(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[  17565691,     491399]*)
(*NotebookOutlinePosition[  17627965,     493063]*)
(*  CellTagsIndexPosition[  17627448,     493042]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "A Tour of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a Calculator"
}], "Section",
  CellTags->"T.1"],

Cell[TextData[{
  "You can use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " just like a calculator: you type in questions, and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints back answers."
}], "Subsection",
  CellTags->"T.1"],

Cell[TextData[{
  "Ask ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " what 3 + 5 is; it prints back 8. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " adds the In and Out labels; you do not type them. You end each line with \
",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]",
    FontSize->12,
    FontSlant->"Plain"],
  "."
}], "Commentary",
  CellTags->"T.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(3 + 5\)], "Input",
  CellTags->"T.1"],

Cell[BoxData[
    \(8\)], "Output",
  CellTags->"T.1"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["^", "MR"],
  " stands for \[OpenCurlyDoubleQuote]to the power \
of\[CloseCurlyDoubleQuote]."
}], "Commentary",
  CellTags->"T.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(57.1^100\)], "Input",
  CellTags->"T.1"],

Cell[BoxData[
    \(4.609043686613962`*^175\)], "Output",
  CellTags->"T.1"]
}, Open  ]],

Cell[TextData[{
  "This asks ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to work out the inverse of a 2 x 2 matrix."
}], "Commentary",
  CellTags->"T.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverse[{{1, 2}, {3, 4}}]\)], "Input",
  CellTags->"T.1"],

Cell[BoxData[
    \({{\(-2\), 1}, {3\/2, \(-\(1\/2\)\)}}\)], "Output",
  CellTags->"T.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can handle formulas as well as numbers."
}], "Subsubsection",
  CellTags->"T.1"],

Cell[TextData[{
  "This asks ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to integrate a simple function."
}], "Commentary",
  CellTags->"T.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Sqrt[x]\ Sqrt[1 + x], x]\)], "Input",
  CellTags->"T.1"],

Cell[BoxData[
    \(1\/4\ \((\@x\ \@\(1 + x\)\ \((1 + 2\ x)\) - ArcSinh[\@x])\)\)], "Output",\

  CellTags->"T.1"]
}, Open  ]],

Cell[TextData[{
  "This asks ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to solve a quadratic equation. The result is a list of rules for x \
convenient for use in other calculations."
}], "Commentary",
  CellTags->"T.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[x^2 + x \[Equal] a, x]\)], "Input",
  CellTags->"T.1"],

Cell[BoxData[
    \({{x \[Rule] 1\/2\ \((\(-1\) - \@\(1 + 4\ a\))\)}, {x \[Rule] 
          1\/2\ \((\(-1\) + \@\(1 + 4\ a\))\)}}\)], "Output",
  CellTags->"T.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can also create two and three-dimensional graphics."
}], "Subsubsection",
  CellTags->"T.1"],

Cell["This creates a 2D plot of a simple function.", "Commentary",
  CellTags->"T.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x] + Sin[1.6  x], {x, 0, 40}]\)], "Input",
  CellTags->"T.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0238095 0.309015 0.148188 [
[.2619 .29651 -6 -9 ]
[.2619 .29651 6 0 ]
[.5 .29651 -6 -9 ]
[.5 .29651 6 0 ]
[.7381 .29651 -6 -9 ]
[.7381 .29651 6 0 ]
[.97619 .29651 -6 -9 ]
[.97619 .29651 6 0 ]
[.01131 .01264 -12 -4.5 ]
[.01131 .01264 0 4.5 ]
[.01131 .16083 -12 -4.5 ]
[.01131 .16083 0 4.5 ]
[.01131 .4572 -6 -4.5 ]
[.01131 .4572 0 4.5 ]
[.01131 .60539 -6 -4.5 ]
[.01131 .60539 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30901 m
.2619 .31526 L
s
[(10)] .2619 .29651 0 1 Mshowa
.5 .30901 m
.5 .31526 L
s
[(20)] .5 .29651 0 1 Mshowa
.7381 .30901 m
.7381 .31526 L
s
[(30)] .7381 .29651 0 1 Mshowa
.97619 .30901 m
.97619 .31526 L
s
[(40)] .97619 .29651 0 1 Mshowa
.125 Mabswid
.07143 .30901 m
.07143 .31276 L
s
.11905 .30901 m
.11905 .31276 L
s
.16667 .30901 m
.16667 .31276 L
s
.21429 .30901 m
.21429 .31276 L
s
.30952 .30901 m
.30952 .31276 L
s
.35714 .30901 m
.35714 .31276 L
s
.40476 .30901 m
.40476 .31276 L
s
.45238 .30901 m
.45238 .31276 L
s
.54762 .30901 m
.54762 .31276 L
s
.59524 .30901 m
.59524 .31276 L
s
.64286 .30901 m
.64286 .31276 L
s
.69048 .30901 m
.69048 .31276 L
s
.78571 .30901 m
.78571 .31276 L
s
.83333 .30901 m
.83333 .31276 L
s
.88095 .30901 m
.88095 .31276 L
s
.92857 .30901 m
.92857 .31276 L
s
.25 Mabswid
0 .30901 m
1 .30901 L
s
.02381 .01264 m
.03006 .01264 L
s
[(-2)] .01131 .01264 1 0 Mshowa
.02381 .16083 m
.03006 .16083 L
s
[(-1)] .01131 .16083 1 0 Mshowa
.02381 .4572 m
.03006 .4572 L
s
[(1)] .01131 .4572 1 0 Mshowa
.02381 .60539 m
.03006 .60539 L
s
[(2)] .01131 .60539 1 0 Mshowa
.125 Mabswid
.02381 .04228 m
.02756 .04228 L
s
.02381 .07191 m
.02756 .07191 L
s
.02381 .10155 m
.02756 .10155 L
s
.02381 .13119 m
.02756 .13119 L
s
.02381 .19046 m
.02756 .19046 L
s
.02381 .2201 m
.02756 .2201 L
s
.02381 .24974 m
.02756 .24974 L
s
.02381 .27938 m
.02756 .27938 L
s
.02381 .33865 m
.02756 .33865 L
s
.02381 .36829 m
.02756 .36829 L
s
.02381 .39793 m
.02756 .39793 L
s
.02381 .42757 m
.02756 .42757 L
s
.02381 .48684 m
.02756 .48684 L
s
.02381 .51648 m
.02756 .51648 L
s
.02381 .54612 m
.02756 .54612 L
s
.02381 .57575 m
.02756 .57575 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.03279 .44763 L
.03793 .51232 L
.04018 .53513 L
.04262 .55554 L
.04394 .5646 L
.04517 .57165 L
.04641 .57748 L
.04758 .5817 L
.0488 .58485 L
.04945 .58597 L
.05015 .58676 L
.05088 .58712 L
.05158 .58702 L
.05288 .58569 L
.05403 .5833 L
.05525 .57952 L
.05641 .57482 L
.05745 .56964 L
.06002 .55339 L
.06244 .53387 L
.07312 .41372 L
.08439 .27361 L
.08903 .22678 L
.09159 .2057 L
.09401 .18925 L
.09538 .18154 L
.09687 .1745 L
.09811 .16973 L
.09948 .16558 L
.10076 .16277 L
.10147 .16167 L
.10213 .16091 L
.10331 .16021 L
.10458 .16038 L
.10575 .16136 L
.107 .16323 L
.10819 .16574 L
.10926 .16861 L
.11189 .1778 L
.11438 .18888 L
.12469 .24779 L
.12899 .27195 L
.13354 .29305 L
.13592 .30147 L
.13718 .30509 L
.13853 .30829 L
.13977 .31058 L
.14091 .31212 L
.14205 .31313 L
Mistroke
.14313 .3136 L
.14438 .31353 L
.14508 .31322 L
.14573 .31276 L
.14692 .31148 L
.14817 .30956 L
.15035 .30491 L
.15274 .29808 L
.16298 .25692 L
.16757 .23838 L
.1701 .22996 L
.17135 .22649 L
.1725 .22374 L
.17356 .22165 L
.17472 .21985 L
.1759 .21863 L
.17714 .21802 L
.1782 .21807 L
.17933 .21873 L
.1804 .21996 L
.18138 .2216 L
.18266 .22452 L
.18387 .22809 L
.18613 .23686 L
.18857 .24935 L
.1912 .26629 L
.20034 .34722 L
.21021 .45117 L
.21544 .49978 L
.21832 .52155 L
.22105 .53784 L
.2223 .54367 L
.22363 .54868 L
.22432 .55079 L
.22509 .55269 L
.22578 .55404 L
.22644 .55496 L
.22767 .55579 L
.2288 .55547 L
.23004 .55392 L
.23135 .55091 L
.2325 .5471 L
.23373 .54182 L
.23594 .5292 L
.23857 .50916 L
.24097 .48646 L
.25179 .34278 L
.26202 .18399 L
.26704 .11556 L
.27173 .06458 L
Mistroke
.27409 .04506 L
.27662 .02924 L
.27807 .02275 L
.27878 .02025 L
.27944 .01834 L
.28067 .01584 L
.28132 .01509 L
.28201 .01472 L
.28326 .01517 L
.28441 .01684 L
.28567 .02007 L
.2863 .02223 L
.287 .02502 L
.28942 .038 L
.29169 .05448 L
.29592 .09534 L
.30046 .15079 L
.31064 .29662 L
.31601 .37097 L
.32171 .43737 L
.32411 .45976 L
.32668 .47965 L
.32816 .48894 L
.32951 .49607 L
.33089 .50193 L
.33217 .50614 L
.33326 .50876 L
.33442 .51061 L
.33571 .51152 L
.33688 .51133 L
.3381 .51011 L
.33879 .50899 L
.33943 .50767 L
.3406 .50459 L
.34184 .50043 L
.34437 .48921 L
.34678 .47564 L
.35128 .44421 L
.36143 .36197 L
.36567 .33035 L
.37019 .30265 L
.3728 .2903 L
.37515 .28168 L
.37629 .27841 L
.37752 .27554 L
.37868 .27347 L
.37975 .27211 L
.38102 .27115 L
.38222 .27089 L
.38329 .27117 L
Mistroke
.38447 .27201 L
.38574 .27352 L
.38709 .27575 L
.38952 .28122 L
.39385 .29458 L
.39862 .31205 L
.40377 .33007 L
.40665 .33821 L
.40803 .3413 L
.4093 .34363 L
.41049 .34531 L
.41175 .34652 L
.41247 .34692 L
.41315 .34712 L
.41443 .34695 L
.41565 .34614 L
.41677 .3448 L
.418 .34268 L
.4193 .33968 L
.42185 .33159 L
.42426 .32126 L
.42878 .29551 L
.43893 .21733 L
.44765 .15007 L
.45003 .13535 L
.45261 .12237 L
.45379 .11757 L
.45504 .11338 L
.4561 .11055 L
.45726 .10828 L
.45853 .10684 L
.45968 .10647 L
.46032 .10667 L
.46101 .10721 L
.46226 .10907 L
.46344 .11186 L
.46468 .11592 L
.46691 .12606 L
.46943 .14188 L
.47179 .16071 L
.47716 .21662 L
.49558 .47279 L
.50056 .53196 L
.50318 .55726 L
.50598 .57866 L
.50737 .58693 L
.50867 .59323 L
.50984 .59761 L
.51111 .60097 L
.51231 .60282 L
Mistroke
.51358 .60332 L
.51467 .60256 L
.51586 .60048 L
.5171 .5969 L
.51828 .59222 L
.52049 .58012 L
.52287 .56245 L
.52545 .53819 L
.53439 .42217 L
.54461 .26319 L
.54962 .19144 L
.5542 .13632 L
.5565 .1137 L
.55901 .0934 L
.56154 .07797 L
.56291 .07174 L
.56419 .06734 L
.56488 .06553 L
.56563 .06402 L
.56634 .06301 L
.56699 .06245 L
.56822 .06232 L
.56952 .06351 L
.5702 .06465 L
.57093 .06626 L
.57224 .07018 L
.57379 .07646 L
.57522 .08364 L
.58001 .11685 L
.58511 .16381 L
.59427 .26035 L
.59901 .30731 L
.60412 .34968 L
.60705 .36869 L
.60974 .38229 L
.61231 .39169 L
.6136 .39508 L
.61429 .39652 L
.61502 .39777 L
.61633 .39933 L
.61754 .39999 L
.61885 .3999 L
.61959 .39949 L
.62029 .39888 L
.62154 .39725 L
.62269 .3952 L
.62527 .3888 L
.62755 .3814 L
.63005 .37194 L
.63459 .35265 L
Mistroke
.63985 .33067 L
.64274 .32039 L
.64545 .31266 L
.64669 .3099 L
.64799 .30755 L
.64867 .30658 L
.64942 .3057 L
.65074 .3047 L
.65194 .30438 L
.65322 .30469 L
.65443 .30561 L
.65553 .30697 L
.65671 .30898 L
.65782 .31137 L
.66034 .31862 L
.6628 .32791 L
.66545 .34007 L
.67462 .39238 L
.6799 .42239 L
.68278 .43625 L
.68546 .4466 L
.68664 .45021 L
.68775 .45303 L
.68903 .45552 L
.6902 .45702 L
.69149 .45781 L
.69269 .45769 L
.694 .45656 L
.69466 .4556 L
.69539 .45422 L
.69668 .45095 L
.69788 .44696 L
.7006 .43453 L
.703 .41973 L
.70555 .40018 L
.71484 .30208 L
.72573 .16389 L
.7305 .10981 L
.73321 .08384 L
.73573 .06364 L
.73816 .04842 L
.73952 .04185 L
.74075 .03717 L
.74206 .03361 L
.74279 .03225 L
.74347 .0314 L
.74472 .03091 L
.74535 .03119 L
.74605 .0319 L
.74679 .03313 L
Mistroke
.74749 .03476 L
.74882 .03901 L
.75024 .04532 L
.7518 .05422 L
.75459 .07531 L
.75719 .10039 L
.76696 .23158 L
.77737 .3975 L
.78237 .46917 L
.78765 .53008 L
.79041 .55397 L
.79187 .56414 L
.79344 .57304 L
.79488 .57932 L
.79619 .58346 L
.79751 .58606 L
.79877 .58709 L
.79992 .58681 L
.8012 .58514 L
.80184 .58377 L
.80253 .5819 L
.80378 .5775 L
.8062 .56541 L
.80842 .55043 L
.81354 .50378 L
.81893 .44128 L
.82846 .31979 L
.83371 .25934 L
.83866 .21299 L
.8409 .1964 L
.84327 .18214 L
.84451 .17609 L
.84587 .17057 L
.84713 .16654 L
.84827 .16372 L
.84939 .16177 L
.85045 .16063 L
.85157 .16017 L
.85279 .1605 L
.85385 .16148 L
.85498 .16319 L
.85605 .16542 L
.85702 .16792 L
.86718 .2149 L
.87273 .24801 L
.8779 .27666 L
.88233 .29607 L
.88481 .3041 L
.8859 .3069 L
.88706 .30936 L
Mistroke
.88835 .31143 L
.88954 .31275 L
.89081 .31351 L
.89154 .31365 L
.89222 .31357 L
.89345 .31297 L
.89458 .3119 L
.89581 .31017 L
.89711 .30776 L
.90678 .27506 L
.91209 .25217 L
.9147 .24165 L
.9171 .23309 L
.91933 .22653 L
.92051 .22371 L
.92178 .22126 L
.92305 .21945 L
.92424 .21839 L
.92494 .21807 L
.9256 .21797 L
.92684 .21837 L
.92791 .21933 L
.92904 .22099 L
.93011 .22317 L
.93108 .22567 L
.93345 .23395 L
.93569 .2445 L
.94034 .27463 L
.94525 .31672 L
.95403 .40744 L
.95898 .4589 L
.96428 .50655 L
.96685 .52505 L
.96928 .53896 L
.97146 .54811 L
.97269 .55176 L
.97382 .55412 L
.97497 .55547 L
.97619 .55577 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{305, 188.438},
  ImageMargins->{{4, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004a0000_2000`400?l00000o`00003ooooooolb
ooooo`00oooooolbooooo`00oooooolbooooo`003oooool00`00003oooooooooo`3oooooob3ooooo
0006ooooo`Go00001?ooool00`00003oooooooooo`3oooooob3ooooo0007ooooo`04o`000?oooooo
ooooo`0000Cooooo00<00000ooooooooool0oooooolPooooo`001Ol00003ooooo`03o`000?oooooo
oooo00Cooooo0`00003oooooob3ooooo0009ooooo`03o`000?oooooooooo00?ooooo00<00000oooo
ooooool0BOooool2o`000=Cooooo0006ooooo`05o`000?ooooooooooooooool000001?ooool00`00
003oooooooooo`18ooooo`;o000000?oooooo`000?ooool0d_ooool000Kooooo00Go0000oooooooo
ooooooooo`000004ooooo`0300000?oooooooooo04Sooooo00Co0000oooooooooooo0000doooool0
00Oooooo0ol00005ooooo`0300000?oooooooooo04Sooooo00Co0000oooooooooooo0000doooool0
00oooooo00<00000ooooooooool0B?ooool01?l0003oooooooooool0003Cooooo`003oooool00`00
003oooooooooo`18ooooo`04o`000?ooooooooooo`0008Gooooo0ol0001;ooooo`003oooool00`00
003oooooooooo`18ooooo`05o`000?ooooooooooooooool00000Q?ooool00ol0003oooooo`00001;
ooooo`003oooool00`00003oooooooooo`17ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0P_ooool00ol0003oooooo`00001;ooooo`003oooool00`00003o0000ooooo`17ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0P_ooool00ol0003oooooo`00001;ooooo`00
3oooool00`00003oooooooooo`17ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
P_ooool01?l0003oooooooooool0001:ooooo`003oooool00`00003oooooooooo`17ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0POooool01Ol0003ooooooooooooooooo000004[o
oooo000?ooooo`0300000?oooooooooo04Oooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`21ooooo`05o`000?ooooooooooooooool00000B_ooool000oooooo00<00000ooooooooool0
Aoooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo087ooooo00Go0000oooooooooooo
ooooo`00001:ooooo`003oooool00`00003oooooooooo`16ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool0P?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Sooooo
000?ooooo`0300000?oooooooooo04Kooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`1>ooooo`;o0000<?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Sooooo000?
ooooo`0300000?oooooooooo04Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1>
ooooo`03o`000?oooooo000002oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`18
ooooo`003oooool00`00003oooooooooo`16ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0COooool00ol0003oooooo`00000_ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0Aoooool000oooooo00<00000o`000?ooool0A_ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo04cooooo00Co0000oooooooooooo0000;oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo04Oooooo000?ooooo`0300000?oooooooooo04Kooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`1<ooooo`05o`000?ooooooooooooooool00000;_ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo04Oooooo000?ooooo`0300000?oooooooooo04Ko
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1<ooooo`05o`000?oooooooooooooo
ool00000;_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo04Oooooo000?ooooo`03
00000?oooooooooo04Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1<ooooo`05
o`000?ooooooooooooooool00000;_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
04Oooooo000?ooooo`0300000?oooooooooo04Kooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`1<ooooo`05o`000?ooooooooooooooool00000;_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo04Oooooo000?ooooo`0300000?oooooooooo04Kooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0;?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04Kooooo000?ooooo`030000
0?oooooooooo04Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1:ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo04Kooooo000?ooooo`0300000?oooooooooo04Gooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0;?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04Kooooo000?ooooo`0300000?oooooo
oooo04Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1:ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo04Kooooo000?ooooo`0300000?l0003ooooo04Gooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`1:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:_ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo04Kooooo000?ooooo`0300000?oooooooooo04Go
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0/ooooo`;o00007?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`16ooooo`003oooool00`00003oooooooooo`15ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool0;?ooool00ol0003oooooo`00000Kooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool0:_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo04Kooooo
000?ooooo`0300000?oooooooooo04Gooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0/ooooo`03o`000?oooooo000001_ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0Zooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0A_ooool000oooooo00<00000
ooooooooool0AOooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02_ooooo00Co0000
oooooooooooo00006oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02[ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`16ooooo`003oooool00`00003oooooooooo`15
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0:oooool01?l0003oooooooooool0
000Kooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo04Kooooo000?ooooo`0300000?oooooooooo04Gooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`0[ooooo`05o`000?ooooooooooooooool000006_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`15ooooo`003oooool00`00003oooooooooo`15ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool0:_ooool01Ol0003ooooooooooooooooo000001Wooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool0AOooool000oooooo00<00000o`000?ooool0AOooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo04Gooooo000?ooooo`0300000?oooooooooo04Gooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02Sooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`15ooooo`003oooool00`00003oooooooooo`15ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Xooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool0AOooool000oooooo00<00000ooooooooool0
AOooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
:?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo04Gooooo000?ooooo`0300000?oo
oooooooo04Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Xooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo02Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`15ooooo`003oooool0
0`00003oooooooooo`15ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0:?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0AOooool0
00oooooo00<00000ooooooooool0AOooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
02Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
04Gooooo0007ooooo`?o00001Oooool00`00003oooooooooo`14ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Co
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool0AOooool000Sooooo00?o0000ooooooooool01?ooool00`00003ooooo
ooooo`14ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0:?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`0Vooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0AOooool000Go00000ooo
ool00ol0003oooooooooo`04ooooo`<000005?ooool2o`0002kooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0Gooooo`;o0000;?ooool000Sooooo00?o0000ooooooooool01?ooool0
0`00003oooooooooo`0Dooooo`03o`000?oooooo000002gooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooo000002_ooooo0008ooooo`03o`000?oooooooooo
00Cooooo00<00000ooooooooool05?ooool00ol0003oooooo`00000]ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool05Oooool01?l0003oooooooooool0000[ooooo`001oooool2o`00
00Kooooo00<00000ooooooooool04oooool01?l0003oooooooooool0000]ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool05Oooool01?l0003oooooooooool0000[ooooo`002?ooool0
0ol0003oooooooooo`04ooooo`0300000?oooooooooo01?ooooo00Go0000ooooooooooooooooo`00
000/ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool09oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0Vooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool05Oooool01?l0003ooooooooo
ool0000[ooooo`003oooool00`00003oooooooooo`0Cooooo`05o`000?ooooooooooooooool00000
;?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
9_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Gooooo00Go0000oooooooooooo
ooooo`00000Zooooo`003oooool00`00003oooooooooo`0Booooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0:_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02Kooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool09_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Xooooo`003oooool00`00003ooooooooo
o`0Booooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0Cooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool09Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0Xooooo`003oooool00`00003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool0:Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02Kooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool09Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0Xooooo`003oooool00`00003o0000ooooo`0Boooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo02Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Xoooo
o`003oooool00`00003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0:Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02Kooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool09?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Wooooo`003oooool00`00003oooooooooo`0Aooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo02Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo01Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Wooooo`003ooo
ool00`00003oooooooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0:?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool09?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0Wooooo`003oooool00`00003oooooooooo`0Aooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo02Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Wooooo`003oooool00`00
003oooooooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0:?ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool09?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`0Wooooo`003oooool00`00003oooooooooo`0Aooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02Go
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Vooooo`003oooool00`00003ooooo
ooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool09oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool08oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Vooooo`003oooool00`00003oooooooooo`0@ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool03_ooool2o`0001Oooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0Uooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03_ooool2o`0001Kooooo000?
ooooo`0300000?l0003ooooo013ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0<
ooooo`04o`000?ooooooooooo`0001Kooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0Uooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03Oooool01?l0003ooooooooo
ool0000Eooooo`003oooool00`00003oooooooooo`0@ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool03?ooool01?l0003oooooooooool0000Fooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool09?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00cooooo
00Co0000ooooooooool000005Oooool000oooooo00<00000ooooooooool04?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00_ooooo00Go0000ooooooooooooooooo`00000Fooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Sooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00cooooo00@00000ooooooooool000005Oooool000oooooo00<00000oooooooo
ool04?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00_ooooo00Go0000oooooooo
ooooooooo`00000Fooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool09?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Sooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00_ooooo00<00000ooooooooool00_ooool00`00
003oooooooooo`0Booooo`003oooool00`00003oooooooooo`0@ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01?o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo01;o
oooo000?ooooo`0300000?oooooooooo013ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool08_ooool00ol0003ooooo
ooooo`0<ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`0:ooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool04_ooool000oooooo00<0
0000ooooooooool04?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool08oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00cooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00<0
0000ooooooooool01?ooool00`00003oooooooooo`0Aooooo`003oooool00`00003oooooooooo`0@
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0S
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00`00003oooooooooo`04
ooooo`0300000?oooooooooo017ooooo000?ooooo`0300000?l0003ooooo013ooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02?ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool08Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`09ooooo`0300000?oooooooooo00Cooooo00<00000oooo
ooooool04Oooool000oooooo00<00000ooooooooool03oooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Wooooo00<00000ooooooooool01?ooool00`00003oooooooooo`0Aooooo`00
3oooool00`00003oooooooooo`0?ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2Oooool00`00003oooooooooo`04ooooo`0300000?oooooooooo017ooooo000?ooooo`0300000?oo
oooooooo00oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo02;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`09ooooo`0300000?oo
oooooooo00Cooooo00<00000ooooooooool04Oooool000oooooo00<00000ooooooooool03oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool08_ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00<00000ooooooooool01_ooool0
0`00003oooooooooo`0@ooooo`003oooool00`00003oooooooooo`0?ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
027ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool01oooool00`00003oooooooooo`06ooooo`0300000?oooooooooo
013ooooo000?ooooo`0300000?oooooooooo00oooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool03Oooool4o`0000?o
oooo0_l00009ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool02oooool5o`0000?o
oooo0_l00009ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool08Oooool4o`0000Co
oooo0_l00006ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`07ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool00oooool3o`0000?o
oooo0_l00005ooooo`003oooool00`00003oooooooooo`0?ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00kooooo
00?o0000ooooool000000_ooool01?l0003oooooooooool00008ooooo`03o`000?oooooooooo01;o
oooo0ol0000=ooooo`03o`000?oooooooooo00_ooooo0_l00002ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
027ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Gooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Kooooo00<0
0000ooooooooool01oooool00`00003oooooooooo`04ooooo`05o`000?ooooooooooooooool00000
0_ooool00ol0003oooooooooo`02ooooo`003oooool00`00003oooooooooo`0?ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooool000000_ooool01?l0003oooooooooool00009ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooool000003Oooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooo000000Cooooo00Co0000oooooooooooo00002?ooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo027ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooooooo
o`0000Gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Kooooo00<00000ooooooooool01oooool01000003oooooooooooooool5o`0000;ooooo00Co
0000oooooooooooo00001?ooool000oooooo00<00000o`000?ooool03oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00002Oooool00ol0003ooooo
ooooo`0@ooooo`04o`000?ooooooooooo`0000gooooo00?o0000ooooooooool02oooool01?l0003o
ooooooooool00003ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`0Qooooo`04o`000?oooooo0000o`0000?ooooo00Co0000oooooooooooo0000
1Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
1_ooool00`00003oooooooooo`07ooooo`0500000?ooooooooooooooool000000_ooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool00_ooool000oooooo00<00000oooooooo
ool03oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooo
oooo00002Oooool00ol0003oooooooooo`0@ooooo`05o`000?ooooooooooooooool000003?ooool0
0ol0003oooooooooo`0;ooooo`;o00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Pooooo`03o`000?oo
oooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`04ooooo`030000
0?oooooooooo00Sooooo00<00000ooooooooool00_ooool00ol0003oooooo`000003ooooo`04o`00
0?ooooooooooo`0000Cooooo000?ooooo`0300000?oooooooooo00oooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
3Oooool2o`000005ooooool0003oooooooooool000000_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo013ooooo00Go0000ooooooooooooooooo`00000;ooooo`03o`000?oooooooooo
00cooooo0_l00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01oooooo0_l00003ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool01?ooool00`00003oooooooooo`08ooooo`0300000?oo
oooooooo00?ooooo0_l00003ooooo`04o`000?ooooooooooo`0000Cooooo000?ooooo`0300000?oo
oooooooo00oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool03Oooool00ol0003oooooo`000003ooooo`;o00002_oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0=ooooo`?o00001?ooool2o`0000Wooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`0Oooooo`03o`000?oooooo000000;o00001?ooool2o`0000Kooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00<0
0000ooooooooool02?ooool00`00003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo0_l0
0005ooooo`003oooool00`00003oooooooooo`0?ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00oooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00;ooooo00<00000
ooooooooool02Oooool00`00003oooooooooo`0@ooooo`003oooool00`00003oooooooooo`0?oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Ooooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo00;ooooo00<00000ooooooooool02Oooool00`00003oooooooooo`0@oooo
o`003oooool00`00003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00;ooooo00<00000oooooooo
ool02_ooool00`00003oooooooooo`0?ooooo`003oooool00`00003oooooooooo`0>ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo00gooooo00Go0000oooooooooooooooo0000000=ooooo`0300000?oooooooooo00oo
oooo000?ooooo`0300000?oooooooooo00kooooo00?o0000ooooooooool03_ooool01Ol0003ooooo
oooooooooooo000000cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03
o`000?oooooooooo00cooooo0ol0000@ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooooooo000000gooooo00<00000oooo
ooooool03oooool000Sooooo1`0000000ol0000000000000000>00000003o`0000000000000000h0
000000Co000000000000003o00003@0000000ol0000000000000000?00000003o`00000000000000
00d0000000?o00000000000000003P0000000ol0000000000000000500000003o`00000000000000
00H0000000?o00000000000000003P0000000ol0000000000000000>00000003o`00000000000000
00h0000000?o00000000000000002`0000001?l00000000000000?l0000@00000003o`0000000000
000000h0000000?o00000000000000003P0000000ol0000000000000000>000000;o000000<00000
o`00000000007P00000000oooooo00?o0000ooooooooool02oooool01?l0003oooooooooool0000:
ooooo`03o`000?oooooooooo00Cooooo0ol00004ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`03o`000?ooool0000000gooooo00?o0000
ooooooooool02oooool01?l0003oooooooooool00008ooooo`03o`000?oooooo000000Gooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00<0
0000ooooooooool02Oooool00ol0003oooooo`00000=ooooo`;o00003?ooool2o`0000;ooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00<0
0000ooooooooool01oooool01Ol0003ooooooooooooooooo000000cooooo0_l0000=ooooo`03o`00
0?oooooooooo00;o00002Oooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo00Kooooo
00<00000ooooooooool01_ooool000oooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo00oooooo00?o0000ooooo`0000003Oooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool02Oooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo00_ooooo00Go0000ooooooooooooooooo`00000?ooooo`03o`00
0?oooooooooo00Cooooo00<00000ooooooooool02?ooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo01oooooo00<00000ooooooooool01_ooool00`00003oooooooooo`06ooooo`003ooo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`0Oooooo`0300000?oooooooooo00oooooo000?ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo01oooooo00<00000ooooooooool03oooool000oooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0Oooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool07oooool00`00
003oooooooooo`0?ooooo`003oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo023o
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00go
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Oooooo`0300000?oooooooooo00oo
oooo000?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool08?ooool00ol0003ooooo
ooooo`0=ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`0=ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`0=ooooo`03o`000?oooooooooo023ooooo00<00000ooooooooool03_ooool000oooooo00<0
0000o`000?ooool03_ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00gooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Wooooo00Go
0000ooooooooooooooooo`00000Cooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0
8?ooool00`00003oooooooooo`0>ooooo`003oooool00`00003o0000ooooo`0>ooooo`03o`000?oo
oooooooo023ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool02_ooool01?l0003oooooooooool0000Cooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool08?ooool00`00003oooooooooo`0>ooooo`003ooo
ool00`00003o0000ooooo`0>ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02_oo
ool01?l0003oooooo`000?l0000Cooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
8Oooool00`00003oooooooooo`0>ooooo`003oooool00`00003o0000ooooo`0=ooooo`03o`000?oo
oooooooo027ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool03?ooool2o`0001Cooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Qooooo`0300000?oooooooooo00kooooo000?ooooo`0300000?l0003o
oooo00gooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool08Oooool00`00003oooooooooo`0>ooooo`003oooool00`00
003o0000ooooo`0=ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool03Oooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool08_ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo027ooooo00<00000ooooooooool03_ooool000oo
oooo00<00000o`000?ooool03Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00go
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Qooooo`0300000?oooooooooo00ko
oooo000?ooooo`0300000?l0003ooooo00gooooo00?o0000ooooooooool08Oooool00ol0003ooooo
ooooo`0=ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool08Oooool00`00003ooooo
ooooo`0>ooooo`003oooool00`00003o0000ooooo`0=ooooo`03o`000?oooooooooo027ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool08_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02;ooooo00<0
0000ooooooooool03Oooool000oooooo00<00000o`000?ooool03Oooool00ol0003oooooooooo`0R
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0R
ooooo`0300000?oooooooooo00gooooo000?ooooo`0300000?l0003ooooo00gooooo00?o0000oooo
ooooool08_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool08_ooool00`00003oooooooooo`0=ooooo`003oooool00`00003o0000ooooo`0=ooooo`03
o`000?oooooooooo02;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0@ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo02;ooooo00<00000ooooooooool03Oooool000oooooo00<00000o`000?ooool0
3Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Rooooo`0300000?oooooooooo00gooooo000?ooooo`0300000?oo
oooo000000gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Tooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool08_ooool00`00003oooooooooo`0=ooooo`003oooool0
0`00003oooooo`00000=ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool09?ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02?ooooo00<00000ooooooooool03Oooool0
00oooooo00<00000ooooool000003Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo
02Cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Cooooo`05o`000?oooooooooo
ooooool000003Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0Sooooo`0300000?oooooooooo00gooooo000?oooo
o`0300000?oooooo000000gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Toooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04oooool01Ol0003ooooooooooooooooo
000000gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool08oooool00`00003oooooooooo`0=ooooo`003oooool00`00
003oooooo`00000<ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool09?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo01?ooooo00Co0000oooooooooooo00003_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0Tooooo`0300000?oooooooooo00cooooo000?ooooo`0300000?l0003o0000
00cooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool05Oooool3o`0000kooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool09?ooool00`00
003oooooooooo`0<ooooo`003oooool00`00003oooooo`00000<ooooo`03o`000?oooooooooo02Co
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Ko
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Tooooo`0300000?oooooooooo00co
oooo000?ooooo`0300000?oooooo000000cooooo00?o0000ooooooooool09?ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0Uooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool09oooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0Tooooo`0300000?oooooooooo00cooooo000?ooooo`0300000?oooooo000000cooooo00?o
0000ooooooooool09?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool09oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0Tooooo`0300000?oooooooooo00cooooo000?
ooooo`0300000?oooooo000000cooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0V
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0T
ooooo`0300000?oooooooooo00cooooo000?ooooo`0300000?oooooo000000cooooo00?o0000oooo
ooooool09?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool09oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0Tooooo`0300000?oooooooooo00cooooo000?ooooo`03
00000?oooooo000000cooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Vooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Tooooo`03
00000?oooooooooo00cooooo000?ooooo`0300000?oooooo000000cooooo00?o0000ooooooooool0
9?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
:?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0Tooooo`0300000?oooooooooo00cooooo000?ooooo`0300000?oo
oooo000000cooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo01?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Vooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Uooooo`0300000?oo
oooooooo00cooooo000?ooooo`0400000?l0003oooooo`0000_ooooo00?o0000ooooooooool09?oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0:?oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0Uooooo`0300000?oooooooooo00cooooo000?ooooo`0400000?oooooo
ooooo`0000_ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo01?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Vooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo01Cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Uooooo`0300000?oo
oooooooo00cooooo000?ooooo`0400000?ooooooooooo`0000_ooooo00?o0000ooooooooool09?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0:Ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0Vooooo`0300000?oooooooooo00_ooooo000?ooooo`0400000?oooooo
ooooo`0000[ooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo01Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo01Gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Vooooo`0300000?oo
oooooooo00_ooooo000?ooooo`0400000?ooooooooooo`0000[ooooo00?o0000ooooooooool09_oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0:_oo
ool01Ol0003ooooooooooooooooo000001Oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0Vooooo`0300000?oooooooooo00_ooooo000?ooooo`0400000?ooooooooooo`0000[ooooo
00?o0000ooooooooool09_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool0:oooool01?l0003oooooooooool0000Hooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool09_ooool00`00003oooooooooo`0;ooooo`001oooool3o`0000Gooooo
00@00000oooooooooooo00002_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02Oo
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0[ooooo`04o`000?ooooooooooo`00
01Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Vooooo`0300000?oooooooooo
00_ooooo0008ooooo`03o`000?oooooooooo00Cooooo00@00000oooooooooooo00002_ooool00ol0
003oooooooooo`0Vooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool05Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0[ooooo`04o`000?ooooooooooo`0001Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Vooooo`0300000?oooooooooo00_ooooo0008ooooo`03o`000?oooooooooo
00Cooooo00@00000oooooooooooo00002_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo02Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0/ooooo`?o00006?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo02Kooooo00<00000ooooooooool02oooool0
00Sooooo00?o0000ooooooooool01?ooool300000003o`000?oooooooooo00Sooooo00?o0000oooo
ooooool09_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Gooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool0;?ooool2o`0001Wooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Woooo
o`0300000?oooooooooo00_ooooo0008ooooo`03o`000?oooooooooo00Cooooo00@00000oooooooo
oooo00002_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool05Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02Wooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`17ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool09oooool00`00003oooooooooo`0;ooooo`001oooool2o`0000Kooooo00@00000oooooooo
oooo00002_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool05Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02Wooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`17ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool09oooool00`00003oooooooooo`0;ooooo`002?ooool00ol0003oooooooooo`04ooooo`04
00000?ooooooooooo`0000[ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Yoooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo02Oooooo00<00000ooooooooool02oooool000oooooo00@00000oooooooo
oooo00002_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02Wooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`17ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool0:?ooool00`00003oooooooooo`0:ooooo`003oooool01000003oooooooooool00009oooo
o`03o`000?oooooooooo02Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo04Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Xoooo
o`0300000?oooooooooo00[ooooo000?ooooo`0400000?ooooooooooo`0000Wooooo00?o0000oooo
ooooool0:?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Oooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool0Aoooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo02Sooooo00<00000oooo
ooooool02_ooool000oooooo00D00000ooooooooooooooooo`000008ooooo`03o`000?oooooooooo
02Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
04Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Xooooo`0300000?oooooooooo
00[ooooo000?ooooo`0500000?l0003oooooooooool000002?ooool00ol0003oooooooooo`0Xoooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo02[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`19oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0:?ooool00`00003oooooooooo`0:oooo
o`003oooool01@00003ooooooooooooooooo000000Sooooo00?o0000ooooooooool0:Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Zooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0BOooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo02Wooooo00<00000ooooooooool02_ooool000oo
oooo00D00000ooooooooooooooooo`000008ooooo`03o`000?oooooooooo02Wooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0:_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo04Wooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0Yooooo`0300000?oooooooooo00[ooooo000?ooooo`05
00000?ooooooooooooooool000002?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool05oooool01Ol0003ooooooooooooooooo000002gooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool0:_ooool00`00003oooooooooo`09ooooo`003oooool01@00003ooooooooooooooooo
000000Sooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo01Oooooo00Go0000ooooooooooooooooo`00000]ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0BOooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02[ooooo00<0
0000ooooooooool02Oooool000oooooo00D00000ooooooooooooooooo`000008ooooo`03o`000?oo
oooooooo02Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Hooooo`04o`000?oo
ooooooooo`0002gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`19ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0:_ooool00`00003oooooooooo`09ooooo`003ooo
ool01@00003ooooooooooooooooo000000Sooooo00?o0000ooooooooool0:Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01Sooooo00Co0000ooooool0003o0000;_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Zooooo`0300000?oooooooooo00Wooooo000?ooooo`0500000?ooooooooooooooool0
00002?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool06Oooool2o`0002oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`19ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0:_ooool00`00003oooooooooo`09ooooo`00
3oooool01@00003ooooooooooooooooo000000Sooooo00?o0000ooooooooool0:_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo01Wooooo0_l0000_ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool0BOooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02[o
oooo00<00000ooooooooool02Oooool000oooooo00D00000o`000?ooooooooooo`000007ooooo`03
o`000?oooooooooo02_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1:ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0B_ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo02[ooooo00<00000ooooooooool02Oooool000oooooo00D00000oooooooooooo
ooooo`000007ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`1:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Boooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo02_ooooo00<00000ooooooooool02?ooool000oooooo
00D00000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo02_ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`1;ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0Boooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02_ooooo00<00000oooooooo
ool02?ooool000oooooo00<00000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo02_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1;ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0Boooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo02_ooooo00<00000ooooooooool02?ooool000oooooo00<00000ooooooooool00_oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`1;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Booo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02cooooo00<00000ooooooooool02?oo
ool000oooooo00<00000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo02_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1;ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool0Boooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo02cooooo00<00000ooooooooool02?ooool000oooooo00<00000ooooooooool00_ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`1;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Boooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo02cooooo00<00000ooooooooool02?ooool000oo
oooo00<00000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02_o
oooo00Go0000ooooooooooooooooo`00001>ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0Boooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02cooooo00<00000oooo
ooooool02?ooool000oooooo00<00000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo02cooooo00Co0000oooooooooooo0000C_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo04cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0/oooo
o`0300000?oooooooooo00Sooooo000?ooooo`0300000?l0003ooooo00;ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0]ooooo`04o`000?ooooooooooo`0004oooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0;Oooool00ol0003oooooooooo`07ooooo`003oooool00`00003oooooooooo`03ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0;Oooool00ol0003oooooo`00001@ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool0C?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo02gooooo00?o0000ooooooooool01oooool000oooooo00<00000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02kooooo0_l0001@ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0C?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo02kooooo00?o0000ooooooooool01_ooool000oooooo00<00000ooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02kooooo0_l0001@ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0C?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo02kooooo00?o0000ooooooooool01_ooool000oooooo00<00000ooooooooool00oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo083ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`1<ooooo`05o`000?ooooooooooooooool00000>_ooool000oooooo00<00000
ooooooooool00oooool01Ol0003ooooooooooooooooo000008?ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`1<ooooo`05o`000?ooooooooooooooool00000>_ooool000oooooo00<0
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000008?ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`1<ooooo`05o`000?ooooooooooooooool00000>_ooool000oooooo
00<00000ooooooooool01?ooool01?l0003oooooooooool00024ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool0C?ooool01Ol0003ooooooooooooooooo000003[ooooo000?ooooo`03
00000?oooooooooo00Cooooo00Co0000oooooooooooo0000Q?ooool01Ol0003ooooooooooooooooo
000004oooooo00Go0000ooooooooooooooooo`00000jooooo`003oooool00`00003o0000ooooo`04
ooooo`04o`000?ooooooooooo`0008Cooooo00Go0000ooooooooooooooooo`00001?ooooo`05o`00
0?ooooooooooooooool00000>_ooool000oooooo00<00000ooooooooool01?ooool00ol0003ooooo
o`000025ooooo`05o`000?ooooooooooooooool00000D?ooool00ol0003oooooo`00000kooooo`00
3oooool00`00003oooooooooo`05ooooo`;o0000QOooool01Ol0003ooooooooooooooooo0000053o
oooo00?o0000ooooool00000>oooool000oooooo00<00000ooooooooool01Oooool00ol0003ooooo
ooooo`24ooooo`04o`000?ooooooooooo`0005;ooooo00?o0000ooooooooool0>_ooool000oooooo
00<00000ooooooooool0S?ooool01?l0003oooooooooool0002?ooooo`003oooool00`00003ooooo
ooooo`2<ooooo`04o`000?ooooooooooo`0008oooooo0006ooooo`Go00001?ooool00`00003ooooo
ooooo`2=ooooo`03o`000?oooooo000008oooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo
00<00000ooooooooool0SOooool3o`0008oooooo0008ooooo`03o`000?oooooooooo00Cooooo0`00
002=ooooo`;o0000T?ooool000Wooooo00?o0000ooooooooool00oooool00`00003oooooooooo`3o
ooooob3ooooo0006ooooo`05o`000?ooooooooooooooool000001?ooool00`00003oooooooooo`3o
ooooob3ooooo0006ooooo`05o`000?ooooooooooooooool000001?ooool00`00003oooooooooo`3o
ooooob3ooooo0007ooooo`?o00001Oooool00`00003oooooooooo`3oooooob3ooooo003ooooooc;o
oooo003ooooooc;ooooo0000\
\>"],
  ImageRangeCache->{{{0, 304}, {187.438, 0}} -> {-2.23171, -2.14139, 0.14221, \
0.0228491}},
  CellTags->"T.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.1"]
}, Open  ]],

Cell["Here is a 3D plot.", "Commentary",
  CellTags->"T.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 4}, {y, 0, 4}]\)], "Input",
  CellTags->"T.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.1978e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -5.89944 -9 ]
[.17646 .18758 .10056 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 6 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02411 .26511 -12 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.787 ]
[.01568 .31795 0 6.213 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42928 -18 -2.88162 ]
[-0.00208 .42928 0 6.11838 ]
[-0.01144 .48796 -6 -2.93177 ]
[-0.01144 .48796 0 6.06823 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(2)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(3)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(4)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(2)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(3)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(4)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(-1)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-0.5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .36581 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.5)] -0.00208 .42928 1 -0.35964 Mshowa
.00095 .48364 m
.00714 .48148 L
s
[(1)] -0.01144 .48796 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33498 m
.02819 .33359 L
s
.02277 .34594 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .3556 L
s
.01749 .37928 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40055 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43643 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44679 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .47171 m
.00655 .47041 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.918 .527 .231 r
.38853 .69037 .40169 .70186 .42185 .75936 .40862 .74574 Metetra
.763 .282 0 r
.40862 .74574 .42185 .75936 .44356 .79083 .43028 .77804 Metetra
.678 .745 .901 r
.43028 .77804 .44356 .79083 .46666 .77805 .45342 .7701 Metetra
.906 .787 .718 r
.45342 .7701 .46666 .77805 .49027 .72397 .47727 .72241 Metetra
.951 .802 .66 r
.47727 .72241 .49027 .72397 .51352 .65099 .50092 .65297 Metetra
.966 .831 .658 r
.50092 .65297 .51352 .65099 .53612 .5881 .52394 .58745 Metetra
.941 .88 .746 r
.52394 .58745 .53612 .5881 .55848 .55781 .54653 .54792 Metetra
.54 .748 .972 r
.54653 .54792 .55848 .55781 .58141 .56912 .56936 .5459 Metetra
0 .001 .576 r
.56936 .5459 .58141 .56912 .6056 .61561 .59317 .57997 Metetra
0 0 .455 r
.59317 .57997 .6056 .61561 .63115 .67659 .61834 .636 Metetra
0 0 .552 r
.61834 .636 .63115 .67659 .65731 .72299 .64453 .69012 Metetra
.194 .3 .745 r
.64453 .69012 .65731 .72299 .68266 .72981 .67067 .71683 Metetra
.764 .781 .867 r
.67067 .71683 .68266 .72981 .70604 .69016 .69546 .70096 Metetra
.951 .929 .581 r
.69546 .70096 .70604 .69016 .72735 .61975 .71818 .64636 Metetra
.781 .786 .288 r
.71818 .64636 .72735 .61975 .74782 .54729 .73929 .5737 Metetra
.73929 .5737 .74782 .54729 .76938 .49985 .76023 .50939 Metetra
.773 .924 .555 r
.76023 .50939 .76938 .49985 .79383 .49283 .78282 .47446 Metetra
.48 .59 .886 r
.78282 .47446 .79383 .49283 .8221 .52639 .80856 .4785 Metetra
.247 .269 .687 r
.80856 .4785 .8221 .52639 .85366 .58531 .83801 .51787 Metetra
.233 .223 .641 r
.83801 .51787 .85366 .58531 .8863 .64242 .87036 .57624 Metetra
.28 .259 .656 r
.87036 .57624 .8863 .64242 .9167 .6684 .9033 .62824 Metetra
.405 .406 .747 r
.9033 .62824 .9167 .6684 .94218 .64688 .93372 .64856 Metetra
.756 .99 .78 r
.93372 .64856 .94218 .64688 .96245 .58459 .95925 .62443 Metetra
0 0 .216 r
.95925 .62443 .96245 .58459 .98 .5072 .97979 .56318 Metetra
.915 .517 .214 r
.37517 .67871 .38853 .69037 .40862 .74574 .39522 .73188 Metetra
.77 .292 0 r
.39522 .73188 .40862 .74574 .43028 .77804 .41681 .76475 Metetra
.597 .717 .928 r
.41681 .76475 .43028 .77804 .45342 .7701 .43996 .7613 Metetra
.892 .79 .741 r
.43996 .7613 .45342 .7701 .47727 .72241 .46399 .72009 Metetra
.947 .805 .671 r
.46399 .72009 .47727 .72241 .50092 .65297 .48803 .6551 Metetra
.967 .832 .657 r
.48803 .6551 .50092 .65297 .52394 .58745 .51148 .58857 Metetra
.958 .875 .712 r
.51148 .58857 .52394 .58745 .54653 .54792 .53439 .54146 Metetra
.779 .871 .916 r
.53439 .54146 .54653 .54792 .56936 .5459 .55725 .52689 Metetra
0 .259 .769 r
.55725 .52689 .56936 .5459 .59317 .57997 .58078 .54741 Metetra
0 0 .52 r
.58078 .54741 .59317 .57997 .61834 .636 .60552 .59458 Metetra
0 0 .534 r
.60552 .59458 .61834 .636 .64453 .69012 .63149 .65035 Metetra
.026 .15 .658 r
.63149 .65035 .64453 .69012 .67067 .71683 .65803 .69165 Metetra
.458 .521 .834 r
.65803 .69165 .67067 .71683 .69546 .70096 .68397 .69908 Metetra
.921 .933 .798 r
.68397 .69908 .69546 .70096 .71818 .64636 .70824 .66641 Metetra
.839 .856 .4 r
.70824 .66641 .71818 .64636 .73929 .5737 .73058 .60406 Metetra
.73058 .60406 .73929 .5737 .76023 .50939 .75176 .53355 Metetra
.75176 .53355 .76023 .50939 .78282 .47446 .7733 .47754 Metetra
.812 .996 .768 r
.7733 .47754 .78282 .47446 .80856 .4785 .79685 .45207 Metetra
.424 .483 .816 r
.79685 .45207 .80856 .4785 .83801 .51787 .82363 .46283 Metetra
.28 .275 .675 r
.82363 .46283 .83801 .51787 .87036 .57624 .85398 .50438 Metetra
.272 .244 .644 r
.85398 .50438 .87036 .57624 .9033 .62824 .88696 .56079 Metetra
.31 .278 .661 r
.88696 .56079 .9033 .62824 .93372 .64856 .9203 .60919 Metetra
.418 .419 .754 r
.9203 .60919 .93372 .64856 .95925 .62443 .95111 .62747 Metetra
.658 .952 .723 r
.95111 .62747 .95925 .62443 .97979 .56318 .9772 .60466 Metetra
.91 .506 .195 r
.36161 .66687 .37517 .67871 .39522 .73188 .38162 .71777 Metetra
.773 .296 0 r
.38162 .71777 .39522 .73188 .41681 .76475 .40315 .75094 Metetra
.497 .673 .943 r
.40315 .75094 .41681 .76475 .43996 .7613 .42628 .75161 Metetra
.874 .792 .767 r
.42628 .75161 .43996 .7613 .46399 .72009 .45046 .71686 Metetra
.941 .809 .686 r
.45046 .71686 .46399 .72009 .48803 .6551 .47482 .6571 Metetra
.966 .833 .661 r
.47482 .6571 .48803 .6551 .51148 .58857 .49872 .59112 Metetra
.967 .871 .69 r
.49872 .59112 .51148 .58857 .53439 .54146 .52201 .53825 Metetra
.886 .903 .835 r
.52201 .53825 .53439 .54146 .55725 .52689 .54502 .5124 Metetra
.326 .568 .927 r
.54502 .5124 .55725 .52689 .58078 .54741 .56839 .51906 Metetra
0 .065 .626 r
.56839 .51906 .58078 .54741 .60552 .59458 .59273 .55454 Metetra
0 0 .552 r
.59273 .55454 .60552 .59458 .63149 .65035 .61833 .60639 Metetra
0 .078 .61 r
.61833 .60639 .63149 .65035 .65803 .69165 .64492 .65574 Metetra
.222 .305 .738 r
.64492 .65574 .65803 .69165 .68397 .69908 .67161 .68271 Metetra
.669 .718 .885 r
.67161 .68271 .68397 .69908 .70824 .66641 .6973 .67435 Metetra
.92 .961 .645 r
.6973 .67435 .70824 .66641 .73058 .60406 .72122 .63092 Metetra
.683 .743 .24 r
.72122 .63092 .73058 .60406 .75176 .53355 .74342 .56581 Metetra
.74342 .56581 .75176 .53355 .7733 .47754 .76486 .49917 Metetra
.76486 .49917 .7733 .47754 .79685 .45207 .787 .44992 Metetra
.807 .98 .896 r
.787 .44992 .79685 .45207 .82363 .46283 .81133 .43041 Metetra
.421 .444 .779 r
.81133 .43041 .82363 .46283 .85398 .50438 .83889 .4441 Metetra
.315 .289 .67 r
.83889 .4441 .85398 .50438 .88696 .56079 .86989 .48511 Metetra
.305 .262 .645 r
.86989 .48511 .88696 .56079 .9203 .60919 .90339 .53897 Metetra
.332 .29 .661 r
.90339 .53897 .9203 .60919 .95111 .62747 .93728 .58551 Metetra
.415 .41 .745 r
.93728 .58551 .95111 .62747 .9772 .60466 .96888 .60512 Metetra
.904 .492 .173 r
.34783 .65485 .36161 .66687 .38162 .71777 .36782 .70341 Metetra
.773 .296 0 r
.36782 .70341 .38162 .71777 .40315 .75094 .3893 .73661 Metetra
.379 .614 .943 r
.3893 .73661 .40315 .75094 .42628 .75161 .41239 .74101 Metetra
.849 .792 .796 r
.41239 .74101 .42628 .75161 .45046 .71686 .43666 .71259 Metetra
.933 .813 .704 r
.43666 .71259 .45046 .71686 .47482 .6571 .4613 .6587 Metetra
.964 .836 .668 r
.4613 .6587 .47482 .6571 .49872 .59112 .48563 .59473 Metetra
.971 .869 .678 r
.48563 .59473 .49872 .59112 .52201 .53825 .50935 .53803 Metetra
.934 .908 .772 r
.50935 .53803 .52201 .53825 .54502 .5124 .53262 .50254 Metetra
.646 .795 .954 r
.53262 .50254 .54502 .5124 .56839 .51906 .55597 .4958 Metetra
.037 .271 .768 r
.55597 .4958 .56839 .51906 .59273 .55454 .58 .51786 Metetra
0 .051 .605 r
.58 .51786 .59273 .55454 .61833 .60639 .60517 .56123 Metetra
0 .063 .599 r
.60517 .56123 .61833 .60639 .64492 .65574 .63151 .61189 Metetra
.1 .187 .668 r
.63151 .61189 .64492 .65574 .67161 .68271 .65853 .65221 Metetra
.378 .439 .798 r
.65853 .65221 .67161 .68271 .6973 .67435 .6853 .66639 Metetra
.814 .88 .893 r
.6853 .66639 .6973 .67435 .72122 .63092 .71082 .64682 Metetra
.796 .882 .455 r
.71082 .64682 .72122 .63092 .74342 .56581 .73458 .59758 Metetra
.73458 .59758 .74342 .56581 .76486 .49917 .75685 .53261 Metetra
.75685 .53261 .76486 .49917 .787 .44992 .77862 .46985 Metetra
.77862 .46985 .787 .44992 .81133 .43041 .80128 .42506 Metetra
.787 .936 .927 r
.80128 .42506 .81133 .43041 .83889 .4441 .82617 .40811 Metetra
.441 .441 .763 r
.82617 .40811 .83889 .4441 .86989 .48511 .85423 .42143 Metetra
.349 .307 .67 r
.85423 .42143 .86989 .48511 .90339 .53897 .88563 .45975 Metetra
.334 .279 .646 r
.88563 .45975 .90339 .53897 .93728 .58551 .91955 .51064 Metetra
.351 .297 .657 r
.91955 .51064 .93728 .58551 .96888 .60512 .95414 .55672 Metetra
.896 .477 .148 r
.33384 .64264 .34783 .65485 .36782 .70341 .35383 .6888 Metetra
.769 .29 0 r
.35383 .6888 .36782 .70341 .3893 .73661 .37525 .72178 Metetra
.252 .541 .924 r
.37525 .72178 .3893 .73661 .41239 .74101 .39829 .72946 Metetra
.815 .789 .828 r
.39829 .72946 .41239 .74101 .43666 .71259 .4226 .70716 Metetra
.922 .817 .725 r
.4226 .70716 .43666 .71259 .4613 .6587 .44747 .65961 Metetra
.96 .84 .68 r
.44747 .65961 .4613 .6587 .48563 .59473 .47219 .59899 Metetra
.973 .87 .673 r
.47219 .59899 .48563 .59473 .50935 .53803 .49636 .54039 Metetra
.957 .907 .729 r
.49636 .54039 .50935 .53803 .53262 .50254 .52 .49722 Metetra
.826 .896 .891 r
.52 .49722 .53262 .50254 .55597 .4958 .54347 .47822 Metetra
.336 .532 .898 r
.54347 .47822 .55597 .4958 .58 .51786 .56732 .48621 Metetra
0 .175 .691 r
.56732 .48621 .58 .51786 .60517 .56123 .59207 .51781 Metetra
0 .094 .62 r
.59207 .51781 .60517 .56123 .63151 .61189 .618 .5637 Metetra
.057 .141 .637 r
.618 .5637 .63151 .61189 .65853 .65221 .64497 .61001 Metetra
.216 .275 .709 r
.64497 .61001 .65853 .65221 .6853 .66639 .67234 .6414 Metetra
.493 .551 .844 r
.67234 .6414 .6853 .66639 .71082 .64682 .6992 .6459 Metetra
.87 .978 .847 r
.6992 .6459 .71082 .64682 .73458 .59758 .7247 .61953 Metetra
.7247 .61953 .73458 .59758 .75685 .53261 .7485 .56809 Metetra
.7485 .56809 .75685 .53261 .77862 .46985 .77097 .50472 Metetra
0 0 .021 r
.77097 .50472 .77862 .46985 .80128 .42506 .79309 .44495 Metetra
.79309 .44495 .80128 .42506 .82617 .40811 .81614 .40214 Metetra
.793 .932 .924 r
.81614 .40214 .82617 .40811 .85423 .42143 .84134 .38465 Metetra
.476 .461 .762 r
.84134 .38465 .85423 .42143 .88563 .45975 .86959 .39474 Metetra
.383 .328 .672 r
.86959 .39474 .88563 .45975 .91955 .51064 .90113 .42837 Metetra
.362 .295 .646 r
.90113 .42837 .91955 .51064 .95414 .55672 .93533 .47553 Metetra
.887 .458 .119 r
.31963 .63024 .33384 .64264 .35383 .6888 .33964 .67394 Metetra
.76 .28 0 r
.33964 .67394 .35383 .6888 .37525 .72178 .36102 .70643 Metetra
.128 .463 .89 r
.36102 .70643 .37525 .72178 .39829 .72946 .38399 .71695 Metetra
.77 .78 .861 r
.38399 .71695 .39829 .72946 .4226 .70716 .40829 .70045 Metetra
.906 .82 .751 r
.40829 .70045 .4226 .70716 .44747 .65961 .43333 .65952 Metetra
.954 .845 .696 r
.43333 .65952 .44747 .65961 .47219 .59899 .4584 .60343 Metetra
.973 .873 .675 r
.4584 .60343 .47219 .59899 .49636 .54039 .48303 .54486 Metetra
.968 .906 .701 r
.48303 .54486 .49636 .54039 .52 .49722 .50709 .49616 Metetra
.909 .929 .814 r
.50709 .49616 .52 .49722 .54347 .47822 .5308 .46657 Metetra
.625 .764 .946 r
.5308 .46657 .54347 .47822 .56732 .48621 .55462 .46086 Metetra
.198 .361 .802 r
.55462 .46086 .56732 .48621 .59207 .51781 .57906 .47878 Metetra
.051 .171 .67 r
.57906 .47878 .59207 .51781 .618 .5637 .60453 .51512 Metetra
.068 .147 .638 r
.60453 .51512 .618 .5637 .64497 .61001 .63116 .56016 Metetra
.154 .205 .663 r
.63116 .56016 .64497 .61001 .67234 .6414 .65866 .60119 Metetra
.299 .34 .737 r
.65866 .60119 .67234 .6414 .6992 .6459 .68637 .62538 Metetra
.568 .638 .881 r
.68637 .62538 .6992 .6459 .7247 .61953 .71341 .62374 Metetra
.828 .995 .756 r
.71341 .62374 .7247 .61953 .7485 .56809 .73907 .59438 Metetra
.73907 .59438 .7485 .56809 .77097 .50472 .7631 .5433 Metetra
0 0 .059 r
.7631 .5433 .77097 .50472 .79309 .44495 .78589 .48214 Metetra
0 0 .078 r
.78589 .48214 .79309 .44495 .81614 .40214 .80834 .42427 Metetra
.80834 .42427 .81614 .40214 .84134 .38465 .83162 .3812 Metetra
.817 .976 .895 r
.83162 .3812 .84134 .38465 .86959 .39474 .85689 .36049 Metetra
.526 .505 .776 r
.85689 .36049 .86959 .39474 .90113 .42837 .88503 .36476 Metetra
.42 .355 .679 r
.88503 .36476 .90113 .42837 .93533 .47553 .91639 .39158 Metetra
.876 .436 .086 r
.3052 .61764 .31963 .63024 .33964 .67394 .32524 .65882 Metetra
.747 .265 0 r
.32524 .65882 .33964 .67394 .36102 .70643 .34659 .69057 Metetra
.018 .388 .848 r
.34659 .69057 .36102 .70643 .38399 .71695 .36948 .70346 Metetra
.71 .762 .892 r
.36948 .70346 .38399 .71695 .40829 .70045 .39375 .69235 Metetra
.884 .821 .781 r
.39375 .69235 .40829 .70045 .43333 .65952 .41888 .65817 Metetra
.945 .85 .717 r
.41888 .65817 .43333 .65952 .4584 .60343 .44424 .60757 Metetra
.971 .877 .684 r
.44424 .60757 .4584 .60343 .48303 .54486 .46931 .55083 Metetra
.973 .907 .687 r
.46931 .55083 .48303 .54486 .50709 .49616 .49384 .49886 Metetra
.945 .937 .754 r
.49384 .49886 .50709 .49616 .5308 .46657 .51791 .46081 Metetra
.814 .898 .901 r
.51791 .46081 .5308 .46657 .55462 .46086 .54185 .44261 Metetra
.452 .593 .902 r
.54185 .44261 .55462 .46086 .57906 .47878 .56612 .4463 Metetra
.187 .3 .749 r
.56612 .4463 .57906 .47878 .60453 .51512 .59118 .46991 Metetra
.124 .197 .668 r
.59118 .46991 .60453 .51512 .63116 .56016 .61733 .50759 Metetra
.152 .195 .653 r
.61733 .50759 .63116 .56016 .65866 .60119 .64458 .55012 Metetra
.226 .252 .68 r
.64458 .55012 .65866 .60119 .68637 .62538 .67258 .58639 Metetra
.352 .382 .753 r
.67258 .58639 .68637 .62538 .71341 .62374 .70067 .60585 Metetra
.6 .689 .905 r
.70067 .60585 .71341 .62374 .73907 .59438 .72804 .60149 Metetra
.731 .957 .667 r
.72804 .60149 .73907 .59438 .7631 .5433 .75405 .57227 Metetra
.75405 .57227 .7631 .5433 .78589 .48214 .77849 .52349 Metetra
0 0 .118 r
.77849 .52349 .78589 .48214 .80834 .42427 .80171 .46499 Metetra
0 0 .138 r
.80171 .46499 .80834 .42427 .83162 .3812 .82448 .40814 Metetra
.82448 .40814 .83162 .3812 .85689 .36049 .84788 .3631 Metetra
.77 .986 .746 r
.84788 .3631 .85689 .36049 .88503 .36476 .87299 .33701 Metetra
.6 .589 .812 r
.87299 .33701 .88503 .36476 .91639 .39158 .9007 .33318 Metetra
.861 .41 .047 r
.29053 .60484 .3052 .61764 .32524 .65882 .31063 .64344 Metetra
.729 .244 0 r
.31063 .64344 .32524 .65882 .34659 .69057 .33196 .6742 Metetra
0 .324 .806 r
.33196 .6742 .34659 .69057 .36948 .70346 .35478 .68899 Metetra
.636 .732 .918 r
.35478 .68899 .36948 .70346 .39375 .69235 .37898 .68279 Metetra
.852 .818 .815 r
.37898 .68279 .39375 .69235 .41888 .65817 .40415 .65528 Metetra
.931 .854 .743 r
.40415 .65528 .41888 .65817 .44424 .60757 .42973 .61091 Metetra
.966 .883 .7 r
.42973 .61091 .44424 .60757 .46931 .55083 .45518 .55762 Metetra
.974 .911 .683 r
.45518 .55762 .46931 .55083 .49384 .49886 .48019 .50466 Metetra
.959 .939 .713 r
.48019 .50466 .49384 .49886 .51791 .46081 .5047 .46058 Metetra
.903 .95 .823 r
.5047 .46058 .51791 .46081 .54185 .44261 .52892 .4318 Metetra
.695 .807 .934 r
.52892 .4318 .54185 .44261 .56612 .4463 .55319 .42189 Metetra
.38 .487 .843 r
.55319 .42189 .56612 .4463 .59118 .46991 .57797 .43129 Metetra
.224 .292 .724 r
.57797 .43129 .59118 .46991 .61733 .50759 .60363 .45727 Metetra
.193 .228 .67 r
.60363 .45727 .61733 .50759 .64458 .55012 .63039 .49411 Metetra
.219 .233 .662 r
.63039 .49411 .64458 .55012 .67258 .58639 .65821 .53365 Metetra
.278 .284 .687 r
.65821 .53365 .67258 .58639 .70067 .60585 .68671 .56642 Metetra
.379 .401 .757 r
.68671 .56642 .70067 .60585 .72804 .60149 .71526 .58369 Metetra
.59 .692 .912 r
.71526 .58369 .72804 .60149 .75405 .57227 .74312 .57966 Metetra
.642 .923 .643 r
.74312 .57966 .75405 .57227 .77849 .52349 .76971 .55326 Metetra
.76971 .55326 .77849 .52349 .80171 .46499 .79478 .50855 Metetra
0 0 .164 r
.79478 .50855 .80171 .46499 .82448 .40814 .81856 .4534 Metetra
0 0 .194 r
.81856 .4534 .82448 .40814 .84788 .3631 .84172 .39737 Metetra
0 0 .112 r
.84172 .39737 .84788 .3631 .87299 .33701 .86518 .34946 Metetra
.86518 .34946 .87299 .33701 .9007 .33318 .88995 .31657 Metetra
.841 .379 .001 r
.27563 .59183 .29053 .60484 .31063 .64344 .2958 .62779 Metetra
.704 .216 0 r
.2958 .62779 .31063 .64344 .33196 .6742 .31714 .65733 Metetra
0 .274 .771 r
.31714 .65733 .33196 .6742 .35478 .68899 .33988 .67353 Metetra
.548 .691 .933 r
.33988 .67353 .35478 .68899 .37898 .68279 .364 .67168 Metetra
.81 .809 .85 r
.364 .67168 .37898 .68279 .40415 .65528 .38915 .6506 Metetra
.911 .856 .775 r
.38915 .6506 .40415 .65528 .42973 .61091 .41487 .61294 Metetra
.957 .89 .723 r
.41487 .61294 .42973 .61091 .45518 .55762 .44065 .56449 Metetra
.971 .917 .69 r
.44065 .56449 .45518 .55762 .48019 .50466 .46612 .51272 Metetra
.962 .941 .69 r
.46612 .51272 .48019 .50466 .5047 .46058 .49112 .4652 Metetra
.935 .964 .751 r
.49112 .4652 .5047 .46058 .52892 .4318 .51572 .42829 Metetra
.848 .934 .882 r
.51572 .42829 .52892 .4318 .55319 .42189 .54017 .40642 Metetra
.608 .711 .918 r
.54017 .40642 .55319 .42189 .57797 .43129 .56484 .40164 Metetra
.374 .443 .803 r
.56484 .40164 .57797 .43129 .60363 .45727 .59013 .41361 Metetra
.274 .305 .713 r
.59013 .41361 .60363 .45727 .63039 .49411 .61635 .4395 Metetra
.254 .259 .672 r
.61635 .4395 .63039 .49411 .65821 .53365 .64366 .47423 Metetra
.272 .262 .665 r
.64366 .47423 .65821 .53365 .68671 .56642 .672 .51085 Metetra
.315 .303 .687 r
.672 .51085 .68671 .56642 .71526 .58369 .70101 .54151 Metetra
.39 .398 .747 r
.70101 .54151 .71526 .58369 .74312 .57966 .73013 .55884 Metetra
.548 .64 .893 r
.73013 .55884 .74312 .57966 .76971 .55326 .75867 .5577 Metetra
.609 .938 .737 r
.75867 .5577 .76971 .55326 .79478 .50855 .78606 .53652 Metetra
.78606 .53652 .79478 .50855 .81856 .4534 .812 .49778 Metetra
.012 0 .192 r
.812 .49778 .81856 .4534 .84172 .39737 .83657 .44734 Metetra
.052 0 .24 r
.83657 .44734 .84172 .39737 .86518 .34946 .86027 .39289 Metetra
.025 0 .21 r
.86027 .39289 .86518 .34946 .88995 .31657 .88386 .34232 Metetra
.816 .34 0 r
.26048 .57861 .27563 .59183 .2958 .62779 .28076 .61187 Metetra
.671 .179 0 r
.28076 .61187 .2958 .62779 .31714 .65733 .30212 .63997 Metetra
0 .242 .747 r
.30212 .63997 .31714 .65733 .33988 .67353 .3248 .65709 Metetra
.454 .64 .937 r
.3248 .65709 .33988 .67353 .364 .67168 .34881 .65898 Metetra
.753 .79 .883 r
.34881 .65898 .364 .67168 .38915 .6506 .37391 .64392 Metetra
.881 .854 .812 r
.37391 .64392 .38915 .6506 .41487 .61294 .39969 .61316 Metetra
.942 .896 .753 r
.39969 .61316 .41487 .61294 .44065 .56449 .42572 .57063 Metetra
.964 .925 .708 r
.42572 .57063 .44065 .56449 .46612 .51272 .45159 .52203 Metetra
.96 .946 .682 r
.45159 .52203 .46612 .51272 .49112 .4652 .47709 .47368 Metetra
.939 .965 .699 r
.47709 .47368 .49112 .4652 .51572 .42829 .50216 .43145 Metetra
.906 .979 .791 r
.50216 .43145 .51572 .42829 .54017 .40642 .52695 .40003 Metetra
.799 .901 .914 r
.52695 .40003 .54017 .40642 .56484 .40164 .55171 .38246 Metetra
.572 .652 .89 r
.55171 .38246 .56484 .40164 .59013 .41361 .5768 .37999 Metetra
.398 .434 .781 r
.5768 .37999 .59013 .41361 .61635 .4395 .60257 .39199 Metetra
.324 .326 .708 r
.60257 .39199 .61635 .4395 .64366 .47423 .62928 .41598 Metetra
.306 .287 .673 r
.62928 .41598 .64366 .47423 .672 .51085 .65707 .44773 Metetra
.315 .285 .665 r
.65707 .44773 .672 .51085 .70101 .54151 .68589 .4816 Metetra
.343 .313 .681 r
.68589 .4816 .70101 .54151 .73013 .55884 .71543 .51118 Metetra
.393 .381 .727 r
.71543 .51118 .73013 .55884 .75867 .5577 .7452 .53023 Metetra
.495 .552 .843 r
.7452 .53023 .75867 .5577 .78606 .53652 .77459 .53398 Metetra
.629 .95 .94 r
.77459 .53398 .78606 .53652 .812 .49778 .80303 .52013 Metetra
.80303 .52013 .812 .49778 .83657 .44734 .83012 .48954 Metetra
.069 0 .194 r
.83012 .48954 .83657 .44734 .86027 .39289 .8558 .44593 Metetra
.122 0 .268 r
.8558 .44593 .86027 .39289 .88386 .34232 .88034 .39508 Metetra
.782 .292 0 r
.24509 .56518 .26048 .57861 .28076 .61187 .26549 .59569 Metetra
.627 .134 0 r
.26549 .59569 .28076 .61187 .30212 .63997 .2869 .62212 Metetra
0 .227 .736 r
.2869 .62212 .30212 .63997 .3248 .65709 .30953 .63968 Metetra
.364 .586 .928 r
.30953 .63968 .3248 .65709 .34881 .65898 .33343 .64465 Metetra
.682 .759 .909 r
.33343 .64465 .34881 .65898 .37391 .64392 .35843 .63505 Metetra
.837 .844 .85 r
.35843 .63505 .37391 .64392 .39969 .61316 .38422 .61112 Metetra
.918 .898 .792 r
.38422 .61112 .39969 .61316 .42572 .57063 .4104 .57525 Metetra
.953 .934 .737 r
.4104 .57525 .42572 .57063 .45159 .52203 .43661 .53147 Metetra
.952 .954 .69 r
.43661 .53147 .45159 .52203 .47709 .47368 .46258 .48476 Metetra
.929 .965 .669 r
.46258 .48476 .47709 .47368 .50216 .43145 .48816 .44016 Metetra
.905 .98 .704 r
.48816 .44016 .50216 .43145 .52695 .40003 .5134 .40216 Metetra
.879 .987 .82 r
.5134 .40216 .52695 .40003 .55171 .38246 .53844 .37422 Metetra
.771 .876 .923 r
.53844 .37422 .55171 .38246 .5768 .37999 .56356 .35855 Metetra
.575 .632 .871 r
.56356 .35855 .5768 .37999 .60257 .39199 .58905 .35599 Metetra
.436 .447 .772 r
.58905 .35599 .60257 .39199 .62928 .41598 .61524 .36597 Metetra
.373 .352 .707 r
.61524 .36597 .62928 .41598 .65707 .44773 .64236 .38658 Metetra
.352 .312 .674 r
.64236 .38658 .65707 .44773 .68589 .4816 .67055 .41454 Metetra
.353 .304 .663 r
.67055 .41454 .68589 .4816 .71543 .51118 .69978 .4455 Metetra
.368 .319 .671 r
.69978 .4455 .71543 .51118 .7452 .53023 .72983 .47435 Metetra
.397 .362 .702 r
.72983 .47435 .7452 .53023 .77459 .53398 .7603 .49591 Metetra
.453 .462 .778 r
.7603 .49591 .77459 .53398 .80303 .52013 .79066 .5057 Metetra
.573 .752 .962 r
.79066 .5057 .80303 .52013 .83012 .48954 .82035 .50083 Metetra
.82035 .50083 .83012 .48954 .8558 .44593 .84891 .48059 Metetra
.094 0 .144 r
.84891 .48059 .8558 .44593 .88034 .39508 .8761 .44665 Metetra
.736 .234 0 r
.22944 .55152 .24509 .56518 .26549 .59569 .25 .57923 Metetra
.571 .078 0 r
.25 .57923 .26549 .59569 .2869 .62212 .27148 .60378 Metetra
0 .228 .738 r
.27148 .60378 .2869 .62212 .30953 .63968 .29409 .62132 Metetra
.288 .535 .913 r
.29409 .62132 .30953 .63968 .33343 .64465 .31788 .62868 Metetra
.601 .716 .925 r
.31788 .62868 .33343 .64465 .35843 .63505 .34276 .62386 Metetra
.779 .82 .885 r
.34276 .62386 .35843 .63505 .38422 .61112 .36848 .60641 Metetra
.881 .892 .835 r
.36848 .60641 .38422 .61112 .4104 .57525 .39474 .57753 Metetra
.933 .94 .778 r
.39474 .57753 .4104 .57525 .43661 .53147 .4212 .53984 Metetra
.94 .964 .716 r
.4212 .53984 .43661 .53147 .46258 .48476 .44757 .49694 Metetra
.914 .968 .662 r
.44757 .49694 .46258 .48476 .48816 .44016 .47366 .45286 Metetra
.877 .967 .642 r
.47366 .45286 .48816 .44016 .5134 .40216 .49941 .41154 Metetra
.86 .982 .694 r
.49941 .41154 .5134 .40216 .53844 .37422 .52489 .37638 Metetra
.855 .994 .829 r
.52489 .37638 .53844 .37422 .56356 .35855 .55024 .35003 Metetra
.77 .878 .925 r
.55024 .35003 .56356 .35855 .58905 .35599 .57571 .33419 Metetra
.603 .646 .866 r
.57571 .33419 .58905 .35599 .61524 .36597 .60158 .32956 Metetra
.482 .474 .773 r
.60158 .32956 .61524 .36597 .64236 .38658 .62812 .33585 Metetra
.421 .382 .71 r
.62812 .33585 .64236 .38658 .67055 .41454 .65556 .35173 Metetra
.395 .338 .676 r
.65556 .35173 .67055 .41454 .69978 .4455 .68403 .3749 Metetra
.388 .322 .661 r
.68403 .3749 .69978 .4455 .72983 .47435 .71358 .40219 Metetra
.393 .325 .661 r
.71358 .40219 .72983 .47435 .7603 .49591 .74406 .42975 Metetra
.407 .347 .677 r
.74406 .42975 .7603 .49591 .79066 .5057 .77518 .45343 Metetra
.434 .398 .719 r
.77518 .45343 .79066 .5057 .82035 .50083 .80652 .46923 Metetra
.489 .526 .822 r
.80652 .46923 .82035 .50083 .84891 .48059 .83758 .47395 Metetra
.541 .875 .991 r
.83758 .47395 .84891 .48059 .8761 .44665 .86787 .46572 Metetra
.675 .161 0 r
.21353 .53764 .22944 .55152 .25 .57923 .23427 .56249 Metetra
0 0 .501 r
.23427 .56249 .25 .57923 .27148 .60378 .25585 .58497 Metetra
0 .245 .752 r
.25585 .58497 .27148 .60378 .29409 .62132 .27846 .60204 Metetra
.233 .494 .898 r
.27846 .60204 .29409 .62132 .31788 .62868 .30217 .61108 Metetra
.519 .666 .928 r
.30217 .61108 .31788 .62868 .34276 .62386 .32691 .61024 Metetra
.705 .782 .912 r
.32691 .61024 .34276 .62386 .36848 .60641 .35253 .59868 Metetra
.827 .871 .878 r
.35253 .59868 .36848 .60641 .39474 .57753 .37878 .57675 Metetra
.899 .938 .829 r
.37878 .57675 .39474 .57753 .4212 .53984 .40539 .54592 Metetra
.921 .975 .76 r
.40539 .54592 .4212 .53984 .44757 .49694 .43207 .50856 Metetra
.895 .976 .68 r
.43207 .50856 .44757 .49694 .47366 .45286 .45862 .46761 Metetra
.841 .955 .612 r
.45862 .46761 .47366 .45286 .49941 .41154 .48491 .42622 Metetra
.796 .942 .59 r
.48491 .42622 .49941 .41154 .52489 .37638 .5109 .38741 Metetra
.792 .964 .651 r
.5109 .38741 .52489 .37638 .55024 .35003 .53668 .3538 Metetra
.824 1 .805 r
.53668 .3538 .55024 .35003 .57571 .33419 .56238 .32747 Metetra
.789 .913 .924 r
.56238 .32747 .57571 .33419 .60158 .32956 .58821 .30984 Metetra
.651 .694 .878 r
.58821 .30984 .60158 .32956 .62812 .33585 .61441 .3016 Metetra
.535 .52 .786 r
.61441 .3016 .62812 .33585 .65556 .35173 .64122 .30277 Metetra
.47 .42 .72 r
.64122 .30277 .65556 .35173 .68403 .3749 .66887 .31262 Metetra
.437 .368 .682 r
.66887 .31262 .68403 .3749 .71358 .40219 .69751 .32971 Metetra
.423 .343 .661 r
.69751 .32971 .71358 .40219 .74406 .42975 .72721 .35194 Metetra
.42 .335 .654 r
.72721 .35194 .74406 .42975 .77518 .45343 .75795 .37663 Metetra
.424 .341 .658 r
.75795 .37663 .77518 .45343 .80652 .46923 .78955 .40069 Metetra
.435 .363 .677 r
.78955 .40069 .80652 .46923 .83758 .47395 .82173 .42087 Metetra
.455 .412 .721 r
.82173 .42087 .83758 .47395 .86787 .46572 .85408 .4341 Metetra
.593 .071 0 r
.19735 .52352 .21353 .53764 .23427 .56249 .2183 .54547 Metetra
0 .071 .584 r
.2183 .54547 .23427 .56249 .25585 .58497 .24002 .56569 Metetra
0 .275 .776 r
.24002 .56569 .25585 .58497 .27846 .60204 .26266 .58185 Metetra
.204 .468 .885 r
.26266 .58185 .27846 .60204 .30217 .61108 .2863 .59188 Metetra
.448 .615 .921 r
.2863 .59188 .30217 .61108 .32691 .61024 .31092 .59414 Metetra
.624 .731 .923 r
.31092 .59414 .32691 .61024 .35253 .59868 .33641 .58767 Metetra
.755 .831 .911 r
.33641 .58767 .35253 .59868 .37878 .57675 .36259 .57227 Metetra
.846 .918 .881 r
.36259 .57227 .37878 .57675 .40539 .54592 .38924 .54856 Metetra
.891 .977 .821 r
.38924 .54856 .40539 .54592 .43207 .50856 .41612 .51788 Metetra
.874 .989 .728 r
.41612 .51788 .43207 .50856 .45862 .46761 .44304 .48216 Metetra
.807 .955 .619 r
.44304 .48216 .45862 .46761 .48491 .42622 .46982 .44368 Metetra
.727 .905 .532 r
.46982 .44368 .48491 .42622 .5109 .38741 .49638 .4048 Metetra
.674 .878 .501 r
.49638 .4048 .5109 .38741 .53668 .3538 .5227 .36784 Metetra
.679 .903 .557 r
.5227 .36784 .53668 .3538 .56238 .32747 .54884 .33483 Metetra
.751 .977 .721 r
.54884 .33483 .56238 .32747 .58821 .30984 .57492 .30744 Metetra
.804 .975 .903 r
.57492 .30744 .58821 .30984 .61441 .3016 .6011 .2869 Metetra
.717 .788 .907 r
.6011 .2869 .61441 .3016 .64122 .30277 .6276 .27398 Metetra
.601 .594 .817 r
.6276 .27398 .64122 .30277 .66887 .31262 .65462 .26894 Metetra
.525 .475 .742 r
.65462 .26894 .66887 .31262 .69751 .32971 .68237 .27156 Metetra
.484 .407 .695 r
.68237 .27156 .69751 .32971 .72721 .35194 .71102 .28113 Metetra
.461 .371 .667 r
.71102 .28113 .72721 .35194 .75795 .37663 .7407 .29645 Metetra
.451 .352 .652 r
.7407 .29645 .75795 .37663 .78955 .40069 .77145 .31586 Metetra
.447 .346 .647 r
.77145 .31586 .78955 .40069 .82173 .42087 .80322 .33733 Metetra
.448 .35 .651 r
.80322 .33733 .82173 .42087 .85408 .4341 .83588 .35851 Metetra
.485 0 0 r
.1809 .50916 .19735 .52352 .2183 .54547 .20209 .52817 Metetra
0 .162 .671 r
.20209 .52817 .2183 .54547 .24002 .56569 .22398 .54595 Metetra
0 .318 .806 r
.22398 .54595 .24002 .56569 .26266 .58185 .24669 .5608 Metetra
.2 .458 .879 r
.24669 .5608 .26266 .58185 .2863 .59188 .2703 .57112 Metetra
.396 .573 .909 r
.2703 .57112 .2863 .59188 .31092 .59414 .29481 .57558 Metetra
.548 .674 .921 r
.29481 .57558 .31092 .59414 .33641 .58767 .32015 .57323 Metetra
.672 .773 .926 r
.32015 .57323 .33641 .58767 .36259 .57227 .34621 .56358 Metetra
.772 .871 .921 r
.34621 .56358 .36259 .57227 .38924 .54856 .37283 .54671 Metetra
.84 .957 .888 r
.37283 .54671 .38924 .54856 .41612 .51788 .39981 .5232 Metetra
.848 .998 .806 r
.39981 .5232 .41612 .51788 .44304 .48216 .42698 .49412 Metetra
.783 .97 .674 r
.42698 .49412 .44304 .48216 .46982 .44368 .45417 .46091 Metetra
.673 .89 .53 r
.45417 .46091 .46982 .44368 .49638 .4048 .48126 .42522 Metetra
.57 .809 .422 r
.48126 .42522 .49638 .4048 .5227 .36784 .50817 .3888 Metetra
.50817 .3888 .5227 .36784 .54884 .33483 .53488 .35338 Metetra
.53488 .35338 .54884 .33483 .57492 .30744 .56144 .32053 Metetra
.581 .862 .535 r
.56144 .32053 .57492 .30744 .6011 .2869 .58794 .2916 Metetra
.727 .983 .775 r
.58794 .2916 .6011 .2869 .6276 .27398 .6145 .26769 Metetra
.782 .934 .931 r
.6145 .26769 .6276 .27398 .65462 .26894 .64128 .24958 Metetra
.691 .728 .878 r
.64128 .24958 .65462 .26894 .68237 .27156 .66848 .23773 Metetra
.598 .565 .788 r
.66848 .23773 .68237 .27156 .71102 .28113 .69626 .2323 Metetra
.54 .469 .724 r
.69626 .2323 .71102 .28113 .7407 .29645 .72481 .23311 Metetra
.507 .413 .684 r
.72481 .23311 .7407 .29645 .77145 .31586 .75427 .23964 Metetra
.487 .381 .659 r
.75427 .23964 .77145 .31586 .80322 .33733 .78474 .25108 Metetra
.476 .363 .645 r
.78474 .25108 .80322 .33733 .83588 .35851 .8163 .26631 Metetra
0 .159 .637 r
.16417 .49456 .1809 .50916 .20209 .52817 .18563 .51057 Metetra
0 .261 .755 r
.18563 .51057 .20209 .52817 .22398 .54595 .20772 .52577 Metetra
.035 .369 .838 r
.20772 .52577 .22398 .54595 .24669 .5608 .23054 .53892 Metetra
.22 .463 .878 r
.23054 .53892 .24669 .5608 .2703 .57112 .25416 .54888 Metetra
.369 .544 .896 r
.25416 .54888 .2703 .57112 .29481 .57558 .27859 .55461 Metetra
.489 .622 .908 r
.27859 .55461 .29481 .57558 .32015 .57323 .30381 .55528 Metetra
.592 .705 .921 r
.30381 .55528 .32015 .57323 .34621 .56358 .32973 .55033 Metetra
.685 .798 .935 r
.32973 .55033 .34621 .56358 .37283 .54671 .35625 .53954 Metetra
.764 .899 .937 r
.35625 .53954 .37283 .54671 .39981 .5232 .38324 .523 Metetra
.805 .98 .897 r
.38324 .523 .39981 .5232 .42698 .49412 .41054 .50115 Metetra
.769 .993 .782 r
.41054 .50115 .42698 .49412 .45417 .46091 .43802 .47472 Metetra
.652 .913 .604 r
.43802 .47472 .45417 .46091 .48126 .42522 .46554 .4447 Metetra
.46554 .4447 .48126 .42522 .50817 .3888 .493 .41223 Metetra
.493 .41223 .50817 .3888 .53488 .35338 .52034 .37852 Metetra
.52034 .37852 .53488 .35338 .56144 .32053 .54754 .34484 Metetra
.54754 .34484 .56144 .32053 .58794 .2916 .5746 .31236 Metetra
.5746 .31236 .58794 .2916 .6145 .26769 .60158 .28216 Metetra
.60158 .28216 .6145 .26769 .64128 .24958 .62858 .25517 Metetra
.65 .951 .732 r
.62858 .25517 .64128 .24958 .66848 .23773 .6557 .23214 Metetra
.774 .952 .932 r
.6557 .23214 .66848 .23773 .69626 .2323 .6831 .21366 Metetra
.71 .752 .885 r
.6831 .21366 .69626 .2323 .72481 .23311 .71091 .20008 Metetra
.626 .59 .793 r
.71091 .20008 .72481 .23311 .75427 .23964 .73931 .19157 Metetra
.57 .492 .728 r
.73931 .19157 .75427 .23964 .78474 .25108 .76843 .1881 Metetra
.536 .434 .686 r
.76843 .1881 .78474 .25108 .8163 .26631 .79841 .18942 Metetra
0 .29 .755 r
.14715 .4797 .16417 .49456 .18563 .51057 .16891 .49268 Metetra
0 .359 .828 r
.16891 .49268 .18563 .51057 .20772 .52577 .19124 .50515 Metetra
.126 .424 .867 r
.19124 .50515 .20772 .52577 .23054 .53892 .21422 .51626 Metetra
.259 .479 .881 r
.21422 .51626 .23054 .53892 .25416 .54888 .2379 .52524 Metetra
.366 .53 .886 r
.2379 .52524 .25416 .54888 .27859 .55461 .2623 .53133 Metetra
.454 .582 .892 r
.2623 .53133 .27859 .55461 .30381 .55528 .28742 .53388 Metetra
.532 .642 .903 r
.28742 .53388 .30381 .55528 .32973 .55033 .3132 .53238 Metetra
.605 .715 .922 r
.3132 .53238 .32973 .55033 .35625 .53954 .3396 .5265 Metetra
.675 .805 .945 r
.3396 .5265 .35625 .53954 .38324 .523 .36651 .51608 Metetra
.733 .905 .955 r
.36651 .51608 .38324 .523 .41054 .50115 .39384 .50117 Metetra
.747 .982 .911 r
.39384 .50117 .41054 .50115 .43802 .47472 .42148 .48203 Metetra
.671 .966 .766 r
.42148 .48203 .43802 .47472 .46554 .4447 .4493 .45909 Metetra
.513 .84 .546 r
.4493 .45909 .46554 .4447 .493 .41223 .47722 .43294 Metetra
.47722 .43294 .493 .41223 .52034 .37852 .50514 .4043 Metetra
.50514 .4043 .52034 .37852 .54754 .34484 .53301 .37397 Metetra
.53301 .37397 .54754 .34484 .5746 .31236 .56078 .34279 Metetra
.56078 .34279 .5746 .31236 .60158 .28216 .58845 .31159 Metetra
.58845 .31159 .60158 .28216 .62858 .25517 .61603 .28117 Metetra
.61603 .28117 .62858 .25517 .6557 .23214 .64359 .2523 Metetra
.64359 .2523 .6557 .23214 .6831 .21366 .67118 .22562 Metetra
.67118 .22562 .6831 .21366 .71091 .20008 .69891 .2017 Metetra
.676 .975 .823 r
.69891 .2017 .71091 .20008 .73931 .19157 .72688 .18099 Metetra
.761 .892 .936 r
.72688 .18099 .73931 .19157 .76843 .1881 .75522 .16385 Metetra
.689 .694 .85 r
.75522 .16385 .76843 .1881 .79841 .18942 .78406 .15049 Metetra
0 .415 .852 r
.12983 .46459 .14715 .4797 .16891 .49268 .15193 .4745 Metetra
.109 .451 .884 r
.15193 .4745 .16891 .49268 .19124 .50515 .17455 .4841 Metetra
.221 .48 .89 r
.17455 .4841 .19124 .50515 .21422 .51626 .19773 .49287 Metetra
.312 .504 .884 r
.19773 .49287 .21422 .51626 .2379 .52524 .22152 .5003 Metetra
.385 .528 .877 r
.22152 .5003 .2379 .52524 .2623 .53133 .24595 .50589 Metetra
.445 .557 .875 r
.24595 .50589 .2623 .53133 .28742 .53388 .27101 .50918 Metetra
.498 .594 .88 r
.27101 .50918 .28742 .53388 .3132 .53238 .2967 .50977 Metetra
.548 .641 .894 r
.2967 .50977 .3132 .53238 .3396 .5265 .32296 .50736 Metetra
.598 .703 .917 r
.32296 .50736 .3396 .5265 .36651 .51608 .34977 .50169 Metetra
.648 .785 .947 r
.34977 .50169 .36651 .51608 .39384 .50117 .37705 .49266 Metetra
.689 .882 .97 r
.37705 .49266 .39384 .50117 .42148 .48203 .40472 .48023 Metetra
.69 .962 .942 r
.40472 .48023 .42148 .48203 .4493 .45909 .43271 .46451 Metetra
.596 .945 .797 r
.43271 .46451 .4493 .45909 .47722 .43294 .46093 .44569 Metetra
.46093 .44569 .47722 .43294 .50514 .4043 .48931 .42408 Metetra
.48931 .42408 .50514 .4043 .53301 .37397 .51777 .40006 Metetra
.51777 .40006 .53301 .37397 .56078 .34279 .54625 .37407 Metetra
.54625 .37407 .56078 .34279 .58845 .31159 .57471 .34662 Metetra
.039 0 .03 r
.57471 .34662 .58845 .31159 .61603 .28117 .60313 .31823 Metetra
.071 0 .066 r
.60313 .31823 .61603 .28117 .64359 .2523 .63148 .28943 Metetra
.084 0 .078 r
.63148 .28943 .64359 .2523 .67118 .22562 .65979 .26077 Metetra
.078 0 .066 r
.65979 .26077 .67118 .22562 .69891 .2017 .68809 .23274 Metetra
.047 0 .023 r
.68809 .23274 .69891 .2017 .72688 .18099 .71641 .20582 Metetra
.71641 .20582 .72688 .18099 .75522 .16385 .74483 .18042 Metetra
.74483 .18042 .75522 .16385 .78406 .15049 .77342 .15693 Metetra
.151 .524 .918 r
.11221 .44921 .12983 .46459 .15193 .4745 .13469 .45601 Metetra
.241 .53 .919 r
.13469 .45601 .15193 .4745 .17455 .4841 .15762 .46264 Metetra
.315 .531 .904 r
.15762 .46264 .17455 .4841 .19773 .49287 .18106 .46879 Metetra
.373 .533 .886 r
.18106 .46879 .19773 .49287 .22152 .5003 .20503 .47418 Metetra
.419 .538 .87 r
.20503 .47418 .22152 .5003 .24595 .50589 .22954 .47849 Metetra
.457 .547 .86 r
.22954 .47849 .24595 .50589 .27101 .50918 .25462 .48144 Metetra
.49 .563 .857 r
.25462 .48144 .27101 .50918 .2967 .50977 .28025 .48276 Metetra
.521 .587 .862 r
.28025 .48276 .2967 .50977 .32296 .50736 .30643 .48222 Metetra
.552 .622 .875 r
.30643 .48222 .32296 .50736 .34977 .50169 .33312 .4796 Metetra
.583 .669 .898 r
.33312 .4796 .34977 .50169 .37705 .49266 .36031 .47477 Metetra
.616 .734 .93 r
.36031 .47477 .37705 .49266 .40472 .48023 .38794 .46759 Metetra
.645 .817 .966 r
.38794 .46759 .40472 .48023 .43271 .46451 .41597 .458 Metetra
.652 .907 .981 r
.41597 .458 .43271 .46451 .46093 .44569 .44434 .44601 Metetra
.589 .945 .907 r
.44434 .44601 .46093 .44569 .48931 .42408 .473 .43164 Metetra
.421 .843 .687 r
.473 .43164 .48931 .42408 .51777 .40006 .50189 .41502 Metetra
.50189 .41502 .51777 .40006 .54625 .37407 .53095 .39628 Metetra
.53095 .39628 .54625 .37407 .57471 .34662 .56014 .37561 Metetra
.048 0 0 r
.56014 .37561 .57471 .34662 .60313 .31823 .5894 .35326 Metetra
.117 0 .052 r
.5894 .35326 .60313 .31823 .63148 .28943 .61871 .32949 Metetra
.162 0 .113 r
.61871 .32949 .63148 .28943 .65979 .26077 .64803 .30459 Metetra
.192 0 .152 r
.64803 .30459 .65979 .26077 .68809 .23274 .67734 .27886 Metetra
.21 0 .176 r
.67734 .27886 .68809 .23274 .71641 .20582 .70665 .25262 Metetra
.218 0 .186 r
.70665 .25262 .71641 .20582 .74483 .18042 .73595 .22618 Metetra
.218 0 .185 r
.73595 .22618 .74483 .18042 .77342 .15693 .76527 .19985 Metetra
.3 .608 .953 r
.09428 .43356 .11221 .44921 .13469 .45601 .11717 .43721 Metetra
.358 .593 .935 r
.11717 .43721 .13469 .45601 .15762 .46264 .14047 .44077 Metetra
.402 .576 .909 r
.14047 .44077 .15762 .46264 .18106 .46879 .16421 .44409 Metetra
.436 .562 .884 r
.16421 .44409 .18106 .46879 .20503 .47418 .18841 .447 Metetra
.462 .553 .863 r
.18841 .447 .20503 .47418 .22954 .47849 .21308 .44935 Metetra
.484 .549 .847 r
.21308 .44935 .22954 .47849 .25462 .48144 .23824 .45099 Metetra
.503 .55 .837 r
.23824 .45099 .25462 .48144 .28025 .48276 .26389 .45176 Metetra
.52 .556 .833 r
.26389 .45176 .28025 .48276 .30643 .48222 .29004 .45153 Metetra
.536 .569 .835 r
.29004 .45153 .30643 .48222 .33312 .4796 .31666 .45015 Metetra
.553 .589 .844 r
.31666 .45015 .33312 .4796 .36031 .47477 .34376 .44751 Metetra
.571 .618 .86 r
.34376 .44751 .36031 .47477 .38794 .46759 .37132 .4435 Metetra
.59 .658 .885 r
.37132 .4435 .38794 .46759 .41597 .458 .39931 .43803 Metetra
.609 .714 .919 r
.39931 .43803 .41597 .458 .44434 .44601 .4277 .43104 Metetra
.625 .787 .959 r
.4277 .43104 .44434 .44601 .473 .43164 .45647 .42247 Metetra
.622 .871 .989 r
.45647 .42247 .473 .43164 .50189 .41502 .48559 .4123 Metetra
.561 .921 .951 r
.48559 .4123 .50189 .41502 .53095 .39628 .51502 .40053 Metetra
.396 .846 .763 r
.51502 .40053 .53095 .39628 .56014 .37561 .54471 .38717 Metetra
.54471 .38717 .56014 .37561 .5894 .35326 .57464 .37227 Metetra
.57464 .37227 .5894 .35326 .61871 .32949 .60478 .35588 Metetra
.105 0 0 r
.60478 .35588 .61871 .32949 .64803 .30459 .63507 .3381 Metetra
.178 0 .055 r
.63507 .3381 .64803 .30459 .67734 .27886 .6655 .31901 Metetra
.226 0 .129 r
.6655 .31901 .67734 .27886 .70665 .25262 .69603 .29875 Metetra
.259 0 .18 r
.69603 .29875 .70665 .25262 .73595 .22618 .72665 .27744 Metetra
.282 0 .215 r
.72665 .27744 .73595 .22618 .76527 .19985 .75733 .25523 Metetra
.424 .669 .963 r
.07603 .41763 .09428 .43356 .11717 .43721 .09936 .4181 Metetra
.457 .64 .935 r
.09936 .4181 .11717 .43721 .14047 .44077 .12307 .41851 Metetra
.48 .613 .905 r
.12307 .41851 .14047 .44077 .16421 .44409 .14717 .41881 Metetra
.497 .59 .878 r
.14717 .41881 .16421 .44409 .18841 .447 .17166 .41891 Metetra
.51 .571 .854 r
.17166 .41891 .18841 .447 .21308 .44935 .19656 .41875 Metetra
.52 .558 .834 r
.19656 .41875 .21308 .44935 .23824 .45099 .22189 .41826 Metetra
.528 .548 .819 r
.22189 .41826 .23824 .45099 .26389 .45176 .24764 .41738 Metetra
.536 .543 .809 r
.24764 .41738 .26389 .45176 .29004 .45153 .27383 .41604 Metetra
.543 .541 .803 r
.27383 .41604 .29004 .45153 .31666 .45015 .30045 .41417 Metetra
.55 .544 .8 r
.30045 .41417 .31666 .45015 .34376 .44751 .3275 .41171 Metetra
.557 .55 .802 r
.3275 .41171 .34376 .44751 .37132 .4435 .35499 .4086 Metetra
.565 .562 .809 r
.35499 .4086 .37132 .4435 .39931 .43803 .38291 .40479 Metetra
.574 .579 .82 r
.38291 .40479 .39931 .43803 .4277 .43104 .41126 .40021 Metetra
.584 .603 .837 r
.41126 .40021 .4277 .43104 .45647 .42247 .44001 .39483 Metetra
.595 .636 .862 r
.44001 .39483 .45647 .42247 .48559 .4123 .46917 .38859 Metetra
.606 .681 .894 r
.46917 .38859 .48559 .4123 .51502 .40053 .49872 .38146 Metetra
.615 .74 .935 r
.49872 .38146 .51502 .40053 .54471 .38717 .52865 .37342 Metetra
.613 .814 .977 r
.52865 .37342 .54471 .38717 .57464 .37227 .55893 .36443 Metetra
.577 .883 .992 r
.55893 .36443 .57464 .37227 .60478 .35588 .58955 .35447 Metetra
.46 .885 .904 r
.58955 .35447 .60478 .35588 .63507 .3381 .62049 .34355 Metetra
.255 .748 .665 r
.62049 .34355 .63507 .3381 .6655 .31901 .65174 .33165 Metetra
.65174 .33165 .6655 .31901 .69603 .29875 .68326 .31877 Metetra
.095 0 0 r
.68326 .31877 .69603 .29875 .72665 .27744 .71504 .30494 Metetra
.188 0 0 r
.71504 .30494 .72665 .27744 .75733 .25523 .74707 .29017 Metetra
.522 .709 .957 r
.05745 .40141 .07603 .41763 .09936 .4181 .08128 .39867 Metetra
.537 .674 .926 r
.08128 .39867 .09936 .4181 .12307 .41851 .10543 .39588 Metetra
.547 .642 .896 r
.10543 .39588 .12307 .41851 .14717 .41881 .12993 .39301 Metetra
.553 .614 .868 r
.12993 .39301 .14717 .41881 .17166 .41891 .15478 .39004 Metetra
.556 .59 .843 r
.15478 .39004 .17166 .41891 .19656 .41875 .17998 .38695 Metetra
.558 .571 .822 r
.17998 .38695 .19656 .41875 .22189 .41826 .20554 .38372 Metetra
.56 .554 .805 r
.20554 .38372 .22189 .41826 .24764 .41738 .23148 .38033 Metetra
.561 .541 .79 r
.23148 .38033 .24764 .41738 .27383 .41604 .25779 .37675 Metetra
.562 .531 .778 r
.25779 .37675 .27383 .41604 .30045 .41417 .28448 .37297 Metetra
.563 .524 .769 r
.28448 .37297 .30045 .41417 .3275 .41171 .31156 .36897 Metetra
.565 .519 .763 r
.31156 .36897 .3275 .41171 .35499 .4086 .33904 .36471 Metetra
.566 .516 .758 r
.33904 .36471 .35499 .4086 .38291 .40479 .36691 .36018 Metetra
.568 .515 .756 r
.36691 .36018 .38291 .40479 .41126 .40021 .39518 .35537 Metetra
.571 .517 .756 r
.39518 .35537 .41126 .40021 .44001 .39483 .42385 .35024 Metetra
.573 .521 .759 r
.42385 .35024 .44001 .39483 .46917 .38859 .45293 .34478 Metetra
.577 .528 .764 r
.45293 .34478 .46917 .38859 .49872 .38146 .48242 .33896 Metetra
.581 .537 .771 r
.48242 .33896 .49872 .38146 .52865 .37342 .51231 .33278 Metetra
.585 .551 .782 r
.51231 .33278 .52865 .37342 .55893 .36443 .54261 .3262 Metetra
.591 .568 .797 r
.54261 .3262 .55893 .36443 .58955 .35447 .57332 .31922 Metetra
.597 .591 .816 r
.57332 .31922 .58955 .35447 .62049 .34355 .60443 .31181 Metetra
.604 .621 .841 r
.60443 .31181 .62049 .34355 .65174 .33165 .63594 .30396 Metetra
.611 .66 .873 r
.63594 .30396 .65174 .33165 .68326 .31877 .66786 .29565 Metetra
.616 .711 .913 r
.66786 .29565 .68326 .31877 .71504 .30494 .70017 .28687 Metetra
.614 .775 .957 r
.70017 .28687 .71504 .30494 .74707 .29017 .73287 .27761 Metetra
.597 .735 .941 r
.03853 .3849 .05745 .40141 .08128 .39867 .06289 .37892 Metetra
.602 .698 .911 r
.06289 .37892 .08128 .39867 .10543 .39588 .08754 .37288 Metetra
.603 .664 .882 r
.08754 .37288 .10543 .39588 .12993 .39301 .11249 .36675 Metetra
.601 .634 .856 r
.11249 .36675 .12993 .39301 .15478 .39004 .13775 .36054 Metetra
.599 .608 .832 r
.13775 .36054 .15478 .39004 .17998 .38695 .1633 .35425 Metetra
.596 .585 .811 r
.1633 .35425 .17998 .38695 .20554 .38372 .18918 .34787 Metetra
.593 .565 .792 r
.18918 .34787 .20554 .38372 .23148 .38033 .21537 .3414 Metetra
.59 .548 .776 r
.21537 .3414 .23148 .38033 .25779 .37675 .24188 .33482 Metetra
.588 .533 .761 r
.24188 .33482 .25779 .37675 .28448 .37297 .26872 .32815 Metetra
.585 .521 .749 r
.26872 .32815 .28448 .37297 .31156 .36897 .2959 .32138 Metetra
.583 .51 .738 r
.2959 .32138 .31156 .36897 .33904 .36471 .32343 .31449 Metetra
.581 .5 .729 r
.32343 .31449 .33904 .36471 .36691 .36018 .35129 .30749 Metetra
.579 .492 .72 r
.35129 .30749 .36691 .36018 .39518 .35537 .37952 .30037 Metetra
.577 .485 .714 r
.37952 .30037 .39518 .35537 .42385 .35024 .4081 .29313 Metetra
.576 .479 .708 r
.4081 .29313 .42385 .35024 .45293 .34478 .43705 .28577 Metetra
.575 .474 .703 r
.43705 .28577 .45293 .34478 .48242 .33896 .46637 .27827 Metetra
.574 .471 .699 r
.46637 .27827 .48242 .33896 .51231 .33278 .49607 .27063 Metetra
.573 .468 .696 r
.49607 .27063 .51231 .33278 .54261 .3262 .52615 .26286 Metetra
.573 .465 .693 r
.52615 .26286 .54261 .3262 .57332 .31922 .55662 .25494 Metetra
.573 .464 .692 r
.55662 .25494 .57332 .31922 .60443 .31181 .58749 .24687 Metetra
.573 .463 .691 r
.58749 .24687 .60443 .31181 .63594 .30396 .61876 .23864 Metetra
.573 .464 .691 r
.61876 .23864 .63594 .30396 .66786 .29565 .65044 .23025 Metetra
.574 .465 .692 r
.65044 .23025 .66786 .29565 .70017 .28687 .68254 .2217 Metetra
.575 .467 .693 r
.68254 .2217 .70017 .28687 .73287 .27761 .71506 .21298 Metetra
.656 .751 .92 r
.01926 .36808 .03853 .3849 .06289 .37892 .0442 .35885 Metetra
.653 .714 .893 r
.0442 .35885 .06289 .37892 .08754 .37288 .0694 .34952 Metetra
.648 .681 .867 r
.0694 .34952 .08754 .37288 .11249 .36675 .09484 .34009 Metetra
.643 .651 .843 r
.09484 .34009 .11249 .36675 .13775 .36054 .12055 .33057 Metetra
.637 .624 .82 r
.12055 .33057 .13775 .36054 .1633 .35425 .14652 .32095 Metetra
.631 .6 .8 r
.14652 .32095 .1633 .35425 .18918 .34787 .17275 .31124 Metetra
.625 .579 .782 r
.17275 .31124 .18918 .34787 .21537 .3414 .19925 .30142 Metetra
.619 .56 .766 r
.19925 .30142 .21537 .3414 .24188 .33482 .22603 .29151 Metetra
.614 .543 .751 r
.22603 .29151 .24188 .33482 .26872 .32815 .25309 .28149 Metetra
.609 .528 .737 r
.25309 .28149 .26872 .32815 .2959 .32138 .28042 .27136 Metetra
.605 .514 .725 r
.28042 .27136 .2959 .32138 .32343 .31449 .30805 .26113 Metetra
.601 .502 .714 r
.30805 .26113 .32343 .31449 .35129 .30749 .33597 .25079 Metetra
.597 .491 .704 r
.33597 .25079 .35129 .30749 .37952 .30037 .36418 .24034 Metetra
.593 .48 .695 r
.36418 .24034 .37952 .30037 .4081 .29313 .3927 .22978 Metetra
.59 .471 .686 r
.3927 .22978 .4081 .29313 .43705 .28577 .42152 .2191 Metetra
.586 .463 .678 r
.42152 .2191 .43705 .28577 .46637 .27827 .45066 .20831 Metetra
.584 .455 .671 r
.45066 .20831 .46637 .27827 .49607 .27063 .48011 .19741 Metetra
.581 .448 .665 r
.48011 .19741 .49607 .27063 .52615 .26286 .50988 .18638 Metetra
.578 .442 .659 r
.50988 .18638 .52615 .26286 .55662 .25494 .53998 .17523 Metetra
.576 .436 .653 r
.53998 .17523 .55662 .25494 .58749 .24687 .57041 .16396 Metetra
.574 .43 .648 r
.57041 .16396 .58749 .24687 .61876 .23864 .60118 .15257 Metetra
.572 .425 .643 r
.60118 .15257 .61876 .23864 .65044 .23025 .63229 .14105 Metetra
.57 .42 .639 r
.63229 .14105 .65044 .23025 .68254 .2217 .66375 .12939 Metetra
.568 .416 .634 r
.66375 .12939 .68254 .2217 .71506 .21298 .69556 .11761 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(2)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(3)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(4)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 233.562},
  ImageMargins->{{30, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jB000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00aP3oool3o`0005L0oooo00370?ooo`03o`00003o
ool0oooo05H0oooo00340?ooo`Go0000E`3oool00<@0oooo00Co00000?ooo`3ooooo0000F03oool0
0<D0oooo00?o00000?ooool00000F03oool00<H0oooo0_l000080?ooo`;o0000CP3oool00<L0oooo
00?o00000?ooo`3oool01@3oool01?l00000oooo0?ooool0001=0?ooo`00c`3oool01?l00000oooo
0?ooool0001=0?ooo`00c`3oool01?l00000oooo0?ooool0001=0?ooo`00c`3oool01?l00000oooo
0?ooool0001=0?ooo`00c`3oool01?l00000oooo0?ooool0001=0?ooo`00bP3oool2000000@0oooo
0_l0001>0?ooo`00a`3oool3o`0000030?ooo`000000oooo05<0oooo00350?ooo`;o0000103oool0
0`00003o00000?ooo`1B0?ooo`00`P3oool3o`0000H0oooo00?o00000?ooool00000DP3oool00;l0
oooo0ol000090?ooo`03o`00003ooooo00000580oooo002m0?ooo`;o00000P3oool00ol00000oooo
0?ooo`070?ooo`04o`00003oool0ooooo`000540oooo002j0?ooo`?o00003P3oool01Ol00000oooo
0?ooo`3ooooo00000500oooo002h0?ooo`;o00004@3oool01Ol00000oooo0?ooo`3ooooo00000500
oooo002E0?ooo`?o00007@3oool3o`0001<0oooo00Ko00000?ooo`3ooooo00000?ooool0001?0?oo
o`00U03oool01Ol00000oooo0?ooo`3ooooo000001X0oooo0_l000030?ooo`03o`00003oool0oooo
0100oooo00?o00000?ooo`3oool00`3oool00ol00000oooo0?ooo`1<0?ooo`00V03oool00ol00000
oooo0?ooo`0E0?ooo`?o0000603oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo04`0
oooo002F0?ooo`;o00005P3oool2o`0001/0oooo00?o00000?ooo`3oool0103oool00ol00000oooo
0?ooo`1;0?ooo`00V03oool00ol00000oooo0?ooo`0@0?ooo`Co00007@3oool00ol00000oooo0?oo
o`030?ooo`03o`00003oool0oooo04/0oooo002D0?ooo`05o`00003oool0oooo0?ooool000003`3o
ool3o`000240oooo00?o00000?ooo`3oool0103oool00ol00000oooo0?ooo`1:0?ooo`00U@3oool3
o`0000h0oooo0_l0000T0?ooo`03o`00003oool0oooo00D0oooo00?o00000?ooo`3oool0B@3oool0
0:<0oooo0ol0000V0?ooo`03o`00003oool0oooo00@0oooo0_l0001;0?ooo`00X@3oool2o`000080
oooo00?o00000?ooo`3oool0903oool00ol00000oooo0?ooo`060?ooo`03o`00003oool0oooo04P0
oooo002N0?ooo`?o0000:`3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo04L0oooo
002L0?ooo`;o0000;P3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo04L0oooo002I
0?ooo`?o0000<03oool00ol00000oooo0?ooo`080?ooo`03o`00003oool0oooo04H0oooo002G0?oo
o`;o00000`3oool00ol00000oooo0?ooo`0]0?ooo`03o`00003oool0oooo00T0oooo00?o00000?oo
o`3oool0A@3oool009@0oooo0ol0000e0?ooo`03o`00003oool0oooo00P0oooo0_l000170?ooo`00
T@3oool3o`0003P0oooo00?o00000?ooo`3oool02P3oool00ol00000oooo0?ooo`140?ooo`00S`3o
ool2o`000080oooo00?o00000?ooo`3oool0=P3oool00ol00000oooo0?ooo`0;0?ooo`03o`00003o
ool0oooo04<0oooo002<0?ooo`?o0000?@3oool00ol00000oooo0?ooo`0;0?ooo`03o`00003oool0
oooo04<0oooo002:0?ooo`;o0000@03oool00ol00000oooo0?ooo`0<0?ooo`03o`00003oool0oooo
0480oooo001W0?ooo`Go00006`3oool3o`000480oooo00?o00000?ooo`3oool03@3oool00ol00000
oooo0?ooo`110?ooo`00J03oool01?l00000oooo0?ooool0000I0?ooo`;o00000`3oool00ol00000
oooo0?ooo`0o0?ooo`03o`00003oool0oooo00d0oooo00?o00000?ooo`3oool0@@3oool006T0oooo
00?o00000?ooo`3oool05P3oool3o`0004L0oooo00?o00000?ooo`3oool0303oool00ol00000oooo
o`0000070?ooo`?o0000>03oool006X0oooo00?o00000?ooo`3oool04`3oool2o`0004X0oooo00?o
00000?ooo`3oool03`3oool00ol00000oooo0?ooo`050?ooo`03o`00003oool0oooo03L0oooo001W
0?ooo`05o`00003oool0oooo0?ooool000004@3oool3o`0000030?ooool00000oooo04T0oooo00?o
00000?ooo`3oool03`3oool00ol00000oooo0?ooo`050?ooo`03o`00003oool0oooo03L0oooo001W
0?ooo`05o`00003oool0oooo0?ooool000003P3oool3o`0004l0oooo00?o00000?ooo`3oool0403o
ool00ol00000oooo0?ooo`040?ooo`03o`00003oool0oooo03L0oooo001X0?ooo`?o00003@3oool2
o`000540oooo0_l0000B0?ooo`03o`00003oool0oooo00@0oooo00?o00000?ooo`3oool0=`3oool0
07D0oooo0ol0001@0?ooo`?o000000?oTFZRo`00003oool04P3oool00ol00000oooo0?ooo`020?oo
o`;o0000>@3oool007<0oooo0_l000030?ooo`03o`00003oool0oooo04X0oooo0ol00004oi5ZXP;o
00004@3oool3o`0000@0oooo00?o00000?ooo`3oool0=`3oool00700oooo0ol0001@0?ooo`;o0000
2?nAJZ800ol00000oooo0?ooo`0A0?ooo`03o`00003oool0oooo03`0oooo001^0?ooo`03o`000000
0000oooo04l0oooo0ol000000onAJj?o0000oi5ZXP07oi5ZXP03o`00003oool0oooo0180oooo00?o
00000?ooo`3oool0>`3oool006/0oooo0ol000000`3oool000000?ooo`1<0?ooo`?o00001?nAJj<0
0ol0003oTFZRoi5ZXP06oi5ZXP03o`00003oool0oooo01<0oooo00?o00000?ooo`3oool0>P3oool0
06P0oooo0ol000050?ooo`030000003oool0oooo04P0oooo0_l00008oi5[X`03o`000?nAJZ;oTFZR
00GoTFZR00?o00000?ooo`3oool04`3oool00ol00000oooo0?ooo`0j0?ooo`00IP3oool2o`000500
oooo0ol000000onBK:Co0000oi5[X`07oi5[X`03o`000?nAJZ;oTFZR00GoTFZR0_l0000E0?ooo`03
o`00003oool0oooo03T0oooo001S0?ooo`Go0000C@3oool3o`0000CoTVbT00?o0000oi5[XonAJj<0
1_nAJj<00ol0003oTFZRoi5ZXP05oi5ZXP;o0000503oool3o`0003X0oooo001Q0?ooo`;o0000C`3o
ool3o`0000OoTVbT00?o0000oi5[XonAJj<01_nAJj<00ol0003oTFZRoi5ZXP05oi5ZXP;o00004P3o
ool2o`000003ok2afOl0003o000003X0oooo000m0?ooo`?o00007P3oool3o`0004h0oooo0ol00000
0onBKZGo0000oi9/Y008oi9/Y003o`000?nAJj?oTF^S00GoTF^S00?o0000oi5ZX_nAJZ801OnAJZ82
o`000100oooo0ol00003ok2af@;o0000>@3oool003h0oooo00?o00000?ooo`3oool06`3oool3o`00
04d0oooo0ol00004oi9^Y@03o`000?nBK:CoTVbT00OoTVbT00?o0000oi5[XonAJj<01_nAJj<00ol0
003oTFZRoi5ZXP04oi5ZXP03o`000?nAJZ;o000000d0oooo0ol000000olg02oo0000ok2af@02ok2a
f@03o`00003ooooo000003P0oooo000n0?ooo`03o`00003oool0oooo01P0oooo0ol000020?ooo`03
o`00003oool0oooo04T0oooo0_l00008oi9^Y@03o`000?nBK:CoTVbT00KoTVbT00?o0000oi5[XonA
Jj<01_nAJj<00ol0003oTFZRoi5ZXP04oi5ZXP03o`000?nAJZ;o000000/0oooo1?l00002ocL0;`07
o`000?n`/MWo/;7Iok2afOl00000ooooo`00000h0?ooo`00?P3oool00ol00000oooo0?ooo`0F0?oo
o`;o0000CP3oool3o`000003oi=_Yol0003oTVjU00OoTVjU00?o0000oi9/Y?nBK:@01_nBK:@00ol0
003oTF^Soi5[X`06oi5[X`03o`000?nAJZ;oTFZR00CoTFZR00?o0000oi5ZX_l000002@3oool5o`00
00?o=`0_00?o0000ok2afOn`/MT00_n`/MT00ol00000ooooo`00000g0?ooo`00?P3oool00ol00000
oooo0?ooo`0C0?ooo`?o0000C@3oool3o`0000CoTfnW00?o0000oi9^YOnBKZD01_nBKZD00ol0003o
TVbToi9/Y006oi9/Y003o`000?nAJj?oTF^S00KoTF^S00?o0000oi5ZX_nAJZ801?nAJZ800ol0003o
TFZRo`0000080?ooo`Co00001?lg02l00ol0003o/;7Iok2af@03ok2af@Co0000=P3oool003d0oooo
0_l0000B0?ooo`?o00000P3oool00ol00000oooo0?ooo`190?ooo`;o00002?nCKjL00ol0003oTVjU
oi9^Y@05oi9^Y@03o`000?nBK:CoTVbT00KoTVbT00?o0000oi5[XonAJj<01_nAJj<00ol0003oTFZR
oi5ZXP04oi5ZXP03o`000?nAJZ;o000000H0oooo1Ol00005ocL0;`03o`000?n`/MWo/;7I00?o/;7I
00Co00000?ooo`3ooooo0000=P3oool003h0oooo00?o00000?ooo`3oool03P3oool2o`0004h0oooo
0ol000000onCLJSo0000oi=_Y`07oi=_Y`03o`000?nBKZGoTVjU00GoTVjU00?o0000oi9/Y?nBK:@0
1onBK:@00ol0003oTF^Soi5[X`06oi5[X`03o`000?nAJZ;oTFZR00?oTFZR00Co0000oi5ZX_nAJZ;o
00000`3oool6o`0000Ko=`0_00?o0000ok2afOn`/MT01?n`/MT01?l00000oooo0?ooool0000e0?oo
o`00C03oool3o`0004d0oooo0ol00004oi=aZ003o`000?nCKjOoTfnW00KoTfnW00?o0000oi9^YOnB
KZD01_nBKZD00ol0003oTVbToi9/Y006oi9/Y003o`000?nAJj?oTF^S00KoTF^S00?o0000oi5ZX_nA
JZ800onAJZ801?l0003oTFZRoi5ZX_l000020?ooo`03o`000?l<00Go000000Co00001_lg02l00ol0
003o/;7Iok2af@04ok2af@04o`00003oool0ooooo`0003D0oooo001:0?ooo`;o000000<0ooooo`00
0?l00000B`3oool2o`0000OoTg6X00?o0000oi=_YonCKjL01_nCKjL00ol0003oTVjUoi9^Y@06oi9^
Y@03o`000?nBK:CoTVbT00KoTVbT00?o0000oi5[XonAJj<01_nAJj<00ol0003oTFZRoi5ZXP03oi5Z
XP07o`000?nAJZ;oTFZRo`00003ooooo0000o``01@04o`000003ocL0;ol0003o=`0_00Go=`0_1Ol0
0002ok2af@05o`00003oool0oooo0?ooool00000=03oool004L0oooo0ol0001=0?ooo`?o000000?o
U7:Zo`000?nCLJP01onCLJP00ol0003oTfnWoi=_Y`05oi=_Y`03o`000?nBKZGoTVjU00KoTVjU00?o
0000oi9/Y?nBK:@01_nBK:@00ol0003oTF^Soi5[X`06oi5[X`03o`000?nAJZ;oTFZR00?oTFZR00?o
0000oi5ZX_nAJZ800_l00002o``01@?o00000_lg02l00ol0003o=`0_ocL0;`03ocL0;`;o00001?n9
Kjl4o`0000<0oooo00?o00000?ooo`3oool0<@3oool004D0oooo0_l0001=0?ooo`?o00001?nDLZX0
0ol0003oTg6Xoi=aZ006oi=aZ003o`000?nCKjOoTfnW00KoTfnW00?o0000oi9^YOnBKZD01OnBKZD0
0ol0003oTVbToi9/Y006oi9/Y003o`000?nAJj?oTF^S00KoTF^S00?o0000oi5ZX_nAJZ800onAJZ80
1_l0003oTFZRoi5ZX_nAJZ;o0000o``01@?o00000_lg02l00ol0003o=`0_ocL0;`04ocL0;`;o0000
1on9Kjl00ol00000oooo0?ooo`02o`0003<0oooo00120?ooo`Co0000C03oool2o`0000SoU7:Z00?o
0000oi=aZ?nCLJP01OnCLJP00ol0003oTfnWoi=_Y`06oi=_Y`03o`000?nBKZGoTVjU00KoTVjU00?o
0000oi9/Y?nBK:@01OnBK:@00ol0003oTF^Soi5[X`07oi5[X`03o`000?nAJZ;oTFZR00;oTFZR00Ko
0000oi5ZX_nAJZ;oTFZRo`000?l<00D2o`0000?o=`0_00?o0000ocL0;olg02l00olg02l2o`000003
oi5m^_l0003oRFn_00GoRFn_00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`0`0?ooo`00
@03oool2o`0000@0oooo00?o00000?ooo`3oool0AP3oool3o`000003oiEdZol0003oU7:Z00OoU7:Z
00?o0000oi=aZ?nCLJP01OnCLJP00ol0003oTfnWoi=_Y`06oi=_Y`03o`000?nBKZGoTVjU00KoTVjU
00?o0000oi9/Y?nBK:@01_nBK:@00ol0003oTF^Soi5[X`06oi5[X`03o`000?nAJZ;oTFZR00;oTFZR
00Oo0000oi5ZX_nAJZ;oTFZRo`000?l<00Go000000Co=`0_00?o0000ocL0;olg02l00_lg02l01Ol0
003oB00go`000?nAOK[o000000OoRFn_00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`0_
0?ooo`00?@3oool3o`0004`0oooo0ol00004oiEdZ`03o`000?nDLZ[oU7:Z00KoU7:Z00?o0000oi=a
Z?nCLJP01OnCLJP00ol0003oTfnWoi=_Y`06oi=_Y`03o`000?nBKZGoTVjU00KoTVjU00?o0000oi9/
Y?nBK:@01_nBK:@00ol0003oTF^Soi5[X`06oi5[X`03o`000?nAJZ;oTFZR00;oTFZR00Co0000oi5Z
X_nAJZ;oTFZR0_l00005ocL0;`05o`000?lg02oo=`0_ocL0;ol000000_m803L00ol0003oTGfjo`00
0007ohU_[`03o`00003oool0oooo0080oooo00?o00000?ooo`3oool0;`3oool003X0oooo1?l0001<
0?ooo`;o00002?nEM:/00ol0003oU7:ZoiAbZP05oiAbZP03o`000?nCLJSoTg6X00KoTg6X00?o0000
oi=_YonCKjL01_nCKjL00ol0003oTVjUoi9^Y@05oi9^Y@03o`000?nBK:CoTVbT00KoTVbT00?o0000
oi5[XonAJj<01_nAJj<00ol0003oTFZRoi5ZXP03oi5ZXP05o`000?nAJZ;oTFZRoi5ZX_l000001Olg
02l01?l0003o=`0_ocL0;ol00003odP0=`03o`000?nAOK[o000000OoRFn_00?o00000?ooo`3oool0
0`3oool00ol00000oooo0?ooo`0^0?ooo`00>03oool2o`0000<0oooo00?o00000?ooo`3oool0A`3o
ool3o`000003oiIf[Ol0003oUGB[00OoUGB[00?o0000oiAbZ_nDLZX01OnDLZX00ol0003oTg6Xoi=a
Z006oi=aZ003o`000?nCKjOoTfnW00KoTfnW00?o0000oi9^YOnBKZD01OnBKZD00ol0003oTVbToi9/
Y006oi9/Y003o`000?nAJj?oTF^S00KoTF^S00?o0000oi5ZX_nAJZ800onAJZ800ol0003oTFZRo`00
0002o`0000Go=`0_00?o0000ocL0;ol000001?m803L01?l0003oTGfjoi5m^_l00006ohU_[`03o`00
003oool0oooo00@0oooo00?o00000?ooo`3oool0;@3oool001L0oooo0_l0000L0?ooo`?o0000C03o
ool3o`0000CoUWJ]00?o0000oiEdZonEM:/01_nEM:/00ol0003oU7:ZoiAbZP06oiAbZP03o`000?nC
LJSoTg6X00GoTg6X00?o0000oi=_YonCKjL01_nCKjL00ol0003oTVjUoi9^Y@06oi9^Y@03o`000?nB
K:CoTVbT00GoTVbT00?o0000oi5[XonAJj<01onAJj<00ol0003oTFZRo`000004o`0000;oTgNa00?o
0000ocL0;olg02l00_lg02l00ol0003o=`0_o`000004odP0=`05o`000?nAOK[oTGfjoi5m^_l00000
1_n9Kjl00ol00000oooo0?ooo`030?ooo`;o00001P3oool5o`0002@0oooo000F0?ooo`04o`00003o
ool0ooooo`0001T0oooo0ol0001;0?ooo`?o00002?nFMZd00ol0003oUGB[oiEdZ`05oiEdZ`03o`00
0?nDLZ[oU7:Z00KoU7:Z00?o0000oi=aZ?nCLJP01OnCLJP00ol0003oTfnWoi=_Y`06oi=_Y`03o`00
0?nBKZGoTVjU00KoTVjU00?o0000oi9/Y?nBK:@01OnBK:@00ol0003oTF^Soi5[X`06oi5[X`?o0000
0onCMk401Ol0003oTgNaoi=g/OnCMk7o000000Co=`0_0_l00005odP0=`05o`000?nAOK[oTGfjoi5m
^_l000001on9Kjl00ol00000oooo0?ooo`040?ooo`03o`00003oool0oooo00@0oooo00Co00000?oo
o`3ooooo0000903oool001H0oooo00Co00000?ooo`3ooooo00005P3oool3o`000080oooo00?o0000
0?ooo`3oool0AP3oool3o`0000;oUgR_00?o0000oiIf[OnFMZd01_nFMZd00ol0003oUGB[oiEdZ`05
oiEdZ`03o`000?nDLZ[oU7:Z00KoU7:Z00?o0000oi=aZ?nCLJP01OnCLJP00ol0003oTfnWoi=_Y`07
oi=_Y`03o`000?nBKZGoTVjU00GoTVjU00?o0000oi9/Y?nBK:@01_nBK:@00ol0003oTF^Soi5[X`02
oi5[X`?o000000?oTWNao`000?nCMk400onCMk400ol0003oTgNaoi=g/@02oi=g/@03o`000?lg02oo
=`0_00;o00001_m803L01Ol0003oTGfjoi5m^_nAOK[o000000OoRFn_00?o00000?ooo`3oool01@3o
ool00ol00000oooo0?ooo`040?ooo`03o`00003oool0oooo02@0oooo000F0?ooo`04o`00003oool0
ooooo`0001@0oooo0_l0001;0?ooo`?o00001OnGN:l00ol0003oUWJ]oiIf[@06oiIf[@03o`000?nE
M:_oUGB[00KoUGB[00?o0000oiAbZ_nDLZX01OnDLZX00ol0003oTg6Xoi=aZ006oi=aZ003o`000?nC
KjOoTfnW00KoTfnW00?o0000oi9^YOnBKZD01OnBKZD00ol0003oTVbToi9/Y006oi9/Y003o`000?nA
Jj?o000000;o00001?nBMk400ol0003oTgNaoi=g/@02oi=g/@03o`000?nCMk7oTgNa00;oTgNa00Go
0000ocL0;ol0003o@P0^o`000006odP0=`05o`000?nAOK[oTGfjoi5m^_l000001on9Kjl00ol00000
oooo0?ooo`050?ooo`03o`00003oool0oooo00D0oooo00?o00000?ooo`3oool08`3oool001H0oooo
00Co00000?ooo`3ooooo00004@3oool3o`0004X0oooo0ol000000onGN[7o0000oiMh[`06oiMh[`03
o`000?nFMZgoUWJ]00GoUWJ]00?o0000oiEdZonEM:/01_nEM:/00ol0003oU7:ZoiAbZP05oiAbZP03
o`000?nCLJSoTg6X00KoTg6X00?o0000oi=_YonCKjL01_nCKjL00ol0003oTVjUoi9^Y@05oi9^Y@03
o`000?nBK:CoTVbT00CoTVbT1?l00008oi9g/@05o`000?nCMk7oTgNaoi=g/Ol000001?nCMk42o`00
00;o@P0^00?o0000odP0=om803L01?m803L00ol0003oTGfjoi5m^P02oi5m^P03o`000?n9KjooRFn_
00CoRFn_00?o00000?ooo`3oool01P3oool01Ol00000oooo0?ooo`3ooooo000000<0oooo00?o0000
0?ooo`3oool08P3oool001H0oooo00Co00000?ooo`3ooooo00003`3oool2o`000080oooo00?o0000
0?ooo`3oool0A@3oool3o`0000CoUgZa00?o0000oiMh[onGN:l01OnGN:l00ol0003oUWJ]oiIf[@05
oiIf[@03o`000?nEM:_oUGB[00KoUGB[00?o0000oiAbZ_nDLZX01_nDLZX00ol0003oTg6Xoi=aZ005
oi=aZ003o`000?nCKjOoTfnW00KoTfnW00?o0000oi9^YOnBKZD01_nBKZD00ol0003oTVbTo`000003
o`0000;oTWJ`00?o0000oi9g/OnBMk401onBMk401Ol0003oTgNaoi=g/OnCMk7o000000CoTgNa00Go
0000od80;_m202ko@P0^o`000006odP0=`03o`000?nAOK[oTGfj00;oTGfj00?o0000ohU_[on9Kjl0
1?n9Kjl00ol00000oooo0?ooo`070?ooo`04o`00003oool0ooooo`0000<0oooo00?o00000?ooo`3o
ool08P3oool001L0oooo0_l0000=0?ooo`?o0000BP3oool2o`0000SoUgZa00?o0000oiMh[onGN:l0
1?nGN:l00ol0003oUWJ]oiIf[@06oiIf[@03o`000?nEM:_oUGB[00GoUGB[00?o0000oiAbZ_nDLZX0
1_nDLZX00ol0003oTg6Xoi=aZ005oi=aZ003o`000?nCKjOoTfnW00KoTfnW00?o0000oi9^YOnBKZD0
1?nBKZD4o`0000KoTWJ`00?o0000oi9g/OnBMk401onBMk401Ol0003oTgNaoi=g/OnCMk7o000000Go
TgNa00?o0000od80;_l000001om803L00ol0003oTGfjoi5m^P02oi5m^P03o`000?n9KjooRFn_00Go
RFn_00?o00000?ooo`3oool0103oool200000004o`00003oool0oooo0?ooo`?o00009@3oool002<0
oooo0ol0001:0?ooo`?o000000?oV7fdo`000?nGN[401onGN[400ol0003oUgR_oiMh[`05oiMh[`03
o`000?nFMZgoUWJ]00GoUWJ]00?o0000oiEdZonEM:/01OnEM:/00ol0003oU7:ZoiAbZP06oiAbZP03
o`000?nCLJSoTg6X00GoTg6X00?o0000oi=_YonCKjL01onCKjL00ol0003oTVjUo`000003o`0000;o
TWJ`00?o0000oi9f/?nBM[001_nBM[000ol0003oTWNaoi9g/@07oi9g/@04o`000?nCMk7oTgNao`00
00GoTgNa00?o0000od80;_l000001_m803L4o`0000;oTGfj00?o0000ohU_[on9Kjl01On9Kjl00ol0
0000oooo0?ooo`070?ooo`03o`00003oool0oooo02P0oooo000Q0?ooo`;o00000`3oool00ol00000
oooo0?ooo`150?ooo`;o00001?nHOK@00ol0003oUgZaoiMj/@06oiMj/@03o`000?nGN:ooUgR_00Go
UgR_00?o0000oiIf[OnFMZd01OnFMZd00ol0003oUGB[oiEdZ`06oiEdZ`03o`000?nDLZ[oU7:Z00Go
U7:Z00?o0000oi=aZ?nCLJP01_nCLJP00ol0003oTfnWoi=_Y`04oi=_Y`Co00001_nBM[000ol0003o
TWJ`oi9f/006oi9f/003o`000?nBMk7oTWNa00OoTWNa00Co0000oi=g/Ol0003o00001OnCMk400ol0
003o@P0^o`000006odP0=`04o`00001lHJP0O66X07aQZ0Co00001_n9Kjl00ol00000oooo0?ooo`08
0?ooo`03o`00003oool0oooo02L0oooo000N0?ooo`?o0000B`3oool2o`0000OoV7fd00?o0000oiMj
/OnGN[401OnGN[400ol0003oUgR_oiMh[`05oiMh[`03o`000?nFMZgoUWJ]00GoUWJ]00?o0000oiEd
ZonEM:/01_nEM:/00ol0003oU7:ZoiAbZP05oiAbZP03o`000?nCLJSoTg6X00KoTg6X00?o0000oi=_
Yol000001?l00002oi9f/@03o`000?nBM[3oTWJ`00KoTWJ`00?o0000oi9f/?nBM[001OnBM[000ol0
003oTWNaoi9g/@06oi9g/@?o000000?oTgNao`000?nCMk401?nCMk400ol0003o@P0^o`000006odP0
=`03o`00001lHJP0O66X00@0O66X0_l00005ohU_[`03o`00003oool0oooo00P0oooo00?o00000?oo
o`3oool09`3oool001d0oooo00?o00000000003oool0B@3oool3o`000003oiV0]_l0003oV7fd00Ko
V7fd00?o0000oiMj/OnGN[401_nGN[400ol0003oUgR_oiMh[`05oiMh[`03o`000?nFMZgoUWJ]00Go
UWJ]00?o0000oiEdZonEM:/01OnEM:/00ol0003oU7:ZoiAbZP06oiAbZP03o`000?nCLJSoTg6X00?o
Tg6X1?l00007oi9f/@03o`000?nBM[3oTWJ`00KoTWJ`00?o0000oi9f/?nBM[001_nBM[000ol0003o
TWNaoi9g/@02oi9g/@?o000000?oTWNao`000?nCMk400_nCMk400ol0003oTgNaoi=g/@02oi=g/@03
o`000?m202ko000000GoB00g0_l0000607aQZ004o`000?miG:Go0000o`0000?oRFn_00?o00000?oo
o`3oool02@3oool00ol00000oooo0?ooo`0V0?ooo`007@3oool2o`0000030000003oool0oooo04@0
oooo0ol00004oiV0]P03o`000?nHOKCoV7fd00GoV7fd00?o0000oiMj/OnGN[401_nGN[400ol0003o
UgR_oiMh[`05oiMh[`03o`000?nFMZgoUWJ]00GoUWJ]00?o0000oiEdZonEM:/01OnEM:/00ol0003o
U7:ZoiAbZP06oiAbZP03o`000?nCLJSo000000?o00000_nBMk400ol0003oTWJaoi9f/@07oi9f/@03
o`000?nBM[3oTWJ`00GoTWJ`00?o0000oi9f/?nBM[001_nBM[000ol0003oTWNao`000002o`0000Go
TWNa00Go0000oi=g/OnCMk7oTgNao`000004oi=g/@;o00001?m803L00ol0003o<000o`00000607aQ
Z004o`000?miG:GoNEbUogULY@;o00000_n9Kjl00ol00000oooo0?ooo`070?ooo`;o0000:03oool0
01d0oooo00Co00000?ooo`3oool00000@P3oool3o`0000SoVH2f00?o0000oiQm]?nHOK@01?nHOK@0
0ol0003oUgZaoiMj/@06oiMj/@03o`000?nGN:ooUgR_00GoUgR_00?o0000oiIf[OnFMZd01OnFMZd0
0ol0003oUGB[oiEdZ`05oiEdZ`03o`000?nDLZ[oU7:Z00CoU7:Z1?l00006oi9g/@03o`000?nBM[7o
TWJa00OoTWJa00?o0000oi9f/?nBM[001OnBM[000ol0003oTWJ`oi9f/005oi9f/0?o00002?nBMk40
0ol0003oTgNaoi=g/@02oi=g/@04o`000?nCMk7oTgNaoi=g/@;o00000om803L01?l0003o<000o`00
0000000707aQZ003o`000?miG:GoNEbU00;oNEbU0ol0000;0?ooo`03o`00003oool0oooo02D0oooo
000E0?ooo`?o00001@3oool01Ol00000oooo0?ooo`3oool0000003h0oooo0ol00002oiZ3^@03o`00
0?nIP;KoVH2f00KoVH2f00?o0000oiQm]?nHOK@01OnHOK@00ol0003oUgZaoiMj/@05oiMj/@03o`00
0?nGN:ooUgR_00GoUgR_00?o0000oiIf[OnFMZd01OnFMZd00ol0003oUGB[oiEdZ`06oiEdZ`03o`00
0?nDLZ[o000000?o00000_nBMk800ol0003oTWNaoi9g/@06oi9g/@03o`000?nBM[7oTWJa00KoTWJa
00?o0000oi9f/?nBM[001_nBM[001?l0003oTWJ`oi9f/?nBM[03o`0000;oTWJ`00?o0000oi9g/OnB
Mk401_nBMk400ol0003oTgNaoi=g/@02oi=g/@05o`000?nCMk7oTgNaoi=g/Ol000000_m803L2o`00
00;o<00000?o0000085Y[`0000001P1lHJP00ol0003oNEbUogULY@04ogULY@03o`00003oool0oooo
00X0oooo00?o00000?ooo`3oool0903oool001H0oooo00?o00000?ooo`3oool00`3oool3o`0000<0
oooo00<000000?ooo`3oool0>03oool3o`0000GoVX>i00?o0000oiV0]_nIP;H01_nIP;H00ol0003o
V7fdoiQm]005oiQm]003o`000?nGN[7oUgZa00GoUgZa00?o0000oiMh[onGN:l01_nGN:l00ol0003o
UWJ]oiIf[@04oiIf[@03o`000?nEM:_oUGB[00CoUGB[1?l00006oi9g/P03o`000?nBMk7oTWNa00Ko
TWNa00?o0000oi9f/OnBM[401_nBM[400ol0003oTWJ`oi9f/006oi9f/0Co00001OnBM[000ol0003o
TWNaoi9g/@06oi9g/@03o`000?nCMk7oTgNa00?oTgNa00Ko0000oi=g/OnCMk7o0000odP0=ol00004
oc000003o`000021JJl0000000H0O66X00?o0000ogULYOmiG:D01?miG:D00ol00000oooo0?ooo`0:
0?ooo`03o`00003oool0oooo02@0oooo000>0?ooo`Go00000`3oool00ol00000oooo0?ooo`030?oo
o`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0=03oool3o`000003oi^7_?l0003oVX>i
00KoVX>i00?o0000oiV0]_nIP;H01OnIP;H00ol0003oV7fdoiQm]005oiQm]003o`000?nGN[7oUgZa
00KoUgZa00?o0000oiMh[onGN:l01OnGN:l00ol0003oUWJ]oiIf[@05oiIf[@03o`000?nEM:_o0000
00?o00000_nBN;800ol0003oTWNboi9g/P06oi9g/P03o`000?nBMk7oTWNa00GoTWNa00?o0000oi9f
/OnBM[401onBM[400ol0003oTWJ`oi9f/003oi9f/0?o00002?nBM[000ol0003oTWNaoi9g/@07oi9g
/@03o`000?nCMk7oTgNa00?oTgNa00Co0000oi=g/OnCMk7o00001?l`00001?l00000PFV_085Y[`00
000607aQZ003o`000?miG:GoNEbU00CoNEbU00?o00000?ooo`3oool02`3oool00ol00000oooo0?oo
o`0S0?ooo`005P3oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo00D0oooo00<00000
0?ooo`3oool0<@3oool2o`0000CoVhNl00?o0000oiZ3^OnJPkT01OnJPkT00ol0003oVH2foiV0]P06
oiV0]P03o`000?nHOKCoV7fd00CoV7fd00?o0000oiMj/OnGN[401_nGN[400ol0003oUgR_oiMh[`05
oiMh[`03o`000?nFMZgoUWJ]00?oUWJ]1?l00006oi9h/P03o`000?nBMk;oTWNb00KoTWNb00?o0000
oi9g/OnBMk401_nBMk400ol0003oTWJaoi9f/@06oi9f/@04o`000?nBM[3oTWJ`oi9f/0;o00000_nB
M[000ol0003oTWJ`oi9f/006oi9f/003o`000?nBMk7oTWNa00OoTWNa00?o0000oi=g/OnCMk400onC
Mk400ol0003oTgNao`000002o`0000?o<00000Co0000085Y[`21JJl000001P1lHJP00ol0003oNEbU
ogULY@05ogULY@03o`00003oool0oooo00/0oooo00?o00000?ooo`3oool08P3oool001H0oooo00?o
00000?ooo`3oool00`3oool2o`0000L0oooo00<000000?ooo`3oool0;P3oool2o`0000OoVhNl00?o
0000oiZ3^OnJPkT01?nJPkT00ol0003oVH2foiV0]P06oiV0]P03o`000?nHOKCoV7fd00GoV7fd00?o
0000oiMj/OnGN[401OnGN[400ol0003oUgR_oiMh[`06oiMh[`03o`000?nFMZgo000000;o00000_nC
NK<00ol0003oTWRboi9h/P06oi9h/P03o`000?nBMk;oTWNb00GoTWNb00?o0000oi9g/OnBMk401_nB
Mk400ol0003oTWJaoi9f/@06oi9f/@Co00001?nBM[000ol0003oTWJ`oi9f/007oi9f/003o`000?nB
Mk7oTWNa00KoTWNa00?o0000oi=g/OnCMk400_nCMk43o`0000?oWLKd00Co0000oc000?l`003o0000
0`21JJl00`000000O66X07aQZ00407aQZ003o`000?miG:GoNEbU00CoNEbU00?o00000?ooo`3oool0
2P3oool2o`0002@0oooo000E0?ooo`;o00001@3oool00ol00000oooo0?ooo`070?ooo`030000003o
ool0oooo02X0oooo0ol000000onMRl3o0000oi^7_006oi^7_003o`000?nJPkWoVX>i00GoVX>i00?o
0000oiV0]_nIP;H01OnIP;H00ol0003oV7fdoiQm]005oiQm]003o`000?nGN[7oUgZa00GoUgZa00?o
0000oiMh[onGN:l01?nGN:l4o`0000GoTgVc00?o0000oi9h/_nBN;801_nBN;800ol0003oTWNboi9g
/P06oi9g/P03o`000?nBMk7oTWNa00GoTWNa00?o0000oi9f/OnBM[401?nBM[43o`0000SoTWJ`00?o
0000oi9f/?nBM[001_nBM[000ol0003oTWNaoi9g/@07oi9g/@Co00000onMa_@01?l0003oWLKdoig6
m?nMa_@2o`0000@0PFV_00<0000007aQZ01lHJP0101lHJP00ol0003oNEbUogULY@04ogULY@03o`00
003oool0oooo00`0oooo00?o00000?ooo`3oool08@3oool001H0oooo00?o00000?ooo`3oool00`3o
ool00ol00000oooo0?ooo`080?ooo`030000003oool0oooo02H0oooo0ol00004oif;`003o`000?nK
QkcoVhNl00GoVhNl00?o0000oiZ3^OnJPkT01OnJPkT00ol0003oVH2foiV0]P06oiV0]P03o`000?nH
OKCoV7fd00CoV7fd00?o0000oiMj/OnGN[401_nGN[400ol0003oUgR_o`000003o`0000;oTgZe00?o
0000oi=i/onCNK<01OnCNK<00ol0003oTWRboi9h/P05oi9h/P03o`000?nBMk;oTWNb00KoTWNb00?o
0000oi9g/OnBMk401_nBMk400ol0003oTWJaoi9f/@03o`0000;oTWJa00?o0000oi9f/?nBM[001_nB
M[000ol0003oTWJ`oi9f/006oi9f/003o`000?nBMk7oTWNa00GoTWNa0ol00007oig6m003o`000?nM
a_CoWLKd00;o00001021JJl00`000000O66X07aQZ00407aQZ003o`000?miG:GoNEbU00CoNEbU00?o
00000?ooo`3oool03@3oool00ol00000oooo0?ooo`0P0?ooo`006`3oool3o`0000X0oooo00<00000
0?ooo`3oool08P3oool3o`0000SoWH_000?o0000oi^7_?nKQk`01OnKQk`00ol0003oVX>ioiZ3^@04
oiZ3^@03o`000?nIP;KoVH2f00KoVH2f00?o0000oiQm]?nHOK@01?nHOK@00ol0003oUgZaoiMj/@04
oiMj/@Co00001_nCN[D00ol0003oTgVcoi=i/`05oi=i/`03o`000?nBN;;oTWRb00KoTWRb00?o0000
oi9g/_nBMk801OnBMk800ol0003oTWNaoi9g/@06oi9g/@?o00001_nBM[400ol0003oTWJ`oi9f/005
oi9f/003o`000?nBM[3oTWJ`00OoTWJ`00?o0000oi9g/Ol000001?l00003oiffj@03o`000?nMa_Co
WLKd00CoWLKd0ol00006085Y[`030000001lHJP0O66X00@0O66X00?o0000ogULYOmiG:D01OmiG:D0
0ol00000oooo0?ooo`0<0?ooo`03o`00003oool0oooo0200oooo000K0?ooo`03o`00003oool0oooo
00/0oooo00<000000?ooo`3oool07P3oool3o`0000;oWXo400?o0000oif;`?nMRl001_nMRl000ol0
003oVhNloi^7_005oi^7_003o`000?nJPkWoVX>i00CoVX>i00?o0000oiV0]_nIP;H01_nIP;H00ol0
003oV7fdoiQm]005oiQm]003o`000?nGN[7o000000?o00000_nCO;H00ol0003oTgZeoi=j]@06oi=j
]@03o`000?nCNK?oTgVc00CoTgVc00?o0000oi9h/_nBN;801_nBN;800ol0003oTWNboi9g/P06oi9g
/P03o`000?nBMk7oTWNa00;oTWNa1?l00008oi9f/@03o`000?nBM[3oTWJ`00GoTWJ`00?o0000oi9f
/?nBM[001OnBM[04o`0000WoWKKY00?o0000oig6m?nMa_@00_nMa_@3o`00008000001P21JJl00`00
0000O66X07aQZ00407aQZ003o`000?miG:GoNEbU00CoNEbU00?o00000?ooo`3oool03@3oool00ol0
0000oooo0?ooo`0O0?ooo`006`3oool2o`0000d0oooo00<000000?ooo`3oool06P3oool3o`0000Ko
WXo400?o0000oif;`?nMRl001OnMRl000ol0003oVhNloi^7_005oi^7_003o`000?nJPkWoVX>i00Go
VX>i00?o0000oiV0]_nIP;H01OnIP;H00ol0003oV7fdoiQm]003oiQm]0Co00001_nCO;H00ol0003o
TgZeoi=j]@06oi=j]@03o`000?nCNK?oTgVc00GoTgVc00?o0000oi9h/_nBN;801OnBN;800ol0003o
TWNboi9g/P06oi9g/P03o`000?nBMk7o000000;o00000onBMk400ol0003oTWJaoi9f/@06oi9f/@03
o`000?nBM[3oTWJ`00KoTWJ`00?o0000oi9f/?l000001?l00002oibXg`03o`000?nM]^WoWKKY00Wo
WKKY00Co0000oig6m?l0003o00000`1fGZX01?l00000LeZV000000000004085Y[`030000001lHJP0
O66X00@0O66X00?o0000ogULYOmiG:D01?miG:D00ol00000oooo0?ooo`0=0?ooo`;o0000803oool0
01/0oooo00?o00000?ooo`3oool03@3oool00`000000oooo0?ooo`0F0?ooo`?o000000?oWiC8o`00
0?nNSl@01_nNSl@00ol0003oWH_0oif;`006oif;`003o`000?nKQkcoVhNl00CoVhNl00?o0000oiZ3
^OnJPkT01OnJPkT00ol0003oVH2foiV0]P06oiV0]P03o`000?nHOKCo000000;o00000_nDOKP00ol0
003oTgbfoi=l]P06oi=l]P03o`000?nCN[GoTgZe00GoTgZe00?o0000oi=i/onCNK<01OnCNK<00ol0
003oTWRboi9h/P06oi9h/P03o`000?nBMk;oTWNb00CoTWNb0ol00007oi9g/@03o`000?nBM[7oTWJa
00GoTWJa00?o0000oi9f/?nBM[001?nBM[04o`0000SoW:SO00?o0000oiffjOnM]^T02?nM]^T2o`00
00D0MUjZ00@00000o`00001cFZH0LeZV0P000002085Y[`030000001lHJP0O66X00@0O66X00?o0000
ogULYOmiG:D01?miG:D00ol00000oooo0?ooo`0>0?ooo`03o`00003oool0oooo01h0oooo000K0?oo
o`03o`00003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool2o`0000GoWiC800?o0000oij?
a?nNSl@01OnNSl@00ol0003oWH_0oif;`005oif;`003o`000?nKQkcoVhNl00GoVhNl00?o0000oiZ3
^OnJPkT01?nJPkT00ol0003oVH2foiV0]P04oiV0]PCo00001OnDOKP00ol0003oTgbfoi=l]P06oi=l
]P03o`000?nCN[GoTgZe00GoTgZe00?o0000oi=i/onCNK<01OnCNK<00ol0003oTWRboi9h/P06oi9h
/P03o`000?nBMk;oTWNb00;oTWNb0_l000000onBMk;o0000oi9g/@07oi9g/@03o`000?nBM[7oTWJa
00KoTWJa00?o0000oi9f/?l000000ol00002oiZNe`03o`000?nLZ=ooW:SO00SoW:SO00?o0000oiff
jOnM]^T01OnM]^T2o`00000307]X/@000000MUjZ00D0MUjZ00?o000007=JYP1cFZH00P1cFZH00`00
0000PFV_0000000607aQZ003o`000?miG:GoNEbU00GoNEbU00?o00000?ooo`3oool03P3oool00ol0
0000oooo0?ooo`0M0?ooo`006`3oool2o`000100oooo0P00000A0?ooo`;o00001onOU<P00ol0003o
WXo4oij?a005oij?a003o`000?nMRl3oWH_000GoWH_000?o0000oi^7_?nKQk`01OnKQk`00ol0003o
VX>ioiZ3^@05oiZ3^@03o`000?nIP;Ko000000?o00000_nDOkX00ol0003oU7fhoiAm^005oiAm^003
o`000?nCO;KoTgbf00GoTgbf00?o0000oi=j]OnCN[D01_nCN[D00ol0003oTgVcoi=i/`05oi=i/`03
o`000?nBN;;oTWRb00GoTWRb00?o0000oi9g/_l000000_l00004oi9g/P03o`000?nBMk7oTWNa00Go
TWNa00?o0000oi9f/OnBM[401?nBM[44o`0000OoVYkG00?o0000oibXgonLZ=l01onLZ=l00ol0003o
WKKYoiffj@02oiffj@?o00000`1kJ;400`000000MUjZ07INZP0407INZP0300000?l00000LeZV00<0
LeZV0`00000507aQZ003o`000?miG:GoNEbU00GoNEbU00?o00000?ooo`3oool03`3oool00ol00000
oooo0?ooo`0L0?ooo`00203oool2o`0000@0oooo00?o00000?ooo`3oool00P3oool3o`0000D0oooo
00?o00000?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`?o000000?oXIW<o`000?nOU<P0
1onOU<P00ol0003oWXo4oij?a005oij?a003o`000?nMRl3oWH_000GoWH_000?o0000oi^7_?nKQk`0
1?nKQk`00ol0003oVX>ioiZ3^@03oiZ3^@Co00001_nDOkX00ol0003oU7fhoiAm^005oiAm^003o`00
0?nCO;KoTgbf00GoTgbf00?o0000oi=j]OnCN[D01_nCN[D00ol0003oTgVcoi=i/`05oi=i/`03o`00
0?nBN;;oTWRb00CoTWRb0ol00007oi9g/P03o`000?nBMk7oTWNa00KoTWNa00?o0000oi9f/Ol00000
0ol00002oiRGd003o`000?nJW]OoVYkG00OoVYkG00?o0000oibXgonLZ=l01onLZ=l01Ol0003oWKKY
o`000?l00000000000D0NfRa00<0000007INZP1fGZX0101fGZX00`000000LeZVo`00000507=JYP80
00001@1lHJP00ol0003oNEbUogULY@04ogULY@03o`00003oool0oooo00l0oooo00?o00000?ooo`3o
ool0703oool000L0oooo00Co00000?ooo`3ooooo00001`3oool01Ol00000oooo0?ooo`3ooooo0000
00<0oooo00?o00000?ooo`3oool04`3oool00`000000oooo0?ooo`080?ooo`;o00001OnQVL`00ol0
003oWiC8oinDb005oinDb003o`000?nNSlCoWXo400GoWXo400?o0000oif;`?nMRl001OnMRl000ol0
003oVhNloi^7_005oi^7_003o`000?nJPkWo000000;o00000_nEP[`00ol0003oU7njoiAo^P06oiAo
^P03o`000?nDOKSoU7fh00CoU7fh00?o0000oi=l]_nCO;H01_nCO;H00ol0003oTgZeoi=j]@05oi=j
]@03o`000?nCNK?oTgVc00GoTgVc00Co0000oi9h/_nBN;;oTWRb0ol00002oi9h/P03o`000?nBMk;o
TWNb00GoTWNb00?o0000oi9g/OnBMk401?nBMk44o`0000OoV9O@00?o0000oiZNeonJW]L01_nJW]L0
0ol0003oW:SOoibXg`07oibXg`;o00000P26NKd00`000000NfRa07]X/@0407]X/@030000001fGZX0
MUjZ00<0MUjZ00@0000007=JYP1cFZKo0000101cFZH00`000000LURU0000000407aQZ003o`000?mi
G:GoNEbU00CoNEbU00?o00000?ooo`3oool03P3oool00`00003o0000o`0000070?ooo`?o00004`3o
ool000Go00000P3oool01?l00000oooo0?ooool0000;0?ooo`04o`00003oool0oooo0?ooo`;o0000
5@3oool00`000000oooo0?ooo`040?ooo`?o00001onQVL`00ol0003oWiC8oinDb006oinDb003o`00
0?nNSlCoWXo400CoWXo400?o0000oif;`?nMRl001OnMRl000ol0003oVhNloi^7_003oi^7_0Co0000
1_nEP[`00ol0003oU7njoiAo^P05oiAo^P03o`000?nDOKSoU7fh00CoU7fh00?o0000oi=l]_nCO;H0
1_nCO;H00ol0003oTgZeoi=j]@05oi=j]@03o`000?nCNK?oTgVc00KoTgVc0ol00005oi9h/P03o`00
0?nBMk;oTWNb00KoTWNb00?o0000oi9g/Ol000000ol00002oiNAc003o`000?nHUm3oV9O@00KoV9O@
00?o0000oiZNeonJW]L01onJW]L00ol0003oW:SOoibXg`04oibXg`;o00000P1_GZh3000000H0NfRa
00<0000007INZP1fGZX0101fGZX00`000000LeZVo`00000407=JYP040000001bF:D0LURU000000<0
O66X00?o0000ogULYOmiG:D01?miG:D00ol00000oooo0?ooo`0>0?ooo`040000003oool0ooooo`00
00D0oooo00Go00000?ooo`3oool0ooooo`00000B0?ooo`001`3oool01?l00000oooo0?ooool0000;
0?ooo`05o`00003oool0oooo0?ooool000005`3oool00`000000oooo0?ooo`03o`0000;oXioA00?o
0000oj6Ic?nQVL`01_nQVL`00ol0003oWiC8oinDb005oinDb003o`000?nNSlCoWXo400GoWXo400?o
0000oif;`?nMRl001OnMRl000ol0003oVhNlo`000002o`0000;oUHFo00?o0000oiF2_?nEP[`01OnE
P[`00ol0003oU7njoiAo^P05oiAo^P03o`000?nDOKSoU7fh00GoU7fh00?o0000oi=l]_nCO;H01OnC
O;H00ol0003oTgZeoi=j]@06oi=j]@03o`000?nCNK?oTgVc00;oTgVc1?l00007oi9h/P03o`000?nB
Mk;oTWNb00CoTWNb1?l00007oiNAc003o`000?nHUm3oV9O@00KoV9O@00?o0000oiZNeonJW]L01_nJ
W]L00ol0003oW:SOoibXg`02oibXg`;o000000<0000006mN[P1_GZh00`1_GZh2000000D0NfRa00<0
000007INZP1fGZX0101fGZX010000000LeZV07=JY_l0000307=JYP040000001bF:D0LURU079HY@80
000000<0O66Xo`000?miG:D01_miG:D00ol00000oooo0?ooo`0<0?ooo`<0000000<0ooooo`00003o
ool0203oool00ol00000oooo0?ooo`0@0?ooo`001`3oool01?l00000oooo0?ooool000070?ooo`Co
0000103oool00ol00000oooo0?ooo`0E0?ooo`?o00001_nSWm400ol0003oXIW<oj6Ic005oj6Ic003
o`000?nOU<SoWiC800GoWiC800?o0000oij?a?nNSl@01OnNSl@00ol0003oWH_0oif;`002oif;`0Go
00001_nEQKl00ol0003oUH:loiF2_004oiF2_003o`000?nDOk[oU7nj00KoU7nj00?o0000oiAm^?nD
OKP01?nDOKP00ol0003oTgbfoi=l]P06oi=l]P03o`000?nCN[GoTgZe00GoTgZe00?o0000oi=i/ol0
00000_l00003oi=i/`03o`000?nBN;;oTWRb00KoTWRb00?o0000oi9g/_l000000ol00002oiF=b003
o`000?nGTLcoUi7<00KoUi7<00?o0000oiRGd?nHUm001_nHUm000ol0003oVYkGoiZNe`07oiZNe`04
o`000?nLZ=oo0000o`000080N6^h00<0000006mN[P1_GZh0101_GZh2000000@0NfRa00<0000007IN
ZP1fGZX0101fGZX01@000000LeZV07=JYP1cFZKo000000<0LeZV00<00000079HY@1bF:D00P1bF:D0
0`00003o0000ogULY@06ogULY@03o`00003oool0oooo00/0oooo1@0000000`3ooooo00000?ooo`05
0?ooo`;o00004`3oool000L0oooo00Co00000?ooo`3ooooo00001`3oool00ol00000oooo0?ooo`05
0?ooo`;o0000503oool2o`000003ojBVeol0003oXioA00KoXioA00?o0000oj6Ic?nQVL`01_nQVL`0
0ol0003oWiC8oinDb005oinDb003o`000?nNSlCoWXo400?oWXo41_l00003oiJ8`P03o`000?nEQKoo
UHFo00GoUHFo00?o0000oiF2_?nEP[`01OnEP[`00ol0003oU7njoiAo^P05oiAo^P03o`000?nDOKSo
U7fh00CoU7fh00?o0000oi=l]_nCO;H01_nCO;H00ol0003oTgZeoi=j]@04oi=j]@?o00001onCNK<0
1?l0003oTWRboi9h/_nBN;86o`0000OoUHg800?o0000oiNAc?nGTL`01OnGTL`00ol0003oV9O@oiRG
d006oiRGd003o`000?nJW]OoVYkG00OoVYkG0_l0000407Q[^0030000001_GZh0Kej^00@0Kej^00<0
000006aGZ@000000101kJ;400`000000MUjZ07INZP0307INZP050000001cFZH0LeZV07=JY_l00000
0`1cFZH00`000000LURU079HY@03079HY@0300000?l0003oNEbU00GoNEbU00?o00000?ooo`3oool0
2P3oool00`0000001P0e0000000400000003o`00003oool0oooo00H0oooo00?o00000?ooo`3oool0
403oool000P0oooo0_l000080?ooo`Go00000`3oool00ol00000oooo0?ooo`0A0?ooo`;o00001?nT
Y]L00ol0003oXioAoj>Od@05oj>Od@03o`000?nQVLcoXIW<00GoXIW<00?o0000oinDb?nOU<P01OnO
U<P00ol0003oWXo4oij?a003o`0000;oUhc600?o0000oiJ8`_nFR<801OnFR<800ol0003oUHFooiF5
_`04oiF5_`03o`000?nEP[coUH:l00GoUH:l00?o0000oiAo^_nDOkX01OnDOkX00ol0003oU7fhoiAm
^005oiAm^003o`000?nCO;KoTgbf00GoTgbf00?o0000oi=j]OnCN[D00_nCN[D2o`000003oi=j]Ol0
003oTgVc00GoTgVc1_l00004oiB9a@03o`000?nESLSoUHg800KoUHg800?o0000oiNAc?nGTL`01_nG
TL`00ol0003oV9O@oiRGd006oiRGd003o`000?nJW]OoVYkG00?oVYkG0ol000000`28QLT0000007Q[
^00407Q[^0030000001_GZh0Kej^00<0Kej^00@0000006aGZ@1/EjT000000`1kJ;400`000000MUjZ
07INZP0407INZP050000001cFZH0LeZV07=JY_l000000P1cFZH00`000000LURU079HY@04079HY@;o
00001OmiG:D00ol00000oooo0?ooo`090?ooo`040000000603D00000000000<0VIK?00<000000?oo
ool000000`3oool01Ol00000oooo0?ooo`3ooooo00000180oooo000I0?ooo`03o`00003oool0oooo
00l0oooo0ol00007ojBVe`03o`000?nSWm7oXioA00GoXioA00?o0000oj6Ic?nQVL`01OnQVL`00ol0
003oWiC8oinDb003oinDb0Co00001_nGS<H00ol0003oUXS2oiJ8`P04oiJ8`P03o`000?nEQKooUHFo
00GoUHFo00?o0000oiF2_?nEP[`01OnEP[`00ol0003oU7njoiAo^P04oiAo^P03o`000?nDOKSoU7fh
00GoU7fh00?o0000oi=l]_nCO;H01OnCO;H00ol0003oTgZeo`000002o`0000CoTgZe00?o0000oi=i
/ol000000ol00002oi>7``03o`000?nDRLGoU8W500KoU8W500?o0000oiF=b?nESLP01OnESLP00ol0
003oUi7<oiNAc006oiNAc003o`000?nHUm3oV9O@00KoV9O@00?o0000oiZNeonJW]L00ol000001@00
0000R8G908R5b@28QLT0000000D0N6^h00<0000006mN[P1_GZh0101_GZh00`000000K5NY06aGZ@02
0000000307]X/@000000MUjZ00D0MUjZ00<0000007=JYP1cFZH00P1cFZH00ol00000LeZV00000006
079HY@030000001bFJKo000000GoNEbU00?o00000?ooo`3oool01`3oool0100000001P0e00H0=@00
000409VFc`0400000?l00000ooooo`0000<0oooo0ol0000C0?ooo`006@3oool2o`0000d0oooo0ol0
0002ojF^g@03o`000?nTY]OoY:KG00GoY:KG00?o0000oj>OdOnSWm401OnSWm400ol0003oXIW<oj6I
c005oj6Ic003o`000?nOU<SoWiC800?o00000_nGT<X00ol0003oUhc6oiN<aP05oiN<aP03o`000?nF
R<;oUXS200CoUXS200?o0000oiF5_onEQKl01OnEQKl00ol0003oUH:loiF2_005oiF2_003o`000?nD
Ok[oU7nj00GoU7nj00?o0000oiAm^?nDOKP01?nDOKP00ol0003oTgbfoi=l]P04oi=l]P?o00000onC
N[D6o`0000OoThO300?o0000oiB9aOnDRLD01OnDRLD00ol0003oUHg8oiF=b006oiF=b003o`000?nG
TLcoUi7<00KoUi7<00?o0000oiRGd?nHUm001OnHUm03o`0000040000001[HKD0Jf6e06]Q]@800000
00<0R8G90000001hJkP0101hJkP00`000000Kej^06mN[P0406mN[P030000001/EjT0K5NY0080K5NY
0P00000607INZP030000001cFZH0LeZV00<0LeZV00?o00000000001bF:D01@1bF:D00`000000LUVV
079IYP02o`0000?oNEbU00?o00000?ooo`3oool01P3oool01@0000001P0e00H0=@0603D0000000D0
VIK?00<000000?ooool000006@3oool001T0oooo00?o00000?ooo`3oool02@3oool3o`0000KoYJkM
00?o0000ojBVeonTY]L01OnTY]L00ol0003oXioAoj>Od@05oj>Od@03o`000?nQVLcoXIW<00?oXIW<
1?l00006oiN@bP03o`000?nGS<KoUhc600CoUhc600?o0000oiJ8`_nFR<801OnFR<800ol0003oUHFo
oiF5_`04oiF5_`03o`000?nEP[coUH:l00GoUH:l00?o0000oiAo^_nDOkX01OnDOkX00ol0003oU7fh
oiAm^004oiAm^004o`000?nCO;KoTgbfoi=l]PWo00001?nBQL800ol0003oThO3oi>7``06oi>7``03
o`000?nDRLGoU8W500GoU8W500?o0000oiF=b?nESLP01_nESLP00ol0003oUi7<oiNAc006oiNAc003
o`000?nHUm3oV9O@00;oV9O@1?l0000307]ia@030000001[HKD0Jf6e0080Jf6e0`00000407Q[^003
0000001_GZh0Kej^00@0Kej^00<0000006aGZ@1/EjT00`1/EjT2000000D0MUjZ00<0000007=JYP1c
FZH00`1cFZH00ol000000000079HY@06079HY@050000001bFJH0LUVV079IY_l000000_miG:D00ol0
0000oooo0?ooo`050?ooo`040000000603D01P0e00H0=@8000001@2IU/l010000000oooo0?ooool0
000H0?ooo`006@3oool00ol00000oooo0?ooo`060?ooo`?o000000?oYkKTo`000?nU[]d01_nU[]d0
0ol0003oY:KGojBVe`05ojBVe`03o`000?nSWm7oXioA00GoXioA00?o0000oj6Ic?nQVL`00ol00002
oiREc`03o`000?nGT<[oUi3:00GoUi3:00?o0000oiN<a_nGS<H01OnGS<H00ol0003oUXS2oiJ8`P04
oiJ8`P03o`000?nEQKooUHFo00GoUHFo00?o0000oiF2_?nEP[`01OnEP[`00ol0003oU7njoiAo^P04
oiAo^P03o`000?nDOKSoU7fh00GoU7fh1_l00002oi:4`@03o`000?nBQL;oTXG200KoTXG200?o0000
oi>7`onCQl<01OnCQl<00ol0003oU8W5oiB9a@06oiB9a@03o`000?nESLSoUHg800KoUHg800?o0000
oiNAc?nGTL`01OnGTL`00ol0003oV9O@o`000002o`000003ogGRiol00000NgW500@0NgW500<00000
06]Q]@1[HKD0101[HKD2000000<0N6^h00<0000006mN[P1_GZh0101_GZh00`000000K5NY06aGZ@04
06aGZ@800000101fGZX00`000000LeZV07=JYP0407=JYP03o`0000000000LURU00D0LURU00<00000
079IYP1bFJH00P1bFJH3o`0000H0oooo0P00000300H0=@8000001@2IU/l01@000000oooo0?ooo`3o
oooo000001L0oooo000I0?ooo`;o00001@3oool2o`0000GoYkKT00?o0000ojF^gOnU[]d01OnU[]d0
0ol0003oY:KGojBVe`05ojBVe`03o`000?nSWm7oXioA00;oXioA1Ol00006oiREc`03o`000?nGT<[o
Ui3:00CoUi3:00?o0000oiN<a_nGS<H01OnGS<H00ol0003oUXS2oiJ8`P04oiJ8`P03o`000?nEQKoo
UHFo00GoUHFo00?o0000oiF2_?nEP[`01OnEP[`00ol0003oU7njoiAo^P05oiAo^P04o`000?nDOKSo
U7fhoiAm^0Go00001onBQ<400ol0003oTXG2oi:5`P05oi:5`P03o`000?nCQl?oThO300KoThO300?o
0000oiB9aOnDRLD01OnDRLD00ol0003oUHg8oiF=b006oiF=b003o`000?nGTLcoUi7<00CoUi7<1ol0
00000`2JYMd0000007]ia@0307]ia@030000001[HKD0Jf6e00@0Jf6e00<0000006EF[@0000000`1h
JkP00`000000Kej^06mN[P0306mN[P030000001/EjT0K5NY00@0K5NY00<0000006]EY`000000101f
GZX00`000000LeZV07=JYP0407=JYP03o`00001bF:D0LURU00@0LURU00<00000079IYP1bFJH0101b
FJH2o`0000@0oooo0`00000200H0=@030000000O04@0000000D0VIK?00@000000?ooo`3oool0oooo
0_l0000F0?ooo`006@3oool01?l00000oooo0?ooo`3oool3o`0000SoYkKT00?o0000ojF^gOnU[]d0
1OnU[]d00ol0003oY:KGojBVe`03ojBVe`Ko00000onIVm@00ol0003oV9G?oiREc`05oiREc`03o`00
0?nGT<[oUi3:00GoUi3:00?o0000oiN<a_nGS<H01?nGS<H00ol0003oUXS2oiJ8`P05oiJ8`P03o`00
0?nEQKooUHFo00CoUHFo00?o0000oiF2_?nEP[`01OnEP[`00ol0003oU7njoiAo^P02oiAo^POo0000
0onAPl400ol0003oTXC1oi:4`@06oi:4`@03o`000?nBQL;oTXG200GoTXG200?o0000oi>7`onCQl<0
1_nCQl<00ol0003oU8W5oiB9a@05oiB9a@03o`000?nESLSoUHg800KoUHg800?o0000oiNAc?nGTL`0
1?l00003oi?Ro@;o00000P0000000`2JYMd0000007]ia@0407]ia@030000001[HKD0Jf6e00<0Jf6e
00@0000006EF[@1UEZd000000P1hJkP00`000000Kej^06mN[P0406mN[P030000001/EjT0K5NY00<0
K5NY00@0000006]EY`1[EJL000000`1fGZX00`000000LeZV07=JYP0407=JYP0300000?l00000LURU
00@0LURU00<00000079IYP1bFJH01@1bFJH01_l00000oooo0?ooo`3oool000000000708000000P06
03D00`0000007`140000000609VFc`030000003oool0oooo00;o00005P3oool001P0oooo00?o0000
0?ooool000000_l00003ojO0j`03o`000?nW]^CoYkKT00KoYkKT00?o0000ojF^gOnU[]d01?nU[]d0
0ol0003oY:KGojBVe`03o`0000;oVJ;K00?o0000oiVKe?nIVm@01OnIVm@00ol0003oV9G?oiREc`05
oiREc`03o`000?nGT<[oUi3:00CoUi3:00?o0000oiN<a_nGS<H01OnGS<H00ol0003oUXS2oiJ8`P04
oiJ8`P03o`000?nEQKooUHFo00GoUHFo00Co0000oiF2_?nEP[coUH:l2?l000001?n@Q<;o0000o`00
0?l00007oi63`@03o`000?nBQ<7oTXC100GoTXC100?o0000oi:5`_nBQL801_nBQL800ol0003oThO3
oi>7``05oi>7``03o`000?nDRLGoU8W500KoU8W500?o0000oiF=b?nESLP01OnESLP3o`0000GoTn;m
0_l0000010000000Kg;506mba@1_L/D2000000D0NgW500<0000006]Q]@1[HKD0101[HKD01P000000
IEJ]06EF[@000000N6^h000000H0Kej^00<0000006aGZ@1/EjT00`1/EjT010000000JeFW06]EY`1[
EJL20000000307INZP000000LeZV00D0LeZV00<00000o`00001bF:D0101bF:D00`000000LUVV079I
YP05079IYP080000003oool0oooo0000000001`0000000d0?@00000200H0=@030000000O04@00000
00800000102IU/l00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo01<0oooo000H0?ooo`;o
00001onW`>/00ol0003oYkKTojNfi006ojNfi004o`000?nU[]goYJkMojF^g@Go00001_nIX]/00ol0
003oVI_DoiVKe004oiVKe003o`000?nHULooV9G?00GoV9G?00?o0000oiN@b_nGT<X01OnGT<X00ol0
003oUhc6oiN<aP04oiN<aP03o`000?nFR<;oUXS200CoUXS200?o0000oiF5_onEQKl00onEQKl6o`00
00CoT8C300?o0000oi24`_l000000_l00003oi24`P03o`000?nAPl7oTH?100CoTH?100?o0000oi:4
`OnBQ<401_nBQ<400ol0003oTXG2oi:5`P05oi:5`P03o`000?nCQl?oThO300KoThO300?o0000oiB9
aOnDRLD01OnDRLD00ol0003oUHg8oiF=b002oiF=b0?o00000onLd?X2o`000003oi?RoOl0003o0000
0080Tj7N00<0000006mba@1_L/D00`1_L/D2000000<0NgW500<0000006]Q]@1[HKD0101[HKD01000
0000IEJ]06EF[@1UEZd2000000H0Kej^00<0000006aGZ@1/EjT0101/EjT00`000000JeFW06]EY`02
06]EY`8000001P1cFZH00`000000LURUo`000005079HY@030000001bFJH0LUVV00@0LUVV00X00000
0?ooo`3oool000000000700000003@0m0000000603D000000P0O04@20000000306]J[@000000VIK?
0080VIK?00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`0C0?ooo`004@3oool2o`0000D0
oooo00?o00000?ooool000001onW`>/00ol0003oYkKTojNfi004ojNfi0Go00000onJZN400ol0003o
VJ;KoiVRf`06oiVRf`03o`000?nIVmCoVI_D00CoVI_D00?o0000oiREconHULl01?nHULl00ol0003o
Ui3:oiN@bP05oiN@bP03o`000?nGS<KoUhc600CoUhc600?o0000oiJ8`_nFR<801OnFR<800ol0003o
UHFoo`000002o`0000;oT8K400?o0000oi24`on@Q<<01On@Q<<2o`0000KoT8C200?o0000oi63`OnA
Pl401?nAPl400ol0003oTXC1oi:4`@06oi:4`@03o`000?nBQL;oTXG200GoTXG200?o0000oi>7`onC
Ql<01_nCQl<00ol0003oU8W5oiB9a@05oiB9a@03o`000?nESLSo000000;o00001onLd?X2o`0000@0
Tj7N00<0000006mba@1_L/D00`1_L/D00`000000GeZd0000000307]ia@030000001[HKD0Jf6e00<0
Jf6e00<0000006EF[@1UEZd00P1UEZd2000000D0Kej^00<0000006aGZ@1/EjT0101/EjT00`000000
JeFW06]EY`0306]EY`8000001P1cFZH00`000000LURUo`000004079HY@030000001bFJH0LUVV00D0
LUVV1000000200d0?@070000000603D0000001l0A0000000QX760000000206]J[@050000002IU/l0
VIK?09VFc`000000103oool00ol00000oooo0?ooo`0B0?ooo`00403oool01?l00000oooo0?ooool0
00040?ooo`04o`00003oool0ooooo`0000OoYl3[00?o0000ojNfi?nW]^@00ol00002oiZbj@03o`00
0?nJZN7oVZWQ00CoVZWQ00?o0000oiVRfonIX]/01OnIX]/00ol0003oVI_DoiVKe004oiVKe003o`00
0?nHULooV9G?00GoV9G?00?o0000oiN@b_nGT<X01?nGT<X00ol0003oUhc6oiN<aP05oiN<aP04o`00
0?nFR<;oUXS2oiJ8`PGo00001_n@Q/@01?l0003oT8C3oi24`on@Q<<3o`000003oi24`ol0003oT8C2
00GoT8C200?o0000oi63`OnAPl401OnAPl400ol0003oTXC1oi:4`@05oi:4`@03o`000?nBQL;oTXG2
00KoTXG200?o0000oi>7`onCQl<01OnCQl<00ol0003oU8W5oiB9a@04oiB9a@Co00001onLd?X2o`00
00030<GPk0000000Tj7N00@0Tj7N00<0000006mba@1_L/D00P1_L/D00`000000GeZd05mJ]0020000
000307]ia@000000Jf6e00@0Jf6e00<0000006EF[@1UEZd00`1UEZd2000000@0Kej^00<0000006aG
Z@1/EjT0101/EjT00`000000JeFW06]EY`0406]EY`8000001@1cFZH010000000LURU079HYOl00003
079HY@030000001bFJH0LUVV00D0LUVV0P0000001P0001`0000000d0?@0000001P0e000000807`14
00@0000008J1aP26PLH000000P1[FZd010000000VIK?09VFc`0000050?ooo`03o`00003oool0oooo
0140oooo000@0?ooo`04o`00003oool0ooooo`0000@0oooo0_l000020?ooo`03o`000?nW`>_oYl3[
00CoYl3[0ol00006oiZbj@03o`000?nJZN7oVZWQ00CoVZWQ00?o0000oiVRfonIX]/01OnIX]/00ol0
003oVI_DoiVKe004oiVKe003o`000?nHULooV9G?00CoV9G?00?o0000oiN@b_nGT<X00_nGT<X>o`00
00?oShO700?o0000oi26a?n@Q/@01On@Q/@4o`0000CoT8C300?o0000oi24`_n@Q<801On@Q<800ol0
003oTH?1oi63`@04oi63`@03o`000?nBQ<7oTXC100KoTXC100?o0000oi:5`_nBQL801OnBQL800ol0
003oThO3oi>7``06oi>7``03o`000?nDRLGo000000?o00001?nM_Nl00ol0003oW=3joic@nP02oic@
nP;o000000<0aN3/0000000000000`00000309>QgP030000001_L/D0Kg;500<0Kg;500@0000005mJ
]01OF[@0GeZd0P00000606]Q]@030000001UEZd0IEJ]0080IEJ]00<0000006=BZ@000000101_GZh0
0`000000K5NY06aGZ@0306aGZ@030000001[EJL0JeFW00@0JeFW00<0000006aGZ0000000101cFZH0
10000000LURU079HYOl00003079HY@030000001bFJH0LUVV00D0LUVV0P0000001P0001`0000000d0
?@0000001P0e000000807`1400@0000008J1aP26PLH000000`1[FZd00`000000VIK?000000040?oo
o`;o00004`3oool00100oooo00Co00000?ooo`3ooooo0000103oool00ol00000oooo0?ooo`020?oo
o`03o`000?nW`>_oYl3[00?o00000_nH_?000ol0003oV[;YoiZbj@04oiZbj@03o`000?nJZN7oVZWQ
00GoVZWQ00?o0000oiVRfonIX]/01?nIX]/00ol0003oVI_DoiVKe004oiVKe003o`000?nHULooV9G?
00;oV9G?1ol00003ohn=cP03o`000?n?R/[oSh[:00CoSh[:00?o0000ohn7aon?QlL01On?QlL00ol0
003oT8K4oi26a002oi26a0?o00002?n@Q<<00ol0003oT8C2oi24`P04oi24`P03o`000?nAPl7oTH?1
00GoTH?100?o0000oi:4`OnBQ<401OnBQ<400ol0003oTXG2oi:5`P05oi:5`P03o`000?nCQl?oThO3
00CoThO31?l00009oifmk`04o`000?nLd?[o0000o`0000<000000`2BY^<010000000IFo700000000
000209>QgP030000001_L/D0Kg;50080Kg;500<0000005mJ]01OF[@00P1OF[@2000000D0Jf6e00<0
000006EF[@1UEZd00P1UEZd010000000He:Y06=BZ@00000306mN[P030000001/EjT0K5NY00<0K5NY
00<0000006]EY`1[EJL0101[EJL010000000K5NX06aGZ000000307=JYP050000001bF:D0LURU079H
YOl000000`1bF:D00`000000LUVV079IYP04079IYP<000000P0=03d2000000<07`1400@0000008J1
aP26PLH00000101[FZd2000000H0oooo00?o00000?ooo`3oool0403oool00100oooo00Co00000?oo
o`3ooooo0000103oool00ol00000oooo0?ooo`030?ooo`;o00001_nH_?000ol0003oV[;YoiZbj@04
oiZbj@03o`000?nJZN7oVZWQ00CoVZWQ00?o0000oiVRfonIX]/01OnIX]/01?l0003oVI_DoiVKe?nI
Vm@7o`0000?oSY;B00?o0000ohn=c_n?SLh01On?SLh00ol0003oSh[:ohn:bP04ohn:bP03o`000?n?
QlOoShO700CoShO700?o0000oi26a?l000000_l00003oi26a003o`000?n@Q<?oT8C300GoT8C300?o
0000oi24`_n@Q<801?n@Q<800ol0003oTH?1oi63`@05oi63`@03o`000?nBQ<7oTXC100GoTXC100?o
0000oi:5`_nBQL801_nBQL800ol0003oThO3o`000003o`0000;oVjkT00?o0000oifmkonM_Nl02?nM
_Nl2o`0000030<cVj@000000TZKS00H0TZKS00H0000006E_a`1UKlL0000009>QgP00000406mba@03
0000001OF[@0GeZd00<0GeZd00<0000006]Q]@1[HKD00`1[HKD00`000000IEJ]06EF[@0306EF[@04
0000001SDZT0He:Y00000080Kej^00<0000006aGZ@1/EjT0101/EjT00`000000JeFW06]EY`0406]E
Y`040000001/EjP0K5NX00000080LeZV00<00000079HY@1bF:D00P1bF:D01?l00000LURU079HY@00
0007079IYP8000000P0=03d2000000<07`1400@0000008J1aP26PLH000001@1[FZd2000000H0oooo
00?o00000?ooo`3oool03`3oool00100oooo00Co00000?ooo`3ooooo00000`3oool2o`0000L0oooo
00?o0000oiRll?nH_?001?nH_?000ol0003oV[;YoiZbj@04oiZbj@03o`000?nJZN7oVZWQ00CoVZWQ
00?o0000oiVRfonIX]/00_nIX]/6o`0000?oSYOG00?o0000ohjBd_n>T]801On>T]800ol0003oShg>
ohn=cP04ohn=cP03o`000?n?R/[oSh[:00CoSh[:00?o0000ohn7aon?QlL00on?QlL3o`0000KoT8K4
00?o0000oi24`on@Q<<01On@Q<<00ol0003oT8C2oi24`P05oi24`P03o`000?nAPl7oTH?100GoTH?1
00?o0000oi:4`OnBQ<401OnBQ<401?l0003oTXG2oi:5`_nBQL86o`0000OoVjkT00?o0000oifmkonM
_Nl01OnM_Nl3o`0000<0c>KY00<0000009:Vh`2BY^<0102BY^<010000000IFo706E_a`1UKlL20000
00D0Kg;500<0000005mJ]01OF[@00P1OF[@2000000@0Jf6e00<0000006EF[@1UEZd00`1UEZd01`00
0000He:Y06=BZ@1SDZT0000006mN[P0000001P1/EjT00`000000JeFW06]EY`0406]EY`070000001/
EjP0K5NX06aGZ0000000LeZV00000004079HY@04o`00001bF:D0LURU000000L0LUVV00@0000000d0
?@0=03d03@0m0P00000301l0A00500000026PLH0QX7608J1aP0000001@1[FZd00`000000oooo0?oo
o`040?ooo`03o`00003oool0oooo00l0oooo000A0?ooo`;o0000103oool00ol00000oooo0?ooo`07
0?ooo`03o`000?nH_?3oV;c`00CoV;c`00?o0000oiZbjOnJ/^T00onJ/^T00ol0003oVZWQoiZYh@02
oiZYh@Oo00000on=WMh00ol0003oSYOGohjGe`04ohjGe`03o`000?n>T];oSY;B00CoSY;B00?o0000
ohn=c_n?SLh01?n?SLh00ol0003oSh[:ohn:bP04ohn:bP03o`000?n?QlOoShO700?o00000_n?QlL0
0ol0003oT8K4oi26a004oi26a003o`000?n@Q<?oT8C300KoT8C300?o0000oi24`_n@Q<801?n@Q<80
0ol0003oTH?1oi63`@05oi63`@03o`000?nBQ<7oTXC100?oTXC11_l00004oiRRg003o`000?nK[^Co
VjkT00OoVjkT00?o0000oifmkonM_Nl00_nM_Nl2o`000003ofGH`ol00000c>KY00@0c>KY00<00000
09:Vh`2BY^<00`2BY^<00`000000IFo706E_a`0306E_a`8000000`1_L/D00`000000GeZd05mJ]002
05mJ]0030000001JCj`0000000<0Jf6e00<0000006EF[@1UEZd00`1UEZd00`000000He:Y06=BZ@02
06=BZ@8000001P1/EjT00`000000JeFW06]EY`0406]EY`030000001/EjP0K5NX0080K5NX00<00000
07=JYP000000101bF:D00ol00000LURU00000007079IYP050000000=03d03@0m00d0?@000000100O
04@01@000000QX7608J1aP26PLH0000000D0JeZ]00<000000?ooo`3oool0103oool2o`000100oooo
000G0?ooo`03o`00003oool0oooo00P0oooo00Co0000oiRll?nH_?3oV;c`3Ol00003ohbTi@03o`00
0?n=WMkoSIgN00GoSIgN00?o0000ohjGeon>UmL00on>UmL00ol0003oSY;BohjBdP04ohjBdP03o`00
0?n?SLkoShg>00GoShg>00?o0000ohn:b_n?R/X00on?R/X3o`0000GoShO700?o0000oi26a?n@Q/@0
1On@Q/@00ol0003oT8C3oi24``05oi24``03o`000?n@Q<;oT8C200CoT8C200?o0000oi63`OnAPl40
1OnAPl400ol0003oTXC1oi:4`@03o`0000;oUI[F00?o0000oiRRg?nHX]`01_nHX]`00ol0003oVjkT
oi^^i007oi^^i003o`000?nM_Noo000000Co00001`3<i^T00`000000TZKS09:Vh`0309:Vh`030000
001UKlL0IFo70080IFo700<00000059C]@0000000P1_L/D00`000000GeZd05mJ]00305mJ]0030000
001JCj`0000000<0Jf6e00<0000006EF[@1UEZd00P1UEZd00`000000He:Y06=BZ@0306=BZ@800000
1@1/EjT00`000000JeFW06]EY`0406]EY`030000001/EjP0K5NX00<0K5NX0P000005079HY@03o`00
001bF:D0000000H0LUVV00D0000000d0?@0=03d03@0m0000000401l0A00500000026PLH0QX7608J1
aP0000001@1[FZd00`000000oooo0?ooo`050?ooo`03o`00003oool0oooo00h0oooo000G0?ooo`;o
00002P3oool3o`0000?oQKGd00?o0000ohV/kOn9[>d00on9[>d00ol0003oS:CUohbTi@05ohbTi@03
o`000?n=WMkoSIgN00CoSIgN00?o0000ohjGeon>UmL01?n>UmL00ol0003oSY;BohjBdP04ohjBdP03
o`000?n?SLkoShg>00CoShg>00Co0000ohn:b_n?R/[oSh[:0_l000000on?R/[o0000ohn7a`06ohn7
a`03o`000?n@Q/CoT8K400CoT8K400?o0000oi24`on@Q<<01On@Q<<00ol0003oT8C2oi24`P05oi24
`P04o`000?nAPl7oTH?1oi63`@Ko00001_nEV]H00ol0003oV:;LoiRRg006oiRRg003o`000?nK[^Co
VjkT00KoVjkT1Ol00002000000D0c>KY1@00000309:Vh`030000001UKlL0IFo70080IFo700@00000
059C]@1BDkD000000P1_L/D00`000000GeZd05mJ]00205mJ]0040000001JCj`0FTn/00000080Jf6e
00<0000006EF[@1UEZd00P1UEZd00`000000He:Y06=BZ@0406=BZ@030000001/EjT0K5NY00<0K5NY
00<0000006]EY`1[EJL01@1[EJL00`000000K5NX06aGZ00306aGZ08000001@1bF:D00ol000000000
079IYP06079IYP040000000=03d00000000000<07`140P00000308J1aP030000001[FZd0JeZ]00@0
JeZ]00<000000?ooo`3oool01@3oool00ol00000oooo0?ooo`0=0?ooo`005`3oool00ol00000oooo
0?ooo`0;0?ooo`03o`000?n5]OCoQKGd00;oQKGd00?o0000ohV/kOn9[>d00on9[>d00ol0003oS:CU
ohbTi@04ohbTi@03o`000?n=WMkoSIgN00GoSIgN00?o0000ohjGeon>UmL01?n>UmL00ol0003oSY;B
ohjBdP03ohjBdP03o`000?n?SLkoShg>00GoShg>0ol00004ohn:bP03o`000?n?QlOoShO700CoShO7
00?o0000oi26a?n@Q/@01?n@Q/@00ol0003oT8C3oi24``06oi24``04o`000?n@Q<;oT8C2oi24`POo
00001?nBU=400ol0003oUI[FoiFJeP06oiFJeP03o`000?nHX]coV:;L00GoV:;L00?o0000oi^^i?nK
[^@00onK[^@3o`0000;oSn_c0_l000000`000000io[:0>OjbP05000000<0VkK[00H0000005mac@00
0000000009:Vh`00000506E_a`060000001BDkD0DU>e0000001_L/D00000101OF[@01`000000FTn/
05Y?[01JCj`0000006]Q]@0000001@1UEZd00`000000He:Y06=BZ@0306=BZ@8000001@1/EjT00`00
0000JeFW06]EY`0406]EY`030000001/EjP0K5NX00<0K5NX00@0000006mL[@00000000000`1bF:D0
0ol000000000079IYP06079IYP040000000=03d00000000000<07`140P00000308J1aP030000001[
FZd0JeZ]00@0JeZ]00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`0<0?ooo`005`3oool0
0ol00000oooo0?ooo`0<0?ooo`03o`000?n5]OCoQKGd00;oQKGd00?o0000ohV/kOn9[>d00on9[>d0
0ol0003oS:CUohbTi@04ohbTi@03o`000?n=WMkoSIgN00CoSIgN00?o0000ohjGeon>UmL01?n>UmL0
0ol0003oSY;BohjBdP04ohjBdP04o`000?n?SLkoShg>ohn=cPCo00001_n?R/X00ol0003oShO7ohn7
a`04ohn7a`03o`000?n@Q/CoT8K400GoT8K400Co0000oi24`on@Q<?oT8C32?l00003oi2?c`03o`00
0?nBU=7oTYCA00KoTYCA00?o0000oiFJe_nEV]H01OnEV]H00ol0003oV:;LoiRRg006oiRRg003o`00
0?nK[^Co000000;o00000on?jo<2o`0000030>Oj]0000000io[:0080io[:0P00000709^fj`030000
001OLLd0Gg7=00<00000101UKlL010000000DU>e059C]@1BDkD2000000@0GeZd00<0000005Y?[01J
Cj`00P1JCj`2000000D0IEJ]00<0000006=BZ@1SDZT00`1SDZT00`000000I5>Y0000000406aGZ@03
0000001[EJL0JeFW00@0JeFW00<0000006aGZ01/EjP00`1/EjP010000000Keb]06mL[@1_G:d20000
0080LURU00?o0000079IYP1bFJH01@1bFJH2000000060140<@0000007`1401l0A0000000600T0P00
000308J1aP030000001[FZd0JeZ]00<0JeZ]00<000000?ooo`3oool01P3oool00ol00000oooo0?oo
o`070?ooo`?o00000P3oool001H0oooo0ol0000>0?ooo`03o`000?n5]OCoQKGd00;oQKGd00?o0000
ohV/kOn9[>d00on9[>d00ol0003oS:CUohbTi@04ohbTi@03o`000?n=WMkoSIgN00CoSIgN00?o0000
ohjGeon>UmL01?n>UmL00ol0003oSY;BohjBdP03ohjBdPCo00000on?SLh00ol0003oSh[:ohn:bP04
ohn:bP03o`000?n?QlOoShO700;oShO73_l00004ohj<c@03o`000?n@SlooT8o?00GoT8o?00?o0000
oi:DdOnBU=401OnBU=400ol0003oUI[FoiFJeP06oiFJeP03o`000?nHX]coV:;L00GoV:;L1Ol00002
oho[l`04o`00003Wn[@0ioZd000000<0io[:00@000000=W_h@3Ikn4000001P2K]^/00`000000Gg7=
05mac@0205mac@030000001UKlL0IFo70080IFo700<00000059C]@1BDkD00P1BDkD2000000@0GeZd
00<0000005Y?[01JCj`00P1JCj`2000000@0IEJ]00<0000006=BZ@1SDZT0101SDZT00`000000I5>Y
0000000306aGZ@030000001[EJL0JeFW00@0JeFW00<0000006aGZ01/EjP0101/EjP00`000000Keb]
06mL[@0206mL[@040000001bF:D00000o`0000H0LUVV0P0000002@0A0340000001l0A00O04@00000
01P090000000HU>/0000000208J1aP030000001[FZd0JeZ]00<0JeZ]00<000000?ooo`3oool01P3o
ool2o`0000T0oooo00?o00000?ooo`3oool00@3oool001H0oooo00?o00000?ooo`3oool03`3oool4
o`000003ohFem?l0003oRJc]00CoRJc]00?o0000ohbTiOn<Y>D00on<Y>D00ol0003oSIgNohfMgP04
ohfMgP03o`000?n>UmOoSYOG00CoSYOG00Co0000ohjBd_n>T];oSY;B0ol00004ohn=cPko00000on;
R/d00ol0003oS8_<ohb;c004ohb;c003o`000?n>S<goSXc=00KoSXc=00?o0000oi2?con@Sll01?n@
Sll00ol0003oTYCAoi:Dd@06oi:Dd@03o`000?nEV]KoUI[F00GoUI[F00?o0000oiRRg?nHX]`00_nH
X]`3o`0000GoWmkm0_l000000`000000ioZd000000030>OjbP030000003Ikn40fNoQ0080fNoQ00<0
000009^fj`2K]^/00`2K]^/00`000000Gg7=05mac@0205mac@8000000`1UKlL00`000000DU>e059C
]@03059C]@030000001OF[@0GeZd0080GeZd00<0000005Y?[01JCj`00`1JCj`00`000000IEJ]06EF
[@0206EF[@030000001SDZT0He:Y00@0He:Y00@0000006ACZ@1TDjT000000P1/EjT00`000000JeFW
06]EY`0506]EY`030000001/EjP0K5NX00<0K5NX00<0000006mL[@1_G:d00`1_G:d300000003o`00
001bFJH0LUVV00@0LUVV00<000000140<@0000000P0O04@00`000000600T00000002069C[0030000
0026PLH0000000D0JeZ]00<000000?ooo`3oool0203oool00ol00000oooo0?ooo`030?ooo`Go0000
0P3oool001H0oooo00?o00000?ooo`3oool03`3oool01?l0003oK:_fofb[m_m/ZoHVo`0000?oQhcA
00?o0000ohV;con9Rll01?n9Rll00ol0003oRh[=oh^:c@05oh^:c@03o`000?n<RlcoS8_<00CoS8_<
00?o0000ohj<cOn>S<d01On>S<d00ol0003oT8o?oi2?c`05oi2?c`03o`000?nBU=7oTYCA00GoTYCA
00?o0000oiFJe_nEV]H01_nEV]H01?l0003oV:;Lo`000?l00006oioNo@;o000000D0h?NT0000003W
n[@0ioZd000000020>OjbP030000003Ikn40fNoQ00<0fNoQ00<0000009^fj`2K]^/0102K]^/00`00
0000Gg7=05mac@0205mac@8000000`1UKlL00`000000DU>e059C]@02059C]@030000001OF[@0GeZd
0080GeZd00<0000005Y?[01JCj`00`1JCj`00`000000IEJ]06EF[@0206EF[@030000001SDZT0He:Y
00@0He:Y00L0000006ACZ@1TDjT0I5>Y0000001/EjT0000000L0JeFW00<0000006aGZ01/EjP00`1/
EjP00`000000Keb]06mL[@0506mL[@0300000?l00000LUVV00D0LUVV00D000000140<@0000007`14
0000000201P090040000001RDj`0HU>/069C[08000001P1[FZd00`000000oooo0?ooo`070?ooo`03
o`00003oool0oooo00<0oooo00Co00000?ooo`3ooooo00000`3oool001H0oooo00?o000000000000
0000403oool00ol0003oK:_fofb[mP02ofb[mP03o`000?mdXnooM:?_00?oM:?_00?o0000ogZLiomj
W>L00omjW>L00ol0003oOiOPognGh004ognGh004o`000?n2T][oPY;Joh:BfPCo00001On5S]D00ol0
003oQhcAohN<d@05ohN<d@03o`000?n9RlooRH_?00CoRH_?00?o0000oh^:cOn;R/d01?n;R/d00ol0
003oS8_<ohb;c004ohb;c003o`000?n>S<goSXc=00KoSXc=00?o0000oi2?con@Sll01On@Sll00ol0
003oTYCAoi:Dd@05oi:Dd@03o`000?nEV]KoUI[F00CoUI[F1?l00005oioNo@;o000000<000000>3g
Y00000000P3Wn[@010000000io[:0>OjbP0000060=W_h@@000000`2K]^/00`000000Gg7=05mac@02
05mac@0300000016C[H000000080IFo700<00000059C]@1BDkD00P1BDkD2000000<0GeZd00<00000
05Y?[01JCj`00`1JCj`2000000@0IEJ]00<0000006=BZ@1SDZT00`1SDZT00`000000I5>Y06ACZ@02
06ACZ@030000001/EjT0000000H0JeFW00<0000006aGZ01/EjP0101/EjP00`000000Keb]06mL[@04
06mL[@040000001dJKSo0000000000@0LUVV0P00000201l0A0040000000H02@00000000000@0HU>/
0P00000506]J[@030000003oool0oooo00P0oooo00?o00000?ooo`3oool00`3oool00ol00000oooo
o`0000030?ooo`000`3oool2o`0000@0oooo00?o00000?ooo`3oool00P3oool3o`0000D0oooo00?o
00000?ooo`3oool04@3oool00ol0003oK:_fofb[mP02ofb[mP03o`000?mdXnooM:?_00?oM:?_00?o
0000ogZLiomjW>L00omjW>L00ol0003oOiOPognGh004ognGh0?o00001?n2T]X00ol0003oQHkEohF>
e@03ohF>e@03o`000?n7S=7oQhcA00CoQhcA00?o0000ohV;con9Rll01?n9Rll00ol0003oRh[=oh^:
c@05oh^:c@03o`000?n<RlcoS8_<00CoS8_<00?o0000ohj<cOn>S<d01On>S<d00ol0003oT8o?oi2?
c`05oi2?c`03o`000?nBU=7oTYCA00GoTYCA00?o0000oiFJe_nEV]H01?l00004oio9m@;o000000Go
Wmkmo`000?l0000000000=OdW00200000080ioZd1P0000020=W_h@<0000000@0/Lk_0000001QO=L0
HGcG1000000405mac@0600000016C[H0ATjf0000001UKlL000001@1BDkD2000000<0GeZd00<00000
05Y?[01JCj`00`1JCj`2000000<0IEJ]00<0000006=BZ@1SDZT00`1SDZT00`000000I5>Y06ACZ@03
06ACZ@8000001P1[EJL00`000000K5NX06aGZ00406aGZ0030000001_G:d0Keb]00@0Keb]00@00000
07AY^01dJKSo00000`0000001@1bFJH000000000000O04@000000080600T0P000005069C[0030000
001[FZd0JeZ]00<0JeZ]00<000000?ooo`3oool01`3oool200000003o`00003oool0oooo00<0oooo
0_l000030?ooo`000P3oool01?l00000oooo0?ooool000070?ooo`05o`00003oool0oooo0?ooool0
0000103oool00ol00000oooo0?ooo`0B0?ooo`03o`000?m/ZoKoK:_f00;oK:_f00?o0000ogBSkomd
Xnl00omdXnl00ol0003oNYcWogZLi`03ogZLi`04o`000?moUn3oOiOPognGh0?o00001_n2T]X00ol0
003oQHkEohF>e@04ohF>e@03o`000?n7S=7oQhcA00CoQhcA00?o0000ohV;con9Rll01?n9Rll00ol0
003oRh[=oh^:c@04oh^:c@03o`000?n<RlcoS8_<00GoS8_<00?o0000ohj<cOn>S<d01?n>S<d00ol0
003oT8o?oi2?c`06oi2?c`03o`000?nBU=7oTYCA00?oTYCA1?l00009oio9m@?o00000`0000000`3P
mj@000000000000200000080l?Nb00<000000>of`03_m/000P0000050;7>k`030000001QO=L0HGcG
0080HGcG0P00000405mac@0300000016C[H0ATjf008000001@1BDkD00`000000CTV/0000000205mJ
]0030000001JCj`0FTn/00<0FTn/00<0000005Y=Z@0000000P1UEZd00`000000He:Y06=BZ@0406=B
Z@030000001TDjT0I5>Y00<0I5>Y0P00000506]EY`030000001/EjP0K5NX00@0K5NX00<0000006mL
[@1_G:d01@1_G:d00`000000M6Vho`00000307AY^0<0000000@07`140000000H02@0600T0P000005
069C[0030000001[FZd0JeZ]00<0JeZ]00<000000?ooo`3oool0103oool4000000030?ooool00000
oooo00D0oooo00?o00000?ooo`3oool00@3oool00080oooo00Co00000?ooo`3ooooo00002`3oool0
1?l00000oooo0?ooo`3oool3o`0001@0oooo1?l000000om/ZoKo0000ogBSk`04ogBSk`03o`000?mj
W>OoNYcW00?oNYcW0ol00003ognGh003o`000?n2T][oPY;J00CoPY;J00?o0000ohF>eOn5S]D00on5
S]D00ol0003oQhcAohN<d@05ohN<d@03o`000?n9RlooRH_?00?oRH_?00?o0000oh^:cOn;R/d01On;
R/d00ol0003oS8_<ohb;c004ohb;c003o`000?n>S<goSXc=00GoSXc=00?o0000oi2?con@Sll01On@
Sll00ol0003oTYCAoi:Dd@03o`0000CoVkK[00?o0000oio9mOnObOD01?nObOD2o`000003oiKaj?l0
003o00000080000000D0h?NT000000000000kON[000000020?3g/P040000003_m/00koK00>of`080
00001P2ac^l00`000000HGcG065le`02065le`8000000`1OLLd010000000ATjf04I>]P16C[H20000
00@0DU>e00H0000004i9[01>BJ`0000005mJ]000000505Y?[0060000001JCJT0FTfY0000001UEZd0
00001P1SDZT00`000000I5>Y06ACZ@0306ACZ@030000001XF:d0000000D0JeFW00<0000006aGZ01/
EjP00`1/EjP00`000000Keb]06mL[@0506mL[@040000001dJKP0M6Vho`0000@0M6Vh0P00000301P0
908000001@1RDj`2000000D0JeZ]00<000000?ooo`3oool00`0000050?ooo`03o`00003oool0oooo
00P0oooo00020?ooo`04o`00003oool0ooooo`0000/0oooo00Go00000?ooo`3oool0ooooo`00000H
0?ooo`03o`000?m<Vo?o000000Ko000000?oM:?_o`000?mjW>L00ol000000omjW>Oo0000ognGh004
ognGh003o`000?n2T][oPY;J00?oPY;J00?o0000ohF>eOn5S]D01?n5S]D00ol0003oQhcAohN<d@04
ohN<d@03o`000?n9RlooRH_?00?oRH_?00?o0000oh^:cOn;R/d01On;R/d00ol0003oS8_<ohb;c005
ohb;c003o`000?n>S<goSXc=00CoSXc=00?o0000oi2?con@Sll00_n@Sll6o`0000SoVkK[00?o0000
oio9mOnObOD00_nObOD00ol0003oU_7XoiKaj002o`0000040000003Gm9`0000000000080kON[00@0
00000?3g/P3`mk8000000`3_m/0010000000io?B0>OcdP0000050;7>k`030000001QO=L0HGcG00<0
HGcG0P00000205mac@0300000016C[H0ATjf0080ATjf00<00000059C]@1BDkD00P1BDkD010000000
CTV/04i9[01>BJ`2000000D0FTn/00@0000005Y=Z@1JCJT0FTfY0P00000606=BZ@030000001TDjT0
I5>Y00<0I5>Y00<0000006QH[@1XF:d00P00000306]EY`030000001/EjP0K5NX00@0K5NX00<00000
06mL[@1_G:d0101_G:d01@000000M6Vh07AY^01dJKSo000000<0M6Vh0P00000301P090030000001i
M/<0000000D0HU>/0P00000406]J[@<00000203oool00ol00000oooo0?ooo`080?ooo`000P3oool0
1?l00000oooo0?ooool000070?ooo`Co0000103oool00ol00000oooo0?ooo`0G0?ooo`05o`000?m<
Vo?oC9_codbKlol000000omKUnl<o`000003ognGh?l0003oPY;J00GoPY;J00?o0000ohF>eOn5S]D0
0on5S]D00ol0003oQhcAohN<d@05ohN<d@03o`000?n9RlooRH_?00?oRH_?00?o0000oh^:cOn;R/d0
1On;R/d00ol0003oS8_<ohb;c004ohb;c003o`000?n>S<goSXc=00;oSXc=1ol00004oiNXhP03o`00
0?nK]^_oVkK[00SoVkK[00Co0000oio9mOl0003o00000_nFlNP2o`0000030<kdWP00000000000080
000000<0kON[0000003`mk800P3`mk8010000000koK00>of`00000030>OcdPH0000000<0/Lk_0000
001QO=L00`1QO=L00`000000>DZi0000000205mac@0500000016C[H0ATjf04I>]P0000001@1BDkD0
10000000CTV/04i9[01>BJ`2000000D0FTn/00@0000005Y=Z@1JCJT0FTfY0P00000506=BZ@030000
001TDjT0I5>Y00@0I5>Y00D0000006QH[@1XF:d0J5R]0000000206]EY`030000001/EjP0K5NX00@0
K5NX00<0000006mL[@1_G:d01@1_G:d01@000000M6Vh07AY^01dJKSo000000<0M6Vh00L0000001P0
900H02@0600T0000001iM/<0000000D0HU>/0P00000406]J[@030000003oool0oooo00P0oooo00?o
00000?ooo`3oool0203oool00080oooo00Co00000?ooo`3ooooo00001`3oool00ol00000oooo0?oo
o`050?ooo`;o00006@3oool01?l0003oC9_codbKlom<Vo<3o`0000;oFiO_00?o0000ofJCj?mVTnP0
0omVTnP01?l0003oKhoRofn?h_m_Sn87o`000003oh:Bf_l0003oQHkE00GoQHkE00?o0000ohN<dOn7
S=401?n7S=400ol0003oRH_?ohV;c`03ohV;c`03o`000?n;R/goRh[=00GoRh[=00?o0000ohb;c?n<
Rl`00_n<Rl`7o`0000?oTYkL00?o0000oiNXh_nGZ>801_nGZ>800ol0003oVkK[oi^fj`07oi^fj`Oo
00000P0000000`3Gm9`00000000000020>ggZ`040000003`mk80l?Nb00000080koK000L000000>Oc
dP3Wlm80io?B0000003@iNH0000000@0LiOV10000002065le`060000000iB[T0>DZi0000001OLLd0
00000`16C[H2000000@0DU>e00<0000004i9[01>BJ`00P1>BJ`00`000000FTn/05Y?[00305Y?[003
0000001JCJT0FTfY0080FTfY0P00000406=BZ@030000001TDjT0I5>Y00@0I5>Y00<0000006QH[@1X
F:d00P1XF:d3000000H0K5NX00<0000006mL[@1_G:d01@1_G:d01@000000M6Vh07AY^01dJKSo0000
00<0M6Vh00L0000001P0900H02@0600T0000001iM/<0000000D0HU>/00<0000005a;Y@0000000`1[
FZd00`000000oooo0?ooo`090?ooo`03o`00003oool0oooo00L0oooo00030?ooo`;o0000203oool5
o`0000<0oooo00?o00000?ooo`3oool06@3oool3o`000003odbKlol0003oFiO_00?oFiO_00?o0000
ofJCj?mVTnP00omVTnP00ol0003oKhoRofn?hP02ofn?hP03o`000?mfSMcoMXgL00;oMXgL8_l00003
ohfFf003o`000?nBW]coTYkL00GoTYkL00?o0000oiNXh_nGZ>801_nGZ>800ol0003oVkK[oi^fj`03
oi^fj`?o00000onVj?/2o`000009oj_ga?l0000000000=OdW0000000jONY0000003]mj/000000080
l?Nb00D000000>of`03_m/00koK0000000020>OcdP050000003@iNH0d>GV0=3UiP0000001@1cUnH0
0`000000;dbo00000002065le`030000000iB[T0>DZi008000001016C[H2000000<0DU>e00<00000
04i9[01>BJ`00P1>BJ`00`000000FTn/05Y?[00305Y?[0030000001JCJT0FTfY0080FTfY00<00000
05iAZ`000000101SDZT00`000000I5>Y06ACZ@0306ACZ@030000001XF:d0J5R]00@0J5R]0P000005
06aGZ0030000001_G:d0Keb]00D0Keb]00<0000007AY^01dJKP00P1dJKP01?l00000M6Vh07AY^000
000301P090030000001iM/<0000000D0HU>/00@0000005a;Y@1LBjD000000P1[FZd00`000000oooo
0?ooo`090?ooo`03o`00003oool0oooo00L0oooo000E0?ooo`03o`00003oool0oooo01H0oooo0ol0
00020?ooo`Co00001?mKUnl00ol0003oIY?XofJCj002ofJCj003o`000?m_Sn;oKhoR00?oKhoR00?o
0000ogJ=g?mfSM`00omfSM`00ol0003oNhcHog^<f004og^<f003o`000?n0S=KoP8cF00CoP8cF00?o
0000ohF>eOn5S]D00on5S]D00ol0003oRI7EohVAe@05ohVAe@03o`000?n=U]SoSIKH00GoSIKH00?o
0000oi:Ng?nBW]`01OnBW]`00ol0003oUjSRoiNXhP06oiNXhP03o`000?nK]^_o000000;o00001?nV
j?/3o`000003oj_ga?l00000c_BN0080000000@0jONY0000003]mj/000000P3`mk801@000000koK0
0>of`03_m/0000000080io?B00<000000=3UiP3@iNH00`3@iNH00`000000LiOV07>GiP0307>GiP05
0000000_C;l00000065le`0000000`0iB[T2000000<0ATjf00<000000452[00000000`1BDkD01000
0000CTV/04i9[01>BJ`2000000@0FTn/00<0000005Y=Z@1JCJT00P1JCJT010000000GU6[05iAZ`00
000306=BZ@030000001TDjT0I5>Y00@0I5>Y00<0000006QH[@1XF:d0101XF:d2000000D0K5NX00<0
000006mL[@1_G:d0101_G:d00`000000M6Vh07AY^00307AY^007o`00001dJKP0M6Vh0000000H02@0
000005U>Z`02000000D0HU>/00D0000005a;Y@1LBjD0G4^U0000000206]J[@030000003oool0oooo
00P0oooo00?o00000?ooo`3oool01`3oool001D0oooo0_l0000D0?ooo`?o00001P3oool00ol0003o
9XK[obJ6j`04o`000003oe^Gkol0003oIY?X00?oIY?X00?o0000ofn?h_m_Sn800om_Sn800ol0003o
MXgLogJ=g003ogJ=g003o`000?mkS=SoNhcH00CoNhcH00?o0000oh2<e_n0S=H01?n0S=H00ol0003o
QHkEohF>e@03ohF>e@03o`000?n9TMGoRI7E00GoRI7E00?o0000ohfFf?n=U]P01?n=U]P00ol0003o
TYkLoi:Ng006oi:Ng003o`000?nGZ>;oUjSR00GoUjSR0ol00004ojKXn`Co000000?oZoO4o`000000
0000100000020>ggZ`040000003`mk80l?Nb00000080koK000@000000>OcdP3Wlm8000001`3@iNH0
0`000000LiOV07>GiP0207>GiP060000000_C;l0;dbo0000001QO=L000000`0iB[T01@000000ATjf
04I>]P16C[H000000080@D:/00@00000059C]@1BDkD00000101>BJ`2000000<0FTn/00<0000005Y=
Z@1JCJT00`1JCJT010000000GU6[05iAZ`00000206=BZ@030000001TDjT0I5>Y00@0I5>Y00<00000
06QH[@1XF:d0101XF:d010000000KfFh00000000000306aGZ0030000001_G:d0Keb]00D0Keb]00<0
000007AY^01dJKP00`1dJKP00ol00000M6Vh0000000200000080FDj[0P000005069C[0040000001L
BjD0G4^U00000080JeZ]00<000000?ooo`3oool0203oool00ol00000oooo0?ooo`070?ooo`00503o
ool2o`0001<0oooo0_l0000:0?ooo`04o`000?lVQ^_o9XK[o`0000;o?HO[1Ol00002ofJCj003o`00
0?m_Sn;oKhoR00?oKhoR00?o0000ogJ=g?mfSM`00_mfSM`00ol0003oNhcHog^<f004og^<f003o`00
0?n0S=KoP8cF00CoP8cF00?o0000ohF>eOn5S]D00on5S]D00ol0003oRI7EohVAe@05ohVAe@03o`00
0?n=U]SoSIKH00GoSIKH00?o0000oi:Ng?nBW]`01OnBW]`00ol0003oUjSRoiNXhP02oiNXhP?o0000
0onUdOL2o`000004ojKXnol0003o0000o`0000;oZoO400?o00000000003>m9h00P000000103YmjT0
00000>ggZ`0000020?3g/PT00000103@iNH500000080LiOV00@0000002m<_`0_C;l0;dbo0P000003
03U:^@0500000016C[H0ATjf04I>]P0000000`11@Z`00`000000DU>e0000000404i9[0030000001@
B:X0000000<0FTn/00<0000005Y=Z@1JCJT00P1JCJT01`000000GU6[05iAZ`1NDJ/0000006=BZ@00
00001P1TDjT00`000000J5R]06QH[@0406QH[@040000001_IKP0KfFh06mU^080000000<0K5NX0000
001_G:d01P1_G:d00`000000M6Vh07AY^00307AY^005o`00001dJKP0000008[Oo@0000000`1ICZ/0
0`000000HU>/069C[003069C[0070000001LBjD0G4^U05a;Y@000000JeZ]0000000:0?ooo`03o`00
003oool0oooo00L0oooo000D0?ooo`03o`00003oool0oooo00l0oooo0ol0000=0?ooo`;o000000?o
9XK[o`000?lmQn/00_lmQn/00ol0003oD8OWoe27i`03o`0000GoKhoR00?o0000ogJ=g?mfSM`00omf
SM`00ol0003oNhcHog^<f004og^<f003o`000?n0S=KoP8cF00CoP8cF00?o0000ohF>eOn5S]D00on5
S]D00ol0003oRI7EohVAe@05ohVAe@03o`000?n=U]SoSIKH00CoSIKH00?o0000oi:Ng?nBW]`01_nB
W]`01?l0003oUjSRo`000?l00007ojGAm`;o000000Co/?Kao`000?n[mlCoZoO40_l000001@3>m9h0
00000000003YmjT000000080kON[100000020?K`/0040000003el;H0mO2f00000080lNo110000003
09o3lP030000000bG<d000000080LiOV00D0000002m<_`0_C;l0;dbo0000000303U:^@8000000`16
C[H010000000@D:/0452[011@Z`2000000@0CTV/00@000000518ZP1@B:X000000P1JCj`00`000000
FTfY05Y=Z@0205Y=Z@030000001NDJ/0GU6[0080GU6[0P00000706ACZ@030000001XF:d0J5R]00@0
J5R]00<0000006mU^01_IKP00P1_IKP3000000H0Keb]00<0000007AY^01dJKP0101dJKP00ol00000
00000000000405U>Z`030000001RDj`0HU>/00<0HU>/00<0000005a;Y@1LBjD00P1LBjD2000000X0
oooo00?o00000?ooo`3oool01`3oool001@0oooo0_l0000=0?ooo`?o00004@3oool4o`0000?o?HO[
00?o0000oe27iom@QnL00_m@QnL5o`000003ofn?h_l0003oMXgL00?oMXgL00?o0000og^<f?mkS=P0
1?mkS=P00ol0003oP8cFoh2<eP04oh2<eP03o`000?n5S]GoQHkE00CoQHkE00?o0000ohVAeOn9TMD0
1?n9TMD00ol0003oSIKHohfFf005ohfFf003o`000?nBW]coTYkL00CoTYkL1?l00006ojGAm`;o0000
0_n`m_400ol0003oZoO4oj_ga002o`000080000000D0iOV^0000003YmjT000000>ggZ`0200000005
0?Gb[P000000m_2`0?K`/00000000P3el;H00`000000lNo10?7_`@020?7_`@030000002O`o80Wl?b
00@0Wl?b00D00000039Lc@000000LiOV0000000402m<_`040000000iB[T0>DZi03U:^@8000000P16
C[H00`000000@D:/0452[0020452[08000000`1>BJ`01`000000D4RZ0518ZP1@B:X0000005Y?[000
00001@1JCJT00`000000GU6[05iAZ`0205iAZ`8000001P1TDjT00`000000J5R]06QH[@0406QH[@03
0000001_IKP0KfFh00@0KfFh1@00000306mL[@030000001dJKP0000000@0000000?o00000000001I
CZ/00`1ICZ/2000000@0HU>/00<0000005a;Y@1LBjD00P1LBjD2000000X0oooo00?o00000?ooo`3o
ool01`3oool001@0oooo00?o00000?ooo`3oool02@3oool3o`0001D0oooo00Co0000o`1Zf_l0003o
00000olmQn/01Ol0003oD8OWoe27iom@QnOo000000CoGhSR1Ol00002ogJ=g003o`000?mkS=SoNhcH
00CoNhcH00?o0000oh2<e_n0S=H00on0S=H00ol0003oQHkEohF>e@04ohF>e@03o`000?n9TMGoRI7E
00GoRI7E00?o0000ohfFf?n=U]P01?n=U]P00ol0003oTYkLoi:Ng004o`0000CoWK_^00?o0000ojGA
monUdOL00_nUdOL01Ol0003o/?Kaok3flOn`m_7o000000;oZoO40_l00004000000040>WgZ@000000
000000000080mO:^00L000000?K`/03fl;00m_2`0000003el;H0000000@0lNo100<000000>S]d000
00001@2O`o800`000000<Uc=039Lc@02000000@0;dbo00@0000003U:^@0iB[T0>DZi0P00000204I>
]P0300000011@Z`0@D:/00<0@D:/00<0000004i9[01>BJ`00P1>BJ`010000000D4RZ0518ZP1@B:X2
000000D0FTfY00<0000005iAZ`1NDJ/00`1NDJ/2000000D0I5>Y00<0000006QH[@1XF:d0101XF:d0
0`000000KfFh06mU^00406mU^0030000001mQ]80OHKB0080OHKB1@00000308[Oo@80000000<0L733
o`00001ICZ/0101ICZ/2000000@0HU>/00<0000005a;Y@1LBjD00P1LBjD2000000X0oooo00?o0000
0?ooo`3oool01P3oool001@0oooo00?o00000?ooo`3oool01P3oool3o`0001T0oooo00?o0000o`1Z
f_l0J]X00ol000000olmQn_o0000oe27i`02oe27i`03o`000?mOR>;oGhSR00?oGhSR00?o0000of^9
g_m[RMh00ol00006og^<f003o`000?n0S=KoP8cF00CoP8cF00?o0000ohF>eOn5S]D01?n5S]D00ol0
003oRI7EohVAe@04ohVAe@03o`000?n=U]SoSIKH00;oSIKH1Ol00009oifkkP04o`000?nUdOOo0000
o`0000?o/?Ka00?o0000oj_ga?l000000_l000001@38n:`00000000000000000jONY0080000000D0
loB`0000003elZh0mO:^000000020?K`/0040000003el;H0mO2f000000<0lNo100D000000>S]d03X
kM00j>g@0000000509o3lP030000000bG<d0<Uc=008000000`0_C;l200000080>DZi00<00000034j
Z`0000000P16C[H00`000000@D:/0452[0020452[0030000001>BJ`0CTV/0080CTV/00<000000518
ZP1@B:X00P1@B:X2000000@0FTfY00<0000005iAZ`1NDJ/00`1NDJ/00`000000IEbc0000000406AC
Z@030000001XF:d0J5R]00D0J5R]00<0000006mU^01_IKP0101_IKP00`000000OHKB07f6dP0607f6
dP030000002:god000000080D4V[00<00000o`00001ICZ/0101ICZ/2000000@0HU>/00<0000005a;
Y@1LBjD00`1LBjD00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo00H0oooo000D0?ooo`;o
0000103oool3o`0001d0oooo0_l000000ol0J][o0000oa]chP03o`0000?oD8OW00?o0000oen8h_mO
R>800omOR>800ol0003oJhWNof^9gP02of^9gPco000000?oP8cFo`000?n5S]D01On5S]D00ol0003o
RI7EohVAe@02ohVAe@Oo00001OnEZnD00ol0003oWK_^oifkkP06oifkkPCo00000_n`m_45o`000009
0<Sh[000000000000>Gi[P000000jONY0000003cm;0000000080mO:^00@000000?K`/03fl;000000
0P3el;H01@000000lNo10?7_`@3akl40000000@0j>g@1000000209o3lP050000000bG<d0<Uc=039L
c@000000100_C;l200000080>DZi00D00000034jZ`000000ATjf000000040452[08000000`1>BJ`0
0`000000D4RZ0518ZP030518ZP030000001JCJT0FTfY00<0FTfY00<0000005iAZ`1NDJ/00`1NDJ/0
10000000IEbc00000000000306ACZ@030000001XF:d0J5R]00@0J5R]00<0000006mU^01_IKP0101_
IKP00`000000OHKB07f6dP0607f6dP800000101@BJ/00`00003o000005U>Z`0305U>Z`030000001E
AjD0000000<0HU>/00<0000005a;Y@1LBjD00`1LBjD00`000000oooo0?ooo`080?ooo`03o`00003o
ool0oooo00H0oooo000C0?ooo`;o00000P3oool3o`000280oooo0ol00003oa]chP?o000000?oD8OW
o`000?mOR>800omOR>800ol0003oJhWNof^9gP02of^9gP03o`000?mdS=coM8cL00CoM8cL00?o0000
ogf@fommT=/00_mmT=/=o`0000?oSIoO00?o0000oiF[iOnEZnD01onEZnD00ol0003oWK_^oifkkP02
oifkkP?o00001?n`hOP2o`0000;o_o_Y00Go0000olCnb?l0000000000=om^P0400000080loB`00@0
00000?Gb[P3elZh000000P3fl;0010000000mO2f0?G`]P0000020?7_`@030000003XkM00j>g@0080
j>g@00<000000=?Ui00000000P1FR>D3000000<0<Uc=00<0000002m<_`0_C;l00P0_C;l200000080
>DZi00<00000034jZ`0a>Z/00P0000040452[00300000015@jX000000080CTV/00<000000518ZP1@
B:X00`1@B:X2000000@0FTfY00<0000005iAZ`1NDJ/00`1NDJ/01@000000IEbc06EL/`1UG;<00000
0080I5>Y00<0000006QH[@1XF:d0101XF:d00`000000KfFh06mU^00506mU^0030000001mQ]80OHKB
00@0OHKB00<0000006]aa`0000001@1@BJ/00`00003o000005U>Z`0205U>Z`040000001EAjD0EDNU
00000080HU>/00<0000005a;Y@1LBjD00`1LBjD00`000000oooo0?ooo`080?ooo`03o`00003oool0
oooo00H0oooo000;0?ooo`?o00001@3oool4o`0002H0oooo0ol00002oa]chP03o`000?lhN^?o>7[S
00?o00001?mOR>800ol0003oJhWNof^9gP02of^9gP03o`000?mdS=coM8cL00CoM8cL00?o0000ogf@
fommT=/00ommT=/00ol0003oQIKLohFFg004ohFFg003o`000?n=WmooSIoO00GoSIoO00?o0000oiF[
iOnEZnD01onEZnD01?l0003oWK_^o`000?l00006ok3Qn008o`000?nonnWo_o_YokokjOl0003oa?k8
o`00003Iolh2000000060>Gi[P000000l?Jg0000003cm;0000000P3elZh010000000m_2`0?K`/000
00020?G`]P040000003akl40lNo1000000@0j>g@00D000000=?Ui03CiN@0dnGT0000000405J8i@05
0000000bG<d0<Uc=039Lc@0000000`0_C;l01@0000007c:[0000000iB[T000000080<CZ[0P000005
0452[08000000P1>BJ`00`000000D4RZ0518ZP030518ZP030000001GD:h0000000<0FTfY00<00000
05iAZ`1NDJ/00`1NDJ/00`000000IEbc06EL/`0206EL/`<000001P1XF:d00`000000KfFh06mU^005
06mU^0030000001mQ]80OHKB00<0OHKB0P0000000`1[LLL000000519Z`040519Z`0300000?l00000
FDj[00<0FDj[00@0000005E7Y@1EAjD000000P1RDj`00`000000G4^U05a;Y@0305a;Y@030000003o
ool0oooo00L0oooo00?o00000?ooo`3oool01P3oool000`0oooo00?o00000?ooo`3oool0103oool0
0ol0000000000?ooo`0X0?ooo`06o`000?l0B/7o0000o`000?lKLn;o00001?lhN^<3o`0000;oGhSR
00?o0000of^9g_m[RMh00_m[RMh00ol0003oM8cLogB<g003ogB<g003o`000?mmT=_oOI3K00CoOI3K
00?o0000ohFFg?n5U]`01?n5U]`00ol0003oSIoOohfOg`05ohfOg`03o`000?nEZnGoUJ_U00KoUJ_U
0ol00005ok3Qn0;o00000ononnT01?l0003oa?k8o`00003Iolh2000000040>Gi[P000000l?Jg0000
0080loB`00<000000?Gb[P0000000`3fl;000`000000mO2f000000020?7_`@030000003XkM00j>g@
0080j>g@00<000000=?Ui03CiN@00`3CiN@01@000000EXSU05J8i@1FR>D0000000<0<Uc=0P000002
02m<_`060000000O<Z/07c:[0000000iB[T000000P0a>Z/2000000@0@D:/00<0000004E3ZP000000
0P1>BJ`00`000000D4RZ0518ZP030518ZP030000001GD:h000000080FTfY00<0000005iAZ`1NDJ/0
101NDJ/00`000000IEbc06EL/`0306EL/`8000001P1XF:d00`000000KfFh06mU^00406mU^0030000
001mQ]80OHKB0080OHKB00D0000004M6[0000000Jg77000000050519Z`80000000Go000005U>Z`1I
CZ/0FDj[0000000205E7Y@040000001RDj`0HU>/000000D0G4^U00<000000?ooo`3oool01`3oool0
0ol00000oooo0?ooo`060?ooo`00303oool00ol00000oooo0?ooo`060?ooo`030000003oool0oooo
02L0oooo1?l000000olKLn;o0000ocQjh`02ocQjh`03o`000?m?PN;oCh7R00?o00001Om[RMh00ol0
003oM8cLogB<g003ogB<g003o`000?mmT=_oOI3K00?oOI3K00?o0000ohFFg?n5U]`01On5U]`00ol0
003oSIoOohfOg`04ohfOg`03o`000?nEZnGoUJ_U00?oUJ_U0ol00003ojG8lP05o`000?n`hOSo/>7h
ok3Qn?l000001?nonnT3o`0000030=WocP000000gofj008000000P3`m[L00`000000loB`00000002
0?Gb[P040000003fl;00m_2`00000080mO2f1@0000020>S]d0030000003CiN@0dnGT00@0dnGT0`00
000205J8i@060000000bG<d0<Uc=0000000=:j/000000P0_C;l00`0000007c:[01lbZ`02000000<0
<CZ[00<000000452[011@Z`00P11@Z`01P000000AD>Z04E3ZP000000CTV/000000D0D4RZ00@00000
05M@[P1GD:h000000P1JCJT00`000000GU6[05iAZ`0305iAZ`030000001UG;<0IEbc00@0IEbc0P00
000506QH[@030000001_IKP0KfFh00D0KfFh00@0000007f6dP1mQ]8000000`17AZ`2000000H0D4V[
0P0000001?l00000FDj[05U>Z`00000305E7Y@030000001RDj`0000000D0G4^U00<000000?ooo`3o
ool01`3oool00ol00000oooo0?ooo`060?ooo`00303oool00ol00000oooo0?ooo`070?ooo`030000
003oool0oooo02L0oooo1Ol00004ocQjh`03o`000?m?PN;oCh7R00;oCh7R0ol00002of^9gP03o`00
0?mdS=coM8cL00?oM8cL00?o0000ogf@fommT=/01?mmT=/00ol0003oQIKLohFFg004ohFFg003o`00
0?n=WmooSIoO00GoSIoO00?o0000oiF[iOl000000_l00007ojG8lP03o`000?n`hOSo000000Co_o_Y
0ol000000`3Iolh000000=om^P03000000040?3f]`000000loB`00000080mO:^00D000000?K`/03f
l;0000000?G`]P03000000040?WX[`000000mnNc0?OW/`@000000P3CiN@3000000050:G;m0000000
2DG40000001FR>D00P000002039Lc@050000000=:j/0000002m<_`0000000P0O<Z/2000000<0<CZ[
00<000000452[011@Z`00P11@Z`010000000AD>Z04E3ZP15@jX2000000D0D4RZ00L0000005M@[P1G
D:h0Ee2^0000001JCJT0000000D0GU6[00<0000006EL/`1UG;<0101UG;<00`000000LgK700000002
00000080J5R]00<0000006mU^01_IKP01@1_IKP01@000000OHKB0000001/Nm00000000<0AdJ/0P00
00050519Z`80000000@0FDj[o`00001ICZ/00000101EAjD2000000D0G4^U00<000000?ooo`3oool0
1`3oool00ol00000oooo0?ooo`060?ooo`00303oool00ol00000oooo0?ooo`080?ooo`030000003o
ool0oooo02L0oooo0ol000000ol0Fm?o0000ocQjh`02ocQjh`03o`000?m?PN;oCh7R00;oCh7R00?o
0000of:7h?mRQn001?l00005ogB<g003o`000?mmT=_oOI3K00CoOI3K00?o0000ohFFg?n5U]`01?n5
U]`00ol0003oSIoOohfOg`02ohfOg`Go00002OnUb?87o`000004olkjiOl00000fOo>00000080gofj
0P0000020?3f]`030000003cm;0000000080mO:^00<000000?K`/03fl;000P000000103ijJh00000
0?WX[`0000040?OW/`030000003dj;X0m>Rj008000001@2Ubo@0100000002DG40000001FR>D20000
0006039Lc@0000003B^[0000000_C;l000000`0O<Z/200000080<CZ[0P0000030452[00400000015
@jX0AD>Z04E3ZP8000001@1@B:X00`000000Ee2^05M@[P0205M@[P8000001P1NDJ/00`000000IEbc
06EL/`0306EL/`030000001cM/L0LgK70080LgK71000000306mU^0D000000P1/Nm000`000000AdJ/
04M6[00204M6[0030000001@BJ/0D4V[00<0D4V[00@0000004i3Y@00003o00000P1ICZ/010000000
EDNU05E7Y@1EAjD2000000H0G4^U00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`050?oo
o`002`3oool2o`0000/0oooo0P00000X0?ooo`04o`000?l0::?o0000o`1Kd`;o00000_lhN^<00ol0
003oCh7Rodn1hP02odn1hP03o`000?mRQn3oHXOP00;oHXOP1Ol000000omdS=co0000ogf@f`05ogf@
f`03o`000?n5U]coQIKL00;oQIKL1ol00005oiVcjP03o`000?nUb?;oYLSb00CoYLSb0_l00004ok_W
m004o`000?o>n^Goc_[Uo`000080fOo>00T000000=om^P000000joW20000003`m[L000000??d/000
00000P3elZh010000000m_2`0000000000020?WY[P040000003ij:l0nNR_000000<0mnNc00@00000
0?CX^P3dj;X0m>Rj0P0000060:G;m00900000009AL@0000000000000;;000000039Lc@0000003B^[
00800000100O<Z/010000000<CZ[034jZ`0a>Z/2000000<0@D:/00@0000004E3ZP15@jX0AD>Z0P00
00050518ZP030000001GD:h0Ee2^0080Ee2^0P00000505iAZ`030000001UG;<0IEbc00@0IEbc00<0
000007=fa`1cM/L0101cM/L4000000<0T/3f00D0000003m4[`000000K7_@0000000404M6[0030000
001@BJ/0D4V[00<0D4V[00L0000004i3Y@000000FDj[o`00001ICZ/0000000@0EDNU0P00000505a;
Y@030000003oool0oooo00L0oooo00?o00000?ooo`3oool01@3oool000`0oooo00?o00000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0V0?ooo`Oo000000?o>7[So`000?m?PN800om?PN800ol0003o
HXOPof:7h002of:7h004o`000?maS]ooLHkOog6>g`go00001?n<Y>@00ol0003oVK?ZoiVcjP06oiVc
jP03o`000?nUb?;oYLSb00;oYLSb00?o0000ok_Wm?nkio@00_nkio@2o`0000;oc_[U00?o00000=Wo
cP3Iolh00`000000103[nL8000000?3f]`0000020??d/0030000003elZh0mO:^0080000000L0n>Z`
0000003ijJh0nNV^0000003ij:l0000000<0mnNc00D000000?CX^P3dj;X0m>Rj000000020>oXa@03
0000002Ubo@0YL_d00<0YL_d00<0000000U5a009AL@00P0000000`00;;0000000000000200d[Z`80
00000`0O<Z/010000000<CZ[034jZ`0a>Z/2000000<0@D:/00<0000004E3ZP15@jX00P15@jX00`00
0000D4RZ0518ZP030518ZP030000001GD:h0Ee2^00<0Ee2^0P00000405iAZ`030000001UG;<0IEbc
00@0IEbc00<0000007=fa`1cM/L0101cM/L00`000000T/3f09;0mP0309;0mP8000000P0oA:l20000
00@0AdJ/0P0000040519Z`070000001>@jD0CT>U0000001ICZ_o00000000000505E7Y@030000001L
BjD0G4^U00<0G4^U00<000000?ooo`3oool01`3oool00ol00000oooo0?ooo`050?ooo`006`3oool0
0`000000oooo0?ooo`0W0?ooo`05o`000?l0@/7o0000o`000?lPK=d00_l00005odn1hP03o`000?mR
Qn3oHXOP00;oHXOP00?o0000og6>gomaS]l00_maS]l00ol0003oOiSQognHh@04ognHh@03o`000?n<
Y>CoS:CT00KoS:CT00?o0000oiVcj_nI/nX01_nI/nX01?l0003oYLSbo`000?l00003ok_Wm0;o0000
0oo>n^D00ol00000fOo>0=WocP02000000030>CjdP00000000000080l?Jg00@000000??d/0000000
mO:^0P0000020?SZ/0040000003ijJh0nNV^00000080nNR_00D000000?OW/`3gik<0mnNc00000002
0?CX^P030000003_j<D0knS50080knS51@0000001@2Ubo@0000000U5a009AL@00000008002b`00D0
000000d[Z`0=:j/03B^[0000000301lbZ`8000000P0a>Z/00`000000>3^Y000000020452[0030000
0015@jX0AD>Z0080AD>Z0P0000040518ZP030000001GD:h0Ee2^00<0Ee2^00<0000006AQ^P000000
101NDJ/00`000000IEbc06EL/`0306EL/`030000001cM/L0LgK700D0LgK700L0000009;0mP2B`?H0
T/3f0000001jUn80000000<0?dB_0P00000404M6[0800000101@BJ/01P000000CT>U04i3Y@000000
FDj[o`0000D0EDNU00<0000005a;Y@1LBjD00`1LBjD00`000000oooo0?ooo`070?ooo`03o`00003o
ool0oooo00D0oooo000L0?ooo`030000003oool0oooo02L0oooo00Co0000o`12`Ol0003o00000_lP
K=d3o`0000;oCh7R00?o0000of:7h?mRQn000_mRQn000ol0003oLHkOog6>g`03og6>g`03o`000?mo
V>7oOiSQ00CoOiSQ00?o0000ohbTi?n<Y>@01_n<Y>@00ol0003oVK?ZoiVcjP04oiVcjPGo00000_nk
io@00ol0003oc_[Uolkji@02olkji@04o`0000000000000000000080i?[B00D000000>_i`P000000
l?Jg000000020??d/080000000D0m^be0000003hj[00n>Z`000000020?WY[P030000003ij:l00000
00<0mnNc00D000000?CX^P3dj;X0m>Rj000000030>oXa@040000003RimD0h^OE00000080Di7]0`00
000200U5a00400000000;;0002b`000000803B^[00<0000001lbZ`0O<Z/00P0O<Z/010000000<CZ[
034jZ`00000203PkZ@0300000011@Z`0000000@0AD>Z00<00000051=[`0000000`1@B:X00`000000
Ee2^05M@[P0305M@[P030000001THKX0I66j008000000P1NDJ/00`000000IEbc06EL/`0406EL/`03
0000001cM/L0LgK700D0LgK700@0000009;0mP000000oooo0P00000403m4[`0300000017AZ`0AdJ/
0080AdJ/0P0000040519Z`060000001>@jD0CT>U0000001ICZ_o00001@1EAjD2000000D0G4^U00<0
00000?ooo`3oool01@3oool00`00003o00000?ooo`060?ooo`007@3oool2000002P0oooo00Ko0000
o`12`Ol0@/7o0000ob1/gOl00002od9jh@Co00001?mRQn000ol0003oLHkOog6>g`03og6>g`03o`00
0?moV>7oOiSQ00CoOiSQ00?o0000ohbTi?n<Y>@01_n<Y>@00ol0003oVK?ZoiVcjP03o`0000Go[<ka
1ol0000020000000eoCS0=Odh`000000i?[B0000003[nL8000000P3`m[L300000080m^be00@00000
0?SZ/03hj[0000000P3ijJh010000000nNR_0?WX[`0000020?OW/`050000003dj;X0m>Rj0?CX^P00
00000`3_j<D00`000000h^OE0>;We@020>;We@050000001CTNd0Di7]05>Ak@0000000P09AL@01000
000002b`000//000000200d[Z`8000000`0O<Z/200000080<CZ[00<0000003PkZ@0h>jT00P000005
04E3ZP030000001@CJl0000000<0D4RZ00<0000005M@[P1GD:h00`1GD:h010000000I66j06AQ^P1T
HKX3000000H0IEbc00<0000007=fa`1cM/L01@1cM/L2000000<0oooo0P00000303m4[`0300000017
AZ`0AdJ/0080AdJ/00<0000004DnY00000000`1@BJ/01`000000CT>U04i3Y@1>@jD0000005U>Zol0
00001@1EAjD2000000@0G4^U00<000000?ooo`3oool01@3oool00`00003o00000?ooo`060?ooo`00
7`3oool00`000000oooo0?ooo`0V0?ooo`03o`000?l0@/7o04;100?o00001?m2N^44o`0000;oHXOP
00?o0000og6>gomaS]l00omaS]l00ol0003oOiSQognHh@04ognHh@03o`000?n<Y>CoS:CT00CoS:CT
1?l00007ojc>l@03o`000?o3i^oo`nK_00;o`nK_00?o00000=Odh`3Gm><00P3Gm><01`000000i?[B
0>CjdP000000joW20000003`m[L00P0000001@3ckk`000000?K/]@3fk;D000000080n>Z`00@00000
0?WY[P3ijJh000000P3ij:l010000000mnNc0?OW/`0000020?CX^P050000003_j<D0knS50>oXa@00
00001@3RimD2000000<0Di7]00D0000000U5a00000000000000//002000000803B^[00T0000001lb
Z`0O<Z/07c:[0000000V<JL00000034jZ`0000000P0h>jT00`000000@D:/0000000404E3ZP040000
001@CJl0D4f_00000080D4RZ00<0000005M@[P1GD:h00`1GD:h00`000000I66j06AQ^P0306AQ^P80
00001@1UG;<00`000000LgK707=fa`0207=fa`<000001P3oool010000000?dB_03m4[`0oA:l20000
00<0AdJ/00<0000004DnY00000000`1@BJ/020000000CT>U04i3Y@1>@jD0000005U>Z`00003o0000
101EAjD00`000000FDbX0000000305a;Y@030000003oool0oooo00D0oooo00<00000o`00003oool0
1P3oool00200oooo00<000000?ooo`3oool09P3oool3o`000003o`QNe_l0003o000000Co@W[Q00?o
0000oef7h_mMQn800ol00006og6>g`03o`000?moV>7oOiSQ00CoOiSQ00?o0000ohbTi?n<Y>@00ol0
0003oiZgk003o`000?n/c_7o[<ka00?o[<ka0_l00004ol?Vk`03o`00003Gm><0eoCS0080eoCS00H0
00000>CjdP3Tn]8000000>_i`P0000020?3f]`030000003ckk`000000080m^be00@000000?SZ/03h
j[0000000P3ijJh010000000nNR_0?WX[`0000020?OW/`050000003dj;X0m>Rj0?CX^P0000000P3_
j<D00`000000h^OE0>;We@020>;We@80000000<0amkZ0000000000000P1CTNd20000000500U5a000
000002b`000//00000000P0=:j/2000000807c:[00D0000002HaY`000000<CZ[0000000303PkZ@80
00001015@jX01`000000D4f_051=[`1@CJl000000518ZP0000001@1GD:h00`000000I66j06AQ^P04
06AQ^PD000000P1UG;<4000000030:7cl0000000oooo00H0oooo00<0000003m4[`0oA:l00P0oA:l0
0`000000AdJ/04M6[00204M6[00300000015?Z@000000080D4V[00<0000004i3Y@1>@jD00P1>@jD2
00000003o`00001EAjD0EDNU0080EDNU00<0000005U<Z00000000`1LBjD00`000000oooo0?ooo`05
0?ooo`80000000?o00000?ooo`3oool0103oool00240oooo00<000000?ooo`3oool09P3oool01000
003o0000o`000?l8G]H2o`0000Co@W[Q00?o0000oef7h_mMQn800_mMQn8@o`0000OoV[O/00Go0000
ojc>lOn/c_7o[<kao`000005ol?Vk`03o`00003Gm><0eoCS0080eoCS00L000000>CjdP3Tn]800000
0>_i`P000000l?Jg008000000P3ckk`010000000m^be0?K/]@0000020?SZ/0040000003ijJh0nNV^
00000080nNR_00@000000?OW/`3gik<000000P3dj;X010000000knS50>oXa@0000040>;We@030000
0037g^X0amkZ0080amkZ0P000000101CTNd0000000000009AL@200000009000//0000000000000d[
Z`0000004BFS0000000O<Z/0000000809S6W00<00000034jZ`0000000`0h>jT00`000000AD>Z04E3
ZP0204E3ZP030000001@CJl0D4f_0080D4f_0P00000605M@[P030000001THKX0I66j00<0I66j00<0
000007j=e`1nSML00P1nSML5000000030:7cl0000000oooo00P0oooo00@0000003m4[`0oA:l0?dB_
0P00000304M6[00400000015?Z@0ACjT00000080D4V[00<0000004i3Y@1>@jD00P1>@jD00`000000
EDNUo`00000305E7Y@040000001IC:P0FDbX00000080G4^U00<000000?ooo`3oool0103oool01000
0000000g00000?l000060?ooo`008P3oool2000002L0oooo00<00000o`000?l000000_l8G]H00ol0
003o@W[Qod9jh@02od9jh@05o`000?mMQn;oGHORoef7h_l000001_mdU>@00ol0003oR:CWohRTi`04
ohRTi`03o`000?nJ]ncoV[O/00OoV[O/00?o0000ojc>lOl000001Oo3i^l00ol00000eoCS0=Odh`02
0=Odh`040000003Tn]80i?[B00000080joW20P000000103^l<L000000??__00000020?K/]@040000
003hj[00n>Z`00000080nNV^00@000000?WX[`3ij:l000000P3gik<9000000030>;We@0000000000
00D0amkZ00@000000012a0000000Di7]100000001@00;;000000000HWP0000003B^[008000000P0O
<Z/01@0000009S6W0000000a>Z/0000000<0>3^Y00<0000004E3ZP15@jX00`15@jX00`000000D4f_
051=[`02051=[`8000001@1GD:h00`000000I66j06AQ^P0406AQ^P030000001nSML0OXgG00D0OXgG
0P00000:0?ooo`070000000oA:l0?dB_03m4[`000000>cVT0000000204M6[00400000015?Z@0ACjT
00000080D4V[00<0000004i3Y@1>@jD00P1>@jD20000000305E7YOl00000EDNU0080EDNU00@00000
05U<Z01IC:P000000P1LBjD00`000000oooo0?ooo`030?ooo`040000000003L00000o`0000H0oooo
000T0?ooo`030000003oool0oooo02D0oooo00<00000o`000?l8G]H00_l8G]H3o`000003od9jhOl0
003oGHOR00?oGHOR00?o0000ogBDi?mdU>@01?mdU>@00ol0003oR:CWohRTi`04ohRTi`03o`000?nJ
]ncoV[O/00KoV[O/0ol00004ol?Vk`03o`00003Gm><0eoCS0080eoCS00@000000>CjdP3Tn]80i?[B
0`0000020>k`a`040000003ckk`0lnnl00000080m^be00@000000?SZ/03hj[0000000P3ijJh00`00
0000nNR_0?WX[`0400000080nMj/00@000000?SN[@3hgZd000000P3gg[02000000L0amkZ00<00000
0012a00000000P0000003009AL@0000000000000000001RN0000000=:j/00000014UX`0000007c:[
000000809S6W0P00000303PkZ@8000001015@jX00`000000D4f_051=[`03051=[`800000101GD:h0
0`000000I66j06AQ^P0406AQ^P030000001nSML0OXgG00@0OXgG00<000000?ooo`3oool02`3oool0
1P000000?dB_03m4[`000000>cVT00000080AdJ/00L0000004DnY015?Z@0ACjT0000001@BJ/00000
00D0CT>U00@0000005E7Y@1EAjGo00000P1EAjD01`000000FDbX05U<Z01IC:P0000005a;Y@000000
1@3oool010000000000g00000?l000060?ooo`009@3oool00`000000oooo0?ooo`0U0?ooo`050000
0?l0003o25kFo`QNe_l000000_lhM^03o`0000CoGHOR00?o0000ogBDi?mdU>@01?mdU>@00ol0003o
R:CWohRTi`04ohRTi`03o`000?nJ]ncoV[O/00;oV[O/0ol00003ojo<k`;o000000?o`nK_o`00003G
m><00`3Gm><010000000i?[B0>CjdP3Tn]82000000040>K`e0000000k_3700000080lnnl00L00000
0?K/]@3fk;D0m^be0000003hj[0000000080nNV^00<000000?WX[`0000000P0000001@3igj`00000
0?WN[03igZ`000000080n=j]00H000000?ON/03gg[00mmj`0000003egkH2000000D0amkZ00D00000
0012a000@/@00000000@X00300000003000//000000001RN0080000000@04BFS0000000O<Z/00000
0`0V<JL00`000000>3^Y03PkZ@0203PkZ@8000000`15@jX00`000000D4f_051=[`03051=[`030000
001SIKl0000000@0Ee2^00<0000006AQ^P1THKX00`1THKX00`000000OXgG07j=e`0307j=e`800000
3@3oool010000000?dB_03m4[`00000203/iY00400000017AZ`0AdJ/00000080ACjT00<000000519
Z`0000001@1>@jD010000000EDNU05E7YOl0000205E7Y@070000001IC:P0FDbX05U<Z0000000G4^U
000000050?ooo`040000000003L00000o`0000H0oooo000V0?ooo`030000003oool0oooo02D0oooo
00D00000o`000?l0003o25kFo`000004ocQfh0?o000000?oGHORo`000?mdU>@01OmdU>@00ol0003o
R:CWohRTi`05ohRTi`04o`000?nJ]nco0000o`0000Oo[lc_0_l0000900000080i_3D00@000000>k`
a`3^l<L000000P3ckk`010000000m^be0?K/]@0000020?SZ/0030000003ijJh0nNV^0080000000@0
n>2_0000003igj`000000`3igZ`010000000n=j]0?SN[@0000020?ON/0030000003egkH0mMnf0080
mMnf1`0000020012a004000000004:000000000=VP80000000D001RN0000000=:j/00000014UX`02
000000<09S6W0P00000303PkZ@0300000017B:l0000000<0AD>Z00<00000051=[`1@CJl00`1@CJl0
10000000HfFo00000000000205M@[P030000001THKX0I66j00@0I66j00@0000007j=e`1nSML0OXgG
0P00000?0?ooo`060000000oA:l0?dB_0000000k>J@000000P17AZ`010000000ACjT04DnY015?Z@2
000000D0CT>U0P00000205E7Y@03o`00001EAjD0000000@0FDbX0P0000040?ooo`050000000003L0
000g00000?l000001P3oool002L0oooo0P00000V0?ooo`0300000000DLko000000;o00000olhM^00
0ol0003oGX_Uoej;i@03o`0000KoM9CT00?o0000ohRTion8Y>L00_n8Y>L5o`0000Ko[lc_0_l00005
0<GNj`030000003Hjn40f>_Q0080f>_Q00<000000>K`e00000000P3^l<L01@000000lnnl0??__03c
kk`000000080m^be00@000000?SZ/0000000nNV^0P0000020?SP[`040000003igj`0nMn/000000<0
nMj/00@000000?SN[@3hgZd000000P3gg[000`000000mMnf0?GO]P020?GO]P800000102:_oP01@00
000004;40012a0000000012P00@000000P0069h2000000804BFS00<0000002HaY`0V<JL00P0V<JL0
1@000000>3^Y03PkZ@0h>jT000000080AdR_00@0000004E3ZP15@jX000001@1@CJl010000000HfFo
06=U_`1SIKl3000000H0I66j00<0000007j=e`1nSML00P00000@0?ooo`040000000oA:l0?dB_0000
0080>cVT00<0000004M6[00000001015?Z@2000000D0CT>U0P00000205E7Y@03o`00001EAjD00000
00@0FDbX0P0000030?ooo`050000000003L0000g00000?l000001P3oool002T0oooo00<000000?oo
o`3oool0903oool00`000000057>001AcP02o`0000?o>7KP00?o0000oej;iOmNRnD00_mNRnD;o`00
00GoUkC[00?o0000ojo<kon_c>l00_n_c>l00ol00000aMk[0<GNj`040<GNj`030000003Hjn40f>_Q
0080f>_Q00H000000>K`e03Vl=@000000>k`a`0000030??__0040000003fk;D0m^be00000080n>Z`
0P0000001@3gh[<000000?SP[`3hh:l000000080nMn/00@000000?WN[03igZ`000000P3hgZd01000
0000mmj`0?ON/00000040?GO]P040000003`hKh0l>6n000000@0R[oh00P000000012a000@/@00000
000@X000000000fJ000000<001RN00<00000014UX`0A9J<00P00000302HaY`030000000h>jT0>3^Y
0080>3^Y00H0000004M8[`17B:l0000004E3ZP000005051=[`030000001SIKl0HfFo00<0HfFo0P00
000506AQ^P040000001nSML0000000000180oooo00<0000003m4[`0000000P0k>J@00`000000AdJ/
0000000404DnY08000001@1>@jD00`000000E4ZY0000000205E7Y@03o`0000000000FDbX00@0FDbX
00D000000?ooo`3oool0oooo000000020000=`0300000?l00000oooo00D0oooo000Z0?ooo`030000
003oool0oooo02@0oooo00@00000001AcP00DLh0057>0_l00002ocQfh003o`000?mNRnGoGX_U00;o
GX_U00?o0000ogfOj?mmWnP00ommWnP00ol0003oUkC[oiNdj`07oiNdj`04o`000?n_c>oo0000o`00
00H0aMk[00<000000=S[h@3Hjn400P3Hjn4010000000i_3D0>K`e00000020>k`a`050000003ckk`0
lnnl0??__00000000P3fk;D300000080mn:c00@000000?SP[`3hh:l000000P3igj`01@000000nMj/
0?WN[03igZ`000000080n=j]00@000000?ON/03gg[000000103egkH010000000l>6n0?3Q_P3`hKh2
00000080R[oh0P0000001@00@/@00000000@X000000000fJ008000000P0069h2000000804BFS00@0
000002HaY`0V<JL09S6W0P00000303PkZ@0400000017B:l0AdR_04M8[`8000001P1@CJl00`000000
HfFo06=U_`0306=U_`T000004`3oool00`000000?dB_0000000303/iY00300000017AZ`0000000@0
ACjT00<0000004i3Y@1>@jD00`1>@jD00`000000E4ZY0000000205E7Y@03o`0000000000FDbX00@0
FDbX00D000000?ooo`3oool0oooo000000020000=`030000003ooooo000000D0oooo000[0?ooo`03
0000003oool0oooo02@0oooo00D00000001AcP00DLh0000003=eh@03o`0000GoGX_U00?o0000ogfO
j?mmWnP00ommWnP00ol0003oUkC[oiNdj`06oiNdj`;o000000<000000<GNj`35g^/01035g^/00`00
0000f>_Q0=S[h@020=S[h@040000003Vl=@0i_3D00000080k_3700H000000??__03ckk`0lnnl0000
003fk;D3000000050?CS^@000000mn:c0?OR/`0000000P3hh:l010000000nMn/0?WO[00000020?WN
[0040000003hgZd0n=j]00000080mmj`00<000000?GO]P3egkH00P3egkH00`000000l>6n0?3Q_P02
0?3Q_P070000003oool000000000002:_oP000000012a00400000003000=VP00000001RN008001RN
00@00000014UX`0A9J<00000100V<JL200000080>3^Y00<0000004M8[`17B:l00P17B:l2000000D0
D4f_00<0000006=U_`1SIKl00`1SIKl00`000000S:?T08bSi00408bSi0800000503oool00`000000
?dB_0000000203/iY00300000017AZ`0000000@0ACjT00<0000004i3Y@1>@jD00`1>@jD010000000
E4ZY05A:Z@00000205E7Y@03o`00001IC:P0FDbX00<0FDbX00D000000?ooo`3oool0oooo00000002
0000=`030000003ooooo000000D0oooo000/0?ooo`800000903oool300000004001AcP000000<gGQ
03=eh@;o00001OmNRnD00ol0003oOIoXogfOj003ogfOj003o`000?nG]>_oUkC[00;oUkC[0ol00003
0:c5k@8000000`35g^/00`000000f>_Q0=S[h@020=S[h@040000003Vl=@0i_3D000000<0k_3700@0
00000??__03ckk`0lnnl0P000000103aiL0000000?CS^@0000020?OR/`050000003hh:l0n>2_0?SP
[`0000000P3igj`010000000nMj/0?WN[00000020?SN[@040000003gg[00mmj`000000@0mMnf00D0
00000?3Q_P3`hKh0l>6n000000040?ooo`<0000000H004;4000000004:000000000=VP000003000H
WP030000000A9J<04BFS008000000`0V<JL01@000000>D2^0000000h>jT0000000D0AdR_0P000004
051=[`030000001SIKl0HfFo00@0HfFo00<0000008bSi02<Xn@00P2<Xn@2000001D0oooo00<00000
03m4[`0000000`0k>J@2000000@0ACjT0P00000404i3Y@050000001DBZT0E4ZY05A:Z@0000000P1E
AjD00ol00000FDbX05U<Z00305U<Z0030000003oool0000000<0000g00<000000?ooool000001@3o
ool002h0oooo00<000000?ooo`3oool08P3oool01@00000004K600000000DLh0000000<0<gGQ1Ol0
00000omNRnGo0000ogfOj004ogfOj004o`000?nG]>_o0000o`0000P0[<G]00<000000<GNj`000000
103Hjn401@000000i_3D0>K`e03Vl=@000000080k_3700<000000??__00000000P0000020?7U`004
0000003dhkT0m>>i00000080mn:c00@000000?SP[`3hh:l000000P3igj`01@000000nMj/0?WN[03i
gZ`000000080n=j]00@000000?ON/03gg[0000000`3egkH01@000000l>6n0?3Q_P3`hKh0000000L0
oooo1P00000010003IX00000000HWP0069h2000000804BFS0P00000202HaY`060000000i@:h0>D2^
0000000h>jT000001017B:l00`000000HFK100000004051=[`030000001SIKl0HfFo00@0HfFo00H0
000008bSi02<Xn@000000:C/Y000000F0?ooo`800000100k>J@00`000000ACjT04DnY00304DnY080
0000101>@jD020000000E4ZY05A:Z@1DBZT0000005E7Y@00003o0000101IC:P00`000000oooo0000
00020000=`80000000<0ooooo`00003oool0103oool002l0oooo00<000000?ooo`3oool08P3oool0
1000000004K600000000000303=eh@030000001UT^P0II;X0080II;X2Ol000000`000000[<G]0:c5
k@070:c5k@@000000P3Hjn4010000000i_3D0>K`e03Vl=@600000080jnG:00H000000?7U`03aiL00
00000?CS^@0000020?OR/`050000003hh:l0n>2_0?SP[`0000000P3igj`010000000nMj/0?WN[000
00020?SN[@040000003gg[00mmj`000000<0mMnf00D000000?3Q_P3`hKh0l>6n000000080?ooo`H0
000000<000fJ0000000069h00P0069h01P0000004BFS014UX`0000009cBY000000809S6W00D00000
03U0[P000000>3^Y0000000504M8[`040000001QI/40000000000080D4f_00<0000006=U_`1SIKl0
101SIKl00`000000S:?T00000002000001L0oooo0P00000403/iY08000001015?Z@2000000@0CT>U
00P0000005A:Z@1DBZT0E4ZY0000001EAjD00000o`0000@0FDbX00<000000?ooo`0000000P0003L2
000000030?ooool00000oooo00@0oooo000`0?ooo`030000003oool0oooo0280oooo00@000000016
aP00A/H000000`0cMN400`000000II;X06FBj00306FBj0030000002<[>/0S:c[00D0S:c[00<00000
0:c5k@2/aNd0102/aNd2000000@0`MCY1`0000020>7Te@050000003[iLX0jnG:0>_UbP0000000P3a
iL0010000000m>>i0?CS^@0000020?OR/`040000003hh:l0n>2_00000080nMn/00D000000?WN[03i
gZ`0nMj/000000020?SN[@040000003gg[00mmj`000000<0mMnf00D000000?3Q_P3`hKh0l>6n0000
00090?ooo`P000000P0069h200000004014UX`0000009cBY000000809S6W00<0000003U0[P0i@:h0
0P00000504M8[`040000001QI/40HFK1065V`@<000001@1SIKl5000001T0oooo00<0000003/iY00k
>J@00`0k>J@00`000000ACjT04DnY00204DnY0030000001?AjT0000000<0CT>U00<0000005A:Z@1D
BZT00P1DBZT20000000305U<Z?l00000FDbX00<0FDbX0P0000020000=`80000000<0ooooo`00003o
ool0103oool00340oooo0P00000S0?ooo`0300000000A/H004K6008000000P0cMN400`000000II;X
06FBj00306FBj0030000002<[>/0S:c[00D0S:c[00<000000:c5k@2/aNd00P2/aNd00`000000`MCY
0<7Dj@030<7Dj@030000003Cg^00dmkP00<0dmkP00@000000>7Te@3Qi=D000000`3[iLX01@000000
lNG00?7U`03aiL0000000080m>>i00<000000?OR/`0000000`3hh:l010000000nMn/0?WO[0000002
0?WN[0040000003hgZd0n=j]00000080mmj`00D000000?GO]P3egkH0mMnf000000030?3Q_P030000
003oool0oooo00P0oooo00<000000000T`0000000`00000010003IX00000000HWP0069h200000080
4BFS00D0000002LdZ@0000009S6W0000000303U0[P8000001017B:l00`000000HFK1065V`@03065V
`@80000000@0HfFo00000000000000000`2G/NT00`000000oooo0?ooo`0H0?ooo`800000100k>J@0
0`000000ACjT04DnY00304DnY0030000001?AjT000000080CT>U00<0000005A:Z@1DBZT00`1DBZT2
0000000305U<Z?l00000FDbX0080FDbX00P000000000=`0003L000000:Sc^@000000ooooo`0000D0
oooo000c0?ooo`030000003oool0oooo0240oooo0`000000100dMn80000000000000000606FBj003
0000002<[>/0S:c[00D0S:c[00@000000:c5k@00000000001@31e>T00`000000dmkP0=?Nh0030=?N
h0040000003Qi=D0hNCE000000@0jnG:00@000000?7U`03aiL0000000P3dhkT010000000mn:c0?OR
/`0000020?SP[`050000003igj`0nMn/0?WO[00000000P3igZ`010000000n=j]0?SN[@0000020?ON
/0050000003egkH0mMnf0?GO]P0000000P3`hKh00`000000oooo0?ooo`0:0?ooo`80000000<00025
0000000008d00`0000001P0069h0000000hTX`0000004BFS000000809cBY00<0000002HaY`000000
0`0i@:h2000000@0AdR_00<00000065V`@1QI/400`1QI/42000000D0Uk7Y00<000000?ooo`3oool0
6P3oool00`000000>cVT03/iY00203/iY08000001015?Z@010000000CdNY04m7Z@00000204i3Y@03
0000001DBZT0E4ZY00<0E4ZY0P0000001Ol00000FDbX05U<Z01IC:P000000080000g0P0000030?oo
o`03o`00003oool0oooo0080oooo000d0?ooo`030000003oool0oooo0240oooo0`00000203AghP80
00001P1UT^P00`000000S:c[08b/j`0208b/j`D000001@31e>T00`000000dmkP0=?Nh0030=?Nh005
0000003Qi=D0hNCE0>7Te@0000000`3[iLX010000000lNG00?7U`00000030?CS^@040000003gh[<0
mn:c00000080n>2_00@000000?WO[03igj`000000`3igZ`00`000000n=j]0?SN[@0:000000d0oooo
00<000000000T`000000100000001@0049T00000000HWP0000003RBS008000000P0W=:T00`000000
9S6W0000000303U0[P030000001JHL00000000<0AdR_00<00000065V`@1QI/400`1QI/400`000000
Uk7Y09Naj@0309Naj@800000703oool00`000000>cVT03/iY00303/iY08000000`15?Z@010000000
CdNY04m7Z@00000204i3Y@030000001DBZT0E4ZY00<0E4ZY00@0000006YX_P00003o00000`1IC:P0
10000000000g0000000000030?ooo`03o`00003oool0oooo0080oooo000e0?ooo`030000003oool0
oooo0240oooo0`00000303AghP/000001@2O^n`01@000000`MCY0<7Dj@31e>T0000000D0dmkP00D0
00000>7Te@3Qi=D0hNCE000000030>_UbP050000003aiL00lNG00?7U`00000000P3dhkT010000000
mn:c0?OR/`0000030?SP[`050000003igj`0nMn/0000003igZ`01P0000000`3geJT000000?ODZ002
0?ODZ0040000003ge:P0mmBX000000h0oooo0P0000000`0008D000000000S@0300000003000HWP00
00003RBS008000000`0W=:T2000000@0>D2^00@0000005YQ`000000000000P17B:l00`000000HFK1
065V`@03065V`@040000002G/NT0Uk7Y09Naj@8000007P3oool00`000000>cVT03/iY00203/iY080
00000`15?Z@01`000000CdNY04m7Z@1?AjT0000004i3Y@0000001@1DBZT01@000000JVRn06YX_P00
003o00000080FDbX0P0000000`2XlkT000000?ooo`020?ooo`03o`00003oool0oooo0080oooo000f
0?ooo`8000008P3oool00`00000003k00000000303AghP030000001bWN/0LYg[00<0LYg[00<00000
09nkk02O^n`01`2O^n`00`000000`MCY000000050=?Nh0030000003Qi=D0hNCE0080hNCE00D00000
0>_UbP3[iLX0jnG:000000020?7U`0050000003dhkT0m>>i0?CS^@0000000P3gh[<010000000n>2_
0?SP[`0000030?WO[080000000L0mMN^0000003feZ/0m]J[0000003geJT0000000<0mmBX00@00000
0?ODZ03ge:P000003`3oool4000000040000S@0000000000000@V@8000000P0>9:<2000000<09cBY
0P00000303U0[P040000001JHL00FV7005YQ`0<000001P1QI/401@000000Uk7Y0000002I/>L00000
01l0oooo00L0000003/iY00k>J@0>cVT00000017@ZL0000000<0ACjT00@0000004m7Z@1?AjT0CdNY
0P00000605A:Z@050000001ZJ;h0JVRn06YX__l000000`0000000`2XlkT000000?ooo`020?ooo`03
o`00003oool0oooo0080oooo000h0?ooo`030000003oool0oooo01l0oooo0P0000000`00?/000000
0000000203AghP030000001bWN/0LYg[00<0LYg[00<0000009nkk02O^n`01P2O^n`3000000@0dmkP
00<000000>7Te@3Qi=D00P3Qi=D01@000000jnG:0>_UbP3[iLX0000000<0lNG000@000000?CS^@3d
hkT000000P3gh[<010000000n>2_0?SP[`3hh:l400000080mMN^00@000000?KFZ`3feZ/000000P3g
eJT01@000000mmBX0?ODZ03ge:P000000080mmBX00<000000?ooo`3oool03P3oool2000000050000
Q@000000002=0000000049T00P00000200hTX`800000100W=:T01@000000>D2^03U0[P0i@:h00000
00D0FV7000<00000065V`@1QI/400P1QI/440000000309V`i`000000oooo01l0oooo00D0000003/i
Y00k>J@0>cVT0000000204M2Y`0400000015?Z@0ACjT000000<0CdNY0P00000605A:Z@060000001Z
J;h0JVRn06YX__l00000JVRn0P0000000`2XlkT000000?ooo`020?ooo`03o`00003oool0oooo0080
oooo000i0?ooo`030000003oool0oooo01l0oooo0`0000000`0kO^D0000000000002000000D0LYg[
00<0000009nkk02O^n`00P2O^n`3000000<0]<SY0P0000000`3Cg^0000000>7Te@030>7Te@030000
003[iLX0jnG:0080jnG:00@000000?7U`03aiL0000000`3dhkT00`000000mn:c0?OR/`0500000080
m=Rb00@000000?GG[P3eejh000000P3feZ/010000000mmFY0?OEZ@0000030?ODZ0040000003ge:P0
mmBX00000100oooo100000001@0008d000000000000049T0000000<03RBS00<0000002LdZ@0W=:T0
0P0W=:T2000000<0>D2^00<0000005YQ`01JHL000`1JHL04000000@0VK3W00<000000?ooo`3oool0
803oool01@000000>cVT03/iY00k>J@000000080Ad:W00<0000004DnY0000000101?AjT2000000D0
E4ZY00<0000006YX_P1ZJ;h00P1ZJ;h00ol00000JVRn00000002000000<0oooo00?o00000?ooo`3o
ool00P3oool003X0oooo00<000000?ooo`3oool07`3oool00`00000003Zl0000000303]ni@800000
1@1bWN/010000000Wk_/0000000000070;C8j@D000000P3Qi=D01@000000jnG:0>_UbP3[iLX00000
00<0lNG000@000000?CS^@3dhkT0m>>i100000020?7I]`040000003df;80m=Rb000000<0mMN^00H0
00000?KFZ`3feZ/000000?OEZ@0000030?ODZ0040000003ge:P0mmBX00000180oooo100000000`00
08d00000000@V@02000000803RBS0P00000302LdZ@030000001<Ek`000000080>D2^00<0000005YQ
`01JHL000`1JHL000`000000VK3W09V`i`0409V`i`8000008P3oool01@000000>cVT03/iY00k>J@0
00000080Ad:W00<0000004DnY00000001@1?AjT2000000D0E4ZY00<0000006YX_P1ZJ;h00P1ZJ;h0
0ol0000000000?ooo`040?ooo`03o`00003oool0oooo0080oooo000k0?ooo`800000803oool00`00
000003Zl0000000403]ni@P000001P2db>T2000000D0am7R3`0000001@3^f[h000000?7I]`3afKL0
000000<0m=Rb00@000000?GG[P3eejh000000P3feZ/010000000mmFY0?OEZ@0000030?ODZ0040000
003ge:P0mmBX00000180oooo100000001@0008d00000000@V@0049T0000000<03RBS00<0000002Ld
Z@0W=:T00P0W=:T01@000000C5Nl0000000i@:h0000000H0FV7000<0000009V`i`2I/>L00P2I/>L3
000002<0oooo00@0000003/iY00k>J@000000`17@ZL00`000000ACjT0000000404m7Z@030000001[
Jl40000000@0E4ZY00<0000006YX_P1ZJ;h00P1ZJ;h00`00003o00000?ooo`040?ooo`03o`00003o
ool0oooo0080oooo000m0?ooo`030000003oool0oooo01h0oooo00<00000000j_00000000`0kO^D0
0`000000Q:[]08BZk@0508BZk@030000002db>T0]<SY0080]<SY00<000000<OAhP37dN801037dN80
0`000000e]SI0=KHf@030=KHf@050000003Qf/l0hM[?0>7Jc`0000000`3YflH00`000000k]Zn0000
00030?7I]`040000003df;80m=Rb000000<0mMN^00@000000?KFZ`3feZ/000000P3geJT01@000000
mmBX0?ODZ03ge:P000000080mmBX00<000000?ooo`3oool04@3oool600000003000@V@0000003RBS
00803RBS00<0000002LdZ@0W=:T00P0W=:T01P000000C5Nl04aG_0000000>D2^000000H0FV7000H0
000009V`i`2I/>L000000=?n`@00000U0?ooo`030000000k>J@0000000@0Ad:W0P00000504m7Z@04
0000001[Jl40000000000080E4ZY00L0000006YX_P1ZJ;h0JVRn0000003ooooo000000H0oooo00?o
00000?ooo`3oool00@3oool003h0oooo00<000000?ooo`3oool07P3oool00`00000003Zl00000003
03]ni@0300000024Z^d0Q:[]00D0Q:[]00@000000;C8j@00000000001P37dN800`000000e]SI0=KH
f@030=KHf@050000003Qf/l0hM[?0>7Jc`0000000`3YflH010000000k]Zn0>kJ_P0000030?7I]`04
0000003df;80m=Rb00000080mMN^00L000000?KFZ`3feZ/0m]J[0000003geJT0000000<0mmBX00@0
00000?ODZ03ge:P00000503oool01P000000001d000000000000002=00000080012I00<0000000hT
X`0>9:<00P00000302LdZ@040000001<Ek`0C5Nl04aG_08000001P1JHL000`000000VK3W00000003
000002D0oooo00<0000003/iY00000001017@ZL2000000D0CdNY00@0000006][`@1[Jl40Jf_10`00
000206YX_P8000000P3oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo0040oooo000o
0?ooo`030000003oool0oooo01h0oooo1@0000000`0kO^D0000008BZk@0508BZk@<000001P37dN80
0`000000e]SI0=KHf@030=KHf@050000003Qf/l0hM[?0>7Jc`000000103YflH00`000000k]Zn0000
00030?7I]`050000003df;80m=Rb0?CH/P0000000P3eejh010000000m]J[0?KFZ`0000020?OEZ@05
0000003ge:P0mmBX0?ODZ00000000P3ge:P00`000000oooo0?ooo`0C0?ooo`H0000000<0012I0000
000000000P0>9:<2000000<09cBY00D0000004aG_01<Ek`0C5Nl0000000405YQ`0P000009P3oool0
0`000000>cVT0000000404M2Y`800000101?AjT00`000000Jf_106][`@0306][`@@00000103oool0
0ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo0040oooo00100?ooo`8000007P3oool01@00
000003Zl000000000000BHSY00<000000P24Z^d3000000<0VKO/0P0000030<OAhP030000003Ff=T0
e]SI00<0e]SI00<000000>7Jc`3Qf/l00P3Qf/l01@000000jM_60>WKaP3YflH000000080k]Zn00D0
00000?7I]`3afKL0lMVg000000020?CH/P050000003eejh0mMN^0?GG[P0000000P3feZ/010000000
mmFY0?OEZ@0000030?ODZ0030000003ge:P0000001H0oooo00<000000000M00000000`0000000`00
49T000000000000200hTX`030000000gA[D0000000809cBY00<0000004aG_01<Ek`00P1<Ek`40000
00@0TJ?Q1000000V0?ooo`030000000k>J@0000000D0Ad:W0P00000404m7Z@030000001[Jl40Jf_1
00<0Jf_100<0000006][`@0000001@3oool01Ol00000oooo0?ooo`3ooooo000000<0oooo00120?oo
o`030000003oool0oooo01`0oooo00@00000000j_000000000000`19R>T2000000P0VKO/00<00000
0<OAhP0000001@3Ff=T00`000000hM[?0>7Jc`020>7Jc`050000003YflH0jM_60>WKaP0000000P3^
f[h01@000000lMVg0?7I]`3afKL0000000<0m=Rb00@000000?GG[P3eejh000000`3feZ/00`000000
mmFY000000030?ODZ0040000003ge:P0mmBX000001L0oooo0`000000100008d000000000000049T2
0000000700hTX`000000=dJe03M6]@0000009cBY0000000404aG_0030000002AXn40TJ?Q00@0TJ?Q
1000000X0?ooo`8000001@17@ZL00`000000IfNo0000000304m7Z@030000001[Jl40Jf_100@0Jf_1
00<000000?ooo`3oool0103oool01Ol00000oooo0?ooo`3ooooo000000<0oooo00130?ooo`030000
003oool0oooo01`0oooo00@00000000j_000>[`000000`19R>T00`000000VKO/09Vgk00609Vgk0<0
00001@3Ff=T01@000000hM[?0>7Jc`3Qf/l0000000@0jM_600@000000>kJ_P3^f[h000000`3afKL0
10000000m=Rb0?CH/P0000030?GG[P040000003feZ/0m]J[00000080mmFY00D000000?ODZ03ge:P0
mmBX000000020?ODZ0030000003oool0oooo01D0oooo00<000000000M00000000P0000001`004i`0
00000000000I;j/0000000hTX`0000000P0gA[D2000000D0C5Nl00<00000096Sh@2AXn400P2AXn40
0`000000g_[H00000002000002T0oooo00<0000004M2Y`17@ZL00`17@ZL010000000IfNo06MW_`00
000204m7Z@030000001[Jl40Jf_100<0Jf_100<000000?ooo`3oool01P3oool01?l00000oooo0?oo
ool000030?ooo`00A03oool00`000000oooo0?ooo`0L0?ooo`0300000000>[`003Zl00<0000000<0
BHSY0000002I]n`00`2I]n`3000000<0[/;X00D000000=KHf@3Ff=T0e]SI000000030>7Jc`030000
003YflH0jM_60080jM_600D000000>kJ_P3^f[h0k]Zn000000030?7I]`040000003df;80m=Rb0000
00<0mMN^00@000000?KFZ`3feZ/000000P3geJT01`000000mmBX0?ODZ03ge:P000000?ODZ0000000
603oool00`000000001d0000000200000007000CW0000000000001T_Z`0000003RBS0000000303M6
]@8000001@1<Ek`01@000000TJ?Q096Sh@000000g_[H00@00000:@3oool2000000D0Ad:W00<00000
06MW_`1WIkl00P0000000`1?AjT0000006][`@0206][`@030000003oool0oooo00P0oooo00?o0000
0?ooool000000`3oool004D0oooo0P00000M0?ooo`<000000P1MU^d30000000309Vgk00000000000
00L0[/;X00<000000=KHf@000000103Qf/l00`000000jM_60>WKaP020>WKaP040000003^f[h0k]Zn
000000<0lMVg00@000000?CH/P3df;8000000`3eejh01`000000m]J[0?KFZ`3feZ/000000?OEZ@00
00000`3ge:P010000000mmBX0?ODZ000000I0?ooo`@000000P004i`20000000301T_Z`0000000000
00@0=dJe1@000000101<Ek`00000096Sh@0000020=kjf0<00000:`3oool2000000@0Ad:W00<00000
06MW_`1WIkl00P1WIkl200000080Jf_100<000000?ooo`3oool02@3oool01?l00000oooo0?ooo`00
00020?ooo`00A`3oool00`000000oooo0?ooo`0K0?ooo`<00000101MU^d00`000000[/;X0:k2j007
0:k2j0@000000P3Qf/l00`000000jM_60>WKaP020>WKaP050000003^f[h0k]Zn0>kJ_P0000000`3a
fKL010000000m=Rb0?CH/P0000030?GG[P040000003feZ/0m]J[00000080mmFY00D000000?ODZ03g
e:P0mmBX000000020?ODZ0030000003oool0oooo01L0oooo00<000000000M00000000P0000001000
4i`000000000000I;j/2000000@0=dJe00<0000007j=f01nSMP00P1nSMP9000002d0oooo00D00000
04M2Y`17@ZL0Ad:W0000000506MW_`040000001[Jl400000000000`0oooo00?o00000?ooo`000000
0P3oool004P0oooo00<000000?ooo`3oool06`3oool3000000@0GIK]00<000000:k2j02^`^P0102^
`^P2000000@0`<[R0`0000030>WKaP050000003^f[h0k]Zn0>kJ_P0000000`3afKL01@000000m=Rb
0?CH/P3df;8000000080mMN^00D000000?KFZ`3feZ/0m]J[000000020?OEZ@040000003ge:P0mmBX
0?ODZ0<000006`3oool40000008001>L00<0000001T_Z`0I;j/00P00000403M6]@030000001nSMP0
OXgH00D0OXgH00<000000=3Qi00000000P00000^0?ooo`0500000017@ZL0Ad:W04M2Y`0000001@1W
Ikl00`000000oooo0?ooo`0=0?ooo`03o`0000000000oooo0040oooo00190?ooo`030000003oool0
oooo01/0oooo00<00000000m_`000000101MU^d00`000000[/;X0:k2j0020:k2j00300000030b^80
`<[R00<0`<[R00@000000<o?f@3?cmT0cloI0P0000000`3YflH000000>kJ_P020>kJ_P050000003a
fKL0lMVg0?7I]`0000000P3df;801@000000mMN^0?GG[P3eejh0000000<0m]J[00@000000?OEZ@00
0000mmBX100000000`3ccJP000000?ooo`0J0?ooo`@000000P004i`2000000806Bn[0P00000303M6
]@030000001nSMP0OXgH00@0OXgH00D000000=3Qi0000000joJU0000000`0?ooo`0400000017@ZL0
Ad:W000000@0IfNo00<000000?ooo`3oool03@3oool300000080oooo001:0?ooo`030000003oool0
oooo01/0oooo1P0000000`1MU^d000000:k2j002000000D0`<[R00<000000<o?f@3?cmT0103?cmT7
00000080lMVg00@000000?CH/P3df;8000000`3eejh800000080l/j[00@000000??=Z03ccJP00000
703oool40000008001>L00D0000001T_Z`0I;j/00000061`c00200000080=dJe00<0000007j=f01n
SMP00P1nSMP00`000000d>7T0=3Qi00300000340oooo00<0000004M2Y`0000000`1WIkl00`000000
oooo0?ooo`0:0?ooo`@000001@3oool004/0oooo0P00000K0?ooo`0400000000A/D0000000000080
M:?_100000050<3:hP030000003?cmT0cloI00@0cloI00<000000=[Ad03JdM000P3JdM000`000000
h];70>;Ba`0:00000080k]2d00@000000?3?[`3`cjl000000P3bcZ/010000000llfX0??=Z000000M
0?ooo`D0000000<001>L0000000000000P0I;j/00`000000H73<061`c0020000000503M6]@000000
OXgH07j=f00000000P3@hN@010000000joJU00000000000b0?ooo`8000000P1WIkl00`000000oooo
0?ooo`070?ooo`@000002@3oool004d0oooo00<000000?ooo`3oool06@3oool01000000004K50000
0000000507BSk`0500000030b^80`<[R0<3:hP0000001P3?cmT00`000000f]7@0=[Ad0020=[Ad003
0000003Rd/L0h];70080h];700@000000>OA`03WdL0000000`3/dKT010000000k]2d0>k@]0000002
0?3?[`050000003bcZ/0l/j[0?;>Z`0000000P3ccJP00`000000oooo0?ooo`0K0?ooo`80000000<0
002=0000000000000P004i`20000000301T_Z`000000H73<00<0H73<0P0000000`1nSMP000000=3Q
i0020=3Qi0030000003[mZD0000003@0oooo0`0000070?ooo`<000003@3oool004h0oooo00<00000
0?ooo`3oool06@3oool01000000004K50016a@00000507BSk`0300000030b^80000000H0cloI00<0
00000=[Ad03JdM000P3JdM000`000000h];70>;Ba`020>;Ba`040000003WdL00im70000000<0k=6i
00D000000>k@]03^d;@0k]2d000000020?3?[`050000003bcZ/0l/j[0?;>Z`0000000P3ccJP00`00
0000oooo0?ooo`0L0?ooo`030000000008d000000080000000H001>L0000000hC[`0000001T_Z`00
0005061`c08000000P3@hN@4000003D0oooo00<000000?ooo`3oool00P3oool400000100oooo001?
0?ooo`030000003oool0oooo01T0oooo00<000000016a@00A/D0200000050<o?f@030000003JdM00
f]7@0080f]7@00<000000>;Ba`3Rd/L00P3Rd/L01@000000im700>OA`03WdL00000000<0k=6i00@0
00000>k@]03^d;@000000`3`cjl010000000l/j[0?;>Z`0000020??=Z0030000003oool0oooo01d0
oooo100000000`069ZP000000000000203Q>_08000001`1PL<`010000000d>7T0000002[]n820000
03H0oooo1000000D0?ooo`00D03oool2000001X0oooo0`00000708b`kP050000003?cmT0cloI0<o?
f@000000103JdM000`000000h];70>;Ba`030>;Ba`040000003WdL00im70000000<0k=6i00D00000
0>k@]03^d;@0k]2d000000020?3?[`050000003bcZ/0l/j[0?;>Z`0000000P3ccJP00`000000oooo
0?ooo`0N0?ooo`070000000008d0000000HVZ000000001>L0000000203Q>_08000001@1PL<`30000
00030:^ghP000000000003<0oooo1000000H0?ooo`00DP3oool00`000000oooo0?ooo`0H0?ooo`<0
00001`2</>h00`000000cloI000000050=[Ad0030000003Rd/L0h];70080h];700D000000>OA`03W
dL00im70000000030>cA^@050000003^d;@0k]2d0>k@]00000000P3`cjl010000000l/j[0?;>Z`00
00030??=Z0030000003oool0oooo01h0oooo00D000000000S@000000000000HVZ002000000<0>4jl
00<00000061`c01PL<`00`0000030:^ghP<00000;`3oool4000001`0oooo001C0?ooo`030000003o
ool0oooo01P0oooo0`00000608b`kP<00000103JdM000`000000h];70>;Ba`020>;Ba`050000003W
dL00im700>OA`00000000`3/dKT01@000000k]2d0>k@]03^d;@0000000<0l<n_00@000000?;>Z`3b
cZ/000000P3ccJP00`000000oooo0?ooo`0P0?ooo`040000000008d0000000HVZ0800000100hC[`2
000000D0ZkOR0P0000000`3ckI@000000?ooo`0[0?ooo`<00000803oool005@0oooo00<000000?oo
o`3oool0603oool00`00000005;>0000000208b`kP<000000`2R^n/2000000030=[Ad0000000h];7
00@0h];700D000000>OA`03WdL00im70000000030>cA^@050000003^d;@0k]2d0>k@]00000000P3`
cjl01@000000l/j[0?;>Z`3bcZ/000000080llfX00<000000?ooo`3oool0803oool00`000000002=
0000000200HVZ08000000`0hC[`00`000000ZkOR0:^ghP030:^ghP040000003[k/`00000000002T0
oooo1000000S0?ooo`00E@3oool2000001T0oooo100000070::kj`<00000103Rd/L01@000000im70
0>OA`03WdL00000000<0k=6i00D000000>k@]03^d;@0k]2d000000030?3?[`040000003bcZ/0l/j[
000000<0llfX00<000000?ooo`3oool08@3oool00`000000002=0000000200HVZ0<000000P0hC[`0
2@000000ZkOR0:^ghP2[]n8000000>_^c0000000lnfD0000000U0?ooo`@000009`3oool005L0oooo
00<000000?ooo`3oool05P3oool00`00000016?I00000002000000@0X[_[0P0000030;G3i0050000
003Rd/L0h];70>;Ba`0000000`3WdL001@000000k=6i0>cA^@3/dKT0000000<0k]2d00D000000?3?
[`3`cjl0l<n_000000020?;>Z`050000003ccJP0llfX0??=Z00000008`3oool01P000000002=0000
000000001RJX00000080MHGE10000000102[]n8000000>_^c03[k/`300000240oooo1000000[0?oo
o`00F03oool00`000000oooo0?ooo`0F0?ooo`0300000004HmT016?I0080000000<0X[_[00000000
00001P2e`n@00`000000h];7000000030>OA`0050000003/dKT0k=6i0>cA^@0000000`3^d;@01@00
0000l<n_0?3?[`3`cjl0000000<0l/j[00@000000??=Z03ccJP000009@3oool01P000000002=0000
000000001RJX000000@0MHGE100000000`3[k/`000000000000N0?ooo`@00000;`3oool005T0oooo
00<000000?ooo`3oool05P3oool01@00000016?I00ASf@04HmT0000000P0]L?T100000020>OA`005
0000003/dKT0k=6i0>cA^@0000000`3^d;@01@000000l<n_0?3?[`3`cjl000000080l/j[00D00000
0??=Z03ccJP0llfX0000000V0?ooo`80000000<0<Dbn0000000000001`1eQMD3000001`0oooo0`00
000c0?ooo`00FP3oool2000001L0oooo0P0000000`04HmT000000;G3i0050;G3i08000001035am`3
00000080k=6i00<000000>k@]03^d;@00P3^d;@01@000000l<n_0?3?[`3`cjl000000080l/j[00D0
00000??=Z03ccJP0llfX0000000V0?ooo`8000000P0aC;h2000000D0MHGE00@000000<?7g@33amd0
0000603oool4000003H0oooo001L0?ooo`030000003oool0oooo01D0oooo100000040;G3i0030000
0035am`0aLOL00<0aLOL00L000000=39d`3@bM<0d<WC0000003/dKT0000000<0k]2d00D000000?3?
[`3`cjl0l<n_000000020?;>Z`050000003ccJP0llfX0??=Z0000000:03oool200000080<Dbn0P00
000207F5e@8000000P33amd00`000000oooo0?ooo`0C0?ooo`@00000>P3oool005d0oooo00<00000
0?ooo`3oool05@3oool01@00000087KS000000000000]L?T008000001@35am`00`000000d<WC0=39
d`030=39d`<000000P3^d;@01@000000l<n_0?3?[`3`cjl000000080l/j[00D000000??=Z03ccJP0
llfX0000000X0?ooo`8000000`0aC;h00`000000MHGE000000040<?7g@030000003oool0oooo00l0
oooo1000000n0?ooo`00GP3oool00`000000oooo0?ooo`0E0?ooo`030000000PM^<087KS00800000
1@35am`00`000000d<WC0=39d`040=39d`030000003Ib//0fL[;00@000000P3`cjl010000000l/j[
0?;>Z`0000030??=Z0030000003oool0oooo02L0oooo00<00000035<_P0aC;h00P0aC;h00`000000
`lOM0<?7g@020<?7g@030000003oool0oooo00`0oooo100000120?ooo`00G`3oool2000001H0oooo
0`0000000`0PM^<000000<G7g0020<G7g0030000003@bM<0d<WC00@0d<WC00<000000=W:b`3Ib//0
0P3Ib//00`000000gl[40=o:a007000000030??=Z0000000oooo02T0oooo0P000004035<_P040000
0033amd0`lOM000000`0oooo0`0000160?ooo`00H@3oool00`000000oooo0?ooo`0D0?ooo`030000
0010R^`000000080000000<0aLOL0000003@bM<01@3@bM<00`000000fL[;0=W:b`020=W:b`030000
003Ob/@0gl[40080gl[400@000000>C:_@3Tb[d000000P3WbKL2000002/0oooo1@000000100aC;h0
00000<?7g@0000080?ooo`@00000B@3oool00680oooo00<000000?ooo`3oool0503oool010000000
@8[/042:k010R^`2000000D0d<WC00<000000=W:b`3Ib//00P3Ib//00`000000gl[40=o:a0020=o:
a0040000003Tb[d0i<Zm000000@0ilVg00<000000?ooo`3oool0;P3oool3000000D0oooo1000001=
0?ooo`00H`3oool00`000000oooo0?ooo`0D0?ooo`0300000010R^`0@8[/0080@8[/00D000000=39
d`3@bM<0d<WC000000050=W:b`050000003Ob/@0gl[40=o:a00000000`3Tb[d01@000000ilVg0>O9
]`3WbKL0000003D0oooo1000001A0?ooo`00I03oool2000001D0oooo100000001010R^`000000=39
d`0000050=W:b`030000003Ob/@0gl[40080gl[400@000000>C:_@3Tb[d00000103WbKL00`000000
oooo0?ooo`0_0?ooo`@00000E@3oool006H0oooo00<000000?ooo`3oool04`3oool00`000000HIga
066Ml@04000000@0fL[;00<000000=o:a03Ob/@00P3Ob/@01@000000i<Zm0>C:_@3Tb[d0000000<0
ilVg00<000000?ooo`3oool0;03oool4000005T0oooo001W0?ooo`030000003oool0oooo01<0oooo
00<00000066Ml@1QWO400`1QWO401@000000fL[;0=W:b`3Ib//0000000<0gl[400D000000>C:_@3T
b[d0i<Zm000000040>O9]`030000003oool0oooo02T0oooo0`00001M0?ooo`00J03oool00`000000
oooo0?ooo`0C0?ooo`030000001QWO40HIga00<0HIga00<000000=W:b`000000103Ob/@01@000000
i<Zm0>C:_@3Tb[d0000000<0ilVg00<000000?ooo`3oool09P3oool400000600oooo001Y0?ooo`80
00004`3oool8000000@0gl[400<000000>C:_@3Tb[d00P3Tb[d01@000000ilVg0>O9]`3WbKL00000
02@0oooo1000001T0?ooo`00J`3oool00`000000oooo0?ooo`0@0?ooo`8000001P1o[?401@000000
gl[40=o:a03Ob/@0000000<0i<Zm00D000000>O9]`3WbKL0ilVg0000000Q0?ooo`@00000J03oool0
06`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0000000607n/l@030000003Ob/@00000
00@0i<Zm00D000000>O9]`3WbKL0ilVg0000000M0?ooo`@00000K03oool006d0oooo00<000000?oo
o`3oool03@3oool01@000000oooo0?ooo`3oool0000000<0Ojca1@0000030>C:_@050000003WbKL0
ilVg0>O9]`0000006`3oool300000700oooo001^0?ooo`8000003@3oool00`000000oooo0?ooo`02
0?ooo`<000001@2H]nd2000000030>C:_@000000ilVg0080ilVg00<000000?ooo`3oool05@3oool4
000007<0oooo001`0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0103oool00`00
0000V;O]09Rgk@0409Rgk@<000000P3WbKL00`000000oooo0?ooo`0B0?ooo`@00000M`3oool00740
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`050?ooo`030000002H]nd0V;O]00<0
00000`2]_^H00`000000ilVg0000000@0?ooo`@00000N`3oool00780oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`060?ooo`8000001P2]_^H2000000d0oooo1000001o0?ooo`00L`3o
ool2000000P0oooo00<000000?ooo`3oool01P3oool00`000000[KkV0:fniP040:fniP030000003o
ool0oooo00X0oooo0`0000230?ooo`00M@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00L0oooo00@000000:fniP2]_^H0[KkV0P0000090?ooo`@00000QP3oool007H0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`030000002]_^H0000000L0oooo1000002:
0?ooo`00M`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool00P3oool4000008h0oooo001h0?ooo`8000000`3oool00`000000oooo0?ooo`0:0?ooo`@0
0000TP3oool007X0oooo00@000000?ooo`3oool000002@3oool3000009H0oooo001k0?ooo`030000
003oool0000000D0oooo1000002I0?ooo`00O03oool2000000030?ooo`000000000000800000W@3o
ool007d0oooo0P00002Q0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {232.562, 0}} -> {-0.0710225, 0.0132781, \
0.00358144, 0.00358144}},
  CellTags->"T.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.1"]
}, Open  ]],

Cell[TextData[{
  "You can access many of the calculator features of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " just by pushing buttons in standard palettes. Click ",
  ButtonBox["this hyperlink",
    ButtonData:>{"BasicCalculations.nb", None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  " to check out the Basic Calculations palette. "
}], "GrayBox",
  CellTags->"T.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Power Computing with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  CellTags->"T.2"],

Cell[TextData[{
  "Even though you can use it as easily as a calculator, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gives you access to immense computational power."
}], "Subsection",
  CellTags->"T.2"],

Cell[TextData[{
  "This creates a 500 x 500 matrix of random numbers. ",
  "The semicolon at the end tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " not to print the matrix."
}], "Commentary",
  CellTags->"T.2"],

Cell[BoxData[
    \(\(m = Table[Random[], {500}, {500}];\)\)], "InputOnly",
  CellTags->"T.2"],

Cell[TextData[{
  "On most computers it takes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " only a second or so to compute all the eigenvalues of the matrix and plot \
them."
}], "Commentary",
  CellTags->"T.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[Abs[Eigenvalues[m]]]\)], "Input",
  CellTags->"T.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00190476 0.0147151 0.0552064 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.01131 .12513 -6 -4.5 ]
[.01131 .12513 0 4.5 ]
[.01131 .23554 -6 -4.5 ]
[.01131 .23554 0 4.5 ]
[.01131 .34595 -6 -4.5 ]
[.01131 .34595 0 4.5 ]
[.01131 .45637 -6 -4.5 ]
[.01131 .45637 0 4.5 ]
[.01131 .56678 -12 -4.5 ]
[.01131 .56678 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(100)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(200)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(300)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(400)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(500)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.0619 .01472 m
.0619 .01847 L
s
.1 .01472 m
.1 .01847 L
s
.1381 .01472 m
.1381 .01847 L
s
.17619 .01472 m
.17619 .01847 L
s
.25238 .01472 m
.25238 .01847 L
s
.29048 .01472 m
.29048 .01847 L
s
.32857 .01472 m
.32857 .01847 L
s
.36667 .01472 m
.36667 .01847 L
s
.44286 .01472 m
.44286 .01847 L
s
.48095 .01472 m
.48095 .01847 L
s
.51905 .01472 m
.51905 .01847 L
s
.55714 .01472 m
.55714 .01847 L
s
.63333 .01472 m
.63333 .01847 L
s
.67143 .01472 m
.67143 .01847 L
s
.70952 .01472 m
.70952 .01847 L
s
.74762 .01472 m
.74762 .01847 L
s
.82381 .01472 m
.82381 .01847 L
s
.8619 .01472 m
.8619 .01847 L
s
.9 .01472 m
.9 .01847 L
s
.9381 .01472 m
.9381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .12513 m
.03006 .12513 L
s
[(2)] .01131 .12513 1 0 Mshowa
.02381 .23554 m
.03006 .23554 L
s
[(4)] .01131 .23554 1 0 Mshowa
.02381 .34595 m
.03006 .34595 L
s
[(6)] .01131 .34595 1 0 Mshowa
.02381 .45637 m
.03006 .45637 L
s
[(8)] .01131 .45637 1 0 Mshowa
.02381 .56678 m
.03006 .56678 L
s
[(10)] .01131 .56678 1 0 Mshowa
.125 Mabswid
.02381 .04232 m
.02756 .04232 L
s
.02381 .06992 m
.02756 .06992 L
s
.02381 .09752 m
.02756 .09752 L
s
.02381 .15273 m
.02756 .15273 L
s
.02381 .18033 m
.02756 .18033 L
s
.02381 .20794 m
.02756 .20794 L
s
.02381 .26314 m
.02756 .26314 L
s
.02381 .29075 m
.02756 .29075 L
s
.02381 .31835 m
.02756 .31835 L
s
.02381 .37356 m
.02756 .37356 L
s
.02381 .40116 m
.02756 .40116 L
s
.02381 .42876 m
.02756 .42876 L
s
.02381 .48397 m
.02756 .48397 L
s
.02381 .51157 m
.02756 .51157 L
s
.02381 .53918 m
.02756 .53918 L
s
.02381 .59438 m
.02756 .59438 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02762 .3796 Mdot
.02952 .3796 Mdot
.03143 .37703 Mdot
.03333 .37565 Mdot
.03524 .37565 Mdot
.03714 .37478 Mdot
.03905 .37478 Mdot
.04095 .37226 Mdot
.04286 .37226 Mdot
.04476 .37043 Mdot
.04667 .37043 Mdot
.04857 .36769 Mdot
.05048 .36769 Mdot
.05238 .36539 Mdot
.05429 .36539 Mdot
.05619 .36523 Mdot
.0581 .36523 Mdot
.06 .36479 Mdot
.0619 .36479 Mdot
.06381 .36438 Mdot
.06571 .36438 Mdot
.06762 .36403 Mdot
.06952 .36403 Mdot
.07143 .36328 Mdot
.07333 .36328 Mdot
.07524 .36016 Mdot
.07714 .36016 Mdot
.07905 .35892 Mdot
.08095 .35892 Mdot
.08286 .35867 Mdot
.08476 .35867 Mdot
.08667 .35861 Mdot
.08857 .35861 Mdot
.09048 .35848 Mdot
.09238 .35848 Mdot
.09429 .35675 Mdot
.09619 .35675 Mdot
.0981 .35672 Mdot
.1 .35672 Mdot
.1019 .35589 Mdot
.10381 .35589 Mdot
.10571 .35561 Mdot
.10762 .35561 Mdot
.10952 .35452 Mdot
.11143 .35452 Mdot
.11333 .35442 Mdot
.11524 .35442 Mdot
.11714 .35418 Mdot
.11905 .35418 Mdot
.12095 .35344 Mdot
.12286 .35344 Mdot
.12476 .35305 Mdot
.12667 .35305 Mdot
.12857 .35182 Mdot
.13048 .35182 Mdot
.13238 .34991 Mdot
.13429 .34991 Mdot
.13619 .34923 Mdot
.1381 .34923 Mdot
.14 .34922 Mdot
.1419 .34922 Mdot
.14381 .34902 Mdot
.14571 .34902 Mdot
.14762 .34868 Mdot
.14952 .34868 Mdot
.15143 .34822 Mdot
.15333 .34822 Mdot
.15524 .34784 Mdot
.15714 .34784 Mdot
.15905 .34747 Mdot
.16095 .34747 Mdot
.16286 .3472 Mdot
.16476 .3472 Mdot
.16667 .34385 Mdot
.16857 .34385 Mdot
.17048 .34353 Mdot
.17238 .34353 Mdot
.17429 .34283 Mdot
.17619 .34283 Mdot
.1781 .34275 Mdot
.18 .34275 Mdot
.1819 .34174 Mdot
.18381 .34174 Mdot
.18571 .339 Mdot
.18762 .339 Mdot
.18952 .33897 Mdot
.19143 .33773 Mdot
.19333 .33773 Mdot
.19524 .33733 Mdot
.19714 .33733 Mdot
.19905 .33616 Mdot
.20095 .33616 Mdot
.20286 .33577 Mdot
.20476 .33577 Mdot
.20667 .33456 Mdot
.20857 .33456 Mdot
.21048 .33303 Mdot
.21238 .33303 Mdot
.21429 .33258 Mdot
.21619 .33258 Mdot
.2181 .33141 Mdot
.22 .33092 Mdot
.2219 .33092 Mdot
.22381 .33066 Mdot
.22571 .33066 Mdot
.22762 .33058 Mdot
.22952 .33058 Mdot
.23143 .33019 Mdot
.23333 .33019 Mdot
.23524 .32988 Mdot
.23714 .32988 Mdot
.23905 .32779 Mdot
.24095 .32779 Mdot
.24286 .32688 Mdot
.24476 .32688 Mdot
.24667 .3262 Mdot
.24857 .3262 Mdot
.25048 .32422 Mdot
.25238 .32422 Mdot
.25429 .32381 Mdot
.25619 .32381 Mdot
.2581 .32248 Mdot
.26 .32248 Mdot
.2619 .3212 Mdot
.26381 .3212 Mdot
.26571 .3202 Mdot
.26762 .3202 Mdot
.26952 .31978 Mdot
.27143 .31978 Mdot
.27333 .3196 Mdot
.27524 .3196 Mdot
.27714 .31947 Mdot
.27905 .31947 Mdot
.28095 .31786 Mdot
.28286 .31786 Mdot
.28476 .31602 Mdot
.28667 .31602 Mdot
.28857 .31413 Mdot
.29048 .31413 Mdot
.29238 .31407 Mdot
.29429 .31407 Mdot
.29619 .31357 Mdot
.2981 .31357 Mdot
.3 .3129 Mdot
.3019 .3129 Mdot
.30381 .31216 Mdot
.30571 .31216 Mdot
.30762 .31137 Mdot
.30952 .31137 Mdot
.31143 .31131 Mdot
.31333 .31131 Mdot
.31524 .31071 Mdot
.31714 .31071 Mdot
.31905 .30891 Mdot
.32095 .30891 Mdot
.32286 .30826 Mdot
.32476 .30826 Mdot
.32667 .30791 Mdot
.32857 .30791 Mdot
.33048 .30787 Mdot
.33238 .30787 Mdot
.33429 .30724 Mdot
.33619 .30724 Mdot
.3381 .30635 Mdot
.34 .30635 Mdot
.3419 .30611 Mdot
.34381 .30611 Mdot
.34571 .30319 Mdot
.34762 .30319 Mdot
.34952 .30224 Mdot
.35143 .30224 Mdot
.35333 .30191 Mdot
.35524 .30191 Mdot
.35714 .30134 Mdot
.35905 .30134 Mdot
.36095 .30084 Mdot
.36286 .30084 Mdot
.36476 .30084 Mdot
.36667 .30084 Mdot
.36857 .30078 Mdot
.37048 .30078 Mdot
.37238 .29914 Mdot
.37429 .29914 Mdot
.37619 .29859 Mdot
.3781 .29859 Mdot
.38 .29708 Mdot
.3819 .29708 Mdot
.38381 .29576 Mdot
.38571 .29576 Mdot
.38762 .29481 Mdot
.38952 .29481 Mdot
.39143 .29398 Mdot
.39333 .29398 Mdot
.39524 .29366 Mdot
.39714 .29366 Mdot
.39905 .29218 Mdot
.40095 .29218 Mdot
.40286 .29197 Mdot
.40476 .29197 Mdot
.40667 .29111 Mdot
.40857 .29111 Mdot
.41048 .28969 Mdot
.41238 .28969 Mdot
.41429 .28865 Mdot
.41619 .28865 Mdot
.4181 .2847 Mdot
.42 .2847 Mdot
.4219 .2843 Mdot
.42381 .2843 Mdot
.42571 .28386 Mdot
.42762 .28386 Mdot
.42952 .28272 Mdot
.43143 .28102 Mdot
.43333 .28102 Mdot
.43524 .28049 Mdot
.43714 .28049 Mdot
.43905 .28012 Mdot
.44095 .28012 Mdot
.44286 .27909 Mdot
.44476 .27909 Mdot
.44667 .27859 Mdot
.44857 .27859 Mdot
.45048 .27712 Mdot
.45238 .27712 Mdot
.45429 .27632 Mdot
.45619 .27632 Mdot
.4581 .27577 Mdot
.46 .27577 Mdot
.4619 .27494 Mdot
.46381 .27494 Mdot
.46571 .27427 Mdot
.46762 .27427 Mdot
.46952 .27414 Mdot
.47143 .27414 Mdot
.47333 .27305 Mdot
.47524 .27305 Mdot
.47714 .27276 Mdot
.47905 .27276 Mdot
.48095 .26894 Mdot
.48286 .26894 Mdot
.48476 .26782 Mdot
.48667 .26782 Mdot
.48857 .26716 Mdot
.49048 .26716 Mdot
.49238 .26713 Mdot
.49429 .26713 Mdot
.49619 .26702 Mdot
.4981 .26702 Mdot
.5 .26698 Mdot
.5019 .26698 Mdot
.50381 .26565 Mdot
.50571 .26565 Mdot
.50762 .2654 Mdot
.50952 .2654 Mdot
.51143 .26423 Mdot
.51333 .26423 Mdot
.51524 .26238 Mdot
.51714 .26238 Mdot
.51905 .25893 Mdot
.52095 .25893 Mdot
.52286 .25748 Mdot
.52476 .25748 Mdot
.52667 .25747 Mdot
.52857 .25747 Mdot
.53048 .25719 Mdot
.53238 .25719 Mdot
.53429 .25712 Mdot
.53619 .25712 Mdot
.5381 .25703 Mdot
.54 .25607 Mdot
.5419 .25607 Mdot
.54381 .25602 Mdot
.54571 .25602 Mdot
.54762 .25468 Mdot
.54952 .25468 Mdot
.55143 .25455 Mdot
.55333 .25455 Mdot
.55524 .25252 Mdot
.55714 .25252 Mdot
.55905 .25158 Mdot
.56095 .25158 Mdot
.56286 .25139 Mdot
.56476 .25139 Mdot
.56667 .2502 Mdot
.56857 .2502 Mdot
.57048 .2499 Mdot
.57238 .2499 Mdot
.57429 .24859 Mdot
.57619 .24859 Mdot
.5781 .24807 Mdot
.58 .24807 Mdot
.5819 .24609 Mdot
.58381 .24609 Mdot
.58571 .24478 Mdot
.58762 .24478 Mdot
.58952 .24264 Mdot
.59143 .2423 Mdot
.59333 .2423 Mdot
.59524 .24071 Mdot
.59714 .24071 Mdot
.59905 .2379 Mdot
.60095 .2379 Mdot
.60286 .23747 Mdot
.60476 .23747 Mdot
.60667 .23679 Mdot
.60857 .23679 Mdot
.61048 .23231 Mdot
.61238 .23231 Mdot
.61429 .23075 Mdot
.61619 .23075 Mdot
.6181 .22852 Mdot
.62 .22852 Mdot
.6219 .22846 Mdot
.62381 .22846 Mdot
.62571 .22807 Mdot
.62762 .22807 Mdot
.62952 .22762 Mdot
.63143 .22762 Mdot
.63333 .22715 Mdot
.63524 .22715 Mdot
.63714 .22702 Mdot
.63905 .22702 Mdot
.64095 .22413 Mdot
.64286 .22413 Mdot
.64476 .22366 Mdot
.64667 .22366 Mdot
.64857 .2227 Mdot
.65048 .2227 Mdot
.65238 .2203 Mdot
.65429 .2203 Mdot
.65619 .21935 Mdot
.6581 .21935 Mdot
.66 .21811 Mdot
.6619 .21811 Mdot
.66381 .21793 Mdot
.66571 .21793 Mdot
.66762 .21758 Mdot
.66952 .21758 Mdot
.67143 .21685 Mdot
.67333 .21685 Mdot
.67524 .21684 Mdot
.67714 .21684 Mdot
.67905 .21597 Mdot
.68095 .21404 Mdot
.68286 .21404 Mdot
.68476 .21375 Mdot
.68667 .21375 Mdot
.68857 .2132 Mdot
.69048 .2132 Mdot
.69238 .21124 Mdot
.69429 .21124 Mdot
.69619 .20726 Mdot
.6981 .20726 Mdot
.7 .20725 Mdot
.7019 .20725 Mdot
.70381 .20493 Mdot
.70571 .20493 Mdot
.70762 .20427 Mdot
.70952 .20427 Mdot
.71143 .20404 Mdot
.71333 .20404 Mdot
.71524 .20334 Mdot
.71714 .20334 Mdot
.71905 .20297 Mdot
.72095 .20297 Mdot
.72286 .20262 Mdot
.72476 .20262 Mdot
.72667 .19674 Mdot
.72857 .19674 Mdot
.73048 .19646 Mdot
.73238 .19646 Mdot
.73429 .19574 Mdot
.73619 .19574 Mdot
.7381 .19531 Mdot
.74 .19531 Mdot
.7419 .19341 Mdot
.74381 .19341 Mdot
.74571 .1909 Mdot
.74762 .1909 Mdot
.74952 .19043 Mdot
.75143 .19043 Mdot
.75333 .18416 Mdot
.75524 .18416 Mdot
.75714 .18378 Mdot
.75905 .18378 Mdot
.76095 .18189 Mdot
.76286 .18189 Mdot
.76476 .18039 Mdot
.76667 .18039 Mdot
.76857 .17995 Mdot
.77048 .17995 Mdot
.77238 .17871 Mdot
.77429 .17871 Mdot
.77619 .17712 Mdot
.7781 .17712 Mdot
.78 .1769 Mdot
.7819 .17645 Mdot
.78381 .17645 Mdot
.78571 .17409 Mdot
.78762 .17409 Mdot
.78952 .17283 Mdot
.79143 .17283 Mdot
.79333 .17077 Mdot
.79524 .17077 Mdot
.79714 .16957 Mdot
.79905 .16957 Mdot
.80095 .16324 Mdot
.80286 .16324 Mdot
.80476 .16216 Mdot
.80667 .16216 Mdot
.80857 .16067 Mdot
.81048 .16067 Mdot
.81238 .15991 Mdot
.81429 .15991 Mdot
.81619 .15988 Mdot
.8181 .15988 Mdot
.82 .15908 Mdot
.8219 .15908 Mdot
.82381 .15895 Mdot
.82571 .15895 Mdot
.82762 .15665 Mdot
.82952 .15665 Mdot
.83143 .14991 Mdot
.83333 .14991 Mdot
.83524 .14677 Mdot
.83714 .14677 Mdot
.83905 .14605 Mdot
.84095 .14605 Mdot
.84286 .14512 Mdot
.84476 .14512 Mdot
.84667 .14292 Mdot
.84857 .14292 Mdot
.85048 .14076 Mdot
.85238 .14076 Mdot
.85429 .13961 Mdot
.85619 .13961 Mdot
.8581 .13647 Mdot
.86 .13647 Mdot
.8619 .13528 Mdot
.86381 .13528 Mdot
.86571 .13492 Mdot
.86762 .13492 Mdot
.86952 .13476 Mdot
.87143 .13476 Mdot
.87333 .1325 Mdot
.87524 .1321 Mdot
.87714 .1321 Mdot
.87905 .13039 Mdot
.88095 .13039 Mdot
.88286 .13038 Mdot
.88476 .13038 Mdot
.88667 .12814 Mdot
.88857 .12814 Mdot
.89048 .12466 Mdot
.89238 .12466 Mdot
.89429 .12348 Mdot
.89619 .12348 Mdot
.8981 .12287 Mdot
.9 .11649 Mdot
.9019 .11649 Mdot
.90381 .11468 Mdot
.90571 .11468 Mdot
.90762 .10995 Mdot
.90952 .10729 Mdot
.91143 .10729 Mdot
.91333 .10492 Mdot
.91524 .10492 Mdot
.91714 .10453 Mdot
.91905 .10453 Mdot
.92095 .1039 Mdot
.92286 .1039 Mdot
.92476 .10017 Mdot
.92667 .10017 Mdot
.92857 .09924 Mdot
.93048 .09924 Mdot
.93238 .08673 Mdot
.93429 .08475 Mdot
.93619 .08219 Mdot
.9381 .08219 Mdot
.94 .07905 Mdot
.9419 .07905 Mdot
.94381 .07105 Mdot
.94571 .07105 Mdot
.94762 .07083 Mdot
.94952 .07083 Mdot
.95143 .06887 Mdot
.95333 .06887 Mdot
.95524 .0653 Mdot
.95714 .0653 Mdot
.95905 .06499 Mdot
.96095 .06499 Mdot
.96286 .05981 Mdot
.96476 .05686 Mdot
.96667 .05686 Mdot
.96857 .0433 Mdot
.97048 .03879 Mdot
.97238 .03879 Mdot
.97429 .03204 Mdot
.97619 .02856 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{5, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00?03oool3o`0000@0oooo0_l000040?ooo`;o0000903oool5o`0000<0oooo0_l000040?oo
o`;o00009@3oool3o`0000@0oooo0_l000040?ooo`;o00009P3oool3o`0000<0oooo0_l000040?oo
o`;o00009@3oool3o`0000@0oooo0_l000040?ooo`;o00001@3oool003d0oooo00?o00000?ooo`3o
ool00P3oool01?l00000oooo0?ooool000020?ooo`04o`00003oool0ooooo`0002@0oooo00Co0000
0?ooo`3ooooo00000P3oool01?l00000oooo0?ooool000020?ooo`04o`00003oool0ooooo`0002<0
oooo00Go00000?ooo`3oool0ooooo`0000020?ooo`04o`00003oool0ooooo`000080oooo00Co0000
0?ooo`3ooooo00009P3oool01Ol00000oooo0?ooo`3ooooo00000080oooo00Co00000?ooo`3ooooo
00000P3oool00ol00000oooo0?ooo`0Q0?ooo`05o`00003oool0oooo0?ooool000000P3oool01?l0
0000oooo0?ooool000020?ooo`04o`00003oool0ooooo`0000@0oooo000m0?ooo`03o`00003oool0
oooo0080oooo00Co00000?ooo`3ooooo00000P3oool01?l00000oooo0?ooool0000U0?ooo`03o`00
003oool0oooo0080oooo00Co00000?ooo`3ooooo00000P3oool01?l00000oooo0?ooool0000W0?oo
o`04o`00003oool0ooooo`000080oooo00Co00000?ooo`3ooooo00000P3oool00ol00000oooo0?oo
o`0Q0?ooo`Go00000P3oool01?l00000oooo0?ooool000020?ooo`04o`00003oool0ooooo`0002L0
oooo00Co00000?ooo`3ooooo00000P3oool01?l00000oooo0?ooool000020?ooo`03o`00003oool0
oooo0080oooo000m0?ooo`03o`00003oool0oooo0080oooo00Co00000?ooo`3ooooo00000P3oool0
1?l00000oooo0?ooool0000V0?ooo`05o`00003oool0oooo0?ooool000000P3oool01?l00000oooo
0?ooool000020?ooo`03o`00003oool0oooo02<0oooo0_l000030?ooo`04o`00003oool0ooooo`00
0080oooo00Co00000?ooo`3ooooo00008`3oool01?l00000oooo0?ooool000030?ooo`04o`00003o
ool0ooooo`000080oooo00Co00000?ooo`3ooooo00009`3oool01?l00000oooo0?ooool000020?oo
o`04o`00003oool0ooooo`000080oooo00?o00000?ooo`3oool00P3oool003d0oooo00?o00000?oo
o`3oool00P3oool01?l00000oooo0?ooool000020?ooo`04o`00003oool0ooooo`0002<0oooo00Go
00000?ooo`3oool0ooooo`0000020?ooo`04o`00003oool0ooooo`000080oooo00Co00000?ooo`3o
oooo00009`3oool01?l00000oooo0?ooool000020?ooo`04o`00003oool0ooooo`000080oooo00?o
00000?ooo`3oool08P3oool00ol00000ooooo`0000030?ooo`04o`00003oool0ooooo`000080oooo
00Co00000?ooo`3ooooo00008`3oool4o`0000<0oooo00Co00000?ooo`3ooooo00000P3oool01?l0
0000oooo0?ooool000040?ooo`00?03oool2o`0000@0oooo00Co00000?ooo`3ooooo00000P3oool0
1?l00000oooo0?ooool0000S0?ooo`05o`00003oool0oooo0?ooool000000P3oool01?l00000oooo
0?ooool000020?ooo`04o`00003oool0ooooo`0002<0oooo00Go00000?ooo`3oool0ooooo`000002
0?ooo`04o`00003oool0ooooo`000080oooo00Co00000?ooo`3ooooo00009@3oool2o`0000<0oooo
00Co00000?ooo`3ooooo00000P3oool01?l00000oooo0?ooool0000S0?ooo`03o`00003oool0oooo
00@0oooo00Co00000?ooo`3ooooo00000P3oool01?l00000oooo0?ooool000040?ooo`00?@3oool0
0ol00000oooo0?ooo`030?ooo`;o0000103oool2o`0002D0oooo0ol000040?ooo`;o0000103oool2
o`0002D0oooo0ol000040?ooo`;o0000103oool2o`0002L0oooo00?o00000?ooo`3oool00P3oool2
o`0000@0oooo0_l0000T0?ooo`Go00000`3oool2o`0000@0oooo0_l000050?ooo`00403oool00`00
0000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3oool00100oooo
00<000000?ooo`3oool0o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000:
0?ooool000004`0000040?ooo`00403oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo
00L0oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo
00L0oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo
00L0oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`070?ooo`030000003oool0oooo
00P0oooo00?o00000?ooo`3oool01`3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo
00P0oooo00?o00000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03o`00003oool0oooo
00L0oooo00?o00000?ooo`3oool01`3oool00ol00000oooo0?ooo`080?ooo`03o`00003oool0oooo
00L0oooo00<000000?ooo`3oool0203oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo
00L0oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`070?ooo`030000003oool0oooo
00T0oooo000@0?ooo`030000003oool0oooo0340oooo00?o00000?ooo`3oool0<@3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`090?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`80oooo0_l0000:0?ooo`00403o
ool00`000000oooo0?ooo`3o0?ooo`40oooo0ol0000:0?ooo`00403oool00`000000oooo0?ooo`3o
0?ooo`40oooo0_l0000;0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`;o0000303oool00100
oooo00<00000o`00003oool0oP3oool3o`0000`0oooo000@0?ooo`030000003oool0oooo0?h0oooo
0_l0000=0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0
oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o@3oool3o`0000d0oooo000@0?ooo`03
0000003oool0oooo0?d0oooo0ol0000=0?ooo`00403oool00`000000oooo0?ooo`3k0?ooo`Co0000
3P3oool00100oooo00<000000?ooo`3oool0nP3oool4o`0000l0oooo000@0?ooo`0300000?l00000
oooo0?P0oooo1?l0000A0?ooo`00403oool00`000000oooo0?ooo`3h0?ooo`?o00004P3oool00100
oooo00<000000?ooo`3oool0m`3oool2o`0001@0oooo000@0?ooo`030000003oool0oooo0?H0oooo
0ol0000D0?ooo`00403oool00`000000oooo0?ooo`3e0?ooo`?o00005@3oool00100oooo00<00000
0?ooo`3oool0m@3oool2o`0001H0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3oool00100
oooo00<000000?ooo`3oool0o`3oool>0?ooo`00403oool00`00003o00000?ooo`3b0?ooo`Co0000
5`3oool00100oooo00<000000?ooo`3oool0k`3oool7o`0001L0oooo000@0?ooo`030000003oool0
oooo0>h0oooo1_l0000I0?ooo`00403oool00`000000oooo0?ooo`3^0?ooo`?o0000703oool00100
oooo00<000000?ooo`3oool0k03oool4o`0001d0oooo00070?ooo`Go0000103oool00`000000oooo
0?ooo`3/0?ooo`?o00007P3oool000P0oooo00Co00000?ooo`3ooooo0000103oool00`000000oooo
0?ooo`3Z0?ooo`?o0000803oool000T0oooo00?o00000?ooo`3oool0103oool300000>P0oooo1Ol0
000P0?ooo`002P3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo0>H0oooo1_l0000Q
0?ooo`001`3oool01Ol00000oooo0?ooo`3ooooo000000@0oooo00<000000?ooo`3oool0h@3oool9
o`0002<0oooo00070?ooo`05o`00003oool0oooo0?ooool00000103oool00`000000oooo0?ooo`3P
0?ooo`Oo00009P3oool000P0oooo0ol000050?ooo`030000003oool0oooo0=d0oooo1_l0000Z0?oo
o`00403oool00`000000oooo0?ooo`3K0?ooo`Oo0000:`3oool00100oooo00<000000?ooo`3oool0
f@3oool6o`0002h0oooo000@0?ooo`030000003oool0oooo0=T0oooo1?l0000`0?ooo`00403oool0
0`00003o00000?ooo`3H0?ooo`?o0000<P3oool00100oooo00<000000?ooo`3oool0d`3oool8o`00
0380oooo000@0?ooo`030000003oool0oooo0=40oooo2?l0000d0?ooo`00403oool00`000000oooo
0?ooo`3A0?ooo`?o0000>@3oool00100oooo00<000000?ooo`3oool0c`3oool3o`0003/0oooo000@
0?ooo`030000003oool0oooo0<d0oooo1Ol0000k0?ooo`00403oool00`000000oooo0?ooo`390?oo
o`Oo0000?@3oool00100oooo00<00000o`00003oool0aP3oool8o`0003l0oooo000@0?ooo`030000
003oool0oooo0<@0oooo1_l000130?ooo`00403oool00`000000oooo0?ooo`330?ooo`Co0000AP3o
ool00100oooo00<000000?ooo`3oool0`@3oool4o`0004P0oooo000@0?ooo`030000003oool0oooo
0;`0oooo2?l000190?ooo`00403oool00`000000oooo0?ooo`2l0?ooo`Ko0000B`3oool00100oooo
00<000000?ooo`3oool0]P3oool8o`0004l0oooo000@0?ooo`030000003oool0oooo0;@0oooo2_l0
001?0?ooo`00403oool00`00003o00000?ooo`2c0?ooo`Go0000E@3oool00100oooo00<000000?oo
o`3oool0[`3oool7o`0005L0oooo000@0?ooo`030000003oool0oooo0:T0oooo3?l0001H0?ooo`00
403oool00`000000oooo0?ooo`2W0?ooo`[o0000G03oool00100oooo00<000000?ooo`3oool0X`3o
ool8o`000680oooo00090?ooo`?o0000103oool00`000000oooo0?ooo`2N0?ooo`_o0000I03oool0
00X0oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`2M0?ooo`Oo0000J@3oool000L0
oooo1Ol000040?ooo`<00000VP3oool5o`0006h0oooo00070?ooo`04o`00003oool0ooooo`0000D0
oooo00<000000?ooo`3oool0V@3oool5o`0006l0oooo00080?ooo`03o`00003ooooo000000D0oooo
00<000000?ooo`3oool0UP3oool5o`000780oooo00090?ooo`;o00001@3oool00`000000oooo0?oo
o`2C0?ooo`Oo0000L`3oool000X0oooo00?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`2>
0?ooo`Wo0000MP3oool00100oooo00<000000?ooo`3oool0RP3oool:o`0007T0oooo000@0?ooo`03
0000003oool0oooo08@0oooo2ol0001n0?ooo`00403oool00`000000oooo0?ooo`230?ooo`So0000
PP3oool00100oooo00<00000o`00003oool0O03oool9o`0008P0oooo000@0?ooo`030000003oool0
oooo07T0oooo2ol000290?ooo`00403oool00`000000oooo0?ooo`1d0?ooo`Wo0000T03oool00100
oooo00<000000?ooo`3oool0L03oool;o`000980oooo000@0?ooo`030000003oool0oooo06`0oooo
2_l0002G0?ooo`00403oool00`000000oooo0?ooo`1X0?ooo`[o0000V`3oool00100oooo00<00000
0?ooo`3oool0I`3oool6o`000:00oooo000@0?ooo`0300000?l00000oooo06<0oooo1ol0002S0?oo
o`00403oool00`000000oooo0?ooo`1O0?ooo`[o0000Y03oool00100oooo00<000000?ooo`3oool0
G03oool9o`000:P0oooo000@0?ooo`030000003oool0oooo05D0oooo2ol0002]0?ooo`00403oool0
0`000000oooo0?ooo`1?0?ooo`ko0000/03oool00100oooo00<000000?ooo`3oool0BP3oool<o`00
0;L0oooo000@0?ooo`030000003oool0oooo04D0oooo3?l0002l0?ooo`00403oool00`000000oooo
0?ooo`130?ooo`Wo0000`@3oool00100oooo00<00000o`00003oool0?@3oool9o`000<L0oooo000@
0?ooo`030000003oool0oooo03X0oooo2_l000390?ooo`00403oool00`000000oooo0?ooo`0f0?oo
o`So0000c`3oool00100oooo00<000000?ooo`3oool0<03oool;o`000=80oooo000@0?ooo`030000
003oool0oooo02d0oooo2ol0003E0?ooo`00203oool3o`0000D0oooo00<000000?ooo`3oool0:@3o
ool8o`000=`0oooo00070?ooo`05o`00003oool0oooo0?ooool00000103oool00`000000oooo0?oo
o`0T0?ooo`[o0000g`3oool000L0oooo00Go00000?ooo`3oool0ooooo`0000040?ooo`<00000803o
ool:o`000><0oooo00070?ooo`Co00001@3oool00`000000oooo0?ooo`0I0?ooo`co0000j03oool0
00L0oooo00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`ko0000k03oool000P0
oooo00?o00000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`oo0000lP3oool000T0oooo
0_l000050?ooo`030000003oool0oooo00/0oooo2_l0003h0?ooo`00403oool00`000000oooo0?oo
o`050?ooo`So0000o`3oool10?ooo`00403oool00`000000oooo0?ooo`040?ooo`So0000o`3oool2
0?ooo`00403oool010000000oooo0?ooo`3oool5o`000?l0oooo203oool00100oooo00<00000o`00
0?l000001Ol0003o0?ooo`T0oooo000@0?ooo`0300000?l0003o000000?o0000o`3oool;0?ooo`00
403oool00`00003o0000o`00003o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3o
ool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?oo
o`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3oool00100oooo00<00000o`00003oool0
o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0
oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00403oool00`000000
oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3oool00100oooo00<0
00000?ooo`3oool0o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?oo
o`0300000?l00000oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00
403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3o
ool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00203oool3o`0000D0oooo00<000000?oo
o`3oool0o`3oool>0?ooo`001`3oool01Ol00000oooo0?ooo`3ooooo000000@0oooo00<000000?oo
o`3oool0o`3oool>0?ooo`001`3oool01Ol00000oooo0?ooo`3ooooo000000@0oooo0`00003o0?oo
o`h0oooo00080?ooo`?o00001@3oool00`000000oooo0?ooo`3o0?ooo`h0oooo00070?ooo`05o`00
003oool0oooo0?ooool00000103oool00`000000oooo0?ooo`3o0?ooo`h0oooo00070?ooo`05o`00
003oool0oooo0?ooool00000103oool00`000000oooo0?ooo`3o0?ooo`h0oooo00080?ooo`?o0000
1@3oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3o
ool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?oo
o`h0oooo000@0?ooo`0300000?l00000oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0
o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0
oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00403oool00`000000
oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3oool00100oooo00<0
0000o`00003oool0o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?oo
o`030000003oool0oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00
403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3o
ool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?oo
o`h0oooo000@0?ooo`0300000?l00000oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0
o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0
oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`000P3oool3o`0000@0
oooo0_l000050?ooo`030000003oool0oooo0?l0oooo3P3oool000<0oooo00?o00000?ooo`3oool0
0P3oool01?l00000oooo0?ooool000040?ooo`030000003oool0oooo0?l0oooo3P3oool000<0oooo
00?o00000?ooo`3oool00P3oool01?l00000oooo0?ooool000040?ooo`030000003oool0oooo0?l0
oooo3P3oool000<0oooo00?o00000?ooo`3oool00P3oool01?l00000oooo0?ooool000040?ooo`<0
0000o`3oool>0?ooo`000`3oool00ol00000oooo0?ooo`020?ooo`04o`00003oool0ooooo`0000@0
oooo00<000000?ooo`3oool0o`3oool>0?ooo`000P3oool2o`0000@0oooo00Co00000?ooo`3ooooo
0000103oool00`000000oooo0?ooo`3o0?ooo`h0oooo00030?ooo`03o`00003oool0oooo00<0oooo
0_l000050?ooo`030000003oool0oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o`3o
ool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo
0?l0oooo3P3oool00100oooo00<00000o`00003oool0o`3oool>0?ooo`00403oool00`000000oooo
0?ooo`3o0?ooo`h0oooo000@0?ooo`030000003oool0oooo0?l0oooo3P3oool00100oooo00<00000
0?ooo`3oool0o`3oool>0?ooo`00403oool00`000000oooo0?ooo`3o0?ooo`h0oooo000@0?ooo`03
0000003oool0oooo0?l0oooo3P3oool00100oooo00<000000?ooo`3oool0o`3oool>0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-32.4268, -0.824191, \
1.92514, 0.0664223}},
  CellTags->"T.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can handle numbers of any size."
}], "Commentary",
  CellTags->"T.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(100!\)\)], "Input",
  CellTags->"T.2"],

Cell[BoxData[
    \(933262154439441526816992388562667004907159682643816214685929638952175999\
932299156089414639761565182862536979208272237582511852109168640000000000000000\
00000000\)], "Output",
  CellTags->"T.2"]
}, Open  ]],

Cell["This works out a numerical 100-digit approximation to pi.", "Commentary",
  CellTags->"T.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Pi, 100]\)], "Input",
  CellTags->"T.2"],

Cell[BoxData[
    \(3.1415926535897932384626433832795028841971693993751058209749445923078164\
062862089986280348253421170679821480865124059`100. \)], "Output",
  CellTags->"T.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can work with formulas of any length\[LongDash]solving problems that \
would have taken years by hand."
}], "Subsubsection",
  CellTags->"T.2"],

Cell[" ", "LineSpace",
  CellTags->"T.2"],

Cell[TextData[{
  "This asks ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to factor a polynomial."
}], "Commentary",
  CellTags->"T.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[x^99 + y^99]\)], "Input",
  CellTags->"T.2"],

Cell[BoxData[
    \(\((x + y)\)\ \((x\^2 - x\ y + y\^2)\)\ \((x\^6 - x\^3\ y\^3 + 
          y\^6)\)\ \((x\^10 - x\^9\ y + x\^8\ y\^2 - x\^7\ y\^3 + 
          x\^6\ y\^4 - x\^5\ y\^5 + x\^4\ y\^6 - x\^3\ y\^7 + x\^2\ y\^8 - 
          x\ y\^9 + y\^10)\)\ \((x\^20 + x\^19\ y - x\^17\ y\^3 - 
          x\^16\ y\^4 + x\^14\ y\^6 + x\^13\ y\^7 - x\^11\ y\^9 - 
          x\^10\ y\^10 - x\^9\ y\^11 + x\^7\ y\^13 + x\^6\ y\^14 - 
          x\^4\ y\^16 - x\^3\ y\^17 + x\ y\^19 + y\^20)\)\ \((x\^60 + 
          x\^57\ y\^3 - x\^51\ y\^9 - x\^48\ y\^12 + x\^42\ y\^18 + 
          x\^39\ y\^21 - x\^33\ y\^27 - x\^30\ y\^30 - x\^27\ y\^33 + 
          x\^21\ y\^39 + x\^18\ y\^42 - x\^12\ y\^48 - x\^9\ y\^51 + 
          x\^3\ y\^57 + y\^60)\)\)], "Output",
  CellTags->"T.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calls on sophisticated algorithms to simplify formulas."
}], "Commentary",
  CellTags->"T.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[%]\)], "Input",
  CellTags->"T.2"],

Cell[BoxData[
    \(x\^99 + y\^99\)], "Output",
  CellTags->"T.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has achieved world records\[LongDash]for both size and speed\[LongDash]in \
many kinds of computations."
}], "Subsubsection",
  CellTags->"T.2"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " takes only a few seconds to work out how many ways a billion can be \
partitioned into sums\[LongDash]a frontier number theory calculation."
}], "Commentary",
  CellTags->"T.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PartitionsP[10^9] // Short\)], "Input",
  CellTags->"T.2"],

Cell[BoxData[
    TagBox[\(160453508428096688327 \[LeftSkeleton]35147\[RightSkeleton] 
        526857797923685688339\),
      Short]], "Output",
  CellTags->"T.2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Accessing Algorithms in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section",
  CellTags->"T.3"],

Cell[TextData[{
  "Whenever you use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " you are accessing the world\[CloseCurlyQuote]s largest collection of \
computational algorithms."
}], "Subsection",
  CellTags->"T.3"],

Cell[TextData[{
  "In each case, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatically chooses the best algorithm to use."
}], "Commentary",
  CellTags->"T.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Cos[x] == x + Log[x], {x, 1}]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    \({x \[Rule] 0.8406188356435845`}\)], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Log[x + Sin[x]], {x, 0, 2}]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    \(0.5558893538982785`\)], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[x^5 - 6  x^3 + 8  x + 1 == 0, x]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    \({{x \[Rule] \(-2.0541071517901104`\)}, {x \[Rule] \
\(-1.2915007115165924`\)}, {x \[Rule] \(-0.12651469098984336`\)}, {x \[Rule] 
          1.5505265929875833`}, {x \[Rule] 1.921595961308963`}}\)], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{Cos[x\ y] + x, x^2 + y^2 \[LessEqual] 10}, {x, 
        y}]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    \({\(-3.990114927330392`\), {x \[Rule] \(-2.9980939417791075`\), 
        y \[Rule] 1.0057001124924938`}}\)], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has state-of-the-art algorithms, here for factoring integers."
}], "Commentary",
  CellTags->"T.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[10^54 - 3]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    \({{21518801375655714851137, 1}, {46470989835488840363806434126781, 
        1}}\)], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell["\<\
This generates a two-dimensional table corresponding to a matrix.\
\
\>", "Commentary",
  CellTags->"T.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = Table[2^i + x^j, {i, 3}, {j, 4}]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    \({{2 + x, 2 + x\^2, 2 + x\^3, 2 + x\^4}, {4 + x, 4 + x\^2, 4 + x\^3, 
        4 + x\^4}, {8 + x, 8 + x\^2, 8 + x\^3, 8 + x\^4}}\)], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell["This displays the table in matrix form.", "Commentary",
  CellTags->"T.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[m]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(2 + x\), \(2 + x\^2\), \(2 + x\^3\), \(2 + x\^4\)},
            {\(4 + x\), \(4 + x\^2\), \(4 + x\^3\), \(4 + x\^4\)},
            {\(8 + x\), \(8 + x\^2\), \(8 + x\^3\), \(8 + x\^4\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell["This computes the null space of the matrix.", "Commentary",
  CellTags->"T.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NullSpace[m]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    \({{x + x\^2, \(-1\) - x - x\^2, 0, 1}, {x, \(-1\) - x, 1, 
        0}}\)], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve differential equations both symbolically and numerically."
}], "Subsubsection",
  CellTags->"T.3"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " solves a nonlinear differential equation numerically."
}], "Commentary",
  CellTags->"T.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t] + x[t]^3 == Sin[t], x[0] == \(x'\)[0] == 0}, 
      x, {t, 0, 50}]\)], "Input",
  CellTags->"T.3"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 50.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell["\<\
The answer is an interpolating function which implicitly represents \
the whole solution. Here is a parametric plot of the solution.\
\>", \
"Commentary",
  CellTags->"T.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[Evaluate[{x[t], \(x'\)[t]} /. %], {t, 0, 50}]\)], "Input",\

  CellTags->"T.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.525672 0.240046 0.309093 0.11068 [
[.04558 .29659 -6 -9 ]
[.04558 .29659 6 0 ]
[.28563 .29659 -6 -9 ]
[.28563 .29659 6 0 ]
[.76572 .29659 -3 -9 ]
[.76572 .29659 3 0 ]
[.51317 .08773 -12 -4.5 ]
[.51317 .08773 0 4.5 ]
[.51317 .19841 -12 -4.5 ]
[.51317 .19841 0 4.5 ]
[.51317 .41977 -6 -4.5 ]
[.51317 .41977 0 4.5 ]
[.51317 .53045 -6 -4.5 ]
[.51317 .53045 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04558 .30909 m
.04558 .31534 L
s
[(-2)] .04558 .29659 0 1 Mshowa
.28563 .30909 m
.28563 .31534 L
s
[(-1)] .28563 .29659 0 1 Mshowa
.76572 .30909 m
.76572 .31534 L
s
[(1)] .76572 .29659 0 1 Mshowa
.125 Mabswid
.09359 .30909 m
.09359 .31284 L
s
.1416 .30909 m
.1416 .31284 L
s
.18961 .30909 m
.18961 .31284 L
s
.23762 .30909 m
.23762 .31284 L
s
.33363 .30909 m
.33363 .31284 L
s
.38164 .30909 m
.38164 .31284 L
s
.42965 .30909 m
.42965 .31284 L
s
.47766 .30909 m
.47766 .31284 L
s
.57368 .30909 m
.57368 .31284 L
s
.62169 .30909 m
.62169 .31284 L
s
.6697 .30909 m
.6697 .31284 L
s
.71771 .30909 m
.71771 .31284 L
s
.81373 .30909 m
.81373 .31284 L
s
.86174 .30909 m
.86174 .31284 L
s
.90975 .30909 m
.90975 .31284 L
s
.95776 .30909 m
.95776 .31284 L
s
.25 Mabswid
0 .30909 m
1 .30909 L
s
.52567 .08773 m
.53192 .08773 L
s
[(-2)] .51317 .08773 1 0 Mshowa
.52567 .19841 m
.53192 .19841 L
s
[(-1)] .51317 .19841 1 0 Mshowa
.52567 .41977 m
.53192 .41977 L
s
[(1)] .51317 .41977 1 0 Mshowa
.52567 .53045 m
.53192 .53045 L
s
[(2)] .51317 .53045 1 0 Mshowa
.125 Mabswid
.52567 .10987 m
.52942 .10987 L
s
.52567 .13201 m
.52942 .13201 L
s
.52567 .15414 m
.52942 .15414 L
s
.52567 .17628 m
.52942 .17628 L
s
.52567 .22055 m
.52942 .22055 L
s
.52567 .24269 m
.52942 .24269 L
s
.52567 .26482 m
.52942 .26482 L
s
.52567 .28696 m
.52942 .28696 L
s
.52567 .33123 m
.52942 .33123 L
s
.52567 .35336 m
.52942 .35336 L
s
.52567 .3755 m
.52942 .3755 L
s
.52567 .39764 m
.52942 .39764 L
s
.52567 .44191 m
.52942 .44191 L
s
.52567 .46404 m
.52942 .46404 L
s
.52567 .48618 m
.52942 .48618 L
s
.52567 .50832 m
.52942 .50832 L
s
.52567 .0656 m
.52942 .0656 L
s
.52567 .04346 m
.52942 .04346 L
s
.52567 .02133 m
.52942 .02133 L
s
.52567 .55259 m
.52942 .55259 L
s
.52567 .57472 m
.52942 .57472 L
s
.52567 .59686 m
.52942 .59686 L
s
.25 Mabswid
.52567 0 m
.52567 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.52567 .30909 m
.52568 .3093 L
.52574 .30986 L
.52592 .31094 L
.52625 .31237 L
.52742 .31592 L
.52981 .32116 L
.53422 .32852 L
.54142 .33801 L
.56234 .35876 L
.59672 .38378 L
.64188 .40806 L
.67326 .4207 L
.6894 .42591 L
.705 .43009 L
.72349 .43386 L
.73346 .43533 L
.7442 .43643 L
.7545 .43698 L
.76423 .43701 L
.78233 .43565 L
.80032 .43215 L
.81651 .42676 L
.83327 .41829 L
.84205 .41232 L
.8496 .40611 L
.86324 .39142 L
.86989 .38188 L
.87529 .37232 L
.88311 .35313 L
.88597 .34276 L
.88822 .33089 L
.8898 .3092 L
.88848 .28892 L
.88398 .26684 L
.88053 .25599 L
.87587 .24444 L
.86595 .22586 L
.85272 .20768 L
.83796 .19232 L
.82286 .17998 L
.80171 .16654 L
.77724 .15485 L
.75497 .14669 L
.72927 .13933 L
.66853 .12708 L
.60834 .11785 L
.49243 .09923 L
.42648 .08764 L
.38881 .08153 L
Mistroke
.36998 .07886 L
.3525 .0767 L
.33488 .07492 L
.31618 .07357 L
.29732 .07288 L
.27662 .07308 L
.25941 .07414 L
.24112 .07633 L
.20876 .08351 L
.19238 .08914 L
.17511 .09689 L
.14562 .1157 L
.11996 .14019 L
.0997 .16826 L
.08304 .20208 L
.07179 .23761 L
.06481 .27957 L
.06388 .32627 L
.0698 .37194 L
.07528 .39392 L
.08307 .4168 L
.10123 .45365 L
.12251 .48285 L
.14713 .50661 L
.17692 .52646 L
.20729 .54001 L
.23662 .54854 L
.26386 .55352 L
.29429 .55657 L
.32632 .55768 L
.35629 .55735 L
.39122 .55591 L
.42411 .55401 L
.48506 .55035 L
.51653 .54881 L
.54979 .5476 L
.56707 .54713 L
.58612 .54673 L
.61966 .54621 L
.65019 .54575 L
.68276 .54492 L
.7014 .54412 L
.71829 .54308 L
.75103 .53988 L
.78416 .53435 L
.80244 .52994 L
.81895 .52489 L
.84812 .5128 L
.87688 .49552 L
.89901 .47693 L
Mistroke
.91995 .45281 L
.9365 .4263 L
.94852 .39924 L
.95843 .36493 L
.96377 .32549 L
.96343 .28781 L
.95846 .25383 L
.94745 .21732 L
.93894 .19855 L
.92977 .18265 L
.90992 .15715 L
.88542 .13582 L
.86106 .12154 L
.83684 .11213 L
.80918 .10569 L
.77883 .10264 L
.76191 .10239 L
.74626 .10292 L
.72917 .10422 L
.71117 .1063 L
.68146 .11104 L
.64961 .11749 L
.54536 .14369 L
.39054 .18455 L
.35925 .19407 L
.32871 .20529 L
.29907 .21955 L
.27576 .2351 L
.26466 .24485 L
.25447 .25613 L
.24669 .26734 L
.24117 .27797 L
.23759 .28767 L
.23517 .29829 L
.23455 .30354 L
.23433 .30909 L
.23504 .31873 L
.23711 .3277 L
.23884 .33245 L
.24078 .3366 L
.24513 .34356 L
.25076 .34994 L
.25714 .35514 L
.26377 .35903 L
.27013 .36168 L
.27731 .36368 L
.28516 .36485 L
.29241 .36512 L
.30074 .36455 L
.30849 .36324 L
Mistroke
.31545 .36142 L
.32164 .35929 L
.33453 .35315 L
.34052 .3494 L
.34563 .34564 L
.35104 .34094 L
.35533 .3365 L
.36206 .32736 L
.36463 .32243 L
.3656 .32008 L
.36634 .31791 L
.36691 .31587 L
.36736 .31373 L
.36775 .31018 L
.36776 .30829 L
.36761 .30639 L
.36698 .30328 L
.36602 .30077 L
.36483 .29877 L
.36325 .29698 L
.36133 .29558 L
.36018 .29503 L
.35907 .29469 L
.35784 .29449 L
.35652 .29448 L
.35538 .29466 L
.35433 .29497 L
.35321 .29548 L
.35206 .29624 L
.35116 .29702 L
.35024 .29805 L
.34938 .2993 L
.34867 .30063 L
.34769 .30341 L
.3471 .30692 L
.34706 .31074 L
.34729 .31311 L
.34767 .31545 L
.349 .32052 L
.3501 .32355 L
.35132 .32643 L
.35791 .33792 L
.36736 .34973 L
.38233 .36403 L
.4003 .3777 L
.45594 .40946 L
.52289 .43857 L
.59835 .46527 L
.64613 .47883 L
.67276 .48491 L
Mistroke
.68767 .48776 L
.70178 .49002 L
.7278 .49295 L
.74172 .49376 L
.75666 .49394 L
.78315 .49222 L
.80688 .48801 L
.83052 .48061 L
.85157 .47051 L
.87295 .45564 L
.89334 .43506 L
.91021 .41008 L
.91721 .39596 L
.92361 .37947 L
.93152 .34801 L
.93468 .31702 L
.93356 .28483 L
.9285 .25482 L
.92072 .2289 L
.90902 .20257 L
.89267 .17651 L
.87174 .15245 L
.85132 .13494 L
.8266 .11884 L
.79526 .10389 L
.76362 .093 L
.73398 .0854 L
.70067 .07886 L
.62313 .06784 L
.54831 .05845 L
.40412 .03859 L
.36742 .03427 L
.32725 .03094 L
.3041 .03002 L
.28281 .03002 L
.24118 .03314 L
.20172 .04124 L
.1659 .05474 L
.13567 .07256 L
.10577 .09861 L
.07774 .13519 L
.06577 .15677 L
.05451 .18273 L
.04003 .23332 L
.03329 .28441 L
.0335 .33682 L
.04015 .38554 L
.05125 .42669 L
.06849 .46735 L
.09248 .50516 L
Mistroke
.12311 .53756 L
.15576 .56063 L
.18769 .57569 L
.22799 .58739 L
.24882 .59106 L
.27194 .59368 L
.31321 .59543 L
.35178 .59466 L
.37507 .59345 L
.39703 .59199 L
.43784 .58879 L
.52786 .58182 L
.59966 .57759 L
.63856 .57556 L
.67478 .57336 L
.71341 .5701 L
.7337 .56774 L
.75533 .56449 L
.79288 .55644 L
.82603 .54572 L
.85938 .52993 L
.88842 .51022 L
.91191 .4882 L
.934 .45967 L
.95337 .4234 L
.96104 .40336 L
.96773 .38022 L
.97485 .33736 L
.9759 .29644 L
.97148 .25618 L
.96241 .22016 L
.95052 .19061 L
.93393 .16215 L
.91225 .13629 L
.88575 .11474 L
.85829 .09991 L
.83197 .09073 L
.79909 .08437 L
.78228 .08284 L
.76376 .08225 L
.731 .08356 L
.70078 .08689 L
.68268 .08964 L
.66578 .09264 L
.63481 .09899 L
.56887 .11496 L
.47068 .14169 L
.42437 .15546 L
.37902 .17085 L
.34033 .18722 L
Mistroke
.30946 .20442 L
.29638 .21359 L
.2835 .22431 L
.26418 .24559 L
.25543 .25905 L
.24933 .27163 L
.2467 .2787 L
.24448 .28636 L
.24296 .29358 L
.24208 .30017 L
.24167 .31177 L
.24294 .32399 L
.24608 .33595 L
.25056 .34618 L
.25595 .35476 L
.26302 .36294 L
.27068 .3695 L
.27848 .37452 L
.28597 .37817 L
.29466 .38127 L
.30408 .38348 L
.31313 .38465 L
.32319 .38498 L
.33377 .38433 L
.34268 .38302 L
.35221 .38087 L
.36213 .3778 L
.37219 .37375 L
.38859 .36481 L
.39603 .35954 L
.40333 .35331 L
.4095 .34691 L
.41503 .33973 L
.41913 .33283 L
.42196 .32641 L
.42391 .31989 L
.42492 .31368 L
.42514 .30994 L
.42508 .30656 L
.4247 .30268 L
.42406 .29906 L
.42221 .29271 L
.42078 .28921 L
.41923 .28604 L
.4152 .27954 L
.40968 .27279 L
.40274 .26624 L
.39527 .26069 L
.38806 .25636 L
.37955 .25226 L
Mistroke
.37099 .24906 L
.3627 .24675 L
.35501 .24524 L
.34636 .24428 L
.33724 .2441 L
.32872 .24477 L
.31949 .24651 L
.31497 .24779 L
.31014 .2495 L
.30197 .25339 L
.29493 .25797 L
.28746 .26459 L
.28165 .27169 L
.27888 .27604 L
.27628 .28108 L
.27424 .28611 L
.27271 .29098 L
.27083 .30093 L
.27039 .31091 L
.27118 .32021 L
.27334 .33058 L
.27725 .34196 L
.28015 .34832 L
.28321 .35404 L
.29046 .36516 L
.2985 .37512 L
.3178 .39348 L
.34368 .4116 L
.37046 .42613 L
.40238 .44026 L
.48106 .46801 L
.58174 .49744 L
.61472 .50586 L
.64719 .51325 L
.67987 .51946 L
.71082 .52382 L
.74063 .5262 L
.77242 .52618 L
.80409 .52277 L
.82179 .519 L
.83802 .51409 L
.86625 .50147 L
.88114 .49214 L
.89395 .48221 L
.91662 .45877 L
.93464 .43185 L
.94321 .41461 L
.95081 .39504 L
.96036 .35714 L
.96328 .3349 L
Mistroke
.9644 .3137 L
.96383 .29026 L
.96111 .26528 L
.95184 .22501 L
.94409 .20351 L
.93539 .18468 L
.91592 .15332 L
.89083 .125 L
.86525 .10426 L
.83898 .08851 L
.80818 .07499 L
.7732 .06414 L
.74023 .05694 L
.7088 .05192 L
.67369 .04767 L
.6356 .04396 L
.48205 .02932 L
.40485 .02098 L
.36613 .01747 L
.33007 .01528 L
.29713 .01472 L
.2623 .01627 L
.2277 .02084 L
.19054 .03034 L
.15067 .04794 L
.11655 .07191 L
.08354 .10744 L
.06763 .1315 L
.05507 .15576 L
.03709 .20574 L
.03016 .23633 L
.02595 .2655 L
.02381 .32053 L
.02946 .37794 L
.04124 .42653 L
.06031 .47325 L
.08369 .51093 L
.1088 .53922 L
.14197 .56501 L
.18137 .58451 L
.22071 .59587 L
.25814 .60141 L
.29818 .60332 L
.34135 .60217 L
.38179 .59915 L
.4184 .59551 L
.58621 .57806 L
.6262 .57448 L
.66827 .57042 L
.70732 .56573 L
Mistroke
.74206 .5601 L
.76053 .55625 L
.78017 .55129 L
.81464 .53972 L
.83342 .53139 L
.85247 .52101 L
.88404 .49799 L
.90849 .47275 L
.92066 .45642 L
.93075 .44004 L
.946 .40716 L
.95719 .36898 L
.96249 .33323 L
.96333 .29918 L
.95965 .26255 L
.95049 .22526 L
.93634 .1916 L
.92632 .17452 L
.91582 .16008 L
.89164 .13539 L
.87662 .12424 L
.86222 .11572 L
.835 .10414 L
.80404 .09641 L
.77405 .09305 L
.74614 .09272 L
.72026 .09432 L
.69275 .09763 L
.66724 .10188 L
.64441 .10647 L
.54356 .13239 L
.45211 .16094 L
.38322 .18767 L
.35148 .20383 L
.32592 .22056 L
.30395 .2399 L
.29402 .25148 L
.28651 .26246 L
.28128 .27213 L
.27751 .28121 L
.27458 .29114 L
.27283 .3016 L
.27253 .31222 L
.27361 .32181 L
.27566 .32991 L
.27898 .33809 L
.28381 .34618 L
.28935 .35287 L
.29641 .35911 L
.30038 .36187 L
Mistroke
.30496 .36452 L
.3142 .36852 L
.31947 .37013 L
.32449 .37128 L
.33367 .37252 L
.33887 .37277 L
.3436 .37274 L
.35283 .37197 L
.36118 .3705 L
.37006 .3681 L
.37902 .36477 L
.39272 .35756 L
.39958 .35269 L
.40531 .34771 L
.41044 .34224 L
.415 .33606 L
.41843 .32995 L
.42077 .32424 L
.42184 .32064 L
.42256 .3173 L
.42307 .31359 L
.42329 .30965 L
.42289 .30297 L
.42224 .29916 L
.42135 .29562 L
.41888 .28879 L
.41563 .28242 L
.41197 .2768 L
.40721 .27086 L
.40114 .26463 L
.39373 .25839 L
.38593 .25295 L
.37813 .24838 L
.36202 .24116 L
.35245 .23805 L
.34298 .23577 L
.33406 .23433 L
.32565 .23361 L
.31638 .23356 L
.30653 .23442 L
.29596 .23653 L
.29016 .23829 L
.28496 .24027 L
.27584 .24487 L
.26698 .25108 L
.25988 .2578 L
.2541 .26504 L
.24882 .27397 L
.24456 .28458 L
.24193 .29576 L
Mistroke
.24114 .30244 L
.24089 .30888 L
.24184 .32221 L
.24326 .32983 L
.24512 .33686 L
.24948 .34865 L
.25598 .36134 L
.26466 .37418 L
.27441 .38559 L
.28802 .3984 L
.30273 .40963 L
.33466 .42837 L
.37467 .44574 L
.42381 .46248 L
.52053 .49018 L
.58035 .50596 L
.64084 .5203 L
.66853 .52586 L
.69545 .53035 L
.72707 .53413 L
.75632 .53573 L
.78868 .53476 L
.81835 .53059 L
.84997 .52157 L
.86696 .51421 L
.88177 .50598 L
.90752 .48643 L
.92879 .46314 L
.94831 .43215 L
.96398 .39337 L
.96955 .3721 L
.97375 .348 L
.97619 .30266 L
.97203 .25841 L
.96255 .21917 L
.94915 .18537 L
.93292 .15682 L
.91152 .12957 L
.88488 .10526 L
.85545 .08621 L
.82203 .07116 L
.79201 .06179 L
.75807 .0545 L
.73835 .05145 L
.71676 .04885 L
.69756 .04704 L
.67712 .04548 L
.63812 .04317 L
.60192 .04134 L
.5133 .03613 L
Mistroke
.42863 .02954 L
.39076 .0267 L
.35453 .02463 L
.31254 .02379 L
.27425 .0254 L
.23244 .03104 L
.19479 .04115 L
.17581 .04868 L
.15555 .05903 L
.13536 .0723 L
.11748 .0872 L
.08989 .11828 L
.0655 .15913 L
.04828 .20403 L
.03813 .24895 L
.03345 .30448 L
.03436 .33609 L
.03747 .36483 L
.04865 .41516 L
.0677 .46296 L
.09192 .50159 L
.12336 .53455 L
.15697 .55745 L
.19012 .57194 L
.21098 .57805 L
.23072 .58212 L
.25266 .58505 L
.27625 .58663 L
.2988 .5869 L
.32003 .58626 L
.35947 .58331 L
.39274 .57958 L
.42869 .57481 L
.49924 .56475 L
.61922 .54902 L
.68358 .54019 L
.71852 .53404 L
.74945 .52701 L
.77725 .51875 L
.80612 .50739 L
.83172 .49392 L
.85364 .47882 L
.87513 .45934 L
.89469 .43537 L
.90854 .41228 L
.92034 .38465 L
.92885 .35275 L
.9316 .33433 L
.93282 .31746 L
.93169 .28488 L
Mistroke
.92649 .2553 L
.91813 .22942 L
.90594 .20467 L
.89309 .18609 L
.87671 .16863 L
.85693 .15346 L
.83371 .14123 L
.81044 .13331 L
.78842 .12885 L
.76214 .12654 L
.74736 .12643 L
.73401 .12697 L
.70817 .12949 L
.68429 .13329 L
.65709 .13904 L
.63296 .14522 L
.58205 .16088 L
.50799 .18888 L
.44566 .21802 L
.40072 .24553 L
.37341 .26927 L
.36462 .27991 L
.36105 .28522 L
.35803 .29057 L
.356 .29497 L
.35438 .2995 L
.35342 .3033 L
.35294 .30657 L
.35283 .31002 L
.35297 .31177 L
.35322 .31327 L
.35404 .3159 L
.35465 .31713 L
.35528 .31809 L
.35658 .31945 L
.35816 .3204 L
.35974 .32078 L
.36121 .32071 L
.36287 .32011 L
.36431 .31909 L
.3657 .31746 L
.36635 .31633 L
.36686 .31516 L
.3673 .31382 L
.3676 .31246 L
.36781 .31085 L
.36788 .30901 L
.36763 .30566 L
.36726 .30362 L
.36676 .30161 L
Mistroke
.36559 .29817 L
.36383 .29431 L
.35931 .28704 L
.35158 .27825 L
.34234 .27056 L
.33062 .26337 L
.32318 .25991 L
.31587 .25724 L
.3092 .25538 L
.30162 .25393 L
.29354 .25317 L
.28593 .25324 L
.27903 .25401 L
.27166 .25568 L
.26497 .25809 L
.25907 .26106 L
.25363 .26473 L
.2491 .26865 L
.24444 .27388 L
.24068 .27946 L
.23734 .28625 L
.23479 .2941 L
.23348 .30128 L
.23302 .30955 L
.2337 .31882 L
.23585 .32899 L
.23923 .33866 L
.24347 .3474 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 177.938},
  ImageMargins->{{9, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oUP3oool0
0`000000oooo0?ooo`270?ooo`00UP3oool00`000000oooo0?ooo`270?ooo`00UP3oool00`000000
oooo0?ooo`270?ooo`00UP3oool00`000000oooo0?ooo`270?ooo`00B@3ooolLo`000340oooo00<0
00000?ooo`3oool0Q`3oool004@0oooo1Ol0000L0?ooo`_o00009P3oool00`000000oooo0?ooo`27
0?ooo`00?P3oool6o`000100oooo3?l0000@0?ooo`_o00006`3oool00`00003o00000?ooo`270?oo
o`00>@3oool5o`0000X0oooo3?l0000<0?oooaOo0000103oool;o`000100oooo00<000000?ooo`3o
ool0Q`3oool003D0oooo1?l000070?ooo`So00000`3ooolJo`000180oooo2ol000040?ooo`_o0000
1@3oool00`000000oooo0?ooo`270?ooo`00<`3oool2o`0000P0oooo0ol000020?ooo`Wo00006P3o
ool8o`0001D0oooo3?l000030?ooo`_o0000Q03oool00300oooo0ol000070?ooo`So0000:`3oool5
o`0001`0oooo6Ol0001i0?ooo`00;P3oool2o`0000L0oooo1_l0000e0?ooo`Oo00007@3oool00`00
0000oooo0?ooo`080?oooa;o0000K@3oool002`0oooo0_l000060?ooo`Go0000@03oool8o`0001D0
oooo00<00000o`00003oool06@3oool<o`000680oooo000Z0?ooo`;o00001@3oool5o`0004/0oooo
2Ol0000<0?ooo`030000003oool0oooo02@0oooo3ol0001D0?ooo`00:@3oool00ol00000oooo0?oo
o`030?ooo`Co0000E`3oool8o`0000@0oooo00<000000?ooo`3oool0;P3oool@o`0004T0oooo000W
0?ooo`;o0000103oool3o`000680oooo2?l0000d0?ooo`Go0000103oool6o`0004<0oooo000V0?oo
o`03o`00003oool0oooo0080oooo0ol0001X0?ooo`040000003oool0oooo0?ooo`So0000<@3oool4
o`0000H0oooo1Ol0000n0?ooo`009@3oool00ol00000oooo0?ooo`020?ooo`?o0000J@3oool00`00
0000oooo0?ooo`090?ooo`Oo0000;P3oool5o`0000H0oooo0ol0000k0?ooo`008`3oool2o`0000@0
oooo0_l0001[0?ooo`0300000?l00000oooo0100oooo1ol0000/0?ooo`Co00001@3oool3o`0003P0
oooo000R0?ooo`03o`00003oool0oooo00<0oooo00?o00000?ooo`3oool0J`3oool00`000000oooo
0?ooo`0G0?ooo`Oo0000:@3oool3o`0000D0oooo0ol0000e0?ooo`008@3oool00ol00000oooo0?oo
o`020?ooo`;o00009@3oool<o`0003d0oooo00<000000?ooo`3oool07P3oool7o`0002D0oooo0ol0
00050?ooo`;o0000<`3oool00240oooo00Go00000?ooo`3oool0ooooo`00000M0?ooo`[o0000303o
ool;o`000380oooo00<000000?ooo`3oool09@3oool7o`000240oooo0ol000040?ooo`?o0000<03o
ool00200oooo00Go00000?ooo`3oool0ooooo`00000I0?ooo`Go00008@3oool:o`0001l0oooo1Ol0
00040?ooo`030000003oool0oooo02`0oooo1ol0000M0?ooo`;o00001@3oool2o`0002h0oooo000O
0?ooo`05o`00003oool0oooo0?ooool000005`3oool3o`000300oooo1Ol0000K0?ooo`04o`00003o
ool0ooooo`0000@0oooo00<000000?ooo`3oool0<`3ooolHo`0000L0oooo0ol000040?ooo`?o0000
:`3oool001h0oooo00Go00000?ooo`3oool0ooooo`00000E0?ooo`?o0000>03oool5o`0000l0oooo
1Ol000030?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool0;@3oool7o`0000@0oooo
1?l0000?0?ooo`Co00001P3oool2o`0000D0oooo0_l0000Y0?ooo`007@3oool01Ol00000oooo0?oo
o`3ooooo000001@0oooo0_l000100?ooo`Ko00004P3oool00ol00000oooo0?ooo`030?ooo`<00000
:03oool5o`0000l0oooo1?l0000?0?ooo`Go00000`3oool2o`0000D0oooo00?o00000?ooo`3oool0
9P3oool001`0oooo00Co00000?ooo`3oool0oooo0_l0000A0?ooo`?o0000B03oool7o`0000P0oooo
00Go00000?ooo`3oool0ooooo`0000040?ooo`030000003oool0oooo02<0oooo1Ol0000A0?oooa7o
00002P3oool4o`0000030?ooool0003o000000@0oooo00?o00000?ooo`3oool09@3oool001/0oooo
00Co00000?ooo`3oool0oooo0_l0000@0?ooo`;o0000DP3oool6o`000080oooo00Go00000?ooo`3o
ool0ooooo`0000040?ooo`030000003oool0oooo01l0oooo1?l0000>0?ooo`So00002`3oool3o`00
00<0oooo1_l000080?ooo`Go00000`3oool2o`0002D0oooo000J0?ooo`04o`00003oool0oooo0?oo
o`;o0000403oool00ol00000oooo0?ooo`1H0?ooo`Ko00001@3oool00`000000oooo0?ooo`0K0?oo
o`Co00002`3oool7o`0001H0oooo0ol000060?ooo`Go00001`3oool3o`0000<0oooo00?o00000?oo
o`3oool08P3oool001T0oooo00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`0>0?ooo`03
o`00003oool0oooo05l0oooo1ol0000G0?ooo`Go0000203oool7o`0000/0oooo6?l000080?ooo`?o
00001`3oool2o`000080oooo00?o00000?ooo`3oool08@3oool001P0oooo00?o00000?ooo`3oool0
0P3oool00ol00000oooo0?ooo`0=0?ooo`;o0000I`3oool00`000000ooooo`000006o`0000/0oooo
1Ol000070?ooo`Ko00002`3oool7o`0001L0oooo1_l000060?ooo`;o00001`3oool00ol00000oooo
0?ooo`02o`000240oooo000H0?ooo`05o`00003oool0oooo0?ooool000003`3oool00ol00000oooo
0?ooo`1W0?ooo`0300000?l00000oooo00H0oooo2ol000080?ooo`Co00002`3oool6o`000240oooo
0_l00000103ooooo0000o`000?l000050?ooo`;o00001P3oool2o`000080oooo00?o00000?ooo`3o
ool07P3oool001L0oooo00Go00000?ooo`3oool0ooooo`00000?0?ooo`03o`00003oool0oooo06P0
oooo00<000000?ooo`3oool0203oool;o`000080oooo1?l0000:0?ooo`Go0000:@3oool01?l00000
oooo0?ooo`3oool4o`0000<0oooo0_l000050?ooo`?o000000<0ooooo`00003oool07P3oool001H0
oooo00Go00000?ooo`3oool0ooooo`00000>0?ooo`;o0000J`3oool00`000000oooo0?ooo`050?oo
o`?o0000203oool9o`0000H0oooo1?l0000_0?ooo`;o00001@3oool3o`000080oooo0_l000040?oo
o`05o`00003ooooo00000?ooool000007P3oool001D0oooo00?o00000?ooo`3oool00P3oool00ol0
0000oooo0?ooo`0;0?ooo`03o`00003oool0oooo06/0oooo00@000000?ooo`3oool0oooo1?l00007
0?ooo`Co00002@3oool6o`0003D0oooo0_l000060?ooo`?o000000<0ooooo`000?l000000`3oool0
1Ol00000ooooo`00003ooooo000001d0oooo000E0?ooo`05o`00003oool0oooo0?ooool000003@3o
ool00ol00000oooo0?ooo`1/0?ooo`0400000?l0003o0000o`0000L0oooo1?l0000<0?ooo`?o0000
103oool5o`000380oooo0_l000070?ooo`;o000000<0ooooo`000?l000000P3oool01Ol00000oooo
o`00003ooooo000001`0oooo000D0?ooo`04o`00003oool0oooo0?ooo`;o0000303oool00ol00000
oooo0?ooo`1Z0?ooo`Co00001P3oool4o`0000`0oooo1?l0000<0?ooo`Ko0000303ooolFo`0000`0
oooo00?o00000?ooo`3oool01P3oool01_l00000oooo0?ooool00000ooooo`000080oooo00?o0000
0?ooool000006`3oool001<0oooo00Co00000?ooo`3oool0oooo0_l0000<0?ooo`03o`00003oool0
oooo06P0oooo0ol000030?ooo`0400000?l00000oooo0?ooo`?o0000303oool4o`0001H0oooo3?l0
000F0?ooo`?o00002P3oool2o`0000L0oooo0_l00000103ooooo00000?ooool000020?ooo`03o`00
003ooooo000001X0oooo000C0?ooo`03o`00003oool0oooo00;o0000303oool00ol00000oooo0?oo
o`1U0?ooo`Co00001P3oool01000003o0000o`000?l0000;0?ooo`Co00005`3oool8o`0000030?oo
ool0003o000000Co00006@3oool3o`0000T0oooo00?o00000?ooo`3oool01P3oool01Ol00000oooo
o`00003ooooo00000080oooo0_l0000J0?ooo`004P3oool01?l00000oooo0?ooo`3oool2o`0000/0
oooo00?o00000?ooo`3oool0H`3oool3o`0000P0oooo0ol0000;0?ooo`?o00005@3oool6o`0000l0
oooo1?l0000H0?ooo`?o00001`3oool00ol00000oooo0?ooo`060?ooo`05o`00003ooooo00000?oo
ool000000P3oool2o`0001T0oooo000B0?ooo`03o`00003oool0oooo00;o00002`3oool00ol00000
oooo0?ooo`1P0?ooo`Co0000203oool3o`000080oooo00<000000?ooo`3oool01@3oool4o`0001D0
oooo0ol0000I0?ooo`?o0000603oool3o`0000D0oooo00?o00000?ooo`3oool01P3oool02Ol00000
ooooo`00003ooooo00000?ooool00000ooooo`00000H0?ooo`004@3oool01?l00000oooo0?ooo`3o
ool2o`0000/0oooo00?o00000?ooo`3oool0G@3oool3o`0000T0oooo0ol000050?ooo`040000003o
ool0oooo0?ooo`Co00005P3oool3o`0001l0oooo0_l0000I0?ooo`;o0000103oool00ol00000oooo
0?ooo`060?ooo`09o`00003ooooo00000?ooool00000ooooo`00003ooooo000001L0oooo000A0?oo
o`03o`00003oool0oooo00;o00002`3oool00ol00000oooo0?ooo`1J0?ooo`Co00002@3oool3o`00
00P0oooo1?l0000G0?ooo`?o0000903oool3o`0001P0oooo0_l000030?ooo`03o`00003oool0oooo
00H0oooo00Wo00000?ooool00000ooooo`00003ooooo00000?ooool000005P3oool00140oooo00Co
00000?ooo`3ooooo00002`3oool00ol00000oooo0?ooo`1H0?ooo`?o00002P3oool3o`0000L0oooo
1?l000000`000000oooo0?ooo`0E0?ooo`?o0000:P3oool3o`0001L0oooo0_l000020?ooo`03o`00
003oool0oooo00H0oooo00Wo00000?ooool00000ooooo`00003ooooo00000?ooool000005@3oool0
0100oooo00?o00000?ooo`3oool00_l0000:0?ooo`03o`00003oool0oooo05D0oooo1?l0000:0?oo
o`?o00001P3oool4o`0000@0oooo00<00000o`00003oool04P3oool3o`000300oooo0_l0000G0?oo
o`03o`00003ooooo000000T0oooo00Co00000?ooool0003o00000P3oool00ol00000ooooo`00000D
0?ooo`00403oool01?l00000oooo0?ooool0000;0?ooo`03o`00003oool0oooo0580oooo0ol0000;
0?ooo`?o00001@3oool4o`0000P0oooo00<000000?ooo`3oool03`3oool3o`0003D0oooo0ol0000E
0?ooo`03o`00003ooooo000000T0oooo00Co00000?ooool0003o00000P3oool2o`0001@0oooo000?
0?ooo`03o`00003oool0oooo00;o00002P3oool00ol00000oooo0?ooo`1@0?ooo`?o0000303oool2
o`0000@0oooo1?l0000<0?ooo`030000003oool0oooo00`0oooo0ol0000k0?ooo`;o0000503oool0
0ol00000ooooo`0000080?ooo`05o`00003ooooo00000?ooool000000P3oool2o`0001<0oooo000?
0?ooo`04o`00003oool0ooooo`0000X0oooo00?o00000?ooo`3oool0CP3oool3o`0000`0oooo0ol0
00020?ooo`Co0000403oool00`000000oooo0?ooo`090?ooo`?o0000@03oool2o`0001<0oooo00?o
00000?ooool00000203oool01?l00000ooooo`000?l000020?ooo`;o00004`3oool000h0oooo00?o
00000?ooo`3oool00_l000090?ooo`03o`00003oool0oooo04`0oooo0ol0000<0?ooo`?o000000<0
ooooo`000?l000000_l0000D0?ooo`030000003oool0oooo00H0oooo0ol000150?ooo`03o`00003o
ool0oooo0140oooo00?o00000?ooool00000203oool01?l00000ooooo`000?l000020?ooo`;o0000
4P3oool000h0oooo00?o00000?ooo`3oool00_l000090?ooo`03o`00003oool0oooo04X0oooo0_l0
000<0?ooo`Oo0000603oool00`000000oooo0?ooo`040?ooo`;o0000B@3oool2o`000180oooo00?o
00000?ooool00000203oool2o`0000040?ooool00000oooo0?ooo`;o00004@3oool000h0oooo00Co
00000?ooool0003o00002@3oool00ol00000oooo0?ooo`180?ooo`?o0000303oool5o`0001`0oooo
00@00000o`00003oool0oooo0ol0001=0?ooo`03o`00003oool0oooo0100oooo00?o00000?ooool0
0000203oool3o`000080oooo0_l0000A0?ooo`003@3oool00ol00000oooo0?ooo`02o`0000T0oooo
00?o00000?ooo`3oool0AP3oool2o`0000`0oooo1?l0000P0?ooo`040000003ooooo0000o`000540
oooo0_l0000A0?ooo`;o00002@3oool00ol00000ooooo`0000020?ooo`;o0000403oool000d0oooo
00Co00000?ooool0003o00002@3oool00ol00000oooo0?ooo`150?ooo`;o00002`3oool3o`0002<0
oooo0ol0001E0?ooo`03o`00003oool0oooo00l0oooo0_l000090?ooo`04o`00003ooooo00000?oo
o`;o0000403oool000`0oooo00?o00000?ooo`3oool00_l000090?ooo`03o`00003oool0oooo04<0
oooo0_l0000:0?ooo`?o00008`3oool3o`0000030?ooo`000000oooo05H0oooo00?o00000?ooo`3o
ool03`3oool2o`0000P0oooo0ol000020?ooo`;o00003`3oool000`0oooo00?o00000?ooo`3oool0
0_l000090?ooo`03o`00003oool0oooo0440oooo0_l000090?ooo`Co00008@3oool4o`0000@0oooo
00<000000?ooo`3oool0EP3oool00ol00000oooo0?ooo`0>0?ooo`;o00002@3oool3o`000080oooo
00?o00000?ooo`3oool03@3oool000/0oooo00?o00000?ooo`3oool00_l000090?ooo`03o`00003o
ool0oooo0400oooo0_l000080?ooo`Go00008`3oool2o`0000H0oooo00<000000?ooo`3oool0E`3o
ool00ol00000oooo0?ooo`0>0?ooo`;o00002@3oool2o`000080oooo0_l0000>0?ooo`002`3oool0
0ol00000oooo0?ooo`02o`0000T0oooo00?o00000?ooo`3oool0?`3oool00ol00000oooo0?ooo`05
0?ooo`?o000000<0ooooo`000?l000007P3oool7o`0000030?ooool00000oooo00D0oooo0`00001H
0?ooo`03o`00003oool0oooo00h0oooo00?o00000?ooo`3oool0203oool01Ol00000oooo0?ooo`3o
oooo000000h0oooo000;0?ooo`03o`00003oool0oooo00;o0000203oool00ol00000oooo0?ooo`0n
0?ooo`;o00001@3oool3o`000080oooo0_l0000R0?ooo`;o0000103oool00ol00000oooo0?ooo`04
0?ooo`030000003oool0oooo05T0oooo00?o00000?ooo`3oool03@3oool2o`0000T0oooo0_l00002
0?ooo`03o`00003oool0oooo00`0oooo000:0?ooo`03o`00003oool0oooo00;o00002@3oool00ol0
0000oooo0?ooo`0m0?ooo`03o`00003oool0oooo0080oooo0ol000030?ooo`;o00008P3oool2o`00
00H0oooo00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`1J0?ooo`03o`00003oool0oooo
00d0oooo0_l000080?ooo`;o00000P3oool2o`0000d0oooo000:0?ooo`03o`00003oool0oooo00;o
0000203oool00ol00000oooo0?ooo`0m0?ooo`04o`00003oool0oooo0?ooo`;o00001@3oool00ol0
0000oooo0?ooo`0P0?ooo`;o00001`3oool2o`0000H0oooo00<000000?ooo`3oool0F`3oool00ol0
0000oooo0?ooo`0<0?ooo`;o00002@3oool01Ol00000oooo0?ooo`3ooooo000000d0oooo000:0?oo
o`03o`00003oool0oooo00;o0000203oool00ol00000oooo0?ooo`0l0?ooo`03o`00003ooooo0000
00;o00001@3oool2o`000200oooo0ol0000:0?ooo`03o`00003oool0oooo00@0oooo00<000000?oo
o`3oool0F`3oool00ol00000oooo0?ooo`0=0?ooo`;o0000203oool2o`000080oooo00?o00000?oo
o`3oool02`3oool000T0oooo00Go00000?ooo`3oool0ooooo`0000090?ooo`03o`00003oool0oooo
03X0oooo1?l000070?ooo`03o`00003oool0oooo01h0oooo0_l0000D0?ooo`030000003oool0oooo
05`0oooo00?o00000?ooo`3oool0303oool2o`0000T0oooo00?o00000?ooo`3oool00_l0000<0?oo
o`002@3oool00ol00000oooo0?ooo`02o`0000P0oooo00?o00000?ooo`3oool0>P3oool3o`0000P0
oooo00?o00000?ooo`3oool07@3oool2o`0001H0oooo00<000000?ooo`3oool0G@3oool00ol00000
oooo0?ooo`0<0?ooo`;o0000203oool01Ol00000oooo0?ooo`3ooooo000000`0oooo00090?ooo`03
o`00003oool0oooo00;o0000203oool00ol00000oooo0?ooo`0i0?ooo`;o0000203oool2o`0001l0
oooo00?o00000?ooo`3oool05P3oool00`00003o00000?ooo`1N0?ooo`03o`00003oool0oooo00`0
oooo00?o00000?ooo`3oool01P3oool2o`000080oooo00?o00000?ooo`3oool02P3oool000T0oooo
00?o00000?ooo`3oool00_l000080?ooo`03o`00003oool0oooo03P0oooo0_l000080?ooo`03o`00
003oool0oooo01d0oooo0_l0000I0?ooo`030000003oool0oooo05l0oooo00?o00000?ooo`3oool0
2`3oool00ol00000oooo0?ooo`060?ooo`;o00000P3oool00ol00000oooo0?ooo`0:0?ooo`002@3o
ool01?l00000ooooo`000?l000080?ooo`03o`00003oool0oooo03P0oooo0_l000080?ooo`03o`00
003oool0oooo01d0oooo00?o00000?ooo`3oool06@3oool00`000000oooo0?ooo`1O0?ooo`03o`00
003oool0oooo00`0oooo00?o00000?ooo`3oool01P3oool00ol00000oooo0?ooo`02o`0000/0oooo
00080?ooo`03o`00003oool0oooo00;o0000203oool00ol00000oooo0?ooo`0g0?ooo`;o0000203o
ool6o`0001T0oooo0_l0000L0?ooo`030000003oool0oooo0600oooo00?o00000?ooo`3oool02`3o
ool00ol00000oooo0?ooo`060?ooo`05o`00003oool0oooo0?ooool000002`3oool000P0oooo00?o
00000?ooo`3oool00_l000080?ooo`03o`00003oool0oooo03H0oooo0_l000040?ooo`Go00001P3o
ool6o`000180oooo00?o00000?ooo`3oool0703oool00`000000oooo0?ooo`1P0?ooo`03o`00003o
ool0oooo00/0oooo0_l000070?ooo`;o00000P3oool00ol00000oooo0?ooo`090?ooo`00203oool0
0ol00000oooo0?ooo`02o`0000L0oooo00?o00000?ooo`3oool0=P3oool2o`000080oooo0ol00003
0?ooo`03o`00003oool0oooo00/0oooo0_l0000>0?ooo`;o00007`3oool00`000000oooo0?ooo`1Q
0?ooo`03o`00003oool0oooo00/0oooo00?o00000?ooo`3oool01P3oool01?l00000oooo0?ooool0
000;0?ooo`00203oool00ol00000oooo0?ooo`02o`0000L0oooo00?o00000?ooo`3oool0=@3oool2
o`000080oooo00?o00000?ooo`3oool0103oool00ol00000oooo0?ooo`050?ooo`Ko00000P3oool2
o`0000/0oooo00?o00000?ooo`3oool07`3oool00`00003o00000?ooo`1Q0?ooo`03o`00003oool0
oooo00/0oooo00?o00000?ooo`3oool01P3oool01Ol00000oooo0?ooo`3ooooo000000X0oooo0008
0?ooo`04o`00003oool0ooooo`0000P0oooo00?o00000?ooo`3oool0=03oool2o`0000030?ooool0
003o000000H0oooo00?o00000?ooo`3oool00P3oool4o`0000H0oooo1ol000060?ooo`;o00008P3o
ool00`000000oooo0?ooo`1R0?ooo`03o`00003oool0oooo00X0oooo0_l000070?ooo`;o00000P3o
ool00ol00000oooo0?ooo`080?ooo`00203oool01?l00000ooooo`000?l000080?ooo`03o`00003o
ool0oooo03@0oooo0ol000070?ooo`03o`00003oool0oooo00?o00003`3oool4o`0000<0oooo00?o
00000?ooo`3oool08P3oool00`000000oooo0?ooo`1R0?ooo`03o`00003oool0oooo00X0oooo0_l0
00080?ooo`04o`00003oool0ooooo`0000X0oooo00070?ooo`03o`00003oool0oooo00;o00001`3o
ool00ol00000oooo0?ooo`0d0?ooo`;o00000`3oool9000001D0oooo1?l0000U0?ooo`030000003o
ool0oooo06<0oooo00?o00000?ooo`3oool02P3oool00ol00000oooo0?ooo`060?ooo`03o`00003o
ool0oooo00;o00002@3oool000L0oooo00?o00000?ooo`3oool00_l000070?ooo`03o`00003oool0
oooo03<0oooo0_l00004000000D0oooo00Co00000?ooo`3oool0oooo1000000C0?ooo`;o00009@3o
ool00`000000oooo0?ooo`1S0?ooo`03o`00003oool0oooo00X0oooo0_l000070?ooo`05o`00003o
ool0oooo0?ooool000002@3oool000L0oooo00?o00000?ooo`3oool00_l000070?ooo`03o`00003o
ool0oooo0380oooo00?o0000000000000000203oool00ol00000oooo0?ooo`060?ooo`<000003`3o
ool00ol00000oooo0?ooo`02o`0002<0oooo00<000000?ooo`3oool0H`3oool00ol00000oooo0?oo
o`0:0?ooo`;o00001`3oool2o`000080oooo00?o00000?ooo`3oool01`3oool000L0oooo00?o0000
0?ooo`3oool00_l000070?ooo`03o`00003oool0oooo0340oooo0ol000080?ooo`03o`00003oool0
oooo00X0oooo0P00000<0?ooo`03o`00003oool0oooo0080oooo0_l0000R0?ooo`0300000?l00000
oooo06@0oooo00?o00000?ooo`3oool02@3oool2o`0000P0oooo00Co00000?ooo`3ooooo00002@3o
ool000L0oooo00Co00000?ooo`3ooooo00000P3oool5o`0000030?ooool00000oooo0340oooo00Co
000000000?l0003o00001`3oool00ol00000ooooo`000002o`0000/0oooo00<000000?ooo`3oool0
203oool00ol00000oooo0?ooo`040?ooo`03o`00003oool0oooo0200oooo00<000000?ooo`3oool0
@03oool3o`000240oooo00?o00000?ooo`3oool02P3oool00ol00000oooo0?ooo`060?ooo`04o`00
003oool0ooooo`0000T0oooo00070?ooo`04o`00003oool0ooooo`0000<0oooo00Ko00000?ooo`3o
oooo00000?ooool0000b0?ooo`03o`000000003o000000L0oooo00Go00000?ooo`3oool0ooooo`00
000=0?ooo`8000001`3oool00ol00000oooo0?ooo`060?ooo`03o`00003oool0oooo01l0oooo00<0
00000?ooo`3oool0@@3oool00ol00000oooo0?ooo`0P0?ooo`03o`00003oool0oooo00X0oooo00?o
00000?ooo`3oool01P3oool01?l00000oooo0?ooool000090?ooo`001`3oool5o`0000<0oooo00Co
00000?ooo`3ooooo0000<P3oool00ol000000000o`0000040?ooo`Go00000`3oool00ol00000oooo
0?ooo`0=0?ooo`030000003oool0oooo00<0oooo00?o00000?ooo`3oool0203oool00ol00000oooo
0?ooo`0N0?ooo`030000003oool0oooo0440oooo00?o00000?ooo`3oool0803oool00ol00000oooo
0?ooo`0:0?ooo`;o00001`3oool01?l00000oooo0?ooool000090?ooo`001`3oool01?l00000oooo
o`000?l000050?ooo`03o`00003ooooo00000380oooo00?o000000000?l000001`3oool2o`0000<0
oooo00?o00000?ooo`3oool03P3oool01@000000oooo0?ooo`3ooooo000000`0oooo00?o00000?oo
o`3oool07@3oool00`000000oooo0?ooo`110?ooo`03o`00003oool0oooo0200oooo00?o00000?oo
o`3oool02P3oool2o`0000L0oooo00?o00000?ooo`3oool00_l000080?ooo`001`3oool01?l00000
ooooo`000?l000020?ooo`04o`00003oool0oooo0?ooo`;o0000<P3oool00`00003o00000?ooo`07
0?ooo`03o`00003oool0oooo0080oooo00?o00000?ooo`3oool03P3oool010000000oooo0?ooool0
000>0?ooo`03o`00003oool0oooo01`0oooo00<000000?ooo`3oool0@@3oool00ol00000oooo0?oo
o`0Q0?ooo`03o`00003oool0oooo00X0oooo00?o00000?ooo`3oool01@3oool2o`0000030?ooool0
003o000000P0oooo00070?ooo`04o`00003ooooo0000o`000080oooo00Co00000?ooo`3oool0oooo
0_l0000a0?ooo`03o`000000003o000000L0oooo0_l000030?ooo`;o00004@3oool00`00003o0000
0?ooo`0>0?ooo`;o00007@3oool00`000000oooo0?ooo`100?ooo`;o00008`3oool00ol00000oooo
0?ooo`0:0?ooo`03o`00003oool0oooo00H0oooo00Co00000?ooo`3ooooo0000203oool000L0oooo
00Co00000?ooool0003o00000`3oool3o`0000030?ooool00000oooo0300oooo00<000000?ooool0
00001`3oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo0100oooo00<000000?ooo`3o
ool03P3oool00ol00000oooo0?ooo`0K0?ooo`0300000?l00000oooo0440oooo00?o00000?ooo`3o
ool08@3oool00ol00000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00H0oooo00Co00000?ooo`3o
oooo0000203oool000L0oooo00Co00000?ooool0003o00001`3oool00ol00000oooo0?ooo`0_0?oo
o`0300000?l0003o000000L0oooo00?o00000?ooo`3oool05@3oool00ol0000000000?ooo`0?0?oo
o`;o0000703oool00`000000oooo0?ooo`1U0?ooo`03o`00003oool0oooo00X0oooo00?o00000?oo
o`3oool01P3oool01?l00000oooo0?ooool000080?ooo`001`3oool00ol00000ooooo`0000080?oo
o`03o`00003oool0oooo02h0oooo00<000000?ooool00000203oool00ol00000oooo0?ooo`0D0?oo
o`?o000000<000000?ooo`3oool03@3oool2o`0001`0oooo00<000000?ooo`3oool0I@3oool00ol0
0000oooo0?ooo`0:0?ooo`03o`00003oool0oooo00H0oooo00Co00000?ooo`3ooooo0000203oool0
00L0oooo00?o00000?ooool00000203oool00ol00000oooo0?ooo`0^0?ooo`030000003ooooo0000
00L0oooo0_l0000E0?ooo`;o00000P3oool2o`0000l0oooo00?o00000?ooo`3oool06P3oool00`00
0000oooo0?ooo`1U0?ooo`03o`00003oool0oooo00X0oooo00?o00000?ooo`3oool01P3oool01?l0
0000oooo0?ooool000080?ooo`001`3oool00ol00000ooooo`0000080?ooo`03o`00003oool0oooo
02h0oooo00<000000?ooool000001`3oool2o`0001@0oooo0ol000030?ooo`03o`00003oool0oooo
00d0oooo00?o00000?ooo`3oool06P3oool00`000000oooo0?ooo`1V0?ooo`03o`00003oool0oooo
00T0oooo00?o00000?ooo`3oool01P3oool01?l00000oooo0?ooool000080?ooo`001`3oool00ol0
0000ooooo`0000080?ooo`03o`00003oool0oooo02h0oooo00<000000?ooool000001`3oool2o`00
01@0oooo00?o00000?ooool000000`3oool00ol00000oooo0?ooo`0=0?ooo`;o00006`3oool00`00
0000oooo0?ooo`1V0?ooo`03o`00003oool0oooo00T0oooo00?o00000?ooo`3oool01P3oool01?l0
0000oooo0?ooool000080?ooo`001`0000000ol000000000o`00000800000003o`00000000000000
0300000000?o00000000000000001@000002o`0001@0000000?o000000000?l000000`0000000ol0
000000000000000=000000;o00006`0000000ol0000000000000001V00000003o`00000000000000
00T0000000?o00000000000000001P0000001?l00000000000000?l0000700000040oooo00070?oo
o`03o`00003ooooo000000<0oooo00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`060?oo
o`03o`00003oool0oooo00X0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`0:0?oo
o`0300000?l0003o000000L0oooo0_l000030?ooo`030000003oool0oooo00X0oooo00Oo00000?oo
o`3oool0ooooo`00003ooooo000000<0oooo00Go00000?ooo`3oool0ooooo`00000;0?ooo`?o0000
3@3oool00ol00000oooo0?ooo`0:0?ooo`;o0000303oool00ol00000oooo0?ooo`0;0?ooo`03o`00
003oool0oooo00/0oooo00?o00000?ooo`3oool02P3oool00ol00000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`050?ooo`03o`00
003oool0oooo0080oooo00?o00000?ooo`3oool0103oool00ol00000oooo0?ooo`040?ooo`03o`00
003ooooo00000080oooo00?o00000?ooo`3oool01P3oool000L0oooo00?o00000?ooool000000`3o
ool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo02h0oooo00<000000?ooool000001`3o
ool2o`0000<0oooo00<000000?ooo`3oool03P3oool00ol00000ooooo`0000030?ooo`03o`00003o
ool0oooo00d0oooo0_l0000K0?ooo`0300000?l00000oooo0480oooo00<000000?ooo`3oool08@3o
ool00ol00000oooo0?ooo`090?ooo`03o`00003oool0oooo00H0oooo00Co00000?ooo`3ooooo0000
203oool000L0oooo00?o00000?ooool00000203oool00ol00000oooo0?ooo`0^0?ooo`030000003o
oooo000000L0oooo0_l0000E0?ooo`03o`00003ooooo000000?o00003`3oool00ol00000oooo0?oo
o`0J0?ooo`0300000?l00000oooo06H0oooo00?o00000?ooo`3oool02@3oool00ol00000oooo0?oo
o`050?ooo`;o00000P3oool00ol00000oooo0?ooo`060?ooo`001`3oool01?l00000ooooo`000?l0
00070?ooo`03o`00003oool0oooo02h0oooo00<000000?ooool000001`3oool2o`0001D0oooo00Go
00000?ooo`3oool0ooooo`00000?0?ooo`;o0000703oool00`000000ooooo`00001U0?ooo`03o`00
003oool0oooo00X0oooo00?o00000?ooo`3oool01@3oool2o`000080oooo00?o00000?ooo`3oool0
1P3oool000L0oooo00Co00000?ooool0003o00001`3oool00ol00000oooo0?ooo`0^0?ooo`030000
0?l0003o000000P0oooo00?o00000?ooo`3oool04`3oool01Ol00000oooo0?ooo`3ooooo000000l0
oooo0_l0000L0?ooo`030000003ooooo000006D0oooo00?o00000?ooo`3oool02P3oool00ol00000
oooo0?ooo`050?ooo`;o00000P3oool00ol00000oooo0?ooo`060?ooo`001`3oool01?l00000oooo
o`000?l000070?ooo`03o`00003oool0oooo02h0oooo00<00000o`000?l00000203oool2o`0001@0
oooo00Go00000?ooo`3oool0ooooo`00000?0?ooo`;o0000703oool01000003o00000?ooool0001T
0?ooo`03o`00003oool0oooo00X0oooo00?o00000?ooo`3oool01@3oool2o`000080oooo00?o0000
0?ooo`3oool01P3oool000L0oooo00Co00000?ooool0003o00001`3oool00ol00000oooo0?ooo`0^
0?ooo`0400000?l0003o0000o`0000L0oooo0_l0000E0?ooo`03o`00003ooooo00000100oooo00?o
00000?ooo`3oool06`3oool01@000000oooo0?ooo`3ooooo000006<0oooo00?o00000?ooo`3oool0
2P3oool00ol00000oooo0?ooo`050?ooo`;o00000P3oool00ol00000oooo0?ooo`060?ooo`001`3o
ool01?l00000ooooo`000?l000070?ooo`03o`00003oool0oooo02l0oooo00<00000o`000?l00000
203oool2o`0001@0oooo0_l0000@0?ooo`;o00007@3oool00`000000oooo0?ooo`020?ooo`03o`00
003oool0oooo0600oooo00?o00000?ooo`3oool02P3oool00ol00000oooo0?ooo`050?ooo`;o0000
0P3oool00ol00000oooo0?ooo`060?ooo`001`3oool01?l00000ooooo`000?l000080?ooo`03o`00
003oool0oooo02h0oooo00<00000o`000?l00000203oool2o`0001<0oooo00?o00000?ooool00000
3`3oool2o`0001h0oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`1O0?ooo`03o`00
003oool0oooo00X0oooo00?o00000?ooo`3oool01@3oool2o`000080oooo00?o00000?ooo`3oool0
1P3oool000L0oooo00Co00000?ooool0003o0000203oool00ol00000oooo0?ooo`0_0?ooo`030000
0?l0003o000000L0oooo00?o00000?ooool000004P3oool01?l00000oooo0?ooool0000=0?ooo`;o
00007`3oool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo05h0oooo00?o00000?ooo`3o
ool02P3oool00ol00000oooo0?ooo`050?ooo`;o00000P3oool00ol00000oooo0?ooo`060?ooo`00
1`3oool01?l00000ooooo`000?l000080?ooo`03o`00003oool0oooo0300oooo00<00000o`000?l0
00001`3oool2o`000100oooo0_l000040?ooo`03o`00003oool0oooo00T0oooo0_l0000P0?ooo`03
0000003oool0oooo00D0oooo00?o00000?ooo`3oool0G@3oool00ol00000oooo0?ooo`090?ooo`;o
00001`3oool01Ol00000oooo0?ooo`3ooooo000000P0oooo00080?ooo`03o`00003ooooo000000P0
oooo00?o00000?ooo`3oool0<@3oool2o`0000L0oooo00?o00000?ooool000003P3oool00ol00000
oooo0?ooo`050?ooo`03o`00003oool0oooo00L0oooo0_l0000Q0?ooo`030000003oool0oooo00H0
oooo00?o00000?ooo`3oool0F`3oool00ol00000oooo0?ooo`0:0?ooo`;o00001`3oool00ol00000
oooo0?ooo`02o`0000P0oooo00080?ooo`04o`00003ooooo0000o`0000L0oooo00?o00000?ooo`3o
ool0<P3oool3o`0000H0oooo00Co00000?ooool0003o00002@3oool3o`0000T0oooo00?o00000?oo
o`3oool0103oool3o`000280oooo00<00000o`00003oool01`3oool00ol00000oooo0?ooo`1J0?oo
o`03o`00003oool0oooo00X0oooo00?o00000?ooo`3oool01@3oool2o`000080oooo0_l000080?oo
o`00203oool01?l00000ooooo`000?l000070?ooo`03o`00003oool0oooo0380oooo00?o00000?oo
ool000000_l000040?ooo`05o`00003oool0oooo0?ooool000001@3oool3o`0000d0oooo00Co0000
0?ooo`3oool0oooo0ol0000T0?ooo`030000003oool0oooo00P0oooo0_l0001J0?ooo`03o`00003o
ool0oooo00X0oooo00?o00000?ooo`3oool01@3oool2o`000080oooo00?o00000?ooo`3oool01`3o
ool000P0oooo00Co00000?ooool0003o00001`3oool00ol00000oooo0?ooo`0c0?ooo`04o`00003o
oooo00000?ooo`;o00000`3oool01Ol00000oooo0?ooo`3ooooo00000080oooo0_l0000A0?ooo`?o
000000<0ooooo`00003oool0903oool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0oooo05H0
oooo00?o00000?ooo`3oool02P3oool2o`0000L0oooo0_l000020?ooo`03o`00003oool0oooo00L0
oooo00080?ooo`04o`00003ooooo0000o`0000P0oooo00?o00000?ooo`3oool0<P3oool01?l00000
oooo0?ooool000020?ooo`_o00004@3oool5o`0002H0oooo00<000000?ooo`3oool02`3oool2o`00
05D0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`060?ooo`;o00000P3oool00ol0
0000oooo0?ooo`070?ooo`00203oool01?l00000ooooo`000?l000080?ooo`03o`00003oool0oooo
03<0oooo00?o00000?ooo`3oool00_l000040?ooo`03o`00003oool0oooo00@0oooo00?o00000?oo
o`3oool0303oool2o`0000050?ooool0003o00000?ooool000009P3oool00`000000oooo0?ooo`0=
0?ooo`03o`00003oool0oooo0580oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`06
0?ooo`03o`00003oool0oooo00;o00002@3oool000P0oooo00Co00000?ooool0003o0000203oool0
0ol00000oooo0?ooo`0d0?ooo`05o`00003oool0oooo0?ooool00000103oool00ol00000oooo0?oo
o`040?ooo`ko00000P3oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo02<0oooo00<0
00000?ooo`3oool03P3oool00ol00000oooo0?ooo`1@0?ooo`03o`00003oool0oooo00/0oooo0_l0
00080?ooo`04o`00003oool0ooooo`0000X0oooo00080?ooo`03o`00003oool0oooo00;o00001`3o
ool00ol00000oooo0?ooo`0e0?ooo`04o`00003oool0oooo0?ooo`;o00000`3oool2o`000180oooo
0_l000060?ooo`03o`00003oool0oooo0280oooo00<00000o`00003oool03`3oool2o`000500oooo
00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`060?ooo`;o00000P3oool00ol00000oooo
0?ooo`080?ooo`00203oool00ol00000oooo0?ooo`02o`0000L0oooo00?o00000?ooo`3oool0=@3o
ool00ol00000oooo0?ooo`030?ooo`;o00000`3oool00ol00000oooo0?ooo`0=0?ooo`;o00002@3o
ool2o`000280oooo00<000000?ooo`3oool04@3oool00ol00000oooo0?ooo`1<0?ooo`03o`00003o
ool0oooo00`0oooo00?o00000?ooo`3oool01P3oool01Ol00000oooo0?ooo`3ooooo000000X0oooo
00080?ooo`03o`00003oool0oooo00;o00001`3oool00ol00000oooo0?ooo`0f0?ooo`03o`00003o
ool0oooo00@0oooo1_l000070?ooo`Ko00003@3oool2o`000200oooo00<000000?ooo`3oool04P3o
ool2o`0004`0oooo00?o00000?ooo`3oool02`3oool2o`0000P0oooo00Go00000?ooo`3oool0oooo
o`00000:0?ooo`00203oool00ol00000oooo0?ooo`02o`0000P0oooo00?o00000?ooo`3oool0=P3o
ool00ol00000oooo0?ooo`080?ooo`So00005@3oool00ol00000oooo0?ooo`0M0?ooo`030000003o
ool0oooo01@0oooo0_l0001:0?ooo`03o`00003oool0oooo00/0oooo00?o00000?ooo`3oool01P3o
ool2o`000080oooo0_l0000:0?ooo`002@3oool01?l00000ooooo`000?l000080?ooo`03o`00003o
ool0oooo03L0oooo00?o00000?ooo`3oool0203oool00ol00000oooo0?ooo`0J0?ooo`;o00007@3o
ool00`000000oooo0?ooo`0F0?ooo`;o0000A`3oool00ol00000oooo0?ooo`0<0?ooo`03o`00003o
ool0oooo00H0oooo0_l000020?ooo`03o`00003oool0oooo00T0oooo00090?ooo`03o`00003oool0
oooo00;o00001`3oool00ol00000oooo0?ooo`0h0?ooo`03o`00003oool0oooo00P0oooo0_l0000L
0?ooo`;o00006`3oool00`000000oooo0?ooo`0H0?ooo`;o0000A03oool00ol00000oooo0?ooo`0<
0?ooo`;o0000203oool01Ol00000oooo0?ooo`3ooooo000000/0oooo00090?ooo`03o`00003oool0
oooo00;o00001`3oool00ol00000oooo0?ooo`0i0?ooo`03o`00003oool0oooo00T0oooo00?o0000
0?ooo`3oool06`3oool2o`0001T0oooo00<00000o`00003oool06P3oool00ol00000oooo0?ooo`10
0?ooo`03o`00003oool0oooo00d0oooo00?o00000?ooo`3oool01P3oool2o`0000<0oooo00?o0000
0?ooo`3oool02@3oool000X0oooo00Co00000?ooool0003o0000203oool00ol00000oooo0?ooo`0i
0?ooo`;o00002P3oool2o`0001d0oooo0_l0000G0?ooo`030000003oool0oooo01/0oooo0_l0000o
0?ooo`03o`00003oool0oooo00h0oooo00?o00000?ooo`3oool01P3oool2o`000080oooo00?o0000
0?ooo`3oool02P3oool000X0oooo00Co00000?ooo`3ooooo0000203oool00ol00000oooo0?ooo`0k
0?ooo`;o00002P3oool00ol00000oooo0?ooo`0L0?ooo`03o`00003oool0oooo01@0oooo00<00000
0?ooo`3oool07@3oool2o`0003`0oooo00?o00000?ooo`3oool03P3oool00ol00000oooo0?ooo`07
0?ooo`05o`00003oool0oooo0?ooool00000303oool000X0oooo00Co00000?ooo`3ooooo00002@3o
ool00ol00000oooo0?ooo`0l0?ooo`03o`00003oool0oooo00P0oooo00?o00000?ooo`3oool0703o
ool2o`0001@0oooo00<000000?ooo`3oool07`3oool2o`0003T0oooo00?o00000?ooo`3oool03`3o
ool00ol00000oooo0?ooo`060?ooo`;o00000P3oool2o`0000`0oooo000:0?ooo`03o`00003oool0
oooo00;o0000203oool00ol00000oooo0?ooo`0m0?ooo`;o00002@3oool2o`0001h0oooo0_l0000:
0?ooo`?o00001@3oool00`000000oooo0?ooo`0Q0?ooo`;o0000=P3oool00ol00000oooo0?ooo`0?
0?ooo`;o0000203oool2o`000080oooo00?o00000?ooo`3oool02`3oool000/0oooo00Co00000?oo
o`3ooooo0000203oool00ol00000oooo0?ooo`0o0?ooo`;o00002@3oool00ol00000oooo0?ooo`0M
0?ooo`?o0000203oool00ol00000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo0ol0000a
0?ooo`;o00004P3oool00ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo00;o00003@3oool0
00/0oooo00Co00000?ooo`3ooooo00002@3oool00ol00000oooo0?ooo`100?ooo`;o0000203oool2
o`000200oooo0_l000060?ooo`03o`00003oool0oooo00@0oooo00<000000?ooo`3oool09P3oool2
o`0002`0oooo0ol0000C0?ooo`;o0000203oool2o`000080oooo0_l0000=0?ooo`002`3oool00ol0
0000oooo0?ooo`02o`0000P0oooo00?o00000?ooo`3oool0@P3oool00ol00000oooo0?ooo`070?oo
o`;o0000803oool3o`0000<0oooo00?o00000?ooo`3oool0103oool3000002P0oooo0ol0000X0?oo
o`03o`00003oool0oooo01@0oooo00?o00000?ooo`3oool01`3oool01Ol00000oooo0?ooo`3ooooo
000000h0oooo000<0?ooo`04o`00003oool0ooooo`0000T0oooo00?o00000?ooo`3oool0@P3oool2
o`0000T0oooo00?o00000?ooo`3oool0803oool2o`0000030?ooool00000oooo00D0oooo00<00000
0?ooo`3oool0:`3oool3o`0002@0oooo00?o00000?ooo`3oool0503oool00ol00000oooo0?ooo`07
0?ooo`;o00000P3oool2o`0000h0oooo000<0?ooo`04o`00003oool0ooooo`0000T0oooo00?o0000
0?ooo`3oool0A03oool2o`0000P0oooo0_l0000R0?ooo`?o00001@3oool00`000000oooo0?ooo`0^
0?ooo`?o00007P3oool3o`0001H0oooo0_l000090?ooo`04o`00003oool0oooo0?ooo`;o00003P3o
ool000`0oooo00?o00000?ooo`3oool00_l000090?ooo`03o`00003oool0oooo04D0oooo0_l00008
0?ooo`;o00008@3oool01?l00000ooooo`000?l000030?ooo`030000003oool0oooo0340oooo1?l0
000E0?ooo`Go00006@3oool00ol00000oooo0?ooo`070?ooo`;o00000P3oool2o`0000l0oooo000=
0?ooo`04o`00003oool0ooooo`0000T0oooo00?o00000?ooo`3oool0A`3oool3o`0000L0oooo0ol0
000R0?ooo`?o000000<000000?ooo`3oool0=@3oool7o`0000T0oooo1Ol0000M0?ooo`03o`00003o
ool0oooo00P0oooo00Go00000?ooo`3oool0ooooo`00000@0?ooo`003@3oool01?l00000oooo0?oo
ool0000:0?ooo`03o`00003oool0oooo04T0oooo0_l000080?ooo`;o00008`3oool2o`0003d0oooo
2Ol0000Q0?ooo`;o00002@3oool2o`000080oooo0_l0000@0?ooo`003@3oool00ol00000oooo0?oo
o`02o`0000T0oooo00?o00000?ooo`3oool0B`3oool2o`0000P0oooo0_l0000Q0?ooo`0300000?l0
003o000000;o0000H`3oool2o`0000T0oooo0_l000030?ooo`03o`00003oool0oooo00l0oooo000>
0?ooo`04o`00003oool0ooooo`0000X0oooo00?o00000?ooo`3oool0C03oool2o`0000P0oooo0ol0
000N0?ooo`030000003oool0oooo0080oooo0ol0001O0?ooo`;o00002P3oool2o`000080oooo0_l0
000A0?ooo`003P3oool01?l00000oooo0?ooool0000:0?ooo`03o`00003oool0oooo04h0oooo0ol0
00080?ooo`?o00006`3oool00`000000oooo0?ooo`050?ooo`;o0000G03oool2o`0000X0oooo0_l0
00020?ooo`;o00004P3oool000l0oooo00Co00000?ooool0003o00002P3oool00ol00000oooo0?oo
o`1@0?ooo`?o0000203oool3o`0001P0oooo00<000000?ooo`3oool01`3oool3o`0005P0oooo0_l0
000:0?ooo`;o00000`3oool00ol00000oooo0?ooo`0A0?ooo`003`3oool01?l00000oooo0?ooool0
000:0?ooo`03o`00003oool0oooo05<0oooo0ol000080?ooo`?o00005@3oool00`000000oooo0?oo
o`0:0?ooo`;o0000E03oool3o`0000/0oooo00Co00000?ooo`3oool0oooo0_l0000C0?ooo`003`3o
ool01?l00000oooo0?ooool0000;0?ooo`03o`00003oool0oooo05D0oooo0ol000080?ooo`?o0000
4P3oool00`000000oooo0?ooo`0<0?ooo`?o0000D03oool00ol00000ooooo`00000;0?ooo`;o0000
0`3oool00ol00000oooo0?ooo`0B0?ooo`00403oool01?l00000ooooo`000?l0000;0?ooo`03o`00
003oool0oooo05L0oooo0ol000080?ooo`?o00003`3oool00`00003o00000?ooo`0?0?ooo`?o0000
B`3oool2o`0000030?ooool00000oooo00X0oooo0_l000030?ooo`;o0000503oool00100oooo00Co
00000?ooo`3ooooo00002`3oool00ol00000oooo0?ooo`1J0?ooo`?o0000203oool3o`0000`0oooo
00<000000?ooo`3oool04P3oool3o`0004L0oooo00Co00000?ooo`3ooooo00002`3oool2o`0000@0
oooo00?o00000?ooo`3oool04`3oool00100oooo00?o00000?ooo`3oool00_l0000;0?ooo`03o`00
003oool0oooo05`0oooo1?l000070?ooo`?o00002@3oool00`000000oooo0?ooo`0E0?ooo`?o0000
@P3oool2o`000080oooo00?o00000?ooo`3oool02@3oool3o`0000<0oooo00?o00000?ooo`3oool0
503oool00140oooo00?o00000?ooo`3oool00_l0000;0?ooo`03o`00003oool0oooo05l0oooo0ol0
00070?ooo`?o00001P3oool00`000000oooo0?ooo`0H0?ooo`Co0000?03oool2o`0000<0oooo00?o
00000?ooo`3oool02@3oool3o`0000<0oooo00?o00000?ooo`3oool05@3oool00140oooo00Go0000
0?ooo`3oool0ooooo`00000;0?ooo`03o`00003oool0oooo0680oooo1?l000060?ooo`Co00000P3o
ool00`000000oooo0?ooo`0L0?ooo`?o0000=`3oool2o`0000@0oooo00?o00000?ooo`3oool0203o
ool4o`0000<0oooo0_l0000G0?ooo`004P3oool00ol00000oooo0?ooo`02o`0000/0oooo00?o0000
0?ooo`3oool0I@3oool3o`0000L0oooo0ol0000Q0?ooo`Ko0000;P3oool3o`0000@0oooo0_l0000:
0?ooo`04o`00003ooooo0000o`0000<0oooo0_l0000H0?ooo`004`3oool00ol00000oooo0?ooo`02
o`0000/0oooo00?o00000?ooo`3oool0I`3oool4o`0000D0oooo00<00000o`000?l000000_l0000S
0?ooo`Ko00009@3oool3o`0000H0oooo00?o00000?ooo`3oool02@3oool4o`0000<0oooo0_l0000I
0?ooo`004`3oool01Ol00000oooo0?ooo`3ooooo000000`0oooo00?o00000?ooo`3oool0JP3oool3
o`000080oooo00<00000o`00003oool00P3oool3o`0002H0oooo1?l0000L0?ooo`Go00001`3oool2
o`0000/0oooo0_l00000103ooooo00000?ooo`3oool3o`0001X0oooo000D0?ooo`03o`00003oool0
oooo00;o0000303oool00ol00000oooo0?ooo`1/0?ooo`Co00001P3oool4o`0002H0oooo1_l0000>
0?ooo`So00002`3oool00ol00000oooo0?ooo`090?ooo`;o00000P3oool01_l00000oooo0?ooool0
0000ooooo`0001/0oooo000E0?ooo`04o`00003oool0ooooo`0000d0oooo00?o00000?ooo`3oool0
K@3oool00`000000ooooo`000003o`0000H0oooo0ol0000Y0?ooo`ko00004@3oool2o`0000/0oooo
0_l000020?ooo`06o`00003ooooo0000o`00003ooooo0000703oool001D0oooo00?o00000?ooo`3o
ool00_l0000=0?ooo`03o`00003oool0oooo06`0oooo00<000000?ooo`3oool00`3oool5o`0000@0
oooo1Ol000110?ooo`;o0000303oool00ol00000oooo0?ooo`04o`000080oooo00?o00000?ooo`3o
ool06`3oool001H0oooo00?o00000?ooo`3oool00_l0000=0?ooo`03o`00003oool0oooo06/0oooo
00<000000?ooo`3oool0203oool4o`0000D0oooo1Ol0000k0?ooo`03o`00003oool0oooo00X0oooo
0_l000020?ooo`03o`00003ooooo000000<0oooo00?o00000?ooo`3oool0703oool001H0oooo00Go
00000?ooo`3oool0ooooo`00000>0?ooo`03o`00003oool0oooo06X0oooo00<000000?ooo`3oool0
303oool4o`0000H0oooo1?l0000e0?ooo`;o00002`3oool2o`0000<0oooo0ol000030?ooo`03o`00
003oool0oooo01d0oooo000G0?ooo`05o`00003oool0oooo0?ooool000003P3oool2o`0006X0oooo
00<00000o`00003oool0403oool3o`0000L0oooo1Ol0000^0?ooo`;o00002`3oool2o`0000<0oooo
0ol000040?ooo`03o`00003oool0oooo01h0oooo000H0?ooo`05o`00003oool0oooo0?ooool00000
3`3oool2o`0006P0oooo00<000000?ooo`3oool04`3oool4o`0000P0oooo1?l0000W0?ooo`?o0000
2`3oool3o`0000<0oooo00?o00000?ooool000000`3oool2o`000240oooo000H0?ooo`03o`00003o
ool0oooo0080oooo00?o00000?ooo`3oool03P3oool2o`0006H0oooo00<000000?ooo`3oool05`3o
ool3o`0000T0oooo1Ol0000O0?ooo`?o00002`3oool4o`0000@0oooo0ol000030?ooo`03o`00003o
ool0oooo0240oooo000I0?ooo`03o`00003oool0oooo0080oooo00?o00000?ooo`3oool03`3oool0
0ol00000oooo0?ooo`1S0?ooo`030000003oool0oooo01X0oooo0ol0000;0?ooo`Co00005`3oool4
o`0000T0oooo1ol000040?ooo`?o00000`3oool2o`0002@0oooo000J0?ooo`03o`00003oool0oooo
0080oooo00?o00000?ooo`3oool03`3oool2o`0005X0oooo1Ol000040?ooo`030000003oool0oooo
01d0oooo1_l000090?ooo`Go00003P3oool4o`0000H0oooo1ol000020?ooo`;o0000103oool4o`00
00<0oooo0_l0000V0?ooo`006`3oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo0100
oooo0_l0001I0?ooo`04o`00003oool0ooooo`0000@0oooo00<000000?ooo`3oool08`3oool8o`00
00H0oooo6?l000060?ooo`?o000000<0ooooo`000?l000001Ol000040?ooo`03o`00003oool0oooo
02H0oooo000L0?ooo`03o`00003oool0oooo0080oooo00?o00000?ooo`3oool04@3oool2o`0005P0
oooo00?o00000?ooo`3oool0103oool3000002/0oooo2Ol000030?ooo`Co00004@3oool7o`0000<0
oooo0_l000040?ooo`;o0000:@3oool001d0oooo00?o00000?ooo`3oool00P3oool00ol00000oooo
0?ooo`0B0?ooo`;o0000E`3oool00ol00000oooo0?ooo`030?ooo`030000003oool0oooo03<0oooo
2Ol0000=0?ooo`Ko00001@3oool2o`0000@0oooo0_l0000[0?ooo`007P3oool00ol00000oooo0?oo
o`020?ooo`;o0000503oool2o`000580oooo00Go00000?ooo`3oool0ooooo`0000040?ooo`030000
003oool0oooo02h0oooo1Ol000090?ooo`oo00001P3oool3o`0000@0oooo0_l0000]0?ooo`007`3o
ool2o`0000@0oooo0_l0000D0?ooo`?o0000C`3oool01Ol00000oooo0?ooo`3ooooo000000@0oooo
00<000000?ooo`3oool0:03oool6o`0000/0oooo2_l0000;0?ooo`?o00001@3oool2o`0002l0oooo
000Q0?ooo`03o`00003oool0oooo0080oooo0_l0000F0?ooo`?o0000C@3oool3o`0000D0oooo00<0
00000?ooo`3oool08@3oool7o`0000D0oooo3?l0000B0?ooo`?o00001P3oool2o`000340oooo000R
0?ooo`;o00000`3oool3o`0001L0oooo0ol0001B0?ooo`030000003oool0oooo02go00006`3oool3
o`0000L0oooo0_l0000c0?ooo`00903oool00ol00000oooo0?ooo`020?ooo`?o0000603oool5o`00
03T0oooo5ol0000D0?ooo`Oo0000:P3oool3o`0000L0oooo0ol0000e0?ooo`009@3oool00ol00000
oooo0?ooo`020?ooo`03o`00003ooooo000001`0oooo2?l0000T0?ooo`go0000503oool00`00003o
00000?ooo`0;0?ooo`Wo0000;P3oool3o`0000L0oooo0ol0000h0?ooo`009P3oool2o`0000<0oooo
00Co00000?ooool0003o00008P3ooolTo`000240oooo00<000000?ooo`3oool00`3oool8o`0003<0
oooo1?l000050?ooo`Go0000>`3oool002P0oooo00Co00000?ooo`3oool0oooo0_l000000`3ooooo
0000o`00001R0?ooo`Wo0000=P3oool5o`0000@0oooo1Ol000100?ooo`00:@3oool2o`0000<0oooo
1_l0001H0?ooo`Oo00000`3oool00`000000oooo0?ooo`0d0?ooo`Go00000`3oool6o`0004D0oooo
000[0?ooo`;o0000103oool2o`0000030?ooool0003o000004l0oooo1ol0000:0?ooo`030000003o
ool0oooo02`0oooo2?l000020?ooo`Ko0000B`3oool002d0oooo0_l000040?ooo`Ko0000A@3oool7
o`000140oooo00<000000?ooo`3oool0803oool<o`000080oooo2?l0001A0?ooo`00;`3oool00ol0
0000oooo0?ooo`040?ooo`;o000000@0ooooo`000?l0003o0000>P3oool8o`0001P0oooo00<00000
o`00003oool05@3ooolIo`0005T0oooo000`0?ooo`;o00001P3oool3o`0000030?ooool0003o0000
00;o0000;P3oool8o`000200oooo00<000000?ooo`3oool02@3oool@o`0006h0oooo000b0?ooo`;o
00001`3oool3o`000080oooo1_l0000S0?ooo`Go00008`3ooolBo`0007d0oooo000d0?ooo`?o0000
1`3oool3o`0000D0oooo1ol0000;0?oooa7o00006`3ooolFo`0008H0oooo000g0?ooo`Co00001P3o
ool4o`0000P0oooo2ol0000P0?ooo`co00000P3oool:o`0000H0oooo00<000000?ooo`3oool0Q`3o
ool003/0oooo0ol000070?ooo`Oo0000703oool@o`0000D0oooo2Ol0000@0?ooo`030000003oool0
oooo08L0oooo000n0?ooo`Go00002@3ooolLo`0000/0oooo2_l0000I0?ooo`0300000?l00000oooo
08L0oooo00130?ooo`Go0000803oool;o`0002<0oooo00<000000?ooo`3oool0Q`3oool004P0oooo
8?l0000^0?ooo`030000003oool0oooo08L0oooo002F0?ooo`030000003oool0oooo08L0oooo002F
0?ooo`030000003oool0oooo08L0oooo002F0?ooo`030000003oool0oooo08L0oooo002F0?ooo`03
0000003oool0oooo08L0oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.19505, -2.7927, \
0.0145512, 0.0315591}},
  CellTags->"T.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.3"]
}, Open  ]],

Cell[TextData[{
  "All of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s numerical algorithms are set up to work to whatever \
accuracy or precision you specify."
}], "Subsubsection",
  CellTags->"T.3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Mathematical Knowledge in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section",
  CellTags->"T.4"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " incorporates the knowledge from the world\[CloseCurlyQuote]s mathematical \
handbooks\[LongDash]and uses its own revolutionary algorithms to go much \
further."
}], "Subsection",
  CellTags->"T.4"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows about all the hundreds of special functions in pure and applied \
mathematics."
}], "Subsubsection",
  CellTags->"T.4"],

Cell[" ", "LineSpace",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LegendreQ[3, x]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(2\/3 - \(5\ x\^2\)\/2 - 
      1\/4\ x\ \((3 - 5\ x\^2)\)\ Log[\(1 + x\)\/\(1 - x\)]\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can evaluate special functions with any parameters to any precision."
}], "Commentary",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[MathieuC[1 + \[ImaginaryI], 2  \[ImaginaryI], 3], 50]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(3.9251311374125198643497646168158379203627176844793881135427745223192`\
50.10485313366867 + 
      1.8988239115433472411052747971439115776785813553761263303517103659543`\
49.78948365477323\ \[ImaginaryI]\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is now able to do vastly more integrals than were ever before possible \
for either humans or computers."
}], "Subsubsection",
  CellTags->"T.4"],

Cell[" ", "LineSpace",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Sqrt[x] ArcTan[x], x]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(1\/6\ \((\(-8\)\ \@x - 2\ \@2\ ArcTan[1 - \@2\ \@x] + 
          2\ \@2\ ArcTan[1 + \@2\ \@x] + 
          4\ x\^\(3/2\)\ ArcTan[
              x] - \@2\ Log[\(-1\) + \@2\ \@x - x] + \@2\ Log[
              1 + \@2\ \@x + x])\)\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell["\<\
Here is a definite integral. The results often require special \
functions.\
\>", "Commentary",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Log[x]\ Exp[\(-x^3\)], {x, 0, Infinity}]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(\(-\(1\/54\)\)\ Gamma[
        1\/3]\ \((6\ EulerGamma + \@3\ \[Pi] + 9\ Log[3])\)\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell["Here is a symbolic sum.", "Commentary",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sum[1/\((k + 1)\)^6, {k, 0, n}]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(\[Pi]\^6\/945 - 1\/120\ PolyGamma[5, 2 + n]\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve a wide range of ordinary and partial differential equations."
}], "Commentary",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''\)[x] + \(y'\)[x] + x\ y[x] == 0, y[x], x]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(\(-x\)/2\)\ \
AiryAi[\(-\((\(-1\))\)\^\(1/3\)\)\ \((1\/4 - x)\)]\ C[
                1] + \[ExponentialE]\^\(\(-x\)/2\)\ \
AiryBi[\(-\((\(-1\))\)\^\(1/3\)\)\ \((1\/4 - x)\)]\ C[2]}}\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell["This finds the billionth prime number.", "Commentary",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Prime[10^9]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(22801763489\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s algorithms can generate a huge range of mathematical \
results."
}], "Commentary",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[Product[Gamma[2  n\ /5], {n, 1, 5}]]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(\(12\ \[Pi]\^2\)\/\(25\ \@5\)\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[Exists[x, x^2 + a\ x + b == 0], {a, b}, Reals]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(b \[LessEqual] a\^2\/4\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[2] < Zeta[3] < Sqrt[2]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(True\)], "Output",
  CellTags->"T.4"]
}, Open  ]],

Cell[TextData[{
  "You can tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " assumptions about variables."
}], "Commentary",
  CellTags->"T.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Sin[x + 2  \[Pi]\ n], n \[Element] Integers]\)], "Input",
  CellTags->"T.4"],

Cell[BoxData[
    \(Sin[x]\)], "Output",
  CellTags->"T.4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Building Up Computations", "Section",
  CellTags->"T.5"],

Cell["\<\
Being able to work with formulas lets you easily integrate all the \
parts of a computation.\
\>", "Subsection",
  CellTags->"T.5"],

Cell["Here are the eigenvalues of a matrix of numbers. ", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Eigenvalues[{{3, 1}, {2, 6}}]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \({1\/2\ \((9 + \@17)\), 1\/2\ \((9 - \@17)\)}\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can still compute the eigenvalues even when symbolic parameters are \
introduced. This expression is a compact representation of the eigenvalues \
for any value of c."
}], "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(v\  = \ Eigenvalues[{{3, \ 1}, \ {2, \ c}}]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \({1\/2\ \((3 + c - \@\(17 - 6\ c + c\^2\))\), 
      1\/2\ \((3 + c + \@\(17 - 6\ c + c\^2\))\)}\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica\[CloseCurlyQuote]",
    FontSlant->"Italic"],
  "s functions are carefully designed so that output from one can easily be \
used as input to others."
}], "Subsubsection",
  CellTags->"T.5"],

Cell["\<\
This takes the formula for the eigenvalues and immediately plots \
it.This picture shows how the eigenvalues vary with c.\
\>", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[v], {c, \(-10\), 10}]\)], "Input",
  CellTags->"T.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.307247 0.028815 [
[.02381 .29475 -9 -9 ]
[.02381 .29475 9 0 ]
[.2619 .29475 -6 -9 ]
[.2619 .29475 6 0 ]
[.7381 .29475 -3 -9 ]
[.7381 .29475 3 0 ]
[.97619 .29475 -6 -9 ]
[.97619 .29475 6 0 ]
[.4875 .0191 -18 -4.5 ]
[.4875 .0191 0 4.5 ]
[.4875 .16317 -12 -4.5 ]
[.4875 .16317 0 4.5 ]
[.4875 .45132 -6 -4.5 ]
[.4875 .45132 0 4.5 ]
[.4875 .5954 -12 -4.5 ]
[.4875 .5954 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30725 m
.02381 .3135 L
s
[(-10)] .02381 .29475 0 1 Mshowa
.2619 .30725 m
.2619 .3135 L
s
[(-5)] .2619 .29475 0 1 Mshowa
.7381 .30725 m
.7381 .3135 L
s
[(5)] .7381 .29475 0 1 Mshowa
.97619 .30725 m
.97619 .3135 L
s
[(10)] .97619 .29475 0 1 Mshowa
.125 Mabswid
.07143 .30725 m
.07143 .311 L
s
.11905 .30725 m
.11905 .311 L
s
.16667 .30725 m
.16667 .311 L
s
.21429 .30725 m
.21429 .311 L
s
.30952 .30725 m
.30952 .311 L
s
.35714 .30725 m
.35714 .311 L
s
.40476 .30725 m
.40476 .311 L
s
.45238 .30725 m
.45238 .311 L
s
.54762 .30725 m
.54762 .311 L
s
.59524 .30725 m
.59524 .311 L
s
.64286 .30725 m
.64286 .311 L
s
.69048 .30725 m
.69048 .311 L
s
.78571 .30725 m
.78571 .311 L
s
.83333 .30725 m
.83333 .311 L
s
.88095 .30725 m
.88095 .311 L
s
.92857 .30725 m
.92857 .311 L
s
.25 Mabswid
0 .30725 m
1 .30725 L
s
.5 .0191 m
.50625 .0191 L
s
[(-10)] .4875 .0191 1 0 Mshowa
.5 .16317 m
.50625 .16317 L
s
[(-5)] .4875 .16317 1 0 Mshowa
.5 .45132 m
.50625 .45132 L
s
[(5)] .4875 .45132 1 0 Mshowa
.5 .5954 m
.50625 .5954 L
s
[(10)] .4875 .5954 1 0 Mshowa
.125 Mabswid
.5 .04791 m
.50375 .04791 L
s
.5 .07673 m
.50375 .07673 L
s
.5 .10554 m
.50375 .10554 L
s
.5 .13436 m
.50375 .13436 L
s
.5 .19199 m
.50375 .19199 L
s
.5 .2208 m
.50375 .2208 L
s
.5 .24962 m
.50375 .24962 L
s
.5 .27843 m
.50375 .27843 L
s
.5 .33606 m
.50375 .33606 L
s
.5 .36488 m
.50375 .36488 L
s
.5 .39369 m
.50375 .39369 L
s
.5 .42251 m
.50375 .42251 L
s
.5 .48014 m
.50375 .48014 L
s
.5 .50895 m
.50375 .50895 L
s
.5 .53777 m
.50375 .53777 L
s
.5 .56658 m
.50375 .56658 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .03781 L
.10458 .06295 L
.14415 .08651 L
.18221 .10911 L
.22272 .13309 L
.26171 .15607 L
.30316 .18035 L
.34309 .20356 L
.3815 .22566 L
.42237 .24881 L
.46172 .27059 L
.49955 .29083 L
.53984 .31122 L
.57861 .3291 L
.61984 .34539 L
.65954 .35768 L
.69774 .36629 L
.71741 .36967 L
.73838 .37263 L
.75836 .37496 L
.77996 .37702 L
.82003 .37996 L
.86103 .38213 L
.90052 .38368 L
.93849 .38485 L
.97619 .38577 L
s
.02381 .39807 m
.06244 .39836 L
.10458 .39871 L
.14415 .3991 L
.18221 .39953 L
.22272 .40006 L
.26171 .40068 L
.30316 .40148 L
.34309 .40243 L
.3815 .40357 L
.42237 .40515 L
.46172 .40718 L
.49955 .40984 L
.52059 .41174 L
.53984 .41383 L
.57861 .4194 L
.5976 .42299 L
.61832 .42769 L
.65897 .43961 L
.69809 .45445 L
.73968 .47317 L
.77974 .49321 L
.81829 .51369 L
.8593 .53631 L
.89878 .55863 L
.93676 .58043 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oT?ooool0
0`00003oooooooooo`2=ooooo`00T?ooool00`00003oooooooooo`2=ooooo`00T?ooool00`00003o
ooooooooo`2=ooooo`00P_ooool3o`0000Cooooo0_l00005ooooo`0300000?oooooooooo08gooooo
0009ooooo`800000N?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo
00<00000ooooooooool0SOooool000_ooooo00<00000ooooooooool0KOooool5o`0000?ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00004ooooo`<00000SOooool000cooooo0P00
001eooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001?ooool00`00003ooooo
ooooo`2=ooooo`003_ooool2000007?ooooo00?o0000ooooooooool00_ooool01?l0003ooooooooo
ool00004ooooo`0300000?oooooooooo08gooooo000@ooooo`0300000?oooooooooo06oooooo0_l0
0004ooooo`04o`000?ooooooooooo`0000Cooooo00<00000ooooooooool0SOooool0017ooooo0P00
001`ooooo`03o`000?oooooooooo00?ooooo0_l00005ooooo`0300000?oooooooooo08gooooo000C
ooooo`0300000?oooooooooo07[ooooo00<00000ooooooooool0SOooool001Cooooo0P00001joooo
o`0300000?oooooooooo08gooooo000Fooooo`800000N?ooool00`00003oooooooooo`2=ooooo`00
6?ooool00`00003oooooooooo`1eooooo`0300000?oooooooooo08gooooo000Iooooo`800000MOoo
ool00`00003o0000ooooo`2=ooooo`006oooool2000007?ooooo00<00000ooooooooool0SOooool0
01gooooo00<00000ooooooooool0L?ooool00`00003oooooooooo`2=ooooo`007_ooool20000073o
oooo00<00000ooooooooool0SOooool0023ooooo0P00001^ooooo`0300000?oooooooooo08gooooo
000Rooooo`0300000?oooooooooo06_ooooo00<00000ooooooooool0SOooool002?ooooo0P00001[
ooooo`0300000?oooooooooo08gooooo000Uooooo`800000JOooool00`00003oooooooooo`2=oooo
o`009oooool00`00003oooooooooo`1Vooooo`0300000?l0003ooooo08gooooo000Xooooo`800000
I_ooool00`00003oooooooooo`2=ooooo`00:_ooool00`00003oooooooooo`1Sooooo`0300000?oo
oooooooo08gooooo000[ooooo`800000Hoooool00`00003oooooooooo`2=ooooo`00;Oooool20000
067ooooo00<00000ooooooooool0SOooool002oooooo0P00001Oooooo`0300000?oooooooooo08go
oooo000aooooo`0300000?oooooooooo05cooooo00<00000ooooooooool0SOooool003;ooooo0P00
001Looooo`0300000?oooooooooo08gooooo000dooooo`800000F_ooool00`00003o0000ooooo`2=
ooooo`00=_ooool2000005Sooooo00<00000ooooooooool0SOooool003Sooooo00<00000oooooooo
ool0EOooool00`00003oooooooooo`2=ooooo`00>Oooool2000005Gooooo00<00000ooooooooool0
SOooool003_ooooo0P00001Cooooo`0300000?oooooooooo08gooooo000mooooo`0300000?oooooo
oooo053ooooo00<00000ooooooooool0SOooool003kooooo0P00001@ooooo`0300000?oooooooooo
08gooooo0010ooooo`0300000?oooooooooo04gooooo00<00000ooooooooool0SOooool0047ooooo
0P00001=ooooo`0300000?l0003ooooo08gooooo0013ooooo`800000Boooool00`00003ooooooooo
o`2=ooooo`00AOooool2000004Wooooo00<00000ooooooooool0SOooool004Oooooo00<00000oooo
ooooool0A_ooool00`00003oooooooooo`2=ooooo`00B?ooool2000004Kooooo00<00000oooooooo
ool0SOooool004[ooooo0P000014ooooo`0300000?oooooooooo08gooooo001<ooooo`800000>_oo
ool3o`0000Gooooo00<00000ooooooooool0SOooool004kooooo0P00000gooooo`05o`000?oooooo
ooooooooool000001?ooool00`00003oooooooooo`2=ooooo`00D?ooool00`00003oooooooooo`0^
ooooo`Go00001Oooool00ol0003oooooooooo`02ooooo`<00000SOooool0057ooooo0P00000hoooo
o`03o`000?oooooooooo00;ooooo00<00000ooooooooool0SOooool005?ooooo0P00000booooo`Co
00001Oooool00`00003oooooooooo`2=ooooo`00EOooool00`00003oooooooooo`0_ooooo`03o`00
0?oooooooooo00Kooooo00<00000ooooooooool0SOooool005Kooooo0P00000_ooooo`Go00001?oo
ool00`00003oooooooooo`2=ooooo`00F?ooool2000003Kooooo00<00000ooooooooool0SOooool0
05[ooooo00<00000ooooooooool0<oooool00`00003oooooooooo`2=ooooo`00Foooool2000003?o
oooo00<00000ooooooooool0SOooool005gooooo0P00000aooooo`0300000?oooooooooo08gooooo
001Oooooo`0300000?oooooooooo02kooooo00<00000o`000?ooool0SOooool0063ooooo0P00000^
ooooo`0300000?oooooooooo08gooooo001Rooooo`0300000?oooooooooo02_ooooo00<00000oooo
ooooool0SOooool006?ooooo0P00000[ooooo`0300000?oooooooooo08gooooo001Uooooo`800000
:Oooool00`00003oooooooooo`2=ooooo`00Ioooool2000002Oooooo00<00000ooooooooool0SOoo
ool006Wooooo00<00000ooooooooool09?ooool00`00003oooooooooo`2=ooooo`00J_ooool20000
02Cooooo00<00000ooooooooool0SOooool006cooooo0P00000Rooooo`0300000?l0003ooooo08go
oooo001^ooooo`8000008?ooool00`00003oooooooooo`2=ooooo`00L?ooool2000001kooooo00<0
0000ooooooooool0SOooool007;ooooo00<00000ooooooooool06oooool00`00003oooooooooo`2=
ooooo`00Loooool2000001_ooooo00<00000ooooooooool0SOooool007Gooooo0P00000Iooooo`03
00000?oooooooooo08gooooo001gooooo`0300000?oooooooooo01Kooooo00<00000ooooooooool0
SOooool007Sooooo0P00000Fooooo`0300000?oooooooooo08gooooo001jooooo`8000005?ooool0
0`00003o0000ooooo`2=ooooo`00O?ooool2000001;ooooo00<00000ooooooooool0SOooool007ko
oooo0P00000@ooooo`0300000?oooooooooo08gooooo0020ooooo`0300000?oooooooooo00gooooo
00<00000ooooooooool0SOooool0087ooooo0P00000=ooooo`0300000?oooooooooo08gooooo0007
ooooo`?o00001?ooool2o`0003gooooo0ol0000cooooo`8000002oooool00`00003oooooooooo`0o
ooooo`?o0000?_ooool3o`0000Cooooo0_l00004ooooo`002?ooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0003_ooooo00Go0000ooooooooooooooooo`00000dooooo`8000002Ooo
ool00`00003oooooooooo`0nooooo`05o`000?ooooooooooooooool00000?_ooool00ol0003ooooo
ooooo`02ooooo`04o`000?ooooooooooo`0000?ooooo0005o`0000?ooooo00?o0000ooooooooool0
0_ooool01?l0003oooooooooool0000eooooo`Go00001Oooool00ol0003oooooooooo`0dooooo`80
00001oooool00`00003oooooooooo`12ooooo`03o`000?oooooooooo03cooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00003ooooo`002?ooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0003oooooo00?o0000ooooooooool0=_ooool2000000Gooooo00<00000o`00
0?ooool0@_ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooo00000oooool000Sooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0000k
ooooo`Co0000>oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo03kooooo1?l0000o
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000oooool000Oooooo0_l00004
ooooo`04o`000?ooooooooooo`0003_ooooo00?o0000ooooooooool0?Oooool2000000;ooooo00<0
0000ooooooooool0?_ooool00ol0003oooooooooo`0oooooo`;o00001?ooool01?l0003ooooooooo
ool00003ooooo`002?ooool00ol0003oooooooooo`03ooooo`;o0000??ooool5o`0003gooooo0`00
0010ooooo`Go0000?_ooool00ol0003oooooooooo`03ooooo`;o00001?ooool0093ooooo0P00002>
ooooo`00T?ooool01000003ooooo00000000002<ooooo`00T?ooool01000003oooooooooooooool2
000008[ooooo002@ooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool0Qoooool0093o
oooo00<00000ooooooooool01?ooool2000008Oooooo0002ooooool000007`00000000Wooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02_ooool00`00003oooooooooo`08ooooo`80000000?oooooo`000?ooool02ooo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01Ooo
ool0093ooooo00<00000ooooooooool02_ooool20000087ooooo002@ooooo`0300000?oooooooooo
00cooooo0`00001nooooo`00T?ooool00`00003oooooooooo`0?ooooo`800000O?ooool0093ooooo
00<00000ooooooooool04Oooool2000007[ooooo002@ooooo`0300000?oooooooooo01?ooooo0`00
001gooooo`00T?ooool00`00003oooooooooo`0Fooooo`<00000M?ooool0093ooooo00<00000o`00
0?ooool06Oooool30000077ooooo002@ooooo`0300000?oooooooooo01cooooo0`00001^ooooo`00
T?ooool00`00003oooooooooo`0Oooooo`<00000Joooool0093ooooo00<00000ooooooooool08_oo
ool3000006Sooooo002@ooooo`0300000?oooooooooo02Gooooo0`00001Uooooo`00T?ooool00`00
003oooooooooo`0Xooooo`<00000H_ooool0093ooooo00<00000ooooooooool0:oooool4000005ko
oooo002@ooooo`0300000?oooooooooo02oooooo1@00001Iooooo`00T?ooool00`00003o0000oooo
o`0dooooo`D00000E?ooool0093ooooo00<00000ooooooooool0>Oooool6000004kooooo002@oooo
o`0300000?oooooooooo03oooooo1P000018ooooo`00T?ooool00`00003oooooooooo`15ooooo`l0
0000>Oooool0093ooooo00<00000ooooooooool0E?ooool;000002kooooo002@ooooo`0300000?oo
oooooooo05oooooo5`00000Gooooo`00T?ooool00`00003oooooooooo`1foooooa0000001oooool0
093ooooo00<00000ooooooooool0SOooool0093ooooo00<00000o`000?ooool0SOooool000Wooooo
4P00001eooooo`0300000?oooooooooo08gooooo000Koooood@00000<Oooool00`00003ooooooooo
o`2=ooooo`00GooooolR000000oooooo00<00000ooooooooool0SOooool0087ooooo2`000004oooo
o`0300000?oooooooooo08gooooo002<ooooo`h00000Q_ooool0093ooooo00<00000ooooooooool0
1oooool8000007kooooo002@ooooo`0300000?oooooooooo00oooooo2000001fooooo`00T?ooool0
0`00003o0000ooooo`0Gooooo`D00000LOooool0093ooooo00<00000ooooooooool07?ooool30000
06kooooo002@ooooo`0300000?oooooooooo01oooooo0`00001[ooooo`00T?ooool00`00003ooooo
ooooo`0Rooooo`@00000Ioooool0093ooooo00<00000ooooooooool09_ooool3000006Cooooo002@
ooooo`0300000?oooooooooo02Wooooo1000001Pooooo`00R?ooool3o`0000Gooooo00<00000oooo
ooooool0;Oooool3000005gooooo0027ooooo`05o`000?ooooooooooooooool000001?ooool00`00
003oooooooooo`0`ooooo`<00000F_ooool008_ooooo00?o0000ooooooooool00_ooool00`00003o
ooooooooo`0cooooo`<00000Eoooool008_ooooo00?o0000ooooooooool00_ooool3000003Kooooo
0P00001Eooooo`00Qoooool4o`0000Gooooo00<00000ooooooooool0>?ooool2000005?ooooo0027
ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool0>_ooool20000057ooooo0027oooo
o`Go00001?ooool00`00003oooooooooo`0looooo`0300000?oooooooooo04kooooo002@ooooo`03
00000?oooooooooo03gooooo0P00001>ooooo`00T?ooool00`00003oooooooooo`0oooooo`800000
C?ooool0093ooooo00<00000ooooooooool0@Oooool2000004[ooooo002@ooooo`0300000?oooooo
oooo04?ooooo0`000017ooooo`00T?ooool00`00003o0000ooooo`16ooooo`800000AOooool0093o
oooo00<00000ooooooooool0B?ooool2000004?ooooo002@ooooo`0300000?oooooooooo04[ooooo
0`000010ooooo`00T?ooool00`00003oooooooooo`1=ooooo`800000?_ooool0093ooooo00<00000
ooooooooool0Coooool2000003cooooo002@ooooo`0300000?oooooooooo057ooooo0P00000joooo
o`00T?ooool00`00003oooooooooo`1Cooooo`0300000?oooooooooo03Oooooo002@ooooo`030000
0?oooooooooo05Cooooo0P00000gooooo`00T?ooool00`00003o0000ooooo`1Fooooo`800000=Ooo
ool0093ooooo00<00000ooooooooool0F?ooool2000003?ooooo002@ooooo`0300000?oooooooooo
05[ooooo00<00000ooooooooool0<?ooool0093ooooo00<00000ooooooooool0Foooool20000033o
oooo002@ooooo`0300000?oooooooooo05gooooo0P00000^ooooo`00T?ooool00`00003ooooooooo
o`1Oooooo`0300000?oooooooooo02_ooooo002@ooooo`0300000?oooooooooo063ooooo0P00000[
ooooo`00T?ooool00`00003oooooooooo`1Rooooo`0300000?oooooooooo02Sooooo002@ooooo`03
00000?l0003ooooo06?ooooo0P00000Xooooo`00T?ooool00`00003oooooooooo`1Uooooo`800000
9_ooool0093ooooo00<00000ooooooooool0Ioooool2000002Cooooo002@ooooo`0300000?oooooo
oooo06Wooooo0P00000Rooooo`00T?ooool00`00003oooooooooo`1[ooooo`8000008?ooool0093o
oooo00<00000ooooooooool0KOooool2000001kooooo002@ooooo`0300000?oooooooooo06oooooo
0P00000Looooo`00T?ooool00`00003oooooooooo`1aooooo`8000006_ooool0093ooooo00<00000
o`000?ooool0Loooool00`00003oooooooooo`0Gooooo`00T?ooool00`00003oooooooooo`1doooo
o`8000005oooool0093ooooo00<00000ooooooooool0M_ooool2000001Gooooo002@ooooo`030000
0?oooooooooo07Sooooo00<00000ooooooooool04_ooool0093ooooo00<00000ooooooooool0NOoo
ool2000001;ooooo002@ooooo`0300000?oooooooooo07_ooooo0P00000@ooooo`00P_ooool3o`00
00Cooooo0_l00005ooooo`0300000?oooooooooo07gooooo00<00000ooooooooool03Oooool008?o
oooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00004ooooo`0300000?oooooooooo
07kooooo0P00000=ooooo`00Poooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`00
00Cooooo00<00000ooooooooool0P?ooool2000000_ooooo0023ooooo`03o`000?oooooooooo00;o
oooo00Co0000oooooooooooo00001?ooool3000008;ooooo00<00000ooooooooool02?ooool008?o
oooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00004ooooo`0300000?oooooooooo
08?ooooo0P000008ooooo`00P_ooool2o`0000Cooooo00Co0000oooooooooooo00001?ooool00`00
003oooooooooo`25ooooo`0300000?oooooooooo00Gooooo0023ooooo`03o`000?oooooooooo00?o
oooo0_l00005ooooo`0300000?oooooooooo08gooooo002@ooooo`0300000?oooooooooo08gooooo
002@ooooo`0300000?oooooooooo08gooooo002@ooooo`0300000?oooooooooo08gooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-10.6638, -10.7198, \
0.0737416, 0.121864}},
  CellTags->"T.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell["\<\
You can solve for the value of b at which the first eigenvalue is \
zero.\
\>", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[First[v] == 0, c]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \({{c \[Rule] 2\/3}}\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell["Or find the integral from 0 to c.", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[First[v], c]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \(1\/2\ \((3\ c + 
          c\^2\/2 - \((\(-\(3\/2\)\) + c\/2)\)\ \@\(17 - 6\ c + c\^2\) - 
          4\ ArcSinh[\(\(-3\) + c\)\/\(2\ \@2\)])\)\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell["This finds the series expansion of the result.", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[%, {c, 0, 4}]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\((\(3\ \@17\)\/4 + 2\ ArcSinh[3\/\(2\ \@2\)])\), 
        "+", \(\((3\/2 - \@17\/2)\)\ c\), 
        "+", \(\((1\/4 + 3\/\(4\ \@17\))\)\ c\^2\), 
        "-", \(\(2\ c\^3\)\/\(51\ \@17\)\), 
        "-", \(\(3\ c\^4\)\/\(578\ \@17\)\), "+", 
        InterpretationBox[\(O[c]\^5\),
          SeriesData[ c, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ c, 0, {
        Plus[ 
          Times[ 
            Rational[ 3, 4], 
            Power[ 17, 
              Rational[ 1, 2]]], 
          Times[ 2, 
            ArcSinh[ 
              Times[ 
                Rational[ 3, 2], 
                Power[ 2, 
                  Rational[ -1, 2]]]]]], 
        Plus[ 
          Rational[ 3, 2], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 17, 
              Rational[ 1, 2]]]], 
        Plus[ 
          Rational[ 1, 4], 
          Times[ 
            Rational[ 3, 4], 
            Power[ 17, 
              Rational[ -1, 2]]]], 
        Times[ 
          Rational[ -2, 51], 
          Power[ 17, 
            Rational[ -1, 2]]], 
        Times[ 
          Rational[ -3, 578], 
          Power[ 17, 
            Rational[ -1, 2]]]}, 0, 5, 1],
      Editable->False]], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell["This searches numerically for a root.", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[%% == 1 + c^2, {c, 1}]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \({c \[Rule] 2.1431382898458553`}\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell["\<\
Being able to work with formulas is also important in summarizing \
data.\
\>", "Subsubsection",
  CellTags->"T.5"],

Cell["This generates a table of the first 20 primes.", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Prime[i], {i, 20}]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \({2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 
      67, 71}\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Fit", "MB"],
  " produces an approximate formula."
}], "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fit[%, {Log[x], x, x\^2}, x]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \(3.555586234406268`\ x + 0.04037061342157253`\ x\^2 - 
      5.222555061877685`\ Log[x]\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell["\<\
This computes the sum of the first 20 primes using the approximate \
formula.\
\>", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sum[%, {x, 1, 20}]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \(641.4366817004093`\)], "Output",
  CellTags->"T.5"]
}, Open  ]],

Cell["Here is the exact result.", "Commentary",
  CellTags->"T.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sum[Prime[i], {i, 1, 20}]\)], "Input",
  CellTags->"T.5"],

Cell[BoxData[
    \(639\)], "Output",
  CellTags->"T.5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Handling Data", "Section",
  CellTags->"T.6"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lets you import data in any format, then manipulate it using powerful and \
flexible functions."
}], "Subsection",
  CellTags->"T.6"],

Cell[TextData[{
  "Click ",
  ButtonBox["here",
    ButtonFunction:>SetDirectory[ 
        ToFileName[ {$TopDirectory, "Documentation", "English", "Demos", 
          "DataFiles"}]],
    ButtonEvaluator->Automatic,
    Active->True,
    ButtonStyle->"Hyperlink"],
  " to change to the directory that contains the data files used in this",
  " ",
  "section."
}], "Commentary",
  CellTags->"T.6"],

Cell["This reads image data from a file.", "Commentary",
  CellTags->"T.6"],

Cell[BoxData[
    \(\(data = Import["\<image.dat\>"];\)\)], "InputOnly",
  CellTags->"T.6"],

Cell["This visualizes the data as a density plot.", "Commentary",
  CellTags->"T.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[data, Mesh \[Rule] False, 
      FrameTicks \[Rule] None]\)], "Input",
  CellTags->"T.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00961538 0.0192308 0.0102291 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
100 string
100 94 8 [100 0 0 94 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
2217281517241B1B1B2236585D5850534E535A5C5C5757706D7A84857F6B63666D5A4146
4646382A150D070703030303110B0B0B031711151B1B24242833333C424138382D313342
454C6464574E45464E4E5551555E6D575D6263755D4C535C5A4C4636
2424221B1B24222A221B385D4C4C514E46464166766D5C616C53536280887568504C4641
3C3828220B030703070303071117110D242D362A332D3133363633282D22242822221B17
1B315742453338574549464C585E53505C5357585361504C51515350
222A2A2417171B221B22465345494C4C3F454946556266465763705C57687461624C423B
4233220B07030003030B0B070733241B3F453F50513F423B3338362833241B1B17151111
111B281B413F46413F3B3C3C494242414E5155775E51585C51453836
223322281B1B22241B2A51534E46504E5049424957536B74645A68716B637C6468635D49
28220D0303030B0303070D0D171B2D2A283F5A58422D282A2824282A2A22221B15110B0B
0B0B0D2231454636313631363B42495C6B61535A51514C49452A332D
1B17221B1115172217384E534942413F503F4550495A4E4E6358666C777C687271855C55
2415030307070B0D150B0B1B22333C36312A36383B413C363624221B22171B24150B0B07
0703030B112A332A2D332433384151463C38363C50503F3F312A3838
15171124150D1B242238493C3C3B3F3F38494C533F4951535E6262635A717781816C5D3C
1B07070D0D0D070B0B24244651756D70794E3F495E86778170514133221515110B0B0303
0703030307111B24222A1B2431313631383338422A2D2A2D38363C2D
221B1511171B1B28244650364236383B5050513C4955465049535C635A706C636C75572A
11030B07030B0711152D5364818F8A81765045455D79918D8D7766553622150D110B0703
0703030303070B172A282231222D31333B332D282D3B4136383F3B38
171722152415221B173C413C333336465C4C574946534C535163759BA77C7785643F2811
0B070B150D1B2A36497C8D91B6B1BBB87E4C174980A29E97AAA6967F55494124170D0707
0703000303070715112D312422242828313F4C493B49463C3C36312D
221517151517172228363B382D2D3B50463F463C495A5758585C6B7280977C846336170B
070D0711283B517297A6BAB3D2DDFAE07C220D0D4EACC7CCD1BA9D9B856846362822150B
070303030703030B22222D2D151B1B171B1B2428172A33333336363B
2A171722171B1524223B4C4131415050425849534E42515C586D706655645E513F150B0B
070B0D243C5E6C96B3C4D8D6E2E8D1661B0B07070D3B94C5D0C4968B7E715C503F242811
0B0B0300070300030B070B11221B150D0D17152222171B222D2A2424
150D15151B1B221B2250383841423F493B36364E415058515357616264615733150D0307
070D225072858FB3BBC8D7D8DDD08B220D03070B0B22589CC3C8AE928076726446363122
11110D070303030003070D172417150D11221B1B22171B2D2D282D2D
1B1B2411151B2424223638363C41424E574C4C414141415A6D5C667563311B0D07030B07
222A38557596ACA8A3CBD0D8C47C420B0D0B0B0B0711417597B8ACACB3857A7C64573F33
33150B030307070000030303030707070B172228221B2A28241B241B
17221B1B1B2A1511283F3B334C51425141413F3B455566636B6355422D220D070B0D0D15
2D425E6498A6A69EB4D1DFBD7F2411110D2811110D0B0738688497CDB5A18F8862666257
3C241517150D0707150B110B03030303070D111B1B1B2A2D311B2431
1717151111171517283838383C3F424145414246454E5350614C3624152D33221728151B
3F636C618DA2CCD8D2DCD0A036171722172222171711110D2A7293BBC4CEBAB39B775E57
583F2A1B0B07070B1B17171B070303030003070B0B1515151715151B
2217151115221522283B3B3C4146454553413B4E3F413C3B2D241B112D50573C24222231
4E626D8EC2C0C9D8DDE2C9812A1B17364955553C281B17111B6C91A3BAD5D1CBBBAB9D53
515742170D070B0B112831332A110B030303030707111522221B2224
15171717151B15111731333649423C3F3F41383C453C3124170B0D113B72573311151B58
63617C91C3C5C5DAE4D5B9A65531386D86869186684E362D53888DA5A8D5D2C293A28A71
50333B3822110B0B172A383F41573B1507030003030711171B38362D
15111722111B17111B28312A413B45453C3B382D3324221111285A68614638221738505E
6D8577719CD2D6D6E1D5B9D2767784AC9DABA6A8AB7C5A5563C7A69CB4D0C2AA9E81645E
6C53383B4628150B0D1B314255464945220D07030303070B11221B15
1115170D172222171736424236333F454238312217110D0D3341795E41362A2A2D515861
667270A0DBE0C4D0E0E0D2BA9286A7AEA5B9AEA8BA988A716BAEBEC9B5C8B8AEC8BE9166
6C68574250411B110D1B2D31414E4C4E45311107070B070B111B171B
171B1B0D151B221522313B42424246383B3322150D0D0D2253575842382A17243C454257
555588A5D6D7B8D5EBE4DBAB969CA1AAB3B3B4B3B6A28E74687FC9E2D6CDBA9EB8BAAB80
5851575A382D1B0D0D173145384C6C685A4E2D1507030307111B1B28
15111711111717151B38453F383C3C383138221B171741776C463331281B1B28385C6C75
5C7E9BA6B39CACD6F0D1A2868F9EB9C4C2B4B4BBB3A6A07F6C5A89CBC0C4B3B1B4A7989C
7C58716D55332D220B15222838413B4C5A625E531B07070707111522
1B171517222224171B3133383C3838362D1B17112445585C583F3B281515224662767F6D
717697A898ABBED3D7A68863A3C0C3C7D2CDE0C4B9B9B5A66B5862869CB3A8A2ACAA9C85
84745E63795D42311B1715222D3C3F364C5E746D502A17070B0B0D15
22171715151511151B363B33414138332824171B49706B453C2A17150D11222D455D7063
6D7988A5B5B4C3C7B397896D9DBBD5D8E5EFF3E9C9D2C7A8755D707C91A59DBFB59D8571
615053423F535D4C1B0D0D151B313C45382D3C5C5E513C1107070B11
171B2217151111152431423C382D382A1B1722466B513C2D1711150D0B0B1B2D5068758F
7C8EA1B8BAB3BDCDAEA08B79AECCEEF0F4EFF4EFE5EDD5C08A66718088938D92ACA59484
68686D5E55382D2A220D0B070D24313B3C3B3B4249453C110703070D
150D0D0B1117150D22383C36312D2A1B1B315563493C3C2A110B0D0D2A42506271748F9C
A5A8ABBDBBACC4BAAB947970B9DFF2F3EDFCF4F3F5F5F7E0936B717079948A98ACC0BAA6
967F6D7761493C33110B0D0D0B0717363F46503F314242330D070307
0D0D0D0B0B1B2217152D333F382D2D1B223142505C3F2D150D0D0D1B416375809198A1AE
B4AAB4A3B8BDB39B9B916D63C9E1FAF2E6F8FFEDF5FEF5E49B6D556B899C88A3A1AAB3A6
A198847168574E453B2D110B03030B0D36364E665746424E280B070B
150D15111511150D172433382D1B1B17244946463117110B1B242D3C636C6B53669D97A2
AAC4CEC7BFC2B0A78F7E757FB6F0E6FFEDEDE8EDEAF0EDE5AE856C628A9276847A849DAC
A69E8D8E89867E664C3F33110D0703030B2D45415A66585A4E280B03
11110D110D1115111B28313331243C173B51502D110B0B1131707C7C7570646D61718D96
B3C9D0C4BD9B8FA1966D8696BAD3E9F5DBAACCEBEDE5E0DB9E8F7E6B7079756B778E8B7E
918D8A7C645C5A6B5850513B1707070B030B173F424C616149311103
15111115110D0D11242D3133241B222D454636110D15153B618E7E72645564635D638191
9CAEB4BD97AA748B806486B0A7C0E5F5C489B9EEF4EDD5CEA88F7C6C797E70776C8A8484
8B757779705E5D6162505551360B030303070B1133454C3C5A3F2207
110D150D1B17151122312D2D24221B414936240D0D28537674897F757572626372707993
98929C9D978885867561729CB3A8CDD59385B5E6EDE0C4AEA08E7258558D7A775E8A7F8D
848563707A777972615555534E4522030303030B15314C5750493311
1128170D1111171517282A2A28222D454E2D15153666759286768D858F7E75807E88AAA2
A08E9C8A91887E8D806172989DA6A5AAA1A1B3C0DFCDB3A19C927057497A727A63889286
7C8A805D5C5E6D717761554E4C4241310B0303071138333C625C452D
150D0D111111171117282A282A33415D422422385E7A848885758D8B8889848080A7ACC5
B9AEACAC91A58D93798076A297AA938991978A84A0A397B4A68881625771728170949B8D
898A8B7C797781797C766C5D5C575D53420D070307172D3C36414E3B
15110D0D110D151117172428242A4C4C31364C636D777A747080989E977A7FA68EC0BBD0
DAC4D0AA8B755161708F9BA69DA08F9B93817479858E94AA98928E7A53748D807CA6A69B
A68B949D91977F978E7672765A535A5542311503070B1B38453B423B
170D0D150B11171111242A2424334236384255637C70745D5168808D98A39CA0D6B5C0CB
C2D3DDB37971415E799B9C9496A38A8879796B748198989696A19C9264496B4557A7B4A2
B3A7B3B19693947C88705D715A515A5045333B17070B0D1B2D464546
0D22110D0D1111110D171B2424383F3F4C6C808072504E535050708FA2BDC3C5BEB1AEAB
B5AAABA88A66587297A891848497857572636C7E6C80848A928FA58D6D4C53516BA3A8A1
ACA091A3B3A39D91808A6C66776B554C453C3C45110B0B0D24364555
1111110D0B0D1515111B282A2A3F36425D88896C62453C514E58779DC2D2C7988A818985
8188847962585A74A1A5936D707A7466625A515E68647280799BB39D7F624E7476807C80
8679758A93A6A2A7796D6D6C764C3F33384250533F110D0D0B17223B
17110B0D0D0D0D1511111B1B36453338717F6D555D49504C506689C9DBC3A68E745E5C5D
61766D624E38557F9E9B8D6B63625D5C5553495E63575E72778692A2895C425A63645E5E
64625C6D71758D98968976666D554238453B36333C240D0D15111B38
11110D0D0D0B0B0B0B111517384141417A755E62554645456C8B8FD2BD9374494246575E
50332A24312253929D89725C575551515046535E5862586D6C7480989D64421B28414C51
45464E49535A68778BA3927A614C45424146503C2D2217111111112A
0D0D0D0D0D0B0B07070B0D24383346586B79725D5145455E6497C5BB7F5D7F869398A3D0
EED03C073333588F8A755742454E503F495E535A5C55575D5366889298714C0B17111B1B
2A3F3B3B2A2D3C5870868D97776B5849362A31362D3B2A1517171B24
0D110B0B0B0B110D111115313B4C42687566616158615A797FB4BD7045B5B67C31152D9C
E0AE450715507685725E53413F424242505C574C535A4E4C53687E8EA08B4E11110B0B64
C5E0DDBBA77F42314571848E9164705A362D362D3131241717171B17
070D110B0B0B0B0B0B110D2A4958466D6D6151665158748BA0AC864698B3751707030322
6D3615283C727074625A46423B46414249514C49423F4E4250636B768E7E581B030317B3
DCC7A58896B3C5862D4C6C7F8975667450383C2D243B241517151115
030B0D110B0B07030B113342705D4E5E5D58585551587C84A58B45628D460D030003070D
1533424E5D6D6D5A533C463149423B4C3F5A554255423F33423F5C646C62663F15030741
A68B5115156493D0AC42457E93887A615A4E3C383F312422222D2422
070307110B0B0B0B0D22313C5D5A5775624E504E5C718B8F8B3F316342110303070D1531
4C5A585D5A494C383F2D31313F3F3F4E4945554957554E3B333B505055625A4C3C2D170D
1522070300032A8BC0A84153A692855C4E515736362D2A22242A2A2A
0300000B0B0B0B070B0B223F4C5168625C57515077919289713B425D332A223C556D5A62
4C51424E513C382D312D423B3C3B364E3F4157424549534531413F3B534E4953574E5331
150B070303030031637A773676A2A3867653383C31362D2424242D2A
070303030D0D0707070D1745514C626858574951687184885C3F49493838386264706B5C
533B42493F382D2D2A2D3631503C38533B3B57503850464146413C313F494E424945575A
42332211110B0311495A6B41507A898A846149422D2A2A2A1B222431
030300000B0B0B070B152D555151685D716C706651585157504141585D89726661646674
5E535E5041382D2D243B33463F3C58625E574E493F5150514241363C333C49463C3B455C
575E53573822172436505D683F768A7E715D423B362D3C241B112231
03000300030D070B152A3B58585A665E514957666C49413849556B77856C6B5D49636874
7463575149422A3128313F41464E4C645D53453C53555A4545383328362A364E4E494E50
5758615E5C534938313346462441534C61585C53382A332D15172224
0300000000030D0D113B5C635C5C6262635A61635C71534E505D6679765D5A6855516363
6157556B4C4E332D46413F5141454C6461505A5E586B5D45423336383624314546585E55
5E5C555A5A63626D7A5E4E3C3B41515866684E3C413B3B3317171B28
0300030000000B07113F645E626471615E6361716B574E5C775E63585C4C505C58616264
555871754646333F4149464646414162635A616155716C4642312D2D3F2D364255515E6B
625546534E5A5E57575A504C465049555A5A50413B383F3317171B2D
030000000003071117505C55515C6153576C4C465A5E5A5D4C645768504E4E4558708484
635E637C5A453836363B49464C424E4E644C6249515A4241453336383C3B3F45644C505E
685C5345504249464C534E5855494938363C4E4149463C31221B2228
03000000000307152D495349504C4E3F4E5E5E57586D71725E5862535055586457617561
5770817053533B4146313645554E5051645C5E455757493F382A4141453846506D574553
6258505E504641493F534C3F4650464C424C53414946413B2D222428
0000000000030311424E464957504650505D575D687476585A55615D45506B635A5C6B74
64638471614955464141333F4E6B515A647272635A49464E453B38423C3C4E58705C4C46
5D51423B383F41383B363B464249414E515A5149493B49423324242D
0000000000030724495758575A585155555E4151536471706B5D57584E50535761747F77
646B7F7958555D4E3F453F4155705E515E6C5866515E4553464E454E42455D646868625D
5D585D4C333C3B3C42423C4C3C4C4C55553C3B414645504E4631172A
0000000000030738515D6C554C5550535A626361648479716861625E58464150585E757F
617479815C5158504E4E3F4257555C576B7C6163756353453C46423C42505353775A6368
715E62554C3C383850413F3F423C3F42413B3F4650514C4541453115
0000000000030B465E62705C505A5A585A4249585E71845D5D51414C5772645A575A859B
6C8888776B4E645342583F586C61706D5E75766B866D5041464242383F503B456D624E4C
58504C4649383633383B3F424E494246455A514942463F414536333C
000000000307224E6B555A57536151493F42464E5E57554C4258424E5A66585A63808F8A
7568635D5E667264515E665E756D728E706C86616B755E50424C3F3C4E465545616C5751
51534C4C4E3B3F3C2D2A36453638413C3C364645413C4E3C49464C41
03000000000D42554E5D554C535A453F4936363C42504C4C42494C464C534E5D74A09672
5D574C495A64636158575E71666664817C7FA16C55636257495150424949553F58505C5A
6D4C4E57585A413F382D31362A2A2D383C312D332D38413C42495149
0000000003113C50585842423C5042384242465055495061505557454541618A84857E6B
464C3C42495357645771635A685C7175818497725A6D6361385D455C455851454C4C5A51
615C464551505C5042363636242D312D33425041494C363831363B33
0003000003335D5A4E5145423C3C33313B46495D5D464C5E55454E55575758757F71634C
463F3841415E4C4C5D5D575E7571967F98968F8A647F7C6D575E5D57554C53414E505357
4E4E61495045424C3838383B4238414245423C3B333B45494E414141
00000003073C6B645E70715749493138383B3F423F41464E5350585E535A6C7971614E3F
463136424C585C61585A5D6286719B9D8AB0A59D7E7276625E575D63585155423F49364C
3F515E464657493C36362D363B3B3C3C313338312D3C363C45413C33
000000030B45726C6D5D57533C313B36423641493F383C383642455050647172665C3842
33383F4145495E7A6164716476819CAA8E9CAEA186807A61725E6B6D5D5D4E463F3C3338
31384C4C4C5755463B31382D33242D382D2D2D33383F423B36242D33
0000000717626C5C5350513F334C45464C5351494C36463638465751536166666D5D423F
333336382A4555868E6270808D98A0B49CA38AA2AB86746B8A7E7275685A4E4541382233
383C383C3B4150413F3B3F312A221B22382824282D3133333B362433
00000307225C5D514E423B464541414E553F3F41333F3F3F3C424C5E49495558515A503C
3136313B454C517492798B7784ACB1B397949E8BAB8D777E807C8F7A5D50614C3B331B33
3B42333F3B3C4C3B2A31313B2436222822332D282A283138383B4631
0000030B113F62583C41453B333B3F3F3828312D333C3141413641534C4C414E414E533F
2A33464538385A5E94B8BE8676A093968F89977FA688889684898E806C5D613C31313133
3F3B2A2D3C313B3B2428222D242A22281B22222428222838363B3B42
000300030D24505546423831413F3C3F3631384E3C363B332D2D31464E4C41503B4C4E3B
3C33314C3841466B81B5C7937092796C8E809281948B769BACA6948A7757553F3341313C
2D313838332D3C2D282222151717221724171B241B222815282D312D
030007030B173B51423C3628242D242A3B333C4C36312D31311B1736383B464631454131
412D2836415151648188A1966B797E7E8E8B8D7E8F88858AA0B08F8B795842493B3F3B36
2D3F49362D2D2D312A152222171517171715172A2D22282D41423633
0000070303071138423B311B1117242438313C33282D2836311B2A3C382D412D362D3328
28312D2A2D38514C886B867E66929391718F8986849E8D758B9C967C765149463C463633
3F41463824282D2217241717111B15172211151B312828333F3B3133
0300030003070B28455141332828282D2A31382A2A242D312A2428313628332A33312A24
2D332D2A362A38617277807E53807F986C77817C7E929C9C79A092815A494E4C3F3B3136
332D282822222A17171B1B1B1B1111110D1B15111724242433333B33
00030303030707113C505042313B31222A283336221B17222A2417222A282D2D3C363624
313F363B38414157728B85865D6D7A8F5D5779778D799385948A8F6B6251456358363F3B
2A282422242A3324173617221B1515150D0B1511111528242D242831
0707030003030707244651553F221B1B28242D2215171B241B171B1B1B1528362A363828
2D2445453F4E515553777194556B728A46587A7A84718474A36D7C615D5D5163422D313F
382A2A22282A2415171715221117110B0D0D0B1717151B1115282824
000300030303070D153B38312A33281B17171B2A221B2A333628242224282A33313F3131
382A284E36454E4268515E88586C7184515179745E76706D8F7A63615A554E50363C3841
3633312A33222415171B1711110D0D0D0B17170D0B1B151B150D242A
030D0003030303070B363F423F282D2D31332424242A2A2822222238312228332D1B282D
3F452D3B38425E4C5D766B85715E6181494672745E5C5D68777A6664515558423C46333F
362D2A2A28241B2422172211110D0D0B0B0B11220B0B112822170D17
03030303030303070B3651493C2D2D2A333B2A1B2D2D28241B2424332824282A2A1B1B38
453F36312A38535E576D7F8E667158755D626D66555861617470685C4E5A46363F3F334E
28242A24221B172A1B17150D1111110D070B0B0D150B0B111B151517
0303000303070707112A493831383F2A333B332D2824221B282215151B24282A31222236
413338313B3B455764668681716C6D585C6655554949685A7974755E583C413B58312A38
31222D2D22151B3322110D110D0D0B0B07030D0D0D070D0B150D1111
070003030303030B172A383C2D333338533C2A242D1B17171115150D1117242436282238
3F2D42493B515D6C796C629C9750504961635E415363625A868586685C4941413B24223C
2D1B2828171B1724170D0B110B150D110D0D070B0D07070B0B11241B
0B0303000303030B2250493F332A423636423F3F282D2A282224170D2415221B2222242D
494E4C4E3850666871857975915D3C61636C6636465D635C85646D7E664E455531282433
2A2228222415110D150B0D0B110B0D110D0D0B0D0B0D110B170B0B11
070303030303070D454C4145362D362A332D243831282424150D151B15221B1B222A2836
3C414C50584150576693947E895E417068855C414C5C5157796364766846363C33313822
1724241B221B1115110D0D070B0B0B030B030B0D0D17151B11110B0D
0303030303030336614E45575351515036362D33361B17110D171B1B171522282A36333C
3B4142625161625D64868E758B6B4C6164815338585C4258646C6D6C62553831332D281B
172A24152417110D0B0D0B0B07070B07070B030B0D17242D2A2A1717
0303030303030D577251575D66714E4131334131221B281B171717151B1517242D28384C
51494951516D6B86817E7F8172534E5E647042496B573F4C5C817C6D5C4E4942312D242D
28221B1B1B221B150D0B0D0D07070B07070D110D0D15172A17242838
00030303030D22535A453F5C575C503F2A453B17222422110D0D1711112217243B313C42
494251504E7E7F8996795C8A61623F6D715A425D6C4536515C89818B5D46503B41513331
282A222A24222222220D0D0D0B110D0B0B0B0D11171B151B1715111B
03030003030B2A50453F464545382D31221B1B24170B07070B070B15112436333C453C45
53504E68648997A6A79262797664575170463651553349575E707C765D465E5041553B38
3336312D242A242224110B0D0B110D0D070D11171115150D070D1111
0303030307243F5C36282A24282D362D36221B170D07030707070D111B2A36413B533B3C
495A586C6D7F7EA7A69E705C846250425E463641423C415D5A66717A6C4E5C4C5A50413F
383633312D242422170D0B0B0B0B15070B0D2211241B150D0D0B0D11
03030303112A4262383150312D2A2A221515150D0B07070303070D223342383B42503B42
4263667277847072A27C5E536855463342332D3F3C334C685363747275646250635D4145
413F413831332D281B150B07070D110B070D1517281B221722281B17
00000303152A3133222A28362831311711110B1107030703070B15283C463F4C51454642
4674616C758A7E6D867F5D46505E4631362824282A3157664E4679777C7F665D705D5149
58464C4C4C333833282A171107070B0B0B070D0D1B2A333836363136
0703030D15172A28242A38311B2A413C17110715070B0703030B1B3646454C5D50363F4C
5C6266617A766C808E7642503B53513B423122151B31625D64587A637A7770687C765349
61555A553F332428282A1B110B0303030307070B111B363C493B3B3B
0303070D281722222A1B24313F333C362D17110B07030707070D1B364557705D45425050
5C68775D70636479866C464E3C5A573F5053171B17425C57615E746371766B668076554C
53505546493B2A222D31240D0B070303030307070B0D113145555049
03070B173124241B22283838412A33281B2217110D0D0D0B0D172A3B467C745146616671
6D807A58536B6B6B8A413C41384C614951753324173846515C53517561666B63817E624C
5853503C3C313B2A2A332D171107030307030703070B0B112A2D333B
030B0B0D171B1B17151B31333C3C3B28150D0D0B0B07070B243F4E5172645A5064757177
8E6375746C796B688F4C3C3C384150385A8F3F2A223C313F493B3F666650585C7F7A645D
74645741382A38333331281B220D070303000307030B0D0D15172817
0303071B462A24222D313F46464C3B24241711110B070B1541624942465E686C668A8B86
A0807A7574685C6180503C3F4655413B5D6C3B2436513F313338495A5857615377666671
6D585A453F222A28312A361B28150D030303070707070B070D15221B
00030B17492D2222223C463B2D241B221B110B0D0D0711385557332D3C6D708984949193
968070757461516262463C464C5E513B4C4C422A3842312D363846585550644C7F705D71
81585E50462822242D3B312D22151507000003030303070D17222817
030711453C2D1B1B2238495C583B332417110B070D113151423B38335E70668B96978188
977C745E615E555E5A50425A63726C423B533C3633363F2A3641503855575A5874586176
86685D6B50383641332D3F362817170300000003070B0D1B17152422
03000D5836172422313C4942332A2815170D0D0B0D3F4241514541426B7F8BA0A3A2918A
927557454C625A664C5546515776644E3C423F283C2D3B2D4136454C5A554C556170637C
7F72667C5C464C4E533C3F5036222A110703070303070B1111171724
03071B45172228363F4C4E4C362811150B0B0D114245455558494C5E849196B1A59C9896
9C76534950725D5C4E4245615A9375585745332842364E363341514C5549493B5C616262
6D616274615C5E61614C3C3B5833241B0B00030307070707151B1515
030B3B222D3B3C45413F413F3B22150D0B0B113C453C5D6C556B628A8E9DA2A68686919C
B9975A50557063553F453F5E5780704661463633382D423F2A4542494641493B50556172
6C625E716B6C636C664C3F312D422D170D0303030307070D11111111
0338462424333C3B3F4C3C3B24110D0B07223F4C414C6676687A88A2A6949EA08F8479A1
ACA7745C496C63514E3C3B514E72623B423C31382D36534138313641382D3F453C4E6184
8574625D766C816C66553B3B2D2A3F38170D0B0707070D11151B220D
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{225.562, 225.562},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003Q0000hB000`400?l00000o`00003ohOl00000
0003o`000?oooooooooo0=gooooo0Ol000000003o`000?oooooooooo0=gooooo0Ol000000003o`00
0?oooooooooo0=gooooo0Ol000000003o`000?oooooooooo0=gooooo0Ol000000004o`000?oooooo
ooooooooo`808R8R0P0G5aL202PX:0<05ADE0P0G5aL202@T90H06a/K0`0R8R8203Hf=P80F5QH0P1M
GEd205QHF080D51@0`1CDe<204i>CP80De=C0P1JFUX405aLG0D0EeMG0P1`L70206e]K@80NWYj0P24
Q8@208F5Q@<0Ogmo0P1[Jf/206=SH`80IVIV0P1]KFd205YJFP<0@D511P16ATH203Ph>080:RXZ0`0E
5AD200d=3@@01`L72@030`<2014A4@H02`/;0P030`<301LG5`804A4A0P0E5AD401/K6`D092@T0P0X
:2P403<c<`80?3`l0P12@T830451@@@0>3Ph0P0];Bd2034a<@80<c<c0`12@T8204E5A@80C4a<101T
I6@205MGE`80CTi>0`15ADD204I6AP@0CTi>0P1EEED2055AD@<0EEEE0P1NGUh206e]K@80EeMG0P1M
GEd2069RHP<0Hf=S0P1eMGD205eMG@80C4a<0P1CDe<205aLG0<0FUYJ0P1<C4`204I6AP80=SHf1?oo
ool1o`00000000Co0000oooooooooooooooo0P0R8R8201LG5`80:2PX0`0E5AD201LG5`8092@T1P0K
6a/3028R8P80=SHf0P1HF5P205eMG@80F5QH0P1@D50305=CD`80CTi>0P1CDe<205YJFP@0G5aL1@1G
EeL2071`L080KFe]0P1jNWX208B4Q080QHF50`1oOgl206][J`80Hf=S0P1VIVH206e]K@80FUYJ0`11
@D4604I6AP80>3Ph0P0Z:RX301DE5@803@d=10071`L900<30`804A4A1P0;2`/200<30`<05aLG0P0A
4A4201DE5@@06a/K1@0T92@202PX:0@0<c<c0P0l?3`20492@P<0@D51100h>3P202d];@80<C4a0P0c
<c<30492@P80ADE50P1<C4`406ATI080EeMG0P1>CTh304E5A@80ATI6101>CTh205EEE@80DE5A0`1E
EED205iNGP80KFe]0P1GEeL205eMG@80HV9R0`1SHf<207EeM@80GEeM0P1<C4`205=CD`80G5aL0`1J
FUX204a<C080ATI60P0f=SH4ooooo`7o000000001?l0003oooooooooooooool402@T90808R8R1@0K
6a/202@T90808R8R0P0Z:RX2028R8P<06a/K0P0h>3P205eMG@@0C4a<0P1ADE4304i>CP@0ATI60P11
@D4206IVIP80MWIf0`1]KFd205aLG080HF5Q0P1/K6`405=CD`80HV9R0`20P80208R8R080MGEe0P1X
J6P2051@D080C4a<0`16ATH20451@@80?3`l0P0h>3P202PX:0808R8R0`0;2`/200<30`801`L70P03
0`<200L71`D00`<30P071`L2014A4@805aLG0P0A4A4200d=3@8092@T0`0];Bd203Hf=P80:RXZ0P0c
<c<202d];@80<C4a0`0c<c<403Hf=P80<c<c0P0X:2P202d];@<08R8R0P0T92@202PX:0@08R8R0P0K
6a/301LG5`806a/K0P0a<C4205MGE`80@T920P15ADD203<c<`<0>3Ph0P1GEeL204E5A@80BDU90P16
ATH204a<C0<0F5QH0P1NGUh205=CD`80D51@0P1LG5`205=CD`<0EeMG0P1HF5P205=CD`80HF5Q0P1@
D50204a<C0D0DE5A0P1CDe<2051@D0Cooooo0Ol000000004o`000?ooooooooooooooo`@092@T0P0R
8R8501/K6`8092@T0P0R8R8202XZ:P808R8R0`0K6a/203Ph>080GEeM101<C4`2055AD@<0CTi>1016
ATH20451@@80IVIV0P1fMWH306e]K@80G5aL0P1QHF4206a/K0@0De=C0P1RHV830820P080R8R80P1e
MGD206QXJ080D51@0P1<C4`304I6AP80@D510P0l?3`203Ph>080:2PX0P0R8R8300/;2`800`<30P07
1`L200<30`801`L71@030`<200L71`804A4A0P0G5aL2014A4@803@d=0P0T92@302d];@80=SHf0P0Z
:RX203<c<`80;Bd]0P0a<C4303<c<`@0=SHf0P0c<c<202PX:080;Bd]0`0R8R8202@T9080:2PX100R
8R8201/K6`<05aLG0P0K6a/2034a<@80EeMG0P12@T8204E5A@80<c<c0`0h>3P205MGE`80ADE50P19
BDT204I6AP80C4a<0`1HF5P205iNGP80De=C0P1@D50205aLG080De=C0`1GEeL205QHF080De=C0P1Q
HF42051@D080C4a<1@1ADE4205=CD`80D51@1?ooool1o`00000000Co0000oooooooooooooooo100T
92@2028R8PD06a/K0P0T92@2028R8P80:RXZ0P0R8R8301/K6`80>3Ph0P1MGEd404a<C080DE5A0`1>
CTh404I6AP80@D510P1VIVH207IfMP<0KFe]0P1LG5`2065QH@80K6a/101CDe<2069RHP<0P8200P28
R8P207EeM@80J6QX0P1@D50204a<C0<0ATI60P11@D4203`l?080>3Ph0P0X:2P2028R8P<02`/;0P03
0`<200L71`800`<30P071`L500<30`801`L70P0A4A4201LG5`804A4A0P0=3@d202@T90<0;Bd]0P0f
=SH202XZ:P80<c<c0P0];Bd2034a<@<0<c<c100f=SH203<c<`80:2PX0P0];Bd3028R8P8092@T0P0X
:2P4028R8P806a/K0`0G5aL201/K6`80<C4a0P1GEeL20492@P80ADE50P0c<c<303Ph>080EeMG0P15
ADD204U9B@80ATI60P1<C4`305QHF080GUiN0P1CDe<2051@D080G5aL0P1CDe<305MGE`80F5QH0P1C
De<2065QH@80D51@0P1<C4`5055AD@80De=C0P1@D504ooooo`7o000000001?l0003ooooooooooooo
ool2028R8P@0:RXZ0`0T92@401LG5`806a/K0P0R8R8201/K6`<08R8R0P16ATH205=CD`80ADE50P19
BDT504a<C080?clo0P15ADD204U9B@80ATI60P1EEED3069RHP80IVIV0P16ATH205MGE`80Hf=S0P1`
L70205aLG0<0EeMG0P1XJ6P207AdM080HF5Q0P1RHV8204a<C0<0@T920P0k>c/20492@P80<c<c0P0R
8R8200/;2`<01`L70P030`<2000000@00`<31@0;2`/400L71`80<c<c0P0T92@201/K6`80?clo0`15
ADD203lo?`80D51@0P1ADE4203lo?`80@T920`0k>c/203<c<`80>3Ph0P0f=SH202PX:080<c<c0`0T
92@401/K6`805aLG0P0E5AD7014A4@806a/K0P0X:2P201/K6`80@D510P0o?cl304I6AP80@D510P0o
?cl203/k>`@0?3`l0`19BDT40492@P80@D510P1>CTh2055AD@<0EEEE0P1gMgL205iNGP80DE5A0P1H
F5P205aLG0<0DE5A0P15ADD203Ph>080=SHf1?ooool1o`00000000Co0000oooooooooooooooo0P0R
8R8402XZ:P<092@T100G5aL201/K6`808R8R0P0K6a/3028R8P80ATI60P1CDe<204E5A@80BDU91@1<
C4`203lo?`80ADE50P19BDT204I6AP80EEEE0`1RHV8206IVIP80ATI60P1GEeL206=SH`80L71`0P1L
G5`305MGE`80J6QX0P1dM7@2065QH@80HV9R0P1<C4`30492@P80>c/k0P12@T8203<c<`808R8R0P0;
2`/300L71`800`<30P00000400<30`D02`/;10071`L203<c<`8092@T0P0K6a/203lo?`<0ADE50P0o
?cl2051@D080DE5A0P0o?cl20492@P<0>c/k0P0c<c<203Ph>080=SHf0P0X:2P203<c<`<092@T100K
6a/201LG5`805ADE1`0A4A4201/K6`80:2PX0P0K6a/20451@@80?clo0`16ATH20451@@80?clo0P0k
>c/403`l?0<0BDU91012@T820451@@80CTi>0P1ADE4305EEE@80MgMg0P1NGUh2055AD@80F5QH0P1L
G5`3055AD@80ADE50P0h>3P203Hf=PCooooo0Ol000000004o`000?ooooooooooooooo`808R8R0P0c
<c<2028R8P<0:2PX100K6a/2028R8P8092@T0P0K6a/302XZ:P80DE5A0P1CDe<204i>CP80ATI60P1@
D50304i>CP80D51@0P19BDT20492@P80BDU90P1GEeL305=CD`80Jf][0P1dM7@206ATI080FUYJ0P1X
J6P2075aL@<0Jf][0P1SHf<207alO080I6AT0P1XJ6P206=SH`<0GEeM0P19BDT202PX:0808R8R0P0=
3@d700<30`802`/;10030`<200L71`D03@d=0P0G5aL201/K6`80;Bd]0P0Z:RX202PX:0<0?clo0P1J
FUX205QHF080@T920P0];Bd202PX:0<0:RXZ0P0X:2P202@T9080:2PX100Z:RX5028R8P806a/K0P0E
5AD2014A4@T02`/;0P0=3@d2028R8P80<C4a0P15ADD304I6AP80=SHf0P0a<C4203Hf=P80<C4a0P0f
=SH303/k>`80@T920P19BDT205aLG080Jf][0P1QHF4305=CD`80FUYJ101ADE4204a<C080BDU90`15
ADD202XZ:P80<c<c0P0];Bd4ooooo`7o000000001?l0003oooooooooooooool2028R8P80<c<c0P0R
8R8302PX:0@06a/K0P0R8R8202@T90806a/K0`0Z:RX2055AD@80De=C0P1>CTh204I6AP80D51@0`1>
CTh2051@D080BDU90P12@T8204U9B@80EeMG0`1CDe<206][J`80M7Ad0P1TI6@205YJFP80J6QX0P1a
LG4306][J`80Hf=S0P1lO7`206ATI080J6QX0P1SHf<305eMG@80BDU90P0X:2P2028R8P803@d=1`03
0`<200/;2`@00`<30P071`L500d=3@805aLG0P0K6a/202d];@80:RXZ0P0X:2P303lo?`80FUYJ0P1H
F5P20492@P80;Bd]0P0X:2P302XZ:P80:2PX0P0T92@202PX:0@0:RXZ1@0R8R8201/K6`805ADE0P0A
4A4900/;2`803@d=0P0R8R82034a<@80ADE50`16ATH203Hf=P80<C4a0P0f=SH2034a<@80=SHf0`0k
>c/20492@P80BDU90P1LG5`206][J`80HF5Q0`1CDe<205YJFP@0DE5A0P1<C4`204U9B@<0ADE50P0Z
:RX203<c<`80;Bd]1?ooool1o`00000000Co0000oooooooooooooooo0P0K6a/201LG5`808R8R0`0K
6a/2014A4@805ADE0P0G5aL2028R8P805aLG0`0h>3P204i>CP80De=C0P19BDT20492@P80@D510`0o
?cl2051@D080?clo0P15ADD2051@D080BDU90`1JFUX404i>CP80Hf=S0P1HF5P206IVIP80K6a/0`1g
MgL207alO080J6QX0P1bLW82075aL@80QHF50`1LG5`205EEE@8092@T0P0E5AD400<30`D01`L70P0;
2`/200d=3@805ADE1@0;2`/201/K6`808R8R0P0c<c<203`l?080=SHf0P0a<C4302XZ:P80=SHf0P0h
>3P203/k>`80@D510P0l?3`503Hf=P8092@T0P0R8R8201/K6`808R8R0`0G5aL201/K6`8092@T0P0E
5AD400/;2`D01`L710030`<200/;2`804A4A0P0Z:RX303<c<`80:RXZ0P0];Bd203<c<`8092@T0P0c
<c<303Ph>080@D510P1ADE4204I6AP80?3`l0P0h>3P303Hf=P80?3`l101@D50403lo?`<0<C4a0P0Z
:RX403Ph>0Cooooo0Ol000000004o`000?ooooooooooooooo`806a/K0P0G5aL2028R8P<06a/K0P0A
4A4201DE5@805aLG0P0R8R8201LG5`<0>3Ph0P1>CTh205=CD`80BDU90P12@T820451@@<0?clo0P1@
D50203lo?`80ADE50P1@D50204U9B@<0FUYJ101>CTh206=SH`80F5QH0P1VIVH206a/K0<0MgMg0P1l
O7`206QXJ080LW9b0P1aLG4208F5Q@<0G5aL0P1EEED202@T90805ADE10030`<500L71`802`/;0P0=
3@d201DE5@D02`/;0P0K6a/2028R8P80<c<c0P0l?3`203Hf=P80<C4a0`0Z:RX203Hf=P80>3Ph0P0k
>c/20451@@80?3`l1@0f=SH202@T90808R8R0P0K6a/2028R8P<05aLG0P0K6a/202@T90805ADE100;
2`/500L71`@00`<30P0;2`/2014A4@80:RXZ0`0c<c<202XZ:P80;Bd]0P0c<c<202@T9080<c<c0`0h
>3P20451@@80DE5A0P16ATH203`l?080>3Ph0`0f=SH203`l?0@0D51@100o?cl3034a<@80:RXZ100h
>3P4ooooo`7o000000001?l0003oooooooooooooool201DE5@805aLG0P0A4A4302@T90805ADE0P0=
3@d201/K6`8092@T0P0R8R8303Ph>080BDU9100l?3`203/k>`D0?clo0P0h>3P204U9B@80C4a<0P1C
De<203lo?`<0BDU90P1ADE4205=CD`80GUiN101RHV8206=SH`<0FUYJ0P1aLG4207MgM`@0PH610P1/
K6`305eMG@80?3`l0P0K6a/400L71`L03@d=0P071`L400/;2`D092@T0P16ATH2055AD@80MGEe0P1]
KFd2071`L080NGUi0`1>CTh203lo?`80BDU90P1NGUh208J6QP80MgMg0`21PH42071`L080DE5A0P11
@D4203<c<`808R8R1@0E5AD2014A4@@02`/;1@030`<200L71`H00`<30P071`L2014A4@<06a/K0P0T
92@2028R8P80:RXZ0P0K6a/202@T90D0<C4a0P0f=SH2034a<@80>3Ph0P0c<c<303Ph>080@T920P0Z
:RX202d];@80:RXZ0P0];Bd303Ph>080=SHf0P0l?3`202d];@Cooooo0Ol000000004o`000?oooooo
ooooooooo`805ADE0P0G5aL2014A4@<092@T0P0E5AD200d=3@806a/K0P0T92@2028R8P<0>3Ph0P19
BDT403`l?080>c/k1@0o?cl203Ph>080BDU90P1<C4`205=CD`80?clo0`19BDT2055AD@80De=C0P1N
GUh4069RHP80Hf=S0`1JFUX2075aL@80MgMg1021PH4206a/K0<0GEeM0P0l?3`201/K6`@01`L71`0=
3@d200L71`@02`/;1@0T92@204I6AP80DE5A0P1eMGD206e]K@80L71`0P1iNGT304i>CP80?clo0P19
BDT205iNGP80QXJ60P1gMgL30861P@80L71`0P1ADE420451@@80<c<c0P0R8R8501DE5@804A4A100;
2`/500<30`801`L71P030`<200L71`804A4A0`0K6a/202@T90808R8R0P0Z:RX201/K6`8092@T1@0a
<C4203Hf=P80<C4a0P0h>3P203<c<`<0>3Ph0P12@T8202XZ:P80;Bd]0P0Z:RX202d];@<0>3Ph0P0f
=SH203`l?080;Bd]1?ooool1o`00000000Co0000oooooooooooooooo0P0E5AD201LG5`804A4A0`0T
92@201DE5@803@d=0P0K6a/202@T90808R8R0`0h>3P204U9B@@0?3`l0P0k>c/503lo?`80>3Ph0P19
BDT204a<C080De=C0P0o?cl304U9B@80DE5A0P1CDe<205iNGP@0HV9R0P1SHf<305YJFP80LG5a0P1g
MgL40861P@80K6a/0`1MGEd203`l?0806a/K10071`L700d=3@801`L7100;2`/502@T9080ATI60P1A
DE4207EeM@80KFe]0P1`L70207UiN@<0CTi>0P0o?cl204U9B@80GUiN0P26QXH207MgM`<0PH610P1`
L702055AD@80@D510P0c<c<2028R8PD05ADE0P0A4A4400/;2`D00`<30P071`L600<30`801`L70P0A
4A4301/K6`8092@T0P0R8R8202XZ:P806a/K0P0T92@5034a<@80=SHf0P0a<C4203Ph>080<c<c0`0h
>3P20492@P80:RXZ0P0];Bd202XZ:P80;Bd]0`0h>3P203Hf=P80?3`l0P0];Bd4ooooo`7o00000000
1?l0003oooooooooooooool2028R8P806a/K0P0E5AD3014A4@805aLG100K6a/202PX:08092@T0`16
ATH2051@D080=SHf0P12@T8203Hf=P80>3Ph0`0k>c/4051@D080DE5A0P0l?3`204U9B@<0EEEE0P16
ATH2051@D080BDU90P1CDe<205aLG080Hf=S0`1JFUX2071`L080K6a/0P1SHf<206a/K080MGEe0`1G
EeL202XZ:P804A4A0P030`<200/;2`801`L70`030`<200/;2`801`L70P0A4A4201DE5@80;Bd]0`1C
De<206ATI080PH610P2?Shl208Z:RP80PH610P1fMWH3051@D0@0ADE50P1MGEd207UiN@80TI6A1@2=
SHd207MgM`80IVIV0P1EEED203Hf=P<08R8R0P0E5AD200d=3@804A4A0P0;2`/200L71`<00`<30P07
1`L800<30`801`L70`0;2`/201LG5`80:RXZ0P0X:2P2028R8P80<C4a0`0R8R8202d];@80<C4a0P0c
<c<203/k>`80<c<c0`0];Bd202PX:080;Bd]0P0k>c/20451@@80=SHf0`0h>3P203lo?`80>c/k0P0h
>3P4ooooo`7o000000001?l0003oooooooooooooool2028R8P806a/K0P0E5AD3014A4@805aLG100K
6a/202PX:08092@T0`16ATH2051@D080=SHf0P12@T8203Hf=P80>3Ph0`0k>c/4051@D080DE5A0P0l
?3`204U9B@<0EEEE0P16ATH2051@D080BDU90P1CDe<205aLG080Hf=S0`1JFUX2071`L080K6a/0P1S
Hf<206a/K080MGEe0`1GEeL202XZ:P804A4A0P030`<200/;2`801`L70`030`<200/;2`801`L70P0A
4A4201DE5@80;Bd]0`1CDe<206ATI080PH610P2?Shl208Z:RP80PH610P1fMWH3051@D0@0ADE50P1M
GEd207UiN@80TI6A1@2=SHd207MgM`80IVIV0P1EEED203Hf=P<08R8R0P0E5AD200d=3@804A4A0P0;
2`/200L71`<00`<30P071`L800<30`801`L70`0;2`/201LG5`80:RXZ0P0X:2P2028R8P80<C4a0`0R
8R8202d];@80<C4a0P0c<c<203/k>`80<c<c0`0];Bd202PX:080;Bd]0P0k>c/20451@@80=SHf0`0h
>3P203lo?`80>c/k0P0h>3P4ooooo`7o000000001?l0003oooooooooooooool401LG5`808R8R0`0E
5AD202@T90805ADE0P0R8R8201/K6`805aLG0`0l?3`20451@@80?3`l100c<c<203Hf=P<0ATI60P1L
G5`204a<C080EeMG0P19BDT204I6AP<0De=C0P1<C4`205=CD`80DE5A0P1SHf<207EeM@80Vi^K0`2W
YjL207alO080MgMg0P25QHD206ATI080?clo0`0X:2P2014A4@802`/;0P071`L200/;2`805ADE0`0=
3@d201/K6`80:RXZ0P0f=SH204U9B@80O7al0`2=SHd2096AT@80][Jf0P2a/K420;^k^`80^;Rh0P1n
OWh304a<C0805aLG0P19BDT20820P080XZ:R0P2NWYh309NGU`80ZZZZ0P2VYZH209JFUP80Ogmo0P1E
EED304U9B@80@D510P0T92@201LG5`803@d=1`071`L200<30`80000010030`<500L71`805ADE0P0A
4A4202d];@80<C4a0P0T92@3028R8P8092@T100X:2P2034a<@80?clo0`1<C4`204U9B@80>c/k0P19
BDT204I6APD0?3`l0P0f=SH2034a<@80;Bd]1?ooool1o`00000000Co0000oooooooooooooooo100G
5aL2028R8P<05ADE0P0T92@201DE5@808R8R0P0K6a/201LG5`<0?3`l0P11@D4203`l?0@0<c<c0P0f
=SH304I6AP80G5aL0P1<C4`205MGE`80BDU90P16ATH305=CD`80C4a<0P1CDe<2055AD@80Hf=S0P1e
MGD209^KV`<0YjNW0P1lO7`207MgM`80QHF50P1TI6@203lo?`<0:2PX0P0A4A4200/;2`801`L70P0;
2`/201DE5@<03@d=0P0K6a/202XZ:P80=SHf0P19BDT207alO0<0SHf=0P2ATI420;Jf]P80/K6a0P2k
^k/20;Rh^080OWin0`1<C4`201LG5`80BDU90P20P8020::RXP80WYjN0`2GUiL20:ZZZP80YZJV0P2F
UYH207moO`80EEEE0`19BDT20451@@8092@T0P0G5aL200d=3@L01`L70P030`<2000000@00`<31@07
1`L201DE5@804A4A0P0];Bd2034a<@8092@T0`0R8R8202@T90@0:2PX0P0a<C4203lo?`<0C4a<0P19
BDT203/k>`80BDU90P16ATH503`l?080=SHf0P0a<C4202d];@Cooooo0Ol000000004o`000?oooooo
ooooooooo`808R8R0P0E5AD201LG5`D05ADE100G5aL2028R8P80:2PX0`0f=SH203/k>`80>3Ph100]
;Bd203/k>`<0D51@0P16ATH203lo?`80ATI60P0l?3`204U9B@<0FUYJ0P1GEeL405QHF080G5aL0P1[
Jf/2079bLP<0P8200P2GUiL207alO080Q8B40P1SHf<203Hf=P<05aLG0P0;2`/200L71`803@d=0P07
1`L2014A4@<0:2PX0P0k>c/2055AD@80LW9b0P2GUiL20:JVYP<0^[Zj0P2c/k<20=;BdP80gMgM0P3j
n_X20>3Ph080O7al0`0R8R8400d=3@80CTi>0P2/[:`20<O7a`<0c<c<0P3AdM420;Zj^P80WIfM0P2K
Vi/208F5Q@<0J6QX0P16ATH203Hf=P80:2PX0P0R8R8201DE5@<02`/;0P071`L600<30`801`L71@03
0`<200/;2`@08R8R100];Bd301DE5@@06a/K0P0G5aL401/K6`<092@T0P0X:2P201LG5`80:RXZ1`0c
<c<403Hf=P80>c/k1?ooool1o`00000000Co0000oooooooooooooooo0P0R8R8201DE5@805aLG1@0E
5AD401LG5`808R8R0P0X:2P303Hf=P80>c/k0P0h>3P402d];@80>c/k0`1@D50204I6AP80?clo0P16
ATH203`l?080BDU90`1JFUX205MGE`@0F5QH0P1LG5`206][J`80LW9b0`20P80209NGU`80O7al0P24
Q8@206=SH`80=SHf0`0G5aL200/;2`801`L70P0=3@d200L71`804A4A0`0X:2P203/k>`80DE5A0P1b
LW8209NGU`80YZJV0`2j^[X20;>c/`80d];B0P3MgMd20?[jnP80h>3P0P1lO7`3028R8P@03@d=0P1>
CTh20:b/[080alO70`3<c<`20=7Ad@80^[Zj0P2MWId209^KV`80QHF50`1XJ6P204I6AP80=SHf0P0X
:2P2028R8P805ADE0`0;2`/200L71`H00`<30P071`L500<30`802`/;100R8R8402d];@<05ADE100K
6a/201LG5`@06a/K0`0T92@202PX:0805aLG0P0Z:RX703<c<`@0=SHf0P0k>c/4ooooo`7o00000000
1?l0003oooooooooooooool2028R8P805ADE0P0G5aL501DE5@@05aLG0P0R8R8202PX:0<0=SHf0P0k
>c/203Ph>0@0;Bd]0P0k>c/3051@D080ATI60P0o?cl204I6AP80?3`l0P19BDT305YJFP80EeMG101H
F5P205aLG080Jf][0P1bLW830820P080UiNG0P1lO7`208B4Q080Hf=S0P0f=SH301LG5`802`/;0P07
1`L200d=3@801`L70P0A4A4302PX:080>c/k0P1ADE42079bLP80UiNG0P2VYZH30;Zj^P80/k>c0P3B
d]820=gMg@80n_[j0P3Ph>0207alO0<08R8R100=3@d204i>CP80[:b/0P37alL30<c<c080dM7A0P2j
^[X209fMW@80Vi^K0P25QHD306QXJ080ATI60P0f=SH202PX:0808R8R0P0E5AD300/;2`801`L71P03
0`<200L71`D00`<30P0;2`/4028R8P@0;Bd]0`0E5AD401/K6`805aLG100K6a/302@T9080:2PX0P0G
5aL202XZ:PL0<c<c100f=SH203/k>`Cooooo0Ol000000004o`000?ooooooooooooooo`80:RXZ100G
5aL3028R8P805aLG0P0K6a/201DE5@8092@T0P0R8R8303/k>`80C4a<0P11@D42034a<@80@D511@1@
D5020492@P80F5QH0P19BDT205=CD`80CTi>0`12@T82055AD@80G5aL0P1HF5P206e]K@80L71`0P1V
IVH305EEE@80I6AT0P1NGUh2055AD@80?clo0P0E5AD500/;2`801`L70P0;2`/200d=3@8092@T0`0l
?3`205iNGP80K6a/0P2FUYH20;>c/`80a<C40`3Hf=P20=KFeP80h^;R0P3Xj>P20=7Ad@80IVIV0P0K
6a/300/;2`@01`L70P0=3@d203/k>`80U9BD0`35aLD20=3@d080a<C40P2FUYH208^;R`80OWin0`1a
LG4205aLG080D51@0P0o?cl202@T9080:2PX0`0A4A4400/;2`800`<30P00000200L71`800`<30`00
000200<30`802`/;0P071`L200/;2`804A4A0`0R8R8201/K6`805ADE100=3@d201LG5`<05ADE100R
8R8201LG5`806a/K0P0R8R8302d];@80:RXZ100T92@4ooooo`7o000000001?l0003ooooooooooooo
ool202XZ:P@05aLG0`0R8R8201LG5`806a/K0P0E5AD202@T90808R8R0`0k>c/204a<C080@D510P0a
<C420451@@D0D51@0P12@T8205QHF080BDU90P1CDe<204i>CP<0@T920P1ADE4205aLG080F5QH0P1]
KFd2071`L080IVIV0`1EEED206ATI080GUiN0P1ADE4203lo?`805ADE1@0;2`/200L71`802`/;0P0=
3@d202@T90<0?3`l0P1NGUh206a/K080UYJF0P2c/k<20<C4a0<0f=SH0P3Fe]H20>;RhP80j>SX0P3A
dM4206IVIP806a/K0`0;2`/400L71`803@d=0P0k>c/209BDU0<0aLG50P3@d=020<C4a080UYJF0P2;
Rh/207inOP<0LG5a0P1LG5`2051@D080?clo0P0T92@202PX:0<04A4A100;2`/200<30`8000000P07
1`L200<30`<000000P030`<200/;2`801`L70P0;2`/2014A4@<08R8R0P0K6a/201DE5@@03@d=0P0G
5aL301DE5@@08R8R0P0G5aL201/K6`808R8R0`0];Bd202XZ:P@092@T1?ooool1o`00000000Co0000
oooooooooooooooo0P0E5AD200d=3@D05ADE100K6a/2028R8P806a/K0P0R8R83051@D0@0>3Ph0P11
@D420492@P80?clo0`19BDT203/k>`@0=SHf0P1>CTh20451@@<0D51@0P1HF5P2055AD@80De=C0P1G
EeL2065QH@80HV9R0`1TI6@2065QH@80EeMG0P0c<c<201DE5@803@d=0`030`<400L71`803@d=0P0R
8R82051@D0<0LW9b0P25QHD208n?S`80/k>c0P2k^k/20<S8b0<0emOG0P3Hf=P20=gMg@80d=3@0P2;
Rh/2028R8P803@d=0`030`<200L71`@02`/;0P0R8R8205QHF0<0W9bL0P33`l<20<S8b080[Zj^0P2B
TY820820P0<0MWIf0P1bLW8206ATI080ATI60P0f=SH2034a<@<08R8R100A4A4200d=3@801`L71`03
0`<2000000800`<30P071`L200d=3@805aLG0`0T92@201LG5`805ADE0P0=3@d2014A4@808R8R1@0K
6a/2028R8P805aLG0P0K6a/502d];@80:2PX100];Bd4ooooo`7o000000001?l0003ooooooooooooo
ool201DE5@803@d=1@0E5AD401/K6`808R8R0P0K6a/2028R8P<0D51@100h>3P20451@@80@T920P0o
?cl304U9B@80>c/k100f=SH204i>CP80@D510`1@D50205QHF080DE5A0P1CDe<205MGE`80HF5Q0P1R
HV8306ATI080HF5Q0P1GEeL203<c<`805ADE0P0=3@d300<30`@01`L70P0=3@d2028R8P80D51@0`1b
LW8208F5Q@80Shn?0P2c/k<20;^k^`80b<S80`3GemL20=SHf080gMgM0P3@d=0208^;R`808R8R0P0=
3@d300<30`801`L7100;2`/2028R8P80F5QH0`2LW9`20<?3``80b<S80P2^[Zh209:BTP80P8200`1f
MWH2079bLP80I6AT0P16ATH203Hf=P80<C4a0`0R8R84014A4@803@d=0P071`L700<30`8000000P03
0`<200L71`803@d=0P0G5aL302@T90805aLG0P0E5AD200d=3@804A4A0P0R8R8501/K6`808R8R0P0G
5aL201/K6`D0;Bd]0P0X:2P402d];@Cooooo0Ol000000004o`000?ooooooooooooooo`@06a/K0P0T
92@3014A4@805ADE0P0K6a/402@T90808R8R0`0f=SH203Ph>080=SHf0P0l?3`20451@@80@T920`1>
CTh205MGE`@0C4a<2@11@D4205YJFP80KFe]0P1LG5`206IVIP80MGEe0`1SHf<2034a<@806a/K0P0=
3@d200L71`800`<30`0;2`/200L71`808R8R0P0Z:RX203Ph>080EEEE0`1eMGD209JFUP80[:b/0P2X
Z:P20:>SX`80bl_;0`3@d=020=SHf080a<C40P1lO7`20492@P802`/;0P0=3@d700/;2`801`L70P0A
4A420451@@<0MGEe0P2GUiL20;Rh^0@0[:b/0P2c/k<308F5Q@80NWYj0P1lO7`206ATI080EeMG0P0o
?cl503<c<`805ADE0P0;2`/400<30`D01`L71000000900<30`H01`L70P0;2`/201LG5`<08R8R0P0X
:2P2028R8P806a/K0P0Z:RX202PX:0<092@T0P0K6a/202@T90806a/K1?ooool1o`00000000Co0000
oooooooooooooooo100K6a/202@T90<04A4A0P0E5AD201/K6`@092@T0P0R8R8303Hf=P80>3Ph0P0f
=SH203`l?080@D510P12@T8304i>CP80EeMG101<C4`90451@@80FUYJ0P1]KFd205aLG080IVIV0P1e
MGD306=SH`80<C4a0P0K6a/200d=3@801`L70P030`<300/;2`801`L70P0R8R8202XZ:P80>3Ph0P1E
EED307EeM@80UYJF0P2/[:`20:RXZ080Xj>S0P3;bl/30=3@d080f=SH0P34a<@207alO080@T920P0;
2`/200d=3@L02`/;0P071`L2014A4@80@D510`1eMGD209NGU`80^;Rh102/[:`20;>c/`<0QHF50P1j
NWX207alO080I6AT0P1GEeL203lo?`D0<c<c0P0E5AD200/;2`@00`<31@071`L4000000T00`<31P07
1`L200/;2`805aLG0`0R8R8202PX:0808R8R0P0K6a/202XZ:P80:2PX0`0T92@201/K6`8092@T0P0K
6a/4ooooo`7o000000001?l0003oooooooooooooool401/K6`8092@T0`0A4A4201DE5@806a/K100T
92@2028R8P<0=SHf0P0h>3P203Hf=P80?3`l0P11@D420492@P<0CTi>0P1GEeL404a<C0T0@D510P1J
FUX206e]K@80G5aL0P1VIVH207EeM@<0Hf=S0P0a<C4201/K6`803@d=0P071`L200<30`<02`/;0P07
1`L2028R8P80:RXZ0P0h>3P205EEE@<0MGEe0P2FUYH20:b/[080Z:RX0P2SXj<20<_;b`<0d=3@0P3H
f=P20<C4a080O7al0P12@T8200/;2`803@d=1`0;2`/200L71`804A4A0P11@D4307EeM@80UiNG0P2h
^;P40:b/[080/k>c0`25QHD207YjNP80O7al0P1TI6@205MGE`80?clo1@0c<c<201DE5@802`/;1003
0`<500L71`@000002@030`<600L71`802`/;0P0G5aL3028R8P80:2PX0P0R8R8201/K6`80:RXZ0P0X
:2P302@T90806a/K0P0T92@201/K6`Cooooo0Ol000000004o`000?ooooooooooooooo`805aLG0P0R
8R8701/K6`80:RXZ0P0E5AD2014A4@80:2PX0`0o?cl203/k>`80<c<c0P1<C4`2055AD@80@T920`1A
DE440451@@80?clo0P0k>c/204E5A@<0EEEE0P1VIVH206=SH`80Jf][0P1SHf<205EEE@80@T920`0]
;Bd2028R8P803@d=0P071`L200/;2`D03@d=0P0E5AD202d];@80@T920P1NGUh206ATI0<0V9RH102V
YZH209jNWP80];Bd0P3AdM430=oOg`80_Kfm0P1oOgl202@T90@04A4A0P0=3@d302PX:0@04A4A0P0=
3@d200/;2`801`L70`0h>3P206QXJ080Q8B40P2GUiL20<g=c@80]KFe0`2QXJ4208n?S`80R8R80P1R
HV8206IVIP80HV9R0`1GEeL203`l?08092@T0P0E5AD201LG5`805ADE0P0=3@d500L71`805ADE0P0;
2`/2014A4@802`/;2@030`<200L71`803@d=0`0A4A4601/K6`80:RXZ0P0];Bd3034a<@806a/K0P0T
92@2034a<@Cooooo0Ol000000004o`000?ooooooooooooooo`805aLG0P0R8R8701/K6`80:RXZ0P0E
5AD2014A4@80:2PX0`0o?cl203/k>`80<c<c0P1<C4`2055AD@80@T920`1ADE440451@@80?clo0P0k
>c/204E5A@<0EEEE0P1VIVH206=SH`80Jf][0P1SHf<205EEE@80@T920`0];Bd2028R8P803@d=0P07
1`L200/;2`D03@d=0P0E5AD202d];@80@T920P1NGUh206ATI0<0V9RH102VYZH209jNWP80];Bd0P3A
dM430=oOg`80_Kfm0P1oOgl202@T90@04A4A0P0=3@d302PX:0@04A4A0P0=3@d200/;2`801`L70`0h
>3P206QXJ080Q8B40P2GUiL20<g=c@80]KFe0`2QXJ4208n?S`80R8R80P1RHV8206IVIP80HV9R0`1G
EeL203`l?08092@T0P0E5AD201LG5`805ADE0P0=3@d500L71`805ADE0P0;2`/2014A4@802`/;2@03
0`<200L71`803@d=0`0A4A4601/K6`80:RXZ0P0];Bd3034a<@806a/K0P0T92@2034a<@Cooooo0Ol0
00000004o`000?ooooooooooooooo`@05aLG0P0E5AD5014A4@805aLG0P0E5AD201LG5`80:2PX1`0h
>3P203`l?080?clo0P12@T830451@@80ADE50P11@D420492@P80ATI60P15ADD304i>CP80De=C0P1@
D502065QH@80C4a<0P0f=SH202@T90<05ADE0P0];Bd203<c<`808R8R0P0G5aL202PX:0<05ADE0P0K
6a/203lo?`80Hf=S0P1/K6`2065QH@<0SHf=0P2RXZ820<c<c080f=SH0P3Bd]820=cLg0<0d=3@0P2P
X:0203Hf=P@05aLG0P0R8R8201LG5`D08R8R100G5aL4014A4@<03@d=0P0Z:RX2079bLP80Ti>C0P2k
^k/20<C4a0<0c/k>0P2j^[X20;>c/`80Vi^K0P1gMgL205iNGP<0EeMG0P1HF5P203lo?`80:RXZ0P0K
6a/200/;2`D01`L70P0;2`/201/K6`@05aLG0P0K6a/300L71`H00`<30P00000200<30`<01`L7100;
2`/601DE5@<05aLG100E5AD201/K6`Cooooo0Ol000000004o`000?ooooooooooooooo`@05aLG0P0E
5AD5014A4@805aLG0P0E5AD201LG5`80:2PX1`0h>3P203`l?080?clo0P12@T830451@@80ADE50P11
@D420492@P80ATI60P15ADD304i>CP80De=C0P1@D502065QH@80C4a<0P0f=SH202@T90<05ADE0P0]
;Bd203<c<`808R8R0P0G5aL202PX:0<05ADE0P0K6a/203lo?`80Hf=S0P1/K6`2065QH@<0SHf=0P2R
XZ820<c<c080f=SH0P3Bd]820=cLg0<0d=3@0P2PX:0203Hf=P@05aLG0P0R8R8201LG5`D08R8R100G
5aL4014A4@<03@d=0P0Z:RX2079bLP80Ti>C0P2k^k/20<C4a0<0c/k>0P2j^[X20;>c/`80Vi^K0P1g
MgL205iNGP<0EeMG0P1HF5P203lo?`80:RXZ0P0K6a/200/;2`D01`L70P0;2`/201/K6`@05aLG0P0K
6a/300L71`H00`<30P00000200<30`<01`L7100;2`/601DE5@<05aLG100E5AD201/K6`Cooooo0Ol0
00000004o`000?ooooooooooooooo`808R8R0P0G5aL201DE5@<04A4A0P0E5AD2028R8P805ADE0P0R
8R8202PX:0D0>c/k0P0l?3`20451@@80ATI61@15ADD205=CD`80@D510P0k>c/204i>CP80?clo0`11
@D4203`l?080>c/k0P0];Bd202@T90806a/K0P0A4A4302d];@80D51@0P1GEeL203`l?08092@T1@0R
8R82034a<@80CTi>0P1RHV8206e]K@80SXj>0`32`/820<30`080bLW90P3Hf=P20=gMg@80h^;R0`39
bLT20861P@80:RXZ0P0K6a/201LG5`80=SHf0P19BDT505EEE@80?3`l0P0X:2P201/K6`805aLG0`0A
4A4201/K6`80K6a/0P2ATI420:>SX`80^[Zj0`3EeMD20=7Ad@80bl_;0P2k^k/20:^[Z`80WIfM0`1C
De<2055AD@80EeMG0P12@T8201LG5`803@d=0P071`L500/;2`804A4A0P0X:2P2034a<@80<c<c0`0Z
:RX2014A4@802`/;2@030`<400L71`804A4A0P0E5AD5028R8P806a/K0P0R8R8202@T90Cooooo0Ol0
00000004o`000?ooooooooooooooo`808R8R0P0G5aL201DE5@<04A4A0P0E5AD2028R8P805ADE0P0R
8R8202PX:0D0>c/k0P0l?3`20451@@80ATI61@15ADD205=CD`80@D510P0k>c/204i>CP80?clo0`11
@D4203`l?080>c/k0P0];Bd202@T90806a/K0P0A4A4302d];@80D51@0P1GEeL203`l?08092@T1@0R
8R82034a<@80CTi>0P1RHV8206e]K@80SXj>0`32`/820<30`080bLW90P3Hf=P20=gMg@80h^;R0`39
bLT20861P@80:RXZ0P0K6a/201LG5`80=SHf0P19BDT505EEE@80?3`l0P0X:2P201/K6`805aLG0`0A
4A4201/K6`80K6a/0P2ATI420:>SX`80^[Zj0`3EeMD20=7Ad@80bl_;0P2k^k/20:^[Z`80WIfM0`1C
De<2055AD@80EeMG0P12@T8201LG5`803@d=0P071`L500/;2`804A4A0P0X:2P2034a<@80<c<c0`0Z
:RX2014A4@802`/;2@030`<400L71`804A4A0P0E5AD5028R8P806a/K0P0R8R8202@T90Cooooo0Ol0
00000004o`000?ooooooooooooooo`805ADE1`0G5aL201DE5@806a/K0P0E5AD2014A4@805aLG0`0a
<C4203<c<`80=SHf0P19BDT20492@P80?3`l1@0o?cl20451@@80>3Ph0P0l?3`204E5A@<0?3`l0P0a
<C4202@T90805aLG0P0;2`/200d=3@804A4A0`0k>c/2079bLP80EeMG0P0c<c<2014A4@805ADE0`0K
6a/205QHF080Hf=S0P1QHF4207alO080TI6A0`33`l<40<G5a@80f][J0P3Ti>@20=GEe@<0^KVi0P2V
YZH205EEE@80<C4a0P0h>3P206e]K@D0QXJ60P2ATI4208J6QP80J6QX0P1>CTh203Hf=P<0;Bd]0P1C
De<208R8R080SHf=0P2UYJD20:RXZ0<0eMGE0P3Bd]820<;2`P80Ti>C0P2RXZ8208Z:RP<0LG5a0P1@
D50203<c<`80>c/k0P0h>3P2028R8P804A4A1@0;2`/201LG5`80:RXZ0P0h>3P203lo?`<0@D510P1G
EeL203/k>`805ADE0P071`L200<30`<0000010030`<200L71`804A4A0P0G5aL301/K6`80>3Ph0P0f
=SH202d];@Cooooo0Ol000000004o`000?ooooooooooooooo`805ADE1`0G5aL201DE5@806a/K0P0E
5AD2014A4@805aLG0`0a<C4203<c<`80=SHf0P19BDT20492@P80?3`l1@0o?cl20451@@80>3Ph0P0l
?3`204E5A@<0?3`l0P0a<C4202@T90805aLG0P0;2`/200d=3@804A4A0`0k>c/2079bLP80EeMG0P0c
<c<2014A4@805ADE0`0K6a/205QHF080Hf=S0P1QHF4207alO080TI6A0`33`l<40<G5a@80f][J0P3T
i>@20=GEe@<0^KVi0P2VYZH205EEE@80<C4a0P0h>3P206e]K@D0QXJ60P2ATI4208J6QP80J6QX0P1>
CTh203Hf=P<0;Bd]0P1CDe<208R8R080SHf=0P2UYJD20:RXZ0<0eMGE0P3Bd]820<;2`P80Ti>C0P2R
XZ8208Z:RP<0LG5a0P1@D50203<c<`80>c/k0P0h>3P2028R8P804A4A1@0;2`/201LG5`80:RXZ0P0h
>3P203lo?`<0@D510P1GEeL203/k>`805ADE0P071`L200<30`<0000010030`<200L71`804A4A0P0G
5aL301/K6`80>3Ph0P0f=SH202d];@Cooooo0Ol000000004o`000?ooooooooooooooo`805ADE1`0G
5aL201DE5@806a/K0P0E5AD2014A4@805aLG0`0a<C4203<c<`80=SHf0P19BDT20492@P80?3`l1@0o
?cl20451@@80>3Ph0P0l?3`204E5A@<0?3`l0P0a<C4202@T90805aLG0P0;2`/200d=3@804A4A0`0k
>c/2079bLP80EeMG0P0c<c<2014A4@805ADE0`0K6a/205QHF080Hf=S0P1QHF4207alO080TI6A0`33
`l<40<G5a@80f][J0P3Ti>@20=GEe@<0^KVi0P2VYZH205EEE@80<C4a0P0h>3P206e]K@D0QXJ60P2A
TI4208J6QP80J6QX0P1>CTh203Hf=P<0;Bd]0P1CDe<208R8R080SHf=0P2UYJD20:RXZ0<0eMGE0P3B
d]820<;2`P80Ti>C0P2RXZ8208Z:RP<0LG5a0P1@D50203<c<`80>c/k0P0h>3P2028R8P804A4A1@0;
2`/201LG5`80:RXZ0P0h>3P203lo?`<0@D510P1GEeL203/k>`805ADE0P071`L200<30`<000001003
0`<200L71`804A4A0P0G5aL301/K6`80>3Ph0P0f=SH202d];@Cooooo0Ol000000004o`000?oooooo
ooooooooo`805ADE0P0A4A4201LG5`<08R8R0P0A4A4201/K6`805aLG0P0A4A4201/K6`<0:2PX0P0a
<C4202XZ:P80@D510P0k>c/504E5A@80?3`l0P0k>c/203Ph>080;Bd]0P0c<c<302@T90808R8R100A
4A4202PX:080FUYJ0P1XJ6P3065QH@80ATI60P0h>3P2028R8P805aLG0P0h>3P3051@D080GUiN0P1]
KFd208F5Q@80MgMg0P1aLG4309bLW080d];B103Fe]H20>7Qh@80eMGE0`2i^KT20=;BdP80MWIf0P1g
MgL208B4Q080[:b/0P2MWId30:^[Z`80YZJV0P2XZ:P20:^[Z`80O7al0P1JFUX305EEE@80Hf=S0P37
alL20:JVYP80W9bL0P2d];@30=3@d080`/;20P2ZZZX209jNWP80PH610P1TI6@305iNGP80K6a/0P1C
De<203Ph>080>c/k0P16ATH202PX:0<05ADE0P0;2`/200d=3@806a/K0P0a<C420492@P<0EEEE0P16
ATH204U9B@80ADE50P0R8R8200d=3@<01`L71P030`<200L71`802`/;0`0A4A42028R8P806a/K0P0E
5AD4ooooo`7o000000001?l0003oooooooooooooool201DE5@804A4A0P0G5aL3028R8P804A4A0P0K
6a/201LG5`804A4A0P0K6a/302PX:080<C4a0P0Z:RX20451@@80>c/k1@15ADD203`l?080>c/k0P0h
>3P202d];@80<c<c0`0T92@2028R8P@04A4A0P0X:2P205YJFP80J6QX0`1QHF4204I6AP80>3Ph0P0R
8R8201LG5`80>3Ph0`1@D50205iNGP80KFe]0P25QHD207MgM`80LG5a0`2LW9`20=;BdP@0e]KF0P3Q
hN420=GEe@<0^KVi0P3Bd]8207IfMP80MgMg0P24Q8@20:b/[080WIfM0`2[Zj/20:JVYP80Z:RX0P2[
Zj/207alO080FUYJ0`1EEED206=SH`80alO70P2VYZH209bLW080];Bd0`3@d=020<;2`P80ZZZZ0P2N
WYh20861P@80I6AT0`1NGUh206a/K080De=C0P0h>3P203/k>`80ATI60P0X:2P301DE5@802`/;0P0=
3@d201/K6`80<C4a0P12@T8305EEE@80ATI60P19BDT204E5A@808R8R0P0=3@d300L71`H00`<30P07
1`L200/;2`<04A4A0P0R8R8201/K6`805ADE1?ooool1o`00000000Co0000oooooooooooooooo0P0A
4A4201DE5@805aLG0`0=3@d201LG5`@08R8R100G5aL303Hf=P@0@T920P0f=SH203<c<`80?clo0`15
ADD20492@P80>3Ph0P0a<C42028R8P805aLG0`0A4A4400d=3@80<c<c0P11@D4207UiN@80GUiN0`11
@D4203Hf=P@0:RXZ0P0];Bd2055AD@<0F5QH0P1QHF4206IVIP80LW9b0P1`L7020:2PX0<0fm_K0P3P
h>020<C4a080d=3@103Ph>030=;BdP80^[Zj0P2BTY8208J6QP80YjNW0P2^[Zh20:FUY@<0^KVi0P2^
[Zh20:RXZ080^[Zj0P2HV9P208Z:RP<0LG5a0P1[Jf/20:j^[P80_[jn0P39bLT20;Fe]@<0b<S80P2h
^;P20:j^[P80b<S80P2n_[h2096AT@<0IVIV0P1/K6`206QXJ080EeMG0P12@T82051@D080@D510`0K
6a/2014A4@803@d=0P0K6a/202d];@80<C4a0`11@D4204i>CP80C4a<0P1>CTh204E5A@80<C4a0`0A
4A4400L71`802`/;0P071`L200/;2`<04A4A0P0K6a/201LG5`806a/K1?ooool1o`00000000Co0000
oooooooooooooooo0P0A4A4201DE5@805aLG0`0=3@d201LG5`@08R8R100G5aL303Hf=P@0@T920P0f
=SH203<c<`80?clo0`15ADD20492@P80>3Ph0P0a<C42028R8P805aLG0`0A4A4400d=3@80<c<c0P11
@D4207UiN@80GUiN0`11@D4203Hf=P@0:RXZ0P0];Bd2055AD@<0F5QH0P1QHF4206IVIP80LW9b0P1`
L7020:2PX0<0fm_K0P3Ph>020<C4a080d=3@103Ph>030=;BdP80^[Zj0P2BTY8208J6QP80YjNW0P2^
[Zh20:FUY@<0^KVi0P2^[Zh20:RXZ080^[Zj0P2HV9P208Z:RP<0LG5a0P1[Jf/20:j^[P80_[jn0P39
bLT20;Fe]@<0b<S80P2h^;P20:j^[P80b<S80P2n_[h2096AT@<0IVIV0P1/K6`206QXJ080EeMG0P12
@T82051@D080@D510`0K6a/2014A4@803@d=0P0K6a/202d];@80<C4a0`11@D4204i>CP80C4a<0P1>
CTh204E5A@80<C4a0`0A4A4400L71`802`/;0P071`L200/;2`<04A4A0P0K6a/201LG5`806a/K1?oo
ool1o`00000000Co0000oooooooooooooooo0P0G5aL401/K6`<03@d=0P0E5AD201/K6`808R8R0P0E
5AD2028R8P<0<C4a0P0k>c/60492@P80ATI60`0h>3P203/k>`80<c<c0P0R8R8201DE5@L03@d=0P0R
8R8205=CD`80EeMG0P1HF5P20492@P<0>3Ph0P0Z:RX201LG5`8092@T0P0l?3`204E5A@<0@T920P1G
EeL405EEE@80R8R80P2UYJD30=KFeP80emOG0P2h^;P20=GEe@80jn_[0P3Ti>@30=_Kf`80Zj^[0P2F
UYH209bLW080XJ6Q0P2ZZZX50;>c/`80];Bd0P2c/k<20;Jf]P80XZ:R0P2>SXh307AdM080J6QX0P1o
Ogl20<W9b@80h^;R0P3Fe]H30<g=c@80^[Zj0P2NWYh20;Rh^080^[Zj0P2[Zj/30820P080F5QH0P1A
DE4205MGE`80FUYJ0P0h>3P202d];@<06a/K100=3@d201LG5`80<C4a0P15ADD303Ph>080C4a<0P1/
K6`206QXJ080FUYJ0P1>CTh302d];@805ADE0P071`L400<30`801`L70`0A4A4401/K6`80:2PX1?oo
ool1o`00000000Co0000oooooooooooooooo0P0G5aL401/K6`<03@d=0P0E5AD201/K6`808R8R0P0E
5AD2028R8P<0<C4a0P0k>c/60492@P80ATI60`0h>3P203/k>`80<c<c0P0R8R8201DE5@L03@d=0P0R
8R8205=CD`80EeMG0P1HF5P20492@P<0>3Ph0P0Z:RX201LG5`8092@T0P0l?3`204E5A@<0@T920P1G
EeL405EEE@80R8R80P2UYJD30=KFeP80emOG0P2h^;P20=GEe@80jn_[0P3Ti>@30=_Kf`80Zj^[0P2F
UYH209bLW080XJ6Q0P2ZZZX50;>c/`80];Bd0P2c/k<20;Jf]P80XZ:R0P2>SXh307AdM080J6QX0P1o
Ogl20<W9b@80h^;R0P3Fe]H30<g=c@80^[Zj0P2NWYh20;Rh^080^[Zj0P2[Zj/30820P080F5QH0P1A
DE4205MGE`80FUYJ0P0h>3P202d];@<06a/K100=3@d201LG5`80<C4a0P15ADD303Ph>080C4a<0P1/
K6`206QXJ080FUYJ0P1>CTh302d];@805ADE0P071`L400<30`801`L70`0A4A4401/K6`80:2PX1?oo
ool1o`00000000Co0000oooooooooooooooo0P0G5aL401/K6`<03@d=0P0E5AD201/K6`808R8R0P0E
5AD2028R8P<0<C4a0P0k>c/60492@P80ATI60`0h>3P203/k>`80<c<c0P0R8R8201DE5@L03@d=0P0R
8R8205=CD`80EeMG0P1HF5P20492@P<0>3Ph0P0Z:RX201LG5`8092@T0P0l?3`204E5A@<0@T920P1G
EeL405EEE@80R8R80P2UYJD30=KFeP80emOG0P2h^;P20=GEe@80jn_[0P3Ti>@30=_Kf`80Zj^[0P2F
UYH209bLW080XJ6Q0P2ZZZX50;>c/`80];Bd0P2c/k<20;Jf]P80XZ:R0P2>SXh307AdM080J6QX0P1o
Ogl20<W9b@80h^;R0P3Fe]H30<g=c@80^[Zj0P2NWYh20;Rh^080^[Zj0P2[Zj/30820P080F5QH0P1A
DE4205MGE`80FUYJ0P0h>3P202d];@<06a/K100=3@d201LG5`80<C4a0P15ADD303Ph>080C4a<0P1/
K6`206QXJ080FUYJ0P1>CTh302d];@805ADE0P071`L400<30`801`L70`0A4A4401/K6`80:2PX1?oo
ool1o`00000000Co0000oooooooooooooooo0P0E5AD2014A4@805aLG1@0A4A4401LG5`805ADE0P0K
6a/303Ph>080ADE50P0o?cl203Ph>0@0?3`l0`0h>3P2034a<@80>3Ph0P0R8R8201/K6`D05aLG0P11
@D4207MgM`80K6a/0P16ATH203<c<`80<C4a0`0X:2P401/K6`80:2PX0P0h>3P205aLG0<0K6a/0P1e
MGD205aLG080OWin0P2KVi/20:JVYP<0/k>c0P2LW9`20:b/[080e]KF0P3`l?020=7Ad@<0XZ:R0P26
QXH208n?S`80WYjN0P2i^KT20<C4a080`/;21@2d];@20;^k^`80/k>c0P2VYZH20:2PX0<0Ogmo0P1/
K6`205YJFP80RHV90P3;bl/20<30`0<0a<C40P2c/k<20;6a/@80];Bd0P2WYjL209RHV0<0W9bL0P1l
O7`205QHF080LG5a0P1]KFd205EEE@80<c<c0`0];Bd2028R8P802`/;0P0E5AD2028R8P80:2PX0`0h
>3P20451@@80>c/k0P1<C4`205YJFP80HV9R0`1NGUh205=CD`806a/K2@071`L2014A4@805ADE0P0R
8R84ooooo`7o000000001?l0003oooooooooooooool201DE5@804A4A0P0G5aL5014A4@@05aLG0P0E
5AD201/K6`<0>3Ph0P15ADD203lo?`80>3Ph100l?3`303Ph>080<C4a0P0h>3P2028R8P806a/K1@0G
5aL20451@@80MgMg0P1/K6`204I6AP80<c<c0P0a<C4302PX:0@06a/K0P0X:2P203Ph>080G5aL0`1/
K6`207EeM@80G5aL0P1nOWh209^KV`80YZJV0`2c/k<209bLW080[:b/0P3Fe]H20?3`l080dM7A0`2R
XZ8208J6QP80Shn?0P2NWYh20;Vi^@80a<C40P32`/850;Bd]080^k^k0P2c/k<20:JVYP80X:2P0`1o
Ogl206a/K080FUYJ0P29RHT20<_;b`80`<300`34a<@20;>c/`80/K6a0P2d];@20:NWY`80V9RH0`2L
W9`207alO080F5QH0P1aLG4206e]K@80EEEE0P0c<c<302d];@808R8R0P0;2`/201DE5@808R8R0P0X
:2P303Ph>080@D510P0k>c/204a<C080FUYJ0P1RHV8305iNGP80De=C0P0K6a/900L71`804A4A0P0E
5AD2028R8PCooooo0Ol000000004o`000?ooooooooooooooo`806a/K0P0G5aL201DE5@<05aLG100R
8R8202@T90805aLG0P0K6a/3034a<@80<c<c0P0h>3P203`l?0@0>3Ph0`0f=SH202d];@806a/K0P0G
5aL2014A4@8092@T0`15ADD205QHF080G5aL0P1HF5P203lo?`80>c/k0P0X:2P501DE5@808R8R0P16
ATH2069RHP80MWIf0`1oOgl206e]K@80LG5a0P1fMWH209NGU`80Z:RX0`2HV9P20:^[Z`80_[jn0P3C
dm<20=OGe`80YZJV0`28R8P206=SH`80Xj>S0P30`<020<?3``80alO70P3Bd]830<g=c@80h>3P0P34
a<@40;Vi^@80]KFe0`2VYZH206][J`80F5QH0P1RHV8208J6QP80W9bL0`2c/k<20:RXZ080XZ:R0P2/
[:`20:ZZZP80W9bL0`25QHD208B4Q080M7Ad0P1NGUh206=SH`80NGUi0P1MGEd30492@P80<C4a0P0K
6a/201LG5`805ADE0P0R8R8302d];@80?3`l0P0o?cl203Hf=P80C4a<0P1NGUh307AdM080KFe]0P1@
D50202XZ:P805aLG0P071`L500/;2`803@d=0P0E5AD4ooooo`7o000000001?l0003ooooooooooooo
ool201/K6`805aLG0P0E5AD301LG5`@08R8R0P0T92@201LG5`806a/K0`0a<C4203<c<`80>3Ph0P0l
?3`403Ph>0<0=SHf0P0];Bd201/K6`805aLG0P0A4A4202@T90<0ADE50P1HF5P205aLG080F5QH0P0o
?cl203/k>`80:2PX1@0E5AD2028R8P80ATI60P1RHV8207IfMP<0Ogmo0P1]KFd2075aL@80MWIf0P2G
UiL20:RXZ0<0V9RH0P2[Zj/20;jn_P80dm?C0P3GemL20:JVYP<0R8R80P1SHf<20:>SX`80`<300P33
`l<20<O7a`80d];B0`3=cLd20>3Ph080a<C4102i^KT20;Fe]@<0YZJV0P1[Jf/205QHF080HV9R0P26
QXH209bLW0<0/k>c0P2XZ:P20::RXP80[:b/0P2ZZZX209bLW0<0QHF50P24Q8@207AdM080GUiN0P1S
Hf<207UiN@80GEeM0`12@T82034a<@806a/K0P0G5aL201DE5@808R8R0`0];Bd203`l?080?clo0P0f
=SH204a<C080GUiN0`1dM7@206e]K@80D51@0P0Z:RX201LG5`801`L71@0;2`/200d=3@805ADE1?oo
ool1o`00000000Co0000oooooooooooooooo0P0R8R8401LG5`L05ADE0P0A4A4201DE5@806a/K0`0f
=SH203/k>`80<c<c1011@D4203Ph>0<0<c<c0P0X:2P202@T90805aLG0P0K6a/204U9B@<0L71`0P1[
Jf/204E5A@80?3`l0P0Z:RX201LG5`805ADE0`0=3@d2014A4@808R8R0P0];Bd204E5A@80GEeM0`1`
L70206=SH`80KFe]0P1iNGT208R8R080YJFU0`2e]KD20;Bd]080`l?30P37alL20;>c/`80UiNG0`29
RHT206e]K@80WIfM0P2k^k/20=GEe@80f=SH0P3UiND30>o_k`80lo?c0P3YjNT20<W9b@80d];B0P37
alL30:RXZ080MGEe0P1MGEd2071`L080O7al0P2ATI430:FUY@80WIfM0P2o_kl20;Fe]@80WIfM0P25
QHD3075aL@80HF5Q0P1@D50205=CD`80@T920P0o?cl205=CD`<0GEeM0P1<C4`201/K6`@03@d=0P0E
5AD301/K6`80<C4a0P0l?3`204E5A@80>3Ph0P0];Bd303`l?080G5aL0P1NGUh2055AD@80?3`l0P0A
4A4500L71`802`/;0P0A4A44ooooo`7o000000001?l0003oooooooooooooool2028R8P@05aLG1`0E
5AD2014A4@805ADE0P0K6a/303Hf=P80>c/k0P0c<c<40451@@80>3Ph0`0c<c<202PX:08092@T0P0G
5aL201/K6`80BDU90`1`L70206][J`80ADE50P0l?3`202XZ:P805aLG0P0E5AD300d=3@804A4A0P0R
8R8202d];@80ADE50P1MGEd3071`L080Hf=S0P1]KFd207UiN@80R8R80P2UYJD30;Fe]@80];Bd0P33
`l<20<O7a`80/k>c0P2GUiL308V9R@80KFe]0P2MWId20;^k^`80eMGE0P3Hf=P20>GUi@<0kno_0P3c
lo<20>WYj@80bLW90P3Bd]820<O7a`<0Z:RX0P1eMGD205eMG@80L71`0P1lO7`2096AT@<0YJFU0P2M
WId20;no_`80]KFe0P2MWId208F5Q@<0LG5a0P1QHF42051@D080De=C0P12@T8203lo?`80De=C0`1M
GEd204a<C0806a/K100=3@d201DE5@<06a/K0P0a<C4203`l?080ADE50P0h>3P202d];@<0?3`l0P1L
G5`205iNGP80DE5A0P0l?3`2014A4@D01`L70P0;2`/2014A4@Cooooo0Ol000000004o`000?oooooo
ooooooooo`808R8R100G5aL701DE5@804A4A0P0E5AD201/K6`<0=SHf0P0k>c/203<c<`@0@D510P0h
>3P303<c<`80:2PX0P0T92@201LG5`806a/K0P19BDT3071`L080Jf][0P15ADD203`l?080:RXZ0P0G
5aL201DE5@<03@d=0P0A4A42028R8P80;Bd]0P15ADD205eMG@<0L71`0P1SHf<206e]K@80NGUi0P28
R8P20:FUY@<0]KFe0P2d];@20<?3``80alO70P2c/k<209NGU`<0RHV90P1]KFd209fMW@80^k^k0P3E
eMD20=SHf080iNGU0`3_knl20??cl`80jNWY0P39bLT20=;BdP80alO70`2XZ:P207EeM@80GEeM0P1`
L70207alO080TI6A0`2UYJD209fMW@80_kno0P2e]KD209fMW@80QHF50`1aLG42065QH@80D51@0P1C
De<20492@P80?clo0P1CDe<305eMG@80C4a<0P0K6a/400d=3@805ADE0`0K6a/2034a<@80?3`l0P15
ADD203Ph>080;Bd]0`0l?3`205aLG080GUiN0P1ADE4203`l?0804A4A1@071`L200/;2`804A4A1?oo
ool1o`00000000Co0000oooooooooooooooo0P0G5aL201/K6`808R8R0`0G5aL201DE5@@04A4A0P0E
5AD202@T90<0<C4a0P12@T8203`l?080>3Ph0P0];Bd203Ph>0<0:RXZ0P0K6a/201LG5`808R8R0P16
ATH206][J`<0DE5A0P0l?3`202d];@805aLG0P0A4A4201DE5@803@d=1@0;2`/201/K6`80;Bd]0P1@
D50206QXJ0<0MGEe0P2?Shl207alO080SXj>0P2QXJ420;Rh^0<0^[Zj0P2c/k<20;fm_@80cLg=0P2^
[Zh20:2PX0<0Rh^;0P1iNGT20:j^[P80c<c<0P3^k^h20?3`l080m?Cd0`3_knl20?Cdm080kno_0P3U
iND20>g]k@80eMGE0`30`<0208Z:RP80IVIV0P1aLG420820P080R8R80`2CTi<208f=S@80TY:B0P2/
[:`20:FUY@80U9BD0`24Q8@406QXJ080KFe]0P1NGUh205EEE@80>3Ph0`0];Bd202XZ:P808R8R0P0=
3@d200/;2`801`L70`0=3@d202@T9080<C4a0P0k>c/203`l?0D0>c/k0P12@T8204U9B@80ADE50P0l
?3`2014A4@<01`L70P030`<200L71`803@d=1?ooool1o`00000000Co0000oooooooooooooooo0P0G
5aL201/K6`808R8R0`0G5aL201DE5@@04A4A0P0E5AD202@T90<0<C4a0P12@T8203`l?080>3Ph0P0]
;Bd203Ph>0<0:RXZ0P0K6a/201LG5`808R8R0P16ATH206][J`<0DE5A0P0l?3`202d];@805aLG0P0A
4A4201DE5@803@d=1@0;2`/201/K6`80;Bd]0P1@D50206QXJ0<0MGEe0P2?Shl207alO080SXj>0P2Q
XJ420;Rh^0<0^[Zj0P2c/k<20;fm_@80cLg=0P2^[Zh20:2PX0<0Rh^;0P1iNGT20:j^[P80c<c<0P3^
k^h20?3`l080m?Cd0`3_knl20?Cdm080kno_0P3UiND20>g]k@80eMGE0`30`<0208Z:RP80IVIV0P1a
LG420820P080R8R80`2CTi<208f=S@80TY:B0P2/[:`20:FUY@80U9BD0`24Q8@406QXJ080KFe]0P1N
GUh205EEE@80>3Ph0`0];Bd202XZ:P808R8R0P0=3@d200/;2`801`L70`0=3@d202@T9080<C4a0P0k
>c/203`l?0D0>c/k0P12@T8204U9B@80ADE50P0l?3`2014A4@<01`L70P030`<200L71`803@d=1?oo
ool1o`00000000Co0000oooooooooooooooo0P0E5AD400d=3@<02`/;0P0A4A4201LG5`805ADE0P0=
3@d2028R8P<0>3Ph0P0l?3`203Hf=P80<C4a0P0];Bd202XZ:PD06a/K0P0a<C4205EEE@80Hf=S0P19
BDT503`l?080:RXZ0P0A4A4200/;2`@03@d=0`0Z:RX20492@P80D51@0P1RHV82075aL@80M7Ad0`2?
Shl209bLW080YJFU0P2XZ:P20:^[Z`80_Kfm0`2k^k/20:b/[080a<C40P2j^[X20:^[Z`80U9BD0`1i
NGT2071`L080^KVi0P3Ogml20?;blP80lo?c0P3]kNd30?clo080m?Cd0P3clo<40?Gem@80moOg0`3P
h>0209>CT`80Jf][0P1aLG42071`L080NGUi0`2DU9@208Z:RP80V9RH0P2/[:`20<30`080^[Zj0`2V
YZH209JFUP80Ogmo0P1]KFd207MgM`80HF5Q0P19BDT303`l?080<c<c0P0A4A4200/;2`@03@d=0`0;
2`/200L71`805aLG0P0f=SH203lo?`80ATI60`1@D50203lo?`80<C4a1012@T8203<c<`<03@d=0P07
1`L200<30`801`L71?ooool1o`00000000Co0000oooooooooooooooo0P0E5AD400d=3@<02`/;0P0A
4A4201LG5`805ADE0P0=3@d2028R8P<0>3Ph0P0l?3`203Hf=P80<C4a0P0];Bd202XZ:PD06a/K0P0a
<C4205EEE@80Hf=S0P19BDT503`l?080:RXZ0P0A4A4200/;2`@03@d=0`0Z:RX20492@P80D51@0P1R
HV82075aL@80M7Ad0`2?Shl209bLW080YJFU0P2XZ:P20:^[Z`80_Kfm0`2k^k/20:b/[080a<C40P2j
^[X20:^[Z`80U9BD0`1iNGT2071`L080^KVi0P3Ogml20?;blP80lo?c0P3]kNd30?clo080m?Cd0P3c
lo<40?Gem@80moOg0`3Ph>0209>CT`80Jf][0P1aLG42071`L080NGUi0`2DU9@208Z:RP80V9RH0P2/
[:`20<30`080^[Zj0`2VYZH209JFUP80Ogmo0P1]KFd207MgM`80HF5Q0P19BDT303`l?080<c<c0P0A
4A4200/;2`@03@d=0`0;2`/200L71`805aLG0P0f=SH203lo?`80ATI60`1@D50203lo?`80<C4a1012
@T8203<c<`<03@d=0P071`L200<30`801`L71?ooool1o`00000000Co0000oooooooooooooooo1P0=
3@d500/;2`806a/K0P0R8R8201LG5`805ADE0`0];Bd203<c<`80?clo0P0h>3P402d];@<06a/K0P0R
8R82034a<@80@T920P1@D50205aLG0<0?clo0P0];Bd201DE5@H03@d=0P0K6a/30451@@80Hf=S0P1e
MGD20820P080TI6A0P2HV9P30:6QX@80[Zj^0P2d];@20:ZZZP80];Bd0P2SXj<30;Rh^080_Kfm0P2c
/k<409^KV`80TI6A0`1]KFd206=SH`80bLW90P3QhN420?[jnP80l_;b0P3Vi^H30?Shn080oooo0P3]
kNd20?Gem@80o_kn0P3emOD30>CTi080Vi^K0P1]KFd205EEE@80Jf][0P29RHT309bLW080R8R80P2S
Xj<20:6QX@80ZZZZ0P2c/k<30:JVYP80XJ6Q0P2HV9P208B4Q080LG5a0P1XJ6P205MGE`<0CTi>0P15
ADD203/k>`80;Bd]0P0A4A4200/;2`D00`<30P0;2`/200d=3@@0=SHf0`1>CTh206IVIP80EeMG0P16
ATH20492@P80CTi>0`0X:2P200/;2`801`L70P0;2`/4ooooo`7o000000001?l0003ooooooooooooo
ool600d=3@D02`/;0P0K6a/2028R8P805aLG0P0E5AD302d];@80<c<c0P0o?cl203Ph>0@0;Bd]0`0K
6a/2028R8P80<C4a0P12@T82051@D080G5aL0`0o?cl202d];@805ADE1P0=3@d201/K6`<0@D510P1S
Hf<207EeM@80P8200P2ATI4209RHV0<0XJ6Q0P2^[Zh20;Bd]080ZZZZ0P2d];@20:>SX`<0^;Rh0P2m
_Kd20;>c/`@0Vi^K0P2ATI4306e]K@80Hf=S0P39bLT20>7Qh@80n_[j0P3bl_820>KViP<0n?Sh0P3o
ool20>g]k@80mOGe0P3no_h20?Gem@<0i>CT0P2KVi/206e]K@80EEEE0P1[Jf/208V9R@<0W9bL0P28
R8P20:>SX`80XJ6Q0P2ZZZX20;>c/`<0YZJV0P2QXJ4209RHV080Q8B40P1aLG4206QXJ080EeMG0`1>
CTh204E5A@80>c/k0P0];Bd2014A4@802`/;1@030`<200/;2`803@d=100f=SH304i>CP80IVIV0P1G
EeL204I6AP80@T920P1>CTh302PX:0802`/;0P071`L200/;2`Cooooo0Ol000000004o`000?oooooo
ooooooooo`805ADE0P0=3@d201DE5@<04A4A0P0E5AD2014A4@805ADE0P0=3@d201LG5`<092@T0P0c
<c<203Ph>080;Bd]100K6a/301LG5`8092@T0P19BDT404I6AP80<C4a0`0G5aL2014A4@802`/;0P0K
6a/202@T9080;Bd]0P0l?3`306=SH`80K6a/0P1[Jf/205=CD`80IVIV0P2MWId309NGU`80XZ:R0P2Z
ZZX20<C4a080c/k>0P37alL30;no_`80`/;20P2`/;020:NWY`80Shn?0P1nOWh307EeM@80Ogmo0P2f
][H20?3`l080i^KV0P3oool50>g]k@80j>SX0P3]kNd20>[ZjP80l?3`0P3]kNd30>GUi@80[Zj^0P25
QHD206a/K080HV9R0P2:RXX309:BTP80MWIf0P24Q8@207YjNP80Q8B40P2MWId30:b/[080YZJV0P2N
WYh208f=S@80SXj>0P29RHT208J6QP<0OWin0P1VIVH204a<C080?clo0P0c<c<2014A4@<03@d=0P07
1`L400<30`802`/;0P0];Bd304E5A@80@D510P1JFUX206IVIP80F5QH0P1JFUX304i>CP80:2PX0P0;
2`/200<30`Cooooo0Ol000000004o`000?ooooooooooooooo`805ADE0P0=3@d201DE5@<04A4A0P0E
5AD2014A4@805ADE0P0=3@d201LG5`<092@T0P0c<c<203Ph>080;Bd]100K6a/301LG5`8092@T0P19
BDT404I6AP80<C4a0`0G5aL2014A4@802`/;0P0K6a/202@T9080;Bd]0P0l?3`306=SH`80K6a/0P1[
Jf/205=CD`80IVIV0P2MWId309NGU`80XZ:R0P2ZZZX20<C4a080c/k>0P37alL30;no_`80`/;20P2`
/;020:NWY`80Shn?0P1nOWh307EeM@80Ogmo0P2f][H20?3`l080i^KV0P3oool50>g]k@80j>SX0P3]
kNd20>[ZjP80l?3`0P3]kNd30>GUi@80[Zj^0P25QHD206a/K080HV9R0P2:RXX309:BTP80MWIf0P24
Q8@207YjNP80Q8B40P2MWId30:b/[080YZJV0P2NWYh208f=S@80SXj>0P29RHT208J6QP<0OWin0P1V
IVH204a<C080?clo0P0c<c<2014A4@<03@d=0P071`L400<30`802`/;0P0];Bd304E5A@80@D510P1J
FUX206IVIP80F5QH0P1JFUX304i>CP80:2PX0P0;2`/200<30`Cooooo0Ol000000004o`000?oooooo
ooooooooo`805ADE0P0=3@d201DE5@<04A4A0P0E5AD2014A4@805ADE0P0=3@d201LG5`<092@T0P0c
<c<203Ph>080;Bd]100K6a/301LG5`8092@T0P19BDT404I6AP80<C4a0`0G5aL2014A4@802`/;0P0K
6a/202@T9080;Bd]0P0l?3`306=SH`80K6a/0P1[Jf/205=CD`80IVIV0P2MWId309NGU`80XZ:R0P2Z
ZZX20<C4a080c/k>0P37alL30;no_`80`/;20P2`/;020:NWY`80Shn?0P1nOWh307EeM@80Ogmo0P2f
][H20?3`l080i^KV0P3oool50>g]k@80j>SX0P3]kNd20>[ZjP80l?3`0P3]kNd30>GUi@80[Zj^0P25
QHD206a/K080HV9R0P2:RXX309:BTP80MWIf0P24Q8@207YjNP80Q8B40P2MWId30:b/[080YZJV0P2N
WYh208f=S@80SXj>0P29RHT208J6QP<0OWin0P1VIVH204a<C080?clo0P0c<c<2014A4@<03@d=0P07
1`L400<30`802`/;0P0];Bd304E5A@80@D510P1JFUX206IVIP80F5QH0P1JFUX304i>CP80:2PX0P0;
2`/200<30`Cooooo0Ol000000004o`000?ooooooooooooooo`@04A4A0P0=3@d3014A4@803@d=0P0A
4A4201DE5@804A4A0P0K6a/302PX:080<C4a0P0c<c<2034a<@8092@T0P0l?3`301LG5`80>c/k0P1A
DE42051@D080;Bd]0P0A4A4500/;2`804A4A0P0a<C42071`L0@0O7al0`1eMGD2071`L080I6AT0P1]
KFd2065QH@80LG5a0`2=SHd209JFUP80/k>c0P39bLT20=3@d080a<C40`2m_Kd209^KV`80Shn?0P2Q
XJ4209JFUP80KFe]0`26QXH209JFUP80^[Zj0P3Cdm<20>WYj@80mOGe0P3Kfm/30:ZZZP80c<c<0P3[
jn/20>g]k@80iNGU0P3Ph>030=_Kf`80WYjN0P2?Shl207inOP80Jf][0P1`L70307UiN@80MGEe0P1[
Jf/207MgM`80SXj>0P2;Rh/307inOP80TI6A0P2=SHd208Z:RP80O7al0P1TI6@205aLG0<0FUYJ0P1[
Jf/205QHF080D51@0P1ADE4203/k>`<05aLG10071`L200/;2`800`<30P0;2`/301LG5`80?clo0P12
@T8204a<C0@0HF5Q0`19BDT2034a<@804A4A0P030`<4ooooo`7o000000001?l0003ooooooooooooo
ool4014A4@803@d=0`0A4A4200d=3@804A4A0P0E5AD2014A4@806a/K0`0X:2P2034a<@80<c<c0P0a
<C4202@T9080?3`l0`0G5aL203/k>`80DE5A0P1@D50202d];@804A4A1@0;2`/2014A4@80<C4a0P1`
L70407alO0<0MGEe0P1`L70206ATI080KFe]0P1QHF42075aL@<0SHf=0P2FUYH20;>c/`80bLW90P3@
d=020<C4a0<0_Kfm0P2KVi/208n?S`80XJ6Q0P2FUYH206e]K@<0QXJ60P2FUYH20;Zj^P80dm?C0P3Y
jNT20?Gem@80fm_K0`2ZZZX20<c<c080jn_[0P3]kNd20>GUi@80h>3P0`3Kfm/209jNWP80Shn?0P1n
OWh206][J`80L71`0`1iNGT207EeM@80Jf][0P1gMgL208j>SP80Rh^;0`1nOWh2096AT@80SHf=0P2:
RXX207alO080I6AT0P1LG5`305YJFP80Jf][0P1HF5P2051@D080DE5A0P0k>c/301LG5`@01`L70P0;
2`/200<30`802`/;0`0G5aL203lo?`80@T920P1<C4`4065QH@<0BDU90P0a<C42014A4@800`<31?oo
ool1o`00000000Co0000oooooooooooooooo0P0E5AD4014A4@<05ADE0P0A4A4400d=3@804A4A0P0T
92@302d];@80<C4a0P0c<c<202@T90806a/K0P0R8R8302d];@80ADE50P16ATH203Hf=P804A4A0P0=
3@d501DE5@80>c/k0P1QHF4208j>SP80OWin0P1bLW8306ATI080EEEE0P1TI6@206=SH`80GEeM0P1S
Hf<30861P@80TI6A0P2LW9`20:j^[P80];Bd0P2m_Kd309NGU`80ZZZZ0P1dM7@208^;R`80P8200P1T
I6@308J6QP80/;2`0P2WYjL20<30`080iNGU0P3emOD20<C4a0<0RHV90P2i^KT20>k^kP80m?Cd0P3]
kNd20=GEe@<0c/k>0P2XZ:P208n?S`80O7al0P1/K6`207UiN@<0OWin0P1`L70207MgM`80K6a/0P2:
RXX508B4Q080Rh^;0P1eMGD207MgM`80NGUi0P1`L70205iNGP<0GEeM0P1QHF42069RHP80D51@0P1E
EED2055AD@<0=SHf0P0;2`/600<30`801`L70`0;2`/2014A4@80<c<c0P15ADD204a<C080?3`l0`1J
FUX203lo?`808R8R0P071`L4ooooo`7o000000001?l0003oooooooooooooool201DE5@@04A4A0`0E
5AD2014A4@@03@d=0P0A4A4202@T90<0;Bd]0P0a<C4203<c<`8092@T0P0K6a/2028R8P<0;Bd]0P15
ADD204I6AP80=SHf0P0A4A4200d=3@D05ADE0P0k>c/2065QH@80SXj>0P1nOWh2079bLP<0I6AT0P1E
EED206ATI080Hf=S0P1MGEd206=SH`<0PH610P2ATI4209bLW080[Zj^0P2d];@20;fm_@<0UiNG0P2Z
ZZX207AdM080Rh^;0P20P80206ATI0<0QXJ60P2`/;020:NWY`80`<300P3UiND20?Gem@80a<C40`29
RHT20;Vi^@80k^k^0P3dm?@20>g]k@80eMGE0`3>c/h20:RXZ080Shn?0P1lO7`206a/K080NGUi0`1n
OWh2071`L080MgMg0P1/K6`208Z:RPD0Q8B40P2;Rh/207EeM@80MgMg0P1iNGT2071`L080GUiN0`1M
GEd2065QH@80HV9R0P1@D50205EEE@80DE5A0`0f=SH200/;2`H00`<30P071`L300/;2`804A4A0P0c
<c<204E5A@80C4a<0P0l?3`305YJFP80?clo0P0R8R8200L71`Cooooo0Ol000000004o`000?oooooo
ooooooooo`804A4A0P0=3@d201DE5@<03@d=0P0K6a/201LG5`805ADE0P0A4A42028R8P<0<C4a100]
;Bd202@T90808R8R0P0K6a/30451@@80BDU90P0f=SH202@T90@03@d=0`0X:2P205=CD`80MWIf0P1d
M7@208V9R@80Ogmo1@1eMGD2079bLP80HV9R0P1SHf<2079bLP80L71`0`1iNGT209>CT`80V9RH0P2B
TY8209bLW080WIfM0`2GUiL208R8R080QHF50P26QXH207EeM@80HF5Q0`1bLW8209bLW080/k>c0P2X
Z:P20<g=c@80eMGE0P2CTi<308F5Q@80]KFe0P3Vi^H20>g]k@80h>3P0P34a<@30:j^[P80X:2P0P2>
SXh2079bLP80F5QH0P1EEED308f=S@80NWYj0P1gMgL205iNGP80RXZ:0P1oOgl308f=S@80Q8B40P25
QHD206=SH`80L71`0P1jNWX207MgM`<0NGUi0P1bLW82065QH@@0EEEE0P1CDe<304i>CP80ADE50P0R
8R8900<30`802`/;0P0E5AD2034a<@80C4a<0P1GEeL3051@D080BDU90P0c<c<2014A4@Cooooo0Ol0
00000004o`000?ooooooooooooooo`804A4A0P0=3@d201DE5@<03@d=0P0K6a/201LG5`805ADE0P0A
4A42028R8P<0<C4a100];Bd202@T90808R8R0P0K6a/30451@@80BDU90P0f=SH202@T90@03@d=0`0X
:2P205=CD`80MWIf0P1dM7@208V9R@80Ogmo1@1eMGD2079bLP80HV9R0P1SHf<2079bLP80L71`0`1i
NGT209>CT`80V9RH0P2BTY8209bLW080WIfM0`2GUiL208R8R080QHF50P26QXH207EeM@80HF5Q0`1b
LW8209bLW080/k>c0P2XZ:P20<g=c@80eMGE0P2CTi<308F5Q@80]KFe0P3Vi^H20>g]k@80h>3P0P34
a<@30:j^[P80X:2P0P2>SXh2079bLP80F5QH0P1EEED308f=S@80NWYj0P1gMgL205iNGP80RXZ:0P1o
Ogl308f=S@80Q8B40P25QHD206=SH`80L71`0P1jNWX207MgM`<0NGUi0P1bLW82065QH@@0EEEE0P1C
De<304i>CP80ADE50P0R8R8900<30`802`/;0P0E5AD2034a<@80C4a<0P1GEeL3051@D080BDU90P0c
<c<2014A4@Cooooo0Ol000000004o`000?ooooooooooooooo`804A4A0P0=3@d201DE5@<03@d=0P0K
6a/201LG5`805ADE0P0A4A42028R8P<0<C4a100];Bd202@T90808R8R0P0K6a/30451@@80BDU90P0f
=SH202@T90@03@d=0`0X:2P205=CD`80MWIf0P1dM7@208V9R@80Ogmo1@1eMGD2079bLP80HV9R0P1S
Hf<2079bLP80L71`0`1iNGT209>CT`80V9RH0P2BTY8209bLW080WIfM0`2GUiL208R8R080QHF50P26
QXH207EeM@80HF5Q0`1bLW8209bLW080/k>c0P2XZ:P20<g=c@80eMGE0P2CTi<308F5Q@80]KFe0P3V
i^H20>g]k@80h>3P0P34a<@30:j^[P80X:2P0P2>SXh2079bLP80F5QH0P1EEED308f=S@80NWYj0P1g
MgL205iNGP80RXZ:0P1oOgl308f=S@80Q8B40P25QHD206=SH`80L71`0P1jNWX207MgM`<0NGUi0P1b
LW82065QH@@0EEEE0P1CDe<304i>CP80ADE50P0R8R8900<30`802`/;0P0E5AD2034a<@80C4a<0P1G
EeL3051@D080BDU90P0c<c<2014A4@Cooooo0Ol000000004o`000?ooooooooooooooo`804A4A0P0X
:2P201LG5`<03@d=100A4A4201LG5`805ADE0P0G5aL302PX:0@0:RXZ0P0X:2P2028R8P80;Bd]0`15
ADD204i>CP80;Bd]100E5AD203Hf=P<0IVIV0P1eMGD209:BTP80QXJ60P1fMWH208f=S@80QHF50`2?
Shl207inOP80MGEe0P20P80207inOP80R8R80`2ZZZX20::RXP80X:2P0P2>SXh209bLW080RXZ:0`2A
TI4208R8R080OWin0P2=SHd20820P080HF5Q0`1bLW8209RHV080WIfM0P2VYZH20:FUY@80ZZZZ1@2Q
XJ420;>c/`80`<300P3Ogml20<g=c@80/k>c0`2QXJ4209bLW080TY:B0P1`L70205MGE`80BDU90`1j
NWX2079bLP80NWYj0P1SHf<208R8R080TY:B0`26QXH207alO080RXZ:0P20P80205eMG@80G5aL0P1N
GUh306e]K@80LG5a0P1gMgL2065QH@80EEEE0P1>CTh304a<C080@T920P11@D42034a<@802`/;1@03
0`<200L71`804A4A0P0h>3P203<c<`80?3`l0`1RHV8205aLG080ADE50P0];Bd4ooooo`7o00000000
1?l0003oooooooooooooool2014A4@80:2PX0P0G5aL300d=3@@04A4A0P0G5aL201DE5@805aLG0`0X
:2P402XZ:P80:2PX0P0R8R8202d];@<0ADE50P1>CTh202d];@@05ADE0P0f=SH306IVIP80MGEe0P2B
TY8208J6QP80MWIf0P2=SHd208F5Q@<0Shn?0P1nOWh207EeM@80P8200P1nOWh208R8R0<0ZZZZ0P2R
XZ820:2PX080SXj>0P2LW9`208Z:RP<0TI6A0P28R8P207inOP80SHf=0P20P802065QH@<0LW9b0P2H
V9P209fMW@80YZJV0P2UYJD20:ZZZPD0XJ6Q0P2c/k<20<30`080gmoO0P3=cLd20;>c/`<0XJ6Q0P2L
W9`209:BTP80L71`0P1GEeL204U9B@<0NWYj0P1bLW8207YjNP80Hf=S0P28R8P209:BTP<0QXJ60P1l
O7`208Z:RP80P8200P1MGEd205aLG080GUiN0`1]KFd2075aL@80MgMg0P1QHF4205EEE@80CTi>0`1<
C4`20492@P80@D510P0a<C4200/;2`D00`<30P071`L2014A4@80>3Ph0P0c<c<203`l?0<0HV9R0P1L
G5`204E5A@80;Bd]1?ooool1o`00000000Co0000oooooooooooooooo0P0E5AD400d=3@L04A4A0P0G
5aL2014A4@805aLG0`0X:2P202XZ:P80:2PX0P0Z:RX203<c<`80@D510`1MGEd20492@P8092@T0P0R
8R8203Ph>080GUiN0`1jNWX208B4Q080R8R80P25QHD207EeM@80SHf=0P2;Rh/308R8R080RHV90P24
Q8@40820P080YjNW0`2/[:`20<G5a@80^KVi0P2^[Zh40:b/[0<0TI6A0P2UYJD208f=S@80Ti>C0P1i
NGT20820P0<0MWIf0P2RXZ8209NGU`80ZZZZ0P2CTi<208V9R@80TI6A0`2GUiL208Z:RP80Q8B40P2P
X:020:>SX`80UiNG0`2d];@20:JVYP80R8R80P21PH42069RHP80EeMG0`1aLG42079bLP80PH610P1`
L70209BDU080Vi^K0`2=SHd208V9R@80RXZ:0P2;Rh/207alO080NGUi0P1gMgL30861P@80NGUi0P1l
O7`207IfMP80K6a/0P1MGEd305aLG080EeMG0P1MGEd205=CD`80@T920P0=3@d300L71`800`<30P07
1`L201LG5`80;Bd]0P0l?3`303Hf=P80@D510P1>CTh203/k>`Cooooo0Ol000000004o`000?oooooo
ooooooooo`805ADE100=3@d7014A4@805aLG0P0A4A4201LG5`<0:2PX0P0Z:RX202PX:080:RXZ0P0c
<c<20451@@<0GEeM0P12@T8202@T90808R8R0P0h>3P205iNGP<0NWYj0P24Q8@208R8R080QHF50P1e
MGD208f=S@80Rh^;0`28R8P208V9R@80Q8B41020P8020:NWY`<0[:b/0P35aLD20;Vi^@80[Zj^102/
[:`3096AT@80YJFU0P2=SHd209>CT`80NGUi0P20P80307IfMP80XZ:R0P2GUiL20:ZZZP80Ti>C0P29
RHT2096AT@<0UiNG0P2:RXX208B4Q080X:2P0P2SXj<209NGU`<0];Bd0P2VYZH208R8R080PH610P1R
HV8205MGE`<0LG5a0P1bLW820861P@80L71`0P2DU9@209^KV`<0SHf=0P29RHT208Z:RP80Rh^;0P1l
O7`207UiN@80MgMg0`21PH4207UiN@80O7al0P1fMWH206a/K080GEeM0`1LG5`205MGE`80GEeM0P1C
De<20492@P803@d=0`071`L200<30`801`L70P0G5aL202d];@80?3`l0`0f=SH20451@@80CTi>0P0k
>c/4ooooo`7o000000001?l0003oooooooooooooool201DE5@804A4A1@0=3@d2014A4@803@d=0P0E
5AD2014A4@D05aLG0P0T92@202PX:08092@T0P0Z:RX504a<C080<C4a0P0f=SH204a<C080Hf=S0P1]
KFd307MgM`80NWYj0P1dM7@2071`L080P8200P2HV9P209jNWP<0UiNG0P1jNWX207moO`80YZJV0P2>
SXh20<30`0<0^k^k0P3@d=020=[JfP80a<C40P3@d=020:ZZZP<0Rh^;0P1eMGD2055AD@80HF5Q0P1`
L70208n?S`<0Vi^K0P2VYZH209fMW@80X:2P0P2?Shl209^KV`80Ti>C0`21PH4207AdM080NGUi0P25
QHD208j>SP80U9BD0`2ZZZX209RHV080TY:B0P2>SXh207YjNP80De=C0`1dM7@208f=S@80P8200P1l
O7`40:JVYP<0Vi^K0P2VYZH208^;R`80U9BD0P2MWId2096AT@80UiNG0`1oOgl209NGU`80SXj>0P1f
MWH2079bLP80MWIf0`1JFUX205=CD`80FUYJ0P1EEED20492@P80<C4a0`0E5AD200<30`801`L70P0;
2`/201/K6`80>3Ph0`15ADD203/k>`80@T920P0k>c/4ooooo`7o000000001?l0003ooooooooooooo
ool201DE5@804A4A1@0=3@d2014A4@803@d=0P0E5AD2014A4@D05aLG0P0T92@202PX:08092@T0P0Z
:RX504a<C080<C4a0P0f=SH204a<C080Hf=S0P1]KFd307MgM`80NWYj0P1dM7@2071`L080P8200P2H
V9P209jNWP<0UiNG0P1jNWX207moO`80YZJV0P2>SXh20<30`0<0^k^k0P3@d=020=[JfP80a<C40P3@
d=020:ZZZP<0Rh^;0P1eMGD2055AD@80HF5Q0P1`L70208n?S`<0Vi^K0P2VYZH209fMW@80X:2P0P2?
Shl209^KV`80Ti>C0`21PH4207AdM080NGUi0P25QHD208j>SP80U9BD0`2ZZZX209RHV080TY:B0P2>
SXh207YjNP80De=C0`1dM7@208f=S@80P8200P1lO7`40:JVYP<0Vi^K0P2VYZH208^;R`80U9BD0P2M
WId2096AT@80UiNG0`1oOgl209NGU`80SXj>0P1fMWH2079bLP80MWIf0`1JFUX205=CD`80FUYJ0P1E
EED20492@P80<C4a0`0E5AD200<30`801`L70P0;2`/201/K6`80>3Ph0`15ADD203/k>`80@T920P0k
>c/4ooooo`7o000000001?l0003oooooooooooooool201DE5@804A4A1@0=3@d2014A4@803@d=0P0E
5AD2014A4@D05aLG0P0T92@202PX:08092@T0P0Z:RX504a<C080<C4a0P0f=SH204a<C080Hf=S0P1]
KFd307MgM`80NWYj0P1dM7@2071`L080P8200P2HV9P209jNWP<0UiNG0P1jNWX207moO`80YZJV0P2>
SXh20<30`0<0^k^k0P3@d=020=[JfP80a<C40P3@d=020:ZZZP<0Rh^;0P1eMGD2055AD@80HF5Q0P1`
L70208n?S`<0Vi^K0P2VYZH209fMW@80X:2P0P2?Shl209^KV`80Ti>C0`21PH4207AdM080NGUi0P25
QHD208j>SP80U9BD0`2ZZZX209RHV080TY:B0P2>SXh207YjNP80De=C0`1dM7@208f=S@80P8200P1l
O7`40:JVYP<0Vi^K0P2VYZH208^;R`80U9BD0P2MWId2096AT@80UiNG0`1oOgl209NGU`80SXj>0P1f
MWH2079bLP80MWIf0`1JFUX205=CD`80FUYJ0P1EEED20492@P80<C4a0`0E5AD200<30`801`L70P0;
2`/201/K6`80>3Ph0`15ADD203/k>`80@T920P0k>c/4ooooo`7o000000001?l0003ooooooooooooo
ool201LG5`@03@d=0`0E5AD200/;2`804A4A0P0G5aL4014A4@<092@T0P0Z:RX402@T9080<c<c0P12
@T8303Hf=P80>3Ph0P12@T8205EEE@80Hf=S0P1lO7`3071`L080M7Ad0P1MGEd2055AD@80J6QX0P20
P80208f=S@<0V9RH0P2SXj<209bLW080X:2P0P3Fe]H20;Fe]@<0`<300P3;bl/20<;2`P80dm?C0P3M
gMd20;>c/`<0NGUi0P1aLG420451@@80GUiN0P1iNGT209^KV`<0W9bL0P2DU9@209JFUP80Xj>S0P2:
RXX208R8R0D0NGUi0P1[Jf/207AdM080PH61102HV9P509JFUP80XJ6Q0P2LW9`209:BTP80I6AT0`19
BDT206][J`80ADE50P1GEeL20:NWY`80];Bd0`2RXZ820;>c/`80YjNW0P2c/k<20;6a/@80UYJF0P2C
Ti<309BDU080O7al0P28R8P2071`L080GEeM0P1aLG4305YJFP80DE5A0P1JFUX2051@D080ADE50P0c
<c<303/k>`805aLG0P071`L200/;2`803@d=0P0K6a/302d];@80ATI60P15ADD204I6APCooooo0Ol0
00000004o`000?ooooooooooooooo`805aLG100=3@d301DE5@802`/;0P0A4A4201LG5`@04A4A0`0T
92@202XZ:P@092@T0P0c<c<20492@P<0=SHf0P0h>3P20492@P80EEEE0P1SHf<207alO0<0L71`0P1d
M7@205eMG@80DE5A0P1XJ6P20820P080SHf=0`2HV9P20:>SX`80W9bL0P2PX:020=KFeP80]KFe0`30
`<020<_;b`80`/;20P3Cdm<20=gMg@80/k>c0`1iNGT2075aL@80@D510P1NGUh207UiN@80Vi^K0`2L
W9`209BDU080UYJF0P2SXj<208Z:RP80R8R81@1iNGT206][J`80M7Ad0P21PH4409RHV0D0UYJF0P2Q
XJ4209bLW080TY:B0P1TI6@304U9B@80Jf][0P15ADD205MGE`80YjNW0P2d];@30::RXP80/k>c0P2W
YjL20;>c/`80/K6a0P2FUYH209>CT`<0U9BD0P1lO7`208R8R080L71`0P1MGEd2075aL@<0FUYJ0P1A
DE4205YJFP80D51@0P15ADD203<c<`<0>c/k0P0G5aL200L71`802`/;0P0=3@d201/K6`<0;Bd]0P16
ATH204E5A@80ATI61?ooool1o`00000000Co0000oooooooooooooooo0P0=3@d2028R8P804A4A1@0=
3@d6014A4@803@d=0`0G5aL201/K6`@092@T0P0h>3P503lo?`80C4a<0P1/K6`40820P080LW9b0`1@
D50204i>CP80De=C101@D502071`L080Shn?0`2RXZ820;fm_@80`l?30P35aLD20;jn_P80/K6a0`2^
[Zh20:^[Z`80]KFe0P2ZZZX20:^[Z`80Z:RX0`2:RXX206IVIP80F5QH0P1bLW8209NGU`80Z:RX0`2A
TI4408B4Q080UiNG0P25QHD207EeM@80LW9b0`1SHf<206a/K080OWin0P1/K6`20820P080Q8B40`2:
RXX209:BTP80Shn?0P2UYJD208f=S@80KFe]0`1<C4`205=CD`80DE5A0P1[Jf/20:>SX`80Z:RX0`2Q
XJ420:b/[080X:2P0P2ATI420:>SX`80/k>c0P2SXj<309fMW@80TI6A0P20P80208Z:RP80K6a/0P1V
IVH307MgM`80Jf][0P1EEED204a<C080ADE51@0l?3`204E5A@804A4A100;2`/200d=3@<092@T0P0f
=SH204E5A@80EEEE1?ooool1o`00000000Co0000oooooooooooooooo0P0=3@d2028R8P804A4A1@0=
3@d6014A4@803@d=0`0G5aL201/K6`@092@T0P0h>3P503lo?`80C4a<0P1/K6`40820P080LW9b0`1@
D50204i>CP80De=C101@D502071`L080Shn?0`2RXZ820;fm_@80`l?30P35aLD20;jn_P80/K6a0`2^
[Zh20:^[Z`80]KFe0P2ZZZX20:^[Z`80Z:RX0`2:RXX206IVIP80F5QH0P1bLW8209NGU`80Z:RX0`2A
TI4408B4Q080UiNG0P25QHD207EeM@80LW9b0`1SHf<206a/K080OWin0P1/K6`20820P080Q8B40`2:
RXX209:BTP80Shn?0P2UYJD208f=S@80KFe]0`1<C4`205=CD`80DE5A0P1[Jf/20:>SX`80Z:RX0`2Q
XJ420:b/[080X:2P0P2ATI420:>SX`80/k>c0P2SXj<309fMW@80TI6A0P20P80208Z:RP80K6a/0P1V
IVH307MgM`80Jf][0P1EEED204a<C080ADE51@0l?3`204E5A@804A4A100;2`/200d=3@<092@T0P0f
=SH204E5A@80EEEE1?ooool1o`00000000Co0000oooooooooooooooo1P0A4A4300d=3@802`/;0P0=
3@d401DE5@804A4A0`0K6a/202PX:0@0:RXZ0P0o?cl203Hf=P<0@T920P1MGEd208R8R080RHV90P1/
K6`2069RHP<0ADE50P0l?3`2055AD@80CTi>0P1HF5P207MgM`80WIfM0`32`/820=;BdP80alO70P2H
V9P208Z:RP80PH610`29RHT208F5Q@80PH610P28R8P208B4Q080NGUi0`1RHV8205QHF080FUYJ0P1d
M7@20:6QX@80YJFU0`2CTi<206e]K@80L71`0P1jNWX207AdM080IVIV0P1RHV8305YJFP80DE5A0P1N
GUh206QXJ080I6AT0P1bLW830820P080NGUi0P2KVi/20;>c/`80WIfM0P1oOgl3069RHP80CTi>0P1d
M7@207IfMP80P8200P1lO7`30820P080QXJ60P1iNGT207EeM@80RXZ:0P2CTi<20:JVYP<0XZ:R0P2W
YjL207UiN@@0KFe]0P1/K6`307IfMP80C4a<0P0o?cl203<c<`80>3Ph0P12@T83051@D080De=C0P0o
?cl2014A4@@03@d=0`0;2`/201LG5`808R8R0P0k>c/4ooooo`7o000000001?l0003ooooooooooooo
ool6014A4@<03@d=0P0;2`/200d=3@@05ADE0P0A4A4301/K6`80:2PX100Z:RX203lo?`80=SHf0`12
@T8205eMG@80R8R80P29RHT206a/K080HV9R0`15ADD203`l?080DE5A0P1>CTh205QHF080MgMg0P2M
WId30<;2`P80d];B0P37alL209RHV080RXZ:0P21PH4308V9R@80QHF50P21PH4208R8R080Q8B40P1i
NGT3069RHP80F5QH0P1JFUX207AdM080XJ6Q0P2UYJD309>CT`80KFe]0P1`L70207YjNP80M7Ad0P1V
IVH2069RHP<0FUYJ0P1ADE4205iNGP80J6QX0P1TI6@2079bLP<0P8200P1iNGT209^KV`80/k>c0P2M
WId207moO`<0HV9R0P1>CTh207AdM080MWIf0P20P80207alO0<0P8200P26QXH207UiN@80MGEe0P2:
RXX209>CT`80YZJV0`2RXZ820:NWY`80NGUi101]KFd206a/K0<0MWIf0P1<C4`203lo?`80<c<c0P0h
>3P20492@P<0D51@0P1CDe<203lo?`804A4A100=3@d300/;2`805aLG0P0R8R8203/k>`Cooooo0Ol0
00000004o`000?ooooooooooooooo`805aLG0P0A4A4200/;2`T03@d=0P0E5AD5014A4@@06a/K0P0f
=SH204E5A@80<c<c0`0h>3P2075aL@80Ogmo0P1]KFd205EEE@80GEeM0`19BDT2051@D080C4a<0P1@
D50206IVIP80RHV90P39bLT30=_Kf`80`l?30P2VYZH208j>SP80M7Ad0P1NGUh305aLG080GEeM0P1Q
HF4207IfMP80KFe]0P1RHV8304i>CP80>3Ph0P1EEED207moO`80WYjN0P2KVi/308f=S@80Jf][0P1S
Hf<2069RHP80GEeM0P1LG5`205EEE@<0De=C0P19BDT205iNGP80Hf=S0P1GEeL205iNGP<0LW9b0P1g
MgL208J6QP80TY:B0P2RXZ8208V9R@<0G5aL0P12@T8205YJFP80Hf=S0P1TI6@505iNGP80I6AT0P1R
HV8205aLG080KFe]0P1aLG4207EeM@<0SHf=0P2HV9P209JFUP80RHV90P1fMWH206IVIP<0KFe]0P1E
EED20492@P80>3Ph0P15ADD203/k>`<0=SHf0P0c<c<203`l?08092@T100=3@d301DE5@804A4A0P0K
6a/203Ph>0Cooooo0Ol000000004o`000?ooooooooooooooo`805aLG0P0A4A4200/;2`T03@d=0P0E
5AD5014A4@@06a/K0P0f=SH204E5A@80<c<c0`0h>3P2075aL@80Ogmo0P1]KFd205EEE@80GEeM0`19
BDT2051@D080C4a<0P1@D50206IVIP80RHV90P39bLT30=_Kf`80`l?30P2VYZH208j>SP80M7Ad0P1N
GUh305aLG080GEeM0P1QHF4207IfMP80KFe]0P1RHV8304i>CP80>3Ph0P1EEED207moO`80WYjN0P2K
Vi/308f=S@80Jf][0P1SHf<2069RHP80GEeM0P1LG5`205EEE@<0De=C0P19BDT205iNGP80Hf=S0P1G
EeL205iNGP<0LW9b0P1gMgL208J6QP80TY:B0P2RXZ8208V9R@<0G5aL0P12@T8205YJFP80Hf=S0P1T
I6@505iNGP80I6AT0P1RHV8205aLG080KFe]0P1aLG4207EeM@<0SHf=0P2HV9P209JFUP80RHV90P1f
MWH206IVIP<0KFe]0P1EEED20492@P80>3Ph0P15ADD203/k>`<0=SHf0P0c<c<203`l?08092@T100=
3@d301DE5@804A4A0P0K6a/203Ph>0Cooooo0Ol000000004o`000?ooooooooooooooo`805aLG0P0A
4A4200/;2`T03@d=0P0E5AD5014A4@@06a/K0P0f=SH204E5A@80<c<c0`0h>3P2075aL@80Ogmo0P1]
KFd205EEE@80GEeM0`19BDT2051@D080C4a<0P1@D50206IVIP80RHV90P39bLT30=_Kf`80`l?30P2V
YZH208j>SP80M7Ad0P1NGUh305aLG080GEeM0P1QHF4207IfMP80KFe]0P1RHV8304i>CP80>3Ph0P1E
EED207moO`80WYjN0P2KVi/308f=S@80Jf][0P1SHf<2069RHP80GEeM0P1LG5`205EEE@<0De=C0P19
BDT205iNGP80Hf=S0P1GEeL205iNGP<0LW9b0P1gMgL208J6QP80TY:B0P2RXZ8208V9R@<0G5aL0P12
@T8205YJFP80Hf=S0P1TI6@505iNGP80I6AT0P1RHV8205aLG080KFe]0P1aLG4207EeM@<0SHf=0P2H
V9P209JFUP80RHV90P1fMWH206IVIP<0KFe]0P1EEED20492@P80>3Ph0P15ADD203/k>`<0=SHf0P0c
<c<203`l?08092@T100=3@d301DE5@804A4A0P0K6a/203Ph>0Cooooo0Ol000000004o`000?oooooo
ooooooooo`@04A4A1`0=3@d800/;2`<04A4A0P0E5AD201LG5`80>3Ph1`11@D4207YjNP80MGEe0P1N
GUh2069RHP80EEEE0`16ATH404E5A@80K6a/0P2;Rh/208n?S`80d];B0`2m_Kd209>CT`80M7Ad0P19
BDT20492@P80ATI60`1GEeL205iNGP80D51@0P0c<c<202XZ:P8092@T0`0a<C42028R8P80De=C0P2B
TY8209fMW@80RHV90`1bLW8205aLG080EeMG0P1EEED4055AD@80D51@0`16ATH205=CD`80GUiN0P1H
F5P2069RHP80F5QH0`1]KFd206a/K080M7Ad0P20P80209RHV080WIfM0`1TI6@20492@P806a/K0P0X
:2P20451@@80C4a<0`1ADE4204E5A@80ATI60P1>CTh204U9B@80De=C0P1JFUX306QXJ080MgMg0P2;
Rh/20:>SX`80TY:B0P1jNWX3065QH@80C4a<0P15ADD20492@P80@D510P16ATH3051@D080?3`l0P0]
;Bd2028R8P805aLG2@0A4A4202XZ:PCooooo0Ol000000004o`000?ooooooooooooooo`@04A4A1`0=
3@d800/;2`<04A4A0P0E5AD201LG5`80>3Ph1`11@D4207YjNP80MGEe0P1NGUh2069RHP80EEEE0`16
ATH404E5A@80K6a/0P2;Rh/208n?S`80d];B0`2m_Kd209>CT`80M7Ad0P19BDT20492@P80ATI60`1G
EeL205iNGP80D51@0P0c<c<202XZ:P8092@T0`0a<C42028R8P80De=C0P2BTY8209fMW@80RHV90`1b
LW8205aLG080EeMG0P1EEED4055AD@80D51@0`16ATH205=CD`80GUiN0P1HF5P2069RHP80F5QH0`1]
KFd206a/K080M7Ad0P20P80209RHV080WIfM0`1TI6@20492@P806a/K0P0X:2P20451@@80C4a<0`1A
DE4204E5A@80ATI60P1>CTh204U9B@80De=C0P1JFUX306QXJ080MgMg0P2;Rh/20:>SX`80TY:B0P1j
NWX3065QH@80C4a<0P15ADD20492@P80@D510P16ATH3051@D080?3`l0P0];Bd2028R8P805aLG2@0A
4A4202XZ:PCooooo0Ol000000004o`000?ooooooooooooooo`/03@d=100;2`/400L71`<02`/;0P0=
3@d202@T9080>3Ph0P0c<c<204I6AP<0F5QH0P1[Jf/207UiN@80LW9b0P1MGEd2055AD@D0ADE50P1N
GUh206ATI080UiNG0P35aLD20;^k^`<0Ogmo0P1MGEd207moO`80QXJ60P2CTi<209RHV0<0Xj>S0P3@
d=020>k^kP80d=3@0P0l?3`200L71`D0<c<c0P1HF5P208n?S`80RXZ:0P1eMGD305MGE`80@T920P15
ADD204i>CP80D51@0P0o?cl204U9B@<0GUiN0P1CDe<205YJFP80G5aL0P1EEED205MGE`<0GEeM0P1C
De<206IVIP80R8R80P2BTY8209RHV0<0LG5a0P1<C4`200/;2`805aLG0P0A4A4501/K6`80:RXZ0P0o
?cl403/k>`80:RXZ0P0];Bd303`l?080F5QH0P1`L70208J6QP80SHf=0P2GUiL307MgM`80Jf][0P1H
F5P204U9B@80=SHf0P0Z:RX3034a<@80=SHf0P0];Bd203/k>`80:RXZ0P0E5AD501LG5`806a/K0P0T
92@4ooooo`7o000000001?l0003oooooooooooooool;00d=3@@02`/;10071`L300/;2`803@d=0P0T
92@203Ph>080<c<c0P16ATH305QHF080Jf][0P1iNGT2079bLP80GEeM0P1ADE4504E5A@80GUiN0P1T
I6@209NGU`80aLG50P2k^k/307moO`80GEeM0P1oOgl208J6QP80Ti>C0P2HV9P30:>SX`80d=3@0P3^
k^h20=3@d080?3`l0P071`L503<c<`80F5QH0P2?Shl208Z:RP80MGEe0`1GEeL20492@P80ADE50P1>
CTh2051@D080?clo0P19BDT305iNGP80De=C0P1JFUX205aLG080EEEE0P1GEeL305eMG@80De=C0P1V
IVH208R8R080TY:B0P2HV9P3075aL@80C4a<0P0;2`/201LG5`804A4A1@0K6a/202XZ:P80?clo100k
>c/202XZ:P80;Bd]0`0l?3`205QHF080L71`0P26QXH208f=S@80UiNG0`1gMgL206][J`80F5QH0P19
BDT203Hf=P80:RXZ0`0a<C4203Hf=P80;Bd]0P0k>c/202XZ:P805ADE1@0G5aL201/K6`8092@T1?oo
ool1o`00000000Co0000oooooooooooooooo0P0=3@d2014A4@T02`/;0P0A4A4200d=3@D04A4A0P0E
5AD2034a<@80>c/k0P1<C4`20492@P<0J6QX0P1eMGD206IVIP@0HF5Q0P1HF5P3065QH@80FUYJ0P1i
NGT207moO`80];Bd0P2m_Kd2071`L0<0ADE50P2e]KD20;Jf]P80O7al0P0a<C4201DE5@<0;Bd]0P2L
W9`20>3Ph080[Zj^0P15ADD200L71`<05ADE0P1@D50207IfMP80QHF50P1bLW8205iNGP<0De=C0P11
@D4203lo?`H0@T920P1@D50305aLG080EeMG0P1<C4`205=CD`80FUYJ0P1>CTh304a<C080De=C0P1X
J6P207inOP80SXj>0P2PX:0308^;R`80CTi>100A4A4400/;2`<0I6AT0P35aLD20>3Ph080gMgM0P2k
^k/20:NWY`80Ogmo0`12@T82034a<@80ADE50P1aLG4208B4Q080SXj>0`2ATI4206ATI080L71`0P1J
FUX203Hf=P80;Bd]0`0f=SH202d];@@0<C4a0P0T92@701LG5`806a/K0P0G5aL4ooooo`7o00000000
1?l0003oooooooooooooool200d=3@804A4A2@0;2`/2014A4@803@d=1@0A4A4201DE5@80<C4a0P0k
>c/204a<C080@T920`1XJ6P207EeM@80IVIV101QHF4205QHF0<0HF5Q0P1JFUX207UiN@80Ogmo0P2d
];@20;fm_@80L71`0`15ADD20;Fe]@80][Jf0P1lO7`2034a<@805ADE0`0];Bd209bLW080h>3P0P2^
[Zh204E5A@801`L70`0E5AD2051@D080MWIf0P25QHD2079bLP80GUiN0`1CDe<20451@@80?clo1P12
@T82051@D0<0G5aL0P1GEeL204a<C080De=C0P1JFUX204i>CP<0C4a<0P1CDe<206QXJ080OWin0P2>
SXh20:2PX0<0Rh^;0P1>CTh4014A4@@02`/;0`1TI6@20<G5a@80h>3P0P3MgMd20;^k^`80YjNW0P1o
Ogl30492@P80<C4a0P15ADD2075aL@80Q8B40P2>SXh3096AT@80I6AT0P1`L70205YJFP80=SHf0P0]
;Bd303Hf=P80;Bd]100a<C4202@T90L05aLG0P0K6a/201LG5`Cooooo0Ol000000004o`000?oooooo
ooooooooo`803@d=0P0A4A4900/;2`804A4A0P0=3@d5014A4@805ADE0P0a<C4203/k>`80C4a<0P12
@T8306QXJ080MGEe0P1VIVH4065QH@80F5QH0`1QHF4205YJFP80NGUi0P1oOgl20;Bd]080_Kfm0P1`
L70304E5A@80]KFe0P2f][H207alO080<C4a0P0E5AD302d];@80W9bL0P3Ph>020:j^[P80ADE50P07
1`L301DE5@80D51@0P1fMWH208F5Q@80LW9b0P1NGUh305=CD`80@D510P0o?cl60492@P80D51@0`1L
G5`205MGE`80C4a<0P1CDe<205YJFP80CTi>0`1<C4`205=CD`80J6QX0P1nOWh208j>SP80X:2P0`2;
Rh/204i>CP@04A4A100;2`/306ATI080aLG50P3Ph>020=gMg@80^k^k0P2WYjL207moO`<0@T920P0a
<C4204E5A@80LG5a0P24Q8@208j>SP<0TI6A0P1TI6@2071`L080FUYJ0P0f=SH202d];@<0=SHf0P0]
;Bd4034a<@8092@T1`0G5aL201/K6`805aLG1?ooool1o`00000000Co0000oooooooooooooooo0P07
1`L200d=3@804A4A3@0;2`/3014A4@803@d=0P0Z:RX204U9B@80F5QH0P16ATH506e]K@80HF5Q0P1A
DE4206IVIP80DE5A0`1HF5P207AdM080Rh^;0P2PX:020:b/[080QXJ60P16ATH309RHV080/k>c0P1e
MGD201LG5`801`L71@030`<2028R8P80KFe]0P0f=SH201DE5@80:2PX0`0l?3`2079bLP80L71`0P1d
M7@2069RHP80FUYJ0`16ATH20492@P80>c/k0P16ATH20451@@80@T920P19BDT3055AD@80C4a<0P19
BDT20492@P80?clo0P1>CTh30492@P80D51@0P1SHf<206][J`80MWIf0P2>SXh307inOP80F5QH0P0K
6a/400<30`805aLG0`2c/k<20=cLg080alO70P2UYJD208R8R080UYJF0P2c/k<30<G5a@80QXJ60P0]
;Bd204a<C080K6a/0P1oOgl308V9R@80MGEe0P1VIVH207AdM080D51@0P0h>3P303`l?080;Bd]0P0T
92@203/k>`8092@T0P0E5AD301LG5`805ADE0P0A4A4201DE5@Cooooo0Ol000000004o`000?oooooo
ooooooooo`801`L70P0=3@d2014A4@d02`/;0`0A4A4200d=3@80:RXZ0P19BDT205QHF080ATI61@1]
KFd2065QH@80DE5A0P1VIVH2055AD@<0F5QH0P1dM7@208^;R`80X:2P0P2/[:`208J6QP80ATI60`2H
V9P20;>c/`80MGEe0P0G5aL200L71`D00`<30P0R8R8206e]K@80=SHf0P0E5AD202PX:0<0?3`l0P1b
LW82071`L080M7Ad0P1RHV8205YJFP<0ATI60P12@T8203/k>`80ATI60P11@D420492@P80BDU90`1A
DE4204a<C080BDU90P12@T8203lo?`80CTi>0`12@T82051@D080Hf=S0P1[Jf/207IfMP80SXj>0`1n
OWh205QHF0806a/K10030`<201LG5`<0/k>c0P3Lg=`20<O7a`80YJFU0P28R8P209JFUP80/k>c0`35
aLD208J6QP80;Bd]0P1<C4`206a/K080Ogmo0`29RHT207EeM@80IVIV0P1dM7@2051@D080>3Ph0`0l
?3`202d];@8092@T0P0k>c/202@T90805ADE0`0G5aL201DE5@804A4A0P0E5AD4ooooo`7o00000000
1?l0003oooooooooooooool200<30`802`/;0P0=3@d3014A4@@02`/;0P071`L200<30`802`/;0`0A
4A4203<c<`80@T920P1`L70205eMG@80CTi>0`1NGUh205eMG@@0F5QH0P1EEED2055AD@<0F5QH0P1l
O7`208B4Q080YJFU0P2;Rh/204E5A@80HV9R0`2=SHd204I6AP803@d=0P030`<2000000800`<30`07
1`L200d=3@805ADE0P0c<c<20492@P80CTi>0`1MGEd406e]K@80FUYJ0P1CDe<203`l?0<0ATI60P0a
<C4204U9B@80@T920P0k>c/204a<C080?clo0`1JFUX205EEE@80@T920P1EEED20492@P80?clo0`0c
<c<20492@P80?clo0P1LG5`206ATI080K6a/0`1RHV8206IVIP80?clo0P0E5AD200<30`801`L70`11
@D420:JVYP80Rh^;0P1ADE4401DE5@80I6AT0`2CTi<20=3@d080[:b/0P12@T8204E5A@80OWin0`2C
Ti<208R8R080NWYj0P1QHF4205YJFP80CTi>0`0l?3`203Ph>080?clo0P0a<C4202@T90D08R8R0P0]
;Bd202@T90808R8R1?ooool1o`00000000Co0000oooooooooooooooo0P030`<200/;2`803@d=0`0A
4A4400/;2`801`L70P030`<200/;2`<04A4A0P0c<c<20492@P80L71`0P1MGEd204i>CP<0GUiN0P1M
GEd405QHF080EEEE0P1ADE4305QHF080O7al0P24Q8@20:FUY@80Rh^;0P15ADD2069RHP<0SHf=0P16
ATH200d=3@800`<30P00000200<30`<01`L70P0=3@d201DE5@80<c<c0P12@T8204i>CP<0GEeM101]
KFd205YJFP80De=C0P0l?3`304I6AP80<C4a0P19BDT20492@P80>c/k0P1<C4`203lo?`<0FUYJ0P1E
EED20492@P80EEEE0P12@T8203lo?`<0<c<c0P12@T8203lo?`80G5aL0P1TI6@206a/K0<0HV9R0P1V
IVH203lo?`805ADE0P030`<200L71`<0@D510P2VYZH208^;R`80DE5A100E5AD206ATI0<0Ti>C0P3@
d=020:b/[080@T920P15ADD207inOP<0Ti>C0P28R8P207YjNP80HF5Q0P1JFUX204i>CP<0?3`l0P0h
>3P203lo?`80<C4a0P0T92@5028R8P80;Bd]0P0T92@2028R8PCooooo0Ol000000004o`000?oooooo
ooooooooo`801`L70P030`<200L71`<04A4A200;2`/200d=3@<08R8R0P0a<C4203`l?080GEeM0P1J
FUX205MGE`<0MGEe0P1RHV8204i>CP80D51@0P1>CTh205aLG0<0LG5a0P2;Rh/208n?S`80Rh^;0P0o
?cl2034a<@80Hf=S0`12@T82014A4@@00`<30P071`L200d=3@<05ADE0P0a<C4204a<C080FUYJ0P1H
F5P205eMG@<0FUYJ0P19BDT204a<C080>3Ph0P0o?cl202d];@D0<C4a1P0o?cl204i>CP80BDU90`15
ADD205EEE@80BDU90P1GEeL205EEE@80CTi>0`0k>c/203<c<`80>c/k101@D50205EEE@<0HV9R0P1J
FUX204a<C080?3`l0P0];Bd201LG5`<03@d=0P0E5AD2028R8P801`L70P030`<2000000800`<30`0Z
:RX208^;R`80`<300P2XZ:P20451@@80De=C0`2VYZH209:BTP80QHF50P1LG5`204i>CP80DE5A0`1G
EeL403Hf=P80;Bd]0P0Z:RX2028R8P<092@T1P0Z:RX4ooooo`7o000000001?l0003ooooooooooooo
ool200L71`800`<30P071`L3014A4@P02`/;0P0=3@d3028R8P80<C4a0P0l?3`205eMG@80FUYJ0P1G
EeL307EeM@80HV9R0P1>CTh2051@D080CTi>0P1LG5`3075aL@80Rh^;0P2?Shl208^;R`80?clo0P0a
<C4206=SH`<0@T920P0A4A4400<30`801`L70P0=3@d301DE5@80<C4a0P1<C4`205YJFP80F5QH0P1M
GEd305YJFP80BDU90P1<C4`203Ph>080?clo0P0];Bd5034a<@H0?clo0P1>CTh204U9B@<0ADE50P1E
EED204U9B@80EeMG0P1EEED204i>CP<0>c/k0P0c<c<203/k>`@0D51@0P1EEED3069RHP80FUYJ0P1<
C4`203`l?080;Bd]0P0G5aL300d=3@805ADE0P0R8R8200L71`800`<30P00000200<30`<0:RXZ0P2;
Rh/20<30`080Z:RX0P11@D4205=CD`<0YZJV0P2BTY8208F5Q@80G5aL0P1>CTh2055AD@<0EeMG100f
=SH202d];@80:RXZ0P0R8R8302@T90H0:RXZ1?ooool1o`00000000Co0000oooooooooooooooo0P07
1`L200<30`801`L70`0A4A4800/;2`803@d=0`0R8R82034a<@80?3`l0P1MGEd205YJFP80EeMG0`1e
MGD2069RHP80CTi>0P1@D50204i>CP80G5aL0`1aLG4208^;R`80Shn?0P2;Rh/203lo?`80<C4a0P1S
Hf<30492@P804A4A10030`<200L71`803@d=0`0E5AD2034a<@80C4a<0P1JFUX205QHF080GEeM0`1J
FUX204U9B@80C4a<0P0h>3P203lo?`80;Bd]1@0a<C4603lo?`80CTi>0P19BDT304E5A@80EEEE0P19
BDT205MGE`80EEEE0P1>CTh303/k>`80<c<c0P0k>c/4051@D080EEEE0`1RHV8205YJFP80C4a<0P0l
?3`202d];@805aLG0`0=3@d201DE5@808R8R0P071`L200<30`8000000P030`<302XZ:P80Rh^;0P30
`<020:RXZ080@D510P1CDe<30:JVYP80TY:B0P25QHD205aLG080CTi>0P1ADE4305MGE`@0=SHf0P0]
;Bd202XZ:P808R8R0`0T92@602XZ:PCooooo0Ol000000004o`000?ooooooooooooooo`800`<31000
000900/;2`801`L71@0;2`/2028R8P80?clo0P1<C4`2055AD@80J6QX0`1RHV8205aLG080EeMG0P1A
DE42051@D080MgMg0`2ATI4209:BTP80RHV90P1aLG4203/k>`80@T920P1MGEd303<c<`80:RXZ0P0R
8R8203`l?080EEEE0P1]KFd305YJFP80HV9R0P1<C4`2055AD@80@T920P1>CTh3055AD@80?3`l0P0h
>3P202d];@80<C4a0P0];Bd30492@P80>c/k0P0l?3`203/k>`80=SHf0P1>CTh203lo?`<0@D510P1G
EeL20492@P80ADE50P19BDT205=CD`<0ADE50P0a<C420451@@80?clo0P0k>c/205=CD`<0CTi>0P19
BDT205=CD`80EeMG0P1>CTh205=CD`<0<C4a0P0E5AD200/;2`801`L71P030`<300000080<C4a0P1S
Hf<207YjNP80MgMg0P0f=SH307IfMP80XZ:R0P2SXj<208J6QP80MWIf0P1CDe<303Ph>080?3`l0P0a
<C4203Hf=P80;Bd]1`0T92@202d];@80:RXZ1?ooool1o`00000000Co0000oooooooooooooooo0P03
0`<4000000T02`/;0P071`L500/;2`808R8R0P0o?cl204a<C080DE5A0P1XJ6P3069RHP80G5aL0P1G
EeL2055AD@80D51@0P1gMgL3096AT@80TY:B0P29RHT2075aL@80>c/k0P12@T8205eMG@<0<c<c0P0Z
:RX2028R8P80?3`l0P1EEED206e]K@<0FUYJ0P1RHV8204a<C080DE5A0P12@T8204i>CP<0DE5A0P0l
?3`203Ph>080;Bd]0P0a<C4202d];@<0@T920P0k>c/203`l?080>c/k0P0f=SH204i>CP80?clo0`11
@D4205MGE`80@T920P15ADD204U9B@80De=C0`15ADD2034a<@80@D510P0o?cl203/k>`80De=C0`1>
CTh204U9B@80De=C0P1GEeL204i>CP80De=C0`0a<C4201DE5@802`/;0P071`L600<30`<000000P0a
<C4206=SH`80NWYj0P1gMgL203Hf=P<0MWIf0P2RXZ820:>SX`80QXJ60P1fMWH205=CD`<0>3Ph0P0l
?3`2034a<@80=SHf0P0];Bd702@T9080;Bd]0P0Z:RX4ooooo`7o000000001?l0003ooooooooooooo
ool200L71`L00`<3100=3@d600L71`<03@d=0P0G5aL204E5A@80DE5A0P1<C4`2069RHP<0J6QX0P1H
F5P205MGE`80BDU90P1ADE4206QXJ0<0LG5a0P24Q8@208R8R080G5aL0P0o?cl404U9B@L0>3Ph0P1R
HV8206ATI080L71`0`1[Jf/205aLG080De=C0P0k>c/20492@P80BDU90`0o?cl203Ph>0@0;Bd]0P0Z
:RX202d];@<0=SHf0P0a<C42051@D080?3`l0P0h>3P205=CD`D0>c/k0P1GEeL2051@D080>3Ph0P1@
D50204I6AP<0@D510P16ATH20451@@80?3`l0P0a<C4203lo?`<0BDU90P1>CTh20492@P80BDU90P15
ADD205MGE`<0FUYJ0P12@T8203<c<`808R8R100A4A4200/;2`<00`<30P0A4A4204U9B@80FUYJ0P1[
Jf/20451@@<0D51@0P1jNWX208V9R@80RXZ:0P24Q8@2065QH@<0BDU90P12@T8202d];@H0:RXZ0`0K
6a/2028R8P8092@T0P0a<C44ooooo`7o000000001?l0003oooooooooooooool200L71`L00`<3100=
3@d600L71`<03@d=0P0G5aL204E5A@80DE5A0P1<C4`2069RHP<0J6QX0P1HF5P205MGE`80BDU90P1A
DE4206QXJ0<0LG5a0P24Q8@208R8R080G5aL0P0o?cl404U9B@L0>3Ph0P1RHV8206ATI080L71`0`1[
Jf/205aLG080De=C0P0k>c/20492@P80BDU90`0o?cl203Ph>0@0;Bd]0P0Z:RX202d];@<0=SHf0P0a
<C42051@D080?3`l0P0h>3P205=CD`D0>c/k0P1GEeL2051@D080>3Ph0P1@D50204I6AP<0@D510P16
ATH20451@@80?3`l0P0a<C4203lo?`<0BDU90P1>CTh20492@P80BDU90P15ADD205MGE`<0FUYJ0P12
@T8203<c<`808R8R100A4A4200/;2`<00`<30P0A4A4204U9B@80FUYJ0P1[Jf/20451@@<0D51@0P1j
NWX208V9R@80RXZ:0P24Q8@2065QH@<0BDU90P12@T8202d];@H0:RXZ0`0K6a/2028R8P8092@T0P0a
<C44ooooo`7o000000001?l0003oooooooooooooool400<30`D000001P0;2`/200L71`802`/;0`0E
5AD202d];@80EEEE101ADE4206QXJ0<0GEeM0P1aLG4206a/K080L71`0P1VIVH2055AD@<0F5QH0P1A
DE4205MGE`80D51@1011@D4205QHF0<0GEeM0P29RHT2079bLP80IVIV0P1QHF4206ATI0<0IVIV0P1d
M7@205iNGP80De=C0P1NGUh2051@D0<0@D510P0h>3P402d];@8092@T0P0k>c/303<c<`80ATI60P0o
?cl203`l?080F5QH0P1RHV8205iNGP<0EeMG0P1>CTh204U9B@80?clo0P1ADE42051@D0<0DE5A0P12
@T820451@@80=SHf0P0l?3`203<c<`<0?3`l0P19BDT204I6AP80?3`l0P0k>c/204E5A@<0G5aL0P1G
EeL205iNGP80De=C0P1GEeL203Ph>0808R8R0`0G5aL202@T9080=SHf0P1@D50205eMG@80J6QX0`0o
?cl207IfMP80RXZ:0P1nOWh2075aL@80GEeM0`12@T8203/k>`80=SHf0P0];Bd203`l?08092@T0`0K
6a/2014A4@808R8R0P0a<C44ooooo`7o000000001?l0003oooooooooooooool400<30`D000001P0;
2`/200L71`802`/;0`0E5AD202d];@80EEEE101ADE4206QXJ0<0GEeM0P1aLG4206a/K080L71`0P1V
IVH2055AD@<0F5QH0P1ADE4205MGE`80D51@1011@D4205QHF0<0GEeM0P29RHT2079bLP80IVIV0P1Q
HF4206ATI0<0IVIV0P1dM7@205iNGP80De=C0P1NGUh2051@D0<0@D510P0h>3P402d];@8092@T0P0k
>c/303<c<`80ATI60P0o?cl203`l?080F5QH0P1RHV8205iNGP<0EeMG0P1>CTh204U9B@80?clo0P1A
DE42051@D0<0DE5A0P12@T820451@@80=SHf0P0l?3`203<c<`<0?3`l0P19BDT204I6AP80?3`l0P0k
>c/204E5A@<0G5aL0P1GEeL205iNGP80De=C0P1GEeL203Ph>0808R8R0`0G5aL202@T9080=SHf0P1@
D50205eMG@80J6QX0`0o?cl207IfMP80RXZ:0P1nOWh2075aL@80GEeM0`12@T8203/k>`80=SHf0P0]
;Bd203`l?08092@T0`0K6a/2014A4@808R8R0P0a<C44ooooo`7o000000001?l0003ooooooooooooo
ool200<30`8000000P030`<3000000800`<30P0=3@d200L71`802`/;0P0E5AD302XZ:P80>c/k101H
F5P205YJFP80IVIV0`1NGUh2055AD@80BDU90P1GEeL206IVIP80K6a/0`19BDT20451@@80>3Ph0P19
BDT205EEE@80Jf][0P1gMgL308F5Q@80K6a/0P1[Jf/205eMG@80BDU90P1SHf<306QXJ0@0M7Ad0P1S
Hf<205MGE`80DE5A0`19BDT20492@P80:RXZ0P0a<C4202PX:080<C4a0`0o?cl20451@@80ATI60P1>
CTh204a<C080I6AT0P1MGEd305=CD`80ADE50P0l?3`205=CD`80EEEE0P1JFUX504E5A@80>3Ph0P0c
<c<202PX:080=SHf0`0Z:RX203Hf=P@0CTi>0P19BDT204i>CP<0D51@0P1GEeL205QHF080HF5Q0P1N
GUh205aLG080De=C0`19BDT203Ph>080<C4a0P0c<c<404I6AP<092@T0P11@D4205=CD`80C4a<0P1Q
HF4205QHF0<0G5aL0P1CDe<203Ph>080:RXZ0P0c<c<202d];@<05ADE0P0G5aL2028R8P8092@T1?oo
ool1o`00000000Co0000oooooooooooooooo0P030`<2000000800`<30`00000200<30`803@d=0P07
1`L200/;2`805ADE0`0Z:RX203/k>`@0F5QH0P1JFUX206IVIP<0GUiN0P1ADE4204U9B@80EeMG0P1V
IVH206a/K0<0BDU90P11@D4203Ph>080BDU90P1EEED206][J`80MgMg0`25QHD206a/K080Jf][0P1M
GEd204U9B@80Hf=S0`1XJ6P407AdM080Hf=S0P1GEeL2055AD@<0BDU90P12@T8202XZ:P80<C4a0P0X
:2P2034a<@<0?clo0P11@D4204I6AP80CTi>0P1<C4`206ATI080GEeM0`1CDe<204E5A@80?3`l0P1C
De<205EEE@80FUYJ1@15ADD203Ph>080<c<c0P0X:2P203Hf=P<0:RXZ0P0f=SH404i>CP80BDU90P1>
CTh3051@D080EeMG0P1HF5P2065QH@80GUiN0P1LG5`205=CD`<0BDU90P0h>3P2034a<@80<c<c1016
ATH302@T9080@D510P1CDe<204a<C080HF5Q0P1HF5P305aLG080De=C0P0h>3P202XZ:P80<c<c0P0]
;Bd301DE5@805aLG0P0R8R8202@T90Cooooo0Ol000000004o`000?ooooooooooooooo`800`<30P00
000200<30`<000000P030`<200d=3@801`L70P0;2`/201DE5@<0:RXZ0P0k>c/405QHF080FUYJ0P1V
IVH305iNGP80DE5A0P19BDT205MGE`80IVIV0P1/K6`304U9B@80@D510P0h>3P204U9B@80EEEE0P1[
Jf/207MgM`<0QHF50P1/K6`206][J`80GEeM0P19BDT206=SH`<0J6QX101dM7@206=SH`80EeMG0P1A
DE4304U9B@80@T920P0Z:RX2034a<@80:2PX0P0a<C4303lo?`80@D510P16ATH204i>CP80C4a<0P1T
I6@205eMG@<0De=C0P15ADD203`l?080De=C0P1EEED205YJFPD0ADE50P0h>3P203<c<`80:2PX0P0f
=SH302XZ:P80=SHf101>CTh204U9B@80CTi>0`1@D50205MGE`80F5QH0P1QHF4205iNGP80G5aL0P1C
De<304U9B@80>3Ph0P0a<C4203<c<`@0ATI60`0T92@20451@@80De=C0P1<C4`2065QH@80F5QH0`1L
G5`205=CD`80>3Ph0P0Z:RX203<c<`80;Bd]0`0E5AD201LG5`808R8R0P0T92@4ooooo`7o00000000
1?l0003oooooooooooooool200<30`T000000P030`<400d=3@804A4A0`0k>c/205aLG080Hf=S101L
G5`5069RHP80Hf=S0P1JFUX2065QH@80Hf=S0P1LG5`3075aL@80De=C0P1>CTh2051@D080GEeM0P1V
IVH207UiN@<0MWIf0P1MGEd205YJFP80J6QX0P1EEED2055AD@D0Hf=S0P1QHF4205MGE`80EEEE0P1[
Jf/304a<C080CTi>0P0c<c<202d];@80ATI60P11@D4303lo?`80DE5A0P11@D4204E5A@80C4a<0P1T
I6@2065QH@<0D51@0P1JFUX205iNGP80F5QH0P1[Jf/205eMG@<0ADE50P12@T8203<c<`80=SHf0P0h
>3P203Hf=P<092@T0P0a<C4204E5A@80ATI60P1HF5P205iNGP<0EEEE0P1NGUh205aLG080EEEE101J
FUX206=SH`<0HV9R0P1]KFd207YjNP80GUiN0P1>CTh203`l?0<0>c/k0P11@D42055AD@80F5QH0P1V
IVH206QXJ0<0CTi>0P0l?3`20451@@@0>c/k0P0c<c<501LG5`806a/K0P0X:2P4ooooo`7o00000000
1?l0003oooooooooooooool200<30`T000000P030`<400d=3@804A4A0`0k>c/205aLG080Hf=S101L
G5`5069RHP80Hf=S0P1JFUX2065QH@80Hf=S0P1LG5`3075aL@80De=C0P1>CTh2051@D080GEeM0P1V
IVH207UiN@<0MWIf0P1MGEd205YJFP80J6QX0P1EEED2055AD@D0Hf=S0P1QHF4205MGE`80EEEE0P1[
Jf/304a<C080CTi>0P0c<c<202d];@80ATI60P11@D4303lo?`80DE5A0P11@D4204E5A@80C4a<0P1T
I6@2065QH@<0D51@0P1JFUX205iNGP80F5QH0P1[Jf/205eMG@<0ADE50P12@T8203<c<`80=SHf0P0h
>3P203Hf=P<092@T0P0a<C4204E5A@80ATI60P1HF5P205iNGP<0EEEE0P1NGUh205aLG080EEEE101J
FUX206=SH`<0HV9R0P1]KFd207YjNP80GUiN0P1>CTh203`l?0<0>c/k0P11@D42055AD@80F5QH0P1V
IVH206QXJ0<0CTi>0P0l?3`20451@@@0>c/k0P0c<c<501LG5`806a/K0P0X:2P4ooooo`7o00000000
1?l0003oooooooooooooool200<30`8000000P030`<7000000802`/;0P071`L2014A4@<0?clo0P1T
I6@205iNGP80HV9R0P1TI6@2075aL@<0HF5Q0P1NGUh206=SH`80HF5Q0P1aLG4206][J`<0EeMG0P1>
CTh205aLG080MgMg0P1NGUh206=SH`80F5QH0`1LG5`204a<C080D51@0P1LG5`205QHF080HF5Q0`1R
HV8206ATI080EEEE0P1HF5P2075aL@80MGEe1@16ATH203<c<`80?clo0P11@D4204U9B@L0ATI61011
@D42069RHP80Hf=S0`1JFUX4065QH@80EEEE0P1aLG4206a/K0<0ATI60P12@T82034a<@@0;Bd]0P0o
?cl302d];@80=SHf0P12@T8205EEE@80DE5A0P1NGUh306][J`80HV9R0P1EEED204I6AP80De=C0P1>
CTh205YJFP<0GUiN101GEeL205YJFP80D51@0P1<C4`304I6AP80D51@0P19BDT205EEE@@0FUYJ0`1@
D5020451@@80>c/k0P0h>3P203lo?`80<c<c1@0G5aL201/K6`80;Bd]1?ooool1o`00000000Co0000
oooooooooooooooo0P030`<2000000800`<31`00000200/;2`801`L70P0A4A4303lo?`80I6AT0P1N
GUh2069RHP80I6AT0P1aLG43065QH@80GUiN0P1SHf<2065QH@80LG5a0P1[Jf/305MGE`80CTi>0P1L
G5`207MgM`80GUiN0P1SHf<205QHF0<0G5aL0P1<C4`2051@D080G5aL0P1HF5P2065QH@<0HV9R0P1T
I6@205EEE@80F5QH0P1aLG4207EeM@D0ATI60P0c<c<203lo?`80@D510P19BDT704I6AP@0@D510P1R
HV8206=SH`<0FUYJ101QHF4205EEE@80LG5a0P1/K6`304I6AP80@T920P0a<C4402d];@80?clo0`0]
;Bd203Hf=P80@T920P1EEED2055AD@80GUiN0`1[Jf/2069RHP80EEEE0P16ATH205=CD`80CTi>0P1J
FUX305iNGP@0EeMG0P1JFUX2051@D080C4a<0`16ATH2051@D080BDU90P1EEED405YJFP<0D51@0P11
@D4203/k>`80>3Ph0P0o?cl203<c<`D05aLG0P0K6a/202d];@Cooooo0Ol000000004o`000?oooooo
ooooooooo`800`<32@00000200<30`801`L70P0A4A4201LG5`<0D51@0P1LG5`205EEE@80DE5A0P1L
G5`2065QH@<0De=C0P1GEeL206a/K080C4a<0P16ATH205YJFP<0GUiN0P1JFUX205eMG@80C4a<0P1T
I6@205MGE`80J6QX0`1@D50404i>CP80ADE50P1HF5P2071`L0D0Q8B40P1SHf<205iNGP80Hf=S0P1l
O7`305YJFP80ADE50P0h>3P403Hf=P80>c/k0`19BDT204I6AP80C4a<0P12@T8404i>CP80I6AT0`1<
C4`2069RHP80BDU90P1ADE4205YJFP80@T920`11@D4204E5A@80<c<c0P0f=SH203Ph>080?3`l0`0k
>c/203lo?`80ADE50P1TI6@204a<C080D51@0`1NGUh206QXJ080G5aL0P1CDe<204E5A@80D51@0P12
@T8304U9B@80ATI60P1<C4`205=CD`80CTi>0P1HF5P305EEE@@0BDU90P0h>3P203Hf=P80?3`l0`1>
CTh20451@@80BDU90P16ATH203`l?080<C4a0`0R8R8201/K6`808R8R0P0X:2P4ooooo`7o00000000
1?l0003oooooooooooooool200<30`T000000P030`<200L71`804A4A0P0G5aL3051@D080G5aL0P1E
EED2055AD@80G5aL0P1QHF4305=CD`80EeMG0P1/K6`204a<C080ATI60P1JFUX305iNGP80FUYJ0P1M
GEd204a<C080I6AT0P1GEeL206QXJ0<0D51@101>CTh204E5A@80F5QH0P1`L70508B4Q080Hf=S0P1N
GUh206=SH`80O7al0`1JFUX204E5A@80>3Ph100f=SH203/k>`<0BDU90P16ATH204a<C080@T92101>
CTh206ATI0<0C4a<0P1RHV8204U9B@80DE5A0P1JFUX20492@P<0@D510P15ADD203<c<`80=SHf0P0h
>3P203`l?0<0>c/k0P0o?cl204E5A@80I6AT0P1<C4`2051@D0<0GUiN0P1XJ6P205aLG080De=C0P15
ADD2051@D080@T920`19BDT204I6AP80C4a<0P1CDe<204i>CP80F5QH0`1EEED404U9B@80>3Ph0P0f
=SH203`l?0<0CTi>0P11@D4204U9B@80ATI60P0l?3`2034a<@<08R8R0P0K6a/2028R8P80:2PX1?oo
ool1o`00000000Co0000oooooooooooooooo0P030`<9000000800`<30P071`L2014A4@805aLG0`1@
D50205aLG080EEEE0P1ADE4205aLG080HF5Q0`1CDe<205MGE`80K6a/0P1<C4`204I6AP80FUYJ0`1N
GUh205YJFP80GEeM0P1<C4`206ATI080EeMG0P1XJ6P3051@D0@0CTi>0P15ADD205QHF080L71`1@24
Q8@206=SH`80GUiN0P1SHf<207alO0<0FUYJ0P15ADD203Ph>0@0=SHf0P0k>c/304U9B@80ATI60P1<
C4`20492@P@0CTi>0P1TI6@304a<C080HV9R0P19BDT2055AD@80FUYJ0P12@T830451@@80ADE50P0c
<c<203Hf=P80>3Ph0P0l?3`303/k>`80?clo0P15ADD206ATI080C4a<0P1@D50305iNGP80J6QX0P1L
G5`205=CD`80ADE50P1@D5020492@P<0BDU90P16ATH204a<C080De=C0P1>CTh205QHF0<0EEEE1019
BDT203Ph>080=SHf0P0l?3`304i>CP80@D510P19BDT204I6AP80?3`l0P0a<C43028R8P806a/K0P0R
8R8202PX:0Cooooo0Ol000000004o`000?ooooooooooooooo`800`<32@00000200<30`801`L70P0E
5AD202d];@<0BDU90P1CDe<204U9B@80D51@0P1<C4`204i>CP<0?clo0P1>CTh405iNGP80EeMG0P1H
F5P306e]K@80LG5a0P1bLW8205iNGP80F5QH0P1RHV8205=CD`<0D51@0P1EEED205QHF080I6AT0P1G
EeL2065QH@<0MGEe0P1QHF4205MGE`80L71`0P21PH42071`L0D0De=C0P0k>c/20451@@80ATI60P0a
<C4303Hf=P80ADE50P1EEED204i>CP80D51@0P1ADE4206ATI0<0G5aL0P1NGUh204E5A@@0EeMG0P19
BDT303lo?`80>3Ph0P0Z:RX40451@@80ADE50`0h>3P204I6AP80D51@0P1]KFd205MGE`80ADE50`1C
De<2069RHP80F5QH0P1@D50205iNGP80D51@0P16ATH30451@@80BDU90P0o?cl205=CD`80C4a<0P0o
?cl304I6AP80D51@0P16ATH204a<C080@T920P1<C4`305=CD`80@D510P19BDT204I6AP80@D510P0k
>c/302d];@808R8R0P0T92@202PX:0Cooooo0Ol000000004o`000?ooooooooooooooo`800`<32@00
000200<30`801`L70P0E5AD202d];@<0BDU90P1CDe<204U9B@80D51@0P1<C4`204i>CP<0?clo0P1>
CTh405iNGP80EeMG0P1HF5P306e]K@80LG5a0P1bLW8205iNGP80F5QH0P1RHV8205=CD`<0D51@0P1E
EED205QHF080I6AT0P1GEeL2065QH@<0MGEe0P1QHF4205MGE`80L71`0P21PH42071`L0D0De=C0P0k
>c/20451@@80ATI60P0a<C4303Hf=P80ADE50P1EEED204i>CP80D51@0P1ADE4206ATI0<0G5aL0P1N
GUh204E5A@@0EeMG0P19BDT303lo?`80>3Ph0P0Z:RX40451@@80ADE50`0h>3P204I6AP80D51@0P1]
KFd205MGE`80ADE50`1CDe<2069RHP80F5QH0P1@D50205iNGP80D51@0P16ATH30451@@80BDU90P0o
?cl205=CD`80C4a<0P0o?cl304I6AP80D51@0P16ATH204a<C080@T920P1<C4`305=CD`80@D510P19
BDT204I6AP80@D510P0k>c/302d];@808R8R0P0T92@202PX:0Cooooo0Ol000000004o`000?oooooo
ooooooooo`/0000010030`<2014A4@80@T920`1>CTh204I6AP80BDU90P1GEeL2051@D080ATI61@1@
D50205eMG@80EeMG0P1MGEd206QXJ0<0M7Ad0P1fMWH205QHF080FUYJ0P1EEED2065QH@80GEeM0`15
ADD2051@D080Jf][0P1SHf<205YJFP80G5aL0`1[Jf/207AdM080I6AT0P1SHf<208B4Q080LG5a0`1Q
HF4204U9B@80EEEE0P16ATH40451@@<0<c<c0P0o?cl204i>CP80Jf][0P1ADE4205YJFP80I6AT1@1b
LW8206=SH`80FUYJ0P19BDT204I6AP<0CTi>0P15ADD203/k>`80>3Ph0P12@T8503`l?080CTi>0P1H
F5P2071`L080G5aL0P1<C4`304I6AP80GEeM0P1ADE420492@P80>c/k0P0h>3P203lo?`<0@D510P0h
>3P203/k>`80=SHf0P0k>c/204I6AP<0@T920P19BDT20451@@80CTi>0P1ADE4205YJFP<0DE5A1019
BDT203/k>`80BDU90P12@T8303<c<`@092@T0P0];Bd4ooooo`7o000000001?l0003ooooooooooooo
ool;000000@00`<30P0A4A420492@P<0CTi>0P16ATH204U9B@80EeMG0P1@D50204I6APD0D51@0P1M
GEd205MGE`80GEeM0P1XJ6P307AdM080MWIf0P1HF5P205YJFP80EEEE0P1QHF4205eMG@<0ADE50P1@
D50206][J`80Hf=S0P1JFUX205aLG0<0Jf][0P1dM7@206ATI080Hf=S0P24Q8@2075aL@<0HF5Q0P19
BDT205EEE@80ATI61011@D4303<c<`80?clo0P1>CTh206][J`80DE5A0P1JFUX206ATI0D0LW9b0P1S
Hf<205YJFP80BDU90P16ATH304i>CP80ADE50P0k>c/203Ph>080@T921@0l?3`204i>CP80F5QH0P1`
L70205aLG080C4a<0`16ATH205eMG@80DE5A0P12@T8203/k>`80>3Ph0P0o?cl30451@@80>3Ph0P0k
>c/203Hf=P80>c/k0P16ATH30492@P80BDU90P11@D4204i>CP80DE5A0P1JFUX3055AD@@0BDU90P0k
>c/204U9B@80@T920`0c<c<402@T9080;Bd]1?ooool1o`00000000Co0000oooooooooooooooo2`00
000200<30`801`L70P0T92@204U9B@<0EeMG0P1HF5P205MGE`80FUYJ0P1HF5P2055AD@D0EEEE0P1N
GUh20451@@80DE5A0P1CDe<306ATI080LG5a0P1`L70206][J`80GEeM0P1GEeL205QHF0<0CTi>0P1@
D50205=CD`80EeMG0P1QHF4207AdM0<0Ogmo0P1gMgL206ATI080Jf][0P1oOgl207UiN@<0F5QH0P1E
EED205eMG@80CTi>0P0o?cl204E5A@<0?clo0P11@D4205EEE@80L71`0P1NGUh2055AD@80GUiN0`1/
K6`205QHF080IVIV0P1ADE4205iNGP80ADE50`1CDe<204I6AP80CTi>0P15ADD204i>CP80@T920`15
ADD205eMG@80I6AT101XJ6P2069RHPD0GEeM0P1HF5P205eMG@80C4a<0P0c<c<203`l?0<0>c/k0P0l
?3`40492@P80?3`l0P1<C4`303`l?0@0C4a<101EEED203`l?0<0>c/k0P11@D4204I6AP80ADE50P1@
D50204i>CP<0ATI60P0a<C4201LG5`80:RXZ1?ooool1o`00000000Co0000oooooooooooooooo2`00
000200<30`801`L70P0T92@204U9B@<0EeMG0P1HF5P205MGE`80FUYJ0P1HF5P2055AD@D0EEEE0P1N
GUh20451@@80DE5A0P1CDe<306ATI080LG5a0P1`L70206][J`80GEeM0P1GEeL205QHF0<0CTi>0P1@
D50205=CD`80EeMG0P1QHF4207AdM0<0Ogmo0P1gMgL206ATI080Jf][0P1oOgl207UiN@<0F5QH0P1E
EED205eMG@80CTi>0P0o?cl204E5A@<0?clo0P11@D4205EEE@80L71`0P1NGUh2055AD@80GUiN0`1/
K6`205QHF080IVIV0P1ADE4205iNGP80ADE50`1CDe<204I6AP80CTi>0P15ADD204i>CP80@T920`15
ADD205eMG@80I6AT101XJ6P2069RHPD0GEeM0P1HF5P205eMG@80C4a<0P0c<c<203`l?0<0>c/k0P0l
?3`40492@P80?3`l0P1<C4`303`l?0@0C4a<101EEED203`l?0<0>c/k0P11@D4204I6AP80ADE50P1@
D50204i>CP<0ATI60P0a<C4201LG5`80:RXZ1?ooool1o`00000000Co0000oooooooooooooooo2`00
000200<30`801`L70P0h>3P2055AD@<0GEeM0P1/K6`205EEE@80C4a<0P1EEED2051@D0<0De=C0P1J
FUX2069RHP80Hf=S0P1QHF4206ATI0<0Q8B40P1iNGT2075aL@80J6QX0P1QHF42069RHP80GUiN0`1H
F5P204I6AP80@D510P1@D50205QHF080GUiN0`1eMGD207moO`80HF5Q0P1dM7@207UiN@80PH610`1L
G5`2055AD@80F5QH0P1@D50404i>CP<0?clo0P12@T8205MGE`80EEEE0P1LG5`205MGE`80Jf][0`1l
O7`2065QH@80Hf=S0P1eMGD206=SH`80De=C0`15ADD203`l?080ATI60P12@T8203`l?080@T920`1@
D50405=CD`80MgMg0P1JFUX206=SH`<0J6QX0P1aLG4205iNGP80HV9R0P1EEED204a<C080?3`l1@0h
>3P2051@D080@D51100o?cl30492@P80?3`l0P0o?cl20492@P80@D510P0k>c/303lo?`80ATI60P1@
D502055AD@80C4a<0P15ADD30451@@80ADE50P0a<C4201DE5@Cooooo0Ol000000004o`000?oooooo
ooooooooo`/000000P030`<200L71`80>3Ph0P1ADE4305eMG@80K6a/0P1EEED204a<C080EEEE0P1@
D50305=CD`80FUYJ0P1RHV8206=SH`80HF5Q0P1TI6@308B4Q080NGUi0P1aLG4206QXJ080HF5Q0P1R
HV8205iNGP<0F5QH0P16ATH20451@@80D51@0P1HF5P205iNGP<0MGEe0P1oOgl2065QH@80M7Ad0P1i
NGT20861P@<0G5aL0P1ADE4205QHF080D51@101>CTh303lo?`80@T920P1GEeL205EEE@80G5aL0P1G
EeL206][J`<0O7al0P1QHF4206=SH`80MGEe0P1SHf<205=CD`<0ADE50P0l?3`204I6AP80@T920P0l
?3`20492@P<0D51@101CDe<207MgM`80FUYJ0P1SHf<306QXJ080LG5a0P1NGUh2069RHP80EEEE0P1<
C4`203`l?0D0>3Ph0P1@D5020451@@@0?clo0`12@T8203`l?080?clo0P12@T820451@@80>c/k0`0o
?cl204I6AP80D51@0P1ADE4204a<C080ADE50`11@D4204E5A@80<C4a0P0E5AD4ooooo`7o00000000
1?l0003oooooooooooooool;000000800`<30P071`L203Ph>080DE5A0`1MGEd206a/K080EEEE0P1<
C4`205EEE@80D51@0`1CDe<205YJFP80HV9R0P1SHf<2065QH@80I6AT0`24Q8@207UiN@80LG5a0P1X
J6P2065QH@80HV9R0P1NGUh305QHF080ATI60P11@D42051@D080F5QH0P1NGUh307EeM@80Ogmo0P1Q
HF4207AdM080NGUi0P21PH4305aLG080DE5A0P1HF5P2051@D0@0CTi>0`0o?cl20492@P80EeMG0P1E
EED205aLG080EeMG0P1[Jf/307alO080HF5Q0P1SHf<207EeM@80Hf=S0P1CDe<304E5A@80?3`l0P16
ATH20492@P80?3`l0P12@T83051@D0@0De=C0P1gMgL205YJFP80Hf=S0`1XJ6P2075aL@80GUiN0P1R
HV8205EEE@80C4a<0P0l?3`503Ph>080D51@0P11@D4403lo?`<0@T920P0l?3`203lo?`80@T920P11
@D4203/k>`<0?clo0P16ATH2051@D080DE5A0P1<C4`204E5A@<0@D510P15ADD2034a<@805ADE1?oo
ool1o`00000000Co0000oooooooooooooooo2`00000200<30`802`/;0P16ATH205iNGP<0HV9R0P1`
L70205aLG080D51@101JFUX305QHF080FUYJ0P12@T8204U9B@80F5QH0P1NGUh3075aL@80Q8B4101M
GEd2055AD@80@D510P1<C4`305MGE`80LW9b0P1TI6@205YJFP80EeMG0P1JFUX308F5Q@80Vi^K0P1/
K6`408R8R080MgMg0`1[Jf/204i>CP80I6AT0P1CDe<20492@P80F5QH0`0o?cl205QHF080K6a/0P1Q
HF42071`L080KFe]0P1NGUh307EeM@80MWIf0P1[Jf/208J6QP80KFe]0P1@D5030451@@80ATI61012
@T8203Ph>080?clo0`1@D50203/k>`80ADE50P1]KFd2069RHP80CTi>0`1<C4`205QHF080D51@0P1<
C4`204I6AP80BDU90P0h>3P303Hf=P80<c<c0P0h>3P203/k>`80?clo0P12@T8304i>CP80BDU90P12
@T8204I6AP80ADE50P1JFUX3055AD@80BDU90P12@T8204I6AP80?clo0P11@D4304E5A@80=SHf0P0c
<c<203`l?0Cooooo0Ol000000004o`000?ooooooooooooooo`/000000P030`<200/;2`80ATI60P1N
GUh3069RHP80L71`0P1LG5`2051@D0@0FUYJ0`1HF5P205YJFP80@T920P19BDT205QHF080GUiN0`1a
LG4208B4Q0@0GEeM0P1ADE420451@@80C4a<0`1GEeL2079bLP80I6AT0P1JFUX205MGE`80FUYJ0`25
QHD209^KV`80K6a/1028R8P207MgM`<0Jf][0P1>CTh206ATI080De=C0P12@T8205QHF0<0?clo0P1H
F5P206a/K080HF5Q0P1`L70206e]K@80GUiN0`1eMGD207IfMP80Jf][0P26QXH206e]K@80D51@0`11
@D4204I6AP@0@T920P0h>3P203lo?`<0D51@0P0k>c/204E5A@80KFe]0P1RHV8204i>CP<0C4a<0P1H
F5P2051@D080C4a<0P16ATH204U9B@80>3Ph0`0f=SH203<c<`80>3Ph0P0k>c/203lo?`80@T920`1>
CTh204U9B@80@T920P16ATH204E5A@80FUYJ0`1ADE4204U9B@80@T920P16ATH203lo?`80@D510`15
ADD203Hf=P80<c<c0P0l?3`4ooooo`7o000000001?l0003oooooooooooooool9000000800`<30P07
1`L2028R8P80CTi>0P1[Jf/305EEE@80FUYJ0P1GEeL205=CD`80HF5Q0P1ADE4304U9B@80?clo0P12
@T8204I6AP80CTi>0P1NGUh305MGE`80EEEE0P1<C4`20492@P80F5QH0P12@T8204i>CP<0FUYJ0P1V
IVH205QHF080FUYJ0P1SHf<20820P0<0Shn?0P2:RXX207EeM@80J6QX0P1SHf<205eMG@<0GUiN0P1V
IVH2079bLP80I6AT0P1ADE4205iNGP<0IVIV0P1NGUh207EeM@80KFe]0P1bLW8208j>SP80L71`0`1/
K6`208J6QP80HF5Q0P1[Jf/207EeM@80GUiN0`1@D5020492@P80C4a<0P0o?cl203`l?080CTi>0`16
ATH205EEE@80ADE50P1QHF4206a/K080EeMG1@1ADE4205=CD`@0C4a<0P1>CTh203/k>`<0?clo0P0l
?3`202d];@80:RXZ0P0f=SH204E5A@<0=SHf0P0h>3P20451@@@0?3`l0P0f=SH304I6AP80ADE50P11
@D4203`l?080CTi>0P0l?3`304U9B@80ATI60P1<C4`20451@@Cooooo0Ol000000004o`000?oooooo
ooooooooo`T000000P030`<200L71`808R8R0P1>CTh206][J`<0EEEE0P1JFUX205MGE`80De=C0P1Q
HF42055AD@<0BDU90P0o?cl20492@P80ATI60P1>CTh205iNGP<0EeMG0P1EEED204a<C080@T920P1H
F5P20492@P80CTi>0`1JFUX206IVIP80F5QH0P1JFUX206=SH`80P8200`2?Shl208Z:RP80MGEe0P1X
J6P206=SH`80GEeM0`1NGUh206IVIP80LW9b0P1TI6@2055AD@80GUiN0`1VIVH205iNGP80MGEe0P1]
KFd2079bLP80SXj>0P1`L70306a/K080QXJ60P1QHF4206][J`80MGEe0P1NGUh3051@D080@T920P1<
C4`203lo?`80?3`l0P1>CTh304I6AP80EEEE0P15ADD2065QH@80K6a/0P1GEeL5055AD@80De=C101<
C4`204i>CP80>c/k0`0o?cl203`l?080;Bd]0P0Z:RX203Hf=P80ADE50`0f=SH203Ph>080@D51100l
?3`203Hf=P<0ATI60P15ADD20451@@80?3`l0P1>CTh203`l?0<0BDU90P16ATH204a<C080@D511?oo
ool1o`00000000Co0000oooooooooooooooo0P030`<9000000803@d=0P12@T8205EEE@80CTi>0`1M
GEd205EEE@80C4a<0P1CDe<205YJFP80ADE50`0o?cl204U9B@@0=SHf0P0l?3`20492@P<0D51@101<
C4`20492@P80BDU90P1<C4`204I6AP<0C4a<0P1CDe<204i>CP80GEeM0P1dM7@20:2PX0<0UYJF0P1b
LW8205eMG@80EeMG0P1<C4`204U9B@<0FUYJ0P1TI6@206=SH`80HF5Q0P1HF5P205MGE`<0GUiN0P1a
LG4406IVIP80I6AT0P21PH4207alO0<0Ogmo0P2QXJ4206a/K080EEEE0P1SHf<2069RHP<0EeMG0P19
BDT2055AD@80D51@0P12@T8504U9B@80EEEE0P0o?cl205QHF080D51@0P1LG5`305YJFP80KFe]0P1<
C4`204i>CP80EeMG0P1HF5P205YJFP<0@D510P0o?cl203Ph>080;Bd]0P0a<C4203Hf=PD0:RXZ0P0]
;Bd203Ph>080?3`l0P0a<C4302d];@80<c<c0P0];Bd203Ph>080@D510P0l?3`30492@P80BDU90P1A
DE4204U9B@Cooooo0Ol000000004o`000?ooooooooooooooo`800`<32@00000200d=3@80@T920P1E
EED204i>CP<0GEeM0P1EEED204a<C080De=C0P1JFUX204E5A@<0?clo0P19BDT403Hf=P80?3`l0P12
@T83051@D0@0C4a<0P12@T8204U9B@80C4a<0P16ATH304a<C080De=C0P1>CTh205eMG@80M7Ad0P2P
X:0309JFUP80LW9b0P1MGEd205MGE`80C4a<0P19BDT305YJFP80I6AT0P1SHf<2065QH@80F5QH0P1G
EeL305iNGP80LG5a101VIVH206ATI080PH610P1lO7`307moO`80XJ6Q0P1/K6`205EEE@80Hf=S0P1R
HV8305MGE`80BDU90P1ADE42051@D080@T921@19BDT205EEE@80?clo0P1HF5P2051@D080G5aL0`1J
FUX206e]K@80C4a<0P1>CTh205MGE`80F5QH0P1JFUX30451@@80?clo0P0h>3P202d];@80<C4a0P0f
=SH502XZ:P80;Bd]0P0h>3P203`l?080<C4a0`0];Bd203<c<`80;Bd]0P0h>3P20451@@80?3`l0`12
@T8204U9B@80DE5A0P19BDT4ooooo`7o000000001?l0003oooooooooooooool200<30`T000000P0=
3@d20492@P80EEEE0P1>CTh305eMG@80EEEE0P1<C4`205=CD`80FUYJ0P15ADD303lo?`80BDU9100f
=SH203`l?080@T920`1@D50404a<C080@T920P19BDT204a<C080ATI60`1<C4`205=CD`80CTi>0P1M
GEd207AdM080X:2P0`2FUYH2079bLP80GEeM0P1GEeL204a<C080BDU90`1JFUX206ATI080Hf=S0P1Q
HF4205QHF080EeMG0`1NGUh2075aL@@0IVIV0P1TI6@20861P@80O7al0`1oOgl20:6QX@80K6a/0P1E
EED206=SH`80HV9R0`1GEeL204U9B@80DE5A0P1@D5020492@PD0BDU90P1EEED203lo?`80F5QH0P1@
D50205aLG0<0FUYJ0P1]KFd204a<C080CTi>0P1GEeL205QHF080FUYJ0`11@D4203lo?`80>3Ph0P0]
;Bd2034a<@80=SHf1@0Z:RX202d];@80>3Ph0P0l?3`2034a<@<0;Bd]0P0c<c<202d];@80>3Ph0P11
@D4203`l?0<0@T920P19BDT2055AD@80BDU91?ooool1o`00000000Co0000oooooooooooooooo2@00
000200<30`804A4A0P0l?3`2051@D0D0F5QH1012@T8203`l?080D51@0P12@T8303Ph>0@0@T920P16
ATH2051@D080EEEE0`19BDT2051@D080HF5Q0P1@D50205EEE@80EeMG1@15ADD20451@@80HF5Q0P2:
RXX208B4Q080QHF50`1nOWh206][J`80ATI60P1<C4`203`l?080@T920`19BDT205=CD`80EeMG0P1T
I6@205MGE`80LG5a0`1SHf<205YJFP80J6QX0P1LG5`2075aL@80MGEe0P21PH4308B4Q080UiNG0P1b
LW8205YJFP80KFe]0P1SHf<3065QH@80>3Ph0P1MGEd204E5A@80G5aL0P15ADD305QHF080DE5A0P15
ADD404a<C080FUYJ0`1ADE42065QH@80G5aL0P16ATH204E5A@80DE5A0P1@D50305aLG080D51@0P12
@T8603Hf=P<092@T0P0];Bd2034a<@80;Bd]0P0c<c<20492@P<0D51@0P11@D4204U9B@80C4a<0P0f
=SH203Ph>0<0<C4a0P0f=SH203/k>`80<c<c1?ooool1o`00000000Co0000oooooooooooooooo2@00
000200<30`804A4A0P0l?3`2051@D0D0F5QH1012@T8203`l?080D51@0P12@T8303Ph>0@0@T920P16
ATH2051@D080EEEE0`19BDT2051@D080HF5Q0P1@D50205EEE@80EeMG1@15ADD20451@@80HF5Q0P2:
RXX208B4Q080QHF50`1nOWh206][J`80ATI60P1<C4`203`l?080@T920`19BDT205=CD`80EeMG0P1T
I6@205MGE`80LG5a0`1SHf<205YJFP80J6QX0P1LG5`2075aL@80MGEe0P21PH4308B4Q080UiNG0P1b
LW8205YJFP80KFe]0P1SHf<3065QH@80>3Ph0P1MGEd204E5A@80G5aL0P15ADD305QHF080DE5A0P15
ADD404a<C080FUYJ0`1ADE42065QH@80G5aL0P16ATH204E5A@80DE5A0P1@D50305aLG080D51@0P12
@T8603Hf=P<092@T0P0];Bd2034a<@80;Bd]0P0c<c<20492@P<0D51@0P11@D4204U9B@80C4a<0P0f
=SH203Ph>0<0<C4a0P0f=SH203/k>`80<c<c1?ooool1o`00000000Co0000oooooooooooooooo0P00
000200<30`D000000P030`<203<c<`80GEeM0P1JFUX204i>CP<0DE5A0P15ADD20492@P@0?3`l0P0c
<c<3034a<@80>c/k0P16ATH204U9B@@0GEeM0`16ATH204a<C080GUiN0P1EEED204E5A@80CTi>0P1E
EED505MGE`80F5QH0P1eMGD207moO`80LG5a0`1SHf<204a<C080ATI60P0o?cl203Ph>0D0@D510P1N
GUh404a<C0@0GEeM0`1GEeL205iNGP80MGEe0P1aLG4209JFUP80Ogmo0P2HV9P309JFUP80Shn?0P2:
RXX206ATI080Ogmo0P1lO7`306e]K@80EeMG0P1NGUh205eMG@80EeMG0P1EEED304a<C080De=C0P11
@D4204i>CP80D51@0P1CDe<305MGE`@0CTi>0P1QHF4204U9B@80D51@0P15ADD30492@P80C4a<1P0h
>3P203/k>`<0@T920P0h>3P20451@@80@T920P15ADD20492@P<0?3`l0P0k>c/203<c<`80>c/k0P15
ADD204U9B@<0CTi>1P11@D44ooooo`7o000000001?l0003oooooooooooooool2000000800`<31@00
000200<30`80<c<c0P1MGEd205YJFP80CTi>0`1ADE4204E5A@80@T92100l?3`203<c<`<0<C4a0P0k
>c/204I6AP80BDU9101MGEd304I6AP80C4a<0P1NGUh205EEE@80ADE50P1>CTh205EEE@D0EeMG0P1H
F5P207EeM@80Ogmo0P1aLG4306=SH`80C4a<0P16ATH203lo?`80>3Ph1@11@D4205iNGP@0C4a<101M
GEd305MGE`80GUiN0P1eMGD2075aL@80UYJF0P1oOgl209RHV0<0UYJF0P2?Shl208Z:RP80I6AT0P1o
Ogl207alO0<0KFe]0P1GEeL205iNGP80GEeM0P1GEeL205EEE@<0C4a<0P1CDe<20451@@80CTi>0P1@
D50205=CD`<0EeMG101>CTh2065QH@80BDU90P1@D50204E5A@<0@T920P1<C4`603Ph>080>c/k0`12
@T8203Ph>080@D510P12@T8204E5A@80@T920`0l?3`203/k>`80<c<c0P0k>c/204E5A@80BDU90`1>
CTh60451@@Cooooo0Ol000000004o`000?ooooooooooooooo`H000000`030`<200L71`80?3`l0P1[
Jf/206ATI080GUiN0`1`L702075aL@80EeMG1019BDT2034a<@D0>3Ph0P0k>c/203lo?`80@T920P0o
?cl30451@@80ATI60P1>CTh205=CD`80D51@0P1HF5P205iNGP<0De=C0P1JFUX206a/K080NGUi0P1a
LG42065QH@<0CTi>0P0o?cl204I6AP80<C4a0P0f=SH20492@P<0C4a<0P1HF5P205aLG080HF5Q0P1H
F5P205YJFP<0GEeM0P1RHV8208J6QP80LG5a0P2KVi/209fMW@80RXZ:0`2`/;020:FUY@80WIfM0P1n
OWh2079bLP80MWIf0`1RHV8205iNGP80EeMG0P1MGEd206=SH`80F5QH0`1ADE4205EEE@80@T920P0o
?cl204U9B@80=SHf0`1<C4`203lo?`80DE5A0P1NGUh404I6AP80EeMG0`19BDT203`l?0@0=SHf0P0]
;Bd203Hf=PD0>c/k100l?3`2034a<@80<c<c0`0h>3P2034a<@80;Bd]0P0l?3`203Hf=P80?3`l0`15
ADD20451@@80?3`l0P0c<c<4ooooo`7o000000001?l0003oooooooooooooool6000000<00`<30P07
1`L203`l?080Jf][0P1TI6@205iNGP<0L71`0P1aLG4205MGE`@0BDU90P0a<C4503Ph>080>c/k0P0o
?cl20492@P80?clo0`11@D4204I6AP80CTi>0P1CDe<2051@D080F5QH0P1NGUh305=CD`80FUYJ0P1/
K6`207UiN@80LG5a0P1QHF4304i>CP80?clo0P16ATH2034a<@80=SHf0P12@T8304a<C080F5QH0P1L
G5`2065QH@80F5QH0P1JFUX305eMG@80HV9R0P26QXH2075aL@80Vi^K0P2MWId208Z:RP<0/;2`0P2U
YJD209fMW@80OWin0P1bLW8207IfMP<0HV9R0P1NGUh205MGE`80GEeM0P1SHf<205QHF0<0DE5A0P1E
EED20492@P80?clo0P19BDT203Hf=P<0C4a<0P0o?cl2055AD@80GUiN1016ATH205MGE`<0BDU90P0l
?3`403Hf=P80;Bd]0P0f=SH503/k>`@0?3`l0P0a<C4203<c<`<0>3Ph0P0a<C4202d];@80?3`l0P0f
=SH203`l?0<0ADE50P11@D4203`l?080<c<c1?ooool1o`00000000Co0000oooooooooooooooo1P00
000300<30`801`L70P0l?3`206][J`80I6AT0P1NGUh3071`L080LG5a0P1GEeL404U9B@80<C4a1@0h
>3P203/k>`80?clo0P12@T8203lo?`<0@D510P16ATH204i>CP80De=C0P1@D50205QHF080GUiN0`1C
De<205YJFP80K6a/0P1iNGT2075aL@80HF5Q0`1>CTh203lo?`80ATI60P0a<C4203Hf=P80@T920`1<
C4`205QHF080G5aL0P1QHF4205QHF080FUYJ0`1MGEd2069RHP80QXJ60P1aLG4209^KV`80WIfM0P2:
RXX30;2`/080YJFU0P2MWId207inOP80LW9b0P1fMWH3069RHP80GUiN0P1GEeL205eMG@80Hf=S0P1H
F5P3055AD@80EEEE0P12@T8203lo?`80BDU90P0f=SH304a<C080?clo0P1ADE4205iNGP@0ATI60P1G
EeL304U9B@80?3`l100f=SH202d];@80=SHf1@0k>c/403`l?080<C4a0P0c<c<303Ph>080<C4a0P0]
;Bd203`l?080=SHf0P0l?3`304E5A@80@D510P0l?3`203<c<`Cooooo0Ol000000004o`000?oooooo
ooooooooo`H000000`030`<200/;2`80ADE50P1bLW8206a/K080KFe]0`1MGEd205MGE`80De=C0P0l
?3`2034a<@80>c/k0`0f=SH20492@P80=SHf0P11@D4204U9B@80?clo0`0h>3P203`l?080>3Ph0P0f
=SH20492@P80ADE51@1@D50206ATI080LG5a0P1bLW8206IVIP80G5aL0`0h>3P20492@P80<c<c0P0h
>3P203lo?`80@D510`15ADD204U9B@80GUiN0P1jNWX2065QH@80I6AT0`1aLG4206ATI080MWIf0P21
PH4209bLW080ZZZZ0P2>SXh309bLW080[Zj^0P2QXJ4208J6QP80P8200P1jNWX3065QH@80LW9b0P1N
GUh206][J`80KFe]1@1MGEd204i>CP80ATI60P0o?cl203`l?080<c<c0`0h>3P2034a<@80>3Ph1P1<
C4`205MGE`<0EEEE0P16ATH203/k>`80<C4a0P0h>3P202d];@<0<c<c0P0T92@202d];@80>3Ph1`0]
;Bd203<c<`80>3Ph0P0o?cl20492@P80>c/k0`0f=SH202@T9080;Bd]0P0c<c<4ooooo`7o00000000
1?l0003oooooooooooooool6000000<00`<30P0;2`/204E5A@80LW9b0P1/K6`206e]K@<0GEeM0P1G
EeL205=CD`80?3`l0P0a<C4203/k>`<0=SHf0P12@T8203Hf=P80@D510P19BDT203lo?`<0>3Ph0P0l
?3`203Ph>080=SHf0P12@T8204E5A@D0D51@0P1TI6@2075aL@80LW9b0P1VIVH205aLG0<0>3Ph0P12
@T8203<c<`80>3Ph0P0o?cl20451@@<0ADE50P19BDT205iNGP80NWYj0P1QHF4206ATI0<0LG5a0P1T
I6@207IfMP80PH610P2LW9`20:ZZZP80SXj>0`2LW9`20:j^[P80XJ6Q0P26QXH20820P080NWYj0`1Q
HF42079bLP80GUiN0P1[Jf/206e]K@D0GEeM0P1>CTh204I6AP80?clo0P0l?3`203<c<`<0>3Ph0P0a
<C4203Ph>0H0C4a<0P1GEeL305EEE@80ATI60P0k>c/2034a<@80>3Ph0P0];Bd303<c<`8092@T0P0]
;Bd203Ph>0L0;Bd]0P0c<c<203Ph>080?clo0P12@T8203/k>`<0=SHf0P0T92@202d];@80<c<c1?oo
ool1o`00000000Co0000oooooooooooooooo1P00000300L71`805aLG0P1RHV8206a/K080G5aL0P1C
De<3051@D080DE5A0P0o?cl203<c<`80C4a<0P15ADD304I6AP80C4a<0P1CDe<2055AD@80BDU90P1<
C4`303Hf=P80ATI60P0f=SH203Ph>080ATI60P1GEeL2055AD@<0De=C0P1QHF4406IVIP80KFe]0P1M
GEd30492@P80?clo100c<c<203Hf=P80>3Ph0`0Z:RX204E5A@80EEEE0P26QXH208j>SP80HV9R0`1`
L7020820P080SHf=0P2HV9P20:2PX080];Bd0P2LW9`30:>SX`80RXZ:0P2RXZ820:^[Z`80QXJ60P1d
M7@306][J`80RXZ:0P1nOWh2079bLP80MGEe0P1XJ6P305YJFP80CTi>0P15ADD20451@@80>3Ph0P0R
8R8303<c<`80>3Ph0P0l?3`203Ph>080?3`l0P0k>c/20451@@<0D51@0P11@D4203lo?`80>c/k0P0o
?cl2034a<@<0:RXZ0P0R8R8201/K6`808R8R0P0h>3P202PX:0<092@T0P0X:2P202d];@80<C4a100c
<c<303/k>`80=SHf0P0T92@203<c<`Cooooo0Ol000000004o`000?ooooooooooooooo`H000000`07
1`L201LG5`80HV9R0P1/K6`205aLG080De=C0`1@D502055AD@80?clo0P0c<c<204a<C080ADE50`16
ATH204a<C080De=C0P1ADE4204U9B@80C4a<0`0f=SH204I6AP80=SHf0P0h>3P204I6AP80EeMG0P1A
DE4305=CD`80HF5Q101VIVH206e]K@80GEeM0`12@T8203lo?`@0<c<c0P0f=SH203Ph>0<0:RXZ0P15
ADD205EEE@80QXJ60P2>SXh2069RHP<0L71`0P20P80208f=S@80V9RH0P2PX:020;Bd]080W9bL0`2S
Xj<208Z:RP80XZ:R0P2[Zj/208J6QP80M7Ad0`1[Jf/208Z:RP80OWin0P1bLW8207EeM@80J6QX0`1J
FUX204i>CP80ADE50P11@D4203Ph>0808R8R0`0c<c<203Ph>080?3`l0P0h>3P203`l?080>c/k0P11
@D43051@D080@D510P0o?cl203/k>`80?clo0P0a<C4302XZ:P808R8R0P0K6a/2028R8P80>3Ph0P0X
:2P302@T9080:2PX0P0];Bd2034a<@@0<c<c0`0k>c/203Hf=P8092@T0P0c<c<4ooooo`7o00000000
1?l0003oooooooooooooool4000000800`<30`071`L2028R8P80G5aL0P1MGEd2055AD@80CTi>0`12
@T8203/k>`80ATI60P15ADD40451@@<0CTi>0P1EEED403lo?`80@D510P0c<c<703lo?`80?3`l0P12
@T8204a<C080GUiN1@19BDT205EEE@80F5QH0P1ADE4205YJFP<0D51@0P0l?3`2034a<@80=SHf0P0a
<C4203/k>`<0ADE50P1<C4`2055AD@80M7Ad0P2BTY8207UiN@<0Rh^;0P1gMgL208B4Q080[:b/0P2a
/K420;>c/`80UiNG0`2DU9@209jNWP80Rh^;0P2[Zj/208f=S@80MgMg0`1nOWh20820P080O7al0P2?
Shl207YjNP80GEeM0`1@D502065QH@80C4a<0P0k>c/203<c<`806a/K0`0c<c<203/k>`80@T920P0c
<c<203lo?`80>c/k0P0l?3`304a<C080>c/k0P0Z:RX4034a<@80>c/k0`0T92@203Hf=P808R8R0P0X
:2P2028R8P80<c<c0`0];Bd202PX:080:RXZ0P0X:2P2034a<@D0>3Ph0P0k>c/204I6AP80<C4a1?oo
ool1o`00000000Co0000oooooooooooooooo1000000200<30`<01`L70P0R8R8205aLG080GEeM0P1A
DE4204i>CP<0@T920P0k>c/204I6AP80ADE51011@D4304i>CP80EEEE100o?cl20451@@80<c<c1`0o
?cl203`l?080@T920P1<C4`205iNGPD0BDU90P1EEED205QHF080DE5A0P1JFUX3051@D080?3`l0P0a
<C4203Hf=P80<C4a0P0k>c/304E5A@80C4a<0P1ADE4207AdM080TY:B0P1iNGT308^;R`80MgMg0P24
Q8@20:b/[080/K6a0P2c/k<209NGU`<0U9BD0P2NWYh208^;R`80Zj^[0P2=SHd207MgM`<0OWin0P20
P80207alO080Shn?0P1jNWX205eMG@<0D51@0P1QHF4204a<C080>c/k0P0c<c<201/K6`<0<c<c0P0k
>c/20492@P80<c<c0P0o?cl203/k>`80?3`l0`1<C4`203/k>`80:RXZ100a<C4203/k>`<092@T0P0f
=SH2028R8P80:2PX0P0R8R8203<c<`<0;Bd]0P0X:2P202XZ:P80:2PX0P0a<C4503Ph>080>c/k0P16
ATH2034a<@Cooooo0Ol000000004o`000?ooooooooooooooo`@000000P030`<300/;2`804A4A0P0o
?cl2069RHP80F5QH0P0l?3`30451@@80ADE50P0k>c/203<c<`80>c/k1@0o?cl203Ph>080:2PX0P0a
<C4202d];@80<c<c0`0l?3`2034a<@@0@D510P0f=SH20451@@80De=C1@1<C4`20451@@80CTi>0P11
@D4204i>CP<0De=C0P0o?cl202XZ:P80<c<c0P16ATH204E5A@D0>3Ph0P1JFUX205iNGP80U9BD0P2h
^;P30;jn_P80QXJ60P1fMWH20:2PX080Ti>C0P2FUYH208n?S`<0RHV90P2GUiL207moO`80YZJV1028
R8P309JFUP80Q8B40P29RHT208j>SP80P8200P1/K6`305eMG@80HF5Q0P0l?3`6034a<@<0<c<c0P0o
?cl203/k>`80:RXZ0P0];Bd203`l?080<C4a1@0k>c/202@T9080:2PX0P0R8R8202d];@<092@T0P0Z
:RX2028R8P80:2PX0P0K6a/5028R8P8092@T0P0X:2P2028R8P80:2PX0P0h>3P303Hf=P@0>c/k0P12
@T84ooooo`7o000000001?l0003oooooooooooooool4000000800`<30`0;2`/2014A4@80?clo0P1R
HV8205QHF080?3`l0`11@D4204E5A@80>c/k0P0c<c<203/k>`D0?clo0P0h>3P202PX:080<C4a0P0]
;Bd203<c<`<0?3`l0P0a<C440451@@80=SHf0P11@D4205=CD`D0C4a<0P11@D4204i>CP80@D510P1>
CTh305=CD`80?clo0P0Z:RX203<c<`80ATI60P15ADD503Ph>080FUYJ0P1NGUh209BDU080^;Rh0`2n
_[h208J6QP80MWIf0P2PX:0209>CT`80UYJF0P2?Shl308V9R@80UiNG0P1oOgl20:JVYP@0R8R80`2F
UYH208B4Q080RHV90P2>SXh20820P080K6a/0`1MGEd2065QH@80?3`l1P0a<C4303<c<`80?clo0P0k
>c/202XZ:P80;Bd]0P0l?3`2034a<@D0>c/k0P0T92@202PX:0808R8R0P0];Bd302@T9080:RXZ0P0R
8R8202PX:0806a/K1@0R8R8202@T9080:2PX0P0R8R8202PX:080>3Ph0`0f=SH403/k>`80@T921?oo
ool1o`00000000Co0000oooooooooooooooo1000000200<30`<02`/;0P0A4A4203lo?`80HV9R0P1H
F5P203`l?0<0@D510P15ADD203/k>`80<c<c0P0k>c/503lo?`80>3Ph0P0X:2P2034a<@80;Bd]0P0c
<c<303`l?080<C4a1011@D4203Hf=P80@D510P1CDe<504a<C080@D510P1>CTh20451@@80CTi>0`1C
De<203lo?`80:RXZ0P0c<c<204I6AP80ADE51@0h>3P205YJFP80GUiN0P2DU9@20;Rh^0<0_[jn0P26
QXH207IfMP80X:2P0P2CTi<209JFUP80Shn?0`29RHT209NGU`80Ogmo0P2VYZH408R8R0<0UYJF0P24
Q8@208V9R@80SXj>0P20P80206a/K0<0GEeM0P1QHF4203`l?0H0<C4a0`0c<c<203lo?`80>c/k0P0Z
:RX202d];@80?3`l0P0a<C4503/k>`8092@T0P0X:2P2028R8P80;Bd]0`0T92@202XZ:P808R8R0P0X
:2P201/K6`D08R8R0P0T92@202PX:0808R8R0P0X:2P203Ph>0<0=SHf100k>c/20492@PCooooo0Ol0
00000004o`000?ooooooooooooooo`8000000P030`<2000000<00`<30P0=3@d202@T9080D51@0P1E
EED204I6AP<0@T920P0h>3P2034a<@80@D510P0o?cl203`l?0<0?clo0P0f=SH2034a<@80>3Ph0P1>
CTh203`l?0<0=SHf0P0k>c/203<c<`@0;Bd]0P0a<C4204I6AP<0CTi>0P1<C4`20451@@80D51@0P0k
>c/204a<C0<0CTi>0P0k>c/203`l?080<c<c0P0a<C4204a<C0<0>3Ph0P11@D4204I6AP80Jf][0P21
PH420;Fe]@<0alO70P2CTi<2071`L080TY:B0P1iNGT206a/K080SXj>0`20P80209:BTP80PH610P2D
U9@208^;R`80MWIf0`2KVi/20:b/[080YZJV0P2DU9@208Z:RP80MgMg0`1GEeL205EEE@80?clo0P0c
<c<20451@@80<C4a0`0l?3`202d];@80<C4a100h>3P203<c<`80;Bd]0`0l?3`202d];@80:2PX100R
8R8201DE5@D05aLG0P0R8R8201LG5`8092@T0P0G5aL301/K6`8092@T0P0K6a/2028R8P80:2PX0P0E
5AD302PX:080;Bd]0P0a<C4202d];@Cooooo0Ol000000004o`000?ooooooooooooooo`8000000P03
0`<2000000<00`<30P0=3@d202@T9080D51@0P1EEED204I6AP<0@T920P0h>3P2034a<@80@D510P0o
?cl203`l?0<0?clo0P0f=SH2034a<@80>3Ph0P1>CTh203`l?0<0=SHf0P0k>c/203<c<`@0;Bd]0P0a
<C4204I6AP<0CTi>0P1<C4`20451@@80D51@0P0k>c/204a<C0<0CTi>0P0k>c/203`l?080<c<c0P0a
<C4204a<C0<0>3Ph0P11@D4204I6AP80Jf][0P21PH420;Fe]@<0alO70P2CTi<2071`L080TY:B0P1i
NGT206a/K080SXj>0`20P80209:BTP80PH610P2DU9@208^;R`80MWIf0`2KVi/20:b/[080YZJV0P2D
U9@208Z:RP80MgMg0`1GEeL205EEE@80?clo0P0c<c<20451@@80<C4a0`0l?3`202d];@80<C4a100h
>3P203<c<`80;Bd]0`0l?3`202d];@80:2PX100R8R8201DE5@D05aLG0P0R8R8201LG5`8092@T0P0G
5aL301/K6`8092@T0P0K6a/2028R8P80:2PX0P0E5AD302PX:080;Bd]0P0a<C4202d];@Cooooo0Ol0
00000004o`000?ooooooooooooooo`800`<30P00000200L71`<00`<30P0;2`/201LG5`80>c/k0P1A
DE420492@P<0?3`l0P0f=SH202PX:08092@T0P0];Bd202@T90<0:RXZ0P0k>c/203<c<`80?3`l0P1<
C4`203Hf=P<0<C4a0P0];Bd4034a<@806a/K0P0G5aL203Hf=P<0>3Ph0P0k>c/404I6AP80<C4a0P15
ADD30451@@80<C4a0P11@D4202d];@80:2PX0P0f=SH30451@@@0DE5A0P1TI6@20861P@80R8R80`2Q
XJ4209JFUP80Jf][0P1iNGT407inOP80SXj>0`2;Rh/208f=S@80OWin0P2?Shl208R8R080QHF50`2:
RXX20:2PX080/;2`0P2?Shl208^;R`80NGUi0`1HF5P20492@P80BDU90P0k>c/203lo?`80>c/k0`0f
=SH202d];@80?clo0P19BDT203Hf=PL0;Bd]0P0a<C4202XZ:P805ADE100R8R8301LG5`805ADE1P0G
5aL201DE5@<05aLG0P0Z:RX202d];@808R8R0P0X:2P202d];@<0@D510P12@T8203Hf=P80<c<c1?oo
ool1o`00000000Co0000oooooooooooooooo0P030`<2000000801`L70`030`<200/;2`805aLG0P0k
>c/2055AD@80@T920`0l?3`203Hf=P80:2PX0P0T92@202d];@8092@T0`0Z:RX203/k>`80<c<c0P0l
?3`204a<C080=SHf0`0a<C4202d];@@0<C4a0P0K6a/201LG5`80=SHf0`0h>3P203/k>`@0ATI60P0a
<C4204E5A@<0@D510P0a<C420451@@80;Bd]0P0X:2P203Hf=P<0@D51101ADE4206ATI080PH610P28
R8P30:6QX@80UYJF0P1[Jf/207UiN@@0OWin0P2>SXh308^;R`80SHf=0P1nOWh208n?S`80R8R80P25
QHD308Z:RP80X:2P0P2`/;0208n?S`80Rh^;0P1iNGT305QHF080@T920P19BDT203/k>`80?clo0P0k
>c/303Hf=P80;Bd]0P0o?cl204U9B@80=SHf1`0];Bd2034a<@80:RXZ0P0E5AD4028R8P<05aLG0P0E
5AD601LG5`805ADE0`0G5aL202XZ:P80;Bd]0P0R8R8202PX:080;Bd]0`11@D420492@P80=SHf0P0c
<c<4ooooo`7o000000001?l0003oooooooooooooool4000000801`L71@030`<200L71`804A4A0P0h
>3P20492@P<0>c/k0P0a<C4201/K6`804A4A0P0G5aL502@T9080>3Ph0P0a<C4203`l?080<c<c0P0X
:2P302d];@80:2PX0P0f=SH2034a<@806a/K0P0Z:RX203`l?0<0>3Ph0P0];Bd20451@@80;Bd]0P0f
=SH202d];@<0<c<c100X:2P2034a<@80;Bd]0P0Z:RX302d];@80>3Ph0P1ADE4204a<C080R8R80P1[
Jf/308J6QP80OWin0P1VIVH209:BTP80Ti>C0P2ATI42075aL@<0Shn?0P29RHT208J6QP80Q8B40P2N
WYh208f=S@<0MGEe0P2;Rh/209bLW080UYJF0P1lO7`207IfMP<0DE5A0P19BDT204I6AP80?3`l0P16
ATH203Hf=P<0<c<c0P0o?cl20451@@80ATI60P0h>3P202@T9080:2PX0`0];Bd2028R8P805aLG0P0T
92@401LG5`<04A4A0P0K6a/201DE5@805aLG0P0R8R82014A4@<05ADE0P0K6a/2034a<@@0:2PX0P0c
<c<303lo?`80>c/k0P0a<C4203<c<`Cooooo0Ol000000004o`000?ooooooooooooooo`@000000P07
1`L500<30`801`L70P0A4A4203Ph>080@T920`0k>c/2034a<@806a/K0P0A4A4201LG5`D092@T0P0h
>3P2034a<@80?3`l0P0c<c<202PX:0<0;Bd]0P0X:2P203Hf=P80<C4a0P0K6a/202XZ:P80?3`l0`0h
>3P202d];@80@D510P0];Bd203Hf=P80;Bd]0`0c<c<402PX:080<C4a0P0];Bd202XZ:P<0;Bd]0P0h
>3P2055AD@80C4a<0P28R8P206][J`<0QXJ60P1nOWh206IVIP80TY:B0P2CTi<2096AT@80LG5a0`2?
Shl208V9R@80QXJ60P24Q8@209jNWP80SHf=0`1eMGD208^;R`80W9bL0P2FUYH207alO080MWIf0`1A
DE4204U9B@80ATI60P0l?3`204I6AP80=SHf0`0c<c<203lo?`80@D510P16ATH203Ph>08092@T0P0X
:2P302d];@808R8R0P0G5aL202@T90@05aLG0`0A4A4201/K6`805ADE0P0G5aL2028R8P804A4A0`0E
5AD201/K6`80<C4a100X:2P203<c<`<0?clo0P0k>c/2034a<@80<c<c1?ooool1o`00000000Co0000
oooooooooooooooo1000000200L71`D00`<30P071`L2014A4@80>3Ph0P12@T8303/k>`80<C4a0P0K
6a/2014A4@805aLG1@0T92@203Ph>080<C4a0P0l?3`203<c<`80:2PX0`0];Bd202PX:080=SHf0P0a
<C4201/K6`80:RXZ0P0l?3`303Ph>080;Bd]0P11@D4202d];@80=SHf0P0];Bd303<c<`@0:2PX0P0a
<C4202d];@80:RXZ0`0];Bd203Ph>080DE5A0P1<C4`208R8R080Jf][0`26QXH207inOP80IVIV0P2B
TY8209>CT`80TI6A0P1aLG4308n?S`80RHV90P26QXH208B4Q080WYjN0P2=SHd307EeM@80Rh^;0P2L
W9`209JFUP80O7al0P1fMWH3055AD@80BDU90P16ATH203`l?080ATI60P0f=SH303<c<`80?clo0P11
@D4204I6AP80>3Ph0P0T92@202PX:0<0;Bd]0P0R8R8201LG5`8092@T100G5aL3014A4@806a/K0P0E
5AD201LG5`808R8R0P0A4A4301DE5@806a/K0P0a<C4402PX:080<c<c0`0o?cl203/k>`80<C4a0P0c
<c<4ooooo`7o000000001?l0003oooooooooooooool200<30`8000000P030`<3000000800`<30P07
1`L200/;2`80:2PX0P15ADD3055AD@80@D510P0c<c<602PX:0<0;Bd]0P0Z:RX2034a<@80>3Ph100Z
:RX302@T9080;Bd]0P0a<C4202XZ:P8092@T0P0X:2P2034a<@<0=SHf0P0X:2P203<c<`80:RXZ0P0c
<c<2034a<@<0:RXZ0P0T92@202d];@80<c<c0P0];Bd202XZ:P<0=SHf0P0Z:RX203Ph>080HF5Q0P1b
LW8207MgM`<0P8200P1nOWh205=CD`80P8200P1oOgl209RHV080K6a/0`1gMgL20861P@80O7al0P1n
OWh209:BTPD0W9bL0P1iNGT20:2PX080TY:B0P21PH4205YJFP<0BDU90P1>CTh204a<C080?clo0P0k
>c/2034a<@<0=SHf0P0c<c<202d];@@0:2PX100R8R8302XZ:P@05aLG2@0K6a/6014A4@803@d=0P0K
6a/301DE5@804A4A0P0G5aL602@T90D0<c<c0P0k>c/203<c<`Cooooo0Ol000000004o`000?oooooo
ooooooooo`800`<30P00000200<30`<000000P030`<200L71`802`/;0P0X:2P204E5A@<0DE5A0P11
@D4203<c<`H0:2PX0`0];Bd202XZ:P80<C4a0P0h>3P402XZ:P<092@T0P0];Bd2034a<@80:RXZ0P0T
92@202PX:080<C4a0`0f=SH202PX:080<c<c0P0Z:RX203<c<`80<C4a0`0Z:RX202@T9080;Bd]0P0c
<c<202d];@80:RXZ0`0f=SH202XZ:P80>3Ph0P1QHF42079bLP80MgMg0`20P80207inOP80De=C0P20
P80207moO`80V9RH0P1/K6`307MgM`80PH610P1lO7`207inOP80TY:B1@2LW9`207UiN@80X:2P0P2B
TY820861P@80FUYJ0`19BDT204i>CP80C4a<0P0o?cl203/k>`80<C4a0`0f=SH203<c<`80;Bd]100X
:2P4028R8P<0:RXZ100G5aL901/K6`H04A4A0P0=3@d201/K6`<05ADE0P0A4A4201LG5`H092@T1@0c
<c<203/k>`80<c<c1?ooool1o`00000000Co0000oooooooooooooooo0P00000900<30`@01`L70P0A
4A4203`l?0D0D51@0P12@T82034a<@80>c/k0P0a<C43028R8P80:RXZ0P0X:2P203<c<`80=SHf0P0R
8R8301/K6`805aLG0P0R8R8202XZ:P8092@T0P0G5aL2028R8P<0:RXZ0P0X:2P402d];@80?3`l1@0f
=SH202@T9080<C4a0P0o?cl203Hf=P80>c/k0`0h>3P40451@@80EeMG0P1bLW8208^;R`<0QHF50P26
QXH205eMG@80KFe]0P1jNWX208n?S`80GEeM0`1GEeL207UiN@80MgMg0P2=SHd207UiN@80Ti>C0`25
QHD209BDU080RXZ:0P2?Shl206][J`80HV9R0`1ADE4204E5A@80Hf=S0P1HF5P203Hf=P80?clo0`0k
>c/202XZ:P80:2PX0P0T92@2028R8P8092@T0P0Z:RX303<c<`8092@T0P0G5aL203Hf=P805aLG0P0R
8R8301/K6`H05ADE0P0=3@d200/;2`<05ADE100A4A4201DE5@80:2PX0P0T92@302d];@8092@T0P0X
:2P2034a<@Cooooo0Ol000000004o`000?ooooooooooooooo`8000002@030`<400L71`804A4A0P0l
?3`5051@D080@T920P0a<C4203/k>`80<C4a0`0R8R8202XZ:P80:2PX0P0c<c<203Hf=P808R8R0`0K
6a/201LG5`808R8R0P0Z:RX202@T90805aLG0P0R8R8302XZ:P80:2PX100];Bd203`l?0D0=SHf0P0T
92@2034a<@80?clo0P0f=SH203/k>`<0>3Ph1011@D4205MGE`80LW9b0P2;Rh/308F5Q@80QXJ60P1M
GEd206e]K@80NWYj0P2?Shl205eMG@<0EeMG0P1iNGT207MgM`80SHf=0P1iNGT209>CT`<0QHF50P2D
U9@208Z:RP80Shn?0P1[Jf/2069RHP<0DE5A0P15ADD206=SH`80F5QH0P0f=SH203lo?`<0>c/k0P0Z
:RX202PX:08092@T0P0R8R8202@T9080:RXZ0`0c<c<202@T90805aLG0P0f=SH201LG5`808R8R0`0K
6a/601DE5@803@d=0P0;2`/301DE5@@04A4A0P0E5AD202PX:08092@T0`0];Bd202@T9080:2PX0P0a
<C44ooooo`7o000000001?l0003oooooooooooooool400L71`800`<30`00000400<30`@01`L70P0T
92@304I6AP80DE5A0P1EEED203lo?`808R8R1@0K6a/202PX:08092@T0P0];Bd2028R8P805ADE0`0G
5aL201/K6`8092@T0P0K6a/201LG5`L06a/K0P0E5AD202PX:080=SHf0P0Z:RX203Hf=P<0>3Ph0P0X
:2P202d];@8092@T1015ADD303lo?`80CTi>0P1ADE4205EEE@80De=C0P1gMgL3075aL@80U9BD0P1E
EED206][J`80LW9b0P2:RXX204I6AP<0F5QH101jNWX208B4Q080LG5a0P24Q8@307AdM080Xj>S0P1]
KFd207alO080HF5Q1@1MGEd2055AD@80Hf=S0P12@T8202d];@80<C4a0`0o?cl203Ph>0@0:RXZ0P0R
8R8202PX:080:RXZ0`0T92@201DE5@@05aLG0P0E5AD2028R8P<04A4A0P0G5aL2014A4@802`/;100=
3@d300/;2`@05aLG0P0E5AD201/K6`804A4A0`0E5AD402PX:08092@T1?ooool1o`00000000Co0000
oooooooooooooooo10071`L200<30`<0000010030`<400L71`8092@T0`16ATH2055AD@80EEEE0P0o
?cl2028R8PD06a/K0P0X:2P202@T9080;Bd]0P0R8R8201DE5@<05aLG0P0K6a/202@T90806a/K0P0G
5aL701/K6`805ADE0P0X:2P203Hf=P80:RXZ0P0f=SH303Ph>080:2PX0P0];Bd202@T90@0ADE50`0o
?cl204i>CP80DE5A0P1EEED205=CD`80MgMg0`1aLG4209BDU080EEEE0P1[Jf/2079bLP80RXZ:0P16
ATH305QHF0@0NWYj0P24Q8@2075aL@80Q8B40`1dM7@20:>SX`80KFe]0P1lO7`2065QH@D0GEeM0P1A
DE4206=SH`80@T920P0];Bd2034a<@<0?clo0P0h>3P402XZ:P808R8R0P0X:2P202XZ:P<092@T0P0E
5AD401LG5`805ADE0P0R8R83014A4@805aLG0P0A4A4200/;2`@03@d=0`0;2`/401LG5`805ADE0P0K
6a/2014A4@<05ADE100X:2P202@T90Cooooo0Ol000000004o`000?ooooooooooooooo`@01`L70P03
0`<3000000@00`<310071`L202@T90<0ATI60P1ADE4205EEE@80?clo0P0R8R8501/K6`80:2PX0P0T
92@202d];@808R8R0P0E5AD301LG5`806a/K0P0T92@201/K6`805aLG1`0K6a/201DE5@80:2PX0P0f
=SH202XZ:P80=SHf0`0h>3P202PX:080;Bd]0P0T92@404E5A@<0?clo0P1>CTh2055AD@80EEEE0P1C
De<207MgM`<0LG5a0P2DU9@205EEE@80Jf][0P1bLW8208Z:RP80ATI60`1HF5P407YjNP80Q8B40P1a
LG4208B4Q0<0M7Ad0P2SXj<206e]K@80O7al0P1QHF4505eMG@80DE5A0P1SHf<20492@P80;Bd]0P0a
<C4303lo?`80>3Ph100Z:RX2028R8P80:2PX0P0Z:RX302@T90805ADE100G5aL201DE5@808R8R0`0A
4A4201LG5`804A4A0P0;2`/400d=3@<02`/;100G5aL201DE5@806a/K0P0A4A4301DE5@@0:2PX0P0T
92@4ooooo`7o000000001?l0003oooooooooooooool2000000800`<30P00000700<30`801`L70P0=
3@d201DE5@<0>c/k0P0h>3P2034a<@80:RXZ0P0c<c<202PX:0<06a/K100G5aL201/K6`80:RXZ0P0R
8R8301/K6`80:RXZ0P0c<c<203Hf=P80:2PX0P0T92@2028R8P<092@T0P0X:2P202XZ:P80<c<c0P0a
<C4203lo?`D0<C4a0P0h>3P202XZ:P80:2PX0P1>CTh303Hf=P80ADE50P1>CTh20492@P80J6QX0P1A
DE4305iNGP80R8R80P1HF5P206a/K080LG5a0P24Q8@5055AD@80NGUi0P1dM7@205iNGP80MWIf0P1`
L70306e]K@80Shn?0P1jNWX206=SH`80HF5Q0P1JFUX305EEE@80CTi>0P1@D50203Hf=P80?3`l0P0h
>3P30451@@80=SHf0P0c<c<2034a<@80:RXZ0P0c<c<2028R8P<092@T0P0E5AD201LG5`806a/K0P0G
5aL5014A4@H03@d=0P0;2`/501LG5`803@d=0P0;2`/201/K6`805ADE0P0K6a/301DE5@803@d=0P0T
92@202XZ:PCooooo0Ol000000004o`000?ooooooooooooooo`8000000P030`<2000000L00`<30P07
1`L200d=3@805ADE0`0k>c/203Ph>080<C4a0P0Z:RX203<c<`80:2PX0`0K6a/401LG5`806a/K0P0Z
:RX2028R8P<06a/K0P0Z:RX203<c<`80=SHf0P0X:2P202@T90808R8R0`0T92@202PX:080:RXZ0P0c
<c<2034a<@80?clo1@0a<C4203Ph>080:RXZ0P0X:2P204i>CP<0=SHf0P15ADD204i>CP80@T920P1X
J6P2055AD@<0GUiN0P28R8P205QHF080K6a/0P1aLG4208B4Q0D0DE5A0P1iNGT207AdM080GUiN0P1f
MWH2071`L0<0KFe]0P2?Shl207YjNP80Hf=S0P1QHF4205YJFP<0EEEE0P1>CTh2051@D080=SHf0P0l
?3`203Ph>0<0@D510P0f=SH203<c<`80<C4a0P0Z:RX203<c<`808R8R0`0T92@201DE5@805aLG0P0K
6a/201LG5`D04A4A1P0=3@d200/;2`D05aLG0P0=3@d200/;2`806a/K0P0E5AD201/K6`<05ADE0P0=
3@d202@T9080:RXZ1?ooool1o`00000000Co0000oooooooooooooooo0P030`<200d=3@8000002@03
0`<200L71`802`/;0`0f=SH203lo?`80@T920P0o?cl202PX:0D0;Bd]0P0a<C4203<c<`H092@T1@0Z
:RX202PX:0H08R8R0P0h>3P3034a<@808R8R0P0X:2P203<c<`80;Bd]0P0K6a/302PX:080;Bd]0P0o
?cl204E5A@80;Bd]0P0k>c/303Ph>080@T920P1NGUh204a<C080GEeM0P1fMWH306][J`80QHF50P1a
LG4205iNGP80HF5Q0P21PH4204U9B@<0ATI60P1bLW8207AdM080GUiN0P1LG5`205eMG@<0J6QX0P1g
MgL207YjNP80IVIV0P1TI6@2055AD@<0EEEE0P1HF5P20492@P80?3`l0P16ATH203<c<`<0?clo0P0f
=SH202d];@@0:RXZ0P0X:2P202@T90<06a/K0P0T92@2028R8P805aLG0P0R8R85014A4@@03@d=1P0;
2`/3014A4@808R8R100;2`/2014A4@80:2PX0`0R8R8201LG5`803@d=0P0G5aL4ooooo`7o00000000
1?l0003oooooooooooooool200<30`803@d=0P00000900<30`801`L70P0;2`/303Hf=P80?clo0P12
@T8203lo?`80:2PX1@0];Bd2034a<@80<c<c1P0T92@502XZ:P80:2PX1P0R8R8203Ph>0<0<C4a0P0R
8R8202PX:080<c<c0P0];Bd201/K6`<0:2PX0P0];Bd203lo?`80ADE50P0];Bd203/k>`<0>3Ph0P12
@T8205iNGP80C4a<0P1MGEd207IfMP<0Jf][0P25QHD2075aL@80GUiN0P1QHF420861P@80BDU90`16
ATH2079bLP80M7Ad0P1NGUh205aLG080GEeM0`1XJ6P207MgM`80NWYj0P1VIVH206ATI080DE5A0`1E
EED205QHF080@T920P0l?3`204I6AP80<c<c0`0o?cl203Hf=P80;Bd]100Z:RX202PX:08092@T0`0K
6a/202@T90808R8R0P0G5aL2028R8PD04A4A100=3@d600/;2`<04A4A0P0R8R8400/;2`804A4A0P0X
:2P3028R8P805aLG0P0=3@d201LG5`Cooooo0Ol000000004o`000?ooooooooooooooo`l00`<30P07
1`L200/;2`<0=SHf0P1ADE4204U9B@80?3`l100];Bd302XZ:P80<c<c0P0k>c/202XZ:P806a/K1@0]
;Bd202PX:08092@T0P0K6a/402@T9080<c<c0`0X:2P202@T9080:2PX100Z:RX501/K6`80>3Ph0P15
ADD203lo?`80=SHf0P0a<C4302XZ:P80>3Ph0P1CDe<205iNGP80EeMG0P1]KFd307moO`80SXj>0P1V
IVH2075aL@80F5QH0P1eMGD205eMG@<0HV9R0P1]KFd206IVIP80EEEE0P1HF5P5065QH@80M7Ad0P1`
L70206QXJ080G5aL0P1>CTh305YJFP80ATI60P0f=SH403lo?`80<c<c0`1>CTh202PX:08092@T0P0Z
:RX202@T90808R8R0P0K6a/301LG5`80:RXZ0P0K6a/201LG5`805ADE0P0=3@d7014A4@803@d=0P07
1`L500/;2`803@d=0P0E5AD400/;2`804A4A0`0K6a/401DE5@805aLG1?ooool1o`00000000Co0000
oooooooooooooooo3`030`<200L71`802`/;0`0f=SH2055AD@80BDU90P0l?3`402d];@<0:RXZ0P0c
<c<203/k>`80:RXZ0P0K6a/502d];@80:2PX0P0T92@201/K6`@092@T0P0c<c<302PX:08092@T0P0X
:2P402XZ:PD06a/K0P0h>3P204E5A@80?clo0P0f=SH2034a<@<0:RXZ0P0h>3P205=CD`80GUiN0P1G
EeL206e]K@<0Ogmo0P2>SXh206IVIP80LG5a0P1HF5P207EeM@80GEeM0`1RHV8206e]K@80IVIV0P1E
EED205QHF0D0HF5Q0P1dM7@2071`L080J6QX0P1LG5`204i>CP<0FUYJ0P16ATH203Hf=P@0?clo0P0c
<c<304i>CP80:2PX0P0T92@202XZ:P8092@T0P0R8R8201/K6`<05aLG0P0Z:RX201/K6`805aLG0P0E
5AD200d=3@L04A4A0P0=3@d200L71`D02`/;0P0=3@d201DE5@@02`/;0P0A4A4301/K6`@05ADE0P0G
5aL4ooooo`7o000000001?l0003oooooooooooooool400<30`8000001@030`<600L71`804A4A0`0Z
:RX204U9B@80>3Ph0P0a<C4203Ph>080?clo0`0Z:RX203<c<`80>c/k0P0c<c<202d];@80:2PX0`0T
92@2028R8P806a/K0P0X:2P2028R8P@05ADE0`0K6a/202@T9080:2PX0P0Z:RX2034a<@D08R8R0P0f
=SH20451@@80<c<c0P0h>3P2034a<@D0>c/k0P15ADD205MGE`80I6AT0P1VIVH308J6QP80PH610P1a
LG4206a/K080KFe]0P1HF5P205aLG0<0IVIV101EEED404U9B@80J6QX0`1JFUX207UiN@80M7Ad0P1e
MGD205iNGP80F5QH0`0l?3`20451@@80>c/k0P1HF5P2034a<@80:RXZ0`0h>3P2034a<@808R8R100]
;Bd2028R8P805ADE0`0K6a/203<c<`808R8R0P0A4A4200d=3@804A4A1@0=3@d400/;2`801`L70P03
0`<700d=3@801`L70P0=3@d200/;2`<05ADE0P0=3@d4014A4@Cooooo0Ol000000004o`000?oooooo
ooooooooo`@00`<30P00000500<30`H01`L70P0A4A4302XZ:P80BDU90P0h>3P2034a<@80>3Ph0P0o
?cl302XZ:P80<c<c0P0k>c/203<c<`80;Bd]0P0X:2P302@T90808R8R0P0K6a/202PX:0808R8R100E
5AD301/K6`8092@T0P0X:2P202XZ:P80<C4a1@0R8R8203Hf=P80@D510P0c<c<203Ph>080<C4a1@0k
>c/204E5A@80EeMG0P1TI6@206IVIP<0QXJ60P21PH42075aL@80K6a/0P1]KFd205QHF080G5aL0`1V
IVH405EEE@@0BDU90P1XJ6P305YJFP80NGUi0P1dM7@207EeM@80GUiN0P1HF5P303`l?080@D510P0k
>c/205QHF080<C4a0P0Z:RX303Ph>080<C4a0P0R8R8402d];@808R8R0P0E5AD301/K6`80<c<c0P0R
8R82014A4@803@d=0P0A4A4500d=3@@02`/;0P071`L200<30`L03@d=0P071`L200d=3@802`/;0`0E
5AD200d=3@@04A4A1?ooool1o`00000000Co0000oooooooooooooooo10030`<2000000D00`<31P07
1`L2014A4@<0:RXZ0P19BDT203Ph>080<C4a0P0h>3P203lo?`<0:RXZ0P0c<c<203/k>`80<c<c0P0]
;Bd202PX:0<092@T0P0R8R8201/K6`80:2PX0P0R8R8401DE5@<06a/K0P0T92@202PX:080:RXZ0P0a
<C45028R8P80=SHf0P11@D4203<c<`80>3Ph0P0a<C4503/k>`80ADE50P1GEeL206ATI080IVIV0`26
QXH20861P@80LG5a0P1/K6`206e]K@80F5QH0P1LG5`306IVIP@0EEEE1019BDT206QXJ0<0FUYJ0P1i
NGT207AdM080MGEe0P1NGUh205QHF0<0?3`l0P11@D4203/k>`80F5QH0P0a<C4202XZ:P<0>3Ph0P0a
<C42028R8P@0;Bd]0P0R8R8201DE5@<06a/K0P0c<c<2028R8P804A4A0P0=3@d2014A4@D03@d=100;
2`/200L71`800`<31`0=3@d200L71`803@d=0P0;2`/301DE5@803@d=100A4A44ooooo`7o00000000
1?l0003oooooooooooooool200L71`8000002`030`<200/;2`805aLG0`0Z:RX203Ph>080?3`l0P0]
;Bd403<c<`<0>3Ph0P1CDe<203`l?080:RXZ0P0T92@202d];@<06a/K100G5aL2014A4@@05ADE0P0=
3@d3014A4@805aLG100T92@203Hf=P80:2PX0`0R8R8203Ph>080?clo0P0];Bd20492@P80BDU90`0k
>c/2055AD@80GEeM0P1/K6`207UiN@80K6a/0`1RHV8209bLW080UiNG101@D50204U9B@80HF5Q0`1S
Hf<205iNGP80@D510P1CDe<206=SH`80HV9R0`1JFUX208J6QP80QHF50P26QXH206QXJ080G5aL0`19
BDT40451@@80>c/k0P0T92@2028R8P<0?3`l0P0];Bd201/K6`@0:2PX0P0G5aL201/K6`<05aLG0P0T
92@201LG5`803@d=0P0;2`/2014A4@<02`/;0P0E5AD200d=3@804A4A100=3@d300L71`802`/;0P0=
3@d400L71`D02`/;0P0A4A4202@T90806a/K1?ooool1o`00000000Co0000oooooooooooooooo0P07
1`L2000000/00`<30P0;2`/201LG5`<0:RXZ0P0h>3P203`l?080;Bd]100c<c<303Ph>080De=C0P0l
?3`202XZ:P8092@T0P0];Bd301/K6`@05aLG0P0A4A4401DE5@803@d=0`0A4A4201LG5`@092@T0P0f
=SH202PX:0<08R8R0P0h>3P203lo?`80;Bd]0P12@T8204U9B@<0>c/k0P1ADE4205eMG@80K6a/0P1i
NGT206a/K0<0HV9R0P2LW9`209NGU`@0D51@0P19BDT2065QH@<0Hf=S0P1NGUh20451@@80De=C0P1S
Hf<2069RHP<0FUYJ0P26QXH208F5Q@80QXJ60P1XJ6P205aLG0<0BDU91011@D4203/k>`8092@T0P0R
8R8303`l?080;Bd]0P0K6a/402PX:0805aLG0P0K6a/301LG5`8092@T0P0G5aL200d=3@802`/;0P0A
4A4300/;2`805ADE0P0=3@d2014A4@@03@d=0`071`L200/;2`803@d=10071`L500/;2`804A4A0P0T
92@201/K6`Cooooo0Ol000000004o`000?ooooooooooooooo`802`/;10030`<3000000H00`<30P0;
2`/2028R8P<0D51@0P19BDT203lo?`80<c<c0P0Z:RX20492@PD0=SHf0P12@T8403lo?`80:2PX0`0]
;Bd202XZ:P80:2PX0P0R8R8202@T90805aLG0P0=3@d302@T90805ADE0P0R8R8201/K6`@08R8R0`0T
92@202d];@80BDU90P1>CTh204a<C080CTi>0`0h>3P2051@D080IVIV0P1XJ6P2075aL@80QHF50`1i
NGT207EeM@80TI6A0P1MGEd203`l?080HF5Q0P1SHf<306a/K080IVIV0P0f=SH204I6AP80GEeM0P1S
Hf<305aLG080QHF50P1TI6@206e]K@80OWin0P1VIVH304i>CP80ADE50P1EEED2034a<@80:2PX0P0T
92@303<c<`80:RXZ0P0R8R8202PX:0808R8R0P0T92@201DE5@<04A4A0P0=3@d201DE5@802`/;0P0=
3@d200/;2`<04A4A0P0;2`/200d=3@804A4A100=3@d300/;2`803@d=0P0;2`/200d=3@804A4A0P0;
2`/301LG5`@02`/;0P0A4A44ooooo`7o000000001?l0003oooooooooooooool200/;2`@00`<30`00
000600<30`802`/;0P0R8R83051@D080BDU90P0o?cl203<c<`80:RXZ0P12@T8503Hf=P80@T92100o
?cl202PX:0<0;Bd]0P0Z:RX202PX:0808R8R0P0T92@201LG5`803@d=0`0T92@201DE5@808R8R0P0K
6a/4028R8P<092@T0P0];Bd204U9B@80CTi>0P1<C4`204i>CP<0>3Ph0P1@D50206IVIP80J6QX0P1a
LG4208F5Q@<0NGUi0P1eMGD2096AT@80GEeM0P0l?3`2065QH@80Hf=S0`1/K6`206IVIP80=SHf0P16
ATH205eMG@80Hf=S0`1LG5`208F5Q@80I6AT0P1]KFd207inOP80IVIV0`1>CTh204E5A@80EEEE0P0a
<C4202PX:08092@T0`0c<c<202XZ:P808R8R0P0X:2P2028R8P8092@T0P0E5AD3014A4@803@d=0P0E
5AD200/;2`803@d=0P0;2`/3014A4@802`/;0P0=3@d2014A4@@03@d=0`0;2`/200d=3@802`/;0P0=
3@d2014A4@802`/;0`0G5aL400/;2`804A4A1?ooool1o`00000000Co0000oooooooooooooooo0P07
1`L;00<30`801`L70P0=3@d204E5A@<0C4a<0P11@D4204E5A@80=SHf0P0];Bd203Hf=P<0:RXZ0P0c
<c<202d];@8092@T0P0h>3P2034a<@<0:2PX100T92@201DE5@803@d=0P0E5AD201/K6`<05ADE0P0R
8R8401/K6`808R8R0P0Z:RX302PX:080=SHf0P0l?3`20451@@80C4a<0P1@D50305QHF080@D510P1@
D50205MGE`80IVIV0P2CTi<309BDU080OWin0P29RHT205iNGP80@D510P1`L70206QXJ0<0QHF50P1L
G5`20451@@80C4a<0P1LG5`2055AD@<0EeMG0P1iNGT206=SH`80I6AT0P1fMWH206QXJ0<0ATI60P0f
=SH203`l?080<c<c0P0a<C4203Ph>0<08R8R0P0G5aL402@T90806a/K0P0R8R8201/K6`<04A4A0P0E
5AD2014A4@@03@d=0P071`L700/;2`800`<30P0;2`/200<30`<02`/;100=3@d201LG5`805ADE0P0K
6a/5014A4@802`/;0P0=3@d4ooooo`7o000000001?l0003oooooooooooooool200L71`/00`<30P07
1`L200d=3@80ADE50`1<C4`20451@@80ADE50P0f=SH202d];@80=SHf0`0Z:RX203<c<`80;Bd]0P0T
92@203Ph>080<C4a0`0X:2P402@T90805ADE0P0=3@d201DE5@806a/K0`0E5AD2028R8P@06a/K0P0R
8R8202XZ:P<0:2PX0P0f=SH203`l?080@D510P1<C4`2051@D0<0F5QH0P11@D42051@D080EeMG0P1V
IVH209>CT`<0U9BD0P1nOWh208V9R@80GUiN0P11@D42071`L080J6QX0`25QHD205aLG080@D510P1<
C4`205aLG080DE5A0`1GEeL207UiN@80Hf=S0P1TI6@207IfMP80J6QX0`16ATH203Hf=P80?3`l0P0c
<c<2034a<@80>3Ph0`0R8R8201LG5`@092@T0P0K6a/2028R8P806a/K0`0A4A4201DE5@804A4A100=
3@d200L71`L02`/;0P030`<200/;2`800`<30`0;2`/400d=3@805aLG0P0E5AD201/K6`D04A4A0P0;
2`/200d=3@Cooooo0Ol000000004o`000?ooooooooooooooo`801`L72`030`<200L71`803@d=0P15
ADD304a<C080@D510P15ADD203Hf=P80;Bd]0P0f=SH302XZ:P80<c<c0P0];Bd202@T9080>3Ph0P0a
<C4302PX:0@092@T0P0E5AD200d=3@805ADE0P0K6a/301DE5@808R8R100K6a/2028R8P80:RXZ0`0X
:2P203Hf=P80?3`l0P11@D4204a<C080D51@0`1HF5P20451@@80D51@0P1GEeL206IVIP80Ti>C0`2D
U9@207inOP80RHV90P1NGUh20451@@80L71`0P1XJ6P308F5Q@80G5aL0P11@D4204a<C080G5aL0P1A
DE4305MGE`80NGUi0P1SHf<206ATI080MWIf0P1XJ6P304I6AP80=SHf0P0l?3`203<c<`80<C4a0P0h
>3P3028R8P805aLG100T92@201/K6`808R8R0P0K6a/3014A4@805ADE0P0A4A4400d=3@801`L71`0;
2`/200<30`802`/;0P030`<300/;2`@03@d=0P0G5aL201DE5@806a/K1@0A4A4200/;2`803@d=1?oo
ool1o`00000000Co0000oooooooooooooooo3`030`<203Hf=P80HF5Q0`1>CTh204E5A@80EeMG0P1C
De<4055AD@<0D51@100f=SH202d];@80<c<c0P0f=SH301/K6`805aLG0P0A4A4200d=3@805aLG100K
6a/301LG5`805ADE0P0R8R8202PX:080:RXZ0P0f=SH303<c<`80?3`l0P0k>c/20451@@80@T920P1R
HV83055AD@80HF5Q0P1RHV8205eMG@80I6AT0P26QXH308j>SP80MGEe0P2;Rh/206][J`80C4a<0P1Q
HF4206ATI0<0PH610P1CDe<203Ph>080F5QH0P1LG5`20492@P<0F5QH0P1TI6@206a/K080KFe]0P1/
K6`2069RHP<0EEEE0P0h>3P2034a<@80<c<c0P0];Bd202PX:0<06a/K0P0G5aL202XZ:P8092@T0P0E
5AD202@T90805aLG0`0A4A4200d=3@802`/;0P0=3@d400/;2`D01`L70P0;2`/400L71`802`/;0`03
0`<200/;2`803@d=0P0G5aL202@T9080;Bd]1@0Z:RX401LG5`Cooooo0Ol000000004o`000?oooooo
ooooooooo`l00`<30P0f=SH2065QH@<0CTi>0P15ADD205MGE`80De=C101ADE43051@D0@0=SHf0P0]
;Bd203<c<`80=SHf0`0K6a/201LG5`804A4A0P0=3@d201LG5`@06a/K0`0G5aL201DE5@808R8R0P0X
:2P202XZ:P80=SHf0`0c<c<203`l?080>c/k0P11@D420492@P80HV9R0`1ADE42065QH@80HV9R0P1M
GEd206ATI080QXJ60`2>SXh207EeM@80Rh^;0P1[Jf/204a<C080HF5Q0P1TI6@30861P@80De=C0P0h
>3P205QHF080G5aL0P12@T8305QHF080I6AT0P1/K6`206e]K@80K6a/0P1RHV8305EEE@80>3Ph0P0a
<C4203<c<`80;Bd]0P0X:2P301/K6`805aLG0P0Z:RX202@T90805ADE0P0T92@201LG5`<04A4A0P0=
3@d200/;2`803@d=100;2`/500L71`802`/;10071`L200/;2`<00`<30P0;2`/200d=3@805aLG0P0T
92@202d];@D0:RXZ100G5aL4ooooo`7o000000001?l0003oooooooooooooool=00<30`803@d=0P1G
EeL2079bLP<0DE5A0P1GEeL205eMG@80IVIV0P1aLG4204i>CP<0@D510P0a<C4203<c<`80@D510P0a
<C42028R8P<06a/K0P0X:2P201/K6`H05aLG0P0E5AD301/K6`805ADE0P0G5aL202@T9080;Bd]0P0X
:2P303Ph>080C4a<0P1ADE4404U9B@D0DE5A0P1]KFd206][J`80QXJ60P21PH4207inOP<0Ogmo0P21
PH42079bLP80De=C0P1>CTh205iNGP80I6AT0`1`L7020492@P80BDU90P1[Jf/205MGE`80?clo0`1<
C4`205aLG080PH610P1lO7`206e]K@80G5aL0`1>CTh204U9B@80@T920P0a<C4202d];@8092@T0`0]
;Bd202PX:0808R8R1P0K6a/2028R8P<06a/K0P0E5AD200d=3@802`/;100=3@d500L71`802`/;1007
1`L200d=3@<04A4A100=3@d201DE5@805aLG0P0Z:RX301LG5`8092@T0P0X:2P203Ph>0Cooooo0Ol0
00000004o`000?ooooooooooooooo`d00`<30P0=3@d205MGE`80LW9b0`1ADE4205MGE`80GEeM0P1V
IVH2075aL@80CTi>0`11@D42034a<@80<c<c0P11@D42034a<@808R8R0`0K6a/202PX:0806a/K1P0G
5aL201DE5@<06a/K0P0E5AD201LG5`8092@T0P0];Bd202PX:0<0>3Ph0P1<C4`2055AD@@0BDU91@1A
DE4206e]K@80Jf][0P26QXH20861P@80OWin0`1oOgl20861P@80LW9b0P1CDe<204i>CP80GUiN0P1T
I6@3071`L080@T920P19BDT206][J`80EeMG0P0o?cl304a<C080G5aL0P21PH4207alO080KFe]0P1L
G5`304i>CP80BDU90P12@T82034a<@80;Bd]0P0T92@302d];@80:2PX0P0R8R8601/K6`808R8R0`0K
6a/201DE5@803@d=0P0;2`/400d=3@D01`L70P0;2`/400L71`803@d=0`0A4A4400d=3@805ADE0P0G
5aL202XZ:P<05aLG0P0T92@202PX:080>3Ph1?ooool1o`00000000Co0000oooooooooooooooo0P00
000900<30`803@d=0P0R8R8205=CD`80FUYJ0`15ADD203lo?`80G5aL0P1GEeL205aLG080D51@0`0o
?cl202XZ:P80ADE50P0k>c/201LG5`808R8R0`0T92@2028R8P804A4A100=3@d201LG5`D04A4A0P0R
8R8201LG5`8092@T0P0k>c/2034a<@<0?3`l0P12@T8204U9B@80@T920P1ADE42051@D0<0CTi>0P1n
OWh207moO`80RHV90P2FUYH207UiN@<0G5aL0P2:RXX2065QH@80HV9R0P0o?cl206e]K@80LG5a0`1J
FUX20492@P80GEeM0P1/K6`204E5A@80=SHf0`1ADE4205aLG080RHV90P21PH4208^;R`80GEeM0`16
ATH2051@D080>c/k0P11@D42055AD@80<c<c0`0a<C4202PX:080:RXZ0P0R8R8202XZ:P8092@T2@0R
8R8600d=3@<02`/;0P0A4A4200d=3@H02`/;0`0=3@d2014A4@805aLG0P0K6a/201DE5@806a/K0`0G
5aL201DE5@804A4A0P0K6a/4ooooo`7o000000001?l0003oooooooooooooool2000000T00`<30P0=
3@d2028R8P80De=C0P1JFUX304E5A@80?clo0P1LG5`205MGE`80G5aL0P1@D50303lo?`80:RXZ0P15
ADD203/k>`805aLG0P0R8R8302@T90808R8R0P0A4A4400d=3@805aLG1@0A4A42028R8P805aLG0P0T
92@203/k>`80<C4a0`0l?3`20492@P80BDU90P12@T82055AD@80D51@0`1>CTh207inOP80Ogmo0P29
RHT209JFUP80NGUi0`1LG5`208Z:RP80HF5Q0P1RHV8203lo?`80KFe]0P1aLG4305YJFP80@T920P1M
GEd206a/K080ADE50P0f=SH3055AD@80G5aL0P29RHT20861P@80Rh^;0P1MGEd304I6AP80D51@0P0k
>c/20451@@80DE5A0P0c<c<3034a<@80:2PX0P0Z:RX2028R8P80:RXZ0P0T92@9028R8PH03@d=0`0;
2`/2014A4@803@d=1P0;2`/300d=3@804A4A0P0G5aL201/K6`805ADE0P0K6a/301LG5`805ADE0P0A
4A4201/K6`Cooooo0Ol000000004o`000?ooooooooooooooo`8000002@030`<200d=3@808R8R0P1C
De<205YJFP<0ADE50P0o?cl205aLG080EeMG0P1LG5`2051@D0<0?clo0P0Z:RX204E5A@80>c/k0P0G
5aL2028R8P<092@T0P0R8R82014A4@@03@d=0P0G5aL5014A4@808R8R0P0G5aL202@T9080>c/k0P0a
<C4303`l?080@T920P19BDT20492@P80DE5A0P1@D50304i>CP80OWin0P1oOgl208V9R@80UYJF0P1i
NGT305aLG080RXZ:0P1QHF42069RHP80?clo0P1]KFd2075aL@<0FUYJ0P12@T8205eMG@80K6a/0P15
ADD203Hf=P<0DE5A0P1LG5`208V9R@80PH610P2;Rh/205eMG@<0ATI60P1@D50203/k>`80@D510P1A
DE4203<c<`<0<C4a0P0X:2P202XZ:P808R8R0P0Z:RX202@T90T08R8R1P0=3@d300/;2`804A4A0P0=
3@d600/;2`<03@d=0P0A4A4201LG5`806a/K0P0E5AD201/K6`<05aLG0P0E5AD2014A4@806a/K1?oo
ool1o`00000000Co0000oooooooooooooooo10030`<2000000D00`<30P0;2`/202XZ:P80D51@0P15
ADD303lo?`80ATI61015ADD203Ph>080;Bd]0`0a<C42028R8P@06a/K0P0T92@201LG5`<02`/;1007
1`L200/;2`801`L70P0;2`/201DE5@<04A4A0P0T92@203Hf=P80<c<c0P0l?3`204E5A@<0?3`l0P15
ADD205=CD`80D51@0P1>CTh206QXJ0<0I6AT0P29RHT209NGU`80YZJV0P2WYjL209:BTP<0HV9R0P1i
NGT207IfMP80I6AT0P1GEeL2055AD@80L71`0`16ATH203Hf=P80DE5A0P1EEED203<c<`80BDU90`1G
EeL205iNGP80L71`0P1lO7`207IfMP80GEeM0`16ATH205iNGP80D51@0P11@D4205EEE@80>c/k0`0h
>3P203<c<`80=SHf0P0a<C4202d];@8092@T0P0Z:RX302@T90808R8R0P0T92@2014A4@802`/;0P0=
3@d300/;2`804A4A100=3@d200L71`803@d=0`0A4A4201LG5`804A4A100E5AD200d=3@<01`L70P0=
3@d4014A4@Cooooo0Ol000000004o`000?ooooooooooooooo`@00`<30P00000500<30`802`/;0P0Z
:RX2051@D080ADE50`0o?cl204I6AP@0ADE50P0h>3P202d];@<0<C4a0P0R8R8401/K6`8092@T0P0G
5aL300/;2`@01`L70P0;2`/200L71`802`/;0P0E5AD3014A4@8092@T0P0f=SH203<c<`80?3`l0P15
ADD303`l?080ADE50P1CDe<2051@D080CTi>0P1XJ6P306ATI080RHV90P2GUiL20:JVYP80YjNW0P2B
TY83069RHP80NGUi0P1fMWH206ATI080EeMG0P1ADE42071`L0<0ATI60P0f=SH2055AD@80EEEE0P0c
<c<204U9B@<0EeMG0P1NGUh2071`L080O7al0P1fMWH205eMG@<0ATI60P1NGUh2051@D080@D510P1E
EED203/k>`<0>3Ph0P0c<c<203Hf=P80<C4a0P0];Bd202@T9080:RXZ0`0T92@2028R8P8092@T0P0A
4A4200/;2`803@d=0`0;2`/2014A4@@03@d=0P071`L200d=3@<04A4A0P0G5aL2014A4@@05ADE0P0=
3@d300L71`803@d=100A4A44ooooo`7o000000001?l0003oooooooooooooool900<30`801`L70P0T
92@203lo?`80G5aL0P0f=SH302PX:080:RXZ0P0T92@202PX:080;Bd]0P0f=SH302d];@80=SHf0P0R
8R8201/K6`805aLG0P0=3@d300L71`800`<31P071`L200d=3@804A4A0`0K6a/202XZ:P80=SHf0P11
@D4203/k>`80De=C0`0k>c/203`l?080BDU90P1JFUX205QHF080K6a/0`1]KFd207moO`80OWin0P2W
YjL20:JVYP80WYjN0`1`L70205aLG080Q8B40P1RHV82051@D080@T920P1NGUh304I6AP80=SHf0P11
@D420492@P80?3`l0P11@D4305eMG@80FUYJ0P1VIVH2075aL@80NWYj0P1/K6`304i>CP80G5aL0P1<
C4`205YJFP80D51@0P11@D4303lo?`80>3Ph0P0f=SH203<c<`80<C4a0P0];Bd502@T90808R8R0P0G
5aL200d=3@T02`/;0P0E5AD200L71`802`/;0P0=3@d3028R8P804A4A0P0T92@201/K6`805ADE1@0=
3@d200/;2`803@d=0P0A4A44ooooo`7o000000001?l0003oooooooooooooool900<30`801`L70P0T
92@203lo?`80G5aL0P0f=SH302PX:080:RXZ0P0T92@202PX:080;Bd]0P0f=SH302d];@80=SHf0P0R
8R8201/K6`805aLG0P0=3@d300L71`800`<31P071`L200d=3@804A4A0`0K6a/202XZ:P80=SHf0P11
@D4203/k>`80De=C0`0k>c/203`l?080BDU90P1JFUX205QHF080K6a/0`1]KFd207moO`80OWin0P2W
YjL20:JVYP80WYjN0`1`L70205aLG080Q8B40P1RHV82051@D080@T920P1NGUh304I6AP80=SHf0P11
@D420492@P80?3`l0P11@D4305eMG@80FUYJ0P1VIVH2075aL@80NWYj0P1/K6`304i>CP80G5aL0P1<
C4`205YJFP80D51@0P11@D4303lo?`80>3Ph0P0f=SH203<c<`80<C4a0P0];Bd502@T90808R8R0P0G
5aL200d=3@T02`/;0P0E5AD200L71`802`/;0P0=3@d3028R8P804A4A0P0T92@201/K6`805ADE1@0=
3@d200/;2`803@d=0P0A4A44ooooo`7o000000001?l0003oooooooooooooool900<30`804A4A0P0Z
:RX20492@P80HV9R0P0h>3P3034a<@80D51@0P0a<C4202d];@@0:RXZ0`0R8R8601DE5@803@d=0P0;
2`/500L71`@00`<30P071`L200d=3@808R8R0`0c<c<20492@P80>3Ph0P0k>c/20492@P80D51@0`0k
>c/40492@P80Hf=S0P1VIVH2079bLP<0MgMg0P24Q8@2071`L080LW9b0P2RXZ8207alO0<0GUiN0P1C
De<206QXJ080EEEE0P16ATH203<c<`80@T920`0c<c<202d];@80?clo0P0l?3`203<c<`80C4a<0`1X
J6P205=CD`80Hf=S0P1dM7@2079bLP80MGEe0`1TI6@2069RHP80D51@0P1SHf<205eMG@80@D510`15
ADD20451@@80?clo0P11@D4203Ph>080<C4a0P0c<c<302d];@80:2PX0P0K6a/201DE5@802`/;1@07
1`L200d=3@804A4A0P0;2`/200L71`803@d=0`0E5AD201LG5`80:2PX0P0K6a/2028R8P805aLG0`0R
8R8202PX:0806a/K0P0G5aL4ooooo`7o000000001?l0003oooooooooooooool900<30`804A4A0P0Z
:RX20492@P80HV9R0P0h>3P3034a<@80D51@0P0a<C4202d];@@0:RXZ0`0R8R8601DE5@803@d=0P0;
2`/500L71`@00`<30P071`L200d=3@808R8R0`0c<c<20492@P80>3Ph0P0k>c/20492@P80D51@0`0k
>c/40492@P80Hf=S0P1VIVH2079bLP<0MgMg0P24Q8@2071`L080LW9b0P2RXZ8207alO0<0GUiN0P1C
De<206QXJ080EEEE0P16ATH203<c<`80@T920`0c<c<202d];@80?clo0P0l?3`203<c<`80C4a<0`1X
J6P205=CD`80Hf=S0P1dM7@2079bLP80MGEe0`1TI6@2069RHP80D51@0P1SHf<205eMG@80@D510`15
ADD20451@@80?clo0P11@D4203Ph>080<C4a0P0c<c<302d];@80:2PX0P0K6a/201DE5@802`/;1@07
1`L200d=3@804A4A0P0;2`/200L71`803@d=0`0E5AD201LG5`80:2PX0P0K6a/2028R8P805aLG0`0R
8R8202PX:0806a/K0P0G5aL4ooooo`7o000000001?l0003oooooooooooooool4000000D00`<30P0E
5AD202XZ:P80<C4a0P0c<c<2028R8P<0:RXZ0P0X:2P203Hf=P80:2PX100a<C4301LG5`@04A4A0P0;
2`/2014A4@801`L70`030`<200L71`800`<30P071`L200/;2`805ADE0P0X:2P303`l?080ATI60P0o
?cl204a<C080DE5A0P15ADD304I6AP80@T920P16ATH207AdM080HF5Q0P1/K6`307EeM@80RXZ:0P1n
OWh206e]K@80QXJ60P1oOgl305eMG@80ATI60P1@D50205iNGP80ATI60P0a<C4203Hf=P<0:2PX0P0T
92@202PX:080:RXZ0P0a<C4205MGE`<0IVIV0P1>CTh204I6AP80NGUi0P1gMgL207alO0<0Ogmo0P1V
IVH205eMG@80L71`0P1MGEd2055AD@<0BDU90P1HF5P204I6APH0C4a<0P0c<c<303Ph>080<c<c0P0X
:2P202XZ:P805aLG0P0A4A4500L71`H02`/;0P071`L500d=3@806a/K0P0Z:RX203<c<`80>3Ph1@0f
=SH2034a<@80=SHf1?ooool1o`00000000Co0000oooooooooooooooo1000000500<30`805ADE0P0Z
:RX2034a<@80<c<c0P0R8R8302XZ:P80:2PX0P0f=SH202PX:0@0<C4a0`0G5aL4014A4@802`/;0P0A
4A4200L71`<00`<30P071`L200<30`801`L70P0;2`/201DE5@80:2PX0`0l?3`204I6AP80?clo0P1<
C4`2055AD@80ADE50`16ATH20492@P80ATI60P1dM7@2065QH@80K6a/0`1eMGD208Z:RP80OWin0P1]
KFd208J6QP80Ogmo0`1MGEd204I6AP80D51@0P1NGUh204I6AP80<C4a0P0f=SH302PX:08092@T0P0X
:2P202XZ:P80<C4a0P1GEeL306IVIP80CTi>0P16ATH207UiN@80MgMg0P1lO7`307moO`80IVIV0P1M
GEd2071`L080GEeM0P1ADE4304U9B@80F5QH0P16ATH604a<C080<c<c0`0h>3P203<c<`80:2PX0P0Z
:RX201LG5`804A4A1@071`L600/;2`801`L71@0=3@d201/K6`80:RXZ0P0c<c<203Ph>0D0=SHf0P0a
<C4203Hf=PCooooo0Ol000000004o`000?ooooooooooooooo`@000001@030`<201DE5@80:RXZ0P0a
<C4203<c<`808R8R0`0Z:RX202PX:080=SHf0P0X:2P4034a<@<05aLG100A4A4200/;2`804A4A0P07
1`L300<30`801`L70P030`<200L71`802`/;0P0E5AD202PX:0<0?3`l0P16ATH203lo?`80C4a<0P1A
DE4204E5A@<0ATI60P12@T8204I6AP80M7Ad0P1QHF4206a/K0<0MGEe0P2:RXX207inOP80KFe]0P26
QXH207moO`<0GEeM0P16ATH2051@D080GUiN0P16ATH2034a<@80=SHf0`0X:2P202@T9080:2PX0P0Z
:RX2034a<@80EeMG0`1VIVH204i>CP80ATI60P1iNGT207MgM`80O7al0`1oOgl206IVIP80GEeM0P1`
L70205eMG@80DE5A0`19BDT205QHF080ATI61P1<C4`203<c<`<0>3Ph0P0c<c<202PX:080:RXZ0P0G
5aL2014A4@D01`L71P0;2`/200L71`D03@d=0P0K6a/202XZ:P80<c<c0P0h>3P503Hf=P80<C4a0P0f
=SH4ooooo`7o000000001?l0003oooooooooooooool200L71`@00`<30`0=3@d201DE5@805aLG0P0Z
:RX202PX:08092@T0`0Z:RX203Ph>080<C4a0P0K6a/202XZ:P80@D510`0l?3`201LG5`804A4A0P07
1`L201DE5@801`L70`0;2`/200L71`@00`<30P0;2`/201/K6`80=SHf0`16ATH204E5A@80C4a<0P1M
GEd2051@D080=SHf0`0o?cl204a<C080G5aL0P1RHV8206IVIP80HF5Q0`1jNWX207IfMP80K6a/0P20
P80208j>SP80MWIf0`12@T82051@D080>c/k0P1CDe<2055AD@80>c/k0P12@T83034a<@808R8R0P0E
5AD201/K6`80<C4a0P1RHV8305eMG@80I6AT0P1HF5P207YjNP80Hf=S0P1jNWX307MgM`80L71`0P1X
J6P207alO080MWIf0P1CDe<304U9B@80HF5Q0P1EEED205YJFP80EEEE0P0o?cl203<c<`<092@T100X
:2P202XZ:P806a/K0P0A4A4300/;2`P00`<31@071`L200/;2`804A4A0P0K6a/203Hf=P80?3`l0`19
BDT603/k>`Cooooo0Ol000000004o`000?ooooooooooooooo`801`L710030`<300d=3@805ADE0P0G
5aL202XZ:P80:2PX0P0T92@302XZ:P80>3Ph0P0a<C4201/K6`80:RXZ0P11@D4303`l?0805aLG0P0A
4A4200L71`805ADE0P071`L300/;2`801`L710030`<200/;2`806a/K0P0f=SH304I6AP80ADE50P1<
C4`205eMG@80D51@0P0f=SH303lo?`80C4a<0P1LG5`2069RHP80IVIV0P1QHF4307YjNP80MWIf0P1/
K6`20820P080SXj>0P1fMWH30492@P80D51@0P0k>c/205=CD`80DE5A0P0k>c/20492@P<0<C4a0P0R
8R8201DE5@806a/K0P0a<C42069RHP<0GEeM0P1TI6@205QHF080NWYj0P1SHf<207YjNP<0MgMg0P1`
L70206QXJ080O7al0P1fMWH205=CD`<0BDU90P1QHF4205EEE@80FUYJ0P1EEED203lo?`80<c<c0`0T
92@402PX:080:RXZ0P0K6a/2014A4@<02`/;20030`<500L71`802`/;0P0A4A4201/K6`80=SHf0P0l
?3`304U9B@H0>c/k1?ooool1o`00000000Co0000oooooooooooooooo10030`<200L71`<03@d=0P0X
:2P201LG5`@08R8R0P0Z:RX301/K6`8092@T0P0a<C4203lo?`80<c<c0P0l?3`303Hf=P80;Bd]0P0G
5aL2014A4@802`/;0P071`L300<30`H01`L70P0=3@d201/K6`80=SHf0`15ADD205MGE`80L71`0P1M
GEd204E5A@80@T921@1@D50205aLG080J6QX0P1gMgL205eMG@<0L71`0P1SHf<206ATI080NGUi0P26
QXH206a/K0<0ATI60P1>CTh203`l?080FUYJ0P1GEeL203lo?`80D51@0`1CDe<201LG5`806a/K0P0G
5aL20492@P80G5aL0`1GEeL2065QH@80GUiN0P1dM7@206=SH`80LG5a0`1fMWH206][J`80IVIV0P20
P80207IfMP80EEEE0`1<C4`205=CD`80D51@0P1EEED204I6AP80BDU90P0k>c/302XZ:P808R8R0P0]
;Bd2034a<@8092@T0P0=3@d300/;2`801`L720030`<500L71`802`/;0P0=3@d2014A4@80<C4a0`15
ADD205EEE@80D51@0P19BDT4ooooo`7o000000001?l0003oooooooooooooool400<30`801`L70`0=
3@d202PX:0805aLG100R8R8202XZ:P<06a/K0P0T92@2034a<@80?clo0P0c<c<203`l?0<0=SHf0P0]
;Bd201LG5`804A4A0P0;2`/200L71`<00`<31P071`L200d=3@806a/K0P0f=SH304E5A@80EeMG0P1`
L70205eMG@80ADE50P12@T85051@D080G5aL0P1XJ6P207MgM`80GEeM0`1`L70206=SH`80I6AT0P1i
NGT208J6QP80K6a/0`16ATH204i>CP80?3`l0P1JFUX205MGE`80?clo0P1@D50305=CD`805aLG0P0K
6a/201LG5`80@T920P1LG5`305MGE`80HF5Q0P1NGUh207AdM080Hf=S0P1aLG4307IfMP80Jf][0P1V
IVH20820P080MWIf0P1EEED304a<C080De=C0P1@D50205EEE@80ATI60P19BDT203/k>`<0:RXZ0P0R
8R8202d];@80<C4a0P0T92@200d=3@<02`/;0P071`L800<30`D01`L70P0;2`/200d=3@804A4A0P0a
<C4304E5A@80EEEE0P1@D50204U9B@Cooooo0Ol000000004o`000?ooooooooooooooo`800`<30P07
1`L200/;2`<05aLG0P0a<C4402@T90806a/K0P0R8R8302PX:0@0>3Ph0P11@D4202XZ:P80<c<c0`0X
:2P201/K6`808R8R0P0G5aL2014A4@L03@d=0P0;2`/200d=3@805aLG0P0Z:RX203/k>`<0ATI60P1l
O7`207AdM080DE5A0P16ATH2065QH@<0IVIV0P1aLG4206e]K@80P8200P1jNWX205QHF0<0De=C1P1[
Jf/208Z:RP80@D510`0l?3`20451@@80>3Ph0P1<C4`2065QH@80BDU90P1ADE4307EeM@80<c<c0P0T
92@201LG5`80>3Ph0P16ATH3055AD@80G5aL0P1CDe<2055AD@80MGEe0P1QHF4306IVIP80Jf][0P1S
Hf<20861P@80OWin0P1RHV8304a<C080F5QH0P1CDe<2051@D0@0?3`l0P0a<C4303/k>`@0:RXZ0P0c
<c<202d];@805aLG0`0A4A4200L71`@00`<30P071`L200<30`<01`L70P030`<200L71`@02`/;0P0A
4A4302XZ:P80;Bd]0P0c<c<203/k>`Cooooo0Ol000000004o`000?ooooooooooooooo`800`<30P07
1`L200/;2`<05aLG0P0a<C4402@T90806a/K0P0R8R8302PX:0@0>3Ph0P11@D4202XZ:P80<c<c0`0X
:2P201/K6`808R8R0P0G5aL2014A4@L03@d=0P0;2`/200d=3@805aLG0P0Z:RX203/k>`<0ATI60P1l
O7`207AdM080DE5A0P16ATH2065QH@<0IVIV0P1aLG4206e]K@80P8200P1jNWX205QHF0<0De=C1P1[
Jf/208Z:RP80@D510`0l?3`20451@@80>3Ph0P1<C4`2065QH@80BDU90P1ADE4307EeM@80<c<c0P0T
92@201LG5`80>3Ph0P16ATH3055AD@80G5aL0P1CDe<2055AD@80MGEe0P1QHF4306IVIP80Jf][0P1S
Hf<20861P@80OWin0P1RHV8304a<C080F5QH0P1CDe<2051@D0@0?3`l0P0a<C4303/k>`@0:RXZ0P0c
<c<202d];@805aLG0`0A4A4200L71`@00`<30P071`L200<30`<01`L70P030`<200L71`@02`/;0P0A
4A4302XZ:P80;Bd]0P0c<c<203/k>`Cooooo0Ol000000004o`000?ooooooooooooooo`800`<30P07
1`L200/;2`<05aLG0P0a<C4402@T90806a/K0P0R8R8302PX:0@0>3Ph0P11@D4202XZ:P80<c<c0`0X
:2P201/K6`808R8R0P0G5aL2014A4@L03@d=0P0;2`/200d=3@805aLG0P0Z:RX203/k>`<0ATI60P1l
O7`207AdM080DE5A0P16ATH2065QH@<0IVIV0P1aLG4206e]K@80P8200P1jNWX205QHF0<0De=C1P1[
Jf/208Z:RP80@D510`0l?3`20451@@80>3Ph0P1<C4`2065QH@80BDU90P1ADE4307EeM@80<c<c0P0T
92@201LG5`80>3Ph0P16ATH3055AD@80G5aL0P1CDe<2055AD@80MGEe0P1QHF4306IVIP80Jf][0P1S
Hf<20861P@80OWin0P1RHV8304a<C080F5QH0P1CDe<2051@D0@0?3`l0P0a<C4303/k>`@0:RXZ0P0c
<c<202d];@805aLG0`0A4A4200L71`@00`<30P071`L200<30`<01`L70P030`<200L71`@02`/;0P0A
4A4302XZ:P80;Bd]0P0c<c<203/k>`Cooooo0Ol000000004o`000?ooooooooooooooo`800`<3100;
2`/300d=3@805aLG100K6a/201LG5`805ADE0`0K6a/2034a<@80<c<c100l?3`203/k>`<0:2PX0P0E
5AD400d=3@@02`/;1@071`L200/;2`8092@T0P0o?cl204i>CP80DE5A0`1bLW8206ATI080FUYJ0P1@
D50206ATI080MGEe0`1aLG4207MgM`80SXj>0P1SHf<207EeM@80M7Ad0`1/K6`207UiN@80Jf][0P1X
J6P208n?S`80C4a<1@0l?3`203Ph>080@D510P1@D50203Ph>080FUYJ0`2?Shl203lo?`80:RXZ0P0R
8R8203`l?080<C4a0`0o?cl204U9B@80>c/k0P0o?cl406IVIP<0D51@0P1HF5P205aLG080Ogmo0P1j
NWX206ATI0<0GEeM0P1dM7@206ATI080EeMG0P11@D4203Ph>080:RXZ0`0h>3P403<c<`80<C4a0P0X
:2P201/K6`<08R8R0P0=3@d200L71`@00`<30P00000300<30`801`L70P030`<200/;2`@03@d=0`0E
5AD201LG5`80:2PX0P0G5aL4ooooo`7o000000001?l0003oooooooooooooool200<30`@02`/;0`0=
3@d201LG5`@06a/K0P0G5aL201DE5@<06a/K0P0a<C4203<c<`@0?3`l0P0k>c/302PX:0805ADE100=
3@d400/;2`D01`L70P0;2`/202@T9080?clo0P1>CTh2055AD@<0LW9b0P1TI6@205YJFP80D51@0P1T
I6@207EeM@<0LG5a0P1gMgL208j>SP80Hf=S0P1eMGD207AdM0<0K6a/0P1iNGT206][J`80J6QX0P2?
Shl204a<C0D0?3`l0P0h>3P20451@@80D51@0P0h>3P205YJFP<0Shn?0P0o?cl202XZ:P808R8R0P0l
?3`2034a<@<0?clo0P19BDT203/k>`80?clo101VIVH3051@D080F5QH0P1LG5`207moO`80NWYj0P1T
I6@305eMG@80M7Ad0P1TI6@205MGE`80@D510P0h>3P202XZ:P<0>3Ph100c<c<2034a<@80:2PX0P0K
6a/3028R8P803@d=0P071`L400<30`8000000`030`<200L71`800`<30P0;2`/400d=3@<05ADE0P0G
5aL202PX:0805aLG1?ooool1o`00000000Co0000oooooooooooooooo10030`<200L71`<06a/K0P16
ATH202XZ:P8092@T0P0R8R8202d];@<0<C4a0P0o?cl404I6AP80C4a<0P0k>c/502@T90805aLG100A
4A4200/;2`<01`L70P0;2`/201DE5@80@D510P1RHV8204U9B@80@T920`16ATH205iNGP80J6QX0P1/
K6`206IVIP80RXZ:0`2;Rh/208J6QP80X:2P0P20P80207YjNP80MGEe0`1dM7@206QXJ080G5aL0P1Q
HF420820P080D51@0`0l?3`203lo?`80ATI60P1EEED20451@@80>c/k0P1MGEd306a/K080>c/k0P0T
92@203Hf=P80DE5A0P0o?cl3034a<@80<c<c0P0h>3P204U9B@80FUYJ0P1HF5P305MGE`80HF5Q0P1C
De<207MgM`@0IVIV0`1aLG4206e]K@80F5QH0P1JFUX204E5A@80?clo0P0R8R8302XZ:P80:2PX0P0a
<C4202XZ:P80=SHf0P0K6a/302PX:0805ADE0P0=3@d600<30`T01`L70P0;2`/200L71`<03@d=0P0E
5AD2028R8P806a/K1?ooool1o`00000000Co0000oooooooooooooooo10030`<200L71`<06a/K0P16
ATH202XZ:P8092@T0P0R8R8202d];@<0<C4a0P0o?cl404I6AP80C4a<0P0k>c/502@T90805aLG100A
4A4200/;2`<01`L70P0;2`/201DE5@80@D510P1RHV8204U9B@80@T920`16ATH205iNGP80J6QX0P1/
K6`206IVIP80RXZ:0`2;Rh/208J6QP80X:2P0P20P80207YjNP80MGEe0`1dM7@206QXJ080G5aL0P1Q
HF420820P080D51@0`0l?3`203lo?`80ATI60P1EEED20451@@80>c/k0P1MGEd306a/K080>c/k0P0T
92@203Hf=P80DE5A0P0o?cl3034a<@80<c<c0P0h>3P204U9B@80FUYJ0P1HF5P305MGE`80HF5Q0P1C
De<207MgM`@0IVIV0`1aLG4206e]K@80F5QH0P1JFUX204E5A@80?clo0P0R8R8302XZ:P80:2PX0P0a
<C4202XZ:P80=SHf0P0K6a/302PX:0805ADE0P0=3@d600<30`T01`L70P0;2`/200L71`<03@d=0P0E
5AD2028R8P806a/K1?ooool1o`00000000Co0000oooooooooooooooo0P00000200<30`802`/;0`0G
5aL204U9B@80;Bd]1P0R8R8303`l?080ATI60P0k>c/202d];@8092@T0P0K6a/3028R8P806a/K0P0A
4A4200/;2`@03@d=0`071`L2014A4@80>3Ph0P1EEED205MGE`80<c<c0P0];Bd303`l?080KFe]0P1`
L70208V9R@80Q8B40P2DU9@3096AT@80Ti>C0P2FUYH20820P080L71`0P1eMGD307AdM080HF5Q0P1A
DE44069RHP80ATI60`0l?3`204I6AP80C4a<0P1NGUh2055AD@80>c/k1@1<C4`20492@P80:RXZ0P0h
>3P20492@P80<C4a0`0];Bd203Hf=P80>3Ph0P16ATH205QHF080EEEE0`1@D50206ATI080C4a<0P1o
Ogl2071`L080GEeM0`1aLG420861P@80F5QH0P1NGUh2051@D080ATI60P0X:2P3028R8P8092@T0P0]
;Bd203/k>`80<C4a0P0];Bd3028R8P@05ADE0P071`L4000000T00`<30P071`L200d=3@<05aLG0P0R
8R8202PX:0805aLG1?ooool1o`00000000Co0000oooooooooooooooo0P00000200<30`802`/;0`0G
5aL204U9B@80;Bd]1P0R8R8303`l?080ATI60P0k>c/202d];@8092@T0P0K6a/3028R8P806a/K0P0A
4A4200/;2`@03@d=0`071`L2014A4@80>3Ph0P1EEED205MGE`80<c<c0P0];Bd303`l?080KFe]0P1`
L70208V9R@80Q8B40P2DU9@3096AT@80Ti>C0P2FUYH20820P080L71`0P1eMGD307AdM080HF5Q0P1A
DE44069RHP80ATI60`0l?3`204I6AP80C4a<0P1NGUh2055AD@80>c/k1@1<C4`20492@P80:RXZ0P0h
>3P20492@P80<C4a0`0];Bd203Hf=P80>3Ph0P16ATH205QHF080EEEE0`1@D50206ATI080C4a<0P1o
Ogl2071`L080GEeM0`1aLG420861P@80F5QH0P1NGUh2051@D080ATI60P0X:2P3028R8P8092@T0P0]
;Bd203/k>`80<C4a0P0];Bd3028R8P@05ADE0P071`L4000000T00`<30P071`L200d=3@<05aLG0P0R
8R8202PX:0805aLG1?ooool1o`00000000Co0000oooooooooooooooo0P00000200<30`802`/;0`0G
5aL204U9B@80;Bd]1P0R8R8303`l?080ATI60P0k>c/202d];@8092@T0P0K6a/3028R8P806a/K0P0A
4A4200/;2`@03@d=0`071`L2014A4@80>3Ph0P1EEED205MGE`80<c<c0P0];Bd303`l?080KFe]0P1`
L70208V9R@80Q8B40P2DU9@3096AT@80Ti>C0P2FUYH20820P080L71`0P1eMGD307AdM080HF5Q0P1A
DE44069RHP80ATI60`0l?3`204I6AP80C4a<0P1NGUh2055AD@80>c/k1@1<C4`20492@P80:RXZ0P0h
>3P20492@P80<C4a0`0];Bd203Hf=P80>3Ph0P16ATH205QHF080EEEE0`1@D50206ATI080C4a<0P1o
Ogl2071`L080GEeM0`1aLG420861P@80F5QH0P1NGUh2051@D080ATI60P0X:2P3028R8P8092@T0P0]
;Bd203/k>`80<C4a0P0];Bd3028R8P@05ADE0P071`L4000000T00`<30P071`L200d=3@<05aLG0P0R
8R8202PX:0805aLG1?ooool1o`00000000Co0000oooooooooooooooo0P030`<200L71`804A4A0`15
ADD203`l?080;Bd]100K6a/2028R8P<0>3Ph0P19BDT205aLG080F5QH0P0k>c/203<c<`<092@T0P0G
5aL2014A4@802`/;0P071`L200d=3@<04A4A0P0a<C42055AD@80@T920P0k>c/203Ph>080<c<c0`1N
GUh2071`L080IVIV0P2;Rh/209JFUP80UiNG0`21PH4208R8R080UiNG0P1lO7`207AdM080GUiN0`1Q
HF4205iNGP80EEEE0P1NGUh205YJFP80D51@0`12@T8205YJFP80Hf=S0P1bLW8206a/K080@T920P0k
>c/305=CD`80?3`l0P0f=SH203<c<`80=SHf0P0o?cl302XZ:P80=SHf0P11@D42051@D080>3Ph0P1E
EED305MGE`80FUYJ0P1HF5P207AdM080F5QH0P1QHF4307IfMP80QXJ60P1XJ6P205eMG@80Jf][0P1@
D50203Ph>0<0=SHf0P11@D4203<c<`80;Bd]0P0o?cl203Hf=P<0:2PX100G5aL200<30`L000000P03
0`<200L71`802`/;0P0=3@d201/K6`<05aLG0P0E5AD202@T90808R8R1?ooool1o`00000000Co0000
oooooooooooooooo0P030`<200L71`804A4A0`15ADD203`l?080;Bd]100K6a/2028R8P<0>3Ph0P19
BDT205aLG080F5QH0P0k>c/203<c<`<092@T0P0G5aL2014A4@802`/;0P071`L200d=3@<04A4A0P0a
<C42055AD@80@T920P0k>c/203Ph>080<c<c0`1NGUh2071`L080IVIV0P2;Rh/209JFUP80UiNG0`21
PH4208R8R080UiNG0P1lO7`207AdM080GUiN0`1QHF4205iNGP80EEEE0P1NGUh205YJFP80D51@0`12
@T8205YJFP80Hf=S0P1bLW8206a/K080@T920P0k>c/305=CD`80?3`l0P0f=SH203<c<`80=SHf0P0o
?cl302XZ:P80=SHf0P11@D42051@D080>3Ph0P1EEED305MGE`80FUYJ0P1HF5P207AdM080F5QH0P1Q
HF4307IfMP80QXJ60P1XJ6P205eMG@80Jf][0P1@D50203Ph>0<0=SHf0P11@D4203<c<`80;Bd]0P0o
?cl203Hf=P<0:2PX100G5aL200<30`L000000P030`<200L71`802`/;0P0=3@d201/K6`<05aLG0P0E
5AD202@T90808R8R1?ooool1o`00000000Co0000oooooooooooooooo0P030`<2000000803@d=0`1H
F5P203Hf=P805aLG0P0T92@2028R8P80<C4a0`0l?3`204U9B@80@T920P0c<c<202XZ:P80:2PX0`0E
5AD201LG5`@03@d=0P0;2`/200d=3@<0?clo0P12@T820451@@80DE5A0P15ADD20451@@80@T920`1[
Jf/207moO`80Rh^;0P2PX:020:>SX`80XZ:R0`2ATI4208Z:RP80TY:B0P1eMGD205MGE`80ADE50`1<
C4`2069RHP80FUYJ0P1VIVH204a<C080EEEE0`16ATH2055AD@80EeMG0P1fMWH206ATI080CTi>0P0l
?3`30492@P80?clo0P0X:2P203`l?080;Bd]0P0k>c/302d];@80@D510P0f=SH204E5A@80C4a<0P1J
FUX305EEE@80C4a<0P1EEED2065QH@80L71`0P1SHf<307alO080Ogmo0P1bLW8206IVIP80O7al0P1L
G5`204I6AP<0C4a<0P1>CTh205=CD`80?3`l0P0o?cl2051@D0<0=SHf0P0R8R8202XZ:P804A4A0P07
1`L200<30`<01`L710030`<200L71`802`/;1@0A4A4401LG5`8092@T1?ooool1o`00000000Co0000
oooooooooooooooo0P030`<2000000803@d=0`1HF5P203Hf=P805aLG0P0T92@2028R8P80<C4a0`0l
?3`204U9B@80@T920P0c<c<202XZ:P80:2PX0`0E5AD201LG5`@03@d=0P0;2`/200d=3@<0?clo0P12
@T820451@@80DE5A0P15ADD20451@@80@T920`1[Jf/207moO`80Rh^;0P2PX:020:>SX`80XZ:R0`2A
TI4208Z:RP80TY:B0P1eMGD205MGE`80ADE50`1<C4`2069RHP80FUYJ0P1VIVH204a<C080EEEE0`16
ATH2055AD@80EeMG0P1fMWH206ATI080CTi>0P0l?3`30492@P80?clo0P0X:2P203`l?080;Bd]0P0k
>c/302d];@80@D510P0f=SH204E5A@80C4a<0P1JFUX305EEE@80C4a<0P1EEED2065QH@80L71`0P1S
Hf<307alO080Ogmo0P1bLW8206IVIP80O7al0P1LG5`204I6AP<0C4a<0P1>CTh205=CD`80?3`l0P0o
?cl2051@D0<0=SHf0P0R8R8202XZ:P804A4A0P071`L200<30`<01`L710030`<200L71`802`/;1@0A
4A4401LG5`8092@T1?ooool1o`00000000Co0000oooooooooooooooo0P030`<200L71`806a/K0`15
ADD201LG5`808R8R0P0X:2P203Hf=P80?clo0`1<C4`204i>CP80C4a<0P0f=SH202PX:0804A4A0`0E
5AD400/;2`803@d=0P0A4A420492@PD0ADE50P1EEED205QHF080BDU90P1<C4`205iNGP<0Q8B40P2A
TI4209JFUP80/K6a0P2UYJD209bLW0<0V9RH0P2FUYH209bLW080MWIf0P1CDe<204U9B@<0D51@0P1b
LW8205eMG@80G5aL0P1>CTh20492@P<0ADE50P1QHF4205YJFP80Ti>C0P1eMGD205QHF080EeMG0`15
ADD203<c<`80:2PX0P12@T8203Hf=P80CTi>0`0f=SH203<c<`80@D510P1ADE4204a<C080EEEE1@19
BDT203/k>`80G5aL0P1QHF45069RHP80KFe]0P1QHF42069RHP80M7Ad0P1QHF4205aLG0<0GUiN101Q
HF4204a<C080?3`l0P0k>c/305QHF080<c<c0P0T92@201/K6`802`/;0P00000500<30`P01`L70`0E
5AD201/K6`@05ADE1?ooool1o`00000000Co0000oooooooooooooooo0P030`<200L71`806a/K0`15
ADD201LG5`808R8R0P0X:2P203Hf=P80?clo0`1<C4`204i>CP80C4a<0P0f=SH202PX:0804A4A0`0E
5AD400/;2`803@d=0P0A4A420492@PD0ADE50P1EEED205QHF080BDU90P1<C4`205iNGP<0Q8B40P2A
TI4209JFUP80/K6a0P2UYJD209bLW0<0V9RH0P2FUYH209bLW080MWIf0P1CDe<204U9B@<0D51@0P1b
LW8205eMG@80G5aL0P1>CTh20492@P<0ADE50P1QHF4205YJFP80Ti>C0P1eMGD205QHF080EeMG0`15
ADD203<c<`80:2PX0P12@T8203Hf=P80CTi>0`0f=SH203<c<`80@D510P1ADE4204a<C080EEEE1@19
BDT203/k>`80G5aL0P1QHF45069RHP80KFe]0P1QHF42069RHP80M7Ad0P1QHF4205aLG0<0GUiN101Q
HF4204a<C080?3`l0P0k>c/305QHF080<c<c0P0T92@201/K6`802`/;0P00000500<30`P01`L70`0E
5AD201/K6`@05ADE1?ooool1o`00000000Co0000oooooooooooooooo0P030`<200/;2`80>c/k0`0R
8R8202d];@80>c/k0P0l?3`204E5A@80@D510`0o?cl20451@@80?clo0P0k>c/2028R8P805ADE0`0=
3@d400/;2`804A4A0P0l?3`204E5A@<0?3`l0P1MGEd206a/K080EEEE0P1[Jf/2069RHP80RXZ:0`2>
SXh209fMW@80XZ:R0P2VYZH408J6QP<0TI6A0P2LW9`20;Vi^@80UiNG0P1JFUX2051@D0<0EEEE0P1`
L70206=SH`80EEEE0P0o?cl204E5A@<0?clo0P1NGUh205MGE`80P8200P1`L70204I6AP80HF5Q0`16
ATH203Hf=P80<c<c0P0h>3P202d];@80@T920`0o?cl202XZ:P80ADE50P12@T8204U9B@80ATI60`11
@D4204U9B@80>c/k0P1@D50205EEE@80HF5Q0`1bLW8206a/K080HV9R0P1NGUh2075aL@80Jf][0P1/
K6`306=SH`80K6a/0P1VIVH204a<C080?clo0P0a<C4302d];@80@T920P0];Bd201LG5`803@d=2@03
0`<400L71`803@d=2@0A4A44ooooo`7o000000001?l0003oooooooooooooool200<30`802`/;0P0k
>c/3028R8P80;Bd]0P0k>c/203`l?080ADE50P11@D4303lo?`80@D510P0o?cl203/k>`808R8R0P0E
5AD300d=3@@02`/;0P0A4A4203`l?080ADE50`0l?3`205eMG@80K6a/0P1EEED206][J`80HV9R0P2:
RXX308j>SP80WIfM0P2RXZ820:JVYP@0QXJ60`2ATI4209bLW080^KVi0P2GUiL205YJFP80D51@0`1E
EED2071`L080Hf=S0P1EEED203lo?`80ADE50`0o?cl205iNGP80EeMG0P20P802071`L080ATI60P1Q
HF4304I6AP80=SHf0P0c<c<203Ph>080;Bd]0P12@T8303lo?`80:RXZ0P15ADD20492@P80BDU90P16
ATH30451@@80BDU90P0k>c/2051@D080EEEE0P1QHF43079bLP80K6a/0P1RHV8205iNGP80LG5a0P1[
Jf/206a/K0<0Hf=S0P1/K6`206IVIP80C4a<0P0o?cl2034a<@<0;Bd]0P12@T8202d];@805aLG0P0=
3@d900<30`@01`L70P0=3@d9014A4@Cooooo0Ol000000004o`000?ooooooooooooooo`800`<30P0;
2`/203/k>`<08R8R0P0];Bd203/k>`80?3`l0P15ADD20451@@<0?clo0P11@D4203lo?`80>c/k0P0R
8R8201DE5@<03@d=100;2`/2014A4@80?3`l0P15ADD303`l?080GEeM0P1/K6`205EEE@80Jf][0P1R
HV8208Z:RP<0SXj>0P2MWId20::RXP80YZJV1026QXH3096AT@80W9bL0P2i^KT209NGU`80FUYJ0P1@
D50305EEE@80L71`0P1SHf<205EEE@80?clo0P15ADD303lo?`80GUiN0P1GEeL20820P080L71`0P16
ATH2065QH@<0ATI60P0f=SH203<c<`80>3Ph0P0];Bd20492@P<0?clo0P0Z:RX204E5A@80@T920P19
BDT204I6AP<0@D510P19BDT203/k>`80D51@0P1EEED2065QH@<0LW9b0P1/K6`2069RHP80GUiN0P1a
LG4206][J`80K6a/0`1SHf<206a/K080IVIV0P1<C4`203lo?`80<C4a0`0];Bd20492@P80;Bd]0P0G
5aL200d=3@T00`<310071`L200d=3@T04A4A1?ooool1o`00000000Co0000oooooooooooooooo0P03
0`<203Ph>080ATI61@0T92@203<c<`80?3`l0P0k>c/203lo?`<0C4a<0P0l?3`203/k>`8092@T0P0A
4A4200d=3@<02`/;0P071`L2028R8P80?clo0P1<C4`20451@@<0C4a<0P1VIVH207IfMP80J6QX0P1j
NWX208R8R080XZ:R0`2VYZH209BDU080WYjN0P2PX:0208n?S`80Q8B40`1iNGT20:6QX@80[:b/0P2W
YjL207AdM080G5aL0`19BDT206a/K080Hf=S0P1ADE4204i>CP80?3`l0`0k>c/2055AD@80CTi>0P1b
LW82069RHP80>c/k0P12@T8303`l?080<C4a0P0h>3P202d];@80=SHf0P1CDe<30451@@80>3Ph0P0a
<C4203Hf=P80@D510P0h>3P302d];@80?clo0P15ADD203`l?080CTi>0P1QHF4308B4Q080QHF50P1d
M7@2069RHP80GEeM0P1fMWH206a/K0<0PH610P1/K6`206IVIP80EEEE100k>c/302d];@80:RXZ0P0o
?cl203Ph>0805aLG0P0=3@d300/;2`H01`L70P0=3@d2014A4@<05ADE0P0K6a/2028R8P803@d=1?oo
ool1o`00000000Co0000oooooooooooooooo0P030`<203Ph>080ATI61@0T92@203<c<`80?3`l0P0k
>c/203lo?`<0C4a<0P0l?3`203/k>`8092@T0P0A4A4200d=3@<02`/;0P071`L2028R8P80?clo0P1<
C4`20451@@<0C4a<0P1VIVH207IfMP80J6QX0P1jNWX208R8R080XZ:R0`2VYZH209BDU080WYjN0P2P
X:0208n?S`80Q8B40`1iNGT20:6QX@80[:b/0P2WYjL207AdM080G5aL0`19BDT206a/K080Hf=S0P1A
DE4204i>CP80?3`l0`0k>c/2055AD@80CTi>0P1bLW82069RHP80>c/k0P12@T8303`l?080<C4a0P0h
>3P202d];@80=SHf0P1CDe<30451@@80>3Ph0P0a<C4203Hf=P80@D510P0h>3P302d];@80?clo0P15
ADD203`l?080CTi>0P1QHF4308B4Q080QHF50P1dM7@2069RHP80GEeM0P1fMWH206a/K0<0PH610P1/
K6`206IVIP80EEEE100k>c/302d];@80:RXZ0P0o?cl203Ph>0805aLG0P0=3@d300/;2`H01`L70P0=
3@d2014A4@<05ADE0P0K6a/2028R8P803@d=1?ooool1o`00000000?o0000ooooooooool0gOooool1
o`00000000?o0000ooooooooool0gOooool1o`00000000?o0000ooooooooool0gOooool1o`000000
hOl000000001\
\>"],
  ImageRangeCache->{{{0, 224.562}, {224.562, 0}} -> {-2.05848, -1.93498, \
0.463644, 0.435826}},
  CellTags->"T.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.6"]
}, Open  ]],

Cell["Here the data is successively shifted to the right.", "Commentary",
  CellTags->"T.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[MapIndexed[RotateRight, data], Mesh \[Rule] False, 
      FrameTicks \[Rule] None]\)], "Input",
  CellTags->"T.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00961538 0.0192308 0.0102291 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
100 string
100 94 8 [100 0 0 94 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
362217281517241B1B1B2236585D5850534E535A5C5C5757706D7A84857F6B63666D5A41
464646382A150D070703030303110B0B0B031711151B1B24242833333C424138382D3133
42454C6464574E45464E4E5551555E6D575D6263755D4C535C5A4C46
53502424221B1B24222A221B385D4C4C514E46464166766D5C616C53536280887568504C
46413C3828220B030703070303071117110D242D362A332D3133363633282D2224282222
1B171B315742453338574549464C585E53505C5357585361504C5151
453836222A2A2417171B221B22465345494C4C3F454946556266465763705C5768746162
4C423B4233220B07030003030B0B070733241B3F453F50513F423B3338362833241B1B17
151111111B281B413F46413F3B3C3C494242414E5155775E51585C51
452A332D223322281B1B22241B2A51534E46504E5049424957536B74645A68716B637C64
68635D4928220D0303030B0303070D0D171B2D2A283F5A58422D282A2824282A2A22221B
15110B0B0B0B0D2231454636313631363B42495C6B61535A51514C49
3F312A38381B17221B1115172217384E534942413F503F4550495A4E4E6358666C777C68
7271855C552415030307070B0D150B0B1B22333C36312A36383B413C363624221B22171B
24150B0B070703030B112A332A2D332433384151463C38363C50503F
2A2D38363C2D15171124150D1B242238493C3C3B3F3F38494C533F4951535E6262635A71
7781816C5D3C1B07070D0D0D070B0B24244651756D70794E3F495E867781705141332215
15110B0B03030703030307111B24222A1B2431313631383338422A2D
3B4136383F3B38221B1511171B1B28244650364236383B5050513C4955465049535C635A
706C636C75572A11030B07030B0711152D5364818F8A81765045455D79918D8D77665536
22150D110B07030703030303070B172A282231222D31333B332D282D
3B49463C3C36312D171722152415221B173C413C333336465C4C574946534C535163759B
A77C7785643F28110B070B150D1B2A36497C8D91B6B1BBB87E4C174980A29E97AAA6967F
55494124170D07070703000303070715112D312422242828313F4C49
28172A33333336363B221517151517172228363B382D2D3B50463F463C495A5758585C6B
7280977C846336170B070D0711283B517297A6BAB3D2DDFAE07C220D0D4EACC7CCD1BA9D
9B856846362822150B070303030703030B22222D2D151B1B171B1B24
152222171B222D2A24242A171722171B1524223B4C4131415050425849534E42515C586D
706655645E513F150B0B070B0D243C5E6C96B3C4D8D6E2E8D1661B0B07070D3B94C5D0C4
968B7E715C503F2428110B0B0300070300030B070B11221B150D0D17
221B1B22171B2D2D282D2D150D15151B1B221B2250383841423F493B36364E4150585153
57616264615733150D0307070D225072858FB3BBC8D7D8DDD08B220D03070B0B22589CC3
C8AE92807672644636312211110D070303030003070D172417150D11
0B172228221B2A28241B241B1B1B2411151B2424223638363C41424E574C4C414141415A
6D5C667563311B0D07030B07222A38557596ACA8A3CBD0D8C47C420B0D0B0B0B07114175
97B8ACACB3857A7C64573F3333150B03030707000003030303070707
03070D111B1B1B2A2D311B243117221B1B1B2A1511283F3B334C51425141413F3B455566
636B6355422D220D070B0D0D152D425E6498A6A69EB4D1DFBD7F2411110D2811110D0B07
38688497CDB5A18F88626662573C241517150D0707150B110B030303
03030003070B0B1515151715151B1717151111171517283838383C3F424145414246454E
5350614C3624152D33221728151B3F636C618DA2CCD8D2DCD0A036171722172222171711
110D2A7293BBC4CEBAB39B775E57583F2A1B0B07070B1B17171B0703
110B030303030707111522221B22242217151115221522283B3B3C4146454553413B4E3F
413C3B2D241B112D50573C242222314E626D8EC2C0C9D8DDE2C9812A1B17364955553C28
1B17111B6C91A3BAD5D1CBBBAB9D53515742170D070B0B112831332A
41573B1507030003030711171B38362D15171717151B15111731333649423C3F3F41383C
453C3124170B0D113B72573311151B5863617C91C3C5C5DAE4D5B9A65531386D86869186
684E362D53888DA5A8D5D2C293A28A7150333B3822110B0B172A383F
4255464945220D07030303070B11221B1515111722111B17111B28312A413B45453C3B38
2D3324221111285A68614638221738505E6D8577719CD2D6D6E1D5B9D2767784AC9DABA6
A8AB7C5A5563C7A69CB4D0C2AA9E81645E6C53383B4628150B0D1B31
2D31414E4C4E45311107070B070B111B171B1115170D172222171736424236333F454238
312217110D0D3341795E41362A2A2D515861667270A0DBE0C4D0E0E0D2BA9286A7AEA5B9
AEA8BA988A716BAEBEC9B5C8B8AEC8BE91666C68574250411B110D1B
173145384C6C685A4E2D1507030307111B1B28171B1B0D151B221522313B42424246383B
3322150D0D0D2253575842382A17243C454257555588A5D6D7B8D5EBE4DBAB969CA1AAB3
B3B4B3B6A28E74687FC9E2D6CDBA9EB8BAAB805851575A382D1B0D0D
0B15222838413B4C5A625E531B0707070711152215111711111717151B38453F383C3C38
3138221B171741776C463331281B1B28385C6C755C7E9BA6B39CACD6F0D1A2868F9EB9C4
C2B4B4BBB3A6A07F6C5A89CBC0C4B3B1B4A7989C7C58716D55332D22
311B1715222D3C3F364C5E746D502A17070B0B0D151B171517222224171B3133383C3838
362D1B17112445585C583F3B281515224662767F6D717697A898ABBED3D7A68863A3C0C3
C7D2CDE0C4B9B9B5A66B5862869CB3A8A2ACAA9C8584745E63795D42
5D4C1B0D0D151B313C45382D3C5C5E513C1107070B1122171715151511151B363B334141
38332824171B49706B453C2A17150D11222D455D70636D7988A5B5B4C3C7B397896D9DBB
D5D8E5EFF3E9C9D2C7A8755D707C91A59DBFB59D8571615053423F53
382D2A220D0B070D24313B3C3B3B4249453C110703070D171B2217151111152431423C38
2D382A1B1722466B513C2D1711150D0B0B1B2D5068758F7C8EA1B8BAB3BDCDAEA08B79AE
CCEEF0F4EFF4EFE5EDD5C08A66718088938D92ACA5948468686D5E55
61493C33110B0D0D0B0717363F46503F314242330D070307150D0D0B1117150D22383C36
312D2A1B1B315563493C3C2A110B0D0D2A42506271748F9CA5A8ABBDBBACC4BAAB947970
B9DFF2F3EDFCF4F3F5F5F7E0936B717079948A98ACC0BAA6967F6D77
7168574E453B2D110B03030B0D36364E665746424E280B070B0D0D0D0B0B1B2217152D33
3F382D2D1B223142505C3F2D150D0D0D1B416375809198A1AEB4AAB4A3B8BDB39B9B916D
63C9E1FAF2E6F8FFEDF5FEF5E49B6D556B899C88A3A1AAB3A6A19884
8D8E89867E664C3F33110D0703030B2D45415A66585A4E280B03150D15111511150D1724
33382D1B1B17244946463117110B1B242D3C636C6B53669D97A2AAC4CEC7BFC2B0A78F7E
757FB6F0E6FFEDEDE8EDEAF0EDE5AE856C628A9276847A849DACA69E
8D8A7C645C5A6B5850513B1707070B030B173F424C61614931110311110D110D1115111B
28313331243C173B51502D110B0B1131707C7C7570646D61718D96B3C9D0C4BD9B8FA196
6D8696BAD3E9F5DBAACCEBEDE5E0DB9E8F7E6B7079756B778E8B7E91
8B757779705E5D6162505551360B030303070B1133454C3C5A3F220715111115110D0D11
242D3133241B222D454636110D15153B618E7E72645564635D6381919CAEB4BD97AA748B
806486B0A7C0E5F5C489B9EEF4EDD5CEA88F7C6C797E70776C8A8484
8D848563707A777972615555534E4522030303030B15314C5750493311110D150D1B1715
1122312D2D24221B414936240D0D28537674897F75757262637270799398929C9D978885
867561729CB3A8CDD59385B5E6EDE0C4AEA08E7258558D7A775E8A7F
92867C8A805D5C5E6D717761554E4C4241310B0303071138333C625C452D1128170D1111
171517282A2A28222D454E2D15153666759286768D858F7E75807E88AAA2A08E9C8A9188
7E8D806172989DA6A5AAA1A1B3C0DFCDB3A19C927057497A727A6388
949B8D898A8B7C797781797C766C5D5C575D53420D070307172D3C36414E3B150D0D1111
11171117282A282A33415D422422385E7A848885758D8B8889848080A7ACC5B9AEACAC91
A58D93798076A297AA938991978A84A0A397B4A68881625771728170
7CA6A69BA68B949D91977F978E7672765A535A5542311503070B1B38453B423B15110D0D
110D151117172428242A4C4C31364C636D777A747080989E977A7FA68EC0BBD0DAC4D0AA
8B755161708F9BA69DA08F9B93817479858E94AA98928E7A53748D80
4557A7B4A2B3A7B3B19693947C88705D715A515A5045333B17070B0D1B2D464546170D0D
150B11171111242A2424334236384255637C70745D5168808D98A39CA0D6B5C0CBC2D3DD
B37971415E799B9C9496A38A8879796B748198989696A19C9264496B
53516BA3A8A1ACA091A3B3A39D91808A6C66776B554C453C3C45110B0B0D243645550D22
110D0D1111110D171B2424383F3F4C6C808072504E535050708FA2BDC3C5BEB1AEABB5AA
ABA88A66587297A891848497857572636C7E6C80848A928FA58D6D4C
624E7476807C808679758A93A6A2A7796D6D6C764C3F33384250533F110D0D0B17223B11
11110D0B0D1515111B282A2A3F36425D88896C62453C514E58779DC2D2C7988A81898581
88847962585A74A1A5936D707A7466625A515E68647280799BB39D7F
895C425A63645E5E64625C6D71758D98968976666D554238453B36333C240D0D15111B38
17110B0D0D0D0D1511111B1B36453338717F6D555D49504C506689C9DBC3A68E745E5C5D
61766D624E38557F9E9B8D6B63625D5C5553495E63575E72778692A2
989D64421B28414C5145464E49535A68778BA3927A614C45424146503C2D221711111111
2A11110D0D0D0B0B0B0B111517384141417A755E62554645456C8B8FD2BD937449424657
5E50332A24312253929D89725C575551515046535E5862586D6C7480
889298714C0B17111B1B2A3F3B3B2A2D3C5870868D97776B5849362A31362D3B2A151717
1B240D0D0D0D0D0B0B07070B0D24383346586B79725D5145455E6497C5BB7F5D7F869398
A3D0EED03C073333588F8A755742454E503F495E535A5C55575D5366
687E8EA08B4E11110B0B64C5E0DDBBA77F42314571848E9164705A362D362D3131241717
171B170D110B0B0B0B110D111115313B4C42687566616158615A797FB4BD7045B5B67C31
152D9CE0AE450715507685725E53413F424242505C574C535A4E4C53
50636B768E7E581B030317B3DCC7A58896B3C5862D4C6C7F8975667450383C2D243B2415
17151115070D110B0B0B0B0B0B110D2A4958466D6D6151665158748BA0AC864698B37517
070303226D3615283C727074625A46423B46414249514C49423F4E42
33423F5C646C62663F15030741A68B5115156493D0AC42457E93887A615A4E3C383F3124
22222D2422030B0D110B0B07030B113342705D4E5E5D58585551587C84A58B45628D460D
030003070D1533424E5D6D6D5A533C463149423B4C3F5A554255423F
4E3B333B505055625A4C3C2D170D1522070300032A8BC0A84153A692855C4E515736362D
2A22242A2A2A070307110B0B0B0B0D22313C5D5A5775624E504E5C718B8F8B3F31634211
0303070D15314C5A585D5A494C383F2D31313F3F3F4E494555495755
49534531413F3B534E4953574E5331150B070303030031637A773676A2A3867653383C31
362D2424242D2A0300000B0B0B0B070B0B223F4C5168625C57515077919289713B425D33
2A223C556D5A624C51424E513C382D312D423B3C3B364E3F41574245
3850464146413C313F494E424945575A42332211110B0311495A6B41507A898A84614942
2D2A2A2A1B222431070303030D0D0707070D1745514C626858574951687184885C3F4949
3838386264706B5C533B42493F382D2D2A2D3631503C38533B3B5750
493F5150514241363C333C49463C3B455C575E53573822172436505D683F768A7E715D42
3B362D3C241B112231030300000B0B0B070B152D555151685D716C706651585157504141
585D897266616466745E535E5041382D2D243B33463F3C58625E574E
453C53555A4545383328362A364E4E494E505758615E5C534938313346462441534C6158
5C53382A332D1517222403000300030D070B152A3B58585A665E514957666C4941384955
6B77856C6B5D496368747463575149422A3128313F41464E4C645D53
505A5E586B5D45423336383624314546585E555E5C555A5A63626D7A5E4E3C3B41515866
684E3C413B3B3317171B280300000000030D0D113B5C635C5C6262635A61635C71534E50
5D6679765D5A68555163636157556B4C4E332D46413F5141454C6461
635A616155716C4642312D2D3F2D364255515E6B625546534E5A5E57575A504C46504955
5A5A50413B383F3317171B2D0300030000000B07113F645E626471615E6361716B574E5C
775E63585C4C505C58616264555871754646333F4149464646414162
4E644C6249515A4241453336383C3B3F45644C505E685C5345504249464C534E58554949
38363C4E4149463C31221B2228030000000003071117505C55515C6153576C4C465A5E5A
5D4C645768504E4E4558708484635E637C5A453836363B49464C424E
5051645C5E455757493F382A4141453846506D5745536258505E504641493F534C3F4650
464C424C53414946413B2D22242803000000000307152D495349504C4E3F4E5E5E57586D
71725E58625350555864576175615770817053533B4146313645554E
6B515A647272635A49464E453B38423C3C4E58705C4C465D51423B383F41383B363B4642
49414E515A5149493B49423324242D0000000000030311424E464957504650505D575D68
7476585A55615D45506B635A5C6B7464638471614955464141333F4E
55705E515E6C5866515E4553464E454E42455D646868625D5D585D4C333C3B3C42423C4C
3C4C4C55553C3B414645504E4631172A0000000000030724495758575A585155555E4151
536471706B5D57584E50535761747F77646B7F7958555D4E3F453F41
4257555C576B7C6163756353453C46423C42505353775A6368715E62554C3C383850413F
3F423C3F42413B3F4650514C45414531150000000000030738515D6C554C5550535A6263
61648479716861625E58464150585E757F617479815C5158504E4E3F
3F586C61706D5E75766B866D5041464242383F503B456D624E4C58504C4649383633383B
3F424E494246455A514942463F414536333C0000000000030B465E62705C505A5A585A42
49585E71845D5D51414C5772645A575A859B6C8888776B4E64534258
5E665E756D728E706C86616B755E50424C3F3C4E465545616C575151534C4C4E3B3F3C2D
2A36453638413C3C364645413C4E3C49464C41000000000307224E6B555A57536151493F
42464E5E57554C4258424E5A66585A63808F8A7568635D5E66726451
58575E71666664817C7FA16C55636257495150424949553F58505C5A6D4C4E57585A413F
382D31362A2A2D383C312D332D38413C4249514903000000000D42554E5D554C535A453F
4936363C42504C4C42494C464C534E5D74A096725D574C495A646361
645771635A685C7175818497725A6D6361385D455C455851454C4C5A51615C464551505C
5042363636242D312D33425041494C363831363B330000000003113C50585842423C5042
384242465055495061505557454541618A84857E6B464C3C42495357
4C4C5D5D575E7571967F98968F8A647F7C6D575E5D57554C53414E5053574E4E61495045
424C3838383B4238414245423C3B333B45494E4141410003000003335D5A4E5145423C3C
33313B46495D5D464C5E55454E55575758757F71634C463F3841415E
585C61585A5D6286719B9D8AB0A59D7E7276625E575D63585155423F49364C3F515E4646
57493C36362D363B3B3C3C313338312D3C363C45413C3300000003073C6B645E70715749
493138383B3F423F41464E5350585E535A6C7971614E3F463136424C
45495E7A6164716476819CAA8E9CAEA186807A61725E6B6D5D5D4E463F3C333831384C4C
4C5755463B31382D33242D382D2D2D33383F423B36242D33000000030B45726C6D5D5753
3C313B36423641493F383C383642455050647172665C384233383F41
382A4555868E6270808D98A0B49CA38AA2AB86746B8A7E7275685A4E4541382233383C38
3C3B4150413F3B3F312A221B22382824282D3133333B3624330000000717626C5C535051
3F334C45464C5351494C36463638465751536166666D5D423F333336
313B454C517492798B7784ACB1B397949E8BAB8D777E807C8F7A5D50614C3B331B333B42
333F3B3C4C3B2A31313B2436222822332D282A283138383B463100000307225C5D514E42
3B464541414E553F3F41333F3F3F3C424C5E49495558515A503C3136
33464538385A5E94B8BE8676A093968F89977FA688889684898E806C5D613C313131333F
3B2A2D3C313B3B2428222D242A22281B22222428222838363B3B420000030B113F62583C
41453B333B3F3F3828312D333C3141413641534C4C414E414E533F2A
3C33314C3841466B81B5C7937092796C8E809281948B769BACA6948A7757553F3341313C
2D313838332D3C2D282222151717221724171B241B222815282D312D000300030D245055
46423831413F3C3F3631384E3C363B332D2D31464E4C41503B4C4E3B
31412D2836415151648188A1966B797E7E8E8B8D7E8F88858AA0B08F8B795842493B3F3B
362D3F49362D2D2D312A152222171517171715172A2D22282D41423633030007030B173B
51423C3628242D242A3B333C4C36312D31311B1736383B4646314541
332828312D2A2D38514C886B867E66929391718F8986849E8D758B9C967C765149463C46
36333F41463824282D2217241717111B15172211151B312828333F3B3133000007030307
1138423B311B1117242438313C33282D2836311B2A3C382D412D362D
312A242D332D2A362A38617277807E53807F986C77817C7E929C9C79A092815A494E4C3F
3B3136332D282822222A17171B1B1B1B1111110D1B15111724242433333B330300030003
070B28455141332828282D2A31382A2A242D312A2428313628332A33
3C363624313F363B38414157728B85865D6D7A8F5D5779778D799385948A8F6B62514563
58363F3B2A282422242A3324173617221B1515150D0B1511111528242D24283100030303
030707113C505042313B31222A283336221B17222A2417222A282D2D
362A3638282D2445453F4E515553777194556B728A46587A7A84718474A36D7C615D5D51
63422D313F382A2A22282A2415171715221117110B0D0D0B1717151B1115282824070703
0003030707244651553F221B1B28242D2215171B241B171B1B1B1528
2A33313F3131382A284E36454E4268515E88586C7184515179745E76706D8F7A63615A55
4E50363C38413633312A33222415171B1711110D0D0D0B17170D0B1B151B150D242A0003
00030303070D153B38312A33281B17171B2A221B2A33362824222428
2228332D1B282D3F452D3B38425E4C5D766B85715E6181494672745E5C5D68777A666451
5558423C46333F362D2A2A28241B2422172211110D0D0B0B0B11220B0B112822170D1703
0D0003030303070B363F423F282D2D31332424242A2A282222223831
2824282A2A1B1B38453F36312A38535E576D7F8E667158755D626D66555861617470685C
4E5A46363F3F334E28242A24221B172A1B17150D1111110D070B0B0D150B0B111B151517
03030303030303070B3651493C2D2D2A333B2A1B2D2D28241B242433
151B24282A31222236413338313B3B455764668681716C6D585C6655554949685A797475
5E583C413B58312A3831222D2D22151B3322110D110D0D0B0B07030D0D0D070D0B150D11
110303000303070707112A493831383F2A333B332D2824221B282215
150D11172424362822383F2D42493B515D6C796C629C9750504961635E415363625A8685
86685C4941413B24223C2D1B2828171B1724170D0B110B150D110D0D070B0D07070B0B11
241B070003030303030B172A383C2D333338533C2A242D1B17171115
24170D2415221B2222242D494E4C4E3850666871857975915D3C61636C6636465D635C85
646D7E664E4555312824332A2228222415110D150B0D0B110B0D110D0D0B0D0B0D110B17
0B0B110B0303000303030B2250493F332A423636423F3F282D2A2822
150D151B15221B1B222A28363C414C50584150576693947E895E417068855C414C5C5157
796364766846363C333138221724241B221B1115110D0D070B0B0B030B030B0D0D17151B
11110B0D070303030303070D454C4145362D362A332D243831282424
110D171B1B171522282A36333C3B4142625161625D64868E758B6B4C6164815338585C42
58646C6D6C62553831332D281B172A24152417110D0B0D0B0B07070B07070B030B0D1724
2D2A2A17170303030303030336614E45575351515036362D33361B17
281B171717151B1517242D28384C51494951516D6B86817E7F8172534E5E647042496B57
3F4C5C817C6D5C4E4942312D242D28221B1B1B221B150D0B0D0D07070B07070D110D0D15
172A172428380303030303030D577251575D66714E4131334131221B
2422110D0D1711112217243B313C42494251504E7E7F8996795C8A61623F6D715A425D6C
4536515C89818B5D46503B41513331282A222A24222222220D0D0D0B110D0B0B0B0D1117
1B151B1715111B00030303030D22535A453F5C575C503F2A453B1722
170B07070B070B15112436333C453C4553504E68648997A6A79262797664575170463651
553349575E707C765D465E5041553B383336312D242A242224110B0D0B110D0D070D1117
1115150D070D111103030003030B2A50453F464545382D31221B1B24
170D07030707070D111B2A36413B533B3C495A586C6D7F7EA7A69E705C846250425E4636
41423C415D5A66717A6C4E5C4C5A50413F383633312D242422170D0B0B0B0B15070B0D22
11241B150D0D0B0D110303030307243F5C36282A24282D362D36221B
150D0B07070303070D223342383B42503B424263667277847072A27C5E53685546334233
2D3F3C334C685363747275646250635D4145413F413831332D281B150B07070D110B070D
1517281B221722281B1703030303112A4262383150312D2A2A221515
110B1107030703070B15283C463F4C514546424674616C758A7E6D867F5D46505E463136
2824282A3157664E4679777C7F665D705D514958464C4C4C333833282A171107070B0B0B
070D0D1B2A33383636313600000303152A3133222A28362831311711
17110715070B0703030B1B3646454C5D50363F4C5C6266617A766C808E7642503B53513B
423122151B31625D64587A637A7770687C76534961555A553F332428282A1B110B030303
0307070B111B363C493B3B3B0703030D15172A28242A38311B2A413C
362D17110B07030707070D1B364557705D454250505C68775D70636479866C464E3C5A57
3F5053171B17425C57615E746371766B668076554C53505546493B2A222D31240D0B0703
03030307070B0D1131455550490303070D281722222A1B24313F333C
33281B2217110D0D0D0B0D172A3B467C7451466166716D807A58536B6B6B8A413C41384C
614951753324173846515C53517561666B63817E624C5853503C3C313B2A2A332D171107
030307030703070B0B112A2D333B03070B173124241B22283838412A
3C3B28150D0D0B0B07070B243F4E5172645A50647571778E6375746C796B688F4C3C3C38
4150385A8F3F2A223C313F493B3F666650585C7F7A645D74645741382A38333331281B22
0D070303000307030B0D0D15172817030B0B0D171B1B17151B31333C
464C3B24241711110B070B1541624942465E686C668A8B86A0807A7574685C6180503C3F
4655413B5D6C3B2436513F313338495A58576153776666716D585A453F222A28312A361B
28150D030303070707070B070D15221B0303071B462A24222D313F46
3B2D241B221B110B0D0D0711385557332D3C6D708984949193968070757461516262463C
464C5E513B4C4C422A3842312D363846585550644C7F705D7181585E50462822242D3B31
2D22151507000003030303070D1722281700030B17492D2222223C46
495C583B332417110B070D113151423B38335E70668B96978188977C745E615E555E5A50
425A63726C423B533C3633363F2A3641503855575A587458617686685D6B50383641332D
3F362817170300000003070B0D1B17152422030711453C2D1B1B2238
3C4942332A2815170D0D0B0D3F4241514541426B7F8BA0A3A2918A927557454C625A664C
5546515776644E3C423F283C2D3B2D4136454C5A554C556170637C7F72667C5C464C4E53
3C3F5036222A110703070303070B111117172403000D583617242231
3F4C4E4C362811150B0B0D114245455558494C5E849196B1A59C98969C76534950725D5C
4E4245615A9375585745332842364E363341514C5549493B5C6162626D616274615C5E61
614C3C3B5833241B0B00030307070707151B151503071B4517222836
45413F413F3B22150D0B0B113C453C5D6C556B628A8E9DA2A68686919CB9975A50557063
553F453F5E5780704661463633382D423F2A4542494641493B505561726C625E716B6C63
6C664C3F312D422D170D0303030307070D11111111030B3B222D3B3C
3C3B3F4C3C3B24110D0B07223F4C414C6676687A88A2A6949EA08F8479A1ACA7745C496C
63514E3C3B514E72623B423C31382D36534138313641382D3F453C4E61848574625D766C
816C66553B3B2D2A3F38170D0B0707070D11151B220D033846242433
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{227.188, 227.188},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003S0000hb000`400?l00000o`00003ohol00000
0003o`00003oool0oooo0=l0oooo0Ol000000003o`00003oool0oooo0=l0oooo0Ol000000003o`00
003oool0oooo0=l0oooo0Ol000000003o`00003oool0oooo0=l0oooo0Ol000000003o`00003oool0
oooo0=l0oooo0Ol000000004o`00003oool0oooo0?ooo`80=SHf0P0R8R8301LG5`80:2PX0P0E5AD2
01LG5`8092@T1`0K6a/2028R8P80=SHf0P1HF5P205eMG@<0F5QH0P1@D50205=CD`80CTi>0P1CDe<2
05YJFPD0G5aL101GEeL2071`L080KFe]0`1jNWX208B4Q080QHF50P1oOgl206][J`80Hf=S0`1VIVH2
06e]K@80FUYJ0P11@D4704I6AP80>3Ph0P0Z:RX201DE5@803@d=1@071`L800<30`<04A4A1P0;2`/2
00<30`805aLG0`0A4A4201DE5@@06a/K100T92@302PX:0@0<c<c0P0l?3`20492@P80@D511@0h>3P2
02d];@80<C4a0P0c<c<20492@P<0ADE50P1<C4`406ATI080EeMG0P1>CTh304E5A@80ATI6101>CTh2
05EEE@80DE5A0`1EEED205iNGP80KFe]0P1GEeL205eMG@80HV9R0`1SHf<207EeM@80GEeM0P1<C4`2
05=CD`80G5aL0`1JFUX204a<C080ATI61@3oool1o`00000000Co00000?ooo`3oool0oooo0P0f=SH2
028R8P<05aLG0P0X:2P201DE5@805aLG0P0T92@701/K6`808R8R0P0f=SH205QHF080GEeM0`1HF5P2
051@D080De=C0P1>CTh205=CD`80FUYJ1@1LG5`405MGE`80L71`0P1]KFd307YjNP80Q8B40P25QHD2
07moO`80Jf][0P1SHf<306IVIP80KFe]0P1JFUX20451@@L0ATI60P0h>3P202XZ:P805ADE0P0=3@d5
00L71`P00`<30`0A4A4600/;2`800`<30P0G5aL3014A4@805ADE100K6a/402@T90<0:2PX100c<c<2
03`l?080@T920P11@D4503Ph>080;Bd]0P0a<C4203<c<`80@T920`15ADD204a<C0@0I6AT0P1GEeL2
04i>CP<0ADE50P16ATH404i>CP80EEEE0P1ADE4305EEE@80GUiN0P1]KFd205MGE`80GEeM0P1RHV83
06=SH`80MGEe0P1MGEd204a<C080De=C0P1LG5`305YJFP80C4a<0P16ATH50?ooo`7o000000001?l0
0000oooo0?ooo`3oool205=CD`80D51@1@0T92@2028R8P@06a/K0P0T92@3028R8P80:RXZ0P0R8R82
01/K6`80>3Ph0P1MGEd504a<C080DE5A0P1>CTh404I6AP<0@D510P1VIVH207IfMP80KFe]0P1LG5`2
065QH@<0K6a/101CDe<2069RHP80P8200P28R8P307EeM@80J6QX0P1@D50204a<C080ATI60P11@D43
03`l?080>3Ph0P0X:2P2028R8P802`/;0P030`<300L71`800`<30P071`L400<30`<01`L70P0A4A42
01LG5`804A4A0P0=3@d202@T90<0;Bd]0P0f=SH202XZ:P80<c<c0P0];Bd2034a<@<0<c<c100f=SH2
03<c<`80:2PX0P0];Bd3028R8P8092@T0P0X:2P4028R8P806a/K0`0G5aL201/K6`80<C4a0P1GEeL2
0492@P80ADE50`0c<c<203Ph>080EeMG0P15ADD204U9B@80ATI60`1<C4`205QHF080GUiN0P1CDe<2
051@D080G5aL0`1CDe<205MGE`80F5QH0P1CDe<2065QH@80D51@0`1<C4`4055AD@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80De=C0P1@D50502@T90808R8R100K6a/202@T90<08R8R0P0Z:RX2
028R8P806a/K0P0h>3P205eMG@D0C4a<0P1ADE4204i>CP@0ATI60`11@D4206IVIP80MWIf0P1]KFd2
05aLG080HF5Q0`1/K6`405=CD`80HV9R0P20P80208R8R0<0MGEe0P1XJ6P2051@D080C4a<0P16ATH2
0451@@<0?3`l0P0h>3P202PX:0808R8R0P0;2`/200<30`<01`L70P030`<200L71`@00`<30`071`L2
014A4@805aLG0P0A4A4200d=3@8092@T0`0];Bd203Hf=P80:RXZ0P0c<c<202d];@80<C4a0`0c<c<4
03Hf=P80<c<c0P0X:2P202d];@<08R8R0P0T92@202PX:0@08R8R0P0K6a/301LG5`806a/K0P0a<C42
05MGE`80@T920P15ADD303<c<`80>3Ph0P1GEeL204E5A@80BDU90P16ATH304a<C080F5QH0P1NGUh2
05=CD`80D51@0P1LG5`305=CD`80EeMG0P1HF5P205=CD`80HF5Q0P1@D50304a<C0@0DE5A1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1CDe<2051@D0D092@T0P0R8R8401/K6`8092@T0`0R8R82
02XZ:P808R8R0P0K6a/203Ph>080GEeM1@1<C4`2055AD@80CTi>1016ATH30451@@80IVIV0P1fMWH2
06e]K@80G5aL0P1QHF4306a/K0@0De=C0P1RHV820820P080R8R80`1eMGD206QXJ080D51@0P1<C4`2
04I6AP80@D510`0l?3`203Ph>080:2PX0P0R8R8200/;2`800`<30`071`L200<30`801`L710030`<3
00L71`804A4A0P0G5aL2014A4@803@d=0P0T92@302d];@80=SHf0P0Z:RX203<c<`80;Bd]0P0a<C43
03<c<`@0=SHf0P0c<c<202PX:080;Bd]0`0R8R8202@T9080:2PX100R8R8201/K6`<05aLG0P0K6a/2
034a<@80EeMG0P12@T8204E5A@<0<c<c0P0h>3P205MGE`80ADE50P19BDT204I6AP<0C4a<0P1HF5P2
05iNGP80De=C0P1@D50205aLG0<0De=C0P1GEeL205QHF080De=C0P1QHF42051@D0<0C4a<101ADE45
0?ooo`7o000000001?l00000oooo0?ooo`3oool204E5A@80>3Ph0`0f=SH2028R8P@0:RXZ0P0T92@5
01LG5`806a/K0P0R8R8201/K6`808R8R0P16ATH305=CD`80ADE50P19BDT404a<C080?clo0`15ADD2
04U9B@80ATI60P1EEED2069RHP80IVIV0`16ATH205MGE`80Hf=S0P1`L70205aLG080EeMG0`1XJ6P2
07AdM080HF5Q0P1RHV8204a<C080@T920`0k>c/20492@P80<c<c0P0R8R8200/;2`801`L70`030`<2
000000@00`<31@0;2`/400L71`80<c<c0P0T92@201/K6`<0?clo0P15ADD203lo?`80D51@0P1ADE42
03lo?`<0@T920P0k>c/203<c<`80>3Ph0P0f=SH202PX:0<0<c<c0P0T92@401/K6`805aLG0P0E5AD7
014A4@806a/K0P0X:2P201/K6`<0@D510P0o?cl204I6AP80@D510P0o?cl203/k>`D0?3`l0P19BDT4
0492@P80@D510`1>CTh2055AD@80EEEE0P1gMgL205iNGP80DE5A0`1HF5P205aLG080DE5A1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P15ADD203Ph>0<0=SHf0P0R8R8402XZ:P8092@T1@0G5aL2
01/K6`808R8R0P0K6a/2028R8P80ATI60`1CDe<204E5A@80BDU9101<C4`203lo?`<0ADE50P19BDT2
04I6AP80EEEE0P1RHV8206IVIP<0ATI60P1GEeL206=SH`80L71`0P1LG5`205MGE`<0J6QX0P1dM7@2
065QH@80HV9R0P1<C4`20492@P<0>c/k0P12@T8203<c<`808R8R0P0;2`/200L71`<00`<30P000004
00<30`D02`/;10071`L203<c<`8092@T0P0K6a/303lo?`80ADE50P0o?cl2051@D080DE5A0P0o?cl3
0492@P80>c/k0P0c<c<203Ph>080=SHf0P0X:2P303<c<`8092@T100K6a/201LG5`805ADE1`0A4A42
01/K6`80:2PX0P0K6a/30451@@80?clo0P16ATH20451@@80?clo0P0k>c/503`l?080BDU91012@T82
0451@@<0CTi>0P1ADE4205EEE@80MgMg0P1NGUh2055AD@<0F5QH0P1LG5`2055AD@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80ADE50P0Z:RX303<c<`80;Bd]0P0R8R8203<c<`808R8R0P0X:2P5
01/K6`808R8R0P0T92@201/K6`80:RXZ0`1ADE4205=CD`80CTi>0P16ATH2051@D080CTi>0`1@D502
04U9B@80@T920P19BDT205MGE`80De=C0`1[Jf/207AdM080I6AT0P1JFUX206QXJ080LG5a0`1[Jf/2
06=SH`80O7al0P1TI6@206QXJ080Hf=S0`1MGEd204U9B@80:2PX0P0R8R8200d=3@L00`<30P0;2`/4
00<30`<01`L7100=3@d201LG5`806a/K0P0];Bd302XZ:P80:2PX0P0o?cl205YJFP80F5QH0P12@T83
02d];@80:2PX0P0Z:RX202PX:08092@T0P0X:2P502XZ:P@08R8R0P0K6a/201DE5@<04A4A200;2`/2
00d=3@<08R8R0P0a<C4204E5A@80ATI60P0f=SH2034a<@<0=SHf0P0a<C4203Hf=P80>c/k0P12@T82
04U9B@<0G5aL0P1[Jf/2065QH@80De=C0P1JFUX5055AD@80C4a<0P19BDT50?ooo`7o000000001?l0
0000oooo0?ooo`3oool204E5A@80:RXZ0`0c<c<202d];@808R8R0P0c<c<2028R8P80:2PX1@0K6a/2
028R8P8092@T0P0K6a/202XZ:P<0DE5A0P1CDe<204i>CP80ATI60P1@D50204i>CP<0D51@0P19BDT2
0492@P80BDU90P1GEeL205=CD`<0Jf][0P1dM7@206ATI080FUYJ0P1XJ6P2075aL@<0Jf][0P1SHf<2
07alO080I6AT0P1XJ6P206=SH`<0GEeM0P19BDT202PX:0808R8R0P0=3@d700<30`802`/;10030`<3
00L71`@03@d=0P0G5aL201/K6`80;Bd]0`0Z:RX202PX:080?clo0P1JFUX205QHF080@T920`0];Bd2
02PX:080:RXZ0P0X:2P202@T9080:2PX1@0Z:RX4028R8P806a/K0P0E5AD3014A4@P02`/;0P0=3@d3
028R8P80<C4a0P15ADD204I6AP80=SHf0P0a<C4303Hf=P80<C4a0P0f=SH203/k>`80@T920P19BDT3
05aLG080Jf][0P1QHF4205=CD`80FUYJ1@1ADE4204a<C080BDU91@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0o?cl2034a<@<0:RXZ100h>3P201/K6`805aLG0P0R8R8301/K6`804A4A0P0E5AD2
01LG5`808R8R0P0G5aL303Ph>080CTi>0P1CDe<204U9B@80@T920P11@D4303lo?`80D51@0P0o?cl2
04E5A@80D51@0P19BDT305YJFP@0CTi>0P1SHf<205QHF080IVIV0`1/K6`207MgM`80O7al0P1XJ6P2
079bLP80LG5a0`25QHD205aLG080EEEE0P0T92@201DE5@D00`<310071`L200/;2`803@d=0`0E5AD4
00/;2`806a/K0P0R8R8203<c<`<0?3`l0P0f=SH2034a<@80:RXZ0P0f=SH203Ph>0<0>c/k0P11@D42
03`l?0@0=SHf0P0T92@3028R8P806a/K0P0R8R8201LG5`806a/K0P0T92@301DE5@@02`/;10071`L5
00<30`802`/;0P0A4A4202XZ:P80<c<c0P0Z:RX302d];@80<c<c0P0T92@203<c<`80>3Ph0P11@D43
055AD@80ATI60P0l?3`203Ph>080=SHf0P0l?3`5051@D080?clo1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0o?cl2034a<@<0:RXZ100h>3P201/K6`805aLG0P0R8R8301/K6`804A4A0P0E5AD2
01LG5`808R8R0P0G5aL303Ph>080CTi>0P1CDe<204U9B@80@T920P11@D4303lo?`80D51@0P0o?cl2
04E5A@80D51@0P19BDT305YJFP@0CTi>0P1SHf<205QHF080IVIV0`1/K6`207MgM`80O7al0P1XJ6P2
079bLP80LG5a0`25QHD205aLG080EEEE0P0T92@201DE5@D00`<310071`L200/;2`803@d=0`0E5AD4
00/;2`806a/K0P0R8R8203<c<`<0?3`l0P0f=SH2034a<@80:RXZ0P0f=SH203Ph>0<0>c/k0P11@D42
03`l?0@0=SHf0P0T92@3028R8P806a/K0P0R8R8201LG5`806a/K0P0T92@301DE5@@02`/;10071`L5
00<30`802`/;0P0A4A4202XZ:P80<c<c0P0Z:RX302d];@80<c<c0P0T92@203<c<`80>3Ph0P11@D43
055AD@80ATI60P0l?3`203Ph>080=SHf0P0l?3`5051@D080?clo1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0o?cl2034a<@<0:RXZ100h>3P201/K6`805aLG0P0R8R8301/K6`804A4A0P0E5AD2
01LG5`808R8R0P0G5aL303Ph>080CTi>0P1CDe<204U9B@80@T920P11@D4303lo?`80D51@0P0o?cl2
04E5A@80D51@0P19BDT305YJFP@0CTi>0P1SHf<205QHF080IVIV0`1/K6`207MgM`80O7al0P1XJ6P2
079bLP80LG5a0`25QHD205aLG080EEEE0P0T92@201DE5@D00`<310071`L200/;2`803@d=0`0E5AD4
00/;2`806a/K0P0R8R8203<c<`<0?3`l0P0f=SH2034a<@80:RXZ0P0f=SH203Ph>0<0>c/k0P11@D42
03`l?0@0=SHf0P0T92@3028R8P806a/K0P0R8R8201LG5`806a/K0P0T92@301DE5@@02`/;10071`L5
00<30`802`/;0P0A4A4202XZ:P80<c<c0P0Z:RX302d];@80<c<c0P0T92@203<c<`80>3Ph0P11@D43
055AD@80ATI60P0l?3`203Ph>080=SHf0P0l?3`5051@D080?clo1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0Z:RX202d];@<0>3Ph0P0f=SH203`l?080;Bd]0P0E5AD201LG5`<04A4A0P0T92@2
01DE5@803@d=0P0K6a/202@T90<08R8R0P0h>3P204U9B@@0?3`l0P0k>c/503lo?`80>3Ph0P19BDT2
04a<C080De=C0`0o?cl204U9B@80DE5A0P1CDe<205iNGPD0HV9R0P1SHf<205YJFP80LG5a0P1gMgL5
0861P@80K6a/0P1MGEd203`l?0806a/K1@071`L600d=3@801`L71@0;2`/402@T9080ATI60P1ADE43
07EeM@80KFe]0P1`L70207UiN@80CTi>0P0o?cl304U9B@80GUiN0P26QXH207MgM`80PH610P1`L703
055AD@80@D510P0c<c<2028R8P@05ADE0`0A4A4400/;2`@00`<30P071`L700<30`801`L70P0A4A42
01/K6`<092@T0P0R8R8202XZ:P806a/K0P0T92@5034a<@80=SHf0P0a<C4203Ph>080<c<c0P0h>3P3
0492@P80:RXZ0P0];Bd50?ooo`7o000000001?l00000oooo0?ooo`3oool202XZ:P80;Bd]0`0h>3P2
03Hf=P80?3`l0P0];Bd201DE5@805aLG0`0A4A4202@T90805ADE0P0=3@d201/K6`8092@T0`0R8R82
03Ph>080BDU9100l?3`203/k>`D0?clo0P0h>3P204U9B@80C4a<0P1CDe<303lo?`80BDU90P1ADE42
05=CD`80GUiN1@1RHV8206=SH`80FUYJ0P1aLG4207MgM`D0PH610P1/K6`205eMG@80?3`l0P0K6a/5
00L71`H03@d=0P071`L500/;2`@092@T0P16ATH2055AD@<0MGEe0P1]KFd2071`L080NGUi0P1>CTh2
03lo?`<0BDU90P1NGUh208J6QP80MgMg0P21PH42071`L0<0DE5A0P11@D4203<c<`808R8R100E5AD3
014A4@@02`/;10030`<200L71`L00`<30P071`L2014A4@806a/K0`0T92@2028R8P80:RXZ0P0K6a/2
02@T90D0<C4a0P0f=SH2034a<@80>3Ph0P0c<c<203Ph>0<0@T920P0Z:RX202d];@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80>c/k0P11@D4303Hf=P80>3Ph0P0o?cl203/k>`80>3Ph0P0R8R83
01/K6`805ADE0P0A4A4201LG5`@06a/K0`0X:2P202@T9080ATI60P1@D50203Hf=P80@T920`0f=SH2
03Ph>080>c/k101@D502055AD@<0?3`l0P19BDT205EEE@80ATI60P1@D50204U9B@<0De=C0P1LG5`2
06=SH`80FUYJ0P1`L70206a/K0<0Hf=S0P1/K6`207EeM@80EeMG0P0Z:RX2014A4@<00`<30P0;2`/2
00L71`800`<30P0;2`/300L71`804A4A0P0E5AD202d];@80De=C0P1TI6@30861P@80Shn?0P2:RXX2
0861P@80MWIf0P1@D50504E5A@80GEeM0P1iNGT2096AT@D0SHf=0P1gMgL206IVIP80EEEE0P0f=SH2
028R8P<05ADE0P0=3@d2014A4@802`/;0P071`L200<30`<01`L720030`<200L71`<02`/;0P0G5aL2
02XZ:P80:2PX0P0R8R82034a<@<08R8R0P0];Bd2034a<@80<c<c0P0k>c/203<c<`<0;Bd]0P0X:2P2
02d];@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80>c/k0P11@D4303Hf=P80>3Ph0P0o?cl2
03/k>`80>3Ph0P0R8R8301/K6`805ADE0P0A4A4201LG5`@06a/K0`0X:2P202@T9080ATI60P1@D502
03Hf=P80@T920`0f=SH203Ph>080>c/k101@D502055AD@<0?3`l0P19BDT205EEE@80ATI60P1@D502
04U9B@<0De=C0P1LG5`206=SH`80FUYJ0P1`L70206a/K0<0Hf=S0P1/K6`207EeM@80EeMG0P0Z:RX2
014A4@<00`<30P0;2`/200L71`800`<30P0;2`/300L71`804A4A0P0E5AD202d];@80De=C0P1TI6@3
0861P@80Shn?0P2:RXX20861P@80MWIf0P1@D50504E5A@80GEeM0P1iNGT2096AT@D0SHf=0P1gMgL2
06IVIP80EEEE0P0f=SH2028R8P<05ADE0P0=3@d2014A4@802`/;0P071`L200<30`<01`L720030`<2
00L71`<02`/;0P0G5aL202XZ:P80:2PX0P0R8R82034a<@<08R8R0P0];Bd2034a<@80<c<c0P0k>c/2
03<c<`<0;Bd]0P0X:2P202d];@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80>c/k0P19BDT3
04I6AP@0?3`l0P0f=SH2034a<@80;Bd]1@0G5aL2028R8P805ADE0P0T92@201DE5@<08R8R0P0K6a/2
01LG5`80?3`l0P11@D4203`l?0D0<c<c0P0f=SH204I6AP80G5aL0P1<C4`305MGE`80BDU90P16ATH2
05=CD`80C4a<0P1CDe<3055AD@80Hf=S0P1eMGD209^KV`80YjNW0P1lO7`307MgM`80QHF50P1TI6@2
03lo?`80:2PX0P0A4A4300/;2`801`L70P0;2`/201DE5@803@d=0`0K6a/202XZ:P80=SHf0P19BDT2
07alO080SHf=0`2ATI420;Jf]P80/K6a0P2k^k/20;Rh^080OWin0`1<C4`201LG5`80BDU90P20P802
0::RXP80WYjN0`2GUiL20:ZZZP80YZJV0P2FUYH207moO`80EEEE0`19BDT20451@@8092@T0P0G5aL2
00d=3@L01`L70P030`<2000000@00`<31@071`L201DE5@804A4A0P0];Bd2034a<@<092@T0P0R8R82
02@T90@0:2PX0P0a<C4303lo?`80C4a<0P19BDT50?ooo`7o000000001?l00000oooo0?ooo`3oool2
03/k>`80BDU90`16ATH403`l?080=SHf0P0a<C4202d];@D05aLG0P0R8R8201DE5@8092@T0P0E5AD3
028R8P806a/K0P0G5aL203`l?080@D510P0l?3`503<c<`80=SHf0P16ATH205aLG080C4a<0`1GEeL2
04U9B@80ATI60P1CDe<204a<C080De=C0`1ADE4206=SH`80MGEe0P2KVi/20:NWY`80O7al0`1gMgL2
08F5Q@80I6AT0P0o?cl202PX:0804A4A0`0;2`/200L71`802`/;0P0E5AD200d=3@<06a/K0P0Z:RX2
03Hf=P80BDU90P1lO7`208f=S@<0TI6A0P2f][H20;6a/@80^k^k0P2h^;P207inOP<0C4a<0P0G5aL2
04U9B@80P8200P2RXZ8209jNWP<0UiNG0P2ZZZX20:JVYP80UYJF0P1oOgl205EEE@<0BDU90P11@D42
02@T90805aLG0P0=3@d700L71`800`<30P00000400<30`D01`L70P0E5AD2014A4@80;Bd]0P0a<C43
02@T90808R8R0P0T92@402PX:080<C4a0`0o?cl204a<C080BDU91@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0X:2P201LG5`<0:RXZ1P0c<c<403Hf=P<0>c/k0P0R8R8201DE5@805aLG100E5AD5
01LG5`808R8R0P0X:2P203Hf=P80>c/k0`0h>3P402d];@80>c/k0P1@D50204I6AP<0?clo0P16ATH2
03`l?080BDU90P1JFUX205MGE`D0F5QH0P1LG5`206][J`80LW9b0P20P80309NGU`80O7al0P24Q8@2
06=SH`80=SHf0P0G5aL300/;2`801`L70P0=3@d200L71`804A4A0`0X:2P203/k>`80DE5A0P1bLW82
09NGU`80YZJV0`2j^[X20;>c/`80d];B0P3MgMd20?[jnP80h>3P0`1lO7`2028R8P@03@d=0P1>CTh2
0:b/[0<0alO70P3<c<`20=7Ad@80^[Zj0P2MWId209^KV`<0QHF50P1XJ6P204I6AP80=SHf0P0X:2P2
028R8P<05ADE0P0;2`/200L71`H00`<30`071`L400<30`802`/;100R8R8502d];@805ADE100K6a/2
01LG5`D06a/K0P0T92@50?ooo`7o000000001?l00000oooo0?ooo`3oool202PX:0805aLG0`0Z:RX6
03<c<`@0=SHf0`0k>c/2028R8P805ADE0P0G5aL401DE5@D05aLG0P0R8R8202PX:080=SHf0P0k>c/3
03Ph>0@0;Bd]0P0k>c/2051@D080ATI60`0o?cl204I6AP80?3`l0P19BDT205YJFP80EeMG1@1HF5P2
05aLG080Jf][0P1bLW820820P0<0UiNG0P1lO7`208B4Q080Hf=S0P0f=SH201LG5`<02`/;0P071`L2
00d=3@801`L70P0A4A4302PX:080>c/k0P1ADE42079bLP80UiNG0P2VYZH30;Zj^P80/k>c0P3Bd]82
0=gMg@80n_[j0P3Ph>0307alO0808R8R100=3@d204i>CP80[:b/0`37alL20<c<c080dM7A0P2j^[X2
09fMW@80Vi^K0`25QHD206QXJ080ATI60P0f=SH202PX:0808R8R0`0E5AD200/;2`801`L71P030`<3
00L71`@00`<30P0;2`/4028R8PD0;Bd]0P0E5AD401/K6`805aLG1@0K6a/202@T90D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80:2PX0P0G5aL302XZ:PH0<c<c100f=SH303/k>`808R8R0P0E5AD2
01LG5`@05ADE1@0G5aL2028R8P80:2PX0P0f=SH203/k>`<0>3Ph100];Bd203/k>`80D51@0P16ATH3
03lo?`80ATI60P0l?3`204U9B@80FUYJ0P1GEeL505QHF080G5aL0P1[Jf/2079bLP80P8200`2GUiL2
07alO080Q8B40P1SHf<203Hf=P805aLG0`0;2`/200L71`803@d=0P071`L2014A4@<0:2PX0P0k>c/2
055AD@80LW9b0P2GUiL20:JVYP<0^[Zj0P2c/k<20=;BdP80gMgM0P3jn_X20>3Ph0<0O7al0P0R8R84
00d=3@80CTi>0P2/[:`30<O7a`80c<c<0P3AdM420;Zj^P80WIfM0P2KVi/308F5Q@80J6QX0P16ATH2
03Hf=P80:2PX0P0R8R8301DE5@802`/;0P071`L600<30`<01`L710030`<200/;2`@08R8R1@0];Bd2
01DE5@@06a/K0P0G5aL501/K6`8092@T1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0E5AD5
028R8P805aLG0P0K6a/2028R8P80;Bd]0P0Z:RX502@T9080:RXZ100G5aL2028R8P<05aLG0P0K6a/2
01DE5@8092@T0P0R8R8203/k>`<0C4a<0P11@D42034a<@80@D51101@D5030492@P80F5QH0P19BDT2
05=CD`80CTi>0P12@T83055AD@80G5aL0P1HF5P206e]K@80L71`0P1VIVH305EEE@80I6AT0P1NGUh2
055AD@80?clo0P0E5AD500/;2`801`L70P0;2`/200d=3@<092@T0P0l?3`205iNGP80K6a/0P2FUYH2
0;>c/`<0a<C40P3Hf=P20=KFeP80h^;R0P3Xj>P20=7Ad@<0IVIV0P0K6a/200/;2`@01`L70P0=3@d3
03/k>`80U9BD0P35aLD20=3@d080a<C40P2FUYH308^;R`80OWin0P1aLG4205aLG080D51@0P0o?cl3
02@T9080:2PX0P0A4A4400/;2`800`<30`00000200L71`800`<30P00000200<30`802`/;0`071`L2
00/;2`804A4A0P0R8R8201/K6`805ADE1@0=3@d201LG5`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`805ADE1@0R8R8201LG5`806a/K0P0R8R8202d];@80:RXZ1@0T92@202XZ:P@05aLG0P0R8R83
01LG5`806a/K0P0E5AD202@T90808R8R0P0k>c/304a<C080@D510P0a<C420451@@@0D51@0`12@T82
05QHF080BDU90P1CDe<204i>CP80@T920`1ADE4205aLG080F5QH0P1]KFd2071`L080IVIV0`1EEED2
06ATI080GUiN0P1ADE4203lo?`805ADE1@0;2`/200L71`802`/;0P0=3@d302@T9080?3`l0P1NGUh2
06a/K080UYJF0P2c/k<30<C4a080f=SH0P3Fe]H20>;RhP80j>SX0P3AdM4306IVIP806a/K0P0;2`/4
00L71`803@d=0`0k>c/209BDU080aLG50P3@d=020<C4a080UYJF0`2;Rh/207inOP80LG5a0P1LG5`2
051@D080?clo0`0T92@202PX:0804A4A100;2`/200<30`<000000P071`L200<30`8000000P030`<2
00/;2`<01`L70P0;2`/2014A4@808R8R0P0K6a/201DE5@D03@d=0P0G5aL50?ooo`7o000000001?l0
0000oooo0?ooo`3oool2028R8PD06a/K0P0R8R8201LG5`806a/K100];Bd302PX:0@0;Bd]0P0E5AD2
00d=3@D05ADE100K6a/2028R8P806a/K0P0R8R83051@D0@0>3Ph0P11@D420492@P80?clo0`19BDT2
03/k>`@0=SHf0P1>CTh20451@@<0D51@0P1HF5P2055AD@80De=C0P1GEeL2065QH@<0HV9R0P1TI6@2
065QH@80EeMG0P0c<c<201DE5@<03@d=0P030`<400L71`803@d=0`0R8R82051@D080LW9b0P25QHD2
08n?S`80/k>c0`2k^k/20<S8b080emOG0P3Hf=P20=gMg@80d=3@0`2;Rh/2028R8P803@d=0P030`<2
00L71`D02`/;0P0R8R8205QHF080W9bL0P33`l<20<S8b0<0[Zj^0P2BTY820820P080MWIf0P1bLW82
06ATI0<0ATI60P0f=SH2034a<@808R8R100A4A4300d=3@801`L71P030`<2000000<00`<30P071`L2
00d=3@805aLG0P0T92@201LG5`<05ADE0P0=3@d2014A4@D0oooo0Ol000000004o`00003oool0oooo
0?ooo`808R8R1@0K6a/2028R8P805aLG0P0K6a/402d];@<0:2PX100];Bd201DE5@803@d=1@0E5AD4
01/K6`808R8R0P0K6a/2028R8P<0D51@100h>3P20451@@80@T920P0o?cl304U9B@80>c/k100f=SH2
04i>CP80@D510`1@D50205QHF080DE5A0P1CDe<205MGE`80HF5Q0`1RHV8206ATI080HF5Q0P1GEeL2
03<c<`805ADE0`0=3@d200<30`@01`L70P0=3@d3028R8P80D51@0P1bLW8208F5Q@80Shn?0P2c/k<3
0;^k^`80b<S80P3GemL20=SHf080gMgM0P3@d=0308^;R`808R8R0P0=3@d200<30`801`L71@0;2`/2
028R8P80F5QH0P2LW9`20<?3``80b<S80`2^[Zh209:BTP80P8200P1fMWH2079bLP80I6AT0`16ATH2
03Hf=P80<C4a0P0R8R84014A4@<03@d=0P071`L600<30`8000000`030`<200L71`803@d=0P0G5aL2
02@T90805aLG0`0E5AD200d=3@804A4A1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0;2`/2
01LG5`<08R8R0P0X:2P2028R8P806a/K0P0Z:RX202PX:0<092@T0P0K6a/202@T90H06a/K0`0T92@2
014A4@805ADE0P0K6a/402@T90<08R8R0P0f=SH203Ph>080=SHf0P0l?3`20451@@<0@T920P1>CTh2
05MGE`@0C4a<2@11@D4205YJFP80KFe]0P1LG5`306IVIP80MGEe0P1SHf<2034a<@806a/K0P0=3@d3
00L71`800`<30P0;2`/200L71`808R8R0`0Z:RX203Ph>080EEEE0P1eMGD209JFUP80[:b/0`2XZ:P2
0:>SX`80bl_;0P3@d=020=SHf080a<C40`1lO7`20492@P802`/;0P0=3@d700/;2`801`L70P0A4A42
0451@@80MGEe0P2GUiL30;Rh^0@0[:b/0P2c/k<208F5Q@80NWYj0`1lO7`206ATI080EeMG0P0o?cl4
03<c<`<05ADE0P0;2`/400<30`@01`L71@00000800<30`L01`L71@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0;2`/201LG5`<08R8R0P0X:2P2028R8P806a/K0P0Z:RX202PX:0<092@T0P0K6a/2
02@T90H06a/K0`0T92@2014A4@805ADE0P0K6a/402@T90<08R8R0P0f=SH203Ph>080=SHf0P0l?3`2
0451@@<0@T920P1>CTh205MGE`@0C4a<2@11@D4205YJFP80KFe]0P1LG5`306IVIP80MGEe0P1SHf<2
034a<@806a/K0P0=3@d300L71`800`<30P0;2`/200L71`808R8R0`0Z:RX203Ph>080EEEE0P1eMGD2
09JFUP80[:b/0`2XZ:P20:>SX`80bl_;0P3@d=020=SHf080a<C40`1lO7`20492@P802`/;0P0=3@d7
00/;2`801`L70P0A4A420451@@80MGEe0P2GUiL30;Rh^0@0[:b/0P2c/k<208F5Q@80NWYj0`1lO7`2
06ATI080EeMG0P0o?cl403<c<`<05ADE0P0;2`/400<30`@01`L71@00000800<30`L01`L71@3oool1
o`00000000Co00000?ooo`3oool0oooo0P0;2`/201LG5`<08R8R0P0X:2P2028R8P806a/K0P0Z:RX2
02PX:0<092@T0P0K6a/202@T90H06a/K0`0T92@2014A4@805ADE0P0K6a/402@T90<08R8R0P0f=SH2
03Ph>080=SHf0P0l?3`20451@@<0@T920P1>CTh205MGE`@0C4a<2@11@D4205YJFP80KFe]0P1LG5`3
06IVIP80MGEe0P1SHf<2034a<@806a/K0P0=3@d300L71`800`<30P0;2`/200L71`808R8R0`0Z:RX2
03Ph>080EEEE0P1eMGD209JFUP80[:b/0`2XZ:P20:>SX`80bl_;0P3@d=020=SHf080a<C40`1lO7`2
0492@P802`/;0P0=3@d700/;2`801`L70P0A4A420451@@80MGEe0P2GUiL30;Rh^0@0[:b/0P2c/k<2
08F5Q@80NWYj0`1lO7`206ATI080EeMG0P0o?cl403<c<`<05ADE0P0;2`/400<30`@01`L71@000008
00<30`L01`L71@3oool1o`00000000Co00000?ooo`3oool0oooo0P030`<200L71`<03@d=0P0A4A46
01/K6`80:RXZ0`0];Bd2034a<@806a/K0P0T92@2034a<@805aLG0`0R8R8601/K6`80:RXZ0P0E5AD3
014A4@80:2PX0P0o?cl203/k>`80<c<c0P1<C4`3055AD@80@T920P1ADE440451@@80?clo0`0k>c/2
04E5A@80EEEE0P1VIVH206=SH`80Jf][0`1SHf<205EEE@80@T920P0];Bd2028R8P803@d=0`071`L2
00/;2`@03@d=0P0E5AD302d];@80@T920P1NGUh206ATI080V9RH1@2VYZH209jNWP80];Bd0P3AdM42
0=oOg`80_Kfm0`1oOgl202@T90@04A4A0P0=3@d202PX:0D04A4A0P0=3@d200/;2`801`L70P0h>3P3
06QXJ080Q8B40P2GUiL20<g=c@80]KFe0P2QXJ4308n?S`80R8R80P1RHV8206IVIP80HV9R0P1GEeL3
03`l?08092@T0P0E5AD201LG5`805ADE0P0=3@d500L71`805ADE0P0;2`/2014A4@802`/;1`030`<5
0?ooo`7o000000001?l00000oooo0?ooo`3oool200<30`801`L70`0=3@d2014A4@H06a/K0P0Z:RX3
02d];@80<C4a0P0K6a/202@T9080<C4a0P0G5aL3028R8PH06a/K0P0Z:RX201DE5@<04A4A0P0X:2P2
03lo?`80>c/k0P0c<c<204a<C0<0DE5A0P12@T82055AD@@0@D510P0o?cl303/k>`80ADE50P1EEED2
06IVIP80Hf=S0P1[Jf/306=SH`80EEEE0P12@T8202d];@808R8R0P0=3@d300L71`802`/;100=3@d2
01DE5@<0;Bd]0P12@T8205iNGP80I6AT0P2HV9P50:JVYP80WYjN0P2d];@20=7Ad@80gmoO0P2m_Kd3
07moO`8092@T100A4A4200d=3@80:2PX1@0A4A4200d=3@802`/;0P071`L203Ph>0<0J6QX0P24Q8@2
09NGU`80cLg=0P2e]KD20:6QX@<0Shn?0P28R8P2069RHP80IVIV0P1RHV8205MGE`<0?3`l0P0T92@2
01DE5@805aLG0P0E5AD200d=3@D01`L70P0E5AD200/;2`804A4A0P0;2`/700<30`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`@00`<30`00000200<30`801`L7100;2`/701DE5@805aLG100E5AD2
01/K6`D05aLG0P0E5AD4014A4@805aLG0`0E5AD201LG5`80:2PX1P0h>3P303`l?080?clo0P12@T82
0451@@80ADE50P11@D430492@P80ATI60P15ADD204i>CP80De=C0P1@D503065QH@80C4a<0P0f=SH2
02@T90805ADE0P0];Bd303<c<`808R8R0P0G5aL202PX:0805ADE0`0K6a/203lo?`80Hf=S0P1/K6`2
065QH@80SHf=0`2RXZ820<c<c080f=SH0P3Bd]820=cLg080d=3@0`2PX:0203Hf=P@05aLG0P0R8R82
01LG5`D08R8R100G5aL4014A4@<03@d=0P0Z:RX2079bLP80Ti>C0P2k^k/20<C4a0<0c/k>0P2j^[X2
0;>c/`80Vi^K0P1gMgL205iNGP<0EeMG0P1HF5P203lo?`80:RXZ0P0K6a/200/;2`D01`L70P0;2`/2
01/K6`@05aLG0`0K6a/200L71`800`<31@3oool1o`00000000Co00000?ooo`3oool0oooo10030`<3
000000800`<30P071`L400/;2`L05ADE0P0G5aL401DE5@806a/K1@0G5aL201DE5@@04A4A0P0G5aL3
01DE5@805aLG0P0X:2P603Ph>0<0?3`l0P0o?cl20492@P80@D510P15ADD20451@@<0@T920P16ATH2
04E5A@80CTi>0P1CDe<2051@D0<0HF5Q0P1<C4`203Hf=P8092@T0P0E5AD202d];@<0<c<c0P0R8R82
01LG5`80:2PX0P0E5AD301/K6`80?clo0P1SHf<206a/K080HF5Q0P2=SHd30::RXP80c<c<0P3Hf=P2
0=;BdP80g=cL0P3@d=030:2PX080=SHf100G5aL2028R8P805aLG1@0R8R8401LG5`@04A4A0`0=3@d2
02XZ:P80LW9b0P2CTi<20;^k^`80a<C40`3>c/h20;Zj^P80/k>c0P2KVi/207MgM`80GUiN0`1GEeL2
05QHF080?clo0P0Z:RX201/K6`802`/;1@071`L200/;2`806a/K100G5aL301/K6`801`L70P030`<5
0?ooo`7o000000001?l00000oooo0?ooo`3oool2014A4@802`/;2@030`<400L71`<04A4A0P0E5AD4
028R8P806a/K0P0R8R8302@T90808R8R0P0G5aL201DE5@804A4A0P0E5AD3028R8P805ADE0P0R8R82
02PX:0@0>c/k0`0l?3`20451@@80ATI61015ADD205=CD`<0@D510P0k>c/204i>CP80?clo0P11@D42
03`l?0<0>c/k0P0];Bd202@T90806a/K0P0A4A4202d];@<0D51@0P1GEeL203`l?08092@T1@0R8R82
034a<@80CTi>0P1RHV8206e]K@80SXj>0`32`/820<30`080bLW90P3Hf=P20=gMg@80h^;R0`39bLT2
0861P@80:RXZ0P0K6a/201LG5`80=SHf0`19BDT405EEE@80?3`l0P0X:2P201/K6`<05aLG0P0A4A42
01/K6`80K6a/0P2ATI420:>SX`<0^[Zj0P3EeMD20=7Ad@80bl_;0P2k^k/20:^[Z`<0WIfM0P1CDe<2
055AD@80EeMG0P12@T8201LG5`<03@d=0P071`L400/;2`804A4A0P0X:2P3034a<@80<c<c0P0Z:RX5
0?ooo`7o000000001?l00000oooo0?ooo`3oool2014A4@802`/;2@030`<400L71`<04A4A0P0E5AD4
028R8P806a/K0P0R8R8302@T90808R8R0P0G5aL201DE5@804A4A0P0E5AD3028R8P805ADE0P0R8R82
02PX:0@0>c/k0`0l?3`20451@@80ATI61015ADD205=CD`<0@D510P0k>c/204i>CP80?clo0P11@D42
03`l?0<0>c/k0P0];Bd202@T90806a/K0P0A4A4202d];@<0D51@0P1GEeL203`l?08092@T1@0R8R82
034a<@80CTi>0P1RHV8206e]K@80SXj>0`32`/820<30`080bLW90P3Hf=P20=gMg@80h^;R0`39bLT2
0861P@80:RXZ0P0K6a/201LG5`80=SHf0`19BDT405EEE@80?3`l0P0X:2P201/K6`<05aLG0P0A4A42
01/K6`80K6a/0P2ATI420:>SX`<0^[Zj0P3EeMD20=7Ad@80bl_;0P2k^k/20:^[Z`<0WIfM0P1CDe<2
055AD@80EeMG0P12@T8201LG5`<03@d=0P071`L400/;2`804A4A0P0X:2P3034a<@80<c<c0P0Z:RX5
0?ooo`7o000000001?l00000oooo0?ooo`3oool2014A4@802`/;2@030`<400L71`<04A4A0P0E5AD4
028R8P806a/K0P0R8R8302@T90808R8R0P0G5aL201DE5@804A4A0P0E5AD3028R8P805ADE0P0R8R82
02PX:0@0>c/k0`0l?3`20451@@80ATI61015ADD205=CD`<0@D510P0k>c/204i>CP80?clo0P11@D42
03`l?0<0>c/k0P0];Bd202@T90806a/K0P0A4A4202d];@<0D51@0P1GEeL203`l?08092@T1@0R8R82
034a<@80CTi>0P1RHV8206e]K@80SXj>0`32`/820<30`080bLW90P3Hf=P20=gMg@80h^;R0`39bLT2
0861P@80:RXZ0P0K6a/201LG5`80=SHf0`19BDT405EEE@80?3`l0P0X:2P201/K6`<05aLG0P0A4A42
01/K6`80K6a/0P2ATI420:>SX`<0^[Zj0P3EeMD20=7Ad@80bl_;0P2k^k/20:^[Z`<0WIfM0P1CDe<2
055AD@80EeMG0P12@T8201LG5`<03@d=0P071`L400/;2`804A4A0P0X:2P3034a<@80<c<c0P0Z:RX5
0?ooo`7o000000001?l00000oooo0?ooo`3oool20451@@80EeMG0`0k>c/201DE5@801`L70P030`<2
000000D00`<30P071`L2014A4@805aLG0P0K6a/203Ph>0<0=SHf0P0];Bd201DE5@H05aLG0`0E5AD2
01/K6`805ADE0P0A4A4201LG5`80<C4a0`0c<c<203Hf=P80BDU90P12@T8203`l?0D0?clo0P11@D42
03Ph>080?3`l0P15ADD203`l?0<0<C4a0P0T92@201LG5`802`/;0P0=3@d2014A4@<0>c/k0P1bLW82
05MGE`80<c<c0P0A4A4301DE5@806a/K0P1HF5P206=SH`80HF5Q0P1lO7`3096AT@80`l?31035aLD2
0=[JfP80i>CT0`3EeMD20;Vi^@80YZJV0P1EEED2034a<@80>3Ph0`1]KFd408J6QP80TI6A0P26QXH2
06QXJ0<0CTi>0P0f=SH202d];@80De=C0P28R8P208f=S@<0YJFU0P2XZ:P20=GEe@80d];B0P32`/82
09>CT`<0XZ:R0P2:RXX2075aL@80D51@0P0c<c<203/k>`<0>3Ph0P0R8R82014A4@@02`/;0P0G5aL3
02XZ:P80>3Ph0P0o?cl50?ooo`7o000000001?l00000oooo0?ooo`3oool20451@@80EeMG0`0k>c/2
01DE5@801`L70P030`<2000000D00`<30P071`L2014A4@805aLG0P0K6a/203Ph>0<0=SHf0P0];Bd2
01DE5@H05aLG0`0E5AD201/K6`805ADE0P0A4A4201LG5`80<C4a0`0c<c<203Hf=P80BDU90P12@T82
03`l?0D0?clo0P11@D4203Ph>080?3`l0P15ADD203`l?0<0<C4a0P0T92@201LG5`802`/;0P0=3@d2
014A4@<0>c/k0P1bLW8205MGE`80<c<c0P0A4A4301DE5@806a/K0P1HF5P206=SH`80HF5Q0P1lO7`3
096AT@80`l?31035aLD20=[JfP80i>CT0`3EeMD20;Vi^@80YZJV0P1EEED2034a<@80>3Ph0`1]KFd4
08J6QP80TI6A0P26QXH206QXJ0<0CTi>0P0f=SH202d];@80De=C0P28R8P208f=S@<0YJFU0P2XZ:P2
0=GEe@80d];B0P32`/8209>CT`<0XZ:R0P2:RXX2075aL@80D51@0P0c<c<203/k>`<0>3Ph0P0R8R82
014A4@@02`/;0P0G5aL302XZ:P80>3Ph0P0o?cl50?ooo`7o000000001?l00000oooo0?ooo`3oool2
0492@P80EEEE0`16ATH204U9B@80ADE50P0R8R8200d=3@801`L71`030`<200L71`802`/;0P0A4A43
028R8P806a/K100E5AD2014A4@805aLG0`0R8R82014A4@806a/K0P0G5aL2014A4@806a/K0`0X:2P2
034a<@80:RXZ0P11@D4203/k>`D0ADE50P0l?3`203/k>`80>3Ph0P0];Bd203<c<`<092@T0P0R8R84
014A4@80:2PX0P1JFUX306QXJ080HF5Q0P16ATH203Ph>0808R8R0`0G5aL203Ph>080D51@0P1NGUh2
06e]K@80QHF50`1gMgL2075aL@80W9bL0P3Bd]840=KFeP<0hN7Q0P3EeMD20;Vi^@80d];B0P1fMWH2
07MgM`<0Q8B40P2/[:`209fMW@80Zj^[0P2VYZH20:RXZ0<0Zj^[0P1lO7`205YJFP80EEEE0P1SHf<2
0<O7a`<0YZJV0P2LW9`20;Bd]080d=3@0P32`/820:ZZZP<0WYjN0P21PH4206ATI080GUiN0P1/K6`2
05=CD`<0>3Ph0P0k>c/204I6AP80:2PX0P0E5AD200/;2`<03@d=0P0K6a/2034a<@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80@T920P1EEED304I6AP80BDU90P15ADD2028R8P803@d=0P071`L7
00<30`801`L70P0;2`/2014A4@<08R8R0P0K6a/401DE5@804A4A0P0G5aL3028R8P804A4A0P0K6a/2
01LG5`804A4A0P0K6a/302PX:080<C4a0P0Z:RX20451@@80>c/k1@15ADD203`l?080>c/k0P0h>3P2
02d];@80<c<c0`0T92@2028R8P@04A4A0P0X:2P205YJFP<0J6QX0P1QHF4204I6AP80>3Ph0P0R8R83
01LG5`80>3Ph0P1@D50205iNGP80KFe]0P25QHD307MgM`80LG5a0P2LW9`20=;BdP@0e]KF0`3QhN42
0=GEe@80^KVi0P3Bd]8207IfMP80MgMg0`24Q8@20:b/[080WIfM0P2[Zj/20:JVYP80Z:RX0`2[Zj/2
07alO080FUYJ0P1EEED206=SH`80alO70`2VYZH209bLW080];Bd0P3@d=020<;2`P80ZZZZ0`2NWYh2
0861P@80I6AT0P1NGUh206a/K080De=C0`0h>3P203/k>`80ATI60P0X:2P201DE5@802`/;0`0=3@d2
01/K6`80<C4a1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0];Bd2034a<@<0@D510P1>CTh2
04a<C080CTi>0P15ADD2034a<@<04A4A10071`L200/;2`801`L70P0;2`/3014A4@806a/K0P0G5aL2
01/K6`804A4A0P0E5AD301LG5`803@d=0P0G5aL4028R8PD05aLG0P0f=SH40492@P80=SHf0P0c<c<3
03lo?`80ADE50P12@T8203Ph>080<C4a0P0R8R8301LG5`804A4A100=3@d203<c<`80@D510`1iNGT2
05iNGP80@D510P0f=SH502XZ:P80;Bd]0P1ADE4205QHF080HF5Q0P1VIVH3079bLP80L71`0P2PX:02
0=_Kf`80h>3P0P34a<@30=3@d0@0h>3P0P3Bd]820;Zj^P80TY:B0`26QXH20:NWY`80[Zj^0P2UYJD2
0;Vi^@80[Zj^0`2XZ:P20;Zj^P80V9RH0P2:RXX2075aL@80Jf][0`2^[Zh20;jn_P80bLW90P2e]KD2
0<S8b080^;Rh0`2^[Zh20<S8b080_[jn0P2ATI4206IVIP80K6a/0`1XJ6P205MGE`80@T920P1@D502
0451@@806a/K0`0A4A4200d=3@806a/K1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0];Bd2
034a<@<0@D510P1>CTh204a<C080CTi>0P15ADD2034a<@<04A4A10071`L200/;2`801`L70P0;2`/3
014A4@806a/K0P0G5aL201/K6`804A4A0P0E5AD301LG5`803@d=0P0G5aL4028R8PD05aLG0P0f=SH4
0492@P80=SHf0P0c<c<303lo?`80ADE50P12@T8203Ph>080<C4a0P0R8R8301LG5`804A4A100=3@d2
03<c<`80@D510`1iNGT205iNGP80@D510P0f=SH502XZ:P80;Bd]0P1ADE4205QHF080HF5Q0P1VIVH3
079bLP80L71`0P2PX:020=_Kf`80h>3P0P34a<@30=3@d0@0h>3P0P3Bd]820;Zj^P80TY:B0`26QXH2
0:NWY`80[Zj^0P2UYJD20;Vi^@80[Zj^0`2XZ:P20;Zj^P80V9RH0P2:RXX2075aL@80Jf][0`2^[Zh2
0;jn_P80bLW90P2e]KD20<S8b080^;Rh0`2^[Zh20<S8b080_[jn0P2ATI4206IVIP80K6a/0`1XJ6P2
05MGE`80@T920P1@D5020451@@806a/K0`0A4A4200d=3@806a/K1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0];Bd2034a<@<0@D510P1>CTh204a<C080CTi>0P15ADD2034a<@<04A4A10071`L2
00/;2`801`L70P0;2`/3014A4@806a/K0P0G5aL201/K6`804A4A0P0E5AD301LG5`803@d=0P0G5aL4
028R8PD05aLG0P0f=SH40492@P80=SHf0P0c<c<303lo?`80ADE50P12@T8203Ph>080<C4a0P0R8R83
01LG5`804A4A100=3@d203<c<`80@D510`1iNGT205iNGP80@D510P0f=SH502XZ:P80;Bd]0P1ADE42
05QHF080HF5Q0P1VIVH3079bLP80L71`0P2PX:020=_Kf`80h>3P0P34a<@30=3@d0@0h>3P0P3Bd]82
0;Zj^P80TY:B0`26QXH20:NWY`80[Zj^0P2UYJD20;Vi^@80[Zj^0`2XZ:P20;Zj^P80V9RH0P2:RXX2
075aL@80Jf][0`2^[Zh20;jn_P80bLW90P2e]KD20<S8b080^;Rh0`2^[Zh20<S8b080_[jn0P2ATI42
06IVIP80K6a/0`1XJ6P205MGE`80@T920P1@D5020451@@806a/K0`0A4A4200d=3@806a/K1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P0G5aL2034a<@<0ADE50P0h>3P204a<C080K6a/0P1XJ6P2
05YJFP<0CTi>0P0];Bd201DE5@801`L710030`<300L71`804A4A100K6a/202PX:0805aLG1@0K6a/2
00d=3@805ADE0P0K6a/2028R8P<05ADE0P0R8R82034a<@80>c/k1`12@T8204I6AP80>3Ph0P0k>c/2
03<c<`808R8R0`0E5AD600d=3@808R8R0P1CDe<305MGE`80F5QH0P12@T8203Ph>080:RXZ0`0G5aL2
02@T9080?3`l0P15ADD20492@P80EeMG1@1EEED208R8R080YJFU0P3Fe]H20=OGe`<0^;Rh0P3EeMD2
0>_[j`80i>CT0P3Kfm/20:^[Z`<0UYJF0P2LW9`20:6QX@80ZZZZ102c/k<30;Bd]080/k>c0P2f][H2
0::RXP80SXj>0P1dM7@306QXJ080Ogmo0P39bLT20>;RhP80e]KF0P3=cLd30;Zj^P80WYjN0P2h^;P2
0;Zj^P80Zj^[0P20P80305QHF080DE5A0P1GEeL205YJFP80>3Ph0P0];Bd301/K6`@03@d=1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P0G5aL2034a<@<0ADE50P0h>3P204a<C080K6a/0P1XJ6P2
05YJFP<0CTi>0P0];Bd201DE5@801`L710030`<300L71`804A4A100K6a/202PX:0805aLG1@0K6a/2
00d=3@805ADE0P0K6a/2028R8P<05ADE0P0R8R82034a<@80>c/k1`12@T8204I6AP80>3Ph0P0k>c/2
03<c<`808R8R0`0E5AD600d=3@808R8R0P1CDe<305MGE`80F5QH0P12@T8203Ph>080:RXZ0`0G5aL2
02@T9080?3`l0P15ADD20492@P80EeMG1@1EEED208R8R080YJFU0P3Fe]H20=OGe`<0^;Rh0P3EeMD2
0>_[j`80i>CT0P3Kfm/20:^[Z`<0UYJF0P2LW9`20:6QX@80ZZZZ102c/k<30;Bd]080/k>c0P2f][H2
0::RXP80SXj>0P1dM7@306QXJ080Ogmo0P39bLT20>;RhP80e]KF0P3=cLd30;Zj^P80WYjN0P2h^;P2
0;Zj^P80Zj^[0P20P80305QHF080DE5A0P1GEeL205YJFP80>3Ph0P0];Bd301/K6`@03@d=1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P0;2`/201DE5@<08R8R0P0X:2P203Ph>080@D510P0k>c/2
04a<C0<0FUYJ0P1RHV8205iNGP80De=C0P0K6a/900L71`804A4A0P0E5AD2028R8P<05ADE0P0A4A42
01LG5`@04A4A1@0G5aL201DE5@806a/K0P0h>3P204E5A@80?clo0`0h>3P403`l?080>3Ph0P0a<C42
03Ph>0<08R8R0P0K6a/401LG5`80@D510P1gMgL306a/K080ATI60P0c<c<2034a<@80:2PX1@0K6a/2
02PX:080>3Ph0P1LG5`206a/K0<0MGEe0P1LG5`207inOP80Vi^K0P2VYZH20;>c/`<0W9bL0P2/[:`2
0=KFeP80l?3`0P3AdM420::RXP<0QXJ60P2?Shl209jNWP80^KVi0P34a<@20<;2`PD0];Bd0P2k^k/2
0;>c/`80YZJV0P2PX:0307moO`80K6a/0P1JFUX208V9R@80bl_;0P30`<030<C4a080/k>c0P2a/K42
0;Bd]080YjNW0P2HV9P309bLW080O7al0P1HF5P2075aL@80KFe]0P1EEED303<c<`80;Bd]0P0R8R85
0?ooo`7o000000001?l00000oooo0?ooo`3oool200/;2`805ADE0`0R8R8202PX:080>3Ph0P11@D42
03/k>`80C4a<0`1JFUX2069RHP80GUiN0P1CDe<201/K6`T01`L70P0A4A4201DE5@808R8R0`0E5AD2
014A4@805aLG100A4A4501LG5`805ADE0P0K6a/203Ph>080ADE50P0o?cl303Ph>0@0?3`l0P0h>3P2
034a<@80>3Ph0`0R8R8201/K6`@05aLG0P11@D4207MgM`<0K6a/0P16ATH203<c<`80<C4a0P0X:2P5
01/K6`80:2PX0P0h>3P205aLG080K6a/0`1eMGD205aLG080OWin0P2KVi/20:JVYP80/k>c0`2LW9`2
0:b/[080e]KF0P3`l?020=7Ad@80XZ:R0`26QXH208n?S`80WYjN0P2i^KT20<C4a080`/;21@2d];@2
0;^k^`80/k>c0P2VYZH20:2PX0<0Ogmo0P1/K6`205YJFP80RHV90P3;bl/20<30`0<0a<C40P2c/k<2
0;6a/@80];Bd0P2WYjL209RHV0<0W9bL0P1lO7`205QHF080LG5a0P1]KFd205EEE@<0<c<c0P0];Bd2
028R8PD0oooo0Ol000000004o`00003oool0oooo0?ooo`80<C4a0P0K6a/301LG5`805ADE0P0R8R82
02d];@80?3`l0P0o?cl303Hf=P80C4a<0P1NGUh207AdM080KFe]0P1@D50302XZ:P805aLG0P071`L4
00/;2`803@d=0`0E5AD201/K6`805aLG0P0E5AD201LG5`D08R8R0P0T92@201LG5`806a/K0P0a<C42
03<c<`<0>3Ph0P0l?3`403Ph>080=SHf0P0];Bd301/K6`805aLG0P0A4A4202@T9080ADE50P1HF5P3
05aLG080F5QH0P0o?cl203/k>`80:2PX1@0E5AD2028R8P80ATI60P1RHV8207IfMP<0Ogmo0P1]KFd2
075aL@80MWIf0P2GUiL20:RXZ0<0V9RH0P2[Zj/20;jn_P80dm?C0P3GemL20:JVYP<0R8R80P1SHf<2
0:>SX`80`<300P33`l<20<O7a`<0d];B0P3=cLd20>3Ph080a<C4102i^KT30;Fe]@80YZJV0P1[Jf/2
05QHF080HV9R0P26QXH309bLW080/k>c0P2XZ:P20::RXP80[:b/0P2ZZZX309bLW080QHF50P24Q8@2
07AdM080GUiN0P1SHf<307UiN@80GEeM0P12@T850?ooo`7o000000001?l00000oooo0?ooo`3oool2
034a<@806a/K0`0G5aL201DE5@808R8R0P0];Bd203`l?080?clo0`0f=SH204a<C080GUiN0P1dM7@2
06e]K@80D51@0`0Z:RX201LG5`801`L7100;2`/200d=3@<05ADE0P0K6a/201LG5`805ADE0P0G5aL5
028R8P8092@T0P0G5aL201/K6`80<C4a0P0c<c<303Ph>080?3`l100h>3P203Hf=P80;Bd]0`0K6a/2
01LG5`804A4A0P0T92@204E5A@80F5QH0`1LG5`205QHF080?clo0P0k>c/202PX:0D05ADE0P0R8R82
04I6AP80HV9R0P1fMWH307moO`80KFe]0P1aLG4207IfMP80UiNG0P2XZ:P309RHV080Zj^[0P2n_[h2
0=?Cd`80emOG0P2VYZH308R8R080Hf=S0P2SXj<20<30`080`l?30P37alL30=;BdP80cLg=0P3Ph>02
0<C4a0@0^KVi0`2e]KD20:JVYP80Jf][0P1HF5P2069RHP80QXJ60`2LW9`20;>c/`80Z:RX0P2RXZ82
0:b/[080ZZZZ0`2LW9`208F5Q@80Q8B40P1dM7@205iNGP80Hf=S0`1iNGT205eMG@80@T921@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1MGEd204a<C0<06a/K100=3@d201DE5@806a/K0P0a<C43
03`l?080ADE50P0h>3P202d];@80?3`l0P1LG5`305iNGP80DE5A0P0l?3`2014A4@@01`L70`0;2`/2
014A4@808R8R100G5aL701DE5@804A4A0P0E5AD201/K6`80=SHf0`0k>c/203<c<`@0@D510P0h>3P2
03<c<`<0:2PX0P0T92@201LG5`806a/K0P19BDT2071`L0<0Jf][0P15ADD203`l?080:RXZ0P0G5aL3
01DE5@803@d=0P0A4A42028R8P80;Bd]0P15ADD305eMG@80L71`0P1SHf<206e]K@80NGUi0P28R8P3
0:FUY@80]KFe0P2d];@20<?3``80alO70P2c/k<309NGU`80RHV90P1]KFd209fMW@80^k^k0P3EeMD3
0=SHf080iNGU0P3_knl20??cl`80jNWY0P39bLT30=;BdP80alO70P2XZ:P207EeM@80GEeM0P1`L703
07alO080TI6A0P2UYJD209fMW@80_kno0P2e]KD309fMW@80QHF50P1aLG42065QH@80D51@0P1CDe<3
0492@P80?clo0P1CDe<50?ooo`7o000000001?l00000oooo0?ooo`3oool205eMG@80C4a<0`0K6a/4
00d=3@805ADE0P0K6a/2034a<@<0?3`l0P15ADD203Ph>080;Bd]0P0l?3`205aLG0<0GUiN0P1ADE42
03`l?0804A4A10071`L300/;2`804A4A0P0R8R8401LG5`L05ADE0P0A4A4201DE5@806a/K0P0f=SH3
03/k>`80<c<c1011@D4203Ph>080<c<c0`0X:2P202@T90805aLG0P0K6a/204U9B@80L71`0`1[Jf/2
04E5A@80?3`l0P0Z:RX201LG5`<05ADE0P0=3@d2014A4@808R8R0P0];Bd204E5A@<0GEeM0P1`L702
06=SH`80KFe]0P1iNGT208R8R0<0YJFU0P2e]KD20;Bd]080`l?30P37alL20;>c/`<0UiNG0P29RHT2
06e]K@80WIfM0P2k^k/20=GEe@<0f=SH0P3UiND20>o_k`80lo?c0P3YjNT20<W9b@<0d];B0P37alL2
0:RXZ080MGEe0P1MGEd2071`L0<0O7al0P2ATI420:FUY@80WIfM0P2o_kl20;Fe]@<0WIfM0P25QHD2
075aL@80HF5Q0P1@D50205=CD`<0@T920P0o?cl205=CD`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80GEeM0P1<C4`301/K6`@03@d=0P0E5AD201/K6`80<C4a0`0l?3`204E5A@80>3Ph0P0];Bd2
03`l?080G5aL0`1NGUh2055AD@80?3`l0P0A4A4400L71`<02`/;0P0A4A42028R8P@05aLG1`0E5AD2
014A4@805ADE0P0K6a/203Hf=P<0>c/k0P0c<c<40451@@80>3Ph0P0c<c<302PX:08092@T0P0G5aL2
01/K6`80BDU90P1`L70306][J`80ADE50P0l?3`202XZ:P805aLG0`0E5AD200d=3@804A4A0P0R8R82
02d];@80ADE50`1MGEd2071`L080Hf=S0P1]KFd207UiN@80R8R80`2UYJD20;Fe]@80];Bd0P33`l<2
0<O7a`80/k>c0`2GUiL208V9R@80KFe]0P2MWId20;^k^`80eMGE0`3Hf=P20>GUi@80kno_0P3clo<2
0>WYj@80bLW90`3Bd]820<O7a`80Z:RX0P1eMGD205eMG@80L71`0`1lO7`2096AT@80YJFU0P2MWId2
0;no_`80]KFe0`2MWId208F5Q@80LG5a0P1QHF42051@D080De=C0`12@T8203lo?`80De=C1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P0h>3P202d];@<0:RXZ0P0R8R8200d=3@802`/;0P071`L2
00d=3@<092@T0P0a<C4203/k>`80?3`l100k>c/30492@P80BDU90P15ADD203`l?0804A4A0P071`L3
00<30`801`L70P0=3@d201LG5`806a/K0P0R8R8301LG5`805ADE100A4A4201DE5@8092@T0`0a<C42
0492@P80?3`l0P0h>3P202d];@80>3Ph0`0Z:RX201/K6`805aLG0P0R8R8204I6AP80Jf][0`1ADE42
03`l?080;Bd]0P0G5aL2014A4@<05ADE0P0=3@d400/;2`806a/K0P0];Bd3051@D080J6QX0P1eMGD2
08n?S`80O7al0P2>SXh30:6QX@80^;Rh0P2j^[X20;>c/`80_Kfm0P3=cLd30:j^[P80X:2P0P2;Rh/2
07UiN@80[Zj^0P3<c<`30>k^kP80l?3`0P3dm?@20>o_k`80m?Cd0P3_knl30>GUi@80kNg]0P3EeMD2
0<30`080RXZ:0P1VIVH3075aL@80P8200P28R8P209>CT`80SHf=0P2BTY830:b/[080YJFU0P2DU9@2
08B4Q0@0J6QX0`1]KFd205iNGP80EEEE1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0h>3P2
02d];@<0:RXZ0P0R8R8200d=3@802`/;0P071`L200d=3@<092@T0P0a<C4203/k>`80?3`l100k>c/3
0492@P80BDU90P15ADD203`l?0804A4A0P071`L300<30`801`L70P0=3@d201LG5`806a/K0P0R8R83
01LG5`805ADE100A4A4201DE5@8092@T0`0a<C420492@P80?3`l0P0h>3P202d];@80>3Ph0`0Z:RX2
01/K6`805aLG0P0R8R8204I6AP80Jf][0`1ADE4203`l?080;Bd]0P0G5aL2014A4@<05ADE0P0=3@d4
00/;2`806a/K0P0];Bd3051@D080J6QX0P1eMGD208n?S`80O7al0P2>SXh30:6QX@80^;Rh0P2j^[X2
0;>c/`80_Kfm0P3=cLd30:j^[P80X:2P0P2;Rh/207UiN@80[Zj^0P3<c<`30>k^kP80l?3`0P3dm?@2
0>o_k`80m?Cd0P3_knl30>GUi@80kNg]0P3EeMD20<30`080RXZ:0P1VIVH3075aL@80P8200P28R8P2
09>CT`80SHf=0P2BTY830:b/[080YJFU0P2DU9@208B4Q0@0J6QX0`1]KFd205iNGP80EEEE1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1QHF4204U9B@<0?3`l0P0c<c<2014A4@802`/;100=3@d3
00/;2`801`L70P0G5aL203Hf=P80?clo0P16ATH3051@D080?clo0P0a<C440492@P80<c<c0`0=3@d2
00L71`800`<30P071`L201DE5@D03@d=0P0;2`/2014A4@805aLG0P0E5AD200d=3@<08R8R0P0h>3P2
03`l?080=SHf0P0a<C4202d];@<0:RXZ100K6a/2034a<@80EEEE0P1SHf<304U9B@@0?3`l0P0Z:RX2
014A4@<02`/;100=3@d202XZ:P80@T920P1@D503069RHP80LG5a0P1dM7@208n?S`80W9bL0P2UYJD3
0:RXZ080Zj^[0P2m_Kd20;^k^`80[:b/0P34a<@30;Zj^P80Zj^[0P2DU9@207UiN@80L71`0P2i^KT3
0=oOg`80l_;b0P3clo<20>g]k@80o?cl0P3dm?@30??cl`@0mOGe0P3gmoL20>3Ph080Ti>C0`1[Jf/2
075aL@80L71`0P1iNGT209BDU080RXZ:0`2HV9P20:b/[080`<300P2j^[X20:JVYP80UYJF0`1oOgl2
06e]K@80MgMg1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1QHF4204U9B@<0?3`l0P0c<c<2
014A4@802`/;100=3@d300/;2`801`L70P0G5aL203Hf=P80?clo0P16ATH3051@D080?clo0P0a<C44
0492@P80<c<c0`0=3@d200L71`800`<30P071`L201DE5@D03@d=0P0;2`/2014A4@805aLG0P0E5AD2
00d=3@<08R8R0P0h>3P203`l?080=SHf0P0a<C4202d];@<0:RXZ100K6a/2034a<@80EEEE0P1SHf<3
04U9B@@0?3`l0P0Z:RX2014A4@<02`/;100=3@d202XZ:P80@T920P1@D503069RHP80LG5a0P1dM7@2
08n?S`80W9bL0P2UYJD30:RXZ080Zj^[0P2m_Kd20;^k^`80[:b/0P34a<@30;Zj^P80Zj^[0P2DU9@2
07UiN@80L71`0P2i^KT30=oOg`80l_;b0P3clo<20>g]k@80o?cl0P3dm?@30??cl`@0mOGe0P3gmoL2
0>3Ph080Ti>C0`1[Jf/2075aL@80L71`0P1iNGT209BDU080RXZ:0`2HV9P20:b/[080`<300P2j^[X2
0:JVYP80UYJF0`1oOgl206e]K@80MgMg1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1aLG42
06QXJ0<0EeMG0P1>CTh204E5A@80>c/k0P0];Bd2014A4@<02`/;10030`<200/;2`803@d=1@0f=SH2
04i>CP80IVIV0P1GEeL204I6AP80@T920`1>CTh202PX:0802`/;0P071`L200/;2`L03@d=100;2`/2
01/K6`808R8R0`0G5aL201DE5@80;Bd]0P0c<c<203lo?`80>3Ph1@0];Bd201/K6`808R8R0P0a<C42
0492@P<0D51@0P1LG5`203lo?`80;Bd]0P0E5AD700d=3@806a/K0P11@D4206=SH`<0MGEe0P20P802
096AT@80V9RH0P2QXJ420:j^[P<0];Bd0P2ZZZX20;Bd]080Xj>S0P2h^;P20;fm_@<0/k>c102KVi/2
096AT@80KFe]0P1SHf<30<W9b@80hN7Q0P3jn_X20?;blP80i^KV0P3hn?P30?ooo`80kNg]0P3emOD2
0?knoP80mOGe0P3Ti>@309^KV`80KFe]0P1EEED206][J`80RHV90P2LW9`308R8R080Xj>S0P2QXJ42
0:ZZZP80/k>c0P2VYZH30:6QX@80V9RH0P24Q8@50?ooo`7o000000001?l00000oooo0?ooo`3oool2
075aL@80J6QX0`1GEeL204i>CP80ADE50P0k>c/202d];@804A4A0`0;2`/400<30`802`/;0P0=3@d5
03Hf=P80CTi>0P1VIVH205MGE`80ATI60P12@T8304i>CP80:2PX0P0;2`/200L71`802`/;1`0=3@d4
00/;2`806a/K0P0R8R8301LG5`805ADE0P0];Bd203<c<`80?clo0P0h>3P502d];@806a/K0P0R8R82
034a<@80@T920`1@D50205aLG080?clo0P0];Bd201DE5@L03@d=0P0K6a/20451@@80Hf=S0`1eMGD2
0820P080TI6A0P2HV9P20:6QX@80[Zj^0`2d];@20:ZZZP80];Bd0P2SXj<20;Rh^080_Kfm0`2c/k<4
09^KV`80TI6A0P1]KFd206=SH`<0bLW90P3QhN420?[jnP80l_;b0P3Vi^H20?Shn0<0oooo0P3]kNd2
0?Gem@80o_kn0P3emOD20>CTi0<0Vi^K0P1]KFd205EEE@80Jf][0P29RHT209bLW0<0R8R80P2SXj<2
0:6QX@80ZZZZ0P2c/k<20:JVYP<0XJ6Q0P2HV9P208B4Q0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80LG5a0P1XJ6P305MGE`80CTi>0P15ADD203/k>`80;Bd]0P0A4A4300/;2`@00`<30P0;2`/2
00d=3@D0=SHf0P1>CTh206IVIP80EeMG0P16ATH20492@P<0CTi>0P0X:2P200/;2`801`L70P0;2`/7
00d=3@@02`/;0P0K6a/2028R8P<05aLG0P0E5AD202d];@80<c<c0P0o?cl203Ph>0D0;Bd]0P0K6a/2
028R8P80<C4a0P12@T83051@D080G5aL0P0o?cl202d];@805ADE1`0=3@d201/K6`80@D510P1SHf<3
07EeM@80P8200P2ATI4209RHV080XJ6Q0P2^[Zh30;Bd]080ZZZZ0P2d];@20:>SX`80^;Rh0P2m_Kd3
0;>c/`@0Vi^K0P2ATI4206e]K@80Hf=S0`39bLT20>7Qh@80n_[j0P3bl_820>KViP80n?Sh0`3oool2
0>g]k@80mOGe0P3no_h20?Gem@80i>CT0`2KVi/206e]K@80EEEE0P1[Jf/208V9R@80W9bL0`28R8P2
0:>SX`80XJ6Q0P2ZZZX20;>c/`80YZJV0`2QXJ4209RHV080Q8B41@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2=SHd208j>SP<0RHV90P26QXH207inOP80IVIV0P1<C4`203lo?`<0<c<c0P0A4A42
00d=3@801`L710030`<300/;2`80;Bd]0P15ADD20451@@80FUYJ0P1VIVH305QHF080FUYJ0P1>CTh2
02PX:0802`/;0P030`<301DE5@803@d=0P0E5AD2014A4@805ADE0P0A4A4301DE5@803@d=0P0G5aL2
02@T9080<c<c0P0h>3P302d];@@06a/K0P0G5aL202@T9080BDU91@16ATH2034a<@805aLG0P0A4A43
00/;2`806a/K0P0T92@202d];@80?3`l0P1SHf<306a/K080Jf][0P1CDe<206IVIP80WIfM0P2GUiL3
0::RXP80ZZZZ0P34a<@20<k>cP80alO70P2o_kl30<;2`P80/;2`0P2WYjL208n?S`80OWin0P1eMGD3
07moO`80][Jf0P3`l?020>KViP80oooo1@3]kNd20>SXj080kNg]0P3Zj^X20?3`l080kNg]0`3UiND2
0:j^[P80QHF50P1/K6`2069RHP80RXZ:0`2BTY8207IfMP80Q8B40P1jNWX208B4Q080WIfM0`2/[:`2
0:JVYP80WYjN1@3oool1o`00000000Co00000?ooo`3oool0oooo0P2=SHd208j>SP<0RHV90P26QXH2
07inOP80IVIV0P1<C4`203lo?`<0<c<c0P0A4A4200d=3@801`L710030`<300/;2`80;Bd]0P15ADD2
0451@@80FUYJ0P1VIVH305QHF080FUYJ0P1>CTh202PX:0802`/;0P030`<301DE5@803@d=0P0E5AD2
014A4@805ADE0P0A4A4301DE5@803@d=0P0G5aL202@T9080<c<c0P0h>3P302d];@@06a/K0P0G5aL2
02@T9080BDU91@16ATH2034a<@805aLG0P0A4A4300/;2`806a/K0P0T92@202d];@80?3`l0P1SHf<3
06a/K080Jf][0P1CDe<206IVIP80WIfM0P2GUiL30::RXP80ZZZZ0P34a<@20<k>cP80alO70P2o_kl3
0<;2`P80/;2`0P2WYjL208n?S`80OWin0P1eMGD307moO`80][Jf0P3`l?020>KViP80oooo1@3]kNd2
0>SXj080kNg]0P3Zj^X20?3`l080kNg]0`3UiND20:j^[P80QHF50P1/K6`2069RHP80RXZ:0`2BTY82
07IfMP80Q8B40P1jNWX208B4Q080WIfM0`2/[:`20:JVYP80WYjN1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2=SHd208Z:RP<0O7al0P1TI6@205aLG080FUYJ0P1[Jf/205QHF0<0D51@0P1ADE42
03/k>`805aLG10071`L300/;2`800`<30P0;2`/201LG5`80?clo0P12@T8304a<C0@0HF5Q0P19BDT2
034a<@804A4A0`030`<4014A4@803@d=0P0A4A4200d=3@<04A4A0P0E5AD2014A4@806a/K0P0X:2P2
034a<@<0<c<c0P0a<C4202@T9080?3`l0P0G5aL203/k>`<0DE5A0P1@D50202d];@804A4A1@0;2`/2
014A4@80<C4a0P1`L70407alO0<0MGEe0P1`L70206ATI080KFe]0P1QHF42075aL@<0SHf=0P2FUYH2
0;>c/`80bLW90P3@d=020<C4a0<0_Kfm0P2KVi/208n?S`80XJ6Q0P2FUYH206e]K@<0QXJ60P2FUYH2
0;Zj^P80dm?C0P3YjNT20?Gem@<0fm_K0P2ZZZX20<c<c080jn_[0P3]kNd20>GUi@<0h>3P0P3Kfm/2
09jNWP80Shn?0P1nOWh206][J`<0L71`0P1iNGT207EeM@80Jf][0P1gMgL208j>SP<0Rh^;0P1nOWh2
096AT@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80SHf=0P2:RXX307alO080I6AT0P1LG5`2
05YJFP80Jf][0P1HF5P3051@D080DE5A0P0k>c/201LG5`@01`L70`0;2`/200<30`802`/;0P0G5aL2
03lo?`80@T920`1<C4`4065QH@80BDU90P0a<C42014A4@<00`<3100A4A4200d=3@804A4A0P0=3@d3
014A4@805ADE0P0A4A4201/K6`80:2PX0P0a<C4303<c<`80<C4a0P0T92@203`l?0805aLG0P0k>c/3
055AD@80D51@0P0];Bd2014A4@D02`/;0P0A4A42034a<@80L71`101lO7`307EeM@80L71`0P1TI6@2
06e]K@80HF5Q0P1aLG4308f=S@80UYJF0P2c/k<20<W9b@80d=3@0P34a<@30;fm_@80Vi^K0P2?Shl2
0:6QX@80UYJF0P1]KFd308J6QP80UYJF0P2j^[X20=?Cd`80jNWY0P3emOD30=_Kf`80ZZZZ0P3<c<`2
0>_[j`80kNg]0P3UiND30>3Ph080fm_K0P2NWYh208n?S`80OWin0P1[Jf/3071`L080NGUi0P1eMGD2
06][J`80MgMg0P2>SXh308^;R`80OWin0P2ATI450?ooo`7o000000001?l00000oooo0?ooo`3oool2
08^;R`80MGEe0`1gMgL207UiN@80L71`0P1NGUh205eMG@80HF5Q0`1RHV82051@D080EEEE0P1ADE42
03Hf=P802`/;1`030`<200L71`802`/;0P0A4A4303<c<`80ADE50P1<C4`203`l?080FUYJ0P0o?cl3
028R8P801`L70P0E5AD4014A4@805ADE0`0A4A4400d=3@804A4A0P0T92@202d];@<0<C4a0P0c<c<2
02@T90806a/K0P0R8R8202d];@<0ADE50P16ATH203Hf=P804A4A0P0=3@d501DE5@80>c/k0P1QHF42
08j>SP80OWin0`1bLW8206ATI080EEEE0P1TI6@206=SH`80GEeM0`1SHf<20861P@80TI6A0P2LW9`2
0:j^[P80];Bd0`2m_Kd209NGU`80ZZZZ0P1dM7@208^;R`80P8200`1TI6@208J6QP80/;2`0P2WYjL2
0<30`080iNGU0`3emOD20<C4a080RHV90P2i^KT20>k^kP80m?Cd0`3]kNd20=GEe@80c/k>0P2XZ:P2
08n?S`80O7al0`1/K6`207UiN@80OWin0P1`L70207MgM`80K6a/0`2:RXX408B4Q0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80Rh^;0P1eMGD307MgM`80NGUi0P1`L70205iNGP80GEeM0P1QHF43
069RHP80D51@0P1EEED2055AD@80=SHf0P0;2`/700<30`801`L70P0;2`/2014A4@<0<c<c0P15ADD2
04a<C080?3`l0P1JFUX203lo?`<08R8R0P071`L201DE5@@04A4A0P0E5AD3014A4@@03@d=0P0A4A42
02@T9080;Bd]0`0a<C4203<c<`8092@T0P0K6a/2028R8P80;Bd]0`15ADD204I6AP80=SHf0P0A4A42
00d=3@D05ADE0P0k>c/2065QH@80SXj>0P1nOWh3079bLP80I6AT0P1EEED206ATI080Hf=S0P1MGEd3
06=SH`80PH610P2ATI4209bLW080[Zj^0P2d];@30;fm_@80UiNG0P2ZZZX207AdM080Rh^;0P20P803
06ATI080QXJ60P2`/;020:NWY`80`<300P3UiND30?Gem@80a<C40P29RHT20;Vi^@80k^k^0P3dm?@3
0>g]k@80eMGE0P3>c/h20:RXZ080Shn?0P1lO7`306a/K080NGUi0P1nOWh2071`L080MgMg0P1/K6`3
08Z:RP@0Q8B41@3oool1o`00000000Co00000?ooo`3oool0oooo0P2;Rh/207EeM@<0MgMg0P1iNGT2
071`L080GUiN0P1MGEd2065QH@<0HV9R0P1@D50205EEE@80DE5A0P0f=SH200/;2`L00`<30P071`L2
00/;2`804A4A0`0c<c<204E5A@80C4a<0P0l?3`205YJFP80?clo0`0R8R8200L71`805ADE100A4A42
01DE5@<04A4A100=3@d2014A4@8092@T0P0];Bd3034a<@80<c<c0P0T92@201/K6`808R8R0P0];Bd3
04E5A@80ATI60P0f=SH2014A4@803@d=1@0E5AD203/k>`80HF5Q0P2>SXh207inOP<0LW9b0P1TI6@2
05EEE@80I6AT0P1SHf<205eMG@<0Hf=S0P21PH42096AT@80W9bL0P2^[Zh20;Bd]0<0_Kfm0P2GUiL2
0:ZZZP80M7Ad0P2;Rh/20820P0<0I6AT0P26QXH20;2`/080YjNW0P30`<020>GUi@<0mOGe0P34a<@2
08V9R@80^KVi0P3^k^h20?Cdm0<0kNg]0P3EeMD20<k>cP80Z:RX0P2?Shl207alO0<0K6a/0P1iNGT2
07inOP80L71`0P1gMgL206a/K0<0RXZ:1024Q8@50?ooo`7o000000001?l00000oooo0?ooo`3oool2
08f=S@80Q8B40`25QHD206=SH`80L71`0P1jNWX207MgM`80NGUi0`1bLW82065QH@@0EEEE0P1CDe<2
04i>CP<0ADE50P0R8R8800<30`<02`/;0P0E5AD2034a<@80C4a<0P1GEeL2051@D0<0BDU90P0c<c<4
014A4@803@d=0P0E5AD300d=3@806a/K0P0G5aL201DE5@804A4A0P0R8R83034a<@@0;Bd]0P0T92@2
028R8P806a/K0`11@D4204U9B@80=SHf0P0T92@500d=3@80:2PX0P1CDe<207IfMP80M7Ad0P29RHT3
07moO`@0MGEe0P1bLW82069RHP80Hf=S0`1bLW82071`L080NGUi0P2CTi<209RHV080TY:B0`2LW9`2
09fMW@80UiNG0P28R8P208F5Q@80QXJ60`1eMGD2065QH@80LW9b0P2LW9`20;>c/`80Z:RX0`3=cLd2
0=GEe@80Ti>C0P25QHD20;Fe]@80i^KV0`3]kNd20>3Ph080a<C40P2^[Zh20:2PX080SXj>0`1bLW82
05QHF080EEEE0P2=SHd207YjNP80MgMg0`1NGUh208Z:RP80Ogmo1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2=SHd208B4Q0<0QHF50P1SHf<2071`L080NWYj0P1gMgL207UiN@<0LW9b0P1QHF44
05EEE@80De=C0P1>CTh304E5A@808R8R20030`<300/;2`805ADE0P0a<C4204a<C080EeMG0P1@D503
04U9B@80<c<c100A4A4200d=3@805ADE0`0=3@d201/K6`805aLG0P0E5AD2014A4@808R8R0`0a<C44
02d];@8092@T0P0R8R8201/K6`<0@D510P19BDT203Hf=P8092@T1@0=3@d202PX:080De=C0P1fMWH2
07AdM080RHV90`1oOgl407EeM@80LW9b0P1RHV8206=SH`<0LW9b0P1`L70207UiN@80Ti>C0P2HV9P2
09:BTP<0W9bL0P2MWId209NGU`80R8R80P25QHD208J6QP<0MGEe0P1QHF42079bLP80W9bL0P2c/k<2
0:RXZ0<0cLg=0P3EeMD209>CT`80QHF50P2e]KD20>KViP<0kNg]0P3Ph>020<C4a080[Zj^0P2PX:02
08j>SP<0LW9b0P1HF5P205EEE@80SHf=0P1jNWX207MgM`<0GUiN0P2:RXX207moO`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80TY:B0P26QXH307alO080RXZ:0P20P80205eMG@80G5aL0P1NGUh3
06e]K@80LG5a0P1gMgL2065QH@80EEEE0P1>CTh304a<C080@T920P11@D42034a<@802`/;1@030`<2
00L71`804A4A0P0h>3P203<c<`80?3`l0`1RHV8205aLG080ADE50P0];Bd2014A4@80:2PX0`0G5aL2
00d=3@@04A4A0P0G5aL201DE5@<05aLG0P0X:2P402XZ:P80:2PX0P0R8R8302d];@80ADE50P1>CTh2
02d];@D05ADE0P0f=SH206IVIP80MGEe0P2BTY8208J6QP<0MWIf0P2=SHd208F5Q@80Shn?0P1nOWh2
07EeM@<0P8200P1nOWh208R8R080ZZZZ0P2RXZ820:2PX0<0SXj>0P2LW9`208Z:RP80TI6A0P28R8P2
07inOP<0SHf=0P20P802065QH@80LW9b0P2HV9P209fMW@<0YZJV0P2UYJD20:ZZZP@0XJ6Q0P2c/k<3
0<30`080gmoO0P3=cLd20;>c/`80XJ6Q0P2LW9`309:BTP80L71`0P1GEeL204U9B@80NWYj0P1bLW83
07YjNP80Hf=S0P28R8P50?ooo`7o000000001?l00000oooo0?ooo`3oool209:BTP80QXJ60`1lO7`2
08Z:RP80P8200P1MGEd205aLG080GUiN0`1]KFd2075aL@80MgMg0P1QHF4205EEE@80CTi>0`1<C4`2
0492@P80@D510P0a<C4200/;2`D00`<30P071`L2014A4@80>3Ph0P0c<c<203`l?0<0HV9R0P1LG5`2
04E5A@80;Bd]0P0A4A4202PX:0<05aLG0P0=3@d4014A4@805aLG0P0E5AD301LG5`80:2PX100Z:RX2
02PX:0808R8R0`0];Bd204E5A@80CTi>0P0];Bd501DE5@80=SHf0P1VIVH207EeM@80TY:B0P26QXH3
07IfMP80SHf=0P25QHD208n?S`80OWin0P1eMGD30820P080OWin0P28R8P20:ZZZP80XZ:R0P2PX:03
08j>SP80W9bL0P2:RXX2096AT@80R8R80P1nOWh308f=S@80P8200P1QHF42079bLP80V9RH0P2MWId3
0:JVYP80YJFU0P2ZZZX40:6QX@80/k>c0`30`<020=oOg`80cLg=0P2c/k<20:6QX@80W9bL0`2BTY82
071`L080EeMG0P19BDT207YjNP80LW9b0`1jNWX206=SH`80R8R81@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2DU9@209^KV`<0SHf=0P29RHT208Z:RP80Rh^;0P1lO7`207UiN@<0MgMg0P21PH42
07UiN@80O7al0P1fMWH206a/K0<0GEeM0P1LG5`205MGE`80GEeM0P1CDe<20492@P<03@d=0P071`L2
00<30`801`L70P0G5aL202d];@<0?3`l0P0f=SH20451@@80CTi>0P0k>c/201DE5@D03@d=1P0A4A42
01LG5`<04A4A0P0G5aL202PX:080:RXZ0P0X:2P202XZ:P<0<c<c0P11@D4205eMG@80@T920P0T92@3
028R8P80>3Ph0P1NGUh207YjNP80Q8B40P28R8P308F5Q@80MGEe0P2=SHd208^;R`80R8R80P29RHT3
08B4Q0@0P8200P2WYjL20:b/[080aLG50`2i^KT20:j^[P@0[:b/0P2ATI420:FUY@<0SHf=0P2CTi<2
07UiN@80P8200P1fMWH20::RXP<0UiNG0P2ZZZX209>CT`80RHV90P2ATI4209NGU`<0RXZ:0P24Q8@2
0:2PX080Xj>S0P2GUiL20;Bd]0<0YZJV0P28R8P20861P@80HV9R0P1GEeL2075aL@<0LW9b0P21PH42
071`L0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80U9BD0P2KVi/308f=S@80RHV90P2:RXX2
08^;R`80O7al0P1iNGT307MgM`80PH610P1iNGT207alO080MWIf0P1/K6`305eMG@80G5aL0P1GEeL2
05eMG@80De=C0P12@T8300d=3@801`L70P030`<200L71`805aLG0P0];Bd303`l?080=SHf0P11@D42
04i>CP80>c/k0P0E5AD500d=3@H04A4A0P0G5aL3014A4@805aLG0P0X:2P202XZ:P80:2PX0P0Z:RX3
03<c<`80@D510P1MGEd20492@P8092@T0`0R8R8203Ph>080GUiN0P1jNWX208B4Q080R8R80`25QHD2
07EeM@80SHf=0P2;Rh/208R8R080RHV90`24Q8@40820P080YjNW0P2/[:`20<G5a@<0^KVi0P2^[Zh4
0:b/[080TI6A0P2UYJD308f=S@80Ti>C0P1iNGT20820P080MWIf0P2RXZ8309NGU`80ZZZZ0P2CTi<2
08V9R@80TI6A0P2GUiL308Z:RP80Q8B40P2PX:020:>SX`80UiNG0P2d];@30:JVYP80R8R80P21PH42
069RHP80EeMG0P1aLG43079bLP80PH610P1`L7050?ooo`7o000000001?l00000oooo0?ooo`3oool2
09BDU080Vi^K0`2=SHd208V9R@80RXZ:0P2;Rh/207alO080NGUi0`1gMgL20861P@80NGUi0P1lO7`2
07IfMP80K6a/0`1MGEd205aLG080EeMG0P1MGEd205=CD`80@T920`0=3@d200L71`800`<30P071`L2
01LG5`80;Bd]0`0l?3`203Hf=P80@D510P1>CTh203/k>`805ADE1@0=3@d6014A4@805aLG0`0A4A42
01LG5`80:2PX0P0Z:RX202PX:080:RXZ0`0c<c<20451@@80GEeM0P12@T8202@T90<08R8R0P0h>3P2
05iNGP80NWYj0P24Q8@208R8R0<0QHF50P1eMGD208f=S@80Rh^;0P28R8P208V9R@<0Q8B41020P802
0:NWY`80[:b/0P35aLD30;Vi^@80[Zj^102/[:`2096AT@80YJFU0`2=SHd209>CT`80NGUi0P20P802
07IfMP80XZ:R0`2GUiL20:ZZZP80Ti>C0P29RHT2096AT@80UiNG0`2:RXX208B4Q080X:2P0P2SXj<2
09NGU`80];Bd0`2VYZH208R8R080PH610P1RHV8205MGE`80LG5a0`1bLW820861P@80L71`1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1lO7`50:JVYP80Vi^K0P2VYZH208^;R`80U9BD0P2MWId3
096AT@80UiNG0P1oOgl209NGU`80SXj>0P1fMWH3079bLP80MWIf0P1JFUX205=CD`80FUYJ0P1EEED3
0492@P80<C4a0P0E5AD200<30`801`L70P0;2`/301/K6`80>3Ph0P15ADD203/k>`80@T920P0k>c/3
01DE5@804A4A100=3@d2014A4@803@d=0`0E5AD2014A4@@05aLG0P0T92@202PX:0<092@T0P0Z:RX4
04a<C080<C4a0`0f=SH204a<C080Hf=S0P1]KFd207MgM`80NWYj0`1dM7@2071`L080P8200P2HV9P2
09jNWP80UiNG0`1jNWX207moO`80YZJV0P2>SXh20<30`080^k^k0`3@d=020=[JfP80a<C40P3@d=02
0:ZZZP80Rh^;0`1eMGD2055AD@80HF5Q0P1`L70208n?S`80Vi^K0`2VYZH209fMW@80X:2P0P2?Shl2
09^KV`80Ti>C0`21PH4207AdM080NGUi0P25QHD208j>SP80U9BD0`2ZZZX209RHV080TY:B0P2>SXh2
07YjNP80De=C0`1dM7@208f=S@80P8201@3oool1o`00000000Co00000?ooo`3oool0oooo0P1lO7`5
0:JVYP80Vi^K0P2VYZH208^;R`80U9BD0P2MWId3096AT@80UiNG0P1oOgl209NGU`80SXj>0P1fMWH3
079bLP80MWIf0P1JFUX205=CD`80FUYJ0P1EEED30492@P80<C4a0P0E5AD200<30`801`L70P0;2`/3
01/K6`80>3Ph0P15ADD203/k>`80@T920P0k>c/301DE5@804A4A100=3@d2014A4@803@d=0`0E5AD2
014A4@@05aLG0P0T92@202PX:0<092@T0P0Z:RX404a<C080<C4a0`0f=SH204a<C080Hf=S0P1]KFd2
07MgM`80NWYj0`1dM7@2071`L080P8200P2HV9P209jNWP80UiNG0`1jNWX207moO`80YZJV0P2>SXh2
0<30`080^k^k0`3@d=020=[JfP80a<C40P3@d=020:ZZZP80Rh^;0`1eMGD2055AD@80HF5Q0P1`L702
08n?S`80Vi^K0`2VYZH209fMW@80X:2P0P2?Shl209^KV`80Ti>C0`21PH4207AdM080NGUi0P25QHD2
08j>SP80U9BD0`2ZZZX209RHV080TY:B0P2>SXh207YjNP80De=C0`1dM7@208f=S@80P8201@3oool1
o`00000000Co00000?ooo`3oool0oooo0P15ADD205MGE`<0YjNW0P2d];@20::RXP80/k>c0P2WYjL2
0;>c/`<0/K6a0P2FUYH209>CT`80U9BD0P1lO7`208R8R0<0L71`0P1MGEd2075aL@80FUYJ0P1ADE42
05YJFP<0D51@0P15ADD203<c<`80>c/k0P0G5aL200L71`<02`/;0P0=3@d201/K6`80;Bd]0P16ATH2
04E5A@<0ATI60P0G5aL400d=3@805ADE0P0;2`/3014A4@805aLG100A4A4202@T9080:RXZ1@0T92@2
03<c<`80@T920P0f=SH303Ph>080@T920P1EEED206=SH`80O7al0P1`L70307AdM080GEeM0P1ADE42
06QXJ080P8200P2=SHd309RHV080Xj>S0P2LW9`20:2PX080e]KF0P2e]KD30<30`080bl_;0P32`/82
0=?Cd`80gMgM0P2c/k<307UiN@80LG5a0P11@D4205iNGP80NGUi0P2KVi/309bLW080U9BD0P2FUYH2
0:>SX`80RXZ:0P28R8P507UiN@80Jf][0P1dM7@20861P@D0V9RH102FUYH20:6QX@80W9bL0P2BTY83
06ATI080BDU90P1[Jf/50?ooo`7o000000001?l00000oooo0?ooo`3oool204E5A@80EeMG0`2WYjL2
0;Bd]080XZ:R0P2c/k<20:NWY`80/k>c0`2a/K4209JFUP80Ti>C0P2DU9@207alO080R8R80`1`L702
05eMG@80LG5a0P1JFUX2055AD@80FUYJ0`1@D50204E5A@80<c<c0P0k>c/201LG5`801`L70`0;2`/2
00d=3@806a/K0P0];Bd204I6AP80ADE50`16ATH201LG5`@03@d=0P0E5AD200/;2`<04A4A0P0G5aL4
014A4@8092@T0P0Z:RX502@T9080<c<c0P12@T8203Hf=P<0>3Ph0P12@T8205EEE@80Hf=S0P1lO7`2
071`L0<0M7Ad0P1MGEd2055AD@80J6QX0P20P80208f=S@<0V9RH0P2SXj<209bLW080X:2P0P3Fe]H2
0;Fe]@<0`<300P3;bl/20<;2`P80dm?C0P3MgMd20;>c/`<0NGUi0P1aLG420451@@80GUiN0P1iNGT2
09^KV`<0W9bL0P2DU9@209JFUP80Xj>S0P2:RXX208R8R0D0NGUi0P1[Jf/207AdM080PH611@2HV9P4
09JFUP80XJ6Q0P2LW9`209:BTP<0I6AT0P19BDT206][J`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80De=C0P1ADE4306][J`80Xj>S0P2XZ:P20:6QX@80[:b/0P2PX:03096AT@80Xj>S0P2c/k<2
0:>SX`80WIfM0P2ATI430820P080RXZ:0P1/K6`206IVIP80MgMg0P1[Jf/305EEE@80C4a<0P15ADD4
03`l?080ADE50`0A4A4400/;2`803@d=0P0T92@203Hf=P<0ADE50P1EEED200d=3@808R8R0P0A4A45
00d=3@H04A4A0P0=3@d201LG5`<06a/K100T92@203Ph>0D0?clo0P1<C4`206a/K0@0P8200P1bLW83
051@D080CTi>0P1CDe<4051@D080L71`0`2?Shl20::RXP80_Kfm0P33`l<20<G5a@80_[jn0`2a/K42
0:j^[P80Zj^[0P2e]KD20:ZZZP80Zj^[0`2XZ:P208Z:RP80IVIV0P1HF5P2079bLP80UiNG0`2XZ:P2
096AT@@0Q8B40P2GUiL208F5Q@<0MGEe0P1bLW8206=SH`80K6a/0P1nOWh206a/K0<0P8200P24Q8@2
08Z:RP80TY:B0P2?Shl20:FUY@<0SHf=0P1]KFd204a<C0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80De=C0P1ADE4306][J`80Xj>S0P2XZ:P20:6QX@80[:b/0P2PX:03096AT@80Xj>S0P2c/k<2
0:>SX`80WIfM0P2ATI430820P080RXZ:0P1/K6`206IVIP80MgMg0P1[Jf/305EEE@80C4a<0P15ADD4
03`l?080ADE50`0A4A4400/;2`803@d=0P0T92@203Hf=P<0ADE50P1EEED200d=3@808R8R0P0A4A45
00d=3@H04A4A0P0=3@d201LG5`<06a/K100T92@203Ph>0D0?clo0P1<C4`206a/K0@0P8200P1bLW83
051@D080CTi>0P1CDe<4051@D080L71`0`2?Shl20::RXP80_Kfm0P33`l<20<G5a@80_[jn0`2a/K42
0:j^[P80Zj^[0P2e]KD20:ZZZP80Zj^[0`2XZ:P208Z:RP80IVIV0P1HF5P2079bLP80UiNG0`2XZ:P2
096AT@@0Q8B40P2GUiL208F5Q@<0MGEe0P1bLW8206=SH`80K6a/0P1nOWh206a/K0<0P8200P24Q8@2
08Z:RP80TY:B0P2?Shl20:FUY@<0SHf=0P1]KFd204a<C0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80HV9R0P1>CTh307AdM080MWIf0P20P80207alO080P8200P26QXH307UiN@80MGEe0P2:RXX2
09>CT`80YZJV0P2RXZ830:NWY`80NGUi101]KFd206a/K080MWIf0`1<C4`203lo?`80<c<c0P0h>3P2
0492@P80D51@0`1CDe<203lo?`804A4A100=3@d200/;2`<05aLG0P0R8R8203/k>`H04A4A0`0=3@d2
00/;2`803@d=100E5AD2014A4@<06a/K0P0X:2P402XZ:P80?clo0`0f=SH20492@P80GEeM0P28R8P2
08V9R@80K6a/0`1RHV8204E5A@80?3`l0P1ADE4204i>CP80F5QH0`1gMgL209fMW@80`/;20P3Bd]82
0<O7a`80V9RH0`2:RXX20861P@80RHV90P25QHD20861P@80R8R80`24Q8@207UiN@80HV9R0P1HF5P2
05YJFP80M7Ad0`2QXJ420:FUY@80Ti>C0P1]KFd2071`L080NWYj0`1dM7@206IVIP80HV9R0P1JFUX2
055AD@80GUiN0`1XJ6P206ATI080LW9b0P20P80207UiN@80Vi^K0`2c/k<209fMW@80Ogmo1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1RHV8204i>CP<0M7Ad0P1fMWH20820P080O7al0P20P802
08J6QP<0NGUi0P1eMGD208Z:RP80Ti>C0P2VYZH20::RXP<0YjNW0P1iNGT406e]K@80K6a/0P1fMWH3
04a<C080?clo0P0c<c<203Ph>080@T920P1@D50305=CD`80?clo0P0A4A4400d=3@802`/;0`0G5aL2
028R8P80>c/k1P0A4A4300d=3@802`/;0P0=3@d401DE5@804A4A0`0K6a/202PX:0@0:RXZ0P0o?cl3
03Hf=P80@T920P1MGEd208R8R080RHV90P1/K6`3069RHP80ADE50P0l?3`2055AD@80CTi>0P1HF5P3
07MgM`80WIfM0P32`/820=;BdP80alO70P2HV9P308Z:RP80PH610P29RHT208F5Q@80PH610P28R8P3
08B4Q080NGUi0P1RHV8205QHF080FUYJ0P1dM7@30:6QX@80YJFU0P2CTi<206e]K@80L71`0P1jNWX3
07AdM080IVIV0P1RHV8205YJFP80DE5A0P1NGUh306QXJ080I6AT0P1bLW820820P080NGUi0P2KVi/3
0;>c/`80WIfM0P1oOgl50?ooo`7o000000001?l00000oooo0?ooo`3oool2069RHP80CTi>0`1dM7@2
07IfMP80P8200P1lO7`20820P080QXJ60`1iNGT207EeM@80RXZ:0P2CTi<20:JVYP80XZ:R0`2WYjL2
07UiN@@0KFe]0P1/K6`207IfMP<0C4a<0P0o?cl203<c<`80>3Ph0P12@T82051@D0<0De=C0P0o?cl2
014A4@@03@d=0P0;2`/301LG5`808R8R0P0k>c/6014A4@<03@d=0P0;2`/200d=3@@05ADE0P0A4A43
01/K6`80:2PX100Z:RX203lo?`<0=SHf0P12@T8205eMG@80R8R80P29RHT206a/K0<0HV9R0P15ADD2
03`l?080DE5A0P1>CTh205QHF0<0MgMg0P2MWId20<;2`P80d];B0P37alL209RHV0<0RXZ:0P21PH42
08V9R@80QHF50P21PH4208R8R0<0Q8B40P1iNGT2069RHP80F5QH0P1JFUX207AdM0<0XJ6Q0P2UYJD2
09>CT`80KFe]0P1`L70207YjNP<0M7Ad0P1VIVH2069RHP80FUYJ0P1ADE4205iNGP<0J6QX0P1TI6@2
079bLP80P8200P1iNGT209^KV`<0/k>c0P2MWId207moO`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80RHV90P1LG5`30492@P80FUYJ0P1SHf<206ATI0@0GUiN0`1TI6@2069RHP80G5aL0P1]KFd2
075aL@80MGEe0`2=SHd209RHV080UYJF0P29RHT207IfMP80IVIV0`1]KFd205EEE@80@T920P0h>3P2
04E5A@80>c/k0`0f=SH203<c<`80?3`l0P0T92@400d=3@<05ADE0P0A4A4201/K6`80>3Ph0P0G5aL2
014A4@<02`/;200=3@d201DE5@D04A4A100K6a/203Hf=P<0ADE50P0c<c<203Ph>080LG5a0P1oOgl2
06e]K@<0EEEE0P1MGEd204U9B@80D51@0P1<C4`2051@D0<0IVIV0P29RHT20<W9b@80fm_K0P33`l<2
0:JVYP<0SXj>0P1dM7@205iNGP80G5aL0P1MGEd2065QH@<0MWIf0P1]KFd2069RHP80CTi>0P0h>3P2
05EEE@<0Ogmo0P2NWYh209^KV`80SHf=0P1[Jf/206=SH`<0HV9R0P1MGEd205aLG080EEEE0P1CDe<2
04U9B@<0GUiN0P1SHf<205MGE`80GUiN0P1bLW8207MgM`<0QXJ60P2BTY820::RXPD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80RHV90P1LG5`30492@P80FUYJ0P1SHf<206ATI0@0GUiN0`1TI6@2
069RHP80G5aL0P1]KFd2075aL@80MGEe0`2=SHd209RHV080UYJF0P29RHT207IfMP80IVIV0`1]KFd2
05EEE@80@T920P0h>3P204E5A@80>c/k0`0f=SH203<c<`80?3`l0P0T92@400d=3@<05ADE0P0A4A42
01/K6`80>3Ph0P0G5aL2014A4@<02`/;200=3@d201DE5@D04A4A100K6a/203Hf=P<0ADE50P0c<c<2
03Ph>080LG5a0P1oOgl206e]K@<0EEEE0P1MGEd204U9B@80D51@0P1<C4`2051@D0<0IVIV0P29RHT2
0<W9b@80fm_K0P33`l<20:JVYP<0SXj>0P1dM7@205iNGP80G5aL0P1MGEd2065QH@<0MWIf0P1]KFd2
069RHP80CTi>0P0h>3P205EEE@<0Ogmo0P2NWYh209^KV`80SHf=0P1[Jf/206=SH`<0HV9R0P1MGEd2
05aLG080EEEE0P1CDe<204U9B@<0GUiN0P1SHf<205MGE`80GUiN0P1bLW8207MgM`<0QXJ60P2BTY82
0::RXPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80V9RH0P2MWId306ATI080@T920P0K6a/2
02PX:080@D510P1<C4`3055AD@80ADE50P16ATH204i>CP80BDU90P1CDe<305YJFP80J6QX0P1gMgL2
08^;R`80Xj>S0P2BTY8307YjNP80HF5Q0P1<C4`204E5A@80@T920P11@D4304I6AP80D51@0P0l?3`2
02d];@808R8R0P0G5aL9014A4@80:RXZ1@0A4A4600d=3@T02`/;0P0A4A4201DE5@805aLG0`0h>3P6
0451@@80NWYj0P1eMGD305iNGP80HV9R0P1EEED204I6AP@0ADE50`1/K6`208^;R`80Shn?0P3Bd]82
0;fm_@80Ti>C0`1dM7@204U9B@80@T920P16ATH205MGE`80GUiN0`1@D50203<c<`80:RXZ0P0T92@2
034a<@808R8R0`1CDe<209:BTP80WIfM0P29RHT2079bLP80G5aL0`1GEeL205EEE@@0DE5A0P1@D502
04I6AP<0De=C0P1NGUh205QHF080HV9R0P1HF5P206e]K@<0K6a/0P1dM7@20820P0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80V9RH0P2MWId306ATI080@T920P0K6a/202PX:080@D510P1<C4`3
055AD@80ADE50P16ATH204i>CP80BDU90P1CDe<305YJFP80J6QX0P1gMgL208^;R`80Xj>S0P2BTY83
07YjNP80HF5Q0P1<C4`204E5A@80@T920P11@D4304I6AP80D51@0P0l?3`202d];@808R8R0P0G5aL9
014A4@80:RXZ1@0A4A4600d=3@T02`/;0P0A4A4201DE5@805aLG0`0h>3P60451@@80NWYj0P1eMGD3
05iNGP80HV9R0P1EEED204I6AP@0ADE50`1/K6`208^;R`80Shn?0P3Bd]820;fm_@80Ti>C0`1dM7@2
04U9B@80@T920P16ATH205MGE`80GUiN0`1@D50203<c<`80:RXZ0P0T92@2034a<@808R8R0`1CDe<2
09:BTP80WIfM0P29RHT2079bLP80G5aL0`1GEeL205EEE@@0DE5A0P1@D50204I6AP<0De=C0P1NGUh2
05QHF080HV9R0P1HF5P206e]K@<0K6a/0P1dM7@20820P0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80R8R80P2BTY8309RHV080LG5a0P1<C4`200/;2`805aLG0P0A4A4501/K6`80:RXZ0P0o?cl4
03/k>`<0:RXZ0P0];Bd203`l?080F5QH0P1`L70208J6QP<0SHf=0P2GUiL207MgM`80Jf][0P1HF5P2
04U9B@<0=SHf0P0Z:RX2034a<@80=SHf0P0];Bd203/k>`<0:RXZ0P0E5AD401LG5`806a/K0P0T92@;
00d=3@D02`/;10071`L200/;2`803@d=0`0T92@203Ph>080<c<c0P16ATH205QHF080Jf][0`1iNGT2
079bLP80GEeM0P1ADE4404E5A@<0GUiN0P1TI6@209NGU`80aLG50P2k^k/207moO`<0GEeM0P1oOgl2
08J6QP80Ti>C0P2HV9P20:>SX`<0d=3@0P3^k^h20=3@d080?3`l0P071`L503<c<`80F5QH0P2?Shl2
08Z:RP80MGEe0P1GEeL30492@P80ADE50P1>CTh2051@D080?clo0P19BDT305iNGP80De=C0P1JFUX2
05aLG080EEEE0P1GEeL305eMG@80De=C0P1VIVH50?ooo`7o000000001?l00000oooo0?ooo`3oool2
08R8R080TY:B0`2HV9P2075aL@80C4a<0P0;2`/201LG5`804A4A1@0K6a/202XZ:P80?clo100k>c/3
02XZ:P80;Bd]0P0l?3`205QHF080L71`0P26QXH308f=S@80UiNG0P1gMgL206][J`80F5QH0P19BDT3
03Hf=P80:RXZ0P0a<C4203Hf=P80;Bd]0P0k>c/302XZ:P805ADE100G5aL201/K6`8092@T2`0=3@d5
00/;2`@01`L70P0;2`/200d=3@<092@T0P0h>3P203<c<`80ATI60P1HF5P206][J`<0NGUi0P1bLW82
05eMG@80DE5A1015ADD305iNGP80I6AT0P2GUiL20<G5a@80^k^k0P1oOgl305eMG@80Ogmo0P26QXH2
09>CT`80V9RH0P2SXj<30=3@d080k^k^0P3@d=0203`l?0801`L71@0c<c<205QHF080Shn?0P2:RXX2
07EeM@80EeMG0`12@T8204E5A@80CTi>0P1@D50203lo?`80BDU90`1NGUh205=CD`80FUYJ0P1LG5`2
05EEE@80EeMG0`1MGEd205=CD`80IVIV1@3oool1o`00000000Co00000?ooo`3oool0oooo0P28R8P2
09:BTP<0V9RH0P1aLG4204a<C0802`/;0P0G5aL2014A4@D06a/K0P0Z:RX203lo?`@0>c/k0`0Z:RX2
02d];@80?3`l0P1HF5P2071`L080QXJ60`2=SHd209NGU`80MgMg0P1[Jf/205QHF080BDU90`0f=SH2
02XZ:P80<C4a0P0f=SH202d];@80>c/k0`0Z:RX201DE5@@05aLG0P0K6a/202@T90/03@d=1@0;2`/4
00L71`802`/;0P0=3@d302@T9080>3Ph0P0c<c<204I6AP80F5QH0P1[Jf/307UiN@80LW9b0P1MGEd2
055AD@@0ADE50`1NGUh206ATI080UiNG0P35aLD20;^k^`80Ogmo0`1MGEd207moO`80QXJ60P2CTi<2
09RHV080Xj>S0`3@d=020>k^kP80d=3@0P0l?3`200L71`D0<c<c0P1HF5P208n?S`80RXZ:0P1eMGD2
05MGE`<0@T920P15ADD204i>CP80D51@0P0o?cl204U9B@<0GUiN0P1CDe<205YJFP80G5aL0P1EEED2
05MGE`<0GEeM0P1CDe<206IVIPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80J6QX0P1nOWh3
08j>SP80X:2P0P2;Rh/204i>CP@04A4A1@0;2`/206ATI080aLG50P3Ph>020=gMg@<0^k^k0P2WYjL2
07moO`80@T920P0a<C4204E5A@<0LG5a0P24Q8@208j>SP80TI6A0P1TI6@2071`L0<0FUYJ0P0f=SH2
02d];@80=SHf0P0];Bd5034a<@8092@T1P0G5aL201/K6`<05aLG0P0=3@d2014A4@T02`/;0P0A4A42
00d=3@@04A4A0`0E5AD2034a<@80>c/k0P1<C4`20492@P80J6QX0`1eMGD206IVIP@0HF5Q0P1HF5P2
065QH@<0FUYJ0P1iNGT207moO`80];Bd0P2m_Kd2071`L0<0ADE50P2e]KD20;Jf]P80O7al0P0a<C42
01DE5@<0;Bd]0P2LW9`20>3Ph080[Zj^0P15ADD200L71`<05ADE0P1@D50207IfMP80QHF50P1bLW82
05iNGP<0De=C0P11@D4203lo?`H0@T920`1@D50205aLG080EeMG0P1<C4`205=CD`80FUYJ0`1>CTh2
04a<C080De=C1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1XJ6P207inOP<0SXj>0P2PX:02
08^;R`80CTi>100A4A4500/;2`80I6AT0P35aLD20>3Ph080gMgM0`2k^k/20:NWY`80Ogmo0P12@T82
034a<@80ADE50`1aLG4208B4Q080SXj>0P2ATI4206ATI080L71`0`1JFUX203Hf=P80;Bd]0P0f=SH2
02d];@D0<C4a0P0T92@601LG5`806a/K0`0G5aL200d=3@804A4A2@0;2`/2014A4@803@d=100A4A43
01DE5@80<C4a0P0k>c/204a<C080@T920P1XJ6P307EeM@80IVIV101QHF4205QHF080HF5Q0`1JFUX2
07UiN@80Ogmo0P2d];@20;fm_@80L71`0`15ADD20;Fe]@80][Jf0P1lO7`2034a<@805ADE0`0];Bd2
09bLW080h>3P0P2^[Zh204E5A@801`L70`0E5AD2051@D080MWIf0P25QHD2079bLP80GUiN0`1CDe<2
0451@@80?clo1P12@T83051@D080G5aL0P1GEeL204a<C080De=C0P1JFUX304i>CP80C4a<0P1CDe<5
0?ooo`7o000000001?l00000oooo0?ooo`3oool2051@D080Hf=S0`1[Jf/207IfMP80SXj>0P1nOWh2
05QHF0806a/K1@030`<201LG5`80/k>c0P3Lg=`20<O7a`<0YJFU0P28R8P209JFUP80/k>c0P35aLD2
08J6QP<0;Bd]0P1<C4`206a/K080Ogmo0P29RHT207EeM@<0IVIV0P1dM7@2051@D080>3Ph0P0l?3`2
02d];@<092@T0P0k>c/202@T90805ADE0P0G5aL201DE5@<04A4A0P0E5AD200L71`803@d=0P0A4A4=
00/;2`<04A4A0P0=3@d202XZ:P80BDU90P1HF5P204I6APD0KFe]0P1QHF42055AD@80IVIV0P1ADE43
05QHF080M7Ad0P2;Rh/20:2PX080[:b/0P26QXH304I6AP80V9RH0P2c/k<207EeM@805aLG0P071`L5
00<30`808R8R0P1]KFd203Hf=P805ADE0`0X:2P203`l?080LW9b0P1`L70207AdM080HV9R0`1JFUX2
04I6AP80@T920P0k>c/204I6AP80@D510`12@T8204U9B@80DE5A0P1<C4`204U9B@80@T920`0o?cl2
04i>CP80@T921@3oool1o`00000000Co00000?ooo`3oool0oooo0P1@D50206=SH`<0Jf][0P1fMWH2
08j>SP80OWin0P1HF5P201/K6`D00`<30P0G5aL20;>c/`80g=cL0P37alL30:FUY@80R8R80P2FUYH2
0;>c/`80aLG50P26QXH302d];@80C4a<0P1/K6`207moO`80RHV90P1eMGD306IVIP80M7Ad0P1@D502
03Ph>080?3`l0P0];Bd302@T9080>c/k0P0T92@201DE5@805aLG0P0E5AD3014A4@805ADE0P071`L2
00d=3@804A4A3@0;2`/3014A4@803@d=0P0Z:RX204U9B@80F5QH0P16ATH506e]K@80HF5Q0P1ADE42
06IVIP80DE5A0`1HF5P207AdM080Rh^;0P2PX:020:b/[080QXJ60`16ATH209RHV080/k>c0P1eMGD2
01LG5`801`L71@030`<2028R8P80KFe]0P0f=SH201DE5@<0:2PX0P0l?3`2079bLP80L71`0P1dM7@2
069RHP<0FUYJ0P16ATH20492@P80>c/k0P16ATH20451@@<0@T920P19BDT2055AD@80C4a<0P19BDT2
0492@P<0?clo0P1>CTh20492@PD0oooo0Ol000000004o`00003oool0oooo0?ooo`80<c<c0P12@T83
03lo?`80G5aL0P1TI6@206a/K080HV9R0P1VIVH303lo?`805ADE0P030`<200L71`80@D510P2VYZH3
08^;R`80DE5A100E5AD206ATI080Ti>C0`3@d=020:b/[080@T920P15ADD207inOP80Ti>C0`28R8P2
07YjNP80HF5Q0P1JFUX204i>CP80?3`l0`0h>3P203lo?`80<C4a0P0T92@4028R8P<0;Bd]0P0T92@2
028R8P800`<30P0;2`/200d=3@<04A4A100;2`/200L71`800`<30`0;2`/2014A4@80<c<c0P12@T82
071`L080GEeM0`1>CTh205iNGP80GEeM101HF5P205EEE@<0DE5A0P1HF5P207alO080Q8B40P2UYJD2
08^;R`<0ADE50P1RHV8208f=S@80ATI60P0=3@d200<30`<000000P030`<200L71`803@d=0P0E5AD2
03<c<`<0@T920P1>CTh205eMG@@0KFe]0P1JFUX305=CD`80?3`l0P16ATH2034a<@80BDU90P12@T83
03/k>`80C4a<0P0o?cl205YJFP80EEEE0P12@T8305EEE@80@T920P0o?cl50?ooo`7o000000001?l0
0000oooo0?ooo`3oool203<c<`80@T920`0o?cl205aLG080I6AT0P1/K6`2069RHP80IVIV0`0o?cl2
01DE5@800`<30P071`L20451@@80YZJV0`2;Rh/2055AD@@05ADE0P1TI6@209>CT`<0d=3@0P2/[:`2
0492@P80ADE50P1nOWh209>CT`<0R8R80P1jNWX2065QH@80FUYJ0P1>CTh203`l?0<0>3Ph0P0o?cl2
034a<@8092@T100R8R8302d];@8092@T0P0R8R8200<30`802`/;0P0=3@d3014A4@@02`/;0P071`L2
00<30`<02`/;0P0A4A4203<c<`80@T920P1`L70205eMG@<0CTi>0P1NGUh205eMG@@0F5QH0P1EEED3
055AD@80F5QH0P1lO7`208B4Q080YJFU0P2;Rh/304E5A@80HV9R0P2=SHd204I6AP803@d=0P030`<3
000000800`<30P071`L200d=3@805ADE0P0c<c<30492@P80CTi>0P1MGEd406e]K@80FUYJ0`1CDe<2
03`l?080ATI60P0a<C4204U9B@80@T920`0k>c/204a<C080?clo0P1JFUX205EEE@80@T920`1EEED2
0492@P80?clo1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0c<c<20492@P<0?clo0P1LG5`2
06ATI080K6a/0P1RHV8206IVIP<0?clo0P0E5AD200<30`801`L70P11@D420:JVYP<0Rh^;0P1ADE44
01DE5@80I6AT0P2CTi<30=3@d080[:b/0P12@T8204E5A@80OWin0P2CTi<308R8R080NWYj0P1QHF42
05YJFP80CTi>0P0l?3`303Ph>080?clo0P0a<C4202@T90@08R8R0`0];Bd202@T90808R8R0P030`<2
00/;2`803@d=0`0A4A4400/;2`801`L70P030`<300/;2`804A4A0P0c<c<20492@P80L71`0P1MGEd3
04i>CP80GUiN0P1MGEd405QHF080EEEE0`1ADE4205QHF080O7al0P24Q8@20:FUY@80Rh^;0`15ADD2
069RHP80SHf=0P16ATH200d=3@800`<30`00000200<30`801`L70P0=3@d201DE5@80<c<c0`12@T82
04i>CP80GEeM101]KFd205YJFP<0De=C0P0l?3`204I6AP80<C4a0P19BDT20492@P<0>c/k0P1<C4`2
03lo?`80FUYJ0P1EEED20492@P<0EEEE0P12@T8203lo?`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80CTi>0P0k>c/303<c<`80>c/k101@D50205EEE@80HV9R0`1JFUX204a<C080?3`l0P0];Bd2
01LG5`803@d=0`0E5AD2028R8P801`L70P030`<2000000800`<30`0Z:RX208^;R`80`<300P2XZ:P2
0451@@80De=C0`2VYZH209:BTP80QHF50P1LG5`204i>CP80DE5A0`1GEeL403Hf=P80;Bd]0P0Z:RX2
028R8P<092@T1P0Z:RX200L71`800`<30`071`L2014A4@T02`/;0P0=3@d2028R8P80<C4a0P0l?3`2
05eMG@<0FUYJ0P1GEeL207EeM@80HV9R0P1>CTh2051@D0<0CTi>0P1LG5`2075aL@80Rh^;0P2?Shl2
08^;R`<0?clo0P0a<C4206=SH`80@T920P0A4A4500<30`801`L70P0=3@d201DE5@80<C4a0P1<C4`3
05YJFP80F5QH0P1MGEd205YJFP80BDU90P1<C4`303Ph>080?clo0P0];Bd4034a<@L0?clo0P1>CTh2
04U9B@80ADE50P1EEED304U9B@80EeMG0P1EEED50?ooo`7o000000001?l00000oooo0?ooo`3oool2
04i>CP80>c/k0`0c<c<203/k>`@0D51@0P1EEED2069RHP<0FUYJ0P1<C4`203`l?080;Bd]0P0G5aL2
00d=3@<05ADE0P0R8R8200L71`800`<30P00000200<30`<0:RXZ0P2;Rh/20<30`080Z:RX0P11@D42
05=CD`<0YZJV0P2BTY8208F5Q@80G5aL0P1>CTh2055AD@<0EeMG100f=SH202d];@80:RXZ0P0R8R83
02@T90H0:RXZ0P071`L200<30`<01`L70P0A4A4900/;2`803@d=0P0R8R82034a<@80?3`l0P1MGEd3
05YJFP80EeMG0P1eMGD2069RHP80CTi>0P1@D50304i>CP80G5aL0P1aLG4208^;R`80Shn?0P2;Rh/3
03lo?`80<C4a0P1SHf<20492@P804A4A1@030`<200L71`803@d=0P0E5AD2034a<@80C4a<0`1JFUX2
05QHF080GEeM0P1JFUX204U9B@80C4a<0`0h>3P203lo?`80;Bd]100a<C4703lo?`80CTi>0P19BDT2
04E5A@80EEEE0`19BDT205MGE`80EEEE1@3oool1o`00000000Co00000?ooo`3oool0oooo0P19BDT2
05=CD`<0ADE50P0a<C420451@@80?clo0P0k>c/205=CD`<0CTi>0P19BDT205=CD`80EeMG0P1>CTh2
05=CD`<0<C4a0P0E5AD200/;2`801`L71`030`<200000080<C4a0P1SHf<207YjNP80MgMg0`0f=SH2
07IfMP80XZ:R0P2SXj<208J6QP80MWIf0`1CDe<203Ph>080?3`l0P0a<C4203Hf=P80;Bd]1`0T92@2
02d];@80:RXZ0P030`<5000000T02`/;0P071`L400/;2`808R8R0P0o?cl304a<C080DE5A0P1XJ6P2
069RHP80G5aL0P1GEeL3055AD@80D51@0P1gMgL2096AT@80TY:B0P29RHT3075aL@80>c/k0P12@T82
05eMG@80<c<c0P0Z:RX3028R8P80?3`l0P1EEED206e]K@80FUYJ0P1RHV8304a<C080DE5A0P12@T82
04i>CP80DE5A0P0l?3`303Ph>080;Bd]0P0a<C4202d];@80@T920P0k>c/303`l?080>c/k0P0f=SH2
04i>CP80?clo0P11@D4305MGE`80@T920P15ADD50?ooo`7o000000001?l00000oooo0?ooo`3oool2
04U9B@80De=C0`15ADD2034a<@80@D510P0o?cl203/k>`80De=C0`1>CTh204U9B@80De=C0P1GEeL2
04i>CP80De=C0`0a<C4201DE5@802`/;0P071`L700<30`8000000P0a<C4206=SH`80NWYj0P1gMgL3
03Hf=P80MWIf0P2RXZ820:>SX`80QXJ60P1fMWH305=CD`80>3Ph0P0l?3`2034a<@80=SHf0P0];Bd7
02@T9080;Bd]0P0Z:RX200<30`D000002@0;2`/200L71`@02`/;0P0R8R8203lo?`<0C4a<0P1ADE42
06QXJ080HV9R0P1LG5`205MGE`<0DE5A0P1@D50207MgM`80TI6A0P2BTY8208V9R@<0LG5a0P0k>c/2
0492@P80GEeM0P0c<c<202XZ:P<08R8R0P0l?3`205EEE@80KFe]0P1JFUX2069RHP<0C4a<0P1ADE42
0492@P80CTi>0P1ADE4203`l?0<0>3Ph0P0];Bd2034a<@80;Bd]0P12@T8203/k>`<0?3`l0P0k>c/2
03Hf=P80CTi>0P0o?cl20451@@<0EeMG0P12@T8204E5A@D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80>3Ph0P1@D50304I6AP80@D510P16ATH20451@@80?3`l0P0a<C4303lo?`80BDU90P1>CTh2
0492@P80BDU90P15ADD305MGE`80FUYJ0P12@T8203<c<`808R8R1@0A4A4200/;2`800`<30P0A4A42
04U9B@80FUYJ0`1[Jf/20451@@80D51@0P1jNWX208V9R@80RXZ:0`24Q8@2065QH@80BDU90P12@T82
02d];@L0:RXZ0P0K6a/2028R8P8092@T0P0a<C4300L71`H00`<31@0=3@d600L71`803@d=0P0G5aL3
04E5A@80DE5A0P1<C4`2069RHP80J6QX0P1HF5P305MGE`80BDU90P1ADE4206QXJ080LG5a0P24Q8@3
08R8R080G5aL0P0o?cl404U9B@L0>3Ph0P1RHV8206ATI080L71`0P1[Jf/305aLG080De=C0P0k>c/2
0492@P80BDU90P0o?cl303Ph>0@0;Bd]0P0Z:RX202d];@80=SHf0`0a<C42051@D080?3`l0P0h>3P2
05=CD`D0>c/k0P1GEeL2051@D0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80>3Ph0P1@D503
04I6AP80@D510P16ATH20451@@80?3`l0P0a<C4303lo?`80BDU90P1>CTh20492@P80BDU90P15ADD3
05MGE`80FUYJ0P12@T8203<c<`808R8R1@0A4A4200/;2`800`<30P0A4A4204U9B@80FUYJ0`1[Jf/2
0451@@80D51@0P1jNWX208V9R@80RXZ:0`24Q8@2065QH@80BDU90P12@T8202d];@L0:RXZ0P0K6a/2
028R8P8092@T0P0a<C4300L71`H00`<31@0=3@d600L71`803@d=0P0G5aL304E5A@80DE5A0P1<C4`2
069RHP80J6QX0P1HF5P305MGE`80BDU90P1ADE4206QXJ080LG5a0P24Q8@308R8R080G5aL0P0o?cl4
04U9B@L0>3Ph0P1RHV8206ATI080L71`0P1[Jf/305aLG080De=C0P0k>c/20492@P80BDU90P0o?cl3
03Ph>0@0;Bd]0P0Z:RX202d];@80=SHf0`0a<C42051@D080?3`l0P0h>3P205=CD`D0>c/k0P1GEeL2
051@D0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80>3Ph0P1@D50304I6AP80@D510P16ATH2
0451@@80?3`l0P0a<C4303lo?`80BDU90P1>CTh20492@P80BDU90P15ADD305MGE`80FUYJ0P12@T82
03<c<`808R8R1@0A4A4200/;2`800`<30P0A4A4204U9B@80FUYJ0`1[Jf/20451@@80D51@0P1jNWX2
08V9R@80RXZ:0`24Q8@2065QH@80BDU90P12@T8202d];@L0:RXZ0P0K6a/2028R8P8092@T0P0a<C43
00L71`H00`<31@0=3@d600L71`803@d=0P0G5aL304E5A@80DE5A0P1<C4`2069RHP80J6QX0P1HF5P3
05MGE`80BDU90P1ADE4206QXJ080LG5a0P24Q8@308R8R080G5aL0P0o?cl404U9B@L0>3Ph0P1RHV82
06ATI080L71`0P1[Jf/305aLG080De=C0P0k>c/20492@P80BDU90P0o?cl303Ph>0@0;Bd]0P0Z:RX2
02d];@80=SHf0`0a<C42051@D080?3`l0P0h>3P205=CD`D0>c/k0P1GEeL2051@D0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80BDU90P0o?cl3055AD@80D51@0P1ADE420492@P80@D510P0f=SH3
03`l?080<c<c0P0l?3`204U9B@80ATI60P0l?3`303/k>`80ADE50P1LG5`205MGE`80GUiN0P1CDe<3
05MGE`80>3Ph0P0R8R8201LG5`8092@T0P0f=SH3051@D080GEeM0P1XJ6P203lo?`80MWIf0P2:RXX3
07inOP80LG5a0P1MGEd20492@P80>c/k0P0f=SH302d];@80?3`l0P0T92@201/K6`804A4A0P0R8R83
034a<@@00`<31000000700/;2`801`L70P0;2`/201DE5@<0;Bd]0P1EEED4055AD@80J6QX0P1MGEd3
075aL@80K6a/0P1`L70206IVIP80DE5A0P1HF5P3055AD@80EeMG0P1@D5040451@@80F5QH0`1MGEd2
08V9R@80LW9b0P1VIVH2065QH@80I6AT0`1VIVH207AdM080GUiN0P1CDe<205iNGP80D51@0`11@D42
03Ph>0@0;Bd]0P0T92@203/k>`<0<c<c0P16ATH203lo?`80?3`l0P1HF5P2069RHP<0GUiN0P1GEeL2
04i>CPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80BDU90P0o?cl3055AD@80D51@0P1ADE42
0492@P80@D510P0f=SH303`l?080<c<c0P0l?3`204U9B@80ATI60P0l?3`303/k>`80ADE50P1LG5`2
05MGE`80GUiN0P1CDe<305MGE`80>3Ph0P0R8R8201LG5`8092@T0P0f=SH3051@D080GEeM0P1XJ6P2
03lo?`80MWIf0P2:RXX307inOP80LG5a0P1MGEd20492@P80>c/k0P0f=SH302d];@80?3`l0P0T92@2
01/K6`804A4A0P0R8R83034a<@@00`<31000000700/;2`801`L70P0;2`/201DE5@<0;Bd]0P1EEED4
055AD@80J6QX0P1MGEd3075aL@80K6a/0P1`L70206IVIP80DE5A0P1HF5P3055AD@80EeMG0P1@D504
0451@@80F5QH0`1MGEd208V9R@80LW9b0P1VIVH2065QH@80I6AT0`1VIVH207AdM080GUiN0P1CDe<2
05iNGP80D51@0`11@D4203Ph>0@0;Bd]0P0T92@203/k>`<0<c<c0P16ATH203lo?`80?3`l0P1HF5P2
069RHP<0GUiN0P1GEeL204i>CPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80ADE50P0l?3`3
05=CD`80EEEE0P1JFUX404E5A@80>3Ph0`0c<c<202PX:080=SHf0P0Z:RX203Hf=PD0CTi>0P19BDT2
04i>CP80D51@0P1GEeL205QHF0<0HF5Q0P1NGUh205aLG080De=C0P19BDT203Ph>0<0<C4a0P0c<c<4
04I6AP8092@T0P11@D4305=CD`80C4a<0P1QHF4205QHF080G5aL0P1CDe<303Ph>080:RXZ0P0c<c<2
02d];@805ADE0P0G5aL3028R8P8092@T0P030`<2000000800`<30`00000200<30`803@d=0P071`L2
00/;2`805ADE0`0Z:RX203/k>`@0F5QH0P1JFUX206IVIP<0GUiN0P1ADE4204U9B@80EeMG0P1VIVH2
06a/K0<0BDU90P11@D4203Ph>080BDU90P1EEED206][J`<0MgMg0P25QHD206a/K080Jf][0P1MGEd2
04U9B@<0Hf=S0P1XJ6P407AdM080Hf=S0P1GEeL3055AD@80BDU90P12@T8202XZ:P80<C4a0P0X:2P3
034a<@80?clo0P11@D4204I6AP80CTi>0P1<C4`306ATI080GEeM0P1CDe<50?ooo`7o000000001?l0
0000oooo0?ooo`3oool204E5A@80?3`l0`1CDe<205EEE@80FUYJ1015ADD203Ph>0<0<c<c0P0X:2P2
03Hf=P80:RXZ0P0f=SH504i>CP80BDU90P1>CTh2051@D080EeMG0P1HF5P3065QH@80GUiN0P1LG5`2
05=CD`80BDU90P0h>3P3034a<@80<c<c1016ATH202@T9080@D510`1CDe<204a<C080HF5Q0P1HF5P2
05aLG080De=C0`0h>3P202XZ:P80<c<c0P0];Bd201DE5@805aLG0`0R8R8202@T90800`<30P000002
00<30`<000000P030`<200d=3@801`L70P0;2`/201DE5@<0:RXZ0P0k>c/405QHF080FUYJ0P1VIVH3
05iNGP80DE5A0P19BDT205MGE`80IVIV0P1/K6`304U9B@80@D510P0h>3P204U9B@80EEEE0P1[Jf/3
07MgM`80QHF50P1/K6`206][J`80GEeM0P19BDT306=SH`80J6QX101dM7@206=SH`80EeMG0`1ADE42
04U9B@80@T920P0Z:RX2034a<@80:2PX0`0a<C4203lo?`80@D510P16ATH204i>CP80C4a<0`1TI6@2
05eMG@80De=C1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1@D50205YJFP<0GUiN0P1HF5P2
06][J`80GEeM0P15ADD20492@P<0<c<c0P0f=SH203Ph>080=SHf0P0T92@2034a<@<0ADE50P16ATH2
05QHF080GUiN0P1EEED205iNGP<0G5aL0P1EEED405YJFP80Hf=S0P1RHV8306e]K@80NWYj0P1NGUh2
04i>CP80?3`l0P0k>c/30451@@80DE5A0P1HF5P206IVIP80J6QX0P1>CTh303`l?080@D51100k>c/2
03<c<`D05aLG0P0K6a/202PX:0800`<32@00000200<30`@03@d=0`0A4A4203/k>`80G5aL0P1SHf<4
05aLG0D0HV9R0P1SHf<205YJFP80HF5Q0P1SHf<305aLG080LG5a0P1CDe<204i>CP80D51@0P1MGEd3
06IVIP80NGUi0P1fMWH205eMG@80FUYJ0P1XJ6P305EEE@80DE5A101SHf<2065QH@80EeMG0`1EEED2
06][J`80C4a<0P1>CTh203<c<`80;Bd]0`16ATH20451@@80?clo0P1ADE420451@@80ADE50`1<C4`2
06ATI080HF5Q1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1@D50205YJFP<0GUiN0P1HF5P2
06][J`80GEeM0P15ADD20492@P<0<c<c0P0f=SH203Ph>080=SHf0P0T92@2034a<@<0ADE50P16ATH2
05QHF080GUiN0P1EEED205iNGP<0G5aL0P1EEED405YJFP80Hf=S0P1RHV8306e]K@80NWYj0P1NGUh2
04i>CP80?3`l0P0k>c/30451@@80DE5A0P1HF5P206IVIP80J6QX0P1>CTh303`l?080@D51100k>c/2
03<c<`D05aLG0P0K6a/202PX:0800`<32@00000200<30`@03@d=0`0A4A4203/k>`80G5aL0P1SHf<4
05aLG0D0HV9R0P1SHf<205YJFP80HF5Q0P1SHf<305aLG080LG5a0P1CDe<204i>CP80D51@0P1MGEd3
06IVIP80NGUi0P1fMWH205eMG@80FUYJ0P1XJ6P305EEE@80DE5A101SHf<2065QH@80EeMG0`1EEED2
06][J`80C4a<0P1>CTh203<c<`80;Bd]0`16ATH20451@@80?clo0P1ADE420451@@80ADE50`1<C4`2
06ATI080HF5Q1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1SHf<205YJFPD0HF5Q0P1EEED2
075aL@80K6a/0P16ATH30492@P80<C4a100];Bd203lo?`80;Bd]0`0f=SH20492@P80EEEE0P1ADE42
05iNGP80Jf][0`1RHV8205EEE@80ATI60P1CDe<204i>CP80FUYJ0`1NGUh405MGE`80FUYJ0P1@D502
04a<C0<0ATI60P1@D50204U9B@80EEEE101JFUX3051@D080@D510P0k>c/203Ph>080?clo0P0c<c<5
01LG5`806a/K0P0];Bd200<30`<000000P030`<6000000802`/;0`071`L2014A4@80?clo0P1TI6@2
05iNGP80HV9R0`1TI6@2075aL@80HF5Q0P1NGUh206=SH`80HF5Q0`1aLG4206][J`80EeMG0P1>CTh2
05aLG080MgMg0`1NGUh206=SH`80F5QH0P1LG5`204a<C080D51@0`1LG5`205QHF080HF5Q0P1RHV82
06ATI080EEEE0`1HF5P2075aL@80MGEe1016ATH203<c<`<0?clo0P11@D4204U9B@H0ATI61@11@D42
069RHPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80Hf=S0P1JFUX5065QH@80EEEE0P1aLG42
06a/K080ATI60`12@T82034a<@@0;Bd]0P0o?cl202d];@<0=SHf0P12@T8205EEE@80DE5A0P1NGUh2
06][J`<0HV9R0P1EEED204I6AP80De=C0P1>CTh205YJFP<0GUiN101GEeL205YJFP80D51@0P1<C4`3
04I6AP80D51@0P19BDT205EEE@@0FUYJ0`1@D5020451@@80>c/k0P0h>3P203lo?`80<c<c1@0G5aL2
01/K6`80;Bd]0P030`<3000000800`<31P00000200/;2`<01`L70P0A4A4203lo?`80I6AT0P1NGUh2
069RHP<0I6AT0P1aLG42065QH@80GUiN0P1SHf<2065QH@<0LG5a0P1[Jf/205MGE`80CTi>0P1LG5`2
07MgM`<0GUiN0P1SHf<205QHF080G5aL0P1<C4`2051@D0<0G5aL0P1HF5P2065QH@80HV9R0P1TI6@2
05EEE@<0F5QH0P1aLG4207EeM@@0ATI60P0c<c<303lo?`80@D510P19BDT604I6APD0@D510P1RHV85
0?ooo`7o000000001?l00000oooo0?ooo`3oool206=SH`80FUYJ1@1QHF4205EEE@80LG5a0P1/K6`2
04I6AP<0@T920P0a<C4402d];@80?clo0P0];Bd303Hf=P80@T920P1EEED2055AD@80GUiN0P1[Jf/3
069RHP80EEEE0P16ATH205=CD`80CTi>0P1JFUX305iNGP@0EeMG0P1JFUX2051@D080C4a<0`16ATH2
051@D080BDU90P1EEED405YJFP<0D51@0P11@D4203/k>`80>3Ph0P0o?cl203<c<`D05aLG0P0K6a/2
02d];@800`<30`00000200<30`H000000P0;2`/300L71`804A4A0P0o?cl206ATI080GUiN0P1RHV83
06ATI080LG5a0P1QHF4205iNGP80Hf=S0P1QHF43075aL@80Jf][0P1GEeL204i>CP80G5aL0P1gMgL3
05iNGP80Hf=S0P1HF5P205aLG080C4a<0P1@D50305aLG080F5QH0P1QHF42069RHP80I6AT0P1EEED3
05QHF080LG5a0P1eMGD404I6AP80<c<c0`0o?cl20451@@80BDU91P16ATH50451@@80HV9R1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1>CTh206ATI0<0C4a<0P1RHV8204U9B@80DE5A0P1JFUX2
0492@P<0@D510P15ADD203<c<`80=SHf0P0h>3P203`l?0<0>c/k0P0o?cl204E5A@80I6AT0P1<C4`2
051@D0<0GUiN0P1XJ6P205aLG080De=C0P15ADD2051@D0<0@T920P19BDT204I6AP80C4a<0P1CDe<2
04i>CP<0F5QH0P1EEED404U9B@80>3Ph0P0f=SH303`l?080CTi>0P11@D4204U9B@80ATI60P0l?3`3
034a<@808R8R0P0K6a/2028R8P80:2PX0`030`<8000000800`<30`071`L2014A4@805aLG0P1@D502
05aLG080EEEE0`1ADE4205aLG080HF5Q0P1CDe<205MGE`80K6a/0`1<C4`204I6AP80FUYJ0P1NGUh2
05YJFP80GEeM0`1<C4`206ATI080EeMG0P1XJ6P2051@D0D0CTi>0P15ADD205QHF080L71`1024Q8@3
06=SH`80GUiN0P1SHf<207alO080FUYJ0P15ADD303Ph>0@0=SHf0P0k>c/204U9B@80ATI60`1<C4`2
0492@P80CTi>1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1>CTh206ATI0<0C4a<0P1RHV82
04U9B@80DE5A0P1JFUX20492@P<0@D510P15ADD203<c<`80=SHf0P0h>3P203`l?0<0>c/k0P0o?cl2
04E5A@80I6AT0P1<C4`2051@D0<0GUiN0P1XJ6P205aLG080De=C0P15ADD2051@D0<0@T920P19BDT2
04I6AP80C4a<0P1CDe<204i>CP<0F5QH0P1EEED404U9B@80>3Ph0P0f=SH303`l?080CTi>0P11@D42
04U9B@80ATI60P0l?3`3034a<@808R8R0P0K6a/2028R8P80:2PX0`030`<8000000800`<30`071`L2
014A4@805aLG0P1@D50205aLG080EEEE0`1ADE4205aLG080HF5Q0P1CDe<205MGE`80K6a/0`1<C4`2
04I6AP80FUYJ0P1NGUh205YJFP80GEeM0`1<C4`206ATI080EeMG0P1XJ6P2051@D0D0CTi>0P15ADD2
05QHF080L71`1024Q8@306=SH`80GUiN0P1SHf<207alO080FUYJ0P15ADD303Ph>0@0=SHf0P0k>c/2
04U9B@80ATI60`1<C4`20492@P80CTi>1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1@D502
055AD@<0I6AT0P1LG5`205iNGP80ADE5101GEeL304U9B@80?clo0P0h>3P202XZ:P@0@D510`15ADD2
03Ph>080ATI60P1@D50206e]K@80EeMG0`15ADD205=CD`80HV9R0P1HF5P2051@D080GUiN0`1@D502
04I6AP80@D510P19BDT203lo?`80De=C0`1<C4`203lo?`80ATI60P1@D50204I6AP80C4a<0`12@T82
04a<C080De=C0P11@D4204U9B@80ATI60`11@D4203/k>`80;Bd]0P0R8R8202@T90<0:2PX0P030`<8
000000<00`<30P071`L201DE5@80;Bd]0P19BDT205=CD`<0BDU90P1@D50204a<C080CTi>0P0o?cl2
04i>CPD0GUiN0P1GEeL205QHF080KFe]0P1aLG43079bLP80GUiN0P1HF5P2069RHP80De=C0P1@D503
05EEE@80F5QH0P1TI6@205MGE`80HF5Q0P1eMGD3065QH@80EeMG0P1`L7020861P@80L71`1@1CDe<2
03/k>`80@D510P16ATH2034a<@80=SHf0`15ADD205EEE@80CTi>1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1@D502055AD@<0I6AT0P1LG5`205iNGP80ADE5101GEeL304U9B@80?clo0P0h>3P2
02XZ:P@0@D510`15ADD203Ph>080ATI60P1@D50206e]K@80EeMG0`15ADD205=CD`80HV9R0P1HF5P2
051@D080GUiN0`1@D50204I6AP80@D510P19BDT203lo?`80De=C0`1<C4`203lo?`80ATI60P1@D502
04I6AP80C4a<0`12@T8204a<C080De=C0P11@D4204U9B@80ATI60`11@D4203/k>`80;Bd]0P0R8R82
02@T90<0:2PX0P030`<8000000<00`<30P071`L201DE5@80;Bd]0P19BDT205=CD`<0BDU90P1@D502
04a<C080CTi>0P0o?cl204i>CPD0GUiN0P1GEeL205QHF080KFe]0P1aLG43079bLP80GUiN0P1HF5P2
069RHP80De=C0P1@D50305EEE@80F5QH0P1TI6@205MGE`80HF5Q0P1eMGD3065QH@80EeMG0P1`L702
0861P@80L71`1@1CDe<203/k>`80@D510P16ATH2034a<@80=SHf0`15ADD205EEE@80CTi>1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1[Jf/2055AD@<0FUYJ0P1TI6@4079bLP80Hf=S0P1JFUX3
04U9B@80ATI60P1>CTh204E5A@80>c/k0P0h>3P30492@P@0?3`l0P1>CTh205QHF080L71`0`1LG5`2
04a<C080ATI60P1MGEd2055AD@80@T920`0k>c/203Ph>080?clo0P11@D4203Ph>080>c/k0`0f=SH2
03/k>`80ATI60P12@T8204U9B@80@D510`1>CTh2055AD@80FUYJ0P1ADE4404U9B@<0>c/k0P19BDT2
0492@P80<c<c1@0T92@202d];@/0000010030`<2014A4@80@T920P1>CTh304I6AP80BDU90P1GEeL2
051@D080ATI61@1@D50205eMG@80EeMG0P1MGEd206QXJ080M7Ad0`1fMWH205QHF080FUYJ0P1EEED2
065QH@80GEeM0`15ADD2051@D080Jf][0P1SHf<205YJFP80G5aL0`1[Jf/207AdM080I6AT0P1SHf<2
08B4Q080LG5a0`1QHF4204U9B@80EEEE0P16ATH40451@@<0<c<c0P0o?cl204i>CPD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80Jf][0P1ADE4305YJFP80I6AT101bLW8206=SH`80FUYJ0`19BDT2
04I6AP80CTi>0P15ADD203/k>`80>3Ph0`12@T8403`l?080CTi>0P1HF5P2071`L0<0G5aL0P1<C4`2
04I6AP80GEeM0P1ADE420492@P<0>c/k0P0h>3P203lo?`80@D510P0h>3P203/k>`<0=SHf0P0k>c/2
04I6AP80@T920P19BDT20451@@<0CTi>0P1ADE4205YJFP80DE5A1019BDT303/k>`80BDU90P12@T82
03<c<`D092@T0P0];Bd;000000@00`<30P0A4A420492@P80CTi>0`16ATH204U9B@80EeMG0P1@D502
04I6APD0D51@0P1MGEd205MGE`80GEeM0P1XJ6P207AdM0<0MWIf0P1HF5P205YJFP80EEEE0P1QHF42
05eMG@<0ADE50P1@D50206][J`80Hf=S0P1JFUX205aLG0<0Jf][0P1dM7@206ATI080Hf=S0P24Q8@2
075aL@<0HF5Q0P19BDT205EEE@80ATI61011@D4303<c<`80?clo0P1>CTh50?ooo`7o000000001?l0
0000oooo0?ooo`3oool206][J`80DE5A0`1JFUX206ATI0@0LW9b0P1SHf<205YJFP<0BDU90P16ATH2
04i>CP80ADE50P0k>c/203Ph>0<0@T92100l?3`204i>CP80F5QH0P1`L70305aLG080C4a<0P16ATH2
05eMG@80DE5A0P12@T8303/k>`80>3Ph0P0o?cl20451@@80>3Ph0P0k>c/303Hf=P80>c/k0P16ATH2
0492@P80BDU90P11@D4304i>CP80DE5A0P1JFUX2055AD@@0BDU90`0k>c/204U9B@80@T920P0c<c<5
02@T9080;Bd]2`00000400<30`804A4A0P12@T8204i>CP<0ATI60P19BDT205MGE`80D51@0P16ATH5
051@D080GEeM0P1GEeL205eMG@80J6QX0P1dM7@307IfMP80F5QH0P1JFUX205EEE@80HF5Q0P1MGEd3
04E5A@80D51@0P1[Jf/206=SH`80FUYJ0P1LG5`306][J`80M7Ad0P1TI6@206=SH`80Q8B40P1aLG43
065QH@80BDU90P1EEED204I6AP@0@D510`0c<c<203lo?`80CTi>1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1EEED2071`L0<0GUiN0P1ADE4205iNGP80K6a/0P1HF5P206IVIP<0DE5A0P1NGUh2
04E5A@80De=C0P16ATH204i>CP<0ADE50P1>CTh20492@P80ADE50P1MGEd206ATI0D0J6QX0P1RHV84
05eMG@80F5QH0`1MGEd204a<C080<c<c0P0l?3`203/k>`80?3`l1@12@T8203`l?080C4a<0P0l?3`5
04a<C0@0EEEE0P0l?3`203/k>`80@D510`16ATH204E5A@80D51@0P1>CTh204I6AP<0<C4a0P0G5aL2
02XZ:P/000000P030`<200L71`8092@T0P19BDT305MGE`80F5QH0P1GEeL205YJFP80F5QH0P1ADE45
05EEE@80GUiN0P11@D42055AD@80De=C0`1TI6@2075aL@80L71`0P1[Jf/205eMG@80EeMG0`1HF5P2
04i>CP80D51@0P1CDe<205MGE`80HF5Q0`1dM7@207moO`80MgMg0P1TI6@206][J`80Ogmo0`1iNGT2
05QHF080EEEE0P1MGEd204i>CP80?clo0`15ADD203lo?`80@D511@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1EEED2071`L0<0GUiN0P1ADE4205iNGP80K6a/0P1HF5P206IVIP<0DE5A0P1NGUh2
04E5A@80De=C0P16ATH204i>CP<0ADE50P1>CTh20492@P80ADE50P1MGEd206ATI0D0J6QX0P1RHV84
05eMG@80F5QH0`1MGEd204a<C080<c<c0P0l?3`203/k>`80?3`l1@12@T8203`l?080C4a<0P0l?3`5
04a<C0@0EEEE0P0l?3`203/k>`80@D510`16ATH204E5A@80D51@0P1>CTh204I6AP<0<C4a0P0G5aL2
02XZ:P/000000P030`<200L71`8092@T0P19BDT305MGE`80F5QH0P1GEeL205YJFP80F5QH0P1ADE45
05EEE@80GUiN0P11@D42055AD@80De=C0`1TI6@2075aL@80L71`0P1[Jf/205eMG@80EeMG0`1HF5P2
04i>CP80D51@0P1CDe<205MGE`80HF5Q0`1dM7@207moO`80MgMg0P1TI6@206][J`80Ogmo0`1iNGT2
05QHF080EEEE0P1MGEd204i>CP80?clo0`15ADD203lo?`80@D511@3oool1o`00000000Co00000?oo
o`3oool0oooo0P12@T8205MGE`<0EEEE0P1LG5`205MGE`80Jf][0P1lO7`2065QH@<0Hf=S0P1eMGD2
06=SH`80De=C0P15ADD203`l?0<0ATI60P12@T8203`l?080@T920P1@D50505=CD`80MgMg0P1JFUX2
06=SH`80J6QX0P1aLG4305iNGP80HV9R0P1EEED204a<C080?3`l1@0h>3P2051@D080@D51100o?cl2
0492@P<0?3`l0P0o?cl20492@P80@D510P0k>c/203lo?`<0ATI60P1@D502055AD@80C4a<0P15ADD3
0451@@80ADE50P0a<C4201DE5@/000000P030`<200L71`80>3Ph0`1ADE4205eMG@80K6a/0P1EEED2
04a<C080EEEE0`1@D50205=CD`80FUYJ0P1RHV8206=SH`80HF5Q0`1TI6@208B4Q080NGUi0P1aLG42
06QXJ080HF5Q0`1RHV8205iNGP80F5QH0P16ATH20451@@80D51@0`1HF5P205iNGP80MGEe0P1oOgl2
065QH@80M7Ad0`1iNGT20861P@80G5aL0P1ADE4205QHF080D51@1@1>CTh203lo?`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80@T920P1GEeL305EEE@80G5aL0P1GEeL206][J`80O7al0P1QHF43
06=SH`80MGEe0P1SHf<205=CD`80ADE50P0l?3`304I6AP80@T920P0l?3`20492@P80D51@1@1CDe<2
07MgM`80FUYJ0P1SHf<206QXJ080LG5a0`1NGUh2069RHP80EEEE0P1<C4`203`l?0D0>3Ph0P1@D502
0451@@@0?clo0P12@T8303`l?080?clo0P12@T820451@@80>c/k0P0o?cl304I6AP80D51@0P1ADE42
04a<C080ADE50`11@D4204E5A@80<C4a0P0E5AD;000000800`<30P071`L203Ph>0<0DE5A0P1MGEd2
06a/K080EEEE0P1<C4`205EEE@<0D51@0P1CDe<205YJFP80HV9R0P1SHf<2065QH@<0I6AT0P24Q8@2
07UiN@80LG5a0P1XJ6P2065QH@<0HV9R0P1NGUh205QHF080ATI60P11@D42051@D0<0F5QH0P1NGUh2
07EeM@80Ogmo0P1QHF4207AdM0<0NGUi0P21PH4205aLG080DE5A0P1HF5P2051@D0D0CTi>0P0o?cl5
0?ooo`7o000000001?l00000oooo0?ooo`3oool203lo?`80F5QH0`1/K6`2065QH@80L71`0P1]KFd2
05iNGP80MGEe0`1fMWH206][J`80QXJ60P1]KFd2051@D080@D510`16ATH40492@P80>3Ph0P0o?cl2
051@D0<0>c/k0P15ADD206e]K@80HV9R0P1>CTh204a<C0<0F5QH0P1@D50204a<C080ATI60P19BDT2
03Ph>0<0=SHf0P0c<c<203Ph>080>c/k0P0o?cl20492@P<0CTi>0P19BDT20492@P80ATI60P15ADD2
05YJFP<0DE5A0P19BDT20492@P80ATI60P0o?cl30451@@80ADE50P0f=SH203<c<`80?3`l2`000002
00<30`802`/;0`16ATH205iNGP80HV9R0P1`L70205aLG080D51@1@1JFUX205QHF080FUYJ0P12@T82
04U9B@<0F5QH0P1NGUh2075aL@80Q8B4101MGEd3055AD@80@D510P1<C4`205MGE`80LW9b0P1TI6@3
05YJFP80EeMG0P1JFUX208F5Q@80Vi^K0P1/K6`508R8R080MgMg0P1[Jf/204i>CP80I6AT0`1CDe<2
0492@P80F5QH1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0o?cl205QHF0<0K6a/0P1QHF42
071`L080KFe]0P1NGUh207EeM@<0MWIf0P1[Jf/208J6QP80KFe]0P1@D5020451@@<0ATI61012@T82
03Ph>080?clo0P1@D50303/k>`80ADE50P1]KFd2069RHP80CTi>0P1<C4`305QHF080D51@0P1<C4`2
04I6AP80BDU90P0h>3P303Hf=P80<c<c0P0h>3P203/k>`80?clo0P12@T8304i>CP80BDU90P12@T82
04I6AP80ADE50P1JFUX3055AD@80BDU90P12@T8204I6AP80?clo0`11@D4204E5A@80=SHf0P0c<c<2
03`l?0/000000P030`<200/;2`<0ATI60P1NGUh2069RHP80L71`0P1LG5`2051@D0D0FUYJ0P1HF5P2
05YJFP80@T920P19BDT305QHF080GUiN0P1aLG4208B4Q0@0GEeM0`1ADE420451@@80C4a<0P1GEeL2
079bLP80I6AT0`1JFUX205MGE`80FUYJ0P25QHD209^KV`80K6a/1@28R8P207MgM`80Jf][0P1>CTh2
06ATI0<0De=C0P12@T8205QHF0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80?clo0P1HF5P3
06a/K080HF5Q0P1`L70206e]K@80GUiN0P1eMGD307IfMP80Jf][0P26QXH206e]K@80D51@0P11@D43
04I6AP@0@T920P0h>3P203lo?`80D51@0`0k>c/204E5A@80KFe]0P1RHV8204i>CP80C4a<0`1HF5P2
051@D080C4a<0P16ATH204U9B@80>3Ph0`0f=SH203<c<`80>3Ph0P0k>c/203lo?`80@T920`1>CTh2
04U9B@80@T920P16ATH204E5A@80FUYJ0`1ADE4204U9B@80@T920P16ATH203lo?`<0@D510P15ADD2
03Hf=P80<c<c0P0l?3`;000000800`<30P0;2`/304I6AP80GUiN0P1RHV82071`L080G5aL0P1@D505
05YJFP80F5QH0P1JFUX20492@P80BDU90`1HF5P205iNGP80LG5a0P24Q8@405eMG@<0DE5A0P11@D42
04a<C080EeMG0P1bLW8206ATI0<0FUYJ0P1GEeL205YJFP80QHF50P2KVi/206a/K0D0R8R80P1gMgL2
06][J`80CTi>0P1TI6@305=CD`80@T920P1HF5P50?ooo`7o000000001?l00000oooo0?ooo`3oool2
05iNGP80IVIV0`1NGUh207EeM@80KFe]0P1bLW8208j>SP80L71`0`1/K6`208J6QP80HF5Q0P1[Jf/2
07EeM@80GUiN0`1@D5020492@P80C4a<0P0o?cl203`l?080CTi>0`16ATH205EEE@80ADE50P1QHF42
06a/K080EeMG1@1ADE4205=CD`@0C4a<0P1>CTh303/k>`80?clo0P0l?3`202d];@80:RXZ0P0f=SH3
04E5A@80=SHf0P0h>3P20451@@@0?3`l0`0f=SH204I6AP80ADE50P11@D4203`l?0<0CTi>0P0l?3`2
04U9B@80ATI60P1<C4`20451@@T000000P030`<200L71`<08R8R0P1>CTh206][J`80EEEE0P1JFUX2
05MGE`<0De=C0P1QHF42055AD@80BDU90P0o?cl20492@P<0ATI60P1>CTh205iNGP80EeMG0P1EEED2
04a<C0<0@T920P1HF5P20492@P80CTi>0P1JFUX206IVIP<0F5QH0P1JFUX206=SH`80P8200P2?Shl2
08Z:RP<0MGEe0P1XJ6P206=SH`80GEeM0P1NGUh206IVIP<0LW9b0P1TI6@2055AD@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80GUiN0P1VIVH305iNGP80MGEe0P1]KFd2079bLP80SXj>0P1`L703
06a/K080QXJ60P1QHF4206][J`80MGEe0P1NGUh3051@D080@T920P1<C4`203lo?`80?3`l0P1>CTh3
04I6AP80EEEE0P15ADD2065QH@80K6a/0P1GEeL5055AD@80De=C101<C4`204i>CP<0>c/k0P0o?cl2
03`l?080;Bd]0P0Z:RX203Hf=P<0ADE50P0f=SH203Ph>080@D51100l?3`303Hf=P80ATI60P15ADD2
0451@@80?3`l0`1>CTh203`l?080BDU90P16ATH204a<C080@D512@00000200<30`801`L70`0R8R82
04i>CP80Jf][0P1EEED205YJFP80EeMG0`1CDe<2065QH@80DE5A0P19BDT203lo?`80@T920`16ATH2
04i>CP80GUiN0P1GEeL205EEE@80C4a<0`12@T8205QHF080@T920P1>CTh205YJFP80IVIV0`1HF5P2
05YJFP80Hf=S0P20P80208n?S`80RXZ:0`1eMGD206QXJ080Hf=S0P1MGEd205iNGP80IVIV0`1bLW82
06ATI080DE5A1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1HF5P205MGE`<0GUiN0P1aLG44
06IVIP80I6AT0P21PH4307alO080Ogmo0P2QXJ4206a/K080EEEE0P1SHf<3069RHP80EeMG0P19BDT2
055AD@80D51@0P12@T8504U9B@80EEEE0P0o?cl205QHF080D51@0`1LG5`205YJFP80KFe]0P1<C4`2
04i>CP80EeMG0`1HF5P205YJFP80@D510P0o?cl203Ph>080;Bd]0`0a<C4203Hf=P@0:RXZ0P0];Bd2
03Ph>0<0?3`l0P0a<C4202d];@80<c<c0P0];Bd303Ph>080@D510P0l?3`20492@P80BDU90P1ADE43
04U9B@800`<32000000300d=3@80@T920P1EEED204i>CP80GEeM0P1EEED304a<C080De=C0P1JFUX2
04E5A@80?clo0P19BDT503Hf=P80?3`l0P12@T82051@D0D0C4a<0P12@T8204U9B@80C4a<0P16ATH2
04a<C0<0De=C0P1>CTh205eMG@80M7Ad0P2PX:0209JFUP<0LW9b0P1MGEd205MGE`80C4a<0P19BDT2
05YJFP<0I6AT0P1SHf<2065QH@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80F5QH0P1GEeL3
05iNGP80LG5a101VIVH206ATI080PH610`1lO7`207moO`80XJ6Q0P1/K6`205EEE@80Hf=S0`1RHV82
05MGE`80BDU90P1ADE42051@D080@T921@19BDT205EEE@80?clo0P1HF5P2051@D0<0G5aL0P1JFUX2
06e]K@80C4a<0P1>CTh205MGE`<0F5QH0P1JFUX20451@@80?clo0P0h>3P202d];@<0<C4a0P0f=SH4
02XZ:P80;Bd]0P0h>3P303`l?080<C4a0P0];Bd203<c<`80;Bd]0`0h>3P20451@@80?3`l0P12@T82
04U9B@80DE5A0`19BDT200<30`P000000`0=3@d20492@P80EEEE0P1>CTh205eMG@80EEEE0`1<C4`2
05=CD`80FUYJ0P15ADD203lo?`80BDU91@0f=SH203`l?080@T920P1@D50504a<C080@T920P19BDT2
04a<C080ATI60P1<C4`305=CD`80CTi>0P1MGEd207AdM080X:2P0P2FUYH3079bLP80GEeM0P1GEeL2
04a<C080BDU90P1JFUX306ATI080Hf=S0P1QHF450?ooo`7o000000001?l00000oooo0?ooo`3oool2
06ATI080EeMG0`1aLG4206=SH`80FUYJ0P1XJ6P205aLG080LG5a0`1eMGD20861P@80Q8B40P2GUiL2
079bLP80FUYJ0`1]KFd206=SH`80HF5Q0P0h>3P205eMG@80ADE50`1LG5`204E5A@80F5QH0P1ADE42
04E5A@D0C4a<0P1JFUX2055AD@80HF5Q0P1LG5`204I6AP<0ADE50P1ADE42051@D080G5aL0P1@D502
0492@PL0=SHf0P0T92@202d];@80<C4a0`0];Bd203<c<`80@T920P1@D5020451@@<0BDU90P1<C4`2
03Hf=P80>3Ph0P0a<C4203Hf=P<0>c/k0P0c<c<8000000<00`<30P0A4A4203`l?080D51@101HF5P5
0492@P80?3`l0P1@D5020492@P80>3Ph1@12@T8204I6AP80D51@0P1EEED204U9B@<0D51@0P1QHF42
051@D080EEEE0P1GEeL504E5A@80@D510P1QHF4208Z:RP80Q8B40P25QHD307inOP80Jf][0P16ATH2
04a<C080?3`l0P12@T8304U9B@80De=C0P1GEeL50?ooo`7o000000001?l00000oooo0?ooo`3oool2
06ATI080EeMG0`1aLG4206=SH`80FUYJ0P1XJ6P205aLG080LG5a0`1eMGD20861P@80Q8B40P2GUiL2
079bLP80FUYJ0`1]KFd206=SH`80HF5Q0P0h>3P205eMG@80ADE50`1LG5`204E5A@80F5QH0P1ADE42
04E5A@D0C4a<0P1JFUX2055AD@80HF5Q0P1LG5`204I6AP<0ADE50P1ADE42051@D080G5aL0P1@D502
0492@PL0=SHf0P0T92@202d];@80<C4a0`0];Bd203<c<`80@T920P1@D5020451@@<0BDU90P1<C4`2
03Hf=P80>3Ph0P0a<C4203Hf=P<0>c/k0P0c<c<8000000<00`<30P0A4A4203`l?080D51@101HF5P5
0492@P80?3`l0P1@D5020492@P80>3Ph1@12@T8204I6AP80D51@0P1EEED204U9B@<0D51@0P1QHF42
051@D080EEEE0P1GEeL504E5A@80@D510P1QHF4208Z:RP80Q8B40P25QHD307inOP80Jf][0P16ATH2
04a<C080?3`l0P12@T8304U9B@80De=C0P1GEeL50?ooo`7o000000001?l00000oooo0?ooo`3oool2
06ATI080EeMG0`1aLG4206=SH`80FUYJ0P1XJ6P205aLG080LG5a0`1eMGD20861P@80Q8B40P2GUiL2
079bLP80FUYJ0`1]KFd206=SH`80HF5Q0P0h>3P205eMG@80ADE50`1LG5`204E5A@80F5QH0P1ADE42
04E5A@D0C4a<0P1JFUX2055AD@80HF5Q0P1LG5`204I6AP<0ADE50P1ADE42051@D080G5aL0P1@D502
0492@PL0=SHf0P0T92@202d];@80<C4a0`0];Bd203<c<`80@T920P1@D5020451@@<0BDU90P1<C4`2
03Hf=P80>3Ph0P0a<C4203Hf=P<0>c/k0P0c<c<8000000<00`<30P0A4A4203`l?080D51@101HF5P5
0492@P80?3`l0P1@D5020492@P80>3Ph1@12@T8204I6AP80D51@0P1EEED204U9B@<0D51@0P1QHF42
051@D080EEEE0P1GEeL504E5A@80@D510P1QHF4208Z:RP80Q8B40P25QHD307inOP80Jf][0P16ATH2
04a<C080?3`l0P12@T8304U9B@80De=C0P1GEeL50?ooo`7o000000001?l00000oooo0?ooo`3oool4
04a<C0D0GEeM0P1GEeL205iNGP80MGEe0P1aLG4309JFUP80Ogmo0P2HV9P209JFUP80Shn?0P2:RXX3
06ATI080Ogmo0P1lO7`206e]K@80EeMG0P1NGUh305eMG@80EeMG0P1EEED204a<C080De=C0P11@D43
04i>CP80D51@0P1CDe<205MGE`@0CTi>0`1QHF4204U9B@80D51@0P15ADD20492@P80C4a<1`0h>3P2
03/k>`80@T920P0h>3P30451@@80@T920P15ADD20492@P80?3`l0`0k>c/203<c<`80>c/k0P15ADD2
04U9B@80CTi>1`11@D42000000800`<31@00000200<30`80<c<c0P1MGEd205YJFP80CTi>0`1ADE42
04E5A@80@T92100l?3`203<c<`<0<C4a0P0k>c/204I6AP80BDU9101MGEd304I6AP80C4a<0P1NGUh2
05EEE@80ADE50P1>CTh305EEE@@0EeMG0P1HF5P207EeM@80Ogmo0`1aLG4206=SH`80C4a<0P16ATH2
03lo?`80>3Ph1@11@D4205iNGPD0oooo0Ol000000004o`00003oool0oooo0?ooo`@0C4a<1@1MGEd2
05MGE`80GUiN0P1eMGD2075aL@<0UYJF0P1oOgl209RHV080UYJF0P2?Shl208Z:RP<0I6AT0P1oOgl2
07alO080KFe]0P1GEeL205iNGP<0GEeM0P1GEeL205EEE@80C4a<0P1CDe<20451@@<0CTi>0P1@D502
05=CD`80EeMG101>CTh3065QH@80BDU90P1@D50204E5A@80@T920P1<C4`703Ph>080>c/k0P12@T82
03Ph>0<0@D510P12@T8204E5A@80@T920P0l?3`303/k>`80<c<c0P0k>c/204E5A@80BDU90P1>CTh7
0451@@8000000P030`<5000000800`<30P0c<c<205eMG@80FUYJ0P1>CTh3055AD@80ADE50P12@T84
03`l?080<c<c0`0a<C4203/k>`80ATI60P19BDT405eMG@<0ATI60P1<C4`205iNGP80EEEE0P15ADD2
04i>CP<0EEEE101GEeL205QHF080MGEe0P1oOgl3075aL@80Hf=S0P1<C4`204I6AP80?clo0P0h>3P5
0451@@80GUiN1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1HF5P205aLG0<0HF5Q0P1HF5P2
05YJFP80GEeM0P1RHV8208J6QP<0LG5a0P2KVi/209fMW@80RXZ:0P2`/;020:FUY@<0WIfM0P1nOWh2
079bLP80MWIf0P1RHV8205iNGP<0EeMG0P1MGEd206=SH`80F5QH0P1ADE4205EEE@<0@T920P0o?cl2
04U9B@80=SHf0P1<C4`203lo?`<0DE5A0P1NGUh404I6AP80EeMG0P19BDT303`l?0@0=SHf0P0];Bd2
03Hf=PD0>c/k100l?3`2034a<@80<c<c0`0h>3P2034a<@80;Bd]0P0l?3`203Hf=P80?3`l0`15ADD2
0451@@80?3`l0P0c<c<7000000800`<30P071`L203`l?080Jf][0P1TI6@305iNGP80L71`0P1aLG42
05MGE`@0BDU90`0a<C4403Ph>080>c/k0P0o?cl20492@P<0?clo0P11@D4204I6AP80CTi>0P1CDe<2
051@D0<0F5QH0P1NGUh205=CD`80FUYJ0P1/K6`207UiN@<0LG5a0P1QHF4204i>CP80?clo0P16ATH2
034a<@<0=SHf0P12@T8204a<C0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80F5QH0P1LG5`3
065QH@80F5QH0P1JFUX205eMG@80HV9R0P26QXH3075aL@80Vi^K0P2MWId208Z:RP80/;2`0P2UYJD3
09fMW@80OWin0P1bLW8207IfMP80HV9R0P1NGUh305MGE`80GEeM0P1SHf<205QHF080DE5A0P1EEED3
0492@P80?clo0P19BDT203Hf=P80C4a<0P0o?cl3055AD@80GUiN1016ATH205MGE`80BDU90`0l?3`4
03Hf=P80;Bd]0P0f=SH503/k>`@0?3`l0P0a<C4203<c<`<0>3Ph0P0a<C4202d];@80?3`l0P0f=SH2
03`l?0<0ADE50P11@D4203`l?080<c<c1`00000200<30`801`L70P0l?3`206][J`80I6AT0`1NGUh2
071`L080LG5a0P1GEeL404U9B@<0<C4a100h>3P203/k>`80?clo0P12@T8303lo?`80@D510P16ATH2
04i>CP80De=C0P1@D50305QHF080GUiN0P1CDe<205YJFP80K6a/0P1iNGT3075aL@80HF5Q0P1>CTh2
03lo?`80ATI60P0a<C4303Hf=P80@T920P1<C4`50?ooo`7o000000001?l00000oooo0?ooo`3oool2
04E5A@80BDU90`1NGUh207YjNP80HF5Q0P1TI6@2075aL@80I6AT0`1fMWH20861P@80W9bL0P2ZZZX2
08j>SP80W9bL0`2^[Zh20:6QX@80QXJ60P20P80207YjNP80HF5Q0`1bLW8205iNGP80Jf][0P1]KFd4
05eMG@<0CTi>0P16ATH203lo?`80?3`l0P0c<c<203Ph>0<0<C4a0P0h>3P604a<C080EeMG0`1EEED2
04I6AP80>c/k0P0a<C4203Ph>080;Bd]0`0c<c<202@T9080;Bd]0P0h>3P702d];@80<c<c0P0h>3P2
03lo?`80@T920`0k>c/203Hf=P8092@T0P0];Bd203<c<`L000000P030`<200/;2`80ADE50P1bLW83
06a/K080KFe]0P1MGEd205MGE`80De=C0P0l?3`3034a<@80>c/k0P0f=SH20492@P80=SHf0P11@D43
04U9B@80?clo0P0h>3P203`l?080>3Ph0P0f=SH30492@P80ADE5101@D50206ATI080LG5a0`1bLW82
06IVIP80G5aL0P0h>3P20492@P80<c<c0`0h>3P203lo?`80@D511@3oool1o`00000000Co00000?oo
o`3oool0oooo0P15ADD204U9B@<0GUiN0P1jNWX2065QH@80I6AT0P1aLG4206ATI0<0MWIf0P21PH42
09bLW080ZZZZ0P2>SXh209bLW0<0[Zj^0P2QXJ4208J6QP80P8200P1jNWX2065QH@<0LW9b0P1NGUh2
06][J`80KFe]101MGEd304i>CP80ATI60P0o?cl203`l?080<c<c0P0h>3P3034a<@80>3Ph1P1<C4`2
05MGE`<0EEEE0P16ATH203/k>`80<C4a0P0h>3P202d];@<0<c<c0P0T92@202d];@80>3Ph1`0];Bd2
03<c<`80>3Ph0P0o?cl20492@P<0>c/k0P0f=SH202@T9080;Bd]0P0c<c<7000000800`<30P0;2`/2
04E5A@80LW9b0`1/K6`206e]K@80GEeM0P1GEeL205=CD`80?3`l0`0a<C4203/k>`80=SHf0P12@T82
03Hf=P80@D510`19BDT203lo?`80>3Ph0P0l?3`203Ph>080=SHf0`12@T8204E5A@@0D51@0P1TI6@2
075aL@<0LW9b0P1VIVH205aLG080>3Ph0P12@T8203<c<`<0>3Ph0P0o?cl20451@@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80ADE50P19BDT305iNGP80NWYj0P1QHF4206ATI080LG5a0P1TI6@3
07IfMP80PH610P2LW9`20:ZZZP80SXj>0P2LW9`30:j^[P80XJ6Q0P26QXH20820P080NWYj0P1QHF43
079bLP80GUiN0P1[Jf/206e]K@@0GEeM0`1>CTh204I6AP80?clo0P0l?3`203<c<`80>3Ph0`0a<C42
03Ph>0H0C4a<0P1GEeL305EEE@80ATI60P0k>c/2034a<@80>3Ph0P0];Bd303<c<`8092@T0P0];Bd2
03Ph>0L0;Bd]0P0c<c<203Ph>080?clo0P12@T8303/k>`80=SHf0P0T92@202d];@80<c<c1`000002
00<30`802`/;0P15ADD2079bLP<0K6a/0P1]KFd205eMG@80EeMG0P1CDe<203`l?0<0<C4a0P0k>c/2
03Hf=P80@T920P0f=SH20451@@<0BDU90P0o?cl203Ph>080?3`l0P0h>3P203Hf=P<0@T920P15ADD4
051@D080I6AT0P1aLG43079bLP80IVIV0P1LG5`203Ph>080@T920P0c<c<303Ph>080?clo0P11@D45
0?ooo`7o000000001?l00000oooo0?ooo`3oool203Ph>080:RXZ0`15ADD205EEE@80QXJ60P2>SXh2
069RHP80L71`0`20P80208f=S@80V9RH0P2PX:020;Bd]080W9bL0`2SXj<208Z:RP80XZ:R0P2[Zj/2
08J6QP80M7Ad0`1[Jf/208Z:RP80OWin0P1bLW8207EeM@80J6QX0`1JFUX204i>CP80ADE50P11@D42
03Ph>0808R8R0`0c<c<203Ph>080?3`l0P0h>3P203`l?080>c/k0`11@D42051@D080@D510P0o?cl2
03/k>`80?clo0`0a<C4202XZ:P808R8R0P0K6a/2028R8P<0>3Ph0P0X:2P202@T9080:2PX0P0];Bd2
034a<@D0<c<c0P0k>c/203Hf=P8092@T0P0c<c<7000000801`L70P0G5aL2069RHP<0K6a/0P1LG5`2
05=CD`80D51@0P1ADE4203lo?`<0<c<c0P1<C4`204E5A@80ATI60P1<C4`205=CD`<0DE5A0P19BDT2
04a<C080=SHf0P16ATH203Hf=P<0>3Ph0P16ATH205MGE`80DE5A0P1CDe<2065QH@D0IVIV0P1]KFd2
05eMG@80@T920P0o?cl503<c<`80=SHf1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0h>3P2
02XZ:P<0ADE50P1EEED208J6QP80SXj>0P1RHV82071`L0<0P8200P2=SHd209RHV080X:2P0P2d];@2
09bLW0<0Xj>S0P2:RXX20::RXP80Zj^[0P26QXH207AdM0<0Jf][0P2:RXX207inOP80LW9b0P1eMGD2
06QXJ0<0FUYJ0P1>CTh204E5A@80@D510P0h>3P2028R8P<0<c<c0P0h>3P203`l?080>3Ph0P0l?3`2
03/k>`<0@D510P1@D5020451@@80?clo0P0k>c/203lo?`<0<C4a0P0Z:RX2028R8P806a/K0P0R8R83
03Ph>080:2PX0P0T92@202PX:080;Bd]0P0a<C4503<c<`80>c/k0P0f=SH202@T9080<c<c1`000002
00L71`805aLG0P1RHV8306a/K080G5aL0P1CDe<2051@D080DE5A0P0o?cl303<c<`80C4a<0P15ADD2
04I6AP80C4a<0P1CDe<3055AD@80BDU90P1<C4`203Hf=P80ATI60P0f=SH303Ph>080ATI60P1GEeL2
055AD@80De=C0P1QHF4506IVIP80KFe]0P1MGEd20492@P80?clo1@0c<c<203Hf=PD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80<C4a0P0k>c/304E5A@80C4a<0P1ADE4207AdM080TY:B0P1iNGT3
08^;R`80MgMg0P24Q8@20:b/[080/K6a0P2c/k<309NGU`80U9BD0P2NWYh208^;R`80Zj^[0P2=SHd3
07MgM`80OWin0P20P80207alO080Shn?0P1jNWX305eMG@80D51@0P1QHF4204a<C080>c/k0P0c<c<3
01/K6`80<c<c0P0k>c/20492@P80<c<c0P0o?cl303/k>`80?3`l0P1<C4`203/k>`80:RXZ1@0a<C42
03/k>`8092@T0P0f=SH2028R8P<0:2PX0P0R8R8203<c<`80;Bd]0P0X:2P202XZ:P<0:2PX0P0a<C44
03Ph>080>c/k0P16ATH3034a<@@000000P030`<200L71`808R8R0`1LG5`205eMG@80DE5A0P1>CTh2
0492@P80>c/k0`16ATH204E5A@@0@D510P1>CTh205EEE@D0?clo0P11@D4203<c<`L0?clo0P0l?3`2
0492@P80C4a<0P1NGUh504U9B@80EEEE0P1HF5P2055AD@80FUYJ0P1@D50303`l?080<C4a0P0f=SH5
0?ooo`7o000000001?l00000oooo0?ooo`3oool2034a<@80>c/k0`15ADD204a<C080DE5A0P1dM7@2
09:BTP80NGUi0`2;Rh/207MgM`80Q8B40P2/[:`20;6a/@80/k>c0`2GUiL209BDU080WYjN0P2;Rh/2
0:^[Z`80SHf=0`1gMgL207inOP80P8200P1lO7`208n?S`80NWYj0`1MGEd2051@D080HF5Q0P1<C4`2
03/k>`80<c<c0`0K6a/203<c<`80>c/k0P12@T8203<c<`80?clo0`0k>c/203`l?080C4a<0P0k>c/2
02XZ:PD0<C4a0P0k>c/202@T9080=SHf0P0R8R8302PX:0808R8R0P0c<c<202d];@80:2PX0P0Z:RX3
02PX:080<C4a100h>3P203/k>`80ATI60`0a<C44000000800`<30P071`L2028R8P<0G5aL0P1MGEd2
055AD@80CTi>0P12@T8203/k>`<0ATI60P15ADD40451@@80CTi>0P1EEED503lo?`80@D510P0c<c<7
03lo?`80?3`l0P12@T8204a<C080GUiN1@19BDT205EEE@80F5QH0P1ADE4205YJFP80D51@0`0l?3`2
034a<@80=SHf1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0c<c<204I6AP<0ADE5100h>3P2
05YJFP80GUiN0P2DU9@30;Rh^080_[jn0P26QXH207IfMP80X:2P0P2CTi<309JFUP80Shn?0P29RHT2
09NGU`80Ogmo0P2VYZH508R8R080UYJF0P24Q8@208V9R@80SXj>0`20P80206a/K080GEeM0P1QHF42
03`l?0L0<C4a0P0c<c<203lo?`80>c/k0P0Z:RX302d];@80?3`l0P0a<C4403/k>`8092@T0`0X:2P2
028R8P80;Bd]0P0T92@202XZ:P<08R8R0P0X:2P201/K6`@08R8R0P0T92@302PX:0808R8R0P0X:2P2
03Ph>080=SHf1@0k>c/20492@P@000000P030`<200/;2`<04A4A0P0o?cl2069RHP80F5QH0P0l?3`2
0451@@<0ADE50P0k>c/203<c<`80>c/k100o?cl303Ph>080:2PX0P0a<C4202d];@80<c<c0P0l?3`3
034a<@@0@D510P0f=SH20451@@80De=C1@1<C4`20451@@80CTi>0P11@D4204i>CP<0De=C0P0o?cl2
02XZ:PD0oooo0Ol000000004o`00003oool0oooo0?ooo`80<c<c0P16ATH304E5A@@0>3Ph0P1JFUX2
05iNGP80U9BD0`2h^;P20;jn_P80QXJ60P1fMWH20:2PX080Ti>C0`2FUYH208n?S`80RHV90P2GUiL2
07moO`80YZJV1@28R8P209JFUP80Q8B40P29RHT208j>SP<0P8200P1/K6`205eMG@80HF5Q0P0l?3`7
034a<@80<c<c0P0o?cl203/k>`80:RXZ0`0];Bd203`l?080<C4a100k>c/202@T90<0:2PX0P0R8R82
02d];@8092@T0P0Z:RX3028R8P80:2PX0P0K6a/4028R8P8092@T0`0X:2P2028R8P80:2PX0P0h>3P2
03Hf=PD0>c/k0P12@T84000000800`<30P0;2`/3014A4@80?clo0P1RHV8205QHF080?3`l0P11@D43
04E5A@80>c/k0P0c<c<203/k>`@0?clo0`0h>3P202PX:080<C4a0P0];Bd203<c<`80?3`l0`0a<C44
0451@@80=SHf0P11@D4205=CD`D0C4a<0P11@D4204i>CP80@D510P1>CTh305=CD`80?clo0P0Z:RX5
0?ooo`7o000000001?l00000oooo0?ooo`3oool203`l?080<c<c0`0a<C4204a<C080>3Ph0P11@D42
04I6AP80Jf][0`21PH420;Fe]@80alO70P2CTi<2071`L080TY:B0`1iNGT206a/K080SXj>0P20P802
09:BTP80PH610`2DU9@208^;R`80MWIf0P2KVi/20:b/[080YZJV0`2DU9@208Z:RP80MgMg0P1GEeL2
05EEE@80?clo0`0c<c<20451@@80<C4a0P0l?3`202d];@80<C4a1@0h>3P203<c<`80;Bd]0P0l?3`2
02d];@<0:2PX100R8R8201DE5@D05aLG0P0R8R8201LG5`8092@T0P0G5aL201/K6`<092@T0P0K6a/2
028R8P80:2PX0P0E5AD202PX:0<0;Bd]0P0a<C4202d];@8000000P030`<2000000<00`<30P0=3@d2
02@T9080D51@0P1EEED204I6AP<0@T920P0h>3P2034a<@80@D510P0o?cl203`l?0<0?clo0P0f=SH2
034a<@80>3Ph0P1>CTh203`l?0<0=SHf0P0k>c/203<c<`@0;Bd]0P0a<C4304I6AP80CTi>0P1<C4`2
0451@@80D51@0P0k>c/304a<C080CTi>0P0k>c/50?ooo`7o000000001?l00000oooo0?ooo`3oool2
03`l?080<c<c0`0a<C4204a<C080>3Ph0P11@D4204I6AP80Jf][0`21PH420;Fe]@80alO70P2CTi<2
071`L080TY:B0`1iNGT206a/K080SXj>0P20P80209:BTP80PH610`2DU9@208^;R`80MWIf0P2KVi/2
0:b/[080YZJV0`2DU9@208Z:RP80MgMg0P1GEeL205EEE@80?clo0`0c<c<20451@@80<C4a0P0l?3`2
02d];@80<C4a1@0h>3P203<c<`80;Bd]0P0l?3`202d];@<0:2PX100R8R8201DE5@D05aLG0P0R8R82
01LG5`8092@T0P0G5aL201/K6`<092@T0P0K6a/2028R8P80:2PX0P0E5AD202PX:0<0;Bd]0P0a<C42
02d];@8000000P030`<2000000<00`<30P0=3@d202@T9080D51@0P1EEED204I6AP<0@T920P0h>3P2
034a<@80@D510P0o?cl203`l?0<0?clo0P0f=SH2034a<@80>3Ph0P1>CTh203`l?0<0=SHf0P0k>c/2
03<c<`@0;Bd]0P0a<C4304I6AP80CTi>0P1<C4`20451@@80D51@0P0k>c/304a<C080CTi>0P0k>c/5
0?ooo`7o000000001?l00000oooo0?ooo`3oool203`l?080<c<c0`0a<C4204a<C080>3Ph0P11@D42
04I6AP80Jf][0`21PH420;Fe]@80alO70P2CTi<2071`L080TY:B0`1iNGT206a/K080SXj>0P20P802
09:BTP80PH610`2DU9@208^;R`80MWIf0P2KVi/20:b/[080YZJV0`2DU9@208Z:RP80MgMg0P1GEeL2
05EEE@80?clo0`0c<c<20451@@80<C4a0P0l?3`202d];@80<C4a1@0h>3P203<c<`80;Bd]0P0l?3`2
02d];@<0:2PX100R8R8201DE5@D05aLG0P0R8R8201LG5`8092@T0P0G5aL201/K6`<092@T0P0K6a/2
028R8P80:2PX0P0E5AD202PX:0<0;Bd]0P0a<C4202d];@8000000P030`<2000000<00`<30P0=3@d2
02@T9080D51@0P1EEED204I6AP<0@T920P0h>3P2034a<@80@D510P0o?cl203`l?0<0?clo0P0f=SH2
034a<@80>3Ph0P1>CTh203`l?0<0=SHf0P0k>c/203<c<`@0;Bd]0P0a<C4304I6AP80CTi>0P1<C4`2
0451@@80D51@0P0k>c/304a<C080CTi>0P0k>c/50?ooo`7o000000001?l00000oooo0?ooo`3oool2
034a<@80@D510`0];Bd202PX:080=SHf0P11@D44055AD@<0I6AT0P21PH4208R8R080XJ6Q0P2FUYH2
06][J`<0NGUi101nOWh208j>SP80Rh^;0P2=SHd307inOP80Shn?0P28R8P208F5Q@80RXZ:0P2PX:03
0;2`/080Shn?0P2;Rh/207UiN@80F5QH0P12@T8304U9B@80>c/k0P0o?cl203/k>`80=SHf0P0];Bd3
03lo?`80BDU90P0f=SH602d];@<0<C4a0P0Z:RX201DE5@@08R8R0`0G5aL201DE5@H05aLG0P0E5AD3
01LG5`80:RXZ0P0];Bd2028R8P80:2PX0P0];Bd30451@@80@T920P0f=SH203<c<`800`<30P000003
00L71`800`<30P0;2`/201LG5`80>c/k0P1ADE430492@P80?3`l0P0f=SH202PX:08092@T0P0];Bd3
02@T9080:RXZ0P0k>c/203<c<`80?3`l0P1<C4`303Hf=P80<C4a0P0];Bd4034a<@806a/K0`0G5aL2
03Hf=P80>3Ph0P0k>c/404I6AP<0<C4a0P15ADD20451@@D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80<C4a0P11@D4302d];@80:2PX0P0f=SH20451@@@0DE5A0`1TI6@20861P@80R8R80P2QXJ42
09JFUP80Jf][0`1iNGT407inOP80SXj>0P2;Rh/208f=S@<0OWin0P2?Shl208R8R080QHF50P2:RXX2
0:2PX0<0/;2`0P2?Shl208^;R`80NGUi0P1HF5P20492@P<0BDU90P0k>c/203lo?`80>c/k0P0f=SH2
02d];@<0?clo0P19BDT203Hf=PH0;Bd]0`0a<C4202XZ:P805ADE100R8R8301LG5`805ADE1P0G5aL2
01DE5@<05aLG0P0Z:RX202d];@808R8R0P0X:2P202d];@<0@D510P12@T8203Hf=P80<c<c0P030`<2
000000<01`L70P030`<200/;2`805aLG0P0k>c/2055AD@<0@T920P0l?3`203Hf=P80:2PX0P0T92@2
02d];@<092@T0P0Z:RX203/k>`80<c<c0P0l?3`204a<C0<0=SHf0P0a<C4202d];@@0<C4a0P0K6a/3
01LG5`80=SHf0P0h>3P203/k>`@0ATI60`0a<C4204E5A@80@D511@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0c<c<502PX:080<C4a0P0];Bd202XZ:P80;Bd]0P0h>3P3055AD@80C4a<0P28R8P2
06][J`80QXJ60P1nOWh306IVIP80TY:B0P2CTi<2096AT@80LG5a0P2?Shl308V9R@80QXJ60P24Q8@2
09jNWP80SHf=0P1eMGD308^;R`80W9bL0P2FUYH207alO080MWIf0P1ADE4304U9B@80ATI60P0l?3`2
04I6AP80=SHf0P0c<c<303lo?`80@D510P16ATH203Ph>08092@T0P0X:2P302d];@808R8R0P0G5aL2
02@T90D05aLG0P0A4A4201/K6`805ADE0P0G5aL2028R8P<04A4A0P0E5AD201/K6`80<C4a100X:2P3
03<c<`80?clo0P0k>c/2034a<@80<c<c1@00000200L71`@00`<30P071`L2014A4@<0>3Ph0P12@T82
03/k>`80<C4a0P0K6a/2014A4@<05aLG100T92@203Ph>080<C4a0P0l?3`303<c<`80:2PX0P0];Bd2
02PX:080=SHf0P0a<C4301/K6`80:RXZ0P0l?3`203Ph>080;Bd]0P11@D4302d];@80=SHf0P0];Bd5
0?ooo`7o000000001?l00000oooo0?ooo`3oool203<c<`D0:2PX0P0a<C4202d];@80:RXZ0P0];Bd2
03Ph>0<0DE5A0P1<C4`208R8R080Jf][0P26QXH207inOP<0IVIV0P2BTY8209>CT`80TI6A0P1aLG42
08n?S`<0RHV90P26QXH208B4Q080WYjN0P2=SHd207EeM@<0Rh^;0P2LW9`209JFUP80O7al0P1fMWH2
055AD@<0BDU90P16ATH203`l?080ATI60P0f=SH203<c<`<0?clo0P11@D4204I6AP80>3Ph0P0T92@2
02PX:0<0;Bd]0P0R8R8201LG5`8092@T1@0G5aL2014A4@806a/K0P0E5AD201LG5`808R8R0`0A4A42
01DE5@806a/K0P0a<C4402PX:0<0<c<c0P0o?cl203/k>`80<C4a0P0c<c<5000000801`L710030`<2
00L71`804A4A0`0h>3P20492@P80>c/k0P0a<C4201/K6`804A4A0`0G5aL402@T9080>3Ph0P0a<C42
03`l?0<0<c<c0P0X:2P202d];@80:2PX0P0f=SH2034a<@<06a/K0P0Z:RX203`l?080>3Ph0P0];Bd2
0451@@<0;Bd]0P0f=SH202d];@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80<C4a0P0Z:RX3
02@T9080;Bd]0P0c<c<202d];@80:RXZ0P0f=SH302XZ:P80>3Ph0P1QHF42079bLP80MgMg0P20P803
07inOP80De=C0P20P80207moO`80V9RH0P1/K6`307MgM`80PH610P1lO7`207inOP80TY:B1@2LW9`2
07UiN@80X:2P0P2BTY820861P@80FUYJ0`19BDT204i>CP80C4a<0P0o?cl203/k>`80<C4a0`0f=SH2
03<c<`80;Bd]100X:2P5028R8P80:RXZ100G5aL901/K6`H04A4A0`0=3@d201/K6`805ADE0P0A4A42
01LG5`L092@T100c<c<203/k>`80<c<c0`030`<2000000800`<30P00000200<30`801`L70`0;2`/2
02PX:080ADE50P1ADE420451@@80<c<c1`0X:2P202d];@80:RXZ0P0a<C4303Ph>0@0:RXZ0P0T92@2
02d];@80<C4a0`0Z:RX202@T9080:2PX0P0a<C4203Hf=P80:2PX0`0c<c<202XZ:P80<c<c1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P0a<C4202XZ:P<092@T0P0];Bd203<c<`80;Bd]0P0Z:RX2
03Hf=P<0:RXZ0P0h>3P2065QH@80LW9b0P1gMgL20820P0<0OWin0P1CDe<20820P080Ogmo0P2HV9P2
06a/K0<0MgMg0P21PH4207alO080OWin0P2BTY8509bLW080NGUi0P2PX:0209:BTP80PH610P1JFUX3
04U9B@80CTi>0P1<C4`203lo?`80>c/k0P0a<C4303Hf=P80<c<c0P0];Bd402PX:0D08R8R0P0Z:RX4
01LG5`T06a/K1P0A4A4300d=3@806a/K0P0E5AD2014A4@805aLG1`0T92@403<c<`80>c/k0P0c<c<3
00<30`8000000P030`<2000000800`<30P071`L300/;2`80:2PX0P15ADD2055AD@80@D510P0c<c<7
02PX:080;Bd]0P0Z:RX2034a<@<0>3Ph100Z:RX202@T9080;Bd]0P0a<C4302XZ:P8092@T0P0X:2P2
034a<@80=SHf0P0X:2P303<c<`80:RXZ0P0c<c<50?ooo`7o000000001?l00000oooo0?ooo`3oool2
034a<@80:RXZ0`0T92@202d];@80<c<c0P0];Bd202XZ:P80=SHf0`0Z:RX203Ph>080HF5Q0P1bLW82
07MgM`80P8200`1nOWh205=CD`80P8200P1oOgl209RHV080K6a/0`1gMgL20861P@80O7al0P1nOWh2
09:BTPD0W9bL0P1iNGT20:2PX080TY:B0P21PH4205YJFP<0BDU90P1>CTh204a<C080?clo0P0k>c/2
034a<@<0=SHf0P0c<c<202d];@@0:2PX1@0R8R8202XZ:P@05aLG2@0K6a/6014A4@<03@d=0P0K6a/2
01DE5@804A4A0P0G5aL702@T90@0<c<c0P0k>c/203<c<`<00`<30P00000200<30`8000000P030`<2
00L71`<02`/;0P0X:2P204E5A@80DE5A0P11@D4203<c<`L0:2PX0P0];Bd202XZ:P80<C4a0`0h>3P4
02XZ:P8092@T0P0];Bd2034a<@<0:RXZ0P0T92@202PX:080<C4a0P0f=SH202PX:0<0<c<c0P0Z:RX2
03<c<`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80?3`l1@0f=SH202@T9080<C4a0P0o?cl2
03Hf=P80>c/k0`0h>3P40451@@80EeMG0P1bLW8208^;R`<0QHF50P26QXH205eMG@80KFe]0P1jNWX2
08n?S`<0GEeM0P1GEeL207UiN@80MgMg0P2=SHd207UiN@<0Ti>C0P25QHD209BDU080RXZ:0P2?Shl2
06][J`<0HV9R0P1ADE4204E5A@80Hf=S0P1HF5P203Hf=P<0?clo0P0k>c/202XZ:P80:2PX0P0T92@2
028R8P<092@T0P0Z:RX203<c<`8092@T0P0G5aL303Hf=P805aLG0P0R8R8201/K6`L05ADE0P0=3@d2
00/;2`805ADE100A4A4301DE5@80:2PX0P0T92@202d];@8092@T0P0X:2P3034a<@80000020030`<5
00L71`804A4A0P0l?3`4051@D0<0@T920P0a<C4203/k>`80<C4a0P0R8R8202XZ:P<0:2PX0P0c<c<2
03Hf=P808R8R0P0K6a/201LG5`<08R8R0P0Z:RX202@T90805aLG0P0R8R8202XZ:P<0:2PX100];Bd5
0?ooo`7o000000001?l00000oooo0?ooo`3oool203`l?0D0=SHf0P0T92@2034a<@80?clo0P0f=SH2
03/k>`<0>3Ph1011@D4205MGE`80LW9b0P2;Rh/308F5Q@80QXJ60P1MGEd206e]K@80NWYj0P2?Shl3
05eMG@80EeMG0P1iNGT207MgM`80SHf=0P1iNGT309>CT`80QHF50P2DU9@208Z:RP80Shn?0P1[Jf/3
069RHP80DE5A0P15ADD206=SH`80F5QH0P0f=SH303lo?`80>c/k0P0Z:RX202PX:08092@T0P0R8R83
02@T9080:RXZ0P0c<c<202@T90805aLG0`0f=SH201LG5`808R8R0P0K6a/701DE5@803@d=0P0;2`/2
01DE5@@04A4A0`0E5AD202PX:08092@T0P0];Bd202@T9080:2PX0`0a<C42000000P00`<31@071`L2
014A4@80?3`l101@D5030492@P80<C4a0P0k>c/2034a<@808R8R0P0Z:RX302PX:080<c<c0P0f=SH2
028R8P806a/K0P0G5aL3028R8P80:RXZ0P0T92@201LG5`808R8R0P0Z:RX302PX:0@0;Bd]1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P0f=SH202XZ:P<0=SHf0P0h>3P202PX:080;Bd]0P0T92@5
04E5A@80?clo0P1>CTh2055AD@80EEEE0P1CDe<307MgM`80LG5a0P2DU9@205EEE@80Jf][0P1bLW83
08Z:RP80ATI60P1HF5P407YjNP80Q8B40`1aLG4208B4Q080M7Ad0P2SXj<206e]K@80O7al0`1QHF44
05eMG@80DE5A0P1SHf<20492@P<0;Bd]0P0a<C4203lo?`80>3Ph100Z:RX3028R8P80:2PX0P0Z:RX2
02@T90805ADE1@0G5aL201DE5@808R8R0P0A4A4201LG5`<04A4A0P0;2`/400d=3@802`/;1@0G5aL2
01DE5@806a/K0P0A4A4201DE5@D0:2PX0P0T92@400L71`800`<30P00000500<30`@01`L70P0T92@2
04I6AP<0DE5A0P1EEED203lo?`808R8R100K6a/302PX:08092@T0P0];Bd2028R8P805ADE0P0G5aL3
01/K6`8092@T0P0K6a/201LG5`L06a/K0P0E5AD202PX:0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80=SHf0P0Z:RX303Hf=P80>3Ph0P0X:2P202d];@8092@T1@15ADD203lo?`80CTi>0P1ADE42
05EEE@80De=C0`1gMgL2075aL@80U9BD0P1EEED206][J`80LW9b0`2:RXX204I6AP80F5QH101jNWX2
08B4Q0<0LG5a0P24Q8@207AdM080Xj>S0P1]KFd207alO0<0HF5Q101MGEd2055AD@80Hf=S0P12@T83
02d];@80<C4a0P0o?cl203Ph>0@0:RXZ0`0R8R8202PX:080:RXZ0P0T92@201DE5@D05aLG0P0E5AD2
028R8P804A4A0P0G5aL3014A4@802`/;100=3@d200/;2`D05aLG0P0E5AD201/K6`804A4A0P0E5AD5
02PX:08092@T10071`L200<30`8000001@030`<400L71`8092@T0P16ATH3055AD@80EEEE0P0o?cl2
028R8P@06a/K0`0X:2P202@T9080;Bd]0P0R8R8201DE5@805aLG0`0K6a/202@T90806a/K0P0G5aL7
01/K6`805ADE0P0X:2P50?ooo`7o000000001?l00000oooo0?ooo`3oool202XZ:P80<c<c0`0a<C42
03lo?`@0<C4a0P0h>3P202XZ:P<0:2PX0P1>CTh203Hf=P80ADE50P1>CTh20492@P<0J6QX0P1ADE42
05iNGP80R8R80P1HF5P206a/K0<0LG5a0P24Q8@4055AD@80NGUi0P1dM7@305iNGP80MWIf0P1`L702
06e]K@80Shn?0P1jNWX306=SH`80HF5Q0P1JFUX205EEE@80CTi>0P1@D50303Hf=P80?3`l0P0h>3P2
0451@@80=SHf0P0c<c<3034a<@80:RXZ0P0c<c<2028R8P8092@T0`0E5AD201LG5`806a/K0P0G5aL4
014A4@L03@d=0P0;2`/401LG5`<03@d=0P0;2`/201/K6`805ADE0P0K6a/201DE5@<03@d=0P0T92@2
02XZ:P8000000P030`<2000000L00`<30P071`L200d=3@805ADE0`0k>c/203Ph>080<C4a0P0Z:RX2
03<c<`80:2PX0`0K6a/401LG5`806a/K0P0Z:RX2028R8P<06a/K0P0Z:RX203<c<`80=SHf0P0X:2P2
02@T90<08R8R0P0T92@202PX:0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80:RXZ0P0c<c<3
034a<@80?clo100a<C4203Ph>080:RXZ0`0X:2P204i>CP80=SHf0P15ADD204i>CP80@T920`1XJ6P2
055AD@80GUiN0P28R8P205QHF080K6a/0`1aLG4208B4Q0@0DE5A0P1iNGT207AdM0<0GUiN0P1fMWH2
071`L080KFe]0P2?Shl207YjNP<0Hf=S0P1QHF4205YJFP80EEEE0P1>CTh2051@D0<0=SHf0P0l?3`2
03Ph>080@D510P0f=SH203<c<`<0<C4a0P0Z:RX203<c<`808R8R0P0T92@301DE5@805aLG0P0K6a/2
01LG5`@04A4A1`0=3@d200/;2`@05aLG0`0=3@d200/;2`806a/K0P0E5AD201/K6`805ADE0`0=3@d2
02@T9080:RXZ0P00000200<30`8000001`030`<200L71`803@d=0P0E5AD303/k>`80>3Ph0P0a<C42
02XZ:P80<c<c0P0X:2P301/K6`@05aLG0P0K6a/202XZ:P808R8R0`0K6a/202XZ:P80<c<c0P0f=SH2
02PX:08092@T0`0R8R8202@T9080:2PX1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0Z:RX2
03<c<`<0<C4a0P0o?cl4034a<@80>3Ph0P0Z:RX302PX:080CTi>0P0f=SH204E5A@80CTi>0P12@T83
06QXJ080DE5A0P1NGUh208R8R080F5QH0P1/K6`3075aL@80Q8B4101ADE4207UiN@80M7Ad0`1NGUh2
07IfMP80L71`0P1]KFd208n?S`80NWYj0`1SHf<2065QH@80FUYJ0P1EEED204i>CP80D51@0`0f=SH2
03`l?080>3Ph0P11@D4203Hf=P80<c<c0`0a<C4202XZ:P80<c<c0P0R8R8202@T90<05ADE0P0G5aL2
01/K6`805aLG100A4A4700d=3@802`/;100G5aL300d=3@802`/;0P0K6a/201DE5@806a/K0P0E5AD3
00d=3@8092@T0P0Z:RX2000000800`<30P00000700<30`801`L70P0=3@d201DE5@<0>c/k0P0h>3P2
034a<@80:RXZ0P0c<c<202PX:0<06a/K100G5aL201/K6`80:RXZ0P0R8R8301/K6`80:RXZ0P0c<c<2
03Hf=P80:2PX0P0T92@3028R8P8092@T0P0X:2P50?ooo`7o000000001?l00000oooo0?ooo`3oool2
028R8P80:2PX0`0c<c<202d];@806a/K0P0X:2P202d];@80?clo0`15ADD202d];@80>c/k0P0h>3P2
0492@P80GUiN0`1<C4`205eMG@80MWIf0P1[Jf/208F5Q@80LG5a0`1NGUh2065QH@80PH610P19BDT2
04I6AP80LW9b0`1dM7@205iNGP80G5aL0P1MGEd206QXJ080MgMg0`1jNWX206IVIP80I6AT0P1ADE42
05EEE@80F5QH0`12@T8203`l?080ATI60P0c<c<203lo?`80=SHf0`0];Bd402XZ:P80:2PX0P0T92@3
01/K6`8092@T0P0R8R8201LG5`808R8R1@0A4A4400d=3@H02`/;0`0A4A42028R8P@02`/;0P0A4A42
02PX:0<08R8R0P0G5aL200d=3@805aLG0P030`<200d=3@<0000020030`<200L71`<02`/;0P0f=SH2
03lo?`80@T920P0o?cl202PX:0D0;Bd]0P0a<C4203<c<`L092@T100Z:RX202PX:0L08R8R0P0h>3P2
034a<@D0oooo0Ol000000004o`00003oool0oooo0?ooo`808R8R0P0X:2P303<c<`80;Bd]0P0K6a/2
02PX:080;Bd]0P0o?cl304E5A@80;Bd]0P0k>c/203Ph>080@T920P1NGUh304a<C080GEeM0P1fMWH2
06][J`80QHF50P1aLG4305iNGP80HF5Q0P21PH4204U9B@80ATI60P1bLW8307AdM080GUiN0P1LG5`2
05eMG@80J6QX0P1gMgL307YjNP80IVIV0P1TI6@2055AD@80EEEE0P1HF5P30492@P80?3`l0P16ATH2
03<c<`80?clo0P0f=SH302d];@@0:RXZ0P0X:2P202@T90<06a/K0P0T92@2028R8P805aLG0P0R8R85
014A4@@03@d=1P0;2`/3014A4@808R8R100;2`/2014A4@80:2PX0`0R8R8201LG5`803@d=0P0G5aL2
00<30`803@d=0`00000800<30`801`L70`0;2`/203Hf=P80?clo0P12@T8203lo?`80:2PX1@0];Bd2
034a<@80<c<c1`0T92@402XZ:P80:2PX1`0R8R8203Ph>080<C4a1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0X:2P202@T90<0:2PX100Z:RX401/K6`80>3Ph0`15ADD203lo?`80=SHf0P0a<C42
02XZ:P80>3Ph0`1CDe<205iNGP80EeMG0P1]KFd207moO`80SXj>0`1VIVH2075aL@80F5QH0P1eMGD2
05eMG@80HV9R0`1]KFd206IVIP80EEEE0P1HF5P4065QH@<0M7Ad0P1`L70206QXJ080G5aL0P1>CTh2
05YJFP<0ATI60P0f=SH403lo?`80<c<c0P1>CTh302PX:08092@T0P0Z:RX202@T90808R8R0`0K6a/2
01LG5`80:RXZ0P0K6a/201LG5`805ADE0`0=3@d6014A4@803@d=0P071`L500/;2`803@d=0P0E5AD4
00/;2`<04A4A0P0K6a/401DE5@805aLG3`030`<300L71`802`/;0P0f=SH2055AD@80BDU90P0l?3`5
02d];@80:RXZ0P0c<c<203/k>`80:RXZ0`0K6a/402d];@80:2PX0P0T92@201/K6`D092@T0P0c<c<5
0?ooo`7o000000001?l00000oooo0?ooo`3oool202PX:08092@T0`0X:2P402XZ:P@06a/K0P0h>3P3
04E5A@80?clo0P0f=SH2034a<@80:RXZ0P0h>3P305=CD`80GUiN0P1GEeL206e]K@80Ogmo0P2>SXh3
06IVIP80LG5a0P1HF5P207EeM@80GEeM0P1RHV8306e]K@80IVIV0P1EEED205QHF0@0HF5Q0`1dM7@2
071`L080J6QX0P1LG5`204i>CP80FUYJ0`16ATH203Hf=P@0?clo0P0c<c<204i>CP<0:2PX0P0T92@2
02XZ:P8092@T0P0R8R8301/K6`805aLG0P0Z:RX201/K6`805aLG0P0E5AD300d=3@H04A4A0P0=3@d2
00L71`D02`/;0P0=3@d201DE5@@02`/;0`0A4A4201/K6`@05ADE0P0G5aL?00<30`<01`L70P0;2`/2
03Hf=P80DE5A0P19BDT203`l?0D0;Bd]0P0Z:RX203<c<`80>c/k0P0Z:RX301/K6`@0;Bd]0P0X:2P2
02@T90806a/K1@0T92@203<c<`D0oooo0Ol000000004o`00003oool0oooo0?ooo`805ADE0P0K6a/3
02@T9080:2PX0P0Z:RX2034a<@@08R8R0`0f=SH20451@@80<c<c0P0h>3P2034a<@D0>c/k0P15ADD2
05MGE`80I6AT0P1VIVH208J6QP<0PH610P1aLG4206a/K080KFe]0P1HF5P205aLG0<0IVIV101EEED4
04U9B@80J6QX0`1JFUX207UiN@80M7Ad0P1eMGD205iNGP80F5QH0`0l?3`20451@@80>c/k0P1HF5P2
034a<@80:RXZ0`0h>3P2034a<@808R8R100];Bd3028R8P805ADE0P0K6a/203<c<`808R8R0P0A4A43
00d=3@804A4A100=3@d400/;2`<01`L70P030`<600d=3@801`L70`0=3@d200/;2`805ADE0P0=3@d4
014A4@D00`<30P00000400<30`L01`L70P0A4A4202XZ:P80BDU90P0h>3P3034a<@80>3Ph0P0o?cl2
02XZ:P80<c<c0P0k>c/303<c<`80;Bd]0P0X:2P202@T90808R8R0P0K6a/302PX:0808R8R0P0E5AD5
0?ooo`7o000000001?l00000oooo0?ooo`3oool201DE5@806a/K0`0T92@202PX:080:RXZ0P0a<C44
028R8P<0=SHf0P11@D4203<c<`80>3Ph0P0a<C4503/k>`80ADE50P1GEeL206ATI080IVIV0P26QXH3
0861P@80LG5a0P1/K6`206e]K@80F5QH0P1LG5`306IVIP@0EEEE1019BDT206QXJ0<0FUYJ0P1iNGT2
07AdM080MGEe0P1NGUh205QHF0<0?3`l0P11@D4203/k>`80F5QH0P0a<C4202XZ:P<0>3Ph0P0a<C42
028R8P@0;Bd]0`0R8R8201DE5@806a/K0P0c<c<2028R8P804A4A0`0=3@d2014A4@@03@d=100;2`/3
00L71`800`<31P0=3@d200L71`<03@d=0P0;2`/201DE5@803@d=100A4A4500<30`80000010030`<7
00L71`804A4A0P0Z:RX204U9B@80>3Ph0`0a<C4203Ph>080?clo0P0Z:RX203<c<`80>c/k0`0c<c<2
02d];@80:2PX0P0T92@2028R8P806a/K0`0X:2P2028R8P805ADE1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0E5AD201/K6`<092@T0P0X:2P202XZ:P80<C4a100R8R8303Hf=P80@D510P0c<c<2
03Ph>080<C4a1@0k>c/204E5A@80EeMG0P1TI6@206IVIP80QXJ60`21PH42075aL@80K6a/0P1]KFd2
05QHF080G5aL0`1VIVH405EEE@@0BDU90P1XJ6P305YJFP80NGUi0P1dM7@207EeM@80GUiN0P1HF5P3
03`l?080@D510P0k>c/205QHF080<C4a0P0Z:RX303Ph>080<C4a0P0R8R8402d];@<08R8R0P0E5AD2
01/K6`80<c<c0P0R8R82014A4@<03@d=0P0A4A4400d=3@@02`/;0`071`L200<30`H03@d=0P071`L3
00d=3@802`/;0P0E5AD200d=3@@04A4A1@030`<2000000@00`<31`071`L2014A4@80:RXZ0P19BDT2
03Ph>0<0<C4a0P0h>3P203lo?`80:RXZ0P0c<c<203/k>`<0<c<c0P0];Bd202PX:08092@T0P0R8R82
01/K6`<0:2PX0P0R8R8201DE5@D0oooo0Ol000000004o`00003oool0oooo0?ooo`805ADE0P0=3@d3
014A4@805aLG100T92@203Hf=P80:2PX0`0R8R8203Ph>080?clo0P0];Bd20492@P80BDU90`0k>c/2
055AD@80GEeM0P1/K6`207UiN@80K6a/0`1RHV8209bLW080UiNG101@D50204U9B@<0HF5Q0P1SHf<2
05iNGP80@D510P1CDe<206=SH`<0HV9R0P1JFUX208J6QP80QHF50P26QXH206QXJ0<0G5aL0P19BDT4
0451@@80>c/k0P0T92@3028R8P80?3`l0P0];Bd201/K6`D0:2PX0P0G5aL201/K6`805aLG0P0T92@2
01LG5`<03@d=0P0;2`/2014A4@802`/;0P0E5AD200d=3@<04A4A100=3@d200L71`802`/;0P0=3@d5
00L71`@02`/;0P0A4A4202@T90<06a/K0P071`L2000000/00`<30P0;2`/201LG5`80:RXZ0P0h>3P3
03`l?080;Bd]100c<c<203Ph>080De=C0`0l?3`202XZ:P8092@T0P0];Bd201/K6`D05aLG0P0A4A42
01DE5@D0oooo0Ol000000004o`00003oool0oooo0?ooo`805ADE0P0=3@d3014A4@805aLG100T92@2
03Hf=P80:2PX0`0R8R8203Ph>080?clo0P0];Bd20492@P80BDU90`0k>c/2055AD@80GEeM0P1/K6`2
07UiN@80K6a/0`1RHV8209bLW080UiNG101@D50204U9B@<0HF5Q0P1SHf<205iNGP80@D510P1CDe<2
06=SH`<0HV9R0P1JFUX208J6QP80QHF50P26QXH206QXJ0<0G5aL0P19BDT40451@@80>c/k0P0T92@3
028R8P80?3`l0P0];Bd201/K6`D0:2PX0P0G5aL201/K6`805aLG0P0T92@201LG5`<03@d=0P0;2`/2
014A4@802`/;0P0E5AD200d=3@<04A4A100=3@d200L71`802`/;0P0=3@d500L71`@02`/;0P0A4A42
02@T90<06a/K0P071`L2000000/00`<30P0;2`/201LG5`80:RXZ0P0h>3P303`l?080;Bd]100c<c<2
03Ph>080De=C0`0l?3`202XZ:P8092@T0P0];Bd201/K6`D05aLG0P0A4A4201DE5@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`8092@T0P0G5aL300d=3@8092@T0P0E5AD2028R8P806a/K1@0R8R82
02@T9080;Bd]0P19BDT204i>CP80C4a<0`1>CTh203Ph>080D51@0P1VIVH206QXJ080LG5a0`25QHD2
07UiN@80MGEe0P2ATI4205eMG@80?3`l0`1QHF4206=SH`80K6a/0P1VIVH203Hf=P80ATI60`1MGEd2
06=SH`80G5aL0P25QHD206ATI080KFe]0`1nOWh206IVIP80CTi>0P15ADD205EEE@80<C4a0`0X:2P2
02@T9080<c<c0P0Z:RX2028R8P<0:2PX0P0R8R8202@T90805ADE0P0A4A4200d=3@<05ADE0P0;2`/2
00d=3@802`/;0P0A4A4200/;2`<03@d=0P0A4A4400d=3@802`/;0P0=3@d300/;2`803@d=0P0A4A42
00/;2`805aLG1@0;2`/2014A4@802`/;10030`<2000000L00`<30P0;2`/2028R8P80D51@0`19BDT2
03lo?`80<c<c0P0Z:RX20492@PD0=SHf0P12@T8403lo?`80:2PX0P0];Bd302XZ:P80:2PX0P0R8R85
0?ooo`7o000000001?l00000oooo0?ooo`3oool202@T90805aLG0`0=3@d202@T90805ADE0P0R8R82
01/K6`D08R8R0P0T92@202d];@80BDU90P1>CTh204a<C0<0CTi>0P0h>3P2051@D080IVIV0P1XJ6P2
075aL@<0QHF50P1iNGT207EeM@80TI6A0P1MGEd203`l?0<0HF5Q0P1SHf<206a/K080IVIV0P0f=SH2
04I6AP<0GEeM0P1SHf<205aLG080QHF50P1TI6@206e]K@<0OWin0P1VIVH204i>CP80ADE50P1EEED2
034a<@<0:2PX0P0T92@203<c<`80:RXZ0P0R8R8302PX:0808R8R0P0T92@201DE5@804A4A0P0=3@d3
01DE5@802`/;0P0=3@d200/;2`804A4A0P0;2`/300d=3@804A4A100=3@d200/;2`803@d=0`0;2`/2
00d=3@804A4A0P0;2`/201LG5`D02`/;0P0A4A4200/;2`@00`<30P00000700<30`802`/;0P0R8R82
051@D0<0BDU90P0o?cl203<c<`80:RXZ0P12@T8503Hf=P80@T92100o?cl202PX:080;Bd]0`0Z:RX2
02PX:0808R8R1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0E5AD200d=3@<05ADE0P0K6a/2
01DE5@808R8R100K6a/3028R8P80:RXZ0P0X:2P203Hf=P80?3`l0P11@D4304a<C080D51@0P1HF5P2
0451@@80D51@0P1GEeL306IVIP80Ti>C0P2DU9@207inOP80RHV90P1NGUh30451@@80L71`0P1XJ6P2
08F5Q@80G5aL0P11@D4304a<C080G5aL0P1ADE4205MGE`80NGUi0P1SHf<306ATI080MWIf0P1XJ6P2
04I6AP80=SHf0P0l?3`303<c<`80<C4a0P0h>3P2028R8P805aLG1@0T92@201/K6`808R8R0P0K6a/2
014A4@<05ADE0P0A4A4400d=3@801`L71`0;2`/200<30`802`/;0P030`<200/;2`D03@d=0P0G5aL2
01DE5@806a/K1@0A4A4200/;2`803@d=0P071`L;00<30`801`L70P0=3@d204E5A@<0C4a<0P11@D42
04E5A@80=SHf0P0];Bd203Hf=P<0:RXZ0P0c<c<202d];@8092@T0P0h>3P2034a<@<0:2PX100T92@5
0?ooo`7o000000001?l00000oooo0?ooo`3oool201DE5@803@d=0`0E5AD201/K6`805ADE0P0R8R84
01/K6`<08R8R0P0Z:RX202PX:080=SHf0P0l?3`20451@@<0C4a<0P1@D50205QHF080@D510P1@D502
05MGE`<0IVIV0P2CTi<209BDU080OWin0P29RHT205iNGP<0@D510P1`L70206QXJ080QHF50P1LG5`2
0451@@<0C4a<0P1LG5`2055AD@80EeMG0P1iNGT206=SH`<0I6AT0P1fMWH206QXJ080ATI60P0f=SH2
03`l?0<0<c<c0P0a<C4203Ph>0808R8R0P0G5aL502@T90806a/K0P0R8R8201/K6`804A4A0`0E5AD2
014A4@@03@d=0P071`L700/;2`800`<30P0;2`/200<30`802`/;1@0=3@d201LG5`805ADE0P0K6a/5
014A4@802`/;0P0=3@d200L71`/00`<30P071`L200d=3@80ADE50`1<C4`20451@@80ADE50P0f=SH2
02d];@80=SHf0`0Z:RX203<c<`80;Bd]0P0T92@203Ph>080<C4a0`0X:2P402@T90D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`804A4A0P0=3@d301LG5`@06a/K0P0G5aL201DE5@808R8R0`0X:2P2
02XZ:P80=SHf0P0c<c<203`l?080>c/k0`11@D420492@P80HV9R0P1ADE42065QH@80HV9R0`1MGEd2
06ATI080QXJ60P2>SXh207EeM@80Rh^;0`1[Jf/204a<C080HF5Q0P1TI6@20861P@80De=C0`0h>3P2
05QHF080G5aL0P12@T8205QHF080I6AT0`1/K6`206e]K@80K6a/0P1RHV8205EEE@80>3Ph0`0a<C42
03<c<`80;Bd]0P0X:2P201/K6`<05aLG0P0Z:RX202@T90805ADE0P0T92@201LG5`<04A4A0P0=3@d2
00/;2`803@d=100;2`/500L71`802`/;10071`L200/;2`<00`<30P0;2`/200d=3@805aLG0P0T92@2
02d];@D0:RXZ100G5aL?00<30`80=SHf0`1QHF4204i>CP80ADE50P1GEeL205=CD`D0DE5A0P1@D504
03Hf=P80;Bd]0P0c<c<303Hf=P806a/K0P0G5aL50?ooo`7o000000001?l00000oooo0?ooo`3oool2
014A4@803@d=0`0G5aL401/K6`805aLG0P0E5AD2028R8P<0:2PX0P0Z:RX203Hf=P80<c<c0P0l?3`2
03/k>`<0@D510P12@T82069RHP80DE5A0P1QHF42069RHP<0GEeM0P1TI6@208J6QP80SXj>0P1eMGD2
08^;R`<0Jf][0P1<C4`2065QH@80I6AT0P21PH4205=CD`<0>3Ph0P1HF5P205aLG080@T920P1HF5P2
06ATI0<0K6a/0P1]KFd206a/K080HV9R0P1EEED203Ph>0<0<C4a0P0c<c<202d];@80:2PX0P0K6a/3
01LG5`80:RXZ0P0T92@201DE5@8092@T0P0G5aL3014A4@803@d=0P0;2`/200d=3@@02`/;1@071`L2
00/;2`@01`L70P0;2`/300<30`802`/;0P0=3@d201LG5`8092@T0P0];Bd502XZ:P@05aLG3`030`<2
03Hf=P<0HF5Q0P1>CTh204E5A@80EeMG0P1CDe<5055AD@80D51@100f=SH202d];@80<c<c0`0f=SH2
01/K6`805aLG1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0A4A4200d=3@<05aLG100K6a/2
01LG5`805ADE0P0R8R8302PX:080:RXZ0P0f=SH203<c<`80?3`l0P0k>c/30451@@80@T920P1RHV82
055AD@80HF5Q0P1RHV8305eMG@80I6AT0P26QXH208j>SP80MGEe0P2;Rh/306][J`80C4a<0P1QHF42
06ATI080PH610P1CDe<303Ph>080F5QH0P1LG5`20492@P80F5QH0P1TI6@306a/K080KFe]0P1/K6`2
069RHP80EEEE0P0h>3P3034a<@80<c<c0P0];Bd202PX:0806a/K0`0G5aL202XZ:P8092@T0P0E5AD2
02@T90805aLG0`0A4A4200d=3@802`/;0P0=3@d400/;2`D01`L70P0;2`/400L71`802`/;0`030`<2
00/;2`803@d=0P0G5aL202@T9080;Bd]1@0Z:RX401LG5`l00`<30P0f=SH3065QH@80CTi>0P15ADD2
05MGE`80De=C1@1ADE42051@D0@0=SHf0P0];Bd203<c<`<0=SHf0P0K6a/201LG5`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80:2PX0P0K6a/701LG5`805ADE0P0K6a/201DE5@<05aLG0P0T92@2
02d];@80:2PX0P0h>3P204a<C0<0DE5A1019BDT4055AD@80KFe]0`1[Jf/208J6QP80PH610P1nOWh2
07moO`80PH610`1bLW8205=CD`80CTi>0P1NGUh206ATI080L71`0`12@T8204U9B@80Jf][0P1GEeL2
03lo?`80C4a<0`1LG5`20861P@80O7al0P1]KFd205aLG080CTi>0`19BDT20492@P80<C4a0P0];Bd2
02@T90<0;Bd]0P0X:2P2028R8PH06a/K0`0R8R8201/K6`805ADE0P0=3@d200/;2`D03@d=10071`L2
00/;2`@01`L70`0=3@d2014A4@@03@d=0P0E5AD201LG5`<0:RXZ0P0G5aL202@T9080:2PX0P0h>3P=
00<30`803@d=0`1GEeL2079bLP80DE5A0P1GEeL205eMG@80IVIV0`1aLG4204i>CP80@D510P0a<C42
03<c<`80@D510`0a<C42028R8P806a/K1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0X:2P2
01/K6`L05aLG0P0E5AD201/K6`805ADE0`0G5aL202@T9080;Bd]0P0X:2P203Ph>080C4a<0`1ADE44
04U9B@@0DE5A0P1]KFd306][J`80QXJ60P21PH4207inOP80Ogmo0P21PH43079bLP80De=C0P1>CTh2
05iNGP80I6AT0P1`L7030492@P80BDU90P1[Jf/205MGE`80?clo0P1<C4`305aLG080PH610P1lO7`2
06e]K@80G5aL0P1>CTh304U9B@80@T920P0a<C4202d];@8092@T0`0];Bd202PX:0808R8R1P0K6a/3
028R8P806a/K0P0E5AD200d=3@802`/;1@0=3@d400L71`802`/;10071`L300d=3@804A4A100=3@d2
01DE5@805aLG0`0Z:RX201LG5`8092@T0P0X:2P203Ph>0d00`<30P0=3@d305MGE`80LW9b0P1ADE42
05MGE`80GEeM0P1VIVH3075aL@80CTi>0P11@D42034a<@80<c<c0P11@D43034a<@808R8R0P0K6a/5
0?ooo`7o000000001?l00000oooo0?ooo`3oool202@T90808R8R0`0A4A4400d=3@805aLG100A4A43
028R8P805aLG0P0T92@203/k>`80<C4a0P0l?3`30492@P80BDU90P12@T82055AD@80D51@0P1>CTh3
07inOP80Ogmo0P29RHT209JFUP80NGUi0P1LG5`308Z:RP80HF5Q0P1RHV8203lo?`80KFe]0P1aLG43
05YJFP80@T920P1MGEd206a/K080ADE50P0f=SH3055AD@80G5aL0P29RHT20861P@80Rh^;0P1MGEd3
04I6AP80D51@0P0k>c/20451@@80DE5A0`0c<c<2034a<@80:2PX0P0Z:RX2028R8P80:RXZ0`0T92@8
028R8PL03@d=0P0;2`/2014A4@803@d=1`0;2`/200d=3@804A4A0P0G5aL201/K6`<05ADE0P0K6a/2
01LG5`805ADE0P0A4A4201/K6`<0000020030`<200d=3@<08R8R0P1CDe<205YJFP80ADE50P0o?cl2
05aLG0<0EeMG0P1LG5`2051@D080?clo0P0Z:RX204E5A@<0>c/k0P0G5aL2028R8PD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`8092@T0P0R8R83014A4@@03@d=0P0G5aL4014A4@<08R8R0P0G5aL2
02@T9080>c/k0P0a<C4203`l?0<0@T920P19BDT20492@P80DE5A0P1@D50204i>CP<0OWin0P1oOgl2
08V9R@80UYJF0P1iNGT205aLG0<0RXZ:0P1QHF42069RHP80?clo0P1]KFd2075aL@<0FUYJ0P12@T82
05eMG@80K6a/0P15ADD203Hf=P<0DE5A0P1LG5`208V9R@80PH610P2;Rh/205eMG@<0ATI60P1@D502
03/k>`80@D510P1ADE4303<c<`80<C4a0P0X:2P202XZ:P808R8R0P0Z:RX302@T90P08R8R1`0=3@d2
00/;2`804A4A0P0=3@d700/;2`803@d=0P0A4A4201LG5`806a/K0`0E5AD201/K6`805aLG0P0E5AD2
014A4@806a/K0`00000800<30`803@d=0`0R8R8205=CD`80FUYJ0P15ADD203lo?`80G5aL0`1GEeL2
05aLG080D51@0P0o?cl202XZ:P80ADE50`0k>c/201LG5`808R8R1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0G5aL200/;2`D01`L70P0;2`/200L71`802`/;0P0E5AD3014A4@8092@T0P0f=SH2
03<c<`80?3`l0P15ADD303`l?080ADE50P1CDe<2051@D080CTi>0P1XJ6P306ATI080RHV90P2GUiL2
0:JVYP80YjNW0P2BTY83069RHP80NGUi0P1fMWH206ATI080EeMG0P1ADE43071`L080ATI60P0f=SH2
055AD@80EEEE0P0c<c<304U9B@80EeMG0P1NGUh2071`L080O7al0P1fMWH305eMG@80ATI60P1NGUh2
051@D080@D510`1EEED203/k>`80>3Ph0P0c<c<203Hf=P80<C4a0`0];Bd202@T9080:RXZ0P0T92@2
028R8P8092@T0`0A4A4200/;2`803@d=0P0;2`/2014A4@D03@d=0P071`L200d=3@804A4A0P0G5aL2
014A4@D05ADE0P0=3@d200L71`803@d=1@0A4A4400<30`80000010030`<300/;2`80:RXZ0P1@D502
04E5A@80?clo0P16ATH504E5A@80>3Ph0P0];Bd2034a<@808R8R1@0K6a/202@T90D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`805aLG0P0;2`/500L71`802`/;0P071`L200/;2`805ADE0`0A4A42
02@T9080=SHf0P0c<c<203`l?080ADE50`0l?3`204E5A@80De=C0P1@D50204i>CP80J6QX0`1TI6@2
08V9R@80UiNG0P2VYZH20:NWY`80TY:B0`1RHV8207UiN@80MWIf0P1TI6@205MGE`80DE5A0`1`L702
04I6AP80=SHf0P1ADE4205EEE@80<c<c0`19BDT205MGE`80GUiN0P1`L70207alO080MWIf0`1MGEd2
04I6AP80GUiN0P1@D5020451@@<0EEEE0P0k>c/203Ph>080<c<c0P0f=SH2034a<@<0;Bd]0P0T92@2
02XZ:P8092@T0P0R8R8202@T90<04A4A0P0;2`/200d=3@802`/;0P0A4A4500d=3@801`L70P0=3@d2
014A4@805aLG0P0A4A4501DE5@803@d=0P071`L200d=3@D04A4A10030`<2000000@00`<30`0;2`/2
02XZ:P80D51@0P15ADD203lo?`80ATI61@15ADD203Ph>080;Bd]0P0a<C42028R8PD06a/K0P0T92@5
0?ooo`7o000000001?l00000oooo0?ooo`3oool201LG5`802`/;1@071`L200/;2`801`L70P0;2`/2
01DE5@<04A4A0P0T92@203Hf=P80<c<c0P0l?3`204E5A@<0?3`l0P15ADD205=CD`80D51@0P1>CTh2
06QXJ0<0I6AT0P29RHT209NGU`80YZJV0P2WYjL209:BTP<0HV9R0P1iNGT207IfMP80I6AT0P1GEeL2
055AD@<0L71`0P16ATH203Hf=P80DE5A0P1EEED203<c<`<0BDU90P1GEeL205iNGP80L71`0P1lO7`2
07IfMP<0GEeM0P16ATH205iNGP80D51@0P11@D4305EEE@80>c/k0P0h>3P203<c<`80=SHf0P0a<C43
02d];@8092@T0P0Z:RX202@T90808R8R0P0T92@3014A4@802`/;0P0=3@d200/;2`804A4A1@0=3@d2
00L71`803@d=0P0A4A4201LG5`804A4A1@0E5AD200d=3@801`L70P0=3@d5014A4@@00`<30P000004
00<30`<02`/;0P0Z:RX2051@D080ADE50P0o?cl204I6APD0ADE50P0h>3P202d];@80<C4a0P0R8R85
01/K6`8092@T1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0G5aL200d=3@<01`L70P030`<6
00L71`803@d=0`0A4A4201/K6`80:RXZ0P0f=SH20451@@80>c/k0`1CDe<203/k>`80?3`l0P19BDT2
05YJFP80F5QH0`1/K6`206e]K@80Ogmo0P1nOWh20:NWY`80YZJV0`2NWYh2071`L080G5aL0P24Q8@2
069RHP80D51@0`12@T8205iNGP80ATI60P0f=SH20451@@80@T920`0l?3`20451@@80GEeM0P1JFUX2
06IVIP80LG5a0`1jNWX206a/K080CTi>0P1LG5`204a<C0<0FUYJ0P1@D5020451@@80?clo0P0h>3P2
03Hf=P<0<c<c0P0a<C4202d];@@092@T0P0R8R8301LG5`803@d=200;2`/301DE5@801`L70P0;2`/2
00d=3@808R8R0P0A4A4302@T90806a/K0P0E5AD400d=3@802`/;0`0=3@d2014A4@P00`<30`071`L2
02@T9080?clo0P1LG5`203Hf=P80:2PX0`0Z:RX202@T9080:2PX0P0];Bd203Hf=P80;Bd]0`0f=SH2
028R8P806a/K1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0G5aL200d=3@<01`L70P030`<6
00L71`803@d=0`0A4A4201/K6`80:RXZ0P0f=SH20451@@80>c/k0`1CDe<203/k>`80?3`l0P19BDT2
05YJFP80F5QH0`1/K6`206e]K@80Ogmo0P1nOWh20:NWY`80YZJV0`2NWYh2071`L080G5aL0P24Q8@2
069RHP80D51@0`12@T8205iNGP80ATI60P0f=SH20451@@80@T920`0l?3`20451@@80GEeM0P1JFUX2
06IVIP80LG5a0`1jNWX206a/K080CTi>0P1LG5`204a<C0<0FUYJ0P1@D5020451@@80?clo0P0h>3P2
03Hf=P<0<c<c0P0a<C4202d];@@092@T0P0R8R8301LG5`803@d=200;2`/301DE5@801`L70P0;2`/2
00d=3@808R8R0P0A4A4302@T90806a/K0P0E5AD400d=3@802`/;0`0=3@d2014A4@P00`<30`071`L2
02@T9080?clo0P1LG5`203Hf=P80:2PX0`0Z:RX202@T9080:2PX0P0];Bd203Hf=P80;Bd]0`0f=SH2
028R8P806a/K1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0E5AD200d=3@<02`/;10071`L4
00<30`801`L70`0=3@d2028R8P80<c<c0P12@T8203Ph>080>c/k0`12@T82051@D080>c/k1012@T82
06=SH`<0IVIV0P1bLW8207MgM`80Q8B40P1`L702079bLP<0XZ:R0P1lO7`205iNGP80De=C0P1XJ6P2
05EEE@<0ATI60P0c<c<20492@P80<c<c0P0];Bd203lo?`<0?3`l0P0c<c<204a<C080J6QX0P1CDe<2
06=SH`<0M7Ad0P1bLW8207EeM@80I6AT0P1RHV83051@D080Hf=S0P1MGEd20451@@80ADE50P11@D43
03lo?`80@D510P0h>3P2034a<@80<c<c0P0];Bd302PX:0806a/K0P0E5AD200/;2`@01`L70`0=3@d2
014A4@802`/;0P071`L200d=3@805ADE0`0G5aL202PX:0806a/K0P0R8R8201LG5`808R8R0`0X:2P2
01/K6`805aLG2@030`<2014A4@80:RXZ0P12@T82069RHP80>3Ph0`0a<C42051@D080<C4a0P0];Bd4
02XZ:P<08R8R100E5AD50?ooo`7o000000001?l00000oooo0?ooo`3oool201DE5@803@d=0`0;2`/4
00L71`@00`<30P071`L300d=3@808R8R0P0c<c<20492@P80>3Ph0P0k>c/30492@P80D51@0P0k>c/4
0492@P80Hf=S0`1VIVH2079bLP80MgMg0P24Q8@2071`L080LW9b0`2RXZ8207alO080GUiN0P1CDe<2
06QXJ080EEEE0`16ATH203<c<`80@T920P0c<c<202d];@80?clo0`0l?3`203<c<`80C4a<0P1XJ6P2
05=CD`80Hf=S0`1dM7@2079bLP80MGEe0P1TI6@2069RHP<0D51@0P1SHf<205eMG@80@D510P15ADD2
0451@@<0?clo0P11@D4203Ph>080<C4a0P0c<c<202d];@<0:2PX0P0K6a/201DE5@802`/;10071`L3
00d=3@804A4A0P0;2`/200L71`803@d=0P0E5AD301LG5`80:2PX0P0K6a/2028R8P805aLG0P0R8R83
02PX:0806a/K0P0G5aL900<30`804A4A0P0Z:RX20492@P80HV9R0P0h>3P3034a<@80D51@0P0a<C42
02d];@@0:RXZ0`0R8R8401DE5@D0oooo0Ol000000004o`00003oool0oooo0?ooo`804A4A0P0;2`/3
014A4@801`L70P030`<200L71`800`<30P071`L300/;2`805ADE0P0X:2P203`l?080ATI60P0o?cl3
04a<C080DE5A0P15ADD204I6AP80@T920P16ATH307AdM080HF5Q0P1/K6`207EeM@80RXZ:0P1nOWh3
06e]K@80QXJ60P1oOgl205eMG@80ATI60P1@D50305iNGP80ATI60P0a<C4203Hf=P80:2PX0P0T92@3
02PX:080:RXZ0P0a<C4205MGE`80IVIV0P1>CTh304I6AP80NGUi0P1gMgL207alO080Ogmo0`1VIVH2
05eMG@80L71`0P1MGEd2055AD@80BDU90`1HF5P204I6APH0C4a<0P0c<c<303Ph>080<c<c0P0X:2P2
02XZ:P805aLG0P0A4A4500L71`H02`/;0P071`L500d=3@806a/K0P0Z:RX203<c<`80>3Ph1@0f=SH2
034a<@80=SHf1000000500<30`805ADE0P0Z:RX2034a<@80<c<c0`0R8R8202XZ:P80:2PX0P0f=SH2
02PX:0D0<C4a0P0G5aL2014A4@D0oooo0Ol000000004o`00003oool0oooo0?ooo`804A4A0P0;2`/3
014A4@801`L70P030`<200L71`800`<30P071`L300/;2`805ADE0P0X:2P203`l?080ATI60P0o?cl3
04a<C080DE5A0P15ADD204I6AP80@T920P16ATH307AdM080HF5Q0P1/K6`207EeM@80RXZ:0P1nOWh3
06e]K@80QXJ60P1oOgl205eMG@80ATI60P1@D50305iNGP80ATI60P0a<C4203Hf=P80:2PX0P0T92@3
02PX:080:RXZ0P0a<C4205MGE`80IVIV0P1>CTh304I6AP80NGUi0P1gMgL207alO080Ogmo0`1VIVH2
05eMG@80L71`0P1MGEd2055AD@80BDU90`1HF5P204I6APH0C4a<0P0c<c<303Ph>080<c<c0P0X:2P2
02XZ:P805aLG0P0A4A4500L71`H02`/;0P071`L500d=3@806a/K0P0Z:RX203<c<`80>3Ph1@0f=SH2
034a<@80=SHf1000000500<30`805ADE0P0Z:RX2034a<@80<c<c0`0R8R8202XZ:P80:2PX0P0f=SH2
02PX:0D0<C4a0P0G5aL2014A4@D0oooo0Ol000000004o`00003oool0oooo0?ooo`804A4A0P0;2`/3
014A4@801`L70P030`<200L71`800`<30P071`L300/;2`805ADE0P0X:2P203`l?080ATI60P0o?cl3
04a<C080DE5A0P15ADD204I6AP80@T920P16ATH307AdM080HF5Q0P1/K6`207EeM@80RXZ:0P1nOWh3
06e]K@80QXJ60P1oOgl205eMG@80ATI60P1@D50305iNGP80ATI60P0a<C4203Hf=P80:2PX0P0T92@3
02PX:080:RXZ0P0a<C4205MGE`80IVIV0P1>CTh304I6AP80NGUi0P1gMgL207alO080Ogmo0`1VIVH2
05eMG@80L71`0P1MGEd2055AD@80BDU90`1HF5P204I6APH0C4a<0P0c<c<303Ph>080<c<c0P0X:2P2
02XZ:P805aLG0P0A4A4500L71`H02`/;0P071`L500d=3@806a/K0P0Z:RX203<c<`80>3Ph1@0f=SH2
034a<@80=SHf1000000500<30`805ADE0P0Z:RX2034a<@80<c<c0`0R8R8202XZ:P80:2PX0P0f=SH2
02PX:0D0<C4a0P0G5aL2014A4@D0oooo0Ol000000004o`00003oool0oooo0?ooo`805aLG0P0A4A43
00L71`805ADE0P071`L200/;2`801`L71@030`<200/;2`806a/K0P0f=SH204I6AP80ADE50`1<C4`2
05eMG@80D51@0P0f=SH203lo?`80C4a<0`1LG5`2069RHP80IVIV0P1QHF4207YjNP80MWIf0`1/K6`2
0820P080SXj>0P1fMWH20492@P80D51@0`0k>c/205=CD`80DE5A0P0k>c/20492@P80<C4a0`0R8R82
01DE5@806a/K0P0a<C42069RHP80GEeM0`1TI6@205QHF080NWYj0P1SHf<207YjNP<0MgMg0P1`L702
06QXJ080O7al0P1fMWH205=CD`<0BDU90P1QHF4205EEE@80FUYJ0P1EEED203lo?`<0<c<c0P0T92@4
02PX:080:RXZ0P0K6a/3014A4@802`/;20030`<500L71`802`/;0P0A4A4201/K6`80=SHf0`0l?3`2
04U9B@H0>c/k0P071`L500<30`803@d=0P0E5AD201LG5`80:RXZ0`0X:2P202@T9080:RXZ0P0h>3P2
034a<@806a/K0`0Z:RX20451@@80?3`l1@3oool1o`00000000Co00000?ooo`3oool0oooo0P0G5aL2
014A4@<01`L70P0E5AD200L71`802`/;0P071`L500<30`802`/;0P0K6a/203Hf=P80ATI60P15ADD3
04a<C080GEeM0P1@D50203Hf=P80?clo0P1<C4`305aLG080HV9R0P1VIVH2065QH@80NWYj0P1fMWH3
06a/K080P8200P2>SXh207IfMP80@T920P1@D50303/k>`80De=C0P1ADE4203/k>`80@T920P0a<C43
028R8P805ADE0P0K6a/2034a<@80HV9R0P1MGEd306ATI080F5QH0P1jNWX206=SH`80NWYj0`1gMgL2
071`L080J6QX0P1lO7`207IfMP80De=C0`19BDT2065QH@80EEEE0P1JFUX205EEE@80?clo0`0c<c<2
02@T90@0:2PX0P0Z:RX201/K6`<04A4A0P0;2`/800<30`D01`L70P0;2`/2014A4@806a/K0P0f=SH3
03`l?080BDU91P0k>c/200L71`D00`<30P0=3@d201DE5@805aLG0P0Z:RX302PX:08092@T0P0Z:RX2
03Ph>080<C4a0P0K6a/302XZ:P80@D510P0l?3`50?ooo`7o000000001?l00000oooo0?ooo`3oool2
03Hf=P80;Bd]0`0G5aL2014A4@802`/;0P071`L200<30`L01`L70P0=3@d201/K6`80=SHf0P15ADD3
05MGE`80L71`0P1MGEd204E5A@80@T921@1@D50205aLG080J6QX0P1gMgL205eMG@80L71`0`1SHf<2
06ATI080NGUi0P26QXH206a/K080ATI60`1>CTh203`l?080FUYJ0P1GEeL203lo?`80D51@0`1CDe<2
01LG5`806a/K0P0G5aL20492@P80G5aL0`1GEeL2065QH@80GUiN0P1dM7@206=SH`<0LG5a0P1fMWH2
06][J`80IVIV0P20P80207IfMP<0EEEE0P1<C4`205=CD`80D51@0P1EEED204I6AP<0BDU90P0k>c/2
02XZ:P808R8R0P0];Bd2034a<@<092@T0P0=3@d200/;2`801`L72@030`<400L71`802`/;0P0=3@d3
014A4@80<C4a0P15ADD205EEE@80D51@0P19BDT500<30`801`L70P0=3@d202PX:0805aLG1@0R8R82
02XZ:P806a/K0P0T92@2034a<@<0?clo0P0c<c<203`l?0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80=SHf0P0];Bd301LG5`804A4A0P0;2`/200L71`800`<31`071`L200d=3@806a/K0P0f=SH2
04E5A@<0EeMG0P1`L70205eMG@80ADE50P12@T85051@D080G5aL0P1XJ6P207MgM`80GEeM0P1`L703
06=SH`80I6AT0P1iNGT208J6QP80K6a/0P16ATH304i>CP80?3`l0P1JFUX205MGE`80?clo0P1@D503
05=CD`805aLG0P0K6a/201LG5`80@T920P1LG5`305MGE`80HF5Q0P1NGUh207AdM080Hf=S0`1aLG42
07IfMP80Jf][0P1VIVH20820P080MWIf0`1EEED204a<C080De=C0P1@D50205EEE@80ATI60`19BDT2
03/k>`80:RXZ0P0R8R8202d];@80<C4a0`0T92@200d=3@802`/;0P071`L900<30`@01`L70P0;2`/2
00d=3@<04A4A0P0a<C4204E5A@80EEEE0P1@D50204U9B@D00`<30P071`L200d=3@80:2PX0P0G5aL5
028R8P80:RXZ0P0K6a/202@T9080<C4a0`0o?cl203<c<`80?3`l1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0c<c<202PX:0<06a/K0P0R8R8201LG5`804A4A1`0=3@d200/;2`803@d=0P0G5aL2
02XZ:P80>c/k0`16ATH207alO080M7Ad0P1ADE4204I6AP80HF5Q0`1VIVH2075aL@80KFe]0P20P802
07YjNP80F5QH0`1CDe<606][J`80RXZ:0P11@D4303`l?080@D510P0h>3P204a<C080HF5Q0P19BDT3
055AD@80MGEe0P0c<c<202@T90805aLG0P0h>3P304I6AP80DE5A0P1LG5`205=CD`80DE5A0`1eMGD2
065QH@80IVIV0P1[Jf/206=SH`80PH610`1nOWh2069RHP80C4a<0P1HF5P205=CD`80D51@1@0l?3`2
034a<@80>c/k100Z:RX303<c<`80;Bd]0P0G5aL2014A4@801`L71@030`<200L71`800`<30P071`L2
00<30`801`L71@0;2`/2014A4@80:RXZ0P0];Bd203<c<`<0>c/k0P030`<200L71`802`/;0P0G5aL2
034a<@D092@T0P0K6a/2028R8P80:2PX1@0h>3P20451@@80:RXZ1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0c<c<202PX:0<06a/K0P0R8R8201LG5`804A4A1`0=3@d200/;2`803@d=0P0G5aL2
02XZ:P80>c/k0`16ATH207alO080M7Ad0P1ADE4204I6AP80HF5Q0`1VIVH2075aL@80KFe]0P20P802
07YjNP80F5QH0`1CDe<606][J`80RXZ:0P11@D4303`l?080@D510P0h>3P204a<C080HF5Q0P19BDT3
055AD@80MGEe0P0c<c<202@T90805aLG0P0h>3P304I6AP80DE5A0P1LG5`205=CD`80DE5A0`1eMGD2
065QH@80IVIV0P1[Jf/206=SH`80PH610`1nOWh2069RHP80C4a<0P1HF5P205=CD`80D51@1@0l?3`2
034a<@80>c/k100Z:RX303<c<`80;Bd]0P0G5aL2014A4@801`L71@030`<200L71`800`<30P071`L2
00<30`801`L71@0;2`/2014A4@80:RXZ0P0];Bd203<c<`<0>c/k0P030`<200L71`802`/;0P0G5aL2
034a<@D092@T0P0K6a/2028R8P80:2PX1@0h>3P20451@@80:RXZ1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0c<c<202PX:0<06a/K0P0R8R8201LG5`804A4A1`0=3@d200/;2`803@d=0P0G5aL2
02XZ:P80>c/k0`16ATH207alO080M7Ad0P1ADE4204I6AP80HF5Q0`1VIVH2075aL@80KFe]0P20P802
07YjNP80F5QH0`1CDe<606][J`80RXZ:0P11@D4303`l?080@D510P0h>3P204a<C080HF5Q0P19BDT3
055AD@80MGEe0P0c<c<202@T90805aLG0P0h>3P304I6AP80DE5A0P1LG5`205=CD`80DE5A0`1eMGD2
065QH@80IVIV0P1[Jf/206=SH`80PH610`1nOWh2069RHP80C4a<0P1HF5P205=CD`80D51@1@0l?3`2
034a<@80>c/k100Z:RX303<c<`80;Bd]0P0G5aL2014A4@801`L71@030`<200L71`800`<30P071`L2
00<30`801`L71@0;2`/2014A4@80:RXZ0P0];Bd203<c<`<0>c/k0P030`<200L71`802`/;0P0G5aL2
034a<@D092@T0P0K6a/2028R8P80:2PX1@0h>3P20451@@80:RXZ1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0l?3`203/k>`<0:2PX0P0E5AD400d=3@@02`/;1@071`L200/;2`8092@T0P0o?cl2
04i>CP<0DE5A0P1bLW8206ATI080FUYJ0P1@D50206ATI0<0MGEe0P1aLG4207MgM`80SXj>0P1SHf<2
07EeM@<0M7Ad0P1/K6`207UiN@80Jf][0P1XJ6P208n?S`<0C4a<100l?3`203Ph>080@D510P1@D503
03Ph>080FUYJ0P2?Shl203lo?`80:RXZ0P0R8R8303`l?080<C4a0P0o?cl204U9B@80>c/k0`0o?cl4
06IVIP80D51@0P1HF5P205aLG0<0Ogmo0P1jNWX206ATI080GEeM0P1dM7@206ATI0<0EeMG0P11@D42
03Ph>080:RXZ0P0h>3P503<c<`80<C4a0P0X:2P201/K6`808R8R0P0=3@d300L71`@00`<30P000002
00<30`801`L70`030`<200/;2`@03@d=0P0E5AD201LG5`<0:2PX0P0G5aL200<30`@02`/;0P0=3@d3
01LG5`@06a/K0P0G5aL201DE5@806a/K0`0a<C4203<c<`80?3`l1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0l?3`203/k>`<0:2PX0P0E5AD400d=3@@02`/;1@071`L200/;2`8092@T0P0o?cl2
04i>CP<0DE5A0P1bLW8206ATI080FUYJ0P1@D50206ATI0<0MGEe0P1aLG4207MgM`80SXj>0P1SHf<2
07EeM@<0M7Ad0P1/K6`207UiN@80Jf][0P1XJ6P208n?S`<0C4a<100l?3`203Ph>080@D510P1@D503
03Ph>080FUYJ0P2?Shl203lo?`80:RXZ0P0R8R8303`l?080<C4a0P0o?cl204U9B@80>c/k0`0o?cl4
06IVIP80D51@0P1HF5P205aLG0<0Ogmo0P1jNWX206ATI080GEeM0P1dM7@206ATI0<0EeMG0P11@D42
03Ph>080:RXZ0P0h>3P503<c<`80<C4a0P0X:2P201/K6`808R8R0P0=3@d300L71`@00`<30P000002
00<30`801`L70`030`<200/;2`@03@d=0P0E5AD201LG5`<0:2PX0P0G5aL200<30`@02`/;0P0=3@d3
01LG5`@06a/K0P0G5aL201DE5@806a/K0`0a<C4203<c<`80?3`l1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P16ATH204a<C0<0>c/k100T92@201LG5`@04A4A0`0;2`/200L71`802`/;0P0E5AD2
0451@@80HV9R0`19BDT20492@P80ATI60P1NGUh206QXJ080K6a/0`1VIVH208Z:RP80Rh^;0P26QXH2
0:2PX080P8200`1jNWX207EeM@80M7Ad0P1XJ6P205aLG080HF5Q0`20P802051@D080?3`l0P0o?cl2
04I6AP80EEEE0`11@D4203/k>`80GEeM0P1/K6`203/k>`8092@T0`0f=SH2055AD@80?clo0P0a<C42
03<c<`<0>3Ph0P19BDT205YJFP80F5QH0P1GEeL2065QH@<0De=C0P1gMgL406IVIP80LG5a0P1]KFd3
05QHF080FUYJ0P15ADD203lo?`808R8R0P0Z:RX302PX:080<C4a0P0Z:RX203Hf=P806a/K0P0X:2P3
01DE5@803@d=1P030`<900L71`802`/;0P071`L200d=3@<05ADE0P0R8R8201/K6`@00`<30P071`L3
01/K6`80ATI60P0Z:RX202@T90808R8R0P0];Bd3034a<@80?clo0P16ATH50?ooo`7o000000001?l0
0000oooo0?ooo`3oool204I6AP80C4a<0`0k>c/402@T90805aLG100A4A4300/;2`801`L70P0;2`/2
01DE5@80@D510P1RHV8304U9B@80@T920P16ATH205iNGP80J6QX0P1/K6`306IVIP80RXZ:0P2;Rh/2
08J6QP80X:2P0P20P80307YjNP80MGEe0P1dM7@206QXJ080G5aL0P1QHF430820P080D51@0P0l?3`2
03lo?`80ATI60P1EEED30451@@80>c/k0P1MGEd206a/K080>c/k0P0T92@303Hf=P80DE5A0P0o?cl2
034a<@80<c<c0`0h>3P204U9B@80FUYJ0P1HF5P205MGE`80HF5Q0`1CDe<207MgM`@0IVIV0P1aLG42
06e]K@<0F5QH0P1JFUX204E5A@80?clo0P0R8R8202XZ:P<0:2PX0P0a<C4202XZ:P80=SHf0P0K6a/2
02PX:0<05ADE0P0=3@d600<30`T01`L70P0;2`/200L71`803@d=0`0E5AD2028R8P806a/K10030`<2
00L71`<06a/K0P16ATH202XZ:P8092@T0P0R8R8202d];@<0<C4a0P0o?cl204I6APD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80>c/k0P0];Bd302@T90806a/K0P0R8R8201/K6`804A4A0P0;2`/5
00d=3@801`L70P0A4A4203Ph>080EEEE0`1GEeL203<c<`80;Bd]0P0l?3`206e]K@80L71`0`29RHT2
08B4Q080U9BD0P2ATI4209>CT`80UYJF0`20P802071`L080MGEe0P1dM7@2065QH@80DE5A1@1RHV82
04I6AP80?3`l0P16ATH204a<C0<0GUiN0P1ADE4203/k>`@0C4a<0P12@T8302XZ:P80>3Ph0P12@T82
034a<@80;Bd]0`0f=SH203Ph>080ATI60P1HF5P205EEE@80D51@0`1TI6@204a<C080Ogmo0P1`L702
05eMG@80LG5a0`21PH4205QHF080GUiN0P1@D50204I6AP80:2PX0`0R8R8202@T9080;Bd]0P0k>c/2
034a<@80;Bd]0`0R8R8401DE5@801`L71000000900<30`801`L70P0=3@d301LG5`808R8R0P0X:2P2
01LG5`8000000P030`<300/;2`805aLG0P19BDT202d];@L08R8R0P0l?3`204I6APD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80>c/k0P0];Bd302@T90806a/K0P0R8R8201/K6`804A4A0P0;2`/5
00d=3@801`L70P0A4A4203Ph>080EEEE0`1GEeL203<c<`80;Bd]0P0l?3`206e]K@80L71`0`29RHT2
08B4Q080U9BD0P2ATI4209>CT`80UYJF0`20P802071`L080MGEe0P1dM7@2065QH@80DE5A1@1RHV82
04I6AP80?3`l0P16ATH204a<C0<0GUiN0P1ADE4203/k>`@0C4a<0P12@T8302XZ:P80>3Ph0P12@T82
034a<@80;Bd]0`0f=SH203Ph>080ATI60P1HF5P205EEE@80D51@0`1TI6@204a<C080Ogmo0P1`L702
05eMG@80LG5a0`21PH4205QHF080GUiN0P1@D50204I6AP80:2PX0`0R8R8202@T9080;Bd]0P0k>c/2
034a<@80;Bd]0`0R8R8401DE5@801`L71000000900<30`801`L70P0=3@d301LG5`808R8R0P0X:2P2
01LG5`8000000P030`<300/;2`805aLG0P19BDT202d];@L08R8R0P0l?3`204I6APD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80BDU90P1LG5`305QHF080>c/k0P0c<c<202@T90805aLG0P0A4A43
00/;2`801`L70P0=3@d2014A4@80<C4a0P1ADE430492@P80>c/k0P0h>3P203<c<`80GUiN0P1`L703
06IVIP80Rh^;0P2FUYH209NGU`80PH610P28R8P309NGU`80O7al0P1dM7@205iNGP80HF5Q0P1NGUh3
05EEE@80GUiN0P1JFUX2051@D080@T920P1JFUX306=SH`80LW9b0P1/K6`20492@P80>c/k0P1CDe<3
03`l?080=SHf0P0c<c<203Hf=P80?clo0`0Z:RX203Hf=P80@D510P1@D50203Ph>080EEEE0`1GEeL2
05YJFP80F5QH0P1dM7@205QHF080HF5Q0`1fMWH208J6QP80J6QX0P1MGEd206][J`80D51@0`0h>3P2
03Hf=P80@D510P0c<c<202d];@80?clo0`0f=SH202PX:0@05aLG0P030`<7000000800`<30P071`L2
00/;2`803@d=0`0K6a/201LG5`805ADE0P0T92@2028R8P800`<30`071`L2014A4@80ADE50P0l?3`2
02d];@D06a/K0P0R8R8203Ph>0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80BDU90P1LG5`3
05QHF080>c/k0P0c<c<202@T90805aLG0P0A4A4300/;2`801`L70P0=3@d2014A4@80<C4a0P1ADE43
0492@P80>c/k0P0h>3P203<c<`80GUiN0P1`L70306IVIP80Rh^;0P2FUYH209NGU`80PH610P28R8P3
09NGU`80O7al0P1dM7@205iNGP80HF5Q0P1NGUh305EEE@80GUiN0P1JFUX2051@D080@T920P1JFUX3
06=SH`80LW9b0P1/K6`20492@P80>c/k0P1CDe<303`l?080=SHf0P0c<c<203Hf=P80?clo0`0Z:RX2
03Hf=P80@D510P1@D50203Ph>080EEEE0`1GEeL205YJFP80F5QH0P1dM7@205QHF080HF5Q0`1fMWH2
08J6QP80J6QX0P1MGEd206][J`80D51@0`0h>3P203Hf=P80@D510P0c<c<202d];@80?clo0`0f=SH2
02PX:0@05aLG0P030`<7000000800`<30P071`L200/;2`803@d=0`0K6a/201LG5`805ADE0P0T92@2
028R8P800`<30`071`L2014A4@80ADE50P0l?3`202d];@D06a/K0P0R8R8203Ph>0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80BDU90P1LG5`305QHF080>c/k0P0c<c<202@T90805aLG0P0A4A43
00/;2`801`L70P0=3@d2014A4@80<C4a0P1ADE430492@P80>c/k0P0h>3P203<c<`80GUiN0P1`L703
06IVIP80Rh^;0P2FUYH209NGU`80PH610P28R8P309NGU`80O7al0P1dM7@205iNGP80HF5Q0P1NGUh3
05EEE@80GUiN0P1JFUX2051@D080@T920P1JFUX306=SH`80LW9b0P1/K6`20492@P80>c/k0P1CDe<3
03`l?080=SHf0P0c<c<203Hf=P80?clo0`0Z:RX203Hf=P80@D510P1@D50203Ph>080EEEE0`1GEeL2
05YJFP80F5QH0P1dM7@205QHF080HF5Q0`1fMWH208J6QP80J6QX0P1MGEd206][J`80D51@0`0h>3P2
03Hf=P80@D510P0c<c<202d];@80?clo0`0f=SH202PX:0@05aLG0P030`<7000000800`<30P071`L2
00/;2`803@d=0`0K6a/201LG5`805ADE0P0T92@2028R8P800`<30`071`L2014A4@80ADE50P0l?3`2
02d];@D06a/K0P0R8R8203Ph>0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80?3`l0P19BDT3
0492@P80<c<c0P0Z:RX202PX:0805ADE0P0G5aL500d=3@802`/;0P0=3@d203lo?`80@T920`11@D42
055AD@80ADE50P11@D420492@P80Jf][0`1oOgl208^;R`80X:2P0P2SXj<20::RXP80TI6A0`2:RXX2
09:BTP80MGEe0P1GEeL204E5A@80C4a<0`1RHV8205YJFP80IVIV0P1<C4`205EEE@80ATI60`1ADE42
05MGE`80MWIf0P1TI6@204i>CP80?3`l0`12@T8203lo?`80:2PX0P0l?3`202d];@<0>c/k0P0];Bd2
0451@@80=SHf0P15ADD204a<C0<0FUYJ0P1EEED204a<C080EEEE0P1QHF42071`L0<0Hf=S0P1lO7`2
07moO`80LW9b0P1VIVH207alO0<0G5aL0P16ATH204a<C080CTi>0P1CDe<203`l?0<0?clo0P1@D502
03Hf=P808R8R0P0Z:RX2014A4@<01`L70P030`<200L71`@00`<30P071`L300/;2`@04A4A100G5aL2
02@T90<00`<30P00000200d=3@80F5QH0P0f=SH201LG5`<092@T0P0R8R82034a<@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80?3`l0P19BDT30492@P80<c<c0P0Z:RX202PX:0805ADE0P0G5aL5
00d=3@802`/;0P0=3@d203lo?`80@T920`11@D42055AD@80ADE50P11@D420492@P80Jf][0`1oOgl2
08^;R`80X:2P0P2SXj<20::RXP80TI6A0`2:RXX209:BTP80MGEe0P1GEeL204E5A@80C4a<0`1RHV82
05YJFP80IVIV0P1<C4`205EEE@80ATI60`1ADE4205MGE`80MWIf0P1TI6@204i>CP80?3`l0`12@T82
03lo?`80:2PX0P0l?3`202d];@<0>c/k0P0];Bd20451@@80=SHf0P15ADD204a<C0<0FUYJ0P1EEED2
04a<C080EEEE0P1QHF42071`L0<0Hf=S0P1lO7`207moO`80LW9b0P1VIVH207alO0<0G5aL0P16ATH2
04a<C080CTi>0P1CDe<203`l?0<0?clo0P1@D50203Hf=P808R8R0P0Z:RX2014A4@<01`L70P030`<2
00L71`@00`<30P071`L300/;2`@04A4A100G5aL202@T90<00`<30P00000200d=3@80F5QH0P0f=SH2
01LG5`<092@T0P0R8R82034a<@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80?clo0P1<C4`3
04i>CP80C4a<0P0f=SH202PX:0804A4A0P0E5AD500/;2`803@d=0P0A4A420492@PD0ADE50P1EEED2
05QHF080BDU90P1<C4`205iNGP<0Q8B40P2ATI4209JFUP80/K6a0P2UYJD209bLW0<0V9RH0P2FUYH2
09bLW080MWIf0P1CDe<204U9B@<0D51@0P1bLW8205eMG@80G5aL0P1>CTh20492@P<0ADE50P1QHF42
05YJFP80Ti>C0P1eMGD205QHF0<0EeMG0P15ADD203<c<`80:2PX0P12@T8303Hf=P80CTi>0P0f=SH2
03<c<`80@D510P1ADE4304a<C080EEEE1019BDT203/k>`80G5aL0`1QHF44069RHP80KFe]0P1QHF42
069RHP<0M7Ad0P1QHF4205aLG080GUiN101QHF4304a<C080?3`l0P0k>c/205QHF080<c<c0P0T92@3
01/K6`802`/;0P00000400<30`T01`L70P0E5AD201/K6`D05ADE0P030`<200L71`806a/K0P15ADD2
01LG5`<08R8R0P0X:2P203Hf=PD0oooo0Ol000000004o`00003oool0oooo0?ooo`80?clo0P1<C4`3
04i>CP80C4a<0P0f=SH202PX:0804A4A0P0E5AD500/;2`803@d=0P0A4A420492@PD0ADE50P1EEED2
05QHF080BDU90P1<C4`205iNGP<0Q8B40P2ATI4209JFUP80/K6a0P2UYJD209bLW0<0V9RH0P2FUYH2
09bLW080MWIf0P1CDe<204U9B@<0D51@0P1bLW8205eMG@80G5aL0P1>CTh20492@P<0ADE50P1QHF42
05YJFP80Ti>C0P1eMGD205QHF0<0EeMG0P15ADD203<c<`80:2PX0P12@T8303Hf=P80CTi>0P0f=SH2
03<c<`80@D510P1ADE4304a<C080EEEE1019BDT203/k>`80G5aL0`1QHF44069RHP80KFe]0P1QHF42
069RHP<0M7Ad0P1QHF4205aLG080GUiN101QHF4304a<C080?3`l0P0k>c/205QHF080<c<c0P0T92@3
01/K6`802`/;0P00000400<30`T01`L70P0E5AD201/K6`D05ADE0P030`<200L71`806a/K0P15ADD2
01LG5`<08R8R0P0X:2P203Hf=PD0oooo0Ol000000004o`00003oool0oooo0?ooo`80ADE50P11@D43
03lo?`80@D510P0o?cl203/k>`808R8R0P0E5AD300d=3@@02`/;0P0A4A4203`l?080ADE50`0l?3`2
05eMG@80K6a/0P1EEED206][J`80HV9R0`2:RXX208j>SP80WIfM0P2RXZ820:JVYPD0QXJ60P2ATI42
09bLW080^KVi0P2GUiL205YJFP<0D51@0P1EEED2071`L080Hf=S0P1EEED203lo?`<0ADE50P0o?cl2
05iNGP80EeMG0P20P802071`L0<0ATI60P1QHF4204I6AP80=SHf0P0c<c<303Ph>080;Bd]0P12@T82
03lo?`80:RXZ0P15ADD30492@P80BDU90P16ATH20451@@80BDU90P0k>c/3051@D080EEEE0P1QHF42
079bLP80K6a/0P1RHV8305iNGP80LG5a0P1[Jf/206a/K080Hf=S0P1/K6`306IVIP80C4a<0P0o?cl2
034a<@80;Bd]0P12@T8302d];@805aLG0P0=3@d900<30`@01`L70P0=3@d9014A4@800`<30P0;2`/2
03/k>`808R8R0`0];Bd203/k>`80?3`l1@3oool1o`00000000Co00000?ooo`3oool0oooo0P15ADD2
0451@@<0?clo0P11@D4203lo?`80>c/k0P0R8R8201DE5@<03@d=100;2`/2014A4@80?3`l0P15ADD3
03`l?080GEeM0P1/K6`205EEE@80Jf][0P1RHV8308Z:RP80SXj>0P2MWId20::RXP80YZJV1@26QXH2
096AT@80W9bL0P2i^KT209NGU`80FUYJ0`1@D50205EEE@80L71`0P1SHf<205EEE@80?clo0`15ADD2
03lo?`80GUiN0P1GEeL20820P080L71`0`16ATH2065QH@80ATI60P0f=SH203<c<`<0>3Ph0P0];Bd2
0492@P80?clo0P0Z:RX204E5A@<0@T920P19BDT204I6AP80@D510P19BDT203/k>`<0D51@0P1EEED2
065QH@80LW9b0P1/K6`2069RHP<0GUiN0P1aLG4206][J`80K6a/0P1SHf<206a/K0<0IVIV0P1<C4`2
03lo?`80<C4a0P0];Bd20492@P<0;Bd]0P0G5aL200d=3@T00`<310071`L200d=3@T04A4A0P030`<2
00/;2`80>c/k0P0R8R8302d];@80>c/k0P0l?3`50?ooo`7o000000001?l00000oooo0?ooo`3oool2
04E5A@80@D510`0o?cl20451@@80?clo0P0k>c/2028R8P805ADE0`0=3@d400/;2`804A4A0P0l?3`2
04E5A@<0?3`l0P1MGEd206a/K080EEEE0P1[Jf/2069RHP<0RXZ:0P2>SXh209fMW@80XZ:R0P2VYZH5
08J6QP80TI6A0P2LW9`20;Vi^@80UiNG0P1JFUX3051@D080EEEE0P1`L70206=SH`80EEEE0P0o?cl3
04E5A@80?clo0P1NGUh205MGE`80P8200P1`L70304I6AP80HF5Q0P16ATH203Hf=P80<c<c0`0h>3P2
02d];@80@T920P0o?cl202XZ:P80ADE50`12@T8204U9B@80ATI60P11@D4204U9B@80>c/k0`1@D502
05EEE@80HF5Q0P1bLW8206a/K080HV9R0`1NGUh2075aL@80Jf][0P1/K6`206=SH`80K6a/0`1VIVH2
04a<C080?clo0P0a<C4202d];@80@T920`0];Bd201LG5`803@d=2@030`<400L71`803@d=2@0A4A42
00<30`802`/;0P0k>c/2028R8P<0;Bd]0P0k>c/203`l?0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80?3`l0P0k>c/303lo?`80C4a<0P0l?3`203/k>`8092@T0P0A4A4300d=3@802`/;0P071`L2
028R8P80?clo0P1<C4`30451@@80C4a<0P1VIVH207IfMP80J6QX0P1jNWX308R8R080XZ:R0P2VYZH2
09BDU080WYjN0P2PX:0308n?S`80Q8B40P1iNGT20:6QX@80[:b/0P2WYjL307AdM080G5aL0P19BDT2
06a/K080Hf=S0P1ADE4304i>CP80?3`l0P0k>c/2055AD@80CTi>0P1bLW83069RHP80>c/k0P12@T82
03`l?080<C4a0`0h>3P202d];@80=SHf0P1CDe<20451@@80>3Ph0`0a<C4203Hf=P80@D510P0h>3P2
02d];@80?clo0`15ADD203`l?080CTi>0P1QHF4208B4Q080QHF50`1dM7@2069RHP80GEeM0P1fMWH2
06a/K080PH610`1/K6`206IVIP80EEEE100k>c/202d];@<0:RXZ0P0o?cl203Ph>0805aLG0P0=3@d2
00/;2`L01`L70P0=3@d2014A4@805ADE0`0K6a/2028R8P803@d=0P030`<203Ph>080ATI61@0T92@2
03<c<`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80?3`l0P0k>c/303lo?`80C4a<0P0l?3`2
03/k>`8092@T0P0A4A4300d=3@802`/;0P071`L2028R8P80?clo0P1<C4`30451@@80C4a<0P1VIVH2
07IfMP80J6QX0P1jNWX308R8R080XZ:R0P2VYZH209BDU080WYjN0P2PX:0308n?S`80Q8B40P1iNGT2
0:6QX@80[:b/0P2WYjL307AdM080G5aL0P19BDT206a/K080Hf=S0P1ADE4304i>CP80?3`l0P0k>c/2
055AD@80CTi>0P1bLW83069RHP80>c/k0P12@T8203`l?080<C4a0`0h>3P202d];@80=SHf0P1CDe<2
0451@@80>3Ph0`0a<C4203Hf=P80@D510P0h>3P202d];@80?clo0`15ADD203`l?080CTi>0P1QHF42
08B4Q080QHF50`1dM7@2069RHP80GEeM0P1fMWH206a/K080PH610`1/K6`206IVIP80EEEE100k>c/2
02d];@<0:RXZ0P0o?cl203Ph>0805aLG0P0=3@d200/;2`L01`L70P0=3@d2014A4@805ADE0`0K6a/2
028R8P803@d=0P030`<203Ph>080ATI61@0T92@203<c<`D0oooo0Ol000000003o`00003oool0oooo
0=l0oooo0Ol000000003o`00003oool0oooo0=l0oooo0Ol000000003o`00003oool0oooo0=l0oooo
0Ol000000>?o00000000\
\>"],
  ImageRangeCache->{{{0, 226.188}, {226.188, 0}} -> {-2.05806, -1.93458, \
0.460309, 0.432692}},
  CellTags->"T.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.6"]
}, Open  ]],

Cell["This applies an image filter to the data.", "Commentary",
  CellTags->"T.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[ListConvolve[{{3, \(-1\)}, {\(-3\), 1}}, data], 
      Mesh \[Rule] False, FrameTicks \[Rule] None]\)], "Input",
  CellTags->"T.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00971251 0.0192308 0.0103391 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
99 string
99 93 8 [99 0 0 93 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
9E6395837C90A282688B8A4F6F8C706F6447B0BDA4785289181E4CA2CB94762F74996D68
6360766C6D88758C7C7F897CA18580D49BCE98AC99919C97797D49583E65656F614C2236
5A73306E4875B659795B7F8A7D388681586B3D7EBE665975949CBA
92918F6D61796D76959E58747C75806C829424437EA42F5DBEBE541550986CB56F757195
6C734889826B8675978C7864D29993B9A781DCAE939E837188837D908065656F666F776A
4F154098A19A398160705C65426C6567887DD4814CA1A1715D4350
97609186868C807D97957597708B7FAD796B8B80559AF47C5B73BFA2609B818CB6B18C2C
67597D7C829D757F75898EA530ACA03582CF7A505D486B6F536C92658092797877717474
5947A74E9E7961647E6578608B90C0B58E6B34778A61576E43896C
3A985D6F776A8177A7688271795A648C648F9153A02B349D797A74A5B733B68AD25DA26A
616F8889867C9AA57975A68EB692908C412F4B87BCA38B9A736E5C756C779C776E857578
6E6B4B3F5464717F7C60837A7E983E153D5548977D5B7052918C99
8553A5816790829876714771767F813FAF8A7F625999896D9E6C6B397AB19A9D2D993A7E
629597878A6F7C66CBACDBD9FFC8EEFF9D77A3CFFFE0FFD7C5ABA36A78705275886B7C82
7F7F6B6B45558366716F5E785A435E88758A8E14426862A3977F5D
7E864997A2738982A28767956C737AC27E863EAE985582486A7C857F7C623861AA665574
7E8C6B6A818190948EF4A6E49BB59468888E6F7F5BCF87C2CABFB9978F74759379897C7F
7F7F7F75675C6CA270929B4B82758A837D61429DA2AF827797749E
7EA47E9D639558686F609D51867AA0936B909C6D7A928094A3B4FDFF5C92D04C00336585
8F7CA48EA2CFC1E8FFD3C1E5ABE4E4636E09B1DACF7F8EC3E2D5C3AECBD2947C807D897C
7F75827F7F757C3EA3A3508A676F686EA6C9BA8798808B83646C6A
6F668857936299A560747A717492953D6D606C919193838B656B1C3AE875777D685B7D7A
936F78C9BCCBFEFFA8D3B1ABDCFFB3580E8A002DC7E2E8B89281C2E6A870AA9BA6927D7C
7F897C89717867B4527F9A5573655E5434334B3E4E67786F878CA0
7E7DA17A8775886C92AA8781B1A66C75C66FB9783A878E7CAE7D59181E5B134A487A8A7F
7892ACA4CBA6C6AAB7B5C28B8B07000099827400005D9B819B625D789DB0B3A471AF7F83
907875827F756E494C3C53B9746E6A63815A7CA04350657E665A52
778160947CA15C87B83679B3744F7A712B6B8262AF835E7A476B82AB676E352B90717C82
86B3E3E8B7BAAD7D8178876F43000797778689753E00468294BC7A808AB7A181A787A381
8A948A6E8289716E86868E8073827F89978768857F7F9D7578998F
9E9B67718586947738977874808A89C5A3A7498A5750ABBE7588AD6B000B4F7C709C78C6
B5A27881A8BE4A489B68863C0006839393827C7557512B2C7A8AC7EE7A86B8BABC87A2CA
6B75778289867C757867523970687A746A999B7489A4646C657358
9362A287A2495AA1917E76AD9C70894274647A8FB1CF7670954C071B87677A8F977DA291
B5CF86D08B606AB481A22700004ABC79CC768A8A680011381E74EA68C7A08A6EAAD0BE77
A08CAC9C807993B1809D877875787878675C6C79857F8C9C747FB8
64776A6D559090796E7E8F4F5B9053987C899A756B535D754B3F4A5AB3DAA489BA7C89A8
C78768647FE7F89C824C3F009E9BA58B65B0819487940300878553B7EBC9CBF07C6582C9
ADA176617785898C9B85A57A7C7F7F6B6B6D5C627D4B5251855C53
767F7F8997769A76868387898F7F87A1736B9A67634E5A08415C64D0C8BEA68963A6AD94
6E83F7E4A15D819D8668347C937CB5F0DDDBB38A8B8783537C7E417999B6ABC1ECF93D71
C5AA60897D897C64B4B4A8C8858778897C7578787882A18F879B8B
8A868E796E855362737475996E6B764F917852A06C654C5A4F708BA4CE6167546E79ED95
68A878808B70868F5460EFD192C3F6F3CBF1FFE8CCA3AEFA985C864F8F82661B8B54E161
228ADD9888767F90809197B1FFC183797C757878677E6777D29B85
6E859A6C82867D8964806375719D88737085575D4F6C5A7FD2FFFF9700556BA0D8ED6194
D8512F33C3A0667C817FF5AFFFFFE483CC98C7FFC0B7CA87FF8A51A567584EB31D376EDA
BA5C88DE9B867664607890B141B3F39B828A787F7567666F4B4C57
8C7C49A28A94876FA7A2AF4B75758590736D673F655A87DDA4B949346F68A3B0AF7D7F68
537CFFFE6C437E819EB828DE8FD063929D8778A7BCE69E7A35D5E35A6A6B92EBFCBF6C78
B8BD7893B9798A797F755359A58293D5BE7A808690787F7F6E7A93
8A837C787085789C686F86A19C865776785B6B6F7E82B5C19C14528068577FAD5051775C
40D9776D6C6598997F934F97B55B7AA76295946C9D80827605C7B8C06F81546183C9AE31
5493BF2A5E917582758CB15583D4AAA1B9AF8B736B7C78827F899D
667E8C717867886E99936C67776A8864957A909491FFFF763D2C706365978671BFDAAB75
E58E712000958C8B4800508F8BBDB090757E976D8CAB8E7F1A00785B7A73B864505DDAC8
6FC09ABC76A8A5667A593F9961066198B5F0F87E77867C646D7774
8A7392A58B987A7D6B577E8F71787C77357E6DAAED9321627D9A61547F95CAD3A19A5ABF
587C8936BFA1683E235E38D4C87C7DA8B4DE6F88ACA7D4597919005A707460788C873FA7
C23475E6CF93949D775B79667C8E3F6E81BCB3F5AE8B70896B7064
79867660685889818C8F6B91927778749B779AD8D18B314962336C7C7C823C48556D717E
895482D07D8559287790996577B39EA2C993D08AB498769883A0586A646DD77D554E5D33
4080310198CFB1666474645B7082AA3C0E1781B4DBBE796C787C77
92977D7D75827F976A9890605191676568A5E8B4101D68335C8F6D7F7074859D9382F080
ABAF9B7C776F956C9B7E9BA19CB4A89271828FC3AD8CB3A3837A8864586314909BA1A482
B8B0B1A324174FAE79785C666A6C6E92A16F3D5C708A7F7F757878
5C556F809383677F95677470865A638CC2F39E0A64927870747086D3F7DBDDA780BC89E0
A282837E6D994689635778A5A7788268A77489A788D2B57A857A536590779279C9CBB8DA
936BC287A199894B87888E733455888A9BAE62428E92D471837171
867F7F6E8F9D8F546C719E8B78867D90794C5DC275545388897DA4AFC2C3AFB8C58E9E98
7595348BAE413A6F836467B67794746F7AA1648597748A907F338AAF8571A0574C7F869D
B8A55A999DA29EDEB56B756D7C611E8B5B87EAC1677CC6AE718686
789389945B666F8F65876E665A608589BD7461153D587DADAFBFBABD785C0F35B3606A6E
CFAEC6748674A35557A4C234B83CB6835B49946164748AB0AEA6538A63593A333D67A387
8B91C5BDE2D4AC919ECA719480676B158E6F25AAD09C8ED9AB6F67
8C67866B867F89868675748E93CF62BC82923341797995B3FFFFE475796BCB5A0E8B66A2
857E777A194A8B954EBDAC752EA06259007094875E676F60A7A5873053923D8F9C47126F
6388522D2D47AC99A4C0D375768990642B24A14151AD886C9B8879
7C898686716E8697857A7F5D7340D08758424C8E9D91E5DAA567635C4797647E5D6D7C47
494E8321C9275E597A87C6355D8682423C6A97918C5A67A5767C8395856DA5557F6E976C
436286A17C8362A37689B8BC6E716E867561117F78502FCF949E7A
788C67A1918A78788B7171859068BA77505E8582B1FFE67D618785A8BE5E81B88E5C8E73
3858409B24CC62657F4C5BAF35543D19A1786E71645E368583655233C78C765A8B719B63
B13A79A2B9B3956C8E7A82BEFF9C647F756E75346491C64CA3A58A
C66E7D64778B876170807A8B7CAE7989635EA1E4FFA3AB993CB59EB786A7BC83B5ED7C86
6E824C7F856B9798757F75498B1530CABD601C7C59616D808C757E5E587C8C8A74B45D70
93C8333F577786BD8975718079D5DC6B787F757897354FC6A29DB9
357C927C7F7F75827F7F7888ACA5AD4B71A8D2CB919557857D809065A49D7186D16ADBA3
BD8FCB61CC8E8265DA6D97658F4C3770731C010C485ACA895BB78E9A5B87939A958B889B
749DC9B0A89E8186B4A8939AA7B7C1F568807167308B850960AE9C
897C7582757C817F537D856E6DA5495EBEE2CB816B665258B093A797497FE882B6918CCE
9EC95974030B2D94AFD3688C5E7EB176435575425D8B6663A698B46089C364A2A38E9AC0
6895CFA2BE5CD2936F90BD65767C887DDD85737F5D5B85AB616689
738293678F827D6EA6856F82975C4BA79A8B77A75D7548425A546592EDA754FF21976D43
BD978A458657879995784F7A906E51497F6F79799D80468AAA97B399004A004FA4A3879A
BEB79A7A70BC2586744B85837C80718A83E2936D7F5A3E59B37C9B
BE77678C7D6E857561628C7F8C709AADDCCCA64A3436868540689498B9D1C11D8A503C79
1B1D91B751C6A1BE89545D5E6D7D517F4B95993D525E737F53A66A9B813CB6AA6364866F
702B78D99188AD59CC9053D7A85B7982977AF77176785C745B8EA7
508E7F78778C8686869D858A8A6291A7BA7E41656F5A8B79958C9DC79C76021D2D483A17
5235223E7E9280996C89405D436A66617640429138687445B49A9EA0A85EDE7F17284F37
38585441A28AB757389C8F762F5D50749BAF92EC67807D3C453C58
796E85867D6B867F646662AB867366BE553D5B868EB1608AA2A2E59B4035814B35253C4B
6D52575D3D8EA26E66777E604A587866766E87715E556C884A39AA956566466346473F42
6150483E1A716ADAAF7E666D9E81899C603F4294B46E7F9A65747E
85867D7F787A6677856E7A8973A78A8F5C60AE607F6375D0CB6E91261A2300396B878752
000815685C8CB46B51486E6B686C6E7A62A57661A7647765576174BE85770019556F6D36
51732A4F53354881CFB19C4B738E986CA1BC7F4F869C8071826463
78827F7F7F7F75787170A7745A99B74297B160797F80C254A4FF120025CEFFFFFFFFFFFF
FF2322A0AC7D744F5A4754667A824E7CC66A758C5A87544A70A06777A58F4A620E261A68
82536B202A3152514A8BD1A2BC977F5B3F438A85C29B788C8A9465
89757A7A81908A94878E9A7AC05EAE8B4361998CC3A0B3AEB54E0027FFC5330000005E88
30B5772EE7B6494858897F6F66649590718B577494635B8E86627E97BF6B8F687459FFFF
FFFFFFFFEB47112F6C7A6FCA58C5996F868A639161778B7D7F7F5D
7A93797F7F6E7E70856B75AA917F8966785B9A6A6DCA9BC64E0040FF2E00006A75200000
006AFFCAB750556383618E748C78806B6B6D7E5743986481745150656AA6915177A7FF76
2700277EFFFFEF0033606C78B155CBAF8686795DA5767881786681
7C7793797F756E867FE49DD26A8F506176984E8E7F9763932300FF480000A57D86894600
C7FABCB5547D3E6D3C9A50B46871A05BA08F66B7785364672A775D3453BDD18F6F530053
11000000213EFFFF00209E9BA8A43AABAF6C9DBC4C88A18FB69C90
6775857F7F89907FA86A70528999B478607471A1B9919031008E940034938893939BD1F4
B695946B20484167685392647E8C7F993D92907DB0978650826453549361AEDBCB860000
00179255000026F1FF1A10D88994676294C2616A7D937986769291
786E75857F7F757C456B935176B63D7F9C7A85C7BA74683E8CB15E5CD0B9FCFFFFE3C553
674E6A75655473648BAE8A6F776B87647E866D556D98956F924A558B4B62A0C0BFFFA860
42937F897C0C000055FF0119D5C1D7C55E2DAB6C9B7E837D6E8B7D
8686678C83738275896299876D73956F82678A55387688479C8C439EA0AFD08678A86095
3D9371518664896E855D6FBE70858A707185A4519E5780BC6C78665283914F687491EBD3
C2A28C98878227544279A810355CA1A1989E816F64829262806A98
8275787C7A8B7C8990B198708C8B5BCCA2D49230500F288C9068AED3FFD25571647CC388
B5B47A7F7D7F7F6EAA6CBA3D8FD38BD0AA4F73977D99A266826EA357677D8E5A6F5992B4
E0DCFFAA99A1A03C7563F42D85865C588671709D7EAC5E85538781
758C7C6B8C738C97AF91798E9170852A3D5B95C63F613D86BCDCAECF0E856E4791877DB8
985C8992936F8B8661A66798A7519079766B65C07797549165804B984E5CA4A7948A5989
6EAA87D7E3D78960365C3857091A2D7F80C7A870766A9E6695795D
7F75827567998073AEC8807F7F748CAB9E8A6F55F98AA8808C6B87556461AC974581585B
6E87C3739A8C6DD39070AB636C877F8975BAC76EB4737D78748AA8706E776C73AE9D7E8F
825D7F7FACB4F6FFB06D5DC56B7C9E82A64B4FABA38589807D6E8F
7F897C7F757C708589936A9491A06E739B77A49B2B89A8DB60772A556B736691A56E8360
8CC881657086AE62988C5A97706482889887807692A2757E786A68A18F8574AA6185B876
6B5C7864737D46359489A88F9D5A806364928A6A7E8B7C7F7F7F8C
7F75827F89719D87A8586F5B765B68779D411E79A29A770BB658B6528C774593A7CCB588
8354A0AE6A8E636864927D907DA03E94598F3E8A4624978A8394956EA68A7EA5645E6A9B
8A9B4F923D5B6673747FA09D5D8631374F9381A4986C7A9C808C6C
7F7F7F7F7F7F89B5586E6587585A5A7962BA9B6AAAAEA49B4EA83C929393CA6058642E7D
B9C04276AB799BA155558C98957C877CA76778907093736073A58C8F7095978C92586B78
7A7CC56889678C588B7C3D6DA171B78FA07E7A7F7F8C959486807D
827F7F7F7F7578BC79598A908367B576796C97A58187348C7C7E9B587CB66B8A6E68BA93
519180A358CF756DAF6A7070D3689577BCA1BE6E5785AA93A0598A6691908C7F8A8F577D
73602D5E80865383356AA36E6E7887A6976F9478619D8C89807D8C
7F7F7F7F7F89AE7F91A6947D909782887E4574506A7FC395855D7A9B773F739BB9A0777C
936B9861A8888C718B9A7C91869C5C76743E9D65C0688E7EB090928691A09360A7ADA86B
90C097627D708F909A778F688F9A89822B5D7F7F9C8A97A7905283
7F7F7F7F7F7FB58588AF6A5B857E798F85D789A1C3777C778B9A86945B597E6D4E779C6E
9A669C8171758AA58977828137908F9CA08870E06DA04E70747F528F9D5A59B74C8F9CAB
7E8792BA687877A76F87589C4E68595A8E8A8995986A6B79B9B02F
7F7F7F7F7F89A19481858C838995837A2B547F7652AE3F7361356D8BF6B67A7376AEBA85
AB9557B067A47A5EA476B8A58AABAA4976BF80A78A6F779D6C827578823F6F709C3F4854
70526A82787C74438385899A977E8686D09575586D64818C5393E5
7F7F7F8986B87F9A5251858A8E625E4298786688381A7D47A77D81885A688AA1D9784AA5
23395975CA8FA29882E26D91997AD49158B3553EAC9D9B679D6C8CA457CF675DA58E856A
8B7D908781948F595D768E3D688A657025817F7F65B0648EA7B476
7C7F7F7593D1762BAD6B68886E636FA3545E5E45876D877F57A7626159758FA8C5743954
65525D877F5882936571B84678616AACA6B5863C63998C8A87AA806C8A7D6E6D3DA592C1
55889991CA6A839B7C6F5B6E645587827140665987618A6E8B8A8F
827F7F89866B779E6851754B78817074A6A0A6A05A90B192948F736C57C1E7822A578049
785C7D55606D9478C7753E9A62AA5298886099879579994AAC57CC5EAB67935B7F7F6865
B35D577E6ACF978A8E857A6E8B875D71B6CE85BD9C4F7F535C535A
897C7F7FDAB87D5B778B7D7F4968787190829E8871777C8F4F76B3A0A8544E854E4A469A
5A817F6CA45A48A5436F949DADCE79B39A5BC685A5B38AC567BE5CAF528C748688679348
6BD2717862468B678F838ACB82A1AA9B6F49804B63B79DBE83869E
75828986939C8EA2C1DA8E8F956D9571636E41468C735987A0908E6D8CB1775760546D8B
5A85859C64ADA7607D9283AB6F8CCB3FD2A19EB14779669D6486A17A8A81805578387E60
97757A66B7804E877A637C6F8C6F734F6882677788556B7387715E
7F7F7F89938B8CA13F498C614AAF6F9C688A8E79676C4F4574596B859C836A667C4A9C49
A490746C5D93C08092AC7451B974A07E46A881939C7D78B6819D8E839961907C5D834B6C
4866A08A79A18F836DA25D73496B82787166909B7C9E70583F708C
7F7F899DC1545947757D4E79D181A28BC39170A46C9C6F8887AB73857364679E7C996C82
716C6F408C6BA8ED507ECAA3A775979B871AA2E06F68A0B6BE778C976E817C8773538198
8246655E5585768E97878364805252B1676C686B64637893AA5887
7F897C9A655C717A5E4FA7A7517F9790415E7C42AD639D817167AA594868684191A66C7A
886F8AC37C6E509AB8B54F6FBD9C6C735BC230939083AE5385CE735C6EBA826777738586
8E6C8A7D7179714F7663A665BA7E8A3DB18C77786A808F748FD55A
7F7F895040A68B4A8B9B585A7E7E593F5C6E5591785C928A596C6B938646765C6C91836C
7EBA875454A83E99FFCE7A4C6A394C856775647D76AFB0749D7091A29374537381BA6C89
676E5892605A8F6E6D5E678B61897F6E55707F7C706D87788161B8
89716E7C3C67889C795C6FAD7D758178998BD07966A05155795B6C8E7E7F866C817379B1
6F46A6789741B34189999963604527A168798A4E994C9CE6A876949464669083A8709748
74AD915D7D8659956B853F73589053A55C77855D8A7F217966704F
7197787860518878717E6A396A4F5E9E8187786F775E858B4C4B6A54639C606D74646F95
6A6D4AABA38F64850642A76F40A3AA6F9D67797579AB466CA5688781814BAB8A719C6585
A49E6A70855797825B8AA1747866885D837793A86F7FBFADA2798B
827F7F6B5A1E61957C73625857926E7E7A813C708175917A7FB17F795A7E40A33A6F7443
A0895C534E953FA52C525787C7A29E21A3719A59C67F3F5C5BA2518670957385926B7DB0
767688657983575AB8576D779573819A6C7C59978C7990736D7883
7C7578827F6E5994B997B0A6977A93528B756B8E65946D739C706382745E857A8B647D90
817D7F975248CB34B463854C6159A56B43806B7763B3DA2A9A71903080948B805E7C8A5E
53406E87707E6688679186975B7E714FAC7664458B785A6E75A176
8C7C897C7F75467C83A89A89AA8659896779A25D6F4E6A8C7F53656E896E8B9485997589
9A8CA377B9825C88B57A929243826C5E358579AC2E7E4ADD2D8B45A79060C3AE5BA88063
7979718B948F9974C65D93798986867C538E7F6E5C977C6E5C5A89
827C758275826448798BB0932F5C817E77714F6F808C82546B946B5C5A829B488F868771
3CBF8C879BA06D2C655BB65E7F6D784797818565735D5DB72466757AA29774467A6295A1
798E79897C57648C2E9381648F7367888662998A795D58509E7C5D
7C788C7C7F7F90516E46346AC09174536C5BA6997EA49AB893888891AA75769291639D95
862CB0606F7D50C9076E6E91807A6FA364816F20AE45804FB33095786D7C506EB3867F76
998891955D877F7F8982518E647E89769C9859669B68A076388C93
97767F7F7F75716A7A94A8A54F97AAB3B37E668BA5716153807EBE8C637E817524877D93
C075489776AD8B58EB806DC54360876A6878857F3864824394868764879A519C94687D81
6E7485619065AF8C6C9D767F7F7F78815D79BA6D5383A4958F3961
64927C7F7F7F7F7F7FB17F738F7A78889189629E7E7677718B836F6C8E7D6780815DA886
689C5C63706AB85E6DBD8559BC5765C0B7595E747D8C677C678F657D904B6D916886A74C
74876E746D7D9368855D808289868273826E4FAC766E48827E9578
7F75827F89867C905B715B6FA7A46F7F7F97A6626C766DA86D593C788A7F7F908A8A7377
64907DAB775877AB5E9A57A867BD1E958A3C686C62A16792859D7A98258C91BE43744EAA
708894776E8F93886870907178717E816B8C7D6B7C896C74707C71
718C7C7F75788C8C795398717565AEC766666F94636C7E46718A6B6B668071928B798676
70A0B66ABCABA3A27E18E6CC134A709A749941ACBD5785A4A29E8A809D74902C77739171
71777668996F5A717E7C8178957F8E8A94657E817F6E856492AE89
867C75827F7F7F9ADB89778E62AF6B34AAAFB45AB3A29A9C99787DB1677A6A51808B5EA4
CE7D83747E986D6EC9A50291A63ED170948B5A677988817A2859CF878385B15292826580
92796EA66374488C7A886C955E887F7F7F898276929476A163417A
827F897C7F8982DB556E9780835B6C82484B869C6A737A614E8CA64AAE63857F97819355
688A86D13A536370AEBD7E63898BA37FBE4EA686765181628768738C685D499C94AD3E5C
9773717E9279936E897D757185785C8566887F869880A760957975
827F7F7F7F75EEA56A88ABBDC7A8CB64948F6A915968587CA18779865B9B9B8B95938676
8064B75ED99280765E796D8E9E924C82786B6FA575579048A88F5C77AD785E8975577D85
90796E8B73826B7585788B717882897197647F817FA7A1B3AC8A8F
7F7F7F7F7F9ACE9179AB80ACC2595A7F7DB7664B91AB8B917675718F7C647E895899A6AD
7F894E8EA18BE6A74E5EAE30559877815063B9A361796471C094756D70B1A0688175B19B
596F9862A2918A7F7688837D7F7F7F7F86A2797D7860834F7FB0C8
827F7F7F9AAC6342734A915853997670B45E419597666A6D6D887567AA747FA48A816170
769C7476AEA674B36025B648B749B5933A92B5704F77947A9386CB676A9A64B1D2877C7C
9788A28977909BAA747D7F89977D878675778C978773598C575046
7C75827F7899704881993C64304079741850BD59454F7C817063947C86CE8C75B46D8698
9B68C2A689B5B794B3794AC873BD20944A6F6C4C64C17C8139884A927FA4AC6C89908C97
939D787D977E7D868775817F7F7F867389878C6874855A60798664
7F897C89BF9E8B4C5049404F7AA16DB87E795D6F7E7882758286739D8779A46FA56F686C
A39180935C45997AA29925BE6C705C5D8F7F535BA763976F676A93A4867177C65B948A87
7A86879366857F5D808278816E99678F7CAB60B77F797F90737782
7F7F7F9A87838C8094DC7F8174636B317A796A8181897178827FABB0AA706C9971819068
9C9C8394835500A4276E773D766F6042657880706DA593617F88689DB47C839399749091
8F9C8782A48988839078757889738C71825D9B837CA18FACBA8A83
78827F897C50126C8219B06D948A5E7E7867927178827F8986908991818CA89853A77589
A763737E929E65399E795E4AAC7778606C714A64889C6F7436A6888FBF719D9574AB7AB8
7F97ABB7669D9397AD8E8F766E7485896B706B66B3A1C79892ACBD
827C9A764C7F66907DAB636279B0D26F79758C7C93787F7582909E8E73A59E6D5878A1AF
3D9C5C974562C1826140B13D74A790988B704F678C9D5DC39A73488A6DA19497B76C7E97
A0978A528B4973897F897C89716E7171866E7E66609387AE7C9583
82897CB16E677695515791DD776A73BE7D945B886B868986827D7F7CAFCE6061ABA3797C
90A86567557C71716B927585928685A1CE46996FB15E747A9368856783737D8B7C868757
7E765BA78A8968928B916D82897C7F7F75827571602A817FC9A191
8986978E997A6C6DA8AA817F656F625CAA878A8A9487838C949E7F7EE3675D8CCF9DC391
AF706F36AD895495098A66805DA69179D9AB7E77644F8576652ECC43628E7885929A748C
816F68666FB4887088949287797F7F897C7F75787C7030542B5574
897C64457E6F7D6168767876B383786E4F76777E707485BCD3BA9CE1185192D19A8B86D1
148BCEAA8E73788F99757183615D62A5BE8686948042605D5062679A41607C7F7789A8BA
95808770717E998F70748EA781837C7578788C718286734959742B
6B7CA7EF7E8992B6A391A589A27075AB8C808C797F8997C3C3525B1795AABD6AB7B390A1
BD737E924C65785D977C86A2A84593831E9471BAA6914E528B9C58649C9160735094B45C
6394868C62626D8270AA73908E89797F89867C89717C70707F708F
8289718983768161A7895A462A4F946A76747A897D90D8954F505977B086C6B67F839C59
8864887F6B6B8B2D7F88938991A3705339AF8980546781897D787A7A708F6B99935E87B5
6D899A8989627D78AE63B35E85938271787878787878939498856F
868CF3358A6E74857589D4D495AB7073827F6E859ACAA63646A58BD467628FAC76546E8C
748C3F61898B716EA187AFAAA1B47C49A068A36762AF6C819792229B905EA657499E8988
A66DC782A2A6BA7654B08A88808373827F75828990899E735D809D
6B7CB55D4BAA88A27C7C3C34746F618C7589877CF88643B68C8EA0939CD79392919D786F
6F3855609B898F53998564659467A478529458A3607D899B576BBF7A775B854FD0708E65
A18EA68E9AAF8CC88B71C68C8EA8938782907875787C66778B5B91
939D403FB580B1929E7E957D7645935D838190FF6180B37E839ABFAA988AA5736D999790
79748C86A777628B4B8CA87CC9918BBD6E5E899091AA8652AA97747162803C895B893967
60856B94B49BA2939E6A48ED905EA080717882897C756792867559
89D005D8AF9E9578586A65996A8F67867F89EE6065C7A664DC9AE27398955538617E97C7
BD768C867492685C936C7E77508254AA79859B5A7068A1609153825A78867F616B86AC6D
83747C9CA27E99827A866215CE896D89877C7F75827F906F677E78
F8757C6573866481A665794667797F77BFE48266AE8892A897D79DAA527D719C7041A259
B6B48753808275AB5A7D617362666D387F7A915CA1A377A23D6F76615576A3407D86AEB3
987946AF75D0647F976D9D763FC3C77D918A82867C90838697A266
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{242.375, 242.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003b0000lR000`400?l00000o`00003ol_l00000
0003o`00003oool0oooo0>h0oooo0Ol000000003o`00003oool0oooo0>h0oooo0Ol000000003o`00
003oool0oooo0>h0oooo0Ol000000003o`00003oool0oooo0>h0oooo0Ol000000003o`00003oool0
oooo0>h0oooo0Ol000000004o`00003oool0oooo0?ooo`80WYjN0`1SHf<209FEU@80Ph>30`1lO7`2
092@T080XZ:R0`22PX8206QXJ080Rh^;0`2:RXX204m?C`80Kfm_0`2<S8`2071`L080Kfm_0`1TI6@2
04M7A`<0/;2`0P2m_Kd20:BTY0<0N7Qh0P1BDU8208V9R@<061PH0P0N7Qh204a<C0<0XZ:R0P3;bl/2
09BDU0<0MWIf0P0_;bl207AdM0<0VIVI0P1]KFd206QXJ0<0Hf=S0P1PH60207IfMP<0K6a/0P1]KFd2
08R8R0<0MGEe0P2<S8`207alO0<0Ogmo0P29RHT207alO0<0XJ6Q0P25QHD30820P080e=CD0P2KVi/3
0<k>cP80V9RH0P2/[:`309VIV@80TI6A0P2LW9`309NGU`80NGUi0P1mOGd304U9B@80F5QH0P0n?Sh5
06EUI@80Kfm_0`1QHF4204a<C0808R8R0`0f=SH205YJFP80Lg=c0`0`<30206i^KP80B4Q80`1eMGD2
0;Jf]P80FEUI0`1iNGT205]KF`<0Ogmo0P2:RXX207emO@<0>3Ph0P26QXH20861P@<0F5QH0P1[Jf/2
03dm?@<0OWin0P2n_[h206IVIP<0FEUI0P1eMGD209BDU0<0W9bL0P2j^[X50?ooo`7o000000001?l0
0000oooo0?ooo`3oool209jNWP<0Hf=S0P2EUID208>3P`<0O7al0P2@T9020::RXP<0PX:20P1XJ6P2
08^;R`<0RXZ:0P1?Cdl206m_K`<0S8b<0P1`L70206m_K`<0I6AT0P17AdL30;2`/080_Kfm0P2TY:@3
07QhN080DU9B0P29RHT301PH60807QhN0P1<C4`30::RXP80bl_;0P2DU9@307IfMP80;bl_0P1dM7@3
09VIV@80KFe]0P1XJ6P306=SH`80H61P0P1fMWH306a/K080KFe]0P28R8P307EeM@80S8b<0P1lO7`3
07moO`80RHV90P1lO7`30:6QX@80QHF50`20P8020=CDe080Vi^K0`3>c/h209RHV080[:b/0`2IVIT2
096AT@80W9bL0`2GUiL207UiN@80OGem0`19BDT205QHF080?Shn1@1UIFD206m_K`<0HF5Q0P1<C4`2
028R8P<0=SHf0P1JFUX207=cL`<0<30`0P1^KVh204Q8B0<0MGEe0P2f][H205UIF@<0NGUi0P1KFe/3
07moO`80RXZ:0P1mOGd303Ph>080QXJ60P21PH4305QHF080Jf][0P0m?Cd307inOP80_[jn0P1VIVH3
05UIF@80MGEe0P2DU9@309bLW080^[Zj1@3oool1o`00000000Co00000?ooo`3oool0oooo0P2BTY83
096AT@80Shn?0P1]KFd3065QH@80NGUi0P1]KFd307IfMP80UIFE0P2NWYh305QHF080M7Ad0P1lO7`3
07EeM@80P8200P1/K6`308:2PP80U9BD0`0T92@204=3@`80OWin0`2TY:@202l_;`80GEeM1@2n_[h2
05ADE0<05ADE0P1@D50209RHV0<0K6a/0P2e]KD206m_K`<0MGEe0P1aLG4209FEU@<0K6a/0P1cLg<2
04Q8B0<0RHV90P22PX8206][J`<0QXJ60P1eMGD209NGU`<0S8b<0P1hN7P206ATI0<0d];B0P2IVIT3
09>CT`80^KVi0P2WYjL30861P@80g=cL0P2^[Zh309>CT`80WYjN0P23Ph<3075aL@80R8R80P23Ph<3
07emO@80T92@0P20P80506EUI@80Kfm_0`1VIVH206m_K`80MgMg0`1ZJVX204m?C`805ADE0`10@402
09RHV080XJ6Q0`2JVYX203Ti>@80PH610`1PH602071`L0<0G5aL0P1UIFD20492@P<0K6a/0P1UIFD2
06MWI`<0R8R80P1mOGd20=CDe0<0PH610P1<C4`50:6QX@80LG5a0P1MGEd304=3@`80D51@1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P2BTY83096AT@80Shn?0P1]KFd3065QH@80NGUi0P1]KFd3
07IfMP80UIFE0P2NWYh305QHF080M7Ad0P1lO7`307EeM@80P8200P1/K6`308:2PP80U9BD0`0T92@2
04=3@`80OWin0`2TY:@202l_;`80GEeM1@2n_[h205ADE0<05ADE0P1@D50209RHV0<0K6a/0P2e]KD2
06m_K`<0MGEe0P1aLG4209FEU@<0K6a/0P1cLg<204Q8B0<0RHV90P22PX8206][J`<0QXJ60P1eMGD2
09NGU`<0S8b<0P1hN7P206ATI0<0d];B0P2IVIT309>CT`80^KVi0P2WYjL30861P@80g=cL0P2^[Zh3
09>CT`80WYjN0P23Ph<3075aL@80R8R80P23Ph<307emO@80T92@0P20P80506EUI@80Kfm_0`1VIVH2
06m_K`80MgMg0`1ZJVX204m?C`805ADE0`10@40209RHV080XJ6Q0`2JVYX203Ti>@80PH610`1PH602
071`L0<0G5aL0P1UIFD20492@P<0K6a/0P1UIFD206MWI`<0R8R80P1mOGd20=CDe0<0PH610P1<C4`5
0:6QX@80LG5a0P1MGEd304=3@`80D51@1@3oool1o`00000000Co00000?ooo`3oool0oooo0P2BTY83
096AT@80Shn?0P1]KFd3065QH@80NGUi0P1]KFd307IfMP80UIFE0P2NWYh305QHF080M7Ad0P1lO7`3
07EeM@80P8200P1/K6`308:2PP80U9BD0`0T92@204=3@`80OWin0`2TY:@202l_;`80GEeM1@2n_[h2
05ADE0<05ADE0P1@D50209RHV0<0K6a/0P2e]KD206m_K`<0MGEe0P1aLG4209FEU@<0K6a/0P1cLg<2
04Q8B0<0RHV90P22PX8206][J`<0QXJ60P1eMGD209NGU`<0S8b<0P1hN7P206ATI0<0d];B0P2IVIT3
09>CT`80^KVi0P2WYjL30861P@80g=cL0P2^[Zh309>CT`80WYjN0P23Ph<3075aL@80R8R80P23Ph<3
07emO@80T92@0P20P80506EUI@80Kfm_0`1VIVH206m_K`80MgMg0`1ZJVX204m?C`805ADE0`10@402
09RHV080XJ6Q0`2JVYX203Ti>@80PH610`1PH602071`L0<0G5aL0P1UIFD20492@P<0K6a/0P1UIFD2
06MWI`<0R8R80P1mOGd20=CDe0<0PH610P1<C4`50:6QX@80LG5a0P1MGEd304=3@`80D51@1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P2GUiL3061PH080TI6A1@26QXH208b<S080P8200`1mOGd2
09NGU`80UIFE0`1eMGD209NGU`80L71`0`2;Rh/207moO`80[Jf]0`1iNGT206][J`<0Rh^;0P20P802
05EEE@<0VYZJ0P3dm?@207alO0<0Fe]K0P1cLg<20;no_`<0XZ:R0P1PH60209^KV`<0PH610P2<S8`2
0;Jf]P<0/K6a0P2<S8`202`/;0<0IfMW0P1IFET207emO@<0O7al0P22PX8209fMW@<0MGEe0P1oOgl2
07EeM@<0RHV90P2>SXh20:FUY@<0<30`0P2/[:`30:2PX080=CDe0P22PX830<o?c`80NWYj0P1@D503
05eMG@80B4Q80P1[Jf/306m_K`80De=C0P1/K6`309:BTP80IFEU0P20P80309:BTP80NGUi0P1hN7P3
07MgM`80LG5a1@1dM7@205UIF@80AdM70`2WYjL204i>CP80WYjN0`1iNGT2065QH@80I6AT0`1nOWh2
06EUI@<0N7Qh0P1PH60208^;R`<0T92@0P30`<020;Fe]@<0SXj>0P1[Jf/203@d=0<0MgMg0P2:RXX2
065QH@<0EeMG0P1^KVh204=3@`<0RHV90P1/K6`50?ooo`7o000000001?l00000oooo0?ooo`3oool2
09NGU`<0H61P0P2ATI4508J6QP80S8b<0P20P80307emO@80UiNG0P2EUID307EeM@80UiNG0P1`L703
08^;R`80Ogmo0P2][Jd307UiN@80Jf][0`2;Rh/20820P080EEEE0`2JVYX20?Cdm080O7al0`1KFe/2
07=cL`80_kno0`2RXZ82061PH080Vi^K0`21PH4208b<S080][Jf0`2a/K4208b<S080;2`/0`1WIfL2
05UIF@80OGem0`1lO7`208:2PP80WIfM0`1eMGD207moO`80MGEe0`29RHT208j>SP80YJFU0`0`<302
0:b/[0<0X:2P0P0e=CD208:2PP<0clo?0P1jNWX2051@D0<0GEeM0P18B4P206][J`<0Kfm_0P1CDe<2
06a/K0<0TY:B0P1UIFD20820P0<0TY:B0P1iNGT207QhN0<0MgMg0P1aLG4507AdM080FEUI0P17AdL3
0:NWY`80CTi>0P2NWYh307UiN@80HF5Q0P1TI6@307inOP80IFEU0`1hN7P2061PH080Rh^;0`2@T902
0<30`080]KFe0`2>SXh206][J`80=3@d0`1gMgL208Z:RP80HF5Q0`1GEeL206i^KP80@d=30`29RHT2
06a/K0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80>SXj0`2HV9P205eMG@80Kfm_0`1gMgL2
06YZJP80PH610`1gMgL20:NWY`80J6QX0`22PX82075aL@80NGUi0`1JFUX206ATI080S8b<0`1TI6@2
08n?S`<0TI6A0P1CDe<20:2PX0<0:b/[0P0d=3@209fMW@<0NGUi0P1jNWX207AdM0<0YJFU0P2g]kL2
03<c<`<0][Jf0P2:RXX20=;BdP<0GEeM0P2RXZ8206YZJP<0HF5Q0P1_Kfl208R8R0<0RHV90P26QXH2
07alO0<0VYZJ0P2UYJD207UiN@<0MGEe0P2VYZH208j>SP<0][Jf0P2BTY83092@T080S8b<0P11@D43
02l_;`80Bd];0P27QhL30;bl_080Xj>S0P2;Rh/309ZJVP80Lg=c0P1^KVh305aLG080MGEe0P1/K6`3
07MgM`80W9bL0P1gMgL306i^KP80QHF50P1eMGD307QhN080KVi^0P1[Jf/304];B`80?clo0P1DE5@3
06ATI080LG5a0P1oOgl307alO080H61P0`23Ph<207YjNP80OWin0`2HV9P203hn?P805ADE0`0m?Cd2
05EEE@80B4Q80`2GUiL207emO@80Fe]K0`1`L702059BDP80TI6A0`2<S8`209VIV@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80>SXj0`2HV9P205eMG@80Kfm_0`1gMgL206YZJP80PH610`1gMgL2
0:NWY`80J6QX0`22PX82075aL@80NGUi0`1JFUX206ATI080S8b<0`1TI6@208n?S`<0TI6A0P1CDe<2
0:2PX0<0:b/[0P0d=3@209fMW@<0NGUi0P1jNWX207AdM0<0YJFU0P2g]kL203<c<`<0][Jf0P2:RXX2
0=;BdP<0GEeM0P2RXZ8206YZJP<0HF5Q0P1_Kfl208R8R0<0RHV90P26QXH207alO0<0VYZJ0P2UYJD2
07UiN@<0MGEe0P2VYZH208j>SP<0][Jf0P2BTY83092@T080S8b<0P11@D4302l_;`80Bd];0P27QhL3
0;bl_080Xj>S0P2;Rh/309ZJVP80Lg=c0P1^KVh305aLG080MGEe0P1/K6`307MgM`80W9bL0P1gMgL3
06i^KP80QHF50P1eMGD307QhN080KVi^0P1[Jf/304];B`80?clo0P1DE5@306ATI080LG5a0P1oOgl3
07alO080H61P0`23Ph<207YjNP80OWin0`2HV9P203hn?P805ADE0`0m?Cd205EEE@80B4Q80`2GUiL2
07emO@80Fe]K0`1`L702059BDP80TI6A0`2<S8`209VIV@D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80>SXj0`2HV9P205eMG@80Kfm_0`1gMgL206YZJP80PH610`1gMgL20:NWY`80J6QX0`22PX82
075aL@80NGUi0`1JFUX206ATI080S8b<0`1TI6@208n?S`<0TI6A0P1CDe<20:2PX0<0:b/[0P0d=3@2
09fMW@<0NGUi0P1jNWX207AdM0<0YJFU0P2g]kL203<c<`<0][Jf0P2:RXX20=;BdP<0GEeM0P2RXZ82
06YZJP<0HF5Q0P1_Kfl208R8R0<0RHV90P26QXH207alO0<0VYZJ0P2UYJD207UiN@<0MGEe0P2VYZH2
08j>SP<0][Jf0P2BTY83092@T080S8b<0P11@D4302l_;`80Bd];0P27QhL30;bl_080Xj>S0P2;Rh/3
09ZJVP80Lg=c0P1^KVh305aLG080MGEe0P1/K6`307MgM`80W9bL0P1gMgL306i^KP80QHF50P1eMGD3
07QhN080KVi^0P1[Jf/304];B`80?clo0P1DE5@306ATI080LG5a0P1oOgl307alO080H61P0`23Ph<2
07YjNP80OWin0`2HV9P203hn?P805ADE0`0m?Cd205EEE@80B4Q80`2GUiL207emO@80Fe]K0`1`L702
059BDP80TI6A0`2<S8`209VIV@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80QHF50`1CDe<2
0:FUY@80PH610`1WIfL2092@T080PX:20`2HV9P207IfMP80LG5a0`17AdL2075aL@80MWIf0`1oOgl2
0861P@80?clo0`2_[jl208Z:RP<0Ogmo0P1RHV8205UIF@<0VIVI0P29RHT206e]K@<0WYjN0P1/K6`2
06][J`<0>CTi0P1jNWX20;6a/@<0VYZJ0P2MWId202d];@<0VIVI0P0j>SX207inOP<0HV9R0P2EUID2
09NGU`<0QhN70P2:RXX206m_K`<0O7al0P1VIVH20<_;b`<0[:b/0P3Kfm/20=WIf@<0oooo0P38b<P3
0>k^kP80oooo0P2MWId307MgM`80Xj>S0P3?cll30?ooo`80h>3P0P3oool30=OGe`80aLG50P2[Zj/3
0:>SX`80JVYZ0P1hN7P3071`L080DU9B0P1eMGD308R8R080Jf][0P1lO7`308:2PP@0Ogmo1@1[Jf/2
04E5A@<0EEEE0P23Ph<206IVIP<0LG5a0P1_Kfl305iNGP80N7Qh0P1JFUX304=3@`80GUiN0P28R8P3
07EeM@80RXZ:0P2>SXh301@D5080@T920P1XJ6P3069RHP80Xj>S0P2GUiL307moO`80GEeM1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P25QHD305=CD`80YJFU0P21PH4306MWI`80T92@0P22PX83
09RHV080MWIf0P1aLG4304M7A`80LG5a0P1fMWH307moO`80PH610P0o?cl30:n_[`80RXZ:0`1oOgl2
069RHP80FEUI0`2IVIT208V9R@80KFe]0`2NWYh206a/K080Jf][0`0i>CT207YjNP80/K6a0`2JVYX2
09fMW@80;Bd]0`2IVIT203Xj>P80OWin0`1RHV8209FEU@80UiNG0`27QhL208Z:RP80Kfm_0`1lO7`2
06IVIP80bl_;0`2/[:`20=_Kf`80fMWI0`3oool20<S8b0<0k^k^0P3oool209fMW@<0MgMg0P2SXj<2
0<o?c`<0oooo0P3Ph>020?ooo`<0emOG0P35aLD20:^[Z`<0Xj>S0P1ZJVX207QhN0<0L71`0P1BDU82
07EeM@<0R8R80P1[Jf/207alO0<0PX:2101oOgl506][J`80ADE50`1EEED208>3P`80IVIV0`1aLG42
06m_K`<0GUiN0P1hN7P205YJFP<0@d=30P1NGUh208R8R0<0MGEe0P2:RXX208j>SP<051@D0P12@T82
06QXJ0<0HV9R0P2SXj<209NGU`<0Ogmo0P1MGEd50?ooo`7o000000001?l00000oooo0?ooo`3oool2
07inOP<0QXJ60P19BDT209NGU`<0XZ:R0P1cLg<208V9R@<0PX:20P2RXZ8208N7Q`<0IfMW0P2EUID2
06a/K0<0Lg=c0P1jNWX20<;2`P<0OWin0P26QXH303hn?P80[Zj^0P2HV9P305EEE@80PX:20P18B4P3
06YZJP80O7al0P25QHD307moO`80O7al0P1RHV8303Ph>080HF5Q0P2ZZZX306IVIP80EEEE0P1dM7@3
07inOP80S8b<0P1[Jf/306YZJP@0PH610`2@T90209BDU080SXj>0`3dm?@20:JVYP80i>CT0`2KVi/2
0;Fe]@<0U9BD0P1XJ6P208R8R0<0SXj>0P1_Kfl207moO`<0Fe]K0P3?cll208N7Q`<0`/;20P3:b/X2
0;no_`<0^KVi0P2GUiL208n?S`<0M7Ad0P1eMGD209>CT`<0NGUi0P29RHT207alO0X0Ogmo0P1eMGD2
06MWI`<0G5aL0P1/K6`20::RXP<0L71`0P2BTY8309^KV`80Bd];0P22PX8307EeM@80RXZ:0P23Ph<3
07emO@80HF5Q0P12@T8309fMW@80XZ:R0P2_[jl308:2PP80MgMg0P2GUiL307AdM080WYjN1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1nOWh308J6QP80BDU90P2GUiL30::RXP80Lg=c0P29RHT3
08:2PP80XZ:R0P27QhL306MWI`80UIFE0P1/K6`307=cL`80NWYj0P32`/8307inOP80QXJ60`0n?Sh2
0:j^[P80V9RH0`1EEED208:2PP80B4Q80`1ZJVX207alO080QHF50`1oOgl207alO080HV9R0`0h>3P2
065QH@80ZZZZ0`1VIVH205EEE@80M7Ad0`1nOWh208b<S080Jf][0`1ZJVX40861P@<0T92@0P2DU9@2
08j>SP<0m?Cd0P2VYZH20>CTi0<0Vi^K0P2e]KD309BDU080J6QX0P28R8P308j>SP80Kfm_0P1oOgl3
05]KF`80clo?0P27QhL30<;2`P80b/[:0P2o_kl30;Vi^@80UiNG0P2?Shl307AdM080MGEe0P2CTi<3
07UiN@80RHV90P1lO7`:07moO`80MGEe0P1WIfL305aLG080K6a/0P2RXZ83071`L080TY:B0`2KVi/2
04];B`80PX:20`1eMGD208Z:RP80Ph>30`1mOGd2065QH@80@T920`2MWId20::RXP80[jn_0`22PX82
07MgM`80UiNG0`1dM7@209jNWPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80OWin0`26QXH2
04U9B@80UiNG0`2RXZ8207=cL`80RHV90`22PX820::RXP80QhN70`1WIfL209FEU@80K6a/0`1cLg<2
07YjNP80`/;20`1nOWh208J6QP<0?Shn0P2^[Zh209RHV0<0EEEE0P22PX8204Q8B0<0JVYZ0P1lO7`2
08F5Q@<0Ogmo0P1lO7`2069RHP<0>3Ph0P1QHF420:ZZZP<0IVIV0P1EEED207AdM0<0OWin0P2<S8`2
06][J`<0JVYZ1021PH43092@T080U9BD0P2>SXh30?Cdm080YZJV0P3Ti>@309^KV`80]KFe0`2DU9@2
06QXJ080R8R80`2>SXh206m_K`80Ogmo0`1KFe/20<o?c`80QhN70`32`/820<[:bP80_kno0`2i^KT2
09NGU`80Shn?0`1dM7@207EeM@80Ti>C0`1iNGT208V9R@80O7al2P1oOgl207EeM@80IfMW0`1LG5`2
06a/K080XZ:R0`1`L70209:BTP<0Vi^K0P1;Bd/208:2PP<0MGEe0P2:RXX208>3P`<0OGem0P1QHF42
0492@P<0WIfM0P2RXZ820:n_[`<0PX:20P1gMgL209NGU`<0M7Ad0P2NWYh50?ooo`7o000000001?l0
0000oooo0?ooo`3oool207inOP<0Y:BT0P1nOWh209fMW@<0Hf=S0P2EUID205QHF0<0J6QX0P1_Kfl2
061PH0<0WIfM0P1ADE4208J6QP<0NWYj0P2PX:0209>CT`<0Jf][0P2@T90309bLW080KFe]0P1jNWX3
09:BTP80P8200P2DU9@30:>SX`80];Bd0P3moOd30?ooo`80G5aL0P2BTY830=3@d080C4a<0P000003
03<c<`80IFEU0P25QHD308n?S`80O7al0P2TY:@308j>SP80XZ:R0P3?cll30<71`@80j>SX0P3oool3
0=?Cd`80`L710P3UiND30:^[Z`D0i>CT0P1SHf<206i^KP<02@T90P2a/K420=[JfP<0clo?0P1oOgl2
08j>SP<0`l?30P3Rh^820=GEe@<0`l?30P2^[Zh20<_;b`<0d];B0P2DU9@207alO0<0P8200P1mOGd2
08V9R@<0O7al0P1oOgl207EeM@<0PX:2101oOgl307EeM@80O7al0P0n?Sh50:>SX`<0D51@0P2:RXX2
06MWI`<0Kfm_0P1XJ6P206i^KP<0YZJV0P39bLT20;Zj^P<0QhN70P2HV9P20820P0<0Rh^;0P23Ph<2
06ATI0<0K6a/0P1ZJVX50?ooo`7o000000001?l00000oooo0?ooo`3oool207inOP<0Y:BT0P1nOWh2
09fMW@<0Hf=S0P2EUID205QHF0<0J6QX0P1_Kfl2061PH0<0WIfM0P1ADE4208J6QP<0NWYj0P2PX:02
09>CT`<0Jf][0P2@T90309bLW080KFe]0P1jNWX309:BTP80P8200P2DU9@30:>SX`80];Bd0P3moOd3
0?ooo`80G5aL0P2BTY830=3@d080C4a<0P00000303<c<`80IFEU0P25QHD308n?S`80O7al0P2TY:@3
08j>SP80XZ:R0P3?cll30<71`@80j>SX0P3oool30=?Cd`80`L710P3UiND30:^[Z`D0i>CT0P1SHf<2
06i^KP<02@T90P2a/K420=[JfP<0clo?0P1oOgl208j>SP<0`l?30P3Rh^820=GEe@<0`l?30P2^[Zh2
0<_;b`<0d];B0P2DU9@207alO0<0P8200P1mOGd208V9R@<0O7al0P1oOgl207EeM@<0PX:2101oOgl3
07EeM@80O7al0P0n?Sh50:>SX`<0D51@0P2:RXX206MWI`<0Kfm_0P1XJ6P206i^KP<0YZJV0P39bLT2
0;Zj^P<0QhN70P2HV9P20820P0<0Rh^;0P23Ph<206ATI0<0K6a/0P1ZJVX50?ooo`7o000000001?l0
0000oooo0?ooo`3oool206m_K`<0IVIV0P28R8P205MGE`<0Ti>C0P1RHV8209VIV@<0YJFU0P1PH602
07AdM0<0NWYj0P1aLG4207AdM0<0TY:B0P2EUID203dm?@<0KFe]0P1PH60306a/K0@0TI6A0`2CTi<2
08>3P`80Rh^;0`1UIFD206][J`8071`L0`0j>SX20>SXj080MGEe0`1gMgL207emO@80J6QX0`1KFe/2
07emO@80NWYj0`2CTi<206m_K`80N7Qh0`39bLT20;bl_080bl_;0`3no_h20?ooo`80Z:RX0`3Cdm<2
0;6a/@80Zj^[0`3Lg=`20?ooo`<0/k>c0P1HF5P200h>3P<0RXZ:0P00000202d];@<0alO70P3Rh^82
0>SXj0<0^;Rh0P2BTY820861P@<0`/;20P3Vi^H20:RXZ0<0L71`0P2ZZZX209^KV`<0YZJV0P2BTY82
07emO@<0O7al0P1oOgl208V9R@<0O7al0P29RHT2075aL@<0N7Qh0P1WIfL20;Bd]0<0DU9B0P1oOgl3
09ZJVP80EEEE0P1cLg<306EUI@80GUiN0P1DE5@303@d=080<c<c0P1;Bd/303hn?P80CTi>0P1WIfL3
07QhN080Kfm_0P27QhL308b<S080X:2P1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1_Kfl3
06IVIP80R8R80P1GEeL309>CT`80HV9R0P2IVIT30:FUY@80H61P0P1dM7@307YjNP80LG5a0P1dM7@3
09:BTP80UIFE0P0m?Cd306e]K@80H61P0`1/K6`4096AT@<0Ti>C0P23Ph<208^;R`<0IFEU0P1[Jf/2
01`L70<0>SXj0P3Xj>P207EeM@<0MgMg0P1mOGd206QXJ0<0Fe]K0P1mOGd207YjNP<0Ti>C0P1_Kfl2
07QhN0<0bLW90P2l_;`20<_;b`<0o_kn0P3oool20:RXZ0<0dm?C0P2a/K420:^[Z`<0g=cL0P3oool3
0;>c/`80F5QH0P0>3Ph308Z:RP8000000P0];Bd30<O7a`80h^;R0P3Xj>P30;Rh^080TY:B0P21PH43
0<;2`P80i^KV0P2XZ:P3071`L080ZZZZ0P2KVi/30:JVYP80TY:B0P1mOGd307alO080Ogmo0P29RHT3
07alO080RHV90P1aLG4307QhN080IfMW0P2d];@3059BDP80Ogmo0`2JVYX205EEE@80Lg=c0`1UIFD2
05iNGP80E5AD0`0d=3@203<c<`80Bd];0`0n?Sh204i>CP80IfMW0`1hN7P206m_K`80QhN70`2<S8`2
0:2PX0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80Kfm_0`1VIVH208R8R080EeMG0`2CTi<2
069RHP80VIVI0`2UYJD2061PH080M7Ad0`1jNWX2075aL@80M7Ad0`2BTY8209FEU@80?Cdm0`1]KFd2
061PH0<0K6a/102ATI4309>CT`80Ph>30P2;Rh/306EUI@80Jf][0P0L71`303Xj>P80j>SX0P1eMGD3
07MgM`80OGem0P1XJ6P305]KF`80OGem0P1jNWX309>CT`80Kfm_0P1hN7P30<W9b@80_;bl0P3;bl/3
0?knoP80oooo0P2XZ:P30=?Cd`80/K6a0P2[Zj/30=cLg080oooo0`2c/k<205QHF0803Ph>0`2:RXX2
00000080;Bd]0`37alL20>;RhP80j>SX0`2h^;P209:BTP80PH610`32`/820>KViP80Z:RX0`1`L702
0:ZZZP80Vi^K0`2VYZH209:BTP80OGem0`1lO7`207moO`80RHV90`1lO7`208V9R@80LG5a0`1hN7P2
06MWI`80];Bd0`1BDU8207moO`<0VYZJ0P1EEED207=cL`<0IFEU0P1NGUh205ADE0<0=3@d0P0c<c<2
04];B`<0?Shn0P1>CTh206MWI`<0N7Qh0P1_Kfl208N7Q`<0S8b<0P2PX:050?ooo`7o000000001?l0
0000oooo0?ooo`3oool207inOP<0OGem0P2QXJ4207YjNP<0QhN70P1eMGD208R8R0<0K6a/0P2BTY82
0:ZZZP<0QhN70P21PH420;6a/@<0YZJV0P1/K6`207EeM@<0a/K60P1_Kfl30;Vi^@80N7Qh0P0j>SX3
08N7Q`80SXj>0P1lO7`30:j^[P80OGem0P1IFET301PH60807QhN0P1KFe/301<C4`80BTY:0P18B4P3
07YjNP80RXZ:0P1oOgl307QhN080TY:B0P2/[:`30:BTY080bl_;0P2VYZH30<K6aP80ZZZZ0P2g]kL3
0;Fe]@80`/;21@2;Rh/200L71`D000000P2IVIT308:2PP80M7Ad1@00000205eMG@80Vi^K0`21PH42
09^KV`80HV9R0`1MGEd207QhN080WIfM0`2`/;020;>c/`80Y:BT0`1aLG420:n_[`80Ogmo0`23Ph<2
092@T080N7Qh0`1eMGD208:2PP80Ogmo0`1eMGD206i^KP80BDU90`1<C4`203`l?0<0De=C0P2i^KT2
07AdM0<0KVi^0P1ZJVX206=SH`<0PH610P1JFUX207alO0<0X:2P0P13@d<2051@D0<0IFEU0P1nOWh2
06IVIP<0FUYJ0P1BDU850?ooo`7o000000001?l00000oooo0?ooo`3oool207inOP<0OGem0P2QXJ42
07YjNP<0QhN70P1eMGD208R8R0<0K6a/0P2BTY820:ZZZP<0QhN70P21PH420;6a/@<0YZJV0P1/K6`2
07EeM@<0a/K60P1_Kfl30;Vi^@80N7Qh0P0j>SX308N7Q`80SXj>0P1lO7`30:j^[P80OGem0P1IFET3
01PH60807QhN0P1KFe/301<C4`80BTY:0P18B4P307YjNP80RXZ:0P1oOgl307QhN080TY:B0P2/[:`3
0:BTY080bl_;0P2VYZH30<K6aP80ZZZZ0P2g]kL30;Fe]@80`/;21@2;Rh/200L71`D000000P2IVIT3
08:2PP80M7Ad1@00000205eMG@80Vi^K0`21PH4209^KV`80HV9R0`1MGEd207QhN080WIfM0`2`/;02
0;>c/`80Y:BT0`1aLG420:n_[`80Ogmo0`23Ph<2092@T080N7Qh0`1eMGD208:2PP80Ogmo0`1eMGD2
06i^KP80BDU90`1<C4`203`l?0<0De=C0P2i^KT207AdM0<0KVi^0P1ZJVX206=SH`<0PH610P1JFUX2
07alO0<0X:2P0P13@d<2051@D0<0IFEU0P1nOWh206IVIP<0FUYJ0P1BDU850?ooo`7o000000001?l0
0000oooo0?ooo`3oool207MgM`<0PH610P1PH60209BDU0<0O7al0P2QXJ4205aLG0<0QhN70P2h^;P2
03Hf=P<0NGUi0P2c/k<207AdM0<0Cdm?0P1jNWX2075aL@<0:b/[0P1[Jf/308:2PP80HV9R0P2_[jl3
08>3P`80GUiN0P1jNWX304M7A`80Jf][0P22PX830:^[Z`80IfMW0P1^KVh303De=@80:b/[0P2@T903
075aL@80O7al0P22PX8308J6QP80/k>c0P3Shn<30>SXj080]kNg0P2j^[X30:f][@80OGem0P21PH43
07QhN080QhN70P1_Kfl304=3@`8000000`071`L209NGU`80MgMg0`26QXH208V9R@80MGEe0`0n?Sh2
00000080ATI60`22PX8209BDU080_;bl0`1jNWX20820P080RXZ:0`2g]kL20:6QX@80PH610`2WYjL2
08N7Q`80Xj>S0`21PH4208Z:RP80U9BD0`2:RXX206i^KP80PX:20`29RHT2075aL@80KVi^1@26QXH3
08j>SP80P8200P1cLg<308:2PP80Ogmo0P29RHT309NGU`80QhN70P1XJ6P308F5Q@@0Ogmo0`2MWId2
07EeM@80N7Qh0`2IVIT208n?S`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80MgMg0`21PH42
061PH080U9BD0`1lO7`20:6QX@80G5aL0`27QhL20;Rh^080=SHf0`1iNGT20;>c/`80M7Ad0`1?Cdl2
07YjNP80LG5a0`0[:b/206][J`<0PX:20P1RHV820:n_[`<0Ph>30P1NGUh207YjNP<0AdM70P1[Jf/2
08:2PP<0Zj^[0P1WIfL206i^KP<0=CDe0P0[:b/2092@T0<0LG5a0P1lO7`208:2PP<0QXJ60P2c/k<2
0>?Sh`<0j>SX0P2g]kL20;Zj^P<0[Jf]0P1mOGd20861P@<0N7Qh0P27QhL206m_K`<0@d=30P000003
00L71`80UiNG0P1gMgL308J6QP80RHV90P1eMGD303hn?P8000000P16ATH308:2PP80U9BD0P2l_;`3
07YjNP80P8200P2:RXX30;Ng]`80XJ6Q0P21PH430:NWY`80QhN70P2SXj<30861P@80RXZ:0P2DU9@3
08Z:RP80KVi^0P22PX8308V9R@80LG5a0P1^KVh508J6QP<0SXj>0P20P80207=cL`<0PX:20P1oOgl2
08V9R@<0UiNG0P27QhL206QXJ0<0QHF5101oOgl309fMW@80MGEe0P1hN7P309VIV@80Shn?1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1gMgL30861P@80H61P0P2DU9@307alO080XJ6Q0P1LG5`3
08N7Q`80^;Rh0P0f=SH307UiN@80/k>c0P1dM7@304m?C`80NWYj0P1aLG4302/[:`80Jf][0`22PX82
069RHP80[jn_0`23Ph<205iNGP80NWYj0`17AdL206][J`80PX:20`2[Zj/206MWI`80KVi^0`0e=CD2
02/[:`80T92@0`1aLG4207alO080PX:20`26QXH20;>c/`80hn?S0`3Xj>P20;Ng]`80^[Zj0`2][Jd2
07emO@80PH610`1hN7P208N7Q`80Kfm_0`13@d<2000000<01`L70P2GUiL207MgM`<0QXJ60P29RHT2
07EeM@<0?Shn0P00000204I6AP<0PX:20P2DU9@20;bl_0<0NWYj0P20P80208Z:RP<0]kNg0P2QXJ42
0861P@<0YjNW0P27QhL20:>SX`<0PH610P2:RXX209BDU0<0RXZ:0P1^KVh208:2PP<0RHV90P1aLG42
06i^KPD0QXJ60`2>SXh20820P080Lg=c0`22PX8207moO`80RHV90`2GUiL208N7Q`80J6QX0`25QHD4
07moO`<0WIfM0P1eMGD207QhN0<0VIVI0P2?Shl50?ooo`7o000000001?l00000oooo0?ooo`3oool2
09jNWP<0Vi^K0P1WIfL2075aL@<0QHF50P26QXH209BDU0<0MgMg0P0h>3P209NGU`<0N7Qh0P1dM7@2
0820P0<0RXZ:0P29RHT20<G5a@<0Xj>S0P2WYjL304U9B@80RXZ:0P1GEeL3051@D080Zj^[0P2n_[h3
07EeM@80R8R80P2][Jd306][J`8000000P0;2`/304m?C`80O7al0P1`L70309bLW080N7Qh0P36a/H3
0;Fe]@80XZ:R0P1hN7P30861P@80Z:RX0P2n_[h304Y:BP80B4Q80P2KVi/306QXJ080QXJ60P0l?3`3
000000801PH60`23Ph<409>CT`<0PX:20P1lO7`207EeM@<0EeMG0P1ADE4202/[:`<0;2`/0P1jNWX2
08Z:RP<0alO70P3^k^h207YjNP<0QXJ60P2h^;P20;Zj^P<0_;bl0P27QhL20::RXP<0b/[:0P1[Jf/2
07EeM@<0MgMg0P22PX8208V9R@<0QXJ60P1lO7`207EeM@<0N7Qh0P1WIfL3059BDP80>CTi0P1`L703
06QXJ080NWYj0P1dM7@306YZJP80VIVI0P2KVi/307AdM080RHV90P2TY:@306ATI080K6a/0P1UIFD3
07=cL`80F5QH1@3oool1o`00000000Co00000?ooo`3oool0oooo0P2NWYh309^KV`80IfMW0P1aLG43
08F5Q@80QXJ60P2DU9@307MgM`80>3Ph0P2GUiL307QhN080M7Ad0P20P80308Z:RP80RHV90P35aLD3
0:>SX`80YjNW0`19BDT208Z:RP80EeMG0`1@D5020:^[Z`80_[jn0`1eMGD208R8R080[Jf]0`1[Jf/2
000000802`/;0`1?Cdl207alO080L71`0`2LW9`207QhN080a/K60`2e]KD20::RXP80N7Qh0`21PH42
0:RXZ080_[jn0`1:BTX204Q8B080Vi^K0`1XJ6P208J6QP80?3`l0`00000200H61P<0Ph>3102CTi<3
08:2PP80O7al0P1eMGD305MGE`80DE5A0P0[:b/302`/;080NWYj0P2:RXX30<O7a`80k^k^0P1jNWX3
08J6QP80^;Rh0P2j^[X30;bl_080QhN70P2RXZ830<[:bP80Jf][0P1eMGD307MgM`80PX:20P29RHT3
08J6QP80O7al0P1eMGD307QhN080IfMW0`1BDU8203Ti>@80L71`0`1XJ6P207YjNP80M7Ad0`1ZJVX2
09VIV@80Vi^K0`1dM7@208V9R@80Y:BT0`1TI6@206a/K080IFEU0`1cLg<205QHF0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80Ti>C0`1RHV820::RXP80QhN70`2RXZ8204U9B@80FUYJ0`2QXJ42
096AT@80OWin0`1fMWH20:f][@80W9bL0`1`L70208V9R@80@T920`1dM7@206ATI0<0NWYj0P2?Shl2
0;6a/@<0clo?0P1fMWH2071`L0<0UIFE0P1<C4`200L71`<06a/K0P27QhL206MWI`<0NWYj0P2?Shl2
09NGU`<0OGem0P2RXZ82096AT@<0]KFe0P3?cll208J6QP<0d=3@0P2;Rh/2061PH0<0JVYZ0P2d];@2
0861P@<0XZ:R0P0W9bL500000080BTY:0`2l_;`207UiN@80c<c<0`1fMWH408Z:RP<0J6QX0P000002
014A4@<0>3Ph0P0N7Qh207AdM0<0j^[Z0P1XJ6P20<O7a`<0X:2P0P2:RXX206i^KP<0ZZZZ0P3@d=02
0;jn_P<0MgMg0P2PX:0208b<S0<0[:b/0P2LW9`20820P0<0NGUi0P2CTi<20;6a/@<0P8200P2MWId3
08N7Q`80N7Qh0P1eMGD707QhN0<0IfMW0P1LG5`206a/K0<0NGUi0P25QHD207moO`<0S8b<0P2LW9`2
07AdM0<0Ogmo0P2h^;P50?ooo`7o000000001?l00000oooo0?ooo`3oool209>CT`<0HV9R0P2RXZ82
08N7Q`<0XZ:R0P19BDT205YJFP<0XJ6Q0P2ATI4207inOP<0MWIf0P2][Jd209bLW0<0L71`0P29RHT2
0492@P<0M7Ad0P1TI6@307YjNP80Shn?0P2a/K430<o?c`80MWIf0P1`L70309FEU@80C4a<0P071`L3
01/K6`80QhN70P1WIfL307YjNP80Shn?0P2GUiL307emO@80XZ:R0P2ATI430;Fe]@80clo?0P26QXH3
0=3@d080Rh^;0P1PH60306YZJP80];Bd0P21PH430::RXP809bLW1@00000204Y:BP<0_;bl0P1iNGT2
0<c<c0<0MWIf102:RXX306QXJ08000000P0A4A4303Ph>0807QhN0P1dM7@30>[ZjP80J6QX0P37alL3
0:2PX080RXZ:0P1^KVh30:ZZZP80d=3@0P2n_[h307MgM`80X:2P0P2<S8`30:b/[080W9bL0P20P803
07UiN@80Ti>C0P2a/K430820P080WIfM0`27QhL207QhN080MGEe1`1hN7P306MWI`80G5aL0P1/K6`3
07UiN@80QHF50P1oOgl308b<S080W9bL0P1dM7@307moO`80^;Rh1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2CTi<3069RHP80XZ:R0P27QhL30::RXP80BDU90P1JFUX30:6QX@80TI6A0P1nOWh3
07IfMP80[Jf]0P2LW9`3071`L080RHV90P12@T8307AdM080I6AT0`1jNWX208n?S`80/K6a0`3?cll2
07IfMP80L71`0`2EUID204a<C0801`L70`0K6a/208N7Q`80IfMW0`1jNWX208n?S`80UiNG0`1mOGd2
0::RXP80TI6A0`2e]KD20<o?c`80QXJ60`3@d=0208^;R`80H61P0`1ZJVX20;Bd]080PH610`2RXZ82
02LW9`D000000P1:BTX30;bl_080NGUi0P3<c<`307IfMP@0RXZ:0`1XJ6P2000000804A4A0`0h>3P2
01hN7P80M7Ad0`3Zj^X206QXJ080alO70`2PX:0208Z:RP80KVi^0`2ZZZX20=3@d080_[jn0`1gMgL2
0:2PX080S8b<0`2/[:`209bLW080P8200`1iNGT209>CT`80/K6a0`20P80209fMW@<0QhN70P1hN7P2
07EeM@L0N7Qh0`1WIfL205aLG080K6a/0`1iNGT208F5Q@80Ogmo0`2<S8`209bLW080M7Ad0`1oOgl2
0;Rh^0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80I6AT0`1gMgL206YZJP80KFe]0`1EEED4
092@T0<0NGUi0P1^KVh207inOP<0Shn?0P1?Cdl205]KF`<0T92@0P1CDe<209RHV0<0O7al0P29RHT3
09ZJVP80MGEe0P1[Jf/305=CD`80GEeM0P1eMGD304];B`80?clo0P1:BTX305YJFP80/k>c0P3Jf]X3
0:BTY080RHV90P2j^[X307alO080RHV90P2XZ:P30<O7a`80QhN70P1XJ6P306ATI080Ogmo0P3WinL3
0?Shn080W9bL0P22PX8304a<C080?clo0P00000309jNWP80Vi^K0`2UYJD208^;R`80IFEU0`2`/;02
0861P@80U9BD0`27QhL209BDU0800`<30`00000208N7Q`80QHF50`1CDe<20;Ng]`80jn_[0`39bLT2
0<_;b`80l?3`0`1lO7`206EUI@80PX:20`39bLT20:f][@80XJ6Q0`1fMWH2065QH@80MgMg0`25QHD2
08V9R@80S8b<0`2KVi/208F5Q@<0YJFU0P1jNWX207alO0D0Ogmo1@1[Jf/206e]K@80G5aL0`1RHV82
07emO@80Bd];0`1BDU82055AD@80QHF50`1LG5`205=CD`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80I6AT0`1gMgL206YZJP80KFe]0`1EEED4092@T0<0NGUi0P1^KVh207inOP<0Shn?0P1?Cdl2
05]KF`<0T92@0P1CDe<209RHV0<0O7al0P29RHT309ZJVP80MGEe0P1[Jf/305=CD`80GEeM0P1eMGD3
04];B`80?clo0P1:BTX305YJFP80/k>c0P3Jf]X30:BTY080RHV90P2j^[X307alO080RHV90P2XZ:P3
0<O7a`80QhN70P1XJ6P306ATI080Ogmo0P3WinL30?Shn080W9bL0P22PX8304a<C080?clo0P000003
09jNWP80Vi^K0`2UYJD208^;R`80IFEU0`2`/;020861P@80U9BD0`27QhL209BDU0800`<30`000002
08N7Q`80QHF50`1CDe<20;Ng]`80jn_[0`39bLT20<_;b`80l?3`0`1lO7`206EUI@80PX:20`39bLT2
0:f][@80XJ6Q0`1fMWH2065QH@80MgMg0`25QHD208V9R@80S8b<0`2KVi/208F5Q@<0YJFU0P1jNWX2
07alO0D0Ogmo1@1[Jf/206e]K@80G5aL0`1RHV8207emO@80Bd];0`1BDU82055AD@80QHF50`1LG5`2
05=CD`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80MWIf1@1oOgl208V9R@<0UiNG0P1fMWH2
09ZJVP<0MWIf0P26QXH208>3P`<0QhN70P29RHT208n?S`<0Ogmo0P27QhL20:6QX@<0Lg=c0P1[Jf/3
09ZJVP80IfMW0P1SHf<304i>CP80FUYJ0P0820P30451@@80G5aL0P1TI6@30=3@d080b<S80P2n_[h3
0:JVYP80RHV90P1SHf<30:JVYP80[Jf]0P2DU9@306i^KP80Ph>30P3gmoL30>CTi080XJ6Q0P1MGEd3
0861P@80WIfM0P26QXH306QXJ080=3@d0P1lO7`309>CT`80O7al0`2e]KD20?3`l080gMgM0`3Kfm/2
0;>c/`80RXZ:0`2;Rh/208N7Q`80Ph>30`1CDe<207alO080OWin0`11@D4207UiN@80VIVI0`2f][H2
0:^[Z`80`L710`3/k>`20?Win@80?Cdm0`1aLG420<G5a@80ZZZZ0`1PH60208V9R@80OGem0`29RHT2
07alO080I6AT1@2d];@30:RXZ080b<S80P25QHD308N7Q`80N7Qh0P29RHT307alO080MGEe1`1hN7P2
08:2PP<0XJ6Q0P2?Shl208N7Q`<0Vi^K0P2;Rh/50?ooo`7o000000001?l00000oooo0?ooo`3oool2
07IfMPD0Ogmo0P29RHT309NGU`80MWIf0P2JVYX307IfMP80QXJ60P23Ph<308N7Q`80RHV90P2?Shl3
07moO`80QhN70P2QXJ4307=cL`80Jf][0`2JVYX206MWI`80Hf=S0`1>CTh205YJFP8020P80`11@D42
05aLG080I6AT0`3@d=020<S8b080_[jn0`2VYZH208V9R@80Hf=S0`2VYZH20:f][@80U9BD0`1^KVh2
08>3P`80moOg0`3Ti>@20:6QX@80GEeM0`21PH4209fMW@80QXJ60`1XJ6P203@d=080O7al0`2CTi<2
07alO0<0]KFe0P3`l?020=gMg@<0fm_K0P2c/k<208Z:RP<0Rh^;0P27QhL208>3P`<0De=C0P1lO7`2
07inOP<0@D510P1iNGT209VIV@<0][Jf0P2[Zj/20<71`@<0k>c/0P3inOT203dm?@<0LG5a0P35aLD2
0:ZZZP<0H61P0P29RHT207emO@<0RHV90P1lO7`206ATI0D0];Bd0`2XZ:P20<S8b080QHF50`27QhL2
07QhN080RHV90`1lO7`207EeM@L0N7Qh0P22PX830:6QX@80Shn?0P27QhL309^KV`80Rh^;1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1fMWH507moO`80RHV90`2GUiL207IfMP80VYZJ0`1fMWH2
08J6QP80Ph>30`27QhL208V9R@80Shn?0`1oOgl208N7Q`80XJ6Q0`1cLg<206][J`<0VYZJ0P1WIfL2
06=SH`<0CTi>0P1JFUX200P820<0@D510P1LG5`206ATI0<0d=3@0P38b<P20;jn_P<0YZJV0P29RHT2
06=SH`<0YZJV0P2][Jd209BDU0<0KVi^0P23Ph<20?Ogm`<0i>CT0P2QXJ4205eMG@<0PH610P2MWId2
08J6QP<0J6QX0P0d=3@207alO0<0Ti>C0P1lO7`30;Fe]@80l?3`0P3MgMd30=_Kf`80/k>c0P2:RXX3
08^;R`80QhN70P23Ph<305=CD`80O7al0P1nOWh30451@@80NGUi0P2IVIT30;Jf]P80Zj^[0P31`L43
0>c/k080nOWi0P0m?Cd3075aL@80aLG50P2ZZZX3061PH080RHV90P1mOGd308V9R@80O7al0P1TI6@5
0;Bd]0<0Z:RX0P38b<P208F5Q@<0QhN70P1hN7P208V9R@<0O7al0P1eMGD707QhN080PX:20`2QXJ42
08n?S`80QhN70`2KVi/208^;R`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80RXZ:0`26QXH2
08j>SP80NGUi0`1^KVh208F5Q@80De=C0`1RHV8207=cL`80M7Ad0`1eMGD209VIV@80KVi^0`1[Jf/2
07IfMP80Cdm?0`2ATI4207QhN0<0DU9B0P2PX:0206a/K0<0IFEU0P1<C4`205YJFP<0Cdm?0P1`L702
08^;R`<0Y:BT0P3>c/h2065QH@<0IfMW0P1DE5@206i^KP<0NGUi0P3]kNd209FEU@<0J6QX0P2XZ:P2
07QhN0<0P8200P2;Rh/2071`L0<0QXJ60P2?Shl205ADE0<0H61P0P3_knl20=7Ad@<0TY:B0P33`l<3
0?KfmP80lo?c0P3;bl/30?7al@80oooo0P3Xj>P30<c<c080Xj>S0P2^[Zh30?[jnP80V9RH0P1LG5`3
08J6QP80Cdm?0P2?Shl308:2PP80IVIV0P0K6a/308^;R`80E5AD0P3QhN43065QH@808R8R0P2:RXX3
0=gMg@80V9RH0P28R8P307IfMP80Ogmo0P2@T9030820P080TI6A0`2GUiL20;6a/@80oooo0`31`L42
08>3P`80NGUi0`1lO7`207EeM@D0N7Qh0P1WIfL207inOP<0IfMW0P1gMgL20=;BdP<0Vi^K0P25QHD5
0?ooo`7o000000001?l00000oooo0?ooo`3oool208Z:RP<0QXJ60P2>SXh207UiN@<0KVi^0P25QHD2
05=CD`<0HV9R0P1cLg<207AdM0<0MGEe0P2IVIT206i^KP<0Jf][0P1fMWH204m?C`<0TI6A0P1hN7P3
059BDP80X:2P0P1/K6`306EUI@80C4a<0P1JFUX304m?C`80L71`0P2;Rh/30:BTY080c/k>0P1QHF43
06MWI`80E5AD0P1^KVh307UiN@80kNg]0P2EUID306QXJ080Z:RX0P1hN7P30820P080Rh^;0P1`L703
08J6QP80Shn?0P1DE5@3061PH080kno_0P3AdM4309:BTP80`l?30`3fm_H20??cl`80bl_;0`3alO42
0?ooo`80j>SX0`3<c<`20:>SX`80[Zj^0`3jn_X209RHV080G5aL0`26QXH204m?C`80Shn?0`22PX82
06IVIP806a/K0`2;Rh/205ADE080hN7Q0`1QHF42028R8P80RXZ:0`3MgMd209RHV080R8R80`1fMWH2
07moO`80T92@0`20P802096AT@<0UiNG0P2a/K420?ooo`<0`L710P23Ph<207UiN@<0O7al0P1eMGD5
07QhN080IfMW0P1nOWh306MWI`80MgMg0P3Bd]8309^KV`80QHF51@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1^KVh308F5Q@80VYZJ0P1/K6`308:2PP80QXJ60P1mOGd308V9R@80I6AT0P20P803
06=SH`80MGEe0P1aLG4309fMW@80R8R80P1cLg<3071`L080QHF50`1GEeL205eMG@80Cdm?0`1/K6`2
05YJFP80Ogmo0`3Bd]840?ooo`<0UiNG0P00000205EEE@<0Jf][0P2PX:020=SHf0<0kNg]0P1QHF42
09BDU0<0f=SH0P1ADE4202l_;`<0<c<c0P33`l<20:2PX0<0IVIV0P1lO7`20861P@<0Ogmo0P3emOD2
0:n_[`D0oooo0`3Ti>@208>3P`80c<c<0`2HV9P20<O7a`80oooo0`30`<020;Ng]`80b/[:0`27QhL2
0?ooo`80RXZ:0`1ADE420:FUY@80IfMW0`1HF5P204i>CP80/k>c0`0M7Ad203Lg=`80KVi^0`3Jf]X2
0;Zj^P80G5aL0`28R8P20=kNgP80Vi^K0`26QXH207IfMP80I6AT0`1PH60207QhN0<0T92@0P2a/K42
0451@@<0/k>c0P3clo<209^KV`<0PX:20P2:RXX207QhN0<0Ogmo0P1eMGD206MWI`<0IVIV0P1_Kfl2
04];B`<0C4a<0P1GEeL50?ooo`7o000000001?l00000oooo0?ooo`3oool206i^KP<0QHF50P2JVYX2
06a/K0<0PX:20P26QXH207emO@<0RHV90P1TI6@20820P0<0Hf=S0P1eMGD2075aL@<0WIfM0P28R8P2
07=cL`<0L71`0P25QHD305MGE`80GEeM0P1?Cdl306a/K080FUYJ0P1oOgl30=;BdP@0oooo0`2GUiL2
00000080EEEE0`1[Jf/20:2PX080f=SH0`3]kNd2065QH@80U9BD0`3Hf=P2055AD@80;bl_0`0c<c<2
0<?3``80X:2P0`1VIVH207alO080PH610`1oOgl20?Gem@80[jn_1@3oool30>CTi080Ph>30P3<c<`3
09RHV080alO70P3oool30<30`080]kNg0P3:b/X308N7Q`80oooo0P2:RXX3055AD@80YJFU0P1WIfL3
05QHF080CTi>0P2c/k<301dM7@80=cLg0P1^KVh30=[JfP80^[Zj0P1LG5`308R8R080g]kN0P2KVi/3
08J6QP80MWIf0P1TI6@3061PH080N7Qh0`2@T9020;6a/@80@D510`2c/k<20??cl`80Vi^K0`22PX82
08Z:RP80N7Qh0`1oOgl207EeM@80IfMW0`1VIVH206m_K`80Bd];0`1<C4`205MGE`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80KVi^0`25QHD209ZJVP80K6a/0`22PX8208J6QP80OGem0`29RHT2
06ATI080P8200`1SHf<207EeM@80LG5a0`2MWId208R8R080Lg=c0`1`L70208F5Q@<0EeMG0P1MGEd2
04m?C`<0K6a/0P1JFUX207moO`<0d];B103oool309NGU`8000000P1EEED306][J`80X:2P0P3Hf=P3
0>g]k@80HF5Q0P2DU9@30=SHf080DE5A0P0_;bl303<c<`80`l?30P2PX:0306IVIP80O7al0P21PH43
07moO`80mOGe0P2_[jl50?ooo`<0i>CT0P23Ph<20<c<c0<0V9RH0P37alL20?ooo`<0`<300P2g]kL2
0<[:bP<0QhN70P3oool208Z:RP<0DE5A0P2UYJD206MWI`<0F5QH0P1>CTh20;>c/`<07AdM0P0g=cL2
06i^KP<0f][J0P2j^[X205aLG0<0R8R80P3Ng]h209^KV`<0QXJ60P1fMWH206ATI0<0H61P0P1hN7P3
092@T080/K6a0P11@D430;>c/`80lo?c0P2KVi/308:2PP80RXZ:0P1hN7P307moO`80MGEe0P1WIfL3
06IVIP80Kfm_0P1;Bd/304a<C080EeMG1@3oool1o`00000000Co00000?ooo`3oool0oooo0P2<S8`3
07alO080BDU90P2RXZ8308Z:RP80U9BD0P27QhL306m_K`80YjNW0P2RXZ830:n_[`80Bd];1@1eMGD2
08F5Q@80T92@0`1cLg<206e]K@<0IfMW0P0o?cl206EUI@<0FUYJ0P27QhL20=gMg@<0Y:BT0P2i^KT2
04U9B@<0=3@d0P1_Kfl206QXJ0<0Xj>S0P2`/;020:n_[`<0OGem0P1oOgl206QXJ0<0De=C0P1lO7`2
0?ooo`<0o_kn0P1/K6`204=3@`<0OWin0P21PH4209jNWP<0^;Rh0P0X:2P20=kNgP<0Shn?0P3@d=03
06=SH`80TY:B0P2MWId308N7Q`80N7Qh0P2WYjL30;bl_080i^KV0P2NWYh307YjNP80=CDe0P3EeMD3
0>?Sh`80FUYJ0P1ZJVX306][J`80TY:B0P3[jn/30?clo080_kno0P1/K6`307QhN080^;Rh0P2m_Kd3
07QhN080Ti>C0P2i^KT307UiN@80RXZ:0P1iNGT307moO`80MGEe0`1CDe<205UIF@80YJFU0`22PX82
09>CT`80eMGE0`2n_[h207YjNP80P8200`26QXH2092@T080N7Qh1@1oOgl206i^KP<0NWYj0P2CTi<5
0?ooo`7o000000001?l00000oooo0?ooo`3oool208b<S0<0O7al0P19BDT20::RXP<0RXZ:0P2DU9@2
08N7Q`<0Kfm_0P2WYjL20::RXP<0[jn_0P1;Bd/507EeM@80QHF50P2@T90307=cL`80KFe]0`1WIfL2
03lo?`80IFEU0`1JFUX208N7Q`80gMgM0`2TY:@20;Vi^@80BDU90`0d=3@206m_K`80J6QX0`2SXj<2
0;2`/080[jn_0`1mOGd207moO`80J6QX0`1CDe<207alO080oooo0`3no_h206a/K080@d=30`1nOWh2
0861P@80WYjN0`2h^;P202PX:080g]kN0`2?Shl20=3@d0<0Hf=S0P2BTY8209fMW@<0QhN70P1hN7P2
0:NWY`<0_;bl0P3Vi^H209jNWP<0NWYj0P0e=CD20=GEe@<0hn?S0P1JFUX206YZJP<0Jf][0P2BTY82
0>_[j`<0o?cl0P2o_kl206a/K0<0N7Qh0P2h^;P20;fm_@<0N7Qh0P2CTi<20;Vi^@<0NGUi0P2:RXX2
07UiN@<0Ogmo0P1eMGD305=CD`80FEUI0P2UYJD308:2PP80Ti>C0P3EeMD30;jn_P80NWYj0P20P803
08J6QP80T92@0P1hN7P507moO`80KVi^0`1jNWX209>CT`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80RXZ:0`23Ph<207alO080N7Qh0`1`L70208F5Q@80N7Qh0`2LW9`206QXJ080Kfm_0`26QXH2
0:6QX@80W9bL0`26QXH205MGE`80MWIf0`1hN7P205]KF`<0Jf][0P1_Kfl207inOP<0PX:20P2e]KD2
0<71`@<0W9bL0P0D51@2059BDP<0P8200P1XJ6P205MGE`<0Ogmo0P2][Jd2051@D0<0DE5A0P1gMgL2
05aLG0<0@4100P3IfMT207MgM`<0KFe]0P1/K6`206EUI@<0V9RH0P2IVIT207moO`<0Ti>C0P1?Cdl2
09NGU`<0]KFe0P1KFe/307YjNP80YjNW0P1RHV8309FEU@80U9BD0P1/K6`309fMW@80P8200P22PX83
07IfMP801@D50P37alL30;Rh^080`<300P1_Kfl30861P@80E5AD0P1QHF4308>3P`80bLW90P2^[Zh3
034a<@80E5AD0P2CTi<30;no_`80:RXZ0P1NGUh3096AT@80MGEe0P22PX8307EeM@80S8b<0`2a/K42
05EEE@80Ph>30`3De=@20:ZZZP80XJ6Q0`2i^KT20:n_[`80Rh^;0`1cLg<206][J`80O7al0`1hN7P2
08:2PP80Ogmo0`29RHT209fMW@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80RXZ:0`23Ph<2
07alO080N7Qh0`1`L70208F5Q@80N7Qh0`2LW9`206QXJ080Kfm_0`26QXH20:6QX@80W9bL0`26QXH2
05MGE`80MWIf0`1hN7P205]KF`<0Jf][0P1_Kfl207inOP<0PX:20P2e]KD20<71`@<0W9bL0P0D51@2
059BDP<0P8200P1XJ6P205MGE`<0Ogmo0P2][Jd2051@D0<0DE5A0P1gMgL205aLG0<0@4100P3IfMT2
07MgM`<0KFe]0P1/K6`206EUI@<0V9RH0P2IVIT207moO`<0Ti>C0P1?Cdl209NGU`<0]KFe0P1KFe/3
07YjNP80YjNW0P1RHV8309FEU@80U9BD0P1/K6`309fMW@80P8200P22PX8307IfMP801@D50P37alL3
0;Rh^080`<300P1_Kfl30861P@80E5AD0P1QHF4308>3P`80bLW90P2^[Zh3034a<@80E5AD0P2CTi<3
0;no_`80:RXZ0P1NGUh3096AT@80MGEe0P22PX8307EeM@80S8b<0`2a/K4205EEE@80Ph>30`3De=@2
0:ZZZP80XJ6Q0`2i^KT20:n_[`80Rh^;0`1cLg<206][J`80O7al0`1hN7P208:2PP80Ogmo0`29RHT2
09fMW@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80RXZ:0`23Ph<207alO080N7Qh0`1`L702
08F5Q@80N7Qh0`2LW9`206QXJ080Kfm_0`26QXH20:6QX@80W9bL0`26QXH205MGE`80MWIf0`1hN7P2
05]KF`<0Jf][0P1_Kfl207inOP<0PX:20P2e]KD20<71`@<0W9bL0P0D51@2059BDP<0P8200P1XJ6P2
05MGE`<0Ogmo0P2][Jd2051@D0<0DE5A0P1gMgL205aLG0<0@4100P3IfMT207MgM`<0KFe]0P1/K6`2
06EUI@<0V9RH0P2IVIT207moO`<0Ti>C0P1?Cdl209NGU`<0]KFe0P1KFe/307YjNP80YjNW0P1RHV83
09FEU@80U9BD0P1/K6`309fMW@80P8200P22PX8307IfMP801@D50P37alL30;Rh^080`<300P1_Kfl3
0861P@80E5AD0P1QHF4308>3P`80bLW90P2^[Zh3034a<@80E5AD0P2CTi<30;no_`80:RXZ0P1NGUh3
096AT@80MGEe0P22PX8307EeM@80S8b<0`2a/K4205EEE@80Ph>30`3De=@20:ZZZP80XJ6Q0`2i^KT2
0:n_[`80Rh^;0`1cLg<206][J`80O7al0`1hN7P208:2PP80Ogmo0`29RHT209fMW@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80IVIV0`1nOWh208b<S080LG5a0`1hN7P206MWI`80R8R80`1^KVh2
09VIV@80Ti>C0`1/K6`206MWI`80MgMg0`1ZJVX208R8R080I6AT0`2EUID207YjNP<0T92@0P2DU9@2
096AT@D0oooo0P1fMWH303dm?@80;2`/0P1`L70306=SH`80IFEU0P2GUiL308J6QP80LG5a0P2o_kl3
0=[JfP80Zj^[0P1eMGD30>GUi@80SXj>0P1aLG43020P808000000P2EUID308b<S080Rh^;0P18B4P3
00000080D51@0P2?Shl308^;R`80_Kfm0`2`/;02092@T080MGEe0`1nOWh209NGU`80KFe]0`2<S8`2
0:^[Z`80SXj>0`1oOgl201XJ6P8000000`1hN7P205]KF`80NWYj0`1cLg<20;Rh^080I6AT0`1@D502
05eMG@80f][J0`38b<P206m_K`80`<300`2JVYX20;bl_080MWIf0`2XZ:P20:FUY@80IVIV0`1jNWX2
05UIF@<0?clo0P2IVIT2065QH@<01PH60P1QHF4209RHV0<0]KFe0P3`l?020?Shn0<0OWin0P1gMgL2
08J6QP<0O7al0P1TI6@206e]K@<0MgMg0P1dM7@50?ooo`7o000000001?l00000oooo0?ooo`3oool2
06IVIP<0OWin0P2<S8`2075aL@<0N7Qh0P1WIfL208R8R0<0KVi^0P2IVIT209>CT`<0K6a/0P1WIfL2
07MgM`<0JVYZ0P28R8P206ATI0<0UIFE0P1jNWX3092@T080U9BD0P2ATI450?ooo`80MWIf0`0m?Cd2
02`/;080L71`0`1SHf<206EUI@80UiNG0`26QXH2075aL@80_kno0`3Jf]X20:^[Z`80MGEe0`3UiND2
08j>SP80LG5a0`0P820200000080UIFE0`2<S8`208^;R`80B4Q80`000002051@D080Shn?0`2;Rh/2
0;fm_@<0/;2`0P2@T90207EeM@<0OWin0P2GUiL206e]K@<0S8b<0P2[Zj/208j>SP<0Ogmo0P0J6QX2
000000<0N7Qh0P1KFe/207YjNP<0Lg=c0P2h^;P206ATI0<0D51@0P1MGEd20=[JfP<0b<S80P1_Kfl2
0<30`0<0VYZJ0P2l_;`207IfMP<0Z:RX0P2UYJD206IVIP<0NWYj0P1IFET303lo?`80VIVI0P1QHF43
00H61P80HF5Q0P2HV9P30;Fe]@80l?3`0P3hn?P307inOP80MgMg0P26QXH307alO080I6AT0P1]KFd3
07MgM`80M7Ad1@3oool1o`00000000Co00000?ooo`3oool0oooo0P2:RXX307=cL`80TY:B0P2UYJD3
08^;R`80V9RH0P1jNWX307emO@80Jf][0P1GEeL307inOP80Shn?0P1aLG4307QhN080O7al0P1gMgL3
03De=@80OWin0`1]KFd20:ZZZP80kNg]0`2CTi<2024Q8@80HV9R0`1mOGd209ZJVP80HF5Q0`1DE5@2
07moO`80UIFE0`3:b/X20=?Cd`80XJ6Q0`2JVYX205YJFP80_kno0`1HF5P207alO080RHV90`0f=SH2
0;no_`80XJ6Q0`1XJ6P203hn?P808b<S0`1NGUh203Ph>080e=CD0`38b<P207alO0<0OGem0P2XZ:P2
0;Bd]0<0g]kN0P1_Kfl208R8R0<0[:b/0P2WYjL20=CDe0<0FEUI0P1iNGT201TI6@<000000P1JFUX2
071`L0<0M7Ad0P1PH60207QhN0<0S8b<0P27QhL203lo?`<0YjNW0P32`/8203@d=0<0MGEe0P3Vi^H2
0<o?c`<0Ti>C0P2DU9@209fMW@<0MgMg0P1KFe/307UiN@80IVIV0P1lO7`308j>SP80?clo0P1^KVh3
0861P@80_;bl0P2c/k<30?Gem@80[Zj^0P2;Rh/3071`L080RHV90P1[Jf/3071`L080I6AT1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P2:RXX307=cL`80TY:B0P2UYJD308^;R`80V9RH0P1jNWX3
07emO@80Jf][0P1GEeL307inOP80Shn?0P1aLG4307QhN080O7al0P1gMgL303De=@80OWin0`1]KFd2
0:ZZZP80kNg]0`2CTi<2024Q8@80HV9R0`1mOGd209ZJVP80HF5Q0`1DE5@207moO`80UIFE0`3:b/X2
0=?Cd`80XJ6Q0`2JVYX205YJFP80_kno0`1HF5P207alO080RHV90`0f=SH20;no_`80XJ6Q0`1XJ6P2
03hn?P808b<S0`1NGUh203Ph>080e=CD0`38b<P207alO0<0OGem0P2XZ:P20;Bd]0<0g]kN0P1_Kfl2
08R8R0<0[:b/0P2WYjL20=CDe0<0FEUI0P1iNGT201TI6@<000000P1JFUX2071`L0<0M7Ad0P1PH602
07QhN0<0S8b<0P27QhL203lo?`<0YjNW0P32`/8203@d=0<0MGEe0P3Vi^H20<o?c`<0Ti>C0P2DU9@2
09fMW@<0MgMg0P1KFe/307UiN@80IVIV0P1lO7`308j>SP80?clo0P1^KVh30861P@80_;bl0P2c/k<3
0?Gem@80[Zj^0P2;Rh/3071`L080RHV90P1[Jf/3071`L080I6AT1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2:RXX307=cL`80TY:B0P2UYJD308^;R`80V9RH0P1jNWX307emO@80Jf][0P1GEeL3
07inOP80Shn?0P1aLG4307QhN080O7al0P1gMgL303De=@80OWin0`1]KFd20:ZZZP80kNg]0`2CTi<2
024Q8@80HV9R0`1mOGd209ZJVP80HF5Q0`1DE5@207moO`80UIFE0`3:b/X20=?Cd`80XJ6Q0`2JVYX2
05YJFP80_kno0`1HF5P207alO080RHV90`0f=SH20;no_`80XJ6Q0`1XJ6P203hn?P808b<S0`1NGUh2
03Ph>080e=CD0`38b<P207alO0<0OGem0P2XZ:P20;Bd]0<0g]kN0P1_Kfl208R8R0<0[:b/0P2WYjL2
0=CDe0<0FEUI0P1iNGT201TI6@<000000P1JFUX2071`L0<0M7Ad0P1PH60207QhN0<0S8b<0P27QhL2
03lo?`<0YjNW0P32`/8203@d=0<0MGEe0P3Vi^H20<o?c`<0Ti>C0P2DU9@209fMW@<0MgMg0P1KFe/3
07UiN@80IVIV0P1lO7`308j>SP80?clo0P1^KVh30861P@80_;bl0P2c/k<30?Gem@80[Zj^0P2;Rh/3
071`L080RHV90P1[Jf/3071`L080I6AT1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1iNGT3
08J6QP80MWIf0P1PH60306QXJ080F5QH0P29RHT30861P@80S8b<0P2?Shl306][J`80TI6A0P2BTY83
07MgM`80N7Qh0P1dM7@309^KV`80MgMg0`2JVYX20=SHf080dM7A0`2;Rh/2034a<@80BDU90`1RHV82
03<c<`80K6a/1@1lO7`208:2PP<0?3`l0P18B4P205EEE@<0KFe]0P1aLG4207inOP<0RHV90P1DE5@2
08:2PP<0d=3@0P1mOGd208F5Q@<0FEUI0P0X:2P207MgM`<0T92@0P2IVIT206EUI@<0MgMg0P2c/k<3
09jNWP80XZ:R0P39bLT309>CT`80d=3@0P2:RXX30;Bd]080V9RH0P1fMWH309RHV080Ph>30P2PX:03
05QHF080JVYZ0P1TI6@306e]K@80emOG0P1mOGd305EEE@80CTi>0P1MGEd303<c<`80@4100P20P803
034a<@800@410P2HV9P30<o?c`80/K6a0P1VIVH306ATI080M7Ad0`1TI6@205]KF`80L71`0`22PX82
0:ZZZP80?3`l0`0>3Ph201LG5`80PH610`2d];@20=_Kf`80_[jn0`1iNGT206a/K080N7Qh0`1lO7`2
07MgM`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80NGUi0`26QXH207IfMP80H61P0`1XJ6P2
05QHF080RHV90`21PH4208b<S080Shn?0`1[Jf/2096AT@80TY:B0`1gMgL207QhN080M7Ad0`2KVi/2
07MgM`<0VYZJ0P3Hf=P20=7Ad@<0Rh^;0P0a<C4204U9B@<0HV9R0P0c<c<206a/K0D0O7al0P22PX83
03`l?080B4Q80P1EEED306e]K@80LG5a0P1nOWh308V9R@80E5AD0P22PX830=3@d080OGem0P25QHD3
05UIF@80:2PX0P1gMgL3092@T080VIVI0P1UIFD307MgM`80/k>c0`2NWYh20::RXP80bLW90`2CTi<2
0=3@d080RXZ:0`2d];@209RHV080MWIf0`2HV9P208>3P`80X:2P0`1HF5P206YZJP80I6AT0`1]KFd2
0=OGe`80OGem0`1EEED204i>CP80GEeM0`0c<c<20410@080P8200`0a<C4200410@80V9RH0`3?cll2
0;6a/@80IVIV0`1TI6@207AdM0<0I6AT0P1KFe/2071`L0<0PX:20P2ZZZX203`l?0<03Ph>0P0G5aL2
0861P@<0];Bd0P3Kfm/20;jn_P<0NGUi0P1/K6`207QhN0<0O7al0P1gMgL50?ooo`7o000000001?l0
0000oooo0?ooo`3oool209:BTP<0UiNG101mOGd307EeM@80PX:20P1oOgl309NGU`80JVYZ0P2HV9P3
092@T080H61P0P1ADE43096AT@80IfMW0P1UIFD306QXJ080YJFU0`3Xj>P20;Bd]080410@0`0M7Ad2
06QXJ080<c<c0`1LG5`208n?S`80KFe]0`1oOgl2071`L080M7Ad0`25QHD209fMW@80Ti>C0`22PX82
0?3`l080P8200`2[Zj/20:n_[`80Vi^K0`1lO7`207MgM`80Kfm_0`2EUID206a/K080Vi^K0`1nOWh2
09^KV`80XJ6Q0`2LW9`20;Bd]0<0Z:RX0P2BTY82075aL@<0PX:20P2?Shl20<?3``<0[Jf]0P2<S8`2
0;>c/`<0Xj>S0P23Ph<207YjNP<0R8R80P1TI6@205QHF0<0Hf=S0P0D51@2092@T0<0Vi^K0P2QXJ42
0:BTY0<0PX:20P2h^;P20;2`/0<0/K6a0P2SXj<202@T90<05aLG0P1?Cdl20:j^[P<0NGUi0P1hN7P3
05aLG080IVIV0P1ZJVX306a/K080KVi^0P2BTY830:6QX@80Kfm_0P0m?Cd305aLG080L71`0P2:RXX5
07moO`80MGEe1@1hN7P50?ooo`7o000000001?l00000oooo0?ooo`3oool209:BTP<0UiNG101mOGd3
07EeM@80PX:20P1oOgl309NGU`80JVYZ0P2HV9P3092@T080H61P0P1ADE43096AT@80IfMW0P1UIFD3
06QXJ080YJFU0`3Xj>P20;Bd]080410@0`0M7Ad206QXJ080<c<c0`1LG5`208n?S`80KFe]0`1oOgl2
071`L080M7Ad0`25QHD209fMW@80Ti>C0`22PX820?3`l080P8200`2[Zj/20:n_[`80Vi^K0`1lO7`2
07MgM`80Kfm_0`2EUID206a/K080Vi^K0`1nOWh209^KV`80XJ6Q0`2LW9`20;Bd]0<0Z:RX0P2BTY82
075aL@<0PX:20P2?Shl20<?3``<0[Jf]0P2<S8`20;>c/`<0Xj>S0P23Ph<207YjNP<0R8R80P1TI6@2
05QHF0<0Hf=S0P0D51@2092@T0<0Vi^K0P2QXJ420:BTY0<0PX:20P2h^;P20;2`/0<0/K6a0P2SXj<2
02@T90<05aLG0P1?Cdl20:j^[P<0NGUi0P1hN7P305aLG080IVIV0P1ZJVX306a/K080KVi^0P2BTY83
0:6QX@80Kfm_0P0m?Cd305aLG080L71`0P2:RXX507moO`80MGEe1@1hN7P50?ooo`7o000000001?l0
0000oooo0?ooo`3oool209:BTP<0UiNG101mOGd307EeM@80PX:20P1oOgl309NGU`80JVYZ0P2HV9P3
092@T080H61P0P1ADE43096AT@80IfMW0P1UIFD306QXJ080YJFU0`3Xj>P20;Bd]080410@0`0M7Ad2
06QXJ080<c<c0`1LG5`208n?S`80KFe]0`1oOgl2071`L080M7Ad0`25QHD209fMW@80Ti>C0`22PX82
0?3`l080P8200`2[Zj/20:n_[`80Vi^K0`1lO7`207MgM`80Kfm_0`2EUID206a/K080Vi^K0`1nOWh2
09^KV`80XJ6Q0`2LW9`20;Bd]0<0Z:RX0P2BTY82075aL@<0PX:20P2?Shl20<?3``<0[Jf]0P2<S8`2
0;>c/`<0Xj>S0P23Ph<207YjNP<0R8R80P1TI6@205QHF0<0Hf=S0P0D51@2092@T0<0Vi^K0P2QXJ42
0:BTY0<0PX:20P2h^;P20;2`/0<0/K6a0P2SXj<202@T90<05aLG0P1?Cdl20:j^[P<0NGUi0P1hN7P3
05aLG080IVIV0P1ZJVX306a/K080KVi^0P2BTY830:6QX@80Kfm_0P0m?Cd305aLG080L71`0P2:RXX5
07moO`80MGEe1@1hN7P50?ooo`7o000000001?l00000oooo0?ooo`3oool205aLG0<0EEEE0P1_Kfl2
0820P0<0Ti>C0P23Ph<206MWI`<0Ogmo0P2EUID206MWI`<0M7Ad0P1`L70208J6QP<0FUYJ0P1SHf<2
08b<S0<0`/;20P3clo<309jNWP802PX:0P1TI6@309:BTP80N7Qh0P1`L70307AdM080L71`0P26QXH3
0=?Cd`80moOg0P3Kfm/30=gMg@80YjNW0P20P8030;bl_080RHV90P3Ph>030::RXP80PX:20P23Ph<3
07inOP80KFe]0P2IVIT304I6AP80RHV90P1SHf<305MGE`80N7Qh0P2UYJD30:NWY`80N7Qh0`22PX82
06QXJ080YjNW0`1dM7@208V9R@80YjNW0`28R8P20=;BdP80]KFe0`1jNWX208F5Q@80NWYj0`1CDe<2
06EUI@80T92@0`1gMgL209:BTP80NGUi0`39bLT20<_;b`80^;Rh0`3Jf]X209>CT`80Jf][0`32`/82
08N7Q`80XJ6Q0`2IVIT208V9R@80Bd];0`27QhL208R8R0<0SXj>0P1cLg<203@d=0<0EEEE0P28R8P2
08Z:RP<0Vi^K0P2^[Zh2069RHP<0@T920P2>SXh209:BTP<0e=CD0P1aLG4208>3P`D0LG5a1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1LG5`305EEE@80Kfm_0P20P80309>CT`80Ph>30P1WIfL3
07moO`80UIFE0P1WIfL307AdM080L71`0P26QXH305YJFP80Hf=S0P2<S8`30<;2`P80lo?c0`2NWYh2
00X:2P80I6AT0`2BTY8207QhN080L71`0`1dM7@2071`L080QXJ60`3Cdm<20?Ogm`80fm_K0`3MgMd2
0:NWY`80P8200`2l_;`208V9R@80h>3P0`2RXZ8208:2PP80Ph>30`1nOWh206e]K@80VIVI0`16ATH2
08V9R@80Hf=S0`1GEeL207QhN080YJFU0`2WYjL207QhN0<0PX:20P1XJ6P20:NWY`<0M7Ad0P29RHT2
0:NWY`<0R8R80P3Bd]820;Fe]@<0NWYj0P25QHD207YjNP<0De=C0P1UIFD2092@T0<0MgMg0P2BTY82
07UiN@<0bLW90P3;bl/20;Rh^0<0f][J0P2CTi<206][J`<0`/;20P27QhL20:6QX@<0VIVI0P29RHT2
04];B`<0QhN70P28R8P308j>SP80Lg=c0P0d=3@305EEE@80R8R80P2:RXX309^KV`80[Zj^0P1RHV83
0492@P80SXj>0P2BTY830=CDe080LG5a0P23Ph<5075aL@D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80QXJ61@1oOgl206i^KP<0Shn?0P2MWId208n?S`<0E5AD0P1/K6`2075aL@<0WYjN0P2;Rh/2
07QhN0<0QXJ60P1mOGd2092@T0<0NGUi0P1<C4`305eMG@80`/;20P1eMGD305ADE080De=C0P28R8P3
08V9R@80OGem0P2TY:@30:n_[`80`/;20P33`l<30:n_[`80^;Rh0P35aLD308j>SP80WYjN0P2HV9P3
07EeM@80UIFE0P0d=3@308^;R`80[Zj^0P11@D4303Xj>P80Kfm_0P23Ph<306ATI080IfMW0P2f][H3
07MgM`80U9BD0`1dM7@206m_K`80NWYj0`2QXJ4206ATI080QHF50`2GUiL207AdM080RXZ:0`2@T902
07moO`80<c<c0`2:RXX20:n_[`80QHF50`1aLG420:2PX080EeMG0`1<C4`207moO`80QXJ60`2MWId2
0;Rh^080YJFU0`1JFUX209VIV@80WIfM0`2RXZ8209jNWP80g]kN0`2e]KD206][J`<0MGEe0P1]KFd2
07alO0<0HF5Q0P0N7Qh208^;R`<0Fe]K0P27QhL20>[ZjP<0`L710P1WIfL207alO0<0a/K60P2^[Zh2
075aL@D0QXJ61@3oool1o`00000000Co00000?ooo`3oool0oooo0P26QXH507moO`80KVi^0`2?Shl2
09fMW@80Shn?0`1DE5@206a/K080LG5a0`2NWYh208^;R`80N7Qh0`26QXH207emO@80T92@0`1iNGT2
04a<C0<0GEeM0P32`/8207EeM@<0E5AD0P1CDe<208R8R0<0RHV90P1mOGd20:BTY0<0[jn_0P32`/82
0<?3``<0[jn_0P2h^;P20<G5a@<0SXj>0P2NWYh209RHV0<0MGEe0P2EUID203@d=0<0Rh^;0P2^[Zh2
0451@@<0>SXj0P1_Kfl208>3P`<0I6AT0P1WIfL20;Jf]P<0MgMg0P2DU9@307AdM080Kfm_0P1jNWX3
0:6QX@80I6AT0P25QHD309NGU`80M7Ad0P2:RXX3092@T080Ogmo0P0c<c<308Z:RP80[jn_0P25QHD3
075aL@80X:2P0P1GEeL304a<C080Ogmo0P26QXH309fMW@80^;Rh0P2UYJD305YJFP80VIVI0P2MWId3
0::RXP80WYjN0P3Ng]h30;Fe]@80Jf][0`1eMGD206e]K@80O7al0`1QHF4201hN7P80Rh^;0`1KFe/2
08N7Q`80j^[Z0`31`L4206MWI`80O7al0`36a/H20:j^[P80LG5a1@26QXH50?ooo`7o000000001?l0
0000oooo0?ooo`3oool208J6QPD0Ogmo0P1^KVh308n?S`80WIfM0P2?Shl305ADE080K6a/0P1aLG43
09jNWP80Rh^;0P1hN7P308J6QP80OGem0P2@T90307UiN@80C4a<0`1MGEd20<;2`P80MGEe0`1DE5@2
05=CD`80R8R80`29RHT207emO@80Y:BT0`2_[jl20<;2`P80`l?30`2_[jl20;Rh^080aLG50`2>SXh2
09jNWP80V9RH0`1eMGD209FEU@80=3@d0`2;Rh/20:j^[P80@D510`0j>SX206m_K`80Ph>30`1TI6@2
06MWI`80][Jf0`1gMgL209BDU0<0M7Ad0P1_Kfl207YjNP<0XJ6Q0P1TI6@208F5Q@<0UiNG0P1dM7@2
08Z:RP<0T92@0P1oOgl203<c<`<0RXZ:0P2_[jl208F5Q@<0LG5a0P2PX:0205MGE`<0C4a<0P1oOgl2
08J6QP<0WIfM0P2h^;P20:FUY@<0FUYJ0P2IVIT209fMW@<0XZ:R0P2NWYh20=kNgP<0]KFe0P1[Jf/3
07EeM@80KFe]0P1lO7`3065QH@807QhN0P2;Rh/305]KF`80QhN70P3Zj^X30<71`@80IfMW0P1lO7`3
0<K6aP80[Zj^0P1aLG4508J6QPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80N7Qh0`2CTi<2
08V9R@80U9BD0`1KFe/206IVIP80Kfm_0`2?Shl206EUI@80QhN70`1^KVh206IVIP80FUYJ0`1PH602
08F5Q@80RHV90`2m_Kd207AdM0<0HF5Q0P0E5AD203dm?@<0F5QH0P1mOGd20:f][@<0[jn_0P2o_kl2
0;Zj^P<0_Kfm0P1hN7P205aLG0<03`l?0P0e=CD20;>c/`<0H61P0P1ZJVX206i^KP<0clo?0P2^[Zh2
0<K6aP<0M7Ad0P26QXH207AdM0<0Xj>S0P1EEED205MGE`<0Y:BT0P32`/8203@d=0<0^;Rh0P0l?3`3
0;Jf]P80Ph>30P1KFe/304U9B@80U9BD0P1QHF4306ATI080M7Ad0P2:RXX30;2`/080[Zj^0P2VYZH3
05=CD`80RXZ:0P1SHf<305UIF@80>SXj0P0c<c<303dm?@80IfMW0P2SXj<308N7Q`80Rh^;0P2ATI43
0<G5a@80_Kfm0P3Rh^830=CDe080[:b/0P2ATI4309jNWP80b/[:0`1aLG4209BDU080P8200`1WIfL2
06][J`805ADE0`2>SXh206m_K`809BDU0`2ZZZX20=3@d080W9bL0`2>SXh20=WIf@80Zj^[0`1_Kfl2
06MWI`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80N7Qh0`2CTi<208V9R@80U9BD0`1KFe/2
06IVIP80Kfm_0`2?Shl206EUI@80QhN70`1^KVh206IVIP80FUYJ0`1PH60208F5Q@80RHV90`2m_Kd2
07AdM0<0HF5Q0P0E5AD203dm?@<0F5QH0P1mOGd20:f][@<0[jn_0P2o_kl20;Zj^P<0_Kfm0P1hN7P2
05aLG0<03`l?0P0e=CD20;>c/`<0H61P0P1ZJVX206i^KP<0clo?0P2^[Zh20<K6aP<0M7Ad0P26QXH2
07AdM0<0Xj>S0P1EEED205MGE`<0Y:BT0P32`/8203@d=0<0^;Rh0P0l?3`30;Jf]P80Ph>30P1KFe/3
04U9B@80U9BD0P1QHF4306ATI080M7Ad0P2:RXX30;2`/080[Zj^0P2VYZH305=CD`80RXZ:0P1SHf<3
05UIF@80>SXj0P0c<c<303dm?@80IfMW0P2SXj<308N7Q`80Rh^;0P2ATI430<G5a@80_Kfm0P3Rh^83
0=CDe080[:b/0P2ATI4309jNWP80b/[:0`1aLG4209BDU080P8200`1WIfL206][J`805ADE0`2>SXh2
06m_K`809BDU0`2ZZZX20=3@d080W9bL0`2>SXh20=WIf@80Zj^[0`1_Kfl206MWI`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80S8b<0`1WIfL208J6QP80Jf][0`26QXH207moO`80RHV91@26QXH2
07EeM@<0M7Ad0P2>SXh209>CT`<0clo?0P1RHV820;bl_0<0PX:20P2BTY8303<c<`80@D511@1iNGT2
09FEU@80/k>c1@3oool20>CTi0<0MGEe0P1iNGT206][J`<0bl_;0P1JFUX200h>3P<0Rh^;0P1VIVH2
0::RXP<0QHF50P1nOWh207MgM`<0NWYj0P0I6AT204Y:BP<0Rh^;0P2EUID204i>CP<0_Kfm0P2/[:`2
07EeM@<0;Rh^0P2PX:03069RHP80FEUI0P000003071`L080U9BD0P27QhL305iNGP80IfMW0P1_Kfl3
061PH080YjNW0P2UYJD308N7Q`80<30`0P1CDe<309:BTP80?Cdm0P2?Shl309bLW080AdM70P0B4Q83
06m_K`80Hf=S0P28R8P3059BDP@0;Bd]0`17AdL20:b/[080VIVI0`2TY:@20<30`0<0dm?C0P1eMGD2
07IfMP<0RHV90P2@T90206ATI0<0:b/[0P0T92@20:6QX@<0@D510P1ADE420:f][@<0R8R80P1/K6`2
09^KV`<0R8R80P1iNGT50?ooo`7o000000001?l00000oooo0?ooo`3oool208b<S0<0IfMW0P26QXH2
06][J`<0QXJ60P1oOgl208V9R@D0QXJ60P1eMGD307AdM080SXj>0P2CTi<30<o?c`80HV9R0P2l_;`3
08:2PP80TY:B0`0c<c<20451@@D0NGUi0P2EUID20;>c/`D0oooo0P3Ti>@307EeM@80NGUi0P1[Jf/3
0<_;b`80FUYJ0P0>3Ph308^;R`80IVIV0P2RXZ8308F5Q@80OWin0P1gMgL307YjNP806ATI0P1:BTX3
08^;R`80UIFE0P1>CTh30;fm_@80[:b/0P1eMGD302h^;P80X:2P0`1RHV8205UIF@8000000`1`L702
09BDU080QhN70`1NGUh206MWI`80Kfm_0`1PH6020:NWY`80YJFU0`27QhL2030`<080De=C0`2BTY82
03dm?@80Shn?0`2LW9`204M7A`804Q8B0`1_Kfl206=SH`80R8R80`1BDU8402d];@<0AdM70P2/[:`2
09VIV@<0Y:BT0P30`<030=?Cd`80MGEe0P1fMWH308V9R@80T92@0P1TI6@302/[:`8092@T0P2QXJ43
0451@@80DE5A0P2][Jd308R8R080K6a/0P2KVi/308R8R080NGUi1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2<S8`306MWI`80QXJ60P1[Jf/308J6QP80Ogmo0P29RHT508J6QP80MGEe0`1dM7@2
08j>SP80Ti>C0`3?cll2069RHP80_;bl0`22PX8209:BTP<0<c<c0P11@D4507UiN@80UIFE0P2c/k<5
0?ooo`80i>CT0`1eMGD207UiN@80Jf][0`3;bl/205YJFP803Ph>0`2;Rh/206IVIP80XZ:R0`25QHD2
07inOP80MgMg0`1jNWX201TI6@80BTY:0`2;Rh/209FEU@80CTi>0`2m_Kd20:b/[080MGEe0`0^;Rh2
0:2PX0<0HV9R0P1IFET2000000<0L71`0P2DU9@208N7Q`<0GUiN0P1WIfL206m_K`<0H61P0P2WYjL2
0:FUY@<0QhN70P0`<30205=CD`<0TY:B0P0m?Cd208n?S`<0W9bL0P17AdL2018B4P<0Kfm_0P1SHf<2
08R8R0<0DU9B100];Bd304M7A`80[:b/0P2IVIT30:BTY080`<300`3Cdm<207EeM@80MWIf0`29RHT2
092@T080I6AT0`0[:b/202@T9080XJ6Q0`11@D42055AD@80[Jf]0`28R8P206a/K080Vi^K0`28R8P2
07UiN@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80O7al0`29RHT408J6QP<0LG5a0P1^KVh2
08J6QP<0UiNG0P25QHD207YjNP<0Ogmo0P1MGEd207=cL`<0@4100P3@d=0208N7Q`<0F5QH0P12@T83
04a<C080SXj>0P2MWId3096AT@80iNGU0P3Jf]X30:FUY@80IfMW0P1SHf<305aLG080AdM70P2GUiL3
06ATI080OWin0P1MGEd306e]K@80O7al0P17AdL304U9B@80CTi>0P23Ph<3024Q8@80bLW90P0W9bL3
05iNGP80FEUI0P1jNWX308N7Q`80a/K60P0e=CD305eMG@80QXJ60`22PX820492@P80?3`l0`1ZJVX2
09NGU`80TI6A0`2<S8`205YJFP80IfMW0`2UYJD207IfMP80O7al0`23Ph<209FEU@80QHF50`1]KFd2
0:FUY@80EEEE0`1oOgl206i^KP80UiNG0`1/K6`204=3@`80HV9R0`26QXH20:6QX@80O7al0`23Ph<2
069RHP80Xj>S0`1fMWH208V9R@<0^;Rh0P2l_;`206i^KP<0LG5a0P1^KVh208J6QP<0MGEe0P1QHF42
014A4@<0Ogmo0P1hN7P2051@D0<0;bl_0P3?cll209BDU0<0WYjN0P1jNWX50?ooo`7o000000001?l0
0000oooo0?ooo`3oool207alO0<0RHV91026QXH3075aL@80KVi^0P26QXH309NGU`80QHF50P1jNWX3
07moO`80GEeM0P1cLg<30410@080d=3@0P27QhL305QHF080@T920`1<C4`208j>SP80WIfM0`2ATI42
0>GUi@80f][J0`2UYJD206MWI`80Hf=S0`1LG5`204M7A`80UiNG0`1TI6@207inOP80GEeM0`1]KFd2
07alO080AdM70`19BDT204i>CP80Ph>30`0Q8B420<W9b@809bLW0`1NGUh205UIF@80NWYj0`27QhL2
0<K6aP80=CDe0`1MGEd208J6QP<0PX:20P12@T8203`l?0<0JVYZ0P2GUiL2096AT@<0S8b<0P1JFUX2
06MWI`<0YJFU0P1fMWH207alO0<0Ph>30P2EUID208F5Q@<0KFe]0P2UYJD205EEE@<0Ogmo0P1^KVh2
09NGU`<0K6a/0P13@d<2069RHP<0QXJ60P2QXJ4207alO0<0Ph>30P1RHV820:>SX`<0MWIf0P29RHT3
0;Rh^080_;bl0P1^KVh3075aL@80KVi^0P26QXH307EeM@80HF5Q0P0A4A4307moO`80N7Qh0P1@D503
02l_;`80clo?0P2DU9@309jNWP80NWYj1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1hN7P3
08b<S080IfMW0P2QXJ43096AT@80RXZ:1@1hN7P208^;R`D0LG5a0P25QHD2092@T0<0J6QX0P2j^[X2
07MgM`<0D51@0P1NGUh308F5Q@80PX:20P2a/K430?ooo`80i^KV0P1mOGd3065QH@80QhN70P25QHD3
0:RXZ080_[jn0P1NGUh30861P@80^;Rh0P2>SXh305aLG080SXj>0P1cLg<303Ph>080F5QH0P10@403
09^KV`8092@T0P3<c<`3069RHP80IFEU0P1oOgl304a<C080Fe]K0P2_[jl303De=@80E5AD0`0m?Cd2
01TI6@80XJ6Q0`1hN7P206i^KP80LG5a0`1TI6@205iNGP80=SHf0`25QHD208>3P`80IFEU0`1BDU82
03<c<`80alO70`2<S8`207IfMP80FUYJ0`2;Rh/2075aL@80Vi^K0`1SHf<20;6a/@80>SXj0`1iNGT2
0::RXP80^KVi0`2c/k<209FEU@80K6a/0`2>SXh207YjNP<0PX:20P2n_[h20?ooo`<0W9bL0P1TI6@2
07moO`<0MGEe0P1^KVh207EeM@<0=3@d0P1TI6@2096AT@<0a/K60P1<C4`20:>SX`<0YJFU0P2:RXX5
0?ooo`7o000000001?l00000oooo0?ooo`3oool207QhN0<0S8b<0P1WIfL20:6QX@<0TI6A0P2:RXX5
07QhN080Rh^;1@1aLG4208F5Q@80T92@0`1XJ6P20;Zj^P80MgMg0`1@D50205iNGP<0QHF50P22PX82
0;6a/@<0oooo0P3Vi^H207emO@<0HF5Q0P27QhL208F5Q@<0Z:RX0P2n_[h205iNGP<0PH610P2h^;P2
08j>SP<0G5aL0P2>SXh207=cL`<0>3Ph0P1HF5P20410@0<0Vi^K0P0T92@20<c<c0<0HV9R0P1UIFD2
07moO`<0C4a<0P1KFe/20:n_[`<0=CDe0P1DE5@303dm?@806ATI0P2QXJ4307QhN080KVi^0P1aLG43
06ATI080GUiN0P0f=SH308F5Q@80Ph>30P1UIFD3059BDP80<c<c0P37alL308b<S080MWIf0P1JFUX3
08^;R`80LG5a0P2KVi/306=SH`80/K6a0P0j>SX307UiN@80XZ:R0P2i^KT30;>c/`80UIFE0P1/K6`3
08j>SP80NWYj0`22PX820;jn_P80oooo0`2LW9`206ATI080Ogmo0`1eMGD206i^KP80MGEe0`0d=3@2
06ATI080TI6A0`36a/H204a<C080Xj>S0`2UYJD208Z:RPD0oooo0Ol000000004o`00003oool0oooo
0?ooo`80N7Qh0`2<S8`206MWI`80XJ6Q0`2ATI4208Z:RPD0N7Qh0P2;Rh/5075aL@80QHF50P2@T903
06QXJ080^[Zj0P1gMgL3051@D080GUiN0`25QHD208:2PP80/K6a0`3oool20>KViP80OGem0`1QHF42
08N7Q`80QHF50`2XZ:P20;jn_P80GUiN0`21PH420;Rh^080SXj>0`1LG5`208j>SP80Lg=c0`0h>3P2
05QHF080@4100`2KVi/202@T9080c<c<0`1RHV8206EUI@80Ogmo0`1<C4`205]KF`80[jn_0`0e=CD2
05ADE0<0?Cdm0P0I6AT20:6QX@<0N7Qh0P1^KVh2075aL@<0I6AT0P1NGUh203Hf=P<0QHF50P23Ph<2
06EUI@<0DU9B0P0c<c<20<O7a`<0S8b<0P1fMWH205YJFP<0Rh^;0P1aLG4209^KV`<0Hf=S0P2a/K42
03Xj>P<0NGUi0P2RXZ820;Vi^@<0/k>c0P2EUID206a/K0<0SXj>0P1jNWX308:2PP80_[jn0P3oool3
09bLW080I6AT0P1oOgl307EeM@80KVi^0P1eMGD303@d=080I6AT0P2ATI430<K6aP80C4a<0P2SXj<3
0:FUY@80RXZ:1@3oool1o`00000000Co00000?ooo`3oool0oooo0P36a/H306i^KP80OGem0P1TI6@3
07MgM`80Rh^;0P27QhL3065QH@80L71`0P20P80307YjNP80Rh^;0P1lO7`30:j^[P80NGUi0P29RHT3
06=SH`80GUiN0`2QXJ420>CTi080oooo0`2SXj<20:^[Z`80VIVI0`0l?3`20;Fe]@80WYjN0`2g]kL2
08J6QP80YjNW0`2l_;`208>3P`80]KFe0`3]kNd207alO080QXJ60`1^KVh208:2PP80C4a<0`1oOgl2
08F5Q@80Jf][0`2GUiL209RHV080MGEe0`1oOgl207EeM@80BDU90`2;Rh/201DE5@<0<30`0P3:b/X2
0;fm_@<0H61P0P0L71`207alO0<0FEUI0P1QHF4206e]K@<0P8200P2<S8`207EeM@<0OWin0P1NGUh2
05QHF0<0O7al0P2<S8`208Z:RP<0M7Ad0P2d];@205eMG@<0L71`0P2CTi<20<S8b0<0<c<c0P0o?cl2
05MGE`<0MgMg0P26QXH20;fm_@<0RHV90P1eMGD3075aL@80P8200P1iNGT30=GEe@80g=cL0P1[Jf/3
07QhN080Ogmo0P1eMGD307QhN080UiNG0P0e=CD304m?C`80a/K60P2RXZ8309fMW@80^KVi1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P36a/H306i^KP80OGem0P1TI6@307MgM`80Rh^;0P27QhL3
065QH@80L71`0P20P80307YjNP80Rh^;0P1lO7`30:j^[P80NGUi0P29RHT306=SH`80GUiN0`2QXJ42
0>CTi080oooo0`2SXj<20:^[Z`80VIVI0`0l?3`20;Fe]@80WYjN0`2g]kL208J6QP80YjNW0`2l_;`2
08>3P`80]KFe0`3]kNd207alO080QXJ60`1^KVh208:2PP80C4a<0`1oOgl208F5Q@80Jf][0`2GUiL2
09RHV080MGEe0`1oOgl207EeM@80BDU90`2;Rh/201DE5@<0<30`0P3:b/X20;fm_@<0H61P0P0L71`2
07alO0<0FEUI0P1QHF4206e]K@<0P8200P2<S8`207EeM@<0OWin0P1NGUh205QHF0<0O7al0P2<S8`2
08Z:RP<0M7Ad0P2d];@205eMG@<0L71`0P2CTi<20<S8b0<0<c<c0P0o?cl205MGE`<0MgMg0P26QXH2
0;fm_@<0RHV90P1eMGD3075aL@80P8200P1iNGT30=GEe@80g=cL0P1[Jf/307QhN080Ogmo0P1eMGD3
07QhN080UiNG0P0e=CD304m?C`80a/K60P2RXZ8309fMW@80^KVi1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P0e=CD307alO080TY:B0P1lO7`507moO`80MGEe0`22PX8407moO`<0N7Qh0P28R8P2
0:b/[0<0YJFU0P2][Jd204];B`<0LG5a0P2XZ:P30=;BdP80bl_;0P2ATI4309FEU@80EeMG0P25QHD3
07emO@80P8200P2@T90306EUI@80Y:BT0P2MWId3075aL@80QXJ60P3AdM4306YZJP80fm_K0P2SXj<3
0;fm_@80Shn?0P3;bl/3065QH@80c<c<0P2>SXh308:2PP80IFEU0P3Jf]X306e]K@80UiNG0P1UIFD3
08n?S`80C4a<0`0g=cL2071`L080Lg=c0`0L71`200410@8030`<0`18B4P205YJFP80b/[:0`29RHT2
05]KF`80]kNg0`2>SXh209ZJVP80Fe]K0`27QhL209>CT`80VYZJ0`2EUID208^;R`80R8R80`2KVi/2
07AdM080WIfM0`39bLT20;2`/080Z:RX0`2NWYh20861P@80QXJ60`2d];@20:RXZ0<0Ti>C0P2JVYX2
0:NWY`<0]kNg0P31`L420?Gem@<0J6QX0P20P802075aL@<0IfMW0P0`<30208^;R`<0QHF50P092@T2
061PH0<0[Zj^0P2LW9`50?ooo`7o000000001?l00000oooo0?ooo`3oool203De=@<0O7al0P2BTY82
07alO0D0Ogmo0P1eMGD308:2PP@0Ogmo0`1hN7P208R8R080[:b/0`2UYJD20:f][@80Bd];0`1aLG42
0:RXZ0<0d];B0P3;bl/2096AT@<0UIFE0P1GEeL208F5Q@<0OGem0P20P802092@T0<0IFEU0P2TY:@2
09fMW@<0LG5a0P26QXH20=7Ad@<0JVYZ0P3Kfm/20:>SX`<0_Kfm0P2?Shl20<_;b`<0HF5Q0P3<c<`2
08j>SP<0PX:20P1UIFD20=[JfP<0KFe]0P2GUiL206EUI@<0Shn?0P1<C4`303Lg=`80L71`0P1cLg<3
01`L70800@410P0<30`304Q8B080FUYJ0P3:b/X308V9R@80Fe]K0P2g]kL308j>SP80VYZJ0P1KFe/3
08N7Q`80Ti>C0P2JVYX309FEU@80Rh^;0P28R8P309^KV`80M7Ad0P2MWId30<W9b@80/;2`0P2XZ:P3
09jNWP80PH610P26QXH30;Bd]080Z:RX0`2CTi<209ZJVP80YjNW0`2g]kL20<71`@80mOGe0`1XJ6P2
0820P080LG5a0`1WIfL2030`<080Rh^;0`25QHD200T92@80H61P0`2^[Zh209bLW0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80=CDe0`1lO7`209:BTP80O7al1@1oOgl207EeM@<0PX:2101oOgl3
07QhN080R8R80P2/[:`30:FUY@80[Jf]0P1;Bd/3075aL@80Z:RX0`3Bd]820<_;b`80TI6A0`2EUID2
05MGE`80QHF50`1mOGd20820P080T92@0`1UIFD20:BTY080WIfM0`1aLG4208J6QP80dM7A0`1ZJVX2
0=_Kf`80Xj>S0`2m_Kd208n?S`80bl_;0`1QHF420<c<c080SXj>0`22PX8206EUI@80f][J0`1]KFd2
09NGU`80IFEU0`2?Shl204a<C0<0=cLg0P1`L70207=cL`<071`L0P010@4200`<30<0B4Q80P1JFUX2
0<[:bP<0RHV90P1KFe/20;Ng]`<0SXj>0P2JVYX205]KF`<0QhN70P2CTi<209ZJVP<0UIFE0P2;Rh/2
08R8R0<0Vi^K0P1dM7@209fMW@<0bLW90P2`/;020:RXZ0<0WYjN0P21PH4208J6QP<0];Bd0P2XZ:P3
09>CT`80VYZJ0P2WYjL30;Ng]`80`L710P3emOD306QXJ080P8200P1aLG4306MWI`80<30`0P2;Rh/3
08F5Q@802@T90P1PH6030:j^[P80W9bL1@3oool1o`00000000Co00000?ooo`3oool0oooo0P29RHT3
07alO080MGEe0P22PX8307EeM@80O7al0P21PH4307moO`80De=C0P1mOGd308F5Q@80KVi^0P1]KFd3
0:FUY@80BDU90P1NGUh30;jn_P80h^;R0`3;bl/20861P@80Jf][0`1VIVH2059BDP80F5QH0`2`/;02
09>CT`80YjNW0`2GUiL204U9B@80Ogmo0`3Xj>P208:2PP80][Jf0`2ATI4208b<S080c/k>0`2NWYh2
0<W9b@80FEUI0`1dM7@200<30`802`/;0`0];Bd209BDU080[jn_0`3Cdm<206QXJ080S8b<0`1NGUh2
07inOP<0/K6a0P1fMWH204=3@`<0EEEE0P1eMGD20492@P<0GEeM0P2;Rh/206IVIP<0Hf=S0P2VYZH2
09RHV0<0];Bd0P1PH60208V9R@<0`l?30P1TI6@20::RXP<0Xj>S0P2>SXh209ZJVP<0`<300P1XJ6P2
09FEU@<0clo?0P2RXZ820;jn_P<0G5aL0P3Bd]8209>CT`<0Kfm_0P2@T9030;fm_@80IFEU0P1fMWH3
07alO080R8R80P1mOGd30=gMg@80QHF50P1cLg<307moO`80GEeM0P1KFe/308F5Q@80Zj^[0P1QHF43
06IVIP80RHV91@3oool1o`00000000Co00000?ooo`3oool0oooo0P29RHT307alO080MGEe0P22PX83
07EeM@80O7al0P21PH4307moO`80De=C0P1mOGd308F5Q@80KVi^0P1]KFd30:FUY@80BDU90P1NGUh3
0;jn_P80h^;R0`3;bl/20861P@80Jf][0`1VIVH2059BDP80F5QH0`2`/;0209>CT`80YjNW0`2GUiL2
04U9B@80Ogmo0`3Xj>P208:2PP80][Jf0`2ATI4208b<S080c/k>0`2NWYh20<W9b@80FEUI0`1dM7@2
00<30`802`/;0`0];Bd209BDU080[jn_0`3Cdm<206QXJ080S8b<0`1NGUh207inOP<0/K6a0P1fMWH2
04=3@`<0EEEE0P1eMGD20492@P<0GEeM0P2;Rh/206IVIP<0Hf=S0P2VYZH209RHV0<0];Bd0P1PH602
08V9R@<0`l?30P1TI6@20::RXP<0Xj>S0P2>SXh209ZJVP<0`<300P1XJ6P209FEU@<0clo?0P2RXZ82
0;jn_P<0G5aL0P3Bd]8209>CT`<0Kfm_0P2@T9030;fm_@80IFEU0P1fMWH307alO080R8R80P1mOGd3
0=gMg@80QHF50P1cLg<307moO`80GEeM0P1KFe/308F5Q@80Zj^[0P1QHF4306IVIP80RHV91@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1cLg<308:2PP80Ti>C0P1WIfL308n?S`80PX:20P1mOGd3
06i^KP80YZJV0P25QHD306m_K`80PX:20P2GUiL305aLG080Bd];0P2WYjL309ZJVP80Rh^;0`1gMgL2
0:NWY`80GEeM0`1eMGD204Q8B080@T920`1JFUX205ADE080IFEU0`2BTY820>g]k@80YjNW0`1DE5@2
0?ooo`808B4Q0`2GUiL206e]K@80@d=30`2m_Kd209NGU`80RXZ:0`15ADD208J6QP80EeMG0`27QhL2
09VIV@80UIFE0`1hN7P204m?C`80NWYj0`2@T90206i^KP<0DE5A0P19BDT207moO`<0Kfm_101iNGT3
09fMW@80P8200P16ATH308Z:RP80ZZZZ0P2GUiL30;>c/`80VIVI0P00000304Y:BP8000000P1?Cdl3
0:BTY080Xj>S0P27QhL309ZJVP80_[jn0P2g]kL309ZJVP80NWYj0P1`L7030;bl_0809BDU0P26QXH3
07AdM080Bd];0`25QHD208>3P`80O7al0`20P802075aL@80RXZ:0`23Ph<20>;RhP80Ti>C0`1]KFd2
07moO`80FUYJ0`0n?Sh205UIF@80/k>c0`1lO7`209^KV`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80Lg=c0`22PX8209>CT`80IfMW0`2?Shl208:2PP80OGem0`1^KVh20:JVYP80QHF50`1_Kfl2
08:2PP80UiNG0`1LG5`204];B`80YjNW0`2JVYX208^;R`<0MgMg0P2WYjL205eMG@<0MGEe0P18B4P2
0492@P<0FUYJ0P1DE5@206EUI@<0TY:B0P3]kNd20:NWY`<0E5AD0P3oool2024Q8@<0UiNG0P1]KFd2
04=3@`<0_Kfm0P2GUiL208Z:RP<0ADE50P26QXH205MGE`<0QhN70P2IVIT209FEU@<0N7Qh0P1?Cdl2
07YjNP<0T92@0P1^KVh3055AD@80BDU90P1oOgl306m_K`@0NGUi0`2MWId20820P080ATI60`2:RXX2
0:ZZZP80UiNG0`2c/k<209VIV@8000000`1:BTX200000080Cdm?0`2TY:@20:>SX`80QhN70`2JVYX2
0;jn_P80]kNg0`2JVYX207YjNP80L71`0`2l_;`202DU9@80QXJ60`1dM7@204];B`<0QHF50P23Ph<2
07alO0<0P8200P1aLG4208Z:RP<0Ph>30P3Rh^8209>CT`<0KFe]0P1oOgl205YJFP<0?Shn0P1IFET2
0;>c/`<0O7al0P2KVi/50?ooo`7o000000001?l00000oooo0?ooo`3oool207=cL`<0PX:20P2CTi<2
06MWI`<0Shn?0P22PX8207emO@<0KVi^0P2VYZH208F5Q@<0Kfm_0P22PX8209NGU`<0G5aL0P1;Bd/2
0:NWY`<0VYZJ0P2;Rh/307MgM`80YjNW0P1MGEd307EeM@80B4Q80P12@T8305YJFP80E5AD0P1UIFD3
09:BTP80kNg]0P2WYjL305ADE080oooo0P0Q8B4309NGU`80KFe]0P13@d<30;fm_@80UiNG0P2:RXX3
04E5A@80QXJ60P1GEeL308N7Q`80VIVI0P2EUID307QhN080Cdm?0P1jNWX3092@T080KVi^0`1ADE42
04U9B@80Ogmo0`1_Kfl407UiN@<0WIfM0P20P80204I6AP<0RXZ:0P2ZZZX209NGU`<0/k>c0P2IVIT2
000000<0BTY:0P00000204m?C`<0Y:BT0P2SXj<208N7Q`<0VYZJ0P2n_[h20;Ng]`<0VYZJ0P1jNWX2
071`L0<0_;bl0P0U9BD208J6QP<0M7Ad0P1;Bd/308F5Q@80Ph>30P1lO7`30820P080LG5a0P2:RXX3
08>3P`80h^;R0P2CTi<306e]K@80Ogmo0P1JFUX303hn?P80FEUI0P2c/k<307alO080Vi^K1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P2n_[h307MgM`80IfMW0P2<S8`307emO@80KVi^0P25QHD3
07EeM@80HF5Q0P1RHV8308b<S080Ogmo0P2<S8`3071`L080VYZJ0P2][Jd30=cLg080c<c<0`2VYZH2
04Y:BP80=3@d0`0f=SH208J6QP80QHF50`10@40206QXJ080U9BD0`2HV9P20;Vi^@80dM7A0`31`L42
01dM7@80RXZ:0`1@D50203`l?080NGUi0`0K6a/201dM7@80TI6A0`2g]kL2055AD@80a/K60`2QXJ42
0;jn_P80RHV90`1DE5@205eMG@80GUiN0`1]KFd207emO@<0DE5A0P1oOgl204];B`<0UIFE0P2IVIT2
03dm?@<0DU9B0P1NGUh207=cL`<0Ogmo0P1CDe<20:JVYP<0JVYZ0P2KVi/20861P@<0?3`l0P2f][H2
0:ZZZP<0Hf=S0P1TI6@208J6QP<0Kfm_0P1`L70202/[:`<0N7Qh0P3IfMT2096AT@<0R8R80P2][Jd2
05UIF@<0c<c<0P2@T90305=CD`80emOG0P2XZ:P305]KF`80NGUi0P22PX8309NGU`80NWYj0P3gmoL3
075aL@80MWIf0P1hN7P305aLG080M7Ad0P1KFe/308j>SP80YjNW1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2n_[h307MgM`80IfMW0P2<S8`307emO@80KVi^0P25QHD307EeM@80HF5Q0P1RHV83
08b<S080Ogmo0P2<S8`3071`L080VYZJ0P2][Jd30=cLg080c<c<0`2VYZH204Y:BP80=3@d0`0f=SH2
08J6QP80QHF50`10@40206QXJ080U9BD0`2HV9P20;Vi^@80dM7A0`31`L4201dM7@80RXZ:0`1@D502
03`l?080NGUi0`0K6a/201dM7@80TI6A0`2g]kL2055AD@80a/K60`2QXJ420;jn_P80RHV90`1DE5@2
05eMG@80GUiN0`1]KFd207emO@<0DE5A0P1oOgl204];B`<0UIFE0P2IVIT203dm?@<0DU9B0P1NGUh2
07=cL`<0Ogmo0P1CDe<20:JVYP<0JVYZ0P2KVi/20861P@<0?3`l0P2f][H20:ZZZP<0Hf=S0P1TI6@2
08J6QP<0Kfm_0P1`L70202/[:`<0N7Qh0P3IfMT2096AT@<0R8R80P2][Jd205UIF@<0c<c<0P2@T903
05=CD`80emOG0P2XZ:P305]KF`80NGUi0P22PX8309NGU`80NWYj0P3gmoL3075aL@80MWIf0P1hN7P3
05aLG080M7Ad0P1KFe/308j>SP80YjNW1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1@D503
08j>SP80Ogmo0P1hN7P307MgM`80S8b<1`26QXH209fMW@<0QHF5102:RXX3069RHP80TI6A0P2WYjL3
0;Zj^P80OWin0`11@D4206EUI@80Kfm_0`1JFUX208^;R`80NGUi0`2EUID208b<S080WIfM0`37alL2
09bLW080MWIf0`020P8201dM7@80;Bd]0`18B4P203Xj>P805aLG0`1BDU8203De=@808R8R0`0n?Sh2
07inOP80TY:B0`20P80209VIV@80K6a/0`29RHT20410@080GEeM0`13@d<206YZJP<0IVIV0P1QHF42
07IfMP<0@4100P12@T82096AT@<0>3Ph0P1XJ6P207AdM0<0ADE50P2d];@209ZJVP<0WYjN0P2PX:02
0:RXZ0<0GUiN0P3Ng]h207moO`<05aLG0P0X:2P204m?C`<0=cLg0P0h>3P205QHF0<0E5AD0P11@D42
0::RXP<0RXZ:0P2g]kL205MGE`<0>3Ph0P2LW9`308n?S`80MWIf0P0_;bl305eMG@80D51@0P1dM7@3
09^KV`80[jn_0P2BTY830>c/k080IfMW0P20P80307emO@80?3`l0P15ADD303`l?080F5QH1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1@D50308j>SP80Ogmo0P1hN7P307MgM`80S8b<1`26QXH2
09fMW@<0QHF5102:RXX3069RHP80TI6A0P2WYjL30;Zj^P80OWin0`11@D4206EUI@80Kfm_0`1JFUX2
08^;R`80NGUi0`2EUID208b<S080WIfM0`37alL209bLW080MWIf0`020P8201dM7@80;Bd]0`18B4P2
03Xj>P805aLG0`1BDU8203De=@808R8R0`0n?Sh207inOP80TY:B0`20P80209VIV@80K6a/0`29RHT2
0410@080GEeM0`13@d<206YZJP<0IVIV0P1QHF4207IfMP<0@4100P12@T82096AT@<0>3Ph0P1XJ6P2
07AdM0<0ADE50P2d];@209ZJVP<0WYjN0P2PX:020:RXZ0<0GUiN0P3Ng]h207moO`<05aLG0P0X:2P2
04m?C`<0=cLg0P0h>3P205QHF0<0E5AD0P11@D420::RXP<0RXZ:0P2g]kL205MGE`<0>3Ph0P2LW9`3
08n?S`80MWIf0P0_;bl305eMG@80D51@0P1dM7@309^KV`80[jn_0P2BTY830>c/k080IfMW0P20P803
07emO@80?3`l0P15ADD303`l?080F5QH1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1@D503
08j>SP80Ogmo0P1hN7P307MgM`80S8b<1`26QXH209fMW@<0QHF5102:RXX3069RHP80TI6A0P2WYjL3
0;Zj^P80OWin0`11@D4206EUI@80Kfm_0`1JFUX208^;R`80NGUi0`2EUID208b<S080WIfM0`37alL2
09bLW080MWIf0`020P8201dM7@80;Bd]0`18B4P203Xj>P805aLG0`1BDU8203De=@808R8R0`0n?Sh2
07inOP80TY:B0`20P80209VIV@80K6a/0`29RHT20410@080GEeM0`13@d<206YZJP<0IVIV0P1QHF42
07IfMP<0@4100P12@T82096AT@<0>3Ph0P1XJ6P207AdM0<0ADE50P2d];@209ZJVP<0WYjN0P2PX:02
0:RXZ0<0GUiN0P3Ng]h207moO`<05aLG0P0X:2P204m?C`<0=cLg0P0h>3P205QHF0<0E5AD0P11@D42
0::RXP<0RXZ:0P2g]kL205MGE`<0>3Ph0P2LW9`308n?S`80MWIf0P0_;bl305eMG@80D51@0P1dM7@3
09^KV`80[jn_0P2BTY830>c/k080IfMW0P20P80307emO@80?3`l0P15ADD303`l?080F5QH1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1iNGT306i^KP80QHF50P26QXH307emO@80Jf][0P26QXH3
07moO`80I6AT0P1VIVH3069RHP80Zj^[0P26QXH307=cL`80IVIV0P2n_[h305EEE@80?Cdm0`1KFe/2
08J6QP80SXj>0`2a/K42061PH080RXZ:1@2RXZ820>GUi@<0Vi^K0P10@40203De=@<0PH610P1;Bd/2
03De=@<09BDU0P0l?3`204];B`<0KFe]0P1BDU8205MGE`<0GEeM0P0m?Cd208j>SP<0XZ:R0P1^KVh2
06IVIP<0MgMg0P1nOWh2061PH0<0BTY:0P1HF5P307QhN080IVIV0P1fMWH306i^KP80QhN70P1aLG43
05iNGP80EEEE0P1/K6`308R8R080BTY:0P0i>CT30:ZZZP80UIFE0P1UIFD306IVIP80ATI60P1SHf<3
04I6AP80AdM70P0o?cl30492@P80HF5Q0P1@D50304Q8B080?Shn0P0J6QX3075aL@80JVYZ0P3Jf]X3
0:n_[`80OWin0`1VIVH206e]K@80WYjN0`21PH4208V9R@80W9bL0`1PH60203lo?`80@T920`2DU9@2
0;Bd]080KVi^0`1oOgl209ZJVP80IFEU0`1dM7@207inOPD0oooo0Ol000000004o`00003oool0oooo
0?ooo`80NGUi0`1^KVh208F5Q@80QXJ60`1mOGd206][J`80QXJ60`1oOgl206ATI080IVIV0`1RHV82
0:^[Z`80QXJ60`1cLg<206IVIP80_[jn0`1EEED203dm?@<0Fe]K0P26QXH208j>SP<0/K6a0P1PH602
08Z:RPD0XZ:R0P3UiND309^KV`80@4100P0e=CD30861P@80Bd];0P0e=CD302DU9@80?3`l0P1;Bd/3
06e]K@80DU9B0P1GEeL305eMG@80?Cdm0P2>SXh30::RXP80KVi^0P1VIVH307MgM`80OWin0P1PH603
04Y:BP80F5QH0`1hN7P206IVIP80MWIf0`1^KVh208N7Q`80LG5a0`1NGUh205EEE@80K6a/0`28R8P2
04Y:BP80>CTi0`2ZZZX209FEU@80IFEU0`1VIVH204I6AP80Hf=S0`16ATH204M7A`80?clo0`12@T82
065QH@80D51@0`18B4P203hn?P806QXJ0`1aLG4206YZJP80f][J0`2_[jl207inOP<0IVIV0P1]KFd2
09jNWP<0PH610P29RHT209bLW0<0H61P0P0o?cl20492@P<0U9BD0P2d];@206i^KP<0Ogmo0P2JVYX2
06EUI@<0M7Ad0P1nOWh50?ooo`7o000000001?l00000oooo0?ooo`3oool208F5Q@<0QXJ60P1mOGd2
07moO`<0N7Qh0P1jNWX206IVIP<0MgMg0P25QHD206i^KP<0NWYj0P29RHT207=cL`<0YjNW0P2:RXX2
08n?S`<0G5aL0P1PH6030:j^[P80H61P0P1oOgl306=SH`80MGEe0P3@d=030<_;b`80KVi^0P2ATI43
02HV9P806QXJ0P0S8b<300000080>CTi0P1[Jf/508N7Q`80DU9B0`00000200P820805ADE0`1XJ6P2
05aLG080S8b<0`2d];@206][J`80DE5A0`18B4P206i^KP80Jf][0`1XJ6P206a/K0<0KVi^0P1jNWX2
069RHP<0YJFU0P1fMWH2065QH@<0YjNW0P1TI6@207MgM`<0IFEU0P1GEeL2065QH@<0M7Ad0P2n_[h2
08F5Q@<0MgMg0P00000201TI6@<0EEEE0P1_Kfl206e]K@<0=SHf0P1ADE4207=cL`<0:RXZ0P1?Cdl2
05=CD`<0=CDe0P18B4P20861P@<0clo?0P2a/K4309bLW080Bd];0P1cLg<308j>SP80V9RH0P1/K6`3
0:6QX@80_;bl0P1oOgl304m?C`80QXJ60P2LW9`30820P080LG5a0P22PX8306ATI080Hf=S1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P25QHD308J6QP80OGem0P1oOgl307QhN080NWYj0P1VIVH3
07MgM`80QHF50P1^KVh307YjNP80RHV90P1cLg<30:NWY`80RXZ:0P2?Shl305aLG080H61P0`2^[Zh2
061PH080Ogmo0`1SHf<207EeM@80d=3@0`3;bl/206i^KP80TI6A0`0V9RH201XJ6P808b<S0`000002
03Ti>@80Jf][1@27QhL2059BDP<000000P0820P201DE5@<0J6QX0P1LG5`208b<S0<0];Bd0P1[Jf/2
055AD@<0B4Q80P1^KVh206][J`<0J6QX0P1/K6`306i^KP80NWYj0P1RHV830:FUY@80MWIf0P1QHF43
0:NWY`80I6AT0P1gMgL306EUI@80EeMG0P1QHF4307AdM080_[jn0P25QHD307MgM`8000000P0I6AT3
05EEE@80Kfm_0P1]KFd303Hf=P80DE5A0P1cLg<302XZ:P80Cdm?0P1CDe<303De=@80B4Q80P21PH43
0<o?c`80/K6a0`2LW9`204];B`80Lg=c0`2>SXh209RHV080K6a/0`2QXJ420;bl_080Ogmo0`1?Cdl2
08J6QP80W9bL0`20P802075aL@80PX:20`1TI6@206=SH`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80QHF50`26QXH207emO@80Ogmo0`1hN7P207YjNP80IVIV0`1gMgL208F5Q@80KVi^0`1jNWX2
08V9R@80Lg=c0`2WYjL208Z:RP80Shn?0`1LG5`2061PH0<0[Zj^0P1PH60207moO`<0Hf=S0P1eMGD2
0=3@d0<0bl_;0P1^KVh2096AT@<09RHV0P0J6QX202<S8`<000000P0i>CT206][J`D0QhN70P1BDU83
0000008020P80P0E5AD306QXJ080G5aL0P2<S8`30;Bd]080Jf][0P1ADE4304Q8B080KVi^0P1[Jf/3
06QXJ080K6a/0`1^KVh207YjNP80HV9R0`2UYJD207IfMP80HF5Q0`2WYjL206ATI080MgMg0`1UIFD2
05MGE`80HF5Q0`1dM7@20;jn_P80QHF50`1gMgL2000000806ATI0`1EEED206m_K`80KFe]0`0f=SH2
055AD@80Lg=c0`0Z:RX204m?C`80De=C0`0e=CD204Q8B080PH610`3?cll20;6a/@<0W9bL0P1;Bd/2
07=cL`<0SXj>0P2HV9P206a/K0<0XJ6Q0P2l_;`207moO`<0Cdm?0P26QXH209bLW0<0P8200P1aLG42
08:2PP<0I6AT0P1SHf<50?ooo`7o000000001?l00000oooo0?ooo`3oool207QhN0<0PX:22@1oOgl2
07EeM@<0N7Qh0P1aLG42071`L0<0YjNW0P1dM7@205YJFP<0VIVI0P2g]kL20492@P<0UiNG0P2a/K43
061PH080NGUi0P1oOgl30820P080`/;20P1DE5@30:BTY080oooo0P0B4Q83000000809BDU0P3>c/hA
0?ooo`808b<S0P0R8R830:2PX080[:b/0P1mOGd307AdM080Cdm?0P1JFUX304M7A`80E5AD0P1VIVH3
07YjNP80PX:20`1>CTh207alO080a/K60`1ZJVX207EeM@80S8b<0`1JFUX208N7Q`80E5AD0`1:BTX2
071`L080X:2P0`1WIfL207MgM`80YJFU0`2?Shl204Y:BP80HV9R0`0>3Ph202HV9P806QXJ0`1XJ6P2
08:2PP80De=C0`1[Jf/2020P8080:RXZ0`0a<C42059BDP80DE5A0`1:BTX208^;R`<0dM7A0P2RXZ82
0;bl_0<0UiNG0P1oOgl205]KF`<0?clo0P13@d<208Z:RP<0QHF50P32`/8209^KV`<0N7Qh0P2<S8`2
08Z:RP<0U9BD0P1UIFD50?ooo`7o000000001?l00000oooo0?ooo`3oool207QhN0<0PX:22@1oOgl2
07EeM@<0N7Qh0P1aLG42071`L0<0YjNW0P1dM7@205YJFP<0VIVI0P2g]kL20492@P<0UiNG0P2a/K43
061PH080NGUi0P1oOgl30820P080`/;20P1DE5@30:BTY080oooo0P0B4Q83000000809BDU0P3>c/hA
0?ooo`808b<S0P0R8R830:2PX080[:b/0P1mOGd307AdM080Cdm?0P1JFUX304M7A`80E5AD0P1VIVH3
07YjNP80PX:20`1>CTh207alO080a/K60`1ZJVX207EeM@80S8b<0`1JFUX208N7Q`80E5AD0`1:BTX2
071`L080X:2P0`1WIfL207MgM`80YJFU0`2?Shl204Y:BP80HV9R0`0>3Ph202HV9P806QXJ0`1XJ6P2
08:2PP80De=C0`1[Jf/2020P8080:RXZ0`0a<C42059BDP80DE5A0`1:BTX208^;R`<0dM7A0P2RXZ82
0;bl_0<0UiNG0P1oOgl205]KF`<0?clo0P13@d<208Z:RP<0QHF50P32`/8209^KV`<0N7Qh0P2<S8`2
08Z:RP<0U9BD0P1UIFD50?ooo`7o000000001?l00000oooo0?ooo`3oool208V9R@<0MGEe101jNWX3
0861P@80T92@0P2:RXX309BDU080QhN70P2>SXh309ZJVP80NWYj0P30`<0305iNGP80[Zj^0P2;Rh/3
04=3@`80HF5Q0`2IVIT208b<S080`l?30`2PX:020;>c/`80[Zj^0`2e]KD204i>CP8000000`0W9bL2
0?ooo`80aLG50`0c<c<700000080GUiN0P28R8P3030`<080]KFe0P1gMgL302h^;P80inOW0P2f][H3
04U9B@80B4Q80P1HF5P308V9R@80Ogmo0P1_Kfl306IVIP80I6AT0`2EUID2092@T080LG5a0`2;Rh/2
05MGE`80M7Ad0`2DU9@206=SH`80Fe]K0`2>SXh208J6QP80HV9R0`1nOWh209NGU`80_kno0`1[Jf/2
08n?S`80J6QX0`1dM7@205UIF@h0oooo0P3[jn/304M7A`804A4A0P0_;bl306a/K080NWYj0`1_Kfl2
0<[:bP80F5QH0`35aLD209VIV@80Kfm_0`26QXH208Z:RP80Hf=S0`2ATI42065QH@80MgMg0`2;Rh/2
07emO@D0Ogmo0P1MGEd50?ooo`7o000000001?l00000oooo0?ooo`3oool208V9R@<0MGEe101jNWX3
0861P@80T92@0P2:RXX309BDU080QhN70P2>SXh309ZJVP80NWYj0P30`<0305iNGP80[Zj^0P2;Rh/3
04=3@`80HF5Q0`2IVIT208b<S080`l?30`2PX:020;>c/`80[Zj^0`2e]KD204i>CP8000000`0W9bL2
0?ooo`80aLG50`0c<c<700000080GUiN0P28R8P3030`<080]KFe0P1gMgL302h^;P80inOW0P2f][H3
04U9B@80B4Q80P1HF5P308V9R@80Ogmo0P1_Kfl306IVIP80I6AT0`2EUID2092@T080LG5a0`2;Rh/2
05MGE`80M7Ad0`2DU9@206=SH`80Fe]K0`2>SXh208J6QP80HV9R0`1nOWh209NGU`80_kno0`1[Jf/2
08n?S`80J6QX0`1dM7@205UIF@h0oooo0P3[jn/304M7A`804A4A0P0_;bl306a/K080NWYj0`1_Kfl2
0<[:bP80F5QH0`35aLD209VIV@80Kfm_0`26QXH208Z:RP80Hf=S0`2ATI42065QH@80MgMg0`2;Rh/2
07emO@D0Ogmo0P1MGEd50?ooo`7o000000001?l00000oooo0?ooo`3oool208V9R@<0MGEe101jNWX3
0861P@80T92@0P2:RXX309BDU080QhN70P2>SXh309ZJVP80NWYj0P30`<0305iNGP80[Zj^0P2;Rh/3
04=3@`80HF5Q0`2IVIT208b<S080`l?30`2PX:020;>c/`80[Zj^0`2e]KD204i>CP8000000`0W9bL2
0?ooo`80aLG50`0c<c<700000080GUiN0P28R8P3030`<080]KFe0P1gMgL302h^;P80inOW0P2f][H3
04U9B@80B4Q80P1HF5P308V9R@80Ogmo0P1_Kfl306IVIP80I6AT0`2EUID2092@T080LG5a0`2;Rh/2
05MGE`80M7Ad0`2DU9@206=SH`80Fe]K0`2>SXh208J6QP80HV9R0`1nOWh209NGU`80_kno0`1[Jf/2
08n?S`80J6QX0`1dM7@205UIF@h0oooo0P3[jn/304M7A`804A4A0P0_;bl306a/K080NWYj0`1_Kfl2
0<[:bP80F5QH0`35aLD209VIV@80Kfm_0`26QXH208Z:RP80Hf=S0`2ATI42065QH@80MgMg0`2;Rh/2
07emO@D0Ogmo0P1MGEd50?ooo`7o000000001?l00000oooo0?ooo`3oool207YjNP<0Ti>C0P1iNGT5
07moO`80KVi^0P1nOWh3071`L080QHF50P1[Jf/307EeM@80ZZZZ0P2ATI4307moO`80RHV90P1VIVH3
07QhN080Fe]K0`2JVYX206YZJP80KFe]0`3:b/X209^KV`80a/K60`1>CTh200000080@4100`3oool2
02h^;PD000000P1ZJVX207EeM@<0820P1`00000206YZJP80oooo0`3:b/X20;Ng]`80D51@0`1EEED2
06=SH`80Ph>30`1QHF4208j>SP80M7Ad0`2<S8`207QhN0<0P820101[Jf/306e]K@80OWin0P1GEeL3
04=3@`80V9RH0P1TI6@30861P@80M7Ad0P1ADE43051@D080IFEU0P1ZJVX30:JVYP80TI6A0P1ADE43
07MgM`80YjNW0P3oool307IfMP809bLW0P00000302LW9`80OWin1@3oool20>o_k`8000000`0c<c<2
061PH0<0K6a/0P1hN7P20;6a/@<0EEEE0P3;bl/20:n_[`D0QXJ60P1iNGT305eMG@80YJFU0P1fMWH3
07QhN080PH610P1hN7P306IVIP80PH611@3oool1o`00000000Co00000?ooo`3oool0oooo0P1jNWX3
09>CT`80NGUi1@1oOgl206i^KP80OWin0`1`L70208F5Q@80Jf][0`1eMGD20:ZZZP80TI6A0`1oOgl2
08V9R@80IVIV0`1hN7P205]KF`<0VYZJ0P1ZJVX206e]K@<0b/[:0P2KVi/20<K6aP<0CTi>0P000002
0410@0<0oooo0P0^;Rh500000080JVYZ0P1eMGD3020P80L000000P1ZJVX20?ooo`<0b/[:0P2g]kL2
051@D0<0EEEE0P1SHf<208>3P`<0HF5Q0P2>SXh207AdM0<0S8b<0P1hN7P30820P0@0Jf][0`1]KFd2
07inOP80EeMG0`13@d<209RHV080I6AT0`21PH4207AdM080DE5A0`1@D50206EUI@80JVYZ0`2VYZH2
096AT@80DE5A0`1gMgL20:NWY`80oooo0`1fMWH202LW9`8000000`0W9bL207inOPD0oooo0P3_knl2
000000<0<c<c0P1PH60306a/K080N7Qh0P2a/K4305EEE@80bl_;0P2_[jl508J6QP80NGUi0`1MGEd2
0:FUY@80MWIf0`1hN7P20861P@80N7Qh0`1VIVH20861P@D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80O7al0`1gMgL209>CT`80NGUi0`1oOgl207EeM@80KVi^0`26QXH207moO`80i>CT0`2MWId2
0=;BdP80JVYZ0`2?Shl2051@D080HF5Q0`1fMWH209RHV0<0CTi>0P2>SXh207moO`<0UiNG0P1SHf<2
09>CT`<08b<S0P0000020?ooo`<0B4Q8100000030:FUY@80OGem0P26QXH308V9R@80ATI60P000003
0<O7a`80n_[j0P2l_;`30;Fe]@80E5AD0P1mOGd303hn?P80KFe]0P0l?3`309ZJVP80D51@0P2d];@3
06QXJ080LG5a0`2PX:0205]KF`80X:2P0`2?Shl206IVIP80]kNg0`1hN7P205=CD`80I6AT0`1WIfL2
02XZ:P80MgMg0`1MGEd203@d=080De=C0`2m_Kd20=7Ad@80Shn?0`1_Kfl205=CD`8000000`1CDe<2
014A4@L000000P0Q8B4303hn?P@0oooo0`000002020P80<0WYjN0P2KVi/20:RXZ0<0Y:BT0P0j>SX2
0:^[Z`<0[jn_0P1/K6`209fMW@<0_;bl0P1<C4`208R8R0<0XJ6Q0P2?Shl20;Jf]P<0W9bL0P2@T905
0?ooo`7o000000001?l00000oooo0?ooo`3oool207alO0<0MgMg0P2CTi<207UiN@<0Ogmo0P1eMGD2
06i^KP<0QXJ60P1oOgl20>CTi0<0WIfM0P3Bd]8206YZJP<0Shn?0P1@D502065QH@<0MWIf0P2HV9P3
04i>CP80SXj>0P1oOgl309NGU`80Hf=S0P2CTi<302<S8`8000000P3oool304Q8B0@000000`2UYJD2
07emO@80QXJ60`29RHT204I6AP8000000`37alL20?[jnP80_;bl0`2e]KD205ADE080OGem0`0n?Sh2
06e]K@80?3`l0`2JVYX2051@D080];Bd0`1XJ6P2075aL@<0X:2P0P1KFe/20:2PX0<0Shn?0P1VIVH2
0;Ng]`<0N7Qh0P1CDe<206ATI0<0IfMW0P0Z:RX207MgM`<0GEeM0P0d=3@205=CD`<0_Kfm0P3AdM42
08n?S`<0Kfm_0P1CDe<2000000<0De=C0P0A4A47000000808B4Q0`0n?Sh40?ooo`<000000P0P8203
09jNWP80Vi^K0P2XZ:P30:BTY080>SXj0P2[Zj/30:n_[`80K6a/0P2MWId30;bl_080C4a<0P28R8P3
0:6QX@80Shn?0P2f][H309bLW080T92@1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1lO7`3
07MgM`80Ti>C0P1iNGT307moO`80MGEe0P1^KVh308J6QP80Ogmo0P3Ti>@309fMW@80d];B0P1ZJVX3
08n?S`80D51@0P1QHF4307IfMP80V9RH0`1>CTh208j>SP80Ogmo0`2GUiL206=SH`80Ti>C0`0S8b<2
00000080oooo0`18B4P4000000<0YJFU0P1mOGd208J6QP<0RHV90P16ATH2000000<0alO70P3jn_X2
0;bl_0<0]KFe0P1DE5@207emO@<0?Shn0P1]KFd203`l?0<0VYZJ0P1@D5020;Bd]0<0J6QX0P1aLG43
0:2PX080Fe]K0P2PX:0308n?S`80IVIV0P2g]kL307QhN080De=C0P1TI6@306MWI`80:RXZ0P1gMgL3
05eMG@80=3@d0P1CDe<30;fm_@80dM7A0P2?Shl306m_K`80De=C0P00000305=CD`804A4A1`000002
024Q8@<0?Shn103oool300000080820P0`2NWYh209^KV`80Z:RX0`2TY:@203Xj>P80Zj^[0`2_[jl2
06a/K080WIfM0`2l_;`204a<C080R8R80`2QXJ4208n?S`80][Jf0`2LW9`2092@T0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80IfMW0`1eMGD208F5Q@D0Ogmo0P29RHT2092@T0<0Ogmo0P2XZ:P2
06YZJP<0L71`0P1BDU8208V9R@<0VIVI0P2d];@207QhN0<0H61P0P1dM7@3075aL@80XJ6Q0P2i^KT3
096AT@80T92@0P0a<C4300000080SXj>0P2DU9@300000080=3@d0P2CTi<308R8R0@0Ti>C0`2KVi/2
0=7Ad@80m?Cd0`2f][H209FEU@80U9BD0`1[Jf/2020P8080B4Q80`11@D4206MWI`80J6QX0`1CDe<2
09:BTP80I6AT0`1nOWh208b<S0<0Ogmo0P2IVIT203dm?@<0TY:B0P2@T90207emO@<0/;2`0P2GUiL2
08J6QP<0D51@0P22PX8206ATI0<0De=C0P1DE5@209>CT`<0HF5Q0P2^[Zh20=_Kf`<0bl_;0P26QXH7
000000805aLG0`2BTY8205EEE@D000000P0V9RH20?7al@<0oooo0P0J6QX3010@4080f=SH0P29RHT3
09BDU080IfMW0P1RHV8309BDU080`/;20P1QHF4306YZJP80OGem0P2CTi<307UiN@80QXJ60P1fMWH3
09:BTP80TI6A1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1WIfL307EeM@80QHF51@1oOgl2
08V9R@80T92@0`1oOgl20:RXZ080JVYZ0`1`L702059BDP80RHV90`2IVIT20;Bd]080N7Qh0`1PH602
07AdM0<0LG5a0P2QXJ420;Vi^@<0TI6A0P2@T902034a<@<000000P2>SXh209BDU0<000000P0d=3@2
09>CT`<0R8R8102CTi<309^KV`80dM7A0P3dm?@30;Jf]P80UIFE0P2DU9@306][J`80820P0P18B4P3
0451@@80IfMW0P1XJ6P305=CD`80TY:B0P1TI6@307inOP80S8b<0`1oOgl209VIV@80?Cdm0`2BTY82
092@T080OGem0`2`/;0209NGU`80QXJ60`1@D50208:2PP80I6AT0`1CDe<205ADE080Ti>C0`1QHF42
0:j^[P80fm_K0`3;bl/208J6QPL000000P0G5aL309:BTP80EEEE1@00000202HV9P80lO7a0`3oool2
01XJ6P<0410@0P3Hf=P208V9R@<0U9BD0P1WIfL2069RHP<0U9BD0P32`/82065QH@<0JVYZ0P1mOGd2
09>CT`<0NGUi0P26QXH207IfMP<0TY:B0P2ATI450?ooo`7o000000001?l00000oooo0?ooo`3oool2
07QhN0<0KVi^0P1eMGD208F5Q@D0Ogmo0P1eMGD307alO080ADE50P1[Jf/309>CT`80DE5A0P1fMWH3
0;Jf]P80?Cdm0P1oOgl309bLW080NWYj0`25QHD20<O7a`80^[Zj0`1dM7@206QXJ080?Shn0`2<S8`2
0;6a/@80GUiN0`1LG5`20=3@d080^KVi0`3lo?`40?ooo`<0hn?S0P35aLD205=CD`<0IfMW0P1>CTh2
06YZJP<0MGEe0P1UIFD205ADE0<0Lg=c0P1TI6@208^;R`<0[Zj^0P2:RXX206m_K`<0MgMg0P1[Jf/3
08N7Q`80I6AT0P1nOWh308J6QP80KFe]0P1EEED306e]K@80V9RH0P2EUID306m_K`80TY:B0P1:BTX3
05EEE@80Rh^;0P1;Bd/3069RHP80X:2P0P30`<030;no_`80oooo0P2XZ:P3061PH080@T920P2CTi<3
07moO`80RHV90P1lO7`300`<30@000000`1EEED20?ooo`<00@410P0I6AT20=GEe@<0`L710P3GemL2
0<G5a@<0GUiN0P0];Bd20:^[Z`<0K6a/0P2KVi/207inOP<0Ph>30P1mOGd206i^KP<0Rh^;0P1mOGd5
0?ooo`7o000000001?l00000oooo0?ooo`3oool207QhN0<0KVi^0P1eMGD208F5Q@D0Ogmo0P1eMGD3
07alO080ADE50P1[Jf/309>CT`80DE5A0P1fMWH30;Jf]P80?Cdm0P1oOgl309bLW080NWYj0`25QHD2
0<O7a`80^[Zj0`1dM7@206QXJ080?Shn0`2<S8`20;6a/@80GUiN0`1LG5`20=3@d080^KVi0`3lo?`4
0?ooo`<0hn?S0P35aLD205=CD`<0IfMW0P1>CTh206YZJP<0MGEe0P1UIFD205ADE0<0Lg=c0P1TI6@2
08^;R`<0[Zj^0P2:RXX206m_K`<0MgMg0P1[Jf/308N7Q`80I6AT0P1nOWh308J6QP80KFe]0P1EEED3
06e]K@80V9RH0P2EUID306m_K`80TY:B0P1:BTX305EEE@80Rh^;0P1;Bd/3069RHP80X:2P0P30`<03
0;no_`80oooo0P2XZ:P3061PH080@T920P2CTi<307moO`80RHV90P1lO7`300`<30@000000`1EEED2
0?ooo`<00@410P0I6AT20=GEe@<0`L710P3GemL20<G5a@<0GUiN0P0];Bd20:^[Z`<0K6a/0P2KVi/2
07inOP<0Ph>30P1mOGd206i^KP<0Rh^;0P1mOGd50?ooo`7o000000001?l00000oooo0?ooo`3oool2
07QhN0<0KVi^0P1eMGD208F5Q@D0Ogmo0P1eMGD307alO080ADE50P1[Jf/309>CT`80DE5A0P1fMWH3
0;Jf]P80?Cdm0P1oOgl309bLW080NWYj0`25QHD20<O7a`80^[Zj0`1dM7@206QXJ080?Shn0`2<S8`2
0;6a/@80GUiN0`1LG5`20=3@d080^KVi0`3lo?`40?ooo`<0hn?S0P35aLD205=CD`<0IfMW0P1>CTh2
06YZJP<0MGEe0P1UIFD205ADE0<0Lg=c0P1TI6@208^;R`<0[Zj^0P2:RXX206m_K`<0MgMg0P1[Jf/3
08N7Q`80I6AT0P1nOWh308J6QP80KFe]0P1EEED306e]K@80V9RH0P2EUID306m_K`80TY:B0P1:BTX3
05EEE@80Rh^;0P1;Bd/3069RHP80X:2P0P30`<030;no_`80oooo0P2XZ:P3061PH080@T920P2CTi<3
07moO`80RHV90P1lO7`300`<30@000000`1EEED20?ooo`<00@410P0I6AT20=GEe@<0`L710P3GemL2
0<G5a@<0GUiN0P0];Bd20:^[Z`<0K6a/0P2KVi/207inOP<0Ph>30P1mOGd206i^KP<0Rh^;0P1mOGd5
0?ooo`7o000000001?l00000oooo0?ooo`3oool508J6QP80IfMW0P2<S8`308>3P`80Lg=c0P22PX83
07EeM@80RHV90P1RHV8309VIV@80QhN70P1]KFd307=cL`80UIFE0P1_Kfl308:2PP80IfMW0`2:RXX2
05EEE@80>3Ph0`1fMWH208R8R080AdM70`2LW9`208b<S080@d=30`2NWYh20:2PX080[jn_0`3@d=02
08J6QP80N7Qh0`2XZ:P2061PH080UIFE0`0m?Cd209>CT`80LG5a0`1ADE4208J6QP80I6AT0`29RHT2
06i^KP80QHF50`1MGEd206m_K`80_[jn0`1`L70208F5Q@<0RXZ:0P1`L702075aL@<0QHF50P2TY:@2
055AD@<0WYjN0P1GEeL20820P0<0_;bl0P1/K6`207QhN0<0IVIV0P1BDU8208>3P`<0TI6A0P1?Cdl2
06QXJ0<0M7Ad0P2ATI420>_[j`<0dm?C0P32`/820::RXP<0S8b<0P2HV9P208N7Q`<0PX:20P0W9bL2
05ADE0<0@T920P1iNGT30:RXZ080410@0P0e=CD305aLG0@0XJ6Q0`2HV9P209jNWP80PH610`1_Kfl2
06ATI080PX:20`2BTY82069RHP80P8200`1ZJVX209RHV0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`D0QXJ60P1WIfL208b<S0<0Ph>30P1cLg<208:2PP<0MGEe0P29RHT2069RHP<0VIVI0P27QhL2
06e]K@<0Lg=c0P2EUID206m_K`<0PX:20P1WIfL308Z:RP80EEEE0P0h>3P307IfMP80R8R80P17AdL3
09bLW080S8b<0P13@d<309jNWP80X:2P0P2_[jl30=3@d080QXJ60P1hN7P30:RXZ080H61P0P2EUID3
03dm?@80Ti>C0P1aLG43055AD@80QXJ60P1TI6@308V9R@80KVi^0P25QHD305eMG@80Kfm_0P2n_[h3
071`L080QHF50`2:RXX2071`L080LG5a0`25QHD20:BTY080DE5A0`2NWYh205MGE`80P8200`2l_;`2
06a/K080N7Qh0`1VIVH2059BDP80Ph>30`2ATI4204m?C`80J6QX0`1dM7@2096AT@80jn_[0`3Cdm<2
0<;2`P80XZ:R0`2<S8`209RHV080QhN70`22PX8202LW9`80E5AD0`12@T8207UiN@<0Z:RX0P0@4102
03De=@<0G5aL102QXJ4309RHV080WYjN0P21PH4306m_K`80I6AT0P22PX8309:BTP80HV9R0P20P803
06YZJP80V9RH1@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX8307EeM@80N7Qh0P1lO7`3
07YjNP80Rh^;0P1lO7`308V9R@80T92@0P2a/K4309RHV080L71`0P2<S8`308^;R`80Fe]K0P3<c<`3
0::RXP80e=CD0`2BTY82030`<080D51@0`0?3`l202PX:080S8b<0`2@T90206QXJ080[Zj^0`3Cdm<2
0?ooo`80d];B0`1EEED2075aL@80I6AT0`1lO7`20<?3``80R8R80`2e]KD20;Bd]080NWYj0`1oOgl2
07emO@D0Ogmo0P1^KVh20:ZZZP<0K6a/0P2j^[X203dm?@<0Shn?0P3Cdm<308^;R`80d=3@0P2ZZZX3
04m?C`80Lg=c0P2GUiL307emO@80VIVI0P2RXZ8306IVIP80PX:20P1^KVh30:>SX`80EeMG0P1WIfL3
07emO@80SXj>0P1JFUX306m_K`80FEUI0P2BTY830;Bd]080h>3P0P3Lg=`30?ooo`80ZZZZ0P2IVIT3
0:6QX@80X:2P0P0l?3`307EeM@80Hf=S0`3dm?@202d];@80QHF50`26QXH205aLG080F5QH0`26QXH2
075aL@80L71`0`2MWId207inOP80[:b/0`1NGUh208F5Q@80De=C0`27QhL20861P@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80PX:20`1eMGD207QhN080O7al0`1jNWX208^;R`80O7al0`29RHT2
092@T080/K6a0`2HV9P2071`L080S8b<0`2;Rh/205]KF`80c<c<0`2RXZ820=CDe0<0TY:B0P0`<302
051@D0<03`l?0P0X:2P208b<S0<0T92@0P1XJ6P20:j^[P<0dm?C0P3oool20=;BdP<0EEEE0P1aLG42
06ATI0<0O7al0P33`l<208R8R0<0]KFe0P2d];@207YjNP<0Ogmo0P1mOGd507moO`80KVi^0P2ZZZX3
06a/K080^[Zj0P0m?Cd308n?S`80dm?C0`2;Rh/20=3@d080ZZZZ0`1?Cdl207=cL`80UiNG0`1mOGd2
09VIV@80XZ:R0`1VIVH208:2PP80KVi^0`2SXj<205MGE`80IfMW0`1mOGd208j>SP80FUYJ0`1_Kfl2
05UIF@80TY:B0`2d];@20>3Ph080g=cL0`3oool20:ZZZP80VIVI0`2QXJ420:2PX080?3`l0`1eMGD2
06=SH`<0m?Cd0P0];Bd208F5Q@<0QXJ60P1LG5`205QHF0<0QXJ60P1aLG42071`L0<0WIfM0P1nOWh2
0:b/[0<0GUiN0P25QHD205=CD`<0QhN70P21PH450?ooo`7o000000001?l00000oooo0?ooo`3oool2
08:2PP<0MGEe0P1hN7P207alO0<0NWYj0P2;Rh/207alO0<0RHV90P2@T9020;6a/@<0V9RH0P1`L702
08b<S0<0Rh^;0P1KFe/20<c<c0<0XZ:R0P3De=@309:BTP80<30`0P1@D50300l?3`80:2PX0P2<S8`3
092@T080J6QX0P2^[Zh30=?Cd`80oooo0P3Bd]8305EEE@80LG5a0P1TI6@307alO080`l?30P28R8P3
0;Fe]@80];Bd0P1jNWX307moO`80OGem1@1oOgl206i^KP80ZZZZ0`1/K6`20;Zj^P80?Cdm0`2?Shl2
0=?Cd`<0Rh^;0P3@d=020:ZZZP<0Cdm?0P1cLg<209NGU`<0OGem0P2IVIT20::RXP<0IVIV0P22PX82
06i^KP<0Xj>S0P1GEeL206MWI`<0OGem0P2>SXh205YJFP<0Kfm_0P1IFET209:BTP<0];Bd0P3Ph>02
0=cLg0<0oooo0P2ZZZX209VIV@<0XJ6Q0P2PX:0203`l?0<0MGEe0P1SHf<30?Cdm080;Bd]0P25QHD3
08J6QP80G5aL0P1HF5P308J6QP80LG5a0P1`L70309fMW@80OWin0P2/[:`305iNGP80QHF50P1CDe<3
08N7Q`80PH611@3oool1o`00000000Co00000?ooo`3oool0oooo0P1eMGD308b<S080O7al0P1[Jf/3
08b<S080Lg=c0P2<S8`309NGU`80[jn_0P2ATI4307UiN@80SXj>0P2ATI43071`L080QHF50P0Z:RX3
03dm?@80Fe]K0`2EUID20<K6aP80?clo0`1QHF4203dm?@80QXJ60`2l_;`20=cLg080[Zj^0`3?cll2
00h>3P80QHF50`1^KVh204M7A`80TI6A0`27QhL207emO@80^;Rh0`2HV9P205aLG080RHV90`2BTY82
09>CT`80Kfm_0`2;Rh/208J6QP80HF5Q0`2VYZH206MWI`80V9RH0`2WYjL2055AD@<0T92@0P1iNGT2
07IfMP<0Jf][0P1UIFD20<30`0<0MgMg0P2GUiL205ADE0<0TI6A0P1UIFD20820P0<0Bd];0P2HV9P2
04i>CP<0G5aL0P2TY:@20:NWY`<0U9BD0P2:RXX205UIF@<0RHV90P1^KVh20:ZZZP<0QhN70P3GemL2
0>?Sh`<0emOG0P29RHT2061PH0<0=SHf0P1LG5`303Ph>080EeMG0P092@T301XJ6P80;Bd]0P1oOgl3
0820P080alO70P2XZ:P3071`L080MWIf0P1ZJVX309jNWP80IVIV0P2EUID307UiN@80GEeM1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1eMGD308b<S080O7al0P1[Jf/308b<S080Lg=c0P2<S8`3
09NGU`80[jn_0P2ATI4307UiN@80SXj>0P2ATI43071`L080QHF50P0Z:RX303dm?@80Fe]K0`2EUID2
0<K6aP80?clo0`1QHF4203dm?@80QXJ60`2l_;`20=cLg080[Zj^0`3?cll200h>3P80QHF50`1^KVh2
04M7A`80TI6A0`27QhL207emO@80^;Rh0`2HV9P205aLG080RHV90`2BTY8209>CT`80Kfm_0`2;Rh/2
08J6QP80HF5Q0`2VYZH206MWI`80V9RH0`2WYjL2055AD@<0T92@0P1iNGT207IfMP<0Jf][0P1UIFD2
0<30`0<0MgMg0P2GUiL205ADE0<0TI6A0P1UIFD20820P0<0Bd];0P2HV9P204i>CP<0G5aL0P2TY:@2
0:NWY`<0U9BD0P2:RXX205UIF@<0RHV90P1^KVh20:ZZZP<0QhN70P3GemL20>?Sh`<0emOG0P29RHT2
061PH0<0=SHf0P1LG5`303Ph>080EeMG0P092@T301XJ6P80;Bd]0P1oOgl30820P080alO70P2XZ:P3
071`L080MWIf0P1ZJVX309jNWP80IVIV0P2EUID307UiN@80GEeM1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1oOgl307EeM@80PX:20P1eMGD306MWI`80VIVI0P20P80307=cL`80[Zj^0P38b<P3
0820P0@0Ogmo0`1dM7@208b<S080Zj^[0`2NWYh208Z:RP<0Kfm_0P1EEED20?Win@<0RXZ:0P2XZ:P2
0820P0<0S8b<0P1[Jf/208N7Q`<0EEEE0P1TI6@2065QH@<0[:b/0P2GUiL204E5A@<0PH610P1HF5P2
05]KF`<0KVi^0P27QhL20<?3``<0Lg=c0P2JVYX208b<S0<0KFe]0P3Cdm<2092@T0<0L71`0P2[Zj/2
06=SH`<0K6a/0P27QhL307moO`80RHV90P1eMGD30;Zj^P80alO70P1^KVh30;Bd]080Lg=c0P1mOGd3
07QhN080M7Ad0P2:RXX30:RXZ080L71`0P1^KVh307MgM`80K6a/0P1cLg<30:j^[P80WIfM0P1nOWh3
08n?S`80PX:20P1MGEd507moO`80[:b/0`2d];@20?KfmP80oooo0`2`/;0206e]K@<0GEeM0P35aLD2
06][J`<0O7al0P2NWYh208:2PP<0YZJV0P1;Bd/204m?C`<0Zj^[0P2SXj<208F5Q@<0RHV90P20P802
07emO@<0KVi^0P2?Shl50?ooo`7o000000001?l00000oooo0?ooo`3oool207moO`<0MGEe0P22PX82
07EeM@<0IfMW0P2IVIT20820P0<0Lg=c0P2^[Zh20<S8b0<0P820101oOgl307AdM080S8b<0P2[Zj/3
09jNWP80RXZ:0`1_Kfl205EEE@80nOWi0`2:RXX20:RXZ080P8200`2<S8`206][J`80QhN70`1EEED2
06ATI080HF5Q0`2/[:`209NGU`80ADE50`21PH4205QHF080Fe]K0`1^KVh208N7Q`80`l?30`1cLg<2
09ZJVP80S8b<0`1]KFd20=?Cd`80T92@0`1`L7020:^[Z`80Hf=S0`1/K6`208N7Q`<0Ogmo0P29RHT2
07EeM@<0^[Zj0P37alL206i^KP<0];Bd0P1cLg<207emO@<0N7Qh0P1dM7@208Z:RP<0Z:RX0P1`L702
06i^KP<0MgMg0P1/K6`207=cL`<0[Zj^0P2MWId207inOP<0Shn?0P22PX8205eMG@D0Ogmo0P2/[:`3
0;Bd]080m_Kf0P3oool30;2`/080KFe]0`1MGEd20<G5a@80Jf][0`1lO7`209jNWP80PX:20`2VYZH2
04];B`80Cdm?0`2[Zj/20:>SX`80QHF50`29RHT20820P080OGem0`1^KVh208n?S`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80Ogmo0`1eMGD208:2PP80MGEe0`1WIfL209VIV@80P8200`1cLg<2
0:j^[P80b<S80`20P80407moO`<0M7Ad0P2<S8`20:^[Z`<0WYjN0P2:RXX306m_K`80EEEE0P3inOT3
08Z:RP80Z:RX0P20P80308b<S080Jf][0P27QhL305EEE@80I6AT0P1QHF430:b/[080UiNG0P15ADD3
0861P@80F5QH0P1KFe/306i^KP80QhN70P33`l<307=cL`80VYZJ0P2<S8`306e]K@80dm?C0P2@T903
071`L080Zj^[0P1SHf<306a/K080QhN70`1oOgl208V9R@80MGEe0`2j^[X20<O7a`80KVi^0`2d];@2
07=cL`80OGem0`1hN7P207AdM080RXZ:0`2XZ:P2071`L080KVi^0`1gMgL206a/K080Lg=c0`2^[Zh2
09fMW@80OWin0`2?Shl208:2PP80GEeM1@1oOgl20:b/[0<0];Bd0P3fm_H20?ooo`<0/;2`0P1]KFd3
05eMG@80aLG50P1[Jf/307alO080WYjN0P22PX830:JVYP80Bd];0P1?Cdl30:^[Z`80Xj>S0P25QHD3
08V9R@80P8200P1mOGd306i^KP80Shn?1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1oOgl3
08V9R@80O7al0P1oOgl307EeM@80O7al0P1`L70308F5Q@80RHV90P2CTi<306YZJP80U9BD0P2ATI43
0:2PX080KVi^0P1cLg<309^KV`80MgMg0`2TY:@209^KV`80:b/[0`29RHT20:RXZ080fm_K0`1PH602
07MgM`80:RXZ0`1EEED206][J`80Lg=c0`1VIVH2096AT@80YJFU0`1^KVh208>3P`80H61P0`2<S8`2
0<S8b080PH610`1UIFD2071`L080QXJ60`2^[Zh2069RHP80V9RH0`2<S8`205YJFP80UiNG0`1`L702
06ATI0<0PX:20P28R8P209RHV0<0QhN70P20P80207IfMP<0TY:B0P2RXZ8207EeM@<0OWin0P1hN7P2
06YZJP<0J6QX0P2QXJ4208n?S`<0QHF50P1dM7@20:ZZZP<0HF5Q0P25QHD20;Rh^0<0MWIf0P1[Jf/2
05aLG0<0N7Qh0P1TI6@207=cL`<0OGem0P16ATH203De=@<0U9BD0P29RHT30:RXZ080Shn?0P2MWId3
05YJFP80P8200P1SHf<306ATI080TY:B0P2:RXX306YZJP80OWin0P2;Rh/307alO0L0Ogmo0P2<S8`5
0?ooo`7o000000001?l00000oooo0?ooo`3oool207moO`<0RHV90P1lO7`207moO`<0MGEe0P1lO7`2
071`L0<0QHF50P29RHT209>CT`<0JVYZ0P2DU9@2096AT@<0X:2P0P1^KVh207=cL`<0Vi^K0P1gMgL3
0:BTY080Vi^K0P0[:b/308V9R@80Z:RX0P3Kfm/3061PH080MgMg0P0Z:RX305EEE@80Jf][0P1cLg<3
06IVIP80TI6A0P2UYJD306i^KP80Ph>30P1PH60308b<S080b<S80P21PH4306EUI@80L71`0P26QXH3
0:j^[P80HV9R0P2HV9P308b<S080FUYJ0P2GUiL3071`L080I6AT0`22PX8208R8R080V9RH0`27QhL2
0820P080MWIf0`2BTY820::RXP80MGEe0`1nOWh207QhN080JVYZ0`1XJ6P20:6QX@80Shn?0`25QHD2
07AdM080ZZZZ0`1QHF4208F5Q@80^;Rh0`1fMWH206][J`80G5aL0`1hN7P206ATI080Lg=c0`1mOGd2
04I6AP80=CDe0`2DU9@208V9R@<0Z:RX0P2?Shl209fMW@<0FUYJ0P20P80206=SH`<0I6AT0P2BTY82
08Z:RP<0JVYZ0P1nOWh208^;R`<0O7al1`1oOgl208b<S0D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80Ogmo0`1eMGD208:2PP80Ogmo0`29RHT2075aL@80WIfM0`27QhL20:RXZ080F5QH0`1_Kfl2
05]KF`80MWIf0`1KFe/206QXJ080MgMg0`2MWId20451@@<07QhN0P1iNGT20::RXP<0VYZJ0P1gMgL2
00/;2`<0][Jf0P1HF5P20;Jf]P<0DU9B0P2<S8`207MgM`<0ADE50P2CTi<20:NWY`<0c<c<0P2e]KD2
08R8R0<0Ph>30P1DE5@20:2PX0<0[Zj^0P1ZJVX208j>SP<0Hf=S0P1XJ6P206ATI0<0TY:B0P1mOGd2
092@T0<0OGem0P2PX:0303hn?P80U9BD0P1IFET308n?S`80?Shn0P2:RXX304I6AP8092@T0P2GUiL3
08Z:RP80Ph>30P2DU9@309FEU@80KVi^0P2VYZH308Z:RP80OWin0P2UYJD306ATI080GUiN0P1ZJVX3
09^KV`80RXZ:0P2KVi/304m?C`80TY:B0P0m?Cd305]KF`80IVIV0P1cLg<307AdM080Ogmo0`2PX:02
09fMW@80GEeM0`26QXH2034a<@80=cLg0`1?Cdl209>CT`80PH610`2TY:@209RHV080K6a/0`1jNWX2
09bLW080P8200`2<S8`206a/K0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80Ogmo0`1eMGD2
08:2PP80Ogmo0`29RHT2075aL@80WIfM0`27QhL20:RXZ080F5QH0`1_Kfl205]KF`80MWIf0`1KFe/2
06QXJ080MgMg0`2MWId20451@@<07QhN0P1iNGT20::RXP<0VYZJ0P1gMgL200/;2`<0][Jf0P1HF5P2
0;Jf]P<0DU9B0P2<S8`207MgM`<0ADE50P2CTi<20:NWY`<0c<c<0P2e]KD208R8R0<0Ph>30P1DE5@2
0:2PX0<0[Zj^0P1ZJVX208j>SP<0Hf=S0P1XJ6P206ATI0<0TY:B0P1mOGd2092@T0<0OGem0P2PX:03
03hn?P80U9BD0P1IFET308n?S`80?Shn0P2:RXX304I6AP8092@T0P2GUiL308Z:RP80Ph>30P2DU9@3
09FEU@80KVi^0P2VYZH308Z:RP80OWin0P2UYJD306ATI080GUiN0P1ZJVX309^KV`80RXZ:0P2KVi/3
04m?C`80TY:B0P0m?Cd305]KF`80IVIV0P1cLg<307AdM080Ogmo0`2PX:0209fMW@80GEeM0`26QXH2
034a<@80=cLg0`1?Cdl209>CT`80PH610`2TY:@209RHV080K6a/0`1jNWX209bLW080P8200`2<S8`2
06a/K0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80Ogmo0`1eMGD208:2PP80Ogmo0`29RHT2
075aL@80WIfM0`27QhL20:RXZ080F5QH0`1_Kfl205]KF`80MWIf0`1KFe/206QXJ080MgMg0`2MWId2
0451@@<07QhN0P1iNGT20::RXP<0VYZJ0P1gMgL200/;2`<0][Jf0P1HF5P20;Jf]P<0DU9B0P2<S8`2
07MgM`<0ADE50P2CTi<20:NWY`<0c<c<0P2e]KD208R8R0<0Ph>30P1DE5@20:2PX0<0[Zj^0P1ZJVX2
08j>SP<0Hf=S0P1XJ6P206ATI0<0TY:B0P1mOGd2092@T0<0OGem0P2PX:0303hn?P80U9BD0P1IFET3
08n?S`80?Shn0P2:RXX304I6AP8092@T0P2GUiL308Z:RP80Ph>30P2DU9@309FEU@80KVi^0P2VYZH3
08Z:RP80OWin0P2UYJD306ATI080GUiN0P1ZJVX309^KV`80RXZ:0P2KVi/304m?C`80TY:B0P0m?Cd3
05]KF`80IVIV0P1cLg<307AdM080Ogmo0`2PX:0209fMW@80GEeM0`26QXH2034a<@80=cLg0`1?Cdl2
09>CT`80PH610`2TY:@209RHV080K6a/0`1jNWX209bLW080P8200`2<S8`206a/K0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`h0Ogmo0P29RHT30;Fe]@80F5QH0P1^KVh306EUI@80QhN70P1HF5P5
05YJFP80NGUi0`1RHV820;Zj^P<0Vi^K0P1ZJVX20:ZZZP<0[Zj^0P2TY:@209^KV`<0CTi>0P2XZ:P2
03`l?0<0TY:B102CTi<30<[:bP80H61P0P1HF5P306ATI080;Rh^0P1mOGd30;Vi^@80`<300P12@T83
07IfMP80Zj^[0P1iNGT309^KV`80XJ6Q1@1EEED208b<S080V9RH0`2EUID207alO0<0QhN70P1lO7`2
0:NWY`<0IfMW0P1hN7P2092@T0<0L71`0P2CTi<207=cL`<0H61P0P1cLg<20:FUY@<0S8b<0P2?Shl2
071`L0<0UIFE0P2GUiL208b<S0<0TY:B0P1HF5P206][J`<0N7Qh0P1jNWX207alO0<0aLG50P1XJ6P2
08V9R@<0IfMW0P2<S8`205QHF0<0Rh^;0P1lO7`303dm?@80KFe]0P2QXJ43075aL@80]kNg0P2?Shl3
0:2PX080OWin0P1jNWX507moO`80S8b<0`2EUID209BDU080QXJ60`20P80207emO@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`h0Ogmo0P29RHT30;Fe]@80F5QH0P1^KVh306EUI@80QhN70P1HF5P5
05YJFP80NGUi0`1RHV820;Zj^P<0Vi^K0P1ZJVX20:ZZZP<0[Zj^0P2TY:@209^KV`<0CTi>0P2XZ:P2
03`l?0<0TY:B102CTi<30<[:bP80H61P0P1HF5P306ATI080;Rh^0P1mOGd30;Vi^@80`<300P12@T83
07IfMP80Zj^[0P1iNGT309^KV`80XJ6Q1@1EEED208b<S080V9RH0`2EUID207alO0<0QhN70P1lO7`2
0:NWY`<0IfMW0P1hN7P2092@T0<0L71`0P2CTi<207=cL`<0H61P0P1cLg<20:FUY@<0S8b<0P2?Shl2
071`L0<0UIFE0P2GUiL208b<S0<0TY:B0P1HF5P206][J`<0N7Qh0P1jNWX207alO0<0aLG50P1XJ6P2
08V9R@<0IfMW0P2<S8`205QHF0<0Rh^;0P1lO7`303dm?@80KFe]0P2QXJ43075aL@80]kNg0P2?Shl3
0:2PX080OWin0P1jNWX507moO`80S8b<0`2EUID209BDU080QXJ60`20P80207emO@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80PX:22P1oOgl207EeM@80N7Qh0`2l_;`207UiN@80FEUI0`2:RXX2
092@T080Ph>30`1WIfL20;Fe]@80MWIf0`1iNGT206a/K0<0UiNG0P2UYJD20861P@<0QhN70P0d=3@2
08b<S0<0O7al0P1nOWh209^KV`<0F5QH0P1lO7`20;Jf]P<0Jf][0P2:RXX206i^KP<0J6QX0P2j^[X2
09>CT`<0DE5A0P2ATI420820P0<0Xj>S0P1HF5P20<o?c`<0MGEe0P1]KFd20:n_[`<0JVYZ101`L703
0=?Cd`80J6QX0`2EUID207MgM`80_;bl0`2QXJ420;jn_P80KVi^0`1GEeL208F5Q@80ZZZZ0`2CTi<2
0:2PX080FEUI0`2:RXX206IVIP80TI6A0`2@T90208b<S080Ogmo0`2:RXX208n?S`80EeMG0`1mOGd2
07=cL`80H61P0`0];Bd205iNGP80P8200`26QXH205=CD`80Ph>30`0e=CD206YZJP<0Xj>S101^KVh3
07QhN080QhN70P2VYZH309NGU`80Kfm_0P2DU9@307QhN080HF5Q0P2MWId308b<S080RHV90P20P803
07emO@80S8b<1@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX8:07moO`80MGEe0P1hN7P3
0;bl_080NGUi0P1IFET308Z:RP80T92@0P23Ph<306MWI`80]KFe0P1fMWH307UiN@80K6a/0`2GUiL2
0:FUY@80PH610`27QhL203@d=080S8b<0`1lO7`207inOP80Vi^K0`1HF5P207alO080][Jf0`1[Jf/2
08Z:RP80KVi^0`1XJ6P20;Zj^P80Ti>C0`1ADE42096AT@80P8200`2SXj<205QHF080clo?0`1eMGD2
06e]K@80[jn_0`1ZJVX4071`L0<0dm?C0P1XJ6P309FEU@80MgMg0P2l_;`30:6QX@80_[jn0P1^KVh3
05MGE`80QHF50P2ZZZX309>CT`80X:2P0P1IFET308Z:RP80IVIV0P2ATI43092@T080S8b<0P1oOgl3
08Z:RP80Shn?0P1GEeL307emO@80Lg=c0P1PH60302d];@80GUiN0P20P80308J6QP80De=C0P23Ph<3
03De=@80JVYZ0`2SXj<406i^KP<0N7Qh0P27QhL20:JVYP<0UiNG0P1_Kfl209BDU0<0N7Qh0P1QHF42
09fMW@<0S8b<0P29RHT20820P0<0OGem0P2<S8`50?ooo`7o000000001?l00000oooo0?ooo`3oool2
08:2PPX0Ogmo0P1eMGD207QhN0<0_;bl0P1iNGT205UIF@<0RXZ:0P2@T90208>3P`<0IfMW0P2e]KD2
07IfMP<0NGUi0P1/K6`309NGU`80YJFU0P21PH4308N7Q`80=3@d0P2<S8`307alO080OWin0P2KVi/3
05QHF080O7al0P2f][H306][J`80RXZ:0P1^KVh306QXJ080^[Zj0P2CTi<3055AD@80TI6A0P20P803
0:>SX`80F5QH0P3?cll307EeM@80KFe]0P2_[jl306YZJP@0L71`0`3Cdm<206QXJ0<0UIFE0P1gMgL2
0;bl_0<0XJ6Q0P2n_[h206i^KP<0EeMG0P25QHD20:ZZZP<0Ti>C0P2PX:0205UIF@<0RXZ:0P1VIVH2
096AT@<0T92@0P2<S8`207moO`<0RXZ:0P2?Shl205MGE`<0OGem0P1cLg<2061PH0<0;Bd]0P1NGUh2
0820P0<0QXJ60P1CDe<208>3P`<0=CDe0P1ZJVX30:>SX`@0KVi^0`1hN7P208N7Q`80YZJV0`2GUiL2
06m_K`80U9BD0`1hN7P2065QH@80WIfM0`2<S8`208V9R@80P8200`1mOGd208b<S0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo``0Ogmo0P29RHT20:j^[P<0Ogmo0P2ATI420:JVYP<0U9BD0P1mOGd2
092@T0<0UiNG0P22PX8208R8R0<0OWin0P15ADD307AdM080D51@0P1ZJVX307moO`80`l?30P2EUID3
08F5Q@80GEeM0P1jNWX309^KV`80MgMg0P0o?cl307=cL`80Vi^K0P2i^KT30:2PX080MgMg0P1lO7`3
09>CT`80Jf][0P2HV9P3065QH@80Z:RX0P28R8P308b<S080LG5a0P2;Rh/309ZJVP80O7al0P2ATI43
08J6QP80W9bL0`1LG5`207IfMP80M7Ad0`0n?Sh209fMW@80IFEU0`30`<0206QXJ080SXj>0`1nOWh2
0;2`/080T92@0`2BTY8208J6QP80TI6A0`2PX:0209>CT`80H61P0`2WYjL20:f][@80Z:RX0`1[Jf/2
092@T080`<300`2GUiL2069RHP80OGem0`1`L70208n?S`80T92@0`2JVYX207MgM`<0Shn?0P1XJ6P2
08n?S`<0VYZJ0P29RHT208:2PP<0:b/[0P1MGEd507moO`80W9bL0P2:RXX309NGU`80YjNW0P2@T903
059BDP80Ph>31@3oool1o`00000000Co00000?ooo`3oool0oooo301oOgl208V9R@80[Zj^0`1oOgl2
096AT@80YZJV0`2DU9@207emO@80T92@0`2GUiL208:2PP80R8R80`1nOWh204E5A@<0M7Ad0P1@D502
06YZJP<0Ogmo0P33`l<209FEU@<0QHF50P1MGEd207YjNP<0Vi^K0P1gMgL203lo?`<0Lg=c0P2KVi/2
0;Vi^@<0X:2P0P1gMgL207alO0<0Ti>C0P1[Jf/209RHV0<0HF5Q0P2XZ:P208R8R0<0S8b<0P1aLG42
08^;R`<0VYZJ0P1lO7`2096AT@<0QXJ60P2LW9`305aLG080MWIf0P1dM7@303hn?P80WIfM0P1UIFD3
0<30`080J6QX0P2>SXh307inOP80/;2`0P2@T90309:BTP80QXJ60P2ATI430:2PX080Ti>C0P1PH603
0:NWY`80[Jf]0P2XZ:P306][J`80T92@0P30`<0309NGU`80HV9R0P1mOGd3071`L080Shn?0P2@T903
09ZJVP80MgMg0`2?Shl206QXJ080Shn?0`2JVYX208V9R@80PX:20`0[:b/205eMG@D0Ogmo0P2LW9`2
08Z:RP<0UiNG0P2WYjL2092@T0<0DU9B0P23Ph<50?ooo`7o000000001?l00000oooo0?ooo`3oool>
07moO`80]KFe0`25QHD208R8R080[jn_0`1ZJVX205]KF`80QHF50`1nOWh207UiN@80Shn?0`25QHD2
0=OGe`<0RHV90P2QXJ420<?3``<0MgMg0P1lO7`207MgM`<0Rh^;0P2JVYX208J6QP<0U9BD0P1KFe/2
05UIF@<0OWin0P1]KFd204i>CP<0MgMg0P2LW9`206i^KP<0VYZJ0P1VIVH209bLW0<0PH610P1aLG42
07EeM@<0RXZ:0P2UYJD208V9R@<0MgMg0P22PX820861P@<0=cLg0P2@T90308n?S`80W9bL0P2PX:03
08R8R080L71`0P3Ph>0306e]K@80X:2P0P1>CTh3071`L080M7Ad0P1oOgl3059BDP80Shn?0P2MWId3
05YJFP80FEUI0P2g]kL304a<C080Shn?0P2LW9`30:^[Z`80OWin0P27QhL309:BTP80^[Zj0P1XJ6P3
07QhN080MgMg0P2WYjL306m_K`80QhN70`1HF5P209bLW080CTi>0`1XJ6P205UIF@80FUYJ0`2>SXh2
08Z:RP80RHV90`2EUID209RHV080JVYZ0`1[Jf/207UiN@80^KVi0`2`/;0202l_;`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`h0Ogmo0P2e]KD308F5Q@80R8R80P2_[jl306YZJP80Fe]K0P25QHD3
07inOP80NGUi0P2?Shl308F5Q@80emOG0`29RHT20:6QX@80`l?30`1gMgL207alO080MgMg0`2;Rh/2
09ZJVP80QXJ60`2DU9@205]KF`80FEUI0`1nOWh206e]K@80CTi>0`1gMgL209bLW080KVi^0`2JVYX2
06IVIP80W9bL0`21PH42075aL@80MGEe0`2:RXX20:FUY@80RHV90`1gMgL208:2PP80PH610`0g=cL2
092@T0<0Shn?0P2LW9`20:2PX0<0R8R80P1`L7020>3Ph0<0KFe]0P2PX:0204i>CP<0L71`0P1dM7@2
07moO`<0DU9B0P2?Shl209fMW@<0FUYJ0P1IFET20;Ng]`<0C4a<0P2?Shl209bLW0<0Zj^[0P1nOWh2
08N7Q`<0TY:B0P2j^[X206QXJ0<0N7Qh0P1gMgL20:NWY`<0Kfm_0P27QhL305QHF080W9bL0P1>CTh3
06QXJ080FEUI0P1JFUX308j>SP80RXZ:0P29RHT309FEU@80V9RH0P1ZJVX306][J`80NGUi0P2i^KT3
0;2`/080;bl_1@3oool1o`00000000Co00000?ooo`3oool0oooo3P1oOgl20;Fe]@<0QHF50P28R8P2
0:n_[`<0JVYZ0P1KFe/208F5Q@<0OWin0P1iNGT208n?S`<0QHF50P3GemL308V9R@80XJ6Q0P33`l<3
07MgM`80O7al0P1gMgL308^;R`80VYZJ0P26QXH309BDU080Fe]K0P1IFET307inOP80KFe]0P1>CTh3
07MgM`80W9bL0P1^KVh309ZJVP80IVIV0P2LW9`30861P@80LG5a0P1eMGD308Z:RP80YJFU0P29RHT3
07MgM`80PX:20P21PH4303Lg=`80T92@0`2?Shl209bLW080X:2P0`28R8P2071`L080h>3P0`1]KFd2
0:2PX080CTi>0`1`L70207AdM080Ogmo0`1BDU8208n?S`80WIfM0`1JFUX205UIF@80]kNg0`1<C4`2
08n?S`80W9bL0`2[Zj/207inOP80QhN70`2BTY820;Zj^P80J6QX0`1hN7P207MgM`80YjNW0`1_Kfl2
08N7Q`<0F5QH0P2LW9`204i>CP<0J6QX0P1IFET205YJFP<0SXj>0P2:RXX208V9R@<0UIFE0P2HV9P2
06YZJP<0Jf][0P1iNGT20;Vi^@<0/;2`0P0_;bl50?ooo`7o000000001?l00000oooo0?ooo`3oool<
07moO`80RHV90P2QXJ4309BDU080PH610P25QHD308b<S080Ph>30P29RHT309FEU@80Ph>30P1jNWX3
02/[:`80E5AD0`1oOgl207IfMP80DU9B0`2^[Zh203lo?`80Lg=c0`1QHF4203De=@80KFe]0`2;Rh/2
0?KfmP80][Jf0`1jNWX207=cL`80MWIf0`2^[Zh20;Zj^P80QHF50`2[Zj/209FEU@80EeMG0`2`/;02
06MWI`80Y:BT0`1jNWX205iNGP80Y:BT0`1fMWH20;Rh^080YJFU0`2:RXX20:^[Z`<0ZZZZ0P19BDT2
07IfMP<0_kno0P20P8020:NWY`<0RXZ:0P1_Kfl207MgM`<0WIfM0P1/K6`208:2PP<0MGEe0P1hN7P2
08:2PP<0?clo0P1_Kfl2071`L0<0W9bL0P0o?cl204Q8B0<0E5AD0P1`L702059BDP<0JVYZ0P22PX82
07QhN0<0O7al0P1dM7@204=3@`<0Ph>30P25QHD308V9R@80VYZJ0P2GUiL307inOP@0QXJ60`3@d=02
09FEU@80MGEe0`1HF5P206e]K@80I6AT0`21PH4208b<S080De=C0`2CTi<20>GUi@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo``0Ogmo0P29RHT20:6QX@<0U9BD0P21PH4208F5Q@<0S8b<0P23Ph<2
08V9R@<0UIFE0P23Ph<207YjNP<0:b/[0P1DE5@307moO`80MWIf0P1BDU830:j^[P80?clo0P1cLg<3
065QH@80=CDe0P1]KFd308^;R`80m_Kf0P2f][H307YjNP80Lg=c0P1fMWH30:j^[P80^[Zj0P25QHD3
0:^[Z`80UIFE0P1GEeL30;2`/080IfMW0P2TY:@307YjNP80GUiN0P2TY:@307IfMP80^;Rh0P2UYJD3
08Z:RP80Zj^[0`2ZZZX204U9B@80MWIf0`2o_kl20820P080YjNW0`2:RXX206m_K`80MgMg0`2MWId2
06a/K080PX:20`1eMGD207QhN080PX:20`0o?cl206m_K`80L71`0`2LW9`203lo?`80B4Q80`1DE5@2
071`L080DU9B0`1ZJVX208:2PP80N7Qh0`1lO7`207AdM080@d=30`23Ph<208F5Q@<0RHV90P2JVYX2
09NGU`<0OWin1026QXH30=3@d080UIFE0P1eMGD305QHF080KFe]0P1TI6@30861P@80S8b<0P1CDe<3
09>CT`80iNGU1@3oool1o`00000000Co00000?ooo`3oool0oooo1`1oOgl208V9R@<0QXJ60P2h^;P2
07moO`<0VYZJ0P1BDU82055AD@<0QHF50P2:RXX208j>SP<0HV9R0P1NGUh20492@P<0V9RH0P1hN7P3
06IVIP80R8R80P0h>3P301XJ6P80OGem0P17AdL30:NWY`80OGem0P21PH4308R8R080FUYJ0P1XJ6P3
08Z:RP80XJ6Q0P3IfMT307QhN080BTY:0P2UYJD302<S8`80>CTi0P1IFET307EeM@80b/[:0P2?Shl3
0::RXP80V9RH0P22PX830>;RhP80KFe]0P2ATI4309VIV@80NWYj0`3De=@2096AT@80F5QH0`2c/k<2
05EEE@80?Shn0`2/[:`209fMW@80Vi^K0`1WIfL209fMW@80K6a/0`2<S8`20:BTY080EeMG0`3?cll2
06MWI`80GEeM0`2UYJD208j>SP80QHF50`1ZJVX208^;R`80OGem0`2@T90208N7Q`80PH610`2DU9@2
08n?S`80FEUI0`1MGEd207IfMP<0SXj>0P0m?Cd206QXJ0<0RXZ:0P1UIFD2071`L0<09BDU0P21PH45
07moO`80IFEU0P2`/;0306ATI080SXj>0P2WYjL30;Bd]080MWIf1@3oool1o`00000000Co00000?oo
o`3oool0oooo1`1oOgl208V9R@<0QXJ60P2h^;P207moO`<0VYZJ0P1BDU82055AD@<0QHF50P2:RXX2
08j>SP<0HV9R0P1NGUh20492@P<0V9RH0P1hN7P306IVIP80R8R80P0h>3P301XJ6P80OGem0P17AdL3
0:NWY`80OGem0P21PH4308R8R080FUYJ0P1XJ6P308Z:RP80XJ6Q0P3IfMT307QhN080BTY:0P2UYJD3
02<S8`80>CTi0P1IFET307EeM@80b/[:0P2?Shl30::RXP80V9RH0P22PX830>;RhP80KFe]0P2ATI43
09VIV@80NWYj0`3De=@2096AT@80F5QH0`2c/k<205EEE@80?Shn0`2/[:`209fMW@80Vi^K0`1WIfL2
09fMW@80K6a/0`2<S8`20:BTY080EeMG0`3?cll206MWI`80GEeM0`2UYJD208j>SP80QHF50`1ZJVX2
08^;R`80OGem0`2@T90208N7Q`80PH610`2DU9@208n?S`80FEUI0`1MGEd207IfMP<0SXj>0P0m?Cd2
06QXJ0<0RXZ:0P1UIFD2071`L0<09BDU0P21PH4507moO`80IFEU0P2`/;0306ATI080SXj>0P2WYjL3
0;Bd]080MWIf1@3oool1o`00000000Co00000?ooo`3oool0oooo1`1oOgl208V9R@<0QXJ60P2h^;P2
07moO`<0VYZJ0P1BDU82055AD@<0QHF50P2:RXX208j>SP<0HV9R0P1NGUh20492@P<0V9RH0P1hN7P3
06IVIP80R8R80P0h>3P301XJ6P80OGem0P17AdL30:NWY`80OGem0P21PH4308R8R080FUYJ0P1XJ6P3
08Z:RP80XJ6Q0P3IfMT307QhN080BTY:0P2UYJD302<S8`80>CTi0P1IFET307EeM@80b/[:0P2?Shl3
0::RXP80V9RH0P22PX830>;RhP80KFe]0P2ATI4309VIV@80NWYj0`3De=@2096AT@80F5QH0`2c/k<2
05EEE@80?Shn0`2/[:`209fMW@80Vi^K0`1WIfL209fMW@80K6a/0`2<S8`20:BTY080EeMG0`3?cll2
06MWI`80GEeM0`2UYJD208j>SP80QHF50`1ZJVX208^;R`80OGem0`2@T90208N7Q`80PH610`2DU9@2
08n?S`80FEUI0`1MGEd207IfMP<0SXj>0P0m?Cd206QXJ0<0RXZ:0P1UIFD2071`L0<09BDU0P21PH45
07moO`80IFEU0P2`/;0306ATI080SXj>0P2WYjL30;Bd]080MWIf1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1lO7`507moO`80MGEe0`2CTi<20=7Ad@80MWIf0`0[:b/20:f][@80Jf][0`1XJ6P2
08R8R080KVi^0`1SHf<206m_K`80Xj>S0`1DE5@505iNGP80ADE50P27QhL306e]K@80QhN70P1oOgl3
05MGE`80YjNW0P1RHV83065QH@80FEUI0P1eMGD308n?S`80Z:RX0P35aLD307AdM080>CTi0P1DE5@3
06EUI@80DU9B0P1MGEd308N7Q`80Ogmo0P1HF5P308:2PP80Ti>C0P1UIFD3075aL@80^;Rh0P16ATH3
07QhN080HF5Q0`1ZJVX20:b/[080YZJV0`2e]KD208J6QP80?3`l0`1SHf<209VIV@80S8b<0`2:RXX2
08N7Q`80ZZZZ0`20P80206a/K080RXZ:0`1mOGd206i^KP80KFe]0`0m?Cd20:FUY@80TY:B0`31`L42
05EEE@80R8R80`2IVIT2096AT@80b/[:0`1ZJVX208>3P`80Vi^K0`1lO7`206m_K`<0Fe]K0P1^KVh2
06ATI0<0EEEE0P27QhL208:2PP<0LG5a0P10@40206IVIP<0FEUI0P27QhL2065QH@<0RXZ:0P1^KVh2
08^;R`<0RXZ:0P2?Shl50?ooo`7o000000001?l00000oooo0?ooo`3oool207alO0D0Ogmo0P1eMGD3
09>CT`80dM7A0P1fMWH302/[:`80[Jf]0P1[Jf/306QXJ080R8R80P1^KVh306=SH`80Kfm_0P2SXj<3
05ADE0D0GUiN0P15ADD208N7Q`<0KFe]0P27QhL207moO`<0EeMG0P2WYjL2069RHP<0HF5Q0P1IFET2
07EeM@<0Shn?0P2XZ:P20<G5a@<0M7Ad0P0i>CT205ADE0<0IFEU0P1BDU8205eMG@<0QhN70P1oOgl2
05QHF0<0PX:20P2CTi<206EUI@<0LG5a0P2h^;P204I6AP<0N7Qh0P1QHF4306YZJP80[:b/0P2VYZH3
0;Fe]@80QXJ60P0l?3`306=SH`80VIVI0P2<S8`308Z:RP80QhN70P2ZZZX30820P080K6a/0P2:RXX3
07emO@80KVi^0P1]KFd303dm?@80YJFU0P2BTY830<71`@80EEEE0P28R8P309VIV@80TI6A0P3:b/X3
06YZJP80Ph>30P2KVi/307alO080Kfm_0`1KFe/206i^KP80I6AT0`1EEED208N7Q`80PX:20`1aLG42
0410@080IVIV0`1IFET208N7Q`80HF5Q0`2:RXX206i^KP80Rh^;0`2:RXX208n?S`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80PX:21@1oOgl208V9R@<0QXJ60P1[Jf/207MgM`<0WYjN0P1XJ6P2
055AD@<0MGEe0P1;Bd/207QhN0<0PH610P1`L70207AdM0<0YZJV0P2PX:030:JVYP80X:2P0P1JFUX3
092@T080/K6a0P2BTY8309BDU080Shn?0P1cLg<306a/K080EeMG0P31`L430>OWi`80PX:20P0Z:RX3
05MGE`80P8200P19BDT307QhN080G5aL0P1mOGd305EEE@80H61P0P1]KFd309BDU080N7Qh0P37alL3
07EeM@80?Shn0P2JVYX3069RHP80ZZZZ0`1BDU8209RHV080R8R80`1PH60209VIV@80QhN70`2EUID2
07UiN@80VIVI0`1:BTX20:b/[080EeMG0`3<c<`205iNGP80Zj^[0`1WIfL209>CT`80Fe]K1@1oOgl2
06QXJ0<0IFEU0P2c/k<205eMG@<0EeMG0P1nOWh206YZJP<0clo?0P2GUiL208Z:RP<0SXj>0P25QHD3
07YjNP80KVi^0P2;Rh/308N7Q`80GEeM0P1aLG430;Jf]P80c/k>0P25QHD30;fm_@80W9bL0P1?Cdl3
07moO`80De=C0P1LG5`305=CD`80FUYJ1@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX85
07moO`80RHV90`26QXH206][J`80MgMg0`2NWYh206QXJ080DE5A0`1eMGD204];B`80N7Qh0`21PH42
071`L080M7Ad0`2VYZH20:2PX0<0YZJV0P2PX:0205YJFP<0T92@0P2a/K4209:BTP<0U9BD0P2?Shl2
07=cL`<0K6a/0P1GEeL20<71`@<0inOW0P22PX8202XZ:P<0EeMG0P20P80204U9B@<0N7Qh0P1LG5`2
07emO@<0EEEE0P1PH60206e]K@<0U9BD0P1hN7P20<O7a`<0MGEe0P0n?Sh209ZJVP<0HV9R0P2ZZZX3
059BDP80V9RH0P28R8P3061PH080VIVI0P27QhL309FEU@80NGUi0P2IVIT304Y:BP80[:b/0P1GEeL3
0<c<c080GUiN0P2[Zj/306MWI`80Ti>C0P1KFe/507moO`80J6QX0`1UIFD20;>c/`80GEeM0`1GEeL2
07inOP80JVYZ0`3?cll209NGU`80RXZ:0`2>SXh208F5Q@<0NWYj0P1^KVh208^;R`<0QhN70P1MGEd2
075aL@<0][Jf0P3>c/h208F5Q@<0_Kfm0P2LW9`204m?C`<0Ogmo0P1CDe<205aLG0<0De=C0P1JFUX5
0?ooo`7o000000001?l00000oooo0?ooo`3oool208:2PPD0Ogmo0P29RHT308J6QP80Jf][0P1gMgL3
09jNWP80J6QX0P1ADE4307EeM@80Bd];0P1hN7P30861P@80L71`0P1dM7@30:JVYP80X:2P0`2VYZH2
0:2PX080FUYJ0`2@T9020;6a/@80TY:B0`2DU9@208n?S`80Lg=c0`1/K6`205MGE`80`L710`3WinL2
08:2PP80:RXZ0`1GEeL20820P080BDU90`1hN7P205aLG080OGem0`1EEED2061PH080KFe]0`2DU9@2
07QhN080alO70`1eMGD203hn?P80VYZJ0`1RHV820:ZZZP<0DU9B0P2HV9P208R8R0<0H61P0P2IVIT2
08N7Q`<0UIFE0P1iNGT209VIV@<0BTY:0P2/[:`205MGE`<0c<c<0P1NGUh20:^[Z`<0IfMW0P2CTi<2
05]KF`D0Ogmo0P1XJ6P306EUI@80/k>c0P1MGEd305MGE`80OWin0P1ZJVX30<o?c`80UiNG0P2:RXX3
08j>SP80QHF50`1jNWX206i^KP80Rh^;0`27QhL205eMG@80LG5a0`2f][H20<k>cP80QHF50`2m_Kd2
09bLW080Cdm?0`1oOgl205=CD`80G5aL0`1CDe<205YJFPD0oooo0Ol000000004o`00003oool0oooo
0?ooo`80RHV90`1lO7`407moO`<0f][J0P2h^;P207emO@<0Fe]K0P1gMgL208^;R`<0OGem0P1oOgl2
04U9B@<0J6QX0P1hN7P2075aL@<0T92@0P22PX8309jNWP80R8R80P1aLG4307MgM`80O7al0P2?Shl3
04m?C`80MWIf0P2c/k<30:2PX080Z:RX0P1DE5@304i>CP80QHF50P1>CTh304Y:BP80ATI60P2JVYX3
05YJFP80PH610P1oOgl306a/K080Y:BT0P1JFUX304Q8B080YJFU0P13@d<306m_K`80U9BD0P2MWId3
0:f][@80c/k>0`1iNGT20;>c/`80VYZJ0`1KFe/20<K6aP80QHF50`2UYJD20;>c/`80RXZ:0`35aLD2
06MWI`80_[jn0`1LG5`20:n_[`80DU9B0`2<S8`207AdM080QXJ60`28R8P206MWI`80Ti>C0`18B4P2
06][J`80d];B0`1aLG4207QhN080HV9R0`16ATH208^;R`80IfMW0`2?Shl208>3P`<0RXZ:0P3;bl/2
08:2PP<0XJ6Q0P2ZZZX209^KV`<0Kfm_0P19BDT20820P0<0Bd];0P1SHf<20;Ng]`<0WIfM0P2n_[h2
08>3P`<0QXJ60P2NWYh50?ooo`7o000000001?l00000oooo0?ooo`3oool208V9R@<0O7al101oOgl3
0=[JfP80^;Rh0P1mOGd305]KF`80MgMg0P2;Rh/307emO@80Ogmo0P19BDT306QXJ080N7Qh0P1aLG43
092@T080PX:20`2NWYh208R8R080LG5a0`1gMgL207alO080Shn?0`1?Cdl207IfMP80/k>c0`2PX:02
0:RXZ080E5AD0`1>CTh208F5Q@80CTi>0`1:BTX204I6AP80VYZJ0`1JFUX20861P@80Ogmo0`1/K6`2
0:BTY080FUYJ0`18B4P20:FUY@80@d=30`1_Kfl209BDU080WIfM0`2][Jd20<k>cP<0NGUi0P2c/k<2
09ZJVP<0Fe]K0P36a/H208F5Q@<0YJFU0P2c/k<208Z:RP<0aLG50P1WIfL20;jn_P<0G5aL0P2_[jl2
059BDP<0S8b<0P1dM7@208J6QP<0R8R80P1WIfL209>CT`<0B4Q80P1[Jf/20=;BdP<0LG5a0P1hN7P2
069RHP<0ATI60P2;Rh/206MWI`<0Shn?0P23Ph<308Z:RP80bl_;0P22PX830:6QX@80ZZZZ0P2KVi/3
06m_K`80BDU90P20P80304];B`80Hf=S0P2g]kL309fMW@80_[jn0P23Ph<308J6QP80WYjN1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1eMGD308:2PP80RHV90P26QXH309>CT`80W9bL0P2>SXh3
0::RXP80`L710P3Jf]X308j>SP80Shn?0P2EUID306e]K@80UIFE0P1aLG4306=SH`80KVi^0`11@D42
04I6AP80S8b<0`1cLg<205UIF@80QhN70`2PX:02092@T080SXj>0`1]KFd208b<S080/K6a0`1gMgL2
05MGE`80H61P0`1DE5@206e]K@80Rh^;0`1JFUX408F5Q@<0W9bL0P1TI6@20:f][@<0YjNW0P1PH602
07emO@<0TY:B0P23Ph<20:^[Z`<0Kfm_0P2<S8`30<_;b`80?clo0P3Bd]830:6QX@80WYjN0P2a/K43
04M7A`80NGUi0P1VIVH309fMW@80I6AT0P26QXH30:6QX@80NWYj0P2:RXX30861P@80P8200P1EEED3
07QhN080>3Ph0P1nOWh3061PH080UiNG0P1eMGD307YjNP80IVIV0P2g]kL30820P080CTi>0P27QhL3
07YjNP80Hf=S0`1lO7`206m_K`80S8b<0`1_Kfl207=cL`80Cdm?0`1XJ6P208:2PP80IfMW0`1gMgL2
08R8R080EEEE0`1[Jf/207=cL`80QhN70`1aLG4205iNGPD0oooo0Ol000000004o`00003oool0oooo
0?ooo`80MGEe0`22PX8208V9R@80QXJ60`2CTi<209bLW080SXj>0`2RXZ820<71`@80f][J0`2>SXh2
08n?S`80UIFE0`1]KFd209FEU@80LG5a0`1SHf<206i^KP<0@D510P16ATH208b<S0<0Lg=c0P1IFET2
08N7Q`<0X:2P0P2@T90208j>SP<0KFe]0P2<S8`20;6a/@<0MgMg0P1GEeL2061PH0<0E5AD0P1]KFd2
08^;R`<0FUYJ1025QHD309bLW080I6AT0P2][Jd30:NWY`80H61P0P1mOGd309:BTP80Ph>30P2[Zj/3
06m_K`80S8b<0`3;bl/203lo?`80d];B0`2QXJ4209jNWP80/K6a0`17AdL207UiN@80IVIV0`2MWId2
06ATI080QXJ60`2QXJ4207YjNP80RXZ:0`21PH420820P080EEEE0`1hN7P203Ph>080OWin0`1PH602
09NGU`80MGEe0`1jNWX206IVIP80]kNg0`20P80204i>CP80QhN70`1jNWX206=SH`<0O7al0P1_Kfl2
08b<S0<0Kfm_0P1cLg<204m?C`<0J6QX0P22PX8206MWI`<0MgMg0P28R8P205EEE@<0Jf][0P1cLg<2
08N7Q`<0LG5a0P1NGUh50?ooo`7o000000001?l00000oooo0?ooo`3oool207EeM@<0PX:20P29RHT2
08J6QP<0Ti>C0P2LW9`208j>SP<0XZ:R0P31`L420=[JfP<0SXj>0P2?Shl209FEU@<0KFe]0P2EUID2
075aL@<0Hf=S0P1^KVh30451@@80ATI60P2<S8`307=cL`80FEUI0P27QhL30:2PX080T92@0P2>SXh3
06e]K@80S8b<0P2a/K4307MgM`80EeMG0P1PH60305ADE080KFe]0P2;Rh/305YJFP@0QHF50`2LW9`2
06ATI080[Jf]0`2WYjL2061PH080OGem0`2BTY8208>3P`80Zj^[0`1_Kfl208b<S0<0bl_;0P0o?cl2
0=;BdP<0XJ6Q0P2NWYh20;6a/@<0AdM70P1iNGT206IVIP<0WIfM0P1TI6@208J6QP<0XJ6Q0P1jNWX2
08Z:RP<0PH610P20P80205EEE@<0N7Qh0P0h>3P207inOP<0H61P0P2GUiL207EeM@<0NWYj0P1VIVH2
0;Ng]`<0P8200P1>CTh208N7Q`<0NWYj0P1SHf<307alO080Kfm_0P2<S8`306m_K`80Lg=c0P1?Cdl3
06QXJ080PX:20P1WIfL307MgM`80R8R80P1EEED306][J`80Lg=c0P27QhL3075aL@80GUiN1@3oool1
o`00000000Co00000?ooo`3oool0oooo1`1oOgl208V9R@<0Ti>C0P2;Rh/208b<S0<0XJ6Q0P0o?cl2
04U9B@<0S8b<0P1QHF4204Y:BP<0[jn_0P1_Kfl209bLW0<0J6QX0P2:RXX308j>SP80NGUi0P1WIfL3
06a/K080Cdm?0P15ADD307AdM080FEUI0P1[Jf/308F5Q@80W9bL0P23Ph<306YZJP80IVIV0P1lO7`3
04Y:BP80W9bL0P19BDT30:BTY080T92@0P1dM7@306a/K080GEeM0P2CTi<30<30`080P8200P2BTY83
0:b/[080M7Ad0P1ADE430;Vi^@80M7Ad0`2PX:0207inOP80ATI60`2XZ:P20861P@80Ti>C0`2LW9`2
07emO@80N7Qh0`2f][H20861P@80WIfM0`2>SXh208>3P`80VIVI0`1QHF42092@T080O7al0`1MGEd2
08>3P`80Bd];0`1/K6`204Q8B080IVIV0`2PX:0208Z:RP80NGUi0`2QXJ4208n?S`80Ph>30`1]KFd2
0::RXP<0GEeM0P1cLg<204U9B@<0Jf][0P22PX8207QhN0<0LG5a0P1VIVH2092@T0<0Vi^K0P1lO7`2
09jNWP<0L71`0P1HF5P203lo?`<0L71`0P2<S8`50?ooo`7o000000001?l00000oooo0?ooo`3oool7
07moO`80RHV90`2CTi<208^;R`80S8b<0`2QXJ4203lo?`80BDU90`2<S8`2065QH@80BTY:0`2_[jl2
06m_K`80W9bL0`1XJ6P208Z:RP<0SXj>0P1iNGT206MWI`<0K6a/0P1?Cdl204E5A@<0M7Ad0P1IFET2
06][J`<0QHF50P2LW9`208>3P`<0JVYZ0P1VIVH207alO0<0BTY:0P2LW9`204U9B@<0Y:BT0P2@T902
07AdM0<0K6a/0P1MGEd209>CT`<0`<300P20P80209:BTP<0[:b/0P1dM7@2055AD@<0^KVi0P1dM7@3
0:2PX080OWin0P16ATH30:RXZ080PH610P2CTi<309bLW080OGem0P1hN7P30;Jf]P80PH610P2MWId3
08j>SP80Ph>30P2IVIT3065QH@80T92@0P1lO7`305eMG@80Ph>30P1;Bd/306a/K080B4Q80P1VIVH3
0:2PX080RXZ:0P1iNGT30:6QX@80Shn?0P23Ph<306e]K@80XZ:R0`1MGEd207=cL`80BDU90`1[Jf/2
08:2PP80N7Qh0`1aLG4206IVIP80T92@0`2KVi/207alO080WYjN0`1`L70205QHF080?clo0`1`L702
08b<S0D0oooo0Ol000000004o`00003oool0oooo0?ooo`D0Ogmo0P29RHT209fMW@<0`L710P1DE5@2
05UIF@<0AdM70P1eMGD207emO@<0CTi>0P1iNGT20=7Ad@<0PH610P2RXZ8208^;R`<0`l?30P2ATI43
071`L080Y:BT0P1/K6`309bLW080Kfm_0P28R8P308N7Q`80Zj^[0P1cLg<308F5Q@80Lg=c0P1TI6@3
06MWI`80WYjN0P1lO7`309VIV@80K6a/0P22PX83075aL@80K6a/0P1_Kfl30410@080S8b<0P1[Jf/3
0:RXZ080kNg]0P1@D50307inOP80b/[:0P2SXj<30:NWY`80MGEe0`2GUiL209^KV`80QhN70`0J6QX2
0::RXP80h>3P0`1_Kfl206QXJ080X:2P0`2f][H20;jn_P80MgMg0`2<S8`209NGU`80KVi^0`21PH42
07alO080QhN70`1cLg<205=CD`80PH610`2HV9P208:2PP80ATI60`1UIFD205iNGP80EEEE0`25QHD2
07IfMP80SXj>0`2GUiL208N7Q`<0Ph>30P1TI6@20820P0D0DU9B0P2a/K4306MWI`80K6a/0P1XJ6P3
06][J`80I6AT0P1SHf<307QhN080Ti>C0P2ZZZX305QHF080QhN71@3oool1o`00000000Co00000?oo
o`3oool0oooo1@1oOgl208V9R@80WIfM0`31`L4205ADE080FEUI0`17AdL207EeM@80OGem0`1>CTh2
07UiN@80dM7A0`21PH420::RXP80Rh^;0`33`l<2096AT@<0L71`0P2TY:@206a/K0<0W9bL0P1_Kfl2
08R8R0<0QhN70P2[Zj/207=cL`<0QHF50P1cLg<206ATI0<0IfMW0P2NWYh207alO0<0VIVI0P1/K6`2
08:2PP<0LG5a0P1/K6`206m_K`<0@4100P2<S8`206][J`<0Z:RX0P3]kNd2051@D0<0OWin0P3:b/X2
0:>SX`<0YjNW0P1eMGD309NGU`80Vi^K0P27QhL301XJ6P80XZ:R0P3Ph>0306m_K`80J6QX0P2PX:03
0;Jf]P80_[jn0P1gMgL308b<S080UiNG0P1^KVh30861P@80O7al0P27QhL307=cL`80De=C0P21PH43
09RHV080PX:20P16ATH306EUI@80GUiN0P1EEED308F5Q@80MWIf0P2>SXh309NGU`80QhN70`23Ph<2
06ATI080P8201@1BDU820;6a/@<0IfMW0P1/K6`206QXJ0<0Jf][0P1TI6@206=SH`<0N7Qh0P2CTi<2
0:ZZZP<0F5QH0P27QhL50?ooo`7o000000001?l00000oooo0?ooo`3oool507moO`80RHV90P2MWId3
0<71`@80E5AD0P1IFET304M7A`80MGEe0P1mOGd304i>CP80NGUi0P3AdM430861P@80XZ:R0P2;Rh/3
0<?3``80TI6A0`1`L7020:BTY080K6a/0`2LW9`206m_K`80R8R80`27QhL20:^[Z`80Lg=c0`25QHD2
07=cL`80I6AT0`1WIfL209jNWP80O7al0`2IVIT206a/K080PX:20`1aLG4206a/K080Kfm_0`10@402
08b<S080Jf][0`2XZ:P20>g]k@80D51@0`1nOWh20<[:bP80Xj>S0`2WYjL207EeM@<0UiNG0P2KVi/2
08N7Q`<06QXJ0P2RXZ820>3Ph0<0Kfm_0P1XJ6P20:2PX0<0][Jf0P2n_[h207MgM`<0S8b<0P2GUiL2
06i^KP<0PH610P1lO7`208N7Q`<0Lg=c0P1CDe<20861P@<0V9RH0P22PX8204I6AP<0IFEU0P1NGUh2
05EEE@<0QHF50P1fMWH208j>SP<0UiNG0P27QhL308>3P`80I6AT0P20P805059BDP80/K6a0`1WIfL2
06a/K080J6QX0`1[Jf/206ATI080Hf=S0`1hN7P209>CT`80ZZZZ0`1HF5P208N7Q`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80Ogmo0`29RHT207alO080VYZJ0`1UIFD205aLG080LG5a0`1jNWX2
05iNGP80Cdm?1@2WYjL2055AD@<0Ogmo0P2GUiL2092@T0<0@D510P1NGUh307alO080@T920P2][Jd3
06=SH`80WIfM0P21PH43075aL@80IfMW0P2ZZZX305UIF@80B4Q81@1XJ6P20451@@80TI6A0`2VYZH2
06a/K080NWYj0`28R8P206m_K`80RXZ:0`33`l<207alO080KVi^0`1@D50209ZJVP80^;Rh0`2e]KD2
04m?C`80Kfm_0`2m_Kd209bLW0<0K6a/0P1cLg<205]KF`<0`/;20P0`<30209>CT`<0T92@0P23Ph<2
0:j^[P<0De=C0P25QHD20<k>cP<0Lg=c0P1LG5`206i^KP<0^[Zj0P22PX8206MWI`<0MgMg0P1cLg<2
08F5Q@<0QXJ60P2>SXh206a/K0<0RXZ:0P1mOGd2075aL@<0NGUi0P1aLG4204m?C`<0MWIf0P1SHf<3
0:JVYP80IFEU0P2j^[X307inOP80RXZ:0P0m?Cd30;6a/@80S8b<0P1gMgL307QhN080JVYZ0P20P803
08n?S`80M7Ad0P2?Shl30=GEe@80FUYJ1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1oOgl3
08V9R@80O7al0P2JVYX306EUI@80G5aL0P1aLG4307YjNP80GUiN0P1?Cdl50:NWY`80DE5A0`1oOgl2
09NGU`80T92@0`11@D4205iNGP<0O7al0P12@T820:f][@<0Hf=S0P2MWId20861P@<0LG5a0P1WIfL2
0:ZZZP<0FEUI0P18B4P506QXJ080@D510P2ATI430:JVYP80K6a/0P1jNWX308R8R080Kfm_0P2:RXX3
0<?3``80O7al0P1^KVh3051@D080VYZJ0P2h^;P30;Fe]@80Cdm?0P1_Kfl30;fm_@80W9bL0`1/K6`2
07=cL`80Fe]K0`32`/82030`<080Ti>C0`2@T90208>3P`80[Zj^0`1CDe<208F5Q@80c/k>0`1cLg<2
05aLG080KVi^0`2j^[X208:2PP80IfMW0`1gMgL207=cL`80QHF50`26QXH208j>SP80K6a/0`2:RXX2
07emO@80LG5a0`1iNGT2075aL@80Cdm?0`1fMWH206=SH`<0YZJV0P1UIFD20;Zj^P<0OWin0P2:RXX2
03dm?@<0/K6a0P2<S8`207MgM`<0N7Qh0P1ZJVX20820P0<0Shn?0P1dM7@208n?S`<0eMGE0P1JFUX5
0?ooo`7o000000001?l00000oooo0?ooo`3oool507moO`80RHV90P1@D5030410@080YZJV0P2;Rh/3
04Y:BP80Rh^;0P2KVi/305QHF080FUYJ1@1nOWh205UIF@80?clo0`1LG5`206i^KP<0EEEE0P2ATI42
07QhN0<0G5aL0P2BTY8208Z:RP<0FEUI0P1/K6`206][J`<0Ti>C0P26QXH204I6AP<0MWIf0P1LG5`2
06a/K0<0TI6A0P23Ph<206a/K0<0OWin0P2j^[X208N7Q`D0E5AD0P2XZ:P303hn?P80VIVI0P3oool3
0<k>cP80NWYj0P1<C4`306YZJP80>CTi0`1<C4`208F5Q@80IfMW0`1eMGD206ATI080OGem0`1fMWH2
0:n_[`80/;2`0`1dM7@209fMW@80L71`0`2ATI420::RXP80Ti>C0`1dM7@205=CD`80Lg=c0`21PH42
0;Zj^P80K6a/0`29RHT206MWI`80KVi^0`1HF5P209:BTP80H61P0`1JFUX208n?S`80KVi^0`1]KFd2
05iNGP<0IfMW0P2;Rh/2065QH@<0RHV90P1oOgl206i^KP<0EEEE0P1`L70207moO`<0O7al0P1`L702
06e]K@<0QhN70P1hN7P20861P@<0HF5Q0P2h^;P50?ooo`7o000000001?l00000oooo0?ooo`3oool5
07moO`80RHV90P1@D5030410@080YZJV0P2;Rh/304Y:BP80Rh^;0P2KVi/305QHF080FUYJ1@1nOWh2
05UIF@80?clo0`1LG5`206i^KP<0EEEE0P2ATI4207QhN0<0G5aL0P2BTY8208Z:RP<0FEUI0P1/K6`2
06][J`<0Ti>C0P26QXH204I6AP<0MWIf0P1LG5`206a/K0<0TI6A0P23Ph<206a/K0<0OWin0P2j^[X2
08N7Q`D0E5AD0P2XZ:P303hn?P80VIVI0P3oool30<k>cP80NWYj0P1<C4`306YZJP80>CTi0`1<C4`2
08F5Q@80IfMW0`1eMGD206ATI080OGem0`1fMWH20:n_[`80/;2`0`1dM7@209fMW@80L71`0`2ATI42
0::RXP80Ti>C0`1dM7@205=CD`80Lg=c0`21PH420;Zj^P80K6a/0`29RHT206MWI`80KVi^0`1HF5P2
09:BTP80H61P0`1JFUX208n?S`80KVi^0`1]KFd205iNGP<0IfMW0P2;Rh/2065QH@<0RHV90P1oOgl2
06i^KP<0EEEE0P1`L70207moO`<0O7al0P1`L70206e]K@<0QhN70P1hN7P20861P@<0HF5Q0P2h^;P5
0?ooo`7o000000001?l00000oooo0?ooo`3oool507moO`80RHV90P1@D5030410@080YZJV0P2;Rh/3
04Y:BP80Rh^;0P2KVi/305QHF080FUYJ1@1nOWh205UIF@80?clo0`1LG5`206i^KP<0EEEE0P2ATI42
07QhN0<0G5aL0P2BTY8208Z:RP<0FEUI0P1/K6`206][J`<0Ti>C0P26QXH204I6AP<0MWIf0P1LG5`2
06a/K0<0TI6A0P23Ph<206a/K0<0OWin0P2j^[X208N7Q`D0E5AD0P2XZ:P303hn?P80VIVI0P3oool3
0<k>cP80NWYj0P1<C4`306YZJP80>CTi0`1<C4`208F5Q@80IfMW0`1eMGD206ATI080OGem0`1fMWH2
0:n_[`80/;2`0`1dM7@209fMW@80L71`0`2ATI420::RXP80Ti>C0`1dM7@205=CD`80Lg=c0`21PH42
0;Zj^P80K6a/0`29RHT206MWI`80KVi^0`1HF5P209:BTP80H61P0`1JFUX208n?S`80KVi^0`1]KFd2
05iNGP<0IfMW0P2;Rh/2065QH@<0RHV90P1oOgl206i^KP<0EEEE0P1`L70207moO`<0O7al0P1`L702
06e]K@<0QhN70P1hN7P20861P@<0HF5Q0P2h^;P50?ooo`7o000000001?l00000oooo0?ooo`3oool2
08V9R@<0LG5a0P1^KVh207alO0<0?3`l0P1WIfL208R8R0<0W9bL0P1iNGT205aLG0<0Kfm_0P2][Jd2
07emO@<0MGEe0P21PH4207QhN0<0VIVI0P2;Rh/30=3@d080NGUi0P1VIVH30:2PX080DE5A0P1EEED3
07UiN@80Fe]K0P1/K6`308j>SP80OWin0P1oOgl308J6QP80K6a/0P21PH4307=cL`80NGUi0P2a/K43
06m_K`80ATI60P2VYZH307QhN080UiNG0P11@D430;>c/`80@D510P29RHT509VIV@80Hf=S0`1PH602
04E5A@<09bLW0P2QXJ4206QXJ0<0NGUi0P2:RXX204i>CP<0VIVI0P1<C4`209bLW0<0i^KV0P2XZ:P2
07IfMPD0U9BD0P1TI6@306IVIP80T92@0P23Ph<30:RXZ080L71`0P2GUiL304Q8B080M7Ad0P2][Jd3
096AT@80GEeM0P1mOGd308J6QP80FEUI0P2EUID306][J`80QHF50`0o?cl207=cL`80F5QH0`2@T902
05=CD`80YJFU0`1LG5`207MgM`80QHF50`1MGEd208Z:RP80Ogmo0`0Q8B4207UiN@80IVIV0`1`L702
04m?C`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80RHV90`1aLG4206i^KP80O7al0`0l?3`2
06MWI`80R8R80`2LW9`207UiN@80G5aL0`1_Kfl20:f][@80OGem0`1eMGD20861P@80N7Qh0`2IVIT2
08^;R`<0d=3@0P1iNGT206IVIP<0X:2P0P1ADE4205EEE@<0NGUi0P1KFe/206a/K0<0SXj>0P1nOWh2
07moO`<0QXJ60P1/K6`20861P@<0Lg=c0P1iNGT20;6a/@<0Kfm_0P16ATH20:JVYP<0N7Qh0P2GUiL2
0451@@<0/k>c0P11@D4208V9R@D0VIVI0P1SHf<3061PH080ADE50`0W9bL20:6QX@80J6QX0`1iNGT2
08Z:RP80CTi>0`2IVIT204a<C080W9bL0`3Vi^H20:RXZ080MWIf1@2DU9@206ATI0<0IVIV0P2@T902
08>3P`<0Z:RX0P1`L70209NGU`<0B4Q80P1dM7@20:f][@<0TI6A0P1MGEd207emO@<0QXJ60P1IFET2
09FEU@<0Jf][0P25QHD303lo?`80Lg=c0P1HF5P3092@T080De=C0P2UYJD305aLG080MgMg0P25QHD3
05eMG@80RXZ:0P1oOgl3024Q8@80NGUi0P1VIVH3071`L080Cdm?1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1aLG4309NGU`@0N7Qh0`1PH602055AD@80R8R80`1hN7P2075aL@80OWin0`1ZJVX2
03Ti>@80JVYZ0`1?Cdl205iNGP80WYjN0`21PH4208N7Q`<0N7Qh0P1_Kfl207MgM`<0GUiN0P25QHD2
08^;R`<0C4a<0P1;Bd/206YZJP<0E5AD0P1SHf<209bLW0<0H61P0P1]KFd207AdM0<0I6AT0P1_Kfl2
09FEU@<0JVYZ0P1]KFd204Y:BP<0Zj^[0P2SXj<208n?S`<0I6AT0P25QHD200H61P<0@T920P2WYjL2
06m_K`<0@4100P2SXj<30:ZZZP80Kfm_0P2MWId306MWI`80NGUi0P1eMGD307UiN@80Zj^[0P16ATH3
06a/K080YJFU0P1XJ6P308N7Q`@0PH610`1;Bd/20:^[Z`80RXZ:0`1aLG4209bLW080IFEU0`25QHD2
0:BTY080WYjN0`1ZJVX2071`L080QHF50`1GEeL209NGU`80PX:20`1KFe/208Z:RP<0XJ6Q0P1dM7@2
07QhN0<0IVIV0P28R8P205eMG@<0Ph>30P1gMgL209>CT`<0Z:RX0P1_Kfl207moO`<0_kno0P2][Jd2
0::RXP<0NGUi0P2;Rh/50?ooo`7o000000001?l00000oooo0?ooo`3oool2075aL@<0UiNG101hN7P3
061PH080DE5A0P28R8P307QhN080LG5a0P1nOWh306YZJP80>CTi0P1ZJVX304m?C`80GUiN0P2NWYh3
0861P@80QhN70`1hN7P206m_K`80MgMg0`1NGUh208F5Q@80Rh^;0`1<C4`204];B`80JVYZ0`1DE5@2
06=SH`80W9bL0`1PH60206e]K@80M7Ad0`1TI6@206m_K`80UIFE0`1ZJVX206e]K@80BTY:0`2[Zj/2
0:>SX`80Shn?0`1TI6@208F5Q@801PH60`12@T820:NWY`80Kfm_0`10@4020:>SX`<0ZZZZ0P1_Kfl2
09fMW@<0IfMW0P1iNGT207EeM@<0NGUi0P2[Zj/204I6AP<0K6a/0P2UYJD206QXJ0<0QhN71021PH43
04];B`80Zj^[0P2:RXX3075aL@80W9bL0P1UIFD308F5Q@80Y:BT0P2NWYh306YZJP80L71`0P25QHD3
05MGE`80UiNG0P22PX8305]KF`80RXZ:0`2QXJ4207AdM080N7Qh0`1VIVH208R8R080GEeM0`23Ph<2
07MgM`80Ti>C0`2XZ:P206m_K`80Ogmo0`2o_kl20:f][@80XZ:R0`1iNGT208^;R`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80LG5a0`2GUiL407QhN0<0H61P0P1ADE4208R8R0<0N7Qh0P1aLG42
07inOP<0JVYZ0P0i>CT206YZJP<0Cdm?0P1NGUh209jNWP<0PH610P27QhL307QhN080Kfm_0P1gMgL3
05iNGP80QHF50P2;Rh/304a<C080Bd];0P1ZJVX305ADE080Hf=S0P2LW9`3061PH080KFe]0P1dM7@3
06ATI080Kfm_0P2EUID306YZJP80KFe]0P1:BTX30:^[Z`80Xj>S0P2?Shl306ATI080QHF50P061PH3
0492@P80YjNW0P1_Kfl30410@080Xj>S0`2ZZZX206m_K`80WIfM0`1WIfL207UiN@80MGEe0`1iNGT2
0:^[Z`80ATI60`1/K6`20:FUY@80J6QX0`27QhL40861P@<0Bd];0P2[Zj/208Z:RP<0LG5a0P2LW9`2
06EUI@<0QHF50P2TY:@209jNWP<0JVYZ0P1`L70208F5Q@<0EeMG0P2GUiL208:2PP<0Fe]K0P2:RXX3
0:6QX@80M7Ad0P1hN7P306IVIP80R8R80P1MGEd308>3P`80MgMg0P2CTi<30:RXZ080Kfm_0P1oOgl3
0;no_`80[Jf]0P2RXZ8307UiN@80Rh^;1@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX85
07moO`80Jf][0`1JFUX201hN7P80HF5Q0`2EUID207alO080Lg=c0`1RHV8205QHF080EeMG0`2BTY82
06i^KP80OWin0`1jNWX20861P@<0?3`l0P1`L7020861P@<0MGEe0P2ATI4207YjNP<0Ogmo0P2a/K42
07moO`<0NGUi0P1JFUX207inOP<0@4100P2SXj<203Xj>P<0Kfm_0P1dM7@204=3@`<0X:2P0P29RHT2
05aLG0<0De=C0P1>CTh209FEU@<0?clo0P2UYJD202`/;0<0DU9B0P1GEeL208N7Q`<0alO70P2RXZ83
09jNWP808B4Q0P2SXj<3075aL@80VYZJ0P1IFET30<K6aP80Ogmo0P0o?cl305aLG080Fe]K0P2RXZ83
055AD@80QXJ60P1`L70309FEU@80Lg=c0P25QHD309:BTP80Jf][0P1mOGd30;2`/0@0MWIf0`28R8P2
06EUI@80NGUi0`23Ph<205MGE`80FUYJ0`2h^;P205MGE`<0KFe]0P1gMgL209FEU@<0Lg=c0P21PH42
09ZJVP<0K6a/0P1lO7`205UIF@<0UiNG0P2<S8`207UiN@<0T92@0P1cLg<206e]K@<0N7Qh0P23Ph<5
0?ooo`7o000000001?l00000oooo0?ooo`3oool208:2PPD0Ogmo0P1[Jf/305YJFP807QhN0P1QHF43
09FEU@80O7al0P1cLg<3069RHP80F5QH0P1GEeL309:BTP80KVi^0P1nOWh307YjNP80PH610`0l?3`2
071`L080PH610`1eMGD2096AT@80NWYj0`1oOgl20;6a/@80Ogmo0`1iNGT205YJFP80OWin0`10@402
0:>SX`80>SXj0`1_Kfl207AdM080@d=30`2PX:0208V9R@80G5aL0`1CDe<204i>CP80UIFE0`0o?cl2
0:FUY@80;2`/0`1BDU8205MGE`80QhN70`37alL20::RXP<0WYjN0P0Q8B420:>SX`<0LG5a0P2JVYX2
05UIF@<0a/K60P1oOgl203lo?`<0G5aL0P1KFe/20::RXP<0DE5A0P26QXH2071`L0<0UIFE0P1cLg<2
08F5Q@<0TY:B0P1[Jf/207emO@<0/;2`101fMWH308R8R080IFEU0P1iNGT308>3P`80EeMG0P1JFUX3
0;Rh^080EeMG0`1]KFd207MgM`80UIFE0`1cLg<20861P@80VYZJ0`1/K6`207alO080FEUI0`2GUiL2
08b<S080NGUi0`2@T90207=cL`80KFe]0`1hN7P208>3P`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80O7al0`1eMGD207QhN080PX:20`1oOgl206i^KP80FEUI0`2DU9@20;Vi^@80UiNG0`2`/;02
0:JVYP80UiNG0`1jNWX209>CT`80DU9B0`2;Rh/207EeM@<0Jf][0P2>SXh206EUI@<0U9BD0P1]KFd2
07=cL`<0W9bL0P1`L70206=SH`<0PX:20P1dM7@205iNGP<0QHF50P1jNWX208^;R`<0I6AT0P1mOGd2
092@T0<0PH610P1mOGd207moO`<0UiNG0P1BDU8204Q8B0<0bl_;0P0d=3@20;Bd]0<0Hf=S0P25QHD2
04a<C0<0HF5Q0P1IFET30:FUY@80Jf][0P13@d<30820P080Jf][0P1gMgL306=SH`80/k>c0P3Jf]X3
02XZ:P80VYZJ0P1aLG43092@T080<30`0P20P80309BDU080Rh^;0P20P80305iNGP80O7al0P2:RXX3
05iNGP80De=C0P10@40306i^KP80QhN70P1`L70307inOP80IVIV0P28R8P306MWI`80TI6A0`26QXH2
09NGU`80Fe]K0`1nOWh2075aL@80Cdm?0`2/[:`207IfMP80I6AT0`15ADD208^;R`80N7Qh0`1JFUX2
06i^KP80MGEe0`2QXJ4207IfMPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80O7al0`1eMGD2
07QhN080PX:20`1oOgl206i^KP80FEUI0`2DU9@20;Vi^@80UiNG0`2`/;020:JVYP80UiNG0`1jNWX2
09>CT`80DU9B0`2;Rh/207EeM@<0Jf][0P2>SXh206EUI@<0U9BD0P1]KFd207=cL`<0W9bL0P1`L702
06=SH`<0PX:20P1dM7@205iNGP<0QHF50P1jNWX208^;R`<0I6AT0P1mOGd2092@T0<0PH610P1mOGd2
07moO`<0UiNG0P1BDU8204Q8B0<0bl_;0P0d=3@20;Bd]0<0Hf=S0P25QHD204a<C0<0HF5Q0P1IFET3
0:FUY@80Jf][0P13@d<30820P080Jf][0P1gMgL306=SH`80/k>c0P3Jf]X302XZ:P80VYZJ0P1aLG43
092@T080<30`0P20P80309BDU080Rh^;0P20P80305iNGP80O7al0P2:RXX305iNGP80De=C0P10@403
06i^KP80QhN70P1`L70307inOP80IVIV0P28R8P306MWI`80TI6A0`26QXH209NGU`80Fe]K0`1nOWh2
075aL@80Cdm?0`2/[:`207IfMP80I6AT0`15ADD208^;R`80N7Qh0`1JFUX206i^KP80MGEe0`2QXJ42
07IfMPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80O7al0`1eMGD207QhN080PX:20`1oOgl2
06i^KP80FEUI0`2DU9@20;Vi^@80UiNG0`2`/;020:JVYP80UiNG0`1jNWX209>CT`80DU9B0`2;Rh/2
07EeM@<0Jf][0P2>SXh206EUI@<0U9BD0P1]KFd207=cL`<0W9bL0P1`L70206=SH`<0PX:20P1dM7@2
05iNGP<0QHF50P1jNWX208^;R`<0I6AT0P1mOGd2092@T0<0PH610P1mOGd207moO`<0UiNG0P1BDU82
04Q8B0<0bl_;0P0d=3@20;Bd]0<0Hf=S0P25QHD204a<C0<0HF5Q0P1IFET30:FUY@80Jf][0P13@d<3
0820P080Jf][0P1gMgL306=SH`80/k>c0P3Jf]X302XZ:P80VYZJ0P1aLG43092@T080<30`0P20P803
09BDU080Rh^;0P20P80305iNGP80O7al0P2:RXX305iNGP80De=C0P10@40306i^KP80QhN70P1`L703
07inOP80IVIV0P28R8P306MWI`80TI6A0`26QXH209NGU`80Fe]K0`1nOWh2075aL@80Cdm?0`2/[:`2
07IfMP80I6AT0`15ADD208^;R`80N7Qh0`1JFUX206i^KP80MGEe0`2QXJ4207IfMPD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80S8b<0`1lO7`208V9R@80O7al0`1oOgl207EeM@80ATI60`1lO7`2
08>3P`80Z:RX0`2JVYX208V9R@80ZZZZ0`26QXH205UIF@80RHV90`1WIfL207UiN@<0XZ:R0P1MGEd2
06m_K`<0CTi>0P1ZJVX208b<S0<0Ogmo0P1CDe<206EUI@<0KVi^0P29RHT206i^KP<0Rh^;0P2DU9@2
08F5Q@<0VIVI0P1eMGD208V9R@<0VYZJ0P2<S8`20:>SX`<0MgMg0P2i^KT208:2PP<0G5aL0P28R8P2
0;Fe]@<0NWYj102BTY8304=3@`80PX:20`1/K6`205iNGP80=CDe0`25QHD207UiN@80[:b/0`0^;Rh2
07inOP80BTY:0`3MgMd202d];@80Rh^;0`15ADD20:NWY`80T92@0`1PH6020<?3``80[Zj^0`1KFe/2
0:RXZ080P8200`1SHf<407UiN@<0LG5a0P2;Rh/209BDU0<0Shn?0P2IVIT207AdM0<0a/K60P1MGEd3
09>CT`80NGUi0P29RHT508J6QP80O7al0`1CDe<208j>SP80Ogmo0`1^KVh205aLG080UiNG0`1lO7`2
06i^KP80G5aL0`1JFUX208V9R@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80S8b<0`1lO7`2
08V9R@80O7al0`1oOgl207EeM@80ATI60`1lO7`208>3P`80Z:RX0`2JVYX208V9R@80ZZZZ0`26QXH2
05UIF@80RHV90`1WIfL207UiN@<0XZ:R0P1MGEd206m_K`<0CTi>0P1ZJVX208b<S0<0Ogmo0P1CDe<2
06EUI@<0KVi^0P29RHT206i^KP<0Rh^;0P2DU9@208F5Q@<0VIVI0P1eMGD208V9R@<0VYZJ0P2<S8`2
0:>SX`<0MgMg0P2i^KT208:2PP<0G5aL0P28R8P20;Fe]@<0NWYj102BTY8304=3@`80PX:20`1/K6`2
05iNGP80=CDe0`25QHD207UiN@80[:b/0`0^;Rh207inOP80BTY:0`3MgMd202d];@80Rh^;0`15ADD2
0:NWY`80T92@0`1PH6020<?3``80[Zj^0`1KFe/20:RXZ080P8200`1SHf<407UiN@<0LG5a0P2;Rh/2
09BDU0<0Shn?0P2IVIT207AdM0<0a/K60P1MGEd309>CT`80NGUi0P29RHT508J6QP80O7al0`1CDe<2
08j>SP80Ogmo0`1^KVh205aLG080UiNG0`1lO7`206i^KP80G5aL0`1JFUX208V9R@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80PX:20`1lO7`207EeM@80PX:20`1eMGD208:2PP80I6AT0`18B4P2
07UiN@80Rh^;0`2`/;0209>CT`80;bl_0`1LG5`20861P@80OWin0`1gMgL2075aL@<0Cdm?0P1_Kfl2
0820P0<0S8b<0P22PX8205ADE0<0Jf][0P2DU9@206][J`<0G5aL0P1JFUX208:2PP<0Vi^K0P18B4P2
08n?S`<0QXJ60P27QhL2075aL@<0?3`l0P2o_kl208b<S0<0QhN70P2KVi/20:2PX0<0KFe]0P0/;2`2
06EUI@<0Fe]K0P2f][H205iNGP<0Ogmo0P1]KFd307QhN080AdM70P2GUiL30861P@80QHF50P1UIFD3
07=cL`@0GEeM0`2g]kL202@T9080IVIV0`1eMGD207YjNP80XZ:R0`2GUiL207AdM080ATI60`1jNWX2
069RHP80UIFE0`2QXJ4207UiN@80SXj>0`1iNGT208V9R@80O7al0`1GEeL206ATI080S8b<0`0^;Rh2
09>CT`<0PH610P1TI6@208n?S`<0Lg=c0P1WIfL208R8R0<0QXJ60P1RHV8209VIV@<0RXZ:0P1iNGT2
05eMG@<0F5QH0P1@D50209jNWP<0O7al0P1MGEd50?ooo`7o000000001?l00000oooo0?ooo`3oool2
08:2PP<0O7al0P1eMGD208:2PP<0MGEe0P22PX8206ATI0<0B4Q80P1iNGT208^;R`<0/;2`0P2CTi<2
02l_;`<0G5aL0P21PH4207inOP<0MgMg0P1aLG4304m?C`80Kfm_0P20P80308b<S080PX:20P1DE5@3
06][J`80U9BD0P1[Jf/305aLG080FUYJ0P22PX8309^KV`80B4Q80P2?Shl308J6QP80QhN70P1aLG43
03`l?080_kno0P2<S8`308N7Q`80Vi^K0P2PX:0306e]K@80;2`/0P1UIFD305]KF`80][Jf0P1NGUh3
07moO`80KFe]0`1hN7P204M7A`80UiNG0`21PH4208F5Q@80IFEU0`1cLg<405eMG@<0]kNg0P0T92@2
06IVIP<0MGEe0P1jNWX20::RXP<0UiNG0P1dM7@204I6AP<0NWYj0P1RHV8209FEU@<0XJ6Q0P1iNGT2
08j>SP<0NGUi0P29RHT207alO0<0EeMG0P1TI6@208b<S0<0;Rh^0P2CTi<30861P@80I6AT0P2?Shl3
07=cL`80IfMW0P28R8P308J6QP80HV9R0P2IVIT308Z:RP80NGUi0P1MGEd305QHF080D51@0P2NWYh3
07alO080GEeM1@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX8307alO080MGEe0P22PX83
07EeM@80PX:20P1TI6@304Q8B080NGUi0P2;Rh/30;2`/080Ti>C0P0_;bl305aLG080PH610P1nOWh3
07MgM`80LG5a0`1?Cdl206m_K`80P8200`2<S8`208:2PP80E5AD0`1[Jf/209BDU080Jf][0`1LG5`2
05YJFP80PX:20`2KVi/204Q8B080Shn?0`26QXH208N7Q`80LG5a0`0l?3`20;no_`80S8b<0`27QhL2
09^KV`80X:2P0`1]KFd202`/;080IFEU0`1KFe/20;Jf]P80GUiN0`1oOgl206e]K@<0N7Qh0P17AdL2
09NGU`<0PH610P25QHD206EUI@<0Lg=c101MGEd30;Ng]`8092@T0P1VIVH307EeM@80NWYj0P2RXZ83
09NGU`80M7Ad0P16ATH307YjNP80HV9R0P2EUID30:6QX@80NGUi0P2>SXh307UiN@80RHV90P1lO7`3
05MGE`80I6AT0P2<S8`302h^;P80Ti>C0`21PH4206ATI080Shn?0`1cLg<206MWI`80R8R80`26QXH2
069RHP80VIVI0`2:RXX207UiN@80GEeM0`1HF5P2051@D080WYjN0`1lO7`205eMG@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80O7al0`1hN7P208b<S080O7al1@1oOgl2092@T0<0DE5A0P1^KVh2
04I6AP<0=3@d0P1ZJVX20<30`0<0TI6A0P1dM7@205=CD`<0K6a/0P1KFe/30:JVYP80VIVI0P1nOWh3
0:BTY080VYZJ0P2h^;P309>CT`@0R8R80`2ATI420:ZZZP80MGEe0`1fMWH209:BTP80TI6A0`1SHf<2
09fMW@80UIFE0`26QXH202`/;080/;2`0`1PH60206m_K`80OGem0`1@D5020<W9b@801`L71@1^KVh2
096AT@<0P8200P1jNWX306m_K`80Xj>S0P1TI6@30861P@80Kfm_0P0P82030:j^[P80ADE50P20P803
04m?C`80/k>c0P0`<30309FEU@80N7Qh0P1]KFd307alO080D51@0P1^KVh30;>c/`80QXJ60P1oOgl3
07IfMP80VIVI0P28R8P3096AT@80UIFE0P1MGEd308N7Q`@0Ogmo0`29RHT208:2PP<0DE5A0P2>SXh2
06ATI0<0OWin0P29RHT207IfMP<0W9bL0P2HV9P205UIF@<0IVIV0P2KVi/206QXJ0<0X:2P0P1fMWH2
03Ph>0<0S8b<0P2CTi<50?ooo`7o000000001?l00000oooo0?ooo`3oool207alO0<0N7Qh0P2<S8`2
07alO0D0Ogmo0P2@T903055AD@80KVi^0P16ATH303@d=080JVYZ0P30`<03096AT@80M7Ad0P1CDe<3
06a/K080Fe]K0`2VYZH209VIV@80OWin0`2TY:@209ZJVP80^;Rh0`2CTi<408R8R0<0TI6A0P2ZZZX2
07EeM@<0MWIf0P2BTY82096AT@<0Hf=S0P2MWId209FEU@<0QXJ60P0/;2`20;2`/0<0H61P0P1_Kfl2
07emO@<0D51@0P39bLT200L71`D0KVi^0P2ATI430820P080NWYj0`1_Kfl20:>SX`80I6AT0`21PH42
06m_K`80820P0`2^[Zh204E5A@80P8200`1?Cdl20;>c/`80<30`0`2EUID207QhN080KFe]0`1lO7`2
051@D080KVi^0`2c/k<208J6QP80Ogmo0`1fMWH209VIV@80R8R80`2ATI4209FEU@80GEeM0`27QhL4
07moO`<0RHV90P22PX83055AD@80SXj>0P1TI6@307inOP80RHV90P1fMWH309bLW080V9RH0P1IFET3
06IVIP80Vi^K0P1XJ6P30:2PX080MWIf0P0h>3P308b<S080Ti>C1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P2GUiL307IfMPL0Ogmo0P1eMGD2075aL@<0JVYZ0P1jNWX209BDU0<0Z:RX0P2UYJD2
04m?C`<0UiNG0P2ZZZX50;>c/`80OWin0`1VIVH208^;R`80YJFU0`1aLG42065QH@80De=C0`20P802
07inOP80_[jn0`2<S8`206=SH`80OWin0`21PH4207EeM@8092@T0`27QhL207emO@80Ti>C0`30`<02
07EeM@80B4Q80`2GUiL207IfMP80[Jf]0`2;Rh/205QHF080jn_[0`20P80206e]K@80aLG50`13@d<2
061PH0<0QhN70P1ZJVX206QXJ0<0N7Qh0P25QHD207moO`<0>3Ph0P1TI6@208:2PP<0@d=30P2DU9@2
08J6QP<0QhN70P1TI6@208N7Q`<0VYZJ0P1ADE4209bLW0<0U9BD0P1XJ6P207emO@<0PH610P1^KVh2
07AdM0<0QHF50P1QHF42092@T0<0IFEU0P2_[jl208b<S0<0K6a/0P2MWId307IfMPL0Ogmo0P1hN7P2
0861P@<0GEeM0P1iNGT20;Zj^P<0KFe]0P1CDe<208>3P`<0Y:BT0P2EUID208n?S`<0>CTi0P1QHF45
0?ooo`7o000000001?l00000oooo0?ooo`3oool209NGU`<0MWIf1`1oOgl207EeM@80LG5a0`1ZJVX2
07YjNP80U9BD0`2XZ:P20:FUY@80Cdm?0`2GUiL20:ZZZPD0/k>c0P1nOWh306IVIP80Rh^;0P2UYJD3
075aL@80HF5Q0P1CDe<30820P080OWin0P2n_[h308b<S080Hf=S0P1nOWh30861P@80MGEe0P0T92@3
08N7Q`80OGem0P2CTi<30<30`080MGEe0P18B4P309NGU`80MWIf0P2][Jd308^;R`80F5QH0P3[jn/3
0820P080KFe]0P35aLD304=3@`80H61P0`27QhL206YZJP80J6QX0`1hN7P208F5Q@80Ogmo0`0h>3P2
06ATI080PX:20`13@d<209BDU080QXJ60`27QhL206ATI080QhN70`2JVYX2055AD@80W9bL0`2DU9@2
06QXJ080OGem0`21PH4206i^KP80M7Ad0`25QHD2065QH@80T92@0`1UIFD20:n_[`80S8b<0`1/K6`2
09fMW@<0MWIf1`1oOgl207QhN080PH610`1MGEd207UiN@80^[Zj0`1]KFd205=CD`80Ph>30`2TY:@2
09FEU@80Shn?0`0i>CT2065QH@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80UiNG0`1fMWH7
07moO`80MGEe0P1aLG4306YZJP80NWYj0P2DU9@30:RXZ080YJFU0P1?Cdl309NGU`80ZZZZ1@2c/k<2
07inOP<0IVIV0P2;Rh/20:FUY@<0LG5a0P1QHF4205=CD`<0P8200P1nOWh20;jn_P<0S8b<0P1SHf<2
07inOP<0PH610P1eMGD202@T90<0QhN70P1mOGd209>CT`<0`<300P1eMGD204Q8B0<0UiNG0P1fMWH2
0:f][@<0Rh^;0P1HF5P20>_[j`<0P8200P1]KFd20<G5a@<0@d=30P1PH60308N7Q`80JVYZ0P1XJ6P3
07QhN080QHF50P1oOgl303Ph>080I6AT0P22PX8304=3@`80U9BD0P26QXH308N7Q`80I6AT0P27QhL3
09ZJVP80DE5A0P2LW9`309BDU080J6QX0P1mOGd30861P@80KVi^0P1dM7@308F5Q@80HF5Q0P2@T903
06EUI@80[jn_0P2<S8`306a/K080WIfM0`1fMWH707moO`80N7Qh0P21PH4305eMG@80NGUi0P2j^[X3
06e]K@80De=C0P23Ph<30:BTY080UIFE0P2?Shl303Ti>@80HF5Q1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P1TI6@309:BTP80O7al3P1oOgl20;6a/@<0Ogmo0P1cLg<208n?S`<0NWYj0P1hN7P2
08R8R0<0TI6A0P29RHT3069RHP80WYjN0P1nOWh307IfMP80MgMg0P1aLG4308^;R`80Ph>30P1_Kfl3
06a/K080SXj>0P1mOGd306MWI`80P8200P21PH4305eMG@80Z:RX0P26QXH306QXJ080W9bL0P1LG5`3
06=SH`80L71`0P1ZJVX30;Rh^080GUiN0P1]KFd30;fm_@80QHF50P1IFET30;bl_080EeMG0`1UIFD2
0<30`080]kNg0`1IFET205iNGP80M7Ad0`1mOGd208b<S080IfMW0`1lO7`206MWI`80Shn?0`1UIFD2
07emO@80T92@0`1;Bd/206e]K@80TI6A0`1XJ6P208J6QP80YjNW0`1<C4`207AdM080QhN70`1^KVh2
07AdM080KFe]0`1mOGd209>CT`80J6QX0`25QHD205eMG@<0P8200P22PX8208V9R@<0QXJ60P22PX82
07=cL`<0PX:20P1^KVh204m?C`<0[:b/0P1fMWH206i^KP<0B4Q80P22PX8207inOP<0UIFE0P1hN7P5
0?ooo`7o000000001?l00000oooo0?ooo`3oool206ATI0<0TY:B0P1lO7`>07moO`80/K6a0`1oOgl2
07=cL`80Shn?0`1jNWX207QhN080R8R80`2ATI4208V9R@<0HV9R0P2NWYh207inOP<0MWIf0P1gMgL2
075aL@<0Rh^;0P23Ph<206m_K`<0K6a/0P2>SXh207emO@<0IfMW0P20P8020861P@<0GEeM0P2XZ:P2
08J6QP<0J6QX0P2LW9`205aLG0<0Hf=S0P1`L70206YZJP<0^;Rh0P1NGUh206e]K@<0_Kfm0P25QHD2
05UIF@<0_;bl0P1GEeL306EUI@80`<300P2g]kL305UIF@80GUiN0P1dM7@307emO@80S8b<0P1WIfL3
07alO080IfMW0P2?Shl306EUI@80OGem0P2@T90304];B`80KFe]0P2ATI4306QXJ080QXJ60P2WYjL3
04a<C080M7Ad0P27QhL306i^KP80M7Ad0P1]KFd307emO@80Ti>C0P1XJ6P308F5Q@80GEeM0`20P802
08:2PP80RHV90`26QXH208:2PP80Lg=c0`22PX8206i^KP80Cdm?0`2/[:`207IfMP80KVi^0`18B4P2
08:2PP80OWin0`2EUID207QhN0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80Ogmo0`1eMGD2
08:2PP80Ogmo0`29RHT208J6QP80O7al0`2@T90205]KF`80LG5a0`1KFe/206m_K`80YjNW0`2TY:@2
06m_K`D0Ogmo0P2GUiL30:JVYP80HV9R0P1/K6`307IfMP80KFe]0P2XZ:P306e]K@80FEUI0P0l?3`3
07QhN080RXZ:1@1oOgl2092@T0D0RXZ:0P1cLg<207MgM`<0I6AT0P2@T90207emO@<0Zj^[0P1gMgL2
05QHF0<0MgMg0P2[Zj/205iNGP<0VYZJ0P1GEeL20:RXZ0<0IfMW0P2m_Kd301hN7P80UIFE0P2:RXX3
03`l?080J6QX0P1/K6`3069RHP80XJ6Q0P1WIfL309:BTP80QHF50P2MWId307YjNP80V9RH0P0U9BD3
08b<S080TI6A0P2n_[h304=3@`80M7Ad0P1>CTh30:ZZZP80L71`0P28R8P309BDU080MgMg0P1^KVh3
08n?S`80Ti>C0P28R8P306QXJ080L71`0`2@T902075aL@80N7Qh0`1aLG4207inOP80PH610`1[Jf/2
08b<S080OGem0`1[Jf/207alO080RHV90`1/K6`207AdM080L71`0`1lO7`2075aL@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80Ogmo0`1eMGD208:2PP80Ogmo0`29RHT208J6QP80O7al0`2@T902
05]KF`80LG5a0`1KFe/206m_K`80YjNW0`2TY:@206m_K`D0Ogmo0P2GUiL30:JVYP80HV9R0P1/K6`3
07IfMP80KFe]0P2XZ:P306e]K@80FEUI0P0l?3`307QhN080RXZ:1@1oOgl2092@T0D0RXZ:0P1cLg<2
07MgM`<0I6AT0P2@T90207emO@<0Zj^[0P1gMgL205QHF0<0MgMg0P2[Zj/205iNGP<0VYZJ0P1GEeL2
0:RXZ0<0IfMW0P2m_Kd301hN7P80UIFE0P2:RXX303`l?080J6QX0P1/K6`3069RHP80XJ6Q0P1WIfL3
09:BTP80QHF50P2MWId307YjNP80V9RH0P0U9BD308b<S080TI6A0P2n_[h304=3@`80M7Ad0P1>CTh3
0:ZZZP80L71`0P28R8P309BDU080MgMg0P1^KVh308n?S`80Ti>C0P28R8P306QXJ080L71`0`2@T902
075aL@80N7Qh0`1aLG4207inOP80PH610`1[Jf/208b<S080OGem0`1[Jf/207alO080RHV90`1/K6`2
07AdM080L71`0`1lO7`2075aL@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80Ogmo0`1eMGD2
08:2PP80Ogmo0`29RHT208J6QP80O7al0`2@T90205]KF`80LG5a0`1KFe/206m_K`80YjNW0`2TY:@2
06m_K`D0Ogmo0P2GUiL30:JVYP80HV9R0P1/K6`307IfMP80KFe]0P2XZ:P306e]K@80FEUI0P0l?3`3
07QhN080RXZ:1@1oOgl2092@T0D0RXZ:0P1cLg<207MgM`<0I6AT0P2@T90207emO@<0Zj^[0P1gMgL2
05QHF0<0MgMg0P2[Zj/205iNGP<0VYZJ0P1GEeL20:RXZ0<0IfMW0P2m_Kd301hN7P80UIFE0P2:RXX3
03`l?080J6QX0P1/K6`3069RHP80XJ6Q0P1WIfL309:BTP80QHF50P2MWId307YjNP80V9RH0P0U9BD3
08b<S080TI6A0P2n_[h304=3@`80M7Ad0P1>CTh30:ZZZP80L71`0P28R8P309BDU080MgMg0P1^KVh3
08n?S`80Ti>C0P28R8P306QXJ080L71`0`2@T902075aL@80N7Qh0`1aLG4207inOP80PH610`1[Jf/2
08b<S080OGem0`1[Jf/207alO080RHV90`1/K6`207AdM080L71`0`1lO7`2075aL@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80LG5a0`2<S8`207alO080Ogmo0`1eMGD207QhN0D0S8b<0P1iNGT2
05=CD`<0V9RH0P1aLG4207EeM@<0IFEU0P2^[Zh20<O7a`D0IVIV0`1_Kfl209BDU080Hf=S0`1/K6`2
07inOP80ATI60`1aLG4208Z:RPD0Jf][0P1VIVH20820P0<0LG5a0P2BTY8208^;R`<0NGUi0P26QXH2
07IfMP<0L71`0P2PX:020;Jf]P<0JVYZ0P2l_;`20:^[Z`<0Xj>S0P2RXZ8207inOP<061PH0P3Vi^H2
0<c<c0<04a<C0P1:BTX3071`L080VYZJ0P1dM7@309VIV@80@D510P2/[:`30;fm_@80EeMG0P25QHD3
0:BTY080XZ:R0P2NWYh308Z:RP80P8200P2MWId307AdM080T92@0P0/;2`307MgM`80Lg=c0P2ATI45
075aL@80MgMg0`1fMWH206QXJ080VIVI0`1_Kfl205YJFP80LG5a0`1nOWh207alO0<0PH610P1hN7P2
09FEU@<0Ogmo0P2>SXh208Z:RP<0U9BD0P1UIFD207inOP<0PH610P1oOgl206i^KP<0QHF50P1TI6@2
09:BTP<0[Zj^0P29RHT50?ooo`7o000000001?l00000oooo0?ooo`3oool2075aL@<0S8b<0P1lO7`2
07moO`<0MGEe0P1hN7P508b<S080NGUi0P1CDe<309RHV080LG5a0P1eMGD306EUI@80[Zj^0P37alL5
06IVIP<0Kfm_0P2DU9@206=SH`<0K6a/0P1nOWh204I6AP<0LG5a0P2:RXX506][J`80IVIV0P20P803
075aL@80TY:B0P2;Rh/307UiN@80QXJ60P1fMWH3071`L080X:2P0P2f][H306YZJP80_;bl0P2[Zj/3
0:>SX`80XZ:R0P1nOWh301PH6080i^KV0P3<c<`301<C4`80BTY:0`1`L70209ZJVP80M7Ad0`2IVIT2
0451@@80[:b/0`2m_Kd205MGE`80QHF50`2TY:@20::RXP80WYjN0`2:RXX20820P080WIfM0`1dM7@2
092@T080;2`/0`1gMgL207=cL`80TI6A1@1aLG4207MgM`<0MWIf0P1XJ6P209VIV@<0Kfm_0P1JFUX2
075aL@<0OWin0P1lO7`30861P@80N7Qh0P2EUID307moO`80SXj>0P2:RXX309BDU080IFEU0P1nOWh3
0861P@80Ogmo0P1^KVh308F5Q@80I6AT0P2BTY830:j^[P80RHV91@3oool1o`00000000Co00000?oo
o`3oool0oooo0P26QXH307alO080MGEe0P22PX8707moO`<0VYZJ0P3Kfm/208V9R@<0MgMg0P2>SXh2
069RHP<0[jn_0P1[Jf/203@d=0<0ZZZZ0P2_[jl30;Bd]080FUYJ0P2c/k<30::RXP80VYZJ0P2LW9`3
09VIV@80N7Qh0P1mOGd30;6a/@80IfMW0P1jNWX306YZJP80DE5A0P20P80308^;R`80GUiN0P2TY:@3
0<k>cP80OGem0P23Ph<307AdM080OWin0P2HV9P306e]K@80KVi^0P39bLT30:FUY@800P820P2ATI43
0:JVYP80?Shn0`3AdM42071`L080U9BD0`2;Rh/205YJFP80IfMW0`1iNGT208R8R080PH610`1jNWX2
02PX:080FEUI0`3?cll208N7Q`80Ph>30`25QHD20;6a/@80DU9B0`2BTY8208:2PP80IFEU0`20P802
09:BTP80NGUi0`1^KVh20:JVYP80Hf=S0`1dM7@204Q8B080S8b<0`1jNWX208R8R0<0K6a/0P2EUID2
05iNGP<0R8R81`1oOgl208V9R@80PX:20`1fMWH209:BTP80U9BD0`1fMWH20:6QX@80Hf=S0`11@D42
07YjNPD0oooo0Ol000000004o`00003oool0oooo0?ooo`80QXJ60`1lO7`207EeM@80PX:21`1oOgl3
09ZJVP80fm_K0P29RHT307MgM`80SXj>0P1RHV830:n_[`80Jf][0P0d=3@30:ZZZP80[jn_0`2d];@2
05YJFP80/k>c0`2RXZ8209ZJVP80W9bL0`2IVIT207QhN080OGem0`2a/K4206MWI`80NWYj0`1ZJVX2
055AD@80P8200`2;Rh/205iNGP80Y:BT0`3>c/h207emO@80Ph>30`1dM7@207inOP80V9RH0`1]KFd2
06i^KP80bLW90`2UYJD200820P80TI6A0`2VYZH203hn?P<0dM7A0P1`L70209BDU0<0Rh^;0P1JFUX2
06MWI`<0NGUi0P28R8P20861P@<0NWYj0P0X:2P205UIF@<0clo?0P27QhL208>3P`<0QHF50P2a/K42
059BDP<0TY:B0P22PX8206EUI@<0P8200P2BTY8207UiN@<0KVi^0P2VYZH206=SH`<0M7Ad0P18B4P2
08b<S0<0NWYj0P28R8P306a/K080UIFE0P1NGUh308R8R0L0Ogmo0P29RHT208:2PP<0MWIf0P2BTY82
09BDU0<0MWIf0P2QXJ4206=SH`<0@D510P1jNWX50?ooo`7o000000001?l00000oooo0?ooo`3oool2
08J6QP<0O7al0P1eMGD208:2PPL0Ogmo0`2JVYX20=_Kf`80RHV90`1gMgL208j>SP80HV9R0`2_[jl2
06][J`80=3@d0`2ZZZX20:n_[`<0];Bd0P1JFUX20;>c/`<0XZ:R0P2JVYX209bLW0<0VIVI0P1hN7P2
07emO@<0/K6a0P1WIfL207YjNP<0JVYZ0P1ADE420820P0<0Rh^;0P1NGUh20:BTY0<0c/k>0P1mOGd2
08>3P`<0M7Ad0P1nOWh209RHV0<0KFe]0P1^KVh20<W9b@<0YJFU0P020P82096AT@<0YZJV0P0n?Sh3
0=7Ad@80L71`0P2DU9@308^;R`80FUYJ0P1WIfL307UiN@80R8R80P21PH4307YjNP80:2PX0P1IFET3
0<o?c`80QhN70P23Ph<308F5Q@80/K6a0P1BDU8309:BTP80PX:20P1UIFD30820P080TY:B0P1iNGT3
06i^KP80YZJV0P1SHf<307AdM080B4Q80P2<S8`307YjNP80R8R80`1/K6`209FEU@80GUiN0`28R8P7
07moO`80RHV90P22PX8307IfMP80TY:B0P2DU9@307IfMP80XJ6Q0P1SHf<30451@@80NWYj1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P22PX8307moO`80RHV90P1lO7`307moO`80RHV90P22PX83
0=_Kf`80EEEE0P1^KVh309NGU`80P8200P23Ph<305]KF`80K6a/0P22PX8304Q8B080Bd];0`26QXH2
09bLW080JVYZ0`1cLg<207YjNP80HF5Q0`1>CTh208b<S080YZJV0`1:BTX20:j^[P80Hf=S0`25QHD2
07moO`80UiNG0`21PH4209>CT`80EEEE0`1XJ6P208Z:RP80QXJ60`3AdM4203Xj>P80De=C0`1SHf<2
071`L080[Zj^0`2m_Kd207inOP80Hf=S0`29RHT208^;R`<0Xj>S0P1oOgl20;jn_P<0CTi>0P2VYZH2
08J6QP<0MWIf0P1ADE420861P@<0HV9R0P27QhL206QXJ0<0Lg=c0P2<S8`206QXJ0<0GEeM0P19BDT2
09bLW0<0U9BD0P2][Jd203hn?P<0G5aL0P2GUiL207=cL`<0LG5a0P1nOWh209:BTP<0NGUi0P2CTi<2
06i^KP<0RHV90P1mOGd307EeM@80LG5a0P25QHD307QhN080G5aL0P25QHD306IVIP80R8R80P1oOgl3
08J6QP80V9RH0P20P8030:NWY`80H61P0P2EUID307UiN@80MGEe1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P22PX8307moO`80RHV90P1lO7`307moO`80RHV90P22PX830=_Kf`80EEEE0P1^KVh3
09NGU`80P8200P23Ph<305]KF`80K6a/0P22PX8304Q8B080Bd];0`26QXH209bLW080JVYZ0`1cLg<2
07YjNP80HF5Q0`1>CTh208b<S080YZJV0`1:BTX20:j^[P80Hf=S0`25QHD207moO`80UiNG0`21PH42
09>CT`80EEEE0`1XJ6P208Z:RP80QXJ60`3AdM4203Xj>P80De=C0`1SHf<2071`L080[Zj^0`2m_Kd2
07inOP80Hf=S0`29RHT208^;R`<0Xj>S0P1oOgl20;jn_P<0CTi>0P2VYZH208J6QP<0MWIf0P1ADE42
0861P@<0HV9R0P27QhL206QXJ0<0Lg=c0P2<S8`206QXJ0<0GEeM0P19BDT209bLW0<0U9BD0P2][Jd2
03hn?P<0G5aL0P2GUiL207=cL`<0LG5a0P1nOWh209:BTP<0NGUi0P2CTi<206i^KP<0RHV90P1mOGd3
07EeM@80LG5a0P25QHD307QhN080G5aL0P25QHD306IVIP80R8R80P1oOgl308J6QP80V9RH0P20P803
0:NWY`80H61P0P2EUID307UiN@80MGEe1@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX8:
07moO`80MGEe0P3^k^h30:FUY@80JVYZ0P28R8P30:^[Z`80_Kfm0P37alL30:RXZ080bl_;0P1TI6@3
09BDU080Shn?0`1ZJVX2096AT@80FEUI0`1XJ6P205QHF080O7al0`2QXJ4208N7Q`80NGUi0`26QXH2
05]KF`D0Vi^K0P2;Rh/209FEU@<0Ti>C0P26QXH207IfMP<0P8200P1TI6@20;Ng]`<0GUiN0P3IfMT2
09:BTP<0P8200P1fMWH205iNGP<0NGUi0P1]KFd208j>SP<0WYjN0P2BTY8304a<C080PX:20P1hN7P3
06][J`80Kfm_0P2UYJD307EeM@80EeMG0P2@T90304Q8B080Z:RX0P2?Shl305aLG080MgMg0P2][Jd3
07QhN080GUiN0P29RHT307EeM@80EeMG0P1mOGd308F5Q@80T92@0P1iNGT306i^KP80Rh^;0P1cLg<3
08:2PP80Jf][0P1eMGD308F5Q@80N7Qh0`2;Rh/2075aL@80N7Qh0`22PX8208V9R@80LG5a0`2GUiL2
06ATI080Ogmo0`21PH4207moO`80YjNW0`2QXJ420;>c/`80[:b/0`2:RXX208n?S`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80PX:22P1oOgl207EeM@80k^k^0`2UYJD206YZJP80R8R80`2[Zj/2
0;fm_@80alO70`2XZ:P20<_;b`80I6AT0`2DU9@208n?S`<0JVYZ0P2ATI4205UIF@<0J6QX0P1HF5P2
07alO0<0XJ6Q0P27QhL207UiN@<0QXJ60P1KFe/509^KV`80Rh^;0P2EUID309>CT`80QXJ60P1fMWH3
0820P080I6AT0P2g]kL305iNGP80fMWI0P2BTY830820P080MWIf0P1NGUh307UiN@80KFe]0P2>SXh3
09jNWP80TY:B0`1<C4`208:2PP80N7Qh0`1[Jf/206m_K`80YJFU0`1eMGD205MGE`80T92@0`18B4P2
0:RXZ080Shn?0`1LG5`207MgM`80[Jf]0`1hN7P205iNGP80RHV90`1eMGD205MGE`80OGem0`25QHD2
092@T080NGUi0`1^KVh208^;R`80Lg=c0`22PX8206][J`80MGEe0`25QHD207QhN0<0Rh^;0P1aLG42
07QhN0<0PX:20P29RHT2075aL@<0UiNG0P1TI6@207moO`<0PH610P1oOgl20:NWY`<0XJ6Q0P2c/k<2
0:b/[0<0RXZ:0P2?Shl50?ooo`7o000000001?l00000oooo0?ooo`3oool208:2PPX0Ogmo0P1eMGD2
0>k^kP<0YJFU0P1ZJVX208R8R0<0Zj^[0P2m_Kd20<O7a`<0Z:RX0P3;bl/206ATI0<0U9BD0P2?Shl3
06YZJP80TI6A0P1IFET306QXJ080F5QH0P1lO7`30:6QX@80QhN70P1iNGT308J6QP80Fe]K1@2KVi/2
08^;R`80UIFE0`2CTi<208J6QP80MWIf0`20P80206ATI080]kNg0`1NGUh20=WIf@80TY:B0`20P802
07IfMP80GUiN0`1iNGT206e]K@80SXj>0`2NWYh209:BTP<0C4a<0P22PX8207QhN0<0Jf][0P1_Kfl2
0:FUY@<0MGEe0P1GEeL2092@T0<0B4Q80P2XZ:P208n?S`<0G5aL0P1gMgL20:f][@<0N7Qh0P1NGUh2
08V9R@<0MGEe0P1GEeL207emO@<0QHF50P2@T90207UiN@<0KVi^0P2;Rh/207=cL`<0PX:20P1[Jf/2
07EeM@<0QHF50P1hN7P308^;R`80LG5a0P1hN7P308:2PP80RHV90P1aLG4309NGU`80I6AT0P1oOgl3
0861P@80Ogmo0P2WYjL30:6QX@80/k>c0P2/[:`308Z:RP80Shn?1@3oool1o`00000000Co00000?oo
o`3oool0oooo301oOgl209ZJVP80c/k>0`2ATI4207UiN@80Zj^[0`20P8020:b/[080`/;20`1IFET2
05YJFP80Ogmo0`1mOGd20;Ng]`<0IVIV0P1;Bd/2096AT@<0Zj^[0P2;Rh/2096AT@<0MWIf0P1eMGD2
075aL@<0Shn?0P1lO7`206ATI0<0OWin0P29RHT205QHF0<0VIVI0P2VYZH20:f][@<0Ogmo0P29RHT2
04i>CP<0SXj>0P2QXJ4208^;R`<0i^KV0P2WYjL204i>CP<0GUiN0P2^[Zh2030`<0<0EEEE0P2HV9P3
07MgM`80PH610P1@D50306=SH`80^KVi0P2SXj<3065QH@80NGUi0P1TI6@3075aL@80`<300P2DU9@3
07EeM@80KFe]0P1`L7030;6a/@80X:2P0P1XJ6P30861P@80MGEe0P2a/K4309^KV`80FEUI0P1_Kfl3
09RHV080HV9R0P2RXZ83096AT@80RXZ:0P1oOgl307IfMP80R8R80`23Ph<207emO@T0Ogmo0`26QXH2
0::RXP80NGUi0`1mOGd207QhN080H61P0`23Ph<204m?C`80Ogmo0`2`/;020<S8b0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo``0Ogmo0P2JVYX20<k>cP<0TI6A0P1iNGT20:^[Z`<0P8200P2/[:`2
0<;2`P<0FEUI0P1JFUX207moO`<0OGem0P2g]kL306IVIP80Bd];0P2ATI430:^[Z`80Rh^;0P2ATI43
07IfMP80MGEe0P1aLG4308n?S`80O7al0P1TI6@307inOP80RHV90P1HF5P309VIV@80YZJV0P2][Jd3
07moO`80RHV90P1>CTh308j>SP80XJ6Q0P2;Rh/30>KViP80YjNW0P1>CTh305iNGP80[Zj^0P0`<303
05EEE@80V9RH0`1gMgL20861P@80D51@0`1SHf<20;Vi^@80Xj>S0`1QHF4207UiN@80I6AT0`1aLG42
0<30`080U9BD0`1eMGD206e]K@80L71`0`2a/K420:2PX080J6QX0`21PH4207EeM@80/K6a0`2KVi/2
05UIF@80Kfm_0`2HV9P2069RHP80XZ:R0`2ATI4208Z:RP80Ogmo0`1fMWH208R8R0<0Ph>30P1mOGd9
07moO`<0QXJ60P2RXZ8207UiN@<0OGem0P1hN7P2061PH0<0Ph>30P1?Cdl207moO`<0/;2`0P38b<P5
0?ooo`7o000000001?l00000oooo0?ooo`3oool208:2PPL0Ogmo0`2JVYX20:b/[080Hf=S0`12@T82
07=cL`80BTY:0`2ATI4205QHF080De=C0`2IVIT207IfMP80L71`0`2d];@205iNGP<0@D510P2EUID2
09NGU`<0IVIV0P1ZJVX506e]K@80R8R80P1eMGD306MWI`80ZZZZ0P1dM7@307moO`80Y:BT0P2:RXX3
0861P@80HF5Q0P1`L70307IfMP80W9bL0P1dM7@307IfMP80[Zj^0P2VYZH307AdM080/k>c0P1PH603
02DU9@80][Jf0P18B4P30;Ng]`80BDU90`2e]KD209>CT`80>SXj0`2BTY820;Fe]@80L71`0`1?Cdl2
07MgM`80U9BD0`1jNWX209>CT`80QXJ60`3;bl/206MWI`80JVYZ0`2JVYX206ATI080/K6a0`3Bd]82
08N7Q`D0O7al0P2GUiL208R8R0<0XZ:R0P29RHT207MgM`<0T92@0P2KVi/20:ZZZP<0M7Ad0P1mOGd3
07moO`80RHV90P2GUiL307emO@80QhN70P26QXH307EeM@80MgMg0P2<S8`309NGU`80QhN70P1cLg<3
05UIF@80S8b<0P1GEeL3051@D080ATI61@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX87
07moO`<0VYZJ0P2/[:`206=SH`<0@T920P1cLg<204Y:BP<0TI6A0P1HF5P205=CD`<0VIVI0P1fMWH2
071`L0<0];Bd0P1NGUh30451@@80UIFE0P2GUiL306IVIP80JVYZ1@1]KFd208R8R080MGEe0`1WIfL2
0:ZZZP80M7Ad0`1oOgl20:BTY080RXZ:0`21PH42065QH@80L71`0`1fMWH209bLW080M7Ad0`1fMWH2
0:j^[P80YZJV0`1dM7@20;>c/`80H61P0`0U9BD20;Jf]P80B4Q80`2g]kL204U9B@<0]KFe0P2CTi<2
03Xj>P<0TY:B0P2e]KD2071`L0<0Cdm?0P1gMgL209BDU0<0NWYj0P2CTi<208J6QP<0bl_;0P1WIfL2
06YZJP<0VYZJ0P1TI6@20;6a/@<0d];B0P27QhL507alO080UiNG0P28R8P30::RXP80RHV90P1gMgL3
092@T080Vi^K0P2ZZZX307AdM080OGem0`1oOgl208V9R@80UiNG0`1mOGd208N7Q`80QXJ60`1eMGD2
07MgM`80S8b<0`2GUiL208N7Q`80Lg=c0`1IFET208b<S080EeMG0`1@D50204I6APD0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80PX:21`1oOgl309ZJVP80[:b/0P1SHf<30492@P80Lg=c0P1:BTX3
096AT@80F5QH0P1CDe<309VIV@80MWIf0P1`L7030;Bd]080GUiN0`11@D4209FEU@80UiNG0`1VIVH2
06YZJPD0KFe]0P28R8P207EeM@<0IfMW0P2ZZZX207AdM0<0Ogmo0P2TY:@208Z:RP<0PH610P1QHF42
071`L0<0MWIf0P2LW9`207AdM0<0MWIf0P2^[Zh20:JVYP<0M7Ad0P2c/k<2061PH0<09BDU0P2f][H2
04Q8B0<0]kNg0P19BDT30;Fe]@80Ti>C0P0j>SX309:BTP80]KFe0P1`L70304m?C`80MgMg0P2DU9@3
07YjNP80Ti>C0P26QXH30<_;b`80IfMW0P1ZJVX309ZJVP80I6AT0P2a/K430=;BdP80QhN71@1lO7`2
09NGU`80R8R80`2RXZ8208V9R@80MgMg0`2@T90209^KV`80ZZZZ0`1dM7@207emO@<0Ogmo0P29RHT2
09NGU`<0OGem0P27QhL208J6QP<0MGEe0P1gMgL208b<S0<0UiNG0P27QhL207=cL`<0FEUI0P2<S8`2
05MGE`<0D51@0P16ATH50?ooo`7o000000001?l00000oooo0?ooo`3oool207alO0<0MGEe0P22PX82
07moO`<0N7Qh0P2IVIT2071`L0<0B4Q80P21PH4209VIV@<0?3`l0P1TI6@2030`<0<0@4100P1iNGT2
07AdM0<061PH0P1@D5030;fm_@80FEUI0P15ADD304m?C`80O7al0P21PH43071`L080Hf=S0P2DU9@3
07alO080QXJ60P3>c/h308b<S080MGEe0P2d];@306e]K@80QXJ60P2HV9P309^KV`80J6QX0P32`/83
0:JVYP80RHV90P2e]KD30;Ng]`80U9BD0P2c/k<307UiN@80BTY:0P38b<P307=cL`80_Kfm0`0P8202
09BDU080BTY:0`1_Kfl206a/K080C4a<0`1TI6@20<71`@80O7al0`21PH4203Ti>@80R8R80`1:BTX2
09:BTP80Ogmo0`2TY:@20:b/[080K6a/0`29RHT2092@T080S8b<0`2GUiL209>CT`80WIfM0`1hN7P2
07emO@80UiNG0`1nOWh207emO@80QXJ60`27QhL207EeM@<0PH611`1oOgl208J6QP80Lg=c0`29RHT2
08N7Q`80S8b<0`1XJ6P207AdM080QHF50`1JFUX2061PH080NGUi0`26QXH206ATI0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80O7al0`1eMGD208:2PP80Ogmo0`1hN7P209VIV@80L71`0`18B4P2
0861P@80VIVI0`0l?3`206ATI080<30`0`10@40207UiN@80M7Ad0`0H61P2051@D0<0_Kfm0P1IFET2
04E5A@<0Cdm?0P1lO7`20861P@<0L71`0P1SHf<209BDU0<0O7al0P26QXH20<k>cP<0S8b<0P1eMGD2
0;Bd]0<0KFe]0P26QXH209RHV0<0Vi^K0P1XJ6P20<;2`P<0YZJV0P29RHT20;Fe]@<0]kNg0P2DU9@2
0;>c/`<0NGUi0P1:BTX20<S8b0<0Lg=c0P2m_Kd3020P8080U9BD0P1:BTX306m_K`80K6a/0P1<C4`3
06ATI080`L710P1lO7`30861P@80>CTi0P28R8P304Y:BP80TY:B0P1oOgl30:BTY080[:b/0P1/K6`3
08V9R@80T92@0P2<S8`309NGU`80Ti>C0P2MWId307QhN080OGem0P2GUiL307inOP80OGem0P26QXH3
08N7Q`80MGEe0`21PH4707moO`80QXJ60P1cLg<308V9R@80QhN70P2<S8`306QXJ080M7Ad0P25QHD3
05YJFP80H61P0P1iNGT308J6QP80I6AT1@3oool1o`00000000Co00000?ooo`3oool0oooo0P1oOgl3
08V9R@80O7al0P29RHT30;no_`80WYjN0P2;Rh/304a<C080D51@0P19BDT30410@080Cdm?0P1jNWX3
0:6QX@80KFe]0P2h^;P307inOP80NGUi0`1MGEd206m_K`80OWin0`1hN7P208:2PP80MGEe0`22PX82
08J6QP80Lg=c0`2MWId208N7Q`80NGUi0`2TY:@206m_K`80YJFU0`1_Kfl206QXJ080K6a/0`2SXj<2
096AT@80P8200`2CTi<205aLG080ADE50`2IVIT207YjNP80XZ:R0`2IVIT202DU9@80_[jn0`1/K6`2
071`L0<0G5aL0P1MGEd208n?S`<0Ogmo0P1CDe<205]KF`<0YjNW0P1SHf<209NGU`<0Kfm_0P1WIfL2
06YZJP<0Ti>C0P2TY:@208J6QP<0LG5a0P1gMgL20<K6aP<0Fe]K0P2DU9@208Z:RP<0QhN70P1jNWX2
08J6QP<0QhN70P2CTi<206IVIP<0QHF50P1oOgl205eMG@<0P8200P22PX8307QhN080PH610P1^KVh3
09VIV@80IfMW0P2?Shl307alO080Zj^[0P1PH6030;Ng]`80Ogmo0P1iNGT307moO`80T92@0P1cLg<3
07MgM`80PX:21@3oool1o`00000000Co00000?ooo`3oool0oooo0P1oOgl308V9R@80O7al0P29RHT3
0;no_`80WYjN0P2;Rh/304a<C080D51@0P19BDT30410@080Cdm?0P1jNWX30:6QX@80KFe]0P2h^;P3
07inOP80NGUi0`1MGEd206m_K`80OWin0`1hN7P208:2PP80MGEe0`22PX8208J6QP80Lg=c0`2MWId2
08N7Q`80NGUi0`2TY:@206m_K`80YJFU0`1_Kfl206QXJ080K6a/0`2SXj<2096AT@80P8200`2CTi<2
05aLG080ADE50`2IVIT207YjNP80XZ:R0`2IVIT202DU9@80_[jn0`1/K6`2071`L0<0G5aL0P1MGEd2
08n?S`<0Ogmo0P1CDe<205]KF`<0YjNW0P1SHf<209NGU`<0Kfm_0P1WIfL206YZJP<0Ti>C0P2TY:@2
08J6QP<0LG5a0P1gMgL20<K6aP<0Fe]K0P2DU9@208Z:RP<0QhN70P1jNWX208J6QP<0QhN70P2CTi<2
06IVIP<0QHF50P1oOgl205eMG@<0P8200P22PX8307QhN080PH610P1^KVh309VIV@80IfMW0P2?Shl3
07alO080Zj^[0P1PH6030;Ng]`80Ogmo0P1iNGT307moO`80T92@0P1cLg<307MgM`80PX:21@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1oOgl308V9R@80O7al0P29RHT30;no_`80WYjN0P2;Rh/3
04a<C080D51@0P19BDT30410@080Cdm?0P1jNWX30:6QX@80KFe]0P2h^;P307inOP80NGUi0`1MGEd2
06m_K`80OWin0`1hN7P208:2PP80MGEe0`22PX8208J6QP80Lg=c0`2MWId208N7Q`80NGUi0`2TY:@2
06m_K`80YJFU0`1_Kfl206QXJ080K6a/0`2SXj<2096AT@80P8200`2CTi<205aLG080ADE50`2IVIT2
07YjNP80XZ:R0`2IVIT202DU9@80_[jn0`1/K6`2071`L0<0G5aL0P1MGEd208n?S`<0Ogmo0P1CDe<2
05]KF`<0YjNW0P1SHf<209NGU`<0Kfm_0P1WIfL206YZJP<0Ti>C0P2TY:@208J6QP<0LG5a0P1gMgL2
0<K6aP<0Fe]K0P2DU9@208Z:RP<0QhN70P1jNWX208J6QP<0QhN70P2CTi<206IVIP<0QHF50P1oOgl2
05eMG@<0P8200P22PX8307QhN080PH610P1^KVh309VIV@80IfMW0P2?Shl307alO080Zj^[0P1PH603
0;Ng]`80Ogmo0P1iNGT307moO`80T92@0P1cLg<307MgM`80PX:21@3oool1o`00000000Co00000?oo
o`3oool0oooo1`1oOgl209ZJVP<0QhN70P23Ph<208b<S0<0P8200P2DU9@20=cLg0<0Ogmo0P21PH42
07AdM0<0Hf=S0P1[Jf/2034a<@<0NWYj0P1iNGT306YZJP@0PH610`29RHT2075aL@80N7Qh0`22PX82
07moO`80Zj^[0`2`/;020:ZZZP80L71`0`1/K6`209VIV@80LG5a0`21PH42092@T080J6QX1@2LW9`2
08>3P`<0U9BD0P23Ph<205EEE@<000000P2TY:@202LW9`<0KVi^0P1gMgL203dm?@<0MWIf0P1_Kfl3
061PH080@T920P1UIFD307QhN080P8200P1`L70306e]K@80YJFU0P2CTi<3065QH@80Ogmo0P28R8P3
06QXJ080WIfM0P2d];@307alO080Ph>30P2CTi<309VIV@80M7Ad0P2@T903096AT@80Shn?0P2LW9`3
08N7Q`80PX:20P2TY:@308V9R@80R8R80P23Ph<3092@T080N7Qh0`1eMGD207QhN080RHV90`1cLg<2
08b<S080LG5a0`22PX8205eMG@80Vi^K0`23Ph<207alO080XJ6Q0`2?Shl20:b/[080^[Zj0`2:RXX2
08>3P`D0oooo0Ol000000004o`00003oool0oooo0?ooo`L0Ogmo0P2JVYX308N7Q`80Ph>30P2<S8`3
0820P080U9BD0P3Lg=`307moO`80PH610P1dM7@306=SH`80Jf][0P0a<C4307YjNP80NGUi0`1ZJVX4
0861P@<0RHV90P1aLG4207QhN0<0PX:20P1oOgl20:^[Z`<0/;2`0P2ZZZX2071`L0<0K6a/0P2IVIT2
075aL@<0PH610P2@T90206QXJ0D0W9bL0P23Ph<309BDU080Ph>30P1EEED300000080Y:BT0P0W9bL3
06i^KP80MgMg0P0m?Cd307IfMP80Kfm_0`1PH6020492@P80IFEU0`1hN7P20820P080L71`0`1]KFd2
0:FUY@80Ti>C0`1QHF4207moO`80R8R80`1XJ6P209fMW@80];Bd0`1lO7`208>3P`80Ti>C0`2IVIT2
07AdM080T92@0`2ATI4208n?S`80W9bL0`27QhL208:2PP80Y:BT0`29RHT208R8R080Ph>30`2@T902
07QhN0<0MGEe0P1hN7P208V9R@<0Lg=c0P2<S8`2075aL@<0PX:20P1MGEd209^KV`<0Ph>30P1lO7`2
0:6QX@<0Shn?0P2/[:`20;Zj^P<0RXZ:0P23Ph<50?ooo`7o000000001?l00000oooo0?ooo`3oool2
07QhN0<0PX:20P1oOgl208V9R@<0O7al0P1@D502018B4P<0K6a/0P22PX8201TI6@<0/;2`0P1]KFd2
09BDU0<0RXZ:0P1NGUh207inOP<0N7Qh0P1WIfL309:BTP80LG5a0P1hN7P308:2PP80Ogmo0P29RHT3
08J6QP80T92@0P29RHT3096AT@80PH610P2<S8`30:RXZ080V9RH0P1CDe<30:NWY`80MGEe0P29RHT3
0:NWY`80Hf=S0P1cLg<307inOP80TY:B0P2NWYh306EUI@80>CTi0P2NWYh307UiN@80GUiN0P1:BTX3
0:b/[080MgMg0`1hN7P2061PH080K6a/0`1aLG4204Y:BP80I6AT0`28R8P209bLW080Kfm_0`1dM7@2
03Hf=P80YZJV0`28R8P208n?S`80_kno0`1aLG4209fMW@80UIFE0`1dM7@20:^[Z`80NWYj0`2h^;P2
07moO`80UiNG0`2[Zj/20;Ng]`80IVIV0`2MWId209>CT`80UiNG0`2][Jd208j>SP<0Shn?0P1fMWH2
06i^KP<0M7Ad0P25QHD208V9R@<0Jf][0P1`L70206][J`<0IVIV0P2c/k<20:6QX@<0alO70P2HV9P2
09:BTP<0[:b/0P2m_Kd50?ooo`7o000000001?l00000oooo0?ooo`3oool207QhN0<0PX:20P1oOgl2
08V9R@<0O7al0P1@D502018B4P<0K6a/0P22PX8201TI6@<0/;2`0P1]KFd209BDU0<0RXZ:0P1NGUh2
07inOP<0N7Qh0P1WIfL309:BTP80LG5a0P1hN7P308:2PP80Ogmo0P29RHT308J6QP80T92@0P29RHT3
096AT@80PH610P2<S8`30:RXZ080V9RH0P1CDe<30:NWY`80MGEe0P29RHT30:NWY`80Hf=S0P1cLg<3
07inOP80TY:B0P2NWYh306EUI@80>CTi0P2NWYh307UiN@80GUiN0P1:BTX30:b/[080MgMg0`1hN7P2
061PH080K6a/0`1aLG4204Y:BP80I6AT0`28R8P209bLW080Kfm_0`1dM7@203Hf=P80YZJV0`28R8P2
08n?S`80_kno0`1aLG4209fMW@80UIFE0`1dM7@20:^[Z`80NWYj0`2h^;P207moO`80UiNG0`2[Zj/2
0;Ng]`80IVIV0`2MWId209>CT`80UiNG0`2][Jd208j>SP<0Shn?0P1fMWH206i^KP<0M7Ad0P25QHD2
08V9R@<0Jf][0P1`L70206][J`<0IVIV0P2c/k<20:6QX@<0alO70P2HV9P209:BTP<0[:b/0P2m_Kd5
0?ooo`7o000000001?l00000oooo0?ooo`3oool207QhN0<0PX:20P1oOgl208V9R@<0O7al0P1@D502
018B4P<0K6a/0P22PX8201TI6@<0/;2`0P1]KFd209BDU0<0RXZ:0P1NGUh207inOP<0N7Qh0P1WIfL3
09:BTP80LG5a0P1hN7P308:2PP80Ogmo0P29RHT308J6QP80T92@0P29RHT3096AT@80PH610P2<S8`3
0:RXZ080V9RH0P1CDe<30:NWY`80MGEe0P29RHT30:NWY`80Hf=S0P1cLg<307inOP80TY:B0P2NWYh3
06EUI@80>CTi0P2NWYh307UiN@80GUiN0P1:BTX30:b/[080MgMg0`1hN7P2061PH080K6a/0`1aLG42
04Y:BP80I6AT0`28R8P209bLW080Kfm_0`1dM7@203Hf=P80YZJV0`28R8P208n?S`80_kno0`1aLG42
09fMW@80UIFE0`1dM7@20:^[Z`80NWYj0`2h^;P207moO`80UiNG0`2[Zj/20;Ng]`80IVIV0`2MWId2
09>CT`80UiNG0`2][Jd208j>SP<0Shn?0P1fMWH206i^KP<0M7Ad0P25QHD208V9R@<0Jf][0P1`L702
06][J`<0IVIV0P2c/k<20:6QX@<0alO70P2HV9P209:BTP<0[:b/0P2m_Kd50?ooo`7o000000001?l0
0000oooo0?ooo`3oool208:2PP<0O7al0P2JVYX207IfMP<0C4a<0P1oOgl206IVIP<0T92@0P1mOGd2
0:^[Z`<0Hf=S0P1RHV8207UiN@<0/;2`0P3Bd]8206m_K`<0NGUi0P1eMGD308b<S080O7al0P2CTi<3
07QhN080Ogmo0P1eMGD308:2PP80T92@0P2NWYh308j>SP80Lg=c0P2UYJD309jNWP80KFe]0P1HF5P3
07QhN080XJ6Q0P2_[jl303dm?@80W9bL0P1LG5`309NGU`80ADE50P1RHV830<71`@80PX:20P1QHF43
0410@080/K6a0P0m?Cd307AdM080YjNW0`2@T90209RHV080Rh^;0`1`L70204m?C`80IfMW0`2<S8`2
09fMW@80GEeM0`33`l<209ZJVP80Lg=c0`18B4P208Z:RP80KFe]0`2QXJ4209BDU080UiNG0`2g]kL2
06a/K080OWin0`2GUiL20:2PX080UiNG0`2:RXX2059BDP80Rh^;0`19BDT207=cL`80RHV90`1oOgl2
08V9R@<0O7al0P29RHT2075aL@<0KVi^101aLG4308J6QP80KVi^0P1nOWh306IVIP80H61P0P2CTi<3
08N7Q`80[Zj^0P1lO7`309FEU@80Ph>31@3oool1o`00000000Co00000?ooo`3oool0oooo0P22PX83
07alO080VYZJ0P1fMWH304a<C080Ogmo0P1VIVH3092@T080OGem0P2[Zj/306=SH`80HV9R0P1iNGT3
0;2`/080d];B0P1_Kfl307UiN@80MGEe0`2<S8`207alO080Ti>C0`1hN7P207moO`80MGEe0`22PX82
092@T080WYjN0`2>SXh207=cL`80YJFU0`2NWYh206e]K@80F5QH0`1hN7P20:6QX@80[jn_0`0m?Cd2
09bLW080G5aL0`2GUiL204E5A@80HV9R0`31`L4208:2PP80HF5Q0`10@4020;6a/@80?Cdm0`1dM7@2
0:NWY`<0T92@0P2HV9P208^;R`<0L71`0P1?Cdl206MWI`<0S8b<0P2MWId205eMG@<0`l?30P2JVYX2
07=cL`<0B4Q80P2:RXX206e]K@<0XJ6Q0P2DU9@209NGU`<0]kNg0P1/K6`207inOP<0UiNG0P2PX:02
09NGU`<0RXZ:0P1BDU8208^;R`<0BDU90P1cLg<208V9R@<0Ogmo0P29RHT307alO080RHV90P1aLG43
06i^KP@0LG5a0`26QXH206i^KP80OWin0`1VIVH2061PH080Ti>C0`27QhL20:j^[P80O7al0`2EUID2
08>3P`D0oooo0Ol000000004o`00003oool0oooo0?ooo`80PX:20`29RHT207alO080/K6a0`1^KVh2
06MWI`80MWIf0`2EUID2055AD@80EeMG0`2ATI420=gMg@80MgMg0`1ZJVX207=cL`80_[jn0`1mOGd2
09BDU0<0Fe]K0P28R8P206][J`<0QXJ60P29RHT208J6QP<0PX:20P1mOGd207moO`<0O7al0P2_[jl2
0<k>cP<0H61P0P1QHF420:^[Z`<0Xj>S0P1iNGT207alO0<0T92@0P2XZ:P206EUI@<0IfMW0P1EEED2
07alO0D0LG5a0P1[Jf/309:BTP80MGEe0P25QHD309:BTP80QXJ60`25QHD20:6QX@80c/k>0`16ATH2
09VIV@80Kfm_0`2a/K4205iNGP80M7Ad0`1jNWX209>CT`80J6QX0`25QHD206MWI`80Ph>30`1cLg<2
07emO@80Rh^;0`1lO7`208J6QP80QhN70`1GEeL207inOP80MWIf0`1KFe/20:NWY`80RXZ:0`29RHT2
06QXJ080TY:B0`2;Rh/2096AT@<0KFe]0P22PX8208V9R@<0O7al101oOgl307EeM@80PX:20P1eMGD3
075aL@80H61P0P0Z:RX30861P@80Ogmo0P39bLT30:6QX@80TI6A1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P22PX8308V9R@80O7al0P2a/K4306i^KP80IfMW0P1fMWH309FEU@80DE5A0P1GEeL3
096AT@80gMgM0P1gMgL306YZJP80Lg=c0P2n_[h307emO@80U9BD0`1KFe/208R8R080Jf][0`26QXH2
08V9R@80QXJ60`22PX8207emO@80Ogmo0`1lO7`20:n_[`80c/k>0`1PH602065QH@80Zj^[0`2SXj<2
07UiN@80O7al0`2@T9020:RXZ080IFEU0`1WIfL205EEE@80O7al1@1aLG4206][J`<0TY:B0P1eMGD2
08F5Q@<0TY:B0P26QXH308F5Q@80XJ6Q0P3>c/h304I6AP80VIVI0P1_Kfl30;6a/@80GUiN0P1dM7@3
07YjNP80Ti>C0P1XJ6P308F5Q@80IfMW0P23Ph<307=cL`80OGem0P2;Rh/307alO080QXJ60P27QhL3
05MGE`80OWin0P1fMWH305]KF`80YjNW0P2:RXX308V9R@80J6QX0P2BTY8308^;R`80TI6A0`1]KFd2
08:2PP80RHV90`1lO7`407moO`<0MGEe0P22PX8207EeM@<0LG5a0P1PH60202XZ:P<0PH610P1oOgl2
0<W9b@<0XJ6Q0P2ATI450?ooo`7o000000001?l00000oooo0?ooo`3oool208:2PP<0RHV90P1lO7`2
0;6a/@<0KVi^0P1WIfL207IfMP<0UIFE0P1ADE4205MGE`<0TI6A0P3MgMd207MgM`<0JVYZ0P1cLg<2
0;jn_P<0OGem0P2DU9@305]KF`80R8R80P1[Jf/308J6QP80RHV90P26QXH308:2PP80OGem0P1oOgl3
07alO080[jn_0P3>c/h3061PH080HF5Q0P2[Zj/30:>SX`80NGUi0P1lO7`3092@T080Z:RX0P1UIFD3
06MWI`80EEEE0P1lO7`5075aL@80Jf][0`2BTY8207EeM@80QHF50`2BTY8208J6QP<0QHF50P2QXJ42
0<k>cP<0ATI60P2IVIT206m_K`<0/K6a0P1NGUh207AdM0<0NWYj0P2CTi<206QXJ0<0QHF50P1WIfL2
08>3P`<0Lg=c0P1mOGd208^;R`<0O7al0P26QXH208N7Q`<0EeMG0P1nOWh207IfMP<0Fe]K0P2WYjL2
08Z:RP<0RHV90P1XJ6P209:BTP<0Rh^;0P2ATI4306e]K@80PX:20P29RHT307alO0@0Ogmo0`1eMGD2
08:2PP80MGEe0`1aLG42061PH080:RXZ0`21PH4207moO`80bLW90`2QXJ42096AT@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80RHV90`26QXH209NGU`80SXj>0`2IVIT207YjNP80K6a/0`1]KFd2
0:RXZ080ZZZZ0`21PH4207moO`80IFEU0`1_Kfl2069RHP80G5aL0`2ZZZX208N7Q`D0RXZ:0P2DU9@3
08N7Q`80Ph>30P2<S8`309BDU080WYjN0P1oOgl307inOP80hn?S0P1WIfL305eMG@80S8b<0P3?cll3
09fMW@80`l?30P2ATI430:n_[`80L71`0P1_Kfl303Hf=P80[Jf]0P29RHT305ADE080UIFE0P092@T3
08Z:RP80IVIV0P20P80305eMG@80YZJV0`2ATI4207UiN@80fMWI0`2[Zj/207inOP80MgMg0`1TI6@2
04m?C`80QHF50`1fMWH206EUI@80;Rh^0`3<c<`204=3@`80HV9R0`2>SXh207QhN080QHF50`2BTY82
09ZJVP80M7Ad0`2<S8`20861P@80Kfm_0`1XJ6P206IVIP80Kfm_0`2d];@208R8R080L71`0`28R8P2
09BDU0<0TY:B0P27QhL207UiN@D0Ogmo0P29RHT307alO080Ogmo0P1eMGD307QhN080O7al0P1`L703
030`<080E5AD0P0[:b/305EEE@80M7Ad1@3oool1o`00000000Co00000?ooo`3oool0oooo0P29RHT3
08J6QP80UiNG0P2>SXh309VIV@80NWYj0P1/K6`306e]K@80Z:RX0P2ZZZX30861P@80Ogmo0P1UIFD3
06m_K`80HV9R0P1LG5`30:ZZZP80QhN71@2:RXX209BDU0<0QhN70P23Ph<208b<S0<0U9BD0P2NWYh2
07moO`<0OWin0P3Shn<206MWI`<0GEeM0P2<S8`20<o?c`<0WIfM0P33`l<2096AT@<0[jn_0P1`L702
06m_K`<0=SHf0P2][Jd208V9R@<0E5AD0P2EUID200T92@<0RXZ:0P1VIVH20820P0<0GEeM0P2VYZH3
096AT@80NGUi0P3IfMT30:^[Z`80OWin0P1gMgL306ATI080Cdm?0P25QHD307IfMP80IFEU0P0^;Rh3
0<c<c080@d=30P1RHV8308j>SP80N7Qh0P25QHD309:BTP80VYZJ0P1dM7@308b<S080PH610P1_Kfl3
06QXJ080IVIV0P1_Kfl30;Bd]080R8R80P1`L70308R8R080U9BD0`2BTY8208N7Q`80NGUi1@1oOgl2
08V9R@<0O7al0P1oOgl207EeM@<0N7Qh0P1lO7`2071`L0<0<30`0P1DE5@202/[:`<0EEEE0P1dM7@5
0?ooo`7o000000001?l00000oooo0?ooo`3oool208V9R@<0O7al0P1TI6@204E5A@<0OWin0P1_Kfl2
07emO@<0HF5Q0P1XJ6P207IfMP<0N7Qh0P1fMWH20;>c/`<0Ph>30P1hN7P206i^KP<0Cdm?0P1fMWH3
07MgM`80OWin0P1`L70307AdM080QHF50P2l_;`30=?Cd`80^[Zj0P2LW9`30>7Qh@8061PH0P1ADE43
09:BTP80dM7A0P2JVYX308^;R`80QXJ60P3AdM4301@D5080Rh^;0P3>c/h30:ZZZP80SXj>0P1cLg<3
07QhN080Shn?0P2IVIT307EeM@80LG5a0P23Ph<3065QH@80GEeM0`1RHV820:FUY@80_[jn1@26QXH2
09BDU0<0P8200P12@T82061PH0<0GEeM0P1@D502069RHP<0IfMW0P2JVYX20451@@<0H61P0P1lO7`2
07moO`<0MgMg0P29RHT20:RXZ0<0^[Zj0P2EUID20820P0<0QhN70P1`L702075aL@<0OWin0P2IVIT2
08n?S`<0L71`0P1dM7@308j>SP80YjNW0P21PH4308>3P`80O7al0P1eMGD507QhN080S8b<0`1aLG42
08:2PP80QXJ60`1cLg<204U9B@80FEUI0`1dM7@202/[:`D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80RHV90`1lO7`206ATI080ADE50`1nOWh206m_K`80OGem0`1QHF4206QXJ080MWIf0`1hN7P2
07IfMP80/k>c0`23Ph<207QhN080KVi^0`1?Cdl207IfMP<0MgMg0P1nOWh2071`L0<0M7Ad0P25QHD2
0;bl_0<0dm?C0P2j^[X209bLW0<0hN7Q0P0H61P2055AD@<0TY:B0P3AdM4209ZJVP<0Rh^;0P26QXH2
0=7Ad@<051@D0P2;Rh/20<k>cP<0ZZZZ0P2>SXh207=cL`<0N7Qh0P2?Shl209VIV@<0MGEe0P1aLG42
08>3P`<0HF5Q0P1MGEd3069RHP80YJFU0P2n_[h508J6QP80U9BD0`20P8020492@P80H61P0`1MGEd2
051@D080HV9R0`1WIfL209ZJVP80@D510`1PH60207alO080Ogmo0`1gMgL208V9R@80Z:RX0`2j^[X2
09FEU@80P8200`27QhL2071`L080LG5a0`1nOWh209VIV@80Shn?0`1`L70207AdM0<0SXj>0P2WYjL2
0861P@<0Ph>30P1lO7`207EeM@D0N7Qh0P2<S8`3075aL@80PX:20P26QXH307=cL`80BDU90P1IFET3
07AdM080:b/[1@3oool1o`00000000Co00000?ooo`3oool0oooo0P29RHT307alO080I6AT0P15ADD3
07inOP80Kfm_0P1mOGd3065QH@80J6QX0P1fMWH307QhN080MWIf0P2c/k<308>3P`80N7Qh0P1^KVh3
04m?C`80MWIf0`1gMgL207inOP80L71`0`1dM7@208F5Q@80_;bl0`3Cdm<20;Zj^P80W9bL0`3QhN42
01PH6080DE5A0`2BTY820=7Ad@80VYZJ0`2;Rh/208J6QP80dM7A0`0D51@208^;R`80c/k>0`2ZZZX2
08j>SP80Lg=c0`1hN7P208n?S`80VIVI0`1eMGD2075aL@80Ph>30`1QHF4205eMG@<0HV9R0P2UYJD2
0;jn_PD0QXJ60P2DU9@30820P080@T920P1PH60305eMG@80D51@0P1RHV8306MWI`80VYZJ0P11@D43
061PH080O7al0P1oOgl307MgM`80RHV90P2XZ:P30;Zj^P80UIFE0P20P80308N7Q`80L71`0P1aLG43
07inOP80VIVI0P2?Shl3071`L080M7Ad0`2>SXh20:NWY`80PH610`23Ph<207alO080MGEe1@1hN7P2
08b<S0<0LG5a0P22PX8208J6QP<0Lg=c0P19BDT205UIF@<0M7Ad0P0[:b/50?ooo`7o000000001?l0
0000oooo0?ooo`3oool206][J`<0O7al0P2WYjL20>o_k`<0OWin0P29RHT209:BTP<0][Jf0P2SXj<2
096AT@<0YJFU0P29RHT20::RXP<0L71`0P1eMGD20:^[Z`<0S8b<0P20P80308b<S080NGUi0P1oOgl3
08V9R@80UiNG1@33`l<2059BDP80Fe]K0`0G5aL209FEU@80ZZZZ0`2m_Kd206YZJP80]kNg0`2c/k<2
092@T080XJ6Q0`2m_Kd207=cL`80OWin0`2BTY8204a<C080IFEU0`1hN7P205eMG@80UiNG0`1lO7`2
08J6QP80XZ:R0`2XZ:P204E5A@<0Ti>C0P23Ph<201hN7P<0U9BD0P1aLG420;Zj^P<0YZJV0P2ATI42
04i>CP<0DU9B0P2;Rh/209bLW0<0F5QH0P1TI6@209bLW0<0TI6A0P1PH60207=cL`<0D51@0P2DU9@2
0;Bd]0<0G5aL0P1SHf<209BDU0<0QXJ60P2<S8`5069RHP80KFe]0P22PX83071`L080ZZZZ0`1cLg<2
092@T080SXj>0`29RHT207UiN@80Ogmo0`29RHT208J6QP80O7al0`29RHT2075aL@80O7al1@1`L702
07moO`<0L71`0P2?Shl50?ooo`7o000000001?l00000oooo0?ooo`3oool206][J`<0O7al0P2WYjL2
0>o_k`<0OWin0P29RHT209:BTP<0][Jf0P2SXj<2096AT@<0YJFU0P29RHT20::RXP<0L71`0P1eMGD2
0:^[Z`<0S8b<0P20P80308b<S080NGUi0P1oOgl308V9R@80UiNG1@33`l<2059BDP80Fe]K0`0G5aL2
09FEU@80ZZZZ0`2m_Kd206YZJP80]kNg0`2c/k<2092@T080XJ6Q0`2m_Kd207=cL`80OWin0`2BTY82
04a<C080IFEU0`1hN7P205eMG@80UiNG0`1lO7`208J6QP80XZ:R0`2XZ:P204E5A@<0Ti>C0P23Ph<2
01hN7P<0U9BD0P1aLG420;Zj^P<0YZJV0P2ATI4204i>CP<0DU9B0P2;Rh/209bLW0<0F5QH0P1TI6@2
09bLW0<0TI6A0P1PH60207=cL`<0D51@0P2DU9@20;Bd]0<0G5aL0P1SHf<209BDU0<0QXJ60P2<S8`5
069RHP80KFe]0P22PX83071`L080ZZZZ0`1cLg<2092@T080SXj>0`29RHT207UiN@80Ogmo0`29RHT2
08J6QP80O7al0`29RHT2075aL@80O7al1@1`L70207moO`<0L71`0P2?Shl50?ooo`7o000000001?l0
0000oooo0?ooo`3oool208:2PP<0RHV90P1aLG4208V9R@<0Ph>30P1fMWH20861P@<0HF5Q0P2WYjL2
08V9R@<0FUYJ0P16ATH202XZ:P<0Cdm?0P2DU9@206YZJP<0MWIf0P1dM7@307YjNP80RHV90P1mOGd3
092@T080f=SH0P2EUID304m?C`80D51@0P1IFET307MgM`80/;2`0P26QXH30<K6aP80][Jf0P1oOgl3
08>3P`80W9bL0P1IFET308R8R080I6AT0P28R8P307moO`@0Jf][0`2;Rh/202d];@80Ogmo0`28R8P2
09>CT`80RHV90`2ATI420:>SX`<0L71`0P1CDe<203Ti>@<0[jn_0P29RHT20820P0<0E5AD0P1WIfL2
0861P@<0RHV90P1mOGd207QhN0D0NWYj0P1`L70308n?S`80Jf][0P2IVIT309>CT`80GUiN0P27QhL3
0;Fe]@80KFe]0P29RHT309ZJVP@0RHV90`1RHV8207emO@80N7Qh0`2^[Zh206=SH`<0/k>c0P1NGUh2
08F5Q@<0Ti>C0P22PX82075aL@h0N7Qh0`2CTi<209BDU080V9RH0`25QHD206m_K`D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80PX:20`29RHT2075aL@80RHV90`23Ph<207IfMP80PH610`1QHF42
0:NWY`80RHV90`1JFUX204I6AP80:RXZ0`1?Cdl209BDU080JVYZ0`1fMWH207AdM0<0NWYj0P29RHT2
07emO@<0T92@0P3Hf=P209FEU@<0Cdm?0P1@D50205UIF@<0MgMg0P2`/;0208J6QP<0a/K60P2f][H2
07moO`<0Ph>30P2LW9`205UIF@<0R8R80P1TI6@208R8R0<0Ogmo101[Jf/308^;R`80;Bd]0P1oOgl3
08R8R080Ti>C0P29RHT3096AT@80Xj>S0`1`L70205=CD`80>CTi0`2_[jl208V9R@80P8200`1DE5@2
06MWI`80PH610`29RHT207emO@80N7Qh1@1jNWX2071`L0<0Shn?0P1[Jf/209VIV@<0Ti>C0P1NGUh2
08N7Q`<0]KFe0P1]KFd208V9R@<0VYZJ1029RHT3069RHP80OGem0P1hN7P30:j^[P80Hf=S0`2c/k<2
05iNGP80QHF50`2CTi<208:2PP80LG5a3P1hN7P309>CT`80U9BD0P2HV9P308F5Q@80Kfm_1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P22PX8308V9R@80LG5a0P29RHT308>3P`80MWIf0P21PH43
065QH@80YjNW0P29RHT305YJFP80ATI60P0Z:RX304m?C`80U9BD0P1ZJVX307IfMP80M7Ad0`1jNWX2
08V9R@80OGem0`2@T9020=SHf080UIFE0`1?Cdl2051@D080FEUI0`1gMgL20;2`/080QXJ60`36a/H2
0;Jf]P80Ogmo0`23Ph<209bLW080FEUI0`28R8P206ATI080R8R80`1oOgl406][J`<0Rh^;0P0];Bd2
07moO`<0R8R80P2CTi<208V9R@<0TI6A0P2SXj<3071`L080De=C0P0i>CT30:n_[`80RHV90P20P803
05ADE080IfMW0P21PH4308V9R@80OGem0P1hN7P507YjNP80L71`0`2?Shl206][J`80VIVI0`2CTi<2
05iNGP80QhN70`2e]KD206e]K@80RHV90`2JVYX408V9R@<0HV9R0P1mOGd207QhN0<0[Zj^0P1SHf<3
0;>c/`80GUiN0P25QHD309>CT`80PX:20P1aLG4>07QhN0<0Ti>C0P2DU9@209RHV0<0QHF50P1_Kfl5
0?ooo`7o000000001?l00000oooo0?ooo`3oool208J6QP<0S8b<0P3clo<203De=@<0RXZ:0P1^KVh2
07AdM0<0QHF50P1eMGD208V9R@D0e=CD0P2EUID30:^[Z`80L71`0P1cLg<308:2PP80Ogmo0`1^KVh2
08F5Q@80VYZJ0`3:b/X20:JVYP80=SHf0`16ATH20:FUY@80Rh^;0`3De=@206MWI`80HV9R0`2?Shl2
0:b/[080MWIf0`1DE5@206i^KP80S8b<0`1dM7@208b<S080?clo0`1QHF4208V9R@80Rh^;0`1aLG42
06i^KP80XJ6Q0`27QhL20:n_[`80ZZZZ0`2QXJ420;Bd]0<0O7al0P19BDT20:2PX0<0J6QX0P2SXj<2
06MWI`<0HV9R0P2_[jl206a/K0<0PH610P2GUiL209:BTP<08R8R0P2KVi/2092@T0<0GUiN0P2VYZH2
05MGE`<0BDU90P2NWYh208V9R@<0R8R80P2VYZH206e]K@<0alO70P22PX820::RXP<0YZJV0P2j^[X2
07IfMP<0E5AD0P2`/;0308Z:RP80R8R80P20P80308>3P`80Lg=c0P22PX8307moO`80MGEe0P22PX83
08V9R@80T92@0P29RHT309jNWP80Lg=c0P1MGEd30820P080WIfM1@3oool1o`00000000Co00000?oo
o`3oool0oooo0P26QXH308b<S080lo?c0P0e=CD308Z:RP80KVi^0P1dM7@308F5Q@80MGEe0P29RHT5
0=CDe080UIFE0`2[Zj/2071`L080Lg=c0`22PX8207moO`<0KVi^0P25QHD209ZJVP<0b/[:0P2VYZH2
03Hf=P<0ATI60P2UYJD208^;R`<0e=CD0P1WIfL2069RHP<0Shn?0P2/[:`207IfMP<0E5AD0P1^KVh2
08b<S0<0M7Ad0P2<S8`203lo?`<0HF5Q0P29RHT208^;R`<0LG5a0P1^KVh20:6QX@<0QhN70P2_[jl2
0:ZZZP<0XJ6Q0P2d];@307alO080BDU90P2PX:0306QXJ080Xj>S0P1WIfL3069RHP80[jn_0P1/K6`3
0861P@80UiNG0P2BTY83028R8P80Vi^K0P2@T90305iNGP80YZJV0P1GEeL304U9B@80WYjN0P29RHT3
08R8R080YZJV0P1]KFd30<O7a`80PX:20P2RXZ830:JVYP80^[Zj0P1fMWH305ADE080/;2`0`2:RXX2
08R8R080P8200`23Ph<207=cL`80PX:20`1oOgl207EeM@80PX:20`29RHT2092@T080RHV90`2NWYh2
07=cL`80GEeM0`20P80209fMW@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80Jf][0`1lO7`2
0;Fe]@80GEeM0`1;Bd/20:ZZZP80R8R80`2RXZ8407alO0<0?3`l0P0d=3@207AdM0<0Kfm_0P1QHF42
08b<S0<0MGEe0P29RHT308N7Q`80O7al0P3hn?P308J6QP80@d=30P2f][H308b<S080SXj>0P2PX:03
09>CT`80W9bL0P3GemL309>CT`80TY:B0P2ATI4309fMW@80N7Qh1@1_Kfl203Ph>080EEEE0`1PH602
09^KV`80RHV90`2?Shl205=CD`80VIVI0`25QHD206ATI080IFEU0`2DU9@206MWI`<0Y:BT0P1hN7P2
059BDP<0U9BD0P1HF5P20:>SX`<0H61P0P1mOGd208V9R@<0Vi^K0P1GEeL206][J`<0_kno0P1jNWX2
07MgM`<0Fe]K0P25QHD204m?C`<0d=3@0P1`L70208j>SP<0IFEU0P2QXJ4208j>SP<0YZJV0P2>SXh2
09ZJVP<0[jn_0P2<S8`20<S8b0<0Rh^;0P1aLG430<K6aP80S8b<0P2>SXh30:RXZ080Ti>C0P27QhL3
08:2PP80T92@0P1hN7P307EeM@80N7Qh0P1lO7`306IVIP80MgMg0P2;Rh/305]KF`80TI6A1@3oool1
o`00000000Co00000?ooo`3oool0oooo0P1[Jf/307alO080]KFe0P1MGEd304];B`80ZZZZ0P28R8P3
0::RXP@0O7al0`0l?3`203@d=080M7Ad0`1_Kfl2065QH@80S8b<0`1eMGD208V9R@<0QhN70P1lO7`2
0?Shn0<0QXJ60P13@d<20;Jf]P<0S8b<0P2>SXh20:2PX0<0Ti>C0P2LW9`20=OGe`<0Ti>C0P2BTY82
096AT@<0WIfM0P1hN7P506m_K`80>3Ph0P1EEED3061PH080Vi^K0P29RHT308n?S`80De=C0P2IVIT3
08F5Q@80I6AT0P1UIFD309BDU080IfMW0`2TY:@207QhN080DU9B0`2DU9@205QHF080Xj>S0`1PH602
07emO@80RHV90`2KVi/205MGE`80Jf][0`2o_kl207YjNP80MgMg0`1KFe/208F5Q@80Cdm?0`3@d=02
071`L080SXj>0`1UIFD20:6QX@80SXj>0`2VYZH208j>SP80VYZJ0`2_[jl208b<S080b<S80`2;Rh/2
075aL@<0a/K60P2<S8`208j>SP<0Z:RX0P2CTi<208N7Q`<0PX:20P2@T90207QhN0<0MGEe0P1hN7P2
07alO0<0IVIV0P1gMgL208^;R`<0Fe]K0P2ATI450?ooo`7o000000001?l00000oooo0?ooo`3oool2
06][J`<0O7al0P2e]KD205eMG@<0Bd];0P2ZZZX208R8R0<0XZ:R101lO7`303`l?080=3@d0P1dM7@3
06m_K`80HF5Q0P2<S8`307EeM@80RHV90`27QhL207alO080n?Sh0`26QXH204=3@`80][Jf0`2<S8`2
08j>SP80X:2P0`2CTi<209bLW080emOG0`2CTi<209:BTP80TI6A0`2MWId207QhN0D0Kfm_0P0h>3P2
05EEE@<0H61P0P2KVi/208V9R@<0Shn?0P1CDe<209VIV@<0QHF50P1TI6@206EUI@<0U9BD0P1WIfL3
0:BTY080N7Qh0P1BDU8309BDU080F5QH0P2SXj<3061PH080OGem0P29RHT309^KV`80EeMG0P1[Jf/3
0;no_`80NWYj0P1gMgL305]KF`80QHF50P1?Cdl30=3@d080L71`0P2>SXh306EUI@80XJ6Q0P2>SXh3
0:JVYP80SXj>0P2JVYX30:n_[`80S8b<0P38b<P308^;R`80LG5a0`36a/H208b<S080SXj>0`2XZ:P2
09>CT`80QhN70`22PX82092@T080N7Qh0`1eMGD207QhN080O7al0`1VIVH207MgM`80Rh^;0`1KFe/2
096AT@D0oooo0Ol000000004o`00003oool0oooo0?ooo`80Ti>C0`2MWId20410@080?clo0`2e]KD2
0820P080/K6a0`2BTY8209jNWP80OWin0`2EUID207emO@80MWIf0`15ADD209>CT`80GEeM0`23Ph<2
0861P@<0T92@0P3oool2065QH@<0P8200P2c/k<207inOP<0Ph>30P2JVYX20;no_`<0ZZZZ0P2HV9P2
08Z:RP<0YJFU0P1cLg<206e]K@<0VIVI0P2GUiL2092@T0<0NGUi0P1dM7@208b<S0<0QXJ60P2WYjL2
07MgM`<0HV9R0P2;Rh/204];B`<0S8b<0P2XZ:P207alO0<0bLW90P2ATI4308^;R`80_Kfm0P1^KVh3
05iNGP80RHV90P2@T903096AT@80ZZZZ0P26QXH3059BDP80ZZZZ0P2GUiL307AdM080LG5a0P1RHV83
0820P080?3`l0P29RHT305]KF`80RHV90P0i>CT306MWI`80H61P0P25QHD306][J`80U9BD0P2d];@3
09^KV`80XZ:R0P2CTi<309jNWP80JVYZ0`18B4P20>g]k@80T92@0`1NGUh20:2PX080P8200`1aLG42
07QhN080PX:20`29RHT207alO080MGEe0`1WIfL209:BTP80QXJ60`1eMGD205UIF@D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80Ti>C0`2MWId20410@080?clo0`2e]KD20820P080/K6a0`2BTY82
09jNWP80OWin0`2EUID207emO@80MWIf0`15ADD209>CT`80GEeM0`23Ph<20861P@<0T92@0P3oool2
065QH@<0P8200P2c/k<207inOP<0Ph>30P2JVYX20;no_`<0ZZZZ0P2HV9P208Z:RP<0YJFU0P1cLg<2
06e]K@<0VIVI0P2GUiL2092@T0<0NGUi0P1dM7@208b<S0<0QXJ60P2WYjL207MgM`<0HV9R0P2;Rh/2
04];B`<0S8b<0P2XZ:P207alO0<0bLW90P2ATI4308^;R`80_Kfm0P1^KVh305iNGP80RHV90P2@T903
096AT@80ZZZZ0P26QXH3059BDP80ZZZZ0P2GUiL307AdM080LG5a0P1RHV830820P080?3`l0P29RHT3
05]KF`80RHV90P0i>CT306MWI`80H61P0P25QHD306][J`80U9BD0P2d];@309^KV`80XZ:R0P2CTi<3
09jNWP80JVYZ0`18B4P20>g]k@80T92@0`1NGUh20:2PX080P8200`1aLG4207QhN080PX:20`29RHT2
07alO080MGEe0`1WIfL209:BTP80QXJ60`1eMGD205UIF@D0oooo0Ol000000004o`00003oool0oooo
0?ooo`80RHV90`3@d=0200D51@80f=SH0`2_[jl209jNWP80UIFE0`1hN7P205QHF080JVYZ0`1UIFD2
09VIV@80JVYZ0`2?Shl206MWI`80QXJ60`1oOgl208V9R@<0k^k^0P1PH60206EUI@<0alO70P2VYZH2
06ATI0<0g=cL0P2JVYX20>;RhP<0Lg=c0P2HV9P209FEU@<0EEEE0P0h>3P2065QH@<0OWin0P2GUiL2
0<O7a`<0_Kfm0P1fMWH208b<S0<0QXJ60P1dM7@209:BTP<0J6QX0P1LG5`209>CT`<0K6a/0P1nOWh2
07MgM`<0D51@0P22PX8305ADE080ZZZZ0P1iNGT308F5Q@80Vi^K0P1JFUX3071`L080J6QX0P2QXJ43
061PH080TI6A0P1CDe<308:2PP80FUYJ0P1hN7P308J6QP80Ogmo0P1QHF4306][J`80QXJ60P2/[:`3
06e]K@80Ph>30P1dM7@307alO080W9bL0P2RXZ8307inOP80VIVI0P22PX8307YjNP80QXJ60`1RHV82
01DE5@80c/k>0`29RHT206e]K@80RHV90`27QhL207alO080Ogmo0`1eMGD208:2PP80Ogmo0`2@T902
06m_K`80IfMW0`1nOWh207QhN0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80RHV90`3@d=02
00D51@80f=SH0`2_[jl209jNWP80UIFE0`1hN7P205QHF080JVYZ0`1UIFD209VIV@80JVYZ0`2?Shl2
06MWI`80QXJ60`1oOgl208V9R@<0k^k^0P1PH60206EUI@<0alO70P2VYZH206ATI0<0g=cL0P2JVYX2
0>;RhP<0Lg=c0P2HV9P209FEU@<0EEEE0P0h>3P2065QH@<0OWin0P2GUiL20<O7a`<0_Kfm0P1fMWH2
08b<S0<0QXJ60P1dM7@209:BTP<0J6QX0P1LG5`209>CT`<0K6a/0P1nOWh207MgM`<0D51@0P22PX83
05ADE080ZZZZ0P1iNGT308F5Q@80Vi^K0P1JFUX3071`L080J6QX0P2QXJ43061PH080TI6A0P1CDe<3
08:2PP80FUYJ0P1hN7P308J6QP80Ogmo0P1QHF4306][J`80QXJ60P2/[:`306e]K@80Ph>30P1dM7@3
07alO080W9bL0P2RXZ8307inOP80VIVI0P22PX8307YjNP80QXJ60`1RHV8201DE5@80c/k>0`29RHT2
06e]K@80RHV90`27QhL207alO080Ogmo0`1eMGD208:2PP80Ogmo0`2@T90206m_K`80IfMW0`1nOWh2
07QhN0D0oooo0Ol000000004o`00003oool0oooo0?ooo`80RHV90`3@d=0200D51@80f=SH0`2_[jl2
09jNWP80UIFE0`1hN7P205QHF080JVYZ0`1UIFD209VIV@80JVYZ0`2?Shl206MWI`80QXJ60`1oOgl2
08V9R@<0k^k^0P1PH60206EUI@<0alO70P2VYZH206ATI0<0g=cL0P2JVYX20>;RhP<0Lg=c0P2HV9P2
09FEU@<0EEEE0P0h>3P2065QH@<0OWin0P2GUiL20<O7a`<0_Kfm0P1fMWH208b<S0<0QXJ60P1dM7@2
09:BTP<0J6QX0P1LG5`209>CT`<0K6a/0P1nOWh207MgM`<0D51@0P22PX8305ADE080ZZZZ0P1iNGT3
08F5Q@80Vi^K0P1JFUX3071`L080J6QX0P2QXJ43061PH080TI6A0P1CDe<308:2PP80FUYJ0P1hN7P3
08J6QP80Ogmo0P1QHF4306][J`80QXJ60P2/[:`306e]K@80Ph>30P1dM7@307alO080W9bL0P2RXZ83
07inOP80VIVI0P22PX8307YjNP80QXJ60`1RHV8201DE5@80c/k>0`29RHT206e]K@80RHV90`27QhL2
07alO080Ogmo0`1eMGD208:2PP80Ogmo0`2@T90206m_K`80IfMW0`1nOWh207QhN0D0oooo0Ol00000
0004o`00003oool0oooo0?ooo`80n?Sh0`1eMGD207alO080IFEU0`1cLg<208J6QP80I6AT0`21PH42
0:JVYP80IFEU0`1iNGT204I6AP80IfMW0`1iNGT207moO`80MgMg0`2o_kl20>CTi0<0PX:20P1VIVH2
0:j^[P<0R8R80P2BTY820:RXZ0<0UiNG0P3GemL209fMW@<0ZZZZ0P1BDU8207emO@<0LG5a0P2LW9`2
071`L0<0@D510P2RXZ8205UIF@<0][Jf0P2d];@208N7Q`<0De=C0P20P80208:2PP<0MGEe0P2[Zj/2
05YJFP<0OGem0P1QHF4207=cL`<0HV9R0P1VIVH306e]K@80>3Ph0P1oOgl307YjNP80TI6A0P1LG5`3
0:6QX@80Xj>S0P1gMgL30::RXP80?Cdm0P1_Kfl307IfMP80HF5Q0P1EEED307IfMP80Xj>S0P10@403
07emO@80QXJ60P2^[Zh30;>c/`80V9RH0P1iNGT304I6AP80[jn_0P1eMGD30=3@d080I6AT0P1oOgl3
09NGU`80KFe]0`2MWId207IfMP80?clo0`33`l<20<O7a`80OGem0`2ATI4208Z:RP80PX:20`26QXH2
07alO080T92@0`23Ph<208J6QP80UiNG0`2RXZ8206IVIPD0oooo0Ol000000004o`00003oool0oooo
0?ooo`80n?Sh0`1eMGD207alO080IFEU0`1cLg<208J6QP80I6AT0`21PH420:JVYP80IFEU0`1iNGT2
04I6AP80IfMW0`1iNGT207moO`80MgMg0`2o_kl20>CTi0<0PX:20P1VIVH20:j^[P<0R8R80P2BTY82
0:RXZ0<0UiNG0P3GemL209fMW@<0ZZZZ0P1BDU8207emO@<0LG5a0P2LW9`2071`L0<0@D510P2RXZ82
05UIF@<0][Jf0P2d];@208N7Q`<0De=C0P20P80208:2PP<0MGEe0P2[Zj/205YJFP<0OGem0P1QHF42
07=cL`<0HV9R0P1VIVH306e]K@80>3Ph0P1oOgl307YjNP80TI6A0P1LG5`30:6QX@80Xj>S0P1gMgL3
0::RXP80?Cdm0P1_Kfl307IfMP80HF5Q0P1EEED307IfMP80Xj>S0P10@40307emO@80QXJ60P2^[Zh3
0;>c/`80V9RH0P1iNGT304I6AP80[jn_0P1eMGD30=3@d080I6AT0P1oOgl309NGU`80KFe]0`2MWId2
07IfMP80?clo0`33`l<20<O7a`80OGem0`2ATI4208Z:RP80PX:20`26QXH207alO080T92@0`23Ph<2
08J6QP80UiNG0`2RXZ8206IVIPD0oooo0Ol000000003o`00003oool0oooo0>h0oooo0Ol000000003
o`00003oool0oooo0>h0oooo0Ol000000003o`00003oool0oooo0>h0oooo0Ol000000?;o00000000
\
\>"],
  ImageRangeCache->{{{0, 241.375}, {241.375, 0}} -> {-2.03389, -1.91063, \
0.427003, 0.401125}},
  CellTags->"T.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"T.6"]
}, Open  ]],

Cell["Here is a contour plot of the data.", "Commentary",
  CellTags->"T.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListContourPlot[data, ContourShading \[Rule] False, Contours \[Rule] 6, 
      FrameTicks \[Rule] None]\)], "Input",
  CellTags->"T.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00951826 0.00971251 0.00889165 0.0103391 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.72824 .41208 m
.7367 .41212 L
.72824 .41779 L
.7275 .41212 L
.72824 .41208 L
s
.36888 .4007 m
.37624 .40178 L
.36961 .41212 L
.36888 .41217 L
.36868 .41212 L
.36293 .40178 L
.36888 .4007 L
s
.54371 .2259 m
.544 .22601 L
.55342 .23356 L
.55613 .23635 L
.56313 .24444 L
.57284 .23913 L
.57876 .24669 L
.58256 .24987 L
.59227 .25683 L
.59241 .25703 L
.59393 .26737 L
.59346 .27771 L
.59227 .28415 L
.58959 .28805 L
.58256 .28848 L
.57703 .29839 L
.57311 .30873 L
.57284 .30905 L
.56313 .3188 L
.55342 .31127 L
.55171 .30873 L
.55031 .29839 L
.54913 .28805 L
.54371 .28054 L
.53399 .27999 L
.52428 .28597 L
.52315 .28805 L
.51981 .29839 L
.51457 .30591 L
.50486 .30163 L
.50272 .29839 L
.49992 .28805 L
.49514 .28432 L
.49162 .27771 L
.49369 .26737 L
.49514 .25879 L
.49542 .25703 L
.50026 .24669 L
.50486 .24052 L
.51457 .23918 L
.52242 .23635 L
.52428 .23323 L
.53399 .23114 L
.54317 .22601 L
.54371 .2259 L
s
.63112 .20265 m
.63513 .20533 L
.63112 .20892 L
.62825 .20533 L
.63112 .20265 L
s
.41744 .19432 m
.41764 .195 L
.41744 .20089 L
.40963 .195 L
.41744 .19432 L
s
.44658 .16638 m
.45083 .17432 L
.44957 .18466 L
.45629 .19455 L
.45687 .195 L
.46345 .20533 L
.45629 .20914 L
.45297 .21567 L
.44658 .22335 L
.43927 .21567 L
.44064 .20533 L
.4462 .195 L
.44438 .18466 L
.44055 .17432 L
.44658 .16638 L
s
.45629 .15697 m
.45883 .16398 L
.45629 .16663 L
.4486 .16398 L
.45629 .15697 L
s
.48543 .10928 m
.49514 .10277 L
.50145 .11228 L
.49514 .11824 L
.48543 .12109 L
.48324 .11228 L
.48543 .10928 L
s
.50486 .09661 m
.51457 .09945 L
.5147 .10194 L
.51457 .10201 L
.50486 .10993 L
.49575 .10194 L
.50486 .09661 L
s
.46601 .65909 m
.46706 .66026 L
.46922 .6706 L
.46601 .67496 L
.4573 .6706 L
.45686 .66026 L
.46601 .65909 L
s
.77681 .4212 m
.77964 .42246 L
.78652 .42823 L
.7944 .4328 L
.79623 .43487 L
.80273 .44313 L
.79623 .44419 L
.79379 .44313 L
.78652 .43778 L
.78207 .4328 L
.77681 .42797 L
.76893 .42246 L
.77681 .4212 L
s
.71853 .41124 m
.72824 .4094 L
.73796 .4095 L
.74767 .41187 L
.74875 .41212 L
.74767 .41535 L
.73796 .4203 L
.73254 .42246 L
.72824 .42628 L
.71853 .43053 L
.70956 .42246 L
.71545 .41212 L
.71853 .41124 L
s
.35917 .39931 m
.36888 .3982 L
.37859 .40016 L
.38281 .40178 L
.37859 .41077 L
.37726 .41212 L
.36888 .41607 L
.36218 .41212 L
.35917 .40874 L
.3574 .40178 L
.35917 .39931 L
s
.33003 .34555 m
.33863 .35008 L
.33208 .36042 L
.33003 .36165 L
.32032 .36402 L
.31545 .37076 L
.31061 .37613 L
.30423 .3811 L
.30089 .38544 L
.29232 .39144 L
.29118 .39234 L
.28192 .40178 L
.28147 .40251 L
.27237 .41212 L
.27176 .41306 L
.26354 .41212 L
.2684 .40178 L
.27176 .39911 L
.27753 .39144 L
.27661 .3811 L
.28147 .37379 L
.28781 .37076 L
.29118 .36947 L
.29727 .36042 L
.30089 .35882 L
.31061 .35738 L
.32032 .35626 L
.32454 .35008 L
.33003 .34555 L
s
.35917 .32371 m
.36877 .3294 L
.36888 .32946 L
.37859 .33408 L
.38831 .33302 L
.3946 .33974 L
.39688 .35008 L
.38831 .35791 L
.37859 .35716 L
.36888 .35837 L
.35917 .35641 L
.34946 .35551 L
.3453 .35008 L
.33974 .3474 L
.33826 .33974 L
.33974 .33563 L
.34946 .33811 L
.354 .3294 L
.35917 .32371 L
s
.68939 .2535 m
.69911 .25664 L
.70026 .25703 L
.69911 .26317 L
.68939 .26224 L
.68504 .25703 L
.68939 .2535 L
s
.40773 .24095 m
.40904 .24669 L
.40899 .25703 L
.41744 .26524 L
.42261 .26737 L
.42255 .27771 L
.41744 .28007 L
.41052 .28805 L
.40773 .28913 L
.39904 .29839 L
.39802 .30161 L
.39167 .29839 L
.38831 .29666 L
.37859 .29471 L
.37126 .28805 L
.37528 .27771 L
.37859 .27339 L
.38831 .26944 L
.39802 .27395 L
.40773 .2697 L
.40897 .26737 L
.40773 .26224 L
.39802 .2584 L
.39582 .25703 L
.39802 .24779 L
.39955 .24669 L
.40773 .24095 L
s
.66997 .23332 m
.67779 .23635 L
.66997 .23815 L
.66801 .23635 L
.66997 .23332 L
s
.51457 .2114 m
.52428 .2099 L
.53013 .21567 L
.53399 .21855 L
.54371 .21716 L
.54966 .21567 L
.55342 .21293 L
.55734 .21567 L
.56271 .22601 L
.56313 .22629 L
.57284 .22612 L
.58256 .22815 L
.58917 .23635 L
.59227 .24407 L
.59456 .24669 L
.59905 .25703 L
.60087 .26737 L
.60009 .27771 L
.59775 .28805 L
.59797 .29839 L
.59227 .30462 L
.58666 .30873 L
.58256 .31545 L
.58005 .31907 L
.57284 .32438 L
.56313 .32766 L
.55342 .32028 L
.54884 .31907 L
.5444 .30873 L
.54374 .29839 L
.54371 .29821 L
.53968 .28805 L
.53399 .28571 L
.53016 .28805 L
.52574 .29839 L
.52428 .30056 L
.51888 .30873 L
.51457 .31532 L
.50486 .31312 L
.49986 .30873 L
.49514 .30128 L
.493 .29839 L
.48543 .28868 L
.4852 .28805 L
.48543 .28448 L
.48582 .27771 L
.48543 .27619 L
.48386 .26737 L
.48543 .25714 L
.48546 .25703 L
Mistroke
.48905 .24669 L
.49432 .23635 L
.49148 .22601 L
.49514 .22351 L
.50486 .21585 L
.50497 .21567 L
.51457 .2114 L
Mfstroke
.67968 .19079 m
.68939 .19412 L
.69069 .195 L
.69103 .20533 L
.68939 .20594 L
.68092 .20533 L
.67968 .20465 L
.67427 .195 L
.67968 .19079 L
s
.56313 .19192 m
.5636 .195 L
.56313 .20087 L
.56179 .195 L
.56313 .19192 L
s
.63112 .13635 m
.63974 .1433 L
.64083 .14584 L
.65054 .1485 L
.66026 .15333 L
.66147 .15364 L
.66997 .15563 L
.67968 .1619 L
.68103 .16398 L
.67968 .16484 L
.67167 .17432 L
.66997 .17784 L
.66353 .18466 L
.66026 .19255 L
.65955 .195 L
.66026 .20129 L
.66056 .20533 L
.66026 .20757 L
.65672 .21567 L
.65054 .22282 L
.64083 .21701 L
.63112 .21834 L
.62799 .21567 L
.62141 .20848 L
.61868 .20533 L
.61806 .195 L
.61169 .19224 L
.61004 .18466 L
.61169 .18184 L
.61751 .18466 L
.62141 .19199 L
.63112 .19163 L
.63847 .195 L
.64083 .19625 L
.64328 .195 L
.64236 .18466 L
.6445 .17432 L
.64083 .16451 L
.64042 .16398 L
.63112 .15454 L
.63042 .15364 L
.62701 .1433 L
.63112 .13635 L
s
.58256 .09736 m
.59227 .09801 L
.60198 .09528 L
.61169 .10111 L
.61202 .10194 L
.61523 .11228 L
.61781 .12262 L
.61169 .13246 L
.60198 .12767 L
.59864 .12262 L
.59227 .11588 L
.58894 .11228 L
.58256 .10605 L
.57572 .10194 L
.58256 .09736 L
s
.50486 .09124 m
.51393 .0916 L
.51457 .09182 L
.52185 .10194 L
.51457 .10586 L
.50731 .11228 L
.50486 .11647 L
.49915 .12262 L
.49514 .12841 L
.48891 .13296 L
.48543 .13603 L
.47651 .1433 L
.47572 .14459 L
.47172 .15364 L
.47002 .16398 L
.46601 .17414 L
.46593 .17432 L
.46584 .18466 L
.46601 .18477 L
.46608 .18466 L
.47572 .17807 L
.47864 .18466 L
.47588 .195 L
.47572 .19575 L
.4729 .20533 L
.46601 .21179 L
.46103 .21567 L
.45629 .22048 L
.45282 .22601 L
.44658 .23417 L
.4441 .23635 L
.4434 .24669 L
.4377 .25703 L
.43687 .25734 L
.42716 .26375 L
.42272 .25703 L
.42472 .24669 L
.4211 .23635 L
.42474 .22601 L
.42716 .22345 L
.4314 .21567 L
.42825 .20533 L
.42716 .20404 L
.4264 .20533 L
.41744 .21033 L
.40773 .2139 L
.40178 .20533 L
.40182 .195 L
.40773 .1898 L
.41253 .18466 L
Mistroke
.40773 .17654 L
.40556 .17432 L
.40575 .16398 L
.40773 .16221 L
.41744 .16145 L
.42092 .15364 L
.42716 .14858 L
.43687 .1482 L
.44658 .14494 L
.44807 .1433 L
.45206 .13296 L
.44658 .12373 L
.44268 .12262 L
.44658 .11637 L
.45008 .11228 L
.45629 .10767 L
.46522 .10194 L
.46601 .10165 L
.46751 .10194 L
.47572 .10362 L
.47814 .10194 L
.48543 .09233 L
.49514 .09331 L
.50248 .0916 L
.50486 .09124 L
Mfstroke
.49514 .95989 m
.49587 .96009 L
.49514 .96077 L
.49506 .96009 L
.49514 .95989 L
s
.36888 .91027 m
.3735 .91873 L
.3706 .92907 L
.37094 .93941 L
.36888 .94662 L
.36484 .93941 L
.35917 .92964 L
.35822 .92907 L
.35917 .92836 L
.36336 .91873 L
.36888 .91027 L
s
.44658 .8241 m
.44811 .82568 L
.45603 .83602 L
.45629 .83641 L
.45896 .84636 L
.45629 .85022 L
.45177 .8567 L
.44658 .86218 L
.44284 .8567 L
.43687 .85052 L
.43207 .84636 L
.42716 .83864 L
.42346 .83602 L
.42716 .83307 L
.43687 .82924 L
.44243 .82568 L
.44658 .8241 L
s
.45629 .79382 m
.46601 .79377 L
.46674 .79467 L
.46601 .80119 L
.45629 .79535 L
.4562 .79467 L
.45629 .79382 L
s
.47572 .76964 m
.48543 .77258 L
.48607 .77399 L
.48543 .7827 L
.47572 .77687 L
.47404 .77399 L
.47572 .76964 L
s
.47572 .72028 m
.47606 .72229 L
.47572 .72439 L
.47465 .72229 L
.47572 .72028 L
s
.57284 .68574 m
.58034 .69127 L
.58256 .69484 L
.59227 .69892 L
.59455 .70161 L
.60198 .71143 L
.60428 .71195 L
.60548 .72229 L
.60198 .73131 L
.598 .72229 L
.60078 .71195 L
.59227 .70732 L
.58309 .71195 L
.58256 .71228 L
.5824 .71195 L
.57344 .70161 L
.57284 .70119 L
.56819 .69127 L
.57284 .68574 L
s
.50486 .69095 m
.51242 .69127 L
.51457 .69299 L
.51606 .70161 L
.51457 .70859 L
.51135 .70161 L
.50486 .69165 L
.49574 .69127 L
.50486 .69095 L
s
.59227 .65876 m
.59429 .66026 L
.60198 .66393 L
.61169 .66353 L
.62141 .66742 L
.62288 .6706 L
.62141 .67416 L
.62039 .68093 L
.62141 .68662 L
.62372 .69127 L
.62141 .69976 L
.62103 .70161 L
.61169 .70866 L
.60856 .70161 L
.60534 .69127 L
.60198 .68798 L
.60017 .68093 L
.59227 .67657 L
.59041 .6706 L
.58939 .66026 L
.59227 .65876 L
s
.44658 .6514 m
.45629 .65403 L
.46601 .65138 L
.4736 .66026 L
.47572 .6702 L
.47578 .6706 L
.47637 .68093 L
.47572 .68236 L
.46601 .68573 L
.46021 .68093 L
.45629 .67859 L
.44957 .6706 L
.44658 .6613 L
.44631 .66026 L
.44658 .6514 L
s
.50486 .60762 m
.50663 .60856 L
.51457 .61556 L
.5189 .6189 L
.5224 .62924 L
.52428 .63253 L
.5295 .62924 L
.52676 .6189 L
.52428 .6135 L
.52229 .60856 L
.52428 .60548 L
.53399 .60722 L
.53986 .60856 L
.54371 .6107 L
.55342 .61257 L
.55916 .6189 L
.55568 .62924 L
.56313 .63268 L
.56986 .63958 L
.57132 .64992 L
.56978 .66026 L
.56769 .6706 L
.56313 .67301 L
.5622 .6706 L
.55825 .66026 L
.55576 .64992 L
.55342 .64685 L
.54805 .63958 L
.54371 .63671 L
.53993 .63958 L
.54371 .6448 L
.54896 .64992 L
.54534 .66026 L
.54371 .66865 L
.5399 .66026 L
.53399 .65122 L
.52428 .65523 L
.51981 .66026 L
.51457 .66088 L
.50486 .66037 L
.49514 .66998 L
.492 .66026 L
.48896 .64992 L
.49006 .63958 L
.49514 .63723 L
.50168 .62924 L
.50303 .6189 L
.50381 .60856 L
.50486 .60762 L
s
.54371 .58177 m
.54703 .58788 L
.54534 .59822 L
.54371 .60169 L
.54023 .59822 L
.53869 .58788 L
.54371 .58177 L
s
.33974 .58235 m
.34946 .58059 L
.35133 .58788 L
.34946 .58973 L
.33974 .59406 L
.33639 .58788 L
.33974 .58235 L
s
.35917 .56361 m
.361 .5672 L
.35917 .57392 L
.35326 .5672 L
.35917 .56361 L
s
.83508 .43257 m
.83653 .4328 L
.84454 .44313 L
.84479 .44353 L
.85451 .44711 L
.8604 .45347 L
.85451 .46042 L
.84479 .45783 L
.84052 .45347 L
.83508 .44807 L
.83247 .44313 L
.83448 .4328 L
.83508 .43257 L
s
.71853 .40878 m
.72824 .40708 L
.73796 .40719 L
.74767 .40852 L
.75738 .41029 L
.7635 .41212 L
.76709 .41473 L
.77681 .4181 L
.78509 .42246 L
.78652 .42373 L
.79623 .4307 L
.79855 .4328 L
.80594 .44055 L
.80798 .44313 L
.80594 .44954 L
.79623 .44851 L
.78741 .44313 L
.78652 .44238 L
.77681 .43284 L
.77674 .4328 L
.76709 .42788 L
.75738 .42272 L
.75627 .42246 L
.74767 .42131 L
.74297 .42246 L
.73796 .42497 L
.72824 .43223 L
.72699 .4328 L
.71853 .43418 L
.71617 .4328 L
.70882 .42617 L
.70675 .42246 L
.70882 .41677 L
.71025 .41212 L
.71853 .40878 L
s
.30089 .4083 m
.31061 .40493 L
.31723 .41212 L
.31061 .41904 L
.30696 .42246 L
.30089 .42586 L
.29118 .43139 L
.2906 .42246 L
.29118 .42174 L
.29796 .41212 L
.30089 .4083 L
s
.82537 .39977 m
.82703 .40178 L
.82537 .40905 L
.81942 .40178 L
.82537 .39977 L
s
.33003 .4017 m
.33974 .40044 L
.34946 .39845 L
.35917 .396 L
.36888 .39588 L
.37859 .39776 L
.38596 .40178 L
.38166 .41212 L
.37859 .41445 L
.36888 .41935 L
.35917 .41292 L
.35902 .41212 L
.34946 .40384 L
.33974 .40243 L
.33003 .40185 L
.32957 .40178 L
.33003 .4017 L
s
.78652 .33764 m
.79355 .33974 L
.78652 .34184 L
.78481 .33974 L
.78652 .33764 L
s
.68939 .3284 m
.69911 .3199 L
.70498 .3294 L
.70882 .33441 L
.71853 .33324 L
.72545 .33974 L
.72824 .34245 L
.73689 .33974 L
.73796 .33859 L
.74767 .33592 L
.75553 .33974 L
.75738 .34481 L
.76033 .33974 L
.76709 .33794 L
.76876 .33974 L
.77681 .34932 L
.77751 .35008 L
.7854 .36042 L
.78652 .36122 L
.79103 .37076 L
.79623 .37987 L
.79912 .3811 L
.80594 .38395 L
.81532 .39144 L
.80594 .39824 L
.7986 .39144 L
.79623 .3874 L
.78652 .38363 L
.78057 .3811 L
.77681 .379 L
.76709 .37523 L
.75738 .37087 L
.75704 .37076 L
.74767 .36802 L
.73983 .36042 L
.73796 .3599 L
.7354 .36042 L
.72824 .36415 L
.71853 .36773 L
.70882 .36555 L
.69911 .3689 L
.68939 .36575 L
.68625 .36042 L
.68677 .35008 L
.68492 .33974 L
.68896 .3294 L
.68939 .3284 L
s
.43687 .32345 m
.43703 .3294 L
.43687 .32949 L
.43552 .3294 L
.43687 .32345 L
s
.41744 .32232 m
.42476 .3294 L
.41744 .3338 L
.40916 .3294 L
.41744 .32232 L
s
.37859 .30826 m
.37985 .30873 L
.38212 .31907 L
.37859 .32106 L
.37535 .31907 L
.37652 .30873 L
.37859 .30826 L
s
.53399 .29412 m
.53738 .29839 L
.53754 .30873 L
.53399 .31365 L
.52436 .30873 L
.53149 .29839 L
.53399 .29412 L
s
.57284 .08798 m
.58256 .08307 L
.59227 .08948 L
.60198 .08346 L
.61169 .08603 L
.62141 .09082 L
.62286 .0916 L
.63112 .09768 L
.63546 .10194 L
.63112 .10807 L
.62287 .11228 L
.63072 .12262 L
.63112 .12311 L
.64083 .12652 L
.64771 .13296 L
.65054 .13907 L
.65727 .1433 L
.66026 .14437 L
.66997 .14876 L
.67968 .15228 L
.68201 .15364 L
.68939 .15879 L
.69911 .16198 L
.70055 .16398 L
.69911 .17189 L
.69638 .17432 L
.68939 .17812 L
.68534 .18466 L
.68939 .18806 L
.69869 .195 L
.69911 .19557 L
.70652 .20533 L
.70882 .21108 L
.71242 .21567 L
.70882 .22118 L
.70278 .22601 L
.69911 .23002 L
.6935 .23635 L
.69911 .24611 L
.7001 .24669 L
.70882 .25089 L
.71853 .25632 L
.71986 .25703 L
.72824 .26191 L
.73202 .26737 L
.73432 .27771 L
.72824 .28534 L
.71853 .28698 L
.70882 .28333 L
.69911 .28216 L
Mistroke
.69588 .27771 L
.68939 .27308 L
.67968 .27109 L
.66997 .27352 L
.66455 .26737 L
.66719 .25703 L
.66997 .25322 L
.67032 .24669 L
.66997 .24646 L
.66026 .24255 L
.65159 .24669 L
.6532 .25703 L
.6548 .26737 L
.65054 .27717 L
.6444 .26737 L
.64975 .25703 L
.65003 .24669 L
.64168 .23635 L
.64083 .23316 L
.63657 .22601 L
.63112 .22394 L
.6227 .21567 L
.62141 .21423 L
.61548 .20533 L
.61169 .20148 L
.60791 .195 L
.60638 .18466 L
.61169 .17598 L
.62141 .17745 L
.62392 .17432 L
.62231 .16398 L
.62141 .15503 L
.62129 .15364 L
.6199 .1433 L
.61169 .13976 L
.60198 .13392 L
.60075 .13296 L
.59227 .12511 L
.59063 .12262 L
.58256 .11245 L
.58235 .11228 L
.57284 .10458 L
.5676 .10194 L
.5674 .0916 L
.57284 .08798 L
Mfstroke
.48543 .08402 m
.49514 .08244 L
.50486 .08356 L
.51457 .08684 L
.5211 .0916 L
.52398 .10194 L
.51457 .10887 L
.51072 .11228 L
.50486 .12173 L
.50406 .12262 L
.49514 .13242 L
.49423 .13296 L
.48543 .14187 L
.48308 .1433 L
.47682 .15364 L
.47572 .15699 L
.47482 .16398 L
.47572 .17008 L
.48099 .17432 L
.48239 .18466 L
.48487 .195 L
.48543 .19575 L
.49514 .20052 L
.49917 .195 L
.50486 .18773 L
.50816 .18466 L
.51457 .17989 L
.52428 .17838 L
.53399 .176 L
.54371 .17496 L
.55342 .17695 L
.56313 .18041 L
.56862 .18466 L
.57284 .19125 L
.57614 .195 L
.58039 .20533 L
.58256 .20869 L
.58666 .21567 L
.59227 .22078 L
.59728 .22601 L
.59598 .23635 L
.60088 .24669 L
.60198 .25647 L
.60204 .25703 L
.60312 .26737 L
.60782 .27771 L
.60802 .28805 L
.61017 .29839 L
.60939 .30873 L
.61121 .31907 L
Mistroke
.60415 .3294 L
.60983 .33974 L
.61169 .34024 L
.62141 .34291 L
.63071 .35008 L
.62937 .36042 L
.63112 .36464 L
.63477 .37076 L
.63819 .3811 L
.64083 .38566 L
.64303 .39144 L
.64267 .40178 L
.64861 .41212 L
.64083 .42057 L
.63307 .41212 L
.63171 .40178 L
.63112 .39983 L
.62525 .39144 L
.62181 .3811 L
.62141 .38084 L
.61169 .37579 L
.60969 .37076 L
.61169 .36378 L
.61317 .36042 L
.61169 .35821 L
.60198 .3595 L
.59227 .35249 L
.58256 .35354 L
.57284 .35338 L
.57014 .35008 L
.57284 .34451 L
.58096 .33974 L
.57284 .33601 L
.56313 .3331 L
.55877 .3294 L
.55342 .32656 L
.54371 .32733 L
.53784 .3294 L
.53399 .33162 L
.52649 .3294 L
.52428 .32802 L
.51457 .32513 L
.50505 .3294 L
.51457 .33543 L
.52428 .33525 L
.52461 .33974 L
.52428 .33992 L
.51457 .34528 L
.50844 .33974 L
.50486 .32986 L
Mistroke
.50236 .33974 L
.50178 .35008 L
.49865 .36042 L
.49514 .36271 L
.49235 .36042 L
.48543 .35279 L
.47572 .35111 L
.46601 .3582 L
.46524 .36042 L
.46601 .36929 L
.4661 .37076 L
.46601 .37351 L
.46301 .3811 L
.45629 .38655 L
.45252 .39144 L
.44658 .39784 L
.43714 .39144 L
.4421 .3811 L
.4432 .37076 L
.44503 .36042 L
.44658 .35837 L
.45359 .35008 L
.45629 .34283 L
.45837 .33974 L
.46601 .33732 L
.47217 .3294 L
.47412 .31907 L
.47365 .30873 L
.4685 .29839 L
.47426 .28805 L
.47572 .28675 L
.47972 .27771 L
.48045 .26737 L
.48074 .25703 L
.48104 .24669 L
.48361 .23635 L
.48318 .22601 L
.48543 .21765 L
.48828 .21567 L
.48543 .20888 L
.47572 .21345 L
.47025 .21567 L
.46601 .22031 L
.46244 .22601 L
.45904 .23635 L
.46279 .24669 L
.45654 .25703 L
.45629 .26286 L
.45517 .26737 L
.44658 .27328 L
Mistroke
.44567 .27771 L
.44658 .28245 L
.44724 .28805 L
.44658 .28989 L
.43687 .2927 L
.4293 .28805 L
.42716 .28707 L
.42154 .28805 L
.4216 .29839 L
.41744 .30547 L
.41037 .30873 L
.40773 .31538 L
.39802 .31248 L
.39356 .31907 L
.39802 .32209 L
.40662 .3294 L
.40514 .33974 L
.40298 .35008 L
.40545 .36042 L
.39802 .36916 L
.38831 .36603 L
.37859 .3664 L
.36888 .36987 L
.35917 .36723 L
.34946 .36877 L
.33974 .36733 L
.33003 .36856 L
.3234 .37076 L
.32032 .37824 L
.31841 .3811 L
.31061 .38464 L
.301 .39144 L
.30089 .39149 L
.29118 .39924 L
.28812 .40178 L
.28147 .40925 L
.2774 .41212 L
.27176 .42048 L
.26945 .42246 L
.26204 .43126 L
.26053 .4328 L
.25233 .44067 L
.24651 .4328 L
.24557 .42246 L
.25233 .41793 L
.25607 .41212 L
.26134 .40178 L
.26204 .39771 L
.27176 .39215 L
.27229 .39144 L
Mistroke
.27264 .3811 L
.27886 .37076 L
.28147 .36484 L
.28319 .36042 L
.28651 .35008 L
.28147 .34688 L
.27176 .34283 L
.26687 .33974 L
.27176 .33366 L
.28147 .3328 L
.29118 .33702 L
.29257 .33974 L
.30089 .3464 L
.31061 .34749 L
.31512 .33974 L
.32032 .33439 L
.32748 .33974 L
.33003 .34043 L
.3312 .33974 L
.33473 .3294 L
.33974 .32277 L
.34274 .31907 L
.34946 .31433 L
.35868 .30873 L
.35917 .30826 L
.36101 .29839 L
.35917 .29208 L
.3564 .28805 L
.34946 .282 L
.33974 .28051 L
.33759 .27771 L
.33229 .26737 L
.33974 .26566 L
.34946 .25848 L
.35167 .25703 L
.35917 .24849 L
.36888 .25223 L
.37859 .24835 L
.3811 .24669 L
.38831 .24151 L
.39229 .23635 L
.38831 .22827 L
.3871 .22601 L
.38403 .21567 L
.38831 .21041 L
.3919 .20533 L
.39587 .195 L
.39802 .19231 L
.40607 .18466 L
.39845 .17432 L
Mistroke
.39885 .16398 L
.40773 .15504 L
.41023 .15364 L
.40773 .14759 L
.40665 .1433 L
.40773 .14138 L
.41645 .13296 L
.41744 .13064 L
.42716 .12359 L
.42884 .12262 L
.43645 .11228 L
.43687 .11134 L
.44475 .10194 L
.44658 .10088 L
.45629 .09664 L
.46601 .09273 L
.47572 .09223 L
.47633 .0916 L
.48543 .08402 L
Mfstroke
.28147 .08961 m
.29118 .08839 L
.29608 .0916 L
.30089 .09878 L
.30288 .10194 L
.30089 .10311 L
.29806 .10194 L
.29118 .09858 L
.28147 .09478 L
.27813 .0916 L
.28147 .08961 L
s
.35593 .98077 m
.35199 .97043 L
.34946 .96886 L
.33974 .96446 L
.33003 .96601 L
.32623 .97043 L
.32818 .98077 L
s
.38271 .98077 m
.37925 .97043 L
.37859 .96915 L
.37189 .96009 L
.36888 .95226 L
.35917 .95947 L
.34946 .95165 L
.34823 .94975 L
.34171 .93941 L
.34569 .92907 L
.33974 .92657 L
.33865 .92907 L
.33003 .93752 L
.32506 .93941 L
.32032 .94362 L
.31391 .94975 L
.31061 .95566 L
.30707 .96009 L
.30089 .96138 L
.29632 .97043 L
.29118 .9737 L
.28147 .97336 L
.27562 .98077 L
s
.41744 .95601 m
.42124 .96009 L
.42206 .97043 L
.41744 .9772 L
.41578 .97043 L
.41519 .96009 L
.41744 .95601 L
s
.31061 .93166 m
.31269 .93941 L
.31061 .94163 L
.30372 .93941 L
.31061 .93166 L
s
.71853 .90533 m
.72445 .9084 L
.71898 .91873 L
.72358 .92907 L
.72702 .93941 L
.72824 .94213 L
.73149 .94975 L
.72824 .95367 L
.71962 .96009 L
.71853 .961 L
.71722 .96009 L
.70882 .95569 L
.70308 .94975 L
.70559 .93941 L
.70703 .92907 L
.70454 .91873 L
.70882 .91581 L
.71509 .9084 L
.71853 .90533 L
s
.41744 .89903 m
.42612 .9084 L
.41744 .9165 L
.40805 .9084 L
.41744 .89903 L
s
.37859 .9048 m
.38474 .9084 L
.37859 .91242 L
.37634 .9084 L
.37859 .9048 L
s
.29118 .90633 m
.29701 .9084 L
.29118 .91054 L
.28901 .9084 L
.29118 .90633 L
s
.53399 .89529 m
.5357 .89806 L
.53876 .9084 L
.53399 .91865 L
.52679 .9084 L
.53029 .89806 L
.53399 .89529 L
s
.31061 .88654 m
.31391 .88772 L
.31454 .89806 L
.31061 .90101 L
.30089 .90565 L
.2977 .89806 L
.30089 .89295 L
.30853 .88772 L
.31061 .88654 L
s
.67968 .86446 m
.6824 .86704 L
.68939 .8733 L
.69223 .87738 L
.69277 .88772 L
.69574 .89806 L
.69656 .9084 L
.68939 .91479 L
.68651 .91873 L
.68939 .92504 L
.69077 .92907 L
.68939 .93063 L
.68278 .93941 L
.68939 .94811 L
.69204 .94975 L
.68939 .95366 L
.68621 .94975 L
.67968 .94105 L
.67648 .93941 L
.67607 .92907 L
.67653 .91873 L
.67445 .9084 L
.67313 .89806 L
.67251 .88772 L
.67219 .87738 L
.67742 .86704 L
.67968 .86446 L
s
.37859 .86149 m
.3834 .86704 L
.37859 .8717 L
.37668 .86704 L
.37859 .86149 L
s
.51457 .82424 m
.52428 .82167 L
.52697 .82568 L
.52555 .83602 L
.52428 .83883 L
.52246 .83602 L
.51457 .82625 L
.51438 .82568 L
.51457 .82424 L
s
.14549 .8128 m
.14717 .81534 L
.14549 .81963 L
.13945 .81534 L
.14549 .8128 L
s
.09693 .80998 m
.09923 .81534 L
.09693 .81898 L
.09254 .81534 L
.09693 .80998 L
s
.62141 .80431 m
.63033 .805 L
.63112 .81454 L
.63162 .81534 L
.63786 .82568 L
.63872 .83602 L
.64068 .84636 L
.64083 .84672 L
.64601 .8567 L
.65054 .85934 L
.65777 .86704 L
.66026 .87323 L
.66309 .87738 L
.66026 .88508 L
.65899 .88772 L
.65054 .89454 L
.64083 .8904 L
.6381 .88772 L
.63563 .87738 L
.63112 .87278 L
.6273 .87738 L
.62601 .88772 L
.63112 .89257 L
.63609 .89806 L
.63112 .90482 L
.62834 .89806 L
.62141 .89019 L
.61764 .88772 L
.61728 .87738 L
.61894 .86704 L
.61648 .8567 L
.61717 .84636 L
.61169 .83844 L
.6102 .83602 L
.60545 .82568 L
.60602 .81534 L
.61169 .80524 L
.61266 .805 L
.62141 .80431 L
s
.53399 .78447 m
.54041 .79467 L
.53908 .805 L
.53488 .81534 L
.53399 .81709 L
.52848 .81534 L
.52647 .805 L
.52559 .79467 L
.53399 .78447 L
s
.51457 .79067 m
.52006 .79467 L
.51457 .79786 L
.5138 .79467 L
.51457 .79067 L
s
.45629 .69014 m
.45719 .69127 L
.45629 .69508 L
.4557 .69127 L
.45629 .69014 L
s
.51457 .67045 m
.51469 .6706 L
.51457 .67225 L
.51177 .6706 L
.51457 .67045 L
s
.09693 .62726 m
.09762 .62924 L
.09693 .62979 L
.08877 .62924 L
.09693 .62726 L
s
.07751 .62034 m
.08695 .62924 L
.07751 .63926 L
.07563 .62924 L
.07751 .62034 L
s
.10664 .61737 m
.11636 .6174 L
.11843 .6189 L
.11636 .62199 L
.10664 .62226 L
.10474 .6189 L
.10664 .61737 L
s
.45629 .59592 m
.46113 .59822 L
.45629 .60166 L
.45433 .59822 L
.45629 .59592 L
s
.71853 .58743 m
.71893 .58788 L
.71853 .59076 L
.7174 .58788 L
.71853 .58743 L
s
.47572 .58424 m
.48073 .58788 L
.47572 .59059 L
.47264 .58788 L
.47572 .58424 L
s
.42716 .57187 m
.43264 .57754 L
.42716 .58274 L
.42162 .57754 L
.42716 .57187 L
s
.30089 .56559 m
.30657 .5672 L
.30089 .57449 L
.29824 .5672 L
.30089 .56559 L
s
.11636 .55714 m
.11873 .5672 L
.11636 .56919 L
.11282 .5672 L
.11636 .55714 L
s
.71853 .55354 m
.72127 .55687 L
.71853 .55951 L
.7121 .55687 L
.71853 .55354 L
s
.67968 .5495 m
.68402 .55687 L
.68374 .5672 L
.67968 .56796 L
.67937 .5672 L
.67617 .55687 L
.67968 .5495 L
s
.56313 .55457 m
.56886 .55687 L
.57284 .56638 L
.5731 .5672 L
.57715 .57754 L
.57284 .58245 L
.56414 .57754 L
.56313 .57704 L
.55405 .5672 L
.55783 .55687 L
.56313 .55457 L
s
.53399 .5468 m
.53982 .55687 L
.54371 .56376 L
.55055 .5672 L
.55044 .57754 L
.55336 .58788 L
.55342 .58862 L
.55512 .59822 L
.56051 .60856 L
.56313 .61197 L
.56695 .60856 L
.57233 .59822 L
.57284 .59767 L
.57485 .59822 L
.58256 .60193 L
.59227 .60713 L
.59262 .60856 L
.59227 .60999 L
.58747 .6189 L
.58721 .62924 L
.58709 .63958 L
.59227 .64083 L
.59286 .63958 L
.59861 .62924 L
.60198 .62776 L
.6052 .62924 L
.61169 .63377 L
.62141 .63222 L
.62337 .62924 L
.63112 .62816 L
.63178 .62924 L
.63819 .63958 L
.63465 .64992 L
.64066 .66026 L
.64083 .66051 L
.6439 .6706 L
.64476 .68093 L
.64357 .69127 L
.64083 .69482 L
.63647 .70161 L
.63112 .71125 L
.63067 .71195 L
.62732 .72229 L
.62141 .72829 L
.61696 .73263 L
.61818 .74297 L
.61734 .75331 L
.62141 .75746 L
.6253 .76365 L
.62981 .77399 L
Mistroke
.63112 .77582 L
.6387 .78433 L
.63916 .79467 L
.63112 .80449 L
.62536 .79467 L
.62141 .78489 L
.62092 .78433 L
.61169 .78189 L
.6095 .78433 L
.6082 .79467 L
.60198 .8 L
.59794 .79467 L
.59596 .78433 L
.59638 .77399 L
.59811 .76365 L
.59807 .75331 L
.59473 .74297 L
.59227 .7345 L
.58256 .73418 L
.57284 .73673 L
.56912 .73263 L
.56313 .72853 L
.55622 .73263 L
.55689 .74297 L
.55342 .74906 L
.54694 .75331 L
.54371 .75371 L
.54248 .75331 L
.54228 .74297 L
.54046 .73263 L
.5395 .72229 L
.54018 .71195 L
.53399 .70476 L
.52743 .70161 L
.52428 .70072 L
.52419 .70161 L
.52142 .71195 L
.51894 .72229 L
.51935 .73263 L
.51863 .74297 L
.5187 .75331 L
.51457 .75707 L
.51151 .75331 L
.50767 .74297 L
.50486 .73595 L
.4956 .73263 L
.49702 .72229 L
.49514 .71318 L
.49479 .71195 L
.49131 .70161 L
Mistroke
.48731 .69127 L
.48871 .68093 L
.48543 .67756 L
.48492 .68093 L
.48132 .69127 L
.47918 .70161 L
.48151 .71195 L
.48186 .72229 L
.48142 .73263 L
.48543 .7406 L
.48745 .74297 L
.49514 .75072 L
.49697 .75331 L
.50486 .76283 L
.50533 .76365 L
.50486 .76427 L
.49619 .76365 L
.49514 .76343 L
.49151 .75331 L
.48543 .74806 L
.48366 .75331 L
.48543 .76134 L
.49319 .76365 L
.49117 .77399 L
.49264 .78433 L
.49229 .79467 L
.49476 .805 L
.48725 .81534 L
.48543 .81776 L
.48297 .82568 L
.48543 .83211 L
.49113 .83602 L
.49274 .84636 L
.48543 .85543 L
.47967 .84636 L
.47572 .83847 L
.47154 .83602 L
.46952 .82568 L
.46601 .8204 L
.45924 .82568 L
.4633 .83602 L
.46601 .84261 L
.46689 .84636 L
.46601 .84901 L
.45939 .8567 L
.46539 .86704 L
.458 .87738 L
.45629 .88755 L
.4562 .88772 L
.45091 .89806 L
Mistroke
.45209 .9084 L
.45127 .91873 L
.44658 .92234 L
.43983 .91873 L
.43777 .9084 L
.43727 .89806 L
.43687 .89665 L
.43137 .88772 L
.42745 .87738 L
.42716 .8772 L
.42596 .87738 L
.41744 .88181 L
.41135 .88772 L
.40773 .88881 L
.40592 .88772 L
.40258 .87738 L
.39847 .86704 L
.39802 .86668 L
.39665 .8567 L
.39802 .84683 L
.39885 .84636 L
.40773 .84499 L
.41018 .83602 L
.41388 .82568 L
.41706 .81534 L
.41744 .81445 L
.42163 .81534 L
.42716 .81672 L
.4278 .81534 L
.43687 .80888 L
.44658 .80833 L
.45068 .805 L
.44803 .79467 L
.44658 .78832 L
.44261 .78433 L
.43706 .77399 L
.44658 .76719 L
.45608 .77399 L
.45629 .77441 L
.46601 .78036 L
.46796 .77399 L
.46601 .77062 L
.45835 .76365 L
.45629 .75423 L
.45595 .75331 L
.45185 .74297 L
.45629 .74034 L
.46408 .74297 L
.46601 .74365 L
.46669 .74297 L
Mistroke
.4688 .73263 L
.46601 .72429 L
.45629 .72479 L
.45318 .72229 L
.44658 .71386 L
.44456 .71195 L
.44211 .70161 L
.44183 .69127 L
.43701 .68093 L
.43758 .6706 L
.4398 .66026 L
.43687 .65277 L
.43501 .64992 L
.43162 .63958 L
.43121 .62924 L
.43687 .62291 L
.44253 .62924 L
.44658 .63198 L
.45375 .63958 L
.45629 .6461 L
.46462 .63958 L
.46156 .62924 L
.46601 .62651 L
.46961 .62924 L
.47572 .63214 L
.48087 .62924 L
.47833 .6189 L
.48144 .60856 L
.48543 .60237 L
.49514 .6063 L
.50285 .59822 L
.50486 .59606 L
.5076 .58788 L
.50486 .58166 L
.49514 .58057 L
.48543 .58351 L
.48169 .57754 L
.48543 .56742 L
.49514 .57625 L
.50267 .5672 L
.50486 .56538 L
.51457 .56688 L
.51508 .5672 L
.52428 .57587 L
.52659 .57754 L
.53399 .57783 L
.53412 .57754 L
.53399 .57577 L
.53062 .5672 L
.52488 .55687 L
Mistroke
.53399 .5468 L
Mfstroke
.49514 .53716 m
.4984 .54653 L
.49514 .54799 L
.49317 .54653 L
.49514 .53716 L
s
.53399 .53283 m
.54371 .53228 L
.54792 .53619 L
.54371 .53897 L
.53399 .54571 L
.52937 .53619 L
.53399 .53283 L
s
.67968 .52431 m
.68068 .52585 L
.68247 .53619 L
.67968 .54009 L
.67758 .53619 L
.67914 .52585 L
.67968 .52431 L
s
.22319 .52488 m
.23291 .52023 L
.24262 .52203 L
.24579 .52585 L
.24262 .52843 L
.23616 .53619 L
.24262 .54516 L
.25031 .54653 L
.24778 .55687 L
.24262 .55983 L
.23893 .5672 L
.23291 .57269 L
.22319 .56745 L
.22224 .5672 L
.21587 .55687 L
.22319 .5493 L
.22837 .54653 L
.22319 .54028 L
.21665 .53619 L
.22273 .52585 L
.22319 .52488 L
s
.33974 .51186 m
.34946 .50829 L
.35917 .5075 L
.36611 .51551 L
.35917 .52241 L
.35444 .52585 L
.35917 .53309 L
.36419 .53619 L
.36435 .54653 L
.36486 .55687 L
.36878 .5672 L
.36888 .56744 L
.37358 .57754 L
.36888 .58208 L
.36131 .58788 L
.35917 .59669 L
.35888 .59822 L
.34946 .60486 L
.34315 .60856 L
.33974 .60928 L
.33398 .6189 L
.33003 .62221 L
.32544 .62924 L
.33003 .63665 L
.33113 .63958 L
.33003 .64008 L
.32754 .63958 L
.32032 .63524 L
.31061 .63472 L
.30608 .62924 L
.31061 .61918 L
.3108 .6189 L
.31752 .60856 L
.31303 .59822 L
.32032 .59127 L
.32747 .58788 L
.33003 .58355 L
.3351 .57754 L
.33974 .57271 L
.3441 .5672 L
.34699 .55687 L
.33974 .55092 L
.33612 .54653 L
.33974 .54283 L
.34946 .53719 L
.35053 .53619 L
.34946 .53229 L
.34448 .52585 L
.33974 .51878 L
.33834 .51551 L
Mistroke
.33974 .51186 L
Mfstroke
.57284 .49591 m
.5824 .50517 L
.57284 .50769 L
.57108 .50517 L
.57284 .49591 L
s
.38831 .50301 m
.39802 .49622 L
.39998 .50517 L
.40338 .51551 L
.39911 .52585 L
.40083 .53619 L
.40167 .54653 L
.40367 .55687 L
.4068 .5672 L
.39802 .57319 L
.38831 .57526 L
.37859 .57636 L
.36926 .5672 L
.37563 .55687 L
.37859 .54898 L
.37936 .54653 L
.38124 .53619 L
.37859 .52938 L
.37744 .52585 L
.37859 .52311 L
.38831 .5191 L
.39126 .51551 L
.38831 .5089 L
.38638 .50517 L
.38831 .50301 L
s
.25233 .50133 m
.25712 .50517 L
.25233 .50833 L
.24761 .50517 L
.25233 .50133 L
s
.20377 .49983 m
.21236 .50517 L
.20377 .50648 L
.2007 .50517 L
.20377 .49983 L
s
.15521 .50129 m
.15864 .50517 L
.15521 .5095 L
.15064 .50517 L
.15521 .50129 L
s
.78652 .49455 m
.79623 .49252 L
.80156 .49483 L
.79623 .50027 L
.78652 .49672 L
.78588 .49483 L
.78652 .49455 L
s
.22319 .4933 m
.22525 .49483 L
.22319 .49759 L
.22027 .49483 L
.22319 .4933 L
s
.28147 .48054 m
.29118 .47749 L
.30075 .48449 L
.29501 .49483 L
.29118 .49819 L
.28147 .49856 L
.27495 .49483 L
.27293 .48449 L
.28147 .48054 L
s
.35917 .47102 m
.3632 .47415 L
.36888 .48005 L
.37363 .48449 L
.36888 .48957 L
.35917 .48905 L
.35283 .48449 L
.3533 .47415 L
.35917 .47102 L
s
.30089 .47006 m
.31061 .47281 L
.31324 .47415 L
.31061 .4837 L
.30089 .48441 L
.29439 .47415 L
.30089 .47006 L
s
.19406 .47293 m
.19881 .47415 L
.19406 .47639 L
.18529 .47415 L
.19406 .47293 L
s
.17463 .4714 m
.18383 .47415 L
.17463 .47606 L
.17229 .47415 L
.17463 .4714 L
s
.33974 .45336 m
.34057 .45347 L
.34794 .46381 L
.33974 .46727 L
.33631 .46381 L
.33895 .45347 L
.33974 .45336 L
s
.16492 .43902 m
.17073 .44313 L
.16492 .44833 L
.16176 .44313 L
.16492 .43902 L
s
.13578 .4315 m
.13955 .4328 L
.13578 .43661 L
.13475 .4328 L
.13578 .4315 L
s
.85451 .40999 m
.85721 .41212 L
.86422 .41851 L
.86684 .42246 L
.86422 .42746 L
.8585 .42246 L
.85451 .41616 L
.85193 .41212 L
.85451 .40999 L
s
.71853 .40642 m
.72824 .40481 L
.73796 .40497 L
.74767 .4057 L
.75738 .40732 L
.76709 .4101 L
.76845 .41212 L
.77681 .41535 L
.78652 .41982 L
.78899 .42246 L
.79623 .42781 L
.80183 .4328 L
.80594 .43693 L
.81131 .44313 L
.81566 .45111 L
.81718 .45347 L
.81566 .46312 L
.80594 .45723 L
.799 .45347 L
.79623 .45245 L
.78652 .4452 L
.78376 .44313 L
.77681 .43647 L
.76869 .4328 L
.76709 .43202 L
.75738 .4259 L
.74767 .4249 L
.73796 .42968 L
.73467 .4328 L
.72824 .43328 L
.71853 .43676 L
.71257 .4328 L
.70882 .42937 L
.70447 .42246 L
.70882 .41287 L
.70893 .41212 L
.71853 .40642 L
s
.29118 .40414 m
.29492 .41212 L
.29118 .41737 L
.28189 .41212 L
.29118 .40414 L
s
.17463 .40412 m
.18063 .41212 L
.17566 .42246 L
.17463 .423 L
.16492 .42308 L
.16467 .42246 L
.16492 .41665 L
.16663 .41212 L
.17463 .40412 L
s
.30089 .39716 m
.30602 .40178 L
.30089 .40407 L
.29493 .40178 L
.30089 .39716 L
s
.73796 .30263 m
.74596 .30873 L
.74767 .31018 L
.75738 .31306 L
.76709 .31333 L
.77616 .31907 L
.76709 .32605 L
.75738 .32596 L
.74767 .32512 L
.74323 .31907 L
.73796 .31277 L
.73501 .30873 L
.73796 .30263 L
s
.45629 .28852 m
.45977 .29839 L
.46404 .30873 L
.4641 .31907 L
.45629 .32326 L
.45206 .31907 L
.44984 .30873 L
.45246 .29839 L
.45629 .28852 L
s
.66997 .28684 m
.6725 .28805 L
.67968 .29812 L
.67983 .29839 L
.68314 .30873 L
.68274 .31907 L
.67968 .32775 L
.67496 .31907 L
.67338 .30873 L
.67854 .29839 L
.66997 .29067 L
.66745 .28805 L
.66997 .28684 L
s
.32032 .2877 m
.32112 .28805 L
.32032 .29063 L
.31894 .28805 L
.32032 .2877 L
s
.47572 .25899 m
.47679 .26737 L
.47572 .27165 L
.46625 .26737 L
.47572 .25899 L
s
.35917 .22653 m
.36826 .23635 L
.35917 .23891 L
.35274 .23635 L
.35917 .22653 L
s
.22319 .23482 m
.2322 .23635 L
.22319 .23872 L
.22192 .23635 L
.22319 .23482 L
s
.89336 .21965 m
.90307 .22487 L
.9035 .22601 L
.90307 .2278 L
.89336 .22769 L
.88938 .22601 L
.89336 .21965 L
s
.47572 .22248 m
.47767 .22601 L
.47572 .23583 L
.47166 .22601 L
.47572 .22248 L
s
.73796 .21329 m
.74767 .2147 L
.74822 .21567 L
.75738 .22083 L
.76268 .22601 L
.75738 .22855 L
.75114 .22601 L
.74767 .21982 L
.73796 .2196 L
.73632 .21567 L
.73796 .21329 L
s
.24262 .21398 m
.25222 .21567 L
.24262 .22198 L
.24008 .21567 L
.24262 .21398 L
s
.27176 .18862 m
.2779 .195 L
.27176 .20018 L
.2691 .195 L
.27176 .18862 L
s
.30089 .17105 m
.305 .17432 L
.30089 .17638 L
.2993 .17432 L
.30089 .17105 L
s
.28147 .12694 m
.28809 .13296 L
.28147 .13529 L
.27515 .13296 L
.28147 .12694 L
s
.25233 .13254 m
.2531 .13296 L
.25233 .14147 L
.25119 .13296 L
.25233 .13254 L
s
.26204 .11135 m
.27176 .10517 L
.27621 .11228 L
.27176 .11485 L
.26204 .11291 L
.26159 .11228 L
.26204 .11135 L
s
.57284 .06665 m
.58256 .06882 L
.59227 .06792 L
.60198 .07053 L
.6032 .07093 L
.61169 .07829 L
.61762 .08127 L
.62141 .0826 L
.63112 .08671 L
.63378 .0916 L
.64083 .0961 L
.64931 .10194 L
.65054 .10573 L
.65276 .11228 L
.66026 .11771 L
.66559 .12262 L
.66997 .12528 L
.67672 .13296 L
.67672 .1433 L
.67968 .1456 L
.68939 .14854 L
.69302 .15364 L
.69911 .15605 L
.70529 .16398 L
.70882 .17228 L
.71031 .17432 L
.70882 .17783 L
.69911 .18138 L
.69599 .18466 L
.69911 .18743 L
.70673 .195 L
.70882 .20051 L
.71307 .20533 L
.71853 .21151 L
.72202 .21567 L
.72824 .22226 L
.73111 .22601 L
.72824 .22846 L
.71853 .23278 L
.71151 .23635 L
.71676 .24669 L
.71853 .24775 L
.72824 .24858 L
.73425 .24669 L
.73796 .2463 L
.73882 .24669 L
.74767 .25166 L
.75323 .25703 L
.75277 .26737 L
.75738 .26852 L
Mistroke
.76709 .27145 L
.77681 .27321 L
.78518 .27771 L
.77681 .28351 L
.76709 .28444 L
.75738 .2858 L
.7528 .28805 L
.75738 .29649 L
.75922 .29839 L
.76709 .30351 L
.77681 .30381 L
.78652 .30535 L
.79142 .30873 L
.79623 .31421 L
.80139 .31907 L
.80594 .32436 L
.8154 .3294 L
.81566 .32963 L
.82537 .3352 L
.8291 .33974 L
.82819 .35008 L
.83508 .35638 L
.84402 .36042 L
.83777 .37076 L
.83567 .3811 L
.83508 .38165 L
.83292 .3811 L
.82559 .37076 L
.82898 .36042 L
.82537 .35387 L
.82272 .35008 L
.81566 .34263 L
.80719 .35008 L
.81554 .36042 L
.81566 .36131 L
.81894 .37076 L
.82045 .3811 L
.82537 .38565 L
.83043 .39144 L
.83508 .39773 L
.8434 .40178 L
.84279 .41212 L
.84479 .41804 L
.84895 .42246 L
.85451 .4266 L
.85672 .4328 L
.86024 .44313 L
.86422 .44738 L
.87393 .45111 L
.87751 .45347 L
Mistroke
.88061 .46381 L
.8767 .47415 L
.87393 .47654 L
.86422 .47763 L
.85451 .47972 L
.84479 .47618 L
.84327 .47415 L
.84108 .46381 L
.83508 .4552 L
.8339 .45347 L
.82826 .44313 L
.82537 .43741 L
.82247 .4328 L
.81577 .42246 L
.81566 .42242 L
.80594 .41285 L
.80451 .41212 L
.79623 .40265 L
.79479 .40178 L
.78652 .39511 L
.77959 .39144 L
.77681 .39053 L
.76709 .38422 L
.75738 .38271 L
.74767 .38127 L
.74716 .3811 L
.73796 .37353 L
.72824 .3763 L
.71853 .37862 L
.70882 .37473 L
.69911 .37537 L
.68939 .37818 L
.67968 .37811 L
.66997 .37619 L
.66815 .37076 L
.66997 .3678 L
.67968 .3613 L
.67996 .36042 L
.68239 .35008 L
.67968 .3441 L
.66997 .34321 L
.66026 .34968 L
.65054 .34165 L
.64889 .33974 L
.64881 .3294 L
.64776 .31907 L
.64478 .30873 L
.64083 .30244 L
.63177 .29839 L
.63717 .28805 L
Mistroke
.63399 .27771 L
.63166 .26737 L
.63112 .26328 L
.62141 .25872 L
.61748 .25703 L
.61909 .24669 L
.62003 .23635 L
.62141 .23451 L
.62676 .22601 L
.62141 .22199 L
.61652 .21567 L
.61169 .20984 L
.60593 .20533 L
.60228 .195 L
.6029 .18466 L
.60632 .17432 L
.61169 .1643 L
.61175 .16398 L
.61169 .15876 L
.61068 .15364 L
.60315 .1433 L
.60198 .14245 L
.59227 .13459 L
.59041 .13296 L
.58519 .12262 L
.58256 .1173 L
.57831 .11228 L
.57284 .10791 L
.56438 .10194 L
.56313 .09693 L
.55919 .0916 L
.56313 .08513 L
.56854 .08127 L
.5662 .07093 L
.57284 .06665 L
Mfstroke
.49514 .06918 m
.50486 .07078 L
.51457 .07003 L
.52428 .06894 L
.52747 .07093 L
.52779 .08127 L
.52765 .0916 L
.52577 .10194 L
.52428 .10385 L
.51457 .11176 L
.51399 .11228 L
.50758 .12262 L
.50486 .12668 L
.49772 .13296 L
.49514 .13463 L
.48732 .1433 L
.48543 .14564 L
.47882 .15364 L
.47788 .16398 L
.48403 .17432 L
.48543 .18137 L
.49514 .18052 L
.50486 .18124 L
.5144 .17432 L
.51457 .17425 L
.52428 .16806 L
.53399 .16852 L
.54371 .16628 L
.55342 .17024 L
.56255 .17432 L
.56313 .17489 L
.57284 .18042 L
.57673 .18466 L
.58256 .18821 L
.59227 .19258 L
.5943 .195 L
.59602 .20533 L
.60179 .21567 L
.60153 .22601 L
.60198 .22881 L
.6042 .23635 L
.60899 .24669 L
.61093 .25703 L
.61169 .2662 L
.61193 .26737 L
.62115 .27771 L
.62141 .27787 L
.62988 .28805 L
.63064 .29839 L
.6233 .30873 L
Mistroke
.62236 .31907 L
.62951 .3294 L
.63112 .33512 L
.63396 .33974 L
.64054 .35008 L
.64083 .35947 L
.64106 .36042 L
.64668 .37076 L
.64682 .3811 L
.64928 .39144 L
.65054 .39847 L
.65182 .40178 L
.65785 .41212 L
.65664 .42246 L
.65054 .42854 L
.64083 .43269 L
.63112 .42811 L
.6231 .42246 L
.62141 .42168 L
.61345 .41212 L
.61292 .40178 L
.61169 .39587 L
.60279 .39144 L
.60198 .39123 L
.60068 .39144 L
.59227 .39281 L
.59182 .39144 L
.587 .3811 L
.58256 .37196 L
.57903 .37076 L
.57284 .36693 L
.56344 .36042 L
.56313 .36023 L
.56284 .36042 L
.55342 .36624 L
.54387 .36042 L
.54736 .35008 L
.54371 .34668 L
.54218 .35008 L
.53399 .35579 L
.52781 .36042 L
.52428 .36584 L
.51457 .36566 L
.50792 .37076 L
.50486 .37352 L
.49514 .37555 L
.48543 .37344 L
.47572 .37243 L
.47429 .3811 L
.46828 .39144 L
Mistroke
.46601 .39341 L
.45905 .40178 L
.45629 .40528 L
.44899 .41212 L
.44658 .41568 L
.44126 .42246 L
.43687 .42585 L
.42775 .4328 L
.42716 .43317 L
.41744 .43311 L
.41669 .4328 L
.41614 .42246 L
.41744 .42008 L
.42305 .41212 L
.42716 .40845 L
.43043 .40178 L
.4308 .39144 L
.43261 .3811 L
.43478 .37076 L
.43524 .36042 L
.43687 .35732 L
.44214 .35008 L
.44484 .33974 L
.43687 .33726 L
.42716 .33534 L
.41948 .33974 L
.41837 .35008 L
.41744 .35708 L
.41444 .36042 L
.40773 .36836 L
.4029 .37076 L
.39802 .37683 L
.3892 .3811 L
.38831 .38124 L
.37859 .38222 L
.37382 .3811 L
.36888 .37618 L
.35917 .37649 L
.34946 .37681 L
.33974 .37639 L
.3328 .3811 L
.33003 .38228 L
.32032 .38555 L
.31213 .39144 L
.32032 .39783 L
.33003 .39645 L
.33974 .3956 L
.34946 .39396 L
.35917 .39277 L
.36888 .39347 L
Mistroke
.37859 .39546 L
.38657 .40178 L
.38489 .41212 L
.37859 .41756 L
.36936 .42246 L
.36888 .42253 L
.36866 .42246 L
.35917 .41605 L
.35865 .41212 L
.34946 .40721 L
.33974 .40581 L
.33003 .40668 L
.32159 .41212 L
.32032 .41394 L
.31146 .42246 L
.31061 .42327 L
.30089 .42933 L
.29646 .4328 L
.29118 .43738 L
.28322 .4328 L
.28663 .42246 L
.28147 .41268 L
.27488 .42246 L
.27176 .42425 L
.26596 .4328 L
.26204 .43682 L
.2564 .44313 L
.25315 .45347 L
.25233 .45513 L
.24897 .46381 L
.24262 .46989 L
.23291 .46963 L
.22319 .46534 L
.2177 .46381 L
.21348 .46203 L
.21096 .45347 L
.21348 .44875 L
.22141 .44313 L
.22319 .44157 L
.22863 .4328 L
.23059 .42246 L
.23291 .41749 L
.23884 .41212 L
.24262 .40702 L
.25233 .40585 L
.25423 .40178 L
.25242 .39144 L
.26204 .38332 L
.26439 .3811 L
.27061 .37076 L
Mistroke
.27085 .36042 L
.26337 .35008 L
.26204 .34865 L
.25233 .34084 L
.24262 .3421 L
.23645 .35008 L
.23291 .3523 L
.22319 .35293 L
.21518 .36042 L
.21348 .36254 L
.20377 .37064 L
.20365 .37076 L
.19438 .3811 L
.19406 .38148 L
.18785 .39144 L
.19406 .39841 L
.19888 .40178 L
.19406 .40659 L
.18434 .40863 L
.17547 .40178 L
.17463 .40042 L
.17212 .39144 L
.17377 .3811 L
.17463 .3776 L
.1779 .37076 L
.18434 .36052 L
.18447 .36042 L
.19406 .35562 L
.20377 .35317 L
.20687 .35008 L
.21237 .33974 L
.21348 .33888 L
.21623 .3294 L
.22319 .3211 L
.2266 .31907 L
.23291 .31511 L
.23918 .30873 L
.24262 .30635 L
.25233 .30381 L
.25446 .29839 L
.26015 .28805 L
.26204 .28743 L
.27176 .28565 L
.28147 .28499 L
.29118 .28143 L
.30089 .27805 L
.30343 .28805 L
.30089 .28935 L
.29118 .29341 L
.28585 .29839 L
Mistroke
.29118 .30488 L
.30089 .30689 L
.30439 .30873 L
.31061 .31495 L
.32032 .31213 L
.32599 .30873 L
.33003 .30607 L
.33974 .30693 L
.3468 .29839 L
.33974 .28994 L
.33782 .28805 L
.33119 .27771 L
.33003 .27618 L
.32032 .27201 L
.31061 .27671 L
.30525 .26737 L
.31061 .26393 L
.32032 .2593 L
.32642 .25703 L
.33003 .25639 L
.33974 .25189 L
.34291 .24669 L
.34662 .23635 L
.33974 .23049 L
.3335 .22601 L
.33974 .22103 L
.34946 .21579 L
.34965 .21567 L
.35917 .21263 L
.36216 .21567 L
.36888 .22337 L
.37454 .21567 L
.37859 .21146 L
.38338 .20533 L
.37859 .19663 L
.37365 .195 L
.36888 .18795 L
.36835 .18466 L
.36888 .1824 L
.37859 .17753 L
.3832 .17432 L
.38777 .16398 L
.38831 .1552 L
.39802 .15653 L
.4011 .15364 L
.39968 .1433 L
.40518 .13296 L
.40545 .12262 L
.40773 .12128 L
.41744 .11483 L
Mistroke
.42716 .11239 L
.42733 .11228 L
.43532 .10194 L
.43687 .10076 L
.44658 .09476 L
.45213 .0916 L
.45629 .08957 L
.46601 .08581 L
.47572 .0833 L
.47821 .08127 L
.48543 .07677 L
.49241 .07093 L
.49514 .06918 L
Mfstroke
.24262 .04822 m
.24796 .05025 L
.24262 .05302 L
.23382 .05025 L
.24262 .04822 L
s
.90307 .0361 m
.90837 .03991 L
.90307 .0452 L
.89933 .03991 L
.90307 .0361 L
s
.21348 .02171 m
.22319 .02742 L
.22367 .02957 L
.22319 .03228 L
.21348 .03326 L
.2064 .02957 L
.21348 .02171 L
s
.78638 .98077 m
.77681 .97544 L
.76728 .98077 L
s
.76656 .98077 m
.75738 .97155 L
.75555 .97043 L
.75214 .96009 L
.75317 .94975 L
.74767 .94009 L
.74066 .94975 L
.74298 .96009 L
.74501 .97043 L
.74767 .97462 L
.75342 .98077 L
s
.7294 .98077 m
.72824 .97749 L
.71853 .97076 L
.71824 .97043 L
.70882 .96779 L
.70489 .97043 L
.70215 .98077 L
s
.50121 .98077 m
.50486 .97325 L
.50559 .97043 L
.50731 .96009 L
.50486 .95485 L
.50191 .94975 L
.5047 .93941 L
.49514 .93613 L
.49069 .93941 L
.49162 .94975 L
.48846 .96009 L
.49038 .97043 L
.49323 .98077 L
s
.39091 .98077 m
.38831 .97855 L
.38513 .97043 L
.37909 .96009 L
.38091 .94975 L
.38831 .94228 L
.39141 .93941 L
.39802 .93367 L
.40773 .93372 L
.41191 .92907 L
.41438 .91873 L
.40773 .90864 L
.40661 .9084 L
.39802 .90565 L
.39221 .89806 L
.39236 .88772 L
.38831 .88127 L
.38049 .88772 L
.37859 .88924 L
.36888 .89768 L
.35917 .89647 L
.35465 .89806 L
.34946 .9045 L
.33974 .90395 L
.33391 .9084 L
.33205 .91873 L
.33003 .92138 L
.32032 .91884 L
.31061 .92255 L
.30089 .92844 L
.30067 .92907 L
.2973 .93941 L
.29175 .94975 L
.29118 .9505 L
.28446 .96009 L
.28147 .96334 L
.27457 .97043 L
.27176 .97306 L
.26204 .97094 L
.25557 .98077 L
s
.24912 .98077 m
.24262 .9707 L
.23574 .98077 L
s
.9074 .01923 m
.90307 .02019 L
.89763 .01923 L
s
.85506 .01923 m
.85451 .01958 L
.85307 .01923 L
s
.3309 .01923 m
.33003 .01936 L
.32713 .01923 L
s
.29981 .01923 m
.30089 .01942 L
.31061 .02241 L
.31744 .02957 L
.31471 .03991 L
.31736 .05025 L
.32032 .0596 L
.33003 .05562 L
.33974 .05257 L
.3458 .06059 L
.33974 .07078 L
.3396 .07093 L
.33974 .07134 L
.34351 .08127 L
.33974 .08317 L
.33025 .08127 L
.33003 .08111 L
.32032 .07756 L
.31061 .08085 L
.31025 .08127 L
.31061 .08191 L
.32032 .08473 L
.32818 .0916 L
.32792 .10194 L
.32032 .10715 L
.31061 .10765 L
.30089 .11067 L
.29118 .10601 L
.28147 .10513 L
.27362 .10194 L
.27176 .10054 L
.2678 .0916 L
.27176 .08789 L
.28147 .08294 L
.29118 .08366 L
.29922 .08127 L
.29898 .07093 L
.29118 .06487 L
.2818 .06059 L
.28147 .06025 L
.27511 .05025 L
.27176 .0467 L
.26749 .03991 L
.27176 .03878 L
.27397 .03991 L
.28147 .0478 L
.28946 .05025 L
.29118 .05101 L
.30089 .054 L
.3083 .06059 L
Mistroke
.31061 .06401 L
.31568 .06059 L
.31061 .05806 L
.30425 .05025 L
.30318 .03991 L
.30089 .03866 L
.29118 .03426 L
.28303 .02957 L
.28147 .02548 L
.27176 .02153 L
.26204 .02092 L
.25233 .02939 L
.24262 .0256 L
.24111 .01923 L
Mfstroke
.58256 .95551 m
.58647 .96009 L
.58256 .96699 L
.57896 .96009 L
.58256 .95551 L
s
.82537 .94495 m
.83003 .94975 L
.83508 .95377 L
.8405 .96009 L
.83508 .96495 L
.82863 .96009 L
.82537 .95571 L
.81899 .94975 L
.82537 .94495 L
s
.39802 .94911 m
.40249 .94975 L
.39802 .9569 L
.39685 .94975 L
.39802 .94911 L
s
.04837 .93973 m
.05491 .94975 L
.04837 .95974 L
.04555 .94975 L
.04837 .93973 L
s
.63112 .93445 m
.63619 .93941 L
.63112 .94693 L
.62538 .93941 L
.63112 .93445 L
s
.11636 .92861 m
.11685 .92907 L
.12607 .93254 L
.13578 .93485 L
.14177 .93941 L
.13578 .9451 L
.12607 .9483 L
.12285 .94975 L
.12607 .95427 L
.12924 .96009 L
.12607 .96557 L
.11636 .96683 L
.10664 .9651 L
.10175 .96009 L
.10664 .95525 L
.11342 .94975 L
.11472 .93941 L
.11505 .92907 L
.11636 .92861 L
s
.57284 .91269 m
.5797 .91873 L
.57284 .92727 L
.56799 .91873 L
.57284 .91269 L
s
.12607 .91856 m
.13578 .91778 L
.14549 .91256 L
.15009 .91873 L
.14549 .92059 L
.13578 .91883 L
.12607 .91899 L
.12556 .91873 L
.12607 .91856 L
s
.05808 .91868 m
.05833 .91873 L
.06021 .92907 L
.05808 .93181 L
.05727 .92907 L
.05799 .91873 L
.05808 .91868 L
s
.46601 .87576 m
.47003 .87738 L
.46601 .88721 L
.46508 .87738 L
.46601 .87576 L
s
.11636 .85344 m
.12029 .8567 L
.11636 .85987 L
.1126 .8567 L
.11636 .85344 L
s
.11636 .83511 m
.12156 .83602 L
.11636 .83611 L
.11605 .83602 L
.11636 .83511 L
s
.50486 .81982 m
.50694 .82568 L
.50486 .82924 L
.50195 .82568 L
.50486 .81982 L
s
.37859 .81945 m
.38122 .82568 L
.37859 .82913 L
.37256 .82568 L
.37859 .81945 L
s
.66997 .77606 m
.67449 .78433 L
.66997 .79119 L
.66083 .78433 L
.66997 .77606 L
s
.50486 .77824 m
.50817 .78433 L
.50619 .79467 L
.50486 .7989 L
.50141 .79467 L
.50029 .78433 L
.50486 .77824 L
s
.10664 .7813 m
.11636 .78252 L
.11927 .78433 L
.11636 .7892 L
.11232 .79467 L
.11278 .805 L
.11636 .80553 L
.11711 .805 L
.12607 .79567 L
.13578 .80074 L
.14549 .80207 L
.15521 .80079 L
.16492 .80194 L
.16875 .805 L
.16492 .81293 L
.16032 .81534 L
.16138 .82568 L
.15521 .82877 L
.14549 .82991 L
.13578 .83548 L
.12607 .83566 L
.11901 .82568 L
.11636 .82253 L
.10664 .82488 L
.10618 .82568 L
.09693 .83543 L
.09637 .83602 L
.09331 .84636 L
.09404 .8567 L
.08722 .86304 L
.07834 .8567 L
.07933 .84636 L
.08387 .83602 L
.08446 .82568 L
.085 .81534 L
.08722 .80929 L
.09014 .805 L
.09693 .79497 L
.09732 .79467 L
.10407 .78433 L
.10664 .7813 L
s
.55342 .77098 m
.55768 .77399 L
.56306 .78433 L
.55949 .79467 L
.55821 .805 L
.55342 .81403 L
.54691 .805 L
.55059 .79467 L
.54977 .78433 L
.55129 .77399 L
.55342 .77098 L
s
.17463 .76915 m
.18104 .77399 L
.17463 .7793 L
.16934 .77399 L
.17463 .76915 L
s
.67968 .75595 m
.68466 .76365 L
.67968 .77056 L
.67328 .76365 L
.67968 .75595 L
s
.70882 .74732 m
.71139 .75331 L
.70882 .75751 L
.70521 .75331 L
.70882 .74732 L
s
.11636 .74663 m
.12607 .74603 L
.12851 .75331 L
.12607 .75532 L
.11941 .76365 L
.11636 .76508 L
.11494 .76365 L
.11119 .75331 L
.11636 .74663 L
s
.68939 .74238 m
.68954 .74297 L
.68939 .74429 L
.68885 .74297 L
.68939 .74238 L
s
.43687 .7302 m
.43789 .73263 L
.43687 .73852 L
.43222 .73263 L
.43687 .7302 L
s
.39802 .72307 m
.40189 .73263 L
.39802 .73755 L
.39556 .73263 L
.39802 .72307 L
s
.66026 .71008 m
.66068 .71195 L
.66026 .71311 L
.65736 .71195 L
.66026 .71008 L
s
.10664 .69635 m
.11406 .70161 L
.11636 .70446 L
.12403 .71195 L
.12607 .71332 L
.13325 .72229 L
.12607 .72674 L
.11636 .72695 L
.10664 .72243 L
.1065 .72229 L
.10048 .71195 L
.09738 .70161 L
.10664 .69635 L
s
.68939 .69063 m
.6896 .69127 L
.68939 .69163 L
.68898 .69127 L
.68939 .69063 L
s
.73796 .67865 m
.73992 .68093 L
.73827 .69127 L
.73796 .69136 L
.73587 .69127 L
.73311 .68093 L
.73796 .67865 L
s
.66026 .6784 m
.66613 .68093 L
.66026 .68842 L
.65773 .68093 L
.66026 .6784 L
s
.20377 .66819 m
.20896 .6706 L
.20722 .68093 L
.20377 .68389 L
.19875 .68093 L
.19948 .6706 L
.20377 .66819 L
s
.38831 .66007 m
.39669 .66026 L
.39802 .66106 L
.40186 .6706 L
.39802 .67417 L
.39522 .6706 L
.38831 .66049 L
.38815 .66026 L
.38831 .66007 L
s
.31061 .65726 m
.31442 .66026 L
.31363 .6706 L
.31061 .68015 L
.30562 .6706 L
.3058 .66026 L
.31061 .65726 L
s
.97106 .64983 m
.97278 .64992 L
.97106 .65217 L
.97035 .64992 L
.97106 .64983 L
s
.23291 .63929 m
.23314 .63958 L
.23291 .6409 L
.23273 .63958 L
.23291 .63929 L
s
.14549 .63709 m
.15424 .63958 L
.14549 .64685 L
.14285 .63958 L
.14549 .63709 L
s
.20377 .62642 m
.20729 .62924 L
.21348 .63368 L
.21621 .63958 L
.21348 .64274 L
.20377 .64505 L
.19406 .64665 L
.18434 .64724 L
.18123 .64992 L
.17463 .65559 L
.16492 .65551 L
.15932 .64992 L
.16442 .63958 L
.16492 .63944 L
.17463 .63281 L
.18434 .63464 L
.19406 .63188 L
.19856 .62924 L
.20377 .62642 L
s
.94192 .60635 m
.95163 .60572 L
.95774 .60856 L
.95163 .61827 L
.94192 .61181 L
.93419 .60856 L
.94192 .60635 L
s
.26204 .60774 m
.26472 .60856 L
.26204 .60991 L
.26108 .60856 L
.26204 .60774 L
s
.91278 .59694 m
.92249 .59431 L
.92547 .59822 L
.92249 .6028 L
.91278 .6005 L
.91019 .59822 L
.91278 .59694 L
s
.89336 .59505 m
.89998 .59822 L
.89336 .60453 L
.88548 .59822 L
.89336 .59505 L
s
.74767 .59754 m
.74859 .59822 L
.74767 .60359 L
.73817 .59822 L
.74767 .59754 L
s
.62141 .59665 m
.62203 .59822 L
.62141 .59885 L
.62089 .59822 L
.62141 .59665 L
s
.60198 .58945 m
.606 .59822 L
.60198 .6034 L
.59802 .59822 L
.60198 .58945 L
s
.28147 .58825 m
.29118 .59412 L
.30089 .59389 L
.30304 .59822 L
.30089 .60128 L
.29118 .59901 L
.28147 .59908 L
.28082 .59822 L
.28147 .58825 L
s
.25233 .57588 m
.25402 .57754 L
.25882 .58788 L
.25233 .59085 L
.24844 .58788 L
.24713 .57754 L
.25233 .57588 L
s
.86422 .56653 m
.86483 .5672 L
.86422 .56754 L
.86367 .5672 L
.86422 .56653 L
s
.83508 .5592 m
.84479 .56459 L
.84832 .5672 L
.84479 .56989 L
.83508 .57124 L
.82818 .5672 L
.83508 .5592 L
s
.44658 .56367 m
.44835 .5672 L
.44658 .57045 L
.44301 .5672 L
.44658 .56367 L
s
.27176 .5656 m
.27722 .5672 L
.27662 .57754 L
.27176 .58177 L
.27004 .57754 L
.26801 .5672 L
.27176 .5656 L
s
.79623 .54853 m
.80341 .55687 L
.79623 .562 L
.79164 .55687 L
.79623 .54853 L
s
.31061 .55186 m
.31426 .55687 L
.31061 .55855 L
.30107 .55687 L
.31061 .55186 L
s
.63112 .53888 m
.63787 .54653 L
.63112 .55165 L
.62277 .54653 L
.63112 .53888 L
s
.19406 .54287 m
.19812 .54653 L
.19406 .54821 L
.19212 .54653 L
.19406 .54287 L
s
.92249 .52605 m
.93023 .53619 L
.9235 .54653 L
.92249 .54721 L
.9141 .54653 L
.91457 .53619 L
.92249 .52605 L
s
.85451 .52618 m
.85881 .53619 L
.85451 .54026 L
.84812 .53619 L
.85451 .52618 L
s
.29118 .5348 m
.29464 .53619 L
.29118 .53875 L
.29057 .53619 L
.29118 .5348 L
s
.69911 .5241 m
.70084 .52585 L
.69911 .52999 L
.69788 .52585 L
.69911 .5241 L
s
.55342 .51751 m
.55458 .52585 L
.55342 .52629 L
.55282 .52585 L
.55342 .51751 L
s
.44658 .52569 m
.44671 .52585 L
.44658 .52855 L
.44276 .52585 L
.44658 .52569 L
s
.16492 .52105 m
.17077 .52585 L
.16492 .53107 L
.1597 .52585 L
.16492 .52105 L
s
.86422 .51016 m
.87393 .5105 L
.88364 .51143 L
.88843 .51551 L
.88364 .52292 L
.87838 .52585 L
.87393 .52609 L
.87013 .52585 L
.86422 .52301 L
.85633 .51551 L
.86422 .51016 L
s
.74767 .51351 m
.74885 .51551 L
.74767 .51597 L
.74639 .51551 L
.74767 .51351 L
s
.32032 .51434 m
.32131 .51551 L
.32032 .51604 L
.31788 .51551 L
.32032 .51434 L
s
.54371 .48109 m
.55342 .47565 L
.55797 .48449 L
.55342 .48789 L
.54371 .48521 L
.54286 .48449 L
.54371 .48109 L
s
.23291 .47879 m
.24262 .47841 L
.25097 .48449 L
.24262 .49194 L
.23291 .48789 L
.22508 .48449 L
.23291 .47879 L
s
.66997 .46142 m
.67595 .46381 L
.67968 .4654 L
.68481 .46381 L
.68939 .46315 L
.69014 .46381 L
.69911 .47335 L
.69954 .47415 L
.69911 .47776 L
.68939 .48292 L
.67968 .48002 L
.6702 .47415 L
.66997 .47388 L
.66668 .46381 L
.66997 .46142 L
s
.60198 .46368 m
.60297 .46381 L
.60198 .46787 L
.60139 .46381 L
.60198 .46368 L
s
.48543 .45812 m
.49128 .46381 L
.48543 .47013 L
.48185 .46381 L
.48543 .45812 L
s
.55342 .44714 m
.56313 .45292 L
.56633 .45347 L
.56888 .46381 L
.56726 .47415 L
.56313 .4777 L
.55539 .47415 L
.55702 .46381 L
.55342 .45631 L
.55178 .45347 L
.55342 .44714 L
s
.38831 .45186 m
.39243 .45347 L
.39224 .46381 L
.38831 .46523 L
.37859 .4696 L
.37367 .46381 L
.37859 .45791 L
.38559 .45347 L
.38831 .45186 L
s
.55342 .42614 m
.55556 .4328 L
.55342 .43854 L
.55078 .4328 L
.55342 .42614 L
s
.48543 .43029 m
.49202 .4328 L
.48543 .43675 L
.48428 .4328 L
.48543 .43029 L
s
.27176 .4324 m
.27404 .4328 L
.27573 .44313 L
.27282 .45347 L
.27176 .45701 L
.26984 .46381 L
.27176 .46614 L
.27405 .47415 L
.27176 .47554 L
.26204 .47687 L
.25863 .47415 L
.25849 .46381 L
.25966 .45347 L
.26104 .44313 L
.26204 .44195 L
.27154 .4328 L
.27176 .4324 L
s
.56313 .41908 m
.57284 .41957 L
.57731 .42246 L
.58256 .42719 L
.58901 .42246 L
.59227 .41882 L
.59609 .42246 L
.60198 .43049 L
.61169 .43056 L
.6145 .4328 L
.61652 .44313 L
.62141 .44883 L
.63112 .44698 L
.63563 .45347 L
.64083 .46023 L
.64691 .46381 L
.65054 .46758 L
.6576 .47415 L
.66026 .47694 L
.66647 .48449 L
.66997 .49373 L
.67897 .49483 L
.67162 .50517 L
.67028 .51551 L
.66997 .51847 L
.66026 .52554 L
.66013 .52585 L
.65626 .53619 L
.65105 .54653 L
.65054 .54739 L
.6433 .55687 L
.64417 .5672 L
.64083 .57219 L
.63634 .57754 L
.63755 .58788 L
.64083 .59205 L
.64174 .59822 L
.64083 .59906 L
.64026 .59822 L
.63112 .58935 L
.62819 .58788 L
.62141 .5817 L
.61679 .57754 L
.61169 .57147 L
.60308 .5672 L
.60198 .56695 L
.6016 .5672 L
.60198 .56856 L
.60563 .57754 L
.60198 .58221 L
Mistroke
.59843 .57754 L
.59227 .571 L
.58781 .5672 L
.59135 .55687 L
.58256 .54741 L
.58204 .54653 L
.58256 .53673 L
.58387 .54653 L
.59227 .5561 L
.60198 .54676 L
.61145 .55687 L
.61169 .55718 L
.61471 .55687 L
.61994 .54653 L
.61169 .54145 L
.60198 .538 L
.60113 .53619 L
.59227 .53118 L
.58471 .52585 L
.58256 .52346 L
.58108 .51551 L
.58256 .51452 L
.59227 .50581 L
.59244 .50517 L
.59227 .50066 L
.59174 .49483 L
.59174 .48449 L
.59227 .48371 L
.59962 .47415 L
.59227 .46679 L
.58281 .46381 L
.59176 .45347 L
.5868 .44313 L
.58256 .43859 L
.57284 .43462 L
.57121 .4328 L
.56313 .42509 L
.5577 .42246 L
.56313 .41908 L
Mfstroke
.49514 .42188 m
.49644 .42246 L
.49514 .42378 L
.49491 .42246 L
.49514 .42188 L
s
.29118 .4114 m
.29131 .41212 L
.29118 .41232 L
.28869 .41212 L
.29118 .4114 L
s
.47572 .40001 m
.48543 .40059 L
.48753 .40178 L
.49514 .40818 L
.50486 .40932 L
.51021 .40178 L
.51457 .39725 L
.52276 .40178 L
.51757 .41212 L
.52071 .42246 L
.52428 .42469 L
.5272 .4328 L
.53399 .44262 L
.53466 .44313 L
.53598 .45347 L
.53785 .46381 L
.53399 .4681 L
.52428 .46725 L
.52031 .46381 L
.52027 .45347 L
.52428 .44691 L
.5282 .44313 L
.52428 .44003 L
.51883 .4328 L
.51457 .42628 L
.51065 .4328 L
.5094 .44313 L
.51103 .45347 L
.50944 .46381 L
.50486 .4681 L
.49893 .47415 L
.49514 .47958 L
.48543 .4842 L
.47719 .47415 L
.47572 .47403 L
.47557 .47415 L
.47572 .47564 L
.48517 .48449 L
.48543 .48526 L
.49514 .49391 L
.49717 .49483 L
.50486 .50005 L
.50644 .50517 L
.50486 .50988 L
.49883 .51551 L
.49514 .52032 L
.49128 .51551 L
.48593 .50517 L
.48543 .50485 L
.48277 .49483 L
Mistroke
.47572 .48755 L
.46952 .49483 L
.46601 .50485 L
.45629 .499 L
.45046 .49483 L
.44658 .49473 L
.44648 .49483 L
.44658 .50046 L
.45231 .50517 L
.45629 .50801 L
.46371 .51551 L
.46601 .51727 L
.47572 .52053 L
.47622 .52585 L
.48087 .53619 L
.47869 .54653 L
.47749 .55687 L
.47572 .55881 L
.46997 .5672 L
.46601 .56925 L
.46286 .5672 L
.46114 .55687 L
.45629 .54855 L
.44658 .55123 L
.44106 .54653 L
.4371 .53619 L
.43687 .53571 L
.42716 .53036 L
.42247 .52585 L
.41744 .51631 L
.4168 .51551 L
.41744 .50557 L
.41756 .50517 L
.42057 .49483 L
.41744 .48712 L
.41348 .48449 L
.40773 .48159 L
.40406 .47415 L
.40146 .46381 L
.40773 .45937 L
.41314 .45347 L
.41744 .44452 L
.42716 .44566 L
.43038 .44313 L
.43687 .43676 L
.44658 .4392 L
.45159 .4328 L
.45629 .42954 L
.46563 .4328 L
.46601 .4329 L
Mistroke
.46612 .4328 L
.46626 .42246 L
.47273 .41212 L
.4732 .40178 L
.47572 .40001 L
Mfstroke
.88364 .39065 m
.89336 .38715 L
.899 .39144 L
.89336 .39538 L
.88364 .39155 L
.88337 .39144 L
.88364 .39065 L
s
.33003 .38966 m
.33952 .39144 L
.33003 .39196 L
.32185 .39144 L
.33003 .38966 L
s
.23291 .39063 m
.24262 .38734 L
.24298 .39144 L
.24262 .39215 L
.2334 .40178 L
.23291 .40252 L
.22319 .40221 L
.22211 .40178 L
.22319 .39179 L
.22356 .39144 L
.23291 .39063 L
s
.66026 .3775 m
.66253 .3811 L
.66997 .38358 L
.67968 .38556 L
.68939 .39019 L
.69193 .39144 L
.69911 .3934 L
.70882 .3933 L
.71765 .39144 L
.71853 .39107 L
.72786 .39144 L
.72824 .39149 L
.73796 .39315 L
.74767 .39208 L
.75738 .3935 L
.76709 .39491 L
.77681 .39886 L
.78094 .40178 L
.78652 .40506 L
.79623 .4118 L
.79654 .41212 L
.80471 .42246 L
.80594 .42441 L
.81566 .43244 L
.81588 .4328 L
.82292 .44313 L
.82537 .44668 L
.82889 .45347 L
.83148 .46381 L
.83508 .46947 L
.83698 .47415 L
.84479 .48341 L
.84673 .48449 L
.84819 .49483 L
.84479 .49803 L
.83508 .50496 L
.82537 .50169 L
.81948 .49483 L
.82537 .48459 L
.82543 .48449 L
.83261 .47415 L
.82537 .46496 L
.82406 .46381 L
.82225 .45347 L
.81566 .44416 L
.81507 .44313 L
.80594 .4332 L
.80553 .4328 L
.79623 .42481 L
.79285 .42246 L
Mistroke
.78652 .41553 L
.77681 .41242 L
.77543 .41212 L
.76709 .40575 L
.75738 .40434 L
.74767 .40276 L
.73796 .40257 L
.72824 .40232 L
.71853 .40392 L
.70882 .40873 L
.70599 .41212 L
.70219 .42246 L
.70882 .4324 L
.70925 .4328 L
.71853 .43933 L
.72824 .43513 L
.73796 .43414 L
.73957 .4328 L
.74767 .42816 L
.75738 .4288 L
.76362 .4328 L
.76709 .43571 L
.77681 .43961 L
.78054 .44313 L
.78652 .44929 L
.78947 .45347 L
.79544 .46381 L
.79623 .46503 L
.80142 .47415 L
.80594 .4771 L
.81552 .48449 L
.80594 .48941 L
.79623 .48746 L
.78652 .48695 L
.77835 .48449 L
.77681 .48384 L
.76709 .48032 L
.75738 .47756 L
.75346 .47415 L
.74767 .4715 L
.73796 .46901 L
.72824 .46772 L
.71853 .46502 L
.71721 .46381 L
.70882 .45824 L
.70337 .45347 L
.69911 .451 L
.68939 .45008 L
.67968 .44603 L
.67392 .44313 L
Mistroke
.66997 .43654 L
.66844 .4328 L
.66252 .42246 L
.66132 .41212 L
.66116 .40178 L
.66026 .39526 L
.65923 .39144 L
.65743 .3811 L
.66026 .3775 L
Mfstroke
.41744 .37755 m
.42324 .3811 L
.42517 .39144 L
.42327 .40178 L
.41744 .40904 L
.41709 .41212 L
.40948 .42246 L
.40773 .42503 L
.39802 .42938 L
.39133 .4328 L
.38831 .43384 L
.37859 .43766 L
.36888 .44207 L
.36577 .44313 L
.35917 .44714 L
.34946 .45034 L
.33974 .44912 L
.33003 .45134 L
.32406 .45347 L
.32032 .45561 L
.31394 .46381 L
.31061 .46615 L
.30089 .46555 L
.29118 .46831 L
.28325 .46381 L
.28723 .45347 L
.29051 .44313 L
.29118 .44258 L
.30089 .43282 L
.30092 .4328 L
.31061 .42685 L
.3152 .42246 L
.32032 .41773 L
.32568 .41212 L
.33003 .41018 L
.33974 .40855 L
.34946 .41015 L
.35533 .41212 L
.35917 .41914 L
.36324 .42246 L
.36888 .42602 L
.37638 .42246 L
.37859 .42084 L
.3882 .41212 L
.38761 .40178 L
.37859 .39294 L
.37138 .39144 L
.37859 .38679 L
.38831 .38676 L
.39802 .38669 L
Mistroke
.40773 .38362 L
.41034 .3811 L
.41744 .37755 L
Mfstroke
.89336 .36473 m
.90307 .36076 L
.91034 .37076 L
.90307 .37516 L
.89336 .37481 L
.88598 .37076 L
.89336 .36473 L
s
.22319 .36846 m
.23291 .36334 L
.23754 .37076 L
.23291 .37601 L
.22319 .37524 L
.22247 .37076 L
.22319 .36846 L
s
.96134 .34967 m
.96899 .35008 L
.96134 .35051 L
.96122 .35008 L
.96134 .34967 L
s
.66997 .34985 m
.6746 .35008 L
.66997 .35563 L
.66966 .35008 L
.66997 .34985 L
s
.42716 .34392 m
.43031 .35008 L
.42716 .35291 L
.42578 .35008 L
.42716 .34392 L
s
.16492 .31951 m
.17368 .3294 L
.16729 .33974 L
.16492 .34231 L
.15521 .34704 L
.15313 .33974 L
.15521 .33245 L
.15663 .3294 L
.16492 .31951 L
s
.17463 .3005 m
.1767 .30873 L
.17755 .31907 L
.17463 .32701 L
.16541 .31907 L
.16751 .30873 L
.17463 .3005 L
s
.94192 .29509 m
.9451 .29839 L
.94192 .30264 L
.93556 .29839 L
.94192 .29509 L
s
.88364 .2562 m
.89336 .25201 L
.89968 .25703 L
.90307 .2589 L
.91278 .26319 L
.92249 .26721 L
.9227 .26737 L
.93221 .26939 L
.93441 .26737 L
.94192 .26312 L
.94454 .26737 L
.95163 .27506 L
.95533 .27771 L
.95278 .28805 L
.95943 .29839 L
.96134 .30625 L
.96384 .30873 L
.97103 .31907 L
.97106 .31979 L
.97779 .3294 L
.97106 .33659 L
.96407 .3294 L
.96134 .32767 L
.95163 .32551 L
.94441 .31907 L
.94192 .3156 L
.93221 .31167 L
.92825 .30873 L
.92319 .29839 L
.92249 .29706 L
.91718 .28805 L
.91278 .28664 L
.90532 .27771 L
.90307 .27645 L
.89336 .2772 L
.89062 .26737 L
.88364 .25729 L
.88337 .25703 L
.88364 .2562 L
s
.15521 .20482 m
.1554 .20533 L
.15521 .20574 L
.15242 .20533 L
.15521 .20482 L
s
.75738 .18449 m
.7575 .18466 L
.76524 .195 L
.75738 .19911 L
.75065 .195 L
.75606 .18466 L
.75738 .18449 L
s
.84479 .17146 m
.8516 .17432 L
.85451 .18077 L
.86351 .18466 L
.86422 .18526 L
.8732 .195 L
.87393 .19536 L
.88364 .20215 L
.88728 .20533 L
.89336 .20993 L
.90307 .2144 L
.90872 .21567 L
.91278 .22192 L
.91502 .22601 L
.92249 .23248 L
.92859 .23635 L
.92249 .2461 L
.92099 .24669 L
.91278 .24754 L
.9075 .24669 L
.90307 .24494 L
.89629 .23635 L
.89336 .23448 L
.88364 .23089 L
.87393 .229 L
.87154 .22601 L
.86422 .21793 L
.86113 .21567 L
.85451 .21336 L
.84479 .21143 L
.84252 .20533 L
.83812 .195 L
.83508 .19291 L
.8268 .18466 L
.83508 .17614 L
.83698 .17432 L
.84479 .17146 L
s
.13578 .16947 m
.14202 .17432 L
.13578 .17967 L
.13404 .17432 L
.13578 .16947 L
s
.30089 .16282 m
.31061 .15844 L
.31722 .16398 L
.31536 .17432 L
.31061 .18024 L
.30102 .18466 L
.30089 .18476 L
.29118 .19364 L
.28844 .195 L
.28147 .20433 L
.27991 .20533 L
.27176 .20973 L
.26212 .21567 L
.26204 .21595 L
.2591 .22601 L
.25233 .23307 L
.24262 .23587 L
.24232 .23635 L
.23291 .24448 L
.22802 .24669 L
.22319 .25131 L
.21494 .25703 L
.22102 .26737 L
.21348 .27329 L
.20392 .27771 L
.20377 .27788 L
.19737 .28805 L
.19406 .29278 L
.18463 .29839 L
.18434 .29853 L
.17558 .29839 L
.17848 .28805 L
.18343 .27771 L
.18434 .27651 L
.19406 .27747 L
.19635 .26737 L
.19406 .26586 L
.18874 .25703 L
.19406 .2535 L
.20376 .24669 L
.20377 .24668 L
.21295 .23635 L
.21348 .23601 L
.22319 .22621 L
.22359 .22601 L
.23291 .21729 L
.23367 .21567 L
.24262 .20946 L
.24952 .20533 L
.25233 .20089 L
Mistroke
.26204 .19674 L
.26287 .195 L
.26567 .18466 L
.27176 .18205 L
.28147 .18043 L
.29118 .17697 L
.29283 .17432 L
.29767 .16398 L
.30089 .16282 L
Mfstroke
.17463 .15429 m
.18201 .16398 L
.17463 .17086 L
.16559 .16398 L
.17463 .15429 L
s
.14549 .1637 m
.14973 .16398 L
.14549 .16678 L
.14481 .16398 L
.14549 .1637 L
s
.20377 .15346 m
.20514 .15364 L
.20931 .16398 L
.20377 .16935 L
.19942 .16398 L
.20298 .15364 L
.20377 .15346 L
s
.13578 .13867 m
.14549 .13571 L
.15235 .1433 L
.14549 .14974 L
.13578 .14793 L
.13334 .1433 L
.13578 .13867 L
s
.10664 .1168 m
.11193 .12262 L
.10664 .12704 L
.10401 .12262 L
.10664 .1168 L
s
.22319 .11041 m
.22637 .11228 L
.22319 .11562 L
.21901 .11228 L
.22319 .11041 L
s
.11636 .10786 m
.12328 .11228 L
.11636 .1163 L
.11151 .11228 L
.11636 .10786 L
s
.20377 .09389 m
.21197 .10194 L
.20377 .1067 L
.19432 .10194 L
.20377 .09389 L
s
.18434 .0954 m
.19359 .10194 L
.18434 .10484 L
.17483 .10194 L
.18434 .0954 L
s
.92249 .08745 m
.93221 .0859 L
.93244 .0916 L
.93221 .09183 L
.92249 .093 L
.92064 .0916 L
.92249 .08745 L
s
.89336 .08871 m
.90307 .09044 L
.90475 .0916 L
.90307 .09305 L
.89336 .09401 L
.88805 .0916 L
.89336 .08871 L
s
.20377 .07645 m
.21201 .08127 L
.20377 .08932 L
.19897 .08127 L
.20377 .07645 L
s
.21348 .06258 m
.22137 .07093 L
.21348 .07857 L
.20972 .07093 L
.21348 .06258 L
s
.77681 .03974 m
.77791 .03991 L
.77698 .05025 L
.77681 .05044 L
.76816 .05025 L
.7764 .03991 L
.77681 .03974 L
s
.55342 .0368 m
.56313 .0351 L
.56891 .03991 L
.56313 .04846 L
.56172 .05025 L
.55342 .05588 L
.54371 .05624 L
.53627 .05025 L
.54371 .04217 L
.54805 .03991 L
.55342 .0368 L
s
.17463 .02976 m
.18434 .02997 L
.18621 .03991 L
.19406 .04494 L
.20105 .05025 L
.19483 .06059 L
.19406 .06333 L
.18434 .06869 L
.18053 .06059 L
.18434 .05301 L
.18751 .05025 L
.18434 .04214 L
.17463 .04454 L
.16927 .03991 L
.17463 .02976 L
s
.13578 .03652 m
.14115 .03991 L
.13578 .04149 L
.13501 .03991 L
.13578 .03652 L
s
.19406 .02476 m
.19566 .02957 L
.19406 .037 L
.18455 .02957 L
.19406 .02476 L
s
.98077 .892 m
.97106 .89218 L
.96134 .89245 L
.95211 .88772 L
.95163 .88697 L
.94851 .87738 L
.95163 .87525 L
.9542 .87738 L
.96134 .88093 L
.97106 .8817 L
.98077 .88475 L
s
.98077 .58934 m
.97106 .59311 L
.96134 .58944 L
.95725 .58788 L
.95163 .58409 L
.9497 .57754 L
.95163 .5692 L
.96134 .57741 L
.97106 .57479 L
.97889 .57754 L
.98077 .58203 L
s
.98077 .36672 m
.97172 .36042 L
.98059 .35008 L
.98077 .34993 L
s
.59023 .98077 m
.58256 .97701 L
.5777 .98077 L
s
.68591 .98077 m
.67968 .97358 L
.67547 .97043 L
.6737 .96009 L
.66997 .95563 L
.66175 .96009 L
.66212 .97043 L
.66026 .97541 L
.65594 .97043 L
.65054 .96438 L
.64117 .97043 L
.64083 .97049 L
.63112 .97481 L
.62683 .97043 L
.62141 .96849 L
.61414 .96009 L
.62141 .95079 L
.62258 .94975 L
.62141 .94846 L
.61399 .93941 L
.62128 .92907 L
.62102 .91873 L
.62141 .91633 L
.62334 .9084 L
.62141 .90289 L
.61169 .90335 L
.60433 .9084 L
.60198 .90954 L
.59765 .9084 L
.59227 .90714 L
.58256 .89814 L
.58234 .89806 L
.57383 .88772 L
.57678 .87738 L
.57839 .86704 L
.58053 .8567 L
.58256 .85174 L
.58429 .84636 L
.58256 .84056 L
.58162 .83602 L
.58256 .83432 L
.58863 .82568 L
.58905 .81534 L
.58521 .805 L
.58256 .80204 L
.58069 .805 L
.57868 .81534 L
.57284 .82559 L
.57259 .82568 L
.56728 .83602 L
Mistroke
.56313 .84251 L
.55342 .84294 L
.54968 .83602 L
.5458 .82568 L
.55223 .81534 L
.54371 .81272 L
.54284 .81534 L
.54113 .82568 L
.53406 .83602 L
.53408 .84636 L
.53399 .84652 L
.52428 .8548 L
.51595 .84636 L
.51457 .84383 L
.51006 .84636 L
.50495 .8567 L
.50494 .86704 L
.50958 .87738 L
.51096 .88772 L
.51457 .89387 L
.51951 .88772 L
.52428 .87974 L
.53399 .8842 L
.53625 .88772 L
.54113 .89806 L
.54287 .9084 L
.54167 .91873 L
.54136 .92907 L
.5401 .93941 L
.53399 .9474 L
.5285 .93941 L
.52428 .93241 L
.52116 .92907 L
.51818 .91873 L
.51981 .9084 L
.51457 .90021 L
.50873 .9084 L
.50486 .91401 L
.4975 .9084 L
.49514 .90224 L
.49257 .89806 L
.48899 .88772 L
.49044 .87738 L
.48543 .87131 L
.48017 .87738 L
.47945 .88772 L
.47572 .89675 L
.46601 .88803 L
.45629 .89658 L
.45563 .89806 L
Mistroke
.45629 .90462 L
.45835 .9084 L
.45984 .91873 L
.45641 .92907 L
.46196 .93941 L
.46601 .94859 L
.468 .93941 L
.47554 .92907 L
.47572 .92889 L
.48523 .91873 L
.48543 .91857 L
.49514 .91157 L
.50278 .91873 L
.50486 .92343 L
.50907 .92907 L
.51365 .93941 L
.51457 .94301 L
.518 .94975 L
.52428 .95388 L
.5335 .96009 L
.53399 .96346 L
.53409 .97043 L
.53399 .97116 L
.52428 .98012 L
.51457 .97054 L
.51137 .98077 L
Mfstroke
.47071 .98077 m
.46844 .97043 L
.4664 .96009 L
.46601 .95634 L
.45629 .958 L
.45236 .96009 L
.44658 .96487 L
.44285 .97043 L
.44658 .97867 L
.45082 .98077 L
s
.81118 .98077 m
.81036 .97043 L
.80922 .96009 L
.80594 .95536 L
.80173 .94975 L
.79623 .94877 L
.78652 .94279 L
.77681 .94663 L
.76709 .9496 L
.76103 .93941 L
.75749 .92907 L
.75738 .9288 L
.74767 .92029 L
.74718 .91873 L
.74447 .9084 L
.74284 .89806 L
.74767 .88788 L
.75738 .89074 L
.76003 .88772 L
.75738 .88464 L
.75641 .87738 L
.75738 .87264 L
.75996 .86704 L
.75738 .86409 L
.74767 .86367 L
.73796 .86108 L
.72824 .86681 L
.71853 .85953 L
.70882 .85886 L
.69911 .85992 L
.69713 .8567 L
.69567 .84636 L
.6954 .83602 L
.69355 .82568 L
.68939 .82234 L
.68186 .82568 L
.68206 .83602 L
.67968 .83829 L
.67519 .83602 L
.66997 .83113 L
.66504 .82568 L
.66572 .81534 L
.66026 .81361 L
.65354 .805 L
.65063 .79467 L
.65641 .78433 L
.65291 .77399 L
.65054 .77238 L
.64677 .76365 L
.65054 .75998 L
Mistroke
.66026 .75354 L
.66035 .75331 L
.66836 .74297 L
.66997 .74017 L
.67377 .73263 L
.67877 .72229 L
.67968 .72091 L
.68443 .71195 L
.67968 .70436 L
.67466 .70161 L
.67016 .69127 L
.67218 .68093 L
.66997 .67771 L
.66696 .6706 L
.66741 .66026 L
.66997 .65431 L
.67226 .64992 L
.66997 .64077 L
.66804 .63958 L
.66997 .63088 L
.67007 .62924 L
.66997 .6284 L
.66813 .6189 L
.66693 .60856 L
.66873 .59822 L
.66634 .58788 L
.66888 .57754 L
.66026 .57216 L
.65543 .5672 L
.66026 .56149 L
.66997 .56606 L
.67023 .5672 L
.67056 .57754 L
.67331 .58788 L
.67233 .59822 L
.67467 .60856 L
.67968 .61392 L
.6857 .6189 L
.68939 .62021 L
.69086 .6189 L
.69911 .61307 L
.70591 .6189 L
.70882 .62049 L
.71357 .6189 L
.71853 .61371 L
.72317 .6189 L
.72824 .62368 L
.73452 .62924 L
.73796 .6296 L
.74767 .63359 L
Mistroke
.75738 .63338 L
.76709 .63721 L
.7697 .63958 L
.77221 .64992 L
.77681 .65367 L
.78153 .64992 L
.78379 .63958 L
.78652 .63122 L
.78669 .62924 L
.78652 .629 L
.77833 .6189 L
.77681 .61668 L
.76709 .60945 L
.76625 .60856 L
.76709 .60632 L
.77681 .6071 L
.77965 .60856 L
.78652 .6123 L
.79007 .60856 L
.79378 .59822 L
.78652 .59205 L
.77681 .58962 L
.77487 .58788 L
.76709 .5811 L
.76138 .57754 L
.75928 .5672 L
.75852 .55687 L
.75738 .55403 L
.74989 .54653 L
.74767 .54371 L
.73796 .53804 L
.73499 .53619 L
.73796 .53208 L
.74767 .53284 L
.75738 .53047 L
.76709 .52632 L
.76734 .52585 L
.76709 .52538 L
.76453 .51551 L
.76709 .51362 L
.77334 .51551 L
.77681 .51789 L
.78247 .52585 L
.78652 .52774 L
.78895 .52585 L
.79623 .51737 L
.8 .52585 L
.80594 .53023 L
.81566 .52969 L
.82509 .53619 L
Mistroke
.82106 .54653 L
.82537 .55153 L
.82937 .54653 L
.82683 .53619 L
.82537 .53601 L
.8197 .52585 L
.82537 .52272 L
.8349 .52585 L
.83508 .52618 L
.84017 .53619 L
.84133 .54653 L
.84479 .55046 L
.85451 .55174 L
.86422 .55479 L
.87393 .5542 L
.87979 .54653 L
.88364 .54327 L
.89336 .54132 L
.90307 .5403 L
.91206 .54653 L
.90307 .55651 L
.90289 .55687 L
.89336 .56054 L
.88364 .56011 L
.87445 .5672 L
.88364 .57347 L
.89321 .57754 L
.89336 .57762 L
.90089 .57754 L
.90307 .5763 L
.90629 .5672 L
.91278 .56472 L
.92153 .5672 L
.92249 .5673 L
.92747 .57754 L
.93221 .58488 L
.93672 .57754 L
.93221 .57229 L
.92287 .5672 L
.93221 .561 L
.94014 .55687 L
.94192 .55586 L
.95163 .54888 L
.95185 .54653 L
.95163 .54635 L
.94192 .53888 L
.93877 .53619 L
.93221 .53281 L
.92314 .52585 L
.92278 .51551 L
Mistroke
.92249 .51532 L
.91278 .51345 L
.9097 .51551 L
.90994 .52585 L
.90307 .53172 L
.90019 .52585 L
.89959 .51551 L
.89885 .50517 L
.89671 .49483 L
.90307 .49071 L
.90917 .48449 L
.90307 .47864 L
.89336 .47573 L
.89034 .47415 L
.89336 .46784 L
.89713 .46381 L
.89336 .46224 L
.88752 .45347 L
.89336 .44893 L
.89836 .44313 L
.89336 .4362 L
.88767 .4328 L
.88364 .42876 L
.87726 .42246 L
.87393 .41858 L
.86624 .41212 L
.86553 .40178 L
.86422 .39813 L
.85451 .39225 L
.85223 .39144 L
.85201 .3811 L
.84807 .37076 L
.85451 .36707 L
.86422 .36309 L
.87261 .36042 L
.87313 .35008 L
.87372 .33974 L
.87235 .3294 L
.86422 .32469 L
.85451 .32055 L
.84479 .32106 L
.84127 .31907 L
.84405 .30873 L
.83508 .30451 L
.83027 .29839 L
.82537 .29203 L
.82152 .28805 L
.81566 .28344 L
.80594 .28147 L
.80047 .27771 L
Mistroke
.79623 .27317 L
.78652 .2677 L
.78541 .26737 L
.77681 .26397 L
.76885 .25703 L
.76709 .25578 L
.76335 .24669 L
.75738 .24165 L
.74767 .23886 L
.74557 .23635 L
.74767 .23461 L
.75738 .23489 L
.76138 .23635 L
.76709 .24079 L
.77681 .24146 L
.78652 .23885 L
.78836 .23635 L
.78652 .23272 L
.77681 .227 L
.77525 .22601 L
.76709 .22013 L
.76149 .21567 L
.75738 .21142 L
.75366 .20533 L
.74767 .19817 L
.74508 .195 L
.73796 .18941 L
.73236 .18466 L
.72824 .18131 L
.72136 .17432 L
.72824 .16876 L
.73683 .16398 L
.72824 .15588 L
.72572 .15364 L
.71853 .14678 L
.71602 .1433 L
.70882 .13811 L
.69911 .13505 L
.69553 .13296 L
.68939 .12735 L
.67978 .12262 L
.67968 .12244 L
.67625 .11228 L
.66997 .10838 L
.66037 .10194 L
.66026 .10129 L
.65538 .0916 L
.65054 .09127 L
.64083 .08726 L
.63625 .08127 L
Mistroke
.63112 .07705 L
.62141 .0724 L
.61831 .07093 L
.61169 .06857 L
.60198 .06681 L
.59227 .06294 L
.58256 .0634 L
.57284 .06132 L
.56313 .06409 L
.55342 .06942 L
.55186 .07093 L
.55342 .0792 L
.55405 .08127 L
.55342 .08216 L
.55303 .0916 L
.55342 .09219 L
.56223 .10194 L
.56313 .10308 L
.57284 .11123 L
.57435 .11228 L
.58068 .12262 L
.58256 .13098 L
.58338 .13296 L
.59227 .14094 L
.59456 .1433 L
.60198 .14505 L
.6063 .15364 L
.60729 .16398 L
.60198 .17202 L
.5994 .17432 L
.59227 .18066 L
.58256 .17917 L
.57442 .17432 L
.57284 .17288 L
.56313 .16931 L
.55342 .1656 L
.55 .16398 L
.54371 .16303 L
.53399 .16134 L
.52428 .1635 L
.52256 .16398 L
.51457 .16905 L
.50762 .17432 L
.50486 .17674 L
.49514 .17712 L
.48829 .17432 L
.48543 .17108 L
.48194 .16398 L
.48239 .15364 L
.48543 .15088 L
Mistroke
.49121 .1433 L
.49514 .1388 L
.50424 .13296 L
.50486 .13236 L
.51092 .12262 L
.51457 .11621 L
.51805 .11228 L
.52428 .10777 L
.52957 .10194 L
.53399 .09346 L
.53492 .0916 L
.5415 .08127 L
.53712 .07093 L
.53399 .06872 L
.52428 .06369 L
.51457 .0672 L
.50486 .06456 L
.49514 .06442 L
.48543 .06871 L
.47572 .07089 L
.47565 .07093 L
.46601 .07912 L
.46196 .08127 L
.45629 .08484 L
.44658 .09118 L
.44557 .0916 L
.43687 .0945 L
.42716 .09855 L
.42249 .10194 L
.41744 .10533 L
.40984 .11228 L
.40773 .11417 L
.39802 .11993 L
.39635 .12262 L
.39404 .13296 L
.38831 .13573 L
.37977 .1433 L
.37859 .14433 L
.37063 .15364 L
.36888 .15871 L
.36649 .16398 L
.35917 .16933 L
.35623 .17432 L
.34946 .18259 L
.34446 .18466 L
.33974 .18908 L
.33662 .195 L
.33974 .20414 L
.34946 .20246 L
.35136 .20533 L
Mistroke
.34946 .20664 L
.33974 .20625 L
.334 .21567 L
.33003 .21892 L
.32032 .22588 L
.32028 .22601 L
.32032 .22621 L
.33003 .23597 L
.33043 .23635 L
.33003 .2408 L
.32748 .24669 L
.32032 .25194 L
.31061 .25521 L
.30333 .25703 L
.30089 .25788 L
.29218 .26737 L
.29118 .26879 L
.28315 .27771 L
.28147 .27921 L
.27176 .28087 L
.26204 .2837 L
.25278 .28805 L
.25233 .2924 L
.24554 .29839 L
.24262 .30006 L
.23291 .30663 L
.23023 .30873 L
.22319 .31411 L
.21522 .31907 L
.21348 .32143 L
.20763 .3294 L
.20377 .33235 L
.19406 .33551 L
.19157 .33974 L
.18665 .35008 L
.18434 .35207 L
.17463 .35836 L
.17132 .36042 L
.16693 .37076 L
.16745 .3811 L
.16584 .39144 L
.16492 .39493 L
.15521 .40009 L
.15511 .40178 L
.15521 .4027 L
.15641 .41212 L
.15521 .42209 L
.15051 .41212 L
.14549 .40973 L
.14117 .41212 L
Mistroke
.13578 .42121 L
.1345 .42246 L
.1268 .4328 L
.1289 .44313 L
.13017 .45347 L
.12646 .46381 L
.12607 .4645 L
.12192 .47415 L
.11984 .48449 L
.11636 .48699 L
.10946 .49483 L
.10816 .50517 L
.10664 .50918 L
.10478 .51551 L
.10482 .52585 L
.09835 .53619 L
.09693 .54068 L
.09559 .54653 L
.09088 .55687 L
.08722 .56697 L
.08718 .5672 L
.08544 .57754 L
.07856 .58788 L
.08123 .59822 L
.07751 .6018 L
.0715 .60856 L
.06948 .6189 L
.06797 .62924 L
.06779 .62962 L
.06402 .63958 L
.06386 .64992 L
.06779 .65788 L
.06937 .66026 L
.07495 .6706 L
.07751 .67591 L
.08107 .68093 L
.08722 .68601 L
.09511 .68093 L
.09693 .6727 L
.09727 .6706 L
.09693 .67037 L
.09309 .66026 L
.09693 .65404 L
.10481 .64992 L
.10664 .64674 L
.11636 .64445 L
.12586 .64992 L
.12607 .65032 L
.13306 .64992 L
.12607 .64955 L
Mistroke
.12259 .63958 L
.12607 .63538 L
.13171 .62924 L
.13578 .62227 L
.14549 .62017 L
.14667 .6189 L
.14549 .61607 L
.13578 .6159 L
.12607 .61049 L
.11636 .60881 L
.11554 .60856 L
.11459 .59822 L
.11636 .59594 L
.12607 .59391 L
.13578 .59368 L
.14034 .59822 L
.14549 .60283 L
.15333 .59822 L
.15474 .58788 L
.15521 .58684 L
.16492 .57981 L
.17106 .58788 L
.17463 .59403 L
.17643 .58788 L
.17463 .58558 L
.16714 .57754 L
.17463 .57444 L
.18267 .5672 L
.18434 .56592 L
.19204 .5672 L
.19362 .57754 L
.19406 .57768 L
.20377 .58123 L
.21348 .58609 L
.21579 .58788 L
.21348 .59108 L
.20377 .59382 L
.19406 .59809 L
.19372 .59822 L
.18434 .60387 L
.1841 .60856 L
.18434 .60886 L
.19406 .61156 L
.20377 .61738 L
.21348 .61633 L
.22319 .60926 L
.23265 .6189 L
.23291 .61909 L
.24262 .62235 L
.25233 .62342 L
Mistroke
.26204 .6266 L
.27176 .62841 L
.2727 .62924 L
.27176 .63016 L
.26204 .63906 L
.26191 .63958 L
.26204 .64236 L
.26616 .64992 L
.27176 .6561 L
.2741 .66026 L
.28136 .6706 L
.28147 .67072 L
.29118 .67449 L
.30089 .67495 L
.31037 .68093 L
.31061 .6829 L
.32032 .68103 L
.32042 .68093 L
.32495 .6706 L
.32616 .66026 L
.33003 .65521 L
.33462 .66026 L
.33663 .6706 L
.33974 .68014 L
.34946 .67857 L
.35352 .6706 L
.35619 .66026 L
.35465 .64992 L
.34946 .64206 L
.3479 .63958 L
.3453 .62924 L
.34946 .62197 L
.35347 .6189 L
.35917 .61202 L
.36811 .6189 L
.36888 .61904 L
.36901 .6189 L
.36917 .60856 L
.37859 .6034 L
.38256 .59822 L
.38831 .59136 L
.39802 .59073 L
.40366 .59822 L
.40773 .60041 L
.40934 .60856 L
.40773 .61305 L
.4014 .6189 L
.40773 .62858 L
.41331 .62924 L
.41744 .6331 L
Mistroke
.41817 .63958 L
.41744 .64078 L
.40883 .64992 L
.41744 .6534 L
.42147 .66026 L
.42701 .6706 L
.41744 .67294 L
.41035 .68093 L
.41744 .68642 L
.42231 .69127 L
.42716 .69585 L
.4316 .70161 L
.43005 .71195 L
.42716 .71474 L
.41744 .71471 L
.41283 .72229 L
.41744 .73161 L
.41816 .73263 L
.41858 .74297 L
.42192 .75331 L
.42716 .76158 L
.42789 .76365 L
.42716 .76436 L
.41744 .76862 L
.41311 .77399 L
.41413 .78433 L
.41744 .78991 L
.42176 .79467 L
.41744 .79679 L
.415 .79467 L
.40773 .78879 L
.40118 .78433 L
.39982 .77399 L
.39802 .77274 L
.39108 .77399 L
.38831 .77716 L
.37859 .78157 L
.36888 .78072 L
.36779 .78433 L
.36888 .78725 L
.37859 .79173 L
.38203 .79467 L
.38831 .80086 L
.38942 .805 L
.38831 .8123 L
.37859 .81098 L
.36888 .80989 L
.35917 .81055 L
.35242 .81534 L
.35917 .82251 L
Mistroke
.3635 .82568 L
.35984 .83602 L
.36719 .84636 L
.36888 .84968 L
.37008 .8567 L
.36888 .86683 L
.36877 .86704 L
.35917 .871 L
.35007 .86704 L
.34946 .86672 L
.34459 .8567 L
.3454 .84636 L
.33974 .8366 L
.3342 .84636 L
.33195 .8567 L
.33974 .86627 L
.34845 .86704 L
.34946 .86743 L
.35512 .87738 L
.34946 .88273 L
.34248 .88772 L
.33974 .88964 L
.33003 .89788 L
.32948 .88772 L
.33003 .88658 L
.33346 .87738 L
.33887 .86704 L
.33003 .859 L
.32032 .86383 L
.31622 .86704 L
.31061 .87422 L
.30128 .86704 L
.30089 .8622 L
.30021 .86704 L
.30089 .86783 L
.30328 .87738 L
.30089 .87856 L
.29659 .87738 L
.29118 .87704 L
.29094 .87738 L
.29118 .88329 L
.29181 .88772 L
.29118 .89791 L
.29109 .89806 L
.28147 .90262 L
.27176 .90569 L
.26589 .9084 L
.26204 .91013 L
.25336 .91873 L
.25233 .92047 L
Mistroke
.24646 .92907 L
.25233 .93726 L
.26204 .93473 L
.26675 .92907 L
.27176 .92006 L
.27393 .91873 L
.28147 .91713 L
.291 .91873 L
.29118 .91881 L
.29316 .92907 L
.29118 .93258 L
.28604 .93941 L
.28253 .94975 L
.28147 .95161 L
.27176 .95455 L
.26204 .9568 L
.26136 .94975 L
.25233 .94299 L
.25068 .93941 L
.24262 .93342 L
.2383 .93941 L
.24262 .94655 L
.24534 .94975 L
.24262 .95347 L
.23364 .96009 L
.23291 .96063 L
.22662 .97043 L
.22319 .97894 L
.21943 .98077 L
Mfstroke
.20936 .98077 m
.20377 .97329 L
.1976 .98077 L
s
.11111 .98077 m
.10664 .9791 L
.10126 .98077 L
s
.03875 .98077 m
.03866 .98049 L
.03484 .98077 L
s
.98077 .02198 m
.97131 .01923 L
s
.98077 .03448 m
.97106 .03499 L
.96134 .03937 L
.96058 .03991 L
.95163 .04962 L
.95064 .05025 L
.94192 .05287 L
.93221 .05543 L
.9281 .06059 L
.92249 .06356 L
.91278 .06351 L
.90765 .06059 L
.90307 .05644 L
.89336 .05477 L
.88364 .05722 L
.87393 .05848 L
.86431 .06059 L
.86422 .06068 L
.85451 .06526 L
.84725 .06059 L
.85137 .05025 L
.85451 .04751 L
.86422 .04197 L
.86823 .03991 L
.86422 .03516 L
.85451 .03646 L
.84479 .03843 L
.84043 .03991 L
.83508 .04168 L
.83255 .03991 L
.82537 .03498 L
.81566 .02978 L
.80594 .03235 L
.80127 .02957 L
.79623 .02782 L
.7957 .02957 L
.78652 .03792 L
.78083 .02957 L
.78608 .01923 L
s
.77519 .01923 m
.76709 .02072 L
.75738 .02811 L
.74767 .02875 L
.74621 .02957 L
.73796 .03565 L
.73303 .02957 L
.72824 .02151 L
.72109 .01923 L
s
.37882 .01923 m
.37859 .01932 L
.36888 .0193 L
.35917 .02268 L
.35892 .01923 L
s
.34706 .01923 m
.34946 .02239 L
.34986 .02957 L
.34946 .02995 L
.34562 .03991 L
.34946 .0415 L
.35917 .04856 L
.35996 .05025 L
.36239 .06059 L
.35917 .06746 L
.35711 .07093 L
.35293 .08127 L
.34946 .08515 L
.33974 .09016 L
.33747 .0916 L
.33611 .10194 L
.33003 .11054 L
.32685 .11228 L
.32032 .11617 L
.31814 .12262 L
.31061 .1257 L
.30089 .12849 L
.29718 .13296 L
.29118 .13876 L
.28147 .14264 L
.27983 .1433 L
.27176 .14912 L
.26477 .15364 L
.26204 .15561 L
.25233 .16281 L
.24262 .15874 L
.23291 .15858 L
.22319 .15883 L
.21496 .15364 L
.21426 .1433 L
.22319 .13587 L
.23291 .13461 L
.23519 .13296 L
.23291 .12975 L
.22319 .12919 L
.21744 .12262 L
.21348 .11878 L
.20991 .12262 L
.20377 .12935 L
.20019 .12262 L
.19406 .1137 L
.18434 .11772 L
.17648 .11228 L
.17463 .1022 L
.17109 .11228 L
Mistroke
.16753 .12262 L
.17463 .12661 L
.18434 .13018 L
.19406 .12986 L
.19959 .13296 L
.19406 .13862 L
.18434 .13981 L
.17463 .14116 L
.172 .1433 L
.16492 .15043 L
.15776 .1433 L
.15869 .13296 L
.16152 .12262 L
.15521 .11875 L
.14814 .11228 L
.15521 .10668 L
.15961 .10194 L
.16481 .0916 L
.16492 .09144 L
.16988 .08127 L
.17463 .07755 L
.18276 .07093 L
.17463 .06457 L
.16861 .06059 L
.16492 .05561 L
.15521 .05738 L
.14549 .05101 L
.13924 .06059 L
.13578 .06264 L
.12607 .06655 L
.11936 .07093 L
.1202 .08127 L
.11636 .08864 L
.10664 .08192 L
.10658 .08127 L
.10664 .081 L
.11356 .07093 L
.11205 .06059 L
.11319 .05025 L
.11629 .03991 L
.11636 .03976 L
.11943 .02957 L
.12073 .01923 L
Mfstroke
.05808 .95666 m
.0667 .96009 L
.05808 .9647 L
.05637 .96009 L
.05808 .95666 L
s
.06779 .94549 m
.07475 .94975 L
.06779 .95901 L
.06428 .94975 L
.06779 .94549 L
s
.07751 .93177 m
.08722 .93212 L
.09519 .93941 L
.08722 .94796 L
.07751 .94508 L
.07465 .93941 L
.07751 .93177 L
s
.15521 .92715 m
.16171 .92907 L
.15521 .93162 L
.14956 .92907 L
.15521 .92715 L
s
.10664 .88415 m
.11294 .88772 L
.10664 .89155 L
.1037 .88772 L
.10664 .88415 L
s
.55342 .87076 m
.56313 .8739 L
.56604 .87738 L
.56536 .88772 L
.56606 .89806 L
.56313 .90693 L
.5556 .89806 L
.55342 .89271 L
.54371 .89128 L
.54223 .88772 L
.54371 .87886 L
.54492 .87738 L
.55342 .87076 L
s
.13578 .87189 m
.1403 .87738 L
.13578 .87894 L
.13317 .87738 L
.13578 .87189 L
s
.89336 .84448 m
.89492 .84636 L
.89336 .84923 L
.89188 .84636 L
.89336 .84448 L
s
.74767 .78769 m
.75417 .79467 L
.75429 .805 L
.75738 .80993 L
.76324 .81534 L
.75738 .82092 L
.74767 .81823 L
.73796 .82374 L
.73098 .81534 L
.73796 .80993 L
.74043 .805 L
.74258 .79467 L
.74767 .78769 L
s
.71853 .79014 m
.72499 .79467 L
.72266 .805 L
.71853 .81008 L
.70882 .80796 L
.70398 .805 L
.70882 .79628 L
.70997 .79467 L
.71853 .79014 L
s
.97106 .77061 m
.97947 .77399 L
.97106 .77644 L
.96816 .77399 L
.97106 .77061 L
s
.72824 .76649 m
.73245 .77399 L
.72824 .78149 L
.72494 .77399 L
.72824 .76649 L
s
.25233 .7446 m
.25757 .75331 L
.25233 .7564 L
.24686 .75331 L
.25233 .7446 L
s
.20377 .74685 m
.20674 .75331 L
.20377 .75604 L
.19964 .75331 L
.20377 .74685 L
s
.94192 .73513 m
.95163 .74087 L
.954 .74297 L
.95163 .74825 L
.94192 .74737 L
.93795 .74297 L
.94192 .73513 L
s
.90307 .7415 m
.90433 .74297 L
.90307 .7446 L
.90087 .74297 L
.90307 .7415 L
s
.81566 .73984 m
.81727 .74297 L
.81566 .7455 L
.81305 .74297 L
.81566 .73984 L
s
.33974 .74163 m
.34416 .74297 L
.34946 .749 L
.35115 .75331 L
.34946 .76096 L
.33974 .76073 L
.33687 .75331 L
.33669 .74297 L
.33974 .74163 L
s
.15521 .71991 m
.16492 .71447 L
.16817 .72229 L
.17463 .72661 L
.18434 .72507 L
.19406 .72952 L
.19657 .73263 L
.19406 .73909 L
.18434 .73618 L
.17463 .73651 L
.16492 .73523 L
.15891 .73263 L
.15521 .72717 L
.147 .72229 L
.15521 .71991 L
s
.82537 .70816 m
.83012 .71195 L
.82694 .72229 L
.82537 .72373 L
.82303 .72229 L
.82377 .71195 L
.82537 .70816 L
s
.80594 .70327 m
.81314 .71195 L
.80594 .71967 L
.79879 .71195 L
.80594 .70327 L
s
.27176 .70665 m
.27999 .71195 L
.28147 .71398 L
.29118 .71848 L
.30089 .71603 L
.30686 .72229 L
.30089 .72836 L
.29118 .72899 L
.28147 .73094 L
.27176 .72687 L
.26204 .72759 L
.25233 .72415 L
.24839 .72229 L
.25233 .71814 L
.26204 .7152 L
.26504 .71195 L
.27176 .70665 L
s
.22319 .70546 m
.23291 .708 L
.24096 .71195 L
.23685 .72229 L
.23291 .7252 L
.22658 .73263 L
.22319 .73561 L
.2154 .73263 L
.21348 .73112 L
.20512 .72229 L
.21348 .7133 L
.21589 .71195 L
.22319 .70546 L
s
.87393 .68838 m
.87548 .69127 L
.87393 .69266 L
.87075 .69127 L
.87393 .68838 L
s
.12607 .6861 m
.13578 .68261 L
.14549 .68635 L
.15134 .69127 L
.14549 .69773 L
.13578 .69833 L
.12607 .69382 L
.12377 .69127 L
.12607 .6861 L
s
.26204 .67807 m
.27176 .67669 L
.27458 .68093 L
.27176 .6861 L
.26637 .69127 L
.26204 .69627 L
.25949 .69127 L
.26004 .68093 L
.26204 .67807 L
s
.94192 .66695 m
.94794 .6706 L
.94192 .67621 L
.93622 .6706 L
.94192 .66695 L
s
.91278 .66601 m
.9202 .6706 L
.91278 .67378 L
.90823 .6706 L
.91278 .66601 L
s
.69911 .64111 m
.70165 .64992 L
.69911 .65229 L
.69656 .64992 L
.69911 .64111 L
s
.85451 .6363 m
.86263 .63958 L
.85451 .64747 L
.84704 .63958 L
.85451 .6363 L
s
.95163 .45881 m
.95909 .46381 L
.96134 .46511 L
.97008 .47415 L
.96759 .48449 L
.97106 .48798 L
.97541 .49483 L
.97457 .50517 L
.97106 .51226 L
.96865 .51551 L
.96134 .52128 L
.95353 .51551 L
.95163 .51375 L
.9485 .50517 L
.94856 .49483 L
.9471 .48449 L
.94596 .47415 L
.94853 .46381 L
.95163 .45881 L
s
.38831 .41954 m
.39501 .42246 L
.38831 .4259 L
.38379 .42246 L
.38831 .41954 L
s
.33974 .4113 m
.34688 .41212 L
.34946 .41417 L
.35877 .42246 L
.35917 .4228 L
.36888 .43062 L
.37525 .4328 L
.36888 .43589 L
.35917 .43924 L
.35657 .44313 L
.34946 .44485 L
.33974 .44521 L
.33003 .44653 L
.32032 .44868 L
.31061 .45286 L
.30089 .45024 L
.29543 .44313 L
.30089 .43873 L
.30686 .4328 L
.31061 .43065 L
.3193 .42246 L
.32032 .42156 L
.33003 .41517 L
.33395 .41212 L
.33974 .4113 L
s
.39802 .39254 m
.40395 .40178 L
.40773 .40765 L
.4123 .41212 L
.40773 .41599 L
.39802 .42025 L
.39302 .41212 L
.39158 .40178 L
.39802 .39254 L
s
.66997 .3897 m
.67601 .39144 L
.67968 .39475 L
.68939 .39826 L
.69911 .40023 L
.70882 .4002 L
.71233 .40178 L
.70882 .40297 L
.70196 .41212 L
.69969 .42246 L
.70421 .4328 L
.70882 .43766 L
.71853 .44221 L
.725 .44313 L
.72824 .44349 L
.72928 .44313 L
.73796 .43901 L
.74549 .4328 L
.74767 .43168 L
.75738 .43185 L
.75897 .4328 L
.76709 .43959 L
.77502 .44313 L
.77681 .44483 L
.78362 .45347 L
.78652 .45706 L
.79107 .46381 L
.78652 .47243 L
.78394 .47415 L
.77681 .47659 L
.76824 .47415 L
.76709 .47351 L
.75738 .46976 L
.74767 .46605 L
.73898 .46381 L
.73796 .46325 L
.72824 .45971 L
.71853 .45623 L
.71268 .45347 L
.70882 .44986 L
.69911 .44459 L
.69462 .44313 L
.68939 .44014 L
.67968 .43652 L
.67598 .4328 L
.66997 .42502 L
.66881 .42246 L
.66708 .41212 L
.66641 .40178 L
.66841 .39144 L
Mistroke
.66997 .3897 L
Mfstroke
.02894 .35895 m
.03098 .36042 L
.02894 .36249 L
.02431 .36042 L
.02894 .35895 L
s
.02894 .31513 m
.03492 .31907 L
.02894 .323 L
.02236 .31907 L
.02894 .31513 L
s
.14549 .29354 m
.1532 .29839 L
.15521 .29974 L
.15654 .30873 L
.15521 .31216 L
.14709 .30873 L
.14549 .30583 L
.13947 .29839 L
.14549 .29354 L
s
.07751 .26485 m
.08007 .26737 L
.07751 .26976 L
.07189 .26737 L
.07751 .26485 L
s
.17463 .24288 m
.18434 .23968 L
.19306 .24669 L
.18434 .25042 L
.17743 .25703 L
.17463 .26412 L
.17303 .26737 L
.17249 .27771 L
.16818 .28805 L
.16492 .29255 L
.16237 .28805 L
.15521 .27922 L
.14549 .28326 L
.14274 .27771 L
.14549 .27476 L
.15521 .27397 L
.16223 .26737 L
.16198 .25703 L
.16492 .2537 L
.16837 .24669 L
.17463 .24288 L
s
.03866 .24305 m
.04122 .24669 L
.03866 .24807 L
.03413 .24669 L
.03866 .24305 L
s
.05808 .22429 m
.06779 .22318 L
.07751 .22168 L
.08109 .22601 L
.07751 .22907 L
.06779 .2284 L
.05808 .22859 L
.05587 .22601 L
.05808 .22429 L
s
.31061 .20033 m
.31812 .20533 L
.31467 .21567 L
.31061 .22222 L
.30968 .22601 L
.31045 .23635 L
.31061 .23783 L
.31342 .24669 L
.31061 .24782 L
.30089 .25103 L
.29118 .25381 L
.28792 .25703 L
.28352 .26737 L
.28147 .26968 L
.27176 .2747 L
.26204 .27655 L
.25686 .27771 L
.25233 .28025 L
.24812 .28805 L
.24262 .29243 L
.23622 .29839 L
.23291 .30042 L
.22319 .30538 L
.22083 .30873 L
.21348 .31401 L
.20778 .31907 L
.20377 .32279 L
.19406 .32859 L
.18895 .31907 L
.19406 .31108 L
.19582 .30873 L
.19971 .29839 L
.20377 .29257 L
.20786 .28805 L
.21348 .28255 L
.21646 .27771 L
.22319 .2756 L
.23291 .2688 L
.23603 .26737 L
.24262 .26249 L
.24374 .25703 L
.24607 .24669 L
.25233 .24404 L
.26204 .2373 L
.26713 .23635 L
.27176 .23395 L
.28147 .23027 L
.28523 .22601 L
.29118 .21875 L
.29716 .21567 L
Mistroke
.30089 .21149 L
.30564 .20533 L
.31061 .20033 L
Mfstroke
.06779 .19089 m
.07751 .19264 L
.07963 .195 L
.07918 .20533 L
.07751 .20722 L
.07254 .20533 L
.06779 .19944 L
.06528 .195 L
.06779 .19089 L
s
.04837 .1808 m
.04982 .18466 L
.04837 .18604 L
.04499 .18466 L
.04837 .1808 L
s
.33003 .16688 m
.33974 .16511 L
.34946 .16587 L
.35024 .17432 L
.34946 .17533 L
.33974 .17814 L
.33306 .18466 L
.33003 .19133 L
.32128 .18466 L
.32524 .17432 L
.33003 .16688 L
s
.27176 .16167 m
.28147 .15555 L
.28739 .16398 L
.28557 .17432 L
.28147 .17615 L
.27176 .17719 L
.26204 .1823 L
.25952 .18466 L
.25233 .18974 L
.24749 .195 L
.24262 .20486 L
.242 .20533 L
.23291 .2093 L
.22573 .21567 L
.22319 .21789 L
.21348 .22342 L
.2118 .22601 L
.20495 .23635 L
.20377 .23934 L
.19406 .2458 L
.18765 .23635 L
.18434 .23196 L
.17838 .22601 L
.18434 .22425 L
.19406 .21794 L
.19646 .21567 L
.19527 .20533 L
.20377 .19637 L
.20533 .195 L
.21348 .1904 L
.22319 .18675 L
.23291 .18562 L
.2342 .18466 L
.24262 .17644 L
.24614 .17432 L
.25233 .16907 L
.26204 .16521 L
.26714 .16398 L
.27176 .16167 L
s
.06779 .16201 m
.06968 .16398 L
.06779 .16846 L
.06543 .16398 L
.06779 .16201 L
s
.29118 .14715 m
.29601 .15364 L
.29118 .15918 L
.28349 .15364 L
.29118 .14715 L
s
.06779 .13553 m
.07319 .1433 L
.06779 .1493 L
.06044 .1433 L
.06779 .13553 L
s
.02894 .13755 m
.03315 .1433 L
.02894 .14592 L
.02362 .1433 L
.02894 .13755 L
s
.03866 .12943 m
.04133 .13296 L
.03866 .13959 L
.0326 .13296 L
.03866 .12943 L
s
.04837 .1099 m
.05089 .11228 L
.04837 .1148 L
.04569 .11228 L
.04837 .1099 L
s
.54371 .08976 m
.54654 .0916 L
.55342 .09874 L
.55701 .10194 L
.56313 .10887 L
.56812 .11228 L
.57229 .12262 L
.57284 .1231 L
.57627 .13296 L
.58256 .13855 L
.58798 .1433 L
.59227 .1483 L
.59955 .15364 L
.60198 .15687 L
.6026 .16398 L
.60198 .16503 L
.59227 .17013 L
.58256 .16733 L
.57284 .16509 L
.5688 .16398 L
.56313 .15959 L
.55342 .15695 L
.54583 .15364 L
.54371 .1529 L
.53834 .1433 L
.53399 .13992 L
.53038 .1433 L
.53216 .15364 L
.52428 .15583 L
.51685 .15364 L
.51457 .15307 L
.51189 .15364 L
.50793 .16398 L
.50486 .1679 L
.49514 .16784 L
.48909 .16398 L
.49045 .15364 L
.49514 .14462 L
.49619 .1433 L
.50486 .13926 L
.51028 .13296 L
.51457 .12313 L
.51498 .12262 L
.52349 .11228 L
.52428 .11178 L
.53399 .10262 L
.53443 .10194 L
.54122 .0916 L
.54371 .08976 L
s
.05808 .0869 m
.06133 .0916 L
.05808 .09529 L
.05483 .0916 L
.05808 .0869 L
s
.03866 .08921 m
.0404 .0916 L
.03866 .09461 L
.03583 .0916 L
.03866 .08921 L
s
.81566 .06467 m
.82195 .07093 L
.81566 .07932 L
.81271 .07093 L
.81566 .06467 L
s
.63112 .05664 m
.63712 .06059 L
.63112 .06361 L
.62407 .06059 L
.63112 .05664 L
s
.74767 .03834 m
.74901 .03991 L
.74767 .04734 L
.74311 .03991 L
.74767 .03834 L
s
.09693 .03368 m
.10545 .03991 L
.10158 .05025 L
.09992 .06059 L
.09693 .0689 L
.08889 .06059 L
.09149 .05025 L
.0906 .03991 L
.09693 .03368 L
s
.01923 .23908 m
.02033 .23635 L
.01923 .2313 L
s
.01923 .16624 m
.02049 .16398 L
.01923 .16097 L
s
.01923 .11759 m
.02334 .11228 L
.02001 .10194 L
.01923 .10032 L
s
.01923 .08383 m
.02296 .08127 L
.01923 .07919 L
s
.98077 .93739 m
.97802 .92907 L
.97862 .91873 L
.97886 .9084 L
.98077 .90565 L
s
.98077 .95324 m
.97876 .94975 L
.97106 .94204 L
.96797 .93941 L
.96134 .93138 L
.95897 .92907 L
.96134 .92677 L
.96886 .91873 L
.9655 .9084 L
.96134 .90338 L
.95163 .90087 L
.94732 .89806 L
.94192 .89318 L
.93695 .88772 L
.93221 .88372 L
.92395 .87738 L
.92249 .87514 L
.91514 .86704 L
.91278 .86403 L
.90734 .8567 L
.91036 .84636 L
.91278 .84393 L
.91917 .84636 L
.9194 .8567 L
.92249 .85935 L
.92894 .8567 L
.93221 .85538 L
.93431 .8567 L
.94192 .85927 L
.95003 .8567 L
.95163 .8564 L
.96134 .85389 L
.96805 .8567 L
.97106 .85858 L
.98077 .85955 L
s
.98077 .82439 m
.97106 .81969 L
.96134 .81927 L
.95851 .81534 L
.95163 .81157 L
.94758 .81534 L
.94192 .82307 L
.93583 .81534 L
.93221 .80971 L
.92849 .805 L
.93221 .80109 L
.94192 .7968 L
.95163 .80018 L
.96134 .80019 L
.96687 .805 L
.97106 .8089 L
.98077 .80723 L
s
.98077 .5602 m
.97702 .55687 L
.97106 .55031 L
.96695 .54653 L
.97106 .53917 L
.97851 .54653 L
.98077 .55071 L
s
.98077 .40227 m
.97651 .40178 L
.9781 .39144 L
.97305 .3811 L
.97106 .37236 L
.9696 .37076 L
.96134 .36369 L
.95163 .36219 L
.94983 .36042 L
.94452 .35008 L
.94192 .34857 L
.93362 .33974 L
.93221 .3383 L
.92609 .3294 L
.92249 .327 L
.91623 .31907 L
.91849 .30873 L
.91278 .30482 L
.90739 .29839 L
.90307 .29505 L
.89539 .28805 L
.89336 .28612 L
.88364 .28176 L
.88336 .27771 L
.87393 .2727 L
.86858 .26737 L
.86422 .26277 L
.8561 .25703 L
.85451 .25366 L
.84479 .24833 L
.84368 .24669 L
.83886 .23635 L
.83508 .23396 L
.82537 .22841 L
.82402 .22601 L
.81566 .21701 L
.8135 .21567 L
.81047 .20533 L
.80812 .195 L
.80815 .18466 L
.80594 .18168 L
.80052 .17432 L
.80306 .16398 L
.80594 .15834 L
.81566 .15887 L
.82537 .15527 L
.83508 .16099 L
.83816 .16398 L
.84479 .1661 L
.85451 .16856 L
Mistroke
.85992 .17432 L
.86422 .17663 L
.87393 .18401 L
.87467 .18466 L
.88364 .19297 L
.88692 .195 L
.89336 .20284 L
.89797 .20533 L
.90307 .20992 L
.91203 .21567 L
.91278 .21667 L
.92249 .22327 L
.92782 .22601 L
.93221 .22822 L
.93532 .23635 L
.9386 .24669 L
.94192 .25156 L
.94683 .25703 L
.95163 .26467 L
.95395 .26737 L
.96134 .27471 L
.96371 .27771 L
.96555 .28805 L
.97106 .29775 L
.97176 .29839 L
.97281 .30873 L
.98077 .31501 L
Mfstroke
.98077 .21702 m
.97982 .21567 L
.97664 .20533 L
.98077 .19809 L
s
.98077 .1801 m
.97106 .18309 L
.96661 .18466 L
.96134 .18651 L
.95972 .18466 L
.95313 .17432 L
.95163 .16938 L
.94192 .16768 L
.9401 .16398 L
.94192 .16231 L
.95163 .16216 L
.95449 .16398 L
.96134 .16538 L
.96839 .16398 L
.97106 .16288 L
.98077 .16042 L
s
.98077 .43129 m
.97106 .4305 L
.96134 .42707 L
.95163 .43066 L
.94192 .43101 L
.93447 .42246 L
.93527 .41212 L
.93663 .40178 L
.93221 .39539 L
.92414 .39144 L
.92416 .3811 L
.92249 .37822 L
.91914 .37076 L
.91278 .36366 L
.91008 .36042 L
.90307 .35182 L
.901 .35008 L
.89336 .34258 L
.88958 .33974 L
.88364 .33457 L
.88013 .3294 L
.87393 .32293 L
.86527 .31907 L
.86422 .31551 L
.85505 .30873 L
.85451 .30814 L
.84479 .30211 L
.83984 .29839 L
.83508 .29288 L
.83216 .28805 L
.82537 .28158 L
.82111 .27771 L
.81566 .27224 L
.80751 .26737 L
.80594 .26357 L
.79623 .26118 L
.79205 .25703 L
.79623 .24778 L
.79723 .24669 L
.79623 .24163 L
.79448 .23635 L
.79394 .22601 L
.78732 .21567 L
.78652 .21474 L
.77681 .20856 L
.77456 .20533 L
.77432 .195 L
.77037 .18466 L
.76709 .1821 L
.75787 .17432 L
Mistroke
.75738 .17356 L
.74767 .16677 L
.7432 .16398 L
.7449 .15364 L
.73796 .14968 L
.73047 .1433 L
.72824 .14087 L
.72494 .13296 L
.71853 .12707 L
.70988 .12262 L
.70882 .12199 L
.70301 .11228 L
.69911 .10677 L
.69155 .10194 L
.68939 .10078 L
.67968 .09881 L
.67268 .0916 L
.66997 .08977 L
.66026 .08395 L
.65173 .08127 L
.65054 .08034 L
.64207 .07093 L
.64315 .06059 L
.65054 .05394 L
.66026 .05493 L
.66388 .06059 L
.66997 .06361 L
.67371 .06059 L
.66997 .05414 L
.66403 .05025 L
.66026 .04683 L
.65457 .03991 L
.66026 .03319 L
.66997 .03558 L
.67968 .03139 L
.68939 .02983 L
.69296 .02957 L
.69911 .02687 L
.70882 .02625 L
.71853 .02701 L
.72124 .02957 L
.72824 .03761 L
.73083 .03991 L
.73796 .04132 L
.74675 .05025 L
.74767 .05148 L
.75738 .05415 L
.76402 .06059 L
.76709 .06338 L
.77681 .0689 L
Mistroke
.7807 .07093 L
.78652 .07142 L
.79025 .08127 L
.79623 .08563 L
.80139 .0916 L
.79623 .10032 L
.79517 .10194 L
.79623 .10338 L
.80594 .10275 L
.81566 .10599 L
.82537 .10701 L
.83346 .11228 L
.83045 .12262 L
.83508 .12425 L
.83939 .12262 L
.84035 .11228 L
.83508 .11078 L
.83061 .10194 L
.83508 .09318 L
.84479 .09634 L
.85451 .09772 L
.86422 .09668 L
.87393 .10007 L
.88364 .10066 L
.88858 .10194 L
.89336 .10385 L
.90139 .11228 L
.90307 .11456 L
.90858 .12262 L
.90307 .12605 L
.89336 .12736 L
.8884 .12262 L
.88364 .11994 L
.88207 .12262 L
.88364 .12599 L
.89093 .13296 L
.89336 .13477 L
.90307 .14077 L
.91278 .138 L
.91483 .13296 L
.9151 .12262 L
.91479 .11228 L
.91278 .11085 L
.90752 .10194 L
.91278 .09942 L
.91771 .10194 L
.92249 .10686 L
.93221 .10999 L
.93944 .11228 L
.93459 .12262 L
Mistroke
.93221 .12568 L
.92552 .13296 L
.92543 .1433 L
.93221 .14854 L
.94192 .14884 L
.95163 .15021 L
.95911 .1433 L
.95587 .13296 L
.96134 .12925 L
.96605 .13296 L
.9679 .1433 L
.97106 .1462 L
.98077 .15155 L
Mfstroke
.98077 .13525 m
.97912 .13296 L
.98077 .12981 L
s
.97396 .98077 m
.97106 .98011 L
.96552 .98077 L
s
.98077 .7387 m
.97106 .73469 L
.96917 .73263 L
.96134 .72559 L
.9569 .72229 L
.95163 .71754 L
.94192 .71441 L
.93221 .71911 L
.92765 .71195 L
.92249 .70473 L
.91862 .70161 L
.91278 .69841 L
.9049 .69127 L
.90307 .68874 L
.89753 .68093 L
.8973 .6706 L
.89336 .66289 L
.88364 .66185 L
.88112 .66026 L
.87393 .65155 L
.87049 .66026 L
.87393 .66488 L
.87797 .6706 L
.87393 .67446 L
.87014 .6706 L
.86422 .66552 L
.8567 .6706 L
.85451 .67295 L
.85183 .6706 L
.84479 .66588 L
.83508 .66411 L
.82537 .66533 L
.81733 .6706 L
.82537 .67927 L
.82758 .68093 L
.82537 .68377 L
.81566 .68307 L
.81431 .68093 L
.80594 .67197 L
.80067 .68093 L
.80594 .68805 L
.81014 .69127 L
.80594 .69594 L
.80215 .69127 L
.79623 .6869 L
.78793 .69127 L
.78652 .69267 L
.78257 .70161 L
.78652 .70779 L
.78874 .71195 L
Mistroke
.78652 .71573 L
.77958 .72229 L
.77989 .73263 L
.78652 .73995 L
.79623 .74035 L
.79797 .74297 L
.79623 .74692 L
.79393 .75331 L
.79623 .7597 L
.79729 .76365 L
.79623 .76637 L
.79115 .77399 L
.78652 .77583 L
.78248 .77399 L
.77839 .76365 L
.7807 .75331 L
.78189 .74297 L
.77681 .73823 L
.77134 .74297 L
.76709 .74891 L
.76167 .75331 L
.75868 .76365 L
.75738 .76553 L
.75248 .77399 L
.75738 .78075 L
.76065 .78433 L
.76212 .79467 L
.76196 .805 L
.76709 .81321 L
.77149 .81534 L
.77681 .8204 L
.78652 .82364 L
.79623 .82452 L
.79734 .82568 L
.79894 .83602 L
.79623 .83984 L
.78888 .84636 L
.79317 .8567 L
.79623 .86013 L
.80594 .86159 L
.81173 .86704 L
.81319 .87738 L
.81566 .88387 L
.81755 .88772 L
.82106 .89806 L
.82132 .9084 L
.82357 .91873 L
.82537 .9216 L
.82922 .91873 L
.83099 .9084 L
Mistroke
.83508 .90655 L
.83638 .9084 L
.84001 .91873 L
.83647 .92907 L
.83954 .93941 L
.84479 .94816 L
.85451 .9436 L
.85917 .94975 L
.85964 .96009 L
.85943 .97043 L
.86422 .97538 L
.87193 .98077 L
Mfstroke
.18373 .98077 m
.18434 .98024 L
.19406 .97541 L
.19743 .97043 L
.20377 .96377 L
.20671 .96009 L
.21348 .95343 L
.21716 .94975 L
.22319 .94274 L
.22817 .93941 L
.23291 .93402 L
.23987 .92907 L
.24262 .92466 L
.24856 .91873 L
.2508 .9084 L
.25233 .90664 L
.26204 .90319 L
.26691 .89806 L
.27176 .89209 L
.27364 .88772 L
.27347 .87738 L
.278 .86704 L
.28111 .8567 L
.28147 .85545 L
.29118 .84854 L
.29412 .84636 L
.2989 .83602 L
.29928 .82568 L
.30089 .82393 L
.30341 .82568 L
.31061 .82858 L
.3179 .82568 L
.31701 .81534 L
.31061 .80762 L
.30912 .805 L
.30089 .79705 L
.29908 .79467 L
.29118 .78827 L
.28889 .78433 L
.29118 .78143 L
.29471 .78433 L
.30089 .79236 L
.30533 .79467 L
.31061 .80106 L
.32032 .79813 L
.32749 .79467 L
.32717 .78433 L
.32032 .77889 L
.31453 .78433 L
.31061 .78717 L
Mistroke
.30899 .78433 L
.30674 .77399 L
.30089 .7676 L
.29485 .76365 L
.29118 .76025 L
.28147 .76 L
.27176 .75667 L
.26357 .76365 L
.26204 .76511 L
.25233 .76752 L
.24606 .76365 L
.24262 .75862 L
.23527 .76365 L
.23291 .76518 L
.22319 .76738 L
.22098 .77399 L
.22319 .77681 L
.23291 .77858 L
.24262 .77907 L
.25233 .78291 L
.26204 .78057 L
.2662 .78433 L
.26204 .78677 L
.25233 .7872 L
.24591 .79467 L
.24262 .79702 L
.23291 .79766 L
.22319 .80119 L
.22157 .805 L
.2152 .81534 L
.22319 .81894 L
.22641 .81534 L
.23291 .81031 L
.2398 .81534 L
.23426 .82568 L
.23291 .82655 L
.22319 .82796 L
.21348 .82836 L
.2122 .82568 L
.20377 .8219 L
.20114 .82568 L
.20377 .83254 L
.20834 .83602 L
.20377 .84095 L
.19802 .83602 L
.19406 .83442 L
.18434 .83486 L
.17676 .83602 L
.18434 .84413 L
.18676 .84636 L
Mistroke
.18434 .84857 L
.17463 .85359 L
.16637 .8567 L
.16492 .85787 L
.16184 .86704 L
.16492 .86956 L
.17238 .87738 L
.17463 .88078 L
.17904 .88772 L
.18434 .8942 L
.18707 .89806 L
.18434 .89932 L
.18107 .89806 L
.17463 .89598 L
.17048 .89806 L
.16767 .9084 L
.17463 .91532 L
.1785 .91873 L
.17463 .92522 L
.16966 .92907 L
.1675 .93941 L
.16492 .94277 L
.15939 .94975 L
.15521 .95327 L
.14874 .96009 L
.14665 .97043 L
.14549 .97231 L
.13778 .98077 L
Mfstroke
.57754 .01923 m
.57284 .02303 L
.56313 .02276 L
.55342 .02626 L
.54371 .02183 L
.53399 .02426 L
.52428 .02829 L
.5224 .02957 L
.51602 .03991 L
.51457 .04269 L
.50747 .03991 L
.50486 .03763 L
.49514 .03213 L
.49057 .03991 L
.49514 .04813 L
.49748 .05025 L
.49514 .05442 L
.48543 .05952 L
.48261 .06059 L
.47572 .06272 L
.46601 .0696 L
.45629 .06901 L
.45438 .07093 L
.45172 .08127 L
.44658 .08407 L
.43687 .08628 L
.42716 .0889 L
.42006 .0916 L
.41744 .09357 L
.40773 .09981 L
.40507 .10194 L
.39802 .11066 L
.39633 .11228 L
.38831 .12239 L
.38765 .12262 L
.37859 .12945 L
.36888 .13216 L
.36812 .13296 L
.36599 .1433 L
.36067 .15364 L
.35917 .15647 L
.34946 .16164 L
.34438 .15364 L
.33974 .14991 L
.33453 .15364 L
.33003 .15864 L
.32152 .15364 L
.32032 .15298 L
.31061 .14905 L
.30164 .1433 L
Mistroke
.30822 .13296 L
.31061 .13215 L
.32032 .12761 L
.32608 .12262 L
.33003 .11788 L
.33445 .11228 L
.33974 .10687 L
.34538 .10194 L
.34946 .09553 L
.35027 .0916 L
.35917 .08246 L
.3624 .08127 L
.36732 .07093 L
.36888 .06752 L
.37082 .06059 L
.37859 .05186 L
.38059 .05025 L
.38831 .04204 L
.38912 .03991 L
.39802 .03084 L
.39987 .02957 L
.40139 .01923 L
Mfstroke
.10478 .01923 m
.10664 .0207 L
.10875 .02957 L
.10664 .03752 L
.0985 .02957 L
.09693 .02225 L
.08722 .02047 L
.07751 .02192 L
.07354 .01923 L
s
.02362 .98077 m
.02894 .9769 L
.03282 .97043 L
.03866 .96171 L
.03949 .96009 L
.04092 .94975 L
.04132 .93941 L
.04837 .93126 L
.04986 .92907 L
.04923 .91873 L
.05808 .91064 L
.06779 .91189 L
.07751 .91381 L
.08722 .9166 L
.09693 .91305 L
.10664 .91118 L
.10863 .9084 L
.10664 .90428 L
.09693 .89926 L
.09464 .89806 L
.08722 .8906 L
.08213 .89806 L
.07751 .90298 L
.06779 .90323 L
.05808 .90402 L
.05111 .89806 L
.05442 .88772 L
.05808 .88339 L
.06353 .88772 L
.06779 .89377 L
.07582 .88772 L
.07183 .87738 L
.06779 .87293 L
.06018 .86704 L
.06427 .8567 L
.06643 .84636 L
.06779 .84447 L
.07461 .83602 L
.07695 .82568 L
.07751 .8242 L
.08014 .81534 L
.08339 .805 L
.08722 .7998 L
.09051 .79467 L
.09632 .78433 L
.09693 .78275 L
.10122 .77399 L
.10412 .76365 L
.10194 .75331 L
.10169 .74297 L
Mistroke
.09965 .73263 L
.09693 .7249 L
.09567 .72229 L
.0937 .71195 L
.08722 .70464 L
.08475 .70161 L
.08197 .69127 L
.07751 .68742 L
.07144 .68093 L
.06779 .6738 L
.06679 .6706 L
.06156 .66026 L
.05808 .65172 L
.05758 .64992 L
.05808 .64595 L
.05921 .63958 L
.06196 .62924 L
.06305 .6189 L
.0642 .60856 L
.06779 .60272 L
.0726 .59822 L
.0731 .58788 L
.07695 .57754 L
.07751 .57681 L
.08112 .5672 L
.08258 .55687 L
.08596 .54653 L
.08722 .54446 L
.09046 .53619 L
.09225 .52585 L
.09693 .52257 L
.09846 .51551 L
.10039 .50517 L
.10073 .49483 L
.10259 .48449 L
.10664 .48117 L
.1127 .47415 L
.11636 .46845 L
.12028 .46381 L
.11636 .45475 L
.11565 .45347 L
.10664 .44444 L
.10572 .44313 L
.10664 .44097 L
.11092 .4328 L
.11636 .42751 L
.12298 .42246 L
.12024 .41212 L
.12432 .40178 L
.12607 .39865 L
Mistroke
.12866 .39144 L
.12796 .3811 L
.12607 .37836 L
.11636 .3782 L
.10967 .37076 L
.11636 .36425 L
.12081 .36042 L
.11636 .35706 L
.10664 .35439 L
.10432 .35008 L
.10664 .34629 L
.11291 .33974 L
.10664 .33422 L
.10157 .3294 L
.1017 .31907 L
.09693 .31087 L
.0959 .30873 L
.09631 .29839 L
.09693 .29262 L
.10012 .28805 L
.10337 .27771 L
.10146 .26737 L
.09693 .25873 L
.09615 .25703 L
.09657 .24669 L
.09693 .24119 L
.09859 .23635 L
.09897 .22601 L
.10092 .21567 L
.09693 .20981 L
.09579 .20533 L
.09693 .20287 L
.09983 .195 L
.10012 .18466 L
.10005 .17432 L
.09693 .1691 L
.08722 .1657 L
.0859 .16398 L
.08722 .16038 L
.09248 .15364 L
.09389 .1433 L
.08722 .13575 L
.07751 .13632 L
.07208 .13296 L
.07365 .12262 L
.07751 .12092 L
.08089 .12262 L
.08722 .12704 L
.09593 .12262 L
.08722 .11721 L
Mistroke
.08424 .11228 L
.08537 .10194 L
.07751 .09433 L
.07589 .0916 L
.07751 .08713 L
.08226 .0916 L
.08722 .09943 L
.09693 .09691 L
.09932 .0916 L
.09693 .08462 L
.08722 .08784 L
.08076 .08127 L
.08116 .07093 L
.08443 .06059 L
.07751 .05271 L
.07445 .05025 L
.07751 .0463 L
.08304 .03991 L
.07751 .03317 L
.06779 .03327 L
.06262 .02957 L
.06366 .01923 L
Mfstroke
.01923 .05427 m
.02894 .05759 L
.03634 .06059 L
.03866 .06197 L
.04557 .07093 L
.04837 .07377 L
.05242 .07093 L
.04837 .06524 L
.04373 .06059 L
.04837 .0567 L
.05491 .05025 L
.0517 .03991 L
.04837 .03348 L
.04171 .02957 L
.0434 .01923 L
s
.03344 .01923 m
.02894 .02474 L
.01971 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{242.375, 242.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003b0000lR000`400?l00000o`00003ol_l00000
0003o`00003oool0oooo0>h0oooo0Ol000000003o`00003oool0oooo0>h0oooo0Ol000000003o`00
003oool0oooo0>h0oooo0Ol000000003o`00003oool0oooo0>h0oooo0Ol000000004o`00003oool0
oooo0?ooo`?o000000@0ooooo`00003ooooo0000103oool00`000000ooooo`0000020?ooo`?o0000
0P3oool01Ol00000oooo0?ooo`3oool0000001D0oooo00<000000?ooo`3oool0103oool01?l00000
oooo0?ooo`3oool5000000D0oooo0`0000040?ooo`05o`00003oool0oooo0?ooool000000P3oool0
0ol00000oooo00000003000000@0oooo00<000000?ooo`3oool0:03oool00ol00000oooo0?ooo`0O
0?ooo`<00000203oool4000000030?ooo`000000oooo00h0oooo0_l000090?ooo`?o00003`3oool2
000000D0oooo0Ol000000003o`00003oool0oooo00@0oooo00Co00000?ooo`3ooooo0000103oool0
0`000000oooo0?ooo`02o`0000<0oooo00?o00000?ooool000000`3oool00`000000oooo0?ooo`0=
0?ooo`8000000`3oool00`000000oooo000000050?ooo`04o`0000000000oooo000000D0oooo00<0
00000?ooo`3oool01@3oool00ol00000oooo0?ooo`060?ooo`04o`00003ooooo0000000000P0oooo
00<000000?ooo`3oool0703oool6o`0000030?ooool0003o000000?o0000903oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`020?ooo`7o000000000ol00000oooo0?ooo`070?ooo`03o`00003oool0oooo0080oooo00<0
00000?ooo`3oool01@3oool01_l00000oooo0?ooool00000oooo000000d0oooo0`0000020?ooo`04
0000003oool0000000000080oooo0_l000050?ooo`030000003oool0oooo00D0oooo00?o00000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool06`3oool00ol00000oooo0?ooo`040?ooo`03o`00003oool0oooo01d0oooo00<00000o`00
0?l000001@0000001?l0000000000?ooo`0000030?ooo`<000001@3oool010000000oooo0?ooo`00
0002o`0000040?ooo`0000000000000002/0oooo0Ol000000003o`00003oool0oooo00P0oooo00?o
00000?ooo`3oool00P3oool00ol000000000000000040?ooo`0600000?l00000ooooo`00003oool0
00003@3oool01P000000oooo000000000000oooo000000<0oooo0`00000?0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`0300000?l00000
oooo01D0oooo0_l000050?ooo`03o`00003oool0oooo01h0oooo0P0000020?ooo`8000002@3oool0
1P000000oooo0?ooo`000000oooo000000P0oooo00<000000?ooo`0000000`3oool01Ol00000oooo
0?ooo`3oool0000002X0oooo0Ol000000003o`00003oool0oooo00P0oooo00?o00000?ooo`3oool0
1@3oool01`000000oooo0?ooo`000000oooo00000?l000000P3oool01P000000oooo0?ooo`3ooooo
0000000000L0oooo00@000000?ooo`3oool0oooo0P00000G0?ooo`800000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05P3oool00ol00000oooo
o`0000030?ooo`03o`00003oool0oooo00D0oooo00Co000000000000000000005@3oool00`000000
oooo0?ooo`02000000`0oooo00Ko00000?ooo`3oool000000?ooool000080?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool00`3oool4000000P0oooo00?o00000000003oool03@3oool4
000000@0oooo0Ol000000003o`00003oool0oooo00T0oooo00?o00000?ooo`3oool0103oool30000
00<0oooo00@000000?ooo`3oool000000`3oool00ol000000000000000050?ooo`80000000@0oooo
00000000003o00004P3oool2o`0000030000003oool0oooo00<0oooo00D00000o`00003oool0oooo
000000060?ooo`03o`0000000000oooo00L0oooo00<000000?ooo`3oool05P3oool01?l00000oooo
0?ooo`3oool3o`0000H0oooo0_l000040?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool0403oool300000003o`0000000000oooo00D0oooo00?o00000?ooo`3oool02P3oool4o`000004
0000003oool0oooo0?ooo`;o00001P3oool01?l00000oooo00000000000;0?ooo`800000203oool1
o`00000000?o00000?ooo`3oool02@3oool00ol00000oooo0?ooo`030?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000003@3oool010000000oooo0000003oool200000100oooo
00<000000?ooo`0000001P3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool05`3oool00ol00000oooo0?ooo`030?ooo`03o`00003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180
oooo0P0000050?ooo`8000004`3oool00`000000oooo0?ooo`070?ooo`03o`00003oool0oooo00X0
oooo00<000000?ooo`3oool0203oool1o`00000000?o00000?ooo`3oool02P3oool00ol00000oooo
0?ooo`020?ooo`07o`00003oool0oooo0?ooo`000000oooo000000020?ooo`030000003oool0oooo
00l0oooo00@000000?ooo`3oool000001`3oool300000003o`00003oool0oooo00<0oooo00D00000
o`00000000000000o`0000030?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0I0?ooo`;o0000203oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01D0oooo00<00000o`00003oool04P3oool00ol00000oooo0?ooo`020?ooo`<00000
4@3oool00ol0000000000?ooo`0D0?ooo`8000002`3oool1o`00000000Co00000?ooo`3oool0oooo
0ol000050?ooo`03o`00003oool0oooo00<0oooo00Oo00000?ooo`3oool0oooo0000003oool00000
0080oooo00<000000?ooo`3oool01@3oool2000000L0oooo00Go00000?ooo`3oool0oooo00000009
0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo0`000000103oool000000?oo
o`0000040?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`03o`00003oool0oooo01T0oooo
00?o00000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000001D0oooo100000000`3ooooo
00000?ooo`0A0?ooo`<000005P3oool00`000000oooo0?ooo`060?ooo`<000002@3oool2000000d0
oooo0Ol000000003o`00003oool0oooo00@0oooo00Go00000?ooo`3oool0ooooo`0000070?ooo`03
0000003oool000000080oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`030000
00@0oooo00@000000?ooo`3oool000004`3oool00`000000oooo0?ooo`030?ooo`040000003oool0
00000?ooo`@0000000<0oooo0000003oool00`3oool010000000oooo0?ooo`00000K0?ooo`03o`00
003oool0oooo00X0oooo0`00000A0?ooo`8000000`3oool01P000000oooo0?ooo`000000oooo0000
01D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`020?ooo`D000000`3oool00`00
0000oooo0?ooo`040?ooo`03o`0000000000oooo00h0oooo0Ol000000003o`00003oool0oooo00D0
oooo0ol000090?ooo`8000000P3oool010000000oooo0?ooo`0000030?ooo`80000000?o00000?oo
o`3oool0103oool01?l0000000000?ooo`0000030?ooo`05o`00003oool0oooo0?ooo`0000003`3o
ool00`00003o0000000000040?ooo`04o`00003ooooo0000000000D0oooo00L000000?ooo`3oool0
oooo0000003oool0000001P0oooo1?l0000C0?ooo`<0000000<0oooo0000000000000P0000050?oo
o`80000000@0ooooo`00003oool00000103oool00ol00000oooo0000000E0?ooo`03o`00003oool0
oooo0140oooo0P0000000`3oool00000000000090?ooo`03o`0000000000oooo0080oooo00?o0000
0?ooo`3oool03`3oool1o`00000000?o00000?ooo`3oool01`3oool2o`0000P0oooo00D000000?oo
o`000000oooo000000020?ooo`040000003oool00000000000/0oooo0P0000000`3oool000000000
00040?ooo`8000004@3oool2000000<0oooo00?o00000?ooo`3oool01@3oool01`000000oooo0?oo
o`3oool000000?ooo`0000005`3oool00ol00000oooo0?ooo`020?ooo`X000001P3oool7000000@0
oooo0P0000050?ooo`040000003oool0oooo000000D0oooo00?o00000?ooo`3oool05@3oool20000
00T0oooo00?o00000000003oool01`3oool00`000000oooo0?ooo`0;0?ooo`<000004P3oool1o`00
000000?o00000?ooo`3oool0203oool2o`0000H0oooo00D000000?ooo`3oool0oooo000000030?oo
o`8000003`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000180oooo00<00000
0?ooo`3oool01`3oool020000000oooo0?ooo`3oool000000?ooool0000000004`3oool4o`000003
0?ooo`0000000000008000000_l0000600000004o`00000000000000o`0000<0oooo00@000000?oo
o`3oool000000`3oool6000000040?ooo`0000000000000000@0oooo00<000000?ooo`3oool07P3o
ool2o`0000030000003oool0oooo00@0oooo00?o00000?ooo`000000:P3oool1o`00000000?o0000
0?ooo`3oool0203oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo0P00000>
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000004`3oool00`000000oooo0?ooo`07
0?ooo`070000003oool0oooo0?ooo`000000oooo0000000D0?ooo`05o`00003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`060?ooo`030000003oool0000000<0oooo00@000000?ooo`3o
ool000002@3oool010000000oooo0?ooool0000200000080oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`040?ooo`800000:`3oool1o`00000000Go00000?ooo`3oool0ooooo`00000>
0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool00000303oool00`000000oooo0?oo
o`040?ooo`03o`0000000000000001@0oooo00@000000?ooo`3oool0oooo0`0000030?ooo`060000
003oool0oooo0000003oool000005@3oool01?l00000oooo0?ooool000030?ooo`8000002@3oool0
10000000oooo0?ooo`0000020?ooo`05o`00003oool0oooo0?ooo`0000002@3oool2000000<0oooo
00@000000?ooo`3oool000008P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02X0
oooo0Ol000000004o`00003oool0oooo0?ooo`;o00003@3oool2000000@0oooo0P0000020?ooo`03
0000003oool0oooo00T0oooo00?o00000?ooo`3oool0103oool01?l00000oooo0?ooo`00000>0?oo
o`L0000000@0ooooo`000000000000000P3oool400000080oooo0_l000000`000000oooo0?ooo`0B
0?ooo`;o000000H0ooooo`00003oool00000o`00000000020?ooo`Ko00000`3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo0080000000<0ooooo`000?l000000`3oool3o`000080
oooo0`0000001P3ooooo00000?ooo`3oool00000o`00008000007P3oool200000340oooo0Ol00000
0003o`00003oool0oooo00/0oooo00Go00000?ooo`3oool0ooooo`0000020?ooo`<000000`3oool0
0`000000oooo0000000:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000003P3oool0
0`000000oooo0?ooo`090?ooo`800000103oool300000180oooo1?l000000`3oool0000000000002
000000<0oooo0P0000060?ooo`04o`00003oool0oooo00000080oooo00L000000?ooo`3oool00000
0?ooo`000000oooo008000000P3oool00ol00000ooooo`0000030?ooo`;o00000`3oool01?l00000
ooooo`00000000040?ooo`030000003oool0oooo01d0oooo00?o00000?ooo`3oool06`3oool00ol0
00000000o`00000@0?ooo`7o000000000ol00000oooo0?ooo`050?ooo`;o00000`3oool2o`0000<0
oooo00?o00000000003oool00`3oool01Ol00000oooo0?ooo`3oool0000000X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`04o`00003oool0ooooo`000080000000?o0000
0000003oool01P3oool01P000000oooo00000?l00000oooo00000100oooo0ol000020?ooo`<00000
00Co00000000003oool0oooo0`0000040?ooo`0300000?l0000000000080000000Go00000?ooo`00
0000oooo00000002o`0000050?ooo`00003o00000?ooo`0000001@3oool00ol00000oooo0?ooo`04
0?ooo`;o000000<0oooo0000000000000P3oool300000080oooo00<00000o`00003oool07@3oool0
0`000000oooo0?ooo`0B0?ooo`;o000000<00000o`000?l000000`3oool00ol0000000000000000@
0?ooo`7o000000000ol00000oooo0?ooo`060?ooo`03o`00003oool0oooo0080oooo00Oo00000?oo
o`3oool0ooooo`00003oool0000000<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`020?ooo`040000003oool0oooo0?ooo`8000003P3oool010000000oooo0?ooool0000200000003
0?ooo`000000oooo00H0oooo00<000000?ooo`0000000P3oool00ol00000oooo0?ooo`0<0?ooo`;o
00000`3oool2000000030?ooo`000000oooo0080oooo0P0000040?ooo`<00000103oool02000003o
00000?ooo`00003o00000?ooo`000000oooo0`0000000`3oool000000?ooo`060?ooo`8000001@3o
ool01?l00000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`050?ooo`D000002@3oool00ol000000000000000040?ooo`03o`00
003oool0oooo0100oooo0Ol000000005o`00003oool0oooo0?ooool000003P3oool00`000000oooo
00000002000000h0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool000000080
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`020?ooo`030000003ooooo000000H0
oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`03o`00003oool0oooo0080
oooo00Co00000?ooo`3oool000000P3oool2000000D0oooo00@000000?ooo`3oool0oooo10000000
1?l0000000000000003oool2000000<0oooo00Co000000000000000000000P3oool500000080oooo
00<000000?ooo`3oool00`3oool01?l00000oooo0?ooo`0000030?ooo`030000003oool0oooo0080
oooo0P00000J0?ooo`03o`00003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool7000000H0
oooo00<00000o`00003oool04`3oool1o`00000000Go00000?ooo`3oool0ooooo`00000?0?ooo`03
0000003oool0oooo00l0oooo00@000000?ooo`3oool0oooo0P0000000`3oool00000000000020000
00030?ooo`000000000000h0oooo00?o00000?ooo`3oool00P3oool3o`0000@0oooo0P000000103o
ool000000?ooo`00000=0?ooo`04o`00003oool0oooo0?ooo`8000000P3oool010000000oooo0000
000000020?ooo`<0000000?o00000000003oool00P3oool010000000oooo0?ooo`3oool200000004
o`00000000000000000000D0oooo1P0000070?ooo`030000003oool0oooo00<0oooo00Co00000?oo
o`3ooooo00000P3oool2000000D0oooo0P00000G0?ooo`03o`0000000000000000800000103oool0
0`000000oooo0?ooo`0:0?ooo`;o000000@000000?ooo`3oool000000P3oool00ol00000oooo0?oo
o`0A0?ooo`7o000000001Ol00000oooo0?ooo`3oool0000000l0oooo00<000000?ooo`3oool01@3o
ool00ol00000oooo0?ooo`050?ooo`0300000?l00000oooo00<0oooo00<000000?ooo`000000103o
ool00`000000oooo0?ooo`0<0?ooo`0400000?l00000ooooo`0000@000000P3oool400000080oooo
0P0000000ol00000oooo0?ooo`0<0?ooo`04o`00003oool00000000000<0oooo00<000000?ooo`00
00000P3oool2000000L0oooo00Co00000?ooo`000000oooo100000000ol0000000000?ooo`050?oo
o`030000003oool0oooo00D000001@3oool010000000oooo0?ooo`3oool2o`0000<0oooo00?o0000
0?ooo`3oool00P3oool2000000D0oooo00<000000?ooo`3oool06@3oool5000000l0oooo00@00000
0?ooo`3oool000000P3oool200000140oooo0Ol000000003o`00003oool0oooo0080oooo00<00000
0?ooo`3oool00`3oool2o`0000L0oooo00<000000?ooo`3oool0103oool00ol00000ooooo`000005
0?ooo`030000003oool0oooo00<0oooo0P0000090?ooo`?o0000203oool01?l0000000000?ooool0
00050?ooo`800000103oool2o`0000030000003oool0oooo00`0oooo0_l000000`3ooooo00000?oo
o`020?ooo`80000000D0oooo0000003oool0oooo000000070?ooo`;o00000`3oool01P00003o0000
o`000000003o0000000000P0oooo100000001?l0000000000?ooo`0000050?ooo`030000003ooooo
000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0
oooo01d0oooo00<00000o`00003oool03@3oool01?l00000oooo0?ooo`0000030?ooo`<000003P3o
ool1o`00000000?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03o`00003oool0
oooo00H0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooool000070?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`000000oooo0P0000060?ooo`03o`00003oool0oooo00T0oooo
00<000000?ooo`3oool02@3oool010000000oooo0?ooo`00000>0?ooo`03o`00003oool0000000@0
00000`3oool00`000000ooooo`0000080?ooo`07o`00003oool0oooo0?ooool0000000000?ooo`02
o`0000030?ooo`000000oooo00T0oooo100000000`3ooooo00000?ooo`040?ooo`030000003ooooo
000000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01d0oooo0P00000>0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0303o
ool1o`00000000Go00000?ooo`3oool0oooo0000000=0?ooo`05o`00003oool0oooo00000?l00000
0P3oool2000000X0oooo0P0000000`3oool000000?ooo`020?ooo`040000003oool0oooo000000<0
oooo00?o00000?ooo`3oool05`3oool00`000000oooo0000000>0?ooo`05o`00003ooooo00000?oo
o`0000001@3oool010000000oooo0?ooo`0000090?ooo`?o000000<0oooo00000?l000000`00000<
0?ooo`@0000000<0oooo0000003oool0103oool00`000000ooooo`0000070?ooo`03o`00003oool0
oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
000000X0oooo00?o00000?ooo`3oool00P3oool00`000000oooo000000040?ooo`030000003oool0
oooo00d0oooo0Ol000000003o`00003oool0oooo00h0oooo00Go00000?ooool0003o00000?ooo`02
o`0000040?ooo`0000000000000000/0oooo0`0000060?ooo`050000003ooooo00000?ooool00000
5`3oool00ol00000ooooo`00000=0?ooo`;o000000@0oooo0000003ooooo0000103oool200000080
oooo00<00000o`00003oool02`3oool3o`00008000003@3oool01`000000oooo00000?l000000000
0?ooo`000000103oool00`000000oooo0?ooo`02o`0000H0oooo00Co00000000003oool0oooo0P00
00050?ooo`8000006`3oool2o`0000030000003oool0oooo00L0oooo00?o00000?ooool000000`3o
ool3000000@0oooo00?o00000?ooo`3oool03@3oool1o`00000000?o00000?ooo`3oool01@3oool2
000000L0oooo00Go00000?ooo`3oool0ooooo`0000030?ooo`03o`00003oool0oooo00/0oooo00<0
00000?ooo`3oool00P0000050?ooo`05o`00003oool0oooo0?ooool000000P00000;0?ooo`03o`00
00000000oooo0080oooo00?o00000000000000000P0000000ol00000oooo0?ooo`0:0?ooo`;o0000
0`3oool00`000000oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
203oool3o`0000030000003oool0000000d0oooo00/000000?ooo`00000000000?ooo`000000oooo
o`0000000000oooo000000050?ooo`;o00001P3oool01@000000oooo0?ooo`3oool0000000H0oooo
00<000000?ooo`3oool09@3oool00ol00000ooooo`00000200000080oooo00D000000?ooo`3oool0
ooooo`0000060?ooo`800000203oool1o`00000000?o00000?ooo`3oool0103oool010000000oooo
0?ooo`0000060?ooo`03o`00003oool0oooo0180oooo00<000000?ooo`3oool00`3oool5000000L0
oooo00H000000?ooo`3oool0ooooo`00000000040?ooo`06o`00003oool000000000003oool00000
0P3oool00ol0000000000?ooo`0;0?ooo`;o0000103oool2000000050?ooo`000000oooo0?ooo`00
0000203oool00`000000oooo0?ooo`060?ooo`?o000000<000000?ooo`0000003`3oool200000004
0?ooo`000000oooo00000080oooo00<000000?ooo`3oool01P3oool00ol00000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooool000001P3oool00ol00000oooo0?ooo`0U0?ooo`03o`00003oool0
oooo00<0oooo00@000000?ooo`3oool000001P3oool01?l00000oooo0?ooo`0000020?ooo`03o`00
003oool0oooo0080oooo0Ol000000003o`00003oool0oooo00@0oooo0P0000000`3oool000000?oo
o`040?ooo`030000003ooooo000000?o0000303oool200000080oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`030?ooo`<0000000Co00000?ooo`3oool0oooo0P0000050?ooo`05o`00
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`03o`00003oool0oooo0080
oooo00L000000?ooo`3oool0oooo0000003oool0000000T0oooo00<000000?ooo`3oool01@3oool0
1P00003o0000000000000000oooo00000100oooo00P000000?ooo`00003o00000000003ooooo0000
000000D0oooo00D000000?ooo`3oool0ooooo`0000060?ooo`030000003oool0oooo0080oooo00?o
00000000000000000`3oool00`000000oooo0?ooo`0V0?ooo`8000000`3oool010000000oooo0?oo
o`0000060?ooo`040000003oool0oooo00000080oooo00?o00000?ooo`3oool00P3oool1o`000000
00?o00000?ooo`3oool00`3oool2000000030?ooo`000000oooo00@0oooo0P0000040?ooo`03o`00
003oool0oooo00P0oooo00Co00000000003oool000000P3oool01@000000oooo0?ooo`3ooooo0000
00@000001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo0P0000020?oo
o`030000003oool0oooo00`0oooo00Go00000?ooo`3oool0oooo000000030?ooo`030000003oool0
000000T0oooo00<000000?ooo`3oool01@3oool00`00003o000000000003000000H0oooo00?o0000
0?ooo`3oool02@3oool01Ol00000ooooo`00003oool000000080oooo0P0000030?ooo`8000000P3o
ool2o`0000D0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000002T0oooo
100000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000001`3oool1o`00000000?o
00000?ooo`3oool00P3oool300000003o`00003oool0oooo00<0oooo0P0000000`3ooooo00000?oo
o`030?ooo`03o`00003oool0oooo00L0oooo00Oo00000?ooo`3oool0ooooo`00003oool000000080
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`<000000`3oool00`00003o
0000o`00000=0?ooo`04o`00003oool0oooo000000@0oooo00<000000?ooool000001`3oool00`00
003o0000000000050?ooo`0600000?l0003o000000000?l000000000203oool00`00003o00000?oo
o`0:0?ooo`03o`00003oool00000008000000`3oool00`000000oooo000000020?ooo`8000000P3o
ool3o`000080oooo00?o00000000000000001P3oool01_l00000oooo0?ooo`3ooooo0000000002d0
oooo00?o00000?ooo`3oool0103oool2000000030?ooool00000oooo00H0oooo0Ol000000003o`00
003oool0oooo00d0oooo00<000000?ooo`3oool00`3oool00ol00000oooo0?ooo`070?ooo`04o`00
00000000000000000080oooo00<000000?ooo`0000002P3oool00`000000oooo0?ooo`0:0?ooo`80
00000`3oool2000000@0oooo0_l000040?ooo`;o00001@3oool00ol00000oooo000000050?ooo`03
0000003ooooo000000<0oooo100000080?ooo`040000003oool000000?ooo`800000203oool00`00
0000oooo0000000;0?ooo`80000000<0oooo0000000000000P3oool00`000000oooo000000040?oo
o`<000000P3oool3o`000080oooo00?o00000?ooo`3oool0103oool00ol0000000000?ooo`020?oo
o`030000003oool0oooo02/0oooo1P0000040?ooo`8000001@3oool1o`00000000?o00000?ooo`3o
ool04`3oool00ol00000oooo0?ooo`0>0?ooo`040000003oool0oooo000000H0oooo00?o00000?oo
o`0000002`3oool00ol00000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00Co0000
0?ooo`3ooooo00000P3oool01ol00000oooo0?ooo`3ooooo00000?ooo`0000001P3oool01P000000
oooo0?ooool00000oooo000000/0oooo00@000000?ooo`00003o00000P0000040?ooo`0400000?l0
000000000?ooo`8000000P3oool2000000/0oooo00Ko00000?ooo`00000000000?ooo`0000020?oo
o`030000003oool0oooo00@0oooo0P0000030?ooo`04o`00003oool0ooooo`0000L0oooo00D00000
0?ooo`3oool0ooooo`00000h0?ooo`030000003oool0oooo0080oooo0Ol000000003o`00003oool0
oooo01<0oooo00?o00000?ooo`3oool04@3oool00`000000oooo0?ooo`040?ooo`040000003oool0
oooo00000080oooo0`0000040?ooo`8000000P3oool2000000040?ooo`000000oooo00000080oooo
0P0000020?ooo`03o`00003ooooo00000080oooo00Co00000?ooool0003o00000P3oool010000000
oooo0?ooo`3oool300000003o`00003ooooo00000080oooo00<000000?ooo`3oool01P3oool01Ol0
0000oooo0?ooo`00003o00000080000000<0oooo0000003oool00`3oool010000000oooo0?ooo`00
00060?ooo`8000002P3oool3000000050?ooool00000oooo0?ooool00000203oool3000000050?oo
ool00000oooo0?ooo`0000001P3oool01Ol00000oooo0?ooo`3oool0000000h0oooo0P0000020?oo
o`<00000:03oool1o`00000000Go00000?ooo`3oool0ooooo`00000;0?ooo`03o`00003oool0oooo
0080oooo00?o00000?ooo`3oool04@3oool00`000000oooo000000040?ooo`030000003oool00000
0080oooo0P0000030?ooo`80000000<0oooo0000003oool00P3oool01_l00000oooo0?ooo`000000
oooo00000080oooo00<000000?ooo`0000000`3oool00ol00000oooo0?ooo`020?ooo`03o`00003o
ool0oooo0080oooo00Go00000?ooo`3oool0oooo000000030?ooo`@00000203oool2o`000080oooo
00H00000o`000000000000000?ooo`0000030?ooo`030000003oool0oooo0080oooo100000040?oo
o`800000203oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool0203oool00ol0
0000ooooo`000002o`0000030000003oool0oooo00@0oooo00@000000?ooo`3oool000003P3oool0
10000000oooo0000000000030?ooo`03o`00003oool0oooo01L0oooo0P0000000ol00000oooo0?oo
o`030?ooo`800000103oool1o`00000000Co00000?ooo`3oool0oooo0_l000090?ooo`;o00000`3o
ool3o`0000`0oooo0_l000030?ooo`80000000<0oooo0000000000000`3oool00`000000ooooo`00
00090?ooo`030000003oool0000000;o0000103oool010000000ooooo`000?l000030?ooo`030000
003oool0oooo00H000000P3oool2000000@0oooo00D000000?ooo`3oool00000o`0000090?ooo`Co
00000P3oool01P00003o0000000000000000oooo000000<0oooo00?o00000?ooo`3oool00P000003
0?ooo`8000000_l000001P000000oooo0?ooo`00003o0000000000@0oooo0`0000001?l00000oooo
0?ooo`0000030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool00ol00000
00000?ooo`040?ooo`80000000<0oooo00000?l00000303oool00`000000oooo0?ooo`060?ooo`04
o`00000000000000000001@0oooo00Go00000?ooo`3oool0ooooo`00000200000003o`0000000000
oooo00D0oooo0Ol000000003o`00003oool0oooo00d0oooo00?o00000?ooo`3oool0103oool00ol0
0000oooo0?ooo`060?ooo`03o`0000000000oooo00L0oooo00<000000?ooo`3oool0103oool00ol0
0000oooo0?ooo`080?ooo`8000001`3oool010000000oooo00000?l000030?ooo`040000003oool0
oooo000000@0oooo00<000000?ooool000001P3oool00`000000oooo0?ooo`02000000T0oooo00?o
00000?ooo`3oool00`3oool01000003o00000000000000020?ooo`04o`000000000000000?ooo`L0
00000`3oool500000080oooo100000020?ooo`8000000P3oool01@000000oooo0?ooo`3oool00000
00P0oooo00<000000?ooo`3oool00`3oool00ol0000000000?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`03o`00003oool0oooo
0180oooo00?o00000000000000002`3oool1o`00000000?o00000?ooo`3oool05@3oool00ol00000
oooo0?ooo`050?ooo`03o`00003oool0000001P0oooo00?o00000?ooo`3oool01P3oool01?l00000
oooo0000003oool2o`000080oooo00<000000?ooo`0000001@3oool00ol00000oooo000000050?oo
o`040000003oool0oooo0?ooo`800000203oool00ol00000ooooo`0000030?ooo`040000003oool0
oooo0?ooo`<000000`3oool00ol000000000000000050?ooo`?o00000P3oool2000000030?ooo`00
0000000000@0oooo00<00000o`00000000000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00@0oooo00?o00000?ooo`3oool00P3oool2o`000080oooo00Co00000?ooo`3ooooo0000
1`3oool2000000T0oooo00<000000?ooo`3oool01@3oool5000000030?ooool00000oooo01@0oooo
00?o00000?ooo`3oool02@3oool1o`00000000?o00000?ooo`3oool05@3oool00ol00000oooo0?oo
o`050?ooo`800000603oool00ol00000oooo0?ooo`030?ooo`@0000000D0oooo00000?l00000oooo
o`0000030?ooo`030000003oool0000000<0oooo100000040?ooo`0300000?l00000oooo00<0oooo
00?o00000?ooool000001`3oool00ol00000ooooo`0000030?ooo`050000003oool000000?ooo`00
00000P3oool400000080oooo1Ol000030?ooo`;o00000P3oool00`000000oooo0?ooo`0200000004
0?ooo`000000oooo0?ooo`<0000000?o00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo00Co00000?ooo`3oool0oooo0P0000020?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`05o`00003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00T0oooo0Ol0
00000003o`00003oool0oooo00P0oooo00?o00000?ooo`3oool02P3oool00ol00000oooo0?ooo`05
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`3oool00ol00000oooo00000003
000000D0oooo0P0000000`3oool000000?ooo`020?ooo`040000003oool0ooooo`0000@0oooo00<0
00000?ooo`3oool01@3oool00ol0000000000?ooo`070?ooo`;o00000`3oool3000000030?ooool0
0000000000@0000000<0ooooo`000?l000002P3oool2o`0000030?ooool00000oooo0080oooo00D0
00000?ooo`3oool000000?ooo`02000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`020?ooo`04o`00003ooooo0000000000D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool200000003
0?ooo`000000oooo01<0oooo00D000000?ooo`3oool0ooooo`000002000000@0oooo0Ol000000003
o`00003oool0oooo00L0oooo0ol0000;0?ooo`03o`00003oool0oooo01T0oooo1@0000040?ooo`80
000000<0ooooo`00003oool01P3oool2000000<0oooo0P0000001@3ooooo00000?ooo`3ooooo0000
00@0oooo00?o00000?ooo`3oool01`3oool00ol0000000000?ooo`060?ooo`;o00000`3oool01@00
0000oooo0?ooo`00003o000000D0oooo00?o00000?ooo`3oool0303oool00ol00000ooooo`000005
0?ooo`80000000?o00000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080oooo00Co00000?ooool0000000001`3oool00ol0000000000?ooo`030?ooo`04o`00003o
ool0ooooo`0000P0oooo00?o00000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`040000
003ooooo0000000001<0oooo0`0000070?ooo`7o000000000ol00000oooo0?ooo`0=0?ooo`03o`00
00000000oooo00D0oooo00?o00000?ooo`3oool05`3oool2000000P0oooo00Oo00000?ooo`3oool0
oooo00000?l00000000000@0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooool00006
0?ooo`03o`00003oool0oooo00D0oooo0_l000080?ooo`03o`00003ooooo000000D0oooo00<00000
o`00003oool00`3oool00ol00000oooo0?ooo`0>0?ooo`04o`00003oool00000000000<0oooo0`00
00000`3oool000000?ooo`03000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool00`00
0002o`0000030?ooo`000000oooo00L0oooo00@000000?ooo`3oool0oooo0P0000000`3oool00000
0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool010000000oooo
0?ooo`00000L0?ooo`7o000000000ol00000oooo0?ooo`0<0?ooo`05o`00003oool0ooooo`000000
0000103oool00ol00000oooo0?ooo`0F0?ooo`030000003oool0oooo00L0oooo00`000000?ooo`3o
ool0oooo0000003ooooo00000?ooo`000000oooo00000?l0000:0?ooo`030000003oool0oooo00H0
oooo00?o00000?ooo`3oool00P3oool6o`0000H0oooo00Co00000?ooo`3ooooo00000`3oool01000
0000oooo0?ooool000020?ooo`03o`00003oool0oooo00`0oooo00Go00000000003oool0ooooo`00
00020?ooo`03o`0000000000oooo00H000000`3oool00ol0000000000?ooo`020?ooo`040000003o
ool0oooo000000<0oooo00D000000?ooool00000oooo000000080?ooo`04o`00003oool000000?oo
o`80000000<0oooo0000003oool01P3oool00`000000oooo0?ooo`040?ooo`0300000?l00000oooo
00H0oooo0P0000000`3oool000000?ooo`0J0?ooo`7o000000000ol00000oooo0?ooo`0=0?ooo`04
o`00003oool0oooo000000@0oooo00?o00000?ooo`3oool05P3oool00ol00000oooo0?ooo`070?oo
o`060000003oool0oooo00000?l00000oooo0P0000020?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01`3oool02?l00000oooo0?ooo`3ooooo00000?ooo`000000oooo0_l000060?oo
o`04o`00003oool0ooooo`0000<0oooo00L000000?ooo`3oool0ooooo`00003ooooo000000h0oooo
0P0000020?ooo`06o`00003oool0oooo0?ooo`000000oooo0P0000020?ooo`030000003oool0oooo
0080oooo00?o00000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`050000003ooooo
00000?ooo`0000002@3oool00ol00000ooooo`0000030?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0000001D0oooo00<0
00000?ooo`3oool00P3oool1o`00000000?o00000?ooo`3oool03@3oool010000000oooo0?ooo`00
00030?ooo`03o`00003oool0oooo01H0oooo00<000000?ooo`3oool01`3oool010000000oooo0000
000000030?ooo`040000003oool0oooo000000D0oooo0P0000060?ooo`80000000?o00000?ooo`3o
ool0103oool010000000oooo0?ooool000020?ooo`040000003oool0ooooo`000080oooo00Co0000
0?ooo`3ooooo0000103oool01?l00000oooo0?ooo`0000040?ooo`03o`00003oool0oooo00d0oooo
00<000000?ooo`3oool00P3oool01?l00000oooo0?ooo`0000020?ooo`80000000D0oooo0000003o
ool0ooooo`0000060?ooo`05o`00003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooool0
0000ooooo`0000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00ol00000ooooo`00000D0?ooo`030000
003oool0oooo0080oooo0Ol000000003o`00003oool0oooo00h0oooo00<00000o`000?l000000`3o
ool00ol00000oooo0?ooo`0:0?ooo`;o00002@3oool00`000000oooo0?ooo`070?ooo`<0000000?o
00000?ooo`3oool00`3oool2000000D0oooo00@000000?ooo`3oool000001@3oool3000000L0oooo
00<000000?ooool000000P3oool010000000oooo0?ooo`3oool200000004o`00003oool0ooooo`00
00@0oooo00Co00000?ooo`00000000006@3oool01?l00000oooo0?ooo`0000020?ooo`080000003o
oooo00000000003ooooo00000?ooool000050?ooo`030000003oool0oooo0080oooo0`0000030?oo
o`03o`00003ooooo000000P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00ol00000ooooo`00000B0?oo
o`030000003oool0oooo00<0oooo0Ol000000003o`00003oool0oooo01@0oooo00?o00000?ooo`3o
ool05@3oool00`000000oooo0?ooo`050?ooo`@000001@3oool2000000H0oooo00Go00000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00L0oooo00?o00000?ooool000000`3oool01000
0000oooo0000000000020?ooo`040000003oool0ooooo`0000<0oooo00?o00000?ooool000000`3o
ool2o`0000D0oooo0P000002o`0000d0oooo00Go00000?ooo`3oool0oooo000000020?ooo`06o`00
0000003o00000000003ooooo00001P3oool00`000000oooo0?ooo`090?ooo`03o`00003ooooo0000
00P0oooo00?o00000?ooo`3oool00P3oool00ol0000000000?ooo`050?ooo`030000003oool0oooo
00D0oooo00?o00000000000000002@3oool5000000l0oooo00<000000?ooo`3oool00`3oool1o`00
000000?o00000?ooo`3oool05@3oool00ol00000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0
oooo00Go00000?ooo`000000ooooo`00000200000080oooo00<000000?ooo`3oool01@3oool00ol0
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooool000000`3oool200000007o`0000000000
oooo0?ooool00000ooooo`0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooool00000
0P3oool01?l00000ooooo`00003oool3o`0000030?ooool00000oooo0080oooo0P0000040?ooo`03
o`00003oool0oooo0080oooo0ol000060?ooo`05o`00003oool0oooo0?ooo`0000000P3oool01?l0
00000000o`00000000060?ooo`030000003oool0oooo00X0oooo00Co00000?ooo`3oool000000P3o
ool2o`0000<0000000<0ooooo`0000000000103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00L0oooo00<00000o`00003oool0203oool4000000l0oooo00<000000?ooo`3oool00P3o
ool1o`00000000?o00000?ooo`3oool05@3oool00ol00000oooo0?ooo`0B0?ooo`0300000?l00000
oooo00@0oooo0P0000020?ooo`04o`00003oool00000000000<0oooo00<000000?ooo`3oool0103o
ool00ol00000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0000003ooooo000000/0oooo00T000000?ooool00000ooooo`00003oool0
00000?ooool00000103oool01?l00000oooo0?ooo`0000070?ooo`Co00000P3oool00ol00000oooo
0?ooo`050?ooo`04o`00003oool0oooo00000080oooo00D000000?ooo`3oool00000o`0000030000
00030?ooo`000000oooo00`0oooo00Co00000?ooo`3oool000000`3oool01Ol0000000000000003o
ool000000080oooo00D000000?ooo`3oool0oooo000000060?ooo`03o`00003oool0oooo00T0oooo
00?o00000?ooo`3oool0103oool200000080oooo00<000000?ooo`0000003P3oool00ol00000oooo
0?ooo`020?ooo`7o000000000ol00000oooo0?ooo`0;0?ooo`05o`0000000000000000000?l00000
103oool00ol00000oooo0?ooo`0B0?ooo`030000003oool0oooo00@0oooo00Go00000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`030?oo
o`04o`00003ooooo000000000080oooo0P0000060?ooo`050000003oool0oooo0?ooool000002@3o
ool01@000000oooo0?ooo`3ooooo00000080oooo00D000000?ooool00000ooooo`0000020?ooo`03
o`00003oool0000000l0oooo00?o00000?ooo`3oool01@3oool00ol00000oooo000000030?ooo`80
000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`0;0?ooo`;o00000`3oool00ol00000
oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo00000006
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`000000ooooo`000002
0?ooo`03o`00003ooooo00000180oooo0Ol000000003o`00003oool0oooo00X0oooo0_l000040000
0005o`00003oool0oooo0?ooool000004`3oool00ol00000oooo0?ooo`050?ooo`040000003ooooo
0000000000H0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
0P3oool2000000@0oooo00<000000?ooo`3oool0103oool00ol00000oooo0?ooo`060?ooo`03o`00
003oool0oooo00@0oooo00X000000?ooool00000ooooo`00003oool00000o`00003ooooo00002`3o
ool2o`0000<0oooo1_l000030?ooo`03o`0000000000oooo00@0oooo00<000000?ooool000003`3o
ool00ol00000oooo0?ooo`020?ooo`80000000?o00000?ooo`3oool00P3oool01000003o00000000
000000020?ooo`8000000P3oool00`000000oooo0?ooo`040?ooo`0300000?l00000oooo00T0oooo
0`0000000`3oool00000o`00000200000080oooo0P0000000`3ooooo00000000000@0?ooo`7o0000
00001Ol00000oooo0?ooo`3ooooo00000180oooo00?o00000?ooo`3oool04P3oool00ol00000oooo
0?ooo`030?ooo`030000003oool0000000H0oooo0P0000050?ooo`0300000?l00000oooo00D0oooo
00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo0?ooo`8000001@3oool00ol0
0000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00/000000?ooo`3ooooo00000?ooo`00
0000oooo00000?l00000oooo000000070?ooo`Co00000P3oool00ol00000oooo0?ooo`060?ooo`05
o`00003oool0ooooo`0000000000103oool01@000000oooo0?ooo`3ooooo000000d0oooo00Co0000
0?ooo`3oool0oooo0P00000?0?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool02P3o
ool2000000L0oooo0`00000@0?ooo`7o000000000ol00000oooo0?ooo`020?ooo`03o`00003oool0
oooo00l0oooo00?o00000?ooo`3oool04`3oool02Ol00000oooo0?ooo`3ooooo00000?ooo`000000
ooooo`000003000000030?ooo`000000oooo0080oooo00@00000o`000?l000000000203oool00ol0
0000oooo0?ooo`020?ooo`08o`00003oool0oooo0?ooool00000oooo0000003oool2000000D0oooo
00?o00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`040000003oool0ooooo`0000<0
oooo00<000000?ooool000000P3oool00`000000oooo0?ooo`030?ooo`;o00001P3oool2o`0000L0
oooo0_l000000`3oool000000?ooo`020?ooo`030000003oool0oooo0080oooo00?o00000?ooo`3o
ool0103oool00ol000000000000000030?ooo`05o`00003oool0oooo0?ooo`0000001`3oool01?l0
0000000000000?l00002000000D0oooo00?o00000000003oool0203oool00`00003o00000?ooo`0;
0?ooo`0300000?l00000oooo00H0oooo0P00000?0?ooo`7o000000001Ol00000oooo0?ooo`3ooooo
00000180oooo00?o00000?ooo`3oool04@3oool300000080oooo0P0000001@3oool000000?ooool0
000000000080oooo00D000000?ooo`3oool0oooo0000000=0?ooo`050000003oool0oooo0?ooo`00
00000`3oool010000000oooo0?ooool000060?ooo`03o`00003oool0oooo0080oooo00@000000?oo
o`3oool000001@3oool010000000oooo0?ooool000050?ooo`05o`00003oool0oooo0000003oool0
1?l000090?ooo`03o`00003oool0oooo00;o00000`3oool2o`0000030?ooo`000000oooo0080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`03o`00003oool0oooo00<0oooo
00Go00000?ooo`3oool0oooo000000080?ooo`03o`0000000000oooo0080oooo100000000ol00000
oooo0000000:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool2000000l0
oooo0Ol000000003o`00003oool0oooo00H0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo
0?ooo`0?0?ooo`8000000P3oool3000000030?ooool00000000000D0oooo00Go00000?ooo`3oool0
oooo0000000>0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`080?oo
o`04o`00003oool0oooo0?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooool00000103oool00ol00000oooo000000020?ooo`03o`00003oool0oooo00/0oooo0_l0
00000`3ooooo00000?ooo`020?ooo`05o`00003ooooo00000?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<000001`3oool01Ol00000oooo0?ooo`3oool0000000T0
oooo0P0000080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo000000h0oooo0Ol000000003o`00003oool0oooo00D0
oooo0ol0000<0?ooo`03o`00003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool200000003
0?ooo`000000000000@0oooo0P0000030?ooo`03o`00003oool0oooo00`0oooo0P0000020?ooo`80
00000P3oool010000000oooo0?ooo`3oool3o`0000040?ooool0003o0000o`0000<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooool00000103o
ool01Ol00000oooo0000003ooooo00000180oooo0_l000020?ooo`04o`00003ooooo000000000080
oooo00<000000?ooo`3oool0103oool2000000<0oooo00<000000?ooo`3oool0103oool3o`000003
0?ooool00000000000<0000000?o0000000000000000103oool00`000000oooo0?ooo`050?ooo`03
o`00003oool0oooo00P0oooo0`00000<0?ooo`03o`00000000000000008000000`3oool00ol00000
oooo0?ooo`0<0?ooo`7o000000000ol00000oooo0?ooo`0D0?ooo`03o`00003oool0oooo00d0oooo
00Co00000?ooo`3oool0oooo0P0000000`3oool00000000000040?ooo`8000001@3oool00`000000
oooo0?ooo`080?ooo`04o`0000000000000000000080oooo0P0000030?ooo`0500000?l00000oooo
0?ooool000000`3oool00ol00000oooo0?ooo`040?ooo`030000003oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`03o`00003oool0oooo0080oooo00Go00000?ooo`000000oooo
o`00000D0?ooo`06o`00003ooooo00000?ooool0000000000P3oool00`000000oooo0?ooo`040?oo
o`8000000`3oool00ol00000oooo0?ooo`020?ooo`03o`0000000000oooo0080oooo0_l000070?oo
o`05o`00003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00D0oooo0`00000:0?ooo`03o`00003oool0oooo00/0oooo0Ol000000003o`00003oool0oooo
01@0oooo00?o00000?ooo`3oool03@3oool01?l00000oooo0?ooo`0000020?ooo`03o`00003oool0
oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`050000003oool0
oooo00000?l000000P0000020?ooo`03o`0000000000000000<0oooo00?o00000?ooo`3oool0203o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00?o00000?ooo`3o
ool00`3oool01?l0000000000?ooool0000F0?ooo`08o`00003ooooo0000o`00003oool000000?oo
o`0000060?ooo`8000000`3oool01Ol00000oooo0?ooo`3ooooo00000080oooo00<000000?ooo`3o
ool00P3oool2o`0000H0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo
00`0oooo00?o00000?ooo`3oool0103oool01Ol00000oooo0?ooo`3ooooo000000X0oooo00<00000
0?ooo`3oool02P3oool1o`00000000?o00000?ooo`3oool0503oool00ol00000oooo0?ooo`0=0?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool000000`3oool00`00003o00000?oo
o`040?ooo`;o00002`3oool01?l0000000000000000000020?ooo`030000003oool0000000D0oooo
00Ko00000?ooo`3oool0oooo0000003oool2o`0000030?ooool00000oooo01D0oooo00So00000?oo
ool0003o00000?ooo`000000ooooo`0000800000103oool2000000<0oooo00<000000?ooo`3oool0
0P3oool00ol000000000000000060?ooo`03o`00003oool0oooo00<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`030?ooo`03o`0000000000oooo00`0oooo00<000000?ooo`3oool0
0`3oool010000000oooo0?ooo`3oool3000000P0oooo00<000000?ooo`3oool02P3oool1o`000000
00?o00000?ooo`3oool03`3oool00ol00000oooo0?ooo`020?ooo`03o`00003oool0oooo00d0oooo
00@000000?ooo`3ooooo00000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000020?ooo`8000001@3oool2o`00
00l0oooo00H000000?ooo`00000000000?ooo`0000060?ooo`03o`00003oool0oooo008000000_l0
00020?ooo`03o`00003oool0oooo01D0oooo00Go00000?ooool00000ooooo`0000040?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`040?ooo`03
o`00003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo0P0000040?ooo`04
00000?l00000ooooo`0000/0oooo0Ol000000003o`00003oool0oooo00h0oooo0ol000040?ooo`03
o`00003oool0oooo00/0oooo0P0000000`3oool000000?ooo`040?ooo`03o`00003oool0oooo0080
oooo0P000000103oool00000o`000?l000080?ooo`80000000?o00000?ooo`0000000P3oool00`00
0000oooo0?ooo`040?ooo`03o`00003oool0oooo00T0oooo100000000`3oool00000000000030?oo
o`030000003oool0oooo00<0oooo0_l000020?ooo`80000000<0ooooo`000?l000000P3oool00ol0
0000oooo0?ooo`0E0?ooo`05o`00003ooooo00000?ooo`000000103oool01?l00000oooo0?ooo`00
00020?ooo`030000003oool0000000l0oooo00?o00000?ooo`3oool00P3oool01?l0000000000000
000000040?ooo`<000000P3oool00ol0000000000?ooo`0<0?ooo`03o`00003oool0oooo0080oooo
00<000000?ooo`3oool01@3oool200000004o`0000000000oooo00000080oooo00?o00000?ooo`3o
ool0203oool1o`00000000?o00000?ooo`3oool05@3oool00ol00000oooo0?ooo`090?ooo`800000
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo008000000P3oool00`000000oooo
0?ooo`070?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000800000
00<0ooooo`00003oool02@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00P3oool00ol00000oooo0?ooo`040?ooo`0300000?l0003o00000080oooo
00?o00000?ooo`3oool05@3oool00ol00000ooooo`0000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo000000030?ooo`03o`0000000000000000<000002@3oool00ol00000
oooo0?ooo`060?ooo`@000000`3oool010000000oooo0?ooo`3oool2000000`0oooo00Go00000000
00000000oooo0000000=0?ooo`040000003oool0ooooo`0000T0oooo0Ol000000003o`00003oool0
oooo01H0oooo00?o00000?ooo`3oool01P3oool00ol0000000000?ooo`040?ooo`030000003oool0
oooo00<000000P3oool01@000000oooo0?ooool00000000000L0oooo0P0000000ol00000oooo0?oo
o`020?ooo`03o`00003oool0oooo008000000P3oool01`000000oooo0?ooo`3oool000000?ooool0
0000203oool00ol00000oooo0?ooo`080?ooo`800000103oool00ol00000oooo0?ooo`050?ooo`04
o`00003ooooo0000o`0001P0oooo0_l000001@3ooooo00000?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo0000000:0?ooo`03o`00003oool0oooo00L0oooo00?o00000?ooo`3oool02@3o
ool01@000000oooo0?ooo`3ooooo000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo
0000000200000003o`00003oool0oooo00P0oooo00Co00000000003oool00000203oool1o`000000
00?o00000?ooo`3oool05P3oool00ol00000oooo0?ooo`060?ooo`040000003oool00000000000<0
oooo00@000000?ooo`3oool00000103oool00`000000ooooo`0000080?ooo`040000003oool0oooo
0?ooo`@0000000D0oooo000000000000oooo000000060?ooo`030000003oool0oooo00?o00001@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00?o00000?ooo`3oool01@3o
ool01?l00000ooooo`000?l000080?ooo`Go00002`3oool2o`0000030?ooool00000oooo0080oooo
00<000000?ooo`0000003`3oool3o`0000D0oooo00?o00000?ooo`3oool02@3oool00`000000oooo
0?ooo`030?ooo`03o`0000000000oooo0080oooo00?o00000?ooo`3oool02`3oool00ol000000000
0?ooo`030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`000000203oool1o`00000000?o
00000?ooo`3oool05@3oool00ol00000oooo0?ooo`080?ooo`060000003oool0oooo0000003oool0
00000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`0000001P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01Ol0
0000oooo0?ooo`3oool0000000X0oooo00@000000?ooool0003o00000`3oool00ol00000oooo0?oo
o`040?ooo`06o`00003oool0ooooo`00003ooooo00001P3oool01_l00000ooooo`000?l00000oooo
o`0000X0oooo00Go00000?ooool00000ooooo`0000040?ooo`030000003oool0000000L0oooo00?o
00000?ooo`3oool01`3oool5o`0000H0oooo00?o00000000000000000`0000080?ooo`80000000<0
oooo0000003oool03P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00@0
00000?ooo`3oool00000203oool1o`00000000?o00000?ooo`3oool05@3oool00ol00000oooo0?oo
o`0<0?ooo`0500000?l00000oooo0?ooo`0000000`3oool01?l00000oooo0?ooo`0000080?ooo`05
o`00003ooooo0000o`00000000001`3oool200000005o`00003oool0oooo0?ooool000000`3oool0
0`00003o00000?ooo`020?ooo`03o`00003oool0oooo008000001`3oool01@00003o00000?ooool0
0000oooo00;o000000<0ooooo`000?l000000P3oool01@000000oooo0?ooo`3ooooo00000080oooo
00Co00000?ooo`3ooooo00001@3oool2o`000080oooo00?o00000?ooool000001`3oool3o`000004
0?ooool00000ooooo`0000D0oooo0P0000070?ooo`03o`0000000000oooo0140oooo00<000000?oo
o`3oool03P3oool00`000000oooo0000000?0?ooo`03o`00003oool0oooo0080oooo00?o00000?oo
o`3oool01@3oool010000000oooo0?ooo`0000080?ooo`7o000000000ol00000oooo0?ooo`0D0?oo
o`03o`00003oool0oooo00P0oooo0`0000020?ooo`06o`00003oool0oooo0?ooo`000000oooo0P00
00020?ooo`03o`00003oool0oooo00H0oooo00Go00000?ooool00000oooo000000070?ooo`03o`00
003oool0oooo00T0oooo00D000000?ooo`3oool0ooooo`0000040?ooo`800000103oool01@000000
oooo0?ooo`3ooooo000000<0oooo00?o00000?ooo`3oool00P3oool01@000000oooo0?ooo`3ooooo
000000<0oooo00?o00000?ooool000001@3oool3o`0000040?ooool00000ooooo`0000L0oooo00Oo
00000?ooo`3oool0ooooo`00003ooooo000000D0oooo0P0000080?ooo`8000004@3oool00`000000
oooo0?ooo`0?0?ooo`03o`00003ooooo000000l0oooo00Go00000?ooo`3oool0oooo000000040?oo
o`8000000P3oool010000000oooo0?ooo`0000070?ooo`7o000000000ol00000oooo0?ooo`0D0?oo
o`03o`00003oool0oooo00L0oooo00D000000?ooo`3oool0ooooo`0000040?ooo`<000000`3oool0
0ol00000oooo0?ooo`060?ooo`05o`00003ooooo00000?ooo`0000001`3oool00`000000oooo0?oo
o`0;0?ooo`050000003oool0oooo0?ooool000001@3oool01000003o000000000?l000040?ooo`03
o`00003oool0oooo00D0oooo0P0000020?ooo`03o`00003oool0oooo00<0oooo00?o00000?ooool0
00000`3oool2o`0000040?ooool0000000000?ooo`;o00001P3oool00ol00000oooo0?ooo`020?oo
o`04o`00003oool0ooooo`0000@0oooo0P0000090?ooo`8000004@3oool00ol0000000000000000?
0?ooo`03o`00003ooooo000000l0oooo00Go00000?ooo`3oool0oooo000000020?ooo`80000000D0
ooooo`00003oool0oooo000000020?ooo`030000003oool0oooo00@0oooo0Ol000000003o`00003o
ool0oooo01@0oooo00?o00000?ooo`3oool0203oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0103oool400000080oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0;0?ooo`050000003oool0oooo0?ooool00000203oool00`000000
oooo0?ooo`020?ooo`03o`00003oool0oooo00D0oooo0P0000020?ooo`03o`00003oool0oooo00<0
oooo00?o00000?ooool000000_l00000103ooooo0000o`00003oool2000000030?ooool0003o0000
00H0oooo00Go00000?ooo`3oool0ooooo`0000030?ooo`03o`00003oool0oooo0080oooo00<00000
0?ooo`000000203oool2000000d0oooo00<000000?ooo`3oool0103oool2000000d0oooo00D00000
0?ooo`3ooooo00000000000>0?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo00@0oooo0Ol000000003o`00003oool0oooo01@0oooo
00?o00000?ooo`3oool02@3oool00`000000oooo000000030?ooo`800000103oool00`000000oooo
0?ooo`030?ooo`05o`0000000000ooooo`00003oool00`0000090?ooo`80000000?o00000?ooo`3o
ool0103oool4000000<0oooo00?o00000?ooo`3oool02`3oool00ol00000oooo0?ooo`050?ooo`04
0000003oool0oooo00000080oooo00?o00000?ooo`3oool00P3oool00ol00000oooo0?ooo`020?oo
o`0:o`00003ooooo00000000003oool000000?ooool00000ooooo`0000@0oooo00Go00000?ooo`3o
ool0ooooo`0000040?ooo`05o`00003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0000000d0oooo00<000000?ooo`3oool01P3oool200000003o`00003oool0
oooo00T0oooo0P0000020?ooo`030000003oool0oooo00`0oooo00@000000?ooo`3oool000001`3o
ool01?l00000oooo0?ooo`0000060?ooo`7o000000000ol00000oooo0?ooo`0D0?ooo`03o`00003o
ool0oooo00T0oooo00?o000000000?l000000P3oool00`000000oooo000000030?ooo`03o`000000
0000oooo00<0oooo100000000`3ooooo00000?ooo`0>0?ooo`8000000`3oool00ol00000oooo0?oo
o`040?ooo`;o00000`3oool2o`0000L0oooo00?o00000?ooo`3oool01P3oool01`000000oooo0?oo
o`3oool000000?ooool000001@3oool00ol00000oooo0?ooo`020?ooo`09o`000000000000000?oo
ool00000ooooo`00003ooooo000000<0oooo0_l000020?ooo`03o`00003oool0oooo00<0oooo00Co
00000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0000000`0oooo
00<000000?ooool000000P0000080?ooo`8000002`3oool00`000000oooo0?ooo`02000000d0oooo
00Co00000?ooo`00003o00000P0000050?ooo`040000003oool00000000000D0oooo0Ol000000003
o`00003oool0oooo00<0oooo0P00000?0?ooo`03o`00003oool0oooo00/0oooo00H000000?ooo`3o
ool000000?ooo`0000030?ooo`030000003oool0oooo0080oooo00Ko00000?ooool00000oooo0000
0?l0000B0?ooo`80000000?o00000?ooo`3oool00`3oool2o`0000D0oooo0P0000040?ooo`?o0000
2@3oool01`000000oooo0?ooo`3oool000000?ooool000001P3oool4o`0000<0oooo00@000000?oo
o`3ooooo00000P3oool00ol00000ooooo`0000030?ooo`03o`00003oool0oooo00@0oooo00Co0000
0?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0000000d0oooo00Co
00000?ooo`3oool0oooo1@0000050?ooo`03o`00003oool0oooo00P0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0`3oool010000000oooo0?ooo`0000040?ooo`7o000000000ol00000oooo0?ooo`020?ooo`800000
00<0ooooo`00003oool03P3oool00ol00000oooo0?ooo`0<0?ooo`80000000D0oooo0000003oool0
oooo000000040?ooo`05o`00003ooooo00000?ooo`0000006`3oool00ol00000oooo0?ooo`050?oo
o`030000003ooooo00000080oooo00?o00000?ooo`3oool02`3oool01P000000oooo000000000000
ooooo`000140oooo0_l000000`3ooooo00000?ooo`020?ooo`03o`00003oool0oooo00D0oooo00Co
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool0203oool00ol00000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo
00?o00000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`03o`0000000000oooo00X0oooo
00<000000?ooo`3oool00`3oool00o