(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.5,
MathReader 3.5, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10998,        333]*)
(*NotebookOutlinePosition[     41227,       1389]*)
(*  CellTagsIndexPosition[     41183,       1385]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["HTMLSave", "Title"],

Cell[CellGroupData[{

Cell["How to save your Notebook as HTML", "Section"],

Cell["\<\
Using the front end, issue the menu command:

  File
    Save As Special...
      HTML

to save the currently selected notebook.  A dialog box will prompt you for \
destination file or directory.\
\>", "Text"],

Cell["As a kernel command:", "Text"],

Cell[BoxData[
    \(HTMLSave["\<output.html\>", \ "\<input.nb\>"]\)], "Input"],

Cell[TextData[{
  StyleBox["Important",
    FontWeight->"Bold"],
  ":  Even when you execute this as a kernel command, the kernel must be \
connected to a front end.  HTMLSave needs certain services from the front end \
such as conversion to GIF, and it needs to query the front end for settings."
}], "Text"],

Cell["\<\
The second argument is interpreted as a notebook.  It can be a \
variety of things, including

\"filename.nb\"
\"window name\"
Notebook[] expression
NotebookObject[...]
{Cell, Cell, ...}
Cell[...]
BoxData[...]

If it isn't a complete notebook, e.g. a list of Cells or a BoxData, it will \
be wrapped in a Notebook to make it a whole document.\
\>", "Text"],

Cell[TextData[{
  "Note:  Although HTMLSave assumes that the conversion is of entire ",
  StyleBox["documents",
    FontSlant->"Italic"],
  ", a current item of development is conversion of individual box \
expressions or other pieces of notebooks to snippets of HTML.  This is \
analogous to the built-in TeXForm function, so we may add an HTMLForm \
function, or more likely, include it in the much more general Export \
mechanism in the upcoming version."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to map ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " styles to HTML elements"
}], "Section"],

Cell[TextData[{
  "The style sheet for any of your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks is a set of cells defining named styles that can be applied to \
whole cells, or to smaller pieces of text.  The style of a cell or a piece of \
text identifies that piece's meaning, and has a distinct appearance, and \
perhaps non-visual properties.  Hence, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " styles are used for markup, just as tags are in HTML, or in other SGML or \
XML applications.  They bind presentation and other properties to that named \
element type."
}], "Text"],

Cell["\<\
As a sample, from the ordinary Default.nb style sheet, here is the \
Cell defining the \"InlineFormula\" style:\
\>", "Text"],

Cell["\<\
Cell[StyleData[\"InlineFormula\"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LanguageCategory->Formula,
  ScriptLevel->1,
  SingleLetterItalics->True]\
\>", "Rule",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],

Cell[TextData[{
  "Once you have a style sheet for your notebook, you can add a cell option \
called ",
  StyleBox["ConversionRules", "Input"],
  " to some or all of these cells, in order to specify what HTML tag, or \
nested tags, this cell style should come out as in the HTML document."
}], "Text"],

Cell["\<\
Cell[StyleData[\"InlineFormula\"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LanguageCategory->Formula,
  ScriptLevel->1,
  SingleLetterItalics->True,
  ConversionRules -> 
    {\"HTML\" -> {{\"<B><CODE>\", \"</CODE></B>\"}, 
          {\"<P><B><CODE>\", \"</CODE></B></P>\"}}}]\
\>", "Rule",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],

Cell["\<\
The above specifies that any StyleBox of style \"MyStyle\" should \
have its contents wrapped in bold and code tags in HTML, and any whole cell \
of style \"MyStyle\" should additionally be wrapped in <P>, since it is \
block-level.\
\>", "Text"],

Cell[TextData[{
  "The HTML tags that specify appearance, e.g. <FONT>, are controversial, \
because they are often misused:  they are used instead of tags that convey \
meaning or structure, so they specify one notion of how a document should \
look, not what its parts mean or how they are structured.  The purists \
believe that appearance information should not be part of the document \
content at all.  Personally, I tend to stay away from them, but the less \
radical advice I give people is:  if you insist on embedding appearance \
directives, ",
  StyleBox["at least",
    FontSlant->"Italic"],
  " use them ",
  StyleBox["in addition to",
    FontSlant->"Italic"],
  " markup that indicates role (structure, meaning).  This way, information \
isn't lost, in case the document needs to be converted to something else \
later, or a filter strips out presentation tags.  During the development of \
Version 3, I used ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programs to convert between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks and other document languages, and I can tell you first hand \
that it is very time-consuming and frustrating to develop heuristics to \
figure out the different roles of pieces of text that were marked up as \
\"FontSize \[Rule] 14, FontFamily \[Rule] Courier\".  In one instance, the \
document author switched to Courier to represent a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function name, in another to represent code in another language such as \
C, in another to do something else."
}], "Text"],

Cell["\<\
The major browsers are growing more mature in this respect.  With \
the recent promotion of XML and Cascading Style Sheets Level 2 to full \
Recommendations at the World Wide Web Corsortium, and HTML 4.0 which official \
supports style sheet import, the future is in separation of appearance and \
structure.

With XML and style sheets, you can make up all your own element types to suit \
the meanings and structures you need, and associate appearance \
characteristics with them.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Philosophical point", "Subsection"],

Cell[TextData[{
  "It's important to use StyleBox in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " documents to convey the intended meaning and appearance, so HTMLSave \
doesn't have to guess or use vanilla markup rules.  This affords much more \
control to the author."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A few things added or fixed since 3.0", "Section"],

Cell["\<\
1.  More appearance characteristics are respected, e.g. font color, \
size, underlining, and so on.\
\>", "Text"],

Cell["\<\
2.  The \"tiny GIF\" problem for typeset expressions has been \
fixed.\
\>", "Text"],

Cell["\<\
3.  A lone GridBox is converted to a table, instead of to a \
monolithic GIF image.\
\>", "Text"],

Cell["\<\
But also, since so many people do manual formatting of tables in \
their text cells, using tabs, I added a heuristic to determine when a series \
of lines probably is meant as a table, and I convert that.\
\>", "Text"],

Cell["\<\
row  :=  [possible \\t]   a   [at least one \\t]

row possibly separated by one or more \\n\
\>", "Text"],

Cell[TextData[{
  StyleBox["Still",
    FontWeight->"Bold"],
  ", I recommend using in-line GridBox if you can, because it's better to \
have the meaning clearly conveyed in the source document."
}], "Text"],

Cell["4.  MathML output", "Text"],

Cell[TextData[{
  "5.  Brand new:  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s native linear syntax for typeset expressions, for which there is an \
applet that calls on the FE to produce graphic for it and render it in the \
HTML."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Future Directions:  Style sheets, SGML/XML", "Section"],

Cell["\<\
There is a fair amount of support for level 1 of Cascading Style \
Sheets in the version 4 browsers, but since the support is still erratic, and \
many people haven't upgraded to version 4 browsers, style sheets haven't been \
the highest development priority for HTMLSave yet.\
\>", "Text"],

Cell[TextData[{
  "In a future version, HTMLSave will include a CSS style sheet that makes \
HTML elements mimic ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " styles as much as possible.  Since the translation of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " styles to HTML elements is not one-to-one (the domain, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " styles, has no limit on the number of elements, some very rich style \
sheets might exist), perhaps the CLASS attribute available for all elements \
in HTML 4.0 will be used to distinguish the source document's markup \
elements, and to bind different appearance to them.\n\nExactly mimicking a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook might not be the author's intention, so of course this style \
sheet need not be used."
}], "Text"],

Cell[TextData[{
  "In a future version, there will be a program to take a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " style sheet, and convert it to another style sheet language, including \
CSS1, CSS2, and XSL.  With this, any custom style sheet could be approximated \
in the destination language.\n\nProbably this will also produce an XML DTD \
corresponding to the style sheet and notebook elements."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"3.5 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
ScreenStyleEnvironment->"Presentation",
WindowSize->{561, 697},
WindowMargins->{{Automatic, 94}, {Automatic, 7}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "villegas", 
  "villegas", "Development"}, "HTMLTalk.nb.ps", CharacterEncoding -> 
  "ISO8859-1"],
"Magnification"->1},
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->16],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook", "Presentation"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellBracketOptions->{"Color"->RGBColor[0.66717, 0.187915, 0.232395]},
    CellElementSpacings->{"ClosedGroupTopMargin"->20},
    CellFrameLabelMargins->6,
    StyleMenuListing->None,
    Background->RGBColor[0.924025, 0.891524, 0.771649]],
  
  Cell[StyleData["Notebook", "Printout"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellElementSpacings->{"ClosedGroupTopMargin"->20},
    CellFrameLabelMargins->6,
    StyleMenuListing->None,
    Background->None]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{40, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    CounterIncrements->"Title",
    CounterAssignments->{
      {"Section", 0}, {"Equation", 0}, {"Figure", 0}, {"Subtitle", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    ShowCellBracket->False,
    CellMargins->{{0, 100}, {0, 0}},
    CellFrameMargins->{{30, 100}, {10, 20}},
    AutoIndent->False,
    LineSpacing->{0, 44},
    FontSize->40,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.812512, 0, 0]],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{10, 10}, {12, 30}},
    CellFrameMargins->2,
    FontSize->26]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{40, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    CounterIncrements->"Subtitle",
    CounterAssignments->{
      {"Section", 0}, {"Equation", 0}, {"Figure", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    ShowCellBracket->False,
    CellMargins->{{98, 0}, {20, 0}},
    CellFrameMargins->{{10, 4}, {4, 6}},
    AutoIndent->False,
    LineSpacing->{0, 34},
    FontSize->30,
    Background->RGBColor[0.833814, 0.797284, 0.0792248]],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{40, 10}, {1, 0}},
    FontSize->18]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Author"],
    CellMargins->{{100, Inherited}, {20, 0}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Author", "Presentation"],
    CellFrame->{{0, 0}, {2, 0}},
    ShowCellBracket->False,
    CellMargins->{{98, 0}, {60, 10}},
    CellFrameMargins->{{4, 4}, {2, 8}},
    LineSpacing->{1, 0},
    FontSize->22,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Author", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Author", "Printout"],
    CellMargins->{{40, 10}, {60, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellFrame->{{0, 0}, {0, 2}},
    CellDingbat->None,
    CellMargins->{{40, 22}, {0, 30}},
    CellFrameMargins->{{99, 0}, {1, 4}},
    CellFrameColor->RGBColor[0.708598, 0.00158694, 0.047715],
    CellFrameLabelMargins->{{4, 4}, {0, 2}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellDingbat->None,
    CellMargins->{{10, 0}, {4, 22}},
    CellFrameMargins->3,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellFrame->{{0, 0}, {0, 2}},
    CellMargins->{{40, 22}, {0, 30}},
    CellFrameMargins->{{0, 0}, {0, 2}},
    CellFrameColor->GrayLevel[1],
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{10, 0}, {0, 22}},
    CellFrameMargins->3,
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{99, 60}, {0, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{40, 0}, {0, 25}},
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Rule"],
    CellMargins->{{10, Inherited}, {8, 18}},
    PageBreakBelow->False],
  
  Cell[StyleData["Rule", "Presentation"],
    CellFrame->{{0, 0}, {3, 0}},
    CellMargins->{{99, 60}, {0, 40}},
    CellFrameMargins->False,
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Rule", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Rule", "Printout"],
    CellMargins->{{10, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{99, 22}, {10, 10}},
    TextAlignment->Left,
    TextJustification->0,
    LineSpacing->{1, 3},
    FontSize->16],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{40, 2}, {6, 6}},
    TextJustification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{119, 22}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->12,
    FontColor->RGBColor[0.0899214, 0.182635, 0.460777]],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{50, 2}, {5, 5}},
    TextJustification->0.5,
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{99, 45}, {0, 10}},
    CellFrameMargins->12,
    LineSpacing->{1, 0},
    FontSize->16,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.28748, 0.378042, 0.556527],
    ButtonBoxOptions->{ButtonMinHeight->0.125,
    ButtonMargins->9,
    Background->RGBColor[0.665293, 0.0723888, 0.101137]}],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input", "Printout"],
    CellFrame->True,
    CellMargins->{{40, 0}, {0, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9,
    Background->GrayLevel[0.849989]]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    CellMargins->{{99, Inherited}, {Inherited, Inherited}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InputWord"],
    CellMargins->{{99, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"InputGrouping",
    AutoItalicWords->{},
    FormatType->InputForm,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{99, 45}, {10, 0}},
    CellFrameMargins->12,
    LineSpacing->{1, 0},
    FontSize->16,
    Background->RGBColor[0.978958, 0.959915, 0.622477]],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}}],
  
  Cell[StyleData["Output", "Printout"],
    CellFrame->True,
    CellMargins->{{40, 0}, {6, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{99, 45}, {Inherited, Inherited}},
    CellFrameMargins->12,
    LineSpacing->{1, 0},
    FontColor->RGBColor[0.694072, 0.204471, 0.227802],
    Background->RGBColor[0.963821, 0.948333, 0.891249]],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{40, Inherited}, {Inherited, Inherited}},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{99, 45}, {0, 0}},
    CellFrameMargins->{{12, 12}, {2, 2}},
    LineSpacing->{1, 0},
    Background->GrayLevel[1]],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{50, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None],
  
  Cell[StyleData["Graphics", "Presentation"],
    CellMargins->{{99, 45}, {10, 0}},
    Background->RGBColor[0.978958, 0.959915, 0.622477]],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    CellFrame->True,
    CellMargins->{{40, 0}, {0, -1}},
    ImageMargins->{{40, Inherited}, {Inherited, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontSize->7,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{99, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{10, 0}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    CellMargins->{{99, Inherited}, {Inherited, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1}],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    CellMargins->{{10, Inherited}, {Inherited, Inherited}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"]],
  
  Cell[StyleData["Hyperlink", "Condensed"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"]],
  
  Cell[StyleData["MainBookLink", "Condensed"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"]],
  
  Cell[StyleData["AddOnsLink", "Condensed"]],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"]],
  
  Cell[StyleData["RefGuideLink", "Condensed"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"]],
  
  Cell[StyleData["GettingStartedLink", "Condensed"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"]],
  
  Cell[StyleData["OtherInformationLink", "Condensed"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    Placeholder->Primary,
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Condensed"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Expression Annotation Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to effect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to
make them stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    FontColor->RGBColor[0.760006, 0.330007, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Automatic Numbering", "Section"],
  
  Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{55, 10}, {0, 10}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{55, 55}, {0, 10}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedFigure"],
    CellMargins->{{55, 145}, {2, 10}},
    CellHorizontalScrolling->True,
    CellFrameLabels->{{None, None}, {Cell[ 
            TextData[ {"Figure ", 
              CounterBox[ "NumberedFigure"]}], FontWeight -> "Bold"], None}},
    CounterIncrements->"NumberedFigure",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedFigure", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedTable"],
    CellMargins->{{55, 145}, {2, 10}},
    CellFrameLabels->{{None, None}, {Cell[ 
            TextData[ {"Table ", 
              CounterBox[ "NumberedTable"]}], FontWeight -> "Bold"], None}},
    TextAlignment->Center,
    CounterIncrements->"NumberedTable",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedTable", "Printout"],
    CellMargins->{{18, Inherited}, {Inherited, Inherited}},
    FontSize->10]
  }, Closed]]
  }, Closed]]
  }, Open  ]]
  }]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 25, 0, 74, "Title"],

Cell[CellGroupData[{
Cell[1789, 55, 52, 0, 63, "Section"],
Cell[1844, 57, 219, 9, 188, "Text"],
Cell[2066, 68, 36, 0, 41, "Text"],
Cell[2105, 70, 78, 1, 55, "Input"],
Cell[2186, 73, 309, 6, 126, "Text"],
Cell[2498, 81, 366, 14, 314, "Text"],
Cell[2867, 97, 470, 9, 167, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3374, 111, 128, 5, 90, "Section"],
Cell[3505, 118, 619, 13, 209, "Text"],
Cell[4127, 133, 135, 3, 62, "Text"],
Cell[4265, 138, 270, 9, 169, "Rule"],
Cell[4538, 149, 301, 6, 125, "Text"],
Cell[4842, 157, 398, 12, 259, "Rule"],
Cell[5243, 171, 256, 5, 104, "Text"],
Cell[5502, 178, 1599, 32, 503, "Text"],
Cell[7104, 212, 505, 10, 230, "Text"],

Cell[CellGroupData[{
Cell[7634, 226, 41, 0, 55, "Subsection"],
Cell[7678, 228, 295, 7, 104, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8022, 241, 56, 0, 63, "Section"],
Cell[8081, 243, 123, 3, 62, "Text"],
Cell[8207, 248, 94, 3, 62, "Text"],
Cell[8304, 253, 107, 3, 62, "Text"],
Cell[8414, 258, 228, 4, 104, "Text"],
Cell[8645, 264, 115, 4, 83, "Text"],
Cell[8763, 270, 207, 5, 84, "Text"],
Cell[8973, 277, 33, 0, 41, "Text"],
Cell[9009, 279, 261, 7, 104, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9307, 291, 61, 0, 90, "Section"],
Cell[9371, 293, 301, 5, 125, "Text"],
Cell[9675, 300, 861, 19, 314, "Text"],
Cell[10539, 321, 431, 8, 188, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

