(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    504590,       9836]
NotebookOptionsPosition[    392497,       7587]
NotebookOutlinePosition[    491039,       9616]
CellTagsIndexPosition[    489912,       9569]
WindowTitle->Writing Good Code: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Writing Good Code", "SectionInline",ExpressionUUID->
   "0b667fa7-77b4-4226-9f22-88ab44b7d6aa"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 45}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:283",
 CellLabel->"In[50]:=",ExpressionUUID->"85ac732c-9e72-42bf-b534-d0fbbeb7cb5f"],

Cell["\<\
Writing good code is in many ways like writing good prose: you need to have \
your thoughts clear, and express them well. When you first start writing \
code, you\[CloseCurlyQuote]ll most likely think about what your code does in \
English or whatever natural language you use. But as you become fluent in the \
Wolfram Language you\[CloseCurlyQuote]ll start thinking directly in code, and \
it\[CloseCurlyQuote]ll be faster for you to type a program than to describe \
what it does.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"4a6a7379-0b00-40a0-a090-c0676543deff"],

Cell["\<\
My goal as a language designer has been to make it as easy as possible to \
express things in the Wolfram Language. The functions in the Wolfram Language \
are much like the words in a natural language, and I\[CloseCurlyQuote]ve \
worked hard to choose them well.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"8bfbe0cf-5819-4a12-a00d-f79e4c91630e"],

Cell[TextData[{
 "Functions like ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["FoldList",
  BaseStyle->"Link"],
 " exist in the Wolfram Language because they express common things one wants \
to do. As in natural language, there are always many ways one can in \
principle express something. But good code involves finding the most direct \
and simple way."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fd2d8fae-94b9-4f3f-8abb-43b442092d12"],

Cell[TextData[{
 "To create a table of the first 10 squares in the Wolfram Language, there\
\[CloseCurlyQuote]s an obvious good piece of code that just uses the function \
",
 ButtonBox["Table",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"ed9c50d4-7ec2-4f09-9ff8-d9a608f910a8"],

Cell["\<\
Simple and good Wolfram Language code for making a table of the first 10 \
squares:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c4446ce3-2204-4ff3-9f61-a44d6c696409"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"n", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"201ade10-58c9-4643-b663-5311b2f71daf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"ea7c2d32-eac3-49fd-8072-245dc2e9c0d4"]
}, Open  ]],

Cell["\<\
Why would anyone write anything else? A common issue is not thinking about \
the \[OpenCurlyDoubleQuote]whole table\[CloseCurlyDoubleQuote], but instead \
thinking about the steps in building it. In the early days of computing, \
computers needed all the help they could get, and there was no choice but to \
give code that described every step to take.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"86934592-fb32-4cc4-a1da-db70a5951eb3"],

Cell["\<\
A much worse piece of code that builds up the table step by step: \
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"176266c8-5c55-46d6-a87d-4096b6c2218f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"list", ",", "i"}], "}"}], ",", " ", 
   RowBox[{
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], ";", " ", 
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"i", "=", "1"}], ",", 
      RowBox[{"i", "\[LessEqual]", "10"}], ",", 
      RowBox[{"i", "++"}], ",", " ", 
      RowBox[{"list", "=", 
       RowBox[{"Append", "[", 
        RowBox[{"list", ",", 
         RowBox[{"i", "^", "2"}]}], "]"}]}]}], "]"}], ";", "list"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"e039a4a8-0169-4f5e-909b-218d47a27fe4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"d0ab9a62-b73b-43b6-bcf9-a41106d41450"]
}, Open  ]],

Cell["\<\
But the point of the Wolfram Language is to let one express things at a \
higher level\[LongDash]and to create code that as directly as possible \
captures the concept of what one wants to do. Once one knows the language, it\
\[CloseCurlyQuote]s vastly more efficient to operate at this level. And it \
leads to code that\[CloseCurlyQuote]s easier for both computers and humans to \
understand.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"31e1f8d3-1358-46fd-8150-3ad4dcbbe4bc"],

Cell[TextData[{
 "In writing good code, it\[CloseCurlyQuote]s important to ask frequently, \
\[OpenCurlyDoubleQuote]What\[CloseCurlyQuote]s the big picture of what this \
code is trying to do?\[CloseCurlyDoubleQuote] Often you\[CloseCurlyQuote]ll \
start off understanding only some part, and writing code just for that. But \
then you\[CloseCurlyQuote]ll end up extending it, and adding more and more \
pieces to your code. But if you think about the big picture you may suddenly \
realize that there\[CloseCurlyQuote]s some more powerful \
function\[LongDash]like a ",
 ButtonBox["Fold",
  BaseStyle->"Link"],
 "\[LongDash]that you can use to make your code nice and simple again."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:5"},ExpressionUUID->"eec46765-6d39-4980-9142-03e1c8134caf"],

Cell[TextData[{
 "Make code to convert ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["hundreds", "CodeVariable"], ",", 
    StyleBox["tens", "CodeVariable"], ",", 
    StyleBox["ones", "CodeVariable"]}], "}"}]], "InlineCode",ExpressionUUID->
  "46b976a2-5115-4fcb-8ff0-320085fc9782"],
 " digits to a single integer:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:284", "i:6"},ExpressionUUID->"632880cb-e7fb-4380-863f-612186d116b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", 
   RowBox[{"{", 
    RowBox[{"h_", ",", "t_", ",", "o_"}], "}"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"100", "h"}], "+", 
   RowBox[{"10", "t"}], "+", "o"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"9e1ce7dd-44c6-457a-bf94-4597d8454497"],

Cell["Run the code:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d860e4d2-8b20-40d9-bb9d-a229ad0bcdf0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fromdigits", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "1"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"33b10495-3c01-4c0d-a885-bc6a12417ff2"],

Cell[BoxData["561"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"59afb614-00ea-4728-b3e1-1af05181728f"]
}, Open  ]],

Cell[TextData[{
 "Write a generalization to a list of any length, using ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"e20b6bc1-3d51-4098-8169-800936d5ac8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", "list_List", "]"}], ":=", 
  RowBox[{"Total", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Length", "[", "list", "]"}], "-", "i"}], ")"}]}], "*", 
      RowBox[{"list", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"4c14645c-1aca-491f-9d62-6a95e9f91de8"],

Cell["The new code works:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9f6b6691-cfea-4017-8c3e-e4e2822b32c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fromdigits", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "1", ",", "7", ",", "8"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"534b1b73-bd16-42d0-9aa8-5fea48aae878"],

Cell[BoxData["56178"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"239e9336-e36c-4f20-a86b-345c52baae8e"]
}, Open  ]],

Cell["\<\
Simplify the code by multiplying the whole list of powers of 10 at the same \
time:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6d419c77-714d-4dd2-97fe-71e95cba8636"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", "list_List", "]"}], ":=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{"10", "^", 
     RowBox[{"Reverse", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "list", "]"}], "]"}], "-", "1"}], "]"}]}], "*",
     "list"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"dad005b3-8a30-40ed-8a8d-ad8cc3a578a0"],

Cell["\<\
Try a different, recursive, approach, after first clearing the earlier \
definitions:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"92fd3c06-9881-45de-be7d-ff87108af643"],

Cell[BoxData[
 RowBox[{"Clear", "[", "fromdigits", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"3658a39d-fd95-4636-ac36-d23645769f41"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", 
   RowBox[{"{", "k_", "}"}], "]"}], ":=", "k"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"901703f7-15a4-40c2-9b7b-e092b5a99aa6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", 
   RowBox[{"{", 
    RowBox[{"digits___", ",", "k_"}], "}"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"10", "*", 
    RowBox[{"fromdigits", "[", 
     RowBox[{"{", "digits", "}"}], "]"}]}], "+", "k"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"59bb5efd-31c8-4597-a638-39ee28e41715"],

Cell["The new approach works too:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ff13057b-74c4-4dc1-98c6-afb6bbef54d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fromdigits", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "1", ",", "7", ",", "8"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"6858961b-8775-418f-8fd4-37a4133999d9"],

Cell[BoxData["56178"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"6e9811b2-9051-43ca-8c9e-2ad59c77e0da"]
}, Open  ]],

Cell[TextData[{
 "But then you realize: it\[CloseCurlyQuote]s actually all just a ",
 ButtonBox["Fold",
  BaseStyle->"Link"],
 "!"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c960c912-6895-4125-a82b-297eb75db83d"],

Cell[BoxData[
 RowBox[{"Clear", "[", "fromdigits", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"afb2b309-0f08-4f39-852a-4b44d121d9b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", "list_", "]"}], ":=", 
  RowBox[{"Fold", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"10", "*", "#1"}], "+", "#2"}], "&"}], ",", "list"}], 
   "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"4116b1a7-2244-4e8b-af96-cca8fab484cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fromdigits", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "1", ",", "7", ",", "8"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"c0f41fdf-ee65-417a-9587-a223b4fb4d44"],

Cell[BoxData["56178"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"43748e41-81da-4735-9a59-393e5756b207"]
}, Open  ]],

Cell["Of course, there\[CloseCurlyQuote]s a built-in function that does it \
too:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"157650c1-8352-452a-9fea-df8c8969a30f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "1", ",", "7", ",", "8"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"47dbe523-1a72-464a-9a8e-3d6e978f2157"],

Cell[BoxData["56178"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"4a5faa57-5f76-49cc-9872-fbe19806b26d"]
}, Open  ]],

Cell["\<\
Why is it good for code to be simple? First, because it\[CloseCurlyQuote]s \
more likely to be correct. It\[CloseCurlyQuote]s much easier for a mistake to \
hide in a complicated piece of code than a simple one. Code that\
\[CloseCurlyQuote]s simple is also usually more general, so it\
\[CloseCurlyQuote]ll tend to cover even cases you didn\[CloseCurlyQuote]t \
think of, and avoid you having to write more code. And finally, simple code \
tends to be much easier to read and understand. (Simpler \
isn\[CloseCurlyQuote]t always the same as shorter, and in fact short \
\[OpenCurlyDoubleQuote]code poetry\[CloseCurlyDoubleQuote] can get hard to \
understand.) \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:10"},ExpressionUUID->"738d9a8e-e76a-4435-a06a-f71ce0cc206a"],

Cell[TextData[{
 "An overly short version of ",
 Cell[BoxData[
 "fromdigits"], "InlineCode",ExpressionUUID->
  "796ebea4-b103-4942-8898-5749e26eed01"],
 ", that\[CloseCurlyQuote]s starting to be difficult to understand: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:285", "i:11"},ExpressionUUID->"d0cda0a8-2de4-49a3-a5c3-0da6aaa7cc14"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", " ", "=", 
   RowBox[{
    RowBox[{"Fold", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "1"}], "}"}], ".", 
        RowBox[{"{", "##", "}"}]}], "&"}], ",", "#"}], "]"}], "&"}]}], " ", 
  ";"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"27c14148-e6f5-4edd-8666-d88760111706"],

Cell["It still works though:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"86e8f870-0c93-49a1-92be-5b804e18ab28"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fromdigits", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "1", ",", "7", ",", "8"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"722240e3-08d5-48c6-a38e-372d75f437fb"],

Cell[BoxData["56178"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"a2e7987e-fc72-4529-87a5-9384b8ce26c1"]
}, Open  ]],

Cell["\<\
If what you\[CloseCurlyQuote]re trying to do is complicated, then your code \
may inevitably need to be complicated. Good code, though, is broken up into \
functions and definitions that are each as simple and self-contained as \
possible. Even in very large Wolfram Language programs, there may be no \
individual definitions longer than a handful of lines.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"590db775-8905-4112-8055-15902310a0ec"],

Cell["Here\[CloseCurlyQuote]s a single definition that combines several \
cases:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"69466297-c4a6-410e-ab83-8a90707ed3f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"!", 
      RowBox[{"IntegerQ", "[", "n", "]"}]}], "||", 
     RowBox[{"n", "<", "1"}]}], ",", "\"\<Error\>\"", ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"n", "\[Equal]", "1"}], "||", 
       RowBox[{"n", "\[Equal]", "2"}]}], ",", "1", ",", 
      RowBox[{
       RowBox[{"fib", "[", 
        RowBox[{"n", "-", "1"}], "]"}], "+", 
       RowBox[{"fib", "[", 
        RowBox[{"n", "-", "2"}], "]"}]}]}], "]"}]}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"bb59e1af-3c43-4b0f-a95c-da0fc4e6a8a0"],

Cell["\<\
It\[CloseCurlyQuote]s much better to break it up into several simpler \
definitions:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"03e8fdb1-d911-46fc-822f-622f22224417"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "2", "]"}], "=", "1"}]}], ";"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"ba3fe56a-e19e-4c6f-996e-4938d9f70e7b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "+", 
   RowBox[{"fib", "[", 
    RowBox[{"n", "-", "2"}], "]"}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"fd04ac32-829f-49c2-b58b-9a538e9be4ab"],

Cell[TextData[{
 "A very important aspect of writing good code is choosing good names for \
your functions. For the built-in functions of the Wolfram Language, I\
\[CloseCurlyQuote]ve made a tremendous effort over the course of decades to \
",
 ButtonBox["pick names well",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://blog.stephenwolfram.com/2010/10/the-poetry-of-function-naming/\
"], None},
  ButtonNote->
   "http://blog.stephenwolfram.com/2010/10/the-poetry-of-function-naming/"],
 "\[LongDash]and to capture in their short names the essence of what the \
functions do, and how to think about them. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"542e7ec5-c20c-4e4b-87f2-45e213c3f845"],

Cell["\<\
When you\[CloseCurlyQuote]re writing code, it\[CloseCurlyQuote]s common to \
first define a new function because you need it in some very specific \
context. But it\[CloseCurlyQuote]s almost always worth trying to give it a \
name that you\[CloseCurlyQuote]ll understand even outside that context. And \
if you can\[CloseCurlyQuote]t find a good name, it\[CloseCurlyQuote]s often a \
sign that it\[CloseCurlyQuote]s not quite the right function to define in the \
first place.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"18413abc-3a97-464f-ab61-bdc7fecac08c"],

Cell["\<\
A sign of a good function name is that when you read it in a piece of code, \
you immediately know what the code does. And indeed, it\[CloseCurlyQuote]s an \
important feature of the Wolfram Language that it\[CloseCurlyQuote]s \
typically easier to read and understand well-written code directly than from \
any kind of textual description of it.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"bdf943bc-bef4-4f68-a1c8-be59de573a22"],

Cell["How would one describe this in plain English?", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:286", "i:16"},ExpressionUUID->"b5c088ab-46f2-44f5-9967-87b67bee7fcc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"White", ",", 
    RowBox[{"Riffle", "[", 
     RowBox[{
      RowBox[{"NestList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Scale", "[", 
          RowBox[{
           RowBox[{"Rotate", "[", 
            RowBox[{"#", ",", "0.1"}], "]"}], ",", "0.9"}], "]"}], "&"}], ",", 
        RowBox[{"Rectangle", "[", "\[ThinSpace]", "]"}], ",", "40"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Yellow"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"d2c6f4f6-6b8b-4873-972c-37c2db6ce1a6"],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[1], RectangleBox[{0, 0}], 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      RectangleBox[{0, 0}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        RectangleBox[{0, 0}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          RectangleBox[{0, 0}], {{{
           0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
           0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
          Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            RectangleBox[{0, 0}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              RectangleBox[{0, 0}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                RectangleBox[{0, 0}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  RectangleBox[{0, 0}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 0.5, 0.5], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}, 
   {RGBColor[1, 1, 0], 
    GeometricTransformationBox[
     GeometricTransformationBox[
      GeometricTransformationBox[
       GeometricTransformationBox[
        GeometricTransformationBox[
         GeometricTransformationBox[
          GeometricTransformationBox[
           GeometricTransformationBox[
            GeometricTransformationBox[
             GeometricTransformationBox[
              GeometricTransformationBox[
               GeometricTransformationBox[
                GeometricTransformationBox[
                 GeometricTransformationBox[
                  GeometricTransformationBox[
                   GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    GeometricTransformationBox[GeometricTransformationBox[
                    RectangleBox[{0, 0}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, 
                    Center}], {{{0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, 
                    Center}], {{{0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                    0.9950041652780258, -0.09983341664682815}, {
                    0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                    0.9, 0.}, {0., 0.9}}, Center}], {{{
                   0.9950041652780258, -0.09983341664682815}, {
                   0.09983341664682815, 0.9950041652780258}}, Center}], {{{
                  0.9, 0.}, {0., 0.9}}, Center}], {{{
                 0.9950041652780258, -0.09983341664682815}, {
                 0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
                0.}, {0., 0.9}}, Center}], {{{
               0.9950041652780258, -0.09983341664682815}, {
               0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 
              0.}, {0., 0.9}}, Center}], {{{
             0.9950041652780258, -0.09983341664682815}, {0.09983341664682815, 
             0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 0.9}}, 
            Center}], {{{0.9950041652780258, -0.09983341664682815}, {
           0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
          0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
         0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {
        0., 0.9}}, Center}], {{{0.9950041652780258, -0.09983341664682815}, {
       0.09983341664682815, 0.9950041652780258}}, Center}], {{{0.9, 0.}, {0., 
      0.9}}, Center}]}},
  ImageSize->{149.24609375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[21]=",ExpressionUUID->"72493f63-81ef-4005-bb6d-0221ebdaaf44"]
}, Open  ]],

Cell["\<\
When you write Wolfram Language code, you\[CloseCurlyQuote]ll sometimes have \
to choose between using a single rare built-in function that happens to do \
exactly what you want\[LongDash]and building up the same functionality from \
several more common functions. In this book, I\[CloseCurlyQuote]ve sometimes \
chosen to avoid rare functions so as to minimize vocabulary. But the best \
code tends to use single functions whenever it can\[LongDash]because the name \
of the function explains the intent of the code in a way that individual \
pieces cannot.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"22b76c5c-337f-4d38-8f45-7d59a40d0eca"],

Cell["\<\
Use a small piece of code to reverse the digits in an integer:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"bc199706-259a-4861-b467-13258b76d742"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"Reverse", "[", 
   RowBox[{"IntegerDigits", "[", "123456", "]"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"4f613b23-96de-42f0-b9d0-93e4e49793cb"],

Cell[BoxData["654321"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"7291e09a-4bea-4c53-82ec-a7c88c437514"]
}, Open  ]],

Cell["\<\
Using a single built-in function explains the intent more clearly:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"156d9842-3881-4313-9c56-5b66d246cc34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerReverse", "[", "123456", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"5dd30fc7-e015-4305-a732-c9a8e6b46831"],

Cell[BoxData["654321"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"f0132bf3-54a9-4ade-8a46-0610f185d831"]
}, Open  ]],

Cell["\<\
Good code needs to be correct and easy to understand. But it also needs to \
run efficiently. And in the Wolfram Language, simpler code is typically \
better here too\[LongDash]because by explaining your intent more clearly, it \
makes it easier for the Wolfram Language to optimize how the computations you \
need are done internally.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"6db33ce3-56a3-41e0-b33e-a3c0bd5d335b"],

Cell["\<\
With every new version, the Wolfram Language does better at automatically \
figuring out how to make your code run fast. But you can always help by \
structuring your algorithms well.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b870ccdf-4912-4419-85b4-05db5333040a"],

Cell[TextData[{
 ButtonBox["Timing",
  BaseStyle->"Link"],
 " gives the timing of a computation (in seconds), together with its result: \
"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"7a14c81f-d66b-490c-90f6-e07b933f00fb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"fib", "[", "20", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"17b63fea-2f94-473b-aa05-e761468847ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.021843`", ",", "6765"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"30570a40-8728-47f9-b466-04efd481df28"]
}, Open  ]],

Cell[TextData[{
 "Plot the time to compute ",
 Cell[BoxData[
  RowBox[{"fib", "[", "n", "]"}]], "InlineCodeText",ExpressionUUID->
  "bd55b154-3482-49af-900f-acb645b43675"],
 " according to the definitions above. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:287", "i:22"},ExpressionUUID->"d80a5f77-8c78-478a-972f-f388805f5a4c"],

Cell[TextData[{
 "With the definitions of ",
 Cell[BoxData[
 "fib"], "InlineCode",ExpressionUUID->
  "c72e97c2-08ac-4769-84d1-8287a884f701"],
 " above, the time grows very rapidly:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e27d66cd-f77d-47f1-b67d-2bac59fee25b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"Timing", "[", 
      RowBox[{"fib", "[", "n", "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"2bacd58c-4207-45f3-a525-c8d68cdab657"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEf7Hvfbl3w/dgDO6iAA4R/AMrncECVF3D4mPG4
Y+uPK1C+iIP96jNTrt1/BOVLOGyPt4s0jHkL5cs4VLeyfmeW+wHlK0DVM9lD
+EoOE/Z5Xl6QwQflqzgYxnZclU+UgPLVHGznTZPfcUoZytdwuHomisvjtz6U
r+WwNYjjiZC7HZSv45Cy4VFIdqIblK/n4CNTqbDJIxjKN3D4u9uu+NryGCjf
0OGOpuya/8UZUL6Rw61j81fkRBTbb2RP/7H1j5HDg9fZsVktdfYANxZbrA==

      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{0., 20.}, {0, 0.007450499999999999}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[25]=",ExpressionUUID->"88b1cc3a-a97a-429d-ad9e-e6d7b9ea9765"]
}, Open  ]],

Cell[TextData[{
 "The algorithm we used happens to do an exponential amount of unnecessary \
work recomputing what it\[CloseCurlyQuote]s already computed before. We can \
avoid this by making the definition for ",
 Cell[BoxData[
  RowBox[{"fib", "[", "n_", "]"}]], "InlineCodeText",ExpressionUUID->
  "10b3c172-cc79-4f93-8a85-cc99238805b2"],
 " always do an assignment for ",
 Cell[BoxData[
  RowBox[{"fib", "[", "n", "]"}]], "InlineCodeText",ExpressionUUID->
  "c829f0b7-21b8-4128-a25d-adc5a74a0e34"],
 ", so it stores the result of each intermediate computation."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"9f7cf492-dc78-4a5a-a094-c6209813efe1"],

Cell[TextData[{
 "Redefine the ",
 Cell[BoxData[
 "fib"], "InlineCode",ExpressionUUID->
  "7a1bcd83-ab31-4f4d-85d3-5920f3386255"],
 " function to remember every value it computes:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"873ab0e3-c686-4f8c-a52b-4afb99f6faf9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "2", "]"}], "=", "1"}]}], ";"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"00a086a2-a195-4aad-9a15-03c001517110"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_Integer", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[27]:=",ExpressionUUID->"f89620eb-4665-4e36-8868-11f35e78e5a5"],

Cell["\<\
Now even up to 1000 each new value takes only microseconds to compute:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ee039ef6-495a-4acb-8509-3499c1f9d2a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"Timing", "[", 
      RowBox[{"fib", "[", "n", "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[28]:=",ExpressionUUID->"a186eb8f-cacb-42b1-831b-2c40ee51578f"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.006944444444444445], 
     AbsoluteThickness[1.6], 
     LineBox[{{1.111111111111111, 8.000000000000001*^-6}, {2., 0.}, {
      2.666666666666667, 8.000000000000001*^-6}}], 
     LineBox[{{3.571428571428571, 8.000000000000001*^-6}, {4., 5.*^-6}, {5., 
      6.*^-6}, {6., 6.*^-6}, {7., 5.*^-6}, {8., 6.*^-6}, {9., 6.*^-6}, {10., 
      6.*^-6}, {11., 6.*^-6}, {12., 8.*^-6}, {13., 7.*^-6}, {14., 8.*^-6}, {
      15., 7.*^-6}, {16., 7.*^-6}, {17., 8.*^-6}, {17., 
      8.000000000000001*^-6}}], LineBox[CompressedData["
1:eJxdkzkKwkAYRn88gQewsbV03x33fUnwBIJgJ8ELpLTRE1h4CXsrxc7Cxk7Q
1sJKS7dBmRcI4eWb7/3DwPgHY3voEZHk631/P88pqObX1fK+OWW/P0Kqf/E6
k8BRc1jdRufp6nHQHFGzz/q95ig4Bo6jnwAnwSn00+AMOKv3u9Ocg0+Z612w
5JHn4SuY7BbgL5rsFuEvIS8hL2M+WCrog6WKfhV5DTlY6sjr6DcwHyxNnE8T
/hb8YGnDD5YO+mDpYj5YeqZPgd2e6VsjF8v0KQv7Qb620Lcx30b/z1vHt3UW
9u8+PgHpyV8g
      "]], 
     LineBox[{{75.5, 8.000000000000001*^-6}, {76., 3.*^-6}, {77., 5.*^-6}, {
      78., 4.*^-6}, {79., 4.*^-6}, {80., 5.*^-6}, {81., 3.*^-6}, {82., 
      7.*^-6}, {82.06666666666666, 8.000000000000001*^-6}}], 
     LineBox[CompressedData["
1:eJxd1j1uU0EUhuEjVsACUoSWjg1EswaUPydOMnHixPm1IjYwJQ30UM0GKCPa
qYjoKGhSII0ELUUqKAmJBbqPJct69Z4z3zn3Xlt+Npm/nD6JiA/377+fSzdX
Szd3q+ntz+v661NfiYfXWnrzwF8eOcFlLa3+eHr16vnnR25wrNMPF7itp7vZ
99fXv78u+jfo31icf7voxzc4NumHyybzwzGiHy6j4bwNH1v0bw3rC77hY3s4
T9omH9/gGJMPlzHz42OH/h3mxzc4dof3K+2Sv8v8+Ngb5qU9+uFGfeShX4ZT
HuZnfMFXuFHfc/q4tzJ6Mf62yN8nf5998Hl/eH7BV3zDdzgmw7zlCfvjM1wm
7E9/w3c4DtgfTnCGC1wPeF7xHY7D4TzLcDokH1/gCrfD4Tyd82LK9Z+yP5yp
L/g6JR/f8XHE/nA6Iv+IfHyFG9zpj2Pu/zH5+AwX6iu+4Ts+ZuTP+P7hM77g
64zrj+9wnHD94XRCPlzgCrcTnj/Oj1P2P2V/fIYL9fWU/anvcJyRD6czfn/w
BV/PyKe+4+OcfDidkw8X6iu+nfP8UR8X3P8L8vH5gny4Ut84r8Nxyf6X3H98
xhd8hdsl++Njzv5wgvOc/Dn5cPvP79/dv27n//6//gHl1B9h
      "]], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQHQoCT/Md+t5uXfD92AM7BjAocAh5IlBYrHUSwhco
cOgFy1+A8BXQ5A3Q+A4FDh8zHnds/XEFwg9A4yegmVeAJt+AJj8Bjb8Ajb8B
zf4DaPwLaOofoMl/QOMzFKKqFyhEdZ8CmrwBgp8GAmaF8PAEAJjDiOE=
      "]], 
     LineBox[CompressedData["
1:eJxdlb9KxTAUh4NP0Eeoq1OfQPIIQRwcgyC42d629xZcMrp4ySPkETLYPZPg
lsHFLeBdhTjp6LXXP+QrlPLx/U7POTTQ48ubs6sjIcTt/v5+LtdFJ7dvs/t4
TKcL606+X7/ezZ/PB27BppP3Sz4e2IId2HfyfFd1/cnTgQN8BCfkM/qLVZmv
VqWv4Rt4Ca/AGtyuynkMvAU7sEd9wDwR+QSfwaLH/j32h2/AEqz6cj4N34IN
2KK/g/fwAT7CJ/gMFkM5bwWuB+wPL+EVWA84/2CDvIV38B4cwBHzJfgMFiO+
/4j9x3KeBnkJVmCN+hbewFt49zvPy8/+mC+AI+oTfEY/sS65Wpf1NXwDlmAF
1uAW7zfrcj4L78Ae+QAf0S/BZ3ixwfnfYH/4BiyRV/B6g/3BBvUW7JD38AH9
InyCz2Ax4fxPOP/gZsL3R70Ca+RbeANv4R36e/gAH+HTv58f9tdu+vs/fwEO
RQeP
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQfXtb7u1tfysc+t5uXfD92AM7BjCodAh5IlBYrHUT
wheodPiY8bhj648rEL4CGt8Aje9Q6dALNu8ChB+AJp+AJl8As+8khN+AJj8B
TX4BmvwGNP4BNP4FNP4DNP4HNPcxVKHKC1Sh+R9N3gCN74DGD6hCdX8CGr8A
jd+Apn8CmvwCNPdsQFN/AI1/AcEvkjleKHO9Ch7fAHt80Jc=
      "]], 
     LineBox[CompressedData["
1:eJxd1D9KBDEYh+FgZZnCA6ytVU4g3xGCiHUQBDsjdrvzJ6WNMkfIEabZPpVg
l8IDBLSwEWKlpToDQt6FZXl4f7MwE3aPL2/Org6UUhe/77/P5fW+lcePffx6
KqeL61bO3/Tt3cnzarWTh6Xn1Rre7OTz+vV+//2y2sCCvYUd9h49wBMccf0M
J+wzXOAKq679Pg1vuvZ5ma69XtAtukP36AF9giP2M3qCM/YFrrDq2+t1j/OH
DfYCW+wdukcP8NS3zz+iz3DCPqMXuGKvBpz/gPuHDfaCbmGHvUcPA84fPaLP
cIIzri/oFVYjzn/E/aMbdIEt9g722Ad4guOI3z96Qs9wwb7CKrT7Q1iHdn8U
/v9PfwC7Dhgs
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQ7TlJxXOSTIND39utC74fe2DHAAIKDQ4fMx53bP1x
BcLXaHDoBctfgPAN0PgWDQ4hTwQKi7VOQvgOaHwPNH4AGj8CzbwENPkMNH4B
mvoKNPkGNH4HGn8CGn8GmnkL0Pgr0Pgb0PTvQOMfQOOfQONfQDPvBpr8AzT+
C7T4+IDG/4HG/42ITwC/Qq6P
      "]], LineBox[CompressedData["
1:eJxd1S9IxGAYgPEPQVhcXJxtGGRxST5Mi0MMFw9BGBYnlsX9CwNRFi8O0+LK
wTAtyWwLhsWBhhVhpltUb6DsOTiOH8/L937H4O7o8ub86kAIcf3z/v3cvw5D
+fi5zXcv/eneSii/3Pd0O73NVmEN1mEDNkP5sD+/nW2F8uJDvb07fp0tYRvz
DvoKfQ272O+h+3CA+RQ9gze4T45eoJfoFVxjfwO3mO/gHvMD+ghPsIiW91Wi
ZVdhDfM6ugGb0fJ+FixhG3bgFc5f4z4uuofuowc4P0XP0DdwjvkCLjFfoddw
A7e4f4fewwP2jfCEeREvuxLj+aNrMZ4/ugGbOM+CJeZtdAdeYf8a3UX30H04
gFM4w/026Dl6gV7CFVzDDdzi+3ToPfYP6CP6BItkOa8k+P1Plvs1zOvoBrqJ
bqHL/33Pw9P9yVny93/0DZaGrmQ=
      "]], 
     LineBox[{{650.6, 8.000000000000001*^-6}, {651., 6.*^-6}, {652., 
      4.*^-6}, {653., 3.*^-6}, {653.5, 8.000000000000001*^-6}}], 
     LineBox[{{654.8333333333334, 8.000000000000001*^-6}, {655., 7.*^-6}, {
      656., 8.*^-6}, {657., 7.*^-6}, {657.1666666666666, 
      8.000000000000001*^-6}}], LineBox[CompressedData["
1:eJxd1CGIwlAcx/GHybhoVJOYjCZ50SKIGBZFENZOuWI0bGNFsQiLi4srg8Ul
mW3hwuJAwzg48NItnm6gvO+DMX58fv/3X1pn+TFbNYQQk8fzfFfnZMrDT+j9
nfNRlV1T/hpXJyy/6uwh+8gBcmTKfXVfWucYniCn6GemnN+0zWf/Uucc/QL9
O/olsrDUftNSXbPU+1vot+E95AH6Q7hEHmP/FPM6fAE34Gv4Fr7Dfgf9I9yF
e3AfHsAj7I/RT+ApPIPnyAX23TFfIgtb7Tdt1TV4C7ltq/t7mB8gD9GX8DF8
CteRF/geA76Gb+E7uIP9R/RduAf34QE8gsfYn6CfwjN4jly8c/d5vu3X/+sf
WqDpcw==
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQB2IQreo5ScXzW5tD39utC74fe2DHAAI/2hw+Zjzu2Prj
CoTP0I7K52h36AWrvwDhC6DxJdodQp4IFBZrnYTwFdDkNdD4BmjmW6DJO6CZ
54GmPgCNH4HGT0DjZ6CZX4DGr0BT34Bmfwea+glo8jPQ5Begya9Ak9+Axt+B
Zv8BNPkTaPIX0ORvoMk/QOO/QHPPBzT9P9DkGTpQ5TnQ+AIdqOol0ORlOuDp
CwDCPPrs
      "]], LineBox[CompressedData["
1:eJxdky0IwkAYQA+TcdGoWIZpcRa5uChiWByCsKZiMRpvwbFoXFxcEYxLMtuC
YcEwmMEiaNLoz0DYOxjH473t+8o6k9lo2hBC9D/P7/ZL0+8q6d924fNQDMT3
6EqOL9pi2TtWbCi5+fmsYhNewlvgIdhW8uGWavc6VeyAXfRz+BV4jV6BA+y7
hQ/hI/gYvEefYJ8UnOH9HFygv4Lv4BdYePV9ml79+xp8C74N1tEbXn2eiV7C
W+AhehvegXcxfw6/gl/DK3CAfgsfYp8IPgbv0SfwKXwGn4PP3v//ewO/i3JQ

      "]], LineBox[CompressedData["
1:eJxd1CGM2gAYhuFmComsZK6ZquzMUokkywSSLFlSty4zSGThgEMiKzFLMJcg
UQtzFRPIJkzULOnUKrcbYulDciFP3u/nBKEv3398++FFEARf/v49v7/e3pLt
bZlufz6Vv7/Wb4LnV7NM3/0Yfvr86tvd7TLd/OvV3R09WPU9WPX3QxyyH+GI
fUxPcIrH3E/wFM+4z+g5fU5f4GKV/spuxVP3/e4d3rMv8QEfuT/Rz/QLrthf
6TVucMt9h4OHvgcP/fshDtmP6BE9xgn7lD7GE/ZT+gxn7HP6HC/YF/Qd3uOS
+wP9iE/4zP0FV+yv9Jre4BZ33Afrvgdrfv84xCPuI3qME5ziMZ83oU/xjH1G
z/EcL7gv6Du8xyU+4CM+8f/O+IIr7q+4xg337br//OvYBxue/xu+fxyyH9Ej
ekxP6Cl9TJ/Qp/QZztjneM5+QS/oO7xnX9IP+Mj+RD/TL/SKfqXXuGHf0jsc
bHn+4+G2vw/pI3qEY/YJPaWP6RM8xTOc8Xk5fY4XuOB+R9/jkv0BH9mf6Gd8
YV/hK/ua3uAWd9wHj/z+8RCHj3z/9AjHOOE+/d//AMg4LLI=
      
      "]]}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{254.01953125, Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 1000.}, {0, 8.000000000000001*^-6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[28]=",ExpressionUUID->"1b2e6f13-ab47-4e8a-a5ab-090d39fd01ad"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fa84b7b1-0aa3-4045-8b2a-93010371c7a3"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FromDigits",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "assemble an integer from its digits", "VocabularyText",ExpressionUUID->
     "f6452126-b891-4a69-94f4-5c6bc857cf2a"]},
   {
    RowBox[{
     ButtonBox["IntegerReverse",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["n", "CodeVariableLrg"], "]"}], " ", Cell[
    "reverse the digits in an integer", "VocabularyText",ExpressionUUID->
     "9487636d-f92a-4036-b2cd-2998d789ac6e"]},
   {
    RowBox[{
     ButtonBox["Timing",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["expr", "CodeVariableLrg"], "]"}], " ", Cell[
    "do a computation, timing how long it takes", "VocabularyText",
     ExpressionUUID->"115ef5f6-b7f2-4342-92c5-670c8281ac5d"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4bc56e05-1879-4bac-8cd2-ca273e757523"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"f109d965-1d71-4aa5-a1b5-d1dbc451c83e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"5 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-46-writing-good-code-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ee8d3d50-46bf-4cc4-bce5-459ff0044b3b"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "i"}], "}"}], ",", 
    RowBox[{
     RowBox[{"a", 
      ButtonBox["=",
       BaseStyle->"Link",
       ButtonData->"Set"], "0"}], ";", " ", 
     RowBox[{
      ButtonBox["For",
       BaseStyle->"CodeLink"], "[", 
      RowBox[{
       RowBox[{"i", 
        ButtonBox["=",
         BaseStyle->"Link",
         ButtonData->"Set"], "1"}], ",", 
       RowBox[{"i", 
        ButtonBox["\[LessEqual]",
         BaseStyle->"Link",
         ButtonData->"LessEqual"], "1000"}], ",", 
       RowBox[{"i", 
        ButtonBox["++",
         BaseStyle->"Link",
         ButtonData->"Increment"]}], ",", 
       RowBox[{"a", 
        ButtonBox["=",
         BaseStyle->"Link",
         ButtonData->"Set"], "i", 
        ButtonBox["*",
         BaseStyle->"Link",
         ButtonData->"Times"], 
        RowBox[{"(", 
         RowBox[{"i", 
          ButtonBox["+",
           BaseStyle->"Link",
           ButtonData->"Plus"], "1"}], ")"}], 
        ButtonBox["+",
         BaseStyle->"Link",
         ButtonData->"Plus"], "a"}]}], "]"}], ";", "a"}]}], "]"}]], 
  "InlineCode",ExpressionUUID->"6017e0b1-6ec5-4ee1-9f98-724d7fbf44ee"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "46.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d116685e-e859-46d1-b46d-c065f33bef70"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "334334000"], "ExerciseOutput",ExpressionUUID->
       "f7df7fd1-1d6f-423b-b644-8f0481701b18"],
      Apply[TextCell, 
       Cell[
        BoxData["334334000"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c6dc9bcc-a93b-459b-9233-92c126bd5e02"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "i"}], "}"}], ",", 
    RowBox[{
     RowBox[{"a", 
      ButtonBox["=",
       BaseStyle->"Link",
       ButtonData->"Set"], "x"}], ";", " ", 
     RowBox[{
      ButtonBox["For",
       BaseStyle->"CodeLink"], "[", 
      RowBox[{
       RowBox[{"i", 
        ButtonBox["=",
         BaseStyle->"Link",
         ButtonData->"Set"], "1"}], ",", 
       RowBox[{"i", 
        ButtonBox["\[LessEqual]",
         BaseStyle->"Link",
         ButtonData->"LessEqual"], "10"}], ",", 
       RowBox[{"i", 
        ButtonBox["++",
         BaseStyle->"Link",
         ButtonData->"Increment"]}], ",", " ", 
       RowBox[{"a", 
        ButtonBox["=",
         BaseStyle->"Link",
         ButtonData->"Set"], "1", 
        ButtonBox["/",
         BaseStyle->"Link",
         ButtonData->"Divide"], 
        RowBox[{"(", 
         RowBox[{"1", 
          ButtonBox["+",
           BaseStyle->"Link",
           ButtonData->"Plus"], "a"}], ")"}]}]}], "]"}], ";", "a"}]}], "]"}]],
   "InlineCode",ExpressionUUID->"0efbf491-1928-4b51-b258-62d464a39b9f"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "46.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"86415962-a31f-468d-a7c7-4fa66dbd3ffc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", 
           FractionBox["1", 
            RowBox[{"1", "+", 
             FractionBox["1", 
              RowBox[{"1", "+", 
               FractionBox["1", 
                RowBox[{"1", "+", 
                 FractionBox["1", 
                  RowBox[{"1", "+", 
                   FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", "x"}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]], 
       "ExerciseOutput",ExpressionUUID->
       "d51d3527-b500-45c4-8039-d09353d0624a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         FractionBox["1", 
          RowBox[{"1", "+", 
            FractionBox["1", 
             RowBox[{"1", "+", 
               FractionBox["1", 
                RowBox[{"1", "+", 
                  FractionBox["1", 
                   RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    RowBox[{"1", "+", "x"}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"be75ba48-0020-4fb6-ac9c-cb526a381a99"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "j", ",", "a"}], "}"}], ",", 
    RowBox[{
     RowBox[{"a", 
      ButtonBox["=",
       BaseStyle->"Link",
       ButtonData->"Set"], 
      RowBox[{"{", "}"}]}], ";", " ", 
     RowBox[{
      ButtonBox["For",
       BaseStyle->"CodeLink"], "[", 
      RowBox[{
       RowBox[{"i", 
        ButtonBox["=",
         BaseStyle->"Link",
         ButtonData->"Set"], "1"}], ",", 
       RowBox[{"i", 
        ButtonBox["\[LessEqual]",
         BaseStyle->"Link",
         ButtonData->"LessEqual"], "10"}], ",", 
       RowBox[{"i", 
        ButtonBox["++",
         BaseStyle->"Link",
         ButtonData->"Increment"]}], ",", 
       RowBox[{
        ButtonBox["For",
         BaseStyle->"CodeLink"], "[", 
        RowBox[{
         RowBox[{"j", 
          ButtonBox["=",
           BaseStyle->"Link",
           ButtonData->"Set"], "1"}], ",", 
         RowBox[{"j", 
          ButtonBox["\[LessEqual]",
           BaseStyle->"Link",
           ButtonData->"LessEqual"], "10"}], ",", 
         RowBox[{"j", 
          ButtonBox["++",
           BaseStyle->"Link",
           ButtonData->"Increment"]}], ",", 
         RowBox[{"a", 
          ButtonBox["=",
           BaseStyle->"Link",
           ButtonData->"Set"], 
          RowBox[{
           ButtonBox["Join",
            BaseStyle->"CodeLink"], "[", 
           RowBox[{"a", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "j"}], "}"}]}], "]"}]}]}], "]"}]}], "]"}], ";",
      "a"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "f50d81d1-438d-4a6c-b503-4370802fa44d"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "46.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e0232fbd-aabb-481c-9944-7217fb5bf7f4"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", 
         "4", ",", "1", ",", "5", ",", "1", ",", "6", ",", "1", ",", "7", ",",
          "1", ",", "8", ",", "1", ",", "9", ",", "1", ",", "10", ",", "2", 
         ",", "1", ",", "2", ",", "2", ",", "2", ",", "3", ",", "2", ",", "4",
          ",", "2", ",", "5", ",", "2", ",", "6", ",", "2", ",", "7", ",", 
         "2", ",", "8", ",", "2", ",", "9", ",", "2", ",", "10", ",", "3", 
         ",", "1", ",", "3", ",", "2", ",", "3", ",", "3", ",", "3", ",", "4",
          ",", "3", ",", "5", ",", "3", ",", "6", ",", "3", ",", "7", ",", 
         "3", ",", "8", ",", "3", ",", "9", ",", "3", ",", "10", ",", "4", 
         ",", "1", ",", "4", ",", "2", ",", "4", ",", "3", ",", "4", ",", "4",
          ",", "4", ",", "5", ",", "4", ",", "6", ",", "4", ",", "7", ",", 
         "4", ",", "8", ",", "4", ",", "9", ",", "4", ",", "10", ",", "5", 
         ",", "1", ",", "5", ",", "2", ",", "5", ",", "3", ",", "5", ",", "4",
          ",", "5", ",", "5", ",", "5", ",", "6", ",", "5", ",", "7", ",", 
         "5", ",", "8", ",", "5", ",", "9", ",", "5", ",", "10", ",", "6", 
         ",", "1", ",", "6", ",", "2", ",", "6", ",", "3", ",", "6", ",", "4",
          ",", "6", ",", "5", ",", "6", ",", "6", ",", "6", ",", "7", ",", 
         "6", ",", "8", ",", "6", ",", "9", ",", "6", ",", "10", ",", "7", 
         ",", "1", ",", "7", ",", "2", ",", "7", ",", "3", ",", "7", ",", "4",
          ",", "7", ",", "5", ",", "7", ",", "6", ",", "7", ",", "7", ",", 
         "7", ",", "8", ",", "7", ",", "9", ",", "7", ",", "10", ",", "8", 
         ",", "1", ",", "8", ",", "2", ",", "8", ",", "3", ",", "8", ",", "4",
          ",", "8", ",", "5", ",", "8", ",", "6", ",", "8", ",", "7", ",", 
         "8", ",", "8", ",", "8", ",", "9", ",", "8", ",", "10", ",", "9", 
         ",", "1", ",", "9", ",", "2", ",", "9", ",", "3", ",", "9", ",", "4",
          ",", "9", ",", "5", ",", "9", ",", "6", ",", "9", ",", "7", ",", 
         "9", ",", "8", ",", "9", ",", "9", ",", "9", ",", "10", ",", "10", 
         ",", "1", ",", "10", ",", "2", ",", "10", ",", "3", ",", "10", ",", 
         "4", ",", "10", ",", "5", ",", "10", ",", "6", ",", "10", ",", "7", 
         ",", "10", ",", "8", ",", "10", ",", "9", ",", "10", ",", "10"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "6c07a3fc-189e-4095-b4d2-531d35f2cccc"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "1", ",", "3", ",",
              "1", ",", "4", ",", "1", ",", "5", ",", "1", ",", "6", ",", "1",
              ",", "7", ",", "1", ",", "8", ",", "1", ",", "9", ",", "1", ",",
              "10", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", 
             "3", ",", "2", ",", "4", ",", "2", ",", "5", ",", "2", ",", "6", 
             ",", "2", ",", "7", ",", "2", ",", "8", ",", "2", ",", "9", ",", 
             "2", ",", "10", ",", "3", ",", "1", ",", "3", ",", "2", ",", "3",
              ",", "3", ",", "3", ",", "4", ",", "3", ",", "5", ",", "3", ",",
              "6", ",", "3", ",", "7", ",", "3", ",", "8", ",", "3", ",", "9",
              ",", "3", ",", "10", ",", "4", ",", "1", ",", "4", ",", "2", 
             ",", "4", ",", "3", ",", "4", ",", "4", ",", "4", ",", "5", ",", 
             "4", ",", "6", ",", "4", ",", "7", ",", "4", ",", "8", ",", "4", 
             ",", "9", ",", "4", ",", "10", ",", "5", ",", "1", ",", "5", ",",
              "2", ",", "5", ",", "3", ",", "5", ",", "4", ",", "5", ",", "5",
              ",", "5", ",", "6", ",", "5", ",", "7", ",", "5", ",", "8", ",",
              "5", ",", "9", ",", "5", ",", "10", ",", "6", ",", "1", ",", 
             "6", ",", "2", ",", "6", ",", "3", ",", "6", ",", "4", ",", "6", 
             ",", "5", ",", "6", ",", "6", ",", "6", ",", "7", ",", "6", ",", 
             "8", ",", "6", ",", "9", ",", "6", ",", "10", ",", "7", ",", "1",
              ",", "7", ",", "2", ",", "7", ",", "3", ",", "7", ",", "4", ",",
              "7", ",", "5", ",", "7", ",", "6", ",", "7", ",", "7", ",", "7",
              ",", "8", ",", "7", ",", "9", ",", "7", ",", "10", ",", "8", 
             ",", "1", ",", "8", ",", "2", ",", "8", ",", "3", ",", "8", ",", 
             "4", ",", "8", ",", "5", ",", "8", ",", "6", ",", "8", ",", "7", 
             ",", "8", ",", "8", ",", "8", ",", "9", ",", "8", ",", "10", ",",
              "9", ",", "1", ",", "9", ",", "2", ",", "9", ",", "3", ",", "9",
              ",", "4", ",", "9", ",", "5", ",", "9", ",", "6", ",", "9", ",",
              "7", ",", "9", ",", "8", ",", "9", ",", "9", ",", "9", ",", 
             "10", ",", "10", ",", "1", ",", "10", ",", "2", ",", "10", ",", 
             "3", ",", "10", ",", "4", ",", "10", ",", "5", ",", "10", ",", 
             "6", ",", "10", ",", "7", ",", "10", ",", "8", ",", "10", ",", 
             "9", ",", "10", ",", "10"}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4985e129-a967-4f88-a1da-628f05a21a9a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the timing for computing ",
 Cell[BoxData[
  RowBox[{"n", "^", "n"}]], "InlineCode",ExpressionUUID->
  "257cd21b-b390-4ea6-b0c0-037858dd6fe6"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"108de53f-46f4-4c3b-a9cd-6ad4e2c90812"],
 " up to 10000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "46.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"51eae5b9-b8e9-4739-9b3d-d9ce0c4993c7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.002777777777777778], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxcnX1ck2X7xpeZkZGRkZGRkZGRkZGRkZHdGRkZ6jIyMrJlZGRky0jJSJeR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            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 10000.}, {0, 0.000326}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "cb22a713-4a2d-4091-af96-4b1529bd6e14"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{
               RGBColor[0.368417, 0.506779, 0.709798], 
               PointSize[0.002777777777777778], 
               AbsoluteThickness[1.6], 
               LineBox[CompressedData["
1:eJxcnX1ck2X7xpeZkZGRkZGRkZGRkZGRkZHdGRkZ6jIyMrJlZGRky0jJSJeR
kZIuREREnIgw3scYe8+WkZGRLSMjI1tGRka2jIyM7PfizR/n9/nn+Zwd13G+
X+d13fc2vGrh83OfGqbRaMKu1Wj+7//P/C94Z8WEU7lFF/00Tf0PSmpP2Asv
TvxYlUOUt39tNf2116fKYZDDIUeoskWVI4FHAR8PPBryBKyPAT4ReCzwSZDj
1Pi+VuWbFMfj0x65Kf1bVZ6srver8s3IRzzkWyBPgb1bgSdAvg3yVPBvB56o
/J75Q37rQL8q3wF/p2H9nZAVqd8AWXOX1Ge4C/zpUjZA1twNPmRNEuwngX8P
9EPWzAA+A/7fC/v3gp8M+8nA7wN+H/CZsA9Zcz/w++FfCnDImlnAZyF/s4FD
1swBPgf2tVJWIBu0ku+DrHlAygpkA2TfA/B/rpSVubA/F3zgmgfBh2yA7IOs
SYX/kA2QfangPwT+Q7AP2QdZMw/8eeBD9mG95mHwHwYfuA+yJg18yIY02Ies
eQT5fwR84D7ImvmwPx/1nw8+1msehf1HYR+4D7gmHfbTYT8dfKzXPAb7j8E+
cB9wzQLwF8A+cN8C8B8H/3HYB+4DrtFJOQqyopN8HXADcBNwH/AAcM0TEo96
QsavANdBNkA2QfZBDkDWLET8C5FP4DrIBsgm8H3AA8A1TyL+J5F/4DrgBuAm
4L4n1ftBp2of6zUZiB+yAlmXgfwDN0H2YX0AuOYpxP8U7APXATdANmG9D3jg
KZkPzSLYXwT7wHXADcBNkH1YHwCueRr5fxr9B1kH2fC0jMcEfT7gAeCaTNjP
hP1MydcBN4BvAu4DPwBc8wzy/wz2P3DdM8g/cBNk3zOwD1yzWNqLWoz4Iesg
GyCboM8HPABZ8yzy/yzsA9cBN0A2QfZBDkCfJgv5z0L+gesgGyCbIPuy0P/A
Nc8h/ucQP2QdZANkE/T5gAcga5Yg/iXY/5B1WG8Abloi+82H9QHImufl+qjn
YR+47nnYh2yC7IMcgD6NXtY7TI98QI6DrOilPq0e+cJ6PXADcCNkE9ZbgPsg
+yEH4F8Q+jQvyPVhL6AfgcdBVrBeC1wHWQ/ZANkI2fSC9N8Cez6s90MOgB8E
X7MU8S9F/MDjlkp9CmQt1usg6yEbIBshm+CPBfZ8WO+HHMD6IHDNi4gfchTk
OMgKZC1k3YvSfz1ww4vSPyNkE2QL9Pmgzw88AH4Q6zXZcn0Y5CjIcdmofzbi
h6zDej1wA2QjZBNkC/T5gPshB7A+CFnzEur/EuJ/Sa6PA66Ar4WsA18P2YD1
Rsgm2LMA90H2Y30A9oLANcsQP+SoZYgfsoL1WuA64HrIBsjGZThPoc+C9T7g
fsgByEHImuVKxMiuUTP6/lDjX474lyvifXjcEB5Q41+unFNx7VNz7/5FjR+4
brlyZ11H0cHvjqjxL0f9IRshm+CPBbgPuB94AHIQsiYH+z8H95EczD/gCnAt
ZB1kPfgG4EbIJsgW8H2Q/VgfAB6ErHlZymEvy88DooDHQVZeRvyQdZD14BuA
G4GbIFsg+yD7IQcQTxCyZgX2P+SoFYgfuAJcC1wHXA/cANwI3ATcAtwH3A88
sALxQ9a8gvq/gvoDj4OsQNZC1r2C+gM3QDZCNg3J6uc7FuA+yH7YCwAPAtfk
ov650l5ULuLHeiUX91/gOsh66DNANmK9CbgFsg+yH/wA5CDWa15F/V9F/wOP
A64A10LWYb0euAG4EbIJ6y2QfZD94AdeRf9jvWYl5v9KzP+VmP/AFcha6NMB
10M2QDZCNsG+BbgPsh9yAHIQ+jSrUH/IUasQP3AFuBa4DrIe6w3Ajatw/wFu
WSXr6YM+P9YHgAeBawzSXogB88Ag7UUYkB/IMZDjoC8BuAI5GbIW9tOgT4f1
mZD1WJ8D3AA8H7IR9kuAm6DPbJD3SQvWO7HeB7wduB9yF+QA5F74GwQ+AHua
16QcAjnsNcmPgBz1mrQXAzwO+hKwXgGeDL4W69OA6yBnQp8eeA5wA/B8yEbI
JZBN0GcGboHsRDw+4O3A/ZC7IAcg90JfEPgA/NWsRv1XYx6uxv4HHgV+DPA4
4AnAFehPBq6FnAZZBzkT9vTQnwPZsFru13zoM0JfCXATZDNkC2Qn9PmAt8M/
P+QuyAHwe1fL7y8FsX4AsuZ1yQ+BHPY66g856nXUH/w44AnAFcjJkLWwlwZc
BzwTsh5yDmQD/MuHfiPkEsgmyGboswB3wr4P69ux3g+5C/wA5F7IQcgD0KfJ
w/7PQ/0hR0COghwDOQ5yAuwpedj/wLXA06BPh/WZwPXg5wA3QM6HPiP4JVhv
gmzGegtkJ9b7ILfDvh/8LsgByL2Qg5AH8vD9xjew/9+Q68OAR0COghwDftwQ
rj5PJrwh7SvgJ4OvhZwGvg78TOB68HOw3gA8H7IRcgn0m4CbIVuw3gnZh/Xt
kP2Qu8APAO+FHES8A+Br1mD/r5F42BrMf+BRa1B/rI/D+gTICtYnQ58W69Ow
Xgc8E7Iecg74Bsj5kI3gl0A2Yb0ZsgXrnZB9WN8O3A+5C3IA/F7IQcgD4Gve
xP5/E/v/Tbk+AuujsD4GchzkBMjKm/L+lQxcCzkNsg5yJmQ9/M0BbgCeD9mI
9SXATcDNkC2QnZB90NcO2Y/8d0EOYH0v8CDsDQDX5GP/5+P8z8f+hxwFfgzw
OOhLgKxATgZfCzwNuA5yJmQ95BzIBujPh2zMx/4HboI+M2QL1juhzwe8HXw/
5C6sDwDvBR4EPgD7mrfw/uctuT4McsRbmP/AY97C/Q/rE7BegZyM9VrIaZB1
sJcJfXrIOZAN4OcDN8JeCXATZDP0WYA7oc+H9e1Y7wfeBTwAuRfrg28pH390
fNg155xU64/1mrXY/2tRf8gRkKMgx6xF/dei/pAVrE+GPi3kNKzXQV8mZD34
OcANwPOh3zgk96j1x3oTZDNky1r5+a8TuA9yO/zzA+8CHgDeCzkI+wPANetw
/q9D/dfJz7MjsD4K62PWSf/igCdAnwI8GXwt8DTgOuCZkPWQc8A3IJ584Ebw
S4CbIJux3gLcCdkH++3A/ZC7oD+wTu7vXuBB8AeQf00B9n8B6l8gn98iCjD/
C6T/McDjoC8BuFKgvPLGOX+dPW5ArT9wLfhpwHXAM4HrIedANsD//AKZHyP0
l4BvgmwG3wLZCdkHfjtwP+QuyAHweyEHsX4A8WjelnII5LC3cf8HHgU8BnLc
29J+AnAFcjJkLfhpwHWQM+Gf/m3ZXzlYb8D6fMhG2C+BPhNwM2QL9Dlh3/c2
9j9wP/R1QQ5gfS/sBYEPQNasx/xfj+f/9Tj/1ys33B35y5Epp9T6Y30M1scB
T1iP+Q/7yVivhZwG/TrgmdCvx/ocrDesV7/f9Zdaf/CN4JeAb4JshmyBPidw
H/S3A/eD3wU5ALkXchD6BoBrNqD+G1B/yBEbJD8KeAzwOOAJwBXgyZC1WJ8G
XAc8E7geeA5kA9bnAzcCLwFu2oD7H3ALZOcGeR/zgd+O9f4Nct50gR/A+l7I
QcgDiEdjlM9/w40SD4EcapT6wozS/3DgEeBHAo8CHg19McBjgccBj4ecAHuJ
kBWj7P8k4MmQUyBrYS8V/qUBT4esg5wB/ZnAs4DrgWcDz4Gci/UG+JuH9flY
XwDcCH4R1pdgfRlwE/iVwM3g10O2gG8D7oTshX4f+G1Y3w65wyj3nx/6OrG+
C3i3Ue7nAPAe6O8F3gf9QejrN8rn1QGsH4R+zTsy/uHvSDwEcug7OB/ekfrD
IUeAHwk8CnI01sdAjoUcB3488ATgicAVxJ8EPBn8FOBa4KmQ07A+HbgOcgbW
ZwLPAq5HPbKB50DOhWxA/Hmwl4/1BZCNkIvewfsS4GWQTbBXCb4ZeD1wC3Ab
cCfseSH7kL828NuxvgOyH3In+F3Au4EH4H8P8F7w+4AHwe/H+gHgg+BrCuX5
N7wQ+78Q538hzn/g4eBHYH1kofw9RRT40eDHgB8LOQ5yPPgJkBMhK7CfBH3J
WJ8CWYv1qcDTIKcXyvzrwM/A+kzgWcD18D8beA7kXNg3FGL/Y30+7BcANwIv
GtL3t7r/gZdBNsH/Sug3A68HbgFuA+6EPS9kH+JvA78d6zuQPz/wTshdkLuh
PwD/e4D3Au8DHoT+fvg3gPWDWK/ZiPN/o8RDNmL/Aw8DHr4R+x9yJPhRkKOx
Pgb6Y7E+DnI85ATwE6FfAZ4EORn6UsDXYn0q8DTw0yHrwM8Angl9WZD1WJ8N
PAdyLtYbUP+8jbJ/8rG+APqMwIsgl2B9GWQT7FcCN0Ouh34LZBv8dwL3Avch
/21Y3471HZD9WN8JvAty90bc/xFfD+Re8Ps2yvMziPX9WD8AeRB8TZF8/z+8
SK4PKcL9vwj7H3I45AjwI6E/qkjWPxrrYyDHgh8He/FYn4D1iZAV2E8Cngw5
BbIW9lKBp0FOh6wbktXPVzKAZ0LOgj095GzIOchPLvQZiuT9Lw/8fMgF0GeE
XAT9JeCXATcV4fyHPjPW10O2gG+DPSdkL2Qf+G2w3w65A3w/5E741wW5u0ju
vwDs92B9L+Q+2AvCv37gA+APQtZswv1/E+7/kEMhh0EO3yT1R2zC/R94FPBo
yDHQHwt+HNbHA0+AnLhJzl8F/CTYSwY/BbIW/FTgadCXvkmdNz+r+x/8DKzP
3CT7JQv69ZCzsT4H+nKx3rBJ9l8e+PlYXwDZCP1FwEuAl0G/CXgl+Gasrwdu
Ad+G9U7gXuA+5L8N+ts3qb/v/0fd/9Dnx/pO6O8C3g08AH09WN+L9X2Qg1jf
D3kA+gfB1xRj/xdLfgjkUMhhxdj/xVJ/BNZHQo4CPxp4DPBY4HGQ4yEnQE6E
f0oxzn+sT4acAlkLORVyGuR0yLpi7H/Emwk5C/7rwc+G/hzIuZANxdj/xfL5
PR/rC2DfCP+KsL4E68uAm8CvLJb7zQx+fbGcnxbgtmL59zicwL2QfchfG/xr
x/oOyH7InZC74G838ADi78H6Xsh94Ach92P9AORByJrNeP7fLPGQzVJ/6GZZ
n7DNMl/hWB8BPHIzvj+wGec/+DGQY6EvbrPMXzzWJ2B9IuJTNuP5H3gy9KVA
nxZyKtanQU6Hfh38z8D6TMhZkPWwnw08B3gucAPqnwf/8rG+ALIR+ouAl0Au
g2xC/Suhz4z19ZvlfLIAt8F/J2QvZB/q3wa8Hf50APfDfudm5bDm5u/enzOo
7n+s74YcgP4e8Hs3y3nWBzkI+/3AB2BvcCjeX9X9X4Ln/xLJDynB/gceVoL9
XyLtRYAfCTyqBOc/8BjIsbAfB/3xJWp8/6r7H/xE8BXYTyqR8y0Z/BTIWsSf
CjwNeDpwHfAMxJOJ9VnA9ZCzsT4HeC5wQwnOf+D58K8AuBF4EfAS2C+DbAK/
Enwz1tejfhbwbeA7gXtL5P7yleD8B78dcgdkP/zrBN4FuRtyAP71AO+F3Ad7
Qcj9yM8A5EHImi04/7dg/2/B/t8i/QmDHA5+BPBI6IvaIuOPBh6zRe7HWOBx
0B8POQHrE4ErW/D8DzwZcgr0aSGnQk4DP32LnL86xJ+B9ZnQl4X86sHPBj8H
ci70GRB/HtbnY30B7BuBF4FfArwMfBPwSuBm6KuHbIFsg+yE7IV+H+JvA94O
/zqA+6G/E3jXFjlvuoEHoL8HeC/kPvRPEPb7sX4A8iD4mlLs/1Ls/1KpPxR4
WKn0Pxx4BORIyFGl2P+wF4P1sZDjsD4eeALwROBKKc5/4Mmlcv6kANci/lTg
aZDT4Y8O8WdgfSbWZ5XK+ulhPxt4DvTlQjaUYv8Dz4dcAP1G+FeE9SXwrwy4
CfFXAjdDrodsgX0bZCfWeyH7YL8NeDv0dQD3I75O5KcL67shB8DvAd4Lua9U
zpMg8P5S5ZkrHpoV9tJv6v7H+sFSZVHK+2Of/uJ3df9vlfUfvlX6HwI5dKvU
H7ZV2g8HHgF+JPCorTK/0cBjwI8FHgf78VifgPWJQ/EG1f2/VeY/aaty1TTL
D+8pmjv/X06G/hTo0wJPhf404Ong62A/A/5nIj9Z4OuhPxt4DvBc4IatuP9v
VefhCXX/w58CyMat8nmrCPGXYH0ZcBP8qwRuBr8e/luA24A7IXuh34f8t2F9
O/R3gO8H3gm8C/q6gQdQ3x7gvdDfBzwIvB/2BiAPgq8pw/lfJteHlMn6hAIP
K5P2w8uk/gisj4QcVYb9DzwGciz0x8G/eOAJ8C8RuAL7SbCXDH4K+FrgqeCn
QU4HXwf/M7A+E/qzwNeDn10m53sO9OUCN5TJ8y8P6/NhrwB8I/wrwvoS4GXA
TfC/EvrNWF8P/yzQbwPuBN8L/T7Uvw3r26G/A3w/8E7wuyB3gx9A/D1Y34t4
+sAPwn4/8AHoG4Ss2Ybzf5vEQyCHbpP6w7bh/Mf6iG3Y/+BHgR8Nfsw2eR7H
Ao/bJuOPB54AORGysg3nP/Bk6E+B/1r4nwp+2lD8/6n7H7hum+y/DOCZsJ8F
XA/72fAvB/nPBW5A/fO24fyH/YKh9Wo9jNBfBP0l8LcMuAn6K4Gbob8e/lmA
24A7oc8Lf3zIfxv47VjfAdwP+51Y3wW5G/wA6tcDf3vB7wM/CPv9wAegbxCy
phz7v1ziIeXY/8DDyqX98HJpPwL8SOBR5bL+0cBjoD8WeBzweNhLgJwIvlKO
8x94MvgpwLWwn4r8pEFOB19XjvMfeCb4WeXy72XpYT8b63Mg50K/oRznP/B8
8AsgG2G/CPwS5K8MuAn1rwRuhr166LPAvg18J9Z7gfuQ/zbktx32O4D74X8n
8C7wu4EHwO+Bf73wvw/8IPj9wAegbxCyZrt8/zV8u8RDtmP/Aw/bjvv/dmk/
YruMPxL8KPCjh9afdeZ8iYH92O3KqTLPYzfOUvG47bj/w14C9CfCvrJd9n8S
+MnbZX+lgK+F/lTw08BPB67bjvMfeCb4WbCvh/1s4Dng50K/AfXPQ77zIReA
b4T9IuAl4JfBPxP4lcDN4NdDvwXx2bbL+4kT673oTx/6pw3222G/A7gf/nfC
Xhf43eAHYL8HeC/09W1X6uYfeGDUorPPxBeE/X7wB8AfBK4xyc//h5kkPtwk
+SNMcv+FmGR8I8EPhTzKhH9vyST9Hw08HPwxkCNgfyz4kVg/DniUSeZ/PNZH
Q/8EE+YT8InIV6xJ9uMk4HGwP9kkn3fiTbK/p4CfgPxNBZ4I/6YBV0xy/k2H
vSTwZ4CfDPszgadA32zgWpOcf3OBp8L+PNQnDfbnY3065AWohw75Xwj7GZAX
QV8m4lsMPAv8JbCvB38p1mcj3mWQc2BvBfi5kFei/w0mOf9XY30e5DWQ8+H/
WvhXAHk97BtRv0LgRbBXjPyVwH4p1pchP+XATei/CuCV4FchHjP8rwVeD32N
kC3gW4HbYN8O/U7w3cC94O8G7kP998B+G+S9qE878r8P+jsg7wffD/8PYH0n
7B8EvwvxHQK/G/zDkAPY/0fA74F8FHIv7B8D3gf5OOQg4j8BvB/6TwIfAP8U
8EHEexr50+yQz//Ddsj1wyGPgByyQ9Z/JPDQHdL/UTtw/u+Q+2/0Dul/OPSN
AT8C9sdifSTWjwMetUN+fjV+h/w9XjT8mQA8BvFNBB4L+5OAx8H/yVgfD3kK
5ATEMxX6E3fI+9o04MoO+f5zOvQnQf8M4Mk75PvNmdCfgvzMBq7dIft3LvBU
2J8HPA3258O/dPAXgK/bgfMf/AzUfxHkTNRvMfAsyEugX4/4lwLPhv/LgOcg
vysQXy7srwRu2IHzH+vzYH8N8Hzga+FfwRCu9t962Dcif4XgF0EuBr8E9kuB
l8HfcuAm1L8CeCXsVwE3Y3/VAq+Hf41Yb0H8VvBt4NuBO1F/N/z1Iv7dwH2Y
v3uwvg3r90Juhz/7gHdA3g/Zj/4/ALwT/hwE3oX8HQLejfwdhr8BxH8E/J4d
8r55FPxe5P8Y8D74fxx4EPGfAN4Pf07uwN/zhv5T4A+CfxqypkJ+/2NYheQP
r5DrR0AOqZD2RwIPrZD9Pgp4WIVi3H3fF6bM0+r5Dzwc+sdUKAf+2ftV+SPD
zuiLAD52SFbxSMQzrkL+vc+oCtk/44FHgz8BeEyF7K+JFbI+seBPAj+uQvbP
ZKyPR7xToD8B8U8Fngh902BfqZD9Px14EvgzoD8Z9mcCTwF/doV8f6VF/ucC
T4W+efAvDfrnA08Hf0GF/P23DvYXgp8B/iLgmejXxUP5VH+flIX6LYF9Pewv
hf5s2F+G/OTA/gr0fy74K+GfoQLnP+znIb9rgOfD/lrYK4C8Hnwj9k/hkD41
viLYLwZegv4rhf4yzJ9y+GOqwPkPvBLxVcEfM+zXAq+H3AjZgvpbYc8G2Q7/
nJgfbsTvBX83cF+FvP/vgf428PfC/3bEvw94B+T9kP2I/wDsd8L+QeynLvTP
IfR/N/bbYcQfgP0jWN+D9UeB98K/Y9hffYjnOPhB1O8E8H7IJ4fyN/xMfAOw
fwr+DiJfp6FPs1P6O2ynxIfvlPpGAA/ZKes5EvpCsX4U8LCdsn6jgYfD/hjo
i4D9seBHgj8OeNROnP87lTzXt5+8ulTNbzT4E3bK/orZKfM/cad83ondKes/
Cfw4xD8Z8cWDPwX+JMD+VOCJkKftlL+/VnbK+Tcd65Ngfwb8S96J8x/8FPBn
g68Ffy7ykwr+vJ2yn9OQv/lYn47+WAD/dDvl/Xsh+BnwbxHwTOR/MfAs2F8C
XL9T7v+lWJ8NeRn8z4F/K4Dngr8SuGGnnP+rd8r7RR7iWwN+PvK/FngB5PWQ
jeAXAi9Cvoohl2C/lYJfBrkcsgn7vwL6KyFXgW9GfmqB10NuRP9bUD8rcBvq
ZwfuBN8N3Av+buC+nXj+h79tiH8v8Hbsx33Q37FT3tf2Y/764f8BzKdO2DsI
vAv+HQLeDXuHgQfQf0ewvgfxHAW/F/PqGPh9wI8DD8L+CdjrR3wngQ+g/05B
/yDyfxr+ayrl9/+HVeL8r5T2R1RK/SGV0v5I4KHgjwIeVinrPxr2w8EfA34E
7I8FHlkp59k46I+qlJ+3jwc/ulLeByZUyvzFwL+J4MdCngR+HPyfDDwe/k4B
nlAp98dU4IngT4M/SqU8/6ZjfRLyNwP8ZMQ/E3gK9M2Gf9pK2f9zgaeCPw/6
0yrx/A88HfwF0K+rxPM/1mdAXgT9mYh/MdZnQV4Cvh71Xwr/ssFfBjwH8a+A
/lzwV4JvqJTzfzXwvEr5vLGmUv6eMB/9txb8AthfXyl/T2vE/i8EXoR4ioGX
QH8p/C0Dvxx8E+pfAf8roa8KfDPir4W9esiN0G9B/a3QbwPfDtw51H8jzvjn
hn5vpZz/u8H3If49sNcGeS/47Yh/H/AO1Gc/cD/iPwC8E/k/iPi6YP8Q+N1Y
fxj9G8D8OYL1PZCPVsr31b2I7xjs94F/HHgQ+/cE8H7wT8L/AcR/CusHIZ+G
fs0uef8ftkuuH75Lxjdil+SH7JLzbyTwUPBH7ZLnadgunP+wH75LxjcG+iNg
fyz0R4I/DvqjduH5H/5G75Ln3wTgMbA/EXgs7E/aJfdT3C48/wOPB38K8ATY
nwr7ieBPA67swvkPPAn6Z8B+8i7ZvzOBp8D+bNRPi/jngp8Kf+ahfmnwbz74
6ZAXQNbtks/fC4FnwP6iXXKeZiL+xfAvC/EvgX494l8KPBv2lwHPQfwrsD4X
9lfCP8OQ/+r3P1dDfx70rQGej/jXAi8Afz3sGxF/IfhF8L8Y+7sE9kuhvwz6
yoGbUP+KXfK8qcT6ql1y/poRXy3wethvRP9b4L8VfBv49l3y+0pO5Me9S3ks
4ud7fl15zhn/vfBvN+z7sP/3IN426N8LvB3+7wPeAfv7EY9/F85/4J3gHwTe
Bf8OwX43+IeRnwDqfwT56QH/KPBe7L9jwPvg73HgQcR/Auv7IZ9EfAOI/xT2
xyD4p8HXVOH7f1U4/6vw/A88BPjIKjz/V+H8Bz+sSsY/Gnh4Fc5/4BHgjwUe
CX/GVcn8R1XJ+TMe/kZDngB+TJXs/4lVcn7Egj8J/Lgq+f5ycpXc//HQN6VK
ft8tAfFOrZLzIRHytCr5fRalSt5/plfJ+20S/JkBfcmwPxP8FPBnVylTlve/
l75OfV7Ron5zsT4V9ZtXJfdvGvpvPvKbXiX3wwLguiqc/7CXAXkR+Jmwvxh4
VpW8LyxBfHrEv7RKPs9lQ9+yof1wrvr5P/AV6I9c1GtllXzfZRjiq5//rAY/
D/6uAZ6P+q+FvQLI66sU38Yxk+os56m/H8f+KUT8Rch/MeItAb8UeBn45fDX
hP1fAX4l+FXAzah/LfB67P9GxGcB34p82+CvHbgT89EN+17Iu8H3Yf/vAd4G
+3tRz3bEtw/8DvT/fuB+9P8B4J3I/0H40wX7hxBvN9YfBh6oks+fR4D3gH8U
/vUi/8fA7wP/OPIXRP+eAL8f/JPonwHk5xT0D2L+ncZ81lTL+/+wajkfhlfL
eEcAD6mW/o6slvMhtFr6Mwr8sGpZv9HAw6tlvGOqpf8R1TK+sfA3slrmbxzw
qGpZ//HAoxHfBOAx1bL+ExFvLOxPAh5Xjff/wONhfwrsJyB/U6vl+ZqI9dOQ
P6Vann/TsT4J9mfAv+Rq2X8zgadA32zI2mo5/+aCn1ot7z/zgKfB/nzg6cj/
AuC6ajn/FwLPgL+LgGfC/mLgWcjfEuB6xL8UeDb4y1DfHOArhvxRz9dc7MeV
1fL+Z6iWz3+rsf/ywF8DPB/21wIvAH99tfw+nhH5K4R/ReAXQ38J8lUKvAz5
Kgduqpbzt2JoP4Woz//VyoUH/7utY7N636qCP2b0Vy38qUf/NAK3oP5W4Dbw
7fDPCftu7G8v9O0G7kP/7wHeBvt7EX875s8+4B3g7wfux/w8UC3vt53or4Pw
rwv9cwj90434D6P+AczfI1jfA/+Pwn4v8n8M8fWBfxx4EPU/Abwf/JPAB3D+
nUJ8g+CfBq4xq/2v/vs/w8xS/3CzzMcIs/JT/Pm22yvV/gsx4/w3y/0dCn2j
gIeZZf1Gm2X9ws0y32PM8nk5wizjGwv9kWa5f8cBjzLL76+MN8v8REP/BMQT
A/8nwv9Y8CdBf5xZ1n8y8HizvP9Mgf8JyP9U2E9E/qYBV8xy/0+H/STUfwb4
yWY8/4OfAvuzUQ+tWe7/ueCnwv485D8N9ueDnw77C4DrzHL+L4T+DNhfBDwT
+V8MPAv8JbCvN8v5udQs53s2/F8Gfg7sr0B9cuHPSvSPwSyf/1aDnwf7a7D/
85H/tahvAfxbD/+N6P9C4EXIXzHwEtgvhb9l4JcjHyaznP8V4Fdi/1bBvhn2
a6G/HvxG8C1m+fmiFbjNLM9DO+rnNMv7jdss3694Uc/dmHc+s3z+2YP52gZ/
9gJvR373meX33Tpgfz/s+5G/A0PySPX8h/2DiK/LLJ8PDiH/3ajnYegLYP8f
Ab8H/KOIp9cs30ceA94Hfcfhf9CsRF+YNOaZIxeckU8M1XPMGbkf+k4ivwPw
7xTyOwj+afA1NfL937AayR9eI/kjamT9Q2qk/ZE1Un8o+KNqlC0nrjKPfVet
b1iNrP9o6A+vkfUaUyP7P6IG5z/sRYI/Dvwo+Du+Rj4/RSO+CeDH1Mj5NhF4
LOxPQnxxiH8y8HjwpwBPqJHzdirql4h8TKuR7+OUGjl/pyMfSeDPqJHzKhn5
mQl+Cviza+T+1iL+uchfKuKfBzytRs6f+chPOvgLgOvg70Loz6iR+3cR8EzU
fzHwLORnCezra+T9cSn42eAvAz8H/b8C+c2FvpWon6FGvv9Zjf7JA38N8pUP
/9YCLwB/fQ3e/6MfC7G+CPkvBl6C/JcCLwO/HPkz1eD5H/xKxFcF3Az7tTXy
flQPfiP4lhp5/7PCPxv4duBO9L8b+82L+HcD99Xg/AfeBv5e+N+O/tuH+dkB
/n7U318jz88D6J9O9ONB9G8X9B8C3g19h9FvAey/I+D3IN9HgfdivhyDvT7s
x+OwH6yR9/0TWN+PepxE/gdQ/1PwdxD808i/phbf/6uV9Rtei/O/Fn//r1ba
H1kr7YeCPwr8sFo8/wMPB38M8AjYH1sr918k+ONq5f0jCvbH18r6RcPehFpZ
v5haWf+JtbI/Ymtl/04CHgf/JwOPB38K7CfA/lTwExHPtFr5vkipxfkPfhLs
zwCeDPsz4V8K+LOBa2vl/JwLPBX+zwOeBvvzgafD/gLEr6uV83ch+Bmwvwh4
JuwvBp4F/pJa+T5HD3wp+NnAl8H/nFo5/1YAz0X8K6HfUIvzH3ge+GuA52N/
rQVeAP/X1ypLH7hh/NqPz1fP/1o5/wuxvgjzqBjzpQT7pxT8slo578rhnwn1
rwBeifirgJtR/1rg9fC/Ef5ZauX91wp7NtTXDtxZK89fN3Av/NsN3FeL8x94
G/h7gbcj//swfzvA349+8SP+A8hXJ+bvQdS/C/YPAe+GvcPwP4D6HwHeA/5R
4L3I/zH434f4j8O/IM6fE8D7Uf+TwAcQ/yngg/D/NHBNHZ7/6yQ+vE7aHwE8
pA7v/4GH1sn7zag62f9hdXj+r5P3n3DoG1Mnz58I+DcWeCT444BH1cn6j6+T
94PoOpm/CXWy/jF1cp5PBB5bh+d/+BOH+CcDj4f9KXV4/18n6z8V/ETwp8E/
pU6+/5wOPKlO7ucZwJPr8PyP+qbA39nIvxbxzwU/Ff7PA54G+/NRv3TkfwH4
ujp5/1mI+DLg/yLkNxP2FwPPAn8J9Ouxf5YCz0b8y+B/DuyvwP7Jhf2VyL8B
/NXA84b8U8/rNej3fOhfC7wA+tYDN2L/FtbJ97lFdfI8La6T70tLkJ9S8Mtg
v7xO3j9MdXL+VgCvRD2qoM+M/qqtU8+DUPX8B78R/lmwf61DshqfrU7e5+x1
8r7kRP7dyK8X+dtdJz8v8NXJz9/21Cn3WxLK/v5S9b8N/bQX+6sd9duH/uzA
ftgP3F8nz88DwDvBP4j8d8H+IfjXDX2HkY8A5s8R6O9B/Y4C70X/HYP+PvCP
Yz8FEf8J6O9H/CcRzwD67xT6ZRD2T0O/ph7f/6+X/Tm8XtofUS/5IfV4/w88
FPxRwMNgb3S9zF84+GOAR9TL+9bYetnfkVg/DnhUvaz/+Hq5f6Lr8ft/4DH1
st8mYn1svdw/k+rx93/qZf0nIz/xiH8K8IR62X9ToT8R9qfBP6Uez//IVxLs
zwA/GfZnAk+pl/0+u17ON2297N+5yG8q+mMe6pdWL/t7Pvjp9XKeLaiX54cO
9V8IexnwfxHiy4T/i8HPgn9LgOtR/6XQnw3+MuA5yP8K4Lnoh5Wwbxiqr/r9
j9Wofx74a4Dn1+P8h/0C8NcDN2J+FAIvAr8Y9ktgvxT8MuyXcuAm1L8CeCXs
V6F/zbBfWy/P53rYbwRuQfxW2LeBbwffWS+fr9zge+H/buC+evn5xx7ktw39
txd4O/pvH/ztgP394Pvr5f3nAPBO8A8C76qXzyeHEF831h9G/wdQ/yPAexDP
UeS/F/EfQ3/0wf5xzK8g5scJ4P2I5yTwAfh3CvNvEPGcxvzTNMjv/w5rkPEN
b5Dzb0SD1BfSIPt/ZIOMP7RBxj8K+sMa8Pd/gYeDPwZ4RAPOf+CRDbJ/xgGP
asD7f8QX3YDf/4Mfg/gnDsUzSj3/G2T9JoEf1yDvr5MbZP3iEf8U4AnApzbI
eZAIe9PAVxrk/X868CT4PwP1TW6Q94OZWJ+C/M0GrkX958LfVMQ3D3ga7M9H
/dJhfwFwXQPOf/iXgf5ZBH8yG+T8WQx+FuwvAa5H/EuhPxv8ZeDnoP9WNMjn
11z4vxJ8QwPOf9jPa8D7f/DzG+T8Wgt+AfjrkX9jg5z/heAXwf9i4CXIfyn0
l2F9OXAT6l8BvBL5r0L/mZH/WvDrG+TzQSP4FsRvhb82xG8H7kT/u1EfL/i7
gfuw//fA/zbw9wJvx7zZh/g6MA/3Y70f+TsAvBPz6CDq3YV4DgHvBv/wkL2L
1PMf/h7B+h7k+yjwXpyPx6CvD/zjwIPY/yeQ337030nwB1D/U+APwv5p+K9p
lH//a1ijzOfwRml/RKO0H9IoP18bCX4o+KOAhzXK/h8NPBz8MY0yvohG2T9j
gUc24vwHHtWI9//Ao2F/AuKPQfwTgcc2yveBkxqVLzvmj0z+50L1/If/kxvl
9/niG/H9/0bZ3wmNOP/hT2KjPK+nQVYacf4j/iTonwE8uRHnP+JPQf5mA9ei
/nOBpzbK/TUP+UhD/uYDT4f/C4DrGuX794XAM9CPixrl/TsT+V4M/7Ngfwn0
6xvl/W8p+NngLwOeg/yvQH1ywV8J+4ZG+fnvavDzsH/WgJ/fKM/3tfCvAPlb
j/wZG+X9oRD6i8AvRv+WIP5S+F+G/iuHflMj3v+DXwl+FeIzI/5a8OuR/0bY
t6D+VuA28O2N8vcATth3I79e5G83+D7s/z2w3wb7e8FvR//vA78D/P3A/Yj/
APBO+H8QeBfiP4T6dMP+YeQngP1/BPp7MH+OYj73ov+OAe9rlM/bxxvV9wVh
6vmP/XUC+exvlPehk8AHkJ9T0D8If043yudlTZO8/w9rkve14U2yn0c0yfqH
NMn8jwQeCv6oJnW/q/6FNcn8jW6S/obDnzFNyt0fJqy6eKR6f4towu//m2R+
IqFvHPCoJnn/Gt8k35dHgz8BeAzsT2xSvrrk5j3fvK7GF9sk6z+pSdYzrkm+
P5oMe/FN8v31lCac/01yPk2F/sQm2e/TmuT9Q2mSzz/TUb+kJrmfZiCeZNR/
JvgpyM/sJmXwuTnGruNqPbVNsh/nwv/UJrkf5wFPQ3/NR37SwV/QpM4bNX5d
k7x/LIT/GYh/EexnIv+LUb8s2F8C//SIfyn8y4b9ZbCf0ySf91dAfy72z0r0
v6FJvv9dDX4e8rEG/HzEtxZ4AfjrEa+xSc6/QvCL0L/F2H8l2B+l6O8y+FeO
+EzY/xXIbyX4VfDP3CTPl1ror0f9GoFbIFuxP2yI347554R/buTHC/27m+T7
CF+T/PxpD/A25GMv5lt7k7yP7cN870D8++GPH/P/APBO8A8C72qSz1eH0F/d
6L/DqF8A9T+C/PbA3tEmeR/oRf6PIX994B8HP4j9ewL160f+T8L/AeTnFPiD
mEengWss6vnjPxP/WRbFkj0t8X6jGv8wi/T/bIv0d7hF2j/Hgs8LwD8XeIhF
7v/zgI8E/3yLzG+oRe6PC8AfBf6FwMMs8vnjIugfbZH5uxj8cIus/yXgj7HI
frwU/AiLnB+XWWR9xlrkfrvcIvsz0iLPvytgb5xF9v+V0B9lkfffq8Afj/iv
hj/R8P8a5HsC8nMt8BiLfH6/DvonWuQ8vx7+x6L/bgA+ySL3z40W9b4y+owc
h/65ySLn12Tovxn64hH/LcCnIP5bgSdY5P3vNuBTYf924Inotzsscj5MQ/3v
BK5Y5Pl/F+ozHfy7gSdZ5P3uHou8v8xA/PeCn2yR8/8+xDcT/PuBpyD/s6B/
NvhzUF+tRc7/Byzy/fBc6HsQ+zcV+h/CfJyHfD8M/WmYf49gf89H/h+FvnTk
/zHgC8B/HLgO+/8JxLsQ/CfhXwbwpxD/IsyTp4Fnwv9nkN/F8PdZixIZnfT3
6jHq/s2yyPvfc/B/CerzPHC9Rd7/XwC+FPwXgWej/15CvMvAXw48B/3/Mubf
CuT3FeQjF/P/VeArwV+F+WiwyPd/r8G/1Rb5/PA64s9D/G9gf67BfH0T+vMR
/1vQvxb8dcALLPL5623oXw//N2D/GeHvO+inQujbiP4tgn+b0L/FyPdm6C/B
+i2QSxHvVou875ahv7bhPChHfNsRvwn7f8dQPVS8Av7vRPyV6K9d8K8K/Grs
XzP6pwb+1SL+OsyfevR/A/LXiPtDE3AL7n/NwK2w3wLchvhb4b8dfAf4Tsx/
F/Lvhj4P+seL+9m7wHejH95DfXwW+fnX+6jPHvT/B3g+aEP/fYj49qL/PgLe
jv37Mfzdh/P6E8y3DtyPPkW/7Yf9z4D7Uf/PgR+AvS8s8v1XJ/R/ifwfRDxf
WeTzchf69+uhflDzfwjxfwN93Yj/W+CHwf8O8QWw/79HvY+gv34A3gP/f4T+
o+D/BP96Uf+fgR/D/voF+78P8f+K/jqO8/Q33P+DFvn+8nfU5wT0/YH69yO+
P4GfBP8v4AM4n/7G/j+FfP+D/A7i/PkX9k6j/v9h/2ua5d//OqtZ5n9Ys7R/
djOe/5ul/XOa5XwY0Yznf+gPacbzf7OMb2Sz3F/nN8v4Qpvl/LkA+kfB/oXg
hzXL58+LmpVlz24J/eiP687Io5uVqe/oare0hp+RL26W7+fCof+SZtk/Y2Dv
0mbZfxHAL2uW82Ys4r8c+Ylslv1/BfBx4F8Je1HN8v57FfI3HvyrUd9o5P8a
6J+A/rkWeEyzvP9fB/0TYf96+BfbLOfPDcAngX8j7Mc1y/l/E/iTwb8ZeDzy
fwvwKeDf2izP1wTk77ZmOQ+mwt/bm+X8SER+7wB/Gvh3gq80y/l6V7M8f6Y3
y/l5N/orCfx7MB9mwL97gSdDvg/yTOTzfuyflGY532Yh/tnQNwf7V4v58wDi
n9ssz5sHkb/UZnm/fAj7fx7y/zDwNPTPI9A/v1ne/x5tlveL9GZ5/jwGfAHq
9Tjs65rl+48nmuX5sBD8J5vl+ZSB+J+C/4uQ/6dhPxPxP9OsvPXFfXZ3mZr/
xbD/LOLLQvzPwf8l6J/nwdc3y+fPF+DfUvBfBD8b9l+C/WXgLwc/B/PvZfBX
IP5XwM/F+fMq+CvRv6vQ34Zmef95DftnNfS9DjwP8+2NZuXP1XNePDH+4jPy
GsT/JvzPR3+8BXktzsN1wAvgz9vY3+vh/wb0q7FZPn++A7wQ/I3N6n1Vja+o
Wb7v3IT5Xoz5txn6SmB/C+ZFKeq7FfGX4f61DXg5+Nuxf03g78D+q4A/O5Hv
StR/F/AqxFvdrDwx+aG4iTVq/szwtwb+1aL/69A/9Th/GmCvEf3XBP0W3P+a
gVvRfy3Qb8P+b4V/dvjvwP3GifuLC/l2w74HuBf1exf53A3+e/Df1yyfv97H
+boH9j7AfGxDf30I/XvB/6hZSTud+6gl9dIzcvsQfvkZ+eNm5Y7y4iud+64+
I+/DefIJzvsO1PdT7Mf9mEefYf/6UZ/P4f8B6P8C9e1E/3+J/BwE/yvgXZj/
XwM/BP43wLth/1vs38OYR98hPwHcf7/H/j2CeH9APnvQ/z9i/VH4/xPwXvT/
z8j/MfB/Qfx9sP8r8OPov9+AB3H+/w77J9AffwDvx/z5E/k+Cft/Dc17NX8D
2L9/oz6nYO8f4IM4r/6F/tOI9z+s11jl7//Ossr75jCr7IezrcqHDasjeg+p
+3e4VfbfOVY5P0ZA37lWuZ9DrPL+d55VxjvSKvN3vhW/L4T9C2B/lFXW70Kr
7L8wq6z/RbA/2irP74vBD7fK+l8C/hirvH9dapX7MwL5vcwq59tY5Otyq6xf
pFXujyussv7j4M+VsB9llfvnKqvc3+PBv9oq71fRVnm+XGOV/TkB9bgW9YtB
/a8DPhH1ux54rFWePzcAn4T+udEq92cc6n8T4p0M+zcDj0f+bgE+Bfxb0T8J
Vjn/b0P+p6K+t1vVeam+j0pEfHdY5fd/p6FedwJXhvxVv/9115A/qv7pVvm8
cDf6Jwn77x7gM5Dve6E/Gfz70P8zsT/ut8r3ESlWeZ+aZZXn+2zgc9AfWqt8
/nkA9ZmL/D+I+FKRz4fg/zz4/zD8T0P8j2D/zoc/j2L/p6O/HkO9FyDex8HX
oX+fQP8tRH89CX0ZmI9PAV8E/tPIXyb6/xnMj8XgP4t5mIV8P4f4l2A/Pg9c
b5Xvf14AvtQq79Mvop7ZmH8vAV8G+8uhPwf5ehnxrbDK55FXwM9F/l+F/ZXo
n1XIr8Eq//7La9jvq9H/r8O/PPTvG8DXoH5vAs+3yvvfW8jHWvDXAS/Afnob
+tcj/xuQPyPq/w7yVwj+RugvQv43AS8GfzPsl1jl+98tsF+K/tsKfhni34b8
lKP+21F/k1X+/mYH7Fcg/zthvxLzZBfsV8H/auBmxF9jVX4Yu/3j0y+PPSPX
Qn8d5nk98tuA+2Yj5mkT5oUF86cZ9qzQ32JV9n8//9cnblTPLxv2fyvyY0f+
HdDvRPwu1McNvgd8L+y/a5XvV3ajnu8hfh/O//dxPu+BPx8gv22o74c4D/ci
/x9Z5edp7bg/fwx7+9Avn8D/DsynT5Gf/eB/Btxvle/fPof+A8j/F4inE/F+
if1/EPn5Cv3Rhfp/jXodAv8b4N2YP99C/2Hsl+8Qf8Aqv3/6PfhHEP8PwHvQ
fz/i/nUU8+Mn8HsR/8+I7xj4v4DfB/u/Aj+O/P0G/4LY/7+DfwLn4R9DzyuX
nJH70V9/It8nMZ//wnk+gOfDv/F8fQr5/wf+DSL+f7F/TuP+/R/qr2mR3/87
q0X297AWOU/ObpHxDW+R8/GcFjkfRrRIe+cCD2mR/Xtei3y+Gdki76Pnt8j9
Gdoi++OCFjmfR7XIfrqwReY7rEX230Utsl6jwb8Y/PAWWc9LWuT8HNMi63Ep
+BEt8v59GfCxLbLelyM/kS14/gc+DvW7Ev5Gtcj5dxXqOx71uxp4dIvsz2ta
5P6YgPivRXwxLfL5/TrgExH/9S3y/Ihtkf19A/iTwL8ReFyLvH/e1CLn+WT0
083oj3j03y3ApyD+W4EntMj7823o76mo3+2oX2KLnBd3YL9MQzx3tsjnL6VF
3v/uGtoP6r8/Nn0Iv/KMfPdQvSPPyEnYH/e0yPc9M2D/XuDJ6Jf7WuS8nYl8
3Y/+S4H9WZhfs1vU+4Wanzmwr0X+H4D+uajHg+i31BZ53j8EfB7ieRj201rk
/H4E9ucj/kehPx32H0N/LAD/cfB1LfL8ewL2F2L/Pwn9GbD/FPpnEfbP07Cf
2SLfXzwDfDHsP9uiXBx8Nvq8PWq/ZMH+c8CX4Lx5Hv7rMX9fAL4U8+JF6Mtu
kef/S8CXoX+WA89BfV7GflmBfn4F9cnF/H0V+EroX9WilIeuL3z4p4gzsqFF
fv/3NZxfqzG/Xoe+vBZ5v3oD/q/B/H0T+cxHft4Cvhb7Zx3sF2D+vg18Pfpj
A3Aj+v8dnC+F4G+Ef0WIfxP0F2M+bUZ+S1rk5z9bkI9S9NdW4GU4/7cBLwd/
O/aHCfHvwHyqgL6dwCsR364WxbD9he+VZHX/V+H8qkb85hb5/FeDfq/F+jrY
r0d/NWB+NKJeTeBbwG9G/1oxf1qwv2yQWzHv7MiPA/l04vxxAXej/zzAvbD/
LvpvN/L5Htb7hvpD/f7n+5hPe7D/PkB+2qDvQ+RrL/z/CP63I/6Pwd8H/ieI
rwP7/1Po34/70GfoBz/uf59D/wHE/wX6uRP2v4T9g9h/XwHvwvnzNeI/hPXf
QO7G/v8W+GHM7+9Qv0CL/Pzre8R/BP37A/g9iP9H2D+K+v0EvBf7/2fEfwz5
+wX8PsT/K/DjqN9v8D+I+fc75s0J7J8/cL/pR37+xPw5CXt/Yf4MYL/9jfPn
FObTP+jfQeT/3xZlpHfjnA3PXXZGPo18/Af/NDb57/+dZZP6h9lkPc62qc9r
6v1huE3m/xyb7J8RNpmfc20yHyE22f/ngT/SJut/PvBQm8zfBTalWln09Oe3
q+fbKMgX2uQ8CIP9i2yyPqORj4tt8vkp3Cb74xKbPF/HwN9LbfJ+GWGT99/L
gI+1yfpdbpP1i7TJ/rgC/HE22c9X2uT8irLJ+XeVTe6X8bB3NfIXjf64BvmZ
AP614MfY5P3pOvAn2uT5cj34sTY5326wyX8/exLqcyP0xdnk9w9uQr0nI76b
0W/xNnn/vgX4FPBvtcnn3QTU/zbwp6J/bkc+E1GvO9Dv05CfO7H/FJv8/vdd
6Lfp6K+74U8S6ncP8Bng3/u/+NfGVYvCbjwjJ8O/+1CvmeiH+23y/W2KTb7/
mGWT779mI545qK/WJuf/A8jPXPj/IPKbivn0EOo3D/YfBp5mw/M/9ut85OdR
5DfdJt+/Pgb/F6D/Hof/Opv8/PMJ5Gch6vGkTembvbw8Z7+6vzKg/yn04yL0
69PYv5nYj8+Avxj5exZ4lg3P/5jfS5CP5+G/HvV9AfNj6RA/6oz8IvorG/69
hPm6DPt9Oc6HHJt8//0y/F2B/L6C/slFvK9i/q+Ef6uAG4bmj/r3315DPVYj
ntfhXx767w301xrYfxP28zH/3kJ+1+L+sM4m70cFmD9vIz/rsX82ADdi/r8D
/YXoj43Yf0Wwvwn5KYb/m4GXoP5bgJeCvxX+lWH+bEN85eif7djfJpv8/tMO
5L8C8e9E/JWIfxfwKvCrgZtt8v1/DfBaxF8H/+oRfwP2WyP6rwnzyGKTn/80
g2+F/y3YHzb0fyvyawffAdyJ+rtQfzf2n8cm3694Ud93Ma93Yz68Z5PvJ3yw
/z727x7k7wPE34b4PwS+F/59hP3fjnx8DHwf8vEJ6teB+n8KfD/O08+wP/w2
+f7tc/hzAPF/gfg6Yf9L6D8I/leY/114fvoa5+MhxP8N7kPdOP++Rf8exn76
Dv4HbPL3H9/D/yPw/wfwexD/j8CPwv+fbPLzmF6bfH79GfEdgz+/4HzuQ/y/
ov7HYf834EGbfP/wO/rvBPh/oH798PdP7LeT4P8FfADx/22T7xdOIf//wL9B
5P9f6D+N+v+H+DWt8u9/ndUq9Q9rlfbPbpXzZ3irzP85rfL3PCNapT/ntsr9
GNIq/T+vVd7nR7bKeXR+q+zv0FY5fy5olf03qlWe/xcCD4P9i1plfka34vm/
Vf5+KbxV9uclrXK+jmmV99VLEX8E8nNZq3ofUr//Nhb6Lm+V/R/ZKs/DK6B/
HOxfCTyqVZ5/V7XK82M86nk16h/dKs/na5DfCa2y/65Ff8W0yvl3HfCJrfK+
cz3ijwV+A/I1CfHfiPjjWuX+vAn1nQz9NyO+eMR/C/yfgvhvRf4SWuX+vw39
MBX9dTvwxFZ5v7gD+qchvjvR30orPv+H/9Ox/+8GnoT9fw/yMwP5vrdVzv9k
6LsP9ZuJeO8HnoJ+nYX4Z2P/zkH82lY5/x+AP3ORvwdb5XxOxXx5qFU+X85r
lef5w+inNPTPI8jX/FZ53jyKfk6H/cda5Xm0APPyccxXHebfE8jvQshPwv8M
9OdTWL+oVb6vebpVuemx/C+vfEJ9f5wJf5/B+sWo17Ot8j6c1Srvl8+1qu9z
1fiWoF7Pg69vlc8fL6BeS9EPL6J/s1GPl9Cvy9B/yxFPDvb/y8BXYL6/gv7K
Rb+8Cnkl8rkK+gyY/68hP6sRz+vYb3nQ9wbyvQbxv4l+zgf+FuJfi/23Dv4U
oP/fRr3Wo183YD4ZW+X9/x3YL4T9jcCLMH83wb9i2N+MfinB+bcF/FLsr63Y
L2Xo122Ivxz+bwduapXf/9uB/FSAvxPxV2J+7cL8rQK/GvcJM+pXg/teLfJV
1yo/f6pHfhta1b/fpH7+1Yjztwn+W1D/ZvSnFfloQX1s8L8VuB18B/aHs1W+
/3KB74b/HuBe9N+7qO9u7K/3EL8P8+994HvA/wD914b4PwS+F/X5CP63Y/59
DPv70D+fIL4O9N+n4O/HfPoM/vlxv/kc59MBrP8C8XRi/Zfo/4Pw/yvE34X9
/zXwQ+B/g/tvN/z/FvPgMPrvO+CBVvn5x/eI9wji/QF4D/rvR+BH4f9PwHtR
/58R/zHY/wX3lz7Mi19x/zgOe7/hfAwif7/j/DuBfvsD52k/9P2J/J4E/hfu
DwOt8vPDv1sV78u1dy9Zo87HUzjv/0G8g6jvv+j304jnP/A1dvnv/5xll/N5
mF2eP2fb5fwabpf3r3Pscl6PsEv/zrXL/ITY5fvj88AfaZfz/Hw7nv/tsj4X
AB9ll/1woV39vE3VF2aX++8iu9zPo+2yfy6GvnC77O9LgI9BPJfaZf9G2OX7
i8vssl5jEd/ldtl/kXZ5PlwB/ji7Mmdf5ZopGrWeV9pl/aPs8vtXVwEfD31X
2+X5GG2X8/Ya1GsC+NdCfwz64Tq77N+JyP/1duW5W9+/ddb2K87IsXY5L26w
y/k7CfW4Ef0bZ5fz5yb4Pxn5vhn+xaM+t6D/poB/K+JPQH/cZpfzbir8vR3x
JKL/7rDL+/k05OdO8BW7/P7XXajXdMR3N/ZHEubDPXb1eVKtzwz4cy/iSbbL
+XufXX5/aSbqf79dztMUu7yfzEL+ZqO/5qB+WuTvAcQ/F/YfHNovavypdjz/
gz8P+XsYeBrm3yPA52N/PQo8Hfl4DPlfgPw/jv2rs+P3/0P+qPNiIew/iX7O
QP2eAr4I/KeBZ2L+PWNXYq6zaKpC1d+XLLbL+/6z2N9ZqM9z6K8lqNfz6C89
5v8L6J+ldnnfehF4NubvS6jHMvi3HPwcu7y/vgz+CvBfAZ4L+69if68EfxVw
g11+//c19Mtq8F/H+ZmHerwBeQ38fRN4Puy9hfystcv7zzroK0D8byO+9bC3
AfqNdvn89Y5dvn8vhL2N0FeE+brJrpyV71lxyWXq/itG/jbDvxK7fH+6Bf6V
Qv9W9HOZXf6eYxvmWznyu31ov6n7y2SX3//bgXxX4P62E/O0Eve/XZhPVeBX
2+X912yX998au3x/V4v1dTg/63H+NNjVz7OHnv9xHjfBf4tdfv7djHpZMb9b
wLehnq3w347z3QH/nYjfhXnnxrz2IL9e5P9d4Lsxf98D7sP5/z7yvQf99wHO
/zbMgw/B34t+/gj91Y7z92PM233Yb59gP3Zg/38K//ajPp/BHz/2/+fAD8D+
F9h/nThvvoR8EPa/ssu/b9GF/vga/XMI+f8G+rpx//kW+GH4/x3mQcAuv//0
PfrjCPr/B+A9qN+PON+PYv/9BP967er7g3Fn5J+H8Ogz8jHwf0F/9cHer+jH
49jPvyH+IJ5/fkd8J1DPP+B/P/bzn6jvSfj/l11+vjiAfvsb609hv/yD/h9E
/f+Ff6fB/w/+ahzy939nOaT9YQ7Zn2c75P1puEPaP8ch7Y9wyPyf68Dn/w55
/zkP/JHgn++Q+QqF/Qsc+P6/Q87rC4GHOfD878Dzv0POz4thP9wh588liG8M
/L8UeATivwz2xzpkv1zuUGpmlXX/plX3R6RD9vMVDjk/xiHeK6EvyiHf/17l
kPeH8Q65v65G/aMdcj5c45Dn1QT4d61D7qcYh9xv18HfibB/PfyLRX1uAH8S
+vdG9Hcc/L/JIeflZNTrZofcT/EO+X7lFvg3Bf13K+wnOOTz423wfyr4t4Of
6JDn5R1D+Vb/fu40+HunQ75/Uhzy/neXQzl0dG9/3jXqPJ6O/N8N/5KQv3sQ
/wzU916HfL+S7MDzP/pjJvJ/v0Pez1Mc+Pt/6L/Z2A9zkC+tQ56vDyA/c6Hv
QeCp2E8PDc0T1b95sP+wQ55PaZgfj6D/5iN/jzrk+690xP8Y5tMC9M/jyK/O
Ib//8ATyvdAhz9snh+aV2h8Z0P8U4l3kkPfxpyFnYv49A/uL0X/PIr4sh7z/
Pwd8Cfx7Hv2rx/x/Af27FPwXgWfD/ksO+f5iGfbfcvRHjkPen17G+hUO+Xz3
ikPeL3Kx/17FfFiJ+q0CbnDg+R/5W43z63XkLw/99wb4a5C/N8HPR3+/hf2x
FvrWYf8WwL+3ga9HvTYANzrk89c72H+F6MeNqE8R5scmzKdi3Gc2Y56UYP9v
AV6K/GzF/i1D/bdhf5WDv90hny9NDvn9nx3wvwL52OmQzz+V2J+7gFc55PvI
atTXjPOvBvWqhf916J969F8D+I3gN4Fvwf5tRr2tqHcL+DbcP1uB25EfB/Lv
dMjPT12w78b+8QD3wv672C+74f972P8+h/z8433Mpz1Y/wHmSRv68UPUfy/2
50fwrx3xf4z49uH+9gn6uwP+feqQn1/ux376DOe3H/33uUN+/noA9r7APO5E
/3yJ+h/E/eAr1KML9fsa8RyCvW+Ad+P++y3qcRj5/A77OeCQ7/+/h/4jqOcP
mA890P8j+vso4v3JId8/9mI+/gz/j6FffgHeh/76FefjcdTjN9Qj6JDvX39H
/59A/v9Af/Tj+eZP6D+J56W/oH8A8f2NfJ1CPf7B/hvEfPgX9TmNefgfzj+N
U53P36rP/06Z32FOGd/ZTnz/3yn77xyntD/CKZ8nznXK9z0hTrm/z3PK/hnp
lM9X5zuVK//86vpYp/r3yEKdsv4XwP9RThn/hdAX5pT1v8gp8zPaKfvnYqf6
vKL+HjTcKfv3Evg/xinrealTfV+r+h/hlPe/y5C/sbB/uVP2VyTivwLxjXPK
/rrSKfs3yinvv1c55fuH8cjH1ch/NOK7ximfTyYAv9YpPx+JQX2uc8rnw4lO
OV+uR31jnfj8H/gk1OdG5DcO+bsJ+ZvslPPkZqecB/Hw7xbENwX2b4V/CU75
/v422JuK/NyOeiRi/9wBfBrqfyfqoTjx/I/9PR38u6E/Cfm7B/wZ4N8LPNkp
77/3Qf9MxH+/U86/FNR/Fvp7tlPO2zlOef/UIv8PoL5zka8HgadivzzklOfl
PMT7MNanOeX94RHw54P/KPjpTnm/fcyp/PHSZae/uEB9P7gA8T6O/tI55efv
TzjlfWch5s2TwDNQn6eAL3IqLfccWNJ/kzovnkY+M53y/vMM8MXIx7PQn+WU
zz/PYV4uwfn1PPKpd8r77wvYn0ud8r74IvjZTnm/fwn9uwznwXInfv+P/nvZ
Kc/7FZgfr8C/XMT/KvCV6JdV8M/glO9/X8P+Wo36vo5+yEM+3oD/a5D/N+Ff
PuJ/C/lZi/yvg/8F2P9vw5/12K8bYN+I+r8D/wvh/0b4V4T7zybwi9G/m+F/
Ceq7xSnvx6VO+T5tq1PeJ8sQ3zacP+XY79uhz4T678D8rEC+doJfifmzC/u9
Cuur4b8Z51cN/K91Kpu6Wt/9tlDNRx3meT32XwP6sxHzoAm4BfVrRrxWnF8t
6C8b+K3A7eA7nPL51Il+cKFebvjrccr3r17g70Lejf37HuarD+f/+/B/D/rr
A+hvQ/0+BL4X++Uj2G/H/fdj4PtQv0+Qrw7Y/xT3t/1D93u1nz7D+eF34vkf
8/oA7rNfwL9OzJ8vgR9E/r+C/13oj6+Rv0OI5xuc593Iz7fAD2M/fof+Czjl
3x/6HvP/CObZD075frsH8/FHp/LXhjd6wxLGn5GP4j7/E/ZvL86nn53y70sf
Qz/+gvr0YX7+inl73KnMKO5o9tap++U3+BPE/eN35O8E8vcH8teP+fMn5t1J
5O8vPD8OIL6/4f8p4P/g+XkQ9foX+TsNff8hPo1L/v2vs1xyvwxzyeels134
9/9c8v3DOS7ZHyNc0v9zXbLeIS55fzkP/JEu/P4f9kNd8vy5wCXzP8ol58+F
LsX6WnbzM7vU/Ie55PPHRS7ZH6Ph78XAw6H/EuRrDPy91CXnewTydxn4Y12y
fpcDj3TJ/rrCpWQ+8n87UI1vHPy/Evwol5xfV6H+4+H/1S4l4851u5J3q/s7
2iXP52ugfwL41yJ/MYj/OuRnIuK/Hngs4r8B+CSX/D7zjUP1VvMT55KfP9/k
kveTyS6532+Gvnj02y0uuf+mYP2t8C/BJefHbcCnIv7bgSci/juAT0P973Sp
z5tXnZEVl7z/3YX6TYf9u9FfSS45f+9xyfk8wyXPw3uBJ7vk+4P70E8zMT/u
R31SYH8W4p3tkve5ObCvdcnPnx9AvHPBfxD1TEX/PuRSBmt+PzBroZqfeS45
nx9G/tNc8n71COKfj3gedcn7QDry8xj6dQH68XH0h84lP/98AvldiP37JPoj
A/33FPBF2B9Pu+TngZnoj2cQ/2LE9yzykeWS94/nUJ8lmM/PIx69S77/fQH+
LkV8L+J8yoY/L7nk+bwM9V2O+uUg/pfh/wr4/wr8z8X59yr4K5G/VfDXMDT/
1b//9hr0r3bJ+8LryE8e5tcbwNcgf2+65P02H+f/W8jvWvi/Dv4XYP+/jf27
Hv28AfEZXfLz73cwHwrh/0bYL4K9TS75fFEM/zcDL4H+LfCv1CWfx7dif5e5
5PPENuDl6IftmAcml3z/vwPxVyB/O+FfJfbfLuSjCv1bjfqacf+oQX5rkb86
l3w/Uo/+bwC/Efwm+Gdx4e//A7eC3wLcBvutsG/HfcPhks/vTpd8/nO55Ocr
bpcy4/8fP1S+B/3gxfnyLvDdsP8e5rPPJT//fR/zdw/m0wfojzaX/PzjQ8y7
vfDvI/Rfu0s+v3+M++E+zJNPXPL9UAf8/RT9vh/77TPkx4/58/n/5v+mFUt2
XK+ezwcwr76AvU48n3wJeweRv6+Qvy70/9fYb4ewv7+B/W7k+1vwD4P/HfIX
cMn3/9+jf4+A/wPs9bjk+5Efkf+j8Ocnl3ye7sX58TPuJ8fgzy8u+f6gD/vz
V+DHwf8NeBD1/x378wTO6z+Q/37Mgz9d8n3DScT/F/pvAP79jfl2Cv3zD/I/
iH77F/vnNOb1fy75ebzGre7Pv9Tnf7fUN8wt9+/Zbnl/G+6W9TrHLefXCLeM
/1y3/Pw7xC3zex7kkW4Z7/lueb6FYv0Fbnm+jHLL+8uFbtmfYW75/vYit+zP
0W48/7tl/4S7Zf9d4pb5HQN/L0V+I9xy/l3mlvUb68b3/5GPSDf+/h/yPc4t
++dK8KPc8vtzV7llf4934/N/+BftlvPvGuAT0B/XIv4Y5P86t5yPE+H/9fA/
FvINsD8J+bsR/RDnlveXm6BvMuK/GXi8W57ftwCfAv9vdct5mQD8Nuyfqajn
7W45HxLRX3dgf05zy3+/7063si6w6vqvm4ee/93y/e9d2D/Tka+7oS/JLc/z
exD/DOTvXuDJ6L/7gM9EfPcjHynov1mo/2w3vv/vlvNd65afvz+Afp2LfDzo
ludnKvr5IeRrHuw/DP/T3PL8eAT1nY94HkV/pKN/HnPL82UB/Hsc+dS58ff/
gC9EPZ4EngH/nnLL94eLEP/TWJ/pxt//A77YLc+vZ93y/pqF+j+H+i2B/efB
17vl+78XsD+X4nx5Ef5lw/5LsL8M9pdjf+a45f3vZbf89wZWYB6+gvrmQn4V
59NKt/p+Sv090Cqcvwa3/Ptnr2E/r3bL54fX3fLzizz07xvYH2vc8n3Ym9gf
+Yj/LeyPtejvdejnApx/b+P8Xo/+2QD7Rrf8/PEd9Echzo+NqF8R6r8J+osx
/zYjvhL0/xbst1K3fP7biv1fhv7ahvlRDn+3Y/+asP93oH8q4M9O7IdK6NuF
/qnCfqhGPGacvzVueX+uxX2qDveTethvwPnUCP+bsN6C+d+M+KzQ14L9b0P9
W4HbsT8dbvV5Qz1/nW75/seFerlRD49bfn7lRX7fRXy7MT/egz8+t/z9+/vg
78H99wPUrw3PBx/ivNyLefCRW74fbXfL9+cf436yz60cf7Th4s0/XHNG/gTz
qwP1/RTzez/i+Qz59cP+5/D3AObBF8A7kd8vof8g6vMV8C63fD/2NfBDqP83
wLth/1vsn8PYP99hHgfc8vPv76H/CPz/Af3bg/r/iHwfxbz7Cf3Xi/3/M/jH
wP8F/D7Y/xX9cxz7+TfUL4jz53ecHyeQ3z9Qj348//2JfJ0E/y/MkwHsr78x
v0+h//7B+TuI+P/F8+1pnEf/Add45N//Pssj4x/mkfk724Pnf488/88BPsIj
83WuR/ZfiEc+P50H+yM9eP73yPqHeuT94ALgozzyvLjQI/dHmEe+/7nII/tv
tEfeNy6Gf+EeWe9LPMpdzmEj/+xX+28M9F2K/ER4ZH9fBv/GemR/XI58Rnrk
/LgC/o3zqJ/Xxp2Rr0T+ozzy+w9XeeT8HO+R70OvRn6jEf818H+CR+63az3y
PhkD/6/D+omI93rkNxb9eQPWT/LI/XQj/I/zyOfPmzxyf072yPPsZo/cT/Hw
/xbgU5DvWxF/Avi3oT+mon9vR30SsT/ugL1pHjk/7vTI81PxyM9/7kL80z1y
ft2NfCd55Py7B/03A/PhXtQn2SPff92HfpqJ/r/fI+8PKZBneeR5Nxv1nuOR
z1da7L8HsF/nIr8Pwl4q6vcQ/J8H/x9GPdI88v7xCPjzPXJeP4p+TPfI+/9j
qO8C2H8c/us88vPvJxD/QvTfk9ifGR58/o98LvLI56ensT8yMb+f8cj3M4vR
789iP2fB3+fAX4L+ex79p/fI+/8L6J+lmP8vop+y4f9LmH/LPPJ5aDn4OR75
+fXL4K9A/V7B/sqF/VeRj5XwfxXqb/DIf//pNfTnauz/19GfeR75/Zg3kP81
Hvl9lzc98v1QPvhveeT3R9d65PPuOvhfgP35Nuyvx/oNHnl/Mnrk57fvwL9C
2N8I/4qQ/03Yr8WY55s98vmtBPNzC+pbiv281SPvt2Xgb0N9ypGf7ciHCft/
B/qzAv2zE/moxHzYhfxXYV5Ve+T7KLNHfn5cA/21iKcO+78e+7kB/EbE24R6
WDzy/Usz6mvF+hbEa8N8a0V/2ZE/B85nJ+rnQv7cyJ8H88ELf979334J+Tfl
3SVqf+xGvt4D3+eRn/++j/m3B/Y/AN6G/vrQoz5Pqvb3Yv1HHvV5S81vO87P
j5HvfcjHJ4i3A/F9ivvqfuCfDd03VPt+1P9zxHsA/fcF/OvE+fIl9vdB7N+v
sL+7PPL94Nfw7xDsf4Pzt9sj329+C/ww7svf4X4X8OD5H/U7gv31A+ZjD86H
Hz3y+6FH4f9PQ+eNuv97MT9/Rn8eQz1+Qf76EO+v6LfjmGe/AQ+i/r/jvDoB
/X/Afj/uO3+CfxL2/0L+BrD//0b+TmGe/IP6DeI+9S/8O43+/w+4xqv6q/79
z7O8sn+HeWX9zvbK+8xwr7x/nuOV+3ME+OcCD/HK96fnQf9IL/7+v1f9vFjd
H6FeuX8u8Mr7zyjou9Ar6xHmlc9/F3llv4/2yvP8Yq+8H4XDv0tgf4xX7o9L
vbK/I7zy/nEZ8jXWi+d/6I/0yvpf4ZXPl+Ow/krUN8orf/90lVeen+O9sr+v
Rj6ikf9rvPL8nOCV/XutV/ZfDPRd55X9PRHxX4/6xHrl/rnBK8+XSaj/jbAf
h/69ySvfb0/2yvP7ZtQvHvZvQf2moP63Ak/wyveft3nl/W6qV75vvd0r7zOJ
8OcOL57/0a93oh6KF5//o1+mQ9/d2D9JqP89Xvl+YAb6517UO9krn3/ug/6Z
Xnm/uB94CvplllfO69no5zlYr8X+fwD65/5PV2cdLlUVtfGxQUIRlRCkUzok
hUs30iDd3d1suqVBpBulU2LOOXNmaBCQBhFpkJJQUUH99vPN3O/53t+f69n3
7Fjxrnetfc5c2L8uxusFNX/Vh/80gP4bAv8aAf++CGq+axxUvtEE+muK9Zth
f82DWj+3CCr/bhnU+rcV/Kt1UPNHG5yvbVDzWbug8q/28IcO8fqOjXeE/3QK
av7rjHjtgnjuivjtBvt3R7z1CGr/p2dQ+0+9oK/eiIc+OG9f2KMf1u8P+w/A
/AOh30HBuNQpko5p+0rMPoMxPgT6GIr4HIa/H478NAL+ZYL6/e9InGcUzjs6
qPxtDOYfi3gbBzwbD3+eAP+fiPFJQeX/kyFPAT5MxX6/BD5Ow/zTg3r/MwP+
NRP2mwV9zw4q/54D+8+F/81Dfv4qqPXvfODD19DvAth3YVDrz0XBGJ+N5b/F
8N8l0N9S4O+yoNYry6GvFcCPldjfqqDWG6uDWk+sAf9Yi/j9But/G8+PYuut
Q/ysB75sAD5thD9sCsZ9tnhuul1HYvNtDur90xbYdyv4zDbMtx322oH974Q/
fIfxXcDv3UGt3/cgHvfCvkH4lxPU+tGFPjzgRyiI+h/4HYZ+I0HU/xjfj/Me
wN8fhHwI8X8Y+j4Cex9F/ByDf32P+Y+DL57A+Mkg6n/Y9xT0exr+ewb89Cye
Pwf8OY94uoDzXwT+XAL+/Aj9Xkb8/ITxK4jPn7H+1aC+f38N/Og61r+B+W9i
/VuIn9uoT+4g/9wF/v0CfLsH/ng/3h9yR+UH8fkr9ntHD2GfR7DHr0H9faTH
Qb0/fwL/eAr/fhaMG3cgeZmF42P48Rv4/e/A1z8gP4f+/sT5/4L9/4b+XgBv
XoLv/QP+8C/w8z/wn4Cj/f9XHP19+Vcd1d9rDu7/HcWnN/D3bzqaf95yVB8J
HM3fCR3Vz9uOxl8irJ/YUf9L4uj5kmL9dxy177uO3r8lc9R/3nM0fpJj/fcd
zb8fOGq/Dx2N/xSO4mtKR+2XytH4Se0o/n3kxJ18NL21KR+zZxpH+49psb+P
HY3fdI7yt/SO8v8MjvL/jNhPJugns6PxkQX+k9VRPMnmaH7L7mj9nAPr58Tz
n8B/cjmKv7kxngf2zwt75IP98jv6/0cKwJ8Lwr8KOZp/CjuaXz91tB9RBPor
iv0XczS/F3eUT5WAfko6ij+f4XylcP7SjvKfOEfvf8o42l8rC/uXw37Kw98r
QP8V4R+VMF4Z8V0F/lsV8VcN8VAd/l8D+FET/v85nq/laP6vjfPXgf7qYrye
o3hcH/7RwFG+3BDjjRzU/w7e/0e8NnHw/r+j+aGZo/V1c+i/BfCvpaPvv7eC
flrDn9pAbgv/a+do/7s91usAfXR09P63E+bvjPN2wfm6OsoPusG/ugM/ejia
D3tC/71gn96O8uk+jvLPvvC/fsCL/o7WvwPw/EDkr0Hwr8GIryHY/1D49zCc
dzj8cwTyh3H0/z+NxP5HOcqfR0M/Yxzlc2Nh73Hwv/HAvwmOvr8/EfE7Cf49
GfgwBfqb6sRt7JDgYK4hMf19CXyeBnm6o++vzIB+Z+I8s7C/2Vh/jqO/jzPX
iVvwX8O0xU7liMrzsL+vHO0vzneUz37taL92AfLLQvjLIowvhv8sAf9Y6uj7
f8ucWD8ua1RejvlW4PmV0M8q+N9qxO8a/P1aR+9/v8H4t+BH65B/1jux+j2m
rw3Y30bg0Sbwj82O9v+2wP+3Av+3YX/bnbiiY3IWHrI09n76DthrJ/T/Hfa3
C/xnN+bfg/X3At+C8fqLre84Wu+7kD2sH3JQ/2P9MOI/gvF9yE/7Hb2vOIB4
ORiP17F4OAR+dBjxcwTzHcXfHwN/+N7R/spxnP8E7H/S0fuXH+C/p5CPTjva
nz6D+D0LfzuH9c9jvgvAt4vwv0uw94/Qx2Xwo5+QH68g/n7G/q46+v3TNezv
OvD7BvDzJvD/FvZ7G3zmDua/i/P/Av5xD/u/j/kfQP8PHa1/HyFf/epo/f4Y
+PME/vwU+PoM/Ps31K+/I9//4cS1yJJub6LZMXx6Dv7zJ877l6P/v+tv4McL
rP8S/vIP8PFfyP/BPwIu3v931T9edfXvX3O1PnrdVf71hqvx86ar/OMtV/WT
wFX9J3TVvm+72l9IhPHEruo/iavxndTF/b+r+exdV+/fk7mKH+9h/8ld9cf3
Xdz/Y/xDV/NBClftl9JV/E/lanylhr4+crUeS+Mq/qV11b8/hj3SYf30rvKv
DNh/Rpw/E/SbGfrPgvmzupq/s7nq39ldzQ854H85sd4nbqxfFvO/XFgvN/ST
x9X4z+tq/sjnav8tv6v95wI4f0H4RyH4Y2FX+f2nrubbIq7id1FX8asYzlsc
cglX65GSrubnz7B+KVf7CaVd5d9xrr7/UQb6K4v5ysGfysP/K0A/FfF8Jcxf
2dX6sQr0XxXxWw3zV3c1f9SA/9Z0Ff8+h/1r4fna0HcdxF9dV/vH9YB/9V3N
bw2w34au5qdGWP8L+EdjV/NFE+i/KfynGcabu8o/WgCPWrq4/8d+W0P/bVyt
T9oiPtq5ysfbw94dYJ+OLu7/kW86u8p/u7hav3bFfN2AH93h/z3w9z2B/72g
v97IF31g377Av37Ag/7Y/wD400CMD4K9BkN/Q+CfQ7H+MOxvOPB3BPRjXP3/
jyNx3lF4fjTWHwP/G+ui/neVH47H/iYgfiZC/5OQHyZjf1MwPhXzf4n1p2F8
uqv3XzOgn5nQ/yw3rkvOyeE8k/JE5dlYf46r/dW5yOfzMN9XyN/z4d9fA+8X
QP8LXeXXi1zlm4uhzyWQl7rK/5cB35ZDHyuw/krg6yrE72rwtzXI12tx/m9c
7Y986yr/Xof11kOfG8BPNwK/NgHfNsM/tkA/W4Fv24DP2xF/O+BfO2Gf73D+
XcD/3cCrPTjfXugjiHzuuHr/4rraL/OAfyFX+x8+9B/G+hHofx/G9yO/HYA+
D8K/D7l6/3EYfO0I9HkU+zsG/vM98ttxF7//j/2eBP/4Afo8hf2fdlH/w7/P
gu+dQ7ycB7+5gPUuIv4uYb0fXe33XMb6P7naP7mCfPSzG/fBP8vmZzsfm/8q
8u81rHcdeHsD/ncT/nsL+es29H8Hz9+FvX+Bfu5BP/fdWL82dv4HON9DrP8I
5/kV8z1G/fMEfPUp9PkM47/B/36H//2B8z3H/v4EHv2F8/+N51+4cSsL5nu6
NWusP/vS1f7BP/DXf3He/7BewMP9v6f48Kqn53nNU/x63UP972m8vumh/vdQ
/3vKLxJ6et63PbVfIk/zS2JP648knp4/KdZ/x1P8etdT/Enm4f7fUz6T3FN8
fR/rf4D1P8T6KTzNHyk9tUcqT+2f2lN/+8iL9Qti9k/jqf3TYv2PMZ4O50/v
6f1FBk/jMyP0n8lTfMrsafxn8RQvsnr4/h/zZ/f0/ZscnsZHTpz/E8yfC+vn
xvN5sH5eD/U/7J8f5y0Afy7oKb8ohPULI34+xfpFYN+inr5/UMyLiyytvuLw
/uxRuTj0VcKLK9jZrVqqf7aoXNLT+7/PcP5SOE9pT/EsztP+dxlP81dZ+Es5
T/GnPOK1gqf8paKn/LWSF7tvjeF3ZU/7y1WAN1URf9XgD9Vx/hqwb03E2+c4
fy34f22cr46n/L0u9lfPU/yv72l+bYDnG2L9RrDPF5i/Mc7fBM83BX42w3zN
4a8t4E8tEX+tPO03tIY/t/GUv7XF+u3gD+0Rrx2gj46e8q9OwN/O2H8X+FNX
T/N/N+BTd+irB/JHT0/fP+gVL8fs39vTeqqPp/2Pvli/H+zfH/46AP450FN+
Pgj7G4z9D4E8FP4xzIu9Txzb/3DgwQhP+bnx8P//POXXozyt/0bDfmOw/ljk
s3E433jsZ4Kn7z9PhH9OAh5Nhv9NQX6dCv1/ifw3DetP9/T99xnA55me3gfN
wv5mw9/neNqfnov150E/XyH+5oNffA38XQD/WIjxRTjfYuh/CfBlqaffPy1D
vC0H31sB+6+EvArnW438twb7Wwv8+MbT+uxbxN86xP96rL8Bf78R+t+E9Td7
2r/aAv1vhf9tQ/xtR7zsQP7bCf19B3/Z5en7Q7tx/j1Yfy/Ggx7e/8e4i/j0
gD+hePyK/f8DH3gVBv+JYHwf8vd+nO8A7HMQ+j/kaf16GPMfAb4ehb6P4fzf
Y/7jnt6HnfDijp3JPLBc6hj/OOnp9zs/eFpfnsJ6pzF+Bvo5C/ufA36ex/gF
6O+ip+8fXUK8/gg+cxnn/Qn4fgV//zP2c9XT9x+vIb6u43w3YN+biN9byN+3
gVd3vLgmibadPN4plp/uetr//gX7v4d8ex/2e4D1H2L8EeL1V/j/Y/D3Jzj/
U/CfZ9Dfb572D39HvP7h6X3nc5zvT5z/L+SPv7GfF7DnS+DrP8hX/wKP//O0
HxUIxfDv8P/e/xsry/grIXneWFn2/2pI6k1jZVn/NZWNlSV/vx6S8xsrL021
763+L2P1zRsh8R9jZblfejMk/NJYWeLzrZDEm7Gy5O8EIeEfxsrSn0gYEj5p
rCz59u1QDH9yRsetLHiRCOsngn4Th6R/bBJDP0l0PZNE5wskDYn/GSuLv7wT
kvxjrCx4/G5Ivn8078K+yULi/yYZ9v8e7G9lwYfkWN/KUp+8H5L8Z6ws/O0D
2P8D6OdDXc98iP2lUHuaFDh/ypDkf2Nlie9UOH8qrJ8a/psa5/sI5/8I66cJ
yf2AsbL0d9OGJH8ZK0t99nFI8M18jPXTIT7SYf/pQ/L+t0mP82fA+TPAPzKG
JH+ZjLB/JqyfCc9nhv9nRvxlAf5YWd63zBoS/m+snOxG4U331sfyS7aQ4KWx
8sE9u6a++Tg2nh3xnx3xnSMkfMrkwHjOkPBrkxP48klI8qGxstQXuULSvzC5
MH9uxROTG/rJExJ+YPLAv/KGhM8aK0f7lbH3L/OFpP9t8sE/8ockn5r8Go+B
AiG5XzMFgM8F4+2TKzpuZclvhVRfplBI83NhxHdh4OunIblfMFaWfFskJPzI
FAnh/ZuQ3H+YotBvMbWXKYb9F8f8xaG/EqoPU0LzSaAk7F8S+vssJHzCWFnq
m1Ih4cumFM5XGv5RGvaLC8nvPxkrCz8rA/wsg/xeFvhQFs+XU3uacjh/eZy/
POKnAs5XAeMVQ3Lfbioivioh/qws9W1l2L8y9FMF9q0C/VbF/FWxfjWMV9N4
DFQPCf801eF/NXD+GsD/msj/NYF/n4O/WFnqi1rA31oYrw38q4391YF+6sA/
6iK+6yK/1MP+6+l5A/WRP+sjvzSA/zXA/A2h/4Yh9F9D8v2PaaR/H/gC+esL
rN8Y61s556e3++3L8El0vElI6hfTBP7fVPdrmsK+zcB/moHfNEf+a47nW4Cf
tQA/aIn83xLjrYA/rbB+a9ivtf59oA3s3wb41TYk/XPTFvynneYz0w78tz34
cXus3wH8oQP23xH+3xH8uROe74TnO+P8nbG/LvCfLthfV/DfrrBfN+XDphvw
qzv2Z2W5H+oB/LWy9Ld7huT+x/TE/nupPxgry/1Ib/DX3sDPPsCHPsCXvsD/
vsD3fth/P+BPf/h/f9hnAPLfAMTfQOx/IM4/CPXbIJxvMJ4fjPWHwP+HwP+H
gr8MBX8ZFoobNrNE14wFo/Y0w5B/hoek/jfDwY9H6H7MCOCfCcn//zEG+Wkk
8s9I2GcU+O8o+Mdo3Y8ZjfONgX3GYHws/Gcs9D8O/HAc9jce+D8e/jchJP1D
MwH6nQj7TQS/m4T1J+H5yci/kxH/U4A/U4C/U2G/qVoPBr4E/n0JfjotJPet
Zhr0Mz0k73+Z6cqnAjMQ/zPAv2eGpL9sZkK/s2DfWahvZoP/zNZ6IzAH9p+D
5+eCn8yFfuchP89DfH4Vku8/jZXvlSmTo/HuGH7OR/zPB/5+rec1XwNfFmB/
C7D/hSF5f8YsBL4tgv4WoX5eDPxZDP6zBOdfAv9dGpLfPzJL1V8Cy5D/lyG+
lwN/liM+V+D8Vpb3V1aGpH9rVqL+WYXzr8L8q0Nyv2NWI/7WaDyYNch/a6H/
tbDfN6j/rCz/j+hbzdfmW+DnOuUTZh3Ovx74tF75YmAD5t+A/LER+9sI/W3S
9cwm7G9zSL6/MpvBH7bAv7fAf7bCv7YCH7bh/NuQX7cDf7ejftoBfN2B+NsJ
/NkJ+38H//sO+LcL/TsrR9/HiZ1/N/ovu+H/e8BP92D9vXh+L84fBP8Nwv8c
7N8Bfrg4v4v1PfiPB/uE4s+fKDoeQv/FB/77yA9hxF8Y8RVB/8jKo9avadCi
WeHo+D7sf19I31/Yj/jYD/84gPrpAM53EPh1EP5zCP2/Q9DfYfCfw8ivR1Cf
HoF9j8L+RzH/MeS/Y9Dv94jv7+G/x8Efj2P8BJ4/Afw8ifx/EvnxBzz/A/o7
p9B/PgX9nNZ4Macx/xng7xnwm7NaD5qzwMdzmg/NOax/HvhxHuMXEP8XQvr7
BxeR/y8CHy6h/rqE/vKP6L/+iPi6jPrnMuz/E/jPT/CfK+DfV1A//4z+48+4
X7kakvcPzVWMXwN+X8P+r4fkft5ch//dQPzeAL7dhP/fhH/eAv7dwvlvw/5W
jr5PE7PPHb0PNHdgn7vo/93F/L+g/oQcuIf4u4fx+8DP+xh/APx8AP73UPO9
eQj/fAT8e4TxX6GfX7H+45C8/2gew/5PEP9PYL+nqI+exuN7zP+eYX/PwO9/
A77+hvl/h/1+B3/5IyTvJ5g/kB+eK18xz8Fv/gT+/Bnfj4m9f/sX8sdf4D9/
o7/2N+LvBeqzF7iffgn++xL8/h/Uf/+An/8LfvxvfD8qet8S+A/818ryfnHA
j8X3q9FxK0v/6RVf+Z+VBZ9f9XX9V/H8a77a38pyvtd93P/7er43fL2/e0P3
E3gT429i/rdUNlaW/JzAV/0nwPoJfb3/SIj13/bVvlaW/JLIV35oZYmvxL72
B60s/pvEV/xJousFkvqKP0lVH4F3fM3PVhZ+9K6v9Z+Vpf+SDPZNhvnf8xW/
3sN4cl/zR3I9T+B9X/mvlSX/feAr/n+A+T/E+lYWfpfCFzwyKeC/KX3t36bE
+qmwfiqsn9pXfpEa/vMR/M/Kcj+Txlf+mAb+kdbX+E8L//rYV/yzsuBnOl/z
r5UlP6f39f4vvfp7IIMfl/jw4X0bRkXxwlhZ6t+MvuKrlRs8qXh7RukYvmTy
Fd8zwX8zw35WFnzO4uv7Q1mg36zQj5Xl/aFsvt6fZNP5Atl9+f7DZAd+5YD/
WlnyQ07Mb2XJb5/A/6ws9Xsu+Fcu4EtutZfJDf3nUX82ebB+XtWXsbLUr/l8
rf/zYf386k/GytJfLgD7FvA1/xUEPhdUfwkUAv4Wgv8XxvkK4/lPfeXfn0K/
RYC/RRQPA0V95T9FEZ/FVJ8GcqC4r/zeylKflMD5rSz8syTsXxL48xnw38rC
b0shf5SC/5ZWfzGlYZ+4eP1Ff//DWDn6PUDMv8v4yr/KaDwEyiK/l4V/lsP+
y+H85X3t/5RHfqgAfK0A/KuI81dE/q+k+d5UwvyVfa3/KyP/VgF+VoF/VtV8
aaqqvgLVNF6MlaW/XB3+Xx36raHxamoongRqgp/VjPfn2Pyfwz8hB2r5Wn/V
Aj7WBv7WRvzU8ZX/1sH+6yI/1AW+1PO1f10P8VUf/lUf8zfA+g0Qfw2Bnw2x
fiNf7w8bwb5fAD+/gH0b63qmMfy/ifIt0wTPN/W1f9oU52sG/GuG/TdXfzXN
fe2ftUB+aoHztfTl919MS/CnVsivrbC/1pi/Nfyjja/1bxvw77bgf21hv3Z+
7P3M6Ptqph3wo73imWkP/Xbw4y4/e9lpRfHo78WbDni+I/hfR10v0EnxxnSC
fTsDXzrDPl0Uz00X5K+uvnz/YLoCv7rB/t2QH7ojf3QHP+oB+/TA+j19ff+v
p6/3B738OHfc1V1TFsTeb7ay/J5pb/i3leX9wj7If1buWf75+i7bY/VpX1/7
v32BT/2An/2w//6I//4YH+DHDRp4YuStBDH/GQD9DfT1/cWByJ+DwH8Gwb6D
FW+NlW9lO1sq7bTY+YcgP1g5b606LV+pHhsfivptKPxrWDw+x/Y/DPxtOPLr
cOT3Eb70a80InN8g/xo8PxL+OxL6HaV8y4wCfoxWexsry/3XGNTPVpb+6ljE
91jUB+N8fT9iHOqf8cD/8ahvJ/j6/vcE8NuJiJ+J8f4a+/2fSb72hyYh/04G
f5qs+w1M0XrCTPHle4LAVPDPqYi/L5F/rCz3L9PAH6aBf0z35ftbMx34PAP8
eQbyx0zYb6b6a2CW+oOZpfEYmI38PxvxN0f9xcxBfpiL+nou+Ps88Id5yE9f
+fr+1VfIn/OB//OBT1+rPoyVo9+TxfS7APhhZfn924WI/4Xgt4tQfy5CfC2G
fRajPl2i+jBLsL+lvnz/apYi/y2DfZfBPsvBP5YjvlZoPjErcL6VyF8rwW9X
QX+rtB8RWI38sxr4sAb8eA30s9bH/T/Gv8H838A/voV9voV91oEfrMP86329
P1kP/9qA828APm1EfbIR62/C+psw/2Zf7582g/9vQf7eAvzYCv1sBb5vg/9t
Az5tR/xuh/13xPdnYvi4A/lvJ/LfTv37wHc4/3fQzy70L3bBv3ajfrJynfOX
XtT7IIbPe5D/9oAf7EX+34v1g76+PxNE/ncQfw7md9GfdfG8h/N7iL+QL///
w4SQv3zYxwe/C2P+MOwfUbwxEfDzfcD/fejP7gf/2A/7H1A8MgeQ/w8ifg5C
f4cQ/4fAfw7Dvw8jfx2BfY7Af4/C/kdhn2OKV+YY9P+91ivGynJ/cxz1gZXP
X5w+ov27eaPjJ4C/J+LjPea/J8F/TiJ+flA+Zn7A+CnY/xTi5zTOfxr6PYP+
zRng21nkf8iBc7DPOfSfz2P981j/Ata/AH5xEf3bi3j+kvabzSXY70fwsx+h
v8uoXy5j/p/A360s97tXYN8r4Jc/Y/8/gx9dRf13FfnzGvo316Cf6+gPXEf/
5gbi8wb4601f32+4qecN3AK+3sL4bdj/NvjNHeDHHej3Lurvu/C/X/D8L+BH
9+D/92D/+7DPfeDvA/C/B8jPD8EvHuL5Rxh/hOd/BT/7FfnnMfL/Y/TPn+D+
8An6A09xvqeo356hf/gM+fM35N/fkF9+R/3/O/jDH8B3K0ffp47F13P9e/Mc
/vEn+p9/Qr9/4fx/gb//jfryb9w/vcD98Qvwq5fIfy+RH/9B/fYP4vdf+J+V
E2xqdqlno5h+/wP/+g/4EQjH7t9fxL7/D+v5Xwlr/FlZ+kuvhrV/aWXpD7wW
VvtYWfoPr4eV/7yO+d8I4/4f878Z1vsfK0v8vhVWfmhlqU8ShLX/mwDzJwzj
/j+s/v12WPsDVhb/TRTW+LCy3K8kDiv+WVnwKYnu11hZ8DlpWPEvKc73Ds7/
jtoj8G5Y7/+sHO1n5I+OJ8P+rfz/+4GB98Jaf1hZ8CU59mdl8d/3w1r/WFn8
8wM8b2XBtw+xvpWFH6YIa3/FytL/TQn/SqnnDaQKK/9NhedT43krC//7KKz9
KStL/ZQmrPnRyoJfaTUeTFro5+Ow3o99DP2ng/7SQT/pw1r/W1nwLUNY+xtW
FvzOCHzICPtmCgsemUzQX2acPzOez4L5s+B8WTVeTVbMny2s/MzKUl9kD+v3
N1YWfM4B/LKy8M+ciA8rS3/gk7DeX3wCfMoV1vuRXIjP3IhfKwu/yKP2NHnU
3wN5w8of8yJ+8oXl/48YK0v+yR/W+sbKUj8VAH5ZWeqbgmHNTwVhv0KI30LA
r8JYvzDm/xT++SnGi2i8mCKYv2hY65+iyE/FNB+aYuqPgeKIPysLPykRVn5Q
AvOXRP6zsvR/P1M8MVYW/lwqjO//cb7SYeV/pZF/4sL6/W8c4q+M2suUwfxl
w9p/KAv/KafxYMopHgbKh7V/WV7xIlAB9q0A/KsY1vrDylJ/VEJ8VoL/Vw4r
/60M/6yC9a0s9zdVgV9WnnfrfoGXa2Lff1eD/1eD/1TH/qsDX2voeUwN+EfN
sPL/mpj/czz/OfhVrbD+fkstnL829l8b/LAO1rey1P91ET9WvpakU72rbWP6
qYf8Xw/2qQ/91wf/aYD82wD5s2FY+XtDjDcK6/vzjWDfL8C/rCz1e2PopzHw
twnyUxPovyn23xTx0Qznbwb7Nkf8NEd+aIH8ZWV5P7hlWH7/1LTE+q30vKYV
+F9r+H9r6LcN8ncb4Etb5Le24L/twH/aIb7ba7427YH/HVQfpgP4Xcewvn/Q
EfjdCfvrhPzcGfjbGfyqC/JzF/hvV8R/V+B7N+Ubppvm80B32L87xnuA//VA
fPeE/XsC33sBP60s/c/e0H9v2L8P1u8D/fUN6/1pX/hXP80nph/wsT/4Q3/s
fwD2P0DjKTAQ9h8I+w1C/hwE/Q1G/rdy9H2uGL4NUb5nhmD/Q9XfzVD49zDg
9zDEx3Dgx3DUpyMQnyOAPyYc638kjI5bWd4vHKl82YzE/KPAT0ZBf6Phv6OB
r2PQPxgD/jAW81tZ+o/j4D/jgF/jFe/MeOXjgQmInwl4fiL8byLicxLsOwn8
ZTLyx2Tw/ymw3xTsb6rimZmK/Pkl5v8S808D/58G/jQ9jPv/sN7fz9B8bGbA
vjOxv5kYnwX7z4J/zQZ+zEZ9PEdlMwf8dS70Pxf2mYf8NQ/9ma/Cev/8FfB/
vuK1mQ/8+Brx8XU8nsTsvwDxvSCeb8XstxD1zULofxHy5yI8v1jrCbMY51+C
+FkC/S0N6+8fLQW+LMP8Vpb7leWoX5eDH64A/1qB+nwl+ncrwQ9W4flV4D+r
gb+r4d9rwL/WAF/Xgn+uxf6/wfrfYP1v0V+AHFin+jbrwD/Wh/X9t/VYfwPw
f0N8vBeMjm8Ev9uI+mAT+OMm6HdzWL+/2gz/2YL43gL+uDWs79dsRX7Yhvpx
G/xrO/qr24HvO4APO4DPO/XvzU7o/zuNJ/Md7L8L+X8X+je7gZ+7Mf8exPce
4Nte7H8v9BNEfFtZ7icc9I8cnN9F/9kF//fgHx7GQ2F9/z+E/qWP+PERv2Hg
exj+F0H/NYL8uC+s96/7wI/3I7/tB386AH52APz/oNrDWFnuzw8BPw5B/4dV
NocRv0eAf0fgP0dh/6Pwj2Nh/X7rGPDle+DP98C348Dn44ivE+pv5gTy18mw
fv9wEvjzA/DHyvJ+6ynY5xT472k8fxr7PwP+dwbxeRb131no/xz42zmMn8fz
55H/L6D+v4D8exH140Xwg0sqm0uo/39UfZkf8fxl7aeay8CXn4C/PyE+rwA/
rwBffgb+/gz/vhrW33+7Cv54Dfh6Dfq9Dv59Hf57A/a/Af+8Gdb3H24Cn25B
v7dwP3Eb899G/+kO+k93UB/fDev9613wz1/AL3/B/PcQn/fC+n7NffDD+zj/
A/C/B+BnDzVfm4fY3yPUD49gv1/Rf/gV53+M+HiM+HiC9Z+E5fd8A0/R/3qq
+SDwDOs/Q/3yG/z3N/Db32H/31E//oH7uT+Ar89xvufIX38i/v+Eff9C/+Av
nO9v4N/fsM8L3P+9AL68xPlfAp//Qf6w8u6ufY9/3ium/39xPiv3bd5m3tor
8ff/0P9/wI9AJBbfr0fHrRyNh9j8r0T0fFYW/vFqRPnfq3j+tUhcDad7spT3
o/Y0Vs6aZvDk8c9j469HlL9YWfDljYjyDytLfngzIvncWFnw9a2I4qeVpf+R
IKL97wSYP2FE7y8T6nyBt6GftzF/oojaz8qC74kjEg/GyhL/SVSfJomeN5A0
ovzRytH7uHzR8XcwbmXJT+9G5P+fGCuLfyRT2VhZ/O+9iOKXlYW/Jcf5k0O/
70cUP6yc+E7q9h1Lxt4/+CAieGSsLPH7YUTj38oSvykiyt9TwD9TRjT/pIT+
U0UEj0wqzJ8a/pVa7Rn4SP3ZWFn4T5qI9o/TwL5poX8rS3/oY+jvYz1vIB3s
b2Xpz6aP6P1veoxnwPMZMH/GiPZ3M0I/mSKSD00m6Dcz4sfKgp9ZVDZWjr6v
F9Nv1oj2p6ws/eNsEcU/K0v+yA7/sbLgc46I8v8cwL+cEb3/srLUP59EtP/0
CeybK6L8IBfmz632MLkxngf+lQf+lRfjVpb6P19E+39Wlvo/v9rL5Id+C+h8
xsr6/b/isSmI9QtFtH4qBHwqHNH6tbDiceBT5AcrS/1RJKL3z1aW+9miEf39
jaLA72IR5X/FgP/FI1p/Fod9SsC+JYCvJSPK30pCf59FlL9bWfh9KTxfCvOX
Bj6V1ngIxEX0+984zF8movVJGeinLPK3lYV/lbPzpTn+snPSaD4y5RB/5WHf
8rBPhYjWXxUQPxXh3xVhn0rAh0rIT5UjWn9WVnsHqsB/q+D8VaH/qshv1SJ6
f1AN8VU9ovWDlaPvg0S/Vw7UgP/WAP7XBP+pCf1+DvyCHKgVwff/eL52RPuH
taH/OvD/OhHlx3Xhv3WRH+ohPupBP/U135v6OH8D5VOmAfC7YUS//20I/TaK
6Ps3Vo72Q2P+9wXs/4XykUBj8JvG6q+BJsjfTZDfmmL+ptB/M40n0wznbw7/
b47xFurvxspSP7cE/7Ny9HvoGD9qBf23wv5awz9a4/k2iiemjfKpQFvwx7aa
LwPt4L/toL/20H974EeHiNzHGCtL/6pjRN9f66h/H+ik/mw6Yf+dcf7OeL4L
+GcX8IOuwE8r///fKwh0g/66wX7dNd8bK0v910PjzfRAfPSM6O8fWFm+z+8V
kfse0wv66w3/64399YH/9kF89cXzffF8P82nph/W7w/99ge/HKB8wgyA/w6M
6PcXA5G/Bimem0HgP4M1X5vB4P9D1B5mCPjPUPD/odj/MD2vGYb1h2N/w8E/
RsB/RoBfmYj8/09joJ+R4N8j4T+jgG+jEP+jsf5o8LMx8P8xyE9jFc/MWPjH
OM3HZhzGx2N9K888OqKyNywWXxMi//f+4v8ANhfCqA==
                "]]}}}}, {}}, 
          AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {True, True}, AxesLabel -> {None, None}, 
          AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
          Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 10000.}, {0, 0.000326}}, PlotRangeClipping -> 
          True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"13294886-a6e3-4f9a-ade1-88f0ae2d4180"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the timing for ",
 ButtonBox["Sort",
  BaseStyle->"Link"],
 " to sort ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", "n", "]"}]], "InlineCode",ExpressionUUID->
  "0412d725-7f5d-4330-98f4-e588d9e2a202"],
 " from a random order, for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"f25d2bd1-59be-4570-b51b-44af652a6f29"],
 " up to 200.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "46.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:24"},ExpressionUUID->"85c2a5de-c110-4b4c-866e-31b0f7169727"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdlktIlFEYhr8kIVrEBC0kCqYoC4nI7teZU17ymjqOl9HR+R2di6uoaFdw
Fi3aBC1cx4/b1hJt4rSxolYJ1Ub6KSEiLa3ILhQV8xWcRxB5fL73vOf7B53Z
lj+fKlSJyMM/339/Vr6Wk9fuzj++enFtUn9hkrefTD17+SpRwXXmxtJMuDob
KcfAm8ydXCJTn51XrkF+CzgO3g7egfNrzXTt9ytTG1eVd8PXIb8HvBfz+0x6
IXbhUt035XqzUn59febrgvJ+5A+AD4IPIX8YfATzR3GfY/DHwSdw3knkT8En
kE/CG5+t0ef7Rv1peLCcgQdLg99vG+AbkW9EfxN8E3yz//rZZpx/FnmwtMC3
6Hlv1bf6fbYV+Tbk25BvR74d+Q7kO7BfJ/JgOQcPli74LvR3+/c13fr3+1Pn
4V23qZ7eVUg1vNN8j3++Adsef97BS8r3JuX3WXgHL73I9+r9lzQPdpiXNPZP
I582N++1zoXlX5rHvPT58wZs+3B/eOnH/cG2H88fLAP+/cwA8mA3gP5B9A/i
/vAOLBnkM8jDu4yZ3NrXGbv8QfNDeH5DvrfwDizD/rwZRj+8g5cs8ln9f7qs
eXiXRX4E+RHkwQ7zMoo82ILdqH+e5JDPYX94l0M+8DkemGLH/c2luRU9L/Dz
AdgiH4Id5iN4GUM/2IADsAWH/1gqn1/cmL9PNKbvRx+1P+9zPK/zayp5Ax+A
bd7UrH+xoXnxk/bDO/gILOM+x8EGHIyjHxyOm6c/Zp/fylTp/shHmJcJ9E9g
f/gAbDEfwrsJ7dP7RPBS0Pejz9pfMI8evK/aWf1F94cPwBYcFtAPH8FL0e+L
F/3nZ+CDIvrhQ7DDfFREfwn9YFPC/mCL+RDelfD6w0sZ/WADDsAWHIJdGfvD
y+T/z/O/AYA3DVk=
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{316.48046875, Automatic},
        Method->{},
        PlotRange->{{0., 200.}, {0, 0.000039}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "fd803f4d-2d7f-4212-a7e6-40f1fe6022da"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{
               RGBColor[0.368417, 0.506779, 0.709798], 
               PointSize[0.01388888888888889], 
               AbsoluteThickness[1.6], 
               LineBox[CompressedData["
1:eJxdlktIlFEYhr8kIVrEBC0kCqYoC4nI7teZU17ymjqOl9HR+R2di6uoaFdw
Fi3aBC1cx4/b1hJt4rSxolYJ1Ub6KSEiLa3ILhQV8xWcRxB5fL73vOf7B53Z
lj+fKlSJyMM/339/Vr6Wk9fuzj++enFtUn9hkrefTD17+SpRwXXmxtJMuDob
KcfAm8ydXCJTn51XrkF+CzgO3g7egfNrzXTt9ytTG1eVd8PXIb8HvBfz+0x6
IXbhUt035XqzUn59febrgvJ+5A+AD4IPIX8YfATzR3GfY/DHwSdw3knkT8En
kE/CG5+t0ef7Rv1peLCcgQdLg99vG+AbkW9EfxN8E3yz//rZZpx/FnmwtMC3
6Hlv1bf6fbYV+Tbk25BvR74d+Q7kO7BfJ/JgOQcPli74LvR3+/c13fr3+1Pn
4V23qZ7eVUg1vNN8j3++Adsef97BS8r3JuX3WXgHL73I9+r9lzQPdpiXNPZP
I582N++1zoXlX5rHvPT58wZs+3B/eOnH/cG2H88fLAP+/cwA8mA3gP5B9A/i
/vAOLBnkM8jDu4yZ3NrXGbv8QfNDeH5DvrfwDizD/rwZRj+8g5cs8ln9f7qs
eXiXRX4E+RHkwQ7zMoo82ILdqH+e5JDPYX94l0M+8DkemGLH/c2luRU9L/Dz
AdgiH4Id5iN4GUM/2IADsAWH/1gqn1/cmL9PNKbvRx+1P+9zPK/zayp5Ax+A
bd7UrH+xoXnxk/bDO/gILOM+x8EGHIyjHxyOm6c/Zp/fylTp/shHmJcJ9E9g
f/gAbDEfwrsJ7dP7RPBS0Pejz9pfMI8evK/aWf1F94cPwBYcFtAPH8FL0e+L
F/3nZ+CDIvrhQ7DDfFREfwn9YFPC/mCL+RDelfD6w0sZ/WADDsAWHIJdGfvD
y+T/z/O/AYA3DVk=
                "]]}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {316.48046875, Automatic}, 
          Method -> {}, PlotRange -> {{0., 200.}, {0, 0.000039}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cb8034fc-e556-405a-9390-079f4e5f37a8"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1e722aec-4ef6-47d6-83b7-946eb1c176ca"],

Cell[TextData[{
 "What does ",
 Cell[BoxData[
  RowBox[{"i", 
   ButtonBox["++",
    BaseStyle->"Link",
    ButtonData->"Increment"]}]], "InlineCode",ExpressionUUID->
  "1763a120-c0e9-4c7a-bb78-0a0c6f2c351a"],
 " mean?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b54e0670-61e2-4274-a0e8-a14611847ac2"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s a short notation for ",
 Cell[BoxData[
  RowBox[{"i", 
   ButtonBox["=",
    BaseStyle->"Link",
    ButtonData->"Set"], "i", 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], "1"}]], "InlineCode",ExpressionUUID->
  "965001a9-8833-480c-a2bf-5869cfba3dc3"],
 ". It\[CloseCurlyQuote]s the same notation that C and many other low-level \
computer languages use for this increment operation."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"495598a7-cc0c-4f9b-98a7-4ace9e0a3651"],

Cell[TextData[{
 "What does the ",
 ButtonBox["For",
  BaseStyle->"Link"],
 " function do?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"70924739-762f-4e59-a9e9-085a926649af"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s a direct analog of the ",
 Cell[BoxData[
  RowBox[{"for", 
   RowBox[{"(", "\[NegativeThinSpace]", 
    StyleBox["...",
     FontColor->GrayLevel[0.6]], ")"}]}]], "InlineCode",ExpressionUUID->
  "c9ebacf7-0936-44b7-989b-18ff94bd31ce"],
 " statement in C. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["For",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["start", "CodeVariable"], ",", 
    StyleBox["test", "CodeVariable"], ",", 
    StyleBox["step", "CodeVariable"], ",", 
    StyleBox["body", "CodeVariable"]}], "]"}]], "InlineCode",ExpressionUUID->
  "8ff32453-577d-4d7c-9e8a-3875792f7efa"],
 " first executes ",
 Cell[BoxData[
  StyleBox["start", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "1a4fb0d9-d763-4581-8341-8bedc471d1e4"],
 ", then checks ",
 Cell[BoxData[
  StyleBox["test", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "30f6cb66-8a9d-473b-b9f3-469d6e91e436"],
 ", then executes ",
 Cell[BoxData[
  StyleBox["step", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "8cd16be4-b447-4172-9e61-4277dcdcdcd7"],
 ", then ",
 Cell[BoxData[
  StyleBox["body", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "49f3e6b7-b315-4c50-931a-7c32b3eeae81"],
 ". It does this repeatedly until ",
 Cell[BoxData[
  StyleBox["test", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "7c08da4b-260d-4ec9-acdc-95cc1bb2cdcc"],
 " no longer gives ",
 ButtonBox["True",
  BaseStyle->"Link"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:26",ExpressionUUID->"daa72f98-ba38-4a2c-b147-fa3789e94c44"],

Cell["Why can shortened pieces of code be hard to understand?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"806ad0d5-0895-4df5-a9c5-925222cf1f8f"],

Cell["\<\
The most common issue is that variables and sometimes even functions have \
been factored out, so there are fewer names to read that might give clues \
about what the code is supposed to do.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c055779a-e68f-48fe-af08-880b44608314"],

Cell["What\[CloseCurlyQuote]s the best IDE for authoring Wolfram Language \
code?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"427ad6f5-444f-4d2b-b1d7-76f100cfff17"],

Cell[TextData[{
 "For everyday programming, ",
 ButtonBox["Wolfram Notebooks",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/language/fast-introduction-for-programmers/\
notebook-documents/"], None},
  ButtonNote->
   "http://www.wolfram.com/language/fast-introduction-for-programmers/\
notebook-documents/"],
 " are best. Make sure to add sections, text and examples right alongside \
your code. For large multi-developer software projects, ",
 ButtonBox["Wolfram Workbench",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.wolfram.com/products/workbench/"], None},
  ButtonNote->"https://www.wolfram.com/products/workbench/"],
 " provides an Eclipse-based IDE."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:27",ExpressionUUID->"7e2bdc7c-24c1-45dc-9063-acc3f6a1df31"],

Cell[TextData[{
 "What does ",
 ButtonBox["Timing",
  BaseStyle->"Link"],
 " actually measure?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fc4978b8-871a-4ba2-b2b7-d3e758bb3392"],

Cell[TextData[{
 "It measures the CPU time spent in the Wolfram Language actually computing \
your result. It doesn\[CloseCurlyQuote]t include time to display the result. \
Nor does it include time spent on external operations, like fetching data \
from the cloud. If you want the absolute \[OpenCurlyDoubleQuote]wall clock\
\[CloseCurlyDoubleQuote] time, use ",
 ButtonBox["AbsoluteTiming",
  BaseStyle->"Link"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"f621e05c-ad2d-4fe6-a415-0812a93d637a"],

Cell["How can I get more accurate timings for code that runs fast?", \
"Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:29",ExpressionUUID->"d12f0674-8fa1-4863-aeaa-f22fc8459b4a"],

Cell[TextData[{
 "Use ",
 ButtonBox["RepeatedTiming",
  BaseStyle->"Link"],
 ", which runs code many times and averages the timings it gets. (This won\
\[CloseCurlyQuote]t work if the code is modifying itself, like in the last \
definition of ",
 Cell[BoxData[
 "fib"], "InlineCode",ExpressionUUID->
  "a653779b-e953-4a4d-b9a7-f98094ed5d26"],
 " above.) "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"afd56d57-7049-4862-b130-fbd8554c4171"],

Cell["What are some tricks for speeding up code?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:30",ExpressionUUID->"90b3db5c-067c-4714-b19c-aedd7b05193d"],

Cell[TextData[{
 "Beyond keeping the code simple, one thing is not to recompute anything you \
don\[CloseCurlyQuote]t have to. Also, if you\[CloseCurlyQuote]re dealing with \
lots of numbers,  it may make sense to use ",
 ButtonBox["N",
  BaseStyle->"Link"],
 " to force the numbers to be approximate. For some internal algorithms you \
can pick your ",
 ButtonBox["PerformanceGoal",
  BaseStyle->"Link"],
 ", typically trading off speed and accuracy. There are also functions like \
",
 ButtonBox["Compile",
  BaseStyle->"Link"],
 " that force more of the work associated with optimization to be done up \
front, rather than during a computation.  "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"06eff5ae-3cef-4919-87f5-345cec92a4d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:289",ExpressionUUID->"4c0ec72d-a12f-4961-ac1e-2c1c865474db"],

Cell[TextData[{
 "Complicated behavior can arise even from extremely simple code: that\
\[CloseCurlyQuote]s what my 1280-page book ",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://wolframscience.com/nksonline/toc.html"], None},
  ButtonNote->"http://wolframscience.com/nksonline/toc.html"],
  FontSlant->"Italic"],
 " is about. A good example is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellularAutomaton",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}]}], "]"}]], "InlineCode",
  ExpressionUUID->"a36b50fa-95d8-4227-b855-136d5107cdff"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:31",ExpressionUUID->"8428dbae-c7a9-464e-9001-d62c82d4d8d1"],

Cell[TextData[{
 "The ",
 Cell[BoxData[
 "fib"], "InlineCode",ExpressionUUID->
  "b2192992-02a1-4217-916f-9b80d7bd52e3"],
 " function is computing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fibonacci",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["n", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "4fb68867-637d-478e-82da-670ae9c96dac"],
 ". The original definition always recurses down a whole tree of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    SuperscriptBox["\[Phi]", "n"], ")"}], TraditionalForm]],ExpressionUUID->
  "3d702281-29cf-49ce-9a82-76e9edb48b76"],
 " values, where \[Phi]\[TildeTilde]1.618 is the golden ratio (",
 ButtonBox["GoldenRatio",
  BaseStyle->"Link"],
 ")."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:32",ExpressionUUID->"fef0f4ba-1b7a-4314-aef2-c1a7b7d789d5"],

Cell["\<\
Remembering values that a function has computed before is sometimes called \
memoization, sometimes dynamic programming and sometimes just caching.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:33",ExpressionUUID->"f325c56b-9bd8-4c3e-a435-7e17b2e95652"],

Cell[TextData[{
 "The function ",
 ButtonBox["IntegerReverse",
  BaseStyle->"Link"],
 " was new in Version 10.3."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:34",ExpressionUUID->"61e23f13-e97b-4b3e-ab76-96705704da80"],

Cell[TextData[{
 "For large programs, the Wolfram Language has a framework for isolating \
functions into ",
 StyleBox["contexts",
  FontSlant->"Italic"],
 " and ",
 StyleBox["packages",
  FontSlant->"Italic"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:35",ExpressionUUID->"da08d249-6995-48d0-a888-f2109e20b4e1"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["If",
     BaseStyle->"CodeLink"], "[", 
    RowBox[{
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], "1", 
      ButtonBox[">",
       BaseStyle->"Link",
       ButtonData->"Greater"], "2"}], ",", 
     RowBox[{"2", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], 
      RowBox[{"0", "[", 
       RowBox[{
        ButtonBox["#",
         BaseStyle->"Link",
         ButtonData->"Slot"], "1", 
        ButtonBox["-",
         BaseStyle->"Link",
         ButtonData->"Subtract"], 
        ButtonBox["#",
         BaseStyle->"Link",
         ButtonData->"Slot"], 
        RowBox[{"0", "[", 
         RowBox[{
          ButtonBox["#",
           BaseStyle->"Link",
           ButtonData->"Slot"], "1", 
          ButtonBox["-",
           BaseStyle->"Link",
           ButtonData->"Subtract"], "2"}], "]"}]}], "]"}]}], ",", "1"}], 
    "]"}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"], 
   ButtonBox["/@",
    BaseStyle->"Link",
    ButtonData->"Map"], 
   RowBox[{
    ButtonBox["Range",
     BaseStyle->"CodeLink"], "[", "50", "]"}]}]], "InlineCode",ExpressionUUID->
  "ac379411-a434-48d0-8648-4d860c7194b2"],
 " is an ",
 ButtonBox["example",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://twitter.com/wolframtap/status/522122421575639041"], None},
  ButtonNote->"https://twitter.com/wolframtap/status/522122421575639041"],
 " of short code that\[CloseCurlyQuote]s seriously challenging to \
understand..."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:36"},ExpressionUUID->"d1d42fb4-9fd0-4962-a80b-9693f9d93c44"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Writing Good Code: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-45-datasets.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-45-datasets.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Datasets\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Datasets", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Debugging Your Code\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Debugging Your Code", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->374,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Writing Good Code \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"9430d519-3a3f-4d4a-9f0c-c61f2eb2bff8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:283"->{
  Cell[660, 23, 444, 11, 93, "SectionDoubleDigit",ExpressionUUID->"85ac732c-9e72-42bf-b534-d0fbbeb7cb5f",
   CounterAssignments->{{"Section", 45}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:283"]},
 "i:1"->{
  Cell[1107, 36, 642, 12, 140, "Text",ExpressionUUID->"4a6a7379-0b00-40a0-a090-c0676543deff",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[1752, 50, 422, 9, 90, "Text",ExpressionUUID->"8bfbe0cf-5819-4a12-a00d-f79e4c91630e",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[2743, 81, 368, 11, 65, "Text",ExpressionUUID->"ed9c50d4-7ec2-4f09-9ff8-d9a608f910a8",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[4455, 137, 232, 6, 37, "CodeCaption",ExpressionUUID->"176266c8-5c55-46d6-a87d-4096b6c2218f",
   CellTags->"i:4"]},
 "LastCellOfAPage"->{
  Cell[6215, 192, 858, 18, 70, "Text",ExpressionUUID->"eec46765-6d39-4980-9142-03e1c8134caf",
   CellTags->{"LastCellOfAPage", "i:5"}],
  Cell[14203, 464, 849, 17, 70, "Text",ExpressionUUID->"738d9a8e-e76a-4435-a06a-f71ce0cc206a",
   CellTags->{"LastCellOfAPage", "i:10"}],
  Cell[21540, 680, 227976, 3882, 70, "Output",ExpressionUUID->"72493f63-81ef-4005-bb6d-0221ebdaaf44",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[254250, 4715, 1315, 35, 70, "Output",ExpressionUUID->"88b1cc3a-a97a-429d-ad9e-e6d7b9ea9765",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[374649, 7048, 1105, 34, 70, "Exercise",ExpressionUUID->"85c2a5de-c110-4b4c-866e-31b0f7169727",
   CellTags->{"LastCellOfAPage", "i:24"}],
  Cell[390718, 7522, 1763, 62, 70, "TechNote",ExpressionUUID->"d1d42fb4-9fd0-4962-a80b-9693f9d93c44",
   CellTags->{"LastCellOfAPage", "i:36"}]},
 "i:5"->{
  Cell[6215, 192, 858, 18, 70, "Text",ExpressionUUID->"eec46765-6d39-4980-9142-03e1c8134caf",
   CellTags->{"LastCellOfAPage", "i:5"}]},
 "p:284"->{
  Cell[7076, 212, 497, 15, 70, "CodeCaption",ExpressionUUID->"632880cb-e7fb-4380-863f-612186d116b5",
   CellTags->{"p:284", "i:6"}]},
 "i:6"->{
  Cell[7076, 212, 497, 15, 70, "CodeCaption",ExpressionUUID->"632880cb-e7fb-4380-863f-612186d116b5",
   CellTags->{"p:284", "i:6"}]},
 "i:7"->{
  Cell[8489, 262, 275, 9, 70, "CodeCaption",ExpressionUUID->"e20b6bc1-3d51-4098-8169-800936d5ac8e",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[10653, 339, 251, 7, 70, "CodeCaption",ExpressionUUID->"92fd3c06-9881-45de-be7d-ff87108af643",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[13509, 440, 233, 5, 70, "CodeCaption",ExpressionUUID->"157650c1-8352-452a-9fea-df8c8969a30f",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[14203, 464, 849, 17, 70, "Text",ExpressionUUID->"738d9a8e-e76a-4435-a06a-f71ce0cc206a",
   CellTags->{"LastCellOfAPage", "i:10"}]},
 "p:285"->{
  Cell[15055, 483, 390, 11, 70, "CodeCaption",ExpressionUUID->"d0cda0a8-2de4-49a3-a5c3-0da6aaa7cc14",
   CellTags->{"p:285", "i:11"}]},
 "i:11"->{
  Cell[15055, 483, 390, 11, 70, "CodeCaption",ExpressionUUID->"d0cda0a8-2de4-49a3-a5c3-0da6aaa7cc14",
   CellTags->{"p:285", "i:11"}]},
 "i:12"->{
  Cell[16482, 534, 518, 10, 70, "Text",ExpressionUUID->"590db775-8905-4112-8055-15902310a0ec",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[17912, 575, 251, 7, 70, "CodeCaption",ExpressionUUID->"03e8fdb1-d911-46fc-822f-622f22224417",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[18745, 604, 766, 18, 70, "Text",ExpressionUUID->"542e7ec5-c20c-4e4b-87f2-45e213c3f845",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[20137, 638, 506, 10, 70, "Text",ExpressionUUID->"bdf943bc-bef4-4f68-a1c8-be59de573a22",
   CellTags->"i:15"]},
 "p:286"->{
  Cell[20646, 650, 218, 5, 70, "CodeCaption",ExpressionUUID->"b5c088ab-46f2-44f5-9967-87b67bee7fcc",
   CellTags->{"p:286", "i:16"}]},
 "i:16"->{
  Cell[20646, 650, 218, 5, 70, "CodeCaption",ExpressionUUID->"b5c088ab-46f2-44f5-9967-87b67bee7fcc",
   CellTags->{"p:286", "i:16"}]},
 "i:17"->{
  Cell[249531, 4565, 718, 13, 70, "Text",ExpressionUUID->"22b76c5c-337f-4d38-8f45-7d59a40d0eca",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[250252, 4580, 229, 6, 70, "CodeCaption",ExpressionUUID->"bc199706-259a-4861-b467-13258b76d742",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[250943, 4604, 233, 6, 70, "CodeCaption",ExpressionUUID->"156d9842-3881-4313-9c56-5b66d246cc34",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[251567, 4626, 495, 10, 70, "Text",ExpressionUUID->"6db33ce3-56a3-41e0-b33e-a3c0bd5d335b",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[252395, 4648, 294, 9, 70, "CodeCaption",ExpressionUUID->"7a14c81f-d66b-490c-90f6-e07b933f00fb",
   CellTags->"i:21"]},
 "p:287"->{
  Cell[253149, 4676, 375, 11, 70, "Text",ExpressionUUID->"d80a5f77-8c78-478a-972f-f388805f5a4c",
   CellTags->{"p:287", "i:22"}]},
 "i:22"->{
  Cell[253149, 4676, 375, 11, 70, "Text",ExpressionUUID->"d80a5f77-8c78-478a-972f-f388805f5a4c",
   CellTags->{"p:287", "i:22"}]},
 "i:23"->{
  Cell[255580, 4753, 713, 16, 70, "Text",ExpressionUUID->"9f7cf492-dc78-4a5a-a094-c6209813efe1",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[374649, 7048, 1105, 34, 70, "Exercise",ExpressionUUID->"85c2a5de-c110-4b4c-866e-31b0f7169727",
   CellTags->{"LastCellOfAPage", "i:24"}]},
 "i:25"->{
  Cell[381300, 7220, 594, 17, 70, "Answer",ExpressionUUID->"495598a7-cc0c-4f9b-98a7-4ace9e0a3651",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[382127, 7250, 1597, 47, 70, "Answer",ExpressionUUID->"daa72f98-ba38-4a2c-b147-fa3789e94c44",
   CellTags->"i:26"]},
 "i:27"->{
  Cell[384482, 7322, 856, 22, 70, "Answer",ExpressionUUID->"7e2bdc7c-24c1-45dc-9063-acc3f6a1df31",
   CellTags->"i:27"]},
 "i:28"->{
  Cell[385575, 7357, 568, 13, 70, "Answer",ExpressionUUID->"f621e05c-ad2d-4fe6-a415-0812a93d637a",
   CellTags->"i:28"]},
 "i:29"->{
  Cell[386146, 7372, 218, 5, 70, "Question",ExpressionUUID->"d12f0674-8fa1-4863-aeaa-f22fc8459b4a",
   CellTags->"i:29"]},
 "i:30"->{
  Cell[386859, 7396, 198, 4, 70, "Question",ExpressionUUID->"90b3db5c-067c-4714-b19c-aedd7b05193d",
   CellTags->"i:30"]},
 "p:289"->{
  Cell[387881, 7427, 174, 4, 70, "TechNoteSection",ExpressionUUID->"4c0ec72d-a12f-4961-ac1e-2c1c865474db",
   CellTags->"p:289"]},
 "i:31"->{
  Cell[388058, 7433, 844, 24, 70, "TechNote",ExpressionUUID->"8428dbae-c7a9-464e-9001-d62c82d4d8d1",
   CellTags->"i:31"]},
 "i:32"->{
  Cell[388905, 7459, 858, 26, 70, "TechNote",ExpressionUUID->"fef0f4ba-1b7a-4314-aef2-c1a7b7d789d5",
   CellTags->"i:32"]},
 "i:33"->{
  Cell[389766, 7487, 311, 7, 70, "TechNote",ExpressionUUID->"f325c56b-9bd8-4c3e-a435-7e17b2e95652",
   CellTags->"i:33"]},
 "i:34"->{
  Cell[390080, 7496, 265, 9, 70, "TechNote",ExpressionUUID->"61e23f13-e97b-4b3e-ab76-96705704da80",
   CellTags->"i:34"]},
 "i:35"->{
  Cell[390348, 7507, 367, 13, 70, "TechNote",ExpressionUUID->"da08d249-6995-48d0-a888-f2109e20b4e1",
   CellTags->"i:35"]},
 "i:36"->{
  Cell[390718, 7522, 1763, 62, 70, "TechNote",ExpressionUUID->"d1d42fb4-9fd0-4962-a80b-9693f9d93c44",
   CellTags->{"LastCellOfAPage", "i:36"}]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:283", 483136, 9424},
 {"i:1", 483376, 9428},
 {"i:2", 483502, 9431},
 {"i:3", 483626, 9434},
 {"i:4", 483751, 9437},
 {"LastCellOfAPage", 483895, 9440},
 {"i:5", 484784, 9455},
 {"p:284", 484933, 9458},
 {"i:6", 485077, 9461},
 {"i:7", 485221, 9464},
 {"i:8", 485353, 9467},
 {"i:9", 485486, 9470},
 {"i:10", 485620, 9473},
 {"p:285", 485771, 9476},
 {"i:11", 485918, 9479},
 {"i:12", 486065, 9482},
 {"i:13", 486194, 9485},
 {"i:14", 486329, 9488},
 {"i:15", 486458, 9491},
 {"p:286", 486588, 9494},
 {"i:16", 486734, 9497},
 {"i:17", 486880, 9500},
 {"i:18", 487011, 9503},
 {"i:19", 487148, 9506},
 {"i:20", 487285, 9509},
 {"i:21", 487416, 9512},
 {"p:287", 487554, 9515},
 {"i:22", 487696, 9518},
 {"i:23", 487838, 9521},
 {"i:24", 487969, 9524},
 {"i:25", 488126, 9527},
 {"i:26", 488259, 9530},
 {"i:27", 488393, 9533},
 {"i:28", 488526, 9536},
 {"i:29", 488659, 9539},
 {"i:30", 488793, 9542},
 {"p:289", 488928, 9545},
 {"i:31", 489070, 9548},
 {"i:32", 489205, 9551},
 {"i:33", 489340, 9554},
 {"i:34", 489474, 9557},
 {"i:35", 489608, 9560},
 {"i:36", 489743, 9563}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[660, 23, 444, 11, 93, "SectionDoubleDigit",ExpressionUUID->"85ac732c-9e72-42bf-b534-d0fbbeb7cb5f",
 CounterAssignments->{{"Section", 45}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:283"],
Cell[1107, 36, 642, 12, 140, "Text",ExpressionUUID->"4a6a7379-0b00-40a0-a090-c0676543deff",
 CellTags->"i:1"],
Cell[1752, 50, 422, 9, 90, "Text",ExpressionUUID->"8bfbe0cf-5819-4a12-a00d-f79e4c91630e",
 CellTags->"i:2"],
Cell[2177, 61, 563, 18, 115, "Text",ExpressionUUID->"fd2d8fae-94b9-4f3f-8abb-43b442092d12"],
Cell[2743, 81, 368, 11, 65, "Text",ExpressionUUID->"ed9c50d4-7ec2-4f09-9ff8-d9a608f910a8",
 CellTags->"i:3"],
Cell[3114, 94, 234, 7, 37, "CodeCaption",ExpressionUUID->"c4446ce3-2204-4ff3-9f61-a44d6c696409"],
Cell[CellGroupData[{
Cell[3373, 105, 252, 7, 29, "Input",ExpressionUUID->"201ade10-58c9-4643-b663-5311b2f71daf"],
Cell[3628, 114, 312, 8, 40, "Output",ExpressionUUID->"ea7c2d32-eac3-49fd-8072-245dc2e9c0d4",
 Evaluatable->False]
}, Open  ]],
Cell[3955, 125, 497, 10, 115, "Text",ExpressionUUID->"86934592-fb32-4cc4-a1da-db70a5951eb3"],
Cell[4455, 137, 232, 6, 37, "CodeCaption",ExpressionUUID->"176266c8-5c55-46d6-a87d-4096b6c2218f",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[4712, 147, 632, 19, 29, "Input",ExpressionUUID->"e039a4a8-0169-4f5e-909b-218d47a27fe4"],
Cell[5347, 168, 312, 8, 40, "Output",ExpressionUUID->"d0ab9a62-b73b-43b6-bcf9-a41106d41450",
 Evaluatable->False]
}, Open  ]],
Cell[5674, 179, 538, 11, 70, "Text",ExpressionUUID->"31e1f8d3-1358-46fd-8150-3ad4dcbbe4bc"],
Cell[6215, 192, 858, 18, 70, "Text",ExpressionUUID->"eec46765-6d39-4980-9142-03e1c8134caf",
 CellTags->{"LastCellOfAPage", "i:5"}],
Cell[7076, 212, 497, 15, 70, "CodeCaption",ExpressionUUID->"632880cb-e7fb-4380-863f-612186d116b5",
 CellTags->{"p:284", "i:6"}],
Cell[7576, 229, 320, 9, 70, "Input",ExpressionUUID->"9e1ce7dd-44c6-457a-bf94-4597d8454497"],
Cell[7899, 240, 156, 4, 70, "CodeCaption",ExpressionUUID->"d860e4d2-8b20-40d9-bb9d-a229ad0bcdf0"],
Cell[CellGroupData[{
Cell[8080, 248, 217, 5, 70, "Input",ExpressionUUID->"33b10495-3c01-4c0d-a885-bc6a12417ff2"],
Cell[8300, 255, 174, 4, 70, "Output",ExpressionUUID->"59afb614-00ea-4728-b3e1-1af05181728f",
 Evaluatable->False]
}, Open  ]],
Cell[8489, 262, 275, 9, 70, "CodeCaption",ExpressionUUID->"e20b6bc1-3d51-4098-8169-800936d5ac8e",
 CellTags->"i:7"],
Cell[8767, 273, 597, 18, 70, "Input",ExpressionUUID->"4c14645c-1aca-491f-9d62-6a95e9f91de8"],
Cell[9367, 293, 162, 4, 70, "CodeCaption",ExpressionUUID->"9f6b6691-cfea-4017-8c3e-e4e2822b32c2"],
Cell[CellGroupData[{
Cell[9554, 301, 240, 6, 70, "Input",ExpressionUUID->"534b1b73-bd16-42d0-9aa8-5fea48aae878"],
Cell[9797, 309, 176, 4, 70, "Output",ExpressionUUID->"239e9336-e36c-4f20-a86b-345c52baae8e",
 Evaluatable->False]
}, Open  ]],
Cell[9988, 316, 234, 7, 70, "CodeCaption",ExpressionUUID->"6d419c77-714d-4dd2-97fe-71e95cba8636"],
Cell[10225, 325, 425, 12, 70, "Input",ExpressionUUID->"dad005b3-8a30-40ed-8a8d-ad8cc3a578a0"],
Cell[10653, 339, 251, 7, 70, "CodeCaption",ExpressionUUID->"92fd3c06-9881-45de-be7d-ff87108af643",
 CellTags->"i:8"],
Cell[10907, 348, 164, 3, 70, "Input",ExpressionUUID->"3658a39d-fd95-4636-ac36-d23645769f41"],
Cell[11074, 353, 209, 5, 70, "Input",ExpressionUUID->"901703f7-15a4-40c2-9b7b-e092b5a99aa6"],
Cell[11286, 360, 361, 10, 70, "Input",ExpressionUUID->"59bb5efd-31c8-4597-a638-39ee28e41715"],
Cell[11650, 372, 170, 4, 70, "CodeCaption",ExpressionUUID->"ff13057b-74c4-4dc1-98c6-afb6bbef54d5"],
Cell[CellGroupData[{
Cell[11845, 380, 241, 6, 70, "Input",ExpressionUUID->"6858961b-8775-418f-8fd4-37a4133999d9"],
Cell[12089, 388, 177, 4, 70, "Output",ExpressionUUID->"6e9811b2-9051-43ca-8c9e-2ad59c77e0da",
 Evaluatable->False]
}, Open  ]],
Cell[12281, 395, 269, 9, 70, "CodeCaption",ExpressionUUID->"c960c912-6895-4125-a82b-297eb75db83d"],
Cell[12553, 406, 165, 3, 70, "Input",ExpressionUUID->"afb2b309-0f08-4f39-852a-4b44d121d9b6"],
Cell[12721, 411, 327, 10, 70, "Input",ExpressionUUID->"4116b1a7-2244-4e8b-af96-cca8fab484cc"],
Cell[CellGroupData[{
Cell[13073, 425, 241, 6, 70, "Input",ExpressionUUID->"c0f41fdf-ee65-417a-9587-a223b4fb4d44"],
Cell[13317, 433, 177, 4, 70, "Output",ExpressionUUID->"43748e41-81da-4735-9a59-393e5756b207",
 Evaluatable->False]
}, Open  ]],
Cell[13509, 440, 233, 5, 70, "CodeCaption",ExpressionUUID->"157650c1-8352-452a-9fea-df8c8969a30f",
 CellTags->"i:9"],
Cell[CellGroupData[{
Cell[13767, 449, 241, 6, 70, "Input",ExpressionUUID->"47dbe523-1a72-464a-9a8e-3d6e978f2157"],
Cell[14011, 457, 177, 4, 70, "Output",ExpressionUUID->"4a5faa57-5f76-49cc-9872-fbe19806b26d",
 Evaluatable->False]
}, Open  ]],
Cell[14203, 464, 849, 17, 70, "Text",ExpressionUUID->"738d9a8e-e76a-4435-a06a-f71ce0cc206a",
 CellTags->{"LastCellOfAPage", "i:10"}],
Cell[15055, 483, 390, 11, 70, "CodeCaption",ExpressionUUID->"d0cda0a8-2de4-49a3-a5c3-0da6aaa7cc14",
 CellTags->{"p:285", "i:11"}],
Cell[15448, 496, 405, 13, 70, "Input",ExpressionUUID->"27c14148-e6f5-4edd-8666-d88760111706"],
Cell[15856, 511, 165, 4, 70, "CodeCaption",ExpressionUUID->"86e8f870-0c93-49a1-92be-5b804e18ab28"],
Cell[CellGroupData[{
Cell[16046, 519, 241, 6, 70, "Input",ExpressionUUID->"722240e3-08d5-48c6-a38e-372d75f437fb"],
Cell[16290, 527, 177, 4, 70, "Output",ExpressionUUID->"a2e7987e-fc72-4529-87a5-9384b8ce26c1",
 Evaluatable->False]
}, Open  ]],
Cell[16482, 534, 518, 10, 70, "Text",ExpressionUUID->"590db775-8905-4112-8055-15902310a0ec",
 CellTags->"i:12"],
Cell[17003, 546, 217, 5, 70, "CodeCaption",ExpressionUUID->"69466297-c4a6-410e-ab83-8a90707ed3f9"],
Cell[17223, 553, 686, 20, 70, "Input",ExpressionUUID->"bb59e1af-3c43-4b0f-a95c-da0fc4e6a8a0"],
Cell[17912, 575, 251, 7, 70, "CodeCaption",ExpressionUUID->"03e8fdb1-d911-46fc-822f-622f22224417",
 CellTags->"i:13"],
Cell[18166, 584, 252, 7, 70, "Input",ExpressionUUID->"ba3fe56a-e19e-4c6f-996e-4938d9f70e7b"],
Cell[18421, 593, 321, 9, 70, "Input",ExpressionUUID->"fd04ac32-829f-49c2-b58b-9a538e9be4ab"],
Cell[18745, 604, 766, 18, 70, "Text",ExpressionUUID->"542e7ec5-c20c-4e4b-87f2-45e213c3f845",
 CellTags->"i:14"],
Cell[19514, 624, 620, 12, 70, "Text",ExpressionUUID->"18413abc-3a97-464f-ab61-bdc7fecac08c"],
Cell[20137, 638, 506, 10, 70, "Text",ExpressionUUID->"bdf943bc-bef4-4f68-a1c8-be59de573a22",
 CellTags->"i:15"],
Cell[20646, 650, 218, 5, 70, "CodeCaption",ExpressionUUID->"b5c088ab-46f2-44f5-9967-87b67bee7fcc",
 CellTags->{"p:286", "i:16"}],
Cell[CellGroupData[{
Cell[20889, 659, 648, 19, 70, "Input",ExpressionUUID->"d2c6f4f6-6b8b-4873-972c-37c2db6ce1a6"],
Cell[21540, 680, 227976, 3882, 70, "Output",ExpressionUUID->"72493f63-81ef-4005-bb6d-0221ebdaaf44",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[249531, 4565, 718, 13, 70, "Text",ExpressionUUID->"22b76c5c-337f-4d38-8f45-7d59a40d0eca",
 CellTags->"i:17"],
Cell[250252, 4580, 229, 6, 70, "CodeCaption",ExpressionUUID->"bc199706-259a-4861-b467-13258b76d742",
 CellTags->"i:18"],
Cell[CellGroupData[{
Cell[250506, 4590, 241, 5, 70, "Input",ExpressionUUID->"4f613b23-96de-42f0-b9d0-93e4e49793cb"],
Cell[250750, 4597, 178, 4, 70, "Output",ExpressionUUID->"7291e09a-4bea-4c53-82ec-a7c88c437514",
 Evaluatable->False]
}, Open  ]],
Cell[250943, 4604, 233, 6, 70, "CodeCaption",ExpressionUUID->"156d9842-3881-4313-9c56-5b66d246cc34",
 CellTags->"i:19"],
Cell[CellGroupData[{
Cell[251201, 4614, 170, 3, 70, "Input",ExpressionUUID->"5dd30fc7-e015-4305-a732-c9a8e6b46831"],
Cell[251374, 4619, 178, 4, 70, "Output",ExpressionUUID->"f0132bf3-54a9-4ade-8a46-0610f185d831",
 Evaluatable->False]
}, Open  ]],
Cell[251567, 4626, 495, 10, 70, "Text",ExpressionUUID->"6db33ce3-56a3-41e0-b33e-a3c0bd5d335b",
 CellTags->"i:20"],
Cell[252065, 4638, 327, 8, 70, "Text",ExpressionUUID->"b870ccdf-4912-4419-85b4-05db5333040a"],
Cell[252395, 4648, 294, 9, 70, "CodeCaption",ExpressionUUID->"7a14c81f-d66b-490c-90f6-e07b933f00fb",
 CellTags->"i:21"],
Cell[CellGroupData[{
Cell[252714, 4661, 188, 4, 70, "Input",ExpressionUUID->"17b63fea-2f94-473b-aa05-e761468847ec"],
Cell[252905, 4667, 229, 6, 70, "Output",ExpressionUUID->"30570a40-8728-47f9-b466-04efd481df28",
 Evaluatable->False]
}, Open  ]],
Cell[253149, 4676, 375, 11, 70, "Text",ExpressionUUID->"d80a5f77-8c78-478a-972f-f388805f5a4c",
 CellTags->{"p:287", "i:22"}],
Cell[253527, 4689, 320, 10, 70, "CodeCaption",ExpressionUUID->"e27d66cd-f77d-47f1-b67d-2bac59fee25b"],
Cell[CellGroupData[{
Cell[253872, 4703, 375, 10, 70, "Input",ExpressionUUID->"2bacd58c-4207-45f3-a525-c8d68cdab657"],
Cell[254250, 4715, 1315, 35, 70, "Output",ExpressionUUID->"88b1cc3a-a97a-429d-ad9e-e6d7b9ea9765",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[255580, 4753, 713, 16, 70, "Text",ExpressionUUID->"9f7cf492-dc78-4a5a-a094-c6209813efe1",
 CellTags->"i:23"],
Cell[256296, 4771, 319, 10, 70, "CodeCaption",ExpressionUUID->"873ab0e3-c686-4f8c-a52b-4afb99f6faf9"],
Cell[256618, 4783, 252, 7, 70, "Input",ExpressionUUID->"00a086a2-a195-4aad-9a15-03c001517110"],
Cell[256873, 4792, 380, 11, 70, "Input",ExpressionUUID->"f89620eb-4665-4e36-8868-11f35e78e5a5"],
Cell[257256, 4805, 221, 6, 70, "CodeCaption",ExpressionUUID->"ee039ef6-495a-4acb-8509-3499c1f9d2a0"],
Cell[CellGroupData[{
Cell[257502, 4815, 377, 10, 70, "Input",ExpressionUUID->"a186eb8f-cacb-42b1-831b-2c40ee51578f"],
Cell[257882, 4827, 7209, 149, 70, "Output",ExpressionUUID->"1b2e6f13-ab47-4e8a-a5ab-090d39fd01ad",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[265140, 4982, 159, 4, 70, "VocabularySection",ExpressionUUID->"fa84b7b1-0aa3-4045-8b2a-93010371c7a3"],
Cell[265302, 4988, 969, 26, 70, "VocabularyTable",ExpressionUUID->"4bc56e05-1879-4bac-8cd2-ca273e757523"]
}, Open  ]],
Cell[CellGroupData[{
Cell[266308, 5019, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"f109d965-1d71-4aa5-a1b5-d1dbc451c83e"],
Cell[CellGroupData[{
Cell[268113, 5069, 1248, 38, 70, "ExerciseSummaryCell",ExpressionUUID->"ee8d3d50-46bf-4cc4-bce5-459ff0044b3b"],
Cell[CellGroupData[{
Cell[269386, 5111, 1957, 65, 70, "Exercise",ExpressionUUID->"d116685e-e859-46d1-b46d-c065f33bef70"],
Cell[271346, 5178, 1081, 31, 70, "ExerciseOutput",ExpressionUUID->"c6dc9bcc-a93b-459b-9233-92c126bd5e02"]
}, Closed]],
Cell[CellGroupData[{
Cell[272464, 5214, 1874, 62, 70, "Exercise",ExpressionUUID->"86415962-a31f-468d-a7c7-4fa66dbd3ffc"],
Cell[274341, 5278, 2536, 72, 70, "ExerciseOutput",ExpressionUUID->"be75ba48-0020-4fb6-ac9c-cb526a381a99"]
}, Closed]],
Cell[CellGroupData[{
Cell[276914, 5355, 2372, 78, 70, "Exercise",ExpressionUUID->"e0232fbd-aabb-481c-9944-7217fb5bf7f4"],
Cell[279289, 5435, 5940, 98, 70, "ExerciseOutput",ExpressionUUID->"4985e129-a967-4f88-a1da-628f05a21a9a"]
}, Closed]],
Cell[CellGroupData[{
Cell[285266, 5538, 946, 27, 70, "Exercise",ExpressionUUID->"51eae5b9-b8e9-4739-9b3d-d9ce0c4993c7"],
Cell[286215, 5567, 88397, 1476, 70, "ExerciseOutput",ExpressionUUID->"13294886-a6e3-4f9a-ade1-88f0ae2d4180"]
}, Closed]],
Cell[CellGroupData[{
Cell[374649, 7048, 1105, 34, 70, "Exercise",ExpressionUUID->"85c2a5de-c110-4b4c-866e-31b0f7169727",
 CellTags->{"LastCellOfAPage", "i:24"}],
Cell[375757, 7084, 4977, 108, 70, "ExerciseOutput",ExpressionUUID->"cb8034fc-e556-405a-9390-079f4e5f37a8"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[380795, 7199, 144, 4, 70, "QASection",ExpressionUUID->"1e722aec-4ef6-47d6-83b7-946eb1c176ca"],
Cell[380942, 7205, 355, 13, 70, "Question",ExpressionUUID->"b54e0670-61e2-4274-a0e8-a14611847ac2"],
Cell[381300, 7220, 594, 17, 70, "Answer",ExpressionUUID->"495598a7-cc0c-4f9b-98a7-4ace9e0a3651",
 CellTags->"i:25"],
Cell[381897, 7239, 227, 9, 70, "Question",ExpressionUUID->"70924739-762f-4e59-a9e9-085a926649af"],
Cell[382127, 7250, 1597, 47, 70, "Answer",ExpressionUUID->"daa72f98-ba38-4a2c-b147-fa3789e94c44",
 CellTags->"i:26"],
Cell[383727, 7299, 195, 4, 70, "Question",ExpressionUUID->"806ad0d5-0895-4df5-a9c5-925222cf1f8f"],
Cell[383925, 7305, 336, 8, 70, "Answer",ExpressionUUID->"c055779a-e68f-48fe-af08-880b44608314"],
Cell[384264, 7315, 215, 5, 70, "Question",ExpressionUUID->"427ad6f5-444f-4d2b-b1d7-76f100cfff17"],
Cell[384482, 7322, 856, 22, 70, "Answer",ExpressionUUID->"7e2bdc7c-24c1-45dc-9063-acc3f6a1df31",
 CellTags->"i:27"],
Cell[385341, 7346, 231, 9, 70, "Question",ExpressionUUID->"fc4978b8-871a-4ba2-b2b7-d3e758bb3392"],
Cell[385575, 7357, 568, 13, 70, "Answer",ExpressionUUID->"f621e05c-ad2d-4fe6-a415-0812a93d637a",
 CellTags->"i:28"],
Cell[386146, 7372, 218, 5, 70, "Question",ExpressionUUID->"d12f0674-8fa1-4863-aeaa-f22fc8459b4a",
 CellTags->"i:29"],
Cell[386367, 7379, 489, 15, 70, "Answer",ExpressionUUID->"afd56d57-7049-4862-b130-fbd8554c4171"],
Cell[386859, 7396, 198, 4, 70, "Question",ExpressionUUID->"90b3db5c-067c-4714-b19c-aedd7b05193d",
 CellTags->"i:30"],
Cell[387060, 7402, 784, 20, 70, "Answer",ExpressionUUID->"06eff5ae-3cef-4919-87f5-345cec92a4d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[387881, 7427, 174, 4, 70, "TechNoteSection",ExpressionUUID->"4c0ec72d-a12f-4961-ac1e-2c1c865474db",
 CellTags->"p:289"],
Cell[388058, 7433, 844, 24, 70, "TechNote",ExpressionUUID->"8428dbae-c7a9-464e-9001-d62c82d4d8d1",
 CellTags->"i:31"],
Cell[388905, 7459, 858, 26, 70, "TechNote",ExpressionUUID->"fef0f4ba-1b7a-4314-aef2-c1a7b7d789d5",
 CellTags->"i:32"],
Cell[389766, 7487, 311, 7, 70, "TechNote",ExpressionUUID->"f325c56b-9bd8-4c3e-a435-7e17b2e95652",
 CellTags->"i:33"],
Cell[390080, 7496, 265, 9, 70, "TechNote",ExpressionUUID->"61e23f13-e97b-4b3e-ab76-96705704da80",
 CellTags->"i:34"],
Cell[390348, 7507, 367, 13, 70, "TechNote",ExpressionUUID->"da08d249-6995-48d0-a888-f2109e20b4e1",
 CellTags->"i:35"],
Cell[390718, 7522, 1763, 62, 70, "TechNote",ExpressionUUID->"d1d42fb4-9fd0-4962-a80b-9693f9d93c44",
 CellTags->{"LastCellOfAPage", "i:36"}]
}, Open  ]]
}
]
*)

(* NotebookSignature qIje7bUDY3Z8HJ5f0JGqfK0x *)
