(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2032248,      41346]
NotebookOptionsPosition[   1904544,      38819]
NotebookOutlinePosition[   2004480,      40870]
CellTagsIndexPosition[   2003234,      40822]
WindowTitle->Datasets: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Datasets", "SectionInline",ExpressionUUID->
   "521f21a2-6452-4797-90e3-61490657a792"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 44}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:271",
 CellLabel->"In[1]:=",ExpressionUUID->"a43a8fc3-c81c-4787-a769-3d893d7cb992"],

Cell[TextData[{
 "Especially in larger organizations, computing often centers around dealing \
with large amounts of structured data. The Wolfram Language has a very \
powerful way to deal with structured data, using what it calls ",
 StyleBox["datasets",
  FontSlant->"Italic"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"29971f26-11dc-468c-aba3-42988e3c4b43"],

Cell["\<\
A simple example of a dataset is formed from an association of associations.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"ae81b7e4-5ec6-406b-8aaf-496db845412c"],

Cell["\<\
Create a simple dataset that can be viewed as having 2 rows and 3 columns:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eabeb1e1-d802-4085-a676-4ba0cec6cda7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Dataset", "[", 
   RowBox[{"\[LeftAssociation]", 
    RowBox[{
     RowBox[{"\"\<a\>\"", "\[Rule]", 
      RowBox[{"\[LeftAssociation]", 
       RowBox[{
        RowBox[{"\"\<x\>\"", "\[Rule]", "1"}], ",", 
        RowBox[{"\"\<y\>\"", "\[Rule]", "2"}], ",", 
        RowBox[{"\"\<z\>\"", "\[Rule]", "3"}]}], "\[RightAssociation]"}]}], 
     ",", 
     RowBox[{"\"\<b\>\"", "\[Rule]", 
      RowBox[{"\[LeftAssociation]", 
       RowBox[{
        RowBox[{"\"\<x\>\"", "\[Rule]", "5"}], ",", 
        RowBox[{"\"\<y\>\"", "\[Rule]", "10"}], ",", 
        RowBox[{"\"\<z\>\"", "\[Rule]", "7"}]}], "\[RightAssociation]"}]}]}], 
    "\[RightAssociation]"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"227bf311-4fff-403a-b0a1-5bb904d049e4"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[0]} -> 1, {All, "x"} -> 
           1, {All, "y"} -> 1, {All, "z"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "x" -> TypeSystem`PackageScope`AtomShape[34], "y" -> 
               TypeSystem`PackageScope`AtomShape[34], "z" -> 
               TypeSystem`PackageScope`AtomShape[34]]]]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[238572043], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 2], "HandleQ" -> True, "RowTarget" -> 
        20, "Data" -> TypeSystem`PackageScope`CacheHandle[238572043]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1260814217][{All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"x\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"x\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1260814217][{All, "x"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[All, "x"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"y\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"y\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1260814217][{All, "y"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[All, "y"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"z\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"z\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1260814217][{All, "z"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[All, "z"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["a", 
                    Style[
                    "a", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1260814217][{
                    Key["a"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1260814217][
                   GeneralUtilities`Slice[
                    Key["a"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["3"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["b", 
                    Style[
                    "b", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1260814217][{
                    Key["b"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1260814217][
                   GeneralUtilities`Slice[
                    Key["b"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["5"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["10"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1260814217][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1260814217]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1260814217][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {169., {34.3837890625, 41.6162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"afb3f699-41be-4d37-9b27-5e5714dadfc5"]
}, Open  ]],

Cell["\<\
The Wolfram Language displays most datasets in tabular form. You can extract \
parts from datasets just like you would from associations.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"d84987f3-9a8e-40b7-9ac5-c0c84e0e19cb"],

Cell[TextData[{
 "Get the element from \[OpenCurlyDoubleQuote]row ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"11a5dd69-5571-4312-854a-5367b443dfeb"],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]column ",
 Cell[BoxData[
 "z"], "InlineCode",ExpressionUUID->"6b099022-9443-4297-9f7a-2ca0cf72bb01"],
 "\[CloseCurlyDoubleQuote]:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"b44910d3-3611-4d38-abe4-224db0a56a72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"\"\<b\>\"", ",", "\"\<z\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"b199d28a-7c87-4c9d-b154-5ae53988fa09"],

Cell[BoxData["7"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"3d11f792-e9c1-48b6-adcb-1b3a45631912"]
}, Open  ]],

Cell[TextData[{
 "You can first extract the whole \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"188bccb2-80a2-4012-a396-a561708b2236"],
 " row\[CloseCurlyDoubleQuote], then get the \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "z"], "InlineCode",ExpressionUUID->"3c7a0cd1-ac45-418b-ab6b-da77a6fcb8af"],
 "\[CloseCurlyDoubleQuote] element of the result: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6d9d3714-a6d4-43f8-abeb-cf101ccc6206"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "[", "\"\<b\>\"", "]"}], "[", "\"\<z\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"a5893f1d-3038-4e01-92e7-6646da5bbc25"],

Cell[BoxData["7"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"5f4a8b52-a136-42e9-8374-90b204faf4a1"]
}, Open  ]],

Cell[TextData[{
 "You can also just get the whole \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "b"], "InlineCodeText",ExpressionUUID->
  "8dff72fb-4a77-4698-9d5d-72093bbb634e"],
 " row\[CloseCurlyDoubleQuote] of the dataset. The result is a new dataset, \
which for ease of reading happens to be displayed in this case as a column."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4da1329c-8c10-4af2-aafd-d22e58333dc3"],

Cell[TextData[{
 "Generate a new dataset from the \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"31f10167-fc22-4eb8-9211-2630327a0894"],
 " row\[CloseCurlyDoubleQuote] of the original dataset: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a06eeb3e-6fc6-48a5-af3f-166609f90c75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", "\"\<b\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"4bc94b73-06f0-48e7-bf7c-68019ed20c7b"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 20, "Length" -> 3, "InitialType" -> 
        TypeSystem`Struct[{"x", "y", "z"}, {
           TypeSystem`Atom[Integer], 
           TypeSystem`Atom[Integer], 
           TypeSystem`Atom[Integer]}], "Shape" -> 
        TypeSystem`PackageScope`DocumentShape[<|{"x"} -> 
           TypeSystem`PackageScope`AtomShape[34], {"y"} -> 
           TypeSystem`PackageScope`AtomShape[34], {"z"} -> 
           TypeSystem`PackageScope`AtomShape[34]|>, 1], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1818362630], "Type" -> 
        TypeSystem`Struct[{"x", "y", "z"}, {
           TypeSystem`Atom[Integer], 
           TypeSystem`Atom[Integer], 
           TypeSystem`Atom[Integer]}], "HandleQ" -> True, "RowTarget" -> 20, 
        "Data" -> TypeSystem`PackageScope`CacheHandle[1818362630]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"x\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"x\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1412864164][{
                    Key["x"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][
                  GeneralUtilities`Slice[
                   Key["x"]]], "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["5"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][
                  GeneralUtilities`Slice[
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"y\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"y\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1412864164][{
                    Key["y"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][
                  GeneralUtilities`Slice[
                   Key["y"]]], "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["10"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][
                  GeneralUtilities`Slice[
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"z\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"z\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1412864164][{
                    Key["z"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][
                  GeneralUtilities`Slice[
                   Key["z"]]], "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][
                  GeneralUtilities`Slice[
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[
               TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1412864164][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1412864164]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1412864164][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[
         TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {66., {34.3837890625, 41.6162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"eca7a6b4-ed40-47a9-a76a-2e12325169fe"]
}, Open  ]],

Cell[TextData[{
 "Here is the dataset that corresponds to the \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "z"], "InlineCodeText",ExpressionUUID->
  "218684c9-bb8e-4bcc-b98a-016168a09e5c"],
 " column\[CloseCurlyDoubleQuote] for all \[OpenCurlyDoubleQuote]rows\
\[CloseCurlyDoubleQuote]."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b5f0702e-4c56-4126-b28f-bb672fc9fbab"],

Cell[TextData[{
 "Generate a dataset consisting of the \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "z"], "InlineCode",ExpressionUUID->"205ad08c-8cf3-4449-a112-cb1b5c660bed"],
 " column\[CloseCurlyDoubleQuote] for all rows: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"08da1713-def3-4a61-91a4-871c8d5ef751"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"All", ",", "\"\<z\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"46463f73-8ecb-416b-a561-49ae701685a2"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
            TypeSystem`PackageScope`AtomShape[34]]], 2, {}], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1093571957], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "HandleQ" -> True, "RowTarget" -> 20, 
        "Data" -> TypeSystem`PackageScope`CacheHandle[1093571957]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                "a", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["3"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[529882178][
                 
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                "b", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[529882178][
                 
                  GeneralUtilities`Slice[
                   Key["b"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            Module[{
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 529882178][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 529882178]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[529882178][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[529882178][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {75., {21.8837890625, 29.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"722ae6f9-982a-4034-9447-219258cc5141"]
}, Open  ]],

Cell["\<\
Extracting parts of datasets is just the beginning. Anywhere you can ask for \
a part you can also give a function that will be applied to all parts at that \
level. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"65e77bd0-1f6c-483e-8217-3b2b10bc087e"],

Cell[TextData[{
 "Get totals for each row by applying ",
 ButtonBox["Total",
  BaseStyle->"Link"],
 " to all columns for all the rows:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:272", "i:5"},ExpressionUUID->"d2cf7064-169f-4140-9666-76999da3fc45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"All", ",", "Total"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"674d69bd-0d2f-465c-85f5-58001ca92487"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
            TypeSystem`PackageScope`AtomShape[34]]], 2, {}], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[634172651], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "HandleQ" -> True, "RowTarget" -> 20, 
        "Data" -> TypeSystem`PackageScope`CacheHandle[634172651]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                "a", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["6"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[721151216][
                 
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                "b", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["22"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[721151216][
                 
                  GeneralUtilities`Slice[
                   Key["b"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            Module[{
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 721151216][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 721151216]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[721151216][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[721151216][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {75., {21.8837890625, 29.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"5922addc-3df4-4ba7-a6cb-4a4164bcb8b0"]
}, Open  ]],

Cell[TextData[{
 "If we use ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "38cd14c6-39e6-4d0c-ac97-05c77b9a250e"],
 " instead of ",
 ButtonBox["Total",
  BaseStyle->"Link"],
 ", we can see what\[CloseCurlyQuote]s going on: the function is being \
applied to each of the \[OpenCurlyDoubleQuote]row\[CloseCurlyDoubleQuote] \
associations. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ef696a96-e1b7-4945-bed3-d3251972bdeb"],

Cell[TextData[{
 "Apply the function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"e402c1dc-739c-4fe8-b935-9564cef7b6b4"],
 " to each row:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1ae1e45b-a4e1-483b-83a1-ef8d69906a7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"All", ",", "f"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"a8505d69-86d6-4b40-8e4c-fa2f4cb4e791"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 2, "Length" -> 2, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[
           TypeSystem`Enumeration["a", "b"]], TypeSystem`AnyType, 2], 
        "DisplayedColumnCount" -> 20, "DataRowCount" -> 0, "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[27.], 
            TypeSystem`PackageScope`UnknownShape]], 2, {}], "DataColumnCount" -> 
        0, "InitialData" -> TypeSystem`PackageScope`CacheHandle[693002410], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[
           TypeSystem`Enumeration["a", "b"]], TypeSystem`AnyType, 2], 
        "HandleQ" -> True, "Meta" -> {}, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[693002410]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["a", 
                    Style[
                    "a", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1976287413][{
                    Key["a"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1976287413][
                   GeneralUtilities`Slice[
                    Key["a"]]], "Mouse"], 
                 ImageSize -> {{27., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", 
                    RowBox[{"\[LeftAssociation]", 
                    RowBox[{
                    RowBox[{"\"x\"", "\[Rule]", "1"}], ",", 
                    RowBox[{"\"y\"", "\[Rule]", "2"}], ",", 
                    RowBox[{"\"z\"", "\[Rule]", "3"}]}], 
                    "\[RightAssociation]"}], "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1976287413][
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["b", 
                    Style[
                    "b", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1976287413][{
                    Key["b"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1976287413][
                   GeneralUtilities`Slice[
                    Key["b"]]], "Mouse"], 
                 ImageSize -> {{27., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", 
                    RowBox[{"\[LeftAssociation]", 
                    RowBox[{
                    RowBox[{"\"x\"", "\[Rule]", "5"}], ",", 
                    RowBox[{"\"y\"", "\[Rule]", "10"}], ",", 
                    RowBox[{"\"z\"", "\[Rule]", "7"}]}], 
                    "\[RightAssociation]"}], "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1976287413][
                  GeneralUtilities`Slice[
                   Key["b"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1976287413][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1976287413]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1976287413][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1976287413][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {270., {29.8837890625, 37.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"3f5596fb-257a-41d4-bf17-89b70b14a2aa"]
}, Open  ]],

Cell[TextData[{
 "Apply a function that adds the ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"2fb3af5f-4469-40b9-86d3-d3dedc6ac0f5"],
 " and ",
 Cell[BoxData[
 "z"], "InlineCode",ExpressionUUID->"9c885e17-19fb-46d2-9464-8ee034f62bdf"],
 " elements of each association:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0af3dd15-ccdd-4d8a-87e0-5d9de706bc81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"All", ",", 
   RowBox[{
    RowBox[{"#x", "+", "#z"}], "&"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"f4df816e-d176-413c-a77a-a2895201b2ed"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
            TypeSystem`PackageScope`AtomShape[34]]], 2, {}], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[477482106], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "HandleQ" -> True, "RowTarget" -> 20, 
        "Data" -> TypeSystem`PackageScope`CacheHandle[477482106]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                "a", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["4"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1035181831][
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                "b", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["12"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1035181831][
                  GeneralUtilities`Slice[
                   Key["b"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1035181831][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1035181831]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1035181831][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1035181831][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {75., {21.8837890625, 29.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"c647ee24-3034-4077-b46e-d54410511bab"]
}, Open  ]],

Cell[TextData[{
 "You can use any function; here\[CloseCurlyQuote]s ",
 ButtonBox["PieChart",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"63f7c831-910a-4f81-afd1-33b6a99371c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"All", ",", "PieChart"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"526248db-b06b-461f-9589-e34ffd8cb68c"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[
           TypeSystem`Enumeration["a", "b"]], 
          TypeSystem`Atom[Graphics], 2], "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
            TypeSystem`PackageScope`AtomShape[60]]], 2, {}], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[49315460], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[
           TypeSystem`Enumeration["a", "b"]], 
          TypeSystem`Atom[Graphics], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[49315460]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                "a", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{}, {}, 
                    
                    DynamicModuleBox[{
                    DynamicChart`click$292113$292195 = False, 
                    DynamicChart`click$292120$292195 = False, 
                    DynamicChart`click$292124$292195 = False}, {{
                    Directive[
                    RGBColor[0.5, 0.5, 1.], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]]], {{{{{{}, {{
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.0943951023931957`, 
                    3.141592653589793}]}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292113$292195, 
                    FEPrivate`Not[DynamicChart`click$292113$292195]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292113$292195, {{{1., 0}, {
                    0, 1.}}, {-0.17320508075688776`, 0.09999999999999999}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$292113$292195}]]}, {
                    
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0., 2.0943951023931957`}]}], 
                    StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292120$292195, 
                    FEPrivate`Not[DynamicChart`click$292120$292195]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292120$292195, {{{1., 0}, {0, 1.}}, {
                    0.09999999999999998, 0.17320508075688776`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$292120$292195}]]}, {
                    
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 0.}]}], 
                    StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292124$292195, 
                    FEPrivate`Not[DynamicChart`click$292124$292195]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292124$292195, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$292124$292195}]]}}}}}, {}}, {{}}}}, {{{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292113$292195, 
                    FEPrivate`Not[DynamicChart`click$292113$292195]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292113$292195, {{{1., 0}, {
                    0, 1.}}, {-0.17320508075688776`, 0.09999999999999999}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$292113$292195}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292120$292195, 
                    FEPrivate`Not[DynamicChart`click$292120$292195]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292120$292195, {{{1., 0}, {0, 1.}}, {
                    0.09999999999999998, 0.17320508075688776`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$292120$292195}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292124$292195, 
                    FEPrivate`Not[DynamicChart`click$292124$292195]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292124$292195, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$292124$292195}]]}, {}}}, {}}}, 
                    DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, \
{}}}, {}}}, {PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, ContentSelectable -> False, 
                    GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], LabelStyle -> {
                    GrayLevel[0], FontFamily -> "Arial"}, 
                    PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
                    Scaled[0.02]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1873534869][
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                "b", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{}, {}, 
                    
                    DynamicModuleBox[{
                    DynamicChart`click$292163$292196 = False, 
                    DynamicChart`click$292167$292196 = False, 
                    DynamicChart`click$292171$292196 = False}, {{
                    Directive[
                    RGBColor[0.5, 0.5, 1.], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]]], {{{{{{}, {{
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {1.7135959928671598`, 
                    3.141592653589793}]}], StatusArea[#, 5]& , TagBoxNote -> 
                    "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292163$292196, 
                    FEPrivate`Not[DynamicChart`click$292163$292196]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292163$292196, {{{1., 0}, {
                    0, 1.}}, {-0.15114991487085164`, 
                    0.13097214678905705`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$292163$292196}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.1423973285781068`, 
                    1.7135959928671598`}]}], StatusArea[#, 10]& , TagBoxNote -> 
                    "10"], 
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292167$292196, 
                    FEPrivate`Not[DynamicChart`click$292167$292196]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292167$292196, {{{1., 0}, {0, 1.}}, {
                    0.1918985947228995, 0.056346511368285904`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$292167$292196}]]}, {
                    
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.1423973285781068`}]}], 
                    StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292171$292196, 
                    FEPrivate`Not[DynamicChart`click$292171$292196]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292171$292196, {{{1., 0}, {
                    0, 
                    1.}}, {-0.10812816349111953`, -0.16825070656623622`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$292171$292196}]]}}}}}, {}}, {{}}}}, {{{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292163$292196, 
                    FEPrivate`Not[DynamicChart`click$292163$292196]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292163$292196, {{{1., 0}, {
                    0, 1.}}, {-0.15114991487085164`, 
                    0.13097214678905705`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$292163$292196}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 10]& , TagBoxNote -> "10"], 
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292167$292196, 
                    FEPrivate`Not[DynamicChart`click$292167$292196]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292167$292196, {{{1., 0}, {0, 1.}}, {
                    0.1918985947228995, 0.056346511368285904`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$292167$292196}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$292171$292196, 
                    FEPrivate`Not[DynamicChart`click$292171$292196]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$292171$292196, {{{1., 0}, {
                    0, 1.}}, {-0.10812816349111953`, -0.16825070656623622`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$292171$292196}]]}, {}}}, {}}}, 
                    DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, \
{}}}, {}}}, {PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, ContentSelectable -> False, 
                    GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], LabelStyle -> {
                    GrayLevel[0], FontFamily -> "Arial"}, 
                    PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
                    Scaled[0.02]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1873534869][
                  GeneralUtilities`Slice[
                   Key["b"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1873534869][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1873534869]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1873534869][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1873534869][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {137., {98.8837890625, 106.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"237fd118-e84b-44a3-bc38-14a84d80ec0d"]
}, Open  ]],

Cell["You can give a function to apply to all rows too.", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4ca7617d-13f4-499b-804b-42adf09ef4a0"],

Cell[TextData[{
 "This extracts the value of each \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "z"], "InlineCode",ExpressionUUID->"f1d9b760-e18c-49a2-8544-c695b2eedb29"],
 " column\[CloseCurlyDoubleQuote], then applies ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"5a0a43c7-d4d8-4a4b-b988-4eea967ab022"],
 " to the association of results:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e71fc055-bc15-4adc-a2da-10ffceb8c8f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"f", ",", "\"\<z\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"df3c5ee7-3967-49a4-bbd9-2521217764b3"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"\<\"a\"\>", "\[Rule]", "3"}], ",", 
    RowBox[{"\<\"b\"\>", "\[Rule]", "7"}]}], "\[RightAssociation]"}], 
  "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"f887f3b1-ef7c-4cde-ab4b-9c20c5536fc8"]
}, Open  ]],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"6f3529e8-2ef1-456c-a559-6559532da0a3"],
 " to the totals of all columns:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2c3ca063-f10e-4914-95e1-23dbd7b657d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"f", ",", "Total"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"15365425-176f-4f2c-bbbe-a9960ffe7782"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"\<\"a\"\>", "\[Rule]", "6"}], ",", 
    RowBox[{"\<\"b\"\>", "\[Rule]", "22"}]}], "\[RightAssociation]"}], 
  "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[11]=",ExpressionUUID->"5d538428-1b0a-4923-92e2-930df24b44df"]
}, Open  ]],

Cell["Find the maximum of these totals:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:273", "i:7"},ExpressionUUID->"d2a75d4d-d24c-4935-9df0-acec04d937c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"Max", ",", "Total"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"69c86e2f-9341-4965-8a83-aaa0a173a69a"],

Cell[BoxData["22"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"7adce590-cf05-4f20-9cea-1e545abc5e93"]
}, Open  ]],

Cell[TextData[{
 "You can always \[OpenCurlyDoubleQuote]chain\[CloseCurlyDoubleQuote] \
queries, for example first finding the totals for all rows, then picking out \
the result for the \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "b"], "InlineCodeText",ExpressionUUID->
  "387206b6-780d-422a-bd78-9ee6b54770d7"],
 " row\[CloseCurlyDoubleQuote]."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"f5634acf-c28f-4fa8-86ef-8bab832b889c"],

Cell[TextData[{
 "Find totals for all rows, then pick out the total for the \
\[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"1a7becb0-11dd-408c-9f5b-0f4499de566e"],
 " row\[CloseCurlyDoubleQuote]:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ca00f8f2-e235-4e6e-b852-c97a2cca05e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "[", 
   RowBox[{"All", ",", "Total"}], "]"}], "[", "\"\<b\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"b9f883fa-0a03-4600-88b2-d9e266c5a0ef"],

Cell[BoxData["22"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"6ae4ddaf-fa5f-42aa-8c9b-170c7dffc2fc"]
}, Open  ]],

Cell["It\[CloseCurlyQuote]s equivalent to this:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bbaa57d0-8c22-4705-9ec9-d4527960877e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"\"\<b\>\"", ",", "Total"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"68a6c3fe-496d-4c95-928c-9b16fa270f98"],

Cell[BoxData["22"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"a1070862-60e9-4ffb-9485-85f3989e992e"]
}, Open  ]],

Cell[TextData[{
 "Particularly when one\[CloseCurlyQuote]s dealing with large datasets, it\
\[CloseCurlyQuote]s common to want to select parts based on a criterion. The ",
 StyleBox["operator form",
  FontSlant->"Italic"],
 " of ",
 ButtonBox["Select",
  BaseStyle->"Link"],
 " provides a very convenient way to do this. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"9a3c31e7-e1eb-4cff-8a73-8f8f07590932"],

Cell["Select numbers greater than 5 from a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"3c31075a-9bf1-4a0d-ae07-d2f653fdd530"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "6", ",", "8", ",", "2", ",", "5", ",", "9", ",", 
     "7"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", ">", "5"}], "&"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"4b96ff64-d4fd-4212-9303-5e9cbe3b9dc0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "8", ",", "9", ",", "7"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"07ec3864-2369-4c6a-ad1a-446520bd1231"]
}, Open  ]],

Cell[TextData[{
 "Another way to get the same answer, using the operator form of ",
 ButtonBox["Select",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"be1be0b9-365c-4d5e-bb43-32b83d9ef231"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"#", ">", "5"}], "&"}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "3", ",", "6", ",", "8", ",", "2", ",", "5", ",", "9", ",", 
    "7"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"f0593e3d-bda8-46f9-8dbe-15c3ea6275d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "8", ",", "9", ",", "7"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"221b8342-9541-460b-9f12-66c43172dac8"]
}, Open  ]],

Cell[TextData[{
 "The operator form of ",
 ButtonBox["Select",
  BaseStyle->"Link"],
 " is a function which can be applied to actually perform the ",
 ButtonBox["Select",
  BaseStyle->"Link"],
 " operation."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fbb6df0d-6369-4f24-92c2-8ce26ae9d5d8"],

Cell[TextData[{
 "Make a dataset by selecting only rows whose \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "z"], "InlineCode",ExpressionUUID->"8aa4b12f-c004-4df9-8cc6-439c5a2b2542"],
 " column\[CloseCurlyDoubleQuote] is greater than 5:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c99eafed-da95-4c25-a5cd-bff7cd44c1fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"#z", ">", "5"}], "&"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"a37a2ddb-7432-4933-9b34-fb897ca1bf4c"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 1, "Length" -> 1, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 1], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[<|{All, 
             TypeSystem`PackageScope`KeyDummy[1]} -> 1, {All, "x"} -> 
           1, {All, "y"} -> 1, {All, "z"} -> 1|>, 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             
             TypeSystem`PackageScope`RowShape[<|
              "x" -> TypeSystem`PackageScope`AtomShape[34], "y" -> 
               TypeSystem`PackageScope`AtomShape[34], "z" -> 
               TypeSystem`PackageScope`AtomShape[34]|>]]], 1, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[1722381316], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 1], "HandleQ" -> True, "RowTarget" -> 
        20, "Data" -> TypeSystem`PackageScope`CacheHandle[1722381316]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1313445835][{All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"x\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"x\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1313445835][{All, "x"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
                  GeneralUtilities`Slice[All, "x"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"y\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"y\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1313445835][{All, "y"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
                  GeneralUtilities`Slice[All, "y"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"z\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"z\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1313445835][{All, "z"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
                  GeneralUtilities`Slice[All, "z"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["b", 
                    Style[
                    "b", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1313445835][{
                    Key["b"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1313445835][
                   GeneralUtilities`Slice[
                    Key["b"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["5"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["10"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1313445835][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1313445835]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1313445835][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {155., {21.3837890625, 28.6162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"73fe2cde-6dbc-4000-89ea-a7d340fcf7af"]
}, Open  ]],

Cell["\<\
For each row, select columns whose values are greater than 5, leaving a \
ragged structure:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"22a282d3-918f-44c6-85a6-fc8e8d10e13b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"All", ",", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"#", ">", "5"}], "&"}], "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"04b9370c-ac5b-45cd-ac51-489e0feff0c4"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 2, "Length" -> 2, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Assoc[
           TypeSystem`Atom[String], 
           TypeSystem`Atom[Integer], TypeSystem`AnyLength], 2], 
        "DisplayedColumnCount" -> 20, "DataRowCount" -> 0, "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
            TypeSystem`PackageScope`Limited[
             TypeSystem`PackageScope`ColumnShape[
              TypeSystem`PackageScope`KeyValueShape[
               TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
               TypeSystem`PackageScope`AtomShape[34]]], 2, {All}]]], 2, {}], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[2060372795], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Assoc[
           TypeSystem`Atom[String], 
           TypeSystem`Atom[Integer], TypeSystem`AnyLength], 2], "HandleQ" -> 
        True, "Meta" -> {}, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[2060372795]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["a", 
                    Style[
                    "a", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 431110065][{
                    
                    Key["a"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
                   GeneralUtilities`Slice[
                    Key["a"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 431110065][{
                    
                    Key["a"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
                 
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["b", 
                    Style[
                    "b", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 431110065][{
                    
                    Key["b"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
                   GeneralUtilities`Slice[
                    Key["b"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["y", 
                    Style[
                    "y", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 431110065][{
                    
                    Key["b"], 
                    Key["y"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
                   GeneralUtilities`Slice[
                    Key["b"], 
                    Key["y"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["10"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
                 
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {SpanFromAbove, 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["z", 
                    Style[
                    "z", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 431110065][{
                    
                    Key["b"], 
                    Key["z"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
                   GeneralUtilities`Slice[
                    Key["b"], 
                    Key["z"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
                 
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 431110065][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 431110065]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[431110065][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {110., {42.3837890625, 49.6162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[18]=",ExpressionUUID->"1fb61b46-4f77-4baf-ade5-fd71f64a4630"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Normal",
  BaseStyle->"Link"],
 " turns the dataset into an ordinary association of associations: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:274", "i:11"},ExpressionUUID->"7a9974ef-4edd-4036-b26e-5e5326320fc4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"a291396a-348a-4b03-821b-f97d0a40e888"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"\<\"a\"\>", "\[Rule]", 
    RowBox[{"\[LeftAssociation]", "\[RightAssociation]"}]}], ",", 
   RowBox[{"\<\"b\"\>", "\[Rule]", 
    RowBox[{"\[LeftAssociation]", 
     RowBox[{
      RowBox[{"\<\"y\"\>", "\[Rule]", "10"}], ",", 
      RowBox[{"\<\"z\"\>", "\[Rule]", "7"}]}], "\[RightAssociation]"}]}]}], 
  "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"3c869a03-8bb0-4b15-a17b-190cc7e5169f"]
}, Open  ]],

Cell["Many Wolfram Language functions have operator forms. ", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9bb61a47-28f5-4dbd-b368-722c268fa869"],

Cell["\<\
Sort according to the values of a function applied to each element:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"dd1c88f7-6239-480c-abd7-4647da5e97d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "6", ",", "8", ",", "2", ",", "5", ",", "9", ",", 
     "7"}], "}"}], ",", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "#", "]"}], ",", "#", ",", 
      RowBox[{"10", "+", "#"}]}], "]"}], "&"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"79054081-f344-4c57-a3b5-27e574c16292"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "6", ",", "8", ",", "1", ",", "3", ",", "5", ",", "7", ",", "9"}],
   "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"83885077-e72e-4161-8dd3-ef9a9d679c3e"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["SortBy",
  BaseStyle->"Link"],
 " has an operator form:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4460d28a-a035-4f8b-ab9e-268cd96f57aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SortBy", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "#", "]"}], ",", "#", ",", 
      RowBox[{"10", "+", "#"}]}], "]"}], "&"}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "3", ",", "6", ",", "8", ",", "2", ",", "5", ",", "9", ",", 
    "7"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"374cc508-4b89-4c76-a7b3-6e925b2363ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "6", ",", "8", ",", "1", ",", "3", ",", "5", ",", "7", ",", "9"}],
   "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"82f83f63-8a38-416f-b570-00d5ff4c93e2"]
}, Open  ]],

Cell[TextData[{
 "Sort rows according to the value of the difference of the ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"4297f69b-8062-4b8b-b1f3-78bfc35528ec"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"03f24878-b5da-4e52-bafd-51724309a209"],
 " columns:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d71dbce1-aabc-411e-aaf3-262127c8e5eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"SortBy", "[", 
   RowBox[{
    RowBox[{"#x", "-", "#y"}], "&"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"6c29b2ad-f13e-4df3-8959-bc7eeb9bf680"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[<|{All, 
             TypeSystem`PackageScope`KeyDummy[2]} -> 1, {All, "x"} -> 
           1, {All, "y"} -> 1, {All, "z"} -> 1|>, 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             
             TypeSystem`PackageScope`RowShape[<|
              "x" -> TypeSystem`PackageScope`AtomShape[34], "y" -> 
               TypeSystem`PackageScope`AtomShape[34], "z" -> 
               TypeSystem`PackageScope`AtomShape[34]|>]]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[502204778], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 2], "HandleQ" -> True, "RowTarget" -> 
        20, "Data" -> TypeSystem`PackageScope`CacheHandle[502204778]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336][{
                    All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"x\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"x\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336][{
                    All, "x"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[All, "x"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"y\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"y\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336][{
                    All, "y"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[All, "y"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"z\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"z\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336][{
                    All, "z"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[All, "z"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["b", 
                    Style[
                    "b", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336][{
                    
                    Key["b"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                   GeneralUtilities`Slice[
                    Key["b"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["5"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["10"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["a", 
                    Style[
                    "a", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336][{
                    
                    Key["a"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                   GeneralUtilities`Slice[
                    Key["a"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["3"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
                 
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 233387336]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[233387336][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {155., {33.8837890625, 41.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"d4541ada-cfca-4fad-93e0-07576c99f2fb"]
}, Open  ]],

Cell["Sort the rows, and find the total of all columns:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"101c3c5e-6bc7-4785-af73-860502a49ca9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{
     RowBox[{"#x", "-", "#y"}], "&"}], "]"}], ",", "Total"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"bea25a9f-069c-4924-b6ae-ef2b23caf925"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
            TypeSystem`PackageScope`AtomShape[34]]], 2, {}], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[706579405], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 2], "HandleQ" -> True, "RowTarget" -> 20, 
        "Data" -> TypeSystem`PackageScope`CacheHandle[706579405]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                "b", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["22"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1263130532][
                  GeneralUtilities`Slice[
                   Key["b"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                "a", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["6"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1263130532][
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1263130532][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1263130532]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1263130532][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1263130532][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {75., {21.8837890625, 29.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"d3904cf5-7d92-4898-8093-3f390f3c97d1"]
}, Open  ]],

Cell["\<\
Sometimes you want to apply a function to each element in the dataset.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"383fd40f-0080-444c-850c-99bf1c2916e6"],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"5305d34b-515f-43e6-b6d2-d910c8c0549f"],
 " to each element in the dataset:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bcb5e980-e0bf-4395-83fc-92ba49e0e8b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"All", ",", "All", ",", "f"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"6a01e8e9-aa59-4271-8f5b-77e2fc4b0e5d"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 2, "Length" -> 2, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{"x", "y", "z"}, {
           TypeSystem`AnyType, TypeSystem`AnyType, TypeSystem`AnyType}], 2], 
        "DisplayedColumnCount" -> 20, "DataRowCount" -> 0, "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[<|{All, 
             TypeSystem`PackageScope`KeyDummy[3]} -> 1, {All, "x"} -> 
           1, {All, "y"} -> 1, {All, "z"} -> 1|>, 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             
             TypeSystem`PackageScope`RowShape[<|
              "x" -> TypeSystem`PackageScope`UnknownShape, "y" -> 
               TypeSystem`PackageScope`UnknownShape, "z" -> 
               TypeSystem`PackageScope`UnknownShape|>]]], 2, {}]], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[2099161119], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{"x", "y", "z"}, {
           TypeSystem`AnyType, TypeSystem`AnyType, TypeSystem`AnyType}], 2], 
        "HandleQ" -> True, "Meta" -> {}, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[2099161119]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1931139439][{All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"x\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"x\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1931139439][{All, "x"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[All, "x"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"y\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"y\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1931139439][{All, "y"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[All, "y"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"z\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"z\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1931139439][{All, "z"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[All, "z"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["a", 
                    Style[
                    "a", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1931139439][{
                    Key["a"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1931139439][
                   GeneralUtilities`Slice[
                    Key["a"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", "1", "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["x"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", "2", "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", "3", "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[
                   Key["a"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["b", 
                    Style[
                    "b", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1931139439][{
                    Key["b"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1931139439][
                   GeneralUtilities`Slice[
                    Key["b"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", "5", "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["x"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", "10", "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["y"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"f", "[", "7", "]"}], FontFamily -> 
                   "Source Code Pro", FontSize -> 13, ShowStringCharacters -> 
                   True]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
                  GeneralUtilities`Slice[
                   Key["b"], 
                   Key["z"]]], "Mouse"], ImageSize -> {{60, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1931139439][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1931139439]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1931139439][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[
         TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {233., {41.8837890625, 49.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"575c4017-560e-4d65-ab52-416ab941eb1c"]
}, Open  ]],

Cell["Sort\[NonBreakingSpace]the\[NonBreakingSpace]rows\[NonBreakingSpace]\
before\[NonBreakingSpace]totaling\[NonBreakingSpace]the\[NonBreakingSpace]\
squares\[NonBreakingSpace]of\[NonBreakingSpace]their\[NonBreakingSpace]\
elements:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b737402f-b993-4294-8047-b63f52605ea6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{
     RowBox[{"#x", "-", "#y"}], "&"}], "]"}], ",", "Total", ",", 
   RowBox[{
    RowBox[{"#", "^", "2"}], "&"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"858aee17-f9cb-41a5-b8dc-0bbb54bff195"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Rational], 2], "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
            TypeSystem`PackageScope`AtomShape[34]]], 2, {}], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1847705540], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Rational], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[1847705540]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                "b", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["174"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[480835238][
                 
                  GeneralUtilities`Slice[
                   Key["b"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                "a", ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["14"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[480835238][
                 
                  GeneralUtilities`Slice[
                   Key["a"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            Module[{
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 480835238][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 480835238]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[480835238][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[480835238][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {75., {21.8837890625, 29.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[25]=",ExpressionUUID->"770d3bbc-821f-4b0e-a712-61d1e54d3931"]
}, Open  ]],

Cell[TextData[{
 "Datasets can contain arbitrary mixtures of lists and associations. Here\
\[CloseCurlyQuote]s a dataset that can be thought of as a ",
 StyleBox["list of records",
  FontSlant->"Italic"],
 " with named ",
 StyleBox["fields",
  FontSlant->"Italic"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:275", "i:13"},ExpressionUUID->"40208f57-b4ad-441c-8d4a-56eb73bab303"],

Cell["A dataset formed from a list of associations:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5c7c4466-4cec-4e9b-8cad-6bd7a4f22537"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dataset", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[LeftAssociation]", 
     RowBox[{
      RowBox[{"\"\<x\>\"", "\[Rule]", "2"}], ",", 
      RowBox[{"\"\<y\>\"", "\[Rule]", "4"}], ",", 
      RowBox[{"\"\<z\>\"", "\[Rule]", "6"}]}], "\[RightAssociation]"}], ",", 
    RowBox[{"\[LeftAssociation]", 
     RowBox[{
      RowBox[{"\"\<x\>\"", "\[Rule]", "11"}], ",", 
      RowBox[{"\"\<y\>\"", "\[Rule]", "7"}], ",", 
      RowBox[{"\"\<z\>\"", "\[Rule]", "1"}]}], "\[RightAssociation]"}]}], 
   "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"6596bced-f733-453e-86b7-47fa6f11ac33"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Vector[
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[<|{All, "x"} -> 1, {All, "y"} -> 
           1, {All, "z"} -> 1|>, 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            
            TypeSystem`PackageScope`RowShape[<|
             "x" -> TypeSystem`PackageScope`AtomShape[34], "y" -> 
              TypeSystem`PackageScope`AtomShape[34], "z" -> 
              TypeSystem`PackageScope`AtomShape[34]|>]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[1861868257], 
        "Type" -> TypeSystem`Vector[
          TypeSystem`Struct[{"x", "y", "z"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer]}], 2], "HandleQ" -> True, "RowTarget" -> 
        20, "Data" -> TypeSystem`PackageScope`CacheHandle[1861868257]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"x\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"x\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 784006071][{
                    All, "x"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[All, "x"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"y\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"y\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 784006071][{
                    All, "y"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[All, "y"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"z\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"z\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 784006071][{
                    All, "z"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[All, "z"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}]}, {
               Pane[
                Annotation[
                 RawBoxes["2"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[1, 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["4"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[1, 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["6"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[1, 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Pane[
                Annotation[
                 RawBoxes["11"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[2, 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[2, 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
                 
                  GeneralUtilities`Slice[2, 
                   Key["z"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 784006071][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 784006071]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[784006071][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {120., {33.8837890625, 41.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[26]=",ExpressionUUID->"9ec6f73a-b1ff-477b-8d60-9fab601b9775"]
}, Open  ]],

Cell["It\[CloseCurlyQuote]s OK for entries to be missing:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"1673015e-1ff0-4429-9847-aad505b04b13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dataset", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[LeftAssociation]", 
     RowBox[{
      RowBox[{"\"\<x\>\"", "\[Rule]", "2"}], ",", 
      RowBox[{"\"\<y\>\"", "\[Rule]", "4"}], ",", 
      RowBox[{"\"\<z\>\"", "\[Rule]", "6"}]}], "\[RightAssociation]"}], ",", 
    RowBox[{"\[LeftAssociation]", 
     RowBox[{
      RowBox[{"\"\<x\>\"", "\[Rule]", "11"}], ",", 
      RowBox[{"\"\<y\>\"", "\[Rule]", "7"}]}], "\[RightAssociation]"}]}], 
   "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[27]:=",ExpressionUUID->"4908e7a3-5d48-466e-96e6-f9ef222ad2b6"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Vector[
          TypeSystem`Assoc[TypeSystem`AnyType, 
           TypeSystem`Atom[Integer], TypeSystem`AnyLength], 2], "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`Limited[
            TypeSystem`PackageScope`ColumnShape[
             TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`UnknownShape, 
              TypeSystem`PackageScope`AtomShape[34]]], 2, {All}]], 2, {}], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[2014798214], 
        "Type" -> TypeSystem`Vector[
          TypeSystem`Assoc[TypeSystem`AnyType, 
           TypeSystem`Atom[Integer], TypeSystem`AnyLength], 2], "HandleQ" -> 
        True, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[2014798214]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Pane[
                  Annotation["x", 
                   TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                   765344279][
                    GeneralUtilities`Slice[1, 
                    Key["x"]]], "Mouse"], 
                  ImageSize -> {{9.600000000000001, Full}, Automatic}, 
                  Alignment -> {Left, Baseline}], 
                 ImageSize -> {{60, Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[765344279][
                 
                  GeneralUtilities`Slice[1, 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Pane[
                  Annotation["y", 
                   TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                   765344279][
                    GeneralUtilities`Slice[1, 
                    Key["y"]]], "Mouse"], 
                  ImageSize -> {{9.600000000000001, Full}, Automatic}, 
                  Alignment -> {Left, Baseline}], 
                 ImageSize -> {{60, Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["4"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[765344279][
                 
                  GeneralUtilities`Slice[1, 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["3 total \:203a ", 
                    Style[
                    "3 total \:203a ", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 765344279][{
                    1}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[765344279][
                 
                  GeneralUtilities`Slice[1]], "Mouse"], BaseStyle -> {{
                   RGBColor[
                   0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274], 8}, ContextMenu -> {
                    MenuItem["Show 1 more row at this level", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 765344279}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    1]& , {All}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 more rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 765344279}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    5]& , {All}]], MenuEvaluator -> Automatic], Delimiter, 
                    MenuItem["Show 1 fewer row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 765344279}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -1]& \
, {All}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 fewer rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 765344279}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -5]& \
, {All}]], MenuEvaluator -> Automatic]}}, Alignment -> {Center, Baseline}, 
                Background -> GrayLevel[0.98]], SpanFromLeft}, {
               Item[
                Pane[
                 Pane[
                  Annotation["x", 
                   TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                   765344279][
                    GeneralUtilities`Slice[2, 
                    Key["x"]]], "Mouse"], 
                  ImageSize -> {{9.600000000000001, Full}, Automatic}, 
                  Alignment -> {Left, Baseline}], 
                 ImageSize -> {{60, Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["11"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[765344279][
                 
                  GeneralUtilities`Slice[2, 
                   Key["x"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Pane[
                  Annotation["y", 
                   TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                   765344279][
                    GeneralUtilities`Slice[2, 
                    Key["y"]]], "Mouse"], 
                  ImageSize -> {{9.600000000000001, Full}, Automatic}, 
                  Alignment -> {Left, Baseline}], 
                 ImageSize -> {{60, Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["7"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[765344279][
                 
                  GeneralUtilities`Slice[2, 
                   Key["y"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 765344279][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        Initialization :> If[
          Not[$CloudEvaluation], 
          TypeSystem`NestedGrid`PackagePrivate`attachScrollbar[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$]], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
         TypeSystem`PackageScope`Pathbar[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, 
          TypeSystem`NestedGrid`PackagePrivate`updateState[
          TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 765344279]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[765344279][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[765344279][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$], 
         TypeSystem`NestedGrid`PackagePrivate`shiftRight[{
          TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
           TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`$state$$]], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {106., {60.8837890625, 68.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[27]=",ExpressionUUID->"4d7f304b-8ef7-40ee-b064-8007d65de96a"]
}, Open  ]],

Cell["\<\
Now that we\[CloseCurlyQuote]ve seen some simple examples, it\
\[CloseCurlyQuote]s time to look at something slightly more realistic. Let\
\[CloseCurlyQuote]s import a dataset giving properties of planets and moons. \
The dataset has a hierarchical structure, with each planet having a mass and \
radius of its own, and then also having a collection of moons, each of which \
have their own properties. This general structure is extremely common in \
practice (think students and grades, customers and orders, etc.).\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"e72747f4-ff88-4b09-9282-50deda522519"],

Cell["\<\
Get a hierarchical dataset of planets and moons from the cloud:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"66540b04-372e-4cf8-bdb7-d1aa63d22211"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "=", 
  RowBox[{
  "CloudGet", "[", "\"\<http://wolfr.am/7FxLgPm5\>\"", "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[28]:=",ExpressionUUID->"07665152-cccc-49a6-87ce-7bdfecd7bd58"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 8, "Length" -> 8, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"Mass", "Radius", "Moons"}, {
            TypeSystem`Atom[
             Quantity[1, "Kilograms"]], 
            TypeSystem`Atom[
             Quantity[1, "Kilometers"]], 
            TypeSystem`Assoc[
             TypeSystem`Atom[String], 
             TypeSystem`Struct[{"Mass", "Radius"}, {
               TypeSystem`Atom[
                Quantity[1, "Kilograms"]], 
               TypeSystem`Atom[
                Quantity[1, "Kilometers"]]}], TypeSystem`AnyLength]}], 8], 
        "DisplayedColumnCount" -> 20, "DataRowCount" -> 0, "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[<|{All, 
             TypeSystem`PackageScope`KeyDummy[5]} -> 1, {All, "Mass"} -> 
           1, {All, "Radius"} -> 1, {All, "Moons"} -> <|{All, "Moons", All, 
               TypeSystem`PackageScope`KeyDummy[4]} -> 
             1, {All, "Moons", All, "Mass"} -> 
             1, {All, "Moons", All, "Radius"} -> 1|>|>, 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[67.20000000000002], 
             
             TypeSystem`PackageScope`RowShape[<|
              "Mass" -> TypeSystem`PackageScope`AtomShape[75], "Radius" -> 
               TypeSystem`PackageScope`AtomShape[75], "Moons" -> 
               TypeSystem`PackageScope`Limited[
                 TypeSystem`PackageScope`ColumnShape[
                  TypeSystem`PackageScope`KeyValueShape[
                   TypeSystem`PackageScope`AtomShape[67.20000000000002], 
                   
                   TypeSystem`PackageScope`RowShape[<|
                    "Mass" -> TypeSystem`PackageScope`AtomShape[75], "Radius" -> 
                    TypeSystem`PackageScope`AtomShape[75]|>]]], 2, {
                 All, "Moons"}]|>]]], 8, {}]], "DataColumnCount" -> 0, 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[2051009035], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"Mass", "Radius", "Moons"}, {
            TypeSystem`Atom[
             Quantity[1, "Kilograms"]], 
            TypeSystem`Atom[
             Quantity[1, "Kilometers"]], 
            TypeSystem`Assoc[
             TypeSystem`Atom[String], 
             TypeSystem`Struct[{"Mass", "Radius"}, {
               TypeSystem`Atom[
                Quantity[1, "Kilograms"]], 
               TypeSystem`Atom[
                Quantity[1, "Kilometers"]]}], TypeSystem`AnyLength]}], 8], 
        "HandleQ" -> True, "Meta" -> {}, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[2051009035]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Mass\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Mass\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    All, "Mass"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[All, "Mass"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Radius\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Radius\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    All, "Radius"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[All, "Radius"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Moons\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Moons\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    All, "Moons"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[All, "Moons"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Center, Baseline}], 
               SpanFromLeft, SpanFromLeft}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    All, "Moons", All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[All, "Moons", All, Keys]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Mass\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Mass\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    All, "Moons", All, "Mass"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[All, "Moons", All, "Mass"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Radius\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Radius\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    All, "Moons", All, "Radius"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[All, "Moons", All, "Radius"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mercury", 
                    Style[
                    "Mercury", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Mercury"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Mercury"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"3.30104`6.*^23", "\"kg\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mercury"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"2439.7`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mercury"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Mercury"], 
                    Key["Moons"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mercury"], 
                   Key["Moons"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Venus", 
                    Style[
                    "Venus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Venus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Venus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"4.867320000000000000000001`6.*^24", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Venus"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6051.85`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Venus"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Venus"], 
                    Key["Moons"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Venus"], 
                   Key["Moons"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Earth", 
                    Style[
                    "Earth", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Earth"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Earth"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"5.9721986`8.*^24", "\"kg\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Earth"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6371.0088`8", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Earth"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Moon", 
                    Style[
                    "Moon", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Earth"], 
                    Key["Moons"], 
                    Key["Moon"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Earth"], 
                    Key["Moons"], 
                    Key["Moon"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "7.3459006322855173653772`4.995678626217362*^22", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Earth"], 
                   Key["Moons"], 
                   Key["Moon"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"1737.5`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Earth"], 
                   Key["Moons"], 
                   Key["Moon"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mars", 
                    Style[
                    "Mars", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Mars"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Mars"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6.41693`6.*^23", "\"kg\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"3385.595`4.29804285290057", "\"km\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Deimos", 
                    Style[
                    "Deimos", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Mars"], 
                    Key["Moons"], 
                    Key["Deimos"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Mars"], 
                    Key["Moons"], 
                    Key["Deimos"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.468340774924336`1.9995659225206786*^15", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"], 
                   Key["Moons"], 
                   Key["Deimos"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6.2`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"], 
                   Key["Moons"], 
                   Key["Deimos"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Phobos", 
                    Style[
                    "Phobos", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Mars"], 
                    Key["Moons"], 
                    Key["Phobos"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Mars"], 
                    Key["Moons"], 
                    Key["Phobos"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.0724880884600402`3.9586073148417724*^16", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"], 
                   Key["Moons"], 
                   Key["Phobos"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"11.1`3", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"], 
                   Key["Moons"], 
                   Key["Phobos"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"1.89813`6.*^27", "\"kg\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"69911", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Adrastea", 
                    Style[
                    "Adrastea", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Jupiter"], 
                    Key["Moons"], 
                    Key["Adrastea"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Jupiter"], 
                    Key["Moons"], 
                    Key["Adrastea"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "7.491534565940487`0.9999565727231415*^15", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Moons"], 
                   Key["Adrastea"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"8.2`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Moons"], 
                   Key["Adrastea"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Aitne", 
                    Style[
                    "Aitne", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Jupiter"], 
                    Key["Moons"], 
                    Key["Aitne"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Jupiter"], 
                    Key["Moons"], 
                    Key["Aitne"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "4.4949207395643`0.9999565727231415*^13", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Moons"], 
                   Key["Aitne"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"1.5`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Moons"], 
                   Key["Aitne"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["67 total \:203a ", 
                    Style[
                    "67 total \:203a ", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Jupiter"], 
                    Key["Moons"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Moons"]]], "Mouse"], BaseStyle -> {{
                   RGBColor[
                   0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274], 8}, ContextMenu -> {
                    MenuItem["Show 1 more row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    1]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 more rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    5]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    Delimiter, 
                    MenuItem["Show 1 fewer row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -1]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 fewer rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -5]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic]}}, 
                Alignment -> {Center, Baseline}, Background -> 
                GrayLevel[0.98]], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"5.68319`6.*^26", "\"kg\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"57316.`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Aegaeon", 
                    Style[
                    "Aegaeon", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Saturn"], 
                    Key["Moons"], 
                    Key["Aegaeon"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Saturn"], 
                    Key["Moons"], 
                    Key["Aegaeon"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 Item[
                 "\[LongDash]", Alignment -> {Left, Baseline}, BaseStyle -> 
                  GrayLevel[0.85]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Moons"], 
                   Key["Aegaeon"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"0.25`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Moons"], 
                   Key["Aegaeon"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Aegir", 
                    Style[
                    "Aegir", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Saturn"], 
                    Key["Moons"], 
                    Key["Aegir"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Saturn"], 
                    Key["Moons"], 
                    Key["Aegir"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 Item[
                 "\[LongDash]", Alignment -> {Left, Baseline}, BaseStyle -> 
                  GrayLevel[0.85]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Moons"], 
                   Key["Aegir"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"3.`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Moons"], 
                   Key["Aegir"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["62 total \:203a ", 
                    Style[
                    "62 total \:203a ", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Saturn"], 
                    Key["Moons"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Moons"]]], "Mouse"], BaseStyle -> {{
                   RGBColor[
                   0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274], 8}, ContextMenu -> {
                    MenuItem["Show 1 more row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    1]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 more rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    5]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    Delimiter, 
                    MenuItem["Show 1 fewer row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -1]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 fewer rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -5]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic]}}, 
                Alignment -> {Center, Baseline}, Background -> 
                GrayLevel[0.98]], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"8.68103`6.*^25", "\"kg\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"25266.`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Ariel", 
                    Style[
                    "Ariel", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Uranus"], 
                    Key["Moons"], 
                    Key["Ariel"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Uranus"], 
                    Key["Moons"], 
                    Key["Ariel"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.352971142608851997243`2.9956786262173587*^21", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"], 
                   Key["Moons"], 
                   Key["Ariel"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"578.9`4", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"], 
                   Key["Moons"], 
                   Key["Ariel"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Belinda", 
                    Style[
                    "Belinda", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Uranus"], 
                    Key["Moons"], 
                    Key["Belinda"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Uranus"], 
                    Key["Moons"], 
                    Key["Belinda"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "3.56597045338767194`2.995678626217367*^17", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"], 
                   Key["Moons"], 
                   Key["Belinda"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"40.3`3", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"], 
                   Key["Moons"], 
                   Key["Belinda"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["27 total \:203a ", 
                    Style[
                    "27 total \:203a ", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Uranus"], 
                    Key["Moons"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"], 
                   Key["Moons"]]], "Mouse"], BaseStyle -> {{
                   RGBColor[
                   0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274], 8}, ContextMenu -> {
                    MenuItem["Show 1 more row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    1]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 more rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    5]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    Delimiter, 
                    MenuItem["Show 1 fewer row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -1]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 fewer rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -5]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic]}}, 
                Alignment -> {Center, Baseline}, Background -> 
                GrayLevel[0.98]], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"1.0241`6.*^26", "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"24552.5`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Despina", 
                    Style[
                    "Despina", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Neptune"], 
                    Key["Moons"], 
                    Key["Despina"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Neptune"], 
                    Key["Moons"], 
                    Key["Despina"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "2.09762967846333643`1.9995659225206872*^18", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"], 
                   Key["Moons"], 
                   Key["Despina"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"75.`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"], 
                   Key["Moons"], 
                   Key["Despina"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Galatea", 
                    Style[
                    "Galatea", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Neptune"], 
                    Key["Moons"], 
                    Key["Galatea"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                   GeneralUtilities`Slice[
                    Key["Neptune"], 
                    Key["Moons"], 
                    Key["Galatea"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "3.745767282970243625`1.9995659225206872*^18", "\"kg\""}],
                    FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"], 
                   Key["Moons"], 
                   Key["Galatea"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"88.`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"], 
                   Key["Moons"], 
                   Key["Galatea"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
              SpanFromAbove, SpanFromAbove, SpanFromAbove, 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["14 total \:203a ", 
                    Style[
                    "14 total \:203a ", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][{
                    
                    Key["Neptune"], 
                    Key["Moons"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"], 
                   Key["Moons"]]], "Mouse"], BaseStyle -> {{
                   RGBColor[
                   0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274], 8}, ContextMenu -> {
                    MenuItem["Show 1 more row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    1]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 more rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    5]& , {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    Delimiter, 
                    MenuItem["Show 1 fewer row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -1]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 fewer rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503}, 
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, -5]& \
, {All, "Moons"}]], MenuEvaluator -> Automatic]}}, 
                Alignment -> {Center, Baseline}, Background -> 
                GrayLevel[0.98]], SpanFromLeft, SpanFromLeft}}, 
             BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            Module[{
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 838284503]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[838284503][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {551., {239.3837890625, 246.6162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[28]=",ExpressionUUID->"44ae734a-bf3f-4f73-811d-5734568ffdfb"]
}, Open  ]],

Cell["Find the radii of all the planets:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:276",ExpressionUUID->"21ce5bca-2c6b-431e-81fc-3288adffb794"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{"All", ",", "\"\<Radius\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[29]:=",ExpressionUUID->"4b28712c-d1c2-470b-b961-7c8ac47ec7e6"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 8, "Length" -> 8, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilometers"]], 8], "DisplayedColumnCount" -> 20, 
        "DataRowCount" -> 0, "Shape" -> TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[67.20000000000002], 
            TypeSystem`PackageScope`AtomShape[75]]], 8, {}], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[326621149], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilometers"]], 8], "HandleQ" -> True, "Meta" -> {}, 
        "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[326621149]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mercury", 
                    Style[
                    "Mercury", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Mercury"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Mercury"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"2439.7`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Mercury"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Venus", 
                    Style[
                    "Venus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Venus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Venus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6051.85`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Venus"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Earth", 
                    Style[
                    "Earth", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Earth"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Earth"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6371.0088`8", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Earth"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mars", 
                    Style[
                    "Mars", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Mars"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Mars"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"3385.595`4.29804285290057", "\"km\""}], FontColor -> 
                   RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Mars"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"69911", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Jupiter"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"57316.`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Saturn"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"25266.`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Uranus"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][{
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1843539671][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"24552.5`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
                  GeneralUtilities`Slice[
                   Key["Neptune"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1843539671]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1843539671][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[
         TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {166., {104.8837890625, 112.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[29]=",ExpressionUUID->"f989d4a6-2464-47de-ad99-ebec986c4b3b"]
}, Open  ]],

Cell["Make a bar chart of planet radii:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"55da807e-9a64-47c6-a39c-24654c6d0bc2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"planets", "[", 
    RowBox[{"All", ",", "\"\<Radius\>\""}], "]"}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[30]:=",ExpressionUUID->"820cd207-0446-4a41-a0e8-fdd0be129840"],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], 
    PointBox[{{0.39075018208302986`, 0.}, {8.451201747997086, 0.}}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
     Thickness[Small]}], 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5487982520029133, 0.}, {1.4512017479970867`, 
            2439.7}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{35.648029800155356`, 58.40452253007466}, {
           48.94630857844055, 53.68303567122818}}],
         StatusArea[#, 2439.7`5.]& ,
         TagBoxNote->"2439.7`5."],
        StyleBox["2439.7`5.", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2439.7`5., {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.5487982520029133`, 0.}, {2.4512017479970867`, 
            6051.85}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{60.311600839848005`, 83.06809356976731}, {
           42.673531692670636`, 53.68303567122818}}],
         StatusArea[#, 6051.85`5.]& ,
         TagBoxNote->"6051.85`5."],
        StyleBox["6051.85`5.", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6051.85`5., {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5487982520029133`, 0.}, {3.4512017479970867`, 
            6371.0088}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{84.97517187954065, 107.73166460945995`}, {
           42.11928783692542, 53.68303567122818}}],
         StatusArea[#, 6371.0088`8.]& ,
         TagBoxNote->"6371.0088`8."],
        StyleBox["6371.0088`8.", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[6371.0088`8., {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.5487982520029133`, 0.}, {4.451201747997087, 
            3385.595}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{109.6387429192333, 132.3952356491526}, {
           47.30368900495514, 53.68303567122818}}],
         StatusArea[#, 3385.595`4.29804285290057]& ,
         TagBoxNote->"3385.595`4.29804285290057"],
        StyleBox["3385.595`4.29804285290057", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[3385.595`4.29804285290057, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{4.548798252002913, 0.}, {5.451201747997087, 69911.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{134.30231395892596`, 
           157.05880668884527`}, {-68.22280430248838, 53.68303567122818}}],
         StatusArea[#, 69911]& ,
         TagBoxNote->"69911"],
        StyleBox["69911", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[69911, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.548798252002913, 0.}, {6.451201747997087, 57316.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{158.9658849986186, 
           181.7223777285379}, {-46.35061602783975, 53.68303567122818}}],
         StatusArea[#, 57316.`5.]& ,
         TagBoxNote->"57316.`5."],
        StyleBox["57316.`5.", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[57316.`5., {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.548798252002913, 0.}, {7.451201747997087, 25266.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{183.62945603831125`, 206.38594876823055`}, {
           9.306679264140278, 53.68303567122818}}],
         StatusArea[#, 25266.`5.]& ,
         TagBoxNote->"25266.`5."],
        StyleBox["25266.`5.", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[25266.`5., {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.548798252002913, 0.}, {8.451201747997086, 24552.5},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{208.29302707800392`, 231.0495198079232}, {
           10.545727008003858`, 53.68303567122818}}],
         StatusArea[#, 24552.5`5.]& ,
         TagBoxNote->"24552.5`5."],
        StyleBox["24552.5`5.", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[24552.5`5., {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, {}, {}, 
   StyleBox[{
     {Thickness[Tiny], 
      LineBox[{{0.39075018208302986`, 0.}, {8.612410779315367, 0.}}], 
      StyleBox[{}, "GraphicsLabel",
       StripOnInput->False]}, 
     StyleBox[{
       {Thickness[Tiny], 
        LineBox[{{0.5487982520029133, 0.}, 
          Offset[{-1.102182119232618*^-15, -6.}, {0.5487982520029133, 0.}]}], 
        LineBox[{{8.451201747997086, 0.}, 
          Offset[{-1.102182119232618*^-15, -6.}, {8.451201747997086, 
           0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {
          LineBox[{{1.4512017479970867`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {1.4512017479970867`, 
             0.}]}], LineBox[{{1.5487982520029133`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {1.5487982520029133`, 
             0.}]}], LineBox[{{2.4512017479970867`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {2.4512017479970867`, 
             0.}]}], LineBox[{{2.5487982520029133`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {2.5487982520029133`, 
             0.}]}], LineBox[{{3.4512017479970867`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {3.4512017479970867`, 
             0.}]}], LineBox[{{3.5487982520029133`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {3.5487982520029133`, 
             0.}]}], LineBox[{{4.451201747997087, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {4.451201747997087, 0.}]}],
           LineBox[{{4.548798252002913, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {4.548798252002913, 0.}]}],
           LineBox[{{5.451201747997087, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {5.451201747997087, 0.}]}],
           LineBox[{{5.548798252002913, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {5.548798252002913, 0.}]}],
           LineBox[{{6.451201747997087, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {6.451201747997087, 0.}]}],
           LineBox[{{6.548798252002913, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {6.548798252002913, 0.}]}],
           LineBox[{{7.451201747997087, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {7.451201747997087, 0.}]}],
           LineBox[{{7.548798252002913, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {7.548798252002913, 
             0.}]}]}, {}}}, 
       StyleBox[
        {Thickness[Tiny], 
         InsetBox["\<\"Mercury\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"Venus\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"Earth\"\>", Offset[{0., -2.}, {3., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"Mars\"\>", Offset[{0., -2.}, {4., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"Jupiter\"\>", Offset[{0., -2.}, {5., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"Saturn\"\>", Offset[{0., -2.}, {6., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"Uranus\"\>", Offset[{0., -2.}, {7., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"Neptune\"\>", 
          Offset[{0., -2.}, {7.999999999999999, 0.}], {0, 1}, Automatic, {1, 
          0}]}, "GraphicsLabel",
        StripOnInput->False]}, "GraphicsTicks",
      StripOnInput->False]}, "GraphicsAxes",
    StripOnInput->False,
    Antialiasing->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.39075018208302986`, 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      1., 
       FormBox["\"Mercury\"", TraditionalForm], 0}, {2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      2., 
       FormBox["\"Venus\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      3., 
       FormBox["\"Earth\"", TraditionalForm], 0}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      4., 
       FormBox["\"Mars\"", TraditionalForm], 0}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      5., 
       FormBox["\"Jupiter\"", TraditionalForm], 0}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      6., 
       FormBox["\"Saturn\"", TraditionalForm], 0}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      7., 
       FormBox["\"Uranus\"", TraditionalForm], 0}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      8., 
       FormBox["\"Neptune\"", TraditionalForm], 0}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      2., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}, {
      8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0], Selectable -> False], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[30]=",ExpressionUUID->"aa52bc47-ceb0-4b71-8aef-79d9fc49eb8b"]
}, Open  ]],

Cell["\<\
If we ask about the moons of Mars, we get a dataset, which we can then query \
further.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"318512b2-c13e-4a6a-89b0-26cb81cfcf2c"],

Cell["Get a dataset about the moons of Mars:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c7bbc911-39a7-4ad1-b7e3-b601e336f493"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{"\"\<Mars\>\"", ",", "\"\<Moons\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[31]:=",ExpressionUUID->"b7e448f1-6ba3-4704-a109-233ed0b27f72"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 2, "Length" -> 2, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"Mass", "Radius"}, {
            TypeSystem`Atom[
             Quantity[1, "Kilograms"]], 
            TypeSystem`Atom[
             Quantity[1, "Kilometers"]]}], 2], "DisplayedColumnCount" -> 20, 
        "DataRowCount" -> 0, "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[<|{All, 
             TypeSystem`PackageScope`KeyDummy[6]} -> 1, {All, "Mass"} -> 
           1, {All, "Radius"} -> 1|>, 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[57.60000000000001], 
             
             TypeSystem`PackageScope`RowShape[<|
              "Mass" -> TypeSystem`PackageScope`AtomShape[75], "Radius" -> 
               TypeSystem`PackageScope`AtomShape[75]|>]]], 2, {}]], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1374581724], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Struct[{"Mass", "Radius"}, {
            TypeSystem`Atom[
             Quantity[1, "Kilograms"]], 
            TypeSystem`Atom[
             Quantity[1, "Kilometers"]]}], 2], "HandleQ" -> True, 
        "Meta" -> {}, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[1374581724]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1167970617][{All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Mass\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Mass\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1167970617][{All, "Mass"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
                  GeneralUtilities`Slice[All, "Mass"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Radius\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Radius\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1167970617][{All, "Radius"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
                  GeneralUtilities`Slice[All, "Radius"]], "Mouse"], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Deimos", 
                    Style[
                    "Deimos", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1167970617][{
                    Key["Deimos"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1167970617][
                   GeneralUtilities`Slice[
                    Key["Deimos"]]], "Mouse"], 
                 ImageSize -> {{57.60000000000001, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.468340774924336`1.9995659225206786*^15", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
                  GeneralUtilities`Slice[
                   Key["Deimos"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6.2`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
                  GeneralUtilities`Slice[
                   Key["Deimos"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Phobos", 
                    Style[
                    "Phobos", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1167970617][{
                    Key["Phobos"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1167970617][
                   GeneralUtilities`Slice[
                    Key["Phobos"]]], "Mouse"], 
                 ImageSize -> {{57.60000000000001, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.0724880884600402`3.9586073148417724*^16", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
                  GeneralUtilities`Slice[
                   Key["Phobos"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"11.1`3", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
                  GeneralUtilities`Slice[
                   Key["Phobos"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1167970617][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1167970617]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1167970617][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {241., {41.8837890625, 49.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[31]=",ExpressionUUID->"5753319e-0259-4ed8-897a-4a4ebd37583a"]
}, Open  ]],

Cell["\<\
\[OpenCurlyDoubleQuote]Drill down\[CloseCurlyDoubleQuote] to make a table of \
radii of all the moons of Mars:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1e5ada54-2dca-4ef7-bcc3-f2bc3e95e043"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{
  "\"\<Mars\>\"", ",", "\"\<Moons\>\"", ",", "All", ",", "\"\<Radius\>\""}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[32]:=",ExpressionUUID->"07e068e6-1864-41e4-bd2c-81dce05a6975"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 2, "Length" -> 2, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilometers"]], 2], "DisplayedColumnCount" -> 20, 
        "DataRowCount" -> 0, "Shape" -> TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[57.60000000000001], 
            TypeSystem`PackageScope`AtomShape[75]]], 2, {}], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1093356506], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilometers"]], 2], "HandleQ" -> True, "Meta" -> {}, 
        "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[1093356506]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Deimos", 
                    Style[
                    "Deimos", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 112950143][{
                    
                    Key["Deimos"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[112950143][
                   GeneralUtilities`Slice[
                    Key["Deimos"]]], "Mouse"], 
                 ImageSize -> {{57.60000000000001, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"6.2`2", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[112950143][
                 
                  GeneralUtilities`Slice[
                   Key["Deimos"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Phobos", 
                    Style[
                    "Phobos", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 112950143][{
                    
                    Key["Phobos"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[112950143][
                   GeneralUtilities`Slice[
                    Key["Phobos"]]], "Mouse"], 
                 ImageSize -> {{57.60000000000001, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"11.1`3", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[112950143][
                 
                  GeneralUtilities`Slice[
                   Key["Phobos"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 112950143][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 112950143]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[112950143][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[112950143][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {145., {29.8837890625, 37.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[32]=",ExpressionUUID->"598e5c1f-9717-49eb-a795-bda59d9775d4"]
}, Open  ]],

Cell["\<\
We can do computations about the moons of all planets. First, let\
\[CloseCurlyQuote]s just find out how many moons are listed for each planet.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:277",ExpressionUUID->"1cab299d-4cd7-4b9b-b6a1-f1bb4eaa9aca"],

Cell["\<\
Make a dataset of the number of moons listed for each planet:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"554baa61-72f4-4152-ab13-6d0daa5c56f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{"All", ",", "\"\<Moons\>\"", ",", "Length"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[33]:=",ExpressionUUID->"d863535f-09f4-479d-ad7c-3b577afb15c4"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 8, "Length" -> 8, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 8], "DisplayedColumnCount" -> 20, 
        "DataRowCount" -> 0, "Shape" -> TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[67.20000000000002], 
            TypeSystem`PackageScope`AtomShape[34]]], 8, {}], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[2005366144], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[Integer], 8], "HandleQ" -> True, "Meta" -> {}, 
        "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[2005366144]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mercury", 
                    Style[
                    "Mercury", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Mercury"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Mercury"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Mercury"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Venus", 
                    Style[
                    "Venus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Venus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Venus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Venus"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Earth", 
                    Style[
                    "Earth", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Earth"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Earth"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Earth"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mars", 
                    Style[
                    "Mars", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Mars"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Mars"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["67"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["62"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["27"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][{
                    
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["14"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 775140629]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[775140629][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {114., {104.8837890625, 112.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[33]=",ExpressionUUID->"6a944d5f-ada2-4283-9810-ae0953daa44b"]
}, Open  ]],

Cell["Find the total mass of all moons for each planet:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"926e8ca0-2852-4b21-8c6f-047f04f2014c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{"All", ",", "\"\<Moons\>\"", ",", "Total", ",", "\"\<Mass\>\""}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[34]:=",ExpressionUUID->"e5307dc1-da71-4de3-98ec-a1f8f63b31ad"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 8, "Length" -> 8, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilograms"]], 8], "DisplayedColumnCount" -> 20, 
        "DataRowCount" -> 0, "Shape" -> TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[67.20000000000002], 
            TypeSystem`PackageScope`AtomShape[75]]], 8, {}], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[715867184], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilograms"]], 8], "HandleQ" -> True, "Meta" -> {}, 
        "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[715867184]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mercury", 
                    Style[
                    "Mercury", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Mercury"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Mercury"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Mercury"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Venus", 
                    Style[
                    "Venus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Venus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Venus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Venus"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Earth", 
                    Style[
                    "Earth", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Earth"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Earth"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "7.3459006322855173653772`4.995678626217362*^22", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Earth"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mars", 
                    Style[
                    "Mars", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Mars"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Mars"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.2193221659524738`2.8853273743447083*^16", "\"kg\""}], 
                   FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Mars"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "3.93014495684943813490738`4.983582838146157*^23", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.40510302468385873962401`4.924759393349542*^23", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "9.141802013724491324794`3.3647579628804034*^21", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Uranus"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][{
                    
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "2.1486894814509604147309`4.537238273631205*^22", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
                 
                  GeneralUtilities`Slice[
                   Key["Neptune"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 595194551]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[595194551][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {178., {104.8837890625, 112.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[34]=",ExpressionUUID->"c2cd7f91-5935-42d6-a2c8-bc29d28d4108"]
}, Open  ]],

Cell["\<\
Get the same result, but only for planets with more than 10 moons:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a7db02b8-3991-435f-872d-88f7bd18c4d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "#Moons", "]"}], ">", "10"}], "&"}], "]"}], ",", 
   "\"\<Moons\>\"", ",", "Total", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[35]:=",ExpressionUUID->"d7c6f89b-8003-481f-9c09-1a87297cdbf0"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 4, "Length" -> 4, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilograms"]], 4], "DisplayedColumnCount" -> 20, 
        "DataRowCount" -> 0, "Shape" -> TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[67.20000000000002], 
            TypeSystem`PackageScope`AtomShape[75]]], 4, {}], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1596386133], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Atom[
           Quantity[1, "Kilograms"]], 4], "HandleQ" -> True, "Meta" -> {}, 
        "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[1596386133]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1842018076][{
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1842018076][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "3.93014495684943813490738`4.983582838146157*^23", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1842018076][
                  GeneralUtilities`Slice[
                   Key["Jupiter"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1842018076][{
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1842018076][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.40510302468385873962401`4.924759393349542*^23", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1842018076][
                  GeneralUtilities`Slice[
                   Key["Saturn"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1842018076][{
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1842018076][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "9.141802013724491324794`3.3647579628804034*^21", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1842018076][
                  GeneralUtilities`Slice[
                   Key["Uranus"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1842018076][{
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1842018076][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "2.1486894814509604147309`4.537238273631205*^22", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1842018076][
                  GeneralUtilities`Slice[
                   Key["Neptune"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1842018076][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1842018076]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1842018076][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1842018076][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[
         TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {178., {54.8837890625, 62.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[35]=",ExpressionUUID->"271379dc-4c77-4b15-9a02-8eceaca01c85"]
}, Open  ]],

Cell["Make a pie chart of the result:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:278",ExpressionUUID->"acaea558-b7ba-49a1-b5fd-964a95147be2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"%", ",", 
   RowBox[{"ChartLegends", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[36]:=",ExpressionUUID->"c3e32510-612f-44e4-9c1e-a7254ce7da19"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{
      DynamicChart`click$8831$8942 = False, DynamicChart`click$8835$8942 = 
       False, DynamicChart`click$8839$8942 = False, 
       DynamicChart`click$8843$8942 = False}, {{
        Directive[
         RGBColor[0.5, 0.5, 1.], 
         EdgeForm[
          Directive[
           GrayLevel[0], 
           Opacity[0.5]]]], {{{{{{}, {{
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.982864, 0.7431472, 0.3262672]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.2355545709912255`, 
                    3.141592653589793}]}], 
                    StatusArea[#, 
                    3.93014495684943813490738`4.983582838146157*^23]& , 
                    TagBoxNote -> 
                    "3.93014495684943813490738`4.983582838146157*^23"], 
                   StyleBox[
                   "3.93014495684943813490738`4.983582838146157*^23", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[3.93014495684943813490738`4.983582838146157*^23, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$8831$8942, 
                    FEPrivate`Not[DynamicChart`click$8831$8942]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$8831$8942, {{{1., 0}, {0, 1.}}, {
                   0.11584494145732219`, 0.1630335840823896}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$8831$8942}]]}, {
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.928, 0.5210666666666667, 0.2]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.8004695734331984`, -1.2355545709912255`}]}], 
                    StatusArea[#, 
                    1.40510302468385873962401`4.924759393349542*^23]& , 
                    TagBoxNote -> 
                    "1.40510302468385873962401`4.924759393349542*^23"], 
                   StyleBox[
                   "1.40510302468385873962401`4.924759393349542*^23", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[1.40510302468385873962401`4.924759393349542*^23, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$8835$8942, 
                    FEPrivate`Not[DynamicChart`click$8835$8942]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$8835$8942, {{{1., 0}, {
                    0, 1.}}, {-0.08649135548757698, -0.1803309330811594}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$8835$8942}]]}, {
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.9022851902905504`, -2.8004695734331984`}]}], 
                    StatusArea[#, 
                    9.141802013724491324794`3.3647579628804034*^21]& , 
                    TagBoxNote -> 
                    "9.141802013724491324794`3.3647579628804034*^21"], 
                   StyleBox["9.141802013724491324794`3.3647579628804034*^21", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[9.141802013724491324794`3.3647579628804034*^21, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$8839$8942, 
                    FEPrivate`Not[DynamicChart`click$8839$8942]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$8839$8942, {{{1., 0}, {
                    0, 1.}}, {-0.19163645917602865`, \
-0.057231700258460895`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$8839$8942}]]}, {
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.4992, 0.5552, 0.8309304]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.9022851902905504`}]}], 
                    StatusArea[#, 
                    2.1486894814509604147309`4.537238273631205*^22]& , 
                    TagBoxNote -> 
                    "2.1486894814509604147309`4.537238273631205*^22"], 
                   StyleBox["2.1486894814509604147309`4.537238273631205*^22", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[2.1486894814509604147309`4.537238273631205*^22, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$8843$8942, 
                    FEPrivate`Not[DynamicChart`click$8843$8942]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$8843$8942, {{{1., 0}, {
                    0, 1.}}, {-0.198570005776364, -0.02387368438207158}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$8843$8942}]]}}}}}, {}}, {{}}}}, {{{{
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               
               TagBox[{{}, {}}, 
                StatusArea[#, 
                 3.93014495684943813490738`4.983582838146157*^23]& , 
                TagBoxNote -> 
                "3.93014495684943813490738`4.983582838146157*^23"], 
               StyleBox["3.93014495684943813490738`4.983582838146157*^23", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[3.93014495684943813490738`4.983582838146157*^23, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8831$8942, 
                 FEPrivate`Not[DynamicChart`click$8831$8942]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$8831$8942, {{{1., 0}, {0, 1.}}, {
               0.11584494145732219`, 0.1630335840823896}}, {{1, 0}, {0, 
              1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$8831$8942}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               
               TagBox[{{}, {}}, 
                StatusArea[#, 
                 1.40510302468385873962401`4.924759393349542*^23]& , 
                TagBoxNote -> 
                "1.40510302468385873962401`4.924759393349542*^23"], 
               StyleBox["1.40510302468385873962401`4.924759393349542*^23", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[1.40510302468385873962401`4.924759393349542*^23, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8835$8942, 
                 FEPrivate`Not[DynamicChart`click$8835$8942]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$8835$8942, {{{1., 0}, {
                0, 1.}}, {-0.08649135548757698, -0.1803309330811594}}, {{1, 
              0}, {0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$8835$8942}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               
               TagBox[{{}, {}}, 
                StatusArea[#, 
                 9.141802013724491324794`3.3647579628804034*^21]& , 
                TagBoxNote -> 
                "9.141802013724491324794`3.3647579628804034*^21"], 
               StyleBox["9.141802013724491324794`3.3647579628804034*^21", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[9.141802013724491324794`3.3647579628804034*^21, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8839$8942, 
                 FEPrivate`Not[DynamicChart`click$8839$8942]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$8839$8942, {{{1., 0}, {
                0, 1.}}, {-0.19163645917602865`, -0.057231700258460895`}}, {{
              1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$8839$8942}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               
               TagBox[{{}, {}}, 
                StatusArea[#, 
                 2.1486894814509604147309`4.537238273631205*^22]& , 
                TagBoxNote -> 
                "2.1486894814509604147309`4.537238273631205*^22"], 
               StyleBox["2.1486894814509604147309`4.537238273631205*^22", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[2.1486894814509604147309`4.537238273631205*^22, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8843$8942, 
                 FEPrivate`Not[DynamicChart`click$8843$8942]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$8843$8942, {{{1., 0}, {
                0, 1.}}, {-0.198570005776364, -0.02387368438207158}}, {{1, 
              0}, {0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {
              DynamicChart`click$8843$8942}]]}, {}}}, {}}, {}, {}}, 
      DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, {}}}, {}}}, {
    ContentSelectable -> False, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {
       GrayLevel[0], FontFamily -> "Arial"}, 
     PlotRange -> {{-1., 1.}, {-1., 1.}}, PlotRangePadding -> 
     Scaled[0.09166666666666669]}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Jupiter\"", "\"Saturn\"", "\"Uranus\"", "\"Neptune\""}, 
      "SwatchLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.928, 0.5210666666666667, 0.2]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    RectangleBox[{0, 0}, {10, 10}, "RoundingRadius" -> 0]}, 
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          GrayLevel[0], FontFamily -> "Arial", FontFamily -> "Arial"}, 
         Background -> Automatic, StripOnInput -> False], TraditionalForm]& ),
       InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6552426666666666, 0.4954314666666667, 
                    0.21751146666666665`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.982864, 0.7431472, 0.3262672]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.982864, 0.7431472, 0.3262672]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.982864, 0.7431472, 0.3262672], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6186666666666667, 0.3473777777777778, 
                    0.13333333333333336`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.928, 0.5210666666666667, 0.2]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.928, 0.5210666666666667, 0.2]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.928, 0.5210666666666667, 0.2], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.4744270222222222, 0.32106666666666667`, 
                    0.36554631111111113`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.7116405333333333, 0.4816, \
0.5483194666666666]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    Editable -> False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.3328, 0.37013333333333337`, 0.5539536], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.4992, 0.5552, 0.8309304]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.4992, 0.5552, 0.8309304]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.4992, 0.5552, 0.8309304], Editable -> False, 
                    Selectable -> False]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"None", ",", "None", ",", "None", ",", "None"}], 
                 "}"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 
                 RowBox[{"FontFamily", "\[Rule]", "\"Arial\""}]}], "}"}]}], 
           ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[36]=",ExpressionUUID->"724a03a8-f3d8-4d7c-8e7c-e8003b6ee629"]
}, Open  ]],

Cell["\<\
Get a dataset with moons that are more than 1% of the mass of the Earth.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"79ca5d76-5c52-403c-9a6e-0c8baa5844b9"],

Cell["\<\
For all moons, select ones whose mass is greater than 0.01 times the mass of \
the Earth:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"97b4dd15-6d60-4c41-894e-4c301f3a0a4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{"All", ",", "\"\<Moons\>\"", ",", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"#Mass", ">", 
      NamespaceBox["LinguisticAssistant",
       DynamicModuleBox[{Typeset`query$$ = "1/100 earth mass", 
        Typeset`boxes$$ = TemplateBox[{"0.01", 
          SubscriptBox[
           StyleBox["\"M\"", Italic, StripOnInput -> False], "\"\[Earth]\""], 
          "Earth masses", "\"EarthMass\""}, "Quantity", SyntaxForm -> Mod], 
        Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
        Typeset`open$$ = {1, 2}, Typeset`querystate$$ = {
        "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
         1.23332`6.542620767742447, "Messages" -> {}}}, 
        DynamicBox[ToBoxes[
          AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
           Dynamic[Typeset`query$$], 
           Dynamic[Typeset`boxes$$], 
           Dynamic[Typeset`allassumptions$$], 
           Dynamic[Typeset`assumptions$$], 
           Dynamic[Typeset`open$$], 
           Dynamic[Typeset`querystate$$]], StandardForm],
         ImageSizeCache->{93., {13.5, 16.5}},
         TrackedSymbols:>{
          Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
           Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
        DynamicModuleValues:>{},
        UndoTrackedVariables:>{Typeset`open$$}],
       BaseStyle->{"Deploy"},
       DeleteWithContents->True,
       Editable->False,
       SelectWithContents->True]}], "&"}], "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[37]:=",ExpressionUUID->"5a4beb23-0208-4255-908a-6cfee79a915c"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 8, "Length" -> 8, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Assoc[
           TypeSystem`Atom[String], 
           TypeSystem`Struct[{"Mass", "Radius"}, {
             TypeSystem`Atom[
              Quantity[1, "Kilograms"]], 
             TypeSystem`Atom[
              Quantity[1, "Kilometers"]]}], TypeSystem`AnyLength], 8], 
        "DisplayedColumnCount" -> 20, "DataRowCount" -> 0, "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[<|{All, All, 
             TypeSystem`PackageScope`KeyDummy[8]} -> 1, {All, All, 
             TypeSystem`PackageScope`KeyDummy[7]} -> 1, {All, All, "Mass"} -> 
           1, {All, All, "Radius"} -> 1|>, 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[67.20000000000002], 
             TypeSystem`PackageScope`Limited[
              TypeSystem`PackageScope`ColumnShape[
               TypeSystem`PackageScope`KeyValueShape[
                TypeSystem`PackageScope`AtomShape[76.80000000000001], 
                
                TypeSystem`PackageScope`RowShape[<|
                 "Mass" -> TypeSystem`PackageScope`AtomShape[75], "Radius" -> 
                  TypeSystem`PackageScope`AtomShape[75]|>]]], 1, {All}]]], 
           8, {}]], "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1883199230], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Assoc[
           TypeSystem`Atom[String], 
           TypeSystem`Struct[{"Mass", "Radius"}, {
             TypeSystem`Atom[
              Quantity[1, "Kilograms"]], 
             TypeSystem`Atom[
              Quantity[1, "Kilometers"]]}], TypeSystem`AnyLength], 8], 
        "HandleQ" -> True, "Meta" -> {}, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[1883199230]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2091137000][{All, All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[All, All, Keys]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2091137000][{All, All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[All, All, Keys]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Mass\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Mass\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2091137000][{All, All, "Mass"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[All, All, "Mass"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Radius\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Radius\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    2091137000][{All, All, "Radius"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[All, All, "Radius"]], "Mouse"], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mercury", 
                    Style[
                    "Mercury", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Mercury"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Mercury"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Mercury"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Mercury"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Venus", 
                    Style[
                    "Venus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Venus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Venus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Venus"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Venus"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Earth", 
                    Style[
                    "Earth", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Earth"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Earth"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Moon", 
                    Style[
                    "Moon", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Earth"], 
                    Key["Moon"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Earth"], 
                    Key["Moon"]]], "Mouse"], 
                 ImageSize -> {{76.80000000000001, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "7.3459006322855173653772`4.995678626217362*^22", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Earth"], 
                   Key["Moon"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"1737.5`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Earth"], 
                   Key["Moon"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mars", 
                    Style[
                    "Mars", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Mars"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Mars"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Mars"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Mars"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Callisto", 
                    Style[
                    "Callisto", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Jupiter"], 
                    Key["Callisto"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Jupiter"], 
                    Key["Callisto"]]], "Mouse"], 
                 ImageSize -> {{76.80000000000001, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.07567783404752629528633`4.995678626217362*^23", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Callisto"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"2410.3`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Jupiter"], 
                   Key["Callisto"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {SpanFromAbove, 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["3 total \:203a ", 
                    Style[
                    "3 total \:203a ", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Jupiter"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Jupiter"]]], "Mouse"], BaseStyle -> {{
                   RGBColor[
                   0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274], 8}, ContextMenu -> {
                    MenuItem["Show 1 more row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000},
                     TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    1]& , {All}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 more rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000},
                     TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, 
                    5]& , {All}]], MenuEvaluator -> Automatic], Delimiter, 
                    MenuItem["Show 1 fewer row at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000},
                     TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, \
-1]& , {All}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show 5 fewer rows at this level", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000},
                     TypeSystem`NestedGrid`PackagePrivate`adjustLimitBy[#, \
-5]& , {All}]], MenuEvaluator -> Automatic]}}, 
                Alignment -> {Center, Baseline}, Background -> 
                GrayLevel[0.98]], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Titan", 
                    Style[
                    "Titan", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Saturn"], 
                    Key["Titan"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Saturn"], 
                    Key["Titan"]]], "Mouse"], 
                 ImageSize -> {{76.80000000000001, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   
                   RowBox[{
                    "1.34520841449162446435527`4.958607314841778*^23", 
                    "\"kg\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Titan"], 
                   Key["Mass"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  StyleBox[
                   RowBox[{"2575.5`5", "\"km\""}], FontColor -> RGBColor[{
                    Rational[33, 74], 
                    Rational[27, 74], 
                    Rational[117, 370]}]]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Saturn"], 
                   Key["Titan"], 
                   Key["Radius"]]], "Mouse"], 
                ImageSize -> {{75, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Uranus"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Uranus"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft, SpanFromLeft}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  2091137000][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Spacer[10], 
                    Style[
                    Spacer[10], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][{
                    Key["Neptune"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
                  GeneralUtilities`Slice[
                   Key["Neptune"]]], "Mouse"], BaseStyle -> {
                  GrayLevel[0.5], 8}], SpanFromLeft, SpanFromLeft}}, 
             BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 2091137000]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[2091137000][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {342., {128.8837890625, 136.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[37]=",ExpressionUUID->"161b2112-3105-4270-8abd-62769d351d35"]
}, Open  ]],

Cell["\<\
Get the list of keys (i.e. moon names) in the resulting association for each \
planet:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fbe51bbb-0801-4247-b94f-9e180aad258d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"planets", "[", 
   RowBox[{"All", ",", "\"\<Moons\>\"", ",", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"#Mass", ">", 
       NamespaceBox["LinguisticAssistant",
        DynamicModuleBox[{Typeset`query$$ = "1/100 earth mass", 
         Typeset`boxes$$ = TemplateBox[{"0.01", 
           SubscriptBox[
            StyleBox["\"M\"", Italic, StripOnInput -> False], "\"\[Earth]\""],
            "Earth masses", "\"EarthMass\""}, "Quantity", SyntaxForm -> Mod], 
         Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
         Typeset`open$$ = {1, 2}, Typeset`querystate$$ = {
         "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
          1.23332`6.542620767742447, "Messages" -> {}}}, 
         DynamicBox[ToBoxes[
           AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
            Dynamic[Typeset`query$$], 
            Dynamic[Typeset`boxes$$], 
            Dynamic[Typeset`allassumptions$$], 
            Dynamic[Typeset`assumptions$$], 
            Dynamic[Typeset`open$$], 
            Dynamic[Typeset`querystate$$]], StandardForm],
          ImageSizeCache->{93., {13.5, 16.5}},
          
          TrackedSymbols:>{
           Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
            Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
         DynamicModuleValues:>{},
         UndoTrackedVariables:>{Typeset`open$$}],
        BaseStyle->{"Deploy"},
        DeleteWithContents->True,
        Editable->False,
        SelectWithContents->True]}], "&"}], "]"}]}], "]"}], "[", 
  RowBox[{"All", ",", "Keys"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[38]:=",ExpressionUUID->"3e10e1e7-8111-440b-a0ec-ecb3cf31563f"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 8, "Length" -> 8, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Vector[
           TypeSystem`Atom[String], TypeSystem`AnyLength], 8], 
        "DisplayedColumnCount" -> 20, "DataRowCount" -> 0, "Shape" -> 
        TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[67.20000000000002], 
            TypeSystem`PackageScope`UnknownShape]], 8, {}], "DataColumnCount" -> 
        0, "InitialData" -> TypeSystem`PackageScope`CacheHandle[411953274], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          TypeSystem`Vector[
           TypeSystem`Atom[String], TypeSystem`AnyLength], 8], "HandleQ" -> 
        True, "Meta" -> {}, "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[411953274]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mercury", 
                    Style[
                    "Mercury", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Mercury"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Mercury"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], {}}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Venus", 
                    Style[
                    "Venus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Venus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Venus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], {}}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Earth", 
                    Style[
                    "Earth", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Earth"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Earth"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Style[{"Moon"}, ShowStringCharacters -> False], 
                    Style[
                    Style[{"Moon"}, ShowStringCharacters -> False], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Earth"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                 
                  GeneralUtilities`Slice[
                   Key["Earth"]]], "Mouse"]]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mars", 
                    Style[
                    "Mars", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Mars"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Mars"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], {}}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    
                    Style[{"Callisto", "Ganymede", "Io"}, 
                    ShowStringCharacters -> False], 
                    Style[
                    
                    Style[{"Callisto", "Ganymede", "Io"}, 
                    ShowStringCharacters -> False], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Jupiter"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                 
                  GeneralUtilities`Slice[
                   Key["Jupiter"]]], "Mouse"]]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Style[{"Titan"}, ShowStringCharacters -> False], 
                    Style[
                    Style[{"Titan"}, ShowStringCharacters -> False], 
                    FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Saturn"]}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                 
                  GeneralUtilities`Slice[
                   Key["Saturn"]]], "Mouse"]]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], {}}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][{
                    
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{67.20000000000002, Full}, Automatic}], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], {}}}, 
             BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 914453454]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[914453454][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {223., {104.8837890625, 112.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[38]=",ExpressionUUID->"eded0ae1-eeac-4276-8c7a-b096f7ee4d4e"]
}, Open  ]],

Cell["Get the underlying association:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:279",ExpressionUUID->"6fbb5cea-c499-462d-a954-7974a791a168"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[39]:=",ExpressionUUID->"d5a7d98b-197d-401d-9fd0-a97dc17aea93"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"\<\"Mercury\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"Venus\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"Earth\"\>", "\[Rule]", 
    RowBox[{"{", "\<\"Moon\"\>", "}"}]}], ",", 
   RowBox[{"\<\"Mars\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"Jupiter\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Callisto\"\>", ",", "\<\"Ganymede\"\>", ",", "\<\"Io\"\>"}],
      "}"}]}], ",", 
   RowBox[{"\<\"Saturn\"\>", "\[Rule]", 
    RowBox[{"{", "\<\"Titan\"\>", "}"}]}], ",", 
   RowBox[{"\<\"Uranus\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"Neptune\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[39]=",ExpressionUUID->"2e0f5d16-dea8-44c0-82c9-9c855b374066"]
}, Open  ]],

Cell["Join together, or \[OpenCurlyDoubleQuote]catenate\
\[CloseCurlyDoubleQuote], the lists for all keys:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"9d17b0cf-b393-45f0-a370-0ad3efda80ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catenate", "[", "%", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[40]:=",ExpressionUUID->"87ae0360-016b-42cb-bd2a-d79550c3154e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Moon\"\>", ",", "\<\"Callisto\"\>", ",", "\<\"Ganymede\"\>", 
   ",", "\<\"Io\"\>", ",", "\<\"Titan\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[40]=",ExpressionUUID->"cc392e61-b528-4c9d-80a0-80d0405cb51f"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s the whole computation in one line:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0358a742-1aad-4231-ba3c-22ce1925aa5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"planets", "[", 
    RowBox[{"All", ",", "\"\<Moons\>\"", ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"#Mass", ">", 
        NamespaceBox["LinguisticAssistant",
         DynamicModuleBox[{Typeset`query$$ = "1/100 earth mass", 
          Typeset`boxes$$ = TemplateBox[{"0.01", 
            SubscriptBox[
             StyleBox["\"M\"", Italic, StripOnInput -> False], 
             "\"\[Earth]\""], "Earth masses", "\"EarthMass\""}, "Quantity", 
           SyntaxForm -> Mod], Typeset`allassumptions$$ = {}, 
          Typeset`assumptions$$ = {}, Typeset`open$$ = {1, 2}, 
          Typeset`querystate$$ = {
          "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
           1.23332`6.542620767742447, "Messages" -> {}}}, 
          DynamicBox[ToBoxes[
            AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
             Dynamic[Typeset`query$$], 
             Dynamic[Typeset`boxes$$], 
             Dynamic[Typeset`allassumptions$$], 
             Dynamic[Typeset`assumptions$$], 
             Dynamic[Typeset`open$$], 
             Dynamic[Typeset`querystate$$]], StandardForm],
           ImageSizeCache->{93., {13.5, 16.5}},
           
           TrackedSymbols:>{
            Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
             Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
          DynamicModuleValues:>{},
          UndoTrackedVariables:>{Typeset`open$$}],
         BaseStyle->{"Deploy"},
         DeleteWithContents->True,
         Editable->False,
         SelectWithContents->True]}], "&"}], "]"}]}], "]"}], "[", 
   RowBox[{"Catenate", ",", "Keys"}], "]"}], "//", "Normal"}]], "Input",
 Deletable->False,
 CellLabel->"In[41]:=",ExpressionUUID->"6cfea72d-6911-4514-aea3-dfd3e19b62af"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Moon\"\>", ",", "\<\"Callisto\"\>", ",", "\<\"Ganymede\"\>", 
   ",", "\<\"Io\"\>", ",", "\<\"Titan\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[41]=",ExpressionUUID->"222b1774-a55b-4b38-9b8c-ed7aced78b91"]
}, Open  ]],

Cell["\<\
Here\[CloseCurlyQuote]s one more example, where we find the logarithm of the \
mass of each moon, then make a number line plot of these values for each \
planet.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"620ac347-68b4-4654-900a-1cd588aaca74"],

Cell["\<\
Make number line plots of the logarithms of masses for moons of each planet:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0a06c242-931d-4abb-a535-d51083a6a3c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{"All", ",", "\"\<Moons\>\"", ",", 
   RowBox[{
    RowBox[{"NumberLinePlot", "[", 
     RowBox[{"Values", "[", "#", "]"}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"#Mass", "/", 
      NamespaceBox["LinguisticAssistant",
       DynamicModuleBox[{Typeset`query$$ = "1 earth mass", Typeset`boxes$$ = 
        TemplateBox[{"1", 
          SubscriptBox[
           StyleBox["\"M\"", Italic, StripOnInput -> False], "\"\[Earth]\""], 
          "Earth masses", "\"EarthMass\""}, "Quantity", SyntaxForm -> Mod], 
        Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
        Typeset`open$$ = {1, 2}, Typeset`querystate$$ = {
        "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
         1.21194`6.535026113067228, "Messages" -> {}}}, 
        DynamicBox[ToBoxes[
          AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
           Dynamic[Typeset`query$$], 
           Dynamic[Typeset`boxes$$], 
           Dynamic[Typeset`allassumptions$$], 
           Dynamic[Typeset`assumptions$$], 
           Dynamic[Typeset`open$$], 
           Dynamic[Typeset`querystate$$]], StandardForm],
         ImageSizeCache->{74., {13.5, 16.5}},
         TrackedSymbols:>{
          Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
           Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
        DynamicModuleValues:>{},
        UndoTrackedVariables:>{Typeset`open$$}],
       BaseStyle->{"Deploy"},
       DeleteWithContents->True,
       Editable->False,
       SelectWithContents->True]}], "]"}], "&"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[42]:=",ExpressionUUID->"b5ebbfae-82fb-4d96-a7b8-0e6eb1b5c696"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "DisplayedRowCount" -> 20, "RowCount" -> 8, "Length" -> 8, 
        "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[
           TypeSystem`Enumeration[
           "Earth", "Jupiter", "Mars", "Mercury", "Neptune", "Saturn", 
            "Uranus", "Venus"]], 
          TypeSystem`Atom[Graphics], 8], "DisplayedColumnCount" -> 20, 
        "DataRowCount" -> 0, "Shape" -> TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`ColumnShape[
           TypeSystem`PackageScope`KeyValueShape[
            TypeSystem`PackageScope`AtomShape[63.], 
            TypeSystem`PackageScope`AtomShape[60]]], 8, {}], 
        "DataColumnCount" -> 0, "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1159106545], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[
           TypeSystem`Enumeration[
           "Earth", "Jupiter", "Mars", "Mercury", "Neptune", "Saturn", 
            "Uranus", "Venus"]], 
          TypeSystem`Atom[Graphics], 8], "HandleQ" -> True, "Meta" -> {}, 
        "RowTarget" -> 20, "Data" -> 
        TypeSystem`PackageScope`CacheHandle[1159106545]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mercury", 
                    Style[
                    "Mercury", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Mercury"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Mercury"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  
                  GraphicsBox[{}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, PlotRange -> {{-3., 3.}, {0, 1}}, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 0}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Mercury"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Venus", 
                    Style[
                    "Venus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Venus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Venus"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  
                  GraphicsBox[{}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, PlotRange -> {{-3., 3.}, {0, 1}}, 
                    PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 0}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Venus"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Earth", 
                    Style[
                    "Earth", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Earth"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Earth"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{
                    RGBColor[0.24720000000000014`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-4.398142899775445, 1}]}}}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, 
                    PlotRange -> {{-4.398142899775445, 8.79628579955089}, {0, 
                    1}}, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 1}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Earth"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Mars", 
                    Style[
                    "Mars", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Mars"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Mars"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{
                    RGBColor[0.24720000000000014`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-22.12624793250122, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.4428931686004542], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.137814612839865`, 1}]}}}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, 
                    PlotRange -> {{-22.12624793250122, -20.137814612839865`}, \
{0, 1}}, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 1}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Mars"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Jupiter", 
                    Style[
                    "Jupiter", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Jupiter"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Jupiter"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{
                    RGBColor[0.24720000000000014`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.4966073127496, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.4428931686004542], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-25.61260312250368, 1}]}}, {
                    RGBColor[0.6, 0.5470136627990908, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-14.876206447032377`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.33692049419863584`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-19.11031295162971, 1}]}}, {
                    RGBColor[0.24, 0.3531726744018182, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.5632658430022722], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.42664098839727194`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.91945594194372, 1}]}}, {
                    RGBColor[0.2634521802031821, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-22.65077240062537, 1}]}}, {
                    RGBColor[0.24, 0.47354534880363613`, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-4.016749221138189, 1}]}}, {
                    RGBColor[0.5163614825959097, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-17.628708410705492`, 1}]}}, {
                    RGBColor[0.6, 0.3062683139954558, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.3838248546049982, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-25.101777498737807`, 1}]}}, {
                    RGBColor[0.24, 0.5939180232054561, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.39598880819409377`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-15.7430171216432, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.2941043604063603], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-25.61260312250368, 1}]}}, {
                    RGBColor[0.5041975290068142, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-25.61260312250368, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.48570930239273163`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.2756161337922776, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.71121541117179, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.4144770348081764], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-4.823943193025306, 1}]}}, {
                    RGBColor[0.6, 0.5754297965913696, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-25.61260312250368, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.36533662799091565`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-3.696644461676854, 1}]}}, {
                    RGBColor[0.24, 0.32475654060953846`, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.631773869491962`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.5348497092099924], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.45505712218955346`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.6, 0.24496395358909184`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.91945594194372, 1}]}}, {
                    RGBColor[0.24, 0.4451292150113622, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.5447776163881838, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-13.694212549425279`, 1}]}}, {
                    RGBColor[0.6, 0.3346844477877375, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-4.202893187207173, 1}]}}, {
                    RGBColor[0.35540872081272423`, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.146266053710253`, 1}]}}, {
                    RGBColor[0.24, 0.5655018894131706, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-25.101777498737807`, 1}]}}, {
                    RGBColor[0.42440494198636775`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.71121541117179, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.26568822661407865`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.4757813952145403, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.146266053710253`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.514125436184998], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.3040322675845516, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.118170877029353`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.3860609010159101], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-18.36837560690033, 1}]}}, {
                    RGBColor[0.5961540696163564, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.07215808155653, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.39375276178318186`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-17.72401859051053, 1}]}}, {
                    RGBColor[0.24, 0.2963404068172645, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.5064335754177262], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.71121541117179, 1}]}}, {
                    RGBColor[0.6, 0.48347325598182744`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-16.807727858635293`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.2733800873813658], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.71121541117179, 1}]}}, {
                    RGBColor[0.24, 0.4167130812190805, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-23.343919581185315`, 1}]}}, {
                    RGBColor[0.5731937501804577, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.36310058158001146`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.32699258702045025`, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.5370857556208966, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.4528210757786416, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24272790717818, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.4473652614222664, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.6, 0.5425415699772719], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.3324484013768256, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.35764476722363614`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.5677379358240978, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.6, 0.42216889557547116`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.2679242730249905, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.4780174416254521], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.710086049141232`, 1}]}}, {
                    RGBColor[0.6, 0.511889389774086, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.710086049141232`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.3017962211736552], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.710086049141232`, 1}]}}, {
                    RGBColor[0.24, 0.3882969474268066, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.710086049141232`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.5983901160272683], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-18.194022219755553`, 1}]}}, {
                    RGBColor[0.6, 0.39151671537227, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-26.71121541117179, 1}]}}, {
                    RGBColor[0.298576453228161, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.313320138373424`, 1}]}}, {
                    RGBColor[0.24, 0.5086696218286226, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-15.198289946201626`, 1}]}}, {
                    RGBColor[0.4812372095709156, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.27114404097045397`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-22.882574014682692`, 1}]}}, {
                    RGBColor[0.41894912763000774`, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.91945594194372, 1}]}}}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, 
                    PlotRange -> {{-26.71121541117179, -3.696644461676854}, {
                    0, 1}}, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 1}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Jupiter"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Saturn", 
                    Style[
                    "Saturn", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Saturn"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Saturn"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{
                    RGBColor[0.24720000000000014`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.4428931686004542], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.5470136627990908, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-19.46698789556844, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.33692049419863584`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-27.80869833780934, 1}]}}, {
                    RGBColor[0.24, 0.3531726744018182, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-21.769572988562484`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.5632658430022722], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.42664098839727194`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.2634521802031821, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.47354534880363613`, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-21.230576487829797`, 1}]}}, {
                    RGBColor[0.5163614825959097, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.3062683139954558, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-8.603698663685897, 1}]}}, {
                    RGBColor[0.3838248546049982, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-10.920235901910658`, 1}]}}, {
                    RGBColor[0.24, 0.5939180232054561, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-16.245259001717834`, 1}]}}, {
                    RGBColor[0.39598880819409377`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-22.779389778447467`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.2941043604063603], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.5041975290068142, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.6, 0.48570930239273163`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.2756161337922776, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.4144770348081764], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.5754297965913696, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-19.272831881127484`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.36533662799091565`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-13.889957126551394`, 1}]}}, {
                    RGBColor[0.24, 0.32475654060953846`, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.5348497092099924], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-8.104055100276806, 1}]}}, {
                    RGBColor[0.6, 0.45505712218955346`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-22.329188776497908`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.24496395358909184`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-14.962427622479577`, 1}]}}, {
                    RGBColor[0.24, 0.4451292150113622, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.5447776163881838, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.3346844477877375, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-21.317587864819426`, 1}]}}, {
                    RGBColor[0.35540872081272423`, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.5655018894131706, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.42440494198636775`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-11.96748555046809, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.26568822661407865`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.07215808155653, 1}]}}, {
                    RGBColor[0.4757813952145403, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-23.57572119524264, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.514125436184998], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.401297132945274`, 1}]}}, {
                    RGBColor[0.3040322675845516, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.3860609010159101], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.912122756711263`, 1}]}}, {
                    RGBColor[0.5961540696163564, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-17.505887581019152`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.39375276178318186`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-13.48792131518902, 1}]}}, {
                    RGBColor[0.24, 0.2963404068172645, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.5064335754177262], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-17.280936618830346`, 1}]}}, {
                    RGBColor[0.6, 0.48347325598182744`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-7.858297808613832, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.2733800873813658], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.4167130812190805, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.5731937501804577, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.36310058158001146`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.32699258702045025`, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.5370857556208966, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.4528210757786416, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.407500956147185`, 1}]}}, {
                    RGBColor[0.6, 0.24272790717818, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.4473652614222664, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.6, 0.5425415699772719], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-18.847948687162216`, 1}]}}, {
                    RGBColor[0.3324484013768256, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-23.666692973448367`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.35764476722363614`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.5677379358240978, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.6, 0.42216889557547116`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.07215808155653, 1}]}}, {
                    RGBColor[0.24, 0.2679242730249905, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.24, 0.4780174416254521], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-21.51825856028158, 1}]}}, {
                    RGBColor[0.6, 0.511889389774086, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.537429307269853`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.3017962211736552], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-9.177023907856789, 1}]}}, {
                    RGBColor[0.24, 0.3882969474268066, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-24.07215808155653, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.5983901160272683], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-3.7931512712470643`, 1}]}}, {
                    RGBColor[0.6, 0.39151671537227, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.912122756711263`, 1}]}}}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, 
                    PlotRange -> {{-27.80869833780934, -3.7931512712470643`}, \
{0, 1}}, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 1}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Saturn"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Uranus", 
                    Style[
                    "Uranus", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Uranus"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Uranus"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{
                    RGBColor[0.24720000000000014`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-8.392567392784576, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.4428931686004542], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-16.633774551512225`, 1}]}}, {
                    RGBColor[0.6, 0.5470136627990908, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-17.978910840138607`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.33692049419863584`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-15.911639834078857`, 1}]}}, {
                    RGBColor[0.24, 0.3531726744018182, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-18.70484784352154, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.5632658430022722], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-16.67232322162946, 1}]}}, {
                    RGBColor[0.6, 0.42664098839727194`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.2634521802031821, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-17.32692173207217, 1}]}}, {
                    RGBColor[0.24, 0.47354534880363613`, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.5163614825959097, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.3062683139954558, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-16.187151370910552`, 1}]}}, {
                    RGBColor[0.3838248546049982, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.5939180232054561, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.39598880819409377`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-11.414100312283301`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.2941043604063603], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-7.591902556428909, 1}]}}, {
                    RGBColor[0.5041975290068142, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-18.522526286727587`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.48570930239273163`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.2756161337922776, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-15.083177139101057`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.4144770348081764], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-19.46698789556844, 1}]}}, {
                    RGBColor[0.6, 0.5754297965913696, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-14.540251942755184`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.36533662799091565`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-16.970246788133437`, 1}]}}, {
                    RGBColor[0.24, 0.32475654060953846`, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-19.46698789556844, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.5348497092099924], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.71975086406381, 1}]}}, {
                    RGBColor[0.6, 0.45505712218955346`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-13.920137743701364`, 1}]}}, {
                    RGBColor[0.24, 0.6, 0.24496395358909184`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-7.434843557474199, 1}]}}, {
                    RGBColor[0.24, 0.4451292150113622, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-22.799192405743646`, 1}]}}, {
                    RGBColor[0.5447776163881838, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-8.53643520565625, 1}]}}}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, 
                    PlotRange -> {{-22.799192405743646`, -7.434843557474199}, \
{0, 1}}, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 1}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Uranus"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["Neptune", 
                    Style[
                    "Neptune", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][{
                    Key["Neptune"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1231202866][
                   GeneralUtilities`Slice[
                    Key["Neptune"]]], "Mouse"], 
                 ImageSize -> {{63., Full}, Automatic}], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes[
                  GraphicsBox[{{
                    RGBColor[0.24720000000000014`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-14.86181770958029, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.4428931686004542], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-14.281999214327428`, 1}]}}, {
                    RGBColor[0.6, 0.5470136627990908, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.6, 0.33692049419863584`], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.3531726744018182, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-14.004367477729119`, 1}]}}, {
                    RGBColor[0.6, 0.24, 0.5632658430022722], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-17.23851077472883, 1}]}}, {
                    RGBColor[0.6, 0.42664098839727194`, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-12.172998870406026`, 1}]}}, {
                    RGBColor[0.2634521802031821, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.47354534880363613`, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-11.683763879232401`, 1}]}}, {
                    RGBColor[0.5163614825959097, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.6, 0.3062683139954558, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-20.900943058827202`, 1}]}}, {
                    RGBColor[0.3838248546049982, 0.6, 0.24], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {{}}}, {
                    RGBColor[0.24, 0.5939180232054561, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-16.5845843073213, 1}]}}, {
                    RGBColor[0.39598880819409377`, 0.24, 0.6], 
                    PointSize[Medium], 
                    Directive[
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    PointBox[{-5.631744740771266, 1}]}}}, {
                   PlotRangeClipping -> True, Frame -> True, FrameStyle -> 
                    GrayLevel[0.85], Ticks -> None, FrameTicks -> None, Axes -> 
                    None, ImageSize -> 96, AxesLabel -> {None}, 
                    Ticks -> {Automatic, Automatic}, 
                    FrameTicks -> {{Automatic, Automatic}, {
                    Automatic, Automatic}}, 
                    PlotRange -> {{-20.900943058827202`, -5.631744740771266}, \
{0, 1}}, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {0, 1}}, AspectRatio -> 
                    NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
                    AxesOrigin -> {Automatic, Automatic}, 
                    Axes -> {True, False}, ImagePadding -> All}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
                  GeneralUtilities`Slice[
                   Key["Neptune"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1231202866]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1231202866][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {171., {104.8837890625, 112.1162109375}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[42]=",ExpressionUUID->"cbfbee66-5911-49c6-a329-95558633485f"]
}, Open  ]],

Cell["\<\
Here\[CloseCurlyQuote]s how to make a word cloud of names of moons, sized \
according to the masses of the moons. To do this, we need a single \
association that associates the name of each moon with its mass. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ad9a6d20-b14c-4dce-bb00-e9f26bca89cd"],

Cell[TextData[{
 "When given an association, ",
 ButtonBox["WordCloud",
  BaseStyle->"Link"],
 " determines sizes from values in the association:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"b3d153c1-76e1-4855-8ebb-aeff31392eb5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordCloud", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"\"\<A\>\"", "\[Rule]", "5"}], ",", 
    RowBox[{"\"\<B\>\"", "\[Rule]", "4"}], ",", 
    RowBox[{"\"\<C\>\"", "\[Rule]", "3"}], ",", 
    RowBox[{"\"\<D\>\"", "\[Rule]", "2"}], ",", 
    RowBox[{"\"\<E\>\"", "\[Rule]", "1"}]}], "\[RightAssociation]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[43]:=",ExpressionUUID->"6299e7ad-4f62-42e3-8c5f-421b1eb5b7ce"],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.7291666666666666],
     FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.5729166666666666],
     FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {-33., 18.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"C\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.41666666666666663`],
     FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {30., 13.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"D\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.26041666666666663`],
     FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {0., -25.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"E\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.10416666666666666`],
     FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {-28., -5.5}, Center,
     Automatic]},
  DefaultBaseStyle->{"Graphics", FontFamily -> "Helvetica"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-50.5, 45.5}, {-35., 45.}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[43]=",ExpressionUUID->"b37e519c-b5ac-4b49-840e-e4f2e6cc9d09"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 ButtonBox["Association",
  BaseStyle->"Link"],
 " combines associations:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"853fad81-205e-4f3e-a232-2454dac38075"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Association", "[", 
  RowBox[{
   RowBox[{"\[LeftAssociation]", 
    RowBox[{
     RowBox[{"\"\<a\>\"", "\[Rule]", "1"}], ",", 
     RowBox[{"\"\<b\>\"", "\[Rule]", "2"}]}], "\[RightAssociation]"}], ",", 
   RowBox[{"\[LeftAssociation]", 
    RowBox[{"\"\<c\>\"", "\[Rule]", "3"}], "\[RightAssociation]"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[44]:=",ExpressionUUID->"15757db8-8371-4cc1-845f-889383ceabdb"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"\<\"a\"\>", "\[Rule]", "1"}], ",", 
   RowBox[{"\<\"b\"\>", "\[Rule]", "2"}], ",", 
   RowBox[{"\<\"c\"\>", "\[Rule]", "3"}]}], "\[RightAssociation]"}]], "Output",\

 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[44]=",ExpressionUUID->"40742866-5db5-4486-9070-f51101dd9e2c"]
}, Open  ]],

Cell["Generate the word cloud of moon masses:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:280", "i:22"},ExpressionUUID->"8f055eb0-13f2-49d5-8d97-a16a33c8c025"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"WordCloud", "[", 
     RowBox[{"Association", "[", 
      RowBox[{"Values", "[", "#", "]"}], "]"}], "]"}], "&"}], ",", 
   "\"\<Moons\>\"", ",", "All", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[45]:=",ExpressionUUID->"7bedef8d-7082-4144-b31f-cae334ec7cb9"],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"Ganymede\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.20408163265306123`],
     FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"Titan\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.20408163265306123`],
     FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {0., 43.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"Callisto\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.1561643679384994],
     FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {0., -51.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"Moon\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.11589068663893688`],
     FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {43., 77.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"Europa\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.08581464179376451],
     FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {0., -84.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"Io\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.13459226231470894`],
     FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {-82., 36.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"Triton\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.054415706133205725`],
     FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {-30., 84.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"Desdemona\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154729457362142`],
     FontColor->RGBColor[0.6361597700445392, 0.7170733077827265, 0.]], {98., -28.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Prometheus\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154739364403832`],
     FontColor->RGBColor[
      0.6536293927965667, 0.37163285420200276`, 0.6534265180085832]], {-14., -101.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Epimetheus\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915513989194653],
     FontColor->RGBColor[0.37977756485605163`, 0.715, 0.3025558265468435]], {0., 103.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"S/2004 N1\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915452483643847],
     FontColor->RGBColor[0.7175796237092107, 0.7261199581899123, 0.]], {-70., -75.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"S/2007 S2\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451910983755],
     FontColor->RGBColor[
      0.3383114092015346, 0.5643508726387724, 0.8209736910418415]], {73., -75.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Enceladus\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02928207209451304],
     FontColor->RGBColor[
      0.838355547812947, 0.44746667828057946`, 0.0208888695323676]], {99., 39.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"S/2010 J2\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154518950437316`],
     FontColor->RGBColor[
      0.9107287510704583, 0.33890687339431275`, 0.20182187767614543`]], {53., 95.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"S/2010 J1\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154518950437316`],
     FontColor->RGBColor[0.6672593867853922, 0.7205288207539324, 0.]], {-50., 99.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Eurydome\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451898579962],
     FontColor->RGBColor[
      0.6453361616656581, 0.37647057236169945`, 0.6741595958358548]], {99., 52.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Hermippe\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519038873058`],
     FontColor->RGBColor[0.4177882075393331, 0.715, 0.25417864494993975`]], {44., -102.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Harpalyke\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451907425535],
     FontColor->RGBColor[
      0.9603267270590103, 0.5591336352950514, 0.10711783694067224`]], {-71., -87.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Amalthea\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029156960310857467`],
     FontColor->RGBColor[
      0.8613800418100862, 0.48092002787339083`, 0.02824203762907758]], {-77., 82.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Chaldene\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451902118191],
     FontColor->RGBColor[0.529922539669161, 0.44454647619850335`, 0.85]], {72., -87.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Mundilfari\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451918040222],
     FontColor->RGBColor[0.7658565873730018, 0.358, 0.4582975578876895]], {0., -113.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Megaclite\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451918040222],
     FontColor->RGBColor[
      0.9840111653093676, 0.677555826546838, 0.04316985366470745]], {-109., -28.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Themisto\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519746518892`],
     FontColor->RGBColor[
      0.6670481226429111, 0.3638052617916352, 0.6198796933927223]], {107., -40.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Callirrhoe\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519958812644`],
     FontColor->RGBColor[
      0.8335801463353031, 0.3487839707329394, 0.3481997561078282]], {0., 115.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Stephano\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154526009184535`],
     FontColor->RGBColor[
      0.6319174318193065, 0.38429816477207124`, 0.7077064204517338]], {-112., -42.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Thalassa\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915496121137315],
     FontColor->RGBColor[
      0.8564488486273256, 0.42032672705901153`, 0.06612212156831418]], {48., 107.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Adrastea\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915452777829912],
     FontColor->RGBColor[
      0.19193353076984873`, 0.681453175384121, 0.6453202369238185]], {-64., -100.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Pasiphae\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915487275564376],
     FontColor->RGBColor[
      0.8168067340273636, 0.3521386531945273, 0.3761554432877274]], {-102., 64.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Praxidike\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519445769408`],
     FontColor->RGBColor[0.5788038738141875, 0.715, 0.049249615145579635`]], {109., -52.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Prospero\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915454370033041],
     FontColor->RGBColor[0.47929071933511125`, 0.715, 0.1759027208462221]], {-45., -112.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Cressida\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154924059966808`],
     FontColor->RGBColor[0.9810598048862722, 0.7553955338762525, 0.]], {-50., 111.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Hyperion\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029161064656701374`],
     FontColor->RGBColor[0.5407932311309059, 0.715, 0.09762679674248334]], {-110., -54.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Iapetus\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031286302011133485`],
     FontColor->RGBColor[0.915, 0.3325, 0.2125]], {42., -116.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"Oberon\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03271220836897272],
     FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {-8., -125.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"Autonoe\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519038873058`],
     FontColor->RGBColor[0.7042770479220728, 0.358, 0.5530353108891188]], {95., 26.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Cordelia\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154572006163816`],
     FontColor->RGBColor[0.8493197142977551, 0.7407577460330839, 0.]], {43., 119.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Lysithea\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154593235538873`],
     FontColor->RGBColor[
      0.8342400905885153, 0.4628267270590103, 0.0038160815296638794`]], {-121., 42.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Rosalind\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154819682206123`],
     FontColor->RGBColor[
      0.23716678280579248`, 0.645266573755366, 0.699600139366951]], {114., 64.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Titania\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.03331724555803106],
     FontColor->RGBColor[1, 0.75, 0]], {-42., 123.5}, Center, Automatic], 
   InsetBox[
    StyleBox["\<\"Taygete\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519127328787`],
     FontColor->RGBColor[
      0.8774935098648088, 0.34000129802703827`, 0.2750108168919853]], {116., -64.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Suttungr\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451918040222],
     FontColor->RGBColor[0.15725938678540247`, 0.715, 0.5857607804549424]], {-115., -67.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Trinculo\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519817283474`],
     FontColor->RGBColor[
      0.922066817647527, 0.5213778784316846, 0.08286013588277422]], {-47., -124.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Pandora\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154694959627674`],
     FontColor->RGBColor[
      0.9038177251280404, 0.3492734123079395, 0.18454431282010084`]], {89., -99.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Miranda\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029232359974593336`],
     FontColor->RGBColor[
      0.5833680111493557, 0.4126186601628758, 0.8290799721266107]], {-95., 94.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Euanthe\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451898579962],
     FontColor->RGBColor[
      0.8949268664259606, 0.5032845776173072, 0.05843417978336459]], {97., 95.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Erinome\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451898579962],
     FontColor->RGBColor[
      0.2198892179497479, 0.6590886256402017, 0.6788670615396974]], {113., 76.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Setebos\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915454370033041],
     FontColor->RGBColor[
      0.8745421494417032, 0.39318677583744527`, 0.11135537360425793`]], {90., 107.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Despina\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029156995693149227`],
     FontColor->RGBColor[
      0.16397784358994957`, 0.7038177251280403, 0.6117734123079395]], {-116., -79.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Calypso\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915452317860119],
     FontColor->RGBColor[
      0.969373377466199, 0.6043668873309952, 0.08269188084126262]], {-86., -110.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Ananke\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915455431501794],
     FontColor->RGBColor[
      0.3103557220216354, 0.5867154223826917, 0.7874268664259625]], {85., -111.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Ophelia\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154582620851348`],
     FontColor->RGBColor[
      0.596786740995709, 0.404791067752503, 0.7955331475107271]], {117., -78.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Sycorax\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029160870054096708`],
     FontColor->RGBColor[
      0.8857244243136628, 0.3764133635295058, 0.1393110607841571]], {-120., 76.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Phoebe\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029164303905511797`],
     FontColor->RGBColor[
      0.9324333565611593, 0.5282889043741062, 0.0921900209050434]], {-94., 106.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Thyone\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519038873058`],
     FontColor->RGBColor[
      0.8633598745697435, 0.40996018814538476`, 0.08339968642435877]], {-106., -96.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Telesto\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154527424476204`],
     FontColor->RGBColor[
      0.8781534541180211, 0.4921023027453475, 0.04333810870621905]], {82., 119.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Albiorix\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915454370033041],
     FontColor->RGBColor[0.6897400905885174, 0.358, 0.5753998606330502]], {-80., 122.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Belinda\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0291549399819981],
     FontColor->RGBColor[0.5472001045252132, 0.43417993728487203`, 0.85]], {144., -28.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Galatea\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915894171919591],
     FontColor->RGBColor[
      0.9874666782805795, 0.6948333914028977, 0.033839968642435214`]], {81., -123.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Himalia\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02916247994837168],
     FontColor->RGBColor[
      0.6753413537738198, 0.3589675436319385, 0.5991466155654507]], {142., 38.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Proteus\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029213961182879278`],
     FontColor->RGBColor[0.8996399512215667, 0.7463488834690629, 0.]], {142., 50.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Thrymr\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451918040222],
     FontColor->RGBColor[
      0.8510135028964549, 0.47400900193096995`, 0.018912152606809424`]], {-85., -122.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Deimos\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915452066645848],
     FontColor->RGBColor[
      0.5750747800184488, 0.4174563783225715, 0.8498130499538777]], {-142., 54.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Phobos\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.0291545315960484],
     FontColor->RGBColor[
      0.9930578157165594, 0.7227890785827968, 0.01874389756528967]], {-150., -28.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Siarnaq\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154564929705466`],
     FontColor->RGBColor[
      0.8607200975568693, 0.34335598048862614`, 0.30296650407188447`]], {148., -40.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Caliban\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029155385798874247`],
     FontColor->RGBColor[
      0.9637822400302223, 0.5764112001511111, 0.0977879519184]], {128., -90.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Larissa\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029160357010866216`],
     FontColor->RGBColor[0.47401116530937026`, 0.47809330081437784`, 0.85]], {149., -52.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Umbriel\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.030537966540456065`],
     FontColor->RGBColor[
      0.9728288904374106, 0.621644452187053, 0.07336199581899142]], {-151., -54.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Tarvos\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915452211713244],
     FontColor->RGBColor[0.31827505306025683`, 0.715, 0.3808317506505822]], {-152., -39.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Paaliaq\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154528662856415`],
     FontColor->RGBColor[
      0.7896667828057927, 0.3575666434388414, 0.4213886953236787]], {-133., 88.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Tethys\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029883571054395597`],
     FontColor->RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965]], {135., 86.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Iocaste\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519162711078`],
     FontColor->RGBColor[
      0.6102054708420535, 0.39696347534213544`, 0.7619863228948663]], {127., -102.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Erriapo\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451983497462],
     FontColor->RGBColor[
      0.26512246998569167`, 0.6229020240114467, 0.73314696398283]], {-123., -108.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Helene\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154549007674172`],
     FontColor->RGBColor[
      0.9492067688690977, 0.5394711792460651, 0.10728609198218791`]], {153., 61.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Sinope\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154607388455576`],
     FontColor->RGBColor[0.2187618985811806, 0.715, 0.5074848563512248]], {127., 105.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Bianca\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915462861783063],
     FontColor->RGBColor[0.7513196300394465, 0.358, 0.48066210763162087`]], {152., -64.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Mimas\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029199277531799794`],
     FontColor->RGBColor[
      0.8439466852489265, 0.3467106629502147, 0.3309221912517893]], {4., 126.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Rhea\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.031880193778288116`],
     FontColor->RGBColor[0.571589, 0.586483, 0.]], {-130., 100.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"Isonoe\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451902118191],
     FontColor->RGBColor[
      0.9986489531525362, 0.7507447657626809, 0.0036478264881522893`]], {-115., 118.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Kalyke\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519162711078`],
     FontColor->RGBColor[0.7989994773739094, 0.735166608597101, 0.]], {120., -114.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Carme\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154674614809913`],
     FontColor->RGBColor[0.428777913273419, 0.5052332520359486, 0.85]], {117., 117.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Thebe\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029156288047314072`],
     FontColor->RGBColor[
      0.8878600487784333, 0.33792799024431336`, 0.2577332520359445]], {-152., -67.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Janus\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915675863179445],
     FontColor->RGBColor[
      0.6184987019729621, 0.39212575718243875`, 0.7412532450675947]], {-140., -89.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Nereid\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029190962693236712`],
     FontColor->RGBColor[
      0.28240003484173815`, 0.6090799721266095, 0.7538800418100857]], {152., -76.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Skathi\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154519304240244`],
     FontColor->RGBColor[0.4567336004533182, 0.4884598397280091, 0.85]], {-155., 66.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Portia\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029156503879293794`],
     FontColor->RGBColor[0.7678998606330495, 0.7317110956258943, 0.]], {-118., -121.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Kiviuq\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154522824778276`],
     FontColor->RGBColor[0.7277983389807635, 0.358, 0.5168487092603637]], {130., 126.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Naiad\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154748917622608`],
     FontColor->RGBColor[
      0.9052934053395919, 0.510195603559728, 0.06776406480563275]], {-146., 112.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Aitne\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451898579962],
     FontColor->RGBColor[
      0.8064401951137368, 0.3542119609772526, 0.39343300814377197`]], {28., -26.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Juliet\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029155177043352874`],
     FontColor->RGBColor[0.7132613816472081, 0.358, 0.5392132590042952]], {155., 96.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Elara\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029155545019187157`],
     FontColor->RGBColor[
      0.35558897405758294`, 0.5505288207539337, 0.8417067688690995]], {-155., 41.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Dione\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.030447971681370107`],
     FontColor->RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {115., -126.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Atlas\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154521409486607`],
     FontColor->RGBColor[
      0.845266573755366, 0.437100139366951, 0.03816643438841502]], {-153., -101.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Leda\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154531847262674`],
     FontColor->RGBColor[0.5019668524892619, 0.46131988850644284`, 0.85]], {157., -101.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Metis\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915466046189321],
     FontColor->RGBColor[
      0.9784200278733908, 0.649600139366954, 0.058265924741844846`]], {-146., -119.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Puck\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029157935092995396`],
     FontColor->RGBColor[0.7748409210981391, 0.358, 0.4444755060028629]], {149., -114.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Narvi\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915451933962254],
     FontColor->RGBColor[
      0.8926354502560807, 0.366046824615879, 0.15658862564020168`]], {158., 72.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Ijiraq\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.02915452034801785],
     FontColor->RGBColor[0.9307395679624266, 0.7498043964402695, 0.]], {143., -126.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Ariel\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.030752029405590738`],
     FontColor->RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85]], {-144., 124.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Ymir\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154524770804317`],
     FontColor->RGBColor[0.38354466123747527`, 0.5323732032575149, 0.85]], {-159., 77.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"Pan\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.029154524770804317`],
     FontColor->RGBColor[
      0.9046334610863751, 0.334573307782725, 0.22977756485604156`]], {-155., 99.5},
     Center, Automatic]},
  DefaultBaseStyle->{"Graphics", FontFamily -> "Helvetica"},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-171.5, 171.5}, {-134., 134.}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[45]=",ExpressionUUID->"e03e0afa-99f6-420c-a304-e9eb96eaf1ca"]
}, Open  ]],

Cell[TextData[{
 "For what it does, the code here is surprisingly simple. But we can make it \
slightly more streamlined by using ",
 Cell[BoxData[
  ButtonBox["@*",
   BaseStyle->"Link",
   ButtonData->"Composition"]], "InlineCodeText",ExpressionUUID->
  "55aafae0-aa30-467e-b4e7-a57abc2332c0"],
 " or ",
 Cell[BoxData[
  ButtonBox["/*",
   BaseStyle->"Link",
   ButtonData->"RightComposition"]], "InlineCodeText",ExpressionUUID->
  "3e9b9694-0f61-439b-afce-d48959c72b38"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38ae046e-58bb-4b69-9aa4-e5a54bb4377b"],

Cell[TextData[{
 "We\[CloseCurlyQuote]ve seen before that we can write something like ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x", "]"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "42b0aaf9-5ac9-48f3-ae44-c25683069e2b"],
 " as ",
 Cell[BoxData[
  RowBox[{"f", 
   ButtonBox["@",
    BaseStyle->"Link",
    ButtonData->"Prefix"], "g", 
   ButtonBox["@",
    BaseStyle->"Link",
    ButtonData->"Prefix"], "x"}]], "InlineCodeText",ExpressionUUID->
  "4d1e8084-56fb-4632-8694-4f81ca117e57"],
 " or ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["//",
    BaseStyle->"Link",
    ButtonData->"Postfix"], "g", 
   ButtonBox["//",
    BaseStyle->"Link",
    ButtonData->"Postfix"], "f"}]], "InlineCodeText",ExpressionUUID->
  "77c4f3a9-ed9d-4a21-bb9e-8848a5162478"],
 ". We can also write it ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"g", "[", 
     ButtonBox["#",
      BaseStyle->"Link",
      ButtonData->"Slot"], "]"}], "]"}], 
   RowBox[{
    ButtonBox["&",
     BaseStyle->"Link",
     ButtonData->"Function"], "[", "x", "]"}]}]], "InlineCodeText",
  ExpressionUUID->"b52378e8-ccff-4f06-a331-3c3dc38bdbc2"],
 ". But what about ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"g", "[", 
     ButtonBox["#",
      BaseStyle->"Link",
      ButtonData->"Slot"], "]"}], "]"}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCodeText",ExpressionUUID->
  "a9fb5039-207d-4a0b-b34c-b2d3068d7dd0"],
 "? Is there a short way to write this? The answer is that there is, in terms \
of the ",
 StyleBox["function composition operators",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["@*",
   BaseStyle->"Link",
   ButtonData->"Composition"]], "InlineCodeText",ExpressionUUID->
  "867fef44-1cd6-4147-80b3-d59541df86d9"],
 " and ",
 Cell[BoxData[
  ButtonBox["/*",
   BaseStyle->"Link",
   ButtonData->"RightComposition"]], "InlineCodeText",ExpressionUUID->
  "5bbc3834-1d70-4c96-8016-2861dec1a364"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"288f8536-7358-4568-8fb4-f95e21169494"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"f", 
   ButtonBox["@*",
    BaseStyle->"Link",
    ButtonData->"Composition"], "g", 
   ButtonBox["@*",
    BaseStyle->"Link",
    ButtonData->"Composition"], "h"}]], "InlineCode",ExpressionUUID->
  "aca1f526-4f6d-4090-8702-9fc915cf83f2"],
 " represents a composition of functions to be applied right-to-left:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"b4cb821e-1a4b-4750-a627-6850dfc4fe8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"f", "@*", "g", "@*", "h"}], ")"}], "[", "x", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[46]:=",ExpressionUUID->"edfc5a42-83bb-423b-bad7-bacc7ff18bff"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "x", "]"}], "]"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[46]=",ExpressionUUID->"80079c24-2584-4bff-906f-19dadbeab20a"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"h", 
   ButtonBox["/*",
    BaseStyle->"Link",
    ButtonData->"RightComposition"], "g", 
   ButtonBox["/*",
    BaseStyle->"Link",
    ButtonData->"RightComposition"], "f"}]], "InlineCode",ExpressionUUID->
  "ee53128b-1fcb-4942-abc6-2684b47b055b"],
 " represents a composition of functions to be applied left-to-right:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"74081cda-5de2-4dcc-9dbb-bb3422ee6b30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"h", "/*", "g", "/*", "f"}], ")"}], "[", "x", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[47]:=",ExpressionUUID->"bc5b47dc-e519-4fd8-9686-7eb602e25e67"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "x", "]"}], "]"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[47]=",ExpressionUUID->"34758873-4631-46bf-aea5-8787411c5c7e"]
}, Open  ]],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s the previous code rewritten using composition ",
 Cell[BoxData[
  ButtonBox["@*",
   BaseStyle->"Link",
   ButtonData->"Composition"]], "InlineCode",ExpressionUUID->
  "ea16b7d8-d839-4aaf-aeef-ec116e6f7f8e"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dde5874c-c7b9-4644-894a-d1cecb717ad8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{
   RowBox[{"WordCloud", "@*", "Association", "@*", "Values"}], ",", 
   "\"\<Moons\>\"", ",", "All", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[48]:=",ExpressionUUID->"139a0aa5-709d-4ec2-8adc-c2992015f5dc"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     StyleBox["\<\"Ganymede\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.2046783625730994],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], InsetBox[
     StyleBox["\<\"Titan\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.2046783625730994],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {0., 43.}], InsetBox[
     StyleBox["\<\"Callisto\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.15662098889738937`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {0., -52.}], 
    InsetBox[
     StyleBox["\<\"Moon\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.116229548295786],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {43., 77.}], 
    InsetBox[
     StyleBox["\<\"Europa\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.086065561799023],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {0., -85.}], 
    InsetBox[
     StyleBox["\<\"Io\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.13498580694136814`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {-82., 36.}], 
    InsetBox[
     StyleBox["\<\"Triton\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.05457481638507435],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {-30., 84.}], 
    InsetBox[
     StyleBox["\<\"Desdemona\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923997720433354],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6361597700445392, 0.7170733077827265, 0.]], {98., -29.}], InsetBox[
     StyleBox["\<\"Prometheus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923998714034319],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6536293927965667, 0.37163285420200276`, 
        0.6534265180085832]], {-14., -102.}], InsetBox[
     StyleBox["\<\"Epimetheus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924038883901905],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.37977756485605163`, 0.715, 0.3025558265468435]], {0., 103.}], 
    InsetBox[
     StyleBox["\<\"S/2007 S2\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766241757705`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8774935098648088, 0.34000129802703827`, 
        0.2750108168919853]], {-73., -76.}], InsetBox[
     StyleBox["\<\"Enceladus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02936769218837668],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.838355547812947, 0.44746667828057946`, 
        0.0208888695323676]], {73., -76.}], InsetBox[
     StyleBox["\<\"Eurydome\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8949268664259606, 0.5032845776173072, 
        0.05843417978336459]], {99., 39.}], InsetBox[
     StyleBox["\<\"Hermippe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766170585716`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7042770479220728, 0.358, 0.5530353108891188]], {51., 97.}], 
    InsetBox[
     StyleBox["\<\"Harpalyke\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766206071466`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.3383114092015346, 0.5643508726387724, 
        0.8209736910418415]], {98., 51.}], InsetBox[
     StyleBox["\<\"Amalthea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029242214580792302`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8613800418100862, 0.48092002787339083`, 
        0.02824203762907758]], {-51., 99.}], InsetBox[
     StyleBox["\<\"Chaldene\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976615284284],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8633598745697435, 0.40996018814538476`, 
        0.08339968642435877]], {44., -103.}], InsetBox[
     StyleBox["\<\"Mundilfari\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9840111653093676, 0.677555826546838, 
        0.04316985366470745]], {-71., -88.}], InsetBox[
     StyleBox["\<\"Megaclite\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.4567336004533182, 0.4884598397280091, 0.85]], {-109., -29.}], 
    InsetBox[
     StyleBox["\<\"Themisto\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976688030069],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.922066817647527, 0.5213778784316846, 
        0.08286013588277422]], {71., -88.}], InsetBox[
     StyleBox["\<\"Callirrhoe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239767093215185`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9307395679624266, 0.7498043964402695, 0.]], {-78., 82.}], InsetBox[
     StyleBox["\<\"Stephano\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977316127822],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6319174318193065, 0.38429816477207124`, 
        0.7077064204517338]], {0., -114.}], InsetBox[
     StyleBox["\<\"Thalassa\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240209635987863`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8564488486273256, 0.42032672705901153`, 
        0.06612212156831418]], {107., -41.}], InsetBox[
     StyleBox["\<\"Adrastea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239774935565656`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.19193353076984873`, 0.681453175384121, 
        0.6453202369238185]], {0., 115.}], InsetBox[
     StyleBox["\<\"Pasiphae\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240120921615983`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8168067340273636, 0.3521386531945273, 
        0.3761554432877274]], {-111., -43.}], InsetBox[
     StyleBox["\<\"Praxidike\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976657867183],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6670481226429111, 0.3638052617916352, 
        0.6198796933927223]], {-65., -100.}], InsetBox[
     StyleBox["\<\"Prospero\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979090415259],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.47929071933511125`, 0.715, 0.1759027208462221]], {43., 112.}], 
    InsetBox[
     StyleBox["\<\"Cressida\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924017237595167],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9810598048862722, 0.7553955338762525, 0.]], {-101., 64.}], InsetBox[
     StyleBox["\<\"Hyperion\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924633092764745],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5407932311309059, 0.715, 0.09762679674248334]], {109., -53.}], 
    InsetBox[
     StyleBox["\<\"Iapetus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.03137778242639052],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-43., -113.}], InsetBox[
     StyleBox["\<\"Oberon\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.03280785810106538],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {-48., 111.}], 
    InsetBox[
     StyleBox["\<\"Autonoe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766170585716`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9603267270590103, 0.5591336352950514, 
        0.10711783694067224`]], {-109., -55.}], InsetBox[
     StyleBox["\<\"Cordelia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239819292751594`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8493197142977551, 0.7407577460330839, 0.]], {43., -115.}], InsetBox[
     StyleBox["\<\"Lysithea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239840584200847`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8342400905885153, 0.4628267270590103, 
        0.0038160815296638794`]], {2., -126.}], InsetBox[
     StyleBox["\<\"Rosalind\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240067692992856`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.23716678280579248`, 0.645266573755366, 
        0.699600139366951]], {6., 126.}], InsetBox[
     StyleBox["\<\"Titania\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.03341466440471154],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[1, 0.75, 0]], {-119., 39.}], InsetBox[
     StyleBox["\<\"Orthosie\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766081871343`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9107287510704583, 0.33890687339431275`, 
        0.20182187767614543`]], {-40., 123.}], InsetBox[
     StyleBox["\<\"Taygete\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766259300085`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7989994773739094, 0.735166608597101, 0.]], {114., 65.}], InsetBox[
     StyleBox["\<\"Suttungr\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7658565873730018, 0.358, 0.4582975578876895]], {88., -99.}], InsetBox[
     StyleBox["\<\"Trinculo\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766951272186`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.26512246998569167`, 0.6229020240114467, 
        0.73314696398283]], {48., 122.}], InsetBox[
     StyleBox["\<\"Calypso\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977032241832],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.38354466123747527`, 0.5323732032575149, 0.85]], {95., 95.}], InsetBox[
     StyleBox["\<\"Pandora\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239942605728503`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9038177251280404, 0.3492734123079395, 
        0.18454431282010084`]], {-42., -126.}], InsetBox[
     StyleBox["\<\"Sycorax\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924613575602932],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8857244243136628, 0.3764133635295058, 
        0.1393110607841571]], {-95., 94.}], InsetBox[
     StyleBox["\<\"Miranda\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02931783471138119],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5833680111493557, 0.4126186601628758, 
        0.8290799721266107]], {-118., -67.}], InsetBox[
     StyleBox["\<\"Euanthe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.2198892179497479, 0.6590886256402017, 
        0.6788670615396974]], {118., -67.}], InsetBox[
     StyleBox["\<\"Erinome\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8064401951137368, 0.3542119609772526, 
        0.39343300814377197`]], {-120., 51.}], InsetBox[
     StyleBox["\<\"Setebos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979090415259],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8745421494417032, 0.39318677583744527`, 
        0.11135537360425793`]], {85., 107.}], InsetBox[
     StyleBox["\<\"Despina\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029242250066541055`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.16397784358994957`, 0.7038177251280403, 
        0.6117734123079395]], {113., 77.}], InsetBox[
     StyleBox["\<\"Euporie\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766081871343`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6453361616656581, 0.37647057236169945`, 
        0.6741595958358548]], {-81., -112.}], InsetBox[
     StyleBox["\<\"Ananke\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239801549877223`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.3103557220216354, 0.5867154223826917, 
        0.7874268664259625]], {-92., 105.}], InsetBox[
     StyleBox["\<\"Siarnaq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239812195601848`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8607200975568693, 0.34335598048862614`, 
        0.30296650407188447`]], {86., -111.}], InsetBox[
     StyleBox["\<\"Ophelia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239829938476222`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.596786740995709, 0.404791067752503, 
        0.7955331475107271]], {-116., -80.}], InsetBox[
     StyleBox["\<\"Phoebe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029249579647945622`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9324333565611593, 0.5282889043741062, 
        0.0921900209050434]], {117., -79.}], InsetBox[
     StyleBox["\<\"Thyone\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766170585716`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.4177882075393331, 0.715, 0.25417864494993975`]], {-120., 77.}], 
    InsetBox[
     StyleBox["\<\"Telesto\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977458070817],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8781534541180211, 0.4921023027453475, 
        0.04333810870621905]], {-105., -98.}], InsetBox[
     StyleBox["\<\"Paaliaq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239775822709375`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7896667828057927, 0.3575666434388414, 
        0.4213886953236787]], {-87., 117.}], InsetBox[
     StyleBox["\<\"Albiorix\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979090415259],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6897400905885174, 0.358, 0.5753998606330502]], {86., 119.}], InsetBox[
     StyleBox["\<\"Belinda\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924018834453861],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5472001045252132, 0.43417993728487203`, 0.85]], {141., 38.}], 
    InsetBox[
     StyleBox["\<\"Galatea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029244201782722377`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9874666782805795, 0.6948333914028977, 
        0.033839968642435214`]], {145., -29.}], InsetBox[
     StyleBox["\<\"Himalia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029247750357597496`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6753413537738198, 0.3589675436319385, 
        0.5991466155654507]], {82., -123.}], InsetBox[
     StyleBox["\<\"Proteus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029299382122030548`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8996399512215667, 0.7463488834690629, 0.]], {-82., -124.}], 
    InsetBox[
     StyleBox["\<\"Thrymr\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.15725938678540247`, 0.715, 0.5857607804549424]], {93., 25.}], 
    InsetBox[
     StyleBox["\<\"Erriapo\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976696901506],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8335801463353031, 0.3487839707329394, 
        0.3481997561078282]], {140., 51.}], InsetBox[
     StyleBox["\<\"Deimos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976780293016],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.845266573755366, 0.437100139366951, 
        0.03816643438841502]], {-150., -29.}], InsetBox[
     StyleBox["\<\"Phobos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977876447795],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9930578157165594, 0.7227890785827968, 
        0.01874389756528967]], {-140., 63.}], InsetBox[
     StyleBox["\<\"Caliban\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240635464972874`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9637822400302223, 0.5764112001511111, 
        0.0977879519184]], {148., -41.}], InsetBox[
     StyleBox["\<\"Larissa\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924562121267242],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.47401116530937026`, 0.47809330081437784`, 0.85]], {126., -91.}], 
    InsetBox[
     StyleBox["\<\"Umbriel\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.030627258840301846`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9728288904374106, 0.621644452187053, 
        0.07336199581899142]], {150., -53.}], InsetBox[
     StyleBox["\<\"Tarvos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239769257845858`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7277983389807635, 0.358, 0.5168487092603637]], {-147., -52.}], 
    InsetBox[
     StyleBox["\<\"Tethys\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029970949917147712`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28026441037696703`, 0.715, 0.4292089322474965]], {133., 88.}], 
    InsetBox[
     StyleBox["\<\"Iocaste\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976629478584],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8510135028964549, 0.47400900193096995`, 
        0.018912152606809424`]], {-132., 89.}], InsetBox[
     StyleBox["\<\"Helene\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979622701491],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9492067688690977, 0.5394711792460651, 
        0.10728609198218791`]], {-117., -109.}], InsetBox[
     StyleBox["\<\"Sinope\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239854778500347`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.2187618985811806, 0.715, 0.5074848563512248]], {122., 105.}], 
    InsetBox[
     StyleBox["\<\"Bianca\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239876069949596`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7513196300394465, 0.358, 0.48066210763162087`]], {125., -103.}], 
    InsetBox[
     StyleBox["\<\"Nereid\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02927631638534224],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28240003484173815`, 0.6090799721266095, 
        0.7538800418100857]], {149., 62.}], InsetBox[
     StyleBox["\<\"Mimas\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029284655536298783`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8439466852489265, 0.3467106629502147, 
        0.3309221912517893]], {-132., 100.}], InsetBox[
     StyleBox["\<\"Rhea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.031973410719180036`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.571589, 0.586483, 0.]], {-154., 41.}], InsetBox[
     StyleBox["\<\"Isonoe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976615284284],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.529922539669161, 0.44454647619850335`, 0.85]], {-154., -62.}], 
    InsetBox[
     StyleBox["\<\"Kalyke\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976629478584],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6102054708420535, 0.39696347534213544`, 
        0.7619863228948663]], {-140., -92.}], InsetBox[
     StyleBox["\<\"Carme\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239922201422974`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.428777913273419, 0.5052332520359486, 0.85]], {122., -114.}], InsetBox[
     StyleBox["\<\"Thebe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029241540351566033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8878600487784333, 0.33792799024431336`, 
        0.2577332520359445]], {121., 116.}], InsetBox[
     StyleBox["\<\"Janus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924201231202442],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6184987019729621, 0.39212575718243875`, 
        0.7412532450675947]], {154., -66.}], InsetBox[
     StyleBox["\<\"Skathi\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976643672883],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8926354502560807, 0.366046824615879, 
        0.15658862564020168`]], {-120., 116.}], InsetBox[
     StyleBox["\<\"Portia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029241756814633414`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7678998606330495, 0.7317110956258943, 0.]], {-116., -121.}], InsetBox[
     StyleBox["\<\"Kiviuq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239769967560832`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.969373377466199, 0.6043668873309952, 
        0.08269188084126262]], {-150., -76.}], InsetBox[
     StyleBox["\<\"Naiad\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239996721495354`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9052934053395919, 0.510195603559728, 
        0.06776406480563275]], {-153., 75.}], InsetBox[
     StyleBox["\<\"Aitne\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9986489531525362, 0.7507447657626809, 
        0.0036478264881522893`]], {28., -27.}], InsetBox[
     StyleBox["\<\"Juliet\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240426099055243`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7132613816472081, 0.358, 0.5392132590042952]], {150., -78.}], 
    InsetBox[
     StyleBox["\<\"Elara\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240795150842255`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.35558897405758294`, 0.5505288207539337, 
        0.8417067688690995]], {114., -126.}], InsetBox[
     StyleBox["\<\"Dione\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.030537000838353076`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.736782672705901, 0.358, 0.5030266573755369]], {154., 97.}], 
    InsetBox[
     StyleBox["\<\"Atlas\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239768548130884`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.31827505306025683`, 0.715, 0.3808317506505822]], {154., 74.}], 
    InsetBox[
     StyleBox["\<\"Leda\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239779016426763`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5019668524892619, 0.46131988850644284`, 0.85]], {157., -90.}], 
    InsetBox[
     StyleBox["\<\"Metis\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239908007123474`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9784200278733908, 0.649600139366954, 
        0.058265924741844846`]], {-148., -106.}], InsetBox[
     StyleBox["\<\"Puck\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.0292431922131704],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7748409210981391, 0.358, 0.4444755060028629]], {155., -103.}], 
    InsetBox[
     StyleBox["\<\"Narvi\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976647221458],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5788038738141875, 0.715, 0.049249615145579635`]], {-149., 112.}], 
    InsetBox[
     StyleBox["\<\"Ijiraq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239767483558415`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5750747800184488, 0.4174563783225715, 
        0.8498130499538777]], {-143., -118.}], InsetBox[
     StyleBox["\<\"Ariel\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.030841947620246835`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.40082222609352647`, 0.5220066643438841, 0.85]], {152., 107.}], 
    InsetBox[
     StyleBox["\<\"Ymir\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977191927701],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9046334610863751, 0.334573307782725, 
        0.22977756485604156`]], {137., 125.}], InsetBox[
     StyleBox["\<\"Kale\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766081871343`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6672593867853922, 0.7205288207539324, 0.]], {140., -126.}], 
    InsetBox[
     StyleBox["\<\"Pan\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977191927701],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7175796237092107, 0.7261199581899123, 0.]], {-160., 87.}]}},
  Background->GrayLevel[0, 0],
  ImageSize->{199.73828125, 151.},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-171.5, 170.5}, {-133.5, 133.5}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[48]=",ExpressionUUID->"cb99eff0-73a7-44dd-821f-df4c178567be"]
}, Open  ]],

Cell[TextData[{
 "And using right composition ",
 Cell[BoxData[
  ButtonBox["/*",
   BaseStyle->"Link",
   ButtonData->"RightComposition"]], "InlineCode",ExpressionUUID->
  "50d9e482-3899-4948-85dc-2a49cd10269c"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:281",ExpressionUUID->"1baa224e-4c7a-4cc5-b373-e05a790fda85"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"planets", "[", 
  RowBox[{
   RowBox[{"Values", "/*", "Association", "/*", "WordCloud"}], ",", 
   "\"\<Moons\>\"", ",", "All", ",", "\"\<Mass\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[49]:=",ExpressionUUID->"b91f9cd3-713b-49b4-b780-894513fbeea5"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     StyleBox["\<\"Ganymede\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.2046783625730994],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], InsetBox[
     StyleBox["\<\"Titan\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.2046783625730994],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {0., 43.}], InsetBox[
     StyleBox["\<\"Callisto\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.15662098889738937`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {0., -52.}], 
    InsetBox[
     StyleBox["\<\"Moon\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.116229548295786],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {43., 77.}], 
    InsetBox[
     StyleBox["\<\"Europa\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.086065561799023],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {0., -85.}], 
    InsetBox[
     StyleBox["\<\"Io\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.13498580694136814`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {-82., 36.}], 
    InsetBox[
     StyleBox["\<\"Triton\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.05457481638507435],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {-30., 84.}], 
    InsetBox[
     StyleBox["\<\"Desdemona\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923997720433354],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6361597700445392, 0.7170733077827265, 0.]], {98., -29.}], InsetBox[
     StyleBox["\<\"Prometheus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923998714034319],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6536293927965667, 0.37163285420200276`, 
        0.6534265180085832]], {-14., -102.}], InsetBox[
     StyleBox["\<\"Epimetheus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924038883901905],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.37977756485605163`, 0.715, 0.3025558265468435]], {0., 103.}], 
    InsetBox[
     StyleBox["\<\"S/2007 S2\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766241757705`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8774935098648088, 0.34000129802703827`, 
        0.2750108168919853]], {-73., -76.}], InsetBox[
     StyleBox["\<\"Enceladus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02936769218837668],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.838355547812947, 0.44746667828057946`, 
        0.0208888695323676]], {73., -76.}], InsetBox[
     StyleBox["\<\"Eurydome\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8949268664259606, 0.5032845776173072, 
        0.05843417978336459]], {99., 39.}], InsetBox[
     StyleBox["\<\"Hermippe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766170585716`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7042770479220728, 0.358, 0.5530353108891188]], {51., 97.}], 
    InsetBox[
     StyleBox["\<\"Harpalyke\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766206071466`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.3383114092015346, 0.5643508726387724, 
        0.8209736910418415]], {98., 51.}], InsetBox[
     StyleBox["\<\"Amalthea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029242214580792302`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8613800418100862, 0.48092002787339083`, 
        0.02824203762907758]], {-51., 99.}], InsetBox[
     StyleBox["\<\"Chaldene\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976615284284],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8633598745697435, 0.40996018814538476`, 
        0.08339968642435877]], {44., -103.}], InsetBox[
     StyleBox["\<\"Mundilfari\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9840111653093676, 0.677555826546838, 
        0.04316985366470745]], {-71., -88.}], InsetBox[
     StyleBox["\<\"Megaclite\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.4567336004533182, 0.4884598397280091, 0.85]], {-109., -29.}], 
    InsetBox[
     StyleBox["\<\"Themisto\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976688030069],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.922066817647527, 0.5213778784316846, 
        0.08286013588277422]], {71., -88.}], InsetBox[
     StyleBox["\<\"Callirrhoe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239767093215185`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9307395679624266, 0.7498043964402695, 0.]], {-78., 82.}], InsetBox[
     StyleBox["\<\"Stephano\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977316127822],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6319174318193065, 0.38429816477207124`, 
        0.7077064204517338]], {0., -114.}], InsetBox[
     StyleBox["\<\"Thalassa\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240209635987863`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8564488486273256, 0.42032672705901153`, 
        0.06612212156831418]], {107., -41.}], InsetBox[
     StyleBox["\<\"Adrastea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239774935565656`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.19193353076984873`, 0.681453175384121, 
        0.6453202369238185]], {0., 115.}], InsetBox[
     StyleBox["\<\"Pasiphae\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240120921615983`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8168067340273636, 0.3521386531945273, 
        0.3761554432877274]], {-111., -43.}], InsetBox[
     StyleBox["\<\"Praxidike\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976657867183],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6670481226429111, 0.3638052617916352, 
        0.6198796933927223]], {-65., -100.}], InsetBox[
     StyleBox["\<\"Prospero\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979090415259],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.47929071933511125`, 0.715, 0.1759027208462221]], {43., 112.}], 
    InsetBox[
     StyleBox["\<\"Cressida\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924017237595167],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9810598048862722, 0.7553955338762525, 0.]], {-101., 64.}], InsetBox[
     StyleBox["\<\"Hyperion\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924633092764745],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5407932311309059, 0.715, 0.09762679674248334]], {109., -53.}], 
    InsetBox[
     StyleBox["\<\"Iapetus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.03137778242639052],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-43., -113.}], InsetBox[
     StyleBox["\<\"Oberon\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.03280785810106538],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {-48., 111.}], 
    InsetBox[
     StyleBox["\<\"Autonoe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766170585716`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9603267270590103, 0.5591336352950514, 
        0.10711783694067224`]], {-109., -55.}], InsetBox[
     StyleBox["\<\"Cordelia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239819292751594`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8493197142977551, 0.7407577460330839, 0.]], {43., -115.}], InsetBox[
     StyleBox["\<\"Lysithea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239840584200847`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8342400905885153, 0.4628267270590103, 
        0.0038160815296638794`]], {2., -126.}], InsetBox[
     StyleBox["\<\"Rosalind\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240067692992856`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.23716678280579248`, 0.645266573755366, 
        0.699600139366951]], {6., 126.}], InsetBox[
     StyleBox["\<\"Titania\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.03341466440471154],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[1, 0.75, 0]], {-119., 39.}], InsetBox[
     StyleBox["\<\"Orthosie\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766081871343`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9107287510704583, 0.33890687339431275`, 
        0.20182187767614543`]], {-40., 123.}], InsetBox[
     StyleBox["\<\"Taygete\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766259300085`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7989994773739094, 0.735166608597101, 0.]], {114., 65.}], InsetBox[
     StyleBox["\<\"Suttungr\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7658565873730018, 0.358, 0.4582975578876895]], {88., -99.}], InsetBox[
     StyleBox["\<\"Trinculo\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766951272186`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.26512246998569167`, 0.6229020240114467, 
        0.73314696398283]], {48., 122.}], InsetBox[
     StyleBox["\<\"Calypso\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977032241832],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.38354466123747527`, 0.5323732032575149, 0.85]], {95., 95.}], InsetBox[
     StyleBox["\<\"Pandora\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239942605728503`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9038177251280404, 0.3492734123079395, 
        0.18454431282010084`]], {-42., -126.}], InsetBox[
     StyleBox["\<\"Sycorax\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924613575602932],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8857244243136628, 0.3764133635295058, 
        0.1393110607841571]], {-95., 94.}], InsetBox[
     StyleBox["\<\"Miranda\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02931783471138119],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5833680111493557, 0.4126186601628758, 
        0.8290799721266107]], {-118., -67.}], InsetBox[
     StyleBox["\<\"Euanthe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.2198892179497479, 0.6590886256402017, 
        0.6788670615396974]], {118., -67.}], InsetBox[
     StyleBox["\<\"Erinome\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8064401951137368, 0.3542119609772526, 
        0.39343300814377197`]], {-120., 51.}], InsetBox[
     StyleBox["\<\"Setebos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979090415259],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8745421494417032, 0.39318677583744527`, 
        0.11135537360425793`]], {85., 107.}], InsetBox[
     StyleBox["\<\"Despina\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029242250066541055`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.16397784358994957`, 0.7038177251280403, 
        0.6117734123079395]], {113., 77.}], InsetBox[
     StyleBox["\<\"Euporie\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766081871343`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6453361616656581, 0.37647057236169945`, 
        0.6741595958358548]], {-81., -112.}], InsetBox[
     StyleBox["\<\"Ananke\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239801549877223`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.3103557220216354, 0.5867154223826917, 
        0.7874268664259625]], {-92., 105.}], InsetBox[
     StyleBox["\<\"Siarnaq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239812195601848`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8607200975568693, 0.34335598048862614`, 
        0.30296650407188447`]], {86., -111.}], InsetBox[
     StyleBox["\<\"Ophelia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239829938476222`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.596786740995709, 0.404791067752503, 
        0.7955331475107271]], {-116., -80.}], InsetBox[
     StyleBox["\<\"Phoebe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029249579647945622`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9324333565611593, 0.5282889043741062, 
        0.0921900209050434]], {117., -79.}], InsetBox[
     StyleBox["\<\"Thyone\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766170585716`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.4177882075393331, 0.715, 0.25417864494993975`]], {-120., 77.}], 
    InsetBox[
     StyleBox["\<\"Telesto\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977458070817],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8781534541180211, 0.4921023027453475, 
        0.04333810870621905]], {-105., -98.}], InsetBox[
     StyleBox["\<\"Paaliaq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239775822709375`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7896667828057927, 0.3575666434388414, 
        0.4213886953236787]], {-87., 117.}], InsetBox[
     StyleBox["\<\"Albiorix\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979090415259],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6897400905885174, 0.358, 0.5753998606330502]], {86., 119.}], InsetBox[
     StyleBox["\<\"Belinda\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924018834453861],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5472001045252132, 0.43417993728487203`, 0.85]], {141., 38.}], 
    InsetBox[
     StyleBox["\<\"Galatea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029244201782722377`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9874666782805795, 0.6948333914028977, 
        0.033839968642435214`]], {145., -29.}], InsetBox[
     StyleBox["\<\"Himalia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029247750357597496`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6753413537738198, 0.3589675436319385, 
        0.5991466155654507]], {82., -123.}], InsetBox[
     StyleBox["\<\"Proteus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029299382122030548`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8996399512215667, 0.7463488834690629, 0.]], {-82., -124.}], 
    InsetBox[
     StyleBox["\<\"Thrymr\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766312528708`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.15725938678540247`, 0.715, 0.5857607804549424]], {93., 25.}], 
    InsetBox[
     StyleBox["\<\"Erriapo\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976696901506],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8335801463353031, 0.3487839707329394, 
        0.3481997561078282]], {140., 51.}], InsetBox[
     StyleBox["\<\"Deimos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976780293016],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.845266573755366, 0.437100139366951, 
        0.03816643438841502]], {-150., -29.}], InsetBox[
     StyleBox["\<\"Phobos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977876447795],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9930578157165594, 0.7227890785827968, 
        0.01874389756528967]], {-140., 63.}], InsetBox[
     StyleBox["\<\"Caliban\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240635464972874`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9637822400302223, 0.5764112001511111, 
        0.0977879519184]], {148., -41.}], InsetBox[
     StyleBox["\<\"Larissa\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924562121267242],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.47401116530937026`, 0.47809330081437784`, 0.85]], {126., -91.}], 
    InsetBox[
     StyleBox["\<\"Umbriel\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.030627258840301846`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9728288904374106, 0.621644452187053, 
        0.07336199581899142]], {150., -53.}], InsetBox[
     StyleBox["\<\"Tarvos\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239769257845858`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7277983389807635, 0.358, 0.5168487092603637]], {-147., -52.}], 
    InsetBox[
     StyleBox["\<\"Tethys\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029970949917147712`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28026441037696703`, 0.715, 0.4292089322474965]], {133., 88.}], 
    InsetBox[
     StyleBox["\<\"Iocaste\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976629478584],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8510135028964549, 0.47400900193096995`, 
        0.018912152606809424`]], {-132., 89.}], InsetBox[
     StyleBox["\<\"Helene\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923979622701491],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9492067688690977, 0.5394711792460651, 
        0.10728609198218791`]], {-117., -109.}], InsetBox[
     StyleBox["\<\"Sinope\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239854778500347`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.2187618985811806, 0.715, 0.5074848563512248]], {122., 105.}], 
    InsetBox[
     StyleBox["\<\"Bianca\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239876069949596`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7513196300394465, 0.358, 0.48066210763162087`]], {125., -103.}], 
    InsetBox[
     StyleBox["\<\"Nereid\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02927631638534224],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28240003484173815`, 0.6090799721266095, 
        0.7538800418100857]], {149., 62.}], InsetBox[
     StyleBox["\<\"Mimas\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029284655536298783`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8439466852489265, 0.3467106629502147, 
        0.3309221912517893]], {-132., 100.}], InsetBox[
     StyleBox["\<\"Rhea\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.031973410719180036`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.571589, 0.586483, 0.]], {-154., 41.}], InsetBox[
     StyleBox["\<\"Isonoe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976615284284],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.529922539669161, 0.44454647619850335`, 0.85]], {-154., -62.}], 
    InsetBox[
     StyleBox["\<\"Kalyke\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976629478584],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6102054708420535, 0.39696347534213544`, 
        0.7619863228948663]], {-140., -92.}], InsetBox[
     StyleBox["\<\"Carme\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239922201422974`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.428777913273419, 0.5052332520359486, 0.85]], {122., -114.}], InsetBox[
     StyleBox["\<\"Thebe\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029241540351566033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8878600487784333, 0.33792799024431336`, 
        0.2577332520359445]], {121., 116.}], InsetBox[
     StyleBox["\<\"Janus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02924201231202442],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6184987019729621, 0.39212575718243875`, 
        0.7412532450675947]], {154., -66.}], InsetBox[
     StyleBox["\<\"Skathi\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976643672883],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8926354502560807, 0.366046824615879, 
        0.15658862564020168`]], {-120., 116.}], InsetBox[
     StyleBox["\<\"Portia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029241756814633414`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7678998606330495, 0.7317110956258943, 0.]], {-116., -121.}], InsetBox[
     StyleBox["\<\"Kiviuq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239769967560832`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.969373377466199, 0.6043668873309952, 
        0.08269188084126262]], {-150., -76.}], InsetBox[
     StyleBox["\<\"Naiad\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239996721495354`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9052934053395919, 0.510195603559728, 
        0.06776406480563275]], {-153., 75.}], InsetBox[
     StyleBox["\<\"Aitne\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766117357093`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9986489531525362, 0.7507447657626809, 
        0.0036478264881522893`]], {28., -27.}], InsetBox[
     StyleBox["\<\"Juliet\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240426099055243`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7132613816472081, 0.358, 0.5392132590042952]], {150., -78.}], 
    InsetBox[
     StyleBox["\<\"Elara\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029240795150842255`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.35558897405758294`, 0.5505288207539337, 
        0.8417067688690995]], {114., -126.}], InsetBox[
     StyleBox["\<\"Dione\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.030537000838353076`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.736782672705901, 0.358, 0.5030266573755369]], {154., 97.}], 
    InsetBox[
     StyleBox["\<\"Atlas\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239768548130884`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.31827505306025683`, 0.715, 0.3808317506505822]], {154., 74.}], 
    InsetBox[
     StyleBox["\<\"Leda\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239779016426763`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5019668524892619, 0.46131988850644284`, 0.85]], {157., -90.}], 
    InsetBox[
     StyleBox["\<\"Metis\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239908007123474`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9784200278733908, 0.649600139366954, 
        0.058265924741844846`]], {-148., -106.}], InsetBox[
     StyleBox["\<\"Puck\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.0292431922131704],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7748409210981391, 0.358, 0.4444755060028629]], {155., -103.}], 
    InsetBox[
     StyleBox["\<\"Narvi\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923976647221458],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5788038738141875, 0.715, 0.049249615145579635`]], {-149., 112.}], 
    InsetBox[
     StyleBox["\<\"Ijiraq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239767483558415`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5750747800184488, 0.4174563783225715, 
        0.8498130499538777]], {-143., -118.}], InsetBox[
     StyleBox["\<\"Ariel\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.030841947620246835`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.40082222609352647`, 0.5220066643438841, 0.85]], {152., 107.}], 
    InsetBox[
     StyleBox["\<\"Ymir\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977191927701],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9046334610863751, 0.334573307782725, 
        0.22977756485604156`]], {137., 125.}], InsetBox[
     StyleBox["\<\"Kale\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029239766081871343`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6672593867853922, 0.7205288207539324, 0.]], {140., -126.}], 
    InsetBox[
     StyleBox["\<\"Pan\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.02923977191927701],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7175796237092107, 0.7261199581899123, 0.]], {-160., 87.}]}},
  Background->GrayLevel[0, 0],
  ImageSize->{200.1953125, 154.},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-171.5, 170.5}, {-133.5, 133.5}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[49]=",ExpressionUUID->"da0a011c-c987-48b3-8a90-9d342c69e8ee"]
}, Open  ]],

Cell[TextData[{
 "As a final example, let\[CloseCurlyQuote]s look at another dataset\
\[LongDash]this time coming straight from the ",
 ButtonBox["Wolfram Data Repository",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://datarepository.wolfram.com"], None},
  ButtonNote->"http://datarepository.wolfram.com"],
 ". Here\[CloseCurlyQuote]s a webpage (about big meteors) from the repository:"
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7cc486ec-3457-4059-86b8-a0054ddce34e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvVl0XclxIKhZPuZzzpk5c+acPtPdcsuyVqsk2bKtxZYtWSIJktXqttu2
LLttj2W53d2lsexpH48sVXGpKiwsS7VIJvFAElxAEDvADVwAkAS4s1jcSQAE
sQOsvSwVq0otFd6byIx78+XN7ea9bwPACAbfebgvb2ZkRGRkRK7v/bNv/ru/
+B/f8573/M3/Ah//7k//7je/9a0//ft//7/CH7/7yN/8p2888vU/X/nI3379
G1//1q/+2f8EDz8GH93/83vew77nCAgICAgICAgICAgICAgICAgICAgICAgI
CAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgI
CAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgI
CAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgI
CAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgI
CAgICAgICAgICAgICAgICAgICJYgZLNZ5QsBAQEBAQEBAQEBAcGyB4yAlDho
eYdFxtplOcCX+/fvv/jii1NTU+Pj4xMTE+MEBAQEBAQEBAQEBATLAkSAMz09
DVEPxD62KOlBCAnlOv74xz8eHh4+ceLEkSNHjnI4duwYfIfPowQEBAQEBAQE
BAQEBMsLMNiBCAjioDfffLNywVm5QQl133777atXryJPzp07d/369Tt37kxN
Tc3MTM3NzczOTsMnISEhISEhISEhISHh8kCIdKamJsbGRq9du3Lu3JljHCAm
euedd4wR0zKGe/fu9ff39/X1vfDCC9PT07Ozs3NzcyIGpGCQkJCQkJCQkJCQ
kHB54Pw8hDvTeowDweGlS5cgJhoYGHjllVcwUFreISHWbmJi4ujRo0NDQ/AF
w0BgkcIcCgkJCQkJCQkJCQkJCZcBYmijhDz4ED4nJu6ePHkSosLJyclKh2ul
BQwGoZpHjhw5f/78zMyUI+ijeJCQkJCQkJCQkJCQcNmgLcCB59PTk2fOnDp6
9Ch8q3TQVlp47bXXoJpnz57FTYIyillU/KLPGBISEhISEhISEhISEi4/xAjo
7NnTx44de+ONNyodtJUK3n333cHBwRMnToiZQZoEJCQkJCQkJCQkJCQkBJye
njx+/PipU6cgbsotx42EY2NjEPCOjo7KC2gpJCQkJCQkJCQkJCQkfABRXhWJ
YdHw8PDRo0cnJydFMLgMokKswsLCwokTJ06fPq1Un+JBQkJCQkJCQkJCQsIH
EJVQiP85BxETxE04RSjHU0sdXn755SNHjoyMjMi1pmCQkJCQkJCQkJCQkJBQ
IE4Rvvrqq5UO4AoCPYa9cePGwMCAOEaGrhokJCQkJCQkJCQkJHyQUT5TRYRF
09OTfX19t27dcodXSwiQ+NOnT585c0quO8SGdIgoISEhISEhISEhISEhoJg7
g9Dp/PnzWQ5KVLVEAYg/duzYpUsX9SWyFBISEhISEhISEhISEj7IKGbKMFx6
/vnn+/r6RCRV2VCucIAqvPvuu0ePHr1y5QVRZVomSkhISEhISEhISEhIqN/E
d/nyZYieFhYWlkEwiPDTn/4UanTt2pWKc5uQkJCQkJCQkJCQkHAx45UrVyB6
ghiq0mFc0YDiwQcZaS6YkJCQkJCQkHDZoO7akbNXdKR4kHD5oel2lcpTRUhI
SEhISEhImAjJiysDUjxISEhISEhISEhISLiYkQLD0iHFg4TLD8liEBISEhIS
EhIuGwTXTj8FhbBYSPEg4XJCulKEkJCQkJCQkJCQ0B8pHiRcZigGjuALwBQB
AQEBAQEBAcHSBPDlZmbybt78/CxNERYdKR4kXGY4MnL7woVzJ04MHDt27CgB
AQEBAQEBAcESh/7+/lOnBsG9n5wcr7irufyQ4kHCJY3ybODY2OipU6dA+gMD
A5cuXbp58+bIyMgoAQEBAQEBAQHBkoU7d+5cu3bt9OnT4OP19fVdvnyZzxjO
oQdYkb1COE3pnqlkv85Oz0f91TnTXsiKb42keJBw6SI0HLFs4NatG2Aijh8/
PjExgfqczWYrrYwEBAQEBAQEBAQFgfDo3njjDQgGwc8fGhqampoSDmH5F5HK
oZwckOKfgh75y1w04lOeVHYRLMWDhEsU5YZz8+ZNEPr58+ffeecdNBrCdFBU
SEBAQEBAQECwbABCrL6+vpMnT05PT8o+YZknCvUITg/u5JkLREGkPCeoJysz
UjxIuERRNKixsVEwCxAMvvvuu5XWPgICAgICAgICgqKBcYT/xRdfPHbs2Llz
5+YqMcVmLFFMFNroUUI/fcawgkjxIOFSx9OnTx8/fvytt96qtOoREBAQEBAQ
EBAUE5R1XwJGRkYgJIRP9AbLv17UOBvoQ4y+ebDih6ZSPEi4pPHOnREQ99jY
WKX1joCAgICAgICAoJggB4PK57vvvnvixIkzZ86UM5LSl6QaV43mpwLhSXik
jPstWi9aXKB48IHCS5cu9fX1vfPOO0IBaMMgAQEBAQEBAcHyAIdfNzw8fOTI
kenp8oVR+ukx+Dl2Z+TkiYGuzvZdOxsbMlsQm3bv7OnuHBo8MTE+NmeaOrx8
+ZI8OUjxYBGB4sEHCgcHB8+dO6fbCooKCQgICAgICAiWMbz88svg89++fbv8
8ZQI4kZGbu/b1711y+Zt9Vtk3J6ph08MDLc21B86uP/u2KgSDG7b1kD7B0sE
SyIeVA4aWiTKMOfdlCpOsJiLHxgYAB0uXG1sq9NjX/F/XgZwxMV6BZXEqcl+
AEPvB7zKRjUrljqVE1K0+mIVumihIjxZ9rAIz7suFiWOqpEu2aCI1pLYe//+
ffD5r169Wjb/cz76/fTJExD3NdRnMAaE0G9H47bWluaO9taWvXsat0MgmOG/
ZiBghD/PnT09z53Yq5evNDZkIP2ctp2wIkjxYNnQdiztYlADB+LKZ2MtKk4z
ENDf33/z5s0Cdcbt69pS+jwvM/hUxL+yPgU9OD2+HvI84OBgyJJg1IOjuumA
OFMUiGWjQw9Lp6LFzbPMxBcLkgbpjmoWUno6YggE/OxnPwOfH2KZcnqewZeZ
qd5DByDKwxnAnTu2Hx/oGx25PR96zvjl1o2bfceOsMAwnCiEP69eeWFbw1aI
HzP1mxeJR03xYDlRWSTMLqycm7l54xpo0d7mppnwFpWKo6zt7W0t27Zmzpwe
moterLlIsK+v7/bt28VSniVtit2LZpP2Pv6sWNJMSwa8okUJqBc/mKuWVX91
fCEQYNSZJcqoJUp2BcFmMSo1xFTcSG2J6kPqZliUQTCjCBYWFjyzWk72pChQ
/ngQT4nhwWD99kw9xHRHDh+anBy3uceQ+O7Y6IH9PRAPQmI2ZbglmFLEeJDO
Fy0FLM54UMSAyvwaaMiunY1MPTINL1y6KN9IUkE6BRnXrlzFmW6gUMxxz4XH
Ky2GwBDjwcItYVNTUyaTmZ+f939l8UyOsBKzuX3dPYBKRwNfoI3X19eLqunk
3b17FxLs2bOHlozGwMKSHAYvHKB2oB6gJPfm1AZy8fyFjrb2xm3bQffw18XM
CrBbqOrlL3psbAwsDNiZ3OJmkQ6XL1+GLgC6BOX50qpFRSCRHS4DgPrJNBQr
N1GXCravRCAIxipAD5goNi+W7IB1UDrQoMd3sUUsXXtSXMC6y/Fg2fzSU0Mn
t+Eq0Ib6s2dO6Y50EDZKUR640IMnj+Pa0W3BIlI2XShSVtavpniwIoiin5qa
aG1pDoYLMg1jd0YWwxCBKH1mZurunbHtW7cF66K3Zp6/eH4+/KniPESEePDW
rVuFq009B5+OEvqO8fFxY1RlfF4eeOvN+5kt9acGh5TnQE9PTw920LblLkA2
iBiqrzyPLXRubg7efUBufrxw7vyO7Y1DQxEOQ6esCH3ZdM1KRUA9QEmgv8pl
8z9Bh4ia097aBiEh+9X07uKBe/Oz0EwUVS8PgJ5kOCyJ8XyZNoj09+zOu52L
mexFC7odxgGWLVu2gELiTAF+ATx8qBeTgT0Hm3Px/IVikQElysOeBYoSslI6
zQq2r3SA/T703bEpIfKSZQRyaWtpBUmlOL4gHz7PzyMPxRPsZQYHB2MzWVr2
pNRQ5vlBwNGR2+ASY1h3/twZz7eggVx+4Xm+TDSzNZwfhBBAeP40P1hcWLTx
oDrxNzuNc8e4nPj0qcHFEAwq1EL0BzEgqj3QuX1bw43rVxfDhkdBQ+HxIFpR
sKvM3Y2NBxey2Ikrr1uflx5wcvDq5SuBux4t/f79+/Wbt/T39xveCj/ZSOMW
5icY0zhgYGAAMh8fi+9MlwE0N+1BLslswd4cvy+n7livC/M8ttSDQRBP2BBE
/WbQOtswyCJkCPqrqOplJg9n4StiIpKCTBgONIEBsS04J3CA1Q5ncxgDQqDd
3toGkQV8CmTDegtZTAOIwXhRAIO1e/fuFSU3Fl1uYWsGRDUr2L5SAFCIIV58
PCjJQogJAjd8va2tDeSbS15lEATyUDzBXsYnoF5C9qQMIOLB8vil0A/u6+ni
p8dkDvcenDMVKoI7+fAZtmdwKx4sU4/zg7j3cE4KEGh+sIiwaONBZdb4xPF+
UAOMs44cPiRUqOJ0yohrpM+dPY2qCwgh4a2b1yu7qFVmlIgHCx3q5Nb+xfmY
jvL+j99EPsjxFHzanhdCUgLIhmP4WoHDt24DVXJ/pw8nspFGXv2kBB86dIiF
AzweXPadEagZ+ADnz58XT5iPV5+Po5fx7AlUCjUE/L287zc3D/GgcGaWRMXB
mjVwfwv/LCfN0MqEtixmXin24daNm4oBIUgBuh3GmSl1LCWqF2BtINaAd4tF
BgahYtiwQMA1A/Iq8Qq2r3QAQbqneouZRLmBQN+HEZw+4uoDIAiMKMWT2zdv
tbW0XrgQPyO8VOxJeaDM84N3Roe5976lcfvW6akJo98ub61CxGAQ3X4RD+Le
Q92zrQhSPFgenI0exnLxwjlUJ9CH7q6OuUpPExuplT+HTg5ivANk79rZODo6
vEiILNZ6UaxdbEfJfOAtwYCe7P/bnpcBoKC33rwPxPcf6wue5H/LHT7U27ht
uzsH6ONYH7458Ugj+Crw4sTd8cREL1HIRhw2EDo6Cfnfl1e/LFcH1EPMD+JT
9P2WlkMCNLMYVpsKLwOwVhZdG7YkAAzIju2N+vOlVYsKg8kOozL4RCJFZHUw
qqPtAk6ZG6vD5nvz+Y2lFWxf6UDMD8buHzTLK8siOMgEosJcivlByW1I+voS
tSclgjLvHzx5/AReLXF8oE+e5REE6Ivobly/Cp4zxI87tzEEa7B96zb4ZN+3
b624O41I8WDZUOjGrZvXt29rwPGBPU27JifH5QRiink+qlqlpsqNQEx/39Gt
DfVIdtPuneN371ScpXMFx4PCluJyOLDPr7/62kBfP5h3PCJDBDv3799va2nF
Y2fqQ8BX2lvbcDMIRlVKn4srTKDjGB+729vbC38CgnvAcubnkwhrDk96urqh
XHDA5KKDRNFgRO4Fhm/dNi96yeYgt96Dh+T0EDxePH8BSIJXoBT4jvGgvhMB
CAZWQErcIHZqcAjexQRDJweD9ZNb6qEI/CLvXhwfH4f4FN6CvhL4Jr+LMDc3
B54De4UvdsXc2E6ZbEA5VArIA1bk2SVxAB0PIA9fx5RQnG2vDYoVskLewisK
PzEN0AyUsCMRdjfBdyFEYMj87BxbL8RP3XnrrbeY0Hc3oRqwPXQYLknjCZgb
KExjY1giy+hdwV74hF+FbkAayAGE9fb9tyDnyOpfSUOY1Hq6lNqB2kB64Fjg
0/AXgLcgUy79hZycQybDCg3rBYCkInMgqysvXNYnmrGBzM1O458gEbBduHlQ
kT6wCPMHHYBKQRq2H4pzG6p5vH8A9AHSo0bhOivBExZj1mdQrOBoCS0NdDvL
6EdGwU/IUqxyoLq8FHgOtQA5oubI7YKpjbQcK/9WLtAiEBbQD9x47ZVXI6zn
9TK2MmYTQtGH7SffyqA6QMzzFy5C3ZFdtvEi+TkSAzljFdgUfNYpL7k6SC2a
He5zitYRKGHYHIBF2Bwc42DQunE7GwLkBrUQzRabwMWLF3PhwnWQGmPjtu2R
ZpuvZKDqUC4AEG8YTQoliJkAnUCtwq6mXbtBH22ykCMUkFpbG9dGXm5eGzmA
mKAuqGayiROFKVZIlCgELaqDnBSSiiRbyMKvMhtzYYNSqqBUU7EDWEGoDiRj
DaGnS2w2lKsjFAMaoJK52AUMdLImHHZGepgDVug6SKGnB5QEuL2/Z5++GQHb
vkyePEYkAJqSza4qkO+AwupgQ0A6A0WNthvIFuwJPIRSBgbyjQL4k40aW0gD
r4M9hDTwFugVvALfoQrIKD2sigyI8cqK+Vx5mQT8tCscM5EHY69duQqUoPJA
rUGN5U4HcsB4UB5RxCfilBibPYHvUEGc3FRohr5J6ABaTkWpGKP6+rGlYPuS
d4Uv0eiyzPODXZ3tuNVr+PbNRTWVUyBSPFgeFDpzd2wUgimcMm5s2HrxwjnQ
qNu3biBCqIh/yg8BSxcVzsxMQaF6iUbsaG/dnmnYxo8bbW1pngoj2QpisfYP
YkcJZhasqNgzjvEdRC45EQ/u2o2LNFpbW6Ffhk+wpWClMU5EpwI3g7z66quY
P2SLPhV6g/CWKAL6C2F+L1++jA/Rj8Vxy/y6kWzu9NApyEe5XANfB5NuHMOH
Th8ywTABn0BfIOI4URB2DdgrYUqoMnq/2DfhIWxYO0wAPQ5UE4nEHlnEYtCj
YSeLo6b4Hd/NSd0N20pfv/lI72F4KzjDFqca+e/ALvhza6YBGA6ZYMAVBHEc
IDCBRoTl4jYcwTQR7AgApmER6GEiPfDuG6+9LtJAlVEuGMDid3lAWO67URlw
EIDJNNz+IxxXKBE76+3bt0MypB9E//prr4hDxXPhrlWMFLBo3DqE2oIRljxs
DYJmUfOFc0oFQTcgfxZGSRxGX31n4w7IUDy8cO58Q0MDhPNCr3AwAYpDvwW/
Y13k3MT+QXzC3KqmXTiMAK1AjsSxKUGlUGewImACUY6KsJgvJ/lsuP8IMoew
EYca+PoaxuTXXnsNqy+3UBEKIYDXhGoplyKvysN4U5nShUYBokF5gbBAZEgb
MyzhibJsxazmwGfDrcfKnAtkyAIWTjY6n9hMMtr+UwVwqEG0LCAG22Z+Ft4i
L3gF+CPngzlAk8mEZ5XgJ/T4UAVgrHI4BopblkWOz0FAMgjxRM44KgL6CeIO
LGR9/djYGL6CzVahXAShOR7nYpNBtuAGqEvSGA7UAqMz5BgQhiMtwsgjYUKs
CgODMbpwVTNGQNiKRWWhsaAZgddxCxgqPI5ryWdjgh4KE4figz/l6oD64evC
0GEnkhcE/9TtsCB1cnwiF3XC9TSyauFo5Diu8OertaFxBbo9P4+qCxVBqyj3
IEJXgZ8Q3AmLJDgAHZBIBqSihqBxEy2OB1kqeXI8yNpv/Wa5K4FfkbE2u2oD
0DqwXVhuR1u7oAGYKasoPkSC6zlDsONghElqkMsFW+yRPyhN+IIWxnO9KJae
i7YR1sQyGYi8ZD6DBWDjqFx1MTRDDrClv1Lrx9YkmyN8olgJoz0Rxi1fbpZ1
UlgWjv+gDuRHWXP5BDgqKAhDDizRYDBX9nhw185G0DCc11tU534UiBQPlhkh
pMIDRSGw4nNtWxC3Z+q3btkMiH/i4IO4qaSrs73olODewO6uDlFWLLKjcfn8
IFALf7KVrpXmZxHPF0XjCS4NTg0wL5E7ZgMDA8L+s0G56BJBBNzcLS/ekAdR
Rdcsdp2DT4IPsSx4gp6P6JjAL+rv7xdHd4K3hr6TuBVCNt3y4LP8K5sh2lIv
n/+JvhZ6j8Llw5PTlJUnu3fvhteFlwjOBvYd6O3IfXFkSJyPf0JXBe8GMyzh
u1A7dE5EyAm6jZ0aTgGI4dP+Y33ooYnjfcDhxNIFPeh4YLgqJo/Q94B35V1+
LPDkdIpuEere09UNbgAOLCM9PT1s1ukEhFQLAQNxejQnlkfOzsEreS5lA29Z
rLMVz4M+HSR+7rwQH85qYfgjax327PDri/P33nzzTRAW5IPuq7oGic/2Qoli
qEEAOpyQDyaGkPPt+29B5szl3rxF+JPw/MC+/fBETMqIDSzCbwSpAXPk2F8m
NT/zko2eJSj5EcKZB5YC86FGqPagukNDQyJsgaJljQoe8niNxdFbt6HjDfSA
zQTvpbGxEcpip/nxyQsMPZBFAnACCPiAYzg5rt69vfmmgfODyvwFNgpwkoV2
geAy4Sy/YAIeBam7jorTDunFtPjrr78uBITxguwqC5D/ROaD+yeUH5x/nOJ3
yAvbSy5qdkQwfv/HbyLHmDPM2SisHGidaIMKPfA5dHIQMoF3xU84KoJ1gZgd
VFEIFOwVqBa47iJAADWTmy1kCAGLmNfDiU4oN5iS44WiyQU5BrLI5jDwVA7L
QiGKMF+8Hsx/Sace4fAdEAxcAuJBFdEe4lH/kA8QICapwW4Ex0Vmg7EXoIdJ
Nhu0d2yAQk+wdmIKBsQNTBC5CaqQjco5zEjq3TtjcmLZeoshCHmDHvYyYPRY
45qdA9ZhttC0cUwyOAA5mx+XY9QuZOVCsdGJzgi7CUA0LKyZzM9Dy4IGCGkw
0ABuoEorVcho84MiHkSAZuW2q+YYJKQfaBDqJyQiJ0TdwGlfVEWMxTJsT98x
kUyszBTLGKBqWCm527XSI43dyROOt2/fDnTgzlj+3YXAAgRqnM2rscou3pyV
eBCeKKfE6PYECJbtSTDGuJDFtsyG+7JBT4TJRF+M5gVarsgf+lbwcIxVXkJQ
5ngQneHWluY5vgtsZmZqeYSEFA+WDTH+YifySYGVCADFF4wN2aGj/AmePiQO
ICoiPWyjK59kwVOSQtxiRB7A1kspg+cV52oR48Ggs5B6AzaavXmLPN/EHO+M
Or+QywWbu9V1aBywT1cO4UQjHwxWo3OyeYtxjk+kZ1FbQ8PBgweVn8CeQxeg
TJQgYKAh/gRGKXMBCMH+wSjxzFuQFz5xtwH7OPEEq6av+JI9H9kjAh9GPMd4
MFi+JQF2iEAkm7yTwkzsT8XEFjYlSCZ7XzkcreV1DP5eyOYXiUn0gB+Frh2e
1YDxeAOejcB70kjQnQ3W9rDxXun0GDYIsHkLBIkRpzQbRCXCh8fnUCIWIc/w
oo9hPD8Qp1eE2mRD3dNnPwEgkERng3lEC8EIP1vId/4CUPj8hXA5H/dgoUTh
YgGpkODw4cNybiA+ZA5ODOVnFurz8aAcWyk+ObpYeqXUI/gWAkcUXBSRRsSY
8iDD1SsviDkF4TODh4NVxgg6Fy6m1dVbpk1ZL5rjjQL1DYImudli9ITaLjiA
A+mK0w6tUnbzcDIaGBhZ5chXuipDRjJhWC9Ig8TIk30yuOUlHzyCBk2eGoA8
dSsHheK8ieJmI1WBAclKDAzHOuRVl+h5QiY7G3cIzxPbApuPDh1U5pNnGGeU
4SMBoG8oQWVtOcb+eLmqPD9oi82VeBBnVZTlgL29QZ5GPmP4ANVRxl6gKYmY
glkwPsekME3/k42NSEoukxoxntnIDac4uZmJzg8G4a00iYmlAGHwk2xgc6Ex
lJfxYytWF/GGQyKQUqxeiESvWT4gyWe7ZIbExoNoV4MqWOyqzjfxRImgoei8
lQsBw1ul48Z5W9lU4nDckd5Iw8nxbdHsqq+xMblcY0gIMRokZoth+LogAD4j
GcxOyqXjDD5UHMysbAFkNcZnQZQqDU+J+UHxxGxPcuEpcML8hl2komnICrHU
BFS6wX5OAs0PeiIoOXi/7W0tysEgSx0pHiwPBtoyO93Z0Ya6FNw/wmcA8coJ
MSEo5uMwJIQvXZ3t8yUgCU/NDY45xTVFHvODfGZzM1JVccYWd72ovD0BQwBk
izw/qMSDCOPhYV+6RQ02Xs2otzmjp8Ssd5a5ysFcCd+JkzNZZugclW4LASJK
5hW/eV/5Cfsa6CPEE3CBGqRjZ2Ti1ZUnoTsnP0FvbfvWbeJFwxA3/xROhSga
u8jGxkbxBONBecpPro5YBCUAfADZPxcLk+RkWb72D0WGfgv0yMGorHRpMvuy
kMXRZhG14fzgge4e1onjo4WAA/gnSBDnB0VxYhGaXFk8n1/Mysn+AJZ46NAh
ZRLHeH7ghQsX8rM2PDnwBHwSZYOkEBY6PCyC44lZWRk2kYFrmWRnXrhJoHXB
zIvEHAQkVdyDlgv9alyJh0/ge329OteWC0fsgZIY7yIbaBS4KCKlvp4zFwZx
euMCdWIti08Fwk/g7ClhuMIikb/ICj4htmJTCdAoosSKwEcMONSHG4iU/IVX
jHmaW9lCVhlKUoJKfAgMZ+FedIREgENeuLxWlhdzX+u5ry6FGMgxZfeWqKlS
nDAgSuJgYcNr0vrSbLAUQXHLAd547XVcoIhWbidfOsis3EI2EhWiLA71QhPr
O3pMyeTF+XuKLOR4UG7XYn5QPESeK2s1kZPy1J4CUBGgZGhoSBEQWBVhhSAT
DMNxGYAxlGCW6t49nY25UG3YWspwQzrOc8k3nMJDIEP23jGlsmsgF86rKvNc
rJqZjAgSszjHncno2/cwlJCj40hF+P41aKfKVJp7vSgC2iWHXVVKDD5N/BRD
ajIN+blj6V5U+dxOHIvLiKUs0Tz1+UEjPaKybKELB1x5Wx9uo5DNAg4lgQlV
lAEbGvwkhrBQseu1/YOyrTPaExyNjMwkZnM4jag0Cigrwxc/4BMUB3zabg1e
oiFhReYH21r3yu59ZY/cLwpSPFhmxP2DuF4U8OKFc7h3Dzfx2fbxzUxPFpeM
/F0nM1M+Owdxb2NPR/u28JTRlr17lsf+QQS9a8uZlvcHu6I0H1h39pR+RO+C
gxApHF7GeYoMXwIHvbNsrhcMO93zgDvX5N4QAbt4MVyf40tAM3zTYi5q9sV5
MuKJGHKE+Bc43N7ezhZ6hfcmi44S78OVOyA5/IE4EfpEcFTEgTPy5Bpzk0y3
FeiOjYD6+nzsgFPbOs1iCHScryVj8uL7wkT+IlbFwXOxJhMXtaIIIKbQJz1x
cEBe76fMq8rMlEsUgBMx4qyAnLj10nSNO/jb8kQn/IT772SByq9A/Jjhi9/Q
/8dxbFy5hJlASjZdWJ+fLzCSit+ROWJxck6cLS/NDzLfz3T9YkZbFiUDyKW/
vx9oY6PrXDRyJAJ5Yrwm54kP9UEYbFliaWjTrt0N0e1dOmA8iE4UZo7zsPCW
7sk3RO8mQw/QOCclhAhv4cZbkaHIViwpz1mcrixfA5CJbriT+RArLxC6EgfJ
M2WCY/JxK9nsu8Y1tLlwwEqZqdQPUkbACSbl0CdBCVgP/I5GD+dZxJJFAbi8
WVRfWNFseN0JNuoc6pjpPBlFS3NhACWkgw8FJ2UeyoCbv9DJV36VWyWbhcc9
Ynv2QAM0+tjnz59Xmq0YYEGR4XwT2FicdRJDgjnT1lTUSeWeXDFQoDMfSmls
zB91EmiF1jbxOgzlBFTIFmSBx85guQrP3fODgaHm+7IddtUF2eBIGaRhW7jj
Ve5xMuE9OPK+bNlW58RUGiit1uxQPfRBHh3kdT6if4TagTVDzgSjNHy7hNyK
ZWdAMSngf8nmLqe5HA57otwaHIxDmi4uhIeiCwDO4CAG2EA8R0g3JksRyr9/
EC+biPjSS3+KkOLBMuM8P18UFAkXXu5p2sWiKud1fiWakhbZzsxMzcUpM9jb
/r6juMCvgZ8vevfuncWg/8WKB9HZU+Z09ME6jPvk5f0IuFZN8akiHVa4EUnO
SnWG+UmAmfDQTrHGQ35L+RNXzbEFgdmc/BwDAYwTxYvGE7NZ0MTnB0WlhPMZ
bLpvbDx06BB4O3hoiVxH7EzzZ+5Js6jonONBOuD44fRBZKMEP09G5xieIQD9
F05w1PNdk2L8XDii+kB0TnK0BFW4sU6ZWsLvgcgk/kOX2n+sT4wAQ7cuL5jU
z4JDN0OPB2U65Z+wRLmvx3gw6p+H8g3XneKOFRxJNi7qE+XiPqkc1woR98Fn
fX3gxrAFS5ngvkjcD4URvV46Kqes5/pKPOb7mebKjXNYOKCNnhJud9W1IsvX
oOrjLXLAIucZRDf37skNTXHtFBEooWU2nFFS3FRjhrb5QTQdwiuul86dkHMT
58MbCcvHCBlGTDb6HAEXJySQVyYyU5aVps+kkhci+0AlCAxINMLAWfLMFnWj
tDjJRIz8YLCPbUGuNWgyW/XKATRBXs1YLy2hVKMw6TAfDA8VUyYHWfItmchz
8Ntly5kPEKIgXHf0mcVpNg3S2TtYKZEe5I5Gu4FvelVmSLNZ1Q4rNVJOaFFA
HkuUdVKOB3FsTZxr3SCdHSS+yKM6SoYBQ8bUoS1onijNjrZ2qBQ7sIXvPI2d
H5TvH0SAuNJmV0Wkia1SXgeLi41x2Qwe/Qo0KBs2xUBBcA+O6LijzVy2yQYO
S0Gugx5ZORXAk5x7urrRbuPrxmt5MXMxzqD3KXI8KKu0bk/Go+tFQcNlLZWl
L6s6JH77/lsoDpwbhV5emT1filCx80WHb82V/haAsiHFg+VB5S6J5y+ex3gQ
V13OahFZ2bRLvyfFiEODJ4JVo/WZXTt23lkE9w8iFvc8GeNKKuP8oDG4Mzp7
GeN0STYY0sfZIhnwOOiM2KTjBDycUx/vxdFCxTnBY0L1tUb6/CDrazLMHcL1
h9jNyXXMhtNbeKpDTvIucB4EnAeUi+5v5PsvyXOQPRZckQV1Pyrhkd7D8EQs
wrFddCXCXnSZcEMWTk8oIpPvjZLeZ6wTNx00hMfu5UwnvyGXZPXA4BpZxzML
Cw1LVCSuz9fIlOBkCuoATu3ZbtNAYHO49ZtxVL++PnBdUGPxRTxxNFhanA1m
rMTcjQxAquIOofuqxINiwksG4xQGei/sgFxc0cpRn2035qlv+kNAVcnPD/LJ
Nbc1wNhHLhGH3wMHlT8Ro/ny4rRsuJlLP4ivPrpeFE9nkkcSBAdk02EE0UL1
FDjMYpMXqooynwtlzYXyyjdYVd8WBHtlwkCLgn1/0XhQ9mB1JoBLDOoKeOTg
oWO9h0XjxQtEZHj91ddOaFYOqy+WT8v5i4NoRFhUr60XzZlGLVCdFG3EAMGx
XxsJQyskY+/BQ4D6cSg2o40zd3hosCJ3WZ10wMRBU4oepCPrPMLs7GxDeBga
kKcQLDM/aMVafyHWA+CfQ0NDGIWJfX8501SaHg++ODsjr/qQ6mO2q8BhcTgz
gLz/EQeLkIZ8dL9FZRpWXDGhuJRdjgcz0d0KApQxUgc9DnnhlROBOmUDQ2Tc
BSDiWfwzWNcqjXTpOwqt9iQawotj01Du2O6EGsgaiwBRIVAozvJ1L6tY/FDm
ePDE8X7c23V8oE/xpZc0UjxYfkS1QY3C5ZdHj/SW57bBFKQCYWdPn9meacBx
0cbtWxfJlStIQ39/f+nuo0dz3SBd8aPHRO7nOVsXvBCczS4fy6DOBUS3zBgB
+i81ouH5XOf9+3i4vAo/cb4J96coZWHvmQ2XwWBKtgVMyhOTyV2VPGgvk6T3
hkrnZRwalV+Xr8Az+s940ZX+uph1Rb5hXGwImfkpprLzppcCznCDdCiBcndw
LvQq9cFwTKb4bDm+yQtolje4ZTKRC511GvAyyvs/fvMAn1JRFotG3uJSwzAQ
PW3kANIDjjrbSyhtHszyqw1QvcXsiQB9/yDG/vIte/poCUJ+aEVaw4xiVZqq
zkDDVsFszragMd9mucsqtu04llfr8SBrhniRZRTQv4IMRQNEscqXL4j6ZsSJ
GeFG1MiZLbl88GscMpKJwXtDlLELBIzR3PJSZoJYZCS1Iz2oz0nbmuSHGCAo
p2DlxLm+iiyywbmFxlOtHCAmbpDJaBKVa1Ny0g5HcQ5SIAtlaGuBxexbtmwR
W0pzYVzMmlg2Jx4iJ6Ei5rXuoanUq+OeRhFTwEJn8EQy46SSCK+UmVYZ0D7I
8lL6KTHihBK0LSbPZ6hNLyJg2xGmCfeZKgeYmONB0330mpLnV3LmNLtqBn5j
Y319dJsqRn/REcgg3pf0PIe7CaQJQVx7n4keRCMzxPO+iXrLNRnwELSOrcvN
5sRtQbjjT7Zj4jgCoR4iiBMp9XUvNnuidsfZoC6gAwkm+7LBAhK8o3PpAsaD
nrMbheOd0WGMB3fu2D49NTGH5c7bX5mdvsfPb6y42+xGigfLg7qKggU7eGAf
O1Umw86nOzV00pissnQCkZeev7CtYSt2N/DlxvWrthpVBIu2XpTb0hfn78kP
xTkG4gleAqsMLAexkul5Lrq9SAB0tbgaRyzVUOM+frmA3IVBAtmvQH8+Yzp6
Jcf7dyBG8XNwR6F68GM2fymYeBYMusqrZ7PspDJlrSy6DUrolwnXx8oP0b2U
42UxNKoQj0Qad0Qi4D4ROR6Uk4FLE5xfEQJ818/owKMJRITCVtG8/bacj4hY
cU9Nlm8wZOfJbM5XH4eddaFj7KOfaIolqodARv09BXCQ/PrVa8o5tzmuD7Iz
CX4IO/www64/6+SXYIqicQshbhHK3zzIAUnFGxlEVuKgDDn2qa9XxaofhSdS
NkSPZsppWoEzzteuXFUiSjawv1kN823zg/k8s4Ea46SP8XxRkb+SFZsmzmwR
Z1oKJmBsIh/Whztb5fWNOelSM3Fg1Pnz7K4KNkqTjXiDmFKZTYZCZQ8TumPQ
MWD+q6+anTqbvFC1FHlpS0O5T7t5CzrwwjgoAx1ZDmhA5HfF/IVei5zcbBfM
vqhoBUq9cBIWrRxO2UP15RsucuE9gOy0kzBzPDpDVmbIlhkobfosWM3L4wU1
4stsEXeRKJCvjimqEqzTr5bYvp2dOSnEB5SzC0C1oa1gujmTEUeE6fnnUIiZ
LbIQjf1ULlQMWTkVsuWwUdlNie1dmCZ20pdyDKw4kLkhclVfRix9CVPKTdXY
ryl21QaoZooGvvnmm0invEMhHw9K8OK9OeUsaNyaqmzBADVTMnSAIx5kWwgz
me7uwFaIc7wjdZfOFxXPcJEnECZkIQbZxBOHPVF67WC8N2wUtjGlyMPwZGCx
yXSJQpnnByGy6+nu3NrA7gg4cviQfNijPKejfJf3fC0S/1lBigfLhrpiTE9P
tuzdExwl2lA/dmekbOMbsaQiheN372zj20XAYgCFEBsuBvJkOot1vmhwskd0
4BT+VJZz3P/xmxgrKUGQ7XkudKTBtRBdCfir4FvKkzXwE3Qf+QMWssEx0fKC
PXb7+eYtsiuI7lPk5qMQIDf9RDI8lx5DlaCghSxGakof1NbG728KcwBnAC+b
UPx/6AEb8CoH6KreXcA80VWDd4U/wEYgee8sd15BV2g61BQXsUDvhuIQK7Lk
1ZJingIYIsax8QQMQNBduSD0CcVRq0CSchsgPGlqaoJuXfbDsfs+dCgYM8dF
WeAR5YUeTgUq+y8gZSZ6/yAwEEvUL/VriB6HqACuRNrJDyG8JN38mA3PHpHj
XOjZITHeRof3mCBgUIkEKFMV6Js1iBsbsxFSc5JeyUvXRGiQMZ2ck1+hJz1G
mYrJO/DEUCsUHQCxRi55xHppTiaCPvLQ2spCNvnOOCCjp6dHTGqgnymvH5b1
TRzSK98/KDLHMzyhBaFagvTxLNzgRP1wGyO0Mtx3dqT3sIgxxb3wohaYGDdU
Ch3LSTeEBm72AhuIgIaGsb9DXvrdcIqfjM4zsFfeXoc8YYLgii2eQxX0AxKz
lml9rA4aDdZspfWN0DbFjaVQBeAeOyyLR4WMLVevKiNUaBgDWfDC8aDdTHTC
Ha8oBSLxIRoolIVsxrOmLZNYKXHfDbwozoEBdyiIOrP5mxDlQQyojjhNlFWn
sVFUBx5evny5vr5eviIW2ZjLqfY554wvRHp5fa+jn8pJU6hIT0Dt66+jnsit
GEeWJscnsIHgbX04YScUeMuWLfJw0PjYXTzMSjljJz9ZGcbpSMaOHTuEpQUz
BRxw2FUjiHOhg+Xl/HhesblPntVF+UIAKFdT34WHGyvkMRNIgyLOmDYF64Bj
oRMTE6Lx5nhXLtYJy1QJkwKOAfIZTYqyJwXnB/Nhb9awCsVmT4LTTSXnBHOD
Bi7fdPzGa6+LfhMC6r17mqHt5Gd+w2UVjnUySwJEPFg273R05DbGg4Dnzp5W
zv83nji6+C+noHiwPGjcGwhf7o6N7trZiHdMXH7heVSqCp5bKyJBJPL6tSvi
/gvU+cWjyUhJEfcP1mvbTPDOYsX56T14CC02dE9il5zjOXZYGIhB54iHtODO
NTH3B+YdvUow79BJ4WEsGWl9nVjxIu8eCsbwtVuccN5K3KwnE49b2JAAnDZC
L10J9G7fvo1pgGz0FnDwORNd8zkeHssAyaCjwckUUQRkLnaLnDp1qj6671Lm
rUw/Ol1iXwN6L+KEOuGN4MEF6BNm+M6XTLhx/vKlFxThirNbMcwREbq43heI
wfCKXZy3h534By4NfIdKifu2sLdVjhLCmYsGfocgMGF4eBhrgfu5sFCsC1ZE
uc7MuH4vAqFfmokeFYv6AHmy2QdJyliLhvA0AwRcrKssVRL566Sibiik4r3S
UE3hOwWH42knxMr7N8VPWIqsFahRyglF+vaZnNYM5dmTTHQlNtCMERaOqAff
MxlwkMRbeCwGSDm4a5szU5AkOKC3IOB/cAhDeNU73u2IDpUcrcj6xk5S5dPo
GE7KE+KiUYOy4aw3/AQPhRCBfjQXACIAtMlLmRXF5qYYtCC+kGdptUuxRbs2
njIRXONuOjgLmN/e3p4JB5dYI0KbFo5CgLOBDESChSWU+Sy3ffEloy0NhWQi
84bwABBwuTHWkGsdGPbZOcVI5sJFC6IsNNHwiRvWQBCi6clyzITr8CH6E6cu
i+oACKMt22G5aBHI1Ee3QBpjxkx0c5yxn0KAZi7spNCcjLbbDtJg0A1pMMIC
NQaVk1dmgrlGlooOC0IbHHaQc8OlF5BAtjbAJTCS0L4g+sB77d121Qx8HaMw
rRiNIg0iJkVAlZ6bnZbfxpsuI1oaXkTLKrVrN1oGyBZ1zHN+EDLcvXs3KDnu
McQTkpFR8v470YXheJesxroyMHPEmcMGJbL5mzJkZdDtSQNfGK8f5wWCwKUd
wgAiDVhBEIeQODvYtqUVGxFzRbTzb5cECFLLPD+IzufQ4IkMXiPeUH/h/Fnh
HhvnB+fC7VfgSPf3HZ1bTL60QIoHy4nKlDHD2elbN6/v3LF9b3PT9NTE/KIZ
PcCYdGZ6Emzftq2ZM6eH5qN6XnEKESEe1A9ISQHMB9PcJxYCZDL6kS+nh06B
XQVbKsbtbc+zYs/O7Ny1K1fhOToP4EZCdynniUPcOMEBmRzpPYyTXCJz+JUd
8HI776ThOY34XfYo8ARs5U7nAPgIJB7fDb0AfMEj4qE/gp4un4r7hBDfYa/R
f6yP9Rd8p7xyFTJ0cNDPYtgYrFbKsl4J3oUioDrgBuOOBnhRcBL+xGm7yIFy
ck+0wOYOent74RXMHLo/4dTlxHkyvJpQLvotEJ0pvq4AcD8gB5ROT08P676z
+WkahCsvXIa64KEWQDlIk43uhoATmnIVsLJQOgaD8G7er+AD78A38ROWqNCG
nr9+F4ksL7xTPphKlnIA8vDAH9nPBNHX85MN5KPv2Xow7qTt27fPyBzwXoBU
YCC8GJCqAR5+ixqIOeBqavn6DPyUm5JcEGgF5AAMQWmy+GUhohU5HNjPRK7k
QM7Xh4fbqAVFb5ZEAI6hTqJKKOffgnOF2o4eafAunyjHt4BCofB5OfCZazxM
Eh0taDtMcAtZdFyV7aJAFSQQKdFhbuIgJ4N3oUT55CW5CsBtyOHQoUPK/IVN
XrImsOUE9fk5tYhoomvX8V51uSWCUTUMHYT1qo8eNCSTjTMXYLsgAcRKIGig
U95J+vb9t4ZODqKHDCKABi72XeYlmw1aItQOuAeqAqGKGjGFsmD6s2u3IgvZ
jOvaKBMMdYf8MWZBCyYm+5AScdkBtCBwxcGayTfJ4uIHrA6kgerIU5MDA2wE
QFxKrnyinVGUUwEUoiwvYz8lXgfFQHowDAmYLyUAnrMzUni9kMNg3pXrjRDg
IQt5GhvBkjMF47zNRKfSUARsHExaFYPtC+gMIr6wLJtddQDQAOTtbNwBNOCO
ctx7KC+yDUxo9IhmYUYiXOWUQFY4JMVmzbLB0aA+84NIPwL26ZAJRMSQz6sv
vyIzmcFCsB5eGKLA4kmAvc/w8DCaBWQXti/d5TDYE607xjpCYxkaGsKRGdFv
iuKEocPAEHUexaH0hksCjPFgGbxTcZ84zgLg7eFHj/ROhxfDGSaAZqcnJ+4e
7j2I0yvHjh4u+pXihSPFg5VCZUJZhIGzzrsnykweDmggzkXj2UUSEor5waKY
MiUTY542s2l7Xh9uvJI7C0NKcUuvyXnIac4MTvrop1vk+CI0tupJ8WbjKut4
6AbZfQof5czf7a/HPEfmSA8i58lIW5YKrZQkAlGiMrBfIBgy0R9IqgIdej0/
IBQ5nJXTaLyVSXVrqaFSWQmNZEc1yqexGH9SIohoUuuvPsyPqKJUEfe7nmKN
8C2r6mSRdSMqBTMfovJyaKn6uilnOU1gQNwU2h9G8sxGzZ1FXX0KMqq0Sr9W
NR/zkqCBG3dHLpirD766YKON8nRqEysFo0SUairNJFYWxm4IW0E8k5121Q15
OheyRv3x6kG8k3nRUzwoVi9syV3jtsLGopqvSgEQDz7/5cuXy+wez/EZk0MH
9wdn72e27NrZeHygb3TkNh4gI5zn4ds3+/uO7ty2dVs9u8ge4kcIDPFagUWF
FA+WGQ0zyIvpLks9JpUplJeSLhLs7++/du1arjCDFusbFJJ5vXSThdulMT4U
C8mUT1zkKQafxXOcxirw+Gh/V9+YxuAzFLXEbLheVL8I0p1t0pRBRZxZOXyS
Aj2QLD9vpHHb9sbG/NEEkXfjQgZPHU7qk9j8ZxcPw0+bnvg4zD6s9mlfsWzx
18Z0P7kTJyXP/WJs3CGEgo43Ltm9evWqp6VyJ3CoYqy2+ENSUhMZNKPqxr6L
bLx25apDKMYSPe1JUtuSugtLp+Hy7fDWpl0AGQliyeI1Ulv6ogRTsQ3WyIFE
7SXWxhalIuWHn/zkJ+Dzg8kqmyMt+8nwOTR4YttWvmo9DAx37tje2tLc0d7a
snfPjsZt+BAiwe2Z+u3bGs6eOXVvcawDVJDiwfKgI4xSgq/FQGosJYuBTsQT
J0688IK6XywFGO2qp2V2Pxd7dooTm4Q/NTftkQ8/FDA0xFZMmReLxhXhTpDO
VUtUaGwy8ZN+/2CiTi1Z+OnxxLMg5bm7pm+99ZY4NhB99dL11mXwBIriShUY
vqUuIvaVdIQV6MgVH7LB6UO2a24KDys8HV130Vl2h0HigDdRcY7cfJLhykb3
bUE2YmINoI2Z/nFWIvvviIT9xWp41/2zd1YFtoR0Ki2zukAPwT9ZEVv9Uo8B
Zfjnf/5n8PmvX79etrmVe5rHPnJ7mHXW4WkbArfy7ZrBtGCm4dCBg2N3Riru
NtuQ4kHCpYvQ/E+fPj04OBivFpUD/XiN1CBMNx4JaJgE5JfQ2dZ6LR8I73Jq
qFcvO1gGAFK+ffMWbnXMaOdG5pZFD06wSIEbEPkaboI08IDYYQKCsoPe/c3M
zIDPf2cRxFl3R4aHjg/0dLQ37WjEGBBwz84dPd2dp4ZO3h0bXYR7BmWkeJBw
6eLs7PT169dB3Po9s4sHcB+6OPWiDJMXD0K8gOewKQePLGmQ1ePChQt4+p98
wIWcjICgRFAUM0WQIx4SEBQPdLskvl+6dGlgYGAm3I5XwdVreOm82DYoY3Al
faV9ZjdSPEi4pHFqaqKvr+/555+vtN7FQNkWWxIsA3AvPiRNICgppNiaREBA
QFAGUCzS66+/fuzYsYsXz1fcFxXocw7/4tlyJSPFg4RLGqFZXb58GQyCct57
bnH4MyUq3T1h9CC4cA9CHY3wwFacoJxAapYUHkw7TEBQQVhYWDh79mxfX9/U
1MSc8UK3CjmlKX5aDEjxIOHSRWxcMzNTJ0+eHBgYePnll3PFPlyicCj6tI5t
4cRiiH/LAMve73pA5EiwyIE0MCk8UHaYgKAiIFoWBIMYv9y4caPivqjumupn
SCrzhovhXjkFKR4kXLoojkKdmpo4fvx4f3//xMSE0IRl3CO7z5cjWLrgf0wi
AUFJgZTNH8gOExCUDaB93b9//8KFC0ePHn7hhecr7ogqTqnjKoGKk+dGigcJ
lwFCQwM4derUsWPHTp8+DVHhm2++WWlNDKAoh4G4jxkvJOclBw/aNroHpJoE
BMsAqLUSEJQOFhYWXnrppZs3bw4MDICzd/361UV1L7Zyt/hcOAmoP1+cSPEg
4RJFba34HPxx48aNEydOgKEAHejr6zt58uTg4ODJRQBIRmpixOu2fAZDKIzM
JQBKHZdflY1yHDzBcXAQ1LsiVBE8IKCoHyoegSc8OHaYgKBsINyeoxzAwTt3
7tz4+LhyWfYiiQo93deK06AjxYOEywyhoY2NjV69evnixfPnzp05e/Y0ISEh
ISEhISHhEsXz589eunTx1q0bk5PjFfczlyVSPEi4nBAnDZUnFaeKkJCQkJCQ
kJCwQFyEJ7EsD6R4kHCZ4RJaM0BISEhISEhISGhD/aBO8vFKgRQPEi5XJItB
SEhISEhISLjUkTy6UiPFg4TLCY0Wg8wIISEhISEhIeHSxaVyUOcSRYoHCZcl
kq0gJCQkJCQkJFxOSN5diZDiQUJCQkJCQkJCQkLCRYi0Z7AMSPEgISEhISEh
ISEhIeGiRYoKS4oUDyLOz03Ng7LNT83McWWbn5pjf1ZeQIsE9fOdipjzMm7g
y7t2iweNN9IS5wkrgsotybEp9T9JnwkJCQkJPfEev4MDAhn+OQOBTIpbOSge
RAQ2zs7PsTCQ9blzwMn5kLeEhISEhISEhISEhISLCufD0cJ5FrrkHybNh+JB
xGBakOHcfBgeTs/fq7igCQkJCRcbLq2J76VFLSEhISEhYQrEtY7p3qV4EHEW
F4jOTs8HfzKuvjg3WXHhEhISEhISEhISEhISqjg/OTM7AV/mZ+cwikk3/knx
YMhPvl6Uf2fzrfDnDESIc5UXNCEhYYmRJo+WGeKEYFKxkhoQEhISEi4thJ6L
7x+ce3EWZ7UwnEkcv1A8iMinBedCNrLJwbG7E3eKB2OjZiw12MotNZaa/lLX
t9R0Fiv/xaZXpc6/1PJdKvpTKbkvFXps4Cm+u3fGKtu+kkKp9bzU5RYrfbGg
UnSmMDVLutxi0VmsfEpdr1LzuVj5LxX5ljp90nxKnb8z/d3R0bHJ8Qk2nzXL
VzbO0Hky6c+TmZudxmWigNOzM4ODg1sb6p9LCM9a4AfPPmfEUoOt3FJjCgAu
KZ8O+m18fu6ZgNXwRf6elH5b/pWSb7H4b+WbUyjyuynlUuL6Fos/+QQFKE8a
/j9jwYT8KRYklWOp6SmcTnc7NcraIfpKga2+SdtjUn1Omo8NipW/v9zdfEtK
Z7HSJ80nVmOVL2UoN5G9Ssr/pHS64VndtTA1bUd7Lxb9Vr5ZsGh6mDD/pOUW
qz0Wyz4k5U9i+Sb0M5Pmn5j/P3gGCt+1a8d/+7u/n8dtbrOTdJ5MrrD7B6fn
516cm5yZnQc4efLkXzzTVfVkG6HAVU+0Ov4kJFwGuLq63faFUObSEmJLLKlK
giVUNUJCwtS4tOwYIaERV9Z0PPx4y7fru55pOsA2SszdY4HMHM0Ppj1PJrpz
BCJriAf/8gcHvrxp/4qnDgDil5UhrrDgShOuCDPxecvnuYJftuSv0OyTVeGo
EONfovwifLdVylZQTHr4lePKaBFG2hIR7C7XqA8rNc7Ecgm1aGX0y8ooJUWR
nSMrneAUqqUkcxSn/5S0mjo95WkCDlJtbVwXrq6rPo2iiKQWF5VaJ2q8KeSl
89lfIv75682hiFJIZt/86Ewko6TskvtKI7XioTETY30V86J0x7E8TIcro999
zKyRz3L6EpkdvQiZUYolKbC/M74iy9rWKayU+kr5i1HnS2Tlkgq0zOhgXQrn
rXQun/CafPK3idL4VuG1TsEHHwWwkmSyRT7aa+vxgzwtjTQuz31Vm/Z9e+uh
Z5oPi/smUmyHp3jQsnyUxYN/8ey+VbWdRqyqMaMtvTWf2g4jrrKgrdzVtV2J
6HHTX6x8RIJYPtjot6KFb3Z+FkcuyYi0Y7H0Suab+A5f8hnWdQHq+SfVB8xc
FFG4XhnfkikvCn+MzQQ/3endfM7/mVBPEuuhsVBXPpKtSKK3WvWT2R9/PnjK
MZZ7njXywmqVTpsg5GZlSFPXtbrOwAp4mFSfbTUqnP+2OjpSilbpL8d4+ZoY
6N8e05WbgH5OHjY6RB8u2bROL9fW34GqMJTKVZ4kUnK5R8Aa6W+58/FUHi9R
1nUJHZY/U+qPSobNZbLUxdJeFA7nee7Xvowy0pVEf5iCkxb+aBYbLJLd/liL
SOhH2YRVpRPj4Y/pxsHKUqvnbHk9mrP4s1h6njQfo2I4VMhW1qrabnjyDw0H
n93TK0KYFIEPxYPGiUIxP5jUXpVar+wxo8VueNixpLSVwp7YMZlfamopTn4W
SV4p7INOXor8bfFg6nop6pGiXiXlm7/cZUw62hBLT2xcLOIC/IJdoSueslIS
7+cUyGfPhxH1SNCuY9qvZ/qkfHD4ewanujr5eJGkCYnHsiyapsvdbu3T64Nn
IFZcNTPWMV1LdGPSiElmbIp+ymFkcJAhVj+Vot1FJOAktzwKusYHiuH/+0hz
TTQMLLqCJRKcoUaWeMGOCcfNksqxSBjPEBEZOatsC4QdippIf5LyObHc7Xou
aiF/JuWwsQrudmqhJ2F/x3P7h/p9GA+Ki/MoHizietFvPLc/jamxDB0bv3ja
JZ+matMT40MxYGgsRSYyaaEpiFSKLiSHZYxGi51YOjWB9OXRbAfPk/baRs0J
xjO1rlYmQB9dNwwSuirrsp/+XPKehkvGjRSScrzln1VsRfQeShGE9np+zDkc
eU7QL/vTE0ttOu45LEyljE/QEdioila2kHE2H+8rkUvp6WcWqy9LIW7lV7l1
u9Mb+0fjPI6em7Iew/zKEu/mbHY+5q2azpV1wafMvRTxS6mqU1R61MU5BUu8
dGrjL0T36wqRblczUbaxZBvXRyUrTgsJHclsPxn9eaP4iqAP0V77Hxr2i/nB
dEjxoHu9qGMcz2g0rPNxCVGZgMgL3TbBV9MeOw8Y8frq8lMYkXGtImGsAuv0
JKLfg4BodSw5GKuchg/WfsQ61KPTKfvVNkfdxgdNP12FxlY5P71lXd9iyTCp
vOz+J7eWkcguov8mfXPlFkcPliK3i4LQ4lQUjT9F0s+k+djsXrpxcun1GPuQ
FK32x9I6FLVPzTebPTG2emd7NHPDXS8jmvU5SdOostjn1XXJ9dnCfLelClpl
mLnDDljr68fnvEtZ16mbgtV1nTYKDWNQydu1bFcdnYVPT626DTVW/ZfTO/TK
sx9xCF3/9OwcS+Gf+PDT5iP52LfY3jYR//1VOkG/n9aeRMsy65XMQ4c+2B4W
bofl9Tny99h+Qfl01N3zoSJfX3ueuL9jpUM8+PSeXrF/kOLBXFHXi37juf32
JmaRY7TLiE1fPDSXaFS5KnucYjcvMQSosz9RhXfo/8qaDkB712AtzjDflHi8
JXG5SdHRfmUO6wbWP5+I+EL1S9pf4LtRBupP4oSefP7OPS9p6r+85JXe3taZ
m3Bxh/ViOVmA6qYvt8Ah4nS1LsoUqj5bYRzwV6aH5AS2VhNfulPNFHl5eW6B
+kVq511KoXoS8k3rRxLP8VlqZ9kiauuAjM4n5i+3U1uzLbo9t/LN5LU64ruI
cL3U3mW6Fdah32vqLFL6mbGFxiczLcbT25F/uSWSb9n8t3Ry1+OatPoTT56e
f1Vdl23tcXIOlLqdWvXQoue8ggb9NDexCK8iHLDWy7b8w7YvOEV3DPHgM02H
xJQW3TeRK+r8oGO9aGTHt7br3NrKDC1I7QTd7SK5PS9OPknzd/PN3pqscWU8
oqkU++65HfOUiz9/ipXemg93bPStH4nK9dkPlUK+qcx+MoYXIBdf+18IeTat
M2CYQNngWVx2xdbOU28Nr2huXsw4bUKjUaz2Zc+nG7CqrieSib1jTdQKUtCZ
ul6eC5jdOcSqh1suheyv9OSDZybW4z7ieJj/Im3TwPaYgs4C65VCn5WCUpdb
ETkqGRbOGUP6ODuslKIsGy5kC3BS8RWFmUnlEsO9VEqo81PP1lxKWjtsokSN
1IzjeJ78EfqZWjQ2DgffizDQao5PccxQXi9K+wcRihsPylPPil9kVgbLkjNH
q7Q1N2czNDQBMXZk6CU95lncQ6w+liEy1O/0Jw1NNTrYq3wp1jiSSr9rONqV
g+6WJLVvq/IFdUS/u143jSPlc1gdSnBlTbuVHqMxMRbNDyOSKYn0oYl7NNe4
h1w7oUjBQ2koUreHnvrJJ6AjWprU2leZnE+X3E3tKxgnNBFp7fLMk5Ve+8h8
BFQV3d8hpqIctsiYiYMPHnM9qp5ECrU3Ukc7VfJ0pA/Hi0xKpfmTVjHF88es
/3JPYVEYqXX72WEH/xX7qeejHpyLmYfxYJIdOjF2WyPebJfy/Zpaoi1/lYcK
35TS9ULDF9VQMYWhEHplEUGgAPIyVHtxlgpa20VEwZT8bVbC6E7ILlBwKJbH
8kXFC5INhfxpZGCV0T8xVdCzv/aXYJBbdPcN+zNpu4srUUkgt6zI8EVCu2cN
bOXXCwnno604tiEYdMzZv6SkypBt0vZira+y4tRth43rzKss+26EXEzxQoz9
1HW7SjpPhtaLCihWPHhiEOLBHl3ZbO3dqNKedsPhj1VpUYBPc4gv19X1eDVP
97tGjXWQqthDIzfMZEQXhgVvuVchRulJzc9Io7YQGZuP+S3L9vZY/sfmb35F
s4dJy02kFf564lC/EmHSdmR7Sxelmw+2oypspaSrl/JELtSds9sEJRjv1Vqr
Xi99uL7o8vLhjxttlwsoy0XEgkCHSZEx9tzadPXSiyhWzsL5KZA88aen6B2m
z2YY/YXuI6lVUkezskbd7x8rCzcfXJlo9kT51XCGkqYAig4A/cpPblXJyysa
NRsWY2tLnZVXbHX3b9fKc93xlmLzSJVtnDfLWquj/pZreFASimVQV60UBoNJ
1dJXizx4Hvt6bCmOlCkoF4JQPn2qhuL2pLlAOt30yN+FZur5G7c2iHZqq/i3
MxQPqlD0eNCoY7bWtCra9mP1x3CsYk3eqXDoRoHoJqwQm6Arv+2Jov82M5ui
DeZft68+db9oG8+xMcrnV7my/mTb8vfhv/FPT0EnLTemRs58bHrin3k6evwx
aYZJ+WATgY9ECue/tcSoHhbRCol8jHzzr2lqeRVOvyc9bjp1y1Bc+kvHnyAr
0+h60vxTNzdbJp7yctg3XSJu6STV1XQ5GN+y7T8ylmtbPOzQyVhm6jTovxpN
jXho9ILS6a2tTfmv1TcWGktPavL89cEho9RccuQfm4M/M/Xnnv6VUpz+6Vm1
RDSbsy1sqacoWqZNb5Kx7dRtgige1KEU8aCPnudNh7bUxKdxKSmTtpdEmull
MerMY4Ox+egKb3vibxWLVfcE1U9Yrp6sQIsdS7MjH/l5rJn1yadYUnDkozxM
3a952u2iyMU/W0cpiXQsls7Cy3XrQ7Fml6zUhtt+i9vqi44OFhl5XnR9K7Oe
J3olVj/dRCarl3O+zD8fG7uUeNAWViQyVj522+cnmarYlq5XR06jr4R3kKrn
r8w52vTflo9hYjGV3uopHVFqUj4X3o4c6wR8iElXrpnzpgVIij54stqdzDHF
bNQ3nULxvcovJExn30qO1fn5aOStPNknMwHvLY2VtT4CU0XxoAnKEw+6W5P7
J2M+DosqK0yKzNORJL9iW8zmWbV0dt69gyN1q7cWZ6IzRf7uasZU2dsfSKRa
BSpnivQ2AmLbSyL+yybUeORFBfsFf9GnaI9uPSmw3AI135Mehz4UomylkKD+
U4r9wv5GID3B9usLCy83qZbaKCyWOSrWiIH1fpkSyKu4/I+xA5YVJm5r4Fll
x7uxTzwrmLTVyL8al8Erb8UuhU3NHJcQTfrvwxaVOUnmqvz55k+VzhNPscrP
Y8cxdLnon/4lJmKX+DPFPKaxd8g/rM7v33ScYhSvA1r6KooHTUDxYApqY2kr
Vrtz6H+sP5N/WNAB7C7C5CIKz82NxreS5p+0XgbyPA6sTqc5OgH++XimSTSO
XU50C70Qfpa63OJSlZQeWxvxb0RFp9z4U9L6lpT+FOf1FZEbhsSG419cmaSw
e8XiofUglGLzrVA6tRyqvPcdBO/6zTv4iCY2H0e79qxg0lYTSeCx26Ii8aBR
aj5sKUR/3ATbfoot0ZitfkWCl7xCdOtzlV9IWGBb89RDf/nKxCsJ/NugXq5O
TxXFgyYobjyYorUa14u6W5yexjF0UKBd8kyvGNXYHFLotk8tijUOnDS+sxXn
v14onbwSsdFn8Z5N8VRL7m38C5KCdz6xafSuJHU/W0jtbC8aM/cfz4lVV9vS
NXe9PDUwESuqPPxSfynb9hEbB5ML1EYvCpWFVc7DOtz8LIq+GXWj1PGgoy+w
FereEWYg0nl9raMuXvQnsSRVNfmH+irKRPk7SE0kAtveDYVC296iQvae2Mqt
Mp1L45C1Te42iSfVW1uCRbVe1CDWugShQbpyIwR7my9PbnvKRa+4WyeNdBo/
bSXKJ4p7csnzYTpUun7lYQq5V0UnWFdRPGiBRRIPGhuO/q7tPBmfEzILsUu2
F2Nzc9QlqU2LNbM+54uWCN388eSbXi+ly44dT3MbcP9D7cSfto3/tnyMsk7h
/6frcYw/6aGB0TPxb7lFaUeJXne84pmPUfSxL8aSKp5H1io4Z5AL4ZtDuIpA
9Xbk2MxVdHTLy33el4+hE3wuKeVFsaWqifY2ku7Nd7YdZO666L/aCHYn0/NU
DKz4Mzb/AqmN539USWyHziVdL+oQt61qnlZXb8tu+aaj2S3WRLuejYV6NmEH
03wK9SQsdrLAnyS3fsY2wFiy/VtHRPqWpWLGT3eJVdqFSpHE9nnM1C3Uxgf8
IptB/zaoi96YjOJBHUoRD3q2i9iU1p+0+ybyf8o/1amevJuSWPuppTHcT2R7
MfZhbLlGPY+0F794MN2Nco4m6ZKafWuJkQBbMuW8a/yunyfsGQ/GCtpIv0Ov
BKaLs3yeF5JP7GxRKVYUO+i0aov3vScyw33CHFsz9KfWnaE1mUUhY8q1HKQQ
y0/360WUrzs3W8Sna6OnkuRROzahuFhl8R4LZJSuJz73quiK7W/KYqvgo9UO
QRuTeRZqe26b7HafG59aLvnvUaUyEuNZtI1X6lkW9vFMgyZYupsqKXDzb+/K
r7armvBXfdrIpiFqttKfNrHaZBFtGpZ+P7yizi0LT0ykNjZZOB4a3zKGWj5S
86FcSEH5tOUs/lwd3vuj02agx37vW6zQYzmskyeXaHxLb7PuSXmKB3Uoajy4
P1bfVLnHxQvW1lQjaa93YGXUcFl5DC86vQ53K/NswjFmLclVvynshrUKSe6e
0LmXyA5UmcYk3bVw68nKOtCr7uB7TcdaeKWuzchtm/Q96U9q7txSllGOdMR3
vfvWifEJkaym29IelZoqD22Ssj1xMNCYXh798NdtT711PzS+WOXsaNxkBH9G
T+HwFFAKxXO0Yn/74N/6zNpo318ma6ws9NQydS/Jc2elMzyvb/Z24cjHXZDx
16R+VOwQSjq5J0WHZM2J/cZJdIYoCpNH5256o5K4269bYWyv+Odm0x835Tq3
HUUbC/XJX0dZjjZJKdXxZJpRf2LXD7ip1U1KUikbabP3qhHjoL4e+m9Jl2fE
NtUU7bdY+diItDZ5vw2SDrm4LaqtOsr6cFovGguljgf9FckHZYmLz/gWHTf9
4Wp0cfGgo8fxsW8p2FXEdV/+VMUysJB40JjeJn3br7pdWlHbsbKuc/Wm7pXc
I10T3rIqe+PgrNroL9v6uliGOKpv44lP5onanZGe2HZqbLk6McZ6ed5LHlvT
wlufg3tJXwn+lDTQX0w29bC+Xqeu/Ikd+PWsqY8sbK3SplopmKm/klTQ/vqf
Ih93AvlX4762EmlsCu0tVv5J11EbFcaoTm6qjM/TxYPp+GldAmoZ3/MvXTzR
Oaxk4p+/sUR3XRzpfYpzGIcUWKXFgwV25W4HstRtqnDi5Vo4hFVVo34motPf
TsY+t9lPR7lG4ikeTArliQcdonQYedtPqZW28EaqoG04N2l/kagWZYgHDZ2X
R1xsEHHSo56l9Pq6MmM/6FIhbgDXhJTwT3irY03wenCU8Vo/+1MKdOiJXs1V
fKnMyjCq1XOLXYkXW64/PcF8pT2O9lm9LMSdXw9cp04VxbYjdylViyMeVBno
Fw8a37U9KQX68NzQKqNLGvSjGm0Nufx8cOhVotc96UzHz0T0+FQzdf6lQ4Ue
QaFP1KYz080QBweC7QCS/2/cDpyUnz4Ml5tPjBwFkfadCw6WOvQkljY3ecai
bfYhlp9eGwGMw1wW81J0hY9ty0XJvBC7VOU9viQrRlIl8afTU1fT8cdNvK4k
FA/qUNx40CFumyiTYiKlzetAeI9JcXedOCh09xf+zUf+s3SebermKdttlQke
VzM4+Onzq43PAaNqIXpqZ3sQNiEZTAdW1nWsrG3FGJDtRKjrNHrmbg4kTb9K
0Uan/sgqpGZebQ4i0tGfqNHZ8nE89MkhHYWOlIk0ysaustXLk9qq2g5DrWut
h8IllaNPPkn1xzO9kf+eYop90S3HWHH486co/PQ5j8XBz9hVdun0oRD++Oeg
K0OAqcYhC0+fotax5foO1tmrbNxV4blG2pHSU4I6nT6scyiq/MSxMDgpl2zm
JU9SYed9udtRbBMrQ7vLvxu3MUEmSf/057y7HSVNloI/xk+3oCke1KE88WBs
g/LvpxKpbiH6llQn3TbQs10YK6sXVyL6UxRUVfA9jzZ6fH6185nZwBWhMcTE
rMepDfYVrqxrY4tImbnoWKsf1ue3wNj9xPBWwfGgvzn1od8fHfk4HhaiD/70
uEn1tyqK/jtISir32Ezia73c48ECpe+g3/2wKPwpnJ9J9xeka60psMCccd7f
Z92C/Guk0Lh4MNE+BbWZ2+18cfkZy0bPgVNHy4qvbAHxoI2xsayrcrpDNlTC
w0KI1DN052A8UMVWNc/q+zDNkU+K9WB5AuStMXH3FYoAXyz+SUe/56LlWO1y
81YnyfBJ8WBCWFT7B/1XuwkFTneeTCxVnrWoyHrRovRQNjqNrPblg90OGMp1
ngBgfFfvI6x8rmlnOwdr2YG3a+q6P/tE26c3tq1ih5L1rAqtBB5bt7aaLSK1
9SP+fEsnF0c+ejVXxe2D8KekShukjV3Upy/jjGRokaZPi47VBDef3bX2p8HH
JUuqJz456L/aFswnyEc5MtG7dvmincdYuaWjpHfsA7UO/ieUvj//3QWlzidF
cbKYUtgTxyHzJSI4ReZCyrHn5Niqb66mtFrSmIktf/FdtgnGy9cc9U1xfq8t
gbuaPpnEmj7xp09I7ig90QlaOk98LEaV3iul0jejBhalmXs1zCLZk1gj6RZW
Uv10fCbSk6QCcj/3520s2Xp6igd1qFQ8qMvX364mkruPvsXSEGvHjBn6r/9J
yqjU+cRW3JbAnY9xHQtD+zib9eg5O//9JbKytnttTU9Vbcdvbuz8F+uaf/d7
B/742X0fXNfySxta1/A1oqtqu5EASLaitjWFxBPpbWrR2KrvSOZDiUK2fOCe
rV6e9LilaXzL9tBNT6zO6PkUVyiJWOGZPrYupdA0t7xieZ5URrFNJjZxIXrl
LqsUXPWRoNISxXdXViW4bkOnp4j1ddfLJghrD6KvtfDeTOdjE/zbqQ+jjGkS
MTmd/kc4mbBGSilV2vSim3KbktuWhibV/0SFGotIkbPtrVLYkELy9DwoTHmi
fNqSefbLnuU6nhv13N3G9So4KKF4UIdK3TehyzeP9nVQygFBseoXHL5hmUaU
jwJ2Wwy3qfStl1ONfdpR7ACdbRG+P/9tCZI2ZwfDZZ476HeMKvucPPmZjR3/
cv3u1Zv2fb998MqtWxN3xxt7z/7xs/t/ft3ej69ny0RXbmqB/FfWdBlHPt3n
2vmwzhPdS1PcbDcm8yFGV3UX1na46bGVqz+3pVEYEitfdynJftWO3NSr5qLW
2GqKfR99Uvn65GCTjo9GOVRF6JVxl5DhifciajedOvPdgjOWlYxv9n7KnY91
9EzjUoKcLUdqFKIn6d51kOHZTo3S9CzOZzMdJrMdKeBzE1xSJrslHlvTfGLT
rL1qspyXhsfkb293emVlv8JmIvxLMfpgDv577mITuaWOYqIpzU0+NrcUDSqW
yMQZOpdvebaCWFVRpGO0S578MbQRDz77s5fiQR1KFw/6SDO2hfp4yw699Wxr
wmiIQmPV2GbHbBob27RVzni0IyM/5Vo4CsI/bWNlrpYeF4yLPGMdGwPnjYVW
swsEV9aBKe5eFayHD+4WXBMSs7KOxf4P8yNifv2Jzveua4FXnu4YvHLj5puv
Tb39+tRPXpn+yetzY3dv7+w990fP7f+Fx/Z+8nHIqg2SranhWwjZ5RQdzODX
tK9ixeFVFB3IRkizJugOOtY45Zto+NGmDEZWxKqxUrR8j7OPiq7yO0vcp325
tS7/vM56jICi1VVRD8GzdLf6+bwYKwKjHB1rq/Qx9hRsVPjgj0k5YCtCTCgb
q5OaBkdK5Yn+p3+90NqoOuZ9aqKN/8Y9SsY/bTwx1j2WgZ75GNFmrMz+s2mU
xqbeBU5fevJN57y/nsua7Klmxiex5FVp4x5GmhUJ2hjrXzX/9P4ZJpqz04Xi
yU9/ehzKECtrNyq956pUKm0URETBwvNRFd7G6oPtYfCTKW6t8nNOfHhlMwKe
bTC2vdgSi/kdhVRDEdrIia6KFA/qsMjjQbdG2f40PpEx3frqwrXa6IRYG1fc
djwbP31aojtbNx/kT0+2xKaMEXednLKDHxfTDcZhRU0X/7N7TU0bhGyfebz9
X69vWbOp4x87Bq/evHX/1amfvj79xvxE14kLjYdOTYyP/uT16Xdemxm/e2fX
4fN/8szBD6xvfmhD25d4bvzW7G5+4ijk2Q0lrq3pYTsQaztW1LIIEcNDPKrU
Rx9iddiRz6qo9fbhoTH69tdPt/4YJ3H8fQNV6+R78bTgQv6ySmsjRmI8y/XH
1HYJ0RYPVsX5n/5UlZR+nTBPRTKaFwcNNsJsKWPJczM2okWmV5Ly35MhnnLx
yT8pVYmk7CluR/7uQr12ySW536FKM33+eu7DN1tkkYJjirXMB852TbCpbizf
Eu318xFTUt7Kdcxj3P13CSj00AQ9vT9Pyrnf0CbxWBalSB9LTKJ2pCdL+qJN
fLbExqwoHiwiVDwelKeT/OdWkiaL3bmfruG783E/sZVrfG4kz5jSOCtksxW2
PN1VVj59qPLkjw1xcpAl29S1si6YFlxb215V28amC+t6fnVD6/sebf+33+t+
rmfoyvXht16ZWnhj+rX5yb7z1/5u+5FPPd7+8+v2fn1zb2v/xdmpMYgKf/Kj
qfG7w81Hz//5Dw59aH3rQ+tbV9R2rOYnjuKRXHh5/cqadjZ7WNMDRVTxcsNZ
wjjFqMtrdTp9kxP4DNbZApAUpRelaXiSkZTOwokphOCkL+rPHSvHPJXBhw+p
6Revu7NdFdfMPRXJX8rGgvzrqz/XZRHLn3Sc9KHTzRm9OLffm0hPEpEdSSPt
tvDlRlw8qB/t4j4KqcpiYP1FY1NXMx/87iX3HG2ObTj++pAU3Rpo3Jvp4Jst
/8KjKuNbjhaUKB6MPQazcD6nkEipS4mloaCRBG89T2cJk1bKkX8VxYMmWDzx
YCLTkTqZzXqka4wxdtXyRF8qH6v/NvJsDTBdvTzTiwZlbIwO+mP540CMc3Ex
J3BsRW3rw+zF7l/b2PkvH2353af2/WDfqdsjN955bSr3o/mX5u8eOH3pb7ce
+bUnO37hsb1frO6AKPJj69s/tK796z88tOfI2fG7IwtvzP/kjcmpqZGWvgtf
/+EBiAo/vqFtRXU7jwrZiTSrxanLdTwgDfab+G4acqiZT611RhnPwRMJHFrk
WbpRLoW0Dp0em+b705moIfjLyBMTZegoRZedz0ZOt8Qjv9aalgr7jGP4aaat
sj7ySsdtI0tTy1cwUMkzhXB9XvGsu39Zjrcc8vJHm4oaU+rPUy8WDSqV5Jzq
RP6DvmhT1gejksTqs00uPlK2ve6zj8OfKn86k75rI0Be4FGQJhTVeqg0m+YI
lCep6S9WfctPQOp40EcziyW7FFzVmzbFgzqUJx5M2q49BZ0imbG4RHu+PPUt
tSbLVCWtL6J/nJviFALRmsSnT009W72rXnU97OwXHpo9zK+V/+WNXe9d1/Lv
/7H7h/uHbg3ffue1mZ/+8/xLc6MHz7zwrUzvJza2fmBd25ee7FhT01a1qR1i
uofZ4tLOh9bvfd/6PX/07MHGo2cnx0Z+8vr0wo9mZibvtPWf/fMf9nx4QxsE
hiufbF9T3b0Sw0Akj91VwbnqHQ8a91H667nOH3diPR5MWq5RmkkbpptIW4bG
RQKJ9KS47bdAu6QkdueDVfYJCf3ru1TiQR/dWFVrmJdJIQ4l56pixIM2pU1H
ZyyXYn+1JY4lwIc8Wzyo519gPKg8cYQVSfd9yOTp+mBQEuetK265+LTi2Bz8
5e6paW46k75rE1zhWhFb01j6Y9MkjQcLb0cp6lseTKEGjkz0h7ZSCm8vieql
FE3xoA4PTjzoXlEcYMKOzE1/Cq1W1hkmra+c2CcqNAzt+vVZyqd8e12e1ZZF
Jin0AddwrmLnunSure381Iaun1vf/tXv79u8/8zNW8M/eWNy4Udz8zNjB068
8K3th35pQ+sH1jd/sTpY/4kLTXlxHbivH74/tL71/etb/uNzh3YcOjs6Ovyz
12bffX1mcmas9ej5v9p85KGNLR9b17Kiur2qphtKXF3NXlzNj6xhC0f9BFFg
PCgPyMtGrBAF8NRGR/qi22cf6SfSz8jmRL9799yyk78nqqDxfADdzuiN3Zat
Px/SyT1WykZ9UCZZYnPzsQD6yi69XL2sGBtiCjQS6ban3qYYx/OXr6ttFukG
iirnUoRYyg1pkm/4DbKtFqsyzJguHvSRZmzKpPQIY2KbaTWWGMOfhGpmyyeR
LulrMo380euYaLrQIUr/Bq43TKNV8VGhpBxOiolUt0RFRySYypi4+WZsFLHo
zt9WEbeqrKJ40ALLKR70z8FYqGv9VUK7ZKuv8qKtLH2+0vinP/cSPffkv/xp
pNlRU1tKY38qHzDyycc7fm793j94et+2g0Njd0Z+9sYMRIJz03c6By79ly2H
PrKu9aPr21ZUt62q2cfeDSK4rpX8BNHgbFL+55pNXRDl/fKG1vdu2PP739+/
9cCZ4dHbP319MvfmzEuz4z3Hn38kc/TjG9o+ur75t2va/+2mzvAQG3BRuvB0
01h9iOWhD0MiOTt3r3jqpE2R3HoSK9AU6D8+oz9JxNUU1Pq3LMfrtsGW1PP+
CiVeB9Sn1Um3wZGfx+4SstkEx3N3c4glL8+iOJOoZJKI/ynYmDr/WM4UrVXq
ZsfJZwfr8r+mjQdFe7Hpc4HxoHq8mzeHY5XKSI8+spRI5RyZF0X0nmTYtEV5
YhsTtmWeaLOhm8+6fOUijPmo2VqOm0jNN8+UxUrmn95fsilq5+aeTwNPRJWt
ndqaDMWDOiyeeNA2Du950YxDt3VM2o/40K/rtp7evXPQUQvjnz4tyN2O1OYT
d+qO8q78mSIe1DsLEfeJPwOs6/ylDa3vW7/nq9/flzl45s6dkZ++OvHTf56f
mGSR4H+uP/SLG1o/sm5vGPfh0riOkMNs8yAvJZhkZOVW82sj+PNPbWx777rm
rz5zEKLCW8M33351+qc/mp6fGe86eRFizI9vaPnwoxBjdq6ua1/JjzldVdfm
1ocUK/BV+UZDP5FhrKIm3YmmKoBRWJKYVhd2cp2erSJuWe4yVUbPzZanrlSJ
adNmBt21tjV2W31X8f2w4ugnf14Z5eWPKRTSmI+YP/LMPyk9yq86o3z5ph31
L1DVqFT3Tfiz0T+xbgpWSe3O4dMW3ipt2qUzzZDSdChlITTk0T6PozTSRHyQ
37LJS2l3+n7neOIt9lY0rsTcSNSOjL5TqnsTDGPUpvFJIwPlxDbtLUU8qOTs
Hw+uEldXR5UttTIrD3VxGPVQ50PSzjeaiXZYk5N77vkRhjjAzn0tHxn5SND9
lntjl3vmWm96FA/qUNL76G0HFzs0x0+xE7ZK50FSxrKMHqBOp2I0lP5Ccc4L
XL+nr3ZI2gPGMyohYQrH5JravBd3QVCpNcFlgu1sZSa3M59c3/L+9W1/+tz+
hkNnx8bG/jubE5yZmh5rOXrhz//p0C+ua/kwOwembS2WKG36M2qCfu8qcpKd
ULp+9+98r+fZrlO3bo+8/cYErkHtOv7CI5nDn3ycxZsranrW1HWvwngzevGE
MDLG+kJ1Vm0KTCiEk5jDGu7lArU4jynuUoQqrK3lV2xsChas8mNOhRPejTUN
z1ntWFm7L1gKG0a+kCf8yXIWilrXgVsgIfGK2o611Z35GU9+qyNjOCeGIT9L
Z0VtK3+lh9v8Niyaf3ZgQVgWygiCZT73CvTz3Gq7g91qfLnXwzVYXOeX68Lb
7Xnt+PWOPZjJypoudsdHeDfc6ie7+DE+nVwfOsKadmPFsaDVdTLn4U/G5DWB
CDrESEIVZyDyh7OlEz+rQqoCja1D9WMn2a5+sgeykjpEkFpPID6hwOHdlPk0
m9jrnC1sXALk9WWujXiPCQ5NsDpWdwS8yvenjLd4/WUV2yfLdIPpTCgjqDgb
hajjItjE1AMvysS6r6ztDjUqKK6K/8pKrGurCgZGerAU9kp1x5fq2gMCOBNY
zkxFu5CNnAkoTfy1h3OsDdm1tqZHrOJbXR1QiHeyiOa8si6QaSCIurCZcP3n
14m2VdXsY00Pr3HBKoTF8Qtfupju1XBZM+zhGXZwXWV5ssrW7hPSD+4nZUR2
r+bnR4kmiQmQqpV1QohMq7GNQI0Co1HXhkJfG4i+A/VnVTWrPnI48GyRaQkN
bGJ3rjZmxMDTXBsTOF60JU5a31jj70+t8uvqWnWExJatuff0jiYMP2mjpvqY
g41+PVtjKQ7+63WxjXjoRStLu6tCl173W5T6OrhqG9MuUHPi1ClyD51R1kUs
d5VTJ31KcYxp6DLShziUssSTWL31tA8ROk0hvIrRsdzYSNmWTJeXm06fZmVU
DCMnKR7UoaTxYFKBpnjRqy1b4sHVofPp1q7Y5zp5xkbkPy0uMlFyUw11ASfh
OJicyIDoL/q0bltBa2rw2BYe4NS1/srGzvc91vwfnzuw58i5mYmxN1+aeHlu
4urNW1sPnPm97x14z3ea/sV3935mQ9tnn2j73OPs8sHPbmz/9Ma2X9/Avz/B
PmWEJ5AS8DOPt3IUDzs+/XjHZx/v/NUnWt//aMv/8A97Pl/dXdMycO7S1Rdn
Jn786uQrs+O9Zy79t61HP/FE24cfa2EXT9R1y5UNZnzq8rWzVDnw2zE04JrZ
g7HY6tr9OI+JoYpID2Wt4IESTpHgnKaISoKwEZ1GHsvgWyxeqA7iqdVh8FgV
vNsC31dIsQwP7jrCaxyZJwzEsCrwCAhDj7Xc5cAzdviC2y4eNTDnOSCsmjnw
K/MeMtv4wx2VTu6id6DjzYI+xq792O5wS+ZaFkrw+x8xtOShB7rfGI0GpbAr
P7rYDSM1+Q2hOFeLIRgPmbtYUMPrspaFtO0YCLNoq6YdI9mHg26um7O3KxRH
NzIQQ+kqziLBH/guJM7zYYHtwzU8UmaZ9GCcJbgBT3gA2w1sEYIOAmFRR4zu
N3VhpI+UYPi2CiP6uvZAYdBtE99RuyCYCgMxLHpFsBa6SwxW8CArIGBNbcuq
4GDedq45XTyq2o8iWBHk382rv599l3YEYwVXBVdwBpEXo5kXFNSLBaFtgejD
G0I5u5gQMYyCKHs1U8gergbdqBsSW/igBJcOqMTqQATda8PGIrWLTgxawwCf
RXZrRcPhbAz4wCW+go+9iAgxtKIdODbCcuYnTa2tYbFkGHV2onSgHXFF5bIQ
QwQQNtZ1hkwuIXp2i55+VGy35XierpdxG//CeeLTmRqf+7wV27cW2FE6CHD4
A466+BQtIrjgrfx4lFXKsVw1vuKjOY6lX/6aKefmlmkh6CYp9nXPuQB3GjSn
shHzzyFGky3jCbH0CKVyj0jYCLCxxZ1PIunYElRRPGiCRRIPlu5FWz5yMFgV
3UHv01oLKT3SjsSf9vU2tpa4ShrPSUSVnBvmoDfJREPZidq1w25jXXCu6rce
7/qjZ/ZBJDg5MfqjVybG746MjY0eGLz4yNbe36zp+WJ1xx8+0/O1Z3v+8Jnu
P/z+vq89c+CrT3fDJzz8w6f3s88k+DV45en9X32254+f3f+1Z/et2dT2G092
/ckPDjb2nh0eHp24M/zG/MTL9yYPnbr0SMOBz1fzGE0w0D74rPKcz4UJd3R1
ELDwCRcWEOF0TzfOhmAgw+KswM3m/jCfW4RPjL9EnFUV5hYGZUyZgUg2gcK9
Ypx8XMnvUgxdaDbBwZ1z5rpLQw0QFbah87wC51DA+cd4h4cDX67uxOknyPzL
m9icHUadq2paxdIXcK3zaslDgyDkDOdfwM2GrDDOwnKDmTUWCXZg2IhVXh1E
sny2CIipCWbN1nI3ni/9ZYHqWh6SiBlDHgVwbjzZiTFRmCGf4snP+3QEETcL
bVD9Ongg2YHxThWLwYN4h0+QdVeFd1CGYRQG1J3B97oelGkQ39XyeTcetKLs
VocLmKtqgkmoNYGe8NgKvm/CevEQrDoQCovaaluBBmA4Vp/PnTFZrGKbW1lU
iHHTippgn+xKnEdmgXkX5rMimLDjfAinFFfW4fcOMavORyd6cJTgSwGFHaEg
unkQ1BHIKJxWhkK5Auxj86E1XUAkmzfk039Bo8a61/E5xGD6Owzba3owFA3b
COMYLvxeUd325brALOBMMW8OLSvrOsM4t5vbbT7pWdOKk4ZSA4RfmaqLvcMs
PIeWVYttig1EcCUHebUFq8eB7bz6K8I5cVSJqpqgkTLm1AUBuG7Pk/YOsdM6
EatiOp7Ls4ik5Nn6Ps96GelPnVWsaXXX11FBuaezjrX67dL1r0shCmPkgG+3
K9XXtjjTODYuHsovrjL14w6RyQLymdfTJeKjPOlbYlzidPrvoyf6r8bTnGR/
VTE+xaJTCEgu1Kaxicr1qbues34unDsfxxM5Z5EVxYM6LMJ40DZqJNuH1Gov
v7g6GCRXF/45rFwKA66XHjtYZPtTeeLgTywNtvyVlQCJ6hXLOkf64Hmwugwc
wvZPrWvrP3s9+869mYmx0dHR8bvDI3eGz75w4/zzV2+OwPfRG3du3By9NTp8
d3h05NboCDwZBhi9OTx8a3j0toK3R24Bas9HEG+O3Ry5PTwC/+HdkTu3x4Zv
jwxfuHZz8NLlkdujd+/egaLZlYU/mpuZufO7T3V/9omWwAtlZAczPmss4sM0
uLwQIxFch7ambt+nNnR8ZF3rh9ftBtc33MHEJrB+q7r1Q4/u+eC6ls8+vvcr
T/UAQ8Ad5RNb3Q+tb4bnv7yhGecWWbl1+yDq+chjTR9+rOUT6/Z+bEPTQ+tb
IQ18X13dHqzhrO4BT56P4/VADpD4l9bvhTzB1X849MzDBYedazZ1/fqT7IzW
D65r+oXH9n7o0b0feGzPL6zbzUlqhuefXN/ycF03hHK/tr7tQ+v3wPNfeJQ9
//B398Ln+x6DL3t+q5r51XweJ3CzceISSgECPrShCfKEkH/tU904+YilP1zX
ATHOBx7bDfR/9LG9/OSfDgxIV/Fllqs3dUNWH9/QAlR9aF3n5x9vX/tUZzAD
yGK9DhaMQMTxjz1feLIdigirsBu+v2/93p/7btNnnugM5rY4MV8Gwp4K5v7g
dcjt159oh2p+dF0Tr2ZXOFPZBWR/+LGm9z/WxJjw2O4PP9b8fqj1Y3s555s/
uIFxidFc3YOn2j5c2/7bT7RD6R95FDjZDIV+BRfH1nSK9U5VweJbRvlXNh34
4sbuD35310fWMYI/+F3IFspq+tfrdv+bR/d85vF23jw5kWw3a+cnmICaIeX7
17cwEazbI8QEUvgNrlHAzy/UtH3wsTYgEkiFX4EYyBb48L7vNH12Yztfe8xi
sWDkeVPXw7zz/SSvzkPr935yw56Pbtjzi+ubf/67e774eAcuZl6D85JQzU0s
poZXPs7S7/3Yuj2fWNf68ceaf3E9sKJ9RTVIpzs4xKmuE/KEoj+2YS8oxlc2
dX5q416oHQiak9SC/ATiQbLwEPjAv+/5YnUbKFu4yrQTioCUoOEf3tAMWYGY
Pvpo8xeru1ia6mC6EGNkIP4D63ZBLXjFGX/gxfd+txHIA8LYstunun9jY9tH
Hm2BTD73ZCcfmujAuT/ePLt/ZT1QxaTwRTZf2Z5vy2JKtzD33ueEKLe9jbXD
woy7yXOba+MTH/tvKytpTT3JcPRxboKD2XB5sZxHQfpwbmx94zvKOsPQolv0
1s7UcpmUv7oKFbJxNbXm2wpSVDdWH2L1MJ2apUjgSZI7gSMT9FSDoVfTXrlC
6BQM18cKjKg7hwWW61bg2FZZVRNJpqc0thqKB3WobDyY9OSxpOrnsA9yMKgP
9hrbRUn130iqrdxC6HFbdVvipDtf3OJzJGDj+dVszuJTG9sOn7n809dmxydG
p8fvjI3fmRgfm5u++9L81IuzdwBfmp28Nzvx4tzkizN3X5wbvzcLn2Pw/SX8
nB1nzyXEJ/ApfpK/vzxzh2UyM/nKLLw+Ac9fmR2FDCcmR6fujk2Mj0yMsz8B
vvq9njTxoLTbjv1ay9apbmw51Xn6Zv3Ry+Ca/vaTrbgSD3zU3//+/l0DV5sH
r//fm49+ZkMbn4Xp/lJd+2890bap+0Lb6Rvf23/pizWtK2q6Hq7p/OXHWz/y
ePNfN/a1nb515urcqatTp29Od5y69Z8bjkIw8umNzWs39QTLAqvbIEyr6zrf
cWb0qa5zX3iy80t8zohNuATrSxl5n3ui+S+3HNl94ubu4zd2H78GuHPg+u4B
+PParr5rLadu1nSe+9yTrZ/d2PrtPWdaBod39d/YxVLewGSQ//+7re8LmzrA
z+c3P3axOTJcEFjX8emNbU+0nW4futl0/Mof/eDwZzd0hDsQWelQwd/73r6d
Azcg2x8eef4LNR1fqg62LiIDgcm/trFtQ9spqOzewetQx09vbEG+8aWt3Tjx
97nH2/7kBwd4Fa4x2k7cahm68dy+F769+wTk/77HmiAYeZgbH7YQNL9Es/OX
N7T+2T/1wot7h4b/Ye8QlAWqCOEG4NP7n28avNE0AAy5seMEVJbVuhFqffwq
K2XgevPQ8LYjL/zO93ognIfKAquBsduPXdk7dGNz7/Nfqu350hNBWLE62FeY
X/oLUR6U9Y363t0nrzdxshGbTt56tufid3Ye/71n9v3cd1kgA5oGUoOA/fHW
082nbnFKrgMlIBqgAclrGbz1rcbDv7ZhLyT76ve6tg9cazpxfdfA5V3HbzYN
MMpru85/e+fJ33m6GwJDCFpx7S6yDv78V482fe253vqjV89cmzx7c/r09cm+
y5Mb209/7sl2iCjF+k82c7qpa8UTbf/q0eY/evYglHvmxhS8curGTOe5kb/Z
dRSiuU+v37v6qf0rqjtB2Wq6znSdGX6q5yKI9Vc2NK9vOdM8eJMRdoIpGBAP
nAy+H7/RdPwWVL/lxLU//eEhiIVBTJ9ny7mb/1P9sdaT109fnYJS4LPnzO2/
aex/aGMLxK0PByt+mar/9hOdtZ2nIH/IkOln/409x29uH7jyeOvZv8oc+5XH
2z61rgUa4P+3Y6D51I3mwdtfe3bfr25oDWcq2eLkT6zb+/fNx0EN2s/c/PMf
HPzsk818NhlnPA3HTfig0e55juMZzbIxN0dX4iDDYfxjLX/SKqfuOFL0+0b+
2N7y3H8RZG6aSfEnxvaWo776T0bnIUhgP2EgqVhtFZF9A38PJFbKRUmZQmGK
WK5R+knVQ0bhqa6odU1hFML/QqxZOjuWjk7j81UUDxYDFuH8YOyLhfRTsv7o
84PCvhmHSgqviEKMcZerYxpUHZH2OMzZky2xxqrAeNBbvsE+MvC4vrCp/S//
6eDfbj32SH3vX289/Ff/dPg/PN3z1ae7f+e5bra28/v7fv/7PX/w9IFv/HDf
3zQc/q/1vY9k+r6ZOfTN+qOPZI7+1/oj8GnCw0b8Zubw/9PQ+1+2HP695/b/
wTPdv//s/j98+uDvP8vWkf7uMz1/9lzvX2cOQIJvNhyBnJlNTrxeVL5FC4+I
6fg3j+4+cX0ql1vI5nJ/ueXoQ4+yCbuVta3/13d21bSfy2ZZ89x78ub/9p0m
NitU3Q3eeNVTXQu5LPy7MDz3gcf2QKjySxtbPv94e9+lu/wx/PhT+PhZLjBQ
By/c/cxGNh/3cB2LpyBO+dyTnfOv/wjyHpt94xMQSdW0B+TVBTRDePhz32n5
4aHLvPwFzId9z76L33+Wy/3o7f/+0Ia29z6668ytmSx7sMBqgRRnc+/yGt2Y
eumb2/o+8NjeoJXxWdHPbGgBxz4bGp8dfVf/9+82AQFr2ckkbP7rF9e1fDMz
kOXFQn6PNPR/+Lt7H67Nn6zyq+tav/LUviz79V343NJ79f/47g6cj1sdHDzC
Jrw+9Oje9a2nBPHvBnVgdL784/udp0ag0A8AW9hRPKEQ61g48H9+p7nn3C1M
/tqP7v/Gkx2fr2n//Mbm36zpQm6wambznOFszwU1WgAeLfzpPx355Lq9UCMI
377dfIqnhY8FCEM+tq4F+VCFM1DV3av/f/beA7qtI0kbpee8/7139u2//z8z
OzvjOLYsR8kKtpVzJMUg2eN1nOQ0TmN7HMa2LJFIRCRA5ZwZkCMzJeacJFIi
RVFizqRISlQiJZEE8aq7L0AQuLi4AGXv/ucI5xqmLvp2V1dXd9d3q7rKETNH
ZnyIEwtQehyXxg2NOdd/5cbwzoTSGTyUWBOueSJdXVufU9tOj+B7htyLAVvi
XohUfXE4k6IWk+GoE/68fP3WNlMJyOEabBwEIUF2YZ5mb1LFHTSaVgfxuGYr
tPjJgcxp3JhNcsqkCBPheY5OYa64OzJOylD04CZOnm56fXsyYPNVEj2wceD6
ENTa3n9tqdAQEKGqbOq02RzFJx6kiKPk2cZR5k/naRcKNbMFOn3hRUTP+KSn
4O/Cc20hiuRZAhUOm2NcLzEuEmnbL193Yg0hyTqOOQBy+/oOS8B3xxXmIjJy
qaXNv+OoiNszQPVVIg2M+LXhYfSM1RYWnbREpCOnQe3+w3ZPZn81KN+WRw+5
XJlLelrw/dgm/F7VWd5kUwl7Ypi1VhfFlTZYLkPlnkAcw1OeqmV5RJGWdc51
ehpfl5vukXAmtSWn8Y91dpp11o5c6KdVDxiIn2jRr4zPP135n6IeliqW1/pD
7FZCB+d9rYENhf6tZvdqofNvFLzOR1pN+z4edP/8N8GDXicLy3FnlnNnzwcX
GBjMmC/Va7sM67BPM8vLP+WTop7eq/dy7BnoXyvsB9rhhYXOCinMi4T6lyN1
84W6R7gaAINHk4sPmIr2mvL3Gwv3GPP2GQqOJ5e8tzv5txw1lHxJoJ2HC88X
GeYJ9S4X1AMF0K9CHejSAKPgDtyfj6+XRMbpfF2g3AKVH0oo2GPOh8r3GfL2
mgrjUou+Opj2IFf9otBAakDH93yMJ2OPBWoKtofIgDugh8uMJTas1or1Rc/y
4gPxAbpn+Kqk0ktYcbWebeydJ9KsRY5wCUDzhwfTMbaxKkwlj3JVS4U6UODP
t/eTuXzj9khCccOhU1VJpQ3Dt++Sm2cudUF/AdFADYES4yqx+VxrDzR5pq5j
gcgQZA/tSEWewbALwJTCUkrw4Nmm7rxzbaA/F15oL63tKqlthwpVObWLxZpZ
AvXJ8kYodOvOXSiTcbr5ZFVjZmVj1+VbCDWOI0D3twMpc3lacrjsVZnpMZ5S
oCvAmBFQpK2xq2+pWA/aO0o8jcl4KVLz8YFUCl1abcbC8w9HxGPXRMqU9lBE
vNRQaEcE1uiEsukRaiqwCWXfRAbHmTxlhCqfAIZzrV0ATLLPNtc09aAbGFD0
Dgy9vTP5OUE8FV4GxXvRrxQhwzSgJIRHMED5Z0zuM1xlkMQCiCYu53xZfWdF
XU9hdQv0t3vwKhQbGr4DbCmu6SiqbS+v68mraQJBhXqABsDL6RX11DprRdD+
wXBlKDkkiANgkkhBlPDLzdO4GomumBQ/Xd+RXgHMbIdvINtmB4k7E8qngZzI
DCCHBRcAT1lvDA8V1XYWVaPRKa5rg+/CC51VF3u4qoI5AuTA+RngQfxwXevl
1IrGU2caM0431rZcJmMEn6MnK6dHKIEPa6XmJ/lqVd55PHbot/zqtkPpZ9W5
Fxq7BgieGrPa3t+f+jxXhTJ4ynUgqz/EZTteHSRXNO1NP63OO9t1+QbUACws
PN/xFF+zUqwDyHmhAxq1goAAMwHmb7NUVNV1ll/oLqrtyqpsbh+4SnoJBXLO
NYHIFV/oKr/Y9vn+kzA1ZvPVQAx+G4EAWlp5w+GMswkFDQCTMWNGW/uvgCDB
XAZBWiPRLZWYKhuBb6MDg7fSqhoyK+szzzTlVLXcuHkHA/qRvqu3YbX5n1vi
zjb3oDcGYyNv7UiaL4gn6u6vwuO2m8qJmMmMRb+OiCevDpz2ESrCD5tl09dl
lqE880bj6zrPniq/V3uGm+z5w4Zan3jrd389lZkK/9kzmXboGVr3SC1d3FpP
wWwZ+suMZ91llfqDXdh5Wvmhp9DbGU82/PR60535XsfLuTz7GAsM3XHXWhlG
2SfynJWZ0Mnx4WlpprU+s59iU6HTj2rdC4Tcx4N0n58CD/o6PRmkiFbe2EiI
e80hk09G+zTBmdt1Xxjd22V/Mtf5YvbTdp+hfswv9/elDAz0VIz2BDR7AXDc
J+fLHMCKWE9ARX+aqxarcmzjA7bhPtvtTutQn224y3qnyzY+uNOS/zgXR8JH
CR0sDgc8mibkNHEDHBx+UaD+dF+K7XavdaTfNnQZ6odv63C3zXo1Of/M4wKt
IzdBcJQf+Sbs6STsrolwzeFq/n7wlA1br9RZtU9xVCHYyXC1xNLYc4VMz9t3
Rt7YbVksQgcqn+IiKERMY98cz3yBp3mMo0osayD2lHMNXaEKy0P8+Gk81e+5
2o3bEs82daEqxm3awronOGpoF/TkFRLAg3DfCuBlvliLw62YqOCcONgLXM/y
VNsSSki1f9ufHrAlboFAixE0wBDNvEgtgEHo0WyBAfAFlOkevLVMAkhNPRsd
rFMBtUfSK5G1yGoDzPIcXx0UpSN8gF8zq5qh3q6BW0OjCI/8/cipWXztRmoU
jC8LNJ8dOElsRQAoeq4OA2JdJkEOjZuw7XJGpL70QhtlkbTZAFMA3xzKOYkV
A3/MFCi3qvOJPv99bE7A98eAXYtFxg/3pQGwJdBm4Mr1VTLzCowgiHkRxOxH
VRb8dvnacPdVZF0yFl4AJodinA4dx68d9CAqD0TEZJ9rhcq7+q4uFOumceLg
14WRiH6SOGOlUB+6LeHmbUAf420D18Zto219g8skurUiEg2Giv/piA0LNwHY
inQlBMN+dSwn4McTc4Ta5/jKuZHazfF5N27ehp9uj9le3ZE0L1K9MFIH6A/u
1PdcmS3UAmh9SWRcKFADGTBSC0T6NZhpgK8/OZBJeLUj+XTAD8fnRuqf46OX
If+Mye4fvEHE7K/7UqBC4OQPcbmk8K27Q18fz/09VwniBBh8nkinya4lsgqc
geFeJdIFSpHv7sXmPig/eHP4y6MZ/zNC+SRX9RBPAwVMRXXtlwe/OnoKal4t
QbZpAKRQsqqxa7lUv05mWIHew+iAYPj+xeYTcRk1pOm/7k0jIode3UTqAPw+
GqE8ehIbrMdtTZ1X39qR8BhP+QRX+ShXtTbKUFDbgfpgHQdcDAIGArNeql8q
1lY1AB60na7t/NcIdAYQxOy5SNWqKGNCaT2WLpuusOYX3x5HXcairsyt/TcO
woMwRiDn9V39cLNj4PoykX65REOO64bYw/CSWcNy2XS9POjDXvcF6r5bQEg/
1CH37YO5F77uLM6roqebnvpL2yhbT07PoeZ97e9ENCRv3HZ5T+u+EbDxJmXj
bufeBPPW76x7TLo/sey43XSik3KK9pxvgo3UMQuDF8Z6mgL0/fWYBY8lhQzl
3QnzdVKwx4MTrXiw9XuShKnMU5aXu3V44oSyXU4mejr5ACCDux37vjNPIrfp
YHSobfZfJ+7cx4Pun58ED7qv8G65p71MBNbvbVxaZClyDC4fLOcs7fowaV6w
3vQZ1hlf5zhtea9xD9wXfDbzzvuM9lADexlwlFkuNn20J+VIatEuUwFPlcFV
ZnLjMnbq84+mFX56IHWp2EhOqIXKDaCjPs/VgHoMeilgq1cUFvtBPwzEqNCC
FjsCojI4wB+gsr6xLWFvQvH+xAK+MocTl7U1LlOuz1edLN98NH252GCP2zmR
942BYE+sIKe00IqqMK8Wa+G7a+AGqKN51e0zhZpgqXkONgKCfnp3ZGxoeAR+
ClfmPc5TBct0j3CUJzKr4c6todv/uS0J9OF396bZMG5qv3x9eZRpeoTWEazm
9+HKtVIj4Cls6LH+aVc6KNhrJKaVMl11Sy88VVbXuRAr2y6iAiQ9w4+PNpcS
v8h/HMmYwVMDxlmP4j0iWLpOhgOKSg1AanJlE5Tpv3br1R0JiwUaFHpUZgK0
8luOuvxiFyCbnoHBkGhkXIP7S0QawDI37yLD5bbE02caO6BAXHbNQxEqRy4A
wFMfHUyHhu+OjtwdQWp6uCoHhpLEogGA8Je9ycQv9c5dhBq3m8qn89SOBBOO
XFozecotqjyyxAnU+Q8jr1RjoMT4OCf+t9z4jMomAj0OnDz9SLiKhD8Fpj3G
UyeWXIRqzWUXD6afgWcvX72xRmom9COLnhSxC6DWi0Jt8QUEQ7quXAtTAKhE
npOBMhL+FAXSBBTJUeYjsNx/XWIpJojj62NZAFgcKxWJp4o7jggAoRVrkfsi
sGVrfO4zfBU61BllBBQP2HBfapUN//Z9TN40jhJYAfAHSrb2DILatkysDZKa
gqJgdAwbpAlkWMNkRsCDnx7KIE6SAKmAk4E4qwKwImDzUZmujEBmhank11vi
Xubrz7f1EUPk97FZAT/GkXo2RhkWizUBW+NPnWkkLN2ecPrhiHiYFK/vTBq4
hSx06RX1QCSJXwqcXCrSvCwA8UaAEXq6TmwCIHah9TKUPNPcu0SCjMIhOIAt
cAy4+nh4nDr3PGkavSLgacgxQODqCpF2U3Ti0PAd+OnqzduvbLf8iqMktmBg
zgwOCnpzEZnIrSAQ35zIm8WPA8lfKtWdbURyXnWxZ75ItVqsJ5kHgQOLRYbO
gUHgSVVTN+BNALw1GKheHxoOiUZJaqZtjduqJiDRFp1Q9tsIZejkyIosF95J
02oKCzibpZX9g+wXcPaXp83Uv/I0O5S3dfVeMZYNn70CNxcmu5f3yn9nZWbS
zcnBwD216FVvoVe2JyNfpg66KwxyJr0rxNtrZ3K5x5PxT64YnnJnkXOjXkOp
TFGc/BgvX2tjJs9dGhnbZfuS3xNJnu473jMQXYhhgrBcbxn4yfCq5D4edP/8
PHjQfeD8lrR7Mr+8xkfydZ66SKCnuXCvptW9Ku9rPSzZ4n0/YkGnc5kwBbJ3
PMpVLRDpP9qf8vcDaXAtkxge5BjW4MCAOKS8Bcq8ts0SqSmQGktlxpI/7koA
TR7nKKcSKOAKyatRkz0dPNISN8pQwEzQTp8XqGZEaj/anfz5gZQvD6WBzvlr
rgrU100yMxVU36/zIxOOylFGx7vZQBwns6AWWXk6+69viEant6bx4ndYkJZe
cqkrr6bNahtT5Z1/PEIF2v6LAAHqOmzjY6BRL5Ro/sePscdPVZFZDPp8wJY4
p1yECaDD/4/w+L3JpQT47E858yg3FpTw5VJzDVbLAa+540FgFDz+PCcu2lxh
QycDx74/njWTr5rI4i2n4qCC5j87UnPqNDK1XLk29J87EpcKDSQF3ia58d/D
Y/T5yO3w+vDdd/amLRboADQ9FqHF/pCjYyOjgA60+Rfh2ebu68DedRIdYSCA
iI8PnIQHQfO/2HUVCqSdbvo9TxeGTyA+GK7ak1iODj9eHmzqHRjHwGQ6gqsT
uQLJKLzAV/2ozCVOjyAP0yOUJBd5qML8HEf9+vbk23cRvmjuuQZSBCK0IcoC
uAMY2H9tGGCFUFv4zq40fCLO+l1MNiC1MIXZsZEB7H1JpCu148GN0ZalUo3j
GCAxJE3nKVPKkek2v7odCncNXoe/dbm1D3PUjphCOA2Ew1ZofIqjEuvyyUm3
cGXeTL4GLybomOETHPX3sTnUeToNMtstEKsLL7QCAS2Xb6yXG1ZIKLtzmJ0V
gThaJvDz00OnMLS3Hj557lmehhQLlhmwK+lJLD7WaHN5wPfHPj92krw9KDzf
8TA3LlCMc3nIKIPmTK72z3uSRkbGoKqzzZdfEukXRWoAnV2/dgdErKa19wWB
/hmuOkyB3rTAYAGXlotx6go5QtAw4ujAo3X8TEM38JzgQdJx+AaYpsmrJcL8
5dGMuTxijkfdeYKrlBgoQH0iq+qBrfGbqBwQKOosTNtfRsRztfnk7KSxsBom
C4jTUrGxqrkLHjp7qXexULuehHuSGtfJTHOE2qqGy9i0OghE/l9bjgH6xk7E
tn3JZ/9lq3JOpP50PRrcy1evrxIbV4kMU/TM9wEPsivpvvgw6Nu0K9W93YUZ
9npPhb3uvwzn6F3uu7jfhNJlQ5vYnX1Rwtl3ylMfQzzgxxDPuMyZA85tOZ92
Ya8P+0G/g1G0HPBUD0O7DHxwvthY0FgqHp6e8sQolpfXcf+vuey5Yl0khOXo
35N+0QazpSXAWQw8RaXwynOW8s8sKvfxoPvnJzo/yCB45PueBCNyPx/tejHk
2aRS3U06S+6TTDJMK9pH/Ogyw7TyNNfu1arFvLYzLzhsprOvraOIf0Lt+3vS
rnS33upvv3ul7auDac8LNATfEd4ujNS/vz/NHjjCFqHKfxoUVGmiI680SWqA
o98bqTxo9lTXRI1fLoa2jHV1l24PdtqGOqXqzEc5GkSGXL8JZa82bEKp2Oml
hdntlnZMf89Vx2TVYBfQ8T/vSQS0+yQ3Pq38ElJNU8/sS64EHbe6sXuJ2Lic
rwdA2jkwCHPWVFT7v8KRhajsUjdy7bsz+tquJFDOceWWMHkyStqOfS//tCdl
aATZhooutM4SqleKdSujzOewfdAZDzpIIt65z/K1ABCIBv7Zgcx/2xq/XKhZ
HqlbJNIuEaAYpyghiDQB8CCANRuyDw6/tSMJtG7kshuFfO0e5cZXNfRg++AN
bOEyBUXpnhLEAziCaisaOwN+PCFQ5xGs+uXhTMAawYBhpcaXAA8eQiDl+vBI
bF4NFB6+fXfTNhTQFRAo9AhwBzxkLr5Y29oNECA6oQI45uCwMx7cospz4MFn
cOoK2DdJbsFpXF1mVRP2zBz7+EjmS3w1jB2ICuACsiq+ty/1BYH66o2b8Ly5
8NKjEUp0htHuagIDMV+sJ3gQRmSjImG5RGPPFIycCZdE6l+NTrh56y508NDJ
yoB/Hk2vbISh7Oi7hjwnxXoqhaIsgWSTJ8IAmEikw/bB8bFwTcFMnhIlyIvS
r5UaA36Mjc04Z0VOjrZvj2UDrIPRL7zQiUBN59Vpkap/2RoH9D/F18D3cxFa
wF9hcuQBO5evwj7JiM9HT1Y9w1eRJBcgxo9sVX97grDIutNcEfDt8f2p5eM4
dIxEX/TQVgSBw2QkcC5GwRLjXIHxbD0ySg6Pjby9M3meUD+Lry2p6ySmtPya
jrDohMc4KK1DoD0/JuA15IEpRWF5atv7oBgIBqDXdWLqRQQZMsDC2vwLhPmA
B+dwVTBnofvA1ad5yqTSS+SnTw6egpElcxY6uAH5IVsWizUgPN2D6NTnpe6r
K2QWAINLxfrKRuQvXdnQAZK5jmTYVJgB2gP/+wbRyAIlC0SGJRLtS5EadLbR
Ot5+efBXnPi/HUgjXrvbk8p+FaGmfaPORr9lszx62qeYgSFlJ2IMD+K+2vi0
tjuDrIm/PdiV6JZr+nxhzndC3fLZeeIA++3GKx+YC7vrmb4OsTPlzHLCZhN0
AcWenvWDDwyNun4zRCiiE0L3zY6lHuWJfv9q8NRr5wLuLfp3rufnv2jdmFni
wXveEY9qtrf7nijxlU6GIWNgxX086P752fCg+zrDfqC9C9gU5i9Deb9XA08S
6Gt5BmH2yqup08m8ujKv/FNcRV0eJFAO8MuHuxMa6i+2tDa0tTYAHpwbqUfp
4exBORZF6t7dmzJEHT9DB8dm4EN5JMs5ropkr7aEKAwk4D+CCSTJuwx5nK4T
o7bKKqu72poHelv4ypyn+Dqcct04kQ6eJGenC/DlRTJdciXLzdM4Sp66kKjT
fG3Bb7fErIoyIg9Sm/Wr41l/P5iBZuio9c+7034TEfvRAWLNscnMxb+MiAuU
mlp6B0FtrW3vBe0XKdgKKlgoOq4ot6wSIyW8qXsQGdR6rgD9oBjDnXNu/qIO
4glAfpaniqZcHG0/KHOWS/Vv7Uh5a1faGztS/rg7FdAZAKsgGeBB9cnTyF+0
78qtOUJNwOajv4yIfzhc9ZJAf/xkNYkTmVHZ+BxfCxBssVD/+o7EOyN3QdE+
kFoJAOf1HZZhjFXjc2v/g6MEhLJebnhZqEXxZKwoFMl3MdmXWlEITaml7PcR
MXMjtX/bjzxph+6OhSsLeq/cxPFkKp7ixpPcB6gXk/EgYZdAnf9ERGywLBEh
CJk5JNr4eIRqb/ppGxaS8LjcpzkIUT7KVyaVN8Kdxp7LS6WGX4XHp1ago44D
125C/cvFBoKyoX7gvAseXIG9InHTyCr3BFcJIJSE5fzs8MkHvo+RGIrHMfQC
mXyOo8bxc4z2vOdUbsppHLVYV0hE929HMgL+efg34crfceIBzH594tSN28h5
ePDW7VCFebFAt0ioL6rthNHvvXYDYEt0QtmuxLKdSZV7kyrkCcUo54VYD2IA
CPpjhAdHoe0D6ece2Bq/VGhYIlT/O0f56whl9tlm5GY5bvsmJucX38Uos8+T
06l/O4QwMjEK292kEVcBF+tya0nUF0BtL/LUs/mq9/ek4Biz6J3G0B2rrrAW
5PZ5gQog3gZkUk+AGUrsg+fbkFtmZWMPMBPE1ZGBBcfaRXjQ4S86R6AmnESe
n2L9mYZeLGY3gqJNK8W6MHkiksAolICeGCLnRWorGzrHcEjYVxQJC4WaRRJ9
NfYXLaltDfgx/l+2nPhNuPpRbvwykTGlvMGKzkFaj2aee4SLYoo+HqGNiM8j
8vDZ0VNHs6ptyDh4a41EB+U3epjRTC+3GdEQwyLJ3mfPvVoGtys2h++86lTM
+xfzBsr8T6899Xsfca7BJz/PiX3n5wICXk3DbPjvdbyYu0NMqyGs7YNs2mLP
QI+TwsMpSPYtuisqzHzzaQr4MV/useTQcYyB1Hsu1X5ErvjpOOC+6NEusCH3
8SDd5+eJL+q+wvi0RHiVxqnMR4byfs/uEBndK9+fHg+yr5xNPQyrq/t9X1dR
n8Ydu3QmLJAY3tuVVN94qampobWt8fODqYAHKT7jVNSgFv5lb/LNsVGSHOHH
2Pzn+Gp8OAtnupdSvnkrRaalQt1SkQbQEImcHyxHmdnhV4BL8M+Sququ9qbB
7jZRXNY0nLfdATQI2gqZAh4MdlqWF0SqP9ibSmIzHkk/E/DD8U+wNQf0UkBP
gLxIxH+AigHfHsMQAyneXxzKeISjDItOwMjRln++db7IsF6KIAm2d1OxT0GX
XiwynLmErCTkmBvoyavFxuoWFGeDFg+S05TP8uIVlnJC1eCtO4M3hweHhuC6
MnQbhTAtvQCIb61UP5sPeLABCLx5e+RQckW0oVRhKjt6srKxe9Ce38H2x51J
L0civf1xzgmAUDaMGj4+kA44/XmhCpkLrSPNPVeXSQwrZTpQvAH0EX9RAB0w
lPvTKuGRkovtL/A0v9uqPJ6J/pl1tiV0m+W2FZEXbS59KiIOES+l8suTIQY8
iOLJ4A/gwekRymAFNV5QACCq1FA88StPvUKIMt1fu3UbyNPlXvx9uBKwDzB8
DAca/TE2+ym+hkofLzOtl6B0D5Psg2JTqHxi0AFgnqxqhE40dF0FaDmbr/3D
Nsut2ygRh6Gg5hFOHI5+Q2V+tCdYMeN4MoWk7wnFdVJd0TZjGWDn0toubPJG
mE5qLAWwGSjTLxBpi5C/qJXgR0dyijE8aluP5yCYLDPNjtQAOiNlTmRVgTy8
okDpWjbHZOVUt5IhBoA2g6d8kqtB6H58HEYT4D8gXMwu++l7/P0oV7U7oYLw
jaMugUEMjTZCQ/84nA2DSPAvaSu7qu3bE1kzeGqUpkFhBvQH0nihlcKDMNwu
9kEYAgce/ByQJnAbH1NdizNmouOB47ZLHQNrpaiqDdhGTxwDwqQI488SqJFV
fXzszl3rX/akw+OAIquQfdDa2nNdZizaZSnfaShR59cMXLlBWoGBWyMzrhEh
qzpgZ2AUDiBja+m9PnDtJgDGPckVv4yIh4bWKyweZ7Tn9dPXRdKnddsnYlxU
IzZV+bdcuz9IG2bN3e/R+xY/ZfWVfSvOJX3SnKeoFU/lcZ+Eirk7Dul1+fbU
IoPt+F6Nr6/10GostP9kVlp8YinLwvf2CpmsV7DhFcvVwDcyWHq5/2Swkf3A
3ceDzJ+fLd+EY21xvIDyz2XU4aLg7PDJUgaYpwZtkEw2KxX9fV/woK/1+1TD
FF1zPS2wXu87/8SmF+6rtOMncvpvkVD/3h7zpUt17c1NbU31nx9KflGoC6EM
W6iPUODdvWnDI3cJGNkckzOTpwyRkVwPFvvBN8OmbebXticB4ArE7pH2oUdQ
YpXIAFWVVJ5vb2u62tMiiM96WqDFVhIjacVZ3tjzmfbVPdxcIwE92dzShw7K
5Va3PvB9bJSxDDT/joGbSyT6l4Xq+vYroOWCqhzw3YljWSiYTO+N63/YljSL
pwLFvvcaxoO1nS9FanAoD2LLIKSi0DpLxcayepTlrffK9U1yhJdXSk0o34QH
f1FCJ4DoaHM59pgj+eysxP8WMXXMVlTb+QxftU6inSPQpZ1poJK62bP74f+h
p9p7rnx5OH06H4FBoATqLDzfAaVK67sDtsQ9wdEGfHt8S0w2WYW+Poai1kDJ
+Xx03o0c5vpgX8ofd6YRZ9p3diQ/ztMheyggkbgswAjEF3SbpWI6J26Cq072
QQceBFg3jaNEPq4y4yvY6gRAhm/P7MBV50F3nuCoUX4Km3V0bPztPckAzP/v
8NhnBcrO/uvAhbSyOkBhjnCgNHgwEmUhCcIOlkuFOpCuG0Noj9ieUB7w3dEn
+epfbD6hLayz4eCca2WWVWKEaIgsOeFBpUifT2UIHCe4imQ8RCBrYOjW/tSK
57madTI0svOF+sIL7QiM371d09Jf09Rzvq2vtqm3rqXvYlsfYECgEISWxGsl
02EMj+AoHtJRG5Wp8FL75VejE2ZGaOYINVmVzeM4awlMjcVCdQh1TM+RXgHh
QegREQmOJncGF5nmX1EkPM1RrYrSbzeVX+q4QmVpxBKRWHIRoNkykR6EHK6L
OFgN4EHiL0rpkzikwNNctT5vwl90Lg+Fww2TGVeLtYFSC0Jq47a6zgHid4re
DmG/X+L1HRRlmC3QpZQjU/XwiPVPe1Lm8dTo/GBjp805jSPmKbngp//ckfI8
V/Uqfh0UJk9+GB9CJF2DEldu3EFxhEQ653DHwW7vHlmunD+dZshS//S1mB9k
0JpvaM/p30M8yEYPd9+JfCrsx3DQrvZTHGVPP/nq38iS2y7fbDg/8ZPb+3mW
fGP+dSozzl0AHH/TMtCPWKA/9cUy3qZXan+K7jB4evtT2xTeRzFfLo/cx4Pu
n58z/6DLOnOvBNJv++DUpwaDy9A9lPOftIB/lDDzmWaPYKeKMNJsnC8y/G13
8qWGegCDrW2N/ziQDpBkA1YIN0hR3JiFAu1f96bdHLtN1OnvY7NmAB6UOxz5
ED56Y3diXfeVgWs3ASL9EJ8HwAqgEzHuBEnRWS34u7jyXFdr09XeRkF8Dj56
ZsB5rikbUBBt8ibWG5/zP9FhPZ4mvRKFbQRt+bcRSpRxG0drfJKrepynMiMQ
Ya1q6v1/uTHpFZdAUy2+0DFHoFkm0YXIE1p7rsCdc02XF4t1OL9AAtQfqCAh
TUygcq8W60GXBuW8rfcGkL1EYFgm0zPgwZAoFCETSEL5JmxIdd5mKfvbvrQf
TmR/F5P53YncH0/k/GlX8hqJLgjHk0mvQA6Wt+7czTjdqM2uqW7us42jtdFc
fGG6QDWXpyUJ4hdF6t7ZlXTnLspcf6a+Y3tSWWxmzYH0M9q8S0RdV+VVg0IO
JV/mqnD+QXRSbvPx7ICIOJRVfNwWocwJi06w4bCrK6T6N7cnEwhK8k0QtB5i
TxEOf88SqJ3x4JPceCqEKXbUfCIidl8qlb+Ao8x/ihsPBXDuDNutobtHMmsO
nzx3IvPczpSKuk7ksNp3YwieXRlpJDudMx4k8WRWinXBGDgATpnGiRPoKVfV
lOL63UmnY3OqdljKMs41k7SG38VkAxKZiCpDZTEwAR4U64tJ6sWyS72a7Jrs
qhZM5OjFjp5QRSKwCMARQP41Mv0ioQHbB21NvVeXiHSz+dqlIoS80CUxUNGT
oowv8ZV/P5ROhtJGAKaVxGe1nW3qOJRydrXcNCtSE6Ywg7BpcpHsjVpHPjiY
AUAyGM8FEKp1UXpiG32Mp4zLriGI7+sTKOMJBsgoqMtyoeqhrcqlYpQaAzuy
kkZs5rL654A2qQHgVd2EfRCJq13kqPODznhwNl9FRnO92LAEkF0T8hft6L+6
Nsq0AtvBSXAnUgNOO6gru9ANkgQj9Z/bExYK1OipRmRX7RscSiypN+RebO0f
JMvCvtQz/85RLRDoXpUn4Civ6ExxkNQAELu6pYcAxt1J5Q/y4kKptKFO+R3o
sm4xr2k/nSZJiJl0BO9nVwUZVj9PDXlSzzwp7QxVuYSRcTfnMexEbFjBvlOO
XxnICJ6sKjNkY3dnDjPn2es/LLvs/M3Qrqe54KtHIntq2VfriRXOd5i555Oo
/Jdcnvjjderd8+44POR9Glz2hZkf8fhWxHEcw63XIffxIN3n57MP0hm1fR13
5nlB1SmdcOdzWX49Tg2/MveFMB4hcb/J8CrP03TwyiVXIfclyYXzU2y2CdpF
leFBj4uwZyI9yQbS2aQWQD3v7kqqr7/Y0lzf2dL4xeEUUMuXClGUTtBp5wn1
ywT6v+6jIqiAUvdDXPZMrjpYagbAiJQ6qXEBX/PRgZOUV5vNKjOUPocyEUBz
llApOlG4Uoq00IrK2s62xoHeFpEyczofmSBxHgHjepzKAR0/ZK3nMPCQiARg
E5ytb3zw1u1XdyZXXmzDYTPLAQ8+EaFCDoQ22/DQyCs7UsvqOuEnVUHNdJ4a
1GniEQd3rt0aekWBmIOCfyJLUwJyR5TrAYW9vjPp+vBd0N9LL7W9JNItF5tW
Sw3u+SYchKEImQBRuTqAgcQs+P6etIDNx2fwtDN46pl8DUBFaBcfxDMCLE07
U48Odg0OLRRqAr47ulhqGhwaAtY3dPYvlaDwPmE4Tfwj4Sp7gnub3ZWUAAYK
NrT1Xl0ltqySalB+hP0ncWjT8a2xOQH/PH4ioxLKpJbV7049DfczKlsCtsS9
ty91FFUzEm05/QxHS6Whl03k1XLGgwJ1/jSOGniCkDIOWfk7jgolocNtA/oA
IBMSbb6KE/xh6kYp0ETZRJE4cdQIVNLiQZRvQqSlBF5meIqvARxHKhq350l0
fHCAmrpHePGO1cBhfoJhFemKsDXL+umRjF98exh6mleNjIDDw3c+OZT1BBdZ
OaHkWql+gUhfVNtuQ/6Ng4CSFom0a6XE3Gxch+UzVAFjZHhJoP/k8CnScHxu
Lfz67q6Uv+xOAVC/SozOOa4R6mA0gSePcDUH06oAe44jjhU+xrGHbbEbxNfL
DbMjNaW1KITRXev4X3alzRciH1p0OFeKXkQEK0yrxUbkasuNhRqG7o6RvgMg
ncmJWxllvtBK2QcBNq6WOgLbTsQXJYxC8WQEGmxkscDMfVaA3JJtCKiOfbA3
9UWYj8AxhRkWBDQZ5SboCADkjm6Ae2OtfQOBUtMSkYHgQaiw7EJLwNaYgO+P
wcpABrSgpnUaT7VObMDMtJAkp8CEB8PjDqWfJbx6d28KfpthJlFMnTcR5ygr
zAu18wrJ0knDp4BgIW7ow+uCzFIV9LpPeV3ZWO1ck6ORMNgN2dDsXDn7NZl9
Ve50eho+T/QzKyTMXXD80xGrn3mkPPXanQxP9HjVB1xjuk6Wdl8lOcTJQctB
CbN9mU2d7qxwVzYYOsJciX9CxTBqftZjZxc5ycI8+h6guv+pJbzKDAMxtOTR
xuvzWj/9RRS2yXjQMfT38aD75+e0D7pftPOdeSlzSL6LkLgE65g0r1lEKmNo
nVaWmGtg/ytzeegm+1TvnqaYO3+Co1ghR+aGaMswxSKj3R89r7cue0oI5S9K
8GBje3PDFwfSfxmukliKC6tbcmvaTmSdeUGgB0X35tiolfIXzZopUIYRecC6
HyCg9/afvDUyQtKugfr9PAdglJYcPwQlEwVmlJmKqs51tlL+ok/xdc6MZR5c
54FzYYiHnlpmcOO+i8tC5KLTYSW9/dfgz78fRCE1XhZqP9iXQlwxo8xlzV0o
MkykpoBkrn+Uq1LlnSdemhxl4X+ExwMEcFidNsp1/xqhRoH6sf/b8ezqB8OV
KP+g1ILOD46PlV3oWSwyBOLMehudKATdGOcfrCAs+uYYig0SKp/oIPEeDJKZ
X+RriKI+cP32GztSVgr1vwpX7TBXEK3eWHLxf0fEA5ogEf6L6wDnWq8PDadW
NGacbs6qajp1pjGhuOFiWy9Jo/DV8ZPP8lQvR+rw+UEU5CQ8PhvU+A8PnwKw
fGNopO/GLSjJU+YHbI5BbMGuqYBbn8QH5VACQWTDNQbLEzagZArqcFUOgZyA
TQAPhuFsd2EK43y+Zq3M0n9zCOW7H7wB/f1/tsYLdAUkCtGZ+o7EkotZZ5oy
qupPVbTknGsBGAL308obnuQrCYsAVQG4RungbbbO/pso34REHRKVBIO+KFLz
2vaE23fQMb7my4OJJfWZZ5pOVjVBhQkl5/uuQBdQoBLA7MskxNXZEkz5uCJ0
Rp0ftFm5cQUAaedwNe/sTbNaEUZr67+yUGwA7ANDDIAUAGDxBXQytKnvBjy7
UmSghE1qz7OJSLW8KFB/cvAUiRKzL/VMwNbjMAVgHsG1RqKjEjdgmZnFU30f
l4udKq3JZfW/xYFWSDxemBfwN1T12vakoeE7UFtd58BSMYoSAy2CoC4Xo2OJ
ISicEXDYDOQ9sDl2d9JpgqlFpkIkezI9yjeB8g92w7MgeJhgNFggJE9ztTi+
KBoEkm/CMUdAzvcmUHkSd6dU/n/h8YSeEMov2gR8++p4FsKL4yg7ydOc+NVS
HZBU1dwFeLSisXOxWBcoMvwmIt5UeInMF4Wp5F/xfAnFNlCUmxIdm9UczzhH
UPwnB0++hIcbJbWUWYK9rXvuk51+GbynJ2hoA3uyWaWD3fadUG/p4bzU4/wO
Fr95C2GB73zacZwfdIl9SlOVN86wbIglMxnKOzOWdptj1gdot0VHPaTmnyGa
h09j5FzeV2BIPT45fK5XktgwlrYX7O3LfssSLW3MdDI/O2noPUsjLe7ziV0T
5VlEOrLXQK+s+t1NBvrdZca307738SDd578WD3pdD90HnfZvBpn3rX7GXcCx
0TDPRD/q95VvDPW7/NNlo/d1Yt4rqpjXYZdfPS1Z7ngw4Mf47IpGAkC6rg5N
48W/tTtlaPQuOXgF+u1MDlJrcRp6hPjmC1FCiuGRUVKAqy+cyUPnwgjGATUG
4BJopyi+aGv9YDcTHnTH6ROywQ4UB2PX0yVC9Tu7UoAkUFOzzraAOt51ZXB9
VAKo66BXLxWZ6juQy2LqucbrN5AB6+NDJ+dyVaCmzuJpvjmaRY6bVTR2P8ZT
LhWoSNOAjBYJ9DP5qgvtV602lNb9s8MZoM/j/ING7C9qrajrmC/UgTa+QUZi
sCAEQaJ0UvFFbQiGfHM89wV0dM7h3EjtROuBgEgN8bG8fG0Y5R8UAd40zI5U
Yw9V+Iy+fzB9ZoRmicjwx93J6Nia1abPPx+w5djzAs1svnYWXxuw5cS7+9KJ
/6Ihv+4RjhLA2ieH08nps/C4/N9z1XOFKgxgUZm+waH1CtOT4ar39qUTyL8t
qfgpDmVLooLJYEA0k69BKcXxQTyeJg8HV7GEyg3LBPqALXGqnFpiutLl1j4U
Hvc4T3MSp5+4dmtonczyLz/GvyDQzxKonuYp/ydHVd7QAUVv3Ly9IdqyQoiT
ucsM80Uq6vxg//VN28wAx0IwrJ7GUToi1WxWZT/ww/FZyG9W/QJfFfBDDCAy
cnpva3z+k/y4TbKEYJkBmZuxr+kzW9ViLXLTxfno82fyUSSWfw2PVeYT1G87
kFr5m3CUGx0g9nwhsQ9aW/sG4PFlIhJYyeLwi9iAz9nNiVTC0BMwdfRk1bNc
AKEWwPIO45o9TQY6qbdUaujoQydSQRrf3JkKw/Gq3IJciOXGIKkpYEtMXGY1
MbEdO3X29+HKMLllXqTuH8cy/3NbEoCpTXILiryE370Ak787QVK6WyWGkgfD
49bIjOdR1nhbZeNlEMJVBGnKDORM7nSeVpNfY8Oj8sWx7Ln2vBioCRECxcRU
2953BcAd8BOlooiywK8rhep/4ajzqxE2R37F8XkwaoES3RKh8WwzEpszl7qW
iEDOkUkX+n7rzl0oOHhzeD1KjIJMjSH2M4zPc1Ux+IgufD49mDWPpyavQeyh
ib2vkM52Da+L8z1YV1kAAWZNz9c13NOvzOetmO943KnpEIFjy2DGg/71kbm/
vu7swW7SQrup+cRnR38d31MUIZ+4wZKfNOd3WDggBfsLbNnT5lKSzTmjEA84
0aVa5kbddTBfe0fbBZb1eOqje7VeW2dPp0+/snHzZtN9X9lyHw+6f/7PwoOT
Sv40eNAThZ6+pzgv2K6xfm1t7jumHxOHmT8+UeL1ci7p8l4xhBYPbo0xFVwg
SdNqmi4/w9O9vTN5aHSUGBq+i8t6jq9GaQJkxGcgEdkH96XcujtGjq0JdIVz
UQhEwyMR6ici4p/kq5dJkKWj9ExNe1vLQG+TOx6cylt0d7aDThskNSwRm2pQ
Nj3bEE6Snnam4WkUbx+hmyc4anPxxXGUZPA2/NQzcANlTpeguDHr5YbnuRqc
ZA0dClPlnf8NV/WbiNjnePr/FXFiGk+VUnGJ8AGAwzN8FQCEdSI9qOXEX7Tg
bNsDm0/8W3jMwxz1Q+Exj3FUoP8/HBG/VmYB8BKdUEZg2tfHskiSRwcTyLiQ
fPTIPjg+0n/t5mu7kpYKdYAIHuVo/nkiiyjVVU29z/Li/21r/PZEFFkUZQCJ
y32Mq8WhNRGAWi01wFMNnf0wHN1XrwPOeoaj/ehgKlmatsTlzOCpHwxX7rSc
JmYdQ/6l30bEAQb5cG/qKG5jW2L5k3iIAcmSJJIhCmS0gnGPwHjQNm796mh2
wLdHfsdRPcQ5Ac8eOUXp/MCaV7cnT49Q/2Fb4s3bw3DzZGUL1EaCCyGkJjdD
63tTThMQxNXmP8aJR5yXmOcBHMP2QSA7LNqCzHMKU6gkYUakOqcaefwO3rgd
ts1EMqHDT8GyRGAXdt1EEWKTSi9BQwBJ4CcEyaMQMEHnBxEexKkzlTmzeEr4
dSkfDdmVG8gqN3JndON288sCLfEXLb3QBmj3Yue1B7nqX/wY90h4/O848Y+E
xz7G0TwUEf8iX/NKlGU+XwuNEjvdwZOVSAxQ5hQjOTcXPKGuJGySm+Hx6IQK
7CtrvdQxAO0CrHuaE/97rjJga5xAWzyGxWn47vgrCjQZF0XqvovJhB5d7Oj5
z23JvwqPf5wTO4un+dfw+Ke56qKLLYTPnx3NBEFdLbFcbAU8aAWJBfS6Toxx
loIy84G4oviieFZ+eSRrNl9N+aniSDvQteSyRiIV2edaZ4g0/zs89jm+9uGt
yl+Exx1IO01+aui6Oi9Su06iA/4skegrm5B/dXlD11KRBmA+AM9fR8TvTC4n
6DixpP6XW+MwBwgeNz7PjT+RVUVeLn1y8NSLAiWW9oRJ5wfZLYD3BA/6tE/5
Wo+v6z+bfc2xbnsNx+FVQQ328MLfaxP3ZJtz76+jXV/5404P/eNyMxubpvNu
7mJ59KOP/kkFy618UsfZ4cGf7vKkd7GRw2BvgsTwoHvTfvDBV3poC9NaaZ3r
oZ+DPwsepO2jTzxxxgLs3Ynv40H3z39zPMhylnmS86lLuMt67pA35sXB7/6y
pMQn4u/JRukHDeypclwMsRpCPOBBY0E9keSqhh5Qd7F9EKncJP/gbI56g1wf
JrVgT0L9QoH2/YPpt9DJJqTaCg3Fv9kS/+mhU9tNFTssJWJN4VqpMVBqKamq
bm9rYrAPeqLT64bi8is+logc1Swll2z2WB/bE04DNCPFnuSqJPoiYqojR59e
FKgDsekHNNXZAsPrOxJRTj/Un3HAfRxl/j+OZXI0ecANwhbAmH/YkYLCg8gT
oHcrpFTQjIbuAYG6UGooluuK5cbSaH2JwlAUbSx+c3syIESFqYwc8gM8OIOn
nPR6EyX7Q3hwjkCTchox//LNoTe2JeEMBcj2BKAJ6CTH5rao8h747lj5BXTS
beDW8EZFArJkyVAmR9xB44NcJSBZooR/G5v7i+9iPz5wklhvt8bmPcdRLorU
vLUj6dbw0J2R238/kgkoCXT+D/elEfdORULFdGThNdr3O6T2A3MA0oYr8zDP
rPqcus0xWZGq/JjMcy0dAySwJnxvicl+khc7jasRqPMI4gNWPx6hCo5yxCm1
zI3Uf3ogFUNja0p505N8JQzZerF2gciA0sHbrN19yF8UOgU0LI00vrEzAZ2b
G7dlnG6cLkBJEzbatbh1YsNSsbG+84oNhT25BTdXYWdd7PqYBH9M46hF+nwS
8+TH+MIZkchnMlRh+fetKoWlmNxPOd344Jb49VL9fKGmCLng2nqu31ToS0Wa
Qpkhf5uxTKYvjDaURhkLvovJBrj9Ik+NQSgajGOnzlJZM3DEXfuYUicsoF+r
pbrZfBVUi2y51tH+gesgGF/EnPz+eA7lzInArJWvL4QhhoF+kh+XWdlILHfD
I9bYrGpo9OsT2Vvjc6uaelHxcVtZXftMvma5RLcqyljTetlG8g8i2zeJWYrD
e8qMJB89Oaz5xZH0WXzjuigU7CUYh3IC4Llabujpv0XmdV17L4BTkPMf4rKB
zzYi/TbbBwfSnhWoUbwdqRlYfbYJGXCrLnXBurEOoXvTKpFmvljdfHkQp8aw
fbg/9WkUNMZAvE+f4WliUeZB9OYB8CBMmRBHulJ289qrZnivVlqPTfhoYWFP
p9euMS/mntZJZqa53/e6g9CW94kntA96rce/8WLol6cy7ly9h2iLvez5NApT
GQhfKWf5k98Sy8wNr+Pu3/rAvhKfxnSSFPkyfXwdSo/1sDtOew+FwbnMfTzo
/rm3eNC/We/ThJr0iDcPc6/1s6TK7lVlcv9mSbCnX9lQxZ5+T6uTy50pcoNN
ecQxuesrKfcll2FBdieABg9uUVkKzhNlHtS/p/iqN3clD4+N4CxsViqejP0Y
Jmh3C4Smd/el3xoZIQBEoM4P2HxUnV9H8rvBf6C1LhebyqtqOtvqr3Z3eMKD
vu56njoF/QX88rsI9S5LKT65haj69EgGCosahULozI3U/mUP8qgkBMfl1P2a
cyIIB0UBlT5MgTLav78/rfMqOnU4Nm6dCCOJ/2jpHfzrnlQAlSS6yDqJbrnU
2Ds4hH6jwpxYSW4Ae3QX67cncgK+PXQg9SwgArjz4wmUyc6549gMZ14bZZop
UJZf7EI5KcZtb+xMWiRC+GVjNDqJ9s6uJFL39dtD38flE3fHjHPNj6DoPcgW
QyYU0P8sT/XNcSrrRFFt5wObT3xyMI1QAzDtiQgUdwVw0xs7Ut/embxejM7c
AQ798GC61YaCAh1Jq34IBSY14XwiCYSrG3GsTpGuhFiCnMO54Oid45c6Bv5+
NP1Rbuxaqf5FvuZCZw/O3IdyPi4SqUlISYwR9Oui9HNFus7Lg4RFf92TvECg
DZLqZwu1l7oHbOOIY5u2ofyDG6IsD0fEnsgkB9BsYm0RIgy/hUBpEWQIc/2O
E49dVVFKjl0JZ54MV6FgMnL9RuQ5bAAx2GapIBTzdcXPcOM24FEGFP8CT9PY
g1I5wGiJdEWPc+LniVR1nQO4MBWZZ2JI8aepd2C6QAVj9+WRLCwSo+r82ie5
CMfZnYrNODUnwoP4vKHllSjzAoFunlCffa6FyhjhqHGcpL2wSo2l03iqIKkh
RJG4WmwEUTQXX5gUOcdue4Wv6pZeFDM2UgdYeI3MODAEgM7aPnB1qciEzx6a
8JAhSPhwuCqtrIkMzzcxOS/gM6HE7BusQHNkBkf1xu5EnMHQiomZCPUDzLx6
8+7nR7MejUAvLsLkFqh8idjY2X/Thl1MF0Ya1xB5k1seiVB/G5uJezQ2cP3W
ShFKPojOu8nNj0eojMUI3kIDXxzDS4cjao2Hee0eRsM/fc/rAu51H6Ev5k3F
on2X7sm4yUAV86ruaZ1kLkO7bHpthba8V0Z55bDXeqYyXu7Es5cfX/dlNr32
iVqGfZw9B/ymk5Z7DIV96gUbzrARYJbsZea51x55pMqbkszgcc3AKz/G616N
PssWvbpy3ceD7p+fAg/6Jy2+Psj+fYKv9TNsLi7fvkq+p7nGkhKvvfDk6O5y
37Fo+zHLfBogd2K8uvrQLqrBHvDgA1vjdUUXiQpX2XL5Wa7uT4AHRxz2waxZ
fJRCYolEvUyEgB7xFx0aHSXWFpGm8IEfjh/OrCJzobWvHyUdExvLz5zvam8a
6KWxDzqsw7Qd8TqOrj9hM9lLAu3HBzNzz7XlV7eklzUARlgj0ZHU8IES3RqZ
3pBfl3u2qeBc89fHsl7iowzawbJE4mq4SW5+mqcM22Y6ln6uvvMqgoT4U9PS
fyDtdKDC+CwvPkyeCDrtRlnCOhmKP6nLq4Gq8qvbC8825p1rLjzbml/dlneu
tfBcW+HZ5vf2ZzwcEb9ZlVtc3V5wtu2j/WmLInXBbmK/Psq4WKzbn1KVd64t
vaJ+0w4TOkOH4zECSc/z4nYnnS6sbiqqblfmny86215Q1fJdTPZsPobnGL6F
4oNjaySmkGhzall9wblGc2HdywLVn3YmFZwFYtq/PHxqXiSVAG6JyLBUhNAT
YAQYyj/vSs492wIEb43PBe5hSGUIodIi6AFbLRbqvzx6MrcadaqgCpEBfYSe
msvqueq8lVLTjHB1iCwRWt8kNyadaYSOx2bWLES5zqkI1XaAaZwlUEn1JfBs
6fn2zw9lvCzQBkpNy2Ta2FPVUCcgCBxXE8WifJmvP5h+BjiZV9n86g4zsYSG
KhKJcywM6DwULScVnoKB3mYsm8XXbpQlUQGx5WYY2e+P5xRWtwBLvzqaDcAT
8AjgNUCLM3jaLw5nwWCVnu8EcZ3NV60QGo+dOlt0rglqg27CgGKmtRUhKUI9
3ZdyDgZosUDz/p40Mrh8TdGCSLV94pOQazgAkcIcFKVDrpsy06vRCQsF2tkC
nUibd7q+Z3hsjMCuziu3TEV1f9ufDngKHThVmEG0XpVblkRqp/OUXx7OTCxp
bOsbpDaVcVttx8DepIqlEvPLAs2rClOgGKUL1OddhFFTZtWuliI5xO80jCQo
7lyRVm4sRYNV2fru3uTFQi0+AmnEsT2NBOXN4imXSXT7kk+fb+4ZGx8FQDdm
szZ0XonNOvvGzgSAuiQ7xgaZeW0USuupzK4GCYzLPrcK41bkniozAJKdJzSq
8i7AEJy50IXsgEI1jqdkAdwq0ReBtIAovrsrabHIgGLdKPzJSD4Vf1GW64l/
67PfWhnLfWfSZbfae9KT2az87luw42LYR7wvvL70l00lvu77tAV8i8k5OYCe
f930lU6GsWMzlFMkzysNnsozxC2cei+Yy7sXY+6XT91nxR9P56o8ZLF3r5kN
n6co/z+FnHhl9X086P75GfCg1+l2Dxc05tlBG/GMJT0hLMCgH/PC6zrmEmPT
p/Lu88K9U/dwH/FpUQ2h29AZ3iuG0NsH44wFF4mZ4GxT9zPcuHd2pdweHSM2
ms3xWS9wtGHRltd3WF7bnvRqtHlRpOa9A6no/CCGkAJdYcDmmKMnz9lwwruO
vmugOoIaX1Z5rqut+WoPzflBBzHMeJB2s6brGopm/4oiYbVY/wJfRaKsBEtR
um0ST2NjtAX027mRmlk81Uy+Zo1QtxGZFA3k12CcEhGuJZH6JyLi18nNH+5N
+Wh/+od7U0HlfowTvzwSZWDHoVSIXQ+RDQrwDJ7yBZ4GWoTmZqJ21S8I1HME
uhf5mvVS/evRiSvFulk8aFS5DllVEkNwIrYNcic4jHVvgGn4QTXo2wADQwnQ
w3YfqAqQFHwDS6Gt2ZGaJSIU0BL7TyKT0AZMOconLjVBJTN5BgCeoTjP+AsC
7SyBGrpAAp8SPEUeQbkg4RGZGTGEq14tsQCLsLsjQnAoHk4UCly5EadfhH7N
5aln8/RQGAh4gaebwVM/zYuD3oUqLJtwDrtNcst8gWqOQIP8A4kEynH2BGy3
AlIBiSwSGoBjc/mq9RIzDBZOWGmYL0SBTV6K1MAAheG4K0DYMqHpBb5yFle3
Dh5UkIOWxhAFgpkAGwF7AgJF3Oarlovhn2aSx4QIEnQEcCWwAqiFYq8osC8l
tk9BSYAnwMZZ/LiVIvQTILKFkTrgEkgFDCI8AsMHHUQ9hfp5mkUiLX4QRb+B
AsCEZWI1PqZkCsIIFDPf7MjQsUGuB2hGJAo4P42LxuvPu1PeO5D28YH0TdsS
noUm+AYgMkymx4Nittevh3af4as2KhL+ti/tk32nPtqfApD5EU4cDH2YPBkG
BdiF8LJQC7TN52s3QYsKHRUdXY7CPUEHYd7N4aKBAKi4Cfsk43A3ZnsGQMTP
lSLDI1wVDN+7+1M/OJD20b5TIAlPcOMAO6NgoRjnEudPoG2+EHEGhslpTAGe
m0HeYOBmCpQv8tFsColGZIBoAbwFGmbC1MADjcLjYNeCULnrCsZm3aZ9xNe1
1L912GvNfq/wLNd/R6BRn5QB9/WTuSE2BxW9Us6mv2xq8HXfd73sEVnZQ0JP
W8zUd3NmtrMkjFlC7hXBLOtxOZ7pMrJeL/fm2JPn+CPUWwhfNnLiB99Y8Yex
42zGa6ryz1hyomm3+KWe1hk2Dd3Hg+6fnxoPTtogZK7/9CSxnkTOfUK5OyWy
mREM8s+8DrCcsO5EevqVuUJf8aCn2eRSIQNnWM5fr/x0DoPmqX7mtdellRA6
PPiLH+N1RVQaa8CDz/I0b+1OujmGQgiOo3z0OQ/8cHxnUuXgrTtXbgwV1HY8
x9f+ZU/qjRECGK2RmqJffBd7JOMMQZTtl6+vkFlWSfSlZxAeHOhpY4gv6tJZ
V8baNyCy0TOsco50AzjKinG9wlGAwiMEDVHRP6KoWKDY0w9XAvBHlkiUZ1C/
50XqADyCJrxObMJKOMkfZySn6oLxwUMCQnFkUZTXm4AsQkAgrhOhMGQzMpKg
nSTaBooDaXecw8syOsAI7aJHUB8TCZTDSQcsIfajYcEYzVEOkzKCO0xh9o7j
AkZ7GQqnBJOIjogkC+k10IlRngXb7Mh0AF6ZSS8cjA2lKEEkbaSC3hiwb6rB
DhhJBBVk+COdIj3ClkpDoJyK80lYQS7SfeASGZ0Q3AQyzmLmIAOWPSoLOQqK
M12acF+oBBBkCgRFUfoeLk9xJhAXI0bVYJw4ciPOtE5GgZpBciIJRmqso9DY
wcjakbJdJ8RVbcBSEUblNESiQt4DUEyYWN8sISTThP2twqSUCvZRDpToAXIC
1JoXqQUght88GKD7JJmF43HCQ5S7U6wD8ZsjBGStXS1FKGwDld2PSpqDIaQh
iBpxYxgl/ERaiIRbqJJy51dDEwmF4XGAimtkxpeF6gUC3aJIHY7kY8bnRk2O
QSFUbbBHpLGnladSe1DvRqhBpHQMLBJ6ShrlRD4tVOt0KyGzdudp/3K946o5
OwkeOw3H0zrMprAfCz5DnS4rPyqMRc59SWdj1/PEJednKQlxTnXBvNf4ckDJ
UQ9LjMaGP15rcPTIa7UT+Yx84aTf19RrdtkKf1JqPfHNWXKYuecqyXR88Ils
T494qp+mBjf4z8Rqtya8rlfO1XpaVbya+z3U72U1Y84HN4nn1PLo9KvT7uCr
hNzHg+6fe4oHE5gnDu1cC6FDeczzmuXUC7FnOKVdB9wfpF0laLvjADu+EsZM
Lft10mt5vwu49IsNSS5cYtmET9wgR3gWiPQf7EkGPNjWVN/W2vD5/rSA8Fhd
QR0WZOvZxt6neUrAgzgfvZXCg98cOZ6B4tijCCqd/dO4mj/toQLOoLzb2uIH
vo8hBeDT1nd9pcwAam1Z5fnO1qYrl1sBD04n+a8RpMK9Q0Yfj/noXZJQuOza
nryqSG1BdksN0ksV5lApwaGWEErfppb0jRPeLxYMHLAujYNhUjTI7as6BoAO
gIOsWvYQIhg12DV5BLKQHcoOmhDuwE1QkBM1KjUS5IgRDQm6SA5/4cVcQdJg
majgJPZ1246VKMdLAqlApd8gMztcFqkylD2IHG0zbpQirGSvhzCTpBc0ObR0
h9ocTJBglANnUbCRFEMZ7hxkyBwlJyn5KKWCjCSzM1PskuvD7DsjsprJEgl+
JLgJZ1gj/MEIMYpCssQyRY2FzGAfdwuh3GnRwOFhqUExE7V5Q1QiNB2oMIZK
jYSNJPbmBjw0mAYYviRyZ6MTYgqhZMAShtmFUa3ePiuNxC+XZNmzDx8FbKkO
4rF2gvBGB8QLswttUBR5GzCxF1O4GAFY9M+NsgT7oJiC7axwDJwDbKI6pRbs
9GskDCGmTzswNGHZcNi+7fFFoyYScLsvQZ5Waa9LMW1J5vPLtCuh61x20k9o
H2FYjd3pnPQykDG5oad6PN0JYbHt0lxu2VTZ8Jn5jvNP7Othc3/SMLHOzeE+
Lu5jzeZZ5p88ecI47rtmh2eRQd6dIV5nBMtx9O/y1Lp7JpEQD5ujh5o92p09
tc4wqZkZ6KDN62E0hosVTxhHwZNc3St6pjK+tAYL9nxwkQryBpU9x5ilhYGS
kPt4kO7zE+FB2nH0lPCF4f2bH+JK0y7dHeb5xbCuslivPJLk6/z1VN6rn4wf
qxPLMgx8Y6DB5Y6veJD8BHjw/d3IPtjc3NjagvHgljhd0QWcbnu8srHrGZ7m
TZyPnviL/hCXG/DdURKOHv55tr4TAOOf9yXfGBnD5wetQm3BAz8cP5qJ/EWt
tvG2vsE1EtNqsbGkqrqzrX6wu0mI7YMEC5AkZe5pByfR7yGLrnOvHX8T+BBC
6e0TGZxDcWZzYgEMlE+oxBPGC4IFsIumI/O4vR775iVFAArfp7LCkdmHkIt8
InF5sEN1V9jhJLGFYWdO4pxJ9UhBTI3o5kbcRJhMj4AeVY8FmzKxYx5lcDSR
ekLkE7CORO9HrURpsCnHgA98ESBMstGZCBwjFp8gBaHTQlAPySMJaJH0keCa
EMoSRJ1Ho7z7ZMTiScEcCvvIKTrt/0QYJ1BOBdukxgJHL3GaZeicZojMbnBE
iSESHGiUQCTMMYudHmo7w8DQgdcQM5H9zm62w0DSYdpDfcRcNdixM4bndlxP
cCh51oE0QwmiJwyU65FfpcIYRMxtpE4MM0lbiKs4ZApmrBGH20Vj4fCEDCGv
XDBtwPONUuMEbVEmkiIQi1OiXVYthC2OE3YO2xxhLGqOnPuTopLBTm8q0BUF
pOooXmFciQlODKZea5C5kBBCvQTA6F5KvQmh1RYmesHamuO1pPv6w2qxnYwH
adc990YdTTgvpzQrqrdIkp5W76n0nbnLXvlMrTxy5znlsTBzbewvmq2HHR5k
yU+vQMzrr57wIBuusifDa51suMTAOk+buB898umi5V5o1KQs9pP2WQ9keBoC
95rZvPynkTpGbYpZQtjzmZkShlnstV1mSfDUX5/a9aQyeeoL7RLqqRcujzhT
EnIfD9J9pogHOzvbHXjwk72JtAJD4+TJQmB8Elc2lbjIrU/zy9370Q/C/Ji/
PpWn3WrZzEr2Zdh01vmfZIn2b6Qmdc1uH3x3F+DB+ram+o7Whn8cSH5ga7wx
v5ZI8rnmnqc4KN8Eye1uw/bBgH8eP5B82nHA8GmO6k97k4ZHqBCFAm1xwA/H
j2ecw9EQx9v7r62UGVZIjMVnarramwZ72yl/USl2I5QSS5yrxwJNL+xvupz3
JtrTLuuj9UTtx/6cemIFC0KGvAR8Go4KAomsUZRvnpHKnUHhGj3GcQTTEVXc
FIo0f4eqbwyMpuwvQXZrEdSGLT7QowRiNkIKvzSBRPZAqj5yidQFyRJCJ84B
WQjsItUS6Ie8Bwk+tTMEHd8jur2CnPyigpZQEEmGfflklLMrcRANltptYbiz
uHdUDgLUNZluI/lbasaID3tCSs0OIEN8QSnOSymDo1MCcbvFU26aZLWxDw22
RiXYBY84o1LHLamzdZjnAJGogKgyZC4EXlEoDw+THT+SbHp64BvO4U5JODy+
CeFxC8FxCDxiUEZwOmV8pJAa5edJ+ZrKKIzs5AKK/kmYbHd6BORIrbrEZxiF
oEGewMaJscOmYcK3DRRsN5IwMsQjl/IlxmBzk0KPWW0hbCScDLW/l7AbYY0U
jouyjyzBsDLTJkw5MXFSAoxDABHmE0ZtiLLbWKOQ3TOIMhabNlJKlwUdmVRY
EGCctFwbHQNHu56HTNYuWK7PDCsSm73JQ0mPeJCBqhA6SOgQ14mFhcW+4PXO
1PGgS80Uz92ix7tMNwYK2Y+Xrxeb+r0OMZubfoyL331n3kB94sNU2M5+NGkJ
8zvFAI3sTVY2QpySV7JX22jLTGUlmSJ/mMfI0yRluHzmswcjta/0M7HXmwy4
dMEPPEjLh5D7eJDu89PZB32QOs8Sy1KMmWWedp6ynHRe5crXR3yVW1o+0Bb2
9B7MZXVyqYeNnwbL9YSGSLqXP37wmRBJ/EUbLgEebEb2wYMonoyu4JIN2wer
mnqn89Rv7kocumMdd5wf/D7mQOpZggdPN15+mqv+877km3epA4Y8Q0nAjyeO
ZFDxRdsvX0f5JiTIX7S7relqTxNfmfUkT0t1xP5mI2hyfmrvbLE/S7MxyfCZ
LxmKcWF3k7Ng50k9sXwFRRFPPz3Z7MhBMEobV1AKP4VPpZTFKtQOVdZJdAsF
WhTDM1K9XGwIVSTiw4b4UA8uQ7R9FNyDchpETowYn1qICRJ796GEjOsAj0gM
m4DOKAOOdUOFAcHxUS2kj8gmqCCGNqT/h8kcZk17FBp8k2jLgXJLKAoXY7aD
DuocGWEpOkYXZVgkUK6DzqJMGcawaIRSF/FRkBmKNkAfMvNGu8WW8CcQR6eh
BAZ7gYbiNHbYIIU5ScE6PYlxiviMIR4gPgTuELrUE8sXlTpQTh3iI7CX+Nna
CziGHgWxwfAcWkERLAMlRooDMpPDuIzbNTqOUlJ5N+T6CSdMXIAcnASoiMfa
bLd+EouheYVIuyRSj8Py4GmFgeFaqZ5YdTEPKVFBQBuNOIXdyFBuJBFXCEaj
vGdxu3LLikgUpwWaAyavkaC4K9h7Exnv7PZTDOuiSJJZbEmM0hELLAX05EZi
1MNvA4wLBeoVUj3UTJoA0QqS6tehjluI8ZrCTVFGB6inTvBheyICy9im6cDy
gXKaVcLTNGReP50v54nJsBbRLlbsm/O6+DsqpPmebFxjuQ6z2Wt8XYcZiGeo
x9MdNvWzr3lSnZNPJHnlm6+te62BvTzQ9p396LDviH98ZtNrTwNKS5jfGJC2
dYY3G55WCZYs8oNLvq5L7Nvy2kHny5PzmD89YgzrxHyHDX/Y8IFNX/x4NuQ+
HqT7/HfAgy47MvPxUp8kjWGespx0zHLFLG/sZ6XXku7/pMUXLJc7n+YaG/54
IpKmjJt/OPv5u0BkeH93cn19fXPTpc62xi/3pwRsidEU1ZHcZ2ebe6Zz4t7e
mYj8RfHnh7jsgO+PHUw/Q/JoVzb2PMvT/HlX8s1Rkp7PytcWPPDdsSOnqkni
s/bLg2vF2jVCXfGZmvY2dH5QiM8POgim6JmafE66sD6/WqpbI9FtQJYmDNYc
57CQVx4V8YMc9wvFMToQ1lBQDoEh0mT78UDKBRR7VBrXS/Vv7s/6Mr4YcNCb
u9Pe3pcSKEHpGIgXKMpdGG1ZJdAs4qPA/iSOIu6II/gGuqDkQqFmhVAPYHCh
ULVWpEfOgcgEibwxUdhMZCFKCKNO6VpC7XFUqD0aFw6RUSFNSKeCHREgo5Al
cQlfuUJg2BSVSIoBJYEoKYApNDrl8/ii17cnr5MgChHK2576hTL3zZ2p6xH8
wQTg5jbhGDXItiUzrRPpF4oNgTL9JhllsAixg2WMWIlNkAq0EmLfPUm4GMor
FdVs2ui0NGFTLOL/UoFqlQRhMWxBM9k7a/fkxHbVRZEaBL2lhqV8HWA3eDxQ
QYWvpKYthcRNBI2SQ6kkwCZ6VqANi07AUMsAlGwiHqQYsWImGD6ILfjoSPp6
MSIyTGFcL9QvEGjXS4zrxSjwy7qJ+DMmgtlxH0kNJF4KGqPFXBWM6UYF8tQF
8qAwANi39p96a3cKQMu/q0r/sj8ZOBniCIgkp5gWjK17QPZCrhZmSlh0EuUT
a4e0lLFYptugSIXh++Pu5HViA8F3KyJ1KCu9RP+yQEPwJmVhxNFoieMxIkxm
egW/HwiyOy07Kt9IN5s8TUPm9ZN2brp7onqCil7XQ0/0MNRD++2ij/mNB72u
7SyvqftJeqLKV9qYd1L3cfSVTp85422/9iQPtH1nuY+7F/DvKZa9Y7hoi91b
DvvaI59mgceu+YhevVbu34h46iCDBsgwTPdq3N2J8W+8XO7TeoCwrIEl8cH3
8aCHz8+DB3+K9Y39zApxe4/kqRjLeeFwH3X2SXD+29ODvs47T73zuhT4MROn
sm7QDhZtPbQngLzSE4oV9UUiLYonc6mutaWppbke2Qe3KvVFF6wol7itqqHn
Wb6e5KNHwUOtVnx+8PiB9HNE1M81dD3FUf1pTwrJRw9XpKYAACM5P2hD8WQG
10jNoCqT84NXe1qkcdnTeepQ6ugWBZru4boKev5yvoGbVr/jVPXqSD1AtiCx
fpVIA8gL8N1KsWalUIsz+lkCxSjt3ZpINQocGmVeLdCgPNoYLYJ+vlqMzEYY
1yAsAHjh+c3Hvk6pL++7HRhtjmscSb/QvCZSFSSxrBaolkeiGI/rInXv7M36
LCZ3VaQSJ7g3rRSqV0dqse0GHQNEYJCn+kxVntpys7DturKi9Y+7ElaJESpZ
KtIAXgjFwW2CJChxANAJ9CA0J9KtjMRxYxQW6EuQ2LhWZASITYxoQFgQMuoZ
Nkj10JHVUsPHsbkf7jsJUAsoXys1Lhco0X2h6s1DJRV94/84kDpzazwwBKDr
piPFlf2jW46fms8HfAr4QrNKpCN2STwXLEuE6g9iSs3VXe/uSloeqSMpBqDF
5UJNkB2EQh+BVAKfg6R6aA4lQMRGqHUiLfxzvQQljwA4Rup3uIkCVZ+qit7a
bgL0ilIbSA3LIpEdbWOUyWHWXCzQvR9bnNBwPbd1yFDV8d6BVCgDTADsA4B6
nQRZ30IkBsCzwBBAXvAI9HSVCFnHYMQ/PV7w4cGTQAPGXEYgG24G21HAaqF6
Gldvbr6jLm+aw1MCvgORWCoxCdIbszqGM1uGdmeeDZUa18ks66W6ZZHARnx+
UI6ag9YBnK4RocyVQPPnsYV/3ZcCAA3uw0CAUM3mqw3NdxNrGpfI0vJ7RwWG
/Cd+jIHuIyuewrAecQyRAXVCd0AOoYY/7rIAixBKlWiA1PViAL9J5DTowvDj
K3dmwvAJdXlzOboNIm3QjtTtxV2W2msnm69uTy9fJ4FR0L+iQCFMV0Si9wzI
gKtI+CI2/w2FBSdVMa0VamAQg6TIdonBrNFxPsjTeuiyzjCsn36sjR72C6PT
316WPubWHQUc3+jy4GzPcgV2fsTTG9cpXu6c90SP89ix4f+9pdBXvt3bAmx2
XpYDzeZBBhr847an/Yv9aN7b8XUEHnFpy/l0/8RPbnFNvXdQ7lqzT4xiqJxZ
Hhiq9XVQvI7U1Mfd3QrPvjbnO7RaNC3NDC5wLje98iHkPh6k+/zMeNBFkFzi
f96TZcST1LncYZ50PkmX13nndT6yr80/Mphrc5+GLJnMfNMTk2kJY+4dOlKn
SJwv1H+0O7G/s/765eabA+3/OJAe8OOJtPIGbOyzNV6+geyDe1Idsh0el/uL
b48eP0UdMGzsGng8PO6vB1KtONrMqM0mM5Q/8MNxZS6JL2q9dtu6XGxYIzGc
r60bHmi13WgXK/Mexy6X9qAuDs9M1tLotnM5X4BlXuIZTlTeSDnfvZirWh1l
AQ3/nX0ZYQr9LIH6jf1pb+xMAnwK9axRmJdH6d45nAEa/ly+6k8HMjdtMyMo
ITctitRs3JX2waGTS0WqQJl+JV+9Jjr5tR3mb5LrMtuuvya3fBhf8oWqABTs
hXzD63vT/7I/ZblAPYOjkRX0ZzZeBsAIyOJlgebtAxlv70leLNCQJOCA0T5T
1zTctB3JO/+VpszcePNHdc6MLTHLZPp3D+Vs3G5exFcDClsfZV4kNb+15+Rr
25PmcFWbdp96e0/iMrF2Q1RioNyyPMoELb6zK2UpX7M+yrhhWwoy+kjMG7Yn
QSsvioym9pHDWRcWidQrROpVsoR3j2SHRhtf4sa9c6j8VMfQx4dObtqdGqIw
zI04+sbhwryeke9iTs0Kj10k0v75SM7r25PnCZXIgxFj2Bf5mujSPqvVFpV4
eg4nFpi2gK8K2Zny3sFT6yVGgLoLxQbcx1QYYuDSMqkZmgtR6JaJECpZtz35
gyOn1kUlQMnFIsNbBzJf35ME4BGwJICd5TvSM7rvCkxlS8RGQNCLJMb3D2Vs
kpsXYvgG+GUpT/lOzJkL18fiS+r/oSxLrLseach/SWQM2oazgSiSgzB4B5S6
OMr8+t6Tr22zzBfqYBzf2g3MOTFHkpzQOnKs8NxCKSIVWnn3cNYr2xMRUpYZ
Fgn0f9iVGrw99UTNjWP51Qv4GugyPC4v7m64Ph5pKOWdrLPUDn6wyzI7ImaV
3PLekcxAqWURIL7o5EC5aZnE8Pb+7Fd3JC3hxy2VJaV2j+w5VTUvUhumMC+R
mUN3Jr61J/VLbcWXJzLWylNOddwN1+St35a8cVviokgVejMQbaFSXWxPCpSq
1uzIzO0elSYULcSAepXM/O7RTID5IKhBEh0w+c3dKa8dyUnrHI1Q57wsUK2J
1IYczC3qGzmae36rpbqq32auagaWQi9WK8wfHM6FEV+w9diGQ0U5l+9uic+E
KQBCuHFXyvuHslZLkUlxk3198BpPhnY98bJ+yicdO/K0ZnpYXWmix7DZX1yW
X8evLm35t4/QPnJP8KB7NC3mUBshTlqiJzzINDSs9yOGqnx6yu/aQrzhYga5
ZWjFnQ8ud5irZd73/eOn16FhmI/36qJ9L8QQqYDlxHFZOlxk22/5pK3cpxFh
uZ54JZX86oKqmOMFsa/HJymird8rHmR/n5bsSWvgfTxI97m38WSYJWHSWFPx
HOxnf+7RwuVVNhySzDC/PEm+H/Fk2Exqrxf78l454FM9HjviWIrpVmCG/jKQ
wUwV8ruTGWbyNZuiE1MLz2SVnMsuLf/zruSArXF7Uyobugbru/rNFXX/wUF2
k3MtfXVd1y509H966FTA9yck+qKG7oFL3VeTy+pRgSjTmeauSx0Dlzr7vjqW
E/B9nMhUCDVc6rhSUNu2QGwEWKHNLM8pqy6uuvD1odRfRyjX4gTx1CEp+xsM
+qF0kmrnlx7OkuNY9Ih97WW+fm9Jr6qk/kWhQVbcoaseKLg8pjndKUq9kNcz
ntc7+NH+lMWShD0l3aa6/oK+0diKpqiMS/m91py2Kx/tSpkeHvuZ9nRO73hZ
3+ih3Jr5PGXozgxL83Bu30hO9+2UCz0bRLofki7yjaULRIZ9Ff1Z3XcKekcj
9UWvHC5K7bpb2HvHUNf7ijyJm9RQ3DdS0H2Xq80H7AbcXiGzpHfdMZZffCbi
xKytasAUq4Xq4OhT8TVXSvpH8zoG/340dTpXL8lu1Fy4BtUmXOgVp9Qkd46W
9d/6IS7zeU4sP7s+4dKNlI6R8v6RzfE5gHFi6gbDVZnPhMcIC1vl6VWf6cvy
e0fzL4/syr/wtbY8ueN2ds/dpIt9b+3Qr4vOSm+6ndxyI7977NSl/tclunV7
MnJ6R744mPg8R7enrBf6m9Nx/Zvj2Qt4ccDG1UJVyK5Mfd0NQ8018/nOIInq
RZ7qH9qq7B5rxYA1rrxhqcgUldlS0jde3neboytYJk2Mrb1xpm8srXHgDYXp
tV0ZhksD2b02c00H1LY5+WJWxx2AMLKk04DIAN7y85pKBmzArqi08lVyU0zN
QEmfNbv9xufHTwEuBlywQGjS1A+l1TS/zIl5busJgEWA13aW9e3LqZm55cTn
uip9bf9KsQZqNtT15fSO7chu2VPUdbL7bk7Hza+P536sry4dGIFh3ZVzfqXU
tLe0p7R/PKvt+leHM56MiP2n+Vzh5bH0juHTl0e3p52dDyBLGP+HgwU1g6MC
df6DPxydI1Avl5oBRr1xsCCp9WZF39jJhp6/7jC9JNLvKuvR1PUDgstpvf6m
PPHvlrqyvruFl0ehIx/HFcWe7cvsHjtW2vx9UjXXlL9EmqisuwH9yui+XdB1
9YNdhrU7c0wN1z7YlzAn0niiqn+rqeKfKU2lV6wlPWN8c9kqaaKq/gaMRWpd
3193GmZw9TvyO8r7x5NbrpVevvN9bBaQul6gDtmXldtt/eZQUsBXR/54rLT2
+tjXB5PePlZyquN2Ru9ocm3nH/ak8fLby/vH8rqHtyac2Zx8CQYuv3foSHFz
mFS3hjpW6SXOvKd1j3n9pFnW6NZA2gddEkxMZZNips15G2JoiKG/XmPI+HdN
4jYLb1IG+p1JZbkrMdwnx2b9GxSWAuP1Weef/MCDDoH06hboqVpPZE9FXL2y
wmvrbOq3yyr9q1daYtjEk2FTm+O+y3xhw3+WfPB1RDzJlX/jxXA+i6Ee56fc
7Ti+SpHLHQay/egj82RxlLmPB90/99Y+6CI/XmTDLS4Hm8uPeeH1EZayR/8T
3dF1T6LrdV54naEeKfSc5oC5X7QveP1c9xhPH9NWMokJVCYyiz0uPRWuhERZ
CVP8/+y9B1QcV5YwjLz7feffb3e/3Z3dmZ3ZmfHk4HEOkhUQoGRbIMue8QSH
mXEYr+2RgxI554wQiEyTM91NFiBAEiAJCUkoIYRyApRQzpnvVVV3dfVLdasa
efb8hz7v9Kl+/eq++256975Y+/aKut+tbHhrRd1vUEqu+W2y+bfJ9Sjn7VWr
301vkf5COX9IRTmN6PsPyXW/X1H79sr691Y1vZPW9PuU+t8m16L0u5V1UgHp
J0rvrWp+N3X12ysb0V9iDipZ/xZKK2vfSa7/dVKDdHXCwljx/MYEZhtV6EMQ
YWGseUqYcdWmc6UbDzwbU9t6+l7z3mN/zFjXNnx/09CFd7Pbqg/fMPbunRq5
Gjnw1VsH38nr3nL2bsfBkffS29pGbme39bkltfSeexBS1jZnxWoULfqXbcrY
dmH9odO/S2xM3nR2/bHzcyJNeTsuVmwZnBxp9K/f+W76av/Vg7su3Psgu2Xl
lrOr94+ilvo2DCIf/o/xpkVlfSh2e39lPYorPZI7uk/f8S5ofyGkStjeFV39
UoQpv//a5hMXEZ2TN57qO39l/opaw8DVzSdH/5jRUb3vysCFO3/JWZPZe7Hj
6JkXwkvy9l7bcvLSOytro9ed6Dt3+93M5tXDtxNru7/hX5Sz66p5x+C8pNWN
R24YugffTKz7rLTHq6Lz1yvXbDh1N3tt38z4pq7TdzNbdr2Z0tIxcqd8w8Cc
Vc1tZ25/sqrJc/WhzUOXXo2qDmg5sPH03bdihf1oU0KKfRoO1+46NielFVHv
s7RaFD/uufAwY83293LWLineENZyZODS/WW57V+UdP21oMuw82Jz/4mpYdWZ
uy6UdB/N3Dy6bXh0YbL549y297K7915+mGTe+FZ6y6KCdfOijG4xFe/n96KI
JqFpq9uKJsPuK9uOnXsroS55w5ntF66/m1zrHFo2Z0Vrx/CDCFP304ElCxJq
XomufjbSXLXvhqnv6Le9Db4NB1EQPTO6ImnLmcOXHizLb3/b0OVn3P5GUkNK
7/me4Ut/zFtbd/xWwYYD86JNiZ2nN5w4Oz+yPKL9cNP+M+9kr9914UFy7cbX
09vXnbyd1SHMD84MK/3MtHvjmZvvrKiZESXESvMiK5wTmpqG767eeRipUuXg
jfYDw3OTalpH7rcOjPw+tbl15G5hx55XkhA972Ws3z0nqvLLmu3DN+6vqOud
HluTP3C9sncXCmPrj9ws7z38ZmJ9xZ7rTXuPvZPTjSLfRVkNT4TVdpy+m1y/
3T27e8OZuysatrjGNhbuuVa/88D0iHIkGEUb939ZuWvf5bGvcts+Ldu+8/x9
n5KOKWFVCDGP9DYU3/mVr30psPjFhPq6k/cSaze8k7nOu7LrzbQ1m87cy1y3
8/e53V1n7sTW9bontSyr7luUu+bj4t59V+76l66dElZpuW2EbUCAXo2K3WNc
HQi3eOOyFJNlfrWu4lBNkLM4mAnWUuxMQlWYypaq4iP/y6ekKo9IOvD3jao6
FSw8tVLPDjhtXYpMLq2TNfRaLIdNUaa8lXXBCU79yXcG+GRXeguseoFwOHi6
E3cHkyymQB6PgwXgE76UfPvhKcj8hVaB4dOZBYo1GAXUIwgHgc2RC6DvQEPj
RDyIfR5dPMjno6qhoCa43PLFg1W7VjisBvIzqXqku436KCD/yw9gOZZKKw6w
0WnLZdwLxJvBF1puP699KaLaO7/1xJGDAwOD23bv3r57sG/XwJ7+gb37D+zY
M9C7ffeWbbv6du/tH9y/e2D/tp17tvTtQt+79g72Dx7c2b+vt28XStt29e/Z
dwAV2L6rv1csgP5COeh7647dKCEIQoF9B/r2DKDC2xHAPYNnRg5nNG56Ntxk
vW2BPuYM4R3J5fkJRnF+8Hzx5gMvRtc1j9wJr1zvtLywqP88crydlubFdJ01
9R12jWlZM3RvSVa9U2BZ1aGb8bXdTktzU7Zdzlrb99eyrT3nb6V1DKxYe6Dj
1MOcLcdaR24vK+h4bHHGJ8a9Haeuo7gpbdOFwk37n/Yp/13GuuwtJ0sGLvee
u/NhWq1382Hj9iP/6F2MQpLuk1eSmvfm9A71nru3KLP12ZDiN1eu6zx1z7u0
/YXQ0gUJptmhZbNS16IXQ8vWO3llzo5vW3vmzpf569J2Xkpv3TZpSW7y5jP5
Gw85Lcla1nig9dDF6VGmvP4b6Ws2/7t3xivJHR3Hby8q6izffyXc3Pm4fxGq
sWLHwBP+ZRV7r8SaN//YJ39qfF1QU3/hjlObTl5Pa921ILGt7fTDj1bWO3nl
ebccaRoY/nV2V8vIjS9y1qVtvdgyOBzTsqNo18Wec7c/Sm+YFlGJYtWsnRdQ
MLuy+8jey/dDStZ+bt7ZO3rLPbLqOf+Cb4dU1g7dK96w9wcBhc8FFk6LaUGh
TdWOo7Gr99YeumneO7KotHfNqQcN/ac+WNXwdLgxbfPw1vO3Uxp3eERXusYa
3aMrX4ltbR66+8Wqup9GG3vO3g+v6P6H5TnOKW2bz9zzL+96JrhkbsIaFPJE
mjY9FVz+ekLdvKiqZ0ONBbsuF/Yc+L5f8TLzYNuJy65RFWl9o0U9+57yL3w6
pOyTog1F24ar919de+ScR0pj4b6riXWd/8uv0rj/RvP+4eimHUV7L9XtO5va
daTxyIV5YeV/71uRs/NSUc8BFB/NDCn+1DTQe/bhOyvMLhHCDsppQcW/z+/Z
NXr/88wGp6XZbxl6t5y9+1Fee/XBK8GlLY8tNSRuPl25Y/D5CGP90XtBFZ1I
hDybBteevPpaVOn3/Iozdl4o2LBzRlzdmlN3vEo7nRanv1+1q+PU1cUlW5qO
3voss/GJ8BrToRsJNV2/imlYM/Lwy0zzLyMb1565Z9o+FNu0u+bo9dI9J437
LxRsHPyhV87LyaubTt4JqeqaEl4qxIMZ6zpO3Q+o6JwcVDI5vrZx6G5Kfc+P
wowh9fsKd51eP3I7t2PbK8m1LcN3/pph/Klf4fxVrSmdB4v2XEZNiDF3Tg0v
Ew+lAd1DDdE7lrcP7IYeha1W3lAzXv2RfmTGr9WsJbiayMsvQIoEi+9wenJe
BFKA0xCtpOP0v+MrCR7cM5RY9ISMA7P4qFIevI+PVQunmRC6QdSQJSS6Bdvd
ag1IBFTg2MeDEM11RH5Y/IXXolu/PGh3mUGaY6PwRDxI+zzS/YMcawBfmw23
6prkkGPu4AIGVDelfVNmciy8I3oK1y+4YXQQAczW8fBJqLFeiidcZPZqovm1
uNqnQyv9StpvnB86O3x0ZOTQ8NDRUyePnRo6OnLyyMjJQ6eGDp8ePoJ+iunw
qaGD1mfhp1jg6OnhY1KO/CClM0PHTp88KqbDchKBHJYKjF0/k9ey8efhVa8I
B1EKp6xIF6iRFNZ0k441s256sDGj51x5z6EXo2vqh+8k1m35blBxzp4Lqc27
/sMnP3njxaptAy4xTc3Hb3oXt/8goLps79XU1m3fCSzJ3Hk5o73vk9LeHaMP
/I3bPi3ufi+j6feFm7acv+9btH7S4rRPavZ2nb76WjSKN8+lt/V5pK7bef5h
RFXnbzKRc/5wUfbqkPVD5r7DTr55iT3nNw1d+Gtp919LN76fu35hUs0r0VXT
45qaT96r2TqAgpdfhZS7xFQvTO/aePZ+dO0GFG7MT96AfPVFhvVZWy/lrNv+
I7+ChM1DhZuOfd87P7D5cOv+09MijfmD19PX9DotTX8ze+Omcw8+L1xfffx2
SFkrCifTtp2r2L5nSkh17ZEbkeYNTstzDP1XNx05/euEOhQqFnT2u69oRyHb
hyvMKB6M6jrVsmfo9YyuNcM3PspYm7n9fMO+4U+LelCA+W5265vJNW6hpa+n
tKJ/y7YeiW4aMO87X9JzYFnjbhQtLkyo/qlf8ffCjJVH71ZvPfCzAMMTQcXT
Elu7Tt8t7Dn0l+Kuz4o6fp/e9GJ4ybSkhti1RwYv3l9e2OIUWPpu1vrmw9da
D59bGGecHlH+RvL69WfuLspo/LdQY8/og0REhCU589LW7kTULm5/PqRsalRt
xYHra/qPvxRc9mRA/qx4s2t8Q2n/lYLugUlfpS82HVh38jIKLVduGy3Z2P9z
//wlVft2XHzwlaH544LeNceu/y6zzXTsbnxt12PeZaYDN1Fk+nHhxs9Lel5N
qAluO9YzdO2V8PK/8y1BAWbRxv0vh1XOjax8I7tzz8X7kbXd3/XJfymkYm50
1TvFG7afv7e0oBlF5e+X7Np87sEHue0VBy5Hm7q+71+SvPVM2dY902Nr15y6
hyI1p8WZng2D7SfO/yau4vlQFGleyduwa0osigcf+BW1T/oqe3HjwfUnRr8o
2bru5O13EiucAoz1x+7Emza9mNzUee7uFxm13wyp7TpzJ7/78EdF3f9d2Dk3
uaXi4C3TtiPf8cqZktC05szd8PLOKWHGueEV87PXdZ2+vzy3yWmJ4b9Ltu6/
NPZ5/tqk3tENx88gNY/fdBrR5K301etO3/tgRdn3Yho3nLtXuH7vvKRG8/F7
K+o3ovZ6CDct1pHGCu4rai2JdVXys/LB9qJj04Jauzl47wAMMCF0GMduAls/
r1oRHx9SJGTuKP1q4Lk3WikMIaNuOkuyBzxX1vHEcUvcNXomQOHB/qIyYiHp
KxKTg3w8ydodjwfJ3U8QzmLlVbUMqID2ZR55PMjHk1qeBQdeWB9irAIeE+tF
aZ9xnh/UeB4aVH0IOJrAOpLPrxeoblp1B043B9PXUAuLfdSS0rJMYWFMrOVi
AtcY8wuR1c9FGF3jTH9e1fDeqqY/pTb8Ka3xj+g5tV5+QN/ys/Aztem9FOGn
LaU2CUmZY32RlQT4qfXvpzW+nlj7fITxxYhKZ/FIz4VE64AzpyQpXo8zPh9c
WbT3WmP/8aejzFvPPshs3vb3/sXGE3cK1vU7eRXl9l1sGxyZEdvUd/5haGnH
t4LKW0/fy163+3/7l5Qfu2vq2zcl1tw2fLdq44EPszvCm3e8mVif1Xehd+iy
Z2Vf/dDd7Rcvzw6vKd1zLX9D/9tZGweu3vUq3hC+bmjo+sOPshq+qj+058Jt
79JNXrV7UewQbdz0RenmiLq+BTFlwikx4WUfV+06ePVh6cYDntU7us/cCzJu
8m06sOvibZ/KLebDN9cfOj0txlg7dNvUe+DffPLyBi6ad536D8/8qPbT20Zv
TomsTNl6pvP4qG/1NhRXrh8cco6pqT50p23geFDj4MGr96u37f1ZSGnBvuvr
9535pGyjMNPUO/h+Qfeei3eL1g++mtCGHkp6Dvo07Nl34UF0efuMVS17L90N
KGz7uGL3rgsP/IrXeVZtCazqcYs0Tg6tiOwc2Xv54asRZZOW5byRu/3Q1buh
NbvqDt+o6zsW0LA7Ze3+oKZ+FD0lNfQldR6JrN8Rse7olpFri3LX+NfuXFS4
MaZ7OHX1lg+KerecvZ+15XDG1uOfZK5O6bm47eyVNxKNM5D4JTWtPXW3oe/o
n7PbE7qG9ly6hYhgOnyt8/DphfGmOTE1zuHl7xb07L1837j92NKqrSjijmrc
FtZ6Yvu5q4HmHevOPNw2entaRHnR4J2G/oP/5Z0XvGYE4fNx9prcPVf2Xbz7
+oqmvL3Xuo+e+0t2e9CaQ73nx/wK1y439S4rWjs/dS2KHAs37POq7z9+/V7e
hv0vhFYsiDW9HF4Vs/74oev34pv6gpsPbDp766OM9uTN53qHL3lVbO08daeq
d/+0ONOGc3eSmjb9k09RwcCtlv0nngqpqDlyZ82BU++nNUe0H906evV3CWU/
Dy0rOXyrYefgyyjaP3dn9d5TXsa+becfZLVsnxnf3HvuQcH6fZFth8/fehBf
2/14VAMK7hr7Dv4hsy1h8xCKVRfltgfX7/jvrNWfVexBAhNbuyOh++zwzbvB
lZ0vhJbPjix3z1nfd+5+Sd+h6I6j/ZceoBj5Z+HGppN3G3Yc/rBgI4phzb17
XRIbNpy9X75h4Iu6wb4L95Mae5aYdh+9em9F44bJIaVI78ZxfhBS0hE7rBWO
1uq0YuU4BVTxB2ZCauF0l9RirE750cmJKljy4l3+hg4sqW4YHK9e2xFBAvow
kJL8n+TiYT6vIc3ko2ThIFcU+XG6ir6oxYPyalXIEnGWRuigP/BfFmW0jl1o
QkmVX6rNURbwmIgHaZ+vc36QI8kcCafKsw6jrU87IPbKlmDz147or77Egj+O
VUDqVeYzCtfJhuW1WNOMGGNkxdo1G3aa1m4ubt2U3dCTU78ht74ns25jTtOm
rIaurIYNKBOlrPpNKGU3bpR/Wh4aNghJ/Be9JRRo3GjJFJOUY4OghNbQk9mw
ObOup7B5Q3XH1qbuPlQ7YvG8OBPWQN3xoHDDeKTZt2ZXuHHztNjGhLZ9y4vX
PRtWHry63698w1PB5f61u8Nre+bGNMSv27cos+mlCFNEc79fxfpnQ0qDVu+L
rO1+LqTw17mdFXvPNg3fLt954teJprlxjYU7R5tHbmVvOBBTv3VurNnH3B9a
2T01whi19njr0LWcjUeSm/v/tLLWLa65YMf59qFL76SaPyzsbTpypfnE9ZQ1
e16LNQoHusaaJkdUfFrRV3v4SuupG4buA28lmCbHVietHWk7fde8a+idFNMz
YcbINQeCqzdMDitZXrMjzCQc7LmotDepec+0qKpVW86sPXK16tgt0+4Tf0yp
+1VwCXL+64/cNu4+ldQ+4FfVOTWo9B3D5obDVwt7jy2q6Cnbe9ncfyaj88Cy
wi73uNWxLQP5fac7Tl1f1dLnElU2M6Ypa/NQRsfuZ0KqA5sGm05cbz5yMaJh
++zIiulRZr/mgfim7W6RFcJtDklNaZ2HvshsWZjaZRy83DJyPaNjp2tUlbdR
OO6m8ejFgNK2yZHm+K7jrSdvNxy68GXJ+k/Kemr3X2w5cSHUtHlBUmPyxuHG
oVvm/lOLMptnRJYhfs2IMn1u3Llu+E5GR79zmDGm43DH6bumnSNvJ9c4R1aL
W1/N00Oq3i/pqRm80D7ysKT38NtJpjkrVhfsPt86dH3lmoHwhi0IN5/6fRG1
W5zDS+evaEnbNLR66GpW58GYlh0eMaZ3crpXH7hS0ndkdlxVYNPA6pM3UAPD
6zc9H1jyadnWlpM3qvtPZ63dv6ys0znSJNxWH1XlHFUT2nxw9Ym7zScvJTT3
CrdpxNRn9Z5ef+pWQc/gm1FlU2LrkjsOLS9oeya00q9hV3jd1qnBhX/J71lz
9Er6hoNfFPfEt+58Q2ydf0N/qLnbLbYusL6/YMtw+/DNvK5BVAWSxiX1u9tG
bhZuPZncsntxUcczQeWfV+1Yf/JmanvfjJiqFV3HW4ZvNR0Y9SppR3+FtOxf
e+p+3tZjqe2DKEKcGWWcH1XtkdwU3364qHfIuHs4rrHXJabixeCyv5T0Ggcu
mPacRhz3q+h6KaJ0WU3/utP3olZvX1LZ13DsumHrMALyVV67W3S1h3gfvap9
1mrPgXZyvOytJjupuiNSHz76MFfFH5gJqcWup0jgRUZUalCxhbdd04IZOCM0
xYMyJpzA0BF50y1I1Lrg7dKKAMZWMtbQJNVUDDmVst6ChDya6M8Cyz/higpk
3OkPfEu3+DlSqUwi94l4cJw+4x4P6tsvwJFwTQKmqi98UCw5h0K2H/bRp7/6
2sjRr3GnJxQZoisHvGUWzpARjuWvfS3e/LOwShSFPRy7MHbt9Nj10w+uj4xd
H75/7eTYzZEH14ce3jg1dm1k7NqQJV2Xfo6M3RCKKfKHbT+lZzlJmTfEt9Dr
MgTr88PrZ8Qyp9H3wwejx04eei22ZnaMrYEY2SH9iz0p6l5PqJsVUf5yVNXr
ieYpoWWuMcJd887h5Sh++c2KhpnhJdMjKzwSTVNDK+dF172eVIdCCbcI829W
NM4MK58RIdwq7hZW9XKUaW5SzcvRFa9Fm4U72WMqX0msmxJa8XKocEvgrPBK
56jK+fHV08OMsxJN06PKXggtRQ1B3v7U6GqUMy/aNDOs0lk4yNE4LbzMQ16c
HyuclDItxjw7sfbl8Ko5MdULok2TQwXgM6LLXSKqhQsLwkqmR5neTKx3jaic
HlGOMJwTWT05uAJBrj1xN2fd1qfDymZEVTuHVS5MqkOYuMTVzYqpQvGsS4T5
jYTa2ZHl02NNKGidEVY2M6F+drTxxZAi4Sb3WIEaUyKNqOoZEVWvRAkXUKLY
eW5ig3t09eRwk1tCw8yY6unhwhV4C+NrZoVXT0WYi3tOkRShts+NNSLgU2PN
cxLNqNi8qEr07RJrRMk52vxatPHl8OpZSfXO0VUSfSbH1M5ZYZ4eWeUWWYVK
zkmod401ihcu1KLga2FsjUtk5fR489x407yYKhQpz0qoc44SLnOcv0LY5To/
XljN6IxojliQYEYFhEsGoyunxVbNia19Oax8SlQ5IpdrRPnUiGpECkT8lyNr
ZsWbp4VVTBbuuDTNjqhyjq+bnWCaG12FBMAtrgGhilj8RkIdIrVzfA3C5/mQ
MkSchUmiFCXVvhJbiYLQWXG1KE0JL30trvaV6OopkdVzkuqE2+2jTQsSaqaG
ls+KrPl1ksAgxFxEc9SQGQl18+LqXKOQhAi3MSIhnBleNT3ChIQQMQIhPzvJ
LF6waHojthFFxLMTmhCJngspnxNpEiBEmGbG1s5OEK6bfCmyYnYiIqNwByXS
3MkRVeinS3jFc8HCVZICOxLqX4s3IQpMDitByEyOqEby9mai0CgXBCTa/GKw
IEtIyBEQ1/j6uZGVM8ONbnEmFGg/H1IyN8r8RrzJPd52op1W+wwvz3G/qUtG
WXZPh93W6kcxTf2jPNCGTzcMgur6TIg/gK13JYtRXtEbv8PlZLwSnwi2xaLE
dJKD/FLyiBP/suQc917sJ0PJTX+6/Q3lK+Jx3Ozjj7hi72E/5apbMODzX5ih
wBZIUxmHQdYU4JAqAJQH3Xyh6ot0rCsoXk5gCh7nRdXyQHK5T8SDjM/Xc54M
3P5rlWe49DoOR1WPgLWQZcYLN77Ww+kwPk4FcVw2BH/xoU48ZdQ8I9ocWrqu
eu0OQ2tP/upNBas3FDRtLmjuQQn9LGyxPBc0b0EJ/bTmbBEKW/7iJal8Xgun
zEZDy5ai5s2Fq7dWtfcm13S7Jwo3X5BU4ptcFpdFygiNlS6zQG65dEWdeK+3
Cf2F/PnX44STFRE1xFfMUrAsLaZdGC/dR1/jEV33aky1sMg2UbrwovbVGKNI
RpRTI0z2xddL97O/GmecHyd2NAk14lxnzfwY4d8FsSb08GpsDYoppGDcI974
RpyIXqz51RjxFJ1E4S30LgKOwkmUM996GJ2lsXFiRXF1iEQoukzrO5fc1jcj
sBgVRkGBeC6rWYAcYxJwjjfOFzeKonpRAdRS9C3Stk44SVJcOYy+hevUE8zi
T+HSgddiTR7i7eQoXzpwTzyTVryPQFxSiNIbEmKSkxBneiWmVkb1tehasaTE
jjr3aCOKoN8QaCs0EwVTAlPENs6PQfiIzYkXLo4X6Bxbh3JQ299EGIqYWC6m
FCoSUJLOt0d/vRJdNV8gncA7FNiiKoSL3QV2i8USa8V73gX4AmXiKiUZEBZL
xwhcECPcWpnI0jrJV4Uaa6SzbaUL6y2T6Qm1KCh7Na5KwDZJwEHgfnSVgAyK
ZGMR323uOkJYwBlBEzA0SbGzUHuicNStxFzhKKf4OoTzq4IECsqIWoeQEQQy
0ST+rBWAxBgRQYSJUZEsEtqSfKJY21JdgtlDcWO7JHIi040LRAa9Flc1D5Ei
wehuuQNIkDRpxTiqXagloVZivbibuFqrtWT5LdRikEV6496PYAk7yB3eLs3G
GdxDQVoNp7MmIqviQ6WVDsqo4j9e7AbCoYYGqmC1yienpPIv1XgQ/5e90tJx
0lmsunbCjks8qAdb7YINR0CHvoxXA93V5Af4LvUv5lswRYAU8Jg4T4b2eUTx
IBH7q9wjA9Qm/DBe6xCKVt1kFdOqC3i+6BByjueSHsj7XxhE4yKg5YIJiH0g
tzzoSPw7YVXJ6CH47dIxnoLz/HpirVuU6enwihfDjcIOPvFbSs+hFF4tPb8Q
iR6q5L/En0LhlyJM6FtK6FkuYC1mQsn6swr7V85ELz4bVflcZNUzYVXTIoXD
ZBYkqOwfZzWQXkZwhgXHXmi1EE+JkJEznGB8PU5y4E2WPZXWyMtD8tLF2EcS
nlcTzdI5PDbxEy4QF5ROCkzmiy639IoUK7nH1kr+vwWfBEvY9bp0JWiC6MzH
WQLA14XQxviqFIwkWOBIoZBCJSUdF+IaEYh5fnKj5RJ2oQohhEGhkKWlYknp
8FjxSDQhNpQCCvGSEQucN+JqZdOx0FaLbExQPIKi3WqxsCg8qIqEekvtFszl
wjbqSUGKEOiJsYYU1knERz/FSmtECGbpAHb3uAYRPQscgaRS4GMhgoDqQjH8
kYJT4TuhXm6jZW5LIDsSHpNEcLFSoxwJWslSJ6nh66IiWAIikcjo+XURTylu
kilgnTizUMDdSnAh5ETmKFEIny1yItIW8d1dnMqUiSkBlII7sbAQ0logJxgX
WqozW+FI4ifQWSq8UIxiPOIaPCwxuOU8KAnyfEU0+rpNboVhB0kgZSlCSRj6
SLBc1ikRH4GV5kdEyPV8XWPZH36Oezw+gI8nRufFr9oRE8rERIu3r1ILwCwD
a6cO9VM6a0UfRz7bekON/i21MJzUQDmBVOFhHXJRZip/2iGvNp/lCH+BEuJB
mR+0M+wym+Dw+X890rbwy/B1h/O6TAFpHAyCGzUihmBFygYfDlMl7fN173Pk
l4fYImkEkoM2X05ArNdyzYfSbkzEg+RnXOPBRhbfIfJsl0+c6s+XancinCEd
g3E5p8vB14HqQP2XHOAiS7JsHb88Nckvyt9Ayzzu5OLAIU0NvDzrXbWk6/pp
7rmycHlQTao0pHYccGQgdJZzXo0xitOUUFopbxNWPlgmTbRvwAGSC89nO+Ra
SUT1eFkEoTKC30z5X9a6L4lo2CmFqsIGF2xVsaHmULHFLA/VVmO1UGjCPU6T
Jf+qquQxHrft6IZAB6u4cVsZ1yiXF5IHcajKrYwtnSwM0wfXNb68kVWT52mQ
MKk9I0kcVbml8p3zChyszDKyGPVdjNGQGTFqEyD6CGqvgu8288i+P5oD38IX
xaGvHnG8vljTlRPSgLwM1iL/sWaWtWH+pA0UKLnAX2cLlC7p3DwuEMswL78W
sjqOVAD3JKrIg+JdiXecSRBNVOIX4PQaLJvDWsTlMbFelPb5HxoP6pIruGLq
hjMuCZdbxpwaK2qQ8ynKzrX/rPJ0PWKHhFpbOl4U45dRHsmlDbi2gX0z9ZxD
TXzHMOTvSILILauM6iIZTvcBaSCrC7AbFYftg1AyQhNH+D2Can+BASHpRo4j
Ma0W4NRxFt1YOZrwVyWvKn91KyyTJoSJ45cEQVMjCKuBHL4r2e2hmBEYR7Lo
g6C1OqUN4ceDwAEW/jACf3+firDR9p2pxoMQafFQGz1W1shrnQM6AuE7Cz6H
SlQcFjCupYCoAKi99l2eBYjeeFCZoxoPUgkCoTmfs8DxGabowjRaVbrURTTe
DI8HWQiT2uGgRbKDRlgA3ejxJYev76qWSlnMfSIeZHzGNx7EmAJXK4gU6ZZe
JRz+qA7VjMDjCzieHPgQa8bXC1sB+5U8rPKs6pTffD5qYoEOCPC3IFZFlb/c
eES5XhEHzkdDlV+cHE3tYr0L34fiIIvHi+/wGjmJsxSQA5D1FtWfYYkNiQOV
zlQ28TGHy4MmdlPVAc4CSO18QeVDINnKki5N8qZKW33SC2WWroWm+NI1q6mn
xoPwFmltqXIixoNxVyMcJl/aWUDIAsDNYkCJVcGZMd5FVerxSlS1VdVcoEBC
pIK+GgHTYsBx6yx/zIMd0fPiQeoQRwKuFxj3+cxlVQehIakFlMWNsTZFpg/g
sNers1jAx1azVjLW3UHsMFaj6jIVFsflc0Sp+KuaC+oyg4l4kPyMezxIZQff
WvIlk1+G103QVnHriAc5VcPx5FfHwWEBccgY1jpML0hQqvOJrPZSv+Gt00ph
Vb7ooydGNBCSsH2pHAzpZo1Bf35LteoIi7+QVrAW6WlmLkNW4fSk8kv3uQpa
5Q3bCMx5y3G+kElWWE5MCq8XQi5ljuPLGvm1U/+l/uTrgh09FfsLbP45ex4f
DhnCZTgdNMshsKIEuyiM5OZ4tYjfRriu4T+t/h5V4DVJO3C2gsMXR+jAr2W8
Ekd6eUR2QPD4+qJKBxZKfNJRV/wCd/C524dyqgvUgfgDkefQXPkvdT5XzlHK
v6bamQTRHQ8S+sWCA1Q6zCPVSn87y6B2/rA7cV6HDGQiHiQ/f9t4kCV1LIVS
1Qjq+hO4vAGnEqjxAkTLWMprE2+GxaC2kaWnJHBV/SUbS34DtZWCBvgKEr4F
gFsJDn9BCGvsLrHuhmqRgNIC1AuOFGmlLVXeMOBQRoP1lCUhyk6cHJuFxIPY
Uk9H5A1kCjTCh3CKKkjUtsCZAhnPlwkIZDeEehLXyFM1qCPhIGi05lP3m8vx
IKvhfL7ApZcvjSzLoJWPEJq722urh308qOngBa2M1qwppHZrjwdJcVWpNwF3
IKky5gj9qX8x3+LOPfHNgrK8qt12UOr4VAXSgUUK6itUH54kGoaDbGdYe3Aw
OKT8QHYFwtvLL0+xYzRb9z8qHuTnaxUtrfKjWi+WsOOaMVJPxIPk5xHFg6pq
JdtnIJfhGofVoknB+XbYVkzNjDOriLWzV6p1UWiSQLmNiFWjKj057SW/gdqq
j8J8yKr1KoHw40EdNFdtEQcZFv782skc/nIgFj2B66ZYAqObxeSSWo84Dfvi
AYm6hEbh/8faTq3UJG/YW6pRGJ/sdiXt15WxlI6sRSkAQH2Ra5R9HpYkkHVp
igdZNORTWOYR1kC+TGIkAqKnggMMcx1KAeeUjpWE5CvSNSJKjiipCuG7jkpZ
CqKqKapEY2muKn811YvRSgeXHWGiezwlKCbx4dgE+Sd/CtXx1qnyC0gcDnew
Vzg9F2d4mYUAyyBD5BZCAThZlPmk3ZNOCLcVUFtXA7dg+uSBqdqMWXitNGTJ
A78P4tcLN0cT8SD5+dueJwOSPQeMmFY447vIH4geNqPBQkaH9qmW59Mc+x4v
a6lPBjhwsD0sqnCU1GZZJAjmzAFMBp1ZlKGu9dKBj+q7yuFxCPH18VfIjLc7
T8bSr8HO7eejZKGVIvSzJWqmRoliSYgmPeLPaHDgsNYDqOKP/dTqpSt/Kpem
8yGoomEro5jzJaWdL2wQqnLehcgVS1/4cg6XWx1yrkITWjyI5Wttnb4G2s0/
AiQNkwd3+5iIPz+oj1MYqqqU57SX9S6cbnx6Yj/JoJhfnk8liIrx26tKPQ5V
NWmW3HB5fgeIBqsAa0AMiKRcGCIYqkDkfJt4y/KfoKeXhHAEjiEHGqaSWEly
X5LtX1qj5PFhEh+guGLlMfRUGTERD5Kf/5nxIMMMWv098CoyzK46omju1jFY
x+Fg7WXZfHfZl9Y7GiPDB+qR8l/sG25DSAQgnOLjw6/XjoAiuVTnAVlXGJAc
gWBry1HcRmFJjPsp4Hzk00SffrEqgggVh7+2TOLUHYkOcMmRQVFse6zZnUFn
1QWifNJR/sU2EjLuDYHzxQMb82ERkIsYuQqRmqNEQ7lyhsp3uxfHOx5ktUWJ
qjvDRJAywCqpSa6obJLJK/Oa2Qq1Www0Ra9a9Zq66BHDyoNw21TFXgcBxZ/4
XDx/uxZHYCDayqGSPHKiXJ/MN+ZAmnP0VBPdWCLEkkOeb2Cfw9okBRIngCJD
5FaVjxiGmF11VwztyvKjHA1TFRslYfnTiEoTh60GcWeHfqqCQSWI3Q4Ie/sp
mxqpjPV2CZ0hIUtNeFyD2THV1qlwxHLLrb24qsWDLMw5EshKtvIKvk/Eg+Tn
EcWDLP6yjAzH4nFWkgOSNs1StbpYYhkQVWyB9lOVbvAa+WSHVMfhJqv3184v
zfjzG2WXD1iZw6uLOPURUikViB1A6eCsWLsLnoBt5+xO0kdPuKIB+wW8cDzt
NABaJs+fBCg1OWVMwucEj6z28rlDpYmyOR7g7cwQlFRHLeR/F1jPpCKFkIWG
bini8I7ChQTLgeqQ2qmrp0jy8mfbIVwDJ3xTpA5y6cNBK79IUedPYetAmzXo
ShE29nw33ij2bZL6CM6hMyk/muivWh3LmnHeotboQRseYdJT9wAs44QiPg05
9HFQQbQ2AbLY2J21jiKevgmR9brcd8MJwmIx53XVJpNyQtbCpwYHGgsr6kgp
CyZhH8wQrJQVkdRTziCzvqnE9JiIB2mfrzke5Eg7yUGIRjuYqPrCKQDEXLVS
jifPSpoaoqn5qnWprlz9W8WD/HaRDiHfEmqFz6eJPi7AmaUbjqZ26aMDBzdI
jdTCmlrHoRWWr0nR4AxiYQIkL/AVVbtKR+kRx4MQaHyywPXUcTujmTWAy8Ef
OQ7a+ylWohbWgbYj4g00ayoUAAyjQWwCpBX6SKTaKD4r5aW51HiQEwEBh7Co
9fJpxQcLaRQGkzMfqk2caOczgF7UqMjAt7ACLJEAyhsHYQg3IdTQxDVledbo
gRQ1Ky/XgNOQrIVFIuxblgRqyYl4kPw8uvWifLmSmUXlI0cYxjdRtYlTgPU6
B3+43vHTo2u+43V5KMZq3OMVW8a+xrZQsAIsHFXiD/IopHUdjPXzuqkHtIes
Wvg58JV1QOSxYxCAnH10lCEZhL3OgalJODnyw+wHHaCDKkqqUq1JILVqKORM
YyabuFrJIZ0qZFVS/01s0fhSXvUtJgGJkT0g0ah/6bbt5Fsc4wm0eI7QXIkG
Z2uJPpkBaoRutN3Z+y41QeOUZ/GXr1/w9lJ5oYM+tne/rngQyEoIAnBOcegP
by/kXw+uX6Qsz9qPwKetklkcQqlyRx4qkb8XqJ2j5TERD9I+j3T/oDvDOGD5
2Lc+O6k1UQVVk9Fg4c+pjlOvh323CNkS6zi5+PZQ9XgrJRw8J4F3SCMQH60N
4QBk7SiHYAKpTh/a/HdVBY9Df1amI3Kij1aO16vKXI52cNadqu6r5deIlwdM
ugGBcwpT3yXxcXBoQhNfVIWTCpbaLsxWQNCDSCaEg3/b5IjRg9si6hUPVLD8
6hynJ1xy+PWOF80hTaAWALZ6HPGnYgtpCPwsU2DbSVEZ9/W9+ogDwZwvA9gt
h48CMSp6HD4CVYzfWDhl4I1SQuDTH9/OTLiXrEkEiBTJVFJ+c+TQYyIepH3+
5vEglY/jq4yqWOkzGizMOUCo0JSZ5NZmvv46aGY57bIroLoNgTuCxIkHsZ+6
94pCeMdaPkq+qLpqhW/39FEJE0ggDuOyD0g3eUlyjVeNEKpS6aaDU6wcCFaa
hASST8WW/65W/HUzmk8B1Xc5xZRKqlvvIChpQtj21iM+d1orPvy3oOxIoE+E
AXXNEXpyWsSpmi8JjtCcXoXaLgkWbqy6HMefojjjsQ5HFQKH+yTFPNjeiyP8
gjdElWuqDf8aEMMQoOKD7/vWYmNVhcfx9tI1IoHit/CthypHlP9SZ7E92K44
Bl+mp8dEPEj7fG3xIIvvFA6yR5mYkkm7upq/bB6YicHEHwASSELAaAK8B+dR
2KvxsoeQSIel4Mqf/OU6+hrI8jAhkslqo771ouRhMsoaqedDutOkTllGE7n0
ubXqekGz/+PFPr5MkuKENRbId51iz8dNi78NAQgk1DiqD7R2e3vIIikHQ9wk
ct0n6ovU8y05QP5WtFJl37i8BQEFl09Ix8SxRfy+WC5Drdr9a1kvyirAeoVD
HE5djuOvKs9al8GQ9Pegjd9qlU+t8aAjdcHp43i9WtVTK7sxNLB4EIIPvKU6
6En1QCwAdd0krqpNWAEP7jW15Ddnu5DHRDxI+3yd8SBLULFv3dKrT1X5mZoA
Yq3gFOboC193xpcm/Hp1nzsBPyGTRQcH26UemnH9KCAH+W2hvMWNBzE66KDe
o0iktXeEDhyCqzZERzHV/ojTEE0kguOjA3nNzAL7t+OelFXAZYPFLwibHJd/
Bwk+LnTWioNWOrDsvD4l5RdwkBcc5FUooHGwy65FtJW08LZIhVWHIDg55E8S
CCs0oLJV67Aq/3YGVV7zf6rSE0NbVZY4uJHt4os6RykkmijXjurWUOCLcCWV
RYKsiLMOynE7w5cE5S5COV/aOgQcoANKIDWH+s1qu8dEPEj7fA3xIHDlG6k+
jt00wUnjvDgck0kdB1ZD7IA+jVbFGW6COFg5Xrs+aCw8MRZQ73C0o7/9hWua
cObn25VJqKVuTIDzFChd45U82H6FB2NGQMWSM+6bYLcL74shbRc6xFi7Ox8d
1xqmUvDvb9J43wRTPhn+IRVJVhu/BplZQFytyGqdlT4Ci6X7JpT5HKkTEnHL
niM4wzRXA0l10FmrfGq1w0r4qlNIFLVV6x0c1y9q1Y90PxofZ01yRRJWK7/4
P5VVcOijyibVhMU+QLqxcnTT01HeEeOurMU2+CW2NCLbJet1tED0OPylvihP
CELiYiqvpWfbyX72BRy3MxAu2DKtp4kq6Uyyya4hDJFW9gisBQPuxMEyHL3w
mIgHaZ9Hdd8EZ2YZMGyiat/IsTK+pw1cR6FaL/musoAstCodbgLuSHN0iprP
xJ+wb/xmUrlDIoZZGw59qG8pM/mGjgWfv4JF9+4e1SogHGFBZoUAvLfUFlZp
lQcNpBCrVhJBq77A26uJkjoYquxV+XKF6YsmgYG86HhLqeSF10uVEypWmCsI
mV9QAoHoIJwvqhCAdKZnar8wQtVwqbJbEja5FR5x1gPYrf9yKpULSLaOgwPf
agH9TD7HbT+VV6ZqhMlCns8dOMJMfefaTx2t4DOCJDglMc7Dh1StNV+WOpZJ
YcHhj89o5QWQiVrZqhuyitrak0v4dszfIIcEdbMVZy6sXWQ+VQY4BKfgMK47
rB3hL7PVCXb+icdEPEj7POr5QVWN0ycPQFAcODqETX6RpapU4BzE5J/8eRbO
i1giex+qqqrixsoB6qmqFeLbPUji+6sa7BgYPlxUtEo7BwIwStVXC14pbB8r
X97GnT5A751UQw/CXKgmOF800Ufp+euWBLpIqO3bxTLh9FeNB/mBCZDvWunJ
KsDfI0wWhkgUtaX6MLRk2k922wbP1fa5SwiTQ99UrlEnoHXoqSprlEKodSMz
K6lGTzyE2SseOUBY0gjBlixGn/LQ2CJI7Zx3Ofl8YSCZq7s6viDB5YGqvBD8
NQHnQHC8FlWKkRKoj8525WnnVFAbBeHX+FIAkpQjFVrH1ZmtnogHAZ+vLR7k
yK3jamWRf3bgA02K5QT40gL7cVrlN6nOWnWHLMkaRYfrAr88CJravTCsetV1
E+yKKJFRX5tn3x3rW3chvwu0oo6YTb5NxowhJmbUdx05twFrO1yKgG3njECq
EgpYrw48dfBLx4t8rumQED674QKvo7Ee1lEmDAg/rtGkTaoocfDE/iIhaI0H
qaTgE5/+uvZ9CvKRL/K3jvlBHf6zqo5gaEjz7LgYxJm0tpfqB9ogO6yn4yuH
uhHQYQdIQulYfkkKA7V/0dpArbwAoco4DcydO2gApwNVrlgQIPoCzUywYxwV
E021aCoGkXPqQpTxkltgehTxoJIF7hPxIOPzN4wHWZlwg88rwL0SXat8erDD
QKo6a7Z+XD2FQNPaUq100FQ7NV8rwUFiAL70DVIdPEFe1FqvMp8/nm+XCVhf
CkSPLMPaDqMP/tcTD5JjAqzCOpbPsQBCBFWfLjhCH61SB2kvdVxCBz58OdQB
B4IMpyRcKXRwRDehPGj9jl15jSd3ObhelJQNC0AUD2Jbg4kcYHupJoj8lweT
ewUDR34g8gD5FwPLm/TUOx4OjAep7aIuGaUyAthACA76pI4176xPK1nlWTkc
SlL1lFKdxt4ZiL8mjqvKA0cjtCY4Z7VyyhEu48yaiAfZn/+/xoN4ecCR15Dq
qN+kGdGnI6y3VKFx/oXYBzlx/H9NcOCYjxd/lS/qGzjVZ+s4ZZRU1cpxDdjq
igfxRWV6zyWgQvbQPruqg9Ec7lNFmoWqJhZopY8yQfb9sWocL/rweQGnJwYH
yBcqNaiF4dTg6B0JR1Vb4fTXJzDuRASneqylBzsYhCf1XWxa5Fk5a2lJtHhw
AeMQHh1kVOUsn+zYW6wcOGJ8qeDvb7VL4ClmLFOf3smRMsZNHXxxhBdwfo1X
PMiXBEi7cEraF1DlFwsfTQyFEFxVrjTpviajAVdk1aS1ItZfnD7XYyIepH3+
tutFHRQY9WKMewl12BPqN4aJ/AyCyZjb0rFzTdXSsngBVTdaP8JBAyMIlFl6
hYTkstalDsoCrPUS8FYrxYw/kKvPivKxgo97cNZXK9sOjGdJGkJwHt9+hLXO
hCkM1vPigLufWI11nGv6JET3hZKknmriLz6AoLpKmREP6sCcih4LZ75n7k4z
HfTCGrdgswhIZR/1JDSy1cpvjJKaOO5IsoOmuHycXBoq5APiQR0CoIPsdPyJ
HBICHz4cPT4+LI5zMrWaERI9bDsMsIHUFmnlBbUMvMt2ZP2zajNlu6GPwhA+
AtlHxdahSmmbW5X05/facI47nvj9OKc5GG4cF85jIh6kff5nnicDkXmcv1pc
I1YHAdQ1lmW2GVu2fFKFn0Ullr2CqydWgPpTlZJwQ8S3+ar/siCrukwY8iw7
BsFNTtSTGSD9DrxdmhJ9dFdCidqnAzSCJQ9AAYPTmapuOijDn08B6outdkU8
6IhfDSnvLl/PpN1SAamhCSbfzmiCo7teB5MHd+RBdXLBkQYC28JXBw1DN4xg
ENqWWMq5+loTVilHcmT6a2Uo0A/nt1p1vFeFKWD5hLNDE0mpVFUtz0cPaK/g
+PDz+W2HlGEV1neeDFNUYP2FbkLpoBv1jhW4TELkR59GaNUORxIkHoRIF2ff
jcdEPEj7PLp4UNnZsbYtax0lpt4TRz1MxnFPiaMj2E8soGPpl7zMhqyUr6eq
GKq0KB6/jEYHQXRQj/Mv/EUsBwsM7YgPDn9UEVC1jeNCLjgl4fTRpgWxtov/
JNpiFTmyf5CDOVB0lfhDjopyJwIuef4FgtsC20HizMEH5WpYTfKgWyTGRZxU
sVKKgaYgBaO81nodpJIqNJYAA+viYKXjoCosf4H9iWHU1x3BkIOt6vJR1Url
w1F1rGbhtFcemQGqlWoBTfZHqxyyOEvqEQcf6sEpLNw4P/lEpoqrqnXFXmdR
AEglDm2BcsgXWiDX+PhrAotdHMaRNDjddMSDLDlk1QjkBT/uHt8LJoCM5gzR
czSaelCAx0Q8SPuMSzyI0vquzr+mN2jtd1jcpEJYoLhmWhtkcXeDJQH0QnAg
rZ6hcFdyvN2iMiU+8+NMdsAt2yg0DMbyF7axxnUh5lEJllWepTW4nYk1Wzxt
NvL0ZG80qNekstqOqzBBCuogEks27FaSg0fL+XST/5XDBJZXzGmX6rJGJRwq
wVWtq43ssgMQj9+A4IGpiTUh+ZevC1c1wqr01GEQFrBPGpS9R9KBZFWtYw2w
Do5QxUx2oTnwyb8sr+ize9zdlFRQJM50yDRRoV7u7LgAQOpVtR5UqvI5i7SG
H5gI3mBCDa4pBB1YoqWcvlRvLy1fWTuL/qommmrKeOVZXZJicAnIa1XbyP+L
Y/E0CZXFHmqXZyC2wrMVGm5s1V4nuxhGE8xSwqRCq7px6ImdQkMZByDiX07X
xm8O2S4sAZlCOldUpwJoJDHlZSmCVlsE4QVL31n+Bkt+WOhRjRvJR4wUQo8W
a5ExS+9Go4lN/gnD6ME2UKrmUa6XH7dykl9uU4oYD54S00Q8ODZO8eDw8MnO
7q5FGcz1og4my24sXYvi+AUssqQ0ZfazjSx90VEp9Cw4+6suGG/R7SS7pKPI
w/EHvqLKULmADnyom0bHq7EyVuMyJa2KIVmMrBefNuXSljVPrUPOSchyjt39
5oyBaLjyajoPitJx0F7XwS9qZyrRDSLMijIUlfSw329l682Ju29040+l5ziK
8bgkKqf4WFHlWdUf0NRk3b2PCub8DYw0G8jf+UXmw+kAJ5dq1ePbWfD//ZtI
LMdnsM+3xC+K5Qf4vBIJdry6YEf8kPElEbWBXyfjcL+ObQCBLcKeqVaUFRg+
CsIqE7XLw2NMroxp6nA5eOqDo8kUcLSPBUeiT6ChcWJ+EPuM1/xgd3e3MD+Y
WPd6Ur2U0LP8U3pW/qvMJIuRf3EKqCYSAfnnwsT61xOYheUyQFR1J1SFlBAy
0rcl6a1L01skL3QA4bRLbo7tp72E8GmLcoQO1F60qLixMGfJG5C81MLUHFZ7
gVhhTdDEfZKkiGhKcVI+WBBTvCLlQNihVYRIawAnPsuMANHg5FNzVNGjZkrC
iRXgm0EeE0VpkXRE5hFL2mVGK3FQ5QuJmyrNHTR6rHeVds/O9NF0TZ10jnUT
mirS2mRNxGRZGz4xIf/qJhQp2BDJ1Ep8rf/iYiM/cxEbL1FRbaytTGKtpMtK
zIUJZQZzlehhYqAbYSorqX8pVVIHT1UNCx8rTXVhbKX+VK2ORRzsWSogWVqh
b+X25hCpoLJe9RX5J8vmO5IsnU6CzR/QjTyVCyzt44gK35Cy6uILANJHlILy
mibiQewzXvFgZ2fnh0nVs8NKUZoTXoaS8nlOeMnssGJlwnLQT7IMmWSw9sDt
Mu1TMSOTlVjFWPAtaCh/zgotkR/kZ1bVs0KLJPiMVuCEAiblW2IVGvBX/uTS
Vp2kJJdJenKqIPmrlCs1VqryVyWpyZWj8DFp4WeqyTmzAJmp0EdlJpmjqlwg
OlB1Vm6mtaXjxUfmK1ZFo4jleCRLM4H6wkJgbqjle1a47VlEmMIIuUZapSzt
00A30SYD1V+/XihFXdEW/XxXdiVspaDTH8tXyIxmedNKBwB8re9SKEzKj1Z8
JPLKiYqbPj6Kr+ihG62DoMOZF1Y2N9RBCvDJSK/XSislU4qUFollT8Dyphth
W46cj0gkJxpPmTkMXkAEj0ouh/QIwhfWu1LbqXhKXFN+iw8Yc0tY9UqvaO2A
2B4avTxL5WXyEpjYcRO1HdMUVQpr8T1sCcxuFTJSIaAciQ4kGlK+d3p1cnG9
cpXjRDyoLx4kSYfiwT/HlLj4G2b65aJv6UF6Fr4DcqQ00z8bJdtPsQz2ilRe
KikXtjwryijfkh7IRC2sxEeCbKtCUR4l5wADSjP8c0mAnKpJCmCvk6AwsJzX
Lc8EfWT85QJy0yS6UWEqaydzqKwkE9lqFkGorGEVg0BW8tGOpzQ8WZhz6EBK
EVaSSjdVdvNJTWU9Sq4BeSypptbFY7qVREi2ZfGW5YQllhRU7fXaJo1cfcR+
onYxeWSv/rI8U1vKYi6VYpYHAn9LYsmJooydyDEEmKnU1EolsH7ZzgE5rv45
0relyQz6SCLBkivymyXJOA5qesTkr2xw7E097xUG+6j5pIIo+aisnYU/Sypk
vmBNgMChcp9EktM6jqyq0pylZcBXMHqS2PKBqzALUxP7ftYRtFl05ksspia4
FHHtCZUvJAcxgbRQwPqX5FGQ9VJrp5CUZmyV9oqqIKzma6IwX8g5IsHilB00
qpD4Z0vdE4cRHJ2yQ0DBAlsxe7+ISnNcDOzdLaWdoVKeQ0mq6FKRZ3GK1XxO
RZjY2B5ob1ElisRNVXdY76Lk7JtDQlPiSfbLLKlTlVvyeVlKeVJ+jY4wcCIe
VA0Mu7u7UTzoFphPTchvYf3lEmRJ1EwssYDAE8JESiwkOahyEhW9WUEFKJG1
U6oOLtDXXgmaVvpg5WUgjpOXWtHMwDyUgO3SR38Hk8x6rHYWtlQkEa81yS2r
pRIcrKSS0VgmB7gOPcIklspQEgJHocif5IPW6vjlSW2ioiS1lCQjhwIcepJv
6ZBkITQOtCmj0BYRCJ8pHGhKHPTho6NeFiYkNCWzpAfUfPSgtV4qizlig9GT
1QdR+a60Znx8+L0eaiZGHCqVSAGQ7QzZBPlZwtCN1gfxqaHUHYEXhPxQ9UWr
nip5JL+o6iSoQuMDob4ll1cSCkI0fnOAKAENOPkX3/hTOQtJHPumSSVZlv9R
JxbZIf4VhFYYfNK7wx6olcqKT4HP/ouFD1AS+FwA+glkdUCt12QcWASk4ikb
OiDLlL7u8tQKFA9OrBdVfhyMBy1p+GRX1/r3Y0tZcuUSZJDSzMBclOSfWCfr
ZosglGWUyVJSTuwamb28oJKBuSi5BRmUScghtIaUPVUR5egXFWFuKyxEw+jA
0mIb5lrKC7MMOD7iWwrKWHFQpza1gUBOYc4hgIZ0+ijlDZMfGNlBrcB8J1UI
EAusA0OO/8x8RWN5VnNsAiYmTN6U+OuAL/PXTpItFdnRx+af22u0mz1iFh0X
vzEJJ8oz6EazG5zyLMmRW6eQT0uOmxUxFyXmjPCflEZrXRT5nynaNzd7v8Xa
P7JUxlF+6YVDJyBbVrXVy7SHBB0g/IW3Qmt/obQwpJskAXSzD0PIZkL0jl/G
cfsA7L84fKRqEEQvOA1RDRPI/kh+kPBhQaDqHZlYFp6KoUxPwokaH/nUkVj9
iNQu0j6zktwirF2OdE+kn0CTNFyWMA+QAGvDTe4IxN7ETmzc5AEfRTF4f0GV
B1JgMCJzXqTiL9PcNZgHAYMP95qUfQ1TflgKaO9O2GguoKpB/pXGQRnMSuh5
p1ZK8aDuKcKJeJBMp04NS/HgB3FlLLunTFR1ow47cPRCCYczL2N7RdJEK3DV
fpnVsWIIkNLOxx84jSJD5k9ZSsNTWO0YGfl+FIYDC1UJHxb+1PZKms6aCeLD
YUEWAh97A8IyVnzaqooli7ZAA0j1T6iNZeGmbI7UZKUwyOxQTVjryCo4wqmc
sGCBdVE4pdQcqvrIE3N8YWDJKskyEnNSKsgXtQ4IQOiM4YMhoDrZR5KX1Xay
mXJdGEdI+NRxLSVrbFUwxmdY8Dn1kl2/NBhOMpE0ehy1pYhxMGi6imO9LeGn
v10YTiLA0UHSLlFxlibgqPqF5VNbzR+oh/SnLHlzURhbUp4xUnPWfkBqJAUD
Gz+RqCfjQFVbzvihXTGaQUPvKjUUYpeA1QHpz3qRxByoayyx0QpEU3sheicz
FPuGtAVIN9LGSuzmD8Wj8lTWcwQJK0ZW7cLQR44TyGkRtaQqH8l+n1MvdbqT
+iIuHgF2CqukAz/ElnHDrL2ScZoUDWssKZlyQuj5rKqamB/EPuMzPzgy1NXV
hc0PYv4klSlUM0X1B1iSzJd2lhpiUiRYA2vfp9Ro5SvYih2l+pMiTeoOKZnK
Z2WN/H4cMNRGgaDUetlj5MRKpHWF2Hm+nurgnZxmBltIZBtyDMa9LNYiHyo+
WKUuwTkugUWCWQvKVhLKLbBQfC4U8BQH+sSfBgmTWYGGmcEG14AChIz0l2uw
koCWGWc3a9cglRd/FkqQlbQlvS8WtiT15BcRNISMPLiKQWaZaLqssuVQEiHZ
n5fASopARVjBR8voqGzq3Widi+UhuMBN45InaarUVdprGVLgSozM44gF5Eqj
u/IcKynDyhkBtqQVSu86B9kEwDlAHgoulMaKZwXnigJQiDFRhgYZ7FXiSSqs
m303yppVIThbKI3HzgpAqBa5hOQhyswKKpIZJAubtbxBFGCD5AnMFmTYwBmX
s+JcKEqOOBEQjDIL3AIVwmnvV8hkZwmhncULthNsG5KIthLYYBGUWMBZfJ4l
j+GjTLkAR1TsLb/MBQxPvkHTZCcxd4hEDPtXFiQZN5u1FC2YSPM8xGKBAiGW
IRHBkAbLzDXIFkyaNRBlQBpHLSSRUeqFshNUuMSSVSywlAnO409mKemMueik
KcDcTrIkNu6klBCMR9SS1DhCOedFKper/RpCVdulppU8mVeqiU1g/A0c6cXo
oCqBcsKiNklPpREDUk/d7G0atfPi/EtygaQJ6y1lAQ5k5V8cgwNMLJVXOsB8
eWAxC+IaQfxb2QPHMFGGrlTpYj2rYkXpAoJxy8mBQ/WNMbCk423fQzHXTcll
fFIqEwsm9g/afR5dPEjlEb8fxHwkieOqRhWiNVRxpUZAWoFjlo38pmqWi5bx
NFKz+J0FCYGE5mZvtJXMUvrqEP11DWAuB+WwjO84kf0C1hFgtFXltSqdsaX7
Vv/WgCJE5CEjdwgVQK6U0A8GFQvrQIIt5khygwVxtcqD5GUp3OPCmVYXVPK+
0PNsxSZBDEPOTjQWxSwIBOeJK3utnqp1HQtf11RpxYkvlKKODckyOSs6hxL1
BCrRJk91b5cTg/QcMdyWMBTCFqrvZ0FSjNlJzwFor5SNwro8Un0sy4e49gSi
11R9pP7kzJ4THlShjKQgP7ZFTYWWIE4M5OV2CUmM6WYJ9CxyDcwWv3PJSq3J
MkAx279gTkChi7WzdgmyI5cbzUVRJY5EfHlC37IkWNRWWampyyRsoWJIgYgb
dPaEry/69p/KzCX9OrIM61/yXcsUXrBB1AuBBbOkJIXwAYVKtK3sswxVWaVC
Gv6y215n0XqFC03tqZV8EYNxYRxM6z5rDmH5/GLFg/r4C0magLP4q1ovZH80
pKXYen7OK3wMyWgRwiPVKImDLRMmbXBGtV0kYbXy0VUxFOPijxt5GQet8SAJ
gf8ux5uVWsfqo4HirRoPkuMMJFUh8SAm2yyLR5U0uVIyHsQ6FykelEOYifNF
x8Y7HmTFOLIsUdcdsQaLSFZqsucsYbDJDCAedKRSpSvowp3ao1oMjl8K6ZWU
2kFd/chpnQsRH/HXoWmNB7US2TXYEnIKzp445i8OZcMWhtnv8uNPwQgzfRbv
xTK1NCtQmAEU/0U+baE0aTJLGOgudLMOuwmTKYHSRKFQZo5/kTQHJLwuDolb
OVsouVjW1e+FJC+UfStJE0yDJKMnB4CC1xecN0PEZEaQMBGj6luS8Fn6y5rf
Z/Vx/F5eorNzMFMAVOSB18UL3bFIllxJs6Q5WeqLyp5F4r6LYspSVZ5thst+
d62sO8qfku8tvGJduA4/toLKEWUO9SenFUq7J8iPchTLwmjLzhfnoGxJVmXa
uoRIYi+4QM4BOcLcekiBi3X8gT4jaT8pbAsGxek54dg3pdtgb5MxYsqZ9s8G
MaYTlU6YFsy1xDUhllXr0hCEtHZCDIhQuywjObaZQbCdh69D4JSxawJ7nIel
j9QcVjxozSmUZnJt09YWjlgiPpRE+mdbRTrfzRqqkwImGx8ME2VgKE3QS+G2
gInI6JnidDlGBzKmeERDwTJwSAG+HpGs1IEMldeaKiXlBxgH2fkqCjlhlXez
txukVXl0CRtzVv5FPQ0JKCEs2lJHHpSgWAWUk1ZaRzWpM92uCssMoRIr2lLm
UP0KTYLHCWxJ4XQJsvuLv0KYxIdfEcTukVyTykzMD5KfRz0/iPGXKicsjlP1
Tnci40E3wr65AWyp1gRRMRYd+IvemQrLWEHNsg/UcV2qlsnlIXEreViWfsKK
s3VCVBhsGXybSZv84owX8ekmjFoHC+s/rSs5BfdS9FoLnINyLXMNAcIiOsmb
QrXPEj0oyewLXrE0FRVcIHnRUrwjLmq1bTYXgUjOT67oixa60Nb3ugbbDY/I
3yw6W9oVUiDNP8qKgw1UqtpYThkOf7GVJ6yhUctPaVI1WFy6Zt1hKs+0smRY
k67Nsky8Frpa1xigEJ5VXrlGV1k1S2aYcCwMzZcDEOkZ0x1Xac0e+3wJVqtZ
HGH9hKw7lV8UJwRzhKiZsk24UKSkJbhWslhaSThLmOwTxHh2EL63VyknFkUI
kWTeEg7Msg4L2AgeUiDnyNxRagTrEA+Eoas42yueNmCd4bIumcbekuyJrKGC
dgdakCSnwDTJniwzEP1SlStMIzTJA1aXm7SS3DIAZZmrlZcT2Iy59XhbJAwC
0UKkSXwxiAu2YSXH8lJjsb5AaQpcAouEWqTRs8BC26FtjFNZWIrAdxIgmcp8
iG3RFA+SPNJhviDwWSrmZt8pq1atxFZpeyHlWdjCWwqPbqg1yvpFMpSFDMuN
ZLWLNbPMcUeVyABrhxBEKUhanWGMO+rjA7BdsapywiqvzMHcBrzJWtbOsXZn
u9DiemUZbH5wIh4c+9rjQRd7F4sqpRwjD5dPiO6Q+kJFRl6Tr0mRWbVoSixS
wLWVlW/piBnbLkhq80nKxwRo7jjtkgIosYDBxerRuRCHHthCIUYfzcFTHA8X
l4MGWwb3hNgzJHd2EPpZYFkFKjhUljVXAiaBReLOI8PswCLL9FBwDoIj+cYS
WZDDLHubFl/XijBVCyyW2T4SpMo/wke4ykoxbyu404EFQmDon4XCWKAkqPJU
mlvRzV87XiM4IZbliBJYkbC5+jCkJmHeJ1CKcQyWqZ+gHIiKKQd4yZaqjp/b
HgSnOtdZmJ/NE7lgmBNgGd+WZlsgTgWWQ13uSJLLhi3XT6aMtAdY4gJEMWni
TJr6kckoLW+Wd0fKS3FmBeaI1M4lB3+UNQpaIO1EE/kuReguiklDgSbWKVr5
9VnERQbs8THLzBdKSGFllinHq2U3Q55Pl3ntFmiZJcSMoSYHTCkqqmU4FptV
nsznQ7b/1+DiLz4rQngXi8tUJGx0DcmfESgaNOs+QYE44qiXS3AR6gExD1ne
QYwZWOx7ZnCOFTeDsqRSp5QbuCAagVVB/VfVe4fzFO4ku9pfIMJvAlw24LWT
S0f4dfFz4NII+ZefIPG+Ej51nwuHmPwWuZLj5+M6I6BMumXSlbZPn09PKgWo
CGg9owkiIWR5MocVD1JhYus/+baRKidYmYl4kPx8DfEgNt7OmvenCgammCxZ
1adfGASWEdBqHEicgeuu4TlAbcXG/eyUHbAej6q/1IW7LEwg1o+l49SEWi05
pbOJgx0gtotj9KSwzjJLElzkHJQthnKlziHWhZ0hqC7htA3JdXQRJzjcLAdr
FLoGZs8UdhcKs1Gu9otbLJ6VFCRaz7lVHEFTQGLIWo6CrX1FjpySoRIpxAnN
PP5h3RAxphKTNZ5PlVgqr+U509nW1Xqc87fhSidLu6s46+EWUOIi+qJiOM+8
KArTI9WZd069onaIE5FCACVEPSgMFNclCqwX0LCdR1ToRlgJ/gollpxgiLHw
xOoiLbCQI8QL4npLcRIcSbsw8R2UhwF3C5TXVFu5FlIghpMF0kAK1VqKrwhq
Is4Jins2BbLbztWRm2/pIELsjnycSVysgDffsnq80KKM4lyhPDVPrqybHWSB
P8uOfVBXjb9eVOYUGVFqlXO+HeNDVoq6OJ5WNNO6IEF8KJwekPuSd/ZUf4NI
jdy5AtmtSxGs08GudmfUFGJVKONrJXFkARAhCyZxVrBlwlca01OGkxB/QHUR
glZm8SFg0QE88Wvho6G1LmqinjPDkitljuOr+Fj/Ojg75kbzRrApaRICUL9Y
CLDGE6j59jqiUpe+eJAv/3x+cVZOYusndcu5jRHsA4cV25PzZdsCb4WLwnq7
KSSWtHV8PJU7pybWi5KfRxEPUkezWfuPVJVU1kH+/I6OpAMCaXyoxgTz5ajx
IFAdZFDwvkP5rlKPMM3CKKx8IPcb8rHVtH9QxzyjNB83FSV/wzT/nGkBedMC
bAdMcQQMaHkET16M1ATXPbAYuUNzgg1PeKY96Z0xN6RIPjsRufdyEyw71MQl
cEKQ6Jf7hOeqH3llvuyXKzg/0ni4GBpI+5vEJW3CqlRpAaqLuN8KbsH4mVK8
KcVWruIyLdSKWcEUs6xDOzgRkxIZiDzP9MtD7JsqcDB3OnIXhXnVfNV74qhK
QYcvLP8rQmwSGORveHxZxmQ/w2w2elJoP8M/F/nG08SEHtBPKjKsdYAyEy0O
c0ieNAXmHCiMD6A2ClGVkJlrmYTijtuTW1xd7Q+roXJHzqT2/tTRG/uSNldf
Op9WmOMOKHzaO/sHXhkv+xmknYOzrUbYcoyMf863vdJeDsifE1woHZrkxnDP
ZgbnoIh4qm/uj73SXYX5KcOsYFsZBM05wPCyGCRK5wshBZcmWF2t5/qq2Qfx
cNTA/Jd9cl7yzkLf0wMN8n5GeRBDklUEeYY4Byov1bZaGLv1opp0BLO6kPJa
E6R2pVQotyMJNiokV5rvQ4x41jP3H5akPO2b5Rpq+Lm38CyqiWUPrHWdbSEK
82eHGBDXfrI87UnfDGnhKKcfp7nlwivCQT3BgvD80DPjl755s4PxuFLWL7Kn
gyRWeZZXj7FYE79UV2IrK1VtiFb7jFWnXFCtyX660cbDVSmsSRqVbWf5SHCe
crDFKqKOD2v1tahiA3H8pD0a47XLSVYHLP7lowHhCKekPltkQYZ20pHMOzei
/4I0nyXeJFkw1mM7cbD2on8n5gfJzyOdH5TZwY8X+PacJW/A40SUiTNaSy3A
j/5Yg+FYSRfFrIqyFog9nGV/hj9w3JJso1JTbPu2iEjTFdv9wbWofHz461U4
ekpNwhn4QYaX/HKm+hrmBxUjd/GHy1c975+jOsA10/4sdLm9hIdsEI9TEMbA
nUOykUf0E6+csJIt/rk1P/XMnhVQJC58KnQWzxqVB89dhNAjf25Qzq88M//Z
N+fD1LrlKcanvTN+5J0rRDrBORLmroHZ84IKf7A8/SfeWXOCiqVpFDf/Anlp
HJXOrsSR3ZjYuCo2rQsedbAw2yI6dYX/vDRFQJsdD7JW7wNlTJZnTdusUMkX
fLJmBBXMCyl19jV8zztlRlDh3MAi5TyOm3Ug0VVxaCQ8uUonhwQVT/fLmhFZ
kdqw+U/Rhuf88PWiijZaT1wMKpjql41iVVTvbLV7E0g4UqwnHTCL4n1hgWhw
0feWp/zb8pXCIIC49lg+mkN5ngxH/rFO0JV2XrcLIB4kvWKqVAhrPqVdsUJD
DNP9DN9Yvur3sVWemUZnv/Rve2Yj0ZVEWlh/G2SYHpDtHFqWUbX5w1DDM/45
yk2R5PgSStP88uZHl/0lsfqVgJyfL836oWfWnGAL/RHBX/bLfconAwVxcwU1
zH3RN3tGgNgc+TZnwpa6KMfZxBNvpvvnTwnK/U1MuUdowQ88U37umYsCVSnQ
s+ga0pfQoqeWp/zUK3VuSNEsy4ULBok7yqWqpLphmRAPmZQ6tn1TX5RIKin5
LykSlnxhy0OhNJyFZHJ2WHFV+84zl6/evnvn2JkLq8wbn/ETOOIWUjw7IFsM
7QWaI47/cHn6iyEFS3Na3w0t/delaZKCKJcmyr0JxnGLZQgyOAcWuAVkuwYU
POWblVDVFZxp/IV3pmobSXOkKUhk2Xn+K0qLimmKLGmkJ6M6vwn32FUTq175
YB/5L9X5Pn3xoKx3ZOSOQaPGg1QvAsJfElssdsO0FSMUq1J5SFk276RTh/XC
fJePLEPttVVJTT7Psh62Ly/e5pTHbD7ZBWBJOQipeuYeR1pYxUipcFH4w3wi
sMwjSU/MKjoHGFgNl5rpvbJiIh7EPuMbD2rVdBd5Z4cicnS1nkhPdpccBaTK
pGqwhqknX/5ZqkoC59hGFjKkFeLgxgFF9RaUVSjbDtF3qnlUvivzi1wtQMoA
xi9ZYammWH5GzuEvfHKyW/t2DBxp27x/8PhZc2PXC54Zk8Xpg6k+WU96ZYnb
tfKeXZ71lF+mNPswMyjbxV+cOwjIEWYExCmDGYE56N+XfYQgbroUKQQJBZCX
8qJfHnIghWFwf8Njy3I2HLrR0LbJadFKBFzwaoJyXMWdpNJCxBmCzy+09Nnl
Gc8El7TtHTk3eunQyMXBw8cXRVY84ZuJzBF68VlfYebuBb/spRn1n8YX/so7
S4gOgrKf9cp82ssaVwblT/bJQYWn+eYit1k6F/QZn5ynfDKlQxhcxBmQKb5C
GeQzC36duKJP8pkt4iGEzPmodeg5srjjo2TTvyxJsepUrjQ/JRxxGZRDyiRn
LJQv5+RPWx9k3UEp/UTIO4eWtO8+umXXkfZt+48MDSXm1nxneRaiPCLU875Z
z/hkzQ4SZg9/6Zn1km+ea4hwkOwMcamtcKqPMNeWJ7BVWJoo7NB83jcD0UeI
F/yFlYoomvulZ8Y04aBXAYeXvNLnrKi5cvfWktjCSYtTn/XNEiL0gCxxr2Kh
tGINUXKGb+bL4VXGngObdh7qHRjauvf4pt3HTK0bXfwyJ0tE9hdkBmGIwKIg
5QmvzOmiwEjhD8IZ8VFYKimyTGyyZbHiZP9cX0OzT+7qf12WPj3AcpysfP8a
i9SYuQPaInhSArfzY0WspNlMN3G27sfeWemrd1y4cvXQyXOnRoZCM4yPe9ra
7hyQ/4Jf5ryoxtGRa0vC8iYtzXjWN1twV4JFmfTPf84nE/EUxReIob/yRoFe
/veXpYS3DN67e3u2b9rvk81LV5oQMcXzTHL/3StrVduBzk3bfr485Tm/7Bmh
VeaO/v+OLHzSXyDy896ZT/nmSFOr0wIsM++oFqSSs6VNmoHCTStPeqa/lWDq
PzG86+BQ35Fz/XsG3wrN+1/LsmeLGv2UV9Zz3lkIyNO+mZ+taPh8pfFnXhlC
4OOX95RXxrM+gumwhLTWSxWlM6OkNeEcXnCG7qlaxnIISQNIHbSB7x7C+g5h
ZjAk/5+WpP5pRc39B2NjD+9Xrdu5qqZrzdaDD8fG9p44jcj4U8/MWYIBsdw3
8cTyjD8kNu0bvnTs1Pmh81da2je7+aVN8RdYjIzni76Z0uJ5ZBURjwSLJ67k
R1I0PSjnea+sF30MyJxO9zP80msVeusby7L6T55tbW1zWpTypE+mNIcu+erC
xazS4mH7CyyUloQkoxtnvkxxXxXJCNJwafLSMW1VIqxJZ4H9LwcHbDhU2RzZ
s9JkH1xp9wmSLrebvbUnR9FdiMCZOk5FJTsWrJGNVQqGi+I+ZaX8AO2nbAnJ
eH+m/R3NmD9Dtp213ZgcVuLwXZmUPpUb7VQE1wD6vn4OPckWkbrDWodJFQBq
oo6kybzGlnWxElVZqP4hX8ix1inpPzE/SH4eXTxIihCZTwowX0dYQxzUuIlz
zhtfeID2mZOoc5d8b4GaibULW3fK102lglOr1tofsWZXNe07lntqGQdIn4Xc
8v9cnnXo7Pm1m7Y8H5j7XlLDtWsPiqqa/s/StG95pb8UlPdBchUK8f7NM/eP
ScbfRhR8Y3kacjCe8MoW10Hl/Wx55o+9c+aGFL3ok/OMb95Pl2VNCyr8eKUR
hWkvBeQ+653xY5/8T1LNrwQZvrE8Y04wcjWznDwzG7YPpVc0fsc/74OY0seX
pb3km/ukVw4CODes8GXfrJ97ZwszPgE53/DM3jV09cyRE/P9cyaHFFds3BuT
YXb6csUvfXM/SKmdH2b4r2UZ/59n1u7jQ6bG9knLclAQ+g9LM96KM74bW/zN
ZasQd5CnPS+s5MOkypf8hfugZ/rl/qNn2m/jqv4cU/b40lUoxnELNXxvacbU
4OKPk4zPeWb+1Cf7FdRT+OUjp32qv3R6vDiBEmRAEcq88KKxMeTwPfhtXOWk
xSst/Zp04gcqGVzEkWdVEVXKAH/yziXI9o2AvOSdNTu66t7DGysLGqYHFviU
bR67e3NxXDGi3r8sz5wXWfFBYtUPlmY8EZj/WUqtW0D2f3lmoDDwF8vThdsN
ArJ+6JnxjL9hbkgeCg2e8c39oWf2wuiK92IrEFudgwsfX5YxPbjkk1Tj897p
P/HJRhyc4pXxWrx5z/GhDyIK3ow1uofkf8szC1Hyh145SDDmBQkrIZ/xFqK8
mSFF78ZVvBZRMnD5Xs+23chn/n1E8c+8coRwI7gQBQsv+OZMDTL832UZr0WW
v59Y9ZPlac/5580OyPq/S9J/E1f5x/jSbyxfhbgwJ6jYMpYVnD/dN+97Xpmj
124gA+uX1zLpq+QZ6BVxcayrdAG6mu1S9Wc4is/hI9PxCBDXP1smMQ0/Wpr6
ZXH32MM7H0bl/dg7N62pL6Wy9bueaU95C5NoiES/9Mn4iWfq/OiG3m3H3w/O
W5BgWhCU++1l6Sgue94n+/vLM95OqFwQbnD6KnlqcOGH8ZVIcZ7yzfpNZMVf
UqoeW5LesOf05m07nJauEqyBn8FpWXb51nOIVsErKpy+TJwTWXPyyDXP2KL/
9MpEsvHbeNN7cSXfWZ41xTfrV17piH2z/HJ+5Jn2jF82kgcUVCKlnh1i+NnS
9M+z28fGbnweXeQSXta5b/jG1QtvBuV8d2nqd70yP0iqfius+FvLU50Wp9fu
ONe2YTuq/Rmv9B96Z3+QbFwYUfxfy9NnB9mNYCiWcxswJ5lvJyHxmqYABOKD
cRCweE1BxU+hKCzYgOg8eGIIxdpOX678+yVpTl+sfD26dOwhCgnPfnNZ2nT/
fOl+lukB2d/1yT8xemtNW8c/Lkv5KLu1rnPX22EF312a9iPv3I9Xmt0Dcr+P
7I9Pznc9M95OMv0xquRHS9OEYDAg+/HlOUg9/xxb+M3FqS8F536RXDvVJ+Pv
Fqd37t6fXdb4y+CCP0QX/wCptr+4fDdAuiuE57GzWipPFitDAxf7yAioHUBV
YmkrX39Z+APLq/JdK90g+LCCNTnNsj/RFBvXUgZZyrgGKL1YFMNprzJH6zy7
0gaS/gwJn7UXldMVUskIsfMYL7C3LB4UeJ0waXPg9WoSRTiLWThg9MfkWV88
iDVH+jkRD5KfRxQPatp/QfKdr8uY8XFl303DEhWt+uiI8MsGhxWfsg67wJ6V
BhaipNSGqC4G4BTgnO/EoRvGKb7yssTGOSjvv3yykceSVtrk9EGE06K0TQcv
NDXWT/ItLOzYvf/EuUMnTvwmvsy0+fDQ+Sujly4n5tb9k2/+um17P4rMc1qa
Ydx4sKxmvdNn8f+d3l7R2v3hSlP/iYtHRi8OHDzq7pP2C//SngOnj507PzI0
/FVsyfc8cxCSTssyszv2nz5zbvvBkbPXbhSbmpGb2trT/2ZA7g+WpaFYo33L
/vdC8yYtS/soZ/3Yretv+Wc7LUub7IOim1Uo86uclj0j5/ePXLh45cyfIks+
WrXu/OVrI8PnzGs2/XJZ8qqW3SOXLqOUU9Tk9HnyZ+nrhkYvHjlzbvD42TWd
W5/zz0QFzl64OHz1Rk1T5z8vTnULrijv6O8fujxw7Mymvv2fJZYi3/vn/gW1
XQPhGTXIHxO5Ix6z72/4hVduRHnH/bGxW/fu/ja+fNLiNHHJnLRnp5DUIEgC
qrMSrAsRD86JqR65OPpu0Cqnj6K+GVh18dJ139isqfG1jZt2X7xyt7GzxyO+
atfJ88fOXDp9+uwfQ/LeWFnXtnnn5KWrng+t6tx+MHBlpdMXSStqNqVXrvm8
sPPEyMWhK9eb1/V+6/OVf17ZePzileOjl7Zt63/D3/C0X94U7+wZMcZ9wxeO
Hj0zcOLC6IVzn4bn+VdsLKnrRDE4ol5U9UZjy4YnhNm9vGe9M5yWZLTtO1nV
0DXpL/GBlZvMLV1PLl2F4hrvii0F1R2fZrV29B0ZOHLm7PWbazo2vLw047Fl
mamrd58ZvTx86VpFfRuKW2cESktPpSsPChDkD1cYH6LP2FhAwRoUGc30z3YN
tumvcnhZ075+KrX5DOWPCQvxYGCuEGcFCRNtKBz48dLUxaUbkAQtDMia9NeV
KGSYtDTj01XNlau3zPHK+Cef3Jy2nZG55n9bXrrr0KWDJ84ODI9eunLec2X5
Y1+mRFStW7vj+NDF6wdODCWWdnQPnjl/6XZrc9dPl6x8J6EuJrf505Tqsxev
otw1W/e+G25AoaXT8qy81oEjQ5eOHD7xgmf8L4JMfXvOfB6ZhUQ3e82OUxcv
n7p0MSm9+v20JhSSPO2ZOjOscv2u/b4Jxklfpae07Sgwrf3B0syfL0v7LHvN
2dFzHv5ZKOhD6cTZmyZT808jq3sGRwdPjJ6/fCkgqezN5IaR8zfPnrtY07bV
M6th8/6TSEnPXz/rl24UZquVV4IqpgUxwytTj2p7IYzgqJhydJ0TjFAT6VNZ
knBlpAHR07xuB+r0nwvI/c+laVIDURTs9EXqX1ZVI1H1zVn9jcUpwvxgcM50
P8PjPgXnbtyrbWp97K+JTp8lC7PA3hnTg8s6B84dP3vx7OiZD6MLXwyu7Npz
cmD47PkLV9JL6lCMuTyjubnvyJU79zOKG96IqTx07gqytMdPjPwuJCutqe/4
yFlkey9cuZxiqPu+V7ZzQA4KVMVJSbspJGwGgTUJS3ZenP4aEqfDbZ0bzdV0
ISab+Os2x8vfIN/SDUf17Ds3+z6dXoB19YzGAQ0JGdIhoayItj/flUNnZS1K
G0iWUQoVcJCHlB9N8SBc3nTAwdCA9DUQe+VIgvR0smYp96eQ33z4lgOsJuJB
tc8430dPGztiKY6b9niQ6v+gB+ngfaANlMeF4EdJszSLtdCOP4oITBz91aFr
lMWcsOZjc52utLl+7NhJDp78PWvMtgTkfM8zq33XicFDhw31O05cuHPn5qVp
S1P/PaRk7MH9nq5Njy/LbNk7fOX82bk+GZ8VIld2bHFM1d6RS/llZidvA/LJ
x0aPO30aXbblcNeGXZsHh7f1bHdaku6Xt3p+SEn74PlNXZ1Of02IMu9GIaGL
Z9Zk/9xJy7NKu4dPHD7+h8jcN+Oaxu7cii1sPXH1bnZJ7aSPk1a1Hbh5ZXTK
0lWTFqfGrxncO3DwV0tSRSIUzgzM/blXhmdhe1xB06SvkvM7jh87dPhF38wt
B4YaW9c9422Iadhz+fzQHO/0yZG150evLE+tPTRyKbeo9ldBZReu3s4pavQt
3zr28N6fQw2vJdY/eDCWnVv5H56lYw/HVq9d//fLMvuGbw7s3uH0SdxvV65G
zfoixvADH3Gdm7gh0TW4aEZA/qQvV0WWtj94OHb5+q3fJVb/0jPLQupA8aZp
9rp9VqIueuELrYsiHkQJxYOuEeUoWu/u7S9rG3g49mD3nr1OH8d8KsQdY6m5
picDK87dvtfZueVHnhn5XUfOHz/5UVLdtft3/uCX5pHcjMo0Na5BscmBoQs1
zdsu3LidkFH5M/+SgJzaV6Orzt24k5xbgdzajfsvIwj/tCR1ik/mtNiKc9du
1zdteMEnK3X90RP7DkaWdD+8d3OBH4r+0ocv3l7dsNZpyUphitAv/5+9sjoP
nq1t2ej0aeIXxT0Pxh6+G5jptCRrz9k7ZebWmNU77964+lFYvkts7f2HD5JT
yt/OWHvjxgUE6snAqhuXb8ZmG//FO9MyMC5eSjIrQFin+qcVNTdvC7OEPgVr
ULukM/8h/RfEFrlajy/gKJcW+MI6ZFfp+Ee/vMd9c0q6Dt2//7Cxs/ftEAPS
jmVFfScPn3p1WdpjnhmHL98xNrQ6LS4YOXu1vq3red+sgrUHxu6Mfvur5PZ9
py+Pnp7mm2vo3IfIGJJS8evk5odjdz+OzH1/Vfeh/uNIv1r2nuzZtvvX4SWv
BOajuOOx5bl1vUdiilrb+0eb6tucluTv3nP6Xb+M5VU7r1w46ea98vnIuuGR
c6tMW6/cuP7mshVvZK5/+PC+2bza6a8Zo5fullSt/rulGU8sW/WXrJZz50//
NjTvOb+cSYtXVmw+3NGzc26sMbms4wdLVvibdl++NOrqn9OwdXhtTx8yKcvy
2xPKmv/1q5Urm/ZdGRmZ7rVqsp/dkb8cayb3R8AZKH6+G22DgI7ElJkgw4yA
gp94Z41evtna2//YF2niiayWpQLTfLO/uTRDWBG6Zf/fL0uXblOdGVjwS8+M
P6euOXVr7NDRobDMmm8tTnHyzOw5cmFz55ZJnyaFN+08dvzQBwnmxLL2F75K
/ax4y/07159bnBprPojY/WVc0dQI4637Y7WrN7wQYFhl3vinsKLiTYeGh4df
D8yKqNlx/fKF2T4ZLwZZbm5Vni8kJeoYL3COA3MPHCEp1fqRtavQn80vzjo9
eGKd4Ke17awzGVjnLFHhzwoqYA4pEztW9Mmz0htRliQlhITDH09QRn92vg0N
LORIIk3t4lOG2nbqWB+rXvszptQ9QK1yCBxyAfKXVCsqQHh/iuVPxIPk5xHF
g5jpwDxJajyIcZB1ppAq3yHyCY8EqXLIHwEmZZ61/5EPUEc8SJaRdV9fwgil
bCBmSKksozYHw0f5LqtdMwJzvu2V2bH36M49B2KL21c1bEYxVEZR4zPh5QdH
zr4XlOG0vPDs2Rv+8SWPfbHKaVFK0+6hqsa14cZt69Zv/CC15cCJ87v6938Q
Xb3x0GhQatmS8u7zo5czK1sf/zLxO6FVDx48qGjdEle5Nr/zwMOr1z8NyX3c
J9vp/7H3HnBRZNn+OM7bz++93/vve2/f2923afa3eWZn08zOzuwElWBWcsaM
GDCScxRBjCA5NknEgCIiKGbAgIggYlYkqIABc55Ruv/n1q0uqqu6qhtEZeR8
P2XbVN+64dxQ53vPufd6Z5Q1tCeu32EwN+57C+NL6prXbz/gt7H+yuVzBgvW
nO54AFroEM+UX3gmxOw9e/LkpQ/dk4cyS5DIDjMhWUMWJFiu2b6xorGqvqO9
+exv3WKLj59PXrfJYF78iba7Jy5cjCjYv3xL9a0HL0p21p44f3lqaJLBzJjj
bR2KwvLSmuv5BcRuaDAvJqq0/sKl80bhRWdPdTgEpsLNKSn7nj588PnClfH7
LzQ2nv4/bsTjdHg4d2SkwjiYOLIauK5cvrEKaNfTl8+/CCEbuTA7nebxz/vm
X32Y7pN3kjHUygfv3N1xoH55fqVi14nz7bcXRGa5ZO0/c7nFYH7UpOT9tzvu
jPBO/Be3OAPfzLY7j4ITi7fXNa/ILA7dWHO963bJrlqblcVN7TdtFmcU1ra2
tLUuSSsymLl00dqD37x4unpjZfT6vUean3RcavvMfc2f/JPHrNl+obVjYlgm
CO3Hwfntt264xRQePXdnTdqmD6IK79+9NzE06yP/LLJNULDi3/2BD17fWl4N
JM7AM+Nsx8PsddveC9ncdfu+hX9iWtX5zbsPGsyPhSu5/HRFTX3Boebmc82R
G/dGFlTef9xdvmvPv7gnGi0mixyHkZVuZNWncXj2e/PXTFy9CcgL0PkpsZt+
60uXTUkuM9HaibSvZNHcx0PP0UmqmzNb+iiYgzLpbrp5Xwam/rtn0qz4XTVN
N1XfPPKL2uAQv/dEfdMI7yQDP8XR1i7Fpt3/5l9QV3/VMSB1yKL4HwZtuHzr
2cLovC2HTqeuKzJwWbogt+JCU9tvF6028M06cqnLIy5nYnxlQ/2lf52/UnGk
afvew0MWxpHFvCEKYBllJzpisop+H7W1W/l07orCkqomp4is/ec7G85djijY
u6yw+uGj5zGZO3aevLI0eUvkxkM37j/atvOg3YqSlmvXHcPT/hRIlp26ZpR3
3Oq0D8v4W1D2v7on5Nc01TSeGzJz+fCIjfm7T+5uuHTrXtdvPOJTys9tLq2E
nmiwMGb8iqINVSf3HrvW1XbJISz1bwGZgrGIP1jxX21cmF5VgZ77MPeZwkj6
j4WS1ccwDtz75nleeR00cmY5koKq7tD+f+CdeLK589iF5v/1SSE2O7I0KWtk
sOKnnvFfRqzN2tH4/IVqR2X112H5d54827r3eNT6ipz9Z6FVf+m5+meBOfl7
anceb7l9646pZ8qK4nP79x8dMn2p79a6a1ev/9Yt7g8BGf/jkWTgmXzw7GXF
upIhs1cYx+5obXvsHK74KJA1wg6nm9jwit/b953+OsArMkRuJZc+OZHPf6/2
5dZ56RmD/FCvk18IOJ3W+AW8RuBWyvUp/s1etWe+NsLPrbyeKQ4jHmn5zLpn
mBXNoAryrHP+hwuvPx3W8qwmWxfMIEmVUZ86lZGwjFewTJ6lfnpFPqjtzSXp
d2esjUjymx/yQTH6nQ/KtHCp+tKnhUjN0mjtKfL9S2c7FI/SvSqUOC15Pqhz
iwDaJcX50TkPxgXog1nQUHNdhv41pY/ctL4HBf2a/94xDMp+3y/91JXO9IJS
YDoGs6IdEisedbVMWlFQ23LTJSLl15FbOq4/XRCm+EFApsGi2LwjTfsqjw1b
UXq04VLlsQsr1+1VlNVVn2qpbmibGZr2vYVrZqXuPHHpVnNza2DenrZbt4EP
rtt3pnDv8aW5JaYhWZ8HKoAPltZdzSjc/Z5HosGipK31V3buP2oQtK61rT06
b9+Fq10zIjI+8s/8jWeCe8GxZ3e6Rnut+WWQApjgz90S3nOPiy8/0XG3K77g
QMT6yhPnz3zmnbDj+MWs/GKI6uy1u/UNTfFltSVVjYlFB4xDMwpqmzuarm07
1tzedmVMWN6xpgdJKZsNPJJ/Pj/Gb1P1mZbWcRFbjp1onxyaTlb9+GSebr2X
Vli5t7EzLacEghmze0IyEiMnZeQCS/04OGv/iQugsOXvqQMt9+vADHrwH21I
/KbV27Yt09T5jdlQkw/+wzd15LJCoHXTIzMN5sYYzFqes+9yw9HDs9PKT1y4
9IsFq9031LVduDZ0UdzHwZkGXuknOx+EJW/w23D0WGNLeUVtqGLX9oOnjjZe
qq4//+sFKw28kiI2Hmm9/nhnRfWK4uqOzluJxYdLDp/N3VHjl7T1a780sqZs
1ZZzVzpclqb/yCvlN0FrO+/en780zXdzw4GDJ5JKGxobzvzYPZ49wDEo+/u+
yZWXbhaVHzLwTPn+orjIbfXHT5xeubXm7JlLBnOXb6q5XLL3iIFHgsGC+LTy
01WNjVuPNzWeu5hYfHTboTPJxQdmrMj/S0Aa2cWR2VMF+ODIkIy/+GX+h2ey
YudRqIVj51qBav0jKINp6gqpl6nW7skeu6DtnS5Yiqu1RqSe5XdzejId3Q/E
MCyPHLbim/qfHok/8EwasjA2ZueZK5cveCWVVx65aOyVDPRt38WbuVv2/GvA
uroT12aGpb/vlfh++MZLN554ROVsOHh63dbyIfNivQuqG5uah/km/GvA2iNn
bnqtyXOK39dw/NIvF6wpqLlctqfawD0JBAXs4z3vrJK61rziXcAUNh+70tV5
Z+++k5MXZx240NFwuiVh+7HiypOpmw8Z+qXGl508fLZ1R1VDWPaOrYcuHDnR
WlV36g/uZLHwH72S56Tt7urqsglL/4N3qsHCxNq2u0Vl+xxiyh7eeVxYdsA7
fX/NmaufB6Vn7r9YsP3ge3PjFhfV3br3MK3wQNjafY2XLk5enPhn9qgRBWNq
J7I1kXa9M5ReT9SrcU9qnNSpZGrNktT1dUjOj7wTmztuNFzsMHCPHx6aTs99
MGY2SvqtX8bjZy837q2jlUI78tfB6T/1Sv6FR7LBosRPwgqu33qQtbnmbNP1
oj21a/efKtxT65dS5JZTcfPhg+J9h92SyxpOtFj6Z6woPr1zx1GDmSvjD5w+
cf6ygduaEaFZf/ZLgZ514NTF9cU7DRassU3e1XLllkto5p8DydpVZv/YPG44
4q870yocKf9qwT7evR279JEwl27PHiY8T9Hevgel1A898y8Tmz6l0FpwrfNO
vZWPTsojr8bobM/8PdI1csujn1LjHj+T8vUlU4NiMqjTDiLIUh8qSEMCfZrT
kCqRjBwEfLAPdS0zgaDz9BadOZTv71oVb06XRj4oxhvmg4KGwbVteY1FMMpp
ZYX8GLTyl1fpib29ZNb69aorae0RYj95nfM/UulqfRnp8z4yYrfg0+F1oLV0
RsGSSxSl6yvnp34Z567d3FSyDxS5H/mnbjrc2nr2zIiIdZdu3l2wVPGee8bZ
G08PHTz63pyVPwvf8Oylam3BVgOPjOPtz6GN2wQl2qdXqlTdhyuO/MQ7zT1h
25891hjMi7v66NvdBxv3ne5Iyy0aMnO5gXvq0NAcskUnoSSpO0/d2rGv2mBO
7CdRm5QqVWZ2kYFrXG7FGeg123ZW/8IrblhIDvCsDwPybz3rPlhRM2RRPOg8
YesrQtfvu/60O1mx1WBquN/6uoc3Wj/2ijnWdD1/yw6D2as2HW+/dO6swZxl
BvPj/+ST+VFYVm1b197D9TEb91uEZBm4rCqq77x+teVnC+IMfNLPXH9ecWDf
pyGbzl647hKe9dfAzH93i/Vfd6hb9e35C80WQakfByroMeLMoJ0HqtcHvkmf
BSnOtrVDedPLgMUkfxHIHJPB7H5JF7j1tj33gTYaivjgiOhNDx7d9YnJH+Ke
8LvgvAsdTzdu3O6StufilfZPPOO/jtqsVH27On2TwZxV09MrIPMuYSmfR20G
MnWt9fIP3BKS97Yqu1Vxudt+H5i7aPVmA5elBqHroXKzy45fuXF/amjKkJnR
v/BJMQnL+Dok+0ufNKNVRbeePvaPWWcwZ0XE1gbVt49H+8T+dknh2Y6H3aqH
S5IKh3imMhyZ2Ee+55t67MqdbXsOv+cR/0VAGmi/Ry/eUX37LDZr25B5cQU1
TdXHThrMX/3D4OwHz1VrUrdAhO1NLUAVDeau+SQwg+i0zK6MdNOYEaE5UAX/
6wsk9axSqaxsbPqVb9qf/FJMQsm5kDLy16r28N/+fB2Gr5HqOdUs8z6lu2sS
g1Fg5u/9MleV1WQV7fvQMwlKHby5obP5zMKkcmBqRp6rDQIK7jxXZm3eaeCT
03btsc/yPBDC0m2nVMoHv/JK2NtwaXPpTgPXlX6balqudgz3i38vMK+h9Z73
6rWOSVXnG1vfnx9feub67qo6iJkUITjdwFux79St9dsPGCxY/euwdXe/6VY9
eWTskZZ0qPXCmUaDudEGrqs/D8z9g0/C5HjiI93ScMbALW5DZYtS1b06u8zA
M9E4NON3nsnzM/fef9BlFpRk4JEWv/OkSvVshE96XdPDI/v3Dpkcapu0p+vJ
4098UzYe6dgBxH9ezJ3nLzdsKDWYEuGqOPzk3jWnsOS/BJCqocs8jam1XcQH
+dP18tKWqV/xeiXxU6+oz/MvsgtQaNb/554Yve4A9KyZiYXfmx/3ZYBiaIji
774ZBvNjEosOg2CdVm38jU8Cs6dxxt/802wStpZUNTpGZv/LwpU/DMrvvPFk
RWbp8eZH+flFBjOWGHinGHgln+68c6L+mMG0xUYxZbdvP7f2Tlm9/XxlxVGD
uaus43Z3K1X+sdkGCxKcVmwyXZy7r765aPtOg/mxjikVt248cglN+yA4gy5c
ZfxXtbA8nYOMjJ6gj7h6JV7B3tr65ES+FFLhZTZ8likLn0f3tuXI5+0VZahV
69OqqItj1hq/oWiXPMNQDaVLoNJI2Qv00Talapyfz96+H+VpslT70Ri0e+9b
LuC/+qfb75f+2j4XWCqMzOpOvg1F6wsU+aAYr2k/Ga1MR+s5IPr3UPEoJ5iK
EbecXvVHKeOj1j9lCKmg3+kzf2KsbVJLLCudfqdayy71cjGRPmdNp0Bk5tbk
5W+iPtJan/BczocFZ7zvl152oulaR/u2qtPArW7eap8Rmf3RksIz7e0Ll+ca
uCVaJ5aCgne0sbnz/jcHDzd+6pNi4BG3rvrq0wddny5a9fnSwpfdqqy8IgPP
9D3nujrbr5fWX7p5q2Pa4kzz2LLH3z4/dPLCubbb23dW/c03+cugjCHeaWm7
Lzx/9mjficv3n39bXnnsr55JP/GKN19ZDr1mZWYR0UIhh2FZoIhaxpfcfKoC
glZ57tqTb771jt0UUXzyTtdt0I1vPX567lTD/1u0KrqkER4srzxiFbn2yKU7
1651VJy6dub0BaCfFRfvnzh3Mb209sjpywkbd/4+LL+x/eG5S80nrz1oudxq
6Bc/NKoYOqhzWMafA7O+Ckz+v4E5975R1R06PMRtDdsvmPU+8OVT/7SvQ3I6
796HtNLKjg1xT/p7QBpZm8McE8DoDDnAdo17/xYTT37K9yDa8rk6/cwvbXjE
uiu3H54831xcdbbp1oNjjaf/5B47b21lw/lLX/snveeRGF504sm3T3fXNX3T
rczYsOvHHmt+6Jd1/d63dTXHDGYv98wHlbV7amjCTyOLLl5/WHe66ciFzjNn
znzqmbSiqP6b5093HrtwpeN+TFbhf3tn/MM3eVhUYdONBzdu3Nrf0NytfB6V
tu0/fJKBimbXdiiVT0f6JRIqzbjMDQvO/nff9P0Xbm4uPwISGxaaZeAWv2bv
BZXyW7PADINFcWvKG18qHx1pbL129+HxhlN/9kz8r6Dsmpauzs4b+xqvtrRe
mxid+Se/NLI3bBjxzfsyVPFr7+SdNecgwwdPNr3vn/IH79QRjPWNOXtCrv8K
9uUT9wu+btNbPURyaA1mTjlRx/xrr9SAgsMPvnnReO5y1fn2h48fRSWuN/DL
Pn39fsu1ziOnOm523lmq2PI99/ymqw9vdF7fc7Ll+ZOX0ckbDRYm7Gs4V7Bp
h8HcGPd1hxovtRr6Jn4vcN2RC9c9Y9ZOjttzvP7Sr+evgZ+edXcfOdU0YwXZ
ytXAJ72k/mpe0f4hnikgeb8NNS+6Xzr4p/yfgKwzV+9dvdoOQj57ttkhLBXy
cPPxt0cOVA+ZFeVfeIxMGizJ/EUAOSLhQ+/ESfHbIKtVtacPnG5/9PCuf8IG
IKqRhUfh5u7aS1duPoVO9xfv+LmKKtWzb8sPnd56uKnzeteuE03XHz5tu3TJ
PDDhr4H0DaKgLZlxsc4RWIK0XlLr5QW9RqjG8Pi+IHKZmtVnDRd/sCUB6AEr
QVn/7Z1Sc/GKSqlySyv5nV/Kz31S/hqQlrjtoFKlSig6+N7CJGilNEuf+WYa
h6+tPn/zzp17e49fuv7kaU1146/c1jiu3vnkyTMyWrbfyy7c46Eov/vg6a7a
c1c67t5svTXcK2FV8ek9e6p/4R7/fe+UtPLTz55/u+P4hdv373nGb8zbc4LM
iS2MAarY3HTTOTTzQ8akPiycuLLTs1r4IjKStnrz5anPunUp6ckLU6oWuFT0
1GylBk+p8OJzHPTR/wUSkArfq73+DEX+6lxZZPaIkMqwkWj1Cje9r/V9JHY0
5UfF70rG0jqJzNwLd24jfxWneCafi1lKbzSWHgH0F44xt+ozTLgAU1w6Lnyv
UpFaoyolMa1llOpBfZg01mpK0LpFsGBkEPR6+fiNRZoJvZAPivE6+KCgHQp4
h7hNGoo0H3Ev5vcL8ab3gpvcn+KExO1HPHPFJ57cUhGtWRLkQapXyg8CMuHl
3y/iXsmXEp8d96KH8ibl+Bnmj8zy5RWIUfyGlaHVklkKVQwLVoyJyJ8eu8Ur
uWRR3FZgN//rnTRycY5F5NrRzAv0fa9E46gNKTtql2dtB+72x4DMYaH5oKLb
R6z7Z3CGYWCmbXTBGOYgvE9Csv1zDyh2Hp0avfb3Pum/9k40XbYprax2ZW65
eVj2V0EZhuGEI4wKy7dbsSm5pHp59o4/+iT91T/DYMHqCSt23L/7wD4k/aPA
DOOgHMNw4oH5vkfCFxHrVm07lL6t0i4i+9884/8SoAjM35dcXOkQTc40NAzI
As0nZP2BpM37P/VJ+iAwM3L9wfStVXah6Q7JOxuars+OXTd1+cY5qZWgmHkv
zzTwy1hRfDhx414j/4z/9U0etzjfPCofVDW4fu0eZ+CjaL7/bFVmIZBWcnRX
GBU4MRSCdmcWufbarfvrDhw3cE/+Qn30M1/U4u4mPseEG/+lZt5kJhlkOoLV
svWzErb4pJQsiN36iW/S732STSMKzCLzDIMUhsGpP/BKnpK8PXfPsYCYwv/j
mTw0OOer4CzTqLWmS/K+CAQ559lHbzAKSgOGaxi5bmlRdfymqtHByUC1fuKT
MidpR275sYC04hHB6cxhhWRB3KjwvLmpJVm7jrmuXP8Tn+R/BKQazFmde6St
oaH+vUVrqPWHyW3usJAcsyXrLCJyQTX9p1/Ge3NWpuw+f/HsuR8zau3ag+cr
quv81u5ftW7XZz6pfwxI/6dv2odBaRHrq7K2H3Jdlf9ZYAZJNDSduL0FZw4N
UXwUkH70bFv1+daP/DM/9E41YaliBnMyuFyz1zpKSPU48eueHMKrXvPCdUOp
9yY/LeA+0JaIZk46eN6vPGK/iMxfvuVwflnN9JVZP/dO/Ktf+vCI9Ynbq0PS
to0IyhoTkTMsKGdMWN7s1O3Zu47OWbb+J55JX4VlQfMzXZwLtHd0RL7Vknzj
4PSvQxTmUdBJc0eG50FvhZ77m4AU36zKpKKqcWG5/wjNgABmEfnjI9YNJ4dv
5nwSnGaxNH9cePYf/JI+Ds5aUnAkq/iQ8wpCZz4PVJhG5I8NzwWBm0Sss4kq
GEHOlMyiB0pCKRyWbViUVOIRvw063Y88E4Fr/N4/3S1zV3rx4SlL80eEZ48O
yfydX5pX1v70zRXD/NMXZR9ILamcvGwtjAzGuvZoFf8qNT7zu4NMfWmtTUE8
gvcabT+CDMi7XRmGsnulQiP8g2/Kx0Hpe2suApW+9fDJ+bbrz1/CV7IL7trd
MGIk/d0vlaFmJPBnfuk/9U31zNqzdt/xxRklH3unfRKY8YFn2siowpQdx6LX
7rIMzfmxT5Jr2q7s0uqZy/JGB5FjBMctzjMPJx3w64CsH3unz00uy9ld6x5b
+KFfsnnkBrNwBT3N0zJi/agQovea8AouJR++MagnMO+wPHHb5lMqI21zxVpr
TVALMrUmVi97tX8LX9EVtyWp7i/f3sSUTWdLFmRYXjLiS0YT0Dr4aE23V0KT
us+uqZE+q118U7wGR8oPma936dOF+cIR14hMjctHrlVzlmq3gtYlqHetlSVV
72IpCWTSq/i1llRre5DvrdwlGP34PUtrU+cEBXwwJrcY+SAfb+D8QT3bm2Al
r8y4J9X8BDXOjZ/inGjts8YShNFYet9jcep6+lrr+ZPU/InUIzrL27dL/zGQ
L3apdPUf/3vkH5prEpz7j4D0DwNSPvBNIach+2eQ9S9Bir/6K0D5HMVs0/GZ
XxoogT/2Tv2C+EdlmoRkfBWo+HNACug2w0Kz/uRHNg5ljkjO+INP8vc94v7k
x0QSqvjEL+2Hnsk/806GAIzMFSZhmcyZ9ek/d0/6mWfyZwFZwD0DMsvvPH9Z
uuegAXuIAzG6GYbmjgjJ+6d/KujD/+lFaCMkMSw442deScBY/+KT8WkA3CGG
IbjzUy9muV9IJrDX//JM+Re3uBl5h1WqF8ExBf8MzVq5ufZJ1+25URk/90r5
hUfyf3slfxaUPTJMMTQoE6KFIvw9MGdW/Pa9dTeuX7z4D6/4f7LKPxSBcQQN
z4HPrwOJfQqI4VfqvRoEb0AZ/16dL1OtValT6eXufOybCnX3gV/6n31J9oAg
fBWQCcIHAkLiCcn+yDf5Bx5pv/JNY7Y3IZuNfOqX/jf/NBD+18Hpf/JLGRqa
C3X9uX/6//NM/E+vhL8HZY2CUgdmALX8T4/E3/ikDA3OphtlQKKf+qd96Jv+
Px5JH/ikfRyQZr+scM2muu6H932W5/3AL5vxi1NQ0UF1f+5L1F2oR/tlG1cV
H1WqXoTErnvPh1n3dOF6zbF6IIn/453yZQBpbCBDyP/7Xsn/4Z7woT85NdKY
syuFkePpgRICzfkkOBMyD7QU0mLXeKq39NGnQ/H1Bxl9jypCxrqWY8iMA+TX
8Byq0LKHsIevBSH/wjPp++4pf/RPg2xDJ/oiII0sxvRO/zQw9Z9BWUBvPw7I
hAr9d48UkDNkA1gV1ObfoZctzvkqIBXKPiwsb2SwAsIDm4PI/xaYRl1qf+2d
+COvJDrVw1CPFELxQnOAI0BI4J7A0EHOXwVl/MIn6b88k/7in039oqEj/N0/
c/Ti3KEBqX/0TxkenEu3yhwZnA1EA1rIR76p5FDCIMYRMQwqIuO3Xsk/AD7r
D7mF/JDwv/JK+C8YJUKyfuOTAB3/z/7pfw1KIxb2Xg5NUjqJnkOlVo1dqj8a
i155UqlrucJzjIPI4DAiXPFX38wfeSfOjS/K33V8f0NT8vaDY8Jy6K5H5UfP
GXgkfByQPoLMguaRU0hCsn7nnfJ9t8T3fZOhPZMjGsOz/x6Q9APPBBijoA2M
CIUAZNz7o1/GJ4HpMEbBsPkJcVAn1Tc8MBMY6A89E3/rmwpjIJDNT4OJNzXU
1F8CyQZcpBTh6rkp2QlGY13quj4dSp/eYSTa8ERrhFrj7MOrTVCbgp1CpWpc
cOmpbOi04PR23NB66fQ70po3qSL36pJhGTrrrs9y0JmKPtLWqWJxbZJv89K6
r6zO+tJ/XkvrDFWvci4vZ0Gz4b7rHtB4l9TYq5Vj8qse7YNi9DsflJks4rdn
qdYl1T75XgHyPVFr7zDSZS/TOn/IPSjVPmW20pJv8HpevR2fpUY2PbOkp6FT
vrBiPqhPwbWOnxrcP4xxdAwGvsaGpHs+GAVTrV5BV8YRxZV8IVPixox+ztsR
ItcoJN0omG4ToWD20GD2gWT1DSaesAxQC4k+HKpQb69BdmL5Z0DayLCNFWfb
dhysNQpIYfchJKvGskERNQQVN5yYNgzpWhiG8TGL9Xo236a7u0OcQGyZFEkG
oDgf+GRGrq8+13HrwtWu0+cvzV++9n1fZoqemfMkLT9MwW4OH6T4fUBW2p6z
x85cmrZY8UtforbRYlKl2iiIsJuRwbn/DCBEmBoF+LNkMm9qcTuRf6PJVJbM
RfsLEX4IdZvMJTQEZMUYN+kWl4aMlYERYDZXBMbhLVPdukg1gfANGZlAYMZS
wDr40ZA9c/Wh7HrJDzzT5mRU1DW1rcwo+aV7MoSk91nrKqm+zOGheR/5JM1J
33XyUvua3O3/65VKphF80oM3HFyZW/6BXyblj6SiyQnauczKFMYFl9kNg2kz
dD6BtKXPgzK/CEwfybA/spMP4Yx5hLwHZ8jIk98Hdc7w83cr1TkPI66jnmfp
tlFhPTMGI4LYszOMGHMhfI4IWTs8jOSc2UA1m7ogMh0zj3Y0RjJZ1NmJywxp
/z1b2jK9A35iJi7oti3GGn2EfBnBPEKfNVHXIGnebJthzQHMs7nD1T2O5CeM
jZC2AdrYqPWQLTIZQNKhA5KTNZjltMPVe6cYS2zyo88wJRasnv2LqwWZsV2q
o+mvL9E4qRyYpk5mD37pmQyM+Mdeif/mnQyMfsiipJlxxSqlamfNuV/6pQ0N
ylQ/lTmC2YmU7X3h7H47xDWCfKHjZy77dlb3ONo22LIwruwjQgi7pGekcu2N
jup0elNq311+W+XcX/V8J9J2wpcz5w1IvwhWnIlrUJwHcY3wo9LaVEy0bfok
bic6257OdiXfgPU0Vb8KF5N5y4h5rv5xvgpDlMmnWP4CLZG7+O40Yt8YqQYp
sw+DuBnrz6qoWVxwv2eJQW88z3W2K334oHydyrR5Kh9Bn+JS1Lqvmnw+2Rh4
bgNSeaDCRz4oxuuzD0r1O0E9CvqFVHitfFCQnNZ2rjUzenYNnf1FJj/iRt6H
S378lwrPL7LMaCOjbfbqvlQ2uPGwD0RYkKJJCMvaKOeiXkbk5DiimRMNfBiz
7IXqdXQwAa2POj6pmUI2NRsZ8nUVdW7pr0yKDLOgbI6nZzJpZf7aK/X/+iZ8
FpA1Ipw+SB4ZFsZuQDGcOWyC7ppOaQuwA0YUTJbIr+wG7xA5UZCggkLXwlP/
6pX0t5Bc6yX5H/im/MQnhaG0RG1TqysKugCQxvNxQPrPPJN/55c2IlxBrU7G
IeolHuFkheBQ+joGxqR+a5io12zy/ULF7ztO4L1trnq+CJh8ZpKtLYKyKCmg
uSIyD0mn6x9ZfT4oh5aFbcDEfZc5DSGI2EApESA/BWdQDVPtG0aqm/xKCxum
YAgyLaNiZJji78Fp7/ul/9g7eXh4nklYJq1B5vE8wuNCyAXa7xeBmb/yTgMh
U346Nizrrz5JHwakjFKHgeoYQRRmrsHkmXBbvIZRt+1cuikHpTzQQkhyRDtd
axyq0Co0nexbanzjVvew2rK2cyjEA5FgbodlWEzzIF1JbbIhB1aSUpAWzjCv
PNqw6eY55NmQdDorwlQfTV3BcSt6uj2EHBnMHMvInIo+NIRWCjsbozZKKrie
S3solTPTBXJoR1Z3JQVdp0lnCZg4SXugIwChseHcjoi5dO7FSL00chhxBiCH
rdNz56GN0aZC0gpdayjSq/XvCH3gg1Lh9UlCKn65dJmmzsqcdqsgpv0EMw01
PMvAbc3MNVtAJUjeetDAM5bWNbSKYSFsZySdLnQtU1nZQ0NzR4blMt1NQRsh
0/4VdKQlIcO4eZ7s4dB/QzPZnJNeTyprVEiPzkY/Zezm/BrpeanJ+osaqdc1
8CmhTikJGI0+VS81hGrts4KbWutdZiiQ34etX0jTq0fCVZA45/qn0ttsCEi3
/ONSfJCLSquQtfI7+ckZ+TxIzUVIXVIx65mijITl88+/I1iHxYXRX8eTz62U
POXzqbUsgn0Xua7NjSHIB8V4A+sH9Wxv3Ayb1HyLVGsXKz98f3txlmR6Db+T
8tez96G/61xkp498+pAuPzZ5Rqb1baVPMK0i7cPrqZcEk5n/Z+erGfWbHmEc
mkHoYXCuoZqRcaOBIU/ZMKHxBKexliNqQSA2tQziGaU2I6rHkFxD5iA2wgSJ
XpRDDvUDfgeqUVCGMVVEqXKlZoUML8ihLm2UGhBiGMzOhxuHsLYPukaJWKPC
qFZMPkeEZn3pn/FpYPrQ4Gy6ESgEMGaNjNmc7k0OHwdNODBraEiaIZmoJ9YN
VukiOl4OW8awjOGheZQcCWTI349dZlDl14vWliPlxyhf0SwnDVNbo0Joz1Kw
1gfG+RbqcfjiTFbt5w3jnL2PTgUwyr+C0nbGVMdEG0LUe8Y4mMUxI+aiJoks
oJlfB6eDZKj6yjVUapugrGQoELegHKgIKiuTsAxyJkVQNmExYXlcdRhSgzKb
/2xaLo7rMZkn5svhTC1AzJBhWnCxhw+/N4lXX8rLlqs4E94xH+J1TDr7NZGV
+mh78V7u/A5IC05ZG1d2Zu6FbSdUsJTa94wGobQvqO10oRmMXZWlY9w2nrQN
UF5ApwuoIY/a1mkwwlBCe5aHm6g/KVVnBm0SgC4ghf7OliiYeiBnq0VEI2Sn
Amh3lhGXPhom/5IatwV2Iq0OkDorXSZ+qYuOErSXcbXAMXFiMGUmyn7kleS8
etPs2MKPA9KMqbGesWWTAY0y62BqECeLeWFI5DLMTSawjT8sy5jyR6ZVMHXE
WNXJSEWnF9gZPGPpPS60yl9qyBLLkBup+MOI8HHNnQH4ktezLqTS1bMLa31W
z/BScjAW6R4yY3ivcqvzEqxz5EcoX7+vmAd5t2o9L36TEO/oxdMNelEvOtIS
tV55pVEqZn1S1KfsWi8+C9bK9A01rZM6K1Sqn3LBtPJxNh6JpS7y3FYwi8Ky
jLAc5INivO71g+JxmF874renuI1xnVEr3xcPCHy1lj+qax2X+C9xcVvS3uZ5
GzW8yvgj1R/1OR9Q/9j0SZ0vMTEpkHqtCPqg1Mpx/tWr3RU0S8Qqomrexz5I
lXA1U8hUb/uv4ObAyWFw4VQzyaP+n0as5S6LcXPizpXONWKdl5hxiVEmKWug
roCcGyox9zDqqNqElwnxG7E8FFLJGhaSw22kY8iswQFCQZkdEyCHO3aZ6Cqh
a8knYzpk9OfckcGs7yshFHwHPEZ5Y40moblqW6faxzWM05/VsuKZafhTHIYi
46DW1tIHlVhnhVIaTlVHQesyZC2/1FKTQ42z6v5LpEGJw7DgDJMwljdR9Z4w
lLAMhmXnGHHGx5Cevsk4FhJtnx5zxns8l2shhEWG5nKZYdRmRg0OZVuIsdrs
yFFpSnZYjxdoGCF5TLkyeScU0LMIWbdYkhlyR3JzUa1kXP7ivze5Z000z5fs
Vf8y4jtXswZl4qRN6iuctfWwtJ0R4Miw3KHMFjSGoZwNOteEtVazXZXWJusV
HJKt9vvN7WmEjDmPmvu5tkEFSK7wHl5JZ2DYyZYQtqfTaKmnK3l2cS5j5KUN
LJfvl6ieK8gbHsx2H2A0bNdT503PuuD6gtSUiJQqIi3/XozYUnxQpl+TBa1M
1VCxqIm8Qi1AMsSR/W9DFb/zTvmbf4ZxOGkAdHQF6kfHE6aa2OYNYyDDqUkn
4hx3qVmcFTiMe6GZzO5GeTAk0mYzgtc46RAKIUeE5fI7rPzYIn7RaJUh34m6
t/ZBviYgb/Xgay90NpsfXqfFRFCPWl++Mu2ES5S//6f86KHnwg2dYfS5ZMrS
KymJBS51R2OCS7+5bv4leEsa8pQx8X6b8vXCf9XKhJe/I868uLVIWeukCi4l
bZlOoZUP8nVCw/7gg8LwmjqwVnouFY/4Kf5+pHwVCPmgGG93PxkpPihf7zrV
Tin2p7PfSTVUcRujDYz/3pHpAvxL5x4CfeCDgpFQnx4nL0Bjao3i9XqZkhpz
Vgme27b84KxPPYov7sXH0RxjdkJJrbEwq8CYKejcHkOhWjlhJ6sZvZ3V/bht
aSl7ohZDxruMvNyJ/TGXO7OPXe6k3qmPcD3GU25YKG3DxAmKUZXz1MJnzBkh
VIys3ZBcnCWCLX4u82w6k2imCadmhGdR/1JjRlWj1plhIexuiiaha5mJ+ixq
9iLZI95fuZz1irDU4Bzxe0T8BtHaWvpAT/R5kJqN6HI/1o7AMwUaq5eqURuQ
IWt6yBsWrB4TwvLowiVmGWnPvtzGarJJKT/j4ssUlk1X7b1GFxgyRG8EUUeB
R7NHB7JMLZxTlXPJHkR0PV0QMbmqhcbOS1BrFy0F2VCIVn0wu5CKpsuklUu1
REPWMJrFLaHql4tfrZx6oE/9iuuFaTNqv+KwbK4K6II+2sIh8wzLy2Vt6yHp
zLPsLARbp4xPr7pms2nH5Cg8Z1Ln9xHapI3UVJ2dXQlXW3Y0zdk0/MhgBa1K
w1A6e8PO4VB6YqS2RRqxFsYspixM0uEaDqh08aPaDUDHVJhYHRVPWor7kXgk
lNeB5fuj1vo10nZynyAekzCOT+XRuRGGwdEqYM2vJsxm2pT00V8J3eBGFeq6
wJiDoUeQiS9mZoD1FGXs8sZqcz/rGB+awQ6tYZQu5dGRzVg9xcqyeL135pRp
zProCVLy4ZxJ+CF1LmnUP11jTbVEa/PQyI8uPihQErS2NP4ruw/i7RctQuul
JwfUJ89a+1ffYpMqu5QcZGpZTzmL73Djg04tUT4enRkQxN+rfiG4M5x3DrU+
stWnJRhKnyapfx1pnTdDPiiP/uWDAjud1LyccL0nz21Dqh4F462AnmidHDMJ
FS4s5VLXGtg4REtC/MwYaTsXxlhCW5Dng2K9QuCZoLPNi7sSJwQNUcsOUDJ+
pPqoLlwwrdVqrLkJgLxkjHhT7lrf47yBIpPTJ41Zww1rhSHfg3L45MtEM4Zh
4axiT818jINZprpm2QZALAj86ghn94cxYlYYMSY5Ggm3TpB1V+MSIs8SFYu1
UQIVZT1FGX2JBAtmvQcZZ9ccyuPYGIJZQtqjmatNh2rRqbU4nju0uhMp+C2E
+xR0Ln4LkekXWjuI1tqXae3in7hcsckxTrbE4ZCxtDILQrOofZAuNqQOoj37
Tqg3M+kZ24Ny1Isrc43VkwacCsqtSWTMGazwqcCpXYPNJOtKxyxCpF+CWa9I
hgHRpW2s6IxZFzhNqsKYwFhRhyl6+Kk6q2rJM4vvgnpsxPL9Qmsf4f7k16PU
HKxgNNCaECu6MNYMaqx2wjRmJZ/J1RptkDSqHvMQf8wJzzHhVbRxSI+HMGe7
VD+uMFHXFL8grO01rCekekImm3IWE/UeNWzmmRQ127zahTs4R73TFJ2LANqS
TpsWz7qay2VSXBEyHlxU/ka80z24KWid/ULANAUdRFBf4ovfqfmDgPQrg1i6
+S7NdA6EO62GdhlDteGb2dJHQfeKgWDDwolhnR12WAt4LjNM5dGZFuqfQIk2
NwFixG59zBQzmHWN6MktN6enloPMG9NI0xKns81LVZ+0fDR27ebS0poZqTZg
yFMb+FHJawKC/MuvszMMFU5BSOVTa2Mz1hxD+HqUvHzk4+eXhSuyEc81RT5j
XNVLeVOLn5J6N4nptpQkxZehNr1LrO9p7do6aaBWf0j+g4JxQ3vBJXZi5GeD
E7i85qZnvRuKtAKBHExk98LiciWWodQAqM9bTCarXB5YgfMkJvBLh0+/uA2U
D7a3X0U+SNE3PtgJn51XQJDXbrS3d1650d5RVVUxbWVBb2uQX1nidQQy+o9U
JDJ/yox13AimM2atTgX6X/Ijkv6XoebYJVhZ/+qX4K2hz/u0V+Xtz6yqy873
CuivS2st92EdQd+SlvFgGeCXvHz4HtfiGUjB20GscRmJ9vvtW2d8u/KR6mKs
oDSPmZORoZ6XeLpVQ8i9jK2/GqFAB+BrR4aaw5rMdHG/d/m33pz6ViKZp8Tq
Fl/OWqLSxUMH7CVfd/wRVeqdLnARlPkuI2c95SY1jukZz1tvqGIdntPTBK1R
fpzvW7pa3xT9ddHBR9AYhov2pKWX1sn5/s1Pf9WXuGsPwHwKKqLnu+YybXm9
XUp5M2SmOoeF5PgnbgI+2NnZSShhJ/JBgj7bB2+0X7ne2d7RfhW+dHR0HDhY
NWNFvnqTAX0vta1H+83hrPlGLvCrxM+/I0jrFS+tSciEN5a4xALRv5j9fr2Z
VAx73PB6kbH+rT59Cs5P8XWkLoi/D/l8Y/X1+i6prvrWM/YmC96H5s09os9T
b12e+gzyUmV5A+3hrctHZ/ZoDmWGTfFIMsAL9bZkqPXPN5+6TEiZPweUDKXy
2S/vTbp5lJS+9DYujnG8/YqQueT1zMF0ESLsk7hhdU5RR+eV9var7Z1XOpEP
9pUPXr1OPq91XO3sbAdmDVdVReXUFeul5n9k5v+lpnpeJZ4+xCCVmVe89IxT
//mc15FJmczLmDDeTAZ6FbJXe7r2TQ5vTDhvXtoD8NIq9j7E06tdC4w1/fH0
2f/wdRcZG4O8653UJTOu6l8RfRa+2L/l9UnG+BWO9fnuXr0VKSci/hItwVtD
PLDr6f8pqBH9m6v+r/i3qAzoUwqpLvOKPUj8uNgSJO+YKnX1anyQ6V9i39G3
VTXy6b7KeNi3mnrrl9RKzOGhuX7x62NzStqBwRAb4ZUb7cgHX2X9YEcH8RQF
ct0On5UHq0aFphl4JJDLPZ5c9Dv9k/uu3zXEXeMycItnv0g9IkhOkAG9U5QL
w0XY++KIywUl4grVh6vPGeib/Puc7tvJ/ytUkJao+NfbLdebufgl5b6L78h+
F7Rw7rtUor1q6uSmuL/3rxBE3ZPe6a/4JQurbViQk56g4L2Rg0b8OptE7+Pv
9SUTeZ/TpbUmvl5fKaQk9lpFp+vq9Xgl8XrSXoq3WrT+r7JXKNdrf2++7nHv
tebTXVLhGXBy9hD1XHlRqweWga4PSLxc+jmVt9VK9U5oiHuSgWesa3R+RGoB
pTPXr7URRoN8sE98sL39amd7B3Bq8oXYCK9WVVWtLalOLz48oK60rYf0vPnW
Ly5X8IV+5+eTu/kWi5Cx7cgbFkU/hnzdOcELL7xe5eIPgG89M3hpvQbg+/T1
vZX6UC7Ba1rrHbxex9W/zUBrbH1rD/zvA6oxvL6cDKhiar0UW6szig9vKK0q
2rmf2LWuE3/R3lvEkA+y13XggsTnllmG2X4V/gQ+ePf2nbddGgRCpVQq33YW
EAgEAvGOAN8pCMQ7AyVztTa3APHpbCdmQeIxeq0d+WBf/UUZ0yqzTWsnI9CK
qsp7966/7dIMIIjfIPhOQSAQegKHCwQC8Q4AhzLEm4GSgV5Bu5UtLS2ngfgA
i2G2lCHbYyIf7Ku/KPnSeQUuIsX2q1WHDj64ff9tlwaBQCD0AmopiHcJ2J4R
iHcG70x3fgMF6X0S3XAx9sFTnZTOoL8og/47j77i7p2ut10aBAKBQCAQCAQC
gdCO1tZW4IOvwnqQDyIfRCAQCAQCgUAgEN9FIB8UA/kgAoFAIBAIBAKBGAxA
PigG8kEEAoFAIBAIBAIxGIB8UAzkgwgEAoFAIBAIBGIwAPmgGMgHEQgEAoFA
IBAIxGAA8kExkA8iEAgEAoFAIBCIwQDkg2IgH0QgEAgEAoFAIBCDAcgHxUA+
iEAgEAgEAoFAIAYDkA+KgXwQgUAgEAgEAoFADAYgHxQD+SACgUAgEAgEAoEY
DEA+KAbyQQQCgUAgEAgEAjEYgHxQDOSDCAQCgUAgEAgEYjAA+aAYyAcRCAQC
gUAgEAjEYADyQTGQDyIQCAQCgUAgEIjBAOSDYiAfRCAQCAQCgUAgEIMByAfF
QD6IQCAQCAQCgUAgBgOQD4qBfBCBQCAQCAQCgUAMBiAfFAP5IAKBQCAQCAQC
gRgMQD4oBvJBBAKBQCAQCAQCMRiAfFAM5IMIBAKBQCAQCARiMAD5oBjIBxEI
BAKBQCAQCMRgAPJBMZAPIhAIBAKBQCAQiMEA5INiIB9EIBAIBAKBQCAQgwHI
B8VAPohAIBAIBAKBQCAGA5APioF8EIFAIBAIBAKBQAwGIB8UA/kgAoFAIBAI
BAKBGAxAPigG8kEEAoFAIBAIBAIxGIB8UAzkgwgEAoFAIBAIBGIwAPmgGMgH
EQgEAoFAIBAIxGAA8kExkA8iEAgEAoFAIBCIwQDkg2IgH0QgEAgEAoFAIBCD
AcgHxUA+iEAgEAgEAoFAIAYDkA+KgXwQgUAgEAgEAoFADAYgHxQD+SACgUAg
EAgEAoEYDEA+KAbyQQQCgUAgEAgEAjEYgHxQDOSDCAQCgUAgEAgEYjAA+aAY
yAcRCAQCgUAgEAjEYADyQTGQDyIQCAQCgUAgEIjBAOSDYiAfRCAQCAQCgUAg
EIMByAfFQD6IGPhQAvjfeX9KhX/teepJTKVkPl93Kt0qJZdQNz89JVNe5evP
w1sBLRktoM6wtN67eYG5xzVbRR9biJJtiqywNVPRvMF+sjXV+9pRqp96J2sV
gUAgEIi3BeSDYiAfRHwHoFQr8Gq9Wjsp7O6hRQIFXA8S2Re8ePFi+7aSpLT0
oqIi+N6PMQtye6W1LScvNy0988ihw4IAe3fvSctIX7du3YN796Ue/+5iP5Qu
LS0nJ6etpVUP2tutLng3IdAMeF94jyqZIL2EQKpN5y8oFArIXl3t8Z6ou3nc
U9k7Jnjo0KGMjAxFdtbF8xc4vvmOVCQCgUAgEAMDyAfFQD6I+E6AU6s5A42K
92e3pta8dUvRPNe5YSGhTRcvsfp5v+eHUfifP38+e+YswxEjnZ2d4Xt/J9JD
Yw9WVk0wMzUaOWr16tUqHjGBL96eXsNNjB2cHGF84z35jlDCwMBAw1EjxppO
qKqqUmlaisXQsCOrCZ8GB+TPJ/QpPz2SV6mKioqMxo0eOnpUenIKP8yzZ8/S
MzNcXV2hsu7ductZFQUxiLF8+XKTkSPGTRhftr1UbNNEIBAIBALx6kA+KAby
QcTAx9rsrKVRS2JjVtErBj5jV8OXuJWx8TGxa1atjo5ampudQwOfO3fO0tbO
1Np6xJixoeFhrzVjL168cHd3N7W0WrRoUf8OCwLnxqNHqp0mTTS3tklLSxOE
XBwWbmppMWOmy9WrV989+gA1a25pAWU/evQoe0u6iFsLN0WEL45dHRO3elXM
6pVrYmLjVsfAl/g1cYUbN9XW1vbSXqcdnPPqzrIdFja25ra263LzXqp6fHqB
zY02HW9tazNi3Ji0jHTekzr8P5MSEs2treycHPfs2q16BdKKQCAQCARCCsgH
xUA+iBj4mDV3ntHo0WY2NiPHjhsxbpzJ2LHwOWrceOPx44zHjzGZMPazr7+c
4jydrhQ7c+YM8EELOzuT0WNCwkJVr8fIQuOE7uPh4WFmZd3vfJCfCoDjgykp
KYIwwAfNrCydXWYAH1Rpmg77PT9vGFAEwgetrRwnOh07WqMzvG9g0FcjTEzt
bEdNmACNBNqM8Zgx8GXUuLEgIogEqqmyspIzEb5KxuBz5/ZSG1t7qJT8nFzK
BynZLCneNmrCOFt7O5Oxo1PSUnvSUrKcUSra5MQkKKz9RKe9u/ewCanQYRSB
QCAQiP4E8kExkA8iBj78/Pzs7OycnZ3d3Ny8GHh6enp5eMIXoGPw3dXVNTo6
mgRlVO51a/Nnz5wV4Od//uy517oIC7oPZGOChSUQjf5dPygAxwdTU3n8gkF4
aJiFlaWLiwvlgxTvjGlp6dKlptaWjpMn1VQfpY6XL6UDL49eZmVjPXX6NB8v
74iIiPDwcPgMCAhY5O42eeoUCxtrKztbkFVZWRkJ3QcBKXv+B1pXvmOnpa2N
mY3NWrVtmkr90aNHsXFroEYiIyNvdF7XvwVyfHDfrt09+ya9GxWJQCAQCMTA
APJBMZAPIgY+gA+Cnj99hvO1a9f492VsYeJFhf0OSJTywdfhL8olQb8AH3Sc
6GRpZZOemsb/FbA4LBxIhIAPvjOIjlpqaW3l6OhI+CADGaa7Ymk0iMjRadLJ
Ew2CvVxqa2uDgoLsAPaOzi4zbty6+YrrBwHlpWW2trbQMvNycgX7yZD/u7vZ
RYw8c6Q8TU9KSITC2jo6UH9RneERCAQCgUD0FsgHxUA+iBj48Avwt2BcIjs7
O/sWw2vSq6H7eLp7mFtYuS18LXyQA7UPcnxQyStReGgYt36w54F3hUZERUUB
24WyU/sgQMY+uGxpNLWvHTt2THN7Wfb/RW4e9g5OVlY2O3fu7LOIOMnvKC2z
tLc1tSN8UKmRTs95Ez27z+iRXPyaOOCD9jw+iEAgEAgEon+BfFAM5IOIgQ8/
H18ra9sZM2awW2jy1W5tmvbTh49u37l3//59FXPWAKfAP336uKur6+H9B5wn
HhCHbVuLQbFvbbrMRdnNrATrunVj/+4927eVwK/V1dXEHbTH8Y89woCzD86f
P5/eef78+eHDh8sYwFMqXmAVx+N4hx10XGs/WFlVvmNn2fbSiv0Hbt/q6gnK
PcXfTyYllR+bilk/aGFp7eLi0n5VbTzlHcD34ptvqw8eKt2+DeI/sG9/a3OL
fiLvSaPr5i0o0Z6d5aUl22Gs6EmFVy6aSRD47bt3vnn2nP2pWwkkDp7aUbId
8iC7co78AsLsCX/4CLGvqVSrVqwE8U6cNKXm6BFBimIsj15myZBHEJcgdlrd
mwrWA2E0tbaEL4KGwzWSWzduVlRUQKXv3F569NDhRw8eqoNpHlDRrYQAVna2
lrZ2+Tm5bBnUgKe67tx+/Pgh38WUX1jA8WO1UCnQwKABPH36FOSTrcgys7K0
c3Lcx9kHucyrc3ij8zqwxZIS0iyPHquhUuKXkS5SpI9cvtQETau0eBtU37Gj
Nd98841YaO/KzAECgUAgEHoB+aAYyAcRAx9+fn5AhabPcG5p0YvOJMYnOE2c
PHfu3HNnT/P99IqLtto42Hv7+wGxuHv/XmhwiJWDnbWtjdH4caCKs3t9MPp0
ZmrajJkuFjbWpuZmZuaW1vYO8xcsAqoioGlAEj3dPSZYWPr6+sKfEP/8+Qtt
bO3NrKyt7OztHR0WLlzIt/X0HJiuUu3dvy88PHzmzJk2drbAUMxtrW3tyRrJ
3NxcLozAX1SKD0JyEM/VtiuCJEpLSyEDdvaOY83N4YJg053JorbTp08Ls8SP
Uf0/0MCoqKjZs2fbOjoA5bSyITmcMm1qUlLSS5WQsd68edPLywu4WFVFJdyB
Uru7e4LcgC6BKEDsixYsPH/+vHZDrVK1o7hk/sIFEMzS1sbU0gIecXPzqKmp
gfJCth2dJh2rqeYdL6gdK5YtN7ewgsBCPqgmVls2bgLCBUXZvKlQIypGXPcf
PoiJiQFJQjEhD8AcHZwc58x1TU1N1Zrqbmb9oIWNbZ6aD9I4X3S/hJqdOHlS
cHDg48ePxXKu3FsBwoF80sJCC1wwbz6w9cKNm4iQxf6ianNjcmLS9JkuhNIy
zRIa2KJFi8p371KJ6vHOnTsrl6+YNmUqlHe0hek4CzOgmQsWLcwvWEe45zu0
6RACgUAgEL0C8kExkA8iBj4Cff0srWyofZBqsHRjfw4CtTZqSeSo0WNBza47
foxv1VmXmzds7Mg5c+YAr/T19hk2epSVtS0o/6MtzA9VHWQiUj1++MjPx3ec
mekEM1NQ6YFPuc6bC2HGm04A1Z0la+oUv/nmGy8PYD12Cxe6AQUYZ2ExcuwY
eMrZZQbo6kAMgdeYWlsXFxfzs3rhwgVPT096HsF4czPgUDNnzwKeBXeAC4wx
m5CZpRAcIFh9+AgEA+oh5oPhoWGUD167cpWft/UbNo23tAQeB5g3bx6QtWnT
Z4w1NRs13szOzq6xsVEgZH5yQO5CQkIg2Kgxo8eaToCyzJw1Z+r0aZBDR3sH
uLNy5coe8qi2W02bNm302DF5eXmbNm0eM8HUaNxYB8eJkyZNsbaxmzJlmqml
FWTyxo0bgqM04DM1IQVEBzUBbMiBkYaT0yTjMWPs7e3nznGdPN0Z2D1nH5Sh
MMvU6wcpHxQyXaUqLCyMHOjgYF9XV6dhWVaq2traoKLNLMwtLS2BobvMmjl9
hrOFjbW5pcUEC3MfL2/G7qnBgql9ECqFPeuEWzmoUrq7uxuPGj1r1qwHDx4I
Mrl2XT6ZLrAmD0KdQkLwCc0Gyu7q6gpCBhLK7i/KS+vWrVs+Pj5AA+GaNGUy
MDsIbGNjY2pqCiXaULCen4F7d+5CAKgmIIMQITS2BQsI1x47ftyIUSOXLFnC
EwoCgUAgEIMLyAfFQD6IGPig9kEgWdevX1eqN8+klJDbN4ZPE1asWAHsY/LU
KSfqj/OJ1eYNGy2sLOfPXwjkaOT4sa5z5xcWbjlYWbW9qAT0bRomODBorLm5
hZ2dr79fzeEjjx48BAqzq2wHqN+m1paWtjb19fVchHT9oP1Ep2nTnIE6TZ8+
PSsrq/543eVLTbvLdwGvtLUlOr/jRKempiYue/CdkNAx44A1rM3Nq605BlTu
1MnG2NUxTsCgJk4ERtByuZkGpmlRPihjH9TwF1WpOjo6pkydDmwFONqmDRvv
370HZOHs2bPpmRlwMyAg4O7duyq65wkPDNNWUuvSNJcZhiNM5i2Yr8jIBHoF
gyd5PDUNsjdp0iRzW2v+ARCQSeCDwKccJ08CEjTW3NTOyTEpIRHCHD9WCyTa
acrkqVOnApfJzs7mlwuwfv36Eebjp0wh+39GRiwBabS1tNbUHktMTHR0dAQB
Tp85a+KkKcdqqmX3FiVYHr0MGBCw18uXLwvsZU+fPoXMw0/A9P0C/Ck95AgR
EKg5c+ZA5cK1cOHCsu2lrc0tTRcvAc+aPtMFaOl4c4vFYRHU15eLeWfZDsoH
yfpBZc++MfC/r6//BAtLNze3hw8fqtQ7/8CXvXv3AuWcOHEyJAQt7VDVQSgs
kNPM9IyJkydZWVnNmOkCrWXPrt1sXTDN+0X3Sx8/33EWZkD9ggICjx+tefzw
0c3rN0pKSoBOEhdTOzt4N3EZSEtLm2Bm6uDg4O/rd/JUo5IpYOW+/RAJMPry
8nJ5MSIQCAQC8Q4D+aAYyAcRAx8cH2xpaXkEePAQLlCJ6ZeH9x88f/qMhqRa
98qVK0EbnzRlcsOJOr59cFPBehtb++nTZ4BqvWjRohs3bnGeeFRfLy7aOsHC
3NLKJjQ0nK7y44gDUIwp06aON52wNGIJFyFdP2jr6ODkNAn4Y3NzM998+fz5
cw8PD1DLgQKsiY/j5xA0+YTEZO6ICm4dZEREhA1zJgLrgqgOX1N9FPiCDB8E
HsHZBwHFxcUWltaW1lY5OTk9STBRnTlzpqurS8VjZBoGOzW/PnigInblqidP
nhAO1t3DgxLjE6wc7CDmmJgYfh0BH5w3bx7wPmAcs2fPPnWigZ/L/Px8YEDw
U2BgYE9ySmL2AqmSrVNtbZITk/g/wQVECWi4/cRJThMnU39RmUYCiI6OBlI5
eeqUjLT0HaVlZO1nyXao9LSkZA8vT0gCmLunp2fHlasatkGlMiUlxczMzM7B
HvgvEQ7v50sXLk6d4QI0fbylJdQa15zgKbKfDOMvytoHeesM/fwCgEJCG4PW
ylu++hREBBQSqjhqSaS66amoo/KFc+chPDBWup8MdV2mz25cvwGaEPC+iMgl
nHCod/PZ8+egnQP7Ay7MZcDX2weascuc2cwSWnWuVMqXym6+qzACgUAgEIMQ
yAfFQD6IGPjw9/UjxwQw5w8Cw4JPdx5cXFx27drFD79ixQqgSCwfZED16g0b
NoD2PnnKNCAgV1rbNA4CgOvbFwvdFpmRs/xmPbhzV8VZkNTnjCclJQEfnDVr
DuVTKsZflDmP3tLVdd7LlzzrlZLlmCdOnLB3cALC6Dpvrth1UO1f2LPDzPnz
54GVANsCvsAPCXywV/bBgoICwgetbIqKimga7KXUIFVafS81TkZQMyMu5J07
d6ZOnWpubeXn5c2ZF6l9cO7cuVY21vDZdfMWWy715jz37twFkmhlZw+ECGgR
V4Dc3FzIp729o4+Pz0u+TNRUKGbValNLsiSw5ugRah+U8RddGb2M7DvkMguI
JxAiYHBwjbYwHWM2AVjY5MmTZ82adbrxFMvp1Pu0QG1S/14HJ0eQv0pt4+Ny
U7a9lK6CBC7J97Hcpc0+CHjZrfL3DwQ+yNkHKUpLtltaWgInnT93npIrKv1k
spSVlWVuaQHZYO2DDJ49e7ZgoRtIaebMmUDP+ZZxWoTY2NixphOAOD9++IjG
4+bhDsWfM9eVFRc3syGq93fmnEoEAoFAIPQE8kExkA8iBj78/f3tnCaC0j7B
zHTMhPFwjTYdD0r+KPMJoyaM+3zoV3kF65Sc6qtUrVzO+otyfJBi/fr1xCfQ
2iolKZne6e7hH6qG+hNOTk6gxq/NzWN/VPUwO/i/vr7e1s7Bxsmp+vARqngT
f1FPch49sEKV2rim5H359uULslTQ3m7i5Elnz57VXjy1Rg5EqbGxkS5b8/Pz
4wc5eqRah31wxgy+fbC6uhrIIDALYGGVByrYu91Kjt/1RKJJDfjb0fB+7aZC
ePbsSWtzCxANoJqe7h5AhzlPyOsdncAEoYIiIyM5ZsdyFgbkYA5rG6AtD+7d
58gm1CxQLaiU3Xv38Hez4R5ctjQaSqenfRACAx+c7uwyZ9ZsV4J581znu86e
M2vObGgMppYWwKnhp8T4BI7jk21Cy8rhKWt7h5CQEJWaBLNCYCT2zYtvFyxY
YGfnMGnSpAsXLnAsGPighn2Qt34QymVqTmzQrL8oc39pZJS1tTUIAdohJWhK
td2WBkhOTKLnD+7bs5df9daOjqZmFsDxe7xS2X+kXg4fPGRmZek40amu9jj9
NSwkFHgl3IlaEnmn67a80BAIBAKBGFRAPigG8kHEwAdo11Z29tOnT4+Li8vK
yspIS+df8WviiNGHB+CDZuaWhA821NM7VOMuXEeOGwB9e//efZyBRqnepWRL
4WbQq4EXZGZmNjacPFF/vL6utuF4bV1dbd3xY6dO1G/eVOjo6GhlZ7t3zy7K
Vl68eOHu7g6EhT2PXsi2iEkuKjLCwsoSmGbF/gP8zNAAHe1Xd5XvSEpKCg8P
d3WdPXXqZGfnaXYO9gEBAfyI5M+bEPNBSGJJ5NIxZma29naQ59CQoNLSErpm
UMpOxI+WH6arq2v//r0ZKamREUvmznedMm0yVAQwTU9vL+78As4+CHyQsiqO
WrI0U6Xy9vaGfM6bN+/hfdZOev/uPcZ/0t7FxfnWzes9RkweoqOWAuGi9kF9
+CDUL/CgQ1UHHz9+/OjRo6ePnzx68PDenbu1NcfSU9NASmY2ViPNxhNnV7V5
LjNdARkD2a5bt44jWQI5RC9fRnb7sbcjLqNqMZWXllH74LrcPP7SQiCM/r5+
wAfdFhJ/URoV2YrW05OsJ50y9fTpRuq/Kcg/8EFzzfPoVdRZ1MrawXFiTk4O
NMJ6pjVC46yrq6uvPw53NhWsJw639rYV0KqZDJw80UC2hLWxphvjpKamMh1E
h/QQCAQCgRgMQD4oBvJBxMAHaNegEjs7Oz9/zroayru5Ufsg31+UYuOGAlD7
gV3sLNsheAQizMvJBW0c9OeJjk7mtmQHSEtrK7LDJPMJl52dHdC6cRZmlA+q
eP6iCxcu5IaFHh7BkINlK6LNbW2B4pVtL6U36a+nTjYui4yaMdNltIX5VyNH
jBg3BrT66TOc4bKzdwwKCORnj6wfnDQFcgK6vcDAx+wvauniorF+UMV07ajo
pUBhJlhYTiBOmQ5z5romJCSwbqWavrKcEPi2ubaW1lWrVrnMcQVhDh010nj8
OCgFkEFIC3Lo5eXFP8/uxvUO13lzTc0swkJCtVZKDx9Uu1C2NrdAVMCngCg9
e0ZWgPYwMbXhjKF4Ntz+ovL1Hh1NjIkgxoaGeg1zpzrOc2fOzpzhAg3A1M72
8MFD9Jf4mFioXEtbm9LibZqOoj1Os7nZOUwbsC0oKGC3OWXOo7e2t4ObaoMy
G/6lstvf33883z7IHM7I+tPOn3f7tnabHbUP2nH7izIPZqZnAK+b5jLTgUwI
0KZoSxskBIYIrRzsHO0dJlhZ7N3bY1WsqqpymTPblGyOamluYTVp8tTAwGDI
sKbbaE9rRCAQCARikAD5oBjIBxEDH8AHQQeeMWNGW1uLShcZVPWJDwKyMhWg
Y09znj53juuCRQvnL1zAB/wJpM99kdvM2bOOHDpMH6HnD4LW7ebm1sMHNbO3
fDk5BMHGyYGf6MaNG4G2jJowDlgDPJscnwC/Xutob6g/MXWGM+j/gf499kGI
kOwvOnEy0IGUlBTODkV/YuyDQj7IBQBeEBERMW36DOAOZhbADMg2O6U7yvg0
QIs0u5W79+6ZOHHiuAnj4QIiuSYmtqR4W0tLS9vl5llzXSEnvp595IPcOsrz
588Du7S0tfPx8REflU5zFR21FKqMnj+oc39R9ryJiU5Hqw/zhaBUe7XCB5A+
EC+wpLjYNfTX1StXQb1b2dlu31YiNpjS9Y8F+evI/ICtHXH1VPNBbn9R1l9U
/SA84ufnx/FBGlVXV9fs2bNt7GyhIXGMWNBUkhISLXn2QfprSlIyZNjZ2QWa
JTQV2hQp3BeQVjpv0UK4P2vWrNrqo+yxlUxsjx8+ysnK9vDwsndwgoqHC8hj
UEAwZaMsWe7W1ZcQCAQCgXi3gHxQDOSDiIEP4INkf1Fn59bWZn3C980+uG5t
PhAroAabNmyEOy9fviQufS9fAukjrqHMtv8Eyh4rFbAYygepfZCuR+PWG3L+
nEBSnCZNrKk+SpX1A/v2k6MrrK2mTZtWWFj47MlTjpLduHEDblpYWgvsg8Rf
dOJkyJ7YPgj8i/JB/n4yvIKRq7m5OTs7e+58ZnNLZr8a7rQIDU9RtTmsseEk
DTZ56pTctXn3791R78Hy8vGjB66urpCilH0wNDhEa6WI/UU7OzshKuBT8+fP
JxRJ28LGpZFRlA/q4y+6PHoZsB4QNeWDggJSMnnmZCPwXIgTYqb3CQuztQOG
u6Vws0Z0PG5FdlW1sgE+BUSey4bwvAkuRWZH3AkW5px9UMVsCwOszdrWZtac
2R3tGpZcLpPUX1RgHwROB0nY2ttt21oMWSKNUNlNW2Z3d/e3L190q1smlzp/
xoAuMIyKinJwcoRrgql5WFAwJa3ywkQgEAgE4p0E8kExkA8iBj4oHwTK09Jy
WfV67IMQIyjhNrb2wNRSk1PEyrJSW7r0/EHgg3T9ILehjUrt+vjo0aO5c+fa
2jlMnT6ttbmF6OHM4jIgC8DvyE4v/A1MlKrzTZeIyczKhrMPKrnzBydOBq5K
8tat5O7z7YNXr17ldnfhP8vtMAncJDw83N7RAUgHsDZ+YMGX6Kil483NIOSm
zYXMzZfqxXbdXbduAO+zsLLkrx9UMXwQ+KY8H4RK4fggJPT8+XOQGwgHWOe5
c+c4Hs3PD6F4DB88qicftGbsgySwlhqEGOpqjzs6OgIz5fgg0H+yF6utXWxs
LH+bUN5ThN8BJQOBVFdX0/tQj+U7dgIfhBT59kGV2l90nJkp318UADeBD9o5
2FcfOSRuS3AnJSlZwAdVjFcqcRC1skxPT9fO4TRcYjXmIvhLIKsqKqfPcAZJ
Qh6ogRsJIQKBQCAGIZAPioF8EDHwQf1FnZ2dqb+oTvTNX/Tu7TvOM2aChg/c
6tGDh4KlZFoB3cfDjeztT04iEEOpKi0ttbGzpS6R3S9ewp27d+/OnDkT1PuA
gCDNlYbkA7gS5YNa7YNAFtJT0zSsP8z6QSCkxF/0GrEPypNlYDFk1xcLc3d3
9x62qAmgM15eXvT4vJ7cKVmGq3zZPc91LqTo4+XdWz4ILAxS52QLn8BP6TpN
si5PW8ahKidYWELZ9eWDjH2wWm0f1CgdQ/WSEhKtmBMeCbNmAFQUHnFwcpw1
a9aTJ080N9xhSPr588Ax7ewd58yZQ51dabQ71fuLCg6LBEH5+voK7IOAmJgY
uuIvISFBa/4z0zPEfPBG5/VpztOhFc2aM5s9qkNzDoEtmjpp7lMsgcLCQsit
mZXlhoL1uHIQgUAgEIMTyAfFQD6IGPjg9pMBPqjTOKjqPR/k/CRXrFhham4G
undERETPr7z/BNa3Fy9eeHmQg85nzJhBzXP8X4H4uLq62jqSvT4KN26iN+/f
vTdz9ix4xMOt5zA7jhhmZ2c7OTnZ2NoDH+THxq0fzMpUCHJC95OBOPm7lAAN
Kd+tcSYjF37+/PlAVSDb3LkJfACVgIva8iDzPYxPbfQsLto6afJUWzsHoMB9
8xcFsXA3i4uLLS2tgY4BR75//76gcqtrjgI7dpw8Rc/zJoAPWlhaOzo6nj51
khWo+gwI+qW8tMxh0kRIzsbB/uSJBu7BwMBAsjGLjXXMmliNGBm7KrHr2duN
NzdLTEzkS3IHs78okPeN6zfwc07Pm+DvJ0OfqqiosLa1mTh50uTJky9fvizI
/IULF+bOcbUH4qnJByEPUdFLzS0tLG3tli1fyZVFqebpXE5V6jt1NcfOnDqt
4jVsmqvt20rG21hDaynavKWHVCItRCAQCMRgAvJBMZAPIgY+/Hx86X4y3PrB
17G/KHxeaW0DAgJKPlzBwcHnz55j1W6l6uHde1u2bAkICrx14yb3FBAiIFZA
Mezs7KZOc95YuIkjZfX19R4eHuRweVu7eQvmc4ewf/vyBdwHPujoOFGRkUkj
B10dFPjIiCWjJoyD2BwcJwb4+fPzdvjgIbhpaW21JiZWYB8MCQqGQk2ZNvXa
tWv0/qNHjyIil4waNzYyMhKGLCYKNrexcWscnBzHmZnGro6REeDisHBTSwvI
/OrVq+m6SIi5tbktJiZmnIUZMFygVH3YXxQqZe7cuQ/u3efKBVmdPdsV2Jmt
vR2wp9raWsJSlap79+6tXZdPXFvNzae5zOT2F5XJs0rNBydOnLirfEf71Wtt
bW3w2dzcfP78+bKdOyLClwDVcnBwGGdmHh8fz38QpASFhWzY2NnCT11dXVSS
TU1NIAorZvdRaH63bt3q2bZUqdq2tZhs8mllQ+qRB44PLly4kJ43wd7v7vbw
8oRKhCqYM2fOwYMHab08fvx4c9GWyVOmWZhBYWcI+aBK1XK5GSikja09XOHh
EZcuXOSa5f2794CNQrO8d+cuk4byRO1xYOsghE2bNhGKrSZ8p042AsGHGIBy
Xjx/QSnYWxaBQCAQiMEB5INiIB9EDHwAOQLKw+eD8uijfZB8Ux05dNjGycEU
1HwrkmJE+OIVy5ZHRUUBWzGzsvx86NCUlDTuQbp+EBR4V9d5Vta2YyaMnzdv
XtSSyODAoClTpgDHAbIwcdKUxsZG/uK4os1bRplPmDRpChArX1/fZUujw0PD
IJjhiJGQipubG0QlsA+eqKu3d3ACFjZ96rSlkVEcuwQsWRxhZmU9eeqU2bNn
79hRCpQAeJCzywzIDFAS4IlAbBPi4uPXxJHz7+ztzC0tJk2b2tbSKik+9Y43
wEyBkQHhXbp0KRRq6vRphiNMgNBBkW1tbT093fuwvyhQEuovypWtoqIK2BYk
BBewHhAd8GJgUsBngaMB65w83Rm4sJ58kBzN4Dx91swZM9WASoS6sLa1GW9u
AWUHph8dvZwJzotNqdpeVmrOOHPa2NhBJUIewsPD4XGgb1QUx4/VqsPSp5Ug
JXhkytTpUCnAIrn3glb7oIppZidPNUIxbZiliEDZoGGDYN3d3SeYmkPLBMFO
cZ4OtHS/Jh8EHDhwwM7eEcKQjZVcZixZsoQ0yyWR8xcugGb5D8OvczIVNHOZ
WQoTqHpLaHrWC+cvWLE0Oj05ZdmyZdTpdNx408T4BJXEelgEAoFAIN55IB8U
A/kgYuAD9HMTExMbGxuxl51WhIaGDjUyNLW0qK05puK2eAFVOSd7uInx6LFj
tmwtUkrbRurr6+nR4WPNLE3GjqXXqHHjgZEFBQVxh02omO7jMmvmF199mZ6e
XrH/wDSXGcBiTEaPGT1+wgQLopGDug5jjjiJuLg4S0tLU2vrURMmmIwdbTR6
pLW9XfTyZY8ePVgWHfX3zz+DB/nhISHgDqMmjBtrbmo0csTh6iOcF2vlgYoJ
VhbAWb4Y+rW7pwe9f7XtCpCjSdOmQzYg8yPGjYML0gKaPGf+AtZoqAnBcsLc
3FxyRIWVJfBKw3Fjh48cCcUB3tp181ZqaupnX34xffbsZ988V9upVB3XO4GA
fz1sqIeXtqWUKtWcOXMMjY2AmnHnTXDYt2/f9BnOwBbhAjmDAEGMU2c4H6ys
qq2thfoabzrh0KFDEtXVg8CgEONRo63s7CEeYH9QdvpJTtmYNAn4MlQf/5A+
AWAknDVrlpWV1ShzM6NxRGhjTScAkfTw8KCMvkdQzPdHjx4tcneDvI00MwUp
nT17lsoCArgumP9PI8Pp06ffv39fIOTjx4/Pdp1jYUkKO9rU1HjMmBFjxk6e
Mq1s545zly6CwEeMGgnklF2tyaNsIAq6QykUCuoUcgjXyPFjgasGBAXW1LAb
xnZ3d+/ZtRs4JrBOaIcQv/H4cRBytIW5vb19bKymQywCgUAgEIMMyAfFQD6I
GPiorKzcsmVLWVmZ1MFtAgANLNyyedv2EuLbyQVUqi6ev1C0ecu2rcWtzS2c
x52Gns/7cuDAgbSU1IjwxcHBwdHR0Xl5eXW1x7ntOqiF66Wye//+/QUFBTC2
wA+3b3VtKFgfFRUFvGP1ylXkAHpt8VNUVFTErFodHBi0OCw8OzubcDQlu/gr
v2AdcSZUaVBWKEv8mjhghSEhIRzHpNEf2LcfKLC3t/fatWv595suXtq0YSNJ
JTgYAsDjkKWX374QZ0a4twzzP1CM+Pj4wOAgoIHpqWkc4zh/9lzh+g1V+w8A
9eAeefLkSXl5eWFh4eHDWs56oKvn4FegY1rGTyURHWQ1OmppYGDgkiVLQIx3
um6rupW3b98uKioqKSm5deuWTufG40droH53lJbBtbNsB1zwZfu2EshYQ0PD
3bt3xbUswOPHj7dv374mJi4kKDQsJDQxPmHfnr38dAWCunbt2qqY1VApkRFL
2trauDBVFZWFGzcBz6WFFaT19PETaIQrl6+A2l+yOCIvJ5eYa5kgpaWlW7du
vXr1qkZWeYLav3dfSlLyksWRkMOlS5euzc1rqD8hXIjKHHpSeaAiIyMjMiIK
Qi5bEp2TqairqxPXiw6ZIhAIBALxbgH5oBjIBxHfCfRZgxXsMMldOiPkDo9g
AnQreRcN0GPBEfEFmZg1CIWaLXJruSBOzh2RzyX5+RHkX1AuzcS0iUIitzpv
ClPo1siPVB4ER2BoTUL8J5fVXlZ3N3NmfTe9eN91p65RL92iDItFy4+kW9QG
lD2RaCtCt7ZMdkvWozgrusQuTFezpYkLjkAgEAjEIAHyQTGQDyK+E+ib1srt
/sHnJNxffD1aCymQSLcnKj1IpVSu5G9KRSvQ+jnSxLFIDQOfRI60Ri64KU5X
HIMwRek4pTKg9b5O8igDKgelfpHwG4Wg9jWIORdAmkeLhS14XApSudWa4Z7w
mpfGyfJiPi7ii/rUEQKBQCAQ7yqQD4qBfBDx3UIPm5NWZTlTGl8tlzO5yHKx
HpuRWrHm+KCAIwgtMt18C6P25Hr+lLUNyXAorT8IaIIMb5UxGMmwSz15hP5M
RyMh9e9cEfSnLfKilrmvxd4nYZ0USqyX0wI9dl7+I5oWRvnc6rTxSf2J7A+B
QCAQCOSDYiAfRHyH0AvThoZFRAvJknEalIqctTaKH+HxOTUD1e2mKBW5lkAi
31G9IpROSO4ZTR6k/kLdGiUMlL1NRQ5CuQnYk86Ye2X80pMoSdN07SnqtE4q
Nc2CPVWvd4YJuqUmA7RkVd7+i0AgEAjE4AHyQTGQDyK+i+i1Qss7wrtbxhIj
iFzaLiY0BfKXE+oBziaop62TOzteS0htZixJPqs3L9AW50s9Q+qTE613tGdP
hoxJpqrir+CTyYBO/qjTNqeSyJ1S1+M9+dSVPY1PbfxUS7TSBkc0FyIQCARi
MAP5oBjIBxHvHrRq2b2yHMmE4bNFTkUXB9CTo8kEUPI4pj6USJ7r6VN8qVTk
iY/W1KWSlktd/CDvp15JQCVdC68FWs2XcsLq+V+pebMfM4x0D4FAIBAIMZAP
ioF8EIF4N9BbwisIKbYeCm72LSevEkafGN6ktYtvIe1VGXUydL0iFPwubf3s
L/S7SHtnPe+/zLzbXrIDp1wyQ1AfvAgQCATiNQH5oBjIBxGIwYne2iv7N/JX
T+I7gf6Vw9ty9dTfpNuHSPR55J1vJ73FQJOMPkywX1rRYAYKCoHoLyAfFAP5
IALxDqC3qoK8xURq/dpA82Z88wpSH9yA31hOXncqr25l64PZur/wTurS70yh
3pmCvEm821ZvBOK1AvmgGMgHEYh3A73yF5UKrM8cft+4p9SzfdZn3ry/aG8T
1dNQon9lvUX+K19x/etU3LMEs1+dit8xzXmgmQgp5Bv5wMzzdxT9O0GHQAwq
IB8UA/kgAoGQUd76sJhLJ9n8jqox8iruq0eoT7A3KTpxAftM5zndVU+h9Xpx
ZW9ie5fA7Tw8EKCPnN9WY35n8E5ObiAQbxjIB8VAPohAvAPorZLQW/ug/gHk
n3pNaswb0456NScvLnVf5aBx2ojUwR9vC32zb+r5VH+ZCN9JDJwJll4xQeUA
yPB3FwOn0hGI7y6QD4qBfBCBeDfwKpSQoFtDzZB15+uDv2j3/8/eWzg5sit5
o//ii/hexLd77z1n5kyTmZnbdjOjm5mZcZqZmZm53ejutl1VTwWqKnefu+/u
fhsbc96rjBm3XSClUikpf8qURKOY/8b57f/haECyIPBgiP/8oYjovyrhL8Ty
ASFowM//Wfpvce78Cy8ijDb+1/IIzO7/a5ZzYGl+BYfRv9ZpgLbjJzUY/TXY
/osSJzSOOPo/JA4PfiUOD3LE0V+daOMA8XuPDvevrq6w/5QhjWKLC3O9PV07
2wf/wVPX19egC/0v9X4IiviOjw5AClSG/x32zOXl5fHxMRkv9z9lIOGodmZq
ure39/T0HGb5n0NnbLb/RXLf3x4eHr6/45J/97wd7O8+PTz+pzL9L9PHx8fe
3t7j4+fsLi4uTk9P/7Op3d3dgYL8v1bWm+cFL+PTE4b90zMx/0Wi8/L7/Scn
J0D4/weJ/TKEYjc3N0dHR0CLfh1gQIv6/PwcaPiX+zgY3NxY6+nuXN3c8SMB
1coBnH+FaBD98vR8sLf/+vqK/XdMmHDE0f8PicODX4nDgxz9OgSMbWJ08xGf
wPZGPXeX68sLAK1MT09vbu14fRjLj0V9gQMi8RYKzA4/aaLDROiHAkwQKi/y
OnOT+sPOh22SUs+Q3xD4EJ4p26DxwcdYOaJkqvgVlJ0q9YAPC/hJZYH71PDn
/NRPinPS3UZky/Kj4A+9HBs0wqSC5s+CDTisjuSB9nP5u2qK+QIJX8jLLKpj
M0Dwg1Dlw7DK3CSRwnJ1906+jlJ507jGxyoywiop/sDb2ZZeIchv6GIECDlD
AwSFi+5ofTHSYWlq6WfVI0u2pKRRrCDeprRHPXkRWOmYn0mVnTglSZSWEkaL
zcd6gSUi4kUk4CqpJC+V2Yk8oSxMJG3u+PmzpSIqPvX46plyfSKUCwSF7i2U
UhOUkiSRXkGcWemMe/Oh9F12vTBcsfyPbVVZfJHx4PgRXNqZHhTzBb1jC3Qx
8bJTBYR1ypYD5Yxhyxlh3ab/IswVlM4dudqZlymkraPzgeb7R3qU1hSd7sWY
1FDo92GJDWESJKjaFSfXWdzvuHwm+lodFvvY3CZ8CNcf8vv51rhcIW4fWybq
C/mkMLD6YP2gVAP8lBfDCEo0mZcLs16SkN34SbZQxwJkEqhy7FbspwVOps5q
AkyfQyfFJEv2Q5BDhKx5tnigmjGOM1qqMC82T+1lqUKD9eodYRod6xnoi6df
QT6XCEqV7O389HVaMij7YR+7LyR7Zlh2DAt8HsV8BYnh+qhkH1NWP9n7DbZV
8URinoCf4Cr2+f8UxyAsXcXzYVo0RIzkXxajQGfYaSGMzL2evZ3d8+s7DGHH
V+Ncvzze7mxtfyB0ATH6ld3NjYdnLyUcGASAfDxsr69cPb5Q2aJkE/V96Tf8
Bwd7J6fn8DrT3Pxvj9vbu/evUJkDKgtFqez8n4cMlLnL7plnBhpD+bLZpTPq
CqNdRFEhk0xXTF8ED7w9LizMnZxesgYO3/XJ3sLyxpufzpZpUoCr9dmZ9ta2
7t6ew7ObwL6dI47+qsThwa/E4UGOfiFCSfxBEj7urE72KKQCpVan1WtEMrla
b6pp7sQCDDaEGbsxZigcaqtt6BqlzbNPBgM9ztPmH3ssZg+mjIHMAD4mQcZ2
QqENj/qpcR6FaTAGM507ba3RFgl7fGWZatCkgOn4UCZZ9sPQYHg6MmpFKXkN
FDqg2aYNE5ZRQX6+Xu3ppLwoV8XpycH9wx1tpqKYt6cZCHsMlgutzE0Qyq04
HmRxToWBMXLAAVcghzg9nqxrxKF5DT3si0TBfKRtjLJEujze9Y/fvsW5Khmz
GPHTmIE2F4viwwEefPBhjN2FUPV3fbRcWlxycPVMVwTMLwB4kuSHoiaT9T1d
1RYXTW7sU7XJEtjJ+rgwLDi7suXq9PLt/iolWv+/w1Rru7dYQEXj1cRUG+Jl
qxKQak60QRmZ8O5nMwNNLAi0oSxIQxprLs/gCQ04HkTQzYk+EY9P4kEmR5bk
ydRgtfuxwLpAKYOZUTA/kw4GKwLqI+q72ZkRS0Vt44t0XkRqb6l2tTY2BfET
D7P0iq5LNjhFoZzLU2JlOuPDB36ludz1f/379/qOiU8VBDg/25qRyoQ4HiTS
pDSEuIuwQRabaagDkHXEc3tYUVK8snvjI3l4PbfqZInZtRQ/aEAFsGWEUtdx
QW3NjheXVz1++OkegG6VdE0FxD1StUCJF4UzOZBNBKMbO0pm5KcVEoO4BcU+
9WaMPU9PAbWXpIgNjlsPo3h+pvqgffL+XF9aMjq/QcuJ/mTpGELP+aDMYwQn
7/eVpSUz8wfs1wPn4HysXo6e7EJyE2y6yDQvykzUgLf87gurQmCLzzk5On5w
333u7lCmg6XBIKMSAX0yhjDaRSHTT0HUINPhrkajTilVqxUKVWJW8f2rj+5r
R1orlGoVILXJPr26T/O/Njlg0mllGpVco2/vm6aEgKALQ11arVqhVMvUupqW
PtiTYmyOwL/lyX67QSdVamQqpTMu5ezqiWZnZazHoNeC6yqtqWd4gda6072N
hurySLs1O68eVjGecm9LtVFvsFqtZotNqVbEJmX4EQxOK+EJTvZVB4UpZpaP
WQrsR+HsFquKKExKz1qAvw+XO1IhL7ugmemVMKylOEWgNl69eWl5Ur3V43Vx
elwIX6DW6ORKWYhAUlBS//wcOEXDEUd/QeLw4Ffi8CBHvxCxjQTCPF6faFPI
pd3DU2enx/NTIxnxUf/2Izi7vBlhxjIfy3ZCaKSSbtNaEssxxmnC2EJURgEO
AWi/Ydgn/w5h26O05cPmkDDbWAwj9C8fNJAYY5jKz0+/ikFjhoYOJHzDHSIs
4xTx0y4DFnZg25kQWxLGy8uJySBJL2ymMbKf8VT5UZapQCeGek4AHhxYOMDY
JhZxO9ogj0qpocVVkR8vUjqeXv0YAwM/41mUZdWxS/F8vm5UCAvahumyswWI
MnYfy68WsIQMgcAGzv+jWHGiTRERj7GtR1hx1wv9P0KlB27IKjXRzS4dws4Y
AB/S8MZv+t0CgaB1epOVIKU87p1FAU+8e/0KLfNAjWW5clCMdmwhLJXAb+bH
WDRRiRhrTxiUbWGy8TVUzvbqbKHEfHjyBH5vTw1IhaK+iSWaf7aysVNAWV5O
WFIvbcDTLiqCNwR+xwh3DlVewKL3akupkrSNLtE2OeGz/sh06sxx6UTKFOCl
ag82E/SzMuNKW52RqDE43O8sBiDD8C388vvFikwh7R6DZWRWnMELVFWyJB+g
ewT/VxshoYLxnQdKZ15O7XpFSl4TS6egLNjeNEYl8HSGGsuDZBqyt2E3S8gP
yrzI+slCrMxLKDMFQTmDECzAb8WuclpFaRTghwyTFdpbkyUxO6/f2K8jDOfU
pQ+JmF85MEN2F4ynCTIGJxAY6O6n0QPunLuQ8ATNPRts32tgF8cwTDjpqMRL
U+36qFRaupRW+DwGkaihb5Xtu0QY3Scr0ce0ewRFmbLQGBp+J2sE8zP3WDKc
66n+FvJHal753NxCZ31pUEhwRj7ej4GnNyd7ecFB6cU1S3PTsTbND6Xx+OYB
vH5/uKEQ8IzRyQvzs6Wpsd/4wpm1I5Dq/uKIIOxHTFr+0sJiY6nrH3+ENffN
sJoQpbe7i8N8XpAzKWNmZm64s1kiCDPHpnmIqaqrnXmJMDg8IXdxYbog2fFN
IFnYOiOL3FXukig1AqE4IjIHqhzOZGFahFBlrG9uaWmsqaos7+kdhOG1lBLO
DjSGCpTL624GDmJ02yR/0lM6pFh8MIIBfbrcV0lkuSXtTNVhWFd5pshouX37
hPKQ1srs7yG8uo7B1w//3dlxSUaCLTru/vkDxTji6K9NHB78Shwe5OhXIgRO
aVLm/8Z4m0yq2jpx02N9cVrkP0IkSxt4qAx46OnmrKupPj8vq7io6vDqHjzm
9dx0dzRHW6z2mLSG+urBwUnS4JydGCovLsp25fUOjn+Kn6Km5VFsbXK4KDcr
N694fGqZxiB3V4cDA0OAq5254bzc7OKSytOLewyafyh0NHifb9pryrKzcytr
mg+Pj+gh8+Z4q6I4P9OV3dUzTl6Zmxzt6h30+THKsEGx1ZnxngHKE+c+P6gt
KXW5sls7+qDR65udGF3d2EXf3KW5WWUVLbih/nzX09KYn5tXWFSye0I2PR/A
gxaDPKW4mbbeEcZYxyZ+duRk5RYUVy2tHJD4wX152FFZotFoMl25rS2dN09e
0qJ4ubvobam1mI1RsSm1tbWjo7Pg/er8BKU+5vb2dqC9Lj0rt7Vn2McY58B2
fu9oqc7KyS6vqLp5esfY1iCOB9eMCnFF1/DG6kxBTnZhQdn63hnEEO/j/b2n
V3cv14cZ6amt3RPvrw/z0xMXl7ckRgMPjXa3ZmVlldfUj44MdLQ09w9Ng6TL
EsOtCZkPT48ddaU5OVldA1MkLyvzk4UpiRqNpbSivq6++ej8lhT7/HhvDqi/
vOK1zSPSEAWfN8d7lcXFWXm5Le09wOa5PtmqK8/X6XTZBWU1NTUrm/soxNGX
e1vVeZkalTYvt7S7ZwBcOlpfXJhfIQ25+emhha0dFH2pyM0oKq99ecPFeLy1
XFaY58rK6x+e8VHV8FEQazUnuy4uT+rLCrNdWT1DJNsUGFmcHSkpKQFa1P5z
mEYT/wwPgrsPV0d15YWZObl1Td2XV3e0AU35uzFsbX68uqw4M9fV1olbleT9
072VkeFJkPrMcDcQXXlN06X7lZ5gAf8nB7pysjOq6lsBPzqtsnNskYY6xIc3
M8LoSM87P9mtKi3KzMkeGp0j+fFR+OVtoK0JlK6svHLn8JxuaFWZsTge9OKo
++Z0d3py6snzRiWMotN97fnZWdX1XUvjg3q9tnt8gUYqu0szxXnZgEZnVhgE
8fHY0VjtysoBirGze+T3YRDjovsbc+U5WVqNMb+kqqa2fvfwBnu/t5nkrpou
99lJVVFBdn7B0vIGWRgC//pmhwfLivKzMrOHxxdI43lmtD81IUZndjQ0NDS1
d90+wGBR/8d4b/fE7CLsst6GfnYvLG9Q0vt47u/tWN85IJnZXZkuzM0CzX98
cg1iF+/EwE+g8K+3J9kZqXWt3X6i8ldnhwpyXDk5eXOruwEQjMRxqP/94ayx
phI0sZHRyZaKHIXNcfXuowqMeQc623KyXYWlFSfXeFjj9clea02p0aBOzy6s
r22YXdwiJyiOd9YqCrMzcjJ7+qfIyiR7Od/DdXNdRW6eq7y65dr9enOx21CW
a9Lps7KKaqtrFhc3SexwtDFfkZebkZ0DapwJmUAxUJtAE3Jz86enZwsz4sxx
6bh/EFbfs/u0u65Up9Empbrqm9rvX30Xe6tjU3g8cGdNMeDw4PoBPPt8e1pf
XurKzWtq7ATP4BgTz+NjfKj/4Pjx9e6wvLCwoKhwafMQpHmyu1xQmFNUWE4E
MVKxm+SUwtn++ujYFFU7KNaYlxCmtpy/4Pxkx+ilpgSyW32/XFLyBcV1/fiU
S2H6D6mWAEQAk76Gq0SO1HLQ+VS6ogRa6zvcSCo3ziLVO15evbQLmFy28HBx
ODQyjEJMN95aEiSSrx69gF/1efHBcsOth+DGd2uRC2NcZaQT+fX55fX1LjXK
YY50saC6zxVliEwtggXC2DMVJISf7W8WiTTLy7ujg53Z2a6K6obbZ5yNi72l
1pam69t3eri8Pt3sbO+4efmAAxbyeLmlkcnyyzqoIhFu3M7KLJnZQYQfkxMd
5JDoy4zUysIzoDJCtzkxJHGQkKO/NHF48CtxeJCjX4pQGJVFGuFb4+0KhWJm
7YBAZ/h49HKxIRWEZVW1g+87Ez9lIr5crYuIiJLJhXyN5fDi0fd04rDotDqD
xWJSaJUJSWWY/60oKeo7XxLusEfYDL+FhhRUtbG8MKRnBGkrywgJC7Xa7A67
5bfQIFdpI/nM3nyvWCyOioowGbUGi5XPD1Nbo6/uPJQvhbAtXq5OYh1mnlwT
lxCrUYqUtpjrZz8YObemeuSSMLXOHBllD+OHpuVXgnG/v9L1v/4Int84p4wK
z5VBxDfEunBza21MLRZKNHrwPF/Ii04t8BIWtivOqjFa4mOcfLEoKbNiY2Va
rxaJFeqoiGiVXBSq1K/s4KmhT8c2rSK9qInlL8A7K9T7mJsS8Qdf6Ihw2ozq
3/j8+u4J8MDJ+rhep9EbDXqjTmtxrh/fk3j8amc5XK9VGYAMLSqVKtlVDK4D
E1StMVqtVoPF7DRrfw8Kza7uICHfs/s81qoPkigio2K0ConM4Di5eqVkS5Tx
+Xw92qpT63V6g8VmsysV4h9C2fj8FlHlbqdZGW6PjLRb+WJJbm2P+2SDF/S9
qGUQv/nxWpGV8AdPkpKSEmM3BfOEYrkqNbsWwbx1eUlao8lmNevNFotR8y04
rLJ1CDf/KvP4UqnVYjKZtXK1bXpuF6TTkJccKuDbwiOAboQIJIM43seOVycM
SqFMb4mPixEKeJl5NetTg0qlHBTQbDLI1Pqq5mFaT1aGWhUqqdFs0mrVTnx5
FFqaYOcpTC9E9GNOglNlssRFRQukwshoF6iylZE2UIMaS3iUwxnCFxRWdJDQ
vtqVIAXqqTMAOTgsxr+HhOaWE+s9kZeClJgfYUK73RlhM/0REowv5yTon+HB
i70VAP8lamNyfJxcwrfGpL1RS8HIINqPMlcikJjFGg5k+yM0JDWvgrTmZttL
xaCynFEAdoEKDQkJssZnPHqIkvjfa3LigDBNNocj3A6kIddqB2ZXyQYJ0eZH
cVq0QgOq0xgebrUYtN9CQsrqOygz232ZZDd8FwgjnRF6lQxU9MDsGtGmscqM
OIAH74mFW2NNhb8HB4+vn+BeD+S1IjvmWzAPsBrusIEWDUTUv7BBcjvUVhbC
FwF5Oey2MJ6gAl9YinkfL9MjjaEyeVxcnEEjlhscp3ceDC6THGytEcmUJovR
YrIqlNqewU0Me42PsBrDrWaCFHJRsFg1ubwDnn97vk6KMP4QicPtTqfVBGqk
pgPUO1buihcpFGarxazXgSa/c/xEufaQj5Rw1R9yy8Mrjp1vDpbCvv1DF5lG
Th3szvb94/sfnaOrOOftlaGhoUab0xFhABVRWTdAhIu/RJuNVtBnOWxhQklG
biXuKqrKDePzwomqD+ZLuwZnsEAn+c3xlkUtChLIQKUA/qUyhSMu8fqDEJDH
7UoID8LdTNF6jVyoMh7fPR6tjiiVStC0QUOQqZTF9X2gbhaG2sRhfLXJHuWw
B/HDcouphcYne0sWlSJUInc6wiVioSOpcLK/z6iUAW03WI0yubK2uQ88Nttb
yxOJgUqDXiQklFdW1wkgG1C43cVBpUQoECvsznCDTi+RSBKziunIf/DM/f6C
06gBrRXvagyWo5uXydYSiUaXHB8jFcsMduf1q+9yZ1krkQpVSqA2Yj5Pbgg/
vXzEp4OQ53irRq6zOy12wI9MKpAbnRUlhaDJg/qVheFPHlzeUYpJucYCVhT2
1+aFaCx3Hny6zCiXgh6GnmdLitSGp+CdW7LD4EwuoN1t9dmJcksU+FKUYtGn
5FM9GegwlweFUsXSzhnhnUTp2AOqoBDBrY+1A2Gunr2Bi7FGTUxGKQYjE8qz
okWmGI+XWZ2cHmW1RWSRAx8x9j3FhxvTcuqebm/Pzy/p0RAOkHg2M0OdaqVK
Z9AC9bbb7XxeMNDP62fv9e7C77//w1XZCVEkUpbm+C5Q3j77aEV6vN5Uy2UF
pR0kzyQXOB60Rt54/FSMA+WJ99cWJHwLlTR0DHlpXzo9YnKAkKO/MnF48Ctx
eJCjX4vI2X9qrPFtjrXJ5dLZ1QNqpAefXneUSeNMLgK3TzaX62oa38jdHZ6P
5PzQjKIWYg7TExtuis+upryMqL+3uWkEGqWNeXEhMg2wSeBdPMf10a4fwd/S
SlvIn20lmX/7EdIzuggGxuONMbVMrLFGru4A2xU3iv4IFbT1zcPoONxQWOmv
DQoKmt/H18X4n6/nZ5bBi693hwY5z5FSQJZma7IrRCCe3r7AvPdKiSCnvJNk
YHeyL4wnmtm5xrwPdq3cEOUiC3+2PMLjCdpHAWhCGkrS/x4UEpdRANAHsK8u
9tcaquqeybV3nmuViB+fVYW/83xs0SvTippJVEB+gt5qqCH/79+DarsJB6X/
uTAh/BtPvrxzCt5+PFsDmKixewyjlpbhpgD+oufOqdemFTTRO7HUl2aH8sKy
SmpfPnB3aEaUQaCy4TPPKFKWHhUq1RxdeUivjUEpTszBA7TgBkHY69m6Xa8w
OmOWt06I6fR9k1Kksic9v/sR7CUnNeK3YEFOVbuPeOXucFEtE1R2joJMt6Y7
g0PCGn/OElV/H2FSJ+fVkGlW5SQBrFFY2YK7bHxPCSa1whb35MXjEqf76oUK
w+aZh5TkymALSKR9aI78WZJql+mj8VouTv4hNDz5genqv9zbWV7CHUZXe3MK
paRrfAUPtkQQuFMQnv/RzCBQhNGFI9IaLE2J0loin7y4/jVV5P3+IwiYlO6X
d/D0w/GaQhKSkNdIvjjTXglYXTl8BN9LMmOFMlVL7zCRsrcsM+YbTzy/egi+
97fWD00uktrfVpwWJNbsXTwC26yjJgfgQXI/GTYe7K/O/BbGB1IHz9xeHS4v
rdNLCMkFpENdzb2jc2QRBhoLvwvlq4f3oDmsjbSLRMHhUWm4Sx3FuquygniS
sfVDHCp21wLNz61sJUSF9DeVC2SyzslljBUIiqDvBckRfKX65+AULiHEm5ds
+02gXNm7AjdrcxP/HiwcmsGbm//1Jt6s+aE0n13iix+rM+K1xkgyXnS6uxoY
/3hzQLHprpq/fw/OJaYXUMzXW18klMu7p9ZBEc63JkErKKihVp721uSEyFTX
z/7njaHg4NCRZdwyx97u52aXPOQWPQSHwK7dnh0QyjSjq0eUZ/PlLD7SIJEb
egcmwa+7ww25iJ+UW4vf+3jurm+cXT4mnarFKXae1Hr18E7OESnNkTfvVH/k
hwuypnvqwwTSha0z3MfaXSsWCTRmxy4evol0VWaINPbXd5DFnJgXnFfWSbbE
vrq8ULH64OIJFDA3Ne57CC+zpImMItia7QWwsaZjnOj7/PW5CSKF5dL9Rpr0
eJbe16xY6+9C1dzaISig+/o8M1KvtseSXqfWirRvfOXywSVhxr9FmhThCbm4
r/ZmR6dSN/TOkAb848WOQgw6igoMdlkhfMX87hVoy3EmdZBMt36Ae3KvT3am
J+c+vH73zqJMouwaWibr/fpoUSwKSyluIFmaaCv/IZbuXLxhPrdDLw1T2/bP
n4F4Lg/Www0yR3I2vXaVlN3bzYFBriipHyBVdLKjThAapLXGnlwQbte3uwiN
VKSxnVw/EfNUcxJ+ECgF7jlFPLkJ9h9ieUPHCPhxuTmjlksESsMAvqYVW5no
/iMsrLJpAA4Z0G1HjyfIe6xJaY9LBdX2drahFcnq2sfpZepAjc0RWYDVWJs2
Nb+RZrinPk+gtYJidhWnhCh0AK6SzaqxMJUvV41vHMG84IZUMFSchHWFSTaZ
wUFsHvMYrtVl5jfRI0V7eZZUHX519w5PQXlPjbaanemMrF7d0XqVUKV3Rtg0
Gp0zKnHz4CJwZERmBzoEIn5qdqnbjTO2OtHxIzgotwLfrassMVxkcIC2gD/q
uTUpJaAPZ8IGQId/tauWKwrLumB6uG50VWVLTfbzD0aGJIGOOtGm/duPYIMj
tqOz9/75A6MjTzhAyNFfmTg8+JU4PMjRr0SflsAgm2MdCpl8euOA3oQQ2DUx
NqMzNguljF5ww7u5ujTU02ZSauJTSfD1nmQ3xWXV4sYltbsCnsDd5enE8EBx
ZjpfpVvYvifMJDISyF+c4uSpbB4/3HQUfbKppfbEAvDrZGVEIJF3T+5hxK3X
y02ZUFpRN0w7v8DjhysjImFYfFr+9vEpDaCmOqsBAJzbuvA8ud331++PVxaV
IquyH9wqSAlXmmPeiNVd1ZlRYAQHSe3P9IDnR5e2318fHtx3Hx93AP4kFeNW
SmVeLF9pvnlF4VhM4aztjeWfvR0OjSQiLQ9P6/XEbMDxIC1P3CzwPcWZVTjM
hAP4++2uTCDKLm4D373X20a5rOnnJBkHCI0BH4a8RxhU6bkNVDooWlWYKFZF
+r3UUpSB+kKhVHb9gqKeGwAAsys6EL/36f7m9c1TnR2rMEXSu9XhfJ2tG+Si
StwpSTHW11IUJFDsHLlR7C0hyqhypsHFL8jN/pxOLqzqGQe/xtvLAdK88lCs
1+fEq+wJ5Pei5HCNA64fRLGO0gy+1nnxACwW38xAs1Ch27kg9mNH/a4Ymzo8
yeP1ud13Dw8P62PtAon2+tG3OND4RwivoLb15uaZSAOPvrs/WlKqpF2Tm+wQ
KTKA6mR5GFjI04tUAGR5Gh5MiCNQDKvIT+TLdDduXNnAoz9rc0PFyt2Tu5cH
t/vx9uVmVycTV7SOgrQKYyza2BQMWq0PJ4tivqCs/ic1LQ+09PpkfHigLDed
p9ROrOAIi+0f3Jrsp/Hg7EBdMI+fVVR7enHPrA5DUMpIRfzkStiHm4vpsaHK
oky+WDMwuQGKudDfIBLLl48fydo53xgViuQ9E9ukt0JmcHqhpwO721CrpC3j
SwHNFP3IcBosyQXULww53ZkO4wlaB9ZAwwFIPy6nnmwdQG4X6+NBYaF1XZN+
PF40Xm2wEUJCprsrRQrZwuE1YDw90qw0xcFwSuTjdkepkvSMAyTibSpIFqrM
l7dvjw83oFE8HC4qxdKh2X3/44FMGBKZmLuxfUR1GjBaj6yw/aVBkVw7uXFN
leTlPNygSCpqoYP6YsMNzrh8DG6wA9i7PT0eG/yZkxIvVeh3T93gva5Kl8wS
RUTbQaCNv448nC3JRPzKNlChWE5SXHp6emxkRONPfMIBIDVHEu5RAoiepzCd
3zwCtp8e3dd7cyqJpH18G+hnSpRFZ4+HKyCR4rRIIHP3s//BffP4+Ag4F0sl
43MHtE8W3+WVF5pX9xNGFSKDjYUic8TDuw/5eAjXimNdlaD1ud3u59eX3upc
udL+AVL3nGg0krr+aRKuDDYVB4tVm/vXz8+P9/cPr3fHWoWkfnT9+WJJEMKv
75mGa1ApzOveW1CLpD1Dq2Qtd1dlCUS6vXP30+Pds/vh+XJdLZX2Te/c7c2H
Bod1jKzSnXZVVowmKslLwwW87fgw95lJoSyvHyazGG6uDOVLpjYOyWmo9amu
ID6/a3SZTgS0oO9izdbFC8CKaeFKa3IOeQfgu0itKim/iqwSgPG0cmVecRsN
eKjHoJNrsDH/7z8Eo4v7gImL/QWpWFbbMkblgWK1qXE2Rzr29hJjVScUNFBL
uVGsv7kYQPKH14+7g1WZmKc0RZSXlaQnxeEb0Zgss9snvjfP9dXZzc3V1eX5
y4sHOt9wxdud6PjH96Dazgm813i5MKgV6XnNRLr4UwPVeXKV+QL2aKD3TI42
WyOImEyyA3z3NJbkZeYWz84tDfW1KIU8idF5cvuKwvXmBB5sCOGrto8eYSwx
lubQaCOSwZej+YHQMP7Q/D54bme6hy8QTa4eg6zh4a/Yw9UWhQdZq9+7qvB4
UXo5KtP1Aez/8dDVUG4xqn4LDZHpLSNTayjrIY44+osShwe/EocHOfp1iF5D
Qc8qr493yOVK3D9I3/Jc2XWS6Kwq4gnfz8ZKtVZlMofHxcWoFMqMvDLiybcY
uyEhsxyjzFrk6mg1MSpcrtVGx8RFO6xSg21x65oJxkI/0qL0hpg8DG6Ih8/x
xjn1tljwzMXmkFAu7xhepkIfr/Z0CkVV4zAcD8k1j96xjka5TBImlITHpq3u
nIBLfY0VYrnCYbeZLGar2WYy63hieWEFHqizNtoSJpAuHgAL32tWiVNLWkAa
0/0NSpUGPG/Ggx0tgIBZ6ML9C0hZulNhT3n3M7vw9bfV6NUKtdWWFBetUynj
c0vwq09nZr0krYicjobGnefMZpCkAvSHwm0S/W/RGkVcGrDnfZ7TTWAWNvWM
0pInC4W+PUbqtBm5EFqiWFVevFzluL+n1gZOtZar1Nqbdwy7WXeYVMbwcIvF
pjcDxs0KudQel/roo8x7lPAPGhXivJY+WuQzfW1CgXR+GzfXk8JVjtRy2oS7
311WywB4HAM/TjamQLXmVzahxCalCgEvLpcyBYsTbaqoBM8HSvhpfW3AdNdF
XD/jNtXkzzqx3LRx8ozXJuJJi3dqtHhkqRlIFojWqJcqTctbN6DWGsozRSKB
QKxIdBVd3uE7S1xsTytU8vaxZdJfyjrLHNmf7ZeLFKOzJADBKpOjNdZo/MAL
BC3LSVZpYz0elNSH1uJ8lUJtt9vxkEWLxWyxgcKSQs6Ps+qjkvGpADK68ubE
LJXiwcnAVDvfTY1xytWayNiEGKdNqjGNreKugT+NF8X58r501ZaIxcJQiSwx
Nff4/BFl9urH1fjp6jAzKUquUEXExMZGOsQy7cTkLsh0oa9RppBPrh+QBTvd
nJbJ1X2gXJgv0qyJSy6j2+D13iyAZh348kCE2ZkH+3BF6E0J6V4IWJ7O9nQi
SVX3FPZxoZcBLD9KG/bepzOFQpZbjMewVWckAnP6gTA7Z7prRQrF4hFA4l6n
WRuXWo7B3TmutqZkannnBI5EarMzlGqF3RYO6s5ssVtMZpFE3DmCLy2c6G9X
K8ShIpEtIoboIuhOBBfsxkyfRKoaWz5GiV15Mc+F1ahIKWiEbRZLc5qj4gtJ
Nk/W56IdZplGFZOQGG6z6EzW/dMHoDrtZekyqxMPy4TH2ZBvI8hrvFUbnVGF
fnjsBt3k8k51ZnRSXiP24dGr5CWtAHEg9YXpIrUKpIZzjpORp1B1De+ABOIj
zJFxBdCNixUnx6h0Rhv1pNFqNEjkmvG5Fdri3pjvA+hpeGKb9J+C/22VmRKz
E59yuT+NNel1QMesJjIXrVpjMNuf/Aj2dKRTy2p6JkjGf9bnSJUaPL7XYsP/
AX5kiraRzYtl0L+JZ/fO/DBynvQAXm7PacSy9r5lEk62FGYrlXKb3QpexHuz
cLNYJB9fWttcGgjjq8lddkkqTgrXx6ayT9hEEezj5tikkJfU9JHCH6yvkElV
uxd3pD7NdZWL5bKl41t6t9u16a5gvnR68RrcTw3XhqfmUN2T7ynJokrMLaU2
43q4cKjVBeWd5F0aL5M1tTPTGxQUlFrSSP58AH2dRFnTPkFj3vzkWEtUJrgV
Y9Mm5zfQYLK7LlegtR7f4wp+vDaXFh9pNhmKKtqWJ/vBcHN471sbbpbLpUaj
mSdT1jR3w4lB5O50TRQWZEnMJUqPoK/34VpNZmETPX61VmTKVLYrNwzgRD9S
o602RyY9tUgdHwNB2fZ0b1AYr3Vgjhmt8PMmmsMEyrnlM7q/rsqKFptjn/1A
1V8itYo4VyW4WOOKURid7z64uJLI4ulqG/TPxZWdGL0XLop1lbtEFjsBUumd
uViHHAGd8zyMdreDkSJYrl07PEdhahxx9BclDg9+JQ4PcvTrUOCMIx6NszHR
pZQrZqHhCoaog/mfwcHBtV2T4GdPTX5wiCC3rPbsHAd3iVZDdGoukdBTnM2U
lFNHxPX57892bWqpyhoxNouvGtud6Q5WqJe2b1B6EwLkwxVpUjlTYL44KxlR
Fr0jAdw/3xgVycVtQ/i7wAh5v8DxYGXjKAY3a6Hp+eGqp7XerJAIVJbLp5ep
/hq+SD0ysby+vLC6uLS0vLG+vn594yYw2rVeIapon3w8XeKLZdMbFyDlqZ91
wRJZ78ji6srCMnh+aWVjbf3y5gGkXJLhlFvjH+AmNYNNRT94PFdJ1fEZ7l4p
iDYCCwT37r2cmvUyYn9RjHZfYm/Xdp00LqeenvVFPu7sSllCOh459nq+ZFBI
8XhRuK8fVRiP26HVZuQ3oVDy1flJAA9eUwsnsdG2MoBc8Ii1+z0AAXKr27bW
VnG2FxY3V5eOjk/ZdsXL6YZRISzq7KPNnpGO8iCBav0AlO4twaG1JxUxNtXe
IsCDVd1DZEb1+YnfBaLIqHCNWm5yJp1dvZB8liQ6VBEJePAqaa8CQ0sXcfWE
o9CJnzUClXnvlDgvDH1JcBrNUSl7W9sry/NLi2urq6t7O7sPj6+k8XlxulNf
lisS8o0RiSC1l7NllVrWPU26RZhNYwFje3ODCrFybPaArPXy1Di9OfLZh9tM
ZbnxMo3zljxKAUNaCrPECt3s0trqCl6PK0urm+tb9/d4VeYB8z02xQ8Px3i8
3JLyhdVt4+jbXYROKjE6h6fnAEw4Xe4PlSmmVnFfZHtNFsCD+6A4GLI53ScT
SvsmFmmL8fbqsKW2VC7ha0zRx1du0n4Dn2/3Z9EWlUht6B+ee0fRs60pvkA6
SjgBFwcaxQrJxNo+KeHDrQmZVN0/fYihfsCdPTmfbgWvZ2tAGm1jC/BUAuIy
6nE5DNaETNpTcHe4KBAIWvpXMd+lViYoah6CUzHYy822RCwsrOwB32vT43VG
u9uLh2XOdNYJFKr5I3yrqCiTLiKlkG5H7pM1pUraMYm7nCozYmR6y8rm7trS
ItCu5eXVrY3N+/t7MvGPx/vejiaTThom0y+sH7K6DhwPihWa8bVLCh28XNpM
yuS8OvqBDKc5MgHP9GZvGSiw3hE/v4Av+pvrrBNKlDunOFRpKU1WhEc+fFBN
gCg7WS5vc3GKwZm8MjsMIOqLH5toybdHp2+vzCgUqrldPDi2KitOqI1aWFsD
1Q8aBbA9tjb3Hh9eUeQ9MdLoiM6ly5sTY9fb47Z2NkEvgbegleXt7e2nh1e6
wW4tDoWG8fvH1ui4xL66PJkl3ANQxfM16HBScst2Nzdw+SyurK2t7R8cAe16
ut7QqSVN+L4xeCJt1a4wlWl8YX11eWV5aWEF9EcbG+6nD3xuSigZXz2CWISq
5outebVU3jOwQvYZjflpIqV+YWUXWAs4n6A4WzsvntfJgaagMNnK7g29E29F
Zow2OpneEpOU2Pv1gUmpKiXxIIoNNZZKpPKVvQuym5rprQ0TSee2r1FqRTa6
ONTwja+c2bgDo0C6XWdJzqEqzvcUb1EnZZeTbCLuc4tKnV/+5WBT0G/vzfPC
fpiisqntVTHEew8wKT+3qouoQi/AYskOQ3haMaEMJrwLQmFflxkts0Y++hCI
Tym5T3QW8KR4aMHD1dHUxPTM7MT02BR9lt/bwyHo5YTaCLqjxmMzTGpnejGt
mXhPbiaOH6X2iP5IjzaZnS4iXzjngJKZEn7++z2VXFCBx8oyuj071MgTaJZJ
3SYI9CqKiPg3oi/qrXIJtY6XF1xQaWVtzBBFFML7dGFSSjILG2Dbxf/XZsXK
zJHsGTxqLpEZ4XAhnK+Ph4QKKhuG6HknlBk1yH1f//xcSY44+tWIw4NficOD
HP1KhNBuCIwYiDbHuxQy+c4ldebd4+muTSsLUZqIxTVYgllmiicBIH5ksF0l
j8soJJJ5cVg1cenl5Bzy4mDzb3+Itq6o1WTDTXmhUt389jU9coEvHSWu33mC
hR1ch8FLd8eLfF5oVlErSOFkdUgqU7QBu4h49OVy1yCT4niQmjvFo6FeXx7e
P6gAG//1cmjI946JjefzdWDFNf5cwOj92VglLcuMc8RnVOan6SzxH4QlcLo5
KwwLLWkZZkuDTLM4LVJuSSTMDDyR1EiNIiIdDtbP0UaFIyUHh7fPxwatLLum
H4ObyRP/vDkJzlC5FmAl0ghZGWn9HsRr7MIdB88nqwaluKFnksyLOcPu9dau
libl1UNcidQWJEpUzot76syzsbYSlVp7+gQw9WuETmGMSafNVyoijz4HBPW/
nm0a5KJCPOCNuIZ6ksI1Yn3U3Ysfx2sOvY1YEEqW+n53EZhAVV34ksaLnTmL
wdg7Nr8yP72CTwtQ8/8gh5KkcGVk/DNc29VSngHw4CXODzbeXR0sVO6fvRFW
i78hNyFYYrh99ULOKN6e3fe0jBZHG/4tTLJx7EHvV8VSUfv4Ou1lgOcAIvuz
gzKJfHRmn8yxPCVaa3E+feAKU54LwHKE2/1G2t7zg63BoUEDC/vEKiH2cZNI
YbxF4YijFA/199bm/h7KWz5+ut2b/i1Ygq8xJHgb66oMFqum1vB9dFsqssQy
650btw83xvuFfNHcCo5JH90PCAyQO1/u+fEjuBdfc4eR7o/DuYHQP3gT63dk
ORaGm//gKcYmcf/UYl+DUC4dXT8m3z1eH5cqVd34LaQk2Q5ax8Gdl5T0wdKo
UCrB1w9SMXikgezNjNRq41LpUzNaS9N+58nnt+4w/0e0Ra0wRb/7EQJBIoP1
Bb+F8ceW9sD7xWmxWks0aUlO99RK5bL5gyuMWG/1Q647vX0jZb43+1MslfRM
4i1urL38t1Dh3P496zQHooU/Pb+8+6gAv8dDUfAf+D4hKNQ+IgQxhCedWb+l
qvvl1GGUJZEHvREppEWYIhPwWYjp1uIgnvD6jdL8tiKXSKrZO3eDYjYXp/L0
DmKlMXnAKBFTSUCdzckuo9kQnxAVR7iurjZHw632lPS48MjYZ+L89tG28u88
4ezOPft0GNxgRt6THebw6Bza0u6qzPguUB5R4eB0R4HQe4zg7ldJiDOzBIMO
nOrsWKkF35kHpJZm10mNMZQBD2OGwcfj6ZJcIa7tJbamQdGNse7gIH7X5CZG
R2IQj13uLkoFYcSeJxSbfi/eHV1tTMl5wrbRVVKq8331f4Tyx5ZP4PmVPlKw
R0tDktCgzLpuytWEIalOoyU+A0HoQuOlfrs5MCmUpdUDZC4EHlSt7pGeJtwp
Lw0LSc9voPFHeqSep7U8evDDTVLDtdZkSlyo9zHJoklwkdwivnuABxUFAA+y
DnABNXS+v6RVSEzRWSiEPGQTzo0zSQzRBEvYw8myMCy4uAUPYe0sS/shUhO9
BwLGGaNCDIYP4hWf10uljHzcGeQCe1IJ4mf1byQsQv3eh3OHSSHVRT15WZ41
DGsqTAANitrh03drEAkTcmpQpjUhabFGW2QevYXL+sLE6uYRDbRAM/kRyv85
ucpoP4KfRx/GVy+sX5LXHi42gfQS8yrJgoIRSq/XZuekm422hZ0rDGPOoCFO
GfHkxRhDVdbLx3eyrfjuz/Ty0Mg0SqQXx/tHh2fgFcRzW19dMb95DLP1H6+N
4qu5O/DJ2Kuz4/0Deh0l5yvk6C9GHB78Shwe5OjXITiRSw2m4N/GaLuYH5pd
Ut3f01mQlaOUCL+JVMOzpK3uLU6xh4gUPQMjQ4M/U6LDfwSFJGYQe8FhPleM
KVis6e7smZ5aWF8cFYt4yTkVU2Oj9WW5crk0VKZfgAuLyIH37frIphTy1GaQ
2sRgj1khCVOZT8+fwd3tuZ9BfH5jzzwJbV7Ot4D5VFzZB18HhLQWpouU+q6+
oeX5uYrs5GC+aHbtFNwoS3f+PZhfXNU0MzX9s6U6MSn98OKRMsIXh+ViATCV
q5uGCbMP3xavqSD5b8EhoLwz0+MDXQ1x8clbx88g/fwEc6jGceslY1Pxffu/
i5WdA8PDI/2pMfagoKCI9Fycmfdbq05miEw9ubzFbVfKCvKdbUxLeT+Utujx
0bG+jgapIFTnTH3CYxb9L8ercl5QdccAtKOhler1JNu1PLmuq6trdAoPzyvP
ig4RmC/u34mC+0ca8kMl8oMLPIhxaagNCN8elz41MT0xPpwQF9/dR+z3Dg3U
55N1k1rMU2rLKhtGB4dyEyP//Y+g1p8zRFKPEWaZLiqHtqxut2dF/ODS1kHA
0PHarFapKKxuBYKdn5sZHRnY3aNOYc6PMgjMjmdqpwe0rig5VGrBtwFBsbWp
3uAfQak55b3dPdsHJw/ne3qFgKeydf4cnp6eLHIlF1bhRzTiu7ZaYsYnJxbm
Z5MjzWEqE8CM6MOJUiKwRKb09HTNzZNHolML8ramfoYG84cISAX4LIhzilUG
fFKdODIsVGx2uz8oNfa/psdafg8RVze0zc5MtNSWxqVl4NuSoP7SZDuo9Ni0
nMH+oY76spDgH+EpBeCty50ZoOrxmUVTE5NNlUVahTRYohtbxN2sXbW5wJLv
6ZvFiDWMfF6wq7T5490DtEtucAyNTc7PLrgSHKCyNo/O6Sq8P1xTS0KdCXmT
44CBcr1G/oOvHBnfApbebA++8HBweZeU3cHKSDBPiC8Bw/eKHA0JCdHZ4wYH
+7ubqo0a5XehvGN8hVzcRMkaec+NtQGYlugqGBzo66gq/BH8R3RGOXl3bawL
KEN4fOrIyAgoIC84JDK9mDy/szY77odQMTUHIAky1VL0XSAa38Sbye78EJCD
1hk/ODjY3VSpV8l+F4m6plYI6/Ym0ab+QyBtaOmdmZmpK81JzS4Erw/UFYgV
uvbun0tzs3UFaSF8wcAMc/A60JCzrRkJjxcTn/uzq3N9Zx99vzYq+JGuati9
eOPNGtIvsznXG8YPdRVVT46OVRXmyGUiocq4d4rPF400l38LFpRUN/b+HDw+
vsao8xyJWN+XS4dB/n9/C6pswKdfsLf72HDD//rtW2ZBNbWq6+UmJVwVJJI3
tHZPz07Ul+akZObhG32gH5FmlSE8jWQV/PfcnjjUiiCxpqO7f2pqoibflZlf
/kE1HgIBov7GwuR/+x6UU1w5OthXkp3MCwsCdXTxjpdlb2kkLDRYFx47NjE6
NTmelhhX24b3Tp77I6NCqLAl9Pb2zc8ugRZdmGD9eyivvL5pdna6o74iITnj
8tELdLKxOBN0Oxl5ZeNjIw3F2QZrBAAL3tsjnZxviErq7e2dX9nAPh5dUYZ/
hEprm1qnJudaq0oS0vMAXkOQ15wYK+jlKho7RgZ+ZiVF/xH0w57kogOtSZ/R
29W+isfLJrYx8WNIf2XhjxDRyu4JBNpYc3E64KGgtHp0ZKgoLfYf34PqO0cI
iPkUq5dqolOpuvW+OLWSiJR8Cubfn2pEwsyCVqo3JvI8WJs1SIX/zhOWV9T0
drbV1VaXFFfMTK2Cu3tzgyFBwYk5FbNTo6AWwpTWqxt8Duf2eFMl4OkjE2em
J/MSI76FyuZ2gGYicwMtCo22q2twYnw02qL+LlCt7l5gGNNPkvEP16ebUWbV
34J4rpzivu6uqrr60tLivsEpwP3d0YpMHGqNSZubmsyPd34TEL5UDHGfnbQ1
1rW3tlmMKpUxoq6hvqcX74TLsxN+54srahuBNrbXVfJCw0wx2c8vH+xQ2In+
xrCgH7rwyNaun+P9veE6eYhYt3FwS/b24H9tTiq+vVVShpdyNWIwFht/YHdm
KCz4m9oa09/fP/Cz02FQf+NJ5zdw97rXfRWhEocqjTdPXgDhNeLQ34WqovLa
kYH+tsZauYQvM0ee3b+h3vt4m+K7QLNJzOfQcx3s3pIjjn5l4vDgV+LwIEe/
FLGWa2G4R2ZxLMqBr3YxGDUmmzU7p2Dj8II+wPrqeDveGS5XKlR6U0l1c2le
elZ+KTlSn29Px1gtfLHIGBn/6P2YbK9UKZRKlSY6IbmzpSEhLnF+54bJiPh2
c7SZ5LTJNCqQoC0qYf/kglyIdLY1ZbCY+yfWyZ+e6/0oS3gjMetOvIvjuI2V
6YSYSJVaq9JpFQZzGzDdyfOUvS+1+elKlVSp16s1usTU/JPLe+gG9eQlRams
ju3zJ8ppRUSuNhZnqVUKtd6g0iijk7KPzgB+9DWUpFvjXM8+aj+Z28vd1Air
RCFXaU3FFTXlBZnp+SWk7dheWfAHX1jfNwdPeqbWg+zPjUda9RKVSqFSxqXk
k9sngpRfLjcjw83dAzMYPOWZlsreyrTFrOOLJQAcAbtioCnfbk+8cb+TApvt
aQi3O8+vn8mHZ/tbzYBntV6jATXlGF9YZ9Uj5rnaTImLA1ZZfFS4WCqQ6411
HcPQb/KaneRIzK2DDg7MfbTqsOiah2fJzfkTnEaRXGUy6jUmE2AegNDalmEE
QRrzUyKSM5+9lJHT3VRsi0q5eyHizT6em0uzpHKZUCiu6xjE8N0Rl2MjwuVq
jVarVenNtc0D4LHZkZ7ocKNKp9fpVfpw5/zSJsnAZGc9AKFBYglAlLQqghtH
K5Nmo2Vy5YzcvbMxL8MRm0wC0oayLJsj9f6R8lbisbuvt/mZyUqlXK3VaLT6
lJziOw9eHVUF6WmZhSWuNLlUJpMpElxF7pd3XFV8bwPNZQqFAlSRIza1p7U+
Pj5+bh1fInS+PWvRCE0Rmfh2ix9XWbFWvtJ8enW3sTQWF2kHegX+6Uzmwbl1
Mm/aeTHW1ahWK5VqlT0isaejNT42bnRmB59mGes0Wy3z+H65eHWf7MzbbPbh
edLvicwNdpn0KpFMqreE19bWpiVG98+s0k4WooBvpdnJmZkF+amJYoVErFCn
5pY9vdHbuWCzgy1Gg06mAnkr0/Mr3rwYuXZ1Y35ALhbFJOFzF2tjHUarbXX/
gjR05wbaTFq5TCHXW+wNdY2piQkDZHEw7Ml97kqMkqt1Go1KrTHkltT5iSMU
UxMj5Bq9RgcanR5gBx/cCZb0BGHox0BjCSi8QCAoaugFV1KirfgWptS0A1qY
HJdeUINDPPSjuSxXDnRLrYpJzW5vboiLS9g7xdeyvT/eFKbGgDKKpJqhsSUY
QOcl5dxYki03WBfWz8k5pY7qbJHaMDRJb4qCedwXmQlOkCyuAzptZmntKzGl
k58clZRRDjseHB/dnWwlxDoAC1qtWqkxltd14EcLku4b/DEfUOnynHTAJGgL
semZdRUVSamu63fKSbcxN2Qz6eVakI1GZ7T3jU6TbX/6Z6tBowyWCkHPgyfn
uS/NTMQ3RdEBuamTs0su7j1E2Ly3qThHrVaDKgO6lF9cd/OCq/XkzyaVWsYX
ClJyqvEm8OYuSEsgmNSC6sjIq7j3fOBhG+6TrKRYoM0SmTgrv7gyPxfog5cV
FAG+fLjPo622emIHHgzflLUeNKW943PYXvBJhrqybJVKA9JX6oz1nUOw5XmK
kh3xedVk2AjqfcyJd2SXUjv3oo9XsXZrTfMoHVUCaLSzAXCYlJQU4bRbzEaT
xSyVqSqqKffxRHcD6KcB6cyO5e0zjIoBRnbmx80mHd7+dMbu0WlyJNrfXkiP
jVYqwHWF0RKxvH5AbxeGUkGT+K+VmUGDTp+QkBQd5bBaDGazWS6Xu3IrSY62
ZoZNRi2QLRinBiYof+vx2qxZp9IYjNExifHREUatxhYRBzqTd/d5VWGOTosr
jUylTcjIInyLlFucbGGzI21gICsrz7cYtBKp3GiLnFvfIzWTzPFoZTw0NLSs
eYjWMQqywe5sbarPYdSB5gY6SdD1Tc1sUFtSP12lOkwyc8TJ3Qe+kfXxbn56
AhiJwBAmVYLRM+3g/Jaszqx4m0jn3D66QZl0GeDJEUe/OHF48CtxeJCjX47Y
4wlKTzbS85sIygw5OOg6OT1w48Yo7r8g9wclD5hGfS8nR6dPz2/EXhDI4931
yem5H75Fvg7SR2kQSqLCi/PT8zP4y8cMb2TWDFqFt0ifJmEbPN5egU7G8+bD
yHBNmKrn8X7/+OTxCW7fhrEiuwgGSM8cbc16Xh8ODw/vnl7hshUYehUI8U5O
zh4oWIcDSQgz0Zuzi7snD52JjxEqcnV2fHl1xyRGpk4hCChdJiwQBVbo8fHx
q8dLBQUhjEuUlgoC9xwAMrk4OTy7uiRvoIwEiDAllFoRc358BOoLumkwlgFB
Q1F6uz6sqyJLb4+5fXz1eT2vPt+z+zYryipRmz2E2Ogd7dk2iY9iHb28OL64
uff7vTQnV5cnR0cnbB0Df6+vTg8OjjB/gGwf7i7PLy98vg9yi1aaMebdAKuH
2ReXOYSMyPTp/ubo6OjZ46MvAn5I3bi9Ob+4vMWoEEcqxuzFfXN4esZKFCF1
4/np/uLigmDOh3y8gy733UsGKCO3l2dAW97JqgloO3hGrw93J0fHrDVBfhjf
RSkzHUtGKRJ58c19fHjyBkPwgD4Q93wQ8CE+eAvkfnl1Q7cplNYhDDk9Pb2+
f6TaEazrl9vr6+tLFAbLBbQpz+Pe0SHI1E864FjxeEAM9zfnRyf7eL2j5NpL
/P/z3d3B3rHb46ebBqtq8I4CvAXk5v2gGGTbqkQ56ecR9/X52cU5yw1Kdj74
G6Agt3fud78Po9fvUfXih+3Ej8KYOvJVCpwSh93f3l6fHJ3jExVkBC21OTDD
Kt0KgDBBcyPnnVhaxsTjuS+Pz84vYeG8GGzBpMvy8vQEKC2rZeGfL4+3gH+P
10f3A28P14cHp48esl0w0nh5doMu5dHzwZbS4+356ek5sBNggojbfXd2cOR5
Iw8ngG0QQ85Pz65v7mCxPqjdmGDfSDlVGX1jZwIX06LY24v79OQIDwJHMdaR
fLQQkMC4UCBRH6uwUAlZDQrWBqX/5Hl7/pfHg8Njsm+k95slbn6ADvwFFwAz
7oBblxcnx8SC6IBGT9XhJ5WjvlKbtSJwexbk9fD4wEMF/NOHuUOXHxTGO1XP
yMvz/fHJ/vW9m5YDq3f2E40YT8r7+gi6CzJ+lc3J0nB9iFS+dXSPoWxBI2x5
gsKen16AMRGDF8lEPl4e3Y8PkD3839PjHehwbm5uaHX1YX58E+ynR7YwWHXN
EUe/OnF48CtxeJCjX4egGcZYQWjAUIVRq/tptEAN/RBM0bYNitKPBZhV0K5g
TApqZCRdBtQFFP5hxmEUGvv0SywDAO7CgNBpEhYd3E+B3C+O2psRQeHoz2YY
8oDQhg1rFP8UfsNYpCj8RX73s6ErCoVAPoCyrSOElu0nETEFx+CZziglNygx
ZlMRhhn6XaYsGHEyCArr4uvdwBxZT8CkqIxSnXqBKZJ5CX2NMcv19jTG+8Cq
QfocariIkdVRQ6FBlpBAtkgo5A+4Rr/IYouyzT69TRld7HU0vj8tWsA3woNM
qzpzB8qcyQ5mgtH50BdR2uSG4b6UEHywXOwsPmGQT0rIXA1sifCT4sUHDXs/
+12WDiAYjT8hUGLJHyGaBMJOn5A7S0VZZx1i1HkxGK3nVOUy/3xMygGiZkAu
6ypUYCpxKqYagTJnqx/dygKQKfOJ0PKHLY4pAVUKNtwKBA6spkR5VVAKXaDs
hwP6HMKhT5XyUzqMmiCw3ZHy9LHY8weqDobBCqSOVmf0MAANEc962V1cwOaT
FBBgKcPnwlISZqkl8S7C6rqpHg9hTS59EhervIFaR9/6s4qmHmbO5WS9Q5TB
ywJx7EVwsHbwm5SCUVtP423NT2v7l86E0RwWS7Rq0ToD65eOqqU/UVZvA2+w
o2ZQ+CKdI/E4UdGI//n5+XBjUSPmRaQUMkVmFYrkhm4CDBxmB4QzoBthJcFM
S0LBIvQKYnqVdECAD0cc/arE4cGvxOFBjn4dIuwK+hdCD0/MFeIz8CxcOO5/
GvFZphR8ADoVqNdYxyWzLRmU3A7AR2cNTzkkhzwfy36gefbTBxzDcRxhcqfH
d4TxJDIFoZNCoX1FOKQoUcBn2S4DWjgMGAxADWzzlW1MYjSyY82wI2w7EJpR
SECy0DIJtCs+HUcMKyvgoo/11Cc7nM7dzxQfonLGWMKwpcluFXHYd4YrNScj
VatRqXSOdWpbQgb4sxYrYezioCgjWPQz09DbRRmrtLjYVYnQWdAEFQNhmUkI
xgY9gW9BMXpZEAB882JQk+hDxFiyopPzU5oMHcqsFoFAI5sFsdkzGDQoQ9hv
YTT4QVk1QiUDK5Fwb8FjFwPBUYCI2ESrCA0TUEZ94SM0aEXpMjL+MtoGhqAG
PEKfm8aqAZ8fg+7sAHOX5oLRRrhNB0JfZGoNFtwHLyNYoO+JbaXDSvnUY3wu
Kc0SitDNjdZAiErYOIgx9cmehGieCILRTTtA2szUE7M5MoayWxnC6kFZTMKC
kLNaUKmoPWFYwofyRliiYjApitLL/RjemFbAKD+ruwjonaCEA7AbzJtusyxV
R5ieAWPfQmkBwlMTiccQWkthcVicYDCWgy5+AI6DLkpqyoKuFT/6wUowQLoI
Qs8xsnAuJT84DUinRU5PMZiMJVtGz9izggG9Fa3Sgd2mn/2o7+U6yaH9PZSv
tjlPrh8YBWBt+0nP6qCsNJmLUFGpHAOCfgNhL2wgrJQxDPvSIDni6JckDg9+
JQ4PcvQrEWNdMKMMPYQFDjTQ2mXcItSLlA3AcogEJh2YzqfHaF9DwPhLvwRt
GypKigUi4HCJYUxqlEOQtr0D58yZ4mEBwJACOMxsLbsEzJBL26soa4ymUw1w
TATYnPAPG9USNlug5cky7T6hv4BZdIZDlP3lcyLsF2krLqDAGNt2otE0nv7V
4U5ZaUFqckpKWmpda/fLB71dJ9QNxo5CAsTCpEZlzExrB8oBYwVlsR4OkD+5
aoxVuE+zDfTDDPKFqSPMVxo8MjYYLAgtCWaXV/KSn86CUQlmbuPPoRlZHDqa
8fN9lhGLQjGiAYKCR5Z9tu9YbSHwOjQOocOFBgUEq/7PKdCWNDNJwvhYA7Ae
HdfK+CzYMa7sK9B1xp4UohKHQkRZFRRQNNpRQscKol9kC5+hQBls1XjabAc6
dZd0k6JsBETKnMH+gd5z6KlBGPmyqhhhuabZSIelYvTz8KefvEUgeyhMJsoC
wlKEkcznPufzT4gUIMxlh9dS9c5qaHReLO2FPeEnRyS7a6JQCSHYT9GOXxog
3cy/OvdRhkPyefYTzOxDwEQWVE6W7gYkylJ9BAtwicJy0e0XSoM1LpDK4GMV
JlAaTB/C7kwwjG6NdHhAoE8T1pr//W12pP/nz/5XIvCUEiAaKEb6LQz7EnwS
kCbEjAG+YHa7+yeewD/rkTji6BcjDg9+JQ4PcvTrEArtHDrwjwoiIq0DhLGf
/+Rd9iR0oHFOJ85+ko6eokZkZsD87G0JZA9lG5mUTREIvgKJjdH82Cc+acuf
5YygTBTG8EC+JvWFt/8gSgf58jCdCfuZfybVgMAhyM+fPPxJ/hxxxBFHHHHE
EUe/IHF48CtxeJCjX4dIMMherUA7SshpbVYUD/st9NMXZrr1y61/cXVDYEjq
JyYpWEp7tViTxDR9xUSsGV0aZLHhHmsmmZ6kZb6Q7oBP+BRFv15hFeGf8BII
Xv8VgTD4F8MQZlaYcdygzCoSlMODHHHEEUccccTRL0scHvxKHB7k6JciGBrK
2voAhxsQg7EA1J9CQuzrPYx+8596wVjRLwgDc8jrLEdaQHAXs5FLwMYsXzEa
dZMoBc0be3kOJB99Ew0AhgHf/jxxNnv/IuBlHg6I/2QnGrAoKiAvDvFxxBFH
HHHEEUd/SeLw4Ffi8CBHvxahAaAPo5e9kB8oa5XLP3WAMespGAiGsh1bGMSG
LB8cggUulGMtbPH/CQINXG+CUedisDYVYbyBDGAMQI5wuQ366bHApXpwcRy5
IuzLQjBKYPRKNLiH/yfJ/DO33Vc8iNIw9xN4DXgeYT/LEUccccQRRxxx9Fch
Dg9+JQ4PcvQrERUjSi9aJ1EV+LMwNlJfXVFVVdU/NIlhzLI7+AFX9qFwjwd6
Sxa4Jx4LQVJL6j55u2hchrESp06OoPNi+cwgkGQt9aM4+Voo1p4h+H8fRmMr
BrASjyKsXTKojQ7odY7/kXOTTZ93j/my2DDgJAhmIeQ/D7Jl4OznTVQ44ogj
jjjiiCOO/kLE4cGvxOFBjn4lYjYnpz1tnqvDlBhLUJhArTeZLfowPk9ni9s9
vKEhDEQtDOzys1LDaJcj6wHo/qJ2lYGbazJoj4kdZXv6ICSk/XooTA5lHXH1
Keryy86KgbCU5JP18+PmMD87a2r9AoO36C0KsYCkAnKhv9Lp0xtvwp3uAhcA
opRcUJaXkJYkU+TADfZYnCN/4qpkRdtyxBFHHHHEEUcc/YLE4cGvxOFBjn49
YgGf5+uEcPVvPFFL99AbcWLb/HCL3RG1uX8NYQ9GO+lolEce/hV4SAVrT2+W
/4t5C/HTUIoO7yTeQxm4x8BFP/kK3LzdFxBU+ak0KB2/irECXZFPj8B8/dj9
AS9UOLR8S8bI0vvAQ5YYUMnKCPl0iYHVzE4vGAuBgq/UuQABZw2ToiMOQfNB
obGkwd4rlcaUX8rLEUccccQRRxxx9KsShwe/EocHOfpVCUcf4+3l//4jrG1w
kb5KABEfCXJIYDUy2JuSHJ+SmtnZM0Be2V2eKq2surp9Jc93BhhnZ2Wyqrbl
zoOn+fFwVVWcGx8fn5VffHX7SCa7vTje0z/1/vRSU5AcneS6un1emxmenF5/
e7qvLHDFxSdWNXa++Sg/2vRQz9js6vP9dXluSmxSavvPYcDK3cl2XnpqfFL6
8PgCyT8JIS/3Vwtd6bGJCaWVLe8fBKpCkNGhn5NzK+/PD1WFWTEJiZUNbR4v
fmtreTonNUmr16Vn5OTmFcwu7sKoUfyUasz/2txUl5iYmJGZMzQ88fL6QWb0
fn9WVZSfkJCUk19ydf9CPO9bmx37OTDp970115clxcUXldbAWzjimxodTEsC
QktvbOm8ubuFwvR1tjQkJcYnp2UNjs1AuIwdbs4B2fo8z60VBc7olKOrFwx9
qy/PSUxKycktnJqef/V4YdVwxBFHHHHEEUcc/brE4cGvxOFBjn4lggvlSJ8a
8pESoVWHJ0AXG3ndC0Mc8e9VOUm/B4VFxMTGx0X9+PEjPqsMJLK/NPS3v/9W
1jgEVxQiyQ5liNL28oHcnm4YlTKhypicnGxQS4VaB45uMKy7wiWRaCIjHCqV
whGfcvfobcqNDRUr7SaLOdwZ57D99iMkr6KRdJGVJEYJ5XKz1WJxRDmNmlCJ
PCcnz2k1hdsjTVrl72Gi4ZlVsjy7swMiYZjGYktOTJKLBeYY1zN+2DJWnOAU
SVVmi81qc8Y4LSBxV2kruD7R16pQKU1Gm8Vh1egtLd1T5EJIAC39Pk9xejxP
KAPINynaFizRTiwegMLeHW7oVRKxxpiUkgyKJjOGn109gaS6Slx8schmjTCa
LDHRjuDg4PDEgg/inOLBlvIwnsgZl5KakhDGE5Q09OA8vT1kRpuDwnhx8cmA
pb8FhxTVdBDVgQ13FIlkyuhom0antkYmr69v5qc4+Ep1enp6hNkgUpt2zx9Y
MbXcukKOOOKII4444ugXJQ4PfiUOD3L06xA7ABL36/lubBpVYnoZCTHe3z3u
m9vbW6Bot89vXoDzFgdbv/8RlF/dSb4z1Fj6j+9/NI8sgeczHFpDlIt0b71e
7CpEovK2CZCBK9Ii1US++shwyBeTWpqYVwm+znVWh4aGWqNT7l8pNNpUlPJD
IC6pbUOJ2ElXpElscOAuRwxrLcoO4gnLG7vw8M73u1ibNkgga+kdBSl67nY1
Yl5MdhXO/+uVWSOyJuWR6NVzvi4VCmq7JsGP5gIXSKGsrpMoms8VY5PqrHfv
uOvufGtSJFeNrBzDzXDIvWX82O2OSBRc2DhA/tzf3vl/2HvvrzqWLN/zX5g1
89usWevNrNfT3a9fV3fZe3V1ZUF47w7ee++9FyC8996DAGGEJOTwHiGEkEAG
hPcgvOeczJxIH+ecWz3VVV01qlF81r0oT2ZkmB2RmfubOzJz/wgUcpYZG+gR
dO9MRAf+TkK8XVKKW0CSwcf19va2mQVVZ9RM2ObidGtXtw8rB+BHcrCn371s
eprr5vzs+hoZH+x4UGRsbfeo5zVGfemxoTDF1M55cHwObJrof+zkaBsUkbS6
e0aGC99025jbdY0ukiYkLudmP19gBD+vFYFAIBAIBOJbBelBaZAeRHw74Nxj
brSsuPwaHuSXnlNHBwRnhnu83Zz9A0K8ffwa2/tAsrK0SIeA2JNLOjWG46fx
wR5h8cXg99izaitX98mFrziBDT6qsnXx2jrG8aN5Hw/7sqan6xtLc1/mV9fX
ihIjAyLjgLwabau0c/N8v7DPPThYmxPtEZnI1kzU0VRo7x25snUKftXlpHoF
36VDlqDCJRn3Au9msk/YCYFAi0gk6/Bl5IWTk8vzvvGV5fm5ubm11cXYIJ/4
rBoguBqyE3xCo5n24kR3Q4FbQNDcPvnc3sLkoIuXV+/4PF0y9/oX7Gw7NszX
xTv4aWf/wQXzxOLm7DiwSWVj28b66sL87MrqelFKZHAEqIywr6XCzd1741BI
Rxg/DbQ5enkOT6+AzOoLkq2cPWrqn2xu7eH0vNbL3eQw/5C4PO5pQfxkzcfF
Mb24AajMN72PrZ1dB98t0abZXfwU6Obgezdh8NUY13N0W5AcRCAQCAQC8S2D
9KA0SA8iviWgry2ICAw7igkKiEotpNfsba0P9PcOdT/z8nQpaekE0iMn2i80
LZfehX7UrTgrxjcgkUy/v+Dt7FD9cAisz4r2D4/LBxJpZ2Yo3Nc7JDw6LCws
JCQsNDTY18cjMasQaKKR1jJXn6C5rxdAGtFCrz433jMidg+ITeodpC+aytx8
IhZ3LsCmhtwk36CI/QtGqN1Pjw+OTCXoV40Sl5kJkdHp5eDn+MsWPw+PiIiI
sJDQkJCQ0PAwDw+v0soHIFlDdpxvyN39SyHdtO6Wcpeg4NUjMoPZiT5XD9+u
0RlK4ZIKkdNoq7PvEqMiHBxdXfwCHjzuAWs2Po6H+XgFR0SRDSJbFOrn5Z2c
kQOSD7ZUAz04vbhNG2d65KmHj++rT8tg+fJgoyIv1dnZ1dHdtaCkdu8cJNmP
CvSgA4sEU5wwITjgXjpp3omuBnuvgIkvuyLG1Nin8cGI4ABrB5eA4OjOgTH6
lT50YPFvN1gQCAQCgUAg/pMgPSgN0oOIbwjuIUFGVgirM6Jt3QPX9i8I7psL
ooOYsICCxpcgWUFckNfdVFq80JGprLgAv7spdGYFCcERiaXnp1u+Hq6Nz0fA
/hszo76uzjWPezbWlxbm5lfmFtbW1nb3DoDC6X9Y5u7t93F1n/usHtCD3hH3
Ns8ZOfayqdjVP2J5h3yFS31eindQxO4J/c16rDozPiwyjak4fpF5L/ReSjnI
Z7LzoZOTS8+rifXlhYX52YUFUNzG3sE+gWM12SkBwRG7F8xTd52g9KCIlUNS
Hk5P9Lp6+fZPLHE2IeBvBZLvnHldkBpvZef4tH8S21vydHGsfdy+s7oMWrQ0
u7i6urq3swsS9zTWuLj7fF7YoF9SOjX8zN0nYPTTIvPGUZzYWJlpLC2yd7RL
LmgEK+PCfGIzyWrT7zUVYXvhPl7x2eVA6L3tarDz8Ho9uUlw36wgcxC9HupL
iA6wcPbsGZlkX2dKIEmIQCAQCATimwXpQWmQHkR8Q9B6EGLuXa+DtUVUesnh
mZCZjHixE+rjmln3GPzqbCg2tXHpGZuh52quTA7Z2Vvl17TRMyTHOhr9gsMb
y3L9g8JpHYefbkf6uwXHZkNPujFffu9rqXD29p1c3eEmPT7IifMJi905F9Gz
Vdubyj19w5Z3zsDm+pxk34Dw7XMmcFeVGR8cmc58wxATZsSFx6aUgB9Hq5/c
nZ0yyki1Rc2nZN6WAxbvZyX6htw7OGdmura3AD0YtnREbvo03mnr4N47Nk9v
wtiv0l+cHG4sb3KfVoz2tw/PqcIxYUyAe1BCLqfU6KcdgWzubCp3dfP6sLxJ
t+jDyDMgM0c/kzJzfXmJbjVBatsEe7cIsEdzUbK5i8/02imd1duuZnMr+6aX
oyDN2MtGey+f0Y/MJxFP9nfWtnaongLN3XO1sc9mAotcKBOBQCAQCATiWwTp
QWmQHkR8S3BfQmdfpYITz1vKTays/MPuNbQ8ePKwNSP+ro2tffPzPpDmfGc9
NsjL0t3rQcvDp63Nvm4OLgHRq1+PaVEpOl6/F+SmZ26ZWljHBcXe9T6xtrYM
vJfS/uLliycPIyOjnnaTn4fouJ9t7uj8bnmH/togKL08JcLaJ5gUfZTOe1yb
Y+nsP/f1DCxXpMTYuwVsnzLngbK4MDf/e0KmzucxId6B93LotrxsKDSxsE7K
LOx42d7aVB0VHTc2vQx2KUm66+jht3fJfNX+5f1cE3ffpYNz8rsVi+99XZ2D
7iY3N9SPDJMP6GEY2ZwPg20uzh4ZxZV9Pb0Pa4ut7Z2qyEmz2Lv+5zZW9mEx
qaBFL589ioiIeNE7TtqtusDSxnFqYY0Wy+97Wy2cnEcX97DDr8HeHqEJaR2d
vV3PWn3cHaPTSoChj1a/BDo7ufqFP3nytLWuzNneLjwu9+CUnAI6+KLKwNa5
d2KFemUN0fmgwt7Zrep+w0B3f3lOmq2Ta+fAFPTwIIoPIhAIBAKB+EZBelAa
pAcR3w6sGMToz6mzH5Ug3vY+jY+O8Pf39/H1D70b97ijXyRixMfxznJBehK5
yc83IT135esepSIxOsjV0VzjHxw2NDHDBwSBJBxuj4kI9Q8MCAgMjktKnfr8
BWx92/0wOj55duuQ/WQ81l5flpCZt3/B1Gq4veVecvYmOaWTeF5fmZiSvXfO
TG19VFWclVOJMRMtz6sLsoqqmwi6/hje9eRBeHCQX1BgYFBIWm7xyvouSNZW
V56UmnUgFNE5vOpojE3N2DpjpsuOdj0MDfJ1cnMvqG1mbYPtba09vF8aGRrk
HwJqHlZZ/5j6miHJ+6HnkREhvsGBgQGh8UmZU5/mwcrXnY9iohMWN7/SMbu5
d/3x8fGfVneI85OR9kexkZFBIcE+AYEpOeXbBweUzYmNuXdpcTH+/r5gfWZR
5d4pY+VPrzruxiR9mF2ne2dtcba6KDMkKNQ/OCggNOJJ+yDzPlgUG0QgEAgE
AvFtg/SgNEgPIv4uANrq6Ohod3cXl/rqOb3p8PDwT8yH/ru3t3dyciKd218D
UAqouZD+yMWflv7s7Aw0Cl7DLe/s7JyenkrvBYoALfrTa7W/v39wcCBtAWDJ
4+Pj/9caAra3t+nY5d/GjAgEAoFAIBB/IUgPSoP0IOLbh5Mb0GtV/ovz/GsD
1/xPbMUfSwav+VOW/1jOfyESmSBJiEAgEAgE4tsH6UFpkB5E/L3wxxTHn6FE
/j8RL392oX+KuPvPZv7H5PCfnQ8CgUAgEAjEtw/Sg9IgPYj49vn/gej482TX
fxwi/NPX/8eV+bOrh0AgEAgEAvH3BdKD0iA9iPj74q8x1/GvjYRM+0/ptf+U
cvwzavWX54nEIwKBQCAQiL8XkB6UBulBxLfPf2qm6H9KnnzLWubPewbwL2zR
t2wQBAKBQCAQiL8QpAelQXoQ8XfE3+A1KX9t/pRK/sdvifkrKcG/JM+/8ct5
EAgEAoFAIP48kB6UBulBxN8L/4UvF5XO9rviF58WpD8h8Zdk+B1aEoFAIBAI
xN8XSA9Kg/QgAoFAIBAIBAKB+B5AelAapAcRCAQCgUAgEAjE9wDSg9IgPYhA
IBAIBAKBQCC+B5AelAbpQQQCgUAgEAgEAvE9gPSgNEgPIhAIBAKBQCAQiO8B
pAelQXoQgUAgEAgEAoFAfA8gPSgN0oMIBAKBQCAQCATiewDpQWmQHkQgEAgE
AoFAIBDfA0gPSoP0IAKBQCAQCAQCgfgeQHpQGqQHEQgEAoFAIBAIxPcA0oPS
ID2IQCAQCAQCgUAgvgeQHpQG6UEEAoFAIBAIBALxPYD0oDRIDyIQCAQCgUAg
EIjvAaQHpUF6EIFAIBAIBAKBQHwPID0oDdKDCAQCgUAgEAgE4nsA6UFpkB5E
IBAIBAKBQCAQ3wNID0qD9CDi2wEn/ycPLiFYxOk1QjCuNtc3hCJ6q2R68N/6
3NSrNxPUJoxOcLy99PrV6AVGHO/ubmysQblT/14ejPQPf92/YFdibH4YLpYS
/GQ24bhIMhMC2pHNBKd3YmvObTpYn21ubFneOiSTYVBFxYvGcT5nnN8kxLHz
h1VFnUNvqZrgzF4YbwumMhgubh66JFB1sAEnm0DZCyxwycjVbJVg21KlYxLW
5tYzNcQu2ltbRkamcKZgDGoRbxmcz4fZRDeBMYOYDdlyqSLa62taHj5hdmQs
S2yvzK1u7YOfIigl31y6OK6qGG1SMJrYJuMioWSbMCmDQyalFi525itLCj8v
7zDDgPrLVBXjSsSGO56/eN4FlkQE1zSMHsizb4ceNT0+E9HdxxWAsbWmO4Lv
AozOg2oOzianCxpqf/HsWTfcM3RVhfR2XLrTJEY1AoFAIBDfNUgPSoP0IOIb
gvZ6GdkC/rl8XFOZlVtUV1OekZX+onOEFEcE45AzMgHHxntby5qamE2UY/91
Zqi0uhp4/q97mnNK6nA4e5Dt0XplZvHSxjnOqTecyhNn3HfO96ZLwXiBRy4s
vO3RU1Vrbh+n90sLDohJKuKceVqi4pSn31JXOfJqDiy9ab//462bjwemGCVH
XEK6DGP2xVihh0Mqlan6vommjE9CLq2hmPpgB+Z6qt7h2Wx1cWYvjBZFIl4g
8zqR1YxU6RglqsBfeistcpicMDY9uR7DWbkEUr7pftpS/4xcEu5oK91yCYtj
Gk4LVZwXOJzWY4rgxRqnBeE0XMWYDvAxUDOzcOdqfnG8G+zmoKGpraWpauvo
M7fwlTUUNGpYVcVoKEh78bKUl328lqSt96g8WU5eZXLxgFov5LISznUrK8jU
90+xCRmhDesssMHPTFvV0EWEsx3K9R5OlCW6XZNTXdq8gO9agHw6WxrbnvcS
GKv+qCxFdCnQqF2eHKuqqSZ3wIhAc21FQ1cJ5U+wVWXrwhUtYntWJLUDAoFA
IBDfI0gPSoP0IOJbQixahF0elOel976bPz8//TIxmhqfODo1B20naKf9w8jz
tp4+XHi8vLxM+9tbs2MNjfUnQiHY8WD/hJI32NfNlc2tr+ROR1sP69oOT0Tr
K/N0tIiSP0JCdDY/v0jrESHlPl8e7ayvbwLpxDnTIPu5sY7f/OP/eVPP+gwj
d/O2MnL1jmfqc3HweWaaiiJhIuGmuYra3aRmcvXpwdLC4t7xGR3Y+rqytLS2
Ryk1UNAZ7fxvLM/uHV+S1aCFhuji8/QXSibhGHbgbK4VmVkOi8T3XTV/+O1/
V9Sy2ji64MTV0d7K7NIaLRYuRHRw62hubo4WCAvzM7uHZIvJ5giZNi3OfrnA
+OZdHu7NfZnlhBsUJaTjekSql5W+vjsti1ZXFla3t9kEwpmZGVanYCe7G0vL
q7yyZhXKwvSXwwtehgNrYNjRl4VFWMXsb6/uHp7EOds6OgdxfZ17z+Wmsuar
iY+jHS2Otjb9Y19wNhL35dNnTguBbE62N+eWlglWJJLtPdleWGTDxGD98dbs
3DIfAWTU2WWoreH/8k+/Sits5Poa/AdasTf3ytxA8+HgRyHGGG1pbp42yO7m
8u7BJZ14d2NjeWWT7EEq24v9za3tfTqT44OvC3OLQiEpq08P12cXVyj1SniZ
6di4hHODH2xdm507F5E5r67Mr22d0IHXtvIkBQ2t7RMyq72ttZXlbe5Imfk8
zfcR8/fiy+y8mKRlekAsAIpAIBAIxPcJ0oPSID2I+HbA2WAZJ69qaorerxzT
2x7X5na8fj810jH27hP4ebQ529r4iMBFa59H0lIT7t9vKSkpKiqs2xURBysT
9xvrgOJZ/Tz2qn8Q5Nb3rLW0pLKkuLC9exR4/o0FRdl5xZVlublZxQvLQCRi
s1PDOXnZpaXFJeX1uxfE0fZcU3lhfm7es57h1fn3dXUNh5eMO/2u44Gzlam8
knp0Zj3YMdTJJiAiGyNEuQlB2tq6Wpqqlk6ee+dYcXrM7es3lBRUkwsqNtY+
B7kEz64eAj8/OcRHQ1VHXV01IDQdtOJg61Ogp5uzs7OZro6cqqDt6XtQ2/sZ
sbraOtpaqromjp8XvwIP39FUIyqzEop84SGuDsGBIb72Njml7bSwqsmK01TX
0VBXDY1MBhV7VpHtauVgpqPlHBAJVEigg4WalraGsnpaHql3Pgw9dre39fDw
0FNX1NSx+TALlMtFQqiPlra+pqa6jXPwyTm2OzcU6Oj9fu4QpM+LC8ytbvr4
ZkBDVk5eUc7RxXv/9Dg9JKqy8iXotMn+xwaaamBHPSOL5cWVgaYyPX1dXR0t
b/+7x4zaxPofVxkLtAXaOiraBg87x8FejdmJ9pa2Hs62sgqKHgFR50Kyl0uS
AxVUVK1sLK/fuBUUmcgJnwRPUxlNHU73AGH2trvF2dLc2cpeW11F08jm89Yh
gR3f9XPQ0TVQU1XwCok7JZUZXl+crKaiqqah6uAWAnZsr87U0tLQ0lXz8I89
FrEBNYxYmnjqbOkYfzfI0sKB1OAEvrP2wVJfT11foC/QklFW+7BxuD7xwsPG
ztXBRVVV1c01NCshzkJPS05Zs+XJMMikNDk8Nb8S7JsdFmBn7WJtbXhbTjGz
qJog574W+YcngIXO2mxTfUMdHa2QiMS2inx1GRkF+TuekSn72+vJQd6O1vZ6
AoPqyqogV3s9PT1lZdX86i5s96OdkbrsHUUtI+uxsfW2muSEzAIqaNhlpq+h
oamrqit4MfQJNKStKsfe0tLT1UlVXt7RK/iInD56yYWD/wbHLwKBQCAQ3z5I
D0qD9CDiGwIX//fyuL4s92nPqy+zHzse1aUkZ+8cnvc0VnQOjIKN6wtj6akF
wA9f+tiTmpI5s7AiujguTk9vaO3FjpdrmutBLp96Hzc1PxRd7EdHxS3tnRO4
cB4kE56WJsfXPu44Phc+rMyraWk/O9oqzsp/N7MFcntaU9r8ZOBybyYiJPTV
JBlZW5jsLyyr2b+g53QKR59XOzr41RcUyMsq75yLUgPdvEJTQX1qiwu7Rt5t
Lk6q35SJTqlbnJ1UU1AJikibnpsf76qWu6E+vXHyovTub6/fftQ9PPK8/saV
a1k17UAR3v7htwYOvsOjbx0Eykb27kBaNleVPe16tbm5qKsi4xSSBergZqId
kVVK0E8yYrhoZ9pUWzB/JHqUG25lTwbRBlqKFeRVO15NH23NaCkqNXWNdxSE
/fd/+sekzOqlxbUEb+sr8lojrydaiqL/cOV6+7uFjbfPfvPvv/aNzXzzZlBL
/pZPTDZoXU1R8fjHlflPA/IyN9PqB04Wu3XldUamdsCmABcTe9+7h7s7bpbG
eoa2I2NvhNi+vqJaeFIbfrGmK3PDxCHg07sPQMvMf3mvcuWa770q0fF628Mn
Z6zm6n3SWH2/eXdnM9ROoCYwBauyPCz+9YebjY/bu5sKrt9SeL99NvWy4sqV
KyW1zyaGBowU73j6xBDs5NmFyWEdRZnf3VL084sAchus6q5J/c2Pf0jKrvn4
/pWx2i0j52AhflJZUDizuDM9+vjOz7fquz9tTj6/+oef7mXcf/+6vaay/n33
QxUFxfoX708Ol01U1cB6drxh+Xc93AJTQVmmOrovRldB/s5majc0Td6Ojj/I
vXdHUeHj3sXX3rof//XXYekV4yMv5a79TlHPrr9/0MtcS83UCXRKoJ2+qWcQ
yMFBTeaaoqCrfzg5wPaOqiHIvTLFU1ZgA/JUuX3TMbCAEB4+a3u6NP3RTkvV
ztV3curzxeZnrau/va5hOjw6+XmkvbKi9uv+QW1G+HUFra3dvZoUL1U93Red
Q4cHZ2EOOpbuAeDYMFVX0LN0nZp8F+5ielNBe+9C+CDT51e/uVp2/8lQT931
n+WrH79nZhfjv/AoKAKBQCAQ3ydID0qD9CDiG4J7bo55NvCiriQvrbC8obYm
v7T005d1sLK9obx/ZBwk2F56X5pfi+P459cv27p76QyWJrpqahuO91cbmx8A
F3321cu2lhYwzJtqS9Oz87oHRsmZiqfbzZWNp0JyLt77gWf1zwa2FiaTkjNG
R0fBMG4sK6hvfrKzONX68AFbLeaRPXru37veOk0Fk63dC38rLd/o/OLEWP+g
RHrO4f28xEBvX6VbcpH3gFAlLLX1y6rHwT4TXbXaSkYrW6ce5voeAan0Y3Zx
fg6mVhGEaFugbNDzeoMMC+aEGds50QU1lWUG+3mrqsi7h2WDn05m2pGZpdwj
eG8eF9++JpuSkRnkYPKzqi5YWRDtflNdr7ikrCA3Q1npTlJN15OMcDMTRzKU
hu9rKchnlnUTVGDRydgg5F79xtQTbTXrrTMyt7gAB4fAKGpa4WVhSkygj+cd
ebnU2p6ztWErXcuxj+Skxwg/J7ege6D4VH9XG9toyhQHVjpGOZVja0P1SrJa
O2fMw4oEcRbuaimjoBIRm8u+koV5b8zrzkehASEm2kqGltbgZ6Kzmat7GGXg
LVsTyzez+5mhDjrWQfQs01RXGwenQHYkUP1wtpt2N1Dm+lVZBc3pzd3RhgwD
SzOCevqurTxJScGcyuo0815YgKej4s07zwamihN9dQzduc6riQ5QllcoLCgt
zs/TllV09YjCmScoL50N1TQEFjnZmTLXrkXnt4HWqdxQbH5JTWTdmTLR1xpa
PvjyvNhYw/CMHDmX7laGiRWtINfmglh1E0eyOV5mDkHRoBRHDfWMkjbqdkS9
kaGlCCOaCu5qm7kBLZ8SaHdbXjksMk1EPWHqa2YQFpVP1m7zg5GCUtnzcXrA
rc+M3g0NcrE2UtTQXzzBJ1ozDc3N6bfiRLqZu8dknG1MqCgpf9oXUc/Druqp
KHVMbDan+lm7eVFPCx566JtmFZE9LuIeSEWSEIFAIBAIpAd/CaQHEd8SGK8H
MRwXHt+vLnkzv4lDb9h42Vw59GYSLJ7vLVQUV4I1n0c7W9rb6bmUX153VNY0
HB+uNbWQsyLnhjuamxhZN9b5NCMlubbm8fnpWWvFg9VN8nGsVz2tzW3D63Nj
6Wl5r1+/6uvp7e/v39g7WXrb39pYxz5fhnNvIwEu/fuuGi1Fw8/bFwezvbqa
Gpo6RslZNdjFvpOBrsDE6enTLl8Tg+CoHCBmjdUNCqvGQCZTPfc1lQxX109d
zA29Q/LpBqaHeRibBxHYrkDFsKVjniCEBckhVh7eBHYe5GCkoW/V2toe6G5t
G5QKNjmZqUfnVlPzQsmKJPg4yqtr+Xv5BXi4Ksoq9L1fqs8KVdAyvV9bnZ2d
XVfftPb1sjTU28rSkSpqU01BpbB+lH7dioepYcDdaqAHdVTNphb3wPZwTxv/
+Gzhybq5nqqFnU9He6+VudG9speXq8Pm2ibvl05AFmnh7g6BkSBxpLutA6kH
LwjiyFLbMLt2bGWwTE1Rg5xPSz35SP/XWpUv0FDS0rX9vHRAGU6UF+olp6Rc
UtFQkRxiYGkBLJnkZu1o7wsyP9/+ZGZoOrFwlBJiY+Jyj367ZpqbjaNzAP1e
GurdN1TbqV4wUJH1SnvwuaPW2NKU7txHpdHaus5L796Zaaq5eIX1dHVba2k9
7J7KifE2MA+mXlZDTkWuiPFVUtSsra0uyMmuqq77+OEL/QTi9uceHWUVeydP
P19PCx01c2f/y/NNLTmt573LZAV2pkwNtPtX9qbby/TV9FZOyFHh6mgalV2K
E8KylCBNS2eQf4KnqXMIqZRddLVjUyuAFUYel5oZ213iWGN+hLaxzQU1G7qj
sdhQW1XZwHJz9zDcTD+MHCqEaOudiapqzZPX5IzW2hwFBaX45Jyex1U6AtPF
A7y38h6pfKkA9T13c6+o7PP1UXU1xfkD6ki53NDXlH/6br01I9TM3oV6KnXD
VWCSVz1Mv8GUHm9IDiIQCAQCQSA9+EsgPYj4pmBfCkL5vpcHVcXZw5/WmXWE
UEjgreUFD9rIwMfwy4bYe1lAVnwZe5ZXVkkluSzKTHjwdITY/1JL6cHpvkdN
Lc2nR1+nPn8hE5xvJETHra6utpbXLW6eAh9+6MXDigfPTnc28lIzZjZPmTdq
YuRLYxpqq+gKne/vzMx+EbEfNxjtqJC7JRh6twGWK6I8/9f/6x8zavuPdyau
/vvNrqmdy8NV1Z9+DojIBrXVkZUPiasAyd50Vive1pnbPm7M8P/husLEzOri
p5HbP/8cU9IqPF1QuaVV10a+ESU72svUNQi73Lx27WpV5zx+uaenImPmkwRy
sBaoBSQW0Hr5eGtCUeZOcesYHSsMtRaYOse87XlwU0al990mSLA4O32JE1ne
Vkb6VnQTQh30ZVSMNnaOhlpL/3D1xuORuZnh+3IyelOzx+RcUGdjv8Sys7VX
v712Y+aAOFx+c/P2tejSDmJ3WvHq1aLWkel3Q7ev/eQZlQ4yi3S20NSy3Tu8
IPA9ExWtmPTn+NG84vWf3MNThfjZi4et3U/bG2prQKGHS92//u2N5nZacwkN
5H5wCcsCS8E2uso6BiBBrL2RmRkZDz3ZnNDXNhiZP+6uSfzDj7JDUwsrXyYU
rv9s5xrKPN8nPAxxs/UJTtzZPwOmU5aTSajoXBl9oKio2Nb3/uvGvLbcdd/4
8vEX1T/+Xu70Al/61HX99z9Vt72bffXgh99drWjsOz9Yb2l83POwQlH2VsvL
CYKcbzy9tXdCK9gUH2sVbSt6BF4u98ndutM/OuVirKJn57d3dFyXGnHlp5/f
7ZzPtBVqyWksHJO9YGcqCE8tAXvnxXor69uDHaMcDax8yHCnjbJSWHwx2NTf
lK+jYwz6oi7LX8nQbn9vp6K4gBxEe2/+cPX6wIeNaCuBpVPg0bnocvWtwR25
0oYeYKswBx0ZPRvQuY/yw357RxHIz+GGRFlFlQ8L5I2RMEdde+9IDD81UJKx
8oo8PbvICbW/Kqu8cywqjnLSNbckb4yI1q00dLJLe7l3Af31DlgEAoFAIP6+
QHpQGqQHEd8Q7Ifw6Ef1iMujxvsVE3Nr9LfkaGbeD6cnZZRX1ORnpVSUNYA1
G/NvklPi79c1lBfl5ZVWn4pE2P58Xl7O9MbRyuRAZ3vP8d52SVZG7f0HlaVl
D568uDg/fdLwYO0r+aqN1/3Pa5vaQCYT/Y/jU9IbGhpLC4s+rOztL0w8aW6m
henk8LO4+OTtE+bdmR96HhhqWo582iFrebqqo3onJrcZx84jPa1UVDVdnO3V
1PRS0svA1orE0J9v/eQTnj7e/dLc0Hpy8ZDAz/wcLVW0tDQ1VOzdwkANDlZH
zTRNH/ctgdaWpkc7+vjhOJ7q76qopObk4mykrUF9zAKLD7BR1rJe3TwG2Q41
5+rqGS4fMC+X6arL0tIyPsOwsgTf20oqxvq6RqYuK7tndUlhtg6etN0Otj5Z
GuhoawmUlRXDYwvIhj8rM9Gx+bJyBoqLCnQNSsoh8EsvaxPQBHcnez0d3YK6
Tpy4vOtlK3Nb3tnFQ1dbJzmrACSe6m7WVpFVFti8m5oOcXBMyibnTLbX5Cnc
uamnL9AxNm2qr/N3NtfV0zfQ1fEOStg5ZfruQUm6nJKyhaW1gba2h6cvWJPl
5+zmGgpacbo17WRp83hskcAPQx3Nbisr2dvaqaiqx8YVMVrm8rgiJ07xjpyW
wFBDVcHByf9SSEx2VSjeuW1mbqOjqaSrb7e2fyk6WnKxEihraLs7Ompo6Fc3
9JCRzRBPGXklQ11Nc2uXnVPiQXaUnJwCsJKOkVX/K/LlnEBbuZjrh8YVMW9D
xUQOxnox+a2rUwOKCnJa2gJTU1NNfdPlg8u57hoLgfnysYgQEZ6uVsmFVeQc
1OwoEzsvkE9igL1PZCzIxNdEPymrTkRgr59UW1k5iTCipSwW6L7Tr8ve1gId
XYGRnraXb/S5iOhpLZaVvW1k5zM/NuJlalL3+BXYfaLroZ6yusDI2MHU0NzK
/sPayen2Z2sdndty8i/6eosSAz2CokC573obNFQU9bU1FJXUax53gR2L7nna
u3hRU0O3vMytS+qGuOMK+otAIBAIxHcN0oPSID2I+KZgv2zOeLCXFyeXzLcJ
Lqi3YpDfANzZWn0z9o7+cj1Bf9kcO53/8nH87RQTD8GJ9cXVrR2gnrDz0zNq
zcW7N6NTUx/p7Rdnl7S6wzDs4pJ59eLh9vLr12+WF1fICYoi0eX5Bb3+9HBv
bW2NnW6H4Rcnh7t7F/xXvi92d3fp+r7u7Zld2yPnH+7tUtIC//zu1evxT5cn
ouOTvUsh45C/fz04OspW9fTs8GDvnKrN+fHJ7u5Xev34UP/03CZYPjvcJX+L
jqbG3x8ck1+L2N1eOz46YL8yQOa5vb1JfaSAWJmZ7OrqOT46B+vPjvZPD04o
0zHlDvd1f5pZwdmyjo4OcFLZECcHhzs7O7QIH+h9vr1L7nW0s4NT3054O9g/
t7YJMjnc2aIt8HV7bWBgaP/gFLs4P7k8pT8jKDzc7uzs/nrIqNTR4b7BwTfU
t+AJ9pP3woVPUyOvp8jN5ydkLxzvg6pSjbgEJj06PqUfc3s90v9hehYsnJzQ
fUf+EZJf4jge6uqYmPhMjRPR08IYYwuT6eWFgb5BLhVGXAy86Px6Sk4G3tz6
Sk/0Xfjyvqe3n/vAxPbKXEdn7/bOBcZ8lk+4tb1GvlOUTCEkPwlxfrKySMZ/
8ZOv3V39pyLywb3TC1KWHh0ciqiBeHzw9fiYDCifnZ0cHBwAox4f7R3uk/1y
fHhyTt49wLDLo+O9r6DM09Pjw91tqjTszchg3/Br9mMQ2PLMp6GhkRPQ1NPj
s3MRXcPj3aXevgH6myf7JxdkjwlPero717Z2cGDpw306Gci/p6Nz85D+wgV2
fgwqwgyM0/3D0zMhN0bR84MIBAKBQNAgPSgN0oOIbwcc56aLAr1Gec9sqFDs
0UL22+iUXmE+pE4/W0ctQE8gEtyn7thP2LOSky2LINhPmYuv5N9igkPJ2J+8
FuOqAX/BHKgSSjRAn97D+IZgcCXpgnBGCDB74NzHxTHxhhPwmyJxie/OEfSD
dxjGfcxcrJKQIuDbwM6CZavIftidfiuokEuM/5GsLhjFx+cMyQ76e/Pclw4w
qFFQLcTqicEfPCRNym4S8mZnaM2LVNbWPbnEqLsEIshQXPsxjJdC7FDhSqS+
M0kwI4T+0qKIzZ6VsaxZqOEkwqF344jZEzICzr7zh3uakimLH1tQG9kuprey
ZqcmLTP1xCDbEQT7aiPWpkKu7/imcd3EfHdQBBkEgUAgEIjvHaQHpUF6EPFt
gXOqkHWhMdpFxjn5IO7b0t8xx1jdQbvEQtY5F7F6jfTOcTG3GJNexll1yShE
xpcWj67QUSRIuEHKERIsOFQBsnAh1zRWGQo5KYqxc2ShHIRcrTCuCE5MUWlE
fIn8azwhBcRKCP4HYyuCCdixBqe+hE69ZlOi+kLohSQ8OHHJqB2oAwhCvP44
J/eYNkKZC6GP4TEikc0EE99XQjfRaWn1Tcx/fPX0yTMM7lZedrHCn7cW1BDm
e3yYWEqxcjgFSog1jet0vjJS9qGyoJuDMzcHOK1I/2FlJqv+MFan0pIQh0vB
eDMydxIITuWxL4rBebXOVoFbphojLsMRCAQCgfieQXpQGqQHEd8WlIBiXHFJ
D5bRIDjs8eKcf85thTQFpwRwbg0TRSQ4RQA9tMgGy7g0BCQzeeUlnpiJw0jG
fJhQEVttNt7EKQNImlKuPsb78LACxdlc2PIYrcHWjTMVzipZXgIxQU9JE7OB
TsrUjKRl46e4eBp6E6sncE7c8WKKjXDxwgWGNjIvTjGc7QVGBcOqiipLJG5E
yKacrQhyXijO20oEVYkdGJiI0bxcVFfILv6ClOM6nRdZGJ8S/BKytwWgTMQM
yxZzyYs+vtoYcw8BKp155Sn3mXimL0RwD/LhcnFdDN2yEEEFYLAW5jqINTIS
gwgEAoFAkCA9KA3Sg4hvCyiwRbCijJMNrBhh/kKzSTn5JOL3pbxrIJoYMSil
iwhCeiUt8YRQBSDhw4ojAvLPqTVSoUb+o3lizjy1motd8m3kRB8vx9jII18r
PgYqIScly+Jn2hJs+I8Tv1wpTOZCsVzYqsPah0sM62uxHSWrhPGl8wKQS8dP
T6W3ipimsdNq4XmVdLyPVj18N2B06UwMjrM5E+jk9TgnkFljYmKalBtLcA6U
oaC5l4R4iE1IsB2H8yONrTwUMoWGBzdcye7jY7WsSXExvQwHLgmoQyHJDC2w
hwPGtYUTgwQbmqQzRB+kRyAQCASCBulBaZAeRHxrwIpPQg/CCQjpqAfrK+MS
KyhBhEM7Esx6OEMMLlEigXj5YkoBp2UCEwNk18BBIlYdUdMsqZ+clqV/sdNi
GeXDRYi4CYqQvJTQvzgkiMT3FWsawcaSYKnFaSc4hMQmYCdLcnFDZnIjlC2n
uwhequNSVuVshYtrKEKiO6j6cOKR7QuMVYV0GrgJnIKCW8sn45/2ZKKEjKzj
H9XEJSspVh1WU7Mvw4GKgoYXF5KDZCw0hKD5orx4xNkGYnDlMbF9MXYeMpNA
yGpVGKijcen1bPf+wo4IBAKBQHy/ID0oDdKDiG8KWAzCs/LEpkFyy5QkEX9f
CcH/YlaxkSzxCInkq2NYSSgmL/hAGzwHT1KDwCKLTyY+nVCqdHoSJh9lgyJK
cPQKg8J6bOgLEmKcYiIkZSOMePgSklG4pMHpFCJOiUB14N5VAj+nRv+DSVhA
Iu6GE5AkgUzDy15O6fNtIQhIxUBvccF+YSUG61Be1UoGf3nxyuzL/uWykow1
Y/DEYHZPieZAL0Fi7YPDDWHGoZiaZuvPxC75ojGcfzUNF6TmontiduO2QhlD
ohLe+AtDAoFAIBCI7xSkB6VBehCBQCAQCAQCgUB8DyA9KA3SgwgEAoFAIBAI
BOJ7AOlBaZAeRCAQCAQCgUAgEN8DSA9Kg/QgAoFAIBAIBAKB+B5AelAapAcR
CAQCgUAgEAjE9wDSg9IgPYhAIBAIBAKBQCC+B5AelAbpQQQCgUAgEAgEAvE9
gPSgNEgPIhAIBAKBQCAQiO8BpAelQXoQ8W3BfWwdZz6MTn+eW8R8l13EfuWc
/zw9jYhZz32SHf6OO5WW+3A8zn0OnoAywai9ue+JE9wnwrkqwelxPjtmd+6T
7vxHw7kEYh81p1tBf+KdyoT8Ryj5zXD4E+3UN+L5T5/Dn44Xq5JI/NPzYhXk
zPKL35THKZgPqfMF48yn3sUqJ+Q+NC8OxhiB/eI8lSO7L2Nwptc4ezAfdqfN
wVhISHcl91F79pPuOFwuThCwwdmcReKtFvu+PNc0/jv3hJD6X8TW/xe+Gi+W
EQ6bEaoALpaWrSQG/RQfP3Bu7KftcWg9VwO6LNaIQoKxqlgbJT83z48cgrMh
V0nxqjJ5ijWNaR5vJFxsiR88XBo2f7GfcBvp5GIHJtSPEstceno0YuL5SSHV
fCZDsVLYAcD8xbnRBR/FuFhlpI4RDB5OrGHZYYDh/OHJDjDY1HBBfAPJH0Jo
FWtY7jBk19O25QYhuxJnxxXGnu3YvWCzwz3+S0akDc0Yny8CPlQhuE1wK7iR
g5Mnarh0IVso2QSmYvyZmTMgDuXMdxN7cqCylT7Lscand6ROqHxOzGhjRh11
ehPxjWJMB/W12JkVY0rkbQYf0VzPYmI7k2Vh/NHKn+65ISoUy+qXxy3TarYA
kdipg00mUQGpax1fb7BNxKXAuLZguNjlir3EsCm5gSSC0/AtEj//QOc3PjN+
YHBDgGAvX0JodGFwtcUPGWn7IBD/ZSA9KA3Sg4hvB3EviKAuYCJoWdI1FXM1
OWcVl7g0QhcsXq2IOQM4eznjr4nMhZO/KEGuNcZe8yQ9VSoFxvrh0DVXPGe4
diJeQ4nZgb5oSl+Axa6YfAOl/XwCvigTrDCDRBbBSz8mZ95y8OUecjsZI0uK
BXY3vg6cR0ruJyQI1p3DedkHaVted0OuIOvwcE6GWOWgcSKuYfm2iyfjnHYx
1w6658D5VDicgLetpFdGu5fQWMMICd8G2pExJN8PYpUVsxusmyDhyrVKotcI
RjSxBoZHHFdPtr959cfvy5bIDQxxTc35upxiZ107nOkycZnJyVXJ8YizdmZz
lW6IVPcRzF0TqEWS41NasPC6ScyXlpZFmHgdmZpLiDjOJmyevMWkciMkDgcx
P1lSQ9GVFO9hrssI8fGGifvwkuMTbhebQsTWHxPfiou4gc6Mba4IITfaYSND
vUa3kRpsvACBO4U7ptgxw57AuYOFwC8JqHX8wPuFQ4zaHYONwLYC6lPxocuV
Cw10HDoE6M0YfNuQH5O8bTGojF/SgDhTDea6g0vKK074EPxNNu4kRhC8CGKT
QRaDwODBzeTwi+d5tuaY+OGP8U3AuX7EuMxAP0qKUq7Lcfp8hUkUJlE6LlUb
1jJ8NqyZuATsbUCuSvDl4I8UhED8l4P0oDRIDyK+HXBCMsrGQnuezBUEdkf4
1PClE3J1oJAafBNYzFXDWbnB3IenNIKEABT3kSQvlLzbQC/yd1ZFUh6FxF6/
mBV/BxiqCSbm+eDiFuBs+IuxKl5b/AeVkWwIfR2H3DbOj8Uk9oGCXDhXK7E+
whiPmgvjculxrpn0grgnxtWSdZj4O9asl8NLNk6kEKzuZtZDmfDLOOS4wKVA
Awl2b/44kt4dlF4s1sx4QbzppaISf6R3mOituCn4huMEtBeGi+kgZoCJ60C+
v/h6MhtEYsUw5sVo6QRHG/kScYL/D17PloKxIoXvBxwS/1wEhy8d0lDUkcZq
Xa4vhFAvQscXfJTiv2BGqH7QVmaZn3gg1iA66kRAUTxucIqNLDHxBbUM3irk
LCZpSSmNI7E7AW39Y0cfbGchf5hAd73ElDsUiuKcc0IIjzO4qlwmnPoQwlqW
7RpKKhKcVmXrzJxUxRrLWA8Tt4bYocokho3Fnfih8SY+9ODm0L/p4YRhOAHH
4qF7MNztQV5AsSnJfZlTFldtsbL+2LlBCG8Scc3HIZuLFcTD3lhgm8oGIeFD
g08r0fZfsgg9ZsSiwBI1Z44DjKk5K/glz5aSTealMbwgPj4xgj+LYhh82obS
SJlRcoQjEP/lID0oDdKDiG8H9m4qH6QQchd/KU+VucqwAQlOp+Cs+0pdBMX2
wjl/D4cuZFSQiMuTvXqKoF3Y65eILZ2Hj0jSLh+joXCR+E1Rus4igveR2Cu9
iLlG8pdy2CAEO0uHy4qXPEx7Cb7hrC/BZI7RLrVY+Axn68x6ntAtYm5uJ++u
sGtEkq3GoXJxrmJcvUWwuoF9bCHTc5w/KR5q4TxJ8VlhVJ6XYrlBfpTERFk6
vMJOwWWdH0bzC8U6Bbpjz7u+kDvOOv2sM0aqTCHkKWFMLILdD1JnYJdL1vnB
pEzK+kg4my3OBXQYa+PMNpybMwmHOcQEhXj4gxV/bNQbx8VCV1zb2e4joGqL
1YrrenHHj20p73xy4TO2ZfzNFqi/uCFLxx0kPWGuBTjbg7DeZybOMeOZG+rM
vD5MegRCpbObJO69iIWY+U0YFy/mr/JiEXyJqA2TmDvuhFznwv8xjcX4KvIH
KX808a0QH4pQ9fj9CbE1fNAPZ/udIMPxcLCPD3thfP7sREK4zwnu+IJkEd/d
YgNGIkwJHYYEVxB0d4I7/4i3l90Xg85gbOeAMz8/duiVYrc3+I7GeMnDDGNq
eOCs9fmCxEaK2E/ofhR/KiCY8zcXXOPbJVZPOENIfHHnSe62AJNOYiDxxWKQ
rdifvLkwiSC+eHPYNWJHtAiXSkhtEnGDhtmJWiMxWHH48Geaxkt+nL2wsoaE
eplpI/s0BK+pMeoSgIu3S2wBgfirgvSgNEgPIr4tGM+Ke+iBOdboW/RHu1vz
M5+E7EUMulxSkxJxxj17MzD4+vUn6MqLEexNY841nXrV/2rkDVicfjs4MDYu
pi/g6hDQlRdyS6BrInsRpBySN8PDQyNTBF0Khi98eN03NMy0hbu+c1dzZk7O
xWBvz/v3M+D30sLiyuoWey+XTLwy+76ne/gS8kwkKyk29e6XHDMM8h4hvxJ2
gyQUAbUk4ozMxk/5QA1XKOx1s5XhEhBMTAS7mJ2d2d07gizAeiOMpBIzL+zt
0J31dnhg5B2wD/G6r3/swzxsRq5pZEVPd7u7O+fX9gnJ5zGZLltbml9dXGKb
ydyoJ7cIj/t6uz8vbBA4XHnJiaywK8u5eXzUC+cqLD4wcGhCl7jjx7aCtx5z
a4I2nVRoEmfXE7wuIZ8PwgluYh5XOU7g0FEeCYVObhjpfvlhdhksjfT3vJ+Z
4z1GnO9HtgJCqNUSYoHgZoTRziTn0rNjSSK8jnGafHpsYPj1uFit2HR0helx
QBmUn6jJZgYts1EkODaK8/Yn2CJIN368v/fNxAdGPsCHNnyEULtwESWuaOo/
bH9nZWl2mbIre1wyJUBHHzO3kmkrd+S8fzM88PqD+D5S8RL2dhZsFbFTEFc9
ri8gXbaxsry4sErwMU2u7bxBWG1CH9oXwwPdH2fW2Rsp/C0anDn9sjXB4CPh
su9Jvb9P8NjHBXpYQseI2CPGnJXZBaZidLdyg41r3Ic3owOv3kBHIvsEHHUe
Oz/ZX5iepi4BQr5RVKfNTo71Dryi17BhZSFXLmxnXFJ38KbeXXgf6ON2/+EL
ts6Y2DN03O0FdhASrMDhztA4d07jTw2i8cGet1MzzC+pGxc4p5K4u1JsVB/8
c7qz0fv8xdbeCVsCH2llWkYQUHezhqX1NXwYU3ni0L0pDD5LMwcstvd1dXl2
kc0I50coZwFMQrOxd8z4yQ+8wAQsLy2sb+xAHY2JDnZ629uX17bhiQcSlkHC
EPFXBelBaZAeRHw7wD4P5a1cFCVGmVlZOzramxkZJuVVjbVX3Lgu2zu2CD8a
wTl+jBOCiewM9J2ckjj3A+fkD+cREUSMvYmphSP4Ge9hYuzgwRbLh0LARVPE
ebmQu0X73jh3IWb9PbpCXhYm1tahjFdAYIXhTlomFpzYhO9rQ57koamqbsS9
etASfUVZO797BOTkVGUGKuia7Ahx1m3g/BCxKazsRR8Kt7HOJtt05i+bEbue
1S+S85YgRQC/KISTgZD7LPZEIectTIwMjo9/BOlW3vdcv3Y7s7aLzpPxjanI
Giamv+id+Tv03EpnSwNL3xSwYGGo4xmVz1ZAYqIRdrE9oayuUfZwlDMIGx5l
XEovc3UNfSfaW6IifawfeL6qqa2VVPYStufa/Mf+3j7GoJSxyb0Ytx/jTQ25
5XDsCCyMDvW/m5oWCwpw/jkzB1FitjA/oiDHSEzHQQ8fiY0BdgSKyR+JR1xZ
VXVJ1fnEQkU5Mq0arLbWUw5NK+HnsIkdUAQrOXnHnrc/8wPakXUIpeQAk+32
0kxfT/85FdULczEwc/Xhj1xxa9Ard5Y/D/UMCC+hiCTBuvdce3HmgOUrKf7w
IBx/d9FTc/W5x7mvBC/qmTAtzraIf5sHzo4mah5gUazPFTm1zXPqxIJJHJW8
ofjcoM71dzIycgzhKgYPdW6GA5eekcOQjmPtKeKOTWjOA9MWF0NtNVMnsLz0
cWJk6DV0nEKDBMoNJ3YMtLVDU6u5IBqOw+Xy5wHa8HRHvnleo3D7tp6JTefw
JN8cqg5HX5cqMpOcnF1jYpL3zlhniTotiPgRwuTGH++MCfFQT0tdaz92xECq
lpR4wokXBVd+vvOs+yM3tFjJI0oNc1ExceGsRx+VA/3dM3PL0PmEtxU0mZw5
XoQH65YCzevyGhmFD7hMuOApf/4Xi+iy923Ykyo780E4Pz3Z19dHLZ+7GGu5
Rabh0HDlWgwdsFDN6f8wIHyx5ZFWLRmlp6/n4adqqR1FBDzphTc09LY0rgTe
BEKuE9kuEztxFca6Gds58Tuy95oI9uYglClrIbG2cLdQ6fUnxurypu7B4Oe7
sZHxN+/J+ahLI7qySmUPB+CcEIi/JUgPSoP0IOLbAXZdSIT7loqyWsb2ubm5
CfeiWtt6Tk52+jo61rcOxC5M5J6YCOMFi4OBYUBwidg0NtbT5uRMkpOltbU7
WE71sbZw9GAKxrlXBYrYx0Y4JQh7Dkx1qSJEjFNI1TjK2d7BNpppB4EXRboY
2buy7jAJ5WiywRq6PtixpbZeVHQl2PJqsO8NfRuZnh6JEy8bMpT1LXZ5j5wQ
i3vyNaGu+cxVGLo9zdqEWriEZqmJw84l4y/rjOdAsBYQSw1rSVii8pd2nAhy
MAmOKQErjvbWuju7Zpc2qNpdSpqRXmasi0MV4FaJPBxMHQPTgKmtTPW9Ywqh
suB5dMKLzXF1LUHXm21O4ZKqC6O6knJpPr3p7+9/zd8P5wO165raGtXPPtGN
pbu+rzFP29gKhypHcNFP2qFinFtMfKoYe/cAJ3xs9MOzasmfGMY2FBpFOJcJ
1wRWyOBituTNS7CjjmBDurx7iRFMuASDY4tszbmJyiLWcPuOquqRGcDvxeyM
1EOTC6BugSJnTH24iWF8feDDSnxQcQtCvjNZUTzRXqtlaEytxMKcjZwCIpnZ
vGJ+MsZWVzT1NNtIy4ZuDv+ySqYt/DH1yy4lM22bOZToarrpqYfF5EFzCy95
K3FVxenKM4qMje4xNz2mpya6e3vOhGwytkp8iIhgbyLxa5iNga7mlm6RrCWF
kOmg+YFQUJI1H+uL45xlIA2Cif18PzrSPzIOflWlBJra+fNdwx/jzE0htgih
jblhRGoNdE7FuMcjubARd1ahd6xOD1Q39+bribPxcYKoy4hQVdEKDw7SVpIx
dfQ9vWQPZIKf/c7czMGhNrIDKcLbwtLrHi8bueFNnXAuDzY6XzxfXz9gjjUo
lJ8c4iSw9yf4HiTXmxlrl7YNss8vM8cdOz74m2P0PPCLrTE5Da1Pu/R5jzmo
RcILAmO6RAiNNK6bcKiz2Ftn5FBtyIvVs7ajppleuBprRGSWc9aDz5MSkzYp
hDh7Mgd/lkea9BU1PqydMmXh8GiENCI0NwMeeOwtDvovO9mDMYWQwOG7lOTK
zLteetY2bOHs9HjJ+zycBuQHJNtwWjmzWhUXjQ72vnozAVaGu5j5h+eAtecr
I4byis9er3APe0JWxbm/CMRfD6QHpUF6EPFtwbiitAd1YK2uUvNwjGBvq34c
68suKAPX86mhF5lpieH+TtZ2/uBobKtKMTAyFBgZt70cBwnDnO31dK0CvZw0
tfTySprA7ksfhoNcnA0MDPSN7XoHPoGrVYKbtZ2tN0icEmBp7eYF0ox3PnCw
MAWZxMRmnbLu48RQh6e9nbG+wNTG6cMSORGxtbYyJio60ttbVVMnPfM+uKCC
+nQ2Fwl09ZycHFQUFP2D8zi39kFmuK6OVmiAj0Bbxz8qXURJk9XJfjtLU4GB
vp/f3QvS9Tq21jW8G3cfFNeQn/vieQ9IszjZb2tmYGFjb6CuamrteUxJyMrU
aD19XSMLi55Xn0HunU0lFuZGhvommeklrCcgHB/s8HCw1ReYmDk4vpvdAyvr
S4vjE5LMjY0S0kARJyGerno6uo5egRsHjDSjfJSL+EAXfX09S2efr2dYe21W
YHACuCivjj/zdPfZOce/zg7bmRnrCvS8gmLORMTu7Ki9uYm2QC86mby+b8y8
S4yLuhseYCzQtnDw3T296K8vVr5zR1VVPSK55GD/a1V22sTnNVBY36NKcyN9
XQPjhPRCsvCzraK0tNi791xsjfUMzHsGJkDXjL5scrW20jPStbNzW9g6Aqk8
7C2cg7OACewtDOLyH40/q4mJTqCN3NtSERYWh1Gvub/c+2xhauDo4uloaygw
tuwengVpntSUp95NdLcwjUnK6Wh/Vt/0Auz1dW7Cx9HaxsbGzcXVMyjyw4dJ
H1drB3d/dwcLgZH18Kc9bPezo7G2rJKCua33wOAM7Z18Ge5Ii4m6Fwz6VCMu
saStscbRRFdg4jA2/oX0X86+3vVzEAgMbN2DLy5FHU35MndkldU17kblgbp1
NZWYGekbGBrXNHdSnSWsSYsBA1Kgb/jgUR9OXE4OdGYkZ4YHe1hYuc1Pz6XF
BxoaCOztnAfez7EOJEbHIL9MdMVHJ64ckM8nVuemlNU+BFsflWdaGIODwKyg
/BGGCVPiEkYmN0CC9vqijExyQA48fmBvbWGgr+foEryydQpkupO2+r3cBpCh
g5lubu3j1vKCpIwK+k5IY0FSfGohfUSCkj/2P7Ey0jfU042Iz6BWXdYWZMRF
R3o5Oejq6T/s7Kf7oigpXF9f39jScvANeU9j4HmdjYWpkYFxYlrOBXUEH61M
uNroycgrmFm4vnmzVpXiZ2JmGh4WpKahnlNaQ/bLwuRdX1dzQ0M9Q5PeiU8X
e2t2hloK8ipW1vZ9ryfo88D7vsfZSTFhoKtcAsjjsTTNxFBX19zyadckGP/N
5Vl2pmbgMAkMjjslnVlsZ3HCxdJUT0/H0Tt071CY6GZnZmod5u+upSmoqHvE
2fZgayn5boiVoZGOnnZB9XPGyybw8pTY9PRi+mddUVJ2ccv0xHBpXj15Ohp6
agWklIEgJj4LpC3PSmpseQ6STfW/iI5Nu7jEv7wb9HezBwmMLaxffSAnKgd5
2dp63OXc36nhrtS4u7Fh/lraAtBNbc21liYGxtZ2n5c2QYa9rZV2VpYCgcDd
13ebejHn0uQoOBZs7W28XFy8faOnRicbKopjY2PtLUD32A4OzoHj4ElVQVdn
/9r8uEBdRUVJ3dnNf3dru7Qo89HzAZDnZMeT5MjkY0pQlKVECPSMnG1tFRSV
M6qegfrMT/Tbmhrr6ureS8nnxQsm2p0bd7MFVhW4eoaCEXK5u2Cmp35dRj4w
Kub4gpNFzM2Q9cXFS0pzvXuR8/ufVJe+ntDDCKR58/KBqSFokEF8Wh7pfeyv
lKVnJUVEG+jqNLUP0FZJjwpS0zcMDfDV0daMSSoBa3bnX+cnp8cGB5tZWT9/
+qLufuPGCXmBKE+7Z2pm5ezqAk6891s7a4oyDAzNwsJCNLU1YtIqQH1qssJu
yMipaWmnZNaBzF/U5RoZmQj0Tepbu8DV5WFVUWJ8gp2lWWB4Kt3baRHeV29c
N7Fy+zzz4XF9eXJ0uImB4f2Ot5dHyy4O5mCou3oE7p6AUSVsqyhPCI8K8HHW
0zV50PC8MjtOT0vdzz/+4JgRRF/G28211O8oK9q5hMzObCYG25hb2wT5empp
69Y8aqevc9W5SeCY0jcxf9kzxuq4S7qe4LwAzgx55ffByu137ZYaGm6uvram
RoaWNh/mycvQQGeTrYUJOOCTk3PJfc/X/F2cQMe5+gWfnWOii63SnPTEyHAb
O9uwsLC8tEK6N7sflYWHpYCFx1XZhvoGAhOjR89HwO5P62qSkmM8HC0jk4vr
CnL93MNBls2lqcaGRsbGphV1D9l7IycJ90ItLCwC/Txd3H1WTrCLwyVvOws9
PX2/8HtA957szoHrcnxctJmxwNLW7d08eQG6X1QyOrQw2latLHdbRUUlODn/
cGXGXV/f3cPX2cZE38zm7ftPnOokkBhE/E1AelAapAcR3xjcVDcRITpw09O0
cg6qq64qL7u/s3822JRxRUH98BLrf5T93/7H/zS39WxofgY8YU159Zr6J5Xp
odraJivbBwk+dtduy2XnF6VE+P7uh+svh97PDDUHeAd2dHQEOpqo6FmCS2Oq
l42tPTlXLcXf1t47HFyI1eRkXEOzXjTXJSWlHGPMlJu2qoIA35Curi5nAy0j
cy+wJsrV/J9/9Zv09MLkUI+fb91ZPrhcevvi+pU/+IbHVxXly9y+6RuQz72w
7lHxvZ+u34qMSysvSLt2/cfo/MeEcEdPTs7A3KuitEDp1o92vgkgoZ2BQUxi
IyjPXFbGO6YQIw4NFeRU9R1rS8pNtOW1zF1Ahk8L4uSV1B+0PCqK9DMys//0
+b2i7K2Y9Ibm6iJQGS7u2VaV5xsQ3tvZ5WqsZWQNdC4RYKH7f/zLH0IiEodH
J2PcbfRMnZ62PXY20Xf0DGFv7V7Eezto6lq8fPoY2MfVK27+7csrV642P+sK
shcYuoQCt1xP/qaBtW9FfkZkWPzC7KSdvqZ7RMLzxy36aqoFjZ37C4O/+s3v
rV39KkqKNeRkLZ2jp0e69BVlTS1tHjzt2P88pHz1+qPh5bUPHTI/3fANT6wo
SL125cekiheE6Mjg9s+/V9ArLMw311LUNHEBVWoqyggMjgWnFFN1JSu3aFBH
P0cLp5AssAA0aWzp86Wxlh+uyg5O7oK62wvU9e39GUfidFFfXUlD36aivNjO
UPOWiunhGVYYbPXf/uFffPzuDgy+8rTV17MPB/3iZaIlMHNsbazTuH1DzzJ4
fWPH1ljjjopeQUGBhbaSvomX8GT9rrOpsqZmQlrRly8btG1fP8j+3b/8ysYn
ujgrVeanq4paRvlZeQYqsoZ2gcBFjHazNDSwe/r0iY+lsbtP3KfXnRqqcub2
Tk2NL0ceVasoahRX1beUpWmoCz7MHXVXx/3hys2M3MKUUMcfrsu++rw7N/jg
n//xf+iZuT548Czew/mOrFZv31DyvYjOwfcEwd9AB/+OtBQoKup+3LoAyx4m
Oh4hWcTx9O3bN3OrntaXpOWVNF0eLKgqq91v/wi8zsxABx19K9Dk2qzkoMhE
MDB01eScg4ADjJF6MJucF+dsqln0qK+rLuOnmypbZ6CMA4GSrOfdIrrMxakB
xRvX7LzCgKa4ff1GUEI5uG7YaN/51c+KRQXFzsYq8urWINnDnCg5Nc3mltaM
cA8DS6e11UXtazd9ogqePShLS806o6Ts8e5CrJe5oqpGQkrB0uJBbYb/b69e
T0vNTg5z/uGW6tTc3vK7bn9P72fPX6YGOKiqm+7s7ER62ijIaSZkZJOPOlLH
ZE9tyv/9L/9gYu3c8rDtcXkGMGxdUys49nV1LKcXdguBvEot6O18onz7zr2C
R8TloYmyvKqRdWVJQVhgxMrWea639R9uyWdl5gU7Gt9U1FrYvaBOOvju3JsQ
H8/7rY8b82Juyyt3vZ6ltVBJlNvPt9V2zoEeO9BTuJNY87Kl4K6ynC3YpC97
x8k3vqu1LjklAwwARz1V/7s5YKfnlYlKqnqHF8SrpzW+3gGdnZ2B1gJtAzuQ
XYyftbVHFCdCe+tT/ue//trDPzY/LfanKz9o6pvm5+bpyt0wd4uh9U7Y3eS+
7pcChTteIdlkIM9I08TJt7W5XkHmmql9xOrCiubtqzfVDIqKCkxUZPUtnYEe
9NJVsnb039lYsjXWVtE1zS0oPzjYNDGg4lM48bwwUkPeEIiWtvJ7v/vdzeS0
/PzUmJ9kbpc+en2+NWuuqeYblfLiUYO2qnp2SSNzb+541VRdQcPAsaq8SOvO
NQvXMOx0N8TZWEZJp6y64VzEhoqoSfL0KWV3dS4zKVpPVzMmtZAOroEjdHrs
xe1rP/mExJblpvx87UYC6J2LbfWr//4bGeWU5OzPX5bp4rITAn57VS4tPbsw
PeZ3P94qbBm7WH1141//WVbDuLyq4WV9zk1FjblD4eCD9DsycpVVNfFeVj9c
uTM0Ovm0Nvc3P/4YmZCanxz+0xX5l71fhp9XKCrI2nn6P382PNBWqSGnVlLd
2FCSrK5uNL2ym+Rn+b//w7/5BIa/fDFMx0kflKbIyCr6R2dvbC5bacv8jyvX
k1Kz5uanHfQ1VfXsasrKtBR+Ftj5gbYkuxj+w2+uZmbkxfrZ/fo3v3P3jMjN
Sr529XpK6UM6Erox/9bTXEdVWzM7v3prfT/e3/L3NxRzcov87ATXFHXPhHhP
Tbq8ssr9lkdlCaFauoYzK0d03G7wSfm1Kz9FxGUWJt/94eeb5U/GsN2POnLX
jOy8KktLzFRldCw89g+2tW/c8onIe9lcmZKSd3G8H2hrJLDyeNH2xNZA0ys8
jRDtqt387e9llUsrGh6Xxd2+eWfoywHI3sVAw8En6XPfE1VllZqGh/VZsepa
gq0jUUmc9//2T//mGRTe0f9md2t7cXrpbVfjjd9fL2nqqMlOLq6oYaOwpy0N
teWlVcYq1351S/3o/NjX0sDcNeBl2yNrLbW7mZXY2fqVK79WMzArKszXlLlt
5xoPdjRUUvUOLJ4bG9CVlzUytap/9Oxkc9ZKRVZBz6KooFBX4aapUxAcdhSb
n4BA/HVAelAapAcR3xbQnDTs8sDXTCCrruvsYmdiafN+emt6sEFNYHwovOxu
TJVV0vtKunKEr5WOppljf99w96PK27d+bp/4cNfNPjCwkL677SBQdI9Io64v
h9UleW42Rop6pkA95PnY2dl6g0KS/WysvchZVXYGGuq6Vi9733GzaQj6XuXB
SnF+jqW+mkDXEmQY7WltZRdJbhNtGxtrvNs4LYx0AhWgkgsj3ezt7GOY+Tk4
XhLjaWRrTzcpLcDF3DF6tKVQSVFz/1KE46LxJ0Xysqo7Z6fu5ubRCeTMPRdd
zfSK9tXReqU7ihtn5NS+9oZ0dRNHkAMpSC29R4b72+pybt/Sbn004GCibmzm
OjyxwNqNmShIHK+V5eXYCNT0zYEQEPpbCqwdgsnK7b+Vl5GNSCsbGRiM87e9
rqy9e0a9g2d3TlvupndUWv/gQEG0n8xVBVDu22dFv//9bwWm7uSN9PzQW8oC
gp0F11mZdvO64oPmzsGBPlNdNRunhO0vA6o6xsuHZH+8bclXkdUGC9GWxnGZ
daA+p196DJU1xhf2C4PsdQztKeviRSGu6noOQIpaAUVZ3wOS9TflCgxsji9I
l3J/eaY4O1NfR9nElKy5j5OFY2gOgYtsLYwC4ytAE+0NVf2SqghsV1dF/enI
Iu2Pnm1PaGkLHg2vkw7Z17eaN+XGF44rwh0NTGzp6VX+bua2gek4camvfKfk
ySTYKdTS1DcU+Mln2traeQ/I51kmHuYZ6BiBvuuvSTGwseGGJWC4PkNbRedA
SEZUgfHD85rAyubCCC1Lz9Ovy7rKimHxxYP9I2nBdrdU1MAegXZ6qVXPwb4x
DgbKOgbd/QMD7U+VbyoUlzYBgeADBBc1sc1RV8MvunTlw0tlGbXPm2Roujk7
+ubVG/FpZWy3EsxDf5TuHXtWaWJsMXNAtijcxTYytpg439RWVrRw8n47s0fa
Ye2dubHJo4FZkKA4zt/e3p06nPDNpbeFmekCDTkrz2hgIhdtrdjcJlyEOZtq
x+QDP/ZcoKJU0jR+stiprqEzv8mEdQrvusjpGtJzgx9mhyupkSOB3CXnPrDD
ykiTgZY1GM/OAi0rm+DXQ/3NVWk/39bo6Z30sdTRFFh1jbznJvWBf0Yasw3N
zelJa1EuZpZeIaTIE26YqelXtXyi5o9dNlaUBbva3LmjunmOTTwvNtR0pkMn
VCOIl5WJKhraO+dkj3oaqumaWw8MDXa3lN366VZpy2uQZmq0NyclUVFWKSa5
9WPf/RsKml/PuCmLhLeBhn9EOijodHVUoGf66vM+P8uOIF421SSG+MrK3Wro
ecOcBU4WdRVVGwdXdqefqKlqHwnxpuxIfQNX0AAvMx0VLfNH7WNU1xx7WhjG
pJdTIznf2NBu6YTSwJfbFcX5DmZ6murkLNmYAAdbryjOGs9K4zUNDajDSmgm
0E0p7yJlYEKItqYdPe7Wpl/nZKRqKd528ojDsAMtVaWmwSWQxs/UMCqpARSq
rahV20Y+pdtRnaxnaQ4O53hbQyeXQLBvfryXmetdgpqR7mBpmFzWDFb2VSfb
GrqCEl31VNxCM+hW25kb5jaPTLaX/Syv3PCsZ6iv11RHQd8hgB57Q3Wpd2Q0
lo/J5iy/eiB7Q27tSPSyPknfxoedw4stTk+W5uTmZuQM9L0Fv6dGe0y0VP7t
xxtZBa3c62USfS3UjG1oU5dEeakZWYvOv5rJy2fX9TCdQ6WLDLA3A3KYmiAb
ZiFw8oon9j5pySi8HN/ACNHn/lpwKO1dEtWRzvqm5MDY+X/Ye++2qJptX/QT
3M9w/jrPPvfcs/fdd++93vX6msh0zrnpbpom56AgkqOAIEgQzKhIEBBRCSqK
goDkoIDknHMO3XPOW7Nnz9DgPvc+zz3ruf5BrXfJ7Jo1q0aNGlX1GzVGVXUW
CRhAopAHKYEC7RUj2w6ANGY++whEWqfivmweB8livJUsiWNjY1Pjx0pbyz9L
v3TfjQxSqYOMlkw9psweL/eKZMqBpUPAMY3QPvw2arP+Wf3Q1sJu3OhEuthd
aXeJPr28lxOgdfW+jkrOTBOPxxncRt1ffXRSv6g7evyMlKL0ECdPH2Of1Xur
hSEpqMl1b7xOwVRPrx+H6sRiB9+WlqbPr55cuGB3v7Qbc9UIcZbIvUIweU32
0Sg8Qw1rw0Cl6p0F/RFa7Hlrz+VPzq0EKcQcueZjUw+a5/TXy9Z2t3ILv7U0
Rvo52IhddnfW5Tz7OxVNWBd25HMiM8thwwKfzRmY2U0K0HJEzmD0/vi+5OIl
6zefpwtzg3kyL9KhHUam2j+yrS1dvcMnVw9J71NjG+lXeu0sbWs7x5eHPlif
t8vNr2hp/hqkk/CkQUdb83y+8OvPLZC6MDlUq/UCD94KxbWIh+Dz60pZbBq6
LeJopl1Go79sQL0IXt+LlWu8YPNdh1QYcBbOwj8inOmDp8OZPngWfqdA7kpA
/0BbHnxu+r0yDLAZEOhz5T2eVLt3DFUVpIjUbkdGzBCiFUqcXZKSEiPDoxKS
Uxe3t0LdXEJDHyLGvMJcxZHZT35+e8dmsgJCw1PCgwRKJ8iA5FzRObsGAYCR
Huzo7BVkLHI3IcjDysrG1Sdiee8Ig+Kv7qcwGKzwqKRoL1et2g21D/p6ebqg
q/fQzrBaJR+c3csK0XiGp2A2wRhfT2/T/kHUh/FxbKDGywtzpXqQGOrqeaMq
N00h0BjxreFgqF5iy13Y2/N31CakvALf+AgFt59/HKq5rxRIMUZUFaYLFeju
fieZROnsk5QcHxERFhufsbQGQMtqiKeTpaV1YHjS3rHpcITK+2mA4IiIhEh/
ncIFaKnQFUena9fQ3WFLg/VMFic0Mj4uPiryemhefumuwXii5Uyn3I7mHxKR
EB8dfT0yMysP4JLt4U//9b/8F7XHDUDGnWh3ni4Qn6/1L/JSLG05t26lxkWF
h4dFV73vGmyq4Cm1s+uH4P3450IxXbgLI6EqQWzKY3RNebxZwWB3TGze9NT6
e0VhVp66B2kSvgyBDj24vLxnNSDf2ie3VQAYwEhRdhyNxohJTPFzVjvpogDr
rviofMJyENRfVHE95R7I4G1enNYt6F3JPQel7gjfeaNf6RNLJW+bptDW2RpR
0hjNI+sPwwK80PVntIFD/bXOQehZIncTr9rzpNevhbI5vJqGAQRZkymkeS8a
wKtPJdkaNbph7U1OhIOjBqFsHW0uyVVwxTMo1xB/T4fE3Mcg9nFGmNw9an9u
RM63uRqVlBATGxEZmvf4OUCXvo7ixLvFAA/G6rQisfzWzfiYiPC4+OT+nk4v
jiA7v9ooGIYUD6eA4OSxzjcyrvOscY0DRDfXFAi4DDu6oOJtC4Lgh40Y/+16
V+Dg4Dq9ix7McCvYOzAEyB6yvTTp66y4BPT9tIdHx4tOMseadvTs0FdZCe7u
V1AEfjOcxuLeSEz1cnZwv4oywYvPS84pRRVSJS82Ox/EpF/z9AhNLs6+qXW7
ipEBisgI0Gi9fDATz493j3gSEXgRpBUn5hWABN9rH7pJ3De2IK1MqHbzT7oB
hCIkITlnEYWR22EB7hYWFh5+URu7h0Ye6msfJMrUij3ULQ5K9HfyCA6HwCy0
1O3BV79rmx9ufyvicHz8Q3MTw2Uc6dK+obbgppjvvqOHcdUYAk2vcHQ0boM8
DhKLFSrX1KSEiIiIuLibM7MT6aHeLK4oNe22SiC5fbuq+U0mE2gNlEYMVkiC
I9KNvtDv1XJNx/gutnNr7kcbgLRqN9+s9FSpiFv6qYPYFhrqpoy68aDodpzW
GWVLflqkROBxjN7msB8f4mtlY631DNvaO7zuoU3OfgGK6K9/oVLr9g1Aacrj
05jBYTHJIV4qGaqzJFx1dQ6IJU7jfPcoWapSop6/8IGXRpP1rA5EZkYHamQh
IM2d+GAmgxuXeNNHLvPxCwc53w7zp3Hl16/6cTiSps5J5GhKzpY+KUMPjSm7
f0Pphi49xbmofAIiQD6pEZ4qzwjYOLK56RTZhW9BJGgvdwUKv724zIwHxcYV
pCNXnfp+eVNTRa4NU5ienBwTHRYRfr2ypglbBKi5HS9iyU07/xZ7FNb0odXj
t/kJIpW3Ht9Y1tP43sdFp3N2f1xQS+yBHf9aYmtv965jDKtvrLvU80oENjY2
ltwSOaihvUUdl/fiXQ9MeJyCAfaqu/OVeIw/qb6uHv7RyOZ3JUvYObYKYno/
PueKFJObyNr4FzGb6Xs1TCvh+YQmg/R5if4K12BjjZa91cq84gYEWtdKBE/e
ompRtJeM7+CYkpocGR6RkJAwtbIWH+jr7ZWC4AfLgDQLgx+5IunH3mUY3nZ1
EGQXVYHI6vuJIrp03+jqD230K2zs++b2c0PcvT1DAMULPxoVGmXf7DZ46+Kk
DEl8aNJkIDgvLtDBxROzPAY6Ca/fzEE9fr+VuwpdpxYPfbVKqdr9ZuqN8IiQ
6Bu3+wcWjfzVB6pYwUnZWCYlt4KUnn6G5QENU9T6cw3EbI010PnCnpldGN6N
8Xe3uGwTEHl7pLeJy2NGxKQmxkZFhV179KL6eHnESS4oB7q5sdPlxfi5+8V8
qXwilzqBuvo5OfDkjmkpCZERYTFxGdNTO9kJgTr/GASffY1D/fHB8qCrRnrp
snXczUcGfJcnBG/K6FbuERng57c3j+xt2LFJSXGxkaGR11+UfVmb7BRI5J87
5tEBJ/mauyfaHD5K5fXIJ6Bx/WSCiLgskIV+rkfD4hTXdoPIZxlRWl0gecWG
yWWFclHUWTgL/4Bwpg+eDmf64Fn4rYJxcRLXPOAtVzY98U4hcYhZQ2Uug6/c
geDq5zcYUsfNI3Qij/PXMiROCH5GPQp1HMQaTQiMHhvZYnHh/Lv67lhvkcAV
1UQ+FyVd5EhQs6CPo6cHahaM93V0C44A+kNbZx9Av4fjH//H38+9bkM3u8HQ
oeCShW/EA/Dhsyg/LlsBpq1YXxetYxRa0NqQQiXpXzkqvx36lz13Xw9D0J6S
zXL1uolvykMKkoIYAtG2ASCOfSHN6krCk8XBJkDS668/QYWSAx2tOGr9Eewm
Ft/MqgVTJ1COUu9VAahz7q/Lb1vmAA1JQWq6xA1dKneTC9S+CL77fm1prKt3
GDwM1j367+cutE9itzkciyz+5heH7hbJj/XkylDFM9BR7ed7CzBnd2WYb28X
nWXcMwURhznoASpTcuwCw3NNZk30nw01jxsRFqnksQo/9Ay3v/zbn5fr2hdB
9ceHBr6+eWZz2a5hYIMwrHR/KbJlcJr6UQfOSA8Zne8MGsaTzwq+gZ4Fejja
LKUxW0Y36p7F/2Vpv3iAHmrgzLNVeSUA1KFh0XLyX4Nkrx+mOjj5A5BvfflC
xL33gLSEQK1AEoS6ObkofdBKIRqpKOp2CSoou4teavE5a9vMvGLjwjWKYY7W
+plsVsbjOkBVeWbIXxeYK5v7dwKdnbQBmPwE+2m0gajF5Eawr7fflcLCQqDD
oucHwvMiMS/76UfwVFeY7qDUghwqbl9liuS4YKJy1fw8U8QWoYYSUDudPCbz
KYh+kBbM1/kh+1tSrlVkRgHJW3hbIbCPyEXJuxflbUcTUcQcCtWJgdCC4vSb
w/YXLLIKm0faS3j2irHZfRDZ2dJ6aDymUMWwEbvG7iwMva2o2j8wYNh1oOGF
zQVm5/g6crzIt7OJS3m4s744PDYNXjUVxJ2ztFlZn5PZsO+WfoehI08518kT
gPAdq8t/pBa2AsIifJVCj0gEMrhx+KmPXgPGaKXs1IfloHFXhr6oxbwLdEFB
WSOxRP++IPWPyza9szuoMuUoEMiBzm7wVLGjMx6Dh56qexqebg9CrjtLxI5X
iBrurs20dQ2CHFa+V/7zv16u/TaNZfj2QSyNJzTu7EPifFU6/1BQ7sFcp46r
7BjZTvGV27HdQD2n6gtsL9kBUfn0KIFur6GsFCFv7sWL5Yp1447EeB8NS+xM
2DVWBj/9jz8uN46AvmBQ8jihsc9WxhrP/XnpeQ16vsrE4I/t7d0QB3HAtSSQ
frK9WiF2aB/bwmS4IMbroiUDlaPNQRbtctG7TsJW0v3hmZjP4bCVz4yWrPzk
UJHAc3tzr7vnB3i7t9j0b/96saltPMyT5xVxG8RkXHG346M+tDqWndotEeRT
lR1DtxcBOiN91bpraZgMgP/eP0oSSmUrhwCC77irlOkP0YWR9HBfB1U4UNOs
/v2vh6+GQQ8NUnK1zuiAFhng5RMcUVJcCDgDfu5vDojshI8L0P2bxblxMp0L
iIzRyb28IwF3EoJcuI7+Rv3oQCpgBRh7UEqAisfzBOmvO/JZcm+Q/mipj2Zj
efdV91RHzTkLu7bRTZMMG4kEfye7qi0vXnj6uh0UeS/W86KNZP9AX5gTxlW5
YosXmD6FHckKyH6ck/2+BYxv8M7IFwsLq5KGn5hIVORG/XnZdnoXlQNXkZ3C
8zoCbWnorIKKRkIZRFcJwtxoMnf0cX+WfvFizJ038HK31J5R37tgQKCuTwVM
oWR2E+5pKHZ0dMq997iqphETj/RIbyGoL7p0uOSukN8taYShFRHbPu91K3ib
Fe5px5ETh0KDel1z0Tg7RxO+HOBhYaiexRXV9YCBbstRxk66/wJEzvbVWV78
6245uvvyUYLfBSvB5o7hpq+ji9sVdFXh+weZQtw1hTLN2VF8Nf4+ygsI5UZO
mBNf7Ww84Bj20/CuJGaih4U2F2s52oVdQ8oVFU/iim+Vw08uRZDsKO+L9jy0
g0D7Uvol75g7yPowz/JSQR16jmtWhLsNSzqzuN7b8xNG1dPXf/zN/t27Jgcu
/Wb+R3yXH4Is9YIWL6xqw4bolZEGZweFLY2fmPYYvE8OdGbwHPEOhVp444M9
JG4hMH4oK4iZ7P8+NoM6GxSkBP3rn8yV7WNj0qP0IDc63wHj4dJgvf2ly48q
u4mJAAwgdAG/tmUWZHUv7qqLWzCI9xQrwsLQHbgebPrV2ByQ++Fsq4xGK3oD
2gV6mhaucQLjM/LtU1W9cR8l9bDUs3AW/kHhTB88Hc70wbPwWwWTW5fpoM8t
LZMdm/ociwP/ry/Ptecr947h2iex9iIVtvVna2ZAzWfShWJXjdTFM/LwwJAS
6A5QsYe7K93O0skb9XqquBtvbUVzcXFTsG15ChS+1t4JA+BkfPnww9P4v9ME
LV8a/VVcB42zzkHg7Bo4vrJrhPRQbnSgjT3L3cOHQbeXq1Cn0Bh3ncbReGL8
xrBIzK3pGod2llTsSwyu0MfD/fwFi9CIO8SpOC/z4i5esnL39JDxmfZch9HF
fcToOHrRyk6tklta0IrfoGvXYS4KmkAJwYdeQm5UYj6IifV0PHeR5ubqTbe6
IHP0MsDQxnS3kE7jSxTODvLgqFt9bfUOXHu1k85RKvD2i1zfM55jABsyYwIu
2tO8vLzY1lZqHXqhxhWF3Ms3DZvr35fmWVpaqtROMpEw2XjkAnZKXXN1ke3l
yyq1TioR5T5+cSchyJbnBN5W3gn7u61gfVt/+7r7X7Z0R6VMIneaWt7Jv3kN
QEedTisRyRtaR/cXO+1sLUQyrbNCdumi9etPqK/dg8Rrf1yy8AmKG//2UcNk
VXwehZDdAIXIji8Eah2NIemb2UH0m0p72u2HVQhq2UyUG/dYpV7V2dLYnr4+
LHsbJ3f08I30CI8L1sKNjaPEqy7WTPXc4hYQkOfJQf/0Hxf6ZvZIsdmZUHDp
dJ5Ep3G4eN4i9V4RqMINNwetoz+GtYLdVagrGmhEPxdbBi82JirQ3S0hLc9w
vCYT8bMLUED14WmqTKI1QMhE1yemnbU9R1JZXWdkEtRQnC6w401uoU65zk6S
yFvoMT4PbgTT5YBsqPV1vo3lBY2js1TCTwCKIQxnhgf8cc4i6Mq1452lQJXM
liVw0aq1zl4Lu9DKZJfY3k4kdRCx6Gon33090lSaTbdTjhnPzwGNaMfkuDu7
cLj8moaf3a/u/7d//feKDy1YH9Fvz7iJOJY0gZ+3y3kLm5wH1Qs/mjg0hk6n
k4t4geFJBgN8I1Bz/jINdAErKxtf1CAFRfs629D4AYE+QKK8gUIEFEOt0Faq
A1pmuKfAiu+8uHEAIqM8pf96ibl+ABOXbkPQXpS30obOVSukVgx2ffc4BB/p
pMzwdNQE3/UmT85Rr24ja1PtPHsaX6bWOshCozNmhrqdxCylxlGnlGk9riyt
HWGXksz0NYhsadYMwaeGxqxIL50PQIzH+rlONVta17nUXn2fZmfvqHV1kApt
aMKppf3loRY+7bI1T1bysgFr5srccLZMgNpRwQAx16/k0IDa7qRReAVFzy7N
+alFHL7kip8X6GLhsah6nhnj83crmlap5PJVfT9nY7Uy/6vJoDNMtL8B0gvU
H2xh5EfDSzbDWqnQuKvkVta2r7/2mC4aMPqCyu3P/592nC2jy+qDhKsysf/G
7LSbgi/VOLlq5CpdwOrWQWVe/MWLl5U6Fz7N2kHje2hAXmZG2Nox3F28OWy6
QITaNJ/eDvnjIru1ZxqrS839OK5YvI5auHd1clna/SqQf1aEn0wG9JrjSC+V
HVvo6+1naWHrF4jKbayXis4XxcUleLu73cx5crg9K2GI7hW1gI5fmBUr1mpB
k0U6Sjy8rqNXLbx8ZGtxUeDg0je9VZYDBiJrtdZVwLRVagOOjg0jPe9tLlmI
xHJPJ82fF63zXnwG9b0V6XsejJNAuKUObz58M11QAiP3469ctrB1dJBbXbZ7
VFQNIu8nXmXL3Uz3L8Imf3WjzfYgxc/9vA0dZEKztvD0Cd8/Np1LAx2tX3OR
gBo5yMR0jqB9dBU+GJPZMvPLmhHKKSJ3EkP/+Ouip6e3kGHLV+h2j5CVnjc8
a/bnniWQS2fdUzuuaG4fnu94w7CxCQwJi7we4unlNza/8uBmiEDta1Qo1nVi
QdbjKkBNqKfuj/OXo+OSDjbnfZRce67AXaNwcg3c2D2O9tA66aLIezIRaOH7
BwaH//77AgKtawT0xLvFxrOjDfnJYRYX7bQOcsvLNrlPUTNrlFbqpLsKPpnu
e8eTCDon0aUwZ5U4IOouMZO1fSi2trTiiTTf+/siPJX+0Wmg7062lMg5Dj9n
9vZXBuUcBkcod1UrXX2uru9hBjLocHPOTcJiCyQKsYAnVk7tHByMt8ntrTky
raNSfO6SVWlNN7Q1ohIxHRx1gCStR/DBoaHuReYFi8tarU4mlGc/eYtAS0Ke
/dOqZnzqRK7quP/l3y8NL6Kj5dHamFYooHHFrjq1i8fVYxhKDfMQuwTiHgho
R60vu89mGSVBwL0WlblvQEV/rr/p0r//X3QO39fVGd3Dvnz48mHauUs2zk4u
EpG4pPLr4dYgYGBVK3p9YW60v6OTH+p+IJYEhaK+sk9uRvzt0kUP/+ix9i8a
Fuc56t2tf3LjuoMTWrQr8y8bsR9mXIbhs1NlzsI/Npzpg6fDmT54Fn63AON/
AKT50dY6ND6NTdhgnlhfmOrsQG8cXpwb7+jogNFI43rv0U7xvbvZWXf7+oYN
BsPc2MjoyOCLZ/fzn71ATEhD//lNaW7u44mp8ZnJkX09bDjcKCsumVjbh+H9
iueFI1NbR6szj3Iycu892zk0YGd9GzM/flP89P6jopmZueGfQyB2rL+v//s4
uoiq3+vpaJ9b3DASsPEg+3Z5xYf5uamxiXGiJjNT0+PDQ5/elmbn3DPO+Kb4
z9Xl6bey+sfnMAywMPmzpKTkWI+M9HYPjsxiTHhb/OBhfsnIyMjk8PARdmj4
0dqTe9mgmj9GJ8DPqYGevKyMR8+KjkynnJsOYK8sfvboUfHM1Oz4MHpL11B3
59DPccyIhqBHFLbkZaQ9L3yxvLJh4rXxFvHF6YHczPSnjwtXNrab6uvHJlaM
Rln4c22VEcwf11YUZqfntLcPYl81fXyVcev2m9pPkOGwp/65UKkuq6y6n5n1
Y3QJ5zlSWZj/8OHztdXl/t6exQXsPuXjsicPs7MfrB1gNz7sdre2zsygQ8fK
9EhfRwdapmGnIv/uk4I3S0tLUz+HQE4HG7PlzwoAAw2b0y8KincOUW2lIMlf
qnTDLwREdTToeG9sdPBHT8vd7NsfG7sxFXi0r6ev7wcmQkM/en/0Dy2Ndfro
nO89KKmrrn5dkAvA552ixp/fe6bml0FWK/PTvZ0dGDAa6m5Ov5Xc2dOPuRRu
LI53f+veM+Lb/q5vY5NzIHJ+eqirC/PLgmYGunIy0p4+fbG8vI/51pY/u/fw
aSG2Qay84HFmRta3zu9HxqUGaG8R0FlQYLrpbGF6vKu15wCVOQME6T+8Lk1P
y2juQE/eWxtvZ9sz8yu+GrEd+p9+ZxE0fV39t9XV1Z8DQyBmqKf1Ttqtp4UV
JrsetF/6JK+49O3axurPwX6j8BwUP7xbUP56eX5u9OcgjOinx7+XFJcDtWV1
qrukoHTvGFAJxfhpte7Y8Q6YJcUkW1WFT25n5EwuHRrzP/7e1QbmU/C0uTLX
2965fYCmhw6W8nMzc+88ADIMeLQwOnDvTlbe/YL9I6JPo2Giry0zNfX70NDy
zNiP/kGjbemgu71t0bgI0/6lJvP2nZ8j07Pjk8truyD9eH9zWlpaS/sAZgdc
nJnobO8g7x807BSAvp+d3dP/E6VtZ+p+1u031fVAeIaGhjBetFRXZN3KbmxB
VbyhnvbBn8Nol91c6mzv2jReI4jVdaCrPSstra1rcGlqYnZuAXOPwzzZRnu7
u7p/GJl/PDU60IUedgokdij/Tk5W3qP1A5OHZENlyb2HBUtLK3Njw+hBKxBS
/7rkbl7+xPTC+PAIEHdof/VlwfPhsXmMIctzE12d7UatCvre1T49j6o882M/
AWFG8dl8di/nRfnr2dn5kYHR2e/1V1x1d5+VfaiprXh6+9wflo9Kmvp7OmeW
Ub7NTo12dXWh7Pre/f3HEMbt7vrX6Zm508t74MeHimcP8ktXVlZmxsb2jd1l
fXoA1Pfjl7bZqeGJyWlMcWisKc28lV5bU683mK4wwO5h/PrhNYjvGBwzmpDg
6eHBrp5uhHJVCELcv4MgbXWVmakZZW8+ELfjmZofRiqePMrMyl3aPEQjDld7
Wr7NL20ilC2cYLgbHf3x7lVRzt2nh0a34L3VubbWlq0t9N6HjeXZ9tY2wO/c
uGt+Ptfev6v5UPtGJ2AINIGrC1Pd3wcwzbOvq31yCvVahA63C+7mFJWjp3Xp
kaMX+Y+yM3O+tQ0AMke+9/b/GMLdJIwHFG+ttnd2bBzpgSz3drWCHIx3MaAS
0vqpNj09va1vDKvO2I/u/r4xwJm9rfWOtvatI3QM7e/pGByeoM5lvS0fbqdn
Ts/OTI79HBqaQnvh5kp3e8fW9oGxxK2Ch7lZmfd6+8eJ+zWMS6H7hfdzc/Ie
bx+jhB2tL8/MTHU1f81JT2/vHsGmwtmx7w9y0nPvF2zpjRyGkNHu5tz0tOcl
Zetbh0Ct7O5omV1aJW4umZ/ob2/uwO+PQNcfip/czczIaetFx/Ohod7vfT/x
djS5bva3Nd/OuFVS/g7G225zaaap/kttTVXR08fPnxfNrqBy1df2MTs9taS0
ZudQbzjYbW9vB7o2alcd/tnXO4C6lHd2D4+ZJrWaFwX37z9bXV4DXWjROEjO
Tgz19g2gstr8pbG5EyEtxWfhLPwDw5k+eDqc6YNn4fcK5P3O2FVcJkxmwhum
G6Pwu8/IK5sgHCqbNETC5cR8kdH8DmL8zixTeuPKpAHf2kPiYTINfj0bYrqj
0PiLcskaQtkIbzDFmkFhk1/UMaWueDz1+imYKAQyQRUiEnsP47enkTdwkWVh
KgMRA+Nb9WEyHwzjYUv6+D1W6E3KJMhGYGopFIaY+IimIa5gb6jMPUfjTm4b
SC5RP8d5iyEZPB/svjwDQbweIS47w1RFXBVBsO0k+IVZQGWb6o8K9Lhwgfaw
otH4IYwTRdCJ3Rl98kY8jP0zA012tpapD5+3fmsuyk2xobNrv45SGUvw3yRU
xM1q5v+a4RbY7E5nslDiiAaT1ZvMnHL/uOlSMEIs8RsqTRnevxkWFBK3uXNM
CJiBWgT2gD0S99NRpJFClfn+XJwYLMPx3i8BbkoLawa6MQ3PwkykUQk5JunE
L2okxQomcjfgn0OUGMh03ZipF8AkAbiowCSvSIklGgXGuYMgCFU6EPOGwOTH
hIQxS70RZEOELBNNbKIfi4PwYom7NRGEHA1MnYL4z4Sc8SrD1AxhhHB6xw/+
JV5RM8c/gSCiSQjG4I1FDlYjTa9oVnbpj1+2t3zLT4tk0Pmf2ydMxeK8NI1j
MGVIod5EacpZT1bEmJ7odDhVevKR0tzET2JIwZsPzx9fRjCQxMCm5RpTJSjH
SBKCin9vvC3URBKRMz6OIrDZWGcIcJGzFbr2pqbm+hq1kO0ZnIiYBYj4S5V/
4lI/LBio6SnCihBjkVnFTbMMnpgYOQn+mgrBZYDyligEhomLOWAyzgD/qkQK
/6lCi18gaHbHKELMbgQRpr94P4KoQkrpf8bSyTtt0VULBIbNGQeTmREJDRRm
kXmaVmjxCyspPZqgDSGHfSrHSQIwSTAfTc/CWfhfGs70wdPhTB88C79PMGkN
ZggKoaIsM2BDYvKTaJD40HyiJD6m6kqU69Rhs8kXm7pJSAOTD2ROxF3VJKmU
S5xPTak4JCNvJcandhwe4JUy/tVTjxGh3HxNsIgAr1R2ESXgcPRXDCEjcRxI
JRgHz1RoYcofv9udcn02gkz+aM7OzF3ZIO+aJ5AwThDBHwpDCOB6glFGtEDW
i2wXk4483teg0zjcfVJLMMEcF2F0Eiw4dbs3gnypeKZTyhw1Kp2zR11jJ95w
hC0Dwu+VJrUSShVIdRu7L8z4aLrjnlIKhPPfQGlZhGx9RG92t/hpsIRX/+fP
nyaVCH2hN2VELCCcqCNM4G4zu4wZcqOgYkJCut4VOqkUlR/bEWyVgOxiWDch
F0ZIUnHiIbN+oDcXZur94MQKj0l4yUvJ4WOYkgVlHKD0SlIdJATfRAzWN4x7
LrFniJoZjOFTUy/GZYOoArV1cHOX8ZkE7QS3YXzdiWhfCNcUCM7AFP0FwZV9
HC3jH5pUAATB93yRgxVRUwpoxxhSVfLQ0UHupNa4unl9NW7PJPRiSkVMsNxU
OEzRPE4w09RYVA6QCwUG816jJ2hDD3qlVPOEykN8RcHzMG5GRGBikD/dc/UI
XnHKQhClXqZMTBRuzA2FB3qoHVXOasek1DwiQ8qn5LoTtRgjHXoKu6h/8XZB
8DTmyxR4OrTRidUwStFUthD04w1BqqgwQRtVg6OKkDG9Hs/T/Mr3E3ym2GcR
QsOF8YGdIIAoG8EUdrOx3XwSIXcRYr2K8gwR/CTrSC6KkKymlohgowf5E6Fm
QpmVEJiS11k4C//QcKYPng5n+uBZ+K2CcV4jAIaenENhik6HUOZZXLHSI6Q1
yjT7wuQzJXfCGEAmgSmI/QSUJf6YgBxl6iLAkmlSg2GzstAC9JTkpj+E6YSI
p6JlMxoIvQMxsyVRk+FzN0k+ZlIkdApiZdh02oORJONMbFJGcJBG4Yp5tpRW
gEgsTAkGiqpOBbEE7KfQRqkcJZAqOcE7xNTERPviKU+DBRLbQwhV74fM30Iw
HswLJQgzw/MUek5AQSqdlCpQYRtsOJXMDCZRYTZxGj9VAvFXZkoNlSRTbhje
M6sIRIGgJ1lhpjtQW8G8XCq0w8TAHBASX2EypqcUQdGIyZ8mnpgtvJgz1BwD
mimqRAchMSqRoTlJsLnNhdIcpypKfTYzoRJDilnb4f4AMMkTgl1UNE5lIxqj
pzY3wXoDifz1VAOV2bfEJ5Q84RMJTvQEnEIzeTAJPKFikJ2cSEB5OCXYlN4H
U4YjYvwk0yCnx5D/WSCU5RMVJ3atUgQUf4ZJ5pNWV4ooU35Sh0psEYDURyij
hVk14ROjFTk2EomhEyMVTOEbVYBPVJ8UKjKRHiFFxqwWiElfMxtG8BwwGsw7
i1kXIGZF885i9kSsU5l+EoZO6khLjlfmYmZqZSqr8GqctG+ehbPwG4czffB0
ONMHz8JvFXCIi0+UJg8uBF/ANEYSkykxO0PmORgj8RnLDJzjkxuuqRmXYfFJ
EqKgMxJCm8+QCL7geQKNmXkVmswrCGWupGRi5lp2ou5mvwkAQHjTYckwcs3U
KrPtJ6assYmbnLIpVSbBhhkOxLlNEk8h5nSgYEUqMv9VpX6hxxG5/mf4gWKC
hHHfJHPw+escT8JykvzTX51qXCIZaSpFIPhkCmP+VOUTJgQSMkPR5qJCGpnM
3R2xSOraArUiCEWYqeSe4BtEiAqRD3EeyH/GfyoKNbmTUaWYzJlgi9kD4Vf2
a22CIPYUtXjMSbc6M1BNjgN6Yo0IPpEYIoYAUlUgizpVZwiiWAZPrkLgJOFL
KFgO1BahGLmo30KnY6h+6VTd59SiFkIkM2tuYhCjjConanPS6dQ88oSo41or
kc8vuiqFLtK0dKLgE26Ep1Sh/0zMTtD2n6Ug+pHZ8hshlrhOTXiT4o19Yj3K
LJxSzYw5/E/oNKeZugSBd67TTDZf0oPJP9RySZ6TBj+8ImRyihhA5NR3YnHD
GAnhvcO8CPPOSDYQTPgJ45TjbUkuwMKk3/uvVr1OCxUxPBqXDQ1mlT4LZ+H3
DWf64Olwpg+ehd8t4PtoTI8QObuazh1FsGkRJuc5c0hG/EQQIvEJ2ECokMZX
OFiCMAedX/vwUKAZuSZMAQbkzI1trDNXqsyA/EnocCoQBeFQ4QQGA78M8Gmo
RrWkwAgOAs3WmWH4BD0n9RqzNV6ImPOxb00qwwmoQKqcBmptYeQkfkBwfGVK
D1G3ExIJiCYgqMT8DyFTEScBzy/06NNcJYg5Abqo1TFzD8bfEtYc2Byy44mJ
jXImUqkW5P80wAQiNLMS4q5cFFhLKv1mMPK0/kVY8UwmApN/2gn5IRA2YT42
IwqhivQJks1FnaSBIPVUgCCyj5wwWiHUuhGQm+I9SNBMTUPJAs/ASAZEGQ2w
o3soSJdiQj3pKkkQSnKI9E0w05hO6IwIPrwglBYk3arNSsFYTTQmRTwgag4E
KScbAKL0TmxAOCG0lA5lijnd6U4qVpTMfy2m1NUKs+KINRmykhSRJwdGMzXq
RCkkt34VY1rEMMYaqEsoxpdEHySknbq0dWp0MleLCCUdxusCnRTOUz+p+7pP
1OvkEEfUgtJpYSIHjDYDkSWhd1HEgOrHTGyeNeaI76QgLbOQyRf9l0s9EHz6
BzkS/MK5xYxj0Kk8fy0nxmpgAmCATb7E/5Nh7yychd8nnOmDp8OZPngWfrdA
3RJomrbIvUv4LVcIQk7xsBlYRRDqXEZAMHIlH8sXNvuNzcVmG1vIfHDIASFm
RjliXsZ+mYxIp3UTBHdtIiJIUx2Jqn7hiEmCHypDyGf8A9OGMr0pX8i0XwUD
P7ABT2mGbAlkSsH2hJHFYNK70V/40TdY5U3sNTPW4HgPVx5JGkiGmIEQijuj
niAJZ/gJzEZSS20RakXMd6aYIX8K9iYsHRTHTaKt9ZTPzb4yaVVm5FCcYAmu
4uYMBMEQLExmThJJgfq4WOIMxHE+rs5TZcFcCE/a7BCE1ASpROJVIxIZTP0I
I8bMzEPyDbcpU0Gp2U8T5VTtDKYacEmSTjycCOb9FCKse4QAnDowh8I4xLQ/
jgprCWiNx0B4T4HIqsJk96H2R6I6uJTi7Q1RuYSRTQ5JlCHiRH/EyzJXbymL
VTDhXUxVlqntSOZHlUa8LMJX04D/opKBk2ogH8wJwwUbJ8+sq+JMI4kn0A5E
MJDCT1OWEKTHRchgotE8nNSb4BMPxOhBLrCY7w03V5dOKHrog54gzKw7kIsn
v1LY4dPdgRwPidUqwjJoVi8YawZSdyJGP6JcmGA4gskDXiN0D6apjlRizCpF
ygZlFqPsGias8+aiZ74JgkqY0Z8eXxw8JkrErZOEORuXT3zdBjEP1AEQrykx
df56aegsnIXfLZzpg6fDmT54Fn6rYAYgYXIiNNNXMCx0ctmTYqog3MxIwAbB
+EYJfOcRdmiJwbSl7sSSqRkVRO4mpIT9R2zxoIIxKgAwzdQw5dRNSs2wBwib
jc38nfAHvMrUT/Dth5SjDvHXGBlEHc2Lw/9A5kCcCukoJOM/CFhFWZc+fWgh
jl5McIJQKwi0SgFvlMqS2Iaywo/TRfIWIitLlkImo3yFl0ulikxmLlom8xkm
IhSHqxPtjptjzHC7WQrqwTsU7pm+wqtMIYOSOclbgm7jwzFCNA2B23HZPmkO
MNkCSe9KzIyLgzQMrWGyCkMUziO4LMEUoTX+Jlb4yb5AtK2ZlOJk68ne92vj
FEE58RPnJ7mXFigURqL0+BmkuK2HaHpS0cbK0uPlUnKDKZ/AFKaRJEP4CALj
YwKMW3UJMSAsNqZsqVKEmPZ24Y1uamKcUURKmNrKEFXhwNIQ5zmS2hVhnsYl
gTLyEKe+UJaDcPlCTi6JnGgB6kY5AyHMJ2xAp7V+igMzkYC6mkQu7OCKIvkv
8suczZ4pOg7eTAilgU4dLYLzn7qr8qSbKOG7SLh8mNJAeARWLzJjiGIoh0jL
NdVHxUwaTi3anTAmIgRjKX3/xKQGBkbT4IBJ3QnbNzGGE4SdUhURhKqCUQQP
xhlkSmNOoTlXqWMOTMmK+orcckqRq1NOEQgpeJSmPAtn4XcOZ/rg6XCmD56F
3y5Q5r6l2fG29ubmhi/1Hz99Hxye7GmMD4uemNkgcDK5tE7JIOdmyt17FTCR
wAybmQBeWd7tjNt3wMOrRxnpdx6gczdpdqQeQQARYOxFbkZGxj080hytEJMg
cc49hjOJt7/08SPBLYHC0P8fbk1EXY9paJ4wTfMUZECty+7CYEJYeFPvBIUA
M9CyMNARExbV2b9IoiYSQemN1dObnO6M3+bdTs7NryS4ZNYgJ/e7YQoVfgI8
TPrcwtTP8RoR5CGE1oa3C8W31rQoTT1YHvu36kleSnI63soENsYvxTBjKV5R
HNqZWIiDOoQKbE59Ra2ggbjWBP1zfArqkNiYNGbBhozEG/lPa4jqkIWSdURW
x7+DdkEvJadoyhQCIEI1GOqsj7iesLpnWBhoiA2Pnlndw1hHkSXc7GhSXsxZ
jdd6sq/FWcqXOHpOr+5RaIMInRirCUyKLtVCSawwmHpdTenjhNgcinve/yMC
/EUCiqJNdgHD5nRqXPj7b/34VxBCVA3B8TMCjbXXx4dGbBwja6PfYq7H/JjY
ohB8nJ4Q//RZLdE6pq1W5CGKZKFUVX1+rCP6WtyPoVXCBEn2GvxfI0DWwyZL
D4wbnUl/7MmuhrjrEeMruxSZx7+GyRpRLMsYlqAuO5z04TQzXsHm/eyksyhV
WSDk3MzOeFLUKUZnaqsTCWqfZ9tZXopNeUi8xXMwN1XDpnIpY8AJe6V590KI
LgH9QmExhsL7Oak3HxLJW6pKoiOTVzePcI0ZIZvJ3IKPP2NrcXqzBTe81tgH
VSUP42/lUetM8gcmYij9l8yFYsIzlYXF63E+QtRxG4IPbyUnPHlZTyEC+vqq
6EZs0iHlNBcsW9ylAxPa44He9voPdb3fe4aHBhs/fuzs6jncm0+4HvsVTBAG
UvYeZaVl5D2nVp/qXU927a3Z5LCw+pYfFFd0ouZ6skUgc/7CpB8OPsLjKzDm
DfuLndFn4Sz8fuFMHzwdzvTBs/D7BKqzn3Gu2Q5wlFnSmWpHFY/PjL11b7C1
gsfkfuuZoyAAiJiVcJCHqLgsF5dkBDcvEtlSUVOUSiSTOYOIeHehxNEDRzXm
WAJGVia7UhJuGk/YhKMcZCKpozneMOYGEYYJw1RPc8qNW4SlgXTWIq1YegLS
IXhGFPMk+md3vt3uPP1BYasZZwiYCpssAvBiD+Ovi08qv5kSQcfUI+LBw1hT
OZvGqfg4jJigLMYEA47BUJp6v7xNTruDvdFIGRq/JMqisBliOHlmOKzH6UXV
3m/vy5Mz7uA10lPWiiESxBJr0bAehqmaIEEzRRknbS7QbR8thy02u7jBBAqP
zdAIyVUTTDJApFTgpegRmIpssVPlIUoOuBMrxmoIGWp9n5KUhXMeMb/4g/IJ
+tWujM7x8sskFS5zpQN7mu14y7fnllb/oBwHCplnaEr55VW2xZ/cyU1o7MsD
+/O2fdNbiMkIgsE1cibC251iZyFaDkHCfXU0kXP1u4aVjWMCQGMWNwOGG01t
hOn1EJGCVKhN2aEl5kb729pqjvD89evjqYkp83sUB0VSMYEpyJnUhmBKe1Gf
kbV+nt2FzLKPRI0gsuFwqIxAnS8zATcmNgzT3ypYdEFd6xK17gomx8c/Cxc5
Y13IbWcUjYkC10EYaa+0+oPxsXEOwaWL0iMR/BFCjpZS4xJRxZw0ASN3U+Nr
v/SAh97KPJtzlj/m9qgrVNQHmJLXh4onGXfzKZq3SVooqgdVV0JF9xjPyJjA
gJywXpEBMnkkEgIFI0TfwxNQOU+pKmVo0u9PC6xp/mG3fwx33E3NGhrfMm7u
oyQ0U/qIg7kQgnu/dhiGEdwgS1j9MGaSPQX8Dvd05HB9iDSVOdFsvmpoYgMm
NB3SpVOfl3Lj3ZcfFHoofpjY4AubBiWYkHYYTgp2shY5Y8VBhIMnRfchezdl
PQSnGLtiBkHMHPsR7D4OE3NIHm8JOYzAuIdUeSqI86dZsbYNlG9PTApoKXvx
Ib5sIZ/H4zBYdKlE5BIQMTf9nXOBdr+4DzZpeSgbgl1UTv4R+Fe43RM3ncMQ
nu32GO/Cxaxn78lkeI225n8kJSYf6IkJQm9GGMUiSV1ewz4/XJ9Oi0+e3ftF
a5+Fs/AbhjN98HQ40wfPwm8UcChiQkSGTXcGIyLl4ebm9srS8ubWDnJsmF9e
ArPU1uoieL8yO1r+8g0GJmpeFVe/b8ZmYT+N0/WwewOdXysr3yC4W9P2yszL
8pLG5m6siGRfF1eXIPAuLdjVyScAm9+aPlW/rHizhi5BoxGHO2tvH8Ta2XFe
v2tc3zpM83Px94tYnBgoK3u7h3qrodPlwcFG7avy2g8NRpoPniVfo9nx33xq
WFhcpaKLDzUv37xBUa5ev9XfP4bBjJXlxeHB8e0dgC335kb7i4rLlncOAXU7
C50ShqyovBvjw/iPtpKSoqVNdNjBMLdhe/HVy4rOjy+VPFFFTQfGvMb3leWV
dcZHyAQm4MOVlZVjGNlbXzw6hPbWpsuLSubW9xB8rXh3Y+XWNS86R/S1qXXv
YD/QSxeWmv/ze2fl6xoEJtQTQ82rF1XvGqj4CpBxvLVY/bLsQ71RGz1ciwty
teML25s7drcPdrd3QFxXy8eaus/gq6OV6dLS0o0D05YZ8GlfS1NZ6auNY8Jd
UP/hzau3NXVbehSlb2/tG5DdL9WvP3xqwSpy57qvt2vg6sxwaUnZ+gF5l3Fj
44fS4gqsQRcWFgAsm+7vfFNTi6m9lSVF9W09ODYzqWwri1NlL0rb2jDoqF9c
RI2nYz0tVe8/g68MO8vFRc97hyfwtQRob3stLybAjiH80Ni8vLIJwN768kRJ
QfHo6KwBR9rj3zuLi4vHJoEqceyhVKYklw73tLyu+oQWCUErS6sQpF+fHyot
fLG2g+kUBysrS/sHekz36mr8WFr2amF5A0PRXz+gQnhk1GOa3t7jMxxmdg0z
zYUytvj7xMrs/BwByBdnR2ZmlzBeLKysguoM9LbX1nw0nmm0U/q8qKljAIV5
y9NaGd8j+MbRwaFRILfLS140tfZjnWVtGVVeWj6+bevu20fNDdCXmuq2riHw
bm6sr6Dw+dzKAa77wD/aPr371JAVc1Ut9zvG0DV02PL6iZ0tI6+4dnJy2kiM
vqzsRWNjk0kZwdzjjO3e8OVj6YuK3Z0jDMQers+Wvihu6egjV0jWBtVqyfM3
dY3vqz41tBPyBsH7byuAsLVjqkRP9WMJkz8wswMD4VpZAQgW00Q+vHrZ1NLg
LldHRT7EpGK0q6moqGhDb1qE2dqYLiss7u4exBoOV3XRl9NdVVKeY13DaG3V
y46eISz90uLM8soaSKDf3pleXNQfHPbWPWHY2OXmV05OzRurB40Ptgho9gHX
bw4Pz/78VKTiKwfG5t69LhscmTVpKzA0O95X+PzZ/NI20XYbi5NX3RzYMkVb
a/fWISBF39f6ubikfMeoVK0tzQMEv7E69/r125npBVTx2VsrL3sxvXkEPm+q
q3mHMsfkGdj19UNZeeX8yga5WAEjq6vT5aVlrS19RiKPUemCQL9rfF/fgH64
s/yi8HnvwLDBDNuDNjmqLCv58rUVG7u+fylh2nIrPo+P/agR0gUZeeVDY5PG
/I9elhY2NHVhowSQcJC4teVDVe0XxLTOg1ZDrz+an589OkJXDpaWVhYWlrBs
P9e8flv1bmtvHyN4crS3+FnJPOgbuPrUXF/z8XNTvL+bi1MUPjUYDnd3VlbW
wOPq4hJINjvQXlL+Cmv68f6vIrp94PW0gcFRY8NCVaUv3tc3Ykrj8vwcePje
1vju01e0lgfLQP6b23vBh1nxATq/qMW5yZcl5aaBBV3xOKh9/fpN9QesIpsr
i/sHBmh/8/WL4p8zS8QA2Pbl/ds3teMTM32dLUdGnjd+rCwvf2fATWsTIz1l
xUX9o9PGX9s6jUNyXnl304c31R8xwkpvhaskqs29rempBVxvhGZnp0FTEnfE
A4Ztri6B4SIrxFun8lpcXVtZ3Vyb63IQqF7V/Gitr/r6rRf7FMyJ6+ur2KD0
sfrV27efdnaPECKA2INVdNZofKfli/LLUDEAnbcGHXg/GWfbvff5N2xtGOU1
XxaX0ab50dNSVlQ6vbSFiQcMHVW8LKv/3HBsWg+DeloaSorKDo0T3JdXD+xs
6HeKavBB4Cychd86nOmDp8OZPngWfp9A8T80/oQ3XXjcO/nvEDym8c09icpl
+xjqqCng8mgSicjR4/rG4niIzoEnEnI5rJDIDPBdYqDbJStbD3dXhp2tVO0P
gOtgQ6WIw1Eq5bZ0VmzKQ5DbTV9HN+cQkGd6sJPOPxg8ZEZeFcnkDkKRp3fo
nhHLrg/3ekrYl63teAqH5qGFt1mx1pY2Ph7uDFsricrtwICsDbdr+DylUsW0
twuLzzo6WHSS80B6vkj1vu4bRrXhaPG6q4YjlAD6gsIyYGRDzqQlP/wElDUh
3T7/Vcv3+kKGnb2LRifisa05vO6xxaPdSTFT8ry8F3xfmB5la20jEols6Ky3
n7tAniOtb1g0W55YJhWxL1kxm3pmAcqK9nPjCyQiMdvTJ3z9yLSOPdNZq1bJ
ZvegwZp8gR3DSesm4NJsmMLWwUkMfgx3fZbwmRa2dLnKHWgWtxOuWtjYe7h5
Wllf1PpGAVhl2FvxUcsFEimPx7kScQvBjTuDTTUKHlfloGDZ0eJuPd0c/yZh
21ja2ih1/mNDy3fifW1pfDcnDY3O9nb3CPRxo9nb8uUOc7sokrgdE2hly5BK
ufZMSVsfgIj74X6uEoVKIeAFx+aBBH4uSiZXoHV0sLC09gtPB4VW3o6lXbZy
cXXn0O14YuXE2j6g4VaYjz1XIBVxtS7+QLeqe5zGt7XncdneV2JWZwddZAKx
WMyhs29kPSZOSGh49VTAZjgAMbBjJqU/BTkX5dzg0G1lPHZgfObw90YxmykW
C1lM/uOyKkwmpweaFUK2pS1NKHXs7F8caq7iMhlikZzO5pRUNYF8C26FWtva
iPk8kcZl/fA4OdDTypbl7uZiYWHhHRQHcnj3IJVrx3R2dmYx7dh81fzWgX6m
XaWWNf1cACQlB7tb0pliHtvZJ3J1fjHYXSWUyyV8ttIlYG3rePDzEwFTObWr
n24pkfJk84sLoF4ZT1FnyN3pDqmAW/7xB7bg8OhWDM2exeXzrlzPnBvsUAn5
EpGUyWQ+q/gw8O2jnZXlRQvbzMdFW1N9WqFALJUwmey03FeAgKQADyaNL2AL
Hz19npwQyuAK2HzR0zedzRWPQRqpWMLhK+paRoAakxfjd8nKUqvVWlqcd3SP
MnXV/eUgD9V5CxsGW/S8rO5odcRBwmALhSy6jceVRELRg47WwrzdOEK5TMwT
yJxn1/bnB786yUVqtQOHK8wvrDO5OO6MeSgFNCbPWSO3sLIMT8pGlbKxbjWf
CXoQi2bvExwFWnL03TMpSzC7Z1jqfgs4ObmlR3ZnPWQcOkcEPvzj/KXMzLcg
t5LcZBoDNakAlo6ub8/1NzlKpBq1A48nKKttRgirpdGMszLaKmTSOBKZk1J8
4bzlrbvl4FWMp3NUIupV3vex2EHnA3B7gpvDRUsLtkByv/QDJiH3o4IuX75s
z2SkPahY+dkmp9MlSq2DmAv65utPHeDbuqI7dLo9aA42T/ypudc4siGdH4pY
tIt2djYu7qFrm0eFWfEMwG2ZUKx2m9s4mvhWLeJx+VKpo1NA/dtaRylHDfRk
NkcolQRd8VPJJZcsLsfnP