(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    503742,       9714]
NotebookOptionsPosition[    432699,       8221]
NotebookOutlinePosition[    492320,       9446]
CellTagsIndexPosition[    492241,       9441]
WindowTitle->Datasets: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Make a word cloud of the planets, with weights determined by their number of \
moons.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"4357fb6a-46dd-4064-abd8-dac7c0a8ff69"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d83fd8c9-75ab-430c-8012-bc9960d8069a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXd1PG1mWH+2+7OM+79tK8xe0tqVV3latPCxvmWjzFKU1aGfpVkdZerJR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            "], {{0, 130}, {170, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{170, 130},
          PlotRange->{{0, 170}, {0, 130}}]], "ExerciseOutput",
         ImageSize->{174, 130},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "87559b57-de6b-4ddd-bf49-3ab7596c9b52"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXd1PG1mWH+2+7OM+79tK8xe0tqVV3latPCxvmWjzFKU1aGfpVkdZerJR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              "], {{0, 130}, {170, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {170, 130}, 
            PlotRange -> {{0, 170}, {0, 130}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8ea7cd7a-ed64-4104-a298-f23592abd2fd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"15d4bbcb-395f-4590-843b-b656c4ca5053"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7c72064a-ae39-44f7-85c5-55f3b2e140e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"72626a1a-2e2a-40c5-80c8-ab6d94394f73"],

Cell["Make a bar chart of the number of moons for each planet.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"295e6a86-da42-4381-b9f3-27cc6059959a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"da51580a-c68a-4e21-af47-63539c54b8eb"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnTGr80p6gL8kTcr8gRT5F2lDqrS7pEi5S+4sSaHA3aCwhYqAm+BmXblR
pUaVGxVOYQiGqDGJCxVRQIUILrT4A18QaEGwAmdGkn18bJ9zfOaeTz7X7/Nw
7r22LM87887o0cxYcP/il//0M/XHX758+fWf6n/97Bf/8lfff/+L3/z8z/Sb
v3V+/Q+/cr77+79x/vm7X333/V/+8k/0wZ3+5x//6MsX83oPAAAAMDx16ikv
qdqXm9hTBs+P63vXCwA+N/V8pG3hpsYeZeioaVzs68JXKkjLe9cNAD4vuXaH
Nx27IzP3qBJHa6Sdc2Shq4Lk3rUDgE9KvZkrNdnum8j1ktrYw3P8XftRmfiu
jz0A4DqhXrKMgsVi5ilnEi62PySuOthjPT21h3rOvSoMAJ+ETbperVbr1XLs
OMEiKZtiolSU12YzxFPePD+eiTEA4Br1zB0l7XZHmUb99GIU7U7OwB4A8DZN
XVXnv9ZiDwCwA3sAgB3YAwDswB4AYAf2AAA7sAcA2IE9AMAO7AEAdvCMunD+
7q//fPi/ezcaPga8IRx9Lf/hP34+5B/2eBiwh3CwB1iDPYSDPcAa7CEc7AHW
YA/hYA+wBnsIB3uANdhDONgDrMEewsEeYA32EA72AGt41lQ42AOswRvCwR5g
DfYQDvYAa7CHcLAHWIM9hIM9wBrsIRzsAdZgD+FgD7AGewgHe4A12EM42AOs
wR7CwR5gDfYQDvYAa3hSXTjYA6zBG8LBHmAN9hAO9gBrsIdwsAdYgz2Egz3A
GuwhHOwB1mAP4dzXHvxPMH/SYA/h3N0eTHt+umAP4WAPsAZ7CAd7gDXYQzjY
A6zhSXXhYA+wBm8IB3uANdhDONgDrMEewsEeYA32EA72AGuwh3CwB1iDPYSD
PeCCbTR22l9iR3FR6/f1Jvba954f1yfnYQ/hYA84o1iMlAp2+sVyopxZtS9D
R03jYl8Xvv4gLY9nYg/hYA84o9rmWVHpF0U8Ve6sqhJHuWk758hCVwXJ8Uzs
IRzsAdeo5xPXLFWidF8lnuPv2qNl4rs+9oAe7AEXNP1/Sz3rcNZfE1cd7LGe
ntnjlDvUFO4K9oAzMrPNsTKvyrVesyRVMVEqymszIfGUN8+PZ2IM4WAPOKfK
pmbVYn528ZfGFWUa9dOLUbQ7ORF7CAd7wFWqqqqbk/dNrQ+cnYM9hIM9wBrs
IRzsAdZgD+FgD7AGewgHe4A12EM42AOswR7CwR5gDfYQDvYAa3jKVDjYA6zB
G8LBHmAN9hAO9gBrsIdwsAdYgz2Egz3AGuwhHOwB1mAP4WAPsAZ7CAd7gDXY
QzjYA6zBHsLBHmAN9hAO9gBreFJdONgDrMEbwsEeYA32EA72AGuwh3CwB1iD
PYSDPcAa7CEc7AHWYA/hYA+wBnsIB3uANdhDONgDrMEewsEeYA32EA72AGt4
Ul042AOswRvCwR5gDfYQDvYAa7CHcLAHWIM9hIM9wBrsIRzsAdZgD+FgD7AG
ewgHe4A12EM42AOswR7CwR5gDc+aCgd7gDV4QzjYA6zBHsLBHmAN9hAO9gBr
sIdwsAdYgz2Egz3AGuwhHLH20K+H/7tHD39DsIdwJNvjjg3/1DTFbOx0D3IE
8UYfqDex1771/Lg+ORF7CAd7YI8zioWnnHDX7MssUmqUN2XoqGlc7OvC1z5J
y+OZ2EM42AN7nLHL4jjbmVf1Wikn+Zo4yk3bOUcWuipIjmdiD+FgD+zxAlut
CsdfNVXiOX5rk32Z+K7/zB6n3KuicC+wB/a4pC5WI6W8YNXoN1XiqoM91tMz
e9ypgvApwB7Y44x6szD7pSuzX9o02h/FRKko10uXeu4pb54fz8QewsEe2OOM
xfh0OeIl1b5Mo/7dKNqdnIk9hIM9sMdNNHVV1WfHsIdwsAf2sAZ7CAd7YA9r
sIdwsAf2sAZ7CAd7YA9rsIdwsAf2sAZ7CAd7YA9rsIdwsAf2sIZn1IWDPbCH
NXhDONgDe1iDPYSDPbCHNdhDONgDe1iDPYSDPbCHNdhDONgDe1iDPYSDPbCH
NdhDONgDe1iDPYSDPbCHNdhDONgDe1iDPYSDPbCHNTypLhzsgT2swRvCwR7Y
wxrsIRzsgT2swR7CwR7YwxrsIRzsgT2swR7CwR7YwxrsIRzsgT2swR7CwR7Y
wxrsIRzsgT2swR7CwR7YwxqeNRUO9sAe1uAN4WAP7GEN9hAO9sAe1mAP4WAP
7GEN9hAO9sAe1mAP4WAP7GEN9hAO9sAe1mAP4WAP7GEN9hAO9sAe1mAP4WAP
7GEN9hAO9sAe1vCkunCwB/awBm8IB3tgD2uwh3CwB/awBnsIB3tgD2uwh3Cw
B/awBnsIB3tgD2uwh3CwB/a4SpVFygnL9nW9ib32l1nPj+uTc7CHcLAH9rik
WIdGFu6sMu/K0FHTuNjXha9UkJbH07CHcLAH9jinTsfuJApHeu5h7FEljnLT
ds6Rha4KkuOJ2EM42AN7XKXJ9fSjt4fn+Lv2YJn4ro89oAd7YI+rVNmTPVx1
sMd6emaPU+5UU7gb2AN7XKVKD/bYFxOlolwvXeq5p7x5fjwHYwgHe2CPq9TZ
rN/30FOONOqnF6Nod3IO9hAO9sAeN9HUVVWfHcMewsEe2MMa7CEc7IE9rMEe
wsEe2MMa7CEc7IE9rMEewsEe2MMa7CEc7IE9rMEewsEe2MManjIVDvYYPrp+
Mfzftxg8eEM42OMu9rhjzj8Q7CEc7DF8dOwBjwH2GD469oDHAHsMHx17wGOA
PYaPjj3gMcAew0fHHvAYYI/ho2MPeAywx/DRsQc8Bthj+OjYAx4D7DF89Eey
B0+qSwZ7DB/9kezxLYqFnwrYY/jo2AMeA+wxfHTsAY8B9hg+OvaAxwB7DB8d
e8BjgD2Gj4494DHAHsNHxx7wGGCP4aNjD3gMsMfw0bEHPAbYY/jo2AMeA+wx
fPRHsgdPqksGewwf/ZHs8S2KhZ8K2GP46NgDHgPsMXx07AGPAfYYPjr2gMcA
ewwfHXvAY4A9ho+OPeAxwB7DR8ce8Bhgj+GjYw94DLDH8NGxBzwG2GP46NgD
HgPsMXz0R7IHT6rfHd25w/8dQ99xJGOP4Rv+geCNz4DYkYw9hm/4B4I9PgNi
RzL2GL7hHwj2+AyIHcnYY/iGfyDY4zMgdiRjj+Eb/oFgjyP32rfcCx7J2GP4
hn8g2OMII/nhG07Orahj32t/mPWWm+r0A+xxhJH88A0n5xaUSaCUX9T7IvaV
E5YnH2GPI4zkh284ObcgDRwnSM2rJnWVk5zMPrDHEUbywzecnFuQBt50tWtf
loHjrZ/bAwBkcos9ksA92GPnK3f96tzjxjI/kGPEO4YePvodQ+/JueCcv5dt
PFFuVO/39Wau1ChvXitWbFYZyQOHHj46ObeijMZON1eZpbvXixWbVUbywKGH
j07Oramrqm7OD2KPq68fO/T+M+e8qcuyvByoQ4T+xnySnH/TYs2ROvWUcv3V
4VgTT/X7WbUflm2so578QrTzlQqzQWtRZbPn+0yn9blCvpwt8mpfJZ777Jdx
S+7UEVUWKie8JUriO9N1ua/yWbj88bXaxMEx0dNFdvWcPsMfSJ26J91apbrt
3zrD1cxVjr9qnirgpfUNX8uX4SK3iDeYr1p7ZO2zZYcdknYM38Ee+zpy1WhR
9G9yfSFPt8PWwFxHyt+UVbnrKF+9K1b67CDt7XHDcHiLO3VE2+qb7FEVeVE2
VRrceP5rmItIRZlZWe+yuW5ovLs86ZDhD+TMHje3/UdQRW2/BuvdZQVewaS5
e/TinQw62+lG6aF123jqjMaeN9M302abTHUfO/pvkuwaPbzH3a1ivPxdEnWf
uJNo11TRaNIlJJtNwrSs83l34r+FgdMWpQtbTb0+gS9QJma60d3EVxPlRVq8
dTKf9jGjRF9VeTRxXK/d1vEWeWm65ix0sRq7rus4umamzu/h6ljKl4GjHF2e
8nwzFTom4V9/2/5nkpUmgZ5rKuVOF/aTkJc74sU6jBdxOHEcE3sSpXYrgEOr
r3SiLtk1ZTtBvDHHo+ks/ToftZHn2SvD422X1qn+3iwpumVLkawyXUKVByN9
nzYl+ouszqNjhsejqK1aX8njABv/+3+OHadLvje9YUZ01R4nNf8hX44cp8u1
GWD6o+fld8lpvzsbh/rqrldvdIGZeyjzuWfiHipwmb2JCWTOGwWruq+SM8+/
nvXLZZXOixoS05zRYjHV/9IViVx3nugLUF/F7WRgbqaURTxRTlS394tFvq12
/2teFHqMVPOxvsp/F7r9gyVp4PlJ2XbKJNuVVV1M9C1GD7167Sgve2NUmZPN
7KPpM9yOn3F7vWy0RGZ5nYaumppJ4GYxdvxEK+cstDHQRKe0yZfRInnf5KVf
uTj96FF6xDabYDztBou+anT5+2MSqh9CRwX9EXe1bdr6O9fuobfxUke8Uoev
/6WrudxUTZlF4WJrNXAO9jjPpJnVK99kcLfSLtaT7cPxoJX8y8Ojuqkeu3Qx
6nb3HS+MM5O+OJhG5m5bmX4PSl2lLsN6ducErZb7Sj4NsNI8Ehnrljf5+Pnz
CS8n+dwe5VPNfx8H2gEmVDYfmQFWn5ffJcF8Nw1cfUK1fqsLKt2KWWZ+C9VC
qpu8rcDV7HWjaNdOOqr2sc8rI/yiShdF3ZL9j6JbiO2ykRolm5XrmGR65hH3
Ymo61jAaj0fjYPOD7sT21lwlbt+bHaaBvR7DfoCZxLZs5p7y1/nCjPs365LP
dPxsq2cek1i/LZZm5T/qqjAaBcuNTmDQ913oHuxxGnpf5uHYbecm03Xxvjlp
O5YCffU3PfpYky0CPZNxPU8XGnbrlH6XoJrpsZ2W3crleKQbWja82BGv1GGf
x6HbbR1Eb186Z/HK0nyjPrHHRSd2M2czPsOsOrk16PNfHh430JRFtjGJamq9
Hlrp6cx0tWt2qZ57tA112iXblQz39jgOsIuP3qBKOhP2KdBtcaPqJJ+7bDE+
5NrTU4uL8o8jsO5H4JtdYOwRmJAbPZ0Yz/TJOs9Xsuce+3TmumGahW770PjF
CD+v0kVRQ+qjlZ6eciW+286FC33rb1Vvxsx0ZW4+9WY58Zf18RZQZ26/UG2W
E2cSZ1qTi0JfbOXMMzeLU3vonm4n5K0t36RctzNXZ96moN398Lvlor4vLTbV
ufnN87TPQq/DaXfvSMwsZf2uTFzYo9lvl1pf7cq7bi24e3YfVGd3xm6c/Bh7
XOuIl+vQ7NbT6dzEKxP9ndV7ItebqNtZKpaTdufwPJNm7uG2q85y/dLc4/rw
uCW66VkVb7pF7U7nbRJvY30rNWuBbs6p+/0pw66amB0xM5bMzOGZPZ5PS96i
1LWfLrvdyFLP5fTd6qSQYtz52ayRR44ePxfl694Zt7tz6cxzg+SGLngaFe0j
WObGllZXsqdnEG3k8jj3UMGVEX5RpYuibuuCj+GwCdyYprWTurr/EaHZrsyF
304vw/X29MeF7SrsP/FCbYVsPjnun+vkdxf5McLKzNnmtzWqMRO8p61Cvagc
9YFGMx3oZO7RhzgLXWZzp1196FIW2fsu5CqL1HOi7P9CnQKz/De7LXq0nCYh
mZm6zf/nvw9HzL3S/neiFzti+3IdyvnE6Vv77i2XbVv9tpn9XP15J7bruG4N
5y/Nvkef/DIx3xvNf//y8LiFfOkfw3n+sjSDyvwK07bTNbsE5SHD+df54RGm
9tJ76v2ToLfNPfR5m6V3DDwKzW3qqZBmHfS5buc/YXlRfpnNj99uXfdmF7Sj
4rD3my90ko0lzi+ubterzbbrm92MMjH5H8/zs365bPJ5UZ+Ipqqq6xd+Uz/7
RL+9el6z02701/a7iSbO60vp89DNW194H/WHlvbhdWiuPtxzc7HPvnqSSXOF
mplz82rZLw+Pm2i/fvp9U4Hr8V4aX3aYMfVSoLfT2Zz1hm0XnGTvsB6pr5bz
duN/ZEd8SjqjejPrrUS4F3rl4gVvb1XBx/BRTw09Fs11mQIAAAAAgCz+H29D
uKE=
            "], {{0, 237}, {362, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{362, 237},
          PlotRange->{{0, 362}, {0, 237}}]], "ExerciseOutput",
         ImageSize->{366, 237},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "29b30c11-6b80-430a-a045-340da66b21d4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnTGr80p6gL8kTcr8gRT5F2lDqrS7pEi5S+4sSaHA3aCwhYqAm+BmXblR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              "], {{0, 237}, {362, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {362, 237}, 
            PlotRange -> {{0, 362}, {0, 237}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"56479935-b437-4d46-a0b1-80e125ecf616"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d6514878-98f6-4eb4-b80f-122e7bbe7a59"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8365b3d1-fc12-4a6f-9341-9f966323e4aa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c3ac627e-bbe9-43da-a8bb-5c49b78fc5cf"],

Cell["\<\
Make a dataset of the masses of the planets, sorted by their number of moons.\
\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"23bc9512-ce43-491f-8596-7b72b1c43e4e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"496d44cc-896d-464c-ac9f-d198bf60b390"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnc9rIl+f7+XOZpbzL9y1/8DduJjl4CozXNyYhcM8PoyLR4gDEoQQhAiC
AbEXGi6mYUxD5ea2nWAjNmJ3qNBUMl0TihCJkkRpkzZJkRRGDBEM5J5z6vcv
Y0xSlcTzJt/+anVZ2tY7n3NO1Xmd9//81+A/+/+Hw+EI/T3445994X+cmfHN
/ss/gCf/+2+hf//r3/7yb//0t//4y1//MvO//vXvwMZD8B8D/oOP77GwLFQd
C8tadSdD4F9q9y/3pAv7DctKYb9hWSnsNywrhf2GZaWw3965Bqef5/wz01Mz
/vDWcQdsOKM+zoOn01OxxBo7sPrjYL+9c/X2iJUy2+sdfZ2bmf54c39/9HWp
vH/e7zQJ/1Tq+6nFHwf7bVLU35mfXrqWnw+2E94MeW7xp8B+ux/c3nQ6173b
Id/SXb933enc6Fof8ELuqtMf8bvu97iry+tR9x5TJh8JuGtqNrMj7HO8DlvY
6UVWtc9tk9k96bxsE2vit3ba43A4PJW2uIFjQk64hWzr9n070vntdjsTRN88
/JmdWzrq6b6gQTPrn5L2Sa3siKey8yPlF7fP7V+pThOd8c4u7ym3nJFL0kEI
StuKNb8tzkwHa/p3Hyrdu5h9pNutlHdmbu1a9epbOuWdXzmQN/R2Z8FnYzqP
+xCPlKnf3MBdDneSFM5UPgSfvze/dYoL4Q1yj726PGHWQS96fmVP+wX19jJz
H5jjU+7qnF4FXaCpDWSLk2/gsfdH7fymc0gEp2aCn27Q7s2vMf6Mx5SHutqE
Xl3due53GHgQL30l/yXHfEQveYTfDN/F+CP1Tz+Hp+Yzm+KvyeDs9zn/mE5N
qeza34tNT33et8dvSZfDHQA1zk2y8EQBt7k8bvgU+Y1rkFGPEznQEcpWOLCJ
ZSJuT7JQykZ8Lpc7R4P92oVkgN/H7YuSjXY+4g7kaP4NWDrr9mXbuhcu/7//
43IGyFZX3C3ndgWoZzL50P7b7YZ/SlOUtOrtiH7rFYNg511+c78GDOPfR27p
XzWPjg9+JKbmFYc6gX31xTPhWTMzPZX4eii89ncRHDP3dW1ePMIoMnoX4490
sw/NPBv0z8IqHa71euU5sVwHl06U7W5/b17yW/+QmPPHkEv7FzvZsBeNcIOJ
cDD3vTnqpzSSmd/iTkeSpMCf7izTIqMOR4Qk08B00G8cDWzkDKTpeoMupYHt
QoV6t02iiuhw+SLRSCTPtAsR8DfOZL5CVvIhlyNSOkg6Hc64UDDbZNzhiLfQ
I9UL//unD/gzTaG9OAI9ea6aatJ/u6S/rRML4CsNMxfGvbi7q4MfXz4mwIlL
rF9LJ1eqLT3+TMl2OVrxK60LnkoFUPXazi4oKbEvwHsHOr+dZv3eDXT2b2rr
s9OLJ7qOlfpdHvhIqn9O//ZG31/l/VYD25tZ6K4P0I39wxR4HP7A1A72ybWY
YRPwGA3xW5xiWwXYjALf+Ig6xwh+a1NJsI2gq/VqtV5nkm6HM1rpstA2kYJ4
KJZ0gaellnREjoM10yX5jYJ+Q/VN/cJulwJHdASq4FGrAN46TsoHeRG/9Q8y
QfT7Ox2rXRn3lvvH6/w1q/lMGTVShwll04POVPFYPrk1jd9W/TN+2W8bQXTW
+vC0zi+jPvwA+q2mevPedgZ0xryfv8DLZbOp8s29Vqp3eegjPSy+Pf21+xm2
xUtn6MPcoDpZE8rgrcrSY2mI36KwllVRi+hjgC+gzaDfKDSWcDr59hT8H5Q6
ijdYXOre8S6qKK2i9hsp+031QoXNmCw8xjMOnoe2px3Y0ATX9KdV0t3FT3AS
s9Q59Izy4lVP0RIhGfhNV99u9uEIYnZhMZtYzCTCsDM2N/eZVA4lBj8WUMM3
t244qFW/ywMf6WH19xLiiKZ4LFi/+TU84/8oDjTE35QnaKjfoFvqpXQyz8BN
ot9alahQf5QSbCMarK1zERiDuOT2lKM0flM6kyNgg+0G23055rnM1n3o+hts
9eTv1lCnoOs1v7rHf/Mz4uWFfu3TjLo11LSnJ+CsTcdOFAdJfDm8u9grrq4V
v3zaAH+ugPHpVHb549b+pfSqm+PivGAAb1Gx3eRdHvhIDwvVt8Ty2mdo8iCD
RjSo+xc86otv4X9xv8mbRL91WyUXHKomqXqj1ahXcpEAGMZqbdNCI9xAiWm0
W1UiGkhWWmQcOqhUbVRJwgdKmCtp4jcwTEjzw2GKfUa76fwGxp7hxe1ak+tc
HpGoX41at5vaGhwXoLMFRoKJTLH55/L6qvljGV48Kf++ved/8af9W8eX/V4T
DAAlo971O2Aku53xzqY2Welq2wUcn2a+7t30e/tf4CB3+0p9GvTt6eAAnP3Z
zObd/YCGDav/SFHjDN/F7CONKtQEb8DKdg6Ht9NzcGDU2YGeX1jaIou5Oa92
3P14mY5Pjf0mjE9bNOFxyIrmq6C5Bf5KKkeSLSrilnZxEQzLMnlpgwcMbwW/
6V4IVQUdR9gtfFZp/TZo5oLytbV58X6i0m9n1MfZaXmf3DfpgtVlOeGVLnYx
F4JXjlblC3ozistZJ98/yBvJptG51pYj9vhQaoKbx6obASbvYvyRRlX/IKEY
n8Krjv4PoBd3fVxOwf6tN7PyKQVHNwcPHWiYnnB/gWu3Wu32AwWIbbdV+3Bs
o9Focw8cGnnbka8/tN8jZdiegsHaNby/MOzs9Hu966tO3+D+wuXo9xdQUbLg
/sIjPtJoBxR/DVCtMxvzjqhXeT8L9vQc7uyztqVQE33/dEx1CL5g8jdZwh/Z
h18yTK/Tb1SpRDee3W7Yb+Po+uJw/9fP7e9ler/59LL5Kv32UsJ+s13Yb1hW
CvsNy0phv2FZqToWluWyu/BYpDqub3YL+w3LSmG/YVkp7DcsK4X99s6l4515
3dTWE4n1IZP9XkjYb+9cOt4Zip9lJE85tk7Yb5MimXeGEz4/f19PhB85Qe45
hP02ioSpREZzlngUWj9VyWxPHTQ9uOl1rju9u/E+mU4P8c698pw3S17e3x/G
/B/Vu9nFO6OJ35GCclOjFJUmW75dmfvtsjg3NRM2bF969EpYmtmYWN6U9rm7
2M2FxUmPGQTiIWpgRvWDZsmaQNNnikmYM/45+s8wxl+vMXhnHprILi/lUnNo
CuVP2XL28c501qOey83mPJAleP4ZQtbKxG+D7RQ/ucvAb9cMPEHlGsQH2H04
71eYcNiDs/1ngh+Y43Puz+HRb3SaBp0jZncf/dRqe0UIAoThPHATaLq2OpdZ
3Wz+OWd/70BDDqV1lBqfdx702D+nZ+CnVpz3L9YuFO6ykXduQEIqUmoIT1sl
8DSKYCsD0hn4MxfyRdPJED9b3JOj4AtlormLoGYBgu62mULILbBdgXjJSg8b
+q0G52aHswteBUIlC0EBYRGIO02JFaC2AirJ0tD+D+Ka9bOvZWhapZMvwdGJ
gyfwztIhdmPBj6p/r528MwtRPI9Q0Ko5H6huNGdCOgvEqMMdSZcQ2uxwQvBK
Jpq7Eq7V6nIMOJYrStAMUyHiLnf82eDSsfx2RkIwautigE63UXt6tRNDiy1s
kLs0RF3CqJ1CMBRwaSI46/cnEh/3/2j9g2w8p4SUddC0Ugh7Dyu5vxfknY1l
J+8MKlwE+ALxyq0k7M6Vul0T0hn4Le5yRCqis+J8WywTzV0FhNWuQEYrXWmx
z8wmjCKN33gupoh+55vIb0bzVzvQWn6/QM0kisiT5wQsF0HiS3H7+3oGes9P
K1npzg7YP6NeXU0LTStUW4VdxLIKT54o3lnApnxEvdvKg9qVpWGpMyadu10y
7nJGJXAeYoOVNvKbU+e3LldJ+kRIywlaZBvb09oybCYymcVsKoaKmD+xsKSZ
M92EZYpf+mPQpD4BF8VWQRN5ngO97l/iye3AJpJQ9Hxo2CH8YDjVXwFNC9pH
ZiMo/VJsk8M7Q8G1HDzJPPRYhO/JGZPORn4jeb85IkJzyUH3ypAp164zFBEH
xnNWLBzzavzGMuWNL2sbq5+KXz6hGhUmVotnqlN7C894eF28WHFLTPO/4Cq4
GJypWcXJvfsDl6AhfhkQykgSNH2Pihgk+4pGxpgk3hmKh/LgACAtLGpkTDqb
1De0/oMjmqcbdTqNhhKoPSUDnkiJabAcVy3F7fWbUsr2VMmfIjTeW96HxYc7
LgMDpL4174VxxFTxV7Pf76ALJl7xQgLqiQU/KXtoJtD07VYCXR75snPy+/Co
dgB+OMntk8U786rCJY4crkJD3mRAOqP+m9pvwipeSXFXtDYDgpo5MFCVXx7K
US9sMZUe9BvfR1L6DULEKRkujmXK4kns/JC3+4u/hIasfyz3CSWZQNO9Ylje
yP8oW0DMO4saiXTm1W41Wro9WRYcwIYRw/j3F3rG9xfQ9lHhYjNo+nmFeefX
o4m+fzqmJoF3filhv40hzDuPLew324X9hmWlsN+wrBT2G5aVqmNhWS67C49F
quP6Zrew37CsFPYblpXCfsOyUthvWLJeHo7GfsOS9fJwNPYbloFeDI5+ab+1
GJJkrGRihmlsv40ONUONEBitFNy5o5/kc3t9dckZbBeOf/McE5ush6NN/Mbn
OyvlGnEiLlvNhwLJqji3DUVZPnNMzNjS++1oNaya8WgwJ/aWWZkTd/B+FqKZ
eT5L9YPmZ95uycTx1HxqnVOdRsg9qZiC3iEhTbn0xyRCmf21Js/PDC7W5Fd0
tpalDzOcRtTqlcDRZn5Luhy+dIEiyYogesR53ywNGS5SnGIJp5rHLZ3EO0QG
flvxzyys1Wp7PKS8XzvVrKtw9j3Gzxu/6Z1voang2/DUDM5qIte8f7AP08B5
pLRTXJgrUntnV5dNCoKfYq5ur7zg1c3g7cD5vQg6vv6zi3hn5PYBJK0Sqzug
v3TXOciB7QtF9KkQTDHt3aAO2KvTo5FnB70qONrMbzD/lNZOwGWIqFOcIe6L
Evw0c5bOegJpisyHPG73X+N/4fdwuV1Od5ZuQ1TQl9Sg0HZJ7zeIOK0cmn89
aMp3oiw+hVjW/Kp2QjUoHaAwcpqtPD0nAMgD9vfh0a81ld8QQiWVCDQRHUEQ
vV2wPSfiNkcrAojd/72OUNnHnF3+yK8Jjh5S31yheFpQMpkk6lyXzkWj6TxF
M1QBJQ4hGFDCagKRaCT+n/8XUleOaK5QyBeYFkchhkGDQtslo/qG4PrUYm75
E13TE3nIb6mf4lOUOa4GRu5QILjBLGs0rFMhqAiB0fgtJ0GFoI8kFMnLIiqG
qZVyjYHIKo8K8sxCJhOb93vnw6CKHipK8ZuBo0395oY1yiPI7XJHEIHaZRtM
pZAncsCPQngu4v4CUnOL2lM3JZZGQxTaLun9dvJ9KZX6QCx/SAV5VEpbu/j2
NLG8zvz6WV6J6QAlZMiwng89RUC0GkHta5jQzgbsvPk/f/vJUGViISit83Dy
Db2R0EUM8p0rvquZWl7bpjY3EKqTJaVfkDcDRw9rT7XOaOdCqLF0eQKRSMCl
8JuiaskxqUiGqKBdGjo+RavWGIwXBkffPyUgoORPwW7zVGxV/g6vmY8i3Kd8
xSni6cI1Te9G6zfYX/qxDOoVaMLCmTnoPdCe8gWTZ+1v+H6dHw4NUEj0mljT
EAq9UFYc/W3A0UP8FtUsv4WWYpAWsWGSgpFU6zYIT92q8YIOhbZLw6+HPJzv
fLWpdhfszoHenWqI0dnLIJLOoDff59tT4zKCQNdFVkKMxQaRoxb5RZZQeyoX
zC3grsSm9PK3Akc/MD4FA1RBdButyeDLVlrtBkkAPzrccQO/sUwWoqYlplFl
6m3uVde3/kE2HNvah/nO/FoN6KKThj8dnB0fsmCHX2j1j4Wi5CPU1Hq3lR34
AerAgHHf/uHJMUKYj895N95cXbLHZfAWOfKQu7rkD3LXO2/+Pr++OqVXY1L7
yNe3FD8+5cllNF64QyHRsZVNrnd7xoBOmqJAvR042vT6m1t9+Q36hCvFJYDZ
E3Abt6dKzDlKtkxQaHuk9dsI+c7gS/wsLTaYKXKK18JlGZZ3VAfsya2M+oKe
5nqdUEz4C1zClT1F6PMJuSTvHFyULo6dodBz4cOsbCod8lbg6MfeX0Ck8sMV
im23WTtWQBouw/aUv3cwJN/5Dq53+kKc8oC/uWCwmOqgxxneXxjA+w7D06hH
l/VwNL5/ivV8ehiOxn7DekY9CEdjv2FZKew3LCuF/YZlpbDfsKxUHQvLctld
eCxSHdc3u4X9hmWlsN+wrBT2G5aVwn5759IhzGfUR37mUkycn2ClsN/euXQI
89HXpfL+eb/TJJRTLq0S9tukSEaYeQ22E94MqUc2XlbYb7xgyHLv2UKWDQ9o
Ak0P+pbmO6N9jtfRtLdF9fwNu/KduyLv7JHn4nIMYhc8bzri2dBvJ9Snee1c
RAPdXfyEM6jVMCA6cUFNlqnRAQ2h6fsz5bzK6WDZaB74EI2BMCt0S6e88yuK
f459+c7S/F53UpiaW8+HeID0nfmNpT4g/Kp8cnV5Uts7M/vt7h2k+D62BMv0
hS2Qn1L4zfCAJtD0/dHqXGqlfHJxyf3ZQ6C9caSgXuMjzPeDs9/n/GM6NaWy
q435zohfcAc8UhJWCFJZbjHCniUi4nRzpzuZZ+ArWCbi9iQLpWzE50JRzjbm
OJtJ5zcIvIwQCIXSThMfs0rgaNBr1g4RWa+sb4YHHAmahgFe07Gz0VqzJyDM
KE5OmKm+dKJsd+3Md4Z8VpKkwJ/uLNNCi4CQZFqkq9pENJItkDRD5xHdnK9z
3TbJW9Dli0Qjkfx//5eNOc5m0vjt7mITMjILi6mwfzYYzK6Wja4P9MoLPJEH
gUoNcNQ/hmST5DeTAw6HpgfNX+UiIltzCoThRRHmu/7tjX45HTvznQX+tAUz
UB1OFLzLMWkFzcfVaTJPENlkBAZNVlpdFvotUhAPZWuOs5k0frvZ/wQxmbkP
5e+bW18+zCJ4U00KD5hl0CNaPEGPod80/beaym9mBxwKTd/+SAVR8Zn6/Et5
deLNIMyP0hC/If60GoBFy8d0+TxT5LcWySc0uz2BEGxzUbCpkOAsDzBszHE2
k85vatLz1wcthom60KAZyqUWs4k5tOyeP7Ms9YX0fjM74DBomlcTMvV+9dDj
bSDMj9JQv8E2sF5K8z00iVau5nxwAQfBQIxb5Td1s2lTjrOZtP03xC//+CN8
tzfMEuyMKU/t4HL761pRyID+CDPHg3Mb33alXXhSWH7Jgwe810PT4qGOtdDx
W0GYH6UH/SZvEv3WgI2si6DqrQaTi7gdhn6zNcfZTLrxQuczAidrF52bqwM4
pguv9bX8qSRNe3rLXV02SVDBvFvH59xVb8gBTaDpXnEh/Pn7LnvVYY93shBQ
jcmdtLeDMD9KpuNTY7+h8SlLSxnNcnAzCxPq4QNetuY4m0l/PeTuajfjl8Zr
H2roMoWJ33rIb6oOuYJrFpa3NTygCTR9y4fXS1fMtv+oit5bQZgfpXHvL3Ct
RqPdfmAsYFeOs5nM7i9A7Ndw5dJxpT+gKTQ9GJisp/qEt8b5zq9DE33/dEzh
fOfxhf02hnC+89jCfrNd2G9YVgr7DctKYb9hWak6FpblsrvwWKQ6rm92C/sN
y0phv2FZKew3LCuF/fbOZRTZfEJ+jGkSsqwS9ts7l453RlPavFvHl9cX59eY
r39JTaLfJAm88205PJWlTu/6vZdZ4f8BYb+NpD5MQ7jW3q4e3DwHqmxCKD/v
0STemZ8RGkygRnaDUU4btp13diTFKZe6EJmRxOTjUYJ5uk+eS2Z+04HDKimp
ZEJClb9/UEy2nKP/aOaHXxbnpmbCn1SQiz7f2ZRQHklj8c6nGXGKO0fF+BZW
0CvgnR2uOB/PpgnJGlEUmpX+DEZ5Jun9ZggOq4Rwg9TqznW/w6xCoJhGE/tr
q3OZ1c3mn3P29w6KZl5TWAtFDU4r/WaY72xCKI+gJ/DOkLHKokBV6LdwUS7O
dvPOkSwM1eURP6Xf6hUxXMvpIShUACHs7I7E4z4+rzKQrnMw9xk+c7rcbpfL
l22zdMjlzjECZkNnA4EsnGTO0jmPL05kI0Job1oio9uFeEDI7vIlmefgu/R+
MwKHVTqB3ezFM+EZzMwSI8IV+3wJKmGB2irK8F3wKvxjlO9sQiiPoqdENvf/
bEIywg/8H1aVZbt55zjdImF+eKgOYUDBb3yacyRHNhrVPIxvc0MQRoCdXfFc
oUTAKF5ntMS1afj3vnihVMiXaK4NgRqJiSBh6at0pXhoZ4AolbJRj0BPd7lC
BGKvearaqFbQQ+Lp09LN2lM16KT9K4VtekYAJiLWxcjdMxJm2W9dDJAJNe2p
Ot/5AUL5RSObBzf6bqfdvHOUZLssxJYDwAFMEvmNhSygO8k06tVqvU7lYAig
CDtL8CkFHOeEQD2ddDnjIimjBriknEpUOaPCVg5CN1FSOKAnXUHv0yCz4F19
9JMNZ+a32hC/rfoVtjEAMGsodlmIx0WgTRFd1Woiv6n67Zq83QcI5QnknaEL
SJgsHqpUkmi8gHLGYTlyiv9zpSGcpfJSoxThBxfK8NOhfhN7htI+LMlnWopv
43S6Ak8PIh/Tb+b1bR+Zjc+Xh8dZhu1OJrOYTcViKHcysbAkT8LW5js/SChP
Iu8MmlIhztSVbPPjiFBBuzvvE0pb35Thp13UniZF01DD/cY3vpVnXnRkjPYU
xS7HToRnp7D/9oXvv/V4mq+oOKcsU94Q4OhPGRQpTqwWz2S/afKdHyCUJ5Z3
ZnI+0W/CwlyBbKneajWqVDoUgXuh5s+XLtQbDaaSdcEmFzajoIiBfck6jHrm
utUQXNkhV23VKzk4OjCIh5ZrYDsLXe7OkUyr1WJIIhBIP918er8ZgsMq/hSl
Kme+7t30e/tf5tBSWvfwCkMCOiH1ZefkN8pxrh1w6hqkaU8N852HEcoTzTuj
xQbdSeQKrpINySSzMwRHjmLzx8sdyvGvZJm8uG4XKnfSC50+43hoVEuFfiDL
JH0yMu2K5J8+QtX7zRAc1vDOJ4pLbYSwhBFa8kgd5axpvJqq8YJxvvNwQhnz
zrI4FsY8SySzVJc4tq3Fm9l2W97GtVuNVmv0jj+H4qS5ZyKmx76/gOqJ/v7C
8+h5CeWJ4J3bFVD/Is/d3Xp2TfT90zH1OnnnNlWqVB9a3sF2Yb+NIcw7jy3s
N9uF/YZlpbDfsKwU9huWlapjYVkuuwuPRarj+ma3sN+wrBT2G5aVwn7DslLY
b+9cOt75hFyKhYPzQf+835t62s33MYT99s6l451rK/6ZubUmmkbVvLAasMd+
mxSJ+c7Qb+K0TOuF/XZ/f3t9NUL+wuD2ptO5UUPpj5v8YwJNW5zvfARnjXph
Lpg/piZe7eOdNWEx3S6VdvPze9+09H5jf63NShMXg4s14/n+na1lKZ1ZjIDv
HOTkKZfejV+q+ZB6gNoYmrYz3xlN2szsys9t5J114WsISXh3fhtApimxugN6
NXfAP36YbKWrM7cIWvFuUAfs1emRMCcHlosZ/1ITVoMevRKUctmMAWoTaNqW
fGf2zyn/eH/Z/1rync39xtJZTyBNkfmQx+0O5BrVvEdgtRwuT6RUR5O+efw5
mQy4eFo5TvMzxOms25cVp44zERQDDSFAIs5PHHe6POnSCzbuWr/1duenp3K/
hKpytOLVE+793+uIJ9V8bWgVDjFCt78PypSXn/dqCFCPAk3bke/84bXkO5v7
TcCTHY5AJBqJ5xsMEYqkSyRFUyUYFci3uWLWczRXKBBxp4jPtMk4DzJ0uwKu
Bd6CpdNwoZICydBULupxIwjaIr/dXxbRMgugyNQYmNwnkX2SeFIgk4nN+73z
4bkidcgXwDOYDDg1O7dE7++CAjKbKCtPnQb4GgpN43zn4X6Lw/BTZcvKtqhK
iSBycVDOXMlWV8C1oiL+XAg4hqB/yITOLFm1INZN3387+YbSlgWYJahfMeYI
Eaap5bVtanMjBb2XJaEn7y5+Qr+Fhf5SllRGM2uB1qHQNM531vKkXeg3t+w3
xUJJdZhtitrMQCjkcQr1TW1XFWrq1KOmdFSEuOCCJPQLQhAav939Lspo/J9d
RCQt6TrVoDStiZ06BCAvlEFhJIAHltFVhf751jL05A/FWhwGfntgUYjJzndG
49MAUZU2wIhdhDCrF0qC2KAjIuLPwpoPw1H6iHLpBmkfrt1gqAJskR+/6tfo
0vhNG/9NLYIezpH61KL2VO7GbwEDJDb5jh8htVaDPc3ITtOemkPTsiY735nL
w6WJ3ARVbbdbdB4WMU+W7mr9xkIq2ZNkGq06XQi5HIb1TfIbi/p+0TzdqNPp
kBAMTaV9nihRhdBfiwg5XvSqi2F9S/HjU54RRlVIyZ/eId45trLJ9W7PGNCP
4mvIOaSWgvz49LYGR4vCkNOQRDaBpnG+s0IsE/c4ZYQ5QvDu0bSnLSor7eSR
21PV5TvFqg71pMhFS8HQ1UJcfhuHJ8+84EUXg/6b8gpYcHHfKN/5jPwo7ZNY
2eRP4t3FTkrKcYZXS4SGzIRENoSmcb6zznTtVqPR0iHMaoG2sPGIEGdIPLc1
rDzX5rnmUY8xpozvLwzgZf8H7i8M4D2I6572DN5cPeL+gjE0jfOd368m+v7p
mHqdvPPbEPbbGMK889jCfrNd2G9YVgr7DctKYb9hWak6FpblsrvwWKQ6rm92
C/sNy0phv2FZKew3LCuF/fbOhfOd7dMk+g3nO9unSfSbpLeQ78y2VTELb11P
8tvovDPa81oPpJjouecjvcV8526LInyKeZBOd0hg/Yz02nKczaT3G4/DyD/G
c2JH551VUyhn55aOlD7S5zv3DgnpIFra/WG9n3xnBFg5fEmyWm80qmQBBmgN
ifN4bTnOZjLw24p/ZmGtVtvbZ3bhT+30abxzp7gQ3iD32KvLEwQYirP9DfOd
OzAUyb9Yu+hc87ROcNQZ4O8s3xkxeo6cajOHWlWWiLilkpfMw5o2co6zGpQ2
jXW21G8QcVrRoitKPZZ3Vuh2wz8l1h+jfGeEUEn1pH8M/tY7YnV5b/nOCEZ2
uENEiWTqDUX/rU1EI9kCSTN0Pg5DA/N17nE5ziIofWgc62y1345WUPZ3ajG3
/ImuaWHn+/F458El/W2dgAUtzFwoTqgm3xn5LfdLctgh+NsN+QrFROU7d+uV
rFvuvjk8kaxoB65Ok3mCyCZhaYqjRnbkHGcZlDaOdX5h6f128n0plfpALH9I
Bfl8SS0MMg7v3D/IBPnWM1ZTdsm0ebudDdh583/+9pOhysQCPLjCb5PEO4sC
49MqTRJxCAd60nS3Rfp4XMsTCAU8DtFXo+Y4K8Auk9jTl9XQ8elgO2UwXhiP
d0bqwJU6gmuyT7R+g52rH8ugcoL2LpyBy3r41e3ppPDOMAVS1bhxcDmHaKUK
xw0BWuhpMRKw/Ogc59foNzR2MPDbOLyz8QG1+c4qISZ6UUmjTA7v3K6AttKV
zlfA8LTVqJZQTm6kUG9AzN5FUPVWg8lF3Mr69rgc51fit/5BNhzb2m9yncsm
9Wl2WliRb3zeubeXCS9u1+ABjxC1KtRAk3znu9558/f59dUpvRqTWmpBk8Q7
cw0y6lN23xyRHOqesXREjFyWgOXuGDnOQ2KdrfTboJlTxC7PJ9ZYodMyLu9s
ckCzfOebfYm29n5WLY4ENXG8M4duL2gxZK7VaLQN0OQn5ThbI8P29K7fu4a3
A4aencfwznf924cPKB6Xv7nwXIup3mPe+TVpou+fjinMO48v7LcxhHnnsYX9
Zruw37CsFPYblpXCfsOyUnUsLMtld+GxSHVc3+wW9huWlcJ+w7JS2G9YVgr7
7Z1Lyzv3ygn/bNA/HwzGwsFEpvyMd1pHEfbbO5eWdx6wxwcw2fl3cys1NRM2
nsn5csJ+mxSJ+c6iTlPTU+Xfo0KyzyXst1EkRCfo5yMZo8qjBUYLsjrfmReM
v1zYVO9jI+/cTosTKD1pyuDMDVMbwoQRyGSx1XwokKy+mmlwZn7TxzEr1KNX
ZCY6sbwpzIE0QZWHBUbreGfb8p3hfHgvrZn/biPv3O226tVqlYw4hdm5jxFX
pUokg3Ip6aTD4SQtIEtHk95vxnHMCl0z0BLlGnQCu88DpD1TVNk0MNqQd7Yl
3xmKycikqiwb850FsWkX7zc2H3EHcrSwVYpp5nOc43F+5QdXIM0zgwwRCYGd
WTrArwjhcruc7ixEAdsFhHqhAMskj0RrOOgXnVOu95thHLNSCAoIi0Ac7PPA
CmCGKpsGRhvxzpo3sijfmQ+P08YgotfYxzsLaicFv8HcSadY6OSYZiHH2RXP
FUoE2NfhjJa6MuPcKiAmGqY85wtMiy2Acunw5alqo1pBDwlOx0Fb7DdemvhI
la52Yqix2yB3aRjtF4btlCmqPDQwWsM7i1utz3c2lq28s9ZvLrlhldEqtMyI
xLmgDGjoQzmAEranborvv6GdPelKA7TU9QaZBVb00ZxRYPSLycxvtSF+u+9A
1MXvF3plieINv9EEVR4WGK3nT6FwvrMkE7+RccNc3UYpwiNXCsYZ+M0l+JEl
+SxKvo11ArkCFKvltl5UY/itCUmoxTP4cMAzg7FVBCgZocoPBEYb+018o0nO
dxbUjgvjhXbaJbenHKX2G2Va31DtcgvjBX5dEd0iSxou9UX1+PYULY4UXhcv
VtxCrF73hUuo8gOB0UN55wnOd+YYEi5TQ+WjaqLZVwI9LxKtCyfmOIMm0pcu
1BsNppIFe7iTVFfZnjJZyKiWGAhCt1swDNrhzoGxa6vFkEQgkNYFlFvtN0Nw
WMmfIi95y/toAavjMjBA6lvz3gRVNguMvjfmnXG+My+USs+vExLJ8fVIQTQr
c5xJMa4Z7RwSdjYMdIbL0bBM0ueS9ndF8qyOg7bYb4bgsJp3viyn5H1imTJ/
Es1QZcPAaBPeGec7S+JU9LK4rdFoqEBnqf8GdjdfdBUcilX8LcdHOdtxEXj8
+ws9/f0Fc1R5lMBoeWec7zyy2hXn0HUvX5sm+v7pmHpVvHObKlWqLx47/2zC
fhtDmHceW9hvtgv7DctKYb9hWSkDOBAL6yVlt+WxsLCwsLCwsLCwsLCwsLCw
sLCwsLCwsLCwsLCwsLCwsLCwsLCwsLCwXrv+P2OsQmE=
            "], {{0, 219}, {208, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{208, 219},
          PlotRange->{{0, 208}, {0, 219}}]], "ExerciseOutput",
         ImageSize->{212, 219},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "83c022ed-686b-4539-906f-52802a9cd80c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnc9rIl+f7+XOZpbzL9y1/8DduJjl4CozXNyYhcM8PoyLR4gDEoQQhAiC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              "], {{0, 219}, {
              208, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {208, 219}, 
            PlotRange -> {{0, 208}, {0, 219}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"07a8446d-8378-43e9-bf12-18bbac959274"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8db9c57d-7f95-4a59-bf08-3cc3a1e4960e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4ef56d14-5a93-411f-8c80-3adca5075f56"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"aa74d0df-421e-48f5-9566-f480e0ec5df3"],

Cell["\<\
Make a dataset of planets and the mass of each one\[CloseCurlyQuote]s most \
massive moon.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"2b72ae7c-e554-468b-b2f4-acf73c3d01ef"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"30bef936-8ab6-4258-9a66-ea4ae74604ee"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnc1rIuuex2VmM8v5F2YtnPVsXJzl4OKQOwxukoWXOV7GxfUSByQIEoQE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            "], {{0, 219}, {186, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{186, 219},
          PlotRange->{{0, 186}, {0, 219}}]], "ExerciseOutput",
         ImageSize->{190, 219},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6ed46894-e0e2-48df-afda-d36b1ecb4272"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnc1rIuuex2VmM8v5F2YtnPVsXJzl4OKQOwxukoWXOV7GxfUSByQIEoQE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              "], {{0, 219}, {186, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {186, 219}, 
            PlotRange -> {{0, 186}, {0, 219}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d7ce72e9-4294-4d4e-b7e7-f3379ffbb5a6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0a6c5d0a-e592-4220-bf96-fae670099f19"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ea10b98f-88d4-4a99-a9bb-b3cd55e3817d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ecae4fd5-474a-4a40-b7a9-3be734ad7286"],

Cell["\<\
Make a dataset of masses of planets, where the planets are sorted by the \
largest mass of their moons.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"61e43eba-e9e0-4124-a09c-a2c038d66cfb"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1a6988dd-5b94-4c47-a250-467bae2eb60a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnc9rIlubx2VmM8v5F2Yt3PVsXNzl4OIl7zC4SS98mdeXcfFmiAMShBCE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            "], {{0, 219}, {186, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{186, 219},
          PlotRange->{{0, 186}, {0, 219}}]], "ExerciseOutput",
         ImageSize->{190, 219},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "56c0b413-6040-4d03-96da-93681c009dc9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnc9rIlubx2VmM8v5F2Yt3PVsXNzl4OIl7zC4SS98mdeXcfFmiAMShBCE
Dgg2eO2FNoMJjAlUTyZ2NzZiT7C7qaap7um6TREiUZKUdCVtJ0VSGDFEMJA5
59QP66cpo4lJ+vmQe69WSs31fH2ec47Pt55/+NPMH0N/4/F4In+H/vXHYPTX
2dng3D//PbrzL3+N/Ntf/vrnf/2nv/7Hn//y59l//NPfooM76J//Rf/g25cA
4Jo6AAxD++cA/Z9O+qN5vwG1AO4BtQDuAbUA7gG1AO4BtQDuAbUA7gG1AO4B
tVxenkuiKErt237r7yEOamlmAh6PJ1BpqgckLuLFR+im5dz7g1UtPfFTyKPw
69waKGYwjmrx4zfQn6KV97kQIe/oA1OLlP3V4/lDYltqf/999RePJ7S2O5lh
uCc4qSXl8/jDKL74aRG/zUgrvoAf3yVqkXg6HvDKH8lIriKhQyIX8wdSxXIu
FvT5/HkWndcspsLyOf5gnOabhZg/nGflFxDZnD+Ya1oeuPQ//+nzhmmhrZ6W
9/vCzJgkalaLRCOF/LapRJRPiV88vy5DeBmAk1oSXk+KZtC//TlOoOMeT4ym
M0gyWC0Si0TgDWfYOs+WM0g0kWK93aRJNPL4grF4LFbgmsUY+o03VajQlULE
54mVt1NejzehBKsmnfB4EgK5ZXjg7x+DSF0ZhpwlUeTOuOKZSS3t339D+ed3
VR+b2T94fvkN1DKAAWpJMKJQxAkIjXqQqkucopYmk0LHKLZar1brdS7l93jj
lbaIBz1WVJ9KpH3oblnQnlGScLzyaWphsFpIbDE+sN1m0DN6wlV0Syiil07Q
/ScZs1o2s3q1/P7br55fsqCWAQxQSxzHkSrJJUEOjSoWCVYLQ2bAXq+cidB/
UZhhZHkktGmNrIGKfqCNaqH7ajE8UCcSLoefY4wLNhexBdQyiIFqwWNdL2dS
BQ4fUtUiVOLKZ1+PMuiqPJoWDaCZs6+fiSTGpBa9riQKpzo/Oh7Mc+OSSts6
bxEraN6SNcxbQC2DuFIt/UOqWtpC2YeXRymmzgt8vZKPhdHSyTzoAllVhcsc
3xSqVDycqgh0Ao9/ucpXaSqIwocv5aAWNLnNyEswRhyjWGzWRL8hufwhu9s+
F7dfoZvTq7AmGoTjmsheLcqaSGCpgKdPvFBFiQqpI6VfvQhMzK+d4qM4UeQK
2oEAWlIparE8EFNFEyY8HRorNvst3+lp9U/65d/XpImMwf1hhL1cqSkIzeYV
H36x2TScI4k8zzelK56aKNNTqF913pA47eWKsJfrjju5849nOGjpPtYshIHv
iUbkbqqFKZdZfuxiAbWMyp1Uy00BahkRUAvgHlAL4B5QC+CeOgAMyaQ/9LdE
HWLLaIBaAPeAWgD3gFoA94BaAPeAWgD3gFoA94BawH3mHju1kJLIWFF/iC/H
tVKo+4tVLeA+Gwrb2MLmAsYqRzEfwDWy468huF0sagH32XDYZyIeV93Hyrxy
Vyiju3FSwG/jO0PqykeC8UwqItdRBvIMfmDfX9YmFjPFktZucsWIX/ELhBPl
21SgWS3gPhsSh3mLiM0ZASWYVPNBFFlYycF3pjiAPP5YpkyMZh4vLubv+8va
mgVAaEscei5fnGI5rkIlfP7E2MxCw6sF3GfD4jTL5YsxNKrEPSak8DSm3G47
+M6QWhI+T6yi6iIhZ7G+v6ytK+xvVnDdf6YiiGOuuXWDWS3gPhsSxzURKcUP
UvW2UEBxI8fiMGPvO2u36YTPG9dMiNhIUmkStXgtamlLlVRQnVd6US6bYCYC
99mwDFhBY1drIFXAConJMxh735mdWmhZLZ6YkmgkrL2+aUhq1jmGSiDZeCu3
uM4yz1vAfTYkA9Qi2zTwtDWjXBjB3nfmEFuIE9YTL7B8nc2QCTDJRHQ4ECtz
vChJ1XJiwmoB99mQDNydq+LLJHh8Rb5/yMZ3RuYtRrUo1/FIqacSlyqxmElo
cdR/eCTP3LBADNjst4D7bBiutZfryncm0xR4wXKmKKInmMA812kvF9xnLoGd
f8A9oBbAPaAWwD2gFsA9oBbAPaAWwD11ABiSSX/ob4k6xJbRALUA7gG1AO4B
tQDuAbXccX4wz7IvtrW7+/TyYmhq9lG01pnAHwNqucN0SlEkjKnFlU35/tnW
8uyj6Q97x6dHh6e9CfxBoJa7zFnr8EN6am5JVsv5RnQqxxxcdDvdSUjlEtTi
DjRApyetM/MY9c46rdNW52LkUZA5a7Wkk1bXeHB3JaSqpbWOclBoJjkfQgHn
FXesO+u8wX3db924hhzU8rP0PpNhs9PqiJjpfn+/+AinA/kn/3ZHPv7j7VPt
4Gxonv1+PtTbbnnF1rt0SH3C+a2T/rjX+mo5yD6aqRExSczi7KPlM+2kzte5
R1MU1xrqb7gGjmr5KXqfXTZeL8pjpM0NTJzV1hbnl7f2DqSTgw9LM2jaII9J
7fl89vn7xvdD8dvnHPrIz6yd2T7egu0r7r+ZR8/8rnZ41tqhZtCzrWrPpost
56UZlIkOL2W1REv9mNbdRJJe35qYWgb2PhMp7Qr+Xr/cYcTa+2yCLjMnrGrp
njR297bfJacWHGKLgaONWTwo5tXI/ouZ2dDyqbs33O4VO0gGc0tflRNqaCob
Ii/S2UgqAWfh8cszNdDNhabRmsgQzbqbC5paujvUfGgx+x4Foe7R51x0mkS/
mWR0Jv+24e5vdMRJLYN6n7WbVDyWK9IsxxZw3T65IL+5hdn/TdBl5oRTJtJ9
fgch0k9m1Vygo7MxPzUbfak7fJALTb8iY3dWezn36Mm+ZUJhfEWiFi3UdOSh
d1oh986sMyVZLTWkn0YOa+PpPtbKThrdjj7lattb9BqS2YJD/HTPALU49T4j
SHWWLlBULhXDxfwVwdzCbKIuMyec1FJzoZbuXgl/xle+mh/7PIqOb+zpB7fz
KYtiwvT6i2U0iHPpDWuSMrxidyepzyNk6Et7w+ynyJnoy9d1nMWe/SDiPCMx
StX2uUGQ12WAWpx6n7UFWvaP+QPhCM5WxPphbmE2SZeZE9dWy9leCU0jZ5Ml
07hvEalQZC5hpPfuMZmyzr80hyKbV+y8Ck2l3x6o93RpxSXdzaQ65S7tKYGs
8Tqqy4+dVzM3G1ucep8RW3SYVYaf8xvUYkw4E3KZOXG9TCR+WSWT0o/G+I8C
yAweHbthRepaUIZvurR1bD3BlInQUM5mP8t3urVVdd7iGhJbkktr61iiM9wJ
+RvwVt7Mbld9idBtqKV/SFULj9OTj2LqAs/lY36PrVom6jJzwqqWi25LOjn8
hNaz6ffiyfEpeW/ROghvaJAB+0GTlXJ0efdbo1Hb3q1tN47Q8fMPSSyG9IvP
+992dslxSQsivW08F82+v7jssTglhXa7V7wijgOPQh/2jrudxnp0yv2cWYEk
r1c4qhziJdWjefy9QOszVuzjZx/oUn5+esC6zz2Oa6IBvc9EVnOQ9W1lphZm
E3WZOWFVy+7zmVnddoq8ZaFXy+6LqP4E9EMWL8qevP5HnzvEvR01Z3Uae4dX
vuLl5fFGclrbb+GOhtxn624ndWsivKIPPUWzl9O9jfQMetrp7MoqmvEu6r5v
uh7X3cuVBJ5vXtXDbFIuMyfu+M7/WevYupc72hOq+YzEGed1lltg5//h0qKU
reYpOZmKIz8jqOUBc3q0s/Xl46e3G+xWYywhC9QCuAfUArgH1AK4B9QCuKcO
AEMy6Q/9LVGH2DIaoBbAPaAWwD2gFsA9oJa7S+9gnZT3z4aiH/Za2kFq/snu
GL9MGgZQy92ls0mtbIidzu7rebnC/wyXvuAKlpG/HrwmoJZ7QPfzwqNnuOKl
2xFrpaFrpcYHqOXy8vy01TqblP1Ph637DOWeT8mpObWyjhQ+WdUyUfeZqbQJ
94Pwe3ypO1D+NhJWtUhbL9WSyKnFrE25tUIP19Lb1so23hAjwJAfdtfus/MP
6enZ+bV+KZ2tWibrPrMU2TK468yDU8vJR/QmLy69lzqdfQZPCZKvdyzvUGfj
8bS1Ok5G4pbliYR7tQzhPuserEenFogzqA9Ri9mlMln3mbNaRDYXCGcYuhAJ
+P3hPF8tBJQGNB5fIFauk9pu7ETzx1KpsE92GCVI0zOnbmgSQyXkqkyvL5Ap
32BaNKlFvmTBlvrOby1N2xXE9sRvO7tf1qxq6X7DnpH86zW71OCIe/cZ+fOm
5mZCc+olOM72tEgYKukFOln3mbNatMYi4Vg8lijwHBWJZco0wzJlXNAtZyvV
iRbPF4tUwosdskzboRuayGZwZW+R5lgmHw/445XbVcuUFr/3X8/MhlbtkxEp
zDaopfV1EVe6oli0bVHLjbrP7Jis+2yQWhLYHqLPSaLAVMoUlU+gUOJLCeTh
SC1x1VtUDHvkDiO23dCIhLw5unoL5bsmtVwcvccuoeiTD18+s29WsTt+xkEt
XaPHp4sHZWGJzDx7WC01gx5+MveZPJT6WS7uiqeqRetoht1GCcXPGo5EAl4l
thjFpvWjse+G1mTjqqna4w1Q7A1aYK2z3NNvH/OPZ/Ds5fFikqjF3pphVMvZ
1jOcIx4/ySWfZJPYFLA4P79OH+ge8DO5z8iaKEz1u5xhC5EXJxFDfCBGEo/W
OZpLKb8yqoXWq8WhG5rU5DmmiHOZTopjZ+B+S2c91J88WIZDzkTK5/3iaLP0
fK30YvUV+vcKWhNN5ZaWP+hcZj+Z+0wqYEern2KqzabAFnAACeTYtlktImkc
neJ4oc4WcbdWu9iiqcW2GxqTCQbiVFVoSpJARTw3uk63iy07+0fH0vdNap7s
kZIPtN5PhO+eHIt7Gyj+5Okd6eTYHCusmeinc5/hNUtC7fuMdROj5LE3ZSKB
yWknBfqZyLBdo+uMZtMNrVpM9F/GEyhwN7hMt6qltqR6vmaecEfKNS6MaiEf
/L5fzPKpt9sA+TndZ2JT4HHvsoETUJRF+CEsZnbd0KQmtqldZWYbGZtM1MMb
uaed4a7sdEOA++xOcV+/J7om4D4biZ9MLeA+G4mfTS1jB9QCuAfUArgH1AK4
pw4AQzLpD/0tUYfYMhqgFsA9oBbAPaAWwD2gloeDxa32g1meI5v/yezGcF9q
OwBqeThY3Gq7r5ffbR2enWymH01R46jxBrU8QDS3mspWNpT/AmoZDnu19M7P
xly0cH56ciy1btxP6Mqthiv9NrS2StpfeD23moNa5N5nnpRa/2YqgnIJV0jE
KW70UR4XFrWcf+h7vqYW0i8lp7fJtftM/LI2pxU7zTypkUeYKqBwGdvz4crY
ru1W637DVX+lmvEvv65bzVEtSrehBC/fNxRYuoUh3QLGMMxjwqKWVunxfInZ
/HFy3GCWx+A+6+Hq/eTzz2jOcNHazoemZh/jDmVnRztb3Ffys7m79X4os8Yo
brUf+H8q9Mnaxe+6bjUntaR8nlgu41NbDunVUq8oUsIl+gwJPrLdLJEIkqJJ
XzhTl7DXzEscZX6/zxfMNUU24vPnOaVqjs2FwzlsMhLZfCCYoHIxxaaU0bqk
NYuJsOJrC6a4cXSsGThvOddbwHQM4z7rfF1AR74oZdu7K9NWy8nZFjZFfnDd
h3EEt5pcIzq9gIstkYZ1+ryuW81JLbibFSvQcTTgkTqutFXUIrvPYnma56uF
BG6lh5uDKHYzXyJfLFNIaB5vvCw1Wfz7YKJYLhbKrETsZvF+aTcKO5W2Zmfz
hqlyORcPKJ3U2lIxhptoFZgqX62Qm9TodZiD1EJqEbNvD+x/69Z9dlwigSi9
slHjsK/Q0rroMI/GIv3RePDeuNUGqCVOi20RtzALo/FT3B8i7k3kT3F8vVqt
15k8ruFXG59prayIVQ3bSdiUz5tQu4cMso3E9baROK08YSBTIa/D0zn0qkF2
ZLk4q+WAwp/Hp461iK7dZ/tvcOJYVAq/Z/TdVy9xp1f025BlvnBv3GoD1YLH
kE6hcYtUKikyy22m5CSkeJ/Rf3wZ3G7GoAS+HJOnxHS/2n+wWiyWNJGWzQHq
y3i9vjAzcjJyWBMdEFdFtDYgjbtzn12Q3CR3zTv7/pXU3utWsj384XWYsdwP
t9qVakFJSHF1YPcHmf1GiubTjd5GLbYwerWQTJRSh5wZrBY5bVXG7Fu0UUtr
M0v8FFfUrbpznymGLzWcSAz6VVQzE5GVUdT2ImD3xa12tVrQQjgfVNWiNIYO
58p1QeCrTCYSw2eRxBHMFOs8z1VyPtUmT+NrJ4TpOl/l0Fykiv2OkXxVqFfy
eE7rTzirpd3EvjaPP09zgiBwNBUOZ0aXjlkt5MOOFxdbO/t7pIXZ3uHFCO4z
Obak5TWR7CPTZrlkXpS2WXPdJ7ea45rI0PuMNJr3yy5CqZKL9O1i3gheraiJ
Q7GqRfLyI0WuoFqcSajRHugNhv1oTmw1R+M4psx/RC4V7LdP88UKo6+KzGrp
9AOy8kPe9lHcZ/v0s1ndfos2b9laQjJ48sNhP+y+uNWuuZcridgtplnOtJgg
iRarmths9o9J2HsmuJ+uSrIrbUy2tFva+e91pFvay71tt9p4dv6bFeyeH/c0
Y+z8LN8TXZOr3Wpj+p6oyZQr1Rt3po4KqGUwV7rV4FtFwD2gFsA9oBbAPaAW
wD11ABiSSX/ob4k6xJbRALUA7gG1AO4BtQDuAbU8HMB9NlYeuFrAfTZWHrha
NO6t+0zgaJq7K99NX1stF90O7o82Wm8x+UnG2GPtrrnPdPgq7txEYrUQCaeq
6tfRdByXMoxxxEfBrBZS0Wr0hc2b+1L1GrlQ/4T0ymfT6JjcZ7vPo9byKjQ6
3Mq8enB6nXFwFjhzx91nKR+unGRouqLAurSeiWzK4/HSaqEbrtbWyv4njVkt
vdauYgr7WqttlnCRqqVutrOZnX/K7R1IJ4fsczzir3R6svY+210JzT5eQ8+m
2M1qBxdKqf9U6UvjrHP4YQnXwn06cfu5vhfuM+InMtercFTcq9VKxinZxmjo
hvaXxJ/lM3x+n9efY5tMAskulYrIFZeBPMPfgiqcGJiJGlm0dhh8JfzOZ71a
bHuf4eL8FVPxbacUnZpNbqh3saVo4bnbS+7fC/cZii2+SCKjkEqlqLrUZvPx
eKbAsBxTxDZGf4Z0NDN0Q/uv/07gkm/c9axQ5ASJIX0g/LFMuVLATUZusqHM
lQxQSw2Xv85bbV8yFyfb714sJ9FYJF8qQd6h99nuCi7sz6Wf5JdW2dqhMrhR
vePs/FXIZNW59+4z7Bvy+QMKfp8/xsotE3muUixQeWxI7Jdh67qhkUzkZ9Sw
hGOLOm8hbc4Co9uCro2jWlqf5wYYFdEbqTY0XJD7ug5wn719lk4/pZaepknt
d5oEKzkTJZdecl8+bqwsWsrpH4L7LGEe12Y+IvucA+FYDLfFsxbtK6HGp9oW
DQY0+VcuZ8s3gZNa2PRAo6LKxdFHNC455tBF77NLvDZJa7Pc3u7b1STOCKF0
et7uGgsPwH1mHNcmdrnGysrEg0vZ2ceUu37DLNeoFvqOqeXiO55+UF9sPF8W
DrJ4yrF5Ze8zGTzjtTp9Tt5jP+M3w8zzvrvPlDURWhQpsE1iAwnmKkKTp+VO
rFb7GLYB5fCFX8octpw1pTsfWzob8+Z2ino/EVqSJLOlxvfj05PGO7KcMQ20
IRN1t3PRxQ9bDal13GBW5x5p+x69H3s7Ijr4hWS0x6Wu8Rnuu/tMveiGfr9F
Kie01mUBe/sYGROtwVmcFhizWvph5/axqqW7h4VRMm6y6NWifdUi/+TfWNYy
evdZr5HXWdUWkmuiEuZb6+pBpD3rNYUeqvtMJHYwF6c1xVto2Tsk197L7XY6
pydut2HlPdvTjuHsi05rvBu5l/fXfXZP+Fm+J7omt+Y+ux+AWgYD7jM9oJYR
AbUA7gG1AO4BtQDuqQPAkEz6Q39L1CG2jAaoBXAPqAVwD6gFcA+o5eFg5z6T
CyEW+99vjgSo5eFg4z57trF12G01KH311AiAWh4gZvdZ71NyOksfOj/ALYPV
Itcn3L3Sg2sydrU4+L9uCTfus7O9l6QG5onxC+Xxus/aAkMFvf1aKK8/Uq47
ljHdtR5nTjipxeLtsuHi6COuTuw7O+z9Xw7uM3kYHRuoXcm13WfyQTY9vbCi
K20ar/uMXLffE0zR1TrPV+kivtD/gIsn37UeZ05Y1WLr7bKhs502driz9385
uM8GN1AbzAjus96Pb4fybTY9ZRDbWN1nxMrhyRsOSyQfiVTMr4WbVAHHE9c9
znQmtXCed2x5dqtqsfN2WTnE3YuSy7l+Gby9/+vS3n12OaCB2pWM4j7DJcdK
x4Fn+/qMNV73GWn44vFHqDLN1XndvKVJxWO5Is1ybIG4zAp1abgeZ4pJrbBj
3/LsttUiY6yoN4HCgtxmCFtsDGqx83/Zuc9UrA3UFG7QfXbRPT+ztqMds/us
Xa/k9HXcgVhOHUypztIFisqlcFhIkPTkusdZ36Rm3/LshnFSS81RLT2O9P7Y
J7exWuR5i7P/y9Z9ZhgjG7Xcd/eZAloTVVmaIt0wAxm2LdBBuadMIBwJ44Ag
q8JtjzOvyXZkbUt0swytFjIbRLEin36SS87jna5QKLuEgrYb/5fefdYfVodM
dI/dZ7jPiyEtSLibWbxSxbPdMKvMMDi/OsRD9zi7Y2pxzES940+v10ov1l49
Xy29WF7EE4D5V2++dt35v8zuM2MDNT332n3WrKAs48sUKmhJJPDVMulCFSvW
+SK64aOYusBzeTLd1WLLcD3O7oxabL1dpt5nKrpM5OT/cnSfDWygds/dZxJP
x4MG+1ksT6YlIhtT25F5/fhWivRSHLrH2YCWZ7erFltvl4NaOkQt2hto5/9y
dJ9d0UDtIbjPJLKVK5jaDkkCzzdtWhGN1OPsdriBvVwb/5et++wmAPfZjfKz
fE90TcB9ZgDUMhhwn+kBtYwIqAVwD6gFcA+oBXBPHQCGZNIf+luiDrFlNEAt
gHtALYB7QC2Ae0AtDwdwn42VB64WcJ+NlQeuFo0Juc8eGPZq6Z2f4QIDS6mz
Doe2Zb0uvgpu58J8+vnpybHUGqqa7TrcGfdZ/1rcgcywvaia2F5C+oaY+qBN
HItazj9l+7VGc/PPdm1G2L5t2Q/6ma5IaWZDLY+8OPma1qqh0iVDPfZDdZ+1
20K9Wq3SMa9S+TYMUpUpy70UTX3QJo5FLa3S4+grelM8Od7n8BX4rZWoTm3L
dp/Pp1c29o+Ope+bVFRrQdLCNXLRZ41WR9x6iUYk/aYhD88Ddp+piBmlrYxY
iPnDeVY5yub8wZxcYRnz+2OJhOyB9YUzsouEo2IRdLLIho190FDYKRL7AD4W
TMkGNZMr7UarLQfOW0iTKXMtt6u2ZY0XSEWL2GdB+hytq10DtpamZ2fWSHh5
0O4zBdIBDaulmfJ6vGqQIU5GXH+LbpF85Uvki2UK97fyxsvtvuNMKBr6oIlF
FKo8wQJT5asVcpOSLK60Caild8y+eUnhz36UOzLNXga3Les1vmyUSHeqPI3f
WDJeIV1HzpnZ0HI/GT1c95lZLb5+SuqX6xO7tFZ9zWAbCVaR5iEy9EEjJwcy
FR7luDpP55CQgqxkdqXdKPZq6W5nZ+Q0sVizNMcc2Lbs/F16hnyQp9a/HJCx
XtWrpYYdIqt9tTxw95mDWui+WvTODr4ck8v4dY4zXfsqkZYb0cjZyYvwhRnR
2rDmBhmYiVqkUdGaZaSubFt22XizKIvELra4UcvlvXafqeAOaLJaMr5+JpIY
o1oYx9hi6IMm+6MtF2ow+YxulMH7LfatyvTYtS3D7/2e6v86+Tina+pK5i16
tTxI95mE+8PXeaYQN/rLgmU046DJdV18KS0TBTPFOs9zlRzu4ppi2vpMZOiD
JuRI+9Y8Wi8JAkdT4XBGmKxaOpvZ6JNPNWwW26XJFJE01jT6iWzblnXQYmr9
7VfxpCXufc5hr9AimWy01lFiiq7ud84l4jVLvm4oeniw7jM8p5Xxx/JyLND5
yzyBgFdTi74jvT+inKwzuhr6oKFnSQV92vm+WEG0aZ12i2pxMIsZ1WLbtsyw
UYPeba1D98XRZy3IzyVL+sD+cN1nksFLph7jed5gO9PmLeh058uNmfqgSeTq
ZNIktuxsMxFaNQw2izm2Lev18CawzZ7tuXRLe7n3yn3WrHgHXjPqrvGzfE90
TW7afdZkypWqjcv1jgJqGQy4z/SAWkYE1AK4B9QCuMfGLgIAzkxasAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAOPh/wFBdACl
              "], {{0, 219}, {186, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {186, 219}, 
            PlotRange -> {{0, 186}, {0, 219}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"125801f2-6300-4349-a57c-5a842040a3f8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5a2a83a4-6bc2-46da-b2f9-8ae9dc58afcf"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"50735b8a-e23d-4745-b472-09a53cef1538"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"61e3560a-8711-4e5c-839b-5a51362e51cf"],

Cell["\<\
Make a dataset of the median mass of all moons for each planet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"7301c91f-3fb7-4a5d-97f7-fc7077e1c12d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1a6a2610-16d0-4357-b73f-00bf8f26c176"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnd9r2/x+x812s8v9C7v2P7AbXexy6CpnDN8kFz7s8WG+OIZ4YIIgBEMD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            "], {{0, 219}, {186, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{186, 219},
          PlotRange->{{0, 186}, {0, 219}}]], "ExerciseOutput",
         ImageSize->{190, 219},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ec818284-edf1-412d-bc45-c7807f3078b6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnd9r2/x+x812s8v9C7v2P7AbXexy6CpnDN8kFz7s8WG+OIZ4YIIgBEMD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              "], {{0, 219}, {186, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {186, 219}, 
            PlotRange -> {{0, 186}, {0, 219}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"738f0d33-5b3e-476f-a972-756e09ff9126"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b6a91596-9442-41a8-acdb-14ef19dc8654"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"09c9075a-4f36-461e-a086-0beacafab4ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"344aab83-5495-4fb3-97ff-fe5044719f98"],

Cell["\<\
For each planet, make a list of moons larger in mass than 0.0001 Earth masses.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"2f48285e-ce2c-4f88-86ec-119f3fc2c680"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"12d8925b-0268-4e5d-8aad-d517f659f6c3"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnc+r+t6639N20mH/hY4F6bCTDByWDIRbihMnXno81MGpHA8UcZZZ7khH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            "], {{0, 219}, {304, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{304, 219},
          PlotRange->{{0, 304}, {0, 219}}]], "ExerciseOutput",
         ImageSize->{308, 219},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "58a5bcc6-059d-41d8-b80e-e2bc8058222a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnc+r+t6639N20mH/hY4F6bCTDByWDIRbihMnXno81MGpHA8UcZZZ7khH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              "], {{0, 219}, {304, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {304, 219}, 
            PlotRange -> {{0, 304}, {0, 219}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b1fbf131-7981-4774-9b1a-37ddc5b870a8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9de165c4-1b46-438c-a874-8f0cbcfa56a6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"700bf39c-4f5d-4d89-b84d-6da23bbb722b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"42c8e360-b6ce-48e2-a014-02a17b0409d7"],

Cell["\<\
Make a word cloud of countries in Central America, with the names of \
countries proportional to the lengths of the Wikipedia article about them.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"cbf66fd4-4fbc-419e-8aa4-27d7f7586682"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"873eb8ff-cd30-4a1e-8d0b-852dd477fca8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfdtvG0e65+zuyz7u87wdYP6CwQyw8NsiyMP6LcfYPCUZHGNPnMEEiXOy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            "], {{0, 199}, {360, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 199},
          PlotRange->{{0, 360}, {0, 199}}]], "ExerciseOutput",
         ImageSize->{364, 199},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "957a722e-9bf1-466a-ba0e-28d0520f3a9b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfdtvG0e65+zuyz7u87wdYP6CwQyw8NsiyMP6LcfYPCUZHGNPnMEEiXOy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              "], {{0, 199}, {360, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 199}, 
            PlotRange -> {{0, 360}, {0, 199}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"446a6d46-932a-4757-a9fc-283d8ec5106f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d5a2fd47-2e1b-4632-b793-77ade62797b8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5f8da03a-1688-4667-a903-84e52c431117"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b975f9ca-92f7-408a-810b-c6ce8796652d"],

Cell["\<\
Find the maximum observed altitude in the Fireballs & Bolides dataset.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"9b4fedba-43fc-4b6a-b1b7-8b28d854c713"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e0f62743-17f6-44b1-8f56-324c045d00d0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztlM9r2mAYx8t22XGH/QP7C3bddcddu+xaaFlXh+BIHZR6sR7Ew0A8iFA8
NAf1IEURoQohGAkqKCjkBYVQgpFaQlGaiEpCA937vokxiTJYd2xfVJ48vu/z
/bzPj7w/+Ln7/dXOzk7wDfzZ3T/5dHy8f/rlLXz4Ggj+OAocfvsc+HV4dHj8
8eA1dL6D3w/wi+zHl/VMlzbuA1l9+J8QhnoDmjRXZ6WpZjvvRdBhrlptMDO2
HppLfINjaCDcrH2LbtRP5HnlySRLsRT2E/anJiKeQfHU4YyPPTzGTT60PpIo
Dyy/BhJ+otx/MoxSDmE5hKBwmZwEjTsWSWTaEMG4axeKbQ/LuHoGN9ACEh3X
qZqtroHff4ExNH2deG2peatp3NEwbIGfu7QYqHUqba/Oij/JbvnHAWPcsik/
kWWG+qiUiFG9JmWmMcsMZP4yiu1Uhl06Ti/7cA8JxOtO+ZKushLqvYdOkohe
NGSxQRdzXBMsPYoLpFjoXovNUqVY6gmyF0bQHrUBJAnHLmdQQshhjLNOH3AX
JLbJGg86edQJrdt1flY7ifR5MhWEhq83nVciZjOQ2YsYMiIopkMRC/mJaCye
jfugQTFDJ0yFByhCiJqsJXxggQsxQv1Z7uNCGAN0KUdNTRhuZOINKdSN3UrI
upQdarBwZQZ2KVW3AEBmLxykZiuYlN32EVcEYWFdZN3hGw2mo517QDWf5pUg
Ec0DIe8Lh3I6dhm3V14Y4xoqpuvWRItF3wZMrMfTUCiFp8wN4wDY0u1yHhU3
J00nAhNHMyLOdZxMqtqdqUM6joLD0Z600xCbG6F5QLR+siXI9yILbxo+bxiO
pBXwe0bCEwdb4l9g4EA17Nxmq8B0SvXk6jVCtkRUYnOcK4I5d5Na0mduiMZz
sj13uJ2slnicoKGLlBQEQ9owCTuIVTLXIOP1sFQV7+Ab85mq6K49roP6Qpmp
m6Fe1st6jusPu6z0nA==
            "], {{0, 20}, {47, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{47, 20},
          PlotRange->{{0, 47}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{51, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0d40f66e-1767-4818-adba-d5c47c19d06a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztlM9r2mAYx8t22XGH/QP7C3bddcddu+xaaFlXh+BIHZR6sR7Ew0A8iFA8
NAf1IEURoQohGAkqKCjkBYVQgpFaQlGaiEpCA937vokxiTJYd2xfVJ48vu/z
/bzPj7w/+Ln7/dXOzk7wDfzZ3T/5dHy8f/rlLXz4Ggj+OAocfvsc+HV4dHj8
8eA1dL6D3w/wi+zHl/VMlzbuA1l9+J8QhnoDmjRXZ6WpZjvvRdBhrlptMDO2
HppLfINjaCDcrH2LbtRP5HnlySRLsRT2E/anJiKeQfHU4YyPPTzGTT60PpIo
Dyy/BhJ+otx/MoxSDmE5hKBwmZwEjTsWSWTaEMG4axeKbQ/LuHoGN9ACEh3X
qZqtroHff4ExNH2deG2peatp3NEwbIGfu7QYqHUqba/Oij/JbvnHAWPcsik/
kWWG+qiUiFG9JmWmMcsMZP4yiu1Uhl06Ti/7cA8JxOtO+ZKushLqvYdOkohe
NGSxQRdzXBMsPYoLpFjoXovNUqVY6gmyF0bQHrUBJAnHLmdQQshhjLNOH3AX
JLbJGg86edQJrdt1flY7ifR5MhWEhq83nVciZjOQ2YsYMiIopkMRC/mJaCye
jfugQTFDJ0yFByhCiJqsJXxggQsxQv1Z7uNCGAN0KUdNTRhuZOINKdSN3UrI
upQdarBwZQZ2KVW3AEBmLxykZiuYlN32EVcEYWFdZN3hGw2mo517QDWf5pUg
Ec0DIe8Lh3I6dhm3V14Y4xoqpuvWRItF3wZMrMfTUCiFp8wN4wDY0u1yHhU3
J00nAhNHMyLOdZxMqtqdqUM6joLD0Z600xCbG6F5QLR+siXI9yILbxo+bxiO
pBXwe0bCEwdb4l9g4EA17Nxmq8B0SvXk6jVCtkRUYnOcK4I5d5Na0mduiMZz
sj13uJ2slnicoKGLlBQEQ9owCTuIVTLXIOP1sFQV7+Ab85mq6K49roP6Qpmp
m6Fe1st6jusPu6z0nA==
              "], {{0, 20}, {47, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {47, 20}, 
            PlotRange -> {{0, 47}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7da996c4-4018-40a2-b058-4e563785a67b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5f32b114-8f64-4d44-8468-7dbbd185184c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"688c7ae5-9e88-4c6f-82dd-4d432c4747fb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"690df5b7-b5e0-424a-8e0d-6daf9a4cda7f"],

Cell["\<\
Find a dataset of the 5 largest observed altitudes in the Fireballs & Bolides \
dataset.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"a3a7a021-4e03-42a5-b754-a09bddcdde4e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8450820a-5372-4f15-b8c9-e8a9b4ce4ba4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztncFr4lgcx4fdyx73X9j/Yq973KOz7J7qYYadDHuZgLMQvIgXc1IW9GIP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            "], {{0, 143}, {
            86, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{86, 143},
          PlotRange->{{0, 86}, {0, 143}}]], "ExerciseOutput",
         ImageSize->{90, 143},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a011b28e-1b09-4f2e-bf17-06c09168a8e0"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztncFr4lgcx4fdyx73X9j/Yq973KOz7J7qYYadDHuZgLMQvIgXc1IW9GIP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              "], {{0, 
              143}, {86, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {86, 143}, 
            PlotRange -> {{0, 86}, {0, 143}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9a7eca02-be99-4bc3-8932-ddbdb91107a3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c5f29d05-a3cd-499f-a4f0-b0e1d12c2b5b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a2142851-a44a-499f-9c23-1dc5e9351a88"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5041d4d2-7767-4bfd-ac6a-9d8d14061232"],

Cell["\<\
Make a histogram of the differences in successive peak brightness times in \
the Fireballs & Bolides dataset.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"6eb2e70e-6c04-48e0-a822-0e412018057b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"614690a4-ae87-475e-8963-26edb3bd78ad"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3LGP4tgdwPFN0qTMv5A/IV3alOmii/IH3Cr7LmkcaS96UQqnckdFRePK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            "], {{0, 226}, {360, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 226},
          PlotRange->{{0, 360}, {0, 226}}]], "ExerciseOutput",
         ImageSize->{364, 226},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "241d5353-038a-47e8-8dca-4b2610be3c86"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3LGP4tgdwPFN0qTMv5A/IV3alOmii/IH3Cr7LmkcaS96UQqnckdFRePK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              "], {{0, 226}, {360, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 226}, 
            PlotRange -> {{0, 360}, {0, 226}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"efa91e11-f404-4078-8567-79ff1f3fcea8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ebf1f000-e27f-4390-a977-b761d1155319"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a295b5ef-f431-4b54-841e-6a95c14ed7d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7eab86f2-d992-415d-9e3c-fe771c991e44"],

Cell["\<\
Plot the nearest cities for the first 10 entries in the Fireballs & Bolides \
dataset, labeling each city.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"0e901136-10fa-48c7-bc03-6f3fb86773bc"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"707b83e1-d1ad-4e55-a67b-bf68a0af9e71"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfXl8JFW59swwgCwinxuKgoDgAioKisu9gCt4UVBRELxXXFhUlFGuV0VA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            "], {{0, 215}, {430, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{430, 215},
          PlotRange->{{0, 430}, {0, 215}}]], "ExerciseOutput",
         ImageSize->{434, 215},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "43e8012c-1927-49b5-8c0e-b991ff867880"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfXl8JFW59swwgCwinxuKgoDgAioKisu9gCt4UVBRELxXXFhUlFGuV0VA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              "], {{0, 215}, {
              430, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {430, 215}, 
            PlotRange -> {{0, 430}, {0, 215}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"90fbdaa4-ec7e-421a-8500-67b6e48a76b9"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4f049515-3dfe-4994-94f3-5584f0bc5318"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"951d660e-8f65-4b68-883d-7ca693fdf495"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b7fdd2c2-1945-4047-9e42-5ec2eada9a63"],

Cell["\<\
Plot the nearest cities for the 10 entries with largest altitudes in the \
Fireballs & Bolides dataset, labeling each city.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "45.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"f8409189-3da7-43f5-8e3d-df864213268e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dd492d1f-f47c-4257-a5a5-fd503075408f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsfXd8HNW1v22qKQmBBBICoaVByAuEAPmFQF4SIIUAeSR5hBRSiEl5hDyS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            "], {{0, 222}, {444, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{444, 222},
          PlotRange->{{0, 444}, {0, 222}}]], "ExerciseOutput",
         ImageSize->{448, 222},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2877ff2c-17c3-4268-a6ea-52c008a23095"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsfXd8HNW1v22qKQmBBBICoaVByAuEAPmFQF4SIIUAeSR5hBRSiEl5hDyS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              "], {{0, 222}, {444, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {444, 222}, 
            PlotRange -> {{0, 444}, {0, 222}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"43c3370e-123d-4ed3-a86d-04317bda58fe"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["45.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"203298a1-1a65-4f38-bc1c-539c9e67777a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d7b856b3-5fe8-455d-acae-927dde7f5dc1"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ab01ceb0-bd7f-4541-ab40-97fa521df0a8"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Datasets: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[" 45  Datasets", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
45-datasets.html"], None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "45.1", "45.10", "45.11", "45.12", "45.13", "45.2", "45.3", "45.4", 
         "45.5", "45.6", "45.7", "45.8", "45.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "45.1", "45.10", "45.11", "45.12", "45.13", "45.2", "45.3", "45.4", 
      "45.5", "45.6", "45.7", "45.8", "45.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[24046, 468, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7c72064a-ae39-44f7-85c5-55f3b2e140e3",
   CellTags->"FirstInputCell"],
  Cell[41975, 846, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8365b3d1-fc12-4a6f-9341-9f966323e4aa",
   CellTags->"FirstInputCell"],
  Cell[74314, 1463, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4ef56d14-5a93-411f-8c80-3adca5075f56",
   CellTags->"FirstInputCell"],
  Cell[103146, 2023, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ea10b98f-88d4-4a99-a9bb-b3cd55e3817d",
   CellTags->"FirstInputCell"],
  Cell[129767, 2546, 813, 26, 
  70, "Input", "ExpressionUUID" -> "50735b8a-e23d-4745-b472-09a53cef1538",
   CellTags->"FirstInputCell"],
  Cell[155844, 3060, 813, 26, 
  70, "Input", "ExpressionUUID" -> "09c9075a-4f36-461e-a086-0beacafab4ff",
   CellTags->"FirstInputCell"],
  Cell[189569, 3699, 813, 26, 
  70, "Input", "ExpressionUUID" -> "700bf39c-4f5d-4d89-b84d-6da23bbb722b",
   CellTags->"FirstInputCell"],
  Cell[236842, 4560, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5f8da03a-1688-4667-a903-84e52c431117",
   CellTags->"FirstInputCell"],
  Cell[244507, 4771, 813, 26, 
  70, "Input", "ExpressionUUID" -> "688c7ae5-9e88-4c6f-82dd-4d432c4747fb",
   CellTags->"FirstInputCell"],
  Cell[255563, 5038, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a2142851-a44a-499f-9c23-1dc5e9351a88",
   CellTags->"FirstInputCell"],
  Cell[268697, 5339, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a295b5ef-f431-4b54-841e-6a95c14ed7d4",
   CellTags->"FirstInputCell"],
  Cell[346626, 6702, 813, 26, 
  70, "Input", "ExpressionUUID" -> "951d660e-8f65-4b68-883d-7ca693fdf495",
   CellTags->"FirstInputCell"],
  Cell[431571, 8180, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d7b856b3-5fe8-455d-acae-927dde7f5dc1",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 490428, 9398}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[629, 21, 526, 13, 70, "Exercise", "ExpressionUUID" -> \
"4357fb6a-46dd-4064-abd8-dac7c0a8ff69",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1180, 38, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d83fd8c9-75ab-430c-8012-bc9960d8069a"],
Cell[1839, 60, 21600, 383, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8ea7cd7a-ed64-4104-a298-f23592abd2fd"]
}, Closed]],
Cell[CellGroupData[{
Cell[23476, 448, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"15d4bbcb-395f-4590-843b-b656c4ca5053"],
Cell[24046, 468, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7c72064a-ae39-44f7-85c5-55f3b2e140e3",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24896, 499, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"72626a1a-2e2a-40c5-80c8-ab6d94394f73"],
Cell[25183, 510, 489, 10, 70, "Exercise", "ExpressionUUID" -> \
"295e6a86-da42-4381-b9f3-27cc6059959a",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[25697, 524, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"da51580a-c68a-4e21-af47-63539c54b8eb"],
Cell[26356, 546, 15012, 275, 70, "ExerciseOutput", "ExpressionUUID" -> \
"56479935-b437-4d46-a0b1-80e125ecf616"]
}, Closed]],
Cell[CellGroupData[{
Cell[41405, 826, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d6514878-98f6-4eb4-b80f-122e7bbe7a59"],
Cell[41975, 846, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8365b3d1-fc12-4a6f-9341-9f966323e4aa",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42837, 878, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c3ac627e-bbe9-43da-a8bb-5c49b78fc5cf"],
Cell[43124, 889, 520, 13, 70, "Exercise", "ExpressionUUID" -> \
"23bc9512-ce43-491f-8596-7b72b1c43e4e",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[43669, 906, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"496d44cc-896d-464c-ac9f-d198bf60b390"],
Cell[44328, 928, 29379, 510, 70, "ExerciseOutput", "ExpressionUUID" -> \
"07a8446d-8378-43e9-bf12-18bbac959274"]
}, Closed]],
Cell[CellGroupData[{
Cell[73744, 1443, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"8db9c57d-7f95-4a59-bf08-3cc3a1e4960e"],
Cell[74314, 1463, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4ef56d14-5a93-411f-8c80-3adca5075f56",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75176, 1495, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"aa74d0df-421e-48f5-9566-f480e0ec5df3"],
Cell[75463, 1506, 531, 13, 70, "Exercise", "ExpressionUUID" -> \
"2b72ae7c-e554-468b-b2f4-acf73c3d01ef",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[76019, 1523, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"30bef936-8ab6-4258-9a66-ea4ae74604ee"],
Cell[76678, 1545, 25861, 453, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d7ce72e9-4294-4d4e-b7e7-f3379ffbb5a6"]
}, Closed]],
Cell[CellGroupData[{
Cell[102576, 2003, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"0a6c5d0a-e592-4220-bf96-fae670099f19"],
Cell[103146, 2023, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ea10b98f-88d4-4a99-a9bb-b3cd55e3817d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104008, 2055, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ecae4fd5-474a-4a40-b7a9-3be734ad7286"],
Cell[104295, 2066, 544, 13, 70, "Exercise", "ExpressionUUID" -> \
"61e43eba-e9e0-4124-a09c-a2c038d66cfb",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[104864, 2083, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1a6988dd-5b94-4c47-a250-467bae2eb60a"],
Cell[105523, 2105, 23637, 416, 70, "ExerciseOutput", "ExpressionUUID" -> \
"125801f2-6300-4349-a57c-5a842040a3f8"]
}, Closed]],
Cell[CellGroupData[{
Cell[129197, 2526, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"5a2a83a4-6bc2-46da-b2f9-8ae9dc58afcf"],
Cell[129767, 2546, 813, 26, 70, "Input", "ExpressionUUID" -> \
"50735b8a-e23d-4745-b472-09a53cef1538",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[130629, 2578, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"61e3560a-8711-4e5c-839b-5a51362e51cf"],
Cell[130916, 2589, 504, 12, 70, "Exercise", "ExpressionUUID" -> \
"7301c91f-3fb7-4a5d-97f7-fc7077e1c12d",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[131445, 2605, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1a6a2610-16d0-4357-b73f-00bf8f26c176"],
Cell[132104, 2627, 23133, 408, 70, "ExerciseOutput", "ExpressionUUID" -> \
"738f0d33-5b3e-476f-a972-756e09ff9126"]
}, Closed]],
Cell[CellGroupData[{
Cell[155274, 3040, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b6a91596-9442-41a8-acdb-14ef19dc8654"],
Cell[155844, 3060, 813, 26, 70, "Input", "ExpressionUUID" -> \
"09c9075a-4f36-461e-a086-0beacafab4ff",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[156706, 3092, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"344aab83-5495-4fb3-97ff-fe5044719f98"],
Cell[156993, 3103, 519, 12, 70, "Exercise", "ExpressionUUID" -> \
"2f48285e-ce2c-4f88-86ec-119f3fc2c680",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[157537, 3119, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"12d8925b-0268-4e5d-8aad-d517f659f6c3"],
Cell[158196, 3141, 30766, 533, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b1fbf131-7981-4774-9b1a-37ddc5b870a8"]
}, Closed]],
Cell[CellGroupData[{
Cell[188999, 3679, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"9de165c4-1b46-438c-a874-8f0cbcfa56a6"],
Cell[189569, 3699, 813, 26, 70, "Input", "ExpressionUUID" -> \
"700bf39c-4f5d-4d89-b84d-6da23bbb722b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190431, 3731, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"42c8e360-b6ce-48e2-a014-02a17b0409d7"],
Cell[190718, 3742, 586, 13, 70, "Exercise", "ExpressionUUID" -> \
"cbf66fd4-4fbc-419e-8aa4-27d7f7586682",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[191329, 3759, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"873eb8ff-cd30-4a1e-8d0b-852dd477fca8"],
Cell[191988, 3781, 44247, 754, 70, "ExerciseOutput", "ExpressionUUID" -> \
"446a6d46-932a-4757-a9fc-283d8ec5106f"]
}, Closed]],
Cell[CellGroupData[{
Cell[236272, 4540, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d5a2fd47-2e1b-4632-b793-77ade62797b8"],
Cell[236842, 4560, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5f8da03a-1688-4667-a903-84e52c431117",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[237704, 4592, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b975f9ca-92f7-408a-810b-c6ce8796652d"],
Cell[237991, 4603, 463, 11, 70, "Exercise", "ExpressionUUID" -> \
"9b4fedba-43fc-4b6a-b1b7-8b28d854c713",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[238479, 4618, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"e0f62743-17f6-44b1-8f56-324c045d00d0"],
Cell[239118, 4639, 4782, 107, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7da996c4-4018-40a2-b058-4e563785a67b"]
}, Closed]],
Cell[CellGroupData[{
Cell[243937, 4751, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"5f32b114-8f64-4d44-8468-7dbbd185184c"],
Cell[244507, 4771, 813, 26, 70, "Input", "ExpressionUUID" -> \
"688c7ae5-9e88-4c6f-82dd-4d432c4747fb",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[245369, 4803, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"690df5b7-b5e0-424a-8e0d-6daf9a4cda7f"],
Cell[245656, 4814, 483, 12, 70, "Exercise", "ExpressionUUID" -> \
"a3a7a021-4e03-42a5-b754-a09bddcdde4e",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[246164, 4830, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8450820a-5372-4f15-b8c9-e8a9b4ce4ba4"],
Cell[246803, 4851, 8152, 162, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9a7eca02-be99-4bc3-8932-ddbdb91107a3"]
}, Closed]],
Cell[CellGroupData[{
Cell[254992, 5018, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"c5f29d05-a3cd-499f-a4f0-b0e1d12c2b5b"],
Cell[255563, 5038, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a2142851-a44a-499f-9c23-1dc5e9351a88",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256425, 5070, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"5041d4d2-7767-4bfd-ac6a-9d8d14061232"],
Cell[256712, 5081, 504, 12, 70, "Exercise", "ExpressionUUID" -> \
"6eb2e70e-6c04-48e0-a822-0e412018057b",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[257241, 5097, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"614690a4-ae87-475e-8963-26edb3bd78ad"],
Cell[257880, 5118, 10209, 196, 70, "ExerciseOutput", "ExpressionUUID" -> \
"efa91e11-f404-4078-8567-79ff1f3fcea8"]
}, Closed]],
Cell[CellGroupData[{
Cell[268126, 5319, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"ebf1f000-e27f-4390-a977-b761d1155319"],
Cell[268697, 5339, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a295b5ef-f431-4b54-841e-6a95c14ed7d4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[269559, 5371, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7eab86f2-d992-415d-9e3c-fe771c991e44"],
Cell[269846, 5382, 501, 12, 70, "Exercise", "ExpressionUUID" -> \
"0e901136-10fa-48c7-bc03-6f3fb86773bc",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[270372, 5398, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"707b83e1-d1ad-4e55-a67b-bf68a0af9e71"],
Cell[271011, 5419, 75007, 1258, 70, "ExerciseOutput", "ExpressionUUID" -> \
"90fbdaa4-ec7e-421a-8500-67b6e48a76b9"]
}, Closed]],
Cell[CellGroupData[{
Cell[346055, 6682, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"4f049515-3dfe-4994-94f3-5584f0bc5318"],
Cell[346626, 6702, 813, 26, 70, "Input", "ExpressionUUID" -> \
"951d660e-8f65-4b68-883d-7ca693fdf495",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[347488, 6734, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b7fdd2c2-1945-4047-9e42-5ec2eada9a63"],
Cell[347775, 6745, 518, 12, 70, "Exercise", "ExpressionUUID" -> \
"f8409189-3da7-43f5-8e3d-df864213268e",
 CounterAssignments->{{"SectionNumber", 45}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[348318, 6761, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"dd492d1f-f47c-4257-a5a5-fd503075408f"],
Cell[348957, 6782, 82006, 1373, 70, "ExerciseOutput", "ExpressionUUID" -> \
"43c3370e-123d-4ed3-a86d-04317bda58fe"]
}, Closed]],
Cell[CellGroupData[{
Cell[431000, 8160, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"203298a1-1a65-4f38-bc1c-539c9e67777a"],
Cell[431571, 8180, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d7b856b3-5fe8-455d-acae-927dde7f5dc1",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[432411, 8210, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ab01ceb0-bd7f-4541-ab40-97fa521df0a8"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 2RsfXm0cS6aSeleKFzvwUJ0E *)
