(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    420666,       8331]
NotebookOptionsPosition[    350610,       6859]
NotebookOutlinePosition[    410145,       8084]
CellTagsIndexPosition[    410066,       8079]
WindowTitle->More about Patterns: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Find the list of digits for squares of numbers less than 100 that contain \
successive repeated digits.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"68180981-db75-4f17-83e9-3f9ccc1b2b3b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e7d71b8f-168a-428a-b62c-cce4ef8f2d21"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT2v8sgZhp2kSZm/kD9AnZYyFdJGSUWzqyyrNJuj3UgRLR1VREdHRYUU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            "], {{0, 86}, {430, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{430, 86},
          PlotRange->{{0, 430}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{434, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d6d4320f-9522-4d01-ac58-be05ea0d8cd1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT2v8sgZhp2kSZm/kD9AnZYyFdJGSUWzqyyrNJuj3UgRLR1VREdHRYUU
iYqKhspShCK5iBsX3kg0FBRO4cIF6xnDwdgz9j2e8dh+81xSVuQ9j+17vowx
yNdvv/nrV7NfOo7z46/T/3z19d/HP/zw9fwPv0n/zx+///Ev333/7Z9///3f
vv3u2x9+982v0n/8U/q/f/7CcdjrO0EQBEEQBEEQBEEQBEEQBON2WM5Gow8v
LrxOiQLPC6OkevvwfNxtd8dzqFIWbWfj8XThXit23iRMtqF/Poe3GC5TDBNd
3MN+t9u7/rVq91BZcvG9F34YN+mZO9JkW8MEhYHL8oOuGiY6H9P+P6THqM7R
swlcW1aeM/LSW3hKJ+H+4F/V5zmYufvlYIbIWzuOM1vuL8nb62A3dzhLt2oi
nddTVjRi/5luznBZ4h826T+Nli4SDAyT4a4mTuWeS2UKYf7z7x1vRNYU52Pn
C+tvHlSW7niVVTwYnyO1ngGbbGeYwDBgWWnQVcLE4XLMm8LbMj9Iz3K9msBY
WXnOSOr8bb5u6//PeGZwnre6HEwRnVeOs4pLr8PjdvHB5ur6LB+UyE2n22TN
5o+7Yi894fuTpMzfTJzRSrZ35TCcONhlnZgdDi8DwwTbdFiWF/5v2xmbJsJ3
OLAs/et67Ew2XrqyOHelMGiTbQ0TFAYuEw46GOZyZKt4F6Qdmuzn6er6EJ8K
ezaBsTLxnClxY0mdecA/6+2Wa7+FzH1YDqaIPdb2qPQ6i5B2xEreDzF/Bzlm
rbocHFYseH+SlXlps0dryRuacphs78t01o+n05EzXlWsREEZHCa6PT8s3Nxl
uhdXvA1Ydk3/tvaLs1mlZ+qbbHGYmve/hOKgg2HO6Vngc+3wtmx8hSaDZS1M
YKRMPGcKJJc9v5wrpjOdufvlYAp2un7OmfxrRnweV/ZDsJu9Tu9JMJNMJFmZ
zw8na6BqmBSPXUc7h/CyZe8h0iUmLFMLw2HLzVlcKgLVlkVn/hFx+jGbLVZb
/3kzBA+DNNnaMOn0v5jSoINheJ8vH5vdTrKZ07cJDJVJ5kypKj2nTU5++uFy
s9ke/Jvy1FLIzOlqORjhFhw/0hM0/wyef/2grh/4O+/nuTrejJ3x2sPLEv4R
abkXvL01CJOEe35HiPUxP4T4XoSsTC3Mcz+zreyOB1aWBIvxaLbcHA7bGbtD
MsluyYBhwCbbGSbN/hdTGnQwTBxs+ZJarNeL7M7TWnSK69UERsskc6ZAdseP
zb35YsrKxtk1bSuZu1sOpljyu5hHdrhb7vUT5Jrw9Q4Spt24lL3zisviNZ+m
p+IkbRAm2kz4zdjlarVaTLJbUMfyzaGKMpUwN5dd1ky3Ne9TYNmj+DR63Z1G
woBNtjNM+v0vQjDo6DDdgtNqMZ8v1id3P1ZussGeqWgL2GQ5b3PmjexMyO+U
shakmfn9t3Yyd7YcjJHcfPaWuTgWXj//7LG7BJ708LGf9vbolIW9Htk7r6hY
Vhb7G3YDxxVcKauHiU/b9Wq9XjGWE/6GsjmVl5i0TCHM1WU3fceryh8NgGW5
G978tny2xLAwYJPtDJNu/0u6pzjoanMm24R9TnRe320DTQbLjE5gvEw8Z4qZ
vVzme5SeSbIbEeYzd7ocDBLs0vP08z7h63UceJ53YgHm25PveZeY/XBgPnLG
i8Pr6zV+zyS92A2v4Ya94t/QgWWPmxLrWLhJgzAvktfHHLAMDhNfjtPs09bx
7J3PrusGt6S8CVi2Z59GFm5wuYbnFdtgdOALFu4ZrMmWhkmj/wVlokGHwyTX
08d0cfLD4LxjV54f+6TLngEnMFQmnjOCvV0W7AJs7V+vZ/57mOw7I7OZ+7Ac
TCH+7jjmty5zsFvEscfTvd26jPzd+FEy3gdRtheoLP+VkGiTBmE+j/b8Ll68
Z0EZHMZbF7LwC/jSJmBZFJ7mr8Lxxr2q9QzcZBvDpNP/5TLhoMNhkvQK5PnL
tNFsHSb3LnsGnMBYmXjOiAIkz/OPw85mpd9ImMjch+VgCv4d0zIqvRbC3jLK
X2cn0e31JblCmb9m1wSRZJOGYZqWdRgmidN+efsdfyth/v+GKbrdbtHb5cMX
0zPlOSPZWxo67YNXYa9G08hyMEX2GXzM3zfzr8tcDunFq7P1am6fYmWxu2FX
7NnPyYSbUBgKQ2Eoc21mc8TudjmbLfhP0POviyTRJbjUf0DHyuLD8uNjsck+
Z0g2oTAUhsJQ5trMBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQ
hE2saebAsrbMYu8uMCk2bGigMozv2ZA0jaFlQzOpOWNg/Vxw2LWRWUEnZ2Nu
xFf3yMbI9SsfVAWWwdM+i9FwDZoO01o/V2FRMweWtWIWK7nAxANhwYYGGvTu
qA2tcQ8o2NBMW/+wfk7KDrs2+hnVyVmYGz/9dJzkMk+WJ+GqTi5Q2R2e9hnN
1iCYGQ/TXj9XY1kzB5aZNouJXWCl/dqwocEuMLPSNC0bmmHNGdbPMoed6X7G
dHJW5kZyOYxHi+xZ1Ef2NiC2I4Fl6LTnNF6DhsO02c/VWNbMgWVmLV0yF1hp
t3ZsaKALDGoaWKZtQzOpOQP7WeawM50Z0snZNeXxzKdF3dyoKQOnfZZVew2a
CdNqP1djWTMHlpm1dMlcYMXd2rShceqVYYYEGWZsaGDmujKwn2UOO8OZMZ2c
zbkRXS/eiT1g2plVaUFqy8BpfzexBk2FabWfK7CvmQPLzFq6ZC6wAlZtaKAy
zNSZ0IgNDcxcVwb2s8xhZzgzppOzODfYp/WMahlxbRk47U2sQWNh2uvnSjrR
zIFlJi1dchfYG1ZtaKALzOiZUNeGZkhzBvbzXeqwayHzo1iqk7M6N9izna8H
bvvYCx+ripVh097QGjQTpr1+rsG+Zg4sM2vpkrnAimXWbGigMgxoGlhmwIZm
TnMG9vPbJjmHnenMmE7O0tyIc6opbyz9PQBUhk17/TVoMEyL/VyLVc2caRsd
nFnkAuvIhga6wOCmafRAR9Y/sJ/FDjvTmVGdnJW5wR5gP5of/cvtGu6XrNHb
IC5vApah0/5FkzVoOEyb/VyNVc2caRsdnlngAuvIhga6wMxK08Q90JH1D+xn
scPOdGZcJ2dhbsSXc3YTLWv06hAIjwKWiQfd9Bo0Hqa9fq6mD8arMu1Yuoou
sC/GhgaX9cmGhvVz2WHXRmZUJ2dlbrAwt/owYBk67Uu0kbnbNVjNEI1XlJky
U2bKrJq5jiEarygzZabMlFk1M0EQBEEQBEEQBEEQBEEQBEEQBEEQBEEQBEEQ
BEEQBEEQBFFNE0fVxXOZcsytNMQ899++2w44ikk1W9mG1k5muAwbDj1PHBqm
cBQp7XviIGldfA29d0KRdg0sy9ByCBY3r6Z+bnTiiRsi6o6qmHtbnPGEPwri
Y189Wm277ZCjgM41WM1WtqGZz/xJXRk2HHqeODSz4ChiLHjiLgkkrfNWY+cd
4XPzwLK7nkMw7eemNjoxXXnihoiyo4o/zXJxZBeNNzfddlQhabHgtkOOYljN
JrGhmc2MlmHDoemJA8PIjiLM3LYnDpXWpX+NH3/22OObJxLLJ1im5RDUtNGV
9tuZJ26IKHu1Ivag+Hn2uFj2iNqKM6Edtx1yFJNqNpkNzXRmrAwbDm1PHBRG
dpTSbu144iBp3YvEn7LH/NcoWqrLNB2Cmja60m4788QNEXWv1pVfN8+Ofuiy
x8XOZaYFO2478Cif6KvZZDY045mxMmg49D1xSBjZUYq7teOJw6R1n4TscLOg
7sRZXabpENS00RV325Enbog082qF7InnDybbQFhjx20HHqVwOE01m8yGZjYz
3jRkODQ9cWAY2VEKWPLEYdK6J+Fc4hhSKtN0CGra6Ap05IkbIk0cVdkTGrfe
NYmCLX/uuajMjtsOPMrnpmbUbO/FeRuawcxo07Dh4CGae+IU+llylDcse+L4
X6TSugf8U+E2qPuutq5M0yGobaN7oytP3BBp4Khi91GdxbNv2DiKblPYcduB
R+GYU7PdJTY0o5nRpmHD8b5rZU+cSj+LjlL8kyVPHCStywgP6bXeVPyFgkqZ
pkNQ00ZXrOvOEzdEVB1Vl+OCXzN7URwHJ/YWtnSv3bntoKOYVbOJbWimM4Nl
4HBoeuLAMOKjdOSJQ6V1nPdPiNLhAMq0HIJaNro+eeKGiLqjKjmtZ88yZ7bm
Pzvsym2HHcWsmk1sQzOdGS6DhkPTEweGER+lI08cLq27Z0M/zp3iNMp0HILi
zTUWV1eeuCHS0FGV1cV1ZSU6dduZLCvb0Dr1xEHDYccTVz5Kx544RFqHNQ0u
03QINrTR9ccTN0SG6KiizJSZMneb+UtkiI4qykyZKXO3mQmCIAiCIAiCIAiC
IAiCIAiCIAiCIAiCIAiCIAiCIAiCIIgvjyZeLdBt17Zz7V//hY1jvXHbgZmV
ZGrZ/tt2CMJCwyhI00YVu2W077ZTyAyVweZHTbddmx1otizftMHr8NS9WqDb
zoZz7fgPyDjWK7cdmBmXqWW07BBEhYYBf5aUU/1YVEtuO5MTNbmA5kddt13L
HWi2LD8cg9fhKXu1QLedJecaZBzrmdvOrEyN0bpDEBYahsft4oOdM9byx6Ja
ctsZnaio+VHXbWejA82W5Zs2aB2eslcLdNvZc65xasRkfXPbIZnxsvYdggpC
wxR/UunBseS2MzpR81SYHzXddk/a7UCzZfmmDVqHp+7VAt12lpxrGaCY7N4P
t51S5toyKw5BVGjIiM8yq91jt3bcdkYnakat+VHTbfeg5Q40W5Zv2nB1eA28
WndMpgaWaTrXPg+Ficl64bZTzFxTZscheIcHnVG3kC257YxOVE69+VHTbfds
a7sdaLYs37TB6vAaeLVQmZoV59oTUEzWC7edYuaaMjsOQYXR5NXAJU37bjvj
EzWj2vyo6bZ7Zmq7A82W5Zs2VB2eulcLlalZca49gMRkfXHbqWSuL7PjEFQc
zcRjt7lEGrVHGituO9MTFTI/arrtPvffageaLcs3bdA6PFWvFihTs+lcqzWO
9dBtZ06m9vpbew5BWGgYB57nndhymG9PvuexRx135LYzO1FB86O22679Dmxv
ON5fDw51rxbotrPnXKs1jvXQbWdQpvaZq02HIDbo8bnQg+ymekduO7MTFTY/
6rntLHRge8Mx8O+OG3q1QLddn5xrZsv65bZrWqaW2azQ0IrbzuxERc2Pum67
ImY7sL3hyL8eHEP0alFmykyZe1CWb9pbM4fJEL1alJkyU+bOy/JNe2smQRAE
QRAEQRAEQRC94mcnrHer
              "], {{0, 86}, {430, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {430, 86}, 
            PlotRange -> {{0, 430}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c3449ff5-ccaa-4c51-aa94-3f1037a38a9c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"749ef35c-871c-4dd1-813d-8c9d65a0d90d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f0873635-e360-412f-8200-463730f0dc10"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"144a9003-87c6-4ae6-aae3-b0097417c170"],

Cell["\<\
In the first 100 Roman numerals, find those containing L, I and X in that \
order.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"a8289ae1-f1c0-48b2-aa19-f9acf7d1606a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"91d24dc3-d903-4017-a524-da99f0672737"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWLGOpEYQbfkShyfdF9wPEDslvGiks5xNsicvKyd7aNeSRUpyIkRyQGAJ
J0QTTXDiAiNLSCeRdEJCQkBCQjABSQcEXFUzMwsz1cz4hNiVTGl31dRWvXrd
Vd1U8/bDx/fGD4yxxx/hz/ubP/SHhxvr59fw8Mv9429397e/vrv//fbu9uGn
D69A+QZ+N/CL43aRRRZZZJFFFvn/yi50DE0zP4e+60f1QZtH8BiLViSBu0nK
gUdTBK7Hq6Ztqq3nBHFx+EcVem5wYryXMRxRxK4jATt1CY9+uiPZnuGoOExC
kvT9mioAD+5zRZQ5Ok9ZW/FNN6AMvvxt6PraTg6rXacedIOGs03/tWHgpdJc
pGvGNCeB/7saYzjoSc2lDjIktgY4mbkE2yUOPPhZ3RIyilPzFXjacbcEoQkP
VtFQMASOgsM0JEnfSgF4dJ8pYhWTKWs5growc8rgaxb6R0uZBBeMhRx6kIZ1
AEGKDcRbp0Iqdaa7fMBacB18uNyiVQTBrBDrHyyZuaXzdgknx4h6Akx3COjE
FQ1D4pAcpiJJ+tKAPffZIhIpa1Ow0LxabZD5K6a53RErUiyArjpF5kPBBJzb
6JQpGfbXtm0TBzOWcvQNS8VEL+MUFmMrL45d/cjtWhySw1QkFb6UcuA+S0Qy
Zf0CuGyQB+vegoutCVHwBM4Pr4iLBQCHyFr66E6smOZVOFXkSBjmp+RpObZi
BIepSKp8CeXQfY6ILZWyQX5Jg0wmHY/bPDIR8OkdVGzxBcyM7RjDk7XtzhnQ
JOqNew1OFUqeZq7aLiocksNUJJW+58oT9xkiopyl7KQACIMmx0+BzjaTW06L
nmaANabpWDCbXCgZnuxc2Wmgk+aQne51OA3SlLFX3vmCjOKQHKYiqfCllAP3
WSKSKRsWAGWAjYQ8FZpdZsPAjjpthA9W1dbQIzDd2x0ZeumAX39tm9xARryt
Y3A2Dm8ZeqZqnJrjZSTIRSnr4MJL8wSH5DAVSdKXBuxlc6aIZMoGBUAadI2B
L6+f+WbdXRlEHuBVLCqlAY6tsOgYMsPjKU8S+EnSou6vLXcBd8VlsAT6N6bH
oG4yS2O6HYqnWY3jlFjcxkZmHbtB6FcQ8jocmsNEJElfGrBXAPNEVKTsqQBU
BrLx8zoah1uAAB0cvoe3QRNaWGhZIyunJzhBgdd2vF3uYr1f3iLFKoXrvLxy
dm3GcaYjOMVw1+8Sd397vQbn018KDlOQJMGtP2nA/Xbmc0X8R5GyNgVQ3VPn
dHBEyO8Azkjb/X2CB0uvD3l2nPnBX0hEUjJZqf17om54ii9v3yOl/JYXKD7m
zo8zP/gLiUiJSHxrfwIfNYFjGHYmxtz+kzR1mZcTwE2FMz/4C4lIiQgd07T9
/NmPoUUWWeS55RuisRsS
            "], {{0, 19}, {171, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{171, 19},
          PlotRange->{{0, 171}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{175, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fb87285a-a4a6-4744-8cc1-9e1043ef61e3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWLGOpEYQbfkShyfdF9wPEDslvGiks5xNsicvKyd7aNeSRUpyIkRyQGAJ
J0QTTXDiAiNLSCeRdEJCQkBCQjABSQcEXFUzMwsz1cz4hNiVTGl31dRWvXrd
Vd1U8/bDx/fGD4yxxx/hz/ubP/SHhxvr59fw8Mv9429397e/vrv//fbu9uGn
D69A+QZ+N/CL43aRRRZZZJFFFvn/yi50DE0zP4e+60f1QZtH8BiLViSBu0nK
gUdTBK7Hq6Ztqq3nBHFx+EcVem5wYryXMRxRxK4jATt1CY9+uiPZnuGoOExC
kvT9mioAD+5zRZQ5Ok9ZW/FNN6AMvvxt6PraTg6rXacedIOGs03/tWHgpdJc
pGvGNCeB/7saYzjoSc2lDjIktgY4mbkE2yUOPPhZ3RIyilPzFXjacbcEoQkP
VtFQMASOgsM0JEnfSgF4dJ8pYhWTKWs5growc8rgaxb6R0uZBBeMhRx6kIZ1
AEGKDcRbp0Iqdaa7fMBacB18uNyiVQTBrBDrHyyZuaXzdgknx4h6Akx3COjE
FQ1D4pAcpiJJ+tKAPffZIhIpa1Ow0LxabZD5K6a53RErUiyArjpF5kPBBJzb
6JQpGfbXtm0TBzOWcvQNS8VEL+MUFmMrL45d/cjtWhySw1QkFb6UcuA+S0Qy
Zf0CuGyQB+vegoutCVHwBM4Pr4iLBQCHyFr66E6smOZVOFXkSBjmp+RpObZi
BIepSKp8CeXQfY6ILZWyQX5Jg0wmHY/bPDIR8OkdVGzxBcyM7RjDk7XtzhnQ
JOqNew1OFUqeZq7aLiocksNUJJW+58oT9xkiopyl7KQACIMmx0+BzjaTW06L
nmaANabpWDCbXCgZnuxc2Wmgk+aQne51OA3SlLFX3vmCjOKQHKYiqfCllAP3
WSKSKRsWAGWAjYQ8FZpdZsPAjjpthA9W1dbQIzDd2x0ZeumAX39tm9xARryt
Y3A2Dm8ZeqZqnJrjZSTIRSnr4MJL8wSH5DAVSdKXBuxlc6aIZMoGBUAadI2B
L6+f+WbdXRlEHuBVLCqlAY6tsOgYMsPjKU8S+EnSou6vLXcBd8VlsAT6N6bH
oG4yS2O6HYqnWY3jlFjcxkZmHbtB6FcQ8jocmsNEJElfGrBXAPNEVKTsqQBU
BrLx8zoah1uAAB0cvoe3QRNaWGhZIyunJzhBgdd2vF3uYr1f3iLFKoXrvLxy
dm3GcaYjOMVw1+8Sd397vQbn018KDlOQJMGtP2nA/Xbmc0X8R5GyNgVQ3VPn
dHBEyO8Azkjb/X2CB0uvD3l2nPnBX0hEUjJZqf17om54ii9v3yOl/JYXKD7m
zo8zP/gLiUiJSHxrfwIfNYFjGHYmxtz+kzR1mZcTwE2FMz/4C4lIiQgd07T9
/NmPoUUWWeS55RuisRsS
              "], {{0, 19}, {171, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {171, 19}, 
            PlotRange -> {{0, 171}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"17388733-426d-4a72-9bc0-7e9243335dcc"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7abdafde-da75-4e1f-9491-592fc9b9d546"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2db608ce-1652-4fd4-8553-587f628bd536"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"76f7ef77-a82c-4b0b-942b-4d1a5d903ed7"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"46b4f8d7-bf66-4250-b56b-aaa3a0d73f00"],
 " that tests whether a list of integers is the same as its reverse."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True", "ShowOutput" -> "False"},
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"bf35885f-37ee-44e2-a802-27020420f3d7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"NO", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9d44feb6-2710-4ba6-b48e-a2cecbad683b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[TextData[StyleBox[
        "Many possible solutions of the form _:=_ or _=_", 
         "ExpectedOutputNote"]], "ExerciseOutput",ExpressionUUID->
         "a238864c-f469-4d2e-9b15-60f0dca38cba"],
        Apply[TextCell, 
         Cell[
          TextData[
           StyleBox[
           "Many possible solutions of the form _:=_ or _=_", 
            "ExpectedOutputNote"]], "ExerciseOutput", Magnification -> 1, 
          CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"af296791-99d8-4c03-a09d-04de913bb8b6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b31ed430-d3d1-4c2e-b4d5-b2aaa6cf4187"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e0b3c2ff-f852-4066-8440-7f76f3a8d0ea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"822dffeb-4197-4af7-b34c-24e2c1be31c2"],

Cell["\<\
Get a list of pairs of successive words in the Wikipedia article on \
alliteration that have identical first letters.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"c6eaab3e-fb33-4b15-8993-0d66c4bbf96c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b9ca9271-49c0-45e8-ac0c-dae93f219d1f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvb+r9M6X59e2E4f+F/wPKDbGiUJHgjVOjJJdPFqcjJvZBaO0s84snCgZ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            "], {{0, 570}, {500, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{500, 570},
          PlotRange->{{0, 500}, {0, 570}}]], "ExerciseOutput",
         ImageSize->{504, 570},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "13703357-8389-4d53-abf5-301948e017a6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvb+r9M6X59e2E4f+F/wPKDbGiUJHgjVOjJJdPFqcjJvZBaO0s84snCgZ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              "], {{0, 570}, {500, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {500, 570}, 
            PlotRange -> {{0, 500}, {0, 570}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5e149174-4d93-45c7-82b9-a41790df969f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ac3d7e87-f4af-488e-99ef-b0fc2c7f00d3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6845a3b7-dfe0-4f66-99ad-62235bf7de91"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"de75221e-c600-47ca-b10f-aed3259134c8"],

Cell[TextData[{
 "Use ",
 StyleBox["Grid",
  FontFamily->"Source Sans Pro"],
 " to show the ",
 ButtonBox["sorting process in this section",
  BaseStyle->"Hyperlink",
  ButtonData->{"41-MoreAboutPatterns.nb", "bubble-sort"}],
 " for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}]], 
  "InlineCode",ExpressionUUID->"71cb4b6c-ffbd-43ce-804c-b4a3c5538522"],
 ", with successive steps going down the page."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"2bfe0bc2-f39c-469b-81f6-f6f3d5d8bf5e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cacdd3e1-b9e1-401f-bbae-080a825259cc"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnS2TpEYYgKnEROYv5A+gY5FXEVRdKm7MXWXnKmYztZeq1FgcEocbRUWM
GoUaMwqDwWAQGAwCgUGMmHQDu8POwnT3S0Ozd+9TtVt7uzT9DTdPvd39y+e/
P65/0DTt60/k28dP/xpPT5+2v/9M/vHH49e/vjw+/Pnh8Z+HLw9Pv37+kfzy
P/L1G/miP1++I4o4DNOi4rjynMXRlTjlSVNTJlGUlmfey6s8OB72Bz+IM+4c
ssA/7PeHIM5v/hI4JulQ3Q547uLoWgcjLNlpkv22udoOCp6SnrOjWV/fZGXa
J2a7FNFe7yTZ7OOXP1XJvsnddEOOzEvX0MxdREpRw1PeS3r0rA0tshtyVtA3
dCupb360DdKMAasZE29F2q/u7NJb07Z87sXMJnU2VitdMxyeCuY2KWfMPdKu
xKSGDl8FuxQni6eCpF7F8/gvAvslSbQjFdf8NPNMTeepYBnWo3m1Wa8tx4tz
/jkVGoIVLPMsOu1p+dYexzy4EjokK4v05jk9kNRbn3bsztAMN2amvZwTy9DX
9s73vTUd7ibfrAJUkM6FBqFmaSq19mhddvVM3tiO41hmMwuPKf+tyOjRuZ8b
gB6kpa1y36F9eEj5hkoR0KtXbY+fPNdxXYdim3V37E7MCnaeK2VAymxzlvkc
0TkYcY616vr2OUcGZzPmAX26GM7tS6K+Sz1EI+Y9DhtyBytIsjwN66bV/YzZ
thV5A0anHZ0O3om8RTPWu9MnuejbY5wVeXqw6eDyEkaaKjuu6vHsHsMoDIMg
SIpuwV4e/gzK9LQ1ry/BXdDXWrd5h9cU7Zxi9GOVhdbq5XWrO37CzCRybzLh
njt9nCvyTOb/T8mIXIrJc0EQBEGQ7wB+ZdEg5B9AlkOZshD2DwDLoVRZCPsH
gOVQqiwahPwD2HJQ5lYWDUKfXqGWQ42yaBCqINByKFUWIP9AEbIcapRFk7GQ
fwBYDmXKAuAfAJZDobIA+AeA5VCuLAAALAcqCwRBEASRgWD8Q8vEgRmSlIW4
f2iZNDBDorIQ9w+UqQMzpCqLi3j8w2yBGZSRyoIi+Ol1tsCM8cqiRaSCMwZm
SFAWLQIVLGcNzBitLJ7vwu8fqrkCM2QpC2H/0C32dIEZ0pSFuH/oMGFgBioL
BEEQBEG4mVpZAPwDyHIoUhYA/wCwHAqVBcA/ACyHUmVxhds/ACyHOmXRZC/k
H8DLT2rmVhZ1icX8A3j5iVJlIewfGoQshxplAfAPoOUnipQFwD8ALIdCZQHw
DwDLsQhlIegf5ll+giAIgiDfOtPvMtEycWCGDGUB8g8tkwZmyFIWIP9AmTow
Q6qyaOH2D5dZAjOkKYuLePzDfDtm1IxRFk32Qv5h1h0zxiqLzn14/cO8gRlj
lcVF3D/MFpghR1kA/EO32NMFZshSFgD/0GHCwAz5e1lMH/+AygJBEARBZLBA
ZXFvY4oB+i3HMpXFnY0phum3HMtUFnf9wxB3LMcClcWwfxhk2HIsUFl0uPUP
g2UathwLVBav077yD4OXDluOxSqLXv/AlfC15Viisri/MUUvvZZjocqCtTFF
D/2WY6nKAuAfIPuCDrPYJRtoORAEQRDkDSrP8mAxNjBD7VkeTMYHZig9y4OB
vMAMNWd5sJAXmKHiLA8mMgMzVJzlwXOltMAMFWd53EV2YIbiszx6spAXmLGE
szwYxR4VmPEOzvKY8iiTYVBZIAiCIMj7QVBZAPyDurUkosoC4B/UriURVRYA
/7CAtSRCygLmH1rUrCWBHh7B7x8uateSwD7R88c/1NmrXEsCqCAo/kHZWhIx
ZQGIf1C4lkRYWQD8g8q1JOLKAuAfFruWRC64lgRBEARBFIHKopMfKos3oLIY
AJXFTQaoLFBZPIPK4jWoLO6CyuJNLqgskPfD/1/gVqU=
            "], {{0, 167}, {75, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{75, 167},
          PlotRange->{{0, 75}, {0, 167}}]], "ExerciseOutput",
         ImageSize->{79, 167},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "42819215-38c6-43ef-aa7b-8ceb114fa408"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnS2TpEYYgKnEROYv5A+gY5FXEVRdKm7MXWXnKmYztZeq1FgcEocbRUWM
GoUaMwqDwWAQGAwCgUGMmHQDu8POwnT3S0Ozd+9TtVt7uzT9DTdPvd39y+e/
P65/0DTt60/k28dP/xpPT5+2v/9M/vHH49e/vjw+/Pnh8Z+HLw9Pv37+kfzy
P/L1G/miP1++I4o4DNOi4rjynMXRlTjlSVNTJlGUlmfey6s8OB72Bz+IM+4c
ssA/7PeHIM5v/hI4JulQ3Q547uLoWgcjLNlpkv22udoOCp6SnrOjWV/fZGXa
J2a7FNFe7yTZ7OOXP1XJvsnddEOOzEvX0MxdREpRw1PeS3r0rA0tshtyVtA3
dCupb360DdKMAasZE29F2q/u7NJb07Z87sXMJnU2VitdMxyeCuY2KWfMPdKu
xKSGDl8FuxQni6eCpF7F8/gvAvslSbQjFdf8NPNMTeepYBnWo3m1Wa8tx4tz
/jkVGoIVLPMsOu1p+dYexzy4EjokK4v05jk9kNRbn3bsztAMN2amvZwTy9DX
9s73vTUd7ibfrAJUkM6FBqFmaSq19mhddvVM3tiO41hmMwuPKf+tyOjRuZ8b
gB6kpa1y36F9eEj5hkoR0KtXbY+fPNdxXYdim3V37E7MCnaeK2VAymxzlvkc
0TkYcY616vr2OUcGZzPmAX26GM7tS6K+Sz1EI+Y9DhtyBytIsjwN66bV/YzZ
thV5A0anHZ0O3om8RTPWu9MnuejbY5wVeXqw6eDyEkaaKjuu6vHsHsMoDIMg
SIpuwV4e/gzK9LQ1ry/BXdDXWrd5h9cU7Zxi9GOVhdbq5XWrO37CzCRybzLh
njt9nCvyTOb/T8mIXIrJc0EQBEGQ7wB+ZdEg5B9AlkOZshD2DwDLoVRZCPsH
gOVQqiwahPwD2HJQ5lYWDUKfXqGWQ42yaBCqINByKFUWIP9AEbIcapRFk7GQ
fwBYDmXKAuAfAJZDobIA+AeA5VCuLAAALAcqCwRBEASRgWD8Q8vEgRmSlIW4
f2iZNDBDorIQ9w+UqQMzpCqLi3j8w2yBGZSRyoIi+Ol1tsCM8cqiRaSCMwZm
SFAWLQIVLGcNzBitLJ7vwu8fqrkCM2QpC2H/0C32dIEZ0pSFuH/oMGFgBioL
BEEQBEG4mVpZAPwDyHIoUhYA/wCwHAqVBcA/ACyHUmVxhds/ACyHOmXRZC/k
H8DLT2rmVhZ1icX8A3j5iVJlIewfGoQshxplAfAPoOUnipQFwD8ALIdCZQHw
DwDLsQhlIegf5ll+giAIgiDfOtPvMtEycWCGDGUB8g8tkwZmyFIWIP9AmTow
Q6qyaOH2D5dZAjOkKYuLePzDfDtm1IxRFk32Qv5h1h0zxiqLzn14/cO8gRlj
lcVF3D/MFpghR1kA/EO32NMFZshSFgD/0GHCwAz5e1lMH/+AygJBEARBZLBA
ZXFvY4oB+i3HMpXFnY0phum3HMtUFnf9wxB3LMcClcWwfxhk2HIsUFl0uPUP
g2UathwLVBav077yD4OXDluOxSqLXv/AlfC15Viisri/MUUvvZZjocqCtTFF
D/2WY6nKAuAfIPuCDrPYJRtoORAEQRDkDSrP8mAxNjBD7VkeTMYHZig9y4OB
vMAMNWd5sJAXmKHiLA8mMgMzVJzlwXOltMAMFWd53EV2YIbiszx6spAXmLGE
szwYxR4VmPEOzvKY8iiTYVBZIAiCIMj7QVBZAPyDurUkosoC4B/UriURVRYA
/7CAtSRCygLmH1rUrCWBHh7B7x8uateSwD7R88c/1NmrXEsCqCAo/kHZWhIx
ZQGIf1C4lkRYWQD8g8q1JOLKAuAfFruWRC64lgRBEARBFIHKopMfKos3oLIY
AJXFTQaoLFBZPIPK4jWoLO6CyuJNLqgskPfD/1/gVqU=
              "], {{0, 167}, {75,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {75, 167}, 
            PlotRange -> {{0, 75}, {0, 167}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9b6da071-62f0-4c3d-8d47-5d697ca5414c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bd93caef-66d0-4550-a6aa-5370fd25fd56"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0b3a9fe2-0f87-4436-ba4f-4ea1c4a2e654"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"49c28016-6400-4e62-9f19-4fbfcd3771a6"],

Cell[TextData[{
 "Use ",
 StyleBox["ArrayPlot",
  FontFamily->"Source Sans Pro"],
 " to show the ",
 ButtonBox["sorting process in this section",
  BaseStyle->"Hyperlink",
  ButtonData->{"41-MoreAboutPatterns.nb", "bubble-sort"}],
 " for a list of length 50, with successive steps going across the page."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"5c42b214-1e85-4519-a23c-2023bc213ef2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"be0dfddd-b555-48b9-8b91-86c15bbbdd14"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3SGsZdUVh/FJySQNhoqaGhKCqXoGg0FQQ0hqCiE1NUM6EEIybYYSwpiq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            "], {{0, 65}, {542, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{542, 65},
          PlotRange->{{0, 542}, {0, 65}}]], "ExerciseOutput",
         ImageSize->{546, 65},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b9386b0b-21d0-4ed0-805f-f76ecdb46527"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3SGsZdUVh/FJySQNhoqaGhKCqXoGg0FQQ0hqCiE1NUM6EEIybYYSwpiq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              "], {{0, 65}, {542, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {542, 65}, 
            PlotRange -> {{0, 542}, {0, 65}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"459147fe-09da-43f1-ac58-2a437455c8f0"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"783f851e-e2a0-4e8f-9aeb-ab093c07ce2f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bbe622ab-49cc-42fb-a2ec-d55de17cddab"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f7323d72-934c-417d-8f6e-4d403cb35b8b"],

Cell[TextData[{
 "Start with 1.0, then repeatedly apply the \[OpenCurlyDoubleQuote]",
 StyleBox["Newton",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["s method",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], 
      StyleBox["+",
       FontFamily->"Source Sans Pro"], 
      RowBox[{"2", "/", 
       StyleBox["#",
        FontFamily->"Source Sans Pro"]}]}], " ", ")"}], "/", "2"}], 
   StyleBox["&",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "2a83f0ef-caf5-4a2f-b5ea-242faf32842a"],
 " until the result no longer changes."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"06d6c42a-5f73-4428-9078-6408e5c99379"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5d5cd654-2951-4034-be72-63b6797a2b75"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWqGPtEYUp62pbNK/oK4KXYus2uRr6jDflx5faq7kviYNFjcSh1uFQqFQ
mFUYzJgxCNJkKhAIzIgR23kzcAt3wMLebm/TzC+5zfL28d5vhnnz3jzuh09/
fHC+Ngzjy7fi48PHv6ynp4/eL9+Ji18fv/z++fHht58f/3z4/PD006dvhPB7
8ffjV4YB348aGhoaGhoaGhoaGhoa/x80KXJM08VMXbYlxlXLV98+r88oPoHU
7CIjPSjBuKyHkroiLyTCDsmzOE4OuHoW8aY6pEmcpIoBqys8RrXE7FrEXmm2
NBes4iQnA81J4T0QW+dRE5v32EaOZdl+XncEWhwahuGghPJjGXuGBMqbc6MA
LOuTvW0MMGdzjVNGItAwA6XBysRS9/QSAK986+Rut8cwOnVjj4gwHFjGGGZQ
3JbYK80Gx6bSkp9uTI4zwnsgttKjJrZIjJMU4sFEuVJoi8AwArXjV1nkuzuh
HBar4m5ZH4eW4Ca2AC5xmREJiqwullo1hjoPfAQ3WWHbK5WRI1T2GIyUSRCB
tUYGmVfC8JoYhQS+cM46PngvTOyKdtLp1Yi91iwj8QQQBXkrWaN6RngPxNZ5
1MTOEyNivT3HNYa4G1gmQjtYF3fL+pBZ7OSNRgSKEPKmZb6cATmKZ4kMMTcd
3shpIjecmbjiRNi1o9m0ciVik5pt0xc8TY6EVHKcFN4DsfMeNbE1xGQm6qxB
wA4zKSusTXE3ry8rup3nOq6H0oJeZoRXEDt2hDHwHM3AcBQibQsL6EBwGoVh
lGF67FL57kBEht/vo5Q0o5xbxWJ7csrlY8HbiS1qChQwSz5dIXxnYisXhiY2
75HIWBN3NWXmihDta84NozivzzNkm7YXp0ngQmL2s/l1NGukhqE4kQiOUu48
wygZzQnD6jApPHqOJSvtUh1dBRzPt6H+trJT6VZ5/RnwotGtJraoqZ6jM865
k8L3J/bW5a2JHXkZQwGWECSXajbkcr18N0AbAuF4tm84Y0Qd2QzbD0Mkg8ny
UFT1o32R70ROd5NSXR2QKTaWv2XcxV1KK91hoNFU/BSVSz3WqxBb0mxyW+6e
o21zUngPxN62vDUxJQpl/4U3xDchFZ1+4RiKUnzmsa/RH7RSZNzZ0ewqnzFC
8zgIwjAQHypnWl4QP88JkXPS2ZSHNSfpXh+ols4/EHfmoek5mKfWZZWKdGfj
c2H3dmKzmnUOT9EKxm3rKeE9EJv3qImtJ8bIHlp/ORR+ZSwWrDrfsRJjfICf
vEiclDBlR5qJlGjGIi9w4pmG5aeDpbqkz+Sa3x9IXdMsdKHwE0Gx0chwEOqE
q0QtJZjg2IMkmmFMKAxNVte7BNOapNBI8jJ+pD7sQqEgUci+7p50kwDKw/r8
lsReazKaqao4zApcFHmelw2fFN4DsUmPmthmYl0vpbN/6mcyKNWGCIpW5dZQ
xKw6QJmDzueyPq8TdHp/5wSZfGm90cgA0PPve03F+B2ciVQWqyO3f+XihGrL
4v20yBk4vafD4W7UubotsZea4H0MlDeTwnsgNulRE9tMbFy1yqYfmk/SvG26
HyEzvurhLOjLK9Y0DRucPy8xsgWsFQ5f3CusNe2QxBRuTexiaGJbcbfEoGrt
41rVnFafIOZAU6gVI7z+vd6tjNwCmthWaGIbwfI9nHSs0z9HsTxCjuOTxSYD
b2lJz7YhzuAqRm4BTWwrNLGNYClyXX9f/tc5VkNDQ0ND493wL9oGgIA=
            "], {{0, 
            19}, {296, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{296, 19},
          PlotRange->{{0, 296}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{300, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2b34bff1-15b7-402c-96b8-e896e8fd3910"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWqGPtEYUp62pbNK/oK4KXYus2uRr6jDflx5faq7kviYNFjcSh1uFQqFQ
mFUYzJgxCNJkKhAIzIgR23kzcAt3wMLebm/TzC+5zfL28d5vhnnz3jzuh09/
fHC+Ngzjy7fi48PHv6ynp4/eL9+Ji18fv/z++fHht58f/3z4/PD006dvhPB7
8ffjV4YB348aGhoaGhoaGhoaGhoa/x80KXJM08VMXbYlxlXLV98+r88oPoHU
7CIjPSjBuKyHkroiLyTCDsmzOE4OuHoW8aY6pEmcpIoBqys8RrXE7FrEXmm2
NBes4iQnA81J4T0QW+dRE5v32EaOZdl+XncEWhwahuGghPJjGXuGBMqbc6MA
LOuTvW0MMGdzjVNGItAwA6XBysRS9/QSAK986+Rut8cwOnVjj4gwHFjGGGZQ
3JbYK80Gx6bSkp9uTI4zwnsgttKjJrZIjJMU4sFEuVJoi8AwArXjV1nkuzuh
HBar4m5ZH4eW4Ca2AC5xmREJiqwullo1hjoPfAQ3WWHbK5WRI1T2GIyUSRCB
tUYGmVfC8JoYhQS+cM46PngvTOyKdtLp1Yi91iwj8QQQBXkrWaN6RngPxNZ5
1MTOEyNivT3HNYa4G1gmQjtYF3fL+pBZ7OSNRgSKEPKmZb6cATmKZ4kMMTcd
3shpIjecmbjiRNi1o9m0ciVik5pt0xc8TY6EVHKcFN4DsfMeNbE1xGQm6qxB
wA4zKSusTXE3ry8rup3nOq6H0oJeZoRXEDt2hDHwHM3AcBQibQsL6EBwGoVh
lGF67FL57kBEht/vo5Q0o5xbxWJ7csrlY8HbiS1qChQwSz5dIXxnYisXhiY2
75HIWBN3NWXmihDta84NozivzzNkm7YXp0ngQmL2s/l1NGukhqE4kQiOUu48
wygZzQnD6jApPHqOJSvtUh1dBRzPt6H+trJT6VZ5/RnwotGtJraoqZ6jM865
k8L3J/bW5a2JHXkZQwGWECSXajbkcr18N0AbAuF4tm84Y0Qd2QzbD0Mkg8ny
UFT1o32R70ROd5NSXR2QKTaWv2XcxV1KK91hoNFU/BSVSz3WqxBb0mxyW+6e
o21zUngPxN62vDUxJQpl/4U3xDchFZ1+4RiKUnzmsa/RH7RSZNzZ0ewqnzFC
8zgIwjAQHypnWl4QP88JkXPS2ZSHNSfpXh+ols4/EHfmoek5mKfWZZWKdGfj
c2H3dmKzmnUOT9EKxm3rKeE9EJv3qImtJ8bIHlp/ORR+ZSwWrDrfsRJjfICf
vEiclDBlR5qJlGjGIi9w4pmG5aeDpbqkz+Sa3x9IXdMsdKHwE0Gx0chwEOqE
q0QtJZjg2IMkmmFMKAxNVte7BNOapNBI8jJ+pD7sQqEgUci+7p50kwDKw/r8
lsReazKaqao4zApcFHmelw2fFN4DsUmPmthmYl0vpbN/6mcyKNWGCIpW5dZQ
xKw6QJmDzueyPq8TdHp/5wSZfGm90cgA0PPve03F+B2ciVQWqyO3f+XihGrL
4v20yBk4vafD4W7UubotsZea4H0MlDeTwnsgNulRE9tMbFy1yqYfmk/SvG26
HyEzvurhLOjLK9Y0DRucPy8xsgWsFQ5f3CusNe2QxBRuTexiaGJbcbfEoGrt
41rVnFafIOZAU6gVI7z+vd6tjNwCmthWaGIbwfI9nHSs0z9HsTxCjuOTxSYD
b2lJz7YhzuAqRm4BTWwrNLGNYClyXX9f/tc5VkNDQ0ND493wL9oGgIA=
              "], {{
              0, 19}, {296, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {296, 19}, 
            PlotRange -> {{0, 296}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d814b069-0a4b-4399-92ba-38789c2cac98"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"40f2448c-7c84-414a-895c-222acbf0d618"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bd8db2b7-13f6-4ad1-ac77-f87dca89b13d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b7ec97ed-8781-4afc-bd0b-1ef9aacfaa96"],

Cell[TextData[{
 "Implement ",
 StyleBox["Euclid\[CloseCurlyQuote]s algorithm",
  FontSlant->"Italic"],
 " for GCD in which ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}]], "InlineCode",ExpressionUUID->
  "295ee201-c906-416a-bc66-fb33ab1416f0"],
 " is repeatedly replaced by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"b", ",", 
    RowBox[{
     StyleBox["Mod",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], "}"}]], "InlineCode",ExpressionUUID->
  "61fe695c-d289-4403-9b11-25f54238c877"],
 " until ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"bf8203bb-5dd7-4250-a132-747d83e78478"],
 " is 0, and apply the algorithm to ",
 Cell[BoxData[
  RowBox[{"12345", ",", " ", "54321"}]], "InlineCode",ExpressionUUID->
  "2240be4e-4209-4218-9810-78194052f886"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"9b8d9124-82f7-4c15-a76d-8c8d80f235d9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"49ea1226-bd9f-4b4f-95f9-97e2a952656b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXL/LtcgVNkmTJpB/IW0K67SWqYQN6W6zS/Yuab7It4FwW5vF0s7OyjRC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            "], {{0, 42}, {269, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{269, 42},
          PlotRange->{{0, 269}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{273, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2b5a3007-ac2e-4d16-acce-3e1e135fff23"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXL/LtcgVNkmTJpB/IW0K67SWqYQN6W6zS/Yuab7It4FwW5vF0s7OyjRC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              "], {{0, 42}, {269, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {269, 42}, 
            PlotRange -> {{0, 269}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a6bdb4e6-031b-4122-8362-6ff65139291f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d0045e55-c344-4d1d-811a-5fc5d4c47a8b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a57c531e-fa84-4b71-8acf-db63a8971db8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0ebaa3e4-099b-41a8-98f6-6e8af6afc3ec"],

Cell[TextData[{
 "Define ",
 StyleBox["combinators",
  FontSlant->"Italic"],
 " using the rules ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", 
       RowBox[{"x", 
        StyleBox["_",
         FontFamily->"Source Sans Pro"]}], "]"}], "[", 
      RowBox[{"y", 
       StyleBox["_",
        FontFamily->"Source Sans Pro"]}], "]"}], "[", 
     RowBox[{"z", 
      StyleBox["_",
       FontFamily->"Source Sans Pro"]}], "]"}], 
    StyleBox["\[Rule]",
     FontFamily->"Source Sans Pro"], 
    RowBox[{
     RowBox[{"x", "[", "z", "]"}], "[", 
     RowBox[{"y", "[", "z", "]"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"k", "[", 
      RowBox[{"x", 
       StyleBox["_",
        FontFamily->"Source Sans Pro"]}], "]"}], "[", 
     RowBox[{"y", 
      StyleBox["_",
       FontFamily->"Source Sans Pro"]}], "]"}], 
    StyleBox["\[Rule]",
     FontFamily->"Source Sans Pro"], "x"}]}]], "InlineCode",ExpressionUUID->
  "d33f19b1-179b-4dd0-80cb-0223650cc919"],
 ", then generate a list by starting with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"s", "[", "s", "]"}], "[", "k", "]"}], "[", 
    RowBox[{
     RowBox[{"s", "[", 
      RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], "[", "s", 
   "]"}]], "InlineCode",ExpressionUUID->
  "4bf508ca-1ad9-4a7c-8ed4-531e51acb490"],
 " and applying these rules until nothing changes."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"aa938191-cd74-44f7-87f0-749cfa719132"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d32c749b-70ec-40f8-b16d-4517866f83d7"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnbFPZLvZhydfmpT5F75/gDotZSqkROlQpES5RGnuh24iRbR0lNPRUVFR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            "], {{0, 350}, {
            471, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{471, 350},
          PlotRange->{{0, 471}, {0, 350}}]], "ExerciseOutput",
         ImageSize->{475, 350},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "94695a84-0ebf-4349-8a5f-e4f06a5d9cce"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnbFPZLvZhydfmpT5F75/gDotZSqkROlQpES5RGnuh24iRbR0lNPRUVFR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              "], {{0, 
              350}, {471, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {471, 350}, 
            PlotRange -> {{0, 471}, {0, 350}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1746d583-b46d-4b20-9a18-ec04941e6919"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"09f61295-699e-4ba5-af3f-6b780ebd584e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"519b4802-f11c-4cb6-8fd1-2b5e65cf5141"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6505f20c-5c9d-48c4-9021-652c4b1548a8"],

Cell[TextData[{
 "Remove all trailing 0\[CloseCurlyQuote]s from the digit list for ",
 Cell[BoxData[
  RowBox[{"100", 
   StyleBox["!",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "815bddec-bbfa-4c4e-8fa4-39487b0d3299"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"847336b6-bf5e-41d4-bb69-6a8ea260db6b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"23ac8ba2-bc3f-408a-a181-d8fc7626f58d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztna2TMtkVh0liIvMv5B9AxyKjqNpUosbsVpatmA21m6oUFofE4VAoFAqF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            "], {{0, 86}, {452, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{452, 86},
          PlotRange->{{0, 452}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{456, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9fab1e44-90de-400f-bdec-31cb427b14cd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztna2TMtkVh0liIvMv5B9AxyKjqNpUosbsVpatmA21m6oUFofE4VAoFAqF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              "], {{0, 86}, {452, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {452, 86}, 
            PlotRange -> {{0, 452}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7d58adc0-7db7-4563-b841-078fc09a4692"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4be91d4c-4b25-4cbf-94ad-5e23f788bd6d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f176ebdc-fe29-43af-b169-649719c60be9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"205b41f6-05c3-4260-99ca-62bb09b1d10c"],

Cell[TextData[{
 "Start from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "71fd8267-1b98-4d5b-863a-927839ddd72e"],
 " then for 200 steps repeatedly remove the first 2 elements, and append ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineCode",ExpressionUUID->
  "4ef16046-aa55-4a85-8d16-80baf0958d51"],
 " if the first element is ",
 Cell[BoxData[
 "1"], "InlineCode",ExpressionUUID->"4a609af2-0fa6-47be-9b58-09a897e23a68"],
 " and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "db3896c9-593a-453b-a411-158fe827f97a"],
 " if it is ",
 Cell[BoxData[
 "0"], "InlineCode",ExpressionUUID->"6a99e269-198c-4ae3-8c60-8274e900c736"],
 " and get a list of the lengths of the sequences produced (",
 StyleBox["tag system",
  FontSlant->"Italic"],
 ")."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"3a7035b2-cc55-486e-b219-9afbdd71ebaa"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"da54628b-06cd-40aa-a790-1a5dbfcce158"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb+LO1ua3mU7ceh/wX+AFW9ohU7csIuzTnbZ0eJk3MwajFLBMgicaAOj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            "], {{0, 196}, {490, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{490, 196},
          PlotRange->{{0, 490}, {0, 196}}]], "ExerciseOutput",
         ImageSize->{494, 196},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b4f04f4d-d5d0-4bcd-950c-f80c54d2359f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb+LO1ua3mU7ceh/wX+AFW9ohU7csIuzTnbZ0eJk3MwajFLBMgicaAOj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              "], {{0, 196}, {490, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {490, 196}, 
            PlotRange -> {{0, 490}, {0, 196}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9984fe9c-1661-4f43-a3e3-538a795f8ec8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b0cddf21-8d0a-42de-884f-60cf4a36df56"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8d62ff61-622f-443f-a432-9b7e252fbf91"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"98ac22ec-fd47-4b69-bdf8-0f710c95a348"],

Cell[TextData[{
 "Start from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "1d400f94-20bc-4c71-90fa-b02ba801a7ce"],
 " then for 200 steps repeatedly remove the first 2 elements, and append ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}]], "InlineCode",ExpressionUUID->
  "5bce96a8-a97a-4495-9f0e-543d777208c9"],
 " if the first element is ",
 Cell[BoxData[
 "0"], "InlineCode",ExpressionUUID->"2c04b8a8-888f-4c9d-94dd-bc2d71fb4f1b"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", "0", "}"}]], "InlineCode",ExpressionUUID->
  "2aabb7b1-82f6-4aa1-9df0-5af4b955bf8d"],
 " if the first element is 1, and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "2", ",", "1", ",", "2"}], "}"}]], "InlineCode",
  ExpressionUUID->"cad6af90-cdc4-420c-80f8-e9a6688e6921"],
 " if it is ",
 Cell[BoxData[
 "2"], "InlineCode",ExpressionUUID->"0f136ab5-b4d4-467f-bf40-de8e599a34a5"],
 ", and make a line plot of the lengths of the sequences produced (",
 StyleBox["tag system",
  FontSlant->"Italic"],
 ")."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"982ffadd-40e8-473a-9d11-26915b3d2d4c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c0d6d042-2fb3-4ed8-bf1a-4b4ef22c495e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3dlbE9n/J/CemZu5nH9h/ou5ncu5/c0ztz9a2y61bdO2rfHbbae/LYsi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            "], {{0, 239}, {375, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{375, 239},
          PlotRange->{{0, 375}, {0, 239}}]], "ExerciseOutput",
         ImageSize->{379, 239},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e4f8b355-0e12-408d-b20c-54d6f41cb769"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3dlbE9n/J/CemZu5nH9h/ou5ncu5/c0ztz9a2y61bdO2rfHbbae/LYsi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              "], {{0, 239}, {375, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {375, 239}, 
            PlotRange -> {{0, 375}, {0, 239}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"980d1118-d353-4c06-b2cd-26a2de84f5ae"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["41.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bc78d6ef-ccf4-421a-a42f-0fe9899c6b6b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8c5d914d-c29d-48ca-adad-f44efb73aabe"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"89c19ba1-eb56-49f8-96e7-a50a7c6d0f38"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"More about Patterns: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 41  More about Patterns", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
41-more-about-patterns.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "41.1", "41.10", "41.11", "41.12", "41.2", "41.3", "41.4", "41.5", 
         "41.6", "41.7", "41.8", "41.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "41.1", "41.10", "41.11", "41.12", "41.2", "41.3", "41.4", "41.5", 
      "41.6", "41.7", "41.8", "41.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[15982, 335, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f0873635-e360-412f-8200-463730f0dc10",
   CellTags->"FirstInputCell"],
  Cell[24508, 560, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2db608ce-1652-4fd4-8553-587f628bd536",
   CellTags->"FirstInputCell"],
  Cell[29578, 722, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e0b3c2ff-f852-4066-8440-7f76f3a8d0ea",
   CellTags->"FirstInputCell"],
  Cell[198343, 3575, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6845a3b7-dfe0-4f66-99ad-62235bf7de91",
   CellTags->"FirstInputCell"],
  Cell[208277, 3829, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0b3a9fe2-0f87-4436-ba4f-4ea1c4a2e654",
   CellTags->"FirstInputCell"],
  Cell[221867, 4141, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bbe622ab-49cc-42fb-a2ec-d55de17cddab",
   CellTags->"FirstInputCell"],
  Cell[231717, 4399, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bd8db2b7-13f6-4ad1-ac77-f87dca89b13d",
   CellTags->"FirstInputCell"],
  Cell[245021, 4714, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a57c531e-fa84-4b71-8acf-db63a8971db8",
   CellTags->"FirstInputCell"],
  Cell[268624, 5211, 813, 26, 
  70, "Input", "ExpressionUUID" -> "519b4802-f11c-4cb6-8fd1-2b5e65cf5141",
   CellTags->"FirstInputCell"],
  Cell[286197, 5588, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f176ebdc-fe29-43af-b169-649719c60be9",
   CellTags->"FirstInputCell"],
  Cell[320326, 6243, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8d62ff61-622f-443f-a432-9b7e252fbf91",
   CellTags->"FirstInputCell"],
  Cell[349482, 6818, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8c5d914d-c29d-48ca-adad-f44efb73aabe",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 408392, 8039}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[642, 22, 496, 12, 70, "Exercise", "ExpressionUUID" -> \
"68180981-db75-4f17-83e9-3f9ccc1b2b3b",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1163, 38, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"e7d71b8f-168a-428a-b62c-cce4ef8f2d21"],
Cell[1802, 59, 13573, 251, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c3449ff5-ccaa-4c51-aa94-3f1037a38a9c"]
}, Closed]],
Cell[CellGroupData[{
Cell[15412, 315, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"749ef35c-871c-4dd1-813d-8c9d65a0d90d"],
Cell[15982, 335, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f0873635-e360-412f-8200-463730f0dc10",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16832, 366, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"144a9003-87c6-4ae6-aae3-b0097417c170"],
Cell[17119, 377, 475, 12, 70, "Exercise", "ExpressionUUID" -> \
"a8289ae1-f1c0-48b2-aa19-f9acf7d1606a",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[17619, 393, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"91d24dc3-d903-4017-a524-da99f0672737"],
Cell[18258, 414, 5643, 121, 70, "ExerciseOutput", "ExpressionUUID" -> \
"17388733-426d-4a72-9bc0-7e9243335dcc"]
}, Closed]],
Cell[CellGroupData[{
Cell[23938, 540, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"7abdafde-da75-4e1f-9491-592fc9b9d546"],
Cell[24508, 560, 813, 26, 70, "Input", "ExpressionUUID" -> \
"2db608ce-1652-4fd4-8553-587f628bd536",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25370, 592, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"76f7ef77-a82c-4b0b-942b-4d1a5d903ed7"],
Cell[25657, 603, 654, 15, 70, "Exercise", "ExpressionUUID" -> \
"bf35885f-37ee-44e2-a802-27020420f3d7",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[26336, 622, 647, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"9d44feb6-2710-4ba6-b48e-a2cecbad683b"],
Cell[26986, 643, 1985, 54, 70, "ExerciseOutput", "ExpressionUUID" -> \
"af296791-99d8-4c03-a09d-04de913bb8b6"]
}, Closed]],
Cell[CellGroupData[{
Cell[29008, 702, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b31ed430-d3d1-4c2e-b4d5-b2aaa6cf4187"],
Cell[29578, 722, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e0b3c2ff-f852-4066-8440-7f76f3a8d0ea",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30440, 754, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"822dffeb-4197-4af7-b34c-24e2c1be31c2"],
Cell[30727, 765, 558, 13, 70, "Exercise", "ExpressionUUID" -> \
"c6eaab3e-fb33-4b15-8993-0d66c4bbf96c",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[31310, 782, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b9ca9271-49c0-45e8-ac0c-dae93f219d1f"],
Cell[31969, 804, 165767, 2746, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5e149174-4d93-45c7-82b9-a41790df969f"]
}, Closed]],
Cell[CellGroupData[{
Cell[197773, 3555, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"ac3d7e87-f4af-488e-99ef-b0fc2c7f00d3"],
Cell[198343, 3575, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6845a3b7-dfe0-4f66-99ad-62235bf7de91",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[199205, 3607, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"de75221e-c600-47ca-b10f-aed3259134c8"],
Cell[199492, 3618, 834, 23, 70, "Exercise", "ExpressionUUID" -> \
"2bfe0bc2-f39c-469b-81f6-f6f3d5d8bf5e",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[200351, 3645, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"cacdd3e1-b9e1-401f-bbae-080a825259cc"],
Cell[200990, 3666, 6680, 138, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9b6da071-62f0-4c3d-8d47-5d697ca5414c"]
}, Closed]],
Cell[CellGroupData[{
Cell[207707, 3809, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"bd93caef-66d0-4550-a6aa-5370fd25fd56"],
Cell[208277, 3829, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0b3a9fe2-0f87-4436-ba4f-4ea1c4a2e654",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[209139, 3861, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"49c28016-6400-4e62-9f19-4fbfcd3771a6"],
Cell[209426, 3872, 733, 19, 70, "Exercise", "ExpressionUUID" -> \
"5c42b214-1e85-4519-a23c-2023bc213ef2",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[210184, 3895, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"be0dfddd-b555-48b9-8b91-86c15bbbdd14"],
Cell[210843, 3917, 10417, 199, 70, "ExerciseOutput", "ExpressionUUID" -> \
"459147fe-09da-43f1-ac58-2a437455c8f0"]
}, Closed]],
Cell[CellGroupData[{
Cell[221297, 4121, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"783f851e-e2a0-4e8f-9aeb-ab093c07ce2f"],
Cell[221867, 4141, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bbe622ab-49cc-42fb-a2ec-d55de17cddab",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[222729, 4173, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f7323d72-934c-417d-8f6e-4d403cb35b8b"],
Cell[223016, 4184, 1092, 33, 70, "Exercise", "ExpressionUUID" -> \
"06d6c42a-5f73-4428-9078-6408e5c99379",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[224133, 4221, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5d5cd654-2951-4034-be72-63b6797a2b75"],
Cell[224772, 4242, 6338, 132, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d814b069-0a4b-4399-92ba-38789c2cac98"]
}, Closed]],
Cell[CellGroupData[{
Cell[231147, 4379, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"40f2448c-7c84-414a-895c-222acbf0d618"],
Cell[231717, 4399, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bd8db2b7-13f6-4ad1-ac77-f87dca89b13d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[232579, 4431, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b7ec97ed-8781-4afc-bd0b-1ef9aacfaa96"],
Cell[232866, 4442, 1207, 35, 70, "Exercise", "ExpressionUUID" -> \
"9b8d9124-82f7-4c15-a76d-8c8d80f235d9",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[234098, 4481, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"49ea1226-bd9f-4b4f-95f9-97e2a952656b"],
Cell[234737, 4502, 9677, 187, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a6bdb4e6-031b-4122-8362-6ff65139291f"]
}, Closed]],
Cell[CellGroupData[{
Cell[244451, 4694, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d0045e55-c344-4d1d-811a-5fc5d4c47a8b"],
Cell[245021, 4714, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a57c531e-fa84-4b71-8acf-db63a8971db8",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[245883, 4746, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0ebaa3e4-099b-41a8-98f6-6e8af6afc3ec"],
Cell[246170, 4757, 1800, 58, 70, "Exercise", "ExpressionUUID" -> \
"aa938191-cd74-44f7-87f0-749cfa719132",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[247995, 4819, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d32c749b-70ec-40f8-b16d-4517866f83d7"],
Cell[248634, 4840, 19383, 346, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1746d583-b46d-4b20-9a18-ec04941e6919"]
}, Closed]],
Cell[CellGroupData[{
Cell[268054, 5191, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"09f61295-699e-4ba5-af3f-6b780ebd584e"],
Cell[268624, 5211, 813, 26, 70, "Input", "ExpressionUUID" -> \
"519b4802-f11c-4cb6-8fd1-2b5e65cf5141",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[269486, 5243, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6505f20c-5c9d-48c4-9021-652c4b1548a8"],
Cell[269773, 5254, 635, 17, 70, "Exercise", "ExpressionUUID" -> \
"847336b6-bf5e-41d4-bb69-6a8ea260db6b",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[270433, 5275, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"23ac8ba2-bc3f-408a-a181-d8fc7626f58d"],
Cell[271072, 5296, 14517, 267, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7d58adc0-7db7-4563-b841-078fc09a4692"]
}, Closed]],
Cell[CellGroupData[{
Cell[285626, 5568, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"4be91d4c-4b25-4cbf-94ad-5e23f788bd6d"],
Cell[286197, 5588, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f176ebdc-fe29-43af-b169-649719c60be9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[287059, 5620, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"205b41f6-05c3-4260-99ca-62bb09b1d10c"],
Cell[287346, 5631, 1276, 35, 70, "Exercise", "ExpressionUUID" -> \
"3a7035b2-cc55-486e-b219-9afbdd71ebaa",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[288647, 5670, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"da54628b-06cd-40aa-a790-1a5dbfcce158"],
Cell[289286, 5691, 30432, 527, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9984fe9c-1661-4f43-a3e3-538a795f8ec8"]
}, Closed]],
Cell[CellGroupData[{
Cell[319755, 6223, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"b0cddf21-8d0a-42de-884f-60cf4a36df56"],
Cell[320326, 6243, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8d62ff61-622f-443f-a432-9b7e252fbf91",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[321188, 6275, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"98ac22ec-fd47-4b69-bdf8-0f710c95a348"],
Cell[321475, 6286, 1443, 39, 70, "Exercise", "ExpressionUUID" -> \
"982ffadd-40e8-473a-9d11-26915b3d2d4c",
 CounterAssignments->{{"SectionNumber", 41}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[322943, 6329, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c0d6d042-2fb3-4ed8-bf1a-4b4ef22c495e"],
Cell[323582, 6350, 25292, 443, 70, "ExerciseOutput", "ExpressionUUID" -> \
"980d1118-d353-4c06-b2cd-26a2de84f5ae"]
}, Closed]],
Cell[CellGroupData[{
Cell[348911, 6798, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"bc78d6ef-ccf4-421a-a42f-0fe9899c6b6b"],
Cell[349482, 6818, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8c5d914d-c29d-48ca-adad-f44efb73aabe",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[350322, 6848, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"89c19ba1-eb56-49f8-96e7-a50a7c6d0f38"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 5RclIuQnjFVFpjeoax0xyFwO *)
