(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    611230,      11015]
NotebookOptionsPosition[    545376,       9641]
NotebookOutlinePosition[    604273,      10852]
CellTagsIndexPosition[    604193,      10847]
WindowTitle->Layout and Display: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Make a list of numbers up to 100, with even numbers on yellow and odd numbers \
on light gray.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"af109a2a-e012-4a87-bf51-afedc8a299b4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"80c0577e-eed0-459f-a3ef-869c0dba3ff4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb9rM09+xydJkzL/QipVcauUMa7S2HAhcWMwd+Rs0ijmLiIYVTIcQhAV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            "], {{0, 86}, {498, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{498, 86},
          PlotRange->{{0, 498}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{502, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2f54c49e-c9fc-4c0c-9bc9-b7ba90b594e3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb9rM09+xydJkzL/QipVcauUMa7S2HAhcWMwd+Rs0ijmLiIYVTIcQhAV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              "], {{0, 86}, {498, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {498, 86}, 
            PlotRange -> {{0, 498}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5cb3d53d-1f7b-4fb6-972b-64389784f439"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"eae47dda-e7a4-444a-a0f4-263b74cd5b4f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b762aed2-cb16-445f-8f28-f6e7d582813b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"665a4ef7-4b17-400f-84a2-d00dc68aff0c"],

Cell["Make a list of numbers up to 100, with primes framed.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"992a7da2-0b58-45cc-a715-a2feeb2111a8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"34cc01b1-11a4-4be3-9a36-25143f3b96f0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfTGr9EyWXr924tB/wT/Aih1aoRM3rHHWyS6eXpyMm12DUSpYBoETOTAK
FhRpAgtmLbOgxGJAZkAMK7C1XuRADPIH2kAGDWgCBQquq0rqbrV0qnTUfW/f
urfrge/lfup+qk6d89SpU9V1b/+TP/l3f3T8B7vd7s//Efnnj/74P+h/9md/
bPyrf0z+51///M//7Z/+/Gf/5l/8/N//7E9/9mf/7E/+IXn4X8h/f/Njt6M/
v03Qt01dVXXbvykoKCgovCfawNzvBpgJkvPjx4/dFpD3f1AjzzRYwr6egK3D
ec4Y5bTqsyCnN+S06vnocpcMZG+4SZaXTYdk7W7L4Pve/y6NfBD3q/T1BLyL
ee8+Rjmt+izI6Q05rXo+Cu9A6td6I0vlWEn6egLknClyWvVZkNMbclr1fGSO
vtOcdiNL5VhJ+noC5Jwpclr1WZDTG3Ja9XyoHPul+3oC5Jwpclr1WZDTG3Ja
9XyoHPul+3oC5Jwpclr1WZDTG3Ja9XyoHPul+3oC5Jwpclr1WZDTG3Ja9Xxw
cmxbZFnJvy4rZY5t8jTlXY14x776pozDwA/CvP7wvqosCXw/THLhhY82jei7
yODXulqEta/j0Pf8IKu4PXz8TJlb1ZRZ6Pt+EJXNuynwcasG9HWRpvnaRfIZ
l/7vBXklrmiAfus8Dak/Up4/PsEbfZPG1CiB6j7WqrZKyDT0gySffGKP0DOX
y6Z2lhVbC85VLHNs4RvDzTQreTfvPSHHJja95atZ8BXf9+qrzb3dBB6U/N6p
ry6ydPKSvqf/7k4BLJq+ZO/aaRr91whLXi9QWEcugxYU77NkbGpkaVXqHq/j
2elRBaeVJ1t1Rmky4xL+PAS4XXp1M3thA5cI2zlMyEYB+ePZ3uhy9kgbtGlG
sOo+zqom8wd9DP+e/Jw9RumZw+2C00AWBfc+ZM5+lmPLyDNPNF856ZYcy1ka
uO8HH3Z1EtESMckrZCMjr/AHz+6dFGdwX+XT2qLsVt4/oLF1pnP67sa3HLC+
nHG7usxuUd4WwHBfbaJT9VI/NInNC30VUbH7dOL1gUFUc+Il2WVYJ9yS/nQM
wHTGcQVQbgnKAF7sFlZ1rn4OYpOQ5KLbyIDCVrVVxvYccQFtOtBWjUjHdLdP
+dNwye2rgIwjrvu3fsAG7lsV0v6smAa4ii0nvjtGdTGT4bwax3ujTYkg9SHj
UhFpNpgpkDHqm2KY9GCBDzbCbpxaLEe0Hl2TrRqtZ5BLSxrXMo6aOLh3oQ+O
YO2XE5/a6BzLWRq47wcf9lW0nzQy6Gq1EYbKIhz9cNDwU7K1tWltoc8cC/bF
JgtZzVdiMONm9k0VQwd4ayQnx9Lix4hZCPpM5+TYlDR+UTibj24uMG8a1j44
kXGPy2tOhXfELBlvcLm1UgYIS5obsfXt5bintbfk2IVVfeqeJoLaudlcz3ir
aHNsHd8bBlkE1iRww2UZaZ9hf0/9hlv4JAsc8jUuwhszwVO3xAjN80c0Xqqv
aWbD5tilcrp8SB3jpKcr0VojgwnNOUs3iUUTfovVM8QdX+jpL2TNU8GjaGKN
um7RKNvd4HMsZ2ngvh982FehrpnDVohtk/UEp4HMpdVFWFbefp6++NzWIVPF
zd7e4NIC7GuYLHGeh67remHOOR1bcPu+G/vI3P1yoeSMq6bD0o5RXiZ0+2yU
UG80x+6sMU5NLI7abVhbZ7IkdZmzdDjPPKjMWykDRPOXK7bKXKxHm6zK3ePe
ZvVDX9C5bUQPWFXTdVyz6zbbcxzF47bUtzvtcDqdDMdfS8833D487TSyFc8j
13H8kDv7UTHqL2U0q0mOPm7vBoyITlUil5NXVBmZqboV32tVR+YsKfJo6mgz
onLNnDclzPwUbAqYFVrPEHcEi9R75timTEzSw8EDmtyYYwVLA+f93IdjI7GJ
bKQvaW1phNRPZJupO/MSmsOtiZUOvz6AcyybLARHwzzQhVePoF+Q446rzw/U
36gin6AMTpeaY+8V4Hu6wmPz13QccygFHIFEZjlWv2pSoC6OecBOR1AG3JFj
2dKphdvOY3n7r5aEm7j+7qzCjBnKV7Kn0FeK0ltuV/hkPbf9IHBZFbdIbnxu
64x/SmRvmEwMe3fLrhz2RkNLhV24OI3bEqPWnZx8grMAZxUV4WUZzamTzZld
4hw7TP8jnVNYPUPc86jeO8dag3/AmG3OsVfMlgbB++E8VldZ7B/Y4Nv197cu
E+HJsm17+NM2ewc6gZ9z23Q/1BbHo2l7OW6HMuRYf/zUoTjthkoYNS6Cku77
jsvPLMD3D39Hwsvqvi08gxobgIUsmTJFbJuGYTpxEtCi9uPr2EVTI7Ynam5T
VUTlaQTwyrLBqr6tyyJiyW3ZGtKqYTKSaNuObbFcdzSsaH6EvzKiAWzdFNZX
i3VwdxjzavseMRrbXJT03EagpmKynmtW0fV1Hp5oeT+f72irGiLCS46tImxl
NYKd2J+rxI117A13xLvn2K4pHPahArAK9RldazJuZ7yBL5cGwfvBnOmc18el
RKH3d7Hn2I5jU1h7ja30MSLH9oWpa0fLDUPvyFizD5DhvEdDoMXnLeBUHqvc
4Rwen5NzuniY5wA0Fv9k8moeq08CTuFHcRNWug/d6e6QKQp6xHME6/oPz7EL
sZUswR4hX221ih3vDDgtT+eQVvV1ShTmDDKzxhwbC3Ls7Yj67urWGkojAi6t
WHRn6Kkv/cdz7HCq7EPrNTpGja1dN1Z9Zj9iVcoq9ZPl2ObweeIBd5JGXJnQ
U8lr+sLqGeKeTcuZgLF/GQuHjpZztxdUOvrxY0yLKMOL84xdNOtzg6wRZnjp
HB44tDRc349shGqyDu3DsnIDG5ny2FkBm5jovpjZ9FB6dkuH0xc9IdwdnLyu
U3Z6Tz9gQvbFPpDyoPskYF9sTd9ZQdZ2XRHT+tlK6uXb+jo+Hcw4L4vUZ2Jl
n6UClgNhHcpyM8jqIjpcjsKQw7kjx+KsKgJzSIlxlqVpkiQZPfZ+wCpay1Yp
PUnR5/fA8VZNGqNnBekgTAz3D+yAyA7Lui4ST2dVQIvkduNZ0MlLmqZgl9pO
xWPeAPfjG73R0Q3Z7hgVdUemqkV0d8jwWWJuVZeFHtmHkXonpWvrfpbiQKu6
KhoyshOlg0qKpkfqGeQSiWRZHnskTWtunGZ5xZlHd4Al/+mfjWVZdwr6iViX
Uas0+yJRwHucpeH6/vVGuutYqJKhvLdoZILLx1hviL4mH3OxW1KzLTavr/4c
ICa5FNcXRRkaoxQX4PTVx87xEoXjcGln8baeuP38ebF2dMZFadkaGNbLZVQ6
8W0eF54p0E5HUAbAYwSs+snRbx8NNdJdVvUTQdXU/9A+FO2ry6v6pR0Ut8mj
yZj2ZraBS1/Mx0WHkoPh0sj9MWJna0bIvQCGtKorrOvTvT9c2HhAOQPoDYVz
ISq2KnNmRo25AqNnkDvZ7zAMd3VE2WYD2P1Y+OrFFIV/mF6jnXkPXBqmbxje
L26EZnvNiPKqqcuAhXBW9YGN3GcwOxUzk6Kqy5SVzPPPVoR99W3TtJMNoLiv
AeySFWy2qK++Y31xxzWAvOfmTWgvEXSMPB382nCAcgsuA5BjxGGzVayA3Ft+
UTdVERs6/fwavO7yjlbx0bftjWa29UsVd/MbjHfEiOHmg6EZtnpj0OaDysl9
82gFRVXGHt0YWvG8Rttq1aqeN+ER7gWYv1dQ0fS38ybXC2fe4y0r0/evNtKR
Dd3hcodPs0PgE4plI/cZ3JaxcTVZdxMgsu/V1wDqosVe9fG+HnkbkjsfDlTY
wGXABPgxvqNVZTz59Fs/xYvfr3x3qz6Li/EGe4F+KCDIsc+3Kg+sy/+OG8MP
tuo53CkwOZZUKUUFlJR4kPcjG1kujuJGHjGY9tU+qS8BHunrkbchuVuHAwI/
xne3ihaQLdzvu1v1WdyvHaO+m5eeH2nVc7hTqL+79aX7egLea/4+3si7Nyi5
5/GQ0xtyWvV8qBz7pft6AuScKXJa9VmQ0xtyWvV8qBz7pft6AuScKXJa9VmQ
0xtyWvV8DJecVY79on09AXLOFDmt+izI6Q05rXo+2B/24f5BPB5UjpWkrydA
zpkip1WfBTm9IadVz0c//FGRoxVGcVZi61mVYyXp6wmQc6bIadVnQU5vyGnV
Z6BPPWO8lmpy/0L7DCrHStLXEyDnTJHTqs+CnN6Q06rPQ9+1bdfx/5zILX78
+LHbAvL+D2rkmQZL2NcTsHU4zxmjnFZ9FuT0hpxWKSgoKCgoKCgoKCgoKCgo
KCgoKCgoKCgoKCgoKCgoKCgoKCgoKCg8AnU7TgbIGQU5rXo1qChM8RW9sVO/
5SEB5IyCnFa9GlQUpviK3viKNn8/yBkFOa16NagoTPEVvfEVbf5+kDMKclr1
alBRmOIreuMr2vz9IGcU5LTq1aCiMMVX9MZXtPn7Qc4oyGnVq0FFYYqv6I2v
aPP3g5xRkNOqV4OKwhSf6Y22SsLA94Mkry/PmjILffIsKhvun0P8WJshqwb0
dZGmOe+rhDnctsiuyCv+3yrn9FvnaUj9kfL9AXDraa+sZ67ZYL99k8a027Tk
fgX8x0ahq5Mo8IMwyauJVTUxyvODjP+9yc+3CqNYHretspA+i4ta+E3QoDcY
1jUJcNGa5PS7qsnP0Ma6YnncvimGZwJPTNDkKenkHK9P1yQfTeYPf757+Pfk
5+Rh6h7Zo+GZHlVwCD/OZtCqM0qTvZJwAgFzu1Sf3nKz4L9Vzus3cQ4TslFA
/oC4ra3tbqHFkNkcm3ODPdsz080I/r6gj4tCX0X7iVV7K2bjLq2rK7WggCX9
ZKuQioW4feqeJs92bgYnB443BqxoEubiNMnrF6PJZ2sDp1iQ2+XDFBifxfXK
X7pObNqGNjrtkzUpRuGRSFlsLWk9qlOrfutcfbd3UvqsScjLup1iu4OKMXGR
ANoMWTUiHaW1Tzl6Brl9FZBx0MD1AzZw36rwooS+ii0nBtkwt7/0V1lEPkcf
DD/IbVOb2JywGR8R7Wo2OPmRURAXCZx5FOqaOUzeiIpYJzmkoqbsfPq0pD8d
A9AbQIOcYqwnBWhWgMFEW4VVLDii3D3ubTZV+4KOyIjw3AGrmgS5SE3C/eI0
iYnC6lYLrw2kYsEIenuaMalNbUZmgGbGsDuGQRT+kE+HoN+vyRG3JfF2Ta6h
bc4+bRJrjH576a+10TkWKsbWiwSOzYBVb3QSUN/uDYNMKV7NAHJZ9PfZ+rdA
AFz2pZOH/C7uBQ01YBfOt5irNptDlqypilA5FiyJV4uEVeU0scms6gMSz/PX
HOd0aTjm0LIxa5BTjHXBaag/4AoQbRVWsSB3gpa4fnfwhOcFcy5OkwAXrUmA
i9QkIgrrWy18FJCKhbito5OUPEYtd4muTO5cGcoV/XDQhkDfqckLbkviRzUp
Bv2W8PnQKnN3Hbu4O7AYWy0SVm2eWFVT32p23Wb7+exY4baZQ712OJ1OhuNj
qBduH57IqhqVeeQ6jh/yShWezQOohHgFEo9Ll3uinZNXVBlZ7XULXtkRUVgv
EgRRaOsqi31aqB09Mo0c7ZrBOupVOBCL2Q0WgV3kWsZR41WAaKumECmWy+3b
uiwilyk0KLZwN2hyxt2kyVsuVpOoKKxttfBRQCoW4jZEV5eoVdFy+bsioxl4
F5YVUTWj3KnJ8f23JfEjmlxFXwZsuNOTz2E4Wog9jxUVcrwiQWzz1CpmzFAq
ZCSAqwXAlEs8ScoM2w8CNo94e3aI2zr7MQiGyWryvStenZeeHEodv1wvWW65
rTs5ZYrmH/2NQERhvUjgR4GtDgx22gz/e9EzyxL6VinOCsg+d7c3MrPqCrFi
eVxWgA04gSUQj7tFk3PuFk0uooDTJD4Kb/yt1pYooBQLclM2pJPl2OZw8HIA
JTFMEINZSfrSnfwxTc5K4nMv92hyDewUiyTAaatVZImXdUF3N4WcsEgQ2Tyx
avAtEZPt2BbT1dGwopKvSmhEA0q2tRDVDTdcJobDqOGWv0oK+l3b+8Dc2CRL
u1V0fZ2HJ1oswS0gorBeJKysdF0d2tS0oPz9IzUDWHzel6hvrerPQ1tRrIBL
ZVqlpnbdda5yf/Wbv9qmSbhfinVNzqKA0yQ+CoKtFj4KSMWCXKqm0DMNw3LD
lMZxnwKObF22uJws27ZN9uPeif7ubk0uSuJzN/dqkos6oXtK3Z4uOyWT69HN
BDxed7NCTlwkcG2+taqvU8e2HYf8Y9vWqOeYp+fFiPrJF/LWwp3Ikkszle50
49D8TVwGJgwjXKli59zG1nZ7b0wXfWZvmkdvt1FYLRI4jXSTjwFInbazkjqk
ycAdnhf0MOIIngpCDcLF53Y9L62irWEUC3L7ybM6NPjxnXN/Ef4arUmwX6Qm
AS5Sk/goCLZa6Cj8DqlYXgQvoEe5Z43NiLHn2IPDbWuvsQo+Lu7TJFQSj3jf
HNtV0TDrnCjN0jRJkqLpi8AcUmKcDc8yegGvzw2yXpjhZexwd3AByS0SaCOL
lkGrJo3RfVk6PMBw678lTw52WNZ1kXg6i0yL5JKpUHjUF17SNAW7InQqIG/w
bb7Zy2Btbv5AP9bYHaOi7shyb5Ekeci6u6OwUiSAUaDS1Ywor5q6DKgBO6/o
hlNEM8jqgto8Hu0irYIKuRU946xCKhbg/p//SXf7ll/UTVXEhk4PrmtoRGC/
k4GJNMnrF6NJsF+kJvFREGy10FH4PVKx4Ihy3zxaQVGVsUc3vFZcg56cDoIl
Rrqk3qVJsCQeL5tt1aQY2flk5wKyHjn67Blbj7qMRkWzLz0DEQQKyJUigTay
aBmyarLS0YuF53ZQ3DqPJmPam9kGLu03H6cwJQd5u4k73Ce5ybFIbldY18d7
f7iScVcUpgCLBDAKHVkWD5dPnTU7HEuU8TIqNcoe5+i6VdzSpcuZnnkfBKOs
apCKBUdUxpNDRP0UD5fY0d44vyzSJMTtkZrk9YvRJDoKoq3WBm3gFAty88C6
MA3vPFkW3Alo6bI/b1u2axIsicccu1WT74jCP+w0hxdBXgEJFAkzmxctP2IV
H33bNm13o6MN/fZt0zRTrz/FZrJIkX5vbixujkLTw0XCBIIoLA2gvVBnbLAK
LF3I3ibL8tijr7lxmuXzT6q2WrUEnku10d5Mqqf0i9Uk3O+aJjFRYK8stloT
bI3CqmK53L6bq2rLTNmqyWnHl5L4EU0+jopGaOdNLrjObAaLMbhIuLV52fIj
Vr0aFxMFuEiY4N2jsMj8QOkyOagfH8/6Vtp4kIuJAsNiqzXBt4kCP8deS+KP
1qQYJMMXtxmSb/McyyJh2siy5UesejUuNgpQkTBt5AlWIYvAj7Pq1bgqCtMn
+HwlwIPeuKM7SRp5ZcgZBTmtejWoKEzxFb3xFW3+fpAzCnJa9WpQUZjiK3rj
K9r8/SBnFOS06tWgojDFV/TGV7T5+0HOKMhp1atBRWGKr+iNr2jz94OcUZDT
qleDisIUX9EbX9Hm7wc5oyCnVa8GFYUpvqI3vqLN3w9yRkFOq14NKgpTfEVv
/PjxY/cwSCPPtPn7Qc4oyGnVq0FFYQrlDQUFBQUFBQUFBQUFBQUFBQUFBQUF
BQUFBQUFBQUFBQUFBQUFBQUM1H2zKZQ3ZICKggyQMwpyWiXG7gv+3sTHQXlD
BqgoyAA5oyCnVU/o7tvoWXlDBqgoyAA5oyCnVU/o7tvoWXlDBqgoyAA5oyCn
VU/o7tvoWXlDBqgoyAA5oyCnVU/o7tvoWXlDBqgoyAA5oyCnVU/o7tvoWXlD
BqgoyAA5oyCBVU2epmUzfqdtU2ah7/tBVDbcbwl+is03Vg3o6yJNc8S3F0+5
bZFdkVftFi5Fnach9UfK88cneKNv0pgaRR4h2r7h9k0RBX4QJkJP9FU+9Vp5
JtekW88PMtE3IHO4tOsyywphAGDuZ2uSO6K3dU2CXKQmuf2uahLk1tNe2VOO
2bzor6vuo+cCkVAcUvnm9WUurGvy03NsYu8JXbMS8nPqHulVME1jN8L0qIJj
8ASbp1adUZrMuGQtTd5wu1Sf3nK7aXC938Q5TMhGAfnj2d7ocoP5Yc8GZkal
uOUpt8t9Ftohvvu45k3R1tamXtNT6vPSurpSCwqepEFuF5wGsjh8AFcCTYIj
GrCqSYiL1STcL0aTEHf2hJodw2aDNqNU95FReGtzb2qWl3dITX6oVavoCn+w
b++k5P9cffiBlA4JCaRupxu7uymZ2ipja05c1MDYBTbfWjUiHaW1T4U5dsbt
q4CMgyaTfsAG7lsV0p+tuKftxJYTg2yMN1ZLCLw32tQmI0pYKRER3Wu2oJad
xdfb02xb0VYykrk0M+bwWocowc3e3q5Oq2hnO59O6ZL+dAw4vgS4pOvItYyj
tha+JfduTcLF2F2aBEdEgdAkwEVrEuoXp0mY21/6qywSiqPPWSYBLlJ1yCiI
N1OcKDS2ztYU2kTjWw5JsUhNgg0CJbFwq3VvjmWu1g8HbZRu3162o629PcdO
SqY+dU/D4jLMcTebx4Rv89wqahjLFXvDIMEXFkJzLtPGPls/XgC4hU/y0CFf
4yK8sV5C4L3BRmTW7LWaakyQY2dcOne0s0tzl+QHs4KJtbXbOTcj7wMST90Z
rM49wj3m8BRdcs9N5O5tEYji3qvJZTF2tybhEeE0CXDRmgS4SE0KokDQUAN2
ISf2fJvXVYeIwvpmCk6JdGEiJf/U0VhNLhuESuKVrdZ9OTajs2wXlhUpb7S5
dCtzt3wo6m5WbuXucW+zTVBf0CXGiJA2Q1bVNFdodt1me7KY8ifpkttmDvXa
4XQ6GY4vSs8Lbh+eSKUXlXnkOo4fcnMDxhurJQTeG30VEinoJ6+oMrJR0i1e
LbrkNo52jWkVmTueM9t0P3jteDRtL6ezoHUmS15HvYrnnl9hLFGO5XMHk7do
EijG7tQkbBVOkxAXq0mAi9Wk0JPUM8uxi7lI1SGisL6ZAqMwLExxnoeu63ph
3mzQ5KJBoCRe3WrdkWP7kq4LBlvMyHZMd/Lpq2x6auGGsy+g+DyjJcvi7uBh
sgpoFTNmKBUy8oxXAIBckutIkG0/CFx2nsTZH0Hc1tmPadIwWf2zd3Frt8gb
vBIC7w1imDs5g4rqDd5I2ZBOlmObwyb3AM/SvjB17Wi5YehR0RHnN3SyXMYi
ypYA922dtcZ926xJUSG3SZOgVUhNglykJuEo4DQp8ORQfvslvxSGuSjVIaKw
vpmCcyxbmKi3DPNArdKjGqvJWYNQSXx+ib/V2p5jW5cF62TZtm3uh4LrfI5d
RVSARlDwyMvu4JK4b+uyiJiQlq1BNgNW/edf/uUgKtuxLaaro2FF5VKVohEN
KNnWAnItyP07utwfRg23G1ZJwQaBW0IgvUFGFJukGLWKrq/z8ERLKXC/z/NG
l4WeaRhkAqU0yvtUcEFgQBNrVJA/YetYgDtO7/Ucy+du1iSvkNusScCqX/zX
X+I0KRrRAL4mQe5PSE0K+hWeEXG5ONVhorC+mRLkWH/8hK840eUlua+OhUri
aS/vlWO72HNsx7EprD1brdyYZqSSiflIy3su5usCpyRmYxlwWp6TQDYDVv3l
f/tr8v/O8NAa9RwDeoZH1HdXB9bc3THMTW06mPGUvvSRERRsEAQlBNIbbvy/
bG2398bk0Gf2phFN30EP1XSXkxcmn8O0CZnWVlqHp+v7C+9Iz744N38W3HF2
dzkTsCgVwdw7NMkr5LZrErDqF//91zhNwiPCaRLmIjXJjwJbfI1QeKC75P4O
pzpUFFY3U2AUWArV4vNyzRL1b5GanOdYoCSevvReOXaKnqUCKuAiMAf5xVmW
pkmSZDTH97lB1gszvGjotjtxAdm3VWpq16PpG5sXLYNWTZ7RfVk6fkiK4PY5
ieLBDsu6LhJPZ5mmRXLpOQM9GD95SdMU7ALRqXjMG4ISAu2Njn7osTtGRd11
dWiRHg5Zhx1R7ptHKyiqMvZoIWfFNehJVluZSVHVZJ2h84Du0AdlmkFWF9Hh
coyG4xIRZFkee+Q1zY3TLGcbfhz3Lk3eYl5AbtMkaNXEuyJNAtz/+7dITYL9
IjXJt/lmf42O4B+QqsNFYWUzxZkL9DR+d3Dyuk59ql43b5GaBHPsbUmcTV7i
51jRLBPjci7dODf39nbjatVlzNP2pedbm3kF5OQaf2jAO4JFy5BV065S/dIO
itvn0WRMezPbwKXIxwlOyUHeglyMN4aWBSXEBm90hbW/DskfPhzHcfPAujAN
7zzRFty2jI1rF7qbjMv8eFWVdmuPxTiOO6keGYabPyjufZp84xSQ92iS542z
90SahLhYTfL6xWiSbzO943STY5FcnOowUZi+DG6mwCjQtqrocjP4ol6MJmdW
QSXx+cCBv9XiWfVeKPzDTnP4nrzgpoDcW35RN1URGzr9JHF2TD40Mmv5Eav4
6Nu2abub3Lah375tmpvfN9vsjRGLEmKCrd7oO2LVzR1bLLfvmhmTw6VdtPPf
BKLdIvoFuUu8I3cWBV4Bebcm33tEWE3C/a5p8mNsXlfdehSqHt5MTSCcC3Tk
M7+tanIxQ4GSGN5qYa16FBU99dh5k8uE/KxyLZnKePI5pH6KF7/pRh4vW37E
qs/iYrzBsCghJvg23vgs7iwKYDH2Opr8LC4mCvBmaoJ3j8Jyhi5LYnir9X5W
iUEyfHGrRn5WmYMu1i33F9yWLT9i1Wdx8d4Q4Nt447O4YBTAYuwVNPlZXGwU
oM3UtJGnzFCgJBbgQau24r2yyuONyADlDRmgoiAD5IyCnFY9obtvo2flDRmg
oiAD5IyCnFY9obtvo2flDRmgoiAD5IyCnFY9obtvo2flDRmgoiAD5IyCnFY9
obtvo2flDRmgoiAD5IyCnFY9obtvo2flDRmgoiAD5IyCnFY9obtvo2flDRmg
oiAD5IyCnFaJ8ePHj93DII080+aPg/KGDFBRkAFyRkFOqxQUFBQUFBQUFBQU
FBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUPhfqft0UcnpDTqteDSoKCvdh
9wV/T+TjIKc35LTq1aCioHAflHKmkNMbclr1alBRULgPSjlTyOkNOa16Nago
KNwHpZwp5PSGnFa9GlQUFO6DUs4UcnpDTqteDSoKCvdBKWcKOb0hp1WvBhWF
JfqmjMPAD8K8Hr/Ttimz0Pf9ICqblW/FXXLbKmMP4qJe+YbcJXd8XhdpmvO+
FJjDbYvsirxqt/Zb52lIR5zyRvzRygGs6ps0pkal5cqXuS+5fVNE9EEi8ERX
l9ktyoHe16Rbzw8y/nccf5w3eFZhNPl8qwaIFcvhohQr6HdVsSC3LmbPYLP5
2ljX5EfPlCpLAt8Pk3wagFXFcrls+mRZIUoZj6HNvem1NC/vUvdIf9I09kCP
Kq6kF9w/pO6J/Thwd27GDcSy3/MrpclaSPhjBrhdqk8fWcmmfhPnMHlmFNCI
P1Q50Ihyg/lhzwZmRiV+RF3ua9co7OMajmBm3/iMEuyU+N+6PtaCAhbtx3kD
tAqpySdbdX5xRbEwF6dYXr8YxULc/2Fr82cxZDbHZpQmPy4KJPdHTJ36YMEp
YOpEKZbD7YLTQBYlnMfQMF8azK7GtxwyQV19t3eYfpqEBFK/ammV+5a7x73N
1NIXNBxGhOcOSEfx7FPukAFuXwXEUppM+gEbuG9VSPuzYkLqq9hyYpANBn1W
QK4WCRzlAFa1qU1GlLA1KjKoxDnLFRBBb0/eb1XkQZuR3KSZMccbfd+Nzsrc
/eDzina28+mkLelPxwDjDUG5JSgSON5YWoXVJNIq8VYLbdX4AkKxABetWKhf
nGJhbn/pr7JIvj36nJQEcJGaREZBvNWCo9AmOs3tVNpNYg+JEalYkEsTr2sZ
R00YvofAAk2W0JvW+7Y5u721+XoGuRO0Fnn54IER5HH7wqfiMQwypXgNg1wW
/X22crABcwuf5KFDvsZdBn1RQP6/1SIBTtTcEZk1+7mmKoL1DHFbR79WWblL
MoBZicfW5wcaq5z8FJCNiO4MzeUeeXzMoRDOBsIpt1aKhJWC52oVVpMIq367
utXCW/WGUyzIRSoW5CIVy7N5QEMN2IUryljavK5JjDZWt1qcHEuLfyNm3faZ
TnWFVSzEvQzRJU18UI4dAh3neei6rhfm85OdyrzZE+G4fVuXReSyMjYotnBr
urBqdt1me7JccoYMctvMoQE7nE4nw/H5eR/g9uGJVHpRmUeu4/gh19OLoEMl
8VqRACoHHFFfhaR5/eQVVUa2OLoF16IQt3G0a9SqyNzxnTmgpHP2yPabLeFe
MlhHvQpzFwMBy7yVIkGczSZWTSHSJMaq1a3WFqtQigW5SMVCXKxiOTYPoAsx
f5sJc5GaRERhfavFiUJNSwbtGOVlQo+PjLLHKhbinn3BWB+VY1mgaX1tmAe6
pOhRfX01YzaFnLMvHpfN+gEneEHhcFl3QzFAVhmdt8SD3K7wSSFh+0HAcjtv
BwRxW2c/PNsbJqtw9i5mdRaX8bwiAc6xsCdbd3LKNI3LKjdlQzpZjm0O29iD
UD90h7V3s6E9MvUuihVoj5uIFiWToEgQZrOpVVeINYm3igHeauGtQioW5CIV
C3GxigX7HTCU3365WgrPuChNIqKwvtXiNVIGp4sFe6/AKxbivmFYD2KYof64
whWniT+ryBIUomIurWWr1NSuNfwq91/+x/80DN12bIsp52hYUQnoTtgvBfMk
vJZB3IQu6IdRpS26chNuAbhFgiDHzkYUE/dpVtH1dR6eaLEE7/c53uiy0DMN
w3LDlMZxnwomMDvc88ZPCu6uY0csS6Z7EvXcqvOzNU1irRJutZBW9WWAVKxg
RKN5fMVC3BapWEG/qBOkBRepSUQU1rdaYCMdXa93Xlb3beEZdKUJyt8jFQtx
R0F8aI5lJmnxuAq2l4GXTMzHRRWxyu27yW2o0OCOd8H9p3/hObbtOOQf27ZG
xcaQYjn9Xmd1zd8dg9yU7Pl1Z+ipL31sjuVvAQRFAqwcwKpf29p1qe0ze9OI
pm+gx2a6K0ixJQ3TITt/QhWeru8vPDopwHM/zjwCSqb7cuytVewJQpNIq8Rb
LaRVfZ0iFQuOCKlYkItULMhlaOmW3QjXq9gbboPUJCYKq1stsJGc2m2e39hY
9GT+t0jFQtxzZs6ZRFeufd0Nerq1Ozh5Xac+XdbdvC0Cc5BfnGVpmiRJxo4t
c4OsF2bYCbj/+2/o3snyi7qpitjQ6ZELTTwYbj5xMT2R1tPBUeh+D3ZY1nWR
eDrbPbXofruCfnR18pKmKdgVoVMBjRfMsWA5LSgSaCMoq2q65u+OUVF3XR1a
+1HquBHlvnm0gqIqY48+seKa40kKOmG163ZjGJcZZHURHS4HZWveONsClEwr
ORZnFVKTeKsEWy28VZPGxIpdcIddM0qxQL9IxfJtvtlfY21+65CaxEVhZasF
RoFVvDsryNquK2IqVCupkYoFuUQEWZbHHpm+mhunWc4OoTjeuBt9FV1u2hle
Ssv4+ceAbLXqMvo2zW5F3LcynhzY6Kd4uBKM415Brw6el0gUt8+jidV7M9vA
pcjHKUzJwZDtF9yZcvgFpKhIoI0greoKa38dkj98/I3j5oG1m7XG4RJkpKK4
zTPjZVTarT0W42veGACVTKIigeeNhVVYTWKsWt1qoa2aDnJFsQvuBsWC/WIU
y7eZlpQ3ORbJxWkSr40B4FaLE4U+do4XC47nS2sYxYLcyY6GYbiNxvHGY+jb
pmm7la1D4R+gRRzgtm3Ttjc+w3Mf6Len/d62tqFf+qyZGj3jLpTDK8UXRcIE
QyN4q/qOPps+wnL7rpkxuVwAtFthv+A8mpVMcJEwgdAbKGy2ihWQwFbrI63i
A69YmC1W7CbguauaxGgD3mpNIIrCYMFsKV9TrIC7xCOevBsVPfXYefzf2/r2
3KVyOKX4okiYgLxTnhE9wgXn0azsgYuECd7dGxir4K3WR1r1alxMFOCt1gRf
NAqPgNQkxdrvAn9vLqgcZCk+bUSeET3C5XhjG97dG3irllutj7Pq1bjYKEBb
rWkj8oxI4Tl4r6zyeCMyQE5vyGnVq0FFQeE+KOVMIac35LTq1aCioHAflHKm
kNMbclr1alBRULgPSjlTyOkNOa16NagoKNwHpZwp5PSGnFa9GlQUFO6DUs4U
cnpDTqteDSoKCvdBKWcKOb0hp1WvBhUFhfvw48eP3cMgjXz2ON4HcnpDTqte
DSoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKL4W+a+q6
Xv8b3F8E6hacDFBReGWo6M+QWtowKO3kcb6Z/Cthp36bQwKoKLwyVPRn6Joq
z7PApt/bZSXP/iKDd4eKrwxQUXhlqOhz0NrX7zD9wlDxlQEqCq8MFX0OOm+v
cux7NvLKUFF4Zajoc9C6/O+G/kJQ8ZUBKgqvDBV9DlpH5dh3beSVoaLwylDR
50C6HFtlSeD7YZJfbpU1ZRb6vh9EZcP9VuuPju/SqgF9XaRpzvvKYA63LbIr
8qrdwqWo8zSk/kj5/gC49bRX1rPAbKDfvklj2m1acj8h/eAotGlEjboxoK+J
UZ4fZCvfjwxx6ZjKLCtEAeBwMZrkcdsqCwM/COOivsfmN5Tqlly86uB+V1X3
GdFf1ySP2zdFRKOQCOffSCeuK6fuBlXHlaJUObaLLJ04Wd/Tf3engNiaukd2
w2y4aaZHFRzgj4wvYNUZpcmMS7hhgrhdqk9vBFrJBu7bW+IcJmSjgP2x5NIP
N2+hxbDZoM25wSjDMzMqQeYHRqEvmVGjEIxwMGB8OAwnKDgpC+Z2wWkgC8IH
c5GahLh96p6GTgej3YyTHGCbB6ypDuQiVcfpF6O6Z0cfp0mQ2+W+do3CPq65
y1XhG2eHXSIFqk4gxdbRpMmxbaJTX1XkxyaxmYo6V9/tHWZek5Aw80wFQ7Ms
xsQlBBxfwKrxlXQU3j7lqR3i9lVAxkHD2g/YwH2rQtqfFRNSX8WWE8NskNtf
+qvo5eijD6ckiNum5Ad9UFlERKfZYGpARkFcQsCN0F53Pp3bfWAQ60/lzcOS
/nQMQG+AXLqUuJZx1EThg7lYTYL95u5xb7P81hf0ZSPCcwesqg7kIlUH94tT
HRS4eQG5upnCRx+pSTCC3p6836ISbzOyXmpmDLuDCCvyzBN5985Jm0WDV9WJ
pZhYmsYtpZ6Lli61RszG0mf6kJHa5rLFtjfk2GUxtl5CcHIsYBX9sfCp8AyD
TDhuRQFxmTb2mXiLyeEWPlHEIb+Le0FDDdiF1VabzeF3VWoqJ2SOBUri1RIC
jEJq69dJxKa8mzcBiafuDCPLPZJ5jvOjHC53dEefu6QJQY4FuUhNCvoduBZ5
dPDAlY7HxagO5CJVB3KRqpsHDigg1zdT6Oi3SE1C3L939OtlqtwlyjF5s2F4
C0my9phje0h14MMrP3Pp5a31M4lnoKbD1Y5RXiZ0O2aUN2GtzB33mtk8NFAx
tlpCcDY7oFU1LQU1u26zPVlMue4DuG3mUG0dTqeT4fiCfeqS24cnsuZGZR65
jkOqgy3cq2scnVs+8bh9FRKSfvKKKiMTR7fgdR8RhfUSgjvLdtY4U5pYp5r/
aboF66hX4UBA3PH/WCzWciyHyyDSJJfbt3VZRC7TYFBs4aJUB3KRqoO4NVJ1
s8DBJfHaZgod/QapSYj7O2fySwFVZPKUM4Ids5zj3kKqAx9eG+hLujIG5Wpt
9AyUwemywu29G/llbOaHyPNYYSHHKyE4ORawihkzFBKkcV1QHiy5XeGTIsT2
g4DNMu6eHeC2zn78P8NkL+1d3lk/z5NDIeQLww1x6R2/S+0RcX77GhGFdrWE
AKPQFR5LEabjmEMp5KR/P/0oQZAtIW67ylrlvq1pksdlBdiAE1h487hI1YFc
pOpgP+NUNwucuIznbabQ0W+RmgS5KRvSyXJsczh4OQg0MM+xgOrAh9Mm+pCt
MlHxyX+3oKMbt52X1X1beAZ1wiXzVxFNirxF/w0IDaeQE5YQcHwXVv3qN381
SM52bIup7mhYUQloVjCiASybwWsoxP09LUEPo8JbfuUm6Hd1ZwRyYyJPzSq6
vs7DEy2l4BYQUWhWSwgwCgRNEdumYZhOnAS0NEHXsRAXW8cKuKuaFHCpEKuU
zvnzBnOV+4u//iVSdcJ+KQSqg7g/IVUH5FjuFoC7mUJHv0FqkuONLgs98sxy
w5TGcZ8Krng8XMcOjbDwWbyi6DnIXTKjzbNpjXU+6SqZmI9uJuAuQwMWcuIS
Aozv0qp//heeY9uOQ/6xbWtUewypHRxR313TbM3fp4BcqlvdGXpiG5AN3MEB
9BUjFFSxEPfXtnb1YZ/ZyFn2BkVhtYTgzbILOhbEoOpCmircwRuFd6SHYGu7
sTN3fF+XsxyL++NzUy5GkyC3766d1aGxskudcH+V/RapOk6/KNWBXKTqZoET
bAEEmyl09GukJsERTR/SI42zimD0GT2PzYbWe0h14MNpEy09o9WtbOW23oeD
VTU7K8jaritienxkJXURmENKjLMsTZMkyej1vD4npbduhheL5/EVFZDcEoI2
smgZtOrKoVtgPR2LZAT3N78hzj7YYVnXReLpbOfVIrlJPej25CVNU7ALRKcC
8gbf5sVVPRT3J/qhx+5IdjpdV4cW8ech6+6OwkoJAUahr+PTwYzzskh9lqPp
57bDGaMZZHURHS5HuzguEUGW5bFH5obmxmmWs4mH4yI1CXD7nO72Lb+om6qI
DZ0eTdfofpGq4/WLUR3YL1J1y/TIK6cFmyl09DukJsER5b55tIKiKmOPbmmt
uAY9SYeeZVlMZWx4cZ7Rq6+g6mApXlphE4F3mvFc9LFzvJQ9R3pFpHFubvXt
xtWqy2gNNPmobhZfTgG5UkLQRhYtQ1ZNQPcR53ZQ3D6PJmPam9kGLhvaOMEp
ORgOuDbYTC+W3ORYJLcrrP3VaH+4knFXFKZvAEsIMAp9nRzPH0lrR+eyYI5X
ValR9vgQx53saIYX2MkhiovVJNhvGU8OEfVTPNxXR4/3HDWR6iAuVnW8fjGq
2/FL0NsCUrSZ2hB9nCZBbh5YF6bhnTW5nAtdeu2BwWalOKA6zsMBGa1suIdC
n4C+a5v1vx1e+Ied5vDiyysggRJigqGRWcuPWMXn9m1LntxEYkO/PXnWTJ89
xebx2dTozVFIariEmEAQBTrsxXg69lRglYC7xHO4NPq3D5/SL1Z1cL9rqptF
n1+Ki37vaWv0VzXJ5fbdXDe8uQBhqTreQ4LY1DRLjt9BQKOixx9kE3o9P16s
oUAxBpcQE5DHy5YfserVuJgowCXEBCoKX5S7yLG8UnyxmZrgi0ZfCJl+zwuN
vq2K2wwJ71OgYmxZQkwbWbb8iFWvxsVGASohpo3IMyLFxXPB6CNL8Wkj8ozo
nSDV3yu4H4KzoCc38spQUXhlqOhzoHLsOzfyylBReGWo6HOgcuw7N/LKUFF4
Zajoc6By7Ds38spQUXhlqOhzoHLsOzfyylBReGWo6HPQqO+lfd9GXhkqCq8M
Ff0Z2iqPo8g197v5n2v7klDxlQEqCq8MFf0ZUmu8H3xy4k/+OwXvgR8/fuwe
Bmnks8fxtaGi8MpQ0Z+h77u2FX/Xn4KCgoLC18D/B+1dbT4=
            "], {{0, 170}, {
            460, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{460, 170},
          PlotRange->{{0, 460}, {0, 170}}]], "ExerciseOutput",
         ImageSize->{464, 170},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d72ea230-70ee-4777-95e0-e64999aa2bfd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfTGr9EyWXr924tB/wT/Aih1aoRM3rHHWyS6eXpyMm12DUSpYBoETOTAK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              "], {{0, 
              170}, {460, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {460, 170}, 
            PlotRange -> {{0, 460}, {0, 170}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5b6e4527-4088-458a-b1ae-581e6adae9af"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f420c0e2-07a4-41e0-a6cf-2a326d722e0e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8e3b7bc4-b3cc-4633-b46d-05a7e2912ba4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1d6047e0-fd9f-48f9-bd97-642ac6efc528"],

Cell["\<\
Make a list of numbers up to 100, with primes framed and labeled in light \
gray with their values modulo 4.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"e1a119b5-ee4a-4804-a8b8-b9f13c4257ae"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6e61d3f4-5754-4e41-8df0-930ed96cf27a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnc+L486b393JJcf8AznkD4jPOcbHXGLYkJsvu2S95LIxu4Hgq2D5IshF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            "], {{0, 285}, {485, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{485, 285},
          PlotRange->{{0, 485}, {0, 285}}]], "ExerciseOutput",
         ImageSize->{489, 285},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c70abb6a-49aa-401a-b13f-f1a7293faf58"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnc+L486b393JJcf8AznkD4jPOcbHXGLYkJsvu2S95LIxu4Hgq2D5IshF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              "], {{0, 285}, {485, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {485, 285}, 
            PlotRange -> {{0, 485}, {0, 285}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6e193e35-d1da-4cd8-afb1-81baf6f3282a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"352b1fc4-7858-4433-b960-1b5abb3d0c15"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b2909579-f7a1-4ea6-9796-2c6ad42aee30"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3ed3fb50-7f26-41ff-b9e8-e16b29595382"],

Cell[TextData[{
 "Create a 3\[Times]6 ",
 StyleBox["GraphicsGrid",
  FontFamily->"Source Sans Pro"],
 " of randomly colored disks."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"1715027b-0c65-4b4a-a508-34ca816fdb3f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3d717ad3-15ad-45db-a114-4fc51032972f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfWtwFUeWpnfnz/7ZiN39uxMbsX92ImY2YrdjOmYnoh8xMxvjcG+MO3bx
dDtw0+EBG3C3G4xtmYfdQPO0LRAgnm4kGSRZGNADEAiEJfFohEBCICQLJEBC
b+lKutIFSSDdW7dK+2lq4k5Z92bdrKrMPERHnvi6opyVdfLrRPHdzDyZp/7r
kvcWLPu3L7300of/DpcFi9f87QcfLF732n/Af/xs5Ye/Wr5y6ds/WZmxdPnS
D/56yZ+g8Az+986/eemluftZbdq0aVNrkWHjbvXUN3njRRuHf79yaO/bAzsX
9eOKe5SgHE9Rh5rmfIuMRe/cilwoDxXk9BzI6ty17dFnGx/ginuUoBxPUYea
5nybCE09qHp8I6fp/PorJe9WHlt8tmDhKVxxjxKU4ynqUNP8jhnGzNTkaGS8
Z3S4PTT47WD/3YG+O7jiHiUox1PUoaY538JDkzcrO8oONR5YU/Pp0nMb3ji1
dsFJXHGPEpTjKepQ05xv45HJ280dFVW3jhyr2nu4fMe+0m27TuCKe5SgHE9R
h4peT+tMWVb403/s/fCvH/MANVEfb1ERtq2781lxUf+WdW0r32rmAWqiPt6i
pT3YOlKTeSPv/5Vkff9LHqAm6uMtQs4z0xNjox39Pbe6O6/xADVRH28RcoZ1
tAwf3Vb7/k+OvfEXX/AANVEfb9HS7uoJnTj1h42fF/36o4M8QE3Ux1tq6Bkx
6+bpic9e7+OUi2TgXXiAHzWE/4W2YdZdDW/9pJ1TLpKBd+EBflTSjsfiLafa
v3ytlFMukoF34QF+lHG2LHPi6VB/byOnXKQQkN5GeIAfZZxn5/6w45eK73/4
D8c55SIZeBceDIVdPUfbiNfevLcp8xinXCQD78ID/EhiaFlWw7mJza/2+FYM
J+AH3uBTElsn7Zu1Y+sz7vtWDCfgB97U0G49+/D3/+e4b8VwAn7gTTZt+J+c
CPV11/tWDCfgB97UdPXV0+2/+btC34rhBPzAmxraN261fbw137diOAE/8Cac
9nBXdN+yASGK4QR8wrNYqk4LDU7v+fSREMVwAj7hWR7tsa7I12+dE6IYTsAn
PEviHIs+GxpoFqIYTsAnPEviDBvoHP/dotNCFMMJ+IRnebSHhsezDpQJUQwn
4BOeRZHEwGDd33QJFw0b8Az/oqg6DQODjF+1CBcNG/AM/zJoY2CQ/cMC4aJh
A57hXzhnDAx6Hl8XLho24Bn+hXOGYWCw+Pu5wkXDBjzDvwzaGBis+viwcNGw
Ac/wH5ChaVplO0clKYYTaAVtCelVm3ZxUb8kxXACrQikbZlWzec3JCmGE2jF
EkQbI9ux0Q5JiuEEWhE4isa/2pGt1yQphhNoRewf9olTf5CkGE6gFd+0jZiV
//GwAtGwgbaELJYahvnloW4FomEDbQlZLI3H4mfXXFIgGjbQVvDFUssyR0Jt
CkTDBtoSslhqxOLZ73+jQDRsoC0hi6WGEc8pvKhANGygLR+LpVAblaKRkI6A
4ozXVYpGQjoC0savv0rRSEhHkFEHfv1VioZDOoL+hagUjYR0BP/DVikaCenw
Srt0h4rpScoJS5DuPfmViulJyglLENrVn9cpFo3EhMU3ZzXTk5QTliBdfWSL
iulJyglLENrHy1RMT1JOWPhJNpybIBENG76XSW/WjpGIhg3fy6StZx+SiIYN
f8ukkxMhEtGw4XuZ9OrpdhLRsOF7mfTGrTYS0bDBuUw63BWVFz3hAVr3EZwN
DU7Li57wAK37CM6OdUXkRU94gNa9Bmdj0Wfyoic8QOs+grMDnePyoic8QOs+
grNDw+Pyoic8QOtpg7OYPMrYp+EV4OBpGovKMvZpeAU4eKUtY5+GV4ADP23U
lLFPwyvAwWtXy9in4RXg4JW2jH0aXgEO7rRpZyhOeJqt0M5QnPA0W6GdoTjB
P1uhnaE44Wm2QjtDccLTbIV2huKEy2zFiFmitpEHB5hwhmUNwxS1jTw4wIQz
LBuPxUVtIw8OMOEJy1qWKWobeXCACWdY1ojFRW0jDw4w4QzLGkZc1Dby4AAT
Vlj25ukXZbBhA3x4urfuaphcLpwAHx7aLafayeXCCfBJy3ni6RC5XDgBPjxd
fan4PrlcOAE+PLRrb94jlwsnwCclzyCnXGUAfHi6N8gpVxkAHx7aQU65ygD4
pOUc5JSrDIAPT1cHOeUqA+DDQzvIKVcZAJ9kkj2tM+RCkYy0+Tq6O5+RC0Uy
0ubrGGwdIReKZLjn65iZniAXimSkzdfR0TJMLhTJSJuvo6snRC4UyUjO11GW
FSZXiWSAlXv3qjmH4hVpt4HVZKo4h+IVYOXCmWqjlzvSbgM7uq2WXCWSAVbu
tNWcQ/GK5G1g/Jm7VAKs3LuXP3OXSoCVO23+zF0qAVYunPkzd6kEWLl3NX/m
LpUAK3fa/Jm7VAKsnCQjwwa5RLDgkps0MhYllwgWXHKTToSmyCWCBVZuUsOY
IZcIFlxyk4aHJsklggWX3KTjkUlyiWDBmZv0bvUUuT6wAG6s7r1zK0KuDyyA
G4v2g6rH5PrAAril5Dw1OUquDyyAG6urb1Z2kOsDC+DGon27uYNcH1gAtwTP
b/LGyfWBBXBjde+F8hC5PrAAbizaN3KayPWBBXBLyTky3kOuDyyAG6uryw41
kusDC+DGol1RdYtcH1gAtwTPrzaqPjLPj6KNzJXn/MM95PrAQkEO84+54rdX
yPWBhfPrr6TkPDrcTq4PLIAbq6v3r64m1wcWDqypYdE+cqyKXB9YALcEz9+v
HCLXBxbAjdW9B7I6yfWBBXBj0S55t5JcH1gAt5ScQ4PfkusDC+DG6upPl54j
1wcWwI1Fe+/hcnJ9YAHc/pXn2/Rn2VgAN1b37tpGf5aNBXBj0T62+Cy5PrAA
bik5D/bfJdcHFsCN1dUb3jhFrg8sgBuL9o59peT6wAK4JXjuXNRPrg8sgBur
ez/b+IBcH1gANxbtgoWnyPWBBXBLyXmg7w65PrAAbqyuXrvgJLk+sABuLNrb
dp0g1wcWwC3BU4839HhDjzf0eMPreEOvbwiHXt9QBr2+oRLO9Q0dTxEOHU9R
Bh1PUQlnPEXv3xAOvX9DGfT+DZVw7t/Q+0WFQ+8XVQa9X1QlnPtF9fkU4dDn
U5RBn09RCef5lFl9HlYo9HlYZdDnYVVi3nnYWZ1/Qyh0/g1l0Pk3VCI5/4bO
9yUQOt+XMuh8XyqRnO9rVucXFQSdX1QZdH5RlUiZX3RW5zMXBJ3PXBl0PnOV
YOUz199PCQ79/RRl0N9PUQmX76fM6u+1BYb+Xpsy6O+1qYT716X192GDQH8f
Vhn092FVIu33YWf19+j9Qn+PXhn09+hVgud79LbRzlY8zVCcRjtb8TRDcRrt
bIV/huI02tmKpxmK02hnK55mKE6jna24z1DmWdnOURLRQLv++tY2qm1gaTd6
uVvN5zTbwNCub85U28DSbvRytyNbr5GIBtoNQptqG1jyRi93M00r/2PVh+vR
ItoN0r14/ctD3YpFAy0GpG2Z1tk1lxSLBlq0AtDGhHck1KZYNNCip/WBZMO/
VPb73ygWDbQY/A87p/CiYtFAiz5oGzGl0oG2OAOvaWgbpkrpQFucgVd3i8fi
KqUDbfEEXt3NskyV0vHPoiGgq41YXKV0oC3OwGsa2kZcpXSgLZfAq7tBbdRM
WNBKQEGeR1vNhAWtCKSNX381Exa0EmSk8R3OlqVmwoJWAo40nIZ/NTUTFrQi
9g9bzYQFrQSn3XBuQl6EBZ59L4S6283aMXkRFnj2vRDqbq1nH8qLsMCzv4VQ
d5ucCMmLsMCz74VQd7t6ul1ehAWefS+EutuNW23yIizw7Gkh1N2Gu6Iy9nXA
p4+QK7+FBqdl7OuATx8hV34b64rI2NcBn15DrvwWiz6Tsa8DPn2EXPltoHNc
xr4O+PQRcuW3oeFxGfs64JMz5MpvGCViYCBqIzr8wJvAkacLbQwMRG1Ehx94
U0MbAwNRG9HhB95k04Z/DAxEbUSHH3hT09UYGIjaiA4/8KaGNgYGojaiww+8
yaNtxKybpyeCnJzFu/AgZAnUA23DrLsaDnJyFu/Cg5AlUH6Lx+Itp9qDnJzF
u/AQfAmU3yzLnHg6FOTkLN6FByFLoPxmxOKXiu8HOTmLd+FByBKoB9pGvPbm
vSAnZ/EuPPheAvVqPa0zZVlh/ixhqIn6afNpyLbuzmfFRf38WcJQE/XT5tOQ
bYOtIzWZN/izhKEm6rvn05BtM9MTY6Md/FnCUBP10+bTkG0dLcNHt9XyZwlD
TdRPm09DtnX1hE6c+gN/ljDURP2U+TTUWGTYuFs99U3e+Fcbh3+/cmjv2wM7
F/XjivuijcMox1OXHKFUFhmL3rkVuVAeyj/ccyCrc9e2R59tfIAr7gtyelCO
py45QqlsIjT1oOrxjZymit9eKXm38tjiswULT+GK+/Prr6AcT1k5QqnMMGam
Jkcj4z2jw+2hwW8H++8O9N3BFfcoQTmeuuQIpbLw0OTNyo6yQ437V1d/uvTc
hjdOrV1wElfcH1hTg3I8dckRSmXjkcnbzR0VVbeOHKvae7h8x77SbbtO4Ip7
lKAcT+flCNWmTZs2bdq0adOmTZs2bdq0adOmTZs2bdq0adOmTZs2bX8EFo+M
zTQ1PKssnyg8/PRQ1pPd2yKZG3DFPUpQjqeoQ01zvo1Hh26PXTg/cOBoZ8a+
9iU7772+/duf4op7lKAcT1GHmuZ8i0aejTf1Dla2dhXceHTwcvvuqrbPK3HF
PUpQjqeoQ03zOxaesK63myfrzOyK+Obi+Loi44N8A1fcowTleIo61DTnW+iJ
Vd1i5VabG46bK/LiSw7Gf7Fn7op7lKAcT1GHmuZ86386c/p+OPNa//Izj177
uu3l/NYf5bbginuUoBxPUYeKXqy7c6q0aHzr2vCqJTxATdTHW1SEbeuabD7Z
veV3zS+/2/BnPEBN1MdbtLSnusO9JbfvbTl3573jPEBN1MdbhJwfDlq5NfF3
c43XdnIBNVEfbxFyhrX2WjvOmK/tiP/VWi6gJurjLVrajQOTay52ff9Q03/a
fpMHqIn6eEsNPcswpuuujm//mFMuUgjI9o/hAX7UELbNMKO1Iyc3t7zCKRfJ
wLvwAD8qaZtGfLSu4962Ck65SCEg2yrgwVR1+gAWi1tVzeaKL3nlIhl4Fx7g
RxnnOdqGdbrB/FkWr1wkA+/CA/yopB2NmwVNw//ri7uccpEMvAsP8COJoWVZ
0/W14xs/9K0Y31GPjR/Cm6Jjg6NlnzT92LdiOAE/8KaGdrj+8bcbzvhWDCfg
B94UnIe91Gou/cK/YjgBP/CmpqvPNZr/sN2/YjgBP/Cmhvax5pH/vu+Ob8Vw
An7gTTjteGjwSfZ2IYrhBHzCs1iqTht63pl1f6EQxXACPuFZHu3p0NMHe6qF
KIYT8AnPkjj3h61PvhajGE7AJzxL4gzrGraWHhKjGE7AJzzLo/0g/PwnBa1C
FMMJ+IRnUSQxMAivfke4aPwLVr8D/6KoOg0Dg/cb/6dw0bABz/AvgzYGBnc/
KhYuGjbgGf6Fc8bA4I094kXDBjzDv3DOMAwMfrxevGjYgGf4l0EbA4M/3dEg
XDRswDP8B2RomeZUyVeyFMMBtIK2hPQqzLTME92bJSmGE2jFFJcmwjKt3uJG
SYrhBFoRlV8UI/Kc6rgkxXACrZhC84vuOGNKUgwn0IrI/KKWtfpilyTFcAKt
+O5tyzAmjhxUIBo20JaQxVLDjOY+ek+BaNhAW0IWS00j/vjIdQWiYQNtBV8s
jcWtneUqRMMG2hKyWBozrHVFKkTDBtoSslgajZuLyx4qEA0baMvHYil+/VWK
xr9KR7BRB379VYpGQjoCjjrw669SNBLSEWTUgd8jlaKRkI6Aow78+qsUjYR0
BP1+imWpFI2EdHjt7cmSQsWikZiwBOneE92bFItGYsIShLaa6UnKCYtvzmqm
JyknLEG6OvO0atFITFiC0P6oUsX0JOWEhZ/k3EIohWjY8L1MemO0jEQ0bPhe
Jg3XPyYRDRv+lkkvtZokomHD9zLpuUYa0bDhe5n0WPMIiWjY4FwmjYcGJUZP
eLD6HR/B2aHnnfKiJzxA6z6Cs9Ohp/KiJzxA616Ds/1hS170hAdo3UdwtmvY
khc94QFa9xGcfRB+Li96wgO0njY4a1mWjH0aXgEOnragoLKMfRpeAQ5eacvY
p+EV4MBPGzVl7NPwCnDw2tUy9ml4BTh4pS1jn4ZXgIM7bdoZihOeZiu0MxQn
PM1WaGcoTvDPVmhnKE54mq3QzlCc8DRboZ2hOOEyW7EMQ9Q28uAAE86wrGFG
RW0jDw4w4QzLmkZc1Dby4AATnrBsLG6J2kYeHGDCGZaNGZaobeTBASacYdlo
3BS1jTw4wIQVlp2uu0ouF98ZctRd5ene2pGT5HLhBPjw0B6t6yCXCyfAJy3n
quYXZbBhA3x4uvp0w4sy2LABPjy0C5qGyeXCCfBJyTPIKVcpQ47tH/N0b5BT
rjIAPjy0g5xylQHwScs5yClXGQAfnq4OcspVBsCHh3aQU64yAD7JJGPdneRC
kYy0+Tq6JpvJhSIZafN1THWHyYUiGe75Oh4OWuRCkYy0+Tpaey1yoUhG2nwd
jQOT5EKRjOR8HVOlReQqkQywcu/ek91byFUiGWDlTru35Da5SiQDrFw459bQ
bPRyB1i5d7WacyhekXYb2Bol51C8Yk3SNjD+zF0qAVbu3cufuUslwMqdNn/m
LpUAKxfO/Jm7VAKs3LuaP3OXSoCVO23+zF0qAVZOkvHIGLlEsOCSm3Q8OkQu
ESy45CaNRp6RSwQLrNyk4YkXcZJiwyU3aejJizhJseGSm7T/6Qy5RLDgzE06
09RArg8sgBure2+PXSDXBxbAjUV7vKmXXB9YALeUnK+3v1iRFCfAjdXV1S0v
rm6AG4v26fthcn1gAdwSPJ9VlpPrAwvgxure8wMHyPWBBXBj0R6sbCXXBxbA
LSXnk3Uvrm6AG6urc6tfxMUNG+DGop15rZ9cH1gAtwTPicLD5PrAArixuvdI
Rwa5PrBwtDODRbur4Aa5PrAAbik576l4ERdFbWRXMNcK1h9/cXVjw3Gmbiw7
84hcH1hYfuZRgufTQ1nk+sACuLG6d1/7EnJ9YAHcWLQfHbxMrg8sgFtKzpuL
X1zdADdWV6/Io9cHFsCNRfu1r9vI9YEFcEvwfLJ7G7k+sABurO7dee91cn1g
AdxYtNt3V5HrAwvglpLzuiJ6fWAB3FhdveQgvT6wAG4s2i/n059lYwHcEjwj
mRvI9YEFcGN17/Zvf0quDyyAG4t22+eV5PrAAril5PxBPr0+sABurK7+xR56
fWAB3Fi0f5TbQq4PLIBbgqceb+jxhh5v6PGG1/GGXt8QDr2+oQx6fUMlnOsb
Op4iHDqeogw6nqISzniK3r8hHHr/hjLo/Rsq4dy/ofeLCofeL6oMer+oSjj3
i+rzKcKhz6cogz6fohLO8ymz+jysUOjzsMqgz8OqxLzzsLM6/4ZQ6PwbyqDz
b6hEcv4Nne9LIHS+L2XQ+b5UIjnf16zOLyoIOr+oMuj8oiqRMr/orM5nLgg6
n7ky6HzmKsHKZ66/nxIc+vspyqC/n6ISLt9PmdXfawsM/b02ZdDfa1MJ969L
6+/DBoH+Pqwy6O/DqkTa78PO6u/R+4X+Hr0y6O/RqwTP9+hto52teJqhOI12
tuJphuI02tkK/wzFabSzFU8zFKfRzlY8zVCcRjtbcZ+hzLOpkq9IRAPt+utb
2050byYRDbQbhHZvcSOJaKBd35xzqmm2gaHdIF1NtQ0s7UYvd1tNtA1sddJG
L3ezTHPiyEHFooEW0W6Q7jUtM/fRe4pFAy2i3SC0LdN6fOS6YtFAi2g3QFdb
O8tVSwdaNL2sD6SgbVrrilRLB1o0A3S13duLyx4qFg206KO3LcNQKR1zosEX
eHU3w4yqlA60xRl4dTfTiKuUDrTFE3h1t1hcqXSgLc7AaxrahlLpQFucgVd3
i8ZNldKBtlwCr+6GX381Exa0EnCk4TT8+quZsKCVgCMNp+HXX82EBa0EGWk4
Db9HaiYsaCXgSOM7tE1LzYQFrQQcaXyHtmWpmbCgleC9PbdMKi/Csvod3wuh
7nZjtExehAWefS+Eulu4/rG8CAs8+1sIdbdLraa8CAs8+14Idbdzjaa8CAs8
+14IdbdjzSPyIizw7Gkh1N3ioUEZ+zrg00fIld+GnnfK2NcBnz5Crvw2HXoq
Y18HfHoNufJbf1jKvg749BFy5beuYSn7OuDTR8iV3x6En8vY1wGfnCFXfrMs
CwMDURvR4QfePO2B8U0bAwNRG9HhB97U0MbAQNRGdPiBN9m04R8DA1Eb0eEH
3tR0NQYGojaiww+8qaGNgYGojejwA2/yaFuGMV13NcjJWbwLD0KWQPnNMKO1
IyeDnJzFu/AgZAmU30wjPlrXEeTkLN6Fh+BLoPwWi1tVzWaQk7N4Fx6ELIF6
oG1YpxvMICdn8S48CFkC5bdo3CxoGg5ychbvwoPvJVCvFuvunCot4s8Shpqo
nzafhmzrmmw+2b2FP0sYaqJ+2nwasm2qO9xbcps/Sxhqor57Pg3Z9nDQyq2J
82cJQ03UT5tPQ7a19s4tmfJnCUNN1E+bT0O2NQ5MrrnYxZ8lDDVRP2U+DTUW
j4zNNDU8qyyfKDz89FDWk93bIpkbcMU9SlCOpy45QqlsPDp0e+zC+YEDRzoy
9rUv2Xnv9e3f/hRX3B/tzEA5nrrkCKWyaOTZeFPvYGVrV8GNRwcvt++uavu8
ElfcowTleMrKEUpl4Qnrert5ss7cUxHfXBxfVzT3hTVccZ9dEUc5nrrkCKWy
0BOrusXKrTbXHzdX5M19JukXe+auuN9w3EQ5nrrkCKWy/qczp++HM6/1Lzvz
6LWv217Ob/1RbguuuF9+5hHK8XRejlBt2rRp06ZNmzZt2rRp06ZNmzZt2rRp
06ZNmzZt2rRp0/ZHYJHnQ0395yvb9hfeyjhUu3j3lZ9nVr+KK+5RgnI8RR1q
mvPt6ZPw/Zbr12pOnjmx51jepqMH1+Zkv48r7lGCcjxFHWqa863ffHLKaM2M
Xlk2XbpguuDl5zk/fH4QV9yjBOV4ijrUNL9jw5HpmqbQl5WdmwpbVh1qXLa7
/s3MOlxxjxKU4ynqUNOcb1Z4xKq7ahUXmns/M7esNT9ZaWYsn7vifu9nKJ97
GhZ2BEyUTY30Pb5cfCd/y+Wtv7yQ8Ur5r39Q9tb3cMU9SlCOp6hDRa97rLn0
7uatF/9+Vdl/4wFqoj7eoiJs20Dvw4vlOQd3vrtt3QIeoCbq4y1a2o3xvtUz
FX/5LPs/Tm3kAWqiPt4i5Hyv+8mu0rbXt9b+YNU3PEBN1MdbhJxh1qM2M2+/
ueJN82d/zwXUzNuPt2hpj9yvr8teefIXf5b7N3/CA9REfbylhp5hRuu6Tmz/
5hVOuUgG3oUHxQc94kasqaHqi10rOOUiGXgXHuBHJe2oZeTHGv/q2T5OuUgG
3oUH+FHGOWaY5XV9C7fzykUy8C48wI8yzrNzB69iVvV5870lvHKRjPeWwIOl
9i8kHou2n8st/uWfc8pFMvAuPMCPJIaWZdV3l208/yPfiuEE/MCbmmODzbcv
7f30bd+K4QT8wJui046xpr94luVbMZyAH3hTcB62on7g/2686lsxnIAfeFPT
1dbli+byhf4Vw4nlC+FNDe2HF/KP/eN/8a0YTsAPvAmnHZroyL66UIhiOAGf
8CyWqtNGh/vyv/hYiGI4AZ/wLI/2A3PkJ8/zhCiGE/AJz5I4d4emfpXdIEQx
nIBPeJbEGWb195jrV4lRDCfWr4JnebQjPW1nf/NjIYrhBHzCsyiSGBisPvM/
hIuGDXiGf1FUnYaBQeaGhcJFwwY8w78M2hgY/OeprcJFwwY8w79wzhgY/O/V
1cJFwwY8w79wzrC5YcaiV8WLho1Fr8K/DNoYGBx95d8LFw0b8Az/ARmallly
d5MkxXACrQhN1GlWnsmRpBhOoBWxaVE/mqmQpBhOoBVRvW2a1q6SNkmK4QRa
EZioE/9qZt4+WYrhRN4+gX8hcHV9zwpJiuEEWvFN2zCjR+pXKhANG2hLyGJp
3IiVFu1QIBo20JaQxdKoZfzT9AkFomEDbQVfLI0Z5m+PNCsQDRtoS8hiqWXE
zKwtKkTDRtYWIYul8Vi0ZuPrCkTDBtrysViK3yOVopGQjsAfIjFVikZCOoJ/
9kWlaCSkI0hv49dfpWgkpCPgqGNupKFSNBLSEewvBK+rFI2EdHilXdKkYnqS
csISpHsrzxxWLBqJCUsQ2hkz5xSLRmLC4ptzVsl9xaKRmLAE6WozV8n0JNWE
JQjt63t+o1g0EhMWfpL13WUkomHD9zJp8+1LJKJhw/cy6bFYE4lo2PC3TFpR
P0AiGjZ8L5POLYSSiMY/w/cy6cML+SSiYYNzmTQ00SEvesIDtO4jODs63Ccv
esIDtO4jOPvAHJEXPeEBWvcanO0OTcmLnvAArfsIzs6FXOVFT3iw6FUfwdlI
T5u86AkP0Hra4KxlWTL2aXgFOHjagoLKMvZpeAU4eKUtY5+GV4ADP23UlLFP
wyvAwWtXS9mn4RXrV3mlLWOfhleAgztt2hmKE55mK7QzFCc8zVZoZyhO8M9W
aGcoTniardDOUJzwNFuhnaE44TJbMcyoqG3kwQEmnGHZuBETtY08OMCEMywb
tQxR28iDA0x4wrIxwxS1jTw4wIQzLDsXeBW1jTw4li/kDMvGY1FR28iDA0xY
Ydm6rhPkcuEE+PB0b1NDFblcOAE+PLTzY43kcuEE+KTlXF7XRy4XToAPT1fP
HVgjlwvnkKP6PA/t9nO55HLhBPik5BnklKsMgA9P9wY55SoD4MNDO8gpVxkA
n7Scg5xylQHw4enqQKdcZeC9JTy0g5xylQHwSSbZPdZMLhTJSJuvY6D3IblQ
JCNtvo7GeB+5UCTDPV/Hve4n5EKRjLT5OubyaZALRfKQI12+jpH79eRCkYzk
fB2ldzeTq0QywMq9ey+WqziH4hVg5U57tZJzKF6x2nUb2K5SFedQvAKs3Lt6
LgkPtUqkQN5+d9p12SvJVSIZYDWPJ3/mLpUAK/fu5c/cpRJg5U6bP3OXSoCV
C2f+zF0qAVbuXe0hc5dKrHjTnTZ/5i6VACsnycjzIXKJYMElN+nTJ2FyiWDB
JTdpv/mEXCJYYOUmHY5Mk0sECy65Sa3wCL1EMOCSm3RqpI9cIlhw5iZt6j9P
rg8sgBure++3XCfXBxbAjUX7lNFKrg8sgFtKzjVNIXJ9YAHcmLpRd5VcH5i6
UXeVRfvx5WJyfWAB3BI8K9v2k+sDC+DG6t5rNSfJ9YEFcGPRzoxeIdcHFsAt
JecvKzvJ9YEFcGPqRnEhuT4wdaO4kEX7Tv4Wcn1gAdwSPAsbPiTXBxYKb2Ww
uvf08d3k+sDCmRN7WLSXTpeQ6wMLy6ZLU3L+XWELuT6wsKmwhdXVZvan5PrA
xN7PWLQvb11Erg8sXN76ywTPQ7WLyfWBBXBjde+xvE3k+sACuLFoL5guINcH
FsAtJedVhxrJ9YEFcGPqxpa19PrAwpa1LNoXMl4h1wcWwC3Bc/eVn5PrAwvg
xureowfXkusDC+DGov3y8xxyfWAB3FJyXra7nlwfWAA3pm58spJeH1j4ZH5M
M2Hlv/4BuT6wAG4JnpnVr5LrAwvgxurenOz3yfWBBXBj0f7h84Pk+sACuKXk
/GZmHbk+sABuTN3IWE6vDyxkLGfRLnvre+T6wAK4JXjq8YYeb+jxhh5veB1v
6PUN4dDrG8qg1zdUwrm+oeMpwqHjKcqg4ykq4Yyn6P0bwqH3byiD3r+hEs79
G3q/qHDo/aLKoPeLqoRzv6g+nyIc+nyKMujzKSrhPJ8yq8/DCoU+D6sM+jys
Ssw7Dzur828Ihc6/oQw6/4ZKJOff0Pm+BELn+1IGne9LJZLzfc3q/KKCoPOL
KoPOL6oSKfOLzup85oKg85krg85nrhKsfOb6+ynBob+fogz6+ykq4fL9lFn9
vbbA0N9rUwb9vTaVcP+6tP4+bBDo78Mqg/4+rEqk/T7srP4evV/o79Erg/4e
vUrwfI/eNtrZiqcZitNoZyueZihOo52t8M9QnEY7W/E0Q3Ea7WzF0wzFabSz
FfcZyjwrubuJRDTQrr++ta3yDM02MLQbhPZHRNvAPnLd6OVuu0potoGh3SBd
bebto9GNvPRhbhe7vmcFiWigXW/da5lH6lcqFg20iHaDdK9lmqVFOxSLBlpE
u0Fo4//1P02fUCwaaDFIb5um9dsjzYpFAy2i3SBdjX8pM2uLatHI2hLwLwSv
12x8XbFooEUftA0zqlI60BZn4NXd4kZMpXSgLc7Aq7tFLUOldKAtnsCru8UM
U6V0oC3OwKu7zYVlVUoHREPEX0g8FlUpHWjLJfDqbvg9UjNhQSsBRxpOg0iq
mbCglYC/I05DD6iZsKAVUb2NX381Exa0EnCk4bS5UYeaCUvePoF/IXClZsKC
VoLTru8ukxdhgWffC6Hu1nz7krwICzz7Xgh1t2OxJnkRFnj2txDqbhX1A/Ii
LPDseyHU3eaWSeVFWBa96nsh1N0eXsiXF2GBZ08Loe4WmuiQsa8DPn2EXPlt
dLhPxr4O+PQRcuW3B+aIjH0d8Ok15Mpv3aEpGfs64NNHyJXf5oKzMvZ1rF/l
I+TKb5GeNhn7OuCTM+TKb5ZlYWAgaiM6/MCbpz0wvmljYCBqIzr8wJsa2hgY
iNqIDj/wJps2/GNgIGojOvzAm5qunht4iNqIvnwhvKmhjYGBqI3o8ANv8mgb
ZrSu60SQk7N4Fx6ELIHyW9yINTVUBTk5i3fhQcgSKL9FLSM/1hjk5CzehYfg
S6D8FjPM8rq+ICdn8S48CFkC5TfLiM0dfwtycva9JfAgZAmU3+KxaPu53CAn
Z/EuPPheAvVq3WPNpXc382cJQ03UT5tPQ7YN9D68WJ7DnyUMNVE/bT4N2dYY
71s9U8GfJQw1Ud89n4Zsu9f9ZFdpG3+WMNRE/bT5NGTbXL6OvP0esoShZt7+
tPk0ZNvI/fq67JX8WcJQE/VT5tNQY5HnQ0395yvb9hc2fHiodvHuKz/PrH4V
V9wX3spAOZ665AilsqdPwvdbrl+rOXn6+O5jeZuOHlybk/0+rrg/c2IPyvHU
JUcolfWbT04ZrZnRK0unSxZMF7z8POeHzw/iivtl06Uox1NWjlAqG45M1zSF
vqzs/F1hy6pDjct217+ZWYcr7jcVtqAcT11yhFKZFR6x6q7OZUTP/nTuOyyf
rJz7+huuuN/7GcrnnrJzhFLZ1Ejf48vFd/K3XN666ELGK+W//kHZW9/DFfeX
t/4S5Xg6L0eoNm3atGnTpk2bNm3atP1x2P8Hk78mjQ==
            "], {{0, 177}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 177},
          PlotRange->{{0, 360}, {0, 177}}]], "ExerciseOutput",
         ImageSize->{364, 177},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ee7101fd-dc67-4d08-a357-4fc042bb9b60"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfWtwFUeWpnfnz/7ZiN39uxMbsX92ImY2YrdjOmYnoh8xMxvjcG+MO3bx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              "], {{0, 177}, {
              360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 177}, 
            PlotRange -> {{0, 360}, {0, 177}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3a91d590-f499-40b9-b663-45d3afeb0a2f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f368ef06-077e-47e0-aa7c-4283c5f11c43"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"36dc8b1f-6ee5-4f6e-8cf0-b47579fee942"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"289ba6a0-433d-4cf7-a374-070be8e280ce"],

Cell["\<\
Make a pie chart of the GDPs of the countries in the G5, labeling each wedge.\
\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"24f1ed60-68ff-4490-8463-b2815908c06e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c250d91a-83d4-4358-aaee-389f20def225"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnXlYU1f+8O/7vv+8/aPv9Okz4zy2T0cWN1QEdcapyiKIO4qAikIgeyAb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            "], {{0, 360}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 360},
          PlotRange->{{0, 360}, {0, 360}}]], "ExerciseOutput",
         ImageSize->{364, 360},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "722d1a49-26ed-45e7-be47-26628d4b4c7a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnXlYU1f+8O/7vv+8/aPv9Okz4zy2T0cWN1QEdcapyiKIO4qAikIgeyAb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              "], {{0, 360}, {360, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 360}, 
            PlotRange -> {{0, 360}, {0, 360}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fb170cc2-ac5d-4d48-821f-25f4991787ea"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"47701528-c72f-4805-b296-b2312547f4e1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5f9f5be6-28c1-4cc9-a627-f5929633c771"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9179d93e-69f6-41df-ae37-5ed30bb0594c"],

Cell["\<\
Make a pie chart of the populations of the countries in the G5, giving a \
legend for each wedge.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"5067bbdb-d4b5-48c7-a8ad-33b95305822d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2c4bb4a7-b276-49c2-a518-35a9cc66cc7f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvWdck9m+981z32+el8/L+7w4s8eGYAnizOxt19gbRuxCgFASOoRO6AQE
AghERWKNDVFjw1FjiyIqYMkUdAb1MCP73pspqODGEhgUnpUrAVEBIRBWyu/7
+Z1z5lwmV64k6/fLYl1rrf8Ir9BVgv9lY2MT8f+S/7XKM4YdHu4pWv3/kf9n
bUiEv28I32dJSCTflx8+xet/k4MB/4+NzQvyP9r/7gAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwJDy6tWrf//73w8fPlSr
1eXl5efOnCrZt2O3NHNrRnxuUlhGtF9yiLvId12096ooL+dI3soI3opwd6cI
jxXR3qvj/Tcmh3ikR/IlccFbNon2bJEc2b/z7OkTV69evXv3LjlnfX39y5cv
ab9FAACwNJqamh4/fnzr1q2TRw/tyEvPigkgKR3rsUTMmyvxmJbn5rjN1W63
+9iD3vbH/SacDph4Lph1UehwNWLSjWjHmzGTb8VMrojVqjJ2cpXoq5vRk8si
HVXhky4JHS6EOpQGTjwmGE+eu9vdrtDVtsBtUpbHtFTePJHHkkgeJy3cR5Yr
Pq0oqaioePTo0bNnz969e0f78wAAAPOgra3tX//6V1VV1fa8zLQofxLdcR4L
MzxmbOFO2OepTWwSwiSlSTIbW+Qn4ErYpBN+E/Z62EldJ5CcT+ItjPZauTkl
QnFIXllZ+eTJk5aWFtofGAAAmBB//vmnWq0+c+yQLC0inb9ihy/7rJ9D8Iz/
U7B+DOlOD0N091/kp+RM0ETyy1LAZaV5zI72WCaJC1Yc3k+un7wL2h8kAABQ
4Pnz5/fu3VPIi7KFblsFC075Tb4TYvfvhIlvJZM7cr4iKuWNSl49gXqAf1bn
Qlhynt1mt68SPObH+2/cLyu4ffv206dPaX/AAABgRFpaWu7fv3+6ZF9etM9m
n4Unfb/6Xmj/n7RJugD/SI+jxwvmj6Ue1wNSWaRjsc+4PO6kePcFKULPowf3
kPeLMRkAgMXQ3Nx89+7dg9skGb6cYsGUe6F2z1Iceszw7noncVwz5csb0Y7U
U9owXRI67PO0z3KfEu25YkfepoqKisbGRtpfBQAAGEJTU1N52dWdmaIsnyWk
K/5z5Li/siZ/Nsa7y4c9ujRwIvVkHqRuxkw+Khifz50kcl+Ulxp943rZixcv
aH85AADweVpaWtRq9d7NKdk+i5V+E38VTXgnGViMdylh8Ug5z456IA+hTvpP
yOc6xHos2ZqZWFVZ+fr1a9pfFwAAfEx7e/ujR4+OyYsy/ZyPCb5+FD3e4Bjv
0u61f8tZb089hIdcFbGTFb7jN7s5xng6Hdi57fHjx+TTo/0FAgCAdnj82uWL
uRG8PfwZ90LtNBmOg4zxLt3wt41YPo56/BpPN6Id93nai91mpgi9Ll1QNjU1
0f4yAQBWyj//+U/FPlmWYPk5P9bz1M/f4hyomlIdNk4fST11h0EXQh22uU2M
8VhKuutPnjyh/cUCAKyFtra2e3fvFqVHbfWZczvYrjVzyDrkn8p1xqjLYQ7U
83Z4dDN68j6eXSJ3dk5SxN27d8nnTPurBgBYLK2trbfKr+eEexwR/P2X2AnG
i/EuhSwYfVQwnnrSDrNO+k+QcP+eHOJx/do1TF8HAAwtGo2m7MolSYjLccHk
P5NZw5DkOmU7fVHoamarioZKylBWDtcxzm/9ReU5zIQBAAyeV69eXT5/Jitw
bamvgzEGyfvWSY+Rqautrn/eXVfCJhVwWXH81cqzpW/evKHdHAAAZklra2vZ
lYtZAWuUfhN7W5VvbP0cOc53gZX2z7vrWsSkAldWvO861eWLGIEBAPSfd+/e
3amqzAn3OCGY9EJMJ8l1Ylb9jzC1XRZp6XKYQ67rpMRA1xvXr799+5Z2MwEA
mDo//fSTNCH4IP+bP5KGb5y8D3nPGX0myOxX/Q+hLoY6SLhfp0cH/Pzzz7Qb
CwDARPnjjz/25KXJvKb/KhqOuSv9VNziUfs8LXCV6CB10n9Ckuv0os2bfvvt
N9oNBwBgQrS0tChLj2f7LPlOOI56gH+kXWu+yN2APO9BlbGT93uNi/NYdPJo
MW6VAgAI1T/+mBvhecaX9WboluoPoa7720Y5WfKq/0HqZvRkKXdiUrDb999/
T7spAQCo8ezZM7k0U+Y17d8JE6nndm96nurgOsMqVv0PRmeDWSkuU2X5mSiN
BIC10d7efut6WbYf506IfXv2YDdCNLZcpo+8EjaJemaauCpjJ+/1HBfnvaLs
6hVs2AiAlUC65bs3i/d5f0NrVvlAFTx/9DHrW/VvmK5GTErf+LU0M6mhoYF2
QwMAGJfKmzey/Z3vhJjcfc8+JHH6WxHXlnpUmpH2eY2L9XIqL7uGjjoAFklT
U9Pegoy93n9vHPZl+4PUcbeR4jXonw9MV8Impbt8XZibhvJ2AFgYNTU12SEb
K82qW96lB5Hj/BZi1b8h2s0blxCw8cGDB7QbIABgCHj79q2y9HiB15x6E57E
0rfaMh3XThlxMwar/g3R2WBWnMusk0cP//XXX7QbIwDAcBobG3dIko74OLYY
s+rEMMhz9uhvserfUN2Idsx1nZSbEv3s2TPaTRIAYAgP7t/PDt5wO3Q89TQe
vOIWj9qPVf+D00Hv8fG+62pqamg3TADAwFBdOCf1mvNboknsqTV47Vj9Rd4G
O+qRaO46G8wSubIvnv8W814AMAtaW1tLdhfKvb/RmOT6fcN0zc82ZgWmuAyB
yiId0zZ+vWtrrkajod1UAQB90dTUtD099ltfh3cSU1/1OSA9TXbgzhxFPQwt
Q5Wxk7e5TcxKCHv+/DntBgsA6Jm6urqcMHfLGDD/VBumjVSFY9X/kGm/17ik
IC5pM7SbLQDgY374Tp3ru8ykti4fWgXNG33MF0MuQ6mT/hNiecvU9+7SbrwA
gPfcul6W7zXH7BZ+DkiZy7+UcbGqaIh1MdQh3nW26vJF2k0YAKDl0tnSbbxp
zWayuZbBUnBHpGPVvxFUFumYtHHqmRPHMOkFAIq8e/fuVMn+3Z4WNZWlN90P
tw9YhCmLRtGNaO2kl8P7dqHMNAC02L0le6/HpLYsi5rK0pvaMh3XTPnyFlb9
G0fkg83c6HhWcRDbAgAwzBDT7S3I3OViBtUohlCes0adDWZRjz5LVWXs5Hyu
g6wgq7W1lXYDB8Ba0IX5GV8LWfvZf8UsGnnAC6v+jas8F9b2zZsQ6QAMA7ow
LxVYXZgTbXf+73ys+je+8l0nFuakIdIBMCokzOVbJNYZ5kQqwZhYDqa4DIfy
XCZsSoik3d4BsFh0YX7aWsOc6PfEie6zR1PPOisRf86XsoKstrY22g0fAEvj
3bt3B4ryysPohypdbZg28moEVv0Pk3JcHPYWSUnbo938AbAoThySl/hMtqrZ
LD0qYN5oBVb9D5cqYydnbHQ8vG8XlhoBMFRc/Pb0Hq+/W8k8876VvuxLmRtW
/Q+fKmInp7t8fepYCW0TAGAJVJRf3+Y53RpWgPZHR1xGpK9F/3xYdTN6cuKG
KWVXL9O2AgDmTfWPP+R5sf9j6Xuz9F8/htkHLcYU9OHWtYhJItc5P/7wA21D
AGCu/PrrrzmCpc8tetfEgao103HN1C8rYrHqf7h1IdQhlrcM+6UDYABNTU05
QrcnlrufucHizR59LgSr/inodMDExACXp0+f0jYHAOZEa2trYXrMHQutNDRI
RS8adRCr/inpoPe4rARhS0sLbYsAYDaU7Cn81hfDLD2r0Pm/CzZi1T81SbkT
9xZJMYMRgP5w9aJyr9c3FlbQeQh1yWe0aCWmuFBTRezktI1fXzz/LW2jAGDq
/PTgQb4X+/UmzE7sVfUJEz1mj6Eea9asskhHkeucBw8e0LYLAKbL8+fPc4LX
/ZFkvTu09FPrpo4gkUI91qxZ50NY8YI1z549o20aAEyRt2/fyrIS7oSMo56W
pq+AeWNO+E2gnmlWrn2e4/LSRNiwC4BPUZYeP8rHMEu/lL7sy11Y9W8CkrhM
On38CG3rAGBaPHz4sMBrDhb191OHXUZsWjuOeppBN6Id41xm3b9/n7aBADAV
Ghsbs0Nc/p0wkXpOmovUoXbBWPVvGjofwkrw39DU1ETbRgCYBCE+rrexdGgg
0mxyXDt1BFb9m4h288bJ8jMxIx2Amzeub41ie8+3Pcu3f4s55/2Wx6zR57Hq
3zRUGTtZ7PL3m+XltM0EAE2ePn2aGb3+2ZkVT884xWyYsMl5LCYr9lNRi0Yd
8sYQuqnocphDrNeKhoYG2pYCgA7k79MdBWlVsvltV1frdCTp734LxtwIsqee
lqavrSu/kGLVvylpv9e4gk3xKE4HrJPr11Ty5AVdYa7TryVLAlfYF26ww57n
feuCz+g4rPo3MWW6fl129QptYwEw3Dx9+jQrZn3TOc5HeU7UesV5a8jk0EVj
qiOwtqhX/TNuIm8OVv2bllThk0TenOfPn9O2FwDDyt6inFvb530a5l1S75on
WDz2sId9SyYmpfcsrPo3Qe32GLejQELbXgAMH99///32uMV/qVb1kedELy9w
0rxYomW2dXGoatGD/OeNPumPVf+mpcrYyckuU79Tq2mbDIDhQKPRZMX7/F/F
0r7DvEuXcmfyF4xRCjCb8WOJl47Y7Y5V/yanE37jNy6f++bNG9pWA8DolJ4o
+Ta7r5GWT/XnaafIdeOzVtk1JGM243sd2vhl5jpMWTQtZa0auXzqzI3z3U8q
TtK2GgDG5ffff8+JXvX6ovOA8lyng3Hf+C0YUxmM2Yx63Q2xC1mCVf+moqOC
8etnOHgu9dkRcrAk9kyoR8Qff/xB23AAGJE9hZLbsoF1zrvrcfEifyc72Ub7
ZsxmzPnq9SbHdVNHVGLVP22VRTgGLxizcuayDK8CRbzyeMIFIonP1sL87bQN
B4Cx+PnnnwtFSz97G7RvtV5xLghyFC4a81MkZjN+5TZzlDIUq/5pavO60cun
TI9cF3co+rQuyXUiwR7mGvPTTz/Rth0AQ8/bt2/z0oX/c3jxYMK8S3dkc30W
2R7j2bda92zG8IWjin0whE5H2vueMx3cF/GKgvZ3T/IuyYIPJkenouAFsDxu
3rheLP54Nehg9J/znGQPVvxy23/GWe9Gu1s4X2zZiCkuw62yKMewRaM5M5ak
8/KOxZ/vMcx1inFLvnXzFm3zATCUtLS0ZMV5/X5q+RDmuU7ns6cLFthe8rN/
Z5WzGc97j05wxhT0YZV0w2inqVPD18YejDrZR5LrtCfsSExwXGtrK20LAjBk
XL1y8XiG4bdB+1b9iWXha8blrLF7muJAPWCHWXWiCV5zsep/mHQ6YCJ3Fou7
0K0wUP7ZJO9SvHvalcvY1AVYCG/evMmMdX96xslIea7TvthvAhfY3g6xutmM
a6eMuB6FVf/GVXmUY9TiUSumLxR75ByNO9f/MCfaH3kiQhD1+vVr2kYEYAi4
dOFsqcRYnfPuenhwkf9y+10u9q82WdFsRt+5WPVvXBW52q6YOiVkVeT+yOMD
SvIuJXtknvv2PG0jAjBYSLckM8a1x30UjSHNJefN/o4Ri20fRllLAbtk7ap/
bIRuFH0bNNFj9viN8zdu8d9tWJLrdDDqZLggCjsAAHPn8sXzZ4alc95dFdvn
8BfZnvCy/yvL8m+SHtzwZdY6bIQ+xLoZ4yhaOtJp+vwUN8lAB1h6VIJ7+qUL
l2jbEQDDaW1tzRR5GHvkvEc1neUkuk9Mchr7r3gLn814J9hOuBSr/odSu9zG
rpz29yDnMHmEYvBJ3jmKfjzKP6alpYW2KQEwkBvlZYqM+caO7j5UmjFNsMD2
ikXPZnyZ5rBuGlb9D43Oh0z0mmO/fu66fN8dQ5Xk3Se6XLtaRtuUABjC27dv
s5N8608so5jnRP86vizUeVzeWrvnqRY7m9Ft5qgLoQ7Uw9CsVRHjmLh85PJp
cxNdNx0RnR3yMCcivf3YkHgsFwXmyN27d4vTFtEN8y7tif4mYMGYe6GWOZsx
bMHow1j1PwjJeXbO07724wTvDT9qjCTvUoxb0nfffUfbmgAMmK2SmKHarWVI
9GD/Qt9lY/e62r/eZGlbvuSv+GKrC6a4GKKLoQ4+bLu17FWbBUVGTXKdCgPl
WSnZtK0JwMB48uTJVhGF26B9S3PJOdt3UuQS28fRFjWb8ZzX6MRVmOIyYKWs
GOE0bU68a1pJ7JlhCHOdwtyiiTtoGxSAAVCyv6iyaC71AO9RN7bO8Vloe8rb
cmYz/ho73nuuLfV4NCMd9LJfPW2ywMl/t7Bk2JJcp2zvrXtke2kbFID+8p//
/Ccjcs2bS4YUIRoePT/jFOcyMZUztj7BQmYzrp3yZTlW/fdDV8IcfOeNXT1n
ZbbPtmFOcp2Oxp0T8iKamppo2xSAfnH54vnzucO9hsgAnUyb4rvAtizAvj3b
7DvqAvbo0wETqaeliWuT84jlU2fFbkw+PIwDLJ8q2T3j8qXLtG0KwOdpb2/P
TvL9wwhb4xpD/zy2NHilvXSdXZPYvGczJi0ZsccDt0R71WGfcWunT/JeJtgZ
WkwxyXXaE3YkPjyJOIW2WQH4DI8fP96RSHnO+UAli/gqeOGY74RmPJtx3/q/
Za/HlMUedDXCIXCerfMspyyvLV3FPakryj3u0aNHtM0KwGc4ckB2W2aid0L7
0I975wuW2B1ws3+TYZazGSsCx4Ytw6r/j5W9euTyKTOi1ycWx5w2dkQPSNk+
2/bukNM2KwB98ebNm01R619fNN07oX3o9QXnLMGkmKW2tTETqOfzQPUyzWH9
tBHU89N0pBCMXz/DgbfESxZ8kHp6fyrtXVGviFevXtG27DDQXF1V/gnVzbQv
C3yWysqK45lDWSR0+HVNOstnge23fPs2c5vNyJ0x6qIQq/6/KotwDF04ZuXM
pRme+aYzwPKp4t3TqqqqaFvW+DRXsW0+hVWFQDd5dkpTHx40lTX+BuvpGafY
jRPSV479PZFFPaX7r7CFo0v41j6Enr9utNPUaRFr4w5Gn6Ke2H1ra8CeAskW
2pY1Pho1x8aGLSnXtGma36OhfVngM7x48SIzclXrlVXUA3lIdDR5iu+CMeWB
ZjObcfOK/97mMpZ6otLSCb/xG2dOdF/ksT1oH/Ws7o+OxZ8P8QgnrqFt3AGQ
6G7fm3p9DpPnHFn1J//QrBBxuUIhV9t955TWahqrS4UcfV+ezRWV1zGZr6kW
cYQKZTFXd5wjqmrQb2hWq5Jz2Syms8+VqWp1B+vVCoHuHCxO10FgADdvlp/K
MoNp5/3Xk6NLgjj2hevtXojNoIBdKW9UslWu+i+PcgxbNGrFjMXpvM0kJKkH
df+V4J5efr2ctnEHAMntHp3y2TxniUvrG+rrOmnURnKznMMEL4eksqDqsUob
zSxBsVKlkImY7JY1dz6dIJDIi6VC5vFyEvTNahnzGFGpqlTMPKK4VtNcrTso
VKiUUoH2fGJV/bB9OBaGLD/p0SGzH2z5SK1XnAvDJocsHPNj+Djqid23HkeP
58+zulX/WzaMdpo6JWxN9IGoE9TzeaAqCj4gSc2hbdwBYFiecz8ZPRdXNZJI
ljEDMQ26R9Uo2Cxu16B6lYRlw3qf51x5dbfj0kb9b4Gwtu39SwgVPzCdeHFn
gmu0j2HLMU5vAE1NTVmRzn+pLGSw5SN9v3u+YMnYQ+52GhOezfhO4rh2ypc3
oq1l1f+ZwIlusya6LHDdFrCXejIbJkW80ryGXAzvnwuLq2uqdajV1fXakG2W
sW3YUvX7RzbXKotlYpGQw9L12/V5zraxkXZOh6kmvwHanNc+l9X9uczzZRzd
mIwe5izcagzVD5yKiluns2iWIjK2Xl7gpHs7xC6zfSIy3dmMfPaY0kDLX/V/
M8YxesmoFdMXpLpnD0lxT4pKcDOnWS4G53mP4+fd87y5prhz5Fwgkckl3Pfj
Ldo8VzfqHlatzXF9nn/wW6AtE8J02lkCqUwmZZDJ5TK5og55PnD2FUl+2r+Q
euoaW1fyZvIX2J4X2L81yQJ2iUtGynkWvupf5mrLmfaPkFUR+yOPU0/jwUvq
v6swfztt+/YXg/Oc/XFfuuOjPFdLtd1pRZ3+Xme5mPXZPCdP1h/tqBeRIJfe
YA7KuvK7WiERSRT1qAc1QFpaWtIj15vyhopDqD9PO0WtH5/pbPdnssnNZty7
1pJX/Z8Lnugxe/yGeRtIBlLP4aHSEdHZUK9wc6kTbUieN/crz2vk2rFvibK6
oaFOKRW8HyrpOc876kq190Y5YkVtfa2CuSFKHqM7yBbJa+rqyouZm6pCJeJ8
oPz000/7U5dST9rh1OGEf/jOH3Mr2LS2fLkZaBux3ALzvCLGUbR0pNO0eclu
meY+wPKpRB4p9+/fp23ifmFQ/7xaoB1v+UyedzSqRV3rjlgCGRPpilqNrnsv
6xo/l3P0/fYOTZVc2HWDVSiv0ugPiroOsgWyWgy2DJxTigMV29nUM3aYVXt4
ceAK+6KN9s1ppjKbsSnVYeP0kdTjd2i1233symnfBK4UysOPUc9eYyjLa8uR
4qO0TdwvDJl/PhCaGxsbmwcyIUXDPEPTw8FPjoL+kp0oeHZmBfWAHX61XnHe
EjI5dNGYBxGmMpvRZcbIS5ay6v9CqIM3e9y6uWvzfWXUU9d4kkco4sOSaJsY
AC0NDQ15MSupRytF3d05V7B47BGefUsm/dmMoQtGHxGY/aqiihjHJKeRy6fN
TeCml4i+pR65xpbQI+rp06e0rQxAx507d05a9EzF/ujlBY7YkyVaZvvPOMoF
7HKdvih0Ne9V//t4dqumfeW3InBP2BHqSTs8SnBPu337Nm0rA9Bx5ECRepe1
57lOF3Jm8BfYXhDYv6M3m/G0x8iU1ebaP78Y6sBn261hr8rlb6eescOpPIFs
T5GctpUB6MiM82o8a42D5z3q95PLItaOz1419mkKnQJ2D6PGC+abZf9czBm5
fOrsOBdxCdXinlRUHHM6KiCWtpWBtfPnn39uibOKaecD0v64b/wXjKkKthv+
PH8ncVwzZcTN6MnU87n/Ouhlv3raZJ/lfruEh6lHKy2F8aIxhA7ocu/evROZ
lr8s1AA9Ll7k72S308XuZfpwz2b0njP6jJms+r8S5uA3z3b1bE6291bqiUpX
CR5p3333HW1DA6vm9PHiyiLzqxY6PGq94pwfNDlssW1N1PjhzPOExSP3mcOq
/0znkcunzozdkFwcU0o9Tqkry2vLsZLjtA0NrJptkuj/q7CulaEDVVXRXP4i
W4WnfetwzWbcvfZvuRtMujZ0CX/c2umTvJbxd4Qcoh6kJqJdwsNp8Rm0DQ2s
l9bW1rTwtRZTkMh4+s95TrI7K9HJ9l/xwzGb8Ya/bZSTia76vxrhEDR/jPOs
5VleUlMu7klFITyz2cjFAJrra1SlxTKZTC4vVqmxEN/kePLkya4kzGzpr85J
pvPn2172szP2bMbnprrqP2fNKKepM6LWJxyKPk09PE1Q0bz4uro62rY2Bs1K
XQ2hDypCi2pQasKUqKysPJdjUQXmjK36E8vC1ozfvMbumZFnM7pMH3k5zIRW
/Sv8xm+Y4cBb4lUUfIB6bJqsEt03mdFe6P1HLdPunciRlNY36zY7bKtVMYXh
BApsfmg6nDp24LYMN0MHLHnsNwELxtwJMeLejMHzRx81jVX/ZVGOoQtHr5y5
dJNnnnkV9xx+Sby3Hj18jLat+yJ5wX/1pl6foysAyi3+aIClSsKx4Uh1+533
WMS5tlTM4YrEAu2zRYp7ChFHIJaKmcex2EJVbZ1Kv60uW6Ks0T2lx4rS2vMI
pPqapDYsgbi0saOjTikhJ+nchbejrU7JYXEU1j0IJMuLf3J0CfV4NEf9vH+h
3zK7Pa52rzYZZTZjttMX201g1X/ButHLp0wNXxt7MOok9bQ0fe0IOSRJMely
otrc7qm99ZHnmmq5dnPyqsbeHtBbEedqGVcfzGyWWPlY3lkWulguYemHbLhy
hVyozW+OmiRxQ88VpbvOIy1WSJifA2FpXVudgvn7QP/bUSUlxwU1Vhzn7e3t
aZGury9iMZGB0lxyzvV3jFhs+yh66GcznvQYKV4zgWKSn/Kf4DJzotsi98LA
fdRz0lx0NO6c0CeCOIu2uXvFgDzXxXVXQQpNXblUoisHR/6voq5N01sRZ22p
UBtWqb5i0QfFo5liRmwVc0oNc/7iGk1vFaU/PE+9WF9co1FXzIh5eK2QPEJc
PuQflxnx/PnzvFiE+WB1c9sc/kLbk172f2UN5U3SnyPH+S2g0z8vj3KMWDRq
xYxFaR65GGAZqMI9o4mzaJu7VwzJc7XUpltBCn1vvLPiRFVzr0WcmRzuqub8
QfEL5p9Edd1OqP+96Kmi9EfnkXeep06hLYehbOhoY84gt+beeUfHw4cPD6Uv
o56HFqCms5wEN1bKirH/Thiy2Yxtmcyq/5jhXvW/beOYFVOnCNdE7Y88QT0b
zVEiz+THjx/TNnevGJDnumEQzif15pgcZqubey3i3FVaTvfwD/P8/T915Xlv
FaV7PU9jlXaQRVFdrh2/6foDwUqpqKg4l4OboUOm0+lTfRfYqvzt27OHpqPu
NWf0maDhW/V/JnCi++wJLgtctgbspZ6K5qtk94zKykra5u4VQ/K8o54Z72YV
V38wPbFa2z1m+ue9FHEeaJ73VlG69/O0lWpvqLKYgfjqwX84Zs3Z04pbhVZX
Y86o+tfxZcJV4wrW2jWmDsFsRtHiUfs8h2OV6M0Yx5glI52mL0hxl1hecc9h
Vqan9NTxU7TN3SsG5XlHW71SN/7BFUlLVSqlQi7Uz0bX3oLsrYjzQPO8t4rS
fZynsUqqm/SitPLeeUfHgR3ZPx/ATlxDr52RXwcuGKMWDnY2447VX2w2/qp/
mavtyql/D1oVvi9CQT0MLUDbAvYW5m2nbe5eMSzPCZp6tVTYfUkRSyhV1Ok7
5T0Xce5W+rnj4zzv9k+aGu38GTnp/PdSUfqj88i7F6Fu094JteHIsbCpID30
91PLqaefReq+fIHfMrt9XLvXmwzf8uW6v220kxGnoJ8LnsibPW7DvA1Sv13U
Y9BitD/yeHKUmLa5e8WQ+efdadM0MqWae1hGNERFnAdWUbqxnPwCiNA77+hI
DV+PnVuMp9cXnCW+k6KWjPmfGANnMz5NdnCdYZRV/xUxjnHLRi6fNi+Jm3FE
dJZ6BlqSjsadC/EKo21uK6CtTi7WTYMR1Fj9ItXm5ubsaIS50XVdOpu/0LbU
x77NoNmMG6ePVIVPGtow3+th5zzt64CVofLwY9TTzyIVyot49eoVbYtbOm11
YmYhUrG6gfal0Oe3337bnsChHnfWoOdnnOJcJog5Y39LZA00z4Pmjzk2dKv+
L4Q6eLPt1s1dkyeQUQ89C1aUZxzxF22LAyvi8ePH+8WYfD58Op46xXfBmOuB
A5vNmLnsb0XcIVhVVBHjmOI0cvlUdoJreonoW+qJZ9mK80x5+PAhbYsDK0Kt
Vp/MwuSWYdWTo0uCV47bss6uSdzf2YwK7gjxmsH2z/fx7FZN+0qwInBP2BHq
WWcNSvbIuHv3Lm2LAyuirKzs0ubZ1CPOClUU/nXwwjHfh/VrNuODyHH+Cw0v
PHcpzMGXPXbNHOdc/nbqKWc9SnGTXL9+nbbFgRVx7szxiu1YTERHP+6d77vE
7pC73ZuMz8xmZFb9f3nLoFX/aZwRy6fOjnNJPRx7hnrEWZUyePlnz5yjbXFg
RZwo2aPeNZ96slmtXl9wzvBxiFlq+0vshL4j3Wv26LPBrAEl+SEf+zXTHX2W
++4KLaYeblYo8tdQycEjtC0OrIjDewse7MP4OWWp8mfxF9qe49u/7b2AXezi
kfv7ver/SphDwDzbVbNWSLy3Uo81q9UW/907C3fTtrhRaK6rVpWre90JHVBi
z7a0/zm8mHqgQU/POMVumJDhPPaPpJ5nM8pWfZG3oV9D6FmrRjpNmxmzIak4
ppR6plmzZMEH8zKltC1uFNTashGsKqyuNzG258T86zjmK5qKjiT9w2/BmBtB
dp/muUowJobzmSkuRwXj181w8FrqsyPkIPU0g/aEHclIyKJtcaPAbEXOUSPP
TYz8tCDSM6SeY1CXfi1ZErTCvnD92P+kfVDA7vfEidxZo3tL8rIIx+D5Y5xn
Lc/0kirildSjDCKSRyiSo010CxfvGf/Vm/rz9O553lutTzZXWyVUd1hcXKVf
i99cKxdxdZs0stgcqb5gaLNCyBFI5boqct1rj4IBkZ3IbzqH9aGmpdYrzoXC
r0IXjbkfMa57pG+YNqLHVf+5a0Ytnzo9cn38oejT1EMM6tKBqBNxwkTaFu8Z
kts9dgwGnOe91vrU7cHIKVap5CJdrc9a7aaIzGGxvFRZKteFt7K+reu4DVdc
rJAxcc8ux+j8wMkUef7nPPLcFKXeNU+weOxhDztN52zGoHmjFb4fDLko/MZv
nMnyWOxZFLSfenxBH6k45nR0YCxti/fMUOV577U+ucwmt91rhsqaNTViNktc
qqsvpy8YyhSY0z1AqtuBRVfYTorbrQNnU4z7qwsrqWcX1KNeXuCkezvELbd9
ItLOZsxY9jeZm37Vf1mUY9ii0ZwZS9J5eSjuaZoqEX0bxo+gbfGeGbL+eUdv
tT7ZNixpVyJrty7Xl/7UVKsUUrFI0DlEo89z7WbmnaWFmD4/8twAxBEuby6h
GLRJ61LuTP4CW6XA7ojriHRm1b90w2inqVPD18YejDpJPbWg3qSIVwZ7Cmlb
vGcMyPPGOrWqXL8lrS7PSbe8z1qf0q77pdXakkNcdXO9WD90zhGKZTJmHKZb
nncWp9CoOchzg0gJw+bnZqA/TztFrpsQvWikz9zRrrMmchdyCwPl1PMK6lvk
76YgXihti/eMAXmu0o6OS3QRzcxX1Pa3e6/1qQ98Bo1CQDJc+ptaO8AiUurH
W5qrpL3lORt5bhCzZ82dNWsJZBaaMnXBWLup//jHMvasNQvnrF8614Uz323t
PJ7LfC+P+QK/paFC59i49eI095xc/vbtQfv3RR4/FoehGGo6GnfOkvrnNcXa
IXGBVKFSMHWhOXINOdhrrU8uM/YiUdfVqmQCXaXmtvpS7TGxorahoaZczvp4
vAV5Pli8+DFJudXJeQ8gc1G8RB2zqSIipSw04VJg7Le+Ece9Qw97BOx1893u
6p23zj191fq45c7CRUv4c+a6TJu+cuaMVXP1+b+RM4+7ep7HxnmeJP99l4aE
royJXZ+a6paT47ONdPjl4ceQ/0Ob5yHeJlqiyJDx87Y6qX6moTaelbqiob3V
+tT2z1mdY+Q2XImS6ao3l4q5XQVGRVIJWzvcru5xvEVWjdntA8bHT5SY8wP1
jIKMp/js72I2VUak9jf/Z0xfSfr/C+asQ/4PPs9DvcNpW7xnDJ5/3txT2dBP
a31qx8/Z2g58s7aU6AcPb2NOobH62nDGwDcwPiH7e+qZA5mOuvJfmHg5KPas
X+QJn9ASXqDc3a+I5P96902rN8Y7rRIuWiZgz3Ptnv9L2BtWzHVdNdd9w1ye
+zwf/pLgEE50zLrkVK4k23vb1oC9e8OPHomzoiqlR0RnQ31MNM+NjXaAvdv8
FjA8BAQnkr/fqWcIZL4i/YHYjKrI1Ov9zP/p01bOmblq/uy1Fp//h2PPRPhF
07Y4HWpLxRyhAiMmw0xIuFiUeYd6JkDWow/yX3TOL/Kkj7CEF7TP3V/G5edv
8Mgg+b9iVdjiZb5z53Gnz3Duyv/Fc9Y7sV1WzXVbz+Zx53nzlwQFc6Ki1yYl
u2ZleW3Z6r9nt/BIiSnt8X4w6qTJrg8FFkm0KDM67RZ1j0NQb0rIIfl/O1Jc
3u/858ye4Txv1hrq+S8PPyaOTadtcWBFpIjzI1LKqHsWgoZKXfkflnQlWHTe
P+oUP+yIZ9B+D/8dXH7BRl7mGpcEzurwJct95853mzFjVVf+L5q9bvmcjc5s
13Vsd+5cL59FgUErIqPWJCa5ZmZ5SqX+u3YJDw+oxtOu0OKs5GzaFgdWRFbO
dtLtoe5BCKKlxJwfRJl3osQ3+pn/06aumD3ded7Mz+f/Zr6sIGsLbYsDK2JL
4V7Shql7CoLMRd3yXxUcd94/+jQ/7Khn8AGPgJ1uAulGz6w1rkmc1RFLlvvN
mrM+LjaVtsWBFbFv/xG/yJPUPQJBlie/yBP7DqB+KBg+Tpee9Q4ppt7yIcjy
RJxVWnqWtsWBFVFeXu4RsId6y4cgyxNxFvEXbYsPIc3V5Sp13QeLhDT11SqV
urH3xZ7NdWpVVW3Xv2va+r8utK22qlxd++GapLZGtUpVXd99YntzdVW5SlVe
r9E+vqp2sGuYPrpg8+LevXuegUXUWz4EWZ48A4qIv2hbfOhormLZ2LAkVd2P
fbYwdJVYW4+ICdkGOdeG/eHT+3497faLHz3+42toLhUxW8oIFY0djRLtpjCD
/QFVazcbk5jpytaamhrvQCn1lg9BlievgALiL9oWHzqYbbI4XbtmMXy2MHRb
c31tXYO2u9umZnbfqu71oZ+8nrz7Jl09XEOzQshs9Cgt13WnG+vIS2n6ff6e
qZFzdCWWzJH6+nov/wzqLR+CLE/e/hnEX7Qt3jNrZ7r2pl6fw2Qpu7c811SL
OEKFsli3fyKbI6piUrxz4X9zsUC/rSJHVEoyt16t0NUP/bD6c1u1QsJmetwC
sUTwycvpr0H7o0BOqH2cQNb1ANJX54gUNX1Ul26uVeqrKLFFxcUSDkdcq/ng
OIsrEnL0JTkIdeVybtdFdpWuFnEE2krXbKaktVBVW6fSbxTMligp/3y/fPnS
U5BAveVDkOWJx49/9eoVXYP3BsntHtdADSLP1bqSzgKJvFgqtOncIL1aqitU
1FYlZw6yBXJldRNTOdSGLVSolFImlsUq7Q9fvUrMhKqkVKkvEM3puX9eWszs
0iuQd+/tN8tY5KXUvVaXbtZdIUdeqpQK9bXxtCNF74+X6i5GVzKvXiXR//wo
9bv8di9pTd5nsVzSuX0wV66QC7VXxFEP9u+DweItiE3M/ZF644cgSxLxlBc/
hrK3e8dIec7tDFimMLR2f0Wm8BzT3W2r4WqTkvRgNUwnXtz5p4tGm5BseTOz
C7oNS6KrCt1Rr2T1lOfv908njxUqusVn1ybqPVeXZkpvsEr1pZSamUIc2iuv
Yf5y6Cyx1CjV98+Z3GaJ9bWUOhqYQkzkmnUn118kU56JrWJG23XlrYtrKAd6
VGxGdDq2cIGgoVTMpopoUSZda/eBIXne3Of4ua6oUGcRCu1xVlchUSbP3/8c
MJGoHZPR01nVqF5so+tg619P1sv4uQ1TEUkp4TA3Qms/eXzP1aU/KmlapxDq
rvzj0tW6K2+rEWpj+/2rMz8H7KrmD66KefsiXeY3M3lOvazS5vydIfEXqLd/
CLIkBcedz8vfSdfafWBInrfVCvVj1+9hCj0zoxYfFonrivEe85zp+gqkMpmU
QSaXy+SKupfa83efuyJnd493Bt1JJOW66xExnfSuLveHef5xdemP87y0e56/
vwHamecfXYzunX6a5++fayJ5fkxx2kdYQr39Q5AliXhKcbyUrrX7wJA814+H
dA1BdHSOQgi107U/m+e67j1zK1N7Hrasa2CiWiERSRT1bcxxTme0aqq5vdwP
7fobQVMjZxJdd0m95rnuwpj6pyylfpSHKVGty3NmHEalH+XpUAr14y3Mxcg7
c76NeTwz3mLaeV5RUcEL2Em9/UOQJYkXsIM4i661+8CgPO+o1k1SYQuLS1Xl
KoVIdx9RN8Pks3neUS/WDoiLFOU1v2j7xjZskbymrq68mOllC5XkN6FWOwZi
w5GU1tZ1FpTusX/e7SAzgm3DFqs+m+cdjVXM9XKLVSq5vugp85dFQzmbuZqq
WnIxwq77obpxdW316vpaXalr8iptJp/njx498grIo97+IciSRDxFnEXX2n1g
WJ6TcFTJhF01oZlZHkp9fn1YxLlaztHN+uv6D9LFLZfoBr+ljR2aKrmo6yRs
gaxW03l+aee8RrZ2BuHH89WZ+6HcD6a11EuYbJbX/CbvfbxFd2Ft9eVCfZAL
BMzCJF1vvb5K/r6otU3X3wiacpmw6yK54lLmnX6Y5+/fnf6PBTntMtbPnj3z
8hNTb/8QZEny9hM/ffqUrrX7wJD55+/RNDYaWNO5TaN5/yyNrrj0xxNC2pjj
Qz5NRFNbKhDKutYDqEQ2H1Y41fR0LfqL7OG4qdLe3q6dspjzA3ULQJBlKCHn
ex8/EXEWbXOD9+gH20k/W6mUMUNFbEm5me7T0jcpaQVhSSrqLoAgyxBxU2pa
AW1bg4+pVb1f7ymWl5tPp3tgHCo+Jgg/Rt0FEGQZEoQriKdo2xpYKcwUFxl1
F0CQZcjEJ7cAy+bXX3/18s+m7gIIsgx5B2Q/efKEtq2BldLa2urJj03afJ+6
ESDI3EV85MkXtbS00LY1sF4SknMjUsqoewGCzF0RqWXxSTm0DQ2smuKS4/yw
o9S9AEHmLuIj4ibahgZWjbbwXMB26l6AIHMX8dHdu3dpGxpYNX/++aenbyp1
L0CQuYv4iLiJtqGBtRMUmizKvEPdDhBkviIOIj6ibWUj0VxdrlLXfbDflKa+
WqVSN/a+zLK5Tq2qqn2/xL+t/ysy22qrytW1PWxv1Vxfo1QUy2QyeXFpVU3D
B8/pxx4EA7kGM2bHrgP+UaeoOwKCzFfEQcRHtK1sHJqrWB9uCd6h3d5Qu4Vu
Ve97UFVpK8iJmVBukHNt2B8+ve/X0xYW+uTxtaVimw9hS1S6gNaWq/tgS5ZP
Geg1mDFVVVU8DKFD0CBEHFRZWUnbysZB02d9ol5oa66vrWMqQ7ep2Z/ul9jn
68l7qE+k3RTdRiCva2YivK1RV6VIt31iDbN7bV+r+Ad8DWbMH3/84eWLjRYh
yHARB5nF4Pnshf69qdfnfKZ+aLWII1Qoi7n6zW5FVUyKk+40Odzc0VzcuQ8u
R1RKIrderRB0bqUiU3XVjGurVkjYzIa8ArFE8Gk9i+aq9/WJ9EfUIq5AWaup
Veg34GWxRdWajsbqUiFHvwkumysqryOv2b9r0NTKRFx9uWiBRPcuzJTQiFTU
EoUgw0S8ExYppm3ifkFyu8e3MIg8V3fWvZcXS3VVIeQkM6uluipvbVVyoW6v
c7myuokp/WDDFipUSql2I3IbsUq7ka12wISEK1dSqpTrzvZxPYuOBilbF8BC
uUJVXVvf1RtvqC5lNk3kSOSl9b9pa4basATFSpVCxuS8dpfy/lxDWylTuUKq
UCoVEuYkfQ/gmDSHS477hKL2HAQZIh9hyWEzmXlupDzvqjRRRbKQScL3FXza
arSlRmU15KFMJ17cuRW5RpvdbLm+xBtLor/BWa9k9ZDnpJddIxNyug2fs8TF
al0fukbO0Y23aGoUbBa3a1SfuZh+XkOj9veCLdHV12ioKpbISuvNtof+4MED
nt9m6r6AIHOUp18ecRBtE/cLQ/K8uc/xc11Zt676RLqqyr3Ug5ZxdGMyenT1
f6o19WKb7gWgPywz9CFtmsba6vJiqb5unFBR2/Fh9beO5lplsUwsEnL0Qyf9
vAZdOVHduI1Aqig35+GWDo1G4yWIS8qtpm4NCDIvEdcQ7xAH0TZxvzAkz5mS
9+wPbyYy6cdU4fxs/dBuWartDLMEUplMyiCTy2VyRd1L7fm7zZ9plrO7x7uW
RnUxhyOq6f4Za2q0YyiC0u4v2lxT3DlyLpDI5BKujb4q3GevQdctr1ZJRYLO
snrCGnOO9Nw8WZDoHHV3QJB5ibiGeIe2ffuLIXmuHw8R170/0sBUYxZq55d/
Ns913XvtzwFzHvb7iSjVColIoqhvY45zOjvYzFSWj/rnjVUSpjde0+1YnXbM
XaTqelFNZ5FoRZ0+iMvFLH2ef/4aGopFXHGp/i3WKrXnpl7ieTDcqqjg+RdS
dwcEmZeIa26Zz57nBuV5R7VugghbWFyqKlcpmPuPJB6ZyP1snnfUi7UD4iJF
ec0vpdo+NVskr6mrKy9m7lcKlSR8axVC5o5maW1dtYzb0/1QXW+cHBdKS1Uq
Zalc142WMLdTmRhnSxXl95gxE4myuqGhTqkvMK0dS+nHNTA5b8ORl1fX1VXL
tdWj2eVmHOcdL1684PHjsXcuBPVfxC/ENcQ7tO3bXwzLc5KnKpmwcyBCN5tF
qU87ZihD1jV+3ln4vus/OjrayiW6YWppY4emSi7qOglbIKvVdJ5f2jmnkK0d
+e5hrnhjtUQ/y1D/OKlS311vqJLpDslvV4i6HsISyJhzKrSv8flr0NSpBO/f
IUuqrP34AswNcXpBaMIl6h6BIHORMPGyeJOUtnEHgCHzz9+jaWTox9r6j2nT
aN4/S9OsPUvzx3cc2pjjfd+HIOdhLqH540toa+t6Ae1ZmntY6dSfa2hmDpvH
vZDPUVZW7hmwg7pHIMhcxPOXXbt2nbZxAeiBpqYm7ZALZrlAUD+kG2whrqFt
XAB6Jiu7MFh0nrpTIMj0FRx3PlOyjbZlAegV7d5c/lupOwWCTF88/20WuwcX
sAhevXrl7RufmPMDdbNAkCmLeMTbL4H4hbZlAeiLHbsOCMIV1P0CQaYs4hGL
3fAcWBCPHj3i+WZR9wsEmbKIR4hTaJsVgM/Q3t4eFimOEt+gbhkIMk1Fpd0U
RqQSp9A2KwCf58LFy56Bu6m7BoJMU8QdyguXaNsUgH7x4sULT0F8Qs731I0D
QaamxJwfePw4M1rjD8COXQf4YUepeweCTE2C8GO4EwrMi19++cWDn0bdOxBk
aiK+IO6gbVAABkZiSq4w8TJ1+0CQ6Yg4gviCtjUBGDB37971EKAIHQS9l4fv
ZuIL2tYEYMC8ffs2NCI1UlxO3UQQZAoiXiCOIL6gbU0ADOFa2XWe/zbqPoIg
UxDxwtVrZbRNCYCBtLS0+AUlxmZUUbcSBNFVbMZtv6Ak4gjapgTAcM6dv4Ai
FxDE85edPaekbUcABsXr168FAQnookPWLNI5Jy4gXqBtRwAGC+mi8wJk1D0F
QbRE2j9xAW0jAjAEkG6JbyC66JCVirR80v7ROQcWg/LCJV7AdurOgqDhF2n5
2H0LWBItLS1BwhTMRYesTaTNk5aPaS3Awrh5q8Idy0UhKxNp86Tl0zYfAEPM
27dvo0UZ2NEFsh6R1k7aPBaEAovk/v377j6bqLsMgoZH7vxNpM3Tth0AxiI3
r8gX1aIhK5Ag/Bhp7bQNB4AR+f3333n8hPjs76jbDYKMJ9LCSTsnrZ224QAw
LgrFac/AndQdB0HGEy9g5zHFKdpWA8DovHnzJkiYHJl6nbrpIMgYIm07OCyV
tHPaVgNgOFB/952bz6akzfepWw+ChlakVZO2TVo4bZMBMHwUSHfyhSXU3QdB
QyvSqknbpm0vAIaVZ8+eefslxGbcpm5ACBoqiTLv+PglkrZN214ADDdXr5a5
8XOpexCChkpu/ByV6hplXwFAg3fv3mVKtmI6OmQZIi2ZtGfSqmkbCwA6NDQ0
kL9PYzZVUjcjBA1GsRlV3r4JpD3TthQANLl27bo7P4e6HyFoMCJtmLRk2mYC
gDLt7e2b84t8hIeoWxKCDBNpvfkFO0hLpm0mAOjz4sWLwJDk8JRr1I0JQQMV
abek9ZI2TNtGAJgKDx48cPNOScj5nro9Iaj/Ii2WtFtsogjAR5QcOeHhV0jd
oRDUf3n4Fx45epK2dQAwOdra2sTpeYLwo9RNCkH9kW/40bRN+aTd0rYOAKbI
8+fP/YMxkA6ZgUgrDQhOJi2WtmkAMF1+/vlnN++keImaumEhqDeR9unmnUza
Km27AGDqnD2rdOPnYPdFyDSl3UGRn01aKW2jAGAGtLe3b5ft5QXsoO5cCPpU
pGWS9onZ5gD0k5aWlsTkHN8IbO0CmZZImyQtk7RP2hYBwJx49uxZUGiKMPEy
dQtDkE6kNZI2ie1wATCAJ0+eeAoSosQ3qBsZgkg79BIk/Prrr7RtAYC58v0P
P7h5J4ky71C3M2TNIi2QtEPSGmkbAgDzRqW6xvVOx1YAEC2RtkdaIGmHdI0A
gGVwTHHKJ7gwKbeaurUha1Ni7o9cvuT4iVLaJgDAQmhvb9+3/7CbIA+T0qHh
FDPVPG/fgRLMTgRgCHn37t122V53v63UPQ5Zj0h7K9ohRwk5AIacv/76K69A
5ht2kLrNIWsQz192+MgZ0upoN3wALJPW1tbcvO3EaNTNDlm2eP5Fm/OLSHuj
3eQBsGSIxXI2F67mplO3PGSp8vAvyt28HWEOwDBA/gROTs3a4JlL3fiQ5Wmd
h4SEOVb0AzBsvHv3Ll+6w8NvG2a8QEMl0pZcvHLzCmS0WzcAVkdbW9t22V7t
JEbMS4cGLdKK3AX5pEWh3hAAVCC9dPm+4qDoAwnZWD0KGS7SfgIi5KQtYWoi
ABRpb28/pjjF9UrDHi+QYSIth+udplCcwqIhAEyBq1fL3LyTotJuUg8HyLwU
nXaLtBzSfmg3YQDAe77/4Qcv30Tslw71X6S1kDaDXRMBMEF+/fXXwNBkVDWC
+iPSTkhrwX7mAJgsz58/T0zJQe1RqG95Bu5MTM4hrYV2gwUA9EVLS4t2HiM/
N16ipp4bkKkpLuseaRuF2/dgxRAAZkF7e/u33553804KT7lGPUAg0xFpD6RV
nD2rxFQWAMyLmpoav6AkQfhR6jECmYIE4cdIe/j5559pN0wAgCE8f/48bVM+
z78Q5eqsWQnZ33v4bUtJ2/zs2TPaTRIAYDh//fXXkWMnuV7JGHuxTjFjLClH
FaewkzkAlsGDBw8CQ5J9Qg9RjxdoOMUXlpDvnXz7tBsgAGAoefHixeb8Ind+
TsymSuo5Axlb5Ft242eTb5x877SbHgBg6Glvby8rK/fxS/QNx5ojSxb5fr19
E8h3jXksAFg2DQ0NmZKt7oLNsRm3qScPNLSKzagi32xG1hbyLdNuaACA4eDd
u3dXr5Z5+yXwhSWoiGEZIt8j+TbJd6pSXcO2twBYG8+ePSuQ7nTz2RSRWkY9
jqDBKDL1OvkeybeJGYkAWDPq774LFqZ4Bu6Mz/6Oei5BAxX51ngBO8g3eE+t
pt2UAAD0efPmjUJxmsdPEIQfox5QUP/lG64g35ri+OnXr1/TbkQAABPi999/
z80rcudvwibqpi/yHbnzM8j3Rb412g0HAGCiPHjwIFqU4S7YHCkup55a0Kci
3wv5dmLiMu/fv0+7sQAATJ23b9/evFURLEzx8NuGOY2mo9iMKl7A9iBhCvl2
yHdEu5kAAMyGlpaWCxcv+wYm8vxlJEmop5k1S5vk/kW+gQnKC5ewbzkAwDDe
vHlz7vwFQUACyRP01akkuWfADvL5k28BNz0BAIOHJAnJE7+gRA//QoyrD4/I
58zz30Y+cyQ5AGDI0Wg0V6+VhUakevhuxhwY44l8th6CzeRzvlZ2HaMrAADj
8fbt23v37iWm5Hrw0wXhx1ApY6hEPkl+2FEPfhr5bMknjDueAIBh45dfftmx
64CnIN4zcFdU2k3qeWi+ihLf8AzcTT5J8nmST5X2FwsAsFJevHhxXnkxNCKV
55slCFckZKO73l+RDjn5xMjnFhYpVl64hI3KAQCmQHt7+6NHj3buPugliOP5
FwaLziflVlMPTNMU+WTI5+Pht9XbV9shJ58bdikHAJggr169qqiszMwu5PHj
ef5FwsTL2I9XH+Ob75NPgxcgI59MVnZhZVUVZq0AAMyCpqamsrLy1LR8D594
D//CoNizibk/Ug/V4Rd51+S9k79ZSIynphdcu3adfDK0vxwAADAEEl+3Kio2
5+/wEsR5+uf7CEui029Rj1lji7xH8k7J+/X2jc/Nk5G/WTA8DgCwGDQazf37
9w+XHA+LFPMEKZ4BMv+oU5a05pS8F/KOyPsi7468R/JOyfsl75r2Bw8AAEbk
zz//rKio2LHzQFBosqc22wsF4cciUsvMa7CdXC25ZnLlngHbSYaT90LeEXlf
5N3R/oABAIACDQ0Nd+/ePXRYEZ+Uw/OJ9fTL4gXsFIQrwpOvmtpiJXI9YUkq
EuDkCsl1evJjyTWTKyfXj/rLAADQndbW1idPnty6detQ8bHUtAIfP5GXb6pX
QB7JTx9hSXDc+ZhNFcNzX5W8CnmtkHgleV3y6uQavPzE5HpS0grItZFOOLlO
crW0PzAAADAP2tvbnz179vDhQ5KfiuOlefk7I2MzvAWxnoIEb/8Mr4ACz4Ai
j4A93iHFfpEngkXnhYmXI1LKotNuiTLvxEvUCdnfJ+b8oJsJT/43+W9yhBwn
/0oeQx5JHk9+I/wiT5IzkPOQs5FzevlnkPN78WOiRZnkFY8pTpNXJ9dArgQT
xQEAYGh5+fJlfX19TU3NvXv3ysvLz5w5t+/AkS3b9mZlb08W58fEZYWEi/2D
E30D47U9fH4MzyfKkx9N/pscCQhOJP9Ksjo5NS8rZ7t02x7y3NOlZ69fv07O
Rs5JzkzOT/stAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAABg0vz/iVOlzA==
            "], {{0, 362}, {496, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{496, 362},
          PlotRange->{{0, 496}, {0, 362}}]], "ExerciseOutput",
         ImageSize->{500, 362},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6541b7d4-1add-459b-bcfe-0e8907c326b2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvWdck9m+981z32+el8/L+7w4s8eGYAnizOxt19gbRuxCgFASOoRO6AQE
AghERWKNDVFjw1FjiyIqYMkUdAb1MCP73pspqODGEhgUnpUrAVEBIRBWyu/7
+Z1z5lwmV64k6/fLYl1rrf8Ir9BVgv9lY2MT8f+S/7XKM4YdHu4pWv3/kf9n
bUiEv28I32dJSCTflx8+xet/k4MB/4+NzQvyP9r/7gAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwJDy6tWrf//73w8fPlSr
1eXl5efOnCrZt2O3NHNrRnxuUlhGtF9yiLvId12096ooL+dI3soI3opwd6cI
jxXR3qvj/Tcmh3ikR/IlccFbNon2bJEc2b/z7OkTV69evXv3LjlnfX39y5cv
ab9FAACwNJqamh4/fnzr1q2TRw/tyEvPigkgKR3rsUTMmyvxmJbn5rjN1W63
+9iD3vbH/SacDph4Lph1UehwNWLSjWjHmzGTb8VMrojVqjJ2cpXoq5vRk8si
HVXhky4JHS6EOpQGTjwmGE+eu9vdrtDVtsBtUpbHtFTePJHHkkgeJy3cR5Yr
Pq0oqaioePTo0bNnz969e0f78wAAAPOgra3tX//6V1VV1fa8zLQofxLdcR4L
MzxmbOFO2OepTWwSwiSlSTIbW+Qn4ErYpBN+E/Z62EldJ5CcT+ItjPZauTkl
QnFIXllZ+eTJk5aWFtofGAAAmBB//vmnWq0+c+yQLC0inb9ihy/7rJ9D8Iz/
U7B+DOlOD0N091/kp+RM0ETyy1LAZaV5zI72WCaJC1Yc3k+un7wL2h8kAABQ
4Pnz5/fu3VPIi7KFblsFC075Tb4TYvfvhIlvJZM7cr4iKuWNSl49gXqAf1bn
Qlhynt1mt68SPObH+2/cLyu4ffv206dPaX/AAABgRFpaWu7fv3+6ZF9etM9m
n4Unfb/6Xmj/n7RJugD/SI+jxwvmj6Ue1wNSWaRjsc+4PO6kePcFKULPowf3
kPeLMRkAgMXQ3Nx89+7dg9skGb6cYsGUe6F2z1Iceszw7noncVwz5csb0Y7U
U9owXRI67PO0z3KfEu25YkfepoqKisbGRtpfBQAAGEJTU1N52dWdmaIsnyWk
K/5z5Li/siZ/Nsa7y4c9ujRwIvVkHqRuxkw+Khifz50kcl+Ulxp943rZixcv
aH85AADweVpaWtRq9d7NKdk+i5V+E38VTXgnGViMdylh8Ug5z456IA+hTvpP
yOc6xHos2ZqZWFVZ+fr1a9pfFwAAfEx7e/ujR4+OyYsy/ZyPCb5+FD3e4Bjv
0u61f8tZb089hIdcFbGTFb7jN7s5xng6Hdi57fHjx+TTo/0FAgCAdnj82uWL
uRG8PfwZ90LtNBmOg4zxLt3wt41YPo56/BpPN6Id93nai91mpgi9Ll1QNjU1
0f4yAQBWyj//+U/FPlmWYPk5P9bz1M/f4hyomlIdNk4fST11h0EXQh22uU2M
8VhKuutPnjyh/cUCAKyFtra2e3fvFqVHbfWZczvYrjVzyDrkn8p1xqjLYQ7U
83Z4dDN68j6eXSJ3dk5SxN27d8nnTPurBgBYLK2trbfKr+eEexwR/P2X2AnG
i/EuhSwYfVQwnnrSDrNO+k+QcP+eHOJx/do1TF8HAAwtGo2m7MolSYjLccHk
P5NZw5DkOmU7fVHoamarioZKylBWDtcxzm/9ReU5zIQBAAyeV69eXT5/Jitw
bamvgzEGyfvWSY+Rqautrn/eXVfCJhVwWXH81cqzpW/evKHdHAAAZklra2vZ
lYtZAWuUfhN7W5VvbP0cOc53gZX2z7vrWsSkAldWvO861eWLGIEBAPSfd+/e
3amqzAn3OCGY9EJMJ8l1Ylb9jzC1XRZp6XKYQ67rpMRA1xvXr799+5Z2MwEA
mDo//fSTNCH4IP+bP5KGb5y8D3nPGX0myOxX/Q+hLoY6SLhfp0cH/Pzzz7Qb
CwDARPnjjz/25KXJvKb/KhqOuSv9VNziUfs8LXCV6CB10n9Ckuv0os2bfvvt
N9oNBwBgQrS0tChLj2f7LPlOOI56gH+kXWu+yN2APO9BlbGT93uNi/NYdPJo
MW6VAgAI1T/+mBvhecaX9WboluoPoa7720Y5WfKq/0HqZvRkKXdiUrDb999/
T7spAQCo8ezZM7k0U+Y17d8JE6nndm96nurgOsMqVv0PRmeDWSkuU2X5mSiN
BIC10d7efut6WbYf506IfXv2YDdCNLZcpo+8EjaJemaauCpjJ+/1HBfnvaLs
6hVs2AiAlUC65bs3i/d5f0NrVvlAFTx/9DHrW/VvmK5GTErf+LU0M6mhoYF2
QwMAGJfKmzey/Z3vhJjcfc8+JHH6WxHXlnpUmpH2eY2L9XIqL7uGjjoAFklT
U9Pegoy93n9vHPZl+4PUcbeR4jXonw9MV8Impbt8XZibhvJ2AFgYNTU12SEb
K82qW96lB5Hj/BZi1b8h2s0blxCw8cGDB7QbIABgCHj79q2y9HiB15x6E57E
0rfaMh3XThlxMwar/g3R2WBWnMusk0cP//XXX7QbIwDAcBobG3dIko74OLYY
s+rEMMhz9uhvserfUN2Idsx1nZSbEv3s2TPaTRIAYAgP7t/PDt5wO3Q89TQe
vOIWj9qPVf+D00Hv8fG+62pqamg3TADAwFBdOCf1mvNboknsqTV47Vj9Rd4G
O+qRaO46G8wSubIvnv8W814AMAtaW1tLdhfKvb/RmOT6fcN0zc82ZgWmuAyB
yiId0zZ+vWtrrkajod1UAQB90dTUtD099ltfh3cSU1/1OSA9TXbgzhxFPQwt
Q5Wxk7e5TcxKCHv+/DntBgsA6Jm6urqcMHfLGDD/VBumjVSFY9X/kGm/17ik
IC5pM7SbLQDgY374Tp3ru8ykti4fWgXNG33MF0MuQ6mT/hNiecvU9+7SbrwA
gPfcul6W7zXH7BZ+DkiZy7+UcbGqaIh1MdQh3nW26vJF2k0YAKDl0tnSbbxp
zWayuZbBUnBHpGPVvxFUFumYtHHqmRPHMOkFAIq8e/fuVMn+3Z4WNZWlN90P
tw9YhCmLRtGNaO2kl8P7dqHMNAC02L0le6/HpLYsi5rK0pvaMh3XTPnyFlb9
G0fkg83c6HhWcRDbAgAwzBDT7S3I3OViBtUohlCes0adDWZRjz5LVWXs5Hyu
g6wgq7W1lXYDB8Ba0IX5GV8LWfvZf8UsGnnAC6v+jas8F9b2zZsQ6QAMA7ow
LxVYXZgTbXf+73ys+je+8l0nFuakIdIBMCokzOVbJNYZ5kQqwZhYDqa4DIfy
XCZsSoik3d4BsFh0YX7aWsOc6PfEie6zR1PPOisRf86XsoKstrY22g0fAEvj
3bt3B4ryysPohypdbZg28moEVv0Pk3JcHPYWSUnbo938AbAoThySl/hMtqrZ
LD0qYN5oBVb9D5cqYydnbHQ8vG8XlhoBMFRc/Pb0Hq+/W8k8876VvuxLmRtW
/Q+fKmInp7t8fepYCW0TAGAJVJRf3+Y53RpWgPZHR1xGpK9F/3xYdTN6cuKG
KWVXL9O2AgDmTfWPP+R5sf9j6Xuz9F8/htkHLcYU9OHWtYhJItc5P/7wA21D
AGCu/PrrrzmCpc8tetfEgao103HN1C8rYrHqf7h1IdQhlrcM+6UDYABNTU05
QrcnlrufucHizR59LgSr/inodMDExACXp0+f0jYHAOZEa2trYXrMHQutNDRI
RS8adRCr/inpoPe4rARhS0sLbYsAYDaU7Cn81hfDLD2r0Pm/CzZi1T81SbkT
9xZJMYMRgP5w9aJyr9c3FlbQeQh1yWe0aCWmuFBTRezktI1fXzz/LW2jAGDq
/PTgQb4X+/UmzE7sVfUJEz1mj6Eea9asskhHkeucBw8e0LYLAKbL8+fPc4LX
/ZFkvTu09FPrpo4gkUI91qxZ50NY8YI1z549o20aAEyRt2/fyrIS7oSMo56W
pq+AeWNO+E2gnmlWrn2e4/LSRNiwC4BPUZYeP8rHMEu/lL7sy11Y9W8CkrhM
On38CG3rAGBaPHz4sMBrDhb191OHXUZsWjuOeppBN6Id41xm3b9/n7aBADAV
Ghsbs0Nc/p0wkXpOmovUoXbBWPVvGjofwkrw39DU1ETbRgCYBCE+rrexdGgg
0mxyXDt1BFb9m4h288bJ8jMxIx2Amzeub41ie8+3Pcu3f4s55/2Wx6zR57Hq
3zRUGTtZ7PL3m+XltM0EAE2ePn2aGb3+2ZkVT884xWyYsMl5LCYr9lNRi0Yd
8sYQuqnocphDrNeKhoYG2pYCgA7k79MdBWlVsvltV1frdCTp734LxtwIsqee
lqavrSu/kGLVvylpv9e4gk3xKE4HrJPr11Ty5AVdYa7TryVLAlfYF26ww57n
feuCz+g4rPo3MWW6fl129QptYwEw3Dx9+jQrZn3TOc5HeU7UesV5a8jk0EVj
qiOwtqhX/TNuIm8OVv2bllThk0TenOfPn9O2FwDDyt6inFvb530a5l1S75on
WDz2sId9SyYmpfcsrPo3Qe32GLejQELbXgAMH99///32uMV/qVb1kedELy9w
0rxYomW2dXGoatGD/OeNPumPVf+mpcrYyckuU79Tq2mbDIDhQKPRZMX7/F/F
0r7DvEuXcmfyF4xRCjCb8WOJl47Y7Y5V/yanE37jNy6f++bNG9pWA8DolJ4o
+Ta7r5GWT/XnaafIdeOzVtk1JGM243sd2vhl5jpMWTQtZa0auXzqzI3z3U8q
TtK2GgDG5ffff8+JXvX6ovOA8lyng3Hf+C0YUxmM2Yx63Q2xC1mCVf+moqOC
8etnOHgu9dkRcrAk9kyoR8Qff/xB23AAGJE9hZLbsoF1zrvrcfEifyc72Ub7
ZsxmzPnq9SbHdVNHVGLVP22VRTgGLxizcuayDK8CRbzyeMIFIonP1sL87bQN
B4Cx+PnnnwtFSz97G7RvtV5xLghyFC4a81MkZjN+5TZzlDIUq/5pavO60cun
TI9cF3co+rQuyXUiwR7mGvPTTz/Rth0AQ8/bt2/z0oX/c3jxYMK8S3dkc30W
2R7j2bda92zG8IWjin0whE5H2vueMx3cF/GKgvZ3T/IuyYIPJkenouAFsDxu
3rheLP54Nehg9J/znGQPVvxy23/GWe9Gu1s4X2zZiCkuw62yKMewRaM5M5ak
8/KOxZ/vMcx1inFLvnXzFm3zATCUtLS0ZMV5/X5q+RDmuU7ns6cLFthe8rN/
Z5WzGc97j05wxhT0YZV0w2inqVPD18YejDrZR5LrtCfsSExwXGtrK20LAjBk
XL1y8XiG4bdB+1b9iWXha8blrLF7muJAPWCHWXWiCV5zsep/mHQ6YCJ3Fou7
0K0wUP7ZJO9SvHvalcvY1AVYCG/evMmMdX96xslIea7TvthvAhfY3g6xutmM
a6eMuB6FVf/GVXmUY9TiUSumLxR75ByNO9f/MCfaH3kiQhD1+vVr2kYEYAi4
dOFsqcRYnfPuenhwkf9y+10u9q82WdFsRt+5WPVvXBW52q6YOiVkVeT+yOMD
SvIuJXtknvv2PG0jAjBYSLckM8a1x30UjSHNJefN/o4Ri20fRllLAbtk7ap/
bIRuFH0bNNFj9viN8zdu8d9tWJLrdDDqZLggCjsAAHPn8sXzZ4alc95dFdvn
8BfZnvCy/yvL8m+SHtzwZdY6bIQ+xLoZ4yhaOtJp+vwUN8lAB1h6VIJ7+qUL
l2jbEQDDaW1tzRR5GHvkvEc1neUkuk9Mchr7r3gLn814J9hOuBSr/odSu9zG
rpz29yDnMHmEYvBJ3jmKfjzKP6alpYW2KQEwkBvlZYqM+caO7j5UmjFNsMD2
ikXPZnyZ5rBuGlb9D43Oh0z0mmO/fu66fN8dQ5Xk3Se6XLtaRtuUABjC27dv
s5N8608so5jnRP86vizUeVzeWrvnqRY7m9Ft5qgLoQ7Uw9CsVRHjmLh85PJp
cxNdNx0RnR3yMCcivf3YkHgsFwXmyN27d4vTFtEN8y7tif4mYMGYe6GWOZsx
bMHow1j1PwjJeXbO07724wTvDT9qjCTvUoxb0nfffUfbmgAMmK2SmKHarWVI
9GD/Qt9lY/e62r/eZGlbvuSv+GKrC6a4GKKLoQ4+bLu17FWbBUVGTXKdCgPl
WSnZtK0JwMB48uTJVhGF26B9S3PJOdt3UuQS28fRFjWb8ZzX6MRVmOIyYKWs
GOE0bU68a1pJ7JlhCHOdwtyiiTtoGxSAAVCyv6iyaC71AO9RN7bO8Vloe8rb
cmYz/ho73nuuLfV4NCMd9LJfPW2ywMl/t7Bk2JJcp2zvrXtke2kbFID+8p//
/Ccjcs2bS4YUIRoePT/jFOcyMZUztj7BQmYzrp3yZTlW/fdDV8IcfOeNXT1n
ZbbPtmFOcp2Oxp0T8iKamppo2xSAfnH54vnzucO9hsgAnUyb4rvAtizAvj3b
7DvqAvbo0wETqaeliWuT84jlU2fFbkw+PIwDLJ8q2T3j8qXLtG0KwOdpb2/P
TvL9wwhb4xpD/zy2NHilvXSdXZPYvGczJi0ZsccDt0R71WGfcWunT/JeJtgZ
WkwxyXXaE3YkPjyJOIW2WQH4DI8fP96RSHnO+UAli/gqeOGY74RmPJtx3/q/
Za/HlMUedDXCIXCerfMspyyvLV3FPakryj3u0aNHtM0KwGc4ckB2W2aid0L7
0I975wuW2B1ws3+TYZazGSsCx4Ytw6r/j5W9euTyKTOi1ycWx5w2dkQPSNk+
2/bukNM2KwB98ebNm01R619fNN07oX3o9QXnLMGkmKW2tTETqOfzQPUyzWH9
tBHU89N0pBCMXz/DgbfESxZ8kHp6fyrtXVGviFevXtG27DDQXF1V/gnVzbQv
C3yWysqK45lDWSR0+HVNOstnge23fPs2c5vNyJ0x6qIQq/6/KotwDF04ZuXM
pRme+aYzwPKp4t3TqqqqaFvW+DRXsW0+hVWFQDd5dkpTHx40lTX+BuvpGafY
jRPSV479PZFFPaX7r7CFo0v41j6Enr9utNPUaRFr4w5Gn6Ke2H1ra8CeAskW
2pY1Pho1x8aGLSnXtGma36OhfVngM7x48SIzclXrlVXUA3lIdDR5iu+CMeWB
ZjObcfOK/97mMpZ6otLSCb/xG2dOdF/ksT1oH/Ws7o+OxZ8P8QgnrqFt3AGQ
6G7fm3p9DpPnHFn1J//QrBBxuUIhV9t955TWahqrS4UcfV+ezRWV1zGZr6kW
cYQKZTFXd5wjqmrQb2hWq5Jz2Syms8+VqWp1B+vVCoHuHCxO10FgADdvlp/K
MoNp5/3Xk6NLgjj2hevtXojNoIBdKW9UslWu+i+PcgxbNGrFjMXpvM0kJKkH
df+V4J5efr2ctnEHAMntHp3y2TxniUvrG+rrOmnURnKznMMEL4eksqDqsUob
zSxBsVKlkImY7JY1dz6dIJDIi6VC5vFyEvTNahnzGFGpqlTMPKK4VtNcrTso
VKiUUoH2fGJV/bB9OBaGLD/p0SGzH2z5SK1XnAvDJocsHPNj+Djqid23HkeP
58+zulX/WzaMdpo6JWxN9IGoE9TzeaAqCj4gSc2hbdwBYFiecz8ZPRdXNZJI
ljEDMQ26R9Uo2Cxu16B6lYRlw3qf51x5dbfj0kb9b4Gwtu39SwgVPzCdeHFn
gmu0j2HLMU5vAE1NTVmRzn+pLGSw5SN9v3u+YMnYQ+52GhOezfhO4rh2ypc3
oq1l1f+ZwIlusya6LHDdFrCXejIbJkW80ryGXAzvnwuLq2uqdajV1fXakG2W
sW3YUvX7RzbXKotlYpGQw9L12/V5zraxkXZOh6kmvwHanNc+l9X9uczzZRzd
mIwe5izcagzVD5yKiluns2iWIjK2Xl7gpHs7xC6zfSIy3dmMfPaY0kDLX/V/
M8YxesmoFdMXpLpnD0lxT4pKcDOnWS4G53mP4+fd87y5prhz5Fwgkckl3Pfj
Ldo8VzfqHlatzXF9nn/wW6AtE8J02lkCqUwmZZDJ5TK5og55PnD2FUl+2r+Q
euoaW1fyZvIX2J4X2L81yQJ2iUtGynkWvupf5mrLmfaPkFUR+yOPU0/jwUvq
v6swfztt+/YXg/Oc/XFfuuOjPFdLtd1pRZ3+Xme5mPXZPCdP1h/tqBeRIJfe
YA7KuvK7WiERSRT1qAc1QFpaWtIj15vyhopDqD9PO0WtH5/pbPdnssnNZty7
1pJX/Z8Lnugxe/yGeRtIBlLP4aHSEdHZUK9wc6kTbUieN/crz2vk2rFvibK6
oaFOKRW8HyrpOc876kq190Y5YkVtfa2CuSFKHqM7yBbJa+rqyouZm6pCJeJ8
oPz000/7U5dST9rh1OGEf/jOH3Mr2LS2fLkZaBux3ALzvCLGUbR0pNO0eclu
meY+wPKpRB4p9+/fp23ifmFQ/7xaoB1v+UyedzSqRV3rjlgCGRPpilqNrnsv
6xo/l3P0/fYOTZVc2HWDVSiv0ugPiroOsgWyWgy2DJxTigMV29nUM3aYVXt4
ceAK+6KN9s1ppjKbsSnVYeP0kdTjd2i1233symnfBK4UysOPUc9eYyjLa8uR
4qO0TdwvDJl/PhCaGxsbmwcyIUXDPEPTw8FPjoL+kp0oeHZmBfWAHX61XnHe
EjI5dNGYBxGmMpvRZcbIS5ay6v9CqIM3e9y6uWvzfWXUU9d4kkco4sOSaJsY
AC0NDQ15MSupRytF3d05V7B47BGefUsm/dmMoQtGHxGY/aqiihjHJKeRy6fN
TeCml4i+pR65xpbQI+rp06e0rQxAx507d05a9EzF/ujlBY7YkyVaZvvPOMoF
7HKdvih0Ne9V//t4dqumfeW3InBP2BHqSTs8SnBPu337Nm0rA9Bx5ECRepe1
57lOF3Jm8BfYXhDYv6M3m/G0x8iU1ebaP78Y6sBn261hr8rlb6eescOpPIFs
T5GctpUB6MiM82o8a42D5z3q95PLItaOz1419mkKnQJ2D6PGC+abZf9czBm5
fOrsOBdxCdXinlRUHHM6KiCWtpWBtfPnn39uibOKaecD0v64b/wXjKkKthv+
PH8ncVwzZcTN6MnU87n/Ouhlv3raZJ/lfruEh6lHKy2F8aIxhA7ocu/evROZ
lr8s1AA9Ll7k72S308XuZfpwz2b0njP6jJms+r8S5uA3z3b1bE6291bqiUpX
CR5p3333HW1DA6vm9PHiyiLzqxY6PGq94pwfNDlssW1N1PjhzPOExSP3mcOq
/0znkcunzozdkFwcU0o9Tqkry2vLsZLjtA0NrJptkuj/q7CulaEDVVXRXP4i
W4WnfetwzWbcvfZvuRtMujZ0CX/c2umTvJbxd4Qcoh6kJqJdwsNp8Rm0DQ2s
l9bW1rTwtRZTkMh4+s95TrI7K9HJ9l/xwzGb8Ya/bZSTia76vxrhEDR/jPOs
5VleUlMu7klFITyz2cjFAJrra1SlxTKZTC4vVqmxEN/kePLkya4kzGzpr85J
pvPn2172szP2bMbnprrqP2fNKKepM6LWJxyKPk09PE1Q0bz4uro62rY2Bs1K
XQ2hDypCi2pQasKUqKysPJdjUQXmjK36E8vC1ozfvMbumZFnM7pMH3k5zIRW
/Sv8xm+Y4cBb4lUUfIB6bJqsEt03mdFe6P1HLdPunciRlNY36zY7bKtVMYXh
BApsfmg6nDp24LYMN0MHLHnsNwELxtwJMeLejMHzRx81jVX/ZVGOoQtHr5y5
dJNnnnkV9xx+Sby3Hj18jLat+yJ5wX/1pl6foysAyi3+aIClSsKx4Uh1+533
WMS5tlTM4YrEAu2zRYp7ChFHIJaKmcex2EJVbZ1Kv60uW6Ks0T2lx4rS2vMI
pPqapDYsgbi0saOjTikhJ+nchbejrU7JYXEU1j0IJMuLf3J0CfV4NEf9vH+h
3zK7Pa52rzYZZTZjttMX201g1X/ButHLp0wNXxt7MOok9bQ0fe0IOSRJMely
otrc7qm99ZHnmmq5dnPyqsbeHtBbEedqGVcfzGyWWPlY3lkWulguYemHbLhy
hVyozW+OmiRxQ88VpbvOIy1WSJifA2FpXVudgvn7QP/bUSUlxwU1Vhzn7e3t
aZGury9iMZGB0lxyzvV3jFhs+yh66GcznvQYKV4zgWKSn/Kf4DJzotsi98LA
fdRz0lx0NO6c0CeCOIu2uXvFgDzXxXVXQQpNXblUoisHR/6voq5N01sRZ22p
UBtWqb5i0QfFo5liRmwVc0oNc/7iGk1vFaU/PE+9WF9co1FXzIh5eK2QPEJc
PuQflxnx/PnzvFiE+WB1c9sc/kLbk172f2UN5U3SnyPH+S2g0z8vj3KMWDRq
xYxFaR65GGAZqMI9o4mzaJu7VwzJc7XUpltBCn1vvLPiRFVzr0WcmRzuqub8
QfEL5p9Edd1OqP+96Kmi9EfnkXeep06hLYehbOhoY84gt+beeUfHw4cPD6Uv
o56HFqCms5wEN1bKirH/Thiy2Yxtmcyq/5jhXvW/beOYFVOnCNdE7Y88QT0b
zVEiz+THjx/TNnevGJDnumEQzif15pgcZqubey3i3FVaTvfwD/P8/T915Xlv
FaV7PU9jlXaQRVFdrh2/6foDwUqpqKg4l4OboUOm0+lTfRfYqvzt27OHpqPu
NWf0maDhW/V/JnCi++wJLgtctgbspZ6K5qtk94zKykra5u4VQ/K8o54Z72YV
V38wPbFa2z1m+ue9FHEeaJ73VlG69/O0lWpvqLKYgfjqwX84Zs3Z04pbhVZX
Y86o+tfxZcJV4wrW2jWmDsFsRtHiUfs8h2OV6M0Yx5glI52mL0hxl1hecc9h
Vqan9NTxU7TN3SsG5XlHW71SN/7BFUlLVSqlQi7Uz0bX3oLsrYjzQPO8t4rS
fZynsUqqm/SitPLeeUfHgR3ZPx/ATlxDr52RXwcuGKMWDnY2447VX2w2/qp/
mavtyql/D1oVvi9CQT0MLUDbAvYW5m2nbe5eMSzPCZp6tVTYfUkRSyhV1Ok7
5T0Xce5W+rnj4zzv9k+aGu38GTnp/PdSUfqj88i7F6Fu094JteHIsbCpID30
91PLqaefReq+fIHfMrt9XLvXmwzf8uW6v220kxGnoJ8LnsibPW7DvA1Sv13U
Y9BitD/yeHKUmLa5e8WQ+efdadM0MqWae1hGNERFnAdWUbqxnPwCiNA77+hI
DV+PnVuMp9cXnCW+k6KWjPmfGANnMz5NdnCdYZRV/xUxjnHLRi6fNi+Jm3FE
dJZ6BlqSjsadC/EKo21uK6CtTi7WTYMR1Fj9ItXm5ubsaIS50XVdOpu/0LbU
x77NoNmMG6ePVIVPGtow3+th5zzt64CVofLwY9TTzyIVyot49eoVbYtbOm11
YmYhUrG6gfal0Oe3337bnsChHnfWoOdnnOJcJog5Y39LZA00z4Pmjzk2dKv+
L4Q6eLPt1s1dkyeQUQ89C1aUZxzxF22LAyvi8ePH+8WYfD58Op46xXfBmOuB
A5vNmLnsb0XcIVhVVBHjmOI0cvlUdoJreonoW+qJZ9mK80x5+PAhbYsDK0Kt
Vp/MwuSWYdWTo0uCV47bss6uSdzf2YwK7gjxmsH2z/fx7FZN+0qwInBP2BHq
WWcNSvbIuHv3Lm2LAyuirKzs0ubZ1CPOClUU/nXwwjHfh/VrNuODyHH+Cw0v
PHcpzMGXPXbNHOdc/nbqKWc9SnGTXL9+nbbFgRVx7szxiu1YTERHP+6d77vE
7pC73ZuMz8xmZFb9f3nLoFX/aZwRy6fOjnNJPRx7hnrEWZUyePlnz5yjbXFg
RZwo2aPeNZ96slmtXl9wzvBxiFlq+0vshL4j3Wv26LPBrAEl+SEf+zXTHX2W
++4KLaYeblYo8tdQycEjtC0OrIjDewse7MP4OWWp8mfxF9qe49u/7b2AXezi
kfv7ver/SphDwDzbVbNWSLy3Uo81q9UW/907C3fTtrhRaK6rVpWre90JHVBi
z7a0/zm8mHqgQU/POMVumJDhPPaPpJ5nM8pWfZG3oV9D6FmrRjpNmxmzIak4
ppR6plmzZMEH8zKltC1uFNTashGsKqyuNzG258T86zjmK5qKjiT9w2/BmBtB
dp/muUowJobzmSkuRwXj181w8FrqsyPkIPU0g/aEHclIyKJtcaPAbEXOUSPP
TYz8tCDSM6SeY1CXfi1ZErTCvnD92P+kfVDA7vfEidxZo3tL8rIIx+D5Y5xn
Lc/0kirildSjDCKSRyiSo010CxfvGf/Vm/rz9O553lutTzZXWyVUd1hcXKVf
i99cKxdxdZs0stgcqb5gaLNCyBFI5boqct1rj4IBkZ3IbzqH9aGmpdYrzoXC
r0IXjbkfMa57pG+YNqLHVf+5a0Ytnzo9cn38oejT1EMM6tKBqBNxwkTaFu8Z
kts9dgwGnOe91vrU7cHIKVap5CJdrc9a7aaIzGGxvFRZKteFt7K+reu4DVdc
rJAxcc8ux+j8wMkUef7nPPLcFKXeNU+weOxhDztN52zGoHmjFb4fDLko/MZv
nMnyWOxZFLSfenxBH6k45nR0YCxti/fMUOV577U+ucwmt91rhsqaNTViNktc
qqsvpy8YyhSY0z1AqtuBRVfYTorbrQNnU4z7qwsrqWcX1KNeXuCkezvELbd9
ItLOZsxY9jeZm37Vf1mUY9ii0ZwZS9J5eSjuaZoqEX0bxo+gbfGeGbL+eUdv
tT7ZNixpVyJrty7Xl/7UVKsUUrFI0DlEo89z7WbmnaWFmD4/8twAxBEuby6h
GLRJ61LuTP4CW6XA7ojriHRm1b90w2inqVPD18YejDpJPbWg3qSIVwZ7Cmlb
vGcMyPPGOrWqXL8lrS7PSbe8z1qf0q77pdXakkNcdXO9WD90zhGKZTJmHKZb
nncWp9CoOchzg0gJw+bnZqA/TztFrpsQvWikz9zRrrMmchdyCwPl1PMK6lvk
76YgXihti/eMAXmu0o6OS3QRzcxX1Pa3e6/1qQ98Bo1CQDJc+ptaO8AiUurH
W5qrpL3lORt5bhCzZ82dNWsJZBaaMnXBWLup//jHMvasNQvnrF8614Uz323t
PJ7LfC+P+QK/paFC59i49eI095xc/vbtQfv3RR4/FoehGGo6GnfOkvrnNcXa
IXGBVKFSMHWhOXINOdhrrU8uM/YiUdfVqmQCXaXmtvpS7TGxorahoaZczvp4
vAV5Pli8+DFJudXJeQ8gc1G8RB2zqSIipSw04VJg7Le+Ece9Qw97BOx1893u
6p23zj191fq45c7CRUv4c+a6TJu+cuaMVXP1+b+RM4+7ep7HxnmeJP99l4aE
royJXZ+a6paT47ONdPjl4ceQ/0Ob5yHeJlqiyJDx87Y6qX6moTaelbqiob3V
+tT2z1mdY+Q2XImS6ao3l4q5XQVGRVIJWzvcru5xvEVWjdntA8bHT5SY8wP1
jIKMp/js72I2VUak9jf/Z0xfSfr/C+asQ/4PPs9DvcNpW7xnDJ5/3txT2dBP
a31qx8/Z2g58s7aU6AcPb2NOobH62nDGwDcwPiH7e+qZA5mOuvJfmHg5KPas
X+QJn9ASXqDc3a+I5P96902rN8Y7rRIuWiZgz3Ptnv9L2BtWzHVdNdd9w1ye
+zwf/pLgEE50zLrkVK4k23vb1oC9e8OPHomzoiqlR0RnQ31MNM+NjXaAvdv8
FjA8BAQnkr/fqWcIZL4i/YHYjKrI1Ov9zP/p01bOmblq/uy1Fp//h2PPRPhF
07Y4HWpLxRyhAiMmw0xIuFiUeYd6JkDWow/yX3TOL/Kkj7CEF7TP3V/G5edv
8Mgg+b9iVdjiZb5z53Gnz3Duyv/Fc9Y7sV1WzXVbz+Zx53nzlwQFc6Ki1yYl
u2ZleW3Z6r9nt/BIiSnt8X4w6qTJrg8FFkm0KDM67RZ1j0NQb0rIIfl/O1Jc
3u/858ye4Txv1hrq+S8PPyaOTadtcWBFpIjzI1LKqHsWgoZKXfkflnQlWHTe
P+oUP+yIZ9B+D/8dXH7BRl7mGpcEzurwJct95853mzFjVVf+L5q9bvmcjc5s
13Vsd+5cL59FgUErIqPWJCa5ZmZ5SqX+u3YJDw+oxtOu0OKs5GzaFgdWRFbO
dtLtoe5BCKKlxJwfRJl3osQ3+pn/06aumD3ded7Mz+f/Zr6sIGsLbYsDK2JL
4V7Shql7CoLMRd3yXxUcd94/+jQ/7Khn8AGPgJ1uAulGz6w1rkmc1RFLlvvN
mrM+LjaVtsWBFbFv/xG/yJPUPQJBlie/yBP7DqB+KBg+Tpee9Q4ppt7yIcjy
RJxVWnqWtsWBFVFeXu4RsId6y4cgyxNxFvEXbYsPIc3V5Sp13QeLhDT11SqV
urH3xZ7NdWpVVW3Xv2va+r8utK22qlxd++GapLZGtUpVXd99YntzdVW5SlVe
r9E+vqp2sGuYPrpg8+LevXuegUXUWz4EWZ48A4qIv2hbfOhormLZ2LAkVd2P
fbYwdJVYW4+ICdkGOdeG/eHT+3497faLHz3+42toLhUxW8oIFY0djRLtpjCD
/QFVazcbk5jpytaamhrvQCn1lg9BlievgALiL9oWHzqYbbI4XbtmMXy2MHRb
c31tXYO2u9umZnbfqu71oZ+8nrz7Jl09XEOzQshs9Cgt13WnG+vIS2n6ff6e
qZFzdCWWzJH6+nov/wzqLR+CLE/e/hnEX7Qt3jNrZ7r2pl6fw2Qpu7c811SL
OEKFsli3fyKbI6piUrxz4X9zsUC/rSJHVEoyt16t0NUP/bD6c1u1QsJmetwC
sUTwycvpr0H7o0BOqH2cQNb1ANJX54gUNX1Ul26uVeqrKLFFxcUSDkdcq/ng
OIsrEnL0JTkIdeVybtdFdpWuFnEE2krXbKaktVBVW6fSbxTMligp/3y/fPnS
U5BAveVDkOWJx49/9eoVXYP3BsntHtdADSLP1bqSzgKJvFgqtOncIL1aqitU
1FYlZw6yBXJldRNTOdSGLVSolFImlsUq7Q9fvUrMhKqkVKkvEM3puX9eWszs
0iuQd+/tN8tY5KXUvVaXbtZdIUdeqpQK9bXxtCNF74+X6i5GVzKvXiXR//wo
9bv8di9pTd5nsVzSuX0wV66QC7VXxFEP9u+DweItiE3M/ZF644cgSxLxlBc/
hrK3e8dIec7tDFimMLR2f0Wm8BzT3W2r4WqTkvRgNUwnXtz5p4tGm5BseTOz
C7oNS6KrCt1Rr2T1lOfv908njxUqusVn1ybqPVeXZkpvsEr1pZSamUIc2iuv
Yf5y6Cyx1CjV98+Z3GaJ9bWUOhqYQkzkmnUn118kU56JrWJG23XlrYtrKAd6
VGxGdDq2cIGgoVTMpopoUSZda/eBIXne3Of4ua6oUGcRCu1xVlchUSbP3/8c
MJGoHZPR01nVqF5so+tg619P1sv4uQ1TEUkp4TA3Qms/eXzP1aU/KmlapxDq
rvzj0tW6K2+rEWpj+/2rMz8H7KrmD66KefsiXeY3M3lOvazS5vydIfEXqLd/
CLIkBcedz8vfSdfafWBInrfVCvVj1+9hCj0zoxYfFonrivEe85zp+gqkMpmU
QSaXy+SKupfa83efuyJnd493Bt1JJOW66xExnfSuLveHef5xdemP87y0e56/
vwHamecfXYzunX6a5++fayJ5fkxx2kdYQr39Q5AliXhKcbyUrrX7wJA814+H
dA1BdHSOQgi107U/m+e67j1zK1N7Hrasa2CiWiERSRT1bcxxTme0aqq5vdwP
7fobQVMjZxJdd0m95rnuwpj6pyylfpSHKVGty3NmHEalH+XpUAr14y3Mxcg7
c76NeTwz3mLaeV5RUcEL2Em9/UOQJYkXsIM4i661+8CgPO+o1k1SYQuLS1Xl
KoVIdx9RN8Pks3neUS/WDoiLFOU1v2j7xjZskbymrq68mOllC5XkN6FWOwZi
w5GU1tZ1FpTusX/e7SAzgm3DFqs+m+cdjVXM9XKLVSq5vugp85dFQzmbuZqq
WnIxwq77obpxdW316vpaXalr8iptJp/njx498grIo97+IciSRDxFnEXX2n1g
WJ6TcFTJhF01oZlZHkp9fn1YxLlaztHN+uv6D9LFLZfoBr+ljR2aKrmo6yRs
gaxW03l+aee8RrZ2BuHH89WZ+6HcD6a11EuYbJbX/CbvfbxFd2Ft9eVCfZAL
BMzCJF1vvb5K/r6otU3X3wiacpmw6yK54lLmnX6Y5+/fnf6PBTntMtbPnj3z
8hNTb/8QZEny9hM/ffqUrrX7wJD55+/RNDYaWNO5TaN5/yyNrrj0xxNC2pjj
Qz5NRFNbKhDKutYDqEQ2H1Y41fR0LfqL7OG4qdLe3q6dspjzA3ULQJBlKCHn
ex8/EXEWbXOD9+gH20k/W6mUMUNFbEm5me7T0jcpaQVhSSrqLoAgyxBxU2pa
AW1bg4+pVb1f7ymWl5tPp3tgHCo+Jgg/Rt0FEGQZEoQriKdo2xpYKcwUFxl1
F0CQZcjEJ7cAy+bXX3/18s+m7gIIsgx5B2Q/efKEtq2BldLa2urJj03afJ+6
ESDI3EV85MkXtbS00LY1sF4SknMjUsqoewGCzF0RqWXxSTm0DQ2smuKS4/yw
o9S9AEHmLuIj4ibahgZWjbbwXMB26l6AIHMX8dHdu3dpGxpYNX/++aenbyp1
L0CQuYv4iLiJtqGBtRMUmizKvEPdDhBkviIOIj6ibWUj0VxdrlLXfbDflKa+
WqVSN/a+zLK5Tq2qqn2/xL+t/ysy22qrytW1PWxv1Vxfo1QUy2QyeXFpVU3D
B8/pxx4EA7kGM2bHrgP+UaeoOwKCzFfEQcRHtK1sHJqrWB9uCd6h3d5Qu4Vu
Ve97UFVpK8iJmVBukHNt2B8+ve/X0xYW+uTxtaVimw9hS1S6gNaWq/tgS5ZP
Geg1mDFVVVU8DKFD0CBEHFRZWUnbysZB02d9ol5oa66vrWMqQ7ep2Z/ul9jn
68l7qE+k3RTdRiCva2YivK1RV6VIt31iDbN7bV+r+Ad8DWbMH3/84eWLjRYh
yHARB5nF4Pnshf69qdfnfKZ+aLWII1Qoi7n6zW5FVUyKk+40Odzc0VzcuQ8u
R1RKIrderRB0bqUiU3XVjGurVkjYzIa8ArFE8Gk9i+aq9/WJ9EfUIq5AWaup
Veg34GWxRdWajsbqUiFHvwkumysqryOv2b9r0NTKRFx9uWiBRPcuzJTQiFTU
EoUgw0S8ExYppm3ifkFyu8e3MIg8V3fWvZcXS3VVIeQkM6uluipvbVVyoW6v
c7myuokp/WDDFipUSql2I3IbsUq7ka12wISEK1dSqpTrzvZxPYuOBilbF8BC
uUJVXVvf1RtvqC5lNk3kSOSl9b9pa4basATFSpVCxuS8dpfy/lxDWylTuUKq
UCoVEuYkfQ/gmDSHS477hKL2HAQZIh9hyWEzmXlupDzvqjRRRbKQScL3FXza
arSlRmU15KFMJ17cuRW5RpvdbLm+xBtLor/BWa9k9ZDnpJddIxNyug2fs8TF
al0fukbO0Y23aGoUbBa3a1SfuZh+XkOj9veCLdHV12ioKpbISuvNtof+4MED
nt9m6r6AIHOUp18ecRBtE/cLQ/K8uc/xc11Zt676RLqqyr3Ug5ZxdGMyenT1
f6o19WKb7gWgPywz9CFtmsba6vJiqb5unFBR2/Fh9beO5lplsUwsEnL0Qyf9
vAZdOVHduI1Aqig35+GWDo1G4yWIS8qtpm4NCDIvEdcQ7xAH0TZxvzAkz5mS
9+wPbyYy6cdU4fxs/dBuWartDLMEUplMyiCTy2VyRd1L7fm7zZ9plrO7x7uW
RnUxhyOq6f4Za2q0YyiC0u4v2lxT3DlyLpDI5BKujb4q3GevQdctr1ZJRYLO
snrCGnOO9Nw8WZDoHHV3QJB5ibiGeIe2ffuLIXmuHw8R170/0sBUYxZq55d/
Ns913XvtzwFzHvb7iSjVColIoqhvY45zOjvYzFSWj/rnjVUSpjde0+1YnXbM
XaTqelFNZ5FoRZ0+iMvFLH2ef/4aGopFXHGp/i3WKrXnpl7ieTDcqqjg+RdS
dwcEmZeIa26Zz57nBuV5R7VugghbWFyqKlcpmPuPJB6ZyP1snnfUi7UD4iJF
ec0vpdo+NVskr6mrKy9m7lcKlSR8axVC5o5maW1dtYzb0/1QXW+cHBdKS1Uq
Zalc142WMLdTmRhnSxXl95gxE4myuqGhTqkvMK0dS+nHNTA5b8ORl1fX1VXL
tdWj2eVmHOcdL1684PHjsXcuBPVfxC/ENcQ7tO3bXwzLc5KnKpmwcyBCN5tF
qU87ZihD1jV+3ln4vus/OjrayiW6YWppY4emSi7qOglbIKvVdJ5f2jmnkK0d
+e5hrnhjtUQ/y1D/OKlS311vqJLpDslvV4i6HsISyJhzKrSv8flr0NSpBO/f
IUuqrP34AswNcXpBaMIl6h6BIHORMPGyeJOUtnEHgCHzz9+jaWTox9r6j2nT
aN4/S9OsPUvzx3cc2pjjfd+HIOdhLqH540toa+t6Ae1ZmntY6dSfa2hmDpvH
vZDPUVZW7hmwg7pHIMhcxPOXXbt2nbZxAeiBpqYm7ZALZrlAUD+kG2whrqFt
XAB6Jiu7MFh0nrpTIMj0FRx3PlOyjbZlAegV7d5c/lupOwWCTF88/20WuwcX
sAhevXrl7RufmPMDdbNAkCmLeMTbL4H4hbZlAeiLHbsOCMIV1P0CQaYs4hGL
3fAcWBCPHj3i+WZR9wsEmbKIR4hTaJsVgM/Q3t4eFimOEt+gbhkIMk1Fpd0U
RqQSp9A2KwCf58LFy56Bu6m7BoJMU8QdyguXaNsUgH7x4sULT0F8Qs731I0D
QaamxJwfePw4M1rjD8COXQf4YUepeweCTE2C8GO4EwrMi19++cWDn0bdOxBk
aiK+IO6gbVAABkZiSq4w8TJ1+0CQ6Yg4gviCtjUBGDB37971EKAIHQS9l4fv
ZuIL2tYEYMC8ffs2NCI1UlxO3UQQZAoiXiCOIL6gbU0ADOFa2XWe/zbqPoIg
UxDxwtVrZbRNCYCBtLS0+AUlxmZUUbcSBNFVbMZtv6Ak4gjapgTAcM6dv4Ai
FxDE85edPaekbUcABsXr168FAQnookPWLNI5Jy4gXqBtRwAGC+mi8wJk1D0F
QbRE2j9xAW0jAjAEkG6JbyC66JCVirR80v7ROQcWg/LCJV7AdurOgqDhF2n5
2H0LWBItLS1BwhTMRYesTaTNk5aPaS3Awrh5q8Idy0UhKxNp86Tl0zYfAEPM
27dvo0UZ2NEFsh6R1k7aPBaEAovk/v377j6bqLsMgoZH7vxNpM3Tth0AxiI3
r8gX1aIhK5Ag/Bhp7bQNB4AR+f3333n8hPjs76jbDYKMJ9LCSTsnrZ224QAw
LgrFac/AndQdB0HGEy9g5zHFKdpWA8DovHnzJkiYHJl6nbrpIMgYIm07OCyV
tHPaVgNgOFB/952bz6akzfepWw+ChlakVZO2TVo4bZMBMHwUSHfyhSXU3QdB
QyvSqknbpm0vAIaVZ8+eefslxGbcpm5ACBoqiTLv+PglkrZN214ADDdXr5a5
8XOpexCChkpu/ByV6hplXwFAg3fv3mVKtmI6OmQZIi2ZtGfSqmkbCwA6NDQ0
kL9PYzZVUjcjBA1GsRlV3r4JpD3TthQANLl27bo7P4e6HyFoMCJtmLRk2mYC
gDLt7e2b84t8hIeoWxKCDBNpvfkFO0hLpm0mAOjz4sWLwJDk8JRr1I0JQQMV
abek9ZI2TNtGAJgKDx48cPNOScj5nro9Iaj/Ii2WtFtsogjAR5QcOeHhV0jd
oRDUf3n4Fx45epK2dQAwOdra2sTpeYLwo9RNCkH9kW/40bRN+aTd0rYOAKbI
8+fP/YMxkA6ZgUgrDQhOJi2WtmkAMF1+/vlnN++keImaumEhqDeR9unmnUza
Km27AGDqnD2rdOPnYPdFyDSl3UGRn01aKW2jAGAGtLe3b5ft5QXsoO5cCPpU
pGWS9onZ5gD0k5aWlsTkHN8IbO0CmZZImyQtk7RP2hYBwJx49uxZUGiKMPEy
dQtDkE6kNZI2ie1wATCAJ0+eeAoSosQ3qBsZgkg79BIk/Prrr7RtAYC58v0P
P7h5J4ky71C3M2TNIi2QtEPSGmkbAgDzRqW6xvVOx1YAEC2RtkdaIGmHdI0A
gGVwTHHKJ7gwKbeaurUha1Ni7o9cvuT4iVLaJgDAQmhvb9+3/7CbIA+T0qHh
FDPVPG/fgRLMTgRgCHn37t122V53v63UPQ5Zj0h7K9ohRwk5AIacv/76K69A
5ht2kLrNIWsQz192+MgZ0upoN3wALJPW1tbcvO3EaNTNDlm2eP5Fm/OLSHuj
3eQBsGSIxXI2F67mplO3PGSp8vAvyt28HWEOwDBA/gROTs3a4JlL3fiQ5Wmd
h4SEOVb0AzBsvHv3Ll+6w8NvG2a8QEMl0pZcvHLzCmS0WzcAVkdbW9t22V7t
JEbMS4cGLdKK3AX5pEWh3hAAVCC9dPm+4qDoAwnZWD0KGS7SfgIi5KQtYWoi
ABRpb28/pjjF9UrDHi+QYSIth+udplCcwqIhAEyBq1fL3LyTotJuUg8HyLwU
nXaLtBzSfmg3YQDAe77/4Qcv30Tslw71X6S1kDaDXRMBMEF+/fXXwNBkVDWC
+iPSTkhrwX7mAJgsz58/T0zJQe1RqG95Bu5MTM4hrYV2gwUA9EVLS4t2HiM/
N16ipp4bkKkpLuseaRuF2/dgxRAAZkF7e/u33553804KT7lGPUAg0xFpD6RV
nD2rxFQWAMyLmpoav6AkQfhR6jECmYIE4cdIe/j5559pN0wAgCE8f/48bVM+
z78Q5eqsWQnZ33v4bUtJ2/zs2TPaTRIAYDh//fXXkWMnuV7JGHuxTjFjLClH
FaewkzkAlsGDBw8CQ5J9Qg9RjxdoOMUXlpDvnXz7tBsgAGAoefHixeb8Ind+
TsymSuo5Axlb5Ft242eTb5x877SbHgBg6Glvby8rK/fxS/QNx5ojSxb5fr19
E8h3jXksAFg2DQ0NmZKt7oLNsRm3qScPNLSKzagi32xG1hbyLdNuaACA4eDd
u3dXr5Z5+yXwhSWoiGEZIt8j+TbJd6pSXcO2twBYG8+ePSuQ7nTz2RSRWkY9
jqDBKDL1OvkeybeJGYkAWDPq774LFqZ4Bu6Mz/6Oei5BAxX51ngBO8g3eE+t
pt2UAAD0efPmjUJxmsdPEIQfox5QUP/lG64g35ri+OnXr1/TbkQAABPi999/
z80rcudvwibqpi/yHbnzM8j3Rb412g0HAGCiPHjwIFqU4S7YHCkup55a0Kci
3wv5dmLiMu/fv0+7sQAATJ23b9/evFURLEzx8NuGOY2mo9iMKl7A9iBhCvl2
yHdEu5kAAMyGlpaWCxcv+wYm8vxlJEmop5k1S5vk/kW+gQnKC5ewbzkAwDDe
vHlz7vwFQUACyRP01akkuWfADvL5k28BNz0BAIOHJAnJE7+gRA//QoyrD4/I
58zz30Y+cyQ5AGDI0Wg0V6+VhUakevhuxhwY44l8th6CzeRzvlZ2HaMrAADj
8fbt23v37iWm5Hrw0wXhx1ApY6hEPkl+2FEPfhr5bMknjDueAIBh45dfftmx
64CnIN4zcFdU2k3qeWi+ihLf8AzcTT5J8nmST5X2FwsAsFJevHhxXnkxNCKV
55slCFckZKO73l+RDjn5xMjnFhYpVl64hI3KAQCmQHt7+6NHj3buPugliOP5
FwaLziflVlMPTNMU+WTI5+Pht9XbV9shJ58bdikHAJggr169qqiszMwu5PHj
ef5FwsTL2I9XH+Ob75NPgxcgI59MVnZhZVUVZq0AAMyCpqamsrLy1LR8D594
D//CoNizibk/Ug/V4Rd51+S9k79ZSIynphdcu3adfDK0vxwAADAEEl+3Kio2
5+/wEsR5+uf7CEui029Rj1lji7xH8k7J+/X2jc/Nk5G/WTA8DgCwGDQazf37
9w+XHA+LFPMEKZ4BMv+oU5a05pS8F/KOyPsi7468R/JOyfsl75r2Bw8AAEbk
zz//rKio2LHzQFBosqc22wsF4cciUsvMa7CdXC25ZnLlngHbSYaT90LeEXlf
5N3R/oABAIACDQ0Nd+/ePXRYEZ+Uw/OJ9fTL4gXsFIQrwpOvmtpiJXI9YUkq
EuDkCsl1evJjyTWTKyfXj/rLAADQndbW1idPnty6detQ8bHUtAIfP5GXb6pX
QB7JTx9hSXDc+ZhNFcNzX5W8CnmtkHgleV3y6uQavPzE5HpS0grItZFOOLlO
crW0PzAAADAP2tvbnz179vDhQ5KfiuOlefk7I2MzvAWxnoIEb/8Mr4ACz4Ai
j4A93iHFfpEngkXnhYmXI1LKotNuiTLvxEvUCdnfJ+b8oJsJT/43+W9yhBwn
/0oeQx5JHk9+I/wiT5IzkPOQs5FzevlnkPN78WOiRZnkFY8pTpNXJ9dArgQT
xQEAYGh5+fJlfX19TU3NvXv3ysvLz5w5t+/AkS3b9mZlb08W58fEZYWEi/2D
E30D47U9fH4MzyfKkx9N/pscCQhOJP9Ksjo5NS8rZ7t02x7y3NOlZ69fv07O
Rs5JzkzOT/stAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAABg0vz/iVOlzA==
              "], {{0, 362}, {496, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {496, 362}, 
            PlotRange -> {{0, 496}, {0, 362}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"781be1c2-e58c-43af-8f17-634d86f4d8d7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"43e1e6b2-462d-446a-85f3-79e964611da9"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d681cc3d-4aa7-43ba-8141-ee067da9d13c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2555fbc4-4159-4d7e-88ed-9d9ed9559da1"],

Cell[TextData[{
 "Make a 5\[Times]5 ",
 StyleBox["GraphicsGrid",
  FontFamily->"Source Sans Pro"],
 " of pie charts that give the relative frequencies of digits in ",
 Cell[BoxData[
  RowBox[{"2", "^", "n"}]], "InlineCode",ExpressionUUID->
  "0c45d146-e49f-41b7-b926-d446cc072de2"],
 " with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"4aa95b29-cdf5-4590-9af0-f999de5f8ddc"],
 " starting at 1."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"bbc6e522-fb33-41b2-9861-0de366ddf520"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"db8868e3-2f49-4ec7-8d55-61817851e588"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvWVUXNna73vuvV/uxzvuOO95Ze/ujrtB3AMEJxCIkQDBHQqoghJKoIQy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            "], {{0, 307}, {307, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{307, 307},
          PlotRange->{{0, 307}, {0, 307}}]], "ExerciseOutput",
         ImageSize->{311, 307},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a16271fe-04b6-4699-9cc0-47940561cfc4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvWVUXNna73vuvV/uxzvuOO95Ze/ujrtB3AMEJxCIkQDBHQqoghJKoIQy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              "], {{0, 307}, {307, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {307, 307}, 
            PlotRange -> {{0, 307}, {0, 307}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cfc5bfa0-5de2-428a-b523-5be85801ed75"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4fe8baf7-698c-4926-b180-8615dea0f6b9"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a2745051-e7f4-4ff9-9fd3-0f24b0ab386d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0c1e3c3d-bb6d-4b79-8633-3662507e008d"],

Cell["\<\
Make a graphics row of word clouds for Wikipedia articles on the G5 countries.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"fb9e00a9-549e-40ff-88ff-210a387643be"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ee8b09f3-bd95-44ad-aba6-fae292802b47"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvdtz49iZJ9i7Gx2xsRsbuy/zB+zbPk3ExkZHzNNG+GF3Y58mdhw7E7Nt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            "], {{0, 121}, {614, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{614, 121},
          PlotRange->{{0, 614}, {0, 121}}]], "ExerciseOutput",
         ImageSize->{618, 121},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "129424f6-763d-4064-844b-6a6e1eefafb7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvdtz49iZJ9i7Gx2xsRsbuy/zB+zbPk3ExkZHzNNG+GF3Y58mdhw7E7Nt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              "], {{0, 121}, {614, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {614, 121}, 
            PlotRange -> {{0, 614}, {0, 121}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"008b7ced-a5ac-4f73-94ef-7ce23fe81d70"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["37.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1df0346e-9ab9-4392-b68a-c55db255ba3e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"699bac0d-aa07-4867-9f03-f9fd82fc068d"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"01b6bab3-25f4-498c-9f8a-b3bf3a9e92d5"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Layout and Display: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR
EWwgQQEDRkORWBHFQkCw14AEASUGo9hQyax8PokvL++9vPz+uJ/vnHvOnXvP
OXc+o5GQEZIIAwCyCOgQws5xFQrZeaEy6EO4IIufJOBxfQUiXhJPyEqAUKMP
BR0AxcefL8iAUa90gUgY4u3GjIqOYeL7AQyIAAcsAGBzsjIDQr3CJN6+nu7M
LNQJ/Ite3wKSBcF1E58gJhP8f5LlZApFAEBBKFtxeVkclAtRTssRZUrs0yjT
E1IlDGMkLEQ3iLKihJPm2fizzzy7SJibLuCiLNlzJjedK+EelDdni3koI/4o
F2XzeTko30BZO02czkf5rSQ2ncfOAgAjyY62iMdJRtlckihhWIg7ygsBIFCS
vuCEL1jEyxVJDuWekZkn5Ccli5j6HAOmhb09i+nDy0njiUQmQWxOKlvIZbpn
pGeyBXkAzJ/5s+QkuWWiSba1sLe1NbE0tfgiUf918m9KUtt5ehn8uWYQo+8P
21/5ZdQBwJpBc7PtD1vCbgA6NgKgeO8Pm/YBAKTRurUPfHEehqRfkkWiTAcz
s5ycHFM+j2MqSejv+p8Of0NfvM9Ustzv6WF68BLZ4jQRU5I3TkZahljIzMpk
c3hMkz838T8O/Ot9GIfwEnlCngCNiEC7jC9IQsst4PJF/AwBky/4T0X8h2F/
0nxfo6LVfwL0OFMgM0AHyM99AEMjAyR2HzoD/V43f2IEkNy8SPXx+b7/LOjf
V4XLJAP6Gfkc5x4SxuSIhdnzc5JrCbCABKQBHSgBNaAF9IEJsAR2wBG4AE+w
GASCMBANlgMOSAbpQAhyQD5YD4pACdgGdoJqsB/Ug0bQAo6BDnASnAMXwVVw
DdwE98EwGAPPwDR4DWYhCMJDVIgGKUHqkA5kBFlCLGgR5An5QyFQNBQPJUEC
SAzlQxugEqgcqoZqoUboW+gEdA66DA1Cd6ERaBL6FXoPIzAFpsOqsC5sBrNg
V9gPDoOXwUnwCnglXAhvhavgOvgI3A6fg6/CN+Fh+Bk8gwCEjDAQDcQEYSHu
SCASgyQiQmQNUoxUInVIC9KF9CLXkWFkCnmHwWFoGCbGBOOI8cGEYziYFZg1
mFJMNeYwph3Tg7mOGcFMYz5hqVgVrBHWAeuLjcImYXOwRdhKbAO2DXsBexM7
hn2Nw+EYOD2cHc4HF41Lwa3CleL24lpxZ3GDuFHcDB6PV8Ib4Z3wgXg2XoQv
wu/GH8GfwQ/hx/BvCWSCOsGS4EWIIQgIBYRKQhPhNGGIME6YJcoQdYgOxEAi
l5hHLCPWE7uIA8Qx4ixJlqRHciKFkVJI60lVpBbSBdID0ksymaxJticHk/nk
deQq8lHyJfII+R1FjmJIcafEUsSUrZRDlLOUu5SXVCpVl+pCjaGKqFupjdTz
1EfUt1I0KVMpXymu1FqpGql2qSGp59JEaR1pV+nl0iulK6WPSw9IT8kQZXRl
3GXYMmtkamROyNyWmZGlyVrIBsqmy5bKNslelp2Qw8vpynnKceUK5Q7KnZcb
pSE0LZo7jUPbQKunXaCN0XF0PbovPYVeQv+G3k+flpeTt5aPkM+Vr5E/JT/M
QBi6DF9GGqOMcYxxi/FeQVXBVYGnsEWhRWFI4Y3iAkUXRZ5isWKr4k3F90pM
JU+lVKXtSh1KD5UxyobKwco5yvuULyhPLaAvcFzAWVC84NiCeyqwiqFKiMoq
lYMqfSozqmqq3qqZqrtVz6tOqTHUXNRS1CrUTqtNqtPUF6nz1SvUz6g/Zcoz
XZlpzCpmD3NaQ0XDR0OsUavRrzGrqacZrlmg2ar5UIukxdJK1KrQ6taa1lbX
DtDO127WvqdD1GHpJOvs0unVeaOrpxupu0m3Q3dCT1HPV2+lXrPeA32qvrP+
Cv06/RsGOAOWQarBXoNrhrChjWGyYY3hgBFsZGvEN9prNGiMNbY3FhjXGd82
oZi4mmSbNJuMmDJM/U0LTDtMn5tpm8WYbTfrNftkbmOeZl5vft9CzmKxRYFF
l8WvloaWHMsayxtWVCsvq7VWnVYvrI2sedb7rO/Y0GwCbDbZdNt8tLWzFdq2
2E7aadvF2+2xu82is4JYpaxL9lh7N/u19ift3znYOogcjjn84mjimOrY5Dix
UG8hb2H9wlEnTSe2U63T8CLmovhFBxYNO2s4s53rnB+7aLlwXRpcxl0NXFNc
j7g+dzN3E7q1ub1xd3Bf7X7WA/Hw9ij26PeU8wz3rPZ85KXpleTV7DXtbeO9
yvusD9bHz2e7z21fVV+Ob6Pv9GK7xasX9/hR/EL9qv0e+xv6C/27AuCAxQE7
Ah4s0VkiWNIRCAJ9A3cEPgzSC1oR9H0wLjgouCb4SYhFSH5IbygtNC60KfR1
mFtYWdj9cP1wcXh3hHREbERjxJtIj8jyyOEos6jVUVejlaP50Z0x+JiImIaY
maWeS3cuHYu1iS2KvbVMb1nussvLlZenLT8VJx3Hjjsej42PjG+K/8AOZNex
ZxJ8E/YkTHPcObs4z7gu3AruJM+JV84bT3RKLE+cSHJK2pE0meycXJk8xXfn
V/NfpPik7E95kxqYeih1Li0yrTWdkB6ffkIgJ0gV9GSoZeRmDGYaZRZlDq9w
WLFzxbTQT9iQBWUty+oU0dGfqT6xvnijeCR7UXZN9tuciJzjubK5gty+PMO8
LXnjK71Wfr0Ks4qzqjtfI399/shq19W1a6A1CWu612qtLVw7ts573eH1pPWp
638oMC8oL3i1IXJDV6Fq4brC0Y3eG5uLpIqERbc3OW7avxmzmb+5f4vVlt1b
PhVzi6+UmJdUlnwo5ZRe+criq6qv5rYmbu0vsy3btw23TbDt1nbn7YfLZctX
lo/uCNjRXsGsKK54tTNu5+VK68r9u0i7xLuGq/yrOndr7962+0N1cvXNGrea
1j0qe7bsebOXu3don8u+lv2q+0v2vz/AP3Cn1ru2vU63rvIg7mD2wSf1EfW9
X7O+bmxQbihp+HhIcGj4cMjhnka7xsYmlaayZrhZ3Dx5JPbItW88vulsMWmp
bWW0lhwFR8VHn34b/+2tY37Huo+zjrd8p/PdnjZaW3E71J7XPt2R3DHcGd05
eGLxie4ux662702/P3RS42TNKflTZadJpwtPz51ZeWbmbObZqXNJ50a747rv
n486f6MnuKf/gt+FSxe9Lp7vde09c8np0snLDpdPXGFd6bhqe7W9z6av7Qeb
H9r6bfvbB+wGOq/ZX+saXDh4esh56Nx1j+sXb/jeuHpzyc3BW+G37tyOvT18
h3tn4m7a3Rf3su/N3l/3APug+KHMw8pHKo/qfjT4sXXYdvjUiMdI3+PQx/dH
OaPPfsr66cNY4RPqk8px9fHGCcuJk5Nek9eeLn069izz2exU0c+yP+95rv/8
u19cfumbjpoeeyF8Mfdr6Uull4deWb/qngmaefQ6/fXsm+K3Sm8Pv2O9630f
+X58NucD/kPVR4OPXZ/8Pj2YS5+b+w0AsgC3
                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 37  Layout and Display", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
37-layout-and-display.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "37.1", "37.2", "37.3", "37.4", "37.5", "37.6", "37.7", "37.8"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "37.1", "37.2", "37.3", "37.4", "37.5", "37.6", "37.7", "37.8"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[27692, 527, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b762aed2-cb16-445f-8f28-f6e7d582813b",
   CellTags->"FirstInputCell"],
  Cell[69075, 1288, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8e3b7bc4-b3cc-4633-b46d-05a7e2912ba4",
   CellTags->"FirstInputCell"],
  Cell[117190, 2162, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b2909579-f7a1-4ea6-9796-2c6ad42aee30",
   CellTags->"FirstInputCell"],
  Cell[150179, 2791, 813, 26, 
  70, "Input", "ExpressionUUID" -> "36dc8b1f-6ee5-4f6e-8cf0-b47579fee942",
   CellTags->"FirstInputCell"],
  Cell[197723, 3657, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5f9f5be6-28c1-4cc9-a627-f5929633c771",
   CellTags->"FirstInputCell"],
  Cell[249661, 4595, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d681cc3d-4aa7-43ba-8141-ee067da9d13c",
   CellTags->"FirstInputCell"],
  Cell[345433, 6255, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a2745051-e7f4-4ff9-9fd3-0f24b0ab386d",
   CellTags->"FirstInputCell"],
  Cell[544248, 9600, 813, 26, 
  70, "Input", "ExpressionUUID" -> "699bac0d-aa07-4867-9f03-f9fd82fc068d",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 603068, 10819}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[641, 22, 487, 12, 70, "Exercise", "ExpressionUUID" -> \
"af109a2a-e012-4a87-bf51-afedc8a299b4",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1153, 38, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"80c0577e-eed0-459f-a3ef-869c0dba3ff4"],
Cell[1792, 59, 25293, 443, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5cb3d53d-1f7b-4fb6-972b-64389784f439"]
}, Closed]],
Cell[CellGroupData[{
Cell[27122, 507, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"eae47dda-e7a4-444a-a0f4-263b74cd5b4f"],
Cell[27692, 527, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b762aed2-cb16-445f-8f28-f6e7d582813b",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28542, 558, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"665a4ef7-4b17-400f-84a2-d00dc68aff0c"],
Cell[28829, 569, 438, 9, 70, "Exercise", "ExpressionUUID" -> \
"992a7da2-0b58-45cc-a715-a2feeb2111a8",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[29292, 582, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"34cc01b1-11a4-4be3-9a36-25143f3b96f0"],
Cell[29931, 603, 38537, 660, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5b6e4527-4088-458a-b1ae-581e6adae9af"]
}, Closed]],
Cell[CellGroupData[{
Cell[68505, 1268, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"f420c0e2-07a4-41e0-a6cf-2a326d722e0e"],
Cell[69075, 1288, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8e3b7bc4-b3cc-4633-b46d-05a7e2912ba4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69937, 1320, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1d6047e0-fd9f-48f9-bd97-642ac6efc528"],
Cell[70224, 1331, 501, 12, 70, "Exercise", "ExpressionUUID" -> \
"e1a119b5-ee4a-4804-a8b8-b9f13c4257ae",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[70750, 1347, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6e61d3f4-5754-4e41-8df0-930ed96cf27a"],
Cell[71389, 1368, 45194, 769, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6e193e35-d1da-4cd8-afb1-81baf6f3282a"]
}, Closed]],
Cell[CellGroupData[{
Cell[116620, 2142, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"352b1fc4-7858-4433-b960-1b5abb3d0c15"],
Cell[117190, 2162, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b2909579-f7a1-4ea6-9796-2c6ad42aee30",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118052, 2194, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3ed3fb50-7f26-41ff-b9e8-e16b29595382"],
Cell[118339, 2205, 560, 15, 70, "Exercise", "ExpressionUUID" -> \
"1715027b-0c65-4b4a-a508-34ca816fdb3f",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[118924, 2224, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3d717ad3-15ad-45db-a114-4fc51032972f"],
Cell[119583, 2246, 29989, 520, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3a91d590-f499-40b9-b663-45d3afeb0a2f"]
}, Closed]],
Cell[CellGroupData[{
Cell[149609, 2771, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"f368ef06-077e-47e0-aa7c-4283c5f11c43"],
Cell[150179, 2791, 813, 26, 70, "Input", "ExpressionUUID" -> \
"36dc8b1f-6ee5-4f6e-8cf0-b47579fee942",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151041, 2823, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"289ba6a0-433d-4cf7-a374-070be8e280ce"],
Cell[151328, 2834, 520, 13, 70, "Exercise", "ExpressionUUID" -> \
"24f1ed60-68ff-4490-8463-b2815908c06e",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[151873, 2851, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c250d91a-83d4-4358-aaee-389f20def225"],
Cell[152532, 2873, 44584, 759, 70, "ExerciseOutput", "ExpressionUUID" -> \
"fb170cc2-ac5d-4d48-821f-25f4991787ea"]
}, Closed]],
Cell[CellGroupData[{
Cell[197153, 3637, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"47701528-c72f-4805-b296-b2312547f4e1"],
Cell[197723, 3657, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5f9f5be6-28c1-4cc9-a627-f5929633c771",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[198585, 3689, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9179d93e-69f6-41df-ae37-5ed30bb0594c"],
Cell[198872, 3700, 538, 13, 70, "Exercise", "ExpressionUUID" -> \
"5067bbdb-d4b5-48c7-a8ad-33b95305822d",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[199435, 3717, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"2c4bb4a7-b276-49c2-a518-35a9cc66cc7f"],
Cell[200094, 3739, 48960, 831, 70, "ExerciseOutput", "ExpressionUUID" -> \
"781be1c2-e58c-43af-8f17-634d86f4d8d7"]
}, Closed]],
Cell[CellGroupData[{
Cell[249091, 4575, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"43e1e6b2-462d-446a-85f3-79e964611da9"],
Cell[249661, 4595, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d681cc3d-4aa7-43ba-8141-ee067da9d13c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[250523, 4627, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2555fbc4-4159-4d7e-88ed-9d9ed9559da1"],
Cell[250810, 4638, 785, 21, 70, "Exercise", "ExpressionUUID" -> \
"bbc6e522-fb33-41b2-9861-0de366ddf520",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[251620, 4663, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"db8868e3-2f49-4ec7-8d55-61817851e588"],
Cell[252259, 4684, 92567, 1546, 70, "ExerciseOutput", "ExpressionUUID" -> \
"cfc5bfa0-5de2-428a-b523-5be85801ed75"]
}, Closed]],
Cell[CellGroupData[{
Cell[344863, 6235, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4fe8baf7-698c-4926-b180-8615dea0f6b9"],
Cell[345433, 6255, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a2745051-e7f4-4ff9-9fd3-0f24b0ab386d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[346295, 6287, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0c1e3c3d-bb6d-4b79-8633-3662507e008d"],
Cell[346582, 6298, 519, 12, 70, "Exercise", "ExpressionUUID" -> \
"fb9e00a9-549e-40ff-88ff-210a387643be",
 CounterAssignments->{{"SectionNumber", 37}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[347126, 6314, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ee8b09f3-bd95-44ad-aba6-fae292802b47"],
Cell[347785, 6336, 195856, 3239, 70, "ExerciseOutput", "ExpressionUUID" -> \
"008b7ced-a5ac-4f73-94ef-7ce23fe81d70"]
}, Closed]],
Cell[CellGroupData[{
Cell[543678, 9580, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"1df0346e-9ab9-4392-b68a-c55db255ba3e"],
Cell[544248, 9600, 813, 26, 70, "Input", "ExpressionUUID" -> \
"699bac0d-aa07-4867-9f03-f9fd82fc068d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[545088, 9630, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"01b6bab3-25f4-498c-9f8a-b3bf3a9e92d5"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature NQshQ8k6yNEq2lIc4zAnX1cb *)
