(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    877097,      19197]
NotebookOptionsPosition[    762546,      16893]
NotebookOutlinePosition[    860646,      18913]
CellTagsIndexPosition[    859582,      18870]
WindowTitle->Natural Language Understanding: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Natural Language Understanding", "SectionInline",ExpressionUUID->
   "089e49a8-f6b6-42a2-8415-2e4d8488a8da"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 34}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->{"p:211", "i:1"},
 CellLabel->"In[17]:=",ExpressionUUID->"05e0cf2e-d74e-44c2-afe9-5e91963c3e81"],

Cell[TextData[{
 "We saw ",
 ButtonBox["earlier",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-16-real-world-data.nb", None}],
 " how to use ",
 Cell[TextData[Cell[BoxData[
  TemplateBox[{"ctrl", "="},
   "Key1"]],ExpressionUUID->"fb269df6-0a4b-43e5-b13f-98e3b16d4b82"]],
  FontSize->16,ExpressionUUID->"1a3160ae-4b6f-4a5f-abb9-b50b39159478"],
 " to enter natural language input. Now we\[CloseCurlyQuote]re going to talk \
about how to set up functions that understand natural language."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"92121714-4c8f-4e56-a1da-e712b24f858c"],

Cell[TextData[{
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " is the key to much of this. You tell ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " what type of thing you want to get, and it will take any string you \
provide, and try to interpret it that way."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"ea11afb2-2ac4-48bf-8fef-c51c81855b11"],

Cell[TextData[{
 "Interpret the string ",
 Cell[BoxData[
 "\"\<nyc\>\""], "InlineCode",ExpressionUUID->
  "0c3c0586-5745-4a7d-bf3d-3bc6e43575f0"],
 " as a city:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"e9180630-6870-4270-b7d8-7441cd137b45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<City\>\"", "]"}], "[", "\"\<nyc\>\"", 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"8162a0de-3691-4a35-804c-5810c3da0dd5"],

Cell[BoxData[
 TemplateBox[{"\"New York City\"", 
   RowBox[{"Entity", "[", 
     RowBox[{"\"City\"", ",", 
       RowBox[{"{", 
         RowBox[{"\"NewYork\"", ",", "\"NewYork\"", ",", "\"UnitedStates\""}],
          "}"}]}], "]"}], 
   "\"Entity[\\\"City\\\", {\\\"NewYork\\\", \\\"NewYork\\\", \
\\\"UnitedStates\\\"}]\"", "\"city\""},
  "Entity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"6caaf024-26f3-43eb-98b3-1b47c254a44e"]
}, Open  ]],

Cell["\[OpenCurlyDoubleQuote]The big apple\[CloseCurlyDoubleQuote] is a \
nickname for New York City:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ea3b6b62-3aac-438e-b18a-87e82d3ae0ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<City\>\"", "]"}], "[", 
  "\"\<the big apple\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"454e6d4a-ac64-4068-8201-2a53164affc1"],

Cell[BoxData[
 TemplateBox[{"\"New York City\"", 
   RowBox[{"Entity", "[", 
     RowBox[{"\"City\"", ",", 
       RowBox[{"{", 
         RowBox[{"\"NewYork\"", ",", "\"NewYork\"", ",", "\"UnitedStates\""}],
          "}"}]}], "]"}], 
   "\"Entity[\\\"City\\\", {\\\"NewYork\\\", \\\"NewYork\\\", \
\\\"UnitedStates\\\"}]\"", "\"city\""},
  "Entity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"fcc7e819-082d-434d-9ac6-63f98530fe9f"]
}, Open  ]],

Cell[TextData[{
 "Interpret the string ",
 Cell[BoxData[
 "\"\<hot pink\>\""], "InlineCode",ExpressionUUID->
  "422707bf-2dfb-4c3b-9f4e-b9f3a909cba6"],
 " as a color:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"23ba3be2-f4d6-4f7e-bc2d-5280f68d6e1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<Color\>\"", "]"}], "[", "\"\<hot pink\>\"",
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"b17ea8de-94aa-438d-87be-3c3a24290a81"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[1., 0.4117647058823529, 0.7058823529411764], 
       RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[
      0.6666666666666667, 0.27450980392156865`, 0.47058823529411764`],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[1., 0.4117647058823529, 0.7058823529411764]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = 
       RGBColor[1., 0.4117647058823529, 0.7058823529411764]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[1., 0.4117647058823529, 0.7058823529411764],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[3]=",ExpressionUUID->"b220b67c-fec8-4e1c-89da-5cf20bd346a7"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " converts natural language to Wolfram Language expressions that you can \
compute with. ",
 "Here\[CloseCurlyQuote]s an example",
 " involving currency amounts. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"7ff17141-e275-4290-89ca-3a1858120a1b"],

Cell["Interpret various currency amounts:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e077ed3b-6344-4daf-9449-8b14f71b8460"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<CurrencyAmount\>\"", "]"}], "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<4.25 dollars\>\"", ",", "\"\<34 russian rubles\>\"", ",", 
    "\"\<5 euros\>\"", ",", "\"\<85 cents\>\""}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"19583cbf-be59-4715-9b7d-4bfc45604bdf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"4.25`", 
     RowBox[{
       FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], "US dollars", 
     "\"USDollars\""},
    "QuantityPrefix"], ",", 
   TemplateBox[{"34", 
     RowBox[{
       FormBox["\" \:0440\:0443\:0431\"", TraditionalForm], 
       "\[VeryThinSpace]"}], "Russian rubles", "\"RussianRubles\""},
    "QuantityPrefix"], ",", 
   TemplateBox[{"5", 
     RowBox[{
       FormBox["\"\[Euro]\"", TraditionalForm], "\[VeryThinSpace]"}], "euros",
      "\"Euros\""},
    "QuantityPrefix"], ",", 
   TemplateBox[{"85", 
     RowBox[{"\[VeryThinSpace]", 
       FormBox["\"\[Cent]\"", TraditionalForm]}], "US cents", "\"USCents\""},
    "QuantityPostfix"]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"f2b5410b-3853-42d4-a098-1de1cef41ae9"]
}, Open  ]],

Cell["\<\
Compute the total, doing conversions at current exchange rates:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"29959fb1-263c-4fa3-8f24-09e2689f8c38"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{
    TemplateBox[{"4.25", 
      RowBox[{
        FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], "US dollars",
       "\"USDollars\""},
     "QuantityPrefix"], ",", 
    TemplateBox[{"34", 
      RowBox[{
        FormBox["\" \:0440\:0443\:0431\"", TraditionalForm], 
        "\[VeryThinSpace]"}], "Russian rubles", "\"RussianRubles\""},
     "QuantityPrefix"], ",", 
    TemplateBox[{"5", 
      RowBox[{
        FormBox["\"\[Euro]\"", TraditionalForm], "\[VeryThinSpace]"}], 
      "euros", "\"Euros\""},
     "QuantityPrefix"], ",", 
    TemplateBox[{"85", 
      RowBox[{"\[VeryThinSpace]", 
        FormBox["\"\[Cent]\"", TraditionalForm]}], "US cents", "\"USCents\""},
     
     "QuantityPostfix"]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"680fb280-9abc-4b1a-850a-d8cdda6fdea8"],

Cell[BoxData[
 TemplateBox[{"11.07`", 
   RowBox[{
     FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], "US dollars", 
   "\"USDollars\""},
  "QuantityPrefix"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"ac002980-b7f2-40b6-ba92-60c79785afa8"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s another example, involving locations.", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"dda2eebf-41ed-443f-9d59-cc03e40c1fe5"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Interpreter",
   BaseStyle->"Link"]], "InlineCode",ExpressionUUID->
  "94a36530-0e87-4a7a-bbd0-e17bae10340a"],
 " gives the ",
 "geo location",
 " of the White House:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7c3fff92-335f-4eaa-80b3-90489297e4ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<Location\>\"", "]"}], "[", 
  "\"\<White House\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"9e3598b4-b50c-43a8-a469-9068f3a0be2e"],

Cell[BoxData[
 RowBox[{"GeoPosition", "[", 
  RowBox[{"{", 
   RowBox[{"38.89767`", ",", 
    RowBox[{"-", "77.03655`"}]}], "}"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[6]=",ExpressionUUID->"45783cb2-0208-4ef0-81e1-0e3b7799bc79"]
}, Open  ]],

Cell["It can also work from a street address:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:212", "i:9"},ExpressionUUID->"cd5f6d09-a482-4aca-a0ed-b905d15990c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<Location\>\"", "]"}], "[", 
  "\"\<1600 Pennsylvania Avenue, Washington, DC\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"5a5a600a-af35-4a85-914b-5e4b21338447"],

Cell[BoxData[
 RowBox[{"GeoPosition", "[", 
  RowBox[{"{", 
   RowBox[{"38.89767`", ",", 
    RowBox[{"-", "77.03655`"}]}], "}"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"451a0293-e1ee-4761-bb8d-808a3f64f124"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " handles many hundreds of different types of objects. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b0ad3666-debe-490b-a3d4-56f030ff0fe3"],

Cell["\<\
Interpret names of universities (which \[OpenCurlyDoubleQuote]U of I\
\[CloseCurlyDoubleQuote] is picked depends on geo location):\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"a94eac7b-fad1-4659-8735-62e47d3ffac8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<University\>\"", "]"}], "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<Harvard\>\"", ",", "\"\<Stanford\>\"", ",", "\"\<U of I\>\""}], "}"}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"318c5360-2996-4d22-ab36-f9515024bfe7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"Harvard University\"", 
     RowBox[{"Entity", "[", 
       RowBox[{"\"University\"", ",", "\"HarvardUniversity166027\""}], "]"}], 
     "\"Entity[\\\"University\\\", \\\"HarvardUniversity166027\\\"]\"", 
     "\"university\""},
    "Entity"], ",", 
   TemplateBox[{"\"Stanford University\"", 
     RowBox[{"Entity", "[", 
       RowBox[{"\"University\"", ",", "\"StanfordUniversity243744\""}], "]"}],
      "\"Entity[\\\"University\\\", \\\"StanfordUniversity243744\\\"]\"", 
     "\"university\""},
    "Entity"], ",", 
   TemplateBox[{"\"University of Illinois at Urbana-Champaign\"", 
     RowBox[{"Entity", "[", 
       RowBox[{
        "\"University\"", ",", 
         "\"UniversityOfIllinoisAtUrbanaChampaign145637\""}], "]"}], 
     "\"Entity[\\\"University\\\", \
\\\"UniversityOfIllinoisAtUrbanaChampaign145637\\\"]\"", "\"university\""},
    "Entity"]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"6cabf4b6-d68c-4455-ab11-3107c885a175"]
}, Open  ]],

Cell["Interpret names of chemicals:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"9acc5de9-4910-47c6-8568-f2cde558ff56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpreter", "[", "\"\<Chemical\>\"", "]"}], "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<H2O\>\"", ",", "\"\<aspirin\>\"", ",", "\"\<CO2\>\"", ",", 
    "\"\<wolfram\>\""}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"1fa679c9-8fce-4385-b00e-9c0f514e1a79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"water\"", 
     RowBox[{"Entity", "[", 
       RowBox[{"\"Chemical\"", ",", "\"Water\""}], "]"}], 
     "\"Entity[\\\"Chemical\\\", \\\"Water\\\"]\"", "\"chemical\""},
    "Entity"], ",", 
   TemplateBox[{"\"aspirin\"", 
     RowBox[{"Entity", "[", 
       RowBox[{"\"Chemical\"", ",", "\"Aspirin\""}], "]"}], 
     "\"Entity[\\\"Chemical\\\", \\\"Aspirin\\\"]\"", "\"chemical\""},
    "Entity"], ",", 
   TemplateBox[{"\"carbon dioxide\"", 
     RowBox[{"Entity", "[", 
       RowBox[{"\"Chemical\"", ",", "\"CarbonDioxide\""}], "]"}], 
     "\"Entity[\\\"Chemical\\\", \\\"CarbonDioxide\\\"]\"", "\"chemical\""},
    "Entity"], ",", 
   TemplateBox[{"\"tungsten\"", 
     RowBox[{"Entity", "[", 
       RowBox[{"\"Chemical\"", ",", "\"Tungsten\""}], "]"}], 
     "\"Entity[\\\"Chemical\\\", \\\"Tungsten\\\"]\"", "\"chemical\""},
    "Entity"]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"95a05972-405a-4f4d-8267-b1145df39f2d"]
}, Open  ]],

Cell["Interpret names of animals, then get images of them:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"0c329e52-8ff1-4969-acad-22a39f64d16a"],

Cell[BoxData[
 RowBox[{"EntityValue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Interpreter", "[", "\"\<Animal\>\"", "]"}], "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<cheetah\>\"", ",", "\"\<tiger\>\"", ",", "\"\<elephant\>\""}], 
     "}"}], "]"}], ",", "\"\<Image\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"24dee1c6-63f5-44d2-854e-7bd5b5cab093"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJy0vAd4XOWdxjubbLLZJJsGSUgCpNG7cQFccMdNLpIl2VbvI2l6OXN6b3PK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      "], {{0, 150}, {100, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag[
     "Byte", ColorSpace -> "RGB", Interleaving -> True, 
      MetaInformation -> {
       "Source" -> "http://en.wikipedia.org/wiki/File:TheCheethcat.jpg", 
        "URL" -> 
        "http://www.wolframcdn.com/waimage/hset050/aa9/\
aa9c513a300dd7ae89ed46a0d6dc83fe_v001s.jpg"}],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSize->{76.66796875, Automatic},
    ImageSizeRaw->{100, 150},
    PlotRange->{{0, 100}, {0, 150}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJwku2dwm3ea5UtbOQcqUpREkRLFnCNIggQIIuecc8455xwIgDnnIIrK0bIt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      "], {{0, 87}, {150, 0}}, {0, 
      255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag[
     "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
      Association[
       "Source" -> 
        "http://www.worldatlas.com/articles/countries-with-the-greatest-\
number-of-wild-tigers.html", "URL" -> 
        "http://www.test.wolframcdn.com/waimage/hset050/4e2/\
4e276f93edfd06a4e3bf0369729a95f7_v001s.jpg"]],
     Selectable->False],
    DefaultBaseStyle->"ImageGraphics",
    ImageSize->{129.515625, Automatic},
    ImageSizeRaw->{150, 87},
    PlotRange->{{0, 150}, {0, 87}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJxkvHd0XVWe/SnnTM5UFQUUqYDCYGycs2zZyjnHl3POOecc9ZSDZUkOYKAA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      "], {{0, 113}, {150, 0}}, {0, 255},
      
      ColorFunction->RGBColor],
     BoxForm`ImageTag[
     "Byte", ColorSpace -> "RGB", Interleaving -> True, 
      MetaInformation -> {
       "Source" -> "http://www.eol.org/pages/1644", "URL" -> 
        "http://www.wolframcdn.com/waimage/hset050/e1d/\
e1d32486864183b1554fe999b6e85710_v001s.jpg"}],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSize->{101.22265625, Automatic},
    ImageSizeRaw->{150, 113},
    PlotRange->{{0, 150}, {0, 113}}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"b6b702a4-4c3f-45db-a32d-3b3c485d591b"],

Cell[TextData[{
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " interprets whole strings. ",
 ButtonBox["TextCases",
  BaseStyle->"Link"],
 ", on the other hand, tries to pick out instances of what you request from a \
string. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"713182c5-c005-4da9-9430-b74d7dbee386"],

Cell["Pick out the nouns in a piece of text:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"a9c10471-a5bb-4f1a-a282-07276d1d6464"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TextCases", "[", 
  RowBox[{
  "\"\<A sentence is a linguistic construct\>\"", ",", "\"\<Noun\>\""}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"99786ce4-c8f2-4a6d-8cfc-70256782047d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"sentence\"\>", ",", "\<\"construct\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"e8458607-90ea-4b39-bf98-c17f4abbe05a"]
}, Open  ]],

Cell["Pick out currency amounts:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a1205144-6e99-4f2e-8e0a-ab628f8369ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TextCases", "[", 
  RowBox[{
  "\"\<Choose between $5, \[Euro]5 and \[Yen]5000\>\"", ",", 
   "\"\<CurrencyAmount\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"6bc1a60f-c85f-4c68-89ba-65f023f0b40d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"$5\"\>", ",", "\<\"\[Euro]5\"\>", ",", "\<\"\[Yen]5000\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[12]=",ExpressionUUID->"f96312ad-0145-45b9-8de0-5e52f6d31476"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 ButtonBox["TextCases",
  BaseStyle->"Link"],
 " to pick out particular kinds of things from a piece of text. Here we pick \
out instances of country names in a Wikipedia article."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:213", "i:15"},ExpressionUUID->"08f7c19c-92fc-4cc0-a57e-f12126ae9684"],

Cell["\<\
Generate a word cloud of country names from the Wikipedia article on the EU:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c48a2c98-8e22-4231-a3cd-f7956e37ecdd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordCloud", "[", 
  RowBox[{"TextCases", "[", 
   RowBox[{
    RowBox[{"WikipediaData", "[", "\"\<EU\>\"", "]"}], ",", 
    "\"\<Country\>\""}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellTags->"i:16",
 CellLabel->"In[13]:=",ExpressionUUID->"d1682103-8364-4f13-940c-e2566e8e7993"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     StyleBox["\<\"the United Kingdom\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.11350059737156512`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {0, 0}], InsetBox[
     StyleBox["\<\"France\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.12544802867383512`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {-0.5, 52.5}], 
    InsetBox[
     StyleBox["\<\"German\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.1015531660692951],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {-0.5, -48.5}], 
    InsetBox[
     StyleBox["\<\"Germany\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.07765830346475508],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {5.5, -88.5}], 
    InsetBox[
     StyleBox["\<\"Denmark\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.07765830346475508],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {21.5, 88.5}], 
    InsetBox[
     StyleBox["\<\"Netherlands\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.06571087216248506],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.571589, 0.586483, 0.]], {-0.5, 121.5}], InsetBox[
     StyleBox["\<\"Luxembourg\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.053763440860215055`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.40082222609352647`, 0.5220066643438841, 0.85]], {-12.5, -118.5}], 
    InsetBox[
     StyleBox["\<\"Cyprus\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.06571087216248506],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {-6.5, -148.5}], 
    InsetBox[
     StyleBox["\<\"Iceland\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.06571087216248506],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {-160.5, -39.5}], 
    InsetBox[
     StyleBox["\<\"Greek\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.06571087216248506],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[1, 0.75, 0]], {-135.5, -80.5}], InsetBox[
     StyleBox["\<\"Sweden\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.053763440860215055`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28026441037696703`, 0.715, 0.4292089322474965]], {-0.5, 150.5}], 
    InsetBox[
     StyleBox["\<\"Kosovo\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.053763440860215055`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-117.5, 97.5}], InsetBox[
     StyleBox["\<\"US\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.07765830346475508],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {135.5, 33.5}], 
    InsetBox[
     StyleBox["\<\"Spain\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.053763440860215055`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.736782672705901, 0.358, 0.5030266573755369]], {140.5, -43.5}], 
    InsetBox[
     StyleBox["\<\"Lithuania\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.04181600955794504],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.28240003484173815`, 0.6090799721266095, 
        0.7538800418100857]], {-155.5, 38.5}], InsetBox[
     StyleBox["\<\"Malta\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.053763440860215055`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9728288904374106, 0.621644452187053, 
        0.07336199581899142]], {132.5, -81.5}], InsetBox[
     StyleBox["\<\"Bulgaria\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.04181600955794504],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.838355547812947, 0.44746667828057946`, 
        0.0208888695323676]], {-150.5, 59.5}], InsetBox[
     StyleBox["\<\"Norway\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.04181600955794504],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9324333565611593, 0.5282889043741062, 
        0.0921900209050434]], {150.5, 62.5}], InsetBox[
     StyleBox["\<\"Estonia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.04181600955794504],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8996399512215667, 0.7463488834690629, 0.]], {130.5, -106.5}], 
    InsetBox[
     StyleBox["\<\"Liechtenstein\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7678998606330495, 0.7317110956258943, 0.]], {122.5, -125.5}], 
    InsetBox[
     StyleBox["\<\"Czech\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.04181600955794504],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5833680111493557, 0.4126186601628758, 
        0.8290799721266107]], {143.5, 83.5}], InsetBox[
     StyleBox["\<\"Switzerland\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.23716678280579248`, 0.645266573755366, 
        0.699600139366951]], {-140.5, -103.5}], InsetBox[
     StyleBox["\<\"Bosnia and Herzegovina\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9784200278733908, 0.649600139366954, 
        0.058265924741844846`]], {107.5, -142.5}], InsetBox[
     StyleBox["\<\"Greenland\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9874666782805795, 0.6948333914028977, 
        0.033839968642435214`]], {-104.5, -139.5}], InsetBox[
     StyleBox["\<\"Hungarian\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7748409210981391, 0.358, 0.4444755060028629]], {93.5, 146.5}], 
    InsetBox[
     StyleBox["\<\"Bulgarian\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5407932311309059, 0.715, 0.09762679674248334]], {135.5, 107.5}], 
    InsetBox[
     StyleBox["\<\"Romania\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.37977756485605163`, 0.715, 0.3025558265468435]], {-91.5, 146.5}], 
    InsetBox[
     StyleBox["\<\"Slovakia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5472001045252132, 0.43417993728487203`, 0.85]], {-130.5, -120.5}], 
    InsetBox[
     StyleBox["\<\"Slovenia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9810598048862722, 0.7553955338762525, 0.]], {-132.5, 120.5}], 
    InsetBox[
     StyleBox["\<\"Portugal\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7132613816472081, 0.358, 0.5392132590042952]], {84.5, -157.5}], 
    InsetBox[
     StyleBox["\<\"Spanish\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8168067340273636, 0.3521386531945273, 
        0.3761554432877274]], {129.5, 127.5}], InsetBox[
     StyleBox["\<\"Belgium\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6753413537738198, 0.3589675436319385, 
        0.5991466155654507]], {-96.5, -156.5}], InsetBox[
     StyleBox["\<\"Scottish\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8564488486273256, 0.42032672705901153`, 
        0.06612212156831418]], {194.5, -63.5}], InsetBox[
     StyleBox["\<\"Italy\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.04181600955794504],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8439466852489265, 0.3467106629502147, 
        0.3309221912517893]], {-148.5, 139.5}], InsetBox[
     StyleBox["\<\"Maltese\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8878600487784333, 0.33792799024431336`, 
        0.2577332520359445]], {203.5, 37.5}], InsetBox[
     StyleBox["\<\"English\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8857244243136628, 0.3764133635295058, 
        0.1393110607841571]], {208.5, -30.5}], InsetBox[
     StyleBox["\<\"Finnish\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.47401116530937026`, 0.47809330081437784`, 0.85]], {-194.5, 79.5}], 
    InsetBox[
     StyleBox["\<\"Poland\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.35558897405758294`, 0.5505288207539337, 
        0.8417067688690995]], {199.5, -80.5}], InsetBox[
     StyleBox["\<\"Ireland\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.16397784358994957`, 0.7038177251280403, 
        0.6117734123079395]], {158.5, 144.5}], InsetBox[
     StyleBox["\<\"Welsh\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9052934053395919, 0.510195603559728, 
        0.06776406480563275]], {-192.5, 96.5}], InsetBox[
     StyleBox["\<\"Latvia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6184987019729621, 0.39212575718243875`, 
        0.7412532450675947]], {140.5, -158.5}], InsetBox[
     StyleBox["\<\"Polish\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9637822400302223, 0.5764112001511111, 
        0.0977879519184]], {200.5, 77.5}], InsetBox[
     StyleBox["\<\"Montenegro\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6319174318193065, 0.38429816477207124`, 
        0.7077064204517338]], {81.5, 161.5}], InsetBox[
     StyleBox["\<\"Portuguese\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9046334610863751, 0.334573307782725, 
        0.22977756485604156`]], {34.5, -23.5}], InsetBox[
     StyleBox["\<\"Macedonia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.19193353076984873`, 0.681453175384121, 
        0.6453202369238185]], {-131.5, -59.5}], InsetBox[
     StyleBox["\<\"Romanian\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.38354466123747527`, 0.5323732032575149, 0.85]], {-130.5, 77.5}], 
    InsetBox[
     StyleBox["\<\"Lithuanian\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7896667828057927, 0.3575666434388414, 
        0.4213886953236787]], {-79.5, 161.5}], InsetBox[
     StyleBox["\<\"Irish\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.029868578255675033`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8613800418100862, 0.48092002787339083`, 
        0.02824203762907758]], {187.5, -97.5}], InsetBox[
     StyleBox["\<\"Iceland's\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5019668524892619, 0.46131988850644284`, 0.85]], {-125.5, 161.5}], 
    InsetBox[
     StyleBox["\<\"America\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6361597700445392, 0.7170733077827265, 0.]], {131.5, 160.5}], InsetBox[
     StyleBox["\<\"Swedish\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9307395679624266, 0.7498043964402695, 0.]], {-202.5, -59.5}], 
    InsetBox[
     StyleBox["\<\"Poland's\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7175796237092107, 0.7261199581899123, 0.]], {202.5, -46.5}], InsetBox[
     StyleBox["\<\"Hungary\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8745421494417032, 0.39318677583744527`, 
        0.11135537360425793`]], {-165.5, -132.5}], InsetBox[
     StyleBox["\<\"Croatian\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8493197142977551, 0.7407577460330839, 0.]], {-148.5, -153.5}], 
    InsetBox[
     StyleBox["\<\"Andorra\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9038177251280404, 0.3492734123079395, 
        0.18454431282010084`]], {190.5, 96.5}], InsetBox[
     StyleBox["\<\"Slovene\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.845266573755366, 0.437100139366951, 
        0.03816643438841502]], {209.5, 52.5}], InsetBox[
     StyleBox["\<\"Monaco\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8781534541180211, 0.4921023027453475, 
        0.04333810870621905]], {180.5, 118.5}], InsetBox[
     StyleBox["\<\"Vatican\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.26512246998569167`, 0.6229020240114467, 
        0.73314696398283]], {-182.5, -117.5}], InsetBox[
     StyleBox["\<\"Guyana\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.47929071933511125`, 0.715, 0.1759027208462221]], {-205.5, -71.5}], 
    InsetBox[
     StyleBox["\<\"Albania\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6536293927965667, 0.37163285420200276`, 
        0.6534265180085832]], {-187.5, 111.5}], InsetBox[
     StyleBox["\<\"Croatia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.596786740995709, 0.404791067752503, 
        0.7955331475107271]], {188.5, -110.5}], InsetBox[
     StyleBox["\<\"Turkey\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8335801463353031, 0.3487839707329394, 
        0.3481997561078282]], {-211.5, 58.5}], InsetBox[
     StyleBox["\<\"Greece\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.6897400905885174, 0.358, 0.5753998606330502]], {-204.5, -83.5}], 
    InsetBox[
     StyleBox["\<\"Finland\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9492067688690977, 0.5394711792460651, 
        0.10728609198218791`]], {-221.5, 24.5}], InsetBox[
     StyleBox["\<\"Austria\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.428777913273419, 0.5052332520359486, 0.85]], {-184.5, 123.5}], 
    InsetBox[
     StyleBox["\<\"Slovak\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.31827505306025683`, 0.715, 0.3808317506505822]], {-220.5, 36.5}], 
    InsetBox[
     StyleBox["\<\"Russia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.969373377466199, 0.6043668873309952, 
        0.08269188084126262]], {-202.5, -95.5}], InsetBox[
     StyleBox["\<\"Danish\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8607200975568693, 0.34335598048862614`, 
        0.30296650407188447`]], {189.5, -122.5}], InsetBox[
     StyleBox["\<\"Suisse\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.5750747800184488, 0.4174563783225715, 
        0.8498130499538777]], {-162.5, 157.5}], InsetBox[
     StyleBox["\<\"Britain\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7513196300394465, 0.358, 0.48066210763162087`]], {187.5, 128.5}], 
    InsetBox[
     StyleBox["\<\"Serbia\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.7277983389807635, 0.358, 0.5168487092603637]], {180.5, -138.5}], 
    InsetBox[
     StyleBox["\<\"China\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.8342400905885153, 0.4628267270590103, 
        0.0038160815296638794`]], {-41.5, 23.5}], InsetBox[
     StyleBox["\<\"British\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.2187618985811806, 0.715, 0.5074848563512248]], {-185.5, 135.5}], 
    InsetBox[
     StyleBox["\<\"Dutch\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.3103557220216354, 0.5867154223826917, 
        0.7874268664259625]], {166.5, 158.5}], InsetBox[
     StyleBox["\<\"Iraq\"\>",
      StripOnInput->False,
      FontFamily->"Helvetica",
      FontSize->Scaled[0.017921146953405017`],
      FontWeight->Plain,
      FontSlant->Plain,
      FontTracking->"Plain",
      FontColor->RGBColor[
       0.9930578157165594, 0.7227890785827968, 
        0.01874389756528967]], {17.5, 0.5}]}},
  ImageSize->{239.671875, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-281., 277.}, {-169., 169.}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"5233a43f-3e7c-4996-9d39-eba49fa5b4f7"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["TextStructure",
  BaseStyle->"Link"],
 " shows you the whole structure of a piece of text. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"db2e8590-936e-464a-8814-dce6bcefa4b5"],

Cell["\<\
Find how a sentence of English can be parsed into grammatical units:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d961d9c4-026d-438a-b6fd-b5ed76c93a07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TextStructure", "[", 
  "\"\<You can do so much with the Wolfram Language.\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"b8fbb8f6-7d4f-4b25-a9ca-8556620a508f"],

Cell[BoxData[
 InterpretationBox[
  TagBox[GridBox[{
     {
      InterpretationBox[GridBox[{
         {
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            InterpretationBox[
             GridBox[{{
                TemplateBox[{"\[ThinSpace]", "\" \"", 
                  InterpretationBox[
                   GridBox[{{"\"You\""}, {
                    StyleBox["\"Pronoun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                   TextElement["You", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Pronoun"]]]]}, 
                 "RowWithSeparators"]}, {
                StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, BaseStyle -> 
              "TextElementGrid"], 
             TextElement[{
               TextElement["You", 
                Association[
                "GrammaticalUnit" -> Entity["GrammaticalUnit", "Pronoun"]]]}, 
              
              Association[
              "GrammaticalUnit" -> Entity["GrammaticalUnit", "NounPhrase"]]]], 
            InterpretationBox[
             GridBox[{{
                TemplateBox[{"\[ThinSpace]", "\" \"", 
                  InterpretationBox[
                   GridBox[{{"\"can\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                   TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                  InterpretationBox[
                   GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"do\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["do", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"so\""}, {
                    StyleBox["\"Adverb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["so", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"much\""}, {
                    StyleBox["\"Adverb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["much", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Adverb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["so", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]], 
                    TextElement["much", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"with\""}, {
                    StyleBox["\"Preposition\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["with", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"the\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["the", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"Wolfram\""}, {
                    StyleBox["\"Proper Noun\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["Wolfram", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "ProperNoun"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"Language\""}, {
                    StyleBox["\"Proper Noun\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["Language", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "ProperNoun"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["the", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["Wolfram", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]], 
                    TextElement["Language", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox[
                    "\"Prepositional Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["with", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["the", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["Wolfram", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]], 
                    TextElement["Language", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                   TextElement[{
                    TextElement["do", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["so", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]], 
                    TextElement["much", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]], 
                    TextElement[{
                    TextElement["with", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["the", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["Wolfram", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]], 
                    TextElement["Language", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]]}, 
                 "RowWithSeparators"]}, {
                StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, BaseStyle -> 
              "TextElementGrid"], 
             TextElement[{
               TextElement["can", 
                Association[
                "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
               TextElement[{
                 TextElement["do", 
                  Association[
                  "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                 TextElement[{
                   TextElement["so", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]], 
                   TextElement["much", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "AdverbPhrase"]]], 
                 TextElement[{
                   TextElement["with", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]], 
                   TextElement[{
                    TextElement["the", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["Wolfram", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]], 
                    TextElement["Language", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "ProperNoun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                Association[
                "GrammaticalUnit" -> 
                 Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
              Association[
              "GrammaticalUnit" -> Entity["GrammaticalUnit", "VerbPhrase"]]]], 
            InterpretationBox[
             GridBox[{{"\".\""}, {
                StyleBox["\"Punctuation\"", "TextElementLabel"]}}, BaseStyle -> 
              "TextElementGrid"], 
             TextElement[".", 
              Association[
              "GrammaticalUnit" -> 
               Entity["GrammaticalUnit", "Punctuation"]]]]},
           "RowWithSeparators"]},
         {
          StyleBox["\<\"Sentence\"\>", "TextElementLabel"]}
        },
        BaseStyle->"TextElementGrid"],
       TextElement[{
         TextElement[{
           TextElement["You", 
            Association[
            "GrammaticalUnit" -> Entity["GrammaticalUnit", "Pronoun"]]]}, 
          Association[
          "GrammaticalUnit" -> Entity["GrammaticalUnit", "NounPhrase"]]], 
         TextElement[{
           TextElement["can", 
            Association[
            "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
           TextElement[{
             TextElement["do", 
              Association[
              "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
             TextElement[{
               TextElement["so", 
                Association[
                "GrammaticalUnit" -> Entity["GrammaticalUnit", "Adverb"]]], 
               TextElement["much", 
                Association[
                "GrammaticalUnit" -> Entity["GrammaticalUnit", "Adverb"]]]}, 
              Association[
              "GrammaticalUnit" -> 
               Entity["GrammaticalUnit", "AdverbPhrase"]]], 
             TextElement[{
               TextElement["with", 
                Association[
                "GrammaticalUnit" -> 
                 Entity["GrammaticalUnit", "Preposition"]]], 
               TextElement[{
                 TextElement["the", 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "Determiner"]]], 
                 TextElement["Wolfram", 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "ProperNoun"]]], 
                 TextElement["Language", 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "ProperNoun"]]]}, 
                Association[
                "GrammaticalUnit" -> 
                 Entity["GrammaticalUnit", "NounPhrase"]]]}, 
              Association[
              "GrammaticalUnit" -> 
               Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
            Association[
            "GrammaticalUnit" -> Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
          Association[
          "GrammaticalUnit" -> Entity["GrammaticalUnit", "VerbPhrase"]]], 
         TextElement[".", 
          Association[
          "GrammaticalUnit" -> Entity["GrammaticalUnit", "Punctuation"]]]}, 
        Association[
        "GrammaticalUnit" -> Entity["GrammaticalUnit", "Sentence"]]]]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  TextElement[{
    TextElement[{
      TextElement[{
        TextElement["You", 
         Association[
         "GrammaticalUnit" -> Entity["GrammaticalUnit", "Pronoun"]]]}, 
       Association[
       "GrammaticalUnit" -> Entity["GrammaticalUnit", "NounPhrase"]]], 
      TextElement[{
        TextElement["can", 
         Association["GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
        TextElement[{
          TextElement["do", 
           Association[
           "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
          TextElement[{
            TextElement["so", 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "Adverb"]]], 
            TextElement["much", 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "Adverb"]]]}, 
           Association[
           "GrammaticalUnit" -> Entity["GrammaticalUnit", "AdverbPhrase"]]], 
          TextElement[{
            TextElement["with", 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "Preposition"]]], 
            
            TextElement[{
              TextElement["the", 
               Association[
               "GrammaticalUnit" -> Entity["GrammaticalUnit", "Determiner"]]], 
              TextElement["Wolfram", 
               Association[
               "GrammaticalUnit" -> Entity["GrammaticalUnit", "ProperNoun"]]], 
              TextElement["Language", 
               Association[
               "GrammaticalUnit" -> 
                Entity["GrammaticalUnit", "ProperNoun"]]]}, 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "NounPhrase"]]]}, 
           
           Association[
           "GrammaticalUnit" -> 
            Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
         Association[
         "GrammaticalUnit" -> Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
       Association[
       "GrammaticalUnit" -> Entity["GrammaticalUnit", "VerbPhrase"]]], 
      TextElement[".", 
       Association[
       "GrammaticalUnit" -> Entity["GrammaticalUnit", "Punctuation"]]]}, 
     Association[
     "GrammaticalUnit" -> 
      Entity["GrammaticalUnit", "Sentence"]]]}]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"0b3b9fdf-57ef-4f62-8618-60edb84486ea"]
}, Open  ]],

Cell["An alternative representation, as a graph:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"c70c820f-6ba2-43c0-82e5-603f81a6de57"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TextStructure", "[", 
  RowBox[{
  "\"\<You can do so much with the Wolfram Language.\>\"", ",", 
   "\"\<ConstituentGraphs\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"9b5d2ba0-4990-4c53-a04a-e03c7d7dbd93"],

Cell[BoxData[
 RowBox[{"{", 
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{
       "PRP1", "You1", "NP1", "MD1", "can1", "VB1", "do1", "RB1", "so1", 
        "RB2", "much1", "ADVP1", "IN1", "with1", "DT1", "the1", "NNP1", 
        "Wolfram1", "NNP2", "Language1", "NP2", "PP1", "VP2", "VP1", ".1", 
        ".2", "S1"}, {
       Null, {{1, 2}, {3, 1}, {4, 5}, {6, 7}, {8, 9}, {10, 11}, {12, 8}, {12, 
        10}, {13, 14}, {15, 16}, {17, 18}, {19, 20}, {21, 15}, {21, 17}, {21, 
        19}, {22, 13}, {22, 21}, {23, 6}, {23, 12}, {23, 22}, {24, 4}, {24, 
        23}, {25, 26}, {27, 3}, {27, 24}, {27, 25}}}, {EdgeStyle -> {
          GrayLevel[0.65]}, 
        GraphLayout -> {
         "LayeredEmbedding", "RootVertex" -> "S1", 
          LayerSizeFunction -> (0.5& )}, ImageSize -> 540, 
        VertexLabels -> {"PRP1" -> Placed[
            Framed[
             Style["Pronoun", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "S1" -> Placed[
            Framed[
             Style["Sentence", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "Language1" -> Placed[
            Framed[
             Style["Language", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "much1" -> Placed[
            Framed[
             Style["much", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "RB2" -> Placed[
            Framed[
             Style["Adverb", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "VP2" -> Placed[
            Framed[
             Style["Verb Phrase", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "MD1" -> Placed[
            Framed[
             Style["Verb", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "PP1" -> Placed[
            Framed[
             Style["Prepositional Phrase", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "with1" -> Placed[
            Framed[
             Style["with", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "do1" -> Placed[
            Framed[
             Style["do", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "VP1" -> Placed[
            Framed[
             Style["Verb Phrase", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "RB1" -> Placed[
            Framed[
             Style["Adverb", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "NP1" -> Placed[
            Framed[
             Style["Noun Phrase", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "can1" -> Placed[
            Framed[
             Style["can", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "IN1" -> Placed[
            Framed[
             Style["Preposition", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "VB1" -> Placed[
            Framed[
             Style["Verb", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "NP2" -> Placed[
            Framed[
             Style["Noun Phrase", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], ".1" -> Placed[
            Framed[
             Style["Punctuation", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "You1" -> Placed[
            Framed[
             Style["You", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "so1" -> Placed[
            Framed[
             Style["so", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "Wolfram1" -> Placed[
            Framed[
             Style["Wolfram", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "DT1" -> Placed[
            Framed[
             Style["Determiner", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "the1" -> Placed[
            Framed[
             Style["the", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "ADVP1" -> Placed[
            Framed[
             Style["Adverb Phrase", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "NNP1" -> Placed[
            Framed[
             Style["Proper Noun", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], "NNP2" -> Placed[
            Framed[
             Style["Proper Noun", 
              GrayLevel[0.55]], Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center], ".2" -> Placed[
            Framed[
             Style[".", FontFamily -> "Arial", FontSize -> Medium], 
             Background -> Directive[
               GrayLevel[1], 
               Opacity[1]], RoundingRadius -> 2, 
             FrameMargins -> {{0, 0}, {-1, -2}}, FrameStyle -> Directive[
               GrayLevel[1], 
               Opacity[0]]], Center]}, VertexSize -> {0}, VertexStyle -> {
          Directive[
           GrayLevel[1], 
           Opacity[0]]}}]]}, 
     TagBox[GraphicsGroupBox[{
        {GrayLevel[0.65], Opacity[0.7], LineBox[CompressedData["
1:eJxTTMoPSmVmYGCQAmImKIaBT8m6Fhckf9vD+F+5lLRigr/Y45Ivj5NRVvrA
4IDOh9EQ/SwOH8H6XtvD9MP4MPPR5dHN+QgVR1X/G6r+tT12eW6HTyjiLA6f
UOxlcfgA5t/GkC/erm44bRu7A3bzXsP5MP3o8uj68ZsH868AXD+MDzMfXR5i
jgjcPBgf1T8iDqjxiJCHuEcczb3iGPIw/bjkUcNDGi08pOH60eVx2U/If7jC
D3t4ItIPLhoW77DwRZUXwIgfXPoBumksqQ==
          "]]}, 
        {GrayLevel[1], Opacity[0], EdgeForm[{GrayLevel[0], Opacity[
         0.7]}], {DiskBox[{0., 1.6938020891595866}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Pronoun\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {0., 1.6938020891595866},
           BaseStyle->"Graphics"]}, {DiskBox[{0., 1.2703515668696899}, 0.], 
          InsetBox[
           FrameBox[
            StyleBox["\<\"You\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {0., 1.2703515668696899},
           BaseStyle->"Graphics"]}, {DiskBox[{0., 2.117252611449483}, 0.], 
          InsetBox[
           FrameBox[
            StyleBox["\<\"Noun Phrase\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {0., 2.117252611449483},
           BaseStyle->"Graphics"]}, {
          DiskBox[{0.8469010445797932, 1.6938020891595866}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Verb\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {0.8469010445797932, 1.6938020891595866},
           BaseStyle->"Graphics"]}, {
          DiskBox[{0.8469010445797932, 1.2703515668696899}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"can\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {0.8469010445797932, 1.2703515668696899},
           BaseStyle->"Graphics"]}, {
          DiskBox[{1.6938020891595864, 1.2703515668696899}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Verb\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {1.6938020891595864, 1.2703515668696899},
           BaseStyle->"Graphics"]}, {
          DiskBox[{1.6938020891595864, 0.8469010445797933}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"do\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {1.6938020891595864, 0.8469010445797933},
           BaseStyle->"Graphics"]}, {
          DiskBox[{2.5407031337393797, 0.8469010445797933}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Adverb\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {2.5407031337393797, 0.8469010445797933},
           BaseStyle->"Graphics"]}, {
          DiskBox[{2.5407031337393797, 0.42345052228989655}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"so\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {2.5407031337393797, 0.42345052228989655},
           BaseStyle->"Graphics"]}, {
          DiskBox[{3.387604178319173, 0.8469010445797933}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Adverb\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {3.387604178319173, 0.8469010445797933},
           BaseStyle->"Graphics"]}, {
          DiskBox[{3.387604178319173, 0.42345052228989655}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"much\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {3.387604178319173, 0.42345052228989655},
           BaseStyle->"Graphics"]}, {
          DiskBox[{2.9641536560292763, 1.2703515668696899}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Adverb Phrase\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {2.9641536560292763, 1.2703515668696899},
           BaseStyle->"Graphics"]}, {
          DiskBox[{4.234505222898966, 0.8469010445797933}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Preposition\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {4.234505222898966, 0.8469010445797933},
           BaseStyle->"Graphics"]}, {
          DiskBox[{4.234505222898966, 0.42345052228989655}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"with\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {4.234505222898966, 0.42345052228989655},
           BaseStyle->"Graphics"]}, {
          DiskBox[{5.0814062674787595, 0.42345052228989655}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Determiner\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {5.0814062674787595, 0.42345052228989655},
           BaseStyle->"Graphics"]}, {DiskBox[{5.0814062674787595, 0.}, 0.], 
          InsetBox[
           FrameBox[
            StyleBox["\<\"the\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {5.0814062674787595, 0.},
           BaseStyle->"Graphics"]}, {
          DiskBox[{5.9283073120585525, 0.42345052228989655}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Proper Noun\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {5.9283073120585525, 0.42345052228989655},
           BaseStyle->"Graphics"]}, {DiskBox[{5.9283073120585525, 0.}, 0.], 
          InsetBox[
           FrameBox[
            StyleBox["\<\"Wolfram\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {5.9283073120585525, 0.},
           BaseStyle->"Graphics"]}, {
          DiskBox[{6.775208356638346, 0.42345052228989655}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Proper Noun\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {6.775208356638346, 0.42345052228989655},
           BaseStyle->"Graphics"]}, {DiskBox[{6.775208356638346, 0.}, 0.], 
          InsetBox[
           FrameBox[
            StyleBox["\<\"Language\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {6.775208356638346, 0.},
           BaseStyle->"Graphics"]}, {
          DiskBox[{5.9283073120585525, 0.8469010445797933}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Noun Phrase\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {5.9283073120585525, 0.8469010445797933},
           BaseStyle->"Graphics"]}, {
          DiskBox[{5.0814062674787595, 1.2703515668696899}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Prepositional Phrase\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {5.0814062674787595, 1.2703515668696899},
           BaseStyle->"Graphics"]}, {
          DiskBox[{3.387604178319173, 1.6938020891595866}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Verb Phrase\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {3.387604178319173, 1.6938020891595866},
           BaseStyle->"Graphics"]}, {
          DiskBox[{2.117252611449483, 2.117252611449483}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Verb Phrase\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {2.117252611449483, 2.117252611449483},
           BaseStyle->"Graphics"]}, {
          DiskBox[{4.234505222898966, 2.117252611449483}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Punctuation\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {4.234505222898966, 2.117252611449483},
           BaseStyle->"Graphics"]}, {
          DiskBox[{4.234505222898966, 1.6938020891595866}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\".\"\>",
             StripOnInput->False,
             FontFamily->"Arial",
             FontSize->Medium],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {4.234505222898966, 1.6938020891595866},
           BaseStyle->"Graphics"]}, {
          DiskBox[{2.117252611449483, 2.5407031337393797}, 0.], InsetBox[
           FrameBox[
            StyleBox["\<\"Sentence\"\>",
             StripOnInput->False,
             FontColor->GrayLevel[0.55],
             $CellContext`LineColor -> GrayLevel[0.55],
             $CellContext`FrontFaceColor -> GrayLevel[0.55],
             $CellContext`GraphicsColor -> GrayLevel[0.55],
             $CellContext`BackFaceColor -> GrayLevel[0.55]],
            Background->Directive[
              GrayLevel[1], 
              Opacity[1]],
            FrameMargins->{{0, 0}, {-1, -2}},
            FrameStyle->Directive[
              GrayLevel[1], 
              Opacity[0]],
            RoundingRadius->2,
            StripOnInput->False], {2.117252611449483, 2.5407031337393797},
           BaseStyle->"Graphics"]}}}],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FormatType->TraditionalForm,
   FrameTicks->None,
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->540], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"02fc6c6c-0557-422f-837b-0a8366c7183a"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCodeText",ExpressionUUID->
  "6d82e58f-83ed-4162-beef-7c67fe36e4c4"],
 " gives a lists of common words. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", "\<\"Noun\"\>", "]"}]], "InlineCodeText",
  ExpressionUUID->"681b8d7d-4f1b-47be-8b38-debcf693d557"],
 ", etc. gives lists of words that can be used as particular parts of speech. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9ccd7d68-79fd-4163-bf52-2578118d052e"],

Cell["Give the first 20 in a list of common verbs in English:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"ec5836ec-9c80-4daf-b666-62d8c8d1048a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"WordList", "[", "\"\<Verb\>\"", "]"}], ",", "20"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"aa418404-74ef-41f1-b864-53e5275ad352"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aah\"\>", ",", "\<\"abandon\"\>", ",", "\<\"abase\"\>", 
   ",", "\<\"abash\"\>", ",", "\<\"abate\"\>", ",", "\<\"abbreviate\"\>", 
   ",", "\<\"abdicate\"\>", ",", "\<\"abduct\"\>", ",", "\<\"abet\"\>", 
   ",", "\<\"abhor\"\>", ",", "\<\"abide\"\>", ",", "\<\"abjure\"\>", 
   ",", "\<\"ablate\"\>", ",", "\<\"abnegate\"\>", ",", "\<\"abolish\"\>", 
   ",", "\<\"abominate\"\>", ",", "\<\"abort\"\>", ",", "\<\"abound\"\>", 
   ",", "\<\"abrade\"\>", ",", "\<\"abridge\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"561f3afd-f843-4987-acd1-dd3d1dcdb5a4"]
}, Open  ]],

Cell["\<\
It\[CloseCurlyQuote]s easy to study properties of words. Here are histograms \
comparing the length distributions of nouns, verbs and adjectives in the list \
of common words.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"94468068-e159-4b6d-806c-00a08a38e2e9"],

Cell["\<\
Make histograms of the lengths of common nouns, verbs and adjectives:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"4e187e05-a4b1-49e7-914f-64e88536d117"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Histogram", "[", 
    RowBox[{"StringLength", "[", 
     RowBox[{"WordList", "[", "#", "]"}], "]"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<Noun\>\"", ",", "\"\<Verb\>\"", ",", "\"\<Adjective\>\""}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"f5214a52-857e-409b-bb45-5a5d5dfbcf56"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
      Opacity[0.5389999999999999], Thickness[Small]}], {}, 
      {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
       EdgeForm[{Opacity[0.5389999999999999], Thickness[Small]}], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{0.5, 0}, {1.5, 1}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{27.507405924739796`, 34.5726581265012}, {
            32.21148721718191, 32.733706803340375`}}],
          StatusArea[#, 1]& ,
          TagBoxNote->"1"],
         StyleBox["1", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{1.5, 0}, {2.5, 32}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{34.0726581265012, 41.13791032826261}, {
            31.522680046269645`, 32.733706803340375`}}],
          StatusArea[#, 32]& ,
          TagBoxNote->"32"],
         StyleBox["32", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[32, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{2.5, 0}, {3.5, 499}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{40.63791032826261, 47.70316253002402}, {
            21.146133310268667`, 32.733706803340375`}}],
          StatusArea[#, 499]& ,
          TagBoxNote->"499"],
         StyleBox["499", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[499, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{3.5, 0}, {4.5, 1613}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{47.20316253002402, 
            54.26841473178543}, {-3.6064856702561414`, 32.733706803340375`}}],
          
          StatusArea[#, 1613]& ,
          TagBoxNote->"1613"],
         StyleBox["1613", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1613, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{4.5, 0}, {5.5, 2270}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{53.76841473178543, 
            60.83366693354684}, {-18.204753776364583`, 32.733706803340375`}}],
          
          StatusArea[#, 2270]& ,
          TagBoxNote->"2270"],
         StyleBox["2270", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[2270, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{5.5, 0}, {6.5, 3075}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{60.33366693354684, 
            67.39891913530825}, {-36.09152063392515, 32.733706803340375`}}],
          StatusArea[#, 3075]& ,
          TagBoxNote->"3075"],
         StyleBox["3075", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[3075, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{6.5, 0}, {7.5, 3652}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{66.89891913530825, 
            73.96417133706966}, {-48.91222184735677, 32.733706803340375`}}],
          StatusArea[#, 3652]& ,
          TagBoxNote->"3652"],
         StyleBox["3652", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[3652, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{7.5, 0}, {8.5, 3715}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{73.46417133706966, 
            80.52942353883107}, {-50.312055775339765`, 32.733706803340375`}}],
          
          StatusArea[#, 3715]& ,
          TagBoxNote->"3715"],
         StyleBox["3715", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[3715, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{8.5, 0}, {9.5, 3390}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{80.02942353883107, 
            87.09467574059248}, {-43.09069027384016, 32.733706803340375`}}],
          StatusArea[#, 3390]& ,
          TagBoxNote->"3390"],
         StyleBox["3390", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[3390, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{9.5, 0}, {10.5, 2525}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{86.59467574059248, 
            93.65992794235389}, {-23.870748246771967`, 32.733706803340375`}}],
          
          StatusArea[#, 2525]& ,
          TagBoxNote->"2525"],
         StyleBox["2525", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[2525, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{10.5, 0}, {11.5, 1736}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{93.15992794235389, 
            100.2251801441153}, {-6.339494767746764, 32.733706803340375`}}],
          StatusArea[#, 1736]& ,
          TagBoxNote->"1736"],
         StyleBox["1736", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1736, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{11.5, 0}, {12.5, 1112}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{99.7251801441153, 106.7904323458767}, {
            7.525526995132484, 32.733706803340375`}}],
          StatusArea[#, 1112]& ,
          TagBoxNote->"1112"],
         StyleBox["1112", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1112, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{12.5, 0}, {13.5, 745}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{106.2904323458767, 113.3556845476381}, {
            15.680115115287425`, 32.733706803340375`}}],
          StatusArea[#, 745]& ,
          TagBoxNote->"745"],
         StyleBox["745", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[745, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{13.5, 0}, {14.5, 392}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{112.8556845476381, 119.92093674939952`}, {
            23.523629029223926`, 32.733706803340375`}}],
          StatusArea[#, 392]& ,
          TagBoxNote->"392"],
         StyleBox["392", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[392, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{14.5, 0}, {15.5, 205}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{119.42093674939952`, 126.48618895116093`}, {
            27.67869164085601, 32.733706803340375`}}],
          StatusArea[#, 205]& ,
          TagBoxNote->"205"],
         StyleBox["205", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[205, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{15.5, 0}, {16.5, 96}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{125.98618895116093`, 133.05144115292234`}, {
            30.10062653212818, 32.733706803340375`}}],
          StatusArea[#, 96]& ,
          TagBoxNote->"96"],
         StyleBox["96", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[96, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{16.5, 0}, {17.5, 49}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{132.55144115292234`, 139.61669335468375`}, {
            31.14494708157582, 32.733706803340375`}}],
          StatusArea[#, 49]& ,
          TagBoxNote->"49"],
         StyleBox["49", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[49, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{17.5, 0}, {18.5, 14}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{139.11669335468375`, 146.18194555644516`}, {
            31.922632597121932`, 32.733706803340375`}}],
          StatusArea[#, 14]& ,
          TagBoxNote->"14"],
         StyleBox["14", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[14, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{18.5, 0}, {19.5, 5}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{145.68194555644516`, 152.74719775820654`}, {
            32.12260887254807, 32.733706803340375`}}],
          StatusArea[#, 5]& ,
          TagBoxNote->"5"],
         StyleBox["5", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[5, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{19.5, 0}, {20.5, 6}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{152.24719775820654`, 159.31244995996795`}, {
            32.100389286389614`, 32.733706803340375`}}],
          StatusArea[#, 6]& ,
          TagBoxNote->"6"],
         StyleBox["6", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[6, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{20.5, 0}, {21.5, 1}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{158.81244995996795`, 165.87770216172936`}, {
            32.21148721718191, 32.733706803340375`}}],
          StatusArea[#, 1]& ,
          TagBoxNote->"1"],
         StyleBox["1", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1, {}], 
         "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0.08000000000000002, 0},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->170,
    PlotRange->{{0.5, 21.5}, {All, All}},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{
     {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
      Opacity[0.581], Thickness[Small]}], {}, 
      {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
       EdgeForm[{Opacity[0.581], Thickness[Small]}], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{1.5, 0}, {2.5, 5}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{27.5074059247398, 37.19875900720577}, {
            31.90431429504558, 32.7337068033404}}],
          StatusArea[#, 5]& ,
          TagBoxNote->"5"],
         StyleBox["5", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[5, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{2.5, 0}, {3.5, 293}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{36.69875900720577, 46.390112089671746`}, {
            12.931305817264352`, 32.7337068033404}}],
          StatusArea[#, 293]& ,
          TagBoxNote->"293"],
         StyleBox["293", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[293, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{3.5, 0}, {4.5, 967}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{45.890112089671746`, 
            55.581465172137726`}, {-31.470804300876452`, 32.7337068033404}}],
          StatusArea[#, 967]& ,
          TagBoxNote->"967"],
         StyleBox["967", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[967, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{4.5, 0}, {5.5, 1110}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{55.081465172137726`, 
            64.77281825460369}, {-40.8914300381081, 32.7337068033404}}],
          StatusArea[#, 1110]& ,
          TagBoxNote->"1110"],
         StyleBox["1110", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1110, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{5.5, 0}, {6.5, 1253}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{64.27281825460369, 
            73.96417133706967}, {-50.31205577533976, 32.7337068033404}}],
          StatusArea[#, 1253]& ,
          TagBoxNote->"1253"],
         StyleBox["1253", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1253, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{6.5, 0}, {7.5, 1067}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{73.46417133706967, 
            83.15552441953564}, {-38.05865446677271, 32.7337068033404}}],
          StatusArea[#, 1067]& ,
          TagBoxNote->"1067"],
         StyleBox["1067", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1067, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{7.5, 0}, {8.5, 699}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{82.65552441953564, 
            92.34687750200162}, {-13.815365856274468`, 32.7337068033404}}],
          StatusArea[#, 699]& ,
          TagBoxNote->"699"],
         StyleBox["699", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[699, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{8.5, 0}, {9.5, 608}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{91.84687750200162, 
            101.53823058446758`}, {-7.820422205308873, 32.7337068033404}}],
          StatusArea[#, 608]& ,
          TagBoxNote->"608"],
         StyleBox["608", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[608, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{9.5, 0}, {10.5, 351}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{101.03823058446758`, 110.72958366693356`}, {
            9.11035272104452, 32.7337068033404}}],
          StatusArea[#, 351]& ,
          TagBoxNote->"351"],
         StyleBox["351", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[351, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{10.5, 0}, {11.5, 195}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{110.22958366693356`, 119.92093674939954`}, {
            19.387398979842686`, 32.7337068033404}}],
          StatusArea[#, 195]& ,
          TagBoxNote->"195"],
         StyleBox["195", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[195, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{11.5, 0}, {12.5, 71}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{119.42093674939954`, 129.11228983186552`}, {
            27.556333185554053`, 32.7337068033404}}],
          StatusArea[#, 71]& ,
          TagBoxNote->"71"],
         StyleBox["71", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[71, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{12.5, 0}, {13.5, 32}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{128.61228983186552`, 138.3036429143315}, {
            30.125594750253594`, 32.7337068033404}}],
          StatusArea[#, 32]& ,
          TagBoxNote->"32"],
         StyleBox["32", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[32, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{13.5, 0}, {14.5, 14}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{137.8036429143315, 147.49499599679746`}, {
            31.31140778011492, 32.7337068033404}}],
          StatusArea[#, 14]& ,
          TagBoxNote->"14"],
         StyleBox["14", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[14, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{14.5, 0}, {15.5, 2}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{146.99499599679746`, 156.68634907926344`}, {
            32.101949800022474`, 32.7337068033404}}],
          StatusArea[#, 2]& ,
          TagBoxNote->"2"],
         StyleBox["2", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[2, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{15.5, 0}, {16.5, 4}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{156.18634907926344`, 165.87770216172942`}, {
            31.970192796704545`, 32.7337068033404}}],
          StatusArea[#, 4]& ,
          TagBoxNote->"4"],
         StyleBox["4", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[4, {}], 
         "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{1.2, 0},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->170,
    PlotRange->{{1.5, 16.5}, {All, All}},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{
     {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
      Opacity[0.5319999999999999], Thickness[Small]}], {}, 
      {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
       EdgeForm[{Opacity[0.5319999999999999], Thickness[Small]}], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{1.5, 0}, {2.5, 7}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{27.507405924739793`, 34.27423757187569}, {
            31.9179579847334, 32.73370680334037}}],
          StatusArea[#, 7]& ,
          TagBoxNote->"7"],
         StyleBox["7", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[7, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{2.5, 0}, {3.5, 78}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{33.77423757187569, 40.541069219011575`}, {
            28.715362824576953`, 32.73370680334037}}],
          StatusArea[#, 78]& ,
          TagBoxNote->"78"],
         StyleBox["78", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[78, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{3.5, 0}, {4.5, 328}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{40.041069219011575`, 46.80790086614746}, {
            17.438619302899337`, 32.73370680334037}}],
          StatusArea[#, 328]& ,
          TagBoxNote->"328"],
         StyleBox["328", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[328, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{4.5, 0}, {5.5, 803}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{46.30790086614746, 
            53.07473251328335}, {-3.9871933882881336`, 32.73370680334037}}],
          StatusArea[#, 803]& ,
          TagBoxNote->"803"],
         StyleBox["803", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[803, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{5.5, 0}, {6.5, 1213}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{52.57473251328335, 
            59.34156416041924}, {-22.481052763839422`, 32.73370680334037}}],
          StatusArea[#, 1213]& ,
          TagBoxNote->"1213"],
         StyleBox["1213", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1213, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{6.5, 0}, {7.5, 1499}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{58.84156416041924, 
            65.60839580755514}, {-35.38164735263861, 32.73370680334037}}],
          StatusArea[#, 1499]& ,
          TagBoxNote->"1499"],
         StyleBox["1499", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1499, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{7.5, 0}, {8.5, 1830}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{65.10839580755514, 
            71.87522745469103}, {-50.31205577533977, 32.73370680334037}}],
          StatusArea[#, 1830]& ,
          TagBoxNote->"1830"],
         StyleBox["1830", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1830, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{8.5, 0}, {9.5, 1729}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{71.37522745469103, 
            78.14205910182692}, {-45.756251392582016`, 32.73370680334037}}],
          StatusArea[#, 1729]& ,
          TagBoxNote->"1729"],
         StyleBox["1729", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1729, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{9.5, 0}, {10.5, 1520}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{77.64205910182692, 
            84.4088907489628}, {-36.328893808459526`, 32.73370680334037}}],
          StatusArea[#, 1520]& ,
          TagBoxNote->"1520"],
         StyleBox["1520", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1520, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{10.5, 0}, {11.5, 1069}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{83.9088907489628, 
            90.67572239609869}, {-15.98564849535311, 32.73370680334037}}],
          StatusArea[#, 1069]& ,
          TagBoxNote->"1069"],
         StyleBox["1069", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1069, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{11.5, 0}, {12.5, 702}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{90.17572239609869, 96.94255404323458}, {
            0.5686109944696227, 32.73370680334037}}],
          StatusArea[#, 702]& ,
          TagBoxNote->"702"],
         StyleBox["702", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[702, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{12.5, 0}, {13.5, 437}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{96.44255404323458, 103.20938569037048`}, {
            12.521959127447897`, 32.73370680334037}}],
          StatusArea[#, 437]& ,
          TagBoxNote->"437"],
         StyleBox["437", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[437, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{13.5, 0}, {14.5, 173}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{102.70938569037048`, 109.47621733750637`}, {
            24.43020028633946, 32.73370680334037}}],
          StatusArea[#, 173]& ,
          TagBoxNote->"173"],
         StyleBox["173", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[173, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{14.5, 0}, {15.5, 82}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{108.97621733750637`, 115.74304898464226`}, {
            28.53493492823011, 32.73370680334037}}],
          StatusArea[#, 82]& ,
          TagBoxNote->"82"],
         StyleBox["82", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[82, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{15.5, 0}, {16.5, 35}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{115.24304898464226`, 122.00988063177815`}, {
            30.6549627103055, 32.73370680334037}}],
          StatusArea[#, 35]& ,
          TagBoxNote->"35"],
         StyleBox["35", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[35, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{16.5, 0}, {17.5, 10}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{121.50988063177815`, 128.27671227891403`}, {
            31.782637062473263`, 32.73370680334037}}],
          StatusArea[#, 10]& ,
          TagBoxNote->"10"],
         StyleBox["10", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[10, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{17.5, 0}, {18.5, 1}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{127.77671227891403`, 134.54354392604992`}, {
            32.18859982925366, 32.73370680334037}}],
          StatusArea[#, 1]& ,
          TagBoxNote->"1"],
         StyleBox["1", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{18.5, 0}, {19.5, 2}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{134.04354392604992`, 140.81037557318584`}, {
            32.14349285516695, 32.73370680334037}}],
          StatusArea[#, 2]& ,
          TagBoxNote->"2"],
         StyleBox["2", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[2, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{19.5, 0}, {20.5, 1}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{140.31037557318584`, 147.0772072203217}, {
            32.18859982925366, 32.73370680334037}}],
          StatusArea[#, 1]& ,
          TagBoxNote->"1"],
         StyleBox["1", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1, {}], "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         TagBox[
          DynamicBox[{
            FEPrivate`If[
             CurrentValue["MouseOver"], 
             EdgeForm[{
               GrayLevel[0.5], 
               AbsoluteThickness[1.5], 
               Opacity[0.66]}], {}, {}], 
            RectangleBox[{22.5, 0}, {23.5, 1}, "RoundingRadius" -> 0]},
           
           ImageSizeCache->{{159.1108705145935, 165.8777021617294}, {
            32.18859982925366, 32.73370680334037}}],
          StatusArea[#, 1]& ,
          TagBoxNote->"1"],
         StyleBox["1", {}, StripOnInput -> False]],
        Annotation[#, 
         Style[1, {}], 
         "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{1.06, 0},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->170,
    PlotRange->{{1.5, 23.5}, {All, All}},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"fcda8026-fa4e-4c2a-ad22-63b5ae98aca2"]
}, Open  ]],

Cell[TextData[{
 "So far we\[CloseCurlyQuote]ve only talked about English. But the Wolfram \
Language also knows about other languages. For example, ",
 ButtonBox["WordTranslation",
  BaseStyle->"Link"],
 " gives translations of words."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"07127d98-5242-4900-b59c-7f790acd44e6"],

Cell["Translate \[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote] into \
French:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"49d98e90-cfd2-4cfa-9e8f-2c2f8497fe59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordTranslation", "[", 
  RowBox[{"\"\<hello\>\"", ",", "\"\<French\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"16c57e31-9d87-4643-b268-7267a2d48562"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"bonjour\"\>", ",", "\<\"hello\"\>", 
   ",", "\<\"hol\[AGrave]\"\>", ",", "\<\"oh\[EAcute]\"\>"}], "}"}]], "Output",\

 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"daa9ff02-51ee-4782-8857-1d3d53fb321d"]
}, Open  ]],

Cell["Translate into Korean:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"391aa5d8-dbd1-4447-9cb2-e771dae4e3d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordTranslation", "[", 
  RowBox[{"\"\<hello\>\"", ",", "\"\<Korean\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"5db29c0c-1bec-4e14-bc1e-80076185fe0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\:c5ec\:bcf4\:c138\:c694\"\>", 
   ",", "\<\"\:c548\:b155\:d558\:c138\:c694\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"a6cbb3ca-916e-4228-b2d5-8bec29ae003b"]
}, Open  ]],

Cell["\<\
Translate into Korean, then transliterate to the English alphabet:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"ef32fedb-14df-4b08-96a5-5d6545505800"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transliterate", "[", 
  RowBox[{"WordTranslation", "[", 
   RowBox[{"\"\<hello\>\"", ",", "\"\<Korean\>\""}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"0c004b5a-f3e4-46bd-b65e-991e81d7b603"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"yeoboseyo\"\>", ",", "\<\"annyeonghaseyo\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"f5ebd3e7-1552-45e5-875e-05464dd6c734"]
}, Open  ]],

Cell[TextData[{
 "If you want to compare lots of different languages, give ",
 ButtonBox["All",
  BaseStyle->"Link"],
 " as the language for  ",
 ButtonBox["WordTranslation",
  BaseStyle->"Link"],
 ". ",
 "The result is an association which gives translations for different \
languages, with the languages listed roughly in order of decreasing worldwide \
usage."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"def16427-e896-4455-90ca-eebee1e6c92b"],

Cell["\<\
Give translations of \[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote] \
into the 5 most common languages in the world:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6d1fabf6-3479-4aab-9281-7fb7738de448"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"WordTranslation", "[", 
    RowBox[{"\"\<hello\>\"", ",", "All"}], "]"}], ",", "5"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"0f6ece98-efe6-4b48-82d2-1815bdd195c1"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{
    TemplateBox[{"\"Mandarin\"", 
      RowBox[{"Entity", "[", 
        RowBox[{"\"Language\"", ",", "\"ChineseMandarin\""}], "]"}], 
      "\"Entity[\\\"Language\\\", \\\"ChineseMandarin\\\"]\"", "\"language\""},
     "Entity"], "\[Rule]", 
    RowBox[{
    "{", "\<\"\:8868\:793a\:554f\:5019\:7684\:53eb\:8072\"\>", "}"}]}], ",", 
   RowBox[{
    TemplateBox[{"\"Hindi\"", 
      RowBox[{"Entity", "[", 
        RowBox[{"\"Language\"", ",", "\"Hindi\""}], "]"}], 
      "\"Entity[\\\"Language\\\", \\\"Hindi\\\"]\"", "\"language\""},
     "Entity"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"\:0939\:0932\:094b\"\>", 
      ",", "\<\"\:0928\:092e\:0938\:094d\:0924\:0947\"\>"}], "}"}]}], ",", 
   RowBox[{
    TemplateBox[{"\"Spanish\"", 
      RowBox[{"Entity", "[", 
        RowBox[{"\"Language\"", ",", "\"Spanish\""}], "]"}], 
      "\"Entity[\\\"Language\\\", \\\"Spanish\\\"]\"", "\"language\""},
     "Entity"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"buenos d\[IAcute]as\"\>", ",", "\<\"hola\"\>"}], "}"}]}], 
   ",", 
   RowBox[{
    TemplateBox[{"\"Russian\"", 
      RowBox[{"Entity", "[", 
        RowBox[{"\"Language\"", ",", "\"Russian\""}], "]"}], 
      "\"Entity[\\\"Language\\\", \\\"Russian\\\"]\"", "\"language\""},
     "Entity"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"\:043f\:0440\:0438\:0432\:0435\:0442\"\>", 
      ",", "\<\"\:043f\:0440\:0438\:0432\:0435\:0442\:0441\:0442\:0432\:0438\
\:0435\"\>", 
      ",", "\<\"\:0417\:0434\:0440\:0430\:0432\:0441\:0442\:0432\:0443\:0439\
\:0442\:0435\"\>"}], "}"}]}], ",", 
   RowBox[{
    TemplateBox[{"\"Indonesian\"", 
      RowBox[{"Entity", "[", 
        RowBox[{"\"Language\"", ",", "\"Indonesian\""}], "]"}], 
      "\"Entity[\\\"Language\\\", \\\"Indonesian\\\"]\"", "\"language\""},
     "Entity"], "\[Rule]", 
    RowBox[{"{", "\<\"halo\"\>", "}"}]}]}], "\[RightAssociation]"}]], "Output",\

 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[21]=",ExpressionUUID->"1ea4e86c-d6e5-43b1-b4c1-6c6d0a3059f3"]
}, Open  ]],

Cell["\<\
Let\[CloseCurlyQuote]s take the top 100 languages, and look at the first \
character in the first translation for \[OpenCurlyDoubleQuote]hello\
\[CloseCurlyDoubleQuote] that appears. Here\[CloseCurlyQuote]s a word cloud \
that shows that among these languages, \[OpenCurlyDoubleQuote]h\
\[CloseCurlyDoubleQuote] is the most common letter to start the word for \
\[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote].\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f2f3270b-4d05-4545-a3cc-560e646efa71"],

Cell["\<\
For the top 100 languages, make a word cloud of the first characters in the \
word for \[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote]:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f6f81192-2dc5-4a33-bcdb-ee4a7f5ebd59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordCloud", "[", 
  RowBox[{"Values", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"StringTake", "[", 
      RowBox[{
       RowBox[{"First", "[", "#", "]"}], ",", "1"}], "]"}], "&"}], "/@", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"WordTranslation", "[", 
       RowBox[{"\"\<hello\>\"", ",", "All"}], "]"}], ",", "100"}], "]"}]}], 
   "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"75c19ea3-88bb-49a2-9c73-27021b72461f"],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"h\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.6481481481481481],
     FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"m\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.2559912854030501],
     FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {28.5, 0.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"b\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.22331154684095858`],
     FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {-26.5, 0.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"a\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.2559912854030501],
     FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {-0.5, -28.5}, 
    Center, Automatic], InsetBox[
    StyleBox["\<\"\:0421\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.15795206971677558`],
     FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {23.5, 17.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"G\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[
      0.5833680111493557, 0.4126186601628758, 0.8290799721266107]], {0.5, 28.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0938\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[
      0.838355547812947, 0.44746667828057946`, 0.0208888695323676]], {-24.5, -16.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0905\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965]], {23.5, -16.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0939\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.15795206971677558`],
     FontColor->RGBColor[0.772079, 0.431554, 0.102387]], {-25.5, 21.5}, 
    Center, Automatic], InsetBox[
    StyleBox["\<\"k\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.15795206971677558`],
     FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {15.5, -30.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"d\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.15795206971677558`],
     FontColor->RGBColor[1, 0.75, 0]], {-15.5, -29.5}, Center, Automatic], 
   InsetBox[
    StyleBox["\<\"\:0c39\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.7678998606330495, 0.7317110956258943, 0.]], {13.5, 30.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0417\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[0.915, 0.3325, 0.2125]], {36.5, 16.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"\:8868\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.6536293927965667, 0.37163285420200276`, 0.6534265180085832]], {-27.5, -29.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:4f60\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.23716678280579248`, 0.645266573755366, 0.699600139366951]], {36.5, -17.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:4eca\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.8168067340273636, 0.3521386531945273, 0.3761554432877274]], {-38.5, -12.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:c5ec\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.6361597700445392, 0.7170733077827265, 0.]], {-39.5, 0.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:1324\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.5472001045252132, 0.43417993728487203`, 0.85]], 
    {29.5, -29.5}, Center, Automatic], InsetBox[
    StyleBox["\<\"\:5582\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.9052934053395919, 0.510195603559728, 0.06776406480563275]], {-11.5, 39.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"s\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.15795206971677558`],
     FontColor->RGBColor[0.571589, 0.586483, 0.]], {-37.5, 20.5}, Center, 
    Automatic], InsetBox[
    StyleBox["\<\"c\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.15795206971677558`],
     FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {27.5, 33.5}, Center,
     Automatic], InsetBox[
    StyleBox["\<\"\:091c\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.8857244243136628, 0.3764133635295058, 0.1393110607841571]], {-23.5, 33.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\[Gamma]\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.2187618985811806, 0.715, 0.5074848563512248]], {0.5, 0.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0680\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.5407932311309059, 0.715, 0.09762679674248334]], {-11.5, -39.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"t\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[0.8996399512215667, 0.7463488834690629, 0.]], {-37.5, -26.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0995\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.9874666782805795, 0.6948333914028977, 0.033839968642435214`]], {-37.5, 30.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0f67\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.7132613816472081, 0.358, 0.5392132590042952]], {-25.5, -39.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0d39\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.35558897405758294`, 0.5505288207539337, 0.8417067688690995]], {1.5, 41.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0ca8\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.8878600487784333, 0.33792799024431336`, 0.2577332520359445]], {38.5, 29.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:092a\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.47401116530937026`, 0.47809330081437784`, 0.85]], {27.5, -40.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:043f\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85]], {-34.5, -40.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:10d2\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.8564488486273256, 0.42032672705901153`, 0.06612212156831418]], {37.5, -39.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:09b9\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.7748409210981391, 0.358, 0.4444755060028629]], {-0.5, -44.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:05d4\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.9324333565611593, 0.5282889043741062, 0.0921900209050434]], {-0.5, -12.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:1785\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.9810598048862722, 0.7553955338762525, 0.]], {13.5, 42.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0e2a\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.9637822400302223, 0.5764112001511111, 0.0977879519184]], {11.5, -43.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0b47\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.8613800418100862, 0.48092002787339083`, 0.02824203762907758]], {45.5, 0.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0a95\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.16397784358994957`, 0.7038177251280403, 0.6117734123079395]], {-46.5, 11.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0532\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.28240003484173815`, 0.6090799721266095, 0.7538800418100857]], {47.5, -9.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:06c1\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {47.5, 12.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"v\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.7513196300394465, 0.358, 0.48066210763162087`]], {22.5, 43.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0647\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.12527233115468409`],
     FontColor->RGBColor[
      0.9728288904374106, 0.621644452187053, 0.07336199581899142]], {-49.5, 0.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"j\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.428777913273419, 0.5052332520359486, 0.85]], {-47.5, -11.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"n\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.9784200278733908, 0.649600139366954, 0.058265924741844846`]], {-22.5, 43.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"e\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.9038177251280404, 0.3492734123079395, 0.18454431282010084`]], {47.5, -18.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:1019\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[0.37977756485605163`, 0.715, 0.3025558265468435]], {-0.5, 50.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0433\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.8439466852489265, 0.3467106629502147, 0.3309221912517893]], {41.5, -28.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:062a\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.6753413537738198, 0.3589675436319385, 0.5991466155654507]], {-7.5, -50.5},
     Center, Automatic], InsetBox[
    StyleBox["\<\"\:0bb5\"\>",
     StripOnInput->False,
     FontSize->Scaled[0.09259259259259259],
     FontColor->RGBColor[
      0.6184987019729621, 0.39212575718243875`, 0.7412532450675947]], {47.5, 19.5},
     Center, Automatic]},
  DefaultBaseStyle->{"Graphics", FontFamily -> "Helvetica"},
  ImageSize->{182.328125, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
  PlotRange->{{-55., 53.}, {-55., 55.}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"cd496d27-c5cd-4aa8-9c12-8c136bd018fa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ca69c223-6f49-4210-a3ff-f9c04826fb35"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Interpreter",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"type\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell["specify a function to interpret natural language ", 
     "VocabularyText",ExpressionUUID->"69bb6e18-df51-4bf2-af77-adbb9010e979"]},
   {
    RowBox[{
     ButtonBox["TextCases",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"text\", \"CodeVariableLrg\"]\)\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"type\", \"CodeVariableLrg\"]\)\>\""}], "]"}], " ",
     Cell[TextData[{
     "find cases of a given type of object in ",
     Cell[BoxData[
      StyleBox["text", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "9586172d-6557-4027-a082-83ef72f84023"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "9474a77b-0994-46a4-9188-26bbad423c56"]},
   {
    RowBox[{
     ButtonBox["TextStructure",
      BaseStyle->"CodeLink"], "[", 
     "\"\<\!\(\*StyleBox[\"text\", \"CodeVariableLrg\"]\)\>\"", "]"}], " ", 
    Cell[TextData[{
     "find the grammatical structure of ",
     Cell[BoxData[
      StyleBox["text", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "c8810fbb-90e0-4e9a-8b45-26907d5b2a29"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "d0920164-ec10-437e-bc4e-7f9cffbae5ec"]},
   {
    RowBox[{
     ButtonBox["WordTranslation",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"word\", \"CodeVariableLrg\"]\)\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"language\", \"CodeVariableLrg\"]\)\>\""}], "]"}], 
    " ", Cell[
    "translate a word into another language", "VocabularyText",ExpressionUUID->
     "231c1881-238b-4063-81de-0ba9c266e83b"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a3e0c043-bbda-4d33-9a66-39dcc81e3d8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"11ee5c3e-4f81-42dc-9e4e-5b5eb8f7ca79"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"15 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{
         "EIWL2-35-natural-language-understanding-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8428c153-7706-47bc-a176-7a310a0c7a3b"],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " to find the location of the Eiffel Tower.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"da751798-3c0e-4fa2-9445-9d7df657e3c8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"GeoPosition", "[", 
        RowBox[{"{", 
         RowBox[{"48.858333333333334`", ",", "2.2944444444444443`"}], "}"}], 
        "]"}]], "ExerciseOutput",ExpressionUUID->
       "dd6c4636-5854-4b58-9895-f4fbd548a0a4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"GeoPosition", "[", 
           RowBox[{"{", 
             RowBox[{"48.858333333333334`", ",", "2.2944444444444443`"}], 
             "}"}], "]"}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9575ca0c-4d2d-4bf5-a716-72f7d2de1a05"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " to find a university referred to as \[OpenCurlyDoubleQuote]U of T\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"85d2ef16-1e4d-41cb-9d02-e91c60fb45f1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"\"University of Toronto\"", 
         RowBox[{"Entity", "[", 
           
           RowBox[{"\"University\"", ",", 
             "\"UniversityOfTorontoOntario36741\""}], "]"}], 
         "\"Entity[\\\"University\\\", \
\\\"UniversityOfTorontoOntario36741\\\"]\"", "\"university\""},
        "Entity"]], "ExerciseOutput",ExpressionUUID->
       "fabda0c9-bc55-4484-97c4-316392d7f4f9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"\"University of Toronto\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfTorontoOntario36741\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfTorontoOntario36741\\\"]\"", "\"university\""}, "Entity"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1d909845-744c-4932-b123-04368f7f2cb2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " to find the chemicals referred to as C2H4, C2H6 and C3H8.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9da1056d-3cee-4f7e-9a96-89f72abea2ba"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TemplateBox[{"\"ethylene\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Chemical\"", ",", "\"Ethylene\""}], "]"}], 
           "\"Entity[\\\"Chemical\\\", \\\"Ethylene\\\"]\"", "\"chemical\""},
          "Entity"], ",", 
         TemplateBox[{"\"ethane\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Chemical\"", ",", "\"Ethane\""}], "]"}], 
           "\"Entity[\\\"Chemical\\\", \\\"Ethane\\\"]\"", "\"chemical\""},
          "Entity"], ",", 
         TemplateBox[{"\"propane\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Chemical\"", ",", "\"Propane\""}], "]"}], 
           "\"Entity[\\\"Chemical\\\", \\\"Propane\\\"]\"", "\"chemical\""},
          "Entity"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "a90e515d-45cd-47f9-af1e-dead98140387"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             TemplateBox[{"\"ethylene\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Chemical\"", ",", "\"Ethylene\""}], "]"}], 
               "\"Entity[\\\"Chemical\\\", \\\"Ethylene\\\"]\"", 
               "\"chemical\""}, "Entity"], ",", 
             TemplateBox[{"\"ethane\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Chemical\"", ",", "\"Ethane\""}], "]"}], 
               "\"Entity[\\\"Chemical\\\", \\\"Ethane\\\"]\"", 
               "\"chemical\""}, "Entity"], ",", 
             TemplateBox[{"\"propane\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Chemical\"", ",", "\"Propane\""}], "]"}], 
               "\"Entity[\\\"Chemical\\\", \\\"Propane\\\"]\"", 
               "\"chemical\""}, "Entity"]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6272a505-34fb-4df1-a391-c912a258d005"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " to interpret the date \[OpenCurlyDoubleQuote]20140108\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"47b1cc24-d630-4890-8dbf-ab9aa998d6dc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
         RowBox[{"\"Wed 8 Jan 2014\""}], 
         RowBox[{"DateObject", "[", 
           RowBox[{"{", 
             RowBox[{"2014", ",", "1", ",", "8"}], "}"}], "]"}]},
        "DateObject",
        Editable->False]], "ExerciseOutput",ExpressionUUID->
       "4c7dda95-6920-4a88-904f-76c0888c336d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
           RowBox[{"\"Wed 8 Jan 2014\""}], 
           RowBox[{"DateObject", "[", 
             RowBox[{"{", 
               RowBox[{"2014", ",", "1", ",", "8"}], "}"}], "]"}]}, 
          "DateObject", Editable -> False]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"56ba9edd-eb5f-4a0c-a189-90e14e58c223"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find universities that can be referred to as \[OpenCurlyDoubleQuote]U of X\
\[CloseCurlyDoubleQuote], where x is any letter of the alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"71e23612-eb9e-4d13-9120-71fde292d28a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TemplateBox[{"\"University of Birjand\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfBirjandIran37596\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfBirjandIran37596\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Chicago\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"University\"", ",", "\"UniversityOfChicago144050\""}],
              "]"}], "\"Entity[\\\"University\\\", \
\\\"UniversityOfChicago144050\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"The University of Edinburgh\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"TheUniversityOfEdinburghUnitedKingdom33799\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"TheUniversityOfEdinburghUnitedKingdom33799\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Georgia\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"University\"", ",", "\"UniversityOfGeorgia139959\""}],
              "]"}], "\"Entity[\\\"University\\\", \
\\\"UniversityOfGeorgia139959\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Houston\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"University\"", ",", "\"UniversityOfHouston225511\""}],
              "]"}], "\"Entity[\\\"University\\\", \
\\\"UniversityOfHouston225511\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Illinois at Urbana-Champaign\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfIllinoisAtUrbanaChampaign145637\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfIllinoisAtUrbanaChampaign145637\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Lethbridge\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfLethbridgeAlberta38035\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfLethbridgeAlberta38035\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Michigan-Ann Arbor\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfMichiganAnnArbor170976\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfMichiganAnnArbor170976\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Phoenix-Online Campus\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfPhoenixOnlineCampus372213\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfPhoenixOnlineCampus372213\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Regina\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfReginaSaskatchewan36297\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfReginaSaskatchewan36297\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Saskatchewan\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfSaskatchewanSaskatchewan36481\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfSaskatchewanSaskatchewan36481\\\"]\"", "\"university\""},
          "Entity"], ",", 
         TemplateBox[{"\"University of Toronto\"", 
           RowBox[{"Entity", "[", 
             
             RowBox[{"\"University\"", ",", 
               "\"UniversityOfTorontoOntario36741\""}], "]"}], 
           "\"Entity[\\\"University\\\", \
\\\"UniversityOfTorontoOntario36741\\\"]\"", "\"university\""},
          "Entity"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "b5cfa567-e5f8-4139-98c2-f3da599c51de"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             TemplateBox[{"\"University of Birjand\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", "\"UniversityOfBirjandIran37596\""}],
                  "]"}], 
               "\"Entity[\\\"University\\\", \\\"UniversityOfBirjandIran37596\
\\\"]\"", "\"university\""}, "Entity"], ",", 
             TemplateBox[{"\"University of Chicago\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", "\"UniversityOfChicago144050\""}], 
                 "]"}], "\"Entity[\\\"University\\\", \
\\\"UniversityOfChicago144050\\\"]\"", "\"university\""}, "Entity"], ",", 
             TemplateBox[{"\"The University of Edinburgh\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"TheUniversityOfEdinburghUnitedKingdom33799\""}], "]"}], 
               "\"Entity[\\\"University\\\", \
\\\"TheUniversityOfEdinburghUnitedKingdom33799\\\"]\"", "\"university\""}, 
              "Entity"], ",", 
             TemplateBox[{"\"University of Georgia\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", "\"UniversityOfGeorgia139959\""}], 
                 "]"}], "\"Entity[\\\"University\\\", \
\\\"UniversityOfGeorgia139959\\\"]\"", "\"university\""}, "Entity"], ",", 
             TemplateBox[{"\"University of Houston\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", "\"UniversityOfHouston225511\""}], 
                 "]"}], "\"Entity[\\\"University\\\", \
\\\"UniversityOfHouston225511\\\"]\"", "\"university\""}, "Entity"], ",", 
             TemplateBox[{"\"University of Illinois at Urbana-Champaign\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"UniversityOfIllinoisAtUrbanaChampaign145637\""}], "]"}],
                "\"Entity[\\\"University\\\", \
\\\"UniversityOfIllinoisAtUrbanaChampaign145637\\\"]\"", "\"university\""}, 
              "Entity"], ",", 
             TemplateBox[{"\"University of Lethbridge\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"UniversityOfLethbridgeAlberta38035\""}], "]"}], 
               "\"Entity[\\\"University\\\", \
\\\"UniversityOfLethbridgeAlberta38035\\\"]\"", "\"university\""}, "Entity"], 
             ",", 
             TemplateBox[{"\"University of Michigan-Ann Arbor\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"UniversityOfMichiganAnnArbor170976\""}], "]"}], 
               "\"Entity[\\\"University\\\", \
\\\"UniversityOfMichiganAnnArbor170976\\\"]\"", "\"university\""}, "Entity"], 
             ",", 
             TemplateBox[{"\"University of Phoenix-Online Campus\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"UniversityOfPhoenixOnlineCampus372213\""}], "]"}], 
               "\"Entity[\\\"University\\\", \
\\\"UniversityOfPhoenixOnlineCampus372213\\\"]\"", "\"university\""}, 
              "Entity"], ",", 
             TemplateBox[{"\"University of Regina\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"UniversityOfReginaSaskatchewan36297\""}], "]"}], 
               "\"Entity[\\\"University\\\", \
\\\"UniversityOfReginaSaskatchewan36297\\\"]\"", "\"university\""}, "Entity"],
              ",", 
             TemplateBox[{"\"University of Saskatchewan\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"UniversityOfSaskatchewanSaskatchewan36481\""}], "]"}], 
               
               "\"Entity[\\\"University\\\", \
\\\"UniversityOfSaskatchewanSaskatchewan36481\\\"]\"", "\"university\""}, 
              "Entity"], ",", 
             TemplateBox[{"\"University of Toronto\"", 
               RowBox[{"Entity", "[", 
                 
                 RowBox[{
                  "\"University\"", ",", 
                   "\"UniversityOfTorontoOntario36741\""}], "]"}], 
               "\"Entity[\\\"University\\\", \
\\\"UniversityOfTorontoOntario36741\\\"]\"", "\"university\""}, "Entity"]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d09ab516-2ad3-46ab-a882-38fc953d841e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find which US state capital names can be interpreted as movie titles (use \
",
 ButtonBox["CommonName",
  BaseStyle->"Link"],
 " to get the string versions of entity names).",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"8aea450c-7c40-42cb-ab95-8c4af2bbbe81"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TemplateBox[{"\"Phoenix\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Phoenix::cwgx2\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Phoenix::cwgx2\\\"]\"", "\"movie\""},
          "Entity"], ",", 
         TemplateBox[{"\"Lincoln\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Lincoln::ywsw3\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Lincoln::ywsw3\\\"]\"", "\"movie\""},
          "Entity"], ",", 
         TemplateBox[{"\"Honolulu\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Honolulu::sm2dd\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Honolulu::sm2dd\\\"]\"", "\"movie\""},
          
          "Entity"], ",", 
         TemplateBox[{"\"Annapolis\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Annapolis::74f56\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Annapolis::74f56\\\"]\"", "\"movie\""},
          "Entity"], ",", 
         TemplateBox[{"\"Expedition: Bismarck\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Expedition:Bismarck::5f93j\""}], 
             "]"}], "\"Entity[\\\"Movie\\\", \\\"Expedition:Bismarck::5f93j\\\
\"]\"", "\"movie\""},
          "Entity"], ",", 
         TemplateBox[{"\"Providence\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Providence::7889s\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Providence::7889s\\\"]\"", 
           "\"movie\""},
          "Entity"], ",", 
         TemplateBox[{"\"Nashville\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Nashville::v89b8\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Nashville::v89b8\\\"]\"", "\"movie\""},
          "Entity"], ",", 
         TemplateBox[{"\"Olympia\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Olympia::y5jny\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Olympia::y5jny\\\"]\"", "\"movie\""},
          "Entity"], ",", 
         TemplateBox[{"\"Madison\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Movie\"", ",", "\"Madison::sxz2b\""}], "]"}], 
           "\"Entity[\\\"Movie\\\", \\\"Madison::sxz2b\\\"]\"", "\"movie\""},
          "Entity"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "ec3d86d4-65cc-4021-b55a-394461181944"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             TemplateBox[{"\"Phoenix\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Phoenix::cwgx2\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Phoenix::cwgx2\\\"]\"", 
               "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Lincoln\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Lincoln::ywsw3\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Lincoln::ywsw3\\\"]\"", 
               "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Honolulu\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Honolulu::sm2dd\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Honolulu::sm2dd\\\"]\"", 
               "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Annapolis\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Annapolis::74f56\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Annapolis::74f56\\\"]\"", 
               "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Expedition: Bismarck\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Expedition:Bismarck::5f93j\""}],
                  "]"}], 
               "\"Entity[\\\"Movie\\\", \
\\\"Expedition:Bismarck::5f93j\\\"]\"", "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Providence\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Providence::7889s\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Providence::7889s\\\"]\"", 
               "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Nashville\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Nashville::v89b8\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Nashville::v89b8\\\"]\"", 
               "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Olympia\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Olympia::y5jny\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Olympia::y5jny\\\"]\"", 
               "\"movie\""}, "Entity"], ",", 
             TemplateBox[{"\"Madison\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Movie\"", ",", "\"Madison::sxz2b\""}], "]"}], 
               "\"Entity[\\\"Movie\\\", \\\"Madison::sxz2b\\\"]\"", 
               "\"movie\""}, "Entity"]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0a971eaa-5651-4174-9ce2-52a614ea24ee"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find cities that can be referred to by permutations of the letters a, i, l \
and m.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7e69f592-567e-4193-a3f5-ded17534946a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TemplateBox[{"\"Lima\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"City\"", ",", 
               RowBox[{"{", 
                 RowBox[{"\"Lima\"", ",", "\"Lima\"", ",", "\"Peru\""}], 
                 "}"}]}], "]"}], 
           "\"Entity[\\\"City\\\", {\\\"Lima\\\", \\\"Lima\\\", \
\\\"Peru\\\"}]\"", "\"city\""},
          "Entity"], ",", 
         TemplateBox[{"\"Ilam\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"City\"", ",", 
               RowBox[{"{", 
                 RowBox[{"\"Ilam\"", ",", "\"Ilam\"", ",", "\"Iran\""}], 
                 "}"}]}], "]"}], 
           "\"Entity[\\\"City\\\", {\\\"Ilam\\\", \\\"Ilam\\\", \
\\\"Iran\\\"}]\"", "\"city\""},
          "Entity"], ",", 
         TemplateBox[{"\"Milah\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"City\"", ",", 
               RowBox[{"{", 
                 RowBox[{"\"Milah\"", ",", "\"Mila\"", ",", "\"Algeria\""}], 
                 "}"}]}], "]"}], 
           "\"Entity[\\\"City\\\", {\\\"Milah\\\", \\\"Mila\\\", \
\\\"Algeria\\\"}]\"", "\"city\""},
          "Entity"], ",", 
         TemplateBox[{"\"Mali\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"City\"", ",", 
               RowBox[{"{", 
                 RowBox[{"\"Mali\"", ",", "\"Mali\"", ",", "\"Guinea\""}], 
                 "}"}]}], "]"}], 
           "\"Entity[\\\"City\\\", {\\\"Mali\\\", \\\"Mali\\\", \
\\\"Guinea\\\"}]\"", "\"city\""},
          "Entity"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "051ebc7a-caf9-4a97-9d44-034adce3d157"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             TemplateBox[{"\"Lima\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"City\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"Lima\"", ",", "\"Lima\"", ",", "\"Peru\""}], 
                    "}"}]}], "]"}], 
               "\"Entity[\\\"City\\\", {\\\"Lima\\\", \\\"Lima\\\", \
\\\"Peru\\\"}]\"", "\"city\""}, "Entity"], ",", 
             TemplateBox[{"\"Ilam\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"City\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"Ilam\"", ",", "\"Ilam\"", ",", "\"Iran\""}], 
                    "}"}]}], "]"}], 
               "\"Entity[\\\"City\\\", {\\\"Ilam\\\", \\\"Ilam\\\", \
\\\"Iran\\\"}]\"", "\"city\""}, "Entity"], ",", 
             TemplateBox[{"\"Milah\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"City\"", ",", 
                   RowBox[{"{", 
                    
                    RowBox[{
                    "\"Milah\"", ",", "\"Mila\"", ",", "\"Algeria\""}], 
                    "}"}]}], "]"}], 
               "\"Entity[\\\"City\\\", {\\\"Milah\\\", \\\"Mila\\\", \
\\\"Algeria\\\"}]\"", "\"city\""}, "Entity"], ",", 
             TemplateBox[{"\"Mali\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"City\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"Mali\"", ",", "\"Mali\"", ",", "\"Guinea\""}], 
                    "}"}]}], "]"}], 
               "\"Entity[\\\"City\\\", {\\\"Mali\\\", \\\"Mali\\\", \
\\\"Guinea\\\"}]\"", "\"city\""}, "Entity"]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"854ca864-a528-4ddb-b067-a6eaaec71ff2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a word cloud of country names in the Wikipedia article on \
\[OpenCurlyDoubleQuote]gunpowder\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:26",ExpressionUUID->"979de9b3-9246-4ea1-b66d-f1f879c689c1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {InsetBox[
           StyleBox["\<\"Chinese\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.2554744525547445],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
          InsetBox[
           StyleBox["\<\"Mongols\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.1402228198232808],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.560181, 0.691569, 0.194885]], {-0.5, -39.5}], InsetBox[
           StyleBox["\<\"German\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.12869765655013446`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {-0.5, 46.5}],
           InsetBox[
           StyleBox["\<\"China\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.1402228198232808],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.880722, 0.611041, 0.142051]], {8.5, 71.5}], 
          InsetBox[
           StyleBox["\<\"the United Kingdom\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0710718401844026],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9728288904374106, 0.621644452187053, 
              0.07336199581899142]], {-23.5, -68.5}], InsetBox[
           StyleBox["\<\"English\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.10564733000384172`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.772079, 0.431554, 0.102387]], {-5.5, -94.5}], InsetBox[
           StyleBox["\<\"England\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.09412216673069536],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.363898, 0.618501, 0.782349]], {32.5, 99.5}],
           InsetBox[
           StyleBox["\<\"India\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.1171724932769881],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {97.5, 32.5}],
           InsetBox[
           StyleBox["\<\"Portuguese\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0710718401844026],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.40082222609352647`, 0.5220066643438841, 0.85]], {-65.5, 98.5}],
           InsetBox[
           StyleBox["\<\"Mongol\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.08259700345754897],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.571589, 0.586483, 0.]], {-80.5, 73.5}], 
          InsetBox[
           StyleBox["\<\"France\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.08259700345754897],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.647624, 0.37816, 0.614037]], {-100.5, 44.5}], InsetBox[
           StyleBox["\<\"Britain\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.08259700345754897],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[1, 0.75, 0]], {95.5, 57.5}], InsetBox[
           StyleBox["\<\"American\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.05954667691125624],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.736782672705901, 0.358, 0.5030266573755369]], {98.5, -62.5}], 
          InsetBox[
           StyleBox["\<\"Germany\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.05954667691125624],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.838355547812947, 0.44746667828057946`, 
              0.0208888695323676]], {77.5, -85.5}], InsetBox[
           StyleBox["\<\"Dutch\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0710718401844026],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-99.5, -32.5}], 
          InsetBox[
           StyleBox["\<\"French\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.05954667691125624],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.28026441037696703`, 0.715, 
              0.4292089322474965]], {99.5, -31.5}], InsetBox[
           StyleBox["\<\"Japan\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.05954667691125624],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.5833680111493557, 0.4126186601628758, 
              0.8290799721266107]], {-76.5, -86.5}], InsetBox[
           StyleBox["\<\"Philippines\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.7132613816472081, 0.358, 0.5392132590042952]], {14.5, 26.5}], 
          InsetBox[
           StyleBox["\<\"Indonesia\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.7678998606330495, 0.7317110956258943, 0.]], {96.5, -45.5}], 
          InsetBox[
           StyleBox["\<\"Wales\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.048021513638109865`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9324333565611593, 0.5282889043741062, 
              0.0921900209050434]], {-92.5, -48.5}], InsetBox[
           StyleBox["\<\"Malaysia\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.35558897405758294`, 0.5505288207539337, 
              0.8417067688690995]], {78.5, 76.5}], InsetBox[
           StyleBox["\<\"Australia\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.5407932311309059, 0.715, 
              0.09762679674248334]], {18.5, -111.5}], InsetBox[
           StyleBox["\<\"Scotland\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.37977756485605163`, 0.715, 
              0.3025558265468435]], {-36.5, 110.5}], InsetBox[
           StyleBox["\<\"grenade\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.6184987019729621, 0.39212575718243875`, 
              0.7412532450675947]], {63.5, -98.5}], InsetBox[
           StyleBox["\<\"America\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.6753413537738198, 0.3589675436319385, 
              0.5991466155654507]], {-38.5, -111.5}], InsetBox[
           StyleBox["\<\"Belgium\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8857244243136628, 0.3764133635295058, 
              0.1393110607841571]], {-77.5, -103.5}], InsetBox[
           StyleBox["\<\"Persian\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9637822400302223, 0.5764112001511111, 
              0.0977879519184]], {70.5, -110.5}], InsetBox[
           StyleBox["\<\"China's\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.16397784358994957`, 0.7038177251280403, 
              0.6117734123079395]], {98.5, 88.5}], InsetBox[
           StyleBox["\<\"Peru\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.048021513638109865`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8439466852489265, 0.3467106629502147, 
              0.3309221912517893]], {96.5, 101.5}], InsetBox[
           StyleBox["\<\"Ireland\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8878600487784333, 0.33792799024431336`, 
              0.2577332520359445]], {117.5, 74.5}], InsetBox[
           StyleBox["\<\"Bengal\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.47401116530937026`, 0.47809330081437784`, 
              0.85]], {-118.5, -83.5}], InsetBox[
           StyleBox["\<\"Italy\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.048021513638109865`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8996399512215667, 0.7463488834690629, 0.]], {102.5, -103.5}], 
          InsetBox[
           StyleBox["\<\"Brunei\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.9874666782805795, 0.6948333914028977, 
              0.033839968642435214`]], {-117.5, -95.5}], InsetBox[
           StyleBox["\<\"Egypt\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8613800418100862, 0.48092002787339083`, 
              0.02824203762907758]], {-111.5, -107.5}], InsetBox[
           StyleBox["\<\"US\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.048021513638109865`],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.28240003484173815`, 0.6090799721266095, 
              0.7538800418100857]], {-100.5, 5.5}], InsetBox[
           StyleBox["\<\"Syria\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.8564488486273256, 0.42032672705901153`, 
              0.06612212156831418]], {-125.5, -48.5}], InsetBox[
           StyleBox["\<\"Chile\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.7748409210981391, 0.358, 
              0.4444755060028629]], {-124.5, -62.5}], InsetBox[
           StyleBox["\<\"U.S.\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->Scaled[0.0364963503649635],
            FontWeight->Plain,
            FontSlant->Plain,
            FontTracking->"Plain",
            
            FontColor->RGBColor[
             0.5472001045252132, 0.43417993728487203`, 
              0.85]], {-126.5, 61.5}]}},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic},
        PlotRange->{{-139., 135.}, {-117., 118.}}]], "ExerciseOutput",
       ExpressionUUID->"9629c4a0-8cef-407b-afba-858b0c6c8c47"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {
            InsetBox[
             StyleBox[
             "\"Chinese\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.2554744525547445], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
            InsetBox[
             StyleBox[
             "\"Mongols\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.1402228198232808], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.560181, 0.691569, 0.194885]], {-0.5, -39.5}], 
            InsetBox[
             StyleBox[
             "\"German\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.12869765655013446`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.922526, 0.385626, 0.209179]], {-0.5, 46.5}], 
            InsetBox[
             StyleBox[
             "\"China\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.1402228198232808], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.880722, 0.611041, 0.142051]], {8.5, 71.5}], 
            InsetBox[
             StyleBox[
             "\"the United Kingdom\"", StripOnInput -> False, FontFamily -> 
              "Helvetica", FontSize -> Scaled[0.0710718401844026], FontWeight -> 
              Plain, FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9728288904374106, 0.621644452187053, 
                0.07336199581899142]], {-23.5, -68.5}], 
            InsetBox[
             StyleBox[
             "\"English\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.10564733000384172`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.772079, 0.431554, 0.102387]], {-5.5, -94.5}], 
            InsetBox[
             StyleBox[
             "\"England\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.09412216673069536], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.363898, 0.618501, 0.782349]], {32.5, 99.5}], 
            InsetBox[
             StyleBox[
             "\"India\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.1171724932769881], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.528488, 0.470624, 0.701351]], {97.5, 32.5}], 
            InsetBox[
             StyleBox[
             "\"Portuguese\"", StripOnInput -> False, FontFamily -> 
              "Helvetica", FontSize -> Scaled[0.0710718401844026], FontWeight -> 
              Plain, FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.40082222609352647`, 0.5220066643438841, 0.85]], {-65.5, 
             98.5}], 
            InsetBox[
             StyleBox[
             "\"Mongol\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.08259700345754897], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.571589, 0.586483, 0.]], {-80.5, 73.5}], 
            InsetBox[
             StyleBox[
             "\"France\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.08259700345754897], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.647624, 0.37816, 0.614037]], {-100.5, 44.5}], 
            InsetBox[
             StyleBox[
             "\"Britain\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.08259700345754897], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[1, 0.75, 0]], {95.5, 57.5}], 
            InsetBox[
             StyleBox[
             "\"American\"", StripOnInput -> False, FontFamily -> "Helvetica",
               FontSize -> Scaled[0.05954667691125624], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {
             98.5, -62.5}], 
            InsetBox[
             StyleBox[
             "\"Germany\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.05954667691125624], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.838355547812947, 0.44746667828057946`, 
                0.0208888695323676]], {77.5, -85.5}], 
            InsetBox[
             StyleBox[
             "\"Dutch\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0710718401844026], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.915, 0.3325, 0.2125]], {-99.5, -32.5}], 
            InsetBox[
             StyleBox[
             "\"French\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.05954667691125624], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965]], {
             99.5, -31.5}], 
            InsetBox[
             StyleBox[
             "\"Japan\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.05954667691125624], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.5833680111493557, 0.4126186601628758, 
                0.8290799721266107]], {-76.5, -86.5}], 
            InsetBox[
             StyleBox[
             "\"Philippines\"", StripOnInput -> False, FontFamily -> 
              "Helvetica", FontSize -> Scaled[0.0364963503649635], FontWeight -> 
              Plain, FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.7132613816472081, 0.358, 0.5392132590042952]], {14.5,
              26.5}], 
            InsetBox[
             StyleBox[
             "\"Indonesia\"", StripOnInput -> False, FontFamily -> 
              "Helvetica", FontSize -> Scaled[0.0364963503649635], FontWeight -> 
              Plain, FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.7678998606330495, 0.7317110956258943, 0.]], {
             96.5, -45.5}], 
            InsetBox[
             StyleBox[
             "\"Wales\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.048021513638109865`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9324333565611593, 0.5282889043741062, 
                0.0921900209050434]], {-92.5, -48.5}], 
            InsetBox[
             StyleBox[
             "\"Malaysia\"", StripOnInput -> False, FontFamily -> "Helvetica",
               FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.35558897405758294`, 0.5505288207539337, 
                0.8417067688690995]], {78.5, 76.5}], 
            InsetBox[
             StyleBox[
             "\"Australia\"", StripOnInput -> False, FontFamily -> 
              "Helvetica", FontSize -> Scaled[0.0364963503649635], FontWeight -> 
              Plain, FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.5407932311309059, 0.715, 0.09762679674248334]], {
             18.5, -111.5}], 
            InsetBox[
             StyleBox[
             "\"Scotland\"", StripOnInput -> False, FontFamily -> "Helvetica",
               FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.37977756485605163`, 0.715, 0.3025558265468435]], {-36.5, 
             110.5}], 
            InsetBox[
             StyleBox[
             "\"grenade\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.6184987019729621, 0.39212575718243875`, 
                0.7412532450675947]], {63.5, -98.5}], 
            InsetBox[
             StyleBox[
             "\"America\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.6753413537738198, 0.3589675436319385, 
                0.5991466155654507]], {-38.5, -111.5}], 
            InsetBox[
             StyleBox[
             "\"Belgium\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8857244243136628, 0.3764133635295058, 
                0.1393110607841571]], {-77.5, -103.5}], 
            InsetBox[
             StyleBox[
             "\"Persian\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9637822400302223, 0.5764112001511111, 0.0977879519184]], {
             70.5, -110.5}], 
            InsetBox[
             StyleBox[
             "\"China's\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.16397784358994957`, 0.7038177251280403, 
                0.6117734123079395]], {98.5, 88.5}], 
            InsetBox[
             StyleBox[
             "\"Peru\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.048021513638109865`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8439466852489265, 0.3467106629502147, 0.3309221912517893]], {
             96.5, 101.5}], 
            InsetBox[
             StyleBox[
             "\"Ireland\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8878600487784333, 0.33792799024431336`, 
                0.2577332520359445]], {117.5, 74.5}], 
            InsetBox[
             StyleBox[
             "\"Bengal\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.47401116530937026`, 0.47809330081437784`, 
                0.85]], {-118.5, -83.5}], 
            InsetBox[
             StyleBox[
             "\"Italy\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.048021513638109865`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[0.8996399512215667, 0.7463488834690629, 0.]], {
             102.5, -103.5}], 
            InsetBox[
             StyleBox[
             "\"Brunei\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.9874666782805795, 0.6948333914028977, 
                0.033839968642435214`]], {-117.5, -95.5}], 
            InsetBox[
             StyleBox[
             "\"Egypt\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8613800418100862, 0.48092002787339083`, 
                0.02824203762907758]], {-111.5, -107.5}], 
            InsetBox[
             StyleBox[
             "\"US\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.048021513638109865`], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.28240003484173815`, 0.6090799721266095, 
                0.7538800418100857]], {-100.5, 5.5}], 
            InsetBox[
             StyleBox[
             "\"Syria\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.8564488486273256, 0.42032672705901153`, 
                0.06612212156831418]], {-125.5, -48.5}], 
            InsetBox[
             StyleBox[
             "\"Chile\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.7748409210981391, 0.358, 
                0.4444755060028629]], {-124.5, -62.5}], 
            InsetBox[
             StyleBox[
             "\"U.S.\"", StripOnInput -> False, FontFamily -> "Helvetica", 
              FontSize -> Scaled[0.0364963503649635], FontWeight -> Plain, 
              FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
              RGBColor[
               0.5472001045252132, 0.43417993728487203`, 0.85]], {-126.5, 
             61.5}]}}, 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}, PlotRange -> {{-139., 135.}, {-117., 118.}}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0717fca2-befc-4376-a825-b759f19d8321"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find all nouns in \[OpenCurlyDoubleQuote]She sells seashells by the sea \
shore.\[CloseCurlyDoubleQuote]",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"950ac7e3-c56c-42c9-87b5-9c1970b383f1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"seashells\"\>", ",", "\<\"sea\"\>", 
         ",", "\<\"shore\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "27cd0bfb-99af-43a1-b704-2ac990c2da04"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"\"seashells\"", ",", "\"sea\"", ",", "\"shore\""}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d8dba553-6da8-4780-8bf0-5bf9ae4e3463"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["TextCases",
  BaseStyle->"Link"],
 " to find the number of nouns, verbs and adjectives in the first 1000 \
characters of the Wikipedia article on computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"97fd5cf2-6f5e-4b26-a215-ae0f44c2f6c0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"42", ",", "29", ",", "18"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"50a75215-c485-4f67-92f7-8327ccfef4d8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"42", ",", "29", ",", "18"}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"94ec8033-bfd1-4f6c-8f98-c46eadb4cb70"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the grammatical structure of the first sentence of the Wikipedia \
article about computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2af9c1fe-9e09-492d-8797-7637ab822a91"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       InterpretationBox[
        TagBox[GridBox[{
           {
            InterpretationBox[GridBox[{
               {
                TemplateBox[{"\[ThinSpace]", "\" \"", 
                  InterpretationBox[
                   GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"A\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["A", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"computer\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["computer", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Noun"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                   TextElement[{
                    TextElement["A", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["computer", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]], 
                  InterpretationBox[
                   GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"is\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["is", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"a\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"general-purpose\""}, {
                    StyleBox["\"Adjective\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adjective"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"device\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Noun"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"that\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Wh-Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "WhNounPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"can\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["can", 
                    Association["GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"be\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"programmed\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"to\""}, {
                    StyleBox["\"Preposition\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"carry\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["carry", 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"out\""}, {
                    StyleBox["\"Particle\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Particle\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"a\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"set\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Noun"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"of\""}, {
                    StyleBox["\"Preposition\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"arithmetic\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"or\""}, {
                    StyleBox["\"Conjunction\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"logical\""}, {
                    StyleBox["\"Adjective\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"operations\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Noun"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox[
                    "\"Prepositional Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Clause\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"automatically\""}, {
                    StyleBox["\"Adverb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Adverb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Clause\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Verb"]]], 
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association["GrammaticalUnit" -> Entity["GrammaticalUnit",
                     "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Clause"]]]]}, "RowWithSeparators"]}, {
                    
                    StyleBox["\"Clause\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association["GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Noun"]]], 
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                   TextElement[{
                    TextElement["is", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]], 
                  InterpretationBox[
                   GridBox[{{"\".\""}, {
                    StyleBox["\"Punctuation\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                   TextElement[".", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Punctuation"]]]]},
                 "RowWithSeparators"]},
               {
                StyleBox["\<\"Sentence\"\>", "TextElementLabel"]}
              },
              BaseStyle->"TextElementGrid"],
             TextElement[{
               TextElement[{
                 TextElement["A", 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "Determiner"]]], 
                 TextElement["computer", 
                  Association[
                  "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                Association[
                "GrammaticalUnit" -> 
                 Entity["GrammaticalUnit", "NounPhrase"]]], 
               TextElement[{
                 TextElement["is", 
                  Association[
                  "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                 TextElement[{
                   TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                   TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                Association[
                "GrammaticalUnit" -> 
                 Entity["GrammaticalUnit", "VerbPhrase"]]], 
               TextElement[".", 
                Association[
                "GrammaticalUnit" -> 
                 Entity["GrammaticalUnit", "Punctuation"]]]}, 
              Association[
              "GrammaticalUnit" -> Entity["GrammaticalUnit", "Sentence"]]]]}
          },
          DefaultBaseStyle->"Column",
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
         "Column"],
        TextElement[{
          TextElement[{
            TextElement[{
              TextElement["A", 
               Association[
               "GrammaticalUnit" -> Entity["GrammaticalUnit", "Determiner"]]], 
              TextElement["computer", 
               Association[
               "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "NounPhrase"]]], 
            TextElement[{
              TextElement["is", 
               Association[
               "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
              TextElement[{
                TextElement[{
                  TextElement["a", 
                   Association[
                   "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                  TextElement["general-purpose", 
                   Association[
                   "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                  TextElement["device", 
                   Association[
                   "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                 
                 Association[
                 "GrammaticalUnit" -> 
                  Entity["GrammaticalUnit", "NounPhrase"]]], 
                TextElement[{
                  TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                   Association[
                   "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                  TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                   Association[
                   "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                 Association[
                 "GrammaticalUnit" -> Entity["GrammaticalUnit", "Clause"]]]}, 
               
               Association[
               "GrammaticalUnit" -> 
                Entity["GrammaticalUnit", "NounPhrase"]]]}, 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "VerbPhrase"]]], 
            TextElement[".", 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "Punctuation"]]]}, 
           Association[
           "GrammaticalUnit" -> Entity["GrammaticalUnit", "Sentence"]]]}]]], 
       "ExerciseOutput",ExpressionUUID->
       "7a1b81d8-b61c-47c6-9e05-666d3638dddf"],
      Apply[TextCell, 
       Cell[
        BoxData[
         InterpretationBox[
          TagBox[
           GridBox[{{
              InterpretationBox[
               GridBox[{{
                  TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"A\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["A", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"computer\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["computer", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Noun"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["A", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["computer", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"is\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["is", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"a\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"general-purpose\""}, {
                    StyleBox["\"Adjective\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adjective"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"device\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Noun"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"that\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Wh-Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "WhNounPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"can\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"be\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"programmed\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"to\""}, {
                    StyleBox["\"Preposition\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"carry\""}, {
                    StyleBox["\"Verb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"out\""}, {
                    StyleBox["\"Particle\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Particle\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"a\""}, {
                    StyleBox["\"Determiner\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"set\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Noun"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"of\""}, {
                    StyleBox["\"Preposition\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"arithmetic\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"or\""}, {
                    StyleBox["\"Conjunction\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"logical\""}, {
                    StyleBox["\"Adjective\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]]], 
                    InterpretationBox[
                    GridBox[{{"\"operations\""}, {
                    StyleBox["\"Noun\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Noun"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox[
                    "\"Prepositional Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "PrepositionalPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association["GrammaticalUnit" -> Entity["GrammaticalUnit",
                     "VerbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Clause\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]]], 
                    InterpretationBox[
                    GridBox[{{
                    TemplateBox[{"\[ThinSpace]", "\" \"", 
                    InterpretationBox[
                    GridBox[{{"\"automatically\""}, {
                    StyleBox["\"Adverb\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Adverb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["programmed", 
                    Association["GrammaticalUnit" -> Entity["GrammaticalUnit",
                     "Verb"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association["GrammaticalUnit" -> Entity["GrammaticalUnit",
                     "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association["GrammaticalUnit" -> Entity["GrammaticalUnit",
                     "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association["GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]]}, "RowWithSeparators"]}, {
                    StyleBox["\"Clause\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Clause"]]]]}, "RowWithSeparators"]}, {
                    
                    StyleBox["\"Clause\"", "TextElementLabel"]}}, BaseStyle -> 
                    "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "VerbPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Noun Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association["GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Noun"]]], 
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]]}, 
                    "RowWithSeparators"]}, {
                    StyleBox["\"Verb Phrase\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[{
                    TextElement["is", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", 
                    "NounPhrase"]]]}, 
                    Association["GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]], 
                    InterpretationBox[
                    GridBox[{{"\".\""}, {
                    StyleBox["\"Punctuation\"", "TextElementLabel"]}}, 
                    BaseStyle -> "TextElementGrid"], 
                    TextElement[".", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Punctuation"]]]]}, 
                   "RowWithSeparators"]}, {
                  StyleBox["\"Sentence\"", "TextElementLabel"]}}, BaseStyle -> 
                "TextElementGrid"], 
               TextElement[{
                 TextElement[{
                   TextElement["A", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                   TextElement["computer", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "NounPhrase"]]], 
                 TextElement[{
                   TextElement["is", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                   
                   TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "VerbPhrase"]]], 
                 TextElement[".", 
                  Association[
                  "GrammaticalUnit" -> 
                   Entity["GrammaticalUnit", "Punctuation"]]]}, 
                Association[
                "GrammaticalUnit" -> 
                 Entity["GrammaticalUnit", "Sentence"]]]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"], 
          TextElement[{
            TextElement[{
              TextElement[{
                TextElement["A", 
                 Association[
                 "GrammaticalUnit" -> 
                  Entity["GrammaticalUnit", "Determiner"]]], 
                TextElement["computer", 
                 Association[
                 "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
               Association[
               "GrammaticalUnit" -> Entity["GrammaticalUnit", "NounPhrase"]]], 
              TextElement[{
                TextElement["is", 
                 Association[
                 "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                TextElement[{
                  TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]], 
                    TextElement["general-purpose", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adjective"]]], 
                    TextElement["device", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                   Association[
                   "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]], 
                  TextElement[{
                    TextElement[{
                    TextElement["that", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Determiner"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "WhNounPhrase"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["can", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["be", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["programmed", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement[{
                    TextElement["to", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["carry", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Verb"]]], 
                    
                    TextElement[{
                    TextElement["out", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Particle"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Particle"]]], 
                    TextElement[{
                    TextElement[{
                    TextElement["a", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Determiner"]]], 
                    TextElement["set", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]], 
                    TextElement[{
                    TextElement["of", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Preposition"]]], 
                    TextElement[{
                    TextElement["arithmetic", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]], 
                    
                    TextElement["or", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Conjunction"]]], 
                    TextElement["logical", 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "Adjective"]]], 
                    TextElement["operations", 
                    Association[
                    "GrammaticalUnit" -> Entity["GrammaticalUnit", "Noun"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> Entity[
                    "GrammaticalUnit", "PrepositionalPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "NounPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]], 
                    TextElement[{
                    TextElement["automatically", 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Adverb"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "AdverbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "VerbPhrase"]]]}, 
                    Association[
                    "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                   Association[
                   "GrammaticalUnit" -> 
                    Entity["GrammaticalUnit", "Clause"]]]}, 
                 Association[
                 "GrammaticalUnit" -> 
                  Entity["GrammaticalUnit", "NounPhrase"]]]}, 
               Association[
               "GrammaticalUnit" -> Entity["GrammaticalUnit", "VerbPhrase"]]], 
              TextElement[".", 
               Association[
               "GrammaticalUnit" -> 
                Entity["GrammaticalUnit", "Punctuation"]]]}, 
             Association[
             "GrammaticalUnit" -> Entity["GrammaticalUnit", "Sentence"]]]}]]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5d1409e4-4beb-4774-a05e-db6037cc5d34"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the 10 most common nouns in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExampleData",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{"\<\"Text\"\>", ",", "\<\"AliceInWonderland\"\>"}], "}"}], "]"}]],
   "InlineCode",ExpressionUUID->"84b41b9e-0f14-43f2-964f-fc32132e5d75"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"de6ac8a0-450d-4772-9187-e1c43fdfb9f2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"door\"\>", ",", "\<\"voice\"\>", ",", "\<\"time\"\>", 
         ",", "\<\"way\"\>", ",", "\<\"moment\"\>", ",", "\<\"thing\"\>", 
         ",", "\<\"head\"\>", ",", "\<\"table\"\>", ",", "\<\"round\"\>", 
         ",", "\<\"nothing\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "06b6b38e-486a-4284-a80a-a1c42f92c46a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"door\"", ",", "\"voice\"", ",", "\"time\"", ",", 
             "\"way\"", ",", "\"moment\"", ",", "\"thing\"", ",", "\"head\"", 
             ",", "\"table\"", ",", "\"round\"", ",", "\"nothing\""}], "}"}]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1c9f954b-20c9-41f2-965b-bb4ee1e4e32b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a community graph plot of the graph representation of the text \
structure of the first sentence of the Wikipedia article about language.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"9d2f61c7-9fd6-4610-b149-229e2fe4250d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{2.0395577584570646`, 6.5585625171020805`}, {
             3.477646668572236, 5.2629555321795145`}, {4.04850702372663, 
             5.2629555321795145`}, {4.231879630402142, 5.721499687051441}, {
             4.358894147308115, 6.495955289934566}, {4.358894147308115, 
             7.06681564508896}, {3.8678825860315023`, 7.972721025949974}, {
             3.2970222308771078`, 7.972721025949974}, {2.0395577584570646`, 
             7.129422872256475}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{15.999018135250633`, 1.584179245830848}, {
             16.096503709013984`, -0.025200325767090415`}, {
             16.881974459477448`, -0.28543017757719713`}, {
             17.452834814631842`, -0.28543017757719713`}, {
             17.466066715035065`, 0.9918830518887437}, {17.466066715035065`, 
             1.562743407043138}, {16.569878490405028`, 2.1550396009852424`}, {
             15.999018135250633`, 2.1550396009852424`}}, SplineClosed -> 
             True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{11.545434079340959`, 4.3436666504281}, {
             12.116294434495353`, 4.3436666504281}, {13.043639402431184`, 
             5.1270130384369015`}, {13.127804603877335`, 5.465693079460678}, {
             13.156977760731863`, 5.8712528928750505`}, {13.156977760731863`, 
             6.442113248029445}, {12.586117405577468`, 6.442113248029445}, {
             11.622671038342046`, 6.38894037138851}, {11.545434079340959`, 
             4.914527005582494}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{17.045303586649318`, 7.120495160528133}, {
             17.210541582224554`, 6.382282618425469}, {18.194061276747345`, 
             5.988875251147611}, {18.76492163190174, 5.988875251147611}, {
             18.76492163190174, 6.559735606302006}, {17.950647204382655`, 
             7.891250533166247}, {17.624042858152922`, 8.141817980149662}, {
             17.053182502998528`, 8.141817980149662}, {17.045303586649318`, 
             7.6913555156825275`}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{19.789891483627997`, 8.36790684138196}, {
             19.834024946006792`, 7.950006517433321}, {20.217538891987566`, 
             7.650231052810361}, {20.606026472616204`, 7.447178623209785}, {
             20.985438431492703`, 7.2619585627659395`}, {21.556298786647098`, 
             7.2619585627659395`}, {21.556298786647098`, 7.832818917920334}, {
             20.93779782376967, 8.727536794110758}, {20.402885047099403`, 
             9.317725613389534}, {19.83202469194501, 9.317725613389534}, {
             19.789891483627997`, 8.938767196536354}}, SplineClosed -> 
             True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{8.44583181805175, 4.040676381102599}, {
             9.016692173206145, 4.040676381102599}, {9.701281286955524, 
             5.458765535675201}, {9.73687914499543, 5.7915805986398246`}, {
             9.762465621784818, 6.166723385344769}, {9.762465621784818, 
             6.737583740499163}, {9.191605266630424, 6.737583740499163}, {
             8.738883480435895, 5.882592148491443}, {8.64098243011356, 
             5.479138671363807}, {8.44583181805175, 4.611536736256993}}, 
             SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{15.00834810828516, 4.228008857602263}, {
             15.112486944513787`, 3.9068529752045382`}, {15.683347299668181`, 
             3.9068529752045382`}, {16.00634940823138, 4.103554465153193}, {
             16.00634940823138, 4.674414820307588}, {15.862463664124867`, 
             5.3685757554214355`}, {15.291603308970473`, 
             5.3685757554214355`}, {15.079264433073785`, 5.287006310316011}, {
             15.022044129855736`, 5.0782756256032515`}, {15.00834810828516, 
             4.7988692127566575`}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{21.521017095354452`, 10.4942960604088}, {
             21.58109558341657, 10.02592574283424}, {22.03047478392711, 
             9.836486670276416}, {22.473258977383182`, 9.798526480553308}, {
             23.044119332537576`, 9.798526480553308}, {23.044119332537576`, 
             10.369386835707703`}, {22.750113221230805`, 
             11.037280456842351`}, {22.216025170882464`, 11.48366333951917}, {
             21.64516481572807, 11.48366333951917}, {21.521017095354452`, 
             11.065156415563195`}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{6.268753128196075, 6.119212676532697}, {
             6.83961348335047, 6.119212676532697}, {6.931787959806478, 
             6.419120684994931}, {7.012897272949796, 6.68324599934637}, {
             7.084377398992264, 7.094875770905439}, {7.089916897866087, 
             7.622681662580236}, {7.089916897866087, 8.19354201773463}, {
             6.519056542711692, 8.19354201773463}, {6.379969927826465, 
             7.973345046527028}, {6.268753128196075, 6.690073031687091}}, 
             SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{0.730501328864719, 9.364843120900066}, {
             1.146284845252028, 9.230485949794371}, {1.7171452004064225`, 
             9.230485949794371}, {2.1404666382914037`, 9.300312693835123}, {
             2.1919270306227023`, 9.748540564964816}, {2.1919270306227023`, 
             10.319400920119211`}, {2.035692059989387, 10.749809862403398`}, {
             1.4648317048349924`, 10.749809862403398`}, {1.0255419807614636`, 
             10.452357397444157`}, {0.730501328864719, 9.93570347605446}}, 
             SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{-0.28543017757719713`, 
             4.6899401872896505`}, {-0.14413621280308486`, 
             4.053748217887782}, {0.21500764290763297`, 
             3.5996339287735397`}, {0.7858679980620272, 
             3.5996339287735397`}, {1.0330667147478927`, 
             3.9804886927258707`}, {1.1012153775787272`, 4.44165780078454}, {
             1.1012153775787272`, 5.012518155938935}, {0.716258047440517, 
             5.229859795587814}, {0.28543017757719713`, 
             5.260800542444045}, {-0.28543017757719713`, 5.260800542444045}}, 
             SplineClosed -> True]]}}, {
          {GrayLevel[0.65], Opacity[0.7], 
           LineBox[{{8.830764500120416, 4.76778436798636}, {8.731261995628948,
             4.326106558679796}}], 
           LineBox[{{8.830764500120416, 4.76778436798636}, {8.926412607690757,
             5.19370849378661}}], 
           LineBox[{{8.926412607690757, 5.19370849378661}, {9.024313658013092,
             5.597161970914246}}], 
           LineBox[{{9.451448967418234, 6.077010776217022}, {9.47703544420762,
             6.452153562921966}}], 
           LineBox[{{9.451448967418234, 6.077010776217022}, {
            9.415851109378327, 5.744195713252398}}], 
           LineBox[{{11.875163246050176`, 5.026919818638527}, {
            11.830864256918156`, 4.629096828005297}}], 
           LineBox[{{11.875163246050176`, 5.026919818638527}, {
            11.9548004060364, 5.388641928921964}}], 
           LineBox[{{11.896168886862089`, 5.706169417927664}, {
            11.908101215919244`, 6.103510193811313}}], 
           LineBox[{{11.896168886862089`, 5.706169417927664}, {
            11.9548004060364, 5.388641928921964}}], 
           LineBox[{{12.842374426300138`, 5.751123257037875}, {
            12.871547583154666`, 6.156683070452248}}], 
           LineBox[{{12.842374426300138`, 5.751123257037875}, {
            12.758209224853987`, 5.412443216014099}}], 
           LineBox[{{15.293778285862357`, 4.51343903517946}, {
            15.397917122090984`, 4.1922831527817355`}}], 
           LineBox[{{15.293778285862357`, 4.51343903517946}, {
            15.307474307432933`, 4.792845448026054}}], 
           LineBox[{{15.364694610650982`, 5.001576132738814}, {
            15.57703348654767, 5.083145577844238}}], 
           LineBox[{{15.364694610650982`, 5.001576132738814}, {
            15.307474307432933`, 4.792845448026054}}], 
           LineBox[{{15.540006115328657`, 4.6517883707344545`}, {
            15.720919230654182`, 4.3889846427303905`}}], 
           LineBox[{{15.540006115328657`, 4.6517883707344545`}, {
            15.307474307432933`, 4.792845448026054}}], 
           LineBox[{{17.330733764226515`, 7.40592533810533}, {
            17.338612680575725`, 7.856387802572466}}], 
           LineBox[{{17.330733764226515`, 7.40592533810533}, {
            17.42804562447487, 7.011568378869728}}], 
           LineBox[{{17.58529052825989, 7.227949413104001}, {
            17.665217026805458`, 7.605820355589049}}], 
           LineBox[{{17.58529052825989, 7.227949413104001}, {
            17.42804562447487, 7.011568378869728}}], 
           LineBox[{{17.42804562447487, 7.011568378869728}, {
            17.49597175980175, 6.667712796002666}}], 
           LineBox[{{18.197596024404255`, 6.496458493200662}, {
            18.479491454324542`, 6.274305428724809}}], 
           LineBox[{{18.197596024404255`, 6.496458493200662}, {
            17.92426388022225, 6.6781354204018015`}}], 
           LineBox[{{20.8914566501934, 7.732608800786982}, {21.2708686090699, 
            7.547388740343137}}], 
           LineBox[{{20.8914566501934, 7.732608800786982}, {
            20.502969069564763`, 7.935661230387558}}], 
           LineBox[{{20.502969069564763`, 7.935661230387558}, {
            20.11945512358399, 8.235436695010518}}], 
           LineBox[{{20.075321661205194`, 8.653337018959157}, {
            20.117454869522206`, 9.032295435812337}}], 
           LineBox[{{20.075321661205194`, 8.653337018959157}, {
            20.11945512358399, 8.235436695010518}}], 
           LineBox[{{20.329569296298793`, 8.347526828842227}, {
            20.652367646192474`, 8.442106616533561}}], 
           LineBox[{{20.329569296298793`, 8.347526828842227}, {
            20.11945512358399, 8.235436695010518}}], 
           LineBox[{{22.12426524804093, 10.505091376939237`}, {
            22.464683043653608`, 10.751850279265154`}}], 
           LineBox[{{22.12426524804093, 10.505091376939237`}, {
            21.866525760993767`, 10.311355920411437`}}], 
           LineBox[{{22.31590496150431, 10.121916847853614`}, {
            22.75868915496038, 10.083956658130505`}}], 
           LineBox[{{22.31590496150431, 10.121916847853614`}, {
            21.866525760993767`, 10.311355920411437`}}], 
           LineBox[{{21.80644727293165, 10.779726237985997`}, {
            21.930594993305267`, 11.198233161941973`}}], 
           LineBox[{{21.80644727293165, 10.779726237985997`}, {
            21.866525760993767`, 10.311355920411437`}}], 
           BezierCurveBox[{{21.866525760993767`, 10.311355920411437`}, {
            21.429758101641323`, 9.792376114061208}, {20.99299044228888, 
            9.273396307710978}, {20.556222782936434`, 8.754416501360748}, {
            20.11945512358399, 8.235436695010518}},
            SplineDegree->2], 
           BezierCurveBox[{{20.11945512358399, 8.235436695010518}, {
            19.570657312743556`, 7.846111376358339}, {19.02185950190312, 
            7.45678605770616}, {18.473061691062682`, 7.067460739053981}, {
            17.92426388022225, 6.6781354204018015`}},
            SplineDegree->2], 
           LineBox[{{17.92426388022225, 6.6781354204018015`}, {
            17.49597175980175, 6.667712796002666}}], 
           BezierCurveBox[{{17.49597175980175, 6.667712796002666}, {
            16.948847396709546`, 6.198995959008513}, {16.401723033617344`, 
            5.730279122014361}, {15.854598670525139`, 5.261562285020208}, {
            15.307474307432933`, 4.792845448026054}},
            SplineDegree->2], 
           LineBox[{{16.793357904784397`, 1.4490211966745212`}, {
            17.18063653745787, 1.2773132294659408`}}], 
           LineBox[{{16.793357904784397`, 1.4490211966745212`}, {
            16.4374666992978, 1.4830754767940535`}}], 
           LineBox[{{16.36512460083774, 0.692674639015185}, {
            16.38193388659118, 0.2602298518101067}}], 
           LineBox[{{16.36512460083774, 0.692674639015185}, {
            16.479300824567897`, 1.0584031533109348`}}], 
           LineBox[{{17.01754598909911, 0.38108391434786615`}, {
            17.167404637054645`, 0.}}], 
           LineBox[{{17.01754598909911, 0.38108391434786615`}, {
            16.785393771892803`, 0.7465967529652175}}], 
           LineBox[{{16.785393771892803`, 0.7465967529652175}, {
            16.479300824567897`, 1.0584031533109348`}}], 
           LineBox[{{16.479300824567897`, 1.0584031533109348`}, {
            16.4374666992978, 1.4830754767940535`}}], 
           LineBox[{{16.4374666992978, 1.4830754767940535`}, {
            16.28444831282783, 1.8696094234080451`}}], 
           BezierCurveBox[{{16.28444831282783, 1.8696094234080451`}, {
            16.040204811479107`, 2.6004184295625477`}, {15.795961310130382`, 
            3.3312274357170497`}, {15.551717808781657`, 4.062036441871552}, {
            15.307474307432933`, 4.792845448026054}},
            SplineDegree->2], 
           BezierCurveBox[{{15.307474307432933`, 4.792845448026054}, {
            14.670158036788196`, 4.947744890023065}, {14.03284176614346, 
            5.102644332020077}, {13.395525495498724`, 5.257543774017088}, {
            12.758209224853987`, 5.412443216014099}},
            SplineDegree->2], 
           LineBox[{{12.758209224853987`, 5.412443216014099}, {
            12.361940351560355`, 5.37871224059316}}], 
           LineBox[{{12.361940351560355`, 5.37871224059316}, {
            11.9548004060364, 5.388641928921964}}], 
           BezierCurveBox[{{11.9548004060364, 5.388641928921964}, {
            11.320063081871883`, 5.477530375004573}, {10.685325757707364`, 
            5.566418821087181}, {10.050588433542845`, 5.655307267169789}, {
            9.415851109378327, 5.744195713252398}},
            SplineDegree->2], 
           LineBox[{{9.415851109378327, 5.744195713252398}, {
            9.024313658013092, 5.597161970914246}}], 
           BezierCurveBox[{{9.024313658013092, 5.597161970914246}, {
            8.450102017352968, 5.9400405224165755`}, {7.875890376692846, 
            6.282919073918906}, {7.301678736032722, 6.625797625421238}, {
            6.727467095372599, 6.968676176923568}},
            SplineDegree->2], 
           LineBox[{{6.6463577822292805`, 6.704550862572129}, {
            6.554183305773273, 6.404642854109894}}], 
           LineBox[{{6.6463577822292805`, 6.704550862572129}, {
            6.727467095372599, 6.968676176923568}}], 
           LineBox[{{6.666918884122225, 7.218784134425622}, {
            6.665400105403663, 7.6879148689498304`}}], 
           LineBox[{{6.666918884122225, 7.218784134425622}, {
            6.727467095372599, 6.968676176923568}}], 
           LineBox[{{3.946449452824945, 6.006929864628638}, {
            3.763076846149433, 5.548385709756712}}], 
           LineBox[{{3.946449452824945, 6.006929864628638}, {
            4.003654888692572, 6.414693319708382}}], 
           LineBox[{{3.8031220871358196`, 6.174797550752306}, {
            3.5726117511431905`, 5.77490000536843}}], 
           LineBox[{{3.8031220871358196`, 6.174797550752306}, {
            4.003654888692572, 6.414693319708382}}], 
           LineBox[{{4.003654888692572, 6.414693319708382}, {
            4.073463969730918, 6.781385467511763}}], 
           LineBox[{{3.6859459725347854`, 7.346665021623218}, {
            3.582452408454305, 7.687290848372776}}], 
           LineBox[{{3.6859459725347854`, 7.346665021623218}, {
            3.7108937635453643`, 7.012229366001545}}], 
           LineBox[{{1.906496853045505, 10.033970742542014`}, {
            1.7502618824121896`, 10.4643796848262}}], 
           LineBox[{{1.906496853045505, 10.033970742542014`}, {
            1.8550364607142065`, 9.58574287141232}}], 
           LineBox[{{1.625039779060117, 9.832731905770173}, {
            1.3109721583386609`, 10.16692721986696}}], 
           LineBox[{{1.625039779060117, 9.832731905770173}, {
            1.8550364607142065`, 9.58574287141232}}], 
           LineBox[{{1.4317150228292252`, 9.515916127371568}, {
            1.015931506441916, 9.650273298477263}}], 
           LineBox[{{1.4317150228292252`, 9.515916127371568}, {
            1.8550364607142065`, 9.58574287141232}}], 
           BezierCurveBox[{{1.8550364607142065`, 9.58574287141232}, {
            2.2114803261030067`, 8.95446886728655}, {2.567924191491807, 
            8.323194863160783}, {2.924368056880607, 7.691920859035013}, {
            3.2808119222694074`, 7.060646854909245}},
            SplineDegree->2], 
           LineBox[{{2.6310395695789612`, 6.820752248659998}, {
            2.324987936034262, 6.843992694679278}}], 
           LineBox[{{2.6310395695789612`, 6.820752248659998}, {
            2.9263933420120036`, 6.856153618797502}}], 
           LineBox[{{0.4308278698633199, 4.944429618010616}, {0., 
            4.975370364866848}}], 
           LineBox[{{0.4308278698633199, 4.944429618010616}, {
            0.81578520000153, 4.727087978361737}}], 
           LineBox[{{0.5267622892354211, 4.561514212431248}, {
            0.14129396477411227`, 4.339178395464979}}], 
           LineBox[{{0.5267622892354211, 4.561514212431248}, {
            0.81578520000153, 4.727087978361737}}], 
           LineBox[{{0.7476365371706954, 4.265918870303068}, {
            0.5004378204848301, 3.885064106350737}}], 
           LineBox[{{0.7476365371706954, 4.265918870303068}, {
            0.81578520000153, 4.727087978361737}}], 
           BezierCurveBox[{{0.81578520000153, 4.727087978361737}, {
            1.3434372355041484`, 5.259354388470679}, {1.8710892710067668`, 
            5.79162079857962}, {2.398741306509385, 6.323887208688561}, {
            2.9263933420120036`, 6.856153618797502}},
            SplineDegree->2], 
           LineBox[{{2.9263933420120036`, 6.856153618797502}, {
            3.2808119222694074`, 7.060646854909245}}], 
           LineBox[{{3.2808119222694074`, 7.060646854909245}, {
            3.7108937635453643`, 7.012229366001545}}], 
           LineBox[{{3.7108937635453643`, 7.012229366001545}, {
            4.073463969730918, 6.781385467511763}}], 
           BezierCurveBox[{{4.073463969730918, 6.781385467511763}, {
            4.736964751141338, 6.828208144864714}, {5.400465532551758, 
            6.875030822217665}, {6.063966313962178, 6.9218534995706165`}, {
            6.727467095372599, 6.968676176923568}},
            SplineDegree->2], 
           LineBox[{{6.798947221415067, 7.380305948482636}, {6.80448672028889,
             7.908111840157433}}], 
           LineBox[{{6.798947221415067, 7.380305948482636}, {
            6.727467095372599, 6.968676176923568}}]}, 
          {GrayLevel[1], Opacity[0], EdgeForm[{GrayLevel[0], Opacity[
           0.7]}], {
            {Hue[0.1, 0.6, 0.7], 
             DiskBox[{8.830764500120416, 4.76778436798636}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Proper Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {8.830764500120416, 4.76778436798636},
             BaseStyle->"Graphics"]}, {
            {Hue[0.1, 0.6, 0.7], 
             DiskBox[{8.731261995628948, 4.326106558679796}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Language\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {8.731261995628948, 4.326106558679796},
             BaseStyle->"Graphics"]}, {
            {Hue[0.1, 0.6, 0.7], 
             DiskBox[{8.926412607690757, 5.19370849378661}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {8.926412607690757, 5.19370849378661},
             BaseStyle->"Graphics"]}, {
            {Hue[0.1, 0.6, 0.7], 
             DiskBox[{9.451448967418234, 6.077010776217022}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {9.451448967418234, 6.077010776217022},
             BaseStyle->"Graphics"]}, {
            {Hue[0.1, 0.6, 0.7], 
             DiskBox[{9.47703544420762, 6.452153562921966}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"is\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {9.47703544420762, 6.452153562921966},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{11.875163246050176, 5.026919818638527}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Determiner\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {11.875163246050176, 5.026919818638527},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{11.830864256918156, 4.629096828005297}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"the\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {11.830864256918156, 4.629096828005297},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{11.896168886862089, 5.706169417927664}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {11.896168886862089, 5.706169417927664},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{11.908101215919244, 6.103510193811313}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"ability\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {11.908101215919244, 6.103510193811313},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{12.842374426300138, 5.751123257037875}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Preposition\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {12.842374426300138, 5.751123257037875},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{12.871547583154666, 6.156683070452248}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"to\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {12.871547583154666, 6.156683070452248},
             BaseStyle->"Graphics"]}, {
            {Hue[0.5, 1, 0.7], 
             DiskBox[{15.293778285862357, 4.51343903517946}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {15.293778285862357, 4.51343903517946},
             BaseStyle->"Graphics"]}, {
            {Hue[0.5, 1, 0.7], 
             DiskBox[{15.397917122090984, 4.1922831527817355}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"acquire\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {15.397917122090984, 4.1922831527817355},
             BaseStyle->"Graphics"]}, {
            {Hue[0.5, 1, 0.7], 
             DiskBox[{15.364694610650982, 5.001576132738814}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Conjunction\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {15.364694610650982, 5.001576132738814},
             BaseStyle->"Graphics"]}, {
            {Hue[0.5, 1, 0.7], 
             DiskBox[{15.57703348654767, 5.083145577844238}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"and\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {15.57703348654767, 5.083145577844238},
             BaseStyle->"Graphics"]}, {
            {Hue[0.5, 1, 0.7], 
             DiskBox[{15.540006115328657, 4.6517883707344545}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"Verb\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {15.540006115328657, 4.6517883707344545},
             BaseStyle->"Graphics"]}, {
            {Hue[0.5, 1, 0.7], 
             DiskBox[{15.720919230654182, 4.3889846427303905}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"use\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {15.720919230654182, 4.3889846427303905},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{17.330733764226515, 7.40592533810533}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Adjective\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.330733764226515, 7.40592533810533},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{17.338612680575725, 7.856387802572466}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"complex\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.338612680575725, 7.856387802572466},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{17.58529052825989, 7.227949413104001}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.58529052825989, 7.227949413104001},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{17.665217026805458, 7.605820355589049}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"systems\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.665217026805458, 7.605820355589049},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{17.42804562447487, 7.011568378869728}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.42804562447487, 7.011568378869728},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{18.197596024404255, 6.496458493200662}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Preposition\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {18.197596024404255, 6.496458493200662},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{18.479491454324542, 6.274305428724809}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"of\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {18.479491454324542, 6.274305428724809},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{20.8914566501934, 7.732608800786982}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {20.8914566501934, 7.732608800786982},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{21.2708686090699, 7.547388740343137}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"communication\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {21.2708686090699, 7.547388740343137},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{20.502969069564763, 7.935661230387558}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {20.502969069564763, 7.935661230387558},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{20.075321661205194, 8.653337018959157}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Punctuation\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {20.075321661205194, 8.653337018959157},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{20.117454869522206, 9.032295435812337}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\",\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {20.117454869522206, 9.032295435812337},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{20.329569296298793, 8.347526828842227}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Adverb\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {20.329569296298793, 8.347526828842227},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{20.652367646192474, 8.442106616533561}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"particularly\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {20.652367646192474, 8.442106616533561},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1., 0.8], 
             DiskBox[{22.12426524804093, 10.505091376939237}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Determiner\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {22.12426524804093, 10.505091376939237},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1., 0.8], 
             DiskBox[{22.464683043653608, 10.751850279265154}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"the\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {22.464683043653608, 10.751850279265154},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1., 0.8], 
             DiskBox[{22.31590496150431, 10.121916847853614}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Adjective\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {22.31590496150431, 10.121916847853614},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1., 0.8], 
             DiskBox[{22.75868915496038, 10.083956658130505}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"human\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {22.75868915496038, 10.083956658130505},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1., 0.8], 
             DiskBox[{21.80644727293165, 10.779726237985997}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {21.80644727293165, 10.779726237985997},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1., 0.8], 
             DiskBox[{21.930594993305267, 11.198233161941973}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"ability\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {21.930594993305267, 11.198233161941973},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1., 0.8], 
             DiskBox[{21.866525760993767, 10.311355920411437}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {21.866525760993767, 10.311355920411437},
             BaseStyle->"Graphics"]}, {
            {Hue[0.2, 1, 0.6], 
             DiskBox[{20.11945512358399, 8.235436695010518}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {20.11945512358399, 8.235436695010518},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{17.92426388022225, 6.6781354204018015}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Prepositional Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.92426388022225, 6.6781354204018015},
             BaseStyle->"Graphics"]}, {
            {Hue[0.07, 1, 1], 
             DiskBox[{17.49597175980175, 6.667712796002666}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.49597175980175, 6.667712796002666},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{16.793357904784397, 1.4490211966745212}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"Preposition\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {16.793357904784397, 1.4490211966745212},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{17.18063653745787, 1.2773132294659408}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"to\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.18063653745787, 1.2773132294659408},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{16.36512460083774, 0.692674639015185}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {16.36512460083774, 0.692674639015185},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{16.38193388659118, 0.2602298518101067}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"do\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {16.38193388659118, 0.2602298518101067},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{17.01754598909911, 0.38108391434786615}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"Adverb\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.01754598909911, 0.38108391434786615},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], DiskBox[{17.167404637054645, 0.}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"so\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {17.167404637054645, 0.},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{16.785393771892803, 0.7465967529652175}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"Adverb Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {16.785393771892803, 0.7465967529652175},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{16.479300824567897, 1.0584031533109348}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"Verb Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {16.479300824567897, 1.0584031533109348},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{16.4374666992978, 1.4830754767940535}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {16.4374666992978, 1.4830754767940535},
             BaseStyle->"Graphics"]}, {
            {Hue[0.14, 1, 0.9], 
             DiskBox[{16.28444831282783, 1.8696094234080451}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Clause\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {16.28444831282783, 1.8696094234080451},
             BaseStyle->"Graphics"]}, {
            {Hue[0.5, 1, 0.7], 
             DiskBox[{15.307474307432933, 4.792845448026054}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {15.307474307432933, 4.792845448026054},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{12.758209224853987, 5.412443216014099}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {12.758209224853987, 5.412443216014099},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{12.361940351560355, 5.37871224059316}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Clause\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {12.361940351560355, 5.37871224059316},
             BaseStyle->"Graphics"]}, {
            {Hue[0.8, 0.6, 0.8], 
             DiskBox[{11.9548004060364, 5.388641928921964}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {11.9548004060364, 5.388641928921964},
             BaseStyle->"Graphics"]}, {
            {Hue[0.1, 0.6, 0.7], 
             DiskBox[{9.415851109378327, 5.744195713252398}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {9.415851109378327, 5.744195713252398},
             BaseStyle->"Graphics"]}, {
            {Hue[0.1, 0.6, 0.7], 
             DiskBox[{9.024313658013092, 5.597161970914246}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Clause\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {9.024313658013092, 5.597161970914246},
             BaseStyle->"Graphics"]}, {
            {Hue[1.8180339887498949`, 1., 0.8], 
             DiskBox[{6.6463577822292805, 6.704550862572129}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Punctuation\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {6.6463577822292805, 6.704550862572129},
             BaseStyle->"Graphics"]}, {
            {Hue[1.8180339887498949`, 1., 0.8], 
             DiskBox[{6.554183305773273, 6.404642854109894}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\",\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {6.554183305773273, 6.404642854109894},
             BaseStyle->"Graphics"]}, {
            {Hue[1.8180339887498949`, 1., 0.8], 
             DiskBox[{6.666918884122225, 7.218784134425622}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Conjunction\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {6.666918884122225, 7.218784134425622},
             BaseStyle->"Graphics"]}, {
            {Hue[1.8180339887498949`, 1., 0.8], 
             DiskBox[{6.665400105403663, 7.6879148689498304}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"and\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {6.665400105403663, 7.6879148689498304},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.946449452824945, 6.006929864628638}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Determiner\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.946449452824945, 6.006929864628638},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.763076846149433, 5.548385709756712}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"a\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.763076846149433, 5.548385709756712},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.8031220871358196, 6.174797550752306}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.8031220871358196, 6.174797550752306},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.5726117511431905, 5.77490000536843}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"language\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.5726117511431905, 5.77490000536843},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{4.003654888692572, 6.414693319708382}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {4.003654888692572, 6.414693319708382},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.6859459725347854, 7.346665021623218}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.6859459725347854, 7.346665021623218},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.582452408454305, 7.687290848372776}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"is\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.582452408454305, 7.687290848372776},
             BaseStyle->"Graphics"]}, {
            {Hue[3.43606797749979, 1., 0.8], 
             DiskBox[{1.906496853045505, 10.033970742542014}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Determiner\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {1.906496853045505, 10.033970742542014},
             BaseStyle->"Graphics"]}, {
            {Hue[3.43606797749979, 1., 0.8], 
             DiskBox[{1.7502618824121896, 10.4643796848262}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"any\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {1.7502618824121896, 10.4643796848262},
             BaseStyle->"Graphics"]}, {
            {Hue[3.43606797749979, 1., 0.8], 
             DiskBox[{1.625039779060117, 9.832731905770173}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Adjective\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {1.625039779060117, 9.832731905770173},
             BaseStyle->"Graphics"]}, {
            {Hue[3.43606797749979, 1., 0.8], 
             DiskBox[{1.3109721583386609, 10.16692721986696}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"specific\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {1.3109721583386609, 10.16692721986696},
             BaseStyle->"Graphics"]}, {
            {Hue[3.43606797749979, 1., 0.8], 
             DiskBox[{1.4317150228292252, 9.515916127371568}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {1.4317150228292252, 9.515916127371568},
             BaseStyle->"Graphics"]}, {
            {Hue[3.43606797749979, 1., 0.8], 
             DiskBox[{1.015931506441916, 9.650273298477263}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"example\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {1.015931506441916, 9.650273298477263},
             BaseStyle->"Graphics"]}, {
            {Hue[3.43606797749979, 1., 0.8], 
             DiskBox[{1.8550364607142065, 9.58574287141232}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {1.8550364607142065, 9.58574287141232},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{2.6310395695789612, 6.820752248659998}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Preposition\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {2.6310395695789612, 6.820752248659998},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{2.324987936034262, 6.843992694679278}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"of\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {2.324987936034262, 6.843992694679278},
             BaseStyle->"Graphics"]}, {
            {Hue[5.054101966249685, 1., 0.8], 
             DiskBox[{0.4308278698633199, 4.944429618010616}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Determiner\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {0.4308278698633199, 4.944429618010616},
             BaseStyle->"Graphics"]}, {
            {Hue[5.054101966249685, 1., 0.8], 
             DiskBox[{0., 4.975370364866848}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"such\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {0., 4.975370364866848},
             BaseStyle->"Graphics"]}, {
            {Hue[5.054101966249685, 1., 0.8], 
             DiskBox[{0.5267622892354211, 4.561514212431248}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Determiner\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {0.5267622892354211, 4.561514212431248},
             BaseStyle->"Graphics"]}, {
            {Hue[5.054101966249685, 1., 0.8], 
             DiskBox[{0.14129396477411227, 4.339178395464979}, 0.]}, 
            InsetBox[
             FrameBox[
              StyleBox["\<\"a\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {0.14129396477411227, 4.339178395464979},
             BaseStyle->"Graphics"]}, {
            {Hue[5.054101966249685, 1., 0.8], 
             DiskBox[{0.7476365371706954, 4.265918870303068}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {0.7476365371706954, 4.265918870303068},
             BaseStyle->"Graphics"]}, {
            {Hue[5.054101966249685, 1., 0.8], 
             DiskBox[{0.5004378204848301, 3.885064106350737}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"system\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {0.5004378204848301, 3.885064106350737},
             BaseStyle->"Graphics"]}, {
            {Hue[5.054101966249685, 1., 0.8], 
             DiskBox[{0.81578520000153, 4.727087978361737}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {0.81578520000153, 4.727087978361737},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{2.9263933420120036, 6.856153618797502}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Prepositional Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {2.9263933420120036, 6.856153618797502},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.2808119222694074, 7.060646854909245}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Noun Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.2808119222694074, 7.060646854909245},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{3.7108937635453643, 7.012229366001545}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Verb Phrase\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {3.7108937635453643, 7.012229366001545},
             BaseStyle->"Graphics"]}, {
            {Hue[0, 1, 0.8], 
             DiskBox[{4.073463969730918, 6.781385467511763}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Clause\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {4.073463969730918, 6.781385467511763},
             BaseStyle->"Graphics"]}, {
            {Hue[1.8180339887498949`, 1., 0.8], 
             DiskBox[{6.798947221415067, 7.380305948482636}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Punctuation\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {6.798947221415067, 7.380305948482636},
             BaseStyle->"Graphics"]}, {
            {Hue[1.8180339887498949`, 1., 0.8], 
             DiskBox[{6.80448672028889, 7.908111840157433}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\".\"\>",
               StripOnInput->False,
               FontFamily->"Arial",
               FontSize->Medium],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {6.80448672028889, 7.908111840157433},
             BaseStyle->"Graphics"]}, {
            {Hue[1.8180339887498949`, 1., 0.8], 
             DiskBox[{6.727467095372599, 6.968676176923568}, 0.]}, InsetBox[
             FrameBox[
              StyleBox["\<\"Sentence\"\>",
               StripOnInput->False,
               FontColor->GrayLevel[0.55],
               $CellContext`LineColor -> GrayLevel[0.55],
               $CellContext`FrontFaceColor -> GrayLevel[0.55],
               $CellContext`GraphicsColor -> GrayLevel[0.55],
               $CellContext`BackFaceColor -> GrayLevel[0.55]],
              Background->Directive[
                GrayLevel[1], 
                Opacity[1]],
              FrameMargins->{{0, 0}, {-1, -2}},
              FrameStyle->Directive[
                GrayLevel[1], 
                Opacity[0]],
              RoundingRadius->2,
              StripOnInput->False], {6.727467095372599, 6.968676176923568},
             BaseStyle->"Graphics"]}}}},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{Automatic, 304.2460797641411}]], "ExerciseOutput",
       ExpressionUUID->"65ae7559-3940-448f-b457-645b83d300e6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{2.0395577584570646`, 6.5585625171020805`}, {
                3.477646668572236, 5.2629555321795145`}, {4.04850702372663, 
                5.2629555321795145`}, {4.231879630402142, 
                5.721499687051441}, {4.358894147308115, 6.495955289934566}, {
                4.358894147308115, 7.06681564508896}, {3.8678825860315023`, 
                7.972721025949974}, {3.2970222308771078`, 
                7.972721025949974}, {2.0395577584570646`, 7.129422872256475}},
                 SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{15.999018135250633`, 1.584179245830848}, {
                16.096503709013984`, -0.025200325767090415`}, {
                16.881974459477448`, -0.28543017757719713`}, {
                17.452834814631842`, -0.28543017757719713`}, {
                17.466066715035065`, 0.9918830518887437}, {
                17.466066715035065`, 1.562743407043138}, {16.569878490405028`,
                 2.1550396009852424`}, {15.999018135250633`, 
                2.1550396009852424`}}, SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{11.545434079340959`, 4.3436666504281}, {
                12.116294434495353`, 4.3436666504281}, {13.043639402431184`, 
                5.1270130384369015`}, {13.127804603877335`, 
                5.465693079460678}, {13.156977760731863`, 
                5.8712528928750505`}, {13.156977760731863`, 
                6.442113248029445}, {12.586117405577468`, 
                6.442113248029445}, {11.622671038342046`, 6.38894037138851}, {
                11.545434079340959`, 4.914527005582494}}, SplineClosed -> 
                True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{17.045303586649318`, 7.120495160528133}, {
                17.210541582224554`, 6.382282618425469}, {18.194061276747345`,
                 5.988875251147611}, {18.76492163190174, 5.988875251147611}, {
                18.76492163190174, 6.559735606302006}, {17.950647204382655`, 
                7.891250533166247}, {17.624042858152922`, 
                8.141817980149662}, {17.053182502998528`, 
                8.141817980149662}, {17.045303586649318`, 
                7.6913555156825275`}}, SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{19.789891483627997`, 8.36790684138196}, {
                19.834024946006792`, 7.950006517433321}, {20.217538891987566`,
                 7.650231052810361}, {20.606026472616204`, 
                7.447178623209785}, {20.985438431492703`, 
                7.2619585627659395`}, {21.556298786647098`, 
                7.2619585627659395`}, {21.556298786647098`, 
                7.832818917920334}, {20.93779782376967, 8.727536794110758}, {
                20.402885047099403`, 9.317725613389534}, {19.83202469194501, 
                9.317725613389534}, {19.789891483627997`, 8.938767196536354}},
                 SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{8.44583181805175, 4.040676381102599}, {
                9.016692173206145, 4.040676381102599}, {9.701281286955524, 
                5.458765535675201}, {9.73687914499543, 5.7915805986398246`}, {
                9.762465621784818, 6.166723385344769}, {9.762465621784818, 
                6.737583740499163}, {9.191605266630424, 6.737583740499163}, {
                8.738883480435895, 5.882592148491443}, {8.64098243011356, 
                5.479138671363807}, {8.44583181805175, 4.611536736256993}}, 
                SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{15.00834810828516, 4.228008857602263}, {
                15.112486944513787`, 3.9068529752045382`}, {
                15.683347299668181`, 3.9068529752045382`}, {16.00634940823138,
                 4.103554465153193}, {16.00634940823138, 4.674414820307588}, {
                15.862463664124867`, 5.3685757554214355`}, {
                15.291603308970473`, 5.3685757554214355`}, {
                15.079264433073785`, 5.287006310316011}, {15.022044129855736`,
                 5.0782756256032515`}, {15.00834810828516, 
                4.7988692127566575`}}, SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{21.521017095354452`, 10.4942960604088}, {
                21.58109558341657, 10.02592574283424}, {22.03047478392711, 
                9.836486670276416}, {22.473258977383182`, 
                9.798526480553308}, {23.044119332537576`, 
                9.798526480553308}, {23.044119332537576`, 
                10.369386835707703`}, {22.750113221230805`, 
                11.037280456842351`}, {22.216025170882464`, 
                11.48366333951917}, {21.64516481572807, 11.48366333951917}, {
                21.521017095354452`, 11.065156415563195`}}, SplineClosed -> 
                True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{6.268753128196075, 6.119212676532697}, {
                6.83961348335047, 6.119212676532697}, {6.931787959806478, 
                6.419120684994931}, {7.012897272949796, 6.68324599934637}, {
                7.084377398992264, 7.094875770905439}, {7.089916897866087, 
                7.622681662580236}, {7.089916897866087, 8.19354201773463}, {
                6.519056542711692, 8.19354201773463}, {6.379969927826465, 
                7.973345046527028}, {6.268753128196075, 6.690073031687091}}, 
                SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{0.730501328864719, 9.364843120900066}, {
                1.146284845252028, 9.230485949794371}, {1.7171452004064225`, 
                9.230485949794371}, {2.1404666382914037`, 
                9.300312693835123}, {2.1919270306227023`, 
                9.748540564964816}, {2.1919270306227023`, 
                10.319400920119211`}, {2.035692059989387, 
                10.749809862403398`}, {1.4648317048349924`, 
                10.749809862403398`}, {1.0255419807614636`, 
                10.452357397444157`}, {0.730501328864719, 9.93570347605446}}, 
                SplineClosed -> True]]}}, {{
              EdgeForm[
               GrayLevel[0.5]], 
              FaceForm[None], 
              FilledCurveBox[
               
               BSplineCurve[{{-0.28543017757719713`, 
                4.6899401872896505`}, {-0.14413621280308486`, 
                4.053748217887782}, {0.21500764290763297`, 
                3.5996339287735397`}, {0.7858679980620272, 
                3.5996339287735397`}, {1.0330667147478927`, 
                3.9804886927258707`}, {1.1012153775787272`, 
                4.44165780078454}, {1.1012153775787272`, 5.012518155938935}, {
                0.716258047440517, 5.229859795587814}, {0.28543017757719713`, 
                5.260800542444045}, {-0.28543017757719713`, 
                5.260800542444045}}, SplineClosed -> True]]}}}, {{{
              GrayLevel[0.65], 
              Opacity[0.7], 
              
              LineBox[{{8.830764500120416, 4.76778436798636}, {
               8.731261995628948, 4.326106558679796}}], 
              
              LineBox[{{8.830764500120416, 4.76778436798636}, {
               8.926412607690757, 5.19370849378661}}], 
              
              LineBox[{{8.926412607690757, 5.19370849378661}, {
               9.024313658013092, 5.597161970914246}}], 
              
              LineBox[{{9.451448967418234, 6.077010776217022}, {
               9.47703544420762, 6.452153562921966}}], 
              
              LineBox[{{9.451448967418234, 6.077010776217022}, {
               9.415851109378327, 5.744195713252398}}], 
              
              LineBox[{{11.875163246050176`, 5.026919818638527}, {
               11.830864256918156`, 4.629096828005297}}], 
              
              LineBox[{{11.875163246050176`, 5.026919818638527}, {
               11.9548004060364, 5.388641928921964}}], 
              
              LineBox[{{11.896168886862089`, 5.706169417927664}, {
               11.908101215919244`, 6.103510193811313}}], 
              
              LineBox[{{11.896168886862089`, 5.706169417927664}, {
               11.9548004060364, 5.388641928921964}}], 
              
              LineBox[{{12.842374426300138`, 5.751123257037875}, {
               12.871547583154666`, 6.156683070452248}}], 
              
              LineBox[{{12.842374426300138`, 5.751123257037875}, {
               12.758209224853987`, 5.412443216014099}}], 
              
              LineBox[{{15.293778285862357`, 4.51343903517946}, {
               15.397917122090984`, 4.1922831527817355`}}], 
              
              LineBox[{{15.293778285862357`, 4.51343903517946}, {
               15.307474307432933`, 4.792845448026054}}], 
              
              LineBox[{{15.364694610650982`, 5.001576132738814}, {
               15.57703348654767, 5.083145577844238}}], 
              
              LineBox[{{15.364694610650982`, 5.001576132738814}, {
               15.307474307432933`, 4.792845448026054}}], 
              
              LineBox[{{15.540006115328657`, 4.6517883707344545`}, {
               15.720919230654182`, 4.3889846427303905`}}], 
              
              LineBox[{{15.540006115328657`, 4.6517883707344545`}, {
               15.307474307432933`, 4.792845448026054}}], 
              
              LineBox[{{17.330733764226515`, 7.40592533810533}, {
               17.338612680575725`, 7.856387802572466}}], 
              
              LineBox[{{17.330733764226515`, 7.40592533810533}, {
               17.42804562447487, 7.011568378869728}}], 
              
              LineBox[{{17.58529052825989, 7.227949413104001}, {
               17.665217026805458`, 7.605820355589049}}], 
              
              LineBox[{{17.58529052825989, 7.227949413104001}, {
               17.42804562447487, 7.011568378869728}}], 
              
              LineBox[{{17.42804562447487, 7.011568378869728}, {
               17.49597175980175, 6.667712796002666}}], 
              
              LineBox[{{18.197596024404255`, 6.496458493200662}, {
               18.479491454324542`, 6.274305428724809}}], 
              
              LineBox[{{18.197596024404255`, 6.496458493200662}, {
               17.92426388022225, 6.6781354204018015`}}], 
              
              LineBox[{{20.8914566501934, 7.732608800786982}, {
               21.2708686090699, 7.547388740343137}}], 
              
              LineBox[{{20.8914566501934, 7.732608800786982}, {
               20.502969069564763`, 7.935661230387558}}], 
              
              LineBox[{{20.502969069564763`, 7.935661230387558}, {
               20.11945512358399, 8.235436695010518}}], 
              
              LineBox[{{20.075321661205194`, 8.653337018959157}, {
               20.117454869522206`, 9.032295435812337}}], 
              
              LineBox[{{20.075321661205194`, 8.653337018959157}, {
               20.11945512358399, 8.235436695010518}}], 
              
              LineBox[{{20.329569296298793`, 8.347526828842227}, {
               20.652367646192474`, 8.442106616533561}}], 
              LineBox[{{20.329569296298793`, 8.347526828842227}, {
               20.11945512358399, 8.235436695010518}}], 
              
              LineBox[{{22.12426524804093, 10.505091376939237`}, {
               22.464683043653608`, 10.751850279265154`}}], 
              
              LineBox[{{22.12426524804093, 10.505091376939237`}, {
               21.866525760993767`, 10.311355920411437`}}], 
              
              LineBox[{{22.31590496150431, 10.121916847853614`}, {
               22.75868915496038, 10.083956658130505`}}], 
              
              LineBox[{{22.31590496150431, 10.121916847853614`}, {
               21.866525760993767`, 10.311355920411437`}}], 
              
              LineBox[{{21.80644727293165, 10.779726237985997`}, {
               21.930594993305267`, 11.198233161941973`}}], 
              
              LineBox[{{21.80644727293165, 10.779726237985997`}, {
               21.866525760993767`, 10.311355920411437`}}], 
              
              BezierCurveBox[{{21.866525760993767`, 10.311355920411437`}, {
               21.429758101641323`, 9.792376114061208}, {20.99299044228888, 
               9.273396307710978}, {20.556222782936434`, 8.754416501360748}, {
               20.11945512358399, 8.235436695010518}}, SplineDegree -> 2], 
              
              BezierCurveBox[{{20.11945512358399, 8.235436695010518}, {
               19.570657312743556`, 7.846111376358339}, {19.02185950190312, 
               7.45678605770616}, {18.473061691062682`, 7.067460739053981}, {
               17.92426388022225, 6.6781354204018015`}}, SplineDegree -> 2], 
              
              LineBox[{{17.92426388022225, 6.6781354204018015`}, {
               17.49597175980175, 6.667712796002666}}], 
              
              BezierCurveBox[{{17.49597175980175, 6.667712796002666}, {
               16.948847396709546`, 6.198995959008513}, {16.401723033617344`, 
               5.730279122014361}, {15.854598670525139`, 5.261562285020208}, {
               15.307474307432933`, 4.792845448026054}}, SplineDegree -> 2], 
              
              LineBox[{{16.793357904784397`, 1.4490211966745212`}, {
               17.18063653745787, 1.2773132294659408`}}], 
              
              LineBox[{{16.793357904784397`, 1.4490211966745212`}, {
               16.4374666992978, 1.4830754767940535`}}], 
              LineBox[{{16.36512460083774, 0.692674639015185}, {
               16.38193388659118, 0.2602298518101067}}], 
              
              LineBox[{{16.36512460083774, 0.692674639015185}, {
               16.479300824567897`, 1.0584031533109348`}}], 
              
              LineBox[{{17.01754598909911, 0.38108391434786615`}, {
               17.167404637054645`, 0.}}], 
              
              LineBox[{{17.01754598909911, 0.38108391434786615`}, {
               16.785393771892803`, 0.7465967529652175}}], 
              
              LineBox[{{16.785393771892803`, 0.7465967529652175}, {
               16.479300824567897`, 1.0584031533109348`}}], 
              
              LineBox[{{16.479300824567897`, 1.0584031533109348`}, {
               16.4374666992978, 1.4830754767940535`}}], 
              
              LineBox[{{16.4374666992978, 1.4830754767940535`}, {
               16.28444831282783, 1.8696094234080451`}}], 
              
              BezierCurveBox[{{16.28444831282783, 1.8696094234080451`}, {
               16.040204811479107`, 2.6004184295625477`}, {
               15.795961310130382`, 3.3312274357170497`}, {
               15.551717808781657`, 4.062036441871552}, {15.307474307432933`, 
               4.792845448026054}}, SplineDegree -> 2], 
              
              BezierCurveBox[{{15.307474307432933`, 4.792845448026054}, {
               14.670158036788196`, 4.947744890023065}, {14.03284176614346, 
               5.102644332020077}, {13.395525495498724`, 5.257543774017088}, {
               12.758209224853987`, 5.412443216014099}}, SplineDegree -> 2], 
              
              LineBox[{{12.758209224853987`, 5.412443216014099}, {
               12.361940351560355`, 5.37871224059316}}], 
              
              LineBox[{{12.361940351560355`, 5.37871224059316}, {
               11.9548004060364, 5.388641928921964}}], 
              
              BezierCurveBox[{{11.9548004060364, 5.388641928921964}, {
               11.320063081871883`, 5.477530375004573}, {10.685325757707364`, 
               5.566418821087181}, {10.050588433542845`, 5.655307267169789}, {
               9.415851109378327, 5.744195713252398}}, SplineDegree -> 2], 
              
              LineBox[{{9.415851109378327, 5.744195713252398}, {
               9.024313658013092, 5.597161970914246}}], 
              BezierCurveBox[{{9.024313658013092, 5.597161970914246}, {
               8.450102017352968, 5.9400405224165755`}, {7.875890376692846, 
               6.282919073918906}, {7.301678736032722, 6.625797625421238}, {
               6.727467095372599, 6.968676176923568}}, SplineDegree -> 2], 
              
              LineBox[{{6.6463577822292805`, 6.704550862572129}, {
               6.554183305773273, 6.404642854109894}}], 
              
              LineBox[{{6.6463577822292805`, 6.704550862572129}, {
               6.727467095372599, 6.968676176923568}}], 
              
              LineBox[{{6.666918884122225, 7.218784134425622}, {
               6.665400105403663, 7.6879148689498304`}}], 
              
              LineBox[{{6.666918884122225, 7.218784134425622}, {
               6.727467095372599, 6.968676176923568}}], 
              
              LineBox[{{3.946449452824945, 6.006929864628638}, {
               3.763076846149433, 5.548385709756712}}], 
              
              LineBox[{{3.946449452824945, 6.006929864628638}, {
               4.003654888692572, 6.414693319708382}}], 
              
              LineBox[{{3.8031220871358196`, 6.174797550752306}, {
               3.5726117511431905`, 5.77490000536843}}], 
              
              LineBox[{{3.8031220871358196`, 6.174797550752306}, {
               4.003654888692572, 6.414693319708382}}], 
              
              LineBox[{{4.003654888692572, 6.414693319708382}, {
               4.073463969730918, 6.781385467511763}}], 
              
              LineBox[{{3.6859459725347854`, 7.346665021623218}, {
               3.582452408454305, 7.687290848372776}}], 
              
              LineBox[{{3.6859459725347854`, 7.346665021623218}, {
               3.7108937635453643`, 7.012229366001545}}], 
              
              LineBox[{{1.906496853045505, 10.033970742542014`}, {
               1.7502618824121896`, 10.4643796848262}}], 
              
              LineBox[{{1.906496853045505, 10.033970742542014`}, {
               1.8550364607142065`, 9.58574287141232}}], 
              
              LineBox[{{1.625039779060117, 9.832731905770173}, {
               1.3109721583386609`, 10.16692721986696}}], 
              
              LineBox[{{1.625039779060117, 9.832731905770173}, {
               1.8550364607142065`, 9.58574287141232}}], 
              LineBox[{{1.4317150228292252`, 9.515916127371568}, {
               1.015931506441916, 9.650273298477263}}], 
              
              LineBox[{{1.4317150228292252`, 9.515916127371568}, {
               1.8550364607142065`, 9.58574287141232}}], 
              
              BezierCurveBox[{{1.8550364607142065`, 9.58574287141232}, {
               2.2114803261030067`, 8.95446886728655}, {2.567924191491807, 
               8.323194863160783}, {2.924368056880607, 7.691920859035013}, {
               3.2808119222694074`, 7.060646854909245}}, SplineDegree -> 2], 
              
              LineBox[{{2.6310395695789612`, 6.820752248659998}, {
               2.324987936034262, 6.843992694679278}}], 
              
              LineBox[{{2.6310395695789612`, 6.820752248659998}, {
               2.9263933420120036`, 6.856153618797502}}], 
              
              LineBox[{{0.4308278698633199, 4.944429618010616}, {0., 
               4.975370364866848}}], 
              
              LineBox[{{0.4308278698633199, 4.944429618010616}, {
               0.81578520000153, 4.727087978361737}}], 
              
              LineBox[{{0.5267622892354211, 4.561514212431248}, {
               0.14129396477411227`, 4.339178395464979}}], 
              
              LineBox[{{0.5267622892354211, 4.561514212431248}, {
               0.81578520000153, 4.727087978361737}}], 
              
              LineBox[{{0.7476365371706954, 4.265918870303068}, {
               0.5004378204848301, 3.885064106350737}}], 
              
              LineBox[{{0.7476365371706954, 4.265918870303068}, {
               0.81578520000153, 4.727087978361737}}], 
              
              BezierCurveBox[{{0.81578520000153, 4.727087978361737}, {
               1.3434372355041484`, 5.259354388470679}, {1.8710892710067668`, 
               5.79162079857962}, {2.398741306509385, 6.323887208688561}, {
               2.9263933420120036`, 6.856153618797502}}, SplineDegree -> 2], 
              
              LineBox[{{2.9263933420120036`, 6.856153618797502}, {
               3.2808119222694074`, 7.060646854909245}}], 
              
              LineBox[{{3.2808119222694074`, 7.060646854909245}, {
               3.7108937635453643`, 7.012229366001545}}], 
              
              LineBox[{{3.7108937635453643`, 7.012229366001545}, {
               4.073463969730918, 6.781385467511763}}], 
              BezierCurveBox[{{4.073463969730918, 6.781385467511763}, {
               4.736964751141338, 6.828208144864714}, {5.400465532551758, 
               6.875030822217665}, {6.063966313962178, 6.9218534995706165`}, {
               6.727467095372599, 6.968676176923568}}, SplineDegree -> 2], 
              
              LineBox[{{6.798947221415067, 7.380305948482636}, {
               6.80448672028889, 7.908111840157433}}], 
              
              LineBox[{{6.798947221415067, 7.380305948482636}, {
               6.727467095372599, 6.968676176923568}}]}}, {{
              GrayLevel[1], 
              Opacity[0], 
              EdgeForm[{
                GrayLevel[0], 
                Opacity[0.7]}], {{{
                 Hue[0.1, 0.6, 0.7], 
                 DiskBox[{8.830764500120416, 4.76778436798636}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Proper Noun\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                8.830764500120416, 4.76778436798636}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.1, 0.6, 0.7], 
                 DiskBox[{8.731261995628948, 4.326106558679796}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Language\"", StripOnInput -> False, FontFamily -> "Arial",
                   FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                8.731261995628948, 4.326106558679796}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.1, 0.6, 0.7], 
                 DiskBox[{8.926412607690757, 5.19370849378661}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                8.926412607690757, 5.19370849378661}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.1, 0.6, 0.7], 
                 DiskBox[{9.451448967418234, 6.077010776217022}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                9.451448967418234, 6.077010776217022}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.1, 0.6, 0.7], 
                 DiskBox[{9.47703544420762, 6.452153562921966}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"is\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                9.47703544420762, 6.452153562921966}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{11.875163246050176`, 5.026919818638527}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Determiner\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                11.875163246050176`, 5.026919818638527}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{11.830864256918156`, 4.629096828005297}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"the\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                11.830864256918156`, 4.629096828005297}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{11.896168886862089`, 5.706169417927664}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                11.896168886862089`, 5.706169417927664}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{11.908101215919244`, 6.103510193811313}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"ability\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                11.908101215919244`, 6.103510193811313}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{12.842374426300138`, 5.751123257037875}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Preposition\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                12.842374426300138`, 5.751123257037875}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{12.871547583154666`, 6.156683070452248}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"to\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                12.871547583154666`, 6.156683070452248}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.5, 1, 0.7], 
                 DiskBox[{15.293778285862357`, 4.51343903517946}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                15.293778285862357`, 4.51343903517946}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.5, 1, 0.7], 
                 DiskBox[{15.397917122090984`, 4.1922831527817355`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"acquire\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                15.397917122090984`, 4.1922831527817355`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.5, 1, 0.7], 
                 DiskBox[{15.364694610650982`, 5.001576132738814}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Conjunction\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                15.364694610650982`, 5.001576132738814}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.5, 1, 0.7], 
                 DiskBox[{15.57703348654767, 5.083145577844238}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"and\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                15.57703348654767, 5.083145577844238}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.5, 1, 0.7], 
                 DiskBox[{15.540006115328657`, 4.6517883707344545`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                15.540006115328657`, 4.6517883707344545`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.5, 1, 0.7], 
                 DiskBox[{15.720919230654182`, 4.3889846427303905`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"use\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                15.720919230654182`, 4.3889846427303905`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{17.330733764226515`, 7.40592533810533}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Adjective\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.330733764226515`, 7.40592533810533}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{17.338612680575725`, 7.856387802572466}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"complex\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.338612680575725`, 7.856387802572466}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{17.58529052825989, 7.227949413104001}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.58529052825989, 7.227949413104001}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{17.665217026805458`, 7.605820355589049}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"systems\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.665217026805458`, 7.605820355589049}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{17.42804562447487, 7.011568378869728}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.42804562447487, 7.011568378869728}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{18.197596024404255`, 6.496458493200662}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Preposition\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                18.197596024404255`, 6.496458493200662}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{18.479491454324542`, 6.274305428724809}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"of\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                18.479491454324542`, 6.274305428724809}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{20.8914566501934, 7.732608800786982}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                20.8914566501934, 7.732608800786982}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{21.2708686090699, 7.547388740343137}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"communication\"", StripOnInput -> False, FontFamily -> 
                  "Arial", FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                21.2708686090699, 7.547388740343137}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{20.502969069564763`, 7.935661230387558}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                20.502969069564763`, 7.935661230387558}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{20.075321661205194`, 8.653337018959157}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Punctuation\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                20.075321661205194`, 8.653337018959157}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{20.117454869522206`, 9.032295435812337}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\",\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                20.117454869522206`, 9.032295435812337}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{20.329569296298793`, 8.347526828842227}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Adverb\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                20.329569296298793`, 8.347526828842227}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{20.652367646192474`, 8.442106616533561}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"particularly\"", StripOnInput -> False, FontFamily -> 
                  "Arial", FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                20.652367646192474`, 8.442106616533561}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1., 0.8], 
                 DiskBox[{22.12426524804093, 10.505091376939237`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Determiner\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                22.12426524804093, 10.505091376939237`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1., 0.8], 
                 DiskBox[{22.464683043653608`, 10.751850279265154`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"the\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                22.464683043653608`, 10.751850279265154`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1., 0.8], 
                 DiskBox[{22.31590496150431, 10.121916847853614`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Adjective\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                22.31590496150431, 10.121916847853614`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1., 0.8], 
                 DiskBox[{22.75868915496038, 10.083956658130505`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"human\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                22.75868915496038, 10.083956658130505`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1., 0.8], 
                 DiskBox[{21.80644727293165, 10.779726237985997`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                21.80644727293165, 10.779726237985997`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1., 0.8], 
                 DiskBox[{21.930594993305267`, 11.198233161941973`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"ability\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                21.930594993305267`, 11.198233161941973`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1., 0.8], 
                 DiskBox[{21.866525760993767`, 10.311355920411437`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                21.866525760993767`, 10.311355920411437`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.2, 1, 0.6], 
                 DiskBox[{20.11945512358399, 8.235436695010518}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                20.11945512358399, 8.235436695010518}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{17.92426388022225, 6.6781354204018015`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Prepositional Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.92426388022225, 6.6781354204018015`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.07, 1, 1], 
                 DiskBox[{17.49597175980175, 6.667712796002666}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.49597175980175, 6.667712796002666}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{16.793357904784397`, 1.4490211966745212`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Preposition\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                16.793357904784397`, 1.4490211966745212`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{17.18063653745787, 1.2773132294659408`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"to\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.18063653745787, 1.2773132294659408`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{16.36512460083774, 0.692674639015185}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                16.36512460083774, 0.692674639015185}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{16.38193388659118, 0.2602298518101067}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"do\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                16.38193388659118, 0.2602298518101067}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{17.01754598909911, 0.38108391434786615`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Adverb\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.01754598909911, 0.38108391434786615`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{17.167404637054645`, 0.}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"so\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                17.167404637054645`, 0.}, BaseStyle -> "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{16.785393771892803`, 0.7465967529652175}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Adverb Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                16.785393771892803`, 0.7465967529652175}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{16.479300824567897`, 1.0584031533109348`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                16.479300824567897`, 1.0584031533109348`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{16.4374666992978, 1.4830754767940535`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                16.4374666992978, 1.4830754767940535`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.14, 1, 0.9], 
                 DiskBox[{16.28444831282783, 1.8696094234080451`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Clause\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                16.28444831282783, 1.8696094234080451`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.5, 1, 0.7], 
                 DiskBox[{15.307474307432933`, 4.792845448026054}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                15.307474307432933`, 4.792845448026054}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{12.758209224853987`, 5.412443216014099}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                12.758209224853987`, 5.412443216014099}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{12.361940351560355`, 5.37871224059316}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Clause\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                12.361940351560355`, 5.37871224059316}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.8, 0.6, 0.8], 
                 DiskBox[{11.9548004060364, 5.388641928921964}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                11.9548004060364, 5.388641928921964}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.1, 0.6, 0.7], 
                 DiskBox[{9.415851109378327, 5.744195713252398}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                9.415851109378327, 5.744195713252398}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0.1, 0.6, 0.7], 
                 DiskBox[{9.024313658013092, 5.597161970914246}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Clause\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                9.024313658013092, 5.597161970914246}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[1.8180339887498949`, 1., 0.8], 
                 DiskBox[{6.6463577822292805`, 6.704550862572129}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Punctuation\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                6.6463577822292805`, 6.704550862572129}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[1.8180339887498949`, 1., 0.8], 
                 DiskBox[{6.554183305773273, 6.404642854109894}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\",\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                6.554183305773273, 6.404642854109894}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[1.8180339887498949`, 1., 0.8], 
                 DiskBox[{6.666918884122225, 7.218784134425622}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Conjunction\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                6.666918884122225, 7.218784134425622}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[1.8180339887498949`, 1., 0.8], 
                 DiskBox[{6.665400105403663, 7.6879148689498304`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"and\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                6.665400105403663, 7.6879148689498304`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.946449452824945, 6.006929864628638}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Determiner\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.946449452824945, 6.006929864628638}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.763076846149433, 5.548385709756712}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"a\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.763076846149433, 5.548385709756712}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.8031220871358196`, 6.174797550752306}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.8031220871358196`, 6.174797550752306}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.5726117511431905`, 5.77490000536843}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"language\"", StripOnInput -> False, FontFamily -> "Arial",
                   FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.5726117511431905`, 5.77490000536843}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{4.003654888692572, 6.414693319708382}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                4.003654888692572, 6.414693319708382}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.6859459725347854`, 7.346665021623218}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.6859459725347854`, 7.346665021623218}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.582452408454305, 7.687290848372776}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"is\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.582452408454305, 7.687290848372776}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[3.43606797749979, 1., 0.8], 
                 DiskBox[{1.906496853045505, 10.033970742542014`}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Determiner\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                1.906496853045505, 10.033970742542014`}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[3.43606797749979, 1., 0.8], 
                 DiskBox[{1.7502618824121896`, 10.4643796848262}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"any\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                1.7502618824121896`, 10.4643796848262}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[3.43606797749979, 1., 0.8], 
                 DiskBox[{1.625039779060117, 9.832731905770173}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Adjective\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                1.625039779060117, 9.832731905770173}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[3.43606797749979, 1., 0.8], 
                 DiskBox[{1.3109721583386609`, 10.16692721986696}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"specific\"", StripOnInput -> False, FontFamily -> "Arial",
                   FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                1.3109721583386609`, 10.16692721986696}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[3.43606797749979, 1., 0.8], 
                 DiskBox[{1.4317150228292252`, 9.515916127371568}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                1.4317150228292252`, 9.515916127371568}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[3.43606797749979, 1., 0.8], 
                 DiskBox[{1.015931506441916, 9.650273298477263}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"example\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                1.015931506441916, 9.650273298477263}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[3.43606797749979, 1., 0.8], 
                 DiskBox[{1.8550364607142065`, 9.58574287141232}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                1.8550364607142065`, 9.58574287141232}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{2.6310395695789612`, 6.820752248659998}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Preposition\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                2.6310395695789612`, 6.820752248659998}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{2.324987936034262, 6.843992694679278}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"of\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                2.324987936034262, 6.843992694679278}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[5.054101966249685, 1., 0.8], 
                 DiskBox[{0.4308278698633199, 4.944429618010616}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Determiner\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                0.4308278698633199, 4.944429618010616}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[5.054101966249685, 1., 0.8], 
                 DiskBox[{0., 4.975370364866848}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"such\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                0., 4.975370364866848}, BaseStyle -> "Graphics"]}, {{{
                 Hue[5.054101966249685, 1., 0.8], 
                 DiskBox[{0.5267622892354211, 4.561514212431248}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Determiner\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                0.5267622892354211, 4.561514212431248}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[5.054101966249685, 1., 0.8], 
                 DiskBox[{0.14129396477411227`, 4.339178395464979}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"a\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                0.14129396477411227`, 4.339178395464979}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[5.054101966249685, 1., 0.8], 
                 DiskBox[{0.7476365371706954, 4.265918870303068}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                0.7476365371706954, 4.265918870303068}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[5.054101966249685, 1., 0.8], 
                 DiskBox[{0.5004378204848301, 3.885064106350737}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"system\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                0.5004378204848301, 3.885064106350737}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[5.054101966249685, 1., 0.8], 
                 DiskBox[{0.81578520000153, 4.727087978361737}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                0.81578520000153, 4.727087978361737}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{2.9263933420120036`, 6.856153618797502}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Prepositional Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                2.9263933420120036`, 6.856153618797502}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.2808119222694074`, 7.060646854909245}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Noun Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.2808119222694074`, 7.060646854909245}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{3.7108937635453643`, 7.012229366001545}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Verb Phrase\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                3.7108937635453643`, 7.012229366001545}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[0, 1, 0.8], 
                 DiskBox[{4.073463969730918, 6.781385467511763}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Clause\"", StripOnInput -> False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                4.073463969730918, 6.781385467511763}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[1.8180339887498949`, 1., 0.8], 
                 DiskBox[{6.798947221415067, 7.380305948482636}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Punctuation\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                6.798947221415067, 7.380305948482636}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[1.8180339887498949`, 1., 0.8], 
                 DiskBox[{6.80448672028889, 7.908111840157433}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\".\"", StripOnInput -> False, FontFamily -> "Arial", 
                  FontSize -> Medium], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                6.80448672028889, 7.908111840157433}, BaseStyle -> 
                "Graphics"]}, {{{
                 Hue[1.8180339887498949`, 1., 0.8], 
                 DiskBox[{6.727467095372599, 6.968676176923568}, 0.]}}, 
               InsetBox[
                FrameBox[
                 StyleBox[
                 "\"Sentence\"", StripOnInput -> 
                  False, $CellContext`LineColor -> 
                  GrayLevel[0.55], $CellContext`FrontFaceColor -> 
                  GrayLevel[0.55], $CellContext`GraphicsColor -> 
                  GrayLevel[0.55], FontColor -> 
                  GrayLevel[0.55], $CellContext`BackFaceColor -> 
                  GrayLevel[0.55]], Background -> Directive[
                   GrayLevel[1], 
                   Opacity[1]], FrameMargins -> {{0, 0}, {-1, -2}}, 
                 FrameStyle -> Directive[
                   GrayLevel[1], 
                   Opacity[0]], RoundingRadius -> 2, StripOnInput -> False], {
                6.727467095372599, 6.968676176923568}, BaseStyle -> 
                "Graphics"]}}}}}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], 
          ImageSize -> {Automatic, 304.2460797641411}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e2153273-1173-41c5-b367-69455950d133"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of numbers of nouns, verbs, adjectives and adverbs found by ",
 ButtonBox["WordList",
  BaseStyle->"Link"],
 " in English.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:27",ExpressionUUID->"5f02a1b9-aac6-4f98-8b74-792533f7ab30"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"25133", ",", "6671", ",", "11520", ",", "3199"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "e42702d8-8a3c-4734-95af-43cff2eae32a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"25133", ",", "6671", ",", "11520", ",", "3199"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"15f2bef7-0723-413b-b564-26bae1f9824a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a list of the translations of numbers 2 through 10 into French.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7fbdcf11-1fd2-4ef6-a3c6-d8078aea3e01"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"deux\"\>", ",", "\<\"trois\"\>", ",", "\<\"quatre\"\>", 
         ",", "\<\"cinq\"\>", ",", "\<\"six\"\>", ",", "\<\"sept\"\>", 
         ",", "\<\"huit\"\>", ",", "\<\"neuf\"\>", ",", "\<\"dix\"\>"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "6661abaf-8920-4403-81ef-a5944695af9c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"deux\"", ",", "\"trois\"", ",", "\"quatre\"", ",", 
             "\"cinq\"", ",", "\"six\"", ",", "\"sept\"", ",", "\"huit\"", 
             ",", "\"neuf\"", ",", "\"dix\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cda2e6d8-a3ed-49f8-ae95-5aae484f3891"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1256744f-abb3-40b9-9010-5eeba7669ee8"],

Cell["What possible types of interpreters are there?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a010f854-0fcd-4a37-9ef0-df7ddd8c988e"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s a long list. Check out the ",
 ButtonBox["documentation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InterpretingStrings"],
 ", or evaluate ",
 ButtonBox["$InterpreterTypes",
  BaseStyle->"Link"],
 " to see the list."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"262cabb0-0c42-4c03-a625-aafd9396d479"],

Cell[TextData[{
 "Does ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " need a network connection?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:29",ExpressionUUID->"53640b76-16d0-44db-b61e-9f2fb4aef6d3"],

Cell["\<\
In simple cases, such as dates or basic currency, no. But for full natural \
language input, yes. \
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"02825fe6-2c56-4997-b14c-5f2f2ffe273a"],

Cell["\<\
When I say \[OpenCurlyDoubleQuote]4 dollars\[CloseCurlyDoubleQuote], how does \
it know if I want US dollars or something else?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"99b18784-e6e6-4c49-9974-1e502991be70"],

Cell["\<\
It uses what it knows of your geo location to tell what kind of dollars you\
\[CloseCurlyQuote]re likely to mean.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:30",ExpressionUUID->"233f6512-9958-4679-9231-69e7351fc75e"],

Cell[TextData[{
 "Can ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " deal with arbitrary natural language?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b44cedb7-cd8a-4d37-8340-a3d504a17261"],

Cell[TextData[{
 "If something can be expressed in the Wolfram Language, then ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " should be able to interpret it. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interpreter",
    BaseStyle->"CodeLink"], "[", "\<\"SemanticExpression\"\>", "]"}]], 
  "InlineCode",ExpressionUUID->"e8f92397-d3c2-43da-8f69-8387b417ced9"],
 " takes any input, and tries to understand its meaning so as to get a \
Wolfram Language expression that captures it. What it\[CloseCurlyQuote]s \
doing is essentially the first stage of what Wolfram|Alpha does."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:31",ExpressionUUID->"3d682e68-21bc-4ada-899a-bc16b1191cce"],

Cell["Can I add my own interpreters?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:32",ExpressionUUID->"9f3757a3-dffd-42e3-9539-abc100ae27eb"],

Cell[TextData[{
 "Yes. ",
 ButtonBox["GrammarRules",
  BaseStyle->"Link"],
 " lets you build up your own grammar, making use of whatever existing \
interpreters you want. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bea6bbc3-5190-4190-8b4e-1c6424126b49"],

Cell["Can I find the meaning of a word?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:33",ExpressionUUID->"9b6c8806-24b7-46d3-b06e-1833f715836a"],

Cell[TextData[{
 ButtonBox["WordDefinition",
  BaseStyle->"Link"],
 " gives dictionary definitions."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fd53edfa-199c-4c2c-b9a0-b5638dcba305"],

Cell["Can I find what part of speech a word is?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4b4fd269-6ddd-4933-bcfd-d80d9cbcebc0"],

Cell[TextData[{
 ButtonBox["PartOfSpeech",
  BaseStyle->"Link"],
 " tells you ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the parts of speech a word can correspond to. So for \
\[OpenCurlyDoubleQuote]fish\[CloseCurlyDoubleQuote] it gives noun and verb. \
Which of these is correct in a given case depends on how the word is used in \
a sentence\[LongDash]and that\[CloseCurlyQuote]s what ",
 ButtonBox["TextStructure",
  BaseStyle->"Link"],
 " figures out. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9e4731b4-d4df-4a7e-8293-0f4bd900c9bb"],

Cell["Can I translate whole sentences as well as words?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bbd00a1b-690f-41a4-aeda-cc5ef850685a"],

Cell[TextData[{
 ButtonBox["TextTranslation",
  BaseStyle->"Link"],
 " does this for some languages, usually by calling an external service."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cdf53a8b-0bac-41af-9093-086a580a2b7d"],

Cell[TextData[{
 "What languages does ",
 ButtonBox["WordTranslation",
  BaseStyle->"Link"],
 " handle?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4d4fbab6-5ecf-4426-85eb-8cb75792fca7"],

Cell[TextData[{
 "It can translate lots of words for the few hundred most common languages. \
It can translate at least a few words for well over a thousand languages. ",
 ButtonBox["LanguageData",
  BaseStyle->"Link"],
 " gives information on over 10,000 languages."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"632214da-1afe-4f4c-bcd8-6b7a62bec866"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:215",ExpressionUUID->"e4375a5d-66b3-4961-b904-b21ac1c70356"],

Cell[TextData[{
 ButtonBox["TextStructure",
  BaseStyle->"Link"],
 " requires complete grammatical text, but ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " uses many different techniques to also work with fragments of text."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"783910f9-8635-40c9-8140-242487712be8"],

Cell[TextData[{
 "When you use ",
 Cell[TextData[Cell[BoxData[
  TemplateBox[{"ctrl", "="},
   "Key1"]],ExpressionUUID->"6ae1279f-04ab-4d3f-aa4c-3399be3f3bcf"]],
  ExpressionUUID->"583dbc0e-87f6-4125-9e91-dfb3fe1b8b12"],
 " you can resolve ambiguous input interactively. With ",
 ButtonBox["Interpreter",
  BaseStyle->"Link"],
 " you have to do it programmatically, using the option ",
 ButtonBox["AmbiguityFunction",
  BaseStyle->"Link"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:34",ExpressionUUID->"4281a0bc-517b-4602-a8c2-74743f26b0c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0f51e387-0e29-4867-a588-fe7ea37248e4"],

Cell[TextData[ButtonBox["Guide to Natural Language Interpreters in the \
Wolfram Language\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InterpretingStrings"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"e94cd0fb-7667-4e0a-87de-a128d1c925b5"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Natural Language Understanding: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Associations\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Associations", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-36-creating-websites-and-apps.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-36-creating-websites-and-apps.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Creating Websites and Apps\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Creating Websites and Apps", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->294,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Natural Language Understanding \[LongDash] wolfr.am/eiwl-", 
       "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"8fbad442-3fc6-416b-b90d-02bacfa88efb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:211"->{
  Cell[675, 24, 466, 11, 93, "SectionDoubleDigit",ExpressionUUID->"05e0cf2e-d74e-44c2-afe9-5e91963c3e81",
   CounterAssignments->{{"Section", 34}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->{"p:211", "i:1"}]},
 "i:1"->{
  Cell[675, 24, 466, 11, 93, "SectionDoubleDigit",ExpressionUUID->"05e0cf2e-d74e-44c2-afe9-5e91963c3e81",
   CounterAssignments->{{"Section", 34}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->{"p:211", "i:1"}]},
 "i:2"->{
  Cell[1144, 37, 637, 16, 66, "Text",ExpressionUUID->"92121714-4c8f-4e56-a1da-e712b24f858c",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[1784, 55, 418, 12, 65, "Text",ExpressionUUID->"ea11afb2-2ac4-48bf-8fef-c51c81855b11",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[2205, 69, 315, 10, 37, "CodeCaption",ExpressionUUID->"e9180630-6870-4270-b7d8-7441cd137b45",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[4292, 138, 321, 10, 37, "CodeCaption",ExpressionUUID->"23ba3be2-f4d6-4f7e-bc2d-5280f68d6e1d",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[6664, 210, 375, 11, 65, "Text",ExpressionUUID->"7ff17141-e275-4290-89ca-3a1858120a1b",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[8514, 269, 229, 6, 37, "CodeCaption",ExpressionUUID->"29959fb1-263c-4fa3-8f24-09e2689f8c38",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[10012, 318, 212, 4, 70, "Text",ExpressionUUID->"dda2eebf-41ed-443f-9d59-cc03e40c1fe5",
   CellTags->"i:8"]},
 "LastCellOfAPage"->{
  Cell[10830, 347, 322, 9, 70, "Output",ExpressionUUID->"45783cb2-0208-4ef0-81e1-0e3b7799bc79",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[176709, 3196, 302, 8, 70, "Output",ExpressionUUID->"f96312ad-0145-45b9-8de0-5e52f6d31476",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[254950, 5211, 715, 13, 70, "Output",ExpressionUUID->"561f3afd-f843-4987-acd1-dd3d1dcdb5a4",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[301038, 6534, 2137, 53, 70, "Output",ExpressionUUID->"1ea4e86c-d6e5-43b1-b4c1-6c6d0a3059f3",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[553308, 12388, 838, 22, 70, "Exercise",ExpressionUUID->"9d2f61c7-9fd6-4610-b149-229e2fe4250d",
   CellTags->"LastCellOfAPage"],
  Cell[762167, 16882, 363, 8, 70, "MoreExplore",ExpressionUUID->"e94cd0fb-7667-4e0a-87de-a128d1c925b5",
   CellTags->"LastCellOfAPage"]},
 "p:212"->{
  Cell[11167, 359, 211, 5, 70, "CodeCaption",ExpressionUUID->"cd5f6d09-a482-4aca-a0ed-b905d15990c4",
   CellTags->{"p:212", "i:9"}]},
 "i:9"->{
  Cell[11167, 359, 211, 5, 70, "CodeCaption",ExpressionUUID->"cd5f6d09-a482-4aca-a0ed-b905d15990c4",
   CellTags->{"p:212", "i:9"}]},
 "i:10"->{
  Cell[12223, 396, 297, 7, 70, "CodeCaption",ExpressionUUID->"a94eac7b-fad1-4659-8735-62e47d3ffac8",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[13961, 446, 188, 4, 70, "CodeCaption",ExpressionUUID->"9acc5de9-4910-47c6-8568-f2cde558ff56",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[15589, 493, 211, 4, 70, "CodeCaption",ExpressionUUID->"0c329e52-8ff1-4969-acad-22a39f64d16a",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[175138, 3141, 379, 12, 70, "Text",ExpressionUUID->"713182c5-c005-4da9-9430-b74d7dbee386",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[175520, 3155, 197, 4, 70, "CodeCaption",ExpressionUUID->"a9c10471-a5bb-4f1a-a282-07276d1d6464",
   CellTags->"i:14"]},
 "p:213"->{
  Cell[177026, 3207, 375, 11, 70, "Text",ExpressionUUID->"08f7c19c-92fc-4cc0-a57e-f12126ae9684",
   CellTags->{"p:213", "i:15"}]},
 "i:15"->{
  Cell[177026, 3207, 375, 11, 70, "Text",ExpressionUUID->"08f7c19c-92fc-4cc0-a57e-f12126ae9684",
   CellTags->{"p:213", "i:15"}]},
 "i:16"->{
  Cell[177656, 3230, 309, 8, 70, "Input",ExpressionUUID->"d1682103-8364-4f13-940c-e2566e8e7993",
   CellTags->"i:16"]},
 "i:17"->{
  Cell[203529, 3985, 268, 8, 70, "Text",ExpressionUUID->"db2e8590-936e-464a-8814-dce6bcefa4b5",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[221862, 4415, 201, 4, 70, "CodeCaption",ExpressionUUID->"c70c820f-6ba2-43c0-82e5-603f81a6de57",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[254479, 5195, 214, 4, 70, "CodeCaption",ExpressionUUID->"ec5836ec-9c80-4daf-b666-62d8c8d1048a",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[256002, 5237, 236, 6, 70, "CodeCaption",ExpressionUUID->"4e187e05-a4b1-49e7-914f-64e88536d117",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[297273, 6408, 384, 10, 70, "Text",ExpressionUUID->"07127d98-5242-4900-b59c-7f790acd44e6",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[298444, 6446, 181, 4, 70, "CodeCaption",ExpressionUUID->"391aa5d8-dbd1-4447-9cb2-e771dae4e3d1",
   CellTags->"i:22"]},
 "i:23"->{
  Cell[299172, 6470, 233, 6, 70, "CodeCaption",ExpressionUUID->"ef32fedb-14df-4b08-96a5-5d6545505800",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[299961, 6497, 511, 15, 70, "Text",ExpressionUUID->"def16427-e896-4455-90ca-eebee1e6c92b",
   CellTags->"i:24"]},
 "i:25"->{
  Cell[342884, 7638, 854, 24, 70, "Exercise",ExpressionUUID->"8aea450c-7c40-42cb-ab95-8c4af2bbbe81",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[354791, 7931, 803, 21, 70, "Exercise",ExpressionUUID->"979de9b3-9246-4ea1-b66d-f1f879c689c1",
   CellTags->"i:26"]},
 "i:27"->{
  Cell[750682, 16503, 816, 23, 70, "Exercise",ExpressionUUID->"5f02a1b9-aac6-4f98-8b74-792533f7ab30",
   CellTags->"i:27"]},
 "i:28"->{
  Cell[755497, 16651, 413, 13, 70, "Answer",ExpressionUUID->"262cabb0-0c42-4c03-a625-aafd9396d479",
   CellTags->"i:28"]},
 "i:29"->{
  Cell[755913, 16666, 256, 9, 70, "Question",ExpressionUUID->"53640b76-16d0-44db-b61e-9f2fb4aef6d3",
   CellTags->"i:29"]},
 "i:30"->{
  Cell[756697, 16695, 275, 7, 70, "Answer",ExpressionUUID->"233f6512-9958-4679-9231-69e7351fc75e",
   CellTags->"i:30"]},
 "i:31"->{
  Cell[757228, 16715, 728, 17, 70, "Answer",ExpressionUUID->"3d682e68-21bc-4ada-899a-bc16b1191cce",
   CellTags->"i:31"]},
 "i:32"->{
  Cell[757959, 16734, 186, 4, 70, "Question",ExpressionUUID->"9f3757a3-dffd-42e3-9539-abc100ae27eb",
   CellTags->"i:32"]},
 "i:33"->{
  Cell[758457, 16752, 189, 4, 70, "Question",ExpressionUUID->"9b6c8806-24b7-46d3-b06e-1833f715836a",
   CellTags->"i:33"]},
 "p:215"->{
  Cell[760819, 16835, 174, 4, 70, "TechNoteSection",ExpressionUUID->"e4375a5d-66b3-4961-b904-b21ac1c70356",
   CellTags->"p:215"]},
 "i:34"->{
  Cell[761366, 16854, 596, 17, 70, "TechNote",ExpressionUUID->"4281a0bc-517b-4602-a8c2-74743f26b0c0",
   CellTags->"i:34"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:211", 853312, 18734},
 {"i:1", 853561, 18738},
 {"i:2", 853810, 18742},
 {"i:3", 853935, 18745},
 {"i:4", 854060, 18748},
 {"i:5", 854192, 18751},
 {"i:6", 854325, 18754},
 {"i:7", 854451, 18757},
 {"i:8", 854583, 18760},
 {"LastCellOfAPage", 854721, 18763},
 {"p:212", 855623, 18780},
 {"i:9", 855767, 18783},
 {"i:10", 855912, 18786},
 {"i:11", 856047, 18789},
 {"i:12", 856182, 18792},
 {"i:13", 856317, 18795},
 {"i:14", 856448, 18798},
 {"p:213", 856586, 18801},
 {"i:15", 856728, 18804},
 {"i:16", 856870, 18807},
 {"i:17", 857001, 18810},
 {"i:18", 857131, 18813},
 {"i:19", 857268, 18816},
 {"i:20", 857405, 18819},
 {"i:21", 857542, 18822},
 {"i:22", 857673, 18825},
 {"i:23", 857810, 18828},
 {"i:24", 857947, 18831},
 {"i:25", 858078, 18834},
 {"i:26", 858213, 18837},
 {"i:27", 858348, 18840},
 {"i:28", 858484, 18843},
 {"i:29", 858618, 18846},
 {"i:30", 858753, 18849},
 {"i:31", 858886, 18852},
 {"i:32", 859020, 18855},
 {"i:33", 859155, 18858},
 {"p:215", 859291, 18861},
 {"i:34", 859434, 18864}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[675, 24, 466, 11, 93, "SectionDoubleDigit",ExpressionUUID->"05e0cf2e-d74e-44c2-afe9-5e91963c3e81",
 CounterAssignments->{{"Section", 34}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->{"p:211", "i:1"}],
Cell[1144, 37, 637, 16, 66, "Text",ExpressionUUID->"92121714-4c8f-4e56-a1da-e712b24f858c",
 CellTags->"i:2"],
Cell[1784, 55, 418, 12, 65, "Text",ExpressionUUID->"ea11afb2-2ac4-48bf-8fef-c51c81855b11",
 CellTags->"i:3"],
Cell[2205, 69, 315, 10, 37, "CodeCaption",ExpressionUUID->"e9180630-6870-4270-b7d8-7441cd137b45",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[2545, 83, 213, 5, 29, "Input",ExpressionUUID->"8162a0de-3691-4a35-804c-5810c3da0dd5"],
Cell[2761, 90, 506, 13, 49, "Output",ExpressionUUID->"6caaf024-26f3-43eb-98b3-1b47c254a44e",
 Evaluatable->False]
}, Open  ]],
Cell[3282, 106, 238, 5, 37, "CodeCaption",ExpressionUUID->"ea3b6b62-3aac-438e-b18a-87e82d3ae0ee"],
Cell[CellGroupData[{
Cell[3545, 115, 223, 5, 29, "Input",ExpressionUUID->"454e6d4a-ac64-4068-8201-2a53164affc1"],
Cell[3771, 122, 506, 13, 49, "Output",ExpressionUUID->"fcc7e819-082d-434d-9ac6-63f98530fe9f",
 Evaluatable->False]
}, Open  ]],
Cell[4292, 138, 321, 10, 37, "CodeCaption",ExpressionUUID->"23ba3be2-f4d6-4f7e-bc2d-5280f68d6e1d",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[4638, 152, 219, 5, 29, "Input",ExpressionUUID->"b17ea8de-94aa-438d-87be-3c3a24290a81"],
Cell[4860, 159, 1789, 48, 40, "Output",ExpressionUUID->"b220b67c-fec8-4e1c-89da-5cf20bd346a7",
 Evaluatable->False]
}, Open  ]],
Cell[6664, 210, 375, 11, 65, "Text",ExpressionUUID->"7ff17141-e275-4290-89ca-3a1858120a1b",
 CellTags->"i:6"],
Cell[7042, 223, 178, 4, 37, "CodeCaption",ExpressionUUID->"e077ed3b-6344-4daf-9449-8b14f71b8460"],
Cell[CellGroupData[{
Cell[7245, 231, 358, 8, 54, "Input",ExpressionUUID->"19583cbf-be59-4715-9b7d-4bfc45604bdf"],
Cell[7606, 241, 893, 25, 44, "Output",ExpressionUUID->"f2b5410b-3853-42d4-a098-1de1cef41ae9",
 Evaluatable->False]
}, Open  ]],
Cell[8514, 269, 229, 6, 37, "CodeCaption",ExpressionUUID->"29959fb1-263c-4fa3-8f24-09e2689f8c38",
 CellTags->"i:7"],
Cell[CellGroupData[{
Cell[8768, 279, 902, 25, 33, "Input",ExpressionUUID->"680fb280-9abc-4b1a-850a-d8cdda6fdea8"],
Cell[9673, 306, 324, 9, 70, "Output",ExpressionUUID->"ac002980-b7f2-40b6-ba92-60c79785afa8",
 Evaluatable->False]
}, Open  ]],
Cell[10012, 318, 212, 4, 70, "Text",ExpressionUUID->"dda2eebf-41ed-443f-9d59-cc03e40c1fe5",
 CellTags->"i:8"],
Cell[10227, 324, 350, 12, 70, "CodeCaption",ExpressionUUID->"7c3fff92-335f-4eaa-80b3-90489297e4ea"],
Cell[CellGroupData[{
Cell[10602, 340, 225, 5, 70, "Input",ExpressionUUID->"9e3598b4-b50c-43a8-a469-9068f3a0be2e"],
Cell[10830, 347, 322, 9, 70, "Output",ExpressionUUID->"45783cb2-0208-4ef0-81e1-0e3b7799bc79",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[11167, 359, 211, 5, 70, "CodeCaption",ExpressionUUID->"cd5f6d09-a482-4aca-a0ed-b905d15990c4",
 CellTags->{"p:212", "i:9"}],
Cell[CellGroupData[{
Cell[11403, 368, 254, 5, 70, "Input",ExpressionUUID->"5a5a600a-af35-4a85-914b-5e4b21338447"],
Cell[11660, 375, 292, 8, 70, "Output",ExpressionUUID->"451a0293-e1ee-4761-bb8d-808a3f64f124",
 Evaluatable->False]
}, Open  ]],
Cell[11967, 386, 253, 8, 70, "Text",ExpressionUUID->"b0ad3666-debe-490b-a3d4-56f030ff0fe3"],
Cell[12223, 396, 297, 7, 70, "CodeCaption",ExpressionUUID->"a94eac7b-fad1-4659-8735-62e47d3ffac8",
 CellTags->"i:10"],
Cell[CellGroupData[{
Cell[12545, 407, 312, 8, 70, "Input",ExpressionUUID->"318c5360-2996-4d22-ab36-f9515024bfe7"],
Cell[12860, 417, 1086, 26, 70, "Output",ExpressionUUID->"6cabf4b6-d68c-4455-ab11-3107c885a175",
 Evaluatable->False]
}, Open  ]],
Cell[13961, 446, 188, 4, 70, "CodeCaption",ExpressionUUID->"9acc5de9-4910-47c6-8568-f2cde558ff56",
 CellTags->"i:11"],
Cell[CellGroupData[{
Cell[14174, 454, 328, 8, 70, "Input",ExpressionUUID->"1fa679c9-8fce-4385-b00e-9c0f514e1a79"],
Cell[14505, 464, 1069, 26, 70, "Output",ExpressionUUID->"95a05972-405a-4f4d-8267-b1145df39f2d",
 Evaluatable->False]
}, Open  ]],
Cell[15589, 493, 211, 4, 70, "CodeCaption",ExpressionUUID->"0c329e52-8ff1-4969-acad-22a39f64d16a",
 CellTags->"i:12"],
Cell[15803, 499, 393, 10, 70, "Input",ExpressionUUID->"24dee1c6-63f5-44d2-854e-7bd5b5cab093"],
Cell[16199, 511, 158936, 2628, 70, "Input",ExpressionUUID->"b6b702a4-4c3f-45db-a32d-3b3c485d591b"],
Cell[175138, 3141, 379, 12, 70, "Text",ExpressionUUID->"713182c5-c005-4da9-9430-b74d7dbee386",
 CellTags->"i:13"],
Cell[175520, 3155, 197, 4, 70, "CodeCaption",ExpressionUUID->"a9c10471-a5bb-4f1a-a282-07276d1d6464",
 CellTags->"i:14"],
Cell[CellGroupData[{
Cell[175742, 3163, 243, 6, 70, "Input",ExpressionUUID->"99786ce4-c8f2-4a6d-8cfc-70256782047d"],
Cell[175988, 3171, 249, 6, 70, "Output",ExpressionUUID->"e8458607-90ea-4b39-bf98-c17f4abbe05a",
 Evaluatable->False]
}, Open  ]],
Cell[176252, 3180, 169, 4, 70, "CodeCaption",ExpressionUUID->"a1205144-6e99-4f2e-8e0a-ab628f8369ad"],
Cell[CellGroupData[{
Cell[176446, 3188, 260, 6, 70, "Input",ExpressionUUID->"6bc1a60f-c85f-4c68-89ba-65f023f0b40d"],
Cell[176709, 3196, 302, 8, 70, "Output",ExpressionUUID->"f96312ad-0145-45b9-8de0-5e52f6d31476",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[177026, 3207, 375, 11, 70, "Text",ExpressionUUID->"08f7c19c-92fc-4cc0-a57e-f12126ae9684",
 CellTags->{"p:213", "i:15"}],
Cell[177404, 3220, 227, 6, 70, "CodeCaption",ExpressionUUID->"c48a2c98-8e22-4231-a3cd-f7956e37ecdd"],
Cell[CellGroupData[{
Cell[177656, 3230, 309, 8, 70, "Input",ExpressionUUID->"d1682103-8364-4f13-940c-e2566e8e7993",
 CellTags->"i:16"],
Cell[177968, 3240, 25546, 742, 70, "Output",ExpressionUUID->"5233a43f-3e7c-4996-9d39-eba49fa5b4f7",
 Evaluatable->False]
}, Open  ]],
Cell[203529, 3985, 268, 8, 70, "Text",ExpressionUUID->"db2e8590-936e-464a-8814-dce6bcefa4b5",
 CellTags->"i:17"],
Cell[203800, 3995, 219, 6, 70, "CodeCaption",ExpressionUUID->"d961d9c4-026d-438a-b6fd-b5ed76c93a07"],
Cell[CellGroupData[{
Cell[204044, 4005, 219, 4, 70, "Input",ExpressionUUID->"b8fbb8f6-7d4f-4b25-a9ca-8556620a508f"],
Cell[204266, 4011, 17581, 401, 70, "Output",ExpressionUUID->"0b3b9fdf-57ef-4f62-8618-60edb84486ea",
 Evaluatable->False]
}, Open  ]],
Cell[221862, 4415, 201, 4, 70, "CodeCaption",ExpressionUUID->"c70c820f-6ba2-43c0-82e5-603f81a6de57",
 CellTags->"i:18"],
Cell[CellGroupData[{
Cell[222088, 4423, 270, 6, 70, "Input",ExpressionUUID->"9b5d2ba0-4990-4c53-a04a-e03c7d7dbd93"],
Cell[222361, 4431, 31477, 742, 70, "Output",ExpressionUUID->"02fc6c6c-0557-422f-837b-0a8366c7183a",
 Evaluatable->False]
}, Open  ]],
Cell[253853, 5176, 623, 17, 70, "Text",ExpressionUUID->"9ccd7d68-79fd-4163-bf52-2578118d052e"],
Cell[254479, 5195, 214, 4, 70, "CodeCaption",ExpressionUUID->"ec5836ec-9c80-4daf-b666-62d8c8d1048a",
 CellTags->"i:19"],
Cell[CellGroupData[{
Cell[254718, 5203, 229, 6, 70, "Input",ExpressionUUID->"aa418404-74ef-41f1-b864-53e5275ad352"],
Cell[254950, 5211, 715, 13, 70, "Output",ExpressionUUID->"561f3afd-f843-4987-acd1-dd3d1dcdb5a4",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[255680, 5227, 319, 8, 70, "Text",ExpressionUUID->"94468068-e159-4b6d-806c-00a08a38e2e9"],
Cell[256002, 5237, 236, 6, 70, "CodeCaption",ExpressionUUID->"4e187e05-a4b1-49e7-914f-64e88536d117",
 CellTags->"i:20"],
Cell[CellGroupData[{
Cell[256263, 5247, 381, 10, 70, "Input",ExpressionUUID->"f5214a52-857e-409b-bb45-5a5d5dfbcf56"],
Cell[256647, 5259, 40611, 1146, 70, "Output",ExpressionUUID->"fcda8026-fa4e-4c2a-ad22-63b5ae98aca2",
 Evaluatable->False]
}, Open  ]],
Cell[297273, 6408, 384, 10, 70, "Text",ExpressionUUID->"07127d98-5242-4900-b59c-7f790acd44e6",
 CellTags->"i:21"],
Cell[297660, 6420, 220, 5, 70, "CodeCaption",ExpressionUUID->"49d98e90-cfd2-4cfa-9e8f-2c2f8497fe59"],
Cell[CellGroupData[{
Cell[297905, 6429, 214, 4, 70, "Input",ExpressionUUID->"16c57e31-9d87-4643-b268-7267a2d48562"],
Cell[298122, 6435, 307, 8, 70, "Output",ExpressionUUID->"daa9ff02-51ee-4782-8857-1d3d53fb321d",
 Evaluatable->False]
}, Open  ]],
Cell[298444, 6446, 181, 4, 70, "CodeCaption",ExpressionUUID->"391aa5d8-dbd1-4447-9cb2-e771dae4e3d1",
 CellTags->"i:22"],
Cell[CellGroupData[{
Cell[298650, 6454, 214, 4, 70, "Input",ExpressionUUID->"5db29c0c-1bec-4e14-bc1e-80076185fe0a"],
Cell[298867, 6460, 290, 7, 70, "Output",ExpressionUUID->"a6cbb3ca-916e-4228-b2d5-8bec29ae003b",
 Evaluatable->False]
}, Open  ]],
Cell[299172, 6470, 233, 6, 70, "CodeCaption",ExpressionUUID->"ef32fedb-14df-4b08-96a5-5d6545505800",
 CellTags->"i:23"],
Cell[CellGroupData[{
Cell[299430, 6480, 255, 5, 70, "Input",ExpressionUUID->"0c004b5a-f3e4-46bd-b65e-991e81d7b603"],
Cell[299688, 6487, 258, 7, 70, "Output",ExpressionUUID->"f5ebd3e7-1552-45e5-875e-05464dd6c734",
 Evaluatable->False]
}, Open  ]],
Cell[299961, 6497, 511, 15, 70, "Text",ExpressionUUID->"def16427-e896-4455-90ca-eebee1e6c92b",
 CellTags->"i:24"],
Cell[300475, 6514, 273, 7, 70, "CodeCaption",ExpressionUUID->"6d1fabf6-3479-4aab-9281-7fb7738de448"],
Cell[CellGroupData[{
Cell[300773, 6525, 262, 7, 70, "Input",ExpressionUUID->"0f6ece98-efe6-4b48-82d2-1815bdd195c1"],
Cell[301038, 6534, 2137, 53, 70, "Output",ExpressionUUID->"1ea4e86c-d6e5-43b1-b4c1-6c6d0a3059f3",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[303190, 6590, 559, 11, 70, "Text",ExpressionUUID->"f2f3270b-4d05-4545-a3cc-560e646efa71"],
Cell[303752, 6603, 291, 7, 70, "CodeCaption",ExpressionUUID->"f6f81192-2dc5-4a33-bcdb-ee4a7f5ebd59"],
Cell[CellGroupData[{
Cell[304068, 6614, 495, 14, 70, "Input",ExpressionUUID->"75c19ea3-88bb-49a2-9c73-27021b72461f"],
Cell[304566, 6630, 11597, 277, 70, "Output",ExpressionUUID->"cd496d27-c5cd-4aa8-9c12-8c136bd018fa",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[316212, 6913, 159, 4, 70, "VocabularySection",ExpressionUUID->"ca69c223-6f49-4210-a3ff-f9c04826fb35"],
Cell[316374, 6919, 1875, 50, 70, "VocabularyTable",ExpressionUUID->"a3e0c043-bbda-4d33-9a66-39dcc81e3d8b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[318286, 6974, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"11ee5c3e-4f81-42dc-9e4e-5b5eb8f7ca79"],
Cell[CellGroupData[{
Cell[320091, 7024, 1295, 41, 70, "ExerciseSummaryCell",ExpressionUUID->"8428c153-7706-47bc-a176-7a310a0c7a3b"],
Cell[CellGroupData[{
Cell[321411, 7069, 764, 23, 70, "Exercise",ExpressionUUID->"da751798-3c0e-4fa2-9445-9d7df657e3c8"],
Cell[322178, 7094, 1366, 38, 70, "ExerciseOutput",ExpressionUUID->"9575ca0c-4d2d-4bf5-a716-72f7d2de1a05"]
}, Closed]],
Cell[CellGroupData[{
Cell[323581, 7137, 815, 24, 70, "Exercise",ExpressionUUID->"85d2ef16-1e4d-41cb-9d02-e91c60fb45f1"],
Cell[324399, 7163, 1711, 46, 70, "ExerciseOutput",ExpressionUUID->"1d909845-744c-4932-b123-04368f7f2cb2"]
}, Closed]],
Cell[CellGroupData[{
Cell[326147, 7214, 780, 23, 70, "Exercise",ExpressionUUID->"9da1056d-3cee-4f7e-9a96-89f72abea2ba"],
Cell[326930, 7239, 2676, 65, 70, "ExerciseOutput",ExpressionUUID->"6272a505-34fb-4df1-a391-c912a258d005"]
}, Closed]],
Cell[CellGroupData[{
Cell[329643, 7309, 803, 24, 70, "Exercise",ExpressionUUID->"47b1cc24-d630-4890-8dbf-ab9aa998d6dc"],
Cell[330449, 7335, 1544, 44, 70, "ExerciseOutput",ExpressionUUID->"56ba9edd-eb5f-4a0c-a189-90e14e58c223"]
}, Closed]],
Cell[CellGroupData[{
Cell[332030, 7384, 805, 21, 70, "Exercise",ExpressionUUID->"71e23612-eb9e-4d13-9120-71fde292d28a"],
Cell[332838, 7407, 10009, 226, 70, "ExerciseOutput",ExpressionUUID->"d09ab516-2ad3-46ab-a882-38fc953d841e"]
}, Closed]],
Cell[CellGroupData[{
Cell[342884, 7638, 854, 24, 70, "Exercise",ExpressionUUID->"8aea450c-7c40-42cb-ab95-8c4af2bbbe81",
 CellTags->"i:25"],
Cell[343741, 7664, 5979, 129, 70, "ExerciseOutput",ExpressionUUID->"0a971eaa-5651-4174-9ce2-52a614ea24ee"]
}, Closed]],
Cell[CellGroupData[{
Cell[349757, 7798, 748, 21, 70, "Exercise",ExpressionUUID->"7e69f592-567e-4193-a3f5-ded17534946a"],
Cell[350508, 7821, 4246, 105, 70, "ExerciseOutput",ExpressionUUID->"854ca864-a528-4ddb-b067-a6eaaec71ff2"]
}, Closed]],
Cell[CellGroupData[{
Cell[354791, 7931, 803, 21, 70, "Exercise",ExpressionUUID->"979de9b3-9246-4ea1-b66d-f1f879c689c1",
 CellTags->"i:26"],
Cell[355597, 7954, 31056, 713, 70, "ExerciseOutput",ExpressionUUID->"0717fca2-befc-4376-a825-b759f19d8321"]
}, Closed]],
Cell[CellGroupData[{
Cell[386690, 8672, 769, 21, 70, "Exercise",ExpressionUUID->"950ac7e3-c56c-42c9-87b5-9c1970b383f1"],
Cell[387462, 8695, 1283, 36, 70, "ExerciseOutput",ExpressionUUID->"d8dba553-6da8-4780-8bf0-5bf9ae4e3463"]
}, Closed]],
Cell[CellGroupData[{
Cell[388782, 8736, 841, 24, 70, "Exercise",ExpressionUUID->"97fd5cf2-6f5e-4b26-a215-ae0f44c2f6c0"],
Cell[389626, 8762, 1212, 35, 70, "ExerciseOutput",ExpressionUUID->"94ec8033-bfd1-4f6c-8f98-c46eadb4cb70"]
}, Closed]],
Cell[CellGroupData[{
Cell[390875, 8802, 762, 21, 70, "Exercise",ExpressionUUID->"2af9c1fe-9e09-492d-8797-7637ab822a91"],
Cell[391640, 8825, 159017, 3482, 70, "ExerciseOutput",ExpressionUUID->"5d1409e4-4beb-4774-a05e-db6037cc5d34"]
}, Closed]],
Cell[CellGroupData[{
Cell[550694, 12312, 962, 28, 70, "Exercise",ExpressionUUID->"de6ac8a0-450d-4772-9187-e1c43fdfb9f2"],
Cell[551659, 12342, 1612, 41, 70, "ExerciseOutput",ExpressionUUID->"1c9f954b-20c9-41f2-965b-bb4ee1e4e32b"]
}, Closed]],
Cell[CellGroupData[{
Cell[553308, 12388, 838, 22, 70, "Exercise",ExpressionUUID->"9d2f61c7-9fd6-4610-b149-229e2fe4250d",
 CellTags->"LastCellOfAPage"],
Cell[554149, 12412, 196496, 4086, 70, "ExerciseOutput",ExpressionUUID->"e2153273-1173-41c5-b367-69455950d133"]
}, Closed]],
Cell[CellGroupData[{
Cell[750682, 16503, 816, 23, 70, "Exercise",ExpressionUUID->"5f02a1b9-aac6-4f98-8b74-792533f7ab30",
 CellTags->"i:27"],
Cell[751501, 16528, 1262, 36, 70, "ExerciseOutput",ExpressionUUID->"15f2bef7-0723-413b-b564-26bae1f9824a"]
}, Closed]],
Cell[CellGroupData[{
Cell[752800, 16569, 738, 20, 70, "Exercise",ExpressionUUID->"7fbdcf11-1fd2-4ef6-a3c6-d8078aea3e01"],
Cell[753541, 16591, 1559, 41, 70, "ExerciseOutput",ExpressionUUID->"cda2e6d8-a3ed-49f8-ae95-5aae484f3891"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[755161, 16639, 144, 4, 70, "QASection",ExpressionUUID->"1256744f-abb3-40b9-9010-5eeba7669ee8"],
Cell[755308, 16645, 186, 4, 70, "Question",ExpressionUUID->"a010f854-0fcd-4a37-9ef0-df7ddd8c988e"],
Cell[755497, 16651, 413, 13, 70, "Answer",ExpressionUUID->"262cabb0-0c42-4c03-a625-aafd9396d479",
 CellTags->"i:28"],
Cell[755913, 16666, 256, 9, 70, "Question",ExpressionUUID->"53640b76-16d0-44db-b61e-9f2fb4aef6d3",
 CellTags->"i:29"],
Cell[756172, 16677, 244, 7, 70, "Answer",ExpressionUUID->"02825fe6-2c56-4997-b14c-5f2f2ffe273a"],
Cell[756419, 16686, 275, 7, 70, "Question",ExpressionUUID->"99b18784-e6e6-4c49-9974-1e502991be70"],
Cell[756697, 16695, 275, 7, 70, "Answer",ExpressionUUID->"233f6512-9958-4679-9231-69e7351fc75e",
 CellTags->"i:30"],
Cell[756975, 16704, 250, 9, 70, "Question",ExpressionUUID->"b44cedb7-cd8a-4d37-8340-a3d504a17261"],
Cell[757228, 16715, 728, 17, 70, "Answer",ExpressionUUID->"3d682e68-21bc-4ada-899a-bc16b1191cce",
 CellTags->"i:31"],
Cell[757959, 16734, 186, 4, 70, "Question",ExpressionUUID->"9f3757a3-dffd-42e3-9539-abc100ae27eb",
 CellTags->"i:32"],
Cell[758148, 16740, 306, 10, 70, "Answer",ExpressionUUID->"bea6bbc3-5190-4190-8b4e-1c6424126b49"],
Cell[758457, 16752, 189, 4, 70, "Question",ExpressionUUID->"9b6c8806-24b7-46d3-b06e-1833f715836a",
 CellTags->"i:33"],
Cell[758649, 16758, 234, 8, 70, "Answer",ExpressionUUID->"fd53edfa-199c-4c2c-b9a0-b5638dcba305"],
Cell[758886, 16768, 181, 4, 70, "Question",ExpressionUUID->"4b4fd269-6ddd-4933-bcfd-d80d9cbcebc0"],
Cell[759070, 16774, 595, 17, 70, "Answer",ExpressionUUID->"9e4731b4-d4df-4a7e-8293-0f4bd900c9bb"],
Cell[759668, 16793, 189, 4, 70, "Question",ExpressionUUID->"bbd00a1b-690f-41a4-aeda-cc5ef850685a"],
Cell[759860, 16799, 275, 8, 70, "Answer",ExpressionUUID->"cdf53a8b-0bac-41af-9093-086a580a2b7d"],
Cell[760138, 16809, 240, 9, 70, "Question",ExpressionUUID->"4d4fbab6-5ecf-4426-85eb-8cb75792fca7"],
Cell[760381, 16820, 401, 10, 70, "Answer",ExpressionUUID->"632214da-1afe-4f4c-bcd8-6b7a62bec866"]
}, Open  ]],
Cell[CellGroupData[{
Cell[760819, 16835, 174, 4, 70, "TechNoteSection",ExpressionUUID->"e4375a5d-66b3-4961-b904-b21ac1c70356",
 CellTags->"p:215"],
Cell[760996, 16841, 367, 11, 70, "TechNote",ExpressionUUID->"783910f9-8635-40c9-8140-242487712be8"],
Cell[761366, 16854, 596, 17, 70, "TechNote",ExpressionUUID->"4281a0bc-517b-4602-a8c2-74743f26b0c0",
 CellTags->"i:34"]
}, Open  ]],
Cell[CellGroupData[{
Cell[761999, 16876, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"0f51e387-0e29-4867-a588-fe7ea37248e4"],
Cell[762167, 16882, 363, 8, 70, "MoreExplore",ExpressionUUID->"e94cd0fb-7667-4e0a-87de-a128d1c925b5",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature nINB6EonuSaF5JkxSvZVkcst *)
