(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    528780,      10319]
NotebookOptionsPosition[    455575,       8777]
NotebookOutlinePosition[    515584,      10009]
CellTagsIndexPosition[    515505,      10004]
WindowTitle->Natural Language Understanding: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Use ",
 StyleBox["Interpreter",
  FontFamily->"Source Sans Pro"],
 " to find the location of the Eiffel Tower."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"9622303f-8330-4e25-8c28-975410b431a9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a7b9e736-475e-42ca-81e8-53aaf8e9ab41"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWCuv5cgRPkpIYKT9BfkDxqGGITnSRmEmu8p4FTJrza4UmZq1gsyaRAaR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            "], {{0, 19}, {184, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{184, 19},
          PlotRange->{{0, 184}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{188, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ecf6f381-8964-49d4-bd15-27cd0de497e1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWCuv5cgRPkpIYKT9BfkDxqGGITnSRmEmu8p4FTJrza4UmZq1gsyaRAaR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              "], {{0, 19}, {184, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {184, 19}, 
            PlotRange -> {{0, 184}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"14fa5279-2390-4662-aafb-875e2826289c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"18cdd2b1-7eb7-4b68-a1d3-f69bb422fe58"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a8aefb27-8a9d-4f2e-b332-033dbfd5ed14"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ae30125d-896f-490d-be14-bc1d47d2a618"],

Cell[TextData[{
 "Use ",
 StyleBox["Interpreter",
  FontFamily->"Source Sans Pro"],
 " to find a university referred to as \[OpenCurlyDoubleQuote]U of T\
\[CloseCurlyDoubleQuote]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"de777ff1-431a-4fb3-ab48-0317830a3ac8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38d1fdfa-567c-45b9-88dd-b25be156fb3f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWs9rIlccT9tLj7Y9trT0D8jRbU9CDx5KbpaGXkR2qa57cGuyDZ0exGwF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            "], {{0, 27}, {
            145, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{145, 27},
          PlotRange->{{0, 145}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{149, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "117098c8-fc72-43be-935a-a50e7f7f4cfd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWs9rIlccT9tLj7Y9trT0D8jRbU9CDx5KbpaGXkR2qa57cGuyDZ0exGwF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              "], {{0, 27}, {
              145, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {145, 27}, 
            PlotRange -> {{0, 145}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"23c93b0f-60bb-4020-9d57-579da4adbcd0"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"043e210c-f63e-4ed4-a1e3-a162e7683d56"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"91a3d4df-685b-4967-b9ce-f8b67b53722a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"cc8e43b8-caa7-4661-85c0-6f415630c828"],

Cell[TextData[{
 "Use ",
 StyleBox["Interpreter",
  FontFamily->"Source Sans Pro"],
 " to find the chemicals referred to as C2H4, C2H6 and C3H8."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"0be02300-cc4a-440b-9e72-5e7f0ee120f8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a4535851-947c-474a-9b3f-dc1677d4b3c7"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW99PKtkdp7svfbTdxzZt+gfom7v7ZOKDDw0Pm9CU9GEJ2U1h2Qdv4d6S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            "], {{0, 27}, {221, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{221, 27},
          PlotRange->{{0, 221}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{225, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2921cea7-d7d8-4d64-90de-b4a8eeb2fddc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW99PKtkdp7svfbTdxzZt+gfom7v7ZOKDDw0Pm9CU9GEJ2U1h2Qdv4d6S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              "], {{0, 27}, {221, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {221, 27}, 
            PlotRange -> {{0, 221}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aec62459-928f-4b98-bcfd-bdddf42e00e5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a9a43ee8-35a3-4612-be2a-be87c7bc79a3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0feb144a-32ec-44f8-9ea5-8d1d2bf57cfa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7239b105-0e57-49fc-932f-0c842f61835a"],

Cell[TextData[{
 "Use ",
 StyleBox["Interpreter",
  FontFamily->"Source Sans Pro"],
 " to interpret the date \[OpenCurlyDoubleQuote]20140108\
\[CloseCurlyDoubleQuote]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"a6872f08-2858-4ce8-928b-46d56c1cbed9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5ac1b648-aa12-43ce-9df1-abc08b9609ac"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmt9vWlUcwBd98dFn3/wvfJU3t8TqzBJ4Muw6TRsyA2scVQyNy0isMkF0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            "], {{0, 26}, {116, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{116, 26},
          PlotRange->{{0, 116}, {0, 26}}]], "ExerciseOutput",
         ImageSize->{120, 26},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "468ee3d6-8b95-45a5-a8dd-21499ebab35e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmt9vWlUcwBd98dFn3/wvfJU3t8TqzBJ4Muw6TRsyA2scVQyNy0isMkF0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              "], {{0, 26}, {116, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {116, 26}, 
            PlotRange -> {{0, 116}, {0, 26}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"729c8311-654e-49c9-b2c0-97d8e05b26f3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"265a422e-26b9-435e-820f-2577756b3af6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"914bba4e-9058-42a0-9d4b-f46025f2a2cd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6694ff25-d649-449f-be36-dc75a4d505be"],

Cell["\<\
Find universities that can be referred to as \[OpenCurlyDoubleQuote]U of X\
\[CloseCurlyDoubleQuote], where x is any letter of the alphabet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"f6a5be14-b983-4f0e-a7e9-59359dbb22b9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"63030ad0-9e74-4f4c-ba25-a51304c2802c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvc9vIln2L+j+zmaW7untaFrzBzh3rp4VUi1YjFh8JUZjTUuF0Hsa8+gF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            "], {{0, 187}, {
            450, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{450, 187},
          PlotRange->{{0, 450}, {0, 187}}]], "ExerciseOutput",
         ImageSize->{454, 187},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "56e7008a-0e05-4c2b-b4b5-e8561b3b9def"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvc9vIln2L+j+zmaW7untaFrzBzh3rp4VUi1YjFh8JUZjTUuF0Hsa8+gF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              "], {{0, 
              187}, {450, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {450, 187}, 
            PlotRange -> {{0, 450}, {0, 187}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bf69ad15-abd8-4429-aa9b-ca20a5785928"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f3b2d2a5-38d4-4500-a967-267e3c7c4f1e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f4f5d808-21df-43b0-bb7b-25097955953c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ca5ee7b7-be9f-4244-b3fb-76f153ea5d5e"],

Cell[TextData[{
 "Find which US state capital names can be interpreted as movie titles (use \
",
 StyleBox["CommonName",
  FontFamily->"Source Sans Pro"],
 " to get the string versions of entity names)."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"4557a249-f97b-4c4c-a362-a843a7fc3dd7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"774808db-9d5c-4f59-9ec3-9bdf9cfebc60"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXd9rYlmed2Zf9jGz87rssH9A6i09CwuBesjDkocGl5UdaAkzbJzMg71J
94a99SDaJRhK0LEISoU4aRJSiJQJawKaJlwIbpDKOMGkHLGNpRaKZjSroCuW
W2W3e37d6/V6r7+i9SN1vpwu0tfrPefz/fE53/M9R/373/y7UvNThULx9V+D
f5S//s/7X3316wf/PAX+51++/Pp3v/1y8d/+6cv/WPzt4lf/8Ju/Ahf/EfyX
/4lCAf9uUaFChQoVKlSoUKFCZTLyOnf+9MmjBw8ev3z9vodChQoVKlR6SPX5
5wok95dfCBn7xx9a333Vsv1d6+FPW98oPugGRgjG+cf11tvGQJA/TGh3AwWF
OS7gVKhISTHwEJC1/1Vneg2cyvxz6GZ/ed76v2Lrzc0H3cAIwTidn7XMfwMD
vLd8sNDuBgoKcyzAqVCRkfPH9xX3nlRFV7/7urX3r+/fyYdtILSf/74P4A8f
2t1AQWHeBjgVKjLy4okUY4PlG8gHOjztOhXcP2X3z/gWYEtV8tIVu3t2EZuM
h1+nAu7z6GAPB2P+/d/2ASwBLRH1uy/jCdHTKvGj00CwOSYUmXeAgnVfRjtQ
NIvBU/9hqT42W/RD8Q5gcq0aOfe7z0LhMUEbtdVj5/79TPF6CEcdBDgVKjIi
zdgPf9q1CE275qYWZ0Rt/ixzDV8Cf1uPJhMUiR3wcMPhQDeDMYOR95ZuaOWj
1Zkpbdf4L9cAQKYyHhTDqGh8KGoh/eLM9GV5XLboi2LyMLmW2VtAHriQGtt8
NFIrH2lnpnaCiSEcdRDgVKjIiDRjg4VbVzB6lIAQDhv1bKMKWjrFWoCvLmq2
GuilVXtgQkFRSYZy+eyg93/T75x5N7Qqq5uZ0tlZ0fVmMZJJjmvhgFUk7mLs
KERd1C4sizOz0fExdj8Uk4dJWsKlJGmDKyheHL3TVmXBROkKwTEM4ah9gVOh
IiNDMXZnMF771FOLc6YKJnPG4llToSCa9QQi+J5mnt1ZnkUXp83WXX55Xovv
O9TT4LpWueBlQ/hi5kBvNKyfHZhWUSQa13Zr8Hr21Lq0cxDK+U06tcrD4ien
T6wLOg2Tqo6DBKS4DrQca7JZ3Q3ZgeF71nV46aFUeQNkhZ4LrBvxxbl5D0HH
ay99srbg2N71WReIrlipdf3I885mx7zZEDC2pC16QeuNwqBy7AVJL0m3Wblw
mswOcMN4GLsZ3wIDc7g2zGB4zC5XuZLWbRP0rmHOgm7icuqVy/w1duCrA4tR
STDuuI4anB+a1yzHmyta9BCn64h//tnmEp4mVjXMZSbbydjEURHeQ6eGqNq2
uV/rhkAZm8qo8vzhvXuPnouvyjG2gBBAGOpgvLibb9JeNXb7BY/LgsJ8+iwP
nDlgRD7v2nMf21EQaTaA9zZQuC3OqDx7Gw70Rocf8vDV5jwOB5vd4lyGwaXb
DsB+56a0gASqQTOqw0SrNyWWga/apVbf42PsqH0WzUdyA7spBfTwupo5Plg3
c6j5iyes26lB6A7CQirjdKVybZuwrk4z1+NCoTVspeKhVDQIWzwU3VuBGivL
2qIvNDkUxCh4/g1ZFglr9b1hPIx9aQV8OJ+q35wZwJjnubKPtG5x75BmlxmP
FVGuer1BFiBTWo3+5GALz2WuUFrgh/Peg10X0onRBaae61MD+tu6cXpg0SFl
nueFjM1DDjtQLIC3e1EOI5pGKWNTuYXkHigUmmcvxZclGRuGw6xOPQ+bchpH
wQ5Mp9FLc0wOM3nIhNeqGRdkhuMkoaPUHgwWb/Tl8TJ440qOPDYB36u0IPaA
7u29SKPrEecMF/tcbk9CTK2CCaHSVJKK5TEy9tUmYOweA0uAgS3OrWTwwiHv
Bvc4g3+CF5X6AnlIzCVYhhA4SFf4XTVOV2NBYRTvMpC9BsDYMrbI9oLWG4Vg
wYXtImZs6RvGwdj1EJi7tWv7LbKImLIdhNsu2qVb3LvOfihg+yXA9rmDlbYX
1QNohcJyjD19HM+2sc8w+eQueIh5m3AvTvLh/ULGxpDRhoKRY+kz64KTW2tQ
xqZyK3lb9D78HBD2i+6POsoxtlJlMyzZGNQM+lNyPqSzYII8FvgwCg09z6uN
i3UUtn9CFchZxxrjBM3KQJ6Zg7ehSFnhWCLtlYr9SzvOf2ZPM1J0PSnGlhpY
WVyFaJTTjaL4YmpbhThTmsrAQ1bHRWUkx97NZcKZOGihXDJy5WcwY8vYIjEg
tN4o3jFjV4ImtEYAufGub5PkzDUJPyS6xb17yKyErUnS8kJo32tnbMsqVAAh
exm83QXYZ88C8CG+KF/YSbjmUF/djF1HOTaqtDis69KnRyhjUxleqs8fKRSK
z592Jditgaoi4pf4SEHU4Qr92achyTPHEihsn7M25Mw88zuteqd9qySOFOnY
j5IV6+x58V0yttTAumgNswSfqpGH9GZsoquxMbZMHTsrbQvI2D2gDYqi0Y+x
G+Nk7Cxao4karixJ61Y0X2DGBrMY70sg9/Bursgx9hVm7KCF1PrI9diOHGMj
Pj/fM5nVuJQNplG3+IwoZWwqo0j1+RMN4Ozn4n3HAXceZRl7tZ2/qa643cYC
Kj77ot/DFbd6nffh1J7eYd9vDMDYjegG2uNDgaC2SJ+7GxPX9WfsesiGtr3I
/cVDeMrrv9F8ZHDz9OKFVClbTxCeNJjEvMOfFZGxRbYXtH4o+DJ1zr8iydhS
N9waZvEQaGzV2j5EV4vC9YIRb3lI6VaGsRPYD/FuY6vOdlZFljLk+dcnDKyK
vEIP2eHrV2U4DOgzXYwNt1mX9dzbEyeGabwbQhmbyjgE1bG9r8SXx8HYNbT0
1i5bUvl0IbSFi8/AdVMuWDs1b+4XirFLF6SOVXSCtw9j10Nosam6IgvVKbOr
qzwojIW3sQf3FPcf+sUlHxmuW1QuebYtnk3U7CZfINyHsfHWJDyxcFTIBFwa
svOI6g/wYqWcON9e4vatRmXsIVHIMbacLeSgDYIC8N5xKJwJkH29bsaWuuG2
MPExbEF14obb6dOXhmHsyzLeplw6j0dy0X0HOjGyatjlty0WlzdyxRjGDicI
PIvNqE4uIrV8EBW3p2Bi351jox2NVQN4e7qUZHfUHaubQYFToSIj6KzIufjq
7Rhbx2+7w7MK3NJ1bilKTlWlT9bm+eurzAaur15tzwt8W1zHRovTKSc53RdB
ITN/2V0b4WPh9YsvFArFvcf9Dy6ScxQdDfVIxiMzMPB3zMfM8m9xHqAZpB7x
Lk/zF3XkvJx0WV6oq7GgEJYyOMaex6f7JG0hC60PipvKxdYq96rNymjJ9mXf
G24JE9HsHL8lSloU7W4cJ7+X1G0DJeF8HRtN96qr6k2Bm0oQQBM+EgOyaMzY
Wu4lrcaSQ2uTRtwt8JNpFz6WiXpBD+ctmz3Hp3FIm/VdyE9VcsCpUJEReB77
/rcDnMcesTXLsVw8lElGRKW8RjGSS0ZKxYE/GjNgE6w3Xz77YrCj5rdqtXys
kInVOj95V8mgvb98F0e9VxRytpBrfVBUEwB4pdx1NHHwG965sbpHmEuGOSfM
VorpJl53KNdrb65LyXAhLyLbbCEZysTDle4PAnQ25N5Q1TXJj2T2BU6FiowM
/Amaj6RxsZDzL4Pk5emLshjwRwHtbqD4OGGiSpFJ4mMv7xI4FSoyMvD3inwM
TfCNDW+ruZc5qerghw/tbqD4aGHC+hs5Lvj+gFOhIiMDf3ffx9Bu+XVwH0i7
GygozNsAp0JFRuD3Y9/vYuyjldY3P3n/vj1sc37W8v+uD+APH9rdQEFh3gY4
FSoyUg48UijueV92cvaPP8BfyvjDLz+O3/7Av+7x+Bct889ajX4lwQ8W2t1A
QWGOBTgVKnLy+oUG/86jQvNCSNtvGy2/Fi7fPvzf1wMjBOMEecvb/x0I8ocJ
7W6goDDHBZwKFRl5W37pffrk4cMn9LfUqVChQoUKFSpUqFChQoUKFSpUqFCh
QoUKFSpUqFChQoUKFSpUqFChQoUKFSpUqFChQoUKFSpUqFChQoUKFSpUqFCh
QoXK61fswwcPH3/rfXWbH7r48YfWd1/Bb7/82L/e4e41YBFglz+uw6/goKb8
BHVyh8HeYWjyAF/Hnt7HX/V073FxINhdAp5m/jl8/l/OPvqvULt7DX8pnPMz
+DV3PzSpKT85ndxhsHcYWj+AxedPAGd7X73tg1pSvvu6tfer94+Ott4N+Opz
CzXlp6uTOwz2DkOTA/j6xecKxaPzkb6YF/4UyFlnF9ep4P4pu3/W0dyX0dgE
4FxnArtnF/DJlfjRaSAo+mFZyYujt3riknW3QfndZ6EQ9/DrVMB9PhGM/ZUA
ur6Md/0qt7AN+qsu/UwZYEv9fnm2b5MxStuU76iNqJNElHWfBgINwcVmMXjq
PyxJ/tJuDz1ED0/YwKA/hcwprZZkT1m2JvhjkmBxy0b96w5myQYb42Pb2Icb
wxBtmGgaDRqKZWC1Qqc/NzKBUxjX4UFJox47P9hN5a9b5fCZfz/T48emR27d
AF+f31coHo/G2BI/t5d2zU0tznS1taPxYwF9gSdb4ZMv10AvTAXoPL5rVDMp
ZAj+4ni6Kx+tduPSWAowVBM74G/D4QQwDqEE2Sb4AcFbm3L+LHMrt5QxygAo
xttG0wnnA85Am09qIf3izPRlebgBRO3TizP6AZ2TV1rUPov74v+YIFjQqqEd
NTH9qnKW+IBan6liCMOMYYg2TDTdzo42f0Rw/fqEQQDnTIOSRvlIOzO1E0zU
gnroFcGeidNorRvgbRj7m+6ftE57lFPatf1KNV0pJtptErPPm6wX9GVnWzDP
iWSSMIiaUcvizOwVSnj4i+NpVVYH/NZ62Hxz3ahmG+XYqV0FzLQTgmaqJEO5
fHYCGPs2qPBVpIRe7RvFiKa0HjbqWYi3mk6xFi2cpLYao4yTNBmjtE357toI
OqmyRjJzLaS49Kx2AV0uOiRxoV9mtwyoSV5pV5vzYNIEffF/TBDsm7RXA8Ga
N/creAVRT5zZFxBpw18oHnoMA7fhouk2dlzeaJugGjBzadigjF0PAE5wAQao
p3PxcGXIddaIAKvjZ+xVe6C735zfpFOrPCye1NIn1gWdhkmVwx5mwbm54WLg
DK5VLpxEuXmqHvatLUCKmJl12Hf5VWeOtejmQH4ybbObgIYxWeVYk83qroAE
ew7nA6rjaBpfxBbJBdbxS4tz8x42RMawtuDY3vVZkRPOzHrYcIu72WawZEQV
AMTYus02tOaFaRHb60321Lq0cwAf20geOjU4G5m2be7X+I42t7xrkOG16pXz
aPCEdDrvDRL6qsX3+TeaDeuZMlaa3ri2cX5gAnrwhNIg/TjFIQNGsmyKQq8W
MnYMaEynXpEIolEZu3MuuPapcQaSBYicLrcPIlKB7pp5dmeZG7wVGqsR3TIq
Vb4QZ81q0KmZd+wFO4wiZUqsCod6GvuDt5+xmvkjp2Yad+3YdFd6Os/YIh2M
do0kgULGljRiqx45JsOeWl02XRVh9gLpbo45cenRIKeMVjdwlb5Kk2bsyYBt
xregCQz7nddBIgq1fRzPcmNI+AwqM2dTcANgdZ1hq5LcN6sXPHsb2JTGta1U
9JCYVc1cleGwZWK/HU2tavjYuoRVtKpZOZGsm41kR5h9qUG/s+dFcrES0HOL
CEutV9cJELzw+pzK44I5DGCAZubQsbxylszKMAB04LPNJeIDGuYyA+9sJt1m
DXMWdHNqWbnMS2W2YoCvHkDGHumEn2yO7a6UE6V8jGuJBnI/NIXNR6s3JZaB
nGM/apWh6tC8pj85WEd/T5/CdXdkBxGsw77htarQbAhTuxLW6tyCZ1OP36jb
hGEOF2hzpnKGuISZYYD28MUK/y41c8K6nShtcByEYQqBV3xzKte2CfE57vom
aoUPOS9LWFlr2C0UY4VMJBc/ci2D22bRW9KeOZwihh1oeN6DXczPiOHTHtyR
csljX9GSkJ912vWoU6iQVj2ElePZ2/XZl3i8KCimiD/HX+JVm9G6cby9gh4I
XIufIhMeBG2Ho7LxMLZghmok3VDnjLvJqw5NHJliAPHYrGvPfYwnFM1GDVuW
2cUlwQpaNgLfFhuly5QNRBRgIkDBjowFl64yxiqzXNe7OPDNeyE55xlXpBu3
j06tsC9fNNvB2DJGRNWDKef2FsfP+hK0rAor0LG5jic743ag1U9pUow9KbBX
2yrMzKLrtZAFjSrNjeH61DDdnj6QihYN+/g2aFaDaYeZ58hwxWVdwh7SkI19
Ppquz+CTp2z2jZM9SztYxmRHx6YJ/Gs7CHMzERyeQ4PDSq5rMmHpGJOHm4U9
oUQtxCdvkgyAVQQj9/TAgpDOnudveBWtLjMerBb1+gC2qz65p1j25/qgHlAV
glgWNsx+yLfBVKKCRSSlqcTbV6kv4Gk9uatFkVvwr/ARAVpmD8I5zXzvUgJt
MDncV/4QJr0oMcNrzBqsiqzzVRHuYgIwD98FSERdJFFERDrHZOrYD5HOUSWq
WY7lMjGx6gT5laAxBZ7cwEhQfczIsdyZdcG5FySMPUcGELVD7z1JXnOdIi+F
K7JpX5z0dQzdBkcoNLoLLUyayS0yzRGdAIeZvSyjrtc2PIjMPYFIl0VuwdjQ
lLM69TxsSpzHTu3ALvBLC1GUn2Rc0HWPkyQ9SCFjeaNp5KWqqyoXDjMrOYFR
ZEyZPV4md+J8BnaEJyYpY6VQ12j1cUMK7+qNrLTzdGUvo0a6bjMIlsPQGeYg
9zZ4xpY2IkI6s4QRNS42jGCOqxPLcoOMOckS47qn0iQYWyZSxgCWdNHFkI34
Bp4Z+THULtbhlIS8FE/E3os0DnYjmoVb9aAR5a54BXTKQJtWZGJfsLhL+zTT
cCLDMwWcv2YlyuYjz7ybbt8yqfDgK7a9I3gF+Ztk182MuyMGD1YwUWOwkLGl
GABAgxrjnoYXLwApfpfOThZrlzANWEp1L5G6ALIgydZ4+6AeUBVI24vMxtVF
IBpiuRbgKzyXdjzbgtRUGAJ8IgfrmYsGdxT58yrD7KwxTqvepsTZ43/puEyM
v3m1k7GFS1RysSyuZqRg8gA8rXPVX2ZXySwpxXjcULXMVi4TziXDmXjgBC9z
DDDnJI+qoxkW1V4c1nVuv7ujI+TnmOfJFEamiXzwZNvkYBZ0yvbSTBg1eEb2
XKS5IV3XytlmxxRpkq2LjszYSpXNgM8JLNkM+tOLNqLFNaGnQe4iEY3iF7ox
GvBOMI3LfdhwnUbpNiXmt1kHsDs0PcMRo7SxLmH6yhT4McOS+7W083TvCo28
mkbDwFRp3gs34uu8y0ka8dKKfX7ayDDHbKDWdoOlDImLNO/JvZQmxdiTA4tS
C4kydeNClGPfkMRyeRe8ys8y2Lc5d0UAuRhEFSFLTSb2O+Mlcenf2FlbMqpx
nUGqbD7yzLsdLLDAiNMgn6zBiWb6vJjwkQxBumucKrQnxCrxwzZjSzEAtik/
q0Inn4MAO1VEbDrIlPT65TOFQvHg2fnQP8A7TB2buAFZ5nPlI0yD7ZMk0LKL
a/s4A9FqlvCxIhC/O2v685i/M8zTwzB2ux57JcnYaCR9GVvI/NDH1DiP6vCx
8z2TmVh5Sivk8zc3wqG2GTuU4EoBU0ZmxeXacpGJvqNciW8GuasEr87Mm1Hp
zOkfa47dWRXpsjJGlPVpeCcXRjS3Qlw7LCA/P8lcyxuFM2U9ZEPezk8TgIWc
9i0xYxNjXYi65jQs5TyZrp2s2zE2t5xUHR+YsMvJGRHcnAvt7jAqriC2cFVG
emiPXIhOXmlSjD05sHhKEp6KwQ0lPJBnhM6J6H3hKh/g9yPaJCYGyMGRiX3B
zREnKvho1QtO+zqq+YyVsYFvV2FK7PAHTw3QWA0S0UDV0l1jUELG1okYW4oB
qvDV6bM8P4DYjoCxec6R3cmVAvjsC/jZx8CwxezhwvymEYXrqUV8TAgvkYjV
9nkNGJHF0eBnL/kVWdLtYCykXsq4uQdGHDMyjF0VOAYmAQP/rqxX002z7elS
mvGkGTsMzQrWd9yjGkm3eVmfIa8mTsAKd07ckSRjo4mM3wS55txGgrF3AmSE
hYMlviqihVNkBE3uKum9+/HsPEq/hAapuuKWUQW0SYEzChTIs0Zlm7u4aJUz
Jcre1ev8gdjUnt5h32/IGKtz5Y7CTbP1Z0nnGV/9sz2MjJsjYRVKdyWNGPMZ
Frxc0ovX0SAHFrqBSJ+ySpNm7ImBLaIjcFwlijRUv8LrGqFz4pId2ssj9bGB
GVsc+/zNuPzi4JKQCvSrcdaxcRnKpyFLVLMrBFwIV+FKMl2LYrC9nORTLykG
uMbv4hc+5cNVxCQjM3b1xbeArh+zL/sAH0QVOOVTr3i2LZ5Nvpk8e2yzHsKU
csVN02ZXkC8OOw8CpXzAhbQH0shmZhexuv4qE8td7KJ7VnL1m3O042PbPioV
wz7D7GJXHRsvW2zbh6Vq+yJatk85XEeVcuJ8G5YyjK6gmJEEjJ1yLeFESGRl
I9o99Lo2vNvrPpfFjGZh47bgUXlY5lo1bOSK6VKS3VELNwd7MTYqSk+5/IFS
JnSMF9FzTKp83blQwguu+ZOLcC60pZsRP5xsZHD7VtJGfxt7cE9x/6FfvJ66
BWPjMqZ22ZLKpwuhLbxJgSuWuIKHnD8sgi9nypQL+cbmfqEYu3RB8l+F57Sl
jdWIcl1nItiy5r2QnPOMQScixua253CgyRjxe3SsfeksHqsVI+hEKEy3ejB2
D6Xx/sD/MUGwb0jJBcSsj2UzyVCUxfuDcK+tJV7Fx1y4EMSZfhDGloz99s3F
Qy2Mpq1MPhL1m/Da/PhCvuAzkh3xUgI8GeXAuBJoqch1jdO/mfnji3Apvo9P
A3bk2JIMQN6lOrmI1PJBFypjgkRdkrEHqIq89S/DOvYoH1MfeOcRDPsS+baT
nO6LoGHPX2bF23k2FzFrLmDRtq+ryAc36hEPOcoFN2Qdai7H3p4nCUmZxWp0
gjSGv1iPeJen+S50a7u1bkYiC5x0q102kWLsjjbv8gc7HTJ7zp2+w1b2QQfr
ykiVPGNDwvFepMGwbfzHVZRLLrTLvLh2hEaC96HQnJ4kToLho9NE8OFc5n99
iqivq3IiMPrrF1+gb5IRL6eGZGxv50tXeytt1HNL0fYhJbR1KMj8hUaRNCU6
yDfPP22V2Sj1NFbqgBHejD7QJOM8t9cJWhrwG1LYk3eUHEAZI1ZCG8LPXpk3
D5tCPUjoU1ZpvD8IHWNSYHHXB3rBwxHtcOdvRc6JNz3RWR3kq2gy5evYaOnd
GQJdAcXFfnvnUeAJ0067Hqmx62NHo9iRbduxfASnIbz/CDcc8d+yXTfiuzpu
wFq0pgAYBWAlGQC8yy0AO+1CB7o6VYTz2LY+5RkbnRXxvhqOq3taeYhGtgAC
8Ah6MlwSfdCmmgAXC/mE+OPncO+v6yxHu2XRlpz4OnhXJh7K5bvYbNytUYzk
kqFMMlIb7kR9tiQAWysmZN6eLWUipS6d9GkCo7989oXi3pMBA3bwBg/YxCHq
oQYmZ0qkw0ipONDHKJrlRCHTdbOM80xYJzJGrKcLcLc6VChO4qNkEwYLPx4S
SkWDmXikx0d+0LkdqbMcsmPuGftcq+WhJ2A1NquJSrlXiX68vi3bNbJmQZ5J
ZBggWwAX4+HKsF/1MNnz2EO2sniZSdtEGmf0HFxQKZ6+6PrA1O1N+dG1T0on
kwTbzLO+TZiFateG+aKGccX+nbfjGD/zKPldBEO1atCGC9rvXS13uAm+muBt
NfcyJ3Um6Pam/LjaJ6WTCYPF9dhF5Yp466d3G0vs33k7jvd7ReCXYj1//6Bo
690G/X6zT8mUn5RO7jDYOwxNDuBtGPtopfXNT94/KNp6N+dnLf/vqCk/XZ3c
YbB3GJocwNt8P/aPP8CfSPjDL+FE8PGuO+5qwz9j8fgXLfPPWo3/oab85HRy
h8HeYWj9AObYRwqF4tnLoT/vSORto3X0JczbP5YfUPt0GrAIsAuYoN9WWz/+
SE35yenkDoO9w9DkAb6OPb2Hf+fx/qi/80iFChUqVN6JoN9Sf/TtM1Zyf5UK
FSpUqFChQoUKFSrjkv8H/mvOwg==
            "], {{0, 59}, {486, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{486, 59},
          PlotRange->{{0, 486}, {0, 59}}]], "ExerciseOutput",
         ImageSize->{490, 59},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d0453aa7-b2a0-4da8-8dea-0e7aaa9ef1ca"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXd9rYlmed2Zf9jGz87rssH9A6i09CwuBesjDkocGl5UdaAkzbJzMg71J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              "], {{0, 59}, {486, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {486, 59}, 
            PlotRange -> {{0, 486}, {0, 59}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cd93c0bd-f1f2-4868-b905-d237d164d9ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8a394b04-6d8a-47b7-8438-cdf42f707eb8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"cf49f9d9-ca8a-4efe-b3e1-f794c92d1cf3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"86bdbaec-fe97-4510-89b4-e1f0b42b8c28"],

Cell["\<\
Find cities that can be referred to by permutations of the letters a, i, l \
and m.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"a6d0a4e2-d654-44d5-8093-87137126b798"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fccd7b25-e6d0-40d7-8b9f-c3fa77bbc5db"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm+9LI0cYx9P2TV+m7cuWlv4B8V2ufRXwhS+KLw5SevTFyXFHk/NeeE28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            "], {{0, 
            27}, {211, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{211, 27},
          PlotRange->{{0, 211}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{215, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c04ce4b7-35d8-49c1-8a6d-2e62a93d57f7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztm+9LI0cYx9P2TV+m7cuWlv4B8V2ufRXwhS+KLw5SevTFyXFHk/NeeE28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              "], {{0, 
              27}, {211, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {211, 27}, 
            PlotRange -> {{0, 211}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1ea0a05f-4edd-4d80-a254-a41bdbc4048d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3567eb73-3071-493e-97a1-cbb2e4e30842"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"271c64a0-885d-40d4-b234-46bcc4e047c3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5609afb7-4fc0-4850-af58-8bfd4b795dc5"],

Cell["\<\
Make a word cloud of country names in the Wikipedia article on \
\[OpenCurlyDoubleQuote]gunpowder\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"e6d79ebc-e0b2-48d7-b056-728a2db9f34b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fb8afaaf-52b0-4264-afc9-c971721b6753"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvdlzG1eaL+iZeZnH+Rcmop7qwQ8d0RMT9dARrorqvlPRFY57Xe24FXbL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            "], {{0, 309}, {360, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 309},
          PlotRange->{{0, 360}, {0, 309}}]], "ExerciseOutput",
         ImageSize->{364, 309},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3a0fe2b7-f91f-4751-9e5c-bf84d1786c8c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvdlzG1eaL+iZeZnH+Rcmop7qwQ8d0RMT9dARrorqvlPRFY57Xe24FXbL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              "], {{0, 309}, {360, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 309}, 
            PlotRange -> {{0, 360}, {0, 309}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b8a511ba-daf6-46a1-aaae-e90ad9b0fb00"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b93c3612-fbd3-4a4f-9226-54a7c210aea7"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7b605047-a412-45b3-b9b9-ef5cc55fee7c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ed517374-7e97-4129-8141-944fe26b8a0b"],

Cell["Find all nouns in \[OpenCurlyDoubleQuote]She sells seashells by the sea \
shore.\[CloseCurlyDoubleQuote]", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"12952725-8367-41bd-bbec-0240cc534fae"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"04c89adb-91b4-4d69-874e-3ae8619dc868"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK+P7DYQjlpSWKl/Qf+B4FLDokivKgt5T315KrlG9ypVSwrCAsPCgoKC
goJCgiJVISYhBiEmAQYpMDBIZ+wkt7eb7OW6e/0h7Uh7tzsZf/PN2DOe3W8/
/PLO+8KyrM9fwZ93738jj4/vDz98DR9+fPj886eHjz99//Drx08fH7/78CUo
v4HX7/DC9+Nd7nKXu/zfZeBNTQe1z7ajTdu/dtWby5uTEUXo2bZP5S1BhyaE
e6Qedhk3oW1ZoXjlqreWW5MZUo8QN6j7aS8HGgO+F+b8ppurYUmzjzaNiWXH
wytXvbXcmoxqi8S1LDusJ/wmsqzo6bwrKeXJHig5nNcDKk/s5JHK0Kb4EbRn
y5972c68GlZcX4J6FeHLaC+GsIGnjvicMmkTx7Ijod9LipnXscoq9iwtxI+Z
VvE6dWZVxTWI5EV8MDrL9spOK4c2dCddkNZzDu04jWyz+pDP6RzK2DeWTpAZ
DquZ75uUzF7yVqzFeAXhHWh7QiBe3BqtYgEhYZpqCAda9wqTo0hBWOqaXTBt
J6lZ15aBd2jEKNsENG5UgCpBVwEHD11uW05aUdaWPnByEgCtAnh6aDhvisgL
8jmHuDpvqOEZU3RYhQTDKduOFkCSRM165lULT52o5JxloR9V/DxT1xDeg3Yx
BCvIKlpneNxs9AK9w+TZT/Kqbv9cY4JnXmcbUAQrQU105zGODmktplqRGQRv
R0hewcHJ4cPTdSNFx2gCkZBYjKo4GIadehYIqcxRVRRYRZgapOelrYaEhE+l
t5J5iUtsP2n7zW5zBeE9aJdCcBM6oVLM8KJ3ovoyE8UysA/zNtQVWE5UVJMF
prKcQ9bDXTw3kFlcnRMWeWhlOy7+I7p2ZJf4Zs9tgB1POrZsyEzvFNJJho1u
I9rCm+rcL7vVe+4Kwi+jbYYAcYbNvHtHO4IG1FhvMNFAsfahRIvOgvKYAKuw
wZL4D1x+VpuYJcuptecO74ujQGRfRHh7l/0G7QHf+Hk3nmNuzDYwUwfYn6Lt
EeMKwpfQ6IUQvIxN1p0+w0vmpx2Rq0zwge5CSY29h2Gv0iWf+s4hZf0w8BpU
bspEjTXhxSUXomuKOK2hEJsIPTccNJkzHaE+dp0wb4SUDPvOduZHmWPTI2nF
hOB1FmeaKrYdK4BWpQctu+ik4qVL/KLlUvaZrzOv2gO0iqBYwrmCMN4jL6Jd
DMFOqpaz6oAH2GdyNDsyZ35cZTJOt2psnC6zTVclzlNxRKZl0yxYdIanZDlZ
FIGrAxFwry5mftKo6fQ6M23qLqwUTzyyGIdlp3cfg3HhIPWlfhYNgoauvbSk
HAYIDXJ8+K8gPO5B2w6hi72Z2zIsHRuM60zG57ONPmbhTEANQpyO0EoKUD6b
XVFzPkSvKDcE3YDxkWaYXSDMTECbPX19x/I87RV/n/BetA2Rz7mtyxmTFjI/
XzSm88Bc2t30O+zNhRdYFyldHUz+ZbR9IusER0AzSE+aNPS8oL3p7zY3FzVw
xm9G8bZo+0QWoe8HCftv/DZyl7v8w/IXabqZvA==
            "], {{0, 19}, {126, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{126, 19},
          PlotRange->{{0, 126}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{130, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2bf38b87-5fa9-46b0-930b-3e5c1bea4fa7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK+P7DYQjlpSWKl/Qf+B4FLDokivKgt5T315KrlG9ypVSwrCAsPCgoKC
goJCgiJVISYhBiEmAQYpMDBIZ+wkt7eb7OW6e/0h7Uh7tzsZf/PN2DOe3W8/
/PLO+8KyrM9fwZ93738jj4/vDz98DR9+fPj886eHjz99//Drx08fH7/78CUo
v4HX7/DC9+Nd7nKXu/zfZeBNTQe1z7ajTdu/dtWby5uTEUXo2bZP5S1BhyaE
e6Qedhk3oW1ZoXjlqreWW5MZUo8QN6j7aS8HGgO+F+b8ppurYUmzjzaNiWXH
wytXvbXcmoxqi8S1LDusJ/wmsqzo6bwrKeXJHig5nNcDKk/s5JHK0Kb4EbRn
y5972c68GlZcX4J6FeHLaC+GsIGnjvicMmkTx7Ijod9LipnXscoq9iwtxI+Z
VvE6dWZVxTWI5EV8MDrL9spOK4c2dCddkNZzDu04jWyz+pDP6RzK2DeWTpAZ
DquZ75uUzF7yVqzFeAXhHWh7QiBe3BqtYgEhYZpqCAda9wqTo0hBWOqaXTBt
J6lZ15aBd2jEKNsENG5UgCpBVwEHD11uW05aUdaWPnByEgCtAnh6aDhvisgL
8jmHuDpvqOEZU3RYhQTDKduOFkCSRM165lULT52o5JxloR9V/DxT1xDeg3Yx
BCvIKlpneNxs9AK9w+TZT/Kqbv9cY4JnXmcbUAQrQU105zGODmktplqRGQRv
R0hewcHJ4cPTdSNFx2gCkZBYjKo4GIadehYIqcxRVRRYRZgapOelrYaEhE+l
t5J5iUtsP2n7zW5zBeE9aJdCcBM6oVLM8KJ3ovoyE8UysA/zNtQVWE5UVJMF
prKcQ9bDXTw3kFlcnRMWeWhlOy7+I7p2ZJf4Zs9tgB1POrZsyEzvFNJJho1u
I9rCm+rcL7vVe+4Kwi+jbYYAcYbNvHtHO4IG1FhvMNFAsfahRIvOgvKYAKuw
wZL4D1x+VpuYJcuptecO74ujQGRfRHh7l/0G7QHf+Hk3nmNuzDYwUwfYn6Lt
EeMKwpfQ6IUQvIxN1p0+w0vmpx2Rq0zwge5CSY29h2Gv0iWf+s4hZf0w8BpU
bspEjTXhxSUXomuKOK2hEJsIPTccNJkzHaE+dp0wb4SUDPvOduZHmWPTI2nF
hOB1FmeaKrYdK4BWpQctu+ik4qVL/KLlUvaZrzOv2gO0iqBYwrmCMN4jL6Jd
DMFOqpaz6oAH2GdyNDsyZ35cZTJOt2psnC6zTVclzlNxRKZl0yxYdIanZDlZ
FIGrAxFwry5mftKo6fQ6M23qLqwUTzyyGIdlp3cfg3HhIPWlfhYNgoauvbSk
HAYIDXJ8+K8gPO5B2w6hi72Z2zIsHRuM60zG57ONPmbhTEANQpyO0EoKUD6b
XVFzPkSvKDcE3YDxkWaYXSDMTECbPX19x/I87RV/n/BetA2Rz7mtyxmTFjI/
XzSm88Bc2t30O+zNhRdYFyldHUz+ZbR9IusER0AzSE+aNPS8oL3p7zY3FzVw
xm9G8bZo+0QWoe8HCftv/DZyl7v8w/IXabqZvA==
              "], {{0, 19}, {126, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {126, 19}, 
            PlotRange -> {{0, 126}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3368163c-a2a7-4892-8311-a742752d10e2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ef9e3811-7b68-4dcd-83f0-0a79b54538e2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"feba642b-edb1-421a-9ef9-a5d250133b79"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"62ec2dd6-5bed-4a54-91f7-6fe875da6537"],

Cell[TextData[{
 "Use ",
 StyleBox["TextCases",
  FontFamily->"Source Sans Pro"],
 " to find the number of nouns, verbs and adjectives in the first 1000 \
characters of the Wikipedia article on computers."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"ba3006d0-195d-4bc7-8ede-6784557d59f5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"78ee5216-43c4-478d-80d6-7e4142b41fbf"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVSGP3TgQjlpysNL9gv6B4EMnGRZF6qkspNVtqpK9aFvpFBpmaGYWFBQU
FBQSFGJiYhIQYhJgEGIQsJ2xX5L3dve9t5WWdUd6efF4ZvzN+JvJ+y//fUze
BEHw/Q94fPz8P7m7+5z98w4Wn26/f/t6e/Pvh9sfN19v7v768haUf8Lvb/jh
+/2rvMrvIqahSRim0u4aJcRoDmszyqaqqrodzXIpzKz7pga7Xk2bbjFDW1d1
0+v5Kox5kHKcj45YjOjg5BqgeIMyISTO++lgM0sOrZrQWq9OPYtAE9Ie3kWR
BLgI8RmQVj8N3sjKW/hnWilQWuWVXhd109nEhypzNgHtzUFllVOFEcG/vB0h
E9UU8QoMkQsWBGyrtx0qHyTiAlYF8S8ArgcvwsTTR5ewSfWhMghhurdlhMdo
Vx3QhXl3DvnYlnmK5eLCHKEiPo8WcgiZ31BFtL1bicjXy9QUKkTiODyAXOaV
NPczO48cds160aaneOg8cwKHHOwVVivX56A7E4DOTpDnnnYTQj+glRiUz1u5
1iwkxg+aUZfRfugqOg8eK58QwYgDaXi42+s2d+mcd7OCHCFfdANLkpaDlpQE
hB7uSzm0EAYaKAUDx5xlrAF21mBhgCSEq+PALqmwOcPzTXyQpERfwZEAKeUs
jx0BY/Fs5FD1ggSrhO3a9IsjM60V9XrjLCPXXJQxlkee6dgXvmJomNXDZdi+
F4K4XAFa2ZR5ltGiERghEva87ynyLocLo4NdJtWkITbJyjTLXccvRoEJtC5o
upIzzhkKjXA3KjpEPjrYSSGvwJ56bE3Cpqc2kaqkuAD8fpHIc+mTNiwMonJY
d9jGNKsKOKToMY+hijf+b1EcWxDqUOd+znVSCtH3vcShvqgMWjhv9omkW08I
3gpvN5hFVTkM20GPXYkTjnYup0e+OM+klB1CyspOSamtrbAKSTtM1k4NhZxi
/7lxXcm97+ls8YJjIcIiG76TzYvL3UrEGe5e0lH6WGAyq5puy6xcW/uRL/Dk
gTODfrAD3bVRJc160D5b3Pyh1z9xp4I3tUa4JIs1xsynbf1cX/SeH3grjmzw
vp45JOHjlbGxi25gIAWlNNdNX9LX9kUWnHxTbF/SJMnVpf45kWXWg3629Yv5
2oamaV4Mv8qPV3kh+QlUYJET
            "], {{0, 19}, {62, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{62, 19},
          PlotRange->{{0, 62}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{66, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "69b01d7e-75a7-4ccd-8f3a-b8c31571c294"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVSGP3TgQjlpysNL9gv6B4EMnGRZF6qkspNVtqpK9aFvpFBpmaGYWFBQU
FBQSFGJiYhIQYhJgEGIQsJ2xX5L3dve9t5WWdUd6efF4ZvzN+JvJ+y//fUze
BEHw/Q94fPz8P7m7+5z98w4Wn26/f/t6e/Pvh9sfN19v7v768haUf8Lvb/jh
+/2rvMrvIqahSRim0u4aJcRoDmszyqaqqrodzXIpzKz7pga7Xk2bbjFDW1d1
0+v5Kox5kHKcj45YjOjg5BqgeIMyISTO++lgM0sOrZrQWq9OPYtAE9Ie3kWR
BLgI8RmQVj8N3sjKW/hnWilQWuWVXhd109nEhypzNgHtzUFllVOFEcG/vB0h
E9UU8QoMkQsWBGyrtx0qHyTiAlYF8S8ArgcvwsTTR5ewSfWhMghhurdlhMdo
Vx3QhXl3DvnYlnmK5eLCHKEiPo8WcgiZ31BFtL1bicjXy9QUKkTiODyAXOaV
NPczO48cds160aaneOg8cwKHHOwVVivX56A7E4DOTpDnnnYTQj+glRiUz1u5
1iwkxg+aUZfRfugqOg8eK58QwYgDaXi42+s2d+mcd7OCHCFfdANLkpaDlpQE
hB7uSzm0EAYaKAUDx5xlrAF21mBhgCSEq+PALqmwOcPzTXyQpERfwZEAKeUs
jx0BY/Fs5FD1ggSrhO3a9IsjM60V9XrjLCPXXJQxlkee6dgXvmJomNXDZdi+
F4K4XAFa2ZR5ltGiERghEva87ynyLocLo4NdJtWkITbJyjTLXccvRoEJtC5o
upIzzhkKjXA3KjpEPjrYSSGvwJ56bE3Cpqc2kaqkuAD8fpHIc+mTNiwMonJY
d9jGNKsKOKToMY+hijf+b1EcWxDqUOd+znVSCtH3vcShvqgMWjhv9omkW08I
3gpvN5hFVTkM20GPXYkTjnYup0e+OM+klB1CyspOSamtrbAKSTtM1k4NhZxi
/7lxXcm97+ls8YJjIcIiG76TzYvL3UrEGe5e0lH6WGAyq5puy6xcW/uRL/Dk
gTODfrAD3bVRJc160D5b3Pyh1z9xp4I3tUa4JIs1xsynbf1cX/SeH3grjmzw
vp45JOHjlbGxi25gIAWlNNdNX9LX9kUWnHxTbF/SJMnVpf45kWXWg3629Yv5
2oamaV4Mv8qPV3kh+QlUYJET
              "], {{0, 19}, {62, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {62, 19}, 
            PlotRange -> {{0, 62}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9521e62c-e619-4445-8232-0fa9e123c2d4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"72869532-6092-4209-9ee4-75292d88b1bf"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7276d7ee-dea8-4dba-94f4-eafe61ad599f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2481291e-5726-41d0-95d8-254768be1fc4"],

Cell["\<\
Find the grammatical structure of the first sentence of the Wikipedia article \
about computers.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"9e21cc16-38ce-4d0a-b478-2697d11ea150"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"232b82bf-27ea-4532-a0b7-25e962ce74c9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzs3c1r5Nwe4PfOyyLL/AtZB7zOtpdZNUzIItCbGTIespk0M4HQ2941nEW0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            "], {{0, 353}, {1264,
             0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{1264, 353},
          PlotRange->{{0, 1264}, {0, 353}}]], "ExerciseOutput",
         ImageSize->{1268, 353},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b3594684-ac62-4128-8723-0b5851b6688c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzs3c1r5Nwe4PfOyyLL/AtZB7zOtpdZNUzIItCbGTIespk0M4HQ2941nEW0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              "], {{0, 353}, {
              1264, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {1264, 353}, 
            PlotRange -> {{0, 1264}, {0, 353}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c797fa64-e5fd-4a2f-b2c9-a9e33588848d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3f9d6081-4d9a-4ba3-9ae3-db871ef98784"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"33e5b915-b5b6-49a7-bbfb-3812acc08726"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"78430b8a-7ffc-4f73-b217-f0b9aa68f6ad"],

Cell[TextData[{
 "Find the 10 most common nouns in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["ExampleData",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<Text\>\"", ",", "\"\<AliceInWonderland\>\""}], "}"}], "]"}]],
   "InlineCode",ExpressionUUID->"84b41b9e-0f14-43f2-964f-fc32132e5d75"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"f6809c39-7cab-4756-8f9f-7842d2f7413d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"761e50c7-7cb4-4ffb-a597-ce0883f22b6d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXL2PrMgRx3bi0JL/Av8DxE4JHSGd5YzkTj5OTp7RO0sWKRkhGRkRERER
EQkRCZJFQkJAQkKAJRwQdDDuqm6+hu6BmZ3dfT5PSW8129tUV/3qo6u6mfeH
H/7+nflrRVF+/i398d33/9S+fv3e/vPv6C9/+fLz33768uNf//TlHz/+9OPX
P/7wGzr4e/rP/ZWiwOfLi170ohe96EUvetGLXvSiF73oF0dDUxZV97kykHEk
z+b5DixftKWhLfJyEMBMnoT9WBdF0z/LjmP1Fm4yZaUgfBa9TU0Zva+t+8Q1
VdUqx81o4aqK4vZvZ/8wjYWuKJpXvJENzW9zOqojS1EUvxzeLNz/GZFxuOlq
a5CHwqUg59cYj6FBh6367R475NQ1nfxJvoncXAm3tV7ip8XKSsc/jW6qeRe9
m62H0NQ0w8m7iXnpUy6mG7dbPqWvKar/mdCSxrdML2neyAZyrJOzz30RGoad
td/QZvY/QUPh0V2ikHvDGmT0qP3kMaPmdKInxAbuWV7xpNR0k9taLyFJlJWO
fxo9D7R3szWpkoCmNNWdmIPXeeuKiW6Q9GcV6NvURNj4jp9kPz3YbYSiHWzN
MOFaBolUK6JIql55e9X5FxG34yXO0Hik3E06ElIK3aPawfAyTir0QDkMa5CZ
u5aELXgTOiKYcNzFj4VGXRarfOoQ15OJwPOIGH0CqpPqdmraOc8Ga1RWB2W3
6+5jdjzrRmsA7vY9ASAn1Lz1+M61HrT1OWNh2vGYlGMJqYlBSLrCoQpQUg2T
ml/jqanNQzZMx6NiPoAaUt9iw5rpVzh1rELd9NPIgVF3v93Qmk01/KlHI7Wj
qV7WCVnRv9qqFvDma8gCexLBYxMWqTQra4WwDJGlsYdoNWtF1VhHGmtdYWnN
jSJLxT+bQd0WDpurOXPDd2KJS+rompMgviR1DdUMGbAlVdWMBgpJGhoq46K4
Sb0DoZlA2NEpIcXQPabdWIe64WWpz4ftmM6tIo48sgr3BcIVyOiuqh966ooJ
pSq0VCsaJasAjY1vcqR0Q1cVLaxEZQcWAHYYcY1Uq+AtwAKFPm3ZY1t4XDy6
UDj1CpcmC/jTGqzoC2L2Wi/KK/EnKFQzbQAx1nQ4nsOGDSdmjDapqS9d7gGq
Bw4gImayMDRRfOqioqAbY1szA54Wmtjm5sBnvTjeAXJGzRuP713rblvLmZMi
5GBquk6lY3qtm7WatoUsTZEa5TCirMhjXEuHOUMZ4KJBUebMc6Ia1sxcWMyJ
sjKPoLNUnXayFH0yTNNcdIqee/QpizVpfU6zopJ0RMiK1nPalOdznGAFSVmk
tmGmHRkrkMqglm6qAOTGR3bUFjGUiJafZmnRDAPkYQ1a46FgdnejPI+4X1lB
WqApNcwbJ5eooK82K9g3a/QrLQORe4qgCgdlHZXd8pOqriLI++Cupa/zR0AQ
QCwR9pgnhJRB95h2k/mMuCiZW/rlMLRVjJ/dKM0KwfnBDmQBk8nrwNMkE8aI
wqfaRdtVCTiGEWSdcDcYCwOft0HrcD6QRChUP62aMjGnwZrGuuHmVV0gTztB
eNClVdPPyyJygZmwnLjSizSxSh07K+sqhZyvB+Osi2qlZZVhrOkYYktqojss
OIWT102OST5qRFpNJrOCOMurf4uDbvC5UwEVHuA5rJ61ww0gJ9WUPS50rXtt
LWPeJgCFn9VdnZqYaqpu4NGESvV1StlpWN5g2CphxXGrePpCh1misrEVBAd3
LmNK4COCQBVnos5M9kTtO8lPYgty2Chhxet2/EAn6N66BmNu7FGpCKG7GeWp
So4cRxqN2rb+BIdBng6vVQZII7zGg/lo/bNLMI0CGrJ1ALsTtUJKZYZTx9V5
O+maOotcrnufwUFuCqunNndykexHQsqhe0w7tglmzH9JObcA2NBh2yImAch7
JvOGKFkF4k7zKxxtTGjZJCc1TLuUaUcgbMyIeZEZVqgQJv+pLwCRurYqWL7K
ueMpNj/EXEl4W69prG/qMrBA1n72qMl+iaWs0i94Gh6YKDFNRyBX505bg1Cp
ycklQUch0paLoaXAEAJyXk05ngLXutPWEtloXqVO6ZNZESPitVQdwSYYVy5m
/BQ5dxn8lk6yT8wHaP6cbFKjd1g1hSu6s6aTVKz1vnEoQTn4EL2UYcVllrBa
pyb6wd+kuyFkG+dChuTIcWPNdWpC5sNuzvz5/BItxcQIK2iTnTSnQWGlLdxc
GFgXkTxgVbFmmvpkX5JgWiYYg2wrF9ChkAfQ3a3dpg0Zl6r16FBXAvKWyTY1
7SeMiU0TtplWdR5aU51wCMuUhaZSaiE9gM23jNiurRvwd53pDg1huuUmTE0b
vWgj6mEBo+rYnmk7XVYntPN4k9hXchmS1KQt2VgSdEwev5wUX8JfAMh5NSV4
il3rTltLZLt02DG5SdmUsQa2qmZpfGwOSV85uH9fpluYuTCYmOM9oDq/RdA5
7Agduy0z4o0zaTDX8dR0cDHRQlhaSQwBDflGwmrRFCcYYbXigVLJio0Nbay5
S039Muc6eM8vgf2mbtMu3MkHLDAMl0YZbgSsb3IzlnyWo0gc14LQuZXJD4U8
hO5O7Q5SkxQLCciXu1ITHJ6wQxFVN6Nckq6vYZnYIhRWfHWfC1UKHWVLhbxi
hMCn4nJtblVNu1Sg6Oz6vdmmoKmeHEPzumrqIaymEvEGbZSSBB2T3IyXYmMT
/ltAzqspx1PgWnfaWiIb1SmB7A7Gpm1rNicMFi8BWr+GGgtL3y6FdGV4VdeV
icf2hX46ETK8pGnrGE/J/RL2OCwX1SCr2jqD7U6x6C53nZpIRf+kOcnGqQe+
wWl8XxCzWp01sfpW8ZKSFuaBbYZl3+fgdKaftn3fFIkf5kS8HOtcnLJt6nZY
xBsOg/dyegl+XsQTOylRWFoLNQh1CJJnTd+VbM+dFu09jc+TYnUs5CF092kn
TU3YlYRF3TQdOQ+ywF09eWoaMPT9pu+7ruv7nl/dHMAyH2swKLQwq/u+zSM/
ggmQmlQ77oYuw9oVqyaaA7HVCfOua/AAELkd6QVnO4pZtBQurMSWqkkxvZhC
k+ISVlxPiKlJAyGB5ZpbNF3XlqEf1uOxUpKgw/MlxUiqtmKXCOyiSgzIaTVv
4blzrTttLZMN8TFzigkz9nR3h0ffPJ2ub+ia1JurYWg+sCQGQMKlKHXiqXoh
y33K9sJCX1LTiHZRvW0ZRVI8r1+OpESs2LNcqamWRjKTCtWfDngxyyHUouWG
MuS3I26+iLdmTvcXbT4BgDJ4aefPLUEH2VFez/2ZLqjx9vrSelOnYdj2+gCq
S4G5P4O153xGyEPo7tFuY74t/vyGhRa6/zkN8pYJFPNaMMhXKXiynsmAEuUA
FmTLHJW0gblwcFPYGgreTdMFbddU5xQdO9P1l2lzbkfOM9bxxF1zHGOVmnRr
NrE7hXyX4mRMxXWyNJuqCa/VHSl1kQTdUMf6pI/nmTw1yQA5qaYUT5Fr3Wlr
GXNWhq3Jwa18fUOH6ctd5CQDbFiXHbHx3UHoOKxSnoigKjv36uYhK8EEMsLQ
SizxcvDko18aOLnETRJqhld71roDeYAzo0PopLTT7sZUcACc+XyQL/y8lHa+
BN7rITSc57eX74IF/XTjwDgieHrcjZ/QaxRGwUVkYoB2eSvpWq5TSgmDjgy0
zjj/ttNZNW8+fq3xG23NSi94tQaNPcK7AeympsJ2kac6bO4002/e4RVpPFZS
wvKDvu/yAcs9ZYmuzKIQ+6loecvlg7F6mN5LzqHAV2UKmifHoU2w1oyb8cNg
+Uj8P9HW34abQSVPu4y6B2PXGb7HEv4rx3cXV99NG/PQNU1HfuH/OJGhrSVv
Kr4HfcByT1miDPArRn663dw/FKuH6d3kJOsGE+4v8Sz0w2D5SPw/0dbfiJsN
dbqc0GAsDJcxcS3LCeoH2oYXvejdCb6MdPiVhxf9MgiN/S399wwvetGLXnST
/guhHVcZ
            "], {{0, 19}, {393, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{393, 19},
          PlotRange->{{0, 393}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{397, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6a079fd1-e3de-48bd-83eb-0ad4ac170702"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXL2PrMgRx3bi0JL/Av8DxE4JHSGd5YzkTj5OTp7RO0sWKRkhGRkRERER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              "], {{0, 19}, {393, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {393, 19}, 
            PlotRange -> {{0, 393}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b45cc9f3-c236-4e9f-b536-893c55653d57"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ecb6eb8f-9f2a-4470-b1fe-7f3c1d4b6fc5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"edf22fbf-174a-4232-ae64-851bef5d83d3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"eb27c071-1c88-4b18-bb86-c1895537cf5e"],

Cell["\<\
Make a community graph plot of the graph representation of the text structure \
of the first sentence of the Wikipedia article about language.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"d7f33544-454f-4756-b607-a81cfe5905ba"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f4de1410-f005-4c4b-aed5-500fc860b5ff"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvV9wG9ee54dMpqbykppUzcO+bB6S19QiedzsGx+Suplki1Wzldpkiy+7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            "], {{0, 304}, {
            582, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{582, 304},
          PlotRange->{{0, 582}, {0, 304}}]], "ExerciseOutput",
         ImageSize->{582, 304},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "50e6104a-19d4-4e9d-a3fd-c1905209b9f7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvV9wG9ee54dMpqbykppUzcO+bB6S19QiedzsGx+Suplki1Wzldpkiy+7
m+HOVOrOMrO7k2KefDl37jWuYV+3rw3DhmxCNuALm8a12zJEwVZLBiRQLQkQ
JIACKAiQmiRAiE0CBAGym81usvP7ndP4QwD8I4p/xfOpe2Wg+/QfgOjzPb9z
fn/+m3/z7/9i+I9sNtt/+C/gn7/41//vwN/+7b8e/Rf/Fbz53//mP/z1v/ub
v/y//pe/+Y9/+e/+8m//6b/5z2Hj//Cf2Wz/M7TH1yaDwWAwGAwGg8FgMBgM
BoPBYDAYDAaDwWAwGAwGg8FgMBgMBoPBYDAYDAaDwWAwGAwGg8FgMBgMBoPB
YDAYDAaDwWAwGAwGg8FgMBiMk6Ke4mx2rr5zY8Jht42JppoastncqXo94bDZ
HFVsnR3nJut9T8RgMBgMxqlST4CiudWdG6vZaDQlm2piwGbjElW9mhWiWd0E
iQNp49T+Z2IwGAwG4+So5ydHQKUQ+4g7qlIbzTY0NjqI2wZGoiXUq+zE6Ig/
21I0NT8xNDIh5yfs9NChDz8Ztg9DA0I14bYPcvKpfi4Gg8FgXCz0LOrWqD9f
ksSJMXjpz6v1lBvlbXg8m09wuHusZJoJzm53JFqKhnacjavr1ej4iM02LKRK
STc0HSMqpvPDcE7htD8bg8FgMC4SelUUiBGmqqUUGlyoVqhoAwk6k1iNgqQJ
MijawA5FSxFFw1lHXHTDtqVJaDkhmbSNO8vW1hgMBoNxoqR4hzVzSHBTtWp5
hqgpML0cYnU3RWu9gJfuAdvAeFYWwdYbLZ3mZ2IwGAzGhUPNjuOs4kRCrus7
1WpEoi3qIujdeFbdS9Ga8lfiR2z24dFB2wCXOMUPxWAwGIwLCJlgtPOSaprV
SQeumaFnPllHG3aLql7lR+1U3boVLdFUNHwxLBLvEXhDvElsvKTT829tbZ3m
x2MwGAzGxUEvcUPWfOPA8Ci8HBrPUkUbsOYiB3myIpayFA0nIYnqWaaZLvHE
U3IohZqmT47CkVy1eXrDMH744YfT+3gMBoPBuFio9Xpd1Xs26/VqvXdrP3RV
pw1lzm4bmsi3dmxvbwuCIEnS0dwog8FgMBjHT1XkbG1jjcFgMBiMk2azJtXr
DWN7m77d0jc39cMsfunVLO+fSJWYnjEYDAbjdFAkwQlw4Rp5Wwi7uFDhlO+J
wWAwGIyXhyoa53S6wihkElU0TY4EXE4idUKmgtuFQLjQoO190FKTfBznccFx
Tk8wrpBTXR7DrCMjbpEuqpVEP3V9tA85UtVdb4DBYDAYjCNBKYSdrkhFjoM2
xWStLKCigaXmDCQN0zQqac7pKihmIeThc0TRCiEXnzO1gsvJJSuGaRR9TleG
SNrMwouof5RkDtF1aYKEAAiSlMJUWnYHTfO43ZzeZDAYDAbjaFGksNMZ1kyz
HPM5nQEh6HKFMhGXMyxpZL8W4ZygZaBoIaJoGqgdKJqS87jCRMeUsMtDFQ3R
SY6RRDWFaR5HstV6tVqXU34qc7C/VqudysdkMBgMxmsPVTTUKlMTfTjP6BEK
hRDIWAa3NXJgi2UaZo53+UQ0swqCxxUiisaFyFGNHYrWDMFOuZtxbk1g46l8
QAaDwWBcEFDROMFSJK0YQEWTTK0cctHlNWdQxGiyhhRzNsEVN2KjEUVT+ipa
ghuw2d2gYRippsuiEM1XDxbcxmAwGAzGgVAinpY0Oe8kc3s01RRFMzo3GIpi
7NbYoqloNDzNMZlV9bpAatJEXy8TbXV1tVqtmmrePTJoJV0ZcmB6FT07Ojg8
7qf5n+2j46Ju1v2seByDwWAcPYrAOYPJsqI0ahXp/tWJIz69mhoCRUthzy5i
6TSrlignvFZpQ6amphwOx+pqZXIY/V+ErJRP8CBsA+5UM7nlIJ9ICe4RmuUy
xYrHMRgMxtGjpcNXHy5qzXfl4nzxOK+mrK0pWseG58+lq1eFmXID9j25fe3T
Tz91OgPl/Sy/s8Pa2tpnn302Pj6OBpqp50VBzOOLupzlaNEBFRVtjFqkTT8Z
VjyOwWAwXnu2t7c3NzdP+y4OyuLi4m9/+9ubN2+2tqh5YWSg7f0yyLXKExDN
as7BsuJxDAaDwTg7bGxsXL16dW5urmNb5buf//zXwftybd00Nx9c/vmvf5oz
N+fe+/nPf5pbx/0dr2up4M9//fvvPv75W9dfqwlYBoPBOD4kwePk+Ir1Tglz
zrCk7HnEvif0tl1JnK5Irtbtsc/og471DJh3J4PBYLwCVIBcIRJNRvxAQiR7
1eFPGHY5g8mG0mg0arlYwOn0FQ1QNG9B2//YC0U94bDZHLh+VhWHySTk//rG
f7S2MBgMBuPlQRuNxJGFCwq10VDRuvM0KhFvIKfQ9iRhY788jRTMXRxuTpQZ
Bc7J5RQFDUEPOaErCCagVrSi1XxiuRgPQRsOzuThcZec9rlcLnjvCuRqhmlU
YkF6h2DuVXrv//yiV7NCNKujvydH8qWoqmxtYTAYDMYhAAFyCVI5CcaUt2wo
EaJoPXka29OGVsLGfnkaKWQa0xcKh0IhlCJnIK6B6edy8mkZzhf3wYkrJPFI
QKo1FKUc8gVpSuOYF9Nn5Xg8RIHzxiNirlKMeJzeGJxew0ySHum0DT1VEoap
a4d9cFxEl42sf2RgcHiIbBwcnbACx6opxxCt6m01A/KCe9BuRaKlMDRtYmhk
Qs76rerf9pH7j3EL8RGp8g5qt9lG3AL1dNzaOkzVHgaDwbg4NMvBGKIXpCQc
dIGiLfXkaXwBimbZaGGiaLvlaaSzjj4hVyhkMplCmWZlREHMac29fM5KX4wY
khgCi8zlQRMO7cRGMewj1pwnmJGVZAAMOA/i9Xm9vnj5dCUNXRDtY7wkS/wY
aNhASjVJ7JhtjE9IKRJi5hBNU8Z46UFHQpKiJMhuQlJBv0gq5sl8XsTszEMT
Kwkwzbh6vUTajAiJ7MI9ssU0RQ5P7o9ms4LbhuFozNuRwWAw9qdd4AytLSeZ
fmz05GlshDhOlMFoa4AFFqKK1jdPY/+KaR0mHtnbVrQKWF6Yqx+kM+aBa9Yy
4WCE2Gw5XI/LFMG6C6bJ7ZVDgVDxlG20OgdSNeSIpqR6XZYkWTXNFKjP8CTd
LU1gvLicHQcZGk/ImHa5ngX9GuASJM0XR60tNS+M84mVlKVfZNaRg1PVrS11
t9026M/Tc6Z4aEstv3XeyaWZgw2DwWDsAhhNtNKZiWkaRVA0AVezuvM0Sujj
YYGW1G55GmnFtPCuikYvp5C5S7KrEsZVMhfg4ZwuEEsphlfFdTWXKDVMQ8YG
5E684QwNrf5DLA/9v5r1Dw6OcmNDdCJv4kRqqlVTfCul8pBjso6KZreNRule
NQsm1fCjpLsr6/KQO4HCNzLZuUbW1K+eF3p+2Mqj0oUhF4uN8xNdzmAwGGeH
7jyNhqYcj4mkded/NJSdW6BB56X//M//3J9X6ykiHMPuRFZ0kJRSx59Zo55P
JEqqXpfzgn+MFAioo1SNiXR3iR+BbQs4nWgTZJ2kXVazUcwTQlMxq6SZLk2O
jo7nkrsomlkFkRzmLe+a/CTHTaK9ZphqLBCE0UQxEuBQ/3FmVixiNpVcLGh5
2kRyhrnD8ebYvxIGg8FgHJaNxov//o/+iEtUiaINiDTZRlMUjhkJrCf72GRd
N6tZXBcbz9bJOtoAn62qcgIXyEYndTU7hEmHJ2RVLyVwBhLkqUpkzh2VdLU0
PoT6u5DoUTRriy6M4vEpWa1LwgCuuaGibW1v65pmbJtb8J9N+K+pyAX31bxW
jIB2YRChVgZhE4pa2/HmtB1pGAwG43ygr2anp5dVsAm24H+r85npp/Jmozg9
PY/9qF5/Op1dM8zNasbrfUgyYsDrGa/3mrxpLmeu8ellepoqfW0sX/N6M8ub
rWbkZbtldTYdvHTpr/7qr/7kT/4EpQEVDfr/MeozUT8hRTNLUbe9Peso4Dqa
e7AzrRWpU2pWUxOtrYNjPE3a2JGKeViQVLxne1PRdr4w1TzXPN4+4t8j8X5x
aV2Og465vE3vmVC83OF4w2AwGIz9KYtepyfWNgJqSaeTS9caSb65Auf0lDY6
emnssdGqStTNBDdgdyTINnV8EPYnOlIatpsBtKVKfC3GJhIyWEfNljvPfEKK
Ru+5DqjWG7jDAS5Fk37sbKajZ4iqdx0K2w4YcUYus39brRxzOnniVKolQ0Gx
rDBFYzAYjKMCF9ysZTCjU2ta84S4qGQbAX0qieM7E/ZWO5uZTUUjW+y8BJJR
ncQ1M5s7Vd955pNUtB08+t0/+kdvx0/jyi0202Fv03tGqBhmh+MNg8FgMI6G
GSHQY6MNplRTL0WbHoMDQ3aqaFgozU0c/FrNTOIbj9acXuJaBwyPwsshXMHa
aaPZT0fRjoPt7e3aolytFlOZBTI0MOIBj1BQKrmYlT/FF+nKn2Joyv71VRkM
BoOxO9D37rHXMLTd9+OknPoyKZ9wFu6lDjjz1Kdd/+U/de0mxHNKJcBxD0C6
Go84zlfSSl6Ou1NC58ZHX3Oen2ZP9F4ZDAbjtWZjY+PevXukluUONjc3Hz16
5PP5Pvvss9lZ1vEyGAwG40yztbUVj8d31v/qZmFh4caNG1euXInFYul0+tmz
Z+VyeWVlBSfIjH2myOD8tVrt+fPnIJpwniO9930oiX7qaWgnCRhNNTtqt434
U2SfMGSz/+6WbG6dm8KjDAaDwdiD7e1tUKgnT54csD1YbaBNoih+9913ly9f
fu+99/7hH/7h7//+751OJ7z+6KOPPv3008sErxf90N99991f/vKXH3/88c2b
N0HXjvWzdKFLNAGjIEkpdKG3O2RMR4yBaLBp3Arl1hVJcNJczYRCR+qVw0FO
2CZAYqWtvNAMBoPBODYKhcLDhw/3XkTbFzDTGo3G0tISmGCzs7NgwcFpQfiK
xSLYca948kND4stGslV0s5dTfpJnWDfNajPsbDCK4WGGJUBcmMptv2yWLwcJ
i+bLpLCcnMOkH7GyBooWKrBMjgwGg3FclMvlu3fv6q9pxeWUu5W40YLGFKgk
6Yd9VKDNqKKh2yExzSRL0bSMYCXA9AmYhdIqJ0fa+7ClEvO5XFapOL6zWrhS
CDs5oTkVq4G8YZLLsMfJkSp0NMulJvmss8dXi3Evx9HCcpgLS5MFn4e0dUUK
td7UWAwGg8HoAqynWCymKK+t4UATMIKGoWLrsihE81V4JXMDVg6PCUyTvIgC
5IpUsGqbMyZrZYHWFAAhCsqksBxPUjq3pg2bUc9YUzWYroDiiKQeXOu6RCJd
fAgh5XQCZY2YfnwazifHA85AmpSlc4rFCnz/yVCAFimQYl6OzymksFxRMRrF
pBArKD2psU7tC2UwGIwzCXSkIGcgaqd9I8dIVURbzDGZVfW6QHJRRatmClMx
DibqdR7rcI4tGwtkkjAMOlGOgdkUEIIuV6hQFDyt+t1YB4fP4bQhkS0NxAkV
rdGqNNe1RkZO6EsWCrlMJlco0xFDa9ZRw72hBhbxoWXpzJok+pqF5Txo/TWS
YWrAeSIZuTc11ol+iQwGg3G20XX97t27J+x2eBp0JmC0c4KkSzxmIKbJ8KtR
ELm3bs5RRSOCpIlESTAEuhAC3SEra40wlpir5XiXT8SFt4LgcYVyO0rFdSka
zjqGu0yptolHLqe0y9LJPlrWB6Qz4uWCmVpGCEZw/rOBdiJfLQpdqbGO+Utj
MBiMc8P29vajR4/y+fxp38hJQRIwqrvvR4nhBEsntGIAFQ0kT0nyHrp65QqK
ID0NKdZyXyQrbjsULdRlozXtrxatNtbl2mXpjEzIKiznwcJy4YZSCFh15WhJ
O60rNRaDwWAwKLlcLpVKnZb/4fnC6Cksd0z5qYyu6/SUtGOpsRgMBqOLYrF4
//7919W5kcFgMBgXhEqlMjU1pap7zMBddMB03djY2E/xt7d3mrjbe1q8sHNr
a8sky5ebm5vMOmYwGIxXZG1tLRaLra6unvaNnHUURXn//fcjkchRSc/6+joM
JMbHx9944w14fSTnZDAYjAsLmAZ37txZXFw87Rs5H4AZGw6HP/7445mZmZWV
lX0TV+4B6GM8Hr906dLly5fhr3CEN8lgMBjnCBAgsKoymQx9W6/XE4mELMsv
ex6wNZLJ5PPnz4/4/l53wJ66e/fuZ5999qtf/eqDDz748ssvf/jhh3v37j1+
/DifzxeLxXK5LBPgRalUkiTpyZMnjx49gsEDCOIXX3zx3nvvvfnmm19//XU2
m71165amseBoBoNx4YC+FDrSd9555/r163QJhpJOp999912O43766ae1tbUD
ng26U+hsj+dOLwTwJ3jx4sX09DSoUigU+uqrr8Dg8ng8H3744QcEl8sFBt34
+Ljf7//DH/5w7do1OhRZWlpqTV0WCgWw+E73gzAYDMYJA3L2xhtvXLlyZbd1
HDAHvv/+e4fDcfPmzX2H/aBlYNl1yiLjVDAMA2Su0WDp9xkMxkUBVOzzzz+f
mJjYtyX0jcFgEEy2PewvsBHu3LnDJrvOCDAUefjw4WnfBYPBYJwQy8vLTqfz
4CbVzMwMtL99+3bvrnq9DkbBwScnGccNDFfu3bsHf+LTvhEGg8E4CcCkCoVC
L3UIGGsff/zxN9980+mSt7GxMTU1xTrPs0a1Wr179y4LSWMwGBeBYDB4iIkp
0DK/3//999/T0GAw8eLx+Nzc3DHcIONVSaVSxWLxtO+CwWAwjp1PPvnkcEoE
w/4vvvjC4/GYxCWSudWdWdbX12OxGEtExmAwXnvefffdarW6Y5NemuC4qLR/
6ioQtTfeeMPn8z148IDNa51lcrnc06dPT/suGAwG43hZWFjodgtRE3abzZGo
7nLEDjY3N5eXl1dXV5minWXgz/R6Vw9nMBiMXVD9g7Yx8UCKxjgvzM3NpdPp
074LBoPB2AdFEpwdBCK5Q6QFVIrxsEj8B/T8OMfvoWfNlg3eyaXZqP+cAEa0
KIq1Wu20b4TBYDD2AosUO/lyQ2k0GnIOCx/Hyi8d41wIOZ2hwsu0NORiscFq
Qp4flpaW7t+/z+aHGQzGWUYphJ2c0NQWDeQtlGtIQiBcwAxIYMH5wgVTk0J+
/5Vvvg4EAlciMxsgSI15Ad7Chm+E+ZWFH2BH4Ou0vFFOCPdKWIIEXv1wr2Sa
67k7sPNraHjl9sz6ZrnZsp4WIqUNc3NVEr4J4Hm+/kFa3TShwddfd16IcXZ4
8OBBuVw+7btgMBiMXSGzji4+hPhcOO8IJloh5OFzRNEKoc9/eGZuscxUDMzr
MjU1xbJuMhiMMwuZdfQlC4VcJpMrlOnSFihaiCiaVgjPy4cq+1jPjnOTdfhv
wmGzOQ7qKaKmhmw2d6q+b8MUNzDAJQ5zY4xXIJvNskI/DAbjzEJmHcNdNliO
d/lELG1WuHHpcEsnagqEjFNNU69mhWj2oAG6amIADjuA83+CG7A7mKKdNBsb
G7dv34Z/T/tGGAwGow9oo3HhLq/DhhSjro/vvvuuqWdHB4cc3KjdBgw4+Cxp
oif8Y2SLzWYf8idQ/rL+Efvg0CBsHfz3/x3dNTQu5yeGRiaI0VXlHcN084hb
gC3Z8eHh8RS9ovW6rWh7nn/IHyWKludH7UNuS//U7Ih9wJ/d375jvApgo7Xq
ujIYDMY5wVAU4jBSTwwScZrMSqJ/FF7582pVBBPM5phMSFLKDTJl50BWUm5s
OMK53Z/9eHN8xGYbFlKllQQHGgUyI3IgVgP+aDYruKHZqFBKcHa7Q6QXs143
FW2f8/vFe0TRdImHLRMSmoBydAyumGfpmo6Zra2tqampep2NHBgMxjlka/3Z
w4eLa1QqtpZnHs7I6/rG+mpd3Yb3hr6+UoRNIH7K8tOHTyvUb2BLkWHjFuqi
/PAh7DXgwGdVa7ZKqVVq6/q6/HRm0Vqks15vrT+F1ut61/mTWXnTNPPf/N+2
gXGaYKs561jl7Da6oDYxZLONRU/6y7mQlMvlBw8enPZdMBgMxjlmy9j8Py7T
Oc/2Opo0ASacQ66jcTee3z+fJONIuH//vizLp30XDAaDYUH89rlkxYpFK4Rd
rvCBoqT3PGF3+pFWIMCRwKetGmptz5BqFLRsdAwtNNbDnhgrKyt37txhAdcM
BuOMYAkQF6a5jUDRuIPl/dj9hH3Sj2AgQOHI0l2Jz1fpiw5fR3VimDqhpI7q
KoyDMD09zaraMRiMMwJVNM7ppKaZZCmalhEC1MjyCRmjlTbExOA0nzeimErM
53J5MBjb6eKlDrHqn34k7HFyLo60FqWGqUk+6+zx1WLcyyFOp0cswi5Z8HlI
W1ekADKr5WJBq20z22RL0VId3vvUjWSyxJxCThRVVWOx2Obm5mnfCIPBYBAB
ckUqchyNKVkrC6houNEZRD8Po8I7neGCohRCLj5HDsh5uFDDVMKcM5iugOKI
XmfnjGL/9CMglHwazifHA85AGmQR9ojFiqIoyVAgQnJtSTEvx+eUHFwwUFSM
RjEpxApKMQJShoqplUHYhOKueUtS40M2u5v53p08hULhyZMnp30XDAaDQScJ
Mba6HAOzKSAEXa5QoSh4uLBEGxQFFygWKlqIKJpWIIrWCLs8OWKada2R7Zp+
hMw6arg31EBZtMLfapLoc3GcywMGnwfNwEYyTA04TyQjy3HQMZfXA3h9Xm8o
3i+joJqiEW4Oka2hnQK6roOZtr5+qKwyDAaDcXRQRSOCpIlESTwC2GiYHJ+s
rDXAFuMzNSUXcvri+L4gOLkwVbRMX0Xrl36knSKSXE6xDD1A9hEbEF4VI14u
mKllhGCkQC6E63HVIlh8PLkTLRkKiuV+i3F6Ncr7J0XpqL8bxkEplUqPHj06
7bs4c2xtbS0sLFy/ft3r9b7zzjs//PAD3W4YRiKRWFlZOd3bYzBeP0i2EMHS
Ca0YQEUDaVCSvIeuXrmCIs1WHGj5L7qg/Q5FC3XZaD3pR1ptrMuBormojBqZ
EFyIc7nASOOcsJFeCJfVnEEUKS0d9tKVPqdXqLDSM2eS7e3te/fuVSqV076R
MwTIFgjZb3/72xs3bhQKha4q7eVy2eFwwK5TvEMG40JhaIqi7ZAQTTmW9PtG
93XMrivjnShMzM40IGcgasyTn9KSsz2+kEaj8e6774ZCoZO8MQbjLFBPcTY7
x9weGGeZR48eFYvF076LM0EkEnG5XPs2A+ED1cvlcidwSwzG2aHezIt4wYER
bzKZ4jBwuwA2WyUX89DQA1+ETXidOuvr67FYTNcvegAF/EoDgUCtVjtI46dP
n16+fPm4b4nBOCzdueU7twyTYmE0jz3nplnlB9yCyI+RNMADI6Ks981yjzaa
pWh1wT3Sef6q6LbbBnkJUz/l+TGbfSR7VFmgNue/vBycr7+4dvkyn1zaXLp7
+XJMVaUvL19+XNmEAebTm35/bF6dj355k3hlqFLQH1031Zj/8vWn8DhvpvjL
N6X1zhMGL1/+/mYUuP49nOZyamlTnY9d9kcrhmnUHl++fL1mqnf9l79PlVS1
kY1ei8/j4aUk74dLqIX3338/XlaMhhQJixWtCHIWKzbQaSTgdAnMM+T0efLk
SaHwShH6FxBZlllpHsbZpDe3vOggW8RsNjqOrzixncc+kZggWmYfGU8k+CHM
Lp/om+W+pWgk8zycLZ9PTMDZBt0peCDINd2lkgAiOOzPHtmHwagxV4F49mNW
ESEI/6wWBScn0OU0Ax0RQ0sHduynYWhCOkc9+2vkLCQuoNDcy+WU9uE9jv1m
MRkmQd3OYCTTkOMYld307PeFkqzG9qmzubl5+/ZtRdk/Pwx04yvln+CX6zhA
IbzXlVbJWhb7wDiT1NFe8ufpmxQ/zt+7N0J0jW55EXvnZz/zr2hP34D/pNHk
MuZCP/vZ3z0lffGzb//ur796apK9X1kVvrTQX//sr799uv7s25/97Nt1s/7t
X//s775Kr2v1+vp6+tu/g33YbiX5dz8j/ObGUT4YRNGouJSpZ78L3RQ5J5cm
Eyo5kBc+c3DH/rZEdtCO3bYu1zq827HfqGWCwRierpEDXUvXJPIvub14iBf7
haoxTpzZ2dnp6end9oIxcvfu3Q8//JDjuO3t1YQgZKv9Zymh5UGU8XxRivrd
E4nWB866raQ3zKOGcRbR88NgSqU61rvUFFheo9HzOQpFifE00zFqInr2R+Bd
ORmy3Om5IGbzOLBjf6dEtlCI7LUvp7UO73HsNxuxAEc9+2lMQSUdbnr6ezMV
ZqKdCaBzFkWxdxWpXq+Hw+E333zzq6++ev78OW7S847BoYk8PC+yf3SwOTNP
5+rR3Hv33XdfvHhxwvd/aOr5yZEBqzztiDuqYvlZ/+DgKIcJtG3/7b/6f0xS
AZBmtikUCrbBEfjQ1EZjMM4kWKhrmLcWdPKTHMeH4Nf8fuLQoZT1qH/8LBZk
Jp79nRtOzLG/O6ag504Yp87i4mI8Hm+9XVtbm5ycBC2Df3cUCa1bpV0lHkaC
Q9F8ic7Vt+Yhwdb7zW9+s7CwcML3fxj0LEryqD9fksSJseZigZuItDuRFV3/
9r/ubF5XtShZUxhkisY4u+gC/EjtoylZrUsCPK1DEzOTI7Z/8be+w54vAadL
sHpfR0NzeEBqZF/k5ZsTIJFIgHmladrNmzcdDgdoWZ+lomaxcro6PD6ZkOt1
WZLqHdOQDx48eOONN87BMpNeFYVoCQ0ztZSasJPPRRRtQCQarqa4Wq3L/UMd
HyBL5wzGmUXNc9b0ic0+4sc8g/Xsd2//q555lbp/2N7y4qgm3PZBTu5tM2S9
S6BTY8oxRPwfbYPjIi7MqdmJwYGRsRHiWzI4Fk0J1D9ycGyCdNZ9ZnIuNO3h
QX2P5RvGkQC2WCgUevvtt4PB4Orqav9GTUUzdck93JywGxwTSzvGcN9+++07
77zTaBxZfb1jIsU77LY2blQ0zmYbo4vo8HpkJEJb6lvWqlnK3S4ewWCcWVR4
nus7OszeeRUyLqXlKXXcOSr0timJ4zjtLqTquoxPy6AjIUnRcfTen5Cacxoj
46nUpJWqlxejE5Z75G4zOS/9WVS1UCjMzc0ZRmuur3Gf//hfErw/ppWdWz6+
miSLYMUv3vrd1R+//k+47Rc/pnP3v36LvPTmVo199mrFL/7TL24VyYnJ6ztF
RSveeuutL65+/TvS7Hd3ZrF/K975wnsLQ3qNSu7yP/zbP/7jP7bZh/xE7nsW
NTqGB9XW8o0pCW6q+vYhR0LGP1nWPzJoDRNsA8McK4h9CBYXFz/55JNPP/0U
LKy92jUVrSqlUlLdVOVUdAI9fh1iV8MbN25cvnz5LLtPbJZjw8PD38dn66ph
bs6+PTwszK6pRWH4FwL9BeHrYUEzV9PB4E/zlsn58HPYP3uKt81gHI4+8yql
SSJM1nPtztb7tNFTA7YBMCvU7Dg0Hoc91Wq9nh3FKIBE55xGihuwDfqJiMpj
bcXsP5NzcIrFYiwWK5d3uBEeZYTCLnutobvZXmrpXJJw4CfD5fUEZydDXBlL
o4Hc5/M8uZNEtc+iRnt4sLLjnMNuIZ8Xx1D+cDhNvjfbiD+aivphEDF0hNEQ
FwBd169fv+5wOBKJBIyFbt++vVekVVPRRPwTjaSq8EPPj6GidZstoGUzMzOl
Uul4757BYByQPvMqdTfI1XhWxud5tNS3DT7yqFlWf97BkDtB5jRGJCJVHbUv
MYLAsd9Mzr5ompZKpaBf6vGg3idCgdiGY7KKmjVGnDz1LCovXQ207nO/vW1F
UzvVp70kQaPzaA1rXeLhI1r+pHppwu1PyXLvokZreNA6JxwOfwDre6mLpFkd
xwYjk3RbwmHvtRcYuzE/P/+73/3uq6++as0QPnv2LJvdfUhAPIHRN7iaGB1o
/rIHxlJshZPBOGtokhe93S2/x77zKiV+xGYfbnnw9mlDFA06YZIFyyZgRhEd
F9CigpivdiZ7THQoGkcUbd+ZnD1YXl6empp6/vx5n3me/SIUiDlpF2WqGtiM
ihF52bxP9SB7LUUbtBRtx5JEp6KRL8c6Q4veRY3W8KDtkNBRArt1oY5vckeN
bMYebG1tCQIWQ++KRDMMA35IO/wbK0lnTwQHhczV94y72mUaTgda5L1FoFlI
/SXPUhTC8YME1ynFeFgsmmaDd3Lp1y0aj3GOqSSD9Akokweg/7yKNflm44mh
1adNXcS+V8jWG1lUpdEJWdVLCZyBHOaljtRYfRRt35mcvkDXlMvlRFHcdTV/
lwgFh2gpmozung65Q5X21qw+e8lMo5uKZttGa8t3t6Kl2lYe+sOMjU0KH+Mc
4kRCruvtazWHBztstKEJazq2KbKdipZginYAqtXqxx9/7PP5+nokLiwsJJPJ
jg1axOX0Hrw2K1G0U+zaSUU/vtxQwPCUczEs9V5+6WgRUnDwQJ+CVCYswFhA
LhYbrNwE46zQgB8mn86FOWcgSXLo9p9X0SfJkpj1rk+bEvWcBL2opiaaTpS2
wTG+ujMhf59Zx5efyYFn9t69e9lstsMJpJf+EQqwBVfsSiL6Ww5NqD2aJe6p
aDv2EjNwwDFZVauTuGbWstH6K5rVHr4TXc3y6Bjz/W04p53kurTOgPrYHh5Y
V5ejqPruqKSqMo8LaUNZ1WSK9lKAUeZwOOBns1sDMPPv37+/tLTU2tLI8c0i
s+a8eHWugmORTWX1RbFYKhbLMmZH21zOUJvIF7vvAaPOhVH0PiFDf5d7/j6P
GFLBVmheT8MS7LmGJATCBVrvT/CFC6Ym+TjOQ27SEyS2mFGJBFw0i3Yk9yLm
pZ9F6j7QbCRDPpokwMPHG3AebMjFitVYIFhQTK2SsU7D+TCHQO+FGIzjRytG
4PcLw9BaMgBPQGvk2jOvIoO9MzSR7zy2d+5FVVteHTp6hqgv4eTRfyanB+h2
5ubmpqamZPkAg+d+EQqOttw6MFUymYqkdhbRrMHUjpWyPffSlMvWeiF6HULL
bhuNvG61B7lvqfcYnzX1EjfUFPPhUXg5NJ5tDw8it63lG1ONuodbqu8nCpti
s44HA8z5a9eucRy3bwT0ysoKWP3QvrlBhqcCrTSjmUPG6E46TSyjgFQD0wjb
pLHUawWFEJPUYL76Y/5wiFJOhr/6isw6uvgQ4nORWRetoyY7zeFGUpImMd12
0ed0ZRRTElxOX1zDWcSYxxerEhutYXYfqMnJQCBGFc5LDiyEOA6zpNLMOQ0y
JMYnrJLmsZBuz4UYjBMgHcRBlMvlcZG8uvCAqsvzXW2qIke77NRp+4dvbGw8
fPgwmUy+VALw3giFA6rnQdFVUO+XOgDkvlPt8X561F/t2aKr9Wr9cK6gFxdF
Ubxe7+eff37A30w6nYYhU+ttUXBxYamSDkB/beIUW3fS6dVWtk8l52qWRC8K
Hk8EgzXC4bCmHXOiGKUAIht+NE+01Zcs0OzaZXonrfRuWiGM99meGlVoDjdU
rszOwu5k1rH7QLMmhsDq4uCDwxcA4i6FXRzOOhJFW5U8rTyohoR5vKvdF2Iw
jh0F8+jGZfghwsDSyIU4p1dsSD/+9FNmE/Ya68Vns2uGuZq78YX3y2Sh+Ax4
vrRJDl1fmn0uHzI9grZpjYHn5+dV9aDKAkZZLBaD3uYsB/swzhSbm5ulUgks
r4P/ZgzDWF1dbZtpxvpCsVQqllY1smVbXSgW18ioQmtUluuaoVYWlkl/bSjl
4qKKrfRKsVhRcf6v0Wjsvs57NFTQVoxsWrOO4S75zPEuH1kKLAgeLDwBioZV
J8ymbYWS7QykTUusg/NNG63rwErc5+QE/JzoSOZK19BGc3baaE4nn8EMmY0c
vqz1XIjBOG7KotfpibUfgVrSicnqG0neZSX4Jel/YbQWm1eoJxXOtpNqKc0R
mpYRrOy/dO2gOeuOYzufN6KYSsyHJiBJDsyTmRhzraloT548+eijj/btbXRd
n5mZuXv37tnPxsBgnDA4+xdG9yc0r7hup46GFGsn54YHs+2Q2TSdDDnssRqE
MxUQJFxJ88aqOw80KmkrGbfLw5EVukZOICtuT+l5tHLSY/UaLrHY6HMhBuP0
2DJ0w5KdrRczD8sNXV+dezhdUhX54cOHZQXst+nU7CpufFhQoOWW+vzhw7lV
aDY7/ZwkM9drmdTspqnPpR4WcEndgPM8r212XQikanFxcY87gSGuKIqgfSe5
yL4vYFqm02me5z/44INLly599913t27devDgAWx89OjR/fv3f/zxx/Hx8U8+
+QS2nPbNvv6Q4RZZtSEUwi467roIFCMeZ3Dv39iWrm/t2cA09NbzvseB8Hbv
ZxAa7HclBuOiArabJElTU1Od7mdnDbhJuL3Hjx+Dol29evXbb78Fmfvhhx/u
3btXKpXYBOnJYIVicWFaGKZgTSB0Igexhl3bxs8EwfTYo5j4rnNl/cK+TnVi
rZbGFfBcpXePoSmNhnKGBoIMxtEhCR4nxzd/90qYs9yxXuGE3o4n2xXJ1Y58
zvz58+fHvrDOOP/sOyWezC+iLeONW927IXlgY2WPzh5+yd5cv59ev7CvKjQu
nN7vtFaI0YLp33zzTXKmuIFmkpYMeVrPpigdaLq+GTR9JBjzj1mObcYxQgXI
FcqQd4rAOUOFV1qWgn7DGUySJ7uWi0HX4SsajdN9tBkXE3SKcEUqchz1RdbK
AioabnQGZXR6qmRv3zYbGa6ZA6SWDtAV5Eou5qFS6ItUMJjFWjzyiTgApNFl
nE/olL5+YV9LOFq0FouxtmzHecrFeIhzcjSOC3fJaZ8Lzgv3EsjVDLi3WNDT
DAfrY2cdHE1p1+PTUOJ9BYx8NiSMMQt2lzXtRzNomsE4B5BHFBduw1jsGW00
VDRNJvGVOMIVMhXSbL+QzCY4t9OatzEK8NjmFOUsPNqMiwb1OQeFKsd8TmdA
CLpcoUJR8LR+n6uFu/AbjftoDhANh3O5xl7BZZoiuJx8Gp390kHc1b7W/K0P
P/Reu44EvR9++OG3i5pyy/vhtewyXOJR8MNv01Vl/ifYPr+6piiL14MhaQ2P
u/flh9cKa4VrsOeRYhoLj+4kCtWFKd/bl2PwWGkoxx7piEaD5IN4czJN5qHk
0hl4wrrku/vRbgdNKz1CH+E4Gjvu5IkRV8tFrKjsQKTPmRmM4weXywWpjJHU
3rKhRIiiwUZnIEmGsWmQFurZuHdIZgsyjekLhUOhEEqRMxDXzFY/gL1HIFlp
dxFKOeQLUqmEMSNcAvMxBEAijWI8IuYqZFLo6B9txpml36z1IaGKRmYcNJH0
yx6hQBI6hchJG0+nbuO+ogADtxr69AYreweXmY0w56GzjniUJ9bt0nR0bGxo
U1NTeAdeX/zl81btglEQeY4OVT2BpFTrle/eR9sKmu4VerR2ccFCK8MANdTQ
JBcGnmNYdsznicwVus/MYBw/zeVyQ4SOJBAOukDRlmCkFbbEQwONA6HZNySz
Bc46+oRcoZDJZApl2h3hOhrtB3Avn1PaXYQhiSGwyFweNOHQTmwUwyS1AQwQ
M7KSDIAB57E6l6N8tBlnlH6z1oc8FXFcF6zfplYMoKJBv6okeWst6e5jGjRd
C7mcYGv4YqTqEMYCO9Pkl1uOh3ix3PFzhV87FyELzRmec11/1rqWpsDw7Bi8
LYxKKBAqHtGvviFLZSrwSkNKgx5xjwrd8q31PNp0/bG/0IfI16KRKDOMJQ+1
Vix627NHl3ECtB3AcEhGwk/ARguBjJGVtUYOBmyZxv4hmX1O2Kbdhu5tdxEV
sLzQBoSnIubBYMxMOBghNlsOe7YMRnpSJ2SjfISPNuPM0mfWepVOfIG4xZVK
LmjlCSST0poUwCkynPryhtLw62glEvR/eW2Pqxhae3XJpPHIJMrSeou9PUlW
6PRmKppCZijIHpxtaMZX8Usk3YhSTrasSo7Mth1hvv1UKuUNZ45KKfFpcvJl
orxGLeNCN5hnXfLd+2hbQdN7CD09hNhoSWxgxANcIPGw+8wMxvHTKD15UrKS
NW1t1EulUk01zC2tWoaXC/D/ZZIYSldxF6W8opqG8qK8QlyWjJXyi/WOR05d
KS+sdGX80FttYC8cbqjVFxXafWyuvIDrlIEXC6VyVYEL4VUX4J8y5oDaIg3I
nSyurLOolteePrPWOA/mFIsVRVEw730M9U4GDeIiZBfNmlgj/gtL7USC01fW
118iK1o3RPN229cuukeSTXkjOANhNIpBELUQCVjmjkbR+oWD7c/u4SGNON/y
dXTyIn6TXfLdGwTdDJou7ir0zUOsBjjBEoa/SfeZGQwG44LRZ9aaCASREAwf
a05C40xWebUza6LLdXWqM5HgN7+f0LePdxBEk021OmtNzojpYkvRuryeejLn
aOkwmJhoYAYiBaPHx7ILwzA2NjZwNrZWW1paWlhYmJubKxQKT548efz48cOH
D+Px+J07d27duqWqK5G2cDktJ6v2iYj/445T7yHfXTexX8uuBgc/M4NxKI5w
5f0UIVNGLDXca0ifWev2PBjWJgumiUdeOR7g4xrmIPWS2cKGZaPtTCQ4n7kh
JDDJ9nrx7hdf3FrfmPvuq6l1cx3eTM2tmxtzhdw+iff3udtmsqmeGw43jG6v
p+5pOgUrzsTLitGQImGxovU4aewklUpNTU3dv38fxGt6enpmZgbkbHZ2FqQN
BG5lZWVtbU1VVZJ8EsNwgsmyooD+ybga6RWPz4mFwThFelfe9W1cHeD4dDNq
peByel4tfEzpM0Q86mK+C8YaC3N7/UA/hHCPojV/OTSRIM0uivkGtYKnObHl
4jGKpCeRYCHQbBAUpdapcmRcFytk4O26aa5ID69du/Yj/j++rIGp9SiSfIHX
015Ebkyr5lbpUQT23bhxIxL58RpsIdu13mRTNSmZadlo3V5PStuVokA1upgM
0yCZYCTT6OdKUS6X06VDPDQ0VULrgSZ5hrXCk5nSYf4kR0T28WP4fPhHYTCO
jt6Vd317nQpQiAxuiaL1rzt/YPoMEakP1RHqT2GvMLfCjkKEpimnBRdHo9wi
NewYdzoYMM4TRnvSrOmYp2lGV4PO9zvdQHY76z7zY0bfk3QmmzJqGLXsi1sm
WI/Xk5IL4V6wHwsC5uaqZYJBUlwM/a+c6Vq36wW8OOycKRmj+oK4GsmjW02g
6fJBCmOomSgWsl7KRIWHJbjE6vN7P6UW9coTQUisbmGVgEQ0UVEWo0J0EfR9
aTqaIklWtcXYT9MbW6vT9x4SrxitIAqpxQ3Y3tlSW8oIwsM6pnVdSwlCZgk2
RH7/E06rlkUfZ/nYMBhHQ+/K+7a5jj5QOJ2PFY5aitZTf5ZO/ptognkD0KAY
CXAk53bP0Kv/EBFLKJGATFdQxAFqzHJhE6XnIa+L6A9HVqsPtL6wR5jbaqmr
ECFOSQXiRSy5Kwi5Wo+DwQl+/4yj5KgN/0PQSjaFtqAvIrd9HSvhjsT0xEO4
EGhPXAiK2YgFODruok/E0blS4KPhFayqaOUafWr7FEELWUGmGJLTEaRA0ArC
pLCimxslcadp2RNx0+wx6Bk6Y9jRu5LPdV3oFT7XYagnHDabo3rCV2WcFP3i
xdZAgASJujCLmlEkv8+e+rO9br04gZnuN/TqN0Rsu6XJoCLJGr0TsaYopWQo
GMGJJgVrZx98fWFt9zC37kKEjWKyGeUWKWs9DgZM0hivRmeyqa7tRveWXqeM
LreNV/85kuQ/XQlacc0xgM8z+meiAHUXpC4KNMacPqGlVSsT+Pb29sT1J2bT
tOy1PeHMJDWQdZ7OGPYwhgHVuvMznCCGYejVrBDN7pZLkqUNP+/0ixdbI8mv
cNrehxXNQB48uQPUn9196LXPEFFoR23jBgN+8l466OPI2HX/9QXrtncJc+sp
RFgRAjx5BmvwSYOZareDwTF914wzwBZh344LGkDv97r0b30TtDZiPq5pIlol
DpvPL/XDNzLNPMbecGbbbH8V5efPO0zLHtvTrJFlSV/hCT1PO4ad2p49Fzoh
VlZWfvzxRzU/MTQyUTdNVRKGB2yIfXBctJYUi8WjSsLMOB36rLxbikZSgpRj
zR98n/qze4/xOk7Yf4jYNPGs7JGtw5M+Kzu6hjYaXznA+oJ1201Fk0jpq9bz
0luIUIo1HQTIilu3gwHjteaLL76IxWJ7NKhUKtCgXq9TVxM+bf0kaP7hV1pS
3tbXG23WFEyBv62ra+rpJKA3tH0swG6bsUnXcb225wHPc2Ksrq7C053L5eoJ
zmbj6mbdPWCzj/GSLPFjIGwDKRI1Oz09PT8/f4r3yTgGcEQXbmZMKIroyVHo
rT+7/xhvxwm7h4gdkZsCqVnTOrySDuE1XLSqtSfXOJL1BaN79qZ7Psfojsph
vKbAWP3NN9+sVvuvpcB2S85M03KedLoy9JdKMkO+kqLRNImkzExNzuGjFSuT
nz7LZn+MwN/0jTfeuHnzJryupyxF4+w225AjmpLqdVmSZJoGYnl5+dtvvz3V
m2WcJN1uY/uO8Q57Ha1rRHc86wuMC8rU1NQnn3zSO6lI5QzG89Z7omhkLIWm
mdZUtEpGsGpR0CIyB/eSIsvHTScpK6MULa5Ns9ZjTAGm9qVjxUC5UTyEl9SR
UC6X19bWDt4evjqQg73bGIYBQwX4enX95GxSuOI777wjCIL11lI0s5rih2wW
Q45Jmilpc3PzN7/5zYndG4PBYBwJn3/+OR20t+iWM7MZjFkrUmNKKwuoaDjf
7oxjVnkjzXM4aX9wLykikT4+hL7FxDlJLGtkMjMkY62kOHHGwFkLnyjB6FE+
pJfUERAMBh89enTw9m63+/nz5wdpKcsyjCiy2ewJFOoFDb106VI0Gm1tadlo
+USipOp1OS/4x0DUuISV/e/tt9+u1c5loomNjQ34DcNQZHZ29unTp/ANp9Np
+CNmMpmlpSX4UI1GA35UJzmceD1QKsX55a65Gb1SXFjDoenWSnFOXsOMBVsb
9cWl+paxXpyj2VL15bm5ZUWrzM0treF3rq/jy+2+mYu26g9/+ml2RYVfLLxb
0NRUKJQoYniNWsaX61r5ZjhJZhLU1PWbLKcxowt4uqHvmpmZoW9XVlZAzrq7
MmJSESepGFhCYSEI/6yScjOWkxQ6BGKe+YN6SZGklEI6R5ykCjVyFhJqXWju
5dCv2OWhEaCH9ZI6Aq5du7b3amMnYAc5HI6DO9JsbW0VCgU4//z8/LG63/z4
449+v79zS3MdTRq22exjk3XdrGYnQNHGs5aieb3eZ8+e9TvZ2QK+w0qlAsqV
SCRAsq8Rbty4Aa9hwAA2aSAQmJiYgBf6Snqcs4xQxiHo523STlH10nkezG29
JI4N2cn0wOB4VDLV7Ig1W2AfT+Ef6knvMl9PhlUGo4tisfjWW28tLy+DkPWR
M3NHeoEyrakGskK806lvEpaE4DP7esJ3nbArs027jXW59sNyWC+pI+Du3bvf
f/9955ZS1D++ixl4//79b7755mUvAfYCWBBwLAwnDnmXezI3Nwd/MVXdkSkd
bTQ7zjqWom57e9ZRaDW6devWAY3N84KacoCIq7vsfV0ceo+Ldh7yvXiZPA+6
hPo16Ejk85McDKxs/qycj46jnAmJUlXvfxSDcQCgR33vvfcikUj/TpXOOjZr
qqGTlAfXy8rJkDV64oLEh/fAXlL9MvC021gZ59qKdjxeUgcCrKcPP/ywc0uK
G7CNiX0bg5H45MmTw11oaWnpzp07mUzmaCchDcP45JNPuuSsBxWsy/reTU4c
+J7tjsSOTWpiwGZzJKotOU447PRvIScm3Hx+j7Op+QlLuIfG65hSwz1IjYEh
R0Jm04/7UC6X7927R5KjHpj98jzUU274+kXLZlZhXGXnEqaeGrANJM7YT5Fx
7gC7DIyLS5cubW6+ZO7eHt+k18xLCp5ikEmQm9aWkjA20E/RwBTiOO7lnvqe
a4FZdLSTkDBKmZ2dPZJTnTAJUDQutXNbPSEI2arenDI1q9loNCVDf8iRJcC9
TqdXo+NgEwwLqdIK9qW2YbeQz4sYsmAbo2F40G8f26c5xxQKhbt37+5mo8EP
FYbB+XwenpGX+vGTldyhbFO8RIcdBzA4aBloypy5sPBKKdMZFxM62Qg/S57n
L1++TNdkGS1u3br10Ucftd6K41y01D2IBCPol7/85cOHD1/9cnCqVCoFQ+JX
n4RcXV198803lx4EnJ2V6RppsHPLu49c9FXpxLNy6Qn/mGVD2Yf8CZy6ToEV
NTBMo7+HxiZwk553DA5N5OstR83sxOiIP5v1D9NDh9/3DdkGJ0vU5tKFscGh
8bYmqsSyU4lW2gbGrT9hXbQ3/WFajqAMCijU9PR0Mpnc14sG+pBgMPj222+D
9h1Q18iwpGWOqeMDNrtD7FI0OOcr3D7jIgKdHsgZjUqD4daXX34Jura7gaAv
5rMtcs8X1jt+6fraQja7gBkc5efZrPRiLpcrNdZf5J8sWN7v6y9y2WK9UcqX
6tifGo2FXBF+u5sLuXydnAd2FcmuM1XEFiTe5XK98cYbGxv9i6XC6BT2dnoS
vjpwTlEUHz9+/CqTkGB337hxw9Qkj9MpytZABSsjBJJ7HHXygYFV0QF65JhM
SFLKja4qXBUVDaMKRifEbGJiEPo+MMHqOOvI0VlHomgJDgf2aknEFZkhd1ae
gxMNuImKqalB0rh1ldZRO+Yz1USrmdfrZatpLTY3NxOJBDzmB7e8SqWS3+9/
5513oEvZ/3dbx29+YIyXdTUvoNU8KpS6FC0cDr/CJ2BcODrljAK99+eff/71
11/v8mi360fUKhLmffLEWj9cGnlNS7ZR/xGPUOjNZ5jjXT4RR9wFwUOyRbXX
y1qeJGetW4Fv4+rVqw6H48qVK0+ePFleXi6Xy8+ePQPRgUf4rbfeghdHflE6
CXn79u25ublD9LSLi4twY3QaOcdzHM2rbFaCTmekrJlGJRa0YvgipEpCK0f6
rQc/kMBAXKkUTiR3UDWfmBQwyaRaryYmRugaGa5XDk/SBnk/qBtXVXsVjWoT
jvCpkJGWY/DzqgqjNttIpwdPe/UNzjw0YY3FrHNiH/rFF1/slnDgorG+vn7n
zp3DuQbBowEdyK9//evvvvsONG6PlnLCP9D0Shp2R/EvslPR0un0HoczGJ3U
6/UuOaPouv7JJ594PJ5+YzOaq605o07cHTMNrEN0+/sgKlorO5aGwWse9Ans
zmfYkGLtXPvowbhD0agniWEaMR/1A0HfX3Q72b0HFk8qpzYMAKampr766iv4
fj766KPLly9///338NAda0CZqqpwibt3775sZxsIBNo6iyF+PrkZHd+glpo3
hq5oMuzySFo7R/pqMzDQrCTprmNHL/lHB20tBtxE0ey2UcvsVbNulLBdFQ1z
eQ3QdbSqACfgS1V+mMxidUCmuYbFkipHMfLOHZVUVSa5v6zVnFAolM/v5V5y
QaARqTAiepWTrK2tRaPR99577/333//pp586V6J3oter9b7Z7+Bx28+jicGw
oHJWqew6Av/hhx9yuVyPaaDPJhPPa60+Tp9LJgorajGVmF1e3+NyW4auG536
uKXre01lbJlbcKGny/B7NsqZRFreKN2+vFsPfBGCLOEvBfI0PT19wGccxsmg
9R3LH1joPCzV0gGsMAXvkwGuVWnD6/XFy1orRzoJo6CzjprgckaOP4o15UZZ
mUxJdZ2UubF3qhUiTQzvaaNRRaNLZqp/0DYwgkLlz+/4rnSJp4tyKVWNuodb
8ulvzkzevHnzSFZCzzULCwv9Q3gOy/z8/OTk5DvvvMNxHLyYmZnZbfa+E8Mw
5ubmjuoeGK83+8pZa37m7LCxtvrBx5/37YEvCDC6kCQJjDUYPO+7tHHnzh0Y
kHRuUecfXLkSvnLlVoUcWkmHr4ikx9haeRB7UNHNFw+E+wsoAdqLh1d+mtHI
MVevhF8cv287TgPaxiTd1OXEKDqIjOR14hlis09kq3SZzD4WNdXE//fP//md
krLxQvzFL0ToFhfEyx/eXgARjn/4i19cS61gxmtz7VnkF8CHYr/kZbraVHld
BeOg3vnh4Ou94EUH9nZrfEVevHhx69atzz777Fe/+hUYbt988829e/dg6AW2
2Pr6Oth0Kysr8P2nUqlwOMy8HBkHpNFogJztnXuw5R19prg7g6tvYLSFAiGw
G1qLbheK19J1oZ7l2+spYyhfkyU95e6Yhxxyg96ZxrnMynUugDHS48ePD+LW
eCTXAsF68ODBtWvXfv/738MoFQTugw8++PTTT3meT6fTBzHiGAzzYHJmdniF
mWrePWJ1LANDDsyQpGdHB4fH/Q7ia20fHRfpA5CasLaMubmhwdGsambHh4eb
vtOt1/X85IjVedlH3FF1l2OhoeC2MuKMuAWqrYtSnsZze8MZo2PRjfFaoPZf
TyGb6UuSy7pNIJI70jgThXdyacVUivGwCJZag769CGialkgkMpnMq0RTMhgn
DNj1IGe7L9G2aSqaPomrDcNCVson+EHqF018bm22QT6RoqLDS3o1QZxv/SJt
BnvFOvWstpbmrdd6dpC0y5ckcQJX5/15te+xZHw+ANvyiQkQwEG3pYzaha51
hFXmwx3lqDJBpyu8V1rm3czYvtJw9m1e4kzLkxpEDTmH/kWxo3QKMuRisWGY
xDm30Hr72kPdGiXpKPN7MxjHDbXODiJnZoei5UVBzFfRH0nOcoPEnYzE74xF
yWK6jiE/jkQVHa0H/XR8XcfYooFEfcfKvvVar4oCiU5W1VJqgkS29j22ytlt
A45oXa1W6/UoNCABSgzioBi3etmt6uLCgqLvNQmpgX2j9Rl1b2mNpaXVTWPL
MAx9Yx1+FeubW7s1PlGM2uMHD54tW0aZXpt98HC+ZbfRUrNNkdHCWLZ4qV1y
SOvyhlWouyzHOTlvGKVPkyMBq/wRiUroqkmkxALBwqpEPGi5WLGKbxVTq2Tw
IAxl8GGCNU3ycZyHFD3yBOPn3Yajbo0vXrw47RthMF4CsM6mpqZkWT5g+9as
o5oXRlorHGArcYnO+J3ma+Ip3cxBRNK1dStaK6Y1xTvs7fPZ3H2PXRA7VlDo
hd1nbVHvdGhkuJ35MA0NDJaj71afLCrYdVMTzhdfLca9HGLVudNkwechUuCK
FGogDblY0Gr7ijOBe9aWJaali9QgCpEaRKBi7ZJDPfEIGGlCC69nSLUjrG0U
SBokSzx8jYXqzppERrMEUojG7tG3GEQZSOKDU0nzTi6s0GK1FcM0ij64z/Ms
aQsLC9AtnNOaQYwLy/r6+kvJmdlWNGkUl7v8+RJYSOrEEJGepophu+brzpBV
K7nNDkVTxwfxWDU7jkn0JhJyXd/z2NKYzTY8gZFBsL1eSkXFPEsmSzDiPqf/
/hLGoGvlsLeZF5oL5GpGZ2TfKzK/uEYr/ojFCohFMgRGDGqMFPNyfE7J8aAm
RZCCYlKIFUjROp9E6oWAsAmv4u2/e23Zu7dvE4HzJQu0BlGZfNB2yaGeeIRq
mPPkyL1gtSMufB3jF+i9aREQu1yjsyaR0vz2sGZKqBkmuSp5WkUiDAmLHFW7
SyadU47VrZHBOCZe1jqjWIqm54dBWfy4hiVF3TtttB2KVk+hVDn4RCkvDLfX
0WDnCKhXSRynx9Js27ykmmZ10oF2mDtV73ss5nuwDUelulrN4stWFr4Lj1YU
LnmnsEo4dP3eCNYZMBpxtJDCjaNTtGp1DavdcZZ9VJNEHy1P53J6SFB8MkwN
OE8kI8t4eVezPJ03FH+FfL+715Ytrelk1jG8Uy/bH7koYHlZfGV5w4LiOAUi
xDk0uwpYKp3PkIPghNz0ws6aRI22jebstNGcmOiGtMKXtZ6ytueOra0tSZJO
xq2RwThCDmGdUdr5gvytEnxDI0N2TOagpoaIEmG7jtf5SYfVDkv4jUmYByI6
1AxihW2ohnqJa20aHh3Cyh7Zvseaar7V0jYwIrJ6H21qN32XSA4Qbzubh1aO
i+lac95M6Z4kLPi8EWpWRLwBsGjktOAiaa5cgUgNZ+FyQWupiNp6oGjrSrvr
ln3okYInKEa8XDBTywi0pHijgJ18Feu98mTqSkuGgmL5FXr5ntqy/i9FZSV7
/eYM3JZWyVy/mdmpaBuZ6G3LPWSrnrl9/fr1m/D/O5nylqnNkLf4PvpoVccU
zNNRq0HyeQWOLcRv0gbR5PON5qk2Fmegwb2CTN/qq/PNs0afr2yY2uLtaIY4
l2vQYOG8+SlRt8aXytbIYJwFqJy9+ppvbyBqL3l+bLhZLFLihzti2fR6tdrl
ko21uDo27X4stqyetapdZ4CVx99jtsxWwrE2VNG0rklCs9usaISczkAcHdST
gpCrKREXGEQ4jpCTAScXgU66ukIUzapvZWRCOBeI5emwhni4oRQCzXJ0QVEi
LhZeq1KeV6i8ykLa9uZKdYX6p+jqKotLOlrW1tZEUWRujYxzB5WzV8zMdnB0
iad21wipsT4ykT2ZYy8stJZ3x4p+LZ3MNJo2WvckodK99NMoJolnhdMTjJQ1
DApoLkD5vL5QX494Q+kqT2f2KU/H6gyfYY4kWyODcfJAz3Lnzp0T9shVS9nJ
Cb9/gk/kX9rR/lWOvajUeEwETR0LDbDFwOqSLROse5LQxHWoAE49KwUPukpW
hABP9tfCnDOYqUZwAQp9ArVyPMDHX30ibXNzM5VKZbNZ6ulBHQ7Npvv9Ky09
aQVvRySdKxCpnIdIulPnyLM1MhgnA8gZWGcnWY13a2srk8ncuHFjlwW7ync/
//mvg/fl2jp0dQ8u//zXP/VJQPrw4cNC4URrcp17GoWgy9nydcRQKUvReiYJ
zUYzaAvNMtAyKdacNXQFJQW92T3WpKEzTMrHvHQp853out5oNDBx6J7e+IeB
Os+TKOuanKMOJKSe2zl00TgpmFsj45xy8nLWAp6a3/72t1euXOlODt/XYXIn
y8vLv/nNb9iiySEwdsmi0jtJCC21rvc7NhidJzqy3m93b3wr1NmH626KJPjC
BdqeOLEo3bWEOk7ocrqk5kejfolYqI9Ex0FrUWqQ2Gor7FqafelIuur6ZjEO
56UH4dU1OQ23Qz1p0HOmp7DRmeXgRagZjLMGSMmdO3dORc4oIEmgaG+99VY6
ne5MqNvHYXLngV6v9zgqZjJOn9298eMyBh6kSewzqV9DKgVYTiwYHE0mQjXR
69wxo0gk0keirINkLVAsa4Wwi+PToEdyPOAMpGldWhJ2vXqISLqtrc2QL0gO
UmLk6uSgONiyxXhEzFV6S8udTVpuja9ldmvG6w2Vs7NQgqFUKn1E6CyAu4fD
5KVLly5fvsx8iV9Perzx4Z9VjHcWrKhl9PwPLYGi0RLbIFioaO246e41MhL3
LaRzNMqaVuprzToSG3DH4YeKpNuWxFDzILIi2SiGm540GVnpLS13gl/oQWHZ
GhnnFypnexdAP2Gmp6d/97vfgVrl8/ndhoi6rr/33nu//vWvX3HV5jWA5Hci
uZUIYHS4wq+0qqiWxPEOrt6XDHP99u8n8iccDEEUjYpLWSRS4hIUUvo8TZwU
cmGXk88ouZDTFzdxbRCTezR2ljXvUbRmEo8mrTbNdbrW4YeKpNPX4S6pQsY8
GF6dCQepoYd3G8z0hHIf5xd4qPpBcMjs7OwhAlEZjFPnDMoZBR6rTCYD9tcX
X3zx4sULRVFAwsAWMwxjdXU1Go1C9/aHP/wB3p72nZ4+VjJ8Lkx90QpWIqZX
OWFvmvpq2OUtnLA9QWcdrYUwTQygbQTvysmQ5YrCoWuKSQPcLP9FQdmpaKEe
Resq9Npqg5+a6zz8cJF0etg6yIUHwamlGNf0pMF1OkMONz1paGGjY+Iwq5md
CRAYjGMAeuz19fV6vb5KgBdra2u4Cq9prz7VtrGxAXJ2xgvv1mq1e/fuff31
19BFOByOt95666OPPrp27RoLjWlBFQ17TGKaWakFu3PFm5IQoNVkLFeK3fPA
901TL3icnOVuQXSkIxfx85P3heh2TTG14ykUdLhIOq17k9HV6LgLGx0y+oYU
bLKS1DEYp8Tc3NzU1FQ2m11eXj74JANo4uPHj9ncwmsACpArUkFPA2dM1soC
Klp3rnilY3qNulLsnge+f5p6l5NPyzTdcSBZaecibhRfD1+IM4qhNRqHCz7X
E/4xe9Oryp/AJz3rHxkcGaNleAeGOTqNXM9PDpMaGYOD+B+maIyTg00LMHqg
C0DEgQLMpoAQdLlCmUhPrvjW9Bq699H0Vrvkgd81TT05n4SrVzQ7Fj3ceA18
IY4JGGFubGzU63UYbZZKJTCdVlZW1tfXDzZbriRDrYhwMG8PFOCMDplBzKhc
xXKBNsdkQpJS7mEbrRJIiuHaRvzRVNQPYjfkz8LfE52Jh92pfIpmQ2WKxjg5
SL56d5alK2S0oYpGlos06kDhEbpzxWcaZo53+UQcqBcEDzoH7p4Hfu809dY6
XetwzHt8vL4QxVv+S9cer6nqWr3y+NaXly4F+51EvXXp0s3Zwz0aW41abePl
Z/FBpP7whz8csDGoG0jb/Pz89PT07du3RVGcmZkpl8vdMZhNJAFDDXIVBZ06
0a+Syx1gZcxQ5KKMX341n5gUsjomOK0mJkZo8nCskDsySVsmHFga3qoqSG+h
szQGg3EgsJBHMplUJYFa+jb74LiIjhnZ8eHh8RRt1Hqtl8QxkrEQ5w2gGakB
bR+yDh1xi3182pUM9GUsrc/FoenSQNAwessjSKZWDrksDwTixmA2pFjbgaKZ
sJFm4+hjo3Fd2TnaiiZRX8r24ZXj9oXY6euCqZJx+nTn8hxJVknCorXuwGet
aH1wX+xBgHPRpcNAWOBJhThvKG1VoFbMYgT3k/hqElLdE0PdPpWIvvo//vgj
iNTLfyAELDUQxMePH9+5c2dqaiqTySwsLMDG5n45sKNanJYR4Y6M7qLYPeHk
ihQJwF9/cx76Dv9oR/FbEsjZW0iXKNqgpWh6dqipaMpqxfqkAv7Jer4ZBoOC
8Zv5pUX3gM0+xkuyxI+BOg2kVPix4ZCJNmq+lnHiYNCRyOd5BzZLyAkyMTDI
J1JRP9b+mpB6NM1oFIsycwFkmD1uDMRF4Vh+GsfqC9HlvUmnPXuW57BgNMip
1hP4TGzYgFRrKA30dUTP/1raiWHaBnnhKWjN6mZoVGK0dVn0cXxur1ORz1Kt
Ho05A9/NixcvstksGG53795dXFw0tJXMdLbe/bfaLGamn1VQfjaqs9OZom7q
sEWqbsAXLj+dnl3d1Ovz2dlV6ASqM9e83mix2tjcMjeX014+s2may5lrfHqZ
nou+3qxmvN5ry/RCW1XB680sb5Bb2lDBaN3amJ2eLtb1ejELl4ENilxISyzB
I6MFJjSQaisczmI7oimpXpclSYbfaPLD/+2f/TZJG9HX+mzoT//0n8VWyCZ9
4ZtPv5ouJ/7PP/1TB92kT8Pr3ybx9Ux+xv/he0D4cdXUnge/vA2DNfHLS5e8
l3DrpdAsmRTKi/x7hC9v5+EnXBK/pG/vv7hASxuMc0eXosV9Tq9Y7lmeW4Wx
YqjQ6A183pFUhC4dajkPR0LJLH/+Vr3Opic/WWrc61THBsvRwThXUEXbrKZ4
sLb+7M/+7JtvvtnaYr9hBmNXMB6Bx7kvQ1OKGIyGy4I9y3MNEmUANlp34HNP
miyzPWXao2id7qB7neqYqCSdOyLmsEpCWNp9/aw999uNJOyoM0AcS85r4WzG
GYYqWjWfSJRUXd9YO+37YZxrcFm2o9+yqkgf7SVAOmjmQ4RGPZ+sTb+jc3b5
ktT7smd5LkeaxYqNdNg7Pj7+pd/v//4+fB9qMfZtlJRsUOe+DYrrnS82i7//
6PeFPjYaaltvDHVz+/GhYQVV0YqpIZIa3CuEr+2w2g3OzQaTJEq+lsNyCb4i
lsA78TB5xmsOrqM9q+SGbbb/8c0ftjdOogLUCUyVME4J/DkFoYsn9VGw3/KK
R91jWaIZylBjpU/ajVPkuEOVzROvRkrC+SyzKx1weiKYAKGSi1lOMD58ojt8
Xe7DdhfxdaEuHC1wqjbcTMxoFDh0lVS6wuQ7HF0KyZCPevN4+DhcXU4LLo5G
yUdqGNWYC1oeKccxamKcX7B/SICBFnX/T//4H59MBSiFJGM9mttnnC3Q5A9L
LfsphJ1hRzaPFzsLr5iaFMA8IdgDekNprben6ji2KRRooznxCJK/t6lovU53
EW+AKh1NTqIVIxxH+1onL55oXho5MeHm82bTne8kL30UoJcjWmlGc/BgFD3E
9sTJz4DTJUjdvi74p610zU+i8z/nC4WxzgB2MgH4g3aHybfOs1pKBgIxmlDG
i+H26FAaiBcxObMg5GoKWo4x1EcZ7oCLMDuP0Y/tk6kARTPZ0r6FOHLvXgEK
p1mgz8O2gUjB6BkcMs4YZErQF8R+i0ctCojldjaP6kxX4RX68yAdYA26rFBh
tbunah3btkpQNAWpksSoAFEzitbCEwddIk6OVdI8cfXvzg+skHS+aFBg5vzQ
CTp8qxyJEzapszqXevUzUk/73QLHjpyigOZVBSy0ALqKGXIcn8+mh4ovlFzt
WBl0NeMsioKHGnQUnHX0CblCIZPJFMrUO7E7TL5j9qYmhnzQD8Al6NClUUw2
o+QjZU3GcDjLDQfv4CJFyTNehhOpAEUmM0MyJtiLk2n5XStAmUoGvZrLitGQ
ImGxonUPDk/pa2LsBiqaV7DSe5RrNAWIlc1D6ym80tjRAbpc4QfdPdVqKxNI
+xLoFU9quvhwagu6Qk9uVfK0ktgbkgtntNpFWKQwVbRWkZdWKPdJkPUP0wCs
4fEUpsgYGLGSPg1ZSZ/MaspBYzxtVijo3kQikXfeeeeQmRIPRyPjwnEuF6PK
gd+wk5YbKMdDvLjTe9PpI7lh6BCl/afrl7C6O0y+dZ4K2Gx0vUNDGy1dqwgB
npyshl1Nphpx0Q4HxifxAB9ngsboQhK8brf7ZCpAkb6l0Ny7o/PpqQBlFpNh
ah4GI5lGz+CQ/ZLPGERuunzhOjz6ugqv4JDe6SU9VaNlo+3oqZRe9aGKRhwD
y3TZxYOuFE5MD4InyoWJQ2AjxHEixkE2BA/6HPbxMDwR1JKIaZ2G3FlZTbmH
rKRPoh/jOdFwkx12EuMpSdHxERLRuavltbm5CXIGP/5G44Rjig20iF3tJfVK
OmzFrDu9mYrWdlCxli04sjIW77xLdBDtLirUHSbfOo9RSXdEyTtJlHyzzgBZ
caMNyHWc4QybrWF0A78od2j6ZCpAtfuWnb7KvRWgjFomGCTT6Zg6CYaF3YPD
Y/9eGC+HIjTlpmNb26O7u/AK7QBJz+jiMd9+d0/VxxscLxFuDv6LWNMFNVEr
J5sHumgSCdoHUqB9u9fd3cP8eFDHB2wDbpxsxKRPw1bSp+iYze5IqNlxULHx
hFyvVuv17Kglc31YWlqC/v3bb7/V9b7FZk+cnnIDO3e9ureG0X3+7isax++G
wzivgNV/6bp0MhWgOkd0ro4MCX0qQJmNWIBrDs3ERs/g8GS+HMZR0tkvNZ29
tR2ZRA7dU3UnBsFrnf5vpO4esHRql6RPOxhy91G0VCrlcDgSiXPnVcJgnA6g
aB9ce7ZXi9OrAGX0KQF1+v0U4wjY3t7aeu1zUlBFQxutU9Ho63oC3UYEWTfR
8lKzUUHM78hkparq119//f7777MCfAzGwXn1QsMMBu29HSxZ+g6qbjsunkl1
vVfRQMSGbDb76ISs6qUEzkAO821/pydPnjidzsnJybMy03hQtp7Hrt7Kr5qm
/jh8dWmN3vyWJF69KjzePOV7Y1wIWol9tgzd0NSNjQ1j29zStY1NYhxtb+3x
TL1i5jc4nKbd2jI2N/Wt7a1NbZOFTJ5T6pydKVo3CawHZrM7xFTPrKOJro4T
rZT0g2M8/e4MwwgEAu+9997s7Ozp3fjhoX6ttVrS6Qyu9+xVs/6BofG69Xqc
vu4t/wE/J8E9YrPqegisCiPj4Oyb2OfKnWd9q9AeFdeuhbr9phjnj76KdtDi
xWre6tPIrkF/tt6364N27hFLBAaGHNl6/2NNzH3tH7Qu60idqszqurqnlaWj
Z0hHExCyaDR6sEKcZxN9ZbG8+KK8XCc22c5BL5lr5eo7Xtd7y3+QeqADfjGf
T0zApkH3EYTyMRitxD5dVWj/yV/4qK/akWTNMoyXL3DIOHP0UbSDFi/W863i
xe5hOy1e3K/r0yfR4hkWslI+wWOXBx1dv2N1aYJsE+C6HJbxcxzlCOw42d7e
hmfutO/iGKmnOv6s1ut6T/mPKmwZcETrKrqBRrkB+sv5/9u7n+c0ri2B4/xF
rGbnlRZv7d2sVG+p2cxCi9loK1fFwdWucadqKCrMM2SEYjlEniJThJBMOxKO
PB09ESwYg0Mg7oxBcoggBORuIZCYe7sRQhKSf8gWFvl+KrFR091ql1ScPrfP
PRd4W46tQnvlr5+9/a5ZuNyGRbRXXbxYPbl48bCPvnZBd8on2o1KToSqCTU5
9Fg7aE7najL7qaTnhy/ed7FarVapVKpWq5ZltdttkYKJP0Xwqtfrz58/39jY
EC8u2yOzNzHsx9p1lv/oFXx6Yo2GPrA+qDMm62PgEeexs7NzpNPO0VVor/zz
f57SNauV1XrV/U630tfomoXLbdio46suXiw+2aYPYk5N5HWe4RFNDjBOTwx8
zqnDj3WmMw9S34MHfNvb2w8ePAgEAjdv3rxx44aqqnNzc/fv37+kz8uERiF2
8ONwT/sSzudFQfNddfeGhZ3x3nTYY29we//2oZ1ue5wfRiPpcXI0Z/mPRqWg
zc/aP6wfxV9TYdkPU/xgG+V0Qi/IF1SW4E09ffrU7/f3v0z7xC/uZCxtNNry
99DJ0U52zarJBnqLsltDx+5WWjy5INTpXbNwudkRLX3kVvrYr42Tow2pYx/M
s9rpq4ejjsc++owZ+dE5XyiLzVZ4Upxv+LFJOU7lk7mc+BxsV3QtUaiNf/pz
0do5ebMyI34chh6WkWi+YFkFZ7w3VijocmH7yXAlKafdzUaSRi72L3/5izOv
XE0YInme6d3kGHJAejYmfklqOXl4INfQ5HtTYi+rlrN3C4if8NcPn16W0WO8
b/b29q5fv95vuSM/Ilyz4k64XUnOuF1XrqhDu2YVNX9/2Qi5DKLTgPQVu2bh
cpPP96cCWjqZ1HXxn542asd+bUQyJW61h9Sxd43pXqgqhO2cTkSlIR997YL4
6Jual0UCRsLn5GhDj63pqv38Lidu/DX5IM2VGH2KNnbaNXGrULbkxLlyOuw+
vJfoZdYioQ5Ekqtiix2PhMa6uEmuzU/3aoUmJnppeznhcx+OOmqWfbDaz7Mn
pvWKvCGJxWIjHz3G5RUOh/udChq5SH+wZ2p2+sqVvw7tmlWTa4hE7VZVsiN6
JFt/ja5ZuNwagaMPP+QDsqO/NmJbrNweWsfeLiemnJGpqxMHg4RDPvqS89MH
Z5+cnnQ7G4cd29YD0/0LUelr/W6kI55+JBJ8yZrzkHQw6gzewDSz/nZbloFZ
DeFYbLK3Wcc31QY2ffjhh+/D6DEuqV9//XV1dXVgw671wjqcLtbeWlnSt3oj
2+1fUktLenG3u1v6X33JtpL+ZUcetJVaOrDy025358mK/tw+aiurZys7F/kv
wihYjSPF6UN3Sc9MenLOR1dFcw/07D350deW5xvYdPqx8jvXGhe07Mqfj5NE
z4aTFfHTOKjJccZ7e2PARmxmJvDVv8oczfl5WUl1ZmblDb/ffnst8ZDRYwDv
vfKsM7o0bS+/Mhl4nRvx8xyLN2f3pXRH5P1DLeaR+bkv3ajZrb18CaNtlQOT
MrPeONhiNXIee8bFtviZPfzbtWvxje2dRunRtWvX7n6/0W1v/Me1a99vmDu/
fi/+du50zZJ4fW3lp992O9a3//aPjB7jIvWX6wVeW7umxyLz8/MxPffaWdV5
jsUba5f7j7ompmYm5d1E7uh475Qm493gFld/oLh/6KTbfh5qpcUWNd2QpT4H
T+IYPcboHC7XC7wZwzDu3r178+bN69evq6p67969QoF7pPeaHBY+OaZsj/cO
bm1b8hmZlfP1Z2Q4zVJeMhw9cDbuVfDGcgcPfCcmZ5O1diEy45709dJ9Kzft
npjPNY7tM7hc75CebO3czNVJ1ec0RJrwaXpk9upgFROAsddIzvZnZAAXpJaQ
hbharmLYK/BOxdpGxHXQdaGSkHMfC5Xj+xxdrvdET7ZG0g5gk7FkMmzHMvd0
IJmUjQLcpHXAn0O7VtCTBW5hcaHKMTu3iuTKtVrZMCqyS41ss2aHnrAIQrOJ
Yfv0l+sd1pPNkhFt1n6s25YjD70psYOF3ADG0vPnzyORyNzc3NLSUiaTMQyj
XC5vbm6WSqWff/55dXVV07RwOBwMBu/fv7+xsTHq68WYaSfnZw6f4ybk01gj
POVyeSoNWaMbkN3ST+5zsFzv0J5sveJeOQBpl0hN2C+PzFUBMMZqtdra2lo0
Gr1z504gELh9+7YIYXfv3v3yyy+/+OKLZ8+e7e3RsRzvQKOcTMs2D+Wc7pNT
XKdlSKslREiamZUZWmX4Pv3lestDerIdTFfpEtEAHPXDDz9Uq9VRXwXGk12P
5PLphpwQKaeUzNor8Fnh3nSf9Cn7HC7XO6Qn24mIphPRANhKpdKTJ09GfRUY
V43YbH/g0O3rLSnbW+sqVm6ftk9/ud4hPdnsySa+dH/U8Wqa52gAbK1W67vv
vts/ujYo8Ba1T7QfSotczH1klaKT+wwu13usJxsAnCaVSjHwiAtipZ3JZh6d
xRwAvH0MPOLitGuJyHxMP2xBs7+/v7GxkbQZhrG1tWWa5u7ubqvVsixL3GuJ
jSkb910AXoqBR7wPyuWypmnz8/MfffTRjRs3PB7PrVu35ubmxEYR1EZ9dQAu
DW6AAQDjgYFHAMB42NnZYeARADAeGHgEAIwHBh4BAOOBgUcAwNhg4BEAMB7K
5TIDjwCAMeBMtWZlGQDAGHj06NHW1taorwIAgPMqlUq5XG7UVwEAwHnR4xEA
MDYYeAQAjIdyuczAIwBgDDDwCAAYG6lUioFHAMAYYOARADAeGHgEAIwNBh4B
AOOhXC5ns9lRXwUAAOe1u7vLwCMAYDw8evTot99+G/VVAABwXgw8AgDGAwOP
AICxwcAjAGA8MNUaADAednd3Hzx4wMAjAGAMMPAIABgPDDwCAMaDU/G4t7c3
6gsBAOC8GHgEAIwHploDAMYDA48AgLGxvr7OwCMAYAww8AgAGA97e3vb29sv
Xrxo2sQLy7La7TaTrwEA751Oq9k0O6O+CgAAzsFMRYNKj3c5XxebilF/JN8c
9YUBAPAaDM2vKKF81RR5WmltUVHUvElEAwBcOpUFRdFKrYMvW1ldLzU7vYhm
lqJBr6KqIsxFdENkc8vBBRHvujIOLsSLzVYlE/J6vWIH70K+3ul2qiuLIj6q
dq5XHd0/CgDw52PmRTQqto5vdiJaJRVdXC7KvUrLihJtdptxrz9rHu6QjyjK
wpopk7tlPV8tLfuV4Ip4v1VZUxS/ceK0AAC8K52SX1Ezh+OLHSOT6udonXpR
5Giq6vX7RdzTTDui9XK0uJ3ENUvxkFc+f/MvZitmakFVVL8UDAWDobVNGdIq
lcqo/nEAgD+VrMiz/MtVu8yxbohcTFmr9iJaKqR44zJHa8kcLVLvNqOqqlfE
rk3Nr0TzzWxc5HAyHObjXmUxW9LEnxl5os5mdCHqjGXevn17aWmJliMAgHev
vrLoPah1VLWsfP4lIpoIWNVMVJY/Cn6xg1/kZMbKwsGeSrxoNo0VVR4kH5zp
RrPbqcT9iv0cTQnGs85cgBcvXnzyyScirjWblJoAAN69Tss0h81HE9tbnRNb
jnx97EB5ohNP0DY3N9Pp9Pb29tu5WgAAAAC4vKopRfE6FR22ekRR4oZ5xhEA
ALyXWsteJaj3ag5bJU1RFs+aLWY9/ezTB9awd0oPPr0dz25b29vbjac/RG/f
/uJ5Z/vBp/f+j0J9AMCFsGeOxZ3KjMyC4l8uiRfV/EpvOnRouSoj3YpT8hFa
+btfFoTIAo+Qlh18RlaMe9W40fuiU1RlgxFT8yuq364t8S6KzO/wPHoxFQ05
hSP+yJr47pWM5lWdCdnLdXGCal7WpMgJ3PYEbQAAXk72BpFZWqfodUYg5Uw0
ZaUk4kwrtaB4NcM04oqyYNSbZlPuk5EF/dVj45OyZZYaisaj0ahsDqIsrLW6
puZVIhl56rWQspCq9s/zRzm1sLAiw6hpBBVv1mxG5REimDZTmpavmzJzXJHx
sSKuQF128rxo/L9Ve4abXqI2EgAwREmT6VVVZGgLKfFlp7ImU6dgbz50KJr6
oxj1RvJyVzMvdjV7R/mdhM5hxL0ibcsXi9lstrhZt7fZ065bB+9G8mb/PN26
Hg2pqpx0LYv/zW6zlDqYkL282arIJpK9CdnyCuwJ2d0v9F9EKN3UQ2rvJAAA
HNXM2i0a1RUncnQMEVsydlDaXItG9E1zIKL5lZDdw6ousqpo8TBHk6OO0eKx
8x62xrLf7Z+nKnI2VZPvtGSOlqlXtYWIfbJ6XFUWs7VlOSFbPtBrba4tRNac
HC25IZ/gmeJcRDQAwHCd1IJiN7PqqWbivenRSjBbbZl2oxD5RqvoV3oTpb2L
a4Njf4Z8jnZqRBPveuPF/nk61Yx8TmfP0BbniuabzgRte0K2fOLm7GB/HyWe
7dWq/L0X0aJENADAa5ATq0+pU5Rvnb9ao3P8/Me/Y+fYhOy1soyOh+EVAAAA
AAAAAAAAeHdetxGWmfd740PngxlaUDnkXc7XB4tDAAB4x16zEZYd0YbGKDnp
bDHVNJvNZj0vaxdDpY6IaMGTC2EDAPAu0AgLADAuLk0jLAAAznZZGmEBAPAS
l6QRFgAAL3M5GmEBAPAm3r9GWAAAAADwp9H6Sdd/rFSLq/rj587oY6dSXNd1
PZlK6XqqulPPrGacOvoXpcfrT2t7ZvVJUtdXxX+Pq9Zet1PP6LbMRu1pSl9N
rsq3Mr8dyeZ2xfmL9T3ni05NfM9iq1OT3yC5Kr/Xk5JIyhrPemcq1X//aT25
out37y5GdLv0kSJ/AMCZWqVlRQlVut26fKIWlYX7hqYoEfkEq56xq/o7elAJ
rYkN9UVFWd5sHi+wbxVFbNFLVdPsyDqQSEaW+GcWFVUbGDmU9fxqaFHW+EdC
ssZf3+y2+jMCKuJEqbpTNqnXTbOcii4uy2dzprw8cVUU+QMAXiKzaBd7eP1e
u4ReM8yS5vf2Zky3NLvAQ3YUUbVNQ7PLFE8U2P+R9x8U9hej/l4ZZMfwK8HS
YaSRES2opYrFfDab36zb+xz2ITE1VYnkm/JwuzNXp16MBkVG5vX7VadwhSJ/
AMBZzLyIEmsVEQ9EotTJR1UlqDflbOioLOE3i8Fe78dm3I4mkWzdaZ91pMBe
BCY16lQ/FuP+4LKMhs2snIc90DXLjKtK9FjfyMMD7XeLTbsiUm5IhRSvXT9p
p5CRepcifwDAWTb1oOJfOQwH9ZRIfTL1ZiriPaig9zsplxxFVBacLpDHC+wH
mhjL/iG94n+/Xhqs8ZdZmIhZR7794YHy3bhh2jla0/52UTtzlLmjnIjd7FLk
DwB4M52W2Tqr4OKsAvu3UuI/5Aoo8gcAAACAV7S/32m3O3v7J9/Y6wzbfMaZ
Oq95AAAA59ZIq+s//taVK4gu2svFLGweH3DsFUy+usOCSQAALko751tfFxFN
zheLZPJxVa4dY7/TysTl2tZep8f+H0ZIdRoddyv6QlArHp8i3TJCvRXU1gpy
eRo5mVpRQ9kqD8oAAO9QOuxxu4SJqUn3emHroqZpAwDwNtWSPhHMZsN6IRm+
6nKJiHZR07QBAHibkuqEayJg2a8r2sx6Zu2ipmkDAPA2iYjmVpPOayutLi36
X3Ga9u8/xlOp/I69136r8UuxWHwq/i9Wmq1uZ/sXo9K23zK0fz9lmjYAAG+T
zNGuzjvRp5H03LtXOG3Pl03TPsvbmaYNAMDpKolZl8sV0MtWI+eZcP3DPy3u
d5k+BgC4jNoJddLVN+HbFttatfz3kZ7v841h+ZVlaFMT9iHuqyIg2ttqEc+U
c5opNda40H8FAABS22rUGtaxjVZDOL7xQMM34XLPRoyKEZkVgW0ibXV1j3wx
r+dyiYB8perv+rIBADi3hup2uSY9ibTRaFQMo2K1C9Mu14zmJGtdIyKStdnK
aK8RAIBXUEtH+oOVk55Yw0qLL2cSNeddKxdwudw6I48AgFHY29vz+XyBQOAV
9m0Uksmy1W5UCtq8rC1RH/6PiGgevRfRKtqM+IocDQAwKiKoffzxx9FoVLw4
c0djSuRgs7FGu1vLhWW1ZK4WmxabZpKVRqOsz8gxyfBpD+EAALgAu7u7c3Nz
fr//999/P2O3csLnPhx11GTwauQ8Vw82XfXkiGcAgFETCdrDhw89Hk8ikWi1
zmjFOKQc8swKSQAARqBer3/++ecirn399dfVanXUlwMAwLnUarVvvvnG7sbv
FaGtUChYFikYAOCy2t/ff/bs2bfffhsMBj/44INbt27duXNnZWXl8ePHedv6
+rp497PPPksmk50OTRwBAJeAiG5bW1vZbFZEtK+++uq/bPfv3xdbdnZ2Rn11
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAC6r/wfMsUeB
              "], {{0, 
              304}, {582, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {582, 304}, 
            PlotRange -> {{0, 582}, {0, 304}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2af4da96-172b-499d-bfee-3cb5442e26e2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"cc6c373b-5d7a-45e9-88cb-ee82ac03a325"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"93b79619-6bca-49d3-a5f0-4403025de6bc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d439e4ae-b4e8-4e6b-bae3-0599763adbc2"],

Cell[TextData[{
 "Make a list of numbers of nouns, verbs, adjectives and adverbs found by ",
 StyleBox["WordList",
  FontFamily->"Source Sans Pro"],
 " in English."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"05db75f6-dcd1-4006-8257-60c541d0ec14"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"57b85439-cc0e-489b-a6c4-00a28f3a53d9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWD3PpDYQRkmTMlJ+Qf4AdVrKVEgXpdvmTjlOaS7oLlJES0dJh9JQUVFR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            "], {{0, 19}, {154, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{154, 19},
          PlotRange->{{0, 154}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{158, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f59de427-ac4c-4f0f-af5b-b89a64829fc8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWD3PpDYQRkmTMlJ+Qf4AdVrKVEgXpdvmTjlOaS7oLlJES0dJh9JQUVFR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              "], {{0, 19}, {154, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {154, 19}, 
            PlotRange -> {{0, 154}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"604f34ee-197d-463e-b823-762d3849c37b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.14"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"98d49537-149e-4041-9e86-e3f9fa4be6d4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d1244ceb-7d61-4737-a5f7-109b8caf1aeb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c6feb6fd-c976-4d4a-8397-e84cfe4907ca"],

Cell["\<\
Generate a list of the translations of numbers 2 through 10 into French.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "35.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 15}, {
   "WebOnly", 0}},ExpressionUUID->"0234df0a-6e4f-47ba-b8bb-add369ad19f8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"300c8e40-4ef7-4cc2-aff6-073747200fa5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWa+vrcgdp11T2aSyav8BdC2yimSbOsxu+mZT80reNmmwOCQOhxqFQqEw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            "], {{0, 19}, {283, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{283, 19},
          PlotRange->{{0, 283}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{287, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "08d1db68-f6e2-4d66-9cc3-dcd31cbedc79"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWa+vrcgdp11T2aSyav8BdC2yimSbOsxu+mZT80reNmmwOCQOhxqFQqEw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              "], {{0, 19}, {283, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {283, 19}, 
            PlotRange -> {{0, 283}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3b9f1cb7-5e82-4ee4-8899-543e912ea166"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["35.15"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9857f3e3-8e0b-40ec-a356-0c5b4e2fed10"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"fbe6f99c-7c1f-410c-bb95-275bfc269fd7"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b6ac9f67-5cf1-48dd-8eb3-fbeceb913175"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Natural Language Understanding: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 35  Natural Language Understanding", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
35-natural-language-understanding.html"], None}], Evaluator -> Automatic, 
                Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "35.1", "35.10", "35.11", "35.12", "35.13", "35.14", "35.15", "35.2", 
         "35.3", "35.4", "35.5", "35.6", "35.7", "35.8", "35.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "35.1", "35.10", "35.11", "35.12", "35.13", "35.14", "35.15", "35.2", 
      "35.3", "35.4", "35.5", "35.6", "35.7", "35.8", "35.9"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[10981, 255, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a8aefb27-8a9d-4f2e-b332-033dbfd5ed14",
   CellTags->"FirstInputCell"],
  Cell[21614, 516, 813, 26, 
  70, "Input", "ExpressionUUID" -> "91a3d4df-685b-4967-b9ce-f8b67b53722a",
   CellTags->"FirstInputCell"],
  Cell[33672, 801, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0feb144a-32ec-44f8-9ea5-8d1d2bf57cfa",
   CellTags->"FirstInputCell"],
  Cell[43772, 1054, 813, 26, 
  70, "Input", "ExpressionUUID" -> "914bba4e-9058-42a0-9d4b-f46025f2a2cd",
   CellTags->"FirstInputCell"],
  Cell[103684, 2121, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f4f5d808-21df-43b0-bb7b-25097955953c",
   CellTags->"FirstInputCell"],
  Cell[129915, 2638, 813, 26, 
  70, "Input", "ExpressionUUID" -> "cf49f9d9-ca8a-4efe-b3e1-f794c92d1cf3",
   CellTags->"FirstInputCell"],
  Cell[141093, 2907, 813, 26, 
  70, "Input", "ExpressionUUID" -> "271c64a0-885d-40d4-b234-46bcc4e047c3",
   CellTags->"FirstInputCell"],
  Cell[262267, 4980, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7b605047-a412-45b3-b9b9-ef5cc55fee7c",
   CellTags->"FirstInputCell"],
  Cell[271116, 5209, 813, 26, 
  70, "Input", "ExpressionUUID" -> "feba642b-edb1-421a-9ef9-a5d250133b79",
   CellTags->"FirstInputCell"],
  Cell[279349, 5432, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7276d7ee-dea8-4dba-94f4-eafe61ad599f",
   CellTags->"FirstInputCell"],
  Cell[338311, 6485, 813, 26, 
  70, "Input", "ExpressionUUID" -> "33e5b915-b5b6-49a7-bbfb-3812acc08726",
   CellTags->"FirstInputCell"],
  Cell[352302, 6804, 813, 26, 
  70, "Input", "ExpressionUUID" -> "edf22fbf-174a-4232-ae64-851bef5d83d3",
   CellTags->"FirstInputCell"],
  Cell[432295, 8201, 813, 26, 
  70, "Input", "ExpressionUUID" -> "93b79619-6bca-49d3-a5f0-4403025de6bc",
   CellTags->"FirstInputCell"],
  Cell[442362, 8453, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d1244ceb-7d61-4737-a5f7-109b8caf1aeb",
   CellTags->"FirstInputCell"],
  Cell[454447, 8736, 813, 26, 
  70, "Input", "ExpressionUUID" -> "fbe6f99c-7c1f-410c-bb95-275bfc269fd7",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 513418, 9955}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[653, 22, 510, 14, 70, "Exercise", "ExpressionUUID" -> \
"9622303f-8330-4e25-8c28-975410b431a9",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1188, 40, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a7b9e736-475e-42ca-81e8-53aaf8e9ab41"],
Cell[1827, 61, 8547, 169, 70, "ExerciseOutput", "ExpressionUUID" -> \
"14fa5279-2390-4662-aafb-875e2826289c"]
}, Closed]],
Cell[CellGroupData[{
Cell[10411, 235, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"18cdd2b1-7eb7-4b68-a1d3-f69bb422fe58"],
Cell[10981, 255, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a8aefb27-8a9d-4f2e-b332-033dbfd5ed14",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11831, 286, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ae30125d-896f-490d-be14-bc1d47d2a618"],
Cell[12118, 297, 561, 15, 70, "Exercise", "ExpressionUUID" -> \
"de777ff1-431a-4fb3-ab48-0317830a3ac8",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[12704, 316, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"38d1fdfa-567c-45b9-88dd-b25be156fb3f"],
Cell[13343, 337, 7664, 154, 70, "ExerciseOutput", "ExpressionUUID" -> \
"23c93b0f-60bb-4020-9d57-579da4adbcd0"]
}, Closed]],
Cell[CellGroupData[{
Cell[21044, 496, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"043e210c-f63e-4ed4-a1e3-a162e7683d56"],
Cell[21614, 516, 813, 26, 70, "Input", "ExpressionUUID" -> \
"91a3d4df-685b-4967-b9ce-f8b67b53722a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22476, 548, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"cc8e43b8-caa7-4661-85c0-6f415630c828"],
Cell[22763, 559, 526, 14, 70, "Exercise", "ExpressionUUID" -> \
"0be02300-cc4a-440b-9e72-5e7f0ee120f8",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[23314, 577, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a4535851-947c-474a-9b3f-dc1677d4b3c7"],
Cell[23953, 598, 9112, 178, 70, "ExerciseOutput", "ExpressionUUID" -> \
"aec62459-928f-4b98-bcfd-bdddf42e00e5"]
}, Closed]],
Cell[CellGroupData[{
Cell[33102, 781, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a9a43ee8-35a3-4612-be2a-be87c7bc79a3"],
Cell[33672, 801, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0feb144a-32ec-44f8-9ea5-8d1d2bf57cfa",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34534, 833, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7239b105-0e57-49fc-932f-0c842f61835a"],
Cell[34821, 844, 549, 15, 70, "Exercise", "ExpressionUUID" -> \
"a6872f08-2858-4ce8-928b-46d56c1cbed9",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[35395, 863, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5ac1b648-aa12-43ce-9df1-abc08b9609ac"],
Cell[36034, 884, 7131, 145, 70, "ExerciseOutput", "ExpressionUUID" -> \
"729c8311-654e-49c9-b2c0-97d8e05b26f3"]
}, Closed]],
Cell[CellGroupData[{
Cell[43202, 1034, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"265a422e-26b9-435e-820f-2577756b3af6"],
Cell[43772, 1054, 813, 26, 70, "Input", "ExpressionUUID" -> \
"914bba4e-9058-42a0-9d4b-f46025f2a2cd",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44634, 1086, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6694ff25-d649-449f-be36-dc75a4d505be"],
Cell[44921, 1097, 533, 12, 70, "Exercise", "ExpressionUUID" -> \
"f6a5be14-b983-4f0e-a7e9-59359dbb22b9",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[45479, 1113, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"63030ad0-9e74-4f4c-ba25-a51304c2802c"],
Cell[46118, 1134, 56959, 962, 70, "ExerciseOutput", "ExpressionUUID" -> \
"bf69ad15-abd8-4429-aa9b-ca20a5785928"]
}, Closed]],
Cell[CellGroupData[{
Cell[103114, 2101, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"f3b2d2a5-38d4-4500-a967-267e3c7c4f1e"],
Cell[103684, 2121, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f4f5d808-21df-43b0-bb7b-25097955953c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104546, 2153, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ca5ee7b7-be9f-4244-b3fb-76f153ea5d5e"],
Cell[104833, 2164, 584, 15, 70, "Exercise", "ExpressionUUID" -> \
"4557a249-f97b-4c4c-a362-a843a7fc3dd7",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[105442, 2183, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"774808db-9d5c-4f59-9ec3-9bdf9cfebc60"],
Cell[106081, 2204, 23227, 409, 70, "ExerciseOutput", "ExpressionUUID" -> \
"cd93c0bd-f1f2-4868-b905-d237d164d9ac"]
}, Closed]],
Cell[CellGroupData[{
Cell[129345, 2618, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"8a394b04-6d8a-47b7-8438-cdf42f707eb8"],
Cell[129915, 2638, 813, 26, 70, "Input", "ExpressionUUID" -> \
"cf49f9d9-ca8a-4efe-b3e1-f794c92d1cf3",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[130777, 2670, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"86bdbaec-fe97-4510-89b4-e1f0b42b8c28"],
Cell[131064, 2681, 476, 12, 70, "Exercise", "ExpressionUUID" -> \
"a6d0a4e2-d654-44d5-8093-87137126b798",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[131565, 2697, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"fccd7b25-e6d0-40d7-8b9f-c3fa77bbc5db"],
Cell[132204, 2718, 8282, 164, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1ea0a05f-4edd-4d80-a254-a41bdbc4048d"]
}, Closed]],
Cell[CellGroupData[{
Cell[140523, 2887, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3567eb73-3071-493e-97a1-cbb2e4e30842"],
Cell[141093, 2907, 813, 26, 70, "Input", "ExpressionUUID" -> \
"271c64a0-885d-40d4-b234-46bcc4e047c3",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141955, 2939, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"5609afb7-4fc0-4850-af58-8bfd4b795dc5"],
Cell[142242, 2950, 563, 13, 70, "Exercise", "ExpressionUUID" -> \
"e6d79ebc-e0b2-48d7-b056-728a2db9f34b",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[142830, 2967, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"fb8afaaf-52b0-4264-afc9-c971721b6753"],
Cell[143489, 2989, 118171, 1966, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b8a511ba-daf6-46a1-aaae-e90ad9b0fb00"]
}, Closed]],
Cell[CellGroupData[{
Cell[261697, 4960, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b93c3612-fbd3-4a4f-9226-54a7c210aea7"],
Cell[262267, 4980, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7b605047-a412-45b3-b9b9-ef5cc55fee7c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[263129, 5012, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ed517374-7e97-4129-8141-944fe26b8a0b"],
Cell[263416, 5023, 489, 10, 70, "Exercise", "ExpressionUUID" -> \
"12952725-8367-41bd-bbec-0240cc534fae",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[263930, 5037, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"04c89adb-91b4-4d69-874e-3ae8619dc868"],
Cell[264569, 5058, 5940, 126, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3368163c-a2a7-4892-8311-a742752d10e2"]
}, Closed]],
Cell[CellGroupData[{
Cell[270546, 5189, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"ef9e3811-7b68-4dcd-83f0-0a79b54538e2"],
Cell[271116, 5209, 813, 26, 70, "Input", "ExpressionUUID" -> \
"feba642b-edb1-421a-9ef9-a5d250133b79",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[271978, 5241, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"62ec2dd6-5bed-4a54-91f7-6fe875da6537"],
Cell[272265, 5252, 636, 16, 70, "Exercise", "ExpressionUUID" -> \
"ba3006d0-195d-4bc7-8ede-6784557d59f5",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[272926, 5272, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"78ee5216-43c4-478d-80d6-7e4142b41fbf"],
Cell[273585, 5294, 5156, 113, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9521e62c-e619-4445-8232-0fa9e123c2d4"]
}, Closed]],
Cell[CellGroupData[{
Cell[278778, 5412, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"72869532-6092-4209-9ee4-75292d88b1bf"],
Cell[279349, 5432, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7276d7ee-dea8-4dba-94f4-eafe61ad599f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[280211, 5464, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2481291e-5726-41d0-95d8-254768be1fc4"],
Cell[280498, 5475, 539, 13, 70, "Exercise", "ExpressionUUID" -> \
"9e21cc16-38ce-4d0a-b478-2697d11ea150",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[281062, 5492, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"232b82bf-27ea-4532-a0b7-25e962ce74c9"],
Cell[281721, 5514, 55982, 946, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c797fa64-e5fd-4a2f-b2c9-a9e33588848d"]
}, Closed]],
Cell[CellGroupData[{
Cell[337740, 6465, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"3f9d6081-4d9a-4ba3-9ae3-db871ef98784"],
Cell[338311, 6485, 813, 26, 70, "Input", "ExpressionUUID" -> \
"33e5b915-b5b6-49a7-bbfb-3812acc08726",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[339173, 6517, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"78430b8a-7ffc-4f73-b217-f0b9aa68f6ad"],
Cell[339460, 6528, 705, 19, 70, "Exercise", "ExpressionUUID" -> \
"f6809c39-7cab-4756-8f9f-7842d2f7413d",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[340190, 6551, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"761e50c7-7cb4-4ffb-a597-ce0883f22b6d"],
Cell[340829, 6572, 10865, 207, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b45cc9f3-c236-4e9f-b536-893c55653d57"]
}, Closed]],
Cell[CellGroupData[{
Cell[351731, 6784, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"ecb6eb8f-9f2a-4470-b1fe-7f3c1d4b6fc5"],
Cell[352302, 6804, 813, 26, 70, "Input", "ExpressionUUID" -> \
"edf22fbf-174a-4232-ae64-851bef5d83d3",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[353164, 6836, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"eb27c071-1c88-4b18-bb86-c1895537cf5e"],
Cell[353451, 6847, 585, 13, 70, "Exercise", "ExpressionUUID" -> \
"d7f33544-454f-4756-b607-a81cfe5905ba",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[354061, 6864, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f4de1410-f005-4c4b-aed5-500fc860b5ff"],
Cell[354720, 6886, 76967, 1290, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2af4da96-172b-499d-bfee-3cb5442e26e2"]
}, Closed]],
Cell[CellGroupData[{
Cell[431724, 8181, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"cc6c373b-5d7a-45e9-88cb-ee82ac03a325"],
Cell[432295, 8201, 813, 26, 70, "Input", "ExpressionUUID" -> \
"93b79619-6bca-49d3-a5f0-4403025de6bc",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[433157, 8233, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d439e4ae-b4e8-4e6b-bae3-0599763adbc2"],
Cell[433444, 8244, 547, 14, 70, "Exercise", "ExpressionUUID" -> \
"05db75f6-dcd1-4006-8257-60c541d0ec14",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[434016, 8262, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"57b85439-cc0e-489b-a6c4-00a28f3a53d9"],
Cell[434655, 8283, 7099, 145, 70, "ExerciseOutput", "ExpressionUUID" -> \
"604f34ee-197d-463e-b823-762d3849c37b"]
}, Closed]],
Cell[CellGroupData[{
Cell[441791, 8433, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"98d49537-149e-4041-9e86-e3f9fa4be6d4"],
Cell[442362, 8453, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d1244ceb-7d61-4737-a5f7-109b8caf1aeb",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[443224, 8485, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c6feb6fd-c976-4d4a-8397-e84cfe4907ca"],
Cell[443511, 8496, 467, 11, 70, "Exercise", "ExpressionUUID" -> \
"0234df0a-6e4f-47ba-b8bb-add369ad19f8",
 CounterAssignments->{{"SectionNumber", 35}, {"ExerciseNumber", 15}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[444003, 8511, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"300c8e40-4ef7-4cc2-aff6-073747200fa5"],
Cell[444642, 8532, 9197, 179, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3b9f1cb7-5e82-4ee4-8899-543e912ea166"]
}, Closed]],
Cell[CellGroupData[{
Cell[453876, 8716, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"9857f3e3-8e0b-40ec-a356-0c5b4e2fed10"],
Cell[454447, 8736, 813, 26, 70, "Input", "ExpressionUUID" -> \
"fbe6f99c-7c1f-410c-bb95-275bfc269fd7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[455287, 8766, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b6ac9f67-5cf1-48dd-8eb3-fbeceb913175"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature DRcC0WpaTTGXDjI07cRnQ9RF *)
