(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    257540,       6240]
NotebookOptionsPosition[    147595,       4028]
NotebookOutlinePosition[    242797,       5979]
CellTagsIndexPosition[    242146,       5951]
WindowTitle->Parts of Lists: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Parts of Lists", "SectionInline",ExpressionUUID->
   "32fb29e6-c7cc-4e92-8b60-57b38be89e1e"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 30}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:187",
 CellLabel->"In[1]:=",ExpressionUUID->"a8fccb13-5ffd-4647-af5e-25c0175db9f4"],

Cell[TextData[{
 ButtonBox["Part",
  BaseStyle->"Link"],
 " lets you pick out an element of a list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"b32116dd-9dc8-4a08-8e3a-cab11b1e25e6"],

Cell["Pick out element 2 from a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"bc61c553-bbec-42fe-9783-253cad5515cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"99eb67cb-18aa-42a6-99f9-d47c4919ceb6"],

Cell[BoxData["b"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"6d8d7e02-97b2-406d-bde7-9f0c734058cc"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["[[\[ThinSpace]",
  BaseStyle->"Link",
  ButtonData->"Part"],
 StyleBox[ButtonBox["...\[ThinSpace]",
  BaseStyle->"Link",
  ButtonData->"Part"],
  FontColor->GrayLevel[0.6]],
 ButtonBox["]]",
  BaseStyle->"Link",
  ButtonData->"Part"],
 " is an alternative notation."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"61e3908c-0dc1-4a29-aef8-78360c981c42"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{"[", "2", "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "f8f8c74c-5d35-4dda-941e-3a6fb235e847"],
 " to pick out ",
 "element 2",
 " from a list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9d300711-7053-44c0-8378-16bda4e5f0ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"3f360f90-40f7-4393-a89b-4697cc67c266"],

Cell[BoxData["b"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"024f73b2-81a5-4eff-98b4-3222aa39b08f"]
}, Open  ]],

Cell["Negative part numbers count from the end of a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"9e04b57f-c34c-47af-9910-b63def7e2f15"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"-", "2"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"35c3cbe9-50da-46ac-bc1d-c627be96e24a"],

Cell[BoxData["f"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"d4e926e0-e891-49c4-8858-37e4b1147fc5"]
}, Open  ]],

Cell["\<\
You can ask for a list of parts by giving a list of part numbers.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b27d2635-a380-4f0c-bf23-b73cc2d1f653"],

Cell["Pick out parts 2, 4 and 5:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0446d446-f47b-4829-a12b-ed4a7892c015"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "5"}], "}"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"83f50f17-3ea3-464c-a9fd-8c5d2a671c6c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "e"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"6bb11784-d443-48e6-af46-1072819e672f"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[";;",
   BaseStyle->"Link",
   ButtonData->"Span"]], "InlineCodeText",ExpressionUUID->
  "600daa82-43b6-4ebf-80eb-8f4dbc7f0546"],
 " lets you ask for a ",
 StyleBox["span",
  FontSlant->"Italic"],
 " or sequence of parts."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"6c3e783f-0cf1-48b8-83bd-1f9a430d0a26"],

Cell["Pick out parts 2 through 5:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a23033db-8073-4229-ab4d-ca49c8cef051"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "5"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"755c82b1-0044-47e0-b594-6be35adefffe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"eccd6a65-cff0-481f-bbdd-4956df809919"]
}, Open  ]],

Cell["Take the first 4 elements from a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"70c71a60-6451-44c3-9268-1ff1d8e74e63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", "4"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"51bfef22-3c3f-47fc-bafd-1a6527da22a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"a7e4f8d8-c1a7-47a4-9654-456f8c446d2c"]
}, Open  ]],

Cell["Take the last 2 elements from a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ef70786b-3bb6-44f5-bbe8-cac76a07381f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"083b152c-b900-4fa1-a687-f99be47c004c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", ",", "g"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"a06768ca-e5c1-44f5-806f-81ccd92b9156"]
}, Open  ]],

Cell["Drop the last 2 elements from a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6974a2c4-3c26-4505-9047-ab4d9c4e0bc2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"83a2ae07-e397-4e73-bec8-82df19c5c2a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[8]=",ExpressionUUID->"4e599e86-67a6-4d44-80b2-b9e731204856"]
}, Open  ]],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s now talk about lists of lists, or arrays. Each \
sublist acts as a ",
 StyleBox["row",
  FontSlant->"Italic"],
 " in the array. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:188", "i:6"},ExpressionUUID->"1a93d94b-aa0c-4ce3-9e51-ae12b3215a31"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "//", 
  "Grid"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"ec7c9e2c-d360-44e8-817d-6344770ca3b3"],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b", "c"},
    {"d", "e", "f"},
    {"g", "h", "i"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"ceffa229-4032-4987-a5be-55e295902276"]
}, Open  ]],

Cell["\<\
Pick out the second sublist, corresponding to the second row, in the array:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"27a179a9-a74b-4e80-a777-5804917dced5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"95eadefd-ac89-4f90-95e0-b056e2b6004d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "f"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"eac770c7-23fd-4ad2-b8e3-252b0c42d950"]
}, Open  ]],

Cell["This picks out element 1 on row 2:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38846755-ecf1-4c09-af74-5260c7f637ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "1"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"e704ee57-cdff-4f43-82ed-9b9d94f40930"],

Cell[BoxData["d"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"d2c97f36-4972-46be-95f6-dc9eb6ae9d9f"]
}, Open  ]],

Cell[TextData[{
 "It\[CloseCurlyQuote]s also often useful to pick out ",
 StyleBox["columns",
  FontSlant->"Italic"],
 " in an array. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"1e0c0ce6-b517-4f41-8b0e-2fed2b98c5ae"],

Cell["Pick out the first column, by getting element 1 on all rows:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f1640c1c-0955-4da3-8562-18fce19a0988"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"de30103c-18d0-4b00-89a3-6d97ee508b7a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "d", ",", "g"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"3997884a-bc59-48e2-9a31-8a7de873fb41"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 ButtonBox["Position",
  BaseStyle->"Link"],
 " finds the list of positions at which something appears."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"543a3198-d946-47a7-aee0-56e0888a21b9"],

Cell[TextData[{
 "Here there\[CloseCurlyQuote]s only one ",
 Cell[BoxData[
 "d"], "InlineCode",ExpressionUUID->"aae1082f-9f42-4b18-96ab-7092e4f2e07b"],
 ", and it appears at position ",
 Cell[BoxData[
  RowBox[{"2", ",", "1"}]], "InlineCode",ExpressionUUID->
  "8e26b653-43dd-4e4c-ac31-b9922f2a6949"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"6d136ca9-3b0e-46db-8cfa-94b0291b7a38"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], ",", "d"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"1dc65329-fa24-4225-8520-596f543f0448"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"ffccff7e-7f07-4ee9-b958-45e0b4d57e2c"]
}, Open  ]],

Cell[TextData[{
 "This gives a list of all positions at which ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"f180dc2e-b2cc-48f5-9d3d-39c11be6ae6e"],
 " appears:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"81e46d9e-ecb3-4f9c-9cb5-6881f039de81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "y", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "y"}], "}"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"6cbc6a9a-0368-404f-8c9f-2ca003bd397a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"55fe5805-eb69-4eb1-b59c-55d7ec7d7ec1"]
}, Open  ]],

Cell[TextData[{
 "The positions at which \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
 "a"], "InlineCode",ExpressionUUID->"8eb1767c-177e-40b0-a862-815571090560"],
 "\[CloseCurlyDoubleQuote] occurs in a list of characters:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9345a388-29e9-4f90-89d4-e0c11d17ab5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "\"\<The Wolfram Language\>\"", "]"}], ",", 
   "\"\<a\>\""}], "]"}]], "Input",
 Deletable->False,
 CellTags->"i:10",
 CellLabel->"In[15]:=",ExpressionUUID->"058a3cc5-b95e-40fe-85fe-2415a1b51da4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "10", "}"}], ",", 
   RowBox[{"{", "14", "}"}], ",", 
   RowBox[{"{", "18", "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"b0cb9d1f-1bc5-45ef-837d-81ed730410ee"]
}, Open  ]],

Cell["\<\
Find the positions at which 0 occurs in the digit sequence of 2^500:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"e692b88a-bd2d-4fe0-a5f4-4afc83ff038c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Position", "[", 
   RowBox[{
    RowBox[{"IntegerDigits", "[", 
     RowBox[{"2", "^", "500"}], "]"}], ",", "0"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"8542cef4-0762-44ee-918c-81af95dd415c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7", ",", "9", ",", "19", ",", "20", ",", "44", ",", "47", ",", "50", ",", 
   "65", ",", "75", ",", "88", ",", "89", ",", "96", ",", "103", ",", "115", 
   ",", "116", ",", "119", ",", "120", ",", "137"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"7cdd4ac2-0048-424f-b725-fdfe5245d53e"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 ButtonBox["ReplacePart",
  BaseStyle->"Link"],
 " lets you replace parts of a list:"
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:189", "i:12"},ExpressionUUID->"750870f7-5bf9-4d0b-8256-2027ba33f486"],

Cell[TextData[{
 "Replace part 3 with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"1365b3ba-f3e2-44b5-b5bb-4db59ac6c0d5"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6062972c-f737-434c-abdf-b4df8b7c2864"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"3", "\[Rule]", "x"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"ed1c6069-db6c-487b-9e61-216fbc1a84f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "d", ",", "e", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"a3d574a0-8896-4065-8e79-65752bbb6f19"]
}, Open  ]],

Cell["Replace two parts:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"216ca28c-0ae4-404f-8474-4c1dd0ee90ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "x"}], ",", 
     RowBox[{"5", "\[Rule]", "y"}]}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"7dfc2a2d-d850-4bb3-9602-7140c802f086"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "d", ",", "y", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"d8a60895-c428-40fd-948a-fa7d0c37931f"]
}, Open  ]],

Cell[TextData[{
 "Replace 5 randomly chosen parts with \[OpenCurlyDoubleQuote]",
 Cell[BoxData["--"], "InlineCode",ExpressionUUID->
  "8623903c-c0c3-4900-b1f6-67a241469d6b"],
 "\[CloseCurlyDoubleQuote]:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"e141874a-e730-4da5-9b69-dbfd1a569d57"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "\"\<The Wolfram Language\>\"", "]"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "20"}], "}"}], "]"}], "\[Rule]", "\"\<--\>\""}], 
     ",", "5"}], "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"a195799a-fc1e-4e32-b1c0-41208679c041"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"T\"\>", ",", "\<\"h\"\>", ",", "\<\"e\"\>", ",", "\<\" \"\>", 
   ",", "\<\"W\"\>", ",", "\<\"--\"\>", ",", "\<\"l\"\>", ",", "\<\"f\"\>", 
   ",", "\<\"r\"\>", ",", "\<\"a\"\>", ",", "\<\"m\"\>", ",", "\<\"--\"\>", 
   ",", "\<\"--\"\>", ",", "\<\"--\"\>", ",", "\<\"n\"\>", ",", "\<\"g\"\>", 
   ",", "\<\"u\"\>", ",", "\<\"a\"\>", ",", "\<\"g\"\>", ",", "\<\"--\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"3260addf-840a-4e28-884d-fcc389c00465"]
}, Open  ]],

Cell[TextData[{
 "Sometimes one wants particular parts of a list to just disappear. One can \
do this by replacing ",
 "them",
 " with ",
 ButtonBox["Nothing",
  BaseStyle->"Link"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"47425b83-c9b4-42a4-884a-fa04d9c49ef8"],

Cell[TextData[{
 ButtonBox["Nothing",
  BaseStyle->"Link"],
 " just disappears:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"774e7bce-82e6-49d7-99da-0cc6ce4dcd48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "Nothing", ",", "4", ",", "5", ",", "Nothing"}],
   "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"206bda50-3dc1-46c9-a3f7-448b3bf4b5d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "5"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"db2591a3-3bec-4146-961f-70c878734bb4"]
}, Open  ]],

Cell[TextData[{
 "Replace parts 1 and 3 with ",
 ButtonBox["Nothing",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b4f688d1-aca2-4aee-9f90-356ddc41d08e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "Nothing"}], ",", 
     RowBox[{"3", "\[Rule]", "Nothing"}]}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"6abe2b5d-77ac-473b-b3bc-bf4dc46169ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "e", ",", "f", ",", "g"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"a782cf0f-0243-4555-a7b0-781e1e8f034a"]
}, Open  ]],

Cell["\<\
Take 50 random words, dropping ones longer than 5 characters, and reversing \
others:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"17f806dd-ce02-43f7-9363-7841f3b57f04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"StringLength", "[", "#", "]"}], ">", "5"}], ",", "Nothing", 
     ",", 
     RowBox[{"StringReverse", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"RandomSample", "[", 
   RowBox[{
    RowBox[{"WordList", "[", "\[ThinSpace]", "]"}], ",", "50"}], 
   "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"527ea75d-ff4b-4cd5-93b9-d2d50e22f1b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"yllud\"\>", ",", "\<\"yciuj\"\>", ",", "\<\"poons\"\>", 
   ",", "\<\"tsioh\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"1fefa1f8-43e4-42f9-a262-3398182bd290"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Take",
  BaseStyle->"Link"],
 " takes a specified number of elements in a list based on their position. ",
 ButtonBox["TakeLargest",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["TakeSmallest",
  BaseStyle->"Link"],
 " take elements based on their size."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"82450695-91bd-45da-ba0c-6efeb7be47b1"],

Cell["Take the 5 largest elements from a list: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"edc697f9-335c-4a5d-b811-9603e9ada772"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeLargest", "[", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"245bc596-ed6e-4bd0-a5f3-4950fd10a331"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "19", ",", "18", ",", "17", ",", "16"}], "}"}]], "Output",\

 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"b3294680-ee1c-45fb-8cf6-1b22a3df1790"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["TakeLargestBy",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["TakeSmallestBy",
  BaseStyle->"Link"],
 " take elements based on applying a function."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"897e20c7-f38b-4c02-8a78-270611c38734"],

Cell["\<\
From the first 100 Roman numerals take the 5 that have the largest string \
length:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"3bc6c1d9-04d2-4224-b8f3-622ffb308acf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeLargestBy", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"RomanNumeral", ",", "100"}], "]"}], ",", "StringLength", ",", 
   "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"532c42da-863d-423e-a9dd-c0b991071fb6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"LXXXVIII\"\>", ",", "\<\"LXXXIII\"\>", ",", "\<\"XXXVIII\"\>", 
   ",", "\<\"LXXVIII\"\>", ",", "\<\"LXXXVII\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[24]=",ExpressionUUID->"bf35d3e9-e00a-4ee2-aee1-b9d7ff4390aa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:190",ExpressionUUID->"6c5c990d-7be2-45c3-97a5-3fab3d21a23c"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "part ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "0df75975-d560-4d72-a004-5511d41a2c13"],
     " of a list"
    }], "VocabularyText",ExpressionUUID->
     "2afdfc9e-f91b-4525-a7aa-7f6f0c4b942f"]},
   {
    RowBox[{
     StyleBox["list", "CodeVariableLrg"], "[", 
     RowBox[{"[", 
      StyleBox["n", "CodeVariableLrg"], "]"}], "]"}], " ", Cell[TextData[{
     "short notation for part ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "e84a7e09-d271-45e6-9109-763adc2ff87f"],
     " of a list"
    }], "VocabularyText",ExpressionUUID->
     "56ca171b-233c-4a9c-a333-be4bd1db3519"]},
   {
    RowBox[{
     StyleBox["list", "CodeVariableLrg"], "[", 
     RowBox[{"[", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "CodeVariableLrg"], "1"], 
        StyleBox[",", "CodeVariableLrg"], 
        SubscriptBox[
         StyleBox["n", "CodeVariableLrg"], "2"], 
        StyleBox[",", "CodeVariableLrg"], 
        StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], "]"}], " ", Cell[
    TextData[{
     "list of parts ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        SubscriptBox[
         StyleBox["n", "CodeVariable"], "1"],
        FontColor->GrayLevel[0]], TraditionalForm]],ExpressionUUID->
      "a91f4adf-c70a-402e-b2d0-e779dd25f0a0"],
     ", ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["n", "CodeVariable"], "2"], TraditionalForm]],
      FontColor->GrayLevel[0],ExpressionUUID->
      "b362e55c-fc6c-486a-8cd2-0a05cdfcd15b"],
     ", ",
     StyleBox["...", "GrayPointSix"]
    }], "VocabularyText",ExpressionUUID->
     "6e355300-36a4-4cb7-8757-d8a9e0c6b686"]},
   {
    RowBox[{
     StyleBox["list", "CodeVariableLrg"], "[", 
     RowBox[{"[", 
      RowBox[{
       SubscriptBox[
        StyleBox["n", "CodeVariableLrg"], "1"], 
       ButtonBox[";;",
        BaseStyle->"CodeLink",
        ButtonData->"Span"], 
       SubscriptBox[
        StyleBox["n", "CodeVariableLrg"], "2"]}], "]"}], "]"}], " ", Cell[
    TextData[{
     "span (sequence) of parts ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["n", "CodeVariable"], "1"], TraditionalForm]],
      FontColor->GrayLevel[0],ExpressionUUID->
      "b2d5bf44-a044-4321-b88e-9e13d3c8c2c7"],
     " through",
     StyleBox[" ",
      FontColor->GrayLevel[0]],
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["n", "CodeVariable"], "2"], TraditionalForm]],
      FontColor->GrayLevel[0],ExpressionUUID->
      "8ff917e2-4e0f-4929-a2e2-c7e470394dbc"]
    }], "VocabularyText",ExpressionUUID->
     "fb0c97b6-cf3d-4b6b-93ba-9e198f965c56"]},
   {
    RowBox[{
     StyleBox["list", "CodeVariableLrg"], "[", 
     RowBox[{"[", 
      RowBox[{
       StyleBox["m", "CodeVariableLrg"], ",", 
       StyleBox["n", "CodeVariableLrg"]}], "]"}], "]"}], " ", Cell[TextData[{
     "element from row ",
     Cell[BoxData[
      StyleBox["m", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "9c732af1-2463-476d-8857-991e4a965d38"],
     ", column ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "9d4b7ec4-eccc-4964-8d77-b44a4132bf93"],
     " of an array"
    }], "VocabularyText",ExpressionUUID->
     "199293e0-049e-442b-bb81-f7d133f2df8d"]},
   {
    RowBox[{
     StyleBox["list", "CodeVariableLrg"], "[", 
     RowBox[{"[", 
      RowBox[{
       ButtonBox["All",
        BaseStyle->"CodeLink"], ",", 
       StyleBox["n", "CodeVariableLrg"]}], "]"}], "]"}], " ", Cell[TextData[{
     "all elements in column ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "fe2664d8-3885-4b1b-8a52-16b641462128"]
    }], "VocabularyText",ExpressionUUID->
     "8b36748c-e8c0-464c-9864-20b851fcc2fc"]},
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "take the first ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "e1a5a48e-b00c-4e7d-bab9-417768fcf01d"],
     " elements of a list"
    }], "VocabularyText",ExpressionUUID->
     "4eb573fc-2b5e-47ef-8d8f-061384dd28fe"]},
   {
    RowBox[{
     ButtonBox["TakeLargest",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "take the largest ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "7742916e-21c6-414a-b71d-f385e84541e7"],
     " elements of a list"
    }], "VocabularyText",ExpressionUUID->
     "83e0753c-3b07-4e9c-b0f6-d223e064ca63"]},
   {
    RowBox[{
     ButtonBox["TakeSmallest",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "take the smallest ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "f1729552-4b74-42ed-b5ce-db8316a9aa4d"],
     " elements of a list"
    }], "VocabularyText",ExpressionUUID->
     "e1d93ba3-14ae-408e-8eed-68edbc278f23"]},
   {
    RowBox[{
     ButtonBox["TakeLargestBy",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["f", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "take elements largest by applying ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "b3350844-cffe-4dd2-90de-4d7de5593deb"]
    }], "VocabularyText",ExpressionUUID->
     "76fb73e6-2686-4492-b9b2-f89f0ac1bcd2"]},
   {
    RowBox[{
     ButtonBox["TakeSmallestBy",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["f", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "take elements smallest by applying ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "cfe81a4f-55a6-4559-9f66-e54ab397f1b3"]
    }], "VocabularyText",ExpressionUUID->
     "9543ba23-aac8-4c8f-818b-90dd814c57e4"]},
   {
    RowBox[{
     ButtonBox["Position",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["x", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "all positions of ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "fecf8e76-12e4-4bae-b093-674bb53d9b89"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "ab0c9037-ee17-400e-9e3d-c500ea83ab08"]
    }], "VocabularyText",ExpressionUUID->
     "7262b765-50a5-4af6-b454-f83a0cccd2e7"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      RowBox[{
       StyleBox["n", "CodeVariableLrg"], "\[Rule]", 
       StyleBox["x", "CodeVariableLrg"]}]}], "]"}], " ", Cell[TextData[{
     "replace part ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "0db2bce2-7774-4d26-8192-07d23fcee4ce"],
     " of ",
     Cell[BoxData[
      StyleBox["list", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "09eba9a3-ba66-4245-9a60-38700816ae43"],
     " with ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "ef0f68f1-42fa-4c20-a624-9b74c5440b32"]
    }], "VocabularyText",ExpressionUUID->
     "8c989f84-9599-4418-9d84-f81073dd36fe"]},
   {
    ButtonBox["Nothing",
     BaseStyle->"CodeLink"], " ", Cell[
    "a list element that is automatically removed", "VocabularyText",
     ExpressionUUID->"55a91945-72ab-4725-9296-6ac1a6adda8b"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True}, 
     False}}},ExpressionUUID->"f9c3e703-06cb-46b5-b7bf-172462d02d37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"03ba83cc-e8b2-42d0-9bb8-c1bfc148d402"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"13 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-31-parts-of-lists-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"261006c9-d2e8-42dc-9808-3fdc37ee000d"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the last 5 digits in 2^1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1298d92a-89fa-44a3-9fd6-a0503d226bd4"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"6", ",", "9", ",", "3", ",", "7", ",", "6"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "0a1388f5-76f1-494c-8c11-9bb6a711e7f5"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"6", ",", "9", ",", "3", ",", "7", ",", "6"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a0cedab9-6053-442d-8293-b5444151ec9c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Pick out letters 10 through 20 in the alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f0475986-963a-4e1a-94c1-57a7db8f0107"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"j\"\>", ",", "\<\"k\"\>", ",", "\<\"l\"\>", 
         ",", "\<\"m\"\>", ",", "\<\"n\"\>", ",", "\<\"o\"\>", 
         ",", "\<\"p\"\>", ",", "\<\"q\"\>", ",", "\<\"r\"\>", 
         ",", "\<\"s\"\>", ",", "\<\"t\"\>"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"9f19275f-3942-45b1-a607-85cbed6c574a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"j\"", ",", "\"k\"", ",", "\"l\"", ",", "\"m\"", ",", 
             "\"n\"", ",", "\"o\"", ",", "\"p\"", ",", "\"q\"", ",", "\"r\"", 
             ",", "\"s\"", ",", "\"t\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ff0017a7-5dd3-4110-88d6-a6067da833f4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the letters at even-numbered positions in the alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"202dee62-1c63-48cf-bbd7-f3a0bef30148"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"b\"\>", ",", "\<\"d\"\>", ",", "\<\"f\"\>", 
         ",", "\<\"h\"\>", ",", "\<\"j\"\>", ",", "\<\"l\"\>", 
         ",", "\<\"n\"\>", ",", "\<\"p\"\>", ",", "\<\"r\"\>", 
         ",", "\<\"t\"\>", ",", "\<\"v\"\>", ",", "\<\"x\"\>", 
         ",", "\<\"z\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "41576303-c516-405d-ad56-629932862412"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"b\"", ",", "\"d\"", ",", "\"f\"", ",", "\"h\"", ",", 
             "\"j\"", ",", "\"l\"", ",", "\"n\"", ",", "\"p\"", ",", "\"r\"", 
             ",", "\"t\"", ",", "\"v\"", ",", "\"x\"", ",", "\"z\""}], "}"}]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"41eff8cc-8fc7-4b75-99e3-235df04d673a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the second to last digit in the first 100 powers of 12.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d4bb689f-e490-4195-a392-1494328fa920"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJx9kblKA1AQRR9WlhYWFhYqIiIi7rvmue9bjFsrWvsL82nvk/IJKrlHmFs4
EC4nTN7MnEy+f3U/h0opHz+f3xxUv5Oz1EGMKIfr/9+PGo8pJ5Tj/L7k76cs
eWfa5s3Ye7PWP2dz5m2PBeNFJfcu2R7Ltu+KmLtXbd6avbdu/Ru8p9xU4mvL
eFvJvTu2z67tu6fEx77N69h7NfcHzD0HSvkK43Ko1L0Bs89R3jdgfBzneQHj
7yT3B8w9p0r5CuNyptS9AVPned+A8XeR5wWMv8vcHzD+rpT4My7XSvzB2qfc
5H0Dxt9tnhcw/u5yf8D4u1fKVzUOWPc2mHrI+1YYH7DmNRh/3dxfYe6B5asZ
l0el7q2w9glY1WD89fK8CvN/9HJ/g/H3pMSfccD4g6nnvG+F8QfjD8bfS+6v
MP5g/BmXVyX+YO0TsKrB+Hv7m/cNFrhx1A==
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{328.6015625, Automatic},
        Method->{},
        PlotRange->{{0., 100.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "fc50f410-b204-42cf-beb2-fa43667223f4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJx9kblKA1AQRR9WlhYWFhYqIiIi7rvmue9bjFsrWvsL82nvk/IJKrlHmFs4
EC4nTN7MnEy+f3U/h0opHz+f3xxUv5Oz1EGMKIfr/9+PGo8pJ5Tj/L7k76cs
eWfa5s3Ye7PWP2dz5m2PBeNFJfcu2R7Ltu+KmLtXbd6avbdu/Ru8p9xU4mvL
eFvJvTu2z67tu6fEx77N69h7NfcHzD0HSvkK43Ko1L0Bs89R3jdgfBzneQHj
7yT3B8w9p0r5CuNyptS9AVPned+A8XeR5wWMv8vcHzD+rpT4My7XSvzB2qfc
5H0Dxt9tnhcw/u5yf8D4u1fKVzUOWPc2mHrI+1YYH7DmNRh/3dxfYe6B5asZ
l0el7q2w9glY1WD89fK8CvN/9HJ/g/H3pMSfccD4g6nnvG+F8QfjD8bfS+6v
MP5g/BmXVyX+YO0TsKrB+Hv7m/cNFrhx1A==
               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {328.6015625, Automatic}, 
          Method -> {}, PlotRange -> {{0., 100.}, {0, 9.}}, PlotRangeClipping -> 
          True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0ea5af2a-a294-4cab-b17b-303d6173090d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Join lists of the first 20 squares and cubes, and get the 10 smallest \
elements of the combined list.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"25753c30-29a9-497f-b88c-4e75134e8f48"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "4", ",", "8", ",", "9", ",", "16", ",", "25", 
         ",", "27", ",", "36", ",", "49"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"46a60a33-c27b-471c-894d-60fa9061d08f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "1", ",", "4", ",", "8", ",", "9", ",", "16", 
             ",", "25", ",", "27", ",", "36", ",", "49"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dfb6721a-1d6a-40cc-9b7e-f7cecd19db10"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the positions of the word \[OpenCurlyDoubleQuote]software\
\[CloseCurlyDoubleQuote] in the Wikipedia entry for \
\[OpenCurlyDoubleQuote]computers\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4ab4ac20-d6dd-4b13-9439-3dededbb035c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "4594", ",", "4732", ",", "4739", ",", "4747", ",", "4769", ",", 
         "6070", ",", "6164", ",", "6186", ",", "7608", ",", "7665", ",", 
         "7687"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "3a3b792d-7c43-4b63-b0ab-aa34bd7b4021"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"4594", ",", "4732", ",", "4739", ",", "4747", ",", "4769",
              ",", "6070", ",", "6164", ",", "6186", ",", "7608", ",", "7665",
              ",", "7687"}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bffe8356-130b-41bc-b238-90139b2d7850"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a histogram of where the letter \[OpenCurlyDoubleQuote]e\
\[CloseCurlyDoubleQuote] occurs in the words in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "31b01569-29eb-4657-bad3-2b41fea78303"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2a54673a-d39b-40ff-862c-96be846cafc7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
          EdgeForm[{Opacity[0.5459999999999999], Thickness[Small]}], {}, 
          {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
           EdgeForm[{Opacity[0.5459999999999999], Thickness[Small]}], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{1., 0}, {2., 1674}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{28.85248198558847, 39.60868694955965}, {
                19.519746207292023`, 54.16478329277473}}],
              StatusArea[#, 1674]& ,
              TagBoxNote->"1674"],
             StyleBox["1674", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[1674, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{2., 0}, {3., 6021}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{39.10868694955965, 
                49.864891913530826`}, {-69.14720493404211, 
                54.16478329277473}}],
              StatusArea[#, 6021]& ,
              TagBoxNote->"6021"],
             StyleBox["6021", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[6021, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{3., 0}, {4., 2743}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{49.364891913530826`, 
                60.121096877502}, {-2.2849399601996225`, 54.16478329277473}}],
              
              StatusArea[#, 2743]& ,
              TagBoxNote->"2743"],
             StyleBox["2743", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[2743, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{4., 0}, {5., 4719}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{59.621096877502, 
                70.37730184147318}, {-42.58995386755555, 54.16478329277473}}],
              
              StatusArea[#, 4719]& ,
              TagBoxNote->"4719"],
             StyleBox["4719", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[4719, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{5., 0}, {6., 4887}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{69.87730184147318, 
                80.63350680544436}, {-46.01669594065059, 54.16478329277473}}],
              
              StatusArea[#, 4887]& ,
              TagBoxNote->"4887"],
             StyleBox["4887", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[4887, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{6., 0}, {7., 4238}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{80.13350680544436, 
                90.88971176941554}, {-32.77886495589655, 54.16478329277473}}],
              
              StatusArea[#, 4238]& ,
              TagBoxNote->"4238"],
             StyleBox["4238", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[4238, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{7., 0}, {8., 3799}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{90.38971176941554, 
                101.14591673338671`}, {-23.824461562511303`, 
                54.16478329277473}}],
              StatusArea[#, 3799]& ,
              TagBoxNote->"3799"],
             StyleBox["3799", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[3799, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{8., 0}, {9., 3013}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{100.64591673338671`, 
                111.40212169735788`}, {-7.792204006245221, 
                54.16478329277473}}],
              StatusArea[#, 3013]& ,
              TagBoxNote->"3013"],
             StyleBox["3013", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[3013, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{9., 0}, {10., 2546}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{110.90212169735788`, 121.65832666132907`}, {
                1.7333230659892038`, 54.16478329277473}}],
              StatusArea[#, 2546]& ,
              TagBoxNote->"2546"],
             StyleBox["2546", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[2546, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{10., 0}, {11., 1821}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{121.15832666132907`, 131.91453162530024`}, {
                16.521346893333863`, 54.16478329277473}}],
              StatusArea[#, 1821]& ,
              TagBoxNote->"1821"],
             StyleBox["1821", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[1821, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{11., 0}, {12., 1122}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{131.41453162530024`, 142.1707365892714}, {
                30.779041590318577`, 54.16478329277473}}],
              StatusArea[#, 1122]& ,
              TagBoxNote->"1122"],
             StyleBox["1122", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[1122, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{12., 0}, {13., 597}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{141.6707365892714, 152.42694155324259`}, {
                41.48761056874057, 54.16478329277473}}],
              StatusArea[#, 597]& ,
              TagBoxNote->"597"],
             StyleBox["597", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[597, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{13., 0}, {14., 321}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{151.92694155324259`, 162.68314651721377`}, {
                47.11725826025385, 54.16478329277473}}],
              StatusArea[#, 321]& ,
              TagBoxNote->"321"],
             StyleBox["321", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[321, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{14., 0}, {15., 139}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{162.18314651721377`, 172.93935148118493`}, {
                50.82956217277348, 54.16478329277473}}],
              StatusArea[#, 139]& ,
              TagBoxNote->"139"],
             StyleBox["139", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[139, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{15., 0}, {16., 48}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{172.43935148118493`, 183.19555644515611`}, {
                52.685714129033286`, 54.16478329277473}}],
              StatusArea[#, 48]& ,
              TagBoxNote->"48"],
             StyleBox["48", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[48, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{16., 0}, {17., 24}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{182.69555644515611`, 193.4517614091273}, {
                53.17524871090401, 54.16478329277473}}],
              StatusArea[#, 24]& ,
              TagBoxNote->"24"],
             StyleBox["24", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[24, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{17., 0}, {18., 5}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{192.9517614091273, 203.70796637309846`}, {
                53.562796921551666`, 54.16478329277473}}],
              StatusArea[#, 5]& ,
              TagBoxNote->"5"],
             StyleBox["5", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[5, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{18., 0}, {19., 2}, "RoundingRadius" -> 0]},
               ImageSizeCache->{{203.20796637309846`, 213.96417133706964`}, {
                53.623988744285505`, 54.16478329277473}}],
              StatusArea[#, 2]& ,
              TagBoxNote->"2"],
             StyleBox["2", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[2, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{19., 0}, {20., 1}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{213.46417133706964`, 224.22037630104083`}, {
                53.64438601853011, 54.16478329277473}}],
              StatusArea[#, 1]& ,
              TagBoxNote->"1"],
             StyleBox["1", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[1, {}], "Tooltip"]& ], 
           TagBox[
            TooltipBox[
             TagBox[
              DynamicBox[{
                FEPrivate`If[
                 CurrentValue["MouseOver"], 
                 EdgeForm[{
                   GrayLevel[0.5], 
                   AbsoluteThickness[1.5], 
                   Opacity[0.66]}], {}, {}], 
                RectangleBox[{20., 0}, {21., 1}, "RoundingRadius" -> 0]},
               
               ImageSizeCache->{{223.72037630104083`, 234.476581265012}, {
                53.64438601853011, 54.16478329277473}}],
              StatusArea[#, 1]& ,
              TagBoxNote->"1"],
             StyleBox["1", {}, StripOnInput -> False]],
            Annotation[#, 
             Style[1, {}], 
             "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.6, 0},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        PlotRange->{{1., 21.}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "8486fa06-8528-4bbc-b551-11d1def6172a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
            EdgeForm[{
              Opacity[0.5459999999999999], 
              Thickness[Small]}], {}, {
             RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
             EdgeForm[{
               Opacity[0.5459999999999999], 
               Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{1., 0}, {2., 1674}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{30.81405124099279, 41.47417934347477}, {
                  18.627289568347848`, 52.952466821648045`}}], 
                StatusArea[#, 1674]& , TagBoxNote -> "1674"], 
               StyleBox["1674", {}, StripOnInput -> False]], Annotation[#, 
               Style[1674, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{2., 0}, {3., 6021}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{40.97417934347477, 
                  51.634307445956765`}, {-69.20905781522202, 
                  52.952466821648045`}}], StatusArea[#, 6021]& , TagBoxNote -> 
                "6021"], 
               StyleBox["6021", {}, StripOnInput -> False]], Annotation[#, 
               Style[6021, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{3., 0}, {4., 2743}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{51.134307445956765`, 
                  61.79443554843875}, {-2.9731372439448123`, 
                  52.952466821648045`}}], StatusArea[#, 2743]& , TagBoxNote -> 
                "2743"], 
               StyleBox["2743", {}, StripOnInput -> False]], Annotation[#, 
               Style[2743, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{4., 0}, {5., 4719}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{61.29443554843875, 
                  71.95456365092073}, {-42.90058661821075, 
                  52.952466821648045`}}], StatusArea[#, 4719]& , TagBoxNote -> 
                "4719"], 
               StyleBox["4719", {}, StripOnInput -> False]], Annotation[#, 
               Style[4719, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{5., 0}, {6., 4887}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{71.45456365092073, 
                  82.11469175340272}, {-46.295228062986396`, 
                  52.952466821648045`}}], StatusArea[#, 4887]& , TagBoxNote -> 
                "4887"], 
               StyleBox["4887", {}, StripOnInput -> False]], Annotation[#, 
               Style[4887, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{6., 0}, {7., 4238}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{81.61469175340272, 
                  92.2748198558847}, {-33.18140486263286, 
                  52.952466821648045`}}], StatusArea[#, 4238]& , TagBoxNote -> 
                "4238"], 
               StyleBox["4238", {}, StripOnInput -> False]], Annotation[#, 
               Style[4238, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{7., 0}, {8., 3799}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{91.7748198558847, 
                  102.43494795836669`}, {-24.310883468248875`, 
                  52.952466821648045`}}], StatusArea[#, 3799]& , TagBoxNote -> 
                "3799"], 
               StyleBox["3799", {}, StripOnInput -> False]], Annotation[#, 
               Style[3799, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{8., 0}, {9., 3013}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{101.93494795836669`, 
                  112.59507606084868`}, {-8.428810994477104, 
                  52.952466821648045`}}], StatusArea[#, 3013]& , TagBoxNote -> 
                "3013"], 
               StyleBox["3013", {}, StripOnInput -> False]], Annotation[#, 
               Style[3013, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{9., 0}, {10., 2546}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{112.09507606084868`, 
                  122.75520416333066`}, {1.0074839740361554`, 
                  52.952466821648045`}}], StatusArea[#, 2546]& , TagBoxNote -> 
                "2546"], 
               StyleBox["2546", {}, StripOnInput -> False]], Annotation[#, 
               Style[2546, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{10., 0}, {11., 1821}, "RoundingRadius" -> 0]},
                  ImageSizeCache -> {{122.25520416333066`, 
                  132.91533226581265`}, {15.656978304169158`, 
                  52.952466821648045`}}], StatusArea[#, 1821]& , TagBoxNote -> 
                "1821"], 
               StyleBox["1821", {}, StripOnInput -> False]], Annotation[#, 
               Style[1821, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{11., 0}, {12., 1122}, "RoundingRadius" -> 0]},
                  ImageSizeCache -> {{132.41533226581265`, 
                  143.07546036829464`}, {29.781111458324972`, 
                  52.952466821648045`}}], StatusArea[#, 1122]& , TagBoxNote -> 
                "1122"], 
               StyleBox["1122", {}, StripOnInput -> False]], Annotation[#, 
               Style[1122, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{12., 0}, {13., 597}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{142.57546036829464`, 
                  153.23558847077663`}, {40.38936597324887, 
                  52.952466821648045`}}], StatusArea[#, 597]& , TagBoxNote -> 
                "597"], 
               StyleBox["597", {}, StripOnInput -> False]], Annotation[#, 
               Style[597, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{13., 0}, {14., 321}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{152.73558847077663`, 
                  163.3957165732586}, {45.96627691823743, 
                  52.952466821648045`}}], StatusArea[#, 321]& , TagBoxNote -> 
                "321"], 
               StyleBox["321", {}, StripOnInput -> False]], Annotation[#, 
               Style[321, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{14., 0}, {15., 139}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{162.8957165732586, 173.5558446757406}, {
                  49.64380515007772, 52.952466821648045`}}], 
                StatusArea[#, 139]& , TagBoxNote -> "139"], 
               StyleBox["139", {}, StripOnInput -> False]], Annotation[#, 
               Style[139, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{15., 0}, {16., 48}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{173.0558446757406, 
                  183.71597277822258`}, {51.48256926599786, 
                  52.952466821648045`}}], StatusArea[#, 48]& , TagBoxNote -> 
                "48"], 
               StyleBox["48", {}, StripOnInput -> False]], Annotation[#, 
               Style[48, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{16., 0}, {17., 24}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{183.21597277822258`, 
                  193.87610088070457`}, {51.967518043822956`, 
                  52.952466821648045`}}], StatusArea[#, 24]& , TagBoxNote -> 
                "24"], 
               StyleBox["24", {}, StripOnInput -> False]], Annotation[#, 
               Style[24, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{17., 0}, {18., 5}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{193.37610088070457`, 
                  204.03622898318656`}, {52.35143582626782, 
                  52.952466821648045`}}], StatusArea[#, 5]& , TagBoxNote -> 
                "5"], 
               StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
               Style[5, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{18., 0}, {19., 2}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{203.53622898318656`, 
                  214.19635708566852`}, {52.41205442349595, 
                  52.952466821648045`}}], StatusArea[#, 2]& , TagBoxNote -> 
                "2"], 
               StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
               Style[2, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{19., 0}, {20., 1}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{213.69635708566852`, 
                  224.35648518815051`}, {52.432260622572, 
                  52.952466821648045`}}], StatusArea[#, 1]& , TagBoxNote -> 
                "1"], 
               StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
               Style[1, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{20., 0}, {21., 1}, "RoundingRadius" -> 0]}, 
                 ImageSizeCache -> {{223.85648518815051`, 
                  234.5166132906325}, {52.432260622572, 
                  52.952466821648045`}}], StatusArea[#, 1]& , TagBoxNote -> 
                "1"], 
               StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
               Style[1, {}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0.6, 0}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], PlotRange -> {{1., 21.}, {All, All}}, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"17de1795-dcea-4189-a9c3-e6200fe1e469"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 100 cubes, with every one whose position is a \
square replaced by ",
 ButtonBox["Red",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"17947a30-1dcd-4104-9e9d-d1388b5f3b74"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "8", ",", "27", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "125", ",", "216", ",", "343", ",", "512", 
         ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "1000", ",", "1331", ",", "1728", ",", 
         "2197", ",", "2744", ",", "3375", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "4913", ",", "5832", ",", "6859", ",", 
         "8000", ",", "9261", ",", "10648", ",", "12167", ",", "13824", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "17576", ",", "19683", ",", "21952", ",", 
         "24389", ",", "27000", ",", "29791", ",", "32768", ",", "35937", ",",
          "39304", ",", "42875", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "50653", ",", "54872", ",", "59319", ",", 
         "64000", ",", "68921", ",", "74088", ",", "79507", ",", "85184", ",",
          "91125", ",", "97336", ",", "103823", ",", "110592", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "125000", ",", "132651", ",", "140608", 
         ",", "148877", ",", "157464", ",", "166375", ",", "175616", ",", 
         "185193", ",", "195112", ",", "205379", ",", "216000", ",", "226981",
          ",", "238328", ",", "250047", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "274625", ",", "287496", ",", "300763", 
         ",", "314432", ",", "328509", ",", "343000", ",", "357911", ",", 
         "373248", ",", "389017", ",", "405224", ",", "421875", ",", "438976",
          ",", "456533", ",", "474552", ",", "493039", ",", "512000", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "551368", ",", "571787", ",", "592704", 
         ",", "614125", ",", "636056", ",", "658503", ",", "681472", ",", 
         "704969", ",", "729000", ",", "753571", ",", "778688", ",", "804357",
          ",", "830584", ",", "857375", ",", "884736", ",", "912673", ",", 
         "941192", ",", "970299", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "6fd75595-b99b-4f47-8d89-9b89917e9f9e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "8", ",", "27", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "125", ",", "216", ",", "343", ",", "512", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "1000", ",", "1331", ",", "1728", ",", "2197", ",", "2744", ",",
              "3375", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "4913", ",", "5832", ",", "6859", ",", "8000", ",", "9261", ",",
              "10648", ",", "12167", ",", "13824", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "17576", ",", "19683", ",", "21952", ",", "24389", ",", "27000",
              ",", "29791", ",", "32768", ",", "35937", ",", "39304", ",", 
             "42875", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "50653", ",", "54872", ",", "59319", ",", "64000", ",", "68921",
              ",", "74088", ",", "79507", ",", "85184", ",", "91125", ",", 
             "97336", ",", "103823", ",", "110592", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "125000", ",", "132651", ",", "140608", ",", "148877", ",", 
             "157464", ",", "166375", ",", "175616", ",", "185193", ",", 
             "195112", ",", "205379", ",", "216000", ",", "226981", ",", 
             "238328", ",", "250047", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "274625", ",", "287496", ",", "300763", ",", "314432", ",", 
             "328509", ",", "343000", ",", "357911", ",", "373248", ",", 
             "389017", ",", "405224", ",", "421875", ",", "438976", ",", 
             "456533", ",", "474552", ",", "493039", ",", "512000", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "551368", ",", "571787", ",", "592704", ",", "614125", ",", 
             "636056", ",", "658503", ",", "681472", ",", "704969", ",", 
             "729000", ",", "753571", ",", "778688", ",", "804357", ",", 
             "830584", ",", "857375", ",", "884736", ",", "912673", ",", 
             "941192", ",", "970299", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2dc6e482-f160-4d6e-90c4-1cea159c143b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 100 primes, dropping ones whose first digit is \
less than 5.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f51d43e2-de81-4bba-be1d-75bced039931"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "5", ",", "7", ",", "53", ",", "59", ",", "61", ",", "67", ",", "71", 
         ",", "73", ",", "79", ",", "83", ",", "89", ",", "97", ",", "503", 
         ",", "509", ",", "521", ",", "523", ",", "541"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "57d99aca-b351-499b-8e6a-99719f77b7d3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"5", ",", "7", ",", "53", ",", "59", ",", "61", ",", "67", 
             ",", "71", ",", "73", ",", "79", ",", "83", ",", "89", ",", "97",
              ",", "503", ",", "509", ",", "521", ",", "523", ",", "541"}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d9b9d4a1-0cf8-4bb5-8853-9915e7565dc9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a grid starting with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", "10", "]"}]], "InlineCode",ExpressionUUID->
  "f0cede85-7dca-4a31-ad7b-9ed4fae8b37d"],
 ", then at each of 9 steps randomly removing another element.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"6caa739d-679d-457e-a674-3c14d916a7ce"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"},
          {"1", "2", "3", "5", "6", "7", "8", "9", "10", ""},
          {"1", "3", "5", "6", "7", "8", "9", "10", "", ""},
          {"3", "5", "6", "7", "8", "9", "10", "", "", ""},
          {"3", "6", "7", "8", "9", "10", "", "", "", ""},
          {"3", "6", "7", "9", "10", "", "", "", "", ""},
          {"3", "6", "7", "9", "", "", "", "", "", ""},
          {"6", "7", "9", "", "", "", "", "", "", ""},
          {"7", "9", "", "", "", "", "", "", "", ""},
          {"9", "", "", "", "", "", "", "", "", ""}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "319ef816-2a0e-4590-88df-04a26d02daf5"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}, {
            "1", "2", "3", "5", "6", "7", "8", "9", "10", ""}, {
            "1", "3", "5", "6", "7", "8", "9", "10", "", ""}, {
            "3", "5", "6", "7", "8", "9", "10", "", "", ""}, {
            "3", "6", "7", "8", "9", "10", "", "", "", ""}, {
            "3", "6", "7", "9", "10", "", "", "", "", ""}, {
            "3", "6", "7", "9", "", "", "", "", "", ""}, {
            "6", "7", "9", "", "", "", "", "", "", ""}, {
            "7", "9", "", "", "", "", "", "", "", ""}, {
            "9", "", "", "", "", "", "", "", "", ""}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9679deaf-d474-4165-95b7-04f37fffa613"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the longest 10 words in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "46c18a50-b0ad-4f11-b4d7-0d392ea5f423"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7af303fe-4b3a-45cb-bf4a-8790debd1595"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"electroencephalographic\"\>", 
         ",", "\<\"electroencephalograph\"\>", 
         ",", "\<\"counterrevolutionary\"\>", 
         ",", "\<\"buckminsterfullerene\"\>", 
         ",", "\<\"compartmentalization\"\>", 
         ",", "\<\"electroencephalogram\"\>", 
         ",", "\<\"internationalization\"\>", 
         ",", "\<\"uncharacteristically\"\>", 
         ",", "\<\"magnetohydrodynamics\"\>", 
         ",", "\<\"incomprehensibility\"\>"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"2d96b1fc-32a4-4478-bee4-e741b22ba0ea"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"electroencephalographic\"", ",", 
             "\"electroencephalograph\"", ",", "\"counterrevolutionary\"", 
             ",", "\"buckminsterfullerene\"", ",", "\"compartmentalization\"",
              ",", "\"electroencephalogram\"", ",", 
             "\"internationalization\"", ",", "\"uncharacteristically\"", ",",
              "\"magnetohydrodynamics\"", ",", "\"incomprehensibility\""}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aa1c9d6c-a8bc-40dd-88b3-03549f64c775"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the 5 longest integer names for integers up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1b0a2614-e0e0-461b-ae99-6850469d0abe"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"seventy\[Hyphen]seven\"\>", 
         ",", "\<\"seventy\[Hyphen]three\"\>", 
         ",", "\<\"seventy\[Hyphen]eight\"\>", 
         ",", "\<\"twenty\[Hyphen]three\"\>", 
         ",", "\<\"twenty\[Hyphen]eight\"\>"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"f5280583-b722-4b91-8bf8-c3cc293fb4c4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"seventy\[Hyphen]seven\"", ",", 
             "\"seventy\[Hyphen]three\"", ",", "\"seventy\[Hyphen]eight\"", 
             ",", "\"twenty\[Hyphen]three\"", ",", 
             "\"twenty\[Hyphen]eight\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a1aa981c-e44c-40e3-9a78-bfb5cc556ce6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the 5 English names for integers up to 100 that have the largest \
number of \[OpenCurlyDoubleQuote]e\[CloseCurlyDoubleQuote]s in them.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"0e783ee0-888d-4f99-8f9c-8f66af7b0831"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"seventy\[Hyphen]three\"\>", ",", "\<\"seventeen\"\>", 
         ",", "\<\"seventy\[Hyphen]seven\"\>", ",", "\<\"nineteen\"\>", 
         ",", "\<\"eleven\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "702024b1-6177-423d-aa5f-f3ba63130860"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"seventy\[Hyphen]three\"", ",", "\"seventeen\"", ",", 
             "\"seventy\[Hyphen]seven\"", ",", "\"nineteen\"", ",", 
             "\"eleven\""}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7dcffbf3-f65b-4a11-986d-2608472e7b4c"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:191",ExpressionUUID->"b13ab152-7221-42a3-8593-6cbdada8abeb"],

Cell[TextData[{
 "How does one read ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "CodeVariable"], "[", 
   RowBox[{"[", 
    StyleBox["n", "CodeVariable"], "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "fad585fb-0e2f-4408-857d-688edb6a32be"],
 " out loud?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"69be97ea-31e7-4558-8de9-6f94124f9b1b"],

Cell[TextData[{
 "Usually \[OpenCurlyDoubleQuote]",
 StyleBox["list",
  FontSlant->"Italic"],
 " part ",
 StyleBox["n",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]",
 StyleBox["list",
  FontSlant->"Italic"],
 " sub ",
 StyleBox["n",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote]. The second form (with \[OpenCurlyDoubleQuote]sub\
\[CloseCurlyDoubleQuote] short for \[OpenCurlyDoubleQuote]subscript\
\[CloseCurlyDoubleQuote]) comes from thinking about math and extracting \
components of vectors. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f704488c-00de-4564-94fb-de5a8281fb9c"],

Cell["\<\
What happens if one asks for a part of a list that doesn\[CloseCurlyQuote]t \
exist?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6375c944-253b-41fc-80ef-1debeb452516"],

Cell["\<\
One gets a message, and the original computation is returned undone.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"47ead86c-6ca2-46bb-bea0-47cefc2ad796"],

Cell["\<\
Can I just get the first position at which something appears in a list?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c7bceeef-acc3-486a-99c2-abc9f9396892"],

Cell[TextData[{
 "Yes. Use ",
 ButtonBox["FirstPosition",
  BaseStyle->"Link"],
 ". "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"c517f24f-ff5e-4e68-9a50-f6289c0d2d3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a2c5933a-ed2a-40d1-a335-5ae91d25d540"],

Cell[TextData[{
 ButtonBox["First",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Last",
  BaseStyle->"Link"],
 " are equivalent to ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{"[", "1", "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "7ed4ab8d-a921-4075-83e2-c06583682d54"],
 " and ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{"[", 
    RowBox[{"-", "1"}], "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "5823fa5b-56c3-4342-8986-405f26f9a83e"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3105cc3b-1094-4b6a-b59a-a60ccb44136e"],

Cell[TextData[{
 "In specifying parts, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", 
    ButtonBox[";;",
     BaseStyle->"Link",
     ButtonData->"Span"]}], "-", "1"}]], "InlineCode",ExpressionUUID->
  "80093580-2f41-4263-8ea1-98ef9979100f"],
 " is equivalent to ",
 ButtonBox["All",
  BaseStyle->"Link"],
 ". "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5854b77a-d64d-43c1-b1e0-ac79b29640ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e82751e-3fc6-4c13-b440-35a98a54802c"],

Cell[TextData[ButtonBox["Guide to Parts of Lists in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"87e659fd-4bdc-4a94-9e40-664e8f786c9d"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Parts of Lists: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Rearranging Lists\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Rearranging Lists", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-32-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-32-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Patterns\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Patterns", "Tooltip"]& ]}, "RowWithSeparators"], 
          Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->267,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Parts of Lists \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"54320b67-28a7-485d-bced-b3ef0fc5692b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:187"->{
  Cell[657, 23, 440, 11, 93, "SectionDoubleDigit",ExpressionUUID->"a8fccb13-5ffd-4647-af5e-25c0175db9f4",
   CounterAssignments->{{"Section", 30}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:187"]},
 "i:1"->{
  Cell[1100, 36, 247, 8, 40, "Text",ExpressionUUID->"b32116dd-9dc8-4a08-8e3a-cab11b1e25e6",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[1350, 46, 189, 4, 37, "CodeCaption",ExpressionUUID->"bc61c553-bbec-42fe-9783-253cad5515cd",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[3306, 121, 209, 4, 37, "CodeCaption",ExpressionUUID->"9e04b57f-c34c-47af-9910-b63def7e2f15",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[5009, 182, 412, 14, 41, "Text",ExpressionUUID->"6c3e783f-0cf1-48b8-83bd-1f9a430d0a26",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[6174, 225, 196, 4, 37, "CodeCaption",ExpressionUUID->"70c71a60-6451-44c3-9268-1ff1d8e74e63",
   CellTags->"i:5"]},
 "LastCellOfAPage"->{
  Cell[8179, 296, 277, 7, 70, "Output",ExpressionUUID->"4e599e86-67a6-4d44-80b2-b9e731204856",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[16953, 614, 441, 10, 70, "Output",ExpressionUUID->"7cdd4ac2-0048-424f-b725-fdfe5245d53e",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[25964, 932, 353, 8, 70, "Output",ExpressionUUID->"bf35d3e9-e00a-4ee2-aee1-b9d7ff4390aa",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[141261, 3806, 836, 22, 70, "Exercise",ExpressionUUID->"0e783ee0-888d-4f99-8f9c-8f66af7b0831",
   CellTags->"LastCellOfAPage"],
  Cell[147235, 4017, 344, 8, 70, "MoreExplore",ExpressionUUID->"87e659fd-4bdc-4a94-9e40-664e8f786c9d",
   CellTags->"LastCellOfAPage"]},
 "p:188"->{
  Cell[8471, 306, 331, 11, 70, "Text",ExpressionUUID->"1a93d94b-aa0c-4ce3-9e51-ae12b3215a31",
   CellTags->{"p:188", "i:6"}]},
 "i:6"->{
  Cell[8471, 306, 331, 11, 70, "Text",ExpressionUUID->"1a93d94b-aa0c-4ce3-9e51-ae12b3215a31",
   CellTags->{"p:188", "i:6"}]},
 "i:7"->{
  Cell[11345, 413, 282, 9, 70, "Text",ExpressionUUID->"1e0c0ce6-b517-4f41-8b0e-2fed2b98c5ae",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[12547, 457, 285, 9, 70, "Text",ExpressionUUID->"543a3198-d946-47a7-aee0-56e0888a21b9",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[12835, 468, 460, 13, 70, "CodeCaption",ExpressionUUID->"6d136ca9-3b0e-46db-8cfa-94b0291b7a38",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[15804, 574, 278, 7, 70, "Input",ExpressionUUID->"058a3cc5-b95e-40fe-85fe-2415a1b51da4",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[16403, 595, 235, 6, 70, "CodeCaption",ExpressionUUID->"e692b88a-bd2d-4fe0-a5f4-4afc83ff038c",
   CellTags->"i:11"]},
 "p:189"->{
  Cell[17409, 627, 281, 10, 70, "Text",ExpressionUUID->"750870f7-5bf9-4d0b-8256-2027ba33f486",
   CellTags->{"p:189", "i:12"}]},
 "i:12"->{
  Cell[17409, 627, 281, 10, 70, "Text",ExpressionUUID->"750870f7-5bf9-4d0b-8256-2027ba33f486",
   CellTags->{"p:189", "i:12"}]},
 "i:13"->{
  Cell[19479, 703, 358, 9, 70, "CodeCaption",ExpressionUUID->"e141874a-e730-4da5-9b69-dbfd1a569d57",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[20919, 744, 335, 12, 70, "Text",ExpressionUUID->"47425b83-c9b4-42a4-884a-fa04d9c49ef8",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[23962, 858, 428, 14, 70, "Text",ExpressionUUID->"82450695-91bd-45da-ba0c-6efeb7be47b1",
   CellTags->"i:15"]},
 "i:16"->{
  Cell[25403, 912, 250, 7, 70, "CodeCaption",ExpressionUUID->"3bc6c1d9-04d2-4224-b8f3-622ffb308acf",
   CellTags->"i:16"]},
 "p:190"->{
  Cell[26366, 946, 176, 4, 70, "VocabularySection",ExpressionUUID->"6c5c990d-7be2-45c3-97a5-3fab3d21a23c",
   CellTags->"p:190"]},
 "p:191"->{
  Cell[143638, 3876, 161, 4, 70, "QASection",ExpressionUUID->"b13ab152-7221-42a3-8593-6cbdada8abeb",
   CellTags->"p:191"]},
 "i:17"->{
  Cell[143802, 3882, 413, 13, 70, "Question",ExpressionUUID->"69be97ea-31e7-4558-8de9-6f94124f9b1b",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[145565, 3945, 235, 9, 70, "Answer",ExpressionUUID->"c517f24f-ff5e-4e68-9a50-f6289c0d2d3d",
   CellTags->"i:18"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:187", 238217, 5864},
 {"i:1", 238457, 5868},
 {"i:2", 238581, 5871},
 {"i:3", 238712, 5874},
 {"i:4", 238844, 5877},
 {"i:5", 238970, 5880},
 {"LastCellOfAPage", 239114, 5883},
 {"p:188", 239853, 5897},
 {"i:6", 239990, 5900},
 {"i:7", 240127, 5903},
 {"i:8", 240253, 5906},
 {"i:9", 240379, 5909},
 {"i:10", 240514, 5912},
 {"i:11", 240643, 5915},
 {"p:189", 240779, 5918},
 {"i:12", 240919, 5921},
 {"i:13", 241059, 5924},
 {"i:14", 241194, 5927},
 {"i:15", 241323, 5930},
 {"i:16", 241452, 5933},
 {"p:190", 241588, 5936},
 {"p:191", 241731, 5939},
 {"i:17", 241867, 5942},
 {"i:18", 242002, 5945}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[657, 23, 440, 11, 93, "SectionDoubleDigit",ExpressionUUID->"a8fccb13-5ffd-4647-af5e-25c0175db9f4",
 CounterAssignments->{{"Section", 30}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:187"],
Cell[1100, 36, 247, 8, 40, "Text",ExpressionUUID->"b32116dd-9dc8-4a08-8e3a-cab11b1e25e6",
 CellTags->"i:1"],
Cell[1350, 46, 189, 4, 37, "CodeCaption",ExpressionUUID->"bc61c553-bbec-42fe-9783-253cad5515cd",
 CellTags->"i:2"],
Cell[CellGroupData[{
Cell[1564, 54, 281, 7, 29, "Input",ExpressionUUID->"99eb67cb-18aa-42a6-99f9-d47c4919ceb6"],
Cell[1848, 63, 172, 4, 40, "Output",ExpressionUUID->"6d8d7e02-97b2-406d-bde7-9f0c734058cc",
 Evaluatable->False]
}, Open  ]],
Cell[2035, 70, 426, 16, 40, "Text",ExpressionUUID->"61e3908c-0dc1-4a29-aef8-78360c981c42"],
Cell[2464, 88, 352, 13, 37, "CodeCaption",ExpressionUUID->"9d300711-7053-44c0-8378-16bda4e5f0ca"],
Cell[CellGroupData[{
Cell[2841, 105, 275, 7, 29, "Input",ExpressionUUID->"3f360f90-40f7-4393-a89b-4697cc67c266"],
Cell[3119, 114, 172, 4, 40, "Output",ExpressionUUID->"024f73b2-81a5-4eff-98b4-3222aa39b08f",
 Evaluatable->False]
}, Open  ]],
Cell[3306, 121, 209, 4, 37, "CodeCaption",ExpressionUUID->"9e04b57f-c34c-47af-9910-b63def7e2f15",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[3540, 129, 294, 8, 29, "Input",ExpressionUUID->"35c3cbe9-50da-46ac-bc1d-c627be96e24a"],
Cell[3837, 139, 172, 4, 40, "Output",ExpressionUUID->"d4e926e0-e891-49c4-8858-37e4b1147fc5",
 Evaluatable->False]
}, Open  ]],
Cell[4024, 146, 209, 6, 40, "Text",ExpressionUUID->"b27d2635-a380-4f0c-bf23-b73cc2d1f653"],
Cell[4236, 154, 169, 4, 37, "CodeCaption",ExpressionUUID->"0446d446-f47b-4829-a12b-ed4a7892c015"],
Cell[CellGroupData[{
Cell[4430, 162, 334, 9, 29, "Input",ExpressionUUID->"83f50f17-3ea3-464c-a9fd-8c5d2a671c6c"],
Cell[4767, 173, 227, 6, 40, "Output",ExpressionUUID->"6bb11784-d443-48e6-af46-1072819e672f",
 Evaluatable->False]
}, Open  ]],
Cell[5009, 182, 412, 14, 41, "Text",ExpressionUUID->"6c3e783f-0cf1-48b8-83bd-1f9a430d0a26",
 CellTags->"i:4"],
Cell[5424, 198, 170, 4, 37, "CodeCaption",ExpressionUUID->"a23033db-8073-4229-ab4d-ca49c8cef051"],
Cell[CellGroupData[{
Cell[5619, 206, 300, 8, 29, "Input",ExpressionUUID->"755c82b1-0044-47e0-b594-6be35adefffe"],
Cell[5922, 216, 237, 6, 40, "Output",ExpressionUUID->"eccd6a65-cff0-481f-bbdd-4956df809919",
 Evaluatable->False]
}, Open  ]],
Cell[6174, 225, 196, 4, 37, "CodeCaption",ExpressionUUID->"70c71a60-6451-44c3-9268-1ff1d8e74e63",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[6395, 233, 281, 7, 70, "Input",ExpressionUUID->"51bfef22-3c3f-47fc-bafd-1a6527da22a4"],
Cell[6679, 242, 237, 6, 70, "Output",ExpressionUUID->"a7e4f8d8-c1a7-47a4-9654-456f8c446d2c",
 Evaluatable->False]
}, Open  ]],
Cell[6931, 251, 180, 4, 70, "CodeCaption",ExpressionUUID->"ef70786b-3bb6-44f5-bbe8-cac76a07381f"],
Cell[CellGroupData[{
Cell[7136, 259, 300, 8, 70, "Input",ExpressionUUID->"083b152c-b900-4fa1-a687-f99be47c004c"],
Cell[7439, 269, 217, 6, 70, "Output",ExpressionUUID->"a06768ca-e5c1-44f5-806f-81ccd92b9156",
 Evaluatable->False]
}, Open  ]],
Cell[7671, 278, 180, 4, 70, "CodeCaption",ExpressionUUID->"6974a2c4-3c26-4505-9047-ab4d9c4e0bc2"],
Cell[CellGroupData[{
Cell[7876, 286, 300, 8, 70, "Input",ExpressionUUID->"83a2ae07-e397-4e73-bec8-82df19c5c2a1"],
Cell[8179, 296, 277, 7, 70, "Output",ExpressionUUID->"4e599e86-67a6-4d44-80b2-b9e731204856",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[8471, 306, 331, 11, 70, "Text",ExpressionUUID->"1a93d94b-aa0c-4ce3-9e51-ae12b3215a31",
 CellTags->{"p:188", "i:6"}],
Cell[CellGroupData[{
Cell[8827, 321, 393, 12, 70, "Input",ExpressionUUID->"ec7c9e2c-d360-44e8-817d-6344770ca3b3"],
Cell[9223, 335, 363, 12, 70, "Output",ExpressionUUID->"ceffa229-4032-4987-a5be-55e295902276",
 Evaluatable->False]
}, Open  ]],
Cell[9601, 350, 226, 6, 70, "CodeCaption",ExpressionUUID->"27a179a9-a74b-4e80-a777-5804917dced5"],
Cell[CellGroupData[{
Cell[9852, 360, 415, 12, 70, "Input",ExpressionUUID->"95eadefd-ac89-4f90-95e0-b056e2b6004d"],
Cell[10270, 374, 228, 6, 70, "Output",ExpressionUUID->"eac770c7-23fd-4ad2-b8e3-252b0c42d950",
 Evaluatable->False]
}, Open  ]],
Cell[10513, 383, 177, 4, 70, "CodeCaption",ExpressionUUID->"38846755-ecf1-4c09-af74-5260c7f637ad"],
Cell[CellGroupData[{
Cell[10715, 391, 439, 13, 70, "Input",ExpressionUUID->"e704ee57-cdff-4f43-82ed-9b9d94f40930"],
Cell[11157, 406, 173, 4, 70, "Output",ExpressionUUID->"d2c97f36-4972-46be-95f6-dc9eb6ae9d9f",
 Evaluatable->False]
}, Open  ]],
Cell[11345, 413, 282, 9, 70, "Text",ExpressionUUID->"1e0c0ce6-b517-4f41-8b0e-2fed2b98c5ae",
 CellTags->"i:7"],
Cell[11630, 424, 205, 5, 70, "CodeCaption",ExpressionUUID->"f1640c1c-0955-4da3-8562-18fce19a0988"],
Cell[CellGroupData[{
Cell[11860, 433, 441, 13, 70, "Input",ExpressionUUID->"de30103c-18d0-4b00-89a3-6d97ee508b7a"],
Cell[12304, 448, 228, 6, 70, "Output",ExpressionUUID->"3997884a-bc59-48e2-9a31-8a7de873fb41",
 Evaluatable->False]
}, Open  ]],
Cell[12547, 457, 285, 9, 70, "Text",ExpressionUUID->"543a3198-d946-47a7-aee0-56e0888a21b9",
 CellTags->"i:8"],
Cell[12835, 468, 460, 13, 70, "CodeCaption",ExpressionUUID->"6d136ca9-3b0e-46db-8cfa-94b0291b7a38",
 CellTags->"i:9"],
Cell[CellGroupData[{
Cell[13320, 485, 433, 13, 70, "Input",ExpressionUUID->"1dc65329-fa24-4225-8520-596f543f0448"],
Cell[13756, 500, 242, 7, 70, "Output",ExpressionUUID->"ffccff7e-7f07-4ee9-b958-45e0b4d57e2c",
 Evaluatable->False]
}, Open  ]],
Cell[14013, 510, 308, 9, 70, "CodeCaption",ExpressionUUID->"81e46d9e-ecb3-4f9c-9cb5-6881f039de81"],
Cell[CellGroupData[{
Cell[14346, 523, 506, 15, 70, "Input",ExpressionUUID->"6cbc6a9a-0368-404f-8c9f-2ca003bd397a"],
Cell[14855, 540, 552, 18, 70, "Output",ExpressionUUID->"55fe5805-eb69-4eb1-b59c-55d7ec7d7ec1",
 Evaluatable->False]
}, Open  ]],
Cell[15422, 561, 357, 9, 70, "CodeCaption",ExpressionUUID->"9345a388-29e9-4f90-89d4-e0c11d17ab5f"],
Cell[CellGroupData[{
Cell[15804, 574, 278, 7, 70, "Input",ExpressionUUID->"058a3cc5-b95e-40fe-85fe-2415a1b51da4",
 CellTags->"i:10"],
Cell[16085, 583, 303, 9, 70, "Output",ExpressionUUID->"b0cb9d1f-1bc5-45ef-837d-81ed730410ee",
 Evaluatable->False]
}, Open  ]],
Cell[16403, 595, 235, 6, 70, "CodeCaption",ExpressionUUID->"e692b88a-bd2d-4fe0-a5f4-4afc83ff038c",
 CellTags->"i:11"],
Cell[CellGroupData[{
Cell[16663, 605, 287, 7, 70, "Input",ExpressionUUID->"8542cef4-0762-44ee-918c-81af95dd415c"],
Cell[16953, 614, 441, 10, 70, "Output",ExpressionUUID->"7cdd4ac2-0048-424f-b725-fdfe5245d53e",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[17409, 627, 281, 10, 70, "Text",ExpressionUUID->"750870f7-5bf9-4d0b-8256-2027ba33f486",
 CellTags->{"p:189", "i:12"}],
Cell[17693, 639, 276, 9, 70, "CodeCaption",ExpressionUUID->"6062972c-f737-434c-abdf-b4df8b7c2864"],
Cell[CellGroupData[{
Cell[17994, 652, 319, 8, 70, "Input",ExpressionUUID->"ed1c6069-db6c-487b-9e61-216fbc1a84f7"],
Cell[18316, 662, 271, 7, 70, "Output",ExpressionUUID->"a3d574a0-8896-4065-8e79-65752bbb6f19",
 Evaluatable->False]
}, Open  ]],
Cell[18602, 672, 161, 4, 70, "CodeCaption",ExpressionUUID->"216ca28c-0ae4-404f-8474-4c1dd0ee90ad"],
Cell[CellGroupData[{
Cell[18788, 680, 402, 11, 70, "Input",ExpressionUUID->"7dfc2a2d-d850-4bb3-9602-7140c802f086"],
Cell[19193, 693, 271, 7, 70, "Output",ExpressionUUID->"d8a60895-c428-40fd-948a-fa7d0c37931f",
 Evaluatable->False]
}, Open  ]],
Cell[19479, 703, 358, 9, 70, "CodeCaption",ExpressionUUID->"e141874a-e730-4da5-9b69-dbfd1a569d57",
 CellTags->"i:13"],
Cell[CellGroupData[{
Cell[19862, 716, 457, 12, 70, "Input",ExpressionUUID->"a195799a-fc1e-4e32-b1c0-41208679c041"],
Cell[20322, 730, 582, 11, 70, "Output",ExpressionUUID->"3260addf-840a-4e28-884d-fcc389c00465",
 Evaluatable->False]
}, Open  ]],
Cell[20919, 744, 335, 12, 70, "Text",ExpressionUUID->"47425b83-c9b4-42a4-884a-fa04d9c49ef8",
 CellTags->"i:14"],
Cell[21257, 758, 219, 8, 70, "CodeCaption",ExpressionUUID->"774e7bce-82e6-49d7-99da-0cc6ce4dcd48"],
Cell[CellGroupData[{
Cell[21501, 770, 225, 5, 70, "Input",ExpressionUUID->"206bda50-3dc1-46c9-a3f7-448b3bf4b5d6"],
Cell[21729, 777, 238, 6, 70, "Output",ExpressionUUID->"db2591a3-3bec-4146-961f-70c878734bb4",
 Evaluatable->False]
}, Open  ]],
Cell[21982, 786, 235, 9, 70, "CodeCaption",ExpressionUUID->"b4f688d1-aca2-4aee-9f90-356ddc41d08e"],
Cell[CellGroupData[{
Cell[22242, 799, 414, 11, 70, "Input",ExpressionUUID->"6abe2b5d-77ac-473b-b3bc-bf4dc46169ff"],
Cell[22659, 812, 248, 6, 70, "Output",ExpressionUUID->"a782cf0f-0243-4555-a7b0-781e1e8f034a",
 Evaluatable->False]
}, Open  ]],
Cell[22922, 821, 236, 7, 70, "CodeCaption",ExpressionUUID->"17f806dd-ce02-43f7-9363-7841f3b57f04"],
Cell[CellGroupData[{
Cell[23183, 832, 471, 14, 70, "Input",ExpressionUUID->"527ea75d-ff4b-4cd5-93b9-d2d50e22f1b6"],
Cell[23657, 848, 290, 7, 70, "Output",ExpressionUUID->"1fefa1f8-43e4-42f9-a262-3398182bd290",
 Evaluatable->False]
}, Open  ]],
Cell[23962, 858, 428, 14, 70, "Text",ExpressionUUID->"82450695-91bd-45da-ba0c-6efeb7be47b1",
 CellTags->"i:15"],
Cell[24393, 874, 184, 4, 70, "CodeCaption",ExpressionUUID->"edc697f9-335c-4a5d-b811-9603e9ada772"],
Cell[CellGroupData[{
Cell[24602, 882, 219, 5, 70, "Input",ExpressionUUID->"245bc596-ed6e-4bd0-a5f3-4950fd10a331"],
Cell[24824, 889, 255, 7, 70, "Output",ExpressionUUID->"b3294680-ee1c-45fb-8cf6-1b22a3df1790",
 Evaluatable->False]
}, Open  ]],
Cell[25094, 899, 306, 11, 70, "Text",ExpressionUUID->"897e20c7-f38b-4c02-8a78-270611c38734"],
Cell[25403, 912, 250, 7, 70, "CodeCaption",ExpressionUUID->"3bc6c1d9-04d2-4224-b8f3-622ffb308acf",
 CellTags->"i:16"],
Cell[CellGroupData[{
Cell[25678, 923, 283, 7, 70, "Input",ExpressionUUID->"532c42da-863d-423e-a9dd-c0b991071fb6"],
Cell[25964, 932, 353, 8, 70, "Output",ExpressionUUID->"bf35d3e9-e00a-4ee2-aee1-b9d7ff4390aa",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26366, 946, 176, 4, 70, "VocabularySection",ExpressionUUID->"6c5c990d-7be2-45c3-97a5-3fab3d21a23c",
 CellTags->"p:190"],
Cell[26545, 952, 8768, 251, 70, "VocabularyTable",ExpressionUUID->"f9c3e703-06cb-46b5-b7bf-172462d02d37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35350, 1208, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"03ba83cc-e8b2-42d0-9bb8-c1bfc148d402"],
Cell[CellGroupData[{
Cell[37155, 1258, 1269, 40, 70, "ExerciseSummaryCell",ExpressionUUID->"261006c9-d2e8-42dc-9808-3fdc37ee000d"],
Cell[CellGroupData[{
Cell[38449, 1302, 698, 20, 70, "Exercise",ExpressionUUID->"1298d92a-89fa-44a3-9fd6-a0503d226bd4"],
Cell[39150, 1324, 1254, 36, 70, "ExerciseOutput",ExpressionUUID->"a0cedab9-6053-442d-8293-b5444151ec9c"]
}, Closed]],
Cell[CellGroupData[{
Cell[40441, 1365, 712, 20, 70, "Exercise",ExpressionUUID->"f0475986-963a-4e1a-94c1-57a7db8f0107"],
Cell[41156, 1387, 1568, 41, 70, "ExerciseOutput",ExpressionUUID->"ff0017a7-5dd3-4110-88d6-a6067da833f4"]
}, Closed]],
Cell[CellGroupData[{
Cell[42761, 1433, 735, 20, 70, "Exercise",ExpressionUUID->"202dee62-1c63-48cf-bbd7-f3a0bef30148"],
Cell[43499, 1455, 1642, 42, 70, "ExerciseOutput",ExpressionUUID->"41eff8cc-8fc7-4b75-99e3-235df04d673a"]
}, Closed]],
Cell[CellGroupData[{
Cell[45178, 1502, 740, 20, 70, "Exercise",ExpressionUUID->"d4bb689f-e490-4195-a392-1494328fa920"],
Cell[45921, 1524, 4005, 92, 70, "ExerciseOutput",ExpressionUUID->"0ea5af2a-a294-4cab-b17b-303d6173090d"]
}, Closed]],
Cell[CellGroupData[{
Cell[49963, 1621, 767, 21, 70, "Exercise",ExpressionUUID->"25753c30-29a9-497f-b88c-4e75134e8f48"],
Cell[50733, 1644, 1401, 39, 70, "ExerciseOutput",ExpressionUUID->"dfb6721a-1d6a-40cc-9b7e-f7cecd19db10"]
}, Closed]],
Cell[CellGroupData[{
Cell[52171, 1688, 840, 22, 70, "Exercise",ExpressionUUID->"4ab4ac20-d6dd-4b13-9439-3dededbb035c"],
Cell[53014, 1712, 1507, 40, 70, "ExerciseOutput",ExpressionUUID->"bffe8356-130b-41bc-b238-90139b2d7850"]
}, Closed]],
Cell[CellGroupData[{
Cell[54558, 1757, 952, 27, 70, "Exercise",ExpressionUUID->"2a54673a-d39b-40ff-862c-96be846cafc7"],
Cell[55513, 1786, 33369, 800, 70, "ExerciseOutput",ExpressionUUID->"17de1795-dcea-4189-a9c3-e6200fe1e469"]
}, Closed]],
Cell[CellGroupData[{
Cell[88919, 2591, 803, 24, 70, "Exercise",ExpressionUUID->"17947a30-1dcd-4104-9e9d-d1388b5f3b74"],
Cell[89725, 2617, 40237, 867, 70, "ExerciseOutput",ExpressionUUID->"2dc6e482-f160-4d6e-90c4-1cea159c143b"]
}, Closed]],
Cell[CellGroupData[{
Cell[129999, 3489, 751, 21, 70, "Exercise",ExpressionUUID->"f51d43e2-de81-4bba-be1d-75bced039931"],
Cell[130753, 3512, 1606, 42, 70, "ExerciseOutput",ExpressionUUID->"d9b9d4a1-0cf8-4bb5-8853-9915e7565dc9"]
}, Closed]],
Cell[CellGroupData[{
Cell[132396, 3559, 925, 26, 70, "Exercise",ExpressionUUID->"6caa739d-679d-457e-a674-3c14d916a7ce"],
Cell[133324, 3587, 2604, 61, 70, "ExerciseOutput",ExpressionUUID->"9679deaf-d474-4165-95b7-04f37fffa613"]
}, Closed]],
Cell[CellGroupData[{
Cell[135965, 3653, 871, 26, 70, "Exercise",ExpressionUUID->"7af303fe-4b3a-45cb-bf4a-8790debd1595"],
Cell[136839, 3681, 2027, 50, 70, "ExerciseOutput",ExpressionUUID->"aa1c9d6c-a8bc-40dd-88b3-03549f64c775"]
}, Closed]],
Cell[CellGroupData[{
Cell[138903, 3736, 722, 20, 70, "Exercise",ExpressionUUID->"1b0a2614-e0e0-461b-ae99-6850469d0abe"],
Cell[139628, 3758, 1596, 43, 70, "ExerciseOutput",ExpressionUUID->"a1aa981c-e44c-40e3-9a78-bfb5cc556ce6"]
}, Closed]],
Cell[CellGroupData[{
Cell[141261, 3806, 836, 22, 70, "Exercise",ExpressionUUID->"0e783ee0-888d-4f99-8f9c-8f66af7b0831",
 CellTags->"LastCellOfAPage"],
Cell[142100, 3830, 1477, 39, 70, "ExerciseOutput",ExpressionUUID->"7dcffbf3-f65b-4a11-986d-2608472e7b4c"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[143638, 3876, 161, 4, 70, "QASection",ExpressionUUID->"b13ab152-7221-42a3-8593-6cbdada8abeb",
 CellTags->"p:191"],
Cell[143802, 3882, 413, 13, 70, "Question",ExpressionUUID->"69be97ea-31e7-4558-8de9-6f94124f9b1b",
 CellTags->"i:17"],
Cell[144218, 3897, 670, 21, 70, "Answer",ExpressionUUID->"f704488c-00de-4564-94fb-de5a8281fb9c"],
Cell[144891, 3920, 232, 7, 70, "Question",ExpressionUUID->"6375c944-253b-41fc-80ef-1debeb452516"],
Cell[145126, 3929, 214, 6, 70, "Answer",ExpressionUUID->"47ead86c-6ca2-46bb-bea0-47cefc2ad796"],
Cell[145343, 3937, 219, 6, 70, "Question",ExpressionUUID->"c7bceeef-acc3-486a-99c2-abc9f9396892"],
Cell[145565, 3945, 235, 9, 70, "Answer",ExpressionUUID->"c517f24f-ff5e-4e68-9a50-f6289c0d2d3d",
 CellTags->"i:18"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145837, 3959, 157, 4, 70, "TechNoteSection",ExpressionUUID->"a2c5933a-ed2a-40d1-a335-5ae91d25d540"],
Cell[145997, 3965, 583, 22, 70, "TechNote",ExpressionUUID->"3105cc3b-1094-4b6a-b59a-a60ccb44136e"],
Cell[146583, 3989, 447, 17, 70, "TechNote",ExpressionUUID->"5854b77a-d64d-43c1-b1e0-ac79b29640ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147067, 4011, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"5e82751e-3fc6-4c13-b440-35a98a54802c"],
Cell[147235, 4017, 344, 8, 70, "MoreExplore",ExpressionUUID->"87e659fd-4bdc-4a94-9e40-664e8f786c9d",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature 0IjTXhueEtE9uL#VaIWWup55 *)
