(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    337423,       6989]
NotebookOptionsPosition[    266370,       5495]
NotebookOutlinePosition[    326024,       6721]
CellTagsIndexPosition[    325945,       6716]
WindowTitle->Parts of Lists: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Find the last 5 digits in 2^1000.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"7a9c6fed-b6cd-4165-b465-f582ef5ef383"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7293f8cd-24cd-4470-92fd-5204944d553a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVi2P3DAQjVpSWKm/oH8guDQqKop01bGQO/VyKrlGd5Wq0LDAMLOgoKAg
o5CgkJAQE4OQkACDFBgYbGec7FfX3oVLdqRdXeLn8XvjN3P7+fHXXfjOcZy3
D/B19/DHe319iL9/hIf7l7efzy9PP769/H56fnr98vgeXn6Cz1f44N+bW9zi
FpdD0DR03aiX+KDE0NCqrCibpH3L3NVVWdJuEOcSy6mtMVXLRjtk6I9jsJ97
zG0uQs8LknZSK6eeQNeHaTWqzcwK5yAKZsqphtTDVdfF75gO5kPH2tdJNMrx
00aZYH3mOcfhZp0x4Qm3v4zmAeDTdgV0meNkmrHQWWOOD6JMiVHHWMcAKjnw
UlUMNCOjEjVSz024Zl+jcq+dzYqVVBAoKgfpfmeGmbkx2OJmiy1kj0JmPLoC
aGo5bxcdZNzu3YwUtuTswhbRJHYhO0EMyhsUzLxo4dYTIEOWt7wIFmL6avyG
wY3leUGZMHpBC3FSsaUID1ln7ZR5GvumDNC7xXkdQxkCiJvPtHJjmjxkFryO
oFjaZkuz4JlxEqCzvXoy5JQcveoGCSHJ4n9icQOkJNsOOCN20QF+9fPetmzj
pniJN1WxVLdXLfbgci0Kj+yZBW+yJI4T0rQVXs9ZkkpONMM7qQZLuTerRQtu
nVd2bpLoairBsKxJja8Q7DYrqRkAtgGyC4k37uC8My3uaake9bZWvQOFCwl6
+7y3cZMsxyZtcbxztPDSvCP0pBMQNk1dGa9drBhMJi+hu0PU1ERB0rCBdyUO
2KhCGScwClVz45qNYhqq1F8LfgJbQg8QsjeoAWbitjY4kavYdWpt9PAPtoM6
LrplOdDDfXeKmtrQ3c78kKx+OYHJsVvcvP5zoNwIW6InvuMdCDHBDNyOp5Ye
COnBFjULMcu9W/DKDsu17BIIOnxjhCmJydQl2GlYYP9zYyBkW4HFZt6utscx
okWcoj8/c64Ck22OHvP2jSzbIg3DxPx7ZB75eOZH1xVhkqZRlOT84u3e4hrx
D1uxzZs=
            "], {{0, 19}, {67, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{67, 19},
          PlotRange->{{0, 67}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{71, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f7285fc1-4133-4ee4-b48d-e4e96a542b83"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVi2P3DAQjVpSWKm/oH8guDQqKop01bGQO/VyKrlGd5Wq0LDAMLOgoKAg
o5CgkJAQE4OQkACDFBgYbGec7FfX3oVLdqRdXeLn8XvjN3P7+fHXXfjOcZy3
D/B19/DHe319iL9/hIf7l7efzy9PP769/H56fnr98vgeXn6Cz1f44N+bW9zi
FpdD0DR03aiX+KDE0NCqrCibpH3L3NVVWdJuEOcSy6mtMVXLRjtk6I9jsJ97
zG0uQs8LknZSK6eeQNeHaTWqzcwK5yAKZsqphtTDVdfF75gO5kPH2tdJNMrx
00aZYH3mOcfhZp0x4Qm3v4zmAeDTdgV0meNkmrHQWWOOD6JMiVHHWMcAKjnw
UlUMNCOjEjVSz024Zl+jcq+dzYqVVBAoKgfpfmeGmbkx2OJmiy1kj0JmPLoC
aGo5bxcdZNzu3YwUtuTswhbRJHYhO0EMyhsUzLxo4dYTIEOWt7wIFmL6avyG
wY3leUGZMHpBC3FSsaUID1ln7ZR5GvumDNC7xXkdQxkCiJvPtHJjmjxkFryO
oFjaZkuz4JlxEqCzvXoy5JQcveoGCSHJ4n9icQOkJNsOOCN20QF+9fPetmzj
pniJN1WxVLdXLfbgci0Kj+yZBW+yJI4T0rQVXs9ZkkpONMM7qQZLuTerRQtu
nVd2bpLoairBsKxJja8Q7DYrqRkAtgGyC4k37uC8My3uaake9bZWvQOFCwl6
+7y3cZMsxyZtcbxztPDSvCP0pBMQNk1dGa9drBhMJi+hu0PU1ERB0rCBdyUO
2KhCGScwClVz45qNYhqq1F8LfgJbQg8QsjeoAWbitjY4kavYdWpt9PAPtoM6
LrplOdDDfXeKmtrQ3c78kKx+OYHJsVvcvP5zoNwIW6InvuMdCDHBDNyOp5Ye
COnBFjULMcu9W/DKDsu17BIIOnxjhCmJydQl2GlYYP9zYyBkW4HFZt6utscx
okWcoj8/c64Ck22OHvP2jSzbIg3DxPx7ZB75eOZH1xVhkqZRlOT84u3e4hrx
D1uxzZs=
              "], {{0, 19}, {67, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {67, 19}, 
            PlotRange -> {{0, 67}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3ce822a4-1eda-4940-9d50-1133591ef640"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"39a614cb-18db-44b2-83cc-720eb1b463e6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"78e003b8-c6e7-42b5-866f-4bf933befc9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"79045a4d-baf5-4c45-8dd2-388107b6d4de"],

Cell["Pick out letters 10 through 20 in the alphabet.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"ea383825-5cc5-45c8-8410-968d2b49dd9e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"91e6c9fb-3e8c-489e-b037-c24438794022"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztV6+P5TYQjlpysFL/gv4DxkcNiyJdVRZyp25OJdtor1IVGhbppCosLCgo
KOihkCCTgJqEuFJISECAiUHA69hO8rL7nB+7V5iRdpWXfP48M59nbP/06Y8P
7neWZX15B/8+fPwLPz199H/5AX78+vjl98+PD7/9/Pjnw+eHp/efvoeXP8Lf
3/Ann6+nnXbaaac9t2EQg/mLYFXV9CsfXw077W3WX0IXIY8KyDS1LQtHlQHF
CbKsgPQ7ZAdhp63bIMD0auepi7ETkG5c/JzGcNJww7yFF0MTe25UNAYKUYGO
UbWnwkHYaetWhQiWu3oc6kviWBYK9c8rryLIrtilEBU+JtYhGCwffptz+bxD
z/mRDivZj3bi4eDsr6CUxbGOHcTWVyUWiuj8s05sC0U6oYJKsfjIwwKEE8pN
vt5UGJoLyO1nbBtm8pMFGIdZ5kGvhAXjJqytAiyfLRwYp51HRXk+IpFXdevB
9jR0FDt4mJSrMijOIEm0Jxb2SbvKOXRVYGtKJ/Ad28/NtDq6NHUl0qYGkChj
VxNhL2aGeHnmjUGCX15WwysaYwvFGstSZxYOymw11VoF8EBQR3qdmPXYFotX
OugwIyQLtNteUlRlAqNwbNorF6P8tKQkXd1VrzJdvgS6OaFFKh/tPc4wJ3WV
y4hQ2K1wekqmrKxIHslU4tgc3sTpJXlJ6nvt9Y6TENbUReD6xiS1yhnkxUVZ
VI2UqFYCwVPPCvAETy1xK9XqU0yqWCWrNadgTyy1owWlzgqP0NyNBaiF1iTQ
owo9asggGDczrm3V0q2sGfNUBrA83doIVZzhdBDqS1g5mJhKm8vOY6UTS71Y
50ZOOyLGj9dJLD8lm4dlmQq8aIMDy9SiqkNVccWc2k2xHGsye6WsthluX3Ws
PMZzjSyft0dBW7j18BfWXGQ1zeEo7cwSvPBT1AkMjE2NuCvDJSfdFEs1n7Vu
DjZUWaD7ru1n5kI2pELEaszQ13JwUBhDeOGJEssrSI5lF6QGzK7Dz/hfK9bo
1Ua6elVZl6nsSSg9Ne0di66urJUqr1TWc8X3xTpwuGJlqtq+MYcqFYtPeiEl
REbFZFuZFuo83VD7CPb8yy1QfusbtdpCc+g29zC1o7lJJQvdRLIv1s4onS7l
8Mrs8IqwlhaR2ohKM6dqWZYdlHXDiEwdtAtuRHaFXNdOVHcdvUSqKmIz8sWO
fwegqWf7Kes4bwn46aTMQHIVGWQXBbRtWCvnUYeKWIzxLU6Ds1g6ahTdlpB6
M/WiTm60diruYTCXqsCSX9dJRrFkcx4PABzODaNYO6NUG9SJNcx+5Syf2zX2
0m4p4jNOJRbGE9Sn/QoSuqvSXeNsJEvCPPtzP+8BTZnY81biRHJrNYZAU90q
9Ya+rGVV5uF0dKfzlVZW3Fq9L8wEE30/3oYOkhzgfBVy4P3swgpSn5fg2CCx
fAu5oBzGW890kN7z0wRQ8y1udmYSwecAatUWNUC3ROzG//xbk0IeV6DXtRd5
XE3pTvvdhh0kefOob0KuXFJ2OecmvIs84t4eRpBEHpkWu7kgaei6Qf5V9QQ7
YnK5tazdv9dvww6SvHnUNyHljQzdX/93OWG/RurisIs84t4eRlxCzwsS0/X5
tNNO+3/sP7UfCFM=
            "], {{0, 19}, {143, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{143, 19},
          PlotRange->{{0, 143}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{147, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bb412456-6495-4db2-99f9-b15151978da9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztV6+P5TYQjlpysFL/gv4DxkcNiyJdVRZyp25OJdtor1IVGhbppCosLCgo
KOihkCCTgJqEuFJISECAiUHA69hO8rL7nB+7V5iRdpWXfP48M59nbP/06Y8P
7neWZX15B/8+fPwLPz199H/5AX78+vjl98+PD7/9/Pjnw+eHp/efvoeXP8Lf
3/Ann6+nnXbaaac9t2EQg/mLYFXV9CsfXw077W3WX0IXIY8KyDS1LQtHlQHF
CbKsgPQ7ZAdhp63bIMD0auepi7ETkG5c/JzGcNJww7yFF0MTe25UNAYKUYGO
UbWnwkHYaetWhQiWu3oc6kviWBYK9c8rryLIrtilEBU+JtYhGCwffptz+bxD
z/mRDivZj3bi4eDsr6CUxbGOHcTWVyUWiuj8s05sC0U6oYJKsfjIwwKEE8pN
vt5UGJoLyO1nbBtm8pMFGIdZ5kGvhAXjJqytAiyfLRwYp51HRXk+IpFXdevB
9jR0FDt4mJSrMijOIEm0Jxb2SbvKOXRVYGtKJ/Ad28/NtDq6NHUl0qYGkChj
VxNhL2aGeHnmjUGCX15WwysaYwvFGstSZxYOymw11VoF8EBQR3qdmPXYFotX
OugwIyQLtNteUlRlAqNwbNorF6P8tKQkXd1VrzJdvgS6OaFFKh/tPc4wJ3WV
y4hQ2K1wekqmrKxIHslU4tgc3sTpJXlJ6nvt9Y6TENbUReD6xiS1yhnkxUVZ
VI2UqFYCwVPPCvAETy1xK9XqU0yqWCWrNadgTyy1owWlzgqP0NyNBaiF1iTQ
owo9asggGDczrm3V0q2sGfNUBrA83doIVZzhdBDqS1g5mJhKm8vOY6UTS71Y
50ZOOyLGj9dJLD8lm4dlmQq8aIMDy9SiqkNVccWc2k2xHGsye6WsthluX3Ws
PMZzjSyft0dBW7j18BfWXGQ1zeEo7cwSvPBT1AkMjE2NuCvDJSfdFEs1n7Vu
DjZUWaD7ru1n5kI2pELEaszQ13JwUBhDeOGJEssrSI5lF6QGzK7Dz/hfK9bo
1Ua6elVZl6nsSSg9Ne0di66urJUqr1TWc8X3xTpwuGJlqtq+MYcqFYtPeiEl
REbFZFuZFuo83VD7CPb8yy1QfusbtdpCc+g29zC1o7lJJQvdRLIv1s4onS7l
8Mrs8IqwlhaR2ohKM6dqWZYdlHXDiEwdtAtuRHaFXNdOVHcdvUSqKmIz8sWO
fwegqWf7Kes4bwn46aTMQHIVGWQXBbRtWCvnUYeKWIzxLU6Ds1g6ahTdlpB6
M/WiTm60diruYTCXqsCSX9dJRrFkcx4PABzODaNYO6NUG9SJNcx+5Syf2zX2
0m4p4jNOJRbGE9Sn/QoSuqvSXeNsJEvCPPtzP+8BTZnY81biRHJrNYZAU90q
9Ya+rGVV5uF0dKfzlVZW3Fq9L8wEE30/3oYOkhzgfBVy4P3swgpSn5fg2CCx
fAu5oBzGW890kN7z0wRQ8y1udmYSwecAatUWNUC3ROzG//xbk0IeV6DXtRd5
XE3pTvvdhh0kefOob0KuXFJ2OecmvIs84t4eRpBEHpkWu7kgaei6Qf5V9QQ7
YnK5tazdv9dvww6SvHnUNyHljQzdX/93OWG/RurisIs84t4eRlxCzwsS0/X5
tNNO+3/sP7UfCFM=
              "], {{0, 19}, {143, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {143, 19}, 
            PlotRange -> {{0, 143}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7f8120f6-4bbb-49e7-9953-5bdaa7e2e8ba"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b886e282-f62c-4ea5-bc39-337fa44cc6b5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bad766be-3371-45b7-8968-4c7f0ce7dc57"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"cf39158f-3244-4ed8-84fb-88729253ae48"],

Cell["\<\
Make a list of the letters at even-numbered positions in the alphabet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"ca52b166-747e-4c60-ad37-9164359d3592"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c60191fa-964b-4699-a33f-640fbe5e0278"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWCGP5DYUtlpysFJ/Qf9AcKlhUaSryobcqZtTyTbaq1QNDQs0C4sOBAUF
BYUEhYSYmASEDJlKqZQCA4Otn+PsZjd2xrOjvbuq86RZzY6/vPf8vef3nvPD
+9/fBt8ghD6+kX/evvsT39292//8nfznl9uPv324vfn1p9s/bj7c3P34/lv5
4/fy80l+4Pv9Va5ylatc5b8kvGvbfhDnPjb2tGXHDbW0ytMsr7vhQotCcAv0
hZ7/b2Qo48DzQvpX4yEUNetAnJA2ls/FtsdYukNKgow9XxvPscipjxAmrWHp
LD2fSwSX8kWybswCjHdRc9TWR5oA/3Fx+KeVHJL2bKJogpGXjBZzqVQaluZF
fo5F0SdhQKr+Uj2fSyDzo+ZLWBashHPlxdr62BJJD78HojBCCVVfR+6ia4Ix
GUVriHmKEU6oZREsEm1xfHnGT3ocQuxsRTgyoA6rWaUMsUcsG399UUEhEyOc
QoghQOosBCQJPVVY8f7hpK9FHNvIVzBvF0h+sTnELAunKo1kI1hzpizuszzC
GtPaLd6LLvJwSk12tkMsH8SYFMVpKwoZpekjA4ctZJxlAeD81dbGPNTGpKYw
X3UoqKXeLpmbDmjzSG2YZ5pkh/y4F9P3APnksN49yzyw5GHf9zEOU8irZWnt
sp0ON2+nrkmKhrUFfPdi8xQlOhW5XV63TUGAD98c4rEroWKESVW3hmlotrjP
a9pk1larddnjuB3isZ2ScZ+dsjIj45MMzMgwLeqGrXd2UI+rjVdtb+CmIdLl
cOo6QyNPGSqNiXes1QGi4ljCFkpDnxJDV5VV3UA6QPgacJmpsErDclEGC09F
W52peB5ahjqSK8YRZoSDjzKmc5dt9WJVqG31SlmMqolFkUsPg9xaHzfiuB1i
dytGBowbU0ifbLTazY3DZFEgaItSuyhkDPzMtvFDGelKuEEOuNuo7NUuiS5X
ucpiVUwqXbKfEMVZOvvwXI41PFfNjG6PWwm2nxptcZz1PLYPO/glIXa14szA
PEVYNg2yuXGQQQLQvpZHZJGBRmGqYniFadKc5QjF9EnN4YlqN2JgEdw3qoXb
OlMO5d6Ww2pCe1y6OMSDgx6HENsId7fizIDDgKc2bpsztf4QLhuFPKQ7Zj+f
NJUN38Obp7ghcILrhTtTfqYNtO4OKpfK6qm/+FHN+q7JQKefwv4E23sIR+Wj
/mMFCbIj7HikperFOBmMyGWI16vjmnxi0bNgdb3KKVTftBUXWuHODDwbDAwO
8xwiE9FD3x1G845GPYrgqLbpmep5JIPX57oXrzBDm6ixIO86RillPXilRqyE
a3oeJmoKTvlYV368p/PMrQYPskznviIahvzAn6kwIOFerEO8XlW/LMj37XoW
ITas8lyRVY+XWZlCjB0YeKrT6PBIs2kwh/upcUf3olJT/sNUs4JxGSjtrT6q
O/r3c1Ut8dFS1O1mWaxU1Y2XpuWdcBie+AInfV3chIQNz0qHGem2egIp6MP7
DZMeLn0WF1qZ3gxIwoUbAycBismzvHKBuWCY6hMTZiraOEh6yxVQtQyU0dMv
FraRl+gZetZUUI7kuPt6Vmz3spM6Lwe4wxwwvEn36MndkDdZHASRreOL8dAd
nF71bCMv0UOJKp4+6fgrWpE3jT3y1m9XTuq8HOAOc8DwMg7DKO1cCtlVrnKV
r17+BUObkFY=
            "], {{0, 19}, {161, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{161, 19},
          PlotRange->{{0, 161}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{165, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8cf1a250-93e9-4d59-a595-1085f6631c7b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWCGP5DYUtlpysFJ/Qf9AcKlhUaSryobcqZtTyTbaq1QNDQs0C4sOBAUF
BYUEhYSYmASEDJlKqZQCA4Otn+PsZjd2xrOjvbuq86RZzY6/vPf8vef3nvPD
+9/fBt8ghD6+kX/evvsT39292//8nfznl9uPv324vfn1p9s/bj7c3P34/lv5
4/fy80l+4Pv9Va5ylatc5b8kvGvbfhDnPjb2tGXHDbW0ytMsr7vhQotCcAv0
hZ7/b2Qo48DzQvpX4yEUNetAnJA2ls/FtsdYukNKgow9XxvPscipjxAmrWHp
LD2fSwSX8kWybswCjHdRc9TWR5oA/3Fx+KeVHJL2bKJogpGXjBZzqVQaluZF
fo5F0SdhQKr+Uj2fSyDzo+ZLWBashHPlxdr62BJJD78HojBCCVVfR+6ia4Ix
GUVriHmKEU6oZREsEm1xfHnGT3ocQuxsRTgyoA6rWaUMsUcsG399UUEhEyOc
QoghQOosBCQJPVVY8f7hpK9FHNvIVzBvF0h+sTnELAunKo1kI1hzpizuszzC
GtPaLd6LLvJwSk12tkMsH8SYFMVpKwoZpekjA4ctZJxlAeD81dbGPNTGpKYw
X3UoqKXeLpmbDmjzSG2YZ5pkh/y4F9P3APnksN49yzyw5GHf9zEOU8irZWnt
sp0ON2+nrkmKhrUFfPdi8xQlOhW5XV63TUGAD98c4rEroWKESVW3hmlotrjP
a9pk1larddnjuB3isZ2ScZ+dsjIj45MMzMgwLeqGrXd2UI+rjVdtb+CmIdLl
cOo6QyNPGSqNiXes1QGi4ljCFkpDnxJDV5VV3UA6QPgacJmpsErDclEGC09F
W52peB5ahjqSK8YRZoSDjzKmc5dt9WJVqG31SlmMqolFkUsPg9xaHzfiuB1i
dytGBowbU0ifbLTazY3DZFEgaItSuyhkDPzMtvFDGelKuEEOuNuo7NUuiS5X
ucpiVUwqXbKfEMVZOvvwXI41PFfNjG6PWwm2nxptcZz1PLYPO/glIXa14szA
PEVYNg2yuXGQQQLQvpZHZJGBRmGqYniFadKc5QjF9EnN4YlqN2JgEdw3qoXb
OlMO5d6Ww2pCe1y6OMSDgx6HENsId7fizIDDgKc2bpsztf4QLhuFPKQ7Zj+f
NJUN38Obp7ghcILrhTtTfqYNtO4OKpfK6qm/+FHN+q7JQKefwv4E23sIR+Wj
/mMFCbIj7HikperFOBmMyGWI16vjmnxi0bNgdb3KKVTftBUXWuHODDwbDAwO
8xwiE9FD3x1G845GPYrgqLbpmep5JIPX57oXrzBDm6ixIO86RillPXilRqyE
a3oeJmoKTvlYV368p/PMrQYPskznviIahvzAn6kwIOFerEO8XlW/LMj37XoW
ITas8lyRVY+XWZlCjB0YeKrT6PBIs2kwh/upcUf3olJT/sNUs4JxGSjtrT6q
O/r3c1Ut8dFS1O1mWaxU1Y2XpuWdcBie+AInfV3chIQNz0qHGem2egIp6MP7
DZMeLn0WF1qZ3gxIwoUbAycBismzvHKBuWCY6hMTZiraOEh6yxVQtQyU0dMv
FraRl+gZetZUUI7kuPt6Vmz3spM6Lwe4wxwwvEn36MndkDdZHASRreOL8dAd
nF71bCMv0UOJKp4+6fgrWpE3jT3y1m9XTuq8HOAOc8DwMg7DKO1cCtlVrnKV
r17+BUObkFY=
              "], {{0, 19}, {161, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {161, 19}, 
            PlotRange -> {{0, 161}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"21a305c8-6e16-4448-874b-5baee41347f4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3f9feb76-9aae-473a-bfac-8597eeeadc4a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c1f95576-8b7b-4c9d-a212-25cbf219c7ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d44074a5-5a27-41c5-92eb-6749b90fe2c3"],

Cell["\<\
Make a line plot of the second to last digit in the first 100 powers of 12.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"c7214655-d5de-48b4-9634-5047e35f8f22"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b72bbee3-c811-4a34-a44e-27037691a9ec"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvd+bVdW1LZp77st5PP/C+S/u6308r+d+53VyoqSi2bFyt9khZ0dJooH4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            "], {{0, 213}, {329, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{329, 213},
          PlotRange->{{0, 329}, {0, 213}}]], "ExerciseOutput",
         ImageSize->{333, 213},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c7f07b5b-77db-4c92-b79e-6e5e694813f1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvd+bVdW1LZp77st5PP/C+S/u6308r+d+53VyoqSi2bFyt9khZ0dJooH4
K0YJKjuRhEhUNIoaNYCCCBFRNGjKH6ClIKJiIEFEUUtF5ulztjWbbY3R56g1
Zo3KCX7Vv0o+KRazRq01eht99N566//1gu/896n/9LWvfe27/9n+779//fv/
76WXfv3f/7//Yn/4H9Pfvfib099Y/t+m/+0b3/zGpf/PBf+3ffNl+99/+7++
9rXmv+t+m+os8ZolW7IlO+9syamXbMm+krbk2ku2ZF9JW3LtJVuyr6QtufaS
LdlX0pZce8mW7CtpS669ZEv2lbQl116yJftK2pJrL9mSfSVtybWXbMm+krbE
RluyJftKWimn3jPz9s/ueObUB58UeRps21OHr7/z2c8+P1vwmbHtffEdW/nf
3/+44DMf3feGrXzu088LPjO2fS8fs5WfOPVRwWfuePaIrfzjuc8KPjO2Zw+8
ayv/68kzBZ/5+P43beUffvxpwWfGtv+Vv9rK3/nbhwWfufu5o7by02fmCj6z
Lufad+84WF3xx7eOf1DkabB1m5+3Zy72Nrt356v2U44ce7/gM3/1wF/smR9+
tLjb7IHds/ZTXn/7VMFn/vrBF+yZpz4svM0Ce+iJ1+2nvPrmyYLP/O0fX7Rn
loXo2LbsPWQ/5cAbfy/4zNu3vmzPLAt0dTnXvvORA7a8Q0W32U337G8cZJFx
+Pc7XrGfMnv0vYLPBCi9v8gOsvnxBpQOFt1mAKWTpxfXQR7Y/Zr9lBdfP1Hw
mb95qAGl4++VjGFie2hPA0p/mT1e8Jm3/fEle+axopFAXc61gTxlt9mau/9s
zyweqAS26dEGlF469LeCzwQonTxd8noS2z2PvVJ8m/3HfQ0onVhkB7mvBSUL
bgs+89YHZuyZ7/69sIME9oc/NaD0zMvHCj4ToFQ24q3LuTaQZ+a1kjhsF5B/
gIPcvq0BpeeKbjOAUtlbcGwAJbu3FnzmTfc81zpI4eAwMIDSUy++U/CZAKW3
TxR2kMDu29VcgvbMvF3wmQClN989XfCZdTnX3tAiT9ltdt3t++yZfzu1uMHh
xi0NKD39Uslt9vNNzy7G7SmwO1pQKrvNAErvnFjcs++u7U1mZvfzRws+E6D0
5l8LO0hgAKWdf36z4DMBSoffKXmZrcu59q1/aJDnyRdKbrOrNz79D3CQDQ83
6Zc/Pf9WwWcClMrmUWMDKJXdZgClo4vsIHe0mZntz7xR8Jm/+P3+1kFKpkNj
u7sFpW1PHS74zJvvbUDptbdKZnvqcq79y/ub9Mvj+0tus9Ub9i5GeiGw9S0o
7XjmSMFnApSK354C+20LStueLrnNfnbHM/bMN4rWC2L73dYGlP745KGCz7yh
BaXX3yp89gWGdLHduAs+E6BUtl5Ql3PtW9qc8CNPv1HkabArfv3kP8BBAEpl
t9nq3z5VvKAWGwpVDz5RcpsBlMoW1GJDoer+XbMFnwlQKu4ggSFdfO/OVwo+
E6BUtqBWl3Nt5IQfeuL1Ik+D/ejWPY2DlE4vBIZC1QO7S26zK1tQKlsKjA2F
qnt3vlrwmQClsqXA2ABKd+84WPCZAKWyNZrYAEp2oSj4TIBS2VJgXY5oivTL
5sdLbrPL/+NPi5FeCAzpl7LbDKD02iI7CNIvdxbdZgClg0cW9+xDTtjC8oLP
/GkLSmWLmLGhUGVXoYLPvOZ3+4oXMetypzbSL5seLbnN/v2W3YuRXggMoGSB
VsFnApReWWQHQfrFzpGCz/xxC0qL7SAAJTu7Cz7zJ7/ZW7z8GhvSxXaJK/hM
gFLZ8mtdzrURVJTdZt9bu+sf4CC46ZTdZgCllw8vroMg/WJhecFnXv7LJ+yZ
Lyyyg9zSgpJdhQo+E6D0/KuFHSQwZGbs+lnwmQClsoXjupxrI6iwQKvI02Df
XbOzdZDFvT0BlOwcKfjMFTc1oPRC6dtTYDfc9WzxbQZQev7VwsFhYGtbULJ4
qeAzAUp/PljYQQIDKF1/57MFnwlQevqlkgy3upxrI6iwe2uRp8H+/xseW4z0
QmDXtqBUdpsBlIrfngK7/s4GlOwqVPCZAKX9Bxf37LvxruYSdN3t+wo+8wfr
mkvQvqIU0NjWtuniqzc+XfCZK1tQ2luUE1KXc20EFTcU3WaX/Gz7P8BBrrqt
ASU7uws+E6BUliMd27UtMabsNvu3Xzz+D3AQUIhXb9hb8Jnfb0Fpb1HyamzI
zFzx6ycLPhOg9MRfhpGmTm9ft6JNhK/YcmDs6lrKta9Y/2TxbXbxtY/+Axxk
VUuMWf3bpwo+85LrdxRvIojtqtuacs+VRbcZQKksuzs2sPV+dOuegs8EKJWl
3caGdPFl//Gngs8EKO1+bgjt9szspqmpNcfO1sf3rJua2qTEzVKu/cNfNfcF
O7uLPA32zasfWYz0QmAgxpTdZt9qQaksLz02sPUuL7rNAEqL7SCoQdu9vuAz
AUpleemxAZS+t3ZXwWcClB4bRBhuXXu9xbUnZzZOTS+Ka1/Wlnsu/+UTRZ4G
W75662KkFwJDDbrsNgMolWXUx4YatN2OCz4ToFSWUR8biDGXrtlZ8JnTLSiV
ZdTHBlD6zs8fK/jMf73xseGM+jOzq8yHp5uYfMXmsdJzKddGZrXsNvv6T7Ys
RnohMNSgv1t0mwGUht6eJjVkVu20KvjMi1pQKtsLEBsyM5f8bHvBZ/7LdduL
9wLEhnSxXRULPhOgNKwX4MDG6emNbVnqzIGVU9P75dieEpv8gR/PfXbm4zFd
I2RW3W129osvTp+Z+/SzbImz/3nlluIO8vHc54FsC0DJAtH4xV98cc5WPpe/
coBSWQeJV45yz7e8bTZ45QClHc+WdJB45QClqaseiV88Wnm+rBxAqWwXwyef
hisHKF24emv84i/ODVw5QGnL3iFdDLObVkytb6ufc7Pm2jPjrj3ggT+745nl
P92m38F9wd1mr731nv3V1sw+OPuI7V/Z165B6YU+u2HTs+Z3+h0kMSyEjl98
+J337a8e3pNNjAcoPVbUQX7x+/32WP0OMqvLvW325l9PV4MalABKj+57Y/A6
YwNrzhCe30G5J/ggYO+c+HAYY9k2ZLPNBjlIn4E1p6fSj9c3oLTsij/GL/7r
yTP2V7/fkd05AlAa2H9xenaUIJ+aWrPlgEL5MNe+6rangs8FSYzA32EH3/h7
ld/m8+nnZ+Haw9ILfXbt7/YFKwcoudvstaMNKOW2+RCUyjoIqtj2cH7n+zfv
6ttmh985ZX919/ZsYjxcOxeH04Yq9qeiTHtZC0rNr3PuXPDiN99tQGlA/8UF
q5p446F8HE4Ymp5UePOHv3oCK4+j0LdPfGDf37glmxj/jRaUHtg9vINv7syZ
WGZsmGtf8esnA1/AfWHZlc42e/H1E1U+vdyiOLyHZRv2kVVWB0ESw91mB1pQ
yqWXE5TKNuwjgaMO8r21j4+2WaTn/OqbJ6t83q+9A3jggEAlYeD72QfK7/yv
m3fjB+k3YYfebkBpAO8XoFS2kxokZI3JkS6uPLnaIy0oDeD9ApTuK9paVQ91
bdzy1BdwX7CvWDb8+VeP2/c3ZDbL2Pu5GA6CgEp94Ts/39G3zV5oQenWP+Sx
Z+2ChgeW7QHHLU8XeemNO0fbLBJ9fflwA0q57NnPOlAq6yAgBeki0R1QeaKv
ACWL4bN+BEHpvqI94GAq6iKRmak80dfX32pAye5NuT9lWfvAex4r2QNeD3Vt
oK568cXXPIpfOUiv1a2efJXfC3D6zNxiOAhQ9xPJdXz7ZyNQiqVTn3vlr1U+
SdveATywrEgCmAP69n7n54912yxUhnzhtQaULBLO+hEEpbIiCWAOqINcumYE
SrEy5MuH/1Y1JO08ciBBqaxIAop06sUEpVg69ZUjDSgZGuT+FDzwrvzbU9qG
uTY40uogU1dtwwrfiwaIPPXiO1U+B9W2Kx5YVt4BmXx1EHDe3G32zMvHqnwO
KkGprLwDkmaKP5d0oBQLkO5vQSmXHEhQKivvgKSZ4g8yM5UnQPqX2SbGy+Wg
znWgNCC9kDDEeCrd/N0OlGIB0pcONaCUy0H9/OwXeGBZeYd6qGvjZq0OcmFb
NKk8lcIn/vKWfd+isqwfYY7WOUjJsw9BrDrI1FWP4AfFMp57W1DKpdgRlMoK
U+BmrQ7yrQ6UYhnPfS0o2c7M+hEEpbLCFIjxFDnBeas8nY39BxtQWpnJfTrz
yQiUygpTIMZT5CQoxTobAKVc7hNBqawwRT3UtXHSqYMgieFus8f3v2nft3gy
60fY+7kYDoKTTh1keQdKsRjmn55vQCmXMPy3Ux/jgQPqIAnDplIHAeet8tQq
nnzhbfu++VTWj7CICw8sK6mBk04dhJmZuBkfoGQ4lvUjCEplJTVQGNXQYroD
pbgZ/88Hm4vnv96YxyAiKJXVOqiHujZqiBp7L2vT45UnKbn9mTeqfKIa6pvF
0wuoIaq2uYESVh4r5u38cwNKuUQ11DeLOwjcQYMi+xSw8nib7X7+aJVPVCMo
3b6tpIMgUakOYp8CVh5rPuyZaUApl6hGULrtjyXPPsR4Gnvbp4CVx5oPT7/U
xHi5RDWCUlkxkHqoNhp+OzoIKrnwmlg5YWs7Ac0+36wfAdJF8fQCLg7qIMu6
lcfKCY/ua0DJPs2sH0FQuqOog+DioLeGC1Ztxcpj5YTHWlC6yOPhJIygNKA4
mzDEeBrOfeOn27DyWDlh93MNKLkEiYT9/f0RKP3moZIOghhPbw0XXfMIVh73
vQKUXIJEwk51oFRWxqQedGqTkkEHQX4SEWPcXo2xjC6rMGFgghVPLywbv1aj
aDJqr470BzCW0WUVJoygVNZBcOVRBzGAxcrjbfbI0w0oBey1ee2dv41AaUNR
B0GMp/edC1dtxcrjBoHHnj1S9dAMEkZQyq1Upg1erPedqau2YeUx/3lXC0r2
9fnZL+qJjaBUVuenHuTavPhzOga+g5JfvM3ub8ckuaSphIGeWtZBmI2kg+A7
WHncxf/gE6+NttkXGdvsjWMjUMot5SfsXFe3VQfhyuNt9scnD1U9bJaEHe1A
aX1RBwHtVh3EvoOVxyzibU8frkY0g4zhywSlsoKEiPE0IWDfwcpjmv2OZ0ag
lDV8maB0S2Ypf14b4Nq2ciyG42M+alMB6DGMW30xJsm+spjzoC5URYVhyXDj
dIy5z85y5fE2w0BJ+zrzScY2A3Wh7O2JDDemMgBKWHlMVsdAySpzzilBqaCD
MMZTB+HKYy4uQSmuoiaMoHRLUSnFZVHGzEAJK4/J6tueGoFS1hhHgtLafK5L
2ga4NlMWdJAPWmeHnk9M+cZAySpzIDv4VGUdhCkLOogdDVUr0uVuM4zerjIH
shOUCmqNMo/KXN+nLShh5THle3MHSlnzpglKBbVGGeMxCXP2iy+48pjyjdHb
VeZAqCMdKK0tJwLJGE9zfcu6fR7XZB9uR29XmfNu7MX4V7n8onltgGvbbgkc
xHwW76q7zTB1rsoczAeSZ1U0vcB7DR0EEQhWHhOnMeCpyhztSlAqeHvCO6wO
gggEK495oXfvOFj1MCsSRlAqqJJKwjCzlIhAsPKYOH3vzle7q0fGaInX3x6B
UkH5SsZ4zFIiAsHK48LNA7tnq56Sd8IISmVVUutBro0OF3WQk6cbl8FcvHib
YT5vlTkDC8zzsg7CWjkd5P3WZbDymH5MUMqagfViB0oF9V1ZlqKDwGWw8nib
YT5vlTkDC+0wZR2EMR4dBHRWrDyuD2IUZpUpUk1QKqjvyhiPaXyki7HyuD54
785Xgs9oEiMoldV3rQe5NnGGA8jAHMN2ircZpsBUmeNmwEqq8jsFEsbghwLI
YI5h5XGV7TcdKGVN0wArqRrUKdBnx7obGQsQ2HhYeVxlu+2PI1DKmqZBUCqo
TMsYjw4COitWHudIb+9AKUvukqBUUJmWMR4zwwAlTPSLiwh3daCUJXdJUCor
GVoPcm10MauD4DRE0imuVWGIZ5UpXA9WUlU0vYAuZnUQnIZYebzNMC+vyhSu
JyjdcFcxB0EXcyUVOpyGCF/jbYZ5eVWm7DBBqaCDMMbjSgBKdgQs82pVmJdX
ZQpngb9d1kGYu+ZKkPEwF75w1dY4mITLV5nKcgc7UCqrqVsPcm3eJekgIGkg
txlXfDAqosqUwAV/uyqaXiBC0kHw8SEBEld8MCqiylT4JCjlti8ljGEbHQRn
il1/Lli1NU5oY35NlSmBi6YS+7omv32pzxjjsbYIkoZdf6au2hZXfAhKWRIc
BKWflnMQxnisLSJdbKB08TWPxiEZxp1XmRIcBKWyasD1INfm28iQCaUH+42+
/pMt8TZDP3uVqRWGppKqaHqBbyMdBKWHrU8d/sZPnW32iw6UssT0CEoD+vv6
7OCRk4GDEJQuuuaROLC5uQOlLDG9ZzpQyu3lSRhjPDoIQelfrtseBzbQLKoy
m3kJSgUdhDEeq6JIZlqM952f74gDG0z6qzKbeelNbi/P3Kef23mUVcGkDSCa
ggavdwrUQw1mL7r6kbj6gGJBJcnzc+fObX781fQhTm7PtV56wTa2ffRZ9ZFa
UnP80UBmAyXbZnF4gCEX1Xjy3I6btAoxCIetgzjB4YlTH9nK4y6ztLFewPgB
t++tew9NX78jDg8w5KIar9E8sHs2rSH5VAdKq7yeSnNJW3lWZaeWGI8Ogtv3
Q3te/9cbH4vRDzORq/G2IMOBtMA4QemK9U5P5cnTzcrjxqW0McYjbQCgZG/p
99Y+HocHBCVtC7JfMy3uR1Bym93oWVkrhw04tbkB6CAIF+1XaLdZiMN2BIDV
wwZ/JFLSAAsWdN/tCUFvrhI+NwD/IURv7LNzt5l9Bytngz8SKelmyd0dKLlN
x7iJ5yrhcwMwwCYo/dsvHo8PWXN2rJz9y6jSpoXiCUpu0zHOl9xtNvPaiSDA
fvfvDSht2Xvo+zfviveAASxWztzgF+fOLZuvWZJ78oe/cn5BpAdzpeoY4/Ef
ngAoPfH6Zev+FO+Bm+7Zj5Vr0sbi2HRjFIRK7MueGf8tbuLD9LoHuDZaHdVB
Ztugy06EdpuFnnjlr5+EHggrHQgm020XaM2oetIL6GzKFTvd+8LbgYNAictu
Ct+/aVd8VBkyY+VsFUTazWLgxE8hKLkje+A+uWKnvL/TQZBY2/HsEdsS8VFl
l2WsnK2CuOF+I9l2gXe16unARWdTroMwxuM/RGLtkaffMDeMjyoLdNE4SaoS
brgXrtqaYJUTlNwOXLhPrtgpYzxGm0gXWwBgb/gPIk+0y4Vtab2TgqVp31E1
18DwrlY9HbjPv9pA+rDR2wNcm1uXRw9ugham/sDbZrZPoGDJRC5ZTwkC59aW
tres53BH+0OuXDbPUzoIboIGVrbHYsC3w8sOi2VXfpnIJRUzcf1BE+uynmFD
O9r2h1y5bG5dOghuggZKdnzEgG8Bgx0WmsglFTNWW6KhiXVZz7AhXJFy5bJ5
ntJBRqD0zBH7ZO3gDl5vQdp31+ycumobi56kYiYInAClvsMdeZtcPSvGeLyO
IV287enDFibZKRa83kDJ4PTiax4lK4CFv1gGh4ZPdlnPsCHkbVhlzrIBrk0C
P4ewQM/q6ZeO/fjWPTFs4lhZvnor+b1MHcTN3TTk25f/dNuPPQcBRzp34AIJ
/FRJhZ6Vvb22zWLYxLGiCQRWfhNUEHCJbeVu9IvfK1fwDXIWlYhAon3GtrS7
zXCsaAKBld8EFQSgZCt3HQS/V64iItOhdBD09NnmsftOLFxgsZNFUJpA4J03
QQUBKNnK3egXv1euIiJjPP7K6Omzp9napqOZFAZK9kHoze5QV9dIlH0BSrZy
d0wSfq9YJGQSG+DaD3VcWToIRPYs7LEINtbHsHfbDpFv/2w7iRA8gxKXZTjv
t6591E0vgEiZq6m7tSPw00GQ5LGgyCLYS28M39smCGlvE2QK8QxKFJXgvLby
OGarOyJlroPwekJMwIa3N7A9LMJthiDEjj9mKp6JQvrY4Ly28u97DgIiZa6m
LmM8/sqI2ewNRAQbvB5BCPYMvsM8Q+IuANC2lbu6GWgrztX0YIzHX5lJLYP6
+FKGIMRQkZkKHmGJuwBA21bu6magrTiWWJzEBrg2mjTVQXArsY8AMUnw+kvb
DabZHrpYQn/yvvan2O/rphfAtsqVTWOTJh0EmWfb9rbNvh0pe1iMZDd9zfYA
/6ukQARAyVYeR5t1x7bKVYViPxQdBKewQc3a3zvbzDaY3fSbbE8X8+zsXCwh
EIGfYiuPw4C6a/PJlU1jjMdDk6B0y73PxXd/C3XsImOXOMY8zAAk2nvxU2zl
roOg9zBXNo0xHjGB6WK7TV+wKuziR8iKSxy+wyMs0f+On2LLdkdTwQuymuBo
A1yb/VB0EGR9DaN+8fv9dtcIXm9nigUwlzfnyGib4a1eluzTwWvMudz0AigZ
ucKb7IeigwBXbf12s7P7XfB6O8ftNNdbxn1d73mCSAPos5W7DgIGcq7wJvuh
6CC4Gux7+Zjdpi+MthmqM3rLAOAsSxJpAH22clfga0NLychVxmCMRwcBKNkt
8tY/zMQzKWzBtmxbPN89AM6yJJEGr7GVx3Fy3fUC5Db+8wAijDNdjLciSOvZ
JrGtorcMAM6yJJEGr7GVu1llNCjFCvmT2ADXZusB8xII9myzNdss0iSxYGPN
3X9GYgffwTtj8WpCURBtAvYCVwEPddtcbSW2HrAMh2DPog7bZrEmySVtLQ+J
HXwHm8ROQ/dEhqFNwFYeR/h1N2smV1uJrQeMcwBKfz74Lrpvzo1vs+bGd/s+
u0fwFLuj3SS2KhdwYAAle42rdoW6ba6DMMbjh4WikoES3sxAkwTR3c83PUt5
NFy+bFUJRUGAkr3GdRB0MeRKxzDG44fFUhRcINAfQHRnO5OnGy5ftioXcGAA
JXuNq3aFLoYswRnaANcmy5cOghuo3VuxkvBHXPXITfc8h6IGvmOH9TevfsTi
seWrt57rWTa24hXrn3TTC5iSk6vOR5YvHQRlEQvLEeEH2+ziFpTsgOaGuWXz
87Zmixm+/pMtfdIrABBbuTuFGVNyctX52PPO4/65ESj9dbTNxkdQmV+YdzRX
wm7DYM1AsD6FHwCIrTy+m9RtcafKb59njMfjfqbLzKCfIqiSGBYZIjXvcxer
209c1oqeLesXjUEewFbu1iVBdc5tn2eMRzQDKD390jGElEGVxEDJtiXeZ3wH
ngLs/aRHhwR5AFu5W5d07ywT2gA2Ggl1dBDcKV45cvJ2b5uB5GzeTXm0q25r
rt5oyuhTOQCkG4C7tyd7K6p8ARa2l9JBUFV8+fDf4DsfjW8zkJw14r22PQcR
3PapHACUbOWuLOeqduhYroOwvZQOMgKl105gm30wLtoDkrOGIhZ+2HrAln+n
h8WH89FWHt+q6vZTq/IFWO7oet7pIKjV2v9jA5wav0gi3bpBTqvmHLz2UaT4
jvYwynA+2srjW1Xd8SFzBVgY47EtgulibIBg6xqSG25rKGIRmu155Gfe6Olo
Big1tK7oVlXjU+s/8dM24NRmJxczKiCxvHb0PUB0oA1l9ynbycBefAfpHRQX
+volEbTbe+U6CPSpciW82DRBB4Fe98EjJwHRgQ4M6Aeg/eOMRnoHBJJY4BH2
u60vYeWubu3lrWp9roOwaYIOYmcH3j13m9mRZx8TohTMlER6B1mRvn5J3Oxs
5a5G5Y/aodi5El6M8eggILHY2Q2cCQQ6Gkr8PfuBtJBHs6ucXUVxAenrlwQo
2cpdjUpIHuX22DLG4zZDutjiJVzDA4QEJV5dwA5xizmRFemjVQOUbOWuRqVb
cprQBri2oSjUNZlyRAL/8DunkO3RbQa1HIs/9XoCdj3qm32dF9jM9rPcmd1Q
lcxVabj53uewck5qQNV19uh7yPYEBzGOV40b7fpsnxfqm31VdUCBbSR3Zjdm
/uaqNNhvipUzUAEw2u0PWtABnd5ebPGnxo3I9rNHz/0pACVbuTuzG3r7uSoN
yJUtEwcBMBoooaIXkNLtR6/b/DzSlWDXoJwEBmNf0RCgZCt3tYIxUylXpQGR
g7LLAEoGMqjoBdIidvexYxo3dLBrDMbtLADzvK+qDlBCI1L8ty5hb0Ib4NrX
3/kMhvfRQcCwOvLu6bgMB2ks82s9Fg1aba9CoKZvHgruLHpbVDNsr/J1fuzW
jJXTQcCwOvT2qXibgXRtp6TilcV75pXQJeu7DgCU9LaohkkBuQ6C90EjeYDS
q2+ehLpvsM2q9nKqeAWWlP1SCKLcnwJQAozEf4tJAbmNeHgftPOUDCu8+YGC
jR1etz4wo3iFvIFFTW5fIQwnrK3cFc7F9EC3zyhhho32E7UlcF+XLuabr6/H
rsZGwsXBDiD7oefOnbtQ+FqBIT5BijLmowKQs5ZNG+Dadmzh0OTepl/Qx/li
dILYtQWZwHf/fgYiomBl2z2iTzcGW8L+300j4AjLbeW2nwVmNfc2/QKBxyHZ
ZugEsdAd5Ym3T3wAZwcr296Bvq5/gJJb+qw7/dvcVu4b2oyx7u3dnV8w8OCL
ofNjoISa6ZvvnkaHBX5rCxv6huUBlNZ7Nam6m0OU28qNeig+SnwHmRnzC/j4
wXEWJUJ3xoF1F4HUbdjgNnbVXdiP9cfpTQxHy23lRj0UFwR8h+li+ri+HoRk
Xk7rLgKp2xuo27dSd6CElcdJwku8fqsJbYBrg3WjDsKrh/5eMIiP2ZFNJ2Jn
XN0OOe0bu4NzynUQKvfmioFcdVtzc1EHIcYyvuWLIT5m8dLIid46hXZdFNPN
r90EuNm6FpQaB4lOECr35oqBoFqqDoKY8I1j7zO+5YsRDlmMSieCuiNyI/am
uQnwujun3KJt3Y2MyT1EwMlUsi4oKPZ+Mr7li/HJWiBHJ4LkLK5+dpN183t1
B0pIYcUT3jGb3u3WSRgqI0rW5ftJjhZfDKF4O+xQCH7h9RP8Xeo2Re/m9+oO
lHAVirPorozAhDbAtZFKIpbWXW3ObkPM7fDF7LtnwupI17JUt2W7Zd5nUbc3
entXXVbDB50Qeq6DIJVkDkIxXuRd7QaKhLMqiY3EQB5/lb8U+ijR2YFiWVAL
gN3UlvY2eHXAjzrN4dwhs2AF4DaH7yDvarf+uDnow04MhL6DPkpcsVHFcAX8
17WlPbfcjFiryh8yC1aAOgh50aAC2jvPF8ORLUal76CPEgwKxK6ugD9ACdn4
oNyMbE+VP1DSMNBiM2WzA5Ree+s98JM1M/ZpF4uS3wgtUBSIkfQ45ZHKAEr4
1YLZ9ICL+YopZ2ceXIMi18Y9Y+TnAa6NtAaDjbpjOv3t1Mesa/DFyH7YpiI5
hMXBuqPIulLASPu7hfITXUONqxiQMDDivikOQlBiXYMvRv+m/Wokh7DBre5a
z1wpYKT+XAfBx131KAYkrGFWt3wMXtJ5Teh6c77cZu91CkUkh7DBre7uIIc8
jVaAklsof79TS87N6iDG00Z+XhPYm8MXUzaNbzUa3NCIhLv5rCcFbHdV25Bu
oZxqyS6lP2Hou9F2D14T2JvDF3/UyabxrUaDG/oscGk66DVw3frAjIGSWyjn
lTCxyDOzm6emVs3O1XOH7T9WHpYPbYBrgy+kDnJ/l89Ut4XxpCPQoZSMkx1Q
oA5FQwUZh2OQXuBQLbcpLGEgMYIdh+8wn6luC0NzroEPOc96sgMK9DelAZRw
OH467iCc9JeWRIgNJEa9eXUZyzPYZiq1B4FZ+9XYiKEnO6DAFYoBKLklfmoA
5s6PRoyHhBK+A1Q0UGILGF8MgVnbTmzEUMgFFLiigjfd85xtSLfET2HS3Fmx
iPFUgoCpJLaA8cUApXt3vkKJDLzPONnxGe30GnNA4HRL/IwbE4s8sHHFdVtm
jx0+MHNg9ujx07rbBrg2+ELqIKjNGbDr6QCD6p2dFOwvBmgj1YZAMR4hUXe0
Fq3M0tjl57YVJwydUOogIAzYYcrl8cX8jNhfrKk2RA5ufwronVqZpVG9MNdB
0AmlDgIWky2Dy+OLqa0E0QM735EDwXmHyMGl34Pe6ZITjnSSqm5bccIQ46mD
bO3KKFweX3yi01ai6IHmQOA+bn8KaC0uOYHqhS7vN2Ft99we1ehgupixKF+M
d9W2E3DVgj3NgSCZ7PangMrlkhMoR5NY5OzmFebCazZuWrfSDu3NmrKfEpvw
V8a9CSUJfGe0GT7+VO/RsNHB8fzRd7r9Rm+q23sQJrvZzdS+tGq5uu3bdenx
1OTJHQ2PexOgCd/hZtB7NIwHB7W84E2oJX1x7twFq7ZaqImV2y/Ff4jbJeqV
9p7oAoDk9pUgcruGsBBURnyHJTl6AV9MFUpmLLdILclucOhrxsr1UAAoEah1
Aa90uou5o+G/t7aJ8dRBWJJjdMEXU4XyVJd9xRHPoqQdzfZArFzbBgFKeE+w
tWicC5kgcruGGE/VRViSY3TBF2OTPLzndSQ6zCN2jBcl7Si0jw8rV/E0gJJL
q4ijmtgObJqeWgfCwPE1Uyv2C/1nwKkNBQx1EJ5QOC8UZxjo8t1AMpAHsZ0C
eOeDswzhEMh+QXqBakK5DgL6pXYx84Si7BVfzAiEF8AOZ0aLASMuPsuQ8gIf
O7g9UU0od6g9gFS7mO/rQInnBV/MCASHhV0A8WsyUgUjbnSWSYUCoHS/0EVo
bD3O5T1in2gXM0+o96XiAGOgG9IhukgVjDh8aYUCoMRIRhdA9QyX+5Qw7BOV
3yF9jtUTvngkwPLUYZcOUXeMOHxphQJlTbcvmy1yiUUe3b5qauWDjUOf3j89
NT2zMNdGblwdhNRxLWzBmMlh8nPdZqcJse6yFvwj7mhuegGJyouufiTXQVA8
UgfhvZJFOr6YbT5Mft76gNMdVneVKf4RoHS/12mL6omt3GXPJgzFI3UQ3ivj
bcbeQySHf/vwi6MGoqjgG1CUV//2KXtzlE9FQ4bEluGyZxOGGE9besE0M29l
kY4vJiid6wrxbttO3aUF+EeAErkT+kpkSGzlfeWnPkOMhwQmvsN0sRa2YHot
QnX1dq87rO5ylfwjJA6YFNVXTiaMdnrLmmlE3et2jdEjc10bCXkLKhoH6Uqc
zAYzGuHrRw3Rr/z1i+4fgjcSPzmQcUDiyG1FR5BmOJAWTowNpAJ1ENJfiTx8
MRui+Q/t3PRbosa/byeL7WRuA30lgjRbeVo4MTaonKmDMBv8qVCAYIr2+Idu
H33d8Un4xytbUGLVQF+JPIOtPLcRyS6SFuNpzzvjmRHy/PFLUh+yKFBUBvHP
7aOv25Yo/f7qhmu9i6VMfSWy07Zyl0GUMPT9ac+7wnU1XpaiSgP/ob3t7k8M
qBrgmY+qBuPNL5MLo82dsXcz/Gaua3MjQccD39zQNVCM/lZ6LTWrjEPzR55+
Wh3hsD3f3lU3vYBv2m5xOah9BrqIbSToeOCbJDko0wymmIlD035f93Yf4LCF
u/Z8t/cB37SVuxzUhGEj2T9k5hA13E8+/Tyufmq9GIfm6p4uAxSy+ccftc93
ex/gNbYAl4OaMBxh6iB6yVJ2RN3pWSGrjEPTFbaqu0I2/whQQq0/6A7DN23l
Lgc1Ydiu2qChlywt/tYiHVO3iRFbtnYxqwX1XICSq4G2EGG0Ot+1MfbIPh1s
YHyTzCtss99Izzu7Juu2X88OPgucXO39AJ/BnnXTC9gb9ta5XQx9xuvbj8RB
fivMK7CX+Xp2TdbdhXGFJ2hctzisVwyAHhwk6Npgm0+Wg/D6Zg7CdMQoZdGy
fZavHhtBxVbuurswNoGKV0kPOKX4TN2uDSQ/0Ww++coZ47UOMkpHaGpUS6i1
tHLXXVHgck9ptuZp0lHmAHpk6OkrcQHHyvsa1V1DqKbYoqlRrRDVovxZd0UB
V2m2ltMEf8RnSsajvnIhwmh1vmszdakOou3nF45vMyXSxwVxtQCHoai21fvt
cP9qegE8qnOf8bJwpahXgQuE/4ZkBF//lIRDLIi7rHV9SN2BkusguH+hF2Dy
lfOysFocBARFXJ8vHt9m5DrWYwVxh5Qb0AYASm6/iXYxTO4guJNajIewc/Qm
oKDZ7m2ts9QielNrQdxjrQe0AURibr8JkhJYeXzz7bNRjPfwi3pP1IKmppFr
Eb2pxwriDik3oA3gquL2m7jF7skt17VZsFAH0bgumHSmtWB7/y9rc7NuzxRw
mKIraGwPah8w3Fbw+slXzhS9OojiiWqu1tLvWbfv/w/W/amvZyrAYRyUcadM
3YU3fVTnPiMdQh1E8cS2mdLptRYMMlhfzxSjevwRB2XcKVN3nw68sk8wJDaO
tlQHUTzRZGwt/Z51l1Zd3kOiDkonOCjjTpm6+3QABUEtMmGM8TSRoniiydha
5AHrLq3aXOK8DnFEbswMI3/idsosRBitznftY13lUbXOwAXCf8Ml+XrND9g/
QWeiK2Qa4PAlraORlKivxK1cwX8SY3latc5UzO3S8W2mzUf2fazclSsM2CnA
c/3nNNzKXTZLwlh3AKsZ39R0fdD6p006thKs3OUrBvQtOFrc41N36O2yWRLG
GE8d5Dci5qYZm1qUMeo2OYmVu2pswYkGR9sr/5xm6G1vlMtmSRhjPM00arpe
Mzb1OCihVb/qUWML0kcApbjHJ3ijBliuazPJrw6Csjv+O5h0pjkZiwmrcZVj
tQCHEWS6mQQcXi4fMmHkPqkYYHvBH4ESom6+XhtvLQ6vxkVc1YISNoJMthLo
K3F4uXzIhJGUomKAKuukeY+6S7/gyrn2ntGwUVfEIChhA5TgX6+MO4g52r9c
tz03RGSM1zhIt0O05UevdbX0X9Qi5uOKGAQlbIBS3J1Ut11XF13j070SBh6+
vT+aAlJZJ41aa9EQq0XMx1U+D27Q329BKe5OqhcmjFbnuzZpyeogism43PH1
mge7OTmuOtg2uPmyAVBfiQSFW/JOGNll6iCKyap9XQv1qJYhjO5kgWDbAJTY
AKivbMLjm3a5Je+EkfKqEKrVnyvGt5le8ylk504WCNL4diW3N0cznzTwft2S
d8JIeVVlPM06opLO16t6CYXs3MkCQRofoKSZTxqaEdySd8IY42lcp426ejmq
2T7fblQK2W31jrAgjQ8KrmY+aQsRRqvzZQ9J5GgcpPu5OsAimHTW0UqbbUyB
L1dVbITD3bZBOs51EDteDTOVsDqJvdYROdRBdICFXjHq8XOBAl92pYqfHOBw
myd8jh3H+kocry5pKmEkcqiD6GQBjaCC9VDga5+nKhakMpD11SwcDcdrbs6W
MZ46iMpr6AERrIciri4dK0hloC9As3A0HK9u0iZhjPH04qMlaT0ggvVQxNUd
eRykMtAXgNIAsnA0TQoNsNxTm+2oWoa+VgoEgHe+Xs9WCpi/7nUUBjjcKOs+
MONW7fFuuHWxhLFmqpkBHd507fg2U7bMXZ24pTvqS0P3uqt4ukIcgGhXzSxh
rJmidRHfVAnlAN5xtoItQwFzd9TXzvFqEYoXmhGigQTupv0TxhhPHURFsQIy
g56tFDB3R30F9x2AEgdG6CtBAnfVzBJ2pIvxtAytolgKs7X02NYiYO6O+tLQ
ve5AiaRNfeXKXw4XRqvzXZvAqDwN5YjaOrVSrzdiCjsHRA5YgMPgGbrphUbT
5vf7XWZFwlie0Hy+uTM5osE20xsxh3e4Py7AYdAwXAeB6KXLrEgYP3f09uKb
6s4BZ0avNhze4f64IKUMUCKBUF8JpcpcEgU7CKC5gW/q+xxwZvRqw+Ed7o8L
UsoQqVACIQ1KlW7qI2HsINDUmb7PQa1WKXwc0Ob+uGBLowffpYsvRBitzndt
Zir0Q8F0Rfx3IFSozAoOrnJn7+q1mhRECtvqK8EtcZPnCeOj9EPRGCMQKuzy
2E3pgYOr3Kt9gMMAJQrb6itxy3CT5wmj5IgKPmsoG2wzzWNzcJV7tQ+u1QAl
Bmb6SqQ+3OR5wvgo3GhQ8NKrXEAJ0Dw2h5MGZF1YcK2Gck4sflJ3B/qTXvI8
YXyUFm70Kqe/US2NeLUMJ3Wv9sG1GkRHJbPRFiKMVue7Ni+/up00jaP0lVo4
qHWXJFl2pZ/P12os6awxQ57MfLf8mjBefhsH6TK0er9Wx6nHq9Uc2uhODFEc
Jp01lm0hC8ItvyaMl1/dTnq/VqX0erxazYlybhk9CC1QuI9lW+oWr9b/YcYt
vyaMMZ723WsJT5G/7uheqJJwKKpbRg9ibxTuY9mWuptw4d6PEsbLr1Yqb5D7
tSJ/LZIFtQxFDToWYUFoATore5/1lQsRRqvzXZsnju0B3p7QEIH/DhiAOsAC
yNnX06E4jJ4ge/dmIgdhi6WbYUsYTxzlcWkJA9uMLqCVDmyMPsq64jCRJxac
gcaO/VJuhi1hPHG0lL+6h7pZS7dO3cUqfZR1fXuJPLHgzFzXGuBm2BJG0FMH
0dxy0NWuYvWIVfoYuUrsrNtAzjZkLDgDjq4F1W6GLWGUldMQSIk3QVf73aLd
hFhlWU9JOsAfgFLcmh1ztnMt17WZSNGTQuuqAcFJ43a8vX2D8PSKx0bFOL3A
xmq3RpMwJlL0pNCGi6CwrhdbrK2vPVxxmI2KcJC94iBsrHZrNAljYUVPCm24
CArrSnXAG9jX/apXPIISSwl8GRur3RpNwgi/FOuoxydiBIV1vdjiDeyr/miP
2BedmmgslcONFAdRaSP86h1B+eRBQUdHYuEN7GsPPyQ9YnUHSrFUTtzxmmu5
rs10gTpI3EfMbaZXb9xflBaipscc99LBKL3Abn23yp8w5jD1jNM2yaDcrFdv
bKQfr/el2F6RY457aTZyEHbru9fwhDGroGec9hEH5Wa9EyHS60u0qnwfRPbs
zcHeUwehXpB7DU8YYzw94xSUgnKzXr2Ro+5TmtJj7rMOlGKRH2pXutfwhDHG
U+UWTRcHHdZ6VwIPoU+KTXXVRp3OD78Yi/xMIoyWtlzXZrrgTjmdVR4n6FPW
kfQAVfuO+2TFYR5w+s3gZW6lI2EslqmDqDxO0KeshWOAap/sufbqdnzvV18f
B2d9mZvITRiLZeogqv4R9Ckriwn12b65AFSuq2UYhH4zeNkkuh9qjPGUhGBv
OFuigj5lLRyDg9c3F4A0nlqUP/Wb+jJzmXgjpY1NZEpCaNLFXcwZ5EIxNh3/
DTzpkz1XxTMOg8A3t4o80STCaGnLdW0eyhq+qqjdtvGalCZywU26tWcGn+Iw
CIr2rrIwypfxeuiWAhPGQ1n5+ZiJjBdQ2Rt/VE4CuEl9I8YUh2NNTr6MYQlp
PxOunIey8n+akYhdFBHUpJTVCf75zT3ZGAYStTShUFqNL+P1MI7V08ZDWR1E
51gFNSlldYJ/3jeDT4UHCUpscODLGJbEsXraeCgrS0fpWEFZRHm/4J/3jRij
Mn8toETyG182iTBa2nLZaIxm9X6nWs1Bz6xWl+zDwgRb98kKuWRNx78gMzNx
tidtzIfo/U4774KeWWWw2L+y/+6LjkinrIU1HevZMjMTZ3vSxuueBt7KeA+2
mZa8P/rkM1u5S2auJXFRCyhBe1B5/gyQcvcbYzxKK9fjVOQgYaIlb7u32r66
y+vHqSWuqwWU4O8Pi4MwQIo/jrQxxlMam1KRg4SJ8qA+P/uFrfyOnuHvqghH
9QP1d1hugBRb7qnN7Ks6CPgMeEEwYUcvVmlTHCbND5+IpheI8/GBnjZmX9VB
Lr1xJ4PVgEuAKUKTPJkXulpAaXQgihIvHTA+0NNGrSS9mX5v7S4Gq8GEnUCr
LWGnumEE/C3szYmVeOmA8YGeNuK/3kyhn4MXBBN2lByYtg+6CSm1tHLoBwGj
A74THehp4/YGkwr0CU0XvzB+q1JyYNpYKKml3POefBCw3IxlbLmuzUSHshm1
03n/+JKC1p6EKQ4zYRhLVRNF4yth2pjSVwfRFtSg0Ba09iRMcZgeHWsIk24X
XwnTxpqXOoi2oAaFtsm5xyqZSI+ONYRJIYivhGljzUv5RaqqF4ReTQq6ZwZc
YJpApkfHGsKkEMSKtWljjKd3am1BDST3tY0ibZ+JZCI9moEHXza5MFqf5bo2
ef6adLKbHe9EQSqyib56EsuBKQ4j8LN3NU4mkIsIr9ekYtrYSwgHQdJJVT6C
TEvQCJYwDoWp5d4d7yW2WcVen7YNXTFLk06q8hGk7K6YGJTmRMuO9+5Y/Zic
3tjr08YYTx1E5RcCfA46dBLGgnUtoMQcJl+GPJ69Y7HXp40xnhLwVH4hwOeg
QydhWrAmKDFdwJctUBitzndtFrM0K6vSQ0G+4vs9emKxKQ4z+xGnF5i+i+PG
tLGYpekyVbgKaouXSfI8bSpdy9to5yBfegGj0zhuTBuLWZ2DNB+3shBHsU0X
bU4+b500lVpAKdZt7qLTj+O4MW2M8UYO0qbLdAZK8CEGbYNpA0Gu7gYT2K8f
6zYzfacHxyRGXpMyVDVdHHyIyrWe1zhtnL9+XMVeoDBane/azBurg6i6o+aU
6kghJ2GKw0zJxukFvOf24viv0kYCsOKhCrUFMBIo5CRMcZighASvZt4QV9tB
Gf9V2qgXoflkHe0XyL8rzWBeo9gjMgD25sSK0+zxif8qbcwba6JPR/sFUwZW
Cs1gXqMK39EOlGLFafb4xH+VNsZ4aJpAok/TxQGM9Ikcuoa231qmpcSK0wsU
RqvzXZuEHO0HVOmtANgDPaW0cbw7acxx4Z7yzvHsibRdf+foNqQOohOrmdPA
Hy+dGJRqwWHy/ONjgvKh8eGSNqZo1EF0YvUZuRHUmR1DJCozLal5HhgbAXIp
UozxNBOuA3kpQYY/BnpKaUMDYC0iG3ORVjYbAeKhAGljjKeZcNs/VI/Uk6iO
hG7ShgbAWkY4oR+KT6sjVucAy3Vt3oa0VLRMdLCDT18/x3mNOEwl7cDdaqmP
xNeTtPE2pORzumQ9HlfXnQ72hA/nlYSphsDdamkJnGS4qhq5AZ2DNKkV7R3g
lBD80bDXVQF1jVcSglLgbrWwhSmbPOHDGeOpg9Al6zbg0c0TqG+ljVcSglK8
PDYx4eqxwdPbdI3cAM1U0yVheqIF6ltp45WEoBQzxnGXGSyMVue7NsdAqIPo
m8YpIfhjnzSxa/zQWROJ/ZfNBfEOTBvLcNqdYcfoeqHQNNLTnRR5IDSdNn7o
pGLORf7L5oJcB2EZbuQgbXcGxoLwNaoRndUMyMIlQSleHgWycnsWWIZ7Troz
MDOOr9FEjV7D5zXbBihcEpSCvVe3HkpKYaAznzaW4bRuEqj1qka0XsPnNRYu
kf9EARey53zNAoXR6nzXJgmKDhLvBI1ygx2YNmhz1VKoJbGZr+GlJh4rkza7
xCG5pO1LwU7QKBcTbSZ8OPckQemzKAKEbnDdOYire+waM97avtRsVNkJeqBc
nANK3JMvdqBEYjNfo9zpYN5H2hjjqUx3oFSvpIhAljxtzNCC3YGiDHNrMOUd
BfM+0sYYT0mPgVK9kiICWfK0kd6sRRkNIOsFC6PV+Ww0Jpee6Rpg4wuOfkDB
sZg2vldkj8RXJI18shyEySU6SHBdqsc/oOCtThtxmB3QmnyGKQurTxjcNfaw
qIMEp6emK7P6fEkgUU5+8MYqOeEbgtvzGmM8dRBIY/E1WkOxY9HV7naN11vl
5AdvrJIT9CIwrzHGU1ZwMKVFGxACEfu08f1Uylnwxi5QGK3OP7WZJOQejnOP
vDFRl2DCh/NTZst/fDSr912Y433klHIPx2lJxY1lObjBT1lb/gMH0ZgtCErT
RqI7HSR+WwbjBttMVJYhOJoD7+vjdcdGVoM6SPC2KH9geQ5usM1EQQlyK3zN
YO/jqrSDL3hbQtyY+OLJSpmCkkaM9Xj7zzDLdW2+P3w/44IIVxUf6Gm7vNuf
nJMSX+4Ue4MAKW0cscH3k4IPfE0Q7euBnjbisJKIguNpcMzME5ktrnEww2i/
zgxmuD8VlJYXipkZ49FB4mBmeLTfnWsIwwBKQW5ncMzMGE9bXAO0V0JvVrRP
0p2CUpDbycooupbr2hd1bx0dJC5C8YYVZ4nTRs/S4U3BpVKTIbmZLuTqGQXF
RajBOTq2++nwpuBSqX+czsl0MVfPq1mcglhAjm7Uv6MzzgLM1D9qbXde44vJ
l4tTECpiX/VM3HCN9+hnBJQCzIwyXZM6C1+MHvDHnj0SpyBUxD4zRze6R2vy
JMDMBQqj1fmuzbQYcxcxhY/ZxZj4lzbisE6U00RccFrpaTKvMQamg8TEXfP9
wZU1YMJuASWNuoPTSk+TeY0xMB0kXt7gyhoxQUseQdQ9vD7VxXgklMaFA1bW
2Lw84cMpBaAljyDq1oRJbn0KRzwJpYnK2rnI69NGKQDN6AaD2xYojFbnuzaD
PVYc2DHE17DrNmBJzWvEYdW71t9xIawSBnusOMS0SbKnTkVky7QRh7WnVe8O
C2GV8AZKcey43H/rOB9mcsIYeQJKVNC7Q3CrymOVdPdHOkgcyFFML5cPQzRT
UFKKVMgqGZ/SlTbGeGRXxoHcYD4M9eQVlHQzL1wYrc50bQUu8gRiLjekQW15
cf9s2hibqca4phcWyAVFsEeeQB+L1S7auSzWtV1spuMGlK4T9Fw06Z2JHYQV
TzpITNKjZGiu8A7rpwpKSrvyuKCTpncYcVEkISbpkcWaS/OmJIvKXGs4tBAu
KCMubrmYpDeYxcoBQwpKGg5lC6PNHVg5tXJmXBo5y7X1V6CDxJ2w5MjFLZlp
Iw7rLColSwcN9ao0kjZNhpPdFyPP4N4TRpUKSnqhVj2TOqeDQ5PhfKtj5Bnc
e0J1Rx18oBfqhXRwMMbjWx3z59kZndt7wrkeynnWC/VCOjhYZeBbHaeLR43/
730UB1Fpo7qjcp5V8CfzrZjbssr8eMWBBbi2Xk7JyY+7jzd3zPZYhi5txGGd
IqH5hMF9l3o5pYMEnSz6c2MZurSRH669rsqtGt53KZdTOkjcECcdo3maWoyH
tZVP63Rh3+X4AL6EaYxHB4kb4oKO0clbqhkPa6eS1univssJm8E1xmMUFDfE
MULL7RilrqB2KmmnYdaHeNgce+W661asWsiprYcFjyGmEPkyah0oj24SIw5j
3hbaXrRmEaglGMpN6CB6d+YxFPsvWrkH6DxwHLyqPn63Xy1BBXvTpocF3//4
ox+u89Cp7Coo6U3HUUu4cUK1hC9jPDpI3MZOnYcYadPGSF5BSW86UEugbv/k
agka4/GaELexhzoPE188GckrKOlNZ3KhqrmjW6am1hyvzz64YuXM+GSbKbF5
n6MaAnSQWNuWtzZ3mkPCiMOqeKzphVjjqE8bPDDVEGCc9mYUVDCV5E5zSBjv
IDoEUOVEBmsc6YlAvaP4pjNYnYkDOxSUNFc2os4ezNY40hiPDhLLUCxAnWmk
76qgpOrTgXKsXesm1DiiZFktekexDMVgdSbqu6oqCJl7dY4w2ibz21Ubt2/f
vHJqes2m7cfFuwOPto8Yk7bc5+ibTwcJlGRqkUeLJ2jMs84Oh++SWQyaXgiG
ASlD2M4IW3mfRLa++bzIxCqXgzUVicMKSioCpvXuepwhbCG3rTwYxEPThADv
dLEi/ZeaitHHkTb2BSsoaYsiPk0q+agy4aefn7WV90mzan2EifFYMo7QkSs6
ytuTankpJzYYBqSzNe2yYCvvO3Q0xkOB4I5tL8fplxeGaioSi1TLS7lt7ixI
144e2L9v3779+3ZdNz29cfvMaZn+FLg2gqK+Cp0e0NSai49m9sHlSoVTRlgH
xGg5MhDcVrYDrp99fHU9oOkgKrAPG6yETBzWATFK/gyUkJXtABfoo4bqAU0H
iQO2wUrI1CFRiVpNYqi0Sz2uJ4zrZ1/5VQ9oVo6ORl5AFI2HMqSNOiSqwKlJ
jGD44JiecJs872PM6gHNjEEs9Mr9EweuaaO+nypwahIjd/igvcGb7a4dBeT6
RyBnHxtW5wky3EIzoB46DCeCKHReIw7r1CpNgys+194UgL7ecJU/ZbgVj0dk
mi5Q2pzXmMXSDnpNgwdjMrRlDwdZX2+4BthMqcVqrsH8gskHfFA3XoXlNQ0e
jMnQKQA4yPrIaRrj0UHi+8Lg+QVESwWl1ZIGD2a56hhHxJx93BvVMx81ej/0
QnxfYFojd34Bs2cKSqquljvL1bXAteGnfZ2nepYx5xwPi2FkxYm9Ey6GOKzz
PTW9EAy3imf39Omw6VlGvpY2A8IGTx0iDut8Tx2TEQy30jmn8Mo+HTZV9aeD
xHtJpg6Fs03TxvybgpKOyQimDuk8U3hlXxVPA2wqIcRDVb6cOpQ5lgtsZDsx
db6n6t4H8mLx7J6+Kl5w3wGvIM6sBlOH+q5UsTH/ptMu9Hap4ueDLXBtkFov
65EX1m1DB4mjbqY6c4dpsrTKmn49PtwqUJW59YEvx4Ailu7TPKdsSy2ExnhA
D4tKqmcyiRGHdVCparAHIylZC6g7wOzLB6pCLGrc9iPiUWjDZwV2pVUdVKr5
yWAkZTxxry8fGARF6KSOo+4Fzgq0+6DOqNL8pE4jqr2Je335wCAoQoNhHHWT
EhPPk00bM4e6KzQ/qcNWBlvg2siZcNJoYEp5Jc8/Hm/KPJV2eUxizJJp1KcO
Ai1x7Ku6U/HFfyNn0pcC1UWS56/tzzBew4Os17xGHNaBdFrhCgZJx3NyebMI
LFgkHCROBfAanqtfzf5ZHb2qFa5gwi/QVefk9omBBIsEnTseYBpM+J18BDaz
ZPreaoVLx4PW45NYAfW8egcWLBJU53go0uAJv8yS6XurQwp0POhgC1wbdasL
V/u/st7u2e+gqj4w0uR08sIkRhy2SJsbRnvSdQZlPT4RG3WrvnHMwdWgallS
8TFBMnCQip/XiMO6QuVIBFJX+pnit14mQ8nVgqsBHCQ+JvhxEGQmXDlPeQUl
HSRNCVn8UQ8aTrfn36oFA0nhIG7RBO0nwdyZeQ0xpP2/gpKOjyT5Fn/U8AO/
NTEqsOCOiV4At2iCjyOoyc5rvHooKGniSMeRD7bAtZHtYdwSWHAKw0HiOddf
dOT2IKE9r/Et0tG9ml4gExWm7wCyPVVbO4ufHFwNQCN0Y1d05wUTJOc14rBe
/81BeHvSOeO1DKeou2xP1dbO4idrB0HdaXG4F2o0jeZmYHifUlC6QUYZalqg
Hj9Q8LOqHk1djfHqTqzAvVCjaTRIaM9rvE8pKGnpAd8nYCrFEQBYSUpWLTiF
0SxDlV19JZpGcxPavE9R7bweLz2QATXhA10LXBsfHN+BwIINDwdxfy80KykV
fBLjMarBic76DASjWE2uu8lxVTuCLX5ysOGxPDfLB4jeOj5vdF7jjlVQavQ8
u9VqObgep9vhXaraMbvxk4MNj2YZxPBBlg87UPtTJjHu2HUCStRsr8fLwfX4
kGW8S30/LtgYaJZxZ4ujOXfn+CDIeY1VVwUfXS0n3cCU2YJ3qe/HBRsDzTLu
bHF0owTzRuc1Vs0UlHS1drgw1zTYAtdGQblqU6bxiznoGX+EWI0bAaKvXMeO
T2LEYU0pqDsH41c07YybVF8UrV2idecgbgQI4jcHNU64chZulPKk7qwAVY+n
nZH2r3qu9tq6XncO4kaAIH4Hn9G8xmS7RkT63zqMuB6v4uH9r3qu9rvHYzwI
SrhkDBC/g89oXjvUJds1ItL/VoCqx6t4eP+rnqt9EOOhWWYU3oyDEgSags9o
XmNvhYIS+3TqCE6HWcAyBYz0XRwUsetOrIY1CH0lKGRBrWpeIw6bczHPqSd4
0FWhiUTENvG2gSli1103mZsrA0MmqFXNa8RhBSI9wYNpVlqXwZUw3jawoKyM
bjI3V3ZZSyEbvSenJgUlsl8UiPRaEcCpOiAuRPFZBgvKynCQfV6uDBSy3FE4
rFQqEKmzaMagJki268GFqBovfdKCGA/dZC4ogUKWW6si+0WBSE9w5WINtuDU
toAfv7JbpEO4zjoI9ItcyEIxWvmikxiLnlqd1PTC5cLvqsejCItnsHKXPchB
z/gjusl2ewl8dPUqX3QSY4+MVic1GRhMLFUHufUPM1i5S1kP4ofGQW7f51YV
IY+mfNFJjD0yCkpaoQgmlmpbNyoUVU8jQxA/IKgIUgcw1NqCg2NeY4+MgpKW
3QNRUNWaQIWi6mGHBvED2i2D1AEMH3dwcMxr7JHRqdyaDJy8SS1hgWtbyIRf
WfnJtMBV4SDu5Q7vapCinNeIw9pae4ukFwJxEmVv2uGOlbvt4YGrIup+zLvc
4V3NTVGSMaKgZA7C8kogTqLdfHa4Y+Vue3jgqnAQFR+g4ZDS/MMkRsaIXhmU
VxCMvNF7pR06WLk7uzOgDiLqdkEJh1TulCv2wWlOQ3kFPx6HUx2rZIc7Vu72
RAfUQbRbxuniuhthoAm6SYx9cHplULLT5FPpExa4tsWNFiFU481rtKA4i3ZL
Nw1uEGHvtgLRJEYcVqKjUn+DCWIaOJlLYuWuFFtQnIWDBLxuGI6A4Ded14jD
CkoUNaqjsYaaHLPfCCt3p4AFXBc4iDuhFXFp8JvOa+S6aODNsb91JGWzV5Jj
5pJYuSvFFhRncS11M06IS4My9LxGrouCkhIGgrGGmqAwl7ywXbkrxRbEeAhB
kRV8ZTxdjPg/tww9YnLuOKh5DCUMXJ4z1rDPAte2Z1r4UY2rc9P0E6+77epG
I8jkK/hPYsRhTvqoxylngV6lZvAskLZtX/XInusnXrcOYts1uMbCMC5QwX8S
Y7ulZgOUchboVepl2SDa3KdP9lw7ZequHzm4xsIgB6HgP4mx3VKzAUo5CzR+
9bKMQLpP9jyI8eAgbm0O7zZivMkH2LHdUkHpDqGcBXCql2WQ1gxPXNnzIMbD
Hc2tzeHdBs8NZJhJjCwdBSV9uyYfXZ2wwLWR/uqb5hMwRoDnAccYhpyAoXEf
+8U14rD2TGl6IZD/1Ysb0l9thdTpbdGH1B2ed3mbMVBCOs5+CvFkEiPnUHum
tDoZyP/qxQ2/bJ8yeRD5YEytm7eBayDnMPkYOOoeKyhhr+ImFShCa80Xv6yh
liurG0Q+IAzvkFwWDdcfrNxlv7hGwrD2TLEvuI70fsHzAa8Pv2zfiLHuOjYC
GSQxXBYTQAArd9kvrpEPqaCkN6ms2Wd9Frg2DheLe10x9iAnDwcJmLowRBcW
airDZF4jDmsjp5b1g6NNOSc4XPo0ToMSJwIel6mLIhqC5MlXThxWUBqlGtq9
HYjnk0lVd4dLk0bwgNqiegUZNOxv9ZLJqEfYyvsoea6RLdkk+jpQ0lRDIJ6v
nBNge9847yDGw/3RrXBhC9nKq5wYj7KfmuhTLlAwbkA5J7gd9MW9QYyHcYpu
uhhbCCufHJTqbvyEJvo0qlc9wMEWuDa4HJf1DAu+4a5nlaQN9Vf3ooGUiO3D
CXUtYOSlq/wCwT+e46OtlyhVN+eI19vS1KGEpA0HCa5UMKRE7AUX5YAScVjl
F3jtxd/qTUH5DyhV96mlaR2q7hzELbuD+mIrX5454RG8dE2X6QU/gFNtVwHV
pG86VRDjgVEPlktQdsc3beVZoFR3PE+tPiibNLgpaLsKqCZNytQTgwpiPDDq
XVBCusZWngVKdUe7VVBSEkjWgKQ+U9fmDNOrbhsrZdIC3gXeUgQSH46nZBHr
2kWsr9PENeIw56vW0u0VK2xr6xaGjFw7vkJawLuAqJqbkkWsayvPLSyCoao5
fPYjxNqz2puMW0awQlrAu2gdZJebkkWsaysn03JCwxggzeGTkBArbGvrFm4Z
wQppQYwHB3EJioh1beW5Y2dxLisodTHkJ9hLOoHokPST4vrTrtD5iUGMh5YT
l6CIbI+t/IKeTpM+wzVHQUljyGVXZox26jN1berUrR2natMCsT5gjt5uaKgr
2cHnQkTCgMOaCWd6IdadYxc2DnTbgQFVmxaI9eGgcetESOHayl2ISBhwWG8E
dJB4dtJr0QysgKpNu/7OMbE+jItyi9co7tjKXYhIGLi1Ckr3d8+PZydpFzYO
dJSS45Sjco3qrjbnFq9RV7KVuxCRsGZWyF3PKigx8xNPUdEubBzoQecLTblG
dResuuliXAntxbnkMexwnXrAilvuFJU+UzYaFPZs2yBjSXa6neO2DPuyPaDd
63CQIIULQ4nEvtjRP+l62oNAx7vQAWMZT3LA2IwZpG7sComV20GmGtQoXruM
GmSAq/4G6j4DDisokSgeK+aRA8ZmzC56Hy3G7h1YuT1W4VGL1wGjBsRy+8oF
JaSbFJTogLEML7kH1EQaRe8dQpo3YeXmDroSFK/v90AJHE77yp0ojXSTykvS
AeOpT+QeUNEC0TvvkvYpYOW2ToVHtJy46WLEjfb1rUxQQvlV0xQsIucOpeoz
PbXf6SQUlCBqgY0FJxb829kRzNhCfs+ttqDRo+pXdegz9DjozKn7urt8rPVH
NR5KKHQE0dGhYOEWV646P3CQQNgBhjxq1a/q0Gd4cxSUGDbHAqRU46E2IPXq
8QJDUQs/sHIdQgcH0dZjGvol7WtCGWSaxTP2UerMKVE1D7X+KCBJbcDuuBlF
qra8C7uV64wtOIjLPUa/pH1NKINMQ6ShRa5A1VzhlJsE+s+GSNSmxgtsS3Dl
KnqDSi5DfV0Aoq+qX9WhzxBpKGcgUDWffNRCn6lrM9YCgKDgi73n/iBcvX/r
lYBxl6zaDEPWeoDDdnZzEB6TXbFWJ8Wp6PUjFkpbW0Gt2Z3pgKZFl5eCZIt9
uem4hAGHtYbFZBfOaBXoYARCr+9YKE1tBbVmd8Jp4yDXPuryUkDTta8Jtdlp
qKJq5Z0c0Virk+Qcev2IhdIWfHGnc8cuw0ECBg4M2kQtKOXFeOCJaeWdya5g
XEst5BwKH2lvGmoc7thlkKYCtRkYdmADSpkXT+jmKSiRG5k7uabP1LWZ/FRK
HkIOV4wOmZ8gnQjDZravyWcjwuzDbQrrUr9meiFumOXuYvKzq3Q3jCPAiytG
h8yPltVo2MwNKE02cogGHNb6NUtUsegrzxRo9ex67uio0t0W8pCq2uWNZmgd
5BGXwYvN3IDSZBNVaEhDKSjRQWLRV4bo1ApTRQukqtzRDMhNuQxebOYBoIQ0
lIXxBCWWqGLRV4boPBFU0QJdAK4KOliFWlajASXsa8KJKjQkchWUKIYQi74O
M3VtshFUtAfnoNvWCgdx8z+QR6v6FRT7DAVHnVZMYkmsP0D4xYLtM9KcOc7B
gGgNQ/LWBSWcSlW/gmKfGQ7bl4ISku12Lsf6A2SvuSLDOAfdHk84iNuqj1Op
6ldQ7DPQetts8wiUSCzRUheM7LVAZBjRFA6FgGgNA6tQyTA0pBnta/JBgTDQ
epVUQ2JJLFdL1gTDP5U7Q4+2qymHAr2bLkaasepXUOwz9BooqYbUyliudpip
azM+4VFSd+V7l5OMvpWgUgCDPFrVVvOz1gMcrmQCKemgcZMyr3v8K5WdRNTq
0v+wZqWw0oDt9jX5eF8Y6gWgIuA7pIPGos0c98O/0ilFiFrdvjOs+TfjbBAY
tq59TTi9lIZ0qFJTSAeNRZtZRuFfAcaR3kTU6jbDYs0BGwSGYLgBpYmnl8JQ
L1BqCumgsXICeRH8q+MypQhXabcZFkCK/w/Uh5CRa0EpL8ZDQU1BieT8GE6H
mbp2EO1jYoXdfPtSBKg0IUQM/gqVXPvimOYJzXDY0KySWw+bOGLNB5Zm2K+n
EysMD/sIM2h718YTGiq5A0AJOFwJwYNNHLHmAyvd7ITCOY6JFfZx97H44CDa
eEJDHc2+rukRBu8zkAGUL8cmjhhOSSsiy/cDmUpmaL/8p9tcmitcAx2scaVs
GUBp4pnjMDSiKiixiSNur2adkSxfnauL3gG3awCRBlYeV8rsX9n3J585DkMX
koISpV1yB3P0mbo2K2tn5Fc2VOxTYkcormpUNLBfqv5pBX1mZ+W3f7a9EtYZ
AeexiH7M2iVPdlRkkMaxk6jvpo9QXNtF1exYrPqnFfQZ0uOVsM7Yehkru7L+
wpNd57zb6d+XfoSD2MpdjgS6mfqmFfQZ6rYKSgScWK2CvCae7HAZRFkWcfXd
9OEgtnK3Y8hOh6p/WkGfoZdfQYmtl65aBRTF9Yzg1c/Cxb6bPkLxW1opg9j3
zUOr5uKZB0qYMQGdInyHrGlXrWKAqWuTMmqoizfBIHpZN400NnAVAvYpzVZe
tcz5rPUYDi9v/yEHkVMwIZYGojsoZfSCtrfF7qF6YQ8MCTRzXlci2L5pf6vd
HJOY4TBWTlCig8QcRfLulDJq75iFQLZ5Luhpz6k7Xrqt3CVuwUNz6cc4ahWU
eCK7xGm8scrOYrHSntP3vsFBbOUuKFl02oJSXoxn75Id2UqF5Yns6mwgE6IK
A9/u6gJ2gPa9b2ARQBAg/ttLb9zZgFJmNwcuVkqFZaYrV72/z9S1lXyC+jIu
gH1zUeEgfRH7Je0RdmvPEK4+MxzGcU9CKTHWpXzjrFHyiS3GDlBUl/rmosJB
bOUuKFl0OgCUbukEaghKPDhcyjfOGq3zgtiMPJ5OoFaDg9jKXYo7bgQ39wzh
6jPbXVg5QYkHh8uuxFmjGlPfW/u4xdLI4+kEajVkmG3lLsUdDbl9Q7j6bH0n
UENCKeNwVyEEjQZKPvlfNzd1DeTx3H75ujvybOUuXfAH65rUkHbsTmIoGWuk
xDjcVQgZYMpGwymMi5K91RbNIkjo005HXXj1hr3u/Aj7uKtxEu8kRh0k7hBe
VF1eKIipOvMFM8JQkekb6AAHsZW79Cf7uKv+yYB9ZjiMlXOH8KLqktVBTNUy
1g9/9YRFs0in9403hYPYyl36EzKQfZMB++w3nQ4SWe5M7rlkdRBTtYx1xfom
hYjqZN94UziIrdxNI/yo7bDomwzYZ7ieVMJypzihS1bHgaVlrFVtlzqqk33j
TXGmQKUk/ltDBvvbtZmgdHunL0oHYXEnV+K7z/TUViVk9Kiiphx0NNOQgrYP
xeVkrvzlE1WPpEPCiMPkijO9oINdvlz/VU0Qqwkx6AOgZBbILNCQgraVu5xM
Q4aqR9IhYRs6HCZXnJLCbt0EQawmxOymaetByaxvLgMcxFbuEsXtU6t6JB0S
BohWUKKksMtoBeMOJSHcPSGqg5JZ31wGOAgK6PHfXnXb0wNACTtQQYnZb5dm
D8adZuktzDaQRDKkby4Dgi5buUsUt9O8AaXMRi3sQAUlJsZzNeL6TF1bJYJx
g0airE/qHMszuHbr9RahaXQ6oRGHUZKoJb2ge4kGooV2IjSplasfsZNoWb/Y
CGo0tnK3e+Xqjc02cylVCSMOE5TYlO1WfEC00E4EO7MsWHWLLDTUaMB2iP8W
jcMupSphFCYlKLEQ7zYIgDGo3abo38Q74I54qDvqka3cBSXbb5VUPCc0II+C
EnlNboMAGIPKxMD4TkDEhz2Cckjy2MrdljpcIbUZfxK7r9N5ZgMLeU25OsB9
pq6tEjpQALiipbn2/Vs4iL1dbmrx+jufrcb5+ZMYcZhtICQ7ubUqqFvHul52
fiWazuAgtnKX2WhYUfXwPBNGHCYokex0qyckBfHeWNfLQsREJywcxFbuMhtv
ahUU78gEJXyOlbSBkEizwVO3g3ivCuqCjW8rT3TCpvt8oaCY2+6Ez1G3GYk0
bmsDtEm1pgM2vq080Qmb7vPFRawv1dxn+BwraQMB8c8uBW5rwwBT11bRCSD5
hau3JvIDSKSYc7l0a+geu/KJCSMOg7xRyzy7tV6VDaknSCvoE2zlrlAMDG+s
rdztAUFayZVPTNh93eAVsn85z06nadMgN4GLjz7BVp5gy8BBbOVuDwiuM33p
oD5DBFhJMwWpcapaTIMGjk7zxBNs5Qm2DBzEVu72gABDXPnEhHGOFUGJ3bKu
Lh/ErnWaJ55gK09Q+HDRsJVrdy0NGJILStu6wSsEJXZwuHA6wNS1gcb474e6
aTWJiBqZxouuecSl4qB23Jej7jPiMDu8mF7QIYw09P4AjfEdTqtJXPPxgdrK
3cY0hMR9Oeo+Iw6zw4ujndz6IDjnKrjEaTWJ3CMcxFbudssiJO7LUfcZ4EJB
iXoLKgJPwxGgKnBI6lbJaz4cxJ7mZmZwlKjOxiTGd4ygRO5ooE4DwxGggjao
kVXJaz4q+LZyN12MoyT34omqooISR4oE6jSDTV3729L7s6v7lbVfKbAR4q3y
EQ9xhbbeTGLEYf5cDrgPhCBgP4h6fzipzZVSh4HiYit3ScsI0nJbb4jD/Lmk
MesxQYPCp/b+7O0GX7pS6jBQXGzll3mkZYTWdoZmrRx8P/25nPWg6RcaFD61
IZFN7ok3DQ5iK3dBCZB+XyYo7ewghT+XTONACAKGGEm7pFEsS79p2FG2cheU
AOlug2HCQGfSn8umlUAIYh47e2zzddMocm3cM0Y7V9dWRSb29SfmD3I4pkv6
QniZ8C/XcCpVUomgg2BHBa9HcxzqlfgOsrtVcigqh2O67V0ILxP+5T+zw2GC
Enn+GnXT0JQBYTR854Wur9+dbQTjcMyVHukLFZ9cUCKMs9uIjfAaddNWt00Z
yHLgO8juVj2zjWBgd1c9nRSItdxRBQkjjPMEYSO8C6fIydj3ycVlD6872wj2
JHVFvLwTgDG3vZowzg/rWNcIH8ysTNux7SunpjedPFufnn1wamrVYUkt0LVJ
IMQfX+m64xPC6UR7l2WHMM/tTEwYcZjlUfYV4oAOXo+mDAij6eur5DQHOogL
SoCXHV5nYsKIw2yBZF8hmsKC16MpQ3Wh2QmbGCNIB3GZqIAXpikmNNCfKmmB
ZJu2znqgQaNm6qoviWfshE3MNqWDuExUfCJbeshRfYbCqIISx2nprAcaJDi0
ffWdrkUxMduUP8VNFwNemDud0Djgm6DExg0dQDOvnZzds2e2PXzn9k9NTc9I
mZquzY4e/BESAWnFJ7qh24+Av3UncCWMOMy+bKYXNBVAsyjdPqxKbtZo4l6+
emtCi5tu6NLj8be5XXXEYf7K2PAWIWgqgGZvGlbOmzWauO2elUih0EHcfgQ4
qdsunTCG0wSlkY7B04fB/wlebw5iR7bSO9HoZwCbEOylg7hiueB+u+3SCWM4
TVCijgHCueD1iNKV3slGv8SkGLqhmy7G3/YxNvuMmlEEJXYo22Uht0W0ro9v
WjE1vX6f/g507UAFC9S7dKsaHcRtkgKLzB0LmDB8xJUQyZhe0AiQZnEXeiJ4
2UE7WFq4ieeUm4vGVs8FJW4A/sqARztDUecKXm+/C1bOKhu6XdLCTXx/3CYp
bHV3LGDCUH/XX5kaF6oaTbMjDytnlQ3tYOmzhu+PC0rY6u5YwIS90Kld8Vem
xoVK2dNuuiecB4TeFjc/RuP747oD0ry5oIT6e9XeevAdOuBl4zMr57W5Y/tW
TU2t3LgvwKYpMYT6+L7Br+FeOu9HB3ELZHaLse2Xy3InDlNygY3MzYU6ovPZ
j8brmYq3w9o+gjThhA7iFsgspLeVuzOjE0YcJihRJQn8xuD1qJ5X46l4OyLT
ZRQ6iAtKFuHYyhNJBteo3cceYaokBWp4MIvDq3EycN1mqNK1XcrluQUyA3Bb
+YynhJAw6nQRlKiShKpo8HrSmDUVbz83TSqmXJ7bTm77054AkZnJbbYTVWNw
SNlbF077bO7o9iaBtq95yNmz40TN7tRWEdoJ7akuBF34pAMacZif8rFOjBF0
8eD1v+jaSbLydXSQ3FajhBGHmUqizh7o4sHrOe84K19HB1n44Bga8ypMJbHt
/eJrHo3hlO0kWfk6Okiu8E7CmFchKL3fqXOo/iSNNOasfB31JBc+h4v2RicH
R1Ci+EAwszJt26/Tw3mle9ceoO3wTHdHc8dsDTPiMI8e3J5QYtgQFXzZb5UV
P+/vHKQgKBGHmd/mdELN8tHoIFmXejpIblN2wg51eokEJcjX3Pf4q+70NzAW
NJicxOgguU3ZCcNlTUGJ8jVoLghez36rrPiZgqu5TdkJo14iPY7JLpXzXYjR
tXVM24RGB1n4EBMacZiaJHAQdOvEFEoOSoaS24TG4DlXKSJhzG8TlCCcgpXH
YTYdZF9/2SU2OkiuUkTCjnb5bYIShVMqj0KJPruqv8nLtYMdaBcEJea3CUoU
TmmUrCI4RZ9d1d/k5RoViXPlaxJGpUd++hwbF8ysHGx0bRVundDoILkNOwkj
DrMNB9lXMMRiYgAbErMumHSQ3C7ChBGHCUrIvmLlMSOdjTCJKnZsdJDcLsKE
ISdQibIHZHawwjhrcUfXCJOoYsfGqCZXUyth1KjkewiZHaqZBa9Hz0iVrGLH
xqgmV1MrYUiaVSKURF2RKr9NxjW6tqunkTamX3JbmxNGHGZvIBwE4WtMGQKD
t+pRLu0zOkgReIQRh5k5xBgIrDzmWd3RNcJkZRrpILl6CwlDXFSJ3BBy9Vh5
DKd3dw6C8ccTGh2kSLQJO9WpaxKU4CBYeZwERlNV1Y0/ntB43MSX98GGuEhB
CcQSrDy3Fdo1ujaF0Sb/t7wX57a9JIw4TJBBegHyNVsj2io7xfpas10jBylX
BCZh1AqmaA8cBCt/OOLSs1OsrzXbNTpIQVBibZcgg2IWVh5z6dkphoEIExod
JFeZKmEATwUlOAhWHnPp0TNedQMRJjTGYwUzM9gb1bgG2rJu5blcetfo2u4s
3bTRQXIbhBNGHKaSGMQ/0aofkzFwH6yS3LPYOGijSOQDIw4TlCCOipXHeRt2
iiW4Z7Fx0Eaf7NsAo8oxQQnVXqw8JmOwU+xYP/csNjpIQVCiyrFGPlx53Jr0
cNf0lOCexcYLS8F08dkvvogjn6//ZAtWntua5Bpd2226TxsdpEj8ACMOc9tA
PvqHv2qUT+JRIGxpP9OjAOAaHSRXSiVhxGGCEj4+rDwm3NJBspru6SALH9JK
+6zTZ1Y9Lq48hlO28Lh6433GqRO5qgUJo3CuXsfMQbDymHDLFh5Xb7zPjneR
5Lpy6eK602dWUFr+021YeS7h1jW6tgqjTWiszeV2tCWMOMyzDLen761tZPHi
ZDIaS6tolEba6CA6OXqBRrV55VFz5XujZDId5NMeQRXX6CC5onNpi8+y/3nl
Fqw8hlO28ATzfdJGBykISnXryAEoLV+9FSuPSRps4ekTVHGNuYiC6WKsMwCl
b179CFae27/gGqvdwaDzSYxFk9ze/4QRhxlgQ9f3kusbMdu4NocmlFh9JW1M
1t2Z2fufNuCwSu2Zg2DlcW0OvcbxpIC00UEWPn9ZDTr5CkoXrt6Klcdwyl5j
V5C/z+ggMTlhITZ11bYAlGwbY+VxbY49bgmue2ynurlFBdPFdSuOF4DSxdc+
ipVn1eb6jKc2OP9Z/5YOkquSlDbgsOp/2v6HUHackoWD9E0J6TNmsxc+xVgN
OKy3fsMcrDweJgX5gozO3NboILmCJGmz8yIAJcwvrro5fWqQL3A1hxPGLEpZ
UILCv4KSuQxWHuvZghqdK3TwYZdFKZgurltxvKodi8PvfPtn27HyPj3bLKNr
qzDahEYHWfgsYDXMJlBRYpwpVTuqJngx+ssSMmiu0UFyO+jThtkECkr4Xapu
7Kkammtyx9zTQXKl29KGuSeqoonfpfJm84EC4aoXJoxpxlzptrShe05BCXMW
XDhF91lCBs01phnLgtKla5rZBCpKjN+lGp9ZOdjo2iqMNqFxAmmurEfagMMq
jLm8c5A3o8QmmkDTfV6x0UFyZT3SBhzWtNhFV48c5PA7IWEAnXHpPq/Y6CBl
QQlTFVTalw4S14nQGTd5TzGMDlIwM1N3UxUUlDCIpPL4VxAYSfd5xcb8T67I
bdq+f/OuAJQwiKTK5F/1GV3b7YZOG8dxxkXbhRiwS3P13+wcJC67o0s6d4o3
K7llQQk4rLl6OkhcdoeDZLXv1eIguQJoaUP2RkFp+vqRg8Rld3Tn5U7xpoMU
KdrS/v2W3QEomed2cBqW3cGfzJ3izQRpWVC6vBXqV1ACTLlwOsDo2m6nTNro
ILl96GnDL6iJDpzjlVdtQYtKQrzUtTOdg+SqMqYNOKygdEnnIHG1BT1cuaN+
57oSW5HSJ+2ydrqNghLO8RZOw+I1WlRyR/3SQcqC0g9/9UQASnQQHbIGA8E4
d9TvuS61WzBdXLcKWsGWxnSkanxm5WCja+sk0wmNDpKr2JM24LCW4TA+zL4+
/DisWaBNPrfLgw5SpIBIw1weBSU6yPsRFwjtq7ldHnSQXMWetGEuj2pff3fN
zg5OQy4Q2ldzuzzoILn61WnDwBSdor6ic5ATERcI7asDWs+WXYl0cUlQ+mk7
g0NBCePDXDgdYHDtQBhtQiNJo0gZjmY4HJSEmF6IVW4gFZjLF6WD5Gobpg04
rCWhSzsH+Xgu5AKhizaXmsXiYK62YdpWbWgcRAX5EaK7cAoW4gASOxwkV9sw
baBvKSjhaKg8aiVIVgNI7Be2idz7i6aLr2snCikoIUSvMqmVfQbXDoTRJjSy
mLIEHOa1K3/9ZCBrz/RC/GLw2HPpcHSQXMHVtBkOB7L2dJCYUYNGjwF0ODhI
rgp02q753b4AlOggMaMGPPYBzBM4SFlQwiwkBSXETpXHqAGPfQDzBNXzspkZ
zEJSUELsVGUyavoMrh0Io01odJBcMa60GQ4HszYw9NOdk4he2gGFddBLcsW4
0nbt7fsCUMLQT7eQClmbAYV1lAIpl1fEfr7p2QCULuscJCYovtk6yIAaFkqB
ZUEJOlQKSuBqunAKtboBNSzQS8qmi6FDpYHoFe3Qz6p/4luWucJokxtWkqsQ
mDbD4WBiBdJT7thZCCAMeM/hILmypWkzHA5ACekpd+ws9E4HZMPgIFkKJ/Pa
2t/vD/AH6akLPTgFVWlANgy18lyFwLRBZke/g2uRS/MDE2NAih6VjgEOkjD0
b6p67er2WuTC6QDDqc1xKrn/HMyxLNmlec0uoQEbB+kFl91hV5U/Pf9WVkcn
DLXymCC9EDv4xt+DtwKTiF12x0efNCuPs7jzGhwkV+A9ba8cORmw3DGJ2B2Y
+/Hc57bymGMwr8FBcrWU02YX/+BkQWLNZU3PfdqsfED+GbXysqBkN7Jg5cgb
5LKm+wyubVeVd/9+Jqt5CgYHyZIAGmBIL+SS5dIGMsneoqAU24/b21MuWS5t
cJCyoBQbHCQxM3SAwUHKZmZiu+q2JvOcmBk6wJDtKZsuju3aNuORS5brMx0M
NMDgIFm6ZAMMDuIKvA82OMhigxIcJJcjkTaQSeJWsrKG0ow7pHiwgUyy2KCE
lKA7pHiwIduz2KCElGApOF2ga8NBckWYc+3KNr3gStMPNjhI3EFQ1la3DuLO
yxhscJAiHQQJu3rj08XhFGSSLLHEAQYHyWXwpg3ZniINWQlDztwdrzzAFuja
YFvFPPyyhvRCLnErbXCQIjz8hMFBcolbaYODLDYooeqaS9xKGxwkd6BMrt3Q
Tp3IbYhIG9KhZdPFsUFUP7chos8W6NpgWxVhsycM6QV3Rslgg4PkjqvINThI
Lg82bXCQLDXRAYaxLGXhFA6SpSY6wFAOKzgOoO7qBWXTxbGhHOaOtB5gC3Rt
OMjBzBk6uXZt6yAF5fLqjq+72KB0/Z2NgxSUy6u7ekGWxPEAg4MUnK5Sd/WC
xQalm+5pzr6C01XqrqC22JmZdZubuUWlpqss0LXhILmDvXLt+jub21NBTa26
c5DcwV65BoHKsppacJAXc+R2B9ja1kEKCv3VXUFtsUHpltZBysIp0qHUDF8k
w7yMUiMYFujaoCNSCXORDOmFghKFdecgiw1Ka9vbU1k1MDhIlgb4AAMVpKwa
GBwkSwN8gIEKUnCiTd0V1LJm6wwwDJQpNdFmga6NivMbOYMJBhjSC2V1zFBQ
yxpMMMDgIAXFFevOQWLZlrIGBykrrggHiWVbyhpm9pWFU1ScFztdvKEdSVYK
Tkk0HfbP4SADiElZhqGWZVvq4CCx+ElZw9TXsn2+qDjHWlJl7dbWQcoqsKHi
vNigtKGdFVVW7AhXwsXOzGAUTilZyAWe2nCQATzPLIODlG0GhINkTe4YYLc+
0DhI2WZAOEjW5I4BhmFqZQUtUXEuIiGSMIzNKitoiSth1kS8AYZZAKXgdIGu
DUpG1jihAYb0QtneajjIAAp3luH2tBhtjEWEOBKGcZxl4RQOcmiRMzO3tw5S
VooTOZPZRQalTY82U65Kqd4t0LVByYjlLMoaHKQszQ8OUkTOImFwkLINmHCQ
xQYlzKst24AJB8kaGTnA4CBl4RQ5k8VOF2PKVamu8AW6NhykiChEwjDxvCwX
CJylrHlbA+x3W5vgsGw/O5KKWfO2BhjmJJbtZ0fOZLFBCXMSy8IpkoqLnS7G
nMRSraMLdG04iCpvL4YhvVCWWgkHWWxQwqTdstRKOIiK3C6GYdJuWThFzuSd
RQYlTNot24mPpGLWEMAB9sDuZoBdqU78Bbo2OEsflNB7SRjSCwHVYYErh4O8
t8ighFntAf9qgSuHg6jI7WKY3fhiUugCVw4HWWxQur+d8BiQQhe4cmTddRzA
YhgG2AWdcYNXvsBfGazXAY3eWYbbU0BnLeIgWVMyBxgcJCiaFHGQrCmZAwwj
UMvCKRwka0rmAMMI1IA5tsCVI25c7HQxJjzuKwSnWf8wfjEc5JOe0b0LfDgN
DhIkMRb4cJSlVE+y4MNpGKIdcN4W+HCUpfpAqdTK4SAHFgCn8YtRluoDpVIr
xxDtgIi7wIcjbuxLF5da+dZ2RnApOC3iILGGcJGH0za3DhKkX4o4SKwhXOTh
tAd2vxbnhIs4SKwhXOThtIdaBykLpyhLxZLsRR5O29oOby0Lp4gbY0n2Ig+n
YTZlQCGe5OFTS7ZkS/aVsAViyJIt2ZKdv7bk2ku2ZF9JW3LtJVuyr6QtufaS
LdmSLdmSLdmSFbfj+zdPIz+4atPRpn4yt2f9yvbPK3cdXVwuQRGb3bxyxUb0
6503Kz97cmYN3vSVG8+v9/z07PYV7UJXrNnSlsHOi5WfeXDl1MYZ0FnDBc8d
3TP68/o9i0u0+kfb0VVTU5tm7FM6bb/+ygcPn57ZODW1/thcfWzP+qnpTYvL
7l2wzR3e0myzTY1rnz8rP7N5hb3Vs82WWzG14sGj59PKp6fW7DpW18fWTU1t
PHDmPFj5maObW9fdfKBx5GjBpzdNT63bc6yeO7a++Y3+GX+DgXb25J7t+8BC
mGk+rZkDG6encQiePbBianrmnxaJzc4eNlxat37Vyo3NHPDzZuVnZlZMrZk9
fuzA/pnZw0dPnjl73qy8BaV1+47X9UnzCHOEf/6Vz26+7rpND15n51frtuGC
T8xMT6040J7Ws5tWTG3MGyh/Xtjx/Zumpqb3HbdttnLdyNdPb5xeuf+f78Pq
bG77dVPX7TpeH92MgPy8WfncgRVtRLtpk4FpEzKdNyu3/f9gcwSuaG4TK81X
zpOVz22eHp3I4YJPzKycXj/688z6Feu/Yq49t3+TnX4rza/tDzMbV3S/+8n1
Uyv+WT+s+sysYdHUxi3bN69baW6yfeb4+bLy+swB8wws7+SeNdPrZ86flTdn
HO6ssxbmnjcrP7Opc+1wwScsgupce/+6r5Zrz+1aYyiMZM7Zs2fr43vW2PVv
rkkv2DV21eECw8YXxc6ePrp/3/59+/bv2nTd9KqNM0dPny8rr88etfjwwcON
G8y08eF5s/Im3piGZ5hrGyidJyv/0rWjBR9b03wWzTe2rJxauaWk+s3/WWt/
wS9tZZOPOv3gdaOU+eYDi6tHV8TmZjetHGXIz5uVn57dMlroivWti583K5/d
vm60V6bXHDh99jxZeZMi6FJk4YJPH3hw9ButevCf9hcoaHNnzsz9kyLwPHb+
rLxZafjn82LlZ22lY5H3ebPyzsIFnw0/iyVbsiVbsiVbsiVbsiVbsiX7P2j/
G+ZcQdY=
              "], {{0, 213}, {329, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {329, 213}, 
            PlotRange -> {{0, 329}, {0, 213}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2350a1b7-f1d6-4590-be2d-9945b0790305"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c33b3337-8f9c-4511-80f7-8be45123a94a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"00d62392-1596-4b05-aee1-a472340943fc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2c281dc9-eb7d-42de-8b10-49eb25cbc65f"],

Cell["\<\
Join lists of the first 20 squares and cubes, and get the 10 smallest \
elements of the combined list.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"d932dadc-18c5-464a-aa26-fcdbdca30367"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eeb608c8-0b2b-4445-9918-1385aee8e740"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWCGvrUYQJq2pbNJf0D+ArkVWkbymDvNeenmpuSX3NWmw65C4dShSgUKh
MKg1mK1Yg8BgEDTBrFhxu7PLAc49C4d7+8RrwyT35ByYmf32m9mZ2fv9h9/e
+V9ZlvXpG/nx7v0fztPT+/Cnb+WPnx8//frx8eGXHx9/f/j48PTDh6/lw+/k
35/yD74/n3LKKaeccsop/x8Zisi37YBy/XNsKG1Hcc/qoBr4Z3XdDnxHo6Mk
z7KCsD2l57EuQUv6egO2ntVFluVlPexAHjtSyCVywvq1q1lYNx637deWynqT
Ld4TubVcEtC9GvMkVySLodH+LnjH1HccD5F+cjRSLCc6P8o78dxkoaUkInvE
HlTTQmJXatoR2XjPy8iRCo4Ln1aQm+MuWqVl2TZ8hkX7KmwEe9YiYWPicKCZ
8m3pzyBjCl3trCytjV2YbMfYtq7FrkwpI7rSXdm6USUOY142uCKZMw1m8ldB
oAUrEm8VhbGOLSvWVLdligIwx/VeNA+qAYAm06BdXJs1RiJZRSVk+EAkEpuY
mOlKCGUGOxd5KLcTbEXdgK0rZjJFV0W4MvLXpJKVSJ00eS4gwD3o5zIfgTeh
xbyo0fZiIm26SEL2M2M+i65wbKRjqvLfAQaOYdZyTTJPXYgugBmpxGKjSqux
xLXsWJPCKQR9xTSTRvG9aB5TU5t1PM+2nHgr6HCUwkr5EdTZCHodOzNgTUjC
tivtNbYmk1v32P0KOQ6X+juQSJOvToRL32Q7ywBOrKIzW65lqJC2PYz5+Ybk
EQNVE9sMzjfSK1N4gTUuyNKZz+epoN0P+gE1CitaRdul7gLjRnpVd/yStSSR
Ow1b004h6FY0LTZUd5a+wiaKQGZ72bIywVhOBDu5cr0ccKV7n+0FQRDizJiP
m7YXgShYYblvNfYdrTLgy0/H12C+IXnA9sJ2V6I5A5kKtPwqG34gn65b1WcK
umhz1Xxh94ljOZhtabZ5MLcuN23MqzWpIh9hjHSvwjtMXGEbsTv5DpFayE32
96aR+ylT62aO5cZZnidqVNgo0Ubb6YmqvZkxlRdRiaFEwT6K2UhyrYyDCMdI
TwWepkojiXIWqY5frj1+nqCPiYIdRHEcI1c3nNLQhzlL5LuU9mJs0hAU8w1+
hqaKURgiXJEcjv3Rk6749CbS1Ml19k7sQIApL71VUcn5att1gd0Xwfsi9hQD
fx/DvEUyp0UqqYqSoi5lhN16ylSO1YERA4OTg1bFR1BoiPReJbujxqsUxxjH
IJFrq2StDEGH6cJCFy8DtMPNRnBxrVokXDaOYYN662C9b9Fme4HrCUxhTjxf
2ARfVulXpfKIrRIVl7DYPed8qR4w1cC94xjm+yTD/Osk2o8+XwmBBGygk+ie
zuFmWcGrMK0YpR2HYV8Oyw4qVmXtoNqyE1V5qPr6Uk01HVlz6Mh5U0EDjUh/
qyb6KvBQxdqmzlTxyoXJmxGbbg1BSoahganBCtQl4KUt70pdDXFZ07omhDT9
X/KJFxdt3zckdRSpo2ldg+10tYY6c5XGN7ayfVt2WLJu6Ns8gs2lDT+I2Ugy
y5C8gDddW6XQkqJqSkM1vE2JtEzvvHatK4llM+AUtmOvxvuDaovAxt2E6sVu
1ESF/dmVr+8mN2pCnqPLtdf28dQBDmKTPOTo8sDN9dh/Y0vxC1NIP1bi5Z7u
oql4HLLVtbkNX9SuG1ve1cibr/R2XExTzRHMRpJZHs0wwnRZej29q1tJtFPN
oRRclHfkX6kJPg7DyO+oSZ0rpcOLqiXAem182FaM8kLGryr0K9a9EaOtJuBl
F3gzZsGHG3cMis5kq0u9Mx+fa+mg+shB685c9yWrnbYyyETdPlY1h5M08n1k
/Me3GLum27+mfOlqp60McREFAUqat9WmU0455T8o/wDjJffr
            "], {{0, 19}, {
            167, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{167, 19},
          PlotRange->{{0, 167}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{171, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1e589396-ad86-4b2c-9315-ad98baf80463"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWCGvrUYQJq2pbNJf0D+ArkVWkbymDvNeenmpuSX3NWmw65C4dShSgUKh
MKg1mK1Yg8BgEDTBrFhxu7PLAc49C4d7+8RrwyT35ByYmf32m9mZ2fv9h9/e
+V9ZlvXpG/nx7v0fztPT+/Cnb+WPnx8//frx8eGXHx9/f/j48PTDh6/lw+/k
35/yD74/n3LKKaeccsop/x8Zisi37YBy/XNsKG1Hcc/qoBr4Z3XdDnxHo6Mk
z7KCsD2l57EuQUv6egO2ntVFluVlPexAHjtSyCVywvq1q1lYNx637deWynqT
Ld4TubVcEtC9GvMkVySLodH+LnjH1HccD5F+cjRSLCc6P8o78dxkoaUkInvE
HlTTQmJXatoR2XjPy8iRCo4Ln1aQm+MuWqVl2TZ8hkX7KmwEe9YiYWPicKCZ
8m3pzyBjCl3trCytjV2YbMfYtq7FrkwpI7rSXdm6USUOY142uCKZMw1m8ldB
oAUrEm8VhbGOLSvWVLdligIwx/VeNA+qAYAm06BdXJs1RiJZRSVk+EAkEpuY
mOlKCGUGOxd5KLcTbEXdgK0rZjJFV0W4MvLXpJKVSJ00eS4gwD3o5zIfgTeh
xbyo0fZiIm26SEL2M2M+i65wbKRjqvLfAQaOYdZyTTJPXYgugBmpxGKjSqux
xLXsWJPCKQR9xTSTRvG9aB5TU5t1PM+2nHgr6HCUwkr5EdTZCHodOzNgTUjC
tivtNbYmk1v32P0KOQ6X+juQSJOvToRL32Q7ywBOrKIzW65lqJC2PYz5+Ybk
EQNVE9sMzjfSK1N4gTUuyNKZz+epoN0P+gE1CitaRdul7gLjRnpVd/yStSSR
Ow1b004h6FY0LTZUd5a+wiaKQGZ72bIywVhOBDu5cr0ccKV7n+0FQRDizJiP
m7YXgShYYblvNfYdrTLgy0/H12C+IXnA9sJ2V6I5A5kKtPwqG34gn65b1WcK
umhz1Xxh94ljOZhtabZ5MLcuN23MqzWpIh9hjHSvwjtMXGEbsTv5DpFayE32
96aR+ylT62aO5cZZnidqVNgo0Ubb6YmqvZkxlRdRiaFEwT6K2UhyrYyDCMdI
TwWepkojiXIWqY5frj1+nqCPiYIdRHEcI1c3nNLQhzlL5LuU9mJs0hAU8w1+
hqaKURgiXJEcjv3Rk6749CbS1Ml19k7sQIApL71VUcn5att1gd0Xwfsi9hQD
fx/DvEUyp0UqqYqSoi5lhN16ylSO1YERA4OTg1bFR1BoiPReJbujxqsUxxjH
IJFrq2StDEGH6cJCFy8DtMPNRnBxrVokXDaOYYN662C9b9Fme4HrCUxhTjxf
2ARfVulXpfKIrRIVl7DYPed8qR4w1cC94xjm+yTD/Osk2o8+XwmBBGygk+ie
zuFmWcGrMK0YpR2HYV8Oyw4qVmXtoNqyE1V5qPr6Uk01HVlz6Mh5U0EDjUh/
qyb6KvBQxdqmzlTxyoXJmxGbbg1BSoahganBCtQl4KUt70pdDXFZ07omhDT9
X/KJFxdt3zckdRSpo2ldg+10tYY6c5XGN7ayfVt2WLJu6Ns8gs2lDT+I2Ugy
y5C8gDddW6XQkqJqSkM1vE2JtEzvvHatK4llM+AUtmOvxvuDaovAxt2E6sVu
1ESF/dmVr+8mN2pCnqPLtdf28dQBDmKTPOTo8sDN9dh/Y0vxC1NIP1bi5Z7u
oql4HLLVtbkNX9SuG1ve1cibr/R2XExTzRHMRpJZHs0wwnRZej29q1tJtFPN
oRRclHfkX6kJPg7DyO+oSZ0rpcOLqiXAem182FaM8kLGryr0K9a9EaOtJuBl
F3gzZsGHG3cMis5kq0u9Mx+fa+mg+shB685c9yWrnbYyyETdPlY1h5M08n1k
/Me3GLum27+mfOlqp60McREFAUqat9WmU0455T8o/wDjJffr
              "], {{0, 19}, {
              167, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {167, 19}, 
            PlotRange -> {{0, 167}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9936267a-542f-4068-ae78-79aa1c62ac28"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4123f097-3b30-4143-b1bf-f41b10bb3129"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9bfefb28-0a74-4187-9017-dad522c26f5b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7ccb43d9-03fc-4836-96ea-b622bb6cf71e"],

Cell["\<\
Find the positions of the word \[OpenCurlyDoubleQuote]software\
\[CloseCurlyDoubleQuote] in the Wikipedia entry for \
\[OpenCurlyDoubleQuote]computers\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"1ca80d7d-da27-40bc-8fa1-09adfe55e339"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0cc86f02-b20e-4d99-9e5f-68430fc5c82e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmzGvrbgRgEnSpIyUX5A/QJ2WMhXSRulodrWPVZoX9DZSQktHSUdHRUVF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            "], {{0, 19}, {
            376, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{376, 19},
          PlotRange->{{0, 376}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{380, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1093c129-b9b0-44fe-85a4-44224f31ca8c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmzGvrbgRgEnSpIyUX5A/QJ2WMhXSRulodrWPVZoX9DZSQktHSUdHRUVF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              "], {{0, 19}, {
              376, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {376, 19}, 
            PlotRange -> {{0, 376}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"52b9bf3e-06bf-4706-aee4-f6017c26edf6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d5d71b1c-6e46-4850-a7dd-918943cb02bd"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"13adb3c6-be19-4ff3-a7d6-81a3ec7c0c82"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"786d0da1-8a96-4aa5-be20-f8be7f76d156"],

Cell[TextData[{
 "Make a histogram of where the letter \[OpenCurlyDoubleQuote]e\
\[CloseCurlyDoubleQuote] occurs in the words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"31b01569-29eb-4657-bad3-2b41fea78303"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"27e63a36-8db4-4ea3-b950-2d4e0915a2f1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"78c61967-de6f-4516-b73c-bedc7c32b76f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3TGP68p5xvHjpHGZr5BvkZQp09pw6cJG7jhpJsB1MIELulK3lSo1U7Fh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            "], {{0, 220}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 220},
          PlotRange->{{0, 360}, {0, 220}}]], "ExerciseOutput",
         ImageSize->{364, 220},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "457682cf-5568-4fcf-ba8b-392d7f1a91e6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3TGP68p5xvHjpHGZr5BvkZQp09pw6cJG7jhpJsB1MIELulK3lSo1U7Fh
pYaFmm22YCPAMsCGQARDhQoaWkABCLBgQYCeoSgdXe16pVlRopb8/7D3Yqnz
HF7p8t1nh+Iu+M+//e9fiH/49u3b739u/vWL3/zvv/3442/+8Mt/Mhu/kr//
r9/JH/7j3+X//PC7H378l9/+o3nwL+af//zZt2/286o9QogW9wZgCOgNAK7o
DQCu6A0ArugNAK7EXtdPBMCXQWMAg1HG4Xi3TvCjtdku1pFXb3o6KmygiHTz
wMs6fy/QoDeAgciXUyFGy6IqVuYTb1VmgRSTKK2KVJsmSbIs9oXQaVGlkRYy
yKrTwGFX9AYwEImvnmbLdJXEyXK9yco8lkIl9TJiGSjhx4kvpZ/Y7TJRQsav
p4HDrugNYCCWU2W+3sd+MDHnHt50m8ee1Nv6j7JYK216w5vMmwd86S1eTwOH
XV3fGz/++l9dP678LwL4hMSedey+9jdjoUwtKLGvhcXE1ELsq31vbPV7gcOu
xJHPPRnTA+Wf/3j5B70BdGL9PBJeaN/uzBbSnIbk6ViIcGXOQ4qZJ7zZahOZ
Ognt9nomxGhVngYOu2plvUFvAF9BNhvL3SJh8mJLIEvCZtEwCut1RRY+NYFp
sn0v0KA3gEEp8rwoj7ZL+4BToKI3ALijNwC4ojcAuLr+91PoDWBoWG8AcEVv
AHBFbwBwRW8AcEVvAHBFbwBwxXVYAK5YbwBwRW8AcEVvAHBFbwBwRW8AcMX1
FACuWG8AcEVvAHBFbwBwRW8AcEVvAHDF9RQArlhvAHBFbwCD8f12bMKb5vZ+
jpG329JRfWulItLNAy9re0PIN4EGvQEMRZEo4c3Xm+0mTdNtWWX2RtNRWhWp
FsJPsiz2hdBpUaWRFjLI3gQOe6I3gIEoVqEQo5d5FM3rCshjKVRSLyOWgRJ+
nPhS+ondLk3DyPj1NHDYFb0BDET6MhFCBbPnwN5depLmsSf17m7RWayVNr3h
TebNA770Fq+ngcOu6A1gKMpyf7/ozJx3hP/3JyX2tbCYmFqIfbXvja0WyvTG
SeCwJ3Hkc8+F3gC+BHuuMZnbz7YLaU5D8nRs2mNlzkOKmSe82WoTjYUK7fZ6
Zs5oVuVp4LAr1hvAUGTLyf5yih+t7QNJ2GyPwnpd8f2CyzTZvhdo0BvAoBR5
XpRH26V9wClQ9bE3zP5dP276fID+6WVvPNTzAfqH3qA3AFf9+722R3s+QP+w
3qA3AFf0Br0BuHr83vjE9RF6A7ipL9EbrvunN4CbojfoDcAVvUFvAK4e/zos
vQE8GtYb9Abgit6gNwBX9Aa9AbiiN+gNwBW9QW8ArrieQm8Arlhv0BuAK3qD
3gBc0Rv0BuCK3qA3AFf0xid+T//K/2PAV8f1FNYngCvWG/QG4IreoDcwLEXi
CS/O60/XkVefbng6qm+tVES6eeBlnb8XaNAb9AaGpJiNzBe9SmwrZIEUkyit
ilQL4SdZFvtC6LSo0kgLGWRvAoe90Bv0BoZjZVrDmzypkV1v5LE0BVIvI+wt
p/048aX0E7tdJkrI+PU0cNgPvUFvYCDqu8yPN1UZKi8ubG94Uu/uFp3FWmnT
G95k3jzgS2/xeho47IreoDcwEIG9rbz//Dz1hBwHz5v/j5XY18JiYmoh9tW+
N7ZaKNMbJ4HDrsSRzz0ZegP4EtbJYj6fL+YvT+Z05DnOynQsRLgq7JsenvBm
q000FiosmpXJaPUmcNgV6w16AwNTTNUort+1yJKwWTSMwnpdkYVPcvfANNm+
F2jQG/QGBq0s8vz4Emtlt8uPAhW9QW8A7ugNegNwRW/QG4Arfq+N358FXLHe
YH0CuKI36A3AFb1BbwCu6A16A3BFb9AbgCuup9AbgCvWG/QG4IreoDcAV/QG
vQG4ojfoDcAVvUFvAK7oDXoDcMV1WHoDcMV6g94AXNEb9Abgit6gNwBX9Aa9
AbiiN+gNwBXXU+gNwBXrDXoDcEVv0BsYjM3+dmyjKLW3UirWkVdvezqqb61U
RLp54GWdvxdo0Bv0BgYifR4J4W/NJy9jIad5lQVSTKK0KlJt/iDJstgXQptG
SSMtZJC9CRx2RW/QGxiIfLNapnYVkUYToaZ5HkuhknoZsQyU8OPEl9JP7HaZ
KCHj19PAYVf0Br2BISlmY2XPO8KkymNP6t3dorNYK216w5vMmwd86S1eTwOH
vdAbd8i7flx5RIC/Y3+76MwsJKSpBSX2tbCYmFqIfbXvja0W6m3gsCNx5HNP
hd5oPf+5AwF8bGnfrZjbz7KFOQGJ83QsRLgq7CLEE95stYnGQoV2ez0TYrQq
TwOHXbHeeMD8lUcEeF++nNhzFHtJRb/YEsiSsFk0jMJ6XZHtL7iIabJ9L9Cg
Nx4wf+URAT6Q53lRHm2XhXngOFCcC1T0xkPmrzwiwK3RGw+Yv/KIALdGbzxg
/sojAtwav9f2gPlPHwvgPlhvPGD+yiMC3FonveH68Whf1/QGBq6T3iBPb+BL
ozceMN/KkQVuh954wHwrRxa4nU6up5CnN/Clsd54wHwrRxa4HXrjAfOuH61M
AnA5eqMH+VYmAbgcvdGDfCuTAFyO3uhBvpVJAC5Hb/Qg38okAJfjOmwP8i3O
A3AJ1hs9yLcyCcDl6I0e5FuZBOBy9EYP8q1MAnA5eqMH+VYmAbgcvdGDfCuT
AFyO6yk9yLc4D8AlWG/0IN/KJACXozd6kG9lEtB/ZTrd347Nj9aVvZ9j5NWb
no7qWysVkW4eeFnn7wUa9EYP8lceQQxE+uwJGWzLKluG9e1fM3vD2CitilSb
JkmyLPaF0GlRpZE2yaw6DRx2RW/0IH/lEcRAbJdRtKzv8loshJDxayyFSupl
xDJQwo8TX0o/sdtlot4LHHZFb/Qgf+URxMBsTAdIPS/z2JN6d7foLNZKm97w
JvPmAV96i9fTwGEX4sjnnsQDfh0NLX/dFGFAinQ+EsLz5/bG0XmsxL4WFhNT
C7Gv9r2x1UKZ3jgJHPbDeqMH+SuPIAaiWD/bd0Tn9h3RsjTNkY6FCFfmPKSY
ecKbrTbRWKjQbq9n9Rsgp4HDruiNHuSvPIIYiOen49MLL86rLAmbrVFYryuy
cH/BZZrYB94EGvRGD/JXHkEMWlnk+fEl1spulx8FKnqjF/krjyDgit7oQb6V
SQAuR2/0IO/60crkYMj4vbYB5lucHwwT640B5luZHAwZvTHAfCuTgyGjNwaY
b2VyMGRve+MT77M92tcF+Y/znUwa+uTd3ni0OSffbr6TSUOfvL2e8oBzTr7d
fIfzhn5gvTHAfCeThj6hNwaY72TS0Cf0xgDznUwa+oTeGGC+k0lDn9AbA8x3
MmnoE3pjgPlOJg19wnXYAeY7nDf0A+uNAeY7mTT0Cb0xwHwnk4Y+oTcGmO9k
0tAn9MYA851MGvqE3hhgvpNJQ59wPWWA+Q7nDf3AemOA+U4mDX1Cbwww7/rR
yWTiRvJlKGSQ1Z8X68jb3bxNR/WtlYpINw+8rPP3Ag16g/zZ/H3mGXeQLgLb
AmpqS6HKAikmUVoVqRbCT7Is9oXQaVGlka675TRw2A+9Qf5s/p6DjRsqkic1
DoOR6QTbG3kshUrqZcQyUMKPE19KP7HbZaKEjF9PA4c90Rvkz+bvNNW4i3Jl
lhxNb3hS7+4WncVaadMb3mTePOBLb/F6Gjjs5PgG1btHHnBuyXebv+tY48by
5ffeUGJfC4uJqYXYV/ve2GqhTG+cBA47Yb1B/mz+HtOMe8mTfW9U6ViIcGXO
Q4qZJ7zZahONhQrt9nomxGhVngYOO6E3yJ/N33OqcWvFctq8v2FWEUnYnGyM
wnpdkYVPcvfANNm+F2jQG+TP5u8zz+hGWeT58SXWym6XHwUqeoP8BfmbjCu+
MnqD/Nl8J5OJR0ZvkD+b72Qy8cj4vTbyZ/MdziceE+sN8mfznUwmHhm9Qf5s
vpPJxCOjN8ifzXcymXhk9Ab5s/lOJhOPjN4gfzbfyWTikXE9hfzZvOtHh/OM
+2C9Qb71fCeTjHuiN8i3nu9kknFP9Ab51vOdTDLuid4g33q+k0nGPdEb5FvP
dzLJuCeup5BvPd/hPOM+WG+Qbz3fySTjnugN8q3nO5lk3BO9Qb71vOtHJ5OP
a9Ab5DvPdzL5uAa9Qb7zfCeTj2vQG+Q7z3cy+bgG12HJd57vcP7xOaw3yHee
72TycY3+9YZ5RQ/1fHi9Z/NOH28ntt86fb1FpL36dMR7WefHf0BvPNrz5/We
fb13/MLpXoevN4t9IXRaVGmkhQyyD5+V6xySJ3/nvNPwk/+0xJfST+xnZaKE
jI9WHPQG+S+Xdz2vuel50FfPfyDxvcl8dzfpzJfeYt8bAsAwfKI3Yl/te2Or
hVp8uN4AAGMTjYUKi6oq1jMhRqujm9TTGwD+jix8krvlyjTZHv8BvQHgA0We
F+Xpg/QGAADA5Zbh0/7N41GSn89/afkyPPwoTrGOmp/q01HR8fO6lePXW+XJ
/rRbeNOk2yd2A8Vi2kzyyI/sIBdrX9XbSq/7eoA7kwdS+Iv1drtJ12m/ayNd
BPUUTeuXmZkXPonSqki1EH6SnfvbX89PX6+pjUCooD7Sabrt26Eu05l5qfG2
rLJkJES4KmJfyYn5jlBEev+DWGhLuTTfc4NoHr3M0/zN+zh9UiRPahwGI/P9
137N5LEUKqm/DS0DJfy446fXupPXW1Wr0BOj6XwezZO0f0e63CbP0bJ+Xbn5
RqCTvwb220G97liaT4MefmPoTpm+mO9I42A2C8bmk5dN/wbqJ8qVHaFdb3hS
Nz/VF2ule9cbte+vtyojc4TlePY8G5uzlXHU0yNdLgLznVBvzHpSqfmuLPKF
kvRGu8rD1aLFRHqzVadP5uby5ffeUGLfG4tJX3vj++u1R3p/kp8v5E9/Hqkn
ytR2hgrq5VTmy31vZHMlfXqjRfVcmXI2tva3+OKe/9+15/jN11E6rs+CzTJ2
5om+FubR682nUkzm9lBvF/Ydnb4d6WJtDqjy5/bFlmVp1ldPwgvtYV3NRuYA
885oq7LniWreY9+9C91rxXJ6ON/PknB/HSncnvl7X9VPXu/y2R5pe0nFi9Z9
O9Tr2eGyoBUkmTnA+4ee+v79sBtl/t4Ptw1BaX+sr+sncU9lnvX77e8TdrSH
9HoBAAAAAADe8Te1uKH4
              "], {{0, 220}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 220}, 
            PlotRange -> {{0, 360}, {0, 220}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dc443957-5d12-4f15-ac76-7a5745fe146e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"02f80a5a-57ee-4f85-be3e-5d469bcd4b4a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9fc5840d-c57e-4fb0-b950-193b857a807e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f1379e10-f897-4a1e-92d2-c218fce45ad6"],

Cell[TextData[{
 "Make a list of the first 100 cubes, with every one whose position is a \
square replaced by ",
 StyleBox["Red",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"60c68667-9d80-4ac6-9b4f-7be38035cab2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0e0b40c5-c931-4076-bdc4-17501f9e9530"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnc+rK0mW32V746X/Bf8Bo7W3WnozF8Z4dzczTGvwpn3pMRhtBUMhmI1m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            "], {{0, 
            196}, {490, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{490, 196},
          PlotRange->{{0, 490}, {0, 196}}]], "ExerciseOutput",
         ImageSize->{494, 196},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "874345a9-7e23-4b85-9ad5-2ce4846d6ee7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnc+rK0mW32V746X/Bf8Bo7W3WnozF8Z4dzczTGvwpn3pMRhtBUMhmI1m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              "], {{
              0, 196}, {490, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {490, 196}, 
            PlotRange -> {{0, 490}, {0, 196}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fd9e6ca8-2924-4195-a785-e56e4e712c7c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"66901f92-ee75-474c-a84d-7d396513b6e5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9c61e598-c17e-4bb4-8f82-a9a4f48893a7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2ce25838-5982-420f-8291-94a32d1abd4a"],

Cell["\<\
Make a list of the first 100 primes, dropping ones whose first digit is less \
than 5.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"5939c60f-674e-4ea1-8185-0923c410e74a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8e3f609c-8ced-4d46-bf1d-06b6ea1915f8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWzGvrMYVxkmT0lJ+Qf4AtVvKVCvZSreNrTwsy9LL6tlSREtjUdLRUZGG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            "], {{0, 19}, {363, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{363, 19},
          PlotRange->{{0, 363}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{367, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "67b1724a-a7e0-461e-8bb8-af6f330f0ef4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWzGvrMYVxkmT0lJ+Qf4AtVvKVCvZSreNrTwsy9LL6tlSREtjUdLRUZGG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              "], {{0, 19}, {363, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {363, 19}, 
            PlotRange -> {{0, 363}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"04d67afd-ec46-4131-9d88-85154cfd4a4c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a8d4f20d-1af3-4067-823a-fe69eb390255"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e29c6aec-7935-4b21-b7c7-8ce683a2800d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c23edbfd-4364-4c3f-9b41-775136784db7"],

Cell[TextData[{
 "Make a grid starting with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Range",
    FontFamily->"Source Sans Pro"], "[", "10", "]"}]], "InlineCode",
  ExpressionUUID->"f0cede85-7dca-4a31-ad7b-9ed4fae8b37d"],
 ", then at each of 9 steps randomly removing another element."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"2d24d86c-bb84-494f-8cea-fa6b9016c482"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"794fdf10-423c-4a4e-8079-5ce19dd2d6c9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt2i+P49oZgPGoJRf2K/QLBJcGFkW6VVnIvbqbq5LtaG+lKtQs0MwsyCjI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            "], {{0, 
            187}, {202, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{202, 187},
          PlotRange->{{0, 202}, {0, 187}}]], "ExerciseOutput",
         ImageSize->{206, 187},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4fb5b2d5-7e2d-412f-bf9a-89f2092b7419"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt2i+P49oZgPGoJRf2K/QLBJcGFkW6VVnIvbqbq5LtaG+lKtQs0MwsyCjI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              "], {{
              0, 187}, {202, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {202, 187}, 
            PlotRange -> {{0, 202}, {0, 187}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b5bc1a48-4364-450e-bb81-59a4ee72fbbd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"965f3792-21cb-4b5c-a28b-d344f9c2bcf1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2dbeb059-868c-4d1b-bf68-8757439830f9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b336af3e-1e95-442c-bbd6-c2f94295dc25"],

Cell[TextData[{
 "Find the longest 10 words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"46c18a50-b0ad-4f11-b4d7-0d392ea5f423"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"90fcce75-12cc-460f-8b64-cbe6d1428fc1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0af13a43-4269-4556-87c0-efc757347685"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnTvPrEp2hrGdOPRf8B8gdkroCGksOyKZkQ+jSY7bM5asTlt20M46Q3bQ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            "], {{0, 86}, {411, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{411, 86},
          PlotRange->{{0, 411}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{415, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c7d2dbf5-55d6-4827-8c7f-08fe9846ee3b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnTvPrEp2hrGdOPRf8B8gdkroCGksOyKZkQ+jSY7bM5asTlt20M46Q3bQ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              "], {{0, 86}, {411, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {411, 86}, 
            PlotRange -> {{0, 411}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"49a63a7b-d616-4c97-8d3e-603d65c19fe3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"69c4d226-c4ca-4457-9d16-e6c3ced8340f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"be84af20-40f8-48fa-a316-224a729716c7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"532fa609-0e62-4f81-95ac-374b2944738f"],

Cell["Find the 5 longest integer names for integers up to 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"643cce5a-461f-4153-9c2f-0025aa9ef903"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"624fd435-0c2a-4530-9772-3519c5ac9bcd"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWzGvpDYQJkmTMlJ+Qf6A67QuUyElSkeTKEeU5oIukSJaOko6mhOVi4iK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            "], {{0, 19}, {425, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{425, 19},
          PlotRange->{{0, 425}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{429, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0c93a78b-3818-4856-b5e4-d5dd8a47c6b5"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWzGvpDYQJkmTMlJ+Qf6A67QuUyElSkeTKEeU5oIukSJaOko6mhOVi4iK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              "], {{0, 19}, {425, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {425, 19}, 
            PlotRange -> {{0, 425}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"430dd3c9-fb8a-41c6-b674-075c7eaacbbb"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ae61e26b-f801-47c7-bee1-4bd29a5e4765"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"33fa232c-0cd6-41cc-8c13-be7a78158b5d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"de9843d8-7f51-4f2a-8605-4db6634663c7"],

Cell["\<\
Find the 5 English names for integers up to 100 that have the largest number \
of \[OpenCurlyDoubleQuote]e\[CloseCurlyDoubleQuote]s in them.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "31.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"2955bb8e-f9a3-4d61-bcad-db4d0ff3f0f4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"31802f75-959e-475a-b385-816edf72eca6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWy3PpFYUpq2pbNJf0D+ArkVWkWxT04zZTZdNzZbsNtlgcUgcDoVCoVAY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            "], {{0, 19}, {346, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{346, 19},
          PlotRange->{{0, 346}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{350, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a341e7fe-2fe1-4c39-93bb-675e6705d0e2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWy3PpFYUpq2pbNJf0D+ArkVWkWxT04zZTZdNzZbsNtlgcUgcDoVCoVAY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              "], {{0, 19}, {346, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {346, 19}, 
            PlotRange -> {{0, 346}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b7754530-a795-4921-a0d1-a527d400257d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["31.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"50c2d7ec-47b2-40f9-9d53-a0c098be1b6a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b071724d-e88e-468d-ad25-5f1cd6fea611"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"db10e796-49a3-4263-af58-03e76505a02d"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Parts of Lists: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[" 31  Parts of Lists", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
31-parts-of-lists.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "31.1", "31.10", "31.11", "31.12", "31.13", "31.2", "31.3", "31.4", 
         "31.5", "31.6", "31.7", "31.8", "31.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "31.1", "31.10", "31.11", "31.12", "31.13", "31.2", "31.3", "31.4", 
      "31.5", "31.6", "31.7", "31.8", "31.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[7204, 189, 813, 26, 
  70, "Input", "ExpressionUUID" -> "78e003b8-c6e7-42b5-866f-4bf933befc9f",
   CellTags->"FirstInputCell"],
  Cell[16167, 419, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bad766be-3371-45b7-8968-4c7f0ce7dc57",
   CellTags->"FirstInputCell"],
  Cell[25287, 654, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c1f95576-8b7b-4c9d-a212-25cbf219c7ff",
   CellTags->"FirstInputCell"],
  Cell[107489, 2087, 813, 26, 
  70, "Input", "ExpressionUUID" -> "00d62392-1596-4b05-aee1-a472340943fc",
   CellTags->"FirstInputCell"],
  Cell[117092, 2330, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9bfefb28-0a74-4187-9017-dad522c26f5b",
   CellTags->"FirstInputCell"],
  Cell[128788, 2608, 813, 26, 
  70, "Input", "ExpressionUUID" -> "13adb3c6-be19-4ff3-a7d6-81a3ec7c0c82",
   CellTags->"FirstInputCell"],
  Cell[145306, 2968, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9fc5840d-c57e-4fb0-b950-193b857a807e",
   CellTags->"FirstInputCell"],
  Cell[194148, 3856, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9c61e598-c17e-4bb4-8f82-a9a4f48893a7",
   CellTags->"FirstInputCell"],
  Cell[205488, 4128, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e29c6aec-7935-4b21-b7c7-8ce683a2800d",
   CellTags->"FirstInputCell"],
  Cell[217308, 4410, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2dbeb059-868c-4d1b-bf68-8757439830f9",
   CellTags->"FirstInputCell"],
  Cell[243134, 4923, 813, 26, 
  70, "Input", "ExpressionUUID" -> "be84af20-40f8-48fa-a316-224a729716c7",
   CellTags->"FirstInputCell"],
  Cell[254561, 5194, 813, 26, 
  70, "Input", "ExpressionUUID" -> "33fa232c-0cd6-41cc-8c13-be7a78158b5d",
   CellTags->"FirstInputCell"],
  Cell[265242, 5454, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b071724d-e88e-468d-ad25-5f1cd6fea611",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 324134, 6673}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[635, 21, 418, 9, 70, "Exercise", "ExpressionUUID" -> \
"7a9c6fed-b6cd-4165-b465-f582ef5ef383",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1078, 34, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"7293f8cd-24cd-4470-92fd-5204944d553a"],
Cell[1717, 55, 4880, 109, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3ce822a4-1eda-4940-9d50-1133591ef640"]
}, Closed]],
Cell[CellGroupData[{
Cell[6634, 169, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"39a614cb-18db-44b2-83cc-720eb1b463e6"],
Cell[7204, 189, 813, 26, 70, "Input", "ExpressionUUID" -> \
"78e003b8-c6e7-42b5-866f-4bf933befc9f",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8054, 220, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"79045a4d-baf5-4c45-8dd2-388107b6d4de"],
Cell[8341, 231, 432, 9, 70, "Exercise", "ExpressionUUID" -> \
"ea383825-5cc5-45c8-8410-968d2b49dd9e",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[8798, 244, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"91e6c9fb-3e8c-489e-b037-c24438794022"],
Cell[9437, 265, 6123, 129, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7f8120f6-4bbb-49e7-9953-5bdaa7e2e8ba"]
}, Closed]],
Cell[CellGroupData[{
Cell[15597, 399, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b886e282-f62c-4ea5-bc39-337fa44cc6b5"],
Cell[16167, 419, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bad766be-3371-45b7-8968-4c7f0ce7dc57",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17029, 451, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"cf39158f-3244-4ed8-84fb-88729253ae48"],
Cell[17316, 462, 463, 11, 70, "Exercise", "ExpressionUUID" -> \
"ca52b166-747e-4c60-ad37-9164359d3592",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[17804, 477, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c60191fa-964b-4699-a33f-640fbe5e0278"],
Cell[18443, 498, 6237, 131, 70, "ExerciseOutput", "ExpressionUUID" -> \
"21a305c8-6e16-4448-874b-5baee41347f4"]
}, Closed]],
Cell[CellGroupData[{
Cell[24717, 634, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3f9feb76-9aae-473a-bfac-8597eeeadc4a"],
Cell[25287, 654, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c1f95576-8b7b-4c9d-a212-25cbf219c7ff",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26149, 686, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d44074a5-5a27-41c5-92eb-6749b90fe2c3"],
Cell[26436, 697, 468, 11, 70, "Exercise", "ExpressionUUID" -> \
"c7214655-d5de-48b4-9634-5047e35f8f22",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[26929, 712, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b72bbee3-c811-4a34-a44e-27037691a9ec"],
Cell[27568, 733, 79314, 1329, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2350a1b7-f1d6-4590-be2d-9945b0790305"]
}, Closed]],
Cell[CellGroupData[{
Cell[106919, 2067, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"c33b3337-8f9c-4511-80f7-8be45123a94a"],
Cell[107489, 2087, 813, 26, 70, "Input", "ExpressionUUID" -> \
"00d62392-1596-4b05-aee1-a472340943fc",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108351, 2119, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2c281dc9-eb7d-42de-8b10-49eb25cbc65f"],
Cell[108638, 2130, 495, 12, 70, "Exercise", "ExpressionUUID" -> \
"d932dadc-18c5-464a-aa26-fcdbdca30367",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[109158, 2146, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"eeb608c8-0b2b-4445-9918-1385aee8e740"],
Cell[109797, 2167, 6688, 138, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9936267a-542f-4068-ae78-79aa1c62ac28"]
}, Closed]],
Cell[CellGroupData[{
Cell[116522, 2310, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4123f097-3b30-4143-b1bf-f41b10bb3129"],
Cell[117092, 2330, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9bfefb28-0a74-4187-9017-dad522c26f5b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[117954, 2362, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7ccb43d9-03fc-4836-96ea-b622bb6cf71e"],
Cell[118241, 2373, 616, 14, 70, "Exercise", "ExpressionUUID" -> \
"1ca80d7d-da27-40bc-8fa1-09adfe55e339",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[118882, 2391, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0cc86f02-b20e-4d99-9e5f-68430fc5c82e"],
Cell[119541, 2413, 8640, 170, 70, "ExerciseOutput", "ExpressionUUID" -> \
"52b9bf3e-06bf-4706-aee4-f6017c26edf6"]
}, Closed]],
Cell[CellGroupData[{
Cell[128218, 2588, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d5d71b1c-6e46-4850-a7dd-918943cb02bd"],
Cell[128788, 2608, 813, 26, 70, "Input", "ExpressionUUID" -> \
"13adb3c6-be19-4ff3-a7d6-81a3ec7c0c82",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129650, 2640, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"786d0da1-8a96-4aa5-be20-f8be7f76d156"],
Cell[129937, 2651, 742, 19, 70, "Exercise", "ExpressionUUID" -> \
"27e63a36-8db4-4ea3-b950-2d4e0915a2f1",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[130704, 2674, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"78c61967-de6f-4516-b73c-bedc7c32b76f"],
Cell[131363, 2696, 13336, 247, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dc443957-5d12-4f15-ac76-7a5745fe146e"]
}, Closed]],
Cell[CellGroupData[{
Cell[144736, 2948, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"02f80a5a-57ee-4f85-be3e-5d469bcd4b4a"],
Cell[145306, 2968, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9fc5840d-c57e-4fb0-b950-193b857a807e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146168, 3000, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f1379e10-f897-4a1e-92d2-c218fce45ad6"],
Cell[146455, 3011, 549, 15, 70, "Exercise", "ExpressionUUID" -> \
"60c68667-9d80-4ac6-9b4f-7be38035cab2",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[147029, 3030, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0e0b40c5-c931-4076-bdc4-17501f9e9530"],
Cell[147668, 3051, 45873, 780, 70, "ExerciseOutput", "ExpressionUUID" -> \
"fd9e6ca8-2924-4195-a785-e56e4e712c7c"]
}, Closed]],
Cell[CellGroupData[{
Cell[193578, 3836, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"66901f92-ee75-474c-a84d-7d396513b6e5"],
Cell[194148, 3856, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9c61e598-c17e-4bb4-8f82-a9a4f48893a7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[195010, 3888, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2ce25838-5982-420f-8291-94a32d1abd4a"],
Cell[195297, 3899, 479, 12, 70, "Exercise", "ExpressionUUID" -> \
"5939c60f-674e-4ea1-8185-0923c410e74a",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[195801, 3915, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8e3f609c-8ced-4d46-bf1d-06b6ea1915f8"],
Cell[196440, 3936, 8441, 167, 70, "ExerciseOutput", "ExpressionUUID" -> \
"04d67afd-ec46-4131-9d88-85154cfd4a4c"]
}, Closed]],
Cell[CellGroupData[{
Cell[204918, 4108, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a8d4f20d-1af3-4067-823a-fe69eb390255"],
Cell[205488, 4128, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e29c6aec-7935-4b21-b7c7-8ce683a2800d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[206350, 4160, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c23edbfd-4364-4c3f-9b41-775136784db7"],
Cell[206637, 4171, 716, 18, 70, "Exercise", "ExpressionUUID" -> \
"2d24d86c-bb84-494f-8cea-fa6b9016c482",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[207378, 4193, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"794fdf10-423c-4a4e-8079-5ce19dd2d6c9"],
Cell[208037, 4215, 8663, 170, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b5bc1a48-4364-450e-bb81-59a4ee72fbbd"]
}, Closed]],
Cell[CellGroupData[{
Cell[216737, 4390, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"965f3792-21cb-4b5c-a28b-d344f9c2bcf1"],
Cell[217308, 4410, 813, 26, 70, "Input", "ExpressionUUID" -> \
"2dbeb059-868c-4d1b-bf68-8757439830f9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[218170, 4442, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b336af3e-1e95-442c-bbd6-c2f94295dc25"],
Cell[218457, 4453, 662, 18, 70, "Exercise", "ExpressionUUID" -> \
"90fcce75-12cc-460f-8b64-cbe6d1428fc1",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[219144, 4475, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0af13a43-4269-4556-87c0-efc757347685"],
Cell[219803, 4497, 22723, 401, 70, "ExerciseOutput", "ExpressionUUID" -> \
"49a63a7b-d616-4c97-8d3e-603d65c19fe3"]
}, Closed]],
Cell[CellGroupData[{
Cell[242563, 4903, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"69c4d226-c4ca-4457-9d16-e6c3ced8340f"],
Cell[243134, 4923, 813, 26, 70, "Input", "ExpressionUUID" -> \
"be84af20-40f8-48fa-a316-224a729716c7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[243996, 4955, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"532fa609-0e62-4f81-95ac-374b2944738f"],
Cell[244283, 4966, 443, 9, 70, "Exercise", "ExpressionUUID" -> \
"643cce5a-461f-4153-9c2f-0025aa9ef903",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[244751, 4979, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"624fd435-0c2a-4530-9772-3519c5ac9bcd"],
Cell[245390, 5000, 8563, 169, 70, "ExerciseOutput", "ExpressionUUID" -> \
"430dd3c9-fb8a-41c6-b674-075c7eaacbbb"]
}, Closed]],
Cell[CellGroupData[{
Cell[253990, 5174, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"ae61e26b-f801-47c7-bee1-4bd29a5e4765"],
Cell[254561, 5194, 813, 26, 70, "Input", "ExpressionUUID" -> \
"33fa232c-0cd6-41cc-8c13-be7a78158b5d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[255423, 5226, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"de9843d8-7f51-4f2a-8605-4db6634663c7"],
Cell[255710, 5237, 535, 12, 70, "Exercise", "ExpressionUUID" -> \
"2955bb8e-f9a3-4d61-bcad-db4d0ff3f0f4",
 CounterAssignments->{{"SectionNumber", 31}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[256270, 5253, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"31802f75-959e-475a-b385-816edf72eca6"],
Cell[256909, 5274, 7725, 155, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b7754530-a795-4921-a0d1-a527d400257d"]
}, Closed]],
Cell[CellGroupData[{
Cell[264671, 5434, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"50c2d7ec-47b2-40f9-9d53-a0c098be1b6a"],
Cell[265242, 5454, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b071724d-e88e-468d-ad25-5f1cd6fea611",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[266082, 5484, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"db10e796-49a3-4263-af58-03e76505a02d"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature LRW@qUv7s9e9PiYYEcLcO4S7 *)
