(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    530812,      13309]
NotebookOptionsPosition[    405682,      10813]
NotebookOutlinePosition[    504336,      12842]
CellTagsIndexPosition[    503216,      12797]
WindowTitle->Rearranging Lists: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Rearranging Lists", "SectionInline",ExpressionUUID->
   "d88ddfc8-2eae-48c1-90a7-7912206a3536"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 29}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:177",ExpressionUUID->"410569be-7f26-45af-a43e-7510b233b330"],

Cell["\<\
It\[CloseCurlyQuote]s common for lists that come out of one computation to \
have to be rearranged before going into another computation. For example, one \
might have a list of pairs, and need to convert it into a pair of lists, or \
vice versa.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"61b2e948-dede-4c20-bb86-78b186c4c649"],

Cell["Transpose a list of pairs so it becomes a pair of lists:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"fc5f5e0c-d60a-4f23-a4da-9ab43f315817"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"bf8bb5a1-8390-428a-9032-c3070ec6e260"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"af58798f-aeae-4cb9-8274-c655f710fd76"]
}, Open  ]],

Cell["Transpose the pair of lists back to a list of pairs:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ac5e3df8-038d-480f-8ccb-7473e964ad7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"cf7e5482-6cc1-4659-89fe-34faba69bcf8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"2e2fe29d-8c3c-4bd1-94e9-c07b4e233965"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Thread",
  BaseStyle->"Link"],
 " is a closely related operation, often useful for generating input to ",
 ButtonBox["Graph",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"8962f7e9-0b5b-4246-a788-482a996a0407"],

Cell[TextData[{
 "\[OpenCurlyDoubleQuote]Thread\[CloseCurlyDoubleQuote]",
 " ",
 Cell[BoxData[
  ButtonBox["\[Rule]",
   BaseStyle->"Link",
   ButtonData->"Rule"]], "InlineCode",ExpressionUUID->
  "c8f131e5-c228-4aed-8a33-a68816b78172"],
 " across the elements of two lists:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"338e8ab4-2322-4d18-8b0d-246af194d18f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}], "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"4db3ffd0-27a1-48bc-bb9c-57240550516b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}], ",", 
   RowBox[{"7", "\[Rule]", "8"}], ",", 
   RowBox[{"9", "\[Rule]", "10"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"d0274e1b-ca06-4372-a5a3-65c8df7630aa"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Partition",
  BaseStyle->"Link"],
 " takes a list, and partitions it into ",
 "blocks",
 " of a specified size."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"7d681ab3-a2ec-4534-92ab-e6f6d84c5654"],

Cell["Partition a 12-element list into blocks of size 3:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3e54f540-e83e-48de-8ff7-70a7151b072c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"Range", "[", "12", "]"}], ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"4d78325e-d871-41b3-81fb-77d7ca9058ab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "12"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"741c73dc-27bc-4a69-b217-79c8995d5c7e"]
}, Open  ]],

Cell["Partition a list of characters to display them in a grid:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"546db506-8f7a-4b56-9a5e-7112c01460eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{
     "Characters", "[", 
      "\"\<An array of text made in the Wolfram Language\>\"", "]"}], ",", 
     "9"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"f87f3426-943d-4510-9600-5c8e554b44d5"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"A\"\>", "\<\"n\"\>", "\<\" \"\>", "\<\"a\"\>", "\<\"r\"\>", \
"\<\"r\"\>", "\<\"a\"\>", "\<\"y\"\>", "\<\" \"\>"},
    {"\<\"o\"\>", "\<\"f\"\>", "\<\" \"\>", "\<\"t\"\>", "\<\"e\"\>", \
"\<\"x\"\>", "\<\"t\"\>", "\<\" \"\>", "\<\"m\"\>"},
    {"\<\"a\"\>", "\<\"d\"\>", "\<\"e\"\>", "\<\" \"\>", "\<\"i\"\>", \
"\<\"n\"\>", "\<\" \"\>", "\<\"t\"\>", "\<\"h\"\>"},
    {"\<\"e\"\>", "\<\" \"\>", "\<\"W\"\>", "\<\"o\"\>", "\<\"l\"\>", \
"\<\"f\"\>", "\<\"r\"\>", "\<\"a\"\>", "\<\"m\"\>"},
    {"\<\" \"\>", "\<\"L\"\>", "\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", \
"\<\"u\"\>", "\<\"a\"\>", "\<\"g\"\>", "\<\"e\"\>"}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"e40b500a-64cc-49f0-91fc-411f470e48b3"]
}, Open  ]],

Cell[TextData[{
 "If you don\[CloseCurlyQuote]t tell it otherwise, ",
 ButtonBox["Partition",
  BaseStyle->"Link"],
 " breaks a list up into non-overlapping blocks. But you can also tell it to \
break the list into blocks that have ",
 "some specified offset",
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"29c7bf03-eccf-4969-a37e-39b55454a774"],

Cell["Partition a list into blocks of size 3 with offset 1:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"34537605-c2b5-48da-a310-292c3e2f4884"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", "3", ",", "1"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"24c1870f-6108-49bc-aa33-3c8f3c6a8877"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[6]=",ExpressionUUID->"deeefbef-b444-4d73-b9ca-7f266bc6cd62"]
}, Open  ]],

Cell["\<\
Partition a list of characters into blocks with an offset of 1:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:178",ExpressionUUID->"07a6ea35-a0e3-4ec4-a1ce-5ac379ddf727"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Characters", "[", "\"\<Wolfram Language\>\"", "]"}], ",", "12", 
     ",", "1"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"1eab4ac3-5a03-4d5f-9a98-de7920259e04"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"W\"\>", "\<\"o\"\>", "\<\"l\"\>", "\<\"f\"\>", "\<\"r\"\>", \
"\<\"a\"\>", "\<\"m\"\>", "\<\" \"\>", "\<\"L\"\>", "\<\"a\"\>", "\<\"n\"\>", \
"\<\"g\"\>"},
    {"\<\"o\"\>", "\<\"l\"\>", "\<\"f\"\>", "\<\"r\"\>", "\<\"a\"\>", \
"\<\"m\"\>", "\<\" \"\>", "\<\"L\"\>", "\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", \
"\<\"u\"\>"},
    {"\<\"l\"\>", "\<\"f\"\>", "\<\"r\"\>", "\<\"a\"\>", "\<\"m\"\>", "\<\" \
\"\>", "\<\"L\"\>", "\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\"u\"\>", \
"\<\"a\"\>"},
    {"\<\"f\"\>", "\<\"r\"\>", "\<\"a\"\>", "\<\"m\"\>", "\<\" \"\>", \
"\<\"L\"\>", "\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\"u\"\>", "\<\"a\"\>", \
"\<\"g\"\>"},
    {"\<\"r\"\>", "\<\"a\"\>", "\<\"m\"\>", "\<\" \"\>", "\<\"L\"\>", \
"\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\"u\"\>", "\<\"a\"\>", "\<\"g\"\>", \
"\<\"e\"\>"}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"88e29c32-6eb1-4f18-8c10-9ebce66c915a"]
}, Open  ]],

Cell["Use an offset of 2 instead:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e244d449-0ea1-4edd-accd-ddfbe9f847c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Characters", "[", "\"\<Wolfram Language\>\"", "]"}], ",", "12", 
     ",", "2"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"19fff1eb-0296-4fa3-ad97-2375e2bf498b"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"W\"\>", "\<\"o\"\>", "\<\"l\"\>", "\<\"f\"\>", "\<\"r\"\>", \
"\<\"a\"\>", "\<\"m\"\>", "\<\" \"\>", "\<\"L\"\>", "\<\"a\"\>", "\<\"n\"\>", \
"\<\"g\"\>"},
    {"\<\"l\"\>", "\<\"f\"\>", "\<\"r\"\>", "\<\"a\"\>", "\<\"m\"\>", "\<\" \
\"\>", "\<\"L\"\>", "\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\"u\"\>", \
"\<\"a\"\>"},
    {"\<\"r\"\>", "\<\"a\"\>", "\<\"m\"\>", "\<\" \"\>", "\<\"L\"\>", \
"\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\"u\"\>", "\<\"a\"\>", "\<\"g\"\>", \
"\<\"e\"\>"}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"71718e85-10ba-47ea-b714-919f8979f49f"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Partition",
  BaseStyle->"Link"],
 " takes a list and breaks it into sublists. ",
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 " \[OpenCurlyDoubleQuote]flattens out\[CloseCurlyDoubleQuote] sublists."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"9f96a35b-4542-4681-ad9b-c1422f29e43a"],

Cell["Make a list of lists from digits of successive integers:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a8105255-07f5-4e0e-8753-625d643300e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"d5435fbe-840d-4df1-8cc1-821a04dfa0a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", "9", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"f7dab78e-0ecc-4494-a3f4-d1fb25dad2f3"]
}, Open  ]],

Cell["Make a flattened version:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38961a2d-ba54-464b-b387-0eac2318e77b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"IntegerDigits", "/@", 
   RowBox[{"Range", "[", "20", "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"9af9062b-8555-4b9b-9d2e-c70a19e9e3b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
   "1", ",", "3", ",", "1", ",", "4", ",", "1", ",", "5", ",", "1", ",", "6", 
   ",", "1", ",", "7", ",", "1", ",", "8", ",", "1", ",", "9", ",", "2", ",", 
   "0"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"196858d3-b606-458b-928f-7798a8731f23"]
}, Open  ]],

Cell["Make a plot from the sequence of digits:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fc27c2bd-f139-4700-bc8f-44cd81824726"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"IntegerDigits", "/@", 
    RowBox[{"Range", "[", "20", "]"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"a4e9f557-1033-49b6-951d-6aa054d56e99"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxdkEsKwlAQBAdXLrNw4UIwCSIiQdQk/jU5g0cQXHt1j6Bi9+LVwKMomgfT
Uzxe9+cgIqbf9+N/3l3K6FMOwQwcgWNwAuZgCc76dJ+599EskC/hFXzl/+Ia
+Ubuflvktdx9G+St3P13yPdy3+OA/Cj3fU7Iz3Lf64L8Ki/Fm+i+nT0+01kj
RA==
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->180,
  Method->{},
  PlotRange->{{0., 31.}, {0, 9.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"d87deb76-cac5-4537-891b-b2299b557808"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 " will normally flatten out all levels of lists. But quite often you only \
want to flatten, say, one level of lists. This makes a 4\[Times]4 table ",
 "in which each element is itself",
 " a list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"98c94d4b-c94d-4bbf-b14e-33c79303eb57"],

Cell["Make a list of lists of lists:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"328b558b-dccb-4678-8790-e85399ef2439"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"i", "^", "j"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "4"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"94944208-5bc2-4c66-afc6-ea6a9d1b96c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "8", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "9", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "6"}], "}"}]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[12]=",ExpressionUUID->"358d079c-7717-48c9-a1d5-b7d922893d5d"]
}, Open  ]],

Cell["Flatten everything out:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:179",ExpressionUUID->"45e67845-67dd-49f4-a507-ea4bbca9f141"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IntegerDigits", "[", 
     RowBox[{"i", "^", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"fa438f03-19e6-4253-a909-5cf0fd4e2727"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "4", ",", "8", ",", "1", 
   ",", "6", ",", "3", ",", "9", ",", "2", ",", "7", ",", "8", ",", "1", ",", 
   "4", ",", "1", ",", "6", ",", "6", ",", "4", ",", "2", ",", "5", ",", 
   "6"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"cb41575e-35cc-4223-9c0a-4f3f974eee0e"]
}, Open  ]],

Cell["Flatten out only one level of list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4029ff89-9725-43e0-bb3b-e7107ce1998b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"i", "^", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}], ",", "1"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"3da8ba7b-d8ff-4517-9974-4070ad6849f8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "9", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"37036f6e-c41c-43b7-983b-addb89a9471f"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["ArrayFlatten",
  BaseStyle->"Link"],
 " is a generalization of ",
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 ", which takes arrays of arrays, and flattens them into individual arrays",
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"3d9b368e-714a-4cbb-9baa-902c3ec9f155"],

Cell["\<\
This generates a deeply nested structure that\[CloseCurlyQuote]s hard to \
understand:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"03b9e75c-9ab6-4f43-835e-a158e3d46a2f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}]}], "}"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "1", "}"}], "}"}], ",", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"6060b3ea-fd74-4ace-bf93-d8c31855011a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "1", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", "1", "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", "1", "}"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}]}], "}"}]}], "}"}], ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"992c0d52-1a64-45a2-91ea-64266ad1643f"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["ArrayFlatten",
  BaseStyle->"Link"],
 " makes a structure that\[CloseCurlyQuote]s a little easier to understand:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"c8b1aba6-c7ea-47de-8020-e497d6193792"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArrayFlatten", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"#", ",", "#"}], "}"}]}], "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "1", "}"}], "}"}], ",", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"f7050adb-4072-42c8-9ba5-cc6d9018e97d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "1", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"baa3c445-533b-4491-a616-d5b71e93624c"]
}, Open  ]],

Cell[TextData[{
 "With ",
 ButtonBox["ArrayPlot",
  BaseStyle->"Link"],
 ", it\[CloseCurlyQuote]s considerably easier to see what\[CloseCurlyQuote]s \
going on:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a3c69c4b-08f4-4d18-8689-bee75291fcbc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "/@", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArrayFlatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"#", ",", "#"}], "}"}]}], "}"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", "1", "}"}], "}"}], ",", "4"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"5130d1e9-6e3e-4441-a8af-26815956398d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[{{0}}, {{0, 0}, {1, 1}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{89.81640625, Automatic},
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic}], 
   ",", 
   GraphicsBox[RasterBox[{{0, 0}, {0, 1}}, {{0, 0}, {2, 2}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{90.47265625, Automatic},
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic}], 
   ",", 
   GraphicsBox[
    RasterBox[{{0, 0, 0, 0}, {0, 1, 0, 1}, {0, 0, 1, 1}, {0, 1, 1, 1}}, {{0, 
     0}, {4, 4}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{90.2109375, Automatic},
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic}], 
   ",", 
   GraphicsBox[
    RasterBox[{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 
     1, 0, 0, 1, 1}, {0, 1, 1, 1, 0, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 1, 1}, {0, 
     1, 0, 1, 1, 1, 1, 1}, {0, 0, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 
     1}}, {{0, 0}, {8, 8}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{90.0859375, Automatic},
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic}], 
   ",", 
   GraphicsBox[
    RasterBox[{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 
     0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
      0, 0, 1, 1}, {0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1}, {0, 0, 0,
      0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1}, {0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 
     0, 1, 1, 1, 1, 1}, {0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 
     1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1,
      1, 1, 1, 1, 1, 1, 1}, {0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
     1}, {0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 0, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1}, {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1}}, {{0, 0}, {16, 16}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{90.43359375, Automatic},
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> Automatic}]}],
   "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"ea7cfc28-36bb-4b00-9765-80ca27e68690"]
}, Open  ]],

Cell[TextData[{
 "Generate a ",
 StyleBox["fractal Sierpinski pattern",
  FontSlant->"Italic"],
 " with 8 levels of nesting:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"a1d7916b-a50c-4cfc-9557-0f61c75431ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArrayFlatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"#", ",", "#"}], "}"}]}], "}"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", "1", "}"}], "}"}], ",", "8"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"ea79c986-5402-48cd-a906-940d262b704a"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzlmVFuGzEMRKXepFfqEXKB3v+v3daLZqfxTmhGIjl8hiAQBDOODIIY8Pvb
zx9v38Zv5uN0Zzb/jNn7zObnaIHO959XaHz/vfres/l9jsGu8ePTNh7/eqFl
POe712gYj/ev0TC+vEbD+Br2i2fzGJjd8vBplx/X0y4Pp13+0RMf9UaL/ONV
PuqNFvlxvdvl4W6XfzIX2+SfzMU2+SdzsU1+Pu+NFvmb3miRv32dBvn7tH7+
Pq2fJ5Dy+vXkI18/7o98PTny9ePqj/GWr3+80rNbvn7c3/L15Javhzn52bkp
Uw9z8rNzU6Ye5uRn56ZM/bz2ymfnpkw99IqldyTq4bUsvSNRP+5j+XoSy9cb
/bJcPXza1Y/raVcPp1290S/L1T9e7ZXekagf17tdPdzt6l+cmzL1L85NmfoX
56ZM/Xy9dyTqHb0jUe96PYF6X3n9el95/XonTvl4feenvP7wnfL6zlNef1z9
s/Uur/94xVfv8vrDd5fXd97l9WGOWuPy+jBHrXF5fZij1ri8/rz2kjUurw+9
ZI3L68NrWuPy+sMXl9d3xuX1iZ/+ar+dTh8+1nx5/XE91nx5fTjWfHl94qe/
2m+n03+86rPe+mq/nU5/XG9rvrw+3NZ8eX0yV1fN3TT6ZK6umrtp9MlcXTV3
0+jP+95aNXfT6JPeWtl7KfTJ667svRT65M+vff0E+s58eX3CYvl4ffKR1x/3
R16fHHl98Ner/XY6ffDXq/12Ov1xf8vrk1teH+bsrrmbRh/m7K65m0Yf5uyu
uZtGf157bdfcTaMPvbaz91Low2vv7L0U+uM+ltcnsbz+Zr+dTn+z306nv9lv
p9OH005/s99Op7/Zb6fT3+y30+nD3U4/aO6m0Q+au2n0g+ZuGv0Z13sp9AN7
L4V+6Osn0I+Vj9ePlY/XDyb43//Pf+/+RMP276tPNOi/d59ozh6MuqNh+/fV
dzRs/776jmYE39HgHN4dR8P276vjaNj+fXUcDc7h3XE02Iu742iwF3fH0bD9
++o4Gvw6u+NomB9fnY+G+fHV+WiYH1+dj2bA2Z2Phvnx1flomB9fnY+G+fHV
+WgG3Lvz0bC5vDofDZvLq/PRsLm8Oh8Nm8ur89Gw3lydj4b15up8NOzXWZ2P
hn291flo0J9b/bq3Phrvft5bHw36c6tf99ZHg/7c6te99dGgP7f6dW99NN79
fPb9PsO7n/fWR4P+3OrXvfXR4Jy2zm1vfTTe/Xz2/T7Du5/Pvt9n4Jy2zm1v
fTTYq9be9dZH493PZ9/vM7z7+ez7fQZ+XevX99ZH4/Xr1fw+4vXr1fw+4vXr
1fw+4vXr1fw+4vXr1fw+4vXr1fw+4vXr1fw+4vXr1fw+4p3bVef+iXduV537
J965XXXun3jndtW5f+Lt3cq9f+Dt3cq9f+D99Wr/+v7eLf7v0/09I/r7e2H7
++r7fQbb31ff7zPQv1tPddC/W+/qsP199f0+g+3vq+/3GejfrXd1cI5b4+qw
/X31/T6D7e+r7/cZOMetcXWwl61xddj+vvp+n8H299X3+wz8d6xxdZifV/P7
CPPzan4fYX5eze8jzM+r+X2E+Xk1v48wP6/m9xHm59X8PsL8vJrfR9hcV537
J2yuq879EzbXVef+CZvrqnP/hPW2cu8fsN5W7v0D9utq//q8t8X/fbr/j/5+
q1Hf7zPU9/sM9Pfqfh9R3+8z1Pf7DPX9PgP9vbrfR9T3+wz1/T5Dfb/PUN/v
M9T3+wz1/T5Dfb/PUN/vM7r5faSb30e6+X2km99Huvl9pJvfR7r5faSb30e6
zv2TrnP/pOvcP+k690869/5B594/6P3r9+79g18pFOgK
   "], {{0, 0}, {256, 256}}, {0, 
   1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{174.97265625, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
    Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[18]=",ExpressionUUID->"b1619ca4-3621-43b6-8b8f-440ad3e781ed"]
}, Open  ]],

Cell[TextData[{
 "There are many other ways to rearrange lists. For example, ",
 ButtonBox["Split",
  BaseStyle->"Link"],
 " splits a list into ",
 "runs",
 " of identical elements."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:180", "i:10"},ExpressionUUID->"e8dd28ff-4e1a-41df-aa0c-c92ab9b4ffef"],

Cell["\<\
Split a list into sequences of successive identical elements:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8647de99-4bd7-459e-8d0e-0c8f56ff4dcd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "3", 
    ",", "1", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"171d3c66-5d14-467b-aeed-bbc8f4eac9a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"332edc17-33d9-4f4e-922f-dc8cf342e0dd"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Gather",
  BaseStyle->"Link"],
 ", on the other hand, gathers identical elements together, wherever they \
appear."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"ebee30da-2871-450b-a222-18220e7795cd"],

Cell["Gather identical elements together in lists:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4ff9c2f8-6f96-4668-a203-ee08a72626e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gather", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "3", 
    ",", "1", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"03ea96e5-5327-4512-90d0-1e1989d04449"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"1ffa06b6-0b88-4ba7-8374-1cca1638a3cd"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["GatherBy",
  BaseStyle->"Link"],
 " gathers elements according to the result of applying a function to them. \
Here it\[CloseCurlyQuote]s using ",
 ButtonBox["LetterQ",
  BaseStyle->"Link"],
 ", so that it ",
 "gathers separately letters and non-letters",
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"183c3a0b-bead-4f68-bede-67fcdffc6f6f"],

Cell["\<\
Gather characters according to whether they are letters or not:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"74b7b112-581d-40e6-a102-a57472362c45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GatherBy", "[", 
  RowBox[{
   RowBox[{
   "Characters", "[", "\"\<It's true that 2+2 is equal to 4!\>\"", "]"}], ",",
    "LetterQ"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"eb7ad33b-7035-4049-ba3b-9cce48491e28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"I\"\>", ",", "\<\"t\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>",
      ",", "\<\"r\"\>", ",", "\<\"u\"\>", ",", "\<\"e\"\>", ",", "\<\"t\"\>", 
     ",", "\<\"h\"\>", ",", "\<\"a\"\>", ",", "\<\"t\"\>", ",", "\<\"i\"\>", 
     ",", "\<\"s\"\>", ",", "\<\"e\"\>", ",", "\<\"q\"\>", ",", "\<\"u\"\>", 
     ",", "\<\"a\"\>", ",", "\<\"l\"\>", ",", "\<\"t\"\>", ",", "\<\"o\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"'\"\>", ",", "\<\" \"\>", ",", "\<\" \"\>", ",", "\<\" \"\>",
      ",", "\<\"2\"\>", ",", "\<\"+\"\>", ",", "\<\"2\"\>", ",", "\<\" \"\>", 
     ",", "\<\" \"\>", ",", "\<\" \"\>", ",", "\<\" \"\>", ",", "\<\"4\"\>", 
     ",", "\<\"!\"\>"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"e619f0ae-b3f8-496d-a762-e7a56f6831ef"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["SortBy",
  BaseStyle->"Link"],
 " sorts according to the result of applying a function."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"ed646aae-2a9d-41b5-b49b-f351c414c2c3"],

Cell[TextData[{
 ButtonBox["Sort",
  BaseStyle->"Link"],
 " normally sorts shorter lists before longer ones:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"411e0669-c6aa-47bb-b8eb-c8978edb4e8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IntegerDigits", "[", 
     RowBox[{"2", "^", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"3673c499-8825-49dd-8954-219b47f9470f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2", ",", "4"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"b96941a0-bbfb-4420-81f4-9ec71198b85d"]
}, Open  ]],

Cell[TextData[{
 "Here ",
 ButtonBox["SortBy",
  BaseStyle->"Link"],
 " is told to sort by the first element in each list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e79359df-5d11-46aa-9999-9a2fe832b7fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"2", "^", "n"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", "First"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"54b1a571-214a-4c01-b188-266196fa0cfd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "8", "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"ad4bbd12-c02b-4de7-8827-ffe20180486f"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Sort",
  BaseStyle->"Link"],
 " sorts a list in order. ",
 ButtonBox["Union",
  BaseStyle->"Link"],
 " also removes any repeated elements."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"34f757d1-d3d1-492b-ad9d-462702a47ab6"],

Cell["Find all the distinct elements that appear: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8e12a87a-9498-48e2-9ef9-2ad4a460d303"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "9", ",", "5", ",", "3", ",", "1", ",", "4", ",", "3", ",", "1", 
    ",", "3", ",", "3", ",", "5", ",", "3", ",", "9"}], "}"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"399f5919-c33a-417e-b59f-ef53c2959016"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "9"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"f4b217b3-6763-4b09-b9cd-7150269c1fab"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 ButtonBox["Union",
  BaseStyle->"Link"],
 " to find the \[OpenCurlyDoubleQuote]union\[CloseCurlyDoubleQuote] of \
elements that appear in any of several lists."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d35507f8-69f5-4b46-b432-e8cd594007e1"],

Cell["Get a list of all elements that appear in any of the lists:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3ad3c2f9-72c5-42b8-ad14-8949d742fdae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3", ",", "3"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "8", ",", "5"}], "}"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"00489667-b439-4df6-838b-efd819b3bdf6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "7", ",", "8", ",", "9"}],
   "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[25]=",ExpressionUUID->"43b7f6df-09be-43f7-af78-3a745b7b23c9"]
}, Open  ]],

Cell["Find which elements are common to all the lists:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:181", "i:16"},ExpressionUUID->"efe6522a-bd78-4ecf-8ef2-b8457ec5ba3b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3", ",", "3"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "8"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"f017568d-592a-47bc-840a-6d1957eee41e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[26]=",ExpressionUUID->"107ed0bb-d7de-40a3-af3d-4f4c2614053c"]
}, Open  ]],

Cell["\<\
Find which elements are in the first list but not the second one: \
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"4f615a91-b241-4661-8f64-df3cb4b562e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3", ",", "3"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "8"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[27]:=",ExpressionUUID->"abe6b14f-4af7-42e3-88cd-6ab65d1f7b05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[27]=",ExpressionUUID->"dc72bf8e-e83f-4365-b19b-2b48a4596431"]
}, Open  ]],

Cell["\<\
Find letters that appear in any of English, Swedish and Turkish:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"4853d53c-311e-42cd-a756-53e9e131f615"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"Alphabet", "[", "\"\<English\>\"", "]"}], ",", 
   RowBox[{"Alphabet", "[", "\"\<Swedish\>\"", "]"}], ",", 
   RowBox[{"Alphabet", "[", "\"\<Turkish\>\"", "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[28]:=",ExpressionUUID->"c2d5d2f2-931f-4d85-84c5-76e1fa0ecac9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\:011f\"\>", ",", "\<\"\:015f\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"\[ARing]\"\>", ",", "\<\"\[ADoubleDot]\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"\[CCedilla]\"\>", ",", "\<\"d\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"f\"\>", ",", "\<\"g\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"i\"\>", ",", "\<\"\[DotlessI]\"\>", ",", "\<\"j\"\>", 
   ",", "\<\"k\"\>", ",", "\<\"l\"\>", ",", "\<\"m\"\>", ",", "\<\"n\"\>", 
   ",", "\<\"o\"\>", ",", "\<\"\[ODoubleDot]\"\>", ",", "\<\"p\"\>", 
   ",", "\<\"q\"\>", ",", "\<\"r\"\>", ",", "\<\"s\"\>", ",", "\<\"t\"\>", 
   ",", "\<\"u\"\>", ",", "\<\"\[UDoubleDot]\"\>", ",", "\<\"v\"\>", 
   ",", "\<\"w\"\>", ",", "\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[28]=",ExpressionUUID->"017a3e9b-f0a8-452c-94cb-528707f890a0"]
}, Open  ]],

Cell["Letters that appear in Swedish but not English:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3e44a586-4c77-4e85-b700-9af4b2607541"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Alphabet", "[", "\"\<Swedish\>\"", "]"}], ",", 
   RowBox[{"Alphabet", "[", "\"\<English\>\"", "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[29]:=",ExpressionUUID->"6fe3bd7e-5ba6-4500-9d9c-e836f9c1f5d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[ARing]\"\>", ",", "\<\"\[ADoubleDot]\"\>", 
   ",", "\<\"\[ODoubleDot]\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[29]=",ExpressionUUID->"c3594d8c-959c-4c3d-ae10-7dc5208e63bc"]
}, Open  ]],

Cell[TextData[{
 "Another of the many functions ",
 "you can apply",
 " to lists is ",
 ButtonBox["Riffle",
  BaseStyle->"Link"],
 ", which inserts things between successive elements of a list. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"050db292-e73c-4abf-80b1-5dbf98e00798"],

Cell[TextData[{
 "Riffle ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"25215763-8f82-44be-b941-55ebd483950e"],
 " in between the elements of a list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"28ecc4a8-604f-4cde-aa00-79f276521e5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[30]:=",ExpressionUUID->"1d165fa9-f436-438e-b19a-1a33592aa820"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "x", ",", "2", ",", "x", ",", "3", ",", "x", ",", "4", ",", "x", 
   ",", "5"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[30]=",ExpressionUUID->"df9f2f3b-ed39-4b11-be92-2a4623c1cd84"]
}, Open  ]],

Cell[TextData[{
 "Riffle ",
 Cell[BoxData["--"], "InlineCode",ExpressionUUID->
  "9321d9b3-810a-43bd-9b53-fa87679b7cd4"],
 " into a list of characters:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38b45c34-fa8a-48dc-81b5-d87307c9a5e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riffle", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "\"\<WOLFRAM\>\"", "]"}], ",", "\"\<--\>\""}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[31]:=",ExpressionUUID->"a83da58c-039a-4323-b14f-0cf288537780"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"W\"\>", ",", "\<\"--\"\>", ",", "\<\"O\"\>", ",", "\<\"--\"\>",
    ",", "\<\"L\"\>", ",", "\<\"--\"\>", ",", "\<\"F\"\>", ",", "\<\"--\"\>", 
   ",", "\<\"R\"\>", ",", "\<\"--\"\>", ",", "\<\"A\"\>", ",", "\<\"--\"\>", 
   ",", "\<\"M\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[31]=",ExpressionUUID->"0068b4de-742e-46ca-a8b6-443dda516495"]
}, Open  ]],

Cell["Join everything together in a single string:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ddcec93f-22e3-4c17-9402-095e5e7d4b3a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Riffle", "[", 
   RowBox[{
    RowBox[{"Characters", "[", "\"\<WOLFRAM\>\"", "]"}], ",", "\"\<--\>\""}], 
   "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[32]:=",ExpressionUUID->"b03d75d9-1430-4ae9-9aaa-6d9de349ed80"],

Cell[BoxData["\<\"W--O--L--F--R--A--M\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[32]=",ExpressionUUID->"4670fad4-a968-45d9-b45e-8fe5814af880"]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 ButtonBox["Partition",
  BaseStyle->"Link"],
 " let you take a list and break it into sublists. Sometimes ",
 "you\[CloseCurlyQuote]ll instead just want to start",
 " from a collection of possible elements, and form lists from them."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"48b69621-b517-4e94-a9e3-e6e8fa68299b"],

Cell[TextData[{
 ButtonBox["Permutations",
  BaseStyle->"Link"],
 " gives all possible orderings, or ",
 StyleBox["permutations",
  FontSlant->"Italic"],
 ", of a list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:182", "i:20"},ExpressionUUID->"569ae83e-1c1e-4ff3-9268-9df45efba35c"],

Cell["\<\
Generate a list of the 3!=3\[Times]2\[Times]1=6 possible orderings of 3 \
elements:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8eba414b-e90e-4af2-a16b-2bf76416af3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[33]:=",ExpressionUUID->"fe188099-6d88-4a0d-8d50-269b254dd7be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[33]=",ExpressionUUID->"9697afc9-42ac-4f19-87f4-2384b021aca6"]
}, Open  ]],

Cell[TextData[{
 "Generate all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "3"], "=", "8"}], TraditionalForm]],ExpressionUUID->
  "46bd5808-1ddf-4ca4-bc88-7175be4d5b7c"],
 " possible subsets of a list of 3 elements:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"54ea5451-a2b6-4bb0-9a7f-3bd9ee691de8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[34]:=",ExpressionUUID->"9f1b285a-51f1-49eb-8784-109944d4c428"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0, 0],
     Editable->False,
     Selectable->False], "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[0, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[0, 1, 0],
     Editable->False,
     Selectable->False], "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0., 0., 0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[0, 0, 1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[0, 0, 1],
     Editable->False,
     Selectable->False], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[34]=",ExpressionUUID->"b5ec3653-e951-4c01-9a0e-0e24868593b4"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Tuples",
  BaseStyle->"Link"],
 " takes a list of elements, and generates all possible combinations of a \
given number of those elements."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"99f2a01d-f5b1-4818-999c-f6ddda96293a"],

Cell["Generate a list of all possible triples of red and green:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2be49263-ef0b-4608-87ff-4b9933631ef7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green"}], "}"}], ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[35]:=",ExpressionUUID->"c3bee2e6-2f5a-431b-a6b5-6281fde38190"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[35]=",ExpressionUUID->"74da462a-4bc0-4499-96eb-99b5080146d8"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["RandomChoice",
  BaseStyle->"Link"],
 " ",
 "lets you make a random choice",
 " from a list of elements."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"417a256a-ff55-470a-bd2d-8ccc3d49c0ce"],

Cell["Make a single random choice from a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a90b018e-4cae-43ad-903c-f01693ffcea5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[36]:=",ExpressionUUID->"eef9f7ad-36ec-4cb2-b8f4-ac5b91a0fc2e"],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    GraphicsBox[{
      {GrayLevel[0], RectangleBox[{0, 0}]}, 
      {GrayLevel[0], RectangleBox[{1, -1}]}, 
      {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
     AspectRatio->1,
     Frame->True,
     FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
     FrameTicks->None,
     ImageSize->
      Dynamic[{Automatic, 
        1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification])}],
     PlotRangePadding->None],
    "RGBColor[0, 1, 0]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
         Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  RGBColor[0, 1, 0],
  Editable->False,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[36]=",ExpressionUUID->"f813acdf-29d5-450c-bea9-6328e32ab259"]
}, Open  ]],

Cell["Make a list of 20 random choices:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"45922204-9d4d-41f3-b4a6-7b053e21e5d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", "20"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[37]:=",ExpressionUUID->"c622bed4-0d2e-457a-9c15-b5c69f0cabf0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0., 0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 0, 1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 0, 1],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[37]=",ExpressionUUID->"354aa7a7-5ae9-42c5-b760-b5d8e3845dfa"]
}, Open  ]],

Cell["Make 5 lists of 3 random choices:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a074f3c8-2eb9-491a-9a02-cd624dedc97a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[38]:=",ExpressionUUID->"1c4dd1a2-7095-49f2-bd8c-460a45125d64"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[38]=",ExpressionUUID->"2b17bd04-c0b5-4a42-b76d-181d4d314efc"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["RandomSample",
  BaseStyle->"Link"],
 " picks a random sample of elements from a list, never picking any \
particular element more than once."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"9ca45ddf-45b6-4ccc-9ca8-584c15fef385"],

Cell["\<\
Pick 20 elements from the range 1 to 100, never picking any number more than \
once:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6c8aa36c-d4e5-4168-ae9f-74b7fbcfb152"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"Range", "[", "100", "]"}], ",", "20"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[39]:=",ExpressionUUID->"ab5315fd-a5a8-4bbd-b5b4-a6870e2a1ed9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "82", ",", "3", ",", "93", ",", "92", ",", "39", ",", "45", ",", "63", ",", 
   "32", ",", "79", ",", "75", ",", "34", ",", "1", ",", "11", ",", "59", ",",
    "98", ",", "67", ",", "38", ",", "44", ",", "28", ",", "76"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[39]=",ExpressionUUID->"a16c3b81-07a5-4bd4-8e66-94d062cc670c"]
}, Open  ]],

Cell["\<\
If you don\[CloseCurlyQuote]t say how many elements to pick you get a random \
ordering of the whole list:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f22e0f6f-98ca-4240-af51-756a2b7664c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[40]:=",ExpressionUUID->"20ebd000-a8b6-447e-bb55-dd87ae4c937f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "1", ",", "7", ",", "4", ",", "6", ",", "3", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[40]=",ExpressionUUID->"ab8f3322-f09d-46b1-8f0d-81d9aeea586f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:183",ExpressionUUID->"8e0aea5a-5a60-4e84-afe4-55fd5fe246ae"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "transpose inner and outer lists ", "VocabularyText",ExpressionUUID->
     "72c5c860-a952-4e1c-a47f-29a8a9c07488"]},
   {
    RowBox[{
     ButtonBox["Thread",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "1"], "\[Rule]", 
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "2"]}], "]"}], " ", Cell[
    "thread across elements of lists ", "VocabularyText",ExpressionUUID->
     "c1a5d2fb-2359-4cd6-b103-bcebf8be352e"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "partition into blocks of size ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "e48a1f86-e3d1-4228-9990-f0b9630cce3c"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "aa37f009-ca93-4407-bbba-3053c4505d99"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "flatten out all sublists ", "VocabularyText",ExpressionUUID->
     "e2738445-df89-4256-8cca-ab2dd9b5ba04"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["k", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "flatten out ",
     Cell[BoxData[
      StyleBox["k", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "5e4339bd-8e12-4045-97eb-00458b1dbab0"],
     " levels of sublists "
    }], "VocabularyText",ExpressionUUID->
     "75028fb4-aa95-44f9-b9b1-0a32b7aeb993"]},
   {
    RowBox[{
     ButtonBox["ArrayFlatten",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "flatten arrays of arrays ", "VocabularyText",ExpressionUUID->
     "71970a72-386b-47b9-9057-4dfab4e2246d"]},
   {
    RowBox[{
     ButtonBox["Split",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "split into runs of identical elements ", "VocabularyText",ExpressionUUID->
     "9a216d96-ba2b-493a-bf12-7a808e9a320a"]},
   {
    RowBox[{
     ButtonBox["Gather",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "gather identical elements into lists ", "VocabularyText",ExpressionUUID->
     "d43ef7a5-1384-447f-b8b1-b6f0b751f8c8"]},
   {
    RowBox[{
     ButtonBox["GatherBy",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["f", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "gather according to results of applying ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"f", " "}], "CodeVariable"]], "InlineCode",ExpressionUUID->
      "0b68d324-36cf-4b31-acff-7321cc00394f"]
    }], "VocabularyText",ExpressionUUID->
     "8fa30d74-feac-491d-806f-51cd1b262ce7"]},
   {
    RowBox[{
     ButtonBox["SortBy",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["f", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "sort according to results of applying ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"f", " "}], "CodeVariable"]], "InlineCode",ExpressionUUID->
      "2412463b-7123-45d4-ba41-6ac8471865da"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "9d22889d-f2d4-494b-925c-0c055fb2c639"]},
   {
    RowBox[{
     ButtonBox["Riffle",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["x", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "riffle ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "3bd7aaa3-9b91-4442-a942-2ee34a21d755"],
     " between elements of ",
     Cell[BoxData[
      StyleBox["list", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "2aafdb0e-74a6-4b50-a6c9-b7af0eb3cc60"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "50da466f-7579-4b25-9bea-e13355076093"]},
   {
    RowBox[{
     ButtonBox["Union",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     "distinct elements in ",
     Cell[BoxData[
      StyleBox["list", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "6e0d826a-e57e-4509-8d51-c562dee5d875"]
    }], "VocabularyText",ExpressionUUID->
     "aa8b5899-67ec-4660-976e-e944203e99a5"]},
   {
    RowBox[{
     ButtonBox["Union",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "1"], ",", 
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "2"], ",", " ", 
      StyleBox["...", "GrayPointSix"]}], "]"}], " ", Cell[
    "elements that appear in any of the lists", "VocabularyText",
     ExpressionUUID->"bae2c52b-ad33-42a7-bcb0-adde73e33f11"]},
   {
    RowBox[{
     ButtonBox["Intersection",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "1"], ",", 
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "2"], ",", " ", 
      StyleBox["...", "GrayPointSix"]}], "]"}], " ", Cell[
    "elements that appear in all the lists", "VocabularyText",ExpressionUUID->
     "6db6f007-bfe6-4faf-9f22-70a462da67de"]},
   {
    RowBox[{
     ButtonBox["Complement",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "1"], ",", 
      SubscriptBox[
       StyleBox["list", "CodeVariableLrg"], "2"]}], "]"}], " ", Cell[TextData[{
     "elements that appear in ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        SubscriptBox[
         StyleBox["list", "CodeVariableLrg"], "1"],
        FontColor->GrayLevel[0]], TraditionalForm]],ExpressionUUID->
      "01fea906-8384-4a78-a99b-6fe939a48d7a"],
     " but not ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        SubscriptBox[
         StyleBox["list", "CodeVariableLrg"], "2"],
        FontColor->GrayLevel[0]], TraditionalForm]],ExpressionUUID->
      "7a783fbb-d686-4ff7-8f4b-112be64896db"]
    }], "VocabularyText",ExpressionUUID->
     "d7305317-eeb4-4019-a38c-4b6b674ca1c2"]},
   {
    RowBox[{
     ButtonBox["Permutations",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "all possible permutations (orderings) ", "VocabularyText",ExpressionUUID->
     "058acbc4-a2a4-41e8-97c9-965506bcec1a"]},
   {
    RowBox[{
     ButtonBox["Subsets",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "all possible subsets ", "VocabularyText",ExpressionUUID->
     "7fac0d1a-85dd-44d9-8e81-4aa8c52319b7"]},
   {
    RowBox[{
     ButtonBox["Tuples",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "all possible combinations of ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "fcbc2e35-fb21-486a-8c33-d47b7b81cfa8"],
     " elements "
    }], "VocabularyText",ExpressionUUID->
     "1512c4a5-ba98-4df3-8bee-5de9795116a6"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     "random choice from ",
     Cell[BoxData[
      StyleBox["list", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "6ba6633c-9daa-4cb2-a874-3ddfeeedfdda"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "3f7bd954-d614-4db2-adda-a50a001b7fd2"]},
   {
    RowBox[{
     ButtonBox["RandomChoice",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "85dcee60-924c-410b-ae88-74f60f0adf1b"],
     " random choices "
    }], "VocabularyText",ExpressionUUID->
     "81a22d5f-486e-45f7-abd2-34fd52bbc50c"]},
   {
    RowBox[{
     ButtonBox["RandomSample",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "d350ab46-800e-4734-84bb-3bd9ce315a7e"],
     " random non\[Hyphen]repeating samples "
    }], "VocabularyText",ExpressionUUID->
     "543353fb-7df6-4c0a-8b51-ec632b1f67e7"]},
   {
    RowBox[{
     ButtonBox["RandomSample",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "random ordering of a list ", "VocabularyText",ExpressionUUID->
     "e318af1c-3378-405f-9a84-032be945a176"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{GridBoxDividers->{"Columns" -> {{False}}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"3aedd571-f8e6-47d7-a60a-17d0abf73573"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"c938020b-9ba6-4cac-9018-93d6ed5eb7df"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"21 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 13 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-30-rearranging-lists-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"abc41054-be9c-48a1-a369-2541d09d0e41"],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Thread",
  BaseStyle->"Link"],
 " to make a list of rules with each letter of the alphabet going to its \
position in the alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d7120b93-ad0e-44da-b10d-52f030a7b30c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"a\"\>", "\[Rule]", "1"}], ",", 
         RowBox[{"\<\"b\"\>", "\[Rule]", "2"}], ",", 
         RowBox[{"\<\"c\"\>", "\[Rule]", "3"}], ",", 
         RowBox[{"\<\"d\"\>", "\[Rule]", "4"}], ",", 
         RowBox[{"\<\"e\"\>", "\[Rule]", "5"}], ",", 
         RowBox[{"\<\"f\"\>", "\[Rule]", "6"}], ",", 
         RowBox[{"\<\"g\"\>", "\[Rule]", "7"}], ",", 
         RowBox[{"\<\"h\"\>", "\[Rule]", "8"}], ",", 
         RowBox[{"\<\"i\"\>", "\[Rule]", "9"}], ",", 
         RowBox[{"\<\"j\"\>", "\[Rule]", "10"}], ",", 
         RowBox[{"\<\"k\"\>", "\[Rule]", "11"}], ",", 
         RowBox[{"\<\"l\"\>", "\[Rule]", "12"}], ",", 
         RowBox[{"\<\"m\"\>", "\[Rule]", "13"}], ",", 
         RowBox[{"\<\"n\"\>", "\[Rule]", "14"}], ",", 
         RowBox[{"\<\"o\"\>", "\[Rule]", "15"}], ",", 
         RowBox[{"\<\"p\"\>", "\[Rule]", "16"}], ",", 
         RowBox[{"\<\"q\"\>", "\[Rule]", "17"}], ",", 
         RowBox[{"\<\"r\"\>", "\[Rule]", "18"}], ",", 
         RowBox[{"\<\"s\"\>", "\[Rule]", "19"}], ",", 
         RowBox[{"\<\"t\"\>", "\[Rule]", "20"}], ",", 
         RowBox[{"\<\"u\"\>", "\[Rule]", "21"}], ",", 
         RowBox[{"\<\"v\"\>", "\[Rule]", "22"}], ",", 
         RowBox[{"\<\"w\"\>", "\[Rule]", "23"}], ",", 
         RowBox[{"\<\"x\"\>", "\[Rule]", "24"}], ",", 
         RowBox[{"\<\"y\"\>", "\[Rule]", "25"}], ",", 
         RowBox[{"\<\"z\"\>", "\[Rule]", "26"}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"55b9c852-f27f-4a32-baa0-d384c17410db"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"\"a\"", "\[Rule]", "1"}], ",", 
             RowBox[{"\"b\"", "\[Rule]", "2"}], ",", 
             RowBox[{"\"c\"", "\[Rule]", "3"}], ",", 
             RowBox[{"\"d\"", "\[Rule]", "4"}], ",", 
             RowBox[{"\"e\"", "\[Rule]", "5"}], ",", 
             RowBox[{"\"f\"", "\[Rule]", "6"}], ",", 
             RowBox[{"\"g\"", "\[Rule]", "7"}], ",", 
             RowBox[{"\"h\"", "\[Rule]", "8"}], ",", 
             RowBox[{"\"i\"", "\[Rule]", "9"}], ",", 
             RowBox[{"\"j\"", "\[Rule]", "10"}], ",", 
             RowBox[{"\"k\"", "\[Rule]", "11"}], ",", 
             RowBox[{"\"l\"", "\[Rule]", "12"}], ",", 
             RowBox[{"\"m\"", "\[Rule]", "13"}], ",", 
             RowBox[{"\"n\"", "\[Rule]", "14"}], ",", 
             RowBox[{"\"o\"", "\[Rule]", "15"}], ",", 
             RowBox[{"\"p\"", "\[Rule]", "16"}], ",", 
             RowBox[{"\"q\"", "\[Rule]", "17"}], ",", 
             RowBox[{"\"r\"", "\[Rule]", "18"}], ",", 
             RowBox[{"\"s\"", "\[Rule]", "19"}], ",", 
             RowBox[{"\"t\"", "\[Rule]", "20"}], ",", 
             RowBox[{"\"u\"", "\[Rule]", "21"}], ",", 
             RowBox[{"\"v\"", "\[Rule]", "22"}], ",", 
             RowBox[{"\"w\"", "\[Rule]", "23"}], ",", 
             RowBox[{"\"x\"", "\[Rule]", "24"}], ",", 
             RowBox[{"\"y\"", "\[Rule]", "25"}], ",", 
             RowBox[{"\"z\"", "\[Rule]", "26"}]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6284e50b-3620-4e56-9384-f0278309cdc9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 4\[Times]6 grid of the first 24 letters of the alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3590d512-b56b-4e90-b0d5-ca2545eb293b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"a\"\>", "\<\"b\"\>", "\<\"c\"\>", "\<\"d\"\>", "\<\"e\"\>", "\
\<\"f\"\>"},
          {"\<\"g\"\>", "\<\"h\"\>", "\<\"i\"\>", "\<\"j\"\>", "\<\"k\"\>", "\
\<\"l\"\>"},
          {"\<\"m\"\>", "\<\"n\"\>", "\<\"o\"\>", "\<\"p\"\>", "\<\"q\"\>", "\
\<\"r\"\>"},
          {"\<\"s\"\>", "\<\"t\"\>", "\<\"u\"\>", "\<\"v\"\>", "\<\"w\"\>", "\
\<\"x\"\>"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "4f74c561-95f0-41ad-8669-afd091d85757"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{"\"a\"", "\"b\"", "\"c\"", "\"d\"", "\"e\"", "\"f\""}, {
            "\"g\"", "\"h\"", "\"i\"", "\"j\"", "\"k\"", "\"l\""}, {
            "\"m\"", "\"n\"", "\"o\"", "\"p\"", "\"q\"", "\"r\""}, {
            "\"s\"", "\"t\"", "\"u\"", "\"v\"", "\"w\"", "\"x\""}}, 
           AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6fe54f4d-3e99-425b-af12-9f091d1f0be6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a grid of the digits in 2^1000, with 50 digits per row, and put frames \
around everything.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4b4b4a14-ba8f-461d-b27d-1c0215744a1f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"1", "0", "7", "1", "5", "0", "8", "6", "0", "7", "1", "8", "6", 
           "2", "6", "7", "3", "2", "0", "9", "4", "8", "4", "2", "5", "0", 
           "4", "9", "0", "6", "0", "0", "0", "1", "8", "1", "0", "5", "6", 
           "1", "4", "0", "4", "8", "1", "1", "7", "0", "5", "5"},
          {"3", "3", "6", "0", "7", "4", "4", "3", "7", "5", "0", "3", "8", 
           "8", "3", "7", "0", "3", "5", "1", "0", "5", "1", "1", "2", "4", 
           "9", "3", "6", "1", "2", "2", "4", "9", "3", "1", "9", "8", "3", 
           "7", "8", "8", "1", "5", "6", "9", "5", "8", "5", "8"},
          {"1", "2", "7", "5", "9", "4", "6", "7", "2", "9", "1", "7", "5", 
           "5", "3", "1", "4", "6", "8", "2", "5", "1", "8", "7", "1", "4", 
           "5", "2", "8", "5", "6", "9", "2", "3", "1", "4", "0", "4", "3", 
           "5", "9", "8", "4", "5", "7", "7", "5", "7", "4", "6"},
          {"9", "8", "5", "7", "4", "8", "0", "3", "9", "3", "4", "5", "6", 
           "7", "7", "7", "4", "8", "2", "4", "2", "3", "0", "9", "8", "5", 
           "4", "2", "1", "0", "7", "4", "6", "0", "5", "0", "6", "2", "3", 
           "7", "1", "1", "4", "1", "8", "7", "7", "9", "5", "4"},
          {"1", "8", "2", "1", "5", "3", "0", "4", "6", "4", "7", "4", "9", 
           "8", "3", "5", "8", "1", "9", "4", "1", "2", "6", "7", "3", "9", 
           "8", "7", "6", "7", "5", "5", "9", "1", "6", "5", "5", "4", "3", 
           "9", "4", "6", "0", "7", "7", "0", "6", "2", "9", "1"},
          {"4", "5", "7", "1", "1", "9", "6", "4", "7", "7", "6", "8", "6", 
           "5", "4", "2", "1", "6", "7", "6", "6", "0", "4", "2", "9", "8", 
           "3", "1", "6", "5", "2", "6", "2", "4", "3", "8", "6", "8", "3", 
           "7", "2", "0", "5", "6", "6", "8", "0", "6", "9", "3"}
         },
         AutoDelete->False,
         GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "59fd0ffc-92aa-4cda-8a84-9263d23f0e3e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "1", "0", "7", "1", "5", "0", "8", "6", "0", "7", "1", "8", "6", 
             "2", "6", "7", "3", "2", "0", "9", "4", "8", "4", "2", "5", "0", 
             "4", "9", "0", "6", "0", "0", "0", "1", "8", "1", "0", "5", "6", 
             "1", "4", "0", "4", "8", "1", "1", "7", "0", "5", "5"}, {
            "3", "3", "6", "0", "7", "4", "4", "3", "7", "5", "0", "3", "8", 
             "8", "3", "7", "0", "3", "5", "1", "0", "5", "1", "1", "2", "4", 
             "9", "3", "6", "1", "2", "2", "4", "9", "3", "1", "9", "8", "3", 
             "7", "8", "8", "1", "5", "6", "9", "5", "8", "5", "8"}, {
            "1", "2", "7", "5", "9", "4", "6", "7", "2", "9", "1", "7", "5", 
             "5", "3", "1", "4", "6", "8", "2", "5", "1", "8", "7", "1", "4", 
             "5", "2", "8", "5", "6", "9", "2", "3", "1", "4", "0", "4", "3", 
             "5", "9", "8", "4", "5", "7", "7", "5", "7", "4", "6"}, {
            "9", "8", "5", "7", "4", "8", "0", "3", "9", "3", "4", "5", "6", 
             "7", "7", "7", "4", "8", "2", "4", "2", "3", "0", "9", "8", "5", 
             "4", "2", "1", "0", "7", "4", "6", "0", "5", "0", "6", "2", "3", 
             "7", "1", "1", "4", "1", "8", "7", "7", "9", "5", "4"}, {
            "1", "8", "2", "1", "5", "3", "0", "4", "6", "4", "7", "4", "9", 
             "8", "3", "5", "8", "1", "9", "4", "1", "2", "6", "7", "3", "9", 
             "8", "7", "6", "7", "5", "5", "9", "1", "6", "5", "5", "4", "3", 
             "9", "4", "6", "0", "7", "7", "0", "6", "2", "9", "1"}, {
            "4", "5", "7", "1", "1", "9", "6", "4", "7", "7", "6", "8", "6", 
             "5", "4", "2", "1", "6", "7", "6", "6", "0", "4", "2", "9", "8", 
             "3", "1", "6", "5", "2", "6", "2", "4", "3", "8", "6", "8", "3", 
             "7", "2", "0", "5", "6", "6", "8", "0", "6", "9", "3"}}, 
           AutoDelete -> False, 
           GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3feda60d-633e-4eec-b04a-11796deeaf91"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a grid of the first 400 characters in the Wikipedia article for \
\[OpenCurlyDoubleQuote]computers\[CloseCurlyDoubleQuote], with 20 characters \
per row, and frames around everything.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e14d3cae-ef03-4ce4-91c1-677e2611dec0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"A\"\>", "\<\" \"\>", "\<\"c\"\>", "\<\"o\"\>", "\<\"m\"\>", "\
\<\"p\"\>", "\<\"u\"\>", "\<\"t\"\>", "\<\"e\"\>", "\<\"r\"\>", "\<\" \"\>", \
"\<\"i\"\>", "\<\"s\"\>", "\<\" \"\>", "\<\"a\"\>", "\<\" \"\>", "\<\"g\"\>", \
"\<\"e\"\>", "\<\"n\"\>", "\<\"e\"\>"},
          {"\<\"r\"\>", "\<\"a\"\>", "\<\"l\"\>", "\<\"-\"\>", "\<\"p\"\>", "\
\<\"u\"\>", "\<\"r\"\>", "\<\"p\"\>", "\<\"o\"\>", "\<\"s\"\>", "\<\"e\"\>", \
"\<\" \"\>", "\<\"d\"\>", "\<\"e\"\>", "\<\"v\"\>", "\<\"i\"\>", "\<\"c\"\>", \
"\<\"e\"\>", "\<\" \"\>", "\<\"t\"\>"},
          {"\<\"h\"\>", "\<\"a\"\>", "\<\"t\"\>", "\<\" \"\>", "\<\"c\"\>", "\
\<\"a\"\>", "\<\"n\"\>", "\<\" \"\>", "\<\"b\"\>", "\<\"e\"\>", "\<\" \"\>", \
"\<\"p\"\>", "\<\"r\"\>", "\<\"o\"\>", "\<\"g\"\>", "\<\"r\"\>", "\<\"a\"\>", \
"\<\"m\"\>", "\<\"m\"\>", "\<\"e\"\>"},
          {"\<\"d\"\>", "\<\" \"\>", "\<\"t\"\>", "\<\"o\"\>", "\<\" \"\>", "\
\<\"c\"\>", "\<\"a\"\>", "\<\"r\"\>", "\<\"r\"\>", "\<\"y\"\>", "\<\" \"\>", \
"\<\"o\"\>", "\<\"u\"\>", "\<\"t\"\>", "\<\" \"\>", "\<\"a\"\>", "\<\" \"\>", \
"\<\"s\"\>", "\<\"e\"\>", "\<\"t\"\>"},
          {"\<\" \"\>", "\<\"o\"\>", "\<\"f\"\>", "\<\" \"\>", "\<\"a\"\>", "\
\<\"r\"\>", "\<\"i\"\>", "\<\"t\"\>", "\<\"h\"\>", "\<\"m\"\>", "\<\"e\"\>", \
"\<\"t\"\>", "\<\"i\"\>", "\<\"c\"\>", "\<\" \"\>", "\<\"o\"\>", "\<\"r\"\>", \
"\<\" \"\>", "\<\"l\"\>", "\<\"o\"\>"},
          {"\<\"g\"\>", "\<\"i\"\>", "\<\"c\"\>", "\<\"a\"\>", "\<\"l\"\>", "\
\<\" \"\>", "\<\"o\"\>", "\<\"p\"\>", "\<\"e\"\>", "\<\"r\"\>", "\<\"a\"\>", \
"\<\"t\"\>", "\<\"i\"\>", "\<\"o\"\>", "\<\"n\"\>", "\<\"s\"\>", "\<\" \"\>", \
"\<\"a\"\>", "\<\"u\"\>", "\<\"t\"\>"},
          {"\<\"o\"\>", "\<\"m\"\>", "\<\"a\"\>", "\<\"t\"\>", "\<\"i\"\>", "\
\<\"c\"\>", "\<\"a\"\>", "\<\"l\"\>", "\<\"l\"\>", "\<\"y\"\>", "\<\".\"\>", \
"\<\" \"\>", "\<\"S\"\>", "\<\"i\"\>", "\<\"n\"\>", "\<\"c\"\>", "\<\"e\"\>", \
"\<\" \"\>", "\<\"a\"\>", "\<\" \"\>"},
          {"\<\"s\"\>", "\<\"e\"\>", "\<\"q\"\>", "\<\"u\"\>", "\<\"e\"\>", "\
\<\"n\"\>", "\<\"c\"\>", "\<\"e\"\>", "\<\" \"\>", "\<\"o\"\>", "\<\"f\"\>", \
"\<\" \"\>", "\<\"o\"\>", "\<\"p\"\>", "\<\"e\"\>", "\<\"r\"\>", "\<\"a\"\>", \
"\<\"t\"\>", "\<\"i\"\>", "\<\"o\"\>"},
          {"\<\"n\"\>", "\<\"s\"\>", "\<\" \"\>", "\<\"c\"\>", "\<\"a\"\>", "\
\<\"n\"\>", "\<\" \"\>", "\<\"b\"\>", "\<\"e\"\>", "\<\" \"\>", "\<\"r\"\>", \
"\<\"e\"\>", "\<\"a\"\>", "\<\"d\"\>", "\<\"i\"\>", "\<\"l\"\>", "\<\"y\"\>", \
"\<\" \"\>", "\<\"c\"\>", "\<\"h\"\>"},
          {"\<\"a\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\"e\"\>", "\<\"d\"\>", "\
\<\",\"\>", "\<\" \"\>", "\<\"t\"\>", "\<\"h\"\>", "\<\"e\"\>", "\<\" \"\>", \
"\<\"c\"\>", "\<\"o\"\>", "\<\"m\"\>", "\<\"p\"\>", "\<\"u\"\>", "\<\"t\"\>", \
"\<\"e\"\>", "\<\"r\"\>", "\<\" \"\>"},
          {"\<\"c\"\>", "\<\"a\"\>", "\<\"n\"\>", "\<\" \"\>", "\<\"s\"\>", "\
\<\"o\"\>", "\<\"l\"\>", "\<\"v\"\>", "\<\"e\"\>", "\<\" \"\>", "\<\"m\"\>", \
"\<\"o\"\>", "\<\"r\"\>", "\<\"e\"\>", "\<\" \"\>", "\<\"t\"\>", "\<\"h\"\>", \
"\<\"a\"\>", "\<\"n\"\>", "\<\" \"\>"},
          {"\<\"o\"\>", "\<\"n\"\>", "\<\"e\"\>", "\<\" \"\>", "\<\"k\"\>", "\
\<\"i\"\>", "\<\"n\"\>", "\<\"d\"\>", "\<\" \"\>", "\<\"o\"\>", "\<\"f\"\>", \
"\<\" \"\>", "\<\"p\"\>", "\<\"r\"\>", "\<\"o\"\>", "\<\"b\"\>", "\<\"l\"\>", \
"\<\"e\"\>", "\<\"m\"\>", "\<\".\"\>"},
          {"\<\"\\n\"\>", "\<\"C\"\>", "\<\"o\"\>", "\<\"n\"\>", "\<\"v\"\>", \
"\<\"e\"\>", "\<\"n\"\>", "\<\"t\"\>", "\<\"i\"\>", "\<\"o\"\>", "\<\"n\"\>", \
"\<\"a\"\>", "\<\"l\"\>", "\<\"l\"\>", "\<\"y\"\>", "\<\",\"\>", "\<\" \"\>", \
"\<\"a\"\>", "\<\" \"\>", "\<\"c\"\>"},
          {"\<\"o\"\>", "\<\"m\"\>", "\<\"p\"\>", "\<\"u\"\>", "\<\"t\"\>", "\
\<\"e\"\>", "\<\"r\"\>", "\<\" \"\>", "\<\"c\"\>", "\<\"o\"\>", "\<\"n\"\>", \
"\<\"s\"\>", "\<\"i\"\>", "\<\"s\"\>", "\<\"t\"\>", "\<\"s\"\>", "\<\" \"\>", \
"\<\"o\"\>", "\<\"f\"\>", "\<\" \"\>"},
          {"\<\"a\"\>", "\<\"t\"\>", "\<\" \"\>", "\<\"l\"\>", "\<\"e\"\>", "\
\<\"a\"\>", "\<\"s\"\>", "\<\"t\"\>", "\<\" \"\>", "\<\"o\"\>", "\<\"n\"\>", \
"\<\"e\"\>", "\<\" \"\>", "\<\"p\"\>", "\<\"r\"\>", "\<\"o\"\>", "\<\"c\"\>", \
"\<\"e\"\>", "\<\"s\"\>", "\<\"s\"\>"},
          {"\<\"i\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\" \"\>", "\<\"e\"\>", "\
\<\"l\"\>", "\<\"e\"\>", "\<\"m\"\>", "\<\"e\"\>", "\<\"n\"\>", "\<\"t\"\>", \
"\<\",\"\>", "\<\" \"\>", "\<\"t\"\>", "\<\"y\"\>", "\<\"p\"\>", "\<\"i\"\>", \
"\<\"c\"\>", "\<\"a\"\>", "\<\"l\"\>"},
          {"\<\"l\"\>", "\<\"y\"\>", "\<\" \"\>", "\<\"a\"\>", "\<\" \"\>", "\
\<\"c\"\>", "\<\"e\"\>", "\<\"n\"\>", "\<\"t\"\>", "\<\"r\"\>", "\<\"a\"\>", \
"\<\"l\"\>", "\<\" \"\>", "\<\"p\"\>", "\<\"r\"\>", "\<\"o\"\>", "\<\"c\"\>", \
"\<\"e\"\>", "\<\"s\"\>", "\<\"s\"\>"},
          {"\<\"i\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\" \"\>", "\<\"u\"\>", "\
\<\"n\"\>", "\<\"i\"\>", "\<\"t\"\>", "\<\" \"\>", "\<\"(\"\>", "\<\"C\"\>", \
"\<\"P\"\>", "\<\"U\"\>", "\<\")\"\>", "\<\",\"\>", "\<\" \"\>", "\<\"a\"\>", \
"\<\"n\"\>", "\<\"d\"\>", "\<\" \"\>"},
          {"\<\"s\"\>", "\<\"o\"\>", "\<\"m\"\>", "\<\"e\"\>", "\<\" \"\>", "\
\<\"f\"\>", "\<\"o\"\>", "\<\"r\"\>", "\<\"m\"\>", "\<\" \"\>", "\<\"o\"\>", \
"\<\"f\"\>", "\<\" \"\>", "\<\"m\"\>", "\<\"e\"\>", "\<\"m\"\>", "\<\"o\"\>", \
"\<\"r\"\>", "\<\"y\"\>", "\<\".\"\>"},
          {"\<\" \"\>", "\<\"T\"\>", "\<\"h\"\>", "\<\"e\"\>", "\<\" \"\>", "\
\<\"p\"\>", "\<\"r\"\>", "\<\"o\"\>", "\<\"c\"\>", "\<\"e\"\>", "\<\"s\"\>", \
"\<\"s\"\>", "\<\"i\"\>", "\<\"n\"\>", "\<\"g\"\>", "\<\" \"\>", "\<\"e\"\>", \
"\<\"l\"\>", "\<\"e\"\>", "\<\"m\"\>"}
         },
         AutoDelete->False,
         GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "b3599dec-b7c4-4c39-89a8-3e34a2da05a6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "\"A\"", "\" \"", "\"c\"", "\"o\"", "\"m\"", "\"p\"", "\"u\"", 
             "\"t\"", "\"e\"", "\"r\"", "\" \"", "\"i\"", "\"s\"", "\" \"", 
             "\"a\"", "\" \"", "\"g\"", "\"e\"", "\"n\"", "\"e\""}, {
            "\"r\"", "\"a\"", "\"l\"", "\"-\"", "\"p\"", "\"u\"", "\"r\"", 
             "\"p\"", "\"o\"", "\"s\"", "\"e\"", "\" \"", "\"d\"", "\"e\"", 
             "\"v\"", "\"i\"", "\"c\"", "\"e\"", "\" \"", "\"t\""}, {
            "\"h\"", "\"a\"", "\"t\"", "\" \"", "\"c\"", "\"a\"", "\"n\"", 
             "\" \"", "\"b\"", "\"e\"", "\" \"", "\"p\"", "\"r\"", "\"o\"", 
             "\"g\"", "\"r\"", "\"a\"", "\"m\"", "\"m\"", "\"e\""}, {
            "\"d\"", "\" \"", "\"t\"", "\"o\"", "\" \"", "\"c\"", "\"a\"", 
             "\"r\"", "\"r\"", "\"y\"", "\" \"", "\"o\"", "\"u\"", "\"t\"", 
             "\" \"", "\"a\"", "\" \"", "\"s\"", "\"e\"", "\"t\""}, {
            "\" \"", "\"o\"", "\"f\"", "\" \"", "\"a\"", "\"r\"", "\"i\"", 
             "\"t\"", "\"h\"", "\"m\"", "\"e\"", "\"t\"", "\"i\"", "\"c\"", 
             "\" \"", "\"o\"", "\"r\"", "\" \"", "\"l\"", "\"o\""}, {
            "\"g\"", "\"i\"", "\"c\"", "\"a\"", "\"l\"", "\" \"", "\"o\"", 
             "\"p\"", "\"e\"", "\"r\"", "\"a\"", "\"t\"", "\"i\"", "\"o\"", 
             "\"n\"", "\"s\"", "\" \"", "\"a\"", "\"u\"", "\"t\""}, {
            "\"o\"", "\"m\"", "\"a\"", "\"t\"", "\"i\"", "\"c\"", "\"a\"", 
             "\"l\"", "\"l\"", "\"y\"", "\".\"", "\" \"", "\"S\"", "\"i\"", 
             "\"n\"", "\"c\"", "\"e\"", "\" \"", "\"a\"", "\" \""}, {
            "\"s\"", "\"e\"", "\"q\"", "\"u\"", "\"e\"", "\"n\"", "\"c\"", 
             "\"e\"", "\" \"", "\"o\"", "\"f\"", "\" \"", "\"o\"", "\"p\"", 
             "\"e\"", "\"r\"", "\"a\"", "\"t\"", "\"i\"", "\"o\""}, {
            "\"n\"", "\"s\"", "\" \"", "\"c\"", "\"a\"", "\"n\"", "\" \"", 
             "\"b\"", "\"e\"", "\" \"", "\"r\"", "\"e\"", "\"a\"", "\"d\"", 
             "\"i\"", "\"l\"", "\"y\"", "\" \"", "\"c\"", "\"h\""}, {
            "\"a\"", "\"n\"", "\"g\"", "\"e\"", "\"d\"", "\",\"", "\" \"", 
             "\"t\"", "\"h\"", "\"e\"", "\" \"", "\"c\"", "\"o\"", "\"m\"", 
             "\"p\"", "\"u\"", "\"t\"", "\"e\"", "\"r\"", "\" \""}, {
            "\"c\"", "\"a\"", "\"n\"", "\" \"", "\"s\"", "\"o\"", "\"l\"", 
             "\"v\"", "\"e\"", "\" \"", "\"m\"", "\"o\"", "\"r\"", "\"e\"", 
             "\" \"", "\"t\"", "\"h\"", "\"a\"", "\"n\"", "\" \""}, {
            "\"o\"", "\"n\"", "\"e\"", "\" \"", "\"k\"", "\"i\"", "\"n\"", 
             "\"d\"", "\" \"", "\"o\"", "\"f\"", "\" \"", "\"p\"", "\"r\"", 
             "\"o\"", "\"b\"", "\"l\"", "\"e\"", "\"m\"", "\".\""}, {
            "\"\\n\"", "\"C\"", "\"o\"", "\"n\"", "\"v\"", "\"e\"", "\"n\"", 
             "\"t\"", "\"i\"", "\"o\"", "\"n\"", "\"a\"", "\"l\"", "\"l\"", 
             "\"y\"", "\",\"", "\" \"", "\"a\"", "\" \"", "\"c\""}, {
            "\"o\"", "\"m\"", "\"p\"", "\"u\"", "\"t\"", "\"e\"", "\"r\"", 
             "\" \"", "\"c\"", "\"o\"", "\"n\"", "\"s\"", "\"i\"", "\"s\"", 
             "\"t\"", "\"s\"", "\" \"", "\"o\"", "\"f\"", "\" \""}, {
            "\"a\"", "\"t\"", "\" \"", "\"l\"", "\"e\"", "\"a\"", "\"s\"", 
             "\"t\"", "\" \"", "\"o\"", "\"n\"", "\"e\"", "\" \"", "\"p\"", 
             "\"r\"", "\"o\"", "\"c\"", "\"e\"", "\"s\"", "\"s\""}, {
            "\"i\"", "\"n\"", "\"g\"", "\" \"", "\"e\"", "\"l\"", "\"e\"", 
             "\"m\"", "\"e\"", "\"n\"", "\"t\"", "\",\"", "\" \"", "\"t\"", 
             "\"y\"", "\"p\"", "\"i\"", "\"c\"", "\"a\"", "\"l\""}, {
            "\"l\"", "\"y\"", "\" \"", "\"a\"", "\" \"", "\"c\"", "\"e\"", 
             "\"n\"", "\"t\"", "\"r\"", "\"a\"", "\"l\"", "\" \"", "\"p\"", 
             "\"r\"", "\"o\"", "\"c\"", "\"e\"", "\"s\"", "\"s\""}, {
            "\"i\"", "\"n\"", "\"g\"", "\" \"", "\"u\"", "\"n\"", "\"i\"", 
             "\"t\"", "\" \"", "\"(\"", "\"C\"", "\"P\"", "\"U\"", "\")\"", 
             "\",\"", "\" \"", "\"a\"", "\"n\"", "\"d\"", "\" \""}, {
            "\"s\"", "\"o\"", "\"m\"", "\"e\"", "\" \"", "\"f\"", "\"o\"", 
             "\"r\"", "\"m\"", "\" \"", "\"o\"", "\"f\"", "\" \"", "\"m\"", 
             "\"e\"", "\"m\"", "\"o\"", "\"r\"", "\"y\"", "\".\""}, {
            "\" \"", "\"T\"", "\"h\"", "\"e\"", "\" \"", "\"p\"", "\"r\"", 
             "\"o\"", "\"c\"", "\"e\"", "\"s\"", "\"s\"", "\"i\"", "\"n\"", 
             "\"g\"", "\" \"", "\"e\"", "\"l\"", "\"e\"", "\"m\""}}, 
           AutoDelete -> False, 
           GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4f825f31-2d25-49a1-997c-d894b7c59e62"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the flattened list of the digits from the numbers from \
0 to 200 (",
 StyleBox["Champernowne sequence",
  FontSlant->"Italic"],
 ").",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"335e0c26-6efd-47fe-a007-8e3a2343e79a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.011111111111111112`], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdmEkO3EQUhgtWLHvBggULYyGEEELNPJMKZCIJiZMACSQEZ4aEEGeeozpC
H8FH6CPUEfoIvgBSHwEh/3+j99Xm6fP/ld1+5aG737h46+SVl1NK/7yU0n91
Hts9KY4ct7+S4/ZFjttfxfbXsP11bG+wvcX2N7H9LXyet/15NN5B/i74PfDS
81XfR/6B2Of3IfKPxD7fj5F/Ivb5f4r8M7H78TnyL8Tuz5fIvxK7X18j/0bc
qu5R9flm8zxKRr437q/sRf5t5AJO36mqf+U75PtU1b+yD/l+VfWv7Ed+QFX9
KweQH1RV/8pB5IdU1b9yCPn3qq1ys6+Hw/bnUQ4jP6Lq/h1BfjQerxxF/kPk
Ak7HVN2/Y8iPq7p/x5F3qupf7mJezOpfRZ5OqKp/+UTMi7nVfLPvl5OqGvlk
zItZ/avI0ynP1/FPxbyY9Xkq8vRj5AwuZvWvIk8/qbp/P8W8mN0/5OlnVffv
55gXc6v5Zj9PTqtq5NMxL2b3D3k64/k6/pmYF7P7hzz9Ej9v/iXmBVzB6VdV
9+/XmBez+4c8nVV1/87GvJhbzTf7eXtOVSOfi3kxu3/I02+er+P/FvNidv+Q
p/Oq7t/5mBez+4c8/R45g4vZ/UOeelX1r+ljns3tXHuzn6dmjRF5Nat/E/J0
wfN1/Asxz2b1r0dezOrfiLya1b8JebqoqvNtLsY8g3twMat/I/JqbnV8+OmS
qkZzKebZrP71yMtuvo6PvJrVvwl5uqyq/jWXY57N6l+PvJjVvxF5NasfE/J0
JXIDzuZWxwcXs8aIvJp9/SFPVz1fx78a82z29Ye8mH39Ia9mX3/I0zVVX3/X
Yp7Nvv6QF7OvP+QVPJn9/fAPsUYDzmZff8gL8hFc4U87Vv0z+s2f0c9m9x9+
gT+atR4V/gQ/XRdrfZrr0c/Xo9+b/XyFP8KvZl//8NON6DdmX/83ot/DL+Z2
riP8Cp4wP/0V8wacwT24gEez1rcin8Dppljr29yMeQb3Zn8/Qj6Cq9n3H/L0
d+TG7Pcf8h5czFrfEXkFT2Y//27h+OBsbufaIy9mP/93PI8Kf4KfhpgvwM0Q
/SU4w++Q92at7wC/wF+Z/TyFv4ZfzVrfDfwJ/tbs7z+3o7+4Hf3GrPVdws/w
O7PWt4c/wC/mdq4r+KNZ/Vvv5s+jwt/An5BvwelO9Bdmn/+d6C/hZ3AHv0c+
mH3/wl/BH81a3zX8Cn9j1vpO8Lfw011Vre/ibvSbu9Ffmv18ht/B783tXAf4
xax+rMwaI/w1/Ip8A57gb3f7V70X/cW96Ddmnz/8DL8D9/AH5MWs9V3BH+Gv
zVrfCn8DfzJrfbfw0/3oL8z+Pno/+kv42dzOtYPfm3V+g1mjwF/BH5GvwRX+
Zrf/uU7wt/DTA1Xf/w+i3zyI/tLs84ffwe/BA/yCfGX27wn4a/jVrPXdwJ/g
b81+/z6M/uJh9BtzO9cl/GzW5+3MGj38AX5BvgKP8Ne7/c+1wt/An8xa3y38
9Cj6C7Pv/0fRX8LPZvWrg9/DH8AF/gr5aNb6ruFX+Buz1neCv4WfHqu2c108
jn5j9vvfrJHhd/B75AO4wF/t9j/XEf4afjX7/Qd/gr81+//HJ9FfPIl+Y/b9
Dz/D78zqbw9/gF/AK/gj8rXZ/y/A38CfzO1ct/DT07i/hVmjeRr9JfyMvAP3
8Ifd/uda4K/gj2Z//4Nf4W/Mfv/B38JPz1S1votn0W+eRX9p9v0Pv4Pfm7Ue
A/wCfwUe4a+RV3M71w38CfnW7PE8+ovn0W+QL8EZfmf27x/4A/xi1vqu4I/w
12Z//4O/gT+Z/f6Dn15Ef2H2/1Evor+En82+/+H38Aez/z+Ev4I/gtdmv/92
PI/N//wvBq4bIA==
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{465.4453125, Automatic},
        Method->{},
        PlotRange->{{0., 493.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "9271e28d-0cf0-4a70-ad00-2baa8c44411d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.011111111111111112`], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxdmEkO3EQUhgtWLHvBggULYyGEEELNPJMKZCIJiZMACSQEZ4aEEGeeozpC
H8FH6CPUEfoIvgBSHwEh/3+j99Xm6fP/ld1+5aG737h46+SVl1NK/7yU0n91
Hts9KY4ct7+S4/ZFjttfxfbXsP11bG+wvcX2N7H9LXyet/15NN5B/i74PfDS
81XfR/6B2Of3IfKPxD7fj5F/Ivb5f4r8M7H78TnyL8Tuz5fIvxK7X18j/0bc
qu5R9flm8zxKRr437q/sRf5t5AJO36mqf+U75PtU1b+yD/l+VfWv7Ed+QFX9
KweQH1RV/8pB5IdU1b9yCPn3qq1ys6+Hw/bnUQ4jP6Lq/h1BfjQerxxF/kPk
Ak7HVN2/Y8iPq7p/x5F3qupf7mJezOpfRZ5OqKp/+UTMi7nVfLPvl5OqGvlk
zItZ/avI0ynP1/FPxbyY9Xkq8vRj5AwuZvWvIk8/qbp/P8W8mN0/5OlnVffv
55gXc6v5Zj9PTqtq5NMxL2b3D3k64/k6/pmYF7P7hzz9Ej9v/iXmBVzB6VdV
9+/XmBez+4c8nVV1/87GvJhbzTf7eXtOVSOfi3kxu3/I02+er+P/FvNidv+Q
p/Oq7t/5mBez+4c8/R45g4vZ/UOeelX1r+ljns3tXHuzn6dmjRF5Nat/E/J0
wfN1/Asxz2b1r0dezOrfiLya1b8JebqoqvNtLsY8g3twMat/I/JqbnV8+OmS
qkZzKebZrP71yMtuvo6PvJrVvwl5uqyq/jWXY57N6l+PvJjVvxF5NasfE/J0
JXIDzuZWxwcXs8aIvJp9/SFPVz1fx78a82z29Ye8mH39Ia9mX3/I0zVVX3/X
Yp7Nvv6QF7OvP+QVPJn9/fAPsUYDzmZff8gL8hFc4U87Vv0z+s2f0c9m9x9+
gT+atR4V/gQ/XRdrfZrr0c/Xo9+b/XyFP8KvZl//8NON6DdmX/83ot/DL+Z2
riP8Cp4wP/0V8wacwT24gEez1rcin8Dppljr29yMeQb3Zn8/Qj6Cq9n3H/L0
d+TG7Pcf8h5czFrfEXkFT2Y//27h+OBsbufaIy9mP/93PI8Kf4KfhpgvwM0Q
/SU4w++Q92at7wC/wF+Z/TyFv4ZfzVrfDfwJ/tbs7z+3o7+4Hf3GrPVdws/w
O7PWt4c/wC/mdq4r+KNZ/Vvv5s+jwt/An5BvwelO9Bdmn/+d6C/hZ3AHv0c+
mH3/wl/BH81a3zX8Cn9j1vpO8Lfw011Vre/ibvSbu9Ffmv18ht/B783tXAf4
xax+rMwaI/w1/Ip8A57gb3f7V70X/cW96Ddmnz/8DL8D9/AH5MWs9V3BH+Gv
zVrfCn8DfzJrfbfw0/3oL8z+Pno/+kv42dzOtYPfm3V+g1mjwF/BH5GvwRX+
Zrf/uU7wt/DTA1Xf/w+i3zyI/tLs84ffwe/BA/yCfGX27wn4a/jVrPXdwJ/g
b81+/z6M/uJh9BtzO9cl/GzW5+3MGj38AX5BvgKP8Ne7/c+1wt/An8xa3y38
9Cj6C7Pv/0fRX8LPZvWrg9/DH8AF/gr5aNb6ruFX+Buz1neCv4WfHqu2c108
jn5j9vvfrJHhd/B75AO4wF/t9j/XEf4afjX7/Qd/gr81+//HJ9FfPIl+Y/b9
Dz/D78zqbw9/gF/AK/gj8rXZ/y/A38CfzO1ct/DT07i/hVmjeRr9JfyMvAP3
8Ifd/uda4K/gj2Z//4Nf4W/Mfv/B38JPz1S1votn0W+eRX9p9v0Pv4Pfm7Ue
A/wCfwUe4a+RV3M71w38CfnW7PE8+ovn0W+QL8EZfmf27x/4A/xi1vqu4I/w
12Z//4O/gT+Z/f6Dn15Ef2H2/1Evor+En82+/+H38Aez/z+Ev4I/gtdmv/92
PI/N//wvBq4bIA==
               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {465.4453125, Automatic}, 
          Method -> {}, PlotRange -> {{0., 493.}, {0, 9.}}, PlotRangeClipping -> 
          True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6eac1ad6-9606-4027-b1d7-d040452ab4b4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make 4 steps in the ",
 StyleBox["\[OpenCurlyDoubleQuote]Menger sponge\[CloseCurlyDoubleQuote]",
  FontSlant->"Italic"],
 " analog of the fractal Sierpinski pattern from the text, but with a \
\[OpenCurlyDoubleQuote]kernel\[CloseCurlyDoubleQuote] of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], ",", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], ",", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], ",", "0", ",", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], ",", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], ",", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"]}], "}"}]}], "}"}]], "InlineCode",ExpressionUUID->
  "c3a80841-4b70-4afc-ab6f-f77e06dabeef"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:26",ExpressionUUID->"d8518d6e-d5e9-4815-8219-21945099bb00"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[RasterBox[{{0}}, {{0, 0}, {1, 1}}, {0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[
          RasterBox[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, {{0, 0}, {3, 3}}, {0, 
           1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[
          RasterBox[{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 1, 
           0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 
           1, 0, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 
           0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 
           0, 0}}, {{0, 0}, {9, 9}}, {0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQhmJ8gBE3wq+PkRE7gxHMYMTGwKOLBi6Emw8BmAYipDAM
xKIL5lRkKTQvIxuI5mUsumjgQtyhMDxjGQCjewK4
           "], {{0, 0}, {27, 27}}, {
           0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJztWFEKwzAIjbvJjrQdoRfo/f8GI+mKRqnmFSKLpCCxumfeM5Q9t/29PUop
r/rgjdDrDoxESIe+DuEcOEK4ZWC5Im02GmpQfyHRhS8ER9joPoeYEnyhJsgz
eKZVXwiOEH6GGVgGW4ZZZkoYddaNPSXLKnbdzDR1WQVDLQcR6gKwCwaEbbes
ZeERws8wA8ss3VWw8xOiQVfLnUOAIxQikTvdglqWlLFL2HIHj/AvWdbsSsFe
WoJZPl5gjl1Qy1o39pwsg80AH1t3YFzf2IOWgeWKVJ8CX0hMrjHUl0JwhOL2
O3aCofWvyJQsgy3DLDMljDrrxp6P5Q9Tgwvs
           "], {{0, 0}, {81, 81}}, {0, 
           1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "0a035163-fa7c-4b81-850d-6c05c2e00c06"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              RasterBox[{{0}}, {{0, 0}, {1, 1}}, {0, 1}], Frame -> Automatic, 
              FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              
              RasterBox[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, {{0, 0}, {3, 3}}, {
               0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              
              RasterBox[{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 1,
                0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 
               0}, {0, 1, 0, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 0}, {
               0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 1, 0}, {0, 0,
                0, 0, 0, 0, 0, 0, 0}}, {{0, 0}, {9, 9}}, {0, 1}], Frame -> 
              Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQhmJ8gBE3wq+PkRE7gxHMYMTGwKOLBi6Emw8BmAYipDAM
xKIL5lRkKTQvIxuI5mUsumjgQtyhMDxjGQCjewK4
               "], {{0, 0}, {27, 
               27}}, {0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJztWFEKwzAIjbvJjrQdoRfo/f8GI+mKRqnmFSKLpCCxumfeM5Q9t/29PUop
r/rgjdDrDoxESIe+DuEcOEK4ZWC5Im02GmpQfyHRhS8ER9joPoeYEnyhJsgz
eKZVXwiOEH6GGVgGW4ZZZkoYddaNPSXLKnbdzDR1WQVDLQcR6gKwCwaEbbes
ZeERws8wA8ss3VWw8xOiQVfLnUOAIxQikTvdglqWlLFL2HIHj/AvWdbsSsFe
WoJZPl5gjl1Qy1o39pwsg80AH1t3YFzf2IOWgeWKVJ8CX0hMrjHUl0JwhOL2
O3aCofWvyJQsgy3DLDMljDrrxp6P5Q9Tgwvs
               "], {{0, 0}, {81, 81}}, {
               0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e6af9103-e865-44fa-97db-be291648f020"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find ",
 StyleBox["Pythagorean triples",
  FontSlant->"Italic"],
 " involving only integers by selecting ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", 
    RowBox[{
     ButtonBox["Sqrt",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"x", 
      ButtonBox["^",
       BaseStyle->"Link",
       ButtonData->"Power"], "2", 
      ButtonBox["+",
       BaseStyle->"Link",
       ButtonData->"Plus"], "y", 
      ButtonBox["^",
       BaseStyle->"Link",
       ButtonData->"Power"], "2"}], "]"}]}], "}"}]], "InlineCode",
  ExpressionUUID->"086185fa-417a-4061-b82c-ccf8e5f2c126"],
 " with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"f967bd72-e496-4ba3-89d7-9dad29e792dd"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"40d6e11d-13d0-48da-ba34-b6688d3de6c9"],
 " up to 20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:27",ExpressionUUID->"4b3920f5-2fe9-43ad-aaeb-59b6ce152d1a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "3", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "12", ",", "13"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "8", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "6", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "15", ",", "17"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "12", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12", ",", "5", ",", "13"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12", ",", "9", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12", ",", "16", ",", "20"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"15", ",", "8", ",", "17"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"15", ",", "20", ",", "25"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"16", ",", "12", ",", "20"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"20", ",", "15", ",", "25"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "40d914f7-ef32-436b-b5b2-15e401ed8a5d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "3", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "12", ",", "13"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "8", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "6", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "15", ",", "17"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "12", ",", "15"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"12", ",", "5", ",", "13"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"12", ",", "9", ",", "15"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"12", ",", "16", ",", "20"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"15", ",", "8", ",", "17"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"15", ",", "20", ",", "25"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"16", ",", "12", ",", "20"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"20", ",", "15", ",", "25"}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fc7d988d-110d-4700-8b25-4f34deac51e6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the lengths of the longest sequences of identical digits in ",
 Cell[BoxData[
  RowBox[{"2", 
   ButtonBox["^",
    BaseStyle->"Link",
    ButtonData->"Power"], "n"}]], "InlineCode",ExpressionUUID->
  "a9237f21-e3bb-4018-b2bb-120bcdc0b2b0"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"033df353-df94-47b8-b678-8fd30a4cedee"],
 " up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d9373a53-a8ef-4cae-b2a9-12c5d6aa054c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
         "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",",
          "1", ",", "2", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", 
         ",", "1", ",", "2", ",", "3", ",", "2", ",", "2", ",", "2", ",", "1",
          ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "1", ",", 
         "1", ",", "1", ",", "1", ",", "2", ",", "3", ",", "3", ",", "4", ",",
          "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "2", ",", "1", 
         ",", "2", ",", "3", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1",
          ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",",
          "1", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", 
         ",", "3", ",", "3", ",", "2", ",", "2", ",", "1", ",", "2", ",", "2",
          ",", "3", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", 
         "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",",
          "2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "e5426826-a8d0-456f-b0b8-966dca68b9cf"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",",
              "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
              ",", "1", ",", "1", ",", "2", ",", "1", ",", "2", ",", "2", ",",
              "1", ",", "1", ",", "1", ",", "2", ",", "3", ",", "2", ",", "2",
              ",", "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",",
              "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "3",
              ",", "3", ",", "4", ",", "3", ",", "3", ",", "3", ",", "3", ",",
              "2", ",", "2", ",", "1", ",", "2", ",", "3", ",", "2", ",", "2",
              ",", "2", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", ",",
              "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2",
              ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", ",",
              "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2",
              ",", "2", ",", "1", ",", "2", ",", "2", ",", "3", ",", "2", ",",
              "2", ",", "2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "2",
              ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",",
              "2", ",", "2", ",", "2"}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c0db4dca-6336-42f0-b714-c8d010130349"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Take the names of integers up to 100 and gather them into sublists \
according to their first letters.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f1368f2f-6b08-42e5-bee7-969ff3d74a04"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"one\"\>", ",", "\<\"one hundred\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"two\"\>", ",", "\<\"three\"\>", ",", "\<\"ten\"\>", 
           ",", "\<\"twelve\"\>", ",", "\<\"thirteen\"\>", 
           ",", "\<\"twenty\"\>", ",", "\<\"twenty\[Hyphen]one\"\>", 
           ",", "\<\"twenty\[Hyphen]two\"\>", 
           ",", "\<\"twenty\[Hyphen]three\"\>", 
           ",", "\<\"twenty\[Hyphen]four\"\>", 
           ",", "\<\"twenty\[Hyphen]five\"\>", 
           ",", "\<\"twenty\[Hyphen]six\"\>", 
           ",", "\<\"twenty\[Hyphen]seven\"\>", 
           ",", "\<\"twenty\[Hyphen]eight\"\>", 
           ",", "\<\"twenty\[Hyphen]nine\"\>", ",", "\<\"thirty\"\>", 
           ",", "\<\"thirty\[Hyphen]one\"\>", 
           ",", "\<\"thirty\[Hyphen]two\"\>", 
           ",", "\<\"thirty\[Hyphen]three\"\>", 
           ",", "\<\"thirty\[Hyphen]four\"\>", 
           ",", "\<\"thirty\[Hyphen]five\"\>", 
           ",", "\<\"thirty\[Hyphen]six\"\>", 
           ",", "\<\"thirty\[Hyphen]seven\"\>", 
           ",", "\<\"thirty\[Hyphen]eight\"\>", 
           ",", "\<\"thirty\[Hyphen]nine\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"four\"\>", ",", "\<\"five\"\>", 
           ",", "\<\"fourteen\"\>", ",", "\<\"fifteen\"\>", 
           ",", "\<\"forty\"\>", ",", "\<\"forty\[Hyphen]one\"\>", 
           ",", "\<\"forty\[Hyphen]two\"\>", 
           ",", "\<\"forty\[Hyphen]three\"\>", 
           ",", "\<\"forty\[Hyphen]four\"\>", 
           ",", "\<\"forty\[Hyphen]five\"\>", 
           ",", "\<\"forty\[Hyphen]six\"\>", 
           ",", "\<\"forty\[Hyphen]seven\"\>", 
           ",", "\<\"forty\[Hyphen]eight\"\>", 
           ",", "\<\"forty\[Hyphen]nine\"\>", ",", "\<\"fifty\"\>", 
           ",", "\<\"fifty\[Hyphen]one\"\>", ",", "\<\"fifty\[Hyphen]two\"\>",
            ",", "\<\"fifty\[Hyphen]three\"\>", 
           ",", "\<\"fifty\[Hyphen]four\"\>", 
           ",", "\<\"fifty\[Hyphen]five\"\>", 
           ",", "\<\"fifty\[Hyphen]six\"\>", 
           ",", "\<\"fifty\[Hyphen]seven\"\>", 
           ",", "\<\"fifty\[Hyphen]eight\"\>", 
           ",", "\<\"fifty\[Hyphen]nine\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"six\"\>", ",", "\<\"seven\"\>", ",", "\<\"sixteen\"\>",
            ",", "\<\"seventeen\"\>", ",", "\<\"sixty\"\>", 
           ",", "\<\"sixty\[Hyphen]one\"\>", ",", "\<\"sixty\[Hyphen]two\"\>",
            ",", "\<\"sixty\[Hyphen]three\"\>", 
           ",", "\<\"sixty\[Hyphen]four\"\>", 
           ",", "\<\"sixty\[Hyphen]five\"\>", 
           ",", "\<\"sixty\[Hyphen]six\"\>", 
           ",", "\<\"sixty\[Hyphen]seven\"\>", 
           ",", "\<\"sixty\[Hyphen]eight\"\>", 
           ",", "\<\"sixty\[Hyphen]nine\"\>", ",", "\<\"seventy\"\>", 
           ",", "\<\"seventy\[Hyphen]one\"\>", 
           ",", "\<\"seventy\[Hyphen]two\"\>", 
           ",", "\<\"seventy\[Hyphen]three\"\>", 
           ",", "\<\"seventy\[Hyphen]four\"\>", 
           ",", "\<\"seventy\[Hyphen]five\"\>", 
           ",", "\<\"seventy\[Hyphen]six\"\>", 
           ",", "\<\"seventy\[Hyphen]seven\"\>", 
           ",", "\<\"seventy\[Hyphen]eight\"\>", 
           ",", "\<\"seventy\[Hyphen]nine\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"eight\"\>", ",", "\<\"eleven\"\>", 
           ",", "\<\"eighteen\"\>", ",", "\<\"eighty\"\>", 
           ",", "\<\"eighty\[Hyphen]one\"\>", 
           ",", "\<\"eighty\[Hyphen]two\"\>", 
           ",", "\<\"eighty\[Hyphen]three\"\>", 
           ",", "\<\"eighty\[Hyphen]four\"\>", 
           ",", "\<\"eighty\[Hyphen]five\"\>", 
           ",", "\<\"eighty\[Hyphen]six\"\>", 
           ",", "\<\"eighty\[Hyphen]seven\"\>", 
           ",", "\<\"eighty\[Hyphen]eight\"\>", 
           ",", "\<\"eighty\[Hyphen]nine\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"nine\"\>", ",", "\<\"nineteen\"\>", 
           ",", "\<\"ninety\"\>", ",", "\<\"ninety\[Hyphen]one\"\>", 
           ",", "\<\"ninety\[Hyphen]two\"\>", 
           ",", "\<\"ninety\[Hyphen]three\"\>", 
           ",", "\<\"ninety\[Hyphen]four\"\>", 
           ",", "\<\"ninety\[Hyphen]five\"\>", 
           ",", "\<\"ninety\[Hyphen]six\"\>", 
           ",", "\<\"ninety\[Hyphen]seven\"\>", 
           ",", "\<\"ninety\[Hyphen]eight\"\>", 
           ",", "\<\"ninety\[Hyphen]nine\"\>"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "f074b12a-c085-4f3f-9964-3ce74f3b5080"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"\"one\"", ",", "\"one hundred\""}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"two\"", ",", "\"three\"", ",", "\"ten\"", ",", 
                 "\"twelve\"", ",", "\"thirteen\"", ",", "\"twenty\"", ",", 
                 "\"twenty\[Hyphen]one\"", ",", "\"twenty\[Hyphen]two\"", ",",
                  "\"twenty\[Hyphen]three\"", ",", "\"twenty\[Hyphen]four\"", 
                 ",", "\"twenty\[Hyphen]five\"", ",", 
                 "\"twenty\[Hyphen]six\"", ",", "\"twenty\[Hyphen]seven\"", 
                 ",", "\"twenty\[Hyphen]eight\"", ",", 
                 "\"twenty\[Hyphen]nine\"", ",", "\"thirty\"", ",", 
                 "\"thirty\[Hyphen]one\"", ",", "\"thirty\[Hyphen]two\"", ",",
                  "\"thirty\[Hyphen]three\"", ",", "\"thirty\[Hyphen]four\"", 
                 ",", "\"thirty\[Hyphen]five\"", ",", 
                 "\"thirty\[Hyphen]six\"", ",", "\"thirty\[Hyphen]seven\"", 
                 ",", "\"thirty\[Hyphen]eight\"", ",", 
                 "\"thirty\[Hyphen]nine\""}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"four\"", ",", "\"five\"", ",", "\"fourteen\"", ",", 
                 "\"fifteen\"", ",", "\"forty\"", ",", 
                 "\"forty\[Hyphen]one\"", ",", "\"forty\[Hyphen]two\"", ",", 
                 "\"forty\[Hyphen]three\"", ",", "\"forty\[Hyphen]four\"", 
                 ",", "\"forty\[Hyphen]five\"", ",", "\"forty\[Hyphen]six\"", 
                 ",", "\"forty\[Hyphen]seven\"", ",", 
                 "\"forty\[Hyphen]eight\"", ",", "\"forty\[Hyphen]nine\"", 
                 ",", "\"fifty\"", ",", "\"fifty\[Hyphen]one\"", ",", 
                 "\"fifty\[Hyphen]two\"", ",", "\"fifty\[Hyphen]three\"", ",",
                  "\"fifty\[Hyphen]four\"", ",", "\"fifty\[Hyphen]five\"", 
                 ",", "\"fifty\[Hyphen]six\"", ",", "\"fifty\[Hyphen]seven\"",
                  ",", "\"fifty\[Hyphen]eight\"", ",", 
                 "\"fifty\[Hyphen]nine\""}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"six\"", ",", "\"seven\"", ",", "\"sixteen\"", ",", 
                 "\"seventeen\"", ",", "\"sixty\"", ",", 
                 "\"sixty\[Hyphen]one\"", ",", "\"sixty\[Hyphen]two\"", ",", 
                 "\"sixty\[Hyphen]three\"", ",", "\"sixty\[Hyphen]four\"", 
                 ",", "\"sixty\[Hyphen]five\"", ",", "\"sixty\[Hyphen]six\"", 
                 ",", "\"sixty\[Hyphen]seven\"", ",", 
                 "\"sixty\[Hyphen]eight\"", ",", "\"sixty\[Hyphen]nine\"", 
                 ",", "\"seventy\"", ",", "\"seventy\[Hyphen]one\"", ",", 
                 "\"seventy\[Hyphen]two\"", ",", "\"seventy\[Hyphen]three\"", 
                 ",", "\"seventy\[Hyphen]four\"", ",", 
                 "\"seventy\[Hyphen]five\"", ",", "\"seventy\[Hyphen]six\"", 
                 ",", "\"seventy\[Hyphen]seven\"", ",", 
                 "\"seventy\[Hyphen]eight\"", ",", 
                 "\"seventy\[Hyphen]nine\""}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"eight\"", ",", "\"eleven\"", ",", "\"eighteen\"", ",", 
                 "\"eighty\"", ",", "\"eighty\[Hyphen]one\"", ",", 
                 "\"eighty\[Hyphen]two\"", ",", "\"eighty\[Hyphen]three\"", 
                 ",", "\"eighty\[Hyphen]four\"", ",", 
                 "\"eighty\[Hyphen]five\"", ",", "\"eighty\[Hyphen]six\"", 
                 ",", "\"eighty\[Hyphen]seven\"", ",", 
                 "\"eighty\[Hyphen]eight\"", ",", "\"eighty\[Hyphen]nine\""}],
                "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"nine\"", ",", "\"nineteen\"", ",", "\"ninety\"", ",", 
                 "\"ninety\[Hyphen]one\"", ",", "\"ninety\[Hyphen]two\"", ",",
                  "\"ninety\[Hyphen]three\"", ",", "\"ninety\[Hyphen]four\"", 
                 ",", "\"ninety\[Hyphen]five\"", ",", 
                 "\"ninety\[Hyphen]six\"", ",", "\"ninety\[Hyphen]seven\"", 
                 ",", "\"ninety\[Hyphen]eight\"", ",", 
                 "\"ninety\[Hyphen]nine\""}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"967ff9cb-5a34-43a4-b559-3496bc6c0003"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Sort the first 50 words in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "f15024ad-fa94-4e32-9749-8426ff70e63b"],
 " by their last letters.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a9f3ea33-78ad-4661-ba4b-615e360d71f5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\"abandoned\"\>", ",", "\<\"abashed\"\>",
          ",", "\<\"abbreviated\"\>", ",", "\<\"abed\"\>", 
         ",", "\<\"abalone\"\>", ",", "\<\"abase\"\>", ",", "\<\"abate\"\>", 
         ",", "\<\"abbe\"\>", ",", "\<\"abbreviate\"\>", 
         ",", "\<\"abdicate\"\>", ",", "\<\"abeyance\"\>", 
         ",", "\<\"abhorrence\"\>", ",", "\<\"abidance\"\>", 
         ",", "\<\"abide\"\>", ",", "\<\"abducting\"\>", 
         ",", "\<\"abiding\"\>", ",", "\<\"aah\"\>", ",", "\<\"abash\"\>", 
         ",", "\<\"aardvark\"\>", ",", "\<\"aback\"\>", 
         ",", "\<\"abdominal\"\>", ",", "\<\"abeam\"\>", 
         ",", "\<\"abandon\"\>", ",", "\<\"abbreviation\"\>", 
         ",", "\<\"abdication\"\>", ",", "\<\"abdomen\"\>", 
         ",", "\<\"abduction\"\>", ",", "\<\"aberration\"\>", 
         ",", "\<\"abjection\"\>", ",", "\<\"abattoir\"\>", 
         ",", "\<\"abductor\"\>", ",", "\<\"abettor\"\>", 
         ",", "\<\"abhor\"\>", ",", "\<\"abacus\"\>", ",", "\<\"abbess\"\>", 
         ",", "\<\"abaft\"\>", ",", "\<\"abandonment\"\>", 
         ",", "\<\"abasement\"\>", ",", "\<\"abashment\"\>", 
         ",", "\<\"abatement\"\>", ",", "\<\"abbot\"\>", 
         ",", "\<\"abduct\"\>", ",", "\<\"aberrant\"\>", ",", "\<\"abet\"\>", 
         ",", "\<\"abhorrent\"\>", ",", "\<\"abject\"\>", 
         ",", "\<\"abbey\"\>", ",", "\<\"ability\"\>", 
         ",", "\<\"abjectly\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "e6da626a-c7fe-40be-af27-fd0425715a89"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"a\"", ",", "\"abandoned\"", ",", "\"abashed\"", ",", 
             "\"abbreviated\"", ",", "\"abed\"", ",", "\"abalone\"", ",", 
             "\"abase\"", ",", "\"abate\"", ",", "\"abbe\"", ",", 
             "\"abbreviate\"", ",", "\"abdicate\"", ",", "\"abeyance\"", ",", 
             "\"abhorrence\"", ",", "\"abidance\"", ",", "\"abide\"", ",", 
             "\"abducting\"", ",", "\"abiding\"", ",", "\"aah\"", ",", 
             "\"abash\"", ",", "\"aardvark\"", ",", "\"aback\"", ",", 
             "\"abdominal\"", ",", "\"abeam\"", ",", "\"abandon\"", ",", 
             "\"abbreviation\"", ",", "\"abdication\"", ",", "\"abdomen\"", 
             ",", "\"abduction\"", ",", "\"aberration\"", ",", 
             "\"abjection\"", ",", "\"abattoir\"", ",", "\"abductor\"", ",", 
             "\"abettor\"", ",", "\"abhor\"", ",", "\"abacus\"", ",", 
             "\"abbess\"", ",", "\"abaft\"", ",", "\"abandonment\"", ",", 
             "\"abasement\"", ",", "\"abashment\"", ",", "\"abatement\"", ",",
              "\"abbot\"", ",", "\"abduct\"", ",", "\"aberrant\"", ",", 
             "\"abet\"", ",", "\"abhorrent\"", ",", "\"abject\"", ",", 
             "\"abbey\"", ",", "\"ability\"", ",", "\"abjectly\""}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"956dbf10-2a5c-4e77-be02-e58d4a320034"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 20 squares, sorted by their first digits.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f5f1f9a2-0d83-4600-bb16-00294987b5b1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "16", ",", "100", ",", "121", ",", "144", ",", "169", ",", 
         "196", ",", "25", ",", "225", ",", "256", ",", "289", ",", "36", ",",
          "324", ",", "361", ",", "4", ",", "49", ",", "400", ",", "64", ",", 
         "81", ",", "9"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "9a0b4ad9-d968-4353-80ff-4adc3ade6172"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "16", ",", "100", ",", "121", ",", "144", ",", 
             "169", ",", "196", ",", "25", ",", "225", ",", "256", ",", "289",
              ",", "36", ",", "324", ",", "361", ",", "4", ",", "49", ",", 
             "400", ",", "64", ",", "81", ",", "9"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"51cb7e5b-a0d4-4c31-9c4c-3a47094fccca"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Sort integers up to 20 by the length of their names in English.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"73b50c6b-1ca3-4b3a-af9c-6dbc5b8f78a7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "6", ",", "10", ",", "4", ",", "5", ",", "9", ",",
          "3", ",", "7", ",", "8", ",", "11", ",", "12", ",", "20", ",", "15",
          ",", "16", ",", "13", ",", "14", ",", "18", ",", "19", ",", "17"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "f5a8492f-e062-4e31-9367-12fb4b9fa5a5"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "2", ",", "6", ",", "10", ",", "4", ",", "5", 
             ",", "9", ",", "3", ",", "7", ",", "8", ",", "11", ",", "12", 
             ",", "20", ",", "15", ",", "16", ",", "13", ",", "14", ",", "18",
              ",", "19", ",", "17"}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5b32196e-80cc-499b-8c40-6161f3d62f1c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Get a random sample of 20 words from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "ceae431a-ab18-43f7-a3c6-be21302f10a0"],
 ", and gather them into sublists by length.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"eb6ea61c-7671-4f1e-8776-6a4f2350c866"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "\<\"paste\"\>", "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"mistakenly\"\>", ",", "\<\"unintended\"\>", 
           ",", "\<\"victorious\"\>", ",", "\<\"watercress\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"powerful\"\>", ",", "\<\"jingoist\"\>", 
           ",", "\<\"ballpark\"\>", ",", "\<\"rapeseed\"\>", 
           ",", "\<\"dyslexia\"\>"}], "}"}], ",", 
         RowBox[{"{", "\<\"repeal\"\>", "}"}], ",", 
         RowBox[{"{", "\<\"paleontological\"\>", "}"}], ",", 
         RowBox[{"{", "\<\"encouragement\"\>", "}"}], ",", 
         RowBox[{"{", "\<\"countryside\"\>", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"selfish\"\>", ",", "\<\"hedging\"\>"}], "}"}], ",", 
         RowBox[{"{", "\<\"barometer\"\>", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"veil\"\>", ",", "\<\"well\"\>"}], "}"}], ",", 
         RowBox[{"{", "\<\"municipality\"\>", "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "fd1c2d3b-3544-425b-8629-dc3d50a83582"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", "\"paste\"", "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"mistakenly\"", ",", "\"unintended\"", ",", 
                 "\"victorious\"", ",", "\"watercress\""}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"powerful\"", ",", "\"jingoist\"", ",", "\"ballpark\"", ",",
                  "\"rapeseed\"", ",", "\"dyslexia\""}], "}"}], ",", 
             RowBox[{"{", "\"repeal\"", "}"}], ",", 
             RowBox[{"{", "\"paleontological\"", "}"}], ",", 
             RowBox[{"{", "\"encouragement\"", "}"}], ",", 
             RowBox[{"{", "\"countryside\"", "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"selfish\"", ",", "\"hedging\""}], "}"}], ",", 
             RowBox[{"{", "\"barometer\"", "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"veil\"", ",", "\"well\""}], "}"}], ",", 
             RowBox[{"{", "\"municipality\"", "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aeaae73a-fc82-47d6-bb54-7a41826f8016"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find letters that appear in Ukrainian but not Russian.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a6025856-766c-4815-83a6-cd4d7351159e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"\:0454\"\>", ",", "\<\"\:0456\"\>", 
         ",", "\<\"\:0457\"\>", ",", "\<\"\:0491\"\>"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "2eef5d46-d1e6-40b2-b427-d6ad1126f6a1"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"\:0454\"", ",", "\"\:0456\"", ",", "\"\:0457\"", ",", 
             "\"\:0491\""}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"958851df-ae9d-4c31-b6f2-d7ba0b99a2bc"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Intersection",
  BaseStyle->"Link"],
 " to find numbers that appear both among the first 100 squares and cubes.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e4e811c8-dee9-40f4-a22b-ae2e4a1b18c4"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1", ",", "64", ",", "729", ",", "4096"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "de2c6313-decc-4108-a198-c1b5bc975415"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"1", ",", "64", ",", "729", ",", "4096"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8c393eea-2bda-4926-bff2-c0fdfd755964"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the list of countries that are in both NATO and the G8.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.16", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"6a712fea-caf9-4f81-99fe-712410845d63"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TemplateBox[{"\"Canada\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"Canada\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"Canada\\\"]\"", "\"country\""},
          "Entity"], ",", 
         TemplateBox[{"\"France\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"France\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"France\\\"]\"", "\"country\""},
          "Entity"], ",", 
         TemplateBox[{"\"Germany\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"Germany\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"Germany\\\"]\"", "\"country\""},
          "Entity"], ",", 
         TemplateBox[{"\"Italy\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"Italy\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"Italy\\\"]\"", "\"country\""},
          "Entity"], ",", 
         TemplateBox[{"\"United Kingdom\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"UnitedKingdom\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"UnitedKingdom\\\"]\"", 
           "\"country\""},
          "Entity"], ",", 
         TemplateBox[{"\"United States\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"UnitedStates\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"UnitedStates\\\"]\"", "\"country\""},
          "Entity"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "e5d47695-8ab7-4674-9e5e-727f117b8d67"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             TemplateBox[{"\"Canada\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"Canada\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"Canada\\\"]\"", "\"country\""}, 
              "Entity"], ",", 
             TemplateBox[{"\"France\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"France\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"France\\\"]\"", "\"country\""}, 
              "Entity"], ",", 
             TemplateBox[{"\"Germany\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"Germany\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"Germany\\\"]\"", "\"country\""},
               "Entity"], ",", 
             TemplateBox[{"\"Italy\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"Italy\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"Italy\\\"]\"", "\"country\""}, 
              "Entity"], ",", 
             TemplateBox[{"\"United Kingdom\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"UnitedKingdom\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"UnitedKingdom\\\"]\"", 
               "\"country\""}, "Entity"], ",", 
             TemplateBox[{"\"United States\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"UnitedStates\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"UnitedStates\\\"]\"", 
               "\"country\""}, "Entity"]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"455d660a-6355-4947-b4c0-fd63b47ceae2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a grid in which all possible permutations of the numbers 1 through 4 \
appear as successive columns.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.17", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2b01a72d-a9f1-497f-88fd-439b92ad4846"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"1", "1", "1", "1", "1", "1", "2", "2", "2", "2", "2", "2", "3", 
           "3", "3", "3", "3", "3", "4", "4", "4", "4", "4", "4"},
          {"2", "2", "3", "3", "4", "4", "1", "1", "3", "3", "4", "4", "1", 
           "1", "2", "2", "4", "4", "1", "1", "2", "2", "3", "3"},
          {"3", "4", "2", "4", "2", "3", "3", "4", "1", "4", "1", "3", "2", 
           "4", "1", "4", "1", "2", "2", "3", "1", "3", "1", "2"},
          {"4", "3", "4", "2", "3", "2", "4", "3", "4", "1", "3", "1", "4", 
           "2", "4", "1", "2", "1", "3", "2", "3", "1", "2", "1"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "b9c4d7e1-2a9c-4319-bfd9-9cdbc0637ea8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "1", "1", "1", "1", "1", "1", "2", "2", "2", "2", "2", "2", "3", 
             "3", "3", "3", "3", "3", "4", "4", "4", "4", "4", "4"}, {
            "2", "2", "3", "3", "4", "4", "1", "1", "3", "3", "4", "4", "1", 
             "1", "2", "2", "4", "4", "1", "1", "2", "2", "3", "3"}, {
            "3", "4", "2", "4", "2", "3", "3", "4", "1", "4", "1", "3", "2", 
             "4", "1", "4", "1", "2", "2", "3", "1", "3", "1", "2"}, {
            "4", "3", "4", "2", "3", "2", "4", "3", "4", "1", "3", "1", "4", 
             "2", "4", "1", "2", "1", "3", "2", "3", "1", "2", "1"}}, 
           AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bf6fd317-fbdd-4854-8945-99edc1dd5519"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of all the different strings that can be obtained by permuting \
the characters in \[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.18", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ef34e87b-218a-425d-a9bb-072a41de2091"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"ehllo\"\>", ",", "\<\"ehlol\"\>", ",", "\<\"eholl\"\>", 
         ",", "\<\"elhlo\"\>", ",", "\<\"elhol\"\>", ",", "\<\"ellho\"\>", 
         ",", "\<\"elloh\"\>", ",", "\<\"elohl\"\>", ",", "\<\"elolh\"\>", 
         ",", "\<\"eohll\"\>", ",", "\<\"eolhl\"\>", ",", "\<\"eollh\"\>", 
         ",", "\<\"hello\"\>", ",", "\<\"helol\"\>", ",", "\<\"heoll\"\>", 
         ",", "\<\"hlelo\"\>", ",", "\<\"hleol\"\>", ",", "\<\"hlleo\"\>", 
         ",", "\<\"hlloe\"\>", ",", "\<\"hloel\"\>", ",", "\<\"hlole\"\>", 
         ",", "\<\"hoell\"\>", ",", "\<\"holel\"\>", ",", "\<\"holle\"\>", 
         ",", "\<\"lehlo\"\>", ",", "\<\"lehol\"\>", ",", "\<\"lelho\"\>", 
         ",", "\<\"leloh\"\>", ",", "\<\"leohl\"\>", ",", "\<\"leolh\"\>", 
         ",", "\<\"lhelo\"\>", ",", "\<\"lheol\"\>", ",", "\<\"lhleo\"\>", 
         ",", "\<\"lhloe\"\>", ",", "\<\"lhoel\"\>", ",", "\<\"lhole\"\>", 
         ",", "\<\"lleho\"\>", ",", "\<\"lleoh\"\>", ",", "\<\"llheo\"\>", 
         ",", "\<\"llhoe\"\>", ",", "\<\"lloeh\"\>", ",", "\<\"llohe\"\>", 
         ",", "\<\"loehl\"\>", ",", "\<\"loelh\"\>", ",", "\<\"lohel\"\>", 
         ",", "\<\"lohle\"\>", ",", "\<\"loleh\"\>", ",", "\<\"lolhe\"\>", 
         ",", "\<\"oehll\"\>", ",", "\<\"oelhl\"\>", ",", "\<\"oellh\"\>", 
         ",", "\<\"ohell\"\>", ",", "\<\"ohlel\"\>", ",", "\<\"ohlle\"\>", 
         ",", "\<\"olehl\"\>", ",", "\<\"olelh\"\>", ",", "\<\"olhel\"\>", 
         ",", "\<\"olhle\"\>", ",", "\<\"olleh\"\>", ",", "\<\"ollhe\"\>"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "9d39c347-4222-45dc-b8dd-8e77744e1d5f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"ehllo\"", ",", "\"ehlol\"", ",", "\"eholl\"", ",", 
             "\"elhlo\"", ",", "\"elhol\"", ",", "\"ellho\"", ",", 
             "\"elloh\"", ",", "\"elohl\"", ",", "\"elolh\"", ",", 
             "\"eohll\"", ",", "\"eolhl\"", ",", "\"eollh\"", ",", 
             "\"hello\"", ",", "\"helol\"", ",", "\"heoll\"", ",", 
             "\"hlelo\"", ",", "\"hleol\"", ",", "\"hlleo\"", ",", 
             "\"hlloe\"", ",", "\"hloel\"", ",", "\"hlole\"", ",", 
             "\"hoell\"", ",", "\"holel\"", ",", "\"holle\"", ",", 
             "\"lehlo\"", ",", "\"lehol\"", ",", "\"lelho\"", ",", 
             "\"leloh\"", ",", "\"leohl\"", ",", "\"leolh\"", ",", 
             "\"lhelo\"", ",", "\"lheol\"", ",", "\"lhleo\"", ",", 
             "\"lhloe\"", ",", "\"lhoel\"", ",", "\"lhole\"", ",", 
             "\"lleho\"", ",", "\"lleoh\"", ",", "\"llheo\"", ",", 
             "\"llhoe\"", ",", "\"lloeh\"", ",", "\"llohe\"", ",", 
             "\"loehl\"", ",", "\"loelh\"", ",", "\"lohel\"", ",", 
             "\"lohle\"", ",", "\"loleh\"", ",", "\"lolhe\"", ",", 
             "\"oehll\"", ",", "\"oelhl\"", ",", "\"oellh\"", ",", 
             "\"ohell\"", ",", "\"ohlel\"", ",", "\"ohlle\"", ",", 
             "\"olehl\"", ",", "\"olelh\"", ",", "\"olhel\"", ",", 
             "\"olhle\"", ",", "\"olleh\"", ",", "\"ollhe\""}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"010a8e60-15db-45eb-b59c-086bbcdb408a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an array plot of the sequence of possible 5-tuples of 0 and 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.19", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ce24c51d-6ae5-4342-89d9-85550a17ec6c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        RasterBox[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 1, 0}, {0, 0, 
         0, 1, 1}, {0, 0, 1, 0, 0}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 0, 
         1, 1, 1}, {0, 1, 0, 0, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 
         0, 1, 1}, {0, 1, 1, 0, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 1, 0}, {0, 1, 
         1, 1, 1}, {1, 0, 0, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 
         0, 1, 1}, {1, 0, 1, 0, 0}, {1, 0, 1, 0, 1}, {1, 0, 1, 1, 0}, {1, 0, 
         1, 1, 1}, {1, 1, 0, 0, 0}, {1, 1, 0, 0, 1}, {1, 1, 0, 1, 0}, {1, 1, 
         0, 1, 1}, {1, 1, 1, 0, 0}, {1, 1, 1, 0, 1}, {1, 1, 1, 1, 0}, {1, 1, 
         1, 1, 1}}, {{0, 0}, {5, 32}}, {0, 1}],
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{72.41796875, Automatic},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "5aafae28-7ee8-463c-abe7-675defc21d88"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          
          RasterBox[{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 1, 0}, {0, 0,
            0, 1, 1}, {0, 0, 1, 0, 0}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 
           0, 1, 1, 1}, {0, 1, 0, 0, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0,
            1, 0, 1, 1}, {0, 1, 1, 0, 0}, {0, 1, 1, 0, 1}, {0, 1, 1, 1, 0}, {
           0, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 
           0}, {1, 0, 0, 1, 1}, {1, 0, 1, 0, 0}, {1, 0, 1, 0, 1}, {1, 0, 1, 1,
            0}, {1, 0, 1, 1, 1}, {1, 1, 0, 0, 0}, {1, 1, 0, 0, 1}, {1, 1, 0, 
           1, 0}, {1, 1, 0, 1, 1}, {1, 1, 1, 0, 0}, {1, 1, 1, 0, 1}, {1, 1, 1,
            1, 0}, {1, 1, 1, 1, 1}}, {{0, 0}, {5, 32}}, {0, 1}], Frame -> 
          Automatic, FrameLabel -> {None, None}, 
          FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {72.41796875, Automatic}, 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a0002aef-b7aa-47f2-b996-cdb5658ebdd1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a list of 10 random sequences of 5 letters.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.20", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c6545981-c28a-412d-b630-f17a5b53fddf"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"ayasl\"\>", ",", "\<\"icnry\"\>", ",", "\<\"ahbaa\"\>", 
         ",", "\<\"jqkpc\"\>", ",", "\<\"orlaf\"\>", ",", "\<\"rmexo\"\>", 
         ",", "\<\"ngrfy\"\>", ",", "\<\"vwhii\"\>", ",", "\<\"wjiqn\"\>", 
         ",", "\<\"gngvk\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "b52ea4c6-06ba-426a-aa2a-2a609a32a845"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"ayasl\"", ",", "\"icnry\"", ",", "\"ahbaa\"", ",", 
             "\"jqkpc\"", ",", "\"orlaf\"", ",", "\"rmexo\"", ",", 
             "\"ngrfy\"", ",", "\"vwhii\"", ",", "\"wjiqn\"", ",", 
             "\"gngvk\""}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"16f2231e-4cad-4aa3-a91e-57c5410b4bc4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "j", ",", "k"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "2"}], "}"}]}], "]"}], ",", "2"}], "]"}]], 
  "InlineCode",ExpressionUUID->"9b8a6fe4-4a00-48f1-a176-0d658aef82b4"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.21", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"9138ee94-0d26-4d58-b19f-f002774fb9be"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "2a12e3bf-3f8c-4088-95af-1471726bf413"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2b1790ce-f529-40ca-8299-e1d33491ac80"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an array plot from the numbers of the letters in the first 1000 \
characters in the Wikipedia article on \[OpenCurlyDoubleQuote]computers\
\[CloseCurlyDoubleQuote], with 30 letters per row.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e85e4837-b682-412f-8ca1-f688a51ed011"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[RasterBox[CompressedData["
1:eJxlklGO2zAMROONRbEipYKxKS1RoECv1CPsBXr/vw6NbBZoP+TEljh8M9Sv
jz+/P95ut9sPrJ9YEtZNj1kYT3pYJetODz+NK/kKMtFay3pEXTFWGfiCg8LN
Z/V5Ctfmy2LYzWe3YRS8RWsDMihSQ1VoDDmW9FbIud6dvUjPnZckmpjehce8
B5txgbYpODp+fY/hHOgVlVhUj2vrQlyuVNBRZ8pCyv9tV0FEPsHkKZ12Yse7
TnZiiIP7E5VRWqXwcmyjBXstg+SUhv7E/SIlefdX6cnSQ/2NPLdwzBrKYkzf
bXmNMeRuesrTIgQb/jhJRYbpEa56yChqtEKT48j8hafzs3H2znIwRfVvxXVh
BnhbgGFQAwXU8Gn0wPRgRCcisCWNu5zdu/AG0cYCJmAcPpCsEoH06+PF0AqK
q3RH7/+Oby2nNrZA7Hg8I15prVKVM2g4ZiTqivXddMoJlXeU49AOCfiAABQz
3pdAaJWxJya8IwX/jDxtYzcDj2ljQz7PLApJjuPCASImdkVDkeGeX1HgTmUS
uBIQXClPlyCwDo6O+0WSEW5SXoasxuGaY2yFm+AuYpp/AffXL94=
         "], {{0, 0}, {
         30, 27}}, {0, 26}],
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "2dc81ca4-212a-4bb3-8d70-0a9b947a6dcb"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          RasterBox[CompressedData["
1:eJxlklGO2zAMROONRbEipYKxKS1RoECv1CPsBXr/vw6NbBZoP+TEljh8M9Sv
jz+/P95ut9sPrJ9YEtZNj1kYT3pYJetODz+NK/kKMtFay3pEXTFWGfiCg8LN
Z/V5Ctfmy2LYzWe3YRS8RWsDMihSQ1VoDDmW9FbIud6dvUjPnZckmpjehce8
B5txgbYpODp+fY/hHOgVlVhUj2vrQlyuVNBRZ8pCyv9tV0FEPsHkKZ12Yse7
TnZiiIP7E5VRWqXwcmyjBXstg+SUhv7E/SIlefdX6cnSQ/2NPLdwzBrKYkzf
bXmNMeRuesrTIgQb/jhJRYbpEa56yChqtEKT48j8hafzs3H2znIwRfVvxXVh
BnhbgGFQAwXU8Gn0wPRgRCcisCWNu5zdu/AG0cYCJmAcPpCsEoH06+PF0AqK
q3RH7/+Oby2nNrZA7Hg8I15prVKVM2g4ZiTqivXddMoJlXeU49AOCfiAABQz
3pdAaJWxJya8IwX/jDxtYzcDj2ljQz7PLApJjuPCASImdkVDkeGeX1HgTmUS
uBIQXClPlyCwDo6O+0WSEW5SXoasxuGaY2yFm+AuYpp/AffXL94=
           "], {{0, 0}, {
           30, 27}}, {0, 26}], Frame -> Automatic, FrameLabel -> {None, None},
           FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d376550e-e820-4f93-825f-645b29128f96"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Gather integers up to 30 into lists based on their values modulo 3.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"15e59e5f-f56b-4cfa-b2ca-a8550aaa72a1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1", ",", "4", ",", "7", ",", "10", ",", "13", ",", "16", ",", "19",
            ",", "22", ",", "25", ",", "28"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "2", ",", "5", ",", "8", ",", "11", ",", "14", ",", "17", ",", "20",
            ",", "23", ",", "26", ",", "29"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "3", ",", "6", ",", "9", ",", "12", ",", "15", ",", "18", ",", "21",
            ",", "24", ",", "27", ",", "30"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "d57fbad2-e9eb-4b07-8260-7ef0333a6c40"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               
               RowBox[{
                "1", ",", "4", ",", "7", ",", "10", ",", "13", ",", "16", ",",
                  "19", ",", "22", ",", "25", ",", "28"}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "2", ",", "5", ",", "8", ",", "11", ",", "14", ",", "17", ",",
                  "20", ",", "23", ",", "26", ",", "29"}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "3", ",", "6", ",", "9", ",", "12", ",", "15", ",", "18", ",",
                  "21", ",", "24", ",", "27", ",", "30"}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e2a56ea7-5317-4770-bcd1-2cb0a6a608a4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Gather the first 50 powers of 2 according to their last digits.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"26b89093-7a7b-4913-a82c-4da8933f4152"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "2", ",", "32", ",", "512", ",", "8192", ",", "131072", ",", 
           "2097152", ",", "33554432", ",", "536870912", ",", "8589934592", 
           ",", "137438953472", ",", "2199023255552", ",", "35184372088832", 
           ",", "562949953421312"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "4", ",", "64", ",", "1024", ",", "16384", ",", "262144", ",", 
           "4194304", ",", "67108864", ",", "1073741824", ",", "17179869184", 
           ",", "274877906944", ",", "4398046511104", ",", "70368744177664", 
           ",", "1125899906842624"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "8", ",", "128", ",", "2048", ",", "32768", ",", "524288", ",", 
           "8388608", ",", "134217728", ",", "2147483648", ",", "34359738368",
            ",", "549755813888", ",", "8796093022208", ",", 
           "140737488355328"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "16", ",", "256", ",", "4096", ",", "65536", ",", "1048576", ",", 
           "16777216", ",", "268435456", ",", "4294967296", ",", 
           "68719476736", ",", "1099511627776", ",", "17592186044416", ",", 
           "281474976710656"}], "}"}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"4950180a-26aa-42fa-b980-9729414f4d01"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               
               RowBox[{
                "2", ",", "32", ",", "512", ",", "8192", ",", "131072", ",", 
                 "2097152", ",", "33554432", ",", "536870912", ",", 
                 "8589934592", ",", "137438953472", ",", "2199023255552", ",",
                  "35184372088832", ",", "562949953421312"}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "4", ",", "64", ",", "1024", ",", "16384", ",", "262144", ",",
                  "4194304", ",", "67108864", ",", "1073741824", ",", 
                 "17179869184", ",", "274877906944", ",", "4398046511104", 
                 ",", "70368744177664", ",", "1125899906842624"}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "8", ",", "128", ",", "2048", ",", "32768", ",", "524288", 
                 ",", "8388608", ",", "134217728", ",", "2147483648", ",", 
                 "34359738368", ",", "549755813888", ",", "8796093022208", 
                 ",", "140737488355328"}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "16", ",", "256", ",", "4096", ",", "65536", ",", "1048576", 
                 ",", "16777216", ",", "268435456", ",", "4294967296", ",", 
                 "68719476736", ",", "1099511627776", ",", "17592186044416", 
                 ",", "281474976710656"}], "}"}]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b20d8d9c-35f5-4393-b027-002c52b713e2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the result of sorting the numbers from \[Minus]10 to \
+10 by their absolute values.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"966e34c2-00b0-4065-9401-8cb506bd9630"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.019444444444444445`], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7BlQgQNUfD+E5nBAVScA5TMcgFAiMD6UloDS
HFB5GRgfSitAaQGovBKMD6VVoLQIVF4NxofSGjB7oPJaaPbqQGkZqLwejA+l
DWDugMobornLCEorQeWNYXwobQJzJ1TeFO5uAFL6GCM=
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 21.}, {-10., 10.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.05], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "13037c8a-1943-4e68-8c1d-6fd28128d6a8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.019444444444444445`], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7BlQgQNUfD+E5nBAVScA5TMcgFAiMD6UloDS
HFB5GRgfSitAaQGovBKMD6VVoLQIVF4NxofSGjB7oPJaaPbqQGkZqLwejA+l
DWDugMobornLCEorQeWNYXwobQJzJ1TeFO5uAFL6GCM=
               "]]}}}, {}}, 
          AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {True, True}, AxesLabel -> {None, None}, 
          AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
          Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 21.}, {-10., 10.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.05], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4625776f-e146-42f0-8346-6346cdc468ef"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the list of the first 200 squares, sorted by their \
first digits.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5fe53764-7308-46b5-aa9a-d3ef39f79a10"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxd1luMnHMcxvFfNnuxl5PlQsTFq5k0KhupVYet0r8xatShtapoi9mxdYrE
IdJEJPKrU95K08w6VBfh3bWo0sMWVZS+nS4GRZc6Vw3mQhMX7brRG0Gf7/+C
Jpsnn3nmmV8mafLOibXb+5d3mFnzn79/U/8Ozf1vWlDMJLvIa8iCMlyHjyVr
5HHKZDk+Qek344Ssk9OUnUO4qCw8iqcri4/hk7j/OD5ZOfgE7lHW1+JTlBNP
/u97DZOnKstP4V72T+PTlO1n8CzuP4tPV6a78RlH03+PPlPZP4HPUr89uk+Z
vI9nq0+jz1ZORc9Rv+wDfI6yGX2u+lkf4rnK0eigvtCUPZDYzlN/KPay1T6i
L6nfh122ysf056vfgV223k/oy+rXY5ct2UN/gfp12GXr/pR+nvrV2GXr+oz+
QvUPYpet43P6inrHXuH1veRFRzME7LKtjP189Y3Yy9Y5SX+x+nnYZVsV+0vU
74m9bIUv6C9Vvwi7bMOxv0z9gdjLVvySfoH6W7Ev4HX+n9lCZXKbMmC7g/fj
wl3KHI89x/suV6YZe1waYY9tlD1uYOtn/zx73D/GHicvsMdT2K5QNl9kj8fj
95XDnzinD/vYL1Kf4iDbJHb6479iTz+I7Ur1m3CQ7Qh2+vLX7Onr2Bar34+D
bDO+YU+/Auf0E9iuUt/9LXvZBrDTb8E5vX1HXq1+IQ6yjWCnn8I5ffl79noO
hLU48Fw4iJ1+zg/s6evYlqhv4yBb33729GtwTt/GtlT97B/ZL+X1Ensc7maP
6yt43zLl6Eu8D/t6EtdeZo8rG9hfq+x9hT1OXmWPuzeyx12b2PPc7NjMHg/x
fVwOv+GcPhxgf736dTjIdhg7/fyf2NOPYauq/wsnsve0+Dw5WYKrsqXY6bfh
jH0b5/TH/Cy32JewDai/EyeyZzjQ78XVAXa/cJ9+Js7YV3FOP4Rb7BuY3ynJ
HziRvfgr9+kX42qNHb97HMfnRhb7e7iP6/dyH4f7eN8N5Bbu45U44M5x7uNV
2HFhK/fxMM5x8TXu45TvY4PYuY/tfu7jcfZVHF7nPp7EGR58g/v4CG7h+jbu
8Ltwxpvcj78Tec4EnD7AfZw8xH08wT7DA9u5Hz/vLe7jEWw3Kstv87n4IA64
+TD3sackrr/Dfdy3g/u4jVt46F3u38Sd97iPD+MQe547VVx5hPt4bCf3Ze/J
uU+f4hZ9Gxu/w0u7uB9/l0/jLk5Wcx93reG+7Bn7LO4b3Kev4hZ9A9st6ou7
w9/sq93O
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{337.6328125, Automatic},
        Method->{},
        PlotRange->{{0., 200.}, {0, 40000.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "f18fbab3-b8bf-4c49-b966-dccdc5297430"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxd1luMnHMcxvFfNnuxl5PlQsTFq5k0KhupVYet0r8xatShtapoi9mxdYrE
IdJEJPKrU95K08w6VBfh3bWo0sMWVZS+nS4GRZc6Vw3mQhMX7brRG0Gf7/+C
Jpsnn3nmmV8mafLOibXb+5d3mFnzn79/U/8Ozf1vWlDMJLvIa8iCMlyHjyVr
5HHKZDk+Qek344Ssk9OUnUO4qCw8iqcri4/hk7j/OD5ZOfgE7lHW1+JTlBNP
/u97DZOnKstP4V72T+PTlO1n8CzuP4tPV6a78RlH03+PPlPZP4HPUr89uk+Z
vI9nq0+jz1ZORc9Rv+wDfI6yGX2u+lkf4rnK0eigvtCUPZDYzlN/KPay1T6i
L6nfh122ysf056vfgV223k/oy+rXY5ct2UN/gfp12GXr/pR+nvrV2GXr+oz+
QvUPYpet43P6inrHXuH1veRFRzME7LKtjP189Y3Yy9Y5SX+x+nnYZVsV+0vU
74m9bIUv6C9Vvwi7bMOxv0z9gdjLVvySfoH6W7Ev4HX+n9lCZXKbMmC7g/fj
wl3KHI89x/suV6YZe1waYY9tlD1uYOtn/zx73D/GHicvsMdT2K5QNl9kj8fj
95XDnzinD/vYL1Kf4iDbJHb6479iTz+I7Ur1m3CQ7Qh2+vLX7Onr2Bar34+D
bDO+YU+/Auf0E9iuUt/9LXvZBrDTb8E5vX1HXq1+IQ6yjWCnn8I5ffl79noO
hLU48Fw4iJ1+zg/s6evYlqhv4yBb33729GtwTt/GtlT97B/ZL+X1Ensc7maP
6yt43zLl6Eu8D/t6EtdeZo8rG9hfq+x9hT1OXmWPuzeyx12b2PPc7NjMHg/x
fVwOv+GcPhxgf736dTjIdhg7/fyf2NOPYauq/wsnsve0+Dw5WYKrsqXY6bfh
jH0b5/TH/Cy32JewDai/EyeyZzjQ78XVAXa/cJ9+Js7YV3FOP4Rb7BuY3ynJ
HziRvfgr9+kX42qNHb97HMfnRhb7e7iP6/dyH4f7eN8N5Bbu45U44M5x7uNV
2HFhK/fxMM5x8TXu45TvY4PYuY/tfu7jcfZVHF7nPp7EGR58g/v4CG7h+jbu
8Ltwxpvcj78Tec4EnD7AfZw8xH08wT7DA9u5Hz/vLe7jEWw3Kstv87n4IA64
+TD3sackrr/Dfdy3g/u4jVt46F3u38Sd97iPD+MQe547VVx5hPt4bCf3Ze/J
uU+f4hZ9Gxu/w0u7uB9/l0/jLk5Wcx93reG+7Bn7LO4b3Kev4hZ9A9st6ou7
w9/sq93O
               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {337.6328125, Automatic}, 
          Method -> {}, PlotRange -> {{0., 200.}, {0, 40000.}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a9e75997-e8b2-45b6-a673-8f4544193d5f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of integers up to 200 sorted by the lengths of their names \
in English.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"272b1f78-50b1-49ec-89a9-bbca6e2d99e5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdlctOFUEQhjuuXLpwwcLFSIgxxhjvd6W93y+gCIjCcPAcceUr9KPMo/TS
x5hH8BHE8H2TVJOQP39NVVfVX1VwdvZ7fX4ipfTn6Pc/Hv/8XY2YcsST4BJ4
ClwBTzf2pcZ+BlwGu+bd5cZvpfE7Bz4Fz4OvwAvge/BiE3epibsMXgevgA/B
q+Bn8Noxli9NnO/eaN69if8a/FZT5+2mzjtN3rsxb7rX1Hmf99XjAfis6eMF
uIq/emXwNXb5W/ARdvQs8PQBfIz9IwifdHgCqoPcvqzbuuTWYR/mkT+PWFp8
yXf7foMdXuAJv/KuiaMf9yrbn9x5oltmP4o6ui/m3Yh5q/ujzpt8l2+B1OWe
WOe0J+45c3dOqZmTcyty52Bf6Dr1qU7qgC7V7/SZ1mLdky7q6Xfy1rX4TlqP
7+T16FfWo1+Vf2oQfTM8q7ccvSu8oLd3XeHOsaL/NMdt7PJfMa93bV7v1Ll7
p9W63G/q8m6s07vx74w6uDeTDpuxryx3H+UbsU/zumfG5a2IpUF1cU7qMukO
V/eyHe11O9rTVziY5TvRrl9t/BJ+ucEpz06MqzsxLn3Db594eJ1hh6cf2P1u
/Pf4TpbvEg/PPXHwsoh+9Sd+cuvajXkqPM+x78W6816su8iN34t1pD7W3cEH
9bBueK//jHfhI3yApwPi4AU+wjv0TOaBd/AKz36n7x6uLs7NPoemTuue6tyP
edMsYtegfQ5gr51+ivaD6DfaP7zQz6ST/ePXMc/OdxYxT13EPJl9mXSFD/B0
SJx1Hsa63Bv32r1xLu6Bc3GOvX04V7hzsa+xmaO6jXB1S03f6mAf7rl99PNY
R5nHdwfvwrh5jBvnMS4tInZy71E7vIcP6u+c0Ne59eoPH9Uf7h2bx7s0z3SX
zlX94d5JsU719z37h9v32PSRmrq6w5jHvsxjX/q5V0ODtUHnog6TzvwfPdL5
Hx4BaDU=
            "]]}}, {}, {}, {{}, {}}, {{}, {}}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0., 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotRange->{{0., 200.}, {0, 200.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "86bd70b2-9391-44ed-98d3-e39626feadee"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{{}, {}, {{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.01388888888888889], 
                AbsoluteThickness[1.6], 
                LineBox[CompressedData["
1:eJxdlctOFUEQhjuuXLpwwcLFSIgxxhjvd6W93y+gCIjCcPAcceUr9KPMo/TS
x5hH8BHE8H2TVJOQP39NVVfVX1VwdvZ7fX4ipfTn6Pc/Hv/8XY2YcsST4BJ4
ClwBTzf2pcZ+BlwGu+bd5cZvpfE7Bz4Fz4OvwAvge/BiE3epibsMXgevgA/B
q+Bn8Noxli9NnO/eaN69if8a/FZT5+2mzjtN3rsxb7rX1Hmf99XjAfis6eMF
uIq/emXwNXb5W/ARdvQs8PQBfIz9IwifdHgCqoPcvqzbuuTWYR/mkT+PWFp8
yXf7foMdXuAJv/KuiaMf9yrbn9x5oltmP4o6ui/m3Yh5q/ujzpt8l2+B1OWe
WOe0J+45c3dOqZmTcyty52Bf6Dr1qU7qgC7V7/SZ1mLdky7q6Xfy1rX4TlqP
7+T16FfWo1+Vf2oQfTM8q7ccvSu8oLd3XeHOsaL/NMdt7PJfMa93bV7v1Ll7
p9W63G/q8m6s07vx74w6uDeTDpuxryx3H+UbsU/zumfG5a2IpUF1cU7qMukO
V/eyHe11O9rTVziY5TvRrl9t/BJ+ucEpz06MqzsxLn3Db594eJ1hh6cf2P1u
/Pf4TpbvEg/PPXHwsoh+9Sd+cuvajXkqPM+x78W6816su8iN34t1pD7W3cEH
9bBueK//jHfhI3yApwPi4AU+wjv0TOaBd/AKz36n7x6uLs7NPoemTuue6tyP
edMsYtegfQ5gr51+ivaD6DfaP7zQz6ST/ePXMc/OdxYxT13EPJl9mXSFD/B0
SJx1Hsa63Bv32r1xLu6Bc3GOvX04V7hzsa+xmaO6jXB1S03f6mAf7rl99PNY
R5nHdwfvwrh5jBvnMS4tInZy71E7vIcP6u+c0Ne59eoPH9Uf7h2bx7s0z3SX
zlX94d5JsU719z37h9v32PSRmrq6w5jHvsxjX/q5V0ODtUHnog6TzvwfPdL5
Hx4BaDU=
                 "]]}}}}}, {}, {}, {{}, {}}, {{}, {}}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0., 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImagePadding -> All, 
          Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}}, PlotRange -> {{0., 200.}, {0, 200.}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9d057044-73b7-44f7-8ae2-e7b2a5583fa9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Get a random sample of 25 words from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", "]"}]], "InlineCode",ExpressionUUID->
  "12040a25-0a20-478b-99e7-ae1e2d046ff7"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d3c6fba4-277a-41cd-84b7-bbf404e46364"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"autopsy\"\>", ",", "\<\"reclassification\"\>", 
         ",", "\<\"advancement\"\>", ",", "\<\"forswear\"\>", 
         ",", "\<\"swimwear\"\>", ",", "\<\"cravat\"\>", 
         ",", "\<\"cyclone\"\>", ",", "\<\"taps\"\>", 
         ",", "\<\"diplomatic\"\>", ",", "\<\"effacement\"\>", 
         ",", "\<\"peaked\"\>", ",", "\<\"ponderously\"\>", 
         ",", "\<\"publication\"\>", ",", "\<\"immune\"\>", 
         ",", "\<\"outstay\"\>", ",", "\<\"petrol\"\>", ",", "\<\"deaf\"\>", 
         ",", "\<\"bilk\"\>", ",", "\<\"oddments\"\>", 
         ",", "\<\"scoreboard\"\>", ",", "\<\"lifeless\"\>", 
         ",", "\<\"debriefing\"\>", ",", "\<\"radiogram\"\>", 
         ",", "\<\"doting\"\>", ",", "\<\"inter\"\>"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "5180b473-ef84-45c9-a721-c50ffbb2480e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"autopsy\"", ",", "\"reclassification\"", ",", 
             "\"advancement\"", ",", "\"forswear\"", ",", "\"swimwear\"", ",",
              "\"cravat\"", ",", "\"cyclone\"", ",", "\"taps\"", ",", 
             "\"diplomatic\"", ",", "\"effacement\"", ",", "\"peaked\"", ",", 
             "\"ponderously\"", ",", "\"publication\"", ",", "\"immune\"", 
             ",", "\"outstay\"", ",", "\"petrol\"", ",", "\"deaf\"", ",", 
             "\"bilk\"", ",", "\"oddments\"", ",", "\"scoreboard\"", ",", 
             "\"lifeless\"", ",", "\"debriefing\"", ",", "\"radiogram\"", ",",
              "\"doting\"", ",", "\"inter\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"77dea5d6-7071-4e9b-a084-a9b3e56e7739"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Riffle periods into the string \[OpenCurlyDoubleQuote]UNCLE\
\[CloseCurlyDoubleQuote] to make \[OpenCurlyDoubleQuote]U.N.C.L.E.\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2da9d0b6-fcbc-48c7-a616-b69f4cc4fd2e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"U.N.C.L.E.\"\>"], "ExerciseOutput",ExpressionUUID->
       "9eb07074-a242-4225-9726-01800a96aaf1"],
      Apply[TextCell, 
       Cell[
        BoxData["\"U.N.C.L.E.\""], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6eac75a6-633d-41b9-a62d-a36cb8a3f8dc"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find letters that appear in Swedish or Polish but not English.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3a66ae81-4e6d-4bc0-91af-9381ef9f3ea5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"\:0105\"\>", ",", "\<\"\:0119\"\>", 
         ",", "\<\"\:0144\"\>", ",", "\<\"\:015b\"\>", ",", "\<\"\:017a\"\>", 
         ",", "\<\"\:017c\"\>", ",", "\<\"\[ARing]\"\>", 
         ",", "\<\"\[ADoubleDot]\"\>", ",", "\<\"\[CAcute]\"\>", 
         ",", "\<\"\[LSlash]\"\>", ",", "\<\"\[OAcute]\"\>", 
         ",", "\<\"\[ODoubleDot]\"\>"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"2a2a9145-427b-4b11-8796-c0fb133b9820"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"\:0105\"", ",", "\"\:0119\"", ",", "\"\:0144\"", ",", 
             "\"\:015b\"", ",", "\"\:017a\"", ",", "\"\:017c\"", ",", 
             "\"\[ARing]\"", ",", "\"\[ADoubleDot]\"", ",", "\"\[CAcute]\"", 
             ",", "\"\[LSlash]\"", ",", "\"\[OAcute]\"", ",", 
             "\"\[ODoubleDot]\""}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3af95353-be0b-4f9d-8bc8-a41f07930fc8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find countries that are in the World Health Organization but not the United \
Nations.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e22f5c14-c7eb-4e80-8558-7a8949b3d659"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TemplateBox[{"\"Cook Islands\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"CookIslands\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"CookIslands\\\"]\"", "\"country\""},
          
          "Entity"], ",", 
         TemplateBox[{"\"Niue\"", 
           RowBox[{"Entity", "[", 
             RowBox[{"\"Country\"", ",", "\"Niue\""}], "]"}], 
           "\"Entity[\\\"Country\\\", \\\"Niue\\\"]\"", "\"country\""},
          "Entity"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "71c94051-8004-4a20-9ae4-571de3646b3f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             TemplateBox[{"\"Cook Islands\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"CookIslands\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"CookIslands\\\"]\"", 
               "\"country\""}, "Entity"], ",", 
             TemplateBox[{"\"Niue\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"Niue\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"Niue\\\"]\"", "\"country\""}, 
              "Entity"]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"749881bc-0cc3-406f-92b8-6327d0735e8d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of all pair-wise blends of red, green and blue.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"340df7d3-4fa5-4489-9318-37710d8ed45b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.3333333333333333, 0.3333333333333333, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1/2, 1/2, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                 Rational[1, 2], 
                 Rational[1, 2], 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[
           Rational[1, 2], 
           Rational[1, 2], 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[
                Rational[1, 2], 0, 
                Rational[1, 2]], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.3333333333333333, 0., 0.3333333333333333],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1/2, 0, 1/2]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                 Rational[1, 2], 0, 
                 Rational[1, 2]]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[
           Rational[1, 2], 0, 
           Rational[1, 2]],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.3333333333333333, 0.3333333333333333, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1/2, 1/2, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                 Rational[1, 2], 
                 Rational[1, 2], 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[
           Rational[1, 2], 
           Rational[1, 2], 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 1, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 
                Rational[1, 2], 
                Rational[1, 2]], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.3333333333333333, 0.3333333333333333],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1/2, 1/2]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 
                 Rational[1, 2], 
                 Rational[1, 2]]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 
           Rational[1, 2], 
           Rational[1, 2]],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[
                Rational[1, 2], 0, 
                Rational[1, 2]], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.3333333333333333, 0., 0.3333333333333333],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1/2, 0, 1/2]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                 Rational[1, 2], 0, 
                 Rational[1, 2]]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[
           Rational[1, 2], 0, 
           Rational[1, 2]],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 
                Rational[1, 2], 
                Rational[1, 2]], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0.3333333333333333, 0.3333333333333333],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 1/2, 1/2]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 
                 Rational[1, 2], 
                 Rational[1, 2]]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 
           Rational[1, 2], 
           Rational[1, 2]],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0., 0., 0.6666666666666666],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[0, 0, 1]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[0, 0, 1],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "0868062a-1441-444e-ad65-645071a5aef1"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    Rational[1, 2], 
                    Rational[1, 2], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[0.3333333333333333, 0.3333333333333333, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1/2, 1/2, 0]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[1, 2], 
                    Rational[1, 2], 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
               Rational[1, 2], 
               Rational[1, 2], 0], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    Rational[1, 2], 0, 
                    Rational[1, 2]], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[0.3333333333333333, 0., 0.3333333333333333], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1/2, 0, 1/2]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[1, 2], 0, 
                    Rational[1, 2]]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
               Rational[1, 2], 0, 
               Rational[1, 2]], Editable -> False, Selectable -> False], ",", 
             
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    Rational[1, 2], 
                    Rational[1, 2], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[0.3333333333333333, 0.3333333333333333, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1/2, 1/2, 0]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[1, 2], 
                    Rational[1, 2], 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
               Rational[1, 2], 
               Rational[1, 2], 0], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[0, 
                    Rational[1, 2], 
                    Rational[1, 2]], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[0., 0.3333333333333333, 0.3333333333333333], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1/2, 1/2]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 
                    Rational[1, 2], 
                    Rational[1, 2]]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 
               Rational[1, 2], 
               Rational[1, 2]], Editable -> False, Selectable -> False], ",", 
             
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    Rational[1, 2], 0, 
                    Rational[1, 2]], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[0.3333333333333333, 0., 0.3333333333333333], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1/2, 0, 1/2]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[1, 2], 0, 
                    Rational[1, 2]]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
               Rational[1, 2], 0, 
               Rational[1, 2]], Editable -> False, Selectable -> False], ",", 
             
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[0, 
                    Rational[1, 2], 
                    Rational[1, 2]], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[0., 0.3333333333333333, 0.3333333333333333], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 1/2, 1/2]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 
                    Rational[1, 2], 
                    Rational[1, 2]]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 
               Rational[1, 2], 
               Rational[1, 2]], Editable -> False, Selectable -> False], ",", 
             
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 0, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 0, 1], Editable -> False, Selectable -> False]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0d263db8-9af3-424f-ac12-6a55836ca703"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of array plots, each 50 rows high and with image size 50, of \
successive possible 8-tuples of 0 and 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7dfea61c-2da1-4931-890e-1b1beabe293a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[RasterBox[CompressedData["
1:eJxdj8sRgCAQQ/M82YYtWIol0AD930QI4OSws5+QD1epTzkk3a3OVvAVs/dR
444MtebdOMYxjnHzMX9LrydjN3/XAvssG8uGspETykl83mL/DxCBiYBEICIA
YUgYEIKEAEEgHhCHObzRVwLu
           "], {{0, 0}, {8, 50}}, {0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->50,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxVkMENgDAMA21erMEKjMIIXYD9f1TtOS2CKFjEvrRXe592SLp7nb3cX7u6
ZzearzE3OtroTPLfilOVoJ8DXc/U+I0/LviGb/hrOisvtPcU+IZv+N7YGVIN
h8rxJ11sQZhqq4Rrh2RLorip/a7rFFkq5Q+1UwK8
           "], {{0, 0}, {8, 50}}, {0,
            1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->50,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxNkcERgzAMBPfyShtpIaWkBBpI/78QvIc1oJHxCp3Ofh3fz/EA3mc8zyDh
/5j70uXK8vTj4leVkFlE5JFHnjZZPP6vfsXtLIgbSVdL3uQwzKGIXCs4UrVH
1ATDDDoaR3Fbym7NKA3zENib9cj2Wk2y476B/ACzhQKs
           "], {{0, 0}, {8, 
           50}}, {0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->50,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxVkNsVgDAIQxO/XMMVHMURXMD9/3z0pmB7gENDCGU7r+NcJO2PrXqP7Yoe
0eQeucENbvCUfjDeJHBGq2lprZJQp7g5WVEEh98mTccou5MnoxAuOHz067XE
U6WqZiFmEWzv16WGdvurSnta1LIq35i5Apo=
           "], {{0, 0}, {8, 50}}, {0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->50,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxVj8sNwDAIQ3FPXaMrdJSOkAW6/61R8wwhEgrC+MM13mccEXHPOoMn+f8b
eUwrJmKx1sEZaDUb3WVZ8JQDty38kg81G/hlB+5YMiWvUIthyYK0xwr4Fc9L
jg2eccF91uJv8S2e3urngPvsyf8AdrECeA==
           "], {{0, 0}, {8, 50}}, {0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->50,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "8da4cd3b-df4a-448a-ba32-aec0f5b07c87"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxdj8sRgCAQQ/M82YYtWIol0AD930QI4OSws5+QD1epTzkk3a3OVvAVs/dR
444MtebdOMYxjnHzMX9LrydjN3/XAvssG8uGspETykl83mL/DxCBiYBEICIA
YUgYEIKEAEEgHhCHObzRVwLu
               "], {{0, 0}, {8, 50}}, {0, 1}], Frame -> 
              Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 50, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxVkMENgDAMA21erMEKjMIIXYD9f1TtOS2CKFjEvrRXe592SLp7nb3cX7u6
ZzearzE3OtroTPLfilOVoJ8DXc/U+I0/LviGb/hrOisvtPcU+IZv+N7YGVIN
h8rxJ11sQZhqq4Rrh2RLorip/a7rFFkq5Q+1UwK8
               "], {{0, 0}, {8, 
               50}}, {0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 50, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxNkcERgzAMBPfyShtpIaWkBBpI/78QvIc1oJHxCp3Ofh3fz/EA3mc8zyDh
/5j70uXK8vTj4leVkFlE5JFHnjZZPP6vfsXtLIgbSVdL3uQwzKGIXCs4UrVH
1ATDDDoaR3Fbym7NKA3zENib9cj2Wk2y476B/ACzhQKs
               "], {{0, 0}, {8, 
               50}}, {0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 50, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxVkNsVgDAIQxO/XMMVHMURXMD9/3z0pmB7gENDCGU7r+NcJO2PrXqP7Yoe
0eQeucENbvCUfjDeJHBGq2lprZJQp7g5WVEEh98mTccou5MnoxAuOHz067XE
U6WqZiFmEWzv16WGdvurSnta1LIq35i5Apo=
               "], {{0, 0}, {8, 50}}, {0,
                1}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 50, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxVj8sNwDAIQ3FPXaMrdJSOkAW6/61R8wwhEgrC+MM13mccEXHPOoMn+f8b
eUwrJmKx1sEZaDUb3WVZ8JQDty38kg81G/hlB+5YMiWvUIthyYK0xwr4Fc9L
jg2eccF91uJv8S2e3urngPvsyf8AdrECeA==
               "], {{0, 0}, {8, 50}}, {0,
                1}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 50, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"90f35eef-251a-470d-8bc3-4191d7d097e5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate 1000 random sequences of 4 letters, and make a list of ones that \
appear in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "edbe4fb6-cc4f-4777-b798-ddd3ea4384e6"],
 ". ",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"66e9a863-e390-43e3-a8f9-3b5de9a69c5b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"avow\"\>", ",", "\<\"frog\"\>", ",", "\<\"know\"\>", 
         ",", "\<\"lido\"\>", ",", "\<\"snot\"\>"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"59f9fcc9-9b0a-471b-bed2-16fa3c396af1"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"avow\"", ",", "\"frog\"", ",", "\"know\"", ",", 
             "\"lido\"", ",", "\"snot\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3780bab1-6755-44a6-b974-3bce87b50944"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:185",ExpressionUUID->"ab9d1cec-4ceb-4810-b633-13dbd5e4fa1c"],

Cell[TextData[{
 "What does ",
 ButtonBox["Partition",
  BaseStyle->"Link"],
 " do if the blocks don\[CloseCurlyQuote]t fit perfectly?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4c0aa9a4-7e25-49ff-aa60-2faa64734662"],

Cell[TextData[{
 "If it\[CloseCurlyQuote]s not told otherwise, it\[CloseCurlyQuote]ll only \
include complete blocks, so it\[CloseCurlyQuote]ll just drop elements that \
appear only in incomplete blocks. However, if you say for example ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Partition",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["list", "CodeVariable"], ",", 
    RowBox[{
     ButtonBox["UpTo",
      BaseStyle->"CodeLink"], "[", "4", "]"}]}], "]"}]], "InlineCode",
  ExpressionUUID->"95a8dfd9-3d08-412e-a85c-c57ddc14704b"],
 ", it\[CloseCurlyQuote]ll make blocks ",
 StyleBox["up to",
  FontSlant->"Italic"],
 " length 4, with the last block being shorter if necessary. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:29",ExpressionUUID->"8d9e912b-df0c-4519-8336-69d2b7ad79d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Note", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d899484b-31d2-4bb8-8c99-bd353010ca42"],

Cell[TextData[{
 ButtonBox["Transpose",
  BaseStyle->"Link"],
 " can be thought of as transposing rows and columns in a matrix."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:30",ExpressionUUID->"8a44b516-cb23-49af-87c7-dff12ee692f3"],

Cell[TextData[{
 ButtonBox["ArrayFlatten",
  BaseStyle->"Link"],
 " flattens an array of arrays into a single array, or alternatively, a \
matrix of matrices into a single matrix."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:31",ExpressionUUID->"7652986e-91e4-47b8-90db-3a36134b1d5f"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DeleteDuplicates",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["list", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "c23c0966-bf88-44f7-82e3-a1899c6e0234"],
 " does the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Union",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["list", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "8e5ee28a-b24d-4c9e-ad20-27e42bd32453"],
 ", except it doesn\[CloseCurlyQuote]t reorder elements."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:32",ExpressionUUID->"c62b4ce4-6261-401b-881e-cbc14c9af288"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0a961737-910c-4eb8-8696-db284d733641"],

Cell[TextData[ButtonBox["Guide to Rearranging & Restructuring Lists in the \
Wolfram Language\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreExplore",\

 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"e00cf606-4bd8-418b-b6c9-9355fae03d1c"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Rearranging Lists: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-29-more-about-pure-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-29-more-about-pure-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"More about Pure Functions\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "More about Pure Functions", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Parts of Lists\"", TooltipDelay -> 0.15,
               LabelStyle -> "TextStyling"], 
             Annotation[#, "Parts of Lists", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->254,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Rearranging Lists \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"49166f82-2e05-4679-9d3f-5cfc66bf3030"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:177"->{
  Cell[660, 23, 420, 10, 93, "SectionDoubleDigit",ExpressionUUID->"410569be-7f26-45af-a43e-7510b233b330",
   CounterAssignments->{{"Section", 29}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:177"]},
 "i:1"->{
  Cell[1476, 46, 214, 4, 37, "CodeCaption",ExpressionUUID->"fc5f5e0c-d60a-4f23-a4da-9ab43f315817",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[3707, 124, 327, 11, 40, "Text",ExpressionUUID->"8962f7e9-0b5b-4246-a788-482a996a0407",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[5239, 179, 287, 10, 40, "Text",ExpressionUUID->"7d681ab3-a2ec-4534-92ab-e6f6d84c5654",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[6457, 223, 217, 5, 37, "CodeCaption",ExpressionUUID->"546db506-8f7a-4b56-9a5e-7112c01460eb",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[8491, 282, 211, 4, 70, "CodeCaption",ExpressionUUID->"34537605-c2b5-48da-a310-292c3e2f4884",
   CellTags->"i:5"]},
 "LastCellOfAPage"->{
  Cell[8956, 297, 780, 23, 70, "Output",ExpressionUUID->"deeefbef-b444-4d73-b9ca-7f266bc6cd62",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[18539, 594, 1132, 37, 70, "Output",ExpressionUUID->"358d079c-7717-48c9-a1d5-b7d922893d5d",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[31685, 1022, 2437, 48, 70, "Output",ExpressionUUID->"b1619ca4-3621-43b6-8b8f-440ad3e781ed",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[43957, 1411, 314, 9, 70, "Output",ExpressionUUID->"43b7f6df-09be-43f7-af78-3a745b7b23c9",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[51378, 1651, 432, 12, 70, "Text",ExpressionUUID->"48b69621-b517-4e94-a9e3-e6e8fa68299b",
   CellTags->"LastCellOfAPage"],
  Cell[197260, 5666, 336, 9, 70, "Output",ExpressionUUID->"ab8f3322-f09d-46b1-8f0d-81d9aeea586f",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[197824, 5687, 9389, 263, 70, "VocabularyTable",ExpressionUUID->"3aedd571-f8e6-47d7-a60a-17d0abf73573",
   CellTags->"LastCellOfAPage"],
  Cell[311280, 8430, 1275, 40, 70, "Exercise",ExpressionUUID->"9138ee94-0d26-4d58-b19f-f002774fb9be",
   CellTags->"LastCellOfAPage"],
  Cell[405284, 10801, 382, 9, 70, "MoreExplore",ExpressionUUID->"e00cf606-4bd8-418b-b6c9-9355fae03d1c",
   CellTags->"LastCellOfAPage"]},
 "p:178"->{
  Cell[9751, 323, 231, 6, 70, "CodeCaption",ExpressionUUID->"07a6ea35-a0e3-4ec4-a1ce-5ac379ddf727",
   CellTags->"p:178"]},
 "i:6"->{
  Cell[13000, 413, 374, 11, 70, "Text",ExpressionUUID->"9f96a35b-4542-4681-ad9b-c1422f29e43a",
   CellTags->"i:6"]},
 "p:179"->{
  Cell[19686, 634, 183, 4, 70, "CodeCaption",ExpressionUUID->"45e67845-67dd-49f4-a507-ea4bbca9f141",
   CellTags->"p:179"]},
 "i:7"->{
  Cell[22297, 721, 366, 12, 70, "Text",ExpressionUUID->"3d9b368e-714a-4cbb-9baa-902c3ec9f155",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[25259, 828, 295, 8, 70, "CodeCaption",ExpressionUUID->"c8b1aba6-c7ea-47de-8020-e497d6193792",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[30867, 992, 279, 9, 70, "CodeCaption",ExpressionUUID->"a1d7916b-a50c-4cfc-9557-0f61c75431ad",
   CellTags->"i:9"]},
 "p:180"->{
  Cell[34137, 1073, 344, 12, 70, "Text",ExpressionUUID->"e8dd28ff-4e1a-41df-aa0c-c92ab9b4ffef",
   CellTags->{"p:180", "i:10"}]},
 "i:10"->{
  Cell[34137, 1073, 344, 12, 70, "Text",ExpressionUUID->"e8dd28ff-4e1a-41df-aa0c-c92ab9b4ffef",
   CellTags->{"p:180", "i:10"}]},
 "i:11"->{
  Cell[35573, 1125, 291, 9, 70, "Text",ExpressionUUID->"ebee30da-2871-450b-a222-18220e7795cd",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[36841, 1169, 436, 14, 70, "Text",ExpressionUUID->"183c3a0b-bead-4f68-bede-67fcdffc6f6f",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[38728, 1225, 264, 8, 70, "Text",ExpressionUUID->"ed646aae-2a9d-41b5-b49b-f351c414c2c3",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[38995, 1235, 264, 8, 70, "CodeCaption",ExpressionUUID->"411e0669-c6aa-47bb-b8eb-c8978edb4e8b",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[41833, 1336, 315, 11, 70, "Text",ExpressionUUID->"34f757d1-d3d1-492b-ad9d-462702a47ab6",
   CellTags->"i:15"]},
 "p:181"->{
  Cell[44286, 1423, 221, 5, 70, "CodeCaption",ExpressionUUID->"efe6522a-bd78-4ecf-8ef2-b8457ec5ba3b",
   CellTags->{"p:181", "i:16"}]},
 "i:16"->{
  Cell[44286, 1423, 221, 5, 70, "CodeCaption",ExpressionUUID->"efe6522a-bd78-4ecf-8ef2-b8457ec5ba3b",
   CellTags->{"p:181", "i:16"}]},
 "i:17"->{
  Cell[45215, 1454, 233, 6, 70, "CodeCaption",ExpressionUUID->"4f615a91-b241-4661-8f64-df3cb4b562e9",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[46055, 1484, 231, 6, 70, "CodeCaption",ExpressionUUID->"4853d53c-311e-42cd-a756-53e9e131f615",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[48394, 1548, 343, 11, 70, "Text",ExpressionUUID->"050db292-e73c-4abf-80b1-5dbf98e00798",
   CellTags->"i:19"]},
 "p:182"->{
  Cell[51813, 1665, 331, 12, 70, "Text",ExpressionUUID->"569ae83e-1c1e-4ff3-9268-9df45efba35c",
   CellTags->{"p:182", "i:20"}]},
 "i:20"->{
  Cell[51813, 1665, 331, 12, 70, "Text",ExpressionUUID->"569ae83e-1c1e-4ff3-9268-9df45efba35c",
   CellTags->{"p:182", "i:20"}]},
 "i:21"->{
  Cell[80967, 2457, 392, 12, 70, "CodeCaption",ExpressionUUID->"54ea5451-a2b6-4bb0-9a7f-3bd9ee691de8",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[100564, 2994, 315, 9, 70, "Text",ExpressionUUID->"99f2a01d-f5b1-4818-999c-f6ddda96293a",
   CellTags->"i:22"]},
 "i:23"->{
  Cell[139030, 4032, 281, 10, 70, "Text",ExpressionUUID->"417a256a-ff55-470a-bd2d-8ccc3d49c0ce",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[195528, 5607, 318, 9, 70, "Text",ExpressionUUID->"9ca45ddf-45b6-4ccc-9ca8-584c15fef385",
   CellTags->"i:24"]},
 "p:183"->{
  Cell[197645, 5681, 176, 4, 70, "VocabularySection",ExpressionUUID->"8e0aea5a-5a60-4e84-afe4-55fd5fe246ae",
   CellTags->"p:183"]},
 "i:25"->{
  Cell[236686, 6588, 834, 24, 70, "Exercise",ExpressionUUID->"335e0c26-6efd-47fe-a007-8e3a2343e79a",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[244457, 6759, 1847, 59, 70, "Exercise",ExpressionUUID->"d8518d6e-d5e9-4815-8219-21945099bb00",
   CellTags->"i:26"]},
 "i:27"->{
  Cell[253314, 6989, 1496, 47, 70, "Exercise",ExpressionUUID->"4b3920f5-2fe9-43ad-aaeb-59b6ce152d1a",
   CellTags->"i:27"]},
 "i:28"->{
  Cell[291682, 7955, 742, 20, 70, "Exercise",ExpressionUUID->"6a712fea-caf9-4f81-99fe-712410845d63",
   CellTags->"i:28"]},
 "p:185"->{
  Cell[402324, 10700, 161, 4, 70, "QASection",ExpressionUUID->"ab9d1cec-4ceb-4810-b633-13dbd5e4fa1c",
   CellTags->"p:185"]},
 "i:29"->{
  Cell[402762, 10717, 844, 22, 70, "Answer",ExpressionUUID->"8d9e912b-df0c-4519-8336-69d2b7ad79d0",
   CellTags->"i:29"]},
 "i:30"->{
  Cell[403802, 10750, 280, 8, 70, "TechNote",ExpressionUUID->"8a44b516-cb23-49af-87c7-dff12ee692f3",
   CellTags->"i:30"]},
 "i:31"->{
  Cell[404085, 10760, 332, 9, 70, "TechNote",ExpressionUUID->"7652986e-91e4-47b8-90db-3a36134b1d5f",
   CellTags->"i:31"]},
 "i:32"->{
  Cell[404420, 10771, 659, 19, 70, "TechNote",ExpressionUUID->"c62b4ce4-6261-401b-881e-cbc14c9af288",
   CellTags->"i:32"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:177", 496378, 12649},
 {"i:1", 496618, 12653},
 {"i:2", 496749, 12656},
 {"i:3", 496875, 12659},
 {"i:4", 497001, 12662},
 {"i:5", 497133, 12665},
 {"LastCellOfAPage", 497277, 12668},
 {"p:178", 498602, 12692},
 {"i:6", 498736, 12695},
 {"p:179", 498865, 12698},
 {"i:7", 499000, 12701},
 {"i:8", 499127, 12704},
 {"i:9", 499260, 12707},
 {"p:180", 499395, 12710},
 {"i:10", 499536, 12713},
 {"i:11", 499677, 12716},
 {"i:12", 499806, 12719},
 {"i:13", 499936, 12722},
 {"i:14", 500065, 12725},
 {"i:15", 500201, 12728},
 {"p:181", 500332, 12731},
 {"i:16", 500479, 12734},
 {"i:17", 500626, 12737},
 {"i:18", 500762, 12740},
 {"i:19", 500898, 12743},
 {"p:182", 501029, 12746},
 {"i:20", 501170, 12749},
 {"i:21", 501311, 12752},
 {"i:22", 501448, 12755},
 {"i:23", 501578, 12758},
 {"i:24", 501709, 12761},
 {"p:183", 501840, 12764},
 {"i:25", 501984, 12767},
 {"i:26", 502119, 12770},
 {"i:27", 502255, 12773},
 {"i:28", 502391, 12776},
 {"p:185", 502527, 12779},
 {"i:29", 502664, 12782},
 {"i:30", 502798, 12785},
 {"i:31", 502933, 12788},
 {"i:32", 503068, 12791}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[660, 23, 420, 10, 93, "SectionDoubleDigit",ExpressionUUID->"410569be-7f26-45af-a43e-7510b233b330",
 CounterAssignments->{{"Section", 29}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:177"],
Cell[1083, 35, 390, 9, 90, "Text",ExpressionUUID->"61b2e948-dede-4c20-bb86-78b186c4c649"],
Cell[1476, 46, 214, 4, 37, "CodeCaption",ExpressionUUID->"fc5f5e0c-d60a-4f23-a4da-9ab43f315817",
 CellTags->"i:1"],
Cell[CellGroupData[{
Cell[1715, 54, 492, 15, 29, "Input",ExpressionUUID->"bf8bb5a1-8390-428a-9032-c3070ec6e260"],
Cell[2210, 71, 379, 11, 40, "Output",ExpressionUUID->"af58798f-aeae-4cb9-8274-c655f710fd76",
 Evaluatable->False]
}, Open  ]],
Cell[2604, 85, 195, 4, 37, "CodeCaption",ExpressionUUID->"ac5e3df8-038d-480f-8ccb-7473e964ad7e"],
Cell[CellGroupData[{
Cell[2824, 93, 372, 10, 29, "Input",ExpressionUUID->"cf7e5482-6cc1-4659-89fe-34faba69bcf8"],
Cell[3199, 105, 493, 16, 40, "Output",ExpressionUUID->"2e2fe29d-8c3c-4bd1-94e9-c07b4e233965",
 Evaluatable->False]
}, Open  ]],
Cell[3707, 124, 327, 11, 40, "Text",ExpressionUUID->"8962f7e9-0b5b-4246-a788-482a996a0407",
 CellTags->"i:2"],
Cell[4037, 137, 414, 13, 39, "CodeCaption",ExpressionUUID->"338e8ab4-2322-4d18-8b0d-246af194d18f"],
Cell[CellGroupData[{
Cell[4476, 154, 347, 9, 29, "Input",ExpressionUUID->"4db3ffd0-27a1-48bc-bb9c-57240550516b"],
Cell[4826, 165, 398, 11, 40, "Output",ExpressionUUID->"d0274e1b-ca06-4372-a5a3-65c8df7630aa",
 Evaluatable->False]
}, Open  ]],
Cell[5239, 179, 287, 10, 40, "Text",ExpressionUUID->"7d681ab3-a2ec-4534-92ab-e6f6d84c5654",
 CellTags->"i:3"],
Cell[5529, 191, 193, 4, 37, "CodeCaption",ExpressionUUID->"3e54f540-e83e-48de-8ff7-70a7151b072c"],
Cell[CellGroupData[{
Cell[5747, 199, 216, 5, 29, "Input",ExpressionUUID->"4d78325e-d871-41b3-81fb-77d7ca9058ab"],
Cell[5966, 206, 476, 14, 40, "Output",ExpressionUUID->"741c73dc-27bc-4a69-b217-79c8995d5c7e",
 Evaluatable->False]
}, Open  ]],
Cell[6457, 223, 217, 5, 37, "CodeCaption",ExpressionUUID->"546db506-8f7a-4b56-9a5e-7112c01460eb",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[6699, 232, 386, 11, 54, "Input",ExpressionUUID->"f87f3426-943d-4510-9600-5c8e554b44d5"],
Cell[7088, 245, 987, 20, 135, "Output",ExpressionUUID->"e40b500a-64cc-49f0-91fc-411f470e48b3",
 Evaluatable->False]
}, Open  ]],
Cell[8090, 268, 398, 12, 70, "Text",ExpressionUUID->"29c7bf03-eccf-4969-a37e-39b55454a774"],
Cell[8491, 282, 211, 4, 70, "CodeCaption",ExpressionUUID->"34537605-c2b5-48da-a310-292c3e2f4884",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[8727, 290, 226, 5, 70, "Input",ExpressionUUID->"24c1870f-6108-49bc-aa33-3c8f3c6a8877"],
Cell[8956, 297, 780, 23, 70, "Output",ExpressionUUID->"deeefbef-b444-4d73-b9ca-7f266bc6cd62",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[9751, 323, 231, 6, 70, "CodeCaption",ExpressionUUID->"07a6ea35-a0e3-4ec4-a1ce-5ac379ddf727",
 CellTags->"p:178"],
Cell[CellGroupData[{
Cell[10007, 333, 355, 9, 70, "Input",ExpressionUUID->"1eab4ac3-5a03-4d5f-9a98-de7920259e04"],
Cell[10365, 344, 1192, 25, 70, "Output",ExpressionUUID->"88e29c32-6eb1-4f18-8c10-9ebce66c915a",
 Evaluatable->False]
}, Open  ]],
Cell[11572, 372, 170, 4, 70, "CodeCaption",ExpressionUUID->"e244d449-0ea1-4edd-accd-ddfbe9f847c3"],
Cell[CellGroupData[{
Cell[11767, 380, 355, 9, 70, "Input",ExpressionUUID->"19fff1eb-0296-4fa3-ad97-2375e2bf498b"],
Cell[12125, 391, 860, 19, 70, "Output",ExpressionUUID->"71718e85-10ba-47ea-b714-919f8979f49f",
 Evaluatable->False]
}, Open  ]],
Cell[13000, 413, 374, 11, 70, "Text",ExpressionUUID->"9f96a35b-4542-4681-ad9b-c1422f29e43a",
 CellTags->"i:6"],
Cell[13377, 426, 199, 4, 70, "CodeCaption",ExpressionUUID->"a8105255-07f5-4e0e-8753-625d643300e0"],
Cell[CellGroupData[{
Cell[13601, 434, 192, 4, 70, "Input",ExpressionUUID->"d5435fbe-840d-4df1-8cc1-821a04dfa0a9"],
Cell[13796, 440, 1152, 37, 70, "Output",ExpressionUUID->"f7dab78e-0ecc-4494-a3f4-d1fb25dad2f3",
 Evaluatable->False]
}, Open  ]],
Cell[14963, 480, 168, 4, 70, "CodeCaption",ExpressionUUID->"38961a2d-ba54-464b-b387-0eac2318e77b"],
Cell[CellGroupData[{
Cell[15156, 488, 228, 5, 70, "Input",ExpressionUUID->"9af9062b-8555-4b9b-9d2e-c70a19e9e3b6"],
Cell[15387, 495, 527, 11, 70, "Output",ExpressionUUID->"196858d3-b606-458b-928f-7798a8731f23",
 Evaluatable->False]
}, Open  ]],
Cell[15929, 509, 183, 4, 70, "CodeCaption",ExpressionUUID->"fc27c2bd-f139-4700-bc8f-44cd81824726"],
Cell[CellGroupData[{
Cell[16137, 517, 269, 6, 70, "Input",ExpressionUUID->"a4e9f557-1033-49b6-951d-6aa054d56e99"],
Cell[16409, 525, 1167, 33, 70, "Output",ExpressionUUID->"d87deb76-cac5-4537-891b-b2299b557808",
 Evaluatable->False]
}, Open  ]],
Cell[17591, 561, 391, 11, 70, "Text",ExpressionUUID->"98c94d4b-c94d-4bbf-b14e-33c79303eb57"],
Cell[17985, 574, 173, 4, 70, "CodeCaption",ExpressionUUID->"328b558b-dccb-4678-8790-e85399ef2439"],
Cell[CellGroupData[{
Cell[18183, 582, 353, 10, 70, "Input",ExpressionUUID->"94944208-5bc2-4c66-afc6-ea6a9d1b96c2"],
Cell[18539, 594, 1132, 37, 70, "Output",ExpressionUUID->"358d079c-7717-48c9-a1d5-b7d922893d5d",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[19686, 634, 183, 4, 70, "CodeCaption",ExpressionUUID->"45e67845-67dd-49f4-a507-ea4bbca9f141",
 CellTags->"p:179"],
Cell[CellGroupData[{
Cell[19894, 642, 394, 11, 70, "Input",ExpressionUUID->"fa438f03-19e6-4253-a909-5cf0fd4e2727"],
Cell[20291, 655, 443, 10, 70, "Output",ExpressionUUID->"cb41575e-35cc-4223-9c0a-4f3f974eee0e",
 Evaluatable->False]
}, Open  ]],
Cell[20749, 668, 178, 4, 70, "CodeCaption",ExpressionUUID->"4029ff89-9725-43e0-bb3b-e7107ce1998b"],
Cell[CellGroupData[{
Cell[20952, 676, 425, 12, 70, "Input",ExpressionUUID->"3da8ba7b-d8ff-4517-9974-4070ad6849f8"],
Cell[21380, 690, 902, 28, 70, "Output",ExpressionUUID->"37036f6e-c41c-43b7-983b-addb89a9471f",
 Evaluatable->False]
}, Open  ]],
Cell[22297, 721, 366, 12, 70, "Text",ExpressionUUID->"3d9b368e-714a-4cbb-9baa-902c3ec9f155",
 CellTags->"i:7"],
Cell[22666, 735, 237, 7, 70, "CodeCaption",ExpressionUUID->"03b9e75c-9ab6-4f43-835e-a158e3d46a2f"],
Cell[CellGroupData[{
Cell[22928, 746, 421, 13, 70, "Input",ExpressionUUID->"6060b3ea-fd74-4ace-bf93-d8c31855011a"],
Cell[23352, 761, 1892, 64, 70, "Output",ExpressionUUID->"992c0d52-1a64-45a2-91ea-64266ad1643f",
 Evaluatable->False]
}, Open  ]],
Cell[25259, 828, 295, 8, 70, "CodeCaption",ExpressionUUID->"c8b1aba6-c7ea-47de-8020-e497d6193792",
 CellTags->"i:8"],
Cell[CellGroupData[{
Cell[25579, 840, 468, 14, 70, "Input",ExpressionUUID->"f7050adb-4072-42c8-9ba5-cc6d9018e97d"],
Cell[26050, 856, 796, 25, 70, "Output",ExpressionUUID->"baa3c445-533b-4491-a616-d5b71e93624c",
 Evaluatable->False]
}, Open  ]],
Cell[26861, 884, 300, 10, 70, "CodeCaption",ExpressionUUID->"a3c69c4b-08f4-4d18-8689-bee75291fcbc"],
Cell[CellGroupData[{
Cell[27186, 898, 511, 15, 70, "Input",ExpressionUUID->"5130d1e9-6e3e-4441-a8af-26815956398d"],
Cell[27700, 915, 3152, 74, 70, "Output",ExpressionUUID->"ea7cfc28-36bb-4b00-9765-80ca27e68690",
 Evaluatable->False]
}, Open  ]],
Cell[30867, 992, 279, 9, 70, "CodeCaption",ExpressionUUID->"a1d7916b-a50c-4cfc-9557-0f61c75431ad",
 CellTags->"i:9"],
Cell[CellGroupData[{
Cell[31171, 1005, 511, 15, 70, "Input",ExpressionUUID->"ea79c986-5402-48cd-a906-940d262b704a"],
Cell[31685, 1022, 2437, 48, 70, "Output",ExpressionUUID->"b1619ca4-3621-43b6-8b8f-440ad3e781ed",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[34137, 1073, 344, 12, 70, "Text",ExpressionUUID->"e8dd28ff-4e1a-41df-aa0c-c92ab9b4ffef",
 CellTags->{"p:180", "i:10"}],
Cell[34484, 1087, 212, 6, 70, "CodeCaption",ExpressionUUID->"8647de99-4bd7-459e-8d0e-0c8f56ff4dcd"],
Cell[CellGroupData[{
Cell[34721, 1097, 312, 7, 70, "Input",ExpressionUUID->"171d3c66-5d14-467b-aeed-bbc8f4eac9a4"],
Cell[35036, 1106, 522, 16, 70, "Output",ExpressionUUID->"332edc17-33d9-4f4e-922f-dc8cf342e0dd",
 Evaluatable->False]
}, Open  ]],
Cell[35573, 1125, 291, 9, 70, "Text",ExpressionUUID->"ebee30da-2871-450b-a222-18220e7795cd",
 CellTags->"i:11"],
Cell[35867, 1136, 187, 4, 70, "CodeCaption",ExpressionUUID->"4ff9c2f8-6f96-4668-a203-ee08a72626e9"],
Cell[CellGroupData[{
Cell[36079, 1144, 313, 7, 70, "Input",ExpressionUUID->"03ea96e5-5327-4512-90d0-1e1989d04449"],
Cell[36395, 1153, 431, 13, 70, "Output",ExpressionUUID->"1ffa06b6-0b88-4ba7-8374-1cca1638a3cd",
 Evaluatable->False]
}, Open  ]],
Cell[36841, 1169, 436, 14, 70, "Text",ExpressionUUID->"183c3a0b-bead-4f68-bede-67fcdffc6f6f",
 CellTags->"i:12"],
Cell[37280, 1185, 214, 6, 70, "CodeCaption",ExpressionUUID->"74b7b112-581d-40e6-a102-a57472362c45"],
Cell[CellGroupData[{
Cell[37519, 1195, 274, 7, 70, "Input",ExpressionUUID->"eb7ad33b-7035-4049-ba3b-9cce48491e28"],
Cell[37796, 1204, 917, 18, 70, "Output",ExpressionUUID->"e619f0ae-b3f8-496d-a762-e7a56f6831ef",
 Evaluatable->False]
}, Open  ]],
Cell[38728, 1225, 264, 8, 70, "Text",ExpressionUUID->"ed646aae-2a9d-41b5-b49b-f351c414c2c3",
 CellTags->"i:13"],
Cell[38995, 1235, 264, 8, 70, "CodeCaption",ExpressionUUID->"411e0669-c6aa-47bb-b8eb-c8978edb4e8b",
 CellTags->"i:14"],
Cell[CellGroupData[{
Cell[39284, 1247, 331, 9, 70, "Input",ExpressionUUID->"3673c499-8825-49dd-8954-219b47f9470f"],
Cell[39618, 1258, 763, 23, 70, "Output",ExpressionUUID->"b96941a0-bbfb-4420-81f4-9ec71198b85d",
 Evaluatable->False]
}, Open  ]],
Cell[40396, 1284, 262, 9, 70, "CodeCaption",ExpressionUUID->"e79359df-5d11-46aa-9999-9a2fe832b7fd"],
Cell[CellGroupData[{
Cell[40683, 1297, 369, 11, 70, "Input",ExpressionUUID->"54b1a571-214a-4c01-b188-266196fa0cfd"],
Cell[41055, 1310, 763, 23, 70, "Output",ExpressionUUID->"ad4bbd12-c02b-4de7-8827-ffe20180486f",
 Evaluatable->False]
}, Open  ]],
Cell[41833, 1336, 315, 11, 70, "Text",ExpressionUUID->"34f757d1-d3d1-492b-ad9d-462702a47ab6",
 CellTags->"i:15"],
Cell[42151, 1349, 187, 4, 70, "CodeCaption",ExpressionUUID->"8e12a87a-9498-48e2-9ef9-2ad4a460d303"],
Cell[CellGroupData[{
Cell[42363, 1357, 324, 8, 70, "Input",ExpressionUUID->"399f5919-c33a-417e-b59f-ef53c2959016"],
Cell[42690, 1367, 248, 6, 70, "Output",ExpressionUUID->"f4b217b3-6763-4b09-b9cd-7150269c1fab",
 Evaluatable->False]
}, Open  ]],
Cell[42953, 1376, 326, 10, 70, "Text",ExpressionUUID->"d35507f8-69f5-4b46-b432-e8cd594007e1"],
Cell[43282, 1388, 204, 5, 70, "CodeCaption",ExpressionUUID->"3ad3c2f9-72c5-42b8-ad14-8949d742fdae"],
Cell[CellGroupData[{
Cell[43511, 1397, 443, 12, 70, "Input",ExpressionUUID->"00489667-b439-4df6-838b-efd819b3bdf6"],
Cell[43957, 1411, 314, 9, 70, "Output",ExpressionUUID->"43b7f6df-09be-43f7-af78-3a745b7b23c9",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[44286, 1423, 221, 5, 70, "CodeCaption",ExpressionUUID->"efe6522a-bd78-4ecf-8ef2-b8457ec5ba3b",
 CellTags->{"p:181", "i:16"}],
Cell[CellGroupData[{
Cell[44532, 1432, 437, 11, 70, "Input",ExpressionUUID->"f017568d-592a-47bc-840a-6d1957eee41e"],
Cell[44972, 1445, 228, 6, 70, "Output",ExpressionUUID->"107ed0bb-d7de-40a3-af3d-4f4c2614053c",
 Evaluatable->False]
}, Open  ]],
Cell[45215, 1454, 233, 6, 70, "CodeCaption",ExpressionUUID->"4f615a91-b241-4661-8f64-df3cb4b562e9",
 CellTags->"i:17"],
Cell[CellGroupData[{
Cell[45473, 1464, 346, 9, 70, "Input",ExpressionUUID->"abe6b14f-4af7-42e3-88cd-6ab65d1f7b05"],
Cell[45822, 1475, 218, 6, 70, "Output",ExpressionUUID->"dc72bf8e-e83f-4365-b19b-2b48a4596431",
 Evaluatable->False]
}, Open  ]],
Cell[46055, 1484, 231, 6, 70, "CodeCaption",ExpressionUUID->"4853d53c-311e-42cd-a756-53e9e131f615",
 CellTags->"i:18"],
Cell[CellGroupData[{
Cell[46311, 1494, 339, 7, 70, "Input",ExpressionUUID->"c2d5d2f2-931f-4d85-84c5-76e1fa0ecac9"],
Cell[46653, 1503, 922, 16, 70, "Output",ExpressionUUID->"017a3e9b-f0a8-452c-94cb-528707f890a0",
 Evaluatable->False]
}, Open  ]],
Cell[47590, 1522, 190, 4, 70, "CodeCaption",ExpressionUUID->"3e44a586-4c77-4e85-b700-9af4b2607541"],
Cell[CellGroupData[{
Cell[47805, 1530, 284, 6, 70, "Input",ExpressionUUID->"6fe3bd7e-5ba6-4500-9d9c-e836f9c1f5d8"],
Cell[48092, 1538, 287, 7, 70, "Output",ExpressionUUID->"c3594d8c-959c-4c3d-ae10-7dc5208e63bc",
 Evaluatable->False]
}, Open  ]],
Cell[48394, 1548, 343, 11, 70, "Text",ExpressionUUID->"050db292-e73c-4abf-80b1-5dbf98e00798",
 CellTags->"i:19"],
Cell[48740, 1561, 297, 9, 70, "CodeCaption",ExpressionUUID->"28ecc4a8-604f-4cde-aa00-79f276521e5f"],
Cell[CellGroupData[{
Cell[49062, 1574, 262, 7, 70, "Input",ExpressionUUID->"1d165fa9-f436-438e-b19a-1a33592aa820"],
Cell[49327, 1583, 295, 8, 70, "Output",ExpressionUUID->"df9f2f3b-ed39-4b11-be92-2a4623c1cd84",
 Evaluatable->False]
}, Open  ]],
Cell[49637, 1594, 291, 9, 70, "CodeCaption",ExpressionUUID->"38b45c34-fa8a-48dc-81b5-d87307c9a5e3"],
Cell[CellGroupData[{
Cell[49953, 1607, 244, 6, 70, "Input",ExpressionUUID->"a83da58c-039a-4323-b14f-0cf288537780"],
Cell[50200, 1615, 450, 9, 70, "Output",ExpressionUUID->"0068b4de-742e-46ca-a8b6-443dda516495",
 Evaluatable->False]
}, Open  ]],
Cell[50665, 1627, 187, 4, 70, "CodeCaption",ExpressionUUID->"ddcec93f-22e3-4c17-9402-095e5e7d4b3a"],
Cell[CellGroupData[{
Cell[50877, 1635, 284, 7, 70, "Input",ExpressionUUID->"b03d75d9-1430-4ae9-9aaa-6d9de349ed80"],
Cell[51164, 1644, 199, 4, 70, "Output",ExpressionUUID->"4670fad4-a968-45d9-b45e-8fe5814af880",
 Evaluatable->False]
}, Open  ]],
Cell[51378, 1651, 432, 12, 70, "Text",ExpressionUUID->"48b69621-b517-4e94-a9e3-e6e8fa68299b",
 CellTags->"LastCellOfAPage"],
Cell[51813, 1665, 331, 12, 70, "Text",ExpressionUUID->"569ae83e-1c1e-4ff3-9268-9df45efba35c",
 CellTags->{"p:182", "i:20"}],
Cell[52147, 1679, 234, 7, 70, "CodeCaption",ExpressionUUID->"8eba414b-e90e-4af2-a16b-2bf76416af3f"],
Cell[CellGroupData[{
Cell[52406, 1690, 229, 5, 70, "Input",ExpressionUUID->"fe188099-6d88-4a0d-8d50-269b254dd7be"],
Cell[52638, 1697, 28314, 757, 70, "Output",ExpressionUUID->"9697afc9-42ac-4f19-87f4-2384b021aca6",
 Evaluatable->False]
}, Open  ]],
Cell[80967, 2457, 392, 12, 70, "CodeCaption",ExpressionUUID->"54ea5451-a2b6-4bb0-9a7f-3bd9ee691de8",
 CellTags->"i:21"],
Cell[CellGroupData[{
Cell[81384, 2473, 224, 5, 70, "Input",ExpressionUUID->"9f1b285a-51f1-49eb-8784-109944d4c428"],
Cell[81611, 2480, 18938, 511, 70, "Output",ExpressionUUID->"b5ec3653-e951-4c01-9a0e-0e24868593b4",
 Evaluatable->False]
}, Open  ]],
Cell[100564, 2994, 315, 9, 70, "Text",ExpressionUUID->"99f2a01d-f5b1-4818-999c-f6ddda96293a",
 CellTags->"i:22"],
Cell[100882, 3005, 202, 5, 70, "CodeCaption",ExpressionUUID->"2be49263-ef0b-4608-87ff-4b9933631ef7"],
Cell[CellGroupData[{
Cell[101109, 3014, 235, 6, 70, "Input",ExpressionUUID->"c3bee2e6-2f5a-431b-a6b5-6281fde38190"],
Cell[101347, 3022, 37668, 1007, 70, "Output",ExpressionUUID->"74da462a-4bc0-4499-96eb-99b5080146d8",
 Evaluatable->False]
}, Open  ]],
Cell[139030, 4032, 281, 10, 70, "Text",ExpressionUUID->"417a256a-ff55-470a-bd2d-8ccc3d49c0ce",
 CellTags->"i:23"],
Cell[139314, 4044, 183, 4, 70, "CodeCaption",ExpressionUUID->"a90b018e-4cae-43ad-903c-f01693ffcea5"],
Cell[CellGroupData[{
Cell[139522, 4052, 229, 5, 70, "Input",ExpressionUUID->"eef9f7ad-36ec-4cb2-b8f4-ac5b91a0fc2e"],
Cell[139754, 4059, 1591, 45, 70, "Output",ExpressionUUID->"f813acdf-29d5-450c-bea9-6328e32ab259",
 Evaluatable->False]
}, Open  ]],
Cell[141360, 4107, 176, 4, 70, "CodeCaption",ExpressionUUID->"45922204-9d4d-41f3-b4a6-7b053e21e5d7"],
Cell[CellGroupData[{
Cell[141561, 4115, 258, 7, 70, "Input",ExpressionUUID->"c622bed4-0d2e-457a-9c15-b5c69f0cabf0"],
Cell[141822, 4124, 29532, 827, 70, "Output",ExpressionUUID->"354aa7a7-5ae9-42c5-b760-b5d8e3845dfa",
 Evaluatable->False]
}, Open  ]],
Cell[171369, 4954, 176, 4, 70, "CodeCaption",ExpressionUUID->"a074f3c8-2eb9-491a-9a02-cd624dedc97a"],
Cell[CellGroupData[{
Cell[171570, 4962, 303, 8, 70, "Input",ExpressionUUID->"1c4dd1a2-7095-49f2-bd8c-460a45125d64"],
Cell[171876, 4972, 23637, 632, 70, "Output",ExpressionUUID->"2b17bd04-c0b5-4a42-b76d-181d4d314efc",
 Evaluatable->False]
}, Open  ]],
Cell[195528, 5607, 318, 9, 70, "Text",ExpressionUUID->"9ca45ddf-45b6-4ccc-9ca8-584c15fef385",
 CellTags->"i:24"],
Cell[195849, 5618, 235, 7, 70, "CodeCaption",ExpressionUUID->"6c8aa36c-d4e5-4168-ae9f-74b7fbcfb152"],
Cell[CellGroupData[{
Cell[196109, 5629, 222, 5, 70, "Input",ExpressionUUID->"ab5315fd-a5a8-4bbd-b5b4-a6870e2a1ed9"],
Cell[196334, 5636, 430, 10, 70, "Output",ExpressionUUID->"a16c3b81-07a5-4bd4-8e66-94d062cc670c",
 Evaluatable->False]
}, Open  ]],
Cell[196779, 5649, 257, 7, 70, "CodeCaption",ExpressionUUID->"f22e0f6f-98ca-4240-af51-756a2b7664c9"],
Cell[CellGroupData[{
Cell[197061, 5660, 196, 4, 70, "Input",ExpressionUUID->"20ebd000-a8b6-447e-bb55-dd87ae4c937f"],
Cell[197260, 5666, 336, 9, 70, "Output",ExpressionUUID->"ab8f3322-f09d-46b1-8f0d-81d9aeea586f",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[197645, 5681, 176, 4, 70, "VocabularySection",ExpressionUUID->"8e0aea5a-5a60-4e84-afe4-55fd5fe246ae",
 CellTags->"p:183"],
Cell[197824, 5687, 9389, 263, 70, "VocabularyTable",ExpressionUUID->"3aedd571-f8e6-47d7-a60a-17d0abf73573",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[207250, 5955, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"c938020b-9ba6-4cac-9018-93d6ed5eb7df"],
Cell[CellGroupData[{
Cell[209055, 6005, 1453, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"abc41054-be9c-48a1-a369-2541d09d0e41"],
Cell[CellGroupData[{
Cell[210533, 6054, 815, 24, 70, "Exercise",ExpressionUUID->"d7120b93-ad0e-44da-b10d-52f030a7b30c"],
Cell[211351, 6080, 3988, 87, 70, "ExerciseOutput",ExpressionUUID->"6284e50b-3620-4e56-9384-f0278309cdc9"]
}, Closed]],
Cell[CellGroupData[{
Cell[215376, 6172, 728, 20, 70, "Exercise",ExpressionUUID->"3590d512-b56b-4e90-b0d5-ca2545eb293b"],
Cell[216107, 6194, 2053, 54, 70, "ExerciseOutput",ExpressionUUID->"6fe54f4d-3e99-425b-af12-9f091d1f0be6"]
}, Closed]],
Cell[CellGroupData[{
Cell[218197, 6253, 761, 21, 70, "Exercise",ExpressionUUID->"4b4b4a14-ba8f-461d-b27d-1c0215744a1f"],
Cell[218961, 6276, 5193, 93, 70, "ExerciseOutput",ExpressionUUID->"3feda60d-633e-4eec-b04a-11796deeaf91"]
}, Closed]],
Cell[CellGroupData[{
Cell[224191, 6374, 853, 22, 70, "Exercise",ExpressionUUID->"e14d3cae-ef03-4ce4-91c1-677e2611dec0"],
Cell[225047, 6398, 11602, 185, 70, "ExerciseOutput",ExpressionUUID->"4f825f31-2d25-49a1-997c-d894b7c59e62"]
}, Closed]],
Cell[CellGroupData[{
Cell[236686, 6588, 834, 24, 70, "Exercise",ExpressionUUID->"335e0c26-6efd-47fe-a007-8e3a2343e79a",
 CellTags->"i:25"],
Cell[237523, 6614, 6897, 140, 70, "ExerciseOutput",ExpressionUUID->"6eac1ad6-9606-4027-b1d7-d040452ab4b4"]
}, Closed]],
Cell[CellGroupData[{
Cell[244457, 6759, 1847, 59, 70, "Exercise",ExpressionUUID->"d8518d6e-d5e9-4815-8219-21945099bb00",
 CellTags->"i:26"],
Cell[246307, 6820, 6970, 164, 70, "ExerciseOutput",ExpressionUUID->"e6af9103-e865-44fa-97db-be291648f020"]
}, Closed]],
Cell[CellGroupData[{
Cell[253314, 6989, 1496, 47, 70, "Exercise",ExpressionUUID->"4b3920f5-2fe9-43ad-aaeb-59b6ce152d1a",
 CellTags->"i:27"],
Cell[254813, 7038, 3600, 92, 70, "ExerciseOutput",ExpressionUUID->"fc7d988d-110d-4700-8b25-4f34deac51e6"]
}, Closed]],
Cell[CellGroupData[{
Cell[258450, 7135, 1027, 30, 70, "Exercise",ExpressionUUID->"d9373a53-a8ef-4cae-b2a9-12c5d6aa054c"],
Cell[259480, 7167, 3525, 67, 70, "ExerciseOutput",ExpressionUUID->"c0db4dca-6336-42f0-b714-c8d010130349"]
}, Closed]],
Cell[CellGroupData[{
Cell[263042, 7239, 767, 21, 70, "Exercise",ExpressionUUID->"f1368f2f-6b08-42e5-bee7-969ff3d74a04"],
Cell[263812, 7262, 9870, 200, 70, "ExerciseOutput",ExpressionUUID->"967ff9cb-5a34-43a4-b559-3496bc6c0003"]
}, Closed]],
Cell[CellGroupData[{
Cell[273719, 7467, 891, 26, 70, "Exercise",ExpressionUUID->"a9f3ea33-78ad-4661-ba4b-615e360d71f5"],
Cell[274613, 7495, 3818, 74, 70, "ExerciseOutput",ExpressionUUID->"956dbf10-2a5c-4e77-be02-e58d4a320034"]
}, Closed]],
Cell[CellGroupData[{
Cell[278468, 7574, 732, 20, 70, "Exercise",ExpressionUUID->"f5f1f9a2-0d83-4600-bb16-00294987b5b1"],
Cell[279203, 7596, 1695, 43, 70, "ExerciseOutput",ExpressionUUID->"51cb7e5b-a0d4-4c31-9c4c-3a47094fccca"]
}, Closed]],
Cell[CellGroupData[{
Cell[280935, 7644, 729, 20, 70, "Exercise",ExpressionUUID->"73b50c6b-1ca3-4b3a-af9c-6dbc5b8f78a7"],
Cell[281667, 7666, 1660, 43, 70, "ExerciseOutput",ExpressionUUID->"5b32196e-80cc-499b-8c40-6161f3d62f1c"]
}, Closed]],
Cell[CellGroupData[{
Cell[283364, 7714, 920, 26, 70, "Exercise",ExpressionUUID->"eb6ea61c-7671-4f1e-8776-6a4f2350c866"],
Cell[284287, 7742, 3167, 77, 70, "ExerciseOutput",ExpressionUUID->"aeaae73a-fc82-47d6-bb54-7a41826f8016"]
}, Closed]],
Cell[CellGroupData[{
Cell[287491, 7824, 720, 20, 70, "Exercise",ExpressionUUID->"a6025856-766c-4815-83a6-cd4d7351159e"],
Cell[288214, 7846, 1349, 38, 70, "ExerciseOutput",ExpressionUUID->"958851df-ae9d-4c31-b6f2-d7ba0b99a2bc"]
}, Closed]],
Cell[CellGroupData[{
Cell[289600, 7889, 796, 23, 70, "Exercise",ExpressionUUID->"e4e811c8-dee9-40f4-a22b-ae2e4a1b18c4"],
Cell[290399, 7914, 1246, 36, 70, "ExerciseOutput",ExpressionUUID->"8c393eea-2bda-4926-bff2-c0fdfd755964"]
}, Closed]],
Cell[CellGroupData[{
Cell[291682, 7955, 742, 20, 70, "Exercise",ExpressionUUID->"6a712fea-caf9-4f81-99fe-712410845d63",
 CellTags->"i:28"],
Cell[292427, 7977, 4224, 96, 70, "ExerciseOutput",ExpressionUUID->"455d660a-6355-4947-b4c0-fd63b47ceae2"]
}, Closed]],
Cell[CellGroupData[{
Cell[296688, 8078, 771, 21, 70, "Exercise",ExpressionUUID->"2b01a72d-a9f1-497f-88fd-439b92ad4846"],
Cell[297462, 8101, 2594, 59, 70, "ExerciseOutput",ExpressionUUID->"bf6fd317-fbdd-4854-8945-99edc1dd5519"]
}, Closed]],
Cell[CellGroupData[{
Cell[300093, 8165, 814, 21, 70, "Exercise",ExpressionUUID->"ef34e87b-218a-425d-a9bb-072a41de2091"],
Cell[300910, 8188, 4023, 75, 70, "ExerciseOutput",ExpressionUUID->"010a8e60-15db-45eb-b59c-086bbcdb408a"]
}, Closed]],
Cell[CellGroupData[{
Cell[304970, 8268, 733, 20, 70, "Exercise",ExpressionUUID->"ce24c51d-6ae5-4342-89d9-85550a17ec6c"],
Cell[305706, 8290, 3143, 67, 70, "ExerciseOutput",ExpressionUUID->"a0002aef-b7aa-47f2-b996-cdb5658ebdd1"]
}, Closed]],
Cell[CellGroupData[{
Cell[308886, 8362, 718, 20, 70, "Exercise",ExpressionUUID->"c6545981-c28a-412d-b630-f17a5b53fddf"],
Cell[309607, 8384, 1636, 41, 70, "ExerciseOutput",ExpressionUUID->"16f2231e-4cad-4aa3-a91e-57c5410b4bc4"]
}, Closed]],
Cell[CellGroupData[{
Cell[311280, 8430, 1275, 40, 70, "Exercise",ExpressionUUID->"9138ee94-0d26-4d58-b19f-f002774fb9be",
 CellTags->"LastCellOfAPage"],
Cell[312558, 8472, 2522, 68, 70, "ExerciseOutput",ExpressionUUID->"2b1790ce-f529-40ca-8299-e1d33491ac80"]
}, Closed]],
Cell[CellGroupData[{
Cell[315117, 8545, 860, 22, 70, "Exercise",ExpressionUUID->"e85e4837-b682-412f-8ca1-f688a51ed011"],
Cell[315980, 8569, 3056, 71, 70, "ExerciseOutput",ExpressionUUID->"d376550e-e820-4f93-825f-645b29128f96"]
}, Closed]],
Cell[CellGroupData[{
Cell[319073, 8645, 733, 20, 70, "Exercise",ExpressionUUID->"15e59e5f-f56b-4cfa-b2ca-a8550aaa72a1"],
Cell[319809, 8667, 2351, 63, 70, "ExerciseOutput",ExpressionUUID->"e2a56ea7-5317-4770-bcd1-2cb0a6a608a4"]
}, Closed]],
Cell[CellGroupData[{
Cell[322197, 8735, 729, 20, 70, "Exercise",ExpressionUUID->"26b89093-7a7b-4913-a82c-4da8933f4152"],
Cell[322929, 8757, 3846, 87, 70, "ExerciseOutput",ExpressionUUID->"b20d8d9c-35f5-4393-b027-002c52b713e2"]
}, Closed]],
Cell[CellGroupData[{
Cell[326812, 8849, 770, 21, 70, "Exercise",ExpressionUUID->"966e34c2-00b0-4065-9401-8cb506bd9630"],
Cell[327585, 8872, 3348, 82, 70, "ExerciseOutput",ExpressionUUID->"4625776f-e146-42f0-8346-6346cdc468ef"]
}, Closed]],
Cell[CellGroupData[{
Cell[330970, 8959, 752, 21, 70, "Exercise",ExpressionUUID->"5fe53764-7308-46b5-aa9a-d3ef39f79a10"],
Cell[331725, 8982, 5665, 120, 70, "ExerciseOutput",ExpressionUUID->"a9e75997-e8b2-45b6-a673-8f4544193d5f"]
}, Closed]],
Cell[CellGroupData[{
Cell[337427, 9107, 755, 21, 70, "Exercise",ExpressionUUID->"272b1f78-50b1-49ec-89a9-bbca6e2d99e5"],
Cell[338185, 9130, 5747, 126, 70, "ExerciseOutput",ExpressionUUID->"9d057044-73b7-44f7-8ae2-e7b2a5583fa9"]
}, Closed]],
Cell[CellGroupData[{
Cell[343969, 9261, 874, 26, 70, "Exercise",ExpressionUUID->"d3c6fba4-277a-41cd-84b7-bbf404e46364"],
Cell[344846, 9289, 2534, 56, 70, "ExerciseOutput",ExpressionUUID->"77dea5d6-7071-4e9b-a084-a9b3e56e7739"]
}, Closed]],
Cell[CellGroupData[{
Cell[347417, 9350, 820, 22, 70, "Exercise",ExpressionUUID->"2da9d0b6-fcbc-48c7-a616-b69f4cc4fd2e"],
Cell[348240, 9374, 1095, 31, 70, "ExerciseOutput",ExpressionUUID->"6eac75a6-633d-41b9-a62d-a36cb8a3f8dc"]
}, Closed]],
Cell[CellGroupData[{
Cell[349372, 9410, 728, 20, 70, "Exercise",ExpressionUUID->"3a66ae81-4e6d-4bc0-91af-9381ef9f3ea5"],
Cell[350103, 9432, 1818, 45, 70, "ExerciseOutput",ExpressionUUID->"3af95353-be0b-4f9d-8bc8-a41f07930fc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[351958, 9482, 753, 21, 70, "Exercise",ExpressionUUID->"e22f5c14-c7eb-4e80-8558-7a8949b3d659"],
Cell[352714, 9505, 2163, 55, 70, "ExerciseOutput",ExpressionUUID->"749881bc-0cc3-406f-92b8-6327d0735e8d"]
}, Closed]],
Cell[CellGroupData[{
Cell[354914, 9565, 726, 20, 70, "Exercise",ExpressionUUID->"340df7d3-4fa5-4489-9318-37710d8ed45b"],
Cell[355643, 9587, 36141, 830, 70, "ExerciseOutput",ExpressionUUID->"0d263db8-9af3-424f-ac12-6a55836ca703"]
}, Closed]],
Cell[CellGroupData[{
Cell[391821, 10422, 782, 21, 70, "Exercise",ExpressionUUID->"7dfea61c-2da1-4931-890e-1b1beabe293a"],
Cell[392606, 10445, 7315, 176, 70, "ExerciseOutput",ExpressionUUID->"90f35eef-251a-470d-8bc3-4191d7d097e5"]
}, Closed]],
Cell[CellGroupData[{
Cell[399958, 10626, 930, 27, 70, "Exercise",ExpressionUUID->"66e9a863-e390-43e3-a8f9-3b5de9a69c5b"],
Cell[400891, 10655, 1372, 38, 70, "ExerciseOutput",ExpressionUUID->"3780bab1-6755-44a6-b974-3bce87b50944"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[402324, 10700, 161, 4, 70, "QASection",ExpressionUUID->"ab9d1cec-4ceb-4810-b633-13dbd5e4fa1c",
 CellTags->"p:185"],
Cell[402488, 10706, 271, 9, 70, "Question",ExpressionUUID->"4c0aa9a4-7e25-49ff-aa60-2faa64734662"],
Cell[402762, 10717, 844, 22, 70, "Answer",ExpressionUUID->"8d9e912b-df0c-4519-8336-69d2b7ad79d0",
 CellTags->"i:29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[403643, 10744, 156, 4, 70, "TechNoteSection",ExpressionUUID->"d899484b-31d2-4bb8-8c99-bd353010ca42"],
Cell[403802, 10750, 280, 8, 70, "TechNote",ExpressionUUID->"8a44b516-cb23-49af-87c7-dff12ee692f3",
 CellTags->"i:30"],
Cell[404085, 10760, 332, 9, 70, "TechNote",ExpressionUUID->"7652986e-91e4-47b8-90db-3a36134b1d5f",
 CellTags->"i:31"],
Cell[404420, 10771, 659, 19, 70, "TechNote",ExpressionUUID->"c62b4ce4-6261-401b-881e-cbc14c9af288",
 CellTags->"i:32"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405116, 10795, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"0a961737-910c-4eb8-8696-db284d733641"],
Cell[405284, 10801, 382, 9, 70, "MoreExplore",ExpressionUUID->"e00cf606-4bd8-418b-b6c9-9355fae03d1c",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature #JjpYgIri94fbLOLtuItUo@3 *)
