(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    190447,       4048]
NotebookOptionsPosition[    125651,       2698]
NotebookOutlinePosition[    184414,       3906]
CellTagsIndexPosition[    184335,       3901]
WindowTitle->More about Pure Functions: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Use ",
 StyleBox["Prime",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Array",
  FontFamily->"Source Sans Pro"],
 " to generate a list of the first 100 primes."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "29.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"64153489-0731-43bb-aed4-52d1f8b0af1a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c71c50a8-b37a-4188-8d81-23ba04933896"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT3L61p2x52kSZmvkC/gOq3LVIYJ6dzMkOshzY25Ewhu3VxcqgkuBlx5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            "], {{0, 130}, {455, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{455, 130},
          PlotRange->{{0, 455}, {0, 130}}]], "ExerciseOutput",
         ImageSize->{459, 130},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "29bd209f-0177-4992-9568-9c5ed5e27231"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT3L61p2x52kSZmvkC/gOq3LVIYJ6dzMkOshzY25Ewhu3VxcqgkuBlx5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              "], {{0, 130}, {
              455, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {455, 130}, 
            PlotRange -> {{0, 455}, {0, 130}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"25417e96-b3df-4896-b7b9-aff6774a2675"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["29.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"69582cec-f432-44bb-9f6d-96d4c599a15e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ceafb36f-ce3c-456e-a58f-e596add6519a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"17dac7d6-50ee-4e78-afa6-9e321ac1bcab"],

Cell[TextData[{
 "Use ",
 StyleBox["Prime",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Array",
  FontFamily->"Source Sans Pro"],
 " to find successive differences between the first 100 primes."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "29.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"9df08844-996a-4a98-8ee6-73707e9b2d8f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"265f76d6-fe1e-41b6-bf16-cd3ea5224189"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztna+zrMoRx0liIvMv5B9ARwYZtVUv9dya9yqXVzE3W/elKrUWh8ThVqFW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            "], {{0, 
            64}, {475, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{475, 64},
          PlotRange->{{0, 475}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{479, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "56333d4d-fa71-4b7c-8275-2278506663fd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztna+zrMoRx0liIvMv5B9ARwYZtVUv9dya9yqXVzE3W/elKrUWh8ThVqFW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              "], {{0, 
              64}, {475, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {475, 64}, 
            PlotRange -> {{0, 475}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0ead7cf0-aee1-4b89-80e3-8b2101f76b39"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["29.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"05b66d73-026f-467f-b15d-c38849dc9c85"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ab12d217-a12c-4743-ad30-18d3a36865a7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"62c0d0c5-f4eb-49fe-ab29-0cb3a4d26337"],

Cell[TextData[{
 "Use ",
 StyleBox["Array",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Grid",
  FontFamily->"Source Sans Pro"],
 " to make a ",
 "10 by 10",
 " addition table."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "29.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"1d467f52-802e-4447-8a9b-bb892f86cc94"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"747c0a52-f2bb-473b-b7b8-73b74b3a1d51"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb+PpMgZhlt24tD/gv+Bji8ldIR0lrNO7uTrk5Nz686S1SkZIRkZERER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            "], {{0, 187}, {230, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{230, 187},
          PlotRange->{{0, 230}, {0, 187}}]], "ExerciseOutput",
         ImageSize->{234, 187},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "831665e2-22e2-42ad-a445-0fe3ae69ecf1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb+PpMgZhlt24tD/gv+Bji8ldIR0lrNO7uTrk5Nz686S1SkZIRkZERER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              "], {{0, 187}, {230, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {230, 187}, 
            PlotRange -> {{0, 230}, {0, 187}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"19d5ea66-8460-46b3-b6e0-4dc26f0e1811"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["29.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"37c7db64-0a5d-4a11-b657-a5c4cb265225"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e30f42ae-beb8-4781-9bbd-b259d5a18e7f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f097b004-6254-4b8c-8d24-ab3c7fe70a7a"],

Cell[TextData[{
 "Use ",
 StyleBox["FoldList",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Times",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " to successively multiply numbers up to 10 (making factorials)."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "29.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"f9699c38-fc94-4e69-8ad7-d8edc7c83260"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"170c9711-b382-4760-aa21-703774245555"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWr+rpUYUNkmTMpC/IP+AbdJaphIS0t1ml6xLmo3sBoKtnaWdnZWVlZWV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            "], {{0, 19}, {311, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{311, 19},
          PlotRange->{{0, 311}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{315, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6e390bb1-5f83-4171-882d-1ae5bdf14e51"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWr+rpUYUNkmTMpC/IP+AbdJaphIS0t1ml6xLmo3sBoKtnaWdnZWVlZWV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              "], {{0, 19}, {311, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {311, 19}, 
            PlotRange -> {{0, 311}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8f40c49c-af80-42e1-9046-86d3f2995851"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["29.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"aac228bf-7be5-4d91-99ed-fac29fdc9a34"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5d615b6b-3f5b-409a-8369-0d38d0831600"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e42da305-ff29-466d-bf2d-e9c5d65533aa"],

Cell[TextData[{
 "Use ",
 StyleBox["FoldList",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Array",
  FontFamily->"Source Sans Pro"],
 " to compute the successive products of the first 10 primes."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "29.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"afb5d2a6-fcc2-4eb2-8a30-54c0b869ef4f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3b73af06-952f-4590-9ef9-1c1b68d230ae"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW7/vpLgVJ0mTMlL+gvwD1GkpUyFdlG6aO91ySrNBe5EiWjpKOjoqpEhU
VFQ0VDQ0jiI3KEKRSEFBJBoKF3N+NjDMYDNmmLvbPfGkXc14np/f5/3ys+H7
h2/+9pX1a03Tvv8t/e+rr/9hfPr0tfPn39Evf/n4/V+/+/jh2z99/PuH7z58
+uM3v6GDv6f//vkrTYPP15NOOumkk0466aSTTjrppJNOOumkk0466cumLvUs
XbfRwL/2FUJ1T7Zm9E2RJnGcFLjdFk26OqecSYrbQco0tEUGPAVuFjPbPI2j
OEGNfKJcE7ouQlV/N/S6wL5BDERe3aN4fZX9kOsyo79lZf1Eq+cKkAajG+F6
5tsD5y1CltSX1CBxWtadQONVFJGu4vZr+iWbYHCXhCNBQnGnMR3L6o4sGMWR
w2ntU6FWQsmcGlSA1QrMpbcVuic85rEirucJ2+GSuuj2U4vLFFQrZ9WOe2HL
aOrp+Qi5jyzDuLhFOyrao0DTNMtLGnKtYkdj5BWC8BuRo1hnPPx/O8Yyzh5H
2oIiLLAkaTJzIc30cqZW7RnzPD2pxM6SaDIkNp+sFzdjviyQlKG9GNNC1B1c
5QXIZXCZJ1zCUq6VigK9ry/dYpT9C3DeImS2yMijM5lOWi9/XEfRgLmbRvvl
LJKFg7skHIm6MrRuADQjo7kk9ZHMp2IIIsmchoypa5hMaTsZHp0C0/JeFZfQ
UA8MhQ+Rq3vF+JVDGMmpyHEvbBltT3quIROchpeF8n3pa5rPEdZZ5NoALSil
da+K6GyPtSm0hFJeT9Lzdb7BrAGiu9gLRGWPFoHU0N2KmYf50aAp02RQfmMY
reGTlQi7T4kmQxZ6jkXtYJZT9h0RiEPL9JmtSAVznex6bJXdkPuCMpkBpEYB
NjVpZy7USk2BPjA0M0R0JqPrS3DeImTNQxKHTrcXhW8dRUNkQviCm3pEvaS7
OV1aNLhLwpEgGUJjdNC1K+jPhg+fJZEj86kYl1DyLMHNGvaLP+41hEz+aDxq
SCselHE9TdihinkdGfVpUm3atUmTewH98AYvbBhNPT1lkHFoaro/Ni4I6t6i
zcRUHV9e9+ii3XQK7gqPp+2aSJOAZsLfJNTlLpNGElrCjYDPxADWEtbMDU0I
DqcmBL4dF8h/pUPaJbqd6V5cZR/kgTXkGd9dWLD55VKtWStFBVrKH2BB7O+B
8xYhI5U0JaZo5ABDPM0XRBGUXH1Kfwx7uNuIB3dJOBQkpJ/Pfr2/rE7T4EPk
iHz6PyEEqeS+pIXEyZnZCDLueuxrB82MloIJVHE9S1hWSI3LRR91qGJaei73
IXDcC1tGU05PKWQES47jUEXnqKM0gD03696NIGIftZ2UAMubOabdZRhGKV5d
Tdwxtw3KY2iarainBtFv/mURIi6tG5qww/ucfYcFkr6tqyxk+0lS3dQ+sIo6
ZBZgU1NNKmuue49aqSnQl+yscrEty/UjvDyJqMN5i5A7U3tjwHX5MvxEUdRR
mXO+NBnfOISDuyS8Ieq4PCpuFi6LHJFP/yuDIJZ8bdmxzcpwXcBZ2KkXTgiM
uVNSxbWdsAgW09K6iUyuA0lt2qFlNc7CIIhT7vDjXtgymtTyyomAWa2jH7sq
g9I4nXkZn2rdI3XCslZ8v8evDYHBcS9w+DYy6TMQ5iZGbF34Oqt9n0eqmjxm
3zGBzGuc7OVeeWCVHZBZOxRM3+DgYwRIpJWaAqRyDd3ywjSN4EiqmfNV7g44
bxEy0VBFrIi6QeDya5pgni+KojKAomt7ge/y+6ULZRcO7pHwhqi7jvVBT6db
OFnkCH0qgyCUTKlO7Em4Zka3+kDYgTQe66Aqro2E5Ugd1j4yVTGINceVHZep
YYbd9bgXtowms7x6InDLeAmGzlDTs2WRU6x77LaBdpWy0OBIY36Nda1sjV8H
SYkMbeqDyKT+/76dV6TJoX5PDI30TQlpaczherSrVIQMvcGtIa+pJb2bd5Za
7e9YulxfPMN6Ec47hHRV7ruO4wZ5kRgLgJIoGlAaUXZad8vMg+vE4SoZVJfw
hiBpQNS6RRFEjsSnYghCyQPcJ2gRaklfRY7JomgsifdnRuV+T5qwfchKnO35
vu+yj2aQ/Rs27kvY3eZysQe9sGW0DcsrJ8IQsJ2VdBiY3cWNK0Fwv4c2E6Yt
4FrR8DfeYmHL6fkUv8ue9oFxgRVBzBdtCj1oyMcruMG0RDdJW5oMmGXf9LT8
iECyULBNnWXYvLrKPshslcmSbQbtEOpFWikqQBbnoWJZZPbAeYsQkWnY3p1M
Xc3TKIIL7Em+cFBZwqEgucIzQShN1mJzfxY5jz6VQVhLvvIres2d5nTe7eqP
lSknnd8rUcQlN9SQR4EfBD6QZ7L2PsxraFmNgIsldbwupy95YctobEglPaWQ
+WYRFrAnVHDJxLeeAV7/yeEnJ8oxYm++EOzQ4ummtyvZJuNdaZCVqCyLoqjo
aX3Fxq8jtEuA27Zkr8fAZfWKDTTUnQw3XVsnHmwmUTXw3cFNUFvBWuNTITVN
aN1HCOcRyA3zEmFIodcFtv+6wEOruGq7psodA55AtWx3eXmVHZBH18L9D23r
67ZmLzXYNcFCrQRCVquzK1+3qJqWRi6ghaPTDjjHhaxUIm1uX9wc11UZs5PP
8oGjIIpw7FpeUjV1HsGIl0MSCAd3STgSdVXi8nNWjvgY6gaxj6Q+lUAQSGbW
YRdi9MiG+mGoctCc7p5M9N0pTx2XOGEficzXLPx2wo6Krqs4BNrNHfWCJLD3
pqcsdNmzjGAqxdPz3KE0tTuC+/MBsbi+PfBFwQMXO+Os2K7sRbX5/R4nKvli
D2wD7U4v81tHup+Onfz42hLsLf7Yv6tpsjjsjyK7YwLrPLy9CmTYOXsN8sgq
OyDPoYvjSQcjYS8FC7USCFmt3te5c0NphCxZdsA5LmSlEqGb+GQP3QoesK+j
CCeedj8iG9wl4UCQ/CcwHsagS5H5SOZTkVadUDKHlQfWPGoF+WQ2eHPj4YGy
Ci6hoVY0v7/Ebe5O7GaCZRD2eWHDaOrpKYZ8/zyXhau3cayFhlBfnbJV2Ujf
df1AttnIAFwP3TeM3Q8qaiKjIwL7vuv7Z2+l7FlFEfJiAtXg8TehVg9CpKv3
23+T81yll4UIVWIs0r8xeYgiurZALeHgLgk/QtRtRc7ap1sQhBJYGCkEpjKu
laGeKABy7/+K6Q1eUE+3Df41ZAyt8AiZn3mN1T7LqYFTmRahJ4853sv29rk/
jcCfcZXPc3UhfYYqbdCXpa06/VJxyWko2Isui054KCLPslzxI+O+qZ79Td/b
2d4+96cR+DOu8nmuLqTPUKUN+rK0VadfKi45Daln225Yvdy4n3TSSSeddNJJ
J5305dAP9OTX3g==
            "], {{0, 19}, {424, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{424, 19},
          PlotRange->{{0, 424}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{428, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fa5b27bb-67db-4ef6-8a23-e13546004efc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW7/vpLgVJ0mTMlL+gvwD1GkpUyFdlG6aO91ySrNBe5EiWjpKOjoqpEhU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              "], {{0, 19}, {424, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {424, 19}, 
            PlotRange -> {{0, 424}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"eef1828b-2259-460f-93e1-ed484e344794"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["29.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1996a11a-96d0-44ff-9d25-45750eb0e35f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9791e65b-3b1c-4560-8514-846bd527a365"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1b0c12c8-d5fd-4a70-b203-557aa5869a93"],

Cell[TextData[{
 "Use ",
 StyleBox["FoldList",
  FontFamily->"Source Sans Pro"],
 " to ",
 "successively ",
 StyleBox["ImageAdd",
  FontFamily->"Source Sans Pro"],
 " regular polygons",
 " with between 3 and 8 sides, and with opacity 0.2."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "29.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"89835d56-5cb9-436c-aa0e-7aa51dee7f64"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eb33f1b1-8cb2-4dbe-bbfa-7a1dcc2ebd1f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnUtoXUeax+/MQDObhoFeZZfZeDZtbbSZ9Kq9aRgIBMbMQmBodzO5zYDT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            "], {{0, 295}, {442, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{442, 295},
          PlotRange->{{0, 442}, {0, 295}}]], "ExerciseOutput",
         ImageSize->{446, 295},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b290e835-be2e-4a39-8d9d-7bdf08a6bad4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnUtoXUeax+/MQDObhoFeZZfZeDZtbbSZ9Kq9aRgIBMbMQmBodzO5zYDT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              "], {{0, 295}, {442, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {442, 295}, 
            PlotRange -> {{0, 442}, {0, 295}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"46dfd919-a205-4592-888b-42e1a858e75c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["29.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b098c7e9-23cf-4f44-a32a-078f34bb18cc"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e981de8e-738e-42df-ad43-31e70f329725"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f8adca4a-83e6-4f3f-b9a8-06eceb21df6c"],

Cell[TextData[{
 "Use ",
 StyleBox["Array",
  FontFamily->"Source Sans Pro"],
 " to make a 10 by 10 grid where the leading diagonal and everything below it \
is 1 and the rest is 0."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+29.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"52920852-15b7-48d1-b209-5f0f4c535e16"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4139894a-5d12-47c4-b51f-6f29586d9367"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmq9v20AcR62NDO5f2D8QPGo4VKnTWEmrJdVIV7WTptKxwbKwjAQFDQ1M
IUUlJiYhASElBQUhAQHdue2mDUzxXZy7j79+L0pkR35J5IudH/deHX3cHzzL
suz8hbvZP/ycn50dXrx96VbenZx/OD7pv39z8ql/3D97ffTc3fnTXb+5a7V8
/8RyXpaL5fq+NotiOhlPpsUCRVyZTy6yB75e39V8kGJ4UAm96uZgVKAoK4vp
+MvpnrtnWNQb3+V1nmV7w0q/vqwWyxWKuDJzA3xZb3xX5dC9Gaa3Dys3P7JK
XKJIK6sirz2+88nAncsfH+Z+PR/UeGqUxIrP+Bbu2O8N/5ijPMuHJYq04nv8
9i5/b7o4dW+aTSJKYmVdVp+/5YYzwCOrmTvP964e1dtp9cVsk4iSTlm5X77l
1citXoyvZmV5s/F72sO5PRuMF7eLUbV0uvnnGUoqZVXsZf+w8XPcsZxN8qfN
8+/zWkc9iqbyX9bLO3fx+McLRVUBAAAAAAAAMIJ3n0PS0xYloM8h6WmR4t3n
kPS0T/HocwKU9IFKxxWf+f0AJX2g0nFlx+ObPlDpuBLh+G1d02JJ8elzApS2
NS2WFP8+h6SnRUpAn0PSY0hpEtlApeMKAAAAAAAAgBFi9DkkPYb7HJKeVEqM
Poekx3SfE6Ckb1osKTue3w9Q0jctlhS98U3ftFhS9MY3fdNiSdlxnxOgtC2D
kVWi9DkkPamUOH0OSY+qkhjZpsWSAgAAAAAAAGAE0T6HpMdwn0PS04gi2ueQ
9JjucwKU9BmMrKI3vx+gpM9gZBW9wQpQ0mcwsoreYAUo6TMYWUWvzwlQ2lbO
xFFU+xySnkYU2T6HpKcLfU4AshmMrAIAAAAAAABgBNHYhqSHPmdLpV2xTYAi
GtuQ9NDnbK2kL2fiKHqT9XGU9OVMHEVvz8dR0pczcRS9PR9HSV/OxFH0Yps4
SttimwBFNbYh6WlEkY1tSHroc5pCtpyhzwEAAAAAAADwQLSckVXocwwr9DmW
lfSxTYAiV87IKuljmwBFb+ZdVkkf2wQoertRVkkf2wQoertRVkkf2wQoeuWM
rEKfY1yhz7GtCMc29DmNIRvb0OcAAAAAAABAdxHNYCwp9DmGFfocywp9jmmF
Pse2Qp9jW6HPsa3Q59hW6HOMK/Q5thX6nC5AnwMAAAAAAACwW0Sblo4r9DmG
Ffocywp9jmmFPse2Qp9jW6HPsa3Q59hW6HOMK/Q5thX6nC5AnwMAAAAAAADg
gWiggrJ90iMbqKD4KvQ5lhX6HNMKfY5thT7HtkKfY1uhz7Gt0OcYV+hzbCv0
OV2APgcAAAAAAAC6i2htgrK9IluboDSiiNYmKE0qcrUJSpOK3mw1SpNKu14t
iq/SrleL4qvo1SYoDSmqtQlKI4psbYISQQEAAAAAgL/4BStkDZ0=
            "], {{0, 
            187}, {160, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{160, 187},
          PlotRange->{{0, 160}, {0, 187}}]], "ExerciseOutput",
         ImageSize->{164, 187},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "13c6b941-898f-43dd-a641-06b03b1ef1c6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmq9v20AcR62NDO5f2D8QPGo4VKnTWEmrJdVIV7WTptKxwbKwjAQFDQ1M
IUUlJiYhASElBQUhAQHdue2mDUzxXZy7j79+L0pkR35J5IudH/deHX3cHzzL
suz8hbvZP/ycn50dXrx96VbenZx/OD7pv39z8ql/3D97ffTc3fnTXb+5a7V8
/8RyXpaL5fq+NotiOhlPpsUCRVyZTy6yB75e39V8kGJ4UAm96uZgVKAoK4vp
+MvpnrtnWNQb3+V1nmV7w0q/vqwWyxWKuDJzA3xZb3xX5dC9Gaa3Dys3P7JK
XKJIK6sirz2+88nAncsfH+Z+PR/UeGqUxIrP+Bbu2O8N/5ijPMuHJYq04nv8
9i5/b7o4dW+aTSJKYmVdVp+/5YYzwCOrmTvP964e1dtp9cVsk4iSTlm5X77l
1citXoyvZmV5s/F72sO5PRuMF7eLUbV0uvnnGUoqZVXsZf+w8XPcsZxN8qfN
8+/zWkc9iqbyX9bLO3fx+McLRVUBAAAAAAAAMIJ3n0PS0xYloM8h6WmR4t3n
kPS0T/HocwKU9IFKxxWf+f0AJX2g0nFlx+ObPlDpuBLh+G1d02JJ8elzApS2
NS2WFP8+h6SnRUpAn0PSY0hpEtlApeMKAAAAAAAAgBFi9DkkPYb7HJKeVEqM
Poekx3SfE6Ckb1osKTue3w9Q0jctlhS98U3ftFhS9MY3fdNiSdlxnxOgtC2D
kVWi9DkkPamUOH0OSY+qkhjZpsWSAgAAAAAAAGAE0T6HpMdwn0PS04gi2ueQ
9JjucwKU9BmMrKI3vx+gpM9gZBW9wQpQ0mcwsoreYAUo6TMYWUWvzwlQ2lbO
xFFU+xySnkYU2T6HpKcLfU4AshmMrAIAAAAAAABgBNHYhqSHPmdLpV2xTYAi
GtuQ9NDnbK2kL2fiKHqT9XGU9OVMHEVvz8dR0pczcRS9PR9HSV/OxFH0Yps4
SttimwBFNbYh6WlEkY1tSHroc5pCtpyhzwEAAAAAAADwQLSckVXocwwr9DmW
lfSxTYAiV87IKuljmwBFb+ZdVkkf2wQoertRVkkf2wQoertRVkkf2wQoeuWM
rEKfY1yhz7GtCMc29DmNIRvb0OcAAAAAAABAdxHNYCwp9DmGFfocywp9jmmF
Pse2Qp9jW6HPsa3Q59hW6HOMK/Q5thX6nC5AnwMAAAAAAACwW0Sblo4r9DmG
Ffocywp9jmmFPse2Qp9jW6HPsa3Q59hW6HOMK/Q5thX6nC5AnwMAAAAAAADg
gWiggrJ90iMbqKD4KvQ5lhX6HNMKfY5thT7HtkKfY1uhz7Gt0OcYV+hzbCv0
OV2APgcAAAAAAAC6i2htgrK9IluboDSiiNYmKE0qcrUJSpOK3mw1SpNKu14t
iq/SrleL4qvo1SYoDSmqtQlKI4psbYISQQEAAAAAgL/4BStkDZ0=
              "], {{0, 
              187}, {160, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {160, 187}, 
            PlotRange -> {{0, 160}, {0, 187}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8c2cf0ad-7986-47c8-8970-abd4f6e4ebb6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x29.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ac9c9e10-bac2-4f17-a98d-9dba322a85c1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"477198de-9706-4479-8274-5e59cf1dde5a"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a2a2b935-59b9-4ffb-99ed-5771d0bf9373"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"More about Pure Functions: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 29  More about Pure Functions", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
29-more-about-pure-functions.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+29.1", "29.1", "29.2", "29.3", "29.4", "29.5", "29.6"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+29.1", "29.1", "29.2", "29.3", "29.4", "29.5", "29.6"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[26377, 509, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ceafb36f-ce3c-456e-a58f-e596add6519a",
   CellTags->"FirstInputCell"],
  Cell[40459, 828, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ab12d217-a12c-4743-ad30-18d3a36865a7",
   CellTags->"FirstInputCell"],
  Cell[56011, 1175, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e30f42ae-beb8-4781-9bbd-b259d5a18e7f",
   CellTags->"FirstInputCell"],
  Cell[67507, 1455, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5d615b6b-3f5b-409a-8369-0d38d0831600",
   CellTags->"FirstInputCell"],
  Cell[80175, 1752, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9791e65b-3b1c-4560-8514-846bd527a365",
   CellTags->"FirstInputCell"],
  Cell[115811, 2427, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e981de8e-738e-42df-ad43-31e70f329725",
   CellTags->"FirstInputCell"],
  Cell[124523, 2657, 813, 26, 
  70, "Input", "ExpressionUUID" -> "477198de-9706-4479-8274-5e59cf1dde5a",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 183352, 3876}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[648, 22, 569, 17, 70, "Exercise", "ExpressionUUID" -> \
"64153489-0731-43bb-aed4-52d1f8b0af1a",
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1242, 43, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c71c50a8-b37a-4188-8d81-23ba04933896"],
Cell[1881, 64, 23889, 420, 70, "ExerciseOutput", "ExpressionUUID" -> \
"25417e96-b3df-4896-b7b9-aff6774a2675"]
}, Closed]],
Cell[CellGroupData[{
Cell[25807, 489, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"69582cec-f432-44bb-9f6d-96d4c599a15e"],
Cell[26377, 509, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ceafb36f-ce3c-456e-a58f-e596add6519a",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27227, 540, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"17dac7d6-50ee-4e78-afa6-9e321ac1bcab"],
Cell[27514, 551, 586, 17, 70, "Exercise", "ExpressionUUID" -> \
"9df08844-996a-4a98-8ee6-73707e9b2d8f",
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[28125, 572, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"265f76d6-fe1e-41b6-bf16-cd3ea5224189"],
Cell[28764, 593, 11088, 210, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0ead7cf0-aee1-4b89-80e3-8b2101f76b39"]
}, Closed]],
Cell[CellGroupData[{
Cell[39889, 808, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"05b66d73-026f-467f-b15d-c38849dc9c85"],
Cell[40459, 828, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ab12d217-a12c-4743-ad30-18d3a36865a7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41321, 860, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"62c0d0c5-f4eb-49fe-ab29-0cb3a4d26337"],
Cell[41608, 871, 569, 19, 70, "Exercise", "ExpressionUUID" -> \
"1d467f52-802e-4447-8a9b-bb892f86cc94",
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[42202, 894, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"747c0a52-f2bb-473b-b7b8-73b74b3a1d51"],
Cell[42841, 915, 12563, 235, 70, "ExerciseOutput", "ExpressionUUID" -> \
"19d5ea66-8460-46b3-b6e0-4dc26f0e1811"]
}, Closed]],
Cell[CellGroupData[{
Cell[55441, 1155, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"37c7db64-0a5d-4a11-b657-a5c4cb265225"],
Cell[56011, 1175, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e30f42ae-beb8-4781-9bbd-b259d5a18e7f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56873, 1207, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f097b004-6254-4b8c-8d24-ab3c7fe70a7a"],
Cell[57160, 1218, 651, 20, 70, "Exercise", "ExpressionUUID" -> \
"f9699c38-fc94-4e69-8ad7-d8edc7c83260",
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[57836, 1242, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"170c9711-b382-4760-aa21-703774245555"],
Cell[58475, 1263, 8425, 167, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8f40c49c-af80-42e1-9046-86d3f2995851"]
}, Closed]],
Cell[CellGroupData[{
Cell[66937, 1435, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"aac228bf-7be5-4d91-99ed-fac29fdc9a34"],
Cell[67507, 1455, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5d615b6b-3f5b-409a-8369-0d38d0831600",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68369, 1487, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e42da305-ff29-466d-bf2d-e9c5d65533aa"],
Cell[68656, 1498, 587, 17, 70, "Exercise", "ExpressionUUID" -> \
"afb5d2a6-fcc2-4eb2-8a30-54c0b869ef4f",
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[69268, 1519, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3b73af06-952f-4590-9ef9-1c1b68d230ae"],
Cell[69907, 1540, 9661, 187, 70, "ExerciseOutput", "ExpressionUUID" -> \
"eef1828b-2259-460f-93e1-ed484e344794"]
}, Closed]],
Cell[CellGroupData[{
Cell[79605, 1732, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"1996a11a-96d0-44ff-9d25-45750eb0e35f"],
Cell[80175, 1752, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9791e65b-3b1c-4560-8514-846bd527a365",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81037, 1784, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1b0c12c8-d5fd-4a70-b203-557aa5869a93"],
Cell[81324, 1795, 620, 19, 70, "Exercise", "ExpressionUUID" -> \
"89835d56-5cb9-436c-aa0e-7aa51dee7f64",
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[81969, 1818, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"eb33f1b1-8cb2-4dbe-bbfa-7a1dcc2ebd1f"],
Cell[82608, 1839, 32596, 563, 70, "ExerciseOutput", "ExpressionUUID" -> \
"46dfd919-a205-4592-888b-42e1a858e75c"]
}, Closed]],
Cell[CellGroupData[{
Cell[115241, 2407, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b098c7e9-23cf-4f44-a32a-078f34bb18cc"],
Cell[115811, 2427, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e981de8e-738e-42df-ad43-31e70f329725",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116673, 2459, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f8adca4a-83e6-4f3f-b9a8-06eceb21df6c"],
Cell[116960, 2470, 564, 15, 70, "Exercise", "ExpressionUUID" -> \
"52920852-15b7-48d1-b209-5f0f4c535e16",
 CounterAssignments->{{"SectionNumber", 29}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[117549, 2489, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4139894a-5d12-47c4-b51f-6f29586d9367"],
Cell[118188, 2510, 5727, 122, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8c2cf0ad-7986-47c8-8970-abd4f6e4ebb6"]
}, Closed]],
Cell[CellGroupData[{
Cell[123952, 2637, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"ac9c9e10-bac2-4f17-a98d-9dba322a85c1"],
Cell[124523, 2657, 813, 26, 70, "Input", "ExpressionUUID" -> \
"477198de-9706-4479-8274-5e59cf1dde5a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[125363, 2687, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a2a2b935-59b9-4ffb-99ed-5771d0bf9373"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature QTWmhZEo#E5MojeY1IH4LJMJ *)
