(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    588347,      13157]
NotebookOptionsPosition[    470995,      10799]
NotebookOutlinePosition[    569577,      12827]
CellTagsIndexPosition[    568483,      12783]
WindowTitle->Applying Functions Repeatedly: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Applying Functions Repeatedly", "SectionInline",ExpressionUUID->
   "d60eaa7a-60a8-4f39-88c2-b946c4d5a4b3"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 26}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:153",ExpressionUUID->"0f6866b6-833e-4b62-b661-fe33ded5d34f"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineCodeText",ExpressionUUID->
  "4c83413c-428f-4991-a7a5-ce91fe007070"],
 " applies ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "e6cf4f65-6ab5-40d5-ad3c-4551e1fcd125"],
 " to ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "a27b36bb-e6af-4680-a537-c2b15cd4ce4c"],
 ". ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "d062c400-d90a-4a50-80e9-eab2db51e5a5"],
 " applies ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "0073069c-fdad-4d39-a312-a36f8643d186"],
 " to ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineCodeText",ExpressionUUID->
  "acd48203-fcdf-45a4-982a-5843eadc8862"],
 ", or effectively nests the application of ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "ff8ed017-4fb5-4808-ad56-defb9686138f"],
 ". It\[CloseCurlyQuote]s common to want to repeat or nest a function. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"2055ad21-f90d-4082-aaa2-92dee9c3b1c9"],

Cell[TextData[{
 "This makes a list of the results of nesting ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"28d8f979-9b54-4633-901e-f5dd555e908f"],
 " up to 4 times:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"a1b92a5c-d2b8-43d7-805a-e1e51b1bbc3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"cb55bf85-2e19-43c0-b14c-a7bdeeec9f3e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"ef1b22aa-c1d3-428a-adda-4438488e2c7d"]
}, Open  ]],

Cell[TextData[{
 "Using ",
 ButtonBox["Framed",
  BaseStyle->"Link"],
 " as the function makes it a little more obvious what\[CloseCurlyQuote]s \
going on:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"dddbd3e1-0263-4df5-b04d-ee4430ab5393"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Framed", ",", "x", ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"c6ca45c4-4f24-4834-aa32-07b80398f2bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox["x",
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox["x",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox["x",
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox[
       FrameBox["x",
        StripOnInput->False],
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"ccd5951a-2593-45c4-acab-43ce65b8dd2c"]
}, Open  ]],

Cell[TextData[{
 "If you want to see a list of the results of successive nestings, ",
 "use",
 " ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 ". If you only want to see the final result, use ",
 ButtonBox["Nest",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"100c7f72-543e-4450-a1ec-ac4075111fa9"],

Cell["This gives the final result of 5 levels of nesting:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8404e034-a88d-4807-aef4-b0d34d911258"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"Framed", ",", "x", ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"0071d92d-cfa4-42da-a0fd-2f7d4144c768"],

Cell[BoxData[
 FrameBox[
  FrameBox[
   FrameBox[
    FrameBox[
     FrameBox["x",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False],
   StripOnInput->False],
  StripOnInput->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"b2c279de-5e65-4e51-b281-36aced8d5c09"]
}, Open  ]],

Cell[TextData[{
 "Nestedly apply ",
 ButtonBox["EdgeDetect",
  BaseStyle->"Link"],
 " to an image, first finding edges, then edges of edges and so on."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"06a67b5d-f668-4a3e-9f0c-2543a8644c29"],

Cell["Nestedly do edge detection on an image:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f5c94eef-f8c2-4829-9249-b60429ab210e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"EdgeDetect", ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztmUFuwjAQRSP1JL1Ce5MegQv0CpEQEtyADUvEgiU3gAuwZ8meCyCYvmgk
y2oIDYkT/0W/flAUnPFXbI9nxu+T76/JW1EUn1wfXNW9/SML7vfMAm43O5/t
cLDt1pZLWyxsOrWyrH655wnP+Zc2tBwBdLTb2XxeaWhDWtKetwbC6WSrVVsx
dfIuFhLicrH1uruemNjBWn8cjzabpZHkxBo2O4OJypRIqCcmljsshOvVNpuh
JDmxTy8vfaWhJQVh7b/YcAP3cCjbgKk4miTnn5OfZZt2xbUhPT53F6n80quk
3ybge7NIcjZ5/j4bSn/Sex1soBklOeub+JjeoIm/vASurH1wMhzREDtVheEr
a4NI3JhdjxMlAQS02fU4URJApJ1djxMlAaQA2fU4URLgGYoCUeIgj8suJmbI
KwW/ley80lyDmv5qv8+vxxn7ds19UDNm0IyvRAbxYUFJMG431RzHJPNBU82d
TbLO4BCsyZhq/coka33hi6nVRQPUasgBgvX2ALWziRhq5zgx1M68niDd+eAP
mjcM6Q==
     "], {{0, 0}, {80., 81.60000000000001}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{40.58203125, Automatic},
    PlotRange->{{0, 80.}, {0, 81.60000000000001}}], ",", "6"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"81e27036-b9e4-43e9-af75-6518ca598aa1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJztmUFuwjAQRSP1JL1Ce5MegQv0CpEQEtyADUvEgiU3gAuwZ8meCyCYvmgk
y2oIDYkT/0W/flAUnPFXbI9nxu+T76/JW1EUn1wfXNW9/SML7vfMAm43O5/t
cLDt1pZLWyxsOrWyrH655wnP+Zc2tBwBdLTb2XxeaWhDWtKetwbC6WSrVVsx
dfIuFhLicrH1uruemNjBWn8cjzabpZHkxBo2O4OJypRIqCcmljsshOvVNpuh
JDmxTy8vfaWhJQVh7b/YcAP3cCjbgKk4miTnn5OfZZt2xbUhPT53F6n80quk
3ybge7NIcjZ5/j4bSn/Sex1soBklOeub+JjeoIm/vASurH1wMhzREDtVheEr
a4NI3JhdjxMlAQS02fU4URJApJ1djxMlAaQA2fU4URLgGYoCUeIgj8suJmbI
KwW/ley80lyDmv5qv8+vxxn7ds19UDNm0IyvRAbxYUFJMG431RzHJPNBU82d
TbLO4BCsyZhq/coka33hi6nVRQPUasgBgvX2ALWziRhq5zgx1M68niDd+eAP
mjcM6Q==
     "], {{0, 0}, {80., 81.60000000000001}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{53.62890625, Automatic},
    PlotRange->{{0, 80.}, {0, 81.60000000000001}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRJI
mTsQuzHQAzCiAnLNwMsn0hXYhUkwA78FFJtBlALi1BBhDzHuJaCK6MDDp5Aq
MUBSgsClmNRUhVU56Skca7ok3RQMLWRlNgxNZOZYahiCro8qppBrCKpO8k1B
1koVUygwBKGZzIIZ3RRKDIHppswQmP5RU0ZNGTVl1JSRYAp1yl1qmUKVmoQ6
tdqgqqep1PIYTG0pKrUOqdRSpU6rmUoteCr1JqjUs6FSL4tKPT4q9T6Jcw5V
OtREepsaIwRQpRSPVmC3lIIRGIpHcUY2AAAU8Q3K
      "], {{0, 71}, {70, 0}}, {0, 1},
      
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSize->{53.8359375, Automatic},
    ImageSizeRaw->{70, 71},
    PlotRange->{{0, 70}, {0, 71}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmE0OgjAQRosrl17BW7h1o3GL8QAQkbjBBEyMtxcqIK2lnU6/DUmbYAKZ
efOKDf3Z5o/0thJCNOv2J81e+7rO3udNe3OpmntZFddT9SzKot7lXdixvQ7C
3hK1OaLnGK4HboJM0VW8jPpQLaMnEEFd1Mx7GJQIEEc5WYQkQqjjCCD4OqII
It84W68IPXaHekDmtb0gkmEaC34QM8YbYkphQAxJxk4SMIl2y6KoGJ6KVp2p
opXnqih9Mg8gX5kAyM+ANVb+ZEJUxmz+HzTFhKlESqRESqQsg4L57sIoiJkE
M6uBZljMbA9aeWBWQaAVGVNGz8KsVDkYUwpkBQ/aTYB2NqBdFmjHJ/pvH0HE
HgXZCQ8xNl3a24OcEIjRN+i0Ylo05OREMbI8oBuFnigttX0AsJ4OcQ==
      "], {{0, 71}, {
      70, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{70, 71},
    PlotRange->{{0, 70}, {0, 71}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmEsOgjAURV8dOXQL7sKpE41TjAuQiMQJJmBi3L0gBYR+3ycmJjSBpPT2
9LZQ2td1ek+uCwColvUtOT+3ZXl+HVd15lRUt7zILofikeVZuUkb2b6+duBL
ykxevZ0Q/9jF8DeAZDi6E+aMGC4TIUxTrrQJW6l+Gujz5+4VBTkxDQVVcZCA
Tncn5j26pQhI9xJMMQrikiMh0H4PxieFhXRVmBALRuGmq67UVPmeXoY5ihlF
guh6ypbBY5hWRn0ijsrEgAJFhbQD0aOoFBgodCs9hWdlMMKCzJSZMlNmyl9Q
mBg1ufgU/kois6oJrbAyq73QzoNsZty8zI4MRHaHmorEmD0gYCzDILODl4km
kBhXZIPC+KQiEV8sJjKIZUbC0A0bLyofl9NPCKYc4mlFUIWYtRKnOA5HtN/h
9GSKxPh9egMMyw6t
      "], {{0, 71}, {70, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{70, 71},
    PlotRange->{{0, 70}, {0, 71}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmM1OwzAMx21OO/IKvAVXLkNch3iATSsTlyJ1SIi3p10a106aLydwaqSu
a2L//K+TtkkeTp+H9zsAuO7Gn8Px+2kYjj+v9+PFW3/9uPTd+aX/6i7d8Hia
zJ7HYw+hgojT4ZZbfW4xpp6Drc4CTVa4bjtXpzmGwWJzBJ3iGOtosiBTw7TE
5cxhSAvKRvRt1iC3Rh7Vi8IYAczcEteLzCoMycjdcldBSEY/LgzPMh8SwYTx
6xzmpIbQ0yAdsBCyYJiHfTjyIWxkSUoZhKypN5DuqBBj3jmCUgpxoiulmNRQ
eK0U6lpKq47CBOilMAVI1zViaqSwnlF2EMdgnZSNslE2ykb5J0rlu67Ne7cJ
hRiVX5IqMeIjosYwBXoxdC8A+szIwaYVI8MrxaCckUGT2SG0mamyLi+AADjZ
bDODL8WsryY4Js1pskCKQDgjjkHOCWESclKrT+tfuRJelKL1cRC+TRBjgyIo
dwhsKKS/a1qyRhXbOQlpyRqaLXZxgIK6+0mhzZ04KFmTrUgm5m/LL0vCD7U=

      "], {{0, 71}, {70, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{70, 71},
    PlotRange->{{0, 70}, {0, 71}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmM1OwzAMgBNOO/IKvAVXLkNch3iATSsTlyJ1SIi3p1vt2HGd/xybaV2z
2F8d2/nr0+n78PlgjLnu5svh+PsyTce/98e58jFevy7jcH4bf4bLMD2fbmKv
83dv9GJvxVi4wTJXDd6lC0otioxhpUSaEWzPkJLPFF1aKL5Q6EEm/iC4hoQW
B/LHrE1BTNAcgJApIhpQvV9tCONCc6foAYUEkCoaRG0WFluqaJBIjz2Mag33
aDxEJLG2OtrZkDleKIohIYz12nMK+pj138InH0IpzNILKfkQ51y7ApZAYLbx
zSqHGELwfiXzRMEwj1ZCMNguUjJ/8jGoDyO4BuJ0673iKWG8qiCeT+spIvcq
IRiXnGl/o2yUjbJRWijNcx2n1UCU3yqK2MbWUpqMoRWxxRi21HdZ7TvtPMiY
ll0Qu2nZkZFdLbtD1ruWnSrza8OumUenYQdfiAlAOp1s+pyyqJ5KnOiJj2Ng
pCqk5OmTmWqZjkCgaiRHu5zKyYpokDImavEiQkqSsYmscs3eEDEwm6ykUhwt
iEWLV8D52Jg/7nXZ3JdSnkbyn2yLlIRRyj+6GA81
      "], {{0, 71}, {70, 0}}, {0, 1},
      
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{70, 71},
    PlotRange->{{0, 70}, {0, 71}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmE1OwzAQhT2sWHIFbsGWDYhtEQdo1VKxCVKKhLg9beOZeTOxE9vpMpZA
tWt/efNjZ9zH3ffm8y6EcLo//9tsf5/7fvv3/nDufHSnr2N32L91P4fjoX/a
Xaa9nv9eQqpRoEu7fiQdjQPXryi5EBl0nRuXkTYDpUlOfGJ6Jg1CA8zJ65AZ
DjPIiXbl5UQAyQRHcYLSGBZKGS0ihpA4hlB8xOBg513uRikEpltI1EEaVisF
FaAmBwGzKGU2SyEwPwFhr+TzAX3sMNDLe1/0BHAfYiCnJzJBMZqdZiWplPlN
YhYaKziUJRDdmuhDTbJCiK7UXWF9UgTRBOVoDfbkknEaE0gcDCErh0gwdU/w
cA0Ecx0oM8mWw4CCwtPUU2xYamLsxBCvdedkHYaCxJao2rVKCZJ8zRROGjgo
W8WQbqUmyEpZKStlpRRQ2jBw1rVTpDJbZJKI0Ap5wZtETGmhSA2kL9Zlb9hb
vO1vU3kEyZzaaNsqiN28sCJDVcWYUXUofllWqYabVM0Y5CLMKDDQU8w0J3eb
QOKCmw30rK05a9SH5L7UeA3JlADN3PiUDCdg/e2T3SoGt92EwRhIw7EWeyYl
WuIXAiuFV0qUks1U4S4ZwMjpXyvECHgeGmwypCQzdQlQgmb2/LGoHDfMZ1Lh
0Spb1o8Lrawls6UOIYLItglL/gFekRAq
      "], {{0, 71}, {70, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{70, 71},
    PlotRange->{{0, 70}, {0, 71}}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"6c6c7059-56ce-4deb-ac53-9ba8a1cc08ea"]
}, Open  ]],

Cell["\<\
Use a pure function to both edge-detect and color-negate at each step:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"2d500334-3b04-4e98-bf6a-3b13f4296d37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ColorNegate", "[", 
     RowBox[{"EdgeDetect", "[", "#", "]"}], "]"}], "&"}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztmUFuwjAQRSP1JL1Ce5MegQv0CpEQEtyADUvEgiU3gAuwZ8meCyCYvmgk
y2oIDYkT/0W/flAUnPFXbI9nxu+T76/JW1EUn1wfXNW9/SML7vfMAm43O5/t
cLDt1pZLWyxsOrWyrH655wnP+Zc2tBwBdLTb2XxeaWhDWtKetwbC6WSrVVsx
dfIuFhLicrH1uruemNjBWn8cjzabpZHkxBo2O4OJypRIqCcmljsshOvVNpuh
JDmxTy8vfaWhJQVh7b/YcAP3cCjbgKk4miTnn5OfZZt2xbUhPT53F6n80quk
3ybge7NIcjZ5/j4bSn/Sex1soBklOeub+JjeoIm/vASurH1wMhzREDtVheEr
a4NI3JhdjxMlAQS02fU4URJApJ1djxMlAaQA2fU4URLgGYoCUeIgj8suJmbI
KwW/ley80lyDmv5qv8+vxxn7ds19UDNm0IyvRAbxYUFJMG431RzHJPNBU82d
TbLO4BCsyZhq/coka33hi6nVRQPUasgBgvX2ALWziRhq5zgx1M68niDd+eAP
mjcM6Q==
     "], {{0, 0}, {80., 81.60000000000001}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{44.296875, Automatic},
    PlotRange->{{0, 80.}, {0, 81.60000000000001}}], ",", "6"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"3b9fe65d-d943-4312-867e-67d443991301"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJztmUFuwjAQRSP1JL1Ce5MegQv0CpEQEtyADUvEgiU3gAuwZ8meCyCYvmgk
y2oIDYkT/0W/flAUnPFXbI9nxu+T76/JW1EUn1wfXNW9/SML7vfMAm43O5/t
cLDt1pZLWyxsOrWyrH655wnP+Zc2tBwBdLTb2XxeaWhDWtKetwbC6WSrVVsx
dfIuFhLicrH1uruemNjBWn8cjzabpZHkxBo2O4OJypRIqCcmljsshOvVNpuh
JDmxTy8vfaWhJQVh7b/YcAP3cCjbgKk4miTnn5OfZZt2xbUhPT53F6n80quk
3ybge7NIcjZ5/j4bSn/Sex1soBklOeub+JjeoIm/vASurH1wMhzREDtVheEr
a4NI3JhdjxMlAQS02fU4URJApJ1djxMlAaQA2fU4URLgGYoCUeIgj8suJmbI
KwW/ley80lyDmv5qv8+vxxn7ds19UDNm0IyvRAbxYUFJMG431RzHJPNBU82d
TbLO4BCsyZhq/coka33hi6nVRQPUasgBgvX2ALWziRhq5zgx1M68niDd+eAP
mjcM6Q==
     "], {{0, 0}, {80., 81.60000000000001}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{56.85546875, Automatic},
    PlotRange->{{0, 80.}, {0, 81.60000000000001}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRJI
mQcQuwMxIx0AAwog2wwCAsS5A4fryHcHmiyRhlCuglpqiHMygSAiPgDxqSQl
RnGrJS1d4FJNaurCrp6cNIpNkFRTsGkhL+dh6CI3/1LFFHSN1DGGgkKQAQd7
YIxB0ktZwQ7TTWH9wIBGDwpjKK7yGEaNGTVm1JhRY0awMYOrSKdWPUWlWpNa
dfggaFFQp51Ei0YbtVqi1GoXU6mVTrU+A5V6MNTqT1Grd0etvibRBhEeHBhs
fXXqjFHATKJ4xASHmygZCaJ4NAnJMAoNGKoAALttH/4=
      "], {{0, 72}, {71, 0}}, {0,
       1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSize->{53.75390625, Automatic},
    ImageSizeRaw->{71, 72},
    PlotRange->{{0, 71}, {0, 72}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmMEOgjAMhjtPHn0F38KrJ/WK8QEgIvGCCZgY314MUxkbW9s1xsQtgYTx
99vPIKzdsrhkpxkAtPPulOW3ddPk9/2iuzjU7bmqy+OuvpZV2ayKp2zbHZvu
UL4GRvNKfYxAB5ZhuSGZ0lrbjXJ1T0Imh9WmMCAITEIPQlgJDRbWYEZSvcRn
GDuB3uHQFK2l3qGoaZQpPZXijqBTXDEciiMK8O9oGAUmhkexOMB5JCuQa2bE
YZsxHIxnimknhvLxwPtmLDtRZqQxkZQXIGESJmES5j8xv/VLl1qnhFZNqTVc
KKOQym+Esi22HZkc0no3QnkxiyOT7cvUHjKVkL8ui6/uCJxAaStT+SqhOlzp
B/MaRjqGXuz6JvB7FOrtJm7HZECK278xPHk6CKTova0BLBLw9fYAlQMfTg==

      "], {{0, 72}, {71, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{71, 72},
    PlotRange->{{0, 71}, {0, 72}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmM0OgjAMxztPHn0F38KrJ/WK8QEgIvGCCZgY314+BrhPuq4HE1mCxq39
7W8R13abPZLbCgDqdfOSpK99VaXv86b5cCnre1Hm11P5zIu82mWt2bG5Ds0l
nAMsw23tZLjQsYxxFQlRNrd8IwTIYx0AatdBuIIgRcEcBzoTrxF0Nj4Q9Ntg
FHs4kjAfQC+nm5WKcSB7+HxKsdZhFJd9KMXhEUwZORpl/kZbOKByjAkcR7uz
pjw059sPaBTNsX8WKRiFQxajKKBGRpMA2CfJhZlYZMyIiIgMPyaSMgAWzIJZ
MAvmPzG/9ZfOdU4xnZpcZzhTRsGV39DlqI5MuZ/gyUTlRCDHzIulvCCOJUvn
qhmYKphQzkxdFl3dCaZaUzBVvmL8GcbV4YOg7j2mK6CsR/QodGtqx0R647ah
kgiNKcOD0NuaNqf3xwxYJAA/PhP9HxA=
      "], {{0, 72}, {71, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{71, 72},
    PlotRange->{{0, 71}, {0, 72}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmM9OwzAMxr9w4sgr8BZcOQHXIR5g08rEpUgdEuLt6dYmsdu41HZu1FPb
NXV+/uJGzZ/7w+fu/QbA+bY/7fbfj123/3m962/e2vPHqW2OL+1Xc2q6h8PF
7bk/nvojlK1/gIIFuUaJgYE0ZxfLJSFBinpVtAY0uBXDjvdrQBhPMSxLTBgv
pRhTClXDXEHVLHEubyLlt+SGlPyRJTUoBpQlR4DEAXVcMuSGCQ+HVi1TKGTe
tcQnGo6KIvprKUINaCkZAlakpWR/kJJJwVoOk4PUKDUHhDP8V3yQYj1W0Som
c6gYPYUpmLTQwoFPTOpwcGTmikHgP6NVxZj7DOfAKaYuxpuaDbNhNsw/wPCB
z47xyomVq44MVg4IwCEnETLJihnrOuTQjNizw4cna9+ZdDqrnGlWU5K0FD4x
rjQvJm9eSeFvuNKaQc2R/FWcP9Zl/tUdKXKtNdNcOwTXyjd2bu86PIVw7grE
RiHGte5RhEo7JtE7Z4iqWb9/EyijVKz6Li2qUZmkRm8zNR5bA/gFIFseFw==

      "], {{0, 72}, {71, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{71, 72},
    PlotRange->{{0, 71}, {0, 72}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmM1SxCAMgIMnj76Cb+HVk3pdxwfYna07XupM1xnHt7dbICQUCoEcy0xb
/voRmhBCH0/fh887ALjez7fD8fd5mo5/7w9z4WO8fl3G4fw2/gyXYXo63bq9
ztfLfJlEstWwZEi6VblMRfLd7IsUElqqIV297GwAS/GsQq8tkJt/SRT2yInK
hk0J40bLCORqIdx4v1D0XVIcLkpar+BNIasybyreXlLy0uHSHBylpAX8MikO
LZUthyqT9RZRolGbKTlORsY6Dqwy1ZQkB7yG6ynUzujiWMoCysIBakSYFVGs
nQZBwHgXJaPg+MBkkE0pyMNWWYMwxiACiLoaMcZQ5bRhIPa7LZTYYZQd8DYm
78ckHG7JHeLoYGDH7Jgds2NKGF3vp+WLdXaGVg7uU0q7ptYe3hlRYHCjFN8o
RVtasZ9SJKoVFytF6fTb9pwZpJwMRes8pXS6Q469NZ81qR24Z4JUPvliHTds
zvA5FHpL3r6/Atie3yyANmzogUbuEPn5sHTL2qR/XeLxgDWWUnK5sELlwgta
j6SRQBhpXS11tas35AgyuFVLSYx/rQAekg==
      "], {{0, 72}, {71, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{71, 72},
    PlotRange->{{0, 71}, {0, 72}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmE1OwzAQhZ9ZseQK3IItK2BbxAGoKBWbIrVIiNuTJpmZN47jxnEkitSI
0jaZfH7z59i9XX+u3q8AHK6bf6vX7/v9/vXn+ab58rI7fGx3m7en3ddmu9nf
rY9mj83roXmFwYHQnj5e4cvdZxyPkLgrhoA/gI7+XDdGHjQcPnEV6avsT+iH
S1nqeZE1LqX9U78Sg7RmUFaGIqBxNRDhSYcMFDSmUYg7k1aQpHNA0TdNrhcj
GmGKhn5LGnTglN9w/sQcsJxEWKIAaRY8xwKSTaWCXDLNmMo7FbeEILLnj0n6
OMiswMrKKJ5DcZIUT6SYJSgt3Xck6ynHkaKQ7Fk3TqVYscr8A6nuIoqf1xCs
tssorlIFM9awWYybf7j9Szl92fuWLMUEbQtgvhiKjqZ+DmUwrZQUXoQJweVo
FsZmQRj1jzEUm3PAYBmnLpgL5v9jzqo1l5/9FpmLF3oyVD+nap+avFieKcfW
pJUrCmiuqtY3okBINastCGaJtZ92Rd1K1NQVFDN09KD3LLNK59KbxmGK33sk
LEYhbMNVCwlQ3X5KU0/dlpESqIO8dteirvU9I7/XZDHWYuU7X72bwtQPT/tw
+S1lfB/OEKiD8UDiN3s2yqGBnRr99YVdT4E4BtFM5jScKAu6FHcqeIBTtRVE
t+hxGHI2C3GgaJYvgqjtwFiXDZPnJCo96HfYW8nR7bYo7zkdv4yyHbQ=
      "], {{0, 72}, {
      71, 0}}, {0, 1},
      ColorFunction->GrayLevel],
     BoxForm`ImageTag["Bit", ColorSpace -> Automatic, Interleaving -> None],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{71, 72},
    PlotRange->{{0, 71}, {0, 72}}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[5]=",ExpressionUUID->"6ef2f744-dfee-4341-9ae5-3dd4b09136a1"]
}, Open  ]],

Cell["\<\
Start with red, and nestedly blend with yellow, getting more and more yellow.\
\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:154",ExpressionUUID->"2e5d52be-fd50-4fe4-9657-3192df64d00b"],

Cell["Add another yellow into the blend at each step:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"8e3efbd1-356c-451f-927f-ca359f837d21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Blend", "[", 
     RowBox[{"{", 
      RowBox[{"#", ",", "Yellow"}], "}"}], "]"}], "&"}], ",", "Red", ",", 
   "20"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"719c4753-71d2-4087-9139-46c94ad06765"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.3333333333333333, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1/2, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[1, 2], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[1, 2], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[3, 4], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.5, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 3/4, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[3, 4], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[3, 4], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[7, 8], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.5833333333333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 7/8, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[7, 8], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[7, 8], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[15, 16], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.625, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 15/16, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[15, 16], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[15, 16], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[31, 32], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6458333333333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 31/32, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[31, 32], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[31, 32], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[63, 64], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.65625, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 63/64, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[63, 64], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[63, 64], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[127, 128], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6614583333333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 127/128, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[127, 128], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[127, 128], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[255, 256], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6640625, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 255/256, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[255, 256], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[255, 256], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[511, 512], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6653645833333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 511/512, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[511, 512], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[511, 512], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[1023, 1024], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.666015625, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1023/1024, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[1023, 1024], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[1023, 1024], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[2047, 2048], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6663411458333334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 2047/2048, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[2047, 2048], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[2047, 2048], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[4095, 4096], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.66650390625, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 4095/4096, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[4095, 4096], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[4095, 4096], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[8191, 8192], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6665852864583334, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 8191/8192, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[8191, 8192], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[8191, 8192], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[16383, 16384], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666259765625, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 16383/16384, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[16383, 16384], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[16383, 16384], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[32767, 32768], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666463216145834, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 32767/32768, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[32767, 32768], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[32767, 32768], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[65535, 65536], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.666656494140625, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 65535/65536, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[65535, 65536], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[65535, 65536], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[131071, 131072], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666615804036459, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 131071/131072, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[131071, 131072], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[131071, 131072], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[262143, 262144], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666641235351562, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 262143/262144, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[262143, 262144], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[262143, 262144], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[524287, 524288], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666653951009115, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 524287/524288, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[524287, 524288], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[524287, 524288], 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 
          Rational[1048575, 1048576], 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666660308837891, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1048575/1048576, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
           Rational[1048575, 1048576], 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 
     Rational[1048575, 1048576], 0],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[6]=",ExpressionUUID->"8649a58f-3fd3-4943-9eed-4173bed0d725"]
}, Open  ]],

Cell["\<\
If you successively apply a function that adds 1, you just get successive \
integers.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3b35d736-774e-48ca-87e0-ec473f8628fa"],

Cell["Nestedly add 1, getting successive numbers:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"461d8b86-ad71-4d0c-9bd1-27d5bcf5a3c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", "1"}], "&"}], ",", " ", "1", ",", " ", "15"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"d96a18a2-d7fe-46b3-96cf-d7662b9682d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"f10e2383-de1a-4738-8e0a-14c74686aefa"]
}, Open  ]],

Cell["Nestedly multiply by 2, getting powers of 2.", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dc5e784e-4f07-4a60-bfd4-0bab5fe678fd"],

Cell["The result doubles each time, giving a list of powers of 2:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"bc3d2810-0297-464c-9656-f570ecf3f8e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "#"}], "&"}], ",", "1", ",", "15"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"6094dd97-ed8d-4e69-88bb-13237c5cc238"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64", ",", 
   "128", ",", "256", ",", "512", ",", "1024", ",", "2048", ",", "4096", ",", 
   "8192", ",", "16384", ",", "32768"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"cfc4f97c-eda5-4f46-ba4e-1d8c9e1c66fd"]
}, Open  ]],

Cell["Nested squaring very soon leads to big numbers:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"aed89092-53f4-4cad-a936-9433cd7d9958"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "2"}], "&"}], ",", "2", ",", "6"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"362588bd-9199-4796-b663-bee4054696f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "16", ",", "256", ",", "65536", ",", "4294967296", ",", 
   "18446744073709551616"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"cfbfdd9f-5a10-493d-a6a1-b346a23a7092"]
}, Open  ]],

Cell["You can make nested square roots too.", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"2f5be090-a7f7-4886-89ef-acdfde410fd9"],

Cell["Nestedly apply square root:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d3a6a333-993d-47cc-959c-1de15a79efc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", "#"}], "]"}], "&"}], ",", "1", ",", "5"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"91c67c6f-7c0a-4edd-be53-2b569b696c59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox["2"]}]], ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SqrtBox["2"]}]]}]], ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SqrtBox["2"]}]]}]]}]], ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           SqrtBox["2"]}]]}]]}]]}]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"a2453a6c-0d0e-4fcd-babe-aa9e7f417fbf"]
}, Open  ]],

Cell[TextData[{
 "The decimal version of the result converges quickly (to the ",
 StyleBox["golden ratio",
  FontSlant->"Italic"],
 "):"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"5a90039f-9bab-45d5-834c-def75ca05e40"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", "#"}], "]"}], "&"}], ",", "1", ",", "10"}], "]"}], "//",
   "N"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"e618c1b2-6933-4a01-9e89-c375f9fc81b1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.4142135623730951`", ",", "1.5537739740300374`", ",", 
   "1.5980531824786175`", ",", "1.6118477541252516`", ",", 
   "1.616121206508117`", ",", "1.6174427985273905`", ",", 
   "1.617851290609675`", ",", "1.6179775309347393`", ",", 
   "1.6180165422314876`", ",", "1.6180285974702324`"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[11]=",ExpressionUUID->"c5f10c3e-aeca-4b2d-831a-7205aefdb7b5"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["RandomChoice",
  BaseStyle->"Link"],
 " randomly chooses from a list. You can use it to create a pure function \
that, say, randomly either adds +1 or \[Minus]1."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:155", "i:13"},ExpressionUUID->"03df411e-4a4c-4c62-ad9e-d60839eb297c"],

Cell["Randomly add or subtract 1 at each step, starting from 0:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cb2cfbfd-7fd0-43a4-9218-7534aa30624d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"+", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], "]"}]}], "&"}], ",", "0", ",", "20"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"b62b5b8b-87e9-457a-af15-9a2ed9c8bce6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "6"}], ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "6"}], ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"13955e2d-70cc-4759-bddd-3f81180b1360"]
}, Open  ]],

Cell["This generates 500 steps in a \[OpenCurlyDoubleQuote]random walk\
\[CloseCurlyDoubleQuote]:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"4aaa9f74-7727-4f19-852f-76ad98c1d38c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "+", 
      RowBox[{"RandomChoice", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"+", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], "]"}]}], "&"}], ",", "0", ",", "500"}], 
   "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"8286d3fa-028c-41a0-bff0-7b523f490975"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxdlknSFUUURlNHDGvggAGDkjD+IAyCePRgR6Fgg4BPBEGkKWlEpXv2iKK5
hLeEWsLbgbmEt4RaQk2cG0bdE0aemlSc/8R3783KrPfXq3eeXrr/ckrpn5dS
+u8+X9OpVF9d/fddXa0b/N/z/RX53crvkW/l9+Lj/pr8jvw++ddVf7/8AfmF
/EHVPxR31n1Y/ojyR+WPyR9X/xP4eH4n8WW+vSH/pvJvqf7b8u8of0r1u9rn
Tv508K6Z82n5d5WHud6r58swz+cM9ed7PiN/Vv6s/PuqD3N9oPlg5v9QHub6
SPVh+p/TfOfkP1Ye5jqv/uflL8hfkL+o+hflP1EeZv3L2nfL2mf5Ip8+DY7z
0cFN5OWLfLqk/KXaZ/kinz4LfiXyn9U+w+Rh5r+s/pdrn+ULTP8r6n+l9hkm
L58+V//Pa5/hqF/g3ZG/qv5Xa5/li3y6Frwn8tdqn+UL3Eb+C+Vh8vIFJn89
eG/kr9c+w+Rh5v9S/WHy8kU+3VD+Ru0zHPMV+LXI39T8N2uf5QtM/1vK36p9
li/y6bbyt2uf5QvM/H3wzsxtX/tOvpfPcNQf5Ivyo3z6Sv3hfdEffj36y2f5
Qb6o/gjT/476w/SX7+Wz/ACzfvlR+XRX/e/WvpPv5TPM+uH90V9+VD7dq317
r/YdTH/5LD/IF9Uf4Zgv3Vd/mP7yPRz5LD8oX+CYb4TZ/6+D4/y2cLw/HRy/
D718Vn6A2X/5UT49UP8Hte/ke5j+cMw3wPH7WORH5dM3tW/hyHdw/P/o5bPy
Axz1C8z6Ydb/be1bmOcP8/xh+sMx3wDH/88iP8qn72rfwqwfpj/M85cflC/y
o/LpYe3bh7Xv5HuY9csPyhf5Ufn0SP0f1b6T7+UzzPOHef7yo/Lpsfo/rn0H
c/5gvo/g+H4a5Iv8CPP996T27ZPad3B8//byWflBvsiPMOfvqfrD9JfvYdYP
8/xhzp/8qHxa1b6BI9/CsT8L+U75JRz1e/mVfJZfq/4gv1G+yG+VHzX/BPP+
fV/7Bmb98guY9xOO368lHL9vvfxK+Sy/Vn6Ad2beyBflt/Kj8pN8+qHON3DM
18ovYP4/yS+V7+VXymf5tfKD/Ea+yG9Vf4R3Zp7k0491voFZv/xCvpNfyvfy
K5j1wzHfGo7vlwGO75uNfFF+q/qj/CSffqp9A0f9Vn4Bs//yS/keZv3yWX4N
s//yG/kCx/u5lR+Vn+TTz7Vv4JivhWN9C5jvUzj2ZwnH92kPH5h5BS9mzvJr
+UF+I1/ggzNv5Uf5ST79Utdv4Ji/lV/Ake/gqL+ED83cw4dnXsFHZs7w0ZnX
8oP8Bj42c4GPz7yFT8w8yk/Kp19r38CRb+UX8p38Eo76PRzzr+Sz/Bpm/fIb
+SK/lR/lJ/n0LDj2p3lW+xaO/AKO+Tv5pfK96q/ks/Jr+UF+o/4FZv9h9l9+
kk+/1b6Bo34Ls3445uvgWN8S5vzD8X6sYN5/mPcfjvdvkN/IF/mt6o/qP8mn
57Vvnte+lV/Id/JLmPXLr5TPMOuHWb/8Rr7Ib1V/VP9JPv1e+waO+Vs49nch
38kvYc6//Er5LL9WfoA5//JFfis/qv4kn/6o8w3M+Yf5/ZPv5JfyvfxKPsuv
4Xg/B/jkzBv5ovxW9Uetb5JPL+p886L2Lcz7D/P+w+y/fC+/gtl/+bXyg/pv
NF+R3yo/qv6k/unP2jcwv/8w65fv5Jcw+y+/Uj7Lr+UH+Y18kd/Kj/KT5kt/
1b6BWb/8Aub8w5z///2/zBzMHg==
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{195.10546875, Automatic},
  Method->{},
  PlotRange->{{0., 501.}, {-25., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"443b7541-3f50-40e9-8c87-44b1edee529b"]
}, Open  ]],

Cell[TextData[{
 "So far, we\[CloseCurlyQuote]ve used ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 " ",
 StyleBox["iteratively",
  FontSlant->"Italic"],
 "\[LongDash]",
 "effectively to perform a chain of applications of a particular function",
 ". But you can also use it for ",
 StyleBox["recursion",
  FontSlant->"Italic"],
 ", in which the very pattern of applications of the function is itself \
nested. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"a40120e4-341c-4968-a530-f3c0fca36d65"],

Cell[TextData[{
 "This does a chain of applications of the function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"0a1c2675-2013-4959-8b0b-6fffc2e5de01"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ca4cc239-11b6-47dd-9e33-c4087703eddb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "#", "]"}], "&"}], ",", "x", ",", "3"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"e5c8d293-9ffc-44de-906a-f9d97429396d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"f2cc0c8d-7f3a-4125-b73d-6ab08a4faa02"]
}, Open  ]],

Cell[TextData[{
 "The pattern of applications of ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"ca48befb-bb43-485d-a0fe-4134ebe842c8"],
 " is more complicated here:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7ad75769-16cf-4af6-9faf-63a39f4d2b1b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"#", ",", "#"}], "]"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"bb8cb903-107b-4a19-b4ee-54a8a092037a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "x"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "x"}], "]"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "x"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "x"}], "]"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "x"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "x"}], "]"}]}], "]"}]}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"9c14ffb6-a8e3-4023-8e80-204eaf4c9fd3"]
}, Open  ]],

Cell["\<\
Adding frames makes it a little easier to see what\[CloseCurlyQuote]s going \
on:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"5724e240-6cb5-41e9-8d21-d77d0538d5b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"f", "[", 
      RowBox[{"#", ",", "#"}], "]"}], "]"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"ff249491-21fe-49f5-8a17-0124f45d4a2e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "x"}], "]"}],
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"f", "[", 
     RowBox[{
      FrameBox[
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "x"}], "]"}],
       StripOnInput->False], ",", 
      FrameBox[
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "x"}], "]"}],
       StripOnInput->False]}], "]"}],
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"f", "[", 
     RowBox[{
      FrameBox[
       RowBox[{"f", "[", 
        RowBox[{
         FrameBox[
          RowBox[{"f", "[", 
           RowBox[{"x", ",", "x"}], "]"}],
          StripOnInput->False], ",", 
         FrameBox[
          RowBox[{"f", "[", 
           RowBox[{"x", ",", "x"}], "]"}],
          StripOnInput->False]}], "]"}],
       StripOnInput->False], ",", 
      FrameBox[
       RowBox[{"f", "[", 
        RowBox[{
         FrameBox[
          RowBox[{"f", "[", 
           RowBox[{"x", ",", "x"}], "]"}],
          StripOnInput->False], ",", 
         FrameBox[
          RowBox[{"f", "[", 
           RowBox[{"x", ",", "x"}], "]"}],
          StripOnInput->False]}], "]"}],
       StripOnInput->False]}], "]"}],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"93701045-7432-4940-8b45-6bbfbe4fcca7"]
}, Open  ]],

Cell["\<\
Putting everything in columns shows the nested pattern of function \
applications.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:156",ExpressionUUID->"593d3324-0a5a-490c-979d-b4a4b6e37e20"],

Cell["\<\
The nested boxes are recursively combined in twos at each level:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"60eecff1-dbd5-465c-9ad9-89c0dd038143"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Column", "[", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], "]"}], "]"}], "&"}], ",", "x", ",", 
   "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"9a726920-f680-4134-a30b-d12fd1ab1656"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox[
    TagBox[GridBox[{
       {"x"},
       {"x"}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        FrameBox[
         TagBox[GridBox[{
            {"x"},
            {"x"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"],
         StripOnInput->False]},
       {
        FrameBox[
         TagBox[GridBox[{
            {"x"},
            {"x"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"],
         StripOnInput->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        FrameBox[
         TagBox[GridBox[{
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x"},
                 {"x"}
                },
                DefaultBaseStyle->"Column",
                GridBoxAlignment->{"Columns" -> {{Left}}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Column"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x"},
                 {"x"}
                },
                DefaultBaseStyle->"Column",
                GridBoxAlignment->{"Columns" -> {{Left}}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Column"],
              StripOnInput->False]}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"],
         StripOnInput->False]},
       {
        FrameBox[
         TagBox[GridBox[{
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x"},
                 {"x"}
                },
                DefaultBaseStyle->"Column",
                GridBoxAlignment->{"Columns" -> {{Left}}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Column"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x"},
                 {"x"}
                },
                DefaultBaseStyle->"Column",
                GridBoxAlignment->{"Columns" -> {{Left}}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Column"],
              StripOnInput->False]}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"],
         StripOnInput->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"9fc1cd4f-b491-447d-abc0-b7ba34f87797"]
}, Open  ]],

Cell["This gives a sequence of recursively nested grids:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"a3eacb06-01c5-4ac7-83fb-a79918e4273b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#", ",", "#"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"#", ",", "#"}], "}"}]}], "}"}], "]"}], "]"}], "&"}], ",", 
   "x", ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"88d620cc-2d12-4b78-8051-2c27b5e934a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox[
    TagBox[GridBox[{
       {"x", "x"},
       {"x", "x"}
      },
      AutoDelete->False,
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Grid"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        FrameBox[
         TagBox[GridBox[{
            {"x", "x"},
            {"x", "x"}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False], 
        FrameBox[
         TagBox[GridBox[{
            {"x", "x"},
            {"x", "x"}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]},
       {
        FrameBox[
         TagBox[GridBox[{
            {"x", "x"},
            {"x", "x"}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False], 
        FrameBox[
         TagBox[GridBox[{
            {"x", "x"},
            {"x", "x"}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]}
      },
      AutoDelete->False,
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Grid"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        FrameBox[
         TagBox[GridBox[{
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False], 
        FrameBox[
         TagBox[GridBox[{
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]},
       {
        FrameBox[
         TagBox[GridBox[{
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False], 
        FrameBox[
         TagBox[GridBox[{
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"x", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]}
           },
           AutoDelete->False,
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]}
      },
      AutoDelete->False,
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Grid"],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"92a9b343-56cf-46d1-ac4f-f473fa632e5e"]
}, Open  ]],

Cell["This forms the beginning of a fractal structure:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"bb7b9ffd-a27c-45b8-987b-2617ac70ebad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "#"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"#", ",", "#"}], "}"}]}], "}"}], "]"}], "]"}], "&"}], ",", 
   "x", ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"a40e1a6e-dd71-4983-a4d2-845c30b4733e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox[
    TagBox[GridBox[{
       {"0", "x"},
       {"x", "x"}
      },
      AutoDelete->False,
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Grid"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {"0", 
        FrameBox[
         TagBox[GridBox[{
            {"0", "x"},
            {"x", "x"}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]},
       {
        FrameBox[
         TagBox[GridBox[{
            {"0", "x"},
            {"x", "x"}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False], 
        FrameBox[
         TagBox[GridBox[{
            {"0", "x"},
            {"x", "x"}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]}
      },
      AutoDelete->False,
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Grid"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {"0", 
        FrameBox[
         TagBox[GridBox[{
            {"0", 
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]},
       {
        FrameBox[
         TagBox[GridBox[{
            {"0", 
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False], 
        FrameBox[
         TagBox[GridBox[{
            {"0", 
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]},
            {
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False], 
             FrameBox[
              TagBox[GridBox[{
                 {"0", "x"},
                 {"x", "x"}
                },
                AutoDelete->False,
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
               "Grid"],
              StripOnInput->False]}
           },
           AutoDelete->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Grid"],
         StripOnInput->False]}
      },
      AutoDelete->False,
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Grid"],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[19]=",ExpressionUUID->"bdb398bf-d374-4394-90af-acb81a6725dd"]
}, Open  ]],

Cell["It\[CloseCurlyQuote]s easy to get some pretty ornate recursive \
structures:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:157",ExpressionUUID->"fe5cfb92-7b6e-46e9-b562-c95c6a9fbfc9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"Rotate", "[", 
        RowBox[{"#", ",", 
         RowBox[{"90", "\[Degree]"}]}], "]"}], ",", 
       RowBox[{"Rotate", "[", 
        RowBox[{"#", ",", 
         RowBox[{"270", "\[Degree]"}]}], "]"}]}], "}"}], "]"}], "&"}], ",", 
   "\"\<R\>\"", ",", "4"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"8e94b898-0a23-4828-866b-88ca27cd2828"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"R\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"R\"\>", ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->4.71238898038469]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"R\"\>", ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->4.71238898038469], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->4.71238898038469]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"R\"\>", ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->4.71238898038469], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->4.71238898038469], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->4.71238898038469]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"R\"\>", ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox["\<\"R\"\>",
      BoxRotation->4.71238898038469], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->4.71238898038469], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->4.71238898038469], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->1.5707963267948966`], ",", 
     RotationBox[
      RowBox[{"{", 
       RowBox[{"\<\"R\"\>", ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox["\<\"R\"\>",
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->1.5707963267948966`], ",", 
        RotationBox[
         RowBox[{"{", 
          RowBox[{"\<\"R\"\>", ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox["\<\"R\"\>",
            BoxRotation->4.71238898038469], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->1.5707963267948966`], ",", 
           RotationBox[
            RowBox[{"{", 
             RowBox[{"\<\"R\"\>", ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->1.5707963267948966`], ",", 
              RotationBox["\<\"R\"\>",
               BoxRotation->4.71238898038469]}], "}"}],
            BoxRotation->4.71238898038469]}], "}"}],
         BoxRotation->4.71238898038469]}], "}"}],
      BoxRotation->4.71238898038469]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"d10511ed-df9d-432b-9b78-b611dc3a1342"]
}, Open  ]],

Cell[TextData[{
 "Not all results from recursion are so complicated. Here\[CloseCurlyQuote]s \
an example that successively ",
 "adds two shifted copies of a list together",
 ", as in ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "1"}], "}"}], 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "0"}], "}"}]}]], "InlineCodeText",
  ExpressionUUID->"6e4a3834-04f3-430b-9ea9-d6c962568fce"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6fe4ddc3-7f3f-4914-8085-a315163a59ba"],

Cell["Prepend and append 0 to a list, then add together:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"8d8d5967-64e2-49d1-b30e-4d5ae70c8c07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", "#"}], "]"}], "+", 
     RowBox[{"Join", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", "0", "}"}]}], "]"}]}], "&"}], ",", 
   RowBox[{"{", "1", "}"}], ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"e1ec1d63-e987-40a4-8708-f0a31781de41"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "6", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "10", ",", "10", ",", "5", ",", "1"}], 
    "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"ef5c9b60-507c-4cac-8474-a48db82048ce"]
}, Open  ]],

Cell[TextData[{
 "If you put the result in a grid, it forms ",
 StyleBox["Pascal\[CloseCurlyQuote]s triangle",
  FontSlant->"Italic"],
 " of ",
 StyleBox["binomial coefficients",
  FontSlant->"Italic"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"f8ca5da7-0457-4180-a63c-cae119d89bdd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "0", "}"}], ",", "#"}], "]"}], "+", 
      RowBox[{"Join", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", "0", "}"}]}], "]"}]}], "&"}], ",", 
    RowBox[{"{", "1", "}"}], ",", "8"}], "]"}], "//", "Grid"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"19c75df3-f470-49a1-b289-80473e9dc8ec"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "", "", "", "", "", "", "", ""},
    {"1", "1", "", "", "", "", "", "", ""},
    {"1", "2", "1", "", "", "", "", "", ""},
    {"1", "3", "3", "1", "", "", "", "", ""},
    {"1", "4", "6", "4", "1", "", "", "", ""},
    {"1", "5", "10", "10", "5", "1", "", "", ""},
    {"1", "6", "15", "20", "15", "6", "1", "", ""},
    {"1", "7", "21", "35", "35", "21", "7", "1", ""},
    {"1", "8", "28", "56", "70", "56", "28", "8", "1"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[22]=",ExpressionUUID->"7ef74fc3-dc1e-4203-b558-e4ecb4813b10"]
}, Open  ]],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s another example of recursion with ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:158",ExpressionUUID->"5a3bfc86-c281-4584-aff0-8b220fc6d37c"],

Cell[TextData[{
 "Form a recursive structure with two functions ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"ac1d9348-bbcd-40c2-8552-3815e8da0bef"],
 " and ",
 Cell[BoxData[
 "g"], "InlineCode",ExpressionUUID->"f5a8059c-5d30-4338-9167-4ec534a199dc"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"68ec5844-2737-49d7-ade2-c3a10cdd69fb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "#", "]"}], ",", 
      RowBox[{"g", "[", "#", "]"}]}], "}"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"088336b1-4bc2-4def-a2ab-f4c523836cd5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"g", "[", "x", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"g", "[", "x", "]"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"f", "[", "x", "]"}], ",", 
           RowBox[{"g", "[", "x", "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"g", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"f", "[", "x", "]"}], ",", 
           RowBox[{"g", "[", "x", "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
     
     RowBox[{"g", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"f", "[", "x", "]"}], ",", 
           RowBox[{"g", "[", "x", "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"g", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"f", "[", "x", "]"}], ",", 
           RowBox[{"g", "[", "x", "]"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"13e5fc77-3c60-455e-8d8e-39fbba3b8c58"]
}, Open  ]],

Cell["\<\
Even if things are arranged in columns, it\[CloseCurlyQuote]s still quite \
difficult to understand the structure that\[CloseCurlyQuote]s been created.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b149651f-69f2-46d0-b1ed-0a6eab33acd1"],

Cell["Arrange the recursive structure in columns:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2e9ee232-a793-4ca4-a1b6-6d5903580c2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Column", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "#", "]"}], ",", 
       RowBox[{"g", "[", "#", "]"}]}], "}"}], "]"}], "&"}], ",", "x", ",", 
   "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"1871148d-604e-44e2-bfa9-a9531f09b4d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {
       RowBox[{"f", "[", "x", "]"}]},
      {
       RowBox[{"g", "[", "x", "]"}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {
       RowBox[{"f", "[", 
        TagBox[GridBox[{
           {
            RowBox[{"f", "[", "x", "]"}]},
           {
            RowBox[{"g", "[", "x", "]"}]}
          },
          DefaultBaseStyle->"Column",
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
         "Column"], "]"}]},
      {
       RowBox[{"g", "[", 
        TagBox[GridBox[{
           {
            RowBox[{"f", "[", "x", "]"}]},
           {
            RowBox[{"g", "[", "x", "]"}]}
          },
          DefaultBaseStyle->"Column",
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
         "Column"], "]"}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {
       RowBox[{"f", "[", 
        TagBox[GridBox[{
           {
            RowBox[{"f", "[", 
             TagBox[GridBox[{
                {
                 RowBox[{"f", "[", "x", "]"}]},
                {
                 RowBox[{"g", "[", "x", "]"}]}
               },
               DefaultBaseStyle->"Column",
               GridBoxAlignment->{"Columns" -> {{Left}}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
              "Column"], "]"}]},
           {
            RowBox[{"g", "[", 
             TagBox[GridBox[{
                {
                 RowBox[{"f", "[", "x", "]"}]},
                {
                 RowBox[{"g", "[", "x", "]"}]}
               },
               DefaultBaseStyle->"Column",
               GridBoxAlignment->{"Columns" -> {{Left}}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
              "Column"], "]"}]}
          },
          DefaultBaseStyle->"Column",
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
         "Column"], "]"}]},
      {
       RowBox[{"g", "[", 
        TagBox[GridBox[{
           {
            RowBox[{"f", "[", 
             TagBox[GridBox[{
                {
                 RowBox[{"f", "[", "x", "]"}]},
                {
                 RowBox[{"g", "[", "x", "]"}]}
               },
               DefaultBaseStyle->"Column",
               GridBoxAlignment->{"Columns" -> {{Left}}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
              "Column"], "]"}]},
           {
            RowBox[{"g", "[", 
             TagBox[GridBox[{
                {
                 RowBox[{"f", "[", "x", "]"}]},
                {
                 RowBox[{"g", "[", "x", "]"}]}
               },
               DefaultBaseStyle->"Column",
               GridBoxAlignment->{"Columns" -> {{Left}}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
              "Column"], "]"}]}
          },
          DefaultBaseStyle->"Column",
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
         "Column"], "]"}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"a14d94d2-bdc1-436f-9221-28668e10b7ec"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["NestGraph",
  BaseStyle->"Link"],
 " is basically like ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 ", except that it makes a graph rather than a list. It repeatedly applies a \
function to determine what nodes a particular node should connect to. ",
 "In this case, it produces a tree of nodes, making it",
 " clearer what\[CloseCurlyQuote]s going on."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"5712924b-9567-4270-a9ae-3f2360484a80"],

Cell[TextData[{
 "Start from ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"bca7fe0c-3b58-466b-b870-62cf3221f968"],
 ", then repeatedly connect to the list of nodes obtained by applying the \
function:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"0786e35f-8aa3-4e26-a553-18cd0b70bce2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestGraph", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "#", "]"}], ",", 
      RowBox[{"g", "[", "#", "]"}]}], "}"}], "&"}], ",", "x", ",", "3", ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"f2628035-86e6-45d6-a6e9-a3308b4bf899"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`x, 
       $CellContext`f[$CellContext`x], 
       $CellContext`g[$CellContext`x], 
       $CellContext`f[
        $CellContext`f[$CellContext`x]], 
       $CellContext`g[
        $CellContext`f[$CellContext`x]], 
       $CellContext`f[
        $CellContext`f[
         $CellContext`f[$CellContext`x]]], 
       $CellContext`g[
        $CellContext`f[
         $CellContext`f[$CellContext`x]]], 
       $CellContext`f[
        $CellContext`g[$CellContext`x]], 
       $CellContext`f[
        $CellContext`f[
         $CellContext`g[$CellContext`x]]], 
       $CellContext`g[
        $CellContext`f[
         $CellContext`g[$CellContext`x]]], 
       $CellContext`g[
        $CellContext`g[$CellContext`x]], 
       $CellContext`f[
        $CellContext`g[
         $CellContext`f[$CellContext`x]]], 
       $CellContext`g[
        $CellContext`g[
         $CellContext`f[$CellContext`x]]], 
       $CellContext`f[
        $CellContext`g[
         $CellContext`g[$CellContext`x]]], 
       $CellContext`g[
        $CellContext`g[
         $CellContext`g[$CellContext`x]]]}, {{{1, 2}, {1, 3}, {2, 4}, {2, 
       5}, {4, 6}, {4, 7}, {8, 9}, {8, 10}, {3, 8}, {3, 11}, {5, 12}, {5, 
       13}, {11, 14}, {11, 15}}, Null}, {VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGDgA2ImKA4OWT+z6wyzw82c+2fKfjBA6Q/2Z6zr0+Yt+GaP
Lm/56d2ZmzL8DjB5dPUQ+hqUfoYhv59LnuGYxx+4PLp5bsr+xptKOB1wyU9L
cN/ckCQEl0e3jwENoMujq0N3D8weXPKwcIDJo7sXQrPhlIeYxwOXR/cPxHwB
nPKQ+BCGywMAvrS/KQ==
         "], 0.04275994200999855]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.4748737341529163, 2.1213203435596424}, 
          0.04275994200999855], 
         InsetBox["x", Offset[{2, 2}, {2.517633676162915, 2.164080285569641}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.0606601717798212, 1.414213562373095}, 
          0.04275994200999855], InsetBox[
          RowBox[{"f", "(", "x", ")"}], 
          Offset[{2, 2}, {1.1034201137898196, 1.4569735043830936}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.8890872965260113, 1.414213562373095}, 
          0.04275994200999855], InsetBox[
          RowBox[{"g", "(", "x", ")"}], 
          Offset[{2, 2}, {3.93184723853601, 1.4569735043830936}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.35355339059327373, 0.7071067811865475}, 
          0.04275994200999855], InsetBox[
          RowBox[{"f", "(", 
           RowBox[{"f", "(", "x", ")"}], ")"}], 
          Offset[{2, 2}, {0.3963133326032723, 0.749866723196546}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7677669529663687, 0.7071067811865475}, 
          0.04275994200999855], InsetBox[
          RowBox[{"g", "(", 
           RowBox[{"f", "(", "x", ")"}], ")"}], 
          Offset[{2, 2}, {1.810526894976367, 0.749866723196546}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.04275994200999855], 
         InsetBox[
          RowBox[{"f", "(", 
           RowBox[{"f", "(", 
            RowBox[{"f", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {0.04275994200999855, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7071067811865475, 0.}, 0.04275994200999855], InsetBox[
          RowBox[{"g", "(", 
           RowBox[{"f", "(", 
            RowBox[{"f", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {0.749866723196546, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.181980515339464, 0.7071067811865475}, 
          0.04275994200999855], InsetBox[
          RowBox[{"f", "(", 
           RowBox[{"g", "(", "x", ")"}], ")"}], Offset[{2, 2}, 
          {3.2247404573494625, 0.749866723196546}], ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.82842712474619, 0.}, 0.04275994200999855], InsetBox[
          RowBox[{"f", "(", 
           RowBox[{"f", "(", 
            RowBox[{"g", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {2.8711870667561885, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.5355339059327373, 0.}, 0.04275994200999855], InsetBox[
          RowBox[{"g", "(", 
           RowBox[{"f", "(", 
            RowBox[{"g", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {3.578293847942736, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.596194077712559, 0.7071067811865475}, 
          0.04275994200999855], InsetBox[
          RowBox[{"g", "(", 
           RowBox[{"g", "(", "x", ")"}], ")"}], 
          Offset[{2, 2}, {4.638954019722557, 0.749866723196546}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.414213562373095, 0.}, 0.04275994200999855], InsetBox[
          RowBox[{"f", "(", 
           RowBox[{"g", "(", 
            RowBox[{"f", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {1.4569735043830936, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1213203435596424, 0.}, 0.04275994200999855], InsetBox[
          RowBox[{"g", "(", 
           RowBox[{"g", "(", 
            RowBox[{"f", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {2.164080285569641, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.242640687119285, 0.}, 0.04275994200999855], InsetBox[
          RowBox[{"f", "(", 
           RowBox[{"g", "(", 
            RowBox[{"g", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {4.285400629129283, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.949747468305833, 0.}, 0.04275994200999855], InsetBox[
          RowBox[{"g", "(", 
           RowBox[{"g", "(", 
            RowBox[{"g", "(", "x", ")"}], ")"}], ")"}], 
          Offset[{2, 2}, {4.992507410315831, 0.04275994200999855}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{320.265625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[25]=",ExpressionUUID->"d37fe4a1-9d67-4ce4-bc26-41f72ee97916"]
}, Open  ]],

Cell["\<\
Repeatedly apply a numerical function to form another tree structure:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6e4d3766-a105-41ac-a5f9-a9b2efc5d665"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestGraph", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "#"}], ",", 
      RowBox[{
       RowBox[{"2", "#"}], "+", "1"}]}], "}"}], "&"}], ",", "0", ",", "4", 
   ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"8777e817-c68b-46fd-a9ed-f1c01c9883de"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15}, {{{1, 1}, {1, 2}, {2, 3}, {2, 4}, {3, 5}, {3, 6}, {4, 7}, {4, 8}, {
       5, 9}, {5, 10}, {6, 11}, {6, 12}, {7, 13}, {7, 14}, {8, 15}, {8, 16}}, 
       Null}, {VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0., 4.}, {0., 3.}}, 0.05338164251207729], 
        ArrowBox[BezierCurveBox[{{0., 4.}, {-0.26065992844107355`, 
         4.1208856766115876`}, {-0.3377118644249173, 
         4.392605405643146}, {-0.25716115995679356`, 4.566353556025294}, {
         0.2571611599567934, 4.566353556025294}, {0.33771186442491713`, 
         4.392605405643147}, {0.2606599284410735, 4.1208856766115876`}, {0., 
         4.}},
         SplineDegree->7], 0.05338164251207729], 
        ArrowBox[{{0., 3.}, {-2., 2.}}, 0.05338164251207729], 
        ArrowBox[{{0., 3.}, {0., 2.}}, 0.05338164251207729], 
        ArrowBox[{{-2., 2.}, {-4., 1.}}, 0.05338164251207729], 
        ArrowBox[{{-2., 2.}, {-2., 1.}}, 0.05338164251207729], 
        ArrowBox[{{0., 2.}, {0., 1.}}, 0.05338164251207729], 
        ArrowBox[{{0., 2.}, {1., 1.}}, 0.05338164251207729], 
        ArrowBox[{{-4., 1.}, {-5., 0.}}, 0.05338164251207729], 
        ArrowBox[{{-4., 1.}, {-4., 0.}}, 0.05338164251207729], 
        ArrowBox[{{-2., 1.}, {-3., 0.}}, 0.05338164251207729], 
        ArrowBox[{{-2., 1.}, {-2., 0.}}, 0.05338164251207729], 
        ArrowBox[{{0., 1.}, {-1., 0.}}, 0.05338164251207729], 
        ArrowBox[{{0., 1.}, {0., 0.}}, 0.05338164251207729], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.05338164251207729], 
        ArrowBox[{{1., 1.}, {2., 0.}}, 0.05338164251207729]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 4.}, 0.05338164251207729], 
         InsetBox["0", 
          Offset[{2, 2}, {0.05338164251207729, 4.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 3.}, 0.05338164251207729], 
         InsetBox["1", 
          Offset[{2, 2}, {0.05338164251207729, 3.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.05338164251207729], 
         InsetBox["2", 
          Offset[{2, 2}, {-1.9466183574879228, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.05338164251207729], 
         InsetBox["3", 
          Offset[{2, 2}, {0.05338164251207729, 2.053381642512077}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 1.}, 0.05338164251207729], 
         InsetBox["4", 
          Offset[{2, 2}, {-3.946618357487923, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 1.}, 0.05338164251207729], 
         InsetBox["5", 
          Offset[{2, 2}, {-1.9466183574879228, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.05338164251207729], 
         InsetBox["6", 
          Offset[{2, 2}, {0.05338164251207729, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.05338164251207729], 
         InsetBox["7", 
          Offset[{2, 2}, {1.0533816425120772, 1.0533816425120772}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-5., 0.}, 0.05338164251207729], 
         InsetBox["8", 
          Offset[{2, 2}, {-4.946618357487923, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-4., 0.}, 0.05338164251207729], 
         InsetBox["9", 
          Offset[{2, 2}, {-3.946618357487923, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-3., 0.}, 0.05338164251207729], 
         InsetBox["10", 
          Offset[{2, 2}, {-2.946618357487923, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 0.}, 0.05338164251207729], 
         InsetBox["11", 
          Offset[{2, 2}, {-1.9466183574879228, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 0.}, 0.05338164251207729], 
         InsetBox["12", 
          Offset[{2, 2}, {-0.9466183574879227, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.05338164251207729], 
         InsetBox["13", 
          Offset[{2, 2}, {0.05338164251207729, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.05338164251207729], 
         InsetBox["14", 
          Offset[{2, 2}, {1.0533816425120772, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{2., 0.}, 0.05338164251207729], 
         InsetBox["15", 
          Offset[{2, 2}, {2.053381642512077, 0.05338164251207729}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{255.171875, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[26]=",ExpressionUUID->"7ed99a99-a9df-4ae2-b719-149866e26b98"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 ButtonBox["NestGraph",
  BaseStyle->"Link"],
 " to effectively ",
 "\[OpenCurlyDoubleQuote]crawl\[CloseCurlyDoubleQuote] outward creating a \
network",
 ". As an example, we can repeatedly apply a function that for any country \
gives a list of countries that border it. The result is a network that \
connects bordering countries, here starting with Switzerland."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:159", "i:23"},ExpressionUUID->"faf32d18-b5a7-4fd1-9e0d-43084fea0670"],

Cell["\<\
\[OpenCurlyDoubleQuote]Crawl\[CloseCurlyDoubleQuote] outward 2 steps from \
Switzerland, connecting each country to all those that border it:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"78601800-3827-4429-a91a-d8523f0a674a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestGraph", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", "\"\<BorderingCountries\>\"", "]"}], "&"}], ",", 
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "switzerland", Typeset`boxes$$ = 
     TemplateBox[{"\"Switzerland\"", 
       RowBox[{"Entity", "[", 
         RowBox[{"\"Country\"", ",", "\"Switzerland\""}], "]"}], 
       "\"Entity[\\\"Country\\\", \\\"Switzerland\\\"]\"", "\"country\""}, 
      "Entity"], 
     Typeset`allassumptions$$ = {{
      "type" -> "Clash", "word" -> "switzerland", "template" -> 
       "Assuming \"${word}\" is ${desc1}. Use as ${desc2} instead", "count" -> 
       "2", "Values" -> {{
         "name" -> "Country", "desc" -> "a country", "input" -> 
          "*C.switzerland-_*Country-"}, {
         "name" -> "Movie", "desc" -> "a movie", "input" -> 
          "*C.switzerland-_*Movie-"}}}}, Typeset`assumptions$$ = {}, 
     Typeset`open$$ = {1}, Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.402724`6.056552505291092, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{96., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True], ",", "2", ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[27]:=",ExpressionUUID->"9e66214e-91a1-4bce-bbc7-78c3dace1999"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
       Entity["Country", "Austria"], 
       Entity["Country", "CzechRepublic"], 
       Entity["Country", "Germany"], 
       Entity["Country", "Hungary"], 
       Entity["Country", "Italy"], 
       Entity["Country", "Liechtenstein"], 
       Entity["Country", "Slovakia"], 
       Entity["Country", "Slovenia"], 
       Entity["Country", "Switzerland"], 
       Entity["Country", "France"], 
       Entity["Country", "Andorra"], 
       Entity["Country", "Belgium"], 
       Entity["Country", "Luxembourg"], 
       Entity["Country", "Monaco"], 
       Entity["Country", "Spain"], 
       Entity["Country", "Denmark"], 
       Entity["Country", "Netherlands"], 
       Entity["Country", "Poland"], 
       Entity["Country", "SanMarino"], 
       Entity["Country", "VaticanCity"]}, {{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {
       1, 6}, {1, 7}, {1, 8}, {1, 9}, {10, 11}, {10, 12}, {10, 3}, {10, 5}, {
       10, 13}, {10, 14}, {10, 15}, {10, 9}, {3, 1}, {3, 12}, {3, 2}, {3, 
       16}, {3, 10}, {3, 13}, {3, 17}, {3, 18}, {3, 9}, {5, 1}, {5, 10}, {5, 
       19}, {5, 8}, {5, 9}, {5, 20}, {6, 1}, {6, 9}, {9, 1}, {9, 10}, {9, 
       3}, {9, 5}, {9, 6}}, Null}, {VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{1.0518115435400353`, 2.1222650994248897`}, {
         1.7178484162062129`, 2.71675266116471}}, 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.0518115435400353`, 2.1222650994248897`}, {
         1.7151206645055022`, 2.410935719784465}, {2.420288059038196, 
         2.2495397387228095`}}], 0.03332902941843116], 
        ArrowBox[{{1.0518115435400353`, 2.1222650994248897`}, {0., 
         2.37465945128411}}, 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.0518115435400353`, 2.1222650994248897`}, {
         1.2625869340648301`, 1.5812498855717554`}, {1.1110907243314472`, 
         1.020738846157621}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.0518115435400353`, 2.1222650994248897`}, {
         1.0294925566791076`, 2.327292477345338}, {1.1332268625110462`, 
         2.505543863515221}}], 0.03332902941843116], 
        ArrowBox[{{1.0518115435400353`, 2.1222650994248897`}, {
         0.3503856664237184, 2.962957294268734}}, 0.03332902941843116], 
        ArrowBox[{{1.0518115435400353`, 2.1222650994248897`}, {
         0.4905539974650128, 1.471606286772929}}, 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.0518115435400353`, 2.1222650994248897`}, {
         1.421358182173607, 2.0222239402830766`}, {1.6593845113691839`, 
         1.722363275543227}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{2.420288059038196, 2.2495397387228095`}, {
         1.7569789380727294`, 1.9608691183589895`}, {1.0518115435400353`, 
         2.1222650994248897`}}], 0.03332902941843116], 
        ArrowBox[{{2.420288059038196, 2.2495397387228095`}, {
         1.7178484162062129`, 2.71675266116471}}, 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{2.420288059038196, 2.2495397387228095`}, {
         2.126525576706295, 1.8608279592147368`}, {1.6593845113691839`, 
         1.722363275543227}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{2.420288059038196, 2.2495397387228095`}, {
         2.6250503539786716`, 1.6350002549283538`}, {2.425073692691885, 
         1.0188868647834746`}}], 0.03332902941843116], 
        ArrowBox[{{2.420288059038196, 2.2495397387228095`}, {
         3.086729378740152, 1.6095231012921345`}}, 0.03332902941843116], 
        ArrowBox[{{2.420288059038196, 2.2495397387228095`}, {
         2.6855488116412154`, 1.5967910299353438`}}, 0.03332902941843116], 
        ArrowBox[{{2.420288059038196, 2.2495397387228095`}, {
         2.585453681259055, 3.30179928425048}}, 0.03332902941843116], 
        ArrowBox[{{2.420288059038196, 2.2495397387228095`}, {
         3.124585967865053, 3.073566816396773}}, 0.03332902941843116], 
        ArrowBox[{{2.420288059038196, 2.2495397387228095`}, {
         3.4422247542007796`, 2.5813357475473486`}}, 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.1110907243314472`, 1.020738846157621}, {
         0.9003153338066503, 1.5617540600096165`}, {1.0518115435400353`, 
         2.1222650994248897`}}], 0.03332902941843116], 
        ArrowBox[{{1.1110907243314472`, 1.020738846157621}, {
         0.4905539974650128, 1.471606286772929}}, 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.1110907243314472`, 1.020738846157621}, {
         1.2698619724402216`, 1.4617129008675254`}, {1.6593845113691839`, 
         1.722363275543227}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.1110907243314472`, 1.020738846157621}, {
         1.7683867497126002`, 1.2358851965729891`}, {2.425073692691885, 
         1.0188868647834746`}}], 0.03332902941843116], 
        ArrowBox[{{1.1110907243314472`, 1.020738846157621}, {
         0.7400757830778975, 0.060699712583536236`}}, 0.03332902941843116], 
        ArrowBox[{{1.1110907243314472`, 1.020738846157621}, {
         0.21956505876454147`, 0.4579547530918662}}, 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.1332268625110462`, 2.505543863515221}, {
         1.1555458493719761`, 2.300516485585214}, {1.0518115435400353`, 
         2.1222650994248897`}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.1332268625110462`, 2.505543863515221}, {
         1.525092488005536, 2.2004753264401624`}, {1.6593845113691839`, 
         1.722363275543227}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.6593845113691839`, 1.722363275543227}, {
         1.2898378727356192`, 1.8224044346854735`}, {1.0518115435400353`, 
         2.1222650994248897`}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.6593845113691839`, 1.722363275543227}, {
         1.9531469937010906`, 2.111075055041246}, {2.420288059038196, 
         2.2495397387228095`}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.6593845113691839`, 1.722363275543227}, {
         1.500613263260413, 1.2813892208348385`}, {1.1110907243314472`, 
         1.020738846157621}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.6593845113691839`, 1.722363275543227}, {
         1.267518885874695, 2.0274318126130457`}, {1.1332268625110462`, 
         2.505543863515221}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{1.6593845113691839`, 1.722363275543227}, {
         2.1579092886415667`, 1.4965355712501571`}, {2.425073692691885, 
         1.0188868647834746`}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{2.425073692691885, 1.0188868647834746`}, {
         2.220311397751406, 1.6334263485779632`}, {2.420288059038196, 
         2.2495397387228095`}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{2.425073692691885, 1.0188868647834746`}, {
         1.7677776673107346`, 0.8037405143670633}, {1.1110907243314472`, 
         1.020738846157621}}], 0.03332902941843116], 
        ArrowBox[BezierCurveBox[{{2.425073692691885, 1.0188868647834746`}, {
         1.926548915419504, 1.244714569076018}, {1.6593845113691839`, 
         1.722363275543227}}], 0.03332902941843116], 
        ArrowBox[{{2.425073692691885, 1.0188868647834746`}, {
         2.407833183383966, 0.}}, 0.03332902941843116], 
        ArrowBox[{{2.425073692691885, 1.0188868647834746`}, {
         3.086729378740152, 1.6095231012921345`}}, 0.03332902941843116], 
        ArrowBox[{{2.425073692691885, 1.0188868647834746`}, {
         2.6855488116412154`, 1.5967910299353438`}}, 0.03332902941843116], 
        ArrowBox[{{2.425073692691885, 1.0188868647834746`}, {
         2.9904344413905193`, 0.10983754042548832`}}, 0.03332902941843116], 
        ArrowBox[{{2.425073692691885, 1.0188868647834746`}, {
         3.385468261683381, 0.5561443504983627}}, 0.03332902941843116]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{1.0518115435400353, 2.1222650994248897}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Austria\"\>",
           Entity["Country", "Austria"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.0851405729584664, 2.1555941288433207}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7178484162062129, 2.71675266116471}, 0.03332902941843116],
          InsetBox[
          InterpretationBox["\<\"Czech Republic\"\>",
           Entity["Country", "CzechRepublic"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.751177445624644, 2.750081690583141}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.420288059038196, 2.2495397387228095}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Germany\"\>",
           Entity["Country", "Germany"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.453617088456627, 2.2828687681412405}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 2.37465945128411}, 0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Hungary\"\>",
           Entity["Country", "Hungary"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.03332902941843116, 2.407988480702541}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.1110907243314472, 1.020738846157621}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Italy\"\>",
           Entity["Country", "Italy"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.1444197537498784, 1.0540678755760522}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.1332268625110462, 2.505543863515221}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Liechtenstein\"\>",
           Entity["Country", "Liechtenstein"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.1665558919294774, 2.538872892933652}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.3503856664237184, 2.962957294268734}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Slovakia\"\>",
           Entity["Country", "Slovakia"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.38371469584214957, 2.996286323687165}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4905539974650128, 1.471606286772929}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Slovenia\"\>",
           Entity["Country", "Slovenia"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.523883026883444, 1.5049353161913601}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.6593845113691839, 1.722363275543227}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Switzerland\"\>",
           Entity["Country", "Switzerland"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {1.692713540787615, 1.7556923049616582}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.425073692691885, 1.0188868647834746}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"France\"\>",
           Entity["Country", "France"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.458402722110316, 1.0522158942019058}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.407833183383966, 0.}, 0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Andorra\"\>",
           Entity["Country", "Andorra"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.441162212802397, 0.03332902941843116}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.086729378740152, 1.6095231012921345}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Belgium\"\>",
           Entity["Country", "Belgium"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {3.120058408158583, 1.6428521307105657}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.6855488116412154, 1.5967910299353438}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Luxembourg\"\>",
           Entity["Country", "Luxembourg"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.7188778410596464, 1.630120059353775}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.9904344413905193, 0.10983754042548832}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Monaco\"\>",
           Entity["Country", "Monaco"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {3.0237634708089502, 0.14316656984391948}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.385468261683381, 0.5561443504983627}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Spain\"\>",
           Entity["Country", "Spain"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {3.418797291101812, 0.5894733799167939}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.585453681259055, 3.30179928425048}, 0.03332902941843116], 
         InsetBox[
          InterpretationBox["\<\"Denmark\"\>",
           Entity["Country", "Denmark"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {2.618782710677486, 3.335128313668911}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.124585967865053, 3.073566816396773}, 0.03332902941843116],
          InsetBox[
          InterpretationBox["\<\"Netherlands\"\>",
           Entity["Country", "Netherlands"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {3.157914997283484, 3.106895845815204}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.4422247542007796, 2.5813357475473486}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Poland\"\>",
           Entity["Country", "Poland"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {3.4755537836192105, 2.6146647769657796}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.7400757830778975, 0.060699712583536236}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"San Marino\"\>",
           Entity["Country", "SanMarino"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.7734048124963286, 0.0940287420019674}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.21956505876454147, 0.4579547530918662}, 
          0.03332902941843116], InsetBox[
          InterpretationBox["\<\"Vatican City\"\>",
           Entity["Country", "VaticanCity"],
           BaseStyle->"Entity"], 
          Offset[{2, 2}, {0.25289408818297265, 0.49128378251029736}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{299.67300184542114`, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[27]=",ExpressionUUID->"53b789ed-6fc2-45a0-8fa6-415158376b90"]
}, Open  ]],

Cell[TextData[{
 "As another example, start from the word \[OpenCurlyDoubleQuote]hello\
\[CloseCurlyDoubleQuote] and successively connect every word to 3 words ",
 "in the list of common words",
 " that ",
 ButtonBox["Nearest",
  BaseStyle->"Link"],
 " considers nearest to it."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"a3598aba-ba48-428b-a549-cdc5cc4b1f53"],

Cell["\<\
Create a network of nearby words with respect to 1-letter changes:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e9fabb34-7a1a-44cd-8e5c-7a8a00f2aada"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestGraph", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Nearest", "[", 
     RowBox[{
      RowBox[{"WordList", "[", "\[ThinSpace]", "]"}], ",", "#", ",", "3"}], 
     "]"}], "&"}], ",", "\"\<hello\>\"", ",", "4", ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[28]:=",ExpressionUUID->"f706746e-34bb-48fa-972e-fdf4a0c1a93c"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
      "all", "ail", "alb", "allow", "aglow", "allot", "ball", "bail", "bell", 
       "belle", "call", "callow", "fallow", "cell", "cello", "hello", "hall", 
       "hallo", "hallow"}, {{{1, 2}, {1, 3}, {1, 1}, {4, 5}, {4, 6}, {4, 4}, {
       7, 1}, {7, 8}, {7, 7}, {9, 7}, {9, 9}, {9, 10}, {11, 1}, {11, 7}, {11, 
       11}, {12, 4}, {12, 12}, {12, 13}, {14, 9}, {14, 11}, {14, 14}, {15, 
       14}, {15, 15}, {15, 16}, {17, 1}, {17, 7}, {17, 17}, {18, 17}, {18, 
       18}, {18, 19}, {19, 4}, {19, 12}, {19, 19}, {16, 15}, {16, 18}, {16, 
       16}}, Null}, {VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[BezierCurveBox[{{5.917108145446676, 2.1767348777174425`}, {
         5.596323552491259, 2.107436168132876}, {5.487320965355178, 
         2.1873673736745882`}, {5.45231025998333, 2.2713712313614858`}, {
         5.569259333550731, 2.4992163776904146`}, {5.6579225002534, 
         2.519740521208954}, {5.786410576369309, 2.4777717719097088`}, {
         5.917108145446676, 2.1767348777174425`}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{5.917108145446676, 2.1767348777174425`}, {5.85121211448492,
          3.0835557243974065`}}, 0.05597153371489512], 
        ArrowBox[{{5.917108145446676, 2.1767348777174425`}, {
         6.524926630921547, 2.8964178347448204`}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{0.8911931183989976, 1.5778394942733571`}, {
         0.8155888312465681, 1.8656952295539133`}, {0.9066331948052919, 
         1.9947079926152838`}, {1.0059146743587053`, 2.0332185775787615`}, {
         1.2558428980188643`, 1.8737477285911426`}, {1.2627480772974264`, 
         1.7674829845050863`}, {1.1841057467660594`, 1.6305568985421202`}, {
         0.8911931183989976, 1.5778394942733571`}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{0.8911931183989976, 1.5778394942733571`}, {
         0.341002232447166, 2.2406453355071014`}}, 0.05597153371489512], 
        ArrowBox[{{0.8911931183989976, 1.5778394942733571`}, {0., 
         1.5965476164423795`}}, 0.05597153371489512], 
        ArrowBox[{{6.29079800134855, 1.4851102198738744`}, {5.917108145446676,
          2.1767348777174425`}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{6.29079800134855, 1.4851102198738744`}, {
         6.2224650474167404`, 1.8210079549659217`}, {6.295313376705404, 
         1.9210083344612985`}, {6.371391491001552, 1.9547895421521673`}, {
         6.58633475046312, 1.8589444161066917`}, {6.612046759036769, 
         1.7797740802287885`}, {6.586339643243164, 1.6587530110840192`}, {
         6.29079800134855, 1.4851102198738744`}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{6.29079800134855, 1.4851102198738744`}, {7.207536154357462,
          1.7060845022669522`}}, 0.05597153371489512], 
        ArrowBox[{{6.804639637319404, 0.5226252974646451}, {6.29079800134855, 
         1.4851102198738744`}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{6.804639637319404, 0.5226252974646451}, {
         6.797904710747468, 0.8113743102958652}, {6.9215158757068735`, 
         0.9191891672934214}, {7.031413246858732, 0.9322634990464415}, {
         7.236453438680032, 0.7036406756322159}, {7.211538990355364, 
         0.5958091375667914}, {7.09095557996662, 0.4846182897822523}, {
         6.804639637319404, 0.5226252974646451}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{6.804639637319404, 0.5226252974646451}, {7.570154443823164,
          0.}}, 0.05597153371489512], 
        ArrowBox[{{5.97099021224474, 1.231569253040854}, {5.917108145446676, 
         2.1767348777174425`}}, 0.05597153371489512], 
        ArrowBox[{{5.97099021224474, 1.231569253040854}, {6.29079800134855, 
         1.4851102198738744`}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{5.97099021224474, 1.231569253040854}, {
         5.823686194979994, 1.0125544106497169`}, {5.644404716553765, 
         0.9958961941439046}, {5.54017366133132, 1.0586612371280375`}, {
         5.535722078909278, 1.3929437696489748`}, {5.638244806506984, 
         1.4584621168466183`}, {5.8179062999052045`, 1.4465838815496332`}, {
         5.97099021224474, 1.231569253040854}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{1.1225680691353261`, 0.920306676559083}, {
         0.8911931183989976, 1.5778394942733571`}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{1.1225680691353261`, 0.920306676559083}, {
         1.4035383675319946`, 0.885544811783821}, {1.4938280137938, 
         0.7440097428841196}, {1.489385821246864, 0.6307831653204938}, {
         1.2236193327021234`, 0.46405261470797265`}, {1.1197421380102535`, 
         0.5093242323546087}, {1.0316003246620964`, 0.6522067599436174}, {
         1.1225680691353261`, 0.920306676559083}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{1.1225680691353261`, 0.920306676559083}, {
         0.4976483119080126, 0.3313601337698474}}, 0.05597153371489512], 
        ArrowBox[{{5.944478618059957, 0.3572813369821555}, {6.804639637319404,
          0.5226252974646451}}, 0.05597153371489512], 
        ArrowBox[{{5.944478618059957, 0.3572813369821555}, {5.97099021224474, 
         1.231569253040854}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{5.944478618059957, 0.3572813369821555}, {
         6.191195040780236, 0.2617644681738952}, {6.246940072239025, 
         0.09094929686692067}, {6.208940266404918, -0.024364451774524898`}, {
         5.884688433357688, -0.10317344400541423`}, {
         5.798000546133431, -0.01816487927357753}, {5.769125480051715, 
         0.1591810026626797}, {5.944478618059957, 0.3572813369821555}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{5.004664414818945, 0.0799544489611721}, {5.944478618059957,
          0.3572813369821555}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{5.004664414818945, 0.0799544489611721}, {
         5.191439897334605, -0.023162852657122174`}, {
         5.232753209769381, -0.22449076867830967`}, {
         5.165486073086871, -0.346510013937091}, {
         4.791535814032906, -0.3229248672243756}, {
         4.740132307931055, -0.19342103156139964`}, {4.806413240702989, 
         0.0011208855275663676`}, {5.004664414818945, 0.0799544489611721}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{5.004664414818945, 0.0799544489611721}, {
         4.507492764014705, 0.1274178868402464}, {4.135547167262554, 
         0.4607179038749196}}], 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{4.135547167262554, 0.4607179038749196}, {
         4.632718818066794, 0.4132544659957493}, {5.004664414818945, 
         0.0799544489611721}}], 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{4.135547167262554, 0.4607179038749196}, {
         4.226203672511496, 0.25639822557866504`}, {4.137503975309382, 
         0.07576208509480609}, {4.013142530871718, 0.019888006065363284`}, {
         3.727960114680061, 0.2529038322150042}, {3.757925543578284, 
         0.38590666918082234`}, {3.917257698300187, 0.5088306945148746}, {
         4.135547167262554, 0.4607179038749196}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{4.135547167262554, 0.4607179038749196}, {
         3.5860581879547357`, 1.240953822567897}}, 0.05597153371489512], 
        ArrowBox[{{5.035020174756496, 1.6361386357248582`}, {
         5.917108145446676, 2.1767348777174425`}}, 0.05597153371489512], 
        ArrowBox[{{5.035020174756496, 1.6361386357248582`}, {6.29079800134855,
          1.4851102198738744`}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{5.035020174756496, 1.6361386357248582`}, {
         4.767076247351663, 1.7037180439903326`}, {4.693523464415319, 
         1.859558438968474}, {4.713879268704481, 1.9741241761279906`}, {
         5.0088160599260965`, 2.101626607027514}, {5.1062188325009, 
         2.0379684041475783`}, {5.169353914929415, 1.8776243928737897`}, {
         5.035020174756496, 1.6361386357248582`}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{3.5860581879547357`, 1.240953822567897}, {
         5.035020174756496, 1.6361386357248582`}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{3.5860581879547357`, 1.240953822567897}, {
         3.3479089901642043`, 1.3815633993405}, {3.32136626664837, 
         1.551685161696286}, {3.3731587198221082`, 1.6557711975186165`}, {
         3.691814430570128, 1.6950631213496286`}, {3.7673398299112844`, 
         1.6066760458616356`}, {3.7829176338205226`, 1.4352022512921976`}, {
         3.5860581879547357`, 1.240953822567897}},
         SplineDegree->7], 0.05597153371489512], 
        ArrowBox[{{3.5860581879547357`, 1.240953822567897}, {
         2.046384807712434, 1.2731202452362242`}}, 0.05597153371489512], 
        ArrowBox[{{2.046384807712434, 1.2731202452362242`}, {
         0.8911931183989976, 1.5778394942733571`}}, 0.05597153371489512], 
        ArrowBox[{{2.046384807712434, 1.2731202452362242`}, {
         1.1225680691353261`, 0.920306676559083}}, 0.05597153371489512], 
        ArrowBox[BezierCurveBox[{{2.046384807712434, 1.2731202452362242`}, {
         1.852498558638061, 1.465876173789508}, {1.8691030846034442`, 
         1.6392877299752955`}, {1.9463703938753978`, 1.7280072900137604`}, {
         2.2677217239243053`, 1.6829190690552114`}, {2.3175900319765037`, 
         1.5763613416603504`}, {2.2858307793082693`, 1.4050761176295927`}, {
         2.046384807712434, 1.2731202452362242`}},
         SplineDegree->7], 0.05597153371489512]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{5.917108145446676, 2.1767348777174425}, 
          0.05597153371489512], 
         InsetBox["\<\"all\"\>", 
          Offset[{2, 2}, {5.973079679161571, 2.2327064114323374}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.85121211448492, 3.0835557243974065}, 0.05597153371489512],
          InsetBox["\<\"ail\"\>", 
          Offset[{2, 2}, {5.907183648199815, 3.1395272581123015}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.524926630921547, 2.8964178347448204}, 
          0.05597153371489512], 
         InsetBox["\<\"alb\"\>", 
          Offset[{2, 2}, {6.580898164636442, 2.9523893684597153}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8911931183989976, 1.5778394942733571}, 
          0.05597153371489512], 
         InsetBox["\<\"allow\"\>", 
          Offset[{2, 2}, {0.9471646521138928, 1.6338110279882523}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.341002232447166, 2.2406453355071014}, 
          0.05597153371489512], 
         InsetBox["\<\"aglow\"\>", 
          Offset[{2, 2}, {0.3969737661620611, 2.2966168692219964}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.5965476164423795}, 0.05597153371489512], 
         InsetBox["\<\"allot\"\>", 
          Offset[{2, 2}, {0.05597153371489512, 1.6525191501572747}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.29079800134855, 1.4851102198738744}, 0.05597153371489512],
          InsetBox["\<\"ball\"\>", 
          Offset[{2, 2}, {6.346769535063445, 1.5410817535887695}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{7.207536154357462, 1.7060845022669522}, 
          0.05597153371489512], 
         InsetBox["\<\"bail\"\>", 
          Offset[{2, 2}, {7.263507688072357, 1.7620560359818473}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.804639637319404, 0.5226252974646451}, 
          0.05597153371489512], 
         InsetBox["\<\"bell\"\>", 
          Offset[{2, 2}, {6.860611171034299, 0.5785968311795403}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{7.570154443823164, 0.}, 0.05597153371489512], 
         InsetBox["\<\"belle\"\>", 
          Offset[{2, 2}, {7.6261259775380585, 0.05597153371489512}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.97099021224474, 1.231569253040854}, 0.05597153371489512], 
         InsetBox["\<\"call\"\>", 
          Offset[{2, 2}, {6.0269617459596345, 1.2875407867557491}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.1225680691353261, 0.920306676559083}, 
          0.05597153371489512], 
         InsetBox["\<\"callow\"\>", 
          Offset[{2, 2}, {1.1785396028502213, 0.9762782102739782}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4976483119080126, 0.3313601337698474}, 
          0.05597153371489512], 
         InsetBox["\<\"fallow\"\>", Offset[{2, 2}, 
          {0.5536198456229078, 0.3873316674847425}], ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.944478618059957, 0.3572813369821555}, 
          0.05597153371489512], 
         InsetBox["\<\"cell\"\>", 
          Offset[{2, 2}, {6.000450151774852, 0.4132528706970506}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.004664414818945, 0.0799544489611721}, 
          0.05597153371489512], 
         InsetBox["\<\"cello\"\>", 
          Offset[{2, 2}, {5.06063594853384, 0.1359259826760672}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.135547167262554, 0.4607179038749196}, 
          0.05597153371489512], 
         InsetBox["\<\"hello\"\>", 
          Offset[{2, 2}, {4.191518700977449, 0.5166894375898148}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.035020174756496, 1.6361386357248582}, 
          0.05597153371489512], 
         InsetBox["\<\"hall\"\>", 
          Offset[{2, 2}, {5.090991708471391, 1.6921101694397533}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.5860581879547357, 1.240953822567897}, 
          0.05597153371489512], 
         InsetBox["\<\"hallo\"\>", 
          Offset[{2, 2}, {3.6420297216696307, 1.2969253562827923}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.046384807712434, 1.2731202452362242}, 
          0.05597153371489512], 
         InsetBox["\<\"hallow\"\>", 
          Offset[{2, 2}, {2.102356341427329, 1.3290917789511194}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{400.140625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[28]=",ExpressionUUID->"d4ba3131-6d70-4ab7-8133-27856731cdd9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3ffa75fa-0d1c-4d70-a2d6-5a754e58287e"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NestList",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["f", "CodeVariableLrg"], ",", 
      StyleBox["x", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "make a list of applying ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "c7e96292-0ac1-470f-9f6f-fbb6291f4465"],
     " to ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "ff4cfd36-9b80-460d-b5c1-c184cac615f2"],
     " up to ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "46764433-350f-4268-9b84-9f2a53b03207"],
     " times"
    }], "VocabularyText",ExpressionUUID->
     "28132fad-775c-451d-8572-c760ff2ac2a1"]},
   {
    RowBox[{
     ButtonBox["Nest",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["f", "CodeVariableLrg"], ",", 
      StyleBox["x", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "give the result of applying ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "670c4565-4c26-42c4-947b-6fe0594576d0"],
     " to ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "fc16b807-0a47-4116-b1e9-8e19f94f8e5b"],
     " exactly ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "7f95923d-f224-4571-a8b6-d17f58c15636"],
     " times "
    }], "VocabularyText",ExpressionUUID->
     "dc531480-f531-41c7-acea-9adad043921c"]},
   {
    RowBox[{
     ButtonBox["NestGraph",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["f", "CodeVariableLrg"], ",", 
      StyleBox["x", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "make a graph by nestedly applying ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "3e75ef37-3e76-47f1-b11b-c02ce3346a4a"],
     " starting with ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "36056aba-da37-4730-9216-1d5f50c87f7d"]
    }], "VocabularyText",ExpressionUUID->
     "23369ad0-614d-4531-9f98-767a7135eb00"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"a55fb0ba-d5fd-4b03-9bd1-2e21307697d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"064770d0-9dc7-47d7-b78d-eb03ee094749"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"11 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 5 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{
         "EIWL2-27-applying-functions-repeatedly-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ebe0b97b-8c64-45f9-8a71-b5750616c2b4"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the results of nesting ",
 ButtonBox["Blur",
  BaseStyle->"Link"],
 " up to 10 times, starting with a rasterized size-30 \
\[OpenCurlyDoubleQuote]X\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"117c8006-fe6f-48a4-8e36-ec2c796e6cc2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[RasterBox[CompressedData["
1:eJztUqtyhTAQzUw/oN9QU8k/8AXMVKOuwPZaLC4SFxcVFYWKwqAwGAwGEYNB
IDCICMpr9wI3VLbmnpnMJJuTze7Z83H7/rq9EUI+p/U+rXk/vvAnUKFDFnhx
biX0BSMb/L7ksHfT9pnbUne7dkI1jia5O3g0R2qTRpDKy7r1dQqvidR7eh1i
BbzEaBF7EBUDUkUA3LDe5xhKvOBlv0Z8iERPzejkDtXxKXnJ4C+P9RaRGgqN
MiUxragHC3eWNCZHLHJdYRCBs+OCXBfoc/rgBtL8yuX+oQxe2Que0GWUnOCx
i0I0jjZUhQQPRJnFMbUEnZ2omRxTocFCfZahwGLplmoQEApEtefmFOblxlik
qQUk8AucYqNQXFbsGzIJOMal2fqdRA/5/GQDoxMcpmrM8GiECIuqRkHfJEhG
0+sNFomWnztdz9dNezmgF/4RP02tQHw=
           "], {{0, 0}, {15, 38}}, {0, 255},
           ColorFunction->RGBColor],
          ImageSize->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFANiPmBGMT+PwrIBv8QgKCCXz++fPjw/u3btx8+fPrx89dfFC3//v759ePr
pw/v37199/7Nx2+vHl87dmjPtq1b9+w/cuvR8y/fgephSv/8+vrh5Z1LR/fu
2rZ55/5tJ29fObKyrSo9LNgvOjlz2prdt569/fH7L8TUn1/f3724b3ZHdmxk
YGBCfsqEzfcu7JhaH+dkrqVpaBZa3L755LXXn78DHfP3z893z27tXN4T6WOl
o2vgGJLdtOzg+2c3962ckORjo66kZOQc2DJ349VHr77/+v3jy9tbZ7Z1l4aa
6alqGTmm18/Yde7er28fH1w6PKsh28lQW1nTKCCzcf3hyy/evX/95Pq2JR2h
7mZqanquQQXzNh5/+OrTv7+/Pr9+dGLTgsJgN11lFSN7//rpq09fuX7h2OaO
ohBzPXV9M8+SjiWnrj/5/OM30CdAK5/eOL20q9zLVF9V3dA7vmzWspULpjUG
uZtraBp7R1Qt33Hu2buvv8HBBPTM13fPz+9cWRvhY6SqrGNsHZWamhTpbmig
beIUWDtl7YW7L77+/IMI0Z/fXt69uH5KfaCDvryMhJySopKSnKKOSWBe6/oj
V159/P4HKbL+/fvz/ePLK4fXNmZ6aiuK8HBz8giL6zj4N8/fdPXx6++//6Im
BaDLPz26dmRWU7KJpgwnJyeXmKJ5SP6CnWeevv/6By3Z/Pv7/dPrq8c2N+cE
6yhJ8nBx8wjKGjonTFix787zDz///EVW+ufXt1cPL2+c0xLkYq4gKysnKycj
JqWiY5tUNWHvudvvv/5AJJi/f759eH5x/6r6lAATHS09U5fIyOgAS2MtZVVr
z7CuJVuvP3nzHZJgwOH87NaZFX3lPjaG6npm/mm1M+fN769IczHWVtMxCcpt
2QALkH9/f39+8/jUloUlIe766mpmrsFt8zacvnDh0Pp5RcGuwDg1tPOvm7T2
wh1QUAPTxqPLR+c15bqa6ACNDS3q2Hry+ss3bx5fP7W0s8TTRE9FycArrGrp
9rNP3n758PzOwdXTMvwcdFTVrL3CepZtv/ns7fdfP7+8e3Zux7KqcC99RWUd
I/eCtoUHLz+6cXJLX0WCrYGWlqFtUvWEPeeBfv8JTM9/fn59cefC6km1vjYG
Soratr45zQv371rUmBDkZKBv7BqUNWPtwXsvP0BSAVD5t48vLx1a15gdbGag
o2ni6ZYxecvMssL0mNik9MbJy09df/zp+y9YdAED//vrJzd2rJiak5boH5wU
GN/16PrJU8cPHz1x6uqdx+8/f/+DnAqAaf37l5dP7p45deLAgaP7Dl78+f3L
1y+fv3z9+v3nrz9/0YsOUMj++vn169fPn798+vQVe8EyUgEA6h1MSg==
            "], {{0, 
            38}, {15, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVFlQWlcYdtqXvrXPbVLTh2a6aM2kcbpM046NCyoIIhKJRAUFtaik7nFD
QalLWsy0VuMW17rEuIGJGhFocd+jQtwjyg6KIMtlMT06NnX60jz2od/cc5dz
/vvf//7f+b73iFQ0+TUnJ6ekN8AJTUjzSEwk3A56CzwEJyTFRieQonwTkknR
pMTPia+DyYtgvAnG8f2L/3EWR3/jXwPsNgiCLADgYrPbHWdfOTpyOOw2qxWs
my2Q2WI92FMqZLsSiUQqk+/p9GbI6nAcnUbarRaTfk+jkO7ubEmkm1L1pnhy
VDDQx+ntH+LNLq/KtTozZHMc57RZjAfKnbX5CX7/Y07nI24Xf26K96DxXhEt
KzWLzqxpZ0+JNjQHRqvNZrUYtYqtWWFfXXlhVnZGCqM0t7p3htdew8qMjcBi
cKFUWnHrgHB1R6k3Gg069cbSWEfdT0mUcCwOT0hk0Kp61xcEPQ2slOgbcF9Y
UFgMs7xJMCuSKpUyycrIYGtJTtx1NBwZHJGU/2sdZ1QjXZvm9ZQxUvGBcJg/
mpzCqO9+Mru4ND/J+62ykELAwv1R4bEZZU19I083zQat5Nnco+aKjJjwAB/f
QFxUzp2Kjl52Z1t1/u1YbCAiEBuZVVT9+I+FLfm+3Wo+UO0+FQ5UF2VHYpC+
MASeRM1lMum0ZAIeAw/ARFHzatuHFtel+4cW0E2LUS9bX+I+uJ8XH4nyvubp
7YPGYjAYBMzPF30zhn63YXhCJNPoLTb7ixMS9Vq5aGK4gZUbGQz7wt3tEzfX
S1c+/congJRa0MgWiJ8rDCbIfkIWSA6Z9PLNpaGHVRnfYa9e+dDZ+dyFD1y/
QeGz79YNT4sV+4Zjok73gMMGmbSyjbGB1oIUgsdnH5975+3zFy95Xo8pru2a
FG/vH5rtL2OPHJDZIH8u4nbVZsaFfu3u4nz+3Qvvu32LIjLKWoTza2rA6WkR
x3kNewrxDL/xl/woXMCX7pddP3Jxdbl81TMwPqukY3BsXao2Wqxgw/xV8PJw
Vz0jORrtD/Py9kMikHBPz2seXtgISnFVq3BhVaU7BGUf91ktXRwdrP2RRrqB
9g9Ah0XfysrOSY8nhyD8/BBBsWnMppOG6E2g2L2dlfn+lspsCiEQDg8Oj8lj
3Wvr6GiqYKWRbwJO0SFkOqt+aHx5R3Wgla7P8tnlBekRGCQCFRyXWdjM4c7M
zY9zOZU/ZBLQSJg3ikihVbYMTixvr87yu++XppLxSH84LjL+Tk3byMKzXbl8
e2XhSVsNjUJEesHgqIhkRkUDZ1zQU12aeyssGIXChCblsTq54xsyteHwUKeW
LY9z61h0UgjaxweJIaYnl7Q8rKTTkkhheDz4rfJm9rR4S6s3AaUA9SmeiwXs
5sJMKg4bggih4KgsdkPJz8U0Rj6zrLaNN7G4qzrVIFA1yL6+NNnbVstk0L9P
zadmVixNcoX8wWG+YGpeJJFrDs3QGa7MOo1iTbTwO5/H6eN2c4T7GrlKKVOq
VMAHTBYQ6XhpHEDhwDIMep1KpZRKFTu7SvA5YCOgSPuJw/zDlU4YtttsxyEQ
ZAUTJ8crmdyrWuJ/CX8CkeZNKA==
            "], {{0, 38}, {15, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzdVNtTGlcczrQvfWv/hb7kpc3lJZOb7TROXmyaSSS1uRuQhUUjgiuIaKIS
iRCJhogXlIjBEpya4I2AihElagwSjCSSaJC7BlBMuK5cJOkBM512ptOnTh/6
zTk7u2e//Xb39/vO93UeBUP8bMeOHSVfgAMGxziCIDjmqa/ARU5RST5cRICy
imgEmIAcyPscLO4E80swU+cf///48PFDCv9I2cbHZHLrDySTyb8+lWIk04xE
ekTRcCQcAgiHI5vRGFhJbvNTtK1EPLaJRsDdQDDsD0bW3A6Xw2KxLNvsDvea
LxiOxOKJZFouHkWDfp/nrdNqtSwu215ZV14bp59OjqpHVKOa8dn5BfuqJxBG
Y/F4DDDfeR3LJv2MdkQ90j883qeZnRl7IL/X1tx4k9/ULJUrpucWnB6gHwaa
K7ZXTyeUMomwgc/nNonrJYNTwzJpWx2rHCkuKWHxGrsVj56/trz1et0rVuPs
+P2uZnYVg0pj0Gv47Hb586mHvV0CdjmFCOELihk8oWRI+3RhcdH0YlY9eO8W
p4JcAMNk+pW6tpbf1LZX+sdDPa111RQYj80j0io5IplcPT7+aLi/s5XHRC5D
EEwtYwvu9iq0cxtu22vDZH+XsKaUCl3CQvmUKk5Du1gsartdc5WWT4TgyzR2
w53ekSdziw40COiLM6ODono2AuNzL+QS8sl0ZhmjlEqC8TiIRLvC7ehWzsy/
cXreJ6JowOcxG3VKWUdtGRV3NgeTffJUzqmc0z/nnD0HFdK5gruqCb3Z6X0f
2gRdikaCXqd5VvOwo+FaIe6XrKPfH844mHEk81jO+aIrHPH9If2CxfsuuBlL
gK4mYpsBn3tpfrpPImAWXszKPLBnz669+zOOncFX8IQDGh2QDUaiia0k8MBW
Ihb2r4P/VPWIqhD8j5kHd337ze59GcfPk2oEEvUTo8OzEYnGU6YByvFoYMPz
xjjT92szk4zNyjy0Z9fuvfu+O36GUFUvUmqfWVbXQmgs5Zjtb3Yt67UqceN1
Mv5c1tEfDu0/eOjwkZ8wF5FKnrR/dH7J7vOHgXYiBornWX45q+rp5F4twV88
i8nOzj5x8uTxExjMaQK5tL5NOvrkuXV1PRBJecttX9KNKTpuc2iFMBaLA3VG
ihFqASnvwoVLOJhRzeuSj4CCrK77N9z2RcPUgLT9OhOBITyJjFRzG1qFwqab
nHLKZXwuFi6gc293KsZ0L8wrNpN+UnVfyGMh+UQCsYB5rU7c3TusVivl3S1c
FpUIYXOJxYzaFsmA6rFRr+nv6eCzSikwBJFpFXyRdGRS99JkmtdNDkhFtWUI
IReHIxSXsVsE0iGlrKmZW0EjkwoKqdV1gh6lxrhkfet2u6xLOo2ys/EGvTD/
EpYEUVi0WnGPiHvrOrOcQa+sqbsj658ymFxgp4RCfp/XYjKo+2R8DotKKSGQ
K0lljQpZs6Sd39rSIpHJx6afmR1uP2hADGzqkM/tXDBMDz6QCRoF1zhNlTfE
c9PqqQn1hFarMxjN9tUNfygaBy5IpQAaCnhW7QtGw4RmXPHwUe/ghGfFuuK0
uVwuz9q6PxhOM7fzJ80PhzbW11xO17LFvmR2bKJhNBJGUTQajX0i/imPQA7F
QCigKIigYCgCXpgen+T+NuTSkZMKsX8vYP87/A6AFk3H
            "], {{0, 38}, {15, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzdlFlTmlcYxzPtTe/ar9CbfoY21os0i22TTmasmmVsmsSQuEQgvKCgbCou
iCAomigIKCYExA1cYhQRgYDEEaNEJSBLwA2QXWTT9qBJJzOdTu960f8858w5
7/M/533nPc/5fX0XkXv/szNnzkBfgC73TuU5FOoO7tevwCQfDpU8gMPu/QRH
wx7AUN/e/Rw8/Aa0L0HLjP/4v+v4+CgTR6DP6O/pUx1ldJxKJZLJ00im0umj
k1UfbWCWTqVSIBVPZCIaDoSC/kAgEAyFogcH8UTidMmJLxk/jEUiYZD1+QNe
f2j7vdVhe2exmK02m2t7Zz8Yih3Gk2C3RDwWDft9u673dpA2ma0rZvvqknpB
o1DOvpxVqQxLbywOl9cfBK+IRkK+Pbd1Y8WgU08rFPJp1eisXjMzKJf29fG7
ewSCgdFxtcFocbo9Pq9n17258UY7NznwXNjF5bXzRB1P5XPjzyQCNpNGodRT
GB1dYtkL3dKqxbZpNZsMmmnpM24rvammnlrL6GrmSnUzQ0P9j1sbSbhKTBWp
jtXdOzql0BkMeq1SPtjf0dpIqK7CEigUZk97v/zt4pxCLuKwmgiVEAqFIVKa
n/D7B0dHhgafcToZtUQcGoMl1NHZfKl4UuOymozamSFhd3MNHkIgHkGV5Hoq
s72NxaTVkasxaKgCR6a18yRjStXiWmDPbV9fnp8c7mHR8GhkWXFxWTkchYYg
NBIOL4c/wpDqGTyRTKlfWbNtxcIBj9u+apgffdpDI2Efwu4U3rx+/ca1G4U3
bxXB4BUEeqdANq1dMTu3vcFkPBb2e5zmlfnJoW4GBVVyO+/qz5cuXci5/EvB
rXtoEpUrkqkX3zqANRIDZ3oYDe25NsGXizitOERR7pUL2dlZ2edz8n4vxlPZ
4nHl8obd4w/H4klQAfFYxLfjXH2tkvayCaj7wHz27HdZ53Lyb5eS6V3D09q1
Tfd+6AAUwYed3TajTiHqYVUhYblXLn2flZX9w4/5t0qIzZ3SSdXKO6c3EIkl
QGHFIgGv02JSvxzhsBqh0rt5Vy9fPH/hYs6VgkJYJZkmGBjXLa+7dvfDByfW
LYdpUSN7zm+pqy4vLiq8cb0gL78g71rhb0UIDIHZJZxQ6tc2gT2U+XHry+qp
EX4HnYiFysvKyh6WI+AIeGlpyf3ih3CI3Mjsk4yrX5vMjp3MCb5SDPdz6RRi
BYRCV+Bq6pvodAatgUKoQCPLEZhKMp0tGJyY1y5tmBaUM6OgNqgkLAaDwdY0
tnTz+wekUrGQz25uqIYgJAJTTW5h86SSCY1qTCTuaaPV4oEXT65nc4WyqVnt
K51aMTXQy2mpJaIRKCREIDQ+pnOGRvrau1spFCIOTyDR2p5IZFN64yq4R+ur
xvkpmaCTVVNdhXyEQ+Ko2AaOpIfRxWygNdXTmew+8cicfgncrD2PZ8fleLuk
fzEsfsxikEgUDL4ZXdM5JuGKhd3CXoFkcHRWs7Bmce7tByKRaCiwv+W0GhfU
Y8NSLofHaONRWcLXmpda1bRaPW9YNG5YHbtefzR2CCACIBDy+1wO65ulxTml
amxCMSRXuuxmh83icNjd2zs+cK9j8VPWpNMpAINw0L+7vWWz2dc3rKY1ayQU
CIeC4XA4Q5j4CWH+QlY6nUwkYgcH4VDYHwju+4MAJycBXJ+w6yPnMlxKfyBY
IpE8/kT/QM5/Mfz3+hM16k5L
            "], {{0, 38}, {15, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVlGlTWmcUxzPtm75rv0Lf9DP0bWeaxEwbzWYnTaitSWhqrGLQxBEBUWSV
BBBkEZFNBYawuOHKImBQVAKurCKLlR0E2dzaS0w6melMZjp91f+c55l7n+d/
zpy5Z+7vyweQW79+cunSpebPgO1Wbes3UGht2+0vgJfqxua6x43gR9caW8CP
wdCvH3wKHH4FrM+BVX7+83+p83Kcn3/MUb4v6+zs9H2Udf5h1jtDWadlnZWK
+WI5CsVisXR8fHJ6epHy1nV6cnJcKpUKhWK+UMjli+lULJmIJYBIJg8zmVy+
cJEC+ABX7iibTqfi8Xg4Fj+IJgI+567H4XI53B6PPxiKxpOZo1wBUD6XOUxG
w/t7e16H07W+47LteOyrBstrnWFBYzAZLVabw+v7IxJLpVOpZOwgtOfcti8v
LWp0erXGMKE1G+eUU6MSmUQklkhUk1PGpdVttzcQCgX9uzubVpN+VqmQCYbF
nGE5RzqhnRArRjgcJqW3l8Li8mRjU4allfXNjQ37qkk/I5cKWUw6idpHYvDJ
vFeGaZlyhMOiEnEYNI5IYnAF8nG1Rq/Tzk8rZUPsPgoeh0MTyMQ+Pl2osppm
ZkfFPCYZj+5AIjuwhBfMgcFhiXhkmM9mUAhYNKqzG0uiM/iyoVGNe2NlWT+t
GOJSCRgkrA3WDu/CYHtekEgkfDcahUAgUGgChSkQq+ZmjNaw3+2wLWsn5TwG
pRvR1vK0CRC0GdrcAoW2tLTCkFgSjScenTWsrm150/FwaNdhXdQqh7gvMcjm
hrqHtTU/1YBqamvBTxqew9EUlkA5vbCy7vIGI/lsOhEOutZXNeMyNhnbCnkM
unu7qqryxp0fasD1bV1EzrBC+9rq9O1HEofASDPJaMC9ZdZOClkv26G/3auu
rKi4UnH9Jgj8OwLfO6ScXrI5AgfxdDZ/XCocpRP7PqfFMDMyQEW0PPnxTuXl
y99e+e4GCNyA6umTjmvWNt370VQmVyxXTsUCnm2zTi1ik9ub6+5VV129eqXi
+5ugRw1IAm1ENWtZdwbDifRRodxzJOTaXNNOvuqn4lub6kB371Rev151s7rm
YT2sizQoVi0s29z+A6D2YTwM9GA161RiHhnf2QKpf/jLz6B790H3ax6B65+3
o3v7ReOzRuuWZ28/Gg64nXaLTq0UsHuxKPiz5qdNEEhTIwTS0AhpaHrWCseR
6EKg70Wrbcd3MUHl8CCNhEMh4HA4sqsbS8ATcN3oDhisDZgKCk9lCqSj83Om
NysLU9OKYR6DTEB3olCd+B4ykzMoEokEA/00ErELgWiHodA4Kn1AKlLMzylE
0kE6rQeL6erEEV6wuEL5mHpufn5mckzCH6AQcB3wjnYErovIJrGkCgGd19dD
JmIIBCKdzZWNqg1mi81ut1rM85MqIYdJxOLgCAysk4wgcGR8Gp9FZtIprP4B
iXxMt2jZcnr8fr/P43yzvDilesVls4hECgpLQ+L71XKBUiqQScWqsQmdaWnD
4QkdRBKJZCxysOdxrJqN6rFRoXCE0T9EZYktprnXBs2iybiyZt1xeUPlb5/N
5fNH2UwiGvZ5XG/WVvV6g3pap5rU+Tzbu27H7q43EAxFYonD7FEBgM1buAAJ
yXhsPxh0uz2bW077hhP45VPJeCqV+pswp+9IdnpyfAzgI5vJJJOpaCwRicZL
xUIJAFcJcH3ArgvOvUUccF4qXhCsePZeF5z8Bz8/ZOPZv0Dzx6j8X/UXpdZO
yA==
            "], {{0, 38}, {15, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVlNlTWncUxzPtS9/af6Ev/Rv62se+NCatmkySqcFoxqQxKmpqrYnIvoZF
2WVVUWQVWbQqEkBUXKICsiegsouAbIqa/lA7yUOnfehTz3x/d+498z13ztxz
7udryPPbzZ/duHED+gW43H744ruOjoc9P34FHmpboS2PW5sefd/a2fS4qeNb
yOcg+Q04X4JTvf/wP4yLi/NLXcffGa7j/Pzi7Oz07KxyqWqcn38svDScg2Sl
cnZaqZyeVkrFfLGqQrFYLJfLp6enVyVVFzCcnJRKpUKheJwv5PKFw1QslYwl
k/FkKpXOZECyVC6fgJqTcqlYOM5l0+nDeCIRiSX2o4n3gd2Az+X17Pp8vveh
cDSePMpkj/P5/HH2KJ2MRvaCQb/L7dlyeTad3rf2N6u2Ratl0bpktW9s7nr9
4YNIIplIxKN7ocCuc2tlxWZ8YzYYLTqjzTynntXK1IoJhVKuNcyabavbLrc/
GAj43Dtv7WbTnEajlkzKhVK1QKabnx5XSwViPovLYQnEIwqNzmi22tfX7KtL
i/MGpUzC4w0PsYdp3NFBkdyok6on+HwWlfqaSKbSOHzRpFKtMxj0uimZdITL
ppPJFAKFQWaP0MXKZaN2RiURc4fIBAwGjcaTyHQ2RyASCgTDTAaNRMBjcEQi
lc0UTorkM851i3VeqxjjM8gEFBwG64chkCgsDovDYVAoBByBROPJgxzxmMKg
mbeFvI4du2VOIxeyBnGI/t4X3Z2d0M4uaGd3V/evPX39CDyFIZCodAs267or
GQm9c2+vmP5QjPIoWHgP9HnL40eNjZDG5uanbdBeGJrKFsm1C0vrDqc/nE0n
ouGAY31pRjXOImN+gz5rbLhXX193596DpqdtvyMJHLFsxrSy7XkXiiQLucxh
bN/v3DQZVHw6sa/rWcP9+lu3am7X3YU8aXuFoQgnNW9Wt3zvI/HDbCmfO0pG
g+5t0LeIRX7Z3dpwr+7mzR9qfroDedIOw9FGFXrQQ3AP7MFx4ThzGD/wuzZN
M2oBg9QHzODNNTW3au9CWtr7sVSxTGu2b/vB1qRzuXQithd0bizPTknZVFxv
Z2vjz/framvr7z5oamnrQxCHR+VzZrvDF9oD6wm+hmdn1TynlAioeGRPV3tL
cxOk4SEE8ujJL+29/ehBtlilNy5vutzB/ZDPsbNWHYuYM4RHDfT2vOiEdnS0
tQNBod29fQN4MkM0rjYsrixv7jrWLNY5rXJMwKQSMQj4AGwAAaaGQqHgcNjL
V69ewpBo0iCrOsHp+WXrH1M6+YiIPUgmYLEYDIFEoTPZvGEel8WkkUA5Eg7H
YAn0Ie44f0KnnxRKBQwWlUjC416TqRyeSCpXTU9PTynlo4LhwdckNBIDR5LQ
JA6RMSYXMcRsCoNKotFoHJ5QpppeMFmWwe9hNs1oVCM8LoVEBp0MYIYGCFy5
mDnGo/O5TKFIBJxGs+3tjsvr9bqdO/Yls35KKeLzqVQmlsRGkYb1qjGNQqJW
yrQ6vcm6vOV0vwvvR2OxyH7Y53auLln0Wq1EIuMKJhg86YplzmZZsC1Z1tY3
XG4fMKbSR9lcLnOUjkcOAl73xtqayWTRzy5O6RcDXoff6wr4rziQSGey+SIg
B4BG8TibScbj4VDI4/FtO9ybW7uAMKlk/PAwdfQXYQCpLpFVOSmXC/l85iiT
TKaiscRBNA6wU1XpikOVj7i7AliVTOVi8ZpgnyLxGoqf8vOaelU2Al38A22v
az78q+W/x58A3E8w
            "], {{0, 38}, {15, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzNlVlXWlcUx7Pal761X6Ev/Qx97WNf09VGu6JJbBVjsjRRBNM00SQqgwgy
TwIyIyCXgCCKKIMMGmUIIAgOCDIrUQZxwKQHYxr71oc+dK997rp3n/8+a91z
/ut3vm3putn2xY0bN3q+Ao+b95A/dHffe/LTN+Dj586e+7DO1t9/7IS3wlq7
v2/5EhS/A+NrMOrvH/4v8f4y/4Xo/YeLa/H+Mq4pruLjbO3i4vzsFOTZ2dn5
OcjzWq32qetSUKuBIpg9PT07OT2rlIvlepYqlfLxcfUEVOst57W65vTkpFqp
VEql8lGxdFgs5XOpXDaVzaZzudxBoQCKlXpPtVo9rpRLR4fv9vfz6Ux2L5WJ
JzPb0eBmJBjZWI9GIzux3WQ6s39QODw6PDws7Oezyb341tZmMLzhC4bdgQ3P
G9sbl9XpsDpdjlW3Zz0c2dmNJ1OpVDKxAxYK+FZWls1L9jmL3WB22kxak0Gt
16q00xqD0WhzuDxv/aFwOLQe8LpXbJYFnV6nUGskqmkRZJjXyaenRJNinlAw
IZHJ1FqdyWyxOx0Ou9VknFGrFEKRiD0hYvInmWLIpJNrFAIRj8miUxgMBpcv
nFSqNFqNRgPJwRLccRqdQWZwqFwpQwTZ5zUGtUw6waKTCQT86BiRRGcyOVwO
h8Nm0KlEIhFPpJDoXJZAyVfova5Fm1ELyfhsKhGHQQ0PDQ2jUGgMGoNFo9Ao
FGYEN0alc8XiKT00a4sG3B6neU6rFI7T8ZihgWdP+5AIBBKB7Ov7489nL4Yw
BAqLD37FaFt0epOxSMS/5lgwTIl5ZBzqWR+862FHezus/cGDR3Bk/xCWwhYo
tUaLy+MObu5nwL6HvC6rXiVlErHPkd3321qam5vutPze8ai3H4VnCeR6k33V
vxGJJY8OcpnE9rpneX56iksd7e97DLSNjQ2/Nt1t74K/wBB5MjXQBiKxeDpf
erefS+6G364uzkATdMLAk+62lqZbt35puH0H1gl/iSUJ5Fqz0xPaSuxlC0cF
sPLOunfFpFNxafj+uri5saGh8fbddiDGkPiTrxcca8Hobhy4JruX2Ap7V2wz
kIxFGnne13O/taW5qan57m8dnfCBYfy4UGFYdLiD0c14OhWLRgJup3lWJZ2g
4NHPnyA6H3bAWttgsI6ux4j+V1gqW6ianret+HwhYCy3x2UxAn9wGQQsqr7P
CERvD7y3pxfZ93TgJYpAZglkat38kmXZ53YsWOc0kEwwTiONYtH1EwRnODQ8
PDg4+PLV4CsUFkeisUVipR4yWC0zKp1SJOYwaKQrbwDnsFksJp0GzILDjGAw
+FEiizYu40g0OjlfIWBxGWQqmUil0Tk8gUyuhCBIpZCLJrh0MmUUR8DgKCNE
Dp4uVolYEi6Ny6SyWUy+QDQFXGBatNmA603615CEz6dR6Dg8FY1nose4kGRc
LhyXCHhSqRQ4f8FqX3X7AoHAW6/btWSZ0WokQjGDyRuj8HBk/qxGrn+t0GnV
s3NzNrvL6w9ubsfiicTuznY46F92LM3OGBQKNV88xRFMLdtNLrt52Wlfc7uD
oY1YfC+TywMm7OdzyUQ8Eg6tra5ZrfbZeev0rCUa9kc3gpt1DsTqHCi8K5bK
ACwAO4eFQjadju3shMMRnz/k9q4DwuSy6Xz+M2HqULoEVvX4uFQsFg4K2Wwu
mcok9tIAO/WsVACDgOxv3H3E3GVLtVyuFC8Jdn4NibXPKP2ExtrFJfau2Hgd
tv/g7XXoXlxR97+9GK7HX8drT3I=
            "], {{0, 38}, {15, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzNlFlXWlcUx7Pal761X6Ev/Qx97WNf09XHRhOHJI1KoolKNCvVJkRxQJAZ
LoMyXWbwKjIIYRYBEZEZUVRkEFQUFYQkPZAmTfPQ9rH/te9d9+6z977n7nPO
79s7qJudX9y4caPvK3C7eXvgh97e2+ifvgEvP/f03b/b09H+Y8/jjrsdvd/f
+RI4vwPX1+BqPL/7f+jtJ/rXmDf1esPeAGvo7edqOBvD9XqtXq9WK+/t+rp6
fX1dq9XqHxIbAbUacFar1atKw87PTptWOj8/v7i4uAKuaiOrGVK5vLwsl8ul
s7OT07Pj01IuewAsmz3M5bKFQuHktHReLl9cgrwyqHByXMzn8+lMZi99uHtw
uB3bikeDsWgoHo8ld3YO0oe5o6PicbFYPMrlMvt7qUQiEQxHNoKR9UDE57Z5
XFbXqs3lWvX6fMCfSO6k9vb2UruJeHQr4F9zr1nsToPFoTM7rcZFk25Bq1Fr
NIv6lRWrw+n1bQS2AoHNDa/HZbGYNNplxcKSWKURqbWGJemSUiQX82ARXyyR
qBGQYjRbLRazSa/TqJRyoQjm8GGIL4NEKsOiBJHxRTwWB6JDEJM7z4MlErlS
oVBIYVjA5XLoTBYVmqNxYQZfYdGpllWwmMdiUkmkWQKRSKTQaAwmg8GkU6kU
IvCRaWTGHJMn40oWPTaDWatWwvNsGgk/PYkdHwMax443DTsxhZsh0ugcIV+2
KFsyhXwut21Fq5byWTTC1PiLkefDQ0/RQENDz34beTk+SaBAXJFCtfxab3Xv
xoJBn8sK/pPPJuGwI8/QfY9Q3d1d3aiHjweHRsemSMw5sUq7YnOv+sKZ/eR2
ZNNjNyJSAY0wOTLU3/PgXnt7W8e9+6gn6NFxHJ0LL4AWr29txXYL2YP97ajf
bdeqxBBpemToSde99tbWltb2zu6+wd+xeJZArn3tXA/G46nD4/xhejce8Dr1
C1IWBTc6/OTB3bZbt35pudPR1Tv4YoLAESn11jV/eDu5ny3mDvaT0U1QWS2B
yLiR4f5G5ZaW1rbObhCMJbAFcp151RdKJPYy2f1kMhLwOEyITEifnRoZHmjM
ua2tvfM+CkxjDMeYgxG9xeULBROpVDwY2nDZVjQyIYc8MzH67GnfQ1TXrw+6
ulCP+5+OYibJjHmpWmeye9z+SLPPRt2CjM+mE6axjT6j0YP9A4MD6KHh5y8w
E3jQO6FCvWw22DxrFp1pWdVYQXpzBcH6YV69wmBevcRgXmLGxiamZ8hUiM8T
I1LEaFyUIlK+kMNgUIhEAn52lkgmU2hUKpVMJuLxuKmZqelZPBGiQCImT4mI
uVIeNMekMqhkOp3O5s6BPSmVSMUi0TyHTaNQ8XjSNJ6KI7LxVL5CAMFzjHkW
nctm8QVCuVK9rNMbjcYVnQ5RKoQ8HoPGJBAZ07PQJJGjgjlyIVci5EmlkoXF
JbDvXW5wvHzrHrfd8lqDILAQhlg8En2eQOXpEZkWUWiXFgwGg83h9PkD0Vgi
mUxux2PBTf+qw67T6uQKRACruAKly25yOcxrLsf6+jo4rcndVDqTzeXz2WwG
nNlIOOT1eK1Wp37FqtFZYuFALAJ2SXSnyYF8oXhSAlABzCgVC4VMOg2+Eg5H
/Zsh70YwmwGQSef/IszFJaAS0NXVBWDR6WnhqJDJ5PYPDlN76Sa4zsrlJrsq
lep73DUxBxBWuaoA//nZ+WkJEKx0DZBY/ROJtfonLH3Pxlq9dl0D46AMsI+w
/cjbz7D8gagNqP4zxj+kvftPYX/XH6vyT7Y=
            "], {{0, 38}, {15, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzNldlTWlccxzPtS9/af6Ev/Rv62se+ptM/IJlgomlMjLbGJZJJcSTBFYQL
yHZBlsu+X5BVAUGuAiKCgKJGNjGyKZuYtges3TLTmb71y++euef8vr9z75xz
z4cv7z+92/PJnTt3Bj8Dzd17w988f35v5LsvQOf7/sHeh/24B9/2D+Ee4p5/
ff9TMPgVuD4HV+f+1/+Hfvm7/pm9zX/oxnW7fX19E9cfuvpLaad73RVwXbXb
zWa92WyAaLWarVbr6uqq3S3sGtqgCwZBut5o1hqNaqVYqZQqlXK1Wrm8vKzX
wXCzW9hsNBq12mX14qJcqRRL5ffFcj57kgORy+TzucLZWbFYqlRBHqhaKZfO
z9/nT0/T2exxOnN4ktmPR5LxSCIeTSbjqVTqXTqdy+cLZ4VC4TSXzRwfHyWT
yd3YXigSC+zEgph7y+/GNjwYthEIBiPRaGJ/P3V4mEodJOKxnfC2H8Nc6z67
y2td87kdqNNqsK4YLCsmm93uXl/HtraCoVAoGPD7fWtrTrPFojWaFXqzTG+x
oUqTTqZRIgo5olQqdQbDitVqdzocDtuKGdVqNVK5YhlRwIgKlmqtBrlBJZaL
+ct8Lh/mLQuFiFQqVyoUChmCiAUCAYfHZ8Ei1rKMI1Y7zWoTqBbDMJvBgGgQ
RKMzGMwl5tISkwEG6Awak83gCjkiJV+m31g1O0wajVTIZ9Gp5LnZadJbINCQ
SKSZmdl5MgVisfgSoVwv09vCmMe3ajFp5SLeEnV+hjj5Gj/xchxoYuLVzwTi
9Nwig8OXqFRGO+rwJndD25hndUUvF/KghWnCq5fDPw4OAA0NvRjHT5LmaGwB
okbNTp8bC5+k4vGdgG/NopUJmZRZwsTo4LMnfX29fU/6h0bGCaR5JixRo3bX
RigQSeZOUql4ZMu7alQhLOocYWIEeHt6cD29jweGxyanyexlucEKvNHd5NFp
5ugoGQ1uuMCasKH5jvmHXtyDB7hHfQM/ATOFK1KgjnUsvBc7OMn/MbMaYdPm
CfjuzDhcz6PHHTOJzBHKjTa3PxSL7h+Dd05EAhtrVrAezMVZAn6s8869vX2P
+4eGxyffzi/BEo3J4fZvB6P7+9FQeNOzajEoRDBEnpkEqzE0OPD02cDA4IvR
ick3sxBLIFWjllWfZ3MnjLnBOpvBvDCLujBDJLzGvxwfGxkdGx3H419PvZml
QGy+WKUy2E0O77oDtRnVauky3N3BGbB3RCJxaoo4Bdo3JNLcAoXB5IgEiFaq
sVh1MrAfiIDDYUJ02iKNSgUfCB38aLRFCmVhgbJAhhYhLp0jYQlUOhlfIeIK
eUs8FpPDZsN8vkgsQRBEIhIJeDzwQVGpDDKVRYZgClOklvDkQq5YwBUK+MCk
UmuNJrNlBRwFVKdWSURiDhuG6FwyxFuABDr5skYmVMkkapXSiKJ255rXt4Fh
m36fz+V0oAaDTKqA+RImRwyxxFaj2oJqrWajw273rHsDoe1obC+RSMT3YuFQ
0OvxWCxWjRZF5HohovOvO/1eF+b3BoOB3WgMnNWTdCYL0JBJH6VSseju1uaW
2+2zOdxmqwuc4MTebjKxBzgAbIAC58VSqVwuFYuAB5l0+uDgIBqNb4ejW8FI
LgMgkz7N584AYUolwJdard5RrXZRvSgVS4XCWTabe3eSOTpOA3YB9FxUq112
NZo3uLuhXLPVqNcvLy4rlSp42Hmx3EFi8xaJ7T9ZesPPTlXrCuQbjSaY6vqW
mR/x9pa5v1d14l9I/jHt/9PfxG//mFAV
            "], {{0, 38}, {15, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}], ",", 
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzFlclyGlcYhV3JJrvkFbLJM2SbZbZO5QHiiuOyXEaOhpIca3ZZM0YTCJpB
QDN0Q9OMDY0YGsk0IDFpAoRAsgwITUwaQKDByQXkuCpZZZXDuVT3/c9tbv3V
9+PbR60Pf/viwYMH7V+Br4e/dP3Q1vbLy5++ATc/M9qfPmE8/vVHRsfjJ4/b
vn/0JZj8Doyvwahf//l/62PTd3d1fwS+1+fAJ9XLDd3cXDd8c3sLfNucvLsv
3t02dNNI1K5vrq7KDVeq1atqtVq7BnP1tfXA9XWtVgOTFZCoVC7LlVIxXyoV
SqXi2Vnp/OL8slyuXIFiXZVK+fLy4uz8DJRzheJpvnh4kMoCZzOHh9njk5Nc
Pl8slc7qKhULhdPT08Ojo/TBwX46s5fKJOJbO9tbO/FoIhHf3dv9kEodZLNH
dR0eZNL7++93EolIbHttKxbajIX9dNBPB1Y9gcBqOBzejES2d3YSyWQisbMd
i25srK8GAm7viov2Od6tuF3kstNC2UmHfZFyUW6aXvH7g6FgMBhY8XmXl5cW
7Q4TadOZbbjZ7iR1VgI36TG9FtPrdSaCsNpA3WF32KxWi8FoxHCdEtPJMYMM
M9kJjVmPalVyRCGVy2CFQoGqUDWmBkZRRCZXSGSKBRm6oNSIUT1F6kiDGkdh
mVgo5PMgHheCeBAf4vPBgHh8AU8oFkiVYiUOq00eyuK06AxqhWyBz2PPTLOY
zMmJicmJSSaTyWJNzbI5kEgIo3LMpDLYwr4lD2Ul9ZhSIpyfZU2MvhkaHOgH
Ghx8PTwywZph88VSRKsB+7W7Y+v+kG+ZIo2YXMydZY28Hnj1sqsTqLu7Z2Bo
lDk9L4QRLWF20JQntBffioRXacqqV8n4c6zhwd6ujrbWVkZrW3tXT/8IcwaS
KHHCTtGBlXA0vRff2QqvvHOaNEoBZ2p4sKezrfXZs5ZnjBedf/SNMGcFsMpg
dbn96+FIIrOfSETX/TRFaFHh/DQId/zOaGl52vK8tfNlPSySq022ZU9wc317
t/nkVbfThCNCzvTnJz9/0QwLYZVxcYn2b6xFk+/BntdWQUP0ajmfPTU81Fff
M4PR+qKt+1X/yOQMX6zUEnaXJ7i6FrvvhtWIKSS8OdYo6EZ3V2d7R2dn16ve
wdGJKa4ARnHC4qBd3lDIu0RTZL3P0kafR94MDfT39fT29fYPDb0Zm5hic0US
Ba4x2gib2w2aTWh1Kjksgrjsmam3k5Pj4+OjY2OjY+Pjk8y3M7NsPn9BASN6
REsuGtQmjUIlF0uEEJ83z51vmjvP4bDn2HOznDk2xIEk0AIihHEjJsMRCQKL
YLFQIl6AYfDiKRHwkcthiUQoEHF5Qg53gQ3BHIFSr5LiiFSlkKJKuVqt1un1
hNlCkqTFTBi0WhRBJWIZJIA5EMyG5ASuNOKIQas2GvQg43Qt0R6vz7fi9dBL
FGUxmzUanUyBiaQqvljlJA0Oq8lpI5dclMfrDYbCW5FILBaLRrbWQKto2m53
Gk1WTGtGMcLvXfb73AG/by0cikSjieTufiqVzmRSqQ+7yWQ0EgkGQuBcOl20
zeGORzfjsQg4ynt7u6l0+vDo+BSwI1/I5XLHgBipVDK5G41ur29EwW9mMwAy
6aPD7MnJSb5QAHy5uAQqX15cAtAU8vnj4+PMQfZDKvN+Pw24A9hzDjIXF+Uy
gF619klVgLhy+fz8AiAqXyjmcoWrBtnqSKzVAAkbOL39DE/AxmoN1CsVsLDS
BGazeo/bv7H8ibqg3lh400T1v0n+T543kP2f/iz+ArJbUFQ=
            "], {{0, 38}, {
            15, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> False],
           Selectable->False],
          BaseStyle->"ImageGraphics",
          ImageSize->Automatic,
          ImageSizeRaw->{15, 38},
          PlotRange->{{0, 15}, {0, 38}}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"982ba015-1a48-42c1-a386-7ebe8682264b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              RasterBox[CompressedData["
1:eJztUqtyhTAQzUw/oN9QU8k/8AXMVKOuwPZaLC4SFxcVFYWKwqAwGAwGEYNB
IDCICMpr9wI3VLbmnpnMJJuTze7Z83H7/rq9EUI+p/U+rXk/vvAnUKFDFnhx
biX0BSMb/L7ksHfT9pnbUne7dkI1jia5O3g0R2qTRpDKy7r1dQqvidR7eh1i
BbzEaBF7EBUDUkUA3LDe5xhKvOBlv0Z8iERPzejkDtXxKXnJ4C+P9RaRGgqN
MiUxragHC3eWNCZHLHJdYRCBs+OCXBfoc/rgBtL8yuX+oQxe2Que0GWUnOCx
i0I0jjZUhQQPRJnFMbUEnZ2omRxTocFCfZahwGLplmoQEApEtefmFOblxlik
qQUk8AucYqNQXFbsGzIJOMal2fqdRA/5/GQDoxMcpmrM8GiECIuqRkHfJEhG
0+sNFomWnztdz9dNezmgF/4RP02tQHw=
               "], {{0, 0}, {15, 38}}, {0, 
               255}, ColorFunction -> RGBColor], ImageSize -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFANiPmBGMT+PwrIBv8QgKCCXz++fPjw/u3btx8+fPrx89dfFC3//v759ePr
pw/v37199/7Nx2+vHl87dmjPtq1b9+w/cuvR8y/fgephSv/8+vrh5Z1LR/fu
2rZ55/5tJ29fObKyrSo9LNgvOjlz2prdt569/fH7L8TUn1/f3724b3ZHdmxk
YGBCfsqEzfcu7JhaH+dkrqVpaBZa3L755LXXn78DHfP3z893z27tXN4T6WOl
o2vgGJLdtOzg+2c3962ckORjo66kZOQc2DJ349VHr77/+v3jy9tbZ7Z1l4aa
6alqGTmm18/Yde7er28fH1w6PKsh28lQW1nTKCCzcf3hyy/evX/95Pq2JR2h
7mZqanquQQXzNh5/+OrTv7+/Pr9+dGLTgsJgN11lFSN7//rpq09fuX7h2OaO
ohBzPXV9M8+SjiWnrj/5/OM30CdAK5/eOL20q9zLVF9V3dA7vmzWspULpjUG
uZtraBp7R1Qt33Hu2buvv8HBBPTM13fPz+9cWRvhY6SqrGNsHZWamhTpbmig
beIUWDtl7YW7L77+/IMI0Z/fXt69uH5KfaCDvryMhJySopKSnKKOSWBe6/oj
V159/P4HKbL+/fvz/ePLK4fXNmZ6aiuK8HBz8giL6zj4N8/fdPXx6++//6Im
BaDLPz26dmRWU7KJpgwnJyeXmKJ5SP6CnWeevv/6By3Z/Pv7/dPrq8c2N+cE
6yhJ8nBx8wjKGjonTFix787zDz///EVW+ufXt1cPL2+c0xLkYq4gKysnKycj
JqWiY5tUNWHvudvvv/5AJJi/f759eH5x/6r6lAATHS09U5fIyOgAS2MtZVVr
z7CuJVuvP3nzHZJgwOH87NaZFX3lPjaG6npm/mm1M+fN769IczHWVtMxCcpt
2QALkH9/f39+8/jUloUlIe766mpmrsFt8zacvnDh0Pp5RcGuwDg1tPOvm7T2
wh1QUAPTxqPLR+c15bqa6ACNDS3q2Hry+ss3bx5fP7W0s8TTRE9FycArrGrp
9rNP3n758PzOwdXTMvwcdFTVrL3CepZtv/ns7fdfP7+8e3Zux7KqcC99RWUd
I/eCtoUHLz+6cXJLX0WCrYGWlqFtUvWEPeeBfv8JTM9/fn59cefC6km1vjYG
Soratr45zQv371rUmBDkZKBv7BqUNWPtwXsvP0BSAVD5t48vLx1a15gdbGag
o2ni6ZYxecvMssL0mNik9MbJy09df/zp+y9YdAED//vrJzd2rJiak5boH5wU
GN/16PrJU8cPHz1x6uqdx+8/f/+DnAqAaf37l5dP7p45deLAgaP7Dl78+f3L
1y+fv3z9+v3nrz9/0YsOUMj++vn169fPn798+vQVe8EyUgEA6h1MSg==
                
                "], {{0, 38}, {15, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJztVFlQWlcYdtqXvrXPbVLTh2a6aM2kcbpM046NCyoIIhKJRAUFtaik7nFD
QalLWsy0VuMW17rEuIGJGhFocd+jQtwjyg6KIMtlMT06NnX60jz2od/cc5dz
/vvf//7f+b73iFQ0+TUnJ6ekN8AJTUjzSEwk3A56CzwEJyTFRieQonwTkknR
pMTPia+DyYtgvAnG8f2L/3EWR3/jXwPsNgiCLADgYrPbHWdfOTpyOOw2qxWs
my2Q2WI92FMqZLsSiUQqk+/p9GbI6nAcnUbarRaTfk+jkO7ubEmkm1L1pnhy
VDDQx+ntH+LNLq/KtTozZHMc57RZjAfKnbX5CX7/Y07nI24Xf26K96DxXhEt
KzWLzqxpZ0+JNjQHRqvNZrUYtYqtWWFfXXlhVnZGCqM0t7p3htdew8qMjcBi
cKFUWnHrgHB1R6k3Gg069cbSWEfdT0mUcCwOT0hk0Kp61xcEPQ2slOgbcF9Y
UFgMs7xJMCuSKpUyycrIYGtJTtx1NBwZHJGU/2sdZ1QjXZvm9ZQxUvGBcJg/
mpzCqO9+Mru4ND/J+62ykELAwv1R4bEZZU19I083zQat5Nnco+aKjJjwAB/f
QFxUzp2Kjl52Z1t1/u1YbCAiEBuZVVT9+I+FLfm+3Wo+UO0+FQ5UF2VHYpC+
MASeRM1lMum0ZAIeAw/ARFHzatuHFtel+4cW0E2LUS9bX+I+uJ8XH4nyvubp
7YPGYjAYBMzPF30zhn63YXhCJNPoLTb7ixMS9Vq5aGK4gZUbGQz7wt3tEzfX
S1c+/congJRa0MgWiJ8rDCbIfkIWSA6Z9PLNpaGHVRnfYa9e+dDZ+dyFD1y/
QeGz79YNT4sV+4Zjok73gMMGmbSyjbGB1oIUgsdnH5975+3zFy95Xo8pru2a
FG/vH5rtL2OPHJDZIH8u4nbVZsaFfu3u4nz+3Qvvu32LIjLKWoTza2rA6WkR
x3kNewrxDL/xl/woXMCX7pddP3Jxdbl81TMwPqukY3BsXao2Wqxgw/xV8PJw
Vz0jORrtD/Py9kMikHBPz2seXtgISnFVq3BhVaU7BGUf91ktXRwdrP2RRrqB
9g9Ah0XfysrOSY8nhyD8/BBBsWnMppOG6E2g2L2dlfn+lspsCiEQDg8Oj8lj
3Wvr6GiqYKWRbwJO0SFkOqt+aHx5R3Wgla7P8tnlBekRGCQCFRyXWdjM4c7M
zY9zOZU/ZBLQSJg3ikihVbYMTixvr87yu++XppLxSH84LjL+Tk3byMKzXbl8
e2XhSVsNjUJEesHgqIhkRkUDZ1zQU12aeyssGIXChCblsTq54xsyteHwUKeW
LY9z61h0UgjaxweJIaYnl7Q8rKTTkkhheDz4rfJm9rR4S6s3AaUA9SmeiwXs
5sJMKg4bggih4KgsdkPJz8U0Rj6zrLaNN7G4qzrVIFA1yL6+NNnbVstk0L9P
zadmVixNcoX8wWG+YGpeJJFrDs3QGa7MOo1iTbTwO5/H6eN2c4T7GrlKKVOq
VMAHTBYQ6XhpHEDhwDIMep1KpZRKFTu7SvA5YCOgSPuJw/zDlU4YtttsxyEQ
ZAUTJ8crmdyrWuJ/CX8CkeZNKA==
                "], {{0, 38}, {15, 0}}, {0, 255},
                 ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzdVNtTGlcczrQvfWv/hb7kpc3lJZOb7TROXmyaSSS1uRuQhUUjgiuIaKIS
iRCJhogXlIjBEpya4I2AihElagwSjCSSaJC7BlBMuK5cJOkBM512ptOnTh/6
zTk7u2e//Xb39/vO93UeBUP8bMeOHSVfgAMGxziCIDjmqa/ARU5RST5cRICy
imgEmIAcyPscLO4E80swU+cf///48PFDCv9I2cbHZHLrDySTyb8+lWIk04xE
ekTRcCQcAgiHI5vRGFhJbvNTtK1EPLaJRsDdQDDsD0bW3A6Xw2KxLNvsDvea
LxiOxOKJZFouHkWDfp/nrdNqtSwu215ZV14bp59OjqpHVKOa8dn5BfuqJxBG
Y/F4DDDfeR3LJv2MdkQ90j883qeZnRl7IL/X1tx4k9/ULJUrpucWnB6gHwaa
K7ZXTyeUMomwgc/nNonrJYNTwzJpWx2rHCkuKWHxGrsVj56/trz1et0rVuPs
+P2uZnYVg0pj0Gv47Hb586mHvV0CdjmFCOELihk8oWRI+3RhcdH0YlY9eO8W
p4JcAMNk+pW6tpbf1LZX+sdDPa111RQYj80j0io5IplcPT7+aLi/s5XHRC5D
EEwtYwvu9iq0cxtu22vDZH+XsKaUCl3CQvmUKk5Du1gsartdc5WWT4TgyzR2
w53ekSdziw40COiLM6ODono2AuNzL+QS8sl0ZhmjlEqC8TiIRLvC7ehWzsy/
cXreJ6JowOcxG3VKWUdtGRV3NgeTffJUzqmc0z/nnD0HFdK5gruqCb3Z6X0f
2gRdikaCXqd5VvOwo+FaIe6XrKPfH844mHEk81jO+aIrHPH9If2CxfsuuBlL
gK4mYpsBn3tpfrpPImAWXszKPLBnz669+zOOncFX8IQDGh2QDUaiia0k8MBW
Ihb2r4P/VPWIqhD8j5kHd337ze59GcfPk2oEEvUTo8OzEYnGU6YByvFoYMPz
xjjT92szk4zNyjy0Z9fuvfu+O36GUFUvUmqfWVbXQmgs5Zjtb3Yt67UqceN1
Mv5c1tEfDu0/eOjwkZ8wF5FKnrR/dH7J7vOHgXYiBornWX45q+rp5F4twV88
i8nOzj5x8uTxExjMaQK5tL5NOvrkuXV1PRBJecttX9KNKTpuc2iFMBaLA3VG
ihFqASnvwoVLOJhRzeuSj4CCrK77N9z2RcPUgLT9OhOBITyJjFRzG1qFwqab
nHLKZXwuFi6gc293KsZ0L8wrNpN+UnVfyGMh+UQCsYB5rU7c3TusVivl3S1c
FpUIYXOJxYzaFsmA6rFRr+nv6eCzSikwBJFpFXyRdGRS99JkmtdNDkhFtWUI
IReHIxSXsVsE0iGlrKmZW0EjkwoKqdV1gh6lxrhkfet2u6xLOo2ys/EGvTD/
EpYEUVi0WnGPiHvrOrOcQa+sqbsj658ymFxgp4RCfp/XYjKo+2R8DotKKSGQ
K0lljQpZs6Sd39rSIpHJx6afmR1uP2hADGzqkM/tXDBMDz6QCRoF1zhNlTfE
c9PqqQn1hFarMxjN9tUNfygaBy5IpQAaCnhW7QtGw4RmXPHwUe/ghGfFuuK0
uVwuz9q6PxhOM7fzJ80PhzbW11xO17LFvmR2bKJhNBJGUTQajX0i/imPQA7F
QCigKIigYCgCXpgen+T+NuTSkZMKsX8vYP87/A6AFk3H
                "], {{0, 38}, {
                15, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzdlFlTmlcYxzPtTe/ar9CbfoY21os0i22TTmasmmVsmsSQuEQgvKCgbCou
iCAomigIKCYExA1cYhQRgYDEEaNEJSBLwA2QXWTT9qBJJzOdTu960f8858w5
7/M/533nPc/5fX0XkXv/szNnzkBfgC73TuU5FOoO7tevwCQfDpU8gMPu/QRH
wx7AUN/e/Rw8/Aa0L0HLjP/4v+v4+CgTR6DP6O/pUx1ldJxKJZLJ00im0umj
k1UfbWCWTqVSIBVPZCIaDoSC/kAgEAyFogcH8UTidMmJLxk/jEUiYZD1+QNe
f2j7vdVhe2exmK02m2t7Zz8Yih3Gk2C3RDwWDft9u673dpA2ma0rZvvqknpB
o1DOvpxVqQxLbywOl9cfBK+IRkK+Pbd1Y8WgU08rFPJp1eisXjMzKJf29fG7
ewSCgdFxtcFocbo9Pq9n17258UY7NznwXNjF5bXzRB1P5XPjzyQCNpNGodRT
GB1dYtkL3dKqxbZpNZsMmmnpM24rvammnlrL6GrmSnUzQ0P9j1sbSbhKTBWp
jtXdOzql0BkMeq1SPtjf0dpIqK7CEigUZk97v/zt4pxCLuKwmgiVEAqFIVKa
n/D7B0dHhgafcToZtUQcGoMl1NHZfKl4UuOymozamSFhd3MNHkIgHkGV5Hoq
s72NxaTVkasxaKgCR6a18yRjStXiWmDPbV9fnp8c7mHR8GhkWXFxWTkchYYg
NBIOL4c/wpDqGTyRTKlfWbNtxcIBj9u+apgffdpDI2Efwu4U3rx+/ca1G4U3
bxXB4BUEeqdANq1dMTu3vcFkPBb2e5zmlfnJoW4GBVVyO+/qz5cuXci5/EvB
rXtoEpUrkqkX3zqANRIDZ3oYDe25NsGXizitOERR7pUL2dlZ2edz8n4vxlPZ
4nHl8obd4w/H4klQAfFYxLfjXH2tkvayCaj7wHz27HdZ53Lyb5eS6V3D09q1
Tfd+6AAUwYed3TajTiHqYVUhYblXLn2flZX9w4/5t0qIzZ3SSdXKO6c3EIkl
QGHFIgGv02JSvxzhsBqh0rt5Vy9fPH/hYs6VgkJYJZkmGBjXLa+7dvfDByfW
LYdpUSN7zm+pqy4vLiq8cb0gL78g71rhb0UIDIHZJZxQ6tc2gT2U+XHry+qp
EX4HnYiFysvKyh6WI+AIeGlpyf3ih3CI3Mjsk4yrX5vMjp3MCb5SDPdz6RRi
BYRCV+Bq6pvodAatgUKoQCPLEZhKMp0tGJyY1y5tmBaUM6OgNqgkLAaDwdY0
tnTz+wekUrGQz25uqIYgJAJTTW5h86SSCY1qTCTuaaPV4oEXT65nc4WyqVnt
K51aMTXQy2mpJaIRKCREIDQ+pnOGRvrau1spFCIOTyDR2p5IZFN64yq4R+ur
xvkpmaCTVVNdhXyEQ+Ko2AaOpIfRxWygNdXTmew+8cicfgncrD2PZ8fleLuk
fzEsfsxikEgUDL4ZXdM5JuGKhd3CXoFkcHRWs7Bmce7tByKRaCiwv+W0GhfU
Y8NSLofHaONRWcLXmpda1bRaPW9YNG5YHbtefzR2CCACIBDy+1wO65ulxTml
amxCMSRXuuxmh83icNjd2zs+cK9j8VPWpNMpAINw0L+7vWWz2dc3rKY1ayQU
CIeC4XA4Q5j4CWH+QlY6nUwkYgcH4VDYHwju+4MAJycBXJ+w6yPnMlxKfyBY
IpE8/kT/QM5/Mfz3+hM16k5L
                "], {{0, 38}, {15, 0}}, {0, 255}, 
                ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzVlGlTWmcUxzPtm75rv0Lf9DP0bWeaxEwbzWYnTaitSWhqrGLQxBEBUWSV
BBBkEZFNBYawuOHKImBQVAKurCKLlR0E2dzaS0w6melMZjp91f+c55l7n+d/
zpy5Z+7vyweQW79+cunSpebPgO1Wbes3UGht2+0vgJfqxua6x43gR9caW8CP
wdCvH3wKHH4FrM+BVX7+83+p83Kcn3/MUb4v6+zs9H2Udf5h1jtDWadlnZWK
+WI5CsVisXR8fHJ6epHy1nV6cnJcKpUKhWK+UMjli+lULJmIJYBIJg8zmVy+
cJEC+ABX7iibTqfi8Xg4Fj+IJgI+567H4XI53B6PPxiKxpOZo1wBUD6XOUxG
w/t7e16H07W+47LteOyrBstrnWFBYzAZLVabw+v7IxJLpVOpZOwgtOfcti8v
LWp0erXGMKE1G+eUU6MSmUQklkhUk1PGpdVttzcQCgX9uzubVpN+VqmQCYbF
nGE5RzqhnRArRjgcJqW3l8Li8mRjU4allfXNjQ37qkk/I5cKWUw6idpHYvDJ
vFeGaZlyhMOiEnEYNI5IYnAF8nG1Rq/Tzk8rZUPsPgoeh0MTyMQ+Pl2osppm
ZkfFPCYZj+5AIjuwhBfMgcFhiXhkmM9mUAhYNKqzG0uiM/iyoVGNe2NlWT+t
GOJSCRgkrA3WDu/CYHtekEgkfDcahUAgUGgChSkQq+ZmjNaw3+2wLWsn5TwG
pRvR1vK0CRC0GdrcAoW2tLTCkFgSjScenTWsrm150/FwaNdhXdQqh7gvMcjm
hrqHtTU/1YBqamvBTxqew9EUlkA5vbCy7vIGI/lsOhEOutZXNeMyNhnbCnkM
unu7qqryxp0fasD1bV1EzrBC+9rq9O1HEofASDPJaMC9ZdZOClkv26G/3auu
rKi4UnH9Jgj8OwLfO6ScXrI5AgfxdDZ/XCocpRP7PqfFMDMyQEW0PPnxTuXl
y99e+e4GCNyA6umTjmvWNt370VQmVyxXTsUCnm2zTi1ik9ub6+5VV129eqXi
+5ugRw1IAm1ENWtZdwbDifRRodxzJOTaXNNOvuqn4lub6kB371Rev151s7rm
YT2sizQoVi0s29z+A6D2YTwM9GA161RiHhnf2QKpf/jLz6B790H3ax6B65+3
o3v7ReOzRuuWZ28/Gg64nXaLTq0UsHuxKPiz5qdNEEhTIwTS0AhpaHrWCseR
6EKg70Wrbcd3MUHl8CCNhEMh4HA4sqsbS8ATcN3oDhisDZgKCk9lCqSj83Om
NysLU9OKYR6DTEB3olCd+B4ykzMoEokEA/00ErELgWiHodA4Kn1AKlLMzylE
0kE6rQeL6erEEV6wuEL5mHpufn5mckzCH6AQcB3wjnYErovIJrGkCgGd19dD
JmIIBCKdzZWNqg1mi81ut1rM85MqIYdJxOLgCAysk4wgcGR8Gp9FZtIprP4B
iXxMt2jZcnr8fr/P43yzvDilesVls4hECgpLQ+L71XKBUiqQScWqsQmdaWnD
4QkdRBKJZCxysOdxrJqN6rFRoXCE0T9EZYktprnXBs2iybiyZt1xeUPlb5/N
5fNH2UwiGvZ5XG/WVvV6g3pap5rU+Tzbu27H7q43EAxFYonD7FEBgM1buAAJ
yXhsPxh0uz2bW077hhP45VPJeCqV+pswp+9IdnpyfAzgI5vJJJOpaCwRicZL
xUIJAFcJcH3ArgvOvUUccF4qXhCsePZeF5z8Bz8/ZOPZv0Dzx6j8X/UXpdZO
yA==
                "], {{0, 38}, {15, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzVlNlTWncUxzPtS9/af6Ev/Rv62se+NCatmkySqcFoxqQxKmpqrYnIvoZF
2WVVUWQVWbQqEkBUXKICsiegsouAbIqa/lA7yUOnfehTz3x/d+498z13ztxz
7udryPPbzZ/duHED+gW43H744ruOjoc9P34FHmpboS2PW5sefd/a2fS4qeNb
yOcg+Q04X4JTvf/wP4yLi/NLXcffGa7j/Pzi7Oz07KxyqWqcn38svDScg2Sl
cnZaqZyeVkrFfLGqQrFYLJfLp6enVyVVFzCcnJRKpUKheJwv5PKFw1QslYwl
k/FkKpXOZECyVC6fgJqTcqlYOM5l0+nDeCIRiSX2o4n3gd2Az+X17Pp8vveh
cDSePMpkj/P5/HH2KJ2MRvaCQb/L7dlyeTad3rf2N6u2Ratl0bpktW9s7nr9
4YNIIplIxKN7ocCuc2tlxWZ8YzYYLTqjzTynntXK1IoJhVKuNcyabavbLrc/
GAj43Dtv7WbTnEajlkzKhVK1QKabnx5XSwViPovLYQnEIwqNzmi22tfX7KtL
i/MGpUzC4w0PsYdp3NFBkdyok6on+HwWlfqaSKbSOHzRpFKtMxj0uimZdITL
ppPJFAKFQWaP0MXKZaN2RiURc4fIBAwGjcaTyHQ2RyASCgTDTAaNRMBjcEQi
lc0UTorkM851i3VeqxjjM8gEFBwG64chkCgsDovDYVAoBByBROPJgxzxmMKg
mbeFvI4du2VOIxeyBnGI/t4X3Z2d0M4uaGd3V/evPX39CDyFIZCodAs267or
GQm9c2+vmP5QjPIoWHgP9HnL40eNjZDG5uanbdBeGJrKFsm1C0vrDqc/nE0n
ouGAY31pRjXOImN+gz5rbLhXX193596DpqdtvyMJHLFsxrSy7XkXiiQLucxh
bN/v3DQZVHw6sa/rWcP9+lu3am7X3YU8aXuFoQgnNW9Wt3zvI/HDbCmfO0pG
g+5t0LeIRX7Z3dpwr+7mzR9qfroDedIOw9FGFXrQQ3AP7MFx4ThzGD/wuzZN
M2oBg9QHzODNNTW3au9CWtr7sVSxTGu2b/vB1qRzuXQithd0bizPTknZVFxv
Z2vjz/framvr7z5oamnrQxCHR+VzZrvDF9oD6wm+hmdn1TynlAioeGRPV3tL
cxOk4SEE8ujJL+29/ehBtlilNy5vutzB/ZDPsbNWHYuYM4RHDfT2vOiEdnS0
tQNBod29fQN4MkM0rjYsrixv7jrWLNY5rXJMwKQSMQj4AGwAAaaGQqHgcNjL
V69ewpBo0iCrOsHp+WXrH1M6+YiIPUgmYLEYDIFEoTPZvGEel8WkkUA5Eg7H
YAn0Ie44f0KnnxRKBQwWlUjC416TqRyeSCpXTU9PTynlo4LhwdckNBIDR5LQ
JA6RMSYXMcRsCoNKotFoHJ5QpppeMFmWwe9hNs1oVCM8LoVEBp0MYIYGCFy5
mDnGo/O5TKFIBJxGs+3tjsvr9bqdO/Yls35KKeLzqVQmlsRGkYb1qjGNQqJW
yrQ6vcm6vOV0vwvvR2OxyH7Y53auLln0Wq1EIuMKJhg86YplzmZZsC1Z1tY3
XG4fMKbSR9lcLnOUjkcOAl73xtqayWTRzy5O6RcDXoff6wr4rziQSGey+SIg
B4BG8TibScbj4VDI4/FtO9ybW7uAMKlk/PAwdfQXYQCpLpFVOSmXC/l85iiT
TKaiscRBNA6wU1XpikOVj7i7AliVTOVi8ZpgnyLxGoqf8vOaelU2Al38A22v
az78q+W/x58A3E8w
                "], {{0, 38}, {15, 0}}, {0, 255}, 
                ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzNlVlXWlcUx7Pal761X6Ev/Qx97WNf09VGu6JJbBVjsjRRBNM00SQqgwgy
TwIyIyCXgCCKKIMMGmUIIAgOCDIrUQZxwKQHYxr71oc+dK997rp3n/8+a91z
/ut3vm3putn2xY0bN3q+Ao+b95A/dHffe/LTN+Dj586e+7DO1t9/7IS3wlq7
v2/5EhS/A+NrMOrvH/4v8f4y/4Xo/YeLa/H+Mq4pruLjbO3i4vzsFOTZ2dn5
OcjzWq32qetSUKuBIpg9PT07OT2rlIvlepYqlfLxcfUEVOst57W65vTkpFqp
VEql8lGxdFgs5XOpXDaVzaZzudxBoQCKlXpPtVo9rpRLR4fv9vfz6Ux2L5WJ
JzPb0eBmJBjZWI9GIzux3WQ6s39QODw6PDws7Oezyb341tZmMLzhC4bdgQ3P
G9sbl9XpsDpdjlW3Zz0c2dmNJ1OpVDKxAxYK+FZWls1L9jmL3WB22kxak0Gt
16q00xqD0WhzuDxv/aFwOLQe8LpXbJYFnV6nUGskqmkRZJjXyaenRJNinlAw
IZHJ1FqdyWyxOx0Ou9VknFGrFEKRiD0hYvInmWLIpJNrFAIRj8miUxgMBpcv
nFSqNFqNRgPJwRLccRqdQWZwqFwpQwTZ5zUGtUw6waKTCQT86BiRRGcyOVwO
h8Nm0KlEIhFPpJDoXJZAyVfova5Fm1ELyfhsKhGHQQ0PDQ2jUGgMGoNFo9Ao
FGYEN0alc8XiKT00a4sG3B6neU6rFI7T8ZihgWdP+5AIBBKB7Ov7489nL4Yw
BAqLD37FaFt0epOxSMS/5lgwTIl5ZBzqWR+862FHezus/cGDR3Bk/xCWwhYo
tUaLy+MObu5nwL6HvC6rXiVlErHPkd3321qam5vutPze8ai3H4VnCeR6k33V
vxGJJY8OcpnE9rpneX56iksd7e97DLSNjQ2/Nt1t74K/wBB5MjXQBiKxeDpf
erefS+6G364uzkATdMLAk+62lqZbt35puH0H1gl/iSUJ5Fqz0xPaSuxlC0cF
sPLOunfFpFNxafj+uri5saGh8fbddiDGkPiTrxcca8Hobhy4JruX2Ap7V2wz
kIxFGnne13O/taW5qan57m8dnfCBYfy4UGFYdLiD0c14OhWLRgJup3lWJZ2g
4NHPnyA6H3bAWttgsI6ux4j+V1gqW6ianret+HwhYCy3x2UxAn9wGQQsqr7P
CERvD7y3pxfZ93TgJYpAZglkat38kmXZ53YsWOc0kEwwTiONYtH1EwRnODQ8
PDg4+PLV4CsUFkeisUVipR4yWC0zKp1SJOYwaKQrbwDnsFksJp0GzILDjGAw
+FEiizYu40g0OjlfIWBxGWQqmUil0Tk8gUyuhCBIpZCLJrh0MmUUR8DgKCNE
Dp4uVolYEi6Ny6SyWUy+QDQFXGBatNmA603615CEz6dR6Dg8FY1nose4kGRc
LhyXCHhSqRQ4f8FqX3X7AoHAW6/btWSZ0WokQjGDyRuj8HBk/qxGrn+t0GnV
s3NzNrvL6w9ubsfiicTuznY46F92LM3OGBQKNV88xRFMLdtNLrt52Wlfc7uD
oY1YfC+TywMm7OdzyUQ8Eg6tra5ZrfbZeev0rCUa9kc3gpt1DsTqHCi8K5bK
ACwAO4eFQjadju3shMMRnz/k9q4DwuSy6Xz+M2HqULoEVvX4uFQsFg4K2Wwu
mcok9tIAO/WsVACDgOxv3H3E3GVLtVyuFC8Jdn4NibXPKP2ExtrFJfau2Hgd
tv/g7XXoXlxR97+9GK7HX8drT3I=
                "], {{0, 38}, {15, 0}}, {0, 255},
                 ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzNlFlXWlcUx7Pal761X6Ev/Qx97WNf09XHRhOHJI1KoolKNCvVJkRxQJAZ
LoMyXWbwKjIIYRYBEZEZUVRkEFQUFYQkPZAmTfPQ9rH/te9d9+6z977n7nPO
79s7qJudX9y4caPvK3C7eXvgh97e2+ifvgEvP/f03b/b09H+Y8/jjrsdvd/f
+RI4vwPX1+BqPL/7f+jtJ/rXmDf1esPeAGvo7edqOBvD9XqtXq9WK+/t+rp6
fX1dq9XqHxIbAbUacFar1atKw87PTptWOj8/v7i4uAKuaiOrGVK5vLwsl8ul
s7OT07Pj01IuewAsmz3M5bKFQuHktHReLl9cgrwyqHByXMzn8+lMZi99uHtw
uB3bikeDsWgoHo8ld3YO0oe5o6PicbFYPMrlMvt7qUQiEQxHNoKR9UDE57Z5
XFbXqs3lWvX6fMCfSO6k9vb2UruJeHQr4F9zr1nsToPFoTM7rcZFk25Bq1Fr
NIv6lRWrw+n1bQS2AoHNDa/HZbGYNNplxcKSWKURqbWGJemSUiQX82ARXyyR
qBGQYjRbLRazSa/TqJRyoQjm8GGIL4NEKsOiBJHxRTwWB6JDEJM7z4MlErlS
oVBIYVjA5XLoTBYVmqNxYQZfYdGpllWwmMdiUkmkWQKRSKTQaAwmg8GkU6kU
IvCRaWTGHJMn40oWPTaDWatWwvNsGgk/PYkdHwMax443DTsxhZsh0ugcIV+2
KFsyhXwut21Fq5byWTTC1PiLkefDQ0/RQENDz34beTk+SaBAXJFCtfxab3Xv
xoJBn8sK/pPPJuGwI8/QfY9Q3d1d3aiHjweHRsemSMw5sUq7YnOv+sKZ/eR2
ZNNjNyJSAY0wOTLU3/PgXnt7W8e9+6gn6NFxHJ0LL4AWr29txXYL2YP97ajf
bdeqxBBpemToSde99tbWltb2zu6+wd+xeJZArn3tXA/G46nD4/xhejce8Dr1
C1IWBTc6/OTB3bZbt35pudPR1Tv4YoLAESn11jV/eDu5ny3mDvaT0U1QWS2B
yLiR4f5G5ZaW1rbObhCMJbAFcp151RdKJPYy2f1kMhLwOEyITEifnRoZHmjM
ua2tvfM+CkxjDMeYgxG9xeULBROpVDwY2nDZVjQyIYc8MzH67GnfQ1TXrw+6
ulCP+5+OYibJjHmpWmeye9z+SLPPRt2CjM+mE6axjT6j0YP9A4MD6KHh5y8w
E3jQO6FCvWw22DxrFp1pWdVYQXpzBcH6YV69wmBevcRgXmLGxiamZ8hUiM8T
I1LEaFyUIlK+kMNgUIhEAn52lkgmU2hUKpVMJuLxuKmZqelZPBGiQCImT4mI
uVIeNMekMqhkOp3O5s6BPSmVSMUi0TyHTaNQ8XjSNJ6KI7LxVL5CAMFzjHkW
nctm8QVCuVK9rNMbjcYVnQ5RKoQ8HoPGJBAZ07PQJJGjgjlyIVci5EmlkoXF
JbDvXW5wvHzrHrfd8lqDILAQhlg8En2eQOXpEZkWUWiXFgwGg83h9PkD0Vgi
mUxux2PBTf+qw67T6uQKRACruAKly25yOcxrLsf6+jo4rcndVDqTzeXz2WwG
nNlIOOT1eK1Wp37FqtFZYuFALAJ2SXSnyYF8oXhSAlABzCgVC4VMOg2+Eg5H
/Zsh70YwmwGQSef/IszFJaAS0NXVBWDR6WnhqJDJ5PYPDlN76Sa4zsrlJrsq
lep73DUxBxBWuaoA//nZ+WkJEKx0DZBY/ROJtfonLH3Pxlq9dl0D46AMsI+w
/cjbz7D8gagNqP4zxj+kvftPYX/XH6vyT7Y=
                "], {{0, 38}, {15, 0}}, {
                0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzNldlTWlccxzPtS9/af6Ev/Rv62se+ptM/IJlgomlMjLbGJZJJcSTBFYQL
yHZBlsu+X5BVAUGuAiKCgKJGNjGyKZuYtges3TLTmb71y++euef8vr9z75xz
z4cv7z+92/PJnTt3Bj8Dzd17w988f35v5LsvQOf7/sHeh/24B9/2D+Ee4p5/
ff9TMPgVuD4HV+f+1/+Hfvm7/pm9zX/oxnW7fX19E9cfuvpLaad73RVwXbXb
zWa92WyAaLWarVbr6uqq3S3sGtqgCwZBut5o1hqNaqVYqZQqlXK1Wrm8vKzX
wXCzW9hsNBq12mX14qJcqRRL5ffFcj57kgORy+TzucLZWbFYqlRBHqhaKZfO
z9/nT0/T2exxOnN4ktmPR5LxSCIeTSbjqVTqXTqdy+cLZ4VC4TSXzRwfHyWT
yd3YXigSC+zEgph7y+/GNjwYthEIBiPRaGJ/P3V4mEodJOKxnfC2H8Nc6z67
y2td87kdqNNqsK4YLCsmm93uXl/HtraCoVAoGPD7fWtrTrPFojWaFXqzTG+x
oUqTTqZRIgo5olQqdQbDitVqdzocDtuKGdVqNVK5YhlRwIgKlmqtBrlBJZaL
+ct8Lh/mLQuFiFQqVyoUChmCiAUCAYfHZ8Ei1rKMI1Y7zWoTqBbDMJvBgGgQ
RKMzGMwl5tISkwEG6Awak83gCjkiJV+m31g1O0wajVTIZ9Gp5LnZadJbINCQ
SKSZmdl5MgVisfgSoVwv09vCmMe3ajFp5SLeEnV+hjj5Gj/xchxoYuLVzwTi
9Nwig8OXqFRGO+rwJndD25hndUUvF/KghWnCq5fDPw4OAA0NvRjHT5LmaGwB
okbNTp8bC5+k4vGdgG/NopUJmZRZwsTo4LMnfX29fU/6h0bGCaR5JixRo3bX
RigQSeZOUql4ZMu7alQhLOocYWIEeHt6cD29jweGxyanyexlucEKvNHd5NFp
5ugoGQ1uuMCasKH5jvmHXtyDB7hHfQM/ATOFK1KgjnUsvBc7OMn/MbMaYdPm
CfjuzDhcz6PHHTOJzBHKjTa3PxSL7h+Dd05EAhtrVrAezMVZAn6s8869vX2P
+4eGxyffzi/BEo3J4fZvB6P7+9FQeNOzajEoRDBEnpkEqzE0OPD02cDA4IvR
ick3sxBLIFWjllWfZ3MnjLnBOpvBvDCLujBDJLzGvxwfGxkdGx3H419PvZml
QGy+WKUy2E0O77oDtRnVauky3N3BGbB3RCJxaoo4Bdo3JNLcAoXB5IgEiFaq
sVh1MrAfiIDDYUJ02iKNSgUfCB38aLRFCmVhgbJAhhYhLp0jYQlUOhlfIeIK
eUs8FpPDZsN8vkgsQRBEIhIJeDzwQVGpDDKVRYZgClOklvDkQq5YwBUK+MCk
UmuNJrNlBRwFVKdWSURiDhuG6FwyxFuABDr5skYmVMkkapXSiKJ255rXt4Fh
m36fz+V0oAaDTKqA+RImRwyxxFaj2oJqrWajw273rHsDoe1obC+RSMT3YuFQ
0OvxWCxWjRZF5HohovOvO/1eF+b3BoOB3WgMnNWTdCYL0JBJH6VSseju1uaW
2+2zOdxmqwuc4MTebjKxBzgAbIAC58VSqVwuFYuAB5l0+uDgIBqNb4ejW8FI
LgMgkz7N584AYUolwJdard5RrXZRvSgVS4XCWTabe3eSOTpOA3YB9FxUq112
NZo3uLuhXLPVqNcvLy4rlSp42Hmx3EFi8xaJ7T9ZesPPTlXrCuQbjSaY6vqW
mR/x9pa5v1d14l9I/jHt/9PfxG//mFAV
                "], {{0, 38}, {15, 0}}, {0, 
                255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}], ",", 
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFlclyGlcYhV3JJrvkFbLJM2SbZbZO5QHiiuOyXEaOhpIca3ZZM0YTCJpB
QDN0Q9OMDY0YGsk0IDFpAoRAsgwITUwaQKDByQXkuCpZZZXDuVT3/c9tbv3V
9+PbR60Pf/viwYMH7V+Br4e/dP3Q1vbLy5++ATc/M9qfPmE8/vVHRsfjJ4/b
vn/0JZj8Doyvwahf//l/62PTd3d1fwS+1+fAJ9XLDd3cXDd8c3sLfNucvLsv
3t02dNNI1K5vrq7KDVeq1atqtVq7BnP1tfXA9XWtVgOTFZCoVC7LlVIxXyoV
SqXi2Vnp/OL8slyuXIFiXZVK+fLy4uz8DJRzheJpvnh4kMoCZzOHh9njk5Nc
Pl8slc7qKhULhdPT08Ojo/TBwX46s5fKJOJbO9tbO/FoIhHf3dv9kEodZLNH
dR0eZNL7++93EolIbHttKxbajIX9dNBPB1Y9gcBqOBzejES2d3YSyWQisbMd
i25srK8GAm7viov2Od6tuF3kstNC2UmHfZFyUW6aXvH7g6FgMBhY8XmXl5cW
7Q4TadOZbbjZ7iR1VgI36TG9FtPrdSaCsNpA3WF32KxWi8FoxHCdEtPJMYMM
M9kJjVmPalVyRCGVy2CFQoGqUDWmBkZRRCZXSGSKBRm6oNSIUT1F6kiDGkdh
mVgo5PMgHheCeBAf4vPBgHh8AU8oFkiVYiUOq00eyuK06AxqhWyBz2PPTLOY
zMmJicmJSSaTyWJNzbI5kEgIo3LMpDLYwr4lD2Ul9ZhSIpyfZU2MvhkaHOgH
Ghx8PTwywZph88VSRKsB+7W7Y+v+kG+ZIo2YXMydZY28Hnj1sqsTqLu7Z2Bo
lDk9L4QRLWF20JQntBffioRXacqqV8n4c6zhwd6ujrbWVkZrW3tXT/8IcwaS
KHHCTtGBlXA0vRff2QqvvHOaNEoBZ2p4sKezrfXZs5ZnjBedf/SNMGcFsMpg
dbn96+FIIrOfSETX/TRFaFHh/DQId/zOaGl52vK8tfNlPSySq022ZU9wc317
t/nkVbfThCNCzvTnJz9/0QwLYZVxcYn2b6xFk+/BntdWQUP0ajmfPTU81Fff
M4PR+qKt+1X/yOQMX6zUEnaXJ7i6FrvvhtWIKSS8OdYo6EZ3V2d7R2dn16ve
wdGJKa4ARnHC4qBd3lDIu0RTZL3P0kafR94MDfT39fT29fYPDb0Zm5hic0US
Ba4x2gib2w2aTWh1Kjksgrjsmam3k5Pj4+OjY2OjY+Pjk8y3M7NsPn9BASN6
REsuGtQmjUIlF0uEEJ83z51vmjvP4bDn2HOznDk2xIEk0AIihHEjJsMRCQKL
YLFQIl6AYfDiKRHwkcthiUQoEHF5Qg53gQ3BHIFSr5LiiFSlkKJKuVqt1un1
hNlCkqTFTBi0WhRBJWIZJIA5EMyG5ASuNOKIQas2GvQg43Qt0R6vz7fi9dBL
FGUxmzUanUyBiaQqvljlJA0Oq8lpI5dclMfrDYbCW5FILBaLRrbWQKto2m53
Gk1WTGtGMcLvXfb73AG/by0cikSjieTufiqVzmRSqQ+7yWQ0EgkGQuBcOl20
zeGORzfjsQg4ynt7u6l0+vDo+BSwI1/I5XLHgBipVDK5G41ur29EwW9mMwAy
6aPD7MnJSb5QAHy5uAQqX15cAtAU8vnj4+PMQfZDKvN+Pw24A9hzDjIXF+Uy
gF619klVgLhy+fz8AiAqXyjmcoWrBtnqSKzVAAkbOL39DE/AxmoN1CsVsLDS
BGazeo/bv7H8ibqg3lh400T1v0n+T543kP2f/iz+ArJbUFQ=
                "], {{0, 
                38}, {15, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> False], 
               Selectable -> False], BaseStyle -> "ImageGraphics", ImageSize -> 
              Automatic, ImageSizeRaw -> {15, 38}, 
              PlotRange -> {{0, 15}, {0, 38}}]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"43e6fb7e-23cc-459a-8f72-96a00cd292a7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Start with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"bde9a9f8-ce2f-4afd-b30e-c78196d60ce4"],
 ", then make a list by nestedly applying ",
 Cell[BoxData[
  ButtonBox["Framed",
   BaseStyle->"CodeLink"]], "InlineCode",ExpressionUUID->
  "171ff9ad-2bc4-4700-998d-175dfd13b161"],
 " up to 10 times, using a random background color each time.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"69f8b5cc-0edb-4654-89f2-94737189101f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         FrameBox["x",
          
          Background->RGBColor[
           0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox["x",
           
           Background->RGBColor[
            0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
           StripOnInput->False],
          
          Background->RGBColor[
           0.30777950878101556`, 0.45333645036477366`, 0.8410268692691583],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox["x",
            
            Background->RGBColor[
             0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
            StripOnInput->False],
           
           Background->RGBColor[
            0.30777950878101556`, 0.45333645036477366`, 0.8410268692691583],
           StripOnInput->False],
          
          Background->RGBColor[
           0.283327200871232, 0.7727130391144685, 0.871317277832282],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox[
            FrameBox["x",
             
             Background->RGBColor[
              0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
             StripOnInput->False],
            
            Background->RGBColor[
             0.30777950878101556`, 0.45333645036477366`, 0.8410268692691583],
            StripOnInput->False],
           
           Background->RGBColor[
            0.283327200871232, 0.7727130391144685, 0.871317277832282],
           StripOnInput->False],
          
          Background->RGBColor[
           0.249095181085351, 0.9832540433780819, 0.3018929559996313],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox[
            FrameBox[
             FrameBox["x",
              
              Background->RGBColor[
               0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
              StripOnInput->False],
             
             Background->RGBColor[
              0.30777950878101556`, 0.45333645036477366`, 0.8410268692691583],
             
             StripOnInput->False],
            
            Background->RGBColor[
             0.283327200871232, 0.7727130391144685, 0.871317277832282],
            StripOnInput->False],
           
           Background->RGBColor[
            0.249095181085351, 0.9832540433780819, 0.3018929559996313],
           StripOnInput->False],
          
          Background->RGBColor[
           0.7049588884757114, 0.9989552996626898, 0.9421255349834372],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox[
            FrameBox[
             FrameBox[
              FrameBox["x",
               
               Background->RGBColor[
                0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
               StripOnInput->False],
              
              Background->RGBColor[
               0.30777950878101556`, 0.45333645036477366`, 0.8410268692691583],
              StripOnInput->False],
             
             Background->RGBColor[
              0.283327200871232, 0.7727130391144685, 0.871317277832282],
             StripOnInput->False],
            
            Background->RGBColor[
             0.249095181085351, 0.9832540433780819, 0.3018929559996313],
            StripOnInput->False],
           
           Background->RGBColor[
            0.7049588884757114, 0.9989552996626898, 0.9421255349834372],
           StripOnInput->False],
          
          Background->RGBColor[
           0.5824210548155662, 0.006888707273777328, 0.2918542020799533],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox[
            FrameBox[
             FrameBox[
              FrameBox[
               FrameBox["x",
                
                Background->RGBColor[
                 0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
                StripOnInput->False],
               
               Background->RGBColor[
                0.30777950878101556`, 0.45333645036477366`, 
                 0.8410268692691583],
               StripOnInput->False],
              
              Background->RGBColor[
               0.283327200871232, 0.7727130391144685, 0.871317277832282],
              StripOnInput->False],
             
             Background->RGBColor[
              0.249095181085351, 0.9832540433780819, 0.3018929559996313],
             StripOnInput->False],
            
            Background->RGBColor[
             0.7049588884757114, 0.9989552996626898, 0.9421255349834372],
            StripOnInput->False],
           
           Background->RGBColor[
            0.5824210548155662, 0.006888707273777328, 0.2918542020799533],
           StripOnInput->False],
          
          Background->RGBColor[
           0.7567625326931173, 0.9615294736776787, 0.24427061265602146`],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox[
            FrameBox[
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox["x",
                 
                 Background->RGBColor[
                  0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
                 
                 StripOnInput->False],
                
                Background->RGBColor[
                 0.30777950878101556`, 0.45333645036477366`, 
                  0.8410268692691583],
                StripOnInput->False],
               
               Background->RGBColor[
                0.283327200871232, 0.7727130391144685, 0.871317277832282],
               StripOnInput->False],
              
              Background->RGBColor[
               0.249095181085351, 0.9832540433780819, 0.3018929559996313],
              StripOnInput->False],
             
             Background->RGBColor[
              0.7049588884757114, 0.9989552996626898, 0.9421255349834372],
             StripOnInput->False],
            
            Background->RGBColor[
             0.5824210548155662, 0.006888707273777328, 0.2918542020799533],
            StripOnInput->False],
           
           Background->RGBColor[
            0.7567625326931173, 0.9615294736776787, 0.24427061265602146`],
           StripOnInput->False],
          
          Background->RGBColor[
           0.4052419887727088, 0.2881879138478771, 0.9673782576615628],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox[
            FrameBox[
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox["x",
                  
                  Background->RGBColor[
                   0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
                  StripOnInput->False],
                 
                 Background->RGBColor[
                  0.30777950878101556`, 0.45333645036477366`, 
                   0.8410268692691583],
                 StripOnInput->False],
                
                Background->RGBColor[
                 0.283327200871232, 0.7727130391144685, 0.871317277832282],
                StripOnInput->False],
               
               Background->RGBColor[
                0.249095181085351, 0.9832540433780819, 0.3018929559996313],
               StripOnInput->False],
              
              Background->RGBColor[
               0.7049588884757114, 0.9989552996626898, 0.9421255349834372],
              StripOnInput->False],
             
             Background->RGBColor[
              0.5824210548155662, 0.006888707273777328, 0.2918542020799533],
             StripOnInput->False],
            
            Background->RGBColor[
             0.7567625326931173, 0.9615294736776787, 0.24427061265602146`],
            StripOnInput->False],
           
           Background->RGBColor[
            0.4052419887727088, 0.2881879138478771, 0.9673782576615628],
           StripOnInput->False],
          
          Background->RGBColor[
           0.3799828067454871, 0.9530040198865488, 0.6751660505768033],
          StripOnInput->False], ",", 
         FrameBox[
          FrameBox[
           FrameBox[
            FrameBox[
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox[
                  FrameBox["x",
                   
                   Background->RGBColor[
                    0.4469563533227279, 0.6456320034857528, 
                    0.7688246612562426],
                   StripOnInput->False],
                  
                  Background->RGBColor[
                   0.30777950878101556`, 0.45333645036477366`, 
                    0.8410268692691583],
                  StripOnInput->False],
                 
                 Background->RGBColor[
                  0.283327200871232, 0.7727130391144685, 0.871317277832282],
                 StripOnInput->False],
                
                Background->RGBColor[
                 0.249095181085351, 0.9832540433780819, 0.3018929559996313],
                StripOnInput->False],
               
               Background->RGBColor[
                0.7049588884757114, 0.9989552996626898, 0.9421255349834372],
               StripOnInput->False],
              
              Background->RGBColor[
               0.5824210548155662, 0.006888707273777328, 0.2918542020799533],
              StripOnInput->False],
             
             Background->RGBColor[
              0.7567625326931173, 0.9615294736776787, 0.24427061265602146`],
             StripOnInput->False],
            
            Background->RGBColor[
             0.4052419887727088, 0.2881879138478771, 0.9673782576615628],
            StripOnInput->False],
           
           Background->RGBColor[
            0.3799828067454871, 0.9530040198865488, 0.6751660505768033],
           StripOnInput->False],
          
          Background->RGBColor[
           0.6580825836001154, 0.8179932685037092, 0.04012523598263873],
          StripOnInput->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "8d99ddb1-e787-452f-af8a-c46a16e123af"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             FrameBox[
             "x", Background -> 
              RGBColor[
               0.4469563533227279, 0.6456320034857528, 0.7688246612562426], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
              "x", Background -> 
               RGBColor[
                0.4469563533227279, 0.6456320034857528, 0.7688246612562426], 
               StripOnInput -> False], Background -> 
              RGBColor[
               0.30777950878101556`, 0.45333645036477366`, 
                0.8410268692691583], StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
               "x", Background -> 
                RGBColor[
                 0.4469563533227279, 0.6456320034857528, 0.7688246612562426], 
                StripOnInput -> False], Background -> 
               RGBColor[
                0.30777950878101556`, 0.45333645036477366`, 
                 0.8410268692691583], StripOnInput -> False], Background -> 
              RGBColor[
               0.283327200871232, 0.7727130391144685, 0.871317277832282], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                "x", Background -> 
                 RGBColor[
                  0.4469563533227279, 0.6456320034857528, 0.7688246612562426],
                  StripOnInput -> False], Background -> 
                RGBColor[
                 0.30777950878101556`, 0.45333645036477366`, 
                  0.8410268692691583], StripOnInput -> False], Background -> 
               RGBColor[
                0.283327200871232, 0.7727130391144685, 0.871317277832282], 
               StripOnInput -> False], Background -> 
              RGBColor[
               0.249095181085351, 0.9832540433780819, 0.3018929559996313], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox[
                 "x", Background -> 
                  RGBColor[
                   0.4469563533227279, 0.6456320034857528, 
                    0.7688246612562426], StripOnInput -> False], Background -> 
                 RGBColor[
                  0.30777950878101556`, 0.45333645036477366`, 
                   0.8410268692691583], StripOnInput -> False], Background -> 
                RGBColor[
                 0.283327200871232, 0.7727130391144685, 0.871317277832282], 
                StripOnInput -> False], Background -> 
               RGBColor[
                0.249095181085351, 0.9832540433780819, 0.3018929559996313], 
               StripOnInput -> False], Background -> 
              RGBColor[
               0.7049588884757114, 0.9989552996626898, 0.9421255349834372], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox[
                  FrameBox[
                  "x", Background -> 
                   RGBColor[
                    0.4469563533227279, 0.6456320034857528, 
                    0.7688246612562426], StripOnInput -> False], Background -> 
                  RGBColor[
                   0.30777950878101556`, 0.45333645036477366`, 
                    0.8410268692691583], StripOnInput -> False], Background -> 
                 RGBColor[
                  0.283327200871232, 0.7727130391144685, 0.871317277832282], 
                 StripOnInput -> False], Background -> 
                RGBColor[
                 0.249095181085351, 0.9832540433780819, 0.3018929559996313], 
                StripOnInput -> False], Background -> 
               RGBColor[
                0.7049588884757114, 0.9989552996626898, 0.9421255349834372], 
               StripOnInput -> False], Background -> 
              RGBColor[
               0.5824210548155662, 0.006888707273777328, 0.2918542020799533], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox[
                  FrameBox[
                   FrameBox[
                   "x", Background -> 
                    RGBColor[
                    0.4469563533227279, 0.6456320034857528, 
                    0.7688246612562426], StripOnInput -> False], Background -> 
                   RGBColor[
                    0.30777950878101556`, 0.45333645036477366`, 
                    0.8410268692691583], StripOnInput -> False], Background -> 
                  RGBColor[
                   0.283327200871232, 0.7727130391144685, 0.871317277832282], 
                  StripOnInput -> False], Background -> 
                 RGBColor[
                  0.249095181085351, 0.9832540433780819, 0.3018929559996313], 
                 StripOnInput -> False], Background -> 
                RGBColor[
                 0.7049588884757114, 0.9989552996626898, 0.9421255349834372], 
                StripOnInput -> False], Background -> 
               RGBColor[
                0.5824210548155662, 0.006888707273777328, 0.2918542020799533],
                StripOnInput -> False], Background -> 
              RGBColor[
               0.7567625326931173, 0.9615294736776787, 0.24427061265602146`], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox[
                  FrameBox[
                   FrameBox[
                    FrameBox[
                    "x", Background -> 
                    RGBColor[
                    0.4469563533227279, 0.6456320034857528, 
                    0.7688246612562426], StripOnInput -> False], Background -> 
                    RGBColor[
                    0.30777950878101556`, 0.45333645036477366`, 
                    0.8410268692691583], StripOnInput -> False], Background -> 
                   RGBColor[
                    0.283327200871232, 0.7727130391144685, 0.871317277832282],
                    StripOnInput -> False], Background -> 
                  RGBColor[
                   0.249095181085351, 0.9832540433780819, 0.3018929559996313],
                   StripOnInput -> False], Background -> 
                 RGBColor[
                  0.7049588884757114, 0.9989552996626898, 0.9421255349834372],
                  StripOnInput -> False], Background -> 
                RGBColor[
                 0.5824210548155662, 0.006888707273777328, 
                  0.2918542020799533], StripOnInput -> False], Background -> 
               RGBColor[
                0.7567625326931173, 0.9615294736776787, 0.24427061265602146`],
                StripOnInput -> False], Background -> 
              RGBColor[
               0.4052419887727088, 0.2881879138478771, 0.9673782576615628], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox[
                  FrameBox[
                   FrameBox[
                    FrameBox[
                    FrameBox[
                    "x", Background -> 
                    RGBColor[
                    0.4469563533227279, 0.6456320034857528, 
                    0.7688246612562426], StripOnInput -> False], Background -> 
                    RGBColor[
                    0.30777950878101556`, 0.45333645036477366`, 
                    0.8410268692691583], StripOnInput -> False], Background -> 
                    RGBColor[
                    0.283327200871232, 0.7727130391144685, 0.871317277832282],
                     StripOnInput -> False], Background -> 
                   RGBColor[
                    0.249095181085351, 0.9832540433780819, 
                    0.3018929559996313], StripOnInput -> False], Background -> 
                  RGBColor[
                   0.7049588884757114, 0.9989552996626898, 
                    0.9421255349834372], StripOnInput -> False], Background -> 
                 RGBColor[
                  0.5824210548155662, 0.006888707273777328, 
                   0.2918542020799533], StripOnInput -> False], Background -> 
                RGBColor[
                 0.7567625326931173, 0.9615294736776787, 
                  0.24427061265602146`], StripOnInput -> False], Background -> 
               RGBColor[
                0.4052419887727088, 0.2881879138478771, 0.9673782576615628], 
               StripOnInput -> False], Background -> 
              RGBColor[
               0.3799828067454871, 0.9530040198865488, 0.6751660505768033], 
              StripOnInput -> False], ",", 
             FrameBox[
              FrameBox[
               FrameBox[
                FrameBox[
                 FrameBox[
                  FrameBox[
                   FrameBox[
                    FrameBox[
                    FrameBox[
                    FrameBox[
                    "x", Background -> 
                    RGBColor[
                    0.4469563533227279, 0.6456320034857528, 
                    0.7688246612562426], StripOnInput -> False], Background -> 
                    RGBColor[
                    0.30777950878101556`, 0.45333645036477366`, 
                    0.8410268692691583], StripOnInput -> False], Background -> 
                    RGBColor[
                    0.283327200871232, 0.7727130391144685, 0.871317277832282],
                     StripOnInput -> False], Background -> 
                    RGBColor[
                    0.249095181085351, 0.9832540433780819, 
                    0.3018929559996313], StripOnInput -> False], Background -> 
                   RGBColor[
                    0.7049588884757114, 0.9989552996626898, 
                    0.9421255349834372], StripOnInput -> False], Background -> 
                  RGBColor[
                   0.5824210548155662, 0.006888707273777328, 
                    0.2918542020799533], StripOnInput -> False], Background -> 
                 RGBColor[
                  0.7567625326931173, 0.9615294736776787, 
                   0.24427061265602146`], StripOnInput -> False], Background -> 
                RGBColor[
                 0.4052419887727088, 0.2881879138478771, 0.9673782576615628], 
                StripOnInput -> False], Background -> 
               RGBColor[
                0.3799828067454871, 0.9530040198865488, 0.6751660505768033], 
               StripOnInput -> False], Background -> 
              RGBColor[
               0.6580825836001154, 0.8179932685037092, 0.04012523598263873], 
              StripOnInput -> False]}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4b524e49-67e4-4574-a41c-29e089b2b41f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Start with a size-50 \[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote], then \
make a list of nestedly applying a frame and a random rotation 5 times.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9d98640f-b195-4bbf-96d2-9edf6842b565"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         StyleBox["\<\"A\"\>",
          StripOnInput->False,
          FontSize->50], ",", 
         RotationBox[
          FrameBox[
           StyleBox["\<\"A\"\>",
            StripOnInput->False,
            FontSize->50],
           StripOnInput->False],
          BoxRotation->4.9980562649183895`], ",", 
         RotationBox[
          FrameBox[
           RotationBox[
            FrameBox[
             StyleBox["\<\"A\"\>",
              StripOnInput->False,
              FontSize->50],
             StripOnInput->False],
            BoxRotation->4.9980562649183895`],
           StripOnInput->False],
          BoxRotation->4.0892170524668], ",", 
         RotationBox[
          FrameBox[
           RotationBox[
            FrameBox[
             RotationBox[
              FrameBox[
               StyleBox["\<\"A\"\>",
                StripOnInput->False,
                FontSize->50],
               StripOnInput->False],
              BoxRotation->4.9980562649183895`],
             StripOnInput->False],
            BoxRotation->4.0892170524668],
           StripOnInput->False],
          BoxRotation->4.066341978173231], ",", 
         RotationBox[
          FrameBox[
           RotationBox[
            FrameBox[
             RotationBox[
              FrameBox[
               RotationBox[
                FrameBox[
                 StyleBox["\<\"A\"\>",
                  StripOnInput->False,
                  FontSize->50],
                 StripOnInput->False],
                BoxRotation->4.9980562649183895`],
               StripOnInput->False],
              BoxRotation->4.0892170524668],
             StripOnInput->False],
            BoxRotation->4.066341978173231],
           StripOnInput->False],
          BoxRotation->3.2390188610862616`], ",", 
         RotationBox[
          FrameBox[
           RotationBox[
            FrameBox[
             RotationBox[
              FrameBox[
               RotationBox[
                FrameBox[
                 RotationBox[
                  FrameBox[
                   StyleBox["\<\"A\"\>",
                    StripOnInput->False,
                    FontSize->50],
                   StripOnInput->False],
                  BoxRotation->4.9980562649183895`],
                 StripOnInput->False],
                BoxRotation->4.0892170524668],
               StripOnInput->False],
              BoxRotation->4.066341978173231],
             StripOnInput->False],
            BoxRotation->3.2390188610862616`],
           StripOnInput->False],
          BoxRotation->1.4465488746657034`]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"892a3889-8b99-4ca2-baf1-0637c7512d05"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             StyleBox["\"A\"", StripOnInput -> False, FontSize -> 50], ",", 
             RotationBox[
              FrameBox[
               StyleBox["\"A\"", StripOnInput -> False, FontSize -> 50], 
               StripOnInput -> False], BoxRotation -> 4.9980562649183895`], 
             ",", 
             RotationBox[
              FrameBox[
               RotationBox[
                FrameBox[
                 StyleBox["\"A\"", StripOnInput -> False, FontSize -> 50], 
                 StripOnInput -> False], BoxRotation -> 4.9980562649183895`], 
               StripOnInput -> False], BoxRotation -> 4.0892170524668], ",", 
             RotationBox[
              FrameBox[
               RotationBox[
                FrameBox[
                 RotationBox[
                  FrameBox[
                   StyleBox["\"A\"", StripOnInput -> False, FontSize -> 50], 
                   StripOnInput -> False], BoxRotation -> 
                  4.9980562649183895`], StripOnInput -> False], BoxRotation -> 
                4.0892170524668], StripOnInput -> False], BoxRotation -> 
              4.066341978173231], ",", 
             RotationBox[
              FrameBox[
               RotationBox[
                FrameBox[
                 RotationBox[
                  FrameBox[
                   RotationBox[
                    FrameBox[
                    StyleBox["\"A\"", StripOnInput -> False, FontSize -> 50], 
                    StripOnInput -> False], BoxRotation -> 
                    4.9980562649183895`], StripOnInput -> False], BoxRotation -> 
                  4.0892170524668], StripOnInput -> False], BoxRotation -> 
                4.066341978173231], StripOnInput -> False], BoxRotation -> 
              3.2390188610862616`], ",", 
             RotationBox[
              FrameBox[
               RotationBox[
                FrameBox[
                 RotationBox[
                  FrameBox[
                   RotationBox[
                    FrameBox[
                    RotationBox[
                    FrameBox[
                    StyleBox["\"A\"", StripOnInput -> False, FontSize -> 50], 
                    StripOnInput -> False], BoxRotation -> 
                    4.9980562649183895`], StripOnInput -> False], BoxRotation -> 
                    4.0892170524668], StripOnInput -> False], BoxRotation -> 
                  4.066341978173231], StripOnInput -> False], BoxRotation -> 
                3.2390188610862616`], StripOnInput -> False], BoxRotation -> 
              1.4465488746657034`]}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"31e01dd9-f013-4e73-8be1-8f16f64f1d7d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of 100 iterations of the ",
 StyleBox["logistic map iteration",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{"4", " ", 
   ButtonBox["#",
    BaseStyle->"Link",
    ButtonData->"Slot"], 
   RowBox[{"(", 
    RowBox[{"1", 
     ButtonBox["-",
      BaseStyle->"Link",
      ButtonData->"Subtract"], 
     ButtonBox["#",
      BaseStyle->"Link",
      ButtonData->"Slot"]}], ")"}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCode",ExpressionUUID->
  "dde68693-332f-4862-bf1d-94abe9b053cd"],
 ", starting from 0.2.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e114f488-7b5b-458e-add7-534e3b717d80"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJw1kwlUVGUYhscghUokQyUrllgzRJDNSuSVHWQZZoGBGFCKACMgEgwVuRZL
JRa0GFCUC+BhH6MQAmJCkUUIRuegIVAYyCKyYzmZpofvv+fcc89z3/+9//fe
7/sNI+IFkY/xeLzIh/ej5/I161SQ/+jqcKIXOKRT5TF8YIRYA7mX0jybU28T
a6O393KuTdplYh0sDs+kCn0niXWRUPRR//mGG8TPY/LNa8+Nac8QGyBmIEOj
W62J+EVU65lkztb/TmyM/oDc3wxap4lNcTz7v3m/qRZicxiliw8aG/xJvAkJ
dw5fP/yAfd8CiuaIf/2MrYgtEaUujfU24hNbQal7tmabfgKxNSLspI+rtHKI
t0LXbodKrbCa2AYFFjwJv7Sb2BY/eLXePddxk9gO7vZPNB5zZPntMXHxtJbr
CMvvAI8K857YRZZnG2bX2/4RullO/AqiD1Wa3XIZIH4VFS8lndqbw/K8huom
i5Kn08uJt2Pw56N1RzQ7iR3hla3gFzWxfu3AFYWOZZcV65cTNoYkZKVySmIg
WhTrEDJ0a5k5wCDZurStne2/E3HV5SbulbQ/txMmx1KjHrxfRLoz8q9suR53
5jzpzuisTJkeOsX64YKBhBVGTy0wvwtKei9VOA6mkO6KNIOrkriafNJdsa7i
hLqPVj3pbjC1F4RzBX2ku2F4WuVW4sjyuEOm7NTKfZnycO4Q9lYdePcE5eF5
oO8DUUis7RDpHvhnY22pw032Pz3Rtro/NKfmY9I9IRdskdzfXUq6F8I8awwX
9NpJ94JNvHcK/4u/SPeG8fakxcm3qJ+cN6x1w/KSvWk9bxdk8orusCpaz+1C
g160224/1n8fLGVpdTeW0XnjfFAok/qZZbD++cIwYyHJKpHycr74pqPFVrOb
nTc/lHfa8N0/pXnj/PCkZGnxnbVs3vyRXtOT810y+//++GXv/P59N2Sk8zEl
s7ds+KRnmcGHrdLUbP7CGK3no2Dg9daofePLLOejS1FW9bk26bwACGd07w60
TJA/AJmaaSHqG6h+LgAZjsmx9eNUvzwAa+XZVt2utB9PgPE1jQrRSfoeBGhp
T9lwp4724wR4I9r5YHgqnS+5AMFzAyqXRna+hDj9dtZnq/KGyS/E8Gj7vR+r
WF4hNFc2n9XXp3mVC7Gp8ENhtYjmlSeCdVuZkzCG5hUirEgMFH6lYn4RWqeX
mlediSS/COnr517Yk5dBfjG0rhV1rAsrJr8Y74U8W9uVcoH8YnTJh/s8bag+
uRga399bOapg8xeI++lSmdvUcfIHQnN/8ebx6FryByJcKvb8KZHmWx6IkbL8
i7FKNt9BiDGfKM5TGyR/EEISihwq6lj9QWhza7u9tfIk+YPwrdfqpb+1fyW/
BP4CK9nYl8wvwZxSetSe1cdJEK/ydsp0/pr8D/XgZ0ZdG6g+XjDOKVRrsmup
PgQj1GeP7Kr6lNP/TtbuJQ==
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 101.}, {0, 0.9999384200124961}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "03e9549c-03b6-4663-9abb-a38aae3040d0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJw1kwlUVGUYhscghUokQyUrllgzRJDNSuSVHWQZZoGBGFCKACMgEgwVuRZL
JRa0GFCUC+BhH6MQAmJCkUUIRuegIVAYyCKyYzmZpofvv+fcc89z3/+9//fe
7/sNI+IFkY/xeLzIh/ej5/I161SQ/+jqcKIXOKRT5TF8YIRYA7mX0jybU28T
a6O393KuTdplYh0sDs+kCn0niXWRUPRR//mGG8TPY/LNa8+Nac8QGyBmIEOj
W62J+EVU65lkztb/TmyM/oDc3wxap4lNcTz7v3m/qRZicxiliw8aG/xJvAkJ
dw5fP/yAfd8CiuaIf/2MrYgtEaUujfU24hNbQal7tmabfgKxNSLspI+rtHKI
t0LXbodKrbCa2AYFFjwJv7Sb2BY/eLXePddxk9gO7vZPNB5zZPntMXHxtJbr
CMvvAI8K857YRZZnG2bX2/4RullO/AqiD1Wa3XIZIH4VFS8lndqbw/K8huom
i5Kn08uJt2Pw56N1RzQ7iR3hla3gFzWxfu3AFYWOZZcV65cTNoYkZKVySmIg
WhTrEDJ0a5k5wCDZurStne2/E3HV5SbulbQ/txMmx1KjHrxfRLoz8q9suR53
5jzpzuisTJkeOsX64YKBhBVGTy0wvwtKei9VOA6mkO6KNIOrkriafNJdsa7i
hLqPVj3pbjC1F4RzBX2ku2F4WuVW4sjyuEOm7NTKfZnycO4Q9lYdePcE5eF5
oO8DUUis7RDpHvhnY22pw032Pz3Rtro/NKfmY9I9IRdskdzfXUq6F8I8awwX
9NpJ94JNvHcK/4u/SPeG8fakxcm3qJ+cN6x1w/KSvWk9bxdk8orusCpaz+1C
g160224/1n8fLGVpdTeW0XnjfFAok/qZZbD++cIwYyHJKpHycr74pqPFVrOb
nTc/lHfa8N0/pXnj/PCkZGnxnbVs3vyRXtOT810y+//++GXv/P59N2Sk8zEl
s7ds+KRnmcGHrdLUbP7CGK3no2Dg9daofePLLOejS1FW9bk26bwACGd07w60
TJA/AJmaaSHqG6h+LgAZjsmx9eNUvzwAa+XZVt2utB9PgPE1jQrRSfoeBGhp
T9lwp4724wR4I9r5YHgqnS+5AMFzAyqXRna+hDj9dtZnq/KGyS/E8Gj7vR+r
WF4hNFc2n9XXp3mVC7Gp8ENhtYjmlSeCdVuZkzCG5hUirEgMFH6lYn4RWqeX
mlediSS/COnr517Yk5dBfjG0rhV1rAsrJr8Y74U8W9uVcoH8YnTJh/s8bag+
uRga399bOapg8xeI++lSmdvUcfIHQnN/8ebx6FryByJcKvb8KZHmWx6IkbL8
i7FKNt9BiDGfKM5TGyR/EEISihwq6lj9QWhza7u9tfIk+YPwrdfqpb+1fyW/
BP4CK9nYl8wvwZxSetSe1cdJEK/ydsp0/pr8D/XgZ0ZdG6g+XjDOKVRrsmup
PgQj1GeP7Kr6lNP/TtbuJQ==
               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 101.}, {0, 0.9999384200124961}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4bcea6b2-429d-42fe-85da-08109a3636c8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the numerical value of the result from 30 iterations of ",
 Cell[BoxData[
  RowBox[{"1", 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], 
   RowBox[{"1", "/", 
    ButtonBox["#",
     BaseStyle->"Link",
     ButtonData->"Slot"]}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCode",ExpressionUUID->
  "c11e23b5-56d6-479e-a4b6-75601a568cd4"],
 " starting from 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3e71dba0-896c-4706-9c19-16cf7c1c13d1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "1.6180339887496482`"], "ExerciseOutput",ExpressionUUID->
       "afb642a9-6388-4fef-8196-1a73958d690a"],
      Apply[TextCell, 
       Cell[
        BoxData["1.6180339887496482`"], "ExerciseOutput", Selectable -> False,
         Copyable -> False, Editable -> False, ShowCellBracket -> False]]], 
     " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7dace418-f0c1-4aed-8596-374c831f6df4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a list of the first 10 powers of 3 (starting at 0) by nested \
multiplication.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"897bd7e6-38b0-486e-8b1f-2bae0aeeee45"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "3", ",", "9", ",", "27", ",", "81", ",", "243", ",", "729",
          ",", "2187", ",", "6561", ",", "19683", ",", "59049"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "bb496c37-6f41-4bfe-8e59-1f55d6359087"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "3", ",", "9", ",", "27", ",", "81", ",", "243", 
             ",", "729", ",", "2187", ",", "6561", ",", "19683", ",", 
             "59049"}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"409dfdb8-e338-4432-b1cd-faeaf8423c21"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the result of nesting the (",
 StyleBox["Newton\[CloseCurlyQuote]s method",
  FontSlant->"Italic"],
 ") function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], 
      ButtonBox["+",
       BaseStyle->"Link",
       ButtonData->"Plus"], 
      RowBox[{"2", "/", 
       ButtonBox["#",
        BaseStyle->"Link",
        ButtonData->"Slot"]}]}], ")"}], "/", "2"}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCode",ExpressionUUID->
  "2860ceec-b985-4f25-80cd-ae858f252c1e"],
 " up to 5 times starting from 1.0, and then subtract ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]],ExpressionUUID->
  "bc58e537-a077-437a-b57c-29fb2264b225"],
 "from all the results.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"8a806f5d-421b-4aca-9407-cab4bf64f9a5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.41421356237309515`"}], ",", "0.08578643762690485`", 
         ",", "0.002453104293571373`", ",", "2.123901414519125`*^-6", ",", 
         "1.5947243525715749`*^-12", ",", 
         RowBox[{"-", "2.220446049250313`*^-16"}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"42b1153b-9398-4891-9c3d-c2631c5d19cc"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"-", "0.41421356237309515`"}], ",", 
             "0.08578643762690485`", ",", "0.002453104293571373`", ",", 
             "2.123901414519125`*^-6", ",", "1.5947243525715749`*^-12", ",", 
             RowBox[{"-", "2.220446049250313`*^-16"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"857d9a28-920f-466b-a5f7-63656369b161"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make graphics of a 1000-step 2D random walk which starts at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "0b7466c8-bc10-4020-bc9f-8489aecd9ec9"],
 ", and in which at each step a pair of random numbers between \[Minus]1 and \
+1 are added to the coordinates.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"69aeeb2c-708d-457b-92f1-f98526cacae8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[LineBox[CompressedData["
1:eJxdWGk8lN/7lhJCFFmzjW0WY8w+Y71TCUkLQglpUVpFSiqt35ItLSpCEVkr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         "]]]], "ExerciseOutput",
       ExpressionUUID->"46836e1d-804f-4823-a698-1c69c60fe637"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          LineBox[CompressedData["
1:eJxdWGk8lN/7lhJCFFmzjW0WY8w+Y71TCUkLQglpUVpFSiqt35ItLSpCEVkr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           "]]]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"084f9d46-089c-40b1-a690-06c027790a56"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an array plot of 50 steps of Pascal\[CloseCurlyQuote]s triangle modulo \
2 by starting from ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineCode",ExpressionUUID->
  "5a5e3b8d-4287-449f-8766-e1edc4b18941"],
 " and nestedly joining ",
 Cell[BoxData[
  RowBox[{"{", "0", "}"}]], "InlineCode",ExpressionUUID->
  "1f4dd723-afcc-4530-b575-f486fdbdcc06"],
 " at the beginning and at the end, and adding these results together modulo \
2.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:26",ExpressionUUID->"23cabca6-9eb3-4e37-a1ac-206ecb4801c6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[RasterBox[CompressedData["
1:eJztlcFtXDEMBRdwGnENLiA9pAQDPqf1lJBLTkbePu2n9ElR84BgDkOu9COJ
fv/8/evr7fF4fPz79+Ph8ufnGKP9MJcqnP8ZVOH8z6DKrP6oh3tThfM/gyqc
/xlUiZ6/S/Z3w3uokr0veA9VsvcF76HKaN+rv/u9D9/bw7Opgj/DR/9+RP++
rPr7R3+Nfng2Vejv3e/qZnm3P+dX32/WX7s+PJsqp9z/ruu7urv81f3f9f/L
+hD2vX+sf219V1fFq4x+f9RnM7r/qIcwkyqn3P/o/qPe7Wt3rzLrfKozuv9o
P4SZVDnl/kf3f7Xf1XXxKl3uT/R+OA/hzlQ55f6773Pe/e7pXiX73KvcLwg7
UyV7X9W/39Xhn2f0/393D+HJVDnFZ8/f7l5l1v2s3g/hyVTp3u/q8HO8yqzz
j96P1etDeDJVdn//rg5/j1epcr8hhH3f39X1XR2+hlcZPf+ohxDmUSX7/bs6
/B5eZdb9hBDWpcrqfleH7+FVZt0/CGFdqkTfv6vDn+FVsu89hHA9VUb78Phn
XmX0/uHx+H199vzB9/Yq7v5F7y/99NOf1+/q8PgZXmXW/Y++D9ZnfdZ/fX1X
h8ff4VVmvZ/o+2J91mf9uvMDj3/mVUbvf9RnM7r/qM9mdP9Rn83o/qM++/3j
8Su9yqz3WZ3R/Uf7sxndf7Q/m9H9X+13dXh8B6/SZX5E54Pzu9N9n/O7032f
89nvF4+v7FWy332V+dKdKtn7qv79rg6Px+uMvr/d/elUOcVnvz88vrNXmTWf
qvefTpXu/a4Oj8fHvcqs9x+dD6vXP50qu5+/q8Pj8eu9SpX5BtdSpfr6rg6P
x+d7ldH3H/UwlyrZ5+/q8Hh8fa8yaz7B2lRZ3e/q8Hj8/l5l1vyBtakSPX9X
h8fj+3uV7LkH76HKaB8ej8ePzpXvffjePvv+4fH4vl7FzZ/o/KI/t9/V4fF4
fNSrzJp/0fnI+tfWd3V4PB6/2qvMmp/R+cr6z/vweDy+qlcZnX9Rn83o/qM+
+/zxeDx+lVeZNZ+rM7r/q/2uDo/H43f3KrPmb3W673M++/zweDy+qldx87ML
VUb78Hg8Hv9/rzI6f3f32f//eDwe39WrqL7R36ne7+rweDweH/Mqrk797qtc
tb6rw+PxePxar6L6ZvPq+q4Oj8fj8blexdXN8tnfj8fj8fg1XkX1jf7OaB8e
j8fje3oVV6d+t9r34fF4PD7Hq6i+avvH4/F4fDX/F+4cVCU=
         "], {{0, 0}, {51, 
         51}}, {0, 1}],
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "102dc75c-c7a0-4950-9d87-d37bec3ac8a2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          RasterBox[CompressedData["
1:eJztlcFtXDEMBRdwGnENLiA9pAQDPqf1lJBLTkbePu2n9ElR84BgDkOu9COJ
fv/8/evr7fF4fPz79+Ph8ufnGKP9MJcqnP8ZVOH8z6DKrP6oh3tThfM/gyqc
/xlUiZ6/S/Z3w3uokr0veA9VsvcF76HKaN+rv/u9D9/bw7Opgj/DR/9+RP++
rPr7R3+Nfng2Vejv3e/qZnm3P+dX32/WX7s+PJsqp9z/ruu7urv81f3f9f/L
+hD2vX+sf219V1fFq4x+f9RnM7r/qIcwkyqn3P/o/qPe7Wt3rzLrfKozuv9o
P4SZVDnl/kf3f7Xf1XXxKl3uT/R+OA/hzlQ55f6773Pe/e7pXiX73KvcLwg7
UyV7X9W/39Xhn2f0/393D+HJVDnFZ8/f7l5l1v2s3g/hyVTp3u/q8HO8yqzz
j96P1etDeDJVdn//rg5/j1epcr8hhH3f39X1XR2+hlcZPf+ohxDmUSX7/bs6
/B5eZdb9hBDWpcrqfleH7+FVZt0/CGFdqkTfv6vDn+FVsu89hHA9VUb78Phn
XmX0/uHx+H199vzB9/Yq7v5F7y/99NOf1+/q8PgZXmXW/Y++D9ZnfdZ/fX1X
h8ff4VVmvZ/o+2J91mf9uvMDj3/mVUbvf9RnM7r/qM9mdP9Rn83o/qM++/3j
8Su9yqz3WZ3R/Uf7sxndf7Q/m9H9X+13dXh8B6/SZX5E54Pzu9N9n/O7032f
89nvF4+v7FWy332V+dKdKtn7qv79rg6Px+uMvr/d/elUOcVnvz88vrNXmTWf
qvefTpXu/a4Oj8fHvcqs9x+dD6vXP50qu5+/q8Pj8eu9SpX5BtdSpfr6rg6P
x+d7ldH3H/UwlyrZ5+/q8Hh8fa8yaz7B2lRZ3e/q8Hj8/l5l1vyBtakSPX9X
h8fj+3uV7LkH76HKaB8ej8ePzpXvffjePvv+4fH4vl7FzZ/o/KI/t9/V4fF4
fNSrzJp/0fnI+tfWd3V4PB6/2qvMmp/R+cr6z/vweDy+qlcZnX9Rn83o/qM+
+/zxeDx+lVeZNZ+rM7r/q/2uDo/H43f3KrPmb3W673M++/zweDy+qldx87ML
VUb78Hg8Hv9/rzI6f3f32f//eDwe39WrqL7R36ne7+rweDweH/Mqrk797qtc
tb6rw+PxePxar6L6ZvPq+q4Oj8fj8blexdXN8tnfj8fj8fg1XkX1jf7OaB8e
j8fje3oVV6d+t9r34fF4PD7Hq6i+avvH4/F4fDX/F+4cVCU=
           "], {{0, 0}, {51, 
           51}}, {0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
          FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9cdb285e-bd40-41ce-8cd1-8f07892f0669"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a graph by starting from 0, then nestedly 10 times connecting each \
node with value ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"c2daff86-6a92-412a-b31d-59fc71b07952"],
 " to ones with values ",
 Cell[BoxData[
  RowBox[{"n", "+", "1"}]], "InlineCode",ExpressionUUID->
  "08524c2d-9106-4df9-8ee2-edceb70547d4"],
 " and ",
 Cell[BoxData[
  RowBox[{"2", "n"}]], "InlineCode",ExpressionUUID->
  "46410c6c-2835-42d7-a432-4eee809c0e02"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1875dd2c-c024-40f1-8528-4581e96b9d04"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           Graph[CompressedData["
1:eJwt0skz12EcwPGfraxJdmVP2deyFMauhEGYMg72UWNs49BRhZHpENPBEePg
6E9Q4+DoT/CneH2HZ+Y178/1eT5P/szKyHJYKBT6E7o7wRxOBJE8IIpoYnlI
PI+I4TFPiCOFNBLIIItEnpFDEnkUkMxzXpBKMaWkU04lmVRTy1NeUU82jbwh
l2ZayaeNDgrpooci3tHHS/oZpIQhRihjlHEq+MQEVUxSwxQz1DHHAq9Z5CsN
LNHEKuu8ZYMWvtHOJj/oZIsdutllj15+8/5+Lwd84C8DHDLMESd85JQxzvjM
OdNc8J9ZLpnnii9cs8YN3wmWH85PY6Rua7T+Cvas+8H+9Dh4Z/0X3EXD7j/N
LaGIK1g=
            "], {CompressedData["
1:eJwVxWdbAQEAAGDrzLO3s87ZM86ZWVFZUWhZoWiRFu2iveuv9A+rD+/zwq1+
oUXA4XA/f/7H4/EEApFIIgIkgEQGKACVQqbQyHQyg06lg1QmlcWkMdk0Do3L
YXB4DD5DwAf5QlAEikUskYQlZcmkbCnElrMVcq5cyVVx1SqeCuZpeIhGoNEK
dAK9TqgzCI1Ck1FsNIstYqtFYrFJ7BKHXWafkDllLifkRCE3hLkVbo/Cq/B5
lV6/MqAMBtSBSXVIHQ7BoQgchWNRJDqFxJFEXBuf1s5oZ/VJfSppSKYNGUM2
Y8rMmXKmfM6cmzcvmAvWorVUtBUXbUu2ZceKY9VVdlXKaLmK1tB6DautYQ2s
2fA0Wp51z4av7eu0/e1N/5Z/O7gT3A13w71upLsX6Uf2Ywexw8RR4jg1SA0H
6cFJ+jR9lj3PXuQv81el69JNZVQZj6qj2+pd9b7+UH9sPjWfOy+d195b7334
Mfwcf42/fwFkglHm
             "], Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9lnk01YsWx48xY6aDwzk4vzM5xzw8paLfNyXzkIyl2+V2JU1ENymqExVx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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.013102467270422408`], 
               ArrowBox[BezierCurveBox[{1, 148, 151, 153, 159, 161, 164, 1},
                SplineDegree->7], 0.08172557922900292], 
               ArrowBox[{1, 2}, 0.08172557922900292], 
               ArrowBox[{2, 3}, 0.08172557922900292], 
               ArrowBox[{3, 4}, 0.08172557922900292], 
               ArrowBox[{3, 5}, 0.08172557922900292], 
               ArrowBox[{4, 5}, 0.08172557922900292], 
               ArrowBox[{4, 6}, 0.08172557922900292], 
               ArrowBox[{5, 7}, 0.08172557922900292], 
               ArrowBox[{5, 8}, 0.08172557922900292], 
               ArrowBox[{6, 10}, 0.08172557922900292], 
               ArrowBox[{6, 11}, 0.08172557922900292], 
               ArrowBox[{7, 6}, 0.08172557922900292], 
               ArrowBox[{7, 9}, 0.08172557922900292], 
               ArrowBox[{8, 13}, 0.08172557922900292], 
               ArrowBox[{8, 14}, 0.08172557922900292], 
               ArrowBox[{9, 16}, 0.08172557922900292], 
               ArrowBox[{9, 17}, 0.08172557922900292], 
               ArrowBox[{10, 8}, 0.08172557922900292], 
               ArrowBox[{10, 12}, 0.08172557922900292], 
               ArrowBox[{11, 19}, 0.08172557922900292], 
               ArrowBox[{11, 20}, 0.08172557922900292], 
               ArrowBox[{12, 22}, 0.08172557922900292], 
               ArrowBox[{12, 23}, 0.08172557922900292], 
               ArrowBox[{13, 9}, 0.08172557922900292], 
               ArrowBox[{13, 15}, 0.08172557922900292], 
               ArrowBox[{14, 25}, 0.08172557922900292], 
               ArrowBox[{14, 26}, 0.08172557922900292], 
               ArrowBox[{15, 28}, 0.08172557922900292], 
               ArrowBox[{15, 29}, 0.08172557922900292], 
               ArrowBox[{16, 11}, 0.08172557922900292], 
               ArrowBox[{16, 18}, 0.08172557922900292], 
               ArrowBox[{17, 31}, 0.08172557922900292], 
               ArrowBox[{17, 32}, 0.08172557922900292], 
               ArrowBox[{18, 34}, 0.08172557922900292], 
               ArrowBox[{18, 35}, 0.08172557922900292], 
               ArrowBox[{19, 12}, 0.08172557922900292], 
               ArrowBox[{19, 21}, 0.08172557922900292], 
               ArrowBox[{20, 37}, 0.08172557922900292], 
               ArrowBox[{20, 38}, 0.08172557922900292], 
               ArrowBox[{21, 40}, 0.08172557922900292], 
               ArrowBox[{21, 41}, 0.08172557922900292], 
               ArrowBox[{22, 14}, 0.08172557922900292], 
               ArrowBox[{22, 24}, 0.08172557922900292], 
               ArrowBox[{23, 43}, 0.08172557922900292], 
               ArrowBox[{23, 44}, 0.08172557922900292], 
               ArrowBox[{24, 46}, 0.08172557922900292], 
               ArrowBox[{24, 47}, 0.08172557922900292], 
               ArrowBox[{25, 15}, 0.08172557922900292], 
               ArrowBox[{25, 27}, 0.08172557922900292], 
               ArrowBox[{26, 49}, 0.08172557922900292], 
               ArrowBox[{26, 50}, 0.08172557922900292], 
               ArrowBox[{27, 52}, 0.08172557922900292], 
               ArrowBox[{27, 53}, 0.08172557922900292], 
               ArrowBox[{28, 17}, 0.08172557922900292], 
               ArrowBox[{28, 30}, 0.08172557922900292], 
               ArrowBox[{29, 55}, 0.08172557922900292], 
               ArrowBox[{29, 56}, 0.08172557922900292], 
               ArrowBox[{30, 58}, 0.08172557922900292], 
               ArrowBox[{30, 59}, 0.08172557922900292], 
               ArrowBox[{31, 18}, 0.08172557922900292], 
               ArrowBox[{31, 33}, 0.08172557922900292], 
               ArrowBox[{32, 61}, 0.08172557922900292], 
               ArrowBox[{32, 62}, 0.08172557922900292], 
               ArrowBox[{33, 64}, 0.08172557922900292], 
               ArrowBox[{33, 65}, 0.08172557922900292], 
               ArrowBox[{34, 20}, 0.08172557922900292], 
               ArrowBox[{34, 36}, 0.08172557922900292], 
               ArrowBox[{35, 67}, 0.08172557922900292], 
               ArrowBox[{35, 68}, 0.08172557922900292], 
               ArrowBox[{36, 70}, 0.08172557922900292], 
               ArrowBox[{36, 71}, 0.08172557922900292], 
               ArrowBox[{37, 21}, 0.08172557922900292], 
               ArrowBox[{37, 39}, 0.08172557922900292], 
               ArrowBox[{38, 72}, 0.08172557922900292], 
               ArrowBox[{38, 73}, 0.08172557922900292], 
               ArrowBox[{39, 75}, 0.08172557922900292], 
               ArrowBox[{39, 76}, 0.08172557922900292], 
               ArrowBox[{40, 23}, 0.08172557922900292], 
               ArrowBox[{40, 42}, 0.08172557922900292], 
               ArrowBox[{41, 78}, 0.08172557922900292], 
               ArrowBox[{41, 79}, 0.08172557922900292], 
               ArrowBox[{42, 81}, 0.08172557922900292], 
               ArrowBox[{42, 82}, 0.08172557922900292], 
               ArrowBox[{43, 24}, 0.08172557922900292], 
               ArrowBox[{43, 45}, 0.08172557922900292], 
               ArrowBox[{44, 83}, 0.08172557922900292], 
               ArrowBox[{44, 84}, 0.08172557922900292], 
               ArrowBox[{45, 86}, 0.08172557922900292], 
               ArrowBox[{45, 87}, 0.08172557922900292], 
               ArrowBox[{46, 26}, 0.08172557922900292], 
               ArrowBox[{46, 48}, 0.08172557922900292], 
               ArrowBox[{47, 88}, 0.08172557922900292], 
               ArrowBox[{47, 89}, 0.08172557922900292], 
               ArrowBox[{49, 27}, 0.08172557922900292], 
               ArrowBox[{49, 51}, 0.08172557922900292], 
               ArrowBox[{50, 90}, 0.08172557922900292], 
               ArrowBox[{50, 91}, 0.08172557922900292], 
               ArrowBox[{51, 93}, 0.08172557922900292], 
               ArrowBox[{51, 94}, 0.08172557922900292], 
               ArrowBox[{52, 29}, 0.08172557922900292], 
               ArrowBox[{52, 54}, 0.08172557922900292], 
               ArrowBox[{53, 96}, 0.08172557922900292], 
               ArrowBox[{53, 97}, 0.08172557922900292], 
               ArrowBox[{54, 99}, 0.08172557922900292], 
               ArrowBox[{54, 100}, 0.08172557922900292], 
               ArrowBox[{55, 30}, 0.08172557922900292], 
               ArrowBox[{55, 57}, 0.08172557922900292], 
               ArrowBox[{56, 101}, 0.08172557922900292], 
               ArrowBox[{56, 102}, 0.08172557922900292], 
               ArrowBox[{57, 104}, 0.08172557922900292], 
               ArrowBox[{57, 105}, 0.08172557922900292], 
               ArrowBox[{58, 32}, 0.08172557922900292], 
               ArrowBox[{58, 60}, 0.08172557922900292], 
               ArrowBox[{59, 106}, 0.08172557922900292], 
               ArrowBox[{59, 107}, 0.08172557922900292], 
               ArrowBox[{61, 33}, 0.08172557922900292], 
               ArrowBox[{61, 63}, 0.08172557922900292], 
               ArrowBox[{62, 108}, 0.08172557922900292], 
               ArrowBox[{62, 109}, 0.08172557922900292], 
               ArrowBox[{63, 111}, 0.08172557922900292], 
               ArrowBox[{63, 112}, 0.08172557922900292], 
               ArrowBox[{64, 35}, 0.08172557922900292], 
               ArrowBox[{64, 66}, 0.08172557922900292], 
               ArrowBox[{65, 113}, 0.08172557922900292], 
               ArrowBox[{65, 114}, 0.08172557922900292], 
               ArrowBox[{67, 36}, 0.08172557922900292], 
               ArrowBox[{67, 69}, 0.08172557922900292], 
               ArrowBox[{68, 115}, 0.08172557922900292], 
               ArrowBox[{68, 116}, 0.08172557922900292], 
               ArrowBox[{72, 39}, 0.08172557922900292], 
               ArrowBox[{72, 74}, 0.08172557922900292], 
               ArrowBox[{73, 117}, 0.08172557922900292], 
               ArrowBox[{73, 118}, 0.08172557922900292], 
               ArrowBox[{74, 120}, 0.08172557922900292], 
               ArrowBox[{74, 121}, 0.08172557922900292], 
               ArrowBox[{75, 41}, 0.08172557922900292], 
               ArrowBox[{75, 77}, 0.08172557922900292], 
               ArrowBox[{76, 122}, 0.08172557922900292], 
               ArrowBox[{76, 123}, 0.08172557922900292], 
               ArrowBox[{78, 42}, 0.08172557922900292], 
               ArrowBox[{78, 80}, 0.08172557922900292], 
               ArrowBox[{79, 124}, 0.08172557922900292], 
               ArrowBox[{79, 125}, 0.08172557922900292], 
               ArrowBox[{83, 45}, 0.08172557922900292], 
               ArrowBox[{83, 85}, 0.08172557922900292], 
               ArrowBox[{84, 126}, 0.08172557922900292], 
               ArrowBox[{84, 127}, 0.08172557922900292], 
               ArrowBox[{90, 51}, 0.08172557922900292], 
               ArrowBox[{90, 92}, 0.08172557922900292], 
               ArrowBox[{91, 128}, 0.08172557922900292], 
               ArrowBox[{91, 129}, 0.08172557922900292], 
               ArrowBox[{92, 131}, 0.08172557922900292], 
               ArrowBox[{92, 132}, 0.08172557922900292], 
               ArrowBox[{93, 53}, 0.08172557922900292], 
               ArrowBox[{93, 95}, 0.08172557922900292], 
               ArrowBox[{94, 133}, 0.08172557922900292], 
               ArrowBox[{94, 134}, 0.08172557922900292], 
               ArrowBox[{96, 54}, 0.08172557922900292], 
               ArrowBox[{96, 98}, 0.08172557922900292], 
               ArrowBox[{97, 135}, 0.08172557922900292], 
               ArrowBox[{97, 136}, 0.08172557922900292], 
               ArrowBox[{101, 57}, 0.08172557922900292], 
               ArrowBox[{101, 103}, 0.08172557922900292], 
               ArrowBox[{102, 137}, 0.08172557922900292], 
               ArrowBox[{102, 138}, 0.08172557922900292], 
               ArrowBox[{108, 63}, 0.08172557922900292], 
               ArrowBox[{108, 110}, 0.08172557922900292], 
               ArrowBox[{109, 139}, 0.08172557922900292], 
               ArrowBox[{109, 140}, 0.08172557922900292], 
               ArrowBox[{117, 74}, 0.08172557922900292], 
               ArrowBox[{117, 119}, 0.08172557922900292], 
               ArrowBox[{118, 141}, 0.08172557922900292], 
               ArrowBox[{118, 142}, 0.08172557922900292], 
               ArrowBox[{128, 92}, 0.08172557922900292], 
               ArrowBox[{128, 130}, 0.08172557922900292], 
               ArrowBox[{129, 143}, 0.08172557922900292], 
               ArrowBox[{129, 144}, 0.08172557922900292]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.08172557922900292], 
               DiskBox[2, 0.08172557922900292], 
               DiskBox[3, 0.08172557922900292], 
               DiskBox[4, 0.08172557922900292], 
               DiskBox[5, 0.08172557922900292], 
               DiskBox[6, 0.08172557922900292], 
               DiskBox[7, 0.08172557922900292], 
               DiskBox[8, 0.08172557922900292], 
               DiskBox[9, 0.08172557922900292], 
               DiskBox[10, 0.08172557922900292], 
               DiskBox[11, 0.08172557922900292], 
               DiskBox[12, 0.08172557922900292], 
               DiskBox[13, 0.08172557922900292], 
               DiskBox[14, 0.08172557922900292], 
               DiskBox[15, 0.08172557922900292], 
               DiskBox[16, 0.08172557922900292], 
               DiskBox[17, 0.08172557922900292], 
               DiskBox[18, 0.08172557922900292], 
               DiskBox[19, 0.08172557922900292], 
               DiskBox[20, 0.08172557922900292], 
               DiskBox[21, 0.08172557922900292], 
               DiskBox[22, 0.08172557922900292], 
               DiskBox[23, 0.08172557922900292], 
               DiskBox[24, 0.08172557922900292], 
               DiskBox[25, 0.08172557922900292], 
               DiskBox[26, 0.08172557922900292], 
               DiskBox[27, 0.08172557922900292], 
               DiskBox[28, 0.08172557922900292], 
               DiskBox[29, 0.08172557922900292], 
               DiskBox[30, 0.08172557922900292], 
               DiskBox[31, 0.08172557922900292], 
               DiskBox[32, 0.08172557922900292], 
               DiskBox[33, 0.08172557922900292], 
               DiskBox[34, 0.08172557922900292], 
               DiskBox[35, 0.08172557922900292], 
               DiskBox[36, 0.08172557922900292], 
               DiskBox[37, 0.08172557922900292], 
               DiskBox[38, 0.08172557922900292], 
               DiskBox[39, 0.08172557922900292], 
               DiskBox[40, 0.08172557922900292], 
               DiskBox[41, 0.08172557922900292], 
               DiskBox[42, 0.08172557922900292], 
               DiskBox[43, 0.08172557922900292], 
               DiskBox[44, 0.08172557922900292], 
               DiskBox[45, 0.08172557922900292], 
               DiskBox[46, 0.08172557922900292], 
               DiskBox[47, 0.08172557922900292], 
               DiskBox[48, 0.08172557922900292], 
               DiskBox[49, 0.08172557922900292], 
               DiskBox[50, 0.08172557922900292], 
               DiskBox[51, 0.08172557922900292], 
               DiskBox[52, 0.08172557922900292], 
               DiskBox[53, 0.08172557922900292], 
               DiskBox[54, 0.08172557922900292], 
               DiskBox[55, 0.08172557922900292], 
               DiskBox[56, 0.08172557922900292], 
               DiskBox[57, 0.08172557922900292], 
               DiskBox[58, 0.08172557922900292], 
               DiskBox[59, 0.08172557922900292], 
               DiskBox[60, 0.08172557922900292], 
               DiskBox[61, 0.08172557922900292], 
               DiskBox[62, 0.08172557922900292], 
               DiskBox[63, 0.08172557922900292], 
               DiskBox[64, 0.08172557922900292], 
               DiskBox[65, 0.08172557922900292], 
               DiskBox[66, 0.08172557922900292], 
               DiskBox[67, 0.08172557922900292], 
               DiskBox[68, 0.08172557922900292], 
               DiskBox[69, 0.08172557922900292], 
               DiskBox[70, 0.08172557922900292], 
               DiskBox[71, 0.08172557922900292], 
               DiskBox[72, 0.08172557922900292], 
               DiskBox[73, 0.08172557922900292], 
               DiskBox[74, 0.08172557922900292], 
               DiskBox[75, 0.08172557922900292], 
               DiskBox[76, 0.08172557922900292], 
               DiskBox[77, 0.08172557922900292], 
               DiskBox[78, 0.08172557922900292], 
               DiskBox[79, 0.08172557922900292], 
               DiskBox[80, 0.08172557922900292], 
               DiskBox[81, 0.08172557922900292], 
               DiskBox[82, 0.08172557922900292], 
               DiskBox[83, 0.08172557922900292], 
               DiskBox[84, 0.08172557922900292], 
               DiskBox[85, 0.08172557922900292], 
               DiskBox[86, 0.08172557922900292], 
               DiskBox[87, 0.08172557922900292], 
               DiskBox[88, 0.08172557922900292], 
               DiskBox[89, 0.08172557922900292], 
               DiskBox[90, 0.08172557922900292], 
               DiskBox[91, 0.08172557922900292], 
               DiskBox[92, 0.08172557922900292], 
               DiskBox[93, 0.08172557922900292], 
               DiskBox[94, 0.08172557922900292], 
               DiskBox[95, 0.08172557922900292], 
               DiskBox[96, 0.08172557922900292], 
               DiskBox[97, 0.08172557922900292], 
               DiskBox[98, 0.08172557922900292], 
               DiskBox[99, 0.08172557922900292], 
               DiskBox[100, 0.08172557922900292], 
               DiskBox[101, 0.08172557922900292], 
               DiskBox[102, 0.08172557922900292], 
               DiskBox[103, 0.08172557922900292], 
               DiskBox[104, 0.08172557922900292], 
               DiskBox[105, 0.08172557922900292], 
               DiskBox[106, 0.08172557922900292], 
               DiskBox[107, 0.08172557922900292], 
               DiskBox[108, 0.08172557922900292], 
               DiskBox[109, 0.08172557922900292], 
               DiskBox[110, 0.08172557922900292], 
               DiskBox[111, 0.08172557922900292], 
               DiskBox[112, 0.08172557922900292], 
               DiskBox[113, 0.08172557922900292], 
               DiskBox[114, 0.08172557922900292], 
               DiskBox[115, 0.08172557922900292], 
               DiskBox[116, 0.08172557922900292], 
               DiskBox[117, 0.08172557922900292], 
               DiskBox[118, 0.08172557922900292], 
               DiskBox[119, 0.08172557922900292], 
               DiskBox[120, 0.08172557922900292], 
               DiskBox[121, 0.08172557922900292], 
               DiskBox[122, 0.08172557922900292], 
               DiskBox[123, 0.08172557922900292], 
               DiskBox[124, 0.08172557922900292], 
               DiskBox[125, 0.08172557922900292], 
               DiskBox[126, 0.08172557922900292], 
               DiskBox[127, 0.08172557922900292], 
               DiskBox[128, 0.08172557922900292], 
               DiskBox[129, 0.08172557922900292], 
               DiskBox[130, 0.08172557922900292], 
               DiskBox[131, 0.08172557922900292], 
               DiskBox[132, 0.08172557922900292], 
               DiskBox[133, 0.08172557922900292], 
               DiskBox[134, 0.08172557922900292], 
               DiskBox[135, 0.08172557922900292], 
               DiskBox[136, 0.08172557922900292], 
               DiskBox[137, 0.08172557922900292], 
               DiskBox[138, 0.08172557922900292], 
               DiskBox[139, 0.08172557922900292], 
               DiskBox[140, 0.08172557922900292], 
               DiskBox[141, 0.08172557922900292], 
               DiskBox[142, 0.08172557922900292], 
               DiskBox[143, 0.08172557922900292], 
               DiskBox[144, 0.08172557922900292]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{513.98828125, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"fc6ce081-7c6d-4f4b-9433-e0a0ef3861ad"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               Graph[CompressedData["
1:eJwt0skz12EcwPGfraxJdmVP2deyFMauhEGYMg72UWNs49BRhZHpENPBEePg
6E9Q4+DoT/CneH2HZ+Y178/1eT5P/szKyHJYKBT6E7o7wRxOBJE8IIpoYnlI
PI+I4TFPiCOFNBLIIItEnpFDEnkUkMxzXpBKMaWkU04lmVRTy1NeUU82jbwh
l2ZayaeNDgrpooci3tHHS/oZpIQhRihjlHEq+MQEVUxSwxQz1DHHAq9Z5CsN
LNHEKuu8ZYMWvtHOJj/oZIsdutllj15+8/5+Lwd84C8DHDLMESd85JQxzvjM
OdNc8J9ZLpnnii9cs8YN3wmWH85PY6Rua7T+Cvas+8H+9Dh4Z/0X3EXD7j/N
LaGIK1g=
                "], {CompressedData["
1:eJwVxWdbAQEAAGDrzLO3s87ZM86ZWVFZUWhZoWiRFu2iveuv9A+rD+/zwq1+
oUXA4XA/f/7H4/EEApFIIgIkgEQGKACVQqbQyHQyg06lg1QmlcWkMdk0Do3L
YXB4DD5DwAf5QlAEikUskYQlZcmkbCnElrMVcq5cyVVx1SqeCuZpeIhGoNEK
dAK9TqgzCI1Ck1FsNIstYqtFYrFJ7BKHXWafkDllLifkRCE3hLkVbo/Cq/B5
lV6/MqAMBtSBSXVIHQ7BoQgchWNRJDqFxJFEXBuf1s5oZ/VJfSppSKYNGUM2
Y8rMmXKmfM6cmzcvmAvWorVUtBUXbUu2ZceKY9VVdlXKaLmK1tB6DautYQ2s
2fA0Wp51z4av7eu0/e1N/5Z/O7gT3A13w71upLsX6Uf2Ywexw8RR4jg1SA0H
6cFJ+jR9lj3PXuQv81el69JNZVQZj6qj2+pd9b7+UH9sPjWfOy+d195b7334
Mfwcf42/fwFkglHm
                 "], Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJw9lnk01YsWx48xY6aDwzk4vzM5xzw8paLfNyXzkIyl2+V2JU1ENymqExVx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                "], {{{
                   Hue[0.6, 0.7, 0.5], 
                   Opacity[0.7], 
                   Arrowheads[0.013102467270422408`], 
                   ArrowBox[
                    
                    BezierCurveBox[{1, 148, 151, 153, 159, 161, 164, 1}, 
                    SplineDegree -> 7], 0.08172557922900292], 
                   ArrowBox[{1, 2}, 0.08172557922900292], 
                   ArrowBox[{2, 3}, 0.08172557922900292], 
                   ArrowBox[{3, 4}, 0.08172557922900292], 
                   ArrowBox[{3, 5}, 0.08172557922900292], 
                   ArrowBox[{4, 5}, 0.08172557922900292], 
                   ArrowBox[{4, 6}, 0.08172557922900292], 
                   ArrowBox[{5, 7}, 0.08172557922900292], 
                   ArrowBox[{5, 8}, 0.08172557922900292], 
                   ArrowBox[{6, 10}, 0.08172557922900292], 
                   ArrowBox[{6, 11}, 0.08172557922900292], 
                   ArrowBox[{7, 6}, 0.08172557922900292], 
                   ArrowBox[{7, 9}, 0.08172557922900292], 
                   ArrowBox[{8, 13}, 0.08172557922900292], 
                   ArrowBox[{8, 14}, 0.08172557922900292], 
                   ArrowBox[{9, 16}, 0.08172557922900292], 
                   ArrowBox[{9, 17}, 0.08172557922900292], 
                   ArrowBox[{10, 8}, 0.08172557922900292], 
                   ArrowBox[{10, 12}, 0.08172557922900292], 
                   ArrowBox[{11, 19}, 0.08172557922900292], 
                   ArrowBox[{11, 20}, 0.08172557922900292], 
                   ArrowBox[{12, 22}, 0.08172557922900292], 
                   ArrowBox[{12, 23}, 0.08172557922900292], 
                   ArrowBox[{13, 9}, 0.08172557922900292], 
                   ArrowBox[{13, 15}, 0.08172557922900292], 
                   ArrowBox[{14, 25}, 0.08172557922900292], 
                   ArrowBox[{14, 26}, 0.08172557922900292], 
                   ArrowBox[{15, 28}, 0.08172557922900292], 
                   ArrowBox[{15, 29}, 0.08172557922900292], 
                   ArrowBox[{16, 11}, 0.08172557922900292], 
                   ArrowBox[{16, 18}, 0.08172557922900292], 
                   ArrowBox[{17, 31}, 0.08172557922900292], 
                   ArrowBox[{17, 32}, 0.08172557922900292], 
                   ArrowBox[{18, 34}, 0.08172557922900292], 
                   ArrowBox[{18, 35}, 0.08172557922900292], 
                   ArrowBox[{19, 12}, 0.08172557922900292], 
                   ArrowBox[{19, 21}, 0.08172557922900292], 
                   ArrowBox[{20, 37}, 0.08172557922900292], 
                   ArrowBox[{20, 38}, 0.08172557922900292], 
                   ArrowBox[{21, 40}, 0.08172557922900292], 
                   ArrowBox[{21, 41}, 0.08172557922900292], 
                   ArrowBox[{22, 14}, 0.08172557922900292], 
                   ArrowBox[{22, 24}, 0.08172557922900292], 
                   ArrowBox[{23, 43}, 0.08172557922900292], 
                   ArrowBox[{23, 44}, 0.08172557922900292], 
                   ArrowBox[{24, 46}, 0.08172557922900292], 
                   ArrowBox[{24, 47}, 0.08172557922900292], 
                   ArrowBox[{25, 15}, 0.08172557922900292], 
                   ArrowBox[{25, 27}, 0.08172557922900292], 
                   ArrowBox[{26, 49}, 0.08172557922900292], 
                   ArrowBox[{26, 50}, 0.08172557922900292], 
                   ArrowBox[{27, 52}, 0.08172557922900292], 
                   ArrowBox[{27, 53}, 0.08172557922900292], 
                   ArrowBox[{28, 17}, 0.08172557922900292], 
                   ArrowBox[{28, 30}, 0.08172557922900292], 
                   ArrowBox[{29, 55}, 0.08172557922900292], 
                   ArrowBox[{29, 56}, 0.08172557922900292], 
                   ArrowBox[{30, 58}, 0.08172557922900292], 
                   ArrowBox[{30, 59}, 0.08172557922900292], 
                   ArrowBox[{31, 18}, 0.08172557922900292], 
                   ArrowBox[{31, 33}, 0.08172557922900292], 
                   ArrowBox[{32, 61}, 0.08172557922900292], 
                   ArrowBox[{32, 62}, 0.08172557922900292], 
                   ArrowBox[{33, 64}, 0.08172557922900292], 
                   ArrowBox[{33, 65}, 0.08172557922900292], 
                   ArrowBox[{34, 20}, 0.08172557922900292], 
                   ArrowBox[{34, 36}, 0.08172557922900292], 
                   ArrowBox[{35, 67}, 0.08172557922900292], 
                   ArrowBox[{35, 68}, 0.08172557922900292], 
                   ArrowBox[{36, 70}, 0.08172557922900292], 
                   ArrowBox[{36, 71}, 0.08172557922900292], 
                   ArrowBox[{37, 21}, 0.08172557922900292], 
                   ArrowBox[{37, 39}, 0.08172557922900292], 
                   ArrowBox[{38, 72}, 0.08172557922900292], 
                   ArrowBox[{38, 73}, 0.08172557922900292], 
                   ArrowBox[{39, 75}, 0.08172557922900292], 
                   ArrowBox[{39, 76}, 0.08172557922900292], 
                   ArrowBox[{40, 23}, 0.08172557922900292], 
                   ArrowBox[{40, 42}, 0.08172557922900292], 
                   ArrowBox[{41, 78}, 0.08172557922900292], 
                   ArrowBox[{41, 79}, 0.08172557922900292], 
                   ArrowBox[{42, 81}, 0.08172557922900292], 
                   ArrowBox[{42, 82}, 0.08172557922900292], 
                   ArrowBox[{43, 24}, 0.08172557922900292], 
                   ArrowBox[{43, 45}, 0.08172557922900292], 
                   ArrowBox[{44, 83}, 0.08172557922900292], 
                   ArrowBox[{44, 84}, 0.08172557922900292], 
                   ArrowBox[{45, 86}, 0.08172557922900292], 
                   ArrowBox[{45, 87}, 0.08172557922900292], 
                   ArrowBox[{46, 26}, 0.08172557922900292], 
                   ArrowBox[{46, 48}, 0.08172557922900292], 
                   ArrowBox[{47, 88}, 0.08172557922900292], 
                   ArrowBox[{47, 89}, 0.08172557922900292], 
                   ArrowBox[{49, 27}, 0.08172557922900292], 
                   ArrowBox[{49, 51}, 0.08172557922900292], 
                   ArrowBox[{50, 90}, 0.08172557922900292], 
                   ArrowBox[{50, 91}, 0.08172557922900292], 
                   ArrowBox[{51, 93}, 0.08172557922900292], 
                   ArrowBox[{51, 94}, 0.08172557922900292], 
                   ArrowBox[{52, 29}, 0.08172557922900292], 
                   ArrowBox[{52, 54}, 0.08172557922900292], 
                   ArrowBox[{53, 96}, 0.08172557922900292], 
                   ArrowBox[{53, 97}, 0.08172557922900292], 
                   ArrowBox[{54, 99}, 0.08172557922900292], 
                   ArrowBox[{54, 100}, 0.08172557922900292], 
                   ArrowBox[{55, 30}, 0.08172557922900292], 
                   ArrowBox[{55, 57}, 0.08172557922900292], 
                   ArrowBox[{56, 101}, 0.08172557922900292], 
                   ArrowBox[{56, 102}, 0.08172557922900292], 
                   ArrowBox[{57, 104}, 0.08172557922900292], 
                   ArrowBox[{57, 105}, 0.08172557922900292], 
                   ArrowBox[{58, 32}, 0.08172557922900292], 
                   ArrowBox[{58, 60}, 0.08172557922900292], 
                   ArrowBox[{59, 106}, 0.08172557922900292], 
                   ArrowBox[{59, 107}, 0.08172557922900292], 
                   ArrowBox[{61, 33}, 0.08172557922900292], 
                   ArrowBox[{61, 63}, 0.08172557922900292], 
                   ArrowBox[{62, 108}, 0.08172557922900292], 
                   ArrowBox[{62, 109}, 0.08172557922900292], 
                   ArrowBox[{63, 111}, 0.08172557922900292], 
                   ArrowBox[{63, 112}, 0.08172557922900292], 
                   ArrowBox[{64, 35}, 0.08172557922900292], 
                   ArrowBox[{64, 66}, 0.08172557922900292], 
                   ArrowBox[{65, 113}, 0.08172557922900292], 
                   ArrowBox[{65, 114}, 0.08172557922900292], 
                   ArrowBox[{67, 36}, 0.08172557922900292], 
                   ArrowBox[{67, 69}, 0.08172557922900292], 
                   ArrowBox[{68, 115}, 0.08172557922900292], 
                   ArrowBox[{68, 116}, 0.08172557922900292], 
                   ArrowBox[{72, 39}, 0.08172557922900292], 
                   ArrowBox[{72, 74}, 0.08172557922900292], 
                   ArrowBox[{73, 117}, 0.08172557922900292], 
                   ArrowBox[{73, 118}, 0.08172557922900292], 
                   ArrowBox[{74, 120}, 0.08172557922900292], 
                   ArrowBox[{74, 121}, 0.08172557922900292], 
                   ArrowBox[{75, 41}, 0.08172557922900292], 
                   ArrowBox[{75, 77}, 0.08172557922900292], 
                   ArrowBox[{76, 122}, 0.08172557922900292], 
                   ArrowBox[{76, 123}, 0.08172557922900292], 
                   ArrowBox[{78, 42}, 0.08172557922900292], 
                   ArrowBox[{78, 80}, 0.08172557922900292], 
                   ArrowBox[{79, 124}, 0.08172557922900292], 
                   ArrowBox[{79, 125}, 0.08172557922900292], 
                   ArrowBox[{83, 45}, 0.08172557922900292], 
                   ArrowBox[{83, 85}, 0.08172557922900292], 
                   ArrowBox[{84, 126}, 0.08172557922900292], 
                   ArrowBox[{84, 127}, 0.08172557922900292], 
                   ArrowBox[{90, 51}, 0.08172557922900292], 
                   ArrowBox[{90, 92}, 0.08172557922900292], 
                   ArrowBox[{91, 128}, 0.08172557922900292], 
                   ArrowBox[{91, 129}, 0.08172557922900292], 
                   ArrowBox[{92, 131}, 0.08172557922900292], 
                   ArrowBox[{92, 132}, 0.08172557922900292], 
                   ArrowBox[{93, 53}, 0.08172557922900292], 
                   ArrowBox[{93, 95}, 0.08172557922900292], 
                   ArrowBox[{94, 133}, 0.08172557922900292], 
                   ArrowBox[{94, 134}, 0.08172557922900292], 
                   ArrowBox[{96, 54}, 0.08172557922900292], 
                   ArrowBox[{96, 98}, 0.08172557922900292], 
                   ArrowBox[{97, 135}, 0.08172557922900292], 
                   ArrowBox[{97, 136}, 0.08172557922900292], 
                   ArrowBox[{101, 57}, 0.08172557922900292], 
                   ArrowBox[{101, 103}, 0.08172557922900292], 
                   ArrowBox[{102, 137}, 0.08172557922900292], 
                   ArrowBox[{102, 138}, 0.08172557922900292], 
                   ArrowBox[{108, 63}, 0.08172557922900292], 
                   ArrowBox[{108, 110}, 0.08172557922900292], 
                   ArrowBox[{109, 139}, 0.08172557922900292], 
                   ArrowBox[{109, 140}, 0.08172557922900292], 
                   ArrowBox[{117, 74}, 0.08172557922900292], 
                   ArrowBox[{117, 119}, 0.08172557922900292], 
                   ArrowBox[{118, 141}, 0.08172557922900292], 
                   ArrowBox[{118, 142}, 0.08172557922900292], 
                   ArrowBox[{128, 92}, 0.08172557922900292], 
                   ArrowBox[{128, 130}, 0.08172557922900292], 
                   ArrowBox[{129, 143}, 0.08172557922900292], 
                   ArrowBox[{129, 144}, 0.08172557922900292]}}, {{
                   Hue[0.6, 0.2, 0.8], 
                   EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                   DiskBox[1, 0.08172557922900292], 
                   DiskBox[2, 0.08172557922900292], 
                   DiskBox[3, 0.08172557922900292], 
                   DiskBox[4, 0.08172557922900292], 
                   DiskBox[5, 0.08172557922900292], 
                   DiskBox[6, 0.08172557922900292], 
                   DiskBox[7, 0.08172557922900292], 
                   DiskBox[8, 0.08172557922900292], 
                   DiskBox[9, 0.08172557922900292], 
                   DiskBox[10, 0.08172557922900292], 
                   DiskBox[11, 0.08172557922900292], 
                   DiskBox[12, 0.08172557922900292], 
                   DiskBox[13, 0.08172557922900292], 
                   DiskBox[14, 0.08172557922900292], 
                   DiskBox[15, 0.08172557922900292], 
                   DiskBox[16, 0.08172557922900292], 
                   DiskBox[17, 0.08172557922900292], 
                   DiskBox[18, 0.08172557922900292], 
                   DiskBox[19, 0.08172557922900292], 
                   DiskBox[20, 0.08172557922900292], 
                   DiskBox[21, 0.08172557922900292], 
                   DiskBox[22, 0.08172557922900292], 
                   DiskBox[23, 0.08172557922900292], 
                   DiskBox[24, 0.08172557922900292], 
                   DiskBox[25, 0.08172557922900292], 
                   DiskBox[26, 0.08172557922900292], 
                   DiskBox[27, 0.08172557922900292], 
                   DiskBox[28, 0.08172557922900292], 
                   DiskBox[29, 0.08172557922900292], 
                   DiskBox[30, 0.08172557922900292], 
                   DiskBox[31, 0.08172557922900292], 
                   DiskBox[32, 0.08172557922900292], 
                   DiskBox[33, 0.08172557922900292], 
                   DiskBox[34, 0.08172557922900292], 
                   DiskBox[35, 0.08172557922900292], 
                   DiskBox[36, 0.08172557922900292], 
                   DiskBox[37, 0.08172557922900292], 
                   DiskBox[38, 0.08172557922900292], 
                   DiskBox[39, 0.08172557922900292], 
                   DiskBox[40, 0.08172557922900292], 
                   DiskBox[41, 0.08172557922900292], 
                   DiskBox[42, 0.08172557922900292], 
                   DiskBox[43, 0.08172557922900292], 
                   DiskBox[44, 0.08172557922900292], 
                   DiskBox[45, 0.08172557922900292], 
                   DiskBox[46, 0.08172557922900292], 
                   DiskBox[47, 0.08172557922900292], 
                   DiskBox[48, 0.08172557922900292], 
                   DiskBox[49, 0.08172557922900292], 
                   DiskBox[50, 0.08172557922900292], 
                   DiskBox[51, 0.08172557922900292], 
                   DiskBox[52, 0.08172557922900292], 
                   DiskBox[53, 0.08172557922900292], 
                   DiskBox[54, 0.08172557922900292], 
                   DiskBox[55, 0.08172557922900292], 
                   DiskBox[56, 0.08172557922900292], 
                   DiskBox[57, 0.08172557922900292], 
                   DiskBox[58, 0.08172557922900292], 
                   DiskBox[59, 0.08172557922900292], 
                   DiskBox[60, 0.08172557922900292], 
                   DiskBox[61, 0.08172557922900292], 
                   DiskBox[62, 0.08172557922900292], 
                   DiskBox[63, 0.08172557922900292], 
                   DiskBox[64, 0.08172557922900292], 
                   DiskBox[65, 0.08172557922900292], 
                   DiskBox[66, 0.08172557922900292], 
                   DiskBox[67, 0.08172557922900292], 
                   DiskBox[68, 0.08172557922900292], 
                   DiskBox[69, 0.08172557922900292], 
                   DiskBox[70, 0.08172557922900292], 
                   DiskBox[71, 0.08172557922900292], 
                   DiskBox[72, 0.08172557922900292], 
                   DiskBox[73, 0.08172557922900292], 
                   DiskBox[74, 0.08172557922900292], 
                   DiskBox[75, 0.08172557922900292], 
                   DiskBox[76, 0.08172557922900292], 
                   DiskBox[77, 0.08172557922900292], 
                   DiskBox[78, 0.08172557922900292], 
                   DiskBox[79, 0.08172557922900292], 
                   DiskBox[80, 0.08172557922900292], 
                   DiskBox[81, 0.08172557922900292], 
                   DiskBox[82, 0.08172557922900292], 
                   DiskBox[83, 0.08172557922900292], 
                   DiskBox[84, 0.08172557922900292], 
                   DiskBox[85, 0.08172557922900292], 
                   DiskBox[86, 0.08172557922900292], 
                   DiskBox[87, 0.08172557922900292], 
                   DiskBox[88, 0.08172557922900292], 
                   DiskBox[89, 0.08172557922900292], 
                   DiskBox[90, 0.08172557922900292], 
                   DiskBox[91, 0.08172557922900292], 
                   DiskBox[92, 0.08172557922900292], 
                   DiskBox[93, 0.08172557922900292], 
                   DiskBox[94, 0.08172557922900292], 
                   DiskBox[95, 0.08172557922900292], 
                   DiskBox[96, 0.08172557922900292], 
                   DiskBox[97, 0.08172557922900292], 
                   DiskBox[98, 0.08172557922900292], 
                   DiskBox[99, 0.08172557922900292], 
                   DiskBox[100, 0.08172557922900292], 
                   DiskBox[101, 0.08172557922900292], 
                   DiskBox[102, 0.08172557922900292], 
                   DiskBox[103, 0.08172557922900292], 
                   DiskBox[104, 0.08172557922900292], 
                   DiskBox[105, 0.08172557922900292], 
                   DiskBox[106, 0.08172557922900292], 
                   DiskBox[107, 0.08172557922900292], 
                   DiskBox[108, 0.08172557922900292], 
                   DiskBox[109, 0.08172557922900292], 
                   DiskBox[110, 0.08172557922900292], 
                   DiskBox[111, 0.08172557922900292], 
                   DiskBox[112, 0.08172557922900292], 
                   DiskBox[113, 0.08172557922900292], 
                   DiskBox[114, 0.08172557922900292], 
                   DiskBox[115, 0.08172557922900292], 
                   DiskBox[116, 0.08172557922900292], 
                   DiskBox[117, 0.08172557922900292], 
                   DiskBox[118, 0.08172557922900292], 
                   DiskBox[119, 0.08172557922900292], 
                   DiskBox[120, 0.08172557922900292], 
                   DiskBox[121, 0.08172557922900292], 
                   DiskBox[122, 0.08172557922900292], 
                   DiskBox[123, 0.08172557922900292], 
                   DiskBox[124, 0.08172557922900292], 
                   DiskBox[125, 0.08172557922900292], 
                   DiskBox[126, 0.08172557922900292], 
                   DiskBox[127, 0.08172557922900292], 
                   DiskBox[128, 0.08172557922900292], 
                   DiskBox[129, 0.08172557922900292], 
                   DiskBox[130, 0.08172557922900292], 
                   DiskBox[131, 0.08172557922900292], 
                   DiskBox[132, 0.08172557922900292], 
                   DiskBox[133, 0.08172557922900292], 
                   DiskBox[134, 0.08172557922900292], 
                   DiskBox[135, 0.08172557922900292], 
                   DiskBox[136, 0.08172557922900292], 
                   DiskBox[137, 0.08172557922900292], 
                   DiskBox[138, 0.08172557922900292], 
                   DiskBox[139, 0.08172557922900292], 
                   DiskBox[140, 0.08172557922900292], 
                   DiskBox[141, 0.08172557922900292], 
                   DiskBox[142, 0.08172557922900292], 
                   DiskBox[143, 0.08172557922900292], 
                   DiskBox[144, 0.08172557922900292]}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {513.98828125, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1454ac46-cce3-4cda-8a5f-4061e0ec9fff"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a graph obtained by nestedly finding bordering countries starting \
from the United States, and going 4 iterations.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f985856d-76f4-4eff-96d2-81fe9e8e7f40"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           Graph[{
             Entity["Country", "Belize"], 
             Entity["Country", "Guatemala"], 
             Entity["Country", "Mexico"], 
             Entity["Country", "Canada"], 
             Entity["Country", "UnitedStates"], 
             Entity["Country", "ElSalvador"], 
             Entity["Country", "Honduras"], 
             Entity["Country", "Nicaragua"]}, {{{1, 2}, {1, 3}, {4, 5}, {6, 
             2}, {6, 7}, {2, 1}, {2, 6}, {2, 7}, {2, 3}, {7, 6}, {7, 2}, {7, 
             8}, {3, 1}, {3, 2}, {3, 5}, {5, 4}, {5, 3}}, Null}, {
            VertexLabels -> {All}}]]}, 
          TagBox[GraphicsGroupBox[{
             {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
              ArrowBox[BezierCurveBox[{{2.868617049063046, 
               1.0332920479861112`}, {2.6179624384830364`, 
               0.6680721046713326}, {2.1994579473463247`, 
               0.5229262066968019}}], 0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{2.868617049063046, 
               1.0332920479861112`}, {3.239790754947349, 
               0.8979195576905811}, {3.458155209017822, 0.5686588763681983}}],
                0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{2.1994579473463247`, 
               0.5229262066968019}, {2.450112557926333, 0.8881461500111837}, {
               2.868617049063046, 1.0332920479861112`}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{2.1994579473463247`, 
               0.5229262066968019}, {2.821286263810628, 0.7527736597188819}, {
               3.458155209017822, 0.5686588763681983}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{2.1994579473463247`, 
               0.5229262066968019}, {1.9241317412736838`, 
               0.14263276584747045`}, {1.4768247828993246`, 0.}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{2.1994579473463247`, 
               0.5229262066968019}, {1.599843212373542, 0.3362203733850594}, {
               1.0064587113712156`, 0.5418699115788738}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{3.458155209017822, 
               0.5686588763681983}, {3.0869815031335164`, 
               0.7040313666595726}, {2.868617049063046, 
               1.0332920479861112`}}], 0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{3.458155209017822, 
               0.5686588763681983}, {2.836326892553523, 0.3388114233458691}, {
               2.1994579473463247`, 0.5229262066968019}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{3.458155209017822, 
               0.5686588763681983}, {4.072154197155293, 0.7274099824547237}, {
               4.660522129215408, 0.4907248590506733}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{5.628783515977089, 
               0.4358630413460338}, {5.135631304301088, 0.3040723242911214}, {
               4.660522129215408, 0.4907248590506733}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{4.660522129215408, 
               0.4907248590506733}, {4.046523141077941, 0.331973752964375}, {
               3.458155209017822, 0.5686588763681983}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{4.660522129215408, 
               0.4907248590506733}, {5.153674340891408, 0.6225155761065558}, {
               5.628783515977089, 0.4358630413460338}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{1.4768247828993246`, 0.}, {
               1.7521509889719706`, 0.38029344084924843`}, {
               2.1994579473463247`, 0.5229262066968019}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{1.4768247828993246`, 0.}, {
               1.1525362539991915`, 0.19358760753771034`}, {
               1.0064587113712156`, 0.5418699115788738}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{1.0064587113712156`, 
               0.5418699115788738}, {1.606073446343994, 0.7285757448902874}, {
               2.1994579473463247`, 0.5229262066968019}}], 
               0.046527373367971706`], 
              ArrowBox[BezierCurveBox[{{1.0064587113712156`, 
               0.5418699115788738}, {1.33074724027135, 
               0.34828230404112825`}, {1.4768247828993246`, 0.}}], 
               0.046527373367971706`], 
              ArrowBox[{{1.0064587113712156`, 0.5418699115788738}, {0., 
               0.6760346660095937}}, 0.046527373367971706`]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
              0.7]}], {
               DiskBox[{2.868617049063046, 1.0332920479861112}, 
                0.046527373367971706], InsetBox[
                InterpretationBox["\<\"Belize\"\>",
                 Entity["Country", "Belize"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {2.915144422431018, 1.0798194213540828}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{2.1994579473463247, 0.5229262066968019}, 
                0.046527373367971706], InsetBox[
                InterpretationBox["\<\"Guatemala\"\>",
                 Entity["Country", "Guatemala"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {2.2459853207142966, 0.5694535800647736}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.458155209017822, 0.5686588763681983}, 
                0.046527373367971706], InsetBox[
                InterpretationBox["\<\"Mexico\"\>",
                 Entity["Country", "Mexico"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {3.5046825823857937, 0.6151862497361701}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.628783515977089, 0.4358630413460338}, 
                0.046527373367971706], InsetBox[
                InterpretationBox["\<\"Canada\"\>",
                 Entity["Country", "Canada"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {5.67531088934506, 0.4823904147140055}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.660522129215408, 0.4907248590506733}, 
                0.046527373367971706], InsetBox[
                InterpretationBox["\<\"United States\"\>",
                 Entity["Country", "UnitedStates"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {4.70704950258338, 0.5372522324186451}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.4768247828993246, 0.}, 0.046527373367971706], 
               InsetBox[
                InterpretationBox["\<\"El Salvador\"\>",
                 Entity["Country", "ElSalvador"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {1.5233521562672963, 0.046527373367971706}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.0064587113712156, 0.5418699115788738}, 
                0.046527373367971706], InsetBox[
                InterpretationBox["\<\"Honduras\"\>",
                 Entity["Country", "Honduras"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {1.0529860847391872, 0.5883972849468455}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0., 0.6760346660095937}, 0.046527373367971706], 
               InsetBox[
                InterpretationBox["\<\"Nicaragua\"\>",
                 Entity["Country", "Nicaragua"],
                 BaseStyle->"Entity"], 
                Offset[{2, 2}, {0.046527373367971706, 0.7225620393775655}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}}}],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{575.36328125, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"d7514c5a-d4bf-43fb-bb38-456ac59f83c2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               Graph[{
                 Entity["Country", "Belize"], 
                 Entity["Country", "Guatemala"], 
                 Entity["Country", "Mexico"], 
                 Entity["Country", "Canada"], 
                 Entity["Country", "UnitedStates"], 
                 Entity["Country", "ElSalvador"], 
                 Entity["Country", "Honduras"], 
                 Entity["Country", "Nicaragua"]}, {{{1, 2}, {1, 3}, {4, 5}, {
                 6, 2}, {6, 7}, {2, 1}, {2, 6}, {2, 7}, {2, 3}, {7, 6}, {7, 
                 2}, {7, 8}, {3, 1}, {3, 2}, {3, 5}, {5, 4}, {5, 3}}, Null}, {
                VertexLabels -> {All}}]]}, 
            TagBox[
             GraphicsGroupBox[{{{
                 Hue[0.6, 0.7, 0.5], 
                 Opacity[0.7], 
                 Arrowheads[Medium], 
                 ArrowBox[
                  
                  BezierCurveBox[{{2.868617049063046, 1.0332920479861112`}, {
                   2.6179624384830364`, 0.6680721046713326}, {
                   2.1994579473463247`, 0.5229262066968019}}], 
                  0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{2.868617049063046, 1.0332920479861112`}, {
                   3.239790754947349, 0.8979195576905811}, {3.458155209017822,
                    0.5686588763681983}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{2.1994579473463247`, 0.5229262066968019}, {
                   2.450112557926333, 0.8881461500111837}, {2.868617049063046,
                    1.0332920479861112`}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{2.1994579473463247`, 0.5229262066968019}, {
                   2.821286263810628, 0.7527736597188819}, {3.458155209017822,
                    0.5686588763681983}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{2.1994579473463247`, 0.5229262066968019}, {
                   1.9241317412736838`, 0.14263276584747045`}, {
                   1.4768247828993246`, 0.}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{2.1994579473463247`, 0.5229262066968019}, {
                   1.599843212373542, 0.3362203733850594}, {
                   1.0064587113712156`, 0.5418699115788738}}], 
                  0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{3.458155209017822, 0.5686588763681983}, {
                   3.0869815031335164`, 0.7040313666595726}, {
                   2.868617049063046, 1.0332920479861112`}}], 
                  0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{3.458155209017822, 0.5686588763681983}, {
                   2.836326892553523, 0.3388114233458691}, {
                   2.1994579473463247`, 0.5229262066968019}}], 
                  0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{3.458155209017822, 0.5686588763681983}, {
                   4.072154197155293, 0.7274099824547237}, {4.660522129215408,
                    0.4907248590506733}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{5.628783515977089, 0.4358630413460338}, {
                   5.135631304301088, 0.3040723242911214}, {4.660522129215408,
                    0.4907248590506733}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{4.660522129215408, 0.4907248590506733}, {
                   4.046523141077941, 0.331973752964375}, {3.458155209017822, 
                   0.5686588763681983}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{4.660522129215408, 0.4907248590506733}, {
                   5.153674340891408, 0.6225155761065558}, {5.628783515977089,
                    0.4358630413460338}}], 0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{1.4768247828993246`, 0.}, {
                   1.7521509889719706`, 0.38029344084924843`}, {
                   2.1994579473463247`, 0.5229262066968019}}], 
                  0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{1.4768247828993246`, 0.}, {
                   1.1525362539991915`, 0.19358760753771034`}, {
                   1.0064587113712156`, 0.5418699115788738}}], 
                  0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{1.0064587113712156`, 0.5418699115788738}, {
                   1.606073446343994, 0.7285757448902874}, {
                   2.1994579473463247`, 0.5229262066968019}}], 
                  0.046527373367971706`], 
                 ArrowBox[
                  
                  BezierCurveBox[{{1.0064587113712156`, 0.5418699115788738}, {
                   1.33074724027135, 0.34828230404112825`}, {
                   1.4768247828993246`, 0.}}], 0.046527373367971706`], 
                 
                 ArrowBox[{{1.0064587113712156`, 0.5418699115788738}, {0., 
                  0.6760346660095937}}, 0.046527373367971706`]}}, {{
                 Hue[0.6, 0.2, 0.8], 
                 EdgeForm[{
                   GrayLevel[0], 
                   Opacity[0.7]}], {
                  
                  DiskBox[{2.868617049063046, 1.0332920479861112`}, 
                   0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"Belize\"", 
                    Entity["Country", "Belize"], BaseStyle -> "Entity"], 
                   Offset[{2, 2}, {2.915144422431018, 1.0798194213540828`}], 
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                  
                  DiskBox[{2.1994579473463247`, 0.5229262066968019}, 
                   0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"Guatemala\"", 
                    Entity["Country", "Guatemala"], BaseStyle -> "Entity"], 
                   Offset[{2, 2}, {2.2459853207142966`, 0.5694535800647736}], 
                   
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                  
                  DiskBox[{3.458155209017822, 0.5686588763681983}, 
                   0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"Mexico\"", 
                    Entity["Country", "Mexico"], BaseStyle -> "Entity"], 
                   Offset[{2, 2}, {3.5046825823857937`, 0.6151862497361701}], 
                   
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                  
                  DiskBox[{5.628783515977089, 0.4358630413460338}, 
                   0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"Canada\"", 
                    Entity["Country", "Canada"], BaseStyle -> "Entity"], 
                   Offset[{2, 2}, {5.67531088934506, 0.4823904147140055}], 
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                  
                  DiskBox[{4.660522129215408, 0.4907248590506733}, 
                   0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"United States\"", 
                    Entity["Country", "UnitedStates"], BaseStyle -> "Entity"], 
                   Offset[{2, 2}, {4.70704950258338, 0.5372522324186451}], 
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                  DiskBox[{1.4768247828993246`, 0.}, 0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"El Salvador\"", 
                    Entity["Country", "ElSalvador"], BaseStyle -> "Entity"], 
                   
                   Offset[{2, 2}, {1.5233521562672963`, 
                    0.046527373367971706`}], 
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                  
                  DiskBox[{1.0064587113712156`, 0.5418699115788738}, 
                   0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"Honduras\"", 
                    Entity["Country", "Honduras"], BaseStyle -> "Entity"], 
                   Offset[{2, 2}, {1.0529860847391872`, 0.5883972849468455}], 
                   
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                  DiskBox[{0., 0.6760346660095937}, 0.046527373367971706`], 
                  InsetBox[
                   InterpretationBox["\"Nicaragua\"", 
                    Entity["Country", "Nicaragua"], BaseStyle -> "Entity"], 
                   
                   Offset[{2, 2}, {0.046527373367971706`, 
                    0.7225620393775655}], 
                   ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}}}}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {575.36328125, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a1ec8f30-e7a1-4603-ab06-eab7585648f7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of 100 iterations of ",
 StyleBox["linear congruential function",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Mod",
     BaseStyle->"CodeLink"], "[", 
    RowBox[{
     RowBox[{"59", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"]}], ",", "101"}], "]"}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCode",ExpressionUUID->
  "27d74344-b4e9-49f7-be32-053df3c23f88"],
 ", starting from 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a8f143c0-38a8-46af-91af-7a9de64fbd0f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxllLlOQzEQRS0qSgoKCgqIEEIIISDsW5ywhR0CBGiRqPkFf5o/KZ/A8s6x
FBMpObrx87Nn5s7Mf3wNPidCCJ8/3182n1FnnCH+/abbhmESfYGeguppOIQz
PH+KnoVvcK5iCz7ChYZxgF5EP6CXeL/vW4Z7cIX1O/QqdP8a6yfo9Yb5Cb1R
7WtzvuubPO/5W/AFbkPj3oEtuAv3q3u3q//JQzjgfN9/yP2N5wjewGNo/jqQ
uoTI/kuIDs+wy//sT90qjh48Zx2drZ957bOu1jf6wnPQ2fjO0NwnoVO/Ovce
oqP315fGiU7ez3sNq/fqd/ISXUeHd3g1fs+kvh5nqlh8ap3wZ1LbR9wjvrKO
LnXS1/pA3YPkpfStWv/qG/JuX1nH4iv2ZbW+Jo+JekXziq9LnpkjxRf0mb5M
xFf63HjRuWKyvsSRqU/pS/sarW/ta31SfE7f6Jvs+a5Td334r8+rviznqqlr
8bV9qa/wjT6LzBN9ad6N07lmnpxT+kRfmlf70LicW85h6+a5zokyV5m7zjn7
sPQBcziqR51vktKXSw==
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 101.}, {0, 100.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "07ff4e21-9af1-4757-b2a9-01c50583302d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxllLlOQzEQRS0qSgoKCgqIEEIIISDsW5ywhR0CBGiRqPkFf5o/KZ/A8s6x
FBMpObrx87Nn5s7Mf3wNPidCCJ8/3182n1FnnCH+/abbhmESfYGeguppOIQz
PH+KnoVvcK5iCz7ChYZxgF5EP6CXeL/vW4Z7cIX1O/QqdP8a6yfo9Yb5Cb1R
7WtzvuubPO/5W/AFbkPj3oEtuAv3q3u3q//JQzjgfN9/yP2N5wjewGNo/jqQ
uoTI/kuIDs+wy//sT90qjh48Zx2drZ957bOu1jf6wnPQ2fjO0NwnoVO/Ovce
oqP315fGiU7ez3sNq/fqd/ISXUeHd3g1fs+kvh5nqlh8ap3wZ1LbR9wjvrKO
LnXS1/pA3YPkpfStWv/qG/JuX1nH4iv2ZbW+Jo+JekXziq9LnpkjxRf0mb5M
xFf63HjRuWKyvsSRqU/pS/sarW/ta31SfE7f6Jvs+a5Td334r8+rviznqqlr
8bV9qa/wjT6LzBN9ad6N07lmnpxT+kRfmlf70LicW85h6+a5zokyV5m7zjn7
sPQBcziqR51vktKXSw==
               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 101.}, {0, 100.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"40ec1190-bbda-4461-979c-dcc11be55d17"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a list of 5 ",
 StyleBox["power towers",
  FontSlant->"Italic"],
 " of 2, i.e. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", 
     RowBox[{"2", "^", "2"}]}], "..."}], "^", "2"}]], "InlineCode",
  ExpressionUUID->"746e9652-57e1-433a-b080-f7033b5f1f79"],
 " ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "6d375ded-03b8-435c-a2ba-dd73b19bcd03"],
 " times, with ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "153f7711-ffb3-4b04-af43-6a0f3c928cda"],
 " from 0 to 4.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5acbf216-cddc-4a02-a1af-67aa21d653d0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "16", ",", "65536"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "dfa9afd5-54e7-40be-bf5d-5724ffe8b49e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "4", ",", "16", ",", "65536"}], "}"}]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cff36563-4b0a-4107-bd17-7c9d699c3151"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a list of 20 ",
 StyleBox["power towers",
  FontSlant->"Italic"],
 " of 1.2, i.e. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"1.2", "^", 
     RowBox[{"1.2", "^"}]}], "..."}], "^", "1.2"}]], "InlineCode",
  ExpressionUUID->"9be81bab-629d-46aa-8725-816a065534ff"],
 " ",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "4577671d-8c00-41f0-ba02-6d88633fb078"],
 " times, with ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "9ead7923-4505-4df2-a063-782963032555"],
 " from 0 to 19.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4437feed-ea8b-4337-9096-d262963164d0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1.2`", ",", "1.2445647472039776`", ",", 
         "1.2547181707692288`", ",", "1.257043041201492`", ",", 
         "1.257575982001101`", ",", "1.2576981823156133`", ",", 
         "1.257726203830836`", ",", "1.257732629477705`", ",", 
         "1.2577341029550315`", ",", "1.2577344408411681`", ",", 
         "1.2577345183225506`", ",", "1.2577345360899703`", ",", 
         "1.257734540164255`", ",", "1.2577345410985379`", ",", 
         "1.2577345413127803`", ",", "1.2577345413619085`", ",", 
         "1.2577345413731742`", ",", "1.2577345413757577`", ",", 
         "1.25773454137635`"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "ed5fb707-7604-4dbe-aff6-cd079ecd10b3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "1.2`", ",", "1.2445647472039776`", ",", 
             "1.2547181707692288`", ",", "1.257043041201492`", ",", 
             "1.257575982001101`", ",", "1.2576981823156133`", ",", 
             "1.257726203830836`", ",", "1.257732629477705`", ",", 
             "1.2577341029550315`", ",", "1.2577344408411681`", ",", 
             "1.2577345183225506`", ",", "1.2577345360899703`", ",", 
             "1.257734540164255`", ",", "1.2577345410985379`", ",", 
             "1.2577345413127803`", ",", "1.2577345413619085`", ",", 
             "1.2577345413731742`", ",", "1.2577345413757577`", ",", 
             "1.25773454137635`"}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cafd85e6-3e17-48d2-88bf-4a16c4c4211c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a list of the numerical values obtained by up to 10 nestings of \
the function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"CodeLink"], "[", 
    RowBox[{"1", 
     ButtonBox["+",
      BaseStyle->"Link",
      ButtonData->"Plus"], 
     ButtonBox["#",
      BaseStyle->"Link",
      ButtonData->"Slot"]}], "]"}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCode",ExpressionUUID->
  "3fa72e0d-8237-4d3f-89ce-a3cfd5c143e1"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4312ee74-73b1-4815-bb18-e119effcc855"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1.`", ",", "1.4142135623730951`", ",", "1.5537739740300374`", ",", 
         "1.5980531824786175`", ",", "1.6118477541252516`", ",", 
         "1.616121206508117`", ",", "1.6174427985273905`", ",", 
         "1.617851290609675`", ",", "1.6179775309347393`", ",", 
         "1.6180165422314876`", ",", "1.6180285974702324`"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "6c0cbd5c-28e9-43fd-82c8-1eddbce4f1ec"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1.`", ",", "1.4142135623730951`", ",", 
             "1.5537739740300374`", ",", "1.5980531824786175`", ",", 
             "1.6118477541252516`", ",", "1.616121206508117`", ",", 
             "1.6174427985273905`", ",", "1.617851290609675`", ",", 
             "1.6179775309347393`", ",", "1.6180165422314876`", ",", 
             "1.6180285974702324`"}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7f98d014-e758-4b88-a5a3-a9b46639b7de"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make graphics of a 1000-step 3D random walk which starts at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "6c99385a-3cc6-4415-b48f-6fb5f8b0c822"],
 ", and in which at each step a triple of random numbers between \[Minus]1 \
and +1 are added to the coordinates.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3d755c28-577a-4d6b-9164-4b90f4f4bd4a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       Graphics3DBox[Line3DBox[CompressedData["
1:eJx0Wfk/1N//te/7YAaDGfuMvaRIXjcJbd5ChZQSkixZEiWhSFIUISlLogVF
JWV5PUn2bFEI2bIlW/b1M98/4DuP+ek+7tzlec7z3HMeQ3X0snRmYWJiGmNl
YmJ8/99P0ocDpw+1duDvrGXdZTpGMHTB5Ju1ayEWovFYK4gpHuc6I78k9eMf
Bmd/7ptw+YmHVBrOpp5Iwht3vUF5o+sYJHv2+9a/wl0bRRCW8wPLO/s4Jjt9
HXOtOLj2ljCEN2+9cJF8tAVrOqv6mxbKgpiSnhgOkjrwtqUnIUqJI1jYXiwq
NnoNm2bRfbNG6MEUVLu2uZktYAWGBs9eerCj0QMG8xSODuxzL3578SYLGn7h
aty6dxULEVwqPVXzFHNyfXj+gcM6FiYh7RR/ewVDGQvf6v4rxarCr57hjZzB
Iqru/1B1XMRCXE4+lo/ux9N+1U3s+DqBKYx9/FV9fx6jKO1O8wkvxtcilBan
DDYwhVQi09PsRYwp4Z+PU2cR9pGY/U4xkANVW1bNM29nQRSr02oGVwexHYVl
kx53OJFu+psUkhkrCvh9UYSL6wdWRHnulj7AgSL74qMvNi1gQSXxFbsMBvH4
ucC0PytsKIgzrkzy6STWnFR0u+f7VzwwptEk5zwveh7768j11n5sGkIlEktb
sQtjzdN7XTiQj4bYjPr7BYzpus2DftVkrODY0yvRz5kRN++3/Vt6WBCq6L8c
7FKI3YrmrW1qZ0M78DfOZypWsKJnzAGND8ZwE7bdx/FLLMi+rX+rvP80Fu/Q
npYwM4hbkqP2JT5hQiHRseHDzd+w4aWv/omXF/BTfWVk6pkVrHkIGzNqHcZO
Ru05UJC0ju9gxc9Vio9h9o8n/LkeLGDjdReOupnP4EKLefGtE/8w+6xvLZqn
RzBjx5N7Po7045SEI/wFSiOY9Zg3LV18BTsV9l4oX64Pd/Ul7VHKWMD6dNRS
P0WzIHL/q8OZhcN4hwdu17znHxZ5t+fOnD47cl/9m3fCewqPPaDpLuS5gLku
xihRm9jQ+NUrG+kvN/ACe5ZyC8bv54ccwiajeJDafyWfx5uZYKsU/marNzuy
lOhpdv7HjXQmStxzZOfxW89TCAeecKDs+C5zl1J+xMZZUnWQMIM/6zvH3ujD
hyKkfk+mOXMjXeXcT/N6//AVn4t8Yh/50Rfm/+5+nGZDS3qezgk/JnDnT9Xd
Jc+4Uahq4cbXcl5kRrDtbj7VjWe5sYbz/OJG+oZhVxplhRCT5E77t+9K8IIY
L/d+xIlQufGfohwC4nr5p+3EiQ7MSDK2OMeCHxnulit5PSqGLFyMCGTTOqwn
SyPcYjcPoo+8zV64QUKj0+xid+K7cF/PyRTdIX6kskW4XCZOFFUFK68P187g
FdGuORbPOdHgk7yXbX4k5JR5LN09fQ6nHSkLFUcC6JlJ9UEPQXGk2ydlodW7
iD/ufm8/eUgQBSxmvhkNF0fCw38+ajqxAp/FNguBXH4kmkFGn28Q0MLv0Ltv
3nPC0BY7puxnIkh3StZb00MENXp615jmCMDl1J2O6apiiDyhopTLL4ySureZ
3OYVAc6Zic/K58WQWmTR4u3fQsiY+LqcmCwEN9oMt8XsI6GUUWPC+1l+dGjw
brFhpzBUPHbP5RuQQqFcv7QDKPwoo/L8X48IUUCePEc6WcnI0GlYUmW/MHpf
6Xui9w8BVETlwwTJEih/a7EAi5MQ8jNla9lfKwq9794sf9pNRC9mflmmJ3Oj
ZB6j76mORFA9P82n/0UU7bvUp25Sxs+og9YXm25JcOJeOmsWTkJn9ia85/Ph
QIV2qp98t0tAplnvraQACWRXHxnW/Y4P5QzAD7RBgog1ArH7MRk1Ku46lsbB
gwwCxz3mHMkwbUIa/fxQEt2yYG8/eIEHTbQsW/hqy0KEjqxh/39SyDru+uc9
xxnrMKl92siWBYsEOZOuAjIyCvZXva0jhHbaqGu/bydDllOk6ShdAimrn3y1
7QI36vYNKY5bkoIbJoGNUisSSPWwTA3LDwG0tqtuLbSTDLOnjqW/SSYh6z9k
jspaHpQSWnxfLk4K3i1+e2rSLIl2Wrd2PQ9nRWtVEijPVxaOcN0jNjATkajZ
MUnHfHbkP+x+k/kCGQaFg2r6GPNjmPi+Sp1jQXx/fzzIDZOBjuLS5jwCCbWK
y0mF3VvDSpPQhKQoGXiZ/72qkJdCTNnPaXtO/cVEP+0UeucgC22ivudsFiRR
5sySQWzpBNabaZYuU06Br+xGrSb7pNHSpUfyMT9aMDYh1fCb96XBZDTE54W1
DALxh0UiqT0YRSq8ajRLFt5G92zwJlJQzpL0aYP5P1h42PFT50YoQFjT2VUS
RUXT14PK1ZdHGTpjd+94qBwEOvc8W3pOQQFz9/YEjLdh8UH/3FlX5cBT72qE
XRoV9cm5sd/DerDh65+4bwMVtoR8i4ljp6LIfglpz+pveEn1k83mJjnoGlk/
+/mBHFLhchDbrvgLd/JkRV1/5KGa3ViPKVMOMU1sPfKo/Rx20CJ0Rj1XAaS3
1DQVaFLRRPQlP9GCQVz/a9Co0GV5sDWQV1q6KofSMowVnh39gn17X+vMvyYP
+zumD8mMUxBX6Idk57uDWLT2Z0qbljxsHsprSs+kIrRWOPPQ/iNe038nx+0v
FZotY0uFx+VQs63UBj2vBm8+xyIflEuBb1KbK46WCgjo77yB/Qs2LRUV6F4i
DYTXvTnv2+RRUpQwub6gAxNRSD2e2CsFZ7vk7xwNl0dMX3n9PIaSsC2lsmyc
12Xgek7+uIWIIiJ5jdRYXxnFb5HL/A9tyMJyz43hu3aKqPLhzhNXhf/hoTfy
1LM7qdA9kNAvc18edRjWR9pNtuCqwj6539floPqh0sk/61S0w87j426OLiz4
RaNDxRYFCDykc2ezlTH/vzOJ75/14eUDsiP+KYpwL/ToS0sxOSSSf8dAJGgR
f9YdpZYcqwxNoWf8fzLLoVNCIdj8pwX8e9uKfsALRZCgOfzZeZCKBrjn7Hvm
ZvAbiru8lI2VoIvddILNj4Jcbb1u+qpv4M9kVn2yTiuBb70lW2GeDBLVuTjs
x7+KN5vu5kbMSsAn/+XKH0MqqrTHTJtiJvG/9Q82zzArg9PZTvLpt1SU5l/o
5pzYgQ9Ku1qJlyhBZhFLsOKqLJq+/O+zzoVBbG9AxGbSlDLkVfzs4+unIOM7
Ah8jFmcw9R3UdBVrJWj+9yTMTFgGPXfokvRj8L/5/oS5l4AyENf3zX1noyCD
s5ZcBSL92MG9updfHFKGmVh69nIcg4eXr0b+DOjEctKviUpZK0Py/ZEl2yFZ
RHF/O7NWUIk7F/vb5g2ogPF4Bu9oFgUx5Tvb4eNVeOC5czYF12hQkOKELWXI
IsRkP73V8DNuPdG7clpLFS7YG/09rklB/sHVW/f1zOC2++QS/taqQqH/c/7u
67KILJB/wLtkDL8bMTRjj6vBQks9+TCvDJrejHwoo1uPn9zmm7+XVQ2a6wPZ
zjpIoQsXre9sG6/GDXjvbdMkqUFslbfnnxUisv9gz9P/bhL/nZE+l1OgBpnB
4+3fKeJI4RWWaXlmCY8/VBy1cUcNIscy3zR6E9GETV0Mr8sQrtuouJBfqQo6
+6tbFpmIiBx0xeSNUD8+vDuAx1pZHSrWlw60WEmgadnfO5xUvmBrJfJ1sQLq
MLAH3Sv5LYluJIe/Vc/qw19VC5/7gqnDE7rzmKSLNIqdD30Vs7UJW/7HpXdQ
VA1YvPbWO52koCJvPzPix0kse+GwcdsZdVj7+0JkqxujDnJt7Fb4FHY81/2A
/CcN2GPG6/wlRQpxzCwEqLssYVnZx/S+xKpDnUu5/85GElLxNLW6MDWNCdx0
s5w6rgbh1366tbwRRwbJP7fG6w5hgTpHz/2ZpsMtETXNfZUiiPTE7pJTzDQm
0nVMbyGDBjr3LO7r5Yqh/b0bhc9TFrCSo+H+rlyqoOVZnpJ1goiY4l7FnzGa
w2TzHHdMjauBcfTr8T/OYshOWunc64cbWNzaBNNLmhp4KfU8acbEEMrZybLV
ZwMru8zp+NCTDgbvH+swb5IQj5KryX932ZDNi7MpOmfVgMv/VGs1JxkVBKQ9
kctfxt71v7ifn0kHrfcaXd5UMlKode9bP/0P202Oro7jUAMDl9Xr4cvSaJAS
ktCayowOHZu4/VVTHWIfZ92YdpRCE+dvngnmWMZCeOt1irXVoEt86kZBoBSa
M1o+HsA7gkmGvqui2qnCywtXaN/uSKDm7Ik+qYUGjPD1LgeQVKHmw/D5k48l
EVP4rpe+Fpl4zocr+MtmOmRfT7gZHczg2yfH0Ob+ZjxG07uYc4oOs0zTN6W5
ZdAO8fS3X8J/YM9b2wf1mWhgfFnZQgWkUI2hWV2H+QSWOyGhyUWiQdfgAdNH
+yVQyZYXaVy3+7Hki35jJRo04AhIa+TTEUeXyZRfDixLmNWzxw0n3OggWat2
JNSJiAruPbo5QlnHzIuSuzqjaFCmvjNViiCFxINYqLvermI7CihNAhQ62Mmw
t/r9JKOFf0/kWk9PY6mBSweOVNJhOjz7v/s9sqhXm/586skmtgXUIq6RacBf
JzOxsEcGmf0ronVwzmAVzJW72G4rg4hugdUNISl0KoE30yB5BdtedWmvtZEK
1Ob2TpzbTkI6dnqoZpUNHXJpvyYbqQTm20hFaZliqFHn3IFGEWbUevl8xbyV
Cjj0qNawzooh12oDp/hUNnRClpD7dZQG2wwexfR8FEW3xWIm+86zIG5zs676
eBpUQXdJRZYIWtIoDr4txIpE7orGbr+gCuMCpJ4rzWLopV2awLPgBawyyYkr
1IKBYxxHJf6ehN494rrne20R+1oikHa/laEb/UerFSdE0ZvIQsOtgr8wgfr1
2dgIVSAr0APYygnINcWkaDG3A7tYqrw59pIO+uc2NwI/EhEXU6jnbqMxzMP8
kkC3IB3KbNS24btIiGkWm2uzTsASuVq/P7CggXuni1HbHyIKOlb5r/3sJK67
ev3Y4hINDiawF6juE0VBFV3CV8P/4pmefn55ESrQl8uBLoeIIR4+/aU96sv4
Lp8djsFMKjCqZywVKC2CXGs9uj9NzuGNq6PbaaMq8GTtp7eDljByTTe9MqY3
g5ttqiYLq9NBKCS3a0xRDA37daTmvV7BD8kXOnQY02Di7ff+1wMiqNCvc+Lo
6hI+ahy/7/YkHR4Wl79V2xRE49x92T/n1/Fx5YDi+T90GDzi6UzdFEENb6TP
R7es4iLVvMJSD2jgpKz/ZHRTDLWaGR5dfs0OZSzqO8T+U4Ebl8otg9QlUHW2
147P/HxANY1v/zWjDDZvLfBkViLqTcxyjqoSAKVDUopt/srwq2+X9/MpMdT2
98g2lMcFLoG5DRJeNPhn9esw9w0RNDx/6uB5Pw5w2lG+r1WUDt0pFa/zc4VQ
UdKDg/77uCFoKkhiiy6Dz4lK+787CKD3PqrbTGUFwPP50GSuEOO+F1MCI86I
oPuC7ziLtvNBsHSc2FwpHTTDR1Mqvwgje9I5fvkNHuCSdZ4ybKPBOEuUzben
ouhGfJjB1GtW+OWeyCnL4GGVx53yC6+Ekc7DtFmlFkY9DSDOSlAVMi9YJnna
iCIFnbM8lz4u4UZjUtEfbzLGf81an3EmItXFRxPtGmzgt86yciCODpYyXue9
t0mh7/XMewiCrKAWoG50s5wOCca+6u0PpZDauS0Jn7JW8F72qhbJMFXw0dR+
G5hKRCpl2Y0PykbwyuqVaZ5mGrxb/nz66hojj1zcsrrZuIibJDMN0STpQADz
hZ2xYsgnlfi94/sCvqQfrsm1wMB3/JpWYpoYWrKOTfpmvY7v9+BtstCmgYv+
vrS+NBGkJOgTVCv3D+/stRclXKJD0jlPX/snjLyhyfn4wsIm/m7nN5dfwXTI
GxkcFGkQQWEtfxLlUhi4m7EUHphWBZlL7PtDk4QRs3voG9tabmAOY3W7PKQG
A+w2Q3iOCLIl2XXsnueEHUx/9g9sqkN371dTGkPHSjk5JxswQbjDR8iMs9EE
i/LNpC1MEujtp0NDv7l4YXJfeYsrRRN4jI+VNPiSkfjJpO0OD9jh97HNzgFB
LbjxRt/fQlQCJdz3zkp8tYmLivMoTPtqgjkNlkwkSEjDP2guK3Qa17/r8mhY
Wws4dgxcDtpBQg0pKe7c47/x+XaxwbtXNcDooP/wuzEiCnlVWb/1fDku0LZz
+GiGOpCGFEoChBjjuzZdF1RasJaymYbyDlVYfcn5+chNSSRal1kf4TqAz/je
YH8kqg79dz48inOWRKccBvRrkyvxU8RXF1P11SB/56RvwC0SurCebpJLHsdU
RmZM1vtUIfK/Watyxr2Q6ylHlXnAVzbqTWtK1GFhY7SM1ZnhH247pl8VqsfL
Gi2qgg5qQs3ey/vL08RRSSy7q9a+fvyAy7HDVz9ogFmfga3KFEOXEsf5hFOn
8YUfgiV15hqgYKgLP0+IoQtjxhv/3ZnHSYMinlrDakC22/lE1FwCRRFEnHhz
5nDv8WlHvxdqEP+8cUIjlojMnq5sOaHciR9sq2/e1sjAXaAndXsfEVWqV7Fy
yPbhB01vj2p208HPUnqpPIaIKNx+C1OsVZjgia2pZcGq8Kl8m4l3kASCz09d
NKvrsDpnw/IKgjqwXHez2sLL0EmRf/XF3Z/xa2tS0g901KAgbpb9VKAoYvrV
G5C9FoNrfBedcPtJh86G3lyXBlFkVr9n8gOlH0uY+UUX+EGDEz+MnoXfFUUU
/quhemM12KuusrH7sTSwW531TdAmIpvjF7JOPR7GBv7+9906VgXClhz8TRj+
RHJQ5x4+u4Als7hM+MwrgQRmbg0FomjO+Y/XHUsmlCeuK/uoVAUmarw9GrlJ
KMJy15Ra9xxW5jlslRStAkr3fxNUOcSRztJ0ifSpUczCOEMvjZMGzIrrLA3J
RHTq+OVn4ZEF+PmnmdLEVGXg7jT3L94goOe8Z9qvWnfjrk9l90XnqkD2pkvi
WyMCKhnecSlTdQCnlbpHhZTS4P6VGyTFIQI66jnv9jp5Hj976HGUxUNV0NUV
S777TwgVBiXyc2ydxq9/SnTO8VOHLjvDs+RDwiiCu6ROm2sD/1q2dfICg4dz
hIjuZ1OiqNuelkOW54B3Qs+YyhM04FbHa5W/FsLIsM/8j04qB8Bx9c2jEhqg
LmXf9egVH0rbfd5iSmATX5W08jpwXB2yBYOclS6wo5XjNx3VQ9fwh2fYxvUY
fH7pp700+I0Jpaz90Ky3G8MtuwPaPMNVwe17rgrfO3akn1gUXb02h0u99Q6w
e02DxCbMc3OYGZWs6m4xYfCz9QOW8ISoAqeSGl9+tWVBDYidq/HwJq6/axbb
mqAEunE2KWd62NHxoHfgHc8MsXaZmkNliuBXcNK2eHENI5WFkv95LuETvypJ
/d8UISuihCL5dBOLVTJoWY2ZxYUiNN5qv1GEl2ameWN2G5jTsSiNpIOL+LGP
9aGOTYpQE+Hu3ti9jBmNtKx6nGeCES7VnHomBRD6zhdX+3oTiyw26HYqmceL
nZWlttjIQbLA9IPxqDXsq9vN2u2CTPBRptb2+GkKsNz0y2qlsKF9Gg9qnQqY
4Fw4ZdtGrgx8Fz/sq8Gzia3hnjbqBHb41DJiZ2NGAbO6+2sxsWzofmXBBdEI
NjDQ2tXZqisLbh3DYulKm5iTWZ5/vQ43iGgoWj6mUiF6p/iuk7cmseUZrCYy
lwtK8PxxwWQq6JxrfD2qOIv1u7ic2NHJBX/DpJ7w35WHd08jacOHNzAf+9GU
1XVB2HY8NpGtUgGmfYdsDq9MYDTC5qcePgHw0L+Z9CZREZTYPgU7GfzDjpvs
OL5Dgx8kX/MfV/qqANYOsm0dhZPYDig2N/PnhOSbic+snimBOGGY79boNNb7
oV3/HBMLuFVTwsNMlaAqpcVBfv8s1rPO9Ly2mAM2pm0KMywUwUxpZGen0zBG
337LjNdKAASP2RreKZIHplBCr1vJR/xFqc08W40AqL/ZvH1ZVR4gqf+xP+0d
toJSeZZnheDsraCMO/pUaC6Ljz52qA3z7HgzRhQSgv0HjrBykqgQuyj5MPvW
BPaXsBbdqC8MBTK0LU7pVBiQZg/KX17FxIO6/HxUhYGUb03jOCEHnwzbidX7
WRFyUZHUrhKGNI6P2xyjKdA9m33810cuFPDRpp1oIQSFxxskOpYocLTD/cir
F9yoOCzzXVuyELh3e77aelAO/m7eqtd/y4ncXDRZZ6lC4LryX7FiAwWW1uS3
nDHiRf8I8fQjDcLAFRdme9GVAhHTpuSuRiGUokop8TkpDApCXAIK9RTQiF9w
ErjEjw4aeT/Bf/IC1WFPVAhj/S3vYo4W7eNFyfMBY3tecYDf5nNZ/lEq1K0x
bqYnjGatAq3yDwhA8/SxkqTH8nBK2dRXjFME7Zva6ilSxA1+8+Pmh/kVIeJh
70h+lwDKNd2jZSfGCSRqM/3uFQUQ+IkZWMQJopkH82/6vHggdGdqXMM/eRg1
po7ccxFBXpnkLZcO8cMP3tKdVp6KME15mn/Qm4DYnH9v6RcRhhaLyqiMECUo
ePp2s65KBGlgYMM8KwwsRxw4o1YVYJy2LnSIUxQtVhWbLhBEYSXXtf/fGyVo
1j3V/+qeKPKdHLT2uSIOZf78v3PalSCs6q6k5H+MHJ2q99WjSRzupB4c8Dqk
DGnPw4xaP4gi0eydnM+CJaHAae3Yyi4l+GXMrX7BSgTtPbhH9rANET6dXZoV
klaCOlaXWbVTImj8S+vM1HkSPPl3z+jcEQXQ/4Lu/LgtjKJWPPTaJEjQatS/
oJYlB5H/igYMlMWQI92EcMOaBCojSX/GLaigp/ftFHejCHJv3x+spiIBx2vU
HvVXyUBKZsq9qQYCsmh239PQSoak6/ozuJc0fMAT3Ad5xJBSY69E3VUJqPlo
lKP6Xgbkq4I2HUZIaM7vPK4mTYaQApk9ldOS4KNYsSvfgIwqNoxEkkbIwLPc
1TSVLwVHf1Q4BbyWRsLqYjfmRCSAb7q1QLKdBL9cJ332fZBCD0wPVnfGScBk
0xvu9xqSIF7G1CP+SwLV3PvOpy0pDWLFVGauXHGQ/31zYaVRGrX2HZid6pWB
gJ9/QlvtxYDKUT9Y90MGuVWPaLOJU2HLafaIcwzcugcUwjm+k1HkWuWO7ekU
CPFCCYQHopDVccnNwk4aVb8ffxXfSYWxl8nBruXisCVlZHE9QxpN2va/4tan
AD2jYur2IhGWDEXmde5Koug9kgVxj6TBSbxSJPYYETSkpk8oJzB8V5XC/skh
WcBcb3mFvyZAOvuduQA+KRTR5p2/oU2GMtnyVvNscdj0IF96lMXIp/7iNwfv
k8G8XU/zxVYSWG4dbRP2JKPToRkF019IoMs82CscRYLjlWKX95ZJoCfhOUqJ
zkSQYb/ZO/JEEl4ipp2HhUmomXOM7XaJGCypNM90LUiDq6ZngGi+OALWONG7
N0Wg2Xl8PDRICtZ8Of0LgsRQ9ov8NUxPDC56+38Z85aGldcxCb/FRdCqTde8
DwsJYuciDe5dkwCTLty7UkEUaRB7gnm4xKH71zXnqhES3P203vD4JwGRnZbI
VG0iZHxTyP5tT4SGgPrxWisCYpraQZpbkoBx5wPcJFYpUEP/dv1OF0KnfNnI
Dr5EsBh6N9ZwQhoUlH/ukZgXRm3aZqXD8hIwpO+/FClFBq4fP107WYRRs2Rt
VxSPBIxxJbB7OpIhmHn+zikvYcR9qKN5VUEK5LQnJv0zZCFt2vB9/iECEvlb
/CLIjQj7Es6cTD3D0J/8putMeeKocOPC8ZFuSXCdGrT8EigNLZ07rZZjxJHK
2E+fYjkJOJT6/PuVg9LwZ7KBektUEpFvj7viAxJwx+kCi/msFFgr7I76Z0dC
mX4tcpGVZKiT/ifP/oIMu63zXg0gcVTXeCaukcFz8hul++FVEhBEijnZ4yeK
nL2VvhvFyUKYdfHS1wwSECL2kNJyhZEAyV/YJIUCXduWLJMZfMs47S3MP8aP
zo8//aM5LgtHXxj/Ej0pBlsbrshf4xJAZtaVFM4JKeiqKPGMrxWDbW9vfTPa
xY1KPEwn+leIoHOo8/aJdgJU0uwL3dIEEaZ9wVYoTgxE016lrMoIg9JHI70s
FRHEYXBokAJEUC3dnNhlSwD9KelcSzER5MCsk7/diME/ZZnZmWQx0DFyPGQp
Joz6+XlsHriTwNplW2x4NANPWjallCSKtiye2v/1qwTc523w1/kmCSfcD6MH
kkLIZZtfWTMzo88Xq35FD0lD5ZZro4EnedCAtdLYKBsJzOSVy86dI8Mt4U8P
3JcFke6pKKasChKIBxwwDa2VhXJaI31fFgE5maQzu8SIQaQegeR6hwprCS5g
NEtAllabqIpGggjapuj6A4a+qdxR3OIvipZOO21PnCRB+PcDwrZe8mBLdtkh
8V0IlWqd791HkYC11+art3vlQKPOdardQARZJosttDH6YYH3sO67fCrs/HV5
T6m3ENIwvcTl7iMNVbtqjpc4yYHVfRP7gDcCqMY+sYTNVRIELnwQND2lAMcs
59OyM3nR4MYpuT+zZKjKTwjYa6gEaQLmBz4b8KEUq/DK80IUWDStMbI9oAxh
8ZmFhFPCSHTSuTf0tDRMb9RfX/yjCFU8ygLGzUJIofPW8YCXMmBtYrvNKFYZ
ckYli/bjIujlhSsHsl7JwDkHaxWhGGU4cG7b/Le/QsiE1ZjHVFcaThzie3zy
hzJYLOp2rUgJo9tvPtoIj0jCycHD7iWHlWBHj9AqI7ihIX35qs/tMvBxYOIo
62UlaGfXy+9KIqGwuv1/rUrIwKf38eC8rzLYaO+18XIgobzoCsfzShSwtpMQ
Dp9UBnVRh9KGbHFkglqozZGyoCkzOXJsXhlYXv/Qyr8phv7o/nf83qIU3F2J
Gi9WosHQVY1x+2AiKnmh/L55jQQLD8++OHBLGcwbHm6vF2D0y8DAjno7Mag/
1VX9TV0JZI6fxOseEhG2uyxp+1sC7D/8bPfuh8pw/3CyoEOUJEra0ZJ+tlAE
bkhV3056zfBjBlNNT2RlELtRqpC1qhC4LbS8ty5UhISQ+Vc3Wskor4XvrVYt
D0jyT5snMfYtLpe29dQlows23C+5Q4Sg0erzr2pWFfh5qyiYPVgC+TRMT9Sf
E4BrM3jRlo80cH+ddSVhVhJpXeD3P9fHDzY+kXurr6iAbVjON8YhkCQpQ1D/
PAeUbrvWMRdBA9vx81Fld0loi4XPnwtOLIAsuY11gA4hbk+DUoZFke7zlL0d
n9iA5Y0Hc4OfGpR43Em6nk1Cr1+mtpsMMcF4Izst8RYdShHhre8+ccR2eebR
0UcswKUhH/HBVZWBF8t7Q0Z9qpVU1M9f44YIp6jT+87QQbzI3bPqPOP8LUHk
loc8MNdxhI/3BWPfogVa7YYYkqTOfVF34wTLA+yCV+NVQVDN8uSeEDG0dz4k
OlVZAOhedxXSvRj5y79gzOU6AbW+DXqDfxaE99vtD6z3qsIv1qVrQbgYkmDf
86rmkgi47/blPCyjClYFInw5HgR0Kj781nN2MfB5LxeQTVeDC4HNVrofhNCN
fenmKRwiEHF1XettGR0a90QKXnrKi1jKtM9fjxMFQfB97fuEDouLuzh33BZC
zks5P/7eZ7wf3KbpAyQaBLT7kcQHuRH161ia9aoYpHt/Ln5hqQLa9feJpl08
SO7wgYUzZyQgmfvenl3PlcGKd3qrrhIb8tEhhx88KQleJ0MoUWuKYFImgFkQ
2FHFw8f9f+fFwcZM5WHBVQV4/PNK3FkvXmSsDdG3xCRgqtJPKuO7HDw/9rks
4TQH6onbq8VvRIQn47ImGdUK0NRlJPvOmQ/VxH2R/CMuBnrbm4aNSUrwnOJd
Z5HBgUJyQnrolUTwZLJm6k9QhhIr3S9HL21gcUVPuuUtpKD75PoYf5MKJARK
/4xtZkHDr5q/PzxLhM//vrUXstBhYeyJoOv2RUwOu4b7k0kQptQ72uykCu7f
/VvyqiexOkOJWtbD4hCllcN//CcNauJjBd5m9WFcSnIjUiKi8GuA7i9oqApq
PlnVZX+HMU+5C/QMWSEQVY06edRHDfw9FzrO8q9gBTfuvrPfIgzLQh+SDARU
Ierdp+9bj05j2b9f+la4CoLnwkfiu0OqwKW+LHt9329sI9VKu4Th84MK9Zx1
+mjw6bV6tmTbNHbZ3E1+v4sYOHGs3H92VAWWwKamP3sdIxGwg9yFwtD14fhZ
5loVqJczPz1wlBl9ZToYluorCmG78ll+DDBwTI/0tQ1gRn2j/NXrw6KQ0nTr
At+mCmyaWrT/vsCMVNFGulUhA6+CdsdGeTrc5xxZfTi2jGkGsC2/ZLx/1o0G
CeEWdDgoPK63/PMfFuffk5KzUwweM80u8zB4VZEZkyqVsYGVbYgPK0ULw7uw
hw3nqWrgPEA8aTfIigyW/W8QWoUhok3UitBCh0tvDl9pv8WBOltOvL/tJAK0
gsvuMjvVwNzW4sargE1s4Gy48dyoINAe0JdzlFRh9liOB8soK8pon/GjM/JO
1IDB7ysddOjSPXn6EG0F61NrSGtrFAF5qb1q2xn3bf8uc8J3BzNSvM36YtVe
ANxWkWi/CQ0uCimxqxM50SGZe1Zr+7jg/iQ6HBVJB7Yrootho+yozezi42Fe
fshgiVbdfpIGFrz7P0ht8iLNZ39/X+TjhucRpkZyQIM50n9X+rP4UVmcUeau
b6zgFLhBbnSlg5mm120ZKR5UoHkwvKVkDb+RHCL8lpcGuqqWF22VuJB4RZiz
BxcLxP3etc3+mDLgy3MuFV0caPczgzHKJQ44ZHDG8VSCIlxP2HvKcoQX7QD3
xsF4DvhpYqn7da8ilKz+XGk0E0KPSLKrgX/Y4cv9+jc0F3l4Ofo2IFVdBD2a
qpp9bMcPwiaBMR+V5MB677Nreo+EUXElx6U9vwXhykatupyVPBQ65aSFbIii
ED38q8YgH9Q3BXWl8DDy7MMC7yI+MfTf9bSLDwl80LGdI6/bTA4Gr12++uUM
EeUe43zN4ioAs3r8x9EHCgiJRhKzSononMRo/afbnLA2H+uYpEKBfd6H6pob
GbqaKiiesJ0duCx7QlTWKHCorqM0wo+I9CQJ1A89XDBJqWN60EiBOrTVtc1Y
HFW3hM6aavOBgsDJ8JuKVPi03bzq4kUCsn1e3KSwzAtq9fHty08oUJbzJs9v
RRiNXRQbLP/LDqzSZ1TuelLBMOOpcCaLGOI7K3YrdAsrNB9nCl6WZ/iQK6m0
PZriKHXhxF7pfjYoWzjHEdghDyHCwHy8jYhGyu/VHFnigoreOuUFEwVwTWHq
rGkXRR/XeL+t7uAG3b4Th75MykPX0qL9nIAounhqPd5bgg3Il70uDyooAtGw
wdUkRgSdkM3V1VFmgUtaF7xklhThzJJ1E/0VAVnTBXWeFizjs+Q7n74uy8Nv
9cSAqCohZH7XW9WrexWvofDP3U1UgLKlyZ/mPQJI/XVa+/NwVvjvVGLdz5MK
wB28y6JdnYDM7JX+Gu5axBcElmktWowc+ruZJZVMRBf0OruauqdwFVuQ9ZxV
hIWoFPZkZxL6fpjYdlhmFT98e9vfi5giNAYvJD3/I47slK7Z5kSu4cHrJlt+
jSpClAC/bmUFCf1Zut6zV4gD/Jms2bpDlSBC58WDVwckkXlpi1720jrudLgg
+4eeChw9d2J/3LoU6tUZWkiZY4b4+QsHPn6mwUrwuqBEiSTa2xZ44nsvM2TD
dJLTXjoMeXgEno0no52PvggcOc0GmSWjcfK1dBAwZZaRvM/wFSnmBhHcvHDr
5mWVbH86XOFJmtTPkkZaNnQrxUP8sMdFTn36pBp8j6xfgE5ZNBTyn4l6uAAE
buYd+PFeFfRO0zLW+ykoMzHPreCDEMjI3Hp4IFkVkgPpcl+eUdC4keF4021B
8GswkHMsVAX61S5uwa0U5G5vaNk1JwK/be1qHbpV4eDZ/qzVcmmk9EBnf8YK
AXb4u/s5KKvB0I9F3jfVMijv2UJKZ7wI7HewlbXYpgphG+yHKZ3S6HtW6mZ0
AQEmXuWJ/YtShaWTwmfPLMugIW3P34lOYqAfy2cqeVYNchI0W39WyCB97bdv
qYVEeMX5BE9JpINBIj1YNYKCPvZ6jMlVk8Ap4cbIVw5VGNcNZbevlEYVSid8
Er+RoIrD0+XJBTUwGeLMvNwjjWoE9O/rpUuA9OYUt1yjKqw81HH+FCON/CSu
meUzcpdP+3yDPJkOQf15kdX3ZRE27HDW/REFCgo+Fa+M0CE9O7/m0zQFTV6P
2IJ8ZKFYxxlzOqgGRssOjw+9kUNDoLm7toICPanZiVv0NODjWXYfHhkFlBMq
t8uEkXuf2pQyAowmfH/QNPyFLodE7iq/nC6UBq6z+gH+pZpA+H7z8eO/csig
bW3eNZYCJRKTLjkdWhAY5vS3oF4BDVfJmgUzcqP9zPPnN1S0IENfaFeBvyKa
YJ1QF9tNhYOVEU/tujXh1HOpa45IES2LjfLXTlLA+LLonPdFTRg9ujIynqqE
xLy9Xp67RoG3e+MHjAY0gC5uMqGvo4gOXtUxm0iiQIRxDGUjThPyQ4/0jpCU
kU3S0Tc1xynQ94bs94dZAwgnuJyOmiih5+YqBi+fyoL3utUFwns10NtWeSKs
VAlV9U9vc1mRASm+oxTNIlWQeqlQx35VEVVSjUkSblTQj2cdHQhXh9c5TbVL
pkpIPHQk5kOLLOAGuZdZXDRA7+SbjieaiujJw3g391kKdBv6TdtqaEACV5dA
zQcFFPa5rtpKjwKvvgRYXjHRhG4mg6rXe+URZ/VDF4FvFPBbkN895aIJpvmT
nX0f5FFscsw2Z2UqCA2UdTtEaUDsNY5yTEQOmSzbZwatUuHkrOQtEx0tiNdf
4MgwkENZiVmdK3VUuENWiVmr1oC4oFu+ASpUxCHHhnV5yIEr1cT3zmsNGA+T
ZJevk0WmEQWHiquokGaxucF0Sh3KCvqfiuZQ0Z+Y59fqfagwdKRxfYbB83jH
xttxZlTU5HX+RvqkLDBj2/3ThdVAKR3jqbejoOieluIzTFS4Zv4dIvPVwG96
zx2bOVlkXDr/KOMLFQb0Ui9X+atC0sw+dXUlKkobuvxX+CgV9lqwfrvmRAd3
0uYRPx0Kcr4sXGl8QQ74LwvT6pvp0IS9c41Jo6Av1/6y6MjKwWsid5VVIg0G
Kn9OTh+RQbVj/mb+lRQQbeNM4r2vCjkSe6W0vWSRiwppc9aRCtJ/j1Xf11IF
M/tPpH4pWXQjXOkw0ZwK3n0OLHa7aTDOZa/7REsaGbdaimf6ysE5LsLZIzM0
KGQLly/cIoM6/tWNbhNRgOGsgsaBPlXQ4LTRfr9GQedufW8OzVWEJ7xp5Y/+
qMJWOvHHr3gK4rE0da79oAA3Khy0v79Ug1O7KTF/x6holDUvD9uhAEF0tZAR
Rt3ME3jwy5YUNF/neK3TTB6m/N0kbXF1CDsx5GfBwHfiqGHFC8b8qqPyeqJN
qpC1GuL04DwVYdXDxTvL5CC9+WnPJQl1MOihl62BLAoWD6ZvPUaFE8lXGCZI
DSieH9/dryOjlfFPu+8dpoK5/75WzYfqcKlcrqeMIIECfKSdJDgpYGi32+uY
jzrUXtl0l70jib7Sd/2qfSQLe8bm3O33qEFlnUD+8jgJ3WqVjjt9kApXbZir
VyoZ+6aofBDBiShZ/lGgVw8Fet9WHbpopwaW+Z6G715KIsk605iXv6TBy9u6
K52mDqt5ytN8FRIInGRPERk+oMHs7c35c2pQyudVe9FPGl3QzHEQOy8HVjhp
WyZRFRxT50+pNcsiEW8RrrksCuxRKcyaSqcB+XSggUK2DFJ7uFv+xbw0/FVv
2gX36JCK9d+pJUihhePRybFnyVBlURRU+FMVGre4rbwiyKBKvco6ehoZNPZS
pmO7Gf5WZjasPEsKHZRvvX3FUBbU1IsyzvbQwEnKoeuzryx6lLVUFC5KAQMn
8DhvqwqkBwe3hyRS0K3nBzKWLlLg02TgzYksOvh8232H8wkV9bRukWtMkAH+
hNz/0hh8GIv/teoZS0VlIuNh+FdZiPhwXXQvQ+d3PMv69dlaFiWocwdyvqAC
1V3nbOpzVSjjvGWcO09BPVZLTLoOFPiz1PalaZwGMpQJ4c41WXQt/rRCMKcc
3FbxSq40oEOaVeo6WZiMlPrrdLSrqZCjGhJt2UWD/64b6W0UyyATjTr9NxlU
+Mfuerj3FQ2eHrP7RL5KQcRtRSGzAnJQc8fPTfaKKlQdzPcc/UJFCjs64kvt
5KFsPbBzr5waTO6xWmpGcujYibH1hUgF0El6/XdUjQ7/WW3MXN6lgJjlFvGO
DgUoJTf0FrUy6un32SApSh4tvvuPeumTEqzp3W12KKIBU8pL1a1yCujG8vKz
tCAlOKYR9/K+Nx1YSo9NfL4rh1J09kTeaVMANpWFIL+jdPj1oqf00DYq+upX
+UxtTh743BXyMt+pwB9BOuerIln0JP3SJ8V/csBOyDz3wVgZhDrf8+2tJyOT
xTWmklUGn4keS1xpitDMYcd7blAWLUSc6VamysDiVLo3W7sCCF/gbyiakkGB
X5iOhCVQYCPJhzWOSx6M0fTw1TwKUlhyFFHIpULzviPrmtZy8OVs1s0fdCoq
Lg+R3g1UKMzt8/jWSIXUxlQJCUUqylrc15iizOjfDZUFqxAKPBKxiVhIpSAt
v6Wik3NycPRU0L5vDD1Oc1G57h4gg2IcmZ1VTakg2blb1PgoBUR8ZYaI0lTk
Mp7jKc9NgZRDdhZsuyiwy3VpY/IlBaXtM8ofyqCAbzp69UheGnpeOKRPPJZF
u9t/nGWfosKbVnX34hxJsHxtGr1Pn4qOH9btszVl9JfREcNWOQk42zqVofpZ
Bj39HU7G2qQhdOKjLp1bCozNGi3fnZFGzCzjT05TKFAZYhtxRJEIRbE1Vd59
ZHR54okBsU8WInm2bDU3koD/BFXmH4SSkdtu8ZKEclnQf6xV8+gMGbgJUbZx
4zKo3a4uh/RVBoJcnIflqBQIQWK/f/NIoyHH5WejXtLQMPJZ3c1UGoS4mV99
q5FESx1zhfYMH1IofbzvxF0JeH2/VLjLThoNPw4PbWL0u+TfYMVRPXG4QSp7
7PpIEu1KuDCPxVNgvEOlYDiWCM1v93/edl4KvTvU4IeryML4Kf8jd4tIUCYR
lcHKL4M4bnq6t+6QBp1gj1smF8UhT5tzZ4qxLDL42v2UEkYG3ddX8qQDxKHi
4hS/8IA04pmg/baQkgaDq465GalE4AWN4vNhFDShn/yTJsTQn5dNG385xeAT
f8bIm14KWpRu9XQrkYXPmXfcSQdIcGTQeNBTWg7JmPQHPxBh4KjkiA/oSsBj
wkOdGE55dD+q9Nie0zLQ/ZOc45ooAVKe0TJOB+QQx4t7M2/jyJB2vu5z3hlp
qG6rtfb+IofyKnHssIMk0MWUUpRBGpLUjCZtGe9OncsZ4du5ZDCZ/9B574EU
FK+HSJyjyiHzO7TaA3UMvO7L7Eh0loB7yaWGdVZyKDpbWJXMToawt+4fNN5J
wEnCNtGTjXLIu2F32sRdSai4Xu4xpSgNTaGHp5lL5JHltYRzz+rJoBdbH9Qg
Jwtw1cv040d5xEc/Ni3G0M99F1lfDTpKg4mqnpliqTzi+VbgXFEoCVV2NxvS
GX5wVvD+2WPRCqiYvVMmfpMI/r+f23SyMfSy/uyNj4vyyGa1qS5Vnghv7hWk
ad9n9NPfWzXELwrIWqNL7FGRBERKpSaq5FLg3s8deoK6CujmQkJRcBUJmA45
u6o9lQPuyaae8loF9Om34IOWEHEo8zj++i0jT008MK5tMVJEEVc+Hf2uSAC3
Z69JR7gVgKX349F8QWVE39l+eU+mCNzKudjbRlGAPMHH+s2vVNC7RVENl2oR
SPNcmcViFEGG4/1pwdfKSFPErVY2VQj4We6fseiRB50jZn/6A1RQxuNHji0V
AhD6I3qUJCoPz57xPOsMUkaS8vN4bi0/uFl3GF3ZSQXxWyEL6QHKCHMjqJiX
ccHlYEP3i6UUYHa/ud97TRGRfnnvXG3hho7U7zoflmWhbKUt73egMrq5x+VK
zAA7eN57rFjUSwXul+uLmYvKyPHY0R+52dygs2z08Ns2eci1F3YK4KWhbtvR
w33jgjAX2a1dGyUHLCeFnh24TUfu4SeD1I8Kg/2/W24+nXIwpH0s5osoDZ0O
alAZMhKD7/ajlJ48eZi3PIEJW9HQOzWpRJIPEajZrG8iLeQgJ7NTu8aHjoz6
ipk8GDzEbALyH0ZRoTe8QOF+PQ2NO9OIr1bFYbjrwfnsn7KwUS4xnsWhgrj6
7kY/esboQ5E07YgoWWjbpvxLQZmGtOI7A5PnxYBave9b1ZQ0eF67eEXtjjIq
GgjdrvZPDMKI+z5R1KWBh4nDS5hLGfUzXQ7GGef8cczmlauzLJgMTvF61Cqh
lbXM3cnnifD3YkKaoLkMrEmq+rrcVEQcRR8GDx8iwa3NPgOrjzIwfyz7Vba2
MjJOv95lMSMK0aq3pOJXpIDTjP9eoqIK+r1n/uWpMjGA27eeNrKRwM/IzT6x
lYbkFKbfm66LQ09yKsnZkQhJ5bTfu6/RERnjP9bbLwYVDyTXk+qIMHCdjep/
h4bqLv1J90okQdT7zITzJaLwZ740zP2EKmJp0Q3690Ec7o2ePzJcKQ4Pbt7M
XVZTQy0eMXdHDEShRyhZuWdCFP7VS+4enlNHVdv8Fp9/E4UQZvVv4g9JwMN8
WfLkugYq/p3L3cBLBAWm0m5Bxr1PTHZtVpeoo9V2gmawFxE6+sP1p9wkYW2q
2TKgSwPduGdw+Xm7ONz9MdTh8UUCPIx3B2fbaSHXEA+bn9ri8D2vQnKUKg76
q44jzn81EUVqI2XLLgJ0nJgZUbtLhELxhYDbXzSQDFWO/qFIGNTupmzbUJAA
1lhSWfgOLdRUe79txVEIbhyQ/jUlLQV3QnfYNiRooaK+8ib6diHgiu+4yrUm
CUeqN8xMv2uiF7U0od5yIbgDlXc3M4ggse/88vZzmojn4FOxxkIeeCFxrExp
qzhs6JA4Wx9qoRO1MnpbJAXgQWjmVZcyCWjStc7D2bTRS8Nbn7+7ckNYkqYt
4SwRHKsW/5XLaaN/Xm/0Jkm84JukudK9SIJ3geofzXFtdPOXwsqOrUJwsE8t
vZdbHHxyTpRoV2uh94vsjqJ8IsA2K6qgr0aA84vfHqs3aqHJl7syNfKFYNjL
kGLMJgoC+w5ZHPRnrLN32h1o/BC9w6LU5pI48DvShrYOaKH0JO2zimac4KZh
eA5sxSGyWP1ItIQ2eto/qzSnxgWkXXyc/z0UAY5DVpJD4dooPCG73v0EC3Sd
k+rV6BQCJ01HtgDGfJH4S+1P9nJAmvb87ByLIJgEiApfkNVGKXn5vrv7eMD/
/VvD5CtC0PthLqJNSBud8Lgz6prMC/aFF8MVBQjgs6Hp61Knhfp8DVbFScLQ
4RdTWaEuCE9e6gt6/NJEetZm7AdYBIBen2ik6EcA7F+0i7ixJtphZ+KwxskH
gsn7VQUwcSCtOA0ZsGkhm0naC5edfBCNHgwYuhPA9LCZTT+uhY580A9ScuIE
I6a44y8chKAkqmRlTUILvW3mOFjCxglSs8OFBacFoXtCj3paXgsJvZd0pKTy
wJOJ55r+DiLg4E5ILQvTRKZMYr+LrnPCddZgI7YaUTDu4xsdstBCB7QjbT4K
ckP8A19nTTcCGLBE2Nbt1USGK86T8TvZgO2osvkpXBj08bmR2V511Mu3EeJ7
kheaHab+/WUSA7FtL4dsp9XQ4SYLgV5LHsi7rnvl/UMCBHTuKvshrIpaU0wj
q2i80O06ENIQKgzPYgl/nzTSkCNpUlFZgQvYKA53O32FIMsn4nWNHx29TT47
c4ckCB+e/Q5uZ+eDgb53ZTQbGpJ4P0BIbOaHTyJiwiHtQuBhc+9Z0HEVVDQY
aCf0QgiuNg+esGTmAXv5ofPEUmX0NFbry15FXjjJ9GZ0BrHBUPvTVbcaRfRz
8Hn7Fhl++M+DpnIgihPadBNyYgblkff24vpsDh5Ycr9bUTjLBsVuyYdzJhXQ
7SivqmIebsjqbV1KGmaDHB+Hpo/nFJF/m2l+1V1BCBawvEYEFlj1Wn6IhhXQ
eFL56SM/hcFan8xJer+CR/5Jz3BSVESXVMMHI4+IgQHN/HSy+D/cstafjfpB
HqGrpnpXm8XAVf35SbCYxVE0LxOftgK6n711eX86CYpWKaTFyF+4nEo7hV9a
Af0gmS7+V0YCLja1DaeCVkzr4vNPvP8Y479cdKvuioFNWrryamA3prs8wuFP
VUAqN7G9FYgAadv/WMYo/cQzbiV2hcrII/aAXJvsTTGYDqwTe1zajWM6Tx0+
Tcmjryu7hbX3MN7lOS6d1+P5eOzV5B8BlxSQQibz9H97+SEkvfDMkQMVWJYz
MfFroAJyUOGIZXXjBC7l4Fqttp/45tFLka5K8khh18ExTQlWYJLR9VTVnceZ
/2NaSZ5n+KJ9g9oh49xgazVemfCTCfIOZsaduyuPrK93fK8NE4Dds3FbJVxY
4V2A3BYrRt6xjJKK5Nj9f/+HvrPsNF3Bx6n5R9KJSuj1sX7d23kCsBHuVLKz
ch6nx8a0VbGoINfXzKvsApzwbio3pH9sGf9Yy1Qa2KiCNjfvcOb84Yb6xmCh
hl5muCVbGR25pIwMXEsCyddZoaq9/XJXAyds/5pa9J6ThpYqvP7UeHGCuY5g
RijOCe52Ks57P9PQROxP7bjZDfwsbXS1L40fNOtCOf9jvFPWdLdzR9bYIHMv
byr1Dw9cSb0pLrNXDU1kygvjl9bwLymHeSqD+KGbP/DiOLMGmp7p8UvKZQau
GYE33s7C8DpzsiZvRROJz3evOn3hhC4DJo7MF6LwMNCtz0NQE80HtnPPTAiA
UausCmmdCMJlBYa7fTXQ2z1eJ630eYHts/29JwNScNLapPTqVU3kKX3/C4XA
BdYD4i37GH4zWyzqLUVMAxHjO+TXZvnglktXft0bKYhVFUnK3qKGFt4n7lnz
42DU0258tV8aboZ2lbBIaCB9zp0r2bKbuOtGVif/oiQINVvcDr6tjma3BKya
FHMA+iys3ilIhIiCOeGz2WpoktJkTWfUocfp8dYZhk/J+W/PTOYqHRFWDrnu
YLw7yayHiHe9RcGvqeQD9xMaarlYtFC3xgkHzJy/XBAmAK6iLqY5RkefAwXk
qDacsC6is1flvChDn0zSVbnV0GgboTh/kxVYDv/iFtYXAwvzzzR7KzpqDCuu
X21Zx8MOvoy4qEeAynuVBEoUDU27G9Z12m3gvdDyLLpQGPhfdhctfFVGu9N/
urClM8Hj0ejxPSf5YIeLPan7NQ19fLn1cOF1JrDZvhrDfVkYwo548KtJqSCt
Yzod+6eWcPzG1/zACgKQEM8V9qNKSLd7dyr//nn8e2rj/yq27nCq/j9+7Vn2
yuZO17j3urgU56NppTQoIUWiKCKlJA0yCqUofENGZJSMKDlvsipSIkJGFFFZ
JYR+9/fveV7P+3k/57zer/HHkbRlcn18NqD6IY2KnKd4qNbSc/itzaVJxapK
YHQlND1dlIoWiVPewzcW8JTEvAjHM0oQE8fbsj+IhjouXUjmrPmO63S1fps5
qwSeMeKPZLj7Zxz9YnDM7hkW+dhIrrlDCQzW2JTw7tdB6HnbhqX6h7iFfNip
thAVWDPAU8hjT0Onpdq0Hl0fwzbOB3oldStB/7Mja2+T6ah6riB0rO0HVqbc
7KwRqQRD9S9unJKjo8uC1KKhuQls8bXU8t1JeXBuS35X9pGOEsqFjs5k/cXy
FOrPBnF9ocV5serbFTpqfLV5dVTyLPZgaqBc47ws6DumpscRdNFLnf6Hpa0E
tHLC6xSjQgYeu0RvIGvpoUkq+VJlCD+a70igCKxIgofzvYeN7booLe596IMP
AuiY65HW2UZRIFbf/rLmoi6KiSO+fPdgGavXX1EtPbkaGr8+qJyK10WPHLye
3LL6ifkpuL3dZiMEl58qbetj0lHdmtTavrBf2Hh2/cVkQ2GYmR5kR/HrIjsR
1S/00m/YmWCBHxuIq4BhXVJ7uV8XrYkNMun6NYvx0K0jAoNE4U8n59fTKj1E
rfsVoJg6gd2JEB3MOs8LpQ3bdwjhdPRLu0TpjsA3zG74ikxV5jJ+jrz3v9ht
eqhienX5+JV5TIBW2sb/jwdSctpqi7j5szjM4ajTrxmMo2e2NnDuD76bmR7m
cYyOVJ5emCg88RUz6CsbkvjAC+HY58NKXrpoe4TyhR3t7zGXT9pyprpCsDXr
6AvVBV0k/iVWs05wBN/fdiy6REYQ+nyrifeDuXitGHv/zS8wi6txYhc0eQFV
XKU6WeuivPR0+8Oc79hJG1uE3gmChVLYfOV+XXRkWil5hDGPkb5buFlfE4KJ
Z1FH8vX1UHNWFHO2Ygo7mOeHnvryg0JwmbjjPzpCZ7YHk0bfY6qZ6izdJwLg
8DLn45b9dOQ+PyfjkVeKle+sHb1XKQwu5F39+QI66PSsnzne8A1b10dd/5fJ
D3aB2mo13Hukvrrq5dE3jF3+eejpYAQP3D3JeFDHpqOR3c+7NF2HMTD2pedK
CgFZ0qwpgKaHCH8LjC85lOBODMfbMnsFYNVeSz2t9XrI3Xvd3n2WHdigo0Wq
mf8ybuG27zIxkI6cp48E3qfPYJcM/th5BPJCQcKm4K5TdNTxLJ/Zd34cm4n8
uMGGwwPvu0auaq7ooDBsuT1+ZQaTzNwqdTSEH3SsFfcUEGgob0He7ajYJPY9
QPuI5vklPMNUc8vcJQriHEjudtj7HWve+7GYRJrF8Wko2y5FRqiw+EX31nrs
tFxP5W9eHpg7OjO/+x0ZCWuIBxZYvcVf8KSdP9zOA/Sn+uC8i4I8f+XRDqX8
xMO+6XhiqcJgcSAhZzmXhAiWWLQcJw1v1HzIj78UA5Mzy4k/rxAR+9VAwZaT
E/hJiYHK28VSsPP75IY9wlx/XBA7aw1f8WC+E7lZR+TAks1fGfpbGzEsHXwI
UnN4T7xYr9N6WSi2ogso/dFCHf8+3Ut3XcGJObCj5ZcUrHjvsCzM0kSSlvp7
4zmz+OZ7X15q75UBvrzoHwJWmqju4sqbJpO/+KMC+n/Xhv6vt7Tz//+PmLd1
wnmT7RJeVrYt8vlROejwnin/aqmCCBvczyqY80GMVlPOdm6OeNP79fd6VQ1E
61nXbM0ggOuAlcLmbAXoFTxX01ehge6m7Ys6f4QAxgXXI34OK0KEcOfYoRca
aNPIgzeCfvyg6BR/pZGrSwYf69UPRaui9oOJ57SJBJi4vr9a31YecrL/0zh1
TA3dXF4Za+r+jf9M337v7IwCbDz3NzSvaA3iN+bn8f3zBa+LLbxhpigLApnv
047ia1D4aKiZyLVabCTylLr8F2lw4T/jYe2mhjh6lJuDjiN4UcMCzlcpDyjj
7WxGgwaqEEyvJvtO4W4FCizvi2tA7/tIN4GogS6/Hb57bWYYt45vqAtkKcPE
bv3Z1w6aiOObENBf/R6b8C2u2EpUBk2Njq4n7zVQRjvH0lJzElOfEsf2lCnA
qunHr26naKH1MacV/Ctmse9ZuPPAJgXINdgaS1lFRIpuV//k02awD1Tp1qsG
sqBoofFnxz1t1MzbGmVf9xlrDnQeQboKQPnBGbANJKLtISn/7auYxNr/u7bg
MC4Db251CIn5a6PtOSFO8UPTmOyOKYkwVRmwcoauD6JENGammZqf8BWLtZeL
fxskC4MQgJYuEFFlgMGpsK5P2JKwYbKBjBTILDBQcBIJPbL2c/NkvcU/sD9m
Oz8QB9FSFZmOaTLqbjyfN3B/EGtKOqui0y8CRgUPKQcGqAgO4m4OqsXY24ai
OwprJUBgPEzjySjXv4yk3it8qsUw/pmyxQERsHbdXZpTS0NI4qBE9WARbhvk
mhf7UBLo0xLZ+et00NsSBy3TkjHs9vPldewGGSDtbPXYb0dHcT8spD3v/Mbk
XQ6W38cUQOVe8X8cIh2Fjz/vG/70G+OxH87fbC0L7yb+JdsS9FD3rtifmn7f
MEa53VQGWRoO3CwabPuli9xrxH6L/pvE7g5KrlAvS0LTHpPGlXu6iFhw8GpO
zyTmeSFE1S5GGpopMRlWHXooj550tfDuP0zV9Dm2TUAC1A8vrGDdeoglN/zE
3O4vNrtR9oQzRQQuS+4iWzYZoJwPYV2Dq3lRWfdVMfVMHvhR+XBDtRgD1SmK
Vz/dvIJd6BuQ+tshDB43meXd+xlII9bA45CCALd3ltndp4vBRoPOZk8mA/mt
MKx/JvEjO/fSnYdthSFaoqU0Q4uBfHmYH9iqfIgktegbdFwARFmHjzyUZqKN
oiK+ipsWsLXzP4J7P3FzzXqzQUIUA+kSgtzmZ+exZYcCyl5ZXnDJThWqusbt
iUZqLJeqGSxE5VxY8ycRMPuyl+DhboB2+Dwepe3/g70+N7/KtVMQFHWVjDem
MlBQvKPEgM48trngUrnuax5YKatrXhvHQN73qK6DXJ77rvN7Ht7BC8bjW8N2
6hsgSdImI92r77GUH8VLyy/5QBvZRK1pMEAbSeNqb94N4YSrk/yP2oTh9JCM
hxa3F0+50w7G3qjH+GrGg0yyBGBon7blATsGGptSMym7/h7PW2/zz6FCDMYX
rX2UBP6//zyJROnEXVS8b6nIi8Nhg0sfb4QwkLvMW7MagRbck3BOIy1WEq5s
CN8czc3VyHqpgYdahcWsy/rbT5GFaZfK47xvDVC4eML0DrEebE/qrgz+LBmI
/xBHEnNjoPDClC1itCaMNCpJmI2ShdGS0FNaBQzUfWeDuV/zT6xw8KZASZA8
EBTWbxRmMFDeSY1dWVa92JvY0dS8HWvAU5t4NeEH9/sSwxZk17/Fe54oqRus
VYVaVaPi3FkGGrR+fDrxTwserVIdKRepDkrPXm815fZxgp24aEbyU/zDjsN+
G501wDLL7mP4Nwaykq6/cNu4AzuzCWRKnFThor2TMbuLicJpWexCl8/4o0Av
nW8aqnD5plFPD8ZCrDW3nQ9Vz+IVcV02lbrKIOJiS/58nYX8o9jduxxG8cYg
5nGXX2rg1S4hvSaXiQ7+jV9razuFmw3mXHQ/rgnKvyuHvu5moSCxvMDpmRGc
khV0vbVTE6yfJ+5sr2Sh9sSh8ly5ORzT+vh200Mt2L5IfPaTwULi+rynGJtn
8ahbwa/qiUQI3pVt29rHQlM9xjw6nCVcq5qYSkjUhvT322oMmIZIN7Fn44Xs
KfxMYbCn14omGPLbBwl+MEQsJ3oo7+AynqI//is/XAOiytaYph02RDftUt5O
7Z/BpRf1HYq6NSFELahtbQcL3ca/BZwUmcG7VHuFi7O0wCAw6Q92goUiS2vM
dyb9xje6SFjr6xPhyZ4Pia79LHQwf6KsKnEFr4oUP05UJUKsvg9der8huqsQ
Lxgf8xufiNv2Mc5PGzzI1xeFowwROzeJORg0izczq4OzRUhwgUpO30Bgo5Q0
oRb6gT94YGGhvHerNhQ6bX+ll2qIrCzyTRM2jOFu98blJFNJkJa5yZFnyhAh
VflzhBNc/zI8IxWyQAZFs6LAW92GSC1S/8rAaQJAiLqU+AoRNl9AqWY32eim
SqbXl5crePiwZE2XBAkeVk0H8gmzkfDHV5W649M43/lxQlIrCdiyzTt1ZwzR
o8CGczvdO/FrkrUJuYJE2LLqoF/7e0M0+O7ykylWN9ZXU9IkU8OdIze3K2mS
hcb8pag+9Ha8dE619gEPGbwkjXnuPGeh7d9OaZrc/opX/JxMmVMmwe9Cf/Ec
aUPk4uYmX2c+iUeEKO1d60yCnW1Zoev1uXP253v31fTgSXThMs99JMCky3cd
a2WieWqB+YulD/get/OSUvoUWApU/iVcx0IZ2IbooYFRfLPfqesyZSRo9A5r
ju7j4j2Ht15bM4HLrKaIXmaRYPRTKeHJChPJ/ujD0h6P4Ltbd0TovifBfwQf
Tc4SE3l7DaXOfh7BT/+quN9bRYH745eSJMZYaJA/qsmsrRLb8/z7gVgmDbLG
J6bqTnL5/7ODmpsyhgf9dY3MSaVC+u8DaTmHDJH0rrD7L79M477fhXST62iQ
sHiozEqFjewfB1edpf7DE3KJBe6BOhDfMeh15wEb8dfzS0tYLeHiEsPh50Ko
oHlcquqrARv1neU0ds3zgfeiJc92AR2QNF6ZtjdnI6JCzOvebUIgZPsyv+yk
DrxrztU7FGGIGl2jVWqU+WDlaZTHp04qaKmn1i+VGiKtaKOL+1h/8VlG4x+F
azQI/WJaHEDl3sXiDqUmdQLUFO11e8+d3yX3nBq9lYWKq/+qC4wv4hcvx/jE
GNFgA+3LCZaCIfIZosU8m+EBq9Zzdnv30sAoZ1Xt5llDdHAld93bGT7oyVDc
HEjUAZuo1rHuDEMUNt73Up2+hFt0Th9TaNaBXTvqdRIvsdGxF4lKU9t5gLFH
a++DuzTwVXsYT+PyLZ7UH1v5QwjomplzYpkUSHtkGRZ+g41MJGzYsvvEgTdz
oOgKPw1chrdbe+WwUbH83XXwWgisxFyDDvNQYTjP8aMYywhZqdQkmTOEgDfJ
21Tbigatjm0jr43ZqDefL9q9QBRMEmye3aLQwMLp1B/jE2zk455+UmNIAM4r
CzSoiulAZK+EuTV3H8JKZdFCKR+AQ0IyVUIHbmbK8wqBIdo2E2z/JUcQXjqG
qV3vp8PqjFfr475x9W04RYfdKgC+l7q/iGXTwdtVuJFsyUI/B6xNxfXEgc35
/Tw8TA+UI7N9QnYx0Q3Di3xtGySB1DhmSGihg/1S3PcPvCx0d3dTXFyaFDgu
MQ5L8utAr71xoooUE+mb8FUYl68Ca2HPGcc7VFjIvbmvIJSJigLujB7sF4aH
g0bRbRwqJFFSNPsjGMj/fbqAjrcINIa+TSNx9aGwPrTiigYT+dxR1LjCzROM
kUtnHiaRIfOZuImQPwO1eduM+zwTBC3/CYMiQyocy5k7kOnDQPqmnYaEW6tB
RT+RlCBJBQv757XfKhiowue1vepPCQiiqEU2FpHBk9/15JtWAzT+ymbbJzEZ
uM2f+6ZrmatXOrGZ5XcY6NEc7UfwXRm40JvcpWNHBMsNNlnxuxjo3JYDQzwc
WVgIvLjh/pgWfAz4+jTVgIlOX9tauqItDREN+tm7jbVAUkaI5DnPQDtX+2SK
SsrAOfJMfZ6dNjy2dmp1jWOi0ATz/Q075SFCSehR/Q9t2P/nybjhcyb6JeM1
ii5JQ/XEttDNCiRY6BBXdcxhohVqw1myhiw8vbn8sYlCBp/ZY2xHLr67KlxK
eU4GzI4HesZxdT6VHpLreo+FZibVUykbZECHjj7JvyPCUMbfyhxDFtpWaLWx
tEcCKhQHrCf5teFf5h7PYXsWWuOuUNNSJAbSW7yLOYPakPD5A8XTjYXId43V
qxol4GGj5JW4LURI9nEN9V3HQpMtPjuwY8JgnvKY3OWsBUX2ly5mLrBQokPs
WO1BHrh8VRLf+EIbunM/2Yy2sNC5kKWHkoO8YCfmxnY+xtXPT/+tRdx7l6rW
UhOTEIR2C5Y2TZEIFZqMYpGXLITMA68sVPAC/x+40fyEBFSnWzccLhqiMeTT
q04RBfOmgOx3vWRoszb7E7rWED2Vnpuw/S4AR6RYZV9ySVAzu4d9PtMQ9Z88
t3I1mgciPu+ne3GIkOH+YmloloWazviv6xwUBh/K+b13E0nQdiD9yWIJC62/
OrJzUEgA1gW+9o4YJoP3kaf16fu5+PL3MsZ7RGCCIK/scYwCOnZ3ZEYzmahe
yWDjrXReqOu20t0dQ4Yvj02fxI4xUcGWd2Kr14iCBYyX5gZTIMhtzbGr41z+
FIg33TomBrX86Ep9OQlofUtf169jIpM3qVHptoLQKTUeEX6BCES9/tTvYQxU
mR0ue+o4Pxyh3Kz4jEiw+LWdd4bNQJqCq2fvTfFAQ93y9URbMuRJ7Wrfepbb
YUb9ZnViFvHT1s8cmkwpQMhqjBnJZqBGM9GqtJ2LeIQoa9dKOAX+yy/q7T/B
RF/Lz94P0/+Dk45i40quFBC0yks/GcBENsRN6d8FF3Hae182fYoMjXxBUZ5n
mSjo19j5nT/5wKX3UX6nFRXErA/72w0z0dbJBWNTH2FYNAtzM52hAKVs+Igu
1wfVq8d2fjogAu2aMoeoXLx4CvXy6Swm+t0mo8MREobmKgMHTgMNPtXqYmEX
WejFvPsPibt8wO544BvdRwWjaFGfj1y/zuBX8RVMWcFr3qkOrdfTAbePquV+
nobo30fb5U5VXlhvLfHtjAUV9LR0jUVnWOix4o2To3GCMPVI6fvhUSpotMLV
oQ8s1O11OfLktX94Po1nKvkoDeKlmmeSLrBQ1rW1Sr2L/FDRIh6cu0AF/Yp5
2ch0FsKe71NV5hGBzyYtfAotOvCEdmSDQoAhktlIl6xeJQLPy9+u46zi+kL7
rVXHuLmuyO0NtiaEHzRsAjZFz1LhCLt/Y40NC8mq0Bq3my3iSb++HhU8TgVZ
X9/iu9zn3wfOiXl0LuGPA/W3tN8lg3ngw/PT71noE6FXjhrJAz2L7W4Xmykw
/TPhxmgIV2+FqFWlf4TBzu7byDk/CjzJEhdKeMRC88nCXaqVYlBUke71d5HL
k5BSIpXGzY2Mm2ar/VdDuQfHTucKGRy6RabVzA1Rxjdz4T1mIsAnfE96wzw3
BwqX5h/oM0R3CP86i4EfzvPsYyjJkCCK/Pd42W02kvpQN/2A66eVhupljufI
oO1yPsvnIhuptPAaKe4RAsvEgDwORoGyvJXHbUJGqPDT19P++oJwIaTa7w8v
DZz+8rJVTrLRnPcLL547IuA693n9oCMV6icsebJN2Mj2AdHMZUAMhE3L3p/c
SwHOj+OblnvYqOrV9ExzjxQs9tod2jJLgWCWQmbmSzYa6CW8+s0vDmO7v+Rv
v0yBi8mTJLqIEfKWuCB4hNsnvWp+bEq1pkHXq4uXfpUYod2WAqkniOLgccgn
ttVSBw561l9R22WMtppQK1zKRMDu6acztz/rAMHc03TZzATJbUb1xtOCEJfi
Rdh5VgdKTvcTr+4wQWubHBKW5MTgqHNhtlYIDdKftk8XWZmgEomnUjMBwlCe
36IxIkWFNzt3db47ZozSn1QIm1fwA3Nf2gSpiAYRfIJp5ftM0PbNlXtj6/7h
M+lLtOoPFIhTWDle8p8JEq3Y3RLOt4Avf6nXn8uiQYNCxS+KKAdFJRe2CDku
4efWOo4PVNPA62WKS+JZDvKff1Uucvc33h9w8HTLQSrkbHCYpveYIPF2rTKB
IgI0Z68+eLyWDPrK7pKKwhxEtqTEtw4Kwc0nQibvuogw4DzJucDgoMn165Tu
jxGA3OZzNuSsNoQqV54VbuSgmTtPJuynV/CXrIqxBSMSTN9iDF/vNUFX7R3n
/PWncc6l06zzVSTIazpycuUMB6lNTkqE5czguoycOXYEl8+yTjl9+znoUVRW
52mLBTxk8rKiwyMiqFhLmKAQDkJJVzrsLBdxjJ9wbiiUBIG9Y/0/7pig+dkm
zkalcdyI1SyVaUmCd1TbGwMdxkgxQTy77usUvqlvf/qfVyTgHZkZ2jdmjDZ6
aJp8uPobb1Brirr1kAQrr0v8awuNEd9Tu8Nl+3lhe9lUTHQ5GXRJt8aPShsj
dIgTFKfLDxHmXa2DfWSQShRKUflthIYV8kN78nigj5ffIEeHAqr+X+3mr3D5
vLhlaZLCDy5jWv8M9KlAmuoquHzSCJ3QP918JlQQPmpfT3ntTIWmhfq3//Ea
o6/vhBzWXlnGaW77zrZV0uDpM3eVkBfGiHdgxUN16jf+Udp8wJpMg/Wx9zPN
wQTtyZLd8nXbPN54oPborI0OzNQeKOw2MUEtxfvExDBecCJ3Wou9psGzWVL0
oxET9Ji91OI5Igyhs941P4t1YO20+4LBJw4KUOuzcPQTAfQi1n1ARAei9nqO
9iiYIvWOWk2172IQdnND600uz3ebXKjYmcFB1ybc/Xo6V8Pmwzs8BLbpwqyS
z499lqZIvNtkNuGHFJRcvG16n6YLtwZ6OtTrTNFl4UCrZLY07BLS8916ic7N
HSO+c9pmiC8mW9U8Swp2q5TJvk2mgTEpKtzJ3AzVO40YhnqIQaRmerOtPh1y
IrsE7yWZoksSf6NczUQhurs0YVqUDrt/Xtkq+N0UrTpalR+0IgB5ahda5ag6
sG6WyNBINEMn/vCWnBkXBhvor1N8QYe4++9G1F+YovyLwT0nwlcB4TTnBFFd
F+bllFOCWKYob55WGRAgCLof1J9llutC0R7votHVpujVzMEeeRCHxbahfRrv
9SAoX+WfhpcpWnlIG7i7XQoivGUGRPl0wV/XZG6HrCl6t7kt7zQmB5/deEvq
pXWh4pjx0bfZpig3GkJT/RXgy8M2mWAxPShoqJHa5GGKFhrvGGmEKUHb7Znb
WB4d/K8MTjS7mqI0ZXllYrcybJk19glY0gG0WmIdzn0/fzf69gz7qUKcVatN
c7cOeJXX7TadMkXZfcnqdkVqsLjP6aZMPA3uZaP93QwzJB+EiwtrqEGMiqB5
oDMNrB3Yn3PyzNBC64nRs6s0YHVcf21AMhUecFrWiTqsRQFvnl+UlNOAB3I+
e9J2U4GeZrw2wmYtGtz0annXWU3IWHmZtJafCjuZ3pZOputQj+QSyfG5JuR1
SNtGDtAg8hulwpJmjsjYa+8mIS3wWf3DZbyVBs2rlofeUMzR8RLMOv6OFvz8
t1A0EEqHpd0dIl2q5shlPKiP4KoJP7IsXmY46ILrrTWK1jvM0W9ltdt+yVqw
/jB0OjXrwR2hWnuTFHPE8PgQHBOkDadPVmVcRgaQf7Rs2sfTAslT76s/btKC
/F7rk6tcGaCYMpQcO2uBXtunajT0aAO/GLm8QYoJ4aUvldKYGBLlsU5VOKwN
/kx38QfCTLjBe0qrzdUCha/LuOAjrw3uhF9LVYkM8NQU/rnqmAVik+/D+Hlt
0AqevaWnz4SSvgGR2TEL5P/UdvXRQCJUrr31bkmQCf8D/kpF/A==
         "]],
        ImageSize->{324.4921875, Automatic},
        ViewPoint->{1.3, -2.4, 2.},
        ViewVertical->{0., 0., 1.7753036909777427`}]], "ExerciseOutput",
       ExpressionUUID->"f26b7f35-5667-42c3-a5b5-dd3ab5559571"],
      Apply[TextCell, 
       Cell[
        BoxData[
         Graphics3DBox[
          Line3DBox[CompressedData["
1:eJx0Wfk/1N//te/7YAaDGfuMvaRIXjcJbd5ChZQSkixZEiWhSFIUISlLogVF
JWV5PUn2bFEI2bIlW/b1M98/4DuP+ek+7tzlec7z3HMeQ3X0snRmYWJiGmNl
YmJ8/99P0ocDpw+1duDvrGXdZTpGMHTB5Ju1ayEWovFYK4gpHuc6I78k9eMf
Bmd/7ptw+YmHVBrOpp5Iwht3vUF5o+sYJHv2+9a/wl0bRRCW8wPLO/s4Jjt9
HXOtOLj2ljCEN2+9cJF8tAVrOqv6mxbKgpiSnhgOkjrwtqUnIUqJI1jYXiwq
NnoNm2bRfbNG6MEUVLu2uZktYAWGBs9eerCj0QMG8xSODuxzL3578SYLGn7h
aty6dxULEVwqPVXzFHNyfXj+gcM6FiYh7RR/ewVDGQvf6v4rxarCr57hjZzB
Iqru/1B1XMRCXE4+lo/ux9N+1U3s+DqBKYx9/FV9fx6jKO1O8wkvxtcilBan
DDYwhVQi09PsRYwp4Z+PU2cR9pGY/U4xkANVW1bNM29nQRSr02oGVwexHYVl
kx53OJFu+psUkhkrCvh9UYSL6wdWRHnulj7AgSL74qMvNi1gQSXxFbsMBvH4
ucC0PytsKIgzrkzy6STWnFR0u+f7VzwwptEk5zwveh7768j11n5sGkIlEktb
sQtjzdN7XTiQj4bYjPr7BYzpus2DftVkrODY0yvRz5kRN++3/Vt6WBCq6L8c
7FKI3YrmrW1qZ0M78DfOZypWsKJnzAGND8ZwE7bdx/FLLMi+rX+rvP80Fu/Q
npYwM4hbkqP2JT5hQiHRseHDzd+w4aWv/omXF/BTfWVk6pkVrHkIGzNqHcZO
Ru05UJC0ju9gxc9Vio9h9o8n/LkeLGDjdReOupnP4EKLefGtE/8w+6xvLZqn
RzBjx5N7Po7045SEI/wFSiOY9Zg3LV18BTsV9l4oX64Pd/Ul7VHKWMD6dNRS
P0WzIHL/q8OZhcN4hwdu17znHxZ5t+fOnD47cl/9m3fCewqPPaDpLuS5gLku
xihRm9jQ+NUrG+kvN/ACe5ZyC8bv54ccwiajeJDafyWfx5uZYKsU/marNzuy
lOhpdv7HjXQmStxzZOfxW89TCAeecKDs+C5zl1J+xMZZUnWQMIM/6zvH3ujD
hyKkfk+mOXMjXeXcT/N6//AVn4t8Yh/50Rfm/+5+nGZDS3qezgk/JnDnT9Xd
Jc+4Uahq4cbXcl5kRrDtbj7VjWe5sYbz/OJG+oZhVxplhRCT5E77t+9K8IIY
L/d+xIlQufGfohwC4nr5p+3EiQ7MSDK2OMeCHxnulit5PSqGLFyMCGTTOqwn
SyPcYjcPoo+8zV64QUKj0+xid+K7cF/PyRTdIX6kskW4XCZOFFUFK68P187g
FdGuORbPOdHgk7yXbX4k5JR5LN09fQ6nHSkLFUcC6JlJ9UEPQXGk2ydlodW7
iD/ufm8/eUgQBSxmvhkNF0fCw38+ajqxAp/FNguBXH4kmkFGn28Q0MLv0Ltv
3nPC0BY7puxnIkh3StZb00MENXp615jmCMDl1J2O6apiiDyhopTLL4ySureZ
3OYVAc6Zic/K58WQWmTR4u3fQsiY+LqcmCwEN9oMt8XsI6GUUWPC+1l+dGjw
brFhpzBUPHbP5RuQQqFcv7QDKPwoo/L8X48IUUCePEc6WcnI0GlYUmW/MHpf
6Xui9w8BVETlwwTJEih/a7EAi5MQ8jNla9lfKwq9794sf9pNRC9mflmmJ3Oj
ZB6j76mORFA9P82n/0UU7bvUp25Sxs+og9YXm25JcOJeOmsWTkJn9ia85/Ph
QIV2qp98t0tAplnvraQACWRXHxnW/Y4P5QzAD7RBgog1ArH7MRk1Ku46lsbB
gwwCxz3mHMkwbUIa/fxQEt2yYG8/eIEHTbQsW/hqy0KEjqxh/39SyDru+uc9
xxnrMKl92siWBYsEOZOuAjIyCvZXva0jhHbaqGu/bydDllOk6ShdAimrn3y1
7QI36vYNKY5bkoIbJoGNUisSSPWwTA3LDwG0tqtuLbSTDLOnjqW/SSYh6z9k
jspaHpQSWnxfLk4K3i1+e2rSLIl2Wrd2PQ9nRWtVEijPVxaOcN0jNjATkajZ
MUnHfHbkP+x+k/kCGQaFg2r6GPNjmPi+Sp1jQXx/fzzIDZOBjuLS5jwCCbWK
y0mF3VvDSpPQhKQoGXiZ/72qkJdCTNnPaXtO/cVEP+0UeucgC22ivudsFiRR
5sySQWzpBNabaZYuU06Br+xGrSb7pNHSpUfyMT9aMDYh1fCb96XBZDTE54W1
DALxh0UiqT0YRSq8ajRLFt5G92zwJlJQzpL0aYP5P1h42PFT50YoQFjT2VUS
RUXT14PK1ZdHGTpjd+94qBwEOvc8W3pOQQFz9/YEjLdh8UH/3FlX5cBT72qE
XRoV9cm5sd/DerDh65+4bwMVtoR8i4ljp6LIfglpz+pveEn1k83mJjnoGlk/
+/mBHFLhchDbrvgLd/JkRV1/5KGa3ViPKVMOMU1sPfKo/Rx20CJ0Rj1XAaS3
1DQVaFLRRPQlP9GCQVz/a9Co0GV5sDWQV1q6KofSMowVnh39gn17X+vMvyYP
+zumD8mMUxBX6Idk57uDWLT2Z0qbljxsHsprSs+kIrRWOPPQ/iNe038nx+0v
FZotY0uFx+VQs63UBj2vBm8+xyIflEuBb1KbK46WCgjo77yB/Qs2LRUV6F4i
DYTXvTnv2+RRUpQwub6gAxNRSD2e2CsFZ7vk7xwNl0dMX3n9PIaSsC2lsmyc
12Xgek7+uIWIIiJ5jdRYXxnFb5HL/A9tyMJyz43hu3aKqPLhzhNXhf/hoTfy
1LM7qdA9kNAvc18edRjWR9pNtuCqwj6539floPqh0sk/61S0w87j426OLiz4
RaNDxRYFCDykc2ezlTH/vzOJ75/14eUDsiP+KYpwL/ToS0sxOSSSf8dAJGgR
f9YdpZYcqwxNoWf8fzLLoVNCIdj8pwX8e9uKfsALRZCgOfzZeZCKBrjn7Hvm
ZvAbiru8lI2VoIvddILNj4Jcbb1u+qpv4M9kVn2yTiuBb70lW2GeDBLVuTjs
x7+KN5vu5kbMSsAn/+XKH0MqqrTHTJtiJvG/9Q82zzArg9PZTvLpt1SU5l/o
5pzYgQ9Ku1qJlyhBZhFLsOKqLJq+/O+zzoVBbG9AxGbSlDLkVfzs4+unIOM7
Ah8jFmcw9R3UdBVrJWj+9yTMTFgGPXfokvRj8L/5/oS5l4AyENf3zX1noyCD
s5ZcBSL92MG9updfHFKGmVh69nIcg4eXr0b+DOjEctKviUpZK0Py/ZEl2yFZ
RHF/O7NWUIk7F/vb5g2ogPF4Bu9oFgUx5Tvb4eNVeOC5czYF12hQkOKELWXI
IsRkP73V8DNuPdG7clpLFS7YG/09rklB/sHVW/f1zOC2++QS/taqQqH/c/7u
67KILJB/wLtkDL8bMTRjj6vBQks9+TCvDJrejHwoo1uPn9zmm7+XVQ2a6wPZ
zjpIoQsXre9sG6/GDXjvbdMkqUFslbfnnxUisv9gz9P/bhL/nZE+l1OgBpnB
4+3fKeJI4RWWaXlmCY8/VBy1cUcNIscy3zR6E9GETV0Mr8sQrtuouJBfqQo6
+6tbFpmIiBx0xeSNUD8+vDuAx1pZHSrWlw60WEmgadnfO5xUvmBrJfJ1sQLq
MLAH3Sv5LYluJIe/Vc/qw19VC5/7gqnDE7rzmKSLNIqdD30Vs7UJW/7HpXdQ
VA1YvPbWO52koCJvPzPix0kse+GwcdsZdVj7+0JkqxujDnJt7Fb4FHY81/2A
/CcN2GPG6/wlRQpxzCwEqLssYVnZx/S+xKpDnUu5/85GElLxNLW6MDWNCdx0
s5w6rgbh1366tbwRRwbJP7fG6w5hgTpHz/2ZpsMtETXNfZUiiPTE7pJTzDQm
0nVMbyGDBjr3LO7r5Yqh/b0bhc9TFrCSo+H+rlyqoOVZnpJ1goiY4l7FnzGa
w2TzHHdMjauBcfTr8T/OYshOWunc64cbWNzaBNNLmhp4KfU8acbEEMrZybLV
ZwMru8zp+NCTDgbvH+swb5IQj5KryX932ZDNi7MpOmfVgMv/VGs1JxkVBKQ9
kctfxt71v7ifn0kHrfcaXd5UMlKode9bP/0P202Oro7jUAMDl9Xr4cvSaJAS
ktCayowOHZu4/VVTHWIfZ92YdpRCE+dvngnmWMZCeOt1irXVoEt86kZBoBSa
M1o+HsA7gkmGvqui2qnCywtXaN/uSKDm7Ik+qYUGjPD1LgeQVKHmw/D5k48l
EVP4rpe+Fpl4zocr+MtmOmRfT7gZHczg2yfH0Ob+ZjxG07uYc4oOs0zTN6W5
ZdAO8fS3X8J/YM9b2wf1mWhgfFnZQgWkUI2hWV2H+QSWOyGhyUWiQdfgAdNH
+yVQyZYXaVy3+7Hki35jJRo04AhIa+TTEUeXyZRfDixLmNWzxw0n3OggWat2
JNSJiAruPbo5QlnHzIuSuzqjaFCmvjNViiCFxINYqLvermI7CihNAhQ62Mmw
t/r9JKOFf0/kWk9PY6mBSweOVNJhOjz7v/s9sqhXm/586skmtgXUIq6RacBf
JzOxsEcGmf0ronVwzmAVzJW72G4rg4hugdUNISl0KoE30yB5BdtedWmvtZEK
1Ob2TpzbTkI6dnqoZpUNHXJpvyYbqQTm20hFaZliqFHn3IFGEWbUevl8xbyV
Cjj0qNawzooh12oDp/hUNnRClpD7dZQG2wwexfR8FEW3xWIm+86zIG5zs676
eBpUQXdJRZYIWtIoDr4txIpE7orGbr+gCuMCpJ4rzWLopV2awLPgBawyyYkr
1IKBYxxHJf6ehN494rrne20R+1oikHa/laEb/UerFSdE0ZvIQsOtgr8wgfr1
2dgIVSAr0APYygnINcWkaDG3A7tYqrw59pIO+uc2NwI/EhEXU6jnbqMxzMP8
kkC3IB3KbNS24btIiGkWm2uzTsASuVq/P7CggXuni1HbHyIKOlb5r/3sJK67
ev3Y4hINDiawF6juE0VBFV3CV8P/4pmefn55ESrQl8uBLoeIIR4+/aU96sv4
Lp8djsFMKjCqZywVKC2CXGs9uj9NzuGNq6PbaaMq8GTtp7eDljByTTe9MqY3
g5ttqiYLq9NBKCS3a0xRDA37daTmvV7BD8kXOnQY02Di7ff+1wMiqNCvc+Lo
6hI+ahy/7/YkHR4Wl79V2xRE49x92T/n1/Fx5YDi+T90GDzi6UzdFEENb6TP
R7es4iLVvMJSD2jgpKz/ZHRTDLWaGR5dfs0OZSzqO8T+U4Ebl8otg9QlUHW2
147P/HxANY1v/zWjDDZvLfBkViLqTcxyjqoSAKVDUopt/srwq2+X9/MpMdT2
98g2lMcFLoG5DRJeNPhn9esw9w0RNDx/6uB5Pw5w2lG+r1WUDt0pFa/zc4VQ
UdKDg/77uCFoKkhiiy6Dz4lK+787CKD3PqrbTGUFwPP50GSuEOO+F1MCI86I
oPuC7ziLtvNBsHSc2FwpHTTDR1Mqvwgje9I5fvkNHuCSdZ4ybKPBOEuUzben
ouhGfJjB1GtW+OWeyCnL4GGVx53yC6+Ekc7DtFmlFkY9DSDOSlAVMi9YJnna
iCIFnbM8lz4u4UZjUtEfbzLGf81an3EmItXFRxPtGmzgt86yciCODpYyXue9
t0mh7/XMewiCrKAWoG50s5wOCca+6u0PpZDauS0Jn7JW8F72qhbJMFXw0dR+
G5hKRCpl2Y0PykbwyuqVaZ5mGrxb/nz66hojj1zcsrrZuIibJDMN0STpQADz
hZ2xYsgnlfi94/sCvqQfrsm1wMB3/JpWYpoYWrKOTfpmvY7v9+BtstCmgYv+
vrS+NBGkJOgTVCv3D+/stRclXKJD0jlPX/snjLyhyfn4wsIm/m7nN5dfwXTI
GxkcFGkQQWEtfxLlUhi4m7EUHphWBZlL7PtDk4QRs3voG9tabmAOY3W7PKQG
A+w2Q3iOCLIl2XXsnueEHUx/9g9sqkN371dTGkPHSjk5JxswQbjDR8iMs9EE
i/LNpC1MEujtp0NDv7l4YXJfeYsrRRN4jI+VNPiSkfjJpO0OD9jh97HNzgFB
LbjxRt/fQlQCJdz3zkp8tYmLivMoTPtqgjkNlkwkSEjDP2guK3Qa17/r8mhY
Wws4dgxcDtpBQg0pKe7c47/x+XaxwbtXNcDooP/wuzEiCnlVWb/1fDku0LZz
+GiGOpCGFEoChBjjuzZdF1RasJaymYbyDlVYfcn5+chNSSRal1kf4TqAz/je
YH8kqg79dz48inOWRKccBvRrkyvxU8RXF1P11SB/56RvwC0SurCebpJLHsdU
RmZM1vtUIfK/Watyxr2Q6ylHlXnAVzbqTWtK1GFhY7SM1ZnhH247pl8VqsfL
Gi2qgg5qQs3ey/vL08RRSSy7q9a+fvyAy7HDVz9ogFmfga3KFEOXEsf5hFOn
8YUfgiV15hqgYKgLP0+IoQtjxhv/3ZnHSYMinlrDakC22/lE1FwCRRFEnHhz
5nDv8WlHvxdqEP+8cUIjlojMnq5sOaHciR9sq2/e1sjAXaAndXsfEVWqV7Fy
yPbhB01vj2p208HPUnqpPIaIKNx+C1OsVZjgia2pZcGq8Kl8m4l3kASCz09d
NKvrsDpnw/IKgjqwXHez2sLL0EmRf/XF3Z/xa2tS0g901KAgbpb9VKAoYvrV
G5C9FoNrfBedcPtJh86G3lyXBlFkVr9n8gOlH0uY+UUX+EGDEz+MnoXfFUUU
/quhemM12KuusrH7sTSwW531TdAmIpvjF7JOPR7GBv7+9906VgXClhz8TRj+
RHJQ5x4+u4Als7hM+MwrgQRmbg0FomjO+Y/XHUsmlCeuK/uoVAUmarw9GrlJ
KMJy15Ra9xxW5jlslRStAkr3fxNUOcSRztJ0ifSpUczCOEMvjZMGzIrrLA3J
RHTq+OVn4ZEF+PmnmdLEVGXg7jT3L94goOe8Z9qvWnfjrk9l90XnqkD2pkvi
WyMCKhnecSlTdQCnlbpHhZTS4P6VGyTFIQI66jnv9jp5Hj976HGUxUNV0NUV
S777TwgVBiXyc2ydxq9/SnTO8VOHLjvDs+RDwiiCu6ROm2sD/1q2dfICg4dz
hIjuZ1OiqNuelkOW54B3Qs+YyhM04FbHa5W/FsLIsM/8j04qB8Bx9c2jEhqg
LmXf9egVH0rbfd5iSmATX5W08jpwXB2yBYOclS6wo5XjNx3VQ9fwh2fYxvUY
fH7pp700+I0Jpaz90Ky3G8MtuwPaPMNVwe17rgrfO3akn1gUXb02h0u99Q6w
e02DxCbMc3OYGZWs6m4xYfCz9QOW8ISoAqeSGl9+tWVBDYidq/HwJq6/axbb
mqAEunE2KWd62NHxoHfgHc8MsXaZmkNliuBXcNK2eHENI5WFkv95LuETvypJ
/d8UISuihCL5dBOLVTJoWY2ZxYUiNN5qv1GEl2ameWN2G5jTsSiNpIOL+LGP
9aGOTYpQE+Hu3ti9jBmNtKx6nGeCES7VnHomBRD6zhdX+3oTiyw26HYqmceL
nZWlttjIQbLA9IPxqDXsq9vN2u2CTPBRptb2+GkKsNz0y2qlsKF9Gg9qnQqY
4Fw4ZdtGrgx8Fz/sq8Gzia3hnjbqBHb41DJiZ2NGAbO6+2sxsWzofmXBBdEI
NjDQ2tXZqisLbh3DYulKm5iTWZ5/vQ43iGgoWj6mUiF6p/iuk7cmseUZrCYy
lwtK8PxxwWQq6JxrfD2qOIv1u7ic2NHJBX/DpJ7w35WHd08jacOHNzAf+9GU
1XVB2HY8NpGtUgGmfYdsDq9MYDTC5qcePgHw0L+Z9CZREZTYPgU7GfzDjpvs
OL5Dgx8kX/MfV/qqANYOsm0dhZPYDig2N/PnhOSbic+snimBOGGY79boNNb7
oV3/HBMLuFVTwsNMlaAqpcVBfv8s1rPO9Ly2mAM2pm0KMywUwUxpZGen0zBG
337LjNdKAASP2RreKZIHplBCr1vJR/xFqc08W40AqL/ZvH1ZVR4gqf+xP+0d
toJSeZZnheDsraCMO/pUaC6Ljz52qA3z7HgzRhQSgv0HjrBykqgQuyj5MPvW
BPaXsBbdqC8MBTK0LU7pVBiQZg/KX17FxIO6/HxUhYGUb03jOCEHnwzbidX7
WRFyUZHUrhKGNI6P2xyjKdA9m33810cuFPDRpp1oIQSFxxskOpYocLTD/cir
F9yoOCzzXVuyELh3e77aelAO/m7eqtd/y4ncXDRZZ6lC4LryX7FiAwWW1uS3
nDHiRf8I8fQjDcLAFRdme9GVAhHTpuSuRiGUokop8TkpDApCXAIK9RTQiF9w
ErjEjw4aeT/Bf/IC1WFPVAhj/S3vYo4W7eNFyfMBY3tecYDf5nNZ/lEq1K0x
bqYnjGatAq3yDwhA8/SxkqTH8nBK2dRXjFME7Zva6ilSxA1+8+Pmh/kVIeJh
70h+lwDKNd2jZSfGCSRqM/3uFQUQ+IkZWMQJopkH82/6vHggdGdqXMM/eRg1
po7ccxFBXpnkLZcO8cMP3tKdVp6KME15mn/Qm4DYnH9v6RcRhhaLyqiMECUo
ePp2s65KBGlgYMM8KwwsRxw4o1YVYJy2LnSIUxQtVhWbLhBEYSXXtf/fGyVo
1j3V/+qeKPKdHLT2uSIOZf78v3PalSCs6q6k5H+MHJ2q99WjSRzupB4c8Dqk
DGnPw4xaP4gi0eydnM+CJaHAae3Yyi4l+GXMrX7BSgTtPbhH9rANET6dXZoV
klaCOlaXWbVTImj8S+vM1HkSPPl3z+jcEQXQ/4Lu/LgtjKJWPPTaJEjQatS/
oJYlB5H/igYMlMWQI92EcMOaBCojSX/GLaigp/ftFHejCHJv3x+spiIBx2vU
HvVXyUBKZsq9qQYCsmh239PQSoak6/ozuJc0fMAT3Ad5xJBSY69E3VUJqPlo
lKP6Xgbkq4I2HUZIaM7vPK4mTYaQApk9ldOS4KNYsSvfgIwqNoxEkkbIwLPc
1TSVLwVHf1Q4BbyWRsLqYjfmRCSAb7q1QLKdBL9cJ332fZBCD0wPVnfGScBk
0xvu9xqSIF7G1CP+SwLV3PvOpy0pDWLFVGauXHGQ/31zYaVRGrX2HZid6pWB
gJ9/QlvtxYDKUT9Y90MGuVWPaLOJU2HLafaIcwzcugcUwjm+k1HkWuWO7ekU
CPFCCYQHopDVccnNwk4aVb8ffxXfSYWxl8nBruXisCVlZHE9QxpN2va/4tan
AD2jYur2IhGWDEXmde5Koug9kgVxj6TBSbxSJPYYETSkpk8oJzB8V5XC/skh
WcBcb3mFvyZAOvuduQA+KRTR5p2/oU2GMtnyVvNscdj0IF96lMXIp/7iNwfv
k8G8XU/zxVYSWG4dbRP2JKPToRkF019IoMs82CscRYLjlWKX95ZJoCfhOUqJ
zkSQYb/ZO/JEEl4ipp2HhUmomXOM7XaJGCypNM90LUiDq6ZngGi+OALWONG7
N0Wg2Xl8PDRICtZ8Of0LgsRQ9ov8NUxPDC56+38Z85aGldcxCb/FRdCqTde8
DwsJYuciDe5dkwCTLty7UkEUaRB7gnm4xKH71zXnqhES3P203vD4JwGRnZbI
VG0iZHxTyP5tT4SGgPrxWisCYpraQZpbkoBx5wPcJFYpUEP/dv1OF0KnfNnI
Dr5EsBh6N9ZwQhoUlH/ukZgXRm3aZqXD8hIwpO+/FClFBq4fP107WYRRs2Rt
VxSPBIxxJbB7OpIhmHn+zikvYcR9qKN5VUEK5LQnJv0zZCFt2vB9/iECEvlb
/CLIjQj7Es6cTD3D0J/8putMeeKocOPC8ZFuSXCdGrT8EigNLZ07rZZjxJHK
2E+fYjkJOJT6/PuVg9LwZ7KBektUEpFvj7viAxJwx+kCi/msFFgr7I76Z0dC
mX4tcpGVZKiT/ifP/oIMu63zXg0gcVTXeCaukcFz8hul++FVEhBEijnZ4yeK
nL2VvhvFyUKYdfHS1wwSECL2kNJyhZEAyV/YJIUCXduWLJMZfMs47S3MP8aP
zo8//aM5LgtHXxj/Ej0pBlsbrshf4xJAZtaVFM4JKeiqKPGMrxWDbW9vfTPa
xY1KPEwn+leIoHOo8/aJdgJU0uwL3dIEEaZ9wVYoTgxE016lrMoIg9JHI70s
FRHEYXBokAJEUC3dnNhlSwD9KelcSzER5MCsk7/diME/ZZnZmWQx0DFyPGQp
Joz6+XlsHriTwNplW2x4NANPWjallCSKtiye2v/1qwTc523w1/kmCSfcD6MH
kkLIZZtfWTMzo88Xq35FD0lD5ZZro4EnedCAtdLYKBsJzOSVy86dI8Mt4U8P
3JcFke6pKKasChKIBxwwDa2VhXJaI31fFgE5maQzu8SIQaQegeR6hwprCS5g
NEtAllabqIpGggjapuj6A4a+qdxR3OIvipZOO21PnCRB+PcDwrZe8mBLdtkh
8V0IlWqd791HkYC11+art3vlQKPOdardQARZJosttDH6YYH3sO67fCrs/HV5
T6m3ENIwvcTl7iMNVbtqjpc4yYHVfRP7gDcCqMY+sYTNVRIELnwQND2lAMcs
59OyM3nR4MYpuT+zZKjKTwjYa6gEaQLmBz4b8KEUq/DK80IUWDStMbI9oAxh
8ZmFhFPCSHTSuTf0tDRMb9RfX/yjCFU8ygLGzUJIofPW8YCXMmBtYrvNKFYZ
ckYli/bjIujlhSsHsl7JwDkHaxWhGGU4cG7b/Le/QsiE1ZjHVFcaThzie3zy
hzJYLOp2rUgJo9tvPtoIj0jCycHD7iWHlWBHj9AqI7ihIX35qs/tMvBxYOIo
62UlaGfXy+9KIqGwuv1/rUrIwKf38eC8rzLYaO+18XIgobzoCsfzShSwtpMQ
Dp9UBnVRh9KGbHFkglqozZGyoCkzOXJsXhlYXv/Qyr8phv7o/nf83qIU3F2J
Gi9WosHQVY1x+2AiKnmh/L55jQQLD8++OHBLGcwbHm6vF2D0y8DAjno7Mag/
1VX9TV0JZI6fxOseEhG2uyxp+1sC7D/8bPfuh8pw/3CyoEOUJEra0ZJ+tlAE
bkhV3056zfBjBlNNT2RlELtRqpC1qhC4LbS8ty5UhISQ+Vc3Wskor4XvrVYt
D0jyT5snMfYtLpe29dQlows23C+5Q4Sg0erzr2pWFfh5qyiYPVgC+TRMT9Sf
E4BrM3jRlo80cH+ddSVhVhJpXeD3P9fHDzY+kXurr6iAbVjON8YhkCQpQ1D/
PAeUbrvWMRdBA9vx81Fld0loi4XPnwtOLIAsuY11gA4hbk+DUoZFke7zlL0d
n9iA5Y0Hc4OfGpR43Em6nk1Cr1+mtpsMMcF4Izst8RYdShHhre8+ccR2eebR
0UcswKUhH/HBVZWBF8t7Q0Z9qpVU1M9f44YIp6jT+87QQbzI3bPqPOP8LUHk
loc8MNdxhI/3BWPfogVa7YYYkqTOfVF34wTLA+yCV+NVQVDN8uSeEDG0dz4k
OlVZAOhedxXSvRj5y79gzOU6AbW+DXqDfxaE99vtD6z3qsIv1qVrQbgYkmDf
86rmkgi47/blPCyjClYFInw5HgR0Kj781nN2MfB5LxeQTVeDC4HNVrofhNCN
fenmKRwiEHF1XettGR0a90QKXnrKi1jKtM9fjxMFQfB97fuEDouLuzh33BZC
zks5P/7eZ7wf3KbpAyQaBLT7kcQHuRH161ia9aoYpHt/Ln5hqQLa9feJpl08
SO7wgYUzZyQgmfvenl3PlcGKd3qrrhIb8tEhhx88KQleJ0MoUWuKYFImgFkQ
2FHFw8f9f+fFwcZM5WHBVQV4/PNK3FkvXmSsDdG3xCRgqtJPKuO7HDw/9rks
4TQH6onbq8VvRIQn47ImGdUK0NRlJPvOmQ/VxH2R/CMuBnrbm4aNSUrwnOJd
Z5HBgUJyQnrolUTwZLJm6k9QhhIr3S9HL21gcUVPuuUtpKD75PoYf5MKJARK
/4xtZkHDr5q/PzxLhM//vrUXstBhYeyJoOv2RUwOu4b7k0kQptQ72uykCu7f
/VvyqiexOkOJWtbD4hCllcN//CcNauJjBd5m9WFcSnIjUiKi8GuA7i9oqApq
PlnVZX+HMU+5C/QMWSEQVY06edRHDfw9FzrO8q9gBTfuvrPfIgzLQh+SDARU
Ierdp+9bj05j2b9f+la4CoLnwkfiu0OqwKW+LHt9329sI9VKu4Th84MK9Zx1
+mjw6bV6tmTbNHbZ3E1+v4sYOHGs3H92VAWWwKamP3sdIxGwg9yFwtD14fhZ
5loVqJczPz1wlBl9ZToYluorCmG78ll+DDBwTI/0tQ1gRn2j/NXrw6KQ0nTr
At+mCmyaWrT/vsCMVNFGulUhA6+CdsdGeTrc5xxZfTi2jGkGsC2/ZLx/1o0G
CeEWdDgoPK63/PMfFuffk5KzUwweM80u8zB4VZEZkyqVsYGVbYgPK0ULw7uw
hw3nqWrgPEA8aTfIigyW/W8QWoUhok3UitBCh0tvDl9pv8WBOltOvL/tJAK0
gsvuMjvVwNzW4sargE1s4Gy48dyoINAe0JdzlFRh9liOB8soK8pon/GjM/JO
1IDB7ysddOjSPXn6EG0F61NrSGtrFAF5qb1q2xn3bf8uc8J3BzNSvM36YtVe
ANxWkWi/CQ0uCimxqxM50SGZe1Zr+7jg/iQ6HBVJB7Yrootho+yozezi42Fe
fshgiVbdfpIGFrz7P0ht8iLNZ39/X+TjhucRpkZyQIM50n9X+rP4UVmcUeau
b6zgFLhBbnSlg5mm120ZKR5UoHkwvKVkDb+RHCL8lpcGuqqWF22VuJB4RZiz
BxcLxP3etc3+mDLgy3MuFV0caPczgzHKJQ44ZHDG8VSCIlxP2HvKcoQX7QD3
xsF4DvhpYqn7da8ilKz+XGk0E0KPSLKrgX/Y4cv9+jc0F3l4Ofo2IFVdBD2a
qpp9bMcPwiaBMR+V5MB677Nreo+EUXElx6U9vwXhykatupyVPBQ65aSFbIii
ED38q8YgH9Q3BXWl8DDy7MMC7yI+MfTf9bSLDwl80LGdI6/bTA4Gr12++uUM
EeUe43zN4ioAs3r8x9EHCgiJRhKzSononMRo/afbnLA2H+uYpEKBfd6H6pob
GbqaKiiesJ0duCx7QlTWKHCorqM0wo+I9CQJ1A89XDBJqWN60EiBOrTVtc1Y
HFW3hM6aavOBgsDJ8JuKVPi03bzq4kUCsn1e3KSwzAtq9fHty08oUJbzJs9v
RRiNXRQbLP/LDqzSZ1TuelLBMOOpcCaLGOI7K3YrdAsrNB9nCl6WZ/iQK6m0
PZriKHXhxF7pfjYoWzjHEdghDyHCwHy8jYhGyu/VHFnigoreOuUFEwVwTWHq
rGkXRR/XeL+t7uAG3b4Th75MykPX0qL9nIAounhqPd5bgg3Il70uDyooAtGw
wdUkRgSdkM3V1VFmgUtaF7xklhThzJJ1E/0VAVnTBXWeFizjs+Q7n74uy8Nv
9cSAqCohZH7XW9WrexWvofDP3U1UgLKlyZ/mPQJI/XVa+/NwVvjvVGLdz5MK
wB28y6JdnYDM7JX+Gu5axBcElmktWowc+ruZJZVMRBf0OruauqdwFVuQ9ZxV
hIWoFPZkZxL6fpjYdlhmFT98e9vfi5giNAYvJD3/I47slK7Z5kSu4cHrJlt+
jSpClAC/bmUFCf1Zut6zV4gD/Jms2bpDlSBC58WDVwckkXlpi1720jrudLgg
+4eeChw9d2J/3LoU6tUZWkiZY4b4+QsHPn6mwUrwuqBEiSTa2xZ44nsvM2TD
dJLTXjoMeXgEno0no52PvggcOc0GmSWjcfK1dBAwZZaRvM/wFSnmBhHcvHDr
5mWVbH86XOFJmtTPkkZaNnQrxUP8sMdFTn36pBp8j6xfgE5ZNBTyn4l6uAAE
buYd+PFeFfRO0zLW+ykoMzHPreCDEMjI3Hp4IFkVkgPpcl+eUdC4keF4021B
8GswkHMsVAX61S5uwa0U5G5vaNk1JwK/be1qHbpV4eDZ/qzVcmmk9EBnf8YK
AXb4u/s5KKvB0I9F3jfVMijv2UJKZ7wI7HewlbXYpgphG+yHKZ3S6HtW6mZ0
AQEmXuWJ/YtShaWTwmfPLMugIW3P34lOYqAfy2cqeVYNchI0W39WyCB97bdv
qYVEeMX5BE9JpINBIj1YNYKCPvZ6jMlVk8Ap4cbIVw5VGNcNZbevlEYVSid8
Er+RoIrD0+XJBTUwGeLMvNwjjWoE9O/rpUuA9OYUt1yjKqw81HH+FCON/CSu
meUzcpdP+3yDPJkOQf15kdX3ZRE27HDW/REFCgo+Fa+M0CE9O7/m0zQFTV6P
2IJ8ZKFYxxlzOqgGRssOjw+9kUNDoLm7toICPanZiVv0NODjWXYfHhkFlBMq
t8uEkXuf2pQyAowmfH/QNPyFLodE7iq/nC6UBq6z+gH+pZpA+H7z8eO/csig
bW3eNZYCJRKTLjkdWhAY5vS3oF4BDVfJmgUzcqP9zPPnN1S0IENfaFeBvyKa
YJ1QF9tNhYOVEU/tujXh1HOpa45IES2LjfLXTlLA+LLonPdFTRg9ujIynqqE
xLy9Xp67RoG3e+MHjAY0gC5uMqGvo4gOXtUxm0iiQIRxDGUjThPyQ4/0jpCU
kU3S0Tc1xynQ94bs94dZAwgnuJyOmiih5+YqBi+fyoL3utUFwns10NtWeSKs
VAlV9U9vc1mRASm+oxTNIlWQeqlQx35VEVVSjUkSblTQj2cdHQhXh9c5TbVL
pkpIPHQk5kOLLOAGuZdZXDRA7+SbjieaiujJw3g391kKdBv6TdtqaEACV5dA
zQcFFPa5rtpKjwKvvgRYXjHRhG4mg6rXe+URZ/VDF4FvFPBbkN895aIJpvmT
nX0f5FFscsw2Z2UqCA2UdTtEaUDsNY5yTEQOmSzbZwatUuHkrOQtEx0tiNdf
4MgwkENZiVmdK3VUuENWiVmr1oC4oFu+ASpUxCHHhnV5yIEr1cT3zmsNGA+T
ZJevk0WmEQWHiquokGaxucF0Sh3KCvqfiuZQ0Z+Y59fqfagwdKRxfYbB83jH
xttxZlTU5HX+RvqkLDBj2/3ThdVAKR3jqbejoOieluIzTFS4Zv4dIvPVwG96
zx2bOVlkXDr/KOMLFQb0Ui9X+atC0sw+dXUlKkobuvxX+CgV9lqwfrvmRAd3
0uYRPx0Kcr4sXGl8QQ74LwvT6pvp0IS9c41Jo6Av1/6y6MjKwWsid5VVIg0G
Kn9OTh+RQbVj/mb+lRQQbeNM4r2vCjkSe6W0vWSRiwppc9aRCtJ/j1Xf11IF
M/tPpH4pWXQjXOkw0ZwK3n0OLHa7aTDOZa/7REsaGbdaimf6ysE5LsLZIzM0
KGQLly/cIoM6/tWNbhNRgOGsgsaBPlXQ4LTRfr9GQedufW8OzVWEJ7xp5Y/+
qMJWOvHHr3gK4rE0da79oAA3Khy0v79Ug1O7KTF/x6holDUvD9uhAEF0tZAR
Rt3ME3jwy5YUNF/neK3TTB6m/N0kbXF1CDsx5GfBwHfiqGHFC8b8qqPyeqJN
qpC1GuL04DwVYdXDxTvL5CC9+WnPJQl1MOihl62BLAoWD6ZvPUaFE8lXGCZI
DSieH9/dryOjlfFPu+8dpoK5/75WzYfqcKlcrqeMIIECfKSdJDgpYGi32+uY
jzrUXtl0l70jib7Sd/2qfSQLe8bm3O33qEFlnUD+8jgJ3WqVjjt9kApXbZir
VyoZ+6aofBDBiShZ/lGgVw8Fet9WHbpopwaW+Z6G715KIsk605iXv6TBy9u6
K52mDqt5ytN8FRIInGRPERk+oMHs7c35c2pQyudVe9FPGl3QzHEQOy8HVjhp
WyZRFRxT50+pNcsiEW8RrrksCuxRKcyaSqcB+XSggUK2DFJ7uFv+xbw0/FVv
2gX36JCK9d+pJUihhePRybFnyVBlURRU+FMVGre4rbwiyKBKvco6ehoZNPZS
pmO7Gf5WZjasPEsKHZRvvX3FUBbU1IsyzvbQwEnKoeuzryx6lLVUFC5KAQMn
8DhvqwqkBwe3hyRS0K3nBzKWLlLg02TgzYksOvh8232H8wkV9bRukWtMkAH+
hNz/0hh8GIv/teoZS0VlIuNh+FdZiPhwXXQvQ+d3PMv69dlaFiWocwdyvqAC
1V3nbOpzVSjjvGWcO09BPVZLTLoOFPiz1PalaZwGMpQJ4c41WXQt/rRCMKcc
3FbxSq40oEOaVeo6WZiMlPrrdLSrqZCjGhJt2UWD/64b6W0UyyATjTr9NxlU
+Mfuerj3FQ2eHrP7RL5KQcRtRSGzAnJQc8fPTfaKKlQdzPcc/UJFCjs64kvt
5KFsPbBzr5waTO6xWmpGcujYibH1hUgF0El6/XdUjQ7/WW3MXN6lgJjlFvGO
DgUoJTf0FrUy6un32SApSh4tvvuPeumTEqzp3W12KKIBU8pL1a1yCujG8vKz
tCAlOKYR9/K+Nx1YSo9NfL4rh1J09kTeaVMANpWFIL+jdPj1oqf00DYq+upX
+UxtTh743BXyMt+pwB9BOuerIln0JP3SJ8V/csBOyDz3wVgZhDrf8+2tJyOT
xTWmklUGn4keS1xpitDMYcd7blAWLUSc6VamysDiVLo3W7sCCF/gbyiakkGB
X5iOhCVQYCPJhzWOSx6M0fTw1TwKUlhyFFHIpULzviPrmtZy8OVs1s0fdCoq
Lg+R3g1UKMzt8/jWSIXUxlQJCUUqylrc15iizOjfDZUFqxAKPBKxiVhIpSAt
v6Wik3NycPRU0L5vDD1Oc1G57h4gg2IcmZ1VTakg2blb1PgoBUR8ZYaI0lTk
Mp7jKc9NgZRDdhZsuyiwy3VpY/IlBaXtM8ofyqCAbzp69UheGnpeOKRPPJZF
u9t/nGWfosKbVnX34hxJsHxtGr1Pn4qOH9btszVl9JfREcNWOQk42zqVofpZ
Bj39HU7G2qQhdOKjLp1bCozNGi3fnZFGzCzjT05TKFAZYhtxRJEIRbE1Vd59
ZHR54okBsU8WInm2bDU3koD/BFXmH4SSkdtu8ZKEclnQf6xV8+gMGbgJUbZx
4zKo3a4uh/RVBoJcnIflqBQIQWK/f/NIoyHH5WejXtLQMPJZ3c1UGoS4mV99
q5FESx1zhfYMH1IofbzvxF0JeH2/VLjLThoNPw4PbWL0u+TfYMVRPXG4QSp7
7PpIEu1KuDCPxVNgvEOlYDiWCM1v93/edl4KvTvU4IeryML4Kf8jd4tIUCYR
lcHKL4M4bnq6t+6QBp1gj1smF8UhT5tzZ4qxLDL42v2UEkYG3ddX8qQDxKHi
4hS/8IA04pmg/baQkgaDq465GalE4AWN4vNhFDShn/yTJsTQn5dNG385xeAT
f8bIm14KWpRu9XQrkYXPmXfcSQdIcGTQeNBTWg7JmPQHPxBh4KjkiA/oSsBj
wkOdGE55dD+q9Nie0zLQ/ZOc45ooAVKe0TJOB+QQx4t7M2/jyJB2vu5z3hlp
qG6rtfb+IofyKnHssIMk0MWUUpRBGpLUjCZtGe9OncsZ4du5ZDCZ/9B574EU
FK+HSJyjyiHzO7TaA3UMvO7L7Eh0loB7yaWGdVZyKDpbWJXMToawt+4fNN5J
wEnCNtGTjXLIu2F32sRdSai4Xu4xpSgNTaGHp5lL5JHltYRzz+rJoBdbH9Qg
Jwtw1cv040d5xEc/Ni3G0M99F1lfDTpKg4mqnpliqTzi+VbgXFEoCVV2NxvS
GX5wVvD+2WPRCqiYvVMmfpMI/r+f23SyMfSy/uyNj4vyyGa1qS5Vnghv7hWk
ad9n9NPfWzXELwrIWqNL7FGRBERKpSaq5FLg3s8deoK6CujmQkJRcBUJmA45
u6o9lQPuyaae8loF9Om34IOWEHEo8zj++i0jT008MK5tMVJEEVc+Hf2uSAC3
Z69JR7gVgKX349F8QWVE39l+eU+mCNzKudjbRlGAPMHH+s2vVNC7RVENl2oR
SPNcmcViFEGG4/1pwdfKSFPErVY2VQj4We6fseiRB50jZn/6A1RQxuNHji0V
AhD6I3qUJCoPz57xPOsMUkaS8vN4bi0/uFl3GF3ZSQXxWyEL6QHKCHMjqJiX
ccHlYEP3i6UUYHa/ud97TRGRfnnvXG3hho7U7zoflmWhbKUt73egMrq5x+VK
zAA7eN57rFjUSwXul+uLmYvKyPHY0R+52dygs2z08Ns2eci1F3YK4KWhbtvR
w33jgjAX2a1dGyUHLCeFnh24TUfu4SeD1I8Kg/2/W24+nXIwpH0s5osoDZ0O
alAZMhKD7/ajlJ48eZi3PIEJW9HQOzWpRJIPEajZrG8iLeQgJ7NTu8aHjoz6
ipk8GDzEbALyH0ZRoTe8QOF+PQ2NO9OIr1bFYbjrwfnsn7KwUS4xnsWhgrj6
7kY/esboQ5E07YgoWWjbpvxLQZmGtOI7A5PnxYBave9b1ZQ0eF67eEXtjjIq
GgjdrvZPDMKI+z5R1KWBh4nDS5hLGfUzXQ7GGef8cczmlauzLJgMTvF61Cqh
lbXM3cnnifD3YkKaoLkMrEmq+rrcVEQcRR8GDx8iwa3NPgOrjzIwfyz7Vba2
MjJOv95lMSMK0aq3pOJXpIDTjP9eoqIK+r1n/uWpMjGA27eeNrKRwM/IzT6x
lYbkFKbfm66LQ09yKsnZkQhJ5bTfu6/RERnjP9bbLwYVDyTXk+qIMHCdjep/
h4bqLv1J90okQdT7zITzJaLwZ740zP2EKmJp0Q3690Ec7o2ePzJcKQ4Pbt7M
XVZTQy0eMXdHDEShRyhZuWdCFP7VS+4enlNHVdv8Fp9/E4UQZvVv4g9JwMN8
WfLkugYq/p3L3cBLBAWm0m5Bxr1PTHZtVpeoo9V2gmawFxE6+sP1p9wkYW2q
2TKgSwPduGdw+Xm7ONz9MdTh8UUCPIx3B2fbaSHXEA+bn9ri8D2vQnKUKg76
q44jzn81EUVqI2XLLgJ0nJgZUbtLhELxhYDbXzSQDFWO/qFIGNTupmzbUJAA
1lhSWfgOLdRUe79txVEIbhyQ/jUlLQV3QnfYNiRooaK+8ib6diHgiu+4yrUm
CUeqN8xMv2uiF7U0od5yIbgDlXc3M4ggse/88vZzmojn4FOxxkIeeCFxrExp
qzhs6JA4Wx9qoRO1MnpbJAXgQWjmVZcyCWjStc7D2bTRS8Nbn7+7ckNYkqYt
4SwRHKsW/5XLaaN/Xm/0Jkm84JukudK9SIJ3geofzXFtdPOXwsqOrUJwsE8t
vZdbHHxyTpRoV2uh94vsjqJ8IsA2K6qgr0aA84vfHqs3aqHJl7syNfKFYNjL
kGLMJgoC+w5ZHPRnrLN32h1o/BC9w6LU5pI48DvShrYOaKH0JO2zimac4KZh
eA5sxSGyWP1ItIQ2eto/qzSnxgWkXXyc/z0UAY5DVpJD4dooPCG73v0EC3Sd
k+rV6BQCJ01HtgDGfJH4S+1P9nJAmvb87ByLIJgEiApfkNVGKXn5vrv7eMD/
/VvD5CtC0PthLqJNSBud8Lgz6prMC/aFF8MVBQjgs6Hp61Knhfp8DVbFScLQ
4RdTWaEuCE9e6gt6/NJEetZm7AdYBIBen2ik6EcA7F+0i7ixJtphZ+KwxskH
gsn7VQUwcSCtOA0ZsGkhm0naC5edfBCNHgwYuhPA9LCZTT+uhY580A9ScuIE
I6a44y8chKAkqmRlTUILvW3mOFjCxglSs8OFBacFoXtCj3paXgsJvZd0pKTy
wJOJ55r+DiLg4E5ILQvTRKZMYr+LrnPCddZgI7YaUTDu4xsdstBCB7QjbT4K
ckP8A19nTTcCGLBE2Nbt1USGK86T8TvZgO2osvkpXBj08bmR2V511Mu3EeJ7
kheaHab+/WUSA7FtL4dsp9XQ4SYLgV5LHsi7rnvl/UMCBHTuKvshrIpaU0wj
q2i80O06ENIQKgzPYgl/nzTSkCNpUlFZgQvYKA53O32FIMsn4nWNHx29TT47
c4ckCB+e/Q5uZ+eDgb53ZTQbGpJ4P0BIbOaHTyJiwiHtQuBhc+9Z0HEVVDQY
aCf0QgiuNg+esGTmAXv5ofPEUmX0NFbry15FXjjJ9GZ0BrHBUPvTVbcaRfRz
8Hn7Fhl++M+DpnIgihPadBNyYgblkff24vpsDh5Ycr9bUTjLBsVuyYdzJhXQ
7SivqmIebsjqbV1KGmaDHB+Hpo/nFJF/m2l+1V1BCBawvEYEFlj1Wn6IhhXQ
eFL56SM/hcFan8xJer+CR/5Jz3BSVESXVMMHI4+IgQHN/HSy+D/cstafjfpB
HqGrpnpXm8XAVf35SbCYxVE0LxOftgK6n711eX86CYpWKaTFyF+4nEo7hV9a
Af0gmS7+V0YCLja1DaeCVkzr4vNPvP8Y479cdKvuioFNWrryamA3prs8wuFP
VUAqN7G9FYgAadv/WMYo/cQzbiV2hcrII/aAXJvsTTGYDqwTe1zajWM6Tx0+
Tcmjryu7hbX3MN7lOS6d1+P5eOzV5B8BlxSQQibz9H97+SEkvfDMkQMVWJYz
MfFroAJyUOGIZXXjBC7l4Fqttp/45tFLka5K8khh18ExTQlWYJLR9VTVnceZ
/2NaSZ5n+KJ9g9oh49xgazVemfCTCfIOZsaduyuPrK93fK8NE4Dds3FbJVxY
4V2A3BYrRt6xjJKK5Nj9f/+HvrPsNF3Bx6n5R9KJSuj1sX7d23kCsBHuVLKz
ch6nx8a0VbGoINfXzKvsApzwbio3pH9sGf9Yy1Qa2KiCNjfvcOb84Yb6xmCh
hl5muCVbGR25pIwMXEsCyddZoaq9/XJXAyds/5pa9J6ThpYqvP7UeHGCuY5g
RijOCe52Ks57P9PQROxP7bjZDfwsbXS1L40fNOtCOf9jvFPWdLdzR9bYIHMv
byr1Dw9cSb0pLrNXDU1kygvjl9bwLymHeSqD+KGbP/DiOLMGmp7p8UvKZQau
GYE33s7C8DpzsiZvRROJz3evOn3hhC4DJo7MF6LwMNCtz0NQE80HtnPPTAiA
UausCmmdCMJlBYa7fTXQ2z1eJ630eYHts/29JwNScNLapPTqVU3kKX3/C4XA
BdYD4i37GH4zWyzqLUVMAxHjO+TXZvnglktXft0bKYhVFUnK3qKGFt4n7lnz
42DU0258tV8aboZ2lbBIaCB9zp0r2bKbuOtGVif/oiQINVvcDr6tjma3BKya
FHMA+iys3ilIhIiCOeGz2WpoktJkTWfUocfp8dYZhk/J+W/PTOYqHRFWDrnu
YLw7yayHiHe9RcGvqeQD9xMaarlYtFC3xgkHzJy/XBAmAK6iLqY5RkefAwXk
qDacsC6is1flvChDn0zSVbnV0GgboTh/kxVYDv/iFtYXAwvzzzR7KzpqDCuu
X21Zx8MOvoy4qEeAynuVBEoUDU27G9Z12m3gvdDyLLpQGPhfdhctfFVGu9N/
urClM8Hj0ejxPSf5YIeLPan7NQ19fLn1cOF1JrDZvhrDfVkYwo548KtJqSCt
Yzod+6eWcPzG1/zACgKQEM8V9qNKSLd7dyr//nn8e2rj/yq27nCq/j9+7Vn2
yuZO17j3urgU56NppTQoIUWiKCKlJA0yCqUofENGZJSMKDlvsipSIkJGFFFZ
JYR+9/fveV7P+3k/57zer/HHkbRlcn18NqD6IY2KnKd4qNbSc/itzaVJxapK
YHQlND1dlIoWiVPewzcW8JTEvAjHM0oQE8fbsj+IhjouXUjmrPmO63S1fps5
qwSeMeKPZLj7Zxz9YnDM7hkW+dhIrrlDCQzW2JTw7tdB6HnbhqX6h7iFfNip
thAVWDPAU8hjT0Onpdq0Hl0fwzbOB3oldStB/7Mja2+T6ah6riB0rO0HVqbc
7KwRqQRD9S9unJKjo8uC1KKhuQls8bXU8t1JeXBuS35X9pGOEsqFjs5k/cXy
FOrPBnF9ocV5serbFTpqfLV5dVTyLPZgaqBc47ws6DumpscRdNFLnf6Hpa0E
tHLC6xSjQgYeu0RvIGvpoUkq+VJlCD+a70igCKxIgofzvYeN7booLe596IMP
AuiY65HW2UZRIFbf/rLmoi6KiSO+fPdgGavXX1EtPbkaGr8+qJyK10WPHLye
3LL6ifkpuL3dZiMEl58qbetj0lHdmtTavrBf2Hh2/cVkQ2GYmR5kR/HrIjsR
1S/00m/YmWCBHxuIq4BhXVJ7uV8XrYkNMun6NYvx0K0jAoNE4U8n59fTKj1E
rfsVoJg6gd2JEB3MOs8LpQ3bdwjhdPRLu0TpjsA3zG74ikxV5jJ+jrz3v9ht
eqhienX5+JV5TIBW2sb/jwdSctpqi7j5szjM4ajTrxmMo2e2NnDuD76bmR7m
cYyOVJ5emCg88RUz6CsbkvjAC+HY58NKXrpoe4TyhR3t7zGXT9pyprpCsDXr
6AvVBV0k/iVWs05wBN/fdiy6REYQ+nyrifeDuXitGHv/zS8wi6txYhc0eQFV
XKU6WeuivPR0+8Oc79hJG1uE3gmChVLYfOV+XXRkWil5hDGPkb5buFlfE4KJ
Z1FH8vX1UHNWFHO2Ygo7mOeHnvryg0JwmbjjPzpCZ7YHk0bfY6qZ6izdJwLg
8DLn45b9dOQ+PyfjkVeKle+sHb1XKQwu5F39+QI66PSsnzne8A1b10dd/5fJ
D3aB2mo13Hukvrrq5dE3jF3+eejpYAQP3D3JeFDHpqOR3c+7NF2HMTD2pedK
CgFZ0qwpgKaHCH8LjC85lOBODMfbMnsFYNVeSz2t9XrI3Xvd3n2WHdigo0Wq
mf8ybuG27zIxkI6cp48E3qfPYJcM/th5BPJCQcKm4K5TdNTxLJ/Zd34cm4n8
uMGGwwPvu0auaq7ooDBsuT1+ZQaTzNwqdTSEH3SsFfcUEGgob0He7ajYJPY9
QPuI5vklPMNUc8vcJQriHEjudtj7HWve+7GYRJrF8Wko2y5FRqiw+EX31nrs
tFxP5W9eHpg7OjO/+x0ZCWuIBxZYvcVf8KSdP9zOA/Sn+uC8i4I8f+XRDqX8
xMO+6XhiqcJgcSAhZzmXhAiWWLQcJw1v1HzIj78UA5Mzy4k/rxAR+9VAwZaT
E/hJiYHK28VSsPP75IY9wlx/XBA7aw1f8WC+E7lZR+TAks1fGfpbGzEsHXwI
UnN4T7xYr9N6WSi2ogso/dFCHf8+3Ut3XcGJObCj5ZcUrHjvsCzM0kSSlvp7
4zmz+OZ7X15q75UBvrzoHwJWmqju4sqbJpO/+KMC+n/Xhv6vt7Tz//+PmLd1
wnmT7RJeVrYt8vlROejwnin/aqmCCBvczyqY80GMVlPOdm6OeNP79fd6VQ1E
61nXbM0ggOuAlcLmbAXoFTxX01ehge6m7Ys6f4QAxgXXI34OK0KEcOfYoRca
aNPIgzeCfvyg6BR/pZGrSwYf69UPRaui9oOJ57SJBJi4vr9a31YecrL/0zh1
TA3dXF4Za+r+jf9M337v7IwCbDz3NzSvaA3iN+bn8f3zBa+LLbxhpigLApnv
047ia1D4aKiZyLVabCTylLr8F2lw4T/jYe2mhjh6lJuDjiN4UcMCzlcpDyjj
7WxGgwaqEEyvJvtO4W4FCizvi2tA7/tIN4GogS6/Hb57bWYYt45vqAtkKcPE
bv3Z1w6aiOObENBf/R6b8C2u2EpUBk2Njq4n7zVQRjvH0lJzElOfEsf2lCnA
qunHr26naKH1MacV/Ctmse9ZuPPAJgXINdgaS1lFRIpuV//k02awD1Tp1qsG
sqBoofFnxz1t1MzbGmVf9xlrDnQeQboKQPnBGbANJKLtISn/7auYxNr/u7bg
MC4Db251CIn5a6PtOSFO8UPTmOyOKYkwVRmwcoauD6JENGammZqf8BWLtZeL
fxskC4MQgJYuEFFlgMGpsK5P2JKwYbKBjBTILDBQcBIJPbL2c/NkvcU/sD9m
Oz8QB9FSFZmOaTLqbjyfN3B/EGtKOqui0y8CRgUPKQcGqAgO4m4OqsXY24ai
OwprJUBgPEzjySjXv4yk3it8qsUw/pmyxQERsHbdXZpTS0NI4qBE9WARbhvk
mhf7UBLo0xLZ+et00NsSBy3TkjHs9vPldewGGSDtbPXYb0dHcT8spD3v/Mbk
XQ6W38cUQOVe8X8cIh2Fjz/vG/70G+OxH87fbC0L7yb+JdsS9FD3rtifmn7f
MEa53VQGWRoO3CwabPuli9xrxH6L/pvE7g5KrlAvS0LTHpPGlXu6iFhw8GpO
zyTmeSFE1S5GGpopMRlWHXooj550tfDuP0zV9Dm2TUAC1A8vrGDdeoglN/zE
3O4vNrtR9oQzRQQuS+4iWzYZoJwPYV2Dq3lRWfdVMfVMHvhR+XBDtRgD1SmK
Vz/dvIJd6BuQ+tshDB43meXd+xlII9bA45CCALd3ltndp4vBRoPOZk8mA/mt
MKx/JvEjO/fSnYdthSFaoqU0Q4uBfHmYH9iqfIgktegbdFwARFmHjzyUZqKN
oiK+ipsWsLXzP4J7P3FzzXqzQUIUA+kSgtzmZ+exZYcCyl5ZXnDJThWqusbt
iUZqLJeqGSxE5VxY8ycRMPuyl+DhboB2+Dwepe3/g70+N7/KtVMQFHWVjDem
MlBQvKPEgM48trngUrnuax5YKatrXhvHQN73qK6DXJ77rvN7Ht7BC8bjW8N2
6hsgSdImI92r77GUH8VLyy/5QBvZRK1pMEAbSeNqb94N4YSrk/yP2oTh9JCM
hxa3F0+50w7G3qjH+GrGg0yyBGBon7blATsGGptSMym7/h7PW2/zz6FCDMYX
rX2UBP6//zyJROnEXVS8b6nIi8Nhg0sfb4QwkLvMW7MagRbck3BOIy1WEq5s
CN8czc3VyHqpgYdahcWsy/rbT5GFaZfK47xvDVC4eML0DrEebE/qrgz+LBmI
/xBHEnNjoPDClC1itCaMNCpJmI2ShdGS0FNaBQzUfWeDuV/zT6xw8KZASZA8
EBTWbxRmMFDeSY1dWVa92JvY0dS8HWvAU5t4NeEH9/sSwxZk17/Fe54oqRus
VYVaVaPi3FkGGrR+fDrxTwserVIdKRepDkrPXm815fZxgp24aEbyU/zDjsN+
G501wDLL7mP4Nwaykq6/cNu4AzuzCWRKnFThor2TMbuLicJpWexCl8/4o0Av
nW8aqnD5plFPD8ZCrDW3nQ9Vz+IVcV02lbrKIOJiS/58nYX8o9jduxxG8cYg
5nGXX2rg1S4hvSaXiQ7+jV9razuFmw3mXHQ/rgnKvyuHvu5moSCxvMDpmRGc
khV0vbVTE6yfJ+5sr2Sh9sSh8ly5ORzT+vh200Mt2L5IfPaTwULi+rynGJtn
8ahbwa/qiUQI3pVt29rHQlM9xjw6nCVcq5qYSkjUhvT322oMmIZIN7Fn44Xs
KfxMYbCn14omGPLbBwl+MEQsJ3oo7+AynqI//is/XAOiytaYph02RDftUt5O
7Z/BpRf1HYq6NSFELahtbQcL3ca/BZwUmcG7VHuFi7O0wCAw6Q92goUiS2vM
dyb9xje6SFjr6xPhyZ4Pia79LHQwf6KsKnEFr4oUP05UJUKsvg9der8huqsQ
Lxgf8xufiNv2Mc5PGzzI1xeFowwROzeJORg0izczq4OzRUhwgUpO30Bgo5Q0
oRb6gT94YGGhvHerNhQ6bX+ll2qIrCzyTRM2jOFu98blJFNJkJa5yZFnyhAh
VflzhBNc/zI8IxWyQAZFs6LAW92GSC1S/8rAaQJAiLqU+AoRNl9AqWY32eim
SqbXl5crePiwZE2XBAkeVk0H8gmzkfDHV5W649M43/lxQlIrCdiyzTt1ZwzR
o8CGczvdO/FrkrUJuYJE2LLqoF/7e0M0+O7ykylWN9ZXU9IkU8OdIze3K2mS
hcb8pag+9Ha8dE619gEPGbwkjXnuPGeh7d9OaZrc/opX/JxMmVMmwe9Cf/Ec
aUPk4uYmX2c+iUeEKO1d60yCnW1Zoev1uXP253v31fTgSXThMs99JMCky3cd
a2WieWqB+YulD/get/OSUvoUWApU/iVcx0IZ2IbooYFRfLPfqesyZSRo9A5r
ju7j4j2Ht15bM4HLrKaIXmaRYPRTKeHJChPJ/ujD0h6P4Ltbd0TovifBfwQf
Tc4SE3l7DaXOfh7BT/+quN9bRYH745eSJMZYaJA/qsmsrRLb8/z7gVgmDbLG
J6bqTnL5/7ODmpsyhgf9dY3MSaVC+u8DaTmHDJH0rrD7L79M477fhXST62iQ
sHiozEqFjewfB1edpf7DE3KJBe6BOhDfMeh15wEb8dfzS0tYLeHiEsPh50Ko
oHlcquqrARv1neU0ds3zgfeiJc92AR2QNF6ZtjdnI6JCzOvebUIgZPsyv+yk
DrxrztU7FGGIGl2jVWqU+WDlaZTHp04qaKmn1i+VGiKtaKOL+1h/8VlG4x+F
azQI/WJaHEDl3sXiDqUmdQLUFO11e8+d3yX3nBq9lYWKq/+qC4wv4hcvx/jE
GNFgA+3LCZaCIfIZosU8m+EBq9Zzdnv30sAoZ1Xt5llDdHAld93bGT7oyVDc
HEjUAZuo1rHuDEMUNt73Up2+hFt0Th9TaNaBXTvqdRIvsdGxF4lKU9t5gLFH
a++DuzTwVXsYT+PyLZ7UH1v5QwjomplzYpkUSHtkGRZ+g41MJGzYsvvEgTdz
oOgKPw1chrdbe+WwUbH83XXwWgisxFyDDvNQYTjP8aMYywhZqdQkmTOEgDfJ
21Tbigatjm0jr43ZqDefL9q9QBRMEmye3aLQwMLp1B/jE2zk455+UmNIAM4r
CzSoiulAZK+EuTV3H8JKZdFCKR+AQ0IyVUIHbmbK8wqBIdo2E2z/JUcQXjqG
qV3vp8PqjFfr475x9W04RYfdKgC+l7q/iGXTwdtVuJFsyUI/B6xNxfXEgc35
/Tw8TA+UI7N9QnYx0Q3Di3xtGySB1DhmSGihg/1S3PcPvCx0d3dTXFyaFDgu
MQ5L8utAr71xoooUE+mb8FUYl68Ca2HPGcc7VFjIvbmvIJSJigLujB7sF4aH
g0bRbRwqJFFSNPsjGMj/fbqAjrcINIa+TSNx9aGwPrTiigYT+dxR1LjCzROM
kUtnHiaRIfOZuImQPwO1eduM+zwTBC3/CYMiQyocy5k7kOnDQPqmnYaEW6tB
RT+RlCBJBQv757XfKhiowue1vepPCQiiqEU2FpHBk9/15JtWAzT+ymbbJzEZ
uM2f+6ZrmatXOrGZ5XcY6NEc7UfwXRm40JvcpWNHBMsNNlnxuxjo3JYDQzwc
WVgIvLjh/pgWfAz4+jTVgIlOX9tauqItDREN+tm7jbVAUkaI5DnPQDtX+2SK
SsrAOfJMfZ6dNjy2dmp1jWOi0ATz/Q075SFCSehR/Q9t2P/nybjhcyb6JeM1
ii5JQ/XEttDNCiRY6BBXdcxhohVqw1myhiw8vbn8sYlCBp/ZY2xHLr67KlxK
eU4GzI4HesZxdT6VHpLreo+FZibVUykbZECHjj7JvyPCUMbfyhxDFtpWaLWx
tEcCKhQHrCf5teFf5h7PYXsWWuOuUNNSJAbSW7yLOYPakPD5A8XTjYXId43V
qxol4GGj5JW4LURI9nEN9V3HQpMtPjuwY8JgnvKY3OWsBUX2ly5mLrBQokPs
WO1BHrh8VRLf+EIbunM/2Yy2sNC5kKWHkoO8YCfmxnY+xtXPT/+tRdx7l6rW
UhOTEIR2C5Y2TZEIFZqMYpGXLITMA68sVPAC/x+40fyEBFSnWzccLhqiMeTT
q04RBfOmgOx3vWRoszb7E7rWED2Vnpuw/S4AR6RYZV9ySVAzu4d9PtMQ9Z88
t3I1mgciPu+ne3GIkOH+YmloloWazviv6xwUBh/K+b13E0nQdiD9yWIJC62/
OrJzUEgA1gW+9o4YJoP3kaf16fu5+PL3MsZ7RGCCIK/scYwCOnZ3ZEYzmahe
yWDjrXReqOu20t0dQ4Yvj02fxI4xUcGWd2Kr14iCBYyX5gZTIMhtzbGr41z+
FIg33TomBrX86Ep9OQlofUtf169jIpM3qVHptoLQKTUeEX6BCES9/tTvYQxU
mR0ue+o4Pxyh3Kz4jEiw+LWdd4bNQJqCq2fvTfFAQ93y9URbMuRJ7Wrfepbb
YUb9ZnViFvHT1s8cmkwpQMhqjBnJZqBGM9GqtJ2LeIQoa9dKOAX+yy/q7T/B
RF/Lz94P0/+Dk45i40quFBC0yks/GcBENsRN6d8FF3Hae182fYoMjXxBUZ5n
mSjo19j5nT/5wKX3UX6nFRXErA/72w0z0dbJBWNTH2FYNAtzM52hAKVs+Igu
1wfVq8d2fjogAu2aMoeoXLx4CvXy6Swm+t0mo8MREobmKgMHTgMNPtXqYmEX
WejFvPsPibt8wO544BvdRwWjaFGfj1y/zuBX8RVMWcFr3qkOrdfTAbePquV+
nobo30fb5U5VXlhvLfHtjAUV9LR0jUVnWOix4o2To3GCMPVI6fvhUSpotMLV
oQ8s1O11OfLktX94Po1nKvkoDeKlmmeSLrBQ1rW1Sr2L/FDRIh6cu0AF/Yp5
2ch0FsKe71NV5hGBzyYtfAotOvCEdmSDQoAhktlIl6xeJQLPy9+u46zi+kL7
rVXHuLmuyO0NtiaEHzRsAjZFz1LhCLt/Y40NC8mq0Bq3my3iSb++HhU8TgVZ
X9/iu9zn3wfOiXl0LuGPA/W3tN8lg3ngw/PT71noE6FXjhrJAz2L7W4Xmykw
/TPhxmgIV2+FqFWlf4TBzu7byDk/CjzJEhdKeMRC88nCXaqVYlBUke71d5HL
k5BSIpXGzY2Mm2ar/VdDuQfHTucKGRy6RabVzA1Rxjdz4T1mIsAnfE96wzw3
BwqX5h/oM0R3CP86i4EfzvPsYyjJkCCK/Pd42W02kvpQN/2A66eVhupljufI
oO1yPsvnIhuptPAaKe4RAsvEgDwORoGyvJXHbUJGqPDT19P++oJwIaTa7w8v
DZz+8rJVTrLRnPcLL547IuA693n9oCMV6icsebJN2Mj2AdHMZUAMhE3L3p/c
SwHOj+OblnvYqOrV9ExzjxQs9tod2jJLgWCWQmbmSzYa6CW8+s0vDmO7v+Rv
v0yBi8mTJLqIEfKWuCB4hNsnvWp+bEq1pkHXq4uXfpUYod2WAqkniOLgccgn
ttVSBw561l9R22WMtppQK1zKRMDu6acztz/rAMHc03TZzATJbUb1xtOCEJfi
Rdh5VgdKTvcTr+4wQWubHBKW5MTgqHNhtlYIDdKftk8XWZmgEomnUjMBwlCe
36IxIkWFNzt3db47ZozSn1QIm1fwA3Nf2gSpiAYRfIJp5ftM0PbNlXtj6/7h
M+lLtOoPFIhTWDle8p8JEq3Y3RLOt4Avf6nXn8uiQYNCxS+KKAdFJRe2CDku
4efWOo4PVNPA62WKS+JZDvKff1Uucvc33h9w8HTLQSrkbHCYpveYIPF2rTKB
IgI0Z68+eLyWDPrK7pKKwhxEtqTEtw4Kwc0nQibvuogw4DzJucDgoMn165Tu
jxGA3OZzNuSsNoQqV54VbuSgmTtPJuynV/CXrIqxBSMSTN9iDF/vNUFX7R3n
/PWncc6l06zzVSTIazpycuUMB6lNTkqE5czguoycOXYEl8+yTjl9+znoUVRW
52mLBTxk8rKiwyMiqFhLmKAQDkJJVzrsLBdxjJ9wbiiUBIG9Y/0/7pig+dkm
zkalcdyI1SyVaUmCd1TbGwMdxkgxQTy77usUvqlvf/qfVyTgHZkZ2jdmjDZ6
aJp8uPobb1Brirr1kAQrr0v8awuNEd9Tu8Nl+3lhe9lUTHQ5GXRJt8aPShsj
dIgTFKfLDxHmXa2DfWSQShRKUflthIYV8kN78nigj5ffIEeHAqr+X+3mr3D5
vLhlaZLCDy5jWv8M9KlAmuoquHzSCJ3QP918JlQQPmpfT3ntTIWmhfq3//Ea
o6/vhBzWXlnGaW77zrZV0uDpM3eVkBfGiHdgxUN16jf+Udp8wJpMg/Wx9zPN
wQTtyZLd8nXbPN54oPborI0OzNQeKOw2MUEtxfvExDBecCJ3Wou9psGzWVL0
oxET9Ji91OI5Igyhs941P4t1YO20+4LBJw4KUOuzcPQTAfQi1n1ARAei9nqO
9iiYIvWOWk2172IQdnND600uz3ebXKjYmcFB1ybc/Xo6V8Pmwzs8BLbpwqyS
z499lqZIvNtkNuGHFJRcvG16n6YLtwZ6OtTrTNFl4UCrZLY07BLS8916ic7N
HSO+c9pmiC8mW9U8Swp2q5TJvk2mgTEpKtzJ3AzVO40YhnqIQaRmerOtPh1y
IrsE7yWZoksSf6NczUQhurs0YVqUDrt/Xtkq+N0UrTpalR+0IgB5ahda5ag6
sG6WyNBINEMn/vCWnBkXBhvor1N8QYe4++9G1F+YovyLwT0nwlcB4TTnBFFd
F+bllFOCWKYob55WGRAgCLof1J9llutC0R7votHVpujVzMEeeRCHxbahfRrv
9SAoX+WfhpcpWnlIG7i7XQoivGUGRPl0wV/XZG6HrCl6t7kt7zQmB5/deEvq
pXWh4pjx0bfZpig3GkJT/RXgy8M2mWAxPShoqJHa5GGKFhrvGGmEKUHb7Znb
WB4d/K8MTjS7mqI0ZXllYrcybJk19glY0gG0WmIdzn0/fzf69gz7qUKcVatN
c7cOeJXX7TadMkXZfcnqdkVqsLjP6aZMPA3uZaP93QwzJB+EiwtrqEGMiqB5
oDMNrB3Yn3PyzNBC64nRs6s0YHVcf21AMhUecFrWiTqsRQFvnl+UlNOAB3I+
e9J2U4GeZrw2wmYtGtz0annXWU3IWHmZtJafCjuZ3pZOputQj+QSyfG5JuR1
SNtGDtAg8hulwpJmjsjYa+8mIS3wWf3DZbyVBs2rlofeUMzR8RLMOv6OFvz8
t1A0EEqHpd0dIl2q5shlPKiP4KoJP7IsXmY46ILrrTWK1jvM0W9ltdt+yVqw
/jB0OjXrwR2hWnuTFHPE8PgQHBOkDadPVmVcRgaQf7Rs2sfTAslT76s/btKC
/F7rk6tcGaCYMpQcO2uBXtunajT0aAO/GLm8QYoJ4aUvldKYGBLlsU5VOKwN
/kx38QfCTLjBe0qrzdUCha/LuOAjrw3uhF9LVYkM8NQU/rnqmAVik+/D+Hlt
0AqevaWnz4SSvgGR2TEL5P/UdvXRQCJUrr31bkmQCf8D/kpF/A==
           "]], 
          ImageSize -> {324.4921875, Automatic}, ViewPoint -> {1.3, -2.4, 2.},
           ViewVertical -> {0., 0., 1.7753036909777427`}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7133fecc-799e-45e9-a66a-4c6d87aa9a8a"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"32f20461-3f80-4625-880d-c15af3415cff"],

Cell["What\[CloseCurlyQuote]s the difference between iteration and \
recursion?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"103e613e-89d1-46e5-930a-73b2656e46f5"],

Cell[TextData[{
 "If one does one thing repeatedly, it\[CloseCurlyQuote]s iteration. When one \
takes the result of an operation and applies the same operation to it \
wherever it is, that\[CloseCurlyQuote]s recursion. It\[CloseCurlyQuote]s \
slightly confusing, because simple cases of recursion are just iteration. ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 " always does recursion, ",
 "but if only one slot appears in the function, the",
 " recursion can be \[OpenCurlyDoubleQuote]unrolled\[CloseCurlyDoubleQuote] \
into iteration."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:27",ExpressionUUID->"5fad44ee-fa56-40cb-b0dc-3e5b627b5066"],

Cell["\<\
What is the relation between nesting, recursion and fractals?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"62cc088b-c98f-4cc7-a9f9-568600804a73"],

Cell["\<\
They are very closely related. The definitions aren\[CloseCurlyQuote]t \
precise, but fractals are basically geometrical forms that exhibit some type \
of nested or recursive structure. \
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"bd76b34f-8559-4c49-bd2d-1d95f9ca33e8"],

Cell["What is Pascal\[CloseCurlyQuote]s triangle?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f5c99d83-a456-4c9c-a678-6669a60f370f"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s a very common structure discussed in elementary \
mathematics. Its definition is very close to the Wolfram Language code here: \
at each row each number is computed as the sum of the numbers directly above \
it and above it to its right. Each row gives the coefficients in the \
expansion of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     StyleBox["x", "CodeVariable"]}], ")"}], "^", 
   StyleBox["n", "CodeVariable"]}]], "InlineCode",ExpressionUUID->
  "141f0d02-3a3e-4b00-8686-7c6adfc1eaf6"],
 ". "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:29",ExpressionUUID->"99935d3e-72d2-4570-ac8c-717cab269750"],

Cell[TextData[{
 "Is ",
 ButtonBox["NestGraph",
  BaseStyle->"Link"],
 " like a web crawler?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e7f394d2-b181-4ebf-a5a0-6f5f233f9739"],

Cell[TextData[{
 "Conceptually yes. One can think of it as doing the analog of starting from \
a webpage and then visiting links from that page, and continuing recursively \
with that process. We\[CloseCurlyQuote]ll see an example of this in ",
 ButtonBox["Section 44",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-44-importing-and-exporting.nb", "web-crawl"}],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:30",ExpressionUUID->"b2bbfa4e-c0cc-4aa4-90e3-8313fd1abc0d"],

Cell["\<\
Why do some but not all countries have arrows both ways in the bordering \
countries graph?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"baa79414-e9d1-4ada-bc52-76398d6d946d"],

Cell[TextData[{
 "If ",
 ButtonBox["NestGraph",
  BaseStyle->"Link"],
 " ",
 "was run for enough steps, all countries would",
 " have arrows both ways, since if A borders B, then B borders A. But here we\
\[CloseCurlyQuote]re stopping after just 2 steps, so many of the reverse \
connections haven\[CloseCurlyQuote]t been reached."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"ddbf3ce4-4840-4c16-a28c-bcc63c80cc07"],

Cell[TextData[{
 "Why use ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 " for something like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestList",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"2", 
     ButtonBox["*",
      BaseStyle->"Link",
      ButtonData->"Times"], 
     ButtonBox["#",
      BaseStyle->"Link",
      ButtonData->"Slot"], 
     ButtonBox["&",
      BaseStyle->"Link",
      ButtonData->"Function"]}], ",", "1", ",", "15"}], "]"}]], "InlineCode",
  ExpressionUUID->"4c4eeed9-64c8-4a7b-941a-7697947702a7"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:161",ExpressionUUID->"92a13f8e-132b-4061-a8e8-c8df7c970144"],

Cell[TextData[{
 "You don\[CloseCurlyQuote]t need to. You can just use ",
 ButtonBox["Power",
  BaseStyle->"Link"],
 ", as in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"2", "^", "n"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "15"}], "}"}]}], "]"}]], "InlineCode",
  ExpressionUUID->"4f3386ea-2cad-4d32-89be-0237499b5d50"],
 ". But it\[CloseCurlyQuote]s nice to see the sequence ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Times",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Power",
  BaseStyle->"Link"],
 " arise from successive nesting (e.g. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestList",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"2", "+", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], 
      ButtonBox["&",
       BaseStyle->"Link",
       ButtonData->"Function"]}]}], ",", "0", ",", "15"}], "]"}]], 
  "InlineCode",ExpressionUUID->"b7395dfb-058a-4602-add8-13f60b2bad45"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"2", 
     ButtonBox["*",
      BaseStyle->"Link",
      ButtonData->"Times"], "n"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "15"}], "}"}]}], "]"}]], "InlineCode",
  ExpressionUUID->"b9651b63-aba3-495f-b9a5-bd1acb5b7aff"],
 ")."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"75368442-18b7-4943-8a7c-e317494197cc"],

Cell["\<\
Is there a way to keep applying a function until nothing is changing?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3eb37847-8396-4531-a5ce-cbaeb007fb27"],

Cell[TextData[{
 "Yes. Use ",
 ButtonBox["FixedPoint",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["FixedPointList",
  BaseStyle->"Link"],
 " (see ",
 ButtonBox["Section 41",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-41-more-about-patterns.nb", "FixedPointList"}],
 ")."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"250901bb-3b70-44d4-83a1-7c13fe029413"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Note", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6c1257f0-eaab-4743-953f-ed6c138e28f1"],

Cell[TextData[{
 "The nearest words example can be made much more efficient by first \
computing a ",
 ButtonBox["NearestFunction",
  BaseStyle->"Link"],
 ", then using this repeatedly, rather than computing ",
 ButtonBox["Nearest",
  BaseStyle->"Link"],
 " from scratch for every word. This example is also closely related to ",
 ButtonBox["NearestNeighborGraph",
  BaseStyle->"Link"],
 ", discussed in ",
 ButtonBox["Section 22",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-22-machine-learning.nb", "NearestNeighborGraph"}],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:31",ExpressionUUID->"0c284f95-01d4-4afe-affd-125ce452125c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6c54fdae-86ac-4005-9b9e-67fd7b915314"],

Cell[TextData[ButtonBox["Guide to Functional Iteration in the Wolfram \
Language\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"ffc6e443-a25b-497b-ad37-3ec9b576bf98"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Applying Functions Repeatedly: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-26-pure-anonymous-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-26-pure-anonymous-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Pure Anonymous Functions\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Pure Anonymous Functions", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Tests and Conditionals\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Tests and Conditionals", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->228,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Applying Functions Repeatedly \[LongDash] wolfr.am/eiwl-", 
       "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"5940cd71-5e90-40c6-88ea-ac3147a364b3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:153"->{
  Cell[674, 24, 432, 10, 93, "SectionDoubleDigit",ExpressionUUID->"0f6866b6-833e-4b62-b661-fe33ded5d34f",
   CounterAssignments->{{"Section", 26}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:153"]},
 "i:1"->{
  Cell[1109, 36, 1135, 34, 65, "Text",ExpressionUUID->"2055ad21-f90d-4082-aaa2-92dee9c3b1c9",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[2247, 72, 329, 9, 37, "CodeCaption",ExpressionUUID->"a1b92a5c-d2b8-43d7-805a-e1e51b1bbc3c",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[3357, 110, 310, 10, 37, "CodeCaption",ExpressionUUID->"dddbd3e1-0263-4df5-b04d-ee4430ab5393",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[4788, 169, 390, 14, 65, "Text",ExpressionUUID->"100c7f72-543e-4450-a1ec-ac4075111fa9",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[5977, 216, 298, 9, 65, "Text",ExpressionUUID->"06a67b5d-f668-4a3e-9f0c-2543a8644c29",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[13571, 392, 236, 6, 70, "CodeCaption",ExpressionUUID->"2d500334-3b04-4e98-bf6a-3b13f4296d37",
   CellTags->"i:6"]},
 "LastCellOfAPage"->{
  Cell[14903, 427, 6157, 133, 70, "Output",ExpressionUUID->"6ef2f744-dfee-4341-9ae5-3dd4b09136a1",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[59991, 1704, 537, 12, 70, "Output",ExpressionUUID->"c5f10c3e-aeca-4b2d-831a-7205aefdb7b5",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[69468, 2000, 1457, 51, 70, "Output",ExpressionUUID->"93701045-7432-4940-8b45-6bbfbe4fcca7",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[85996, 2573, 5791, 202, 70, "Output",ExpressionUUID->"bdb398bf-d374-4394-90af-acb81a6725dd",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[107463, 3223, 768, 19, 70, "Output",ExpressionUUID->"7ef74fc3-dc1e-4203-b558-e4ecb4813b10",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[124990, 3736, 5664, 111, 70, "Output",ExpressionUUID->"7ed99a99-a9df-4ae2-b719-149866e26b98",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[165852, 4546, 2529, 70, 70, "VocabularyTable",ExpressionUUID->"a55fb0ba-d5fd-4b03-9bd1-2e21307697d8",
   CellTags->"LastCellOfAPage"],
  Cell[466167, 10620, 495, 14, 70, "Answer",ExpressionUUID->"ddbf3ce4-4840-4c16-a28c-bcc63c80cc07",
   CellTags->"LastCellOfAPage"],
  Cell[470625, 10788, 354, 8, 70, "MoreExplore",ExpressionUUID->"ffc6e443-a25b-497b-ad37-3ec9b576bf98",
   CellTags->"LastCellOfAPage"]},
 "p:154"->{
  Cell[21075, 563, 240, 7, 70, "Text",ExpressionUUID->"2e5d52be-fd50-4fe4-9657-3192df64d00b",
   CellTags->"p:154"]},
 "i:7"->{
  Cell[21318, 572, 205, 4, 70, "CodeCaption",ExpressionUUID->"8e3efbd1-356c-451f-927f-ca359f837d21",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[55190, 1531, 201, 4, 70, "CodeCaption",ExpressionUUID->"461d8b86-ad71-4d0c-9bd1-27d5bcf5a3c8",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[56241, 1566, 219, 5, 70, "CodeCaption",ExpressionUUID->"bc3d2810-0297-464c-9656-f570ecf3f8e7",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[57136, 1595, 206, 4, 70, "CodeCaption",ExpressionUUID->"aed89092-53f4-4cad-a936-9433cd7d9958",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[57929, 1622, 189, 4, 70, "Text",ExpressionUUID->"2f5be090-a7f7-4886-89ef-acdfde410fd9",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[59370, 1680, 291, 9, 70, "CodeCaption",ExpressionUUID->"5a90039f-9bab-45d5-834c-def75ca05e40",
   CellTags->"i:12"]},
 "p:155"->{
  Cell[60543, 1719, 352, 10, 70, "Text",ExpressionUUID->"03df411e-4a4c-4c62-ad9e-d60839eb297c",
   CellTags->{"p:155", "i:13"}]},
 "i:13"->{
  Cell[60543, 1719, 352, 10, 70, "Text",ExpressionUUID->"03df411e-4a4c-4c62-ad9e-d60839eb297c",
   CellTags->{"p:155", "i:13"}]},
 "i:14"->{
  Cell[62278, 1781, 250, 5, 70, "CodeCaption",ExpressionUUID->"4aaa9f74-7727-4f19-852f-76ad98c1d38c",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[65807, 1867, 562, 18, 70, "Text",ExpressionUUID->"a40120e4-341c-4968-a530-f3c0fca36d65",
   CellTags->"i:15"]},
 "i:16"->{
  Cell[68885, 1978, 248, 7, 70, "CodeCaption",ExpressionUUID->"5724e240-6cb5-41e9-8d21-d77d0538d5b6",
   CellTags->"i:16"]},
 "p:156"->{
  Cell[70940, 2054, 243, 7, 70, "Text",ExpressionUUID->"593d3324-0a5a-490c-979d-b4a4b6e37e20",
   CellTags->"p:156"]},
 "i:17"->{
  Cell[75851, 2223, 209, 4, 70, "CodeCaption",ExpressionUUID->"a3eacb06-01c5-4ac7-83fb-a79918e4273b",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[85304, 2549, 207, 4, 70, "CodeCaption",ExpressionUUID->"bb7b9ffd-a27c-45b8-987b-2617ac70ebad",
   CellTags->"i:18"]},
 "p:157"->{
  Cell[91802, 2778, 236, 5, 70, "CodeCaption",ExpressionUUID->"fe5cfb92-7b6e-46e9-b562-c95c6a9fbfc9",
   CellTags->"p:157"]},
 "i:19"->{
  Cell[105274, 3147, 209, 4, 70, "CodeCaption",ExpressionUUID->"8d8d5967-64e2-49d1-b30e-4d5ae70c8c07",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[106598, 3191, 362, 12, 70, "CodeCaption",ExpressionUUID->"f8ca5da7-0457-4180-a63c-cae119d89bdd",
   CellTags->"i:20"]},
 "p:158"->{
  Cell[108246, 3245, 277, 9, 70, "Text",ExpressionUUID->"5a3bfc86-c281-4584-aff0-8b220fc6d37c",
   CellTags->"p:158"]},
 "i:21"->{
  Cell[116053, 3504, 533, 14, 70, "Text",ExpressionUUID->"5712924b-9567-4270-a9ae-3f2360484a80",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[116589, 3520, 365, 10, 70, "CodeCaption",ExpressionUUID->"0786e35f-8aa3-4e26-a553-18cd0b70bce2",
   CellTags->"i:22"]},
 "p:159"->{
  Cell[130669, 3850, 560, 15, 70, "Text",ExpressionUUID->"faf32d18-b5a7-4fd1-9e0d-43084fea0670",
   CellTags->{"p:159", "i:23"}]},
 "i:23"->{
  Cell[130669, 3850, 560, 15, 70, "Text",ExpressionUUID->"faf32d18-b5a7-4fd1-9e0d-43084fea0670",
   CellTags->{"p:159", "i:23"}]},
 "i:24"->{
  Cell[149268, 4226, 426, 12, 70, "Text",ExpressionUUID->"a3598aba-ba48-428b-a549-cdc5cc4b1f53",
   CellTags->"i:24"]},
 "i:25"->{
  Cell[260899, 6697, 1508, 48, 70, "Exercise",ExpressionUUID->"8a806f5d-421b-4aca-9407-cab4bf64f9a5",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[307909, 7546, 1121, 30, 70, "Exercise",ExpressionUUID->"23cabca6-9eb3-4e37-a1ac-206ecb4801c6",
   CellTags->"i:26"]},
 "i:27"->{
  Cell[463007, 10525, 692, 15, 70, "Answer",ExpressionUUID->"5fad44ee-fa56-40cb-b0dc-3e5b627b5066",
   CellTags->"i:27"]},
 "i:28"->{
  Cell[463914, 10550, 348, 8, 70, "Answer",ExpressionUUID->"bd76b34f-8559-4c49-bd2d-1d95f9ca33e8",
   CellTags->"i:28"]},
 "i:29"->{
  Cell[464451, 10566, 717, 18, 70, "Answer",ExpressionUUID->"99935d3e-72d2-4570-ac8c-717cab269750",
   CellTags->"i:29"]},
 "i:30"->{
  Cell[465403, 10597, 519, 12, 70, "Answer",ExpressionUUID->"b2bbfa4e-c0cc-4aa4-90e3-8313fd1abc0d",
   CellTags->"i:30"]},
 "p:161"->{
  Cell[466665, 10636, 700, 26, 70, "Question",ExpressionUUID->"92a13f8e-132b-4061-a8e8-c8df7c970144",
   CellTags->"p:161"]},
 "i:31"->{
  Cell[469733, 10757, 687, 20, 70, "TechNote",ExpressionUUID->"0c284f95-01d4-4afe-affd-125ce452125c",
   CellTags->"i:31"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:153", 561758, 12637},
 {"i:1", 561998, 12641},
 {"i:2", 562124, 12644},
 {"i:3", 562255, 12647},
 {"i:4", 562388, 12650},
 {"i:5", 562514, 12653},
 {"i:6", 562639, 12656},
 {"LastCellOfAPage", 562784, 12659},
 {"p:154", 564141, 12684},
 {"i:7", 564269, 12687},
 {"i:8", 564402, 12690},
 {"i:9", 564536, 12693},
 {"i:10", 564671, 12696},
 {"i:11", 564807, 12699},
 {"i:12", 564936, 12702},
 {"p:155", 565073, 12705},
 {"i:13", 565214, 12708},
 {"i:14", 565355, 12711},
 {"i:15", 565491, 12714},
 {"i:16", 565621, 12717},
 {"p:156", 565758, 12720},
 {"i:17", 565888, 12723},
 {"i:18", 566024, 12726},
 {"p:157", 566161, 12729},
 {"i:19", 566298, 12732},
 {"i:20", 566435, 12735},
 {"p:158", 566574, 12738},
 {"i:21", 566705, 12741},
 {"i:22", 566836, 12744},
 {"p:159", 566975, 12747},
 {"i:23", 567117, 12750},
 {"i:24", 567259, 12753},
 {"i:25", 567390, 12756},
 {"i:26", 567526, 12759},
 {"i:27", 567662, 12762},
 {"i:28", 567796, 12765},
 {"i:29", 567929, 12768},
 {"i:30", 568063, 12771},
 {"p:161", 568198, 12774},
 {"i:31", 568335, 12777}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[674, 24, 432, 10, 93, "SectionDoubleDigit",ExpressionUUID->"0f6866b6-833e-4b62-b661-fe33ded5d34f",
 CounterAssignments->{{"Section", 26}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:153"],
Cell[1109, 36, 1135, 34, 65, "Text",ExpressionUUID->"2055ad21-f90d-4082-aaa2-92dee9c3b1c9",
 CellTags->"i:1"],
Cell[2247, 72, 329, 9, 37, "CodeCaption",ExpressionUUID->"a1b92a5c-d2b8-43d7-805a-e1e51b1bbc3c",
 CellTags->"i:2"],
Cell[CellGroupData[{
Cell[2601, 85, 191, 4, 29, "Input",ExpressionUUID->"cb55bf85-2e19-43c0-b14c-a7bdeeec9f3e"],
Cell[2795, 91, 547, 16, 40, "Output",ExpressionUUID->"ef1b22aa-c1d3-428a-adda-4438488e2c7d",
 Evaluatable->False]
}, Open  ]],
Cell[3357, 110, 310, 10, 37, "CodeCaption",ExpressionUUID->"dddbd3e1-0263-4df5-b04d-ee4430ab5393",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[3692, 124, 196, 4, 29, "Input",ExpressionUUID->"c6ca45c4-4f24-4834-aa32-07b80398f2bf"],
Cell[3891, 130, 882, 36, 93, "Output",ExpressionUUID->"ccd5951a-2593-45c4-acab-43ce65b8dd2c",
 Evaluatable->False]
}, Open  ]],
Cell[4788, 169, 390, 14, 65, "Text",ExpressionUUID->"100c7f72-543e-4450-a1ec-ac4075111fa9",
 CellTags->"i:4"],
Cell[5181, 185, 194, 4, 37, "CodeCaption",ExpressionUUID->"8404e034-a88d-4807-aef4-b0d34d911258"],
Cell[CellGroupData[{
Cell[5400, 193, 192, 4, 29, "Input",ExpressionUUID->"0071d92d-cfa4-42da-a0fd-2f7d4144c768"],
Cell[5595, 199, 367, 14, 93, "Output",ExpressionUUID->"b2c279de-5e65-4e51-b281-36aced8d5c09",
 Evaluatable->False]
}, Open  ]],
Cell[5977, 216, 298, 9, 65, "Text",ExpressionUUID->"06a67b5d-f668-4a3e-9f0c-2543a8644c29",
 CellTags->"i:5"],
Cell[6278, 227, 182, 4, 37, "CodeCaption",ExpressionUUID->"f5c94eef-f8c2-4829-9249-b60429ab210e"],
Cell[CellGroupData[{
Cell[6485, 235, 980, 20, 53, "Input",ExpressionUUID->"81e27036-b9e4-43e9-af75-6518ca598aa1"],
Cell[7468, 257, 6088, 132, 70, "Output",ExpressionUUID->"6c6c7059-56ce-4deb-ac53-9ba8a1cc08ea",
 Evaluatable->False]
}, Open  ]],
Cell[13571, 392, 236, 6, 70, "CodeCaption",ExpressionUUID->"2d500334-3b04-4e98-bf6a-3b13f4296d37",
 CellTags->"i:6"],
Cell[CellGroupData[{
Cell[13832, 402, 1068, 23, 70, "Input",ExpressionUUID->"3b9fe65d-d943-4312-867e-67d443991301"],
Cell[14903, 427, 6157, 133, 70, "Output",ExpressionUUID->"6ef2f744-dfee-4341-9ae5-3dd4b09136a1",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[21075, 563, 240, 7, 70, "Text",ExpressionUUID->"2e5d52be-fd50-4fe4-9657-3192df64d00b",
 CellTags->"p:154"],
Cell[21318, 572, 205, 4, 70, "CodeCaption",ExpressionUUID->"8e3efbd1-356c-451f-927f-ca359f837d21",
 CellTags->"i:7"],
Cell[CellGroupData[{
Cell[21548, 580, 309, 9, 70, "Input",ExpressionUUID->"719c4753-71d2-4087-9139-46c94ad06765"],
Cell[21860, 591, 33083, 928, 70, "Output",ExpressionUUID->"8649a58f-3fd3-4943-9eed-4173bed0d725",
 Evaluatable->False]
}, Open  ]],
Cell[54958, 1522, 229, 7, 70, "Text",ExpressionUUID->"3b35d736-774e-48ca-87e0-ec473f8628fa"],
Cell[55190, 1531, 201, 4, 70, "CodeCaption",ExpressionUUID->"461d8b86-ad71-4d0c-9bd1-27d5bcf5a3c8",
 CellTags->"i:8"],
Cell[CellGroupData[{
Cell[55416, 1539, 249, 7, 70, "Input",ExpressionUUID->"d96a18a2-d7fe-46b3-96cf-d7662b9682d3"],
Cell[55668, 1548, 375, 9, 70, "Output",ExpressionUUID->"f10e2383-de1a-4738-8e0a-14c74686aefa",
 Evaluatable->False]
}, Open  ]],
Cell[56058, 1560, 180, 4, 70, "Text",ExpressionUUID->"dc5e784e-4f07-4a60-bfd4-0bab5fe678fd"],
Cell[56241, 1566, 219, 5, 70, "CodeCaption",ExpressionUUID->"bc3d2810-0297-464c-9656-f570ecf3f8e7",
 CellTags->"i:9"],
Cell[CellGroupData[{
Cell[56485, 1575, 236, 6, 70, "Input",ExpressionUUID->"6094dd97-ed8d-4e69-88bb-13237c5cc238"],
Cell[56724, 1583, 397, 9, 70, "Output",ExpressionUUID->"cfc4f97c-eda5-4f46-ba4e-1d8c9e1c66fd",
 Evaluatable->False]
}, Open  ]],
Cell[57136, 1595, 206, 4, 70, "CodeCaption",ExpressionUUID->"aed89092-53f4-4cad-a936-9433cd7d9958",
 CellTags->"i:10"],
Cell[CellGroupData[{
Cell[57367, 1603, 235, 6, 70, "Input",ExpressionUUID->"362588bd-9199-4796-b663-bee4054696f4"],
Cell[57605, 1611, 309, 8, 70, "Output",ExpressionUUID->"cfbfdd9f-5a10-493d-a6a1-b346a23a7092",
 Evaluatable->False]
}, Open  ]],
Cell[57929, 1622, 189, 4, 70, "Text",ExpressionUUID->"2f5be090-a7f7-4886-89ef-acdfde410fd9",
 CellTags->"i:11"],
Cell[58121, 1628, 170, 4, 70, "CodeCaption",ExpressionUUID->"d3a6a333-993d-47cc-959c-1de15a79efc1"],
Cell[CellGroupData[{
Cell[58316, 1636, 273, 8, 70, "Input",ExpressionUUID->"91c67c6f-7c0a-4edd-be53-2b569b696c59"],
Cell[58592, 1646, 763, 31, 70, "Output",ExpressionUUID->"a2453a6c-0d0e-4fcd-babe-aa9e7f417fbf",
 Evaluatable->False]
}, Open  ]],
Cell[59370, 1680, 291, 9, 70, "CodeCaption",ExpressionUUID->"5a90039f-9bab-45d5-834c-def75ca05e40",
 CellTags->"i:12"],
Cell[CellGroupData[{
Cell[59686, 1693, 302, 9, 70, "Input",ExpressionUUID->"e618c1b2-6933-4a01-9e89-c375f9fc81b1"],
Cell[59991, 1704, 537, 12, 70, "Output",ExpressionUUID->"c5f10c3e-aeca-4b2d-831a-7205aefdb7b5",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[60543, 1719, 352, 10, 70, "Text",ExpressionUUID->"03df411e-4a4c-4c62-ad9e-d60839eb297c",
 CellTags->{"p:155", "i:13"}],
Cell[60898, 1731, 202, 5, 70, "CodeCaption",ExpressionUUID->"cb2cfbfd-7fd0-43a4-9218-7534aa30624d"],
Cell[CellGroupData[{
Cell[61125, 1740, 385, 12, 70, "Input",ExpressionUUID->"b62b5b8b-87e9-457a-af15-9a2ed9c8bce6"],
Cell[61513, 1754, 750, 24, 70, "Output",ExpressionUUID->"13955e2d-70cc-4759-bddd-3f81180b1360",
 Evaluatable->False]
}, Open  ]],
Cell[62278, 1781, 250, 5, 70, "CodeCaption",ExpressionUUID->"4aaa9f74-7727-4f19-852f-76ad98c1d38c",
 CellTags->"i:14"],
Cell[CellGroupData[{
Cell[62553, 1790, 434, 13, 70, "Input",ExpressionUUID->"8286d3fa-028c-41a0-bff0-7b523f490975"],
Cell[62990, 1805, 2802, 59, 70, "Output",ExpressionUUID->"443b7541-3f50-40e9-8c87-44b1edee529b",
 Evaluatable->False]
}, Open  ]],
Cell[65807, 1867, 562, 18, 70, "Text",ExpressionUUID->"a40120e4-341c-4968-a530-f3c0fca36d65",
 CellTags->"i:15"],
Cell[66372, 1887, 306, 9, 70, "CodeCaption",ExpressionUUID->"ca4cc239-11b6-47dd-9e33-c4087703eddb"],
Cell[CellGroupData[{
Cell[66703, 1900, 243, 7, 70, "Input",ExpressionUUID->"e5c8d293-9ffc-44de-906a-f9d97429396d"],
Cell[66949, 1909, 416, 12, 70, "Output",ExpressionUUID->"f2cc0c8d-7f3a-4125-b73d-6ab08a4faa02",
 Evaluatable->False]
}, Open  ]],
Cell[67380, 1924, 312, 9, 70, "CodeCaption",ExpressionUUID->"7ad75769-16cf-4af6-9faf-63a39f4d2b1b"],
Cell[CellGroupData[{
Cell[67717, 1937, 270, 8, 70, "Input",ExpressionUUID->"bb8cb903-107b-4a19-b4ee-54a8a092037a"],
Cell[67990, 1947, 880, 28, 70, "Output",ExpressionUUID->"9c14ffb6-a8e3-4023-8e80-204eaf4c9fd3",
 Evaluatable->False]
}, Open  ]],
Cell[68885, 1978, 248, 7, 70, "CodeCaption",ExpressionUUID->"5724e240-6cb5-41e9-8d21-d77d0538d5b6",
 CellTags->"i:16"],
Cell[CellGroupData[{
Cell[69158, 1989, 307, 9, 70, "Input",ExpressionUUID->"ff249491-21fe-49f5-8a17-0124f45d4a2e"],
Cell[69468, 2000, 1457, 51, 70, "Output",ExpressionUUID->"93701045-7432-4940-8b45-6bbfbe4fcca7",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[70940, 2054, 243, 7, 70, "Text",ExpressionUUID->"593d3324-0a5a-490c-979d-b4a4b6e37e20",
 CellTags->"p:156"],
Cell[71186, 2063, 215, 6, 70, "CodeCaption",ExpressionUUID->"60eecff1-dbd5-465c-9ad9-89c0dd038143"],
Cell[CellGroupData[{
Cell[71426, 2073, 341, 10, 70, "Input",ExpressionUUID->"9a726920-f680-4134-a30b-d12fd1ab1656"],
Cell[71770, 2085, 4066, 135, 70, "Output",ExpressionUUID->"9fc1cd4f-b491-447d-abc0-b7ba34f87797",
 Evaluatable->False]
}, Open  ]],
Cell[75851, 2223, 209, 4, 70, "CodeCaption",ExpressionUUID->"a3eacb06-01c5-4ac7-83fb-a79918e4273b",
 CellTags->"i:17"],
Cell[CellGroupData[{
Cell[76085, 2231, 457, 14, 70, "Input",ExpressionUUID->"88d620cc-2d12-4b78-8051-2c27b5e934a2"],
Cell[76545, 2247, 8744, 299, 70, "Output",ExpressionUUID->"92a9b343-56cf-46d1-ac4f-f473fa632e5e",
 Evaluatable->False]
}, Open  ]],
Cell[85304, 2549, 207, 4, 70, "CodeCaption",ExpressionUUID->"bb7b9ffd-a27c-45b8-987b-2617ac70ebad",
 CellTags->"i:18"],
Cell[CellGroupData[{
Cell[85536, 2557, 457, 14, 70, "Input",ExpressionUUID->"a40e1a6e-dd71-4983-a4d2-845c30b4733e"],
Cell[85996, 2573, 5791, 202, 70, "Output",ExpressionUUID->"bdb398bf-d374-4394-90af-acb81a6725dd",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[91802, 2778, 236, 5, 70, "CodeCaption",ExpressionUUID->"fe5cfb92-7b6e-46e9-b562-c95c6a9fbfc9",
 CellTags->"p:157"],
Cell[CellGroupData[{
Cell[92063, 2787, 525, 15, 70, "Input",ExpressionUUID->"8e94b898-0a23-4828-866b-88ca27cd2828"],
Cell[92591, 2804, 12022, 318, 70, "Output",ExpressionUUID->"d10511ed-df9d-432b-9b78-b611dc3a1342",
 Evaluatable->False]
}, Open  ]],
Cell[104628, 3125, 643, 20, 70, "Text",ExpressionUUID->"6fe4ddc3-7f3f-4914-8085-a315163a59ba"],
Cell[105274, 3147, 209, 4, 70, "CodeCaption",ExpressionUUID->"8d8d5967-64e2-49d1-b30e-4d5ae70c8c07",
 CellTags->"i:19"],
Cell[CellGroupData[{
Cell[105508, 3155, 438, 13, 70, "Input",ExpressionUUID->"e1ec1d63-e987-40a4-8708-f0a31781de41"],
Cell[105949, 3170, 634, 18, 70, "Output",ExpressionUUID->"ef5c9b60-507c-4cac-8474-a48db82048ce",
 Evaluatable->False]
}, Open  ]],
Cell[106598, 3191, 362, 12, 70, "CodeCaption",ExpressionUUID->"f8ca5da7-0457-4180-a63c-cae119d89bdd",
 CellTags->"i:20"],
Cell[CellGroupData[{
Cell[106985, 3207, 475, 14, 70, "Input",ExpressionUUID->"19c75df3-f470-49a1-b289-80473e9dc8ec"],
Cell[107463, 3223, 768, 19, 70, "Output",ExpressionUUID->"7ef74fc3-dc1e-4203-b558-e4ecb4813b10",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[108246, 3245, 277, 9, 70, "Text",ExpressionUUID->"5a3bfc86-c281-4584-aff0-8b220fc6d37c",
 CellTags->"p:158"],
Cell[108526, 3256, 404, 12, 70, "CodeCaption",ExpressionUUID->"68ec5844-2737-49d7-ade2-c3a10cdd69fb"],
Cell[CellGroupData[{
Cell[108955, 3272, 329, 10, 70, "Input",ExpressionUUID->"088336b1-4bc2-4def-a2ab-f4c523836cd5"],
Cell[109287, 3284, 1614, 52, 70, "Output",ExpressionUUID->"13e5fc77-3c60-455e-8d8e-39fbba3b8c58",
 Evaluatable->False]
}, Open  ]],
Cell[110916, 3339, 295, 7, 70, "Text",ExpressionUUID->"b149651f-69f2-46d0-b1ed-0a6eab33acd1"],
Cell[111214, 3348, 186, 4, 70, "CodeCaption",ExpressionUUID->"2e9ee232-a793-4ca4-a1b6-6d5903580c2e"],
Cell[CellGroupData[{
Cell[111425, 3356, 369, 11, 70, "Input",ExpressionUUID->"1871148d-604e-44e2-bfa9-a9531f09b4d4"],
Cell[111797, 3369, 4241, 132, 70, "Output",ExpressionUUID->"a14d94d2-bdc1-436f-9221-28668e10b7ec",
 Evaluatable->False]
}, Open  ]],
Cell[116053, 3504, 533, 14, 70, "Text",ExpressionUUID->"5712924b-9567-4270-a9ae-3f2360484a80",
 CellTags->"i:21"],
Cell[116589, 3520, 365, 10, 70, "CodeCaption",ExpressionUUID->"0786e35f-8aa3-4e26-a553-18cd0b70bce2",
 CellTags->"i:22"],
Cell[CellGroupData[{
Cell[116979, 3534, 380, 10, 70, "Input",ExpressionUUID->"f2628035-86e6-45d6-a6e9-a3308b4bf899"],
Cell[117362, 3546, 6973, 163, 70, "Output",ExpressionUUID->"d37fe4a1-9d67-4ce4-bc26-41f72ee97916",
 Evaluatable->False]
}, Open  ]],
Cell[124350, 3712, 220, 6, 70, "CodeCaption",ExpressionUUID->"6e4d3766-a105-41ac-a5f9-a9b2efc5d665"],
Cell[CellGroupData[{
Cell[124595, 3722, 392, 12, 70, "Input",ExpressionUUID->"8777e817-c68b-46fd-a9ed-f1c01c9883de"],
Cell[124990, 3736, 5664, 111, 70, "Output",ExpressionUUID->"7ed99a99-a9df-4ae2-b719-149866e26b98",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[130669, 3850, 560, 15, 70, "Text",ExpressionUUID->"faf32d18-b5a7-4fd1-9e0d-43084fea0670",
 CellTags->{"p:159", "i:23"}],
Cell[131232, 3867, 292, 7, 70, "CodeCaption",ExpressionUUID->"78601800-3827-4429-a91a-d8523f0a674a"],
Cell[CellGroupData[{
Cell[131549, 3878, 1996, 43, 70, "Input",ExpressionUUID->"9e66214e-91a1-4bce-bbc7-78c3dace1999"],
Cell[133548, 3923, 15705, 300, 70, "Output",ExpressionUUID->"53b789ed-6fc2-45a0-8fa6-415158376b90",
 Evaluatable->False]
}, Open  ]],
Cell[149268, 4226, 426, 12, 70, "Text",ExpressionUUID->"a3598aba-ba48-428b-a549-cdc5cc4b1f53",
 CellTags->"i:24"],
Cell[149697, 4240, 217, 6, 70, "CodeCaption",ExpressionUUID->"e9fabb34-7a1a-44cd-8e5c-7a8a00f2aada"],
Cell[CellGroupData[{
Cell[149939, 4250, 405, 10, 70, "Input",ExpressionUUID->"f706746e-34bb-48fa-972e-fdf4a0c1a93c"],
Cell[150347, 4262, 15294, 272, 70, "Output",ExpressionUUID->"d4ba3131-6d70-4ab7-8133-27856731cdd9",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[165690, 4540, 159, 4, 70, "VocabularySection",ExpressionUUID->"3ffa75fa-0d1c-4d70-a2d6-5a754e58287e"],
Cell[165852, 4546, 2529, 70, 70, "VocabularyTable",ExpressionUUID->"a55fb0ba-d5fd-4b03-9bd1-2e21307697d8",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168418, 4621, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"064770d0-9dc7-47d7-b78d-eb03ee094749"],
Cell[CellGroupData[{
Cell[170223, 4671, 1474, 46, 70, "ExerciseSummaryCell",ExpressionUUID->"ebe0b97b-8c64-45f9-8a71-b5750616c2b4"],
Cell[CellGroupData[{
Cell[171722, 4721, 852, 24, 70, "Exercise",ExpressionUUID->"117c8006-fe6f-48a4-8e36-ec2c796e6cc2"],
Cell[172577, 4747, 46216, 853, 70, "ExerciseOutput",ExpressionUUID->"43e6fb7e-23cc-459a-8f72-96a00cd292a7"]
}, Closed]],
Cell[CellGroupData[{
Cell[218830, 5605, 1015, 28, 70, "Exercise",ExpressionUUID->"69f8b5cc-0edb-4654-89f2-94737189101f"],
Cell[219848, 5635, 22092, 547, 70, "ExerciseOutput",ExpressionUUID->"4b524e49-67e4-4574-a41c-29e089b2b41f"]
}, Closed]],
Cell[CellGroupData[{
Cell[241977, 6187, 814, 21, 70, "Exercise",ExpressionUUID->"9d98640f-b195-4bbf-96d2-9edf6842b565"],
Cell[242794, 6210, 6297, 168, 70, "ExerciseOutput",ExpressionUUID->"31e01dd9-f013-4e73-8be1-8f16f64f1d7d"]
}, Closed]],
Cell[CellGroupData[{
Cell[249128, 6383, 1241, 41, 70, "Exercise",ExpressionUUID->"e114f488-7b5b-458e-add7-534e3b717d80"],
Cell[250372, 6426, 6003, 125, 70, "ExerciseOutput",ExpressionUUID->"4bcea6b2-429d-42fe-85da-08109a3636c8"]
}, Closed]],
Cell[CellGroupData[{
Cell[256412, 6556, 1086, 34, 70, "Exercise",ExpressionUUID->"3e71dba0-896c-4706-9c19-16cf7c1c13d1"],
Cell[257501, 6592, 1107, 32, 70, "ExerciseOutput",ExpressionUUID->"7dace418-f0c1-4aed-8596-374c831f6df4"]
}, Closed]],
Cell[CellGroupData[{
Cell[258645, 6629, 750, 21, 70, "Exercise",ExpressionUUID->"897bd7e6-38b0-486e-8b1f-2bae0aeeee45"],
Cell[259398, 6652, 1464, 40, 70, "ExerciseOutput",ExpressionUUID->"409dfdb8-e338-4432-b1cd-faeaf8423c21"]
}, Closed]],
Cell[CellGroupData[{
Cell[260899, 6697, 1508, 48, 70, "Exercise",ExpressionUUID->"8a806f5d-421b-4aca-9407-cab4bf64f9a5",
 CellTags->"i:25"],
Cell[262410, 6747, 1670, 43, 70, "ExerciseOutput",ExpressionUUID->"857d9a28-920f-466b-a5f7-63656369b161"]
}, Closed]],
Cell[CellGroupData[{
Cell[264117, 6795, 979, 26, 70, "Exercise",ExpressionUUID->"69aeeb2c-708d-457b-92f1-f98526cacae8"],
Cell[265099, 6823, 42773, 718, 70, "ExerciseOutput",ExpressionUUID->"084f9d46-089c-40b1-a690-06c027790a56"]
}, Closed]],
Cell[CellGroupData[{
Cell[307909, 7546, 1121, 30, 70, "Exercise",ExpressionUUID->"23cabca6-9eb3-4e37-a1ac-206ecb4801c6",
 CellTags->"i:26"],
Cell[309033, 7578, 4388, 93, 70, "ExerciseOutput",ExpressionUUID->"9cdb285e-bd40-41ce-8cd1-8f07892f0669"]
}, Closed]],
Cell[CellGroupData[{
Cell[313458, 7676, 1121, 32, 70, "Exercise",ExpressionUUID->"1875dd2c-c024-40f1-8528-4581e96b9d04"],
Cell[314582, 7710, 47998, 870, 70, "ExerciseOutput",ExpressionUUID->"1454ac46-cce3-4cda-8a5f-4061e0ec9fff"]
}, Closed]],
Cell[CellGroupData[{
Cell[362617, 8585, 790, 21, 70, "Exercise",ExpressionUUID->"f985856d-76f4-4eff-96d2-81fe9e8e7f40"],
Cell[363410, 8608, 19161, 378, 70, "ExerciseOutput",ExpressionUUID->"a1ec8f30-e7a1-4603-ab06-eab7585648f7"]
}, Closed]],
Cell[CellGroupData[{
Cell[382608, 8991, 1171, 38, 70, "Exercise",ExpressionUUID->"a8f143c0-38a8-46af-91af-7a9de64fbd0f"],
Cell[383782, 9031, 4137, 95, 70, "ExerciseOutput",ExpressionUUID->"40ec1190-bbda-4461-979c-dcc11be55d17"]
}, Closed]],
Cell[CellGroupData[{
Cell[387956, 9131, 1226, 38, 70, "Exercise",ExpressionUUID->"5acbf216-cddc-4a02-a1af-67aa21d653d0"],
Cell[389185, 9171, 1264, 36, 70, "ExerciseOutput",ExpressionUUID->"cff36563-4b0a-4107-bd17-7c9d699c3151"]
}, Closed]],
Cell[CellGroupData[{
Cell[390486, 9212, 1270, 40, 70, "Exercise",ExpressionUUID->"4437feed-ea8b-4337-9096-d262963164d0"],
Cell[391759, 9254, 2423, 55, 70, "ExerciseOutput",ExpressionUUID->"cafd85e6-3e17-48d2-88bf-4a16c4c4211c"]
}, Closed]],
Cell[CellGroupData[{
Cell[394219, 9314, 1174, 38, 70, "Exercise",ExpressionUUID->"4312ee74-73b1-4815-bb18-e119effcc855"],
Cell[395396, 9354, 1865, 47, 70, "ExerciseOutput",ExpressionUUID->"7f98d014-e758-4b88-a5a3-a9b46639b7de"]
}, Closed]],
Cell[CellGroupData[{
Cell[397298, 9406, 992, 26, 70, "Exercise",ExpressionUUID->"3d755c28-577a-4d6b-9164-4b90f4f4bd4a"],
Cell[398293, 9434, 64290, 1071, 70, "ExerciseOutput",ExpressionUUID->"7133fecc-799e-45e9-a66a-4c6d87aa9a8a"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[462644, 10512, 144, 4, 70, "QASection",ExpressionUUID->"32f20461-3f80-4625-880d-c15af3415cff"],
Cell[462791, 10518, 213, 5, 70, "Question",ExpressionUUID->"103e613e-89d1-46e5-930a-73b2656e46f5"],
Cell[463007, 10525, 692, 15, 70, "Answer",ExpressionUUID->"5fad44ee-fa56-40cb-b0dc-3e5b627b5066",
 CellTags->"i:27"],
Cell[463702, 10542, 209, 6, 70, "Question",ExpressionUUID->"62cc088b-c98f-4cc7-a9f9-568600804a73"],
Cell[463914, 10550, 348, 8, 70, "Answer",ExpressionUUID->"bd76b34f-8559-4c49-bd2d-1d95f9ca33e8",
 CellTags->"i:28"],
Cell[464265, 10560, 183, 4, 70, "Question",ExpressionUUID->"f5c99d83-a456-4c9c-a678-6669a60f370f"],
Cell[464451, 10566, 717, 18, 70, "Answer",ExpressionUUID->"99935d3e-72d2-4570-ac8c-717cab269750",
 CellTags->"i:29"],
Cell[465171, 10586, 229, 9, 70, "Question",ExpressionUUID->"e7f394d2-b181-4ebf-a5a0-6f5f233f9739"],
Cell[465403, 10597, 519, 12, 70, "Answer",ExpressionUUID->"b2bbfa4e-c0cc-4aa4-90e3-8313fd1abc0d",
 CellTags->"i:30"],
Cell[465925, 10611, 239, 7, 70, "Question",ExpressionUUID->"baa79414-e9d1-4ada-bc52-76398d6d946d"],
Cell[466167, 10620, 495, 14, 70, "Answer",ExpressionUUID->"ddbf3ce4-4840-4c16-a28c-bcc63c80cc07",
 CellTags->"LastCellOfAPage"],
Cell[466665, 10636, 700, 26, 70, "Question",ExpressionUUID->"92a13f8e-132b-4061-a8e8-c8df7c970144",
 CellTags->"p:161"],
Cell[467368, 10664, 1538, 56, 70, "Answer",ExpressionUUID->"75368442-18b7-4943-8a7c-e317494197cc"],
Cell[468909, 10722, 217, 6, 70, "Question",ExpressionUUID->"3eb37847-8396-4531-a5ce-cbaeb007fb27"],
Cell[469129, 10730, 408, 16, 70, "Answer",ExpressionUUID->"250901bb-3b70-44d4-83a1-7c13fe029413"]
}, Open  ]],
Cell[CellGroupData[{
Cell[469574, 10751, 156, 4, 70, "TechNoteSection",ExpressionUUID->"6c1257f0-eaab-4743-953f-ed6c138e28f1"],
Cell[469733, 10757, 687, 20, 70, "TechNote",ExpressionUUID->"0c284f95-01d4-4afe-affd-125ce452125c",
 CellTags->"i:31"]
}, Open  ]],
Cell[CellGroupData[{
Cell[470457, 10782, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"6c54fdae-86ac-4005-9b9e-67fd7b915314"],
Cell[470625, 10788, 354, 8, 70, "MoreExplore",ExpressionUUID->"ffc6e443-a25b-497b-ad37-3ec9b576bf98",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature YLziTOes0YkfXIOekNAGjw5A *)
