(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    432787,       9384]
NotebookOptionsPosition[    316866,       7061]
NotebookOutlinePosition[    414760,       9074]
CellTagsIndexPosition[    413760,       9032]
WindowTitle->More about Numbers: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "More about Numbers", "SectionInline",ExpressionUUID->
   "de80174f-ce62-4090-911c-cda245961ca9"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 22}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:129",ExpressionUUID->"4174f847-ae22-414e-9c8b-8b0f59c859da"],

Cell["\<\
When you do a computation with whole numbers, the Wolfram Language gives you \
an exact answer. It does the same with exact fractions.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"2d058abb-f64a-416c-9f2b-518b3162d260"],

Cell["Adding 1/2+1/3 gives an exact answer as a fraction:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"25b6421b-74bd-4a0c-b04d-694b2e04b31c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "2"}], "+", 
  RowBox[{"1", "/", "3"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"b6b20165-57e3-4bc0-b8ad-cd59571c8e73"],

Cell[BoxData[
 FractionBox["5", "6"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"7b2fa9ed-ece6-4a0b-b7ed-63ffcb0d650c"]
}, Open  ]],

Cell[TextData[{
 "Often you\[CloseCurlyQuote]ll just want a numerical or decimal \
approximation. You can get that using the function ",
 ButtonBox["N",
  BaseStyle->"Link"],
 " (for \[OpenCurlyDoubleQuote]numerical\[CloseCurlyDoubleQuote])."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "N", "i:2"},ExpressionUUID->"d3fd047f-e58d-4e59-8117-97fc50780911"],

Cell["Get an approximate numerical answer:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9ae36941-9b33-4a9f-8c6a-a764c3f8b19d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "+", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"7d8fc03f-9b95-4e1a-84d9-af3c53c3fad7"],

Cell[BoxData["0.8333333333333334`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"24304131-d0c3-4977-a284-708fc8834d02"]
}, Open  ]],

Cell["\<\
If there\[CloseCurlyQuote]s any decimal number in your input, the Wolfram \
Language will automatically give you an approximate answer.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f2d3dee8-94ea-4d15-8d8c-ce7aaaef9e0c"],

Cell["\<\
The presence of a decimal number makes the result be approximate:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0995279d-df6d-43fe-baad-ce8ab22a1883"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1.8", "/", "2"}], "+", 
  RowBox[{"1", "/", "3"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"88e122a1-af9d-435a-842a-ca2587dfdf52"],

Cell[BoxData["1.2333333333333334`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"cd7d2288-9b0d-4d20-acbb-2f78cae469c5"]
}, Open  ]],

Cell["\<\
It\[CloseCurlyQuote]s enough just to have a decimal point at the end of a \
number:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"e717a649-0ab8-4463-a2da-7e2641a87422"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "2."}], "+", 
  RowBox[{"1", "/", "3"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"e1dcdd0d-4988-4538-9e7f-c004efe04663"],

Cell[BoxData["0.8333333333333333`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"999b461c-57ed-435a-89f2-fc4fb187c17a"]
}, Open  ]],

Cell["\<\
The Wolfram Language can handle numbers of any size, at least so long as they \
fit in your computer\[CloseCurlyQuote]s memory. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"bf08a97f-467c-4184-8a28-dadf9a67b6e6"],

Cell["Here\[CloseCurlyQuote]s 2 raised to the power 1000:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c815eb0f-bcee-49e6-9b16-44fc3858d30b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "^", "1000"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"f0e16520-4775-4266-bbd6-546f4226c218"],

Cell[BoxData[\
"10715086071862673209484250490600018105614048117055336074437503883703510511249\
361224931983788156958581275946729175531468251871452856923140435984577574698574\
803934567774824230985421074605062371141877954182153046474983581941267398767559\
165543946077062914571196477686542167660429831652624386837205668069376"], \
"Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"9f6b3ef1-2e55-49b5-8428-bbfc46d9fe89"]
}, Open  ]],

Cell["Get a numerical approximation:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ead9d55c-22c3-4b50-8555-6c5fb7536bf3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"2", "^", "1000"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"836cc09d-2f6b-40d6-8ae3-411f9e512f22"],

Cell[BoxData["1.0715086071862673`*^301"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[6]=",ExpressionUUID->"daff41b3-0914-467c-918b-ede4b5321ef9"]
}, Open  ]],

Cell[TextData[{
 "This approximate form is given in ",
 StyleBox["scientific notation",
  FontSlant->"Italic"],
 ". If you need to enter scientific notation, you can do it with *^."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:130", "i:5"},ExpressionUUID->"a7ce3ad6-675f-4f51-a285-9e8440145589"],

Cell["Enter a number in scientific notation:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"29e01b6c-aee0-44b7-956a-e5f9b4c1d114"],

Cell[CellGroupData[{

Cell[BoxData["2.7*^6"], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"703f8398-1ddf-428d-a3f2-0d144bb5dc3e"],

Cell[BoxData["2.7`*^6"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"ec9f16c9-394b-4092-8794-d1c08e7bae53"]
}, Open  ]],

Cell["\<\
Commonly used numbers like \[Pi] (pi) are built into the Wolfram Language.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"23bb0105-2dc4-418d-8251-9a9f72d79c96"],

Cell["Get a numerical approximation to \[Pi]:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"85b542a8-4d21-499a-976a-d74888bb579f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "Pi", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"2869f516-d2d9-45e1-8576-e404d3abfda0"],

Cell[BoxData["3.141592653589793`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"d62b7b73-818b-4930-9f94-9823497ddeb0"]
}, Open  ]],

Cell[TextData[{
 "The Wolfram Language can compute ",
 "to ",
 StyleBox["arbitrary precision",
  FontSlant->"Italic"],
 ", so for example it can find millions of digits of \[Pi] if you want them."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"6b255915-602c-405b-adef-42a9ed496c92"],

Cell["Compute 250 digits of \[Pi]: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"79bf81c7-9a70-4caa-b191-18ca2b49f274"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "250"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"63b20854-5998-4683-9229-d37be1e3fdef"],

Cell[BoxData["3.\
141592653589793238462643383279502884197169399375105820974944592307816406286208\
998628034825342117067982148086513282306647093844609550582231725359408128481117\
450284102701938521105559644622948954930381964428810975665933446128475648233786\
78316527120190914564856692346034861`250."], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"256c0282-2d99-43aa-b07e-002cca40e078"]
}, Open  ]],

Cell[TextData[{
 "There are many functions in the Wolfram Language that handle",
 " ",
 StyleBox["integers",
  FontSlant->"Italic"],
 " (whole numbers). There are also many functions that handle ",
 StyleBox["real numbers",
  FontSlant->"Italic"],
 "\[LongDash]approximate numbers with decimals. An example is ",
 ButtonBox["RandomReal",
  BaseStyle->"Link"],
 ", which gives random real numbers."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"35943a6a-582a-4b9d-b728-f46dd3ae046a"],

Cell["Generate a random real number in the range 0 to 10:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d0634c8e-fb48-47d6-9912-dc46caf11c5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", "10", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"a215304b-76f3-4290-8401-c1d3ea8b411b"],

Cell[BoxData["2.0865819759127913`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"82788a07-a5c9-48de-97b7-6443182478d6"]
}, Open  ]],

Cell["Generate 5 random real numbers:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f16ad17d-758b-42cc-a65e-e526ee13d975"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", "10", "]"}], ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"c3a428bf-3081-4384-8176-7a756f011cd5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.1507084723057055`", ",", "4.810483812353969`", ",", "8.829445832932162`",
    ",", "9.849952861563565`", ",", "9.08312621618083`"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"ca0293dc-1e41-4717-ab9c-b3b3c37ef66a"]
}, Open  ]],

Cell["An alternative way to ask for 5 random real numbers:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4fd35bc5-488f-4d17-a86f-35de4fd79355"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"10", ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"d646851d-9a9d-4510-9183-d61f0b42db18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.473181755576302`", ",", "3.2918089598141336`", ",", 
   "3.5761522518020854`", ",", "8.112044007761153`", ",", 
   "3.3828559170314048`"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[12]=",ExpressionUUID->"73299547-9450-43a7-bbe8-841773bd74c1"]
}, Open  ]],

Cell["Random real numbers in the range 20 to 30:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:131", "i:9"},ExpressionUUID->"40b83260-0a72-49a0-89fd-b9fb2dccb2fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "30"}], "}"}], ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"e2c27f93-6c00-49c2-b0fe-7624535ba55d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24.120200165852403`", ",", "20.128845248353176`", ",", 
   "20.392967801959244`", ",", "25.645548008209914`", ",", 
   "20.92678128449365`"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"0a813e1e-2187-4dcf-b858-d85e34f378ac"]
}, Open  ]],

Cell["\<\
The Wolfram Language has a huge range of mathematical functions built in, \
from basic to very sophisticated. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8d742481-2f87-44f4-9033-8d6bc5c1254d"],

Cell["Find the 100th prime number:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"04c8003c-ce89-4382-b33a-0b0d0bcd1835"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", "100", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"cca9ab5c-dbe3-4596-b18a-ec43c2e4364e"],

Cell[BoxData["541"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"27013d6b-214f-4811-bc5e-0a1fdb10fc46"]
}, Open  ]],

Cell["Find the millionth prime number:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5f424bd2-3eae-4e51-b948-5e9dbc94c741"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", "1000000", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"4e69a332-e405-4f62-b4d7-95b646458ffc"],

Cell[BoxData["15485863"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"580a1f2c-abfe-4a4d-9f9f-d9f19a9ffbd3"]
}, Open  ]],

Cell["Plot the first 50 primes:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d1b33f4d-a5eb-433b-8591-0071d19e0cd6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"c11b2a80-fb08-47c6-97db-9435436aef78"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd0UlKw2AYBuDgyqULFy5cVBEREdE6j411FhStIk5grNaKFrxCjpKj5Cg5
gkdQ+Z8skkB48+TN8CffRPe70xuKoqj5t/9n2H5aDuJqDtdyVI7I8dr5aTkm
Z2vXLcqGXJKTck1OyZ3ac1tyJmTarr4nPeA5PuR5PuYFPquuKz3nJl9U15lf
8jJf8UrIuMOr+uvqd+U3vO76W97gO97ke95yf+ltfmD/KX7kXX5i/y1/5jhk
koRMufGi39NzyllX3w5ZcDmH7FW/7/43PRccmVPW03Pyrje3jMs5Fn39kfV+
6DnjyJyLsufkU3+i/9JzMtCfet4g/gUZ8k7e
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{205.2421875, Automatic},
  Method->{},
  PlotRange->{{0., 50.}, {0, 229.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"4e57469f-e4db-4a50-a5c7-f7329d12265b"]
}, Open  ]],

Cell[TextData[{
 "Three functions common in many practical situations are",
 " ",
 ButtonBox["Sqrt",
  BaseStyle->"Link"],
 " (square root), ",
 ButtonBox["Log10",
  BaseStyle->"Link"],
 " (logarithm to base 10) and ",
 ButtonBox["Log",
  BaseStyle->"Link"],
 " (natural logarithm)."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"6375a871-b361-41e9-b6fa-281989060b79"],

Cell["The square root of 16 is 4:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"907cd409-3d3d-4756-a8a3-ea584500a36c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "16", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"b97e8836-366f-463f-9547-b8d000600f5a"],

Cell[BoxData["4"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"1f244842-5ea8-4155-bb69-93d263525882"]
}, Open  ]],

Cell["\<\
If you don\[CloseCurlyQuote]t ask for a numerical approximation, you\
\[CloseCurlyQuote]ll get an exact formula:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d24eda1b-43d2-43f8-8ae2-805c95ef923f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "200", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"6e923ca1-2fb0-4be3-9ea4-aca6b3dbe40a"],

Cell[BoxData[
 RowBox[{"10", " ", 
  SqrtBox["2"]}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"f597fff0-0831-472b-bcef-700c9997884f"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["N",
  BaseStyle->"Link"],
 " gives a numerical approximation:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"aebe28f5-6562-4d55-bfca-5fe4adfbd560"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sqrt", "[", "200", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"30ee1741-0e63-42b2-9777-10a9342e9327"],

Cell[BoxData["14.142135623730951`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[19]=",ExpressionUUID->"896bda47-5759-4a18-8e60-425d755eb8a2"]
}, Open  ]],

Cell[TextData[{
 "Logarithms are often useful when you\[CloseCurlyQuote]re dealing with \
numbers that have a wide range of sizes. Let\[CloseCurlyQuote]s plot the \
masses of the planets. With ",
 ButtonBox["ListPlot",
  BaseStyle->"Link"],
 " one can\[CloseCurlyQuote]t tell anything about the planets before Jupiter. \
But ",
 ButtonBox["ListLogPlot",
  BaseStyle->"Link"],
 " shows the relative sizes much more clearly."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:132", "i:12"},ExpressionUUID->"cfc96cdb-090f-4c40-9adc-9c059b558c36"],

Cell[TextData[{
 "Make an ordinary ",
 ButtonBox["ListPlot",
  BaseStyle->"Link"],
 " of the masses of the planets:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8e2b4e3d-699d-4248-a3a0-d6d4b461b7ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   TemplateBox[{"\"planets\"", 
     RowBox[{"EntityClass", "[", 
       RowBox[{"\"Planet\"", ",", "All"}], "]"}], 
     "\"EntityClass[\\\"Planet\\\", All]\"", "\"planets\""},
    "EntityClass"], "[", "\"\<Mass\>\"", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"c239b25f-512b-4a74-91aa-2e877a86a3d5"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 3.30104*^23}, {2., 4.86732*^24}, {3., 5.9721986*^24}, {4.,
       6.41693*^23}, {5., 1.89813*^27}, {6., 5.68319*^26}, {7., 
      8.68103*^25}, {8., 1.0241*^26}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{193.390625, Automatic},
  Method->{},
  PlotRange->{{0., 8.}, {0, 1.89813*^27}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"a7b7430b-f71c-412d-aec9-69d9d1359d89"]
}, Open  ]],

Cell["Make a log plot:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"7001d9d3-49bc-4e13-a3d7-25d8b14c2816"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   TemplateBox[{"\"planets\"", 
     RowBox[{"EntityClass", "[", 
       RowBox[{"\"Planet\"", ",", "All"}], "]"}], 
     "\"EntityClass[\\\"Planet\\\", All]\"", "\"planets\""},
    "EntityClass"], "[", "\"\<Mass\>\"", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"ca86f866-ddee-4416-b12a-2ca747c1e48c"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 54.15369470920083}, {2., 56.844585709468355`}, {3., 
      57.04915736617199}, {4., 54.818396949047695`}, {5., 
      62.810666701832105`}, {6., 61.60472511264723}, {7., 59.7257675100779}, {
      8., 59.891026595944446`}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 53.525366096832435`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{194.85546875, Automatic},
  Method->{},
  PlotRange->{{0., 8}, {53.67275182072132, 62.810666701832105`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[{Log, Exp}]}, {Automatic, {{55.262042231857095`, 
       FormBox[
        TemplateBox[{"10", "24"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {57.564627324851145`, 
       FormBox[
        TemplateBox[{"10", "25"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {59.86721241784519, 
       FormBox[
        TemplateBox[{"10", "26"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {62.16979751083923, 
       FormBox[
        TemplateBox[{"10", "27"}, "Superscript", SyntaxForm -> 
         SuperscriptBox], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {52.95945713886305, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {53.652604319423, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {54.05806942753116, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {54.34575149998294, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {54.568895051297154`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {54.751216608091106`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {54.90536728791837, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {55.038898680542886`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {55.15668171619927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {55.95518941241704, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {56.36065452052521, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {56.64833659297699, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {56.8714801442912, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {57.05380170108515, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {57.20795238091241, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {57.34148377353693, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {57.459266809193316`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {58.257774505411085`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {58.66323961351925, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {58.95092168597103, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {59.17406523728524, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {59.3563867940792, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {59.51053747390645, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {59.64406886653098, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {59.76185190218736, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {60.560359598405135`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {60.965824706513295`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {61.253506778965075`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {61.47665033027929, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {61.65897188707324, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {61.8131225669005, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {61.94665395952502, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {62.06443699518141, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {62.86294469139918, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {63.268409799507346`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {63.556091871959126`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {63.779235423273335`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {63.961556980067286`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {64.11570765989455, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {64.24923905251907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {64.36702208817545, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {64.47238260383328, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {65.16552978439323, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {65.57099489250139, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"1f9d70f5-b4dd-4911-9262-e2e56776d920"]
}, Open  ]],

Cell[TextData[{
 "There are a few more functions that show up frequently in general \
programming. First, there\[CloseCurlyQuote]s the almost trivial function ",
 ButtonBox["Abs",
  BaseStyle->"Link"],
 ", that ",
 "finds the absolute value, or positive part, of a number."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"113dd28c-be27-445e-bd68-572d02798461"],

Cell[TextData[{
 ButtonBox["Abs",
  BaseStyle->"Link"],
 " effectively just drops minus signs:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f379e594-0307-489b-a937-cf97a099f455"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Abs", "[", "3", "]"}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"-", "3"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"d4eff812-2695-4528-a793-9c974c57c649"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"addcc5e6-c844-488a-913b-741383e520d1"]
}, Open  ]],

Cell[TextData[{
 "Next there\[CloseCurlyQuote]s ",
 ButtonBox["Round",
  BaseStyle->"Link"],
 ", which rounds to the nearest whole number."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"7ce54f89-d9f2-4335-8e18-fec7a2867e9b"],

Cell[TextData[{
 ButtonBox["Round",
  BaseStyle->"Link"],
 " rounds to the nearest whole number:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d8fd674b-252b-46ef-bff3-37e5a415a001"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Round", "[", "3.2", "]"}], ",", 
   RowBox[{"Round", "[", "3.4", "]"}], ",", 
   RowBox[{"Round", "[", "3.6", "]"}], ",", 
   RowBox[{"Round", "[", "3.9", "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"480283e6-1363-4566-a2a8-6fac3b56cb0e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3", ",", "4", ",", "4"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[23]=",ExpressionUUID->"29a02990-2f78-4359-a12a-d45fe50191e7"]
}, Open  ]],

Cell[TextData[{
 "Another function that\[CloseCurlyQuote]s very useful is ",
 ButtonBox["Mod",
  BaseStyle->"Link"],
 ". ",
 "Let\[CloseCurlyQuote]s say you\[CloseCurlyQuote]re counting up minutes in \
an hour. When you reach 60, you\[CloseCurlyQuote]ll want to start again from \
0. That\[CloseCurlyQuote]s what ",
 ButtonBox["Mod",
  BaseStyle->"Link"],
 " lets you do. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:133", "i:16"},ExpressionUUID->"ee932637-fd2c-4eeb-898c-cb8e28236863"],

Cell["Compute a sequence of numbers mod 60:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f11ef301-b6c4-4c6b-9972-61581b6f3053"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{"50", ",", "60"}], "]"}], ",", 
   RowBox[{"Mod", "[", 
    RowBox[{"55", ",", "60"}], "]"}], ",", 
   RowBox[{"Mod", "[", 
    RowBox[{"60", ",", "60"}], "]"}], ",", 
   RowBox[{"Mod", "[", 
    RowBox[{"65", ",", "60"}], "]"}], ",", 
   RowBox[{"Mod", "[", 
    RowBox[{"70", ",", "60"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"36a58e7f-9e69-470a-ba5c-a0808ec6e6d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"50", ",", "55", ",", "0", ",", "5", ",", "10"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"f91a9482-cb86-4291-a7da-f6bb16cf9ab4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1d4d534e-0e15-49bb-80e8-f5e4e9f4b9a8"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["expr", "CodeVariableLrg"], "]"}], " ", Cell[
    "numerical approximation ", "VocabularyText",ExpressionUUID->
     "3848a093-75a0-4599-9617-7ecd405b8e71"]},
   {
    ButtonBox["Pi",
     BaseStyle->"CodeLink"], " ", Cell[
    "the number \[Pi] (pi)\[TildeEqual]3.14 ", "VocabularyText",
     ExpressionUUID->"7940a769-4531-4af8-bcb8-d329ca481af2"]},
   {
    RowBox[{
     ButtonBox["Sqrt",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["x", "CodeVariableLrg"], "]"}], " ", Cell[
    "square root ", "VocabularyText",ExpressionUUID->
     "24e3a9ad-57f9-4e18-a6dd-89ef049191cf"]},
   {
    RowBox[{
     ButtonBox["Log10",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["x", "CodeVariableLrg"], "]"}], " ", Cell[
    "logarithm to base 10 ", "VocabularyText",ExpressionUUID->
     "d5402188-1241-4239-87e8-3f9dbfc7957a"]},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["x", "CodeVariableLrg"], "]"}], " ", Cell[
    "natural logarithm (ln) ", "VocabularyText",ExpressionUUID->
     "c7b160ff-1428-4776-8a8a-cf9ea7192f87"]},
   {
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["x", "CodeVariableLrg"], "]"}], " ", Cell[
    "absolute value (drop minus signs) ", "VocabularyText",ExpressionUUID->
     "34f62962-8ddc-4a14-a058-fd4c169fcb91"]},
   {
    RowBox[{
     ButtonBox["Round",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["x", "CodeVariableLrg"], "]"}], " ", Cell[
    "round to nearest integer ", "VocabularyText",ExpressionUUID->
     "bc9d5b55-c7b8-4a1e-afa1-c69a41667771"]},
   {
    RowBox[{
     ButtonBox["Prime",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["n", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "85728bd0-7490-4a8a-8575-5db4f2507126"],
     "th prime number"
    }], "VocabularyText",ExpressionUUID->
     "d75b98ef-c2aa-49a0-b601-6f8b4d3cf630"]},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["x", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "modulo (\[OpenCurlyDoubleQuote]clock arithmetic\[CloseCurlyDoubleQuote]) \
", "VocabularyText",ExpressionUUID->"432266bc-79a5-4528-8858-82d54d4b22fc"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["max", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     "random real number between 0 and ",
     Cell[BoxData[
      StyleBox["max", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "a275bdc6-45b0-4929-ac90-8a9d99d50e31"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "bf8cfb43-41e5-4093-91b6-1e74b6a6bd82"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["max", "CodeVariableLrg"], ",", 
      StyleBox["n", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "c8ca549d-9fac-4235-8066-22c6d0eb34e1"],
     " random real numbers"
    }], "VocabularyText",ExpressionUUID->
     "bfb171ec-c0a1-4e18-9b09-bb6fb373105b"]},
   {
    RowBox[{
     ButtonBox["ListLogPlot",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["data", "CodeVariableLrg"], "]"}], " ", Cell[
    "plot on a logarithmic scale ", "VocabularyText",ExpressionUUID->
     "19a2eece-efcf-455e-aa8c-0bb1d3e37567"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6b0e53e2-4ec7-40ca-88cf-70b89f547ebb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"7a24815e-852d-42d6-a589-9df0d291186d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"14 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 4 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-23-more-about-numbers-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"da401a29-a344-474d-bf8a-a523b368a3e3"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]],ExpressionUUID->
  "a108851f-f607-487e-a01d-4e3c355d27b3"],
 " to 500-digit precision.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9f55571f-7dcc-48b8-b66f-9d16d496aaf9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "1.414213562373095048801688724209698078569671875376948073176679737990732\
478462107038850387534327641572735013846230912297024924836055850737212644121497\
099935831413222665927505592755799950501152782060571470109559971605970274534596\
862014728517418640889198609552329230484308714321450839762603627995251407989687\
253396546331808829640620615258352395054745750287759961729835575220337531857011\
354374603408498847160386899970699004815030544027790316454247823068492936918621\
5805784631115966687130130156185689872372352885092648612494977`500."], 
       "ExerciseOutput",ExpressionUUID->
       "97e59aaa-cba9-45f9-bdc6-4a21c5c7287c"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "1.4142135623730950488016887242096980785696718753769480731766797379907\
324784621070388503875343276415727350138462309122970249248360558507372126441214\
970999358314132226659275055927557999505011527820605714701095599716059702745345\
968620147285174186408891986095523292304843087143214508397626036279952514079896\
872533965463318088296406206152583523950547457502877599617298355752203375318570\
113543746034084988471603868999706990048150305440277903164542478230684929369186\
215805784631115966687130130156185689872372352885092648612494977`500."], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4d777b65-c375-4a61-a5b1-108539c5ae4f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate 10 random real numbers between 0 and 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"54ba0f81-b7a6-42a3-898c-a5fbc8c3c454"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "0.9817568927731188`", ",", "0.5015711331804931`", ",", 
         "0.08052820128683269`", ",", "0.02470735293681292`", ",", 
         "0.0663221225442896`", ",", "0.812191478033303`", ",", 
         "0.9297209349105184`", ",", "0.9491638382741032`", ",", 
         "0.6741541554784585`", ",", "0.0702841161822747`"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "0a3b4222-c3fb-445d-8c60-4cd15b5363d2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"0.9817568927731188`", ",", "0.5015711331804931`", ",", 
             "0.08052820128683269`", ",", "0.02470735293681292`", ",", 
             "0.0663221225442896`", ",", "0.812191478033303`", ",", 
             "0.9297209349105184`", ",", "0.9491638382741032`", ",", 
             "0.6741541554784585`", ",", "0.0702841161822747`"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f9b10b01-8806-412f-a601-55103ae8f63a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a plot of 200 points with random real ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and ",
 StyleBox["y",
  FontSlant->"Italic"],
 " coordinates between 0 and 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e24b7fb3-faff-43dd-ab65-59f67e537c17"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.009166666666666668], AbsoluteThickness[1.6], 
           PointBox[CompressedData["
1:eJwVVnk4FNr/nspNSbdIv7p0kWRL0iXblXcKXSJJmz2RUlFDypoUipRQhCSK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            "]]}, {}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{344.0703125, Automatic},
        Method->{},
        PlotRange->{{0, 0.9974282039667004}, {0, 0.9906755902044053}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "240be263-2840-413f-9556-108bba5e91bf"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.009166666666666668], 
                AbsoluteThickness[1.6], 
                PointBox[CompressedData["
1:eJwVVnk4FNr/nspNSbdIv7p0kWRL0iXblXcKXSJJmz2RUlFDypoUipRQhCSK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                 "]]}}}}, {}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {344.0703125, Automatic}, 
          Method -> {}, 
          PlotRange -> {{0, 0.9974282039667004}, {0, 0.9906755902044053}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e4c2f226-5735-4d99-ba08-266f689e1edd"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a random walk using ",
 ButtonBox["AnglePath",
  BaseStyle->"Link"],
 " and 1000 random real numbers between 0 and 2\[Pi].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c8e26c3c-ce6c-445f-8fc9-4ea3bd551078"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[LineBox[CompressedData["
1:eJxdWmk0le/XNs/zPDvnOMc8nWMmzjamQYaiUolk+lEqaSCRhEyhjBkSUZIm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         "]],
        ImageSize->{336.5, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "0ac8faed-20b6-40b9-be9f-766132c7ec7c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          LineBox[CompressedData["
1:eJxdWmk0le/XNs/zPDvnOMc8nWMmzjamQYaiUolk+lEqaSCRhEyhjBkSUZIm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           "]], 
          ImageSize -> {336.5, Automatic}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"92cecef9-3123-4748-8ba6-86069e94c57e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"n", "^", "2"}], ",", "10"}], "]"}]], "InlineCode",ExpressionUUID->
  "15b0f936-5325-4c44-901e-4fd87b4b3b4b"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"6e544245-3e19-431c-ab84-e4f5634ffbeb"],
 " from 0 to 30.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7cf7b98c-1063-47cf-9258-ec5afa2f791e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "4", ",", "9", ",", "6", ",", "5", ",", "6", ",", 
         "9", ",", "4", ",", "1", ",", "0", ",", "1", ",", "4", ",", "9", ",",
          "6", ",", "5", ",", "6", ",", "9", ",", "4", ",", "1", ",", "0", 
         ",", "1", ",", "4", ",", "9", ",", "6", ",", "5", ",", "6", ",", "9",
          ",", "4", ",", "1", ",", "0"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"3c294e17-708f-4042-b6df-47aaaff93c8a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"0", ",", "1", ",", "4", ",", "9", ",", "6", ",", "5", ",",
              "6", ",", "9", ",", "4", ",", "1", ",", "0", ",", "1", ",", "4",
              ",", "9", ",", "6", ",", "5", ",", "6", ",", "9", ",", "4", ",",
              "1", ",", "0", ",", "1", ",", "4", ",", "9", ",", "6", ",", "5",
              ",", "6", ",", "9", ",", "4", ",", "1", ",", "0"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"060b4a8c-2752-4fdd-8a6a-502bf2713d5e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"n", "^", "n"}], ",", "10"}], "]"}]], "InlineCode",ExpressionUUID->
  "c7a68a86-e5ce-4b24-9489-7c1a61013a88"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"404ac87a-c646-4c42-93a1-c942c559fdaf"],
 " from 1 to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b28c9553-fb3d-4500-9fa0-00e1438baabc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdkDlKhEEQRhsjQwODCQxURERExn132nHfddxT0dgr9NH6SB5BZeoJ/X4Y
ijcfVf2qpt6/Bp8jKaWP399fHX7fvbamPCxjUUejTuj/TtRx1Y4qfcyZVD6t
OpNT883m1m9O/fOav6B8UX5d5UvyXI7KnivyW5XfmvzW1b+h+Zt6f0t+28p3
orLfrvI9+e3Lrye/3PYXmPkHymH8+sph9juMGvsXGL+j1q/A+B2rH2b+id6H
8TtVDrPfmXIYv3P5wfhdqB9m/qVyGL8r5TD7XUdlfxi/G/nB+N2qH2b+Xft+
hsOvKK8w+92rHw6/AsdXYfwG6odjflFeYe73oH449itw7F/h8EuPrV+Gw6/A
9MPc70nvw9xPeYW537P64fArcHwV5n4v6oe5n/IKc79X9cPcD2Z/OPzS27/f
D0zEcnQ=
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 100.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "ec0955ba-645c-414c-a569-8bc48844c711"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.01388888888888889], 
                AbsoluteThickness[1.6], 
                LineBox[CompressedData["
1:eJxdkDlKhEEQRhsjQwODCQxURERExn132nHfddxT0dgr9NH6SB5BZeoJ/X4Y
ijcfVf2qpt6/Bp8jKaWP399fHX7fvbamPCxjUUejTuj/TtRx1Y4qfcyZVD6t
OpNT883m1m9O/fOav6B8UX5d5UvyXI7KnivyW5XfmvzW1b+h+Zt6f0t+28p3
orLfrvI9+e3Lrye/3PYXmPkHymH8+sph9juMGvsXGL+j1q/A+B2rH2b+id6H
8TtVDrPfmXIYv3P5wfhdqB9m/qVyGL8r5TD7XUdlfxi/G/nB+N2qH2b+Xft+
hsOvKK8w+92rHw6/AsdXYfwG6odjflFeYe73oH449itw7F/h8EuPrV+Gw6/A
9MPc70nvw9xPeYW537P64fArcHwV5n4v6oe5n/IKc79X9cPcD2Z/OPzS27/f
D0zEcnQ=
                 "]]}}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 100.}, {0, 9.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c8ec94e7-aad7-4473-b966-08df876b9f92"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of the first 10 powers of \[Pi], rounded to integers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f6103473-bb6f-4323-a711-823ec2a70306"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "3", ",", "10", ",", "31", ",", "97", ",", "306", ",", "961", ",", 
         "3020", ",", "9489", ",", "29809", ",", "93648"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "236f9df2-4881-4adc-ad3a-00ce3f5ced9e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"3", ",", "10", ",", "31", ",", "97", ",", "306", ",", 
             "961", ",", "3020", ",", "9489", ",", "29809", ",", "93648"}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cedf1162-9fb1-481e-9e83-975a59cfcf1b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graph by connecting ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"2812fa23-467d-46c9-bced-7e1fd07a393b"],
 " with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"n", "^", "2"}], ",", "100"}], "]"}]], "InlineCode",
  ExpressionUUID->"8ea5175b-21e0-4456-af46-46dda97ac17f"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"bf3dcefc-ac3f-4056-a164-8d47867cc4d0"],
 " from 0 to 99.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d5ceaf1c-76ca-40a5-8d63-aea701f83dd6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{0, 1, 2, 4, 3, 9, 16, 5, 25, 6, 36, 7, 49, 8, 64, 81, 10, 
            11, 21, 12, 44, 13, 69, 14, 96, 15, 56, 17, 89, 18, 24, 19, 61, 
            20, 41, 22, 84, 23, 29, 76, 26, 27, 28, 30, 31, 32, 33, 34, 35, 
            37, 38, 39, 40, 42, 43, 45, 46, 47, 48, 50, 51, 52, 53, 54, 55, 
            57, 58, 59, 60, 62, 63, 65, 66, 67, 68, 70, 71, 72, 73, 74, 75, 
            77, 78, 79, 80, 82, 83, 85, 86, 87, 88, 90, 91, 92, 93, 94, 95, 
            97, 98, 99}, {{{1, 1}, {2, 2}, {3, 4}, {5, 6}, {4, 7}, {8, 9}, {
             10, 11}, {12, 13}, {14, 15}, {6, 16}, {17, 1}, {18, 19}, {20, 
             21}, {22, 23}, {24, 25}, {26, 9}, {7, 27}, {28, 29}, {30, 31}, {
             32, 33}, {34, 1}, {19, 35}, {36, 37}, {38, 39}, {31, 40}, {9, 
             9}, {41, 40}, {42, 39}, {43, 37}, {39, 35}, {44, 1}, {45, 33}, {
             46, 31}, {47, 29}, {48, 27}, {49, 9}, {11, 25}, {50, 23}, {51, 
             21}, {52, 19}, {53, 1}, {35, 16}, {54, 15}, {55, 13}, {21, 11}, {
             56, 9}, {57, 7}, {58, 6}, {59, 4}, {13, 2}, {60, 1}, {61, 2}, {
             62, 4}, {63, 6}, {64, 7}, {65, 9}, {27, 11}, {66, 13}, {67, 
             15}, {68, 16}, {69, 1}, {33, 19}, {70, 21}, {71, 23}, {15, 25}, {
             72, 9}, {73, 27}, {74, 29}, {75, 31}, {23, 33}, {76, 1}, {77, 
             35}, {78, 37}, {79, 39}, {80, 40}, {81, 9}, {40, 40}, {82, 39}, {
             83, 37}, {84, 35}, {85, 1}, {16, 33}, {86, 31}, {87, 29}, {37, 
             27}, {88, 9}, {89, 25}, {90, 23}, {91, 21}, {29, 19}, {92, 1}, {
             93, 16}, {94, 15}, {95, 13}, {96, 11}, {97, 9}, {25, 7}, {98, 
             6}, {99, 4}, {100, 2}}, Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1VXk01VsbPmQIyTwc0/mdg+P8pESIwu+VIUlzCSFTCkVJ5srUbUBRiijJ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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.01508252478762797], 
               ArrowBox[BezierCurveBox[{1, 104, 107, 109, 115, 117, 120, 1},
                SplineDegree->7], 0.07330360781685052], 
               ArrowBox[BezierCurveBox[{2, 127, 130, 132, 138, 140, 143, 2},
                SplineDegree->7], 0.07330360781685052], 
               ArrowBox[{3, 4}, 0.07330360781685052], 
               ArrowBox[{4, 7}, 0.07330360781685052], 
               ArrowBox[{5, 6}, 0.07330360781685052], 
               ArrowBox[{6, 16}, 0.07330360781685052], 
               ArrowBox[{7, 27}, 0.07330360781685052], 
               ArrowBox[{8, 9}, 0.07330360781685052], 
               ArrowBox[BezierCurveBox[{9, 150, 153, 155, 161, 163, 166, 9},
                SplineDegree->7], 0.07330360781685052], 
               ArrowBox[{10, 11}, 0.07330360781685052], 
               ArrowBox[{11, 25}, 0.07330360781685052], 
               ArrowBox[{12, 13}, 0.07330360781685052], 
               ArrowBox[{13, 2}, 0.07330360781685052], 
               ArrowBox[{14, 15}, 0.07330360781685052], 
               ArrowBox[{15, 25}, 0.07330360781685052], 
               ArrowBox[{16, 33}, 0.07330360781685052], 
               ArrowBox[{17, 1}, 0.07330360781685052], 
               ArrowBox[{18, 19}, 0.07330360781685052], 
               ArrowBox[{19, 35}, 0.07330360781685052], 
               ArrowBox[{20, 21}, 0.07330360781685052], 
               ArrowBox[{21, 11}, 0.07330360781685052], 
               ArrowBox[{22, 23}, 0.07330360781685052], 
               ArrowBox[{23, 33}, 0.07330360781685052], 
               ArrowBox[{24, 25}, 0.07330360781685052], 
               ArrowBox[{25, 7}, 0.07330360781685052], 
               ArrowBox[{26, 9}, 0.07330360781685052], 
               ArrowBox[{27, 11}, 0.07330360781685052], 
               ArrowBox[{28, 29}, 0.07330360781685052], 
               ArrowBox[{29, 19}, 0.07330360781685052], 
               ArrowBox[{30, 31}, 0.07330360781685052], 
               ArrowBox[{31, 40}, 0.07330360781685052], 
               ArrowBox[{32, 33}, 0.07330360781685052], 
               ArrowBox[{33, 19}, 0.07330360781685052], 
               ArrowBox[{34, 1}, 0.07330360781685052], 
               ArrowBox[{35, 16}, 0.07330360781685052], 
               ArrowBox[{36, 37}, 0.07330360781685052], 
               ArrowBox[{37, 27}, 0.07330360781685052], 
               ArrowBox[{38, 39}, 0.07330360781685052], 
               ArrowBox[{39, 35}, 0.07330360781685052], 
               ArrowBox[BezierCurveBox[{40, 173, 176, 178, 184, 186, 189, 40},
                
                SplineDegree->7], 0.07330360781685052], 
               ArrowBox[{41, 40}, 0.07330360781685052], 
               ArrowBox[{42, 39}, 0.07330360781685052], 
               ArrowBox[{43, 37}, 0.07330360781685052], 
               ArrowBox[{44, 1}, 0.07330360781685052], 
               ArrowBox[{45, 33}, 0.07330360781685052], 
               ArrowBox[{46, 31}, 0.07330360781685052], 
               ArrowBox[{47, 29}, 0.07330360781685052], 
               ArrowBox[{48, 27}, 0.07330360781685052], 
               ArrowBox[{49, 9}, 0.07330360781685052], 
               ArrowBox[{50, 23}, 0.07330360781685052], 
               ArrowBox[{51, 21}, 0.07330360781685052], 
               ArrowBox[{52, 19}, 0.07330360781685052], 
               ArrowBox[{53, 1}, 0.07330360781685052], 
               ArrowBox[{54, 15}, 0.07330360781685052], 
               ArrowBox[{55, 13}, 0.07330360781685052], 
               ArrowBox[{56, 9}, 0.07330360781685052], 
               ArrowBox[{57, 7}, 0.07330360781685052], 
               ArrowBox[{58, 6}, 0.07330360781685052], 
               ArrowBox[{59, 4}, 0.07330360781685052], 
               ArrowBox[{60, 1}, 0.07330360781685052], 
               ArrowBox[{61, 2}, 0.07330360781685052], 
               ArrowBox[{62, 4}, 0.07330360781685052], 
               ArrowBox[{63, 6}, 0.07330360781685052], 
               ArrowBox[{64, 7}, 0.07330360781685052], 
               ArrowBox[{65, 9}, 0.07330360781685052], 
               ArrowBox[{66, 13}, 0.07330360781685052], 
               ArrowBox[{67, 15}, 0.07330360781685052], 
               ArrowBox[{68, 16}, 0.07330360781685052], 
               ArrowBox[{69, 1}, 0.07330360781685052], 
               ArrowBox[{70, 21}, 0.07330360781685052], 
               ArrowBox[{71, 23}, 0.07330360781685052], 
               ArrowBox[{72, 9}, 0.07330360781685052], 
               ArrowBox[{73, 27}, 0.07330360781685052], 
               ArrowBox[{74, 29}, 0.07330360781685052], 
               ArrowBox[{75, 31}, 0.07330360781685052], 
               ArrowBox[{76, 1}, 0.07330360781685052], 
               ArrowBox[{77, 35}, 0.07330360781685052], 
               ArrowBox[{78, 37}, 0.07330360781685052], 
               ArrowBox[{79, 39}, 0.07330360781685052], 
               ArrowBox[{80, 40}, 0.07330360781685052], 
               ArrowBox[{81, 9}, 0.07330360781685052], 
               ArrowBox[{82, 39}, 0.07330360781685052], 
               ArrowBox[{83, 37}, 0.07330360781685052], 
               ArrowBox[{84, 35}, 0.07330360781685052], 
               ArrowBox[{85, 1}, 0.07330360781685052], 
               ArrowBox[{86, 31}, 0.07330360781685052], 
               ArrowBox[{87, 29}, 0.07330360781685052], 
               ArrowBox[{88, 9}, 0.07330360781685052], 
               ArrowBox[{89, 25}, 0.07330360781685052], 
               ArrowBox[{90, 23}, 0.07330360781685052], 
               ArrowBox[{91, 21}, 0.07330360781685052], 
               ArrowBox[{92, 1}, 0.07330360781685052], 
               ArrowBox[{93, 16}, 0.07330360781685052], 
               ArrowBox[{94, 15}, 0.07330360781685052], 
               ArrowBox[{95, 13}, 0.07330360781685052], 
               ArrowBox[{96, 11}, 0.07330360781685052], 
               ArrowBox[{97, 9}, 0.07330360781685052], 
               ArrowBox[{98, 6}, 0.07330360781685052], 
               ArrowBox[{99, 4}, 0.07330360781685052], 
               ArrowBox[{100, 2}, 0.07330360781685052]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.07330360781685052], 
               DiskBox[2, 0.07330360781685052], 
               DiskBox[3, 0.07330360781685052], 
               DiskBox[4, 0.07330360781685052], 
               DiskBox[5, 0.07330360781685052], 
               DiskBox[6, 0.07330360781685052], 
               DiskBox[7, 0.07330360781685052], 
               DiskBox[8, 0.07330360781685052], 
               DiskBox[9, 0.07330360781685052], 
               DiskBox[10, 0.07330360781685052], 
               DiskBox[11, 0.07330360781685052], 
               DiskBox[12, 0.07330360781685052], 
               DiskBox[13, 0.07330360781685052], 
               DiskBox[14, 0.07330360781685052], 
               DiskBox[15, 0.07330360781685052], 
               DiskBox[16, 0.07330360781685052], 
               DiskBox[17, 0.07330360781685052], 
               DiskBox[18, 0.07330360781685052], 
               DiskBox[19, 0.07330360781685052], 
               DiskBox[20, 0.07330360781685052], 
               DiskBox[21, 0.07330360781685052], 
               DiskBox[22, 0.07330360781685052], 
               DiskBox[23, 0.07330360781685052], 
               DiskBox[24, 0.07330360781685052], 
               DiskBox[25, 0.07330360781685052], 
               DiskBox[26, 0.07330360781685052], 
               DiskBox[27, 0.07330360781685052], 
               DiskBox[28, 0.07330360781685052], 
               DiskBox[29, 0.07330360781685052], 
               DiskBox[30, 0.07330360781685052], 
               DiskBox[31, 0.07330360781685052], 
               DiskBox[32, 0.07330360781685052], 
               DiskBox[33, 0.07330360781685052], 
               DiskBox[34, 0.07330360781685052], 
               DiskBox[35, 0.07330360781685052], 
               DiskBox[36, 0.07330360781685052], 
               DiskBox[37, 0.07330360781685052], 
               DiskBox[38, 0.07330360781685052], 
               DiskBox[39, 0.07330360781685052], 
               DiskBox[40, 0.07330360781685052], 
               DiskBox[41, 0.07330360781685052], 
               DiskBox[42, 0.07330360781685052], 
               DiskBox[43, 0.07330360781685052], 
               DiskBox[44, 0.07330360781685052], 
               DiskBox[45, 0.07330360781685052], 
               DiskBox[46, 0.07330360781685052], 
               DiskBox[47, 0.07330360781685052], 
               DiskBox[48, 0.07330360781685052], 
               DiskBox[49, 0.07330360781685052], 
               DiskBox[50, 0.07330360781685052], 
               DiskBox[51, 0.07330360781685052], 
               DiskBox[52, 0.07330360781685052], 
               DiskBox[53, 0.07330360781685052], 
               DiskBox[54, 0.07330360781685052], 
               DiskBox[55, 0.07330360781685052], 
               DiskBox[56, 0.07330360781685052], 
               DiskBox[57, 0.07330360781685052], 
               DiskBox[58, 0.07330360781685052], 
               DiskBox[59, 0.07330360781685052], 
               DiskBox[60, 0.07330360781685052], 
               DiskBox[61, 0.07330360781685052], 
               DiskBox[62, 0.07330360781685052], 
               DiskBox[63, 0.07330360781685052], 
               DiskBox[64, 0.07330360781685052], 
               DiskBox[65, 0.07330360781685052], 
               DiskBox[66, 0.07330360781685052], 
               DiskBox[67, 0.07330360781685052], 
               DiskBox[68, 0.07330360781685052], 
               DiskBox[69, 0.07330360781685052], 
               DiskBox[70, 0.07330360781685052], 
               DiskBox[71, 0.07330360781685052], 
               DiskBox[72, 0.07330360781685052], 
               DiskBox[73, 0.07330360781685052], 
               DiskBox[74, 0.07330360781685052], 
               DiskBox[75, 0.07330360781685052], 
               DiskBox[76, 0.07330360781685052], 
               DiskBox[77, 0.07330360781685052], 
               DiskBox[78, 0.07330360781685052], 
               DiskBox[79, 0.07330360781685052], 
               DiskBox[80, 0.07330360781685052], 
               DiskBox[81, 0.07330360781685052], 
               DiskBox[82, 0.07330360781685052], 
               DiskBox[83, 0.07330360781685052], 
               DiskBox[84, 0.07330360781685052], 
               DiskBox[85, 0.07330360781685052], 
               DiskBox[86, 0.07330360781685052], 
               DiskBox[87, 0.07330360781685052], 
               DiskBox[88, 0.07330360781685052], 
               DiskBox[89, 0.07330360781685052], 
               DiskBox[90, 0.07330360781685052], 
               DiskBox[91, 0.07330360781685052], 
               DiskBox[92, 0.07330360781685052], 
               DiskBox[93, 0.07330360781685052], 
               DiskBox[94, 0.07330360781685052], 
               DiskBox[95, 0.07330360781685052], 
               DiskBox[96, 0.07330360781685052], 
               DiskBox[97, 0.07330360781685052], 
               DiskBox[98, 0.07330360781685052], 
               DiskBox[99, 0.07330360781685052], 
               DiskBox[100, 0.07330360781685052]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]]]], "ExerciseOutput",ExpressionUUID->
       "1aced7bc-8f9b-4dfe-b683-7d5ccbf298ef"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{0, 1, 2, 4, 3, 9, 16, 5, 25, 6, 36, 7, 49, 8, 64, 81, 
                10, 11, 21, 12, 44, 13, 69, 14, 96, 15, 56, 17, 89, 18, 24, 
                19, 61, 20, 41, 22, 84, 23, 29, 76, 26, 27, 28, 30, 31, 32, 
                33, 34, 35, 37, 38, 39, 40, 42, 43, 45, 46, 47, 48, 50, 51, 
                52, 53, 54, 55, 57, 58, 59, 60, 62, 63, 65, 66, 67, 68, 70, 
                71, 72, 73, 74, 75, 77, 78, 79, 80, 82, 83, 85, 86, 87, 88, 
                90, 91, 92, 93, 94, 95, 97, 98, 
                99}, {{{1, 1}, {2, 2}, {3, 4}, {5, 6}, {4, 7}, {8, 9}, {10, 
                 11}, {12, 13}, {14, 15}, {6, 16}, {17, 1}, {18, 19}, {20, 
                 21}, {22, 23}, {24, 25}, {26, 9}, {7, 27}, {28, 29}, {30, 
                 31}, {32, 33}, {34, 1}, {19, 35}, {36, 37}, {38, 39}, {31, 
                 40}, {9, 9}, {41, 40}, {42, 39}, {43, 37}, {39, 35}, {44, 
                 1}, {45, 33}, {46, 31}, {47, 29}, {48, 27}, {49, 9}, {11, 
                 25}, {50, 23}, {51, 21}, {52, 19}, {53, 1}, {35, 16}, {54, 
                 15}, {55, 13}, {21, 11}, {56, 9}, {57, 7}, {58, 6}, {59, 
                 4}, {13, 2}, {60, 1}, {61, 2}, {62, 4}, {63, 6}, {64, 7}, {
                 65, 9}, {27, 11}, {66, 13}, {67, 15}, {68, 16}, {69, 1}, {33,
                  19}, {70, 21}, {71, 23}, {15, 25}, {72, 9}, {73, 27}, {74, 
                 29}, {75, 31}, {23, 33}, {76, 1}, {77, 35}, {78, 37}, {79, 
                 39}, {80, 40}, {81, 9}, {40, 40}, {82, 39}, {83, 37}, {84, 
                 35}, {85, 1}, {16, 33}, {86, 31}, {87, 29}, {37, 27}, {88, 
                 9}, {89, 25}, {90, 23}, {91, 21}, {29, 19}, {92, 1}, {93, 
                 16}, {94, 15}, {95, 13}, {96, 11}, {97, 9}, {25, 7}, {98, 
                 6}, {99, 4}, {100, 2}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJw1VXk01VsbPmQIyTwc0/mdg+P8pESIwu+VIUlzCSFTCkVJ5srUbUBRiijJ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                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.01508252478762797], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 104, 107, 109, 115, 117, 120, 1}, 
                    SplineDegree -> 7], 0.07330360781685052], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 127, 130, 132, 138, 140, 143, 2}, 
                    SplineDegree -> 7], 0.07330360781685052], 
                    ArrowBox[{3, 4}, 0.07330360781685052], 
                    ArrowBox[{4, 7}, 0.07330360781685052], 
                    ArrowBox[{5, 6}, 0.07330360781685052], 
                    ArrowBox[{6, 16}, 0.07330360781685052], 
                    ArrowBox[{7, 27}, 0.07330360781685052], 
                    ArrowBox[{8, 9}, 0.07330360781685052], 
                    ArrowBox[
                    
                    BezierCurveBox[{9, 150, 153, 155, 161, 163, 166, 9}, 
                    SplineDegree -> 7], 0.07330360781685052], 
                    ArrowBox[{10, 11}, 0.07330360781685052], 
                    ArrowBox[{11, 25}, 0.07330360781685052], 
                    ArrowBox[{12, 13}, 0.07330360781685052], 
                    ArrowBox[{13, 2}, 0.07330360781685052], 
                    ArrowBox[{14, 15}, 0.07330360781685052], 
                    ArrowBox[{15, 25}, 0.07330360781685052], 
                    ArrowBox[{16, 33}, 0.07330360781685052], 
                    ArrowBox[{17, 1}, 0.07330360781685052], 
                    ArrowBox[{18, 19}, 0.07330360781685052], 
                    ArrowBox[{19, 35}, 0.07330360781685052], 
                    ArrowBox[{20, 21}, 0.07330360781685052], 
                    ArrowBox[{21, 11}, 0.07330360781685052], 
                    ArrowBox[{22, 23}, 0.07330360781685052], 
                    ArrowBox[{23, 33}, 0.07330360781685052], 
                    ArrowBox[{24, 25}, 0.07330360781685052], 
                    ArrowBox[{25, 7}, 0.07330360781685052], 
                    ArrowBox[{26, 9}, 0.07330360781685052], 
                    ArrowBox[{27, 11}, 0.07330360781685052], 
                    ArrowBox[{28, 29}, 0.07330360781685052], 
                    ArrowBox[{29, 19}, 0.07330360781685052], 
                    ArrowBox[{30, 31}, 0.07330360781685052], 
                    ArrowBox[{31, 40}, 0.07330360781685052], 
                    ArrowBox[{32, 33}, 0.07330360781685052], 
                    ArrowBox[{33, 19}, 0.07330360781685052], 
                    ArrowBox[{34, 1}, 0.07330360781685052], 
                    ArrowBox[{35, 16}, 0.07330360781685052], 
                    ArrowBox[{36, 37}, 0.07330360781685052], 
                    ArrowBox[{37, 27}, 0.07330360781685052], 
                    ArrowBox[{38, 39}, 0.07330360781685052], 
                    ArrowBox[{39, 35}, 0.07330360781685052], 
                    ArrowBox[
                    
                    BezierCurveBox[{40, 173, 176, 178, 184, 186, 189, 40}, 
                    SplineDegree -> 7], 0.07330360781685052], 
                    ArrowBox[{41, 40}, 0.07330360781685052], 
                    ArrowBox[{42, 39}, 0.07330360781685052], 
                    ArrowBox[{43, 37}, 0.07330360781685052], 
                    ArrowBox[{44, 1}, 0.07330360781685052], 
                    ArrowBox[{45, 33}, 0.07330360781685052], 
                    ArrowBox[{46, 31}, 0.07330360781685052], 
                    ArrowBox[{47, 29}, 0.07330360781685052], 
                    ArrowBox[{48, 27}, 0.07330360781685052], 
                    ArrowBox[{49, 9}, 0.07330360781685052], 
                    ArrowBox[{50, 23}, 0.07330360781685052], 
                    ArrowBox[{51, 21}, 0.07330360781685052], 
                    ArrowBox[{52, 19}, 0.07330360781685052], 
                    ArrowBox[{53, 1}, 0.07330360781685052], 
                    ArrowBox[{54, 15}, 0.07330360781685052], 
                    ArrowBox[{55, 13}, 0.07330360781685052], 
                    ArrowBox[{56, 9}, 0.07330360781685052], 
                    ArrowBox[{57, 7}, 0.07330360781685052], 
                    ArrowBox[{58, 6}, 0.07330360781685052], 
                    ArrowBox[{59, 4}, 0.07330360781685052], 
                    ArrowBox[{60, 1}, 0.07330360781685052], 
                    ArrowBox[{61, 2}, 0.07330360781685052], 
                    ArrowBox[{62, 4}, 0.07330360781685052], 
                    ArrowBox[{63, 6}, 0.07330360781685052], 
                    ArrowBox[{64, 7}, 0.07330360781685052], 
                    ArrowBox[{65, 9}, 0.07330360781685052], 
                    ArrowBox[{66, 13}, 0.07330360781685052], 
                    ArrowBox[{67, 15}, 0.07330360781685052], 
                    ArrowBox[{68, 16}, 0.07330360781685052], 
                    ArrowBox[{69, 1}, 0.07330360781685052], 
                    ArrowBox[{70, 21}, 0.07330360781685052], 
                    ArrowBox[{71, 23}, 0.07330360781685052], 
                    ArrowBox[{72, 9}, 0.07330360781685052], 
                    ArrowBox[{73, 27}, 0.07330360781685052], 
                    ArrowBox[{74, 29}, 0.07330360781685052], 
                    ArrowBox[{75, 31}, 0.07330360781685052], 
                    ArrowBox[{76, 1}, 0.07330360781685052], 
                    ArrowBox[{77, 35}, 0.07330360781685052], 
                    ArrowBox[{78, 37}, 0.07330360781685052], 
                    ArrowBox[{79, 39}, 0.07330360781685052], 
                    ArrowBox[{80, 40}, 0.07330360781685052], 
                    ArrowBox[{81, 9}, 0.07330360781685052], 
                    ArrowBox[{82, 39}, 0.07330360781685052], 
                    ArrowBox[{83, 37}, 0.07330360781685052], 
                    ArrowBox[{84, 35}, 0.07330360781685052], 
                    ArrowBox[{85, 1}, 0.07330360781685052], 
                    ArrowBox[{86, 31}, 0.07330360781685052], 
                    ArrowBox[{87, 29}, 0.07330360781685052], 
                    ArrowBox[{88, 9}, 0.07330360781685052], 
                    ArrowBox[{89, 25}, 0.07330360781685052], 
                    ArrowBox[{90, 23}, 0.07330360781685052], 
                    ArrowBox[{91, 21}, 0.07330360781685052], 
                    ArrowBox[{92, 1}, 0.07330360781685052], 
                    ArrowBox[{93, 16}, 0.07330360781685052], 
                    ArrowBox[{94, 15}, 0.07330360781685052], 
                    ArrowBox[{95, 13}, 0.07330360781685052], 
                    ArrowBox[{96, 11}, 0.07330360781685052], 
                    ArrowBox[{97, 9}, 0.07330360781685052], 
                    ArrowBox[{98, 6}, 0.07330360781685052], 
                    ArrowBox[{99, 4}, 0.07330360781685052], 
                    ArrowBox[{100, 2}, 0.07330360781685052]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.07330360781685052], 
                    DiskBox[2, 0.07330360781685052], 
                    DiskBox[3, 0.07330360781685052], 
                    DiskBox[4, 0.07330360781685052], 
                    DiskBox[5, 0.07330360781685052], 
                    DiskBox[6, 0.07330360781685052], 
                    DiskBox[7, 0.07330360781685052], 
                    DiskBox[8, 0.07330360781685052], 
                    DiskBox[9, 0.07330360781685052], 
                    DiskBox[10, 0.07330360781685052], 
                    DiskBox[11, 0.07330360781685052], 
                    DiskBox[12, 0.07330360781685052], 
                    DiskBox[13, 0.07330360781685052], 
                    DiskBox[14, 0.07330360781685052], 
                    DiskBox[15, 0.07330360781685052], 
                    DiskBox[16, 0.07330360781685052], 
                    DiskBox[17, 0.07330360781685052], 
                    DiskBox[18, 0.07330360781685052], 
                    DiskBox[19, 0.07330360781685052], 
                    DiskBox[20, 0.07330360781685052], 
                    DiskBox[21, 0.07330360781685052], 
                    DiskBox[22, 0.07330360781685052], 
                    DiskBox[23, 0.07330360781685052], 
                    DiskBox[24, 0.07330360781685052], 
                    DiskBox[25, 0.07330360781685052], 
                    DiskBox[26, 0.07330360781685052], 
                    DiskBox[27, 0.07330360781685052], 
                    DiskBox[28, 0.07330360781685052], 
                    DiskBox[29, 0.07330360781685052], 
                    DiskBox[30, 0.07330360781685052], 
                    DiskBox[31, 0.07330360781685052], 
                    DiskBox[32, 0.07330360781685052], 
                    DiskBox[33, 0.07330360781685052], 
                    DiskBox[34, 0.07330360781685052], 
                    DiskBox[35, 0.07330360781685052], 
                    DiskBox[36, 0.07330360781685052], 
                    DiskBox[37, 0.07330360781685052], 
                    DiskBox[38, 0.07330360781685052], 
                    DiskBox[39, 0.07330360781685052], 
                    DiskBox[40, 0.07330360781685052], 
                    DiskBox[41, 0.07330360781685052], 
                    DiskBox[42, 0.07330360781685052], 
                    DiskBox[43, 0.07330360781685052], 
                    DiskBox[44, 0.07330360781685052], 
                    DiskBox[45, 0.07330360781685052], 
                    DiskBox[46, 0.07330360781685052], 
                    DiskBox[47, 0.07330360781685052], 
                    DiskBox[48, 0.07330360781685052], 
                    DiskBox[49, 0.07330360781685052], 
                    DiskBox[50, 0.07330360781685052], 
                    DiskBox[51, 0.07330360781685052], 
                    DiskBox[52, 0.07330360781685052], 
                    DiskBox[53, 0.07330360781685052], 
                    DiskBox[54, 0.07330360781685052], 
                    DiskBox[55, 0.07330360781685052], 
                    DiskBox[56, 0.07330360781685052], 
                    DiskBox[57, 0.07330360781685052], 
                    DiskBox[58, 0.07330360781685052], 
                    DiskBox[59, 0.07330360781685052], 
                    DiskBox[60, 0.07330360781685052], 
                    DiskBox[61, 0.07330360781685052], 
                    DiskBox[62, 0.07330360781685052], 
                    DiskBox[63, 0.07330360781685052], 
                    DiskBox[64, 0.07330360781685052], 
                    DiskBox[65, 0.07330360781685052], 
                    DiskBox[66, 0.07330360781685052], 
                    DiskBox[67, 0.07330360781685052], 
                    DiskBox[68, 0.07330360781685052], 
                    DiskBox[69, 0.07330360781685052], 
                    DiskBox[70, 0.07330360781685052], 
                    DiskBox[71, 0.07330360781685052], 
                    DiskBox[72, 0.07330360781685052], 
                    DiskBox[73, 0.07330360781685052], 
                    DiskBox[74, 0.07330360781685052], 
                    DiskBox[75, 0.07330360781685052], 
                    DiskBox[76, 0.07330360781685052], 
                    DiskBox[77, 0.07330360781685052], 
                    DiskBox[78, 0.07330360781685052], 
                    DiskBox[79, 0.07330360781685052], 
                    DiskBox[80, 0.07330360781685052], 
                    DiskBox[81, 0.07330360781685052], 
                    DiskBox[82, 0.07330360781685052], 
                    DiskBox[83, 0.07330360781685052], 
                    DiskBox[84, 0.07330360781685052], 
                    DiskBox[85, 0.07330360781685052], 
                    DiskBox[86, 0.07330360781685052], 
                    DiskBox[87, 0.07330360781685052], 
                    DiskBox[88, 0.07330360781685052], 
                    DiskBox[89, 0.07330360781685052], 
                    DiskBox[90, 0.07330360781685052], 
                    DiskBox[91, 0.07330360781685052], 
                    DiskBox[92, 0.07330360781685052], 
                    DiskBox[93, 0.07330360781685052], 
                    DiskBox[94, 0.07330360781685052], 
                    DiskBox[95, 0.07330360781685052], 
                    DiskBox[96, 0.07330360781685052], 
                    DiskBox[97, 0.07330360781685052], 
                    DiskBox[98, 0.07330360781685052], 
                    DiskBox[99, 0.07330360781685052], 
                    DiskBox[100, 0.07330360781685052]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FrameTicks -> None, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"11a1f665-4842-48c5-9b8e-83cf5cecb7f9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate graphics of 50 circles with random real coordinates 0 to 10, \
random real radii from 0 to 2, and random colors.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"cd22a870-dc08-40ac-9b0a-085703067885"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[
          0.06374976231430463, 0.9857056835266556, 0.9997070504358709], 
          CircleBox[{8.620230238667578, 4.54046358896672}, 
           1.555335119997991]}, 
         {RGBColor[
          0.9449666561967052, 0.19864487199971803`, 0.34963260363940485`], 
          CircleBox[{9.379749034820616, 4.649212460714088}, 
           1.8771827451611083]}, 
         {RGBColor[
          0.0961314493227885, 0.5775690850427178, 0.3088558614264072], 
          CircleBox[{9.946136717228377, 2.26946816291383}, 
           1.7678389464577635]}, 
         {RGBColor[
          0.3149349898149665, 0.08153992085661765, 0.5607428837922717], 
          CircleBox[{7.558901940239107, 4.841810392565682}, 
           0.6005328629990205]}, 
         {RGBColor[0.3203430587008784, 0.75341404817283, 0.8187017544077633], 
          CircleBox[{5.572137299571695, 1.810030084959326}, 
           1.9043478038209685]}, 
         {RGBColor[
          0.7925887633841124, 0.09107068068453694, 0.14117431384963064`], 
          CircleBox[{9.678295529622336, 2.323273026700736}, 
           0.29313224479585687]}, 
         {RGBColor[
          0.5666714031804103, 0.9997416952931406, 0.42455563861986123`], 
          CircleBox[{1.186485494608247, 6.178751674312039}, 
           0.49423335377658795]}, 
         {RGBColor[0.7895323132395065, 0.5628346517000629, 0.964665130444786],
           CircleBox[{7.698630486851492, 6.64884816354769}, 
           1.8032122104261616]}, 
         {RGBColor[
          0.5614929369130637, 0.2060614458467016, 0.9416956657385838], 
          CircleBox[{9.164168074489815, 1.2158969913533628}, 
           0.6622260320412074]}, 
         {RGBColor[
          0.28435230760057784`, 0.9951934322899174, 0.2835019208826899], 
          CircleBox[{3.6220334229575393, 4.90148451322068}, 
           1.0440801008210556]}, 
         {RGBColor[
          0.4826508581404849, 0.4020828640909102, 0.4503088980204022], 
          CircleBox[{0.6668483472036097, 5.33613559883085}, 
           0.39426098963584666]}, 
         {RGBColor[
          0.6302354990720729, 0.6352894076890092, 0.35606975899933646`], 
          CircleBox[{1.0412226360458021, 2.9906648115028656}, 
           1.3491442757674643]}, 
         {RGBColor[
          0.025921195338689973`, 0.5544815680528175, 0.33498093853018207`], 
          CircleBox[{7.768755667370023, 9.273074534045126}, 
           1.945460728006387]}, 
         {RGBColor[
          0.619642203711354, 0.0918367904345807, 0.014990310473542268`], 
          CircleBox[{7.954072341693987, 6.591123162089051}, 
           0.3075800630752421]}, 
         {RGBColor[0.6802770398456279, 0.5672366254393664, 0.819728865615859],
           CircleBox[{1.8419175152413914, 3.030214183343876}, 
           1.0419121640621762]}, 
         {RGBColor[
          0.32573586670588384`, 0.7217654150007164, 0.5162909512259011], 
          CircleBox[{5.66116113549298, 6.516491686507784}, 
           1.1908563570784074]}, 
         {RGBColor[
          0.6390407258478505, 0.22089219685838546`, 0.7419456854407263], 
          CircleBox[{4.21684158265615, 0.1043879357634836}, 
           1.0256185150380364]}, 
         {RGBColor[
          0.5547839047529675, 0.2617899362592382, 0.6736845292796734], 
          CircleBox[{1.5774453465330822, 4.744861258693193}, 
           1.1450811286305531]}, 
         {RGBColor[
          0.6880754657381596, 0.48664803669167433`, 0.12253165575826341`], 
          CircleBox[{6.828741215238601, 9.026741366572598}, 
           1.42470090277337]}, 
         {RGBColor[
          0.6654525549308514, 0.7731790205824998, 0.7970234870011657], 
          CircleBox[{4.350235498826574, 3.075090192281973}, 
           1.078557900008915]}, 
         {RGBColor[
          0.8310381504156168, 0.7769886817976837, 0.9593332031038422], 
          CircleBox[{5.819215641135234, 1.666713621220433}, 
           1.0169657688699294]}, 
         {RGBColor[
          0.1798640513599581, 0.7216429643063573, 0.8254005960209563], 
          CircleBox[{5.30110400438037, 9.990442511862462}, 
           1.1736518045456732]}, 
         {RGBColor[
          0.9556577751427988, 0.16871077865955297`, 0.24168301347511423`], 
          CircleBox[{6.9542644410661865, 8.724245190081195}, 
           0.04297193439119518]}, 
         {RGBColor[
          0.09717981403068876, 0.823357178680564, 0.9559870658254004], 
          CircleBox[{2.0507316191838694, 3.590200280451567}, 
           1.4771395480383345]}, 
         {RGBColor[
          0.01710293851576572, 0.9023193941377539, 0.1342489221601697], 
          CircleBox[{3.378373707351807, 2.087601098959894}, 
           0.72215214928453]}, 
         {RGBColor[
          0.7166743162163793, 0.47811722563293246`, 0.19144812203639372`], 
          CircleBox[{3.6024699533557794, 0.8929226583316119}, 
           1.9442777526431692]}, 
         {RGBColor[0.4768028757879368, 0.4633578481922591, 0.752331328781416],
           CircleBox[{6.39335962799419, 2.2183250468081823}, 
           1.660487817199237]}, 
         {RGBColor[
          0.838406416628318, 0.912712668314791, 0.10033978955814993`], 
          CircleBox[{9.293775590642582, 1.4077502354251}, 
           0.17164673712663614]}, 
         {RGBColor[0.5317536813735901, 0.6367395996891616, 0.954592189218342],
           CircleBox[{6.824331737872232, 7.265018380237958}, 
           0.8689894413339139]}, 
         {RGBColor[
          0.9484261846938176, 0.5783840950274783, 0.3349301187770797], 
          CircleBox[{4.389534309736899, 7.939322502671416}, 
           1.1779933881775149]}, 
         {RGBColor[0.313875755945368, 0.4601813341937193, 0.7733633582333064],
           CircleBox[{0.5315522875669672, 6.367202220530057}, 
           0.9808080224177793]}, 
         {RGBColor[
          0.7702328668007257, 0.8954264841296524, 0.2996986502337944], 
          CircleBox[{1.989213621296047, 1.4328488825241656}, 
           0.9110562185798048]}, 
         {RGBColor[
          0.35433056523483253`, 0.27512393304087635`, 0.4729037733214243], 
          CircleBox[{7.701728406929057, 6.882121215242755}, 
           0.3583098789960628]}, 
         {RGBColor[
          0.07236685137006749, 0.5902996874380146, 0.6068076748075271], 
          CircleBox[{9.924229152847175, 4.777286436689055}, 
           0.33210527830967784]}, 
         {RGBColor[
          0.2527995661446467, 0.2890634358212616, 0.5251701188801556], 
          CircleBox[{5.952936092922725, 4.347057025209589}, 
           1.3446716055936272]}, 
         {RGBColor[
          0.6449553467151437, 0.5209799779435751, 0.7519416151526961], 
          CircleBox[{8.912475090148913, 6.403354372203964}, 
           0.876379688533353]}, 
         {RGBColor[0.4865741854371626, 0.5124898217696463, 0.81484171253228], 
          CircleBox[{9.38204068165447, 7.680870853194342}, 
           0.7737002190105282]}, 
         {RGBColor[
          0.7549594862192994, 0.9907704653168992, 0.8569505823046624], 
          CircleBox[{4.752191704598081, 2.14881722267668}, 
           1.5314551043538724]}, 
         {RGBColor[
          0.5957560914440021, 0.1148938522837859, 0.4439770214624261], 
          CircleBox[{9.183930863262187, 1.7936466660308668}, 
           1.5204856037898096]}, 
         {RGBColor[
          0.6057770737632464, 0.22213414960535371`, 0.5315438234571437], 
          CircleBox[{6.523944916825009, 0.45033740137211886}, 
           0.9161763640617413]}, 
         {RGBColor[
          0.7430022311251381, 0.7218954614176987, 0.6016883574346117], 
          CircleBox[{6.822742161566143, 2.108976244461962}, 
           1.531249882167368]}, 
         {RGBColor[
          0.9857887552053191, 0.8516360526921238, 0.7372741255996391], 
          CircleBox[{7.29143022669388, 0.5877888995755214}, 
           0.46704610386526735]}, 
         {RGBColor[
          0.06046825716852777, 0.49478310519945334`, 0.7605115121896495], 
          CircleBox[{3.748593183534643, 5.390722489505148}, 
           0.4282515157462341]}, 
         {RGBColor[
          0.14360510693220685`, 0.6310151365899317, 0.8126185113046216], 
          CircleBox[{0.21925747687358488, 0.6846180024235604}, 
           0.9485233315323427]}, 
         {RGBColor[
          0.9707825187762666, 0.02026708970285962, 0.5552952846295178], 
          CircleBox[{5.812166202587468, 7.140737843253898}, 
           0.19664257806431795]}, 
         {RGBColor[
          0.3126493597324487, 0.4177744716677265, 0.30706882864186835`], 
          CircleBox[{5.813544546116688, 4.303352459102603}, 
           0.24924538060376156]}, 
         {RGBColor[
          0.09191163249545276, 0.767850876592473, 0.8504630931457093], 
          CircleBox[{6.68788810668968, 0.22160328968949017}, 
           1.8095014055030045]}, 
         {RGBColor[
          0.8538254746920007, 0.25189836598548476`, 0.33586012016778155`], 
          CircleBox[{0.5906062059491894, 5.979334062615333}, 
           1.1387310329259255]}, 
         {RGBColor[
          0.8629909457197733, 0.6343209182261951, 0.5961988073282303], 
          CircleBox[{1.5037309668447278, 3.5040482185647637}, 
           1.8070620127160875]}, 
         {RGBColor[
          0.48844014864035223`, 0.3117230993700315, 0.25111489491160777`], 
          CircleBox[{2.7305249417958066, 5.423519386421489}, 
           0.7692738546621949]}}]], "ExerciseOutput",ExpressionUUID->
       "f43a02c2-9168-4a11-b0dc-c9eaf8a2771c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{{{
               RGBColor[
               0.06374976231430463, 0.9857056835266556, 0.9997070504358709], 
               
               CircleBox[{8.620230238667578, 4.54046358896672}, 
                1.555335119997991]}}}}, {{{{
               RGBColor[
               0.9449666561967052, 0.19864487199971803`, 
                0.34963260363940485`], 
               
               CircleBox[{9.379749034820616, 4.649212460714088}, 
                1.8771827451611083`]}}}}, {{{{
               RGBColor[
               0.0961314493227885, 0.5775690850427178, 0.3088558614264072], 
               
               CircleBox[{9.946136717228377, 2.26946816291383}, 
                1.7678389464577635`]}}}}, {{{{
               RGBColor[
               0.3149349898149665, 0.08153992085661765, 0.5607428837922717], 
               
               CircleBox[{7.558901940239107, 4.841810392565682}, 
                0.6005328629990205]}}}}, {{{{
               RGBColor[
               0.3203430587008784, 0.75341404817283, 0.8187017544077633], 
               
               CircleBox[{5.572137299571695, 1.810030084959326}, 
                1.9043478038209685`]}}}}, {{{{
               RGBColor[
               0.7925887633841124, 0.09107068068453694, 0.14117431384963064`], 
               
               CircleBox[{9.678295529622336, 2.323273026700736}, 
                0.29313224479585687`]}}}}, {{{{
               RGBColor[
               0.5666714031804103, 0.9997416952931406, 0.42455563861986123`], 
               
               
               CircleBox[{1.186485494608247, 6.178751674312039}, 
                0.49423335377658795`]}}}}, {{{{
               RGBColor[
               0.7895323132395065, 0.5628346517000629, 0.964665130444786], 
               
               CircleBox[{7.698630486851492, 6.64884816354769}, 
                1.8032122104261616`]}}}}, {{{{
               RGBColor[
               0.5614929369130637, 0.2060614458467016, 0.9416956657385838], 
               
               CircleBox[{9.164168074489815, 1.2158969913533628`}, 
                0.6622260320412074]}}}}, {{{{
               RGBColor[
               0.28435230760057784`, 0.9951934322899174, 0.2835019208826899], 
               
               
               CircleBox[{3.6220334229575393`, 4.90148451322068}, 
                1.0440801008210556`]}}}}, {{{{
               RGBColor[
               0.4826508581404849, 0.4020828640909102, 0.4503088980204022], 
               
               CircleBox[{0.6668483472036097, 5.33613559883085}, 
                0.39426098963584666`]}}}}, {{{{
               RGBColor[
               0.6302354990720729, 0.6352894076890092, 0.35606975899933646`], 
               
               
               CircleBox[{1.0412226360458021`, 2.9906648115028656`}, 
                1.3491442757674643`]}}}}, {{{{
               RGBColor[
               0.025921195338689973`, 0.5544815680528175, 
                0.33498093853018207`], 
               
               CircleBox[{7.768755667370023, 9.273074534045126}, 
                1.945460728006387]}}}}, {{{{
               RGBColor[
               0.619642203711354, 0.0918367904345807, 0.014990310473542268`], 
               
               
               CircleBox[{7.954072341693987, 6.591123162089051}, 
                0.3075800630752421]}}}}, {{{{
               RGBColor[
               0.6802770398456279, 0.5672366254393664, 0.819728865615859], 
               
               CircleBox[{1.8419175152413914`, 3.030214183343876}, 
                1.0419121640621762`]}}}}, {{{{
               RGBColor[
               0.32573586670588384`, 0.7217654150007164, 0.5162909512259011], 
               
               
               CircleBox[{5.66116113549298, 6.516491686507784}, 
                1.1908563570784074`]}}}}, {{{{
               RGBColor[
               0.6390407258478505, 0.22089219685838546`, 0.7419456854407263], 
               
               
               CircleBox[{4.21684158265615, 0.1043879357634836}, 
                1.0256185150380364`]}}}}, {{{{
               RGBColor[
               0.5547839047529675, 0.2617899362592382, 0.6736845292796734], 
               
               CircleBox[{1.5774453465330822`, 4.744861258693193}, 
                1.1450811286305531`]}}}}, {{{{
               RGBColor[
               0.6880754657381596, 0.48664803669167433`, 
                0.12253165575826341`], 
               
               CircleBox[{6.828741215238601, 9.026741366572598}, 
                1.42470090277337]}}}}, {{{{
               RGBColor[
               0.6654525549308514, 0.7731790205824998, 0.7970234870011657], 
               
               CircleBox[{4.350235498826574, 3.075090192281973}, 
                1.078557900008915]}}}}, {{{{
               RGBColor[
               0.8310381504156168, 0.7769886817976837, 0.9593332031038422], 
               
               CircleBox[{5.819215641135234, 1.666713621220433}, 
                1.0169657688699294`]}}}}, {{{{
               RGBColor[
               0.1798640513599581, 0.7216429643063573, 0.8254005960209563], 
               
               CircleBox[{5.30110400438037, 9.990442511862462}, 
                1.1736518045456732`]}}}}, {{{{
               RGBColor[
               0.9556577751427988, 0.16871077865955297`, 
                0.24168301347511423`], 
               
               CircleBox[{6.9542644410661865`, 8.724245190081195}, 
                0.04297193439119518]}}}}, {{{{
               RGBColor[
               0.09717981403068876, 0.823357178680564, 0.9559870658254004], 
               
               CircleBox[{2.0507316191838694`, 3.590200280451567}, 
                1.4771395480383345`]}}}}, {{{{
               RGBColor[
               0.01710293851576572, 0.9023193941377539, 0.1342489221601697], 
               
               CircleBox[{3.378373707351807, 2.087601098959894}, 
                0.72215214928453]}}}}, {{{{
               RGBColor[
               0.7166743162163793, 0.47811722563293246`, 
                0.19144812203639372`], 
               
               CircleBox[{3.6024699533557794`, 0.8929226583316119}, 
                1.9442777526431692`]}}}}, {{{{
               RGBColor[
               0.4768028757879368, 0.4633578481922591, 0.752331328781416], 
               CircleBox[{6.39335962799419, 2.2183250468081823`}, 
                1.660487817199237]}}}}, {{{{
               RGBColor[
               0.838406416628318, 0.912712668314791, 0.10033978955814993`], 
               
               CircleBox[{9.293775590642582, 1.4077502354251}, 
                0.17164673712663614`]}}}}, {{{{
               RGBColor[
               0.5317536813735901, 0.6367395996891616, 0.954592189218342], 
               
               CircleBox[{6.824331737872232, 7.265018380237958}, 
                0.8689894413339139]}}}}, {{{{
               RGBColor[
               0.9484261846938176, 0.5783840950274783, 0.3349301187770797], 
               
               CircleBox[{4.389534309736899, 7.939322502671416}, 
                1.1779933881775149`]}}}}, {{{{
               RGBColor[
               0.313875755945368, 0.4601813341937193, 0.7733633582333064], 
               
               CircleBox[{0.5315522875669672, 6.367202220530057}, 
                0.9808080224177793]}}}}, {{{{
               RGBColor[
               0.7702328668007257, 0.8954264841296524, 0.2996986502337944], 
               
               CircleBox[{1.989213621296047, 1.4328488825241656`}, 
                0.9110562185798048]}}}}, {{{{
               RGBColor[
               0.35433056523483253`, 0.27512393304087635`, 
                0.4729037733214243], 
               
               CircleBox[{7.701728406929057, 6.882121215242755}, 
                0.3583098789960628]}}}}, {{{{
               RGBColor[
               0.07236685137006749, 0.5902996874380146, 0.6068076748075271], 
               
               CircleBox[{9.924229152847175, 4.777286436689055}, 
                0.33210527830967784`]}}}}, {{{{
               RGBColor[
               0.2527995661446467, 0.2890634358212616, 0.5251701188801556], 
               
               CircleBox[{5.952936092922725, 4.347057025209589}, 
                1.3446716055936272`]}}}}, {{{{
               RGBColor[
               0.6449553467151437, 0.5209799779435751, 0.7519416151526961], 
               
               CircleBox[{8.912475090148913, 6.403354372203964}, 
                0.876379688533353]}}}}, {{{{
               RGBColor[
               0.4865741854371626, 0.5124898217696463, 0.81484171253228], 
               
               CircleBox[{9.38204068165447, 7.680870853194342}, 
                0.7737002190105282]}}}}, {{{{
               RGBColor[
               0.7549594862192994, 0.9907704653168992, 0.8569505823046624], 
               
               CircleBox[{4.752191704598081, 2.14881722267668}, 
                1.5314551043538724`]}}}}, {{{{
               RGBColor[
               0.5957560914440021, 0.1148938522837859, 0.4439770214624261], 
               
               CircleBox[{9.183930863262187, 1.7936466660308668`}, 
                1.5204856037898096`]}}}}, {{{{
               RGBColor[
               0.6057770737632464, 0.22213414960535371`, 0.5315438234571437], 
               
               
               CircleBox[{6.523944916825009, 0.45033740137211886`}, 
                0.9161763640617413]}}}}, {{{{
               RGBColor[
               0.7430022311251381, 0.7218954614176987, 0.6016883574346117], 
               
               CircleBox[{6.822742161566143, 2.108976244461962}, 
                1.531249882167368]}}}}, {{{{
               RGBColor[
               0.9857887552053191, 0.8516360526921238, 0.7372741255996391], 
               
               CircleBox[{7.29143022669388, 0.5877888995755214}, 
                0.46704610386526735`]}}}}, {{{{
               RGBColor[
               0.06046825716852777, 0.49478310519945334`, 0.7605115121896495], 
               
               CircleBox[{3.748593183534643, 5.390722489505148}, 
                0.4282515157462341]}}}}, {{{{
               RGBColor[
               0.14360510693220685`, 0.6310151365899317, 0.8126185113046216], 
               
               
               CircleBox[{0.21925747687358488`, 0.6846180024235604}, 
                0.9485233315323427]}}}}, {{{{
               RGBColor[
               0.9707825187762666, 0.02026708970285962, 0.5552952846295178], 
               
               CircleBox[{5.812166202587468, 7.140737843253898}, 
                0.19664257806431795`]}}}}, {{{{
               RGBColor[
               0.3126493597324487, 0.4177744716677265, 0.30706882864186835`], 
               
               
               CircleBox[{5.813544546116688, 4.303352459102603}, 
                0.24924538060376156`]}}}}, {{{{
               RGBColor[
               0.09191163249545276, 0.767850876592473, 0.8504630931457093], 
               
               CircleBox[{6.68788810668968, 0.22160328968949017`}, 
                1.8095014055030045`]}}}}, {{{{
               RGBColor[
               0.8538254746920007, 0.25189836598548476`, 
                0.33586012016778155`], 
               
               CircleBox[{0.5906062059491894, 5.979334062615333}, 
                1.1387310329259255`]}}}}, {{{{
               RGBColor[
               0.8629909457197733, 0.6343209182261951, 0.5961988073282303], 
               
               CircleBox[{1.5037309668447278`, 3.5040482185647637`}, 
                1.8070620127160875`]}}}}, {{{{
               RGBColor[
               0.48844014864035223`, 0.3117230993700315, 
                0.25111489491160777`], 
               
               CircleBox[{2.7305249417958066`, 5.423519386421489}, 
                0.7692738546621949]}}}}}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6a0b2a9c-3be4-4fb1-888b-1698240bd36e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 " Make a plot of the ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"d67ada5a-c9aa-400b-8a37-f80dcebe841f"],
 "th prime divided by ",
 Cell[BoxData[
  RowBox[{"n", "*", "log", 
   RowBox[{"(", "n", ")"}]}]], "InlineCode",ExpressionUUID->
  "bdf22eae-adf1-482d-aa5d-5387547ea7d8"],
 ", for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"ee38ca49-4c88-49dc-9968-edf6538c652b"],
 " from 2 to 1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"p:134",ExpressionUUID->"b42d5ee2-345f-4f1c-a3c5-caacbe59a6a1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.0055000000000000005`], AbsoluteThickness[1.6], 
           PointBox[CompressedData["
1:eJxFe3lczPv3/1gukSWELGVsyZ49Qs8QJTSWqEhT2tdp32um2WdqZI8sIyRr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            "]]}, {}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 1.1258873865996188`},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{311.59375, Automatic},
        Method->{},
        PlotRange->{{0., 999.}, {1.1281526881434, 1.173458719019024}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.05], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "fe95c322-d0a2-4d39-b037-217d8a5aa067"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.0055000000000000005`], 
                AbsoluteThickness[1.6], 
                PointBox[CompressedData["
1:eJxFe3lczPv3/1gukSWELGVsyZ49Qs8QJTSWqEhT2tdp32um2WdqZI8sIyRr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                 "]]}}}}, {}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 1.1258873865996188`}, 
          DisplayFunction -> Identity, 
          Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {311.59375, Automatic}, 
          Method -> {}, 
          PlotRange -> {{0., 999.}, {1.1281526881434, 1.173458719019024}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.05], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bdcd0e43-f012-4ba9-a8f8-63fe1e6f1757"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the differences between successive primes up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c3b0b373-a054-49ec-8db9-ae6e533e1a83"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdlElKg0EQRgtXLl24cOEiioiISJxn0zEmzhr/qNGt6Nor1NH6SDmCivUJ
9QKheLya6O5k4f2r+Zwys4+f72/8+0w6OVrJcRo8gzgLPwc/D9+CX0TdEvKX
4VdQv4r8Nfh11LfBG6jfhN9Cv23k7yB/F/l78PsRdQ4HyD9E/yP4Y/gT+NOI
OocOfMn7uFj9uhHjHrwLf4Z6sPXyPO/Bn6NerP59zO/DD9B/AH8RMd6Jg+0S
9WLVX8GLtf91znex3u1Nznew3cKLNf8OXqz7u8d8seY/RIz7d7Hqh7m+DLN3
cdRXsfZ/zPOKWPuIo18Vq76JGO+/NNk7uIq1/yj7Io5+Psr5Fd6esL9Y+8NX
eHvGfLHOD76KNf8l5xex5sNXsd7vOPcr45zv8BXeXrG/WL8XcexTxfpffPuv
/wae/mzb
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{303.828125, Automatic},
        Method->{},
        PlotRange->{{0., 100.}, {0, 18.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "f17ce968-9f3e-41a9-a912-6a1800d44ecb"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.01388888888888889], 
                AbsoluteThickness[1.6], 
                LineBox[CompressedData["
1:eJxdlElKg0EQRgtXLl24cOEiioiISJxn0zEmzhr/qNGt6Nor1NH6SDmCivUJ
9QKheLya6O5k4f2r+Zwys4+f72/8+0w6OVrJcRo8gzgLPwc/D9+CX0TdEvKX
4VdQv4r8Nfh11LfBG6jfhN9Cv23k7yB/F/l78PsRdQ4HyD9E/yP4Y/gT+NOI
OocOfMn7uFj9uhHjHrwLf4Z6sPXyPO/Bn6NerP59zO/DD9B/AH8RMd6Jg+0S
9WLVX8GLtf91znex3u1Nznew3cKLNf8OXqz7u8d8seY/RIz7d7Hqh7m+DLN3
cdRXsfZ/zPOKWPuIo18Vq76JGO+/NNk7uIq1/yj7Io5+Psr5Fd6esL9Y+8NX
eHvGfLHOD76KNf8l5xex5sNXsd7vOPcr45zv8BXeXrG/WL8XcexTxfpffPuv
/wae/mzb
                 "]]}}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {303.828125, Automatic}, 
          Method -> {}, PlotRange -> {{0., 100.}, {0, 18.}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ff91f2fb-32c6-4fb0-8e43-79b0197b2615"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a sequence of 20 middle C notes with random durations between 0 \
and 0.5 seconds.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c3e4242a-eb31-4d1d-855c-340f1be79638"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       InterpretationBox[
        GraphicsBox[{
          {RGBColor[
           0.9568627450980393, 0.9568627450980393, 0.9568627450980393], 
           RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
            GraphicsBox[
             {RGBColor[0.5, 0, 0.5], 
              
              StyleBox[{
                RectangleBox[{0., 0.43198696602798653}, \
{0.19169896542252876, 0.4438917279327484}], 
                RectangleBox[{0.20178838465529345, 0.43198696602798653}, \
{0.38519547105319374, 0.4438917279327484}], 
                RectangleBox[{0.39484847560045166, 0.43198696602798653}, \
{0.8306939909054842, 0.4438917279327484}], 
                RectangleBox[{0.8536332285531175, 0.43198696602798653}, \
{1.261587878048036, 0.4438917279327484}], 
                RectangleBox[{1.283059175389874, 0.43198696602798653}, \
{1.6165028839991455, 0.4438917279327484}], 
                RectangleBox[{1.6340525528733176, 0.43198696602798653}, \
{1.7476454969939268, 0.4438917279327484}], 
                RectangleBox[{1.7536240730002746, 0.43198696602798653}, \
{2.2079378643147067, 0.4438917279327484}], 
                RectangleBox[{2.2318491164891507, 0.43198696602798653}, \
{2.692976165044099, 0.4438917279327484}], 
                RectangleBox[{2.717246009704886, 0.43198696602798653}, \
{3.108500930814539, 0.4438917279327484}], 
                RectangleBox[{3.129093295083468, 0.43198696602798653}, \
{3.2779702139347515, 0.4438917279327484}], 
                RectangleBox[{3.2858058412427136, 0.43198696602798653}, \
{3.3163350321970273, 0.4438917279327484}], 
                RectangleBox[{3.3179418317209386, 0.43198696602798653}, \
{3.5035813470870085, 0.4438917279327484}], 
                RectangleBox[{3.513351847895749, 0.43198696602798653}, \
{3.6578218939786984, 0.4438917279327484}], 
                RectangleBox[{3.665425580614643, 0.43198696602798653}, 
                 {4.129161961729789, 0.4438917279327484}], 
                RectangleBox[{4.153569139683218, 0.43198696602798653}, \
{4.262900173955504, 0.4438917279327484}], 
                RectangleBox[{4.268654438917204, 0.43198696602798653}, \
{4.37166508987701, 0.4438917279327484}], 
                RectangleBox[{4.377086703085421, 0.43198696602798653}, \
{4.840562150944548, 0.4438917279327484}], 
                RectangleBox[{4.864955595568713, 0.43198696602798653}, \
{5.063670766319772, 0.4438917279327484}], 
                RectangleBox[{5.074129459517197, 0.43198696602798653}, \
{5.34161503952147, 0.4438917279327484}], 
                RectangleBox[{5.355693227942747, 0.43198696602798653}, \
{5.581516464735862, 0.4438917279327484}]},
               Antialiasing->True]},
             AspectRatio->NCache[
               Rational[6, 35], 0.17142857142857143`],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.75],
             FrameTicks->False,
             ImagePadding->None,
             PlotRange->{All, All},
             PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
            ImageScaled[{0.5, 0.5}], {350, 60},
            
            Background->RGBColor[
             0.9568627450980393, 0.9568627450980393, 0.9568627450980393]], 
           InsetBox[
            GraphicsBox[
             {GrayLevel[0.6], RectangleBox[{0, 0}]},
             AspectRatio->NCache[
               Rational[6, 35], 0.17142857142857143`],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.75],
             FrameTicks->False,
             ImagePadding->None], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
            
            
            Background->RGBColor[
             0.9568627450980393, 0.9568627450980393, 0.9568627450980393]]}, 
          InsetBox[
           StyleBox[
            TemplateBox[{
              StyleBox[
              "\" | \"", FontSize -> 14, FontColor -> 
               RGBColor[
                0.5098039215686274, 0.5098039215686274, 0.5098039215686274], 
               StripOnInput -> False], 
              StyleBox[
               TemplateBox[{"\"5.59\"", "\" s\""}, "RowDefault"], FontColor -> 
               RGBColor[
                0.5098039215686274, 0.5098039215686274, 0.5098039215686274], 
               StripOnInput -> False]},
             "RowWithSeparator"], "DialogStyle",
            StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
          TagBox[{
            {RGBColor[
             0.9568627450980393, 0.9568627450980393, 0.9568627450980393], 
             RectangleBox[{5, -158}, {29, -135}]}, 
            {RGBColor[
             0.27450980392156865`, 0.5411764705882353, 0.796078431372549], 
             PolygonBox[
              NCache[{{11, -157}, {11, -136}, {20., Rational[-293, 2]}, {
                11, -157}}, {{11, -157}, {11, -136}, {20., -146.5}, {
                11, -157}}]], 
             StyleBox[{},
              Antialiasing->False]}},
           EventHandlerTag[{"MouseClicked" :> If[True, Sound`EmitMIDI[
                 Sound`MIDISequence[{
                   Sound`MIDITrack[{
                    Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                    Sound`MIDIEvent[
                    0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                    Sound`MIDIEvent[
                    0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    6612, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    0], 
                    Sound`MIDIEvent[
                    6612, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    12938, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    12938, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    27971, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    27971, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    42042, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    42042, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    53543, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    53543, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    57461, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    57461, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    73131, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    73131, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    89036, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    89036, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    102531, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    102531, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    107666, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    107666, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    108719, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    108719, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    115122, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    115122, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    120105, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    120105, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    136100, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    136100, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    139871, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    139871, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    143424, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    143424, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    159410, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    159410, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    166264, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    166264, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    175490, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    175490, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    183279, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0]}]}, "DivisionType" -> "PPQ", 
                  "Resolution" -> 32767]]; 
               Sound`EmitSampledSound[None, "Preemptive"], 
               FEPrivate`EmitSound[None, "Preemptive"]], Method -> 
             "Preemptive", PassEventsDown -> Automatic, PassEventsUp -> 
             True}]], 
          TagBox[{
            {RGBColor[
             0.9568627450980393, 0.9568627450980393, 0.9568627450980393], 
             RectangleBox[{29, -158}, {53, -135}]}, 
            {RGBColor[
             0.27450980392156865`, 0.5411764705882353, 0.796078431372549], 
             RectangleBox[{35, -152}, {47, -141}], 
             StyleBox[{},
              Antialiasing->False]}},
           
           EventHandlerTag[{
            "MouseClicked" :> If[True, Sound`EmitSampledSound[
                 SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
               Sound`StopMIDI[], 
               FEPrivate`EmitSound[
                SampledSoundList[{{0.}}, 8000], "Preemptive"]], Method -> 
             "Preemptive", PassEventsDown -> Automatic, PassEventsUp -> 
             True}]], 
          {GrayLevel[0.75], 
           
           StyleBox[
            LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
            Antialiasing->False]}},
         ContentSelectable->False,
         ImageSize->250,
         PlotRange->{{0, 360}, {-164, 0}},
         PlotRangePadding->1],
        Sound[{
          SoundNote["C", 0.20179082051284225`], 
          SoundNote["C", 0.19308620862913795`], 
          SoundNote["C", 0.45877614295247693`], 
          SoundNote["C", 0.42942209260324504`], 
          SoundNote["C", 0.35099823150094644`], 
          SoundNote["C", 0.1195667999454536], 
          SoundNote["C", 0.4782203285855955], 
          SoundNote["C", 0.48541171705934116`], 
          SoundNote["C", 0.4118462541483884], 
          SoundNote["C", 0.15671295418009112`], 
          SoundNote["C", 0.032116454990890886`], 
          SoundNote["C", 0.1954292915135485], 
          SoundNote["C", 0.15207711829568837`], 
          SoundNote["C", 0.4881437372966946], 
          SoundNote["C", 0.1150581400896411], 
          SoundNote["C", 0.10844839686201435`], 
          SoundNote["C", 0.4878627613256217], 
          SoundNote["C", 0.20916422055612272`], 
          SoundNote["C", 0.2815658818262058], 
          SoundNote["C", 0.2377258298688244]}]]], "ExerciseOutput",
       ExpressionUUID->"1e1eb590-6145-4c83-af20-ecac2d9d3768"],
      Apply[TextCell, 
       Cell[
        BoxData[
         InterpretationBox[
          GraphicsBox[{{{{{{
                 RGBColor[
                 0.9568627450980393, 0.9568627450980393, 0.9568627450980393], 
                 
                 RectangleBox[{0, 0}, {360, -164}]}}}}}, {
             InsetBox[
              GraphicsBox[{{{{{{{
                    RGBColor[0.5, 0, 0.5], 
                    StyleBox[{{
                    
                    RectangleBox[{0., 0.43198696602798653`}, {
                    0.19169896542252876`, 0.4438917279327484}], 
                    
                    RectangleBox[{0.20178838465529345`, 
                    0.43198696602798653`}, {0.38519547105319374`, 
                    0.4438917279327484}], 
                    
                    RectangleBox[{0.39484847560045166`, 
                    0.43198696602798653`}, {0.8306939909054842, 
                    0.4438917279327484}], 
                    
                    RectangleBox[{0.8536332285531175, 0.43198696602798653`}, {
                    1.261587878048036, 0.4438917279327484}], 
                    
                    RectangleBox[{1.283059175389874, 0.43198696602798653`}, {
                    1.6165028839991455`, 0.4438917279327484}], 
                    
                    RectangleBox[{1.6340525528733176`, 
                    0.43198696602798653`}, {1.7476454969939268`, 
                    0.4438917279327484}], 
                    
                    RectangleBox[{1.7536240730002746`, 
                    0.43198696602798653`}, {2.2079378643147067`, 
                    0.4438917279327484}], 
                    
                    RectangleBox[{2.2318491164891507`, 
                    0.43198696602798653`}, {2.692976165044099, 
                    0.4438917279327484}], 
                    
                    RectangleBox[{2.717246009704886, 0.43198696602798653`}, {
                    3.108500930814539, 0.4438917279327484}], 
                    
                    RectangleBox[{3.129093295083468, 0.43198696602798653`}, {
                    3.2779702139347515`, 0.4438917279327484}], 
                    
                    RectangleBox[{3.2858058412427136`, 
                    0.43198696602798653`}, {3.3163350321970273`, 
                    0.4438917279327484}], 
                    
                    RectangleBox[{3.3179418317209386`, 
                    0.43198696602798653`}, {3.5035813470870085`, 
                    0.4438917279327484}], 
                    
                    RectangleBox[{3.513351847895749, 0.43198696602798653`}, {
                    3.6578218939786984`, 0.4438917279327484}], 
                    RectangleBox[{3.665425580614643, 0.43198696602798653`}, {
                    4.129161961729789, 0.4438917279327484}], 
                    
                    RectangleBox[{4.153569139683218, 0.43198696602798653`}, {
                    4.262900173955504, 0.4438917279327484}], 
                    
                    RectangleBox[{4.268654438917204, 0.43198696602798653`}, {
                    4.37166508987701, 0.4438917279327484}], 
                    
                    RectangleBox[{4.377086703085421, 0.43198696602798653`}, {
                    4.840562150944548, 0.4438917279327484}], 
                    
                    RectangleBox[{4.864955595568713, 0.43198696602798653`}, {
                    5.063670766319772, 0.4438917279327484}], 
                    
                    RectangleBox[{5.074129459517197, 0.43198696602798653`}, {
                    5.34161503952147, 0.4438917279327484}], 
                    
                    RectangleBox[{5.355693227942747, 0.43198696602798653`}, {
                    5.581516464735862, 0.4438917279327484}]}}, Antialiasing -> 
                    True]}}}}}}}, AspectRatio -> NCache[
                 Rational[6, 35], 0.17142857142857143`], Background -> 
               GrayLevel[1], Frame -> True, FrameStyle -> GrayLevel[0.75], 
               FrameTicks -> False, ImagePadding -> None, 
               PlotRange -> {All, All}, 
               PlotRangePadding -> {Automatic, 0.05}], {180, -35}, 
              ImageScaled[{0.5, 0.5}], {350, 60}, Background -> 
              RGBColor[
               0.9568627450980393, 0.9568627450980393, 0.9568627450980393]], 
             InsetBox[
              GraphicsBox[{{{{{
                    GrayLevel[0.6], 
                    RectangleBox[{0, 0}]}}}}}, AspectRatio -> NCache[
                 Rational[6, 35], 0.17142857142857143`], Background -> 
               GrayLevel[1], Frame -> True, FrameStyle -> GrayLevel[0.75], 
               FrameTicks -> False, ImagePadding -> None], {180, -100}, 
              ImageScaled[{0.5, 0.5}], {350, 60}, Background -> 
              RGBColor[
               0.9568627450980393, 0.9568627450980393, 0.9568627450980393]]}, 
            
            InsetBox[
             StyleBox[
              TemplateBox[{
                StyleBox[
                "\" | \"", FontSize -> 14, FontColor -> 
                 RGBColor[
                  0.5098039215686274, 0.5098039215686274, 0.5098039215686274],
                  StripOnInput -> False], 
                StyleBox[
                 TemplateBox[{"\"5.59\"", "\" s\""}, "RowDefault"], FontColor -> 
                 RGBColor[
                  0.5098039215686274, 0.5098039215686274, 0.5098039215686274],
                  StripOnInput -> False]}, "RowWithSeparator"], "DialogStyle",
               StripOnInput -> False], {355, -159}, 
             Scaled[{1, 0}]], 
            TagBox[{{{{{
                  RGBColor[
                  0.9568627450980393, 0.9568627450980393, 0.9568627450980393], 
                  RectangleBox[{5, -158}, {29, -135}]}}}}, {{{{
                  RGBColor[
                  0.27450980392156865`, 0.5411764705882353, 
                   0.796078431372549], 
                  PolygonBox[
                   NCache[{{11, -157}, {11, -136}, {20., 
                    Rational[-293, 2]}, {11, -157}}, {{11, -157}, {
                    11, -136}, {20., -146.5}, {11, -157}}]], 
                  StyleBox[{}, Antialiasing -> False]}}}}}, 
             EventHandlerTag[{"MouseClicked" :> If[True, Sound`EmitMIDI[
                   Sound`MIDISequence[{
                    Sound`MIDITrack[{
                    Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                    Sound`MIDIEvent[
                    0, "ProgramCommand", "Channel" -> 0, "Value" -> 0], 
                    Sound`MIDIEvent[
                    0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    6612, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    0], 
                    Sound`MIDIEvent[
                    6612, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    12938, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    12938, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    27971, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    27971, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    42042, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    42042, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    53543, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    53543, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    57461, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    57461, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    73131, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    73131, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    89036, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    89036, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                    127], 
                    Sound`MIDIEvent[
                    102531, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    102531, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    107666, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    107666, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    108719, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    108719, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    115122, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    115122, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    120105, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    120105, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    136100, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    136100, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    139871, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    139871, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    143424, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    143424, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    159410, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    159410, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    166264, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    166264, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    175490, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0], 
                    Sound`MIDIEvent[
                    175490, "NoteOn", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 127], 
                    Sound`MIDIEvent[
                    183279, "NoteOff", "Note" -> 60, "Channel" -> 0, 
                    "Velocity" -> 0]}]}, "DivisionType" -> "PPQ", 
                    "Resolution" -> 32767]]; 
                 Sound`EmitSampledSound[None, "Preemptive"], 
                 FEPrivate`EmitSound[None, "Preemptive"]], Method -> 
               "Preemptive", PassEventsDown -> Automatic, PassEventsUp -> 
               True}]], 
            TagBox[{{{{{
                  RGBColor[
                  0.9568627450980393, 0.9568627450980393, 0.9568627450980393], 
                  RectangleBox[{29, -158}, {53, -135}]}}}}, {{{{
                  RGBColor[
                  0.27450980392156865`, 0.5411764705882353, 
                   0.796078431372549], 
                  RectangleBox[{35, -152}, {47, -141}], 
                  StyleBox[{}, Antialiasing -> False]}}}}}, 
             
             EventHandlerTag[{
              "MouseClicked" :> If[True, Sound`EmitSampledSound[
                   SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
                 Sound`StopMIDI[], 
                 FEPrivate`EmitSound[
                  SampledSoundList[{{0.}}, 8000], "Preemptive"]], Method -> 
               "Preemptive", PassEventsDown -> Automatic, PassEventsUp -> 
               True}]], {{{{{
                 GrayLevel[0.75], 
                 StyleBox[
                  LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
                   Antialiasing -> False]}}}}}}, ContentSelectable -> False, 
           ImageSize -> 250, PlotRange -> {{0, 360}, {-164, 0}}, 
           PlotRangePadding -> 1], 
          Sound[{
            SoundNote["C", 0.20179082051284225`], 
            SoundNote["C", 0.19308620862913795`], 
            SoundNote["C", 0.45877614295247693`], 
            SoundNote["C", 0.42942209260324504`], 
            SoundNote["C", 0.35099823150094644`], 
            SoundNote["C", 0.1195667999454536], 
            SoundNote["C", 0.4782203285855955], 
            SoundNote["C", 0.48541171705934116`], 
            SoundNote["C", 0.4118462541483884], 
            SoundNote["C", 0.15671295418009112`], 
            SoundNote["C", 0.032116454990890886`], 
            SoundNote["C", 0.1954292915135485], 
            SoundNote["C", 0.15207711829568837`], 
            SoundNote["C", 0.4881437372966946], 
            SoundNote["C", 0.1150581400896411], 
            SoundNote["C", 0.10844839686201435`], 
            SoundNote["C", 0.4878627613256217], 
            SoundNote["C", 0.20916422055612272`], 
            SoundNote["C", 0.2815658818262058], 
            SoundNote["C", 0.2377258298688244]}]]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5ed2c3d6-60c3-4cba-a966-a95b494a88ab"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an array plot of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"i", ",", "j"}], "]"}]], "InlineCode",ExpressionUUID->
  "3da31b4f-f0d1-443a-b5cd-924768116993"],
 " for ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"a896f405-cbad-4544-94bf-46145d353a21"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"e9896d88-28af-4403-8c19-92ef74e15c87"],
 " up to 50.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4d02b9cb-2e85-4b73-a2b8-66afccc6916b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[RasterBox[CompressedData["
1:eJyVlleS2zAQRLVyWmd7HTevMkUAE3wUH2Ev4Pv/eRoEJQZQIl+VPl91A2yy
tHj+9/d5PpvN/qSfKrOysFfH273nxWqz27vAen1ze3f/8Pi0WK7Wm+2u2JfO
B2JRFZEgKqHwsiuDLNfbovQkg4JlqJI6pX3QwpHWEUPCxYUKE3tfckkoVUcM
CfP53GqxhODEMUrVEQPCC0PtDErk1QtKpYgB4SWwu9LAHOwYVqqOyAuvInZX
RPYrCaVSRF54XaHxgSg7RqkUkRXeJHBw8U68WKkUkRUua+yuVIPXoFYqReSE
twdwU4FCSShVReSEd0dwDGJybKVSREZ43wC7whDFSlURGeFDE+wKQ1QrVUX0
hY8tsCv1NkTPVURf+NQGu7JZsZWqInrC5w6oZLMSKxUjesKXLtiVzUo9VxFd
4WsP7AqzChIjusJVH+wKsyKNER3hW4b4QnnxHCM6wvccGmeiQWJEW/iRBYKN
hBQRbeFnHuzKRsIxoiX8GgC7spEIIlrC7yGwq4AvlkU0hetBsCvyjIimcDMM
dsVBENEQbk+AXYmtl6Qh3J0iPXKLOAr3J0FCEIs4Cg+nwa7Ivop6EB7PoPEt
JzkIT+eo3nLWWlicBbtSklpYnge7sogkrEaAXZEkYT0GjS9hJWxGgV1JJWzH
gV1pFHYjiZcLoRgLTgFhPxrsyoRyPLgqUTcB7Er9FLCrMIn4j2ES2NU0sKtp
/AdZd3Mg
         "], {{0, 0}, {50, 50}}, {0, 49}],
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "52fff178-67b4-44cf-970a-eac487871319"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          RasterBox[CompressedData["
1:eJyVlleS2zAQRLVyWmd7HTevMkUAE3wUH2Ev4Pv/eRoEJQZQIl+VPl91A2yy
tHj+9/d5PpvN/qSfKrOysFfH273nxWqz27vAen1ze3f/8Pi0WK7Wm+2u2JfO
B2JRFZEgKqHwsiuDLNfbovQkg4JlqJI6pX3QwpHWEUPCxYUKE3tfckkoVUcM
CfP53GqxhODEMUrVEQPCC0PtDErk1QtKpYgB4SWwu9LAHOwYVqqOyAuvInZX
RPYrCaVSRF54XaHxgSg7RqkUkRXeJHBw8U68WKkUkRUua+yuVIPXoFYqReSE
twdwU4FCSShVReSEd0dwDGJybKVSREZ43wC7whDFSlURGeFDE+wKQ1QrVUX0
hY8tsCv1NkTPVURf+NQGu7JZsZWqInrC5w6oZLMSKxUjesKXLtiVzUo9VxFd
4WsP7AqzChIjusJVH+wKsyKNER3hW4b4QnnxHCM6wvccGmeiQWJEW/iRBYKN
hBQRbeFnHuzKRsIxoiX8GgC7spEIIlrC7yGwq4AvlkU0hetBsCvyjIimcDMM
dsVBENEQbk+AXYmtl6Qh3J0iPXKLOAr3J0FCEIs4Cg+nwa7Ivop6EB7PoPEt
JzkIT+eo3nLWWlicBbtSklpYnge7sogkrEaAXZEkYT0GjS9hJWxGgV1JJWzH
gV1pFHYjiZcLoRgLTgFhPxrsyoRyPLgqUTcB7Er9FLCrMIn4j2ES2NU0sKtp
/AdZd3Mg
           "], {{0, 0}, {50, 50}}, {0, 49}], Frame -> Automatic, 
          FrameLabel -> {None, None}, 
          FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"579a7d45-1ff8-4f60-b0d0-faddc4c7f88b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"8f3d41b2-06d8-4642-80f5-338c7d3f3cf5"],
 " from 2 to 10 of array plots for ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"537ba331-481e-4e73-94a9-db00026464e8"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"aa412e1c-f07e-47de-8feb-acaaa3ef6690"],
 " up to 50 of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "y"}], " ", "mod", " ", "n"}]], "InlineCode",
  ExpressionUUID->"7195d161-9119-4af3-b202-99d89ecac501"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"3e75fab8-97af-4a74-91f3-64ec8757bd8f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGkgEDyWDUjlE7Ru0YtWPUjlE7Ru0YtWPUDuraAQB4
WAbv
           "], {{0, 0}, {50, 50}}, {0, 1}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmIGRlIh6YCJZDDqqlFXjbpq1FWjrhp11airRl016ip8
AADXcQ1I
           "], {{0, 0}, {50, 50}}, {0, 2}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGZlIBE8mAZCuYGZhIhaP+GPXHqD9G/THqj1F/jPpj
1B8jyR8AJ6AYBQ==
           "], {{0, 0}, {50, 50}}, {0, 3}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmIWkgEDM6mQkYGJVMzAyEwaZiYZjPp81OejPh/1+ajP
R30+6vNRnw9dnwMAEhMYZQ==
           "], {{0, 0}, {50, 50}}, {0, 4}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmJmRlIhC8mAlWTAwEIqZCQZMJEMRsNqNKxGw2o0rEbD
ajSsRsNqNKwGS1gBADBzHDk=
           "], {{0, 0}, {50, 50}}, {0, 5}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJzt0DEBQCEQAlDEwx5WMIoRLGD/7S8WYPgbHEeAN8/dhwDWe9kZdiD3GlHd
WpbM9gKbnC3KbXSjG93oRje60Y3uL7off6QmRg==
           "], {{0, 0}, {50, 50}}, {
           0, 6}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJzt0bsNwDAMA1H5E2kOr5BRMoIXyP5dmvTm9TzCtWC8td9n94i4/3eNgiWO
XqiKpGv4Hz3p8ImaSWcPe5yzh5499OyhZw89e+hxjw+xdzoB
           "], {{0, 0}, {50, 
           50}}, {0, 7}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJztkTERwDAMA+XEjUMjFAKlEEKg/LcuBSDN1VvWrLtf57lPA7C/74EcpXRG
ibmmykhEL6VLRh41UepFqmnyKhvksUEeG+SxQR4b5LFBnv8afAH+gTcn
           "], {{0, 
           0}, {50, 50}}, {0, 8}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}], ",", 
         GraphicsBox[RasterBox[CompressedData["
1:eJzt0UERgDAQQ9G0y7aLDCwgBQk1gP9bLxj4R2aSzFfwrvU+q0u6v048FX3L
GayuUazAO/Ay6Id6sWa2YBWezW1uc5vb3OY2/7/5BkJrMM8=
           "], {{0, 0}, {50, 
           50}}, {0, 9}],
          Frame->Automatic,
          FrameLabel->{None, None},
          FrameTicks->{{None, None}, {None, None}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "3103c168-a724-40ec-8699-aa8cc711854a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGkgEDyWDUjlE7Ru0YtWPUjlE7Ru0YtWPUDuraAQB4
WAbv
               "], {{0, 0}, {50, 50}}, {0, 1}], Frame -> Automatic, 
              FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmIGRlIh6YCJZDDqqlFXjbpq1FWjrhp11airRl016ip8
AADXcQ1I
               "], {{0, 0}, {50, 50}}, {0, 2}], Frame -> Automatic, 
              FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGZlIBE8mAZCuYGZhIhaP+GPXHqD9G/THqj1F/jPpj
1B8jyR8AJ6AYBQ==
               "], {{0, 0}, {50, 50}}, {0, 3}], Frame -> 
              Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmIWkgEDM6mQkYGJVMzAyEwaZiYZjPp81OejPh/1+ajP
R30+6vNRnw9dnwMAEhMYZQ==
               "], {{0, 0}, {50, 50}}, {0, 4}], 
              Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmJmRlIhC8mAlWTAwEIqZCQZMJEMRsNqNKxGw2o0rEbD
ajSsRsNqNKwGS1gBADBzHDk=
               "], {{0, 0}, {50, 50}}, {0, 5}], 
              Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJzt0DEBQCEQAlDEwx5WMIoRLGD/7S8WYPgbHEeAN8/dhwDWe9kZdiD3GlHd
WpbM9gKbnC3KbXSjG93oRje60Y3uL7off6QmRg==
               "], {{0, 0}, {50, 
               50}}, {0, 6}], Frame -> Automatic, FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJzt0bsNwDAMA1H5E2kOr5BRMoIXyP5dmvTm9TzCtWC8td9n94i4/3eNgiWO
XqiKpGv4Hz3p8ImaSWcPe5yzh5499OyhZw89e+hxjw+xdzoB
               "], {{0, 0}, {
               50, 50}}, {0, 7}], Frame -> Automatic, 
              FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJztkTERwDAMA+XEjUMjFAKlEEKg/LcuBSDN1VvWrLtf57lPA7C/74EcpXRG
ibmmykhEL6VLRh41UepFqmnyKhvksUEeG+SxQR4b5LFBnv8afAH+gTcn
               "], {{
               0, 0}, {50, 50}}, {0, 8}], Frame -> Automatic, 
              FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}], ",", 
             GraphicsBox[
              RasterBox[CompressedData["
1:eJzt0UERgDAQQ9G0y7aLDCwgBQk1gP9bLxj4R2aSzFfwrvU+q0u6v048FX3L
GayuUazAO/Ay6Id6sWa2YBWezW1uc5vb3OY2/7/5BkJrMM8=
               "], {{0, 0}, {
               50, 50}}, {0, 9}], Frame -> Automatic, 
              FrameLabel -> {None, None}, 
              FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
              Directive[
                GrayLevel[0.5, 0.4]], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"82234bf6-4adf-4eea-88ce-07484b5cb70a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Round",
  BaseStyle->"Link"],
 " to compute the fractional part of \[Pi] to 50 digits.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8682b7a3-16f3-4596-a45c-49a46b17ef80"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "0.141592653589793238462643383279502884197169399375105820974944592307816\
4118876`50."], "ExerciseOutput",ExpressionUUID->
       "a3297df0-d171-4225-8d63-abcf87a8bee7"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "0.1415926535897932384626433832795028841971693993751058209749445923078\
164118876`50."], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"75f6fc76-ecb4-4fca-b309-ece4848325ca"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the sum of the first 1000 prime numbers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"97cf1ee1-4b41-43b7-9d7b-a9d6d7aa4bf4"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "3682913"], "ExerciseOutput",ExpressionUUID->
       "d32e9fc8-857f-4228-b8a2-6eb07d644752"],
      Apply[TextCell, 
       Cell[
        BoxData["3682913"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5dac6825-f6b6-4755-b026-0ef5bcbba315"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 100 primes modulo 4.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b2cfd91c-c86d-41db-b8e8-5ab87ba6efcc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "2", ",", "3", ",", "1", ",", "3", ",", "3", ",", "1", ",", "1", ",", 
         "3", ",", "3", ",", "1", ",", "3", ",", "1", ",", "1", ",", "3", ",",
          "3", ",", "1", ",", "3", ",", "1", ",", "3", ",", "3", ",", "1", 
         ",", "3", ",", "3", ",", "1", ",", "1", ",", "1", ",", "3", ",", "3",
          ",", "1", ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", ",", 
         "1", ",", "3", ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", ",",
          "1", ",", "3", ",", "1", ",", "1", ",", "3", ",", "3", ",", "3", 
         ",", "3", ",", "1", ",", "1", ",", "3", ",", "1", ",", "3", ",", "1",
          ",", "3", ",", "1", ",", "3", ",", "1", ",", "1", ",", "3", ",", 
         "1", ",", "3", ",", "3", ",", "1", ",", "1", ",", "3", ",", "1", ",",
          "3", ",", "1", ",", "1", ",", "3", ",", "3", ",", "1", ",", "3", 
         ",", "3", ",", "1", ",", "1", ",", "1", ",", "1", ",", "3", ",", "1",
          ",", "3", ",", "1", ",", "3", ",", "3", ",", "1", ",", "1", ",", 
         "1", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",",
          "3", ",", "1", ",", "1", ",", "3", ",", "1"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "c92f86d3-05e3-4201-a49d-d4186ddcec63"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"2", ",", "3", ",", "1", ",", "3", ",", "3", ",", "1", ",",
              "1", ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", ",", "1",
              ",", "3", ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", ",",
              "3", ",", "1", ",", "3", ",", "3", ",", "1", ",", "1", ",", "1",
              ",", "3", ",", "3", ",", "1", ",", "1", ",", "3", ",", "3", ",",
              "1", ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", ",", "3",
              ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", ",", "1", ",",
              "3", ",", "3", ",", "3", ",", "3", ",", "1", ",", "1", ",", "3",
              ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", ",", "3", ",",
              "1", ",", "1", ",", "3", ",", "1", ",", "3", ",", "3", ",", "1",
              ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", ",", "1", ",",
              "3", ",", "3", ",", "1", ",", "3", ",", "3", ",", "1", ",", "1",
              ",", "1", ",", "1", ",", "3", ",", "1", ",", "3", ",", "1", ",",
              "3", ",", "3", ",", "1", ",", "1", ",", "1", ",", "3", ",", "3",
              ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "1", ",",
              "1", ",", "3", ",", "1"}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5e23dfb3-d5c4-476d-8057-74de54636699"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 10000 primes modulo 4, multiply them by \
90\[Degree] and create an angle path from them.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"833b42c0-63b5-47c8-9be1-3a2cf25acbd2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[LineBox[CompressedData["
1:eJy9nIe3HtWV5Yuo+IJezjkp5wCYIIIQICEJbOy2scfumenJ3ZPa7XF2O5BB
WSBE7rEBARIK5MzQxtNtbCwJJCGCAdN2/wsz0zM+6+291n7H56tb9fQ8Xsvr
x9pb59xzz62q71Z99b3eP/2Lq/781CzLZgxnmZH/+7+//x95yu/5T8JToZOn
QSdPh06egZzkmdDJSdDJyb///ynCKdlobaTppwknQSfPhH6m+KcLz0Qt5CT8
N3mm087AWOTpqIXUWia7WiZhDmcKda6TXC8i38efilrI01ALebrTznAxpyMX
eRrGIv36+fW1HP9H6I+PDDpp//vfQtP/lzDyNT51/J2Cusno+NT5FfFPEZ6G
/yaj/p4uTB1fk/Hf5BT8NzkVOjkNOjkd/5achn9LTnWa96fjv8kq6GQ1dLIG
/5b0fhX0qgp+DfLWSP4pwirMi6zGvMka9I2sRl/JGvSdrMa6kCm/CnqV+D6/
H1/rq4JOToc+XXw/P52/708t+kbOQC6yDrnIGchF1iEXWQ+dbEAc2Yi8ZBN0
shlxZAv0lgp+E8YlGzEXsgm1ks2olWxCrWQjaiWb8N+k9xsQR9YjL1nntBn4
t2QtdLIGOqm9pK899/FRfu2J9qKpgF8HndReVfK1J0Xmr+PrWrK+ZqHpLULv
p+bn8+uxZNRjzTgdOjkNOjkV+tQKvsW1Ck1vE5reLqyCTlYjjvTzj+rXc6oa
8yb1XGwI/FT/Z2BcUs+lZqxxi7ABdZP1mBfZgHmTjdDJJsSRjchLer8ZerP4
zcLIz4tvcVoq3tcfzV/7UwednIE4sg59IU3vENq6dApN7xJ6vwY6aeveLayC
XiV+p7AG49bkjF+mvjqMS6bqj/K3C71fhziyHnnJBugN4ncIfXyR+nuEpvcK
Te8Tmt4vNH1AaPMaFJo+JDR9WGj6iNDyzhSaPktYC71WfI2P/Lz4GuikHTez
habPEZo+V2j6PKH3q6BXVfCj/Hnj1yKOnIG8pOnzhb4+71vcAmEddLIeOtkA
vSHHXyg0fZGwDnqd+Kn884R1mDc5A30h69A3sh7rSjZg3UnTR4SmDwsboTeK
r/GNyEs2QW8SX+ObkJe06/KQ0K6xg0K7xg4ITe8XWlyf0PL2Ck3vEVpct9D7
TdBJq7tLaHqnsBl6cwXfxxe5fvnPD/188dfPGuhktP9QvxY66fcHqf2bz+/3
P35/NA3zIqdi3uQU9IWcjL6TU7Au5FSsKzkNOjkdcaT/fPS+j58KnYzq6xRO
wrzIM6GTZ0A/Q/x24RnoG+l9n38ydHIKdNL3dxrqJqP5q19kfXT+3o/G/2Ou
v+l9QtP7haYPCC3voND0IaHFDQtNHxFa3EzhJOiTKvg+fip00voyS2jrMlto
+hzhVOhTxdd470+BTk6GPrmC7+uL5j8snIS+kVF/tf9ToZPToJPToZNV0Mlq
rCtZg3Una6GT0f5M/Si+V+j3h96vgV4jfrcw2l/q/rPI/lb9svHR50+3sB51
kQ2YF+n91P456k/e+qT6H/U3b338/r0eeckGjEtaXwaETdCbxO8T+v54P9p/
+P2J5vd+C+LIVsyLbEPfyXboZAfiyE7kJbugk92II3uc1uti+lxO7/v4svl7
kLdH8uuc+jBXsh+9IPvQK9L7upc06l6zBXqzUNeqKRu71o3Z2GOhAXU3CvVY
aMrG7jWbs7F70ZZs7F6Svu5JI1/je7Kxx0zK70VfyKi/HcJo/XV9ovUrs749
2dhj2tdXZH7aX99/Pde4vnpP4dffHx9DGJccRl3kCHRyJuLIEeQlh6EPl8jf
LpwJnZyFOHI2dHIO4si50OeK3yqcjbrIsvm9H8WXyZ+K9/XPhT5X/GbhRMfP
gk7qvXBT4M+GPlt8vac2vUGo9/L12dhnRUZ9FmQchk4OIY70vo/3+VPj67Om
Gai7VqjPcmqysc96qqFXCXUvPD0buxeelo3d607Nxu6FpxWIn4s4ch50cj7i
SO/7+Cj/dKE+C6sKfD9/fVZWnY19llWTjX0WVpuNfRY2Ixv7rKiugK/Pksaz
fvos0TgT+swcX59Jpo5ffVYVHb/6rNU4CH0wi49/0xuEA9BJfdZbl429l5gR
+LrXNOpeNPJ1LxqN7+uP/FT9mj+qT/cvUX1+/nn5dS/diLqahPqsL/r8iz4/
U59vqeu3/3zzn08dQtM7hZGf9/mWGn8e9HlZ5c8X//mb+nzV+mahbtL0LmHk
58XPhE5G+w/vdwqHoZNDiCMHoZMDiCP7UTdperfQ4nqElrdXaHqfcAD6gPg+
vls4DH24Qv7ILxOfGt/7Uf06v5OtbwT6SAU/qq9LaHqn0Pt+fcuuv7//SB0f
ke/Hz6vfH7/++C+7/4/2f3nXr5Pdv/vrS3T9SV0f865vqf152fsf70fxqf6m
xp/Iz5ci9yfebxcWub76+vLiT9b312/Tu4Sp63vq/Iiu/23C6PmM99uF0fMJ
fX4RPT/Q5wvdiCO7MC+yE3qn+O3CTuQlO1A32Q69Xfx2oY/3+fVZH/1WocW1
CCPf16fjtzst5be5nDrXDlcLvx/tEEbfn+b50feved/PRs+/O4Sp72/L1p96
vq7PAnuyP3w+HD0/Tj0f1mdW/vtxPVf4/bk+U9JzcTgbey5W8vWc9n6U34/v
69NnsnouD2Rj9wKDQX3e18/ygWzsZ31/NnYvMIA16BfqXqqIr3utwWzsXmso
G7tXGg78Puh94o8Ivd8PnbQaZgpNnyU0fbbQ9DlC7w8ijhxCXnIQ45JDqIsc
dtoQ/i05iLHIAaf1479J399+5CIHMBYZ9Ud9rSWqb9jF6FwHXa8HXK8G0cMh
4RzkIudCJ+dBJ+djLHIexiLnYyxyAcYi52Msch7GIuc6bR7+LTkfuUj7/0Jh
5Ks23+Usm9/+v0i4yGmL8W/JJdDJpfi35DL8W3I5dHIF9BU5/kLhWRiXXIG5
kMsxV3IFek0ux7qQy7Bu5FLo5BLo5GLo5CLkJRdjXHIJ9CXia3yUf5bQ9JlC
00eENu6wMOUvhL5Q/JnClO/rS8UvwLgLcsb39Q8JTR8ULoS+sILv45cgL7kU
45LLUDe5HPpy8YeFS5F3qeQfFBapf0BofekX2jHcJzS9V2hxPULL2y20cbuE
3l8InVwAnZwPfX4FPzW+z296p9DXtwQ6aX3tEC6DTi6HTq6ATp4FnTwb+tkF
/XOgk5/KRvc6pOltQotrFZreIrS4ZqHpTULTG4WmNwjPhk6ehThyBXRyOeJI
0+uFFlcntLwzhN5fAZ1cDp1cBp20dasVRn6dcAl0cjH0xeLXC5diXuQy6GTZ
+sYzvtbv8/vxo/7VCi2uRmh5q4VLoJOLEUcugr6ogu/jTzb/QujkAugLCvrz
MS6Z8lPfrxX5/lL91Pdz+q55XTb2XXT6+s56Kl7fFa/HuA3COdDniO+/HywT
r++aR9//Rt9P6/d3+i55Qzb2XXGjvotuHII+VMGP4vWdcx9/st+fRd//6W9G
/Pd/PdnYd+r0XTqj/lbFqL9lMepvZYz6rjh9fafcx/v80fj6TmHZeD+/6PtF
feYRvV9V5v0cHx99/+jXt8z3k9H7YXnvj/n3d1LPL/33H0Wej/rnn/79t7z3
41LPT6P6dPzU93cTXX/q+W3q/bXo/cGTeX8t9f2T6d3C6P03/35klzAaP68+
H9/ltOj9y15hL2ol+5ymz8J6sj/8/rEf/7a/QrzP78fXXkV+r9OK9C/1/qqO
mfp+Meq///7AP58v+/1Ai1CfNTdnY5818/1PfebsfR8f5c8bvw1xbRLfJIz8
vPzR9xN577f2ZPnvb/ZkY5+p67N2vn9b9vNVf7Oa+vz1n4/R55++k+4//ydi
fzCR4+u7+LXZ2Hfxa7Kx79rXBvGRr/H6Ww3jAPQB8XV87w8ijhyCTupvaWsr
+NVC2xdWCU2fLrS4acLIrxL6/Kn6RqCPVPB9fDR/HV9/KxPV5+OL9N+/31Zm
ffS3OlWImy7U3/pMy8b+Vsuov+WaEvg+3s/fj5/qX3R86PpE7yeezPpF9eWt
nz/+RjBvUn+rNjUb+1utKdnY32pNzsb+VmsSxj1TOACd7Ecc6f0o/gyhxZ0u
NP00ocWdKhyCPiT+6cIh5CWHMS4Z+acLU/l9/X5+vn9Rf/U3hYPZ2N/Eed+v
38lef/z1LXr/tko4E3lJ70fvT6fez069v6zvP0fvV3vfP7+pEqbez56PvpIL
0HdyIXRyEXRyMdaNXIR1J72/BHFLJH6qcBHqIr2/BDq5FPMil0Enl0NfXsH3
8UvQN3Ix+kqmnt8tQxyZGn855kUuQ1/Ipegb6fu3FHFk1F/f/0nCKL/6ReLP
FC6DTi5HHOnn5+e/An0hz0LfyLOhk+dAJz+FvpPePxv62eJXCz+FdSXPhX6u
+Jr/XOQ9V8afJjwX8yLPg06eD528AH0hV6Jv5IXoK3kR+k5eDJ28BDq5Khu9
bpORP0no/SL5Nf5S1E2uxrzIy6BfJv4kYRSvfhSv+S9FX8nV6Dt5GdaNXI11
JS+FTq6CvirHnya8BOOSF0MnL4JOXoi6Se9fDP3iCr6Pj46fVH5f33Sh96P5
+fomC72fivd+1N/pwlT/VyHvKsk/WVi2vqj/04Qroa/Miq9vXn+j+vP644/P
1PF/eTZ6XJNXZKPXPdL0GqHF1QpNnyE0vU7o/Sugk2ugk2uhk1dCJ9dhXHI9
6iI3QN9QwffxPv9a6GRUn/pl64vGrxGuRd/JNVgX8gqsG1lk/byv8ZZ3mtDG
nSq0uqYIre7JQtMnCS3uTKHpZwjXQV8nvsZ7fz10cgP0DTn+ZGEq/irURaby
R/PX/kT9myZch76TV2JdyJS/FjpZZP3Kjl8t9Mdn5Pv69PiN4lPnb7VwPfKS
G1A3eRXmRV6NeZNXYV3I1PExnuPzDKHppwtNP01o454qtLpOEV4N/WrxTxNu
QN4Nkt+P7+v3519efeswLhnV78dPzU/r9/P7NHTyM9DJa6CTn4X+WfFPEVpc
JrS89nerSdP/Sej9qxFH+vXx84v6p/29Ejq5FnHklchLen8N4tZUiF+DuDUS
nwmL5Nf4KxBHrkFfyCvQNzLlXw79cvF9fj/+qUI//yvQV9L0M4SRnxd/OeJI
27ecKVwNfXUF3+ImCS3vZKHpU4SmTxWaPk0YfT7r53+0P6gRWlytMLX/Su3f
bN71wsifIbwU45KrURdZZP+ofpF4vz+tFqbu77zv48vuf6P+a3zKP9n8Zffn
0frVCVdh3Um772gQ2n1Lo9Dua5qEF0InVyKOvAA6eT7088WvF65EXeSF0C8U
3+f38anxm4TnQSfPhU7690tNbxFaXKvQ9Dahf7/V++dBP0/8DqH3z0cceQF0
ciXiyAuhkxchjrwQdZMXYV7khZg36f2LEUdeAv0S8ZuFka/xvr6LUTeZqn8l
8pIXQCeL9K9NGMW3CL3vx4/6p+ePP78ugU6uQhxZtr+rUBd5KeZFroa+Osdv
F14GnbwcceRlGJdcjbrIS6GTUX3q+/qi8duFV0An1yCO9L6Pt7wdQhu3U2h1
dQlN7xaa3iP0/mWIIy9HXvIKjEuugb5G/C7h5ch7ueTvEUbjq29xvcIroJNr
EEf68b2/FnHkldDJddDXid8r9PHR+L6+XqH3U/PzvvWlT2h6v9DiBoTe9/Gr
kXd1Tn5fX58wqs+vn19/Pb6i47dDaOddu9CuG23C6Pquvo8vcv3Q8ys6/vOO
79T6r0XfyCuxLuRarBtpcYPCaH0HhaYPCVPxazAu6dc3dfxG51eXMHV+lD2+
ipxfefWnzt/o+qDnv78+rEccuQHzJu2+vVNoeofQ4tqF3r8K+lXitwlNbxVe
DZ38NOLIzyAveQ108rOII73/GeifEb9VaHEtws9lo5+rZOS3Cv8EeUnv+/hr
kJe0upqENu9GYVn/GuikjdsgNL1e6P3PQSdtXnXCz0MnvwCdvDYbvS8ivf95
6KTlrRV+DvrnxNfxi9Sn+b+AvOREjK/+Z6GTvr+fQV/J8axfk9Afn1ZXi3A8
x6eeP6a3Cy2uQ2h6p9DiuoSmdwtN7xGa3iu0vH3CyO8RRvl1/GtQF+mvH5+G
Tl6NOLLs9W8ddPJKxJHrkJdcD3295Nfrr/ej/O3CtVg3Mtqftwi97+Oj/B3C
NdDJIvt/vb+I7j/0/sbf/5zs/UW0fyuzf0/t//39ySrEkZdAv0T8bmHKL3L/
k6o/b/8c5S+zvy5y/5Pa3/j9pd+/9AnXQyc3YFzS72+K3B+V3d/6/Wfe/tb6
MiRcDX21+APCIvdHPr/G+/yXYlxyFfRV4g8II1/jLe+w0MYdEVpdM4VW9yyh
9W220PQ5wsj38TOF3vfj+/p8/ZdCJ1chjrwUecnVqIu8DPplBce/HOOS/vgY
j///s/+XQyf9/FdjXDLqv/d9/zS/r8/0uULT5wlNny+8DPpl4vv4vPmvRV3k
laib9H4UP0eYyj+e4zvVv9T6zRGm+rsGOunndyX0K8WfJ/T+OujkeujrxZ8j
jPLn9Td1/Ef1zxb68X19G1A3afvG+ULvR/FzhOsxLrkBdZPrse6k6SPCq6Bf
VcH38eugrxN/WGj6kND6MihcC51cgzjyCuQlvb8WOunPL1/flYgjU/VvQF3k
etRNmj4gNL1faHqf0O8//P7E7x/WIe+6gvmvQl7yaujkp6GTdl/TIzS9W+j9
axBHRvdnen9V5P5L46+BTtq4XUJ//xXdn+nzn6uhk9HzpdT9WZswen7ln09p
fj9+qv7o+VSHMLq/Lvv8qMzzq+j5gH++pc8XUs+nvJ+qL3r+5p/P+f7l3b+X
9aPnA3p8pp4fpJ5v+PPDniv1Cu25U5/wWujkF6GTX4L+pQp+FN8j9L4fP6qv
RxjFq/95zJv8E/SFjPrj/dTzI/X986fPQye/AJ28Fvq14ncJr0VdZORr/Beh
f3GC4r8EnfxnqJv8cjZ6XpCmtwktrlVYxG8Rmt4sNL1JaHqj8IvQyWuhXyt+
g9DH+/xfhv7lCr6vz49fpH7v6/y/jL6QX4H+FfGbhV9BXrJI/b5/2h/rW73w
C9DJzyOO/ALykhPRf51fan2+grzkn0In/zniyH8BnfyXiCP/DPMmTa8TWtwM
off/DDr5r6CT/xo6+W+y0ef65L/NRt/7IiN/hvDfIS8Z+bVCn9/7/x5x5H+A
Tv454kjTq4WmVwlNny70/l8gjvyPyEv+J+jkf4ZO/hfo5H9FXvIvMS4Z+dVC
7/v8fvyJqE/H/yriyL9E30nv/xV08mvQyf8Gnfw61pX0/tegf62C/3Xk/brk
rxZ+DfMi/wp9J63uaUK/Pl9F3FclvloY9cf3z8f78fPy+/qj+Wl/o/6n+qf9
/0Y2et6S38xGrzvkt6CT34b+bfEbhBbXKDS9SWh6s9D734ZOfgc6+V3o3xW/
RWhxrcJvQSej8b3fKrS+tAlNbxea3iE0vVP4Lejkt6GTVneX8LvQye8hjvwu
xiW/A/07kr9dWGR8jS8yvvq+fsvbLTS9R2h6r9Dq6hOa3i80fUDo/e8g7js5
8T6/H79H6P0ov/f9/Pz88/rzLejkN6GT30Be8psYl0z1r2x/vgmd/Ab0b4iv
4/v6vo66yah+nV80/zLnT6p/3k/Fp87PIn7e+n8XOvk99IUs4vcKi8R3Cf8a
Ovl9xJE/QF7yh9noupM/gk5eB/068fuF3r8eceQNGJf0ftn4GzEv8ibMm7w5
G1038hbo5K3Qb83xu4W3YVxyI+oiN6FuciP6Qpo+INycjT53Jbdko89lya3Z
6HNb0vuboZOboJMboW8Uf0RocTOFlneWcCt0chv0beLPFpo+R7g9G32uT+6A
Tt6OOPIO6ORO6OSdGJfchbrIu6DfVcGP4mcL78K45N2om7wnG/3egrwXOnkf
4sj7od8v/jyhj78HcaQfv2x9ps8Xmr5AaOMuFFpdi4SmLxbeA528G3FkWX88
4y8RWt6lQtOXCe+Ffq/4qfg8/y7kJXdBJ+9EHOn9u6DfVWL8xUIfnxp/J3Ty
DtRNmr5caPoKoZ2XZwntvD1baOf1OcJt0MmtiCO3IS+5FeOSW6CTmxFHboJO
boRO3gadvBV5yVswb/Jm6ORNiCNvRF7yBsyLjPwVwuuRl7wB45I3Yl3Im7Bu
5M1Yd9L7N0Inb4BOXg/9+gp+kfilwije179M6Pt7C/pCpvp/M/pKRn5e/mj9
U+Nr/TdCv7GCfzPmTd6CvpC3QidvQxw5nvr88enry+tPKt4fn/74vQ46+SPM
i7wO8ya9/0PopO07FwttX7pIaPpC4Q+hkz+C/iPxFwhNny+8Djp5PXTS5j1P
6P0i8QuEN0Inb0Je0vS5QoubI/T+TdBvEn+20OJmCU2fKbwJ+k3i+/iTGd/7
N0Mnb4FO3oq85G3oC7kRfSM3oa/kZqw7aZ8bi4Te3wR9k/iLhd7fiDjyNoxL
+vpS9Xvfzz/qz2zhbVg3ciN0chPiyM3IS27BuORW1EVuwbxI729D3DaJnyv0
/nbEbZf4BcKt6CtZZP10/YscH/OFqfiJOP5S/ZvI+Y/Hzzv+o/G9v0S4FTq5
DXHkdoxLRvPPO/6K9Nf3z8f79Z8njNa/7Pk9V2j6HGGR89tf/zTe55/o83ui
j1+//qnj2x8//viyupYKN0EnNyKO9L6PP9njdwfmTd6OvpB3oO/kTqwLeSd0
chf0XRX8nchL3olxyV3Qybugk9H9t7//ny+8Dzp5P+LIB6CTf4M48gHUTd4P
/X7xNd7n9/f/ka/1Falfxy87v1R82f6l6ov6558f6fMlG3e2MHp+NFs40c+P
/PF1F9aN3AWdvBM6uRM6eQfykv749+dX6vzzfnT+LhT68b2/A3WT4/l889dn
v3/S56fe3wJ9i/j6/NX7m6FvruAX2b/p89uovtT4/vMprz67bs8SRvX759N5
z5+L9NfH6/Ntm/dM4Q7oOwr6t0Mn7bgaEXp/B/Qd4g8Lvb8d+vYKfhQ/JPTx
2xBH+u8fIl+/H9gCnfTfL4xnfX3+vPUve3xH55een37/OBH7zzL797L3N6n6
o/x6f1vk/tjvr1L3z3n7M9OXCk1fJoz8suOXuX+P7g/8/lv91P47tT5/jOtT
3vlv150h4U7o5J3QSfvcHhTa5/qA0Pt3Qictb7/Q9D6h6b1C03uEpncLre4u
4e3Qbxe/R+jz34FxSV/fHaibvB3zIv310/s+Psrvx/fz9/3Jq28nxiX9+vn1
9eufml/0+TKR878dOrkDceR26NvF7xPejr6RqfX3x9cu6Luy8fU/6l+qfvWj
+efNbwfqJrdD3y6+j9f8ZY8/35+7MC5perfQ9C5h5Kfi1b8b45L3oC7ybsyL
nIjrk/q7oO+qkP9u5CWtriHhvdDvFX9A6Ov387sXOnkfdPJ+6PeLPyAs4g8K
70PdZOTnxT+AOPJvoJP/HTr542z0ukL+BDr5IHTyoWz0c418OBv93CN3Qycf
gf6I+LOEps8WPpqNfu6S3t8Nfbf4c4UWN0/4WDb6uU/uyUb3HaTpC4WmLxLu
hU4+Dv1x8RcLTV8i3JeN7ptI05cJI9/HLxbuh04eQBy5H3n3F8y/F/rerHJ9
y4WWd4XQxj1LeDAb/V6efCIbfS+BfBI6+RR08uls9G+pkt5/EvqT4p8r9L4f
/yD0g+KfK4zi1U/Fm36e0PTzhZb3AqHVvVJo875Q+Ax08lnEkc8hL/k8dPIF
6OSL0F8Uf6XweYxLWt6LhKZfLPT+s9CfreD7/NH4Wn80v/OEL6Dv5IvQyZcQ
R/r5R77G+/5F9a0URvO7SBj1V+Oj9c3LH/X/QmGUX/3U8fUM5k0+jb6Q0fl3
njDl+/PjIMYlD0A/IL4/v/LOzwPQD2Tx+enz74dO7oO+T/wLhAfQN9LXH80v
VX+Z+UXXN3/9PUtY9vr7DMYln0VdpPf98RHFf0r4HMYln0dd5Auom7TzcoXw
pWz0c4n0/gvQScu7TPgc9OfEXyFM+b6+svX7+lLzexk6+Qrykq9iXPIV9JV8
GTr5EuLIF6G/KP45wpexbqT3U/Hej/rn+5u3fqYvFb4InYz6t0z4CnTyVYxL
/g/URb4G/TXxlwtfRd5XJf9SoelLhBa3WOj9V6CTVvciYeQvEb4EnXwROun7
9zx08jnEkc9CJ5+BTj6Nuki7riwU2nVngfAJ6E+Iv0g4Ht/nny/0/lPQSat7
ntD0uUKLmyO0vLOFdt2dJbTPhZlC+9wYEdrnyrDQ9t1DQu8XiR8R7sO4+2T8
WULvPw798Qq+H/8AxiUPom7S+jIofBI6+RR08mnoT4s/LHwS45JPoC7yIHTS
17cfeckDGJe0uAGh6f1C0/uEpvcKLW+PcB908nHEkfuQl9wPfX+F/OMZv1to
43YJ90In9yCOfAx5yUcxLvkIdHI3dPJhzIt8CPpD4vcKd2Nc8hHURT4KnfT1
Falf46P8XULv+/pS9Xvfz/9B9IU0fUBo+qDQP5/5MXTSP9/xz3/886GTfb5U
5PnVsND0EeG90En//M4/37sLOrkLcWTq+Xvq+5Xo+WPq+xf/fLJPGD0/7RF6
38dHz8d7svF/P7MD+g7xO4Xe3w6dtO+9OoT2vVi70PvboZM7oO8QPy9/FN8m
tLpbhTbvFqHpzULTm4SmNwp3QCe3I47cBp3cijjSvldsENr3jvXCTdDJjdA3
il8n9PFR/kZhavwtyLtF8s8Qml4rtHnVCE2vFlpclXAT9E0VfB+fyr8VcaT1
fbrQ1mWa0NZtqtDWdYrQ1n2yMPKnClPxO6GTd0K/M8efKtyJuslo/GnCOzBv
0vs7oO8Qv0q4A30lt6Pv5A6sOxn5Gp/K7/07oJM7oe+s4N+OcW/P4vpSvtU9
Q7gN+rYsnl/ka7zlrRPauPVCq7tBmPJt3o3CO6GTuxBH3olxyZ3Qd1bwffxd
0Mm7MS8y5d+DvpD3om/kPVg30vv3IY68Hzr5APQHxJ8hfAB1kfdjXuR96Bt5
L/pKmt4kvB/6/Tl+szAV/wD0B3LiW4SmtwqL+G1Cm1e70PQOocV1Ck3vElpc
t9D0HqHpvcLo+9+8/Y2Pvy8b+/2p6f77Vd1/er/I989+/5X3/XTq+2PTh4Wm
jwi9H+1PU/vL1P4x7/vpaP/Yk1X+ft/G7RJGfk9W+f2MaH+q9UfvL+TNL7W/
Tb3fYPPuFN4Dnbw3K3d8R8dnmeO/SP91fn7/PhHro+OXfX+jyPmt/nj615ON
vT7o+vj1uxs6mXq/pezxc7LrY3qnsMj9V0829v2hbuE2xJFbkZdM3X/ZvrlN
mLo/i/w2oemtQtNbhKY3C7dAJzdDJ+2+oEno718iX+O3QN+S4/vxW4WbMC9y
M+ZNbkFfyM3oO7kJ60JuxLqRm7Cu5Gbom8X38Z3C2zAuuRF1kZugk1F96vv8
ka/5b0NfyFvRN/IW6OTNiCNvgk7eCJ28AeOS3o/iW4U3YF3J67HuZMq/Dvp1
4rcKb8C45PWoi/T1e/866NcV9H8EnfwhdPIHWDfS9C6hxXULLW+P0PtRfKew
SH1twh+gb2TktwuLzM/7efG+/lT896F/Pyd/Xv1RvNb/ffSV/Gvo5PeyP/z7
YOqn4ouMnze/VHzZ4+t66OQNiCOjvw/WI7wZOlnk7391Cb2f+vtiqetr5Pvr
Z+r6rfX5z4ci9fcIrS+9QtP7hN6P+uvjNf+t0MnbkJc0vV/o/Y3Z2L+vViR+
QBjFe39QaH3P+/tqt0G/TXwfr3//LeVvzvL/PtzmLP/vv0XxA8Kt0Mlt0LdV
8H38ZvSN3JT94d+/6xVG66PrHx1f/ULvl13fVH3R/qlXmNpfbYFObkUcuQ3j
kpHfI9yKvFsr5C8yvsb7/b3f//v7g9TvK6LfJ/QJ/e8T/PzK3n9sgU6m5h+t
n66/91P98+NH/fXz0/kX6W+fsEh/9fcl/vgq8vuQ1Ph5vx852d/fFLm/LfN8
4mTvz1P319H4ncKJvj8fz/FRJr7s7/Oi9S2zfn7+ZfubWt/o+ZN/fpPnR8/v
OoWmdwi9f1829vm2f/79APQHKvj3ZSf3/DxVf5H6OoT23ka70N7raBP+GDr5
E8SR3vfxlrdVaHqL0OKahT+B/hPxW4U/QV7yQYxLPoS6SO9H8a3ChzAumfIf
Rt1kKt6P7+dXtj8PQn9wnONH/WsTFvF9f9R/GPrDWfH+NQlNbxTuhk4+gjgy
5T8KnXwMeck90PdU8C2uQWh564W7oe8Wv1Ho60sdP6n+pfofHf9lzt8i57de
Pyb6+jIRx1+7cDd08hHo5KPQHxW/VbgbfSej46tF+BjiyD3Q94jfLPTHpz9+
Usef6XVCyztDuAf6ngq+jy9yfJ/s+PXCPchL7sW8ycehPy5+vdDn34txSYur
Fe6DTu6Hvl/8GuFExFcLy/pl89u8q4R7oO8Rv0aYmt/j6Cu5D30n90PfX8H3
8UXWT32//kXG9/Xr/FLHR9Qf31/1fX8fg04+irxk5FcLH4FO7kYc+QjqJndj
3uTD6Avp/ej89r7mj87vvPPX+0WuD7XCVP9S/XkYecmHoD8kfo0w6m8qv8Y/
hHUjTa8SWtx0oeWdJjR9qtDipggfgk4+CP3BCv7DyPuw5M8b/1HEkY8gL2n6
ZKH3ff1RvOZ/DOOSe1AX+Rj6RkbXL72+PY44ch/ykt5Pxe9F3N4K8fsQt0/i
U9cHPb799afI52Pe9TE6//z+NbW/KLM/9p/P0f7Z729S+6M2oentwtT+zOcv
cn+Q2p/7+w/d/6T8aH+k+7fx7H+ahPswL3I/5k3uQ1/Ix6GTe6HvFb9NuA99
J72/FzppdXcITe8Uev8x6GT0+5hO4aOII72/GzpZZP+ft7/391+p+wfvR/Gp
+wd//qXOH/VT52e0f2oU7odOHoBOHkRe8gmMSx5EXeQTmDd5EH0hD0An/fF7
AHnJ/RiXjOrP86PzJ+Xr+eX9Iv0tsz/1/gHopPWtVmh9rRHa7xarhU9BJ59G
HPkM8pJPY1wy5T8F/SnxNX/k5+V/FnHkeOrLG/9JxJGp+p7CupFPY13JZ7Du
pPd9vB//CYxLHoRO+vX393/R8VEmfjz3l3n3R6n9TZH7R3/9qRcehE4+gb6T
qeuT9b1F6K9PprcJn4JOPo048hnkJb3/FPSnZPwmYap+f/31/UndX6eeT5S9
vkR+6vj166f+E9DJJzEvMjr/Utcff32oFz6LvORz0MnnEUc+h7zk85g3+QL0
F8TX+BeQl3wROvkSdPJl1EW+Av0V8euEr2Bc8lXor4rv4zV/NL7mfwl5yfHU
3yg0vUloerPQ6m4R2t+taBV638e/DP1l8VuFprcJTW8XWt4OoY3bKfT+K9Bf
Eb9LaHq30PQeoeXtFZreJzS9X2j6gNDyDgq9H8Vr/lcwLvky9JfF7xem8r+G
OPJvkZd8DfMmI79sfLfwp+g7+Tr018XvEb6OvORPMS7p/Z9BJ/8n5k16/3Xo
r4s/IIzi1U/Fmz4ojPIPCv8uG31vjDR9WPgz6OTr0F/P8XX8n0In/xZx5GvQ
X6vgW9yI0PLOFP4MOunr9/P7e+jkzxFHvgGd/AX0X4g/U2j6LOEvs9G/y0K+
mY3+3RbyV9no33UhI3+28E3kfVPyzxRGft74v8S4v6wwvvd/AZ18A3lJ7/vx
fX+K9M/Pb0SY8n8FnTwEnTyMdSUjf6bwCOoiD2Ne5CHohyr4R9AX8i30lXw7
G/27P6Tp84VHoJOHEUf6/NH4efVH8T6/jh/Vt0Bo+kKh6YuEpi8W2ryXCI9m
o38XijR9mdDilgu9n4o/ijjyGHTyOPTj4q8QWtxZwrehk29Bf0v8s4U+/hh0
8jj04zn+OcJ3oJMnoJPvZqN/N418Lxv9u3jk+9DJD6CTv85G/64e+WE2+ncF
yY+gkx8jjvwN8pIfoy7S+58g7pMK8Z8g7pMK8X78IvWdJ0zFR/O/QGhxK4Wm
Xyi0uIuEpl8sjHyNj/L78c8X/gb6b7LK9eXFR/M/V/hr9J38AOtCmn628EPo
5EeII1O+P35S8X58X9/70Ek7L84Svgv9XfHPEUa+j18h9H40fl7+E4gj30Fe
Mrp+6fUtuj7q9fct6OQR6EfEL3v9zssfxS8WWt2LhKYvFFrcAuF4Pj/zPt/8
5/NRxJGmzxGaPltodc8SHodOvgP9HfFnCn38Uejk29DfFl/H9/VF+4+8+qP8
On5qflH9vj9zhFF/5ghPoG7yXejke4gjvX8C+gnxZwlPYF5ktD556+fjU/lN
HxEWGd8fHyPC6PgYEb4FnfT7w7cwLzK1/t73+aPxh4XeP9n8R5H3aIX80fhD
QosbFJo+ILS4fqH1rU9oeq/Q4nqE3j8CnbTrUrfwEPRD4vcKU/Gmdwlt3E6h
1dUhtHm3C49BJ49DJ+24bBPacdsqtOO6RWh6s9DimoSWt1FoeoPwBPQT4vv4
ZuExjEseR12krz/lp+b3HvT3CvrvIy/5HvpKvo++k+9h3UjvfwCd/DV08kPk
JX+NcckPUBfp/She838A/YMcv0x9H2FcMlV/FN8h/Bj6xxX81Pgfoy/kR1hX
8kPoH4qfV3/k+3ifv1no/ai+VP/y1ic6/vT4fBc6eQJx5DvQ3xG/XZg6/45B
Pya+Xn+i61OnMHX9Kht/FDpp180uofePQSd9ft+f1PW17PWrSP+8nxd/FDpp
824Rmt4stLgmoemNQotrEHo/itf8f+zxi/hNwpT/FuoiI79ReATjkoehk4eg
k/bcs15oz0XrhPbcdIbQnrvWCu25bI3w59B/XsH38T6/H79IffXCKH6G8BB0
8jD0wxV8H/8m6iZ/hXmRFlctPAydPAL9SAX/EPIekvy+fu/78cvE+/kfgX5E
/Lz6UvFvIY58Gzp5FHHk2+g7+RbWlSx7fvnz5wj0IxX86PzMu35YXKvQ8rYJ
vf82dDLaP+ddX6P9pX4++s/XaP/XJfwgG933k6b3CN+D/p74Gu/zR5/v/vPb
f77nff5Hn28nsz9I7c/fwbqS/v7A3z/4+wubd4Mw8puE0f1NavyJrM/WrV5o
ep3wBPQT4vv4RmFq/v7+LLp/S9Wf17+y91ep+8si46fmVy88Bv1YFs8/tX+J
7k/9/WuZ/U90fcrbHxW5vrYID0MnDyGO9PuTaP9SL4z2L41Cn/9XGJd8E3WR
v4RO/gI6+Qb6Qnr/l9BJn9+PPxH1NQnfgP5GVqx+25e1Cf8eOvl3iCMjv01o
ersw8jXej/8G4shfQCd9f72fml+R/O1C0zuE3n8TOvkr6OQh5CUPQz9cwY/i
O4Q+3u8vDmPeZNn8qfq9H82/U+j9qH9twpOd/1vQyej5ZJn774m+P/f7m3cR
R5reLbS4HqHl7RUeg04eRRwZPT/uFpZ9/nsYdZNHMC8yOr798aXHxyHkPST5
yz6/9s/P9fm6f/5+FDp5DPox8fOe33vfxx9HXvId1EWm1u845k2m/Oj4yIs/
inHJKL/W5/P74zM6fv3+vUsYPR/T86fI+afHd6r+Y+g76dcn5VvdA0Kb16DQ
5j0kNH1YaHEjQu/7+Pegk+9Df7+CX/b7v8gvU9945peqz8fn+ceR93iF8Y9n
+d9/m17m+1fvR/H6/bLpc4WmzxOeyNLfP88Vvo840vT5QotbIDwB/YT484Q+
/n3EkR9ko+9FkPZcf5HwQ+jkR9A/En+x0PsfQyftvaIlwk+gk/8AnfxtNvre
B+n9T6B/UsH/LfL+VvIvEv4W8yJ/B/134mu89/8R+j9W8H3+f0DfyU+gfyK+
1uf74/tXpL++P8uEvr+/QxwZ9V/jff7x1Ofnt0hYdv6p4zM6vlPH70Lhb7Bu
5ESs31LhR+graXUtF5q+Qhj5Pn6p8NfQyQ+gk++jLtKuG/8P9ILqOg==
         "]]]], 
       "ExerciseOutput",ExpressionUUID->
       "2e918fc1-b8b7-4c4b-a0ad-96d83dc07c6d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          LineBox[CompressedData["
1:eJy9nIe3HtWV5Yuo+IJezjkp5wCYIIIQICEJbOy2scfumenJ3ZPa7XF2O5BB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           "]]]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"41990a44-ac10-4e5d-9da0-5925b8183d77"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ff71fd34-9927-47e3-8ed9-f1bcb7bdafb9"],

Cell["\<\
What are examples of mathematical functions in the Wolfram Language?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"bd98d5a4-5fc9-4242-a94d-7097ab23b864"],

Cell[TextData[{
 "From standard school math, ones like ",
 ButtonBox["Sin",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Cos",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["ArcTan",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Exp",
  BaseStyle->"Link"],
 ", as well as ",
 ButtonBox["GCD",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Factorial",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Fibonacci",
  BaseStyle->"Link"],
 ". From physics and engineering and higher math, ones like ",
 ButtonBox["Gamma",
  BaseStyle->"Link"],
 " (\[OpenCurlyDoubleQuote]gamma function\[CloseCurlyDoubleQuote]), ",
 ButtonBox["BesselJ",
  BaseStyle->"Link"],
 " (\[OpenCurlyDoubleQuote]Bessel function\[CloseCurlyDoubleQuote]), ",
 ButtonBox["EllipticK",
  BaseStyle->"Link"],
 " (\[OpenCurlyDoubleQuote]elliptic integral\[CloseCurlyDoubleQuote]), ",
 ButtonBox["Zeta",
  BaseStyle->"Link"],
 " (\[OpenCurlyDoubleQuote]Riemann zeta function\[CloseCurlyDoubleQuote]), ",
 ButtonBox["PrimePi",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["EulerPhi",
  BaseStyle->"Link"],
 ". From statistics, ones like ",
 ButtonBox["Erf",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["NormalDistribution",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["ChiSquareDistribution",
  BaseStyle->"Link"],
 ". Hundreds of functions altogether."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"4fac4114-bdb1-4e86-bc21-c007a31b66bb"],

Cell["What is the precision of a number?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"2d877ae7-c612-4ef7-9524-c603668d897c"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s the total number of decimal digits quoted in the \
number. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"100", "/", "3"}], ",", "5"}], "]"}]], "InlineCode",
  ExpressionUUID->"1547103d-2ed9-4078-864d-1b251a3bd30f"],
 " gives ",
 Cell[BoxData[
 "33.333"], "InlineCode",ExpressionUUID->
  "7f2e8bca-d9e3-456b-8726-e0a99d3a1652"],
 ", which has 5 digits of precision. The number ",
 Cell[BoxData[
  RowBox[{"100", "/", "3"}]], "InlineCode",ExpressionUUID->
  "5f1230b0-1953-4449-ba97-c9bc3de24804"],
 " is exact; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"100", "/", "3"}], ",", "5"}], "]"}]], "InlineCode",
  ExpressionUUID->"743ff8d0-8ccd-41de-ba81-d2f3814798ef"],
 " approximates it to 5-digit precision."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e6f1d55-f4aa-421f-9314-fd89d134a967"],

Cell[TextData[{
 "What does the ",
 Cell[BoxData[
  ButtonBox["\[Continuation]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Continuation"]], "InlineCode",
  ExpressionUUID->"e3571e30-6f35-45f8-b571-7c78648332a5"],
 " at the end of each line in a long number mean?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"ff41d60d-bf78-4d71-8b57-6e66999714d5"],

Cell["\<\
It\[CloseCurlyQuote]s there to show that the number continues onto the next \
line\[LongDash]like a hyphen in text.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"52cf0305-78e3-4510-8dc1-f81fcc930e9a"],

Cell["Can I work with numbers in bases other than 10?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"2d58ca3f-4c5b-49a9-bbc2-92bf112c2726"],

Cell[TextData[{
 "Yes. Enter a number in base 16 as ",
 Cell[BoxData[
 "16^^ffa5"], "InlineCode",ExpressionUUID->
  "9043a1b8-4657-4a1b-bdde-d33327ab6764"],
 ". Find digits using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"655", ",", "16"}], "]"}]], "InlineCode",ExpressionUUID->
  "214ebb70-420f-44d5-bb3f-d251dff516f3"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"33e4410d-5a92-4fe4-a667-920155df0740"],

Cell["Can the Wolfram Language handle complex numbers?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"c8d5398f-0680-4105-a81b-497bcd1489b8"],

Cell[TextData[{
 "Of course. The symbol ",
 ButtonBox["I",
  BaseStyle->"Link"],
 " (capital \[OpenCurlyDoubleQuote]i\[CloseCurlyDoubleQuote]) represents the \
square root of \[Minus]1."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9900988b-5595-4c91-8d9d-daf3d85bab75"],

Cell[TextData[{
 "Why does ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"1.5", "/", "7"}], ",", "100"}], "]"}]], "InlineCode",
  ExpressionUUID->"b7270f21-854d-4b22-8bc2-84947d9a6f57"],
 " not give me a 100-digit result?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"72193441-34c6-46b0-b9a7-5d489ab92f99"],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
 "1.5"], "InlineCode",ExpressionUUID->
  "d8666ea3-ddeb-4525-8296-25a30f8184de"],
 " is an approximate number with much less than 100-digit precision. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"15", "/", "70"}], ",", "100"}], "]"}]], "InlineCode",
  ExpressionUUID->"5fceb006-efd4-4f99-bc2b-47b2692283ce"],
 " will for example give a 100-digit-precision number."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1eb4d084-47ad-4e4b-87fc-0bfac53d317d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"783aef6c-e1e0-44d2-b798-c78d8c598022"],

Cell["\<\
The Wolfram Language does \[OpenCurlyDoubleQuote]arbitrary-precision \
computation\[CloseCurlyDoubleQuote], meaning that it can keep as many digits \
in a number as you want.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b327d21f-a9ba-4686-9778-cc2944d46d7b"],

Cell[TextData[{
 "When you generate a number with a certain precision using ",
 ButtonBox["N",
  BaseStyle->"Link"],
 ", the Wolfram Language will automatically keep track of how that precision \
is affected by computations",
 "\[LongDash]",
 "so you don\[CloseCurlyQuote]t have to do your own numerical analysis of \
roundoff errors."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"e1ec4990-dd14-4739-8c1e-4d2768871b63"],

Cell[TextData[{
 "If you type a number like 1.5, it\[CloseCurlyQuote]s assumed to be at the \
native \[OpenCurlyDoubleQuote]machine precision\[CloseCurlyDoubleQuote] of \
numbers on your computer (usually about 16 digits, though only 6 are usually \
displayed). Use ",
 Cell[BoxData[
  RowBox[{"1.5", "\[InvisibleSpace]", "`100"}]], "InlineCode",ExpressionUUID->
  "0713aeb4-5359-4672-93f5-c6403116b396"],
 " to specify 100-digit precision."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"be8bef9c-61f1-443d-a0aa-b16bd7b4fbb2"],

Cell[TextData[{
 "With exact input (like 4 or 2/3 or ",
 ButtonBox["Pi",
  BaseStyle->"Link"],
 "), the Wolfram Language always tries to give exact output. But if the input \
contains an approximate number (like 2.3), or if you use ",
 ButtonBox["N",
  BaseStyle->"Link"],
 ", it\[CloseCurlyQuote]ll use numerical approximation."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f2ab5175-a38e-4a07-b688-27adb3c3d87f"],

Cell["\<\
Numerical approximation is often crucial in making large-scale computations \
feasible.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"32c535b6-960a-45ce-9318-b24f042dc0b2"],

Cell[TextData[{
 ButtonBox["PrimeQ",
  BaseStyle->"Link"],
 " tests if a number is prime (see ",
 ButtonBox["Section 28",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-28-tests-and-conditionals.nb", "PrimeQ"}],
 "). ",
 ButtonBox["FactorInteger",
  BaseStyle->"Link"],
 " finds the factors of an integer."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:26"},ExpressionUUID->"f968a65f-73d4-44d3-8cdc-61ed4530c819"],

Cell[TextData[{
 ButtonBox["RandomReal",
  BaseStyle->"Link"],
 " can give numbers that aren\[CloseCurlyQuote]t just uniformly distributed. \
For example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["NormalDistribution",
     BaseStyle->"CodeLink"], "[", " ", "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"b8404b36-c3b1-4ea4-a433-9853d267cfbf"],
 " gives normally distributed numbers."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:135", "i:27"},ExpressionUUID->"79cd8792-eace-49eb-90b7-c71fe5b98303"],

Cell[TextData[{
 ButtonBox["Round",
  BaseStyle->"Link"],
 " rounds to the nearest integer (up or down); ",
 ButtonBox["Floor",
  BaseStyle->"Link"],
 " always rounds down; ",
 ButtonBox["Ceiling",
  BaseStyle->"Link"],
 " always rounds up."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"285064b1-2d87-4818-82ab-ef213f769319"],

Cell[TextData[{
 ButtonBox["RealDigits",
  BaseStyle->"Link"],
 " is the analog of ",
 ButtonBox["IntegerDigits",
  BaseStyle->"Link"],
 " for real numbers."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:29",ExpressionUUID->"9523f462-e79a-4f43-aaaf-31ac4f5fde7a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cc99bcc2-e7f9-40f6-89a8-10f799905d3c"],

Cell[TextData[ButtonBox["Guide to Numbers in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"12938cea-9e53-4696-b106-635fc01b8ce4"],

Cell[TextData[ButtonBox["Guide to Mathematical Functions in the Wolfram \
Language\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"8ce91a8f-0e70-435e-80b1-c54e4a1f0134"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"More about Numbers: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Machine Learning\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Machine Learning", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-24-more-forms-of-visualization.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-24-more-forms-of-visualization.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"More Forms of Visualization\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "More Forms of Visualization", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->189,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | More about Numbers \[LongDash] wolfr.am/eiwl-", "Header"], 
      
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"8919aa84-1dd9-4296-b947-4040c5b04f9c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:129"->{
  Cell[663, 24, 421, 10, 93, "SectionDoubleDigit",ExpressionUUID->"4174f847-ae22-414e-9c8b-8b0f59c859da",
   CounterAssignments->{{"Section", 22}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:129"]},
 "i:1"->{
  Cell[1087, 36, 293, 7, 65, "Text",ExpressionUUID->"2d058abb-f64a-416c-9f2b-518b3162d260",
   CellTags->"i:1"]},
 "N"->{
  Cell[2004, 68, 399, 11, 65, "Text",ExpressionUUID->"d3fd047f-e58d-4e59-8117-97fc50780911",
   CellTags->{"N", "i:2"}]},
 "i:2"->{
  Cell[2004, 68, 399, 11, 65, "Text",ExpressionUUID->"d3fd047f-e58d-4e59-8117-97fc50780911",
   CellTags->{"N", "i:2"}]},
 "i:3"->{
  Cell[3965, 137, 249, 7, 37, "CodeCaption",ExpressionUUID->"e717a649-0ab8-4463-a2da-7e2641a87422",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[4640, 162, 287, 7, 65, "Text",ExpressionUUID->"bf08a97f-467c-4184-8a28-dadf9a67b6e6",
   CellTags->"i:4"]},
 "LastCellOfAPage"->{
  Cell[6177, 210, 225, 5, 70, "Output",ExpressionUUID->"daff41b3-0914-467c-918b-ede4b5321ef9",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[11608, 392, 377, 10, 70, "Output",ExpressionUUID->"73299547-9450-43a7-bbe8-841773bd74c1",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[18166, 620, 221, 5, 70, "Output",ExpressionUUID->"896bda47-5759-4a18-8e60-425d755eb8a2",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[39466, 1212, 268, 7, 70, "Output",ExpressionUUID->"29a02990-2f78-4359-a12a-d45fe50191e7",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[159147, 3630, 816, 22, 70, "Exercise",ExpressionUUID->"cd22a870-dc08-40ac-9b0a-085703067885",
   CellTags->"LastCellOfAPage"],
  Cell[314138, 6963, 487, 17, 70, "TechNote",ExpressionUUID->"f968a65f-73d4-44d3-8cdc-61ed4530c819",
   CellTags->{"LastCellOfAPage", "i:26"}],
  Cell[316492, 7050, 358, 8, 70, "MoreExplore",ExpressionUUID->"8ce91a8f-0e70-435e-80b1-c54e4a1f0134",
   CellTags->"LastCellOfAPage"]},
 "p:130"->{
  Cell[6417, 218, 342, 10, 70, "Text",ExpressionUUID->"a7ce3ad6-675f-4f51-a285-9e8440145589",
   CellTags->{"p:130", "i:5"}]},
 "i:5"->{
  Cell[6417, 218, 342, 10, 70, "Text",ExpressionUUID->"a7ce3ad6-675f-4f51-a285-9e8440145589",
   CellTags->{"p:130", "i:5"}]},
 "i:6"->{
  Cell[7293, 249, 233, 6, 70, "Text",ExpressionUUID->"23bb0105-2dc4-418d-8251-9a9f72d79c96",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[8095, 277, 343, 10, 70, "Text",ExpressionUUID->"6b255915-602c-405b-adef-42a9ed496c92",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[9288, 314, 544, 16, 70, "Text",ExpressionUUID->"35943a6a-582a-4b9d-b728-f46dd3ae046a",
   CellTags->"i:8"]},
 "p:131"->{
  Cell[12000, 405, 214, 5, 70, "CodeCaption",ExpressionUUID->"40b83260-0a72-49a0-89fd-b9fb2dccb2fd",
   CellTags->{"p:131", "i:9"}]},
 "i:9"->{
  Cell[12000, 405, 214, 5, 70, "CodeCaption",ExpressionUUID->"40b83260-0a72-49a0-89fd-b9fb2dccb2fd",
   CellTags->{"p:131", "i:9"}]},
 "i:10"->{
  Cell[13097, 443, 187, 4, 70, "CodeCaption",ExpressionUUID->"04c8003c-ce89-4382-b33a-0b0d0bcd1835",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[16077, 539, 431, 16, 70, "Text",ExpressionUUID->"6375a871-b361-41e9-b6fa-281989060b79",
   CellTags->"i:11"]},
 "p:132"->{
  Cell[18402, 628, 585, 16, 70, "Text",ExpressionUUID->"cfc96cdb-090f-4c40-9adc-9c059b558c36",
   CellTags->{"p:132", "i:12"}]},
 "i:12"->{
  Cell[18402, 628, 585, 16, 70, "Text",ExpressionUUID->"cfc96cdb-090f-4c40-9adc-9c059b558c36",
   CellTags->{"p:132", "i:12"}]},
 "i:13"->{
  Cell[20834, 704, 175, 4, 70, "CodeCaption",ExpressionUUID->"7001d9d3-49bc-4e13-a3d7-25d8b14c2816",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[37411, 1136, 421, 11, 70, "Text",ExpressionUUID->"113dd28c-be27-445e-bd68-572d02798461",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[38582, 1179, 287, 9, 70, "Text",ExpressionUUID->"7ce54f89-d9f2-4335-8e18-fec7a2867e9b",
   CellTags->"i:15"]},
 "p:133"->{
  Cell[39749, 1222, 535, 16, 70, "Text",ExpressionUUID->"ee932637-fd2c-4eeb-898c-cb8e28236863",
   CellTags->{"p:133", "i:16"}]},
 "i:16"->{
  Cell[39749, 1222, 535, 16, 70, "Text",ExpressionUUID->"ee932637-fd2c-4eeb-898c-cb8e28236863",
   CellTags->{"p:133", "i:16"}]},
 "p:134"->{
  Cell[182337, 4151, 1091, 31, 70, "Exercise",ExpressionUUID->"b42d5ee2-345f-4f1c-a3c5-caacbe59a6a1",
   CellTags->"p:134"]},
 "i:17"->{
  Cell[305967, 6685, 232, 6, 70, "Question",ExpressionUUID->"bd98d5a4-5fc9-4242-a94d-7097ab23b864",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[306202, 6693, 1422, 54, 70, "Answer",ExpressionUUID->"4fac4114-bdb1-4e86-bc21-c007a31b66bb",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[307627, 6749, 190, 4, 70, "Question",ExpressionUUID->"2d877ae7-c612-4ef7-9524-c603668d897c",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[308825, 6788, 432, 12, 70, "Question",ExpressionUUID->"ff41d60d-bf78-4d71-8b57-6e66999714d5",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[309524, 6811, 203, 4, 70, "Question",ExpressionUUID->"2d58ca3f-4c5b-49a9-bbc2-92bf112c2726",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[310255, 6836, 204, 4, 70, "Question",ExpressionUUID->"c8d5398f-0680-4105-a81b-497bcd1489b8",
   CellTags->"i:22"]},
 "i:23"->{
  Cell[312330, 6909, 487, 13, 70, "TechNote",ExpressionUUID->"e1ec4990-dd14-4739-8c1e-4d2768871b63",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[312820, 6924, 593, 13, 70, "TechNote",ExpressionUUID->"be8bef9c-61f1-443d-a0aa-b16bd7b4fbb2",
   CellTags->"i:24"]},
 "i:25"->{
  Cell[313884, 6954, 251, 7, 70, "TechNote",ExpressionUUID->"32c535b6-960a-45ce-9318-b24f042dc0b2",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[314138, 6963, 487, 17, 70, "TechNote",ExpressionUUID->"f968a65f-73d4-44d3-8cdc-61ed4530c819",
   CellTags->{"LastCellOfAPage", "i:26"}]},
 "p:135"->{
  Cell[314628, 6982, 625, 19, 70, "TechNote",ExpressionUUID->"79cd8792-eace-49eb-90b7-c71fe5b98303",
   CellTags->{"p:135", "i:27"}]},
 "i:27"->{
  Cell[314628, 6982, 625, 19, 70, "TechNote",ExpressionUUID->"79cd8792-eace-49eb-90b7-c71fe5b98303",
   CellTags->{"p:135", "i:27"}]},
 "i:28"->{
  Cell[315256, 7003, 393, 14, 70, "TechNote",ExpressionUUID->"285064b1-2d87-4818-82ab-ef213f769319",
   CellTags->"i:28"]},
 "i:29"->{
  Cell[315652, 7019, 309, 11, 70, "TechNote",ExpressionUUID->"9523f462-e79a-4f43-aaaf-31ac4f5fde7a",
   CellTags->"i:29"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:129", 407587, 8898},
 {"i:1", 407827, 8902},
 {"N", 407949, 8905},
 {"i:2", 408081, 8908},
 {"i:3", 408213, 8911},
 {"i:4", 408345, 8914},
 {"LastCellOfAPage", 408482, 8917},
 {"p:130", 409518, 8936},
 {"i:5", 409655, 8939},
 {"i:6", 409792, 8942},
 {"i:7", 409917, 8945},
 {"i:8", 410043, 8948},
 {"p:131", 410171, 8951},
 {"i:9", 410315, 8954},
 {"i:10", 410460, 8957},
 {"i:11", 410595, 8960},
 {"p:132", 410725, 8963},
 {"i:12", 410865, 8966},
 {"i:13", 411005, 8969},
 {"i:14", 411140, 8972},
 {"i:15", 411270, 8975},
 {"p:133", 411400, 8978},
 {"i:16", 411541, 8981},
 {"p:134", 411683, 8984},
 {"i:17", 411820, 8987},
 {"i:18", 411954, 8990},
 {"i:19", 412088, 8993},
 {"i:20", 412222, 8996},
 {"i:21", 412357, 8999},
 {"i:22", 412491, 9002},
 {"i:23", 412625, 9005},
 {"i:24", 412760, 9008},
 {"i:25", 412895, 9011},
 {"i:26", 413029, 9014},
 {"p:135", 413186, 9017},
 {"i:27", 413332, 9020},
 {"i:28", 413478, 9023},
 {"i:29", 413613, 9026}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[663, 24, 421, 10, 93, "SectionDoubleDigit",ExpressionUUID->"4174f847-ae22-414e-9c8b-8b0f59c859da",
 CounterAssignments->{{"Section", 22}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:129"],
Cell[1087, 36, 293, 7, 65, "Text",ExpressionUUID->"2d058abb-f64a-416c-9f2b-518b3162d260",
 CellTags->"i:1"],
Cell[1383, 45, 194, 4, 37, "CodeCaption",ExpressionUUID->"25b6421b-74bd-4a0c-b04d-694b2e04b31c"],
Cell[CellGroupData[{
Cell[1602, 53, 192, 5, 29, "Input",ExpressionUUID->"b6b20165-57e3-4bc0-b8ad-cd59571c8e73"],
Cell[1797, 60, 192, 5, 58, "Output",ExpressionUUID->"7b2fa9ed-ece6-4a0b-b7ed-63ffcb0d650c",
 Evaluatable->False]
}, Open  ]],
Cell[2004, 68, 399, 11, 65, "Text",ExpressionUUID->"d3fd047f-e58d-4e59-8117-97fc50780911",
 CellTags->{"N", "i:2"}],
Cell[2406, 81, 179, 4, 37, "CodeCaption",ExpressionUUID->"9ae36941-9b33-4a9f-8c6a-a764c3f8b19d"],
Cell[CellGroupData[{
Cell[2610, 89, 222, 6, 29, "Input",ExpressionUUID->"7d8fc03f-9b95-4e1a-84d9-af3c53c3fad7"],
Cell[2835, 97, 190, 4, 40, "Output",ExpressionUUID->"24304131-d0c3-4977-a284-708fc8834d02",
 Evaluatable->False]
}, Open  ]],
Cell[3040, 104, 279, 7, 65, "Text",ExpressionUUID->"f2d3dee8-94ea-4d15-8d8c-ce7aaaef9e0c"],
Cell[3322, 113, 216, 6, 37, "CodeCaption",ExpressionUUID->"0995279d-df6d-43fe-baad-ce8ab22a1883"],
Cell[CellGroupData[{
Cell[3563, 123, 194, 5, 29, "Input",ExpressionUUID->"88e122a1-af9d-435a-842a-ca2587dfdf52"],
Cell[3760, 130, 190, 4, 40, "Output",ExpressionUUID->"cd7d2288-9b0d-4d20-acbb-2f78cae469c5",
 Evaluatable->False]
}, Open  ]],
Cell[3965, 137, 249, 7, 37, "CodeCaption",ExpressionUUID->"e717a649-0ab8-4463-a2da-7e2641a87422",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[4239, 148, 193, 5, 29, "Input",ExpressionUUID->"e1dcdd0d-4988-4538-9e7f-c004efe04663"],
Cell[4435, 155, 190, 4, 40, "Output",ExpressionUUID->"999b461c-57ed-435a-89f2-fc4fb187c17a",
 Evaluatable->False]
}, Open  ]],
Cell[4640, 162, 287, 7, 65, "Text",ExpressionUUID->"bf08a97f-467c-4184-8a28-dadf9a67b6e6",
 CellTags->"i:4"],
Cell[4930, 171, 194, 4, 37, "CodeCaption",ExpressionUUID->"c815eb0f-bcee-49e6-9b16-44fc3858d30b"],
Cell[CellGroupData[{
Cell[5149, 179, 149, 3, 70, "Input",ExpressionUUID->"f0e16520-4775-4266-bbd6-546f4226c218"],
Cell[5301, 184, 483, 9, 70, "Output",ExpressionUUID->"9f6b3ef1-2e55-49b5-8428-bbfc46d9fe89",
 Evaluatable->False]
}, Open  ]],
Cell[5799, 196, 173, 4, 70, "CodeCaption",ExpressionUUID->"ead9d55c-22c3-4b50-8555-6c5fb7536bf3"],
Cell[CellGroupData[{
Cell[5997, 204, 177, 4, 70, "Input",ExpressionUUID->"836cc09d-2f6b-40d6-8ae3-411f9e512f22"],
Cell[6177, 210, 225, 5, 70, "Output",ExpressionUUID->"daff41b3-0914-467c-918b-ede4b5321ef9",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[6417, 218, 342, 10, 70, "Text",ExpressionUUID->"a7ce3ad6-675f-4f51-a285-9e8440145589",
 CellTags->{"p:130", "i:5"}],
Cell[6762, 230, 181, 4, 70, "CodeCaption",ExpressionUUID->"29e01b6c-aee0-44b7-956a-e5f9b4c1d114"],
Cell[CellGroupData[{
Cell[6968, 238, 129, 2, 70, "Input",ExpressionUUID->"703f8398-1ddf-428d-a3f2-0d144bb5dc3e"],
Cell[7100, 242, 178, 4, 70, "Output",ExpressionUUID->"ec9f16c9-394b-4092-8794-d1c08e7bae53",
 Evaluatable->False]
}, Open  ]],
Cell[7293, 249, 233, 6, 70, "Text",ExpressionUUID->"23bb0105-2dc4-418d-8251-9a9f72d79c96",
 CellTags->"i:6"],
Cell[7529, 257, 182, 4, 70, "CodeCaption",ExpressionUUID->"85b542a8-4d21-499a-976a-d74888bb579f"],
Cell[CellGroupData[{
Cell[7736, 265, 152, 3, 70, "Input",ExpressionUUID->"2869f516-d2d9-45e1-8576-e404d3abfda0"],
Cell[7891, 270, 189, 4, 70, "Output",ExpressionUUID->"d62b7b73-818b-4930-9f94-9823497ddeb0",
 Evaluatable->False]
}, Open  ]],
Cell[8095, 277, 343, 10, 70, "Text",ExpressionUUID->"6b255915-602c-405b-adef-42a9ed496c92",
 CellTags->"i:7"],
Cell[8441, 289, 172, 4, 70, "CodeCaption",ExpressionUUID->"79bf81c7-9a70-4caa-b191-18ca2b49f274"],
Cell[CellGroupData[{
Cell[8638, 297, 177, 4, 70, "Input",ExpressionUUID->"63b20854-5998-4683-9229-d37be1e3fdef"],
Cell[8818, 303, 455, 8, 70, "Output",ExpressionUUID->"256c0282-2d99-43aa-b07e-002cca40e078",
 Evaluatable->False]
}, Open  ]],
Cell[9288, 314, 544, 16, 70, "Text",ExpressionUUID->"35943a6a-582a-4b9d-b728-f46dd3ae046a",
 CellTags->"i:8"],
Cell[9835, 332, 194, 4, 70, "CodeCaption",ExpressionUUID->"d0634c8e-fb48-47d6-9912-dc46caf11c5f"],
Cell[CellGroupData[{
Cell[10054, 340, 162, 3, 70, "Input",ExpressionUUID->"a215304b-76f3-4290-8401-c1d3ea8b411b"],
Cell[10219, 345, 191, 4, 70, "Output",ExpressionUUID->"82788a07-a5c9-48de-97b7-6443182478d6",
 Evaluatable->False]
}, Open  ]],
Cell[10425, 352, 174, 4, 70, "CodeCaption",ExpressionUUID->"f16ad17d-758b-42cc-a65e-e526ee13d975"],
Cell[CellGroupData[{
Cell[10624, 360, 218, 5, 70, "Input",ExpressionUUID->"c3a428bf-3081-4384-8176-7a756f011cd5"],
Cell[10845, 367, 340, 8, 70, "Output",ExpressionUUID->"ca0293dc-1e41-4717-ab9c-b3b3c37ef66a",
 Evaluatable->False]
}, Open  ]],
Cell[11200, 378, 195, 4, 70, "CodeCaption",ExpressionUUID->"4fd35bc5-488f-4d17-a86f-35de4fd79355"],
Cell[CellGroupData[{
Cell[11420, 386, 185, 4, 70, "Input",ExpressionUUID->"d646851d-9a9d-4510-9183-d61f0b42db18"],
Cell[11608, 392, 377, 10, 70, "Output",ExpressionUUID->"73299547-9450-43a7-bbe8-841773bd74c1",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[12000, 405, 214, 5, 70, "CodeCaption",ExpressionUUID->"40b83260-0a72-49a0-89fd-b9fb2dccb2fd",
 CellTags->{"p:131", "i:9"}],
Cell[CellGroupData[{
Cell[12239, 414, 235, 6, 70, "Input",ExpressionUUID->"e2c27f93-6c00-49c2-b0fe-7624535ba55d"],
Cell[12477, 422, 348, 9, 70, "Output",ExpressionUUID->"0a813e1e-2187-4dcf-b858-d85e34f378ac",
 Evaluatable->False]
}, Open  ]],
Cell[12840, 434, 254, 7, 70, "Text",ExpressionUUID->"8d742481-2f87-44f4-9033-8d6bc5c1254d"],
Cell[13097, 443, 187, 4, 70, "CodeCaption",ExpressionUUID->"04c8003c-ce89-4382-b33a-0b0d0bcd1835",
 CellTags->"i:10"],
Cell[CellGroupData[{
Cell[13309, 451, 158, 3, 70, "Input",ExpressionUUID->"cca9ab5c-dbe3-4596-b18a-ec43c2e4364e"],
Cell[13470, 456, 175, 4, 70, "Output",ExpressionUUID->"27013d6b-214f-4811-bc5e-0a1fdb10fc46",
 Evaluatable->False]
}, Open  ]],
Cell[13660, 463, 175, 4, 70, "CodeCaption",ExpressionUUID->"5f424bd2-3eae-4e51-b948-5e9dbc94c741"],
Cell[CellGroupData[{
Cell[13860, 471, 162, 3, 70, "Input",ExpressionUUID->"4e69a332-e405-4f62-b4d7-95b646458ffc"],
Cell[14025, 476, 180, 4, 70, "Output",ExpressionUUID->"580a1f2c-abfe-4a4d-9f9f-d9f19a9ffbd3",
 Evaluatable->False]
}, Open  ]],
Cell[14220, 483, 168, 4, 70, "CodeCaption",ExpressionUUID->"d1b33f4d-a5eb-433b-8591-0071d19e0cd6"],
Cell[CellGroupData[{
Cell[14413, 491, 301, 8, 70, "Input",ExpressionUUID->"c11b2a80-fb08-47c6-97db-9435436aef78"],
Cell[14717, 501, 1345, 35, 70, "Output",ExpressionUUID->"4e57469f-e4db-4a50-a5c7-f7329d12265b",
 Evaluatable->False]
}, Open  ]],
Cell[16077, 539, 431, 16, 70, "Text",ExpressionUUID->"6375a871-b361-41e9-b6fa-281989060b79",
 CellTags->"i:11"],
Cell[16511, 557, 170, 4, 70, "CodeCaption",ExpressionUUID->"907cd409-3d3d-4756-a8a3-ea584500a36c"],
Cell[CellGroupData[{
Cell[16706, 565, 156, 3, 70, "Input",ExpressionUUID->"b97e8836-366f-463f-9547-b8d000600f5a"],
Cell[16865, 570, 173, 4, 70, "Output",ExpressionUUID->"1f244842-5ea8-4155-bb69-93d263525882",
 Evaluatable->False]
}, Open  ]],
Cell[17053, 577, 263, 7, 70, "CodeCaption",ExpressionUUID->"d24eda1b-43d2-43f8-8ae2-805c95ef923f"],
Cell[CellGroupData[{
Cell[17341, 588, 157, 3, 70, "Input",ExpressionUUID->"6e923ca1-2fb0-4be3-9ea4-aca6b3dbe40a"],
Cell[17501, 593, 208, 6, 70, "Output",ExpressionUUID->"f597fff0-0831-472b-bcef-700c9997884f",
 Evaluatable->False]
}, Open  ]],
Cell[17724, 602, 229, 8, 70, "CodeCaption",ExpressionUUID->"aebe28f5-6562-4d55-bfca-5fe4adfbd560"],
Cell[CellGroupData[{
Cell[17978, 614, 185, 4, 70, "Input",ExpressionUUID->"30ee1741-0e63-42b2-9777-10a9342e9327"],
Cell[18166, 620, 221, 5, 70, "Output",ExpressionUUID->"896bda47-5759-4a18-8e60-425d755eb8a2",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[18402, 628, 585, 16, 70, "Text",ExpressionUUID->"cfc96cdb-090f-4c40-9adc-9c059b558c36",
 CellTags->{"p:132", "i:12"}],
Cell[18990, 646, 255, 9, 70, "CodeCaption",ExpressionUUID->"8e2b4e3d-699d-4248-a3a0-d6d4b461b7ca"],
Cell[CellGroupData[{
Cell[19270, 659, 392, 9, 70, "Input",ExpressionUUID->"c239b25f-512b-4a74-91aa-2e877a86a3d5"],
Cell[19665, 670, 1154, 31, 70, "Output",ExpressionUUID->"a7b7430b-f71c-412d-aec9-69d9d1359d89",
 Evaluatable->False]
}, Open  ]],
Cell[20834, 704, 175, 4, 70, "CodeCaption",ExpressionUUID->"7001d9d3-49bc-4e13-a3d7-25d8b14c2816",
 CellTags->"i:13"],
Cell[CellGroupData[{
Cell[21034, 712, 395, 9, 70, "Input",ExpressionUUID->"ca86f866-ddee-4416-b12a-2ca747c1e48c"],
Cell[21432, 723, 15964, 410, 70, "Output",ExpressionUUID->"1f9d70f5-b4dd-4911-9262-e2e56776d920",
 Evaluatable->False]
}, Open  ]],
Cell[37411, 1136, 421, 11, 70, "Text",ExpressionUUID->"113dd28c-be27-445e-bd68-572d02798461",
 CellTags->"i:14"],
Cell[37835, 1149, 234, 8, 70, "CodeCaption",ExpressionUUID->"f379e594-0307-489b-a937-cf97a099f455"],
Cell[CellGroupData[{
Cell[38094, 1161, 252, 7, 70, "Input",ExpressionUUID->"d4eff812-2695-4528-a793-9c974c57c649"],
Cell[38349, 1170, 218, 6, 70, "Output",ExpressionUUID->"addcc5e6-c844-488a-913b-741383e520d1",
 Evaluatable->False]
}, Open  ]],
Cell[38582, 1179, 287, 9, 70, "Text",ExpressionUUID->"7ce54f89-d9f2-4335-8e18-fec7a2867e9b",
 CellTags->"i:15"],
Cell[38872, 1190, 236, 8, 70, "CodeCaption",ExpressionUUID->"d8fd674b-252b-46ef-bff3-37e5a415a001"],
Cell[CellGroupData[{
Cell[39133, 1202, 330, 8, 70, "Input",ExpressionUUID->"480283e6-1363-4566-a2a8-6fac3b56cb0e"],
Cell[39466, 1212, 268, 7, 70, "Output",ExpressionUUID->"29a02990-2f78-4359-a12a-d45fe50191e7",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[39749, 1222, 535, 16, 70, "Text",ExpressionUUID->"ee932637-fd2c-4eeb-898c-cb8e28236863",
 CellTags->{"p:133", "i:16"}],
Cell[40287, 1240, 180, 4, 70, "CodeCaption",ExpressionUUID->"f11ef301-b6c4-4c6b-9972-61581b6f3053"],
Cell[CellGroupData[{
Cell[40492, 1248, 490, 14, 70, "Input",ExpressionUUID->"36a58e7f-9e69-470a-ba5c-a0808ec6e6d6"],
Cell[40985, 1264, 251, 6, 70, "Output",ExpressionUUID->"f91a9482-cb86-4291-a7da-f6bb16cf9ab4",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41285, 1276, 159, 4, 70, "VocabularySection",ExpressionUUID->"1d4d534e-0e15-49bb-80e8-f5e4e9f4b9a8"],
Cell[41447, 1282, 3754, 105, 70, "VocabularyTable",ExpressionUUID->"6b0e53e2-4ec7-40ca-88cf-70b89f547ebb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45238, 1392, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"7a24815e-852d-42d6-a589-9df0d291186d"],
Cell[CellGroupData[{
Cell[47043, 1442, 1453, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"da401a29-a344-474d-bf8a-a523b368a3e3"],
Cell[CellGroupData[{
Cell[48521, 1491, 820, 25, 70, "Exercise",ExpressionUUID->"9f55571f-7dcc-48b8-b66f-9d16d496aaf9"],
Cell[49344, 1518, 2167, 46, 70, "ExerciseOutput",ExpressionUUID->"4d777b65-c375-4a61-a5b1-108539c5ae4f"]
}, Closed]],
Cell[CellGroupData[{
Cell[51548, 1569, 713, 20, 70, "Exercise",ExpressionUUID->"54ba0f81-b7a6-42a3-898c-a5fbc8c3c454"],
Cell[52264, 1591, 1848, 46, 70, "ExerciseOutput",ExpressionUUID->"f9b10b01-8806-412f-a601-55103ae8f63a"]
}, Closed]],
Cell[CellGroupData[{
Cell[54149, 1642, 830, 26, 70, "Exercise",ExpressionUUID->"e24b7fb3-faff-43dd-ab65-59f67e537c17"],
Cell[54982, 1670, 11533, 215, 70, "ExerciseOutput",ExpressionUUID->"e4c2f226-5735-4d99-ba08-266f689e1edd"]
}, Closed]],
Cell[CellGroupData[{
Cell[66552, 1890, 794, 23, 70, "Exercise",ExpressionUUID->"c8e26c3c-ce6c-445f-8fc9-4ea3bd551078"],
Cell[67349, 1915, 43100, 724, 70, "ExerciseOutput",ExpressionUUID->"92cecef9-3123-4748-8ba6-86069e94c57e"]
}, Closed]],
Cell[CellGroupData[{
Cell[110486, 2644, 1017, 31, 70, "Exercise",ExpressionUUID->"7cf7b98c-1063-47cf-9258-ec5afa2f791e"],
Cell[111506, 2677, 1883, 45, 70, "ExerciseOutput",ExpressionUUID->"060b4a8c-2752-4fdd-8a6a-502bf2713d5e"]
}, Closed]],
Cell[CellGroupData[{
Cell[113426, 2727, 1022, 31, 70, "Exercise",ExpressionUUID->"b28c9553-fb3d-4500-9fa0-00e1438baabc"],
Cell[114451, 2760, 3879, 91, 70, "ExerciseOutput",ExpressionUUID->"c8ec94e7-aad7-4473-b966-08df876b9f92"]
}, Closed]],
Cell[CellGroupData[{
Cell[118367, 2856, 731, 20, 70, "Exercise",ExpressionUUID->"f6103473-bb6f-4323-a711-823ec2a70306"],
Cell[119101, 2878, 1444, 40, 70, "ExerciseOutput",ExpressionUUID->"cedf1162-9fb1-481e-9e83-975a59cfcf1b"]
}, Closed]],
Cell[CellGroupData[{
Cell[120582, 2923, 1132, 34, 70, "Exercise",ExpressionUUID->"d5ceaf1c-76ca-40a5-8d63-aea701f83dd6"],
Cell[121717, 2959, 37393, 666, 70, "ExerciseOutput",ExpressionUUID->"11a1f665-4842-48c5-9b8e-83cf5cecb7f9"]
}, Closed]],
Cell[CellGroupData[{
Cell[159147, 3630, 816, 22, 70, "Exercise",ExpressionUUID->"cd22a870-dc08-40ac-9b0a-085703067885",
 CellTags->"LastCellOfAPage"],
Cell[159966, 3654, 22334, 492, 70, "ExerciseOutput",ExpressionUUID->"6a0b2a9c-3be4-4fb1-888b-1698240bd36e"]
}, Closed]],
Cell[CellGroupData[{
Cell[182337, 4151, 1091, 31, 70, "Exercise",ExpressionUUID->"b42d5ee2-345f-4f1c-a3c5-caacbe59a6a1",
 CellTags->"p:134"],
Cell[183431, 4184, 28711, 498, 70, "ExerciseOutput",ExpressionUUID->"bdcd0e43-f012-4ba9-a8f8-63fe1e6f1757"]
}, Closed]],
Cell[CellGroupData[{
Cell[212179, 4687, 738, 20, 70, "Exercise",ExpressionUUID->"c3b0b373-a054-49ec-8db9-ae6e533e1a83"],
Cell[212920, 4709, 3963, 92, 70, "ExerciseOutput",ExpressionUUID->"ff91f2fb-32c6-4fb0-8e43-79b0197b2615"]
}, Closed]],
Cell[CellGroupData[{
Cell[216920, 4806, 757, 21, 70, "Exercise",ExpressionUUID->"c3e4242a-eb31-4d1d-855c-340f1be79638"],
Cell[217680, 4829, 29407, 613, 70, "ExerciseOutput",ExpressionUUID->"5ed2c3d6-60c3-4cba-a966-a95b494a88ab"]
}, Closed]],
Cell[CellGroupData[{
Cell[247124, 5447, 1096, 33, 70, "Exercise",ExpressionUUID->"4d02b9cb-2e85-4b73-a2b8-66afccc6916b"],
Cell[248223, 5482, 3323, 76, 70, "ExerciseOutput",ExpressionUUID->"579a7d45-1ff8-4f60-b0d0-faddc4c7f88b"]
}, Closed]],
Cell[CellGroupData[{
Cell[251583, 5563, 1182, 34, 70, "Exercise",ExpressionUUID->"3e75fab8-97af-4a74-91f3-64ec8757bd8f"],
Cell[252768, 5599, 10734, 266, 70, "ExerciseOutput",ExpressionUUID->"82234bf6-4adf-4eea-88ce-07484b5cb70a"]
}, Closed]],
Cell[CellGroupData[{
Cell[263539, 5870, 771, 23, 70, "Exercise",ExpressionUUID->"8682b7a3-16f3-4596-a45c-49a46b17ef80"],
Cell[264313, 5895, 1240, 34, 70, "ExerciseOutput",ExpressionUUID->"75f6fc76-ecb4-4fca-b309-ece4848325ca"]
}, Closed]],
Cell[CellGroupData[{
Cell[265590, 5934, 711, 20, 70, "Exercise",ExpressionUUID->"97cf1ee1-4b41-43b7-9d7b-a9d6d7aa4bf4"],
Cell[266304, 5956, 1077, 31, 70, "ExerciseOutput",ExpressionUUID->"5dac6825-f6b6-4755-b026-0ef5bcbba315"]
}, Closed]],
Cell[CellGroupData[{
Cell[267418, 5992, 711, 20, 70, "Exercise",ExpressionUUID->"b2cfd91c-c86d-41db-b8e8-5ab87ba6efcc"],
Cell[268132, 6014, 3525, 67, 70, "ExerciseOutput",ExpressionUUID->"5e23dfb3-d5c4-476d-8057-74de54636699"]
}, Closed]],
Cell[CellGroupData[{
Cell[271694, 6086, 780, 21, 70, "Exercise",ExpressionUUID->"833b42c0-63b5-47c8-9be1-3a2cf25acbd2"],
Cell[272477, 6109, 33282, 563, 70, "ExerciseOutput",ExpressionUUID->"41990a44-ac10-4e5d-9da0-5925b8183d77"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[305820, 6679, 144, 4, 70, "QASection",ExpressionUUID->"ff71fd34-9927-47e3-8ed9-f1bcb7bdafb9"],
Cell[305967, 6685, 232, 6, 70, "Question",ExpressionUUID->"bd98d5a4-5fc9-4242-a94d-7097ab23b864",
 CellTags->"i:17"],
Cell[306202, 6693, 1422, 54, 70, "Answer",ExpressionUUID->"4fac4114-bdb1-4e86-bc21-c007a31b66bb",
 CellTags->"i:18"],
Cell[307627, 6749, 190, 4, 70, "Question",ExpressionUUID->"2d877ae7-c612-4ef7-9524-c603668d897c",
 CellTags->"i:19"],
Cell[307820, 6755, 1002, 31, 70, "Answer",ExpressionUUID->"5e6f1d55-f4aa-421f-9314-fd89d134a967"],
Cell[308825, 6788, 432, 12, 70, "Question",ExpressionUUID->"ff41d60d-bf78-4d71-8b57-6e66999714d5",
 CellTags->"i:20"],
Cell[309260, 6802, 261, 7, 70, "Answer",ExpressionUUID->"52cf0305-78e3-4510-8dc1-f81fcc930e9a"],
Cell[309524, 6811, 203, 4, 70, "Question",ExpressionUUID->"2d58ca3f-4c5b-49a9-bbc2-92bf112c2726",
 CellTags->"i:21"],
Cell[309730, 6817, 522, 17, 70, "Answer",ExpressionUUID->"33e4410d-5a92-4fe4-a667-920155df0740"],
Cell[310255, 6836, 204, 4, 70, "Question",ExpressionUUID->"c8d5398f-0680-4105-a81b-497bcd1489b8",
 CellTags->"i:22"],
Cell[310462, 6842, 320, 10, 70, "Answer",ExpressionUUID->"9900988b-5595-4c91-8d9d-daf3d85bab75"],
Cell[310785, 6854, 417, 14, 70, "Question",ExpressionUUID->"72193441-34c6-46b0-b9a7-5d489ab92f99"],
Cell[311205, 6870, 603, 18, 70, "Answer",ExpressionUUID->"1eb4d084-47ad-4e4b-87fc-0bfac53d317d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[311845, 6893, 157, 4, 70, "TechNoteSection",ExpressionUUID->"783aef6c-e1e0-44d2-b798-c78d8c598022"],
Cell[312005, 6899, 322, 8, 70, "TechNote",ExpressionUUID->"b327d21f-a9ba-4686-9778-cc2944d46d7b"],
Cell[312330, 6909, 487, 13, 70, "TechNote",ExpressionUUID->"e1ec4990-dd14-4739-8c1e-4d2768871b63",
 CellTags->"i:23"],
Cell[312820, 6924, 593, 13, 70, "TechNote",ExpressionUUID->"be8bef9c-61f1-443d-a0aa-b16bd7b4fbb2",
 CellTags->"i:24"],
Cell[313416, 6939, 465, 13, 70, "TechNote",ExpressionUUID->"f2ab5175-a38e-4a07-b688-27adb3c3d87f"],
Cell[313884, 6954, 251, 7, 70, "TechNote",ExpressionUUID->"32c535b6-960a-45ce-9318-b24f042dc0b2",
 CellTags->"i:25"],
Cell[314138, 6963, 487, 17, 70, "TechNote",ExpressionUUID->"f968a65f-73d4-44d3-8cdc-61ed4530c819",
 CellTags->{"LastCellOfAPage", "i:26"}],
Cell[314628, 6982, 625, 19, 70, "TechNote",ExpressionUUID->"79cd8792-eace-49eb-90b7-c71fe5b98303",
 CellTags->{"p:135", "i:27"}],
Cell[315256, 7003, 393, 14, 70, "TechNote",ExpressionUUID->"285064b1-2d87-4818-82ab-ef213f769319",
 CellTags->"i:28"],
Cell[315652, 7019, 309, 11, 70, "TechNote",ExpressionUUID->"9523f462-e79a-4f43-aaaf-31ac4f5fde7a",
 CellTags->"i:29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[315998, 7035, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"cc99bcc2-e7f9-40f6-89a8-10f799905d3c"],
Cell[316166, 7041, 323, 7, 70, "MoreExplore",ExpressionUUID->"12938cea-9e53-4696-b106-635fc01b8ce4"],
Cell[316492, 7050, 358, 8, 70, "MoreExplore",ExpressionUUID->"8ce91a8f-0e70-435e-80b1-c54e4a1f0134",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature EIz7IBgoEpnEjK55gB@INVPN *)
