(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1232756,      22170]
NotebookOptionsPosition[   1156316,      20555]
NotebookOutlinePosition[   1216787,      21797]
CellTagsIndexPosition[   1216706,      21792]
WindowTitle->Graphs and Networks: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Make a graph consisting of a loop of 3 nodes.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"b0a7a724-7e97-4064-8bb6-0328cf1fe831"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fe930467-21d3-4bd1-b813-94c251433ec3"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3dlTW1eeB/DU9Es/zr8wf0XPUy/ppaofu7vmJW/dGbc75YmdCDvBTryF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            "], {{0, 220}, {
            251, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{251, 220},
          PlotRange->{{0, 251}, {0, 220}}]], "ExerciseOutput",
         ImageSize->{255, 220},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a92f2839-9c93-438c-8118-0ba7385f1cc2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3dlTW1eeB/DU9Es/zr8wf0XPUy/ppaofu7vmJW/dGbc75YmdCDvBTryF
2Kw2xmATsDG2AbNIQggQm9jFjsQmdgFiNRJiFwKhLXOEEqeDbSTEvfrd5fsp
2YVlLb+yj67Oufec7/mvf1z66z//44MPPoj7Jfvtr3//8ncKxd+v/u0/2R/+
52LcJ+cvnvvfP1+8fO78OcV//+MX7M4Z9svLfgV//h4AAAAAAAAA4Ijb7U5M
Sr7w6aW7iUlbW1vU5QDwiLXwD3//p48+/izpcdm5SzfYz6z9UxcFwBd2VGft
vKDaGLqxls/uoS4KgC+sJ8OO7W8aPPuZ3UNdFABfWO+dHdXfNHh2tGf3UBcF
wBfWY//1b//w8cWv2bGdtfzf/O4PGLeChAUCgWv3Si/GXQudpXlV1W1dWacu
CoAv7UZLWr7+zR+NowufJZbNLaPNgwTtuz2XU9VLtp/6MHsu979uv7qUWDa7
uEZYGAAflPUDBZU9x+68m1t7/lYRa/MzaPMgIfb1XUWKyuk6fpmpommINXh2
u3i31LKANg8SkVnYou8af/v+Kast1ODZ7dM7aPMgBebpleuZlT6//+2/8vr8
7Nh+IaE4V2nY2N4LBAKxLw+AQ35/gLV2s2XlfQ/ILTOwkSzrzPeOWGNYFwAv
GrsnHxY2n/CAfbeH/T675PjyXvmhxxurugC453QdsLGqzbETyYPz1J3a5mG+
SwLgT1FVX1mdMcIHb+3uK5KVrCfPa0kAPGE98ytpatfBYeRP0bWZc0rb+SsJ
gD/3nje2GadP9RSP13c1vWJ63s5TSQA8MY0vJmTrojjNaBpbiO6JAFRCB+op
qy26p6fl69uNFm5LAuBPTbs5p8wQ9dNZ5/9yqjp0uhJA4EInW9a3znSypbCq
V1ln4qokAP48K++saDrr6XSny61IUdnXdzkpCYAnc8vrXF0w1XeNZxa2nP11
APiT+KSuZ9jKyUv5/P7rDytHLa85eTUAznUPzyU9qePwBc2W4DRLvx+nKEFw
3Ide1pnhfFH2w8Lmxu5Jbl8T4Ow0jYP55V2cv+yqYzsuRe10HXD+ygBRc2w6
FcnKbec+Hy9eVmcsqurj45UBovNdaXtN+yhPL+46ODwWdwBAaNJqu/agwut7
xwo+rrT1T9/7t0AbACp+f+Cbx7qB8UW+3yUhW2caW+D1XQDCYsfe+88bY/BG
U/P2q+n8fo8AnCzUu162x6h3nVNmqGk3x+a9AN5WWmssqo7d+ZP1rT1FsnJr
l5dzQQAnW3VsK1JUe2+FifGqomkoX8P92X6AsDIKmpt6Yn0N9NDj/SKN++u5
ACcbmVq+mVVNMsule2guMZfLGTsAJwvNYxybIZvHyBo8a/ZU7w5y09A5nvWq
lbAADmfdA5xsdy8YJmbfIF6LxIaubABLWwPIQUFlr7KefrUpJytnAU62+Hrz
Spr6QBh5AmfMRgAIK/WZ3mASSmKMx+u79qBiCjFlwI9+8/y3OTWCygQzjS18
8xgxZcC9Q48vPl1jWRDc4TSKBEuAsKpbR3KVQuwwh2LKTpVRDHCyzR2XkJPb
T5VCDxDWU1VHZcsIdRXvdap9RgBONrvoiL+vEfhlzbA7SQFE6E5ObZ95nrqK
MMLuFQgQic6BmeS8BuoqInLCbrAAkThwe66kqRdeb1AXEqn37fcNEAl1w8AL
bQ91FadgX99lo1dnbBdhgTSsHYWJ7ThFlnGnrDMVVvVSVwHi86i4tb5TfN2D
fbcHMWVwWhOzq19laEUaAtNutKQhpgwi5vcHbmZVDU8uUxcSpUDgKKaM5zA0
kIyWvqn0l03UVZzJ9FFMmcfroy4EhG5v/zAuRbVi36Yu5KxyStt1bYgpgzCK
a/qLdf3UVXBgY3vv8yTElMFJ2IGdHd7ZQZ66EG5om4fz1J3UVYBwsa57S+8U
dRWcOfQEt52aXXJQFwJCNDS5dOsRTZgYf3qGrYmcbiwI0uD1+b/K0E7MrlIX
wr2kJ3Xdw4gpg5+p6xh7XNxGXQUvrMvrX6SVuw8FPZ8fYmnHeaBIVq5tOqkL
4Ut+eZemcZC6ChCKF9oedcMAdRU82nYGY8oc0v1EQ+TmVzbYN75AwsT4U2sY
yy6RZp8NTiU5r6FzYIa6Ct6xUfm1BxWTVht1IUCpd8R6J6eWuooYGRhf/Oax
TmLnXSFyhx5v/H3N7KKMrsvcf97Y1o+YMpmqbBl5quqgriKmlu1bcSkqxJTJ
0MZ2cAvIzR0XdSGxVlTdV1qLmDLZyVUaqluFGybGnz2XW5GiWnWIfv4zRM6y
sHY1veLQI9P1EU09kxkFiCmTi+AKuO9qjKML1IWQ8fsDN7KqRqYRUyYLBpMl
9Znc1ziPzby+/hAxZdJ3EEqxWN2kLoReVlGLvmuCugrgl7LeVFCJnKIg+/pu
XIp6d09kSVMQOfwXH4OPv7ThS/wYdPAkDMO0dzKYZlKfiSMPHCKHE3Hvg5O0
koRLLSewLKzFp2sQUyYZTtcBG6viYvoJZDvRQpIwXSos2U6lkx5MiI0QYsqk
4V6+HkseIvFDTNniGnUhED0sajsVWS14lB4sW45C8tP6rsFZ6iogGjXto9+V
tlNXITIyCS2RHkQPRe15RXe5HjFlIoNwuaiFggdxrBAR60owPvTQg/jQKNUa
RrNL0BsUDQREn5GEw8Olp3toLjEXWwCc1eDE4u3HUtseQnpCV0/mltepC5GC
9BeNrX3S2QBIkiqahvI1XdRVSMTRFm9qzMoQrPWt4AwobNTIoVe6/pIaKWzi
KUk5ZYaadmzFy6U9l/toZvUOdSFw3NS8/doDbLbOvebeqQcvm6irgJ/x+wMJ
2TrTGNapcY/9297MqhqeXKIuBH7S1j99L1/uYWL8Ca1/9/qw/l0QXAeHwawJ
2xZ1IVL2qLitvmOMugoIKqszFlX1UVchcfaNXUWyEhlW5FYdwXPFThf+I3in
ahh4qe2hrkLuHhY2N3ZPUlchCwduz5U09cLrDepC5GtkeuVGVhXme8RMx8BM
Sh5iymj4/P7rDytHLa+pC5GRQCDwbU5Nv3meuhA50neNZxa2UFchOzOLa/H3
NbLdLYiK82hnLvv6LnUhcvRE1VHVgpiymCqo7FHWD1BXIVOb267PkxBTFjtL
q5tX0tT7WFlPp6p15InM9nQmlPqswWCaoa5C1lgf/iimzEFdiPSZxhYSsnWB
AE5FEuszzyOmjG8ery8+XWNZQP6hICTnNXQO4KuWR7o2c26ZgboK+MHC6w02
mEJMGU82d1yKFNXG9h51IfCTF9oedQNOl/EiT92pbR6mrgJ+JhRTtoaYMq7N
Lq59eQ9hYkJU3zn+qLiVugqpuZNT2ztipa4C3gExZZzrGpxNflpPXQW819Dk
0q1HiCnjxoHb80Va+fwKpmELWvrLphbElHGhXD/4vKKbugoI4yimTLW3j5iy
M3FsOhXJyh0nVvCJQLGuvxgxZWeTXdJeaxilrgIiwg7v7CDPDvXUhYgVG/iz
4T/iUESEdePTEVMWFTbkv/24enBikboQOIUfY8qWqQsRn5ZeHCtECd/LUXAd
sN6gGr1BkXpU3FrfOU5dhZiU1PS/0mG8L1ZrOLd2Gq/XgmFiOKMrauqGgReI
KYvMg5dNzb24ZiduiCmLEBvgY1aGNHQOzCbnYQbUSdjQ/usM7Tjm3UnFnZza
PsSUvV99x9ij4jbqKoAzs4uOo1UMiCl7B6ydkaSnqo5KxJS9ywttt1o/SF0F
cGxz5yimbBsxZT+D9e8SVtWCmLLj2HCeDeqpqwBesD58/H3NzCLShH7Qb57/
NqeGugrgUei/GHlx3yOlUDZS8ho6EFOGHFrZwDDt+6OkcUUyhvBy8VLbo5J3
TBn2kpCV3b3gpRb7hkz3bcFuQTIk24vp2A9Onry+4N6LYzOy23sRO37K1vDk
0k2Z7a6LydIyJ7clD2yo/hLLYWRs1bETXNTmclMXEgtskM6G6mzATl0IUJLP
smU2SGdDdeoqgJhMginY8PzrDK3Pj9AS+L61byr9RSN1FTz6MZZqiboQEATJ
h8s19UxmFDRTVwECIuGYMjYkZ302NjynLgSERaoB0WxIXoLwcHiLJLcACG0P
wQbm1IWAEElvkxc2GG/FBkDwHhLbxmtwYokNxmU1dwJOSzIbNf6wieecjboQ
EDppbMVbaxjLLpHj/Gc4LQlstr7t3GcDcAfCxCAyeepObfMwdRXRy9d0aRqH
qKsA0djcCa5x3tjeoy4kGtbldTb0dh+K+BsKYk/XZs4tM1BXEQ026O4emqOu
AkTG4/XFp2ssCyKLKesZtiY+qaOuAkTJOLqQ8J2YYsrYQDsYJraEMDGIUuoz
vcFkoa4iUmygzYbb1FWAiC2tbl5OFUdMGRtis4H21u4+dSEgbgWVvcp6E3UV
4eWUtrOBNnUVIHq7ewdxKWr7uqBjyqbn7VfTK9hAm7oQkAJ910RWUQt1Fe/F
htUJ2TrTuGRXbEGM+fyCjilrN1rS8vXUVYCkjEwt38wS4lTbfbeHDauXbFvU
hYDUZBQ0N/VMUldxnLLOVFjVS10FSNCqY1uRohJUTJntKDnNKaSSQEpKa41F
1X3UVfwks6hF3z1BXQVI1lFMmWrZLogOs3l65XpmJcLEgFdt/dP3n9PHlAVP
HGVWsjZPXQhI3I8xZcSxdawnkyngSwMgJZNW27UHFYQxZc6jMDEbwsQgVrJL
2moNZNHThVW9yjoRTO8ByQjFlG07CaYmLtm2Lqeq98UwgROkRNM4mF/eFfv3
TcvXtxtFM0UfJMN96P0irdy6vB7LNzWNLyZk60S0CAukpHtoLpYxZR6v72p6
xZQVYWJAJvFJXc+wNTbvpWsz55S2x+a9AN5pdskRm5iyrd39z5PEGpUDUvKs
vLOiifeYsti8C0BYMTj2xux7BCASfPeuYzlSAAgrdP5ket7Ox4vH+FwQQCQ4
P0O+u3cwabWRnO0HiAS310D7zfNxKaoX2m6S67kAYXE7y+Wltuf8raILCSVP
VR36rnFcXQUB4nAe41cZWtbg2e3TO6WTuLoKguR0uRUpqrPHlDk2nT+29pKJ
2VVOagPgA+t+ZBa2nPFFDKYZ1tr/71u0dhA6TlabPlF1sNYu2KwzgH9ntgTz
BM4SUxafrhm1oLWDaDwsbG7sPl1MmdvtTkxKvvDppa+u3+40jvNUGAAfbI6d
i3eLbyfcYQ34bmLS1laYKBv2gA9//6ePPv4s6XHZuUs32M+s/cemVIAIzS45
inX9gxOLroPDY3/FGvBvP/zjRx9firABsw8Fe1hBtTF0Yy2f3cNn7QCnxnrp
V9LU528VffLNq8TcOk3j4MScLbQrwWkbMPsiYB+NN49nP//qw7+Ezkzihptw
btceVBy751Jima7N/MmFi8caMGvSJzR41ntnH4o3j2cfFnYPx59PgLNhR/jL
qepQO7+RVVVS0z8ytRzaAvu0DZh1eFi3hz2MfTTYE9nPYbv9ADE2ZbXllhkM
Jsvbqz+iaMDsAaGzNKzzgxEriA4aMAAAAAAAAIjU/wOvexjT
              "], {{0, 
              220}, {251, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {251, 220}, 
            PlotRange -> {{0, 251}, {0, 220}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"83d052b1-db40-44b4-8095-659b407c4c40"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c78d2f6d-48f8-4aeb-8246-2718988b7985"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6ba0d364-91eb-4023-98b8-778aedcde615"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d3ef7392-f4b1-44fa-a49d-15c78c39ef70"],

Cell["Make a graph with 4 nodes in which every node is connected.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"bd1c30b6-991d-4592-be97-bd2408cf47f0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"281c8d99-248f-41d9-b662-5a05249509e2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnWdTY1ma53t39sW+3K+wX2EjdmcmZid2OjZmOmYnYnemenvsTvdUd1VX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            "], {{0, 259}, {260, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{260, 259},
          PlotRange->{{0, 260}, {0, 259}}]], "ExerciseOutput",
         ImageSize->{264, 259},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2ddf8e6a-cb5b-4713-9714-6273e1238ff2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnWdTY1ma53t39sW+3K+wX2EjdmcmZid2OjZmOmYnYnemenvsTvdUd1VX
VVda0pGWTEiSxArvvZNAEpIACQkhhPAgECCM8N5DkiQuSRIy9y/dLrUKZK7V
xZxfqDIokO69uvc87pznPM9//vXNL37773/yk5/c+Y/454svH/w0JOTLhz//
T/ifX9y48903N77+6q9v3P36m69D/uTXf4Rf/tG/+8lP/gP+c/78mUAgEAgE
AoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFA
IBAIBAKBQCAQCAQCgUC4knw8PhH7EggEcfhw9NE2Ml+gao/Jq38QX3Xtpeyb
52XXIyvuxCgTChvkht4u+8zewQexL5NAEJCVjXcZMsvNqMrEYlObbWp8dm1r
ex+///Tp0+GHj7v774cnl+tahnIUrXhPapm5o3+aWA2Kk5NPi2tvLT3jZTXd
uD9JJY3ReYasiuaKup76tpGltW2xL5BAl7c7B8Wazjsxiqbusf33gXU+bAes
Q2p5EwyHxTp+9PE4CBd5PoHGKKhqv/1a/jSlulDdAXGwDs5CaUwtbPQMzTV0
jFbqex4lqkMlKqnOuvVuX+zrJfhjcn4dQ1rV0HdweMT0szOLm8mljQ8lavv4
khDXdm6BIWjpnXycpHmRXmvscOztH/p//8rGdrXZDpGBRGzvHgTnIgmMgB5D
IOCYWuFykKn5dYwKaEX4UXxd2Hmmd3guLLUW0dPs0htGH8T9URr77sUpR7jd
cALvDIwuIC5e29zhfih4TeVaKzyBhZUt7kc7t8CBRBQQnq4d5GAHx2ZWcdt1
zUM8XhiBC3iaUFCI+Pg9JqzM4MTl9JdgPSHsCIfhIHE8FNwkHAo2gpcLI3AB
IoBIeWGVT0GggPWH0kPwyPuRxaWjf/p+XBUXc3AKmBjEGnUtw3wdkMCOuAKj
uXtMoIOvbLy7G6vsHZkX6PjBB9Ex1Pib7T1+D3twePQ0pRpSxu9hCfRp75t6
lV336RNXQ+8HWBxnSD69KtwpgkZzzwS+C7XUwjuIvqE3dvauxJzDeQOmGd4R
VLfQJ6Ke8tobHgJzEbEOzsLlE0gQKFQN/VmVLcIdn+ALU+dojqI1OOcytjui
8wzcI02xmJhbg0UQIqryBPcnIkPb57g8LuVF4XGSZmphI2inSyw21TTZg3Y6
Htk7+BCaoBqbXQvCuWB9YvONQTgRwc3A6EJUjj6YZ9zdP4Rq3djaDeZJeaGg
ql2qtQbnXDANTh01HzwdRciqaA7+rIXWMpgbLK+ML+xji0+Tqz8cBS/PqtU2
mVreFLTTXXGgfG6/lr/bDfaUBUbUg/iquWVm6Qoi8unTp2epNUFOkzj6eHwz
qpIkwweHqfl1xGiinNrYPlKgahfl1Czoss/E5NUH/7yZYljtq0m12a6st4ly
6t3991B675nnwQYfGAV4R+NBCZlPAUHIkDUH/7xXkJQyM48pBEzJqmxp6Z0Q
6+z0GZ1ZfZmlE+XU0BXQGGR7VBB4nKQRceXLOjibIbOIdXb6lFR31beNiHV2
OLEXKLC6oEDbfB8hFXHZa2t7/26sUqyz0+T45CQkRvF2R7S9Noiq2mxTYp39
irC0th2WWivuNYQmqNbP90LDzOKmWNMLFDBJFXU9Il7AVcA+vpQmFdlFSSkV
M2Chg6VnvEjTKeIFjEytSIpNIl7AVcA2Mi+6u56nbOuyz4h7Df4pqe40dwmV
yk4HBHRPkjQiXsBVAIMQQ1Hca5DqrMJtmuCF5NJGcXchUSkrIl7AVaDVNlmk
6RD3Gir1PQ0do+Jeg39i8+tFWVlwg+D9u/ByES/gKgDTL9MFKdPMF1mVLb3D
c+Jeg38is+qYlrbgneuRFR+OPop7DZebNttkoVpkuxCdVz85vy7uNfgnOtcw
vbgp7jWEJqhEnNS9CgyMLoibBnly8gmecPAzAxmBkEr0jKCbUZUsirYR6DO1
sPE6uDsXTgE/HB6IiBdAB7VpoFaknUduW/DN8zJBt6IT1rd2H4s6WVdl7NM0
Doh4AXToGZpLk4pjPU2do5Ji0+zSJuKFzy7RIPnbAgGze/u1XKyzfzg6vh9X
df7LTR9++ChWPm23q8gAXndiFPfilPAnRYygMVpWN96Nza7hqoztI8p6W7nW
WqBqz6poTikzxxc2vMquC0uteShR4zohvN9HSPEvbh3GGH6D638QX4W/Qv0+
Ta4OT9fGFRjTpRZErHKDTWsZNHeN4chDE8uIztY2d4JfmxpBmVh7LevbRrIv
SKmHNKlFlAVBx/QqJQvUCwNG6DPCE8N4GBxfaugYlemsWZUtMXn1GL3XXsow
qjGGMYBzFK2V+h5D6zBGb3vfVO/w3ODEEmRkZnFzeX178+3e7v4hFB0GMyQX
EgRbht8gKtx6t/9mew/Hx1CHDhybWe1zzLfZJo3tDjiikCyqMn9Utv5Zag1E
CeKDn7PlLUpjH85lH1vEp4RTSrD+okxp4i7BKFyUOqsDo4sRmSLkbOPRuwXh
xqsK3h0kHHBqfh3jWdXQnyGzvEivxQiE6saAlLnWQDE2JubW197siGKPtncP
ENJaB2f1rcNltd0ppebnabWwNSExCsS5JdVd8CEhg3zdFkSFqgYRCngmlzbK
Db3BPy9rovMMwZ9N2tl775YFOBLcD7i3fwgnBPYFlg4ey62oSihe+Dm65sHe
kfmF1bcXomsGBv/E3JrFOg4BgdmCwYJehfwq6m0dA9Pzy1t+tnvAQh2feP8r
7A4OIthVewfXHJGhvVglkhxTK3AVgjxU4LF8+6IcgvC7cCm7liUIdqA54c/A
HcX1Y9hIihqqjH1Q+ILWOgsycL3s40t1LcO5ilZYN9iO6Lx6eFb9owu7P+6C
MTW/AQcMCuHsQXCH4ZUF65KdQJxhiINZTYIv5Ppe6I0gz23ejVVCFhglysJF
xxiAk+MaFTJYtIq6HsQ7q8LXRTwnwC5AA8D8wf2A7XuaUl2k6WizTeEOQANQ
dja1vOnsLjZE9EErwgMH71Gi+pxvWPAFDFlCYQPscjBPivGMB7eyEWC2DQYL
lgvuLnweRBaQWUPbCLyFi2V8BcLZNc86nqdsw9h7llLtdjuhk5X1Ns9gvNps
Vwi//R9nLNZ0Iva50LkEcDlwD6ODWBADLo2vvHpYqOnFTV3zEN7j8goMmsaB
sZlVsjnaDwiOPKfm8IJf5I4EETH92+2Y8PCItjah8rdHZ1YRqUGj0umBeM6B
dxdXYIRfGpwhl6NonVn6UTYUzgt3t7SmC+5TRKYOnhtcZQhpEC7mojM4vnRK
ENyv1zl63GeIwH/90/9x83Hcn/75Tzs7ed7ANTW/nia1wDZBHPg9sohgNEIW
4IWOCfyl8Dh+d/MupaM+HH1EwIvzwgGOyas3tjsuYhFOcRkYXYAJaO+barNN
ul74YarVNtnSO4EXfrj34DEEoaS2B//COlCfgkuDyAJxRJ9jwdIzjjBEqrXS
nwWF+zo4sQT9+ThJA1ftUuYbD4wuhkpUJdVdAjVKgAhAO+Gh/PGf/cXd8AxE
AYgEm3smSF8G3pmcX8fYhrP0UlJI3fM/+e8/jUsreShRX3sp82pH8PT9H3Nv
/7DLPpNV2XIzqjI2v757cPZyx27wTOQGGxR1QVU7AlUej7z1bv/2vUduHfXN
tTsXoqjaBeL45GR4chl29svHRf/vQcG/PSqCwzk8ufIwMvMffvk7k9kZo61s
vEN88btw6SlBeJFeC/FBcAHTjCeFH+Ah9LuMDoLxpJLG+3HOtZs0aRNsUMDW
xpcJBEGGtpHQBFV8YUNdyzBrocDTwV3FEaJy9CHR8mJZNaWj/st/+/Off/0C
jwAaBq9brgwf6oW3hcQogtY74xKwu/8evlB4hvaLG1n/51rGFzezIAvOKdYy
M5yZx4kaSZFzqtDQ+oeWeVvb+5X6nuuRFW5ZiC2oj84zhKdr4fzDdkRkOHOr
MPKpVUv72CLvncsuFrCAuAkVdT2II+7EKGAp4Fj2DM0trGydXaH79OkTHgrU
DtQLXFAEwq+y665HyqBw4Is6plcpe6pQ6372d/+WllvR2DX2/Uvpvz4o+NWj
wlM6inSzCghcdETN8ILwaH72dTJe//dW9q+fFLvvYYbMghiwc2AGv8xTto1M
rUTnGk4dZO/gQ43ZDs2D9+PhivJFLiKbb/dgLtUmZ58paA8Mcmo2G5ocTile
34WX466GpdbCkyzSdJi7xqbm10+tP8K+QEFBuPBZBF/4K+LlL58U//xmFgz6
H3RUfn09nt78OplK9QRGdmJuvabJHptvhEqPLzBCNeEuLa6+hQX3VCawqtA8
eIVEK/41tACyQBWf3971MvkPsTJ1jiaSEj3cgHWAN4U7vLt/SGfxGg+xrKZ7
fHYNIx8RHFXuHs+itmnwn+7m/u/v0ynjjkcj01kjs2BWKvARVUM/zNPV3OYA
+4jvXm22w+G58aoCprbK2If75qlkEMO+SNe6BQEanjLBcJz+6W4efpNf5Zy1
g7fT5Ls8y+WOgs8bVHtEyAKk5jdPS758XAzj4u6NhTga4x/u7t98l9pim6R+
CTFxTK3AjkNrIawIS63Bxy3WcbhhlzXuPjg8wldGhJVZ0RwqUUGZI25VmwYQ
xp5dyYJHSm2ymFt+89S1+lxS3UUpJZjU34aVIYJ2y0KfY57UZzsPYFTjyTpl
wZXvkV/VDv8W/wvN71knAY8bPthXT0vgCZ/aDY1HjDgFrlexpjMqWw85QoiX
Wt6kauiDlC2tbV9EzYYRiyvvcyzUtQxBbz9NrsYNQdCKr48v5SexB/cTBuJO
jNJd8y1NapF6VICBbf3b65mUpaBkAaYE+uQSLA1fdGDlqedCyQKCBcQI1G/w
gE4V5UAMXlLdiQgaJsDPCF97s4NRVNtkh/hAKyJ4icjQ4rlDOhC8D08ur2xs
n6uEybc7B47pVXypSn1PSpn5cZIG14wIK03apDT2IRyDXNBxNaHhoVjwTT1L
THjeQ/iu/3I//5ehhZ6y8Jl0gTkHvNneo2JttyxAH8Iu/OaHeQ94AmdL0C+s
vk0obHieVkuzxB8GAA7SZZ/RNQ9ClOBWQUAQlUCmonL0WRXNinobHGa8wb3p
EkLHozXBMMZoxzXAw2/pnURgiy+bIWt+naOHCcMduBenhEuDazO2O/AeyDLT
s29s7SJwgK/oPz1A3TjwN9+muiMItyx0Dsyki11t+IqTXdnifi7unNiITN0v
bme7fx8SLffaYHpg1NldMaXUHDCv1RdQnhj5PUNzhrYRqdaa+8OmSxw2JEbx
XXg5DJNzRj1TB3caJ4KzkSGzQHZyFK15yjaEokWaTgxgXDm1GxraNbm0MTa/
HtE9tDpUNC4eQodDOdd5s3Q4CBw5OPlwYGwj81Pz6xjDHOfE8HEIF06kbx32
tXOHAu7TFzcyf/Ww8KwswO28RbrAiAc0mOd0n1sWYKx/9ttk/AajqLy2G16N
r/JlePTGDgd8YwTXQswmIQzffLs3v7w1OrNqH1+C9GEA9w7PwWOHIsV1ttmm
mnsm4Nvg1TEw7dwNPb40PrsGE4DoFVZvz7UbmvcLczMytQLJhYTS2axU1zwE
OUVckFfVhrsNs+jZQxAmUtzyoVcW+ADReYYX6bXPUmp+G+aUhfIfekljBP7V
V8lwYyrqeug0fMR4Q2wIiUBUeBHDZHbs7h9my53b9xBh0Xn/9u4BbAdEGz/D
SEFOYRYhyO43IJg6/zWLLjfRuYY22yQ8k3KPvuoQjfb+KecUU4Jqil7VTehh
+CeQIHHrhAeH3pF5aHUMXfr7cAvVHaqG/s+uyOJBfNXZNzimVqCd+LxKAhPw
KF2VhI/hqXoaaLWpH041foDXAdtBX9uPuHZqw5+/rKkaey5z8Cy15tRGD//A
Z4MtoFZe4NrhCGffg2dx41XFZV2dOf9MzK3DIpz9Pfxzd5JMYrHJ2M6glyIk
CwoQwW9L7yQ/V3lu6HPMY0gr6m1MyzLE5htbf1imRKQAZ9Lr2yTFJvtYgPRs
gkDUtQzJ9V72icBMuHXU2psdOLpMd8surW2/ztFjDKxciiIAzoBX2YYwmabH
6Alsa0Smzr08EZ6u9dVWoK5luFJPmuWJQ2q5z+ptMAfuLSQ1rlUzFsdv6h6D
gYBffaFnC6Gr78dVYZSymJLCF38oUbsXHaBe4JT68jlnFjfhkXK6VgJboPB9
FeHXtw67G3rigT5KVLMLird3D7Iqmp8kaS7ixluYg4KqdkRAcCbZHYHKX3L/
79DEckJhg683w3bcfu3ziRCEA96Ln8rnsOOeOgqCgDezVu/28aVQiapA1b67
f2EeNL7yg/gqqdbKetcwRjW0jedWcZhI/xOnGTJxqulecVp6J/wsH5zVUVDv
1Wb2vSEwohCbIPbsGTrXbcI+uxZfqox9EN4xbotfxZpOpfFHRVMRHfs3rxbr
eEm1mE2NryaF6g5Lz7ifN8C4e+oohM/QcmfrvzFiYWXrWWoN4tBzm5b5Znsv
OteQUmrmeIX4pu55VDd3YhRet+24Eb3Z/dUkLLXWf0MKRL5lNT8q3GdsH+G+
zQoRqExnDU1QOVw7hs4VfY75OzFKY7uD+6HiC4yey8qfKZcpRuH/U/BCr0fK
zlUS76UH9/zaS5n/XLLpxc2XWT+qfg/nAUEEL40DIAjwxhGen5Nq27ghCA0e
Japn+Ogd2epayj+V5o2vDAEJ+NmoHP0577B5yZhf3gpPD2CLKXk5FS9PLWxg
DPPi4eAguYpWuExn08KDDBy/iEwdAiJemjbu7L2HL3Q2udfY4aDT1rlcaz3n
XcgvGR0D03DaA74tMqsOg//ULxX1Nq9ZBOywDs5i5Ggtg2Ll9SEmgl+EoJWv
A0LAq4xe+owUaTrprMW3903ReTQEvsB4rmsZCvg2xAuNXae3pcNSQJnz2GIJ
UTnCkNc5eo6BOVM+HH3E+MR38bpBgx3Dk8twtLw6/K+yvSiWsyCIe5pczdf1
EAKSVNJoHw+cbAy/1+u8K5xq3mslmV2L1KfiTeFY39p9nlaLb8dj0VEcCoIw
4mNOAEExnbLMiDJuvKo4t/Nslw/4/HTqrUFhhqV6zwpQm/ozZM1e/8Sa1Y13
iNbzq9qELoqLMBaOmTtfji+Uxj5f7g1MHsSE5nHiCxt8CRSBX6BzbkZV0nkn
fPjrkd4TieEpvUiv5X2RFIctVHdAY7PeOhoQxLD34pSs0yp8Ab0B+dr1UdG0
z7GQRntHMzxYXXNgD5bAnbGZ1RjaLU5i842Oae+pRPPLWwEXj9jRZpuCv9Q9
OMvvYSFocIoiMrS81yCFY4NwoM23odFaBulvW7ONzPNucwlegWdOv/uVXN+r
9yh+e4qaJmfhOH4u68dAzT5J0pRrrXzluEJmo3L02ZUtQqxkmTpH430n3X12
FcejX/VleX37aQoJn4MBVeOO5putg7N+2sQfn5xEZOra+6Z4urQfAd8ss6I5
MquO2ibMhenFzftxVXUtPoWaC1vv9mHF1jb9TYLFFRjpZzdB/L+PkF6dzeMi
khgoQ8yThZUt/0n1i2vwk5Xs2uDSoaFjFJ4YnVkvX0BUQ7gdwT9p0qbapgBZ
iw8laka9jZ4mVwsXMRHcwP7Sv88fjj5eeynzXzVO1+zs6MrHpXmHWuxWNfQz
VZV4f6W+B+NKuB67lp5xWC7/F4a/Qs/7z3g5BTzP/tEFzldHCADGNqNJy1CJ
yr9Ow7NGiE1n8Y41e/uHSSWNCYUN9Cfe8R1TSs34FC+ZFV5xboCNUQQUNITq
oQkqRkeWG2yGNgbbzAkseLfrzJZh9BFJsclr83pP3u4c3I1VCtq8G7ZJbep/
nKTx75lT7Oy9h7ouqe4Url88NMDrHL3Zd7l4NxNz6/Qn7iiaeyaKNB1sL41A
C0SRUTleal/4Qaqz+ird4AkccnjFQrdjgPOP8MR/vvf61i5EpiaQD88RrWUQ
RofOO7vsM7kMe3sxmvcmsKNnaC6rgtncdWMX3TlYuaGX/ooSa6Bm78UpfW1E
ml1yFiNq6RU2lwNngR2kWR5E1zxEFQqjj8t8K1ldGoEuhtZh+v2CKYYnlyVF
/ibP3SA8jMrWByHlGJr/WWpNRV3PqaAVvpxzykjgKkMfjo4Rj/eOzNN8f2lN
F4s82JtRlVez51HQgMNzNvXUPwj9vJY99Mrm2z3EI75KAPEIImKq/rY7RQTu
E3S1r0rIPIJ76C6RTQe4UoPMZ3Sjcw0syjER6JNa3hSwd/ZZGE092Ubm4a4H
oRwijAKct+dptRBA+CGPEtV0wmqOwEqGSlSM5qbC07X+t9N6JUfRynsWCsET
PBcW6fovs3SMdp9Bc/pZreaXxs7RX9zOvhurCEJlITgtMJFM62PgIyzWIiv1
PYyqdxKYAi+CRZEiptbk4/FJRIbWf50NXsCJNI0DjxPVt1/LrcJr0Wx5i6Le
xvRTrgLOjLPQDW0jLM5FoM934eUsEl1KqjuZDuy1NzsIHFj4BvSBIKSWmTE+
EbOvbGxD/fK4VfMs5u6xiEwd01xBXBvuOYvTdfTT2odLYAd8+BuvKlh8sNps
ZzFd3zs891CiFqhW3tHH4+TSRgiCezUNUcOTJI3WMijE6WaWNiHajHKKKOC5
wRazOKNjaoXm9B2BBc5kAAmzZAAK6NvSmi4WH1Sb+uMLGxil4tDhw9GxpNiU
q2g9ZeMw8OCb8V6tem//EELNYs7hs7NW5/az1BoWH4RJDWP1QQIdEDWzK8vW
P8pgW9YpEGvQ3y5BB/je8QXGgqp2r/kVB4dHMXn1Bap2HnOek0oalWxd96n5
dXczC0bsv/9wi972QwILxmbX/G858QU8hFfZdexOCscsLLWWr039hx8+xhUY
izQdfhKNYDWovp+8FCKD0xWbX89asgYnllLYbnf6PkJ6TmqpXT76HAvsNg9u
be/TX247y/rWLpxt7luMIVbReQY61XcxdBF4YgxzXOaA034vTslltrbLPsM6
BH6UyGzXA4E+bbapIg2bMs6sJ0PcUIOKy0ZjOD+vc37UYzEgMp0VPiHr2jVv
dw5wzf7blwfE3D0mpVEuzyvRefWknqRAGNsdcgNLv/dODNeCSMYOR0Smjl29
F6h3OGnu9ij0kWqt3zwvY7HH2dX2t577pgy4WKxr9WdVtsCUc7wAglfUpn5d
M8spR3YL1qdAwMui/iSGJWJh1gG42jRwP66K6aZpub4XUT+7M3rinI5mKwtw
rjoHZrhfA+EsUJJNNPaeeEVSbPJVHIY+H4+diayMiv8geIzNN0K3czmvuWvs
oURN30PrczhTqngpXgdJZL3k4UxwFX7t/moC1cp6ZdaVhsGDvYYTHpqgonko
WISUUjOjpFBfNHaNYXjTyQuaW36DSJ+v6t+qhn7W9Tdgm0hKkkCUVHeyntvM
UbTylfCzsLKF6GNiLnCGG5wEyCBfKwUIWJ4kafxvwMFfH8RXwS7wcsbPrsKS
rHcuaxrZ2xSCf4o0HayLiHL57FmoiqbL6/6yleDRxebX8zvBbmgdfppc7WuO
FHF9ZFadn9poLJAbeuvZygIid6/l6wncQQTKuq6XjN6uZ/p0D86GSlS+nBbE
mxEZWiE2QWCAPUut8SoOGbJmdnPOfnCmXnewbHoFv07KZA6ZQB843vQrGZ4C
Cor3qi/GdseL9NqzIaq5ewzOjK86vdyB4xGWWnPq+HDs4wqMvLdl56JDWK8H
EQLCZasUo+q49EF4iBHo6Qh12WdolsTnQk2THWK494M4dAxMI7LeE0D6yrVW
M8NNtW6cBTz5a4FE8CS7soV1e2Vj+wjGLb/XQwEJzaxopvKL7GOL9+KUK4KV
ufNE1dAXkanbO/iAKB6xvEC19RhVrz0F7oZApZsJGHKse0tZelimbQcEbomk
qEGqs1Jjcn55S4izeAXigMF2O1ouXIPdkupO1nMOYzOrCaxyKQkBSZdaWM8W
dg6wzzELCGLkR4nqf76XR7/oMS8cHB79w53ce3FVwhW1LqvtZr2+6ZgmsiAU
aVIL63LTfY6FLMG280MWHkrUXz4uEqh8vVeOT04kxSbEtkkljXRyX9mhqLcZ
2E7SjkytSDg3lyd4JYuDj4QPMi24RxPoZIxGjMm1zR1EzUHYwk+dFFYSoQri
FGpZQaCakzgs6yMPTSzTLFNJYAqX9QUM0RyGRUFpUq61ppSZKS8FUTNi5yCI
A24Fhpl78+nu/uGTJI0QXURhFFiXs4ARTyk183o5hN/DZX6Py54UP5i7x16k
13quqS2tbUMc6FdoZIFc3xudZziVPb6xtYvzstvU7IcmJh3BToGLCUJ92qsJ
l9yYjoFpr72euYBIGcPvbDb1wurbu7FKHpOCPNE1D3ld4Pv8+6w8nivnc7lv
rPchEgJSY7az3lfSZpssVPPZEWB5fds18Lzv23Ll7yl4yYz1BF7Qo0S1nz2b
I65EKR77QyHOymQbZ8E4CjdfccXh4ru29E6WVPO2vgD/HGPSf3toKnd6cIK3
Pms9Q3P346oC7iDuHJh5KFHTrCcfEC7xL1l3Fg4uvqvFOl5Ww09pl4/HJ3DX
6WR0zCxuwnbwsuiAg9Cv4+fcjpqhPfzAZjvqKSbm1mPzjew+y6KJCYEmHf3T
BVUsfVcE3Yz23fuhSNNJf6vp9OJmSIyC47owvjgOMrXAIBAo0nTw4p/Aur3M
0rH7LGSB9xiNQMHF/zR1jsrY1nPwpL1vKiy1llEFAASzGMmsd8EjJPnmeRnT
fWou41UfsFltQNa3dp8ms2xczqMtJpxicHyJdfNZyAL33LyFVWczaBapd2+2
9zCeWXT8mV1yBh3sdmrv7L0PTVBxrERBNQVm99m6lmGmza0INIG/wa6e4Wdu
c1AU7w+PoCFZJ41Dju7FKduY5LlNO8MNTl3OqVlWjtXCb0ZVsisjwGUOnOAf
1rWFQUVdD8dGbBkyC+uqWRRrb3YeStQ0t0zCs8IwDtiNNyAQ3keJnPqTPkut
YZeFXlLd1dLL275agifwgVmXv0PQzXpP3GfX9oeoHD33XWNvdw7CUmsC7gKe
mFsP2PqWPjhdQmED61zW+AIjOycNwZ2g6+9XnJBoObuGCGlSC+v8BJeKVvC1
VQ0qOipbD53pq7zw6MwqBGGUW+1HT3CilDIz66mDXEWr/5UUX0iKGoTbWEF4
kV67uMam/F1svpFdceDd/cMH8VUsGln6AQGppNgEtXnW0LgqbCjHGbZUC4gz
2EmpZrcrR26wsSuFwbRNHoERGELslq4gRCxCSGhUKDchNkpDCiAL+DqeK2LU
ghq/CUVuXF232GQrQRDYlbEldbYFpUDF0u2HbmeRlgApgCz46ZXABRy2pLoT
YQg1S+MSBCWjBTWmwOjgPjAtQc96+fgW2wkoAh2U9TZ2pV1cLZ6Zle3CyAmV
qIRuXq9q6AtLrTV2OO7FKYPQYx3SnchwrxkiF3YtYDhWkSX4p6FjlEXldjgk
30dIGX3k4PAIghCc/ctJJY3/89eS5qCU4T05+YTQiZE+Wd14x6Jl2+7+e/h7
TD9FoA+71MftXWdXDkYfyVO28ZKzERC5oTcstaZ7aPZurLLNFozt0vAVcS76
gcPxiVOTMG3gCBsXmcWyLxiBDhNza7H59Uw/5Wx6mMkgwaxnaA6akEUHEEbA
WsEPj8mrp5zqtc2dp8nVinqbQOGJJ4MTS4zcP1wY0z0RvcNzGTKyqU1Advbe
h0TLmX6KUR9PqE0ea7b74v3hEaJyjBbPaVUIRXyBMU3axEu6tX9gj+jfk9Qy
cz/DfUnG9hHem/MSTnErqpJpsURT5yj9IrcILYWulA6fLSJDK9VZz5oA+PMl
1V3469Z24FYLXIDPE5Wtp5mXAsFhWr6be9ILISCvc/RMO+LRXy1q7BqLzjUI
V3rrsysUfShR+49eqWml6cVN4S4DbL7dgwWkM3nV0jvJtEqwq7AbadYmLAVV
7UxjTGdiDI3CSisb7+7EKNeFXB6iUk/pLJHApcfFsK4HRRPbiLObVcDa+OOz
a9F5zDKEEaCRRWeh0TUPMe1iH5lVNxNIx8JnwNsEzauEnrwby2DL59La9qNE
taqhT1A7BVctO9AOqXe770MYTpDefi0Xou43wROoynSGVXfoNLRVmwZ4aXzp
i5ome2iCiqmq3N0/RPwSX9jApV+5fyBodJTATYRptOedEPtfj6zgfGmEAEBb
hqXW0n8/nZ1ZUwsb9+Oq2GXABgQDI0NmgY/BrsE04usasx2Xx7FruR9wS6Eu
/CfiMgrTcMDnaQyeEYEd1CIyfbdhJdCyKbyjF+m1AnnmG1u7OHhJdRfTtapT
OKZWEE3z3lrIjb512H8dYEYFPBHskOqRwQHh3tqbHZpvDljhR9c8KJB35Jhe
RYDAumb7Kd7uHETn1aeWmYVIeINugeb303bE2OGgv60PMsu6khWBEcmljfRr
cPnvQgKZCuFvn44nps5RCAK/jg1GrNxgeyhRC5HFt7a5ExIt95VlPTG3FpWt
p3moPGVbxwD7XYQE+qhN/fQLoZfVdjf6rkicUNjA+5IQvLgiTUd4ulagrm19
jnnIL1/mxhNj+0hcgffKYAi7rkfKaHp6ERlaMqEaHDAY6LujsfnGMR/bxDr6
pyOz6vidsdzdP4SzkVnRzKiGElOgvTHe8qva+D0L4vSYvHpfjTsh3XRGOO7n
tZcyfhtbE3xBpQzRfLOvnI3d/ffwYfhtrzY1vxGaoKJfVY8LGGwl1Z0Infjd
B7e+tQuj4zUcK9Z00uljuLS2zSLHm8Ca+3G0+sZube/jnV7/VKBqlxv47OyJ
gBHCxWMxYToMjDo7h8Jp5DhP5Ym5ewxB+tlcKURedDIxrIOzArVAInglTdpE
p94IRqbXSSTH1AoiUL4cjJ2995JiE5wxvqpbMz17mtQSkalbXuet1Hx8gfFs
BhccpBfpgVcNIJjca1cS6AM/RBmoytBn17T5WeUP7wKuBV+lLRzTq9DMmsYB
QTMlAtJqm4RvY+xw8HI0V9re6WqZ+IIInwMqkDSSlRdchieX433MeHjinNw7
kwinaujjpXcbxgZEAILAYy0jLiCgRuSbUNjAS743PKKz1eajcw0B69U8SlTT
X/0hcGf//YcbrwJnvJyd3IMjgdHLPd1i690+hkpisWn3PGWgwclH2AKV3jkw
w/1Qr7LrTmkSmc5qbPdnemA16DwXAr88SdL4r/PpdXIP4YOvOUP62McWESYL
lxHBkYXVt3DsEcByXKGeX3Z22vI8COJi/zs34THCNnE5KYEFuYpW/xsBYALC
fjy5h1D6WWoNF8f++OQEAUioROWrU9s54eOx8zofxFf1DHHKs5JqrZ6r9jCC
t6Iq/dxArWWQaUY9gTvmrrEijb92hC29E559YfAEIQhc5jydNQQytFCMF6UE
FgQWBiKlzMx6Bfz94RFcypmlP+z+wB3ws+EuubSR6c5oAndWNrYfStR+3lCo
7rB4FB2Ca8S6DR/kqLbJDj/8wqXZ4Mrhy4VEy+HnszOIXfaZiEyd+7Nyfa+u
2adzeDOqUqDUd4J/4AP42ZL5NLnaXUN17+ADXF92M/A4CAYDtKsoywe8sLG1
Kyk2QaUH3N/nlfgCozunC4Y1wUcZvcW1t09TWDa0InAELlBzz4TXP1Gerft/
ZTori04iUIbQgSExCkb9dM4t0PBweHArAm5wPsXqxjtYFmpvnStJr8Jr8SiL
ldbCNEEI4LH42qvrzN8rM1M/w5uCe8N0++3KxrvIrLrEYtPWO2HLswQTRDrF
mk7YU6ZevdrU716Uic03jnhrrJBf1caurD2BO3BafJUOU9Tb3DlyEApGidmf
Pn0ytI3gyJe1xdLE3DqcmQxZ8/YuXa8PhgDRGdVbpKbJ7tlayL139bFzlpu3
PBACU56l1iyseMk1jc6rp1K1hyeXETjQT11be7MTla2XFDUItPvgnPDx+KTG
7JwNqG2y06yWaR9fwp3EB3Fjb0b9YUENxymt6UJIcvs145KGBB4p1/5oJXRt
07n6j+fl8mk/wuEPS621j9HqToVPuSaLFHQyky8HkHd4PqEJKppdqDJklvq2
kXJt919+leSeWIaZ+OZ52e1oOfxJmOOCqvYg1MAknKXPseDZ9LmkugvPYmhi
KSrHuSGxqXuM5jwqZT4yK5qDbw6OPh7vHXxAsI9/Dw6PMJCgqCGYQUv2m5rf
eJVdB2voZwERfiPipt7huUcSNUb+z75Ods8nwC7gN+4XSVIVCyoxye0CITDE
47gWKUsoakiTWv72esZcoN06CDoQgPOYuUpd1fL6NrzrzoEZQ+uwXN+bp2xL
kzZJik3RuYbwdC1Ody9OiSvH1X4fIYWvghd8jJtRlbBo117Kfhcu/fZFOf6K
f/HzrahKuOsRmbqEwgYILL6mKyAaggmzDs5CkOGoc0xBx6XCQMBMeNUGA6ML
uAz3gP/F7ewX6VrqT5RdoF6uTHiyo000Xufo3bs4KVmgXl/cyPRfpQeK19g+
EhKjqDbb2e1JfLf7fnx2DSG23NCLIYog5VGiGmMbQxe+GcYtRAB/ghfXPTjb
P7oA6YDuXVh9u761i8++PzwKWGEeFwkbgXduvt2bX95yTK9CObf0TkDEVA19
ZbXdGL2wfYiFIUFw8KDhsyqacdLGrrGB0UWc64D2DCqkCUo+JFquNg2clSyc
97vwcure/uZp8Rc3s6gi4Z6ywDHlg8CRupYh99qBWxa+elbyN9+leSbvnWqa
OTm/Dv2MUUQzwRgfX1x72zsyr2seLFC1w6OADoccRecZijSd+tZh28g8jokQ
UsStvpCvmaVNDEhICu5JankTviPMDWREUtRQUdfTapvEG/xbEBhKfEGYrbOr
KpBoylrh9Xc3Mu0uS+qWBV91AwhBA/Hyg/jfb+Qs0nT83ijczPJsTDa1sIFQ
gvoZnnmhugMf8V8fDAp5aW27zTYF3RuZVQfXJSy1JkPWXGXswyCBjy10Kzce
wfCGH4WwF8HUyywdLMiTJA2+i6ZxADfBqzaYXXoDMYcv1z006/n7jv5p6g7/
/FYW1SOJkgXIiNcJPUKQgS9EJYxRsvDV0xI8KXd6xsTcOnQ41TIJ3gWUJFwI
r3Md+Ajcb7nBFptfD2cejkd+VZupcxSOzdlezBcXiDniC0gBZAESgQGPaAU/
QFhOfVN4j3/1VdK1COnwxB9KIsMnxE3+8nHRl4+LcShKFvwUoSIEE/i31OpP
kctH+oc7ue42rHCwodKpEDW51Aw7fqrRM7QiItCsyhb4yaESFdx+OF1w7Om7
2ZcAGA4oAZnOSlnA2Hwj7ifiZah65/0Myflf36YiLnZvajN3jeH3v3xYiEgN
sgA37Fztabr0QD/7yoGcW37zNNmZFQZZQFj3L/fzqcmQoYll+APuyO71D31G
4Fd32WfwZgz+0AQV3OPOgRl2tX8vH4gmoApqm+wIph4laahb99uw0r8PyYHn
GZldRzWhNnY4fv2kGDEIbIfXZX0E+zA9CK8q9T15yjYcDe4ZLDj+jXbtRU0p
M0u1VnP3GPw3vDnoX/QCky61XI+U4e55nfSD1oLCx/D+1aNCePifXfVSYAvc
gvD1s5J/upuLH+ASQI9B/zd1j1FrcwRfpJaZPdcOIBH/eDcXqiaxyAT9I9P1
/PO1V99ev9PS4rTC0DMjUytKY5+k2IQ7jIgsTdoENwxSA1WDAY+PwDfDv4i2
YK+hqaDf8LDwfjy++3FVeHwI/EnWN8Xe/uHE3Jp9fAl6G4YYWqWuZRiqAyFb
flU79US+Cy+HG7+49tbzg1A+WssgXJ3fPC2BxYdGoubD8b9/fzsbJv6vv0mF
jUDUPL24EYRemZeARpcjdPb1dVjprx4W/uZJcXKO9I//7C9uPo7Dv0+iczD+
o3MN8DAHx5dYuEwI1vDEU8ubcJwMmUW4GvvnFkRquHXwTpNLG6FJEOTCWU0p
NcOqlmut0Cqqhn6pzlpQ1Q5X9tRDgdaC4FDHqVTp/vJvf3XtcZJc3ws5+upZ
6T/eyYUSg2V/lV3X3jd1pfx/Xphf3ppe3MQLTpHzNb/+wws/byCa+OXXNyAI
JbU9+Pc3396in+nnHwwJRHDPUmsiMrTcixicf44+HmPE5ihaqcEP5Y976yf/
AfeZCoHPvpwz/OWqP/3zn1IKKrtI8U1YKWQhT9HaP7pACnvyC0ItS884nH88
uNySKuq249+2tjbezwW36nWOM0/yshaZeX94pG8dvhenhDVs6Z2gaUyz5S1w
/mE4EHnBgsBMKOqd3Tk7Bqbhdt65/9itoH538x5CP3Erd10+NrZ2je0jMXn1
t6IqYbJ7R+apBTt1rSE8PKKzU6gtPPBmEZiHRMuDU6U2aByfnNQ0OZf44e2f
mtgMiP/t9ngWbgXVYDIjHHNnC1Cvb1+U44Vf4lVOu9fzFQfPa2JuvcZsh69y
N1ZZUt0JteOZ/Q61Ri23CQ3Vh6WkuutyBHoLK1vh6VrEtgIlgsJGP38R/uuQ
WGoWYmH1bXyB8axDhWu4TKtmQoBbZ2x3pJSZ4QUh1EIoh6DM6yCEXYaYBOeq
PhwdwyvA6S66xdc181PMLSC5ilbPHdAw5Q9dOcbuV1yBsbbJDieK5Nh7AhcI
9w1KPiRG8TSlGqbTNjLv3xZDpWBwwtcN2kVCCiTFplw+6n+KhdzQCydfuK6s
nmDwn9qwAH2Cwe+OuxGwQ9EhWsdvIrPqZDqrdXD2Mu1opgm8ffg/CAFyFK1P
kjT346oKVO0d/dP0a3202iap+W1Br/MURx+PYaoMrcPBPClfFGk6onMNTAsv
sAbKCpb97Om2tvfx0PHs3OVV8c6p+XVY+QxZ850YBcwHohjcZLjEF7f2ix/g
5+O7U6UqXqTXXnspe52jl2qtHQPTLDYpw2V6llpDqZcgL43tHXyAPXLPpV8U
GrvGYEMF7dZ0FgRZvmpBQxP66vq39mYHWrFS3wMrjDjx9ms5vCmpzmrpGZ+a
37hwDhXcidWNdwOji5BupzrKq78eKUOs5Oyt0zMOoeDodcODcrudPPZ9oElL
76SvGk3nE0gunE9e6p8zAgOYezvC3f1DxBQ4DgZSVI4eA+lRojq1zDlDVdcy
1D04CwE5J+YDKhr+J8S8pXdCUW9Lk1rg8H8fIYXnk1Jqlut7EQhMzq/zq5Gi
svVuWQh+yX2qHOiQR+rseebg8MhlyEQowNtmm4S3w+8xMd5gOAYnlpq6x5T1
NrhbcPzgY1NDTlLUAMdDaxk0dY7CuNjHFjH2oC23dw+4z1kh3oET8mZ7Dx5d
n2MBF6BpHIB6xzhHFAazC48d/0LzF6o7IKd4D04t6FwZBr/ndAQCLuHO5QsY
Jv/N2c8P0Kj+i5MLx8LqW/9bO3kEQw4yAguCQLKmyY5IHGII8xGdZwhLrcEQ
hbDAplCTgQjVoU4xaBG5xxc2QIISi03JpY14f5q0CWELfgMfHs68525oOPYw
r7BK+FO61ALDVNtkh5MAiYOrA9sU/DnGpJJGT1nw0zJYOGDmEBie/7waBPt4
lBiTopwdOhyjKMhBih9wJRixS2vbCFWcuT3zGzCXY7NrkKDhyeXB8SWM6v7R
Bfj2zt3QCxuLawx2QwcfXBUCcIjh83RtjdkOMVebBkS5EmgP/00HzgNQkuJ2
cnwoUZN8eKEJTVAhGIRoeK0nGQQgkmU13aKcmj5wp9tsUyJewKvsOnYFpQn0
uRVVKW4fCphU1k0EggPc19uv5Xyl77Ijpcwc5D7LVxDE7OK6cKsb76jNjOcW
uLt0ugALSkFV+/n3JC86CMqCtoTqFVdPjeBlgLAAAaCkSOR1EKWxz3+7SQJ3
qHhBxAt4s73nvzGT6HQMTPM+vc8UqdYqykTflQLW/9Q22yCzsvEuLFVkD8Q/
ps5Rub5X3Gsoqe66rK0Tzg+x+UZR1lLd4Oxnu7GfKzoHZvKUItsFXMBV2Ccr
Lhkyi21kXsQLqG8bqajrEfECAjI4seRuDiUWWZUtvaI+pqtATZNdrFU2CmeD
7/PdVnV26Q1VrVFE4guMYz5SVQl80edYSC1vEvECEDivetSOPoecnHy6Hiny
bNu9OOU5SSK9xGxs7YZKVGKdHbouIlMn1tnpA7U8PClaPi3EEMIo1tmvDp8+
fboVVSlWsfGS6s4LsbtNberHS6yzzyxtiu6kXRFyFK2izNcdfvh4J0Z5IZpL
rr3ZuROjEKteQZttUvSJrCuCdXA2pdQc/PMiZnd30zj/xBUYEVuJcurMiguQ
yns5gDvqdXe5oOztH95+Lb8QRoGivW9KlBxCGCM8HdILIGiklpmDPLFZVttN
1VG/KGBMPk+rtfPXGZMmE3PrJFgIJmMzq0+Tq4OWsDo4vvQoUX3hSjHYxxZf
pNcGOWqoqOupIf2Fg0t0riE4K5v7753VYC5oLfr4AqOpk2tJCvrgXt2KqgxO
UTKCm97huVfZgtvi45OThMIGZb1N6BMJxNa7/TsxSl8liXjH0DpcoGoPzrkI
nkiKGgxtI4KeAhYhqzIYdYyFA0rjSZImCA4enDF4ktNka6cYvNneg9JbESwj
olDdcTOq0rPE9wVFqrNKik1CV7dWNfRf6KqzF52GjlEEDkIMVwgCjnxpespk
y1syZM3CxdFLa9vQSyRSEJdiTSe/Su/g8EhrGUwubfxwdEkE4bMr8MFdisjU
CWEdPn36FJNXz71uJIEjeBBw6fkSh8n59YcSdWlN10VvuOAVmIZX2XX8LlPi
/uOwJOninEC1SPjmeRmXdWFElzVN9ntxyuCvTwUTtan/aUr1zBJvEW5WRXN0
noG02jlXGDscd2IU7Ha9NXU7a7NDuV0Fj7d7cPZurFLV0MdxsRLBVHZly/O0
2nNYaJEwvbgJH+BFeu3A6CKd929s7apNAw/iq5JKGsWqPioKu/uHGTJLeLqW
9Xolbh1udX5V26WZXrh8QEcNji9FZetDYhR4Ur3DcxjkO3vvqT/t7R/iIWIA
yPW90Xn1d2KU+IFpR8tLw8DoAsYzJKLPMU/fyUG4IdVZb7+Wk2D5orC1vW/p
GU+XOrUfxvz1SNm3L8pDouWPkzRpUktdy9DE3PolWDvgjn1sMb6wAWO7SNPp
mFrx1fAIQVmfYwFuJO5hpb5nj2SiXlhIcOef7d0DBFxxBcZbUZUPJWp4UDmK
1iJNh0xnTS5tfJZac+NVhaTYZLGOX8E+g4Qry/rWLkwAQuxW26S5e8w+vrS8
vn3h0nQJBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFA
IBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBI78f+zDuz0=
              "], {{0, 259}, {
              260, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {260, 259}, 
            PlotRange -> {{0, 260}, {0, 259}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0e406cfb-dcdb-4a94-b18c-b27c2893a46b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6c360ace-d809-4e54-ad40-b844648cd709"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"505f193c-e14c-45d0-b483-1f3da1baf0cc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"48feebe8-098d-48dd-9de0-205daed1aacb"],

Cell["\<\
Make a table of undirected graphs with between 2 and 10 nodes in which every \
node is connected.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"a1929c6f-74c8-42d8-a3bf-0066d2798ab8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e2ccecb1-3e3e-467c-9801-4c3398760d0d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvflXW1mW7+nu/qV/7H+hf+7V+V5VVk4RGYMjojJf1steWZXVL7uqOmt1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            "], {{0, 1013}, {
            382, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{382, 1013},
          PlotRange->{{0, 382}, {0, 1013}}]], "ExerciseOutput",
         ImageSize->{386, 1013},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4411744b-e8a7-4b03-adc1-b9f6aeeb00da"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvflXW1mW7+nu/qV/7H+hf+7V+V5VVk4RGYMjojJf1steWZXVL7uqOmt1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              "], {{0, 
              1013}, {382, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {382, 1013}, 
            PlotRange -> {{0, 382}, {0, 1013}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4ea0c7dd-164a-4b05-b1bb-b62be730d5d7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"cb21d269-b17d-4082-b249-1a24acc6bd21"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0722b236-0450-400b-aa06-5820b2184ce7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c85b3c95-95d7-4b1c-babe-c91e6c6248f3"],

Cell[TextData[{
 "Use ",
 StyleBox["Table",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Flatten",
  FontFamily->"Source Sans Pro"],
 " to get ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2"}], "}"}]], 
  "InlineCode",ExpressionUUID->"602ae94f-d1bc-4898-ad17-9c7c9ed4022a"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"64ec729f-7af6-4e7a-bdd1-f753a34370c2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"453cbae3-a2cf-4923-9b9e-9b3e80a0f274"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztViFv3DAUtjZSOGm/YH8guNRw6KZOZUda7VKN3KLrpCk0zDDMLCgoKCgo
pMjExMTE4IjJgYAQg4Du2blr2vWSrKg+6T4pkWN/74ue897nfLn9dRV+QAjd
X8Dt6uYP3mxu4u+f4OF6ff/zbr368XX9e3W32lzefoTJz3B9g8uOH88444zT
RlORMAgiYfrHVgmxbbupiFazqiyKksndnPi7q7V5iPEyYbt9VCsoGFdISt09
qiJGDoQ1Y3qNKALH6e9RIceYfqh1ssqWMEPYPl+eIpT233Zb50m0ACblo5oq
h2iiXWge2vePfRV/1GS2QEHahxlh822HIAmi6bgmSDWHimoYQQizdpzrh5qg
GAW0F7Z7csjdwnA8ozmAp8BN9ATDDzXpcoR8G1VHsAuH2n6TZrctbePnox3n
j1qnClvcpSSuuevnAv+p2TBoFbTMp6rPIzVDnYV1jUxgkNTDSidsj4jJN++Y
NQOczp4fnqgZmcFcxmx1qwI2o+9fA6ebeLBLcf4ghdDG2nkcIJxU5ilW10vn
9rTmgnPGmGq61zSP1PYeRXva4M+GL9ALpLyFZasQDAYu6D8sdyC+onmk9tKf
3flLJkrEFsCBPAGfaRLyxXtaX9s4pNtjv2m6Av9GuZixCI9phmWxa2g+zOQk
DBNpjrC7Vit9bOFkaKYiUZRkarYIzjh9/AWPhpP+
            "], {{0, 19}, {80, 0}}, {
            0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{80, 19},
          PlotRange->{{0, 80}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{84, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4400e79d-0d0a-45b9-9398-4ac7dae88c2c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztViFv3DAUtjZSOGm/YH8guNRw6KZOZUda7VKN3KLrpCk0zDDMLCgoKCgo
pMjExMTE4IjJgYAQg4Du2blr2vWSrKg+6T4pkWN/74ue897nfLn9dRV+QAjd
X8Dt6uYP3mxu4u+f4OF6ff/zbr368XX9e3W32lzefoTJz3B9g8uOH88444zT
RlORMAgiYfrHVgmxbbupiFazqiyKksndnPi7q7V5iPEyYbt9VCsoGFdISt09
qiJGDoQ1Y3qNKALH6e9RIceYfqh1ssqWMEPYPl+eIpT233Zb50m0ACblo5oq
h2iiXWge2vePfRV/1GS2QEHahxlh822HIAmi6bgmSDWHimoYQQizdpzrh5qg
GAW0F7Z7csjdwnA8ozmAp8BN9ATDDzXpcoR8G1VHsAuH2n6TZrctbePnox3n
j1qnClvcpSSuuevnAv+p2TBoFbTMp6rPIzVDnYV1jUxgkNTDSidsj4jJN++Y
NQOczp4fnqgZmcFcxmx1qwI2o+9fA6ebeLBLcf4ghdDG2nkcIJxU5ilW10vn
9rTmgnPGmGq61zSP1PYeRXva4M+GL9ALpLyFZasQDAYu6D8sdyC+onmk9tKf
3flLJkrEFsCBPAGfaRLyxXtaX9s4pNtjv2m6Av9GuZixCI9phmWxa2g+zOQk
DBNpjrC7Vit9bOFkaKYiUZRkarYIzjh9/AWPhpP+
              "], {{0, 19}, {80, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {80, 19}, 
            PlotRange -> {{0, 80}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8b12dab8-916c-464f-8072-30f9ff76ca76"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"cccbdfa6-fc72-4774-a002-c68c2b0f4917"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9df18237-1321-4572-a58b-46de6d20ee32"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3a43c240-67cf-4ce9-96f7-383b9ac09802"],

Cell["\<\
Make a line plot of the result of concatenating all digits of all integers \
from 1 to 100 (i.e. ..., 8, 9, 1, 0, 1, 1, 1, 2, ...).\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"8f175146-9cac-46d0-a178-58519f66fc78"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"69f77fdd-d42c-49aa-a4e6-e2d37a515c89"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvdeXXtXV7vl1n5tz2f9C/xfnti/79vTo2y0bZAH+QNjwGWwENsgKICyS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            "], {{0, 259}, {400, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{400, 259},
          PlotRange->{{0, 400}, {0, 259}}]], "ExerciseOutput",
         ImageSize->{404, 259},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0d15a4b8-4525-4aa8-a6ae-dc010c71db82"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvdeXXtXV7vl1n5tz2f9C/xfnti/79vTo2y0bZAH+QNjwGWwENsgKICyS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              "], {{0, 259}, {400, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {400, 259}, 
            PlotRange -> {{0, 400}, {0, 259}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"43dba0cf-245c-4989-b66c-061b4d1c7aea"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"81e87d48-6d04-4bac-bec8-fbb0d85c4919"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"181883af-de21-475c-954b-6f7b4ea774e3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0ceec593-c16d-47a1-8f36-98b4ba6cdaf3"],

Cell[TextData[{
 "Make a graph with 50 nodes, in which node ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"4918ffc6-2470-4cd5-bb3b-d46a8374f76a"],
 " connects to node ",
 Cell[BoxData[
  RowBox[{"i", "+", "1"}]], "InlineCode",ExpressionUUID->
  "4a8c6ffd-0121-4084-b5fe-60bf5c205963"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"f918e7b6-2c63-46e0-b097-96c31d9d4d01"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"baaeef24-32ff-4e2d-8029-c8c18f3b852b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3OlfU2efx/HOzJN5OP/C/BPe86r3gzq3zr21UCWoLYsKaN1YZBWkglg3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            "], {{0, 311}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 311},
          PlotRange->{{0, 360}, {0, 311}}]], "ExerciseOutput",
         ImageSize->{364, 311},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4fa5070a-aac9-4347-8f3f-2ed57c4b08fb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3OlfU2efx/HOzJN5OP/C/BPe86r3gzq3zr21UCWoLYsKaN1YZBWkglg3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              "], {{0, 311}, {
              360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 311}, 
            PlotRange -> {{0, 360}, {0, 311}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9abfd50e-6720-447a-ac58-ca751c9292a2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7222db69-c06e-4b23-8a55-ebc2282b3d31"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c8916e9d-2c28-43a9-9117-929e79006143"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c3639bbf-4111-4399-be3a-a679a5edc514"],

Cell[TextData[{
 "Make a graph with 4 nodes, in which each connection connects ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"929c026b-c091-49a4-ab43-3b82694f34e8"],
 " to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Max",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{"i", ",", "j"}], "]"}]], "InlineCode",ExpressionUUID->
  "b20f385c-de43-48a7-9bf1-cf7ee0fedf16"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"f0054003-cdcc-43c9-869a-c4bf30667048"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"154b1916-e124-4d14-8e70-d8f4647cf468"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnWlXG1maoGtmvszH+QvzG2bqTNeHnjp9pk/PVOVMdVZ2VZ+sOVXVmTlV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            "], {{0, 352}, {228, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{228, 352},
          PlotRange->{{0, 228}, {0, 352}}]], "ExerciseOutput",
         ImageSize->{232, 352},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ec3374e8-3409-4446-8e9e-026013dfecfc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnWlXG1maoGtmvszH+QvzG2bqTNeHnjp9pk/PVOVMdVZ2VZ+sOVXVmTlV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              "], {{0, 352}, {228, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {228, 352}, 
            PlotRange -> {{0, 228}, {0, 352}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9f782521-3811-4ce7-aa1c-b4bbb5da4b0b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"66b86e10-c6a1-49fb-8589-efecafeeb3b7"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c224e59c-95c6-48f4-93df-58d0e69e0d38"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"18ad950e-2498-461c-bde5-44eaa6c4035a"],

Cell[TextData[{
 "Make a graph in which each connection connects ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"b10e0623-1e8b-4692-bc3e-e9005a18a0ce"],
 " to ",
 Cell[BoxData[
  RowBox[{"j", "-", "i"}]], "InlineCode",ExpressionUUID->
  "115bc689-2069-4c8d-ad34-9fb3f51a984c"],
 ", where ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"f826e0ef-8783-4a06-8c33-11f010ea28d4"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"bb418a54-b3b8-4e82-9027-c8c5984282a3"],
 " both range from 1 to 5."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"4be47b01-9e97-4a8f-ac6c-1466f71081d0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"58203f43-c099-4447-ad2a-87ae482645cf"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvWlXW2mW71mre61e/bK/Qn+FftG3emXdupGxKm6GKyMqI1zpqCxHZea1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            "], {{0, 240}, {518, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{518, 240},
          PlotRange->{{0, 518}, {0, 240}}]], "ExerciseOutput",
         ImageSize->{522, 240},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "547e349e-d8cd-447e-9d4a-0d512dd74bd1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvWlXW2mW71mre61e/bK/Qn+FftG3emXdupGxKm6GKyMqI1zpqCxHZea1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              "], {{0, 240}, {518, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {518, 240}, 
            PlotRange -> {{0, 518}, {0, 240}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b81f7fc9-43ca-43a1-a9f5-e470d21149b8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"15f598e5-cc3c-4e79-a577-9e7e5cc1f7f0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3c262889-892f-4b02-bb84-ffe04097b12a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d271b713-aa05-480d-8355-c3d360effe40"],

Cell["\<\
Generate a graph with 100 nodes, each with a connection going to one randomly \
chosen node.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"df1b32df-a199-486f-8262-cb8d613b3614"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"83ff727f-2691-42f7-af87-6eb4cff744d1"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3flbXNed5/F+Zn6ZH+cv6MnMM8/Tk+lOu9OJLNnOxE66O+mkO90dp520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            "], {{0, 544}, {542, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{542, 544},
          PlotRange->{{0, 542}, {0, 544}}]], "ExerciseOutput",
         ImageSize->{546, 544},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "27c387d9-bbf3-4df9-bd86-c2f4eab08b36"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3flbXNed5/F+Zn6ZH+cv6MnMM8/Tk+lOu9OJLNnOxE66O+mkO90dp520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              "], {{0, 544}, {542, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {542, 544}, 
            PlotRange -> {{0, 542}, {0, 544}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1adc1528-cdd1-4bac-bf4c-3d74820ad714"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0197c388-f9c7-482d-b2fe-abac9383bcba"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5c9c1bcf-24ad-43aa-a0e3-9cda895f0a1b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c8398419-98f6-4853-9a4f-b34806dcc174"],

Cell["\<\
Generate a graph with 100 nodes, each connecting to two randomly chosen nodes.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"99c082d6-e282-477e-9f32-590d26ebfc31"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f960e4d0-fca7-494d-bf10-1a9307e2faac"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsveV3XVfW7vl295f+2P9Cj3FHj3tv1VupSioxYzipVNABM7NlJlmybMkW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            "], {{0, 237}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 237},
          PlotRange->{{0, 360}, {0, 237}}]], "ExerciseOutput",
         ImageSize->{364, 237},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "34fcf330-fb3b-4352-a8ef-25ab8dc87e47"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsveV3XVfW7vl295f+2P9Cj3FHj3tv1VupSioxYzipVNABM7NlJlmybMkW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              "], {{0, 237}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 237}, 
            PlotRange -> {{0, 360}, {0, 237}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9ee2ebf9-30bc-4e7a-8972-f05320159dd6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f971e6d1-372f-419d-ade0-437447f67fcd"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"35e06e69-902f-4530-b74b-6ce074028c0c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"41b1d2ae-99e3-41f7-90f9-d5b4510c8e14"],

Cell[TextData[{
 "For the graph ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", 
     StyleBox["\[Rule]",
      FontFamily->"Source Sans Pro"], "2"}], ",", 
    RowBox[{"2", 
     StyleBox["\[Rule]",
      FontFamily->"Source Sans Pro"], "3"}], ",", 
    RowBox[{"3", 
     StyleBox["\[Rule]",
      FontFamily->"Source Sans Pro"], "4"}], ",", 
    RowBox[{"4", 
     StyleBox["\[Rule]",
      FontFamily->"Source Sans Pro"], "1"}], ",", 
    RowBox[{"3", 
     StyleBox["\[Rule]",
      FontFamily->"Source Sans Pro"], "1"}], ",", 
    RowBox[{"2", 
     StyleBox["\[Rule]",
      FontFamily->"Source Sans Pro"], "2"}]}], "}"}]], "InlineCode",
  ExpressionUUID->"1b29f8ea-978d-47ad-a5e8-b5d55761c987"],
 ", make a grid giving the shortest paths between every pair of nodes, with \
the start node as row and end node as column."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"285cf00e-3faf-4a46-8141-64be4d942d2a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"772708fa-0fb7-42fc-93d3-3ebed10dea50"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztna+P40YUx62WFPZf6D8QXGp4KNJVZSF36uVUco2ulaqlYYZmZkFBQUFB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            "], {{0, 73}, {220, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{220, 73},
          PlotRange->{{0, 220}, {0, 73}}]], "ExerciseOutput",
         ImageSize->{224, 73},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0db27104-73e9-4a58-b22d-3061afaa00cc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztna+P40YUx62WFPZf6D8QXGp4KNJVZSF36uVUco2ulaqlYYZmZkFBQUFB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              "], {{0, 73}, {220, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {220, 73}, 
            PlotRange -> {{0, 220}, {0, 73}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ebfa9eee-48fc-42c4-9cf5-fe78be94e89e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["21.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ade8da4e-f02b-458c-a80e-e4753c2007b1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4b1a64af-7e55-42b1-a2a4-1ce0d722d3c5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a1f7bef0-3d09-4371-9735-3b0c7f9dc326"],

Cell["\<\
Make a graph with 4 nodes in which every node is connected, displaying the \
resulting graph with radial drawing.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"eb56cf56-5c59-410d-9fd3-2bc34872aa12"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"480a1a17-4baa-463d-9295-40edad1c21c7"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndlfI0e253tmXuZx/oV5nqf5zOfemenp7d7u2/e2u9193V66b7ervbft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            "], {{0, 313}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 313},
          PlotRange->{{0, 360}, {0, 313}}]], "ExerciseOutput",
         ImageSize->{364, 313},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "50f232f4-febc-4a43-9fe4-0807b8b2a98c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndlfI0e253tmXuZx/oV5nqf5zOfemenp7d7u2/e2u9193V66b7ervbft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              "], {{0, 313}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 313}, 
            PlotRange -> {{0, 360}, {0, 313}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"567fb75c-5a04-4731-839b-62962fa17aeb"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x21.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8a3c9316-ef63-489f-ad36-b56fcae79b56"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"acb16076-3252-4585-ad45-d342e877a91b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f53b5087-3af9-4dd8-81cb-1b19cf11ecb6"],

Cell["\<\
Generate a graph in which a single node is connected to 10 others.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"e306414c-ba77-419f-b458-c4c0108331fa"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cc5872dd-21d0-4ba0-9474-283dc04ed686"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnfdbVFcax93dX/bH/Rf2T9jn2X2e7dlskBhXN6tJiElUmthCwIhRgy0q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            "], {{0, 59}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 59},
          PlotRange->{{0, 360}, {0, 59}}]], "ExerciseOutput",
         ImageSize->{364, 59},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "00c2cf7d-cd31-4f01-841d-828b237ad377"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnfdbVFcax93dX/bH/Rf2T9jn2X2e7dlskBhXN6tJiElUmthCwIhRgy0q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              "], {{0, 59}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 59}, 
            PlotRange -> {{0, 360}, {0, 59}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"200fd071-5efe-4d97-8c61-7aa728d6fad4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x21.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3822c27d-9328-4cbf-a9b4-15dbd4268b5f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"03c7cd8c-c538-46e6-a822-42d8d24e9acf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"db6279d5-e40c-462e-9746-d49c1f95c08f"],

Cell[TextData[{
 "Use ",
 StyleBox["Flatten",
  FontFamily->"Source Sans Pro"],
 " to generate a table of the numbers 1 to 50 in which even numbers are \
colored red."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"db004cfc-b828-4792-b2a7-6442f47fcb2c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e0542576-3e58-4073-be37-6cd2dbecd7de"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXb/L7UgZjtpY+i/YWqS2TWkVWLE7zS7uWWzWw64gp02XMl0KIVVsTiER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            "], {{0, 42}, {491, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{491, 42},
          PlotRange->{{0, 491}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{495, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e0d18b0a-dc16-46a1-b7d6-513ba4f05fde"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXb/L7UgZjtpY+i/YWqS2TWkVWLE7zS7uWWzWw64gp02XMl0KIVVsTiER
IVUQAkKagEYkFkGCkCZCFrJFihRjZibn5Nc7k3fu3U/36jx89+Oc72TyZN55
5p0fyT3PDz/55UfX7xqG8eX3p18fffxr64svPr7/9AfTm599/uUvPvv805//
5PNfffrZp1/8+JPvTX/80fTvX98xDPqaaGhoaGhoaGhoaGhoaGhoaGhoaGho
aPwvo4vdq2neioG/7auiqPtRVqJvSByRR0TKVnbY0GZJ9IjirGwwl0HynHSD
4NOxKYsFZS06jp2pppcXxaSFjxrautiiFhxJUWTk8SBZKb34Pp9q+ojzupMe
Ro8kRUHW4R1bEj9oMBtZnXjZY9OM3VSXqj8rCfDWBa1XlJBO2tYQb98UMW3Y
tJLETcTL0VYkL8kJ846Xvl0k0MgrDfGWOa1ykivxttVOLKW0cxzbtyNpTNsX
oY1dnMeu4h3orK5Qf0Tqqm+yqS0fUbbtyyhdgbxIXUG8WF1J8s+prgBetK5E
vFhdvQn6wjcM4+pGzUiqx91gcDOx2IoHMYzl5wFntrFJbHYqk/223fSkcp5N
z+Zmosv0+IlmWLkozGW4ubwSUELhWcYWppdD5xqIa9GT2Oz3LYIZx9pl5zPZ
Fd7jWljHx32+qiW8NbFeV2uSSqhbqGmG6MYrYmbynnbkDa70rWmyv1ukETbO
gXfMg9uqYY2gEEsFqO+z1ry+4ssG6jvkm2YTSkXA619WwriL+tqBdyc8WvFU
dNlH3qGca8pbORFq41jfoXyYqw6UtoIrhvsjSlddwSlmjttcFqcrkBenK4gX
rStZ/jnRFVxfpK5EvDhdvR363DMMjzdwnYTOjeZdPxf3ynC6YJcXJVfj+XqP
sYkt06lYdRKa4CyZGKpncHwwkVIu3zLsoJhOzCA6Ucd0eycDe+36BFbuOA7z
WYpgqq8NDwd9xjodWz5knkgYTUK73oNWdYzukzRuwl6ahOTGxqlXeBPW5WlZ
pr2rYIyAm2ZIAvd+NYXXL+QdaJR4qDtWR3j8gnnL4Gp7TORjRWt+T9C8T8ya
tyUJ/Mg7NtGkIprHRrkGIN4mZtODlL1OiZ/ieZ90E1/jTsG+PoSj7JE392ge
4+/uU2bz0LxDOL0zXSq+vrhOLx3BNYP9EaerKrxMCYvpuw+vNHmxmSVOVwAv
VlcgL1ZXkvxzpiuQF6srkBetq7fDUNAEvqpxOQnHkyTw6fpfq7zMpfo8W8B3
qSNN4A0xDWJd6G9hJmndSdvl2fDWRGz+g9hR4BjLqUUvoWB7pM/p2VIWirEQ
JfB8ms+b3hyvJqaTh1JyAeWqg4/kNlXcnz+hCrkKRpy57LFpxjKQrUdg3qlq
r5P08gQu4uVlp0aZwidd7pb7BM4H6/tdnsCPvGymYRfYGc6W9zHNDC/o2RFc
345egBGfbAeWhwTuzK9pUhUm8AMvnbG8FoZlMOnUETAf+yNeV333LNtl7rqT
InQF5QGsroS8/FOprgT5B6UrgBetK4hXTVdvAjoqvfIPmRcU0gS+gmct+oTQ
t02RPibxGddQGNSAjZt1Q2xxi/c5nZ2Yl9v16nhhKVpO0v5ik7IkQUDC+HR3
t35Mw/C1Eh7Vkss0a7qSsmZrQ3h9RBO44c7x6tKT6A35qoP3mzGr8E9GQ6hp
2A4YIoFveNdozhP4kXfs27pKAjZRiioV3pZWeZqI9sX50L/l5Xt9kwRut7v/
OBukN7wsoTkJKRPi+ySWj1aiLkAzqmy5AfA+Z2i3kDQFnZ260hnahrfzzSWB
N4l8CvTE3B8VdcXAZLyMEVhdbXjXQOjqyIvX1Z5XRVdbXjVdbXgVdfUG6Krk
NrXTetsHn8BrNt0VTV8pmOYZhCfkJ+HTGrr+EpxtrBzLvLpBHId0bWfY8CY9
1Srbirk7tEGnppTdZa0nobBtGTGi27LBFcKKGqqQCcDxfYfvrfkS3e8SuPXf
TuB09DQle+AgL5u0cNygmwxiXkrHJ0iso8kH2C3vUD0sw/YeUcQ6uGwrY8/b
07kBX1w7rEHtQKm+hArwQTfK6rPJ1j7O/WYvWnrPf8eb+3TOcnN9z7mwUF9O
Wnnpj4q6ordxIjbJWnqfQgIH8wBGVwdeBV3teJV0teVV0xXZxllJV28Al+3o
J2upIhM43+O6hKcU49DGHlVgBIj/GQHXI54zh0J8o+dJnZqi26w8gc9T6oq+
luRntt0Riu8bTgtXeoaiJX1F7mxvU9B/uyr1nPvd8dMsotPxD2UGnrj0j6dT
HVgSY9/kdMSyfBn5mpcrf2pi35sFf3eJ5HkisRTr6HYyIz0OlJdg/uid4izd
xBDxEuKYxHTJMJIyZlNE2XL1wDsUcTjJapq25IlLd6QlmWXTHxV11WUXtmWx
PgSrKzAPIHUF8WJ1teZV1RXMy890pqtdnJV09QYYu5LGylktDMeCbsQV0uto
WS0s+YbesERwLCw45Q4k9Onqw5sSuMvmzDZJwQS+urfQZ8IkSWNokueaW7qp
Tup4GnAvhaRTBPZqYdhhloQDm0JEkokH3UufBgUeXr5XGcwfhVe6VymZPEBN
M5Sso51OVza8DLyXyRcgEO+4atiWxlAq+DVvm9OG5s3tIjranncJTXu6pbCr
77Tmfe0J14+TjgbEuaf3uu/x+WbnhrejCnwt3ApPnXcGvU9uBcJI7fujiq7a
jN7Ns7zd4gClKzAPIHV14FXQ1Y5XSVcAL1pXx/oq6eptUNEtar4HPtDnIdOA
bkCFaVkU9AHSsbybhuXESziaZF4SJjl9cjvL6Fbz4bB4GsrMe1I2XVtHrj3P
dY9nWzCyLRTW7ofD2MDoZFXT1jmbzptxA5DOO28Xn7Tt/ExX2YtI2c3H1Sh/
PCxhi4KooGNRyub2WXs8bGzT28VJy7rKH2zRG43g2abRqihIymb1YUpfD88l
w0RRsajyJw2gssemmWYqRVGmIQ10kOZF2SjwRny9c6Nv84xkBe3gGN6v6W1f
231UbddU6d2iT0q0eN4l2qulLpr34sV121ZZSHfm7KDH81bs4dJw0mrFHiG4
Yev7/M8RvjV1+tXwjeIdGNeVVC0ZWuLa9IYX2Kcg3vLhXN2oauo0pEt7N21h
XrA/4nQ1NAnfnfGTvMjzLMuqbsTqCuTF6Qrgbf+K1RXIi9OViBelK5AXq6s3
xPIUypDbxgbetIIaCpYvV4+p+PayLWw8n3o9HDZM66DL6wla04srTrY/2wK2
HuED9+Gwvk7vy8VZQdYKz/aKMw1sLiEtfHuzTAMOG4l/Xc7GnxE6HDZOY/qz
oubVn3dZjmfji+v1D1+gBk8K2yPissemWW0YzjHusLz/XG3M8h82c8Dx1mmw
PDdr3VKe4/D1XT59TldQvF2Z+Auv7RTisjDvnFvYKo8/JoSrL/uA3i7ZJHAk
71A9t0kZL3+2GcdbRu7r7T3Mhbxgf8TpqvB3tHSZjNUVwPsPpK5AXqyuRPVF
6AribbG6EvFidPWWYO3lSp/RvmxmqiqHjUPfdZv/uPa+Z+sxZxtJ15HVyuh9
SCdWdraTw6Z6dv1myEWS8sKk2xyoUPaA/0zZnjbFu9b33XlHyjtstgMUeMee
NuW7lT1AoezQv2P7jkO36z9aV2/C+y3SlSoG+sCnYb2mjls0dCvECCX/204f
9h6H6bK6rC6ry74fhix0r1cHfG5n7Jvq/Ds69GHveJguq8vqsrqshoaGhoaG
hoaGhoaGhoaGhoaGhoaGhoaGhoaGhoaGhoaGhoaGhoaGhoaGhoaGhoaGhobG
/wIOVs4KVt2wZTbOqhuyrsZadQ8tSZg3fbn6FmekVffQZpyj3HwDNMqqG+RF
WnVDvFirbpCX49SqG+BFW3WLeDFW3QdeBV3B7YvTFRRnrK5mdPQr6bpniyB1
9Sxb5nndLUeidAXyInUF8WJ1BfJynOoK4EXrSsSrYAG/8CroCuRF6urAS7C6
GklZ0K9w5D/l8yu197rqw6tlXZxMZEkGXg1g5Yy26gatnHFW3aCFNNaqe/2d
hMbLygpl1T02ib3itd2UceCsukFenFU3xIu26obrS+ZaGzKrbri+SKtuES/C
qhviResK5MXpCqwvVlcveOy76eawoHT1QuYxe8C5LE5XIC9OVxAvWldwfTlO
dAXxonUl4lWxgF/xonUF8uJ0BdYXrStmXrD7FkdAV2MZU2cR8zRuK8DW1Uir
btDKGWfVDfGirbqbmLqf8Gi51hwQnFX32MSW6XBXn8S1nl/wjrPqBnixVt0g
L9aqG6wvx5lVN8iLteoGeXFW3XCckboCeXG6gnjRuuKontMS3qw4XXEMzJqN
dmZeFqkrgBerK5AXqyuwvhxnugJ5sboCeVUs4PdxRuoK5MXpCuLF6+r1Zdo0
MrOwBboqA3vjYnwOmYX0mVU3ZOWMteo+8uKtuldIHUWr7lXt0o1DB9oCfs2r
agEP8PKyCAv4LS9RsoDf8CpawG951a26j/XFWcBvedUs4Ne8Srpq6GTJujz9
npR0xbKHdbmYm28Xx+lqx6ukK5iXlz3T1YGX4HW151XR1YFXQVfC+iJ0deBV
0NWOF6+rlsazXNdNqKvCt975u2p31tVYq26Ol4W0klX3hlfRqrttSMqUdg1V
jQL7tilSalZkXBfvPKxR4IZ3jXOrboAXb9W951Ww6t7xqll1b3jVrLrBOGN1
tauviq62vCq6CtjMs26oUwPrpHhdFbQLG3HdhPZCR5C62vOucaIrmBepK4AX
q6sjr4Ku9rwKuhLFGaWrY33RujrwonXVMzcQ80KuV+KFhO60CHVVhpd3c4s4
WldjrbrJzrpaxap7y6ti1b1ioQaaSlbd/culY+PGjkrgO94Vzq26AV60VfeB
V8Gqe8+rYtV9iLOCVTccZ5yujnHG62rPi9UVlzGfwNEdDAULeC7jOysbWIbl
q1jAA7wrSHUl4kXpCuTF6QrkxeoKjDNOV5I4n+sKjjNKVyAvVldjRSyTuAGJ
w9kauBPqitfCjUql9TFo5YzdxNhZVytZde95Vay6CXtWweND6ldqVt3UDqWN
mQFn9Gxx7Ax8w/sMM9KqG+IlSKvuNe+ffjerHWnVDfNSnFt1k22cFa26j7xY
XZFtnJV0tefF6OqZQ1yPeM4c3uRvOF0xW2Talz3Pc2y+S/q8HXamK5D3eSvt
RFcy3jNdQby//Q1OV3JeCrGuBHFG6UrGe6YrQZxRuhLxKuYrQvf1KHX2T7Gu
Bp/dFD25D7sGbF2Ns+reWzmrWHULLLM5pFbdqz9zo/CsRVt1r+yxx8Jihn3z
B+dW3UdeVhZl1Q3woq26D7zxH9FW3SAv0qobqi/WqlsUZ4yujrz/QOtK2L4c
Yl0NJPTnkHruPFNKK5yuhjT0Pd/3KFybdkA7SOfEcqYrkJeVPdcVzIvTFcT7
+z/gdCXixehKUF+UriRxPtUVyPsXnK5k7cshzVeri+pZwsyF+Yp7qAUZaoJD
BNbVnOncqhuwcv4aadUN8mKtuqe6m3f6hHBbMwqDPoSDs+qmhkjmPSmbrq0j
l46lYTVgrbpBXpxVN8D79z9jrbpB3qVdZFbdIl6UVTfIi7PqBuOM1RXA+xVS
VyAvVlera2JLbJY5cbpal2VLbFoWqyuQF6crgHcssboCeZe/yXQl4kXpCuRV
toBf4syA0BXAOyB1BfIq5CvLIVVD6pxcjHlDDNQVfzzP9PGWP6CFNPsEYdUN
W9ijrLpBXqxVdzPFwVy2reLnAIqw6h6mReXl9dio6bGyWKtugLdDWnWDvFir
blF951PLrLoh3hFr1S3iRVh1g/XF6grkxekK5MXqasHruS8GhK7WZafg2qws
VlcAL1ZXIC9WV6L6zvGR6QriRetKxKtmAb/UlwGhK5AXpyuQF6urOl1RWHS7
gOOoq/d7CuUU3y6r7gMFBc6qexz6AwkABV5cWZAXa9X9DfOirbpBXpxV9zcf
Z5yuAF5tAf//ZwH/rctX/Xm+KulC4k0S+IdoA63L6rK6rC77gZQdMvb0zuFh
/m8GH6INtC6ry+qyuuwHUnaI3dvNCZDfm6OhoaGhoaGhoaGhoaGhoaGhMeHf
Z5Spig==
              "], {{0, 42}, {491, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {491, 42}, 
            PlotRange -> {{0, 491}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"63a40d90-7a0c-48cf-aed8-3646835db911"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x21.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b88d8a07-67e9-49fc-8e51-d25b20a7c4b4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"db50eadf-46e9-4dc6-ad4d-7a5cc249e6bf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c6aa2745-7943-4271-9fd7-875d2be89aa6"],

Cell[TextData[{
 "Use ",
 StyleBox["ImageData",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Flatten",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Total",
  FontFamily->"Source Sans Pro"],
 " to find the number of white pixels in ",
 StyleBox["Binarize", "InlineCode",
  FontFamily->"Source Sans Pro"],
 StyleBox["[", "InlineCode"],
 StyleBox["Rasterize", "InlineCode",
  FontFamily->"Source Sans Pro"],
 StyleBox["[\"W\"]]", "InlineCode"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"20b0817a-376b-4dd8-bb15-37ca7057db65"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3d9864c6-7042-43d5-91e0-a8df0a992208"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUi1vwzAUtDYyOGnaD9gfCB4NHIrUaayk1ZpqpIvaSZNpmGFYWFBQUFBR
iFGJiYlJQIhJgYGJQYD3nHRpU2mbxnuSLd/lnfM+/DB/n4RXCKHNDWyT2ae/
Xs/w8y2Ql9XmbblavD6tPhbLxfpxfg3iHax7WO5sL7C65rzR7cBbVVdlUW53
Uo/iWtVwXp9qdYFRB7JTvWJE4Tmh21BA9/21poz8TvF2J/6myuMoADVlvd3k
wDwiXVI8hGNMe73KCA7hzoCNU7JWgCM52HXqIy9hhw/ZFKFYDsmLDCH/3G6Y
f7Sr1DvaZRVD/JCt5ulfdstSV0tE0iSedsVO2X/swPk2jzEm2ZZVxBVrfrW3
3NXOzzsCqGAsfvbthqF09oFbAxPnFBqCcE4F59JYUcQhKWvZ0NzNlNC9+4OW
nAuaRzCKjDIuZNulHaAREqZFSQaK80MPNUtGcV6i7M9ojVLq5BlecI4vFdn4
kQ==
            "], {{0, 19}, {21, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{21, 19},
          PlotRange->{{0, 21}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{25, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9039bcd0-0687-493d-9a81-22837149401b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUi1vwzAUtDYyOGnaD9gfCB4NHIrUaayk1ZpqpIvaSZNpmGFYWFBQUFBR
iFGJiYlJQIhJgYGJQYD3nHRpU2mbxnuSLd/lnfM+/DB/n4RXCKHNDWyT2ae/
Xs/w8y2Ql9XmbblavD6tPhbLxfpxfg3iHax7WO5sL7C65rzR7cBbVVdlUW53
Uo/iWtVwXp9qdYFRB7JTvWJE4Tmh21BA9/21poz8TvF2J/6myuMoADVlvd3k
wDwiXVI8hGNMe73KCA7hzoCNU7JWgCM52HXqIy9hhw/ZFKFYDsmLDCH/3G6Y
f7Sr1DvaZRVD/JCt5ulfdstSV0tE0iSedsVO2X/swPk2jzEm2ZZVxBVrfrW3
3NXOzzsCqGAsfvbthqF09oFbAxPnFBqCcE4F59JYUcQhKWvZ0NzNlNC9+4OW
nAuaRzCKjDIuZNulHaAREqZFSQaK80MPNUtGcV6i7M9ojVLq5BlecI4vFdn4
kQ==
              "], {{0, 19}, {21, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {21, 19}, 
            PlotRange -> {{0, 21}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f5325408-cc8c-413f-88b3-928538ef61db"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x21.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7a6be7ce-3fe5-487b-8540-0016802ea9c8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4c22486e-8eca-4fa0-9d76-3ac2556b81f6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"dea9160f-dd49-4db8-8608-3656a7ed4353"],

Cell[TextData[{
 "Use ",
 StyleBox["Flatten",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["IntegerDigits",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Total",
  FontFamily->"Source Sans Pro"],
 " to find the sum of all digits of all whole numbers up to 1000."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"48203153-acc2-4daf-9aca-1c9fc41520ad"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ae907f6a-52b5-43f0-9ebc-d561510cae61"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUy2P3DAQjVpSWKm/oFKxcWlgUaSrypbcqZtTyTbaq1SFhgWGLTMKCgoK
CjEKMTExMYgqmRgEuCDA4Dp2nI13dapaeNKNlCh+43lvPjLv777fpK+iKHp4
A6+b25/x8Xibf34Lhy+Hh2/3h/3XT4cf+/v98ePdawDfwfMBHvv9+GLP0rRg
bNRmO0vWtU3bEaHmy5tGcrYZH73bKNI1ddMyeXHfTCNjQq9H0eSRs3KYFj/F
mQPQgmM2hVlVHl4sppZoLOMzglqxyM1ttqBoWMXGvi6yBKAT9Zwcp0k1OFlh
88j7UOsURwlm4HNmIdnbW42Aw2i/0tbBc4/LPIXMEqoDgkcOYhUN8/fMJcTu
6qAvCpATN8Ed00Ib4tPCx+sdiPE1wHC81r7aTOMrLaPVKHrsympFIE5tC9Au
S9OiqrkytlIUxRX1TOwE5OemaXf8u5am1dr/jIfTNqKIUVrirqtte6JkmGxX
z1pX5P+i5WuTtEBbf65tIsj+Ub/+ry7D7LyYh8y8VaK6PIy1v8RW/AAZllR1
dl54iRF1aue1Xpq50/J8M2wWI9jOpSawOvI3h+kmZSPUJAXJgQ6VaqV3v0Ex
CKlGWu3s5DppXPJR0TIlesBQQZamwPqRGgIQJpRxCd1LogurqB4J3tYlzkiw
nuDLt4AYDz4LilOPJdXoigomvixZ9eQcPK2etJ6fdJnZ+swlCNg0XYMv9nzt
D4YQvWM=
            "], {{0, 19}, {36, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{36, 19},
          PlotRange->{{0, 36}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{40, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "baf83494-1af5-420c-98fc-8b1d19ee31ed"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUy2P3DAQjVpSWKm/oFKxcWlgUaSrypbcqZtTyTbaq1SFhgWGLTMKCgoK
CjEKMTExMYgqmRgEuCDA4Dp2nI13dapaeNKNlCh+43lvPjLv777fpK+iKHp4
A6+b25/x8Xibf34Lhy+Hh2/3h/3XT4cf+/v98ePdawDfwfMBHvv9+GLP0rRg
bNRmO0vWtU3bEaHmy5tGcrYZH73bKNI1ddMyeXHfTCNjQq9H0eSRs3KYFj/F
mQPQgmM2hVlVHl4sppZoLOMzglqxyM1ttqBoWMXGvi6yBKAT9Zwcp0k1OFlh
88j7UOsURwlm4HNmIdnbW42Aw2i/0tbBc4/LPIXMEqoDgkcOYhUN8/fMJcTu
6qAvCpATN8Ed00Ib4tPCx+sdiPE1wHC81r7aTOMrLaPVKHrsympFIE5tC9Au
S9OiqrkytlIUxRX1TOwE5OemaXf8u5am1dr/jIfTNqKIUVrirqtte6JkmGxX
z1pX5P+i5WuTtEBbf65tIsj+Ub/+ry7D7LyYh8y8VaK6PIy1v8RW/AAZllR1
dl54iRF1aue1Xpq50/J8M2wWI9jOpSawOvI3h+kmZSPUJAXJgQ6VaqV3v0Ex
CKlGWu3s5DppXPJR0TIlesBQQZamwPqRGgIQJpRxCd1LogurqB4J3tYlzkiw
nuDLt4AYDz4LilOPJdXoigomvixZ9eQcPK2etJ6fdJnZ+swlCNg0XYMv9nzt
D4YQvWM=
              "], {{0, 19}, {36, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {36, 19}, 
            PlotRange -> {{0, 36}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"eda9dcbb-f6d9-488d-9479-6daaac4a7d9d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x21.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c7405f50-58d6-4e2a-8158-d00212b303ee"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c05bee44-1c39-4d4e-ac05-3a89bb7c6b02"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"dcaa538e-ad52-46d4-91da-f188d96909ee"],

Cell["\<\
Generate a graph with 200 connections, each between nodes with numbers \
randomly chosen between 0 and 100.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"cbb2a8c2-a38d-4648-a4ab-07eb087272df"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"31881cf5-1af3-4ac5-b37b-be12da85d1ee"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvedfVdfa93ufc96cl+dfeN49z33v+947yTbGEjUmaowaU+xdERVUuoBI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            "], {{0, 307}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 307},
          PlotRange->{{0, 360}, {0, 307}}]], "ExerciseOutput",
         ImageSize->{364, 307},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d0fb4a9d-4828-43a2-a2a6-d70b11c8388b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvedfVdfa93ufc96cl+dfeN49z33v+947yTbGEjUmaowaU+xdERVUuoBI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              "], {{0, 307}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 307}, 
            PlotRange -> {{0, 360}, {0, 307}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2c3db8a4-835f-441d-be94-fd5dadfcbabe"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x21.6"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"16223c17-0989-445b-a2e7-287392d06bde"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d9517242-af2a-4efb-bd81-14f39ba74c26"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"85b2a80b-b36a-46c8-a410-0f8c2cc26713"],

Cell["\<\
Generate a plot that shows communities in a random graph with nodes numbered \
between 0 and 100, and 200 connections.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 21}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"87091163-0564-410a-8304-49a4ac105309"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"944544c7-4cf5-47b6-bddd-ba3b282dd811"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvQdYVNfaNux3osZc//W/3/ue9z8lOTnJqUnUmByj0ST2FnsXK6iI2CtF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