(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    965583,      17941]
NotebookOptionsPosition[    887221,      16280]
NotebookOutlinePosition[    947914,      17526]
CellTagsIndexPosition[    947834,      17521]
WindowTitle->Units: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Convert 4.5 lbs (pounds) to kilograms.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"3972e511-6676-4d60-a0cd-dc618e5a4193"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"57d138c1-3c38-434d-9a8f-ee3756f85eec"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztls9r2lAcwMt22XGn3fdf7DZ23LVz10LLujqEjtbBaC/qoXgQigcRRg7N
oXoIUpGACiJrkVrwkIKBPggSqhgJErFKDBED2fe9GPXFdnSDsbL1SxTfe9/3
vp/3/WVebnxe/fhkZWUl+Ay+Vte/vtndXd979xwG77eDn7a2Nz+83f6yubW5
+2rjKUy+gM9r+ODf9qM8yr8gpnIlqoPJL+wYqahaqpRLSNZuXR930UU5V6kK
Q8u7pMlIblG7+p2GZ8a2dUVC6miKNO61ZQktPmrPdEmEg4CPq9/cE3wo5UE/
FPA532y54SVv5UNkCT/77CLWWM7hySA7nGqWYo6aOwOilA+dvScuksz55wc6
pjlxqm2K8YCPv7ovvFLcCwUYgqR/P4SjmD61blaiMJkABYugcrUZvnqyT6xH
MgYZWz2BP2LYCNwxbcyUajkusQNqhTnSxDInloUDIfOwtCONZtbE2F3wljk2
l9NJH7oBHdaZUMCPRguLJkoGfEz5mgxu+KDv4KjmrEhZuLUvFqRQQZrAE6Rm
bLtxuz+tBhyeLC7EegHe6pzCagqbnkjFafhikR2wyPBo+XISDmiCyteRc5o+
VyApYXVKIWwXyRA4GlXO+r3wd/hTLYdDgbBiLWlKpuO0UDQDtrQqJi8I1/3W
OYMDnW72dK8bCA9TpHOenFaSdRpM4yFhDnNgViF+XrR/b/h2KuCLe3xINAt1
sRCZ15fErc1M4MOjeW/bGAjkpjnDM+/xPAZjpWIYBzGaKGQZBqe9P3WcU90T
7wvfPYVDvrdMm9ZMzgo5knGqvl9ncb1XkSrhhhDnaff2BIZ0ErpUiZC0ZM/a
ZKA7Oa/V8zyXLnAsn2VZB57Lz+CbBH5MHYJwzktUrFWcDHsyze7CRy/rmDPp
xKWHrxnbB//7U3xt0S3j7rlz2UJNlK9EVBeUwUSrQeWuVYhbLo/WwMplS5XP
EliNZnDK00E1ug1ZRpVvUDjhSwk1uzr+04FOLmRgY6pYa0pIc2lJ+aSXAx13
m2qTxPeiMzGuwPNh1NH6Pa0/uJm1FxtHecfTdWGvQjZOOa32SWS6xPCixxru
dW63kegGfnAsOn17cXKWgdju/hI8qVNXh1RWJGd08h5Crtq2fyYTY6DTQ7iy
eaf6HxSzAv8+h3nDnkCft8xrFrtF+BskvyF6Cfs/rQxMy9QVkoHJovc14MGK
Ae09OM8ZNnvuTbYHL+B2Y6QvvRg+yqP8R/IDlZ/KKA==
            "], {{0, 22}, {63, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{63, 22},
          PlotRange->{{0, 63}, {0, 22}}]], "ExerciseOutput",
         ImageSize->{67, 22},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b412048b-9f0d-4647-b48b-42270212bc86"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztls9r2lAcwMt22XGn3fdf7DZ23LVz10LLujqEjtbBaC/qoXgQigcRRg7N
oXoIUpGACiJrkVrwkIKBPggSqhgJErFKDBED2fe9GPXFdnSDsbL1SxTfe9/3
vp/3/WVebnxe/fhkZWUl+Ay+Vte/vtndXd979xwG77eDn7a2Nz+83f6yubW5
+2rjKUy+gM9r+ODf9qM8yr8gpnIlqoPJL+wYqahaqpRLSNZuXR930UU5V6kK
Q8u7pMlIblG7+p2GZ8a2dUVC6miKNO61ZQktPmrPdEmEg4CPq9/cE3wo5UE/
FPA532y54SVv5UNkCT/77CLWWM7hySA7nGqWYo6aOwOilA+dvScuksz55wc6
pjlxqm2K8YCPv7ovvFLcCwUYgqR/P4SjmD61blaiMJkABYugcrUZvnqyT6xH
MgYZWz2BP2LYCNwxbcyUajkusQNqhTnSxDInloUDIfOwtCONZtbE2F3wljk2
l9NJH7oBHdaZUMCPRguLJkoGfEz5mgxu+KDv4KjmrEhZuLUvFqRQQZrAE6Rm
bLtxuz+tBhyeLC7EegHe6pzCagqbnkjFafhikR2wyPBo+XISDmiCyteRc5o+
VyApYXVKIWwXyRA4GlXO+r3wd/hTLYdDgbBiLWlKpuO0UDQDtrQqJi8I1/3W
OYMDnW72dK8bCA9TpHOenFaSdRpM4yFhDnNgViF+XrR/b/h2KuCLe3xINAt1
sRCZ15fErc1M4MOjeW/bGAjkpjnDM+/xPAZjpWIYBzGaKGQZBqe9P3WcU90T
7wvfPYVDvrdMm9ZMzgo5knGqvl9ncb1XkSrhhhDnaff2BIZ0ErpUiZC0ZM/a
ZKA7Oa/V8zyXLnAsn2VZB57Lz+CbBH5MHYJwzktUrFWcDHsyze7CRy/rmDPp
xKWHrxnbB//7U3xt0S3j7rlz2UJNlK9EVBeUwUSrQeWuVYhbLo/WwMplS5XP
EliNZnDK00E1ug1ZRpVvUDjhSwk1uzr+04FOLmRgY6pYa0pIc2lJ+aSXAx13
m2qTxPeiMzGuwPNh1NH6Pa0/uJm1FxtHecfTdWGvQjZOOa32SWS6xPCixxru
dW63kegGfnAsOn17cXKWgdju/hI8qVNXh1RWJGd08h5Crtq2fyYTY6DTQ7iy
eaf6HxSzAv8+h3nDnkCft8xrFrtF+BskvyF6Cfs/rQxMy9QVkoHJovc14MGK
Ae09OM8ZNnvuTbYHL+B2Y6QvvRg+yqP8R/IDlZ/KKA==
              "], {{0, 22}, {63, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {63, 22}, 
            PlotRange -> {{0, 63}, {0, 22}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"94745e09-aa08-4ce2-b548-e6b7d6fcd360"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4e0f7d29-6b2d-4b55-96a6-7e79a4bf3c05"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e518103b-012b-44fe-bb64-81e0d0fbbbf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"aa8129dc-a579-45f1-8b4a-95b32bc245d3"],

Cell["Convert 60.25 mph to kilometers per hour.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"789542b0-4081-4d00-bdfe-c67d7e11b568"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"837fdf24-3c4e-4e76-abdf-434944e1a829"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVs2L6lYUH9pNl130H+h/0W2Xb/uabgfeo9NnEaY4FsrMxnEhWQjBRRAG
F2ahLmQYkYAOBFEJKi9CBAMGwhAcUbESGQ1RIgbS+5GYxLGvjwdv52EM5+be
e875/c5H5sf3f779/Zuzs7Pod+Dx9t3fP19dvbv+5Xuw+PUy+seHy4vf3lz+
dfHh4uqn99+Clz+A3xvwg7p9kpOcxBFzMpBmq91XNmIoAsfXGsp06X/7okrd
WqUjSLp15M6LKnRqlV5/uA2aeu63+BonKWPXuSYD482GrM4CB9diIkwU+wGP
ny+aWCjW5P8xYo0fbohYmEhE4TPfdkKSS9dg6f5RkyA6Be9Gz+GTKm9cU8Wb
/RUixcrWvJVCegK/yQmeGVMCW+zgy6CZfJxIsk+fNqIJFHDKj0BOd507ECoJ
yZ039pFYc+GhJASQmTIwmCpKQH0RGXCyqhhAnzzeAp1ToKNJk6kPlta8kYzS
mJZeLhQLh+S1By35CWiWuTU9fxszWHLWEwiAn+4cIwo8ul0bB8WlFEOxKKPj
BULEqcakBoK8fj5Wh9DIqBwLn/cWeLVko0SyJEMFpIxuHL9j27pI/xc0a9pI
g4KpDYHlFMn02gzOe74mz/r3OOPpXGOzD0ApOClAWcs/VpxqiZLKwiMBQgtn
HGgrAblbdGkikW3N1BZXKvBtaW/T4WzOxTBpUAwuTsTuWvYahvogPqntcrVU
7ileZ20WM1WspP2lu4cGCDdluEXegxg2MGYQ5G13IPHZCNIj9b7ULcL67zge
Ucx0CxtJOyQIar8MYCZRLflSQCRIulqiMT/VwT/VOO6XSD5LQiV+rwfAzYpo
l2ULDD4Zv9/gCKEpKk8BugimNsTYq24DBsoPQav2JejrhtEwCRBaSEKZtVBg
7MBACxny5lxfPgAsoma7WSsK+PaOJwF7Ff9Y00cCm6Xy2YLU55CFKQyGdOBg
d14hOYGNO6VMnqbqosSDFAOu1tAL08RwbCl37tU5bB3tgPk94X7qsC8F+0Id
7bDhb8xVC7SDvPKlHsO3bbUU8Tv1y3YAi7wz38GM3xQwfGtaOQLNkyGIMA0S
ZD0BJdMcu15wC5seh5j5/aB2oJE9xGealV9B88Hx6VqbjEULG/vVGcdpYV/z
1kJgSFpSx5NBBQ5qmrPcKmUeRX015CgYAJhympABdPEjMI40jr6tCrI2latw
91pF0wy1baSjzF7UBjR11/pIg9ameupMX4w7Odg79ZE7+FCWMdJnNFpBQj8D
2q5L4anlGHkFzVcqCzETdQojQRVm7lR8btLuFyrSUb3Zjua8Vr8LHewi0ep0
yG9qO5eK5Ll78pxtD71so950a0mD0zVeXkJokT20lPtZcYvTwGOfU82gkT20
COz6YFVtVkt9bdoHYhn6aunryt1mZXib66W+OvyU2PD7At8HzJjG0ZNfIpYx
UQ/+/znJSU5ykq8i/wKMh1t0
            "], {{0, 20}, {73, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{73, 20},
          PlotRange->{{0, 73}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{77, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "15159d85-512a-436e-849f-36c807e86016"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVs2L6lYUH9pNl130H+h/0W2Xb/uabgfeo9NnEaY4FsrMxnEhWQjBRRAG
F2ahLmQYkYAOBFEJKi9CBAMGwhAcUbESGQ1RIgbS+5GYxLGvjwdv52EM5+be
e875/c5H5sf3f779/Zuzs7Pod+Dx9t3fP19dvbv+5Xuw+PUy+seHy4vf3lz+
dfHh4uqn99+Clz+A3xvwg7p9kpOcxBFzMpBmq91XNmIoAsfXGsp06X/7okrd
WqUjSLp15M6LKnRqlV5/uA2aeu63+BonKWPXuSYD482GrM4CB9diIkwU+wGP
ny+aWCjW5P8xYo0fbohYmEhE4TPfdkKSS9dg6f5RkyA6Be9Gz+GTKm9cU8Wb
/RUixcrWvJVCegK/yQmeGVMCW+zgy6CZfJxIsk+fNqIJFHDKj0BOd507ECoJ
yZ039pFYc+GhJASQmTIwmCpKQH0RGXCyqhhAnzzeAp1ToKNJk6kPlta8kYzS
mJZeLhQLh+S1By35CWiWuTU9fxszWHLWEwiAn+4cIwo8ul0bB8WlFEOxKKPj
BULEqcakBoK8fj5Wh9DIqBwLn/cWeLVko0SyJEMFpIxuHL9j27pI/xc0a9pI
g4KpDYHlFMn02gzOe74mz/r3OOPpXGOzD0ApOClAWcs/VpxqiZLKwiMBQgtn
HGgrAblbdGkikW3N1BZXKvBtaW/T4WzOxTBpUAwuTsTuWvYahvogPqntcrVU
7ileZ20WM1WspP2lu4cGCDdluEXegxg2MGYQ5G13IPHZCNIj9b7ULcL67zge
Ucx0CxtJOyQIar8MYCZRLflSQCRIulqiMT/VwT/VOO6XSD5LQiV+rwfAzYpo
l2ULDD4Zv9/gCKEpKk8BugimNsTYq24DBsoPQav2JejrhtEwCRBaSEKZtVBg
7MBACxny5lxfPgAsoma7WSsK+PaOJwF7Ff9Y00cCm6Xy2YLU55CFKQyGdOBg
d14hOYGNO6VMnqbqosSDFAOu1tAL08RwbCl37tU5bB3tgPk94X7qsC8F+0Id
7bDhb8xVC7SDvPKlHsO3bbUU8Tv1y3YAi7wz38GM3xQwfGtaOQLNkyGIMA0S
ZD0BJdMcu15wC5seh5j5/aB2oJE9xGealV9B88Hx6VqbjEULG/vVGcdpYV/z
1kJgSFpSx5NBBQ5qmrPcKmUeRX015CgYAJhympABdPEjMI40jr6tCrI2latw
91pF0wy1baSjzF7UBjR11/pIg9ameupMX4w7Odg79ZE7+FCWMdJnNFpBQj8D
2q5L4anlGHkFzVcqCzETdQojQRVm7lR8btLuFyrSUb3Zjua8Vr8LHewi0ep0
yG9qO5eK5Ll78pxtD71so950a0mD0zVeXkJokT20lPtZcYvTwGOfU82gkT20
COz6YFVtVkt9bdoHYhn6aunryt1mZXib66W+OvyU2PD7At8HzJjG0ZNfIpYx
UQ/+/znJSU5ykq8i/wKMh1t0
              "], {{0, 20}, {73, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {73, 20}, 
            PlotRange -> {{0, 73}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ac5e66e3-6dfe-4c98-aca7-b9c448adc97c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2937db3f-b309-42c5-ad43-a1e289c4c1e6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3358b576-40c6-4907-b280-84850cd44430"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"804ebe22-85d9-47aa-a05f-0b6c588ca926"],

Cell["Find the height of the Eiffel Tower in miles.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"d8d254ae-8a73-4a8c-8539-d1f2fa6f5fb9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"460b3c23-05ea-4607-86d1-72b2b319d8dc"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVs+L4kgUbmYve9zD/AP7X+x1T8teZ92rMMP2joPQi52Fpb3YfRAPgngI
DUsOnYPrITRKE0gLIdiN2IINETpgIEhhizZBlNEQJWLAfVWVmJjuYWZgYS8+
Yqh6qXr1vu/9KL9/98eb318dHBww38Lrzdu/fjw+fnvyy3cw+fWI+fD+6PC3
n4/+PHx/ePzDu29A+Rp+P8EPjzd72cte/gNZr9yoyuw2GzWp0x2+tN4ZPTQb
inSv6suQdjXWW8pV4061dq19fOqhwSS0e6K35cbtjY7MQLkw9Tu5ocg6mmyi
Mnvsaubc+RpETj0XyyRzo5AnRvUkk4xlGNDHzkVtd3m/cob1WfI1c1a2KKKB
hKf0SfMTTynnqYbh6TJ33CwSTZa8i6U2HGsZUjak5JVe+EBdSOFPJfWrQGnV
HHchWVvFQgVPilWNGExkkikUIskdy3BEY4BV5m0BxteGDUYamBkWsLjoCpRC
G8Nyp6p4wfFAQrq89Lbf5BmWEtgpgfGEvtiMasAhR3iw6wWww330j9tyRf15
JuvVInAuPI7IyiiDkc6UTMY3MBa7dnjBcu5PXb2Iv842jn6ejHFKn2hnIhPL
XrS36x/FVIYphxOViqWyFBRgsRZrT/nA+UpMWwXyIX1yzsTyQgiU2xfSiYoi
8SRbsoXL0VgT0jRJWET2PtZyWVZa+TtGymnAldvnnoEKbD9JXqQWWj60zID4
+vkGgqqJCKjl1ESqBDxkClcRsHgviTjeKOIquH8y62exbBjUQqM5XFFUXWFp
KHmxaaiX4EaexJQcGvhAXNr64MhpWKa/hInSSGrKwaBkZL+I4hko+zrtVR+O
8g5LOLe5Wm87/ucONxPiQ6jQHAxKUCl0GyeGV3HYWwo/ciiOVIBxyAMhu0dT
Uw0WvEppU4+6nUhVPxMp7LMzuRdwIFpPXuJt5iqOXY7GzpZJO+JLvCiwJC6p
67bfip3wcZgiPzmDceTQFYKaimtzMpk2/Vawi+hvSJJ4a+D74/bAH/52GFAX
rili309vZ5vnUJLgW+WBMDZVOdI2/RbhaLWyWC2LAoDiirh2UrIaATX7clC0
jiDbzelQxr0oBxkwaUP9xknTm9TZOOmxMjI0/UE1yHXTuQDlSWdgolt2y8Ny
3ENIJwycdgz9cWzfQ3yZQgeZ1nTYKuFeXR84q3HznGTjdVtDXWxzNF9vAllH
S2DxhaD4nUJGkne/JBOtAXZvVDulrtLeuPNQQtwhvb9wUfhXG6n6YGW2pK2g
TeXiviYu3vWJA6mITS98fmKAq0UxBIo02y0oAtkDBS3FB5XKpC+jLdeFNjtb
BjfyOujknxRYM7M+fVkEth3bmtvP/sXsZS972cv/Jv8CN60BHA==
            "], {{0, 
            20}, {71, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{71, 20},
          PlotRange->{{0, 71}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{75, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "137bb9b4-4b5f-4cd4-a7e0-3e8e0084fba4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVs+L4kgUbmYve9zD/AP7X+x1T8teZ92rMMP2joPQi52Fpb3YfRAPgngI
DUsOnYPrITRKE0gLIdiN2IINETpgIEhhizZBlNEQJWLAfVWVmJjuYWZgYS8+
Yqh6qXr1vu/9KL9/98eb318dHBww38Lrzdu/fjw+fnvyy3cw+fWI+fD+6PC3
n4/+PHx/ePzDu29A+Rp+P8EPjzd72cte/gNZr9yoyuw2GzWp0x2+tN4ZPTQb
inSv6suQdjXWW8pV4061dq19fOqhwSS0e6K35cbtjY7MQLkw9Tu5ocg6mmyi
Mnvsaubc+RpETj0XyyRzo5AnRvUkk4xlGNDHzkVtd3m/cob1WfI1c1a2KKKB
hKf0SfMTTynnqYbh6TJ33CwSTZa8i6U2HGsZUjak5JVe+EBdSOFPJfWrQGnV
HHchWVvFQgVPilWNGExkkikUIskdy3BEY4BV5m0BxteGDUYamBkWsLjoCpRC
G8Nyp6p4wfFAQrq89Lbf5BmWEtgpgfGEvtiMasAhR3iw6wWww330j9tyRf15
JuvVInAuPI7IyiiDkc6UTMY3MBa7dnjBcu5PXb2Iv842jn6ejHFKn2hnIhPL
XrS36x/FVIYphxOViqWyFBRgsRZrT/nA+UpMWwXyIX1yzsTyQgiU2xfSiYoi
8SRbsoXL0VgT0jRJWET2PtZyWVZa+TtGymnAldvnnoEKbD9JXqQWWj60zID4
+vkGgqqJCKjl1ESqBDxkClcRsHgviTjeKOIquH8y62exbBjUQqM5XFFUXWFp
KHmxaaiX4EaexJQcGvhAXNr64MhpWKa/hInSSGrKwaBkZL+I4hko+zrtVR+O
8g5LOLe5Wm87/ucONxPiQ6jQHAxKUCl0GyeGV3HYWwo/ciiOVIBxyAMhu0dT
Uw0WvEppU4+6nUhVPxMp7LMzuRdwIFpPXuJt5iqOXY7GzpZJO+JLvCiwJC6p
67bfip3wcZgiPzmDceTQFYKaimtzMpk2/Vawi+hvSJJ4a+D74/bAH/52GFAX
rili309vZ5vnUJLgW+WBMDZVOdI2/RbhaLWyWC2LAoDiirh2UrIaATX7clC0
jiDbzelQxr0oBxkwaUP9xknTm9TZOOmxMjI0/UE1yHXTuQDlSWdgolt2y8Ny
3ENIJwycdgz9cWzfQ3yZQgeZ1nTYKuFeXR84q3HznGTjdVtDXWxzNF9vAllH
S2DxhaD4nUJGkne/JBOtAXZvVDulrtLeuPNQQtwhvb9wUfhXG6n6YGW2pK2g
TeXiviYu3vWJA6mITS98fmKAq0UxBIo02y0oAtkDBS3FB5XKpC+jLdeFNjtb
BjfyOujknxRYM7M+fVkEth3bmtvP/sXsZS972cv/Jv8CN60BHA==
              "], {{0, 
              20}, {71, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {71, 20}, 
            PlotRange -> {{0, 71}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"940fc46a-4d34-4242-8776-91c375709343"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"949b42ee-b319-4ef0-8250-ff051ac7d820"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5917aea5-f0ce-42a0-8a8f-e0b6ae105b49"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1bee78e1-aaa0-436f-9ea0-ef9914826fdd"],

Cell["\<\
Find the height of Mount Everest divided by the height of the Eiffel Tower.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"2f6708d9-8d15-4a30-9604-343092b5cd8f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f02a5e4f-0c58-436f-bba4-c94f55d79a00"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVC2P3DAQjVpSWKm/oD+gwaWBRZFalYXcqZdTyfV0V6kKDQsMCwsKMgoK
MgkyCTExMQhJgYGBiYHBdsbe3WT3PtQfsCMlsid+b958OB+vf33N30RR9PgO
Xl+v/iQPD1fFt/ew+X73+PP27ubHl7vfN7c3D5+v34LzAzyf4MH17mIXe8XM
woaekJ4JFRxK8lMTxp1hnJxoT3rKuN58sgvvSUcGtnUunAH7wITd4vU8QtB+
EArdmpM4QgvveyJAVh02q8Wj2WpYmmyDiYsQwEqyIpJ68T5aJbhLE8/eByVG
dFv2TljZAWPlIabLwVdhRdzeIGIFsXKyTQSqVSdxy1GZnlrEMA0RCWorgcr5
KCVVO8MSXCC9ZjUoZh5Uo6hC+jKQqvFZGH2ouGYVCGebxPUE2GhYXm6o40BZ
TXpneYZ6ZcBBPeNy3JkJvhajPpxEGW7pvXLzEuWEKstNTNMgC30+vlGzYHUO
xUrp4kLEejIrVVzrnWpBXJxTMbMWal3MeBBSS0chhrZtu0Hok7FzM4rMO7F6
fK/JfD6dG81+NEqv06KMVuxlcEggbmAz9/fHGUg7rJXhTdjmRZnhdCVUHUg1
w8Zm3bZSAjMpX2uIs3JsPU6eVwNl1H8Ffu24ckZ2RQrrfnZBBpEhOwkq05bj
UrHcz7Y6CWJawBXDs7Ww9uh2HQSsGMxlhldhDtgwGwIpykNqGievnizKiMO8
YN/hJDgXGi5fQyc+TYwxuW8WDgagjqEXCjQxkdYKTKceuNKKD7hOW2wlLaHE
GZXw7yiRkJuF4qLqubFQt8ZPJuS6oDdrhFITKSLfSt6kZ/8If/vA5iI6kSH9
fQZy+PUMdb52vCT7Mrq5OpDlbQC6sVlP5s0YMnSH3PHedmuI/zMHd3uzs1pr
Y5+eeeJ11rxw0tjn5/9iFzvaP8hjRZk=
            "], {{0, 19}, {45, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{45, 19},
          PlotRange->{{0, 45}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{49, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a7e8cefb-9a7d-449b-9476-0d7b41e92110"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVC2P3DAQjVpSWKm/oD+gwaWBRZFalYXcqZdTyfV0V6kKDQsMCwsKMgoK
MgkyCTExMQhJgYGBiYHBdsbe3WT3PtQfsCMlsid+b958OB+vf33N30RR9PgO
Xl+v/iQPD1fFt/ew+X73+PP27ubHl7vfN7c3D5+v34LzAzyf4MH17mIXe8XM
woaekJ4JFRxK8lMTxp1hnJxoT3rKuN58sgvvSUcGtnUunAH7wITd4vU8QtB+
EArdmpM4QgvveyJAVh02q8Wj2WpYmmyDiYsQwEqyIpJ68T5aJbhLE8/eByVG
dFv2TljZAWPlIabLwVdhRdzeIGIFsXKyTQSqVSdxy1GZnlrEMA0RCWorgcr5
KCVVO8MSXCC9ZjUoZh5Uo6hC+jKQqvFZGH2ouGYVCGebxPUE2GhYXm6o40BZ
TXpneYZ6ZcBBPeNy3JkJvhajPpxEGW7pvXLzEuWEKstNTNMgC30+vlGzYHUO
xUrp4kLEejIrVVzrnWpBXJxTMbMWal3MeBBSS0chhrZtu0Hok7FzM4rMO7F6
fK/JfD6dG81+NEqv06KMVuxlcEggbmAz9/fHGUg7rJXhTdjmRZnhdCVUHUg1
w8Zm3bZSAjMpX2uIs3JsPU6eVwNl1H8Ffu24ckZ2RQrrfnZBBpEhOwkq05bj
UrHcz7Y6CWJawBXDs7Ww9uh2HQSsGMxlhldhDtgwGwIpykNqGievnizKiMO8
YN/hJDgXGi5fQyc+TYwxuW8WDgagjqEXCjQxkdYKTKceuNKKD7hOW2wlLaHE
GZXw7yiRkJuF4qLqubFQt8ZPJuS6oDdrhFITKSLfSt6kZ/8If/vA5iI6kSH9
fQZy+PUMdb52vCT7Mrq5OpDlbQC6sVlP5s0YMnSH3PHedmuI/zMHd3uzs1pr
Y5+eeeJ11rxw0tjn5/9iFzvaP8hjRZk=
              "], {{0, 19}, {45, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {45, 19}, 
            PlotRange -> {{0, 45}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e89a7ae1-d343-4911-8343-306bdb3acd2f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e2d0d483-a2b9-4d34-9221-f05260713bd3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"05a239cf-f0b2-457c-9ca1-b7b0bd4dba06"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1a48b9bd-74de-405d-944f-f4fcbeee8bd1"],

Cell["Find the mass of the Earth divided by the mass of the Moon.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"0c502e7d-9dd6-418d-89a9-81c69a1a1158"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d812ae4b-25b6-4370-b32c-b5bae1f493aa"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVC2P3DAQtVpSWKm/oKQwuDSwKNJVZUvu1M2pZLvaq1QtDQs0CzMKCgpa
ZBIUYmJiEhASEmBgYmCwnXHiXHpN7wecbqREk/HMe/PlfLz7eZO+IYQ8vIPX
ze3v+HS6PX99Dx/fDg8/7g/7718Ov/b3+9Pnu7dg/ADPJ3hQv77KC5JBtnVV
XVplV0aneyk7sx3hOsHrquat1O7RagdZVyUArY294GDjol+8eB7DCsUJvsmx
9qS2PvpPErUblEOxmw6n93lK1HYVWSSmg3cVk6v33DGBJtMCdMbxXLc0UFjO
8nMKfonYYBxpHDGJB1owgMpbDSEVYmcA5FSJGh8n8KRAopaiKiE3I0A7N9q3
SsaropwCtHiLcd1dCCG50FcrgTCtOm/VNCJR1lhZADUw+8ZcQKcINzJwjVKu
+palQN6HERj0/y+jM2OvWur7wAc3ZU6Dt4CKIioqAMzHOaBLg0NfH5f2J2W3
YD7PiJjTGDPup4iMTM3esgDGokHeIgBYFpO4kBZbR0o5OtOV5wT0OhT5PCNm
7WzXYPgO8nxSYxFqjKie3fuj779iwJIFVJ3jlok5J+UZ7VMiPLLL9rsSsPMW
pr7DTZ+ugJnniAjRtCPXkUNuhTQDz3DZamksJFz4xYN6BylVU0JSEWuEVDCn
68AhnajqrMch9CJHPcoL6glTAMkzmOmOd3Answl8mh1Jy37scUfI0SfkmiJd
5pgWjcP9pWQtvjNdmQYcfaGPIUlWhd3o8yTgsLlRRlVxuKL1+nfirNHabDVw
PTej/wrRGyHg848V47Rx11d5SfIH/UUBpg==
            "], {{0, 19}, {38, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{38, 19},
          PlotRange->{{0, 38}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{42, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b526c7ec-8a9e-4ec9-9c34-ee506a965830"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVC2P3DAQtVpSWKm/oKQwuDSwKNJVZUvu1M2pZLvaq1QtDQs0CzMKCgpa
ZBIUYmJiEhASEmBgYmCwnXHiXHpN7wecbqREk/HMe/PlfLz7eZO+IYQ8vIPX
ze3v+HS6PX99Dx/fDg8/7g/7718Ov/b3+9Pnu7dg/ADPJ3hQv77KC5JBtnVV
XVplV0aneyk7sx3hOsHrquat1O7RagdZVyUArY294GDjol+8eB7DCsUJvsmx
9qS2PvpPErUblEOxmw6n93lK1HYVWSSmg3cVk6v33DGBJtMCdMbxXLc0UFjO
8nMKfonYYBxpHDGJB1owgMpbDSEVYmcA5FSJGh8n8KRAopaiKiE3I0A7N9q3
SsaropwCtHiLcd1dCCG50FcrgTCtOm/VNCJR1lhZADUw+8ZcQKcINzJwjVKu
+palQN6HERj0/y+jM2OvWur7wAc3ZU6Dt4CKIioqAMzHOaBLg0NfH5f2J2W3
YD7PiJjTGDPup4iMTM3esgDGokHeIgBYFpO4kBZbR0o5OtOV5wT0OhT5PCNm
7WzXYPgO8nxSYxFqjKie3fuj779iwJIFVJ3jlok5J+UZ7VMiPLLL9rsSsPMW
pr7DTZ+ugJnniAjRtCPXkUNuhTQDz3DZamksJFz4xYN6BylVU0JSEWuEVDCn
68AhnajqrMch9CJHPcoL6glTAMkzmOmOd3Answl8mh1Jy37scUfI0SfkmiJd
5pgWjcP9pWQtvjNdmQYcfaGPIUlWhd3o8yTgsLlRRlVxuKL1+nfirNHabDVw
PTej/wrRGyHg848V47Rx11d5SfIH/UUBpg==
              "], {{0, 19}, {38, 0}}, {0,
               255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {38, 19}, 
            PlotRange -> {{0, 38}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"78de3961-36eb-44fc-bcda-2b4cfc40d903"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dcdeef52-6afb-438b-8d0a-dd3152bd9745"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4df29a85-9867-4961-975d-638d69e2d345"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"94691f7f-507f-4ad8-bed8-6b6db59622dc"],

Cell["Convert 2500 Japanese yen to US dollars.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"41ccb7f5-5f83-4916-9e57-4d91a90d6329"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2908a9e2-0393-4651-a046-a85fc3a6603f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztU89L40AULutlj148efK/8OrRq8aroFh/EOiyjSDppe1BPBTKHkovOdjD
6iGIIoIthNJKsYUIERroQCiBFitFUtqUpLSkoG9majZoXER69DEZMm8y3/e9
b14WNn+tbP8IBALcT5hWNg6WwuENfnUWFmshbm8nFNxaDu0Hd4Lhxc0ZSM7B
Mw8Pfn/+jinGuJ7hYo3x1PCM2lmUZa7KaODN2m1Ulkp5CemGh9pQy9eFvKQ/
DT9CQyIPaNHILp65VJvo7GvXh7BkGTpn8nXy7cN5BC/JWK80/TCH6A/LJP7K
mPyxmE5eUpGtHLAIRJlVSMJxoQuFyEmAKjUdQD4BzKTkY5KtJFjmvNp7t2H1
bYe+9atClN1FtlNJQSGnlLGBGWMNH409KY71g4GjDzzRRHAjZTxbWY5JiCpN
jrRTwuJ3YNwuHRMbWb6iW283HyXYEnLgoZWN/AMcEEDNF5AydlQRG87r3ipM
JQ1ER9TYTyt0o1MEMVntVWRHEfDtZ7qTtXOHPTyjzrRyMezhu1sZNS/BQEmp
d832/QXvko6ebtOkPbKyqtdUVFVapkPKZMQb1G3i3cNj3BuGDFe2XnJbaPhQ
mBiIh5hHNK1f/HaTdNBO0K5ik0w8QzuWSPXUNfFKhuS9+V9D3KLsXt+0PLU6
A/PtVYLwu1zRmN6//B1fjhdpwxCR
            "], {{0, 21}, {27, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{27, 21},
          PlotRange->{{0, 27}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{31, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "78a07ec4-d269-487f-a17f-5358339e4f7b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztU89L40AULutlj148efK/8OrRq8aroFh/EOiyjSDppe1BPBTKHkovOdjD
6iGIIoIthNJKsYUIERroQCiBFitFUtqUpLSkoG9majZoXER69DEZMm8y3/e9
b14WNn+tbP8IBALcT5hWNg6WwuENfnUWFmshbm8nFNxaDu0Hd4Lhxc0ZSM7B
Mw8Pfn/+jinGuJ7hYo3x1PCM2lmUZa7KaODN2m1Ulkp5CemGh9pQy9eFvKQ/
DT9CQyIPaNHILp65VJvo7GvXh7BkGTpn8nXy7cN5BC/JWK80/TCH6A/LJP7K
mPyxmE5eUpGtHLAIRJlVSMJxoQuFyEmAKjUdQD4BzKTkY5KtJFjmvNp7t2H1
bYe+9atClN1FtlNJQSGnlLGBGWMNH409KY71g4GjDzzRRHAjZTxbWY5JiCpN
jrRTwuJ3YNwuHRMbWb6iW283HyXYEnLgoZWN/AMcEEDNF5AydlQRG87r3ipM
JQ1ER9TYTyt0o1MEMVntVWRHEfDtZ7qTtXOHPTyjzrRyMezhu1sZNS/BQEmp
d832/QXvko6ebtOkPbKyqtdUVFVapkPKZMQb1G3i3cNj3BuGDFe2XnJbaPhQ
mBiIh5hHNK1f/HaTdNBO0K5ik0w8QzuWSPXUNfFKhuS9+V9D3KLsXt+0PLU6
A/PtVYLwu1zRmN6//B1fjhdpwxCR
              "], {{0, 21}, {27, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {27, 21}, 
            PlotRange -> {{0, 27}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1cbf4350-6d4c-4b3a-a2a8-aef36e0cff7a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a5c7a315-f2dd-4c58-a9df-5edb7df194ed"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0abc02a3-fdce-472d-b303-f7f9a28f54fe"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b18362c5-f883-412c-b0c4-0226f3813459"],

Cell["\<\
Find the total of 35 ounces, 1/4 ton, 45 lbs and 9 stone in kilograms.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"31c28789-079b-4a29-87a2-e054bf8acacd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f58eff40-4024-400f-8787-9f4e098872d6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVs+L6gYQXtpLjz313v+it9Jjr6/pVXiPbp8lsMVNoawX9SAehLAH8eLh
eXA9hGUfEtCFIOuyqBBBwYABWYKKSpCIRkyIJGBnEqNxk92+3l7bHWJIJpmZ
b775Eb999/ubX784OTmhvoLTm7d//nB+/vbip6/h5ucz6rf3Z6e//Hj2x+n7
0/Pv3n0Jym/g9z388Hr7Kq/yXxBj0hNk1fwnForIcw/3NVGSD0pLERrluyon
zQxXtZ70Rck9hrO1z5E56dWbVa7TFVfWTqNIBxNJGm9eiAiitZMkwXSXnwjc
mtUvSSJGEkn7fFng7bDjmyje2keoObLxG0Ka3CuJWKF97EmupGw95ZzpIRqt
WcpjQob72nMRnaQEeMT2Ph18LU1lJrZ9pxAG/6K2VXga3D6MoHzjKwhBcxa+
ycFTYW5uLdPC44knhY2GuD6WY9W7BvMbJHBdiRKXrAgl2JsERtyDTz8H3jI2
xkvttGpnbFdmM0PEokXdVg5vL2JkHGjUe/kYGZGeYg5kRAQMN4hBuSGJivRs
UDdiAHhrWsuSxFV1AIn3b2mndulEJE0ROWTjIPpcltrlLJJc0oEuikgzgvNo
0y86/nW8IJKpVD5DV6ptPRC1poAjlg5Bmp2ZudWwDWLURZ6OM0xpODefiXgM
vm9sDREfpa5XkH8DkVfag8WongNlojice8cNi+ukZmeNt3vwNmbs1c2onCYj
bJVrsjYPdHnjA99nwo6f5Ie6ncyAiYZyhetWo5TD5o+IamDEI/CVrlBJQOnz
ys5nKEYVnYJLH8OxVNlffMtQWgx0CNGcLgOZ94p8n/Ird34sY9LGns/eDo4e
qHxyNwj+iG5FDCG7n+4E0g6y6OZxghqi3OcgtUv20ePUOBDo9Gp33sKev3b0
k9s49rwFsQ5FX/AZP3jPQJl3USKJ68g8sKS13UHwR3Qz2oFPdbqIM+v09ryG
3R4F/sNXLO9tV8RJ0R1JXs3HzUIEXrsbGU57M/citFkWe4DfWo9wkWVq8lyZ
dEtpmxnwo/A52KUPI2MjoQnbEBeqIjXwGiiyBz8jjuTFVGBxkYZaMzMwopsg
zoiTyxBJw6LYiyIuTpXFXFmoy5V24HAzE5hUaL/S2cau1n027pYvLyN95pAv
HvZ8IiNp+7oQFdiQ1rLFuCaA/EN5AfMy5a8ShyXPdZUXItrM45yyPWceYfdC
oJI+LXu+FHgwjbG34paxXqnrJ4Ow0ZY+palrS/1o35q66pl9y1ip8MKRDTrX
njoPjBgkxgONy0HfmtCWljHIk05D/itkzSH/xYlqQL7uKnj8e7vPQ3RY757/
GPmP9cBPzOcsQLvu671XeZX/lfwFdeWkpA==
            "], {{0, 22}, {63, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{63, 22},
          PlotRange->{{0, 63}, {0, 22}}]], "ExerciseOutput",
         ImageSize->{67, 22},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "44344db9-e450-4efc-a01a-957bd0d388fc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVs+L6gYQXtpLjz313v+it9Jjr6/pVXiPbp8lsMVNoawX9SAehLAH8eLh
eXA9hGUfEtCFIOuyqBBBwYABWYKKSpCIRkyIJGBnEqNxk92+3l7bHWJIJpmZ
b775Eb999/ubX784OTmhvoLTm7d//nB+/vbip6/h5ucz6rf3Z6e//Hj2x+n7
0/Pv3n0Jym/g9z388Hr7Kq/yXxBj0hNk1fwnForIcw/3NVGSD0pLERrluyon
zQxXtZ70Rck9hrO1z5E56dWbVa7TFVfWTqNIBxNJGm9eiAiitZMkwXSXnwjc
mtUvSSJGEkn7fFng7bDjmyje2keoObLxG0Ka3CuJWKF97EmupGw95ZzpIRqt
WcpjQob72nMRnaQEeMT2Ph18LU1lJrZ9pxAG/6K2VXga3D6MoHzjKwhBcxa+
ycFTYW5uLdPC44knhY2GuD6WY9W7BvMbJHBdiRKXrAgl2JsERtyDTz8H3jI2
xkvttGpnbFdmM0PEokXdVg5vL2JkHGjUe/kYGZGeYg5kRAQMN4hBuSGJivRs
UDdiAHhrWsuSxFV1AIn3b2mndulEJE0ROWTjIPpcltrlLJJc0oEuikgzgvNo
0y86/nW8IJKpVD5DV6ptPRC1poAjlg5Bmp2ZudWwDWLURZ6OM0xpODefiXgM
vm9sDREfpa5XkH8DkVfag8WongNlojice8cNi+ukZmeNt3vwNmbs1c2onCYj
bJVrsjYPdHnjA99nwo6f5Ie6ncyAiYZyhetWo5TD5o+IamDEI/CVrlBJQOnz
ys5nKEYVnYJLH8OxVNlffMtQWgx0CNGcLgOZ94p8n/Ird34sY9LGns/eDo4e
qHxyNwj+iG5FDCG7n+4E0g6y6OZxghqi3OcgtUv20ePUOBDo9Gp33sKev3b0
k9s49rwFsQ5FX/AZP3jPQJl3USKJ68g8sKS13UHwR3Qz2oFPdbqIM+v09ryG
3R4F/sNXLO9tV8RJ0R1JXs3HzUIEXrsbGU57M/citFkWe4DfWo9wkWVq8lyZ
dEtpmxnwo/A52KUPI2MjoQnbEBeqIjXwGiiyBz8jjuTFVGBxkYZaMzMwopsg
zoiTyxBJw6LYiyIuTpXFXFmoy5V24HAzE5hUaL/S2cau1n027pYvLyN95pAv
HvZ8IiNp+7oQFdiQ1rLFuCaA/EN5AfMy5a8ShyXPdZUXItrM45yyPWceYfdC
oJI+LXu+FHgwjbG34paxXqnrJ4Ow0ZY+palrS/1o35q66pl9y1ip8MKRDTrX
njoPjBgkxgONy0HfmtCWljHIk05D/itkzSH/xYlqQL7uKnj8e7vPQ3RY757/
GPmP9cBPzOcsQLvu671XeZX/lfwFdeWkpA==
              "], {{0, 22}, {63, 0}}, {0,
               255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {63, 22}, 
            PlotRange -> {{0, 63}, {0, 22}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dd7f71fc-887c-4f59-ad9e-44ba0eee18bf"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"424def3b-3b2f-4396-96a4-988cca762674"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"fd7c2ebe-7861-44bd-899b-2af4e8227592"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"adb83892-f666-4620-8378-4dd3dd93eed3"],

Cell[TextData[{
 "Get a list of the distances to each planet using the ",
 Cell[BoxData[
 "\"\<DistanceFromEarth\>\""], "InlineCode",ExpressionUUID->
  "4fb6a8d6-c771-4674-8b24-664bc824b091"],
 " property, and convert all the results to light minutes."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"4c7f71f8-ee43-418e-95c6-41e929c7ffe9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"382bc26b-e440-4109-90e5-7fa72f600e00"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnd9rIkubx93dm73cf2H/gbne29ztXh14170bAu/LnnldAmePJwtLcpPk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            "], {{0, 72}, {407, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{407, 72},
          PlotRange->{{0, 407}, {0, 72}}]], "ExerciseOutput",
         ImageSize->{411, 72},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "50eda2e6-2c6c-4538-a154-9530893ba352"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnd9rIkubx93dm73cf2H/gbne29ztXh14170bAu/LnnldAmePJwtLcpPk
BZFDQBKQ7Bu8iBeaCyckiKABkSRHkhwMo6CQhkYaDRoa0YkRdVpscOtH/6ru
ak1mD3s64/MhMySV6qq2nnqe+tGd+v7jn/7zDx/+1ufzrf89+u8Pf/zvlZ9+
+uPGv/4D+uHfflj/jz//8P2//8sP//X9n7//6Z/+9Hco8Z/Rv//5G58Pfz8D
AAAAAAAAfk86Rx/e+Xwrvw5+7xsBAAB4PYPqX9G6cj/9yXsxTGnf1+TnKfl+
OlFfmPM3YX51SwjYAvAug0/7KIZ9saSoz63aTb54ddnsKdxLnh7r0kOXTRs2
q9fFQr4mttxzTruSIIn6l9Sa0OSRLKDqCnlBYssclUNr/lS1j/ziIuzfWgu3
3TqzmdOOqiiv94BF1bmDqpsov6H/UvpNHBYctlBkszHF+hP+/bBtpghN9D9u
fG4iBf9KHjlv2FEj2ALwMIMqDmLGNGwspbfW/MbXhcT4zuQhv0t/tR43Z25q
K7VpXrKXEVxyDjPrfkvhAXE0G4jZEPmR/h8v1M3KlNremj9zjx2ndhaOHWVd
54pmTha1FV/znzrTF7CoOnfExOrWUfn1181DSAVx+yTsxTYzG1ZLnaK4QQLI
FvMVG3ATZ7N2IWJeuLBGsAXgYb4wQayfweEo0sahq19MHDfZ8V/tlTNHsfiO
f2vzeKwnts+3UZ/Pi7h/tq/iF6Sj8nIOc5s0xE1VFX3Ra5EnxsjMYHgRwf71
ZFSm1Ha57oCZThTLndGcIk6ZjIbmoK0KRjq/kJH5K+v3XJiSXUCOE0oJ9guV
4cSWpL50kjB5yGpDw1nN9ivpLIAGCNRcpDG10uj3qG3phamS7JYol9KpKA5W
ObaF+TWCLQAPU//4wfdOC2JqJ0+G5uH8S5qZ4Na6EZpI3IteviBn9xS5jGTr
MMOBvpwZVGNoeiaM9N9YHKd5Hg5Fs7T7DaT8gTbHC+ztrIbCJ2My+ifPs9qE
cD0s9qYzpR43J37bolGs2khtBk4LWfrbUOSk3alpF25GJZLNrI5kzlzlmZKR
L0jp0HpEi/CKEF8PFB96xWiA1LUaMqaUz8JpeJUmZm4a2qc626Z3tRs9bht3
xUc+RTe5uXGw7t9NOYJYKrAVzrtdeXeIh4/BgsS6Y9bkUiPYAvAw1f0VFMQ+
k+/H9/GttWBNqt9lTvLnl02X7VkyB9BD0wh379NyXbpJ587SFVGek3MP972N
eGQ7lUo3e/bCReSVa1FzX8ziOHTWgb1PEVAhu4nL7nOreIj65GrxXlaVGnWl
ZKEkVdM4A3JAtS9cxVEfPkjla+XykzFy09tA91woC4Uo7cPxzLVYPkHV7ZLp
h1mdnjl5bikZNZR4bMZb/T6799ijQ9HjSvlafBwip0sSZxQeWgJZuxUfFXKh
P19tyNJ1KhIRn+eZRiILxrtH+WLHH+IGsbVgMrodP4zd3TPNPutdbzknTs5E
x/zKtcaltwXgWT4Lue98vpX9T/RHalb0FTuMHuDBMVDpca5iQpMi0E4bCkeS
kQDZ12rwc+KRdDWWOLm7Scdw4UHB0m3URzwJjJ0ze2Ks4+By6B1W6IUPJ3hj
TdH2YVIlGv+mxbB/K0LHbuxlOdsShmYu08x4m07f/FHym5rnmrftUjJ1HJF1
HFrCrr6EISOC//ZRmeG1Hp6FIq+k9588Lw8WLYdogyRvcHTCxZ7V2d9PK4kN
1ObFm3yGzDroIpEiovu3LszdEtkgNq/G5bYF4GV+9iHe/fJZ+5GatfhA50iN
uL5Lb8M5v4pfaYGrlli17vkzOa08l0LWLeXnMo6E4TSTk+c4KBKiuwodptuP
Qg4/tyIzNy3nUK80qE8VeDs5TGa8Taevm8zvrY7DLdnmOPqizFraTL6JsNvp
/gM8tZiKhSjdad87zNrijIVhfodMSxLxTCpKZiDBXKnllhnVq8UKTD/DWX7y
Epn2mVvjUtsC8DRfOr9+8PneJ7Uxd4L7w2pNmyANc+ucVQyiSfqV5jJqHcWf
2JXW283JvzPnbGqOeKPyrvGsqleO4al+3N6LtC3i4YwJhv3cDt6BCa2tHkSP
pWdLTt1B7N1eHHKK1T33ZY5jL5k4TlB7ckse/5mOc6aF/QEe/Y3GtDFtl9Nk
xcQZI7S7PD/OnB1nUiikxPbIxDVfZoKYarYmCWLh9MTyAe3PHLmJZHakt8/c
GpfaFoDXwXtiK0d62JFTeEZ03Ox1RbJ1kJeG3VIMb3c84F4y7tQlSSgeooXJ
dkUUmh3cJ8leVvBWlJ+kSzyCH16rvJy3UbopIT891jJ44F6960wnnWu6Gs2V
atJ9TaiW28ZGHFmoxjI1VY+NuCeTXnp6Ux88d596/cEzcYqRs3tro/8eLqHU
7bQGln2YlzkOrY5fMp2ypq5q3YcS3ZSmS5hiBDl1VOq02qhlRmShvRMTH7tP
HeHiLN1WZtJ5eA9NXXrDcQdPPg/OyQx2Kmy88638JWd9W8/CNK/7o2ELOtzk
y/Wnnlw5C+MZlD6OTKQTajhrEY5EBb88Vj6hW0xNUegq/BrBFoD3aaR/NDb2
Z/gBpRZVSPfGvYi+QZETjXhlzslDCdrluhfawyB/KHIsky7qzDl+LCV3zJfE
8lW8+MCLAnaeb5ktKHjfY81fG5Fsmydk9JdPN5n8+NEVcTFL9w5u7dDM01pK
e5nKWIbMmMxD4q2a41zsGI6jV+daskziMNk/PMJLEto+YzGtvfZG9nbGD5dG
Y26tb9c6U7l8smekhOO0rWZfqu/xsn7f5W0o49UUiy3U7m3CfE8slro23hwg
8Spo23yyJyq1PbbZzfZhawRbAN6HfU+MMh0/98fmyzPoxwUvXczwqzv6WDwX
VRkOXvCSj46CyrRmJq9hbEijKX79W1XEzDb2zbkPxyfP/cGi946+iimagQyc
rxihD8jcM27MAfO+PWle9pbqH9/73v31BY7D2kJF7dP///qrHLAF4FEGnCDm
Xbo3aOkUuJO6qjod0HeKHG9DvTnauR/R4J+sfl6c1UuALQCP4PzbSU+jyvmo
uVANhWPSb/m3xr8P00G73n4zFjABWwDe4ItwhIaejaPC5zfUAVVlPBrC4Qae
AGwB/P4Mcj+/9/nee/AsHgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAQF/VS4AtvAPYwkPI99fF82zl3uWQZNBXxdjlaNXnRuUqe3tT7nLP
qOEI4GKepNJtIVupNkx9MaUrlLCisSBZNEFAd5iPi0wzEYaWxAbnvPS5EsNW
YehJr2UxGf6SGY1p0B32LuIZOdGOnJx5kOGcWQ36qk452olEpYGpUliw5hB4
4gjgmk1Nropg3QG1c71nkRjeS5RQxwTdYXc4Ms3o3m51HTfBOaC4SAw7haEl
9rRP3P6WI9xBd9i7kCPxqZqqQA6jlpwn2y29vqpDjla5wEfQE2ngkRBDffuo
ZLuEI4BLdND2iF88leP0HFe1c7m7HqVDaiURoAploDvsDkemGX3USiaWjKy6
ndzIlRjmCUNPVUUzlpQJWksD3WEvM6HiXFS+rXPpOM2YAPqqGKscLXYlY5gm
k64ou+rjCOBOHtKodl0pj0gUsQIWg3JUl1kE3WE3uDLN5BNIJ6Y0kgsWieF5
wtBUIufAFBkE3WFP0y5smwO92ogtCmLLq6/KDLt9q1xUtxRl4gzBKYBLRdiL
j9QBiYza4TXNPO7JUjl7oK8xrYDuMIO7TDOj78bFKjE8Vxhaxk6xbew4ge6w
x8E+YspHKnYpHC0Z9FXtaweRyKDEE8eZI7r3tcG6D1cAlwhOrQUzmeM41VXR
5DCILpsmtMGsTUB32I67TPPCIMZIDM8Thm4lLaqsoDvsffBMzFSTdNlmBH1V
zkdQ0CCeOoycZi5FrLZmFyGyYBHAVVq3Z7FkNHJRrhWjzLCuKt07ohl0+6jP
LkB3eD6sTPOiIMZKDM8RhiabKhcP1JygO/wGmEgWUV0y386JLsvJJddXZeRo
GSp4p+XEtjXqKoCr0cC7Lnj0V8x0ss2reSXoDvNxkWnWenLAdSixSQy7C0MT
197QH2+B7vBb0B0m+2BbkbTca+Xxg7CwbBFy1fIsu74qR462WYjGEvl2p1U7
x8PZKZn8LxLA7eaj27mS0EVjNG5q7Cl3UXSfkYokD3qt20SQzgFAd9jNFlyZ
ZnUkS2K9dh4mbV6TJKwzaevDTt1hrjD0zL7BYgV0h72rOzyWsrv6Wze3D7jN
raK6hOXWV+XJ0TavYsaPVIl4tlgAt3txaLyJFLwlDjXp1FLa4yHzCRHoDrvZ
givTTPd2zC/ixbY+zNMd5ghD6x+TG8RAd9jb+o/qcDDqj82ZulNUF/RVHRB9
2zGz/7lYAFclSsS2TVPVfqvzWXZbvEym+bcUhnZn2W3xpgF9Ve8AtvAOYIu3
BOiregewhXcAW7w5QF/VO4AtvAPYAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAArzA4WvH5fCsfhTf9x6agRuodwBbeYVls8bld3X/v873/
+BV/qNkVy7eF7F21bjlltC+WL4uFvPg4TxQPK5maUqR2Zdg5aqScGmegRkqx
qfSy2q8dfG7M04PANmx97Lhzjkovp3D3RLCFm34xqqjXEO/NNh88CneFbPHq
en70YJyFWzgoJqPG/PVnn2//ledlKETu0L+7Q/70PponR8HXk+SMvj1yvFuq
xFcGn0hp4wy6GU8Z1kWNlFejdi/LrkbqVOml5w+bbYjPsrMJyGJL1dgTq5y2
4BfukkjrXWZbzNMvnrWI4Ism1EtODNObei1Q6fA91+os3MJBMZkyqO6jIPa6
GslB5VROdFCNU9OQozIDVEcGHyBvKolY0U+w3NFOmHQqw/LVSHk1aiy9GqlD
pZcKvQWwwrhqkYvVvp9qkoiRLFMd3xacwt0SSSFLbYs5+sXaAKEddYj1gzRF
XSLswghTmjDOwi0cFJMpXxXE8KdOlkn74E9qBLEobcOnEhqpOUGMmnIXi4ri
s3wXKMNa1Uh5NWqAGinGqtJLbRGUXDoN0Xrw33WYxLm2qPNGal7istuCr1+s
EinwvcPI7lpQSxn1dcccZlyCmM1ZXAoHxWT62fdffw52Nx/Gx2tXpJaAJ8YR
WUWj/yUWOomm2x0BjSC7iZLtGirGd3AuSGj4IKoKc5RhZ3Y1Uk6NTmMtrxop
O+zSy0PhcDwayRXK7NnvREfJ0s6adebYYp5GmGvi8tqCYNEv7uJ573r8aYTa
wS6XTHVFQ44g5nQWl8LdE5fJFmQm9l31ldtp8lXY2F3Zo+ImRJ7A2G/Rx3SD
LpaAj6RRY7TRInH9WNUtyFOGndnUSF1q5BprKdVI2ZAyeciiQT9TyN9myOaV
ZeVIZwXFR6e93W3x9UFsKW3B6hcTKXA6AUMriIBtekx+i9WX2AK4zsIpfF7i
UtmCiJJ8t194+WSMSlldiF111Lg4DJK6prWj1a31WFuZPkmXeKq5zowUVEdm
KxzNncViONYFkok0nk25KcMyaqT8GucYa+nUSN03QEjwNycATew19kFcL8TF
Fv+3ILZ0trDoF9PYgoeGs/jpER6FY4exyqP+tB0rxPmTVw1bAa7OMnMRRwbF
5Nnsl7/4EL+8+AllE++3R/UW6+MgmbpFMdmYIKlifIudOXer2UzqOJeKI2vG
qV1SWZkJp4YyrPERDDVSbo2siy25Gimr0qtatj2fSlGLLeg68XLRnIKxBV8C
mJsItmD1i9VeDfX5HBXSTWhBrEaCmEwiWCzDKc3VWbjiyKCYjHN/+s7n+5D8
9PIFZRf7hf/0ShgrSruMJ3in1TZW2Fzbrjx0J0r3Diu64hBkV9QlNMkMmYoq
OpVhKTY1Ul6N+mxi2dVIHSq9I/JAJHUp97rtKra1ZZHODHYzRi6WawuOBLBL
IthiNk+/eEYfSAVE8qHaV3Q3KVwTBfG+LFQF9GHnOwu3cFBMpiUPPu37fO+F
1+2JTY1nBHg0OSvhj6g0Tk2J0mBRxHfuUNQlnyVjKI1ylGH1z2tTI+XVqFtr
qdVIOSq9z83Ssfme2I72zIiAdxqtQcxiIJ4teBLA/ESwxQL9YjotoVPifo5t
EDpVnu8s3MJBMZnyVU8nCaqC5TIVW5pTZHOBzChXGfblNRJAjZRT73iE2mrh
4MQY6BW2cAVs8fW39xLp3tewLLb4mvfEPA+okXoHsIV3+CZtMcPz4m8wiIEa
qYcAW3iHb9EWiM+Fjdf/7eQbAdRIvQPYwjt8W7ZofEr/uOLzfUh/C+EYAICl
48vHD+987z4UGm9wYgwAAAAAAAAAAAB4hv8FQKz42w==
              "], {{0, 72}, {407,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {407, 72}, 
            PlotRange -> {{0, 407}, {0, 72}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aa890ae2-7901-440e-b461-3b02ef42d4d2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dd9452f6-b8b7-47c5-bf21-4765694cb3d8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0ad71d5a-7a6b-4d02-81ef-2060bac5a08a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5f6dcd2c-715e-465c-bd8f-4383519e8abf"],

Cell[TextData[{
 "Rotate the string ",
 Cell[BoxData[
 "\"\<hello\>\""], "InlineCode",ExpressionUUID->
  "d103414e-d2c0-498e-8134-74dd8ac76690"],
 " by 180\[Degree]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"24f1e3dc-2282-486c-a0f7-1ca6ce25151b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ea633e42-8dd5-4c41-95ee-08a7b27ce365"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztk69v3DAUx6OODFYaHtg/EFxqWBSpU5lJq95VJbfT3aQpNCwwzMwoyMjo
kElQiIlJSEBISECAiUGA9+z8mCbluqrq2H2lJH7Pz598/Zx8e/xxt70KguD4
GW53D7/Q4fAQf7+G4H53fHnebZ5udz83z5vDzeMnSH6B6ytcbmwv+p8a+lqw
nNBcqGbMdPJECFPdYK2RnBJWmrFStwXPCaFMyH5e3lWlrOdIN0Uh+8GamoeB
U+gfUVoAS0viMmkJ2FPsJojSkCZuGEYR8gvi2r1MZzB2lZ4qU4hKbWkEz7jy
biTdQsBctaEoQJn0FhWUZN6d6fvJdisgGRHl3rVUQqDAD5LawizOq3kLJfhI
RPtXsZFowpq2mdR2NYGViOgzWMcpuhlbOOu8WcfqcmzXH0VU+84sWDNjY5jd
smFK0sAR9CtYPlnoMwj2p8EOAhCIjs1pOAQRAGq2BxROcsHdtsB7632vNcGj
UCJkSffu1HJ/ZsqtCzMmeIb9HrDzZQfJUjTuaZtV05eyirVDJxPsOxFiJpfW
VemYxNmJJ6PbM1rH/lNLbz8WO34J5XlsjheswtPv8EYsVuYttRe9U78BBzpX
1A==
            "], {{0, 19}, {29, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{29, 19},
          PlotRange->{{0, 29}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{33, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c1adc574-a33c-40a3-b5c8-af467774f45b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztk69v3DAUx6OODFYaHtg/EFxqWBSpU5lJq95VJbfT3aQpNCwwzMwoyMjo
kElQiIlJSEBISECAiUGA9+z8mCbluqrq2H2lJH7Pz598/Zx8e/xxt70KguD4
GW53D7/Q4fAQf7+G4H53fHnebZ5udz83z5vDzeMnSH6B6ytcbmwv+p8a+lqw
nNBcqGbMdPJECFPdYK2RnBJWmrFStwXPCaFMyH5e3lWlrOdIN0Uh+8GamoeB
U+gfUVoAS0viMmkJ2FPsJojSkCZuGEYR8gvi2r1MZzB2lZ4qU4hKbWkEz7jy
biTdQsBctaEoQJn0FhWUZN6d6fvJdisgGRHl3rVUQqDAD5LawizOq3kLJfhI
RPtXsZFowpq2mdR2NYGViOgzWMcpuhlbOOu8WcfqcmzXH0VU+84sWDNjY5jd
smFK0sAR9CtYPlnoMwj2p8EOAhCIjs1pOAQRAGq2BxROcsHdtsB7632vNcGj
UCJkSffu1HJ/ZsqtCzMmeIb9HrDzZQfJUjTuaZtV05eyirVDJxPsOxFiJpfW
VemYxNmJJ6PbM1rH/lNLbz8WO34J5XlsjheswtPv8EYsVuYttRe9U78BBzpX
1A==
              "], {{0, 19}, {29, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {29, 19}, 
            PlotRange -> {{0, 29}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"af93bb14-84dd-48e7-ba3f-db567beb155c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e1c5e1bb-efae-4c63-96f5-b2e0975aff7c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a633fa5f-8b30-49b3-8b28-c4a591f9ed01"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c74f9839-e4f0-4d04-b6b1-e3edde576c0b"],

Cell["\<\
Make a table of a size-100 \[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote] \
rotated by 0\[Degree] through 360\[Degree] in steps of 30\[Degree].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"e87e94ee-d2f0-4636-84b2-d8213eeb5c67"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3c88c979-c0ec-45e0-bb5c-f3d1af1a54eb"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvS2ztEy351nTbUbOV+gvgB6LHEVET7TDdMccOtqcIU5PRAcWh8ThUCgU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            "], {{0, 302}, {421, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{421, 302},
          PlotRange->{{0, 421}, {0, 302}}]], "ExerciseOutput",
         ImageSize->{425, 302},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3331d8ec-963a-436b-9ceb-57c144b62736"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvS2ztEy351nTbUbOV+gvgB6LHEVET7TDdMccOtqcIU5PRAcWh8ThUCgU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              "], {{0, 302}, {
              421, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {421, 302}, 
            PlotRange -> {{0, 421}, {0, 302}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"518b6e9d-fd75-42bc-920e-1ee978551e22"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e5ee581f-4f92-4698-b3ef-0c8411629503"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8dfa8388-986c-4c34-82cb-46ac32bdcd75"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4b7c5c47-d3a6-4c29-9bf0-52c25de251b0"],

Cell[TextData[{
 "Make a ",
 StyleBox["Manipulate",
  FontFamily->"Source Sans Pro"],
 " to rotate an image of a cat between 0\[Degree] and 180\[Degree]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"478098f4-0a0d-4e0e-81b2-e57824e0feda"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"87d35928-c435-4ab4-a8e9-3fa46fe685db"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvQdwY+d5702rbeWyggTRe++9dxAAUQiikARB9E50ECBIAARJsHfuapu6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            "], {{0, 196}, {247, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
            Association[{
              "Exif" -> Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com"}], 
               "Comments" -> 
               Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com", 
                  "Creation Time" -> 
                  DateObject[{2017, 7, 10, 15, 22, 27.}, "Instant", 
                    "Gregorian", -5.]}]}]],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{247, 196},
          PlotRange->{{0, 247}, {0, 196}}]], "ExerciseOutput",ExpressionUUID->
         "db8c7ea0-922b-406e-b5ad-5c3d4904205f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvQdwY+d5702rbeWyggTRe++9dxAAUQiikARB9E50ECBIAARJsHfuapu6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              "], {{0, 196}, {247, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True, 
              MetaInformation -> 
              Association[{
                "Exif" -> Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com"}], 
                 "Comments" -> 
                 Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com", 
                    "Creation Time" -> 
                    DateObject[{2017, 7, 10, 15, 22, 27.}, "Instant", 
                    "Gregorian", -5.]}]}]], Selectable -> False], ImageSize -> 
            Magnification[1], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {247, 196}, PlotRange -> {{0, 247}, {0, 196}}]], 
          "ExerciseOutput", Magnification -> 1, CellFrameColor -> 
          GrayLevel[0], Selectable -> False, Copyable -> False, Editable -> 
          False, ShowCellBracket -> False, CellLabel -> "Out[]=", CellFrame -> 
          False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"eb1ec50a-1078-4f39-afa1-7787ee2ab6e2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"149ee13b-7bbb-4b54-86a4-754fca805b27"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c249f4b7-f336-4001-9c72-e1040e4cd510"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f01de197-6e08-41cd-ace2-a87918a86e75"],

Cell[TextData[{
 "Generate graphics for a path obtained by turning 0\[Degree], 1\[Degree], 2\
\[Degree], ",
 StyleBox["...", "GrayPointSix"],
 " , 180\[Degree]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"8307af23-cc2f-4e21-8b38-a75ec798bfd2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c9e3bb2f-2979-40ed-9f27-193d3b651b6b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnQc8lf3//30bd3dDZIaEKDszLRoiDZpKtHcU7XmnIQ133UWDtrS1lLu0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            "], {{0, 330}, {
            360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 330},
          PlotRange->{{0, 360}, {0, 330}}]], "ExerciseOutput",
         ImageSize->{364, 330},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f298c203-079c-4093-886b-1bc62f506551"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnQc8lf3//30bd3dDZIaEKDszLRoiDZpKtHcU7XmnIQ133UWDtrS1lLu0
aA/aoq2hpRKlSaL/6+f6fc///A6Oczh8ztH7+XjkcZxzjfd18n59Xu/r+gy9
YeN7jaoiJyc3+U/86DV0evtJk4bO7K2IX/r4TfYe7TdyRGe/KSNHj5zUYlhV
vNnlP3JyY/Dvf17/IgiCIAiCIAiCIAiCIAiCIAiCIAjityE3Nzc9PZ11FARB
SDUvXryIiYlZsmRJ//79mzZtWqNGDSUlJXV19bZt244ZMyY4OPj48eOpqams
wyQIghlZWVkXLlwICwvz8fFxcHBQUFCARDg5OU2aNCk8PPzatWvfv3/HZi9f
voyNjV21atXYsWMdHR01NTVr1aplbW0NbVmwYMG+ffuSk5N//PjB+moIgpA8
KDqSkpJ27tw5c+ZMV1dXHR0dpL+dnd3w4cNhJOLi4kQvSSA4CQkJW7ZsmTFj
Rvfu3Q0NDf/444/GjRt369Zt2rRp0JzLly9//PixXC+HIIjy4Pnz50eOHEHR
4eXlZW5ujqIDCe7u7j5//vwDBw48evQoPz9fUueC37h79+7+/fsXLlw4YMAA
W1vb2rVr169fv3379t7e3itXrjxx4gSKIEmdjiAIiQAPcP78+dDQUOSpvb19
3bp1kbbOzs4oOmAMrl+/zhUdFQmEAnIB0UBIEBDEAzGBpEBYIC8QGUjNly9f
KjgqgvjNQeqhUujatWvDhg1RdDRv3nzEiBEhISGnTp16//496+iKAMULShgU
MihnUNSgtIGSDBky5MmTJ6xDI4jKT1JSElpwCEVAQEBUVFRKSooEi46KJDs7
e+7cuUpKSiNHjkRhxTocgqicwEjA9quqqqIkycvLYx2OZMjMzJw1a1a9evV8
fHxevXrFOhyCqDzk5uaiBlFRUfHz80OisQ5H8qSnp0+dOlVRUXH8+PFv3rxh
HQ5ByDzHjx83Njbu2LHj3bt3WcdSvrx9+3bChAlQj8mTJ1NvVYIoHQ8fPnR1
ddXX14+OjmYdS8Xx+vXrcePGoXKZMWNGRkYG63AIQmbIysqaMmWKsrLy0qVL
f88Omc+fPx89erSSkpK/vz91JCMI4eTl5W3cuFFdXX348OHw7azDYczTp0+H
DRsG9QgICPj06RPrcAhCGjl//ryVlVXr1q1v3LjBOhYpIiUlZeDAgSoqKosW
LaLeYgTBA7bcw8NDW1t79+7drGORUu7fv+/p6ammpoba7du3b6zDIQiWIAXm
zJlTr169efPmUTqUSHJysru7e/369YODg7Ozs1mHQxAM2Llzp5aWFppRGvkl
Frdu3erevbuGhsaaNWtycnJYh0MQFcS1a9datWplbW198eJF1rHIKtevX+/S
pQuKu3Xr1uXm5rIOhyDKkTdv3gwbNgxOe9OmTTI6tESqiI+P79ixo46OzubN
m3/+/Mk6HIKQMHDUQUFBSkpKU6dOpaeKkuXChQvt27fX19ffvn073fcgKg2H
Dh3CX3W3bt1SUlJYx1JpOX36dOvWrceOHUuPawlZ59mzZ87OziYmJidOnGAd
y2+Bj48P1CMrK4t1IARRSg4ePCgnJzd//ny6cVeRwHI0a9asUo4dJio9N2/e
VFZWxk/WgfyOTJkyxcLC4t27d6wDIQgxSE9P19bW3rdvH+tAfl/8/f2NjY3T
0tJYB0IQIoGqxMHBYfbs2awD+d1ZvHixvr4+dasjZAIfHx9XV1fqniENBAcH
6+rq0gTIhJSzcePGJk2aUA8N6SEsLAw148OHD1kHQhBFc+nSJRUVFfoTlTbC
w8M1NDSSk5NZB0IQgrx8+VJTUzMmJoZ1IEQR7Nq1S11dnR5vEVJFdna2jY1N
UFAQ60CIYomKilJVVU1ISGAdCEH8LwMHDuzXrx/rKIgSgBtEIXn+/HnWgRDE
r+XLl1taWtLEOzJBXFwcpAM/WQdC/NbExsaicE5NTWUdCCEq8BuQDroTRbDi
8ePHampqZ8+eZR0IIR4JCQn4j4uKimIdCPHb8eXLF1NT0zVr1rAOhCgNN27c
gFGkuaCJiiQ/P79nz54jR45kHQhRepKTkzU0NLZs2cI6EOJ3ISAgoGXLlrIy
L252dvbOnTsdHR0nT54cGRn57Nkz1hFJCw8ePGjQoMHatWtZB0JUfg4dOoQ/
NpkYawk3PnbsWCUlpY4dO0ZHRy9atKhHjx5oZFHdu7q6Lliw4Pjx4x8+fGAd
JkuePHmiq6sbHBzMOhCiMnP37l0VFZUrV66wDkQYGRkZK1eutLCw0NHRmT9/
fuHHPS9evNi/f/+0adPatWtXp06dJk2aDBgwALskJCTIiomSIM+fP9fX11+8
eDHrQIjKCZpm/IFt3bqVdSBFk5eXd+zYsb59+9atW9fLyysuLk6UYbnYKykp
adOmTaNHj7a0tKxZs6adnd24ceNwmbDxv8nAXrhHY2PjOXPmsA6EqGwgv+D2
J06cyDqQInj69Km/vz+qJ1tb29DQ0LIs4/7t27fz58//888/Hh4eMPCKiorO
zs6zZ89GmVO5V7t+9+5d06ZN4cFYB0JUKqZOndqhQwepWqfj+/fv27dvb9++
vbKy8vjx42/fvi3xUyCbDh8+DFFycXGBhqDw6dOnz7Jly86dO/f161eJn44t
mZmZNjY2vr6+rAMhKgm7du1C45uRkcE6kP/l6tWrY8aMQSJ36tRp7969FXZT
4uHDh1AqZFbz5s1R0VhYWIwcOXLjxo2QrPfv31dMDOVKVlaWlpZWWFgY60AI
mef69esqKipJSUmsA/mF3FyxYoW5ubmenl5gYODLly8ZBvPjx48rV66sXr16
4MCBhoaGEDGUSAzjkRQ3b96Uk5P7zR8zEWUERl1bW3v//v0MY8jLy4uJiend
u3fdunWRpKdPn2YYTHHAjEHNli9fzjoQCTBq1CjUfayjIGQVNKn29vYMb7On
pKTMmjVLU1PTzs5u3bp1Ur6i0IsXLxo3brxw4ULWgZSV9PR0OMx79+6xDoSQ
Sby9vd3c3Cr+WeS3b98iIiLatm2rqqo6adIkGZrjLi0tzcTEpBJM5x4cHOzi
4sI6CkL2QHOjoaFRwQ9Q4uPjR44cqaCg0LVrVxRHMDwVeXaJgMbawsJiypQp
rAMpE7m5uYaGhocPH2YdCCFjrF69evDgwRV5RhQjcnJyixcvfv36dUWeV+J8
+PDB1tZ27NixMt1t7NixYwYGBrIo3QRDOnbsWJG3Q9esWWNjY1NpFpP99OlT
69athw8fnpeXxzqW0gPXt2zZMtZREDJDVlaWvLz8ly9fKuZ09+/fV1ZWloY1
FFCXwS08f/48OTn50KFDZcl6fHvt27fv37+/VHWWE4sHDx7g/4WWmiVEJDIy
skuXLhVzLngMa2tryY7mRqpmZmampqYmJSVdunTp+PHje/fu3bx5c3Bw8IIF
C6ZOnTpmzBhktJubW7t27XD2xo0bq6ur16pVq0qVKgoKCg0aNDAxMbG3t4fp
KktPhu/fv3fq1Kl3796y6/YnT548YsQI1lEQsgFyqsKmZfjrr7/gh8XdKyYm
pnr16p6enl5eXq6urm3btkX6ox5H+tesWRPpr6ioqK2tbWpq2qJFC2dnZyTv
kCFD/Pz8cLqgoKDQ0NBt27bBUZw6deratWtoWNPS0gr7q4kTJ+rr69+5c6fU
V5eTk9O9e3dEmJ2dXeqDMATOU01NjdZeIUoEjXW9evVevXpVAeeCGcCfpbhD
xiIiIrDXvHnzwsLCtm/fHh0dffr0aaQ/Kh2kv2RHjmzdulVFRQUKU+ojwFD1
7dsX2iWjs76vX7/ewcGBdRSEtIMmuFmzZhVwos+fP+vq6iLrxdpr9+7dGhoa
cAjlFFVhrl69qqWlFRAQUOrnI3l5eYMGDYIpwiVLNrYKAMFbWFjs2bOHdSCE
VDNhwoQFCxZUwImGDh0q7iSlUVFRqEQk2BMMZuDgwYMlWpQ3b960bNmyV69e
pU58aA4uFgcpyzB/Vpw7dw5F3/fv31kHQkgvjRo1SkxMLO+zQAFwIrEe2cTE
xKA8uXHjRtnPfu/evZCQEFdXV3l5eZjwxo0bw1QI3yUnJ2fEiBFmZmaPHz8u
9Xn9/PxsbGykZ2Sx6PTp0weOi3UUhJSCplxHR6e8z5KWlgYFiI+PF32XuLg4
VVVVsXYR4O3bt9u3bx88eLCmpmbDhg0hApGRkdz497179+LgcFklPjNds2YN
tjx58mSpw5g+fbq5ubnMzQL07NkzZWXlFy9esA6EkEYWLlyINrG8z+Li4jJ3
7lzRt79w4YKKigrcsrgnQgEClzJx4kSkat26dXv27BkaGvro0aPCW7569crJ
yQl1RIl2AmHUr1+/LENf582bZ2hoWDF3niWIv7+/l5cX6ygIaaR58+axsbHl
eorVq1fb2dmJ3jU0ISEBTbzoUeXl5WGXwMDAtm3b1q5dGz+hG4MGDSrxJkZ+
fn5wcDBa1U2bNgnfMjU11dLSEscsdcn/999/o0yTrSUy8QVqaWldunSJdSCE
dPHmzRtFRcVy7aQkbtfQmzdvQjREWc80JSUFXqJXr14KCgpmZmbQCuyFgsjD
w0NfX9/d3R3HmT17dokrONy5c6dp06bdu3dPT08Xstm3b99wZFtb21JPH7Rq
1SqUSwi7dLszAYUeLlmmx90QEmfDhg39+vUrv+PDY1hZWa1bt07E7ZOTk9XV
1YWsZJqRkREZGTlixAhdXV0NDY3Bgwdv27YN6sd9ij9yaMW0adPgCmBCIFY+
Pj4QRmwmfDJSKOf06dNRjBw5ckR4hEFBQTjvxYsXRbwiAfCFowWXrZkuWrRo
ER4ezjoKQopwdXXdtWtX+R1frK6hSHOkZOF4srOzT548iby2trauU6cOYg4J
CRHo0vnixYvOnTubm5tfv34dv54+fTogIICrKTIzMxcvXowjd+jQAYZESNN5
7tw5HR0db29v4QXO0aNHoU7r168X8boEgNBBoKRhGkYRuXr1KgKWxY4oRHmA
7JCXly+/3gVolGEeRHyO8OTJE21tbV67huy+ceMGGndnZ+fatWu3atVqzpw5
58+fL3yTBFuGhYWhFAoMDMwtAGKFv/MhQ4bgJ0oDrr83HAUS1tLS0sjICP6n
uNsUWVlZAwcOLPEpLSQOx4GZKV2Jt3fvXjU1NU7iZAJ8mdBt1lEQUsHBgwfR
BJfTwcXqGgq3gI15s2pDPeTk5AwNDceNG4cghcwWiPx1cHCAkb579+6vgkeH
eN2pUyduROfNmzdhTho0aIAj8xIcVsTNzU1FRcXf3784TRPlKe2nT59wcJy9
dKNHDx06hFNcvny5FPtWPGlpaUpKSmXpx0JUGoYNGwbDX04HF71rKP4m9fX1
eSuWIsHhUq5duyZ8L2Q03Aj+mHEJ3OD3yMhIuI7ly5cLVCJXrlyBkjRs2HDj
xo08uwLBQT2ioKCAOIvsjCrKU1qcCOIDm1Q653Ds2LHSPWtmAmq9Hj16sI6C
YAxyDe1dOa3VfuDAAUiBKF1D0VgbGxvzr1W6detWJKzwvRITE62trbEZFz8K
LmiggYGBkJ6lly5dgrlq1KgRjs9zERkZGQsXLkQ5g2ro6NGjArvwntJCcIQE
s3//fqR/6W4TnTp1Cs5KJgbdo9zT09OLi4tjHQjBkosXLzZt2rQ8jix619DM
zEzEIDB9uoWFReEU5pGTkzN79mzk6ebNm7l3bt261aRJExTgosjU2bNnUVlg
+507d/Km6MExIyIicF4o2IYNGwRufdy5cwcfCX9Km5SUhDpr2rRppZj2p0aN
GiU+xJESoqKiTE1NZXdWIqLsTJ8+vZxm4Raxa2hWVpatre3UqVP530T7a2Rk
VNwu8Az4tGfPnrwuGShS4AcgAiLGhpYdFgUOAWlet27dwYMHe3p6tmnTRktL
a9SoUWhMu3btChsGKeO/9SHKU1pYF0dHR1y7uNP+BAYGSucivEWCa1yzZg3r
KAhmoG1F4S/xw4rYNRTeoGXLloVXJnV1dS3y+Sa29/PzQ+bu3buXewetf5cu
XZo1a/bkyROBjZHCMADbt2/ftGlTQEDA6NGjcVgrKyu4oGrVqikoKMgV4O7u
jnfU1dW3bNny4MEDbBAZGfmrYK48bk1J1D78T3tLfEqLhnjChAko0LibtCKS
kJBgZmYm+vZswRcLXYVRZB0IwYBHjx5paGhIvBPgvXv30PoXORiEn2/fvrVr
127kyJECASBh8TdZ+AnpyZMnkbDwBrw/19jYWCUlJaQwMn3FihVTpkzhbANy
FrYfKV+zZk0oA6Tpr7/+Cg0NPXTo0OXLlxcvXgybjW0WLVrk4+PDdXiLjo5G
GWJtbQ2dwUc8xXv//j2cAFSlY8eOx48f594U5Snt1q1b8SWIPu0PShtIGa/r
mvQDbaSlqH9Pli1bhlZYsseEmUf2ldg1NCcnB5mI7Ct8KwCtvMC9Dnj+oUOH
NmzYECrRq1cv2AZLS0vOLdSpU6dFixbQAbweN24cXArkJbkAlDO1a9eGi+C2
hLB06NABL7p167Z79+7Dhw+jTofgyMvL46PNmzcj5nnz5nE+pHfv3gLR4jjm
5uYmJiYbN27kuoKU+JQWqtKgQYMNGzaI+NXh0rZt2ybixsx5+vQpfBrrKAgG
oGmW+L24WbNmIa+Fb4PW3M3NrU+fPoUzDu07fAL/XQVkNwoTaEJKSsoff/yx
cuVKuf/yZwFVq1aVKwaoCv+vKioqrVq1at++PSQL1U337t2hDy4uLvhowIAB
cD6wLqiDYFrwDlL+1KlTAuHB4WBHbq7Cz58/c09pIVzFPaVF9YRDifjVhYWF
DRo0SMSNpYFGjRrJUH9XQiKg/EdTK9lZc0XpGgqtgGKg0S/ysSOKgmHDhnGv
Ydrd3d1RDnDDQOAHkN1ILmTi33//jfhRL6DYQRvt6OjIO/i5c+eaNGnCLxfc
kpGc2eDdqeDPdJiuUaNG8YdhZmaGUxsYGKCSOn/+vECQKMQ8PDw4QUCRxd2V
Le4pLbRLxC5hqOw0NTVF2VJKwPdWORbUJkQnIiICxliCB/z06ZOuru6///4r
ZBtkGXIfTXyReoVyALLDpTbCQxUwc+ZM3paItlOnTtWrVxcoq62srPhd065d
u3jugnfzE6BemDhxIl5ER0fPnTsXL3g3H6A/cBf8693v378fG6A+Cg8Px0U5
OzsLdOmEEPHnOO8pbWExhKkTfSoAHR0dse6msmXfvn2dO3dmHQVRocCio2aX
4AHHjh07Y8YMIRtANEaMGIEyobj5vREPKojU1FT8tLS05J+E/8aNG0jk/v37
29ra8pcPZ86cMTQ0xJFhcmBCOKeBbVAr9ejRAwURjAGkBtsgzeGvOCUxMjKC
vEBweMc5fPgwXDcvMKQ/Z1R+FVRV69evb9iwIXKE138Vb6JE4r8Q7GJvb194
Sj18LStWrBDlCwT4fsqv767EyczMhJuSie5qhERAy163bl3hE02Iy5QpU5C5
QjYYP3782rVrhVRG5ubmyDt4/sWLF/M/w0Xe/fHHH3j/48ePtWvXRvC8j9zc
3FDaoKHH5aDAQaOvra3t6emJHMdmXN2EsgKb1ahRo379+lAD7iYqd/cDgsDr
pOrl5TV58mTekfv27YtteF1EcLTQ0FCIDyqsW7du/SromSbwPAXFzpIlSwQu
CpfMq7xKJDIyssS7Q1JFs2bNIN2soyAqiKNHj6JxlOwxS9QNlAn//PNPcZ+e
OHECedqqVav79+/z3nz37h1qk+bNm6Oy8PPzO3DgAGoc7qP4+Hgu/bW0tCAs
qJKgS/gVedehQ4fv379//vwZth/v4LxhYWEQHG57HN/a2hovqlWrxr0DnUHN
AseipqbGkwK8AwkaM2YMf5AQPfgB6A++PRRcvN6qHPPnzy/ciQ7aJfrqEhkZ
GVAzGVotF4VkOfUbJKQQtIyrVq2S7DHLqBuoTZDC/H05YmNjNTQ0Zs2ahTxy
dHT8999/vb29g4KCNm7cCHmBweCyHtVHlSpVuNfcsxV4jNOnT3NjaXn3N9q0
aYPK5T//+Q//lkBfXx+Cg+MjYSFQcDVcJwpIBCoRHLzwxFxfv37FjohEoIfn
hg0bClsLCFrNmjVF7yQDTSt8J1ZqQc2IL411FEQFMX369EWLFkn2mGXRDa6r
GEoJ7lcIBSKEaHC3MmAeatWqdfbsWS7fkf7R0dEoMapXr4734SvWrFnDdfHi
oaSkhJ84IPcrzIaurm5SUhJvA39//8aNG/N+vX79OoqgnTt3NmrUCL+2aNEC
3w+sy7hx4zw8PAoHjG1iYmIERt7hHZ4d4ge2p8RecDxw4QLdV6QZqCv0VhaX
hiFKwcqVK8eOHSvZY5ZFN+B/kCzQgV8FT0htbW27du3KLVWAv8ypU6ciT5H4
+Ml7yIt01tPTU1BQwLVATFRUVFBloEJRVFSUKwp+lUCFAuPBLzVeXl4/f/7E
3/+lS5egOQcPHvT19YUocZ8WnrEQR3j+/DmMDf+biYmJRfYVh/6gwhLxazx5
8iTclIgbSwOQStGvjpBp9u/fL/FZFEqtG+np6Uh//ESG3rp1C8YDUsD71MHB
QVtbe/LkyagCeLPx//jxA7t06tQJP3m3KVBuQG0QQ5G68ccff+CnsbFxkZ/i
IBAfCBdeBwcH29nZ5eXlffnyBfICTZP7vwUUgOagWuHC5r0JoatXr17hC5w5
c+b8+fNF/Bqhk9ArVDcibs+cZcuWoX5kHQVREcTHx0t8KdhS60ZAQMCIESN+
FZh/IPCQAh+pqqpevHgRBoN3H3Lr1q1o2dGOV6lSZfjw4fwKIC8vL1dw14J3
A4SnG46OjgJygTTn6YaJiQn3mutlioJlxYoVOMXq1avxq8BTA5wlKysLmiYw
EwXOUnhkDcofd3d3kb/IXyh/yrKedQUDqYeXYx0FURG8ePFC4l0TS6cbaF7h
9rnOTkg6c3NzgfG52AVpiyKCf9UwCwsLOBAkOPIXlkCgNmnXrp1cQUfxIq1F
iUDHuHspYMuWLc2bN2/btq3A3T8ITkZGho+PD2+CMg6oTeFbGUlJSYaGhqJ/
k0FBQePGjRN9e7bAiaFIRNXGOhCi3EEaooWV7NQrpdMNWAiUG9zr2rVroxIR
WPwoLCwM5cCNGze41Pv27dvIkSOxZa0CkNrQDf5+oZJiwoQJSIePHz/i9V9/
/QVBO3jwIC8qNTW1N2/eIDa4Hf5o4UAK92fIzc2tUaOG6Es1Xb9+Xcj0I1KI
p6en8MnQiEqDhoZGqVcOKpLS6YapqSlv0VWk/6JFi5Cw/BsMHDhQruChJ9cE
o/AvMeVhYIR8qq2tLVfQC517SsvzKvwPbeUKnsjAVCAddHR0QkJCjhw5Ymxs
zBu9C7eGb+/ChQt2dnb80fbr12/Hjh2Fr523NIMooAWXrSVZIf5FPnUiKh+2
trYJCQkSPGApdOPEiRP8DyCQy9HR0QKTq6PcQGrb29uj5IdBGjNmTGEpwKmF
awWPwMBAPz+/zp074/XQoUP5P1qxYoVcQbcx/OTOUqVKlapVq0JAOEeEGHg9
8yEmT58+zcrKgufhv2U6adKkpUuXFr72/v37i7VoEf/NHOkHEgeho9Xcfge6
desmZEG0UlAK3UA+8mdH/fr1nzx5wj+rw4MHD6Abzs7OyGI4DfwqijhIhOrV
q3PORK6g+wfqo4sXL+Idrpe7vr4+dx9DYMVGXKCAX+JYsmQJN9pFRPgfHskE
cGtCpoMmKg3e3t6rV6+W4AHF1Y07d+7AJPAPNoFEPH/+HO6CN/AcEcIVDB8+
HB/9KrhhKFbuC5maA+jp6fFewyTg59q1a+UKShiUFXIFD1n27dsnV1DLcF0U
3NzcuEFqSBNulcauXbvyy+/u3bv79OlT+NpR5kD9RP8yU1NTEYbo2zNn7Nix
wv/3icoBHPvMmTMleEBxdWPEiBECo0eRyI8fP+YfeN69e/edO3cOGjSoZcuW
O3bs4KV58+bNuRdGRkZc11DR4Z/MB4LAPS7hvQOtWLVqlYGBgby8/J9//olf
ueOjnoLl4ObV/Pz5M37llpqdMWMG/1WcP3++yF5b0EO4KbG+T8SQmJgo1i4M
OXjwoFjCSMgoKLclO7uUWLoBR6GgoMD1COXRuHFjVCK8gec/f/6sW7cutmzS
pAmSnTMPtra23AtedwseWlpa3Iv27dsL0Q1usBtHSEgIzAw3II4DonH//n2c
Dj6Hsx+mpqYQELzgFowYOHDg3LlzLS0tOVsONeM3GKizcPwiLx/XInC9woEh
XLZsmejbsyUrKwvVnGSngSKkkBMnTkh2eUexdGPevHkCU2z9KphcHcULb+D5
pUuXLCwskGu8pK5RowYqiE2bNnGJzOuhERER0aNHD35xaN26dYnGQ67g2crk
yZN79+7NeweFRq9evfCCG93m4uICy8Grj7Zv3/706dN69eohMK6fiUDfDJRd
1atXL/IOob29feGJB4Wwf/9+3hNqmQCeUPQZiggZBRkq2U4CousGWiW4ff7x
8hxo0G/dusUbeA7/j6TmTSwMPDw8kJJFduhSUVERRShEhwupRYsWc+bMkSsY
TitXcG8Wb/r6+nJdWH8V1TcDkRQ5UyL8g1hz8nz48AG2h//+j5SDL4pWna70
fPz4ESW8BA8oum5s3LixS5cuhTewtra+du0ab+C5g4NDdHQ0l8XcqLSGDRui
BuHMhp2dHX+aDxgwgP9XLs3lCnqFiSgU3OAUjmPHjnHTWMF746S4NO59biAG
ZAGvecsiCPTNgBUp8slCaGgo151edJo3by6WRWHLuXPnbGxsWEdBlDvcIHRJ
HU1E3YDZgLEvcgV2pAn3vo6ODtwIL4vRkJmamnKdLuQKnoo+efJES0sLxlhE
TRCRsWPHyv139D2y4PXr13IF0/7AmLm5uXHbcJNj6OnpdevWjQvby8uLf8ZF
xHn48OHCV4cdxZ2q4q+//po1a5ZYuzAE1gsGKSMjg3UgRPmCRrxwsVBqRPcb
3K3Fwhu0bt2ay0ok6fr162EtuP5X48aNq1KlCvKRm0Wco0mTJv369YMnES4F
QrqgC5edvLw82ANYMoiJi4sLCpPZs2dz86ujKunQoQNC4qZQXrx4Mf8Eg9ir
yOVjuEkOxeocdebMGYkPPyxXunbtumfPHtZREOVLu3btJLiwuOi6wd1aLDy7
adu2bblJxdHIdu/efdGiRStXrlRWVkYW29vba2hoqKmp7d27l5fa3EcC4KL4
SxgrKyvhwiIAr64JCwuD8UAYcGWI9sqVK48fP0YAkI4ZM2agzoIZ4CwH3EXH
jh15VwFJLG7iHW1t7eJWWimSnJwctODiLjXLkODg4JEjR7KOgihf+vfvv3Xr
VkkdTaznKb6+vuPHjxfYwMnJ6cSJE7/+u5bB1atXe/bsuWnTJrn/PmPF3+Sn
T5/Q9COjBw0aVDjrITXVqlUTWD9FRKBLAu9wQ2OqV6/OG6JrYWHh6OgIXwSJ
i4yMRP0SFRWVmpqKfXlXAackMNiNB9SGf3CcKMBl7du3T6xdGAIDpquryzoK
onyZNm0abzbvsiOWbrx9+xaNODKOf4NOnTrFxMT8+u+qB1z/DVQHSENknFxB
1wvUJgLjSoTQtGnTUggIpxVKSkrcjED84/pRQMFyfPnypXfv3rAivXr14uoO
lDO8uv7IkSPFPT+dPn36ggULxPpW/f39ZegWx6+CwQJieSpC5ggJCZHgPA/i
9hdFRgwePJh/A1dX1+jo6F8FC6kgYS9dumRqasrNzuHs7KypqVm1alXkcqtW
rUqnBsVR5NSCECj85B/cigs0MTHhun06ODhwHUe5j+BAeMs23bp1y9zcvMhv
YPv27X379hXrW4XDwfcg1i5sgQ9Eicc6CqIcgQFGISCpo4mrG6g4VFRUeAsv
AgSzf//+XwU3TvERWmdkGdpuvAn1mDdvnlzBGHmkeZ8+fXgJjhRGPtaqVUtf
X19EoeDWfOQBC8G9qFKlCg7OmwRMruC2KhfbnDlz4F4yMzNRmxw+fBgf8d/8
HDNmDG9uw/T0dHiVIr+BxMREY2Nj0b9SuDIEINlpUsobVL4Cq3ITlYzLly8L
TB9RFkoxHnb58uW8p5kAahAZGYkXEAf87XETYoSHh6NZR7ppaGjUqVMHfuOP
P/7gzSnKPU/hLU8vIrwpBLm5juUK5viCLKCtbNSoUf/+/bk3eZNgoJpDANxo
O26SZBQp/CN516xZw38/sMjZAn8VTIuKj0TvyrVz506cSMSNpYS0tDRoL2+i
EqLy8fz5cy0tLUkdrRS6kZ2d3aBBA15fDi8vLziHpKQkJO/ChQuRnqiU4fnb
tm0L88+18vAG7dq14+kGP2WZ9WvXrl3cJOdczQLJgrZwndOCg4PhZLiF2759
+2ZgYCBXcIeW32+cO3euRYsWvF8hR8XV+GZmZqKPNx86dKhkxyxXDDY2NvHx
8ayjIMqL3NxcJIukmoZSzxPYpk0b7jWa+y1btmzbtm3UqFGwu1yNgPDWrl0L
BzJ69GgYACQdd+eBAxUBzzMIPEbhFo8uDKdIReLv71+jgJcvX7Zs2bJVq1Y4
NY7PmzzTw8Ojffv2enp6np6e8Bi8qxDom9G6dWsoSZFfAnaMiIgQ8SuFqD54
8EDEjaUHZ2dnXmdaolKCfHz9+rVEDlU63UDxbmRkdPToUbweNmwYN00l2m6u
HwX3/q+CwRoTJkzAO7Nnz4bbR+HPG/zerFkzJCzyi7dqG8eQIUNENBs4HfcC
uqSpqQnvAbeAw+KA8GNPnjzhYliwYEH16tWxcUZGhq+vr8BgE+Q4b8u+ffvi
IEV+CdOmTcMXJcr3ef/+fW1tbVG2lDY6d+585MgR1lEQ5Yi1tbXAugOlptTr
IBw4cMDCwgK5D0fB3YqHmAQEBMgVlB4oFnht7pgxY0xMTFBExMTEoPbnlnmV
K1jjIDQ0lBtgAsHhH2lSIlZWVjo6OtwuqEEgHXAOSFhuMTjeqbnZP6ZPn87d
pZw0aZLAIPeePXsieM684UqLHAKfmJiIOkvEflyrVq0SfUFqqcLNzU2G1nEg
SgH+i8XtiVQcZVmvDY07GuixY8fyr1oLMVFRUWnXrh3UA3mKWiA8PLx///5o
y1CSWFpaQlK6detWp04dvOaWjXZxcUG+q6qq2tvbC9EKnK7I93EiOBycCFKG
X7mZeWBvfHx88Cv3jJgDtoG39DyneKhNeIslQTQElo7lgEdC4SPi98nNWSTi
xlJFr169ZKivGlEK0ILz1+lloSy6cfr0aT09PT8/P27GHg5vb+/ly5fjJ2oH
OH+01Nid6xqBXIaAwGa0atUK6sF1OIdcoLJGccFbel4sqlWrxpUeMDM4AreG
46NHj7jOY/Az/AHPmjUrMDDwV1Gi8atg6gwImsAjFaQSDiXiQ1XenEWibCxt
4D9r9+7drKMgyhHU7JLqjggJEn6oEtej9/Ly4lce3sBzGIz69evDjXA9vrgF
StAW9+jRw87ODtUEUhiiMWHCBChMKRSDm38Yp8AxY2NjcaiIiAhXV1f8hCKh
GoLfEIh2bgFFigakBofiNye/CpbG1tXV5fUNK5GLFy/CRIm4sbQBSd+2bRvr
KIhyZPPmzQKdNksNcgeeobglhnNycjw9PRctWlTc7tevX5crWKeA9w7/wPP0
9HT4dlQuaIWRy+7u7vAG/fr1Q0UA9UDZIrAePYyHkZFRkSphZmbGPbHlbr2u
X78eP7ndly5disoI50UYOLWJiQm0rk2bNtxcHPxAb//666/CovHmzZtGjRpt
2LBBYHscUKzeUPPnzxfx9qkUgr8osRZ9IGSO48ePOzk5SepoV65cQWNd3JJ/
GRkZMOozZswobne5gh6bvDkqCw8837hxI7aZOXMm0pZbB5ZHw4YNuXkz5Apm
Ho6Li8OOkBcB0cBHiJD3KwL+999/8SIpKQk2Bh/Bb+BNuYKeXXv37oUVKVws
QAO52U0FRAOvraysBCZbBq9evVJSUnr69Kno36S9vb3sPsocPnx4YeUkKhM3
b96ESZDgZHRLlixxcHAorooXLh1cwmppafHuqgmsTvKrYGiYuro67MTjx4/d
3Nw0NDTGjx/PJS9qgcmTJ+MI8MnIU67E5lY04MHr7AFwlry8PBgMVEA3btxQ
U1OLiYkJCgqCesAznDhxAh8V7qN16NAhfAozg6KJXzTgSRwdHYtcmX3gwIFi
FYOfP39G8SX6upDSBipWgdtBROUDrlKIBxAXtPIdOnSYN29ecRsIl45RBWCD
du3aJSYmCqxO8qvglqOrqyvadGT3nj17Ll++bGtri5qCN2r11KlTnCxUq1Yt
ODj4yZMnPKHo1KkTb/Q9jAE25vqAJSQkQIsiIyMRORp6+CVYlwYNGgj0wUhO
ToY3MzY27tu3r4DTwFV7eHj06tWrcCe6+Ph4TU3NL1++iP4dwgJBgkTfXtoY
N24cb7QOUVl5/fq1srKyBMc+p6WlIQ25mbuKRIh0wNIrKiriZ1hYGAwA8tTf
359/AyQ1Mr1bt27cYgeNGzfu0qULN1FPkyZNoAy8jzh0dHRMTU2510h27j4G
N3KNf+pRiI9cwbh7eBiuG9i0adP4A0YuQKlWrVoFWRMQDTBhwoQ2bdoUdgjQ
E8Qm7iQnfn5+EpzfoOLBt7F8+XLWURDlDv5Ke/ToIcEDHjlyBCVGZmZmcRsI
kQ4kLLdEwocPH7ikRiWCeop3o+P27dsHC4D36NOnT+3atSMiIvB6xIgR2HjS
pEkHDhzYvn171apVJ06ciHdQVsBLwFZxM/MsW7aM25cnGqh6oCc4CHfYAQMG
mJmZcc4BBdfq1auhGKhlEHPhG6Hg77//xvZF9ubCMeGFxF041cTERFKd8Zgw
depUlHusoyDKnezsbD09PQnOGfiroNGBbxeyQXHSAbWB/3n48OGvghE0UABu
gHyVKlU8PT03b94ssFA795R2+vTpOTk5qEp69uzJPda5e/cuCoR169Zx9zC5
vlu8UavQAXd3d1gaFRUV7MKTOGS6gYEBJwInT57EviheUKEU+cgVbNu2DQr5
8uXLwheI2gRKJe7i3dxNVJkeTzpz5kwUgKyjICoCJBoaTQlO9YAstrCwKHKG
Xh7FSQf8j8Aqq5yBsbKyQh0BVTE0NETiwxtkZWX9+u9TWktLS242DwggrgXV
ypUrV7S1tWEYeLORc3dcjx49Cqnhnr/wd+DE9pARCE5KSgoOCKPCdaYtTjSO
HTsG5eEWii3MrFmzBg4cKPo3xrFly5YiV5iVIebMmSPkBhdRyXB0dJRU31GO
Bw8eoOlEGgrZpkjp+PbtG/Kaf1GSXwUPLP755x+IBqoPJDiqA9QXKFJatmyJ
P9Rz585t2LABn4aEhCDNIYChoaGoL7hJBaFgyOJTp06Zm5vb29tz9zfk5eX5
Zw1KS0vT0tKKiopCoYSwlyxZwj1mKk40UEpAZIqbjAvOBwcpxZhBVEnCxVb6
CQgImD17NusoiAqCWzRZyE2JUoCyAk2/8EeKRUpHWFhYkesUv3v3btSoUWjl
kVww86iwYmNjUaTY2NjUqVMH0tegQQMoCdz+r4KSx8/PD++j+UPJ86vgfgV3
G6RLly78UUEiWrRoAQ+DygJSwy3y+Kt40Xj06JG6uvq///5b3EWhRiudV8el
idXTQwpZtGiRBJ/QEdKPj4+Pr6+vZI/p4eGBfBS+TWHpQJrr6ekV1zH71q1b
bdq0gYs4e/Ys/0H27NkDWeAelHTq1Gnr1q1wEagjuO6jKCsWLFggVzDEXuCA
vXv3/vPPPyE4/DckixMNqApi44b8FwmMja6ubikWWebmLBJ3L2lj6dKl/AvK
EJWe9+/fcwW+BI+ZlZWlo6NT4sDqwtKxa9cu4asOQSUaNmzo7u7+7NkzgY9Q
tsBmmJiY4KepqemECRNQxXC3OLp27cq/5YsXL7ipPASelhYnGvjV0tJSyLTk
sDSohriJUsVl+fLlOGkpdpQqVqxYUXiRC6JyExISwr+KkESIj49HBVTkQwd+
IB3IuJkzZ3K/InPhKIob8MKBWgMprKSkhIL669ev/B/hV29vb21tbfwZT5o0
iRONKlWqoPq+fPkysvvbt2/z58/nZvtB3cG/b3GigXIGpVDhYW78oMJq166d
8CstDtlaLaU4Vq1aVaLDJCoZKBBg6YVU7qUDNS8qixIfLwpIx9GjRxFMiU95
oEj9+/fX1NTcvn27QGeJmJgY7QIuXrwIoUCpAgvNW1fFxsZGQUEhNjaWf5fi
RAPv9+3bFxWNkKv48OEDFJKbuENcfvz4Ubt2bRlana041q5dy/XAIX4rjh8/
rq+vX3gQaFlArrVv316UVYcEpAPZPWzYsC1btiQkJAgksgBcn/MWLVrwr5T0
q+B2BH8y3rx508HBASXM6tWrUXFwd1B5FCcaAN4b0if8rgW2GTNmTInXWCQy
txpscWzcuFFGZyojyoirq+vSpUsle8zXr1+rqamh3S9xS37pePDgAdQGdsLa
2rpmzZowFagUuJnB4BMEah9kPRRGQ0Nj0KBBhZ+Bvn37dsSIEYhh/fr1RXoG
IaIRFBRkZmb28eNHIWHfu3dPRUWl8Lq3IiJbq88LISIiohQdV4hKwMOHD5WV
lZFokj3s4cOHUTIIzz4OAdfBIzU1FXYoODgYzXrbtm3V1dXr1KmDZhpCgVIo
KioKyYusx45KSkp4h7MH8E7Lli1DUqNI4bqKFUaIaGzbtg1hCziTwri4uCCw
Ei+tOJo3b37q1KlS7y497Nixw9PTk3UUBBumTJlS3PrIZcHX11fE/pDFSYcA
qEEuXbq0adOmqVOnwiYZGBjUqFHDyMioc+fOFhYWsCj+/v56enpdu3YVsqaA
ENEQ3imUByTR0NCQ6yVSCnAVEEAJTmjAkMjISFnv8kqUGrTLaM1FXyRIRGAA
mjZtKuK8LiJKR+FTJCUl7dmzJyAgAOrB3QLV0tJycnIaN27cmjVr4uLi+KsY
IaJx9epV+C7eylDFAT8DvYLCiBUnPwcOHIBdKfXuUgWuRbLDJAnZAtltb28v
8cOi7UYyltiCc5ROOvjJy8uDMjx79uzo0aMrVqwYNWpUmzZtVFVV5eXlURoM
Hjy48HwaHCjWoJwwEiWeAkWQQLcQcfH29i5y6QRZJDo6GsaPdRQEM5BxVlZW
5TE3NRQJrkPEHpVll44iyczMvHDhwurVqwXmEOZ48+aNrq4uyp8Sj/P27VsV
FZUyLqwGu5KYmFiWI0gPMTExnTp1Yh0FwZLz589ra2t/+/ZN4kdGCSx6n/Zy
ko7igPewsLDgnyRZCCNGjChjt+rZs2fb2dmVx5fMhJMnT3bo0IF1FARjPDw8
ymNY9MePHxs2bCh6BzOJS0dubu73798/f/4M4/Hu3btXr16lpqampKTcvXu3
bdu2IvZ4vHnzppqaWnHPaERh2rRpNjY2ZTmCtHH69Gl8gayjIBjz/PnzevXq
CcyWIxEuXryIpBN9sPmHDx+4OQCHDh06cOBAT09Pd3f3Hj16dO3a1cXFxdHR
sU2bNq1atWrWrBnKKzMzMyMjI319fR0dHU1NTZxISUlJXl6+Zs2a3HL2VatW
rVGjRu3atRUVFVFoaGhowFk1atQIH3l7e4sySVdSUhJOUZa5u+fOnYt6DZJY
6iNIIaj+8L/AOgqCPXPmzCmnJ/ILFiyAFIg1vdXBgwc3bdoUERGxY8eOPXv2
HDhwAKbl6NGjsbGxZ86cwR9tQkLC9evXb9++Defw6NGjp0+fvnz58s2bN+/f
v0ez/vXr1x8/fog7dx8/cEqhoaHclKReXl6lPs6SJUsgOzK6KJsQ4uPjUXax
joJgD3KtQYMGonT1FBcohq6u7oQJE6TfqENqTp061b9//7p16/bt2/fYsWNl
mc0vJCQEXqgUE/tIP9euXbO2tmYdBSEVcOu/l6WZLg40uE5OTqgXnJ2dV61a
lZqaKvFTlBFUagEBAdA31BTI97KXFevWrUP1VNwCVbJOcnKyqakp6ygIaaFl
y5abN28up4N/+fIFFceQIUNUVFQsLCxQGaHZKqdziUhOTs7u3bs7duyopKTk
4+MjMG9hqUGFBfMmwYUnpI0tW7ZQP3OCx9WrVzU0NIQPSi07MP8XLlyYOnWq
oaEhTjdmzJiYmJgK7oCdmJjo6+sLuYARgtGS4NJpkZGRuKj79+9L6oBSCDR2
xYoVrKMgpIihQ4dOnDixwk738OHDpUuXOjg41K1bt3fv3mip379/X36ny8zM
XL16tZWVFfzA3LlzC08jVkaioqLU1dVh4yV7WGnDxsamuOmaid+Td+/eycnJ
VfxfRXp6Otxvr169ICCQEYiJwAxdZSE/P//EiRP9+vVTUFDAz5MnT5bHbRy4
JjU1NYmP95E2srOza9asKbuL2xLlxNmzZ1VVVRcvXsxkbSD8WSIBUbzA7RsZ
GU2bNg1FTakjSU1Nha/Q1ta2traG05DsXO78xMXF4UuLj48vp+NLD2hT4DdY
R0FII8+fP2/Xrp29vb3EnbzowBJcvXrV39/fwsJCRUUFBRSqAIEpRosDreHO
nTs7dOhQr149X1/fW7dulWuoUDZEeO7cuXI9i5QQHBzs7e3NOgpCSkHaLlu2
TElJKSIignUs/2MbVq5c6eTkVKdOna5du65bty4tLa3ILa9fv+7j44OwO3bs
GBkZWQG3W7k14ASmMK3EeHl5hYeHs46CkGqSkpLMzMzc3d2lpKd0VlbW7t27
8aerqKhoZ2cXGBjITRGM8EJCQuBMdHV1AwICKqzjxM2bN1GeoLCqmNNJA/r6
+pJdR4OolGRnZ0+aNElTU/P48eOsY/n/5ObmxsXFjR8/Xk9PD8pWt27d/v37
453yuOFZHMnJyerq6qieKuyMzIE+y8vLV+SXTMg0p06d0tbW9vX1lcIb6QkJ
CaLMaCpZHj58qKGhsWvXrgo+L1vgrGgEPSEWHz588PT0NDQ0rPSPGkvkyZMn
UNHfsMyfN29ehc2RQlQm0MIyfEorDbx48UJXVzcsLIx1IAzo3LnzwYMHWUdB
yCTS8JSWFWlpaQYGBr9tL2slJaXinmQRRIlI1VPaCuPdu3fGxsbwWqwDYUNK
SgqqM9ZREDJPUlKSqalp7969peQpbbmSmZnZtGnTOXPmsA6EGTt37sT/Neso
iMpATk7O5MmTpe0prcTJysqytbWdOnUq60BYMmHChKCgINZREJUHaX5KW3a+
fPnSqlWrcePGsQ6EMS1btjxz5gzrKIhKRaV8SgubsXXrVgMDg5EjR/7mnZ1y
c3Nr1qwJCWUdCFEJqRxPaTMyMjZv3tylS5fatWvjckRZ0K3Sc+3aNXNzc9ZR
EJUW3lPap0+fso5FPN68eRMWFubk5CQvL9+7d29o4OfPn1kHJS2EhoaWxyrk
BMGDe0qrrKwsE09pX758GRIS4uDgoKCg4OXltX///kqzsJoEGTx48Pr161lH
QVR+eE9py3vC0tLx5MmTv//+u3nz5vXq1RsyZAiKkQqe41S2MDY2Lu9pTAiC
g3tK26RJkwkTJqxbt+7s2bPMFyG6f/9+YGCglZWVqqrq6NGjT5w4kZubyzYk
6QfKX6tWrZ8/f7IOhPiNiIuLW7p06bBhw1q1aoXGXUlJqXXr1iiWUcuglX/8
+HEF3ERNTEz09/c3MTHR1NT09fU9c+aMTN+5rWBiY2NRx7GOgvitefv2LdJ2
7dq148ePd3Fxadiw4Z9//tm0adO+ffvOnTt3165d8MOS6gdy9erV6dOnGxgY
6OrqTpky5fLly7/549TSsWjRIvhG1lEQxP/h69ev169f37Fjx+zZs93d3U1N
TWvUqKGnp9e5c+dJkyatX7/+/Pnzoq+PAGW4cOECKiNtbW2USLNmzZLUgkq/
Ld27d9+zZw/rKAiiBFBKP3z4MDo6OigoaOjQoS1atFBQUFBRUbG3tx85cuQ/
//wTExPz5MkTfvOAXVAQ+fj4qKurm5ubz58/v9KvY1JhaGho/IZjn4nKQVpa
2unTp0NDQ/38/JydnWEnUOBYWFj069cP70BVbG1tFy9eLMGFV4hfBR1yIMWs
oyAIifHly5dr165t27ZtyZIl1CCWE/v27XNzc2MdBUEQssTUqVMDAwNZR0EQ
hCzRtm3bEydOsI6CIAiZIT8/X1FRsVwX+yYIopKxbds2WviAIAixsLS0/K1W
oyMIooycPn3ayMiIetgSBCE6bm5u69atYx0FQRAyw8OHD1VUVCrlhLEEQZQT
3t7e/v7+rKMgCEJmyMjIUFBQePv2LetACIKQGRYuXDh06FDWURAEITPk5OTU
r1+fRhMTBCE6ERERzs7OrKMgCEKWaNq06bFjx1hHQRCEzBAXF2dsbMw6CoIg
ZImuXbtu2LCBdRQEQcgM9+/fV1VVzc7OZh0IQRAyw+jRo+fOncs6CoIgZIb3
798rKCgwXxiLIAgZYsGCBbRyNEEQopOTk6Ourn7nzh3WgRAEITOEh4e7uLiw
joIgCFnCzMyMJh8mCEJ0Tp48aWpqyjoKgiBkic6dO2/atIl1FARByAx3795V
V1envl4EQYjOyJEj58+fzzoKgiBkhvT0dAUFBfxkHQhBEDIDnAb8BusoCIKQ
GbKzs9XU1O7du8c6EIIgZIZNmzZ17tyZdRQEQcgSJiYmsbGxrKMgCEJmOHny
pLm5Oa3hSBCEiHz69ElHR+fw4cOsAyEIQmYYPHjw6NGjWUdBEITMsG/fPgMD
g69fv7IOhCAI2eD169eqqqpXrlxhHQhBELJBfn6+s7NzQEAA60AIgpAZVq5c
2bx5858/f7IOhCAI2eDu3bvKysopKSmsAyEIQjb48eOHpaUlLahEEITozJgx
o1u3bqyjIAhCZjh37pyGhgYtjEIQhIhkZWXp6upS11CCIERn0KBBY8aMYR0F
QRAyA3UNJQhCLF69eqWmpkZdQwmCEBHqGkoQhLiEhIS0aNGCuoYSBCEid+/e
VVJSevz4MetACIKQDX78+GFhYbFx40bWgRAEITNMnz69e/furKMgCEJmoK6h
BEGIRVZWlo6OzpEjR1gHQhCEzEBdQwmCEIu9e/c2btyYuoYSBCEi1DWUIAix
yM/Pd3JyWrBgAetACIKQGahrKEEQYnH37l1VVdWHDx+yDoQgCNkgMTFRTU1t
3759rAMhCEI2INEgCEIsSDQIghALEg2CIMSCRIMgCLEg0SAIQixINAiCEAsS
DYIgxIJEgyAIsSDRIAhCLEg0CIIQCxINgiDEgkSDIAixINEgCEIsSDQIghAL
Eg2CIMSCRIMgCLEg0SAIQixINAiCEAsSDYIgxIJEgyAIsSDRIAhCLOLj40k0
CIIQnZkzZ8rJyV28eJF1IARByAAfPnzo3bu3hYVFSkoK61gIgpABLly4oK2t
PX78+JycHNaxEAQh7eTl5c2fP19dXf3IkSOsYyEIQgZ48eKFg4ODo6Pj69ev
WcdCEIQMEBUVpaqqunjx4vz8fNaxEAQh7Xz//t3b21tPTy8hIYF1LARByADJ
ycmmpqaenp5ZWVmsYyEIQgYICwtTUVEJDw9nHQhBEDJAZmZmz549raysHjx4
wDoWgiBkgHPnzmlra0+cOJG6ZxAEUSI/f/6cO3du/fr1Y2JiWMdCEIQM8Pz5
c3t7eycnp7S0NNaxEAQhA+zfv19VVTUoKIi6ZxAEUSLfvn0bPXp0o0aNrly5
wjoWgiBkgKSkJBMTk/79+3/69Il1LARByABr1qxRVlaOiIhgHQhBEDJARkZG
9+7dra2tHz16xDoWgiBkgPj4+AYNGkyePPnHjx+sYyEIQtp5+fLliBEj6tev
f+zYMdaxEAQh7WRmZk6ZMqVevXozZsxIT09nHQ5BEFLN169fAwMDoRhjxoyh
+XYIghDOjx8/Vq9era6u3q9fP5o9mCAI4eTn5+/cuVNPT69Tp043b95kHQ5B
ENJOTExM06ZN7ezszpw5wzoWgiCknUuXLjk4OBgZGUVFRbGOhSAIaSc5OdnN
zU1bWzs8PDwvL491OARBSDXPnj0bOHCgqqrqihUrsrOzWYdDEIRU8+7dOz8/
v3r16s2dO5dGpREEIRyoxJw5c6AY0A2oB+twCIKQalCJLF++HFXJoEGDUKGw
DocgCKkmLy8vPDxcW1u7W7duycnJrMMhCELaOXjwoLGxsYODw6VLl1jHQhCE
tHPmzJnmzZubm5vT+u8EQQgnPz//9OnTbm5uenp6O3bsoLmCCYIQwsuXLxcs
WNCoUSN4jNDQUJpahyCI4sjJydmzZ4+Li4uioqK3t/fVq1dZR0QQhPRy+/Zt
Pz8/ZWVlR0dHlCTfv39nHRFBEFLKx48f16xZY2Nj06BBgzlz5jx9+pR1RARB
SCn5+fmxsbGenp7y8vIeHh7Hjx+nYWgEQRRHamrqvHnzdHR0LC0tV61alZmZ
yToigiCklOzs7F27djk7OyspKY0bN+7GjRusIyIIQnqBRIwdOxZyAdGAdNAg
d4IgigMFyMqVK1GMoCSZP38+yhPWEREEIaXk5eUdP37cw8NDXl7ey8srNjaW
OnkSBFEcT58+9ff3b9CggY2NzZo1az5+/Mg6IoIgpJTExMRly5Z17NhRWVl5
/Pjxt2/fZh0RQRDSyMuXL8PDw1GGqKioGBgYeHt779u3Lycnh3VcBEFIF58+
fTp06JCvr6+RkZGSklLfvn03bNhAdzsJghAgNzf3woULc+fObdWqVe3atZ2c
nJYsWXL9+nW61UkQhAD37t1buXKlm5ubvLy8lZXVtGnTTp48SQPNCIIQ4O3b
t9u3bx88eLCWllbDhg2HDx++e/fu9+/fs46LIAjp4tu3b0ePHp00aZK5ubmC
gkLPnj1DQ0MfPnzIOi6CIKSLvLy8hISEwMDAdu3a1apVq02bNgsWLIiPj//5
8yfr0AiCkCLy8/OfPHkSFhbWq1cvRUVFMzOziRMnHjly5MuXL6xDIwhCWnj/
/v2pU6eCg4OHDx9uZ2cHX9GwYcNBgwZt27YtLS2NdXQEQbDn+/fv165dCw8P
nzRpkrOzc/369evWrWtvb+/j4wOPceHChaysLNYxEgTBEhQdjx49OnDgwPz5
893d3Q0NDWvUqNG0adP+/fsvWbIE1cfz589Zx0gQBGPS09Pj4uJQdAwbNqxZ
s2Y1a9bU0dFxdXWdOXPmzp07k5KScnNzWcdIEARLUHRcvXp18+bNEydOdHJy
UldXV1BQcHBwQNGxdu3aixcvfvr0iXWMBEEw4/Pnz/fu3YuNjY2IiAgICOjd
u3eTJk1QdFhYWAwYMCAoKCgmJubFixeswyQIokL5+fPnq1evrly5EhUVtXr1
alQWgwYN6tChg5GRkby8fK1atSAU7du3h0r89ddfu3btSk5OpqKDIH4H+G3D
okWLxo4d26NHj2bNmmlqalarVq1+/fo2NjbdunXz9vYODAwMDw8/ceLEnTt3
aFobgqjc5Ofnv3z5MiEh4cCBA8Jtw/Tp01euXLl///74+HiUGNQJkyBkHaT/
p0+foACwBxABOAToAEwCpAA+AWoAqwBBgFuAJtjZ2UEWtLS0oAywDRoaGra2
tt27dyfbQBBSy48fP75+/ZqVlfX+/fs3b94g2Z8+ffro0aO7d+/evn37+vXr
SPyLFy+eOXOGS/8tW7asWrVq4cKFM2bMQPoPHDgQ6e/o6Ih6wdDQECUD0v8/
//lPnTp18Brv4H18im2wpY+PD/bCvjgCjoOjnTx5EoYB54JnQAw03QRB8Lh8
+bJbOYMGukuXLs7OzrDx9vb2LVq0QLFvYWFhamoKb9+oUSNtbW005SoqKoqK
ikjqGjVqVK1aVU5ODk18zZo1kexKSkpqampIdh0dHX19fXgAMzMzKysrJH7L
li3btGmDgyP94RMgF/AMcA5If7gIpD8kBfICdwHZofQnCImQlpZ2qJyJjo4+
fPjw8ePH4+Lizp07d+nSpatXr968eTMpKen+/fspKSmpqamvXr169+5dZmYm
iojv37/TAwWCIAiCIAiCIAiCIAiCIAiCIAiCIGSC/wenVYpS
              "], {{0, 
              330}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 330}, 
            PlotRange -> {{0, 360}, {0, 330}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"63ac2e0e-a161-4ce8-8184-db0fe9c80f4f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"aae75bcb-5dac-4ac9-9129-1f2ae87e8d06"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d66cce7d-b3d2-4278-982f-598acb6a4a87"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4a7aadd5-2e9e-4486-8933-3dce4e32cba0"],

Cell[TextData[{
 "Make graphics of the path obtained by turning a constant angle 100 times, \
controlling the angle from 0\[Degree] to 360\[Degree] with a ",
 StyleBox["Manipulate",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"94881105-01e1-4776-95f3-3c45194b2780"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a6d9490f-669a-4793-a3ee-f83ab2805e57"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzs3QW0XdXVB3oIbgXaQosVCIRQ3N0JIXiwoEGKFpcQJFjxIAEKNDiFAsGL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            "], {{0, 454}, {405, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
            Association[{
              "Exif" -> Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com"}], 
               "Comments" -> 
               Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com", 
                  "Creation Time" -> 
                  DateObject[{2017, 7, 10, 15, 22, 29.}, "Instant", 
                    "Gregorian", -5.]}]}]],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{405, 454},
          PlotRange->{{0, 405}, {0, 454}}]], "ExerciseOutput",ExpressionUUID->
         "499a1ccd-fa81-4e91-aac5-24fa89f55e9c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzs3QW0XdXVB3oIbgXaQosVCIRQ3N0JIXiwoEGKFpcQJFjxIAEKNDiFAsGL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              "], {{0, 454}, {405, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True, 
              MetaInformation -> 
              Association[{
                "Exif" -> Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com"}], 
                 "Comments" -> 
                 Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com", 
                    "Creation Time" -> 
                    DateObject[{2017, 7, 10, 15, 22, 29.}, "Instant", 
                    "Gregorian", -5.]}]}]], Selectable -> False], ImageSize -> 
            Magnification[1], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {405, 454}, PlotRange -> {{0, 405}, {0, 454}}]], 
          "ExerciseOutput", Magnification -> 1, CellFrameColor -> 
          GrayLevel[0], Selectable -> False, Copyable -> False, Editable -> 
          False, ShowCellBracket -> False, CellLabel -> "Out[]=", CellFrame -> 
          False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f0fbd5b6-e792-4f54-b906-6a3b100b4ab5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a5209bd1-9a14-4e49-a231-a246822016a2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4ed2393d-6ddc-4c3b-9651-1225560d2f6d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3cb6b87b-f698-4ae8-82b0-bdf00eed9ca9"],

Cell["\<\
Make graphics of the path obtained by successively turning by the digits of \
2^10000 multiplied by 30\[Degree].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"a23cbdf6-a30c-4d43-9b94-af11ece29927"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f8e58acc-18ce-421b-ac91-41f0a401f479"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsnQV0FVf39oeiwa0hQAjBNRA0BHe3IMGDBiuuCQSX4FKsSHF3intxLe5e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            "], {{0, 432}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 432},
          PlotRange->{{0, 360}, {0, 432}}]], "ExerciseOutput",
         ImageSize->{364, 432},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "edd065ff-602c-4426-b988-ee7aed0cf22c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsnQV0FVf39oeiwa0hQAjBNRA0BHe3IMGDBiuuCQSX4FKsSHF3intxLe5e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              "], {{0, 432}, {
              360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 432}, 
            PlotRange -> {{0, 360}, {0, 432}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"476d40f2-8483-41a9-8e21-af3d1b8c6ade"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["17.14"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a986ce10-3d81-49d7-84b3-96b23c66c485"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3c8b2790-8430-4bb8-9423-281a547b159d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fedcc8f4-aa9d-4ef4-99f0-e6f6eb43f60b"],

Cell["Convert 4.3 light years to furlongs.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+17.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"5b7a16eb-93a1-4836-b845-b86f6872d44e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6a8c584c-76b3-4e62-b590-deafb970fd40"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWM2L4mYYX9pLj7322P+i1x573dqrsEu3axG2zKZQ9DLOwXoQxEMQBg+b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            "], {{0, 25}, {
            134, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{134, 25},
          PlotRange->{{0, 134}, {0, 25}}]], "ExerciseOutput",
         ImageSize->{138, 25},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "31c5217c-ffb8-4a4e-9a7c-ed1f4b726f1a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWM2L4mYYX9pLj7322P+i1x573dqrsEu3axG2zKZQ9DLOwXoQxEMQBg+b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              "], {{0, 25}, {
              134, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {134, 25}, 
            PlotRange -> {{0, 134}, {0, 25}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6cf740c5-928c-4dd6-9ac6-22285e97f299"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x17.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0f779eb3-a83c-4398-9ff2-18aae3839abb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0f5b7817-74e7-4a0f-9a0e-12414f185144"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"72a81384-1934-4b86-ab42-1074a8962b0d"],

Cell["Convert 20,000 leagues to miles.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+17.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"c81aae25-dfcd-4d16-bc88-62de0e02388e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b6464b80-d960-48d4-b00b-2785f6d8dcdb"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVEFr2mAYlu2y4w77A/sV23XHXTt3LbTMNUPoqBmMeok9iAdBehBheGgO
rYcgSgmoEESL2EIL6VhAIYygosOJUlOSEFFw7/clJtElrjsMdvAlypc3T57v
ed/3yfd89+PW+0c+n498An9bO59fhUI7h2+ews3bffLD3n7g3ev9T4G9QOjl
7mNIPoPfC/ih9XwTm/gvYjqZraZmcle45GoX1fZIX6SGwmWhUuakgb6Kns/7
jXqtVLhtdB0Ubvi1JN6hV2J+KhjrOXRq0jkV9FtXRQLCbi5sZbavOktbiPlD
lCfR0xQr4Jwrfh3JepFCPpY+KdzbmTGLqBI9xDGunWba+nx4nQDmWmcKG53B
FgnOrknl40H/cR5pazIEFTyQPPDrSMyYTlRbuXO9ErMBB1S5b4rz3auknwpn
NHzTLkHfIu0FwUTMAP52hG8GVVizDdkN700yazFhIlcu0HgW0US2NxAYo+fh
pKQa+Fg0WZgsBGkNGrohSN9v2CxXqrZlKFwpkv44IzhUEU3VxPfKESqYvjMr
bKWRyJ9ueG8SVTjGHsiV+WY5afiBZusin4UZxfGMpDxBkbQ1bg13Bq70l2QK
lUbcjpRi2ObHAEJciBRhxKTZHzAPB8g874b3JtGRSIYf4huFJf3RU95iizKW
SGsXUyR2DkSLBr+x/B86adfYBXyu8ePvOqkLcdR/w2DOWuz1ikj8+rYgz00Y
1MV8vUF2yhqW6JUiyE4L008kB35UhwKLouyGn3qSmCLHDxcJZx4D445l2qOh
WEbfIycpRnuZi+Zdp54Cb59c23DsQypx3h91uQQ6zfqLcazgPUnUB4qkHSLh
A0ckhjPPSuaARDZiHnFHdH/57NCkQtzEE1cdZQ3enURvphwisatNkZUjS+QB
TMEpEsdUk8eaPnWmJur4XlZ+O9yMwpR7dawtP3PFryPZxCY28c/iF01Ci7c=

            "], {{0, 20}, {55, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{55, 20},
          PlotRange->{{0, 55}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{59, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7f901495-5d22-4b39-a555-28863530072a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVEFr2mAYlu2y4w77A/sV23XHXTt3LbTMNUPoqBmMeok9iAdBehBheGgO
rYcgSgmoEESL2EIL6VhAIYygosOJUlOSEFFw7/clJtElrjsMdvAlypc3T57v
ed/3yfd89+PW+0c+n498An9bO59fhUI7h2+ews3bffLD3n7g3ev9T4G9QOjl
7mNIPoPfC/ih9XwTm/gvYjqZraZmcle45GoX1fZIX6SGwmWhUuakgb6Kns/7
jXqtVLhtdB0Ubvi1JN6hV2J+KhjrOXRq0jkV9FtXRQLCbi5sZbavOktbiPlD
lCfR0xQr4Jwrfh3JepFCPpY+KdzbmTGLqBI9xDGunWba+nx4nQDmWmcKG53B
FgnOrknl40H/cR5pazIEFTyQPPDrSMyYTlRbuXO9ErMBB1S5b4rz3auknwpn
NHzTLkHfIu0FwUTMAP52hG8GVVizDdkN700yazFhIlcu0HgW0US2NxAYo+fh
pKQa+Fg0WZgsBGkNGrohSN9v2CxXqrZlKFwpkv44IzhUEU3VxPfKESqYvjMr
bKWRyJ9ueG8SVTjGHsiV+WY5afiBZusin4UZxfGMpDxBkbQ1bg13Bq70l2QK
lUbcjpRi2ObHAEJciBRhxKTZHzAPB8g874b3JtGRSIYf4huFJf3RU95iizKW
SGsXUyR2DkSLBr+x/B86adfYBXyu8ePvOqkLcdR/w2DOWuz1ikj8+rYgz00Y
1MV8vUF2yhqW6JUiyE4L008kB35UhwKLouyGn3qSmCLHDxcJZx4D445l2qOh
WEbfIycpRnuZi+Zdp54Cb59c23DsQypx3h91uQQ6zfqLcazgPUnUB4qkHSLh
A0ckhjPPSuaARDZiHnFHdH/57NCkQtzEE1cdZQ3enURvphwisatNkZUjS+QB
TMEpEsdUk8eaPnWmJur4XlZ+O9yMwpR7dawtP3PFryPZxCY28c/iF01Ci7c=

              "], {{0, 20}, {55, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {55, 20}, 
            PlotRange -> {{0, 55}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"111bb543-cda5-4d64-ae6c-7b774e6cdc9d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x17.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"435e3b8a-404b-412a-adfc-394129c53666"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4f044208-b4ad-408c-862c-daaad14da784"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9d5bcbd4-cbcc-458d-a920-24491a1a43ce"],

Cell[TextData[{
 "Make a ",
 StyleBox["Manipulate",
  FontFamily->"Source Sans Pro"],
 " to rotate a size-200 \[OpenCurlyDoubleQuote]W\[CloseCurlyDoubleQuote] to \
any angle from 0\[Degree] to 360\[Degree]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+17.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"ae2eeb23-69ef-492e-b329-fc48edd49490"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d202c20b-32aa-494a-9d5c-2a5ede3f3087"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXc+PW9UVttpNl/0XumPlXSW2XrRSVyNRdecNCIyqSnQaKiFvhw0jtRJu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            "], {{0, 232}, {247, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
            Association[{
              "Exif" -> Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com"}], 
               "Comments" -> 
               Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com", 
                  "Creation Time" -> 
                  DateObject[{2017, 7, 10, 15, 22, 32.}, "Instant", 
                    "Gregorian", -5.]}]}]],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{247, 232},
          PlotRange->{{0, 247}, {0, 232}}]], "ExerciseOutput",ExpressionUUID->
         "89ef1641-6893-4c5f-addf-290769124f3b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXc+PW9UVttpNl/0XumPlXSW2XrRSVyNRdecNCIyqSnQaKiFvhw0jtRJu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              "], {{0, 232}, {247, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True, 
              MetaInformation -> 
              Association[{
                "Exif" -> Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com"}], 
                 "Comments" -> 
                 Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com", 
                    "Creation Time" -> 
                    DateObject[{2017, 7, 10, 15, 22, 32.}, "Instant", 
                    "Gregorian", -5.]}]}]], Selectable -> False], ImageSize -> 
            Magnification[1], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {247, 232}, PlotRange -> {{0, 247}, {0, 232}}]], 
          "ExerciseOutput", Magnification -> 1, CellFrameColor -> 
          GrayLevel[0], Selectable -> False, Copyable -> False, Editable -> 
          False, ShowCellBracket -> False, CellLabel -> "Out[]=", CellFrame -> 
          False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cf5b38bd-07fb-4268-8f47-b2ff66b88c01"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x17.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"901b2637-39d8-4d62-afba-54f3a579ee25"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"604455bd-8460-45af-9e77-f5ed9a9413b8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d9650e76-ce22-445b-970c-c784abc1bd0c"],

Cell["Rotate an image of the Great Pyramid by 180\[Degree].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+17.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"16c71384-bb94-4bf1-81d4-4c3226cb42ed"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"172114bf-45b0-467a-852d-7564eb3bbf44"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJyMvHdYm/m595lrd993z9nTkpNkMpluj3u3wfTeO0gg1ABJIAkhkBBC9N6r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            "], {{0, 94}, {150, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{150, 94},
          PlotRange->{{0, 150}, {0, 94}}]], "ExerciseOutput",
         ImageSize->{154, 94},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "75a5b2cb-a158-42eb-8142-ddda0519ea9b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJyMvHdYm/m595lrd993z9nTkpNkMpluj3u3wfTeO0gg1ABJIAkhkBBC9N6r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              "], {{0, 94}, {150, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {150, 94}, 
            PlotRange -> {{0, 150}, {0, 94}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c526e9b4-269d-4dc2-b3e4-ea8fc5b2332c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x17.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"96d47fb6-bd24-4696-879c-07a0ec0bc128"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"454c9e89-d0ed-486a-b4cf-7fb3c8d6ba33"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"724336f2-9003-4dc1-ba2e-9d91b9451cdc"],

Cell["\<\
Generate a list of letters of the alphabet, each randomly rotated.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+17.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"a69f452d-b0c2-43da-a1c2-2836e983ad85"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a8fb881b-f588-4126-b843-566e5eaf6cf1"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWyGv7bgRTltSWKm/oH/AuNSwKNJWZSG76suq5DXarVSFhgWGBTUoKCgo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            "], {{0, 19}, {414, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{414, 19},
          PlotRange->{{0, 414}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{418, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f370a1d3-d664-4aa3-88c6-572a49144e62"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWyGv7bgRTltSWKm/oH/AuNSwKNJWZSG76suq5DXarVSFhgWGBTUoKCgo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              "], {{0, 19}, {414, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {414, 19}, 
            PlotRange -> {{0, 414}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5e8be5f6-14ed-4838-a128-69d771cd1728"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x17.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6dc7057d-4bb2-4e2a-ac13-17b746068456"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"99995350-1c22-4099-8726-4e650658f995"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6ee4df99-25e6-4dd8-b996-80c83d62d585"],

Cell["\<\
Generate graphics for a path obtained by turning 100 times through a random \
number of degrees between 0 and 360.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+17.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"6f84e32b-efda-444b-b511-2f801c7f37ae"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"72f240b1-bece-4e51-a825-d08349c7deaa"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnQdYE9v29rlXz7HQu/QOKiIIUiyICGLBgogFRewgCgoWFEWxi2JFUbH3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            "], {{0, 342}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 342},
          PlotRange->{{0, 360}, {0, 342}}]], "ExerciseOutput",
         ImageSize->{364, 342},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1859089a-48d7-4e65-9b10-51e1bb00f893"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnQdYE9v29rlXz7HQu/QOKiIIUiyICGLBgogFRewgCgoWFEWxi2JFUbH3
3gvYe8GODY5dVEQREQtNBL/3OvfLzZ8SkhCYBNbveY5PmMzsvZKT9e61ZvZe
22DIGE+/f0tJSY2ri388B090Hjt2cFhPBfzRa/S4AP/Rw4d1Gj1+uP/wsQ5D
auFg739JSY3Af/95/ZsgCIIgCIIgCIIgCIIgCIIgCIIQnJycnE+fPv348aOw
sJBtWwiCkAxOnDihrKxcv379f/3rX3/99ZecnJy6urq+vn6jRo2sra1btWrl
6urapUuXXr16+fr6+vv7BwcHh4WFzZw5Myoqavny5evWrdu+ffuBAwfi4+Mv
XLhw48aNBw8ePH369O3btxkZGdnZ2UVFRWx/RIIgKpH8/PysrKy0tLSXL18+
fvz49u3bly9fPnXq1JEjR3bv3r1p06ZVq1YtXrx4zpw54eHh48aNGzVq1JAh
Q7y9vT08PDp06NCmTRtbW9smTZoYGxtraWkpKSnVq1dPSkqqTp06+Hfr1q1s
fz6CICSG3Nzcbdu2ubu7s20IQRCSxNevX2VlZX/8+MG2IQRBSBLt27c/cOAA
21YQBCFJLF++fNCgQWxbQRCEJJGSkqKiokJPewmCEAhLS8srV66wbQVBEJLE
tGnTJkyYwLYVBEFIErdv3zYzM2PbCoIgJAwNDY2nT5+ybQVBEJLEiBEjoqKi
2LaCIAhJIi4uztHRkW0rCIKQJPLz82VlZTMyMtg2hCAISaJnz56bNm1i2wqC
ICSJzZs3e3p6sm0FQRCSBJIUOTm5vLw8tg0hCEKs+fXrl4yMjJSU1M+fP/Gn
o6NjXFwc20YRBCG+FBQUtGrVCqKRmZnJHImKihoxYgS7VhEEIbZANNq3bw/R
ePz4Mefgs2fPNDQ0qIQgQRAlgWh07doVonH48OFibzVs2PDWrVusWEUQhNgC
0ejRo0e9evVmzZpV8t3Q0NCpU6dWvVUEQYgtEI2ePXsaGRmV9cj1ypUrlpaW
VWwVQRBiCyMaVlZWTZo0KaumaGFhoYqKSkpKShXbRhCEGMKIRqtWrSALr169
4nHm4MGDo6Ojq8ougiDEFEY0XFxcIBrnzp3jffLBgwddXV2rxjCCIMQTRjQ6
duyI9GTZsmXlnp+dnS0jI/P169cqsI0gCDGEEQ13d3dPT08kIHxehfN37dpV
qYYRBCGecERj9uzZdnZ2/K89iY2N7devX6XaRhCEGMIRjaNHj2pqaqampvJ/
bVpamoKCAlqoPPMIghA3OKKRnJysrKyckJAgaAuIT86ePVsZthEEIYZwRCMz
M9PU1HTDhg1CNILUZsyYMSK3jSAIMYQjGnl5eZ07dw4KChKunQcPHhgYGIjW
NoIgxBCOaOTn54eFhbVt27Yi9yj09fUfPnwoQvMIghA3uEVjz549urq6Fawz
PHTo0FWrVonKPIIgxA1u0UhMTFRRUcG/FWzT0tKS1tQTRHWFWzQQY+jp6e3e
vbuCbf769atOnTo5OTkisZAgCLGCWzTw2snJafLkyRVv9vHjxyYmJhVvhyAI
cYNbNPBnUFBQ586dCwsLK97yrl27aFsEgqh+FBONDRs2mJqaZmVliaTxKVOm
REREiKQpgiDEhGKikZCQoKys/OTJE1G137Vr1/3794uqNYIgWKeoqGjMmDFj
x45lpmekpqZqamoeP35chF3o6+s/ffpUhA0SBME6kA4EG8HBwV+/frWzs5s7
d64IG//+/Xu9evVEcp+EIAix4suXL4aGhubm5oMGDRJty9euXWvevLlo25Qs
oJmhoaGRkZGvX79m2xaCEDH379+Xk5OrX7/+3bt3RdhsbGws/0V+qiXDhw93
dHQcNmyYioqKjY0NwjnK2ojqxJYtW5SUlBQUFEQoHYGBgYsXLxZVaxLH3r17
jYyMkKz9/jP/7dy5c6NGjWrQoIGFhcX06dMfPXrEtoEEIQJGjhzZunVrjIyi
kg4nJ6fTp0+LpCmJIyUlBd/k7du3ix0vKiq6cuVKSEiIjo6OqalpWFjYnTt3
WLGQIERCfn6+g4PD+PHjRSUdioqKHz9+rHg7Egeii5YtW0ZFRfE+7datW5Mm
TTI2NtbT0xs7duy1a9doU11CEnn37h0C6U2bNlVcOtCUmpqaqAyTLKZOnerm
5sa/CDx48CAiIsLc3FxDQwPJ3fnz5+khFCFZ4Eerrq6+Z8+eCkpHfHy8i4uL
CA2TFC5evAjt/fDhgxDXPnnyZM6cOdbW1vjyhw8ffuLEiZ8/f4rcQoKoDBYs
WGBnZ3fw4MGKSAcaCQ4OFq1h4s/nz5+1tbXh7xVs59WrVwsXLmzRogVyvYED
Bx45coT/MvIEwRaenp4jRow4fPiw0NIxYMCA9evXi9wwMad79+7jxo0TYYOp
qanR0dFOTk5ycnJ9+/bdu3dvdna2CNsnCBHy7ds3U1PTzZs3Cy0dVlZWN2/e
rAzbxJaYmBikGJWUWaSnp8fGxrq5ucnIyPTo0WPbtm20Fx4hhiQlJSkrKycm
JgohHTWwXM/Dhw/xdT179qyyO/ry5cumTZu6du0qKyvr7u6+YcOGChZyJAjR
smfPHn19ffxQBZUOaI6xsXGl2iZWQCEbN26M8KwqO0VMuGPHjp49e2pra1+6
dKkquyYI3oSEhHTu3LmoqEgg6di9ezdi6cq2TXzw9/fv378/W71fuHBBXV19
3rx5NP2DEBMKCgocHR1nzJiB1/xLR40q17N//35DQ0OM/iza8O7du1atWnXs
2JFyFkJMSEtL09LSio+P/823dHTr1m3fvn1VYh3LvHnzRlVVVRzuAEPhJ06c
iJzl6tWrbNtCEP/hypUrampqr169+s2fdBgYGIiwaJjY8uvXr9atW8+fP59t
Q/7H8ePH8X8qKiqKchZCHFi2bFmzZs1yc3N/lycdNadcD3IxV1dXcfNQhED2
9vZdunT5/Pkz27YQxO++ffsOGTKEec1DOq5fv25jY1O1prHApUuXGjRogCSO
bUNKATnLuHHjdHV18f+CbVuImk52dra5uXlsbCzzJyMdJZeBr1mzRuSlw8SN
zMxMHR2duLg4tg3hxZEjR5Cz1OQSKISY8PTpU+7bgJAO/FlMOoKCghYtWsSG
dVVHjx49QkJC2LaifF6/fm1ra9utW7cvX76wbQtRozl06BAC4E+fPjF/lpSO
tm3bnjp1iiXrqoJVq1Y1a9aM2TlC/Pn582dwcLCenh7t0kuwS1hYmIuLC+fO
ZzHpqN7leh49eoTsTOKeFjGrm6Ojo9k2hKi5QDGgG1APzhGOdKSmpuIFi7ZV
Krm5uebm5hs3bmTbEGF4+fKltbW1p6enqDbjIwhBQZ6CbAU5C+cIIx3z589v
164di4ZVKgEBAd7e3mxbITzIrQIDAw0MDKioKcEWN2/ehFBwF/aHdEhJSY0Z
M4ZFqyoPhPrwuGqwen3fvn3IWWJiYtg2hKih7Nixo02bNsw2kQxwrl+/frFo
UiXx9u1biOSNGzfYNkQ0PH/+3MrKqlevXuwuqyFqJhh8paWlmUmk1ZjCwkJH
R8d58+axbYgoycvLQ9plaGiYmJjIti1EjQPxhphPf6o4kydPbteunbjNJxcJ
u3fvVlZW5szlI4iqITIyMjAwkG0rKpGBAwdKSUmJ53xykfD06VMLCwtvb29m
azmCqALu379vZGTEthWVwq9fv4KCgszMzKrBvVDeINMcPny4iYnJgwcP2LaF
qCloampWv+2SoRVuf6j2osFh+/btyFnWrVvHtiFEjWDYsGFLly5l2wpR8uLF
C4QZCDaq5bMhHvzzzz/m5uY1pOYSwS779+/v0KED21aIjEuXLqmrq69atYpt
Q9ghJSWlXr16bFtBVH++ffsmLS1dPXY92Lhxo6qq6unTp9k2hDUSEhJsbW3Z
toKoEbRt2/bYsWNsW1EhCgsLQ0NDjYyMEKuzbQubIHr08PBg2wqiRjB//vxR
o0axbYXw/Pjxo3v37k5OTlRbLzo6WqL/VxISxMOHDw0MDNi2QkjevHnTtGnT
oUOH0ubvYOLEiXPnzmXbCqKmoK2tLYkRPtJ5DQ2Nal+gjH98fHyqeOM5oibj
5+cncaUsd+7cqaKiIul3ZkSLs7PzmTNn2LaCqCkcPHiwffv2bFvBL0VFRRER
Ebq6usiw2LZFvDA1NU1OTmbbCqKm8P37d2lp6ezsbLYNKZ/c3Nw+ffo4ODik
p6ezbYvYgf+JtLieqEratWt35MgRtq0oh7S0tObNm/fr1y8vL49tW8SOrKws
WVlZtq0gahZRUVEBAQFsW8GLe/fuaWlpzZ49m21DxJSkpCQzMzO2rSBqFo8e
PdLX12fbijI5ePCgsrLy/v372TZEfDl9+nQ1Lg9LiC06OjrieVctMjISkQbV
4+XNpk2bBgwYwLYVRI3D399f3OZC5OfnDxw4sFmzZqmpqWzbIu7MmTNn0qRJ
bFtB1DgOHz7s4uLCthX/Iz09vVWrVp6entVj2V1lM3LkyOXLl7NtBVHj+PHj
h7S0NP5l25D/wNxvmTJlSrUsDVoZdO/e/cCBA2xbQdREEG8g6mDbit/x8fEq
Kirbt29n2xBJonnz5tVmrwdCsli0aJG/vz+7NuzcuVNdXf369evsmiFxaGho
vHv3jm0riJpIUlKSrq4uiwb8888/UlJSKSkpLNogifz69at27do1rTQiIT7o
6ek9fvyYrd5PnjzZunVrtnqXXN6+faupqcm2FUTNJSAgICoqiq3ez50717Zt
W7Z6l1yoQiDBLkeOHGFx2uGlS5co3hACqhBIsEt2dra0tDRb+39dv37d3t6e
la4lGqoQSLBO+/btDx48yErXt27dsrGxYaVriYYqBBKss3jxYj8/P1a6vnfv
nqWlJStdSzRUIZBgHeZhKCuVfh89etS4ceOq71fSoQqBhDgA3ahbt66Tk9Pk
yZOPHz+emZlZNf1CskxNTaumr+qEmZlZUlIS21YQxH+2cjt58uS0adNcXFxk
ZWXNzc2RvCAYfvHiReV1+vz5c0NDw8prv7pCFQIJMeTXr1937tyJjo7u06eP
lpaWurp6z549Fy9efOPGDdGmMykpKTo6OiJssCbw9etXGRkZtq0giHKAd2/f
vn3kyJGWlpYY6USYzqSmpmpoaIjEyJoDVQgkJI6y0hlkHEK0lp6erqKiInIj
JZdPnz6Vew5VCCQkGu50RltbG+mMp6fnokWLEhIS+ExnELEoKChUtp0SQVZW
VkBAgJSUVLlnUoVAojqBdGbHjh2jRo2ysrLiM51B9EKp+ufPn4cNGwbFaNSo
ET+bU1CFQKK6UiydMTQ0hF+UrBqam5tbp04dViwUB5CmDRo0CN+MmZnZtWvX
+LyKKgQSNQEmnZk1a5axsXGx2qEFBQW1atViyzAWef/+fb9+/aAYRkZGly9f
FuhaxBu0OIWoOfTv33/MmDHFDvKT0Vcn3rx506tXL3xqfX398+fPC9HCixcv
1NTUqGgPUUPIzMzU1NS8ePEi98HatWuzMsW96nn58mWPHj2gGFpaWhWcJW5r
a3v69GlRGUYQYs6xY8cMDAy4i6jXrVu32m988OzZsy5dukAxGjRocOLEiYo3
uGjRoqFDh1a8HYKQFAYPHsy9Na2srOzXr18ro6O0tLTg4GAWqyAC9O7m5gbF
UFVVhWaKqtl3794pKirWkDiNIH7/maigo6PDCdTx+//8+bNou7h//76vr6+8
vPzw4cPRPivSkZiY6OzsDMVQUlI6dOiQyNt3dHQ8evSoyJslCLHl1KlTkA5m
ZRYG4o8fP4qk2aKiouPHj7dr105TUzMyMvLLly84GBsba2dnV1hYKJIu+OHW
rVutW7eGYigoKOzdu7eSeomJienfv38lNU4Q4omfn9+wYcPwAj5e8X1AcnNz
V69ebWZm1qxZs23btnEH8BATJyenJUuWVLALfrh69aqDgwMUA8nXzp07hd57
7sOHD1euXHn9+jWPc9LT0xFQVeqtoczMzFevXlVe+wQhKN+/f9fT04uPj9fV
1eXtILyBi4WHh6uoqHTr1u3ChQulnvP8+XMkCy9fvhS6l3I5d+6ctbU1FENa
Wnrr1q18hjcQFmgmzF63bt2kSZO8vLysrKxkZGTwcfT19fGa9+Vubm579uwR
hfmlGLZmzRp8HLr7Sogb58+f19LSgm4Itybu4cOHgwYNwpg7cuTIp0+f8j45
KiqqktaCnThxwsLCgil8tGHDhrKmVUBJII9nzpxBXDR+/HgPD48mTZrUq1ev
QYMGSGrwQWbPnr1r167bt29nZWWlpqYqKys/e/aMd9foztPTU+Sf6O7du82b
N//77799fX1pu15CDAkMDITHJScnC3QVohRXV1d43Ny5c/lcyw93hi9gWBfK
zNI5cuRIw4YNGcWIjY0tKChgjuMFlBB6smLFiuDg4C5duuC0OnXqaGtrt23b
FtlZZGTkvn37EhMTy9rUu2/fvgiiyjUACoOESIQFfL58+QIRhmQh2sELEg1C
PMnOzobf7dy5k5+Tc3NzETzDBy0tLbds2SLoU0jEJ/CI9+/fC2Xp/+H06dNG
Rka1a9euVavWwoULISBLly6FBnbs2NHY2BgSAb+Dso0YMQLvHjp06NGjRzCe
z8YRhiEG4/PGBbIzfBUV+Cj/BRKB6EVNTc3f3x8CS6JBiDkGBgbI6Hk/iv34
8eO0adNUVVUxdp87d07ovtBI9+7dhb6c4d69e1J/gG789ddfEArIBUQD0nHs
2LF//vknPz9f6MYRq0AY+X9uu2PHjs6dOwvdHQMSEwcHB3t7+1u3buEFiQYh
/mB0Gz58OCLzUt99/PjxkCFDFBQUMHY/efKkgn3Boxs1alTBe4kXL15EPBAX
F4dkhJObiIqoqKhOnTrxfz4yHTk5OaEnwCAxGTVqlLq6+vr165HvkGgQkgJ+
q1euXDE1NUXKz3385MmTbm5u+EnPnj07IyNDVN0lJCSgzYrMNEO+Y25uLip7
uElNTVVSUhL0LnHv3r2RvgnaF8Rh48aNSEwCAgIyMzNJNAjJwtHRESM4487p
6el5eXnr1q1r3LixhYXFpk2bKhLzl0VwcHBF6mVVXk3UPn36TJ06VdCrDhw4
IOijIqRaLVq0sLOzQ4by+0+xFBINQrJwdnY+e/YsXowbN87a2hojIBL2St1U
KDs7W19fPz4+XrjLK6nW0Llz5/T09ISYxwWllZeX//DhAz8nZ2VlBQYG4kuG
ODMqQaJBSCLM7rTDhg2TlZWtXbu2aB+VlgWUSltbW+jdtOvVqwfxEaE9P3/+
bNiw4eHDh4W73NfXNzo6mvc5kAXEb1CMESNGcB5ek2gQEoqPj4+UlNTMmTM/
ffp0584d/LBF8qi0XIYOHQp/Ee5akcyN52bBggUVeSwSFxfXsmVLHickJibi
BFtbW3zDnIMkGoTkkpGRgUib8+e0adO6dOlSBf1++fJFQ0PjypUrgl4YExOD
eGPx4sUnTpxITk6u+AoRSJCysrJwk2YZCgoK0EJKSkrJt5CYBAUFQY3Xrl3L
rQ8kGkR1AhG7paUlIuoq6OvQoUMmJib8z8hiUFRUbNCggZeXFzIsU1PTunXr
wisxlPfq1Wv8+PErVqw4evTogwcP+J/G2bt3b6il4Ob/H/z8/BC0FDu4efNm
mOrv71/s+RGJBlH9gNOpqKi8ffu2CvqCswu6p4CFhYWrq+uBAweYP+F6aWlp
CQkJu3btmj9/fkBAADIOc3NzaWlpKIyVlZWHh8eYMWOWLFmCS5AmFHPhs2fP
6unpCapdJWEW1nH+vH//PhKT5s2b37p1q9iZJBpEdWX27Nlubm5V0NHHjx9V
VVWZx5F84uTk5Onpyc/9W6RgEIr9+/cjqRk9enT37t0hIwoKCpAUCIu7uztE
pn79+itXroTsfPjwoSKOXFhYiNDi6dOnSEzQFz7UmjVrSjZIokFUY379+mVj
YyPEdCYh2LJlCzIj/md+9ujRY+DAgSWTAv6B8yKmOnLkCBy8YcOGSHmQ5sDT
kfIg8YFgDh8+fM6cOYLWGkJUA0HQ0NBAzlLqxDYSDaLak5SUpKysXJHSHPzT
oUOHuXPn8nny0KFDAwMDw8LCKtgpEjF8wBcvXnCO5OTkJCcnx8fHr169WkpK
SqBZshAiZjn/zZs3Sz2BRIOoIWBMd3Z2roLfeUpKClz4n3/+4efk8ePHBwcH
+/v7V7DTXr16RURElPWuurp6WlpauY3gy7l8+TKzzi42NlZHRwcCUvI0Eg2i
5oBAHb/2FStWVEFf6KVly5b8uBUikyFDhsDrK9Ld6dOnDQwMeNwO1dfX512g
7OnTp1OnTsVp2traEA1FRcWsrKyJEyeWDIRINIiaBrwDTlFuOa+KA59q1aoV
P/uuIomAaLi4uAjd18+fP01NTXlXI2/UqFGpZdiRvEDi7O3tEZCEhITcvXu3
cePG+/btGz58+NixY+/duwc54j6fRIOomSxatAjSERQUVNnbGTx58kRJSanU
2VPc7Nmzp0OHDs2aNRO6o8jIyHLntqF97rmd+fn5EIfu3bvLycn169cvPj6e
KUg4Z84cpqn09HSkWvgIZmZmN27cYK4i0SBqMm/evEFMrqGh0bp1661bt3LP
LxUt8+bNK/f575kzZ5DRIEEQrou3b9/yUyQZXTBzWfGvn5+fgoJCu3btNm7c
yL2m5vnz59zTRBcuXOju7h4REYE45DeJBkH8oaCg4MCBAxjr4SyIyStexqfU
LqysrDZv3szjHIQBFhYWGPeF68LLy2v69OnlngbdQIgFdUIagvik1OUw7du3
h1Zw/kT6Y2Jisn//fk1NTRINgigGButJkyapqak5Ozvv2rWLR6FR7qecfHLv
3j1VVVUey9JfvXqlp6dXu3ZtIYp9nTp1ytDQkMft0M+fP8fExDCbsAwYMIDH
hLTt27dbWloWK59+7Ngx5Cnm5uYNGzYk0SCIkkAudu/ejegdbj5x4sRSJUJF
RWXQoEFIcwRqOSwsDFFBWe9+/fpVVlYWLaenpwvUbH5+vqmpaam7xOItxAke
Hh4IY7y9vePi4mAAPl1ZTX358kVdXb3UqRrIs0aPHs2ZBk8Q1ZvCwsIfP358
+vQJbo4cJDEx8fr16+fOnTt+/Pi+ffu2bt26Zs2aZcuWIWhHnA+hgHcMHz7c
x8enc+fOGGQxQBsZGcH7uMOAx48fM3MbfH19+b+tikG8SZMmiA3KOqFWrVrI
CPic78Fh3rx5Xbt2LXbw6tWr/v7+ioqKiJ02bNjAWQ0Hg3ks7vPz8xs1alSp
byUnJ0PT8DUKZBtBiBVQg9OnT48YMWLgwIG9e/eG47i6urZq1cra2rpRo0bI
3zFuysvL//333//617/q16+vrKysra0Nr2zatKm9vX3btm07derk6enZv3//
YcOGIeUPDQ2dNm0afHDp0qWxsbFbtmzZu3fvjh07cO3mzZsdHR0bNGgQHh7O
uVuIUB9tQmTQEXqHn5ZrM0IXJEE8pnkjwmnWrBlkjf/vAWKopKTE2Tbx+fPn
ERERyFnwJeCzcBbxQfTg9dAl6OGqVatKbQofQVNTE2FPWX2NGTMGXzj/thGE
GGJsbAxH3rhx465duw4fPoxx/PLly7dv30YA8PLly7S0NETdFXlEAgeHFyPf
Z/5MSkqCSmAERxxy5MgRBA8IDHR0dKAz8EQDAwOo1tGjR3nk/vPnz+ftd0g3
nJycEAjxb2TPnj1nzJjx+fPnlStXtmjRAsoD78aXUOy05cuXd+jQYc+ePYiR
Sp36juzM3Nyc93bV+D7RfqkTRwlCUrh06RLih8q7RxcTEwMvLnYwNzcXcb6D
gwOiFzjs06dPkcUgwYHI7N69GzoD70N8Uuq9TTs7O8RIPHpEswhdkDrxaeHJ
kyfl5OSY2Rd9+/aF4JS6HSRCCPj7w4cP8XrAgAF169YtuUQFYuLu7l5uj1BI
hGp8mkcQ4omNjQ3v6ZFCg0QeaQiPexf3798PCAhQUFBA+IGoA6M8o2AIe1xc
XKAqiEO4i4UioUCDvJ+VoKl+/fotW7aMHwshERAZLS0tZo8SHmdOnDiRs48z
tA4Kg0yN2zYkUHyu9UOnFhYW+/fv58dCghBPduzYUUnD35AhQ8aOHVvuaT9+
/Fi7dq2lpSXif1jCWTKGTMHLy0tFRSUiIoIZ3JcsWYI2ebfm4+ODRIbHqrRi
8FOWJyUlRUlJiVNbdcGCBePHj/f19e3SpQtHxNzc3KKiovjs9Ny5c/r6+pU3
R44gKhv88jHg3rt3T7TNXr9+XUNDQ6Cy5Ldu3YI3QT08PT3PnDnDxB7IYoYP
H46YJCgoqHnz5uXeuBg9ejScGidXyPr/S//+/bmFaPny5aNGjcL31rFjR0bH
oL0C1QkB+Ixz5szhcYLI95sjCNGCARTDtAgbLCwstLKygjcJeuHPnz979uzZ
sGFDc3NzIyMjTriCICQkJASSghyEuclQFtOnT/f39xfhx0HYAwHk3p5+3bp1
jFwgT7G1tUUK06BBgxs3bvCzuJ7Dy5cvuWOYkgwYMAA6uXv3btFu60AQoiIr
KwsDempqqqgaXLFiBY/cp9Qbjwxfv36Ni4tzdXWtXbs2M7uD89bKlSv79OkT
GRkJJ3V3d7906VKpLSxbtgzaUvENnTk4OTkhjeI+sn37dm9vb+Y1EigY2b17
d0dHRz8/P4HqgIWFhSHZKfUthFuNGjXauHFjhw4d5OXl0d3hw4crY4M8gqgI
CO8FLQJcFunp6SoqKmXdDsXA3aVLl127dnGG0VevXm3bti0gIKBp06bS0tLO
zs7h4eHwQWNjY24pc3FxYWZa5uXlxcbG4t0WLVrAm4o9DNq6dWvXrl0dHBxE
8lmOHDnSuHHjYmoAMzw8PJjXV69eheQyEvfo0SOBGkcSp6mpyVkhyw10j1Ml
9dOnT6tWrYJ8KSoqDh48+OTJkzyElyCqEiZsFklIPGjQoPHjx5f61pcvX+Ds
GGdbtWoFR0My8vfff6urq3t5eS1ZsuTmzZvcST2yJ319fWaOOoZ1WVlZ7nuY
8OW9e/fa2Ngw4zJnIczx48fhYqamphX/IDDGzMys5KaTOIIw4Pf/L9ZhYGCg
pqaGj3PhwgVBu9i8ebO9vX0x6UtOTkaDJe+aQkXxLeF8yPLIkSMRcdEiF4J1
PD09K16/69q1axhDS94ORQKCsRvhhJ6enoyMjIWFxdChQ2fMmIHAAOM1pObE
iRMlh9E1a9YgK3nw4AEG37KqeCGkb9++vZaW1uLFixHMXL9+3draGp5VwQ/y
+09mhIyp5PHz588zk1IQF0Eu8EHgy+fOnVNVVb1//75AXcDxbW1ti802QazF
e1kuIrS5c+ciPMNXPXbs2LLKlhJEFXDlyhUjI6OKDGFwfEtLS+QgzJ+vX7/m
JCC1atWCi/n4+MTFxWVlZXFf9f79+6VLl0JAlJWVR4wYgVGb24Y9e/bAHxGf
cJotlbt37/bu3RshE/wI0sR9Y0Q4vn37hkAoMTGx5FsJCQl2dnbIF9ALxIqp
ycOYCvkStFwzWoP7c+67IiuRl5fncw0LIpNp06Yh5jE0NJw8eTJNQyVYAWOf
0Bsog+jo6ObNmy9btgwuDA9itk5DaI0BWkNDIyYmhvfl8LjIyEgrKyv4UUhI
CCfxP3bsGDwUAUm5BiCpwejP3G3o06cPNEroWwFwQ0RBpb6FoAKSgi5wTuvW
rfEBOW8hYDMxMRGo2vnvP3NOpkyZwryeOXPmsGHDBLUWshkaGqqrq9u4cWO0
UAXFGwmCA8b0Nm3aCHQJEhCMvFOnToUHwZUw8Pn7+2/ZsoWzdv7WrVvI1gV6
JothNCIiwszMzMDAICwsjLkriNSDnzmWBQUFjG7AhRHDoOvg4GCBNm/6/f8L
f5W1PzWGeLRvbGyMYAOfuliEBoOLTSUtl9TUVEVFRchmXl4eFCkpKUkga7lB
njh69GgoNpK1BQsWCFqmgCCEAKOztrY2d/FMHmA4btiwobS0NJwaw2XXrl2Z
InjcINJAGF9qXQt+uHfv3sSJE+Gk8OIJEybIyclt2LCh3KtkZWU5ecqzZ8/g
5vr6+ubm5mXV5iqJr69veHh4yeMQJT8/P6YyAPPRSi0tUmwqKT/Mnj27Z8+e
+HQdO3bk/6qyKCwsPHfuHEzF99ayZUvEgTyKHRFExYmKiurfvz8/Z86aNatW
rVqIinNzc69evYrEpNjtUKQ88KyLFy9WxB4k/jIyMpcvXx4zZgzzxDMoKIj3
PQRI319//VXsIFooqxZoMSBWGPRLnoAjHf8wcOBAmIGgoqzMC4rRqVOnwYMH
8/cR/wO+Qz09PXyHvFftCQosQbIGHcMHd3FxWbt2bWZmpgjbJwiGrKwsxMx8
jsvwXy8vL6TVGhoaxUpgIVVBjsBn6MIDNMsZgjGMnjhxgklDWrRosWzZslKH
0SZNmtSrV6/U1ji1xxGTeHt7c2qPcwNhWb16dbGD+EIsLCyQgkEhmaeucEMe
95CRp9jZ2U2ePJn/T7pmzRo0K+gOknwCXUKW16tXL8Rs7u7uW7du5b2OjyAE
BSM7sgP+z0fIgR98mzZtOE8fli9fjkFf0KJbpdK7d+9i0zU/ffpkZWUFr8e4
Ly8v7+zsDI/j3nS1VatW5ZYmZoqFImaACCC94izPOX78OJKvYmLy4MEDfJwF
Cxb8/PkTooRwBZ+33E0ZMjIyTExM+H+0DXk0NTWNjY3l83z+gRa9f//+1q1b
hw4dQs4ydOhQGIaPQMkLIUIEmgP28eNHJCNJSUn4wcMHkQtMnTrVyMioXLfi
B4ySUICSDyUxVjo6OiKfwgkHDx6EtuC0zp07I8jBWxhPYT+fXTx79gwGI0cw
NzefN28eLC9WVeDkyZP4gHv27Pn9p5wgEhAbGxs4HT+rWRGPaWpq8q7kw/D4
8WMkR3fv3sV3WOw5NZ8goYNQnz17Fl8C7AwMDOzRoweEEYpXu3ZtNG5tbd21
a9cRI0YgwdywYQMUkp+1wATBPz179uRnf7Tff+4BhoaGMq/xg8cvEz6F3y2P
Sub8A01A1lDqW/jNQyjQHfPjh9fs2LGjW7duzE1RuImgfV2+fLlLly64Fj1u
2rSJub+xbt06ODJTwJCRU6QeCAwQ53z58oWfZu/fv6+qqnr+/Hnepw0bNgxh
2+8/k75K3l5m4A4bECzBEkRcrq6ujRo1gmwiNUMU0bZtW8gp/o8giUNGdu3a
NQg4La0lqgZ4CkbecnPtK1euaGlpMXOWENsPGjTIwcEBQyc8GiG3QMX6SsXH
x4fHrA+4Q9++fZ2cnLiHfmgXs58s95nl1lVGKrRkyRKIxtixY4cMGdK4cWO8
Zm7DwhORCuFz6evrT5s2TUVF5d27dw0aNOCxlLUYEA3eU0nT09MhRMysD2Z1
z+rVq7nDBjs7O3zPpYYNCIcePXrEp4gRRGWD3yrGNR4nMHWrmAAenouft5ub
W05ODvNuXFycmZkZonqh73IgYoE38V6cXlRUFBAQgACAu66ygYEB/B3/wrv5
rKuMlB/ZDdSGqau8ePFiyBGcVEdHp1atWtBD5Br4RLiQ2fgJjQu0/wsuR8JS
1mOg6dOnI8zg/InABvEDd9gAlYPiUdhAiD+7d+92dHTkcQJ+0swOzhjK4bBe
Xl7FchP8yUzDDg4OFmJAhJ9CBPg5c9GiRdx1lbdv344IAX6NkIDPusqpqanI
QZhZUpmZmfjg0BMmA+LcAIHyWFlZMU+aEJAIuvq1rKmkMA/RiEjuIRME6yCc
wGhbsqw3w4cPHxBOJycnf/78GWM3xuuykhpkB/7+/hi7EXsL9JARbUJ2hLAc
ilfWIriyGDx4cFhY2O8/S8aQYY0fP77YM1Z8D4hbBg4cqKioCLU0NDS8deuW
oIaVOpV03bp1IqwWQhCsg3GcU6CmGAMGDJg4cSIGdHNz87JWzXOTmJiIyB95
DZ+LzaFa3PsyC8SmTZvKqodTKg8ePMCI/+3bt5s3byK1WblyZbETEBIgwNi5
cyfzGkmHh4eHcE89oDxQCe6Mo1GjRmfPnhWiKYIQT75+/YrhlbPxEAfkAtra
2gjgkebPmzeP/waRqiPg79mzJ2eTo7I4c+aMra2toAYzrFq1ChEO/+e3b98+
Jibm0KFDUKpSS7uHhoby2FxSIKCHbdu2lZKSgoAgLjp27FjTpk1F0jJBiA8h
ISETJkzgPsLstIgxXVNTs+S8ynLJzc2dPXs280CTu2hnMQICAiIjI4Wx+Pdv
ZDfBwcF8nnzixAkkJkuXLtXQ0Ch1dmtCQoKamppoN2eEbEKp3N3dmfVxc+bM
EXTlHUGIM69fv0bIwe3gcDE7OzsE9kzcLhypqanIdKA8W7ZsKTlbG0fgqs+f
Pxeucbghc7OiXAoLC5Fn+fj4IFkoNSfKyckxMTGppJ2gHz16hI8ZFxc3ZswY
aJe6uvrgwYP37NkjXAZEEGJFr169ONsYpaWl1apVq169evi1V7xlpgCOvb19
sRqbyIMqEr2Hh4czc6jKBRkNIh8kDmW5KuKWfv36CW0Jb4YMGYLQi/Pnixcv
li9f3rlzZxkZGUdHRySApVYNIgiJ4Pr16wYGBsyjEKYyngjXUCC02Lx5M3IE
hB+cKsTw1hkzZgjd5rhx4/jZAik7OxufxcPDo6yprZAvGMa98kWEfPz4UV5e
vtTGkcrFx8cHBQUhhYEBQ4cO3bdvH4+9qglCPHFwcECsvmnTJsTSGzZs0NfX
F+0EReRBkydPVlZWRoqRl5enra3NY3fIchk1ahSfk+R5FDeDSVBLoSuHlMu0
adP42Zj+2bNnCPY6duyIIMTJySkyMpKKARKSApJuS0tLHR0dppBmSEgIwmmR
F9N++fKlp6enoqKiiYlJRdpB/M/ZREBoRo4cWVadwIqDiEJFRUWgan45OTnH
jx8PDAw0NDTU0tIaNmwYlJzWwhNiDvwoOTmZeV1QUIAEvCKpBA9OnjwJAalI
C97e3tu3b69IC2fPnkXMU3n3J9esWdOlSxehL4d6L1261M3NTVpaum3btgsW
LBB08ipBVA2chScMaWlpGPVK7i0iDnh4eFTkCQgGcV1dXciXCE3iBnFaw4YN
y10hyw/4n4JMCpKOzBHRoJ+f38GDBwXak5cgqpgrV66oqamVO4Or6unQoUNF
BA0pAPcqM5ETFxdnZWUl8mYRDS5evJjZ0Kri20AQROWxbNmyZs2aiVv5lzZt
2gixdRrDiRMnjIyMKnUrZ1dX1y1btoiqtY8fPx45ciQ8PLx9+/YKCgoGBgZe
Xl783HElCBbp27cvszm7+GBra1vqpqv8YGdnt2/fPtHaw82DBw80NDQqUtQI
mnbp0qWFCxf26tVLT08PWoH4aurUqUhY0tPTRWgqQVQe+Bmbm5tXRlVMoWnS
pIlwDytPnjzZuHHjyth0NScn5/r16zExMc7OzkOHDhXo2sLCQmany+HDh1ta
WtavX9/e3j4oKGjbtm20vxIhueDXq6qqKj67lCLRePbsmRAXtm7dWqD9oXiQ
lZV1/vz5xYsX+/j4QIvq1q1rY2MDx1+1ahU/M7jevn2LsCc0NNTJyUlGRsbM
zGzAgAErVqzAl5yfny8SCwmCdQ4dOqSrqyvaxV9Co6mpyec+Dr//PFNmXsDN
TUxMhN6GADnCiRMn5s6di/QBwgVnb9WqVWBg4IYNGxITE8st1fXt27czZ87g
8u7duyORUVNT69q166xZs06dOkU1AIlqTFhYmIuLSyVt/yEQioqKHz9+fPXq
1d27d+GMe/bsWb16NVxy/PjxQ4YM8fDwYCqBaGlp1atXT0pKipmnwZQj5r8X
hASHDx+OiIiAg2trazM7OqGL7du3Jycnl/s9QElu3769cuXKQYMGNWrUCNmH
o6PjuHHjYK2gO1MThOQCT4Fu8LkQlR+K3TxE+xkZGciJEhIS4uLikN1HR0dP
nz599OjRiOHd3d1btGiBeB4ZE6RAWlpaT0/PysoKvuzl5eXn5zdp0qQFCxas
W7fuwIEDCC3u378Px8/Ozm7evPmNGzeuXbumr6/PIyooKipC7gOnRjtubm4q
Kirq6uqdOnWaMmXK/v37y5qolpubm5qa+vDhw4sXLx48eBCxx8KFCydMmABT
IVnQrqFDh8bGxiIgEXr/a4KQdJCnIFvhXc2Yf5Ddw+ttbGwMDAzk5eX//e9/
KykpGRsb29nZdezYsV+/fsgCpk2btnTp0s2bNx89evTq1asY6BFpCDR7AXkB
lAQNrlmzhvs4HPnRo0dbtmwJCQlBfCInJwchQqwyc+ZMfMAnT57cuXOn1GCm
TZs2nGCmTp06SDrMzc0RS6AjhBZjx46dP3/+hQsXeNQeIYiaxs2bNzHii+Q+
f3h4uImJyfXr11+8eIEcn8/HHDk5OXXr1uW/l5EjR8LrkWjk5+efOHFi0aJF
ffr0YSqi//3334hGoAMtW7bECyaYqVWrlqysLDSkWbNmpQYz0AROMCPsRyeI
GgcCb4ywIvGa4OBgxBsla4Dz4PPnz4qKivyfP2fOHIQHzPpZaAXiiiZNmiDr
CQgIYIIZhBzcwQxtRkAQlcTAgQP53NS+XDCUw5HhsHye/+7dO01NTf7bj4mJ
gVyI25RXgqiBwA2trKyio6NF0trMmTNNTU05VX14k5SUJJBuuLq6VnDZPkEQ
ouLly5ecnVUrTlRUlIGBQVkPKJETxcXFhYSEIONA8MD/qjGkHtLS0sbGxiIx
kiCIigNf1tLS+vDhg0haW7Fiha6uLqdYcWFhYUJCwuzZs52cnOD7+BevcUSg
CSRIpmbNmiUjIyMSCwmCEAnTp09v06aNqO4lrlu3TlFRceHChZ6envLy8ogu
EGNAnYR7pvns2TMVFZVv375BdqhwFkGID0VFRZ06dRo7dmxFGvn8+fPu3buH
DRumr6//73//G5nIqlWrKh7GDB48mClZZmpqyillRhCEOJCZmWlgYMBsW88/
eXl5p0+fnjhxorW1NfKILl26LFu2jClWvHfvXjU1tbI2ruWT169fKykpMUs/
nJ2dz5w5U5HWCIIQOffu3UNGkJSUxPs0BCd3796dP39++/btkTu0bNly2rRp
ly9fLpnmHD16FA1eu3ZNaJNGjBgxefJk5rWPj8/mzZuFboogiEpi06ZNZmZm
pd5GePPmzbp16/r06aOsrIxzAgMDDx06VO5i81OnTqmqqgpX1ys1NVVRUZGz
ehdRzdy5c4VohyCIygZDvKenJ/M6KyvrwIEDI0eONDExQeTg7e29YcOGkhtY
8+b8+fO4FgIiqCWjR48eP34858/o6OhRo0YJ2ghBEFVAfn6+nZ2dubm5vb29
jIxMhw4doqKiEhMTK1JfC6kKpKPUTeTL4sOHDwg2uG+r7t+/38PDQ2gbCIKo
VCARS5YsOXv2bF5enqjavH37tpqa2t69e/k8H5EG4g3uIwkJCba2tqKyhyAI
ieD+/fsNGjTYtm1buWdmZGQg2ChWDezNmzdaWlqVZh1BEGJKcnKypqZmuds7
Tp48ueQeAQUFBX/99RdVziGIGsjz5891dXVXrFhR1glZWVkINkpd5IJwhc91
cwRBVDOgCQYGBgsXLiz13RkzZgwePLjUt2xsbMSnHjtBEFUMwgZTU9NZs2YV
O/7t2zcVFZWy9kfo1q3bwYMHK986QmRQXkmIlg8fPpibm3OmgzLMmzePRymh
gIAAHgkOIW4kJSVJSUmFhIQ8evSIbVuI6kNGRkazZs3wu2L+zM7OVlNT4zHR
ffbs2SKsxE5UKkVFRRgX1q5dO2XKFE1NTVtb29WrV/OzmxVBlMuXL1/s7OxG
jBiBn9miRYt69erF4+SNGzf6+vpWmW1ERdi1a5e9vT3zurCwMD4+3svLS05O
zsfH5/z585WxTSdRo/j+/bujoyMEQUND4/79+zzOPHnypKura5UZRggNhMLM
zKzk4gJEmEuXLrWwsDAwMJg1a5agaxYIghtkKNbW1uUuW0Oa3KhRo6oxiXVa
tmyJIZttK4Rk69atrVu35nHC7du3AwICFBUVO3TosHv3btpOlxCOvLw8BB68
z0FSg0C3auxhl6tXr0pJSYlqb6wq5tevX0ZGRkhGyj0zNzd3+/btLi4uSkpK
QUFBvKNNghCaevXq1YQ91Lp27WpjY3P48GG2DRGGjRs3tm3bVqBLXr9+HRER
oaOjg7BzxYoVtEk3IVpMTEz++ecftq2oXB4/fqyuru7u7i6JulFQUKCnp3fl
yhUhri0sLDx16lTfvn0RVeLf06dP0+1TQiRgIDt79izbVlQuvr6+c+fORcgh
ibqxZs2a9u3bV7CRzMxMRB3NmjVDBII4JCUlRSS2ETWW/v37b9myhW0rKpG3
b98qKChkZWVJom7k5+fD0xMSEkTVYGJiYlBQkKKioouLy44dO2jDPkI4QkND
582bx7YVlUhwcDBT5UwSdSMmJqZz584ibxZytHv3bjc3NyUlpZEjR965c0fk
XRDVm4CAgGpcLZDZbptZ8ytxuoFgQFNTs1Kd+s2bNzNnztTX12/atOnSpUvx
dVVeX0R1Yv369bKysvHx8WwbUinMmDFj6NChzGuJ0w04cvfu3augo6KionPn
zvn4+EhJSXG+LoLgDUTD2Ni4R48e1ex2WXZ2tqqq6pMnT5g/JUs3cnJy1NXV
q3gCxuPHj6kEHME/eXl5s2bNQrY7e/bsajPVMDo6mlNJ/rek6UZUVJSXl1fV
96ugoPDx48eq75eQXF6/fu3h4YHY48SJE2zbUlEKCgp0dXW5qxJJkG78+PED
kRKzT18V4+bmJlCdfIJgiIuLMzIywkj95s0btm0Rnq1btzo7O3MfkSDdmDt3
rre3NytdT506NTw8nJWuCUkHacvMmTMVFRXnzJkjoWmLubn5yZMnuY9Iim4w
JdrYmsSLYAMhBytdE9UDpC3du3c3MTEp5oDiz/Hjxy0tLYsdlBTdmDFjBotF
UT5+/KigoMBW70S1AT5oaGgoWWmLo6Pjzp07ix2UCN348uWLsrLy8+fPWbRB
X1+f8xCKIISGSVuUlJSQd4t/2nLt2jUDA4OS9XslQjfCw8NZn0HRu3fvrVu3
smsDUW149epVt27dkLYIsaV1VQIjV65cWfK4+OsGM7u11J1uqpKFCxcGBQWx
awNRzUDagtG8Z8+e4pm2JCUlqamplbpcS/x1Y9KkSf7+/mxb8fvy5ct2dnZs
W0FUN5C2zJgxA2n4vHnzxC1tGTRo0OzZs0t9S8x1Iz09HcGGOBQIzc7Orl+/
vrj9nyWqBy9fvoQnmpqaik/aAqeD65VV20rMdWPcuHGBgYFsW/FfrKysbty4
wbYVRLXl2LFjhoaGXl5e4jBQhoSEwPvKelecdSMtLQ2K9/79e7YN+S9+fn7L
ly9n2wqiOpObmzt9+nQlJSV205bMzEwFBQUe22SLs26MHj2as1uWOLBu3boB
AwawbQVR/WHSFjMzs9OnT7NiwMyZM4cMGcLjBLHVjXfv3iHYEKvVZA8fPkQG
yrYVRE3h6NGjBgYGvXr1quK0JScnR1VVlffcbLHVjYCAgNDQULat+D8UFhbK
yMhQFXSiykDaEhERgbQlJibmxo0bVbOBKZLxHj168D5HPHXj9evX+K4yMjLY
NqQ4Tk5O4nPHm6ghIG1B1GFtbV2/fn1NTc127dqNGjUK3n3mzBmE5aLt69ev
X3p6euUW7xVP3Rg2bNiUKVPYtqIUEALNmjWLbSuImktKSsrJkyeXLl06YsQI
jGLq6uqIgW1tbZntCQ4ePJicnFxQUCB0+9u3b0ez5Z4mhrpx7949fBtZWVls
G1IK+/btwzfGthUE8T+QOF+7dm39+vUTJkzo0qWLsbFxnTp1GjZsiFwjLCxs
y5YtN2/eLHeTSg4WFhb81EcVN90oKiqyt7ffsGED24aUztu3b9XU1Ni2giB4
kZeX9/Dhwz179sycOdPb27tZs2b16tXT0tJydXUNDAyMiYk5e/ZsqdMb4uLi
mjZtyk8X4qYbkE0HBwdx3kBNQ0OD9cUyBCEQcCj8aBFILFmyxM/Pr02bNqqq
qrKyshijBw4cGBkZeejQoSdPniBDQZ7CT4NipRuZmZkYzZGnsG0IL7p37w4l
Z9sKgqgocLcrV66sW7du3Lhx7u7uyG6gG3wO2WKlGxKxbc3cuXN5zL8lCMml
sLCQzzPFRzfu3Lmjrq4u/rMjzpw54+joyLYVBMEmYqIbiI7s7Ow2btzItiHl
8/XrV2lp6ZIVkAii5uDt7d2uXbupU6ciZ09OTmbLHZBktWjRQpxvh3LTqFGj
xMREtq0gCNbIy8uDYkA3PDw8jIyM6tat26xZM19f36ioqJMnT6alpVWBDZmZ
maqqqhLkiQMHDlyzZg3bVhCEuJCdnX3jxg2M/mPGjHF2dlb+Q9u2bYOCguAp
169f538CCf+MGDFCfIps8MPKlStZr3dKEOIMQo5Tp04tWrRo0KBBNjY29erV
MzAw6Nat25QpU3bt2vX48eMKpja3b98W29mhZQGbLSws2LaCICSGwsLCJ0+e
7Nu3LyIiwtPT08TEpE6dOpaWlj4+PgsWLIiPjxdooU1RUZGtre2mTZsqz+DK
4OfPn/Xr1//x4wfbhhCEpJKTk3Pr1q0NGzYEBwe7uLioqakpKCi0adNm1KhR
q1evvnr16rdv38q6du3atS1btpSU26HctGjR4sKFC2xbQRDVh/T09DNnzixZ
smTIkCEIJ+rWrevg4JCXl1fstM+fP6uqqt6/f58VIyvImDFjEF+xbQVBiB1w
f1NT0yNHjlSwndOnT9vY2JQ87u/vL7k7kmzevLlTp05sW0EQ4kVmZqaUlFSv
Xr0q3hTEYe7cucUOIrVp0KCBZN0OZUDgFBMTo6WlhSyMbVuIGsrixYvhnmxb
UZycnBw9PT05OTmRVFTW1dV9/Pgx95HCwkLkLxiyK954VZKdnY3kS0NDo2vX
rtA9ts0haijPnz9XUlJisWpxqcAkqT+IZBvlxMREIyOjYgdjY2NbtWpV8car
jO/fv8+fP19dXb1nz54SND+NqH4UFRU5OTlh/Fq1ahV+jWyb8z8Y0RBV5ZyZ
M2cW28tAsm6HIpPCR1BRUfH29i4WNRFE1YPs2N7eHhH7t2/f5OXlP3z4wLZF
/2HkyJGiuq3B0Lx58/Pnz3Mf8fPzGz16tKjarzwyMjLCw8MRfQ0aNOjp06ds
m0MQ/9kcRFlZmTN+wZXK2r+1KkHkwwQboiq3npqaqqioyD2h9ObNmxoaGmJ+
O/Tjx4+hoaFQDPx/efXqFdvmEMR/cXd3R/TL+fPu3bu6urr8F82oDA4cOMDc
2YiIiBBVmxAiHx8fzp/4gAg/tmzZIqr2RQ6ELjg4GFoXGBgoDnt0EgSHHTt2
NGnS5OfPn9wH4VBxcXFsmXTp0iXEP1ZWVtCNhw8fiqrZTp06cZfUQ2rWunVr
UTUuWlJSUgICAqAYY8eOrZpVwATBP58+fVJTUyv5FG/dunXdunVjxSQIhaqq
akhISOPGjUX4UPjHjx8yMjKcSeYZGRno5cGDB6JqX1Q8f/586NChUIywsDD8
32HbHIIoBW9v7/Hjx5c8np2draCgIPLdl8rlzZs3WlpasbGxULNBgwbZ2tqK
quV9+/Z16NCB8+fw4cPHjBkjqsZFQnJy8oABAxBoITUT//qERI3l6NGjRkZG
OTk5pb47atQofu4t4NcuKns+f/5sZma2aNEiHR2d48ePY8wtObFTaHx9fWNi
YpjXN27c0NDQqJrdLfkBIVafPn0glXPmzOGx7I4gWAdeg5GdxyJK/Jg1NTV5
l7NA6o1UAhlNxR9JQL4cHBwmTpzYs2dPRAIwDy2LaooCPgXGcebWYmFhoY2N
zdatW0XScgW5c+eOh4eHurp6VFQULYQnxB8/Pz9/f3/e57Ro0aLcKsH//PMP
HLxWrVonT54U2hj4tbu7O0KCNWvWNG3aND8/f9euXSK8uXHp0qVmzZoxr1et
WiUOBcCvX7/euXNnSHd0dHRubi7b5hBE+Zw/f15bW7vcQJ3PVZYvXryQlpb+
66+/oEXCFe4bMmRIx44dEV0gKoAQ4QiijpYtWwrRVKmMGzdu+vTpv/8sqlVS
UhLhMxohuHjxoqurq56e3urVq0Wy4oYgqgBkBIaGhseOHSv3TIyDioqKKSkp
5Z4J6dDQ0EDMoKure+7cOYHsCQ8Pt7W1RV7fpEmT9evXMwcRbIiwoISJiQky
gnXr1qFZdCeqZgUF32SbNm2MjY03bNhQkU26CaLqGT9+vLe3N58njxkzZsqU
KfycCelADBMZGYnYOzAwMDs7m5+rkDUYGRl9+vQJl/Tu3Zs5+PbtWzh4UlIS
n0byJjk5uU6dOmZmZm3btr1x44ZI2hSOjRs3btu2jfY6ISSOmzdvqqur8z8x
AE6H8/kcHBnpWLlypa+vr4GBweXLl3mfv3//fkQpr169OnLkCOJ2zs3VmJgY
Ud3cQPCjpqaGNOrEiRMiaZAgaho/f/40NzffuXOnQFchtN63bx+fJzPSsWbN
mqNHj0ITxo4dW9ZNv0uXLqmoqNy7dy81NVVVVfX69euct5ydnSt+6/L27duu
rq7IyJAXVOSeLUHUcGbMmNGlSxdBr9qxYwcckP/zOdLx+fPnvn37mpiYJCQk
FDvn4cOHEA0EA4WFhU5OTnPmzOG8VVRUhGBjyZIlgtrJ4cmTJ15eXlCt1atX
f/z4UV5enm4/EoRwME8rhJgCCqfDhVAD/i/hSMfvP8kIMp1JkyZxnDclJUVL
S2v37t14PXv27LZt23KvoUMEIvTMDYQuw4cPh7WRkZHMfLYNGzaIcBk+QdQo
4Jh2dnaxsbHCXT5+/PjQ0FCBLuGWjvT0dE9Pz8aNGyN3QBBiamoaHR2N49eu
XVNTU4Ozc18IJRHi5kZmZuaECRMUFBQmTpzIPUnbw8NDTKZ4EYTEsXjxYgzr
Qu8M8uzZM1VVVUGjfW7p+P0n30FugtgDrv37T+kqXV3do0ePFrvK0tLS2dmZ
/16ys7OR5igpKfn7+79//577rdzcXFlZWUiKQGYTBAFevnwJt3r+/LnQLdy6
dQsxABxf0AshHUhJ1q5d+/vPpFBXV1djY2Mow/3795E+lNx3IC8vDx0tW7aM
n8Z//vwZExPToEGDPn36QNlKngBRgloKajNBEL//PJ5YuHChEBciuzl48GDr
1q0RGDClt4KDgwWdbAm9QtQB6Rg8eHCnTp0KCgo2bdqEpuTk5Eo+ajl79iw/
NzcQOO3cudPAwKBDhw53794t67Thw4cj0BLIWoIgfv/Zu9DW1lbQuUY/fvyI
jo42NDS0t7ffs2cPLsfgDk8fO3Ys4ofmzZuvXLmS/7VskA6oAWftbXJysoyM
jKOjI9opJhEhISHl3tyIj49HxIIPxXtnQ2gLciKBbucSBPH7z/MFFRUVgSKE
d+/eMdUsvby8rl27xv1WWFgY/BpByIkTJ3r37g0Z6d+//7lz5/i5bWJlZSUr
KwsRQybStGlTJnNZs2aNsrLy/PnzOc9TdHR0eDzzvX79eps2bRo2bHjgwIFy
e0xISDA3Ny/3NIIgitGtWzf+63PeuXOnX79+CgoKSEZKrX+Lg3BzTnLx+fPn
ZcuWQQT09fVnzJjx5s0bHo1DN65evYqEpUuXLshWOMvfUlJS2rVr5+Dg8OTJ
EzSIYGP58uUlL0dYgs+Cyzds2MBn7DR58mQIHT9nEgTBYffu3Y0bNy73IQii
hcOHD2Mch1cuXLiQ9yLZjh07lizkC8EZNWqUoqKim5vbrl27Su3RzMwM6Qmz
6B6BR/369SFB1tbWPXr0QAwzYcIEHJ84cSL+ffToEfeFr1+/9vX1RdS0ePHi
kptB86BJkybcc1AJgiiXjIwMZPe8l3FlZ2evWLHCyMjI1tYW/s7POH7w4MGy
tjaDUzMzS5n628X2EdPV1YUC/Oa6TZqenn7r1q19+/ZBrIKCgnAhc+v1r7/+
srCwQFji7+/v6emJIxCWYg9Yy+Xly5dqampCP3cmiJqJj49PsY3JuElNTZ00
aZKSkhIc88qVK/w3C23R0NAoFhIUA6nH9OnTdXR0mjVrhqSDmT6hqqr68eNH
5gSOdBS7sF69elAMeXl5BB4IYKAYnTt3hoDY2Ngg3qhbt27Dhg07dOgAPZk7
dy40ConPu3fvShWHJUuWDBs2jP/PRRAExnE4ZqkLyu7duwdJUVBQGD16NAZl
IRqfNm0awolyT4M7nz592tvbW05Ork+fPsW2TyopHcwzF+jMkydPIBQDBgwo
do8F0dHjx4/j4uJWrlwJYUGbDg4OELG///4bIVO7du2GDBkyY8aMzZs3X7hw
AZJ15MgRIT4dQdRY4EScWZoM8GJmEpSWltaCBQsqUg707du3MjIyfJbXAF++
fGHWxaNraA5HDYpJx+rVqzm7pQhUNw/50dOnT6FRaCo8PByqiEwKukFlLgiC
f+BBxsbGHK/JycnBAG1iYoJBHLG9SMpMwcEXLVrE//k/f/6sXbv2gwcPEOQo
KytD1rZt2wZx4JYO5CNolu5IEAQrWFtbM7uSpaWlTZ48GX7q4eFx6dIlEXYB
f1dVVQ0NDeVzxQoyFFlZWeY1LoF5HTt2RK4UEBBw+fJlZg0LRKNr164iNJIg
CD7Zu3cvdOP+/fu+vr7y8vKBgYEVWZbCg0+fPkGOLC0t+Vnw/uHDBzU1tWIH
3717N2vWLAMDA0RHzJOUUmduEARRqSA3UVJSQmqvqakZGRlZBXt+rV+/Hj0u
XbqUd37x6tUrPT29Ut/ChefPn0caBd04depUpVhJEEQZQCXk5OT+9a9/bdu2
rdgm0ZXKy5cvW7Ro4eLiwqMiUFJSUsOGDXm3Q3c2CKLq8fHxwZB98+bNqu8a
cc7s2bNVVVWZEl4luXPnDmfbI4IgxIfJkyfLyMiwaMDt27dNTU0hXyVnql+9
ehUxCStW/f6z/DYkJGTIkCFsGUAQ4klWVpaSkhKSFHb3Ss7JyRk5cqSOjs7F
ixe5j585c6Zdu3ZVaUlhYeGlS5eCg4Pr1KmDMExfX79kbWSCqOEg2MB46ubm
dvDgQbZt+U99DA0NDe6ntEePHnV3d6+Crn/8+LF///6BAwfWr19fWloaiuHl
5cXuro4EIZ6kpaUpKiq+fft2wYIFo0aNYtuc/8B5SsusZNmzZw/8t/K6S01N
Xb16defOnZGp2dnZWVtby8rKTp069cOHD5XXKUFINEgNxo4d+/vP2hNTU1O2
zfkf69evV1ZWXrp06ebNmwcMGCDy9u/fvz9r1qzmzZtDNvv167do0aKmTZua
mZnFxsbSDu8EwYMXL14oKSllZGT8/vMoE36KwINto/4H85S2UaNGyB1E0uDP
nz/PnDkTFBSkp6dnaGgYHBx8+vTpuXPnampquri4HD9+nJ7nEkS5YJydOXMm
58++fftytnQXE379+jVixAgpKamyntLyQ1ZW1o4dO/DpFBQU7O3tIRTIgJ4/
f468TF5eHqKE2EOENhNENQbOoqam9uPHD84RiAaci0WTSgVuDgcv6yktD169
erVs2TIEErKysl27dl27di1zy+LSpUvdu3dHcDVlypS0tLRKM5wgqiGdO3dm
Nj7j8ObNGxUVFXGL1adOnTpjxoyyntIWA8bfvHkzPDy8adOmUMUhQ4YcOnSI
WbZfUFCwfft2GxsbExOTVatWMdXRCYLgH3ifvr5+ySnlGNbv3bvHikllMX78
+AULFjCv4+PjGzRoUHItbV5e3vHjx/39/fFuo0aNJk6cePXqVU6dc+Qp8+fP
19LScnZ2Pnr0qLgJI0FICg4ODtu2bSt5HGN6VFRU1dvDAyQp3GtdMzIyuJ/S
glmzZklJSUEu5syZU2wB78uXL4OCghQUFAYMGCBuekgQksXhw4ebNGlS6rB7
8OBBNze3qjeJB8g11q1bV+wg5yktPkVCQsK0adO6dOmCxERTUxOqMnfu3AMH
DnTr1k1JSSksLKzY3tMEQQgKovfGjRsfO3as1He/fv0qLS0t0JYBlY23t/f2
7dtLHi91LS0OLlu2DHLBFOVA2jVo0KCVK1feuXNHJMXKCKJmsnnz5rI2I2BA
CnP27Nkqs6dcED+UtcMa91ra79+/I8PS1tZ2cnJCQIU4BO8mJibGxsYOHToU
8VW9evWgM8HBwTt27KikekQEUS3Jz8/X1dXlvXnB1KlTJ02aVGUmlUuHDh3i
4+N5nMCspUWG0r9/f8QVZZ3248ePCxcuzJ8/v2fPnjo6OohJOnXqNH369Li4
OGbmG0EQpYIYvtw1YhcvXmzevHnV2MMPbdq04b0H9O8/a2mTk5MFajYtLe3Q
oUNhYWHIdOTk5IyMjJAQLVmy5Nq1azTPnCA4IJJXU1N78OAB79N+/vwpIyPD
bHgkDtjZ2VX2MnYkNUlJSZs2bRo5cqSNjQ0yGvwbEBCwceNGHGduINPOCETN
BDG5j48PP2d27tx57969lW0Pn1hYWFTxPPC8vDxEHUuXLu3Xrx/iEFlZWcgI
jwyIICQOPh8TfPr0SVFRsdSd4kuCcN3Pz69CZokOY2Pjp0+fsmhAVFRU7dq1
6WEuUZ3AsBgaGlpusYjg4GB+NlhkePjwoaGhYYVNEw1aWlpsrdL98eOHt7e3
tbU1s6s1QVQb4FPMXIWOHTseOnSo1PAjJSUFwQZna2Z+UFdXF24HWNGCj4OP
xopuIMgxNzcfPHgw3SYlqiXIxydOnAj/QkivpqY2YcKEYg8X+vbtGx4eLlCb
AwYMWL16tUjNFIwvX75ERkZqamra29tX/ZStgwcPqqioFNsnlyCqH/fu3bOy
snJ0dBwzZkyDBg1atGixdu3a79+/I9jGoKmjozN37lz+a99t3ry5Uqvz8eDF
ixdIqRQUFHx9fRMTE6u491+/fk2aNElXV/fWrVtV3DVBsALG5Xnz5ikpKUVH
Rx89erRHjx5ycnKDBg26dOkSvGDYsGFwxl69evEzHfT9+/dIbThLSquGy5cv
e3h4KCsrT548GQZUZdcMnz59cnFxcXV1pZlgRE3jyZMnrVq1atmy5T///JOe
nr5w4cLGjRsjhUG88ebNm5iYGAsLC/wZFRXF2ztwVdWMuZC7HTt2NG/eHFat
XLmSKZdR9dy4cQNRGSSritWSIMSEoqKiFStWYOCGVjA3BxISEvz8/OTl5Tt3
7rx///6rV68OHDgQ0Ui/fv3K2m4e+Q4urwzzvn37tmXLlp8/f2ZlZS1YsEBb
W7tt27ZHjhxhsTLG6tWrVVVVDx8+zJYBBCEmpKSkdOjQwdLS8u7du8yRnJwc
OKyTkxN8JCQkJDExcenSpQ0bNmzUqBFeFNtLGpmOyDc8unjxoq+vL/QKPTKP
gXr27MkxjxVyc3MHDx7cpEmTZ8+esWgGQYgVEAqoxKRJk7ifJz5//nzKlCma
mpq2trYYas+ePYvAA+6MIOT69evMOd+/f5eWlhZJPb13797NmTPH0NDQ3Nw8
IiKia9euSkpKiGeCgoIQFLVv3x4hECvr3F++fGllZeXt7c1WckQQYsvHjx97
9eplYmJy+fJl7uNI5OPj4728vKAYPj4+p06dioqKMjIysrCwiImJ+fr1q6Oj
44kTJ4TuF5nI3r17O3XqpKioiCxp7dq1dnZ2aB85FMdP8/Pzt2/fjo7U1dUh
ZYiRKvRRBSEuLk5NTa1YkVWCILg5dOgQAoyRI0cikCj2VkZGBvIUyIWBgcGs
WbPgUNAZBQUFV1dXf39/Ifp6+PBhcHCwioqKs7Pzxo0bFyxYoKOj06ZNG9hQ
1l3H5ORkRCBQmM6dOx8+fLhS15EVFRVNnz5dS0vr6tWrldcLQVQPvnz5MnTo
UG1t7bIqWty+fTsgIADO26FDh61bt4aGhkpJSVlbW69Zs4Z7x4SyyMrKWrVq
VfPmzeGS4eHhjx8/hnowG6KhZX4sRDK1adOmFi1aoAW4NnctL1GRmZmJEAgi
Rjs5EgT/nD17Vl9ff8CAAZ8/fy71BDgvcgcXFxe4PHTj6NGjHh4e8vLyI0aM
KHVpKobvc+fO9e/fH/kOAhWkNteuXUP6g8uhPMLNEn/w4AFCI7TQvXt3xD+i
etRy7949xFRjx46lsoEEISjZ2dmIBNTV1ffs2cPjtNevX69du5bZLuH9+/cz
Z85EGGBvb4/Ug7lfCk3AQXhi06ZNly1bhnwHDTo4OOBIdHQ0PyEKb9ACDEAA
o6urO2fOnApGCIhkkDrx/sgEQfAmISGhUaNGGND5n5xZWFiI8ANxPuIQiEOd
OnUQFSAH+fbt2+LFi/X09Fq3bn3gwAGRT526c+fO8OHDEfMgjDlz5oyg4Ud+
fj6CJTMzs6SkJNEaRhA1EDjUtGnTlJWVS+41UCrIU4KCgpSUlKAP/v7+ampq
eDFjxgwkFH379r1582alWgt1WrlyJWIbY2PjBQsWfPr0iZ+rEBTZ2dl5enri
8ko1jyBqFA8fPkQu0K5du7LWzn/58mXFihXW1tba2toRERGcehQFBQWILgIC
At68eVOF9v6+fv36oEGDEH54e3vz3vnx7NmzSMc4O74RBCFCfv36FRUVhUBi
yZIlnCwD6cDp06cRSMjJyeHfU6dOidUmiVCzZcuWIdVCAgKzS9ZEjYyMbNCg
wfnz59mwjiBqCs+fP3dyckJUjxeIK3R0dJo1a4ZIQ3zKFJfK5cuX+/fvj/DD
19f32rVrv//cUPXw8HBwcKiMJ7kEQRQDEUVsbKyKikpQUFDVl7+oCBkZGQsX
LjQ2Nm7SpEmLFi1GjhxZbPtpgiAqlaysLLZNEJ5z586tWrWKbSsIgiAIgiAI
giAIgiAIgiAIgiCI6s//A2vXjTo=
              "], {{0, 342}, {360, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 342}, 
            PlotRange -> {{0, 360}, {0, 342}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ca7b3fed-b906-4626-a3a1-ac7dde9b7891"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x17.6"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"64b2c7ee-1eaa-4970-8580-4bfb698df356"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b0d4b753-9279-4dcf-8c88-d36b23b5b999"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d86a6aa7-254d-47f6-8d76-0adbc9f70c0a"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Units: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[" 17  Units", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
17-units.html"], None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+17.1", "17.1", "17.10", "17.11", "17.12", "17.13", "17.14", "+17.2",
          "17.2", "+17.3", "17.3", "+17.4", "17.4", "+17.5", "17.5", "+17.6", 
         "17.6", "17.7", "17.8", "17.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+17.1", "17.1", "17.10", "17.11", "17.12", "17.13", "17.14", "+17.2", 
      "17.2", "+17.3", "17.3", "+17.4", "17.4", "+17.5", "17.5", "+17.6", 
      "17.6", "17.7", "17.8", "17.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[7651, 196, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e518103b-012b-44fe-bb64-81e0d0fbbbf4",
   CellTags->"FirstInputCell"],
  Cell[16251, 420, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3358b576-40c6-4907-b280-84850cd44430",
   CellTags->"FirstInputCell"],
  Cell[24692, 642, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5917aea5-f0ce-42a0-8a8f-e0b6ae105b49",
   CellTags->"FirstInputCell"],
  Cell[32277, 852, 813, 26, 
  70, "Input", "ExpressionUUID" -> "05a239cf-f0b2-457c-9ca1-b7b0bd4dba06",
   CellTags->"FirstInputCell"],
  Cell[39602, 1056, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4df29a85-9867-4961-975d-638d69e2d345",
   CellTags->"FirstInputCell"],
  Cell[46703, 1257, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0abc02a3-fdce-472d-b303-f7f9a28f54fe",
   CellTags->"FirstInputCell"],
  Cell[55145, 1481, 813, 26, 
  70, "Input", "ExpressionUUID" -> "fd7c2ebe-7861-44bd-899b-2af4e8227592",
   CellTags->"FirstInputCell"],
  Cell[73906, 1875, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0ad71d5a-7a6b-4d02-81ef-2060bac5a08a",
   CellTags->"FirstInputCell"],
  Cell[80891, 2078, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a633fa5f-8b30-49b3-8b28-c4a591f9ed01",
   CellTags->"FirstInputCell"],
  Cell[121771, 2833, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8dfa8388-986c-4c34-82cb-46ac32bdcd75",
   CellTags->"FirstInputCell"],
  Cell[245472, 4954, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c249f4b7-f336-4001-9c72-e1040e4cd510",
   CellTags->"FirstInputCell"],
  Cell[299784, 5931, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d66cce7d-b3d2-4278-982f-598acb6a4a87",
   CellTags->"FirstInputCell"],
  Cell[573619, 10513, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4ed2393d-6ddc-4c3b-9651-1225560d2f6d",
   CellTags->"FirstInputCell"],
  Cell[696030, 12606, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3c8b2790-8430-4bb8-9423-281a547b159d",
   CellTags->"FirstInputCell"],
  Cell[706171, 12856, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0f5b7817-74e7-4a0f-9a0e-12414f185144",
   CellTags->"FirstInputCell"],
  Cell[713737, 13064, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4f044208-b4ad-408c-862c-daaad14da784",
   CellTags->"FirstInputCell"],
  Cell[734363, 13495, 813, 26, 
  70, "Input", "ExpressionUUID" -> "604455bd-8460-45af-9e77-f5ed9a9413b8",
   CellTags->"FirstInputCell"],
  Cell[807846, 14784, 813, 26, 
  70, "Input", "ExpressionUUID" -> "454c9e89-d0ed-486a-b4cf-7fb3c8d6ba33",
   CellTags->"FirstInputCell"],
  Cell[822042, 15103, 813, 26, 
  70, "Input", "ExpressionUUID" -> "99995350-1c22-4099-8726-4e650658f995",
   CellTags->"FirstInputCell"],
  Cell[886093, 16239, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b0d4b753-9279-4dcf-8c88-d36b23b5b999",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 945056, 17457}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[626, 21, 423, 9, 70, "Exercise", "ExpressionUUID" -> \
"3972e511-6676-4d60-a0cd-dc618e5a4193",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1074, 34, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"57d138c1-3c38-434d-9a8f-ee3756f85eec"],
Cell[1713, 55, 5331, 116, 70, "ExerciseOutput", "ExpressionUUID" -> \
"94745e09-aa08-4ce2-b548-e6b7d6fcd360"]
}, Closed]],
Cell[CellGroupData[{
Cell[7081, 176, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4e0f7d29-6b2d-4b55-96a6-7e79a4bf3c05"],
Cell[7651, 196, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e518103b-012b-44fe-bb64-81e0d0fbbbf4",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8501, 227, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"aa8129dc-a579-45f1-8b4a-95b32bc245d3"],
Cell[8788, 238, 426, 9, 70, "Exercise", "ExpressionUUID" -> \
"789542b0-4081-4d00-bdfe-c67d7e11b568",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[9239, 251, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"837fdf24-3c4e-4e76-abdf-434944e1a829"],
Cell[9878, 272, 5766, 123, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ac5e66e3-6dfe-4c98-aca7-b9c448adc97c"]
}, Closed]],
Cell[CellGroupData[{
Cell[15681, 400, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2937db3f-b309-42c5-ad43-a1e289c4c1e6"],
Cell[16251, 420, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3358b576-40c6-4907-b280-84850cd44430",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17113, 452, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"804ebe22-85d9-47aa-a05f-0b6c588ca926"],
Cell[17400, 463, 430, 9, 70, "Exercise", "ExpressionUUID" -> \
"d8d254ae-8a73-4a8c-8539-d1f2fa6f5fb9",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[17855, 476, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"460b3c23-05ea-4607-86d1-72b2b319d8dc"],
Cell[18494, 497, 5591, 120, 70, "ExerciseOutput", "ExpressionUUID" -> \
"940fc46a-4d34-4242-8776-91c375709343"]
}, Closed]],
Cell[CellGroupData[{
Cell[24122, 622, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"949b42ee-b319-4ef0-8250-ff051ac7d820"],
Cell[24692, 642, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5917aea5-f0ce-42a0-8a8f-e0b6ae105b49",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25554, 674, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1bee78e1-aaa0-436f-9ea0-ef9914826fdd"],
Cell[25841, 685, 468, 11, 70, "Exercise", "ExpressionUUID" -> \
"2f6708d9-8d15-4a30-9604-343092b5cd8f",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[26334, 700, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f02a5e4f-0c58-436f-bba4-c94f55d79a00"],
Cell[26973, 721, 4697, 106, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e89a7ae1-d343-4911-8343-306bdb3acd2f"]
}, Closed]],
Cell[CellGroupData[{
Cell[31707, 832, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"e2d0d483-a2b9-4d34-9221-f05260713bd3"],
Cell[32277, 852, 813, 26, 70, "Input", "ExpressionUUID" -> \
"05a239cf-f0b2-457c-9ca1-b7b0bd4dba06",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33139, 884, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1a48b9bd-74de-405d-944f-f4fcbeee8bd1"],
Cell[33426, 895, 444, 9, 70, "Exercise", "ExpressionUUID" -> \
"0c502e7d-9dd6-418d-89a9-81c69a1a1158",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[33895, 908, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d812ae4b-25b6-4370-b32c-b5bae1f493aa"],
Cell[34534, 929, 4461, 102, 70, "ExerciseOutput", "ExpressionUUID" -> \
"78de3961-36eb-44fc-bcda-2b4cfc40d903"]
}, Closed]],
Cell[CellGroupData[{
Cell[39032, 1036, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"dcdeef52-6afb-438b-8d0a-dd3152bd9745"],
Cell[39602, 1056, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4df29a85-9867-4961-975d-638d69e2d345",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40464, 1088, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"94691f7f-507f-4ad8-bed8-6b6db59622dc"],
Cell[40751, 1099, 473, 10, 70, "Exercise", "ExpressionUUID" -> \
"41ccb7f5-5f83-4916-9e57-4d91a90d6329",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[41249, 1113, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"2908a9e2-0393-4651-a046-a85fc3a6603f"],
Cell[41908, 1135, 4188, 97, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1cbf4350-6d4c-4b3a-a2a8-aef36e0cff7a"]
}, Closed]],
Cell[CellGroupData[{
Cell[46133, 1237, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a5c7a315-f2dd-4c58-a9df-5edb7df194ed"],
Cell[46703, 1257, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0abc02a3-fdce-472d-b303-f7f9a28f54fe",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47565, 1289, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b18362c5-f883-412c-b0c4-0226f3813459"],
Cell[47852, 1300, 463, 11, 70, "Exercise", "ExpressionUUID" -> \
"31c28789-079b-4a29-87a2-e054bf8acacd",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[48340, 1315, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f58eff40-4024-400f-8787-9f4e098872d6"],
Cell[48979, 1336, 5559, 120, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dd7f71fc-887c-4f59-ad9e-44ba0eee18bf"]
}, Closed]],
Cell[CellGroupData[{
Cell[54575, 1461, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"424def3b-3b2f-4396-96a4-988cca762674"],
Cell[55145, 1481, 813, 26, 70, "Input", "ExpressionUUID" -> \
"fd7c2ebe-7861-44bd-899b-2af4e8227592",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56007, 1513, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"adb83892-f666-4620-8378-4dd3dd93eed3"],
Cell[56294, 1524, 633, 15, 70, "Exercise", "ExpressionUUID" -> \
"4c7f71f8-ee43-418e-95c6-41e929c7ffe9",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[56952, 1543, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"382bc26b-e440-4109-90e5-7fa72f600e00"],
Cell[57591, 1564, 15708, 286, 70, "ExerciseOutput", "ExpressionUUID" -> \
"aa890ae2-7901-440e-b461-3b02ef42d4d2"]
}, Closed]],
Cell[CellGroupData[{
Cell[73336, 1855, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"dd9452f6-b8b7-47c5-bf21-4765694cb3d8"],
Cell[73906, 1875, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0ad71d5a-7a6b-4d02-81ef-2060bac5a08a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74768, 1907, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"5f6dcd2c-715e-465c-bd8f-4383519e8abf"],
Cell[75055, 1918, 547, 15, 70, "Exercise", "ExpressionUUID" -> \
"24f1e3dc-2282-486c-a0f7-1ca6ce25151b",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[75627, 1937, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ea633e42-8dd5-4c41-95ee-08a7b27ce365"],
Cell[76266, 1958, 4018, 95, 70, "ExerciseOutput", "ExpressionUUID" -> \
"af93bb14-84dd-48e7-ba3f-db567beb155c"]
}, Closed]],
Cell[CellGroupData[{
Cell[80321, 2058, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"e1c5e1bb-efae-4c63-96f5-b2e0975aff7c"],
Cell[80891, 2078, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a633fa5f-8b30-49b3-8b28-c4a591f9ed01",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81753, 2110, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c74f9839-e4f0-4d04-b6b1-e3edde576c0b"],
Cell[82040, 2121, 540, 12, 70, "Exercise", "ExpressionUUID" -> \
"e87e94ee-d2f0-4636-84b2-d8213eeb5c67",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[82605, 2137, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3c88c979-c0ec-45e0-bb5c-f3d1af1a54eb"],
Cell[83244, 2158, 37919, 650, 70, "ExerciseOutput", "ExpressionUUID" -> \
"518b6e9d-fd75-42bc-920e-1ee978551e22"]
}, Closed]],
Cell[CellGroupData[{
Cell[121200, 2813, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"e5ee581f-4f92-4698-b3ef-0c8411629503"],
Cell[121771, 2833, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8dfa8388-986c-4c34-82cb-46ac32bdcd75",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[122633, 2865, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4b7c5c47-d3a6-4c29-9bf0-52c25de251b0"],
Cell[122920, 2876, 585, 15, 70, "Exercise", "ExpressionUUID" -> \
"478098f4-0a0d-4e0e-81b2-e57824e0feda",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[123530, 2895, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"87d35928-c435-4ab4-a8e9-3fa46fe685db"],
Cell[124189, 2917, 120675, 2012, 70, "ExerciseOutput", "ExpressionUUID" -> \
"eb1ec50a-1078-4f39-afa1-7787ee2ab6e2"]
}, Closed]],
Cell[CellGroupData[{
Cell[244901, 4934, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"149ee13b-7bbb-4b54-86a4-754fca805b27"],
Cell[245472, 4954, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c249f4b7-f336-4001-9c72-e1040e4cd510",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[246334, 4986, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f01de197-6e08-41cd-ace2-a87918a86e75"],
Cell[246621, 4997, 544, 14, 70, "Exercise", "ExpressionUUID" -> \
"8307af23-cc2f-4e21-8b38-a75ec798bfd2",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[247190, 5015, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c9e3bb2f-2979-40ed-9f27-193d3b651b6b"],
Cell[247829, 5036, 51347, 870, 70, "ExerciseOutput", "ExpressionUUID" -> \
"63ac2e0e-a161-4ce8-8184-db0fe9c80f4f"]
}, Closed]],
Cell[CellGroupData[{
Cell[299213, 5911, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"aae75bcb-5dac-4ac9-9129-1f2ae87e8d06"],
Cell[299784, 5931, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d66cce7d-b3d2-4278-982f-598acb6a4a87",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[300646, 5963, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4a7aadd5-2e9e-4486-8933-3dce4e32cba0"],
Cell[300933, 5974, 651, 16, 70, "Exercise", "ExpressionUUID" -> \
"94881105-01e1-4776-95f3-3c45194b2780",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[301609, 5994, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a6d9490f-669a-4793-a3ee-f83ab2805e57"],
Cell[302268, 6016, 270743, 4472, 70, "ExerciseOutput", "ExpressionUUID" -> \
"f0fbd5b6-e792-4f54-b906-6a3b100b4ab5"]
}, Closed]],
Cell[CellGroupData[{
Cell[573048, 10493, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"a5209bd1-9a14-4e49-a231-a246822016a2"],
Cell[573619, 10513, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4ed2393d-6ddc-4c3b-9651-1225560d2f6d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[574481, 10545, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "3cb6b87b-f698-4ae8-82b0-bdf00eed9ca9"],
Cell[574768, 10556, 555, 13, 70, "Exercise", "ExpressionUUID" -> \
"a23cbdf6-a30c-4d43-9b94-af11ece29927",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[575348, 10573, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "f8e58acc-18ce-421b-ac91-41f0a401f479"],
Cell[576007, 10595, 119415, 1986, 70, "ExerciseOutput", "ExpressionUUID" -> \
"476d40f2-8483-41a9-8e21-af3d1b8c6ade"]
}, Closed]],
Cell[CellGroupData[{
Cell[695459, 12586, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"a986ce10-3d81-49d7-84b3-96b23c66c485"],
Cell[696030, 12606, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3c8b2790-8430-4bb8-9423-281a547b159d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[696892, 12638, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "fedcc8f4-aa9d-4ef4-99f0-e6f6eb43f60b"],
Cell[697179, 12649, 422, 9, 70, "Exercise", "ExpressionUUID" -> \
"5b7a16eb-93a1-4836-b845-b86f6872d44e",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[697626, 12662, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "6a8c584c-76b3-4e62-b590-deafb970fd40"],
Cell[698265, 12683, 7298, 148, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6cf740c5-928c-4dd6-9ac6-22285e97f299"]
}, Closed]],
Cell[CellGroupData[{
Cell[705600, 12836, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"0f779eb3-a83c-4398-9ff2-18aae3839abb"],
Cell[706171, 12856, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0f5b7817-74e7-4a0f-9a0e-12414f185144",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[707033, 12888, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "72a81384-1934-4b86-ab42-1074a8962b0d"],
Cell[707320, 12899, 418, 9, 70, "Exercise", "ExpressionUUID" -> \
"c81aae25-dfcd-4d16-bc88-62de0e02388e",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[707763, 12912, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "b6464b80-d960-48d4-b00b-2785f6d8dcdb"],
Cell[708402, 12933, 4727, 106, 70, "ExerciseOutput", "ExpressionUUID" -> \
"111bb543-cda5-4d64-ae6c-7b774e6cdc9d"]
}, Closed]],
Cell[CellGroupData[{
Cell[713166, 13044, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"435e3b8a-404b-412a-adfc-394129c53666"],
Cell[713737, 13064, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4f044208-b4ad-408c-862c-daaad14da784",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[714599, 13096, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "9d5bcbd4-cbcc-458d-a920-24491a1a43ce"],
Cell[714886, 13107, 637, 16, 70, "Exercise", "ExpressionUUID" -> \
"ae2eeb23-69ef-492e-b329-fc48edd49490",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[715548, 13127, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "d202c20b-32aa-494a-9d5c-2a5ede3f3087"],
Cell[716207, 13149, 17548, 321, 70, "ExerciseOutput", "ExpressionUUID" -> \
"cf5b38bd-07fb-4268-8f47-b2ff66b88c01"]
}, Closed]],
Cell[CellGroupData[{
Cell[733792, 13475, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"901b2637-39d8-4d62-afba-54f3a579ee25"],
Cell[734363, 13495, 813, 26, 70, "Input", "ExpressionUUID" -> \
"604455bd-8460-45af-9e77-f5ed9a9413b8",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[735225, 13527, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "d9650e76-ce22-445b-970c-c784abc1bd0c"],
Cell[735512, 13538, 487, 10, 70, "Exercise", "ExpressionUUID" -> \
"16c71384-bb94-4bf1-81d4-4c3226cb42ed",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[736024, 13552, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "172114bf-45b0-467a-852d-7564eb3bbf44"],
Cell[736683, 13574, 70555, 1185, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c526e9b4-269d-4dc2-b3e4-ea8fc5b2332c"]
}, Closed]],
Cell[CellGroupData[{
Cell[807275, 14764, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"96d47fb6-bd24-4696-879c-07a0ec0bc128"],
Cell[807846, 14784, 813, 26, 70, "Input", "ExpressionUUID" -> \
"454c9e89-d0ed-486a-b4cf-7fb3c8d6ba33",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[808708, 14816, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "724336f2-9003-4dc1-ba2e-9d91b9451cdc"],
Cell[808995, 14827, 508, 12, 70, "Exercise", "ExpressionUUID" -> \
"a69f452d-b0c2-43da-a1c2-2836e983ad85",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[809528, 14843, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "a8fb881b-f588-4126-b843-566e5eaf6cf1"],
Cell[810187, 14865, 11247, 213, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5e8be5f6-14ed-4838-a128-69d771cd1728"]
}, Closed]],
Cell[CellGroupData[{
Cell[821471, 15083, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"6dc7057d-4bb2-4e2a-ac13-17b746068456"],
Cell[822042, 15103, 813, 26, 70, "Input", "ExpressionUUID" -> \
"99995350-1c22-4099-8726-4e650658f995",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[822904, 15135, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "6ee4df99-25e6-4dd8-b996-80c83d62d585"],
Cell[823191, 15146, 556, 13, 70, "Exercise", "ExpressionUUID" -> \
"6f84e32b-efda-444b-b511-2f801c7f37ae",
 CounterAssignments->{{"SectionNumber", 17}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[823772, 15163, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "72f240b1-bece-4e51-a825-d08349c7deaa"],
Cell[824431, 15185, 61054, 1029, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ca7b3fed-b906-4626-a3a1-ac7dde9b7891"]
}, Closed]],
Cell[CellGroupData[{
Cell[885522, 16219, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"64b2c7ee-1eaa-4970-8580-4bfb698df356"],
Cell[886093, 16239, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b0d4b753-9279-4dcf-8c88-d36b23b5b999",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[886933, 16269, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "d86a6aa7-254d-47f6-8d76-0adbc9f70c0a"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 9QGtUkMZ648CAluJrlU@xeqx *)
