(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    307145,       7416]
NotebookOptionsPosition[    225703,       5679]
NotebookOutlinePosition[    286895,       6938]
CellTagsIndexPosition[    286816,       6933]
WindowTitle->Colors and Styles: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Make a list of red, yellow and green.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"d6827751-e307-41de-bbe7-38a497e78a4d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c0da975d-8928-4dbc-a13a-9a3fb60f4e24"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztliFvg0AUx182M7lkn2Bf4HTtyaklXeYwbdZrZhihS5Za3EkcDoVpVRWq
HlODOYPFTCAwJxDbu6NNttHCUTNEX+7gHbk/98vx3j3up29jdgUAixu8jCcf
1HUny6dbHDzbi9e5PXt5sN9n85k7ml7jwzvsI+zK/7rYxYZuRcwZIU4q/xvk
l5URo9Tyks9qP04DTCjGNyuA9nb0dasVtLejqo6VlKoScWgBEJ7sOXc+gI97
qUhOtxZOXPZUa+NsXayeJsJHIH6hfZkqznKQnGlAgQSl9rPIqpkHyCk0G3IW
2dYBoDoGBshZZWvMHb4RHG9AtjoCBsiJURkQhVgVwkPH2w6TU4oQIcMkRz9b
Y/Ybx2cllgSoF8tenA2VIafOnaBW9ct3mVoqUvyyF2dDdUa+6/OTm59Lav8P
WvPv/kdlmu/ISfeqOgYoC0zqUR7j8QBRWvyMz8561FQZ1COZhEsF5u8OIplE
nDFPGNT3qsyzvPd/wFkqGXPH8cKs7J56sb72DX59Xuk=
            "], {{0, 19}, {56, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{56, 19},
          PlotRange->{{0, 56}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{60, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "212ededd-8825-42c5-8164-682c130af693"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztliFvg0AUx182M7lkn2Bf4HTtyaklXeYwbdZrZhihS5Za3EkcDoVpVRWq
HlODOYPFTCAwJxDbu6NNttHCUTNEX+7gHbk/98vx3j3up29jdgUAixu8jCcf
1HUny6dbHDzbi9e5PXt5sN9n85k7ml7jwzvsI+zK/7rYxYZuRcwZIU4q/xvk
l5URo9Tyks9qP04DTCjGNyuA9nb0dasVtLejqo6VlKoScWgBEJ7sOXc+gI97
qUhOtxZOXPZUa+NsXayeJsJHIH6hfZkqznKQnGlAgQSl9rPIqpkHyCk0G3IW
2dYBoDoGBshZZWvMHb4RHG9AtjoCBsiJURkQhVgVwkPH2w6TU4oQIcMkRz9b
Y/Ybx2cllgSoF8tenA2VIafOnaBW9ct3mVoqUvyyF2dDdUa+6/OTm59Lav8P
WvPv/kdlmu/ISfeqOgYoC0zqUR7j8QBRWvyMz8561FQZ1COZhEsF5u8OIplE
nDFPGNT3qsyzvPd/wFkqGXPH8cKs7J56sb72DX59Xuk=
              "], {{0, 19}, {56, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {56, 19}, 
            PlotRange -> {{0, 56}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"10bbcb2c-54a9-4290-8292-dc316bad71dc"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.1"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7ab536ed-ed99-4a77-8c41-72711654a772"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ad2e96b5-4c1f-4e47-a947-440e42ceea39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3c3aa022-9ab0-4ee3-9241-923cdf674f14"],

Cell["Make a red, yellow, green column (\[OpenCurlyDoubleQuote]traffic light\
\[CloseCurlyDoubleQuote]).", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"ab3a1018-23a8-4e63-884f-f9284afadc29"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c93cdd11-a91a-459f-b0dc-9d7b032110c2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UNAUiLmAGMT+TzOwioEBF4LI/seGhrQsHv+OAuLBqlUMuBBE9v9/LGhIy+Lx
7yggHuDMgeCQZMCdgYewLG7/0g4AALCQfrk=
            "], {{0, 53}, {10, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{10, 53},
          PlotRange->{{0, 10}, {0, 53}}]], "ExerciseOutput",
         ImageSize->{14, 53},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7e9e5971-3c48-4a38-94ad-be4f28bbd1f2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UNAUiLmAGMT+TzOwioEBF4LI/seGhrQsHv+OAuLBqlUMuBBE9v9/LGhIy+Lx
7yggHuDMgeCQZMCdgYewLG7/0g4AALCQfrk=
              "], {{0, 53}, {10, 0}}, {0,
               255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {10, 53}, 
            PlotRange -> {{0, 10}, {0, 53}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"47457a9b-7791-4add-8511-b6b97b82fc0c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.2"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"95f6e5ab-23c3-4a3f-84ba-5b1bc8894492"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1db2762d-1964-4598-bc37-4938729e4f14"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1235b044-5f55-4766-a79f-958b02bc3988"],

Cell["Compute the negation of the color orange.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"93c64de6-6252-4a43-b36f-9ba1362bebbb"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"72c6f4bc-8075-4e1d-9635-8a59950a601b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwQBQ+gq/AiqpuE/TjSqhkg1hMKZngAAFQLtUw==
            "], {{0, 
            19}, {12, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{12, 19},
          PlotRange->{{0, 12}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{16, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4d0af0ba-c59e-4894-afca-95c436fbb3c3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwQBQ+gq/AiqpuE/TjSqhkg1hMKZngAAFQLtUw==
              "], {{0, 
              19}, {12, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {12, 19}, 
            PlotRange -> {{0, 12}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9795d021-c668-44cb-898b-05c92ad2ed76"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.3"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c534a000-76fe-48d7-82ca-dd3135ff5058"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0536a9b4-80b6-4a09-b127-a14ecb6107da"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d47a00d0-e872-44a9-8b1b-7f899b1e63f9"],

Cell["\<\
Make a list of colors with hues varying from 0 to 1 in steps of 0.02.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"04ec8c6c-6080-4ef7-8f79-79b0f79f9ef0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"41398961-b70e-45b4-80a9-fe9b1dbdb51d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT9o1GcYx5+2g8VBOmRzkLqlwyEI0sXhQJDiUEgpOByIUk86aA8Vim4G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            "], {{0, 42}, {479, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{479, 42},
          PlotRange->{{0, 479}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{483, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f3e64fc8-a849-47fd-ad9f-2aa0d4e376b5"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT9o1GcYx5+2g8VBOmRzkLqlwyEI0sXhQJDiUEgpOByIUk86aA8Vim4G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              "], {{0, 42}, {479, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {479, 42}, 
            PlotRange -> {{0, 479}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d4f21129-9950-414e-9edf-6c24bcc59829"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.4"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f0bed8ec-db13-4bca-bc9d-12a53cc4fd5d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6674af61-dadb-46b5-a225-f70654971410"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"cf03ea01-81e0-4c3e-88c6-6b9dd54d49f1"],

Cell["\<\
Make a list of colors with maximum red and blue, but with green varying from \
0 to 1 in steps of 0.05.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"4cb86c82-cfa8-4550-9abb-124c6f74a8ec"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"90b1ebb6-5a10-4d2b-b735-a41e18519eac"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmz9oU1EUxq+66CAobt10cBHe0sXBwQcuDkWodBCC0GJfcWlDK5SCQ8lk
wCVbOgWEONxOxSFTcc1glyxByBoHhwxZ3pDh+JK09fWec0+/TqKej6/ty5/f
o9OPd/JO7q9tLWfXnXM7N4tfy6u76fb26t7LO8WDlc2dtxub62+eb75b31jf
frx2o3jyXvHz/ppz02OyWCwWi8VisVgsFovFYrH8fRl16lmSVHv5n/5HLBbL
P5hxO0vTSq37c3L6uNd0zmX1I++8XvF0/pbXK1N3vV6ZWvB6ZeqB1ytTj7xe
mVr0emXqidcrU8+8Xpla8nplasXrlanXXq9MZV6vTG15vTK16/XK1L7XK1Mf
vF6Zani9MnXg9crUJ69Xpi4L0aTfaVWcS+rdOTI+aTjXKK5xplZxFKviHLpN
sSrOoQWKVXEOPaRYFefQIsWqOIeeUqyKc2iJYlWcQ68oVsU5lFGsinNoh2JV
nEP7FKviHPpIsSrOoQOKVXEOfaZYFefQF4pVcQ59pVgV59A3ilVxDn2nWBXn
0A+KVXEOjSlWxTni88Gr/dYLlzRGs+O8N3XO2JwTUOacMmXOKVPmnDKFOafX
TF3SHM+OB+3K3D/mnAuUOadMmXPKlDmnTIHXOTPPFGcaDY6rzqWzOcucc4Ey
55Qpc06ZMueUKcw5k8Ghc65+1K8Xf1xyPJuyzDkXKHNOmTLnlClzTpnCnEOU
N5Opbiajfq04qB2TOSegzDllypxTpsw5ZQpzTt5vFcJpdYfF8eCw4hz8ec6k
v5e4tNY53+WBnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMMpxDmcQpzDKcQ5nEKc
wynEOZxCnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMMpzDmzz42bc+pq963yXmU6
jTXG5+dEnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMMpxDmcQpzDKcQ5nEKcwynE
OZxCnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMOpq9+3mu3n1PF75dProjOW4Nkq
pLDZKqSw2SqksNkqpLDZKqSw2SqksNkqpLDZKqSw2SqksNkqpLDZKqSw2Sqk
sNkqpLDZKqSw2SqksNkqpLDZKqSw2SqksNkqpMD7VoVz0lNqPmelWRPZQx52
qsWb273R73MCe8gCBewhCxSwhyxQwB6yQAF7yAIF7CELFLCHLFDAHrJAAXvI
AgXsIQsUsIcsUMAeskABe8gCBewhCxSwhyxQwB6yQAF7yAIF7CELFLCHLFCX
7yHn3dbeVDKNkzMo77brWVbrA9+3moyHg+GVv5dllFFG/cdU3qlXq7XWYHz5
Wy0Wi8VisVj+3vwCRkTqPQ==
            "], {{0, 19}, {380, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{380, 19},
          PlotRange->{{0, 380}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{384, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "efd78d2c-a3dc-4e5a-a7a2-afc406f26fee"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmz9oU1EUxq+66CAobt10cBHe0sXBwQcuDkWodBCC0GJfcWlDK5SCQ8lk
wCVbOgWEONxOxSFTcc1glyxByBoHhwxZ3pDh+JK09fWec0+/TqKej6/ty5/f
o9OPd/JO7q9tLWfXnXM7N4tfy6u76fb26t7LO8WDlc2dtxub62+eb75b31jf
frx2o3jyXvHz/ppz02OyWCwWi8VisVgsFovFYrH8fRl16lmSVHv5n/5HLBbL
P5hxO0vTSq37c3L6uNd0zmX1I++8XvF0/pbXK1N3vV6ZWvB6ZeqB1ytTj7xe
mVr0emXqidcrU8+8Xpla8nplasXrlanXXq9MZV6vTG15vTK16/XK1L7XK1Mf
vF6Zani9MnXg9crUJ69Xpi4L0aTfaVWcS+rdOTI+aTjXKK5xplZxFKviHLpN
sSrOoQWKVXEOPaRYFefQIsWqOIeeUqyKc2iJYlWcQ68oVsU5lFGsinNoh2JV
nEP7FKviHPpIsSrOoQOKVXEOfaZYFefQF4pVcQ59pVgV59A3ilVxDn2nWBXn
0A+KVXEOjSlWxTni88Gr/dYLlzRGs+O8N3XO2JwTUOacMmXOKVPmnDKFOafX
TF3SHM+OB+3K3D/mnAuUOadMmXPKlDmnTIHXOTPPFGcaDY6rzqWzOcucc4Ey
55Qpc06ZMueUKcw5k8Ghc65+1K8Xf1xyPJuyzDkXKHNOmTLnlClzTpnCnEOU
N5Opbiajfq04qB2TOSegzDllypxTpsw5ZQpzTt5vFcJpdYfF8eCw4hz8ec6k
v5e4tNY53+WBnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMMpxDmcQpzDKcQ5nEKc
wynEOZxCnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMMpzDmzz42bc+pq963yXmU6
jTXG5+dEnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMMpxDmcQpzDKcQ5nEKcwynE
OZxCnMMpxDmcQpzDKcQ5nEKcwynEOZxCnMOpq9+3mu3n1PF75dProjOW4Nkq
pLDZKqSw2SqksNkqpLDZKqSw2SqksNkqpLDZKqSw2SqksNkqpLDZKqSw2Sqk
sNkqpLDZKqSw2SqksNkqpLDZKqSw2SqksNkqpMD7VoVz0lNqPmelWRPZQx52
qsWb273R73MCe8gCBewhCxSwhyxQwB6yQAF7yAIF7CELFLCHLFDAHrJAAXvI
AgXsIQsUsIcsUMAeskABe8gCBewhCxSwhyxQwB6yQAF7yAIF7CELFLCHLFCX
7yHn3dbeVDKNkzMo77brWVbrA9+3moyHg+GVv5dllFFG/cdU3qlXq7XWYHz5
Wy0Wi8VisVj+3vwCRkTqPQ==
              "], {{0, 19}, {380, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {380, 19}, 
            PlotRange -> {{0, 380}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"935a097a-9d3e-4dce-b77c-cf54200a2b92"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.5"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e2075341-0779-498e-b179-277cc19dadf5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"931625c5-b4a2-4b3e-88cd-120374d9fa4c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b8ad8011-cfba-4c82-becc-11694b5506a2"],

Cell["Blend the colors pink and yellow.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"458d499a-8e2f-478a-9683-ed6a74458a9a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0b3ca4de-fbed-43de-aec7-9cc0e14bd903"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwTBqgZt/Aii5v9+B1xoVA2RagiGMz0BAFejIwE=
            "], {{0, 
            19}, {12, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{12, 19},
          PlotRange->{{0, 12}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{16, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6564e172-64ba-4684-ae0a-0397cc01a6b6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwTBqgZt/Aii5v9+B1xoVA2RagiGMz0BAFejIwE=
              "], {{0, 
              19}, {12, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {12, 19}, 
            PlotRange -> {{0, 12}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e8f4df80-d84d-46b8-9695-578e8d0fe98e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.6"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"03afc1ee-2c09-43d2-b2e0-c59ee4729382"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"281f5638-1246-4f08-a638-aa7a64655db7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"40723c17-1358-4235-97e6-e4ce64fc5763"],

Cell["\<\
Make a list of colors obtained by blending yellow with hues from 0 to 1 in \
steps of 0.05.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"c038d638-809e-4744-a53e-61a2c8f17604"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0cecfbfe-225f-485f-a777-51e0835af20e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmz9oE2EYxj910UEQnBx1cLyli4PLjUJBqNwgxKHFXnFpQyuUgsNHJg9c
siVTQIhDOtUlU3HNYJcsQcgaB4cMt9yQ4fOS/svd+37vPZmk9n142l5Kf00h
Hz/yNm+ebu1txHeNMQf3808bm4fh/v7m0ZtH+Y1o9+DDzu72+1e7H7d3tvdf
bN3Lv/k4//h0x5j5tdNoNBqNRqPRaDQajUaj0dy8TPtJHAT1Yfav/xCNRvMf
Ju3GYVhrDP7MLm4PW8aYODnpRUYu++t6e0YuT302cnnqq5HLUu2ekctStmfk
slTcM3JZKuo9kOuhnsn1UC/leqhILk81I7k8dRjJ5al3kVyWiqNILkvZKJLL
Uu0okstSvWhdrodak+uhnsj1UJXemI36nZoxQTI4R9KzpjHNbME6663gHPfN
W8E57qe3gnNc6q3gnInzVnDOD+et4Jy281ZwjnUPfRWcY92ar4JzrHvrq+Ac
66yvgnPsL+ur4Bz73foqOMd+sb4Kzmlb66vgnB/W+io457e1vgrOcfbAV8E5
zq77KjjH2ee+Cs5BvDHqvDZBc7q4zoZz56TqnGLUOUVKnXMddU6RgrwxbIUm
aKWL63G3du4fdc5y1DlFSp1zHXVOkcKe5yw8kztnOj6tGxMu5ix1znLUOUVK
nXMddU6RgrwxGx8bY5KTUZJ/McHpdAW2fI/qnKWocwqUOmcpt9w5zmWtYK6b
2XTUyC8ap6uwxXtU5yxFnVOg1DlLueXOyUadXDidwSS/Hh/XjIH/nzMbHQUm
bPSvdnkg51AKcQ6lEOcQCnIOoSDnEApyDqEg5zAU4ByGApzDUIBzKIU4h1KI
cyiFOIc+Xohz6NlAnEPPIeIceuYR5zAU4ByGApzDUJBzFv83bp1Tq71ulQ1r
82msmV7dI+IcSiHOoRTiHEJBziEU5BxCQc4hFOQchgKcw1CAcxgKcA6lEOdQ
CnEOpRDn0McLcQ49G4hz6DlEnEPPPOIchgKcw1CAcxgKcs7y61aL/ZwEf618
/rzoknXwbFWmsNmqTGGzVYkCZ6sSBc5WJQqcrUoUOFsRCpqtCAXNVoSCZqsy
hc1WZQqbrcoUNluVHy9stiqfDWy2Kp9DbLYqn3lstiIUNFsRCpqtCAV5Y5Q7
J7ygzuesMG4he8iTfj3/4e5w6q7uEdhDZihgD5mhgD1kSiF7yJRC9pAphewh
UwrZQ+ao6j1kjqreQ+ao6j1khgL2kBkK2ENmKGAPmXm8gD1k5mwAe8jMOQT2
kJkzD+whc1T1HjJHVe8hc1SlN7JB52gumebZJZQNukkcN0bA+61m6WQ8Wfl9
WUoppdQtprJ+Uq83OuO0+kc1Go1Go9Fobm7+An14N7I=
            "], {{0, 19}, {380, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{380, 19},
          PlotRange->{{0, 380}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{384, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1334a188-b022-4236-815c-99690b53e2b7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmz9oE2EYxj910UEQnBx1cLyli4PLjUJBqNwgxKHFXnFpQyuUgsNHJg9c
siVTQIhDOtUlU3HNYJcsQcgaB4cMt9yQ4fOS/svd+37vPZmk9n142l5Kf00h
Hz/yNm+ebu1txHeNMQf3808bm4fh/v7m0ZtH+Y1o9+DDzu72+1e7H7d3tvdf
bN3Lv/k4//h0x5j5tdNoNBqNRqPRaDQajUaj0dy8TPtJHAT1Yfav/xCNRvMf
Ju3GYVhrDP7MLm4PW8aYODnpRUYu++t6e0YuT302cnnqq5HLUu2ekctStmfk
slTcM3JZKuo9kOuhnsn1UC/leqhILk81I7k8dRjJ5al3kVyWiqNILkvZKJLL
Uu0okstSvWhdrodak+uhnsj1UJXemI36nZoxQTI4R9KzpjHNbME6663gHPfN
W8E57qe3gnNc6q3gnInzVnDOD+et4Jy281ZwjnUPfRWcY92ar4JzrHvrq+Ac
66yvgnPsL+ur4Bz73foqOMd+sb4Kzmlb66vgnB/W+io457e1vgrOcfbAV8E5
zq77KjjH2ee+Cs5BvDHqvDZBc7q4zoZz56TqnGLUOUVKnXMddU6RgrwxbIUm
aKWL63G3du4fdc5y1DlFSp1zHXVOkcKe5yw8kztnOj6tGxMu5ix1znLUOUVK
nXMddU6RgrwxGx8bY5KTUZJ/McHpdAW2fI/qnKWocwqUOmcpt9w5zmWtYK6b
2XTUyC8ap6uwxXtU5yxFnVOg1DlLueXOyUadXDidwSS/Hh/XjIH/nzMbHQUm
bPSvdnkg51AKcQ6lEOcQCnIOoSDnEApyDqEg5zAU4ByGApzDUIBzKIU4h1KI
cyiFOIc+Xohz6NlAnEPPIeIceuYR5zAU4ByGApzDUJBzFv83bp1Tq71ulQ1r
82msmV7dI+IcSiHOoRTiHEJBziEU5BxCQc4hFOQchgKcw1CAcxgKcA6lEOdQ
CnEOpRDn0McLcQ49G4hz6DlEnEPPPOIchgKcw1CAcxgKcs7y61aL/ZwEf618
/rzoknXwbFWmsNmqTGGzVYkCZ6sSBc5WJQqcrUoUOFsRCpqtCAXNVoSCZqsy
hc1WZQqbrcoUNluVHy9stiqfDWy2Kp9DbLYqn3lstiIUNFsRCpqtCAV5Y5Q7
J7ygzuesMG4he8iTfj3/4e5w6q7uEdhDZihgD5mhgD1kSiF7yJRC9pAphewh
UwrZQ+ao6j1kjqreQ+ao6j1khgL2kBkK2ENmKGAPmXm8gD1k5mwAe8jMOQT2
kJkzD+whc1T1HjJHVe8hc1SlN7JB52gumebZJZQNukkcN0bA+61m6WQ8Wfl9
WUoppdQtprJ+Uq83OuO0+kc1Go1Go9Fobm7+An14N7I=
              "], {{0, 19}, {380,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {380, 19}, 
            PlotRange -> {{0, 380}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a38c854c-1b5a-4a3d-a796-5597ca4adb88"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.7"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ee1bc2cc-71c1-40b3-bd0e-ef00d9a3911f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ce0054d9-0fac-45f2-8f05-e97bf98f936d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"72df63bc-fcae-4532-9021-0cbedad198a6"],

Cell["\<\
Make a list of numbers from 0 to 1 in steps of 0.1, each with a hue equal to \
its value.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"ff6326df-b903-4507-9852-060728b3f4e4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d755340a-20ae-4778-887a-f39fda2781c2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWUFv28gZHbSXHgv0F/QP8OJLrwT20pPgLXpTDrtoGPSSarNFCh32YuQi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            "], {{0, 19}, {241, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{241, 19},
          PlotRange->{{0, 241}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{245, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "59e144f4-fd53-4dfb-a9ec-2384fe3e557c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWUFv28gZHbSXHgv0F/QP8OJLrwT20pPgLXpTDrtoGPSSarNFCh32YuQi
5BKdQgM1hARRAoRwAi2QGIUjwLB3EcWwkpjJLhGDThTbMmptIseysEwsY1+/
b0hKpDTDbAssetGHifKJ3/CJ5Dy+eTP+/ed/+9T6lRDiy9/Qx6ef/cO8cOGz
4p9+S1/+fP7Lv547f/Yvfzz/97Pnzl74w+e/poO/o39H9I9zTGMa05jGNKYx
jWlMYxrT+N+ju1SyDKPgBvJbs46qg2br557dqmPdQUvf/42Hg042Rh/1PTgH
UIIEx7L6b7gnmSA7qN+Fs6IGGWyjfg+1FbiHmSAtPHKwXMd+Rp82tly8zQSB
A9Q1VTfRMp5L63s491H/XtvB24SzjNWtjAvBThN3q1hpKkrbLp7H7QV9+lqQ
fhN7VRyoQChOOzioYW8JPwZZV4Kmh2oTzTfqqrcFp4nGQSYERQ+ui95g7GDV
Ms38XKMTHe+5Nq0TrVKtTQfsPGjNaAj+rGjuIRlrecwLLAj+fDjRn251XpYW
yhkYXeQ3IML2DGMgvi+PP4462B80IE+Qn4EI27lxkPZCXJKt+EID0sQlASts
eajJFOC+7HCrqwWBiFt+ouolqtRKOpBFCAviPH/mv54on2LuouwgW26yg4wn
NmYEZgz+PFdJ13r4RMhqoilf9q6NDYENgz+fVcarJ25UfSw46fY092PfhpiH
Mc+flQnNiaoL/GmtayBIJopMS2qNsWc/8JYqeSGMUiO6uWZZiDK/Yb0G97cl
H8omRA7Z713QYLquyf4rJuZzGJPRowb+VcJNgWu2HqXxFGJTkvAtzA3k3iVq
P6FGTN6T19FHkfJXUD61xizEGQmyDnMGueepaucqjBvyxENUiNVXoOTjpgkr
J5ncwEWBr1xFn4NSxPmvdaNnArnwmiRpx0BceZDEeSCbOvowiaiLEuQWk9Z9
n6r79/lgReqzv4Kq8uXrYVbgjHzw62Vm7PP0aA4GUQt8rpaUk0oPTwU2Jcjb
MpP2XRrkdQ4beXrD+GY84nxVCbLNXLUlk8vXIG6meBXscrUsq6srnLsa2tWr
KOSYok3F8HmVnDDKYSFwmdI8QK7N/cO5sL0kz9WNm4xdmyl9JPPDJc5bqv4P
c1jQUvoUNhE1nm+WKH+ZJu3J6Ku7yVXF7QSwiagrMQjlV9XMZ5BZDaUDLBJX
44H9hvIycSsdoYybTOlF5Q8EkrFDdlA+Nj+FlM6OYIsZWw+tzQHn5TRpyyTR
WfOeBHGZqCvRaHJ+VTPrLhcxY6ol+lSK8EEMQvnLNMgrE4/jK3mdyFPhrjFR
I5DnnDcTpPXXIRZiB9ZnJbd39bfl6Sjt2qYw7HBQ/Go+ordD01g8Ew78j1O6
aWE+7n/qaym9ZmZQ+hjWBkqxCPnfTVB6GD/B0an0NqwZlGJf6n+hovQAnR00
SK5Jw1dUAunjssD1GGTHmqD0ACvSkJCRvqSjtB+LcBiWhtJFoEDvnvI+CWSZ
aRyBnMIao7TU8FIT7jewF1HXeOlth2nciS/9Cx2lO1lsP3aYxu9jkO8mKH1c
4w5bNfRd9h67SkPu3IF4EOWDg3FKtzf5SOtUfgmQm0fRU18N15talZY0pkHp
+vWCEGZoQshsGEPuBTDJhKjm3mGsJLka4BqZEFX/TEp32WzYsWEJXkM8HZ+r
w2j7ei/9hM2GfRyD3ICYnQCRfdhLf6JZtzXZbAyJ+r7CapykC028JM73B8zb
r6in0jaERnrI9or0Icmg3zbk4rEse84pQW6xix6BXIS5mCi/R15aaOMSipc5
KSwrQJ6U2UXHzwQ3TMyqBiH027pVarfMPnloJ0mHn46BdLApXTS3CeMZBZkN
Yy3+cgJzTIcPmdLkRiprzGfKcw81l5NF6YHv0JKwVPNK9J8w6mEXUmljKCot
3bmjIJVeSPRnlVb1/7hKl2Oitmhe8RWuoLfHfM79oAGRKl2Op85WUWMtyDZu
Sy99Dgo1kSo9XPTtF2CVIlM1rBKl/2njusXJxSLuT+6thCo9/O2CfgFIYcvO
k8aRVfp8AoQ0Oa3SOaJxbLNWr6c6D4NV2hjZiaLAFZUUXzUwq/cwrNIGhjJC
btlPg9CRzTJ76a6U603lOJNKG/Hl4o1U6bSjC97AfoDCPay2UIh9tTL0lKaa
bTCbB11vjpI5KVweeWkjejqdOp/rZhqPffLSRjQ5H9WZ0rv/tfGQXtqIuVpX
WQviMym5sa9fTkkvbXwbg8ywOeulOwzPHdxmoW6oQMhLn1+Nvj0iAtsJ49HG
chmLNm6VcasQUXp58tGHXjoG4XzszpP3oKN08JK1dzV8n95ybieni1NWaSvm
iLuopnTgsfx+G40m5wuTs1/AS8griocR/5THRP0hBqH8VRKkK6vxDRzJvRHF
NOqt8YBEIF7WAhDSljj6rbyBq6Nl4FWIz5VGm3LfydPykH8w9M9WFZ0WD5oo
cNd6iXnuEym8oiHMuaXR1YT++U4VRy3cEZiX/b0S8/xA9jr0sO/inol5C7su
DnsKEOmfN1Dto/WakwLR6EeUiMNyo6OzC0Nu4tXeofmWt2/aSpAv2FRUd9C6
wUlhh144lIjndxGEi8ercDvoPJf5GVplKEB2pPyS9u5XOGGxaOM68dxBasfB
k8aDT1SAsH8Wcmu6EidtmTgx4SvSbNdlXlCCSP8sLqP1FhVpLRjkESfODteb
chuktoXOS1ZsurfBJIj0zzMWdjq4YTGl+ZnUObkbz1Eh7W8MrasKhPzzhoV+
B68tZiyPTp2TPZ/v55nA4wL6XZy08cKQux8KkINod67zBhZZi5rk1QPmuU9W
5QiFO6jvorUrq7f5MSkebMA70qsVpmh1lfMgQc5oSWiH/Uc7HjxaTrT1J0z4
8ljVit6LwM2zSSmn3pB9J9p5njdxICvr1kiueWdPjNqDphLkBM7TaNvZ3Jfq
Kt0Iy3W4H5Ju9okK5BjObLTtbN6TINKNhHLdXZZ52M7A6cjbngTpYdmM9ugu
1qREh37DTq8TXUnpnhaE/XO47SwHL3IjoVzXEpvSVijRSpCXvAYMt51rksbh
xt1QrqvlqGpclksr5TPxWITDPed7ksbb1ZRch5R+MuSNcnQ83scL3fK+BDmu
juT6gzuqEp+PAzUIvKY0zNSuhQxE9U4s10coXourN+EF6isJLUeyNXsjcqZ3
POS+dGl07qCHXjcxQQ6GG+is5/FZozgltndxmujfz7IrahD0PqCbWFwMTrS7
cFkgh+gej74OjlMgQbqqAyHJOUocpNsb38r7GVfC0+wYz8eqSWHXPFh0+/xW
j0COUvWgj27iiBpkwHPjccLuHGcuj3QgH3o4SYCcpEHoGX1InKMBCdDrJ3hF
t5d4BlTqptyI7sGOX1lMTo8obUb9QxNiWnZL61U52ksF6lZ1M5/Ix2IKMgX5
BUCCRqXIHC43R0eqJcua8zL/Vjjotf129l8TPx5TkCnILwASLJUKhbmK/zFN
n8Y0pjGNafzf4z+6ZUUk
              "], {{0, 19}, {241, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {241, 19}, 
            PlotRange -> {{0, 241}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ea0126c5-bf28-45bb-9132-c829c08e2f92"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.8"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ae6662be-fc9a-4c3d-8da2-97803477bb75"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1f5b9ce1-5499-4f59-8a37-6daa8f66dc56"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"44da4c5e-3392-4c62-9d6b-ca835c15d16d"],

Cell["Make a purple color swatch of size 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"98079aec-280b-4b2b-8195-151a7487ddd0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8fea925d-de3b-4eaf-9dc3-7181bdf32809"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt0DEKwkAQBdBFG0uv4C1sLW0ja5+QNdissBHELjdfVxAvkTf8GWamfIfh
0d02IYR510bXv06l9O/Lvh0xz/cpp/Gcn2lK5Ths2/P66+8eQ1xzaq1tLmFZ
ZwgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAEC
BAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAEC
BAgQ+AusOVXV+gHj2tXd
            "], {{0, 86}, {86, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{86, 86},
          PlotRange->{{0, 86}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{90, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a3a6be6b-04a5-47e8-8ce4-582e3f55432b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt0DEKwkAQBdBFG0uv4C1sLW0ja5+QNdissBHELjdfVxAvkTf8GWamfIfh
0d02IYR510bXv06l9O/Lvh0xz/cpp/Gcn2lK5Ths2/P66+8eQ1xzaq1tLmFZ
ZwgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAEC
BAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAEC
BAgQ+AusOVXV+gHj2tXd
              "], {{0, 86}, {86, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {86, 86}, 
            PlotRange -> {{0, 86}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"74e82e4a-a041-4b5b-9bde-f53e6319725f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.9"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d1ef7a29-174d-4617-886f-9e6dfcca723a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"fe94e10c-b150-4bc5-88e4-50cea9148896"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ecc57ffe-0a1d-4e2a-8d17-72ec02e51ff6"],

Cell["\<\
Make a list of red swatches with sizes from 10 to 100 in steps of 10.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"2b4fff76-0c6b-4527-81b3-cbcdd06c3320"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fa51adfa-68b5-427b-8969-8b51290c99c7"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnS1zG1cUhm9bUti/0D+wuFSwU+CZdMpEkqmdKXE9SWc6pmKCYkI1EomR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            "], {{0, 158}, {331, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{331, 158},
          PlotRange->{{0, 331}, {0, 158}}]], "ExerciseOutput",
         ImageSize->{335, 158},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e70ac74e-5319-4f96-8443-2f28d4345793"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnS1zG1cUhm9bUti/0D+wuFSwU+CZdMpEkqmdKXE9SWc6pmKCYkI1EomR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              "], {{0, 158}, {331, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {331, 158}, 
            PlotRange -> {{0, 331}, {0, 158}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"64255d8e-f27a-46f5-81c2-02746286a635"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.10"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"16c06483-86da-4794-aa37-b97b2daadb8d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b10c90c8-5750-483e-85ad-ef1661292174"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"67f41cd9-72cc-4160-bb08-4d05bf606527"],

Cell["Display the number 999 in red at size 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"daf2be33-b5be-41a1-a173-67742b9779b2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38a58645-f4d4-4d45-a507-80df316fd551"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnaGP40YUh6OWFPZf6D8QXGpYZOmqspA7dX0q2UZ3laqQgjDDgEpmQUFB
RkYhQSEmISEGISYGBiYGAa9Ocne7q8sbe2xv75fk9+ntau+kzH7RTsYzb97Y
P73784333WAw+PhD9e3N27+dDx/eTn79sfrHb48f/3j/+PD7L49/Pbx/+PDz
u++r//yn+vq3+jr+LIQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQ
Qggh5H+gyGQbSxTKYi7zUyyWEq1ll0hRUgnUKk9k4YszlMHAFM5IglDS/E6V
AK3SWMZujczX4Y5ls78jJUSrUoKxtc8Lt6lkh1tXgrQqE3E7+DzFUDbpzSph
WuVxHz7PIkxuUAnTKt/0rHSOqIMYoBKoVSrDBr/C9WQ2lzCUcCkzX0ZOI7FN
u4kWoBKqlV83d5qFkl9atpSZRPO6d+RIan+BBlTCtNqHpjaHY0lr15ulzI1z
sKF/9UqgVqV4htam0rw7rGcmsWXzsR1QCdUqWehNeVLYvL+K1dTUWsM3CKgE
anWQsZ7niW2dTgQjtcGwSZ4BUAnVqtDnwKNFG6Uj+tysycAOqARrtdY/wu16
1JmNPrZv65oFVIK1mirrkepC3IlM7VeT1fUpgVrpH95Z3M1KZKlNjz0xTa4B
lVCtCj1x1z4p8aVx/WJhaBxQCdaq1Kyc6jPdGX2VNNWHBUAlWCs19epar2Iu
Ek0ut2+YVgEqwVrFgdqperFSU0z6uwZUgrXaalaDPsaEalTYqu1rs2JApeuz
GvXTqapWtP3olbK/DKgEa6VekUd1E+mGVBdlJdE021yN0vVZDSTpqSJRS+u5
wdUowVoZljOrXsZ0kVBZkzqKFaASrJXk4ihWTfJI9RRqll7tVIBKsFaGTZDa
PFID5p7aadVOBagEayWy1F8YdSs+NG8oG1Y0gEqwVvul/sIOufTt3KhktAJU
grUybFgMjLNWA5taJbMVoBKslT7nOcdiayNUV0bV0ApQCdbqsKtpYRY1MtpG
6vTM1gpQCdZKDDuGzxoJ10r1aS7rpbh159psrQCVYK0aFn5X4bgymUoQHL/7
E3GNtd/Diay0bGGtFaASrFXltbLsFbVxKn3cKVdn83IGVgnWql+xqjud+4yW
qzclE7CVYK0qip3NVVWJyfKpQc2qeacCVIK1OlLNaZW9+/q+NJL4ZQpi7fdh
BagEa3UiT8S3ObVd+USXFj6BcpzKakyAVYK1OnMoZbeRwJeR0rgzktlCdlrS
r1Qzva3LIwGVYK1eKkpRSJ5Jdoq8aHAKRq8BWPeyTQaoBGtlT7sKnHtTgrVK
W9W/3ZsSrJV2ArHrsY7bUgK10neovWX9q+9FCdXKkJ9f7KiEbqUWlvdXXHcD
SrBWE2VA+IbjOaASppWhrjXoax16/UqwVuq25lD2vd+V8WqVQK32ao/qksG7
NSVUK0NFQceSyFtSwrTKDFuZNrcwum2lV7JKO/7R96ZSkLlVKR2wEqZVciok
noRtlQr1kNoxWh2FA1TCtMrWTy14c/vX56Zbfg1aJRAAlTCtyq/yNkNPksbJ
7iyuKfxwZregBGqV6ofX5pIa3dKt+PrRm0/h2p/fB1TCtMpNtxg9hzuWRSTb
5NP28X4v8fpYGFD7xJBzWG84AiqhWhn2eXuJtf0MDVAJ1kpeo2z4cxhuanF1
SrBWcnqoRMPS/aYxlLjbvdoAlWCtjmQytX+O0sVw+nouD6ASrNWJOOzWuxwJ
2+YxrkgJ1urIQTZh06d+fIlq0rV6JR9MJVirz+R7iRYy9tRudjzC5ku0uXwa
8U6UYK2eU5ZPZcNVFIUcvt0WJ6wSrBUhhBBCCCGEEEIIIYQQQgghhBBCCCGE
EEIIIcTIfylgB5c=
            "], {{0, 126}, {149, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{149, 126},
          PlotRange->{{0, 149}, {0, 126}}]], "ExerciseOutput",
         ImageSize->{153, 126},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "133299e5-9ae5-43d2-a98b-c110081a6bc9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnaGP40YUh6OWFPZf6D8QXGpYZOmqspA7dX0q2UZ3laqQgjDDgEpmQUFB
RkYhQSEmISEGISYGBiYGAa9Ocne7q8sbe2xv75fk9+ntau+kzH7RTsYzb97Y
P73784333WAw+PhD9e3N27+dDx/eTn79sfrHb48f/3j/+PD7L49/Pbx/+PDz
u++r//yn+vq3+jr+LIQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQ
Qggh5H+gyGQbSxTKYi7zUyyWEq1ll0hRUgnUKk9k4YszlMHAFM5IglDS/E6V
AK3SWMZujczX4Y5ls78jJUSrUoKxtc8Lt6lkh1tXgrQqE3E7+DzFUDbpzSph
WuVxHz7PIkxuUAnTKt/0rHSOqIMYoBKoVSrDBr/C9WQ2lzCUcCkzX0ZOI7FN
u4kWoBKqlV83d5qFkl9atpSZRPO6d+RIan+BBlTCtNqHpjaHY0lr15ulzI1z
sKF/9UqgVqV4htam0rw7rGcmsWXzsR1QCdUqWehNeVLYvL+K1dTUWsM3CKgE
anWQsZ7niW2dTgQjtcGwSZ4BUAnVqtDnwKNFG6Uj+tysycAOqARrtdY/wu16
1JmNPrZv65oFVIK1mirrkepC3IlM7VeT1fUpgVrpH95Z3M1KZKlNjz0xTa4B
lVCtCj1x1z4p8aVx/WJhaBxQCdaq1Kyc6jPdGX2VNNWHBUAlWCs19epar2Iu
Ek0ut2+YVgEqwVrFgdqperFSU0z6uwZUgrXaalaDPsaEalTYqu1rs2JApeuz
GvXTqapWtP3olbK/DKgEa6VekUd1E+mGVBdlJdE021yN0vVZDSTpqSJRS+u5
wdUowVoZljOrXsZ0kVBZkzqKFaASrJXk4ihWTfJI9RRqll7tVIBKsFaGTZDa
PFID5p7aadVOBagEayWy1F8YdSs+NG8oG1Y0gEqwVvul/sIOufTt3KhktAJU
grUybFgMjLNWA5taJbMVoBKslT7nOcdiayNUV0bV0ApQCdbqsKtpYRY1MtpG
6vTM1gpQCdZKDDuGzxoJ10r1aS7rpbh159psrQCVYK0aFn5X4bgymUoQHL/7
E3GNtd/Diay0bGGtFaASrFXltbLsFbVxKn3cKVdn83IGVgnWql+xqjud+4yW
qzclE7CVYK0qip3NVVWJyfKpQc2qeacCVIK1OlLNaZW9+/q+NJL4ZQpi7fdh
BagEa3UiT8S3ObVd+USXFj6BcpzKakyAVYK1OnMoZbeRwJeR0rgzktlCdlrS
r1Qzva3LIwGVYK1eKkpRSJ5Jdoq8aHAKRq8BWPeyTQaoBGtlT7sKnHtTgrVK
W9W/3ZsSrJV2ArHrsY7bUgK10neovWX9q+9FCdXKkJ9f7KiEbqUWlvdXXHcD
SrBWE2VA+IbjOaASppWhrjXoax16/UqwVuq25lD2vd+V8WqVQK32ao/qksG7
NSVUK0NFQceSyFtSwrTKDFuZNrcwum2lV7JKO/7R96ZSkLlVKR2wEqZVciok
noRtlQr1kNoxWh2FA1TCtMrWTy14c/vX56Zbfg1aJRAAlTCtyq/yNkNPksbJ
7iyuKfxwZregBGqV6ofX5pIa3dKt+PrRm0/h2p/fB1TCtMpNtxg9hzuWRSTb
5NP28X4v8fpYGFD7xJBzWG84AiqhWhn2eXuJtf0MDVAJ1kpeo2z4cxhuanF1
SrBWcnqoRMPS/aYxlLjbvdoAlWCtjmQytX+O0sVw+nouD6ASrNWJOOzWuxwJ
2+YxrkgJ1urIQTZh06d+fIlq0rV6JR9MJVirz+R7iRYy9tRudjzC5ku0uXwa
8U6UYK2eU5ZPZcNVFIUcvt0WJ6wSrBUhhBBCCCGEEEIIIYQQQgghhBBCCCGE
EEIIIcTIfylgB5c=
              "], {{0, 126}, {149, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {149, 126}, 
            PlotRange -> {{0, 149}, {0, 126}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5c5bde1c-737f-4fac-8156-b78996b1c322"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.11"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1d71f70e-59b6-430c-a86d-684e0d0d4722"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"711a4699-350a-43f3-922b-24f6d1dc7c53"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4039214f-e4b6-423b-ba3d-e826eb3509bb"],

Cell["\<\
Make a list of the first 10 squares, in which each value is styled at its \
size.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"56451b2e-a950-4917-b102-d8ff09ede554"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"96e6cb23-b351-4999-b94f-50912bb6e0da"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnSuzrNp2xzuJicxXyBdAxyJjQtVNXYe5t3K4FXNCnZuqFBaHxOFQKBQK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            "], {{0, 78}, {494, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{494, 78},
          PlotRange->{{0, 494}, {0, 78}}]], "ExerciseOutput",
         ImageSize->{498, 78},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0b13b918-b7ef-486f-842b-e88d82b50984"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnSuzrNp2xzuJicxXyBdAxyJjQtVNXYe5t3K4FXNCnZuqFBaHxOFQKBQK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              "], {{0, 78}, {494, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {494, 78}, 
            PlotRange -> {{0, 494}, {0, 78}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dc434674-90c9-4b03-8fcf-1e6e63c206a6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.12"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"405ae4ae-7770-42c3-a7f2-509474626c49"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"35ea188e-e7ec-4541-bd12-dd1ddcc67548"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"836db8d3-aa87-41ab-9626-384c469d1e4b"],

Cell[TextData[{
 "Use ",
 StyleBox["Part",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["RandomInteger",
  FontFamily->"Source Sans Pro"],
 " to make a length-100 list in which each element is randomly ",
 StyleBox["Red",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Yellow",
  FontFamily->"Source Sans Pro"],
 " or ",
 StyleBox["Green",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"602ff1fb-8bab-440a-b460-178188e14ed4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"01856c2f-62c1-4ae9-91ba-c6cf8b9439d4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnSFvY0cUhactKexf6B8wLjUsqrRVF5nsqvGqJI2ylapQM8MwM6MQL1oU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            "], {{0, 86}, {478, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{478, 86},
          PlotRange->{{0, 478}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{482, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7d1009dc-98c4-49d0-90f7-4e0f256b0285"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnSFvY0cUhactKexf6B8wLjUsqrRVF5nsqvGqJI2ylapQM8MwM6MQL1oU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              "], {{0, 86}, {478, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {478, 86}, 
            PlotRange -> {{0, 478}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6660a9d0-f2d8-4d50-909a-1e49119a8efd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.13"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ff21e9da-4fed-4f3e-9ab0-0a6df0d2bb96"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"81a910d9-1310-4fd0-aa78-adea00732b91"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"94946aac-f4d8-40bc-8d06-c9950379fbd3"],

Cell[TextData[{
 "Use ",
 StyleBox["Part",
  FontFamily->"Source Sans Pro"],
 " to make a list of the first 50 digits of 2^1000, in which ",
 "each digit has a size equal to 3 times its value",
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "7.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"fdfa06db-f867-48df-a2f4-8918f9d42455"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"235fa63c-f3db-4e41-bf20-66185669a360"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnS/TtLoVwLetqexX6BdA1zJVVczcTh3m3vblTs1b5r2d6WBxSNw6FAq1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            "], {{0, 67}, {355, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{355, 67},
          PlotRange->{{0, 355}, {0, 67}}]], "ExerciseOutput",
         ImageSize->{359, 67},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2f3ad1cb-dd67-4248-be92-79383f802acf"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnS/TtLoVwLetqexX6BdA1zJVVczcTh3m3vblTs1b5r2d6WBxSNw6FAq1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              "], {{0, 67}, {355, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {355, 67}, 
            PlotRange -> {{0, 355}, {0, 67}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b62f2d27-64d5-47e5-9fc8-9e80c969d4c8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["7.14"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d9f59256-9345-41f5-a1cb-e8077fefe4f6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"72c207bd-7e4c-4681-ae1a-a1b57df24de6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c72e2aec-0911-4f0f-bd35-7955f003a67f"],

Cell["\<\
Create a column of colors with hues varying from 0 to 1 in steps of 0.05.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"19e6747b-5ea2-4c96-a5b1-d26ed421bda1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b57b4573-9c3b-4d02-abf4-17e9d1f367ec"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmjFqAlEURW+SJqSKpWXcwjRpA2lS2BhcgBJH0hjQgKSyFbICt/Bat+E2
XMfLlz9V5t/PaxJ48A6HGWdOdbUS/sP8Y9JeA9jcpstktn1ar2dfr/fpYbra
vC9Xi7eX1ediuVg/zm/Sy+8r4C7dL5/1zxCAmauWdF0rewM70oCZq44Luq6V
vYEdacHMVQ8FXdfK3sCOpK+UmKueC7qulb2Bnb2AmetJC7qulb2BnamAmetO
C7qulb2BnZGAmWujBV3Xyt7ADmTA7KoOC7qufG9gB/LM7Kq2BV1XvjewA9ky
u6rHgq4r3xvYgQizq+na13XlewM72Aqzq0ct6LryvYEdPAuzq60WdF353sAO
BsLs6lALuq58b2BnBGHm2kD7uq6VvYGdKYSZ6w7a13Wt7A3s7CHMXE/Qvq5r
ZW9gR3Bg5qo493VdK3sDO+l/CDNXvfwQv3VdK3sDO4KGmati3Nd1rewN7MQ5
5P85h/wDv4XLOA==
            "], {{0, 395}, {10, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{10, 395},
          PlotRange->{{0, 10}, {0, 395}}]], "ExerciseOutput",
         ImageSize->{14, 395},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d283e3e5-3490-40b7-9ad4-5e09f7351691"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmjFqAlEURW+SJqSKpWXcwjRpA2lS2BhcgBJH0hjQgKSyFbICt/Bat+E2
XMfLlz9V5t/PaxJ48A6HGWdOdbUS/sP8Y9JeA9jcpstktn1ar2dfr/fpYbra
vC9Xi7eX1ediuVg/zm/Sy+8r4C7dL5/1zxCAmauWdF0rewM70oCZq44Luq6V
vYEdacHMVQ8FXdfK3sCOpK+UmKueC7qulb2Bnb2AmetJC7qulb2BnamAmetO
C7qulb2BnZGAmWujBV3Xyt7ADmTA7KoOC7qufG9gB/LM7Kq2BV1XvjewA9ky
u6rHgq4r3xvYgQizq+na13XlewM72Aqzq0ct6LryvYEdPAuzq60WdF353sAO
BsLs6lALuq58b2BnBGHm2kD7uq6VvYGdKYSZ6w7a13Wt7A3s7CHMXE/Qvq5r
ZW9gR3Bg5qo493VdK3sDO+l/CDNXvfwQv3VdK3sDO4KGmati3Nd1rewN7MQ5
5P85h/wDv4XLOA==
              "], {{0, 395}, {10, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {10, 395}, 
            PlotRange -> {{0, 10}, {0, 395}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6e7daaba-d61e-440a-82ad-6d30104ed336"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.1"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"94907b20-6bae-47e3-b9fe-ffb3fea78365"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9fbb4c65-c7a8-4970-9173-8637eb2b0ae0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7334704c-fbbb-4d45-aa81-b3fbf5aca6f3"],

Cell[TextData[{
 "Make a list of colors varying from red to green with green components ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"98b0888e-dd95-4d2d-b04a-b9bf46265770"],
 " varying from 0 to 1 in steps of 0.05 and with red components ",
 Cell[BoxData[
  RowBox[{"1", "-", "x"}]], "InlineCode",ExpressionUUID->
  "cbbbe675-dbd6-425a-b191-a32516905f59"],
 ". "
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"14a0d014-9e59-424e-bdf8-4622a95f2057"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6dd486ca-0e0e-4e6f-82fd-aef3ffb70a2c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmzFIW1EUhk/bxQ5CpZNudegiZMnSwcEHLoVKweIgBEGpT7rEYAoidAiZ
DLhkS6aAEAedxCGTuGbQJUsQssahQ4a3vCFD+pKYcr3n3uNvl2J7fn7Ni7wv
cfp4J+/k3dbuaviSiPJTya/Vzf1gb2/z4Mub5MlaNv9tJ7v99WP2+/bO9t6H
rVfJH98mPz9eEA2PBxqNRqPRaDQajUaj0Wg0mueXXqMUplK5Vvy3/xGNRvMP
JqqHQZApNn/275+3KkQUls5PieQ6X+74Ncl1UtUZkuukynMk10kdzpNcJ1VY
ILlOaj9Ncp1UdpHkOqlwmeQ6qY0Vkuuk1tZIrpNa2SC5Tmo5JLlOanGX5Dqp
9D7JdVILBZLrpOYPSa6Tmi2TXCc1UyW5TmrqmOQ6qUescZpQ/XajliFKlZpj
JLopE5WTa5yhVfwVnBNNeys4527OW8E5t++9FZxznfZWcM7VkreCcy5WvBWc
c7LureCcauit4JyjvLeCcwoFbwXn5I+8FZwTVr0VnLN+4q3gnE8X3grOWbry
VnBO+tpbwTnvb70VnDN7563gnOnIW8k5ojjGp7VrnylV7o2O49bQOZE652HU
OWbUOWbUOWZA57QqAaUq0ei4U8+M/aPOMaPOMaPOMaPOMYNe54w8kzin17nM
EQWjOUudY0adY0adY0adYwZ0Tr9zRkSl83YpeaDU5WjKUueYUeeYUeeYUeeY
AZ0zGMSV1FA3/V67mBwULwfqnIdR55hR55hR55gBnRO3a4lwas1uctw5yxDB
n+f02wcpCoqN37s8kHMYBTmHUZBzGAU5h1GQcxgFOYdRkHMYBTmHUZBzGAU5
h1GQcxgFOYdRkHMYBTmHUZBzGAU5h1GQcxgFOYdRkHMYBTpn9LlxZUw97b5V
3MoMp7FyNHlHyDmMgpzDKMg5jIKcwyjIOYyCnMMoyDmMgpzDKMg5jIKcwyjI
OYyCnMMoyDmMgpzDKMg5jIKcwyjIOYyCnMMoyDmM+oP7VqP9nBJ+r3x4XTRh
B/BsZVHgbGVR4GxlUeBsZVHgbGVR4GxlUeBsZVHgbGVR4GxlUeBsZVHgbGVR
4GxlUeBsZVHgbGVR4GxlUeBsZVHgbGVR4GxlUeBsZVHofavEOcE9NZ6zgrCC
7CF3G7nk5HqrN3lDaA+ZU8geMqeQPWROIXvInEL2kDmF7CFzCtlD5hSyh8wp
ZA+ZU8geMqeQPWROIXvInEL2kDmF7CFzCtlD5hSyh8wpZA+ZU8geMqeQPWRO
AXvIcbN2MJRM+WYCxc16KQyLbeD7Vv2o2+k++XtZSiml1H9MxY1SLlesdaLH
T9VoNBqNRqN5vvkF7i63sg==
            "], {{0, 19}, {380, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{380, 19},
          PlotRange->{{0, 380}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{384, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "88ae69b3-18e0-48a6-9163-6e0a82e5a171"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmzFIW1EUhk/bxQ5CpZNudegiZMnSwcEHLoVKweIgBEGpT7rEYAoidAiZ
DLhkS6aAEAedxCGTuGbQJUsQssahQ4a3vCFD+pKYcr3n3uNvl2J7fn7Ni7wv
cfp4J+/k3dbuaviSiPJTya/Vzf1gb2/z4Mub5MlaNv9tJ7v99WP2+/bO9t6H
rVfJH98mPz9eEA2PBxqNRqPRaDQajUaj0Wg0mueXXqMUplK5Vvy3/xGNRvMP
JqqHQZApNn/275+3KkQUls5PieQ6X+74Ncl1UtUZkuukynMk10kdzpNcJ1VY
ILlOaj9Ncp1UdpHkOqlwmeQ6qY0Vkuuk1tZIrpNa2SC5Tmo5JLlOanGX5Dqp
9D7JdVILBZLrpOYPSa6Tmi2TXCc1UyW5TmrqmOQ6qUescZpQ/XajliFKlZpj
JLopE5WTa5yhVfwVnBNNeys4527OW8E5t++9FZxznfZWcM7VkreCcy5WvBWc
c7LureCcauit4JyjvLeCcwoFbwXn5I+8FZwTVr0VnLN+4q3gnE8X3grOWbry
VnBO+tpbwTnvb70VnDN7563gnOnIW8k5ojjGp7VrnylV7o2O49bQOZE652HU
OWbUOWbUOWZA57QqAaUq0ei4U8+M/aPOMaPOMaPOMaPOMYNe54w8kzin17nM
EQWjOUudY0adY0adY0adYwZ0Tr9zRkSl83YpeaDU5WjKUueYUeeYUeeYUeeY
AZ0zGMSV1FA3/V67mBwULwfqnIdR55hR55hR55gBnRO3a4lwas1uctw5yxDB
n+f02wcpCoqN37s8kHMYBTmHUZBzGAU5h1GQcxgFOYdRkHMYBTmHUZBzGAU5
h1GQcxgFOYdRkHMYBTmHUZBzGAU5h1GQcxgFOYdRkHMYBTpn9LlxZUw97b5V
3MoMp7FyNHlHyDmMgpzDKMg5jIKcwyjIOYyCnMMoyDmMgpzDKMg5jIKcwyjI
OYyCnMMoyDmMgpzDKMg5jIKcwyjIOYyCnMMoyDmM+oP7VqP9nBJ+r3x4XTRh
B/BsZVHgbGVR4GxlUeBsZVHgbGVR4GxlUeBsZVHgbGVR4GxlUeBsZVHgbGVR
4GxlUeBsZVHgbGVR4GxlUeBsZVHgbGVR4GxlUeBsZVHofavEOcE9NZ6zgrCC
7CF3G7nk5HqrN3lDaA+ZU8geMqeQPWROIXvInEL2kDmF7CFzCtlD5hSyh8wp
ZA+ZU8geMqeQPWROIXvInEL2kDmF7CFzCtlD5hSyh8wpZA+ZU8geMqeQPWRO
AXvIcbN2MJRM+WYCxc16KQyLbeD7Vv2o2+k++XtZSiml1H9MxY1SLlesdaLH
T9VoNBqNRqN5vvkF7i63sg==
              "], {{0, 19}, {380, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {380, 19}, 
            PlotRange -> {{0, 380}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d1792c28-4e76-4a6c-bd8f-2cc7b584d923"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.2"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a427d839-4189-480e-83ad-7dc7db3e30c1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e09a8373-7b7d-4aff-9705-9be8f4d291c9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"54895dfb-6256-4e9b-aa1a-f9414a3fd00a"],

Cell["\<\
Create a list of colors with no red or blue, and with green varying from 0 to \
1 and back down to 0 in increments of 0.1 (the 1 should not be repeated).\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"3b075508-6b51-4b9d-a012-3a3a4768e057"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f436a41a-b40f-47e8-b26c-7ba4973c3591"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm6tv21AUxs82MrhpbGz7A0xKRi2VDEyTOpWFtFpcjaRROqmKNDAFzTAs
RUYhK6oGgsIDVmJiYpqBgYAQA4PMeVS69b0+Oflqae12Pp1W11F/9X2c88mP
m1fHpwfBYyI6e1r8Ojg69zudo+6HZ8XBYevs00mr+fFt63PzpNl5c/yk+PBF
8fPlEdGyvVCpVCqVSqVSqVQqlUqlUj08zUZh4HntOPvbHVGpVP+g5sPA9xu9
ye98cxwPiCgIr2ibnP+OnhMfbuo18eGm9ogPN7VPfLipQ+LDTQXEh5s6Jz7c
1Dfiw01dEB9u6jvxUee5sHFhc4itF5YbWB5iOY/VF1bL230jT0ZRg8gLJ2tk
ft0n6mcitqKfL6uD8RxmJhnPeVcdjOcwecV4ztfqYDyHqTLGc35UB+M5P6uD
8Zxf1cF4zqI6GM8BzoWNC5tDbL2w3MDyEMt5rL6wWpb5RhK9J68/W7WzeOk5
c/WcEqWeY1LqOSalnmNSMt+IBz55g/mqnQ4ba/9Rz7lFqeeYlHqOSannmJTM
N5KVzxSeM0vHbSJ/dZ+lnnOLUs8xKfUck1LPMSmZb+TpZdEOr5Jw+Zk3nu3A
1tNP9RyTUs+5+7jUc0zq/nnOYpENvOVhPkt6RaM33oWto5/qOSalnnP3cann
mNT985wsiYp2NJkW7fSyQSR+npMnXY/83ijbqZ82JZkTm5LMv01J1tqmJHll
U5IctilJvdiUpDZtSuIDNiXxnLrOhY0Lm0NsvbDcwPIQy3msvrBalnnO6rnx
YE3t9t4qiwuHWj8L2qGfNiWZE5uSzL9NSdbapiR5ZVOSHLYpSb3YlKQ2bUri
AzYl8Zy6zoWNC5tDbL2w3MDyEMt5rL6wWpZ5jvnearU/J5S/K19eF92w0n7a
lOzar0zJrjPLlOyatkzJrp/LlOxavUzJ7gvKlOwepEzJ7nfKlOzeqp5zYePC
5hBbLyw3sDzEch6rL6yWZb6RFJ7jb6j1fZYfDCTsdNQuGsN4tjD7uW3vooMS
7JN0UMw07m3m30Htb9//6aAEe00dFJNUwSaHHZRgD62DEuzXdVBMiV1sfMBB
CfYh13YubFzYHGLrheUGlodYzmP1hdXydt/IJlF3aTL96xsomwzDIOglgu9b
5fNpOt35e1lKKaXUf0xlo7Dd7kXpfPufqlQqlUqlUj1c/QGmDBtL
            "], {{0, 
            19}, {380, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{380, 19},
          PlotRange->{{0, 380}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{384, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b12f674f-4c59-442c-a47c-9aa08d66230c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztm6tv21AUxs82MrhpbGz7A0xKRi2VDEyTOpWFtFpcjaRROqmKNDAFzTAs
RUYhK6oGgsIDVmJiYpqBgYAQA4PMeVS69b0+Oflqae12Pp1W11F/9X2c88mP
m1fHpwfBYyI6e1r8Ojg69zudo+6HZ8XBYevs00mr+fFt63PzpNl5c/yk+PBF
8fPlEdGyvVCpVCqVSqVSqVQqlUqlUj08zUZh4HntOPvbHVGpVP+g5sPA9xu9
ye98cxwPiCgIr2ibnP+OnhMfbuo18eGm9ogPN7VPfLipQ+LDTQXEh5s6Jz7c
1Dfiw01dEB9u6jvxUee5sHFhc4itF5YbWB5iOY/VF1bL230jT0ZRg8gLJ2tk
ft0n6mcitqKfL6uD8RxmJhnPeVcdjOcwecV4ztfqYDyHqTLGc35UB+M5P6uD
8Zxf1cF4zqI6GM8BzoWNC5tDbL2w3MDyEMt5rL6wWpb5RhK9J68/W7WzeOk5
c/WcEqWeY1LqOSalnmNSMt+IBz55g/mqnQ4ba/9Rz7lFqeeYlHqOSannmJTM
N5KVzxSeM0vHbSJ/dZ+lnnOLUs8xKfUck1LPMSmZb+TpZdEOr5Jw+Zk3nu3A
1tNP9RyTUs+5+7jUc0zq/nnOYpENvOVhPkt6RaM33oWto5/qOSalnnP3cann
mNT985wsiYp2NJkW7fSyQSR+npMnXY/83ijbqZ82JZkTm5LMv01J1tqmJHll
U5IctilJvdiUpDZtSuIDNiXxnLrOhY0Lm0NsvbDcwPIQy3msvrBalnnO6rnx
YE3t9t4qiwuHWj8L2qGfNiWZE5uSzL9NSdbapiR5ZVOSHLYpSb3YlKQ2bUri
AzYl8Zy6zoWNC5tDbL2w3MDyEMt5rL6wWpZ5jvnearU/J5S/K19eF92w0n7a
lOzar0zJrjPLlOyatkzJrp/LlOxavUzJ7gvKlOwepEzJ7nfKlOzeqp5zYePC
5hBbLyw3sDzEch6rL6yWZb6RFJ7jb6j1fZYfDCTsdNQuGsN4tjD7uW3vooMS
7JN0UMw07m3m30Htb9//6aAEe00dFJNUwSaHHZRgD62DEuzXdVBMiV1sfMBB
CfYh13YubFzYHGLrheUGlodYzmP1hdXydt/IJlF3aTL96xsomwzDIOglgu9b
5fNpOt35e1lKKaXUf0xlo7Dd7kXpfPufqlQqlUqlUj1c/QGmDBtL
              "], {{0, 
              19}, {380, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {380, 19}, 
            PlotRange -> {{0, 380}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"adc4f5de-1e49-4e1b-a758-b6f6352eb959"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.3"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"36bab7a0-fcdd-4bcc-9c8d-e6fd3c844924"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8e0d1c58-0434-4c3b-b55b-2e7fabce992c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8e04598e-925e-48c1-80ea-16bcca4b3e11"],

Cell["Blend the color red and its negation.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"a47e39e2-38cf-4470-93fb-7fd4c6db6589"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b95fc73f-4a75-43cc-9c04-d09dd17e2c86"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwRBKCEAUdOAG4yqIVINwXCmJwAA4bXtpA==
            "], {{0, 19}, {
            12, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{12, 19},
          PlotRange->{{0, 12}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{16, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "79f06567-384f-4c68-9e53-92848819ae50"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwRBKCEAUdOAG4yqIVINwXCmJwAA4bXtpA==
              "], {{0, 19}, {
              12, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {12, 19}, 
            PlotRange -> {{0, 12}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5e9d7c5e-9728-43b0-986b-862c2e66bfc7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.4"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4acaae29-21dd-4863-a1f1-3197640287a0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4439efe2-ce80-4e6c-b18d-80ce6cec2a06"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3c711d28-562f-439a-b50c-d5e62f8b66b3"],

Cell["\<\
Blend a list of colors with hues from 0 to 1 in increments of 0.1.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"03c50c92-aa3c-422e-a109-99f8b7a92de5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"626108c4-cb56-4ac1-ad92-b0366c9bd085"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwQBw6pV+BFUDZDEhUbVEKmGUDjTEwAAa+4i2Q==
            "], {{0, 
            19}, {12, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{12, 19},
          PlotRange->{{0, 12}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{16, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "597514db-f912-4e59-8a16-edd9e2053bb9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwQBw6pV+BFUDZDEhUbVEKmGUDjTEwAAa+4i2Q==
              "], {{0, 
              19}, {12, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {12, 19}, 
            PlotRange -> {{0, 12}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d874b08a-8ca4-4cf3-a511-5e3cb6c31ad4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.5"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"873ff3c5-0ac9-45b2-8894-22b8c47717b8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5cd069e4-cc4a-44f4-9765-6d7f7c29f1ba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"43823080-7074-4b4f-8f20-18c0dcc3e772"],

Cell["\<\
Blend the color red with white, then blend it again with white. \
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"6096a819-6f14-4dc9-b348-65155f704f2e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"77af4242-4990-4f87-b7e0-8c3798463ef0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwTBqoYG/Aii5v/+/bjQqBoi1RAMZ3oCAHkYWHg=
            "], {{0, 
            19}, {12, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{12, 19},
          PlotRange->{{0, 12}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{16, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4c6c6eda-2f88-43ef-91ef-dcf5b9c348e0"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiHmAGMT+PwTBqoYG/Aii5v/+/bjQqBoi1RAMZ3oCAHkYWHg=
              "], {{0, 
              19}, {12, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {12, 19}, 
            PlotRange -> {{0, 12}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"07277484-4572-4ad9-82fe-d199974ee5c5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.6"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"967ea749-d60f-4c05-9689-8d5e85b6f983"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6054800e-d986-4047-baf1-668ffac1c1c1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ca07168d-27ae-4860-bccc-933e6cc3b248"],

Cell["Make a list of 100 random colors.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"bc1c5273-0d9f-41f8-94d5-be4d2503c3df"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5ed95bc9-e80f-4654-aab5-1f8c26fb0f15"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnQ1s1eUVh/9QdGY4RUMn6rQyQIIfV1Smrk602IFmfARRUVfDWqBG/Kot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            "], {{0, 86}, {478, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{478, 86},
          PlotRange->{{0, 478}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{482, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8f670927-9bbf-43f8-95c7-69b7dbc08e78"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnQ1s1eUVh/9QdGY4RUMn6rQyQIIfV1Smrk602IFmfARRUVfDWqBG/Kot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              "], {{0, 86}, {478, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {478, 86}, 
            PlotRange -> {{0, 478}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7bd28f15-eaf5-4286-891b-7bbfd28e89da"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.7"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"da33ab5f-f4f5-474f-aa2c-910d84df86ea"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"38b8acd7-eb80-44fc-87f3-07f65a560dc1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"be85c39c-2e38-4a47-b92d-bc4668787ec4"],

Cell["\<\
Make a column for each number 1 through 10, with the number rendered first in \
red then in green.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 8}, {
   "WebOnly", 1}},ExpressionUUID->"204428a1-b3dd-4ee8-ae4e-1c435f3cd6b0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"196d8b3b-8924-4fc5-92f5-9a09d48da5a8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXKHPrEgSJ3vm5P0Ll/Pos8hTJHs5N2Y3+9iceTt5e8kFi0PicCgUCoUi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            "], {{0, 35}, {192, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{192, 35},
          PlotRange->{{0, 192}, {0, 35}}]], "ExerciseOutput",
         ImageSize->{196, 35},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d4269554-e964-47d1-a631-b79d0a748579"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXKHPrEgSJ3vm5P0Ll/Pos8hTJHs5N2Y3+9iceTt5e8kFi0PicCgUCoUi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              "], {{0, 35}, {192, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {192, 35}, 
            PlotRange -> {{0, 192}, {0, 35}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"42b8735a-ddaf-464d-95e1-b3888c166512"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.8"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8e7b8509-5cf7-4f81-b552-a3a838f04c54"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e3061c55-665b-438b-a9c6-5dd9d0195a4f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c9a3b412-ea06-4f6f-a501-7d26a416a80a"],

Cell["\<\
Make columns of the numbers 1 through 10, rendered as plain, bold and italic \
in each column.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+7.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 9}, {
   "WebOnly", 1}},ExpressionUUID->"e45b371b-2289-4bdc-8218-4d79b6f10bcf"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6eb05889-567a-4ff0-b240-d47911f61a57"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXa3TpsgRfyoxkfkX8g/gUhWLjKLqUnGYu8pyFbOh7lKVwuKQOBwKhUKh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            "], {{0, 
            53}, {193, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{193, 53},
          PlotRange->{{0, 193}, {0, 53}}]], "ExerciseOutput",
         ImageSize->{197, 53},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a7a14e39-2a9f-43ab-82c4-110d0f66fd9f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXa3TpsgRfyoxkfkX8g/gUhWLjKLqUnGYu8pyFbOh7lKVwuKQOBwKhUKh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              "], {{0, 
              53}, {193, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {193, 53}, 
            PlotRange -> {{0, 193}, {0, 53}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b7c08616-d951-4dbe-9587-cea7bfdd9f11"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x7.9"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2ff047cf-d3ed-400b-867f-8c73f9438e4c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"efd49d2a-3d36-43ad-9561-8b9045d53d88"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9c6b3668-389b-45a7-94e6-3b15c75859af"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Colors and Styles: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 7  Colors and Styles", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
07-colors-and-styles.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+7.1", "7.1", "7.10", "7.11", "7.12", "7.13", "7.14", "+7.2", "7.2", 
         "+7.3", "7.3", "+7.4", "7.4", "+7.5", "7.5", "+7.6", "7.6", "+7.7", 
         "7.7", "+7.8", "7.8", "+7.9", "7.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+7.1", "7.1", "7.10", "7.11", "7.12", "7.13", "7.14", "+7.2", "7.2", 
      "+7.3", "7.3", "+7.4", "7.4", "+7.5", "7.5", "+7.6", "7.6", "+7.7", 
      "7.7", "+7.8", "7.8", "+7.9", "7.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[6195, 172, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ad2e96b5-4c1f-4e47-a947-440e42ceea39",
   CellTags->"FirstInputCell"],
  Cell[12202, 354, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1db2762d-1964-4598-bc37-4938729e4f14",
   CellTags->"FirstInputCell"],
  Cell[18074, 534, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0536a9b4-80b6-4a09-b127-a14ecb6107da",
   CellTags->"FirstInputCell"],
  Cell[29174, 801, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6674af61-dadb-46b5-a225-f70654971410",
   CellTags->"FirstInputCell"],
  Cell[37616, 1025, 813, 26, 
  70, "Input", "ExpressionUUID" -> "931625c5-b4a2-4b3e-88cd-120374d9fa4c",
   CellTags->"FirstInputCell"],
  Cell[43480, 1205, 813, 26, 
  70, "Input", "ExpressionUUID" -> "281f5638-1246-4f08-a638-aa7a64655db7",
   CellTags->"FirstInputCell"],
  Cell[51963, 1430, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ce0054d9-0fac-45f2-8f05-e97bf98f936d",
   CellTags->"FirstInputCell"],
  Cell[64775, 1726, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1f5b9ce1-5499-4f59-8a37-6daa8f66dc56",
   CellTags->"FirstInputCell"],
  Cell[70934, 1911, 813, 26, 
  70, "Input", "ExpressionUUID" -> "fe94e10c-b150-4bc5-88e4-50cea9148896",
   CellTags->"FirstInputCell"],
  Cell[81829, 2175, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b10c90c8-5750-483e-85ad-ef1661292174",
   CellTags->"FirstInputCell"],
  Cell[91294, 2414, 813, 26, 
  70, "Input", "ExpressionUUID" -> "711a4699-350a-43f3-922b-24f6d1dc7c53",
   CellTags->"FirstInputCell"],
  Cell[113182, 2859, 813, 26, 
  70, "Input", "ExpressionUUID" -> "35ea188e-e7ec-4541-bd12-dd1ddcc67548",
   CellTags->"FirstInputCell"],
  Cell[123916, 3131, 813, 26, 
  70, "Input", "ExpressionUUID" -> "81a910d9-1310-4fd0-aa78-adea00732b91",
   CellTags->"FirstInputCell"],
  Cell[139846, 3481, 813, 26, 
  70, "Input", "ExpressionUUID" -> "72c207bd-7e4c-4681-ae1a-a1b57df24de6",
   CellTags->"FirstInputCell"],
  Cell[146536, 3676, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9fbb4c65-c7a8-4970-9173-8637eb2b0ae0",
   CellTags->"FirstInputCell"],
  Cell[155236, 3906, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e09a8373-7b7d-4aff-9705-9be8f4d291c9",
   CellTags->"FirstInputCell"],
  Cell[163433, 4125, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8e0d1c58-0434-4c3b-b55b-2e7fabce992c",
   CellTags->"FirstInputCell"],
  Cell[169295, 4305, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4439efe2-ce80-4e6c-b18d-80ce6cec2a06",
   CellTags->"FirstInputCell"],
  Cell[175202, 4487, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5cd069e4-cc4a-44f4-9765-6d7f7c29f1ba",
   CellTags->"FirstInputCell"],
  Cell[181107, 4669, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6054800e-d986-4047-baf1-668ffac1c1c1",
   CellTags->"FirstInputCell"],
  Cell[197286, 5019, 813, 26, 
  70, "Input", "ExpressionUUID" -> "38b8acd7-eb80-44fc-87f3-07f65a560dc1",
   CellTags->"FirstInputCell"],
  Cell[209483, 5305, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e3061c55-665b-438b-a9c6-5dd9d0195a4f",
   CellTags->"FirstInputCell"],
  Cell[224575, 5638, 813, 26, 
  70, "Input", "ExpressionUUID" -> "efd49d2a-3d36-43ad-9561-8b9045d53d88",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 283634, 6860}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[638, 21, 420, 9, 70, "Exercise", "ExpressionUUID" -> \
"d6827751-e307-41de-bbe7-38a497e78a4d",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1083, 34, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c0da975d-8928-4dbc-a13a-9a3fb60f4e24"],
Cell[1722, 55, 3867, 92, 70, "ExerciseOutput", "ExpressionUUID" -> \
"10bbcb2c-54a9-4290-8292-dc316bad71dc"]
}, Closed]],
Cell[CellGroupData[{
Cell[5626, 152, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"7ab536ed-ed99-4a77-8c41-72711654a772"],
Cell[6195, 172, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ad2e96b5-4c1f-4e47-a947-440e42ceea39",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7045, 203, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3c3aa022-9ab0-4ee3-9241-923cdf674f14"],
Cell[7332, 214, 481, 10, 70, "Exercise", "ExpressionUUID" -> \
"ab3a1018-23a8-4e63-884f-f9284afadc29",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[7838, 228, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c93cdd11-a91a-459f-b0dc-9d7b032110c2"],
Cell[8477, 249, 3119, 80, 70, "ExerciseOutput", "ExpressionUUID" -> \
"47457a9b-7791-4add-8511-b6b97b82fc0c"]
}, Closed]],
Cell[CellGroupData[{
Cell[11633, 334, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"95f6e5ab-23c3-4a3f-84ba-5b1bc8894492"],
Cell[12202, 354, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1db2762d-1964-4598-bc37-4938729e4f14",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13064, 386, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1235b044-5f55-4766-a79f-958b02bc3988"],
Cell[13351, 397, 424, 9, 70, "Exercise", "ExpressionUUID" -> \
"93c64de6-6252-4a43-b36f-9ba1362bebbb",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[13800, 410, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"72c6f4bc-8075-4e1d-9635-8a59950a601b"],
Cell[14439, 431, 3029, 78, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9795d021-c668-44cb-898b-05c92ad2ed76"]
}, Closed]],
Cell[CellGroupData[{
Cell[17505, 514, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"c534a000-76fe-48d7-82ca-dd3135ff5058"],
Cell[18074, 534, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0536a9b4-80b6-4a09-b127-a14ecb6107da",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18936, 566, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d47a00d0-e872-44a9-8b1b-7f899b1e63f9"],
Cell[19223, 577, 460, 11, 70, "Exercise", "ExpressionUUID" -> \
"04ec8c6c-6080-4ef7-8f79-79b0f79f9ef0",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[19708, 592, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"41398961-b70e-45b4-80a9-fe9b1dbdb51d"],
Cell[20347, 613, 8221, 163, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d4f21129-9950-414e-9edf-6c24bcc59829"]
}, Closed]],
Cell[CellGroupData[{
Cell[28605, 781, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"f0bed8ec-db13-4bca-bc9d-12a53cc4fd5d"],
Cell[29174, 801, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6674af61-dadb-46b5-a225-f70654971410",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30036, 833, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"cf03ea01-81e0-4c3e-88c6-6b9dd54d49f1"],
Cell[30323, 844, 494, 12, 70, "Exercise", "ExpressionUUID" -> \
"4cb86c82-cfa8-4550-9abb-124c6f74a8ec",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[30842, 860, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"90b1ebb6-5a10-4d2b-b735-a41e18519eac"],
Cell[31481, 881, 5529, 119, 70, "ExerciseOutput", "ExpressionUUID" -> \
"935a097a-9d3e-4dce-b77c-cf54200a2b92"]
}, Closed]],
Cell[CellGroupData[{
Cell[37047, 1005, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"e2075341-0779-498e-b179-277cc19dadf5"],
Cell[37616, 1025, 813, 26, 70, "Input", "ExpressionUUID" -> \
"931625c5-b4a2-4b3e-88cd-120374d9fa4c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38478, 1057, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b8ad8011-cfba-4c82-becc-11694b5506a2"],
Cell[38765, 1068, 416, 9, 70, "Exercise", "ExpressionUUID" -> \
"458d499a-8e2f-478a-9683-ed6a74458a9a",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[39206, 1081, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0b3ca4de-fbed-43de-aec7-9cc0e14bd903"],
Cell[39845, 1102, 3029, 78, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e8f4df80-d84d-46b8-9695-578e8d0fe98e"]
}, Closed]],
Cell[CellGroupData[{
Cell[42911, 1185, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"03afc1ee-2c09-43d2-b2e0-c59ee4729382"],
Cell[43480, 1205, 813, 26, 70, "Input", "ExpressionUUID" -> \
"281f5638-1246-4f08-a638-aa7a64655db7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44342, 1237, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"40723c17-1358-4235-97e6-e4ce64fc5763"],
Cell[44629, 1248, 482, 12, 70, "Exercise", "ExpressionUUID" -> \
"c038d638-809e-4744-a53e-61a2c8f17604",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[45136, 1264, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0cecfbfe-225f-485f-a777-51e0835af20e"],
Cell[45775, 1285, 5582, 120, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a38c854c-1b5a-4a3d-a796-5597ca4adb88"]
}, Closed]],
Cell[CellGroupData[{
Cell[51394, 1410, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"ee1bc2cc-71c1-40b3-bd0e-ef00d9a3911f"],
Cell[51963, 1430, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ce0054d9-0fac-45f2-8f05-e97bf98f936d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52825, 1462, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"72df63bc-fcae-4532-9021-0cbedad198a6"],
Cell[53112, 1473, 480, 12, 70, "Exercise", "ExpressionUUID" -> \
"ff6326df-b903-4507-9852-060728b3f4e4",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[53617, 1489, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d755340a-20ae-4778-887a-f39fda2781c2"],
Cell[54256, 1510, 9913, 191, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ea0126c5-bf28-45bb-9132-c829c08e2f92"]
}, Closed]],
Cell[CellGroupData[{
Cell[64206, 1706, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"ae6662be-fc9a-4c3d-8da2-97803477bb75"],
Cell[64775, 1726, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1f5b9ce1-5499-4f59-8a37-6daa8f66dc56",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65637, 1758, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"44da4c5e-3392-4c62-9d6b-ca835c15d16d"],
Cell[65924, 1769, 422, 9, 70, "Exercise", "ExpressionUUID" -> \
"98079aec-280b-4b2b-8195-151a7487ddd0",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[66371, 1782, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8fea925d-de3b-4eaf-9dc3-7181bdf32809"],
Cell[67010, 1803, 3318, 83, 70, "ExerciseOutput", "ExpressionUUID" -> \
"74e82e4a-a041-4b5b-9bde-f53e6319725f"]
}, Closed]],
Cell[CellGroupData[{
Cell[70365, 1891, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"d1ef7a29-174d-4617-886f-9e6dfcca723a"],
Cell[70934, 1911, 813, 26, 70, "Input", "ExpressionUUID" -> \
"fe94e10c-b150-4bc5-88e4-50cea9148896",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71796, 1943, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ecc57ffe-0a1d-4e2a-8d17-72ec02e51ff6"],
Cell[72083, 1954, 462, 11, 70, "Exercise", "ExpressionUUID" -> \
"2b4fff76-0c6b-4527-81b3-cbcdd06c3320",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[72570, 1969, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"fa51adfa-68b5-427b-8969-8b51290c99c7"],
Cell[73209, 1990, 8013, 160, 70, "ExerciseOutput", "ExpressionUUID" -> \
"64255d8e-f27a-46f5-81c2-02746286a635"]
}, Closed]],
Cell[CellGroupData[{
Cell[81259, 2155, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"16c06483-86da-4794-aa37-b97b2daadb8d"],
Cell[81829, 2175, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b10c90c8-5750-483e-85ad-ef1661292174",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82691, 2207, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"67f41cd9-72cc-4160-bb08-4d05bf606527"],
Cell[82978, 2218, 427, 9, 70, "Exercise", "ExpressionUUID" -> \
"daf2be33-b5be-41a1-a173-67742b9779b2",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[83430, 2231, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"38a58645-f4d4-4d45-a507-80df316fd551"],
Cell[84069, 2252, 6618, 137, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5c5bde1c-737f-4fac-8156-b78996b1c322"]
}, Closed]],
Cell[CellGroupData[{
Cell[90724, 2394, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"1d71f70e-59b6-430c-a86d-684e0d0d4722"],
Cell[91294, 2414, 813, 26, 70, "Input", "ExpressionUUID" -> \
"711a4699-350a-43f3-922b-24f6d1dc7c53",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92156, 2446, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4039214f-e4b6-423b-ba3d-e826eb3509bb"],
Cell[92443, 2457, 474, 12, 70, "Exercise", "ExpressionUUID" -> \
"56451b2e-a950-4917-b102-d8ff09ede554",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[92942, 2473, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"96e6cb23-b351-4999-b94f-50912bb6e0da"],
Cell[93581, 2494, 18994, 340, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dc434674-90c9-4b03-8fcf-1e6e63c206a6"]
}, Closed]],
Cell[CellGroupData[{
Cell[112612, 2839, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"405ae4ae-7770-42c3-a7f2-509474626c49"],
Cell[113182, 2859, 813, 26, 70, "Input", "ExpressionUUID" -> \
"35ea188e-e7ec-4541-bd12-dd1ddcc67548",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[114044, 2891, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"836db8d3-aa87-41ab-9626-384c469d1e4b"],
Cell[114331, 2902, 821, 27, 70, "Exercise", "ExpressionUUID" -> \
"602ff1fb-8bab-440a-b460-178188e14ed4",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[115177, 2933, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"01856c2f-62c1-4ae9-91ba-c6cf8b9439d4"],
Cell[115836, 2955, 7473, 151, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6660a9d0-f2d8-4d50-909a-1e49119a8efd"]
}, Closed]],
Cell[CellGroupData[{
Cell[123346, 3111, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"ff21e9da-4fed-4f3e-9ab0-0a6df0d2bb96"],
Cell[123916, 3131, 813, 26, 70, "Input", "ExpressionUUID" -> \
"81a910d9-1310-4fd0-aa78-adea00732b91",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124778, 3163, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"94946aac-f4d8-40bc-8d06-c9950379fbd3"],
Cell[125065, 3174, 579, 16, 70, "Exercise", "ExpressionUUID" -> \
"fdfa06db-f867-48df-a2f4-8918f9d42455",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[125669, 3194, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"235fa63c-f3db-4e41-bf20-66185669a360"],
Cell[126308, 3215, 12931, 241, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b62f2d27-64d5-47e5-9fc8-9e80c969d4c8"]
}, Closed]],
Cell[CellGroupData[{
Cell[139276, 3461, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d9f59256-9345-41f5-a1cb-e8077fefe4f6"],
Cell[139846, 3481, 813, 26, 70, "Input", "ExpressionUUID" -> \
"72c207bd-7e4c-4681-ae1a-a1b57df24de6",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[140708, 3513, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c72e2aec-0911-4f0f-bd35-7955f003a67f"],
Cell[140995, 3524, 465, 11, 70, "Exercise", "ExpressionUUID" -> \
"19e6747b-5ea2-4c96-a5b1-d26ed421bda1",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[141485, 3539, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b57b4573-9c3b-4d02-abf4-17e9d1f367ec"],
Cell[142124, 3560, 3805, 91, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6e7daaba-d61e-440a-82ad-6d30104ed336"]
}, Closed]],
Cell[CellGroupData[{
Cell[145966, 3656, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"94907b20-6bae-47e3-b9fe-ffb3fea78365"],
Cell[146536, 3676, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9fbb4c65-c7a8-4970-9173-8637eb2b0ae0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[147398, 3708, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7334704c-fbbb-4d45-aa81-b3fbf5aca6f3"],
Cell[147685, 3719, 751, 18, 70, "Exercise", "ExpressionUUID" -> \
"14a0d014-9e59-424e-bdf8-4622a95f2057",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[148461, 3741, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6dd486ca-0e0e-4e6f-82fd-aef3ffb70a2c"],
Cell[149100, 3762, 5529, 119, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d1792c28-4e76-4a6c-bd8f-2cc7b584d923"]
}, Closed]],
Cell[CellGroupData[{
Cell[154666, 3886, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a427d839-4189-480e-83ad-7dc7db3e30c1"],
Cell[155236, 3906, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e09a8373-7b7d-4aff-9705-9be8f4d291c9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[156098, 3938, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"54895dfb-6256-4e9b-aa1a-f9414a3fd00a"],
Cell[156385, 3949, 545, 12, 70, "Exercise", "ExpressionUUID" -> \
"3b075508-6b51-4b9d-a012-3a3a4768e057",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[156955, 3965, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f436a41a-b40f-47e8-b26c-7ba4973c3591"],
Cell[157594, 3986, 5232, 114, 70, "ExerciseOutput", "ExpressionUUID" -> \
"adc4f5de-1e49-4e1b-a758-b6f6352eb959"]
}, Closed]],
Cell[CellGroupData[{
Cell[162863, 4105, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"36bab7a0-fcdd-4bcc-9c8d-e6fd3c844924"],
Cell[163433, 4125, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8e0d1c58-0434-4c3b-b55b-2e7fabce992c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[164295, 4157, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"8e04598e-925e-48c1-80ea-16bcca4b3e11"],
Cell[164582, 4168, 421, 9, 70, "Exercise", "ExpressionUUID" -> \
"a47e39e2-38cf-4470-93fb-7fd4c6db6589",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[165028, 4181, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b95fc73f-4a75-43cc-9c04-d09dd17e2c86"],
Cell[165667, 4202, 3021, 78, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5e9d7c5e-9728-43b0-986b-862c2e66bfc7"]
}, Closed]],
Cell[CellGroupData[{
Cell[168725, 4285, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4acaae29-21dd-4863-a1f1-3197640287a0"],
Cell[169295, 4305, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4439efe2-ce80-4e6c-b18d-80ce6cec2a06",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[170157, 4337, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3c711d28-562f-439a-b50c-d5e62f8b66b3"],
Cell[170444, 4348, 458, 11, 70, "Exercise", "ExpressionUUID" -> \
"03c50c92-aa3c-422e-a109-99f8b7a92de5",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[170927, 4363, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"626108c4-cb56-4ac1-ad92-b0366c9bd085"],
Cell[171566, 4384, 3029, 78, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d874b08a-8ca4-4cf3-a511-5e3cb6c31ad4"]
}, Closed]],
Cell[CellGroupData[{
Cell[174632, 4467, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"873ff3c5-0ac9-45b2-8894-22b8c47717b8"],
Cell[175202, 4487, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5cd069e4-cc4a-44f4-9765-6d7f7c29f1ba",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176064, 4519, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"43823080-7074-4b4f-8f20-18c0dcc3e772"],
Cell[176351, 4530, 456, 11, 70, "Exercise", "ExpressionUUID" -> \
"6096a819-6f14-4dc9-b348-65155f704f2e",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[176832, 4545, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"77af4242-4990-4f87-b7e0-8c3798463ef0"],
Cell[177471, 4566, 3029, 78, 70, "ExerciseOutput", "ExpressionUUID" -> \
"07277484-4572-4ad9-82fe-d199974ee5c5"]
}, Closed]],
Cell[CellGroupData[{
Cell[180537, 4649, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"967ea749-d60f-4c05-9689-8d5e85b6f983"],
Cell[181107, 4669, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6054800e-d986-4047-baf1-668ffac1c1c1",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[181969, 4701, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ca07168d-27ae-4860-bccc-933e6cc3b248"],
Cell[182256, 4712, 465, 10, 70, "Exercise", "ExpressionUUID" -> \
"bc1c5273-0d9f-41f8-94d5-be4d2503c3df",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[182746, 4726, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5ed95bc9-e80f-4654-aab5-1f8c26fb0f15"],
Cell[183405, 4748, 13274, 246, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7bd28f15-eaf5-4286-891b-7bbfd28e89da"]
}, Closed]],
Cell[CellGroupData[{
Cell[196716, 4999, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"da33ab5f-f4f5-474f-aa2c-910d84df86ea"],
Cell[197286, 5019, 813, 26, 70, "Input", "ExpressionUUID" -> \
"38b8acd7-eb80-44fc-87f3-07f65a560dc1",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[198148, 5051, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"be85c39c-2e38-4a47-b92d-bc4668787ec4"],
Cell[198435, 5062, 490, 12, 70, "Exercise", "ExpressionUUID" -> \
"204428a1-b3dd-4ee8-ae4e-1c435f3cd6b0",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 8}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[198950, 5078, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"196d8b3b-8924-4fc5-92f5-9a09d48da5a8"],
Cell[199589, 5099, 9287, 181, 70, "ExerciseOutput", "ExpressionUUID" -> \
"42b8735a-ddaf-464d-95e1-b3888c166512"]
}, Closed]],
Cell[CellGroupData[{
Cell[208913, 5285, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"8e7b8509-5cf7-4f81-b552-a3a838f04c54"],
Cell[209483, 5305, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e3061c55-665b-438b-a9c6-5dd9d0195a4f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210345, 5337, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c9a3b412-ea06-4f6f-a501-7d26a416a80a"],
Cell[210632, 5348, 486, 12, 70, "Exercise", "ExpressionUUID" -> \
"e45b371b-2289-4bdc-8218-4d79b6f10bcf",
 CounterAssignments->{{"SectionNumber", 7}, {"ExerciseNumber", 9}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[211143, 5364, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6eb05889-567a-4ff0-b240-d47911f61a57"],
Cell[211782, 5385, 12186, 228, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b7c08616-d951-4dbe-9587-cea7bfdd9f11"]
}, Closed]],
Cell[CellGroupData[{
Cell[224005, 5618, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2ff047cf-d3ed-400b-867f-8c73f9438e4c"],
Cell[224575, 5638, 813, 26, 70, "Input", "ExpressionUUID" -> \
"efd49d2a-3d36-43ad-9561-8b9045d53d88",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[225415, 5668, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9c6b3668-389b-45a7-94e6-3b15c75859af"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature RTG9rbBoyUCozlYi#Cvj7d85 *)
