(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    363255,       8900]
NotebookOptionsPosition[    252158,       6687]
NotebookOutlinePosition[    346421,       8614]
CellTagsIndexPosition[    345950,       8593]
WindowTitle->Making Tables: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Making Tables", "SectionInline",ExpressionUUID->
   "e1ed393b-5f9e-490b-8953-64a5bcec8a00"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 5}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:19",ExpressionUUID->"c486abdb-e970-4d23-97e7-fee023d18640"],

Cell[TextData[{
 "We\[CloseCurlyQuote]ve seen a few ways ",
 "to make lists in the Wolfram Language",
 ". You can just type them in. You can use ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 ". And you can use functions like ",
 ButtonBox["IntegerDigits",
  BaseStyle->"Link"],
 ". One of the most common and flexible ways to make lists is with the \
function ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"725a0904-39f0-4e0e-b6ee-7d591a4c904d"],

Cell[TextData[{
 "In its very simplest form, ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " makes a list with a single element repeated some specified number of times."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 4}},
 CellTags->"i:2",ExpressionUUID->"05a75da2-7a23-4873-ba0d-c2ce52419b54"],

Cell["Make a list that consists of 5 repeated 10 times:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0034a8ed-9d6b-4f22-b200-408f4a19c3e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"5", ",", "10"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"9a46dbd4-f04c-4647-94da-586ec5d7d1a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", 
   ",", "5", ",", "5"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"aa7218a7-be7b-4ebb-92ae-1ddf3ecbad99"]
}, Open  ]],

Cell[TextData[{
 "This makes a list with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"4b68fbd6-c27a-4e21-84ac-f161e0fa0c26"],
 " repeated 10 times:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  9}},ExpressionUUID->"3128d8de-e25a-4dc9-9598-0d2248323932"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"x", ",", "10"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"ced6e7f2-e9b5-4145-be68-83f102aa6ea8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", 
   ",", "x", ",", "x"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"0aaddce8-d92a-4bea-b4b8-25fccd80af10"]
}, Open  ]],

Cell["You can repeat lists too:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  9}},ExpressionUUID->"75f2b3d4-9db5-4141-a18b-3f7baaaa0065"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "10"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"2e995a71-da74-42d8-a799-e7bf5e372317"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"63e26703-8f54-4c84-93e5-9defb0530d6f"]
}, Open  ]],

Cell["\<\
Or, actually, anything; here\[CloseCurlyQuote]s a list of 3 identical pie \
charts:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  9}},ExpressionUUID->"b6a25359-35b1-439b-ac3d-d7c97845189a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PieChart", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], ",", "3"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"0b298d27-8bd2-4580-8e7b-6e6101a94e64"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$8976$9083 = False, 
      DynamicChart`click$8979$9083 = False, DynamicChart`click$8982$9083 = 
      False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{7.764302062626908, 
                   65.66382293737308}, {-41.2356979373731, \
-1.6932083126269033`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8976$9083, 
                  FEPrivate`Not[DynamicChart`click$8976$9083]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$8976$9083, {{{1., 0}, {
                 0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$8976$9083}]]}, 
           {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{GrayLevel[
            0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]},
                  
                  ImageSizeCache->{{44.47836456262691, 
                   84.02085418737309}, {-36.31694623850271, 
                   30.102102488502705`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8979$9083, 
                  FEPrivate`Not[DynamicChart`click$8979$9083]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$8979$9083, {{{1., 0}, {0, 1.}}, {0.2, 
                4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
               1}}], TrackedSymbols :> {DynamicChart`click$8979$9083}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]},
                  ImageSizeCache->{{7.764302062626908, 
                   65.6638229373731}, {-4.521635437373099, 35.0208541873731}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8982$9083, 
                  FEPrivate`Not[DynamicChart`click$8982$9083]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$8982$9083, {{{1., 0}, {
                 0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1,
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$8982$9083}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8976$9083, 
                FEPrivate`Not[DynamicChart`click$8976$9083]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$8976$9083, {{{1., 0}, {
               0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$8976$9083}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8979$9083, 
                FEPrivate`Not[DynamicChart`click$8979$9083]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$8979$9083, {{{1., 0}, {0, 1.}}, {0.2, 
              4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}],
             TrackedSymbols :> {DynamicChart`click$8979$9083}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$8982$9083, 
                FEPrivate`Not[DynamicChart`click$8982$9083]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$8982$9083, {{{1., 0}, {
               0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$8982$9083}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{91.78515625, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]], ",", 
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$9017$9084 = False, 
      DynamicChart`click$9020$9084 = False, DynamicChart`click$9023$9084 = 
      False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{7.829145812626902, 
                   66.11772918737309}, {-41.1708541873731, \
-1.3689895626269033`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9017$9084, 
                  FEPrivate`Not[DynamicChart`click$9017$9084]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$9017$9084, {{{1., 0}, {
                 0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$9017$9084}]]}, 
           {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{GrayLevel[
            0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]},
                  
                  ImageSizeCache->{{44.80258331262691, 
                   84.6044479373731}, {-36.217352827609304`, 
                   30.6509465776093}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9020$9084, 
                  FEPrivate`Not[DynamicChart`click$9020$9084]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$9020$9084, {{{1., 0}, {0, 1.}}, {0.2, 
                4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
               1}}], TrackedSymbols :> {DynamicChart`click$9020$9084}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]},
                  
                  ImageSizeCache->{{7.829145812626902, 
                   66.1177291873731}, {-4.197416687373099, 35.6044479373731}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9023$9084, 
                  FEPrivate`Not[DynamicChart`click$9023$9084]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$9023$9084, {{{1., 0}, {
                 0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1,
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$9023$9084}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9017$9084, 
                FEPrivate`Not[DynamicChart`click$9017$9084]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$9017$9084, {{{1., 0}, {
               0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$9017$9084}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9020$9084, 
                FEPrivate`Not[DynamicChart`click$9020$9084]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$9020$9084, {{{1., 0}, {0, 1.}}, {0.2, 
              4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}],
             TrackedSymbols :> {DynamicChart`click$9020$9084}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9023$9084, 
                FEPrivate`Not[DynamicChart`click$9023$9084]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$9023$9084, {{{1., 0}, {
               0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$9023$9084}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{92.43359375, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]], ",", 
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$9058$9085 = False, 
      DynamicChart`click$9061$9085 = False, DynamicChart`click$9064$9085 = 
      False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{7.785005187626905, 
                   65.80874481237309}, {-41.2149948123731, \
-1.5896926876269033`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9058$9085, 
                  FEPrivate`Not[DynamicChart`click$9058$9085]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$9058$9085, {{{1., 0}, {
                 0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$9058$9085}]]}, 
           {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{GrayLevel[
            0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]},
                  
                  ImageSizeCache->{{44.58188018762691, 
                   84.2071823123731}, {-36.285148342253606`, 
                   30.277335842253603`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9061$9085, 
                  FEPrivate`Not[DynamicChart`click$9061$9085]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$9061$9085, {{{1., 0}, {0, 1.}}, {0.2, 
                4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
               1}}], TrackedSymbols :> {DynamicChart`click$9061$9085}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]},
                  
                  ImageSizeCache->{{7.785005187626905, 
                   65.8087448123731}, {-4.418119812373099, 35.2071823123731}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9064$9085, 
                  FEPrivate`Not[DynamicChart`click$9064$9085]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$9064$9085, {{{1., 0}, {
                 0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1,
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$9064$9085}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9058$9085, 
                FEPrivate`Not[DynamicChart`click$9058$9085]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$9058$9085, {{{1., 0}, {
               0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$9058$9085}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9061$9085, 
                FEPrivate`Not[DynamicChart`click$9061$9085]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$9061$9085, {{{1., 0}, {0, 1.}}, {0.2, 
              4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}],
             TrackedSymbols :> {DynamicChart`click$9061$9085}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$9064$9085, 
                FEPrivate`Not[DynamicChart`click$9064$9085]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$9064$9085, {{{1., 0}, {
               0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$9064$9085}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{91.9921875, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"06a8b72a-963e-44f8-a181-ac4ad886f1e7"]
}, Open  ]],

Cell[TextData[{
 "But what if we want to make a table where the elements aren\
\[CloseCurlyQuote]t identical? We can do that by ",
 "introducing a ",
 StyleBox["variable",
  FontSlant->"Italic"],
 ", and then ",
 StyleBox["iterating",
  FontSlant->"Italic"],
 " over that variable",
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 4}},
 CellTags->"i:3",ExpressionUUID->"da78e52b-11a0-4a3f-be35-3e0bdc5dfc07"],

Cell[TextData[{
 "Iterate over ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"5fe7c4cf-58ab-4282-a878-aafc32a9b870"],
 " to make a list where ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"ddf2628c-660d-4fcd-ad51-24ed6007eaab"],
 " goes up to 5:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  9}},ExpressionUUID->"1d93b6fb-82c6-4264-a833-f27531c11986"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"a", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"813ea3f7-4130-4034-baa7-2aa0fa3df391"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], ",", 
   RowBox[{"a", "[", "2", "]"}], ",", 
   RowBox[{"a", "[", "3", "]"}], ",", 
   RowBox[{"a", "[", "4", "]"}], ",", 
   RowBox[{"a", "[", "5", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"5b123954-2109-4c26-9ff8-58faefb1b5a8"]
}, Open  ]],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s how this works. To make the first element of the \
list, ",
 Cell[BoxData[
 "n"], "InlineCodeText",ExpressionUUID->
  "387eb179-f41f-4a15-aa43-74cbf18d609b"],
 " is taken to be 1, so ",
 Cell[BoxData[
  RowBox[{"a", "[", "n", "]"}]], "InlineCodeText",ExpressionUUID->
  "d2617912-3204-4fd3-a895-70df776ed3f4"],
 " is ",
 Cell[BoxData[
  RowBox[{"a", "[", "1", "]"}]], "InlineCodeText",ExpressionUUID->
  "55ba006a-67e2-4061-92a6-7de17f8cf1b0"],
 ". To make the second element, ",
 Cell[BoxData[
 "n"], "InlineCodeText",ExpressionUUID->
  "ddf841db-ef2d-4864-913e-7838a20e1cef"],
 " is taken to be 2, so ",
 Cell[BoxData[
  RowBox[{"a", "[", "n", "]"}]], "InlineCodeText",ExpressionUUID->
  "d5a336ab-3a6d-4d90-ab09-48ce902873d8"],
 " is ",
 Cell[BoxData[
  RowBox[{"a", "[", "2", "]"}]], "InlineCodeText",ExpressionUUID->
  "920d886d-99a2-4829-addd-999efc290ac0"],
 ", and so on. ",
 Cell[BoxData[
 "n"], "InlineCodeText",ExpressionUUID->
  "ccba69c7-982e-4161-a379-02f8860f4a91"],
 " is called a variable because it\[CloseCurlyQuote]s varying as we make the \
different elements of the list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 
  4}},ExpressionUUID->"2747f229-c6bb-4d3f-92c4-b92c66314232"],

Cell[TextData[{
 "Make a table that gives the value of ",
 Cell[BoxData[
  RowBox[{"n", "+", "1"}]], "InlineCode",ExpressionUUID->
  "21051ace-6ad5-4242-89c0-cf92ac36f720"],
 " when ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"f14fcf48-ecbf-4a03-aa5c-20436c836043"],
 " goes from 1 to 10:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  9}},ExpressionUUID->"8d5f0dcd-626d-47ac-b116-538ce06d851a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"n", "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"6fabf7cc-65e9-4ac7-8811-4234ca389ef7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", 
   ",", "10", ",", "11"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[6]=",ExpressionUUID->"7b220f52-2184-43f4-9061-8c0c57f7b9b6"]
}, Open  ]],

Cell["Make a table of the first 10 squares:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:20", "i:4"},ExpressionUUID->"f2b9db75-473c-400d-97fb-97fbd98e9426"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"n", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"1bef520e-2a11-4067-b3d8-f307558c852d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"028e4628-64b1-4d8e-835d-1a04e41f1e57"]
}, Open  ]],

Cell[TextData[{
 "With ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 ", you can make tables of anything. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a085ef90-6c3d-4229-9ea1-60057cbe310a"],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s a table of ",
 "successively longer lists",
 " produced by ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1a05fa38-89b5-428c-93b3-ea5388ae9cb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Range", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"7ca8c22d-e571-4c34-95df-52b76958e31f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"5eab1e9d-e9ca-4ea5-9b47-9310b6939ff4"]
}, Open  ]],

Cell["Here each of the lists produced is shown as a column:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8b8361c4-512f-489a-979f-fa9cdf0f6d71"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"Range", "[", "n", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "8"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"8f6c3e6f-ed01-4169-95d4-64115719dea7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"1"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"2"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"2"},
      {"3"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"2"},
      {"3"},
      {"4"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"2"},
      {"3"},
      {"4"},
      {"5"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"2"},
      {"3"},
      {"4"},
      {"5"},
      {"6"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"2"},
      {"3"},
      {"4"},
      {"5"},
      {"6"},
      {"7"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"], ",", 
   TagBox[GridBox[{
      {"1"},
      {"2"},
      {"3"},
      {"4"},
      {"5"},
      {"6"},
      {"7"},
      {"8"}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"16cf8005-5173-4418-985b-7e8d9440a237"]
}, Open  ]],

Cell["\<\
Here\[CloseCurlyQuote]s a table of plots of successively longer lists of \
values:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"11216638-4f51-4361-beb1-347b7caa3ba8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"10", "*", "n"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "3"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"20155e04-a930-4554-880e-86b40c296189"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {{}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       PointBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 6.}, {
        7., 7.}, {8., 8.}, {9., 9.}, {10., 10.}}]}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{164.828125, Automatic},
    Method->{},
    PlotRange->{{0., 10.}, {0, 10.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7FFpBgdUmgONFkCjRdBoCTRaBo1WQKOV0GgV
NFoNjdZAo7XQaB00Wg+NNkCjDdFoIzTaGI02gdMA/GISxA==
        "]]}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{165.265625, Automatic},
    Method->{},
    PlotRange->{{0., 20.}, {0, 20.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, 
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.012833333333333334`], AbsoluteThickness[1.6], 
       PointBox[CompressedData["
1:eJxdxUkKQAAYQOE/K0sLCwsJSZJknqczOIKydnVHQEp5r16fsx3rroiIdf/4
ds5/ZfmrQg3q0IAmtKELPejDAIYwgjFMYAozmMMClrCCNWxgCzvYwwGOcPq8
AJ/nHEw=
        "]]}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{164.953125, Automatic},
    Method->{},
    PlotRange->{{0., 30.}, {0, 30.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"1b7341de-4c06-464e-9663-16b500388a17"]
}, Open  ]],

Cell["Here are pie charts with successively more segments:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"60180499-b0b2-41c0-bc0d-f388aa21403a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PieChart", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"1", ",", "n"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"d667ce4d-d3ad-4009-bfa0-8425efa6037c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$38455$38644 = False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.5]}], {{{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
           Opacity[0.5]}], GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  DiskBox[{0, 0}, 1., {-3.141592653589793, 
                   3.141592653589793}]},
                 
                 ImageSizeCache->{{9.03398437500001, 
                  91.30585937499998}, {-43.96601562499999, 
                  38.30585937499999}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
             
             EventHandlerTag[{
              "MouseClicked" :> 
               FEPrivate`Set[DynamicChart`click$38455$38644, 
                 FEPrivate`Not[DynamicChart`click$38455$38644]], 
               PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
               True}]], Dynamic[
            If[DynamicChart`click$38455$38644, {{{1., 0}, {0, 1.}}, {
               0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {
              DynamicChart`click$38455$38644}]]}}, {}}, {}}, {{
         GeometricTransformationBox[
          TagBox[
           TagBox[
            TooltipBox[
             TagBox[{{}, {}},
              StatusArea[#, 1]& ,
              TagBoxNote->"1"],
             StyleBox["1", {
               GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
            Annotation[#, 
             Style[1, {
               GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
           
           EventHandlerTag[{
            "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38455$38644, 
               FEPrivate`Not[DynamicChart`click$38455$38644]], PassEventsDown -> 
             True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
          If[DynamicChart`click$38455$38644, {{{1., 0}, {0, 1.}}, {
             0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
           TrackedSymbols :> {DynamicChart`click$38455$38644}]], {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{100.33984375, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]], ",", 
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$38486$38645 = False, 
      DynamicChart`click$38489$38645 = False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   DiskBox[{0, 0}, 1., {0., 3.141592653589793}]},
                  
                  ImageSizeCache->{{8.615864562626907, 
                   91.68491668737309}, {-44.384135437373104`, \
-1.4353958126269113`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38486$38645, 
                  FEPrivate`Not[DynamicChart`click$38486$38645]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38486$38645, {{{1., 0}, {0, 1.}}, {
                1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 0}, {
               0, 1}}], TrackedSymbols :> {DynamicChart`click$38486$38645}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   DiskBox[{0, 0}, 1., {-3.141592653589793, 0.}]},
                  
                  ImageSizeCache->{{8.615864562626907, 
                   91.68491668737309}, {-4.2638229373731065`, 
                   38.68491668737309}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38489$38645, 
                  FEPrivate`Not[DynamicChart`click$38489$38645]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[
              DynamicChart`click$38489$38645, {{{1., 0}, {0, 1.}}, {
                1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 0}, {
               0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$38489$38645}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38486$38645, 
                FEPrivate`Not[DynamicChart`click$38486$38645]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38486$38645, {{{1., 0}, {0, 1.}}, {
              1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
             1}}], TrackedSymbols :> {DynamicChart`click$38486$38645}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38489$38645, 
                FEPrivate`Not[DynamicChart`click$38489$38645]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38489$38645, {{{1., 0}, {0, 1.}}, {
              1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
              1}}], TrackedSymbols :> {
             DynamicChart`click$38489$38645}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{100.30078125, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]], ",", 
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$38522$38646 = False, 
      DynamicChart`click$38525$38646 = False, DynamicChart`click$38528$38646 =
       False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{8.572895812626907, 
                   71.32397918737308}, {-44.427104187373104`, \
-1.6502395626269113`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38522$38646, 
                  FEPrivate`Not[DynamicChart`click$38522$38646]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38522$38646, {{{1., 0}, {
                 0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$38522$38646}]]}, 
           {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{GrayLevel[
            0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]},
                  
                  ImageSizeCache->{{48.52133331262691, 
                   91.29819793737309}, {-39.07502840386802, 
                   32.94612215386799}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38525$38646, 
                  FEPrivate`Not[DynamicChart`click$38525$38646]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38525$38646, {{{1., 0}, {0, 1.}}, {0.2, 
                4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
               1}}], TrackedSymbols :> {DynamicChart`click$38525$38646}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]},
                  
                  ImageSizeCache->{{8.572895812626907, 
                   71.3239791873731}, {-4.4786666873731065`, 
                   38.29819793737309}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38528$38646, 
                  FEPrivate`Not[DynamicChart`click$38528$38646]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38528$38646, {{{1., 0}, {
                 0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1,
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$38528$38646}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38522$38646, 
                FEPrivate`Not[DynamicChart`click$38522$38646]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38522$38646, {{{1., 0}, {
               0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38522$38646}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38525$38646, 
                FEPrivate`Not[DynamicChart`click$38525$38646]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38525$38646, {{{1., 0}, {0, 1.}}, {0.2, 
              4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}],
             TrackedSymbols :> {DynamicChart`click$38525$38646}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38528$38646, 
                FEPrivate`Not[DynamicChart`click$38528$38646]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38528$38646, {{{1., 0}, {
               0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38528$38646}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{99.87109375, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]], ",", 
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$38563$38647 = False, 
      DynamicChart`click$38566$38647 = False, DynamicChart`click$38569$38647 =
       False, DynamicChart`click$38572$38647 = False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {1.5707963267948966`, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{8.55219268762691, 
                   51.24624481237309}, {-44.4478073123731, \
-1.7537551876269113`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38563$38647, 
                  FEPrivate`Not[DynamicChart`click$38563$38647]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38563$38647, {{{1., 0}, {
                 0, 1.}}, {-0.1414213562373095, 0.14142135623730953`}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$38563$38647}]]}, 
           {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   DiskBox[{0, 0}, 1., {0., 1.5707963267948966`}]},
                  
                  ImageSizeCache->{{48.41781768762691, 
                   91.1118698123731}, {-44.4478073123731, \
-1.7537551876269104`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38566$38647, 
                  FEPrivate`Not[DynamicChart`click$38566$38647]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38566$38647, {{{1., 0}, {0, 1.}}, {
                0.14142135623730953`, 0.1414213562373095}}, {{1, 0}, {0, 
               1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$38566$38647}]]}, 
           {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
            EdgeForm[{GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   DiskBox[{0, 0}, 1., {-1.5707963267948966`, 0.}]},
                  
                  ImageSizeCache->{{48.41781768762691, 
                   91.1118698123731}, {-4.5821823123731065`, 
                   38.11186981237309}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38569$38647, 
                  FEPrivate`Not[DynamicChart`click$38569$38647]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38569$38647, {{{1., 0}, {0, 1.}}, {
                0.14142135623730953`, -0.1414213562373095}}, {{1, 0}, {0, 
               1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$38569$38647}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.5707963267948966`}]},
                  ImageSizeCache->{{8.55219268762691, 
                   51.24624481237309}, {-4.5821823123731065`, 
                   38.11186981237309}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38572$38647, 
                  FEPrivate`Not[DynamicChart`click$38572$38647]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38572$38647, {{{1., 0}, {
                 0, 1.}}, {-0.1414213562373095, -0.14142135623730953`}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$38572$38647}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38563$38647, 
                FEPrivate`Not[DynamicChart`click$38563$38647]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38563$38647, {{{1., 0}, {
               0, 1.}}, {-0.1414213562373095, 0.14142135623730953`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38563$38647}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38566$38647, 
                FEPrivate`Not[DynamicChart`click$38566$38647]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38566$38647, {{{1., 0}, {0, 1.}}, {
              0.14142135623730953`, 0.1414213562373095}}, {{1, 0}, {0, 1}}, {{
             1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38566$38647}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38569$38647, 
                FEPrivate`Not[DynamicChart`click$38569$38647]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38569$38647, {{{1., 0}, {0, 1.}}, {
              0.14142135623730953`, -0.1414213562373095}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38569$38647}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38572$38647, 
                FEPrivate`Not[DynamicChart`click$38572$38647]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38572$38647, {{{1., 0}, {
               0, 1.}}, {-0.1414213562373095, -0.14142135623730953`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38572$38647}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{99.6640625, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]], ",", 
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$38609$38648 = False, 
      DynamicChart`click$38612$38648 = False, DynamicChart`click$38615$38648 =
       False, DynamicChart`click$38618$38648 = False, 
      DynamicChart`click$38621$38648 = False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {1.8849555921538759`, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{8.640083312626903, 
                   
                   51.68569793737309}, {-43.39154742631209, \
-2.314302062626897}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38609$38648, 
                  FEPrivate`Not[DynamicChart`click$38609$38648]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38609$38648, {{{1., 0}, {
                 0, 1.}}, {-0.16180339887498948`, 0.11755705045849466`}}, {{1,
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$38609$38648}]]}, 
           {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
            GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {0.6283185307179586, 
                    1.8849555921538759`}]},
                  
                  ImageSizeCache->{{36.4294764091632, 
                   84.22208609083683}, {-45.35991668737309, \
-2.314302062626896}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38612$38648, 
                  FEPrivate`Not[DynamicChart`click$38612$38648]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38612$38648, {{{1., 0}, {0, 1.}}, {
                0.06180339887498949, 0.1902113032590307}}, {{1, 0}, {0, 
               1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$38612$38648}]]}, 
           {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{GrayLevel[
            0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {-0.6283185307179591, 
                    0.6283185307179586}]},
                  
                  ImageSizeCache->{{48.85727081262691, 
                   91.9028854373731}, {-28.781798888554288`, 
                   21.324767638554317`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38615$38648, 
                  FEPrivate`Not[DynamicChart`click$38615$38648]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38615$38648, {{{1., 0}, {0, 1.}}, {
                0.2, -4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {
               0, 1}}], TrackedSymbols :> {DynamicChart`click$38615$38648}]]}, 
           {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-1.8849555921538759`, -0.6283185307179591}]},
                  
                  ImageSizeCache->{{36.4294764091632, 
                   84.2220860908368}, {-5.142729187373092, 
                   37.90288543737311}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38618$38648, 
                  FEPrivate`Not[DynamicChart`click$38618$38648]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38618$38648, {{{1., 0}, {0, 1.}}, {
                0.06180339887498946, -0.19021130325903074`}}, {{1, 0}, {0, 
               1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$38618$38648}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.8849555921538759`}]},
                  ImageSizeCache->{{8.640083312626903, 
                   51.68569793737309}, {-5.142729187373099, 
                   35.9345161763121}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38621$38648, 
                  FEPrivate`Not[DynamicChart`click$38621$38648]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$38621$38648, {{{1., 0}, {
                 0, 1.}}, {-0.16180339887498948`, -0.11755705045849466`}}, {{
               1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$38621$38648}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38609$38648, 
                FEPrivate`Not[DynamicChart`click$38609$38648]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38609$38648, {{{1., 0}, {
               0, 1.}}, {-0.16180339887498948`, 0.11755705045849466`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38609$38648}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38612$38648, 
                FEPrivate`Not[DynamicChart`click$38612$38648]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38612$38648, {{{1., 0}, {0, 1.}}, {
              0.06180339887498949, 0.1902113032590307}}, {{1, 0}, {0, 1}}, {{
             1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38612$38648}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38615$38648, 
                FEPrivate`Not[DynamicChart`click$38615$38648]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38615$38648, {{{1., 0}, {0, 1.}}, {
              0.2, -4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
              1}}], TrackedSymbols :> {DynamicChart`click$38615$38648}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38618$38648, 
                FEPrivate`Not[DynamicChart`click$38618$38648]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38618$38648, {{{1., 0}, {0, 1.}}, {
              0.06180339887498946, -0.19021130325903074`}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38618$38648}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$38621$38648, 
                FEPrivate`Not[DynamicChart`click$38621$38648]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$38621$38648, {{{1., 0}, {
               0, 1.}}, {-0.16180339887498948`, -0.11755705045849466`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$38621$38648}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{100.54296875, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"3e9dfa44-12be-4bc4-94d7-0699ad813350"]
}, Open  ]],

Cell[TextData[{
 "So far we\[CloseCurlyQuote]ve always used ",
 Cell[BoxData[
 "n"], "InlineCodeText",ExpressionUUID->
  "23657575-6685-4e9e-a57d-cdb1302426c0"],
 " as our variable. That\[CloseCurlyQuote]s a pretty common choice. But we \
can actually use any (lowercase) letter we want, or any combination of \
letters. All that matters is that wherever the variable appears, its name is \
the same. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:5"},ExpressionUUID->"63455b18-5b90-4d9a-975c-09ef7c84ab8f"],

Cell[TextData[{
 Cell[BoxData[
 "expt"], "InlineCode",ExpressionUUID->"4dfcef32-87a3-41ee-b4bf-7762e710c728"],
 " is a perfectly good variable name:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:21",ExpressionUUID->"b045f9e8-cdb3-4eab-8302-3eadc41998c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"2", "^", "expt"}], ",", 
   RowBox[{"{", 
    RowBox[{"expt", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"05d13b71-bedc-475e-a5e4-0852d9a7ebaf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64", ",", "128", ",", 
   "256", ",", "512", ",", "1024"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"5521b93a-6750-499f-85d9-063f9f955044"]
}, Open  ]],

Cell[TextData[{
 "Here we\[CloseCurlyQuote]re using ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"cbad8446-38ef-4261-8298-bbb8a51e5937"],
 " as the variable name, and it happens to appear several times:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"08a07124-e71c-4a1f-8615-929c348ecb52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "+", "1"}], ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "5"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"f06e5afc-c240-4a2f-b4d2-8c2dd01c5c40"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "25"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"6838c137-54b8-4ba7-a5dc-ad52bdca2e17"]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "InlineCodeText",
  ExpressionUUID->"095e7701-5890-461b-b825-c73e46009cb2"],
 ", ",
 Cell[BoxData[
 "n"], "InlineCodeText",ExpressionUUID->
  "9de46222-1fae-4ee2-955e-5f613f66502f"],
 " takes on values 1, 2, 3, 4, 5. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "3", ",", "5"}], "}"}]}], "]"}]], "InlineCodeText",
  ExpressionUUID->"95660b3e-dc72-4711-97f0-202c2d06f770"],
 " says to start at 3 instead: 3, 4, 5."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7fcad456-90bd-4aa2-88b6-c49c60f7ee89"],

Cell[TextData[{
 "This generates a table with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"830c13eb-61b8-4dc7-a39a-6485697f3a4b"],
 " going from 1 to 10:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"42fc99f2-37db-4712-9c05-9228eb576347"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"7269355d-8af3-406b-be3a-6cf42cc309b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}], ",", 
   RowBox[{"f", "[", "5", "]"}], ",", 
   RowBox[{"f", "[", "6", "]"}], ",", 
   RowBox[{"f", "[", "7", "]"}], ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "9", "]"}], ",", 
   RowBox[{"f", "[", "10", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"12c35adb-0ecf-406e-9b39-22100590f421"]
}, Open  ]],

Cell[TextData[{
 "This generates a table with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"d8f4ff5c-bfc7-49c9-82f3-b31a7c459110"],
 " going from 4 to 10:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f5dc01bc-8f0a-4c74-89f5-777ada9d01c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"09d663ce-f084-4cc4-9d64-0c914e9979d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "4", "]"}], ",", 
   RowBox[{"f", "[", "5", "]"}], ",", 
   RowBox[{"f", "[", "6", "]"}], ",", 
   RowBox[{"f", "[", "7", "]"}], ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "9", "]"}], ",", 
   RowBox[{"f", "[", "10", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"03509aef-fade-4075-889c-a86e780e46b7"]
}, Open  ]],

Cell[TextData[{
 "This makes ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"01aad4f2-3532-47b2-a254-c5f2a0519bde"],
 " go from 4 to 10 in steps of 2:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"634183a0-48a3-42a9-8465-8c055f124484"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4", ",", "10", ",", "2"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"7e63a211-e477-4889-ae96-66b46e0d1db4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "4", "]"}], ",", 
   RowBox[{"f", "[", "6", "]"}], ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "10", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"7cba10b8-3077-4561-9df7-02f4f624c2fd"]
}, Open  ]],

Cell[TextData[{
 "The Wolfram Language emphasizes consistency, so for example ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " is set up to deal with ",
 "starting points",
 " and steps just like ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"89239e2d-196c-451f-b6b6-c7ed94bec7a5"],

Cell["Generate the range of numbers 4 to 10:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e0c72652-8759-484f-8998-c0493f230826"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"4", ",", "10"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"9d62cda8-8513-4344-a643-e93802b4e5d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", "10"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"2a0c5508-297f-44be-b75e-5f4d8ecde1c3"]
}, Open  ]],

Cell["Generate the range of numbers 4 to 10 going in steps of 2:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fb2490b4-8fce-440a-bb83-d97706212f1e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"4", ",", "10", ",", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"86a9e9b1-7afb-4dd5-9846-7d8730986bc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "6", ",", "8", ",", "10"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"16ee89ca-d9ab-496d-acfc-34f934f645c1"]
}, Open  ]],

Cell["Go from 0 to 1 in steps of 0.1:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ad82fd3d-54de-48c3-abfb-ef18385e196f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"0", ",", "1", ",", "0.1"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"3d50c2d8-60e3-4d2c-aa9a-57460166fd0a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.1`", ",", "0.2`", ",", "0.30000000000000004`", ",", "0.4`", 
   ",", "0.5`", ",", "0.6000000000000001`", ",", "0.7000000000000001`", ",", 
   "0.8`", ",", "0.9`", ",", "1.`"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[19]=",ExpressionUUID->"66c8c9a5-14c8-482b-a265-8e8769f0d445"]
}, Open  ]],

Cell[TextData[{
 "There are usually many ways to do the same thing in the Wolfram Language. \
For example, here\[CloseCurlyQuote]s how ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " can produce identical plots."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 PageBreakAbove->True,
 CellTags->"p:22",ExpressionUUID->"7f1e819b-e4dc-4a06-b3c4-262283a1d174"],

Cell["Generate a table and plot it:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  9}},ExpressionUUID->"2facee38-e672-4e03-bceb-5c429d9c8f95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"x", "-", 
     RowBox[{"x", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", ".02"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"e6fd39f8-43e2-467e-8cb4-1f1cda35fbf7"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAwBmIQDQEf7BlQgUPeYsY9rEJToOIcDklGoQZaKxdD+QIO
/xX/fit9sAbKF3HwCPgjUXx9E5Qv4cB1fXGBLdd2KF/GwU21lGkWx24oX8Hh
j1XBuY5L+6B8JQfRHq9XLCYHoXwVh6x7hV19Tw5B+WoO1SLr3B9WHYHyNRw8
9UAuOArlazlc0U6VfBRxHMrXcZDhfaA7YcEJKF/PQeFSfjz7uZNQvoHDwyqQ
gaegfEOHBPZzkoG3TkP5Rg6zyucsUt55Bso3dph0ut5jf+1ZKN/EwZ25gltF
4xyUb+qwQ671deAOGN/M4bns8hceeuehfHOHSwz3mDi7YHwLh6rjmlaTTsP4
lg5g736C8a0cIPQFKN8aTd4GTb8tmvl2Ds9Q7LdHc5+Dgxuy+xsc0PzniOr/
BkeHOJTwcXJ4gBx+DU5o4euMGv4Nzmjx4+LggRx/DS4OFSjx6+qQgRz/Da4O
Eijpw82BwRop/TS4OXigpC93Bw7k9NfgjpY+PRw+IKffBg+HBJT07enQgJz+
Gzyh8cHAAACX7tbh
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{190.30859375, Automatic},
  Method->{},
  PlotRange->{{0., 51.}, {0, 0.25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"a2632d10-d035-4133-be96-c1ea11aca085"]
}, Open  ]],

Cell["\<\
Get the same result by doing arithmetic with the range of values:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  9}},ExpressionUUID->"b003272c-0530-41e4-9c7c-5a43922a4d02"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "1", ",", ".02"}], "]"}], "-", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "1", ",", ".02"}], "]"}], "^", "2"}]}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"af8ee75f-303b-4ddc-b161-3b6da5b259e4"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAwBmIQDQEf7BlQgUPeYsY9rEJToOIcDklGoQZaKxdD+QIO
/xX/fit9sAbKF3HwCPgjUXx9E5Qv4cB1fXGBLdd2KF/GwU21lGkWx24oX8Hh
j1XBuY5L+6B8JQfRHq9XLCYHoXwVh6x7hV19Tw5B+WoO1SLr3B9WHYHyNRw8
9UAuOArlazlc0U6VfBRxHMrXcZDhfaA7YcEJKF/PQeFSfjz7uZNQvoHDwyqQ
gaegfEOHBPZzkoG3TkP5Rg6zyucsUt55Bso3dph0ut5jf+1ZKN/EwZ25gltF
4xyUb+qwQ671deAOGN/M4bns8hceeuehfHOHSwz3mDi7YHwLh6rjmlaTTsP4
lg5g736C8a0cIPQFKN8aTd4GTb8tmvl2Ds9Q7LdHc5+Dgxuy+xsc0PzniOr/
BkeHOJTwcXJ4gBx+DU5o4euMGv4Nzmjx4+LggRx/DS4OFSjx6+qQgRz/Da4O
Eijpw82BwRop/TS4OXigpC93Bw7k9NfgjpY+PRw+IKffBg+HBJT07enQgJz+
Gzyh8cHAAACX7tbh
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{189.52734375, Automatic},
  Method->{},
  PlotRange->{{0., 51.}, {0, 0.25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"5b5a6b65-03e4-4223-9be0-0c81bed9048e"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Table",
  BaseStyle->"Link"],
 " always separately computes each entry in the list it \
generates\[LongDash]and you can see this if you use ",
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 " in ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 
  4}},ExpressionUUID->"d4ae738f-cd44-45b6-bc64-5f907e131458"],

Cell["\<\
This generates 20 independent random integers with size up to 10:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 
  7}},ExpressionUUID->"1dde9d87-f4ea-4e30-8e92-06e0b654a4d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", "10", "]"}], ",", "20"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"6c1bc705-ae5c-4c26-8738-b1d5e23a9398"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "1", ",", "4", ",", "3", ",", "6", ",", "7", ",", "6", ",", "10", 
   ",", "9", ",", "2", ",", "1", ",", "4", ",", "5", ",", "8", ",", "3", ",", 
   "8", ",", "3", ",", "8", ",", "3", ",", "0"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"022fc60e-274c-4501-8299-02f68c87dc03"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["RandomInteger",
  BaseStyle->"Link"],
 " can actually also generate the list directly."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {7, 4}},
 CellTags->"i:7",ExpressionUUID->"ac7563b6-cfc6-4e03-a51e-ebe0041fef9e"],

Cell["This again generates 20 random integers with size up to 10:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{66, 10}, {4, 7}},
 CellTags->"i:8",ExpressionUUID->"fd64772c-4d85-49ae-84e8-35081663dda2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"10", ",", "20"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"3f417dad-0797-4aa1-8c68-0a8447582950"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "0", ",", "3", ",", "1", ",", "9", ",", "6", ",", "0", ",", "8", 
   ",", "5", ",", "2", ",", "7", ",", "8", ",", "0", ",", "10", ",", "4", ",",
    "4", ",", "9", ",", "5", ",", "7", ",", "1"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"3ddef5ca-884c-480e-b711-ae3bb683bffb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{64, Inherited}, {8, 
   18}},ExpressionUUID->"2b225fdd-176d-4c99-a8e3-e2c6814fa054"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"x", ",", "5"}], "]"}], " ", Cell[TextData[{
     "list of 5 copies of ",
     Cell[BoxData[
     "x"], "InlineCode",ExpressionUUID->
      "cf8d97f3-cf96-4219-8692-1ea37d258ab7"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "e27ca36d-bcc5-4021-a79c-920cbf2ab549"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "10"}], "}"}]}], "]"}], " ", Cell[TextData[{
     "list of values of ",
     Cell[BoxData[
      RowBox[{"f", "[", "n", "]"}]], "InlineCode",ExpressionUUID->
      "ef3dc977-ca90-42c1-8aa7-99c8ed6aeac6"],
     " with ",
     Cell[BoxData[
     "n"], "InlineCode",ExpressionUUID->
      "e362ee31-ee24-472d-8403-1bedd27b2913"],
     " going up to 10 "
    }], "VocabularyText",ExpressionUUID->
     "0e76950d-5c3f-4e6d-82f3-11ca82ec1f2d"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "2", ",", "10"}], "}"}]}], "]"}], " ", Cell[TextData[{
     "list of values with ",
     Cell[BoxData[
     "n"], "InlineCode",ExpressionUUID->
      "9647af8e-c4ae-4d3b-b827-4766724df09b"],
     " going from 2 to 10 "
    }], "VocabularyText",ExpressionUUID->
     "f319a56c-1fa8-4cb6-9b73-14b716324480"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "2", ",", "10", ",", "4"}], "}"}]}], "]"}], " ", 
    Cell[TextData[{
     "list of values with ",
     Cell[BoxData[
     "n"], "InlineCode",ExpressionUUID->
      "3025f539-bef5-4a32-8242-81fb975bcd42"],
     " going from 2 to 10 in steps of 4 "
    }], "VocabularyText",ExpressionUUID->
     "a6c1ce08-357b-4c31-bed7-dcd77040ff99"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"5", ",", "10"}], "]"}], " ", Cell[
    "list of numbers from 5 to 10 ", "VocabularyText",ExpressionUUID->
     "af6683af-7fad-4c3d-a58a-a96958c928ff"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"10", ",", "20", ",", "2"}], "]"}], " ", Cell[
    "list of numbers from 10 to 20 in steps of 2 ", "VocabularyText",
     ExpressionUUID->"b6a72022-523d-43ca-bedb-0572c5e4533c"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"10", ",", "20"}], "]"}], " ", Cell[
    "list of 20 random integers up to 10 ", "VocabularyText",ExpressionUUID->
     "1c338ace-1119-4d50-9543-e7662edf0267"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True}, False}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"ea5014a9-8204-477f-bf03-d95d393d544b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"99c125f5-0240-47a2-89e2-ea3a7ec5502e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"10 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 11 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-06-making-tables-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eb4355b3-585c-443f-a523-41fae2ba900c"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list in which the number 1000 is repeated 5 times.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"f98d46fb-25e6-4ddc-b9ec-bb0ca3971448"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1000", ",", "1000", ",", "1000", ",", "1000", ",", "1000"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "30a06fa5-5d3e-4f0f-b253-11eaf81732bc"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1000", ",", "1000", ",", "1000", ",", "1000", ",", 
             "1000"}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f0deedcd-dffa-4384-8de4-8c605a814b5e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of the values of ",
 Cell[BoxData[
  RowBox[{"n", "^", "3"}]], "InlineCode",ExpressionUUID->
  "d8f574d1-dfe5-48e0-b364-8d62343b1fb7"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"56de1743-f082-42ad-983a-d4169a4e9ab3"],
 " from 10 to 20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"7f8dec7e-5f25-4efb-abbf-d5b0e14cb567"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1000", ",", "1331", ",", "1728", ",", "2197", ",", "2744", ",", 
         "3375", ",", "4096", ",", "4913", ",", "5832", ",", "6859", ",", 
         "8000"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "2e0a1dff-975e-489f-a884-3c7753675ee8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1000", ",", "1331", ",", "1728", ",", "2197", ",", "2744",
              ",", "3375", ",", "4096", ",", "4913", ",", "5832", ",", "6859",
              ",", "8000"}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"759ff657-7559-429f-a65a-fb6d0e3a415e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a number line plot of the first 20 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"1194ed88-8e3c-435f-be1a-c71069ab1e9d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{1, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{4, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{9, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{16, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{25, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{36, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{49, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{64, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{81, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{100, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{121, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{144, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{169, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{196, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{225, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{256, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{289, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{324, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{361, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{400, 1}]}},
        AspectRatio->NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948],
        
        Axes->{True, False},
        AxesLabel->{None},
        AxesOrigin->{Automatic, Automatic},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        ImagePadding->All,
        PlotRange->{{1., 400.}, {0, 1}},
        PlotRangePadding->{{
           Scaled[0.1], 
           Scaled[0.1]}, {0, 1}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "18ee4a2c-9beb-4745-989e-ed96ebad6c07"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{1, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{4, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{9, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{16, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{25, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{36, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{49, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{64, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{81, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{100, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{121, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{144, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{169, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{196, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{225, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{256, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{289, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{324, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{361, 1}]}}}, {{{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[Medium], 
              AbsoluteThickness[1.6], 
              PointBox[{400, 1}]}}}}, AspectRatio -> 
          NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
          Axes -> {True, False}, AxesLabel -> {None}, 
          AxesOrigin -> {Automatic, Automatic}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          ImagePadding -> All, PlotRange -> {{1., 400.}, {0, 1}}, 
          PlotRangePadding -> {{
             Scaled[0.1], 
             Scaled[0.1]}, {0, 1}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8df059cc-46ca-4d28-9223-ff620fdce0b6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the even numbers (2, 4, 6, ",
 StyleBox["...",
  FontColor->GrayLevel[0.6]],
 ") up to 20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"f4042e25-10a5-47ab-8699-87730897ef72"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "2", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12", ",", "14", 
         ",", "16", ",", "18", ",", "20"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"6309aa30-5b10-48a5-8259-de7586f218a0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12", 
             ",", "14", ",", "16", ",", "18", ",", "20"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"00b37a28-6d2f-4e3d-b66e-775b99c120dc"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " to get the same result as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", "10", "]"}]], "InlineCode",ExpressionUUID->
  "c2e52579-b21e-40ae-8915-50653f7811ca"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"553cd48a-eebe-403f-818c-f8752b50ecaf"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
         "8", ",", "9", ",", "10"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "3c9783f4-43e2-47b0-b991-65c4995f9a49"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",",
              "7", ",", "8", ",", "9", ",", "10"}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"89c7a949-73f6-45f1-919b-749202eb45d2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a bar chart of the first 10 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"df4f3fb3-f860-426f-bce2-c84ebcd5f353"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.3429357798165137, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63], 
           Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5412844036697247, 0.}, {1.4587155963302751`, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{23.5014270414048, 41.353078481760015`}, {
                 54.203146170530886`, 55.871544500999555`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275, 
                  4.}, "RoundingRadius" -> 0]},
                ImageSizeCache->{{42.41472711139198, 60.266378551747195`}, {
                 50.69795117912488, 55.871544500999555`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`, 
                  9.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{61.32802718137917, 79.17967862173438}, {
                 44.85595952678153, 55.871544500999555`}}],
               StatusArea[#, 9]& ,
               TagBoxNote->"9"],
              StyleBox["9", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[9, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276, 
                  16.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{80.24132725136636, 98.09297869172157}, {
                 36.67717121350085, 55.871544500999555`}}],
               StatusArea[#, 16]& ,
               TagBoxNote->"16"],
              StyleBox["16", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[16, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                  25.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{99.15462732135354, 117.00627876170876`}, {
                 26.161586239282826`, 55.871544500999555`}}],
               StatusArea[#, 25]& ,
               TagBoxNote->"25"],
              StyleBox["25", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[25, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                  36.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{118.06792739134073`, 135.91957883169596`}, {
                 13.309204604127466`, 55.871544500999555`}}],
               StatusArea[#, 36]& ,
               TagBoxNote->"36"],
              StyleBox["36", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[36, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                  49.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{136.9812274613279, 
                 154.83287890168313`}, {-1.8799736919652332`, 
                 55.871544500999555`}}],
               StatusArea[#, 49]& ,
               TagBoxNote->"49"],
              StyleBox["49", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[49, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                  64.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{155.8945275313151, 
                 173.7461789716703}, {-19.40594864899527, 
                 55.871544500999555`}}],
               StatusArea[#, 64]& ,
               TagBoxNote->"64"],
              StyleBox["64", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[64, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                  81.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{174.80782760130225`, 
                 192.65947904165748`}, {-39.26872026696265, 
                 55.871544500999555`}}],
               StatusArea[#, 81]& ,
               TagBoxNote->"81"],
              StyleBox["81", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[81, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`, 
                  100.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{193.72112767128945`, 
                 211.57277911164468`}, {-61.46828854586736, 
                 55.871544500999555`}}],
               StatusArea[#, 100]& ,
               TagBoxNote->"100"],
              StyleBox["100", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[100, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5412844036697247, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                 0.}]}], 
              LineBox[{{10.458715596330276`, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
             StyleBox[{}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.3429357798165137, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{220.21484375, Automatic},
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "f7e4c095-0327-4516-9ac9-f9ca6efd3b1a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            Opacity[0], 
            PointBox[{0.3429357798165137, 0.}]}, {{}, {
             RGBColor[0.982864, 0.7431472, 0.3262672], 
             EdgeForm[{
               Opacity[0.63], 
               Thickness[Small]}], {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5412844036697247, 0.}, {
                    1.4587155963302751`, 1.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{24.4825959795683, 
                   42.247147226415194`}, {52.590977198204826`, 
                   54.25351051224964}}], StatusArea[#, 1]& , TagBoxNote -> 
                 "1"], 
                StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275,
                     4.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{43.30095683863141, 61.0655080854783}, {
                   49.10337725607037, 54.25351051224964}}], 
                 StatusArea[#, 4]& , TagBoxNote -> "4"], 
                StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`,
                     9.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{62.11931769769453, 79.88386894454142}, {
                   43.29071068584628, 54.25351051224964}}], 
                 StatusArea[#, 9]& , TagBoxNote -> "9"], 
                StyleBox["9", {}, StripOnInput -> False]], Annotation[#, 
                Style[9, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276,
                     16.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{80.93767855675765, 98.70222980360454}, {
                   35.15297748753255, 54.25351051224964}}], 
                 StatusArea[#, 16]& , TagBoxNote -> "16"], 
                StyleBox["16", {}, StripOnInput -> False]], Annotation[#, 
                Style[16, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                    25.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{99.75603941582077, 
                   117.52059066266764`}, {24.690177661129187`, 
                   54.25351051224964}}], StatusArea[#, 25]& , TagBoxNote -> 
                 "25"], 
                StyleBox["25", {}, StripOnInput -> False]], Annotation[#, 
                Style[25, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                    36.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{118.57440027488387`, 
                   136.33895152173076`}, {11.902311206636185`, 
                   54.25351051224964}}], StatusArea[#, 36]& , TagBoxNote -> 
                 "36"], 
                StyleBox["36", {}, StripOnInput -> False]], Annotation[#, 
                Style[36, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                    49.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{137.39276113394698`, 
                   155.15731238079385`}, {-3.210621875946451, 
                   54.25351051224964}}], StatusArea[#, 49]& , TagBoxNote -> 
                 "49"], 
                StyleBox["49", {}, StripOnInput -> False]], Annotation[#, 
                Style[49, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                    64.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{156.2111219930101, 
                   173.97567323985697`}, {-20.648621586618724`, 
                   54.25351051224964}}], StatusArea[#, 64]& , TagBoxNote -> 
                 "64"], 
                StyleBox["64", {}, StripOnInput -> False]], Annotation[#, 
                Style[64, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                    81.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{175.0294828520732, 
                   192.7940340989201}, {-40.411687925380626`, 
                   54.25351051224964}}], StatusArea[#, 81]& , TagBoxNote -> 
                 "81"], 
                StyleBox["81", {}, StripOnInput -> False]], Annotation[#, 
                Style[81, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`,
                     100.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{193.8478437111363, 
                   211.61239495798318`}, {-62.49982089223217, 
                   54.25351051224964}}], StatusArea[#, 100]& , TagBoxNote -> 
                 "100"], 
                StyleBox["100", {}, StripOnInput -> False]], Annotation[#, 
                Style[100, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{{
              Thickness[Tiny], 
              LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
              StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
             StyleBox[{{
                Thickness[Tiny], 
                LineBox[{{0.5412844036697247, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                   0.}]}], 
                LineBox[{{10.458715596330276`, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`,
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
              "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
            StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, AxesOrigin -> {0.3429357798165137, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {220.21484375, Automatic}, 
          PlotRange -> {{All, All}, {All, All}}, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ac8e1bcb-f384-4cb1-ad9f-d8dbdeb20da2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of lists of digits for the first 10 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"d964ba49-e7ee-4001-80c1-969b8e99db8f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", 
         RowBox[{"{", "4", "}"}], ",", 
         RowBox[{"{", "9", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "911409aa-2c72-4bc2-bb5b-905dbbc42e95"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", "1", "}"}], ",", 
             RowBox[{"{", "4", "}"}], ",", 
             RowBox[{"{", "9", "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6d12b198-5987-49f5-be2e-b36ecb5597bf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list line plot of the length of the sequence of digits for each of \
the first 100 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"5bc06fa3-0810-4072-9703-b43cc17d4ace"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxd0TlKBFEYhdGLkaFBBwYGKiIiIs6zdjnPUzunorFbeEt7S3IJKlZSp6D5
OXx1qaAn3r8Gn0NJPn5/f/f/+e53b5quh/FI032vh0fxGB7Hk3iq6X53Gs/g
WTyH5/ECXsRLeBmv4FW8htfxBt7EW3gb7+BdvIf7uGlv+z8WnH06zgEd55CO
c0THOabjnNBxTuk4Z3ScczrOBR3nko5zRce5puPc0HFu6Th3XTe44Ipzzx4X
XHEG7HHBFeeBPS644jyyxwVXnCf2uOCK88weF1xxXtjjgivOK3tccMV5a2+v
+QEZu2x7
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 100.}, {0, 5.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "af5200ff-3d31-452d-a078-e3fbd73b32be"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{
               RGBColor[0.368417, 0.506779, 0.709798], 
               PointSize[0.01388888888888889], 
               AbsoluteThickness[1.6], 
               LineBox[CompressedData["
1:eJxd0TlKBFEYhdGLkaFBBwYGKiIiIs6zdjnPUzunorFbeEt7S3IJKlZSp6D5
OXx1qaAn3r8Gn0NJPn5/f/f/+e53b5quh/FI032vh0fxGB7Hk3iq6X53Gs/g
WTyH5/ECXsRLeBmv4FW8htfxBt7EW3gb7+BdvIf7uGlv+z8WnH06zgEd55CO
c0THOabjnNBxTuk4Z3ScczrOBR3nko5zRce5puPc0HFu6Th3XTe44Ipzzx4X
XHEG7HHBFeeBPS644jyyxwVXnCf2uOCK88weF1xxXtjjgivOK3tccMV5a2+v
+QEZu2x7
                "]]}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 100.}, {0, 5.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bbea5b65-b40a-436a-877b-60c5c477bdaf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of the first digit of the first 20 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"3f7dd5a2-44b5-4eac-9344-0afc225b112a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "4", ",", "9", ",", "1", ",", "2", ",", "3", ",", "4", ",", 
         "6", ",", "8", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",",
          "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "4"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "0ba6d68f-d1cd-4f3a-8a9a-bf7f33650b38"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "4", ",", "9", ",", "1", ",", "2", ",", "3", ",",
              "4", ",", "6", ",", "8", ",", "1", ",", "1", ",", "1", ",", "1",
              ",", "1", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",",
              "4"}], "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"33785029-b401-4e0a-b138-0e4aa4530930"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list line plot of the first digits of the first 100 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "6.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellMargins->{{110, Inherited}, {4, 
   6}},ExpressionUUID->"da72fd59-9c25-45fc-b829-785b45e2aaae"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxd0zlOA0EUhOESESEBAQEBjBBCCCH2Hdzs+2b2FEHMFd7R+kg+AiDXC/q3
ZJW+qXmjcbt7+vOn/z0i6evv+5/Dz6DXpsowxpyjzg7X8/7x0s5NYG4Sc1O4
r8P1GTx/Fp6D5+EFeBHvtwQvwyt4/1V4zZm/Zx3egDeduU5b8LYz12MH3nXm
Ou7B+85cvwNn5+zBxen1CViH6GEdoYd1jB7WCXpYp+hhnaFP5/933jpgXaCH
dYke1hV6WNfo07l/bloHrFv0sO7Qw7pHD+vB6f1Z4IArrEfMwwHXdO73fusC
B1xhPWEejrTPT4X13LrAAVdYL06fvwIHXGG9Yh6OtM9zhfXWusAB13TnfG9d
4IArrA/noPcLVbZ9wQ==
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 100.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "6b618bb7-59ab-49e1-9ff9-be37636240c8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{
               RGBColor[0.368417, 0.506779, 0.709798], 
               PointSize[0.01388888888888889], 
               AbsoluteThickness[1.6], 
               LineBox[CompressedData["
1:eJxd0zlOA0EUhOESESEBAQEBjBBCCCH2Hdzs+2b2FEHMFd7R+kg+AiDXC/q3
ZJW+qXmjcbt7+vOn/z0i6evv+5/Dz6DXpsowxpyjzg7X8/7x0s5NYG4Sc1O4
r8P1GTx/Fp6D5+EFeBHvtwQvwyt4/1V4zZm/Zx3egDeduU5b8LYz12MH3nXm
Ou7B+85cvwNn5+zBxen1CViH6GEdoYd1jB7WCXpYp+hhnaFP5/933jpgXaCH
dYke1hV6WNfo07l/bloHrFv0sO7Qw7pHD+vB6f1Z4IArrEfMwwHXdO73fusC
B1xhPWEejrTPT4X13LrAAVdYL06fvwIHXGG9Yh6OtM9zhfXWusAB13TnfG9d
4IArrA/noPcLVbZ9wQ==
                "]]}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 100.}, {0, 9.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4699ef57-69ef-4390-b044-b31fe7feb4a3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the differences between ",
 Cell[BoxData[
  RowBox[{"n", "^", "3"}]], "InlineCode",ExpressionUUID->
  "5decfda0-a0c0-4a91-9ad2-39240af11ae7"],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "^", "2"}]], "InlineCode",ExpressionUUID->
  "7e611275-c20e-4675-b37a-c6665cd0c805"],
 " with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"2ffed257-617d-4b4e-ae5a-438c05fe239f"],
 " up to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1e233ebc-5148-418c-82c7-7abc92f081b3"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "0", ",", "4", ",", "18", ",", "48", ",", "100", ",", "180", ",", 
         "294", ",", "448", ",", "648", ",", "900"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "04b0b79a-d035-4f81-acea-2d1061be3f8d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"0", ",", "4", ",", "18", ",", "48", ",", "100", ",", 
             "180", ",", "294", ",", "448", ",", "648", ",", "900"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0896b337-1a67-4b64-a5c8-876f542375ec"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the odd numbers (1, 3, 5, ...) up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4e433f17-a255-4046-8632-7d46a3b9b58a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "3", ",", "5", ",", "7", ",", "9", ",", "11", ",", "13", 
         ",", "15", ",", "17", ",", "19", ",", "21", ",", "23", ",", "25", 
         ",", "27", ",", "29", ",", "31", ",", "33", ",", "35", ",", "37", 
         ",", "39", ",", "41", ",", "43", ",", "45", ",", "47", ",", "49", 
         ",", "51", ",", "53", ",", "55", ",", "57", ",", "59", ",", "61", 
         ",", "63", ",", "65", ",", "67", ",", "69", ",", "71", ",", "73", 
         ",", "75", ",", "77", ",", "79", ",", "81", ",", "83", ",", "85", 
         ",", "87", ",", "89", ",", "91", ",", "93", ",", "95", ",", "97", 
         ",", "99"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "30d570e6-63e6-4661-a2ed-222aa127b703"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9", ",", "11", 
             ",", "13", ",", "15", ",", "17", ",", "19", ",", "21", ",", "23",
              ",", "25", ",", "27", ",", "29", ",", "31", ",", "33", ",", 
             "35", ",", "37", ",", "39", ",", "41", ",", "43", ",", "45", ",",
              "47", ",", "49", ",", "51", ",", "53", ",", "55", ",", "57", 
             ",", "59", ",", "61", ",", "63", ",", "65", ",", "67", ",", "69",
              ",", "71", ",", "73", ",", "75", ",", "77", ",", "79", ",", 
             "81", ",", "83", ",", "85", ",", "87", ",", "89", ",", "91", ",",
              "93", ",", "95", ",", "97", ",", "99"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3497b721-d4ec-444b-a848-4f857bca0be0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the squares of even numbers up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9c3699c1-e357-4fb6-ac7d-0fa492f069e9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "4", ",", "16", ",", "36", ",", "64", ",", "100", ",", "144", ",", 
         "196", ",", "256", ",", "324", ",", "400", ",", "484", ",", "576", 
         ",", "676", ",", "784", ",", "900", ",", "1024", ",", "1156", ",", 
         "1296", ",", "1444", ",", "1600", ",", "1764", ",", "1936", ",", 
         "2116", ",", "2304", ",", "2500", ",", "2704", ",", "2916", ",", 
         "3136", ",", "3364", ",", "3600", ",", "3844", ",", "4096", ",", 
         "4356", ",", "4624", ",", "4900", ",", "5184", ",", "5476", ",", 
         "5776", ",", "6084", ",", "6400", ",", "6724", ",", "7056", ",", 
         "7396", ",", "7744", ",", "8100", ",", "8464", ",", "8836", ",", 
         "9216", ",", "9604", ",", "10000"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"6ab94873-5c82-4dbd-b811-540b32fda1fc"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"4", ",", "16", ",", "36", ",", "64", ",", "100", ",", 
             "144", ",", "196", ",", "256", ",", "324", ",", "400", ",", 
             "484", ",", "576", ",", "676", ",", "784", ",", "900", ",", 
             "1024", ",", "1156", ",", "1296", ",", "1444", ",", "1600", ",", 
             "1764", ",", "1936", ",", "2116", ",", "2304", ",", "2500", ",", 
             "2704", ",", "2916", ",", "3136", ",", "3364", ",", "3600", ",", 
             "3844", ",", "4096", ",", "4356", ",", "4624", ",", "4900", ",", 
             "5184", ",", "5476", ",", "5776", ",", "6084", ",", "6400", ",", 
             "6724", ",", "7056", ",", "7396", ",", "7744", ",", "8100", ",", 
             "8464", ",", "8836", ",", "9216", ",", "9604", ",", "10000"}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"852e69d4-452c-4363-9988-4dd7a4d6e2d8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "3"}], ",", 
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]], "InlineCode",
  ExpressionUUID->"9795339d-8e34-4b79-90ea-20f568a3d912"],
 " using ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b9595c02-56a8-409d-80db-822b1658e022"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "2fb672d1-1009-4cf3-9c2c-2fd1c33e2d95"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"-", "3"}], ",", 
             RowBox[{"-", "2"}], ",", 
             RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d9982265-5d8e-46d4-ba37-fbb5e3c89d55"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list for numbers n up to 20 in which each element is a column of the \
values of ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"89446943-db22-410c-93fd-eed1f0b34e70"],
 ", ",
 Cell[BoxData[
  RowBox[{"n", "^", "2"}]], "InlineCode",ExpressionUUID->
  "1887ee06-9854-497e-b844-0b7223163fd8"],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "^", "3"}]], "InlineCode",ExpressionUUID->
  "dd678d9a-814d-4682-b9f9-26ac11eb0bfa"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"00113889-1a72-4861-8015-4c344e05df8b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TagBox[GridBox[{
            {"1"},
            {"1"},
            {"1"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"2"},
            {"4"},
            {"8"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"3"},
            {"9"},
            {"27"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"4"},
            {"16"},
            {"64"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"5"},
            {"25"},
            {"125"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"6"},
            {"36"},
            {"216"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"7"},
            {"49"},
            {"343"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"8"},
            {"64"},
            {"512"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"9"},
            {"81"},
            {"729"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"10"},
            {"100"},
            {"1000"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"11"},
            {"121"},
            {"1331"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"12"},
            {"144"},
            {"1728"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"13"},
            {"169"},
            {"2197"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"14"},
            {"196"},
            {"2744"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"15"},
            {"225"},
            {"3375"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"16"},
            {"256"},
            {"4096"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"17"},
            {"289"},
            {"4913"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"18"},
            {"324"},
            {"5832"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"19"},
            {"361"},
            {"6859"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"], ",", 
         TagBox[GridBox[{
            {"20"},
            {"400"},
            {"8000"}
           },
           DefaultBaseStyle->"Column",
           GridBoxAlignment->{"Columns" -> {{Left}}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
          "Column"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "3b1dcb2d-0cc6-44c5-bb74-f47d17078db5"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             TagBox[
              
              GridBox[{{"1"}, {"1"}, {"1"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"2"}, {"4"}, {"8"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"3"}, {"9"}, {"27"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"4"}, {"16"}, {"64"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"5"}, {"25"}, {"125"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"6"}, {"36"}, {"216"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"7"}, {"49"}, {"343"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"8"}, {"64"}, {"512"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"9"}, {"81"}, {"729"}}, DefaultBaseStyle -> "Column", 
               GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"10"}, {"100"}, {"1000"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"11"}, {"121"}, {"1331"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"12"}, {"144"}, {"1728"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"13"}, {"169"}, {"2197"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"14"}, {"196"}, {"2744"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"15"}, {"225"}, {"3375"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"16"}, {"256"}, {"4096"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"17"}, {"289"}, {"4913"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"18"}, {"324"}, {"5832"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"19"}, {"361"}, {"6859"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"], ",", 
             TagBox[
              
              GridBox[{{"20"}, {"400"}, {"8000"}}, DefaultBaseStyle -> 
               "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
              "Column"]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ad98d241-7180-41ac-b06d-f001743ba508"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list line plot of the last digits of the first 100 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"bb7be746-9a7d-4953-b55d-412d2fc78a2a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdkElKQ0EURQtHDh04yMCBioiISOx7U8bYxCZqjN1UdOwWaml/SS5BJe8I
dT6Ex/mX2+TPvX8NPydSSh+/v787fr479U15fKbiTsad1/tW3Gndlu6M/LPK
4T39CzlVz6L0JfmXlbOi/lXta0tfk39d+Rvq39S+Lenb8u8of1f9e9q3L/1A
/kPlH6n/WPs60nPtLzD5J3V/gdnXlQ7jP1U+TH+v3ld60s/kh8k/Vz/Mvgvp
MP5L5cP097WvL/1Kfpj8a/XD7LuRDuO/VT5M/0D7BtLv5IfJv6/7Mxz7ivQG
xv9Q52c4+gscTyM9DeWHI7/A9MN8v0fth/HDkd/A9I/qfXlU6wXGD0d+elI/
zPeT3sD4n+v8DNMPx9NITy/yw5FfYPphvt+r9sP4Yf4/TP/b/74fU/h7Zg==

            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 100.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "71387056-ab7a-4d28-8673-8feab5be6718"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxdkElKQ0EURQtHDh04yMCBioiISOx7U8bYxCZqjN1UdOwWaml/SS5BJe8I
dT6Ex/mX2+TPvX8NPydSSh+/v787fr479U15fKbiTsad1/tW3Gndlu6M/LPK
4T39CzlVz6L0JfmXlbOi/lXta0tfk39d+Rvq39S+Lenb8u8of1f9e9q3L/1A
/kPlH6n/WPs60nPtLzD5J3V/gdnXlQ7jP1U+TH+v3ld60s/kh8k/Vz/Mvgvp
MP5L5cP097WvL/1Kfpj8a/XD7LuRDuO/VT5M/0D7BtLv5IfJv6/7Mxz7ivQG
xv9Q52c4+gscTyM9DeWHI7/A9MN8v0fth/HDkd/A9I/qfXlU6wXGD0d+elI/
zPeT3sD4n+v8DNMPx9NITy/yw5FfYPphvt+r9sP4Yf4/TP/b/74fU/h7Zg==

               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 100.}, {0, 9.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"39e0270d-fe9f-4aad-a8ee-30693c215da3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list line plot of the first digit of the first 100 multiples of 3.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"525365d1-038e-4877-be66-996671923a6e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxd08tOAkEQheETVixdsGDhAifEGGMM3kUQ2vtdFFFxS3TNK9Sj1SPxCGqo
XvQ/yeTk65OamZ7JrM3m45+apO+/8z+Xx2K4zHqKhchmKteryJVUzjXgJryK
67bgCm7jvuvwBrwJb+E5t+EOvJPKfezCe/B+ZN7nAXwIH8HHkfm9dOETuBeZ
31sfPoUHkVXkEE6lDdZZZHw/g3WOHtYFeliX6GFdoYd1jR7WDXpYt+hh3aGH
dY8e1gN6WI/oYT2hh/WMHtYIPayX0gk22LPz//laOsEGO6wx5mGDHdYb5mGD
HdYE87DBDusd87DBDusD87DBDusT87DBDmuKedhgh/UVWU+/UPeIuA==
            
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 100.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "fd54d6af-1be2-4f1b-b691-98d0c0bafba9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxd08tOAkEQheETVixdsGDhAifEGGMM3kUQ2vtdFFFxS3TNK9Sj1SPxCGqo
XvQ/yeTk65OamZ7JrM3m45+apO+/8z+Xx2K4zHqKhchmKteryJVUzjXgJryK
67bgCm7jvuvwBrwJb+E5t+EOvJPKfezCe/B+ZN7nAXwIH8HHkfm9dOETuBeZ
31sfPoUHkVXkEE6lDdZZZHw/g3WOHtYFeliX6GFdoYd1jR7WDXpYt+hh3aGH
dY8e1gN6WI/oYT2hh/WMHtYIPayX0gk22LPz//laOsEGO6wx5mGDHdYb5mGD
HdYE87DBDusd87DBDusD87DBDusT87DBDmuKedhgh/UVWU+/UPeIuA==
               
               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 100.}, {0, 9.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f4c365e3-5b1d-4db0-b857-7ca17fba3eed"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list line plot of the total of the digits for each number up to 200.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e8149273-5049-460a-b38c-4d78829e825e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxd1jkOFUcUhtEnIkICAgcEDUKWhSzEDGYwxTzPGLCN7TajidhCLaWX0iHL
6CV4CQb5P8EtJFQ6AdKnerduc/DN56fv9+x2uy9f/347///z7+V67lo99w7n
vuHcP5zfDeeB4ZyG89BwHm615/uh54eh58jQ8+PQc3ToOTb0HB96Tgw9J4eu
U0PP6aHnzNBzdug5N/T8NPScH3ouDD0Xh55LOd3Tz0PP5aGn1Z7Oeq7Uns56
rtaeznqu1Z7Ofrfrtaez+7lRezq7n5u1p3N6drdqT2f3c7v2dDZHd2pPZ/dz
t/Z0dj/3ak9n93O/9nR2Pw9qT2dz/bD2dHY/j2pP5/TsHteexno4PSu7nye1
p3HeWef0rOx+ntaexn4vTs/K7udZ7Wmcns7pWdm7f157Gqenc3pWNj+/1J7G
fi9Oz8r20Iva0zh7qHN6VjY/L2tPY/PM6VnZ/LyqPY3T0zk9K9uLv+bMfm6c
fdg5+2dl++e3nHlfjc0zmx82P7/nPJR/z+aH07Oyffi69jT23jk9K3tff9Se
xunpbH7Y/PxZexrbh5yele2fv2pPY++d07Oy+Zlrz8TmmdMzs/vh9Czs9+L0
bJye3d+1Z2LzzOmZ2fvi9Czs9+L0bGx+3tSeie1DTs/M3henZ2HvndOzsfl5
W3smTk/j9MxsP3N6FvbeOT0b2z/vas/E5pnTM7P3xelZ2PeC07Ox/fO+9kxs
H3J6Zk5P5/Qs7HvB6dnY9+tD7ZnYPuT0zGw/c3oW9t45PRv7fn2sPRP7nnJ6
ZrafOT0LZz+vnJ6N7Z9/as/Evqecnpl93zk9C/tecHo29v/oTzl37T8vjwOM

            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 200.}, {0, 19.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "5861fbd3-f4c8-4d5d-9f5f-47b2dec748f0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxd1jkOFUcUhtEnIkICAgcEDUKWhSzEDGYwxTzPGLCN7TajidhCLaWX0iHL
6CV4CQb5P8EtJFQ6AdKnerduc/DN56fv9+x2uy9f/347///z7+V67lo99w7n
vuHcP5zfDeeB4ZyG89BwHm615/uh54eh58jQ8+PQc3ToOTb0HB96Tgw9J4eu
U0PP6aHnzNBzdug5N/T8NPScH3ouDD0Xh55LOd3Tz0PP5aGn1Z7Oeq7Uns56
rtaeznqu1Z7Ofrfrtaez+7lRezq7n5u1p3N6drdqT2f3c7v2dDZHd2pPZ/dz
t/Z0dj/3ak9n93O/9nR2Pw9qT2dz/bD2dHY/j2pP5/TsHteexno4PSu7nye1
p3HeWef0rOx+ntaexn4vTs/K7udZ7Wmcns7pWdm7f157Gqenc3pWNj+/1J7G
fi9Oz8r20Iva0zh7qHN6VjY/L2tPY/PM6VnZ/LyqPY3T0zk9K9uLv+bMfm6c
fdg5+2dl++e3nHlfjc0zmx82P7/nPJR/z+aH07Oyffi69jT23jk9K3tff9Se
xunpbH7Y/PxZexrbh5yele2fv2pPY++d07Oy+Zlrz8TmmdMzs/vh9Czs9+L0
bJye3d+1Z2LzzOmZ2fvi9Czs9+L0bGx+3tSeie1DTs/M3henZ2HvndOzsfl5
W3smTk/j9MxsP3N6FvbeOT0b2z/vas/E5pnTM7P3xelZ2PeC07Ox/fO+9kxs
H3J6Zk5P5/Qs7HvB6dnY9+tD7ZnYPuT0zGw/c3oW9t45PRv7fn2sPRP7nnJ6
ZrafOT0LZz+vnJ6N7Z9/as/Evqecnpl93zk9C/tecHo29v/oTzl37T8vjwOM

               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 200.}, {0, 19.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3514f2a9-21f1-432b-8261-0400d04d8053"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list line plot of the total of the digits for each of the first 100 \
squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"325f9ba0-f94c-4ea6-8009-9957ee87a22e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdkzlOQ0EQREdEhAQEBARgIYQQQuw7eNgxmMULW4og5gp9tH8kHwEj1wu6
LFmlN7+mu3r+/MWv3/7PVCnle/z/18lv1M5a6kRmpNPSlq3PS2eN58zP+qp0
Qbpkvpatk2fZ+q6Yn7ob0jXjdfOzzr5N6bZ0y/ysk2vH8uyaf8/67BsfWJ9D
y3NkfY/Nf2LPT23/meVpW/8q1XsJmPrnuV7AzH+R/QGT59L2w+S5sv4w+a6t
Psy53uR+AVP/NucNmPO5y/6Auacdy9fJ/nKf6wXM/A+WH+b8ura/m/3lUarz
COPyZPlh5nvOeQLmHr3k5xUmD6w8Dcw97eU8tZf9AateAzN/P/srTF5Y77sx
fxnkPNU4BtnfwJzPMOepw+wPWHkamO/o1fLDvC9YeRqY83+Tar4KMz/c0n57
Xt5tP6z6AdMf5v58WH5Y9QJmfvOXT+mo/Qf7j3gr
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{239.57421875, Automatic},
        Method->{},
        PlotRange->{{0., 100.}, {0, 31.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "c2150178-c214-43c6-8ee6-e169797db6ca"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxdkzlOQ0EQREdEhAQEBARgIYQQQuw7eNgxmMULW4og5gp9tH8kHwEj1wu6
LFmlN7+mu3r+/MWv3/7PVCnle/z/18lv1M5a6kRmpNPSlq3PS2eN58zP+qp0
Qbpkvpatk2fZ+q6Yn7ob0jXjdfOzzr5N6bZ0y/ysk2vH8uyaf8/67BsfWJ9D
y3NkfY/Nf2LPT23/meVpW/8q1XsJmPrnuV7AzH+R/QGT59L2w+S5sv4w+a6t
Psy53uR+AVP/NucNmPO5y/6Auacdy9fJ/nKf6wXM/A+WH+b8ura/m/3lUarz
COPyZPlh5nvOeQLmHr3k5xUmD6w8Dcw97eU8tZf9AateAzN/P/srTF5Y77sx
fxnkPNU4BtnfwJzPMOepw+wPWHkamO/o1fLDvC9YeRqY83+Tar4KMz/c0n57
Xt5tP6z6AdMf5v58WH5Y9QJmfvOXT+mo/Qf7j3gr
               "]]}}}, {}}, 
          AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {True, True}, AxesLabel -> {None, None}, 
          AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
          Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {239.57421875, Automatic}, 
          Method -> {}, PlotRange -> {{0., 100.}, {0, 31.}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ba99a9a9-9ede-489e-8d7a-995fb1d198ae"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a number line plot of the numbers ",
 Cell[BoxData[
  RowBox[{"1", "/", "n"}]], "InlineCode",ExpressionUUID->
  "a312fcfe-5616-402b-9c4e-08e64c87bf6e"],
 " with ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"d6ebacd6-bdd7-47c9-b7dd-d1e2e6dcc920"],
 " from 1 to 20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"538666bf-b31e-4463-bd51-839ca9658759"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{1, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 2], 1}, {0.5, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 3], 1}, {0.3333333333333333, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 4], 1}, {0.25, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 5], 1}, {0.2, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 6], 1}, {0.16666666666666666`, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 7], 1}, {0.14285714285714285`, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 8], 1}, {0.125, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 9], 1}, {0.1111111111111111, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 10], 1}, {0.1, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 11], 1}, {0.09090909090909091, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 12], 1}, {0.08333333333333333, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 13], 1}, {0.07692307692307693, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 14], 1}, {0.07142857142857142, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 15], 1}, {0.06666666666666667, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 16], 1}, {0.0625, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 17], 1}, {0.058823529411764705`, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 18], 1}, {0.05555555555555555, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 19], 1}, {0.05263157894736842, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 20], 1}, {0.05, 1}]]}},
        AspectRatio->NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948],
        
        Axes->{True, False},
        AxesLabel->{None},
        AxesOrigin->{Automatic, Automatic},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        ImagePadding->All,
        PlotRange->{{0.05, 1.}, {0, 1}},
        PlotRangePadding->{{
           Scaled[0.1], 
           Scaled[0.1]}, {0, 1}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "5299f17d-32fd-4b88-8416-4128a216e25a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[{1, 1}]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 2], 1}, {0.5, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 3], 1}, {0.3333333333333333, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 4], 1}, {0.25, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 5], 1}, {0.2, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 6], 1}, {0.16666666666666666`, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 7], 1}, {0.14285714285714285`, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 8], 1}, {0.125, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 9], 1}, {0.1111111111111111, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 10], 1}, {0.1, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 11], 1}, {0.09090909090909091, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 12], 1}, {0.08333333333333333, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 13], 1}, {0.07692307692307693, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 14], 1}, {0.07142857142857142, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 15], 1}, {0.06666666666666667, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 16], 1}, {0.0625, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 17], 1}, {0.058823529411764705`, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 18], 1}, {0.05555555555555555, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 19], 1}, {0.05263157894736842, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 20], 1}, {0.05, 1}]]}}}, AspectRatio -> 
          NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
          Axes -> {True, False}, AxesLabel -> {None}, 
          AxesOrigin -> {Automatic, Automatic}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          ImagePadding -> All, PlotRange -> {{0.05, 1.}, {0, 1}}, 
          PlotRangePadding -> {{
             Scaled[0.1], 
             Scaled[0.1]}, {0, 1}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ea9feecb-9d3a-4bdb-9df6-518789fb1440"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of a list of random integers where the ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"376802ed-5b43-4897-8390-2981bf578c83"],
 "th integer is between 0 and ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"74c867f1-5f4f-4820-a4d7-69adb2fe5bac"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+6.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d5c35dd6-84be-4fdb-a653-5cbc74e8a06e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdlMsuREEQhjtWlhYWFhZMRERE3O9MGYzLGMOYGWyFtVeoR+tH8giI/ztJ
1UlO/nznVHdduxffv4afU6WUj9/3T/+f73aJj8Xv0xZ1xqL5bLKfS3bzyX4B
lraS3VLabzntt2LRz2riNYtxrSe7jeR3M/FWWred4tlJce4m/3tJ91P8B8nv
YdrnKMV7nOxOkv9TKfU8k1K3Nv8xs6AOs/5cqn44jN9O9O8w9b6I+zhMHS+l
qoPD1P1Kqvo53JJ2peqjd5Ofa6nq5jBzcyMlf5j8bqWqo8PM/13Mw2H62ovf
vZf2vZd29B+mz30p+fVTHg9SscPkP0jrBnG/8hjjN1jz5bDqXsXNHDxJNXcG
a/4dVlxVTJ/KUKrHYNXHYc1XhZmf5+jHYOZATH8rzHkaSVU/g3W+fRTjqKPo
p4ylumcMZp5g3XN1nOKaSHXeDWbeJvF7RanDi+zIX9ycN1jnuYqbPr/KTnNh
4mZuYdbD3G9vjd8fZFWBlA==
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{239.51171875, Automatic},
        Method->{},
        PlotRange->{{0., 100.}, {0, 93.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "06ef6814-2db4-42b1-9195-a30bd769a0af"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.01388888888888889], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxdlMsuREEQhjtWlhYWFhZMRERE3O9MGYzLGMOYGWyFtVeoR+tH8giI/ztJ
1UlO/nznVHdduxffv4afU6WUj9/3T/+f73aJj8Xv0xZ1xqL5bLKfS3bzyX4B
lraS3VLabzntt2LRz2riNYtxrSe7jeR3M/FWWred4tlJce4m/3tJ91P8B8nv
YdrnKMV7nOxOkv9TKfU8k1K3Nv8xs6AOs/5cqn44jN9O9O8w9b6I+zhMHS+l
qoPD1P1Kqvo53JJ2peqjd5Ofa6nq5jBzcyMlf5j8bqWqo8PM/13Mw2H62ovf
vZf2vZd29B+mz30p+fVTHg9SscPkP0jrBnG/8hjjN1jz5bDqXsXNHDxJNXcG
a/4dVlxVTJ/KUKrHYNXHYc1XhZmf5+jHYOZATH8rzHkaSVU/g3W+fRTjqKPo
p4ylumcMZp5g3XN1nOKaSHXeDWbeJvF7RanDi+zIX9ycN1jnuYqbPr/KTnNh
4mZuYdbD3G9vjd8fZFWBlA==
               "]]}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {239.51171875, Automatic}, 
          Method -> {}, PlotRange -> {{0., 100.}, {0, 93.}}, 
          PlotRangeClipping -> True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"16185854-f166-4eea-a438-95a053b92068"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{64, Inherited}, {8, 
   28}},ExpressionUUID->"d7ef4209-e04a-47ee-b3c4-f21ba042c12a"],

Cell[TextData[{
 "What does the ",
 Cell[BoxData[
  RowBox[{"{", "\[NegativeThinSpace]", 
   StyleBox["...",
    FontColor->GrayLevel[0.6]], "}"}]], "InlineCode",ExpressionUUID->
  "eb9277b4-2ae8-4463-817d-a30deba85d93"],
 " (list) in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"n", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "ccdef05a-7c5e-4f55-b8eb-29810b278171"],
 " mean?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"7cedf2f4-cdf7-4887-8685-4add54f2218b"],

Cell[TextData[{
 "A list is always a way of collecting things together. Here what it\
\[CloseCurlyQuote]s collecting is the variable ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"b92c3f12-373b-45e4-a2c9-a7ca475e2292"],
 " and its range 5. In the Wolfram Language, this kind of use of a list is \
called an ",
 StyleBox["iterator specification",
  FontSlant->"Italic"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cc895cc6-5cea-4d15-a036-5c7d412261a4"],

Cell[TextData[{
 "Why is the ",
 Cell[BoxData[
  RowBox[{"{", "\[NegativeThinSpace]", 
   StyleBox["...",
    FontColor->GrayLevel[0.6]], "}"}]], "InlineCode",ExpressionUUID->
  "406f264b-14aa-48b9-8902-8f02b8bc9914"],
 " (list) in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"n", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "81ecf614-0e2e-4bc1-83f0-26725fbf6c23"],
 " needed?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 
   9}},ExpressionUUID->"3cde657a-53c4-49d8-9514-5364ad86d6b7"],

Cell[TextData[{
 "So one can easily generalize to multidimensional arrays, like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "5"}], "}"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "0c5bd3b8-fc93-4bc5-bffc-21c0a89c0f3a"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d590bb75-dd93-4729-a1b3-735a7d0cc5a8"],

Cell["What are the constraints on the names of variables?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 7}},
 CellTags->"i:10",ExpressionUUID->"1a1167ec-b9f4-4a7c-8821-ab8664b7f012"],

Cell["\<\
They can be any sequence of letters or numbers, but they \
can\[CloseCurlyQuote]t start with a number, and\[LongDash]to avoid possible \
confusion with built-in Wolfram Language functions\[LongDash]they shouldn\
\[CloseCurlyQuote]t start with a capital letter.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"24faf304-0521-4f65-abb2-bce144c0244e"],

Cell["\<\
Why do you have to name a variable if the name never matters?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 
   10}},ExpressionUUID->"8234a9ed-b805-42b2-bf57-2a0c11c1b418"],

Cell[TextData[{
 "Good question! In ",
 ButtonBox["Section 26",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-26-pure-anonymous-functions.nb", None}],
 ", we\[CloseCurlyQuote]ll see how to avoid having named variables. It\
\[CloseCurlyQuote]s very elegant, but it\[CloseCurlyQuote]s a little more \
abstract than what we\[CloseCurlyQuote]re doing with ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " here. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1e9ccbf3-1be6-4a02-8735-cedfe3927634"],

Cell[TextData[{
 "Can ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " deal with negative numbers?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{65, Inherited}, {2, 10}},
 CellTags->"i:11",ExpressionUUID->"74e9393f-05ca-4be5-86fd-bc4fe0392ed1"],

Cell[TextData[{
 "Yes. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"-", "2"}], ",", "2"}], "]"}]], "InlineCode",ExpressionUUID->
  "613b4c61-c072-4db5-b2c9-c073193b7644"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]], "InlineCode",
  ExpressionUUID->"97d1b49b-6401-442f-9039-005650f3aba2"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"2", ",", 
    RowBox[{"-", "2"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "95f5665a-0794-4e45-86e7-dbe1d104477c"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineCode",ExpressionUUID->
  "fe97fe78-cb35-4e88-98e5-92e69a1e09b8"],
 ", but ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"2", ",", 
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "fa54b80e-206c-44f2-a2ac-3aed2fad4729"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "1", ",", "0", ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "2"}]}], "}"}]], "InlineCode",ExpressionUUID->
  "9e42f70c-a881-496c-8cd7-9e7a9b39d020"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9e46d57e-572a-4188-865c-eaff1c77ea60"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{64, Inherited}, {8, 
   28}},ExpressionUUID->"fb5473c3-2adf-491f-a5b1-33dcc97c7241"],

Cell[TextData[{
 "If you specify steps that don\[CloseCurlyQuote]t fit evenly in the range \
you give, ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " just go as far as the steps take them, potentially stopping before the \
upper limit. (So ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"1", ",", "6", ",", "2"}], "]"}]], "InlineCode",ExpressionUUID->
  "253a1512-3ae6-479d-b46d-c2559d1f077b"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "5"}], "}"}]], "InlineCode",ExpressionUUID->
  "dc6e7dad-dee5-4a06-b763-8c32a46f97f6"],
 ", stopping at 5, not 6.)"
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"110056cb-428c-41df-9c5f-4aff5a9252ae"],

Cell[TextData[{
 "Using forms like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"x", ",", "20"}], "]"}]], "InlineCode",ExpressionUUID->
  "2a2284a5-f5dc-4f0e-9e73-7add129647cc"],
 " requires at least Version 10.2 of the Wolfram Language. In earlier \
versions, this had to be specified as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", "20", "}"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "d7e247b7-77fd-476e-b74d-e0194a10c6a9"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"a72eca50-5929-4dc0-b365-d909f0fa5521"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{64, Inherited}, {8, 
   28}},ExpressionUUID->"81f1c727-13ed-4663-8320-7a6a34dc1d79"],

Cell[TextData[ButtonBox["The Table Function in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/language/ref/Table.html"], None},
 ButtonNote->
  "http://reference.wolfram.com/language/ref/Table.html"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{64, Inherited}, {0, 8}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"f3b5f93d-c85e-451e-b7de-ffb59f31bede"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Making Tables: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Operations on Lists\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Operations on Lists", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Colors and Styles\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Colors and Styles", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingCopies->1,
PrintingStartingPageNumber->19,
PrintingPageRange->{1, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Making Tables \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"ede27bdc-ca38-4000-993d-e8a472c62632"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:19"->{
  Cell[656, 23, 463, 12, 93, "Section",ExpressionUUID->"c486abdb-e970-4d23-97e7-fee023d18640",
   CounterAssignments->{{"Section", 5}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->"p:19"]},
 "i:1"->{
  Cell[1122, 37, 556, 18, 90, "Text",ExpressionUUID->"725a0904-39f0-4e0e-b6ee-7d591a4c904d",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[1681, 57, 350, 10, 58, "Text",ExpressionUUID->"05a75da2-7a23-4873-ba0d-c2ce52419b54",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[31257, 777, 468, 16, 58, "Text",ExpressionUUID->"da78e52b-11a0-4a3f-be35-3e0bdc5dfc07",
   CellTags->"i:3"]},
 "LastCellOfAPage"->{
  Cell[34910, 901, 336, 9, 70, "Output",ExpressionUUID->"7b220f52-2184-43f4-9061-8c0c57f7b9b6",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[87790, 2220, 577, 15, 70, "Text",ExpressionUUID->"63455b18-5b90-4d9a-975c-09ef7c84ab8f",
   CellTags->{"LastCellOfAPage", "i:5"}],
  Cell[96865, 2537, 426, 10, 70, "Output",ExpressionUUID->"66c8c9a5-14c8-482b-a265-8e8769f0d445",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[104922, 2791, 3215, 96, 70, "VocabularyTable",ExpressionUUID->"ea5014a9-8204-477f-bf03-d95d393d544b",
   CellTags->"LastCellOfAPage"],
  Cell[251644, 6672, 498, 12, 70, "MoreExplore",ExpressionUUID->"f3b5f93d-c85e-451e-b7de-ffb59f31bede",
   CellTags->"LastCellOfAPage"]},
 "p:20"->{
  Cell[35261, 913, 208, 5, 70, "CodeCaption",ExpressionUUID->"f2b9db75-473c-400d-97fb-97fbd98e9426",
   CellTags->{"p:20", "i:4"}]},
 "i:4"->{
  Cell[35261, 913, 208, 5, 70, "CodeCaption",ExpressionUUID->"f2b9db75-473c-400d-97fb-97fbd98e9426",
   CellTags->{"p:20", "i:4"}]},
 "i:5"->{
  Cell[87790, 2220, 577, 15, 70, "Text",ExpressionUUID->"63455b18-5b90-4d9a-975c-09ef7c84ab8f",
   CellTags->{"LastCellOfAPage", "i:5"}]},
 "p:21"->{
  Cell[88370, 2237, 304, 8, 70, "CodeCaption",ExpressionUUID->"b045f9e8-cdb3-4eab-8302-3eadc41998c9",
   CellTags->"p:21"]},
 "i:6"->{
  Cell[94727, 2459, 391, 14, 70, "Text",ExpressionUUID->"89239e2d-196c-451f-b6b6-c7ed94bec7a5",
   CellTags->"i:6"]},
 "p:22"->{
  Cell[97306, 2550, 435, 14, 70, "Text",ExpressionUUID->"7f1e819b-e4dc-4a06-b3c4-262283a1d174",
   PageBreakAbove->True,
   CellTags->"p:22"]},
 "i:7"->{
  Cell[103489, 2742, 296, 9, 70, "Text",ExpressionUUID->"ac7563b6-cfc6-4e03-a51e-ebe0041fef9e",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[103788, 2753, 253, 6, 70, "CodeCaption",ExpressionUUID->"fd64772c-4d85-49ae-84e8-35081663dda2",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[243962, 6406, 665, 22, 70, "Question",ExpressionUUID->"7cedf2f4-cdf7-4887-8685-4add54f2218b",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[246447, 6493, 248, 5, 70, "Question",ExpressionUUID->"1a1167ec-b9f4-4a7c-8821-ab8664b7f012",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[247908, 6537, 292, 10, 70, "Question",ExpressionUUID->"74e9393f-05ca-4be5-86fd-bc4fe0392ed1",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[250680, 6638, 716, 22, 70, "TechNote",ExpressionUUID->"a72eca50-5929-4dc0-b365-d909f0fa5521",
   CellTags->"i:12"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:19", 342915, 8527},
 {"i:1", 343159, 8531},
 {"i:2", 343284, 8534},
 {"i:3", 343409, 8537},
 {"LastCellOfAPage", 343548, 8540},
 {"p:20", 344283, 8553},
 {"i:4", 344426, 8556},
 {"i:5", 344569, 8559},
 {"p:21", 344719, 8562},
 {"i:6", 344854, 8565},
 {"p:22", 344983, 8568},
 {"i:7", 345137, 8572},
 {"i:8", 345265, 8575},
 {"i:9", 345400, 8578},
 {"i:10", 345534, 8581},
 {"i:11", 345668, 8584},
 {"i:12", 345803, 8587}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[656, 23, 463, 12, 93, "Section",ExpressionUUID->"c486abdb-e970-4d23-97e7-fee023d18640",
 CounterAssignments->{{"Section", 5}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:19"],
Cell[1122, 37, 556, 18, 90, "Text",ExpressionUUID->"725a0904-39f0-4e0e-b6ee-7d591a4c904d",
 CellTags->"i:1"],
Cell[1681, 57, 350, 10, 58, "Text",ExpressionUUID->"05a75da2-7a23-4873-ba0d-c2ce52419b54",
 CellTags->"i:2"],
Cell[2034, 69, 192, 4, 37, "CodeCaption",ExpressionUUID->"0034a8ed-9d6b-4f22-b200-408f4a19c3e5"],
Cell[CellGroupData[{
Cell[2251, 77, 179, 4, 29, "Input",ExpressionUUID->"9a46dbd4-f04c-4647-94da-586ec5d7d1a2"],
Cell[2433, 83, 304, 8, 40, "Output",ExpressionUUID->"aa7218a7-be7b-4ebb-92ae-1ddf3ecbad99",
 Evaluatable->False]
}, Open  ]],
Cell[2752, 94, 331, 10, 34, "CodeCaption",ExpressionUUID->"3128d8de-e25a-4dc9-9598-0d2248323932"],
Cell[CellGroupData[{
Cell[3108, 108, 179, 4, 29, "Input",ExpressionUUID->"ced6e7f2-e9b5-4145-be68-83f102aa6ea8"],
Cell[3290, 114, 304, 8, 40, "Output",ExpressionUUID->"0aaddce8-d92a-4bea-b4b8-25fccd80af10",
 Evaluatable->False]
}, Open  ]],
Cell[3609, 125, 202, 5, 34, "CodeCaption",ExpressionUUID->"75f2b3d4-9db5-4141-a18b-3f7baaaa0065"],
Cell[CellGroupData[{
Cell[3836, 134, 228, 6, 29, "Input",ExpressionUUID->"2e995a71-da74-42d8-a799-e7bf5e372317"],
Cell[4067, 142, 787, 26, 40, "Output",ExpressionUUID->"63e26703-8f54-4c84-93e5-9defb0530d6f",
 Evaluatable->False]
}, Open  ]],
Cell[4869, 171, 268, 8, 34, "CodeCaption",ExpressionUUID->"b6a25359-35b1-439b-ac3d-d7c97845189a"],
Cell[CellGroupData[{
Cell[5162, 183, 278, 8, 29, "Input",ExpressionUUID->"0b298d27-8bd2-4580-8e7b-6e6101a94e64"],
Cell[5443, 193, 25799, 581, 115, "Output",ExpressionUUID->"06a8b72a-963e-44f8-a181-ac4ad886f1e7",
 Evaluatable->False]
}, Open  ]],
Cell[31257, 777, 468, 16, 58, "Text",ExpressionUUID->"da78e52b-11a0-4a3f-be35-3e0bdc5dfc07",
 CellTags->"i:3"],
Cell[31728, 795, 435, 13, 34, "CodeCaption",ExpressionUUID->"1d93b6fb-82c6-4264-a833-f27531c11986"],
Cell[CellGroupData[{
Cell[32188, 812, 256, 7, 70, "Input",ExpressionUUID->"813ea3f7-4130-4034-baa7-2aa0fa3df391"],
Cell[32447, 821, 392, 11, 70, "Output",ExpressionUUID->"5b123954-2109-4c26-9ff8-58faefb1b5a8",
 Evaluatable->False]
}, Open  ]],
Cell[32854, 835, 1301, 37, 70, "Text",ExpressionUUID->"2747f229-c6bb-4d3f-92c4-b92c66314232"],
Cell[34158, 874, 472, 14, 70, "CodeCaption",ExpressionUUID->"8d5f0dcd-626d-47ac-b116-538ce06d851a"],
Cell[CellGroupData[{
Cell[34655, 892, 252, 7, 70, "Input",ExpressionUUID->"6fabf7cc-65e9-4ac7-8811-4234ca389ef7"],
Cell[34910, 901, 336, 9, 70, "Output",ExpressionUUID->"7b220f52-2184-43f4-9061-8c0c57f7b9b6",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[35261, 913, 208, 5, 70, "CodeCaption",ExpressionUUID->"f2b9db75-473c-400d-97fb-97fbd98e9426",
 CellTags->{"p:20", "i:4"}],
Cell[CellGroupData[{
Cell[35494, 922, 252, 7, 70, "Input",ExpressionUUID->"1bef520e-2a11-4067-b3d8-f307558c852d"],
Cell[35749, 931, 312, 8, 70, "Output",ExpressionUUID->"028e4628-64b1-4d8e-835d-1a04e41f1e57",
 Evaluatable->False]
}, Open  ]],
Cell[36076, 942, 238, 9, 70, "Text",ExpressionUUID->"a085ef90-6c3d-4229-9ea1-60057cbe310a"],
Cell[36317, 953, 289, 11, 70, "CodeCaption",ExpressionUUID->"1a05fa38-89b5-428c-93b3-ea5388ae9cb2"],
Cell[CellGroupData[{
Cell[36631, 968, 260, 7, 70, "Input",ExpressionUUID->"7ca8c22d-e571-4c34-95df-52b76958e31f"],
Cell[36894, 977, 530, 16, 70, "Output",ExpressionUUID->"5eab1e9d-e9ca-4ea5-9b47-9310b6939ff4",
 Evaluatable->False]
}, Open  ]],
Cell[37439, 996, 196, 4, 70, "CodeCaption",ExpressionUUID->"8b8361c4-512f-489a-979f-fa9cdf0f6d71"],
Cell[CellGroupData[{
Cell[37660, 1004, 295, 8, 70, "Input",ExpressionUUID->"8f6c3e6f-ed01-4169-95d4-64115719dea7"],
Cell[37958, 1014, 2321, 90, 70, "Output",ExpressionUUID->"16cf8005-5173-4418-985b-7e8d9440a237",
 Evaluatable->False]
}, Open  ]],
Cell[40294, 1107, 233, 7, 70, "CodeCaption",ExpressionUUID->"11216638-4f51-4361-beb1-347b7caa3ba8"],
Cell[CellGroupData[{
Cell[40552, 1118, 325, 9, 70, "Input",ExpressionUUID->"20155e04-a930-4554-880e-86b40c296189"],
Cell[40880, 1129, 3209, 89, 70, "Output",ExpressionUUID->"1b7341de-4c06-464e-9663-16b500388a17",
 Evaluatable->False]
}, Open  ]],
Cell[44104, 1221, 195, 4, 70, "CodeCaption",ExpressionUUID->"60180499-b0b2-41c0-bc0d-f388aa21403a"],
Cell[CellGroupData[{
Cell[44324, 1229, 324, 9, 70, "Input",ExpressionUUID->"d667ce4d-d3ad-4009-bfa0-8425efa6037c"],
Cell[44651, 1240, 43124, 977, 70, "Output",ExpressionUUID->"3e9dfa44-12be-4bc4-94d7-0699ad813350",
 Evaluatable->False]
}, Open  ]],
Cell[87790, 2220, 577, 15, 70, "Text",ExpressionUUID->"63455b18-5b90-4d9a-975c-09ef7c84ab8f",
 CellTags->{"LastCellOfAPage", "i:5"}],
Cell[88370, 2237, 304, 8, 70, "CodeCaption",ExpressionUUID->"b045f9e8-cdb3-4eab-8302-3eadc41998c9",
 CellTags->"p:21"],
Cell[CellGroupData[{
Cell[88699, 2249, 259, 7, 70, "Input",ExpressionUUID->"05d13b71-bedc-475e-a5e4-0852d9a7ebaf"],
Cell[88961, 2258, 317, 8, 70, "Output",ExpressionUUID->"5521b93a-6750-499f-85d9-063f9f955044",
 Evaluatable->False]
}, Open  ]],
Cell[89293, 2269, 351, 9, 70, "CodeCaption",ExpressionUUID->"08a07124-e71c-4a1f-8615-929c348ecb52"],
Cell[CellGroupData[{
Cell[89669, 2282, 339, 10, 70, "Input",ExpressionUUID->"f06e5afc-c240-4a2f-b4d2-8c2dd01c5c40"],
Cell[90011, 2294, 545, 16, 70, "Output",ExpressionUUID->"6838c137-54b8-4ba7-a5dc-ad52bdca2e17",
 Evaluatable->False]
}, Open  ]],
Cell[90571, 2313, 901, 30, 70, "Text",ExpressionUUID->"7fcad456-90bd-4aa2-88b6-c49c60f7ee89"],
Cell[91475, 2345, 303, 9, 70, "CodeCaption",ExpressionUUID->"42fc99f2-37db-4712-9c05-9228eb576347"],
Cell[CellGroupData[{
Cell[91803, 2358, 258, 7, 70, "Input",ExpressionUUID->"7269355d-8af3-406b-be3a-6cf42cc309b7"],
Cell[92064, 2367, 589, 16, 70, "Output",ExpressionUUID->"12c35adb-0ecf-406e-9b39-22100590f421",
 Evaluatable->False]
}, Open  ]],
Cell[92668, 2386, 303, 9, 70, "CodeCaption",ExpressionUUID->"f5dc01bc-8f0a-4c74-89f5-777ada9d01c0"],
Cell[CellGroupData[{
Cell[92996, 2399, 268, 7, 70, "Input",ExpressionUUID->"09d663ce-f084-4cc4-9d64-0c914e9979d9"],
Cell[93267, 2408, 472, 13, 70, "Output",ExpressionUUID->"03509aef-fade-4075-889c-a86e780e46b7",
 Evaluatable->False]
}, Open  ]],
Cell[93754, 2424, 297, 9, 70, "CodeCaption",ExpressionUUID->"634183a0-48a3-42a9-8465-8c055f124484"],
Cell[CellGroupData[{
Cell[94076, 2437, 278, 7, 70, "Input",ExpressionUUID->"7e63a211-e477-4889-ae96-66b46e0d1db4"],
Cell[94357, 2446, 355, 10, 70, "Output",ExpressionUUID->"7cba10b8-3077-4561-9df7-02f4f624c2fd",
 Evaluatable->False]
}, Open  ]],
Cell[94727, 2459, 391, 14, 70, "Text",ExpressionUUID->"89239e2d-196c-451f-b6b6-c7ed94bec7a5",
 CellTags->"i:6"],
Cell[95121, 2475, 181, 4, 70, "CodeCaption",ExpressionUUID->"e0c72652-8759-484f-8998-c0493f230826"],
Cell[CellGroupData[{
Cell[95327, 2483, 180, 4, 70, "Input",ExpressionUUID->"9d62cda8-8513-4344-a643-e93802b4e5d2"],
Cell[95510, 2489, 272, 7, 70, "Output",ExpressionUUID->"2a0c5508-297f-44be-b75e-5f4d8ecde1c3",
 Evaluatable->False]
}, Open  ]],
Cell[95797, 2499, 203, 5, 70, "CodeCaption",ExpressionUUID->"fb2490b4-8fce-440a-bb83-d97706212f1e"],
Cell[CellGroupData[{
Cell[96025, 2508, 190, 4, 70, "Input",ExpressionUUID->"86a9e9b1-7afb-4dd5-9846-7d8730986bc4"],
Cell[96218, 2514, 239, 6, 70, "Output",ExpressionUUID->"16ee89ca-d9ab-496d-acfc-34f934f645c1",
 Evaluatable->False]
}, Open  ]],
Cell[96472, 2523, 174, 4, 70, "CodeCaption",ExpressionUUID->"ad82fd3d-54de-48c3-abfb-ef18385e196f"],
Cell[CellGroupData[{
Cell[96671, 2531, 191, 4, 70, "Input",ExpressionUUID->"3d50c2d8-60e3-4d2c-aa9a-57460166fd0a"],
Cell[96865, 2537, 426, 10, 70, "Output",ExpressionUUID->"66c8c9a5-14c8-482b-a265-8e8769f0d445",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[97306, 2550, 435, 14, 70, "Text",ExpressionUUID->"7f1e819b-e4dc-4a06-b3c4-262283a1d174",
 PageBreakAbove->True,
 CellTags->"p:22"],
Cell[97744, 2566, 206, 5, 70, "CodeCaption",ExpressionUUID->"2facee38-e672-4e03-bceb-5c429d9c8f95"],
Cell[CellGroupData[{
Cell[97975, 2575, 342, 10, 70, "Input",ExpressionUUID->"e6fd39f8-43e2-467e-8cb4-1f1cda35fbf7"],
Cell[98320, 2587, 1570, 39, 70, "Output",ExpressionUUID->"a2632d10-d035-4133-be96-c1ea11aca085",
 Evaluatable->False]
}, Open  ]],
Cell[99905, 2629, 250, 7, 70, "CodeCaption",ExpressionUUID->"b003272c-0530-41e4-9c7c-5a43922a4d02"],
Cell[CellGroupData[{
Cell[100180, 2640, 350, 10, 70, "Input",ExpressionUUID->"af8ee75f-303b-4ddc-b161-3b6da5b259e4"],
Cell[100533, 2652, 1570, 39, 70, "Output",ExpressionUUID->"5b5a6b65-03e4-4223-9be0-0c81bed9048e",
 Evaluatable->False]
}, Open  ]],
Cell[102118, 2694, 443, 16, 70, "Text",ExpressionUUID->"d4ae738f-cd44-45b6-bc64-5f907e131458"],
Cell[102564, 2712, 250, 7, 70, "CodeCaption",ExpressionUUID->"1dde9d87-f4ea-4e30-8e92-06e0b654a4d2"],
Cell[CellGroupData[{
Cell[102839, 2723, 222, 5, 70, "Input",ExpressionUUID->"6c1bc705-ae5c-4c26-8738-b1d5e23a9398"],
Cell[103064, 2730, 410, 9, 70, "Output",ExpressionUUID->"022fc60e-274c-4501-8299-02f68c87dc03",
 Evaluatable->False]
}, Open  ]],
Cell[103489, 2742, 296, 9, 70, "Text",ExpressionUUID->"ac7563b6-cfc6-4e03-a51e-ebe0041fef9e",
 CellTags->"i:7"],
Cell[103788, 2753, 253, 6, 70, "CodeCaption",ExpressionUUID->"fd64772c-4d85-49ae-84e8-35081663dda2",
 CellTags->"i:8"],
Cell[CellGroupData[{
Cell[104066, 2763, 189, 4, 70, "Input",ExpressionUUID->"3f417dad-0797-4aa1-8c68-0a8447582950"],
Cell[104258, 2769, 410, 9, 70, "Output",ExpressionUUID->"3ddef5ca-884c-480e-b711-ae3bb683bffb",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104717, 2784, 202, 5, 70, "VocabularySection",ExpressionUUID->"2b225fdd-176d-4c99-a8e3-e2c6814fa054"],
Cell[104922, 2791, 3215, 96, 70, "VocabularyTable",ExpressionUUID->"ea5014a9-8204-477f-bf03-d95d393d544b",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108174, 2892, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"99c125f5-0240-47a2-89e2-ea3a7ec5502e"],
Cell[CellGroupData[{
Cell[109979, 2942, 1449, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"eb4355b3-585c-443f-a523-41fae2ba900c"],
Cell[CellGroupData[{
Cell[111453, 2991, 764, 21, 70, "Exercise",ExpressionUUID->"f98d46fb-25e6-4ddc-b9ec-bb0ca3971448"],
Cell[112220, 3014, 1302, 37, 70, "ExerciseOutput",ExpressionUUID->"f0deedcd-dffa-4384-8de4-8c605a814b5e"]
}, Closed]],
Cell[CellGroupData[{
Cell[113559, 3056, 975, 28, 70, "Exercise",ExpressionUUID->"7f8dec7e-5f25-4efb-abbf-d5b0e14cb567"],
Cell[114537, 3086, 1492, 40, 70, "ExerciseOutput",ExpressionUUID->"759ff657-7559-429f-a65a-fb6d0e3a415e"]
}, Closed]],
Cell[CellGroupData[{
Cell[116066, 3131, 755, 21, 70, "Exercise",ExpressionUUID->"1194ed88-8e3c-435f-be1a-c71069ab1e9d"],
Cell[116824, 3154, 7894, 173, 70, "ExerciseOutput",ExpressionUUID->"8df059cc-46ca-4d28-9223-ff620fdce0b6"]
}, Closed]],
Cell[CellGroupData[{
Cell[124755, 3332, 812, 24, 70, "Exercise",ExpressionUUID->"f4042e25-10a5-47ab-8699-87730897ef72"],
Cell[125570, 3358, 1403, 39, 70, "ExerciseOutput",ExpressionUUID->"00b37a28-6d2f-4e3d-b66e-775b99c120dc"]
}, Closed]],
Cell[CellGroupData[{
Cell[127010, 3402, 959, 30, 70, "Exercise",ExpressionUUID->"553cd48a-eebe-403f-818c-f8752b50ecaf"],
Cell[127972, 3434, 1393, 39, 70, "ExerciseOutput",ExpressionUUID->"89c7a949-73f6-45f1-919b-749202eb45d2"]
}, Closed]],
Cell[CellGroupData[{
Cell[129402, 3478, 748, 21, 70, "Exercise",ExpressionUUID->"df4f3fb3-f860-426f-bce2-c84ebcd5f353"],
Cell[130153, 3501, 36330, 859, 70, "ExerciseOutput",ExpressionUUID->"ac8e1bcb-f384-4cb1-ad9f-d8dbdeb20da2"]
}, Closed]],
Cell[CellGroupData[{
Cell[166520, 4365, 764, 21, 70, "Exercise",ExpressionUUID->"d964ba49-e7ee-4001-80c1-969b8e99db8f"],
Cell[167287, 4388, 2483, 70, 70, "ExerciseOutput",ExpressionUUID->"6d12b198-5987-49f5-be2e-b36ecb5597bf"]
}, Closed]],
Cell[CellGroupData[{
Cell[169807, 4463, 805, 22, 70, "Exercise",ExpressionUUID->"5bc06fa3-0810-4072-9703-b43cc17d4ace"],
Cell[170615, 4487, 3628, 87, 70, "ExerciseOutput",ExpressionUUID->"bbea5b65-b40a-436a-877b-60c5c477bdaf"]
}, Closed]],
Cell[CellGroupData[{
Cell[174280, 4579, 763, 21, 70, "Exercise",ExpressionUUID->"3f7dd5a2-44b5-4eac-9344-0afc225b112a"],
Cell[175046, 4602, 1628, 42, 70, "ExerciseOutput",ExpressionUUID->"33785029-b401-4e0a-b138-0e4aa4530930"]
}, Closed]],
Cell[CellGroupData[{
Cell[176711, 4649, 775, 21, 70, "Exercise",ExpressionUUID->"da72fd59-9c25-45fc-b829-785b45e2aaae"],
Cell[177489, 4672, 3774, 89, 70, "ExerciseOutput",ExpressionUUID->"4699ef57-69ef-4390-b044-b31fe7feb4a3"]
}, Closed]],
Cell[CellGroupData[{
Cell[181300, 4766, 1064, 31, 70, "Exercise",ExpressionUUID->"1e233ebc-5148-418c-82c7-7abc92f081b3"],
Cell[182367, 4799, 1427, 40, 70, "ExerciseOutput",ExpressionUUID->"0896b337-1a67-4b64-a5c8-876f542375ec"]
}, Closed]],
Cell[CellGroupData[{
Cell[183831, 4844, 721, 20, 70, "Exercise",ExpressionUUID->"4e433f17-a255-4046-8632-7d46a3b9b58a"],
Cell[184555, 4866, 2449, 53, 70, "ExerciseOutput",ExpressionUUID->"3497b721-d4ec-444b-a848-4f857bca0be0"]
}, Closed]],
Cell[CellGroupData[{
Cell[187041, 4924, 718, 20, 70, "Exercise",ExpressionUUID->"9c3699c1-e357-4fb6-ac7d-0fa492f069e9"],
Cell[187762, 4946, 2648, 55, 70, "ExerciseOutput",ExpressionUUID->"852e69d4-452c-4363-9988-4dd7a4d6e2d8"]
}, Closed]],
Cell[CellGroupData[{
Cell[190447, 5006, 981, 31, 70, "Exercise",ExpressionUUID->"b9595c02-56a8-409d-80db-822b1658e022"],
Cell[191431, 5039, 1436, 42, 70, "ExerciseOutput",ExpressionUUID->"d9982265-5d8e-46d4-ba37-fbb5e3c89d55"]
}, Closed]],
Cell[CellGroupData[{
Cell[192904, 5086, 1100, 32, 70, "Exercise",ExpressionUUID->"00113889-1a72-4861-8015-4c344e05df8b"],
Cell[194007, 5120, 14045, 394, 70, "ExerciseOutput",ExpressionUUID->"ad98d241-7180-41ac-b06d-f001743ba508"]
}, Closed]],
Cell[CellGroupData[{
Cell[208089, 5519, 731, 20, 70, "Exercise",ExpressionUUID->"bb7be746-9a7d-4953-b55d-412d2fc78a2a"],
Cell[208823, 5541, 3849, 91, 70, "ExerciseOutput",ExpressionUUID->"39e0270d-fe9f-4aad-a8ee-30693c215da3"]
}, Closed]],
Cell[CellGroupData[{
Cell[212709, 5637, 738, 20, 70, "Exercise",ExpressionUUID->"525365d1-038e-4877-be66-996671923a6e"],
Cell[213450, 5659, 3746, 89, 70, "ExerciseOutput",ExpressionUUID->"f4c365e3-5b1d-4db0-b857-7ca17fba3eed"]
}, Closed]],
Cell[CellGroupData[{
Cell[217233, 5753, 740, 20, 70, "Exercise",ExpressionUUID->"e8149273-5049-460a-b38c-4d78829e825e"],
Cell[217976, 5775, 4705, 105, 70, "ExerciseOutput",ExpressionUUID->"3514f2a9-21f1-432b-8261-0400d04d8053"]
}, Closed]],
Cell[CellGroupData[{
Cell[222718, 5885, 750, 21, 70, "Exercise",ExpressionUUID->"325f9ba0-f94c-4ea6-8009-9957ee87a22e"],
Cell[223471, 5908, 4028, 93, 70, "ExerciseOutput",ExpressionUUID->"ba99a9a9-9ede-489e-8d7a-995fb1d198ae"]
}, Closed]],
Cell[CellGroupData[{
Cell[227536, 6006, 943, 27, 70, "Exercise",ExpressionUUID->"538666bf-b31e-4463-bd51-839ca9658759"],
Cell[228482, 6035, 10137, 230, 70, "ExerciseOutput",ExpressionUUID->"ea9feecb-9d3a-4bdb-9df6-518789fb1440"]
}, Closed]],
Cell[CellGroupData[{
Cell[238656, 6270, 945, 26, 70, "Exercise",ExpressionUUID->"d5c35dd6-84be-4fdb-a653-5cbc74e8a06e"],
Cell[239604, 6298, 4107, 94, 70, "ExerciseOutput",ExpressionUUID->"16185854-f166-4eea-a438-95a053b92068"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[243772, 6399, 187, 5, 70, "QASection",ExpressionUUID->"d7ef4209-e04a-47ee-b3c4-f21ba042c12a"],
Cell[243962, 6406, 665, 22, 70, "Question",ExpressionUUID->"7cedf2f4-cdf7-4887-8685-4add54f2218b",
 CellTags->"i:9"],
Cell[244630, 6430, 516, 14, 70, "Answer",ExpressionUUID->"cc895cc6-5cea-4d15-a036-5c7d412261a4"],
Cell[245149, 6446, 691, 23, 70, "Question",ExpressionUUID->"3cde657a-53c4-49d8-9514-5364ad86d6b7"],
Cell[245843, 6471, 601, 20, 70, "Answer",ExpressionUUID->"d590bb75-dd93-4729-a1b3-735a7d0cc5a8"],
Cell[246447, 6493, 248, 5, 70, "Question",ExpressionUUID->"1a1167ec-b9f4-4a7c-8821-ab8664b7f012",
 CellTags->"i:10"],
Cell[246698, 6500, 406, 9, 70, "Answer",ExpressionUUID->"24faf304-0521-4f65-abb2-bce144c0244e"],
Cell[247107, 6511, 252, 7, 70, "Question",ExpressionUUID->"8234a9ed-b805-42b2-bf57-2a0c11c1b418"],
Cell[247362, 6520, 543, 15, 70, "Answer",ExpressionUUID->"1e9ccbf3-1be6-4a02-8735-cedfe3927634"],
Cell[247908, 6537, 292, 10, 70, "Question",ExpressionUUID->"74e9393f-05ca-4be5-86fd-bc4fe0392ed1",
 CellTags->"i:11"],
Cell[248203, 6549, 1412, 49, 70, "Answer",ExpressionUUID->"9e46d57e-572a-4188-865c-eaff1c77ea60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249652, 6603, 200, 5, 70, "TechNoteSection",ExpressionUUID->"fb5473c3-2adf-491f-a5b1-33dcc97c7241"],
Cell[249855, 6610, 822, 26, 70, "TechNote",ExpressionUUID->"110056cb-428c-41df-9c5f-4aff5a9252ae"],
Cell[250680, 6638, 716, 22, 70, "TechNote",ExpressionUUID->"a72eca50-5929-4dc0-b365-d909f0fa5521",
 CellTags->"i:12"]
}, Open  ]],
Cell[CellGroupData[{
Cell[251433, 6665, 208, 5, 70, "MoreExploreSection",ExpressionUUID->"81f1c727-13ed-4663-8320-7a6a34dc1d79"],
Cell[251644, 6672, 498, 12, 70, "MoreExplore",ExpressionUUID->"f3b5f93d-c85e-451e-b7de-ffb59f31bede",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature qIj8I@sjqgUnwJ59QeBDGFDl *)
