(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    464556,      10557]
NotebookOptionsPosition[    356439,       8386]
NotebookOutlinePosition[    450666,      10311]
CellTagsIndexPosition[    450152,      10289]
WindowTitle->Operations on Lists: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Operations on Lists", "SectionInline",ExpressionUUID->
   "40891c9f-6292-40ae-b4b7-51a9df7b1077"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 4}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{
  "p:15", "i:1"},ExpressionUUID->"07a1b31c-b8a7-4e6f-aaa0-e601aefd876f"],

Cell["\<\
There are thousands of functions in the Wolfram Language that work with \
lists. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"443c04e4-9cfa-4415-954e-eda361014ae0"],

Cell["You can do arithmetic with lists:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"69ccecfe-6298-4697-bead-9ad2e5fb942f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "+", "10"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"cf913516-8416-4bd4-a3c3-a02f28cc7f82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", "12", ",", "13"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"ff1ee7b0-b1b6-4834-a7aa-a0f3203f63fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "2"}], "}"}], "*", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"b62c8936-2f8f-4459-836c-e8079fb6b873"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "6"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"d7ed373b-1193-498c-ac51-5718b8738739"]
}, Open  ]],

Cell["Compute the first 10 squares:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1098bcfa-c79a-4bb3-85d0-bd39243e0f4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Range", "[", "10", "]"}], "^", "2"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"3cb71252-3beb-43de-a5d6-b8c855a6c0be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"ecbb2829-e98d-460d-8f90-204e9c3cf7e0"]
}, Open  ]],

Cell["Plot the first 20 squares:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b922ec60-70ab-4b2a-a947-4219a172757f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], "^", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"3f5f4324-7066-400a-b6c9-d016523ed058"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7FFpBgcIJQClOaC0Epq4AZQWgdKWUFoCSjtB
aRkI3eAB5StA6QBUcx1CoHwVKB0JpdWg8nFQvgaUToLSWhBaIRXK14HalwHl
60Hlc9DcXQClDSG0QBGUbwS1rwTKN4bQE8qgfBMoXekAAOkrGTI=
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{200.03125, Automatic},
  Method->{},
  PlotRange->{{0., 20.}, {0, 400.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"f1ad32f1-7223-4148-98fc-17cdd6069b04"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Sort",
  BaseStyle->"Link"],
 " sorts a list into order:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"e13d5fe0-734c-46c0-9d81-c4d55ff4fbfe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "6"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"5cfde2ef-262c-40b6-a34d-6baf29faf660"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "6"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"88995c7f-fb39-4244-b76b-ee3c5d41a1c1"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Length",
  BaseStyle->"Link"],
 " finds ",
 "how long",
 " a list is:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"a504acf0-1aa5-4326-b357-cef10d4e40ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "3", ",", "4", ",", "5", ",", "3", ",", "4", ",", "5"}], 
   "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"6d38388e-3e00-4e29-9ca0-f589c46adf38"],

Cell[BoxData["7"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"072aa6cf-f9fe-48c0-bca9-01dce0a27b47"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Total",
  BaseStyle->"Link"],
 " ",
 "gives the total from adding up a list",
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"82d9d604-f643-4185-8858-eb367a440ecc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"97e6b34c-7753-46f3-bffd-852cbe536060"],

Cell[BoxData["6"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"4db42392-e7a6-4377-b220-cfc2ccc63366"]
}, Open  ]],

Cell["Find the total of the numbers from 1 to 10:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"067d3034-c53f-49d5-9eaf-d3941b4c189e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"a57380dd-53bb-4ad5-88f7-e4aadac38709"],

Cell[BoxData["55"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[8]=",ExpressionUUID->"f39da581-6df9-48a1-9c9d-e11ea37a541b"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Count",
  BaseStyle->"Link"],
 " counts the number of times something appears in a list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:16", "i:6"},ExpressionUUID->"6b28327e-9774-4047-b633-393294e22eae"],

Cell[TextData[{
 "Count the number of times ",
 Cell[BoxData[
 "a"], "InlineCode",ExpressionUUID->"5213e8ec-7791-40d6-be1a-e68152b0f951"],
 " appears in the list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"347193c5-a9ab-47cc-9ad8-6a9d49c24d76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a", ",", "a", ",", "c", ",", "b", ",", "a"}],
     "}"}], ",", "a"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"2ce033e2-79d8-4c82-a603-cba8be8195a2"],

Cell[BoxData["4"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"e1b3b8fb-f417-4b7c-b053-a913487b84ce"]
}, Open  ]],

Cell[TextData[{
 "It\[CloseCurlyQuote]s often useful to be able to get individual elements of \
a list. ",
 ButtonBox["First",
  BaseStyle->"Link"],
 " gives the first element; ",
 ButtonBox["Last",
  BaseStyle->"Link"],
 " gives the last element. ",
 ButtonBox["Part",
  BaseStyle->"Link"],
 " gives",
 " the element at a particular position."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"46052a8d-e9e7-46e1-b290-ea66652211cb"],

Cell["Pick out the first element of a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"51d22c8f-8e72-4e82-a04d-95dceb2daa42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"{", 
   RowBox[{"7", ",", "6", ",", "5"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"9cc7cd22-c99c-4193-a134-1c82b1697897"],

Cell[BoxData["7"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"7c093b0f-7ec0-422b-9553-bdfe02d818f5"]
}, Open  ]],

Cell["Pick out the last element:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"55c80733-acfd-4244-b21f-5a7146fea8cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"{", 
   RowBox[{"7", ",", "6", ",", "5"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"261b30bc-407f-4d93-a53e-a6df6cd81ff9"],

Cell[BoxData["5"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"d062f73e-6a8a-4630-a6e7-341ee814dae7"]
}, Open  ]],

Cell["Pick out element number 2:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"027c5c7b-0d95-4726-928d-3b9043b785d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "5"}], "}"}], ",", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"d0c22ce2-86bc-47f9-8b70-4c579e2aca58"],

Cell[BoxData["6"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"52e6630a-dab9-49f1-b86a-954b96d4d2b7"]
}, Open  ]],

Cell["\<\
Picking out the first element in a list you\[CloseCurlyQuote]ve sorted is the \
same as finding the minimum element:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"00f07991-d6ef-49b1-b54e-8f3e75b4fb17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], 
   "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"c827e44c-473c-4b40-8bd9-0e41ca2a1276"],

Cell[BoxData["1"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"65c49e89-d1ce-4829-8c34-132c1513e462"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"{", 
   RowBox[{"6", ",", "7", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"90bceca3-6720-43e3-8ef9-a995081465fc"],

Cell[BoxData["1"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"5da4c0a8-79eb-4ea0-86dc-afe060e19976"]
}, Open  ]],

Cell[TextData[{
 "If you have a number, like 5671, you can make a list of its digits using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"CodeLink"], "[", "5671", "]"}]], "InlineCodeText",
  ExpressionUUID->"5a8e4c6a-7d25-4671-a0e1-834af56d3889"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"7f13fb63-03b6-4581-9092-e1016667ae38"],

Cell["Break a number into a list of digits:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bb228c56-c238-474b-a5f4-bb309da692d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", "1988", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"cabeae60-2563-43f2-b428-4dec094672ca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "9", ",", "8", ",", "8"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"5766e1e6-ac5b-4f62-86c5-1820ef4dc978"]
}, Open  ]],

Cell["Find the last digit:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8cac28c9-f062-4549-b398-c0b55ef97722"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"IntegerDigits", "[", "1988", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"5ac53af3-eb09-4694-8ea6-74ae1164cccf"],

Cell[BoxData["8"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"122a5b54-5fa5-4460-9cce-7e0f33614410"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Take",
  BaseStyle->"Link"],
 " lets you take a specified number of elements from the beginning of a \
list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:17", "i:9"},ExpressionUUID->"b02ee93f-4c9c-4f99-bebf-59183831125e"],

Cell["Take the first 3 elements from a list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"91940afe-674d-4de2-8197-1c1186c71523"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "101", ",", "203", ",", "401", ",", "602", ",", "332", ",", "412"}], 
    "}"}], ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"ce8826dc-88f8-4746-829a-970cd73de2d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"101", ",", "203", ",", "401"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"3e436103-4296-4972-9126-d3036dee1fbc"]
}, Open  ]],

Cell["Take the first 10 digits of 2 to the power 100:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e807b086-12ac-4615-9187-c65c6a9d16f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"2", "^", "100"}], "]"}], ",", "10"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"1680e0d6-1197-4d9c-9fd2-469e94b7c7ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "6", ",", "7", ",", "6", ",", "5", ",", "0", ",", "6", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"d433e31c-2b92-45be-aa6c-bff303094cf9"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Drop",
  BaseStyle->"Link"],
 " drops elements from the beginning of a list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"a2931965-bc72-4af5-a214-123a38fe3364"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "101", ",", "203", ",", "401", ",", "602", ",", "332", ",", "412"}], 
    "}"}], ",", "3"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"e6ef39c2-4892-4b14-9816-e164769ac999"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"602", ",", "332", ",", "412"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"93c08b90-d53f-4f92-9c61-d7716d1baf20"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"67428668-ba77-4511-af74-6b4945b15a51"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], 
     ButtonBox["+",
      BaseStyle->"CodeLink",
      ButtonData->"Plus"], 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "2"}], "}"}]}], " ", Cell[
    "arithmetic on lists ", "VocabularyText",ExpressionUUID->
     "05e84062-519c-4888-84d0-127837b88968"]},
   {
    RowBox[{
     ButtonBox["Sort",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7", ",", "1"}], "}"}], "]"}], " ", Cell[
    "sort a list into order ", "VocabularyText",ExpressionUUID->
     "79578f5a-ba0f-4430-834a-21249dc5a6a1"]},
   {
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "]"}], " ", Cell[
    "length of a list (number of elements) ", "VocabularyText",ExpressionUUID->
     "443db598-7c42-424e-ad9b-d7c3036ee3e8"]},
   {
    RowBox[{
     ButtonBox["Total",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}], "]"}], " ", Cell[
    "total of all elements in a list ", "VocabularyText",ExpressionUUID->
     "4dbda4a0-2a83-418f-852a-be2c2ea86366"]},
   {
    RowBox[{
     ButtonBox["Count",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "3"}], "}"}], ",", "3"}], "]"}], " ", Cell[
    "count occurrences of an element", "VocabularyText",ExpressionUUID->
     "ca045df4-361c-4974-b625-8d2e42758a01"]},
   {
    RowBox[{
     ButtonBox["First",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "]"}], " ", Cell[
    "first element in a list ", "VocabularyText",ExpressionUUID->
     "713824ff-6c49-4101-9a0b-f5c6192c3577"]},
   {
    RowBox[{
     ButtonBox["Last",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "8"}], "}"}], "]"}], " ", Cell[
    "last element in a list ", "VocabularyText",ExpressionUUID->
     "b3e44eb6-fcdd-47ba-9db9-e1ddb80e2960"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", "2"}], "]"}], " ", Cell[
    TextData[{
     "particular part of a list, also written as ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "4"}], "}"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]], "InlineCode",ExpressionUUID->
      "bfd7bf38-1170-4bc7-a0a8-257b39d8e8f1"]
    }], "VocabularyText",ExpressionUUID->
     "333d54d3-e078-47c4-883e-d126062a0b8a"]},
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "4", ",", "3", ",", "1"}], "}"}], ",", "2"}], "]"}], 
    " ", Cell[
    "take elements from the beginning of a list ", "VocabularyText",
     ExpressionUUID->"34eb2c60-4889-4abf-aeb5-0d1f826c384a"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "4", ",", "3", ",", "1"}], "}"}], ",", "2"}], "]"}], 
    " ", Cell[
    "drop elements from the beginning of a list", "VocabularyText",
     ExpressionUUID->"f7df9ca2-cc02-4a1d-a8d7-59fd4238dc13"]},
   {
    RowBox[{
     ButtonBox["IntegerDigits",
      BaseStyle->"CodeLink"], "[", "1234", "]"}], " ", Cell[
    "list of digits in a number ", "VocabularyText",ExpressionUUID->
     "b2ed0b71-3160-492c-9039-3a0293272418"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fa19262b-b6ef-4d93-8eee-1c6e9fa9d349"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"aefa32e4-8737-4a6a-a68f-a80de57fbcb7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"14 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 7 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-05-operations-on-lists-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7f906fc7-8bc9-45f6-9601-398955558a35"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 10 squares, in reverse order.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"71df9fed-19a6-4239-bf45-0b940aaff4f1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "100", ",", "81", ",", "64", ",", "49", ",", "36", ",", "25", ",", 
         "16", ",", "9", ",", "4", ",", "1"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"4ac5ff01-198d-461e-ba03-32b404ee8f03"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"100", ",", "81", ",", "64", ",", "49", ",", "36", ",", 
             "25", ",", "16", ",", "9", ",", "4", ",", "1"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"386aa3d6-0764-43d7-831a-c9f5ab8491a8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the total of the first 10 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e651c269-abcf-43c7-9703-7c048cdf3d00"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "385"], "ExerciseOutput",ExpressionUUID->
       "15477220-050c-406b-89ad-571986b7733c"],
      Apply[TextCell, 
       Cell[
        BoxData["385"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29da07e2-c85d-44ff-9932-972743a7ce45"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a plot of the first 10 squares, starting at 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ec338b9f-d10a-427e-8917-842a07140f36"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           PointBox[{{1., 1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 25.}, {6., 
            36.}, {7., 49.}, {8., 64.}, {9., 81.}, {10., 100.}}]}, {}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 10.}, {0, 100.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "15dca2c8-e2a2-4340-813b-eee27e08fb98"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[1.6], 
              
              PointBox[{{1., 1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 25.}, {
               6., 36.}, {7., 49.}, {8., 64.}, {9., 81.}, {10., 
               100.}}]}}, {}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 10.}, {0, 100.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"af301c8d-0498-413d-817c-9cdcdd33a8c1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Sort",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Join",
  BaseStyle->"Link"],
 " ",
 "and ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " to create ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "4", ",", 
    "4"}], "}"}]], "InlineCode",ExpressionUUID->
  "9df57f5c-ac31-4ce7-9257-674628b691d7"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"fef594e9-0049-44be-8b23-0e65552c7f67"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "4", ",", 
         "4"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "e2c06383-a504-45e4-94fd-372ac1d268ae"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "3", ",",
              "4", ",", "4"}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4050b21d-ee93-48e2-bc31-0f26342d2e5c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " and ",
 Cell[BoxData[
  ButtonBox["+",
   BaseStyle->"Link",
   ButtonData->"Plus"]], "InlineCode",ExpressionUUID->
  "b0bfb7b7-9093-41e3-8e06-044c39602f49"],
 " to make a list of numbers from 10 to 20, inclusive.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"425fff1c-fa6a-4bc0-928b-4e7bd8b7419d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15", ",", 
         "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "77f9756a-66c6-4066-b511-8d236dbe204b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"10", ",", "11", ",", "12", ",", "13", ",", "14", ",", 
             "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9afbf14b-d843-41dc-96c7-6f6306f691c4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a combined list of the first 5 squares and cubes (numbers raised to \
the power 3), sorted into order.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"p:18",ExpressionUUID->"8f933998-3669-4b59-af37-a9bd4ae66364"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "4", ",", "8", ",", "9", ",", "16", ",", "25", 
         ",", "27", ",", "64", ",", "125"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"e1565b1a-7299-4e56-9c9d-eb0179003f6e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "1", ",", "4", ",", "8", ",", "9", ",", "16", 
             ",", "25", ",", "27", ",", "64", ",", "125"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"81c55ba5-4a73-4425-a18f-76d385ce80d6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the number of digits in 2^128.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a0121b2f-0daa-40e0-86f2-1a1808c2ea0c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "39"], "ExerciseOutput",ExpressionUUID->
       "bd2cede6-9ea1-4cc6-b22b-b903b2a29791"],
      Apply[TextCell, 
       Cell[
        BoxData["39"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1dbeaf1a-20cf-413d-8315-c2af91f36672"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the first digit of 2^32.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"6d9828e9-91bf-434a-92a7-25b5b56c1581"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "4"], "ExerciseOutput",ExpressionUUID->
       "61f620d8-8d2f-4945-bf8f-14a1adf1bb08"],
      Apply[TextCell, 
       Cell[
        BoxData["4"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"28915d96-d60b-4af9-9049-b89f48b6612a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the first 10 digits in 2^100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e49c543c-74c7-4d99-9abc-7d72dd6dba54"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "2", ",", "6", ",", "7", ",", "6", ",", "5", ",", "0", ",", 
         "6", ",", "0", ",", "0"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "e68a7c27-811a-4cfc-a99c-3f3c7edeb61e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "2", ",", "6", ",", "7", ",", "6", ",", "5", ",",
              "0", ",", "6", ",", "0", ",", "0"}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a9f9ba45-a634-4983-8ab2-1c8cbe87acca"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the largest digit that appears in 2^20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7020654d-63f4-4b2e-81bd-0043933cb012"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "8"], "ExerciseOutput",ExpressionUUID->
       "c5656702-16dd-46ab-befa-7ddf117856a4"],
      Apply[TextCell, 
       Cell[
        BoxData["8"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f0b3444d-d132-4cf6-a6ae-99d8350eddf1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find how many zeros appear in the digits of 2^1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7a25fab5-31a7-479c-8887-1620e58361af"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "28"], "ExerciseOutput",ExpressionUUID->
       "42c560f0-3c7a-4725-b7ba-f0fc46167687"],
      Apply[TextCell, 
       Cell[
        BoxData["28"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f41894a1-d267-4537-8b5c-f08ccd0b6203"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Part",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Sort",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["IntegerDigits",
  BaseStyle->"Link"],
 " to find the ",
 "second-smallest digit",
 " in 2^20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4d0241e8-351f-4dfc-bb3b-75fb102103d1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "1"], "ExerciseOutput",ExpressionUUID->
       "5df325a1-6fb0-46e1-a9e6-6edd24955b5a"],
      Apply[TextCell, 
       Cell[
        BoxData["1"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9d340b91-84d3-40a5-99ff-b097cdfb0832"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the sequence of digits that appear in 2^128.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2c3dd4d9-22e7-4b30-abfd-31ff4d52200c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.019444444444444445`], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdkjsOwjAQRC0qSgqKFBSAECCEEP8/iYEbcAQkaq7gI3MEQJkp/CxFT7Oe
3XGc9J7vx6sRQhj9nj/r9alqNqMKYiuiHvK6fW2xKxbY72AOfX3oAepDzBvj
PBP4p8ibIXcu+j0WyF+ifwX/Gv4N/Fvoneh72GPeAfOOotcJ/Wf0X5BXiv6u
FfpjnpesfT9X52vf2vNuuU7WPs9d1H+RrIv4BSHkI7k=
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{},
        PlotRange->{{0., 39.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "53631cba-0777-4cd9-830d-5f915d3200e8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{
              RGBColor[0.368417, 0.506779, 0.709798], 
              PointSize[0.019444444444444445`], 
              AbsoluteThickness[1.6], 
              LineBox[CompressedData["
1:eJxdkjsOwjAQRC0qSgqKFBSAECCEEP8/iYEbcAQkaq7gI3MEQJkp/CxFT7Oe
3XGc9J7vx6sRQhj9nj/r9alqNqMKYiuiHvK6fW2xKxbY72AOfX3oAepDzBvj
PBP4p8ibIXcu+j0WyF+ifwX/Gv4N/Fvoneh72GPeAfOOotcJ/Wf0X5BXiv6u
FfpjnpesfT9X52vf2vNuuU7WPs9d1H+RrIv4BSHkI7k=
               "]]}}}, {}}, 
          AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {True, True}, AxesLabel -> {None, None}, 
          AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
          Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], Method -> {}, 
          PlotRange -> {{0., 39.}, {0, 9.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7ad55a73-6b12-4d14-a9de-9ff0997ad9ba"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Take",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Drop",
  BaseStyle->"Link"],
 " to get the sequence 11 through 20 from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"CodeLink"], "[", "100", "]"}]], "InlineCode",ExpressionUUID->
  "47051841-d2c1-4211-a80f-3975111ffa0d"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e81e00b5-14bc-4a70-97a6-9a7b3ea1207a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "11", ",", "12", ",", "13", ",", "14", ",", "15", ",", "16", ",", 
         "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"84eb11a7-1ba9-4df4-8252-69d71bffd986"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"11", ",", "12", ",", "13", ",", "14", ",", "15", ",", 
             "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e13f3be6-b433-4c14-a3fd-2cd81ac2e9eb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 10 multiples of 3.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4dbe5cab-a5a7-470b-806b-30d0023be4be"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "3", ",", "6", ",", "9", ",", "12", ",", "15", ",", "18", ",", "21", 
         ",", "24", ",", "27", ",", "30"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"fccc3401-bb5b-4860-a3ea-7d34cd18bdd7"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"3", ",", "6", ",", "9", ",", "12", ",", "15", ",", "18", 
             ",", "21", ",", "24", ",", "27", ",", "30"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a66b7c74-3631-44c7-bdc6-6f84c8ec4b35"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the first 10 squares using only ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Times",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"81788da8-a3fb-4e7c-a315-3b7f1574badc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", 
         ",", "64", ",", "81", ",", "100"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"c2d31703-f559-4500-9d95-bc39903a369a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", 
             ",", "49", ",", "64", ",", "81", ",", "100"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7e4de56e-b65e-4807-ab00-811410f20d9e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the last digit of 2^37.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"89c95fb3-75c2-4601-9b8a-53a61a8796a6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "2"], "ExerciseOutput",ExpressionUUID->
       "ebaa4dbd-e608-4094-b0b0-541b275240d7"],
      Apply[TextCell, 
       Cell[
        BoxData["2"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d7317e26-cddc-4904-9120-d94a1f1e1f43"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the second-to-last digit of 2^32.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"fb1724e2-aa6f-4041-abdb-515268703a9e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "9"], "ExerciseOutput",ExpressionUUID->
       "683496c2-0ef4-4bd8-ba1b-950a4e329879"],
      Apply[TextCell, 
       Cell[
        BoxData["9"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e3311919-d0c6-4582-99ce-85da75032d8e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the sum of all the digits of 3^126.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"64e35bca-65e8-4337-82f9-b1c343d1eeef"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "234"], "ExerciseOutput",ExpressionUUID->
       "ccb2ef88-11ee-4cbf-b2e8-78f9a716398f"],
      Apply[TextCell, 
       Cell[
        BoxData["234"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f7899a8a-6136-4d28-bcef-6021d487d9b5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a pie chart of the sequence of digits that appear in 2^32.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e8e52abc-1163-4f38-a7bb-99187a90e93b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {}, 
         DynamicModuleBox[{DynamicChart`click$34454$34514 = False, 
          DynamicChart`click$34457$34514 = False, 
          DynamicChart`click$34460$34514 = False, 
          DynamicChart`click$34463$34514 = False, 
          DynamicChart`click$34466$34514 = False, 
          DynamicChart`click$34469$34514 = False, 
          DynamicChart`click$34472$34514 = False, 
          DynamicChart`click$34475$34514 = False, 
          DynamicChart`click$34478$34514 = False, 
          DynamicChart`click$34481$34514 = False}, {
           {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
            0.5]}], {{{}, {
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.708269528956718, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-44.72356731215852, \
-1.5857864376269042`}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34454$34514, 
                    FEPrivate`Not[DynamicChart`click$34454$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34454$34514, {{{1., 0}, {
                    0, 1.}}, {-0.19532411114201734`, 0.04299408804220486}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34454$34514}]]}, 
               {RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.491607966640181, 
                    2.708269528956718}]},
                    
                    ImageSizeCache->{{31.45854614921505, 
                    121.41421356237309`}, {-62.51093822097455, \
-1.5857864376269042`}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34457$34514, 
                    FEPrivate`Not[DynamicChart`click$34457$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34457$34514, {{{1., 0}, {
                    0, 1.}}, {-0.17137143523351786`, 
                    0.10311077143540433`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], 
                  TrackedSymbols :> {DynamicChart`click$34457$34514}]]}, 
               {RGBColor[0.998096, 0.5661274666666667, 0.2140296888888889], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.5166309362157622`, 
                    2.491607966640181}]},
                    
                    ImageSizeCache->{{42.1608521298851, 
                    126.61154878657318`}, {-100.41421356237309`, \
-1.5857864376269104`}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34460$34514, 
                    FEPrivate`Not[DynamicChart`click$34460$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34460$34514, {{{1., 0}, {
                    0, 1.}}, {-0.08397782031205293, 0.1815150839341914}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34460$34514}]]}, 
               {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0833078115826873`, 
                    1.5166309362157622`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    166.38142386955298`}, {-100.273421292081, \
-1.5857864376268935`}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34463$34514, 
                    FEPrivate`Not[DynamicChart`click$34463$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34463$34514, {{{1., 0}, {0, 1.}}, {
                    0.053505667705844154`, 0.19270999850384463`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34463$34514}]]}, 
               {RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.10833078115826877`, 
                    1.0833078115826873`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 216.85145744919163`},
                     {-89.23136982919131, -1.5857864376268935`}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34466$34514, 
                    FEPrivate`Not[DynamicChart`click$34466$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34466$34514, {{{1., 0}, {0, 1.}}, {
                    0.16553779963137813`, 0.11223741307247648`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34466$34514}]]}, 
               {RGBColor[
                0.7598801777777778, 0.4773333333333333, 0.3161064888888889], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.5416539057913434, 
                    0.10833078115826877`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-14.793639331071518`, 
                    47.90738385136717}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34469$34514, 
                    FEPrivate`Not[DynamicChart`click$34469$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34469$34514, {{{1., 0}, {0, 1.}}, {
                    0.19532411114201736`, -0.04299408804220479}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34469$34514}]]}, 
               {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.2999693738992244`, -0.5416539057913434}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    203.67250247446168`}, {-4.4142135623731065`, 
                    90.9150128442185}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34472$34514, 
                    FEPrivate`Not[DynamicChart`click$34472$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34472$34514, {{{1., 0}, {0, 1.}}, {
                    0.1210348430387531, -0.15921861314112873`}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34472$34514}]]}, 
               {RGBColor[
                0.6558762666666667, 0.4926222222222222, 0.7345293333333333], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.5166309362157628`, -1.2999693738992244`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    147.09693406117833`}, {-4.4142135623731065`, 
                    94.273421292081}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34475$34514, 
                    FEPrivate`Not[DynamicChart`click$34475$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34475$34514, {{{1., 0}, {0, 1.}}, {
                    0.032356399310552925`, -0.19736530450830525`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34475$34514}]]}, 
               {RGBColor[
                0.5775381333333334, 0.5239111111111111, 0.7827298666666667], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.4916079666401805`, -1.5166309362157628`}]},
                    
                    ImageSizeCache->{{42.16085212988513, 
                    126.61154878657312`}, {-4.414213562373092, 
                    94.41421356237309}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34478$34514, 
                    FEPrivate`Not[DynamicChart`click$34478$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34478$34514, {{{1., 0}, {
                    0, 1.}}, {-0.08397782031205293, -0.1815150839341914}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34478$34514}]]}, 
               {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
                Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.4916079666401805`}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.4142135623731065`, 
                    56.51093822097458}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34481$34514, 
                    FEPrivate`Not[DynamicChart`click$34481$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34481$34514, {{{1., 0}, {
                    0, 1.}}, {-0.18953063423656047`, -0.06386030602719604}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$34481$34514}]]}}}, {}}, {}}, {{{
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 4]& ,
                   TagBoxNote->"4"],
                  StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34454$34514, 
                    FEPrivate`Not[DynamicChart`click$34454$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34454$34514, {{{1., 0}, {
                   0, 1.}}, {-0.19532411114201734`, 0.04299408804220486}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34454$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 2]& ,
                   TagBoxNote->"2"],
                  StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34457$34514, 
                    FEPrivate`Not[DynamicChart`click$34457$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34457$34514, {{{1., 0}, {
                   0, 1.}}, {-0.17137143523351786`, 0.10311077143540433`}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34457$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 9]& ,
                   TagBoxNote->"9"],
                  StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34460$34514, 
                    FEPrivate`Not[DynamicChart`click$34460$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34460$34514, {{{1., 0}, {
                   0, 1.}}, {-0.08397782031205293, 0.1815150839341914}}, {{1, 
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34460$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 4]& ,
                   TagBoxNote->"4"],
                  StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34463$34514, 
                    FEPrivate`Not[DynamicChart`click$34463$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34463$34514, {{{1., 0}, {0, 1.}}, {
                  0.053505667705844154`, 0.19270999850384463`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34463$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 9]& ,
                   TagBoxNote->"9"],
                  StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34466$34514, 
                    FEPrivate`Not[DynamicChart`click$34466$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34466$34514, {{{1., 0}, {0, 1.}}, {
                  0.16553779963137813`, 0.11223741307247648`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34466$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 6]& ,
                   TagBoxNote->"6"],
                  StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34469$34514, 
                    FEPrivate`Not[DynamicChart`click$34469$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34469$34514, {{{1., 0}, {0, 1.}}, {
                  0.19532411114201736`, -0.04299408804220479}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34469$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 7]& ,
                   TagBoxNote->"7"],
                  StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34472$34514, 
                    FEPrivate`Not[DynamicChart`click$34472$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34472$34514, {{{1., 0}, {0, 1.}}, {
                  0.1210348430387531, -0.15921861314112873`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34472$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 2]& ,
                   TagBoxNote->"2"],
                  StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34475$34514, 
                    FEPrivate`Not[DynamicChart`click$34475$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34475$34514, {{{1., 0}, {0, 1.}}, {
                  0.032356399310552925`, -0.19736530450830525`}}, {{1, 0}, {0,
                  1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34475$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 9]& ,
                   TagBoxNote->"9"],
                  StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34478$34514, 
                    FEPrivate`Not[DynamicChart`click$34478$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34478$34514, {{{1., 0}, {
                   0, 1.}}, {-0.08397782031205293, -0.1815150839341914}}, {{1,
                  0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34478$34514}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 6]& ,
                   TagBoxNote->"6"],
                  StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34481$34514, 
                    FEPrivate`Not[DynamicChart`click$34481$34514]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34481$34514, {{{1., 0}, {
                   0, 1.}}, {-0.18953063423656047`, -0.06386030602719604}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {
                 DynamicChart`click$34481$34514}]]}, {}}, {}}},
          DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
        ContentSelectable->False,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        LabelStyle->{
          GrayLevel[0], FontFamily -> "Arial"},
        PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
        PlotRangePadding->Scaled[0.02]]], "ExerciseOutput",ExpressionUUID->
       "11f214d1-e5c7-4c52-9f82-0970f3dd77b6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{
            DynamicChart`click$34454$34514 = False, 
             DynamicChart`click$34457$34514 = False, 
             DynamicChart`click$34460$34514 = False, 
             DynamicChart`click$34463$34514 = False, 
             DynamicChart`click$34466$34514 = False, 
             DynamicChart`click$34469$34514 = False, 
             DynamicChart`click$34472$34514 = False, 
             DynamicChart`click$34475$34514 = False, 
             DynamicChart`click$34478$34514 = False, 
             DynamicChart`click$34481$34514 = False}, {{
              RGBColor[0.5, 0.5, 1.], 
              EdgeForm[{
                GrayLevel[0], 
                Opacity[0.5]}], {{{}, {{
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.708269528956718, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-44.72356731215852, \
-1.5857864376269042`}}], StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34454$34514, 
                    FEPrivate`Not[DynamicChart`click$34454$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34454$34514, {{{1., 0}, {
                    0, 1.}}, {-0.19532411114201734`, 0.04299408804220486}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34454$34514}]]}, {
                  RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.491607966640181, 
                    2.708269528956718}]}, 
                    ImageSizeCache -> {{31.45854614921505, 
                    121.41421356237309`}, {-62.51093822097455, \
-1.5857864376269042`}}], StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34457$34514, 
                    FEPrivate`Not[DynamicChart`click$34457$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34457$34514, {{{1., 0}, {
                    0, 1.}}, {-0.17137143523351786`, 
                    0.10311077143540433`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34457$34514}]]}, {
                  RGBColor[0.998096, 0.5661274666666667, 0.2140296888888889], 
                  
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.5166309362157622`, 
                    2.491607966640181}]}, 
                    ImageSizeCache -> {{42.1608521298851, 
                    126.61154878657318`}, {-100.41421356237309`, \
-1.5857864376269104`}}], StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34460$34514, 
                    FEPrivate`Not[DynamicChart`click$34460$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34460$34514, {{{1., 0}, {
                    0, 1.}}, {-0.08397782031205293, 0.1815150839341914}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34460$34514}]]}, {
                  RGBColor[0.928, 0.5210666666666667, 0.2], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0833078115826873`, 
                    1.5166309362157622`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    166.38142386955298`}, {-100.273421292081, \
-1.5857864376268935`}}], StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34463$34514, 
                    FEPrivate`Not[DynamicChart`click$34463$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34463$34514, {{{1., 0}, {0, 1.}}, {
                    0.053505667705844154`, 0.19270999850384463`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34463$34514}]]}, {
                  RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.10833078115826877`, 
                    1.0833078115826873`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    216.85145744919163`}, {-89.23136982919131, \
-1.5857864376268935`}}], StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34466$34514, 
                    FEPrivate`Not[DynamicChart`click$34466$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34466$34514, {{{1., 0}, {0, 1.}}, {
                    0.16553779963137813`, 0.11223741307247648`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34466$34514}]]}, {
                  RGBColor[
                  0.7598801777777778, 0.4773333333333333, 0.3161064888888889], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.5416539057913434, 
                    0.10833078115826877`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-14.793639331071518`, 
                    47.90738385136717}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34469$34514, 
                    FEPrivate`Not[DynamicChart`click$34469$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34469$34514, {{{1., 0}, {0, 1.}}, {
                    0.19532411114201736`, -0.04299408804220479}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34469$34514}]]}, {
                  RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.2999693738992244`, -0.5416539057913434}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    203.67250247446168`}, {-4.4142135623731065`, 
                    90.91501284421851}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34472$34514, 
                    FEPrivate`Not[DynamicChart`click$34472$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34472$34514, {{{1., 0}, {0, 1.}}, {
                    0.1210348430387531, -0.15921861314112873`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34472$34514}]]}, {
                  RGBColor[
                  0.6558762666666667, 0.4926222222222222, 0.7345293333333333], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.5166309362157628`, -1.2999693738992244`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    147.09693406117833`}, {-4.4142135623731065`, 
                    94.273421292081}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34475$34514, 
                    FEPrivate`Not[DynamicChart`click$34475$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34475$34514, {{{1., 0}, {0, 1.}}, {
                    0.032356399310552925`, -0.19736530450830525`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34475$34514}]]}, {
                  RGBColor[
                  0.5775381333333334, 0.5239111111111111, 0.7827298666666667], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.4916079666401805`, -1.5166309362157628`}]}, 
                    ImageSizeCache -> {{42.16085212988513, 
                    126.61154878657312`}, {-4.414213562373092, 
                    94.41421356237309}}], StatusArea[#, 9]& , TagBoxNote -> 
                    "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34478$34514, 
                    FEPrivate`Not[DynamicChart`click$34478$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34478$34514, {{{1., 0}, {
                    0, 1.}}, {-0.08397782031205293, -0.1815150839341914}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34478$34514}]]}, {
                  RGBColor[0.4992, 0.5552, 0.8309304], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.4916079666401805`}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.4142135623731065`, 
                    56.51093822097458}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34481$34514, 
                    FEPrivate`Not[DynamicChart`click$34481$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34481$34514, {{{1., 0}, {
                    0, 1.}}, {-0.18953063423656047`, -0.06386030602719604}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34481$34514}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34454$34514, 
                    FEPrivate`Not[DynamicChart`click$34454$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34454$34514, {{{1., 0}, {
                    0, 1.}}, {-0.19532411114201734`, 0.04299408804220486}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34454$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34457$34514, 
                    FEPrivate`Not[DynamicChart`click$34457$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34457$34514, {{{1., 0}, {
                    0, 1.}}, {-0.17137143523351786`, 
                    0.10311077143540433`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34457$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34460$34514, 
                    FEPrivate`Not[DynamicChart`click$34460$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34460$34514, {{{1., 0}, {
                    0, 1.}}, {-0.08397782031205293, 0.1815150839341914}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34460$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34463$34514, 
                    FEPrivate`Not[DynamicChart`click$34463$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34463$34514, {{{1., 0}, {0, 1.}}, {
                    0.053505667705844154`, 0.19270999850384463`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34463$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34466$34514, 
                    FEPrivate`Not[DynamicChart`click$34466$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34466$34514, {{{1., 0}, {0, 1.}}, {
                    0.16553779963137813`, 0.11223741307247648`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34466$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34469$34514, 
                    FEPrivate`Not[DynamicChart`click$34469$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34469$34514, {{{1., 0}, {0, 1.}}, {
                    0.19532411114201736`, -0.04299408804220479}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34469$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34472$34514, 
                    FEPrivate`Not[DynamicChart`click$34472$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34472$34514, {{{1., 0}, {0, 1.}}, {
                    0.1210348430387531, -0.15921861314112873`}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34472$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34475$34514, 
                    FEPrivate`Not[DynamicChart`click$34475$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34475$34514, {{{1., 0}, {0, 1.}}, {
                    0.032356399310552925`, -0.19736530450830525`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34475$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34478$34514, 
                    FEPrivate`Not[DynamicChart`click$34478$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34478$34514, {{{1., 0}, {
                    0, 1.}}, {-0.08397782031205293, -0.1815150839341914}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34478$34514}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34481$34514, 
                    FEPrivate`Not[DynamicChart`click$34481$34514]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34481$34514, {{{1., 0}, {
                    0, 1.}}, {-0.18953063423656047`, -0.06386030602719604}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$34481$34514}]]}, {}}, {}}}, 
            DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}}, 
          ContentSelectable -> False, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], LabelStyle -> {
            GrayLevel[0], FontFamily -> "Arial"}, 
          PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
          Scaled[0.02]]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bd964426-510a-4287-b094-95c1bba765bb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of pie charts for the sequence of digits in 2^20, 2^40, 2^60.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"46479eef-5d7e-42ae-8139-47c2090d5567"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{DynamicChart`click$34807$35044 = False, 
            DynamicChart`click$34810$35044 = False, 
            DynamicChart`click$34813$35044 = False, 
            DynamicChart`click$34816$35044 = False, 
            DynamicChart`click$34819$35044 = False, 
            DynamicChart`click$34822$35044 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, {
                 {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {2.938909256584, 3.141592653589793}]},
                    
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-23.738871490884467`, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34807$35044, 
                    FEPrivate`Not[DynamicChart`click$34807$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34807$35044, {{{1., 0}, {
                    0, 1.}}, {-0.19897386467837905`, 0.02023366439748646}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34807$35044}]]}, {}, 
                 {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.1281756685608277`, 
                    2.938909256584}]},
                    
                    ImageSizeCache->{{24.550912077387434`, 
                    121.4142135623731}, {-85.88406228186918, \
-1.585786437626897}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34810$35044, 
                    FEPrivate`Not[DynamicChart`click$34810$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34810$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145526`, 
                    0.11425364301895846`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34810$35044}]]}, 
                 {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5067084925144831, 
                    2.1281756685608277`}]},
                    
                    ImageSizeCache->{{67.8052414462385, 
                    205.35148871225294`}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34813$35044, 
                    FEPrivate`Not[DynamicChart`click$34813$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34813$35044, {{{1., 0}, {0, 1.}}, {
                    0.05013050645174408, 0.1936154237732409}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34813$35044}]]}, 
                 {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.5067084925144822, 
                    0.5067084925144831}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-51.00320196535692, 
                    45.00320196535684}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34816$35044, 
                    FEPrivate`Not[DynamicChart`click$34816$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34816$35044, {{{1., 0}, {0, 1.}}, {
                    0.2, 8.881784197001253*^-17}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34816$35044}]]}, 
                 {RGBColor[0.6167072, 0.5082666666666666, 0.7586295999999999],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.9254922715550338`, -0.5067084925144822}]},
                    
                    ImageSizeCache->{{85.24448216452421, 
                    205.351488712253}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34819$35044, 
                    FEPrivate`Not[DynamicChart`click$34819$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34819$35044, {{{1., 0}, {0, 1.}}, {
                    0.06946105056896418, -0.18755042642941605`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34819$35044}]]}, 
                 {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0],
                   Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.9254922715550338`}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    88.43841824849285}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34822$35044, 
                    FEPrivate`Not[DynamicChart`click$34822$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34822$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145524`, -0.11425364301895853`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34822$35044}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34807$35044, 
                    FEPrivate`Not[DynamicChart`click$34807$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34807$35044, {{{1., 0}, {
                    0, 1.}}, {-0.19897386467837905`, 0.02023366439748646}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34807$35044}]], {}, 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34810$35044, 
                    FEPrivate`Not[DynamicChart`click$34810$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34810$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145526`, 
                    0.11425364301895846`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34810$35044}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34813$35044, 
                    FEPrivate`Not[DynamicChart`click$34813$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34813$35044, {{{1., 0}, {0, 1.}}, {
                    0.05013050645174408, 0.1936154237732409}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34813$35044}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34816$35044, 
                    FEPrivate`Not[DynamicChart`click$34816$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34816$35044, {{{1., 0}, {0, 1.}}, {0.2,
                     8.881784197001253*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34816$35044}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34819$35044, 
                    FEPrivate`Not[DynamicChart`click$34819$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34819$35044, {{{1., 0}, {0, 1.}}, {
                    0.06946105056896418, -0.18755042642941605`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34819$35044}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34822$35044, 
                    FEPrivate`Not[DynamicChart`click$34822$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34822$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145524`, -0.11425364301895853`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$34822$35044}]]}, {}}, {}}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
          PlotRangePadding->Scaled[0.02]], ",", 
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{DynamicChart`click$34863$35045 = False, 
            DynamicChart`click$34866$35045 = False, 
            DynamicChart`click$34869$35045 = False, 
            DynamicChart`click$34872$35045 = False, 
            DynamicChart`click$34875$35045 = False, 
            DynamicChart`click$34878$35045 = False, 
            DynamicChart`click$34881$35045 = False, 
            DynamicChart`click$34884$35045 = False, 
            DynamicChart`click$34887$35045 = False, 
            DynamicChart`click$34890$35045 = False, 
            DynamicChart`click$34893$35045 = False, 
            DynamicChart`click$34896$35045 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, {
                 {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.038589615767177, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-14.28502928755972, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34863$35045, 
                    FEPrivate`Not[DynamicChart`click$34863$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34863$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19973481797696613`, 
                    0.010295750954069347`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34863$35045}]]}, {}, 
                 {RGBColor[0.994288, 0.6103824, 0.24208906666666669`], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.1115622753636316`, 
                    3.038589615767177}]},
                    
                    ImageSizeCache->{{23.094598378626355`, 
                    121.4142135623731}, {-86.71641785770099, \
-1.5857864376269113`}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34866$35045, 
                    FEPrivate`Not[DynamicChart`click$34866$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34866$35045, {{{1., 0}, {
                    0, 1.}}, {-0.16875511196463713`, 
                    0.10733923879832011`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34866$35045}]]}, 
                 {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
                  0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.1845349349600858`, 
                    2.1115622753636316`}]},
                    
                    ImageSizeCache->{{69.16567749268314, 
                    157.58009135135086`}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34869$35045, 
                    FEPrivate`Not[DynamicChart`click$34869$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34869$35045, {{{1., 0}, {
                    0, 1.}}, {-0.015435092425329236`, 
                    0.19940350528970535`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34869$35045}]]}, 
                 {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.6695197458470052, 
                    1.1845349349600858`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    196.6897149937373}, {-93.34131451451661, \
-1.5857864376268935`}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34872$35045, 
                    FEPrivate`Not[DynamicChart`click$34872$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34872$35045, {{{1., 0}, {0, 1.}}, {
                    0.12004285610967365`, 0.15996784894794389`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34872$35045}]]}, 
                 {RGBColor[0.8560000000000001, 0.4981333333333333, 0.2], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5665167080243889, 
                    0.6695197458470052}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    202.4166673053989}, {-63.99272381780572, \
-1.5857864376268935`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34875$35045, 
                    FEPrivate`Not[DynamicChart`click$34875$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34875$35045, {{{1., 0}, {0, 1.}}, {
                    0.1630056675033623, 0.11588421964091276`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34875$35045}]]}, 
                 {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.4635136702017726, 
                    0.5665167080243889}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    207.28497345633747`}, {-55.93704818556675, \
-1.5857864376268935`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34878$35045, 
                    FEPrivate`Not[DynamicChart`click$34878$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34878$35045, {{{1., 0}, {0, 1.}}, {
                    0.17405704820603107`, 0.09850961359077287}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34878$35045}]]}, 
                 {RGBColor[0.7478202666666667, 0.4784, 0.3741597333333332], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.1545045567339245, 
                    0.4635136702017726}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-47.335217688944034`, 
                    13.187708925963058`}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34881$35045, 
                    FEPrivate`Not[DynamicChart`click$34881$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34881$35045, {{{1., 0}, {0, 1.}}, {
                    0.19761757921821543`, 0.030778115340812318`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34881$35045}]]}, 
                 {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.36051063237915715`, -0.1545045567339245}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    216.2706515871165}, {-4.414213562373114, 
                    32.27841387108625}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34884$35045, 
                    FEPrivate`Not[DynamicChart`click$34884$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34884$35045, {{{1., 0}, {0, 1.}}, {
                    0.19340554495826406`, -0.050934224048245824`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34884$35045}]]}, 
                 {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[
                  0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.08153189713747, -0.36051063237915715`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    211.24302819026047`}, {-4.4142135623731065`, 
                    83.15137820162568}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34887$35045, 
                    FEPrivate`Not[DynamicChart`click$34887$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34887$35045, {{{1., 0}, {0, 1.}}, {
                    0.15022638617410394`, -0.13203042413424643`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34887$35045}]]}, 
                 {RGBColor[0.6167072, 0.5082666666666666, 0.7586295999999999],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.8025531618957826`, -1.08153189713747}]},
                    
                    ImageSizeCache->{{96.53576319297456, 
                    166.53198089299582`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34890$35045, 
                    FEPrivate`Not[DynamicChart`click$34890$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34890$35045, {{{1., 0}, {0, 1.}}, {
                    0.025679671029310198`, -0.1983445348272203}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34890$35045}]]}, 
                 {RGBColor[0.5579536, 0.5317333333333334, 0.7947799999999999],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.523574426654096, -1.8025531618957826`}]},
                    
                    ImageSizeCache->{{40.34306603601303, 
                    121.41421356237309`}, {-4.414213562373092, 
                    91.84759343760982}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34893$35045, 
                    FEPrivate`Not[DynamicChart`click$34893$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34893$35045, {{{1., 0}, {
                    0, 1.}}, {-0.11164874440537292`, -0.16593540271052382`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34893$35045}]]}, 
                 {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0],
                   Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.523574426654096}]},
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373099, 
                    54.03863899001122}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34896$35045, 
                    FEPrivate`Not[DynamicChart`click$34896$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34896$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19052707616067652`, -0.06082296646550361}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34896$35045}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34863$35045, 
                    FEPrivate`Not[DynamicChart`click$34863$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34863$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19973481797696613`, 
                    0.010295750954069347`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {
                   DynamicChart`click$34863$35045}]], {}, 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34866$35045, 
                    FEPrivate`Not[DynamicChart`click$34866$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34866$35045, {{{1., 0}, {
                    0, 1.}}, {-0.16875511196463713`, 
                    0.10733923879832011`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34866$35045}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34869$35045, 
                    FEPrivate`Not[DynamicChart`click$34869$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34869$35045, {{{1., 0}, {
                    0, 1.}}, {-0.015435092425329236`, 
                    0.19940350528970535`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34869$35045}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34872$35045, 
                    FEPrivate`Not[DynamicChart`click$34872$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34872$35045, {{{1., 0}, {0, 1.}}, {
                    0.12004285610967365`, 0.15996784894794389`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34872$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34875$35045, 
                    FEPrivate`Not[DynamicChart`click$34875$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34875$35045, {{{1., 0}, {0, 1.}}, {
                    0.1630056675033623, 0.11588421964091276`}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34875$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34878$35045, 
                    FEPrivate`Not[DynamicChart`click$34878$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34878$35045, {{{1., 0}, {0, 1.}}, {
                    0.17405704820603107`, 0.09850961359077287}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34878$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34881$35045, 
                    FEPrivate`Not[DynamicChart`click$34881$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34881$35045, {{{1., 0}, {0, 1.}}, {
                    0.19761757921821543`, 0.030778115340812318`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34881$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34884$35045, 
                    FEPrivate`Not[DynamicChart`click$34884$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34884$35045, {{{1., 0}, {0, 1.}}, {
                    0.19340554495826406`, -0.050934224048245824`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34884$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34887$35045, 
                    FEPrivate`Not[DynamicChart`click$34887$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34887$35045, {{{1., 0}, {0, 1.}}, {
                    0.15022638617410394`, -0.13203042413424643`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34887$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34890$35045, 
                    FEPrivate`Not[DynamicChart`click$34890$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34890$35045, {{{1., 0}, {0, 1.}}, {
                    0.025679671029310198`, -0.1983445348272203}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34890$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34893$35045, 
                    FEPrivate`Not[DynamicChart`click$34893$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34893$35045, {{{1., 0}, {
                    0, 1.}}, {-0.11164874440537292`, -0.16593540271052382`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34893$35045}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34896$35045, 
                    FEPrivate`Not[DynamicChart`click$34896$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34896$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19052707616067652`, -0.06082296646550361}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$34896$35045}]]}, {}}, {}}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
          PlotRangePadding->Scaled[0.02]], ",", 
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{DynamicChart`click$34949$35046 = False, 
            DynamicChart`click$34952$35046 = False, 
            DynamicChart`click$34955$35046 = False, 
            DynamicChart`click$34958$35046 = False, 
            DynamicChart`click$34961$35046 = False, 
            DynamicChart`click$34964$35046 = False, 
            DynamicChart`click$34967$35046 = False, 
            DynamicChart`click$34970$35046 = False, 
            DynamicChart`click$34973$35046 = False, 
            DynamicChart`click$34976$35046 = False, 
            DynamicChart`click$34979$35046 = False, 
            DynamicChart`click$34982$35046 = False, 
            DynamicChart`click$34985$35046 = False, 
            DynamicChart`click$34988$35046 = False, 
            DynamicChart`click$34991$35046 = False, 
            DynamicChart`click$34994$35046 = False, 
            DynamicChart`click$34997$35046 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, {
                 {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0649684425266273`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-11.762941834676706`, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34949$35046, 
                    FEPrivate`Not[DynamicChart`click$34949$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34949$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19985323621016202`, 
                    0.007660546738007111}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34949$35046}]]}, 
                 {RGBColor[0.986672, 0.6988922666666667, 0.2982078222222222], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.988344231463462, 
                    3.0649684425266273`}]},
                    
                    ImageSizeCache->{{22.86746952398782, 
                    121.41421356237309`}, {-19.068544847385045`, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34952$35046, 
                    FEPrivate`Not[DynamicChart`click$34952$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34952$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19868041795193503`, 
                    0.022936685079680164`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34952$35046}]]}, 
                 {RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.6052231761476334`, 
                    2.988344231463462}]},
                    
                    ImageSizeCache->{{23.71086575471345, 
                    121.41421356237309`}, {-53.47200678929569, \
-1.5857864376269042`}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34955$35046, 
                    FEPrivate`Not[DynamicChart`click$34955$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34955$35046, {{{1., 0}, {
                    0, 1.}}, {-0.18822800959591232`, 0.06760337568170055}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34955$35046}]]}, 
                 {RGBColor[0.994288, 0.6103824, 0.24208906666666669`], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.451974754021302, 
                    2.6052231761476334`}]},
                    
                    ImageSizeCache->{{36.0671041668556, 
                    121.41421356237309`}, {-65.49348802572283, \
-1.5857864376269033`}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34958$35046, 
                    FEPrivate`Not[DynamicChart`click$34958$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34958$35046, {{{1., 0}, {
                    0, 1.}}, {-0.16358587215334358`, 
                    0.11506373204372407`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34958$35046}]]}, 
                 {RGBColor[0.998096, 0.5661274666666667, 0.2140296888888889], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.7623568544528108`, 
                    2.451974754021302}]},
                    
                    ImageSizeCache->{{44.52282517472038, 
                    121.41421356237309`}, {-98.65821228207116, \
-1.5857864376269104`}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34961$35046, 
                    FEPrivate`Not[DynamicChart`click$34961$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34961$35046, {{{1., 0}, {
                    0, 1.}}, {-0.10220373588942211`, 
                    0.17191392139744022`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34961$35046}]]}, 
                 {RGBColor[0.976, 0.5363555555555556, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.6091084323264795`, 
                    1.7623568544528108`}]},
                    
                    ImageSizeCache->{{100.30823995781874`, 
                    121.4142135623731}, {-100.34376694325086`, \
-1.5857864376269104`}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34964$35046, 
                    FEPrivate`Not[DynamicChart`click$34964$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34964$35046, {{{1., 0}, {
                    0, 1.}}, {-0.02293668507968008, 0.19868041795193503`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34964$35046}]]}, 
                 {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.5324842212633136`, 
                    1.6091084323264795`}]},
                    
                    ImageSizeCache->{{114.90872400338351`, 
                    125.0912759966165}, {-100.41421356237309`, \
-1.5857864376269104`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34967$35046, 
                    FEPrivate`Not[DynamicChart`click$34967$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34967$35046, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34967$35046}]]}, 
                 {RGBColor[0.8800000000000001, 0.5057777777777778, 0.2], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.1493631659474852`, 
                    1.5324842212633136`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    160.68480273082173`}, {-100.34376694325087`, \
-1.5857864376268935`}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34970$35046, 
                    FEPrivate`Not[DynamicChart`click$34970$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34970$35046, {{{1., 0}, {0, 1.}}, {
                    0.04557070178062755, 0.1947390847755558}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34970$35046}]]}, {}, 
                 {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.8428663216948227, 
                    1.1493631659474852`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    185.28548077826736`}, {-92.01456074412191, \
-1.5857864376268935`}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34973$35046, 
                    FEPrivate`Not[DynamicChart`click$34973$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34973$35046, {{{1., 0}, {0, 1.}}, {
                    0.10871351000024423`, 0.16787308522639}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34973$35046}]]}, 
                 {RGBColor[
                  0.7598801777777778, 0.4773333333333333, 0.3161064888888889],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.3831210553158284, 
                    0.8428663216948227}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    210.4544488681742}, {-76.08332283712153, \
-1.5857864376268935`}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34976$35046, 
                    FEPrivate`Not[DynamicChart`click$34976$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34976$35046, {{{1., 0}, {0, 1.}}, {
                    0.16358587215334353`, 0.11506373204372414`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34976$35046}]]}, {}, 
                 {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.07662421106316586, 
                    0.3831210553158284}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-40.300652459086905`, 
                    5.7629418346767025`}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34979$35046, 
                    FEPrivate`Not[DynamicChart`click$34979$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34979$35046, {{{1., 0}, {0, 1.}}, {
                    0.19765608475606972`, 0.030529856843774877`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34979$35046}]]}, 
                 {RGBColor[
                  0.6875207111111111, 0.48373333333333335`, 
                   0.6644259555555556], EdgeForm[{GrayLevel[0], Opacity[
                  0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.689617899568491, -0.07662421106316586}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.13253047601216`}, {-4.414213562373114, 
                    59.49348802572284}}],
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34982$35046, 
                    FEPrivate`Not[DynamicChart`click$34982$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34982$35046, {{{1., 0}, {0, 1.}}, {
                    0.18550049022041895`, -0.07476341436815374}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34982$35046}]]}, 
                 {RGBColor[
                  0.6558762666666667, 0.4926222222222222, 0.7345293333333333],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.9961147438211544, -0.689617899568491}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    195.47717482527963`}, {-4.4142135623731065`, 
                    78.99329447104033}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34985$35046, 
                    FEPrivate`Not[DynamicChart`click$34985$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34985$35046, {{{1., 0}, {0, 1.}}, {
                    0.13306514003311307`, -0.14931064432239255`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34985$35046}]]}, 
                 {RGBColor[0.6167072, 0.5082666666666666, 0.7586295999999999],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.4558600102001478`, -0.9961147438211544}]},
                    ImageSizeCache->{{118.5857864376269, 
                    173.59669836249032`}, {-4.4142135623731065`, 
                    93.78081417930191}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34988$35046, 
                    FEPrivate`Not[DynamicChart`click$34988$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34988$35046, {{{1., 0}, {0, 1.}}, {
                    0.06760337568170054, -0.18822800959591235`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34988$35046}]]}, 
                 {RGBColor[
                  0.5775381333333334, 0.5239111111111111, 0.7827298666666667],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.1454779097686396`, -1.4558600102001478`}]},
                    
                    ImageSizeCache->{{66.40330163750964, 
                    132.42382240061954`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34991$35046, 
                    FEPrivate`Not[DynamicChart`click$34991$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34991$35046, {{{1., 0}, {
                    0, 1.}}, {-0.04557070178062752, -0.19473908477555582`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34991$35046}]]}, 
                 {RGBColor[
                  0.5383690666666667, 0.5395555555555556, 0.8068301333333333],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.681847387210799, -2.1454779097686396`}]},
                    
                    ImageSizeCache->{{32.55389296936558, 
                    121.41421356237309`}, {-4.414213562373092, 
                    78.99329447104027}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34994$35046, 
                    FEPrivate`Not[DynamicChart`click$34994$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34994$35046, {{{1., 0}, {
                    0, 1.}}, {-0.14931064432239255`, -0.13306514003311307`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34994$35046}]]}, 
                 {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0],
                   Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.681847387210799}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.4142135623731065`, 
                    41.01131799760124}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34997$35046, 
                    FEPrivate`Not[DynamicChart`click$34997$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$34997$35046, {{{1., 0}, {
                    0, 1.}}, {-0.1947390847755558, -0.045570701780627554`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34997$35046}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34949$35046, 
                    FEPrivate`Not[DynamicChart`click$34949$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34949$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19985323621016202`, 
                    0.007660546738007111}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34949$35046}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34952$35046, 
                    FEPrivate`Not[DynamicChart`click$34952$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34952$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19868041795193503`, 
                    0.022936685079680164`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34952$35046}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34955$35046, 
                    FEPrivate`Not[DynamicChart`click$34955$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34955$35046, {{{1., 0}, {
                    0, 1.}}, {-0.18822800959591232`, 0.06760337568170055}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34955$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34958$35046, 
                    FEPrivate`Not[DynamicChart`click$34958$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34958$35046, {{{1., 0}, {
                    0, 1.}}, {-0.16358587215334358`, 
                    0.11506373204372407`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34958$35046}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34961$35046, 
                    FEPrivate`Not[DynamicChart`click$34961$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34961$35046, {{{1., 0}, {
                    0, 1.}}, {-0.10220373588942211`, 
                    0.17191392139744022`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34961$35046}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34964$35046, 
                    FEPrivate`Not[DynamicChart`click$34964$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34964$35046, {{{1., 0}, {
                    0, 1.}}, {-0.02293668507968008, 0.19868041795193503`}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34964$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34967$35046, 
                    FEPrivate`Not[DynamicChart`click$34967$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34967$35046, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                   0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34967$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34970$35046, 
                    FEPrivate`Not[DynamicChart`click$34970$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34970$35046, {{{1., 0}, {0, 1.}}, {
                    0.04557070178062755, 0.1947390847755558}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34970$35046}]], {}, 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34973$35046, 
                    FEPrivate`Not[DynamicChart`click$34973$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34973$35046, {{{1., 0}, {0, 1.}}, {
                    0.10871351000024423`, 0.16787308522639}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34973$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34976$35046, 
                    FEPrivate`Not[DynamicChart`click$34976$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34976$35046, {{{1., 0}, {0, 1.}}, {
                    0.16358587215334353`, 0.11506373204372414`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34976$35046}]], {}, 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34979$35046, 
                    FEPrivate`Not[DynamicChart`click$34979$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34979$35046, {{{1., 0}, {0, 1.}}, {
                    0.19765608475606972`, 0.030529856843774877`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34979$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34982$35046, 
                    FEPrivate`Not[DynamicChart`click$34982$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34982$35046, {{{1., 0}, {0, 1.}}, {
                    0.18550049022041895`, -0.07476341436815374}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34982$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34985$35046, 
                    FEPrivate`Not[DynamicChart`click$34985$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34985$35046, {{{1., 0}, {0, 1.}}, {
                    0.13306514003311307`, -0.14931064432239255`}}, {{1, 0}, {
                   0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34985$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34988$35046, 
                    FEPrivate`Not[DynamicChart`click$34988$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34988$35046, {{{1., 0}, {0, 1.}}, {
                    0.06760337568170054, -0.18822800959591235`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34988$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34991$35046, 
                    FEPrivate`Not[DynamicChart`click$34991$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34991$35046, {{{1., 0}, {
                    0, 1.}}, {-0.04557070178062752, -0.19473908477555582`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34991$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34994$35046, 
                    FEPrivate`Not[DynamicChart`click$34994$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34994$35046, {{{1., 0}, {
                    0, 1.}}, {-0.14931064432239255`, -0.13306514003311307`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34994$35046}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34997$35046, 
                    FEPrivate`Not[DynamicChart`click$34997$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34997$35046, {{{1., 0}, {
                    0, 1.}}, {-0.1947390847755558, -0.045570701780627554`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$34997$35046}]]}, {}}, {}}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
          PlotRangePadding->Scaled[0.02]]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"fee3a006-61f8-4f8f-b6c0-d2954d8c9947"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$34807$35044 = False, 
                 DynamicChart`click$34810$35044 = False, 
                 DynamicChart`click$34813$35044 = False, 
                 DynamicChart`click$34816$35044 = False, 
                 DynamicChart`click$34819$35044 = False, 
                 DynamicChart`click$34822$35044 = False}, {{
                  RGBColor[0.5, 0.5, 1.], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {2.938909256584, 3.141592653589793}]},
                     ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-23.738871490884474`, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34807$35044, 
                    FEPrivate`Not[DynamicChart`click$34807$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34807$35044, {{{1., 0}, {
                    0, 1.}}, {-0.19897386467837905`, 0.02023366439748646}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34807$35044}]]}, {}, {
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.1281756685608277`, 
                    2.938909256584}]}, 
                    ImageSizeCache -> {{24.550912077387434`, 
                    121.4142135623731}, {-85.88406228186918, \
-1.585786437626897}}], StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34810$35044, 
                    FEPrivate`Not[DynamicChart`click$34810$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34810$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145526`, 
                    0.11425364301895846`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34810$35044}]]}, {
                    RGBColor[0.784, 0.47519999999999996`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5067084925144831, 
                    2.1281756685608277`}]}, 
                    ImageSizeCache -> {{67.8052414462385, 
                    
                    205.35148871225294`}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 8]& , TagBoxNote -> "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34813$35044, 
                    FEPrivate`Not[DynamicChart`click$34813$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34813$35044, {{{1., 0}, {0, 1.}}, {
                    0.05013050645174408, 0.1936154237732409}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34813$35044}]]}, {
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.5067084925144822, 
                    0.5067084925144831}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-51.00320196535692, 
                    45.00320196535684}}], StatusArea[#, 5]& , TagBoxNote -> 
                    "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34816$35044, 
                    FEPrivate`Not[DynamicChart`click$34816$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34816$35044, {{{1., 0}, {0, 1.}}, {0.2,
                     8.881784197001253*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34816$35044}]]}, {
                    RGBColor[
                    0.6167072, 0.5082666666666666, 0.7586295999999999], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.9254922715550338`, -0.5067084925144822}]}, 
                    ImageSizeCache -> {{85.24448216452421, 
                    205.351488712253}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34819$35044, 
                    FEPrivate`Not[DynamicChart`click$34819$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34819$35044, {{{1., 0}, {0, 1.}}, {
                    0.06946105056896418, -0.18755042642941605`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34819$35044}]]}, {
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.9254922715550338`}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    88.43841824849285}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34822$35044, 
                    FEPrivate`Not[DynamicChart`click$34822$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34822$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145524`, -0.11425364301895853`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34822$35044}]]}}}, {}}, {}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34807$35044, 
                    FEPrivate`Not[DynamicChart`click$34807$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34807$35044, {{{1., 0}, {
                    0, 1.}}, {-0.19897386467837905`, 0.02023366439748646}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34807$35044}]], {}, 
                    
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34810$35044, 
                    FEPrivate`Not[DynamicChart`click$34810$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34810$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145526`, 
                    0.11425364301895846`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34810$35044}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 8]& , TagBoxNote -> "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34813$35044, 
                    FEPrivate`Not[DynamicChart`click$34813$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34813$35044, {{{1., 0}, {0, 1.}}, {
                    0.05013050645174408, 0.1936154237732409}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34813$35044}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34816$35044, 
                    FEPrivate`Not[DynamicChart`click$34816$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34816$35044, {{{1., 0}, {0, 1.}}, {0.2,
                     8.881784197001253*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34816$35044}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34819$35044, 
                    FEPrivate`Not[DynamicChart`click$34819$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34819$35044, {{{1., 0}, {0, 1.}}, {
                    0.06946105056896418, -0.18755042642941605`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34819$35044}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34822$35044, 
                    FEPrivate`Not[DynamicChart`click$34822$35044]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34822$35044, {{{1., 0}, {
                    0, 1.}}, {-0.16415268824145524`, -0.11425364301895853`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34822$35044}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]], ",", 
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$34863$35045 = False, 
                 DynamicChart`click$34866$35045 = False, 
                 DynamicChart`click$34869$35045 = False, 
                 DynamicChart`click$34872$35045 = False, 
                 DynamicChart`click$34875$35045 = False, 
                 DynamicChart`click$34878$35045 = False, 
                 DynamicChart`click$34881$35045 = False, 
                 DynamicChart`click$34884$35045 = False, 
                 DynamicChart`click$34887$35045 = False, 
                 DynamicChart`click$34890$35045 = False, 
                 DynamicChart`click$34893$35045 = False, 
                 DynamicChart`click$34896$35045 = False}, {{
                  RGBColor[0.5, 0.5, 1.], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.038589615767177, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-14.28502928755972, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34863$35045, 
                    FEPrivate`Not[DynamicChart`click$34863$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34863$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19973481797696613`, 
                    0.010295750954069347`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34863$35045}]]}, {}, {
                    RGBColor[0.994288, 0.6103824, 0.24208906666666669`], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.1115622753636316`, 
                    3.038589615767177}]}, 
                    ImageSizeCache -> {{23.094598378626355`, 
                    121.4142135623731}, {-86.71641785770099, \
-1.5857864376269113`}}], StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34866$35045, 
                    FEPrivate`Not[DynamicChart`click$34866$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34866$35045, {{{1., 0}, {
                    0, 1.}}, {-0.16875511196463713`, 
                    0.10733923879832011`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34866$35045}]]}, {
                    RGBColor[1., 0.544, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.1845349349600858`, 
                    2.1115622753636316`}]}, 
                    ImageSizeCache -> {{69.16567749268314, 
                    157.58009135135086`}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34869$35045, 
                    FEPrivate`Not[DynamicChart`click$34869$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34869$35045, {{{1., 0}, {
                    0, 1.}}, {-0.015435092425329236`, 
                    0.19940350528970535`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34869$35045}]]}, {
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.6695197458470052, 
                    1.1845349349600858`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    196.6897149937373}, {-93.34131451451661, \
-1.5857864376268935`}}], StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34872$35045, 
                    FEPrivate`Not[DynamicChart`click$34872$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34872$35045, {{{1., 0}, {0, 1.}}, {
                    0.12004285610967365`, 0.15996784894794389`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34872$35045}]]}, {
                    RGBColor[0.8560000000000001, 0.4981333333333333, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5665167080243889, 
                    0.6695197458470052}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    202.4166673053989}, {-63.99272381780572, \
-1.5857864376268935`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34875$35045, 
                    FEPrivate`Not[DynamicChart`click$34875$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34875$35045, {{{1., 0}, {0, 1.}}, {
                    0.1630056675033623, 0.11588421964091276`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34875$35045}]]}, {
                    RGBColor[0.784, 0.47519999999999996`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0.4635136702017726, 
                    0.5665167080243889}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    207.28497345633747`}, {-55.93704818556675, \
-1.5857864376268935`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34878$35045, 
                    FEPrivate`Not[DynamicChart`click$34878$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34878$35045, {{{1., 0}, {0, 1.}}, {
                    0.17405704820603107`, 0.09850961359077287}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34878$35045}]]}, {
                    RGBColor[0.7478202666666667, 0.4784, 0.3741597333333332], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.1545045567339245, 
                    0.4635136702017726}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-47.335217688944034`, 
                    13.187708925963058`}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34881$35045, 
                    FEPrivate`Not[DynamicChart`click$34881$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34881$35045, {{{1., 0}, {0, 1.}}, {
                    0.19761757921821543`, 0.030778115340812318`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34881$35045}]]}, {
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.36051063237915715`, -0.1545045567339245}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    216.2706515871165}, {-4.414213562373114, 
                    32.27841387108625}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34884$35045, 
                    FEPrivate`Not[DynamicChart`click$34884$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34884$35045, {{{1., 0}, {0, 1.}}, {
                    0.19340554495826406`, -0.050934224048245824`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34884$35045}]]}, {
                    RGBColor[0.6754608, 0.4848, 0.7224792], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.08153189713747, -0.36051063237915715`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    211.24302819026047`}, {-4.4142135623731065`, 
                    83.15137820162568}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34887$35045, 
                    FEPrivate`Not[DynamicChart`click$34887$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34887$35045, {{{1., 0}, {0, 1.}}, {
                    0.15022638617410394`, -0.13203042413424643`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34887$35045}]]}, {
                    RGBColor[
                    0.6167072, 0.5082666666666666, 0.7586295999999999], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.8025531618957826`, -1.08153189713747}]}, 
                    ImageSizeCache -> {{96.53576319297456, 
                    166.53198089299582`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34890$35045, 
                    FEPrivate`Not[DynamicChart`click$34890$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34890$35045, {{{1., 0}, {0, 1.}}, {
                    0.025679671029310198`, -0.1983445348272203}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34890$35045}]]}, {
                    RGBColor[
                    0.5579536, 0.5317333333333334, 0.7947799999999999], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.523574426654096, -1.8025531618957826`}]}, 
                    ImageSizeCache -> {{40.34306603601303, 
                    121.41421356237309`}, {-4.414213562373092, 
                    91.84759343760982}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34893$35045, 
                    FEPrivate`Not[DynamicChart`click$34893$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34893$35045, {{{1., 0}, {
                    0, 1.}}, {-0.11164874440537292`, -0.16593540271052382`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34893$35045}]]}, {
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.523574426654096}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373099, 
                    54.03863899001122}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34896$35045, 
                    FEPrivate`Not[DynamicChart`click$34896$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34896$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19052707616067652`, -0.06082296646550361}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34896$35045}]]}}}, {}}, {}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34863$35045, 
                    FEPrivate`Not[DynamicChart`click$34863$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34863$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19973481797696613`, 
                    0.010295750954069347`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34863$35045}]], {}, 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34866$35045, 
                    FEPrivate`Not[DynamicChart`click$34866$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34866$35045, {{{1., 0}, {
                    0, 1.}}, {-0.16875511196463713`, 
                    0.10733923879832011`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34866$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34869$35045, 
                    FEPrivate`Not[DynamicChart`click$34869$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34869$35045, {{{1., 0}, {
                    0, 1.}}, {-0.015435092425329236`, 
                    0.19940350528970535`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34869$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34872$35045, 
                    FEPrivate`Not[DynamicChart`click$34872$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34872$35045, {{{1., 0}, {0, 1.}}, {
                    0.12004285610967365`, 0.15996784894794389`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34872$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34875$35045, 
                    FEPrivate`Not[DynamicChart`click$34875$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34875$35045, {{{1., 0}, {0, 1.}}, {
                    0.1630056675033623, 0.11588421964091276`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34875$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34878$35045, 
                    FEPrivate`Not[DynamicChart`click$34878$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34878$35045, {{{1., 0}, {0, 1.}}, {
                    0.17405704820603107`, 0.09850961359077287}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34878$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34881$35045, 
                    FEPrivate`Not[DynamicChart`click$34881$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34881$35045, {{{1., 0}, {0, 1.}}, {
                    0.19761757921821543`, 0.030778115340812318`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34881$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34884$35045, 
                    FEPrivate`Not[DynamicChart`click$34884$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34884$35045, {{{1., 0}, {0, 1.}}, {
                    0.19340554495826406`, -0.050934224048245824`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34884$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34887$35045, 
                    FEPrivate`Not[DynamicChart`click$34887$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34887$35045, {{{1., 0}, {0, 1.}}, {
                    0.15022638617410394`, -0.13203042413424643`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34887$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34890$35045, 
                    FEPrivate`Not[DynamicChart`click$34890$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34890$35045, {{{1., 0}, {0, 1.}}, {
                    0.025679671029310198`, -0.1983445348272203}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34890$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34893$35045, 
                    FEPrivate`Not[DynamicChart`click$34893$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34893$35045, {{{1., 0}, {
                    0, 
                    1.}}, {-0.11164874440537292`, -0.16593540271052382`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34893$35045}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34896$35045, 
                    FEPrivate`Not[DynamicChart`click$34896$35045]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34896$35045, {{{1., 0}, {
                    0, 1.}}, {-0.19052707616067652`, -0.06082296646550361}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34896$35045}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]], ",", 
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$34949$35046 = False, 
                 DynamicChart`click$34952$35046 = False, 
                 DynamicChart`click$34955$35046 = False, 
                 DynamicChart`click$34958$35046 = False, 
                 DynamicChart`click$34961$35046 = False, 
                 DynamicChart`click$34964$35046 = False, 
                 DynamicChart`click$34967$35046 = False, 
                 DynamicChart`click$34970$35046 = False, 
                 DynamicChart`click$34973$35046 = False, 
                 DynamicChart`click$34976$35046 = False, 
                 DynamicChart`click$34979$35046 = False, 
                 DynamicChart`click$34982$35046 = False, 
                 DynamicChart`click$34985$35046 = False, 
                 DynamicChart`click$34988$35046 = False, 
                 DynamicChart`click$34991$35046 = False, 
                 DynamicChart`click$34994$35046 = False, 
                 DynamicChart`click$34997$35046 = False}, {{
                  RGBColor[0.5, 0.5, 1.], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0649684425266273`, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-11.762941834676706`, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34949$35046, 
                    FEPrivate`Not[DynamicChart`click$34949$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34949$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19985323621016202`, 
                    0.007660546738007111}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34949$35046}]]}, {
                    RGBColor[
                    0.986672, 0.6988922666666667, 0.2982078222222222], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.988344231463462, 
                    3.0649684425266273`}]}, 
                    ImageSizeCache -> {{22.86746952398782, 
                    121.41421356237309`}, {-19.068544847385052`, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34952$35046, 
                    FEPrivate`Not[DynamicChart`click$34952$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34952$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19868041795193503`, 
                    0.022936685079680164`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34952$35046}]]}, {
                    RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.6052231761476334`, 
                    2.988344231463462}]}, 
                    ImageSizeCache -> {{23.71086575471345, 
                    121.41421356237309`}, {-53.47200678929569, \
-1.5857864376269042`}}], StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34955$35046, 
                    FEPrivate`Not[DynamicChart`click$34955$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34955$35046, {{{1., 0}, {
                    0, 1.}}, {-0.18822800959591232`, 0.06760337568170055}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34955$35046}]]}, {
                    RGBColor[0.994288, 0.6103824, 0.24208906666666669`], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.451974754021302, 
                    2.6052231761476334`}]}, 
                    ImageSizeCache -> {{36.0671041668556, 
                    121.41421356237309`}, {-65.49348802572284, \
-1.5857864376269033`}}], StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34958$35046, 
                    FEPrivate`Not[DynamicChart`click$34958$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34958$35046, {{{1., 0}, {
                    0, 1.}}, {-0.16358587215334358`, 
                    0.11506373204372407`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34958$35046}]]}, {
                    RGBColor[
                    0.998096, 0.5661274666666667, 0.2140296888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.7623568544528108`, 
                    2.451974754021302}]}, 
                    ImageSizeCache -> {{44.52282517472038, 
                    121.41421356237309`}, {-98.65821228207116, \
-1.5857864376269104`}}], StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34961$35046, 
                    FEPrivate`Not[DynamicChart`click$34961$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34961$35046, {{{1., 0}, {
                    0, 1.}}, {-0.10220373588942211`, 
                    0.17191392139744022`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34961$35046}]]}, {
                    RGBColor[0.976, 0.5363555555555556, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.6091084323264795`, 
                    1.7623568544528108`}]}, 
                    ImageSizeCache -> {{100.30823995781876`, 
                    121.4142135623731}, {-100.34376694325086`, \
-1.5857864376269104`}}], StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34964$35046, 
                    FEPrivate`Not[DynamicChart`click$34964$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34964$35046, {{{1., 0}, {
                    0, 1.}}, {-0.02293668507968008, 0.19868041795193503`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34964$35046}]]}, {
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.5324842212633136`, 
                    1.6091084323264795`}]}, 
                    ImageSizeCache -> {{114.90872400338351`, 
                    125.0912759966165}, {-100.41421356237309`, \
-1.5857864376269104`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34967$35046, 
                    FEPrivate`Not[DynamicChart`click$34967$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34967$35046, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34967$35046}]]}, {
                    RGBColor[0.8800000000000001, 0.5057777777777778, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.1493631659474852`, 
                    1.5324842212633136`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    160.68480273082173`}, {-100.34376694325087`, \
-1.5857864376268935`}}], StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34970$35046, 
                    FEPrivate`Not[DynamicChart`click$34970$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34970$35046, {{{1., 0}, {0, 1.}}, {
                    0.04557070178062755, 0.1947390847755558}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34970$35046}]]}, {}, {
                    RGBColor[0.784, 0.47519999999999996`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.8428663216948227, 
                    1.1493631659474852`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    185.28548077826736`}, {-92.01456074412191, \
-1.5857864376268935`}}], StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34973$35046, 
                    FEPrivate`Not[DynamicChart`click$34973$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34973$35046, {{{1., 0}, {0, 1.}}, {
                    0.10871351000024423`, 0.16787308522639}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34973$35046}]]}, {
                    RGBColor[
                    0.7598801777777778, 0.4773333333333333, 
                    0.3161064888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.3831210553158284, 
                    0.8428663216948227}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    210.4544488681742}, {-76.08332283712153, \
-1.5857864376268935`}}], StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34976$35046, 
                    FEPrivate`Not[DynamicChart`click$34976$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34976$35046, {{{1., 0}, {0, 1.}}, {
                    0.16358587215334353`, 0.11506373204372414`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34976$35046}]]}, {}, {
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-0.07662421106316586, 
                    0.3831210553158284}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-40.300652459086905`, 
                    5.7629418346767025`}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34979$35046, 
                    FEPrivate`Not[DynamicChart`click$34979$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34979$35046, {{{1., 0}, {0, 1.}}, {
                    0.19765608475606972`, 0.030529856843774877`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34979$35046}]]}, {
                    RGBColor[
                    0.6875207111111111, 0.48373333333333335`, 
                    0.6644259555555556], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.689617899568491, -0.07662421106316586}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.13253047601216`}, {-4.414213562373114, 
                    59.49348802572284}}], StatusArea[#, 8]& , TagBoxNote -> 
                    "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34982$35046, 
                    FEPrivate`Not[DynamicChart`click$34982$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34982$35046, {{{1., 0}, {0, 1.}}, {
                    0.18550049022041895`, -0.07476341436815374}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34982$35046}]]}, {
                    RGBColor[
                    0.6558762666666667, 0.4926222222222222, 
                    0.7345293333333333], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.9961147438211544, -0.689617899568491}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    195.47717482527963`}, {-4.4142135623731065`, 
                    78.99329447104033}}], StatusArea[#, 4]& , TagBoxNote -> 
                    "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34985$35046, 
                    FEPrivate`Not[DynamicChart`click$34985$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34985$35046, {{{1., 0}, {0, 1.}}, {
                    0.13306514003311307`, -0.14931064432239255`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34985$35046}]]}, {
                    RGBColor[
                    0.6167072, 0.5082666666666666, 0.7586295999999999], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.4558600102001478`, -0.9961147438211544}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    173.59669836249032`}, {-4.4142135623731065`, 
                    93.78081417930191}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34988$35046, 
                    FEPrivate`Not[DynamicChart`click$34988$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34988$35046, {{{1., 0}, {0, 1.}}, {
                    0.06760337568170054, -0.18822800959591235`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34988$35046}]]}, {
                    RGBColor[
                    0.5775381333333334, 0.5239111111111111, 
                    0.7827298666666667], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.1454779097686396`, -1.4558600102001478`}]}, 
                    ImageSizeCache -> {{66.40330163750964, 
                    132.42382240061954`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 9]& , TagBoxNote -> 
                    "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34991$35046, 
                    FEPrivate`Not[DynamicChart`click$34991$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34991$35046, {{{1., 0}, {
                    0, 1.}}, {-0.04557070178062752, -0.19473908477555582`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34991$35046}]]}, {
                    RGBColor[
                    0.5383690666666667, 0.5395555555555556, 
                    0.8068301333333333], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.681847387210799, -2.1454779097686396`}]}, 
                    ImageSizeCache -> {{32.55389296936558, 
                    121.41421356237309`}, {-4.414213562373092, 
                    78.99329447104027}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34994$35046, 
                    FEPrivate`Not[DynamicChart`click$34994$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34994$35046, {{{1., 0}, {
                    0, 1.}}, {-0.14931064432239255`, -0.13306514003311307`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34994$35046}]]}, {
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.681847387210799}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.4142135623731065`, 
                    41.01131799760124}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34997$35046, 
                    FEPrivate`Not[DynamicChart`click$34997$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34997$35046, {{{1., 0}, {
                    0, 1.}}, {-0.1947390847755558, -0.045570701780627554`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34997$35046}]]}}}, {}}, {}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34949$35046, 
                    FEPrivate`Not[DynamicChart`click$34949$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[DynamicChart`click$34949$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19985323621016202`, 
                    0.007660546738007111}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34949$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34952$35046, 
                    FEPrivate`Not[DynamicChart`click$34952$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34952$35046, {{{1., 0}, {
                    0, 1.}}, {-0.19868041795193503`, 
                    0.022936685079680164`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34952$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34955$35046, 
                    FEPrivate`Not[DynamicChart`click$34955$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34955$35046, {{{1., 0}, {
                    0, 1.}}, {-0.18822800959591232`, 0.06760337568170055}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34955$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34958$35046, 
                    FEPrivate`Not[DynamicChart`click$34958$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34958$35046, {{{1., 0}, {
                    0, 1.}}, {-0.16358587215334358`, 
                    0.11506373204372407`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34958$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34961$35046, 
                    FEPrivate`Not[DynamicChart`click$34961$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34961$35046, {{{1., 0}, {
                    0, 1.}}, {-0.10220373588942211`, 
                    0.17191392139744022`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34961$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34964$35046, 
                    FEPrivate`Not[DynamicChart`click$34964$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34964$35046, {{{1., 0}, {
                    0, 1.}}, {-0.02293668507968008, 0.19868041795193503`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34964$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34967$35046, 
                    FEPrivate`Not[DynamicChart`click$34967$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34967$35046, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34967$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34970$35046, 
                    FEPrivate`Not[DynamicChart`click$34970$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34970$35046, {{{1., 0}, {0, 1.}}, {
                    0.04557070178062755, 0.1947390847755558}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34970$35046}]], {}, 
                    
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34973$35046, 
                    FEPrivate`Not[DynamicChart`click$34973$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34973$35046, {{{1., 0}, {0, 1.}}, {
                    0.10871351000024423`, 0.16787308522639}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34973$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34976$35046, 
                    FEPrivate`Not[DynamicChart`click$34976$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34976$35046, {{{1., 0}, {0, 1.}}, {
                    0.16358587215334353`, 0.11506373204372414`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34976$35046}]], {}, 
                    
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34979$35046, 
                    FEPrivate`Not[DynamicChart`click$34979$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34979$35046, {{{1., 0}, {0, 1.}}, {
                    0.19765608475606972`, 0.030529856843774877`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34979$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 8]& , TagBoxNote -> "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34982$35046, 
                    FEPrivate`Not[DynamicChart`click$34982$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34982$35046, {{{1., 0}, {0, 1.}}, {
                    0.18550049022041895`, -0.07476341436815374}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34982$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34985$35046, 
                    FEPrivate`Not[DynamicChart`click$34985$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34985$35046, {{{1., 0}, {0, 1.}}, {
                    0.13306514003311307`, -0.14931064432239255`}}, {{1, 0}, {
                    0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34985$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34988$35046, 
                    FEPrivate`Not[DynamicChart`click$34988$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34988$35046, {{{1., 0}, {0, 1.}}, {
                    0.06760337568170054, -0.18822800959591235`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34988$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34991$35046, 
                    FEPrivate`Not[DynamicChart`click$34991$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34991$35046, {{{1., 0}, {
                    0, 1.}}, {-0.04557070178062752, -0.19473908477555582`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34991$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34994$35046, 
                    FEPrivate`Not[DynamicChart`click$34994$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34994$35046, {{{1., 0}, {
                    0, 1.}}, {-0.14931064432239255`, -0.13306514003311307`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34994$35046}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34997$35046, 
                    FEPrivate`Not[DynamicChart`click$34997$35046]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$34997$35046, {{{1., 0}, {
                    0, 1.}}, {-0.1947390847755558, -0.045570701780627554`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34997$35046}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2d062882-44f1-4d09-839e-41058a864192"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e93d9943-d460-45fb-85a3-2c80d751e041"],

Cell["Can one add lists of different lengths?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f37980da-589e-4019-b758-5a25718913ba"],

Cell[TextData[{
 "No. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "InlineCode",ExpressionUUID->
  "1cc6ad67-29a7-4bd2-af14-048f8fdddf1d"],
 " won\[CloseCurlyQuote]t work. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0"}], "}"}], 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "InlineCode",ExpressionUUID->
  "f4d6b9dd-98c1-48da-8260-150ae5085de5"],
 " would be fine, if that\[CloseCurlyQuote]s what you mean."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6fca0b6b-0f84-4c75-9bb0-541e9b10a0fe"],

Cell["Can there be a list with nothing in it?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"63b03bce-1b97-43c8-9977-d30523c50141"],

Cell[TextData[{
 "Yes. ",
 Cell[BoxData[
  RowBox[{"{", "\[VeryThinSpace]", "}"}]], "InlineCode",ExpressionUUID->
  "a3e66dd0-7f53-4a5c-8a93-a30e7cd1eac3"],
 " is a list of length 0, with no elements. It\[CloseCurlyQuote]s usually \
called the ",
 StyleBox["null list",
  FontSlant->"Italic"],
 " or the ",
 StyleBox["empty list",
  FontSlant->"Italic"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a292f94f-2b2e-485b-b6c6-2a5a73ea8946"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"746bc76b-076e-4547-b129-13da2ab57863"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"CodeLink"], "[", "5671", "]"}]], "InlineCode",ExpressionUUID->
  "953334b0-4889-4f9e-ab72-bfefe262b1cc"],
 " gives digits in base 10. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"5671", ",", "2"}], "]"}]], "InlineCode",ExpressionUUID->
  "8571ea9c-a868-46c1-bad8-d1367256b3db"],
 " gives digits in base 2. You can use any base you want. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromDigits",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7", ",", "1"}], "}"}], "]"}]], "InlineCode",
  ExpressionUUID->"acb683c0-d45d-422f-bbbc-c221a134fcf6"],
 " reconstructs a number from its list of digits."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"194bc45f-0322-4294-8c1c-2d4b42441ceb"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rest",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["list", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "01863161-0c98-41fe-8d82-6d36cea81f65"],
 " gives all the elements of ",
 Cell[BoxData[
  StyleBox["list", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "d88367a7-a88b-40b6-a8b8-9c9cab7b0baa"],
 " after the first one. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Most",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["list", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "d89a4264-db24-4f72-ace9-5f01de232f18"],
 " gives all elements other than the last one."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"7f304f7b-4414-44fa-a5bd-81ecd3194ad8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c9971f3f-21ae-4dc1-8126-328ae8463718"],

Cell[TextData[ButtonBox["Guide to List Manipulation in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"1feb0f6f-251e-420c-be83-3abef3a15911"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Operations on Lists: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Displaying Lists\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Displaying Lists", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Making Tables\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Making Tables", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->31,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Operations on Lists \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"6db85193-4cab-4fd0-ab57-23041630888d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:15"->{
  Cell[664, 24, 481, 13, 93, "Section",ExpressionUUID->"07a1b31c-b8a7-4e6f-aaa0-e601aefd876f",
   CounterAssignments->{{"Section", 4}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:15", "i:1"}]},
 "i:1"->{
  Cell[664, 24, 481, 13, 93, "Section",ExpressionUUID->"07a1b31c-b8a7-4e6f-aaa0-e601aefd876f",
   CounterAssignments->{{"Section", 4}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:15", "i:1"}]},
 "i:2"->{
  Cell[1376, 48, 191, 4, 37, "CodeCaption",ExpressionUUID->"69ccecfe-6298-4697-bead-9ad2e5fb942f",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[4879, 167, 239, 8, 37, "CodeCaption",ExpressionUUID->"e13d5fe0-734c-46c0-9d81-c4d55ff4fbfe",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[5642, 196, 252, 10, 37, "CodeCaption",ExpressionUUID->"a504acf0-1aa5-4326-b357-cef10d4e40ab",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[6366, 225, 264, 10, 70, "CodeCaption",ExpressionUUID->"82d9d604-f643-4185-8858-eb367a440ecc",
   CellTags->"i:5"]},
 "LastCellOfAPage"->{
  Cell[7469, 267, 203, 5, 70, "Output",ExpressionUUID->"f39da581-6df9-48a1-9c9d-e11ea37a541b",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[13755, 495, 203, 5, 70, "Output",ExpressionUUID->"122a5b54-5fa5-4460-9cce-7e0f33614410",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[34192, 1131, 959, 30, 70, "Exercise",ExpressionUUID->"425fff1c-fa6a-4bc0-928b-4e7bd8b7419d",
   CellTags->"LastCellOfAPage"],
  Cell[356075, 8375, 348, 8, 70, "MoreExplore",ExpressionUUID->"1feb0f6f-251e-420c-be83-3abef3a15911",
   CellTags->"LastCellOfAPage"]},
 "p:16"->{
  Cell[7687, 275, 277, 9, 70, "Text",ExpressionUUID->"6b28327e-9774-4047-b633-393294e22eae",
   CellTags->{"p:16", "i:6"}]},
 "i:6"->{
  Cell[7687, 275, 277, 9, 70, "Text",ExpressionUUID->"6b28327e-9774-4047-b633-393294e22eae",
   CellTags->{"p:16", "i:6"}]},
 "i:7"->{
  Cell[8766, 315, 491, 17, 70, "Text",ExpressionUUID->"46052a8d-e9e7-46e1-b290-ea66652211cb",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[12308, 445, 427, 12, 70, "Text",ExpressionUUID->"7f13fb63-03b6-4581-9092-e1016667ae38",
   CellTags->"i:8"]},
 "p:17"->{
  Cell[13973, 503, 297, 10, 70, "Text",ExpressionUUID->"b02ee93f-4c9c-4f99-bebf-59183831125e",
   CellTags->{"p:17", "i:9"}]},
 "i:9"->{
  Cell[13973, 503, 297, 10, 70, "Text",ExpressionUUID->"b02ee93f-4c9c-4f99-bebf-59183831125e",
   CellTags->{"p:17", "i:9"}]},
 "i:10"->{
  Cell[15805, 569, 253, 8, 70, "Text",ExpressionUUID->"a2931965-bc72-4af5-a214-123a38fe3364",
   CellTags->"i:10"]},
 "p:18"->{
  Cell[36635, 1208, 787, 21, 70, "Exercise",ExpressionUUID->"8f933998-3669-4b59-af37-a9bd4ae66364",
   CellTags->"p:18"]},
 "i:11"->{
  Cell[353251, 8279, 195, 4, 70, "Question",ExpressionUUID->"63b03bce-1b97-43c8-9977-d30523c50141",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[354139, 8313, 931, 26, 70, "TechNote",ExpressionUUID->"194bc45f-0322-4294-8c1c-2d4b42441ceb",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[355073, 8341, 797, 23, 70, "TechNote",ExpressionUUID->"7f304f7b-4414-44fa-a5bd-81ecd3194ad8",
   CellTags->"i:13"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:15", 447044, 10222},
 {"i:1", 447297, 10226},
 {"i:2", 447550, 10230},
 {"i:3", 447681, 10233},
 {"i:4", 447813, 10236},
 {"i:5", 447946, 10239},
 {"LastCellOfAPage", 448091, 10242},
 {"p:16", 448675, 10253},
 {"i:6", 448810, 10256},
 {"i:7", 448945, 10259},
 {"i:8", 449071, 10262},
 {"p:17", 449199, 10265},
 {"i:9", 449336, 10268},
 {"i:10", 449474, 10271},
 {"p:18", 449602, 10274},
 {"i:11", 449736, 10277},
 {"i:12", 449870, 10280},
 {"i:13", 450005, 10283}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[664, 24, 481, 13, 93, "Section",ExpressionUUID->"07a1b31c-b8a7-4e6f-aaa0-e601aefd876f",
 CounterAssignments->{{"Section", 4}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{"p:15", "i:1"}],
Cell[1148, 39, 225, 7, 40, "Text",ExpressionUUID->"443c04e4-9cfa-4415-954e-eda361014ae0"],
Cell[1376, 48, 191, 4, 37, "CodeCaption",ExpressionUUID->"69ccecfe-6298-4697-bead-9ad2e5fb942f",
 CellTags->"i:2"],
Cell[CellGroupData[{
Cell[1592, 56, 204, 5, 29, "Input",ExpressionUUID->"cf913516-8416-4bd4-a3c3-a02f28cc7f82"],
Cell[1799, 63, 230, 6, 40, "Output",ExpressionUUID->"ff1ee7b0-b1b6-4834-a7aa-a0f3203f63fb",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[2066, 74, 260, 7, 29, "Input",ExpressionUUID->"b62c8936-2f8f-4459-836c-e8079fb6b873"],
Cell[2329, 83, 227, 6, 40, "Output",ExpressionUUID->"d7ed373b-1193-498c-ac51-5718b8738739",
 Evaluatable->False]
}, Open  ]],
Cell[2571, 92, 172, 4, 37, "CodeCaption",ExpressionUUID->"1098bcfa-c79a-4bb3-85d0-bd39243e0f4a"],
Cell[CellGroupData[{
Cell[2768, 100, 179, 4, 29, "Input",ExpressionUUID->"3cb71252-3beb-43de-a5d6-b8c855a6c0be"],
Cell[2950, 106, 312, 8, 40, "Output",ExpressionUUID->"ecbb2829-e98d-460d-8f90-204e9c3cf7e0",
 Evaluatable->False]
}, Open  ]],
Cell[3277, 117, 169, 4, 37, "CodeCaption",ExpressionUUID->"b922ec60-70ab-4b2a-a947-4219a172757f"],
Cell[CellGroupData[{
Cell[3471, 125, 215, 5, 29, "Input",ExpressionUUID->"3f5f4324-7066-400a-b6c9-d016523ed058"],
Cell[3689, 132, 1175, 32, 148, "Output",ExpressionUUID->"f1ad32f1-7223-4148-98fc-17cdd6069b04",
 Evaluatable->False]
}, Open  ]],
Cell[4879, 167, 239, 8, 37, "CodeCaption",ExpressionUUID->"e13d5fe0-734c-46c0-9d81-c4d55ff4fbfe",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[5143, 179, 234, 6, 29, "Input",ExpressionUUID->"5cfde2ef-262c-40b6-a34d-6baf29faf660"],
Cell[5380, 187, 247, 6, 40, "Output",ExpressionUUID->"88995c7f-fb39-4244-b76b-ee3c5d41a1c1",
 Evaluatable->False]
}, Open  ]],
Cell[5642, 196, 252, 10, 37, "CodeCaption",ExpressionUUID->"a504acf0-1aa5-4326-b357-cef10d4e40ab",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[5919, 210, 257, 6, 29, "Input",ExpressionUUID->"6d38388e-3e00-4e29-9ca0-f589c46adf38"],
Cell[6179, 218, 172, 4, 70, "Output",ExpressionUUID->"072aa6cf-f9fe-48c0-bca9-01dce0a27b47",
 Evaluatable->False]
}, Open  ]],
Cell[6366, 225, 264, 10, 70, "CodeCaption",ExpressionUUID->"82d9d604-f643-4185-8858-eb367a440ecc",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[6655, 239, 222, 5, 70, "Input",ExpressionUUID->"97e6b34c-7753-46f3-bffd-852cbe536060"],
Cell[6880, 246, 172, 4, 70, "Output",ExpressionUUID->"4db42392-e7a6-4377-b220-cfc2ccc63366",
 Evaluatable->False]
}, Open  ]],
Cell[7067, 253, 186, 4, 70, "CodeCaption",ExpressionUUID->"067d3034-c53f-49d5-9eaf-d3941b4c189e"],
Cell[CellGroupData[{
Cell[7278, 261, 188, 4, 70, "Input",ExpressionUUID->"a57380dd-53bb-4ad5-88f7-e4aadac38709"],
Cell[7469, 267, 203, 5, 70, "Output",ExpressionUUID->"f39da581-6df9-48a1-9c9d-e11ea37a541b",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[7687, 275, 277, 9, 70, "Text",ExpressionUUID->"6b28327e-9774-4047-b633-393294e22eae",
 CellTags->{"p:16", "i:6"}],
Cell[7967, 286, 302, 9, 70, "CodeCaption",ExpressionUUID->"347193c5-a9ab-47cc-9ad8-6a9d49c24d76"],
Cell[CellGroupData[{
Cell[8294, 299, 282, 7, 70, "Input",ExpressionUUID->"2ce033e2-79d8-4c82-a603-cba8be8195a2"],
Cell[8579, 308, 172, 4, 70, "Output",ExpressionUUID->"e1b3b8fb-f417-4b7c-b053-a913487b84ce",
 Evaluatable->False]
}, Open  ]],
Cell[8766, 315, 491, 17, 70, "Text",ExpressionUUID->"46052a8d-e9e7-46e1-b290-ea66652211cb",
 CellTags->"i:7"],
Cell[9260, 334, 180, 4, 70, "CodeCaption",ExpressionUUID->"51d22c8f-8e72-4e82-a04d-95dceb2daa42"],
Cell[CellGroupData[{
Cell[9465, 342, 213, 5, 70, "Input",ExpressionUUID->"9cc7cd22-c99c-4193-a134-1c82b1697897"],
Cell[9681, 349, 173, 4, 70, "Output",ExpressionUUID->"7c093b0f-7ec0-422b-9553-bdfe02d818f5",
 Evaluatable->False]
}, Open  ]],
Cell[9869, 356, 169, 4, 70, "CodeCaption",ExpressionUUID->"55c80733-acfd-4244-b21f-5a7146fea8cf"],
Cell[CellGroupData[{
Cell[10063, 364, 212, 5, 70, "Input",ExpressionUUID->"261b30bc-407f-4d93-a53e-a6df6cd81ff9"],
Cell[10278, 371, 173, 4, 70, "Output",ExpressionUUID->"d062f73e-6a8a-4630-a6e7-341ee814dae7",
 Evaluatable->False]
}, Open  ]],
Cell[10466, 378, 169, 4, 70, "CodeCaption",ExpressionUUID->"027c5c7b-0d95-4726-928d-3b9043b785d7"],
Cell[CellGroupData[{
Cell[10660, 386, 237, 6, 70, "Input",ExpressionUUID->"d0c22ce2-86bc-47f9-8b70-4c579e2aca58"],
Cell[10900, 394, 173, 4, 70, "Output",ExpressionUUID->"52e6630a-dab9-49f1-b86a-954b96d4d2b7",
 Evaluatable->False]
}, Open  ]],
Cell[11088, 401, 267, 7, 70, "CodeCaption",ExpressionUUID->"00f07991-d6ef-49b1-b54e-8f3e75b4fb17"],
Cell[CellGroupData[{
Cell[11380, 412, 280, 7, 70, "Input",ExpressionUUID->"c827e44c-473c-4b40-8bd9-0e41ca2a1276"],
Cell[11663, 421, 173, 4, 70, "Output",ExpressionUUID->"65c49e89-d1ce-4829-8c34-132c1513e462",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[11873, 430, 244, 6, 70, "Input",ExpressionUUID->"90bceca3-6720-43e3-8ef9-a995081465fc"],
Cell[12120, 438, 173, 4, 70, "Output",ExpressionUUID->"5da4c0a8-79eb-4ea0-86dc-afe060e19976",
 Evaluatable->False]
}, Open  ]],
Cell[12308, 445, 427, 12, 70, "Text",ExpressionUUID->"7f13fb63-03b6-4581-9092-e1016667ae38",
 CellTags->"i:8"],
Cell[12738, 459, 180, 4, 70, "CodeCaption",ExpressionUUID->"bb228c56-c238-474b-a5f4-bb309da692d7"],
Cell[CellGroupData[{
Cell[12943, 467, 167, 3, 70, "Input",ExpressionUUID->"cabeae60-2563-43f2-b428-4dec094672ca"],
Cell[13113, 472, 238, 6, 70, "Output",ExpressionUUID->"5766e1e6-ac5b-4f62-86c5-1820ef4dc978",
 Evaluatable->False]
}, Open  ]],
Cell[13366, 481, 163, 4, 70, "CodeCaption",ExpressionUUID->"8cac28c9-f062-4549-b398-c0b55ef97722"],
Cell[CellGroupData[{
Cell[13554, 489, 198, 4, 70, "Input",ExpressionUUID->"5ac53af3-eb09-4694-8ea6-74ae1164cccf"],
Cell[13755, 495, 203, 5, 70, "Output",ExpressionUUID->"122a5b54-5fa5-4460-9cce-7e0f33614410",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[13973, 503, 297, 10, 70, "Text",ExpressionUUID->"b02ee93f-4c9c-4f99-bebf-59183831125e",
 CellTags->{"p:17", "i:9"}],
Cell[14273, 515, 181, 4, 70, "CodeCaption",ExpressionUUID->"91940afe-674d-4de2-8197-1c1186c71523"],
Cell[CellGroupData[{
Cell[14479, 523, 289, 8, 70, "Input",ExpressionUUID->"ce8826dc-88f8-4746-829a-970cd73de2d1"],
Cell[14771, 533, 234, 6, 70, "Output",ExpressionUUID->"3e436103-4296-4972-9126-d3036dee1fbc",
 Evaluatable->False]
}, Open  ]],
Cell[15020, 542, 190, 4, 70, "CodeCaption",ExpressionUUID->"e807b086-12ac-4615-9187-c65c6a9d16f9"],
Cell[CellGroupData[{
Cell[15235, 550, 247, 6, 70, "Input",ExpressionUUID->"1680e0d6-1197-4d9c-9fd2-469e94b7c7ed"],
Cell[15485, 558, 305, 8, 70, "Output",ExpressionUUID->"d433e31c-2b92-45be-aa6c-bff303094cf9",
 Evaluatable->False]
}, Open  ]],
Cell[15805, 569, 253, 8, 70, "Text",ExpressionUUID->"a2931965-bc72-4af5-a214-123a38fe3364",
 CellTags->"i:10"],
Cell[CellGroupData[{
Cell[16083, 581, 289, 8, 70, "Input",ExpressionUUID->"e6ef39c2-4892-4b14-9816-e164769ac999"],
Cell[16375, 591, 234, 6, 70, "Output",ExpressionUUID->"93c08b90-d53f-4f92-9c61-d7716d1baf20",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16658, 603, 159, 4, 70, "VocabularySection",ExpressionUUID->"67428668-ba77-4511-af74-6b4945b15a51"],
Cell[16820, 609, 3682, 108, 70, "VocabularyTable",ExpressionUUID->"fa19262b-b6ef-4d93-8eee-1c6e9fa9d349"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20539, 722, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"aefa32e4-8737-4a6a-a68f-a80de57fbcb7"],
Cell[CellGroupData[{
Cell[22344, 772, 1454, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"7f906fc7-8bc9-45f6-9601-398955558a35"],
Cell[CellGroupData[{
Cell[23823, 821, 718, 20, 70, "Exercise",ExpressionUUID->"71df9fed-19a6-4239-bf45-0b940aaff4f1"],
Cell[24544, 843, 1407, 39, 70, "ExerciseOutput",ExpressionUUID->"386aa3d6-0764-43d7-831a-c9f5ab8491a8"]
}, Closed]],
Cell[CellGroupData[{
Cell[25988, 887, 703, 20, 70, "Exercise",ExpressionUUID->"e651c269-abcf-43c7-9703-7c048cdf3d00"],
Cell[26694, 909, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"29da07e2-c85d-44ff-9932-972743a7ce45"]
}, Closed]],
Cell[CellGroupData[{
Cell[27800, 945, 715, 20, 70, "Exercise",ExpressionUUID->"ec338b9f-d10a-427e-8917-842a07140f36"],
Cell[28518, 967, 3210, 77, 70, "ExerciseOutput",ExpressionUUID->"af301c8d-0498-413d-817c-9cdcdd33a8c1"]
}, Closed]],
Cell[CellGroupData[{
Cell[31765, 1049, 1045, 37, 70, "Exercise",ExpressionUUID->"fef594e9-0049-44be-8b23-0e65552c7f67"],
Cell[32813, 1088, 1342, 38, 70, "ExerciseOutput",ExpressionUUID->"4050b21d-ee93-48e2-bc31-0f26342d2e5c"]
}, Closed]],
Cell[CellGroupData[{
Cell[34192, 1131, 959, 30, 70, "Exercise",ExpressionUUID->"425fff1c-fa6a-4bc0-928b-4e7bd8b7419d",
 CellTags->"LastCellOfAPage"],
Cell[35154, 1163, 1444, 40, 70, "ExerciseOutput",ExpressionUUID->"9afbf14b-d843-41dc-96c7-6f6306f691c4"]
}, Closed]],
Cell[CellGroupData[{
Cell[36635, 1208, 787, 21, 70, "Exercise",ExpressionUUID->"8f933998-3669-4b59-af37-a9bd4ae66364",
 CellTags->"p:18"],
Cell[37425, 1231, 1403, 39, 70, "ExerciseOutput",ExpressionUUID->"81c55ba5-4a73-4425-a18f-76d385ce80d6"]
}, Closed]],
Cell[CellGroupData[{
Cell[38865, 1275, 699, 20, 70, "Exercise",ExpressionUUID->"a0121b2f-0daa-40e0-86f2-1a1808c2ea0c"],
Cell[39567, 1297, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"1dbeaf1a-20cf-413d-8315-c2af91f36672"]
}, Closed]],
Cell[CellGroupData[{
Cell[40671, 1333, 693, 20, 70, "Exercise",ExpressionUUID->"6d9828e9-91bf-434a-92a7-25b5b56c1581"],
Cell[41367, 1355, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"28915d96-d60b-4af9-9049-b89f48b6612a"]
}, Closed]],
Cell[CellGroupData[{
Cell[42469, 1391, 698, 20, 70, "Exercise",ExpressionUUID->"e49c543c-74c7-4d99-9abc-7d72dd6dba54"],
Cell[43170, 1413, 1391, 39, 70, "ExerciseOutput",ExpressionUUID->"a9f9ba45-a634-4983-8ab2-1c8cbe87acca"]
}, Closed]],
Cell[CellGroupData[{
Cell[44598, 1457, 709, 20, 70, "Exercise",ExpressionUUID->"7020654d-63f4-4b2e-81bd-0043933cb012"],
Cell[45310, 1479, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"f0b3444d-d132-4cf6-a6ae-99d8350eddf1"]
}, Closed]],
Cell[CellGroupData[{
Cell[46412, 1515, 716, 20, 70, "Exercise",ExpressionUUID->"7a25fab5-31a7-479c-8887-1620e58361af"],
Cell[47131, 1537, 1067, 31, 70, "ExerciseOutput",ExpressionUUID->"f41894a1-d267-4537-8b5c-f08ccd0b6203"]
}, Closed]],
Cell[CellGroupData[{
Cell[48235, 1573, 876, 31, 70, "Exercise",ExpressionUUID->"4d0241e8-351f-4dfc-bb3b-75fb102103d1"],
Cell[49114, 1606, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"9d340b91-84d3-40a5-99ff-b097cdfb0832"]
}, Closed]],
Cell[CellGroupData[{
Cell[50216, 1642, 729, 20, 70, "Exercise",ExpressionUUID->"2c3dd4d9-22e7-4b30-abfd-31ff4d52200c"],
Cell[50948, 1664, 3462, 84, 70, "ExerciseOutput",ExpressionUUID->"7ad55a73-6b12-4d14-a9de-9ff0997ad9ba"]
}, Closed]],
Cell[CellGroupData[{
Cell[54447, 1753, 981, 32, 70, "Exercise",ExpressionUUID->"e81e00b5-14bc-4a70-97a6-9a7b3ea1207a"],
Cell[55431, 1787, 1411, 39, 70, "ExerciseOutput",ExpressionUUID->"e13f3be6-b433-4c14-a3fd-2cd81ac2e9eb"]
}, Closed]],
Cell[CellGroupData[{
Cell[56879, 1831, 708, 20, 70, "Exercise",ExpressionUUID->"4dbe5cab-a5a7-470b-806b-30d0023be4be"],
Cell[57590, 1853, 1405, 39, 70, "ExerciseOutput",ExpressionUUID->"a66b7c74-3631-44c7-bdc6-6f84c8ec4b35"]
}, Closed]],
Cell[CellGroupData[{
Cell[59032, 1897, 812, 26, 70, "Exercise",ExpressionUUID->"81788da8-a3fb-4e7c-a315-3b7f1574badc"],
Cell[59847, 1925, 1407, 39, 70, "ExerciseOutput",ExpressionUUID->"7e4de56e-b65e-4807-ab00-811410f20d9e"]
}, Closed]],
Cell[CellGroupData[{
Cell[61291, 1969, 693, 20, 70, "Exercise",ExpressionUUID->"89c95fb3-75c2-4601-9b8a-53a61a8796a6"],
Cell[61987, 1991, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"d7317e26-cddc-4904-9120-d94a1f1e1f43"]
}, Closed]],
Cell[CellGroupData[{
Cell[63089, 2027, 703, 20, 70, "Exercise",ExpressionUUID->"fb1724e2-aa6f-4041-abdb-515268703a9e"],
Cell[63795, 2049, 1065, 31, 70, "ExerciseOutput",ExpressionUUID->"e3311919-d0c6-4582-99ce-85da75032d8e"]
}, Closed]],
Cell[CellGroupData[{
Cell[64897, 2085, 705, 20, 70, "Exercise",ExpressionUUID->"64e35bca-65e8-4337-82f9-b1c343d1eeef"],
Cell[65605, 2107, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"f7899a8a-6136-4d28-bcef-6021d487d9b5"]
}, Closed]],
Cell[CellGroupData[{
Cell[66711, 2143, 728, 20, 70, "Exercise",ExpressionUUID->"e8e52abc-1163-4f38-a7bb-99187a90e93b"],
Cell[67442, 2165, 62984, 1356, 70, "ExerciseOutput",ExpressionUUID->"bd964426-510a-4287-b094-95c1bba765bb"]
}, Closed]],
Cell[CellGroupData[{
Cell[130463, 3526, 738, 20, 70, "Exercise",ExpressionUUID->"46479eef-5d7e-42ae-8139-47c2090d5567"],
Cell[131204, 3548, 220818, 4682, 70, "ExerciseOutput",ExpressionUUID->"2d062882-44f1-4d09-839e-41058a864192"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[352083, 8237, 144, 4, 70, "QASection",ExpressionUUID->"e93d9943-d460-45fb-85a3-2c80d751e041"],
Cell[352230, 8243, 179, 4, 70, "Question",ExpressionUUID->"f37980da-589e-4019-b758-5a25718913ba"],
Cell[352412, 8249, 836, 28, 70, "Answer",ExpressionUUID->"6fca0b6b-0f84-4c75-9bb0-541e9b10a0fe"],
Cell[353251, 8279, 195, 4, 70, "Question",ExpressionUUID->"63b03bce-1b97-43c8-9977-d30523c50141",
 CellTags->"i:11"],
Cell[353449, 8285, 493, 17, 70, "Answer",ExpressionUUID->"a292f94f-2b2e-485b-b6c6-2a5a73ea8946"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353979, 8307, 157, 4, 70, "TechNoteSection",ExpressionUUID->"746bc76b-076e-4547-b129-13da2ab57863"],
Cell[354139, 8313, 931, 26, 70, "TechNote",ExpressionUUID->"194bc45f-0322-4294-8c1c-2d4b42441ceb",
 CellTags->"i:12"],
Cell[355073, 8341, 797, 23, 70, "TechNote",ExpressionUUID->"7f304f7b-4414-44fa-a5bd-81ecd3194ad8",
 CellTags->"i:13"]
}, Open  ]],
Cell[CellGroupData[{
Cell[355907, 8369, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"c9971f3f-21ae-4dc1-8126-328ae8463718"],
Cell[356075, 8375, 348, 8, 70, "MoreExplore",ExpressionUUID->"1feb0f6f-251e-420c-be83-3abef3a15911",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature YJjEDzYUXS#HkLOXJdCzUNAj *)
