(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    414288,       9002]
NotebookOptionsPosition[    334959,       7315]
NotebookOutlinePosition[    395828,       8566]
CellTagsIndexPosition[    395749,       8561]
WindowTitle->Operations on Lists: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Make a list of the first 10 squares, in reverse order.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"0f28a84b-802d-41fe-a598-6d96d62d8edb"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e3cbaac8-2389-453c-bbbf-9c78b31225a9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWa/vpUYQJ62pbNK/oH9A0bXImpJcU4e5S49LzZXcNWmwJBUkNVStQ6FQ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            "], {{0, 19}, {188, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{188, 19},
          PlotRange->{{0, 188}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{192, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "04894f52-68ed-49b8-907a-68fe6efc4f81"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWa/vpUYQJ62pbNK/oH9A0bXImpJcU4e5S49LzZXcNWmwJBUkNVStQ6FQ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              "], {{0, 19}, {188, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {188, 19}, 
            PlotRange -> {{0, 188}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ad3a980b-13a9-4342-9d05-252055d0d451"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.1"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f2bc80a1-0d64-4438-a197-1b84fb5d2f4a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f4424307-16e8-4ce7-8a1e-c1f94a5e4dc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"37f6f281-db89-4ea5-9b6b-c1b541f534a0"],

Cell["Find the total of the first 10 squares.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"b74ccfb0-3c0e-4e13-9841-a01cc9e9f42d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1b440e3c-abcb-43d4-a646-86039af396d1"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzlUaFu5DAQjVpy8KSqH9AfMD4aeMhSq7KQXd1udWQbbU+qloYFmi1bFGRk
FGQSFBJiEmJVISEGqeQCA4O9Gae7idr+QZ9kx36ZGb83c7N8vF1fRFH09AO2
28VzvN0udnc/4XK/efr7sFn9+b35t3pYbX8tL4G8gnUNC8/Hbw5naim4KOu2
n0g/NFXJuWi64URZrSa0vcWoXtIIQcJO88pjwXYXOBrjJ5NdeKUJtxPyOqSX
Mck05hxlDv/j2h5tw/AQnpVQiLABIwWQlfFHP+KjiaHKZumZCaTBfEwPJFWf
stCV6VXFE5C0LuwoCQqlhe4VKIrzCmPUHv0kaZru9ry2s+z9yRVrxkbZw+ST
yKDDaR5HlHEhDqExa+5mArwzJcP3ReerjEQk186btkyhpySbjQTRiXS0CVWn
Il7F2NEXRiJa6BPHxkjvJttGvnephDJkJ9t+MJ3IcYaFfuVrFCe1cSAJyUS9
taAsYWVnjK4LdEYP8LjrmywhZ5us1KPPnJ69U65wbq3cT/2gmZr1zjs7DPbD
TL4ivbWDdV8N7/vhP4jYz7Q=
            "], {{0, 19}, {21, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{21, 19},
          PlotRange->{{0, 21}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{25, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b66fdee9-4521-4da5-8fb3-9e9457b3e37e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzlUaFu5DAQjVpy8KSqH9AfMD4aeMhSq7KQXd1udWQbbU+qloYFmi1bFGRk
FGQSFBJiEmJVISEGqeQCA4O9Gae7idr+QZ9kx36ZGb83c7N8vF1fRFH09AO2
28VzvN0udnc/4XK/efr7sFn9+b35t3pYbX8tL4G8gnUNC8/Hbw5naim4KOu2
n0g/NFXJuWi64URZrSa0vcWoXtIIQcJO88pjwXYXOBrjJ5NdeKUJtxPyOqSX
Mck05hxlDv/j2h5tw/AQnpVQiLABIwWQlfFHP+KjiaHKZumZCaTBfEwPJFWf
stCV6VXFE5C0LuwoCQqlhe4VKIrzCmPUHv0kaZru9ry2s+z9yRVrxkbZw+ST
yKDDaR5HlHEhDqExa+5mArwzJcP3ReerjEQk186btkyhpySbjQTRiXS0CVWn
Il7F2NEXRiJa6BPHxkjvJttGvnephDJkJ9t+MJ3IcYaFfuVrFCe1cSAJyUS9
taAsYWVnjK4LdEYP8LjrmywhZ5us1KPPnJ69U65wbq3cT/2gmZr1zjs7DPbD
TL4ivbWDdV8N7/vhP4jYz7Q=
              "], {{0, 19}, {21, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {21, 19}, 
            PlotRange -> {{0, 21}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0318df6a-0972-48e6-a1af-d2a88b35c505"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.2"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1456043d-fdff-4216-bf25-7847cd008b43"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c0593b3f-9c3f-4000-8732-693262b81a1f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8feb6405-1bd6-49ec-bd02-51f33318af93"],

Cell["Make a plot of the first 10 squares, starting at 1.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"68755a0b-8d38-4b72-adf1-608414df8897"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b5eed556-f2b7-4037-9f73-186de7768a88"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3b+L4+gdgPFN0qTMv5D/Im3KtBfSHtyRey9pFLgLb0jxFgfuXJkr3KhS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            "], {{0, 227}, {
            360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 227},
          PlotRange->{{0, 360}, {0, 227}}]], "ExerciseOutput",
         ImageSize->{364, 227},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f7e87733-2e39-44e2-b71c-19a4216276d0"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3b+L4+gdgPFN0qTMv5D/Im3KtBfSHtyRey9pFLgLb0jxFgfuXJkr3KhS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              "], {{0, 
              227}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 227}, 
            PlotRange -> {{0, 360}, {0, 227}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"19471d71-3265-470c-b2f4-175147fa83ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.3"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5db16c50-5bce-42af-8a80-6d38c85c03f9"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d1b016a7-b959-4bd3-9ec3-b18f4146c185"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2deb9b84-c662-46bc-ade8-286110b61433"],

Cell[TextData[{
 "Use ",
 StyleBox["Sort",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Join",
  FontFamily->"Source Sans Pro"],
 " ",
 "and ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " to create ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "4", ",", 
    "4"}], "}"}]], "InlineCode",ExpressionUUID->
  "9df57f5c-ac31-4ce7-9257-674628b691d7"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"11690a98-e0f9-4d4a-8283-4866151112b6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d53e1393-14ea-4442-97ea-cde3a1efe3de"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztly2P2zAcxq2NDE7aJ9gXCB41HIp001jInXY5beBW3U2aSsMMzcyCgoKC
gkKCTEJMTAJCTAoMQgwCbn65rrktTdxeN3J9pFRJ+mscP/6/uO+vvl/ErwAA
92/0x8XlT3h3d7n+9FZffL69/3pze/3l4+2P65vruw9Xr/XNd/r4pg9z/nDW
WWed9RIlSxQHwYopd9m3jHX9sPQrD6wXtCzyvKB8cwJMbWhV5EVJuTgB9ijJ
m6aTyhvrsxjCKKGbx4n3jOj2EaNCDA9tvgZWiMqZZ/lgkuWBZdznKufPwQZR
hSMsRPXksnliv0WxwQNEZ6kxNvAyjUY/6RsMAHbud1WWrAxJmjn3fLA204Mg
u/x6vYzTk4HliQ2ihEHSWi8qBAGAtD8ec1Jt7mIgJM1eaArjaQgC7GaumHFv
NAjXvuBZ9/ywXm7zWlK0fyKe2E6yTk6BCaQDFEZRACCecW8CYwSCgLgHm9Xf
OmmkGujjnidm1WDNJotlaBHrN4LVeWQKTTZjng/GTP6BshOZiaO97k1i3Dqm
nyzbaqWtHSf+qd0busLOY7qgHYL1es2d5mN+EXNjrUuzUCkEkOwptnuwweYy
KjiyJbYaD3Ja9yQ1ixfNhcoBmH5ztSmxYYturiHMYn1qW8sKYYyT0JW0qjsE
U8S2pUHyRJ8k1WhgZgoaW5qHD7ahpg9APLsR8cTUblcxMLi33ftgqs4IJgQb
odD4EKb13+7txRRP9UVKTUy2pkK4uqf0Fo7V5qt1VnPGhDIteq0LZlKOtkRe
mBJVZNOHVA1rGkppK4ejsVLXl2BdcSE3XYFMIGStOhobabApyeypH/bYKYjD
dj1XNSF4Itz0+mszu2DUlP0wRv6gbBgciynRJFGwRQJctu7Vj8NGMkUyTNkB
2NOea/d7aCYDTXBu4Rn9B2xQvZRP/t48Bzv63Tgxgegwl8UwJpNlWJhkABlb
6A4vBlM0Xdsi3ezuZCiOEz6Z8L1oxeLfwJeDqRKtVknaLgboWWf9S/0Cv1+W
8A==
            "], {{0, 19}, {106, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{106, 19},
          PlotRange->{{0, 106}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{110, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4f23f900-3cbe-477a-b21e-abe9f8e09b68"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztly2P2zAcxq2NDE7aJ9gXCB41HIp001jInXY5beBW3U2aSsMMzcyCgoKC
gkKCTEJMTAJCTAoMQgwCbn65rrktTdxeN3J9pFRJ+mscP/6/uO+vvl/ErwAA
92/0x8XlT3h3d7n+9FZffL69/3pze/3l4+2P65vruw9Xr/XNd/r4pg9z/nDW
WWed9RIlSxQHwYopd9m3jHX9sPQrD6wXtCzyvKB8cwJMbWhV5EVJuTgB9ijJ
m6aTyhvrsxjCKKGbx4n3jOj2EaNCDA9tvgZWiMqZZ/lgkuWBZdznKufPwQZR
hSMsRPXksnliv0WxwQNEZ6kxNvAyjUY/6RsMAHbud1WWrAxJmjn3fLA204Mg
u/x6vYzTk4HliQ2ihEHSWi8qBAGAtD8ec1Jt7mIgJM1eaArjaQgC7GaumHFv
NAjXvuBZ9/ywXm7zWlK0fyKe2E6yTk6BCaQDFEZRACCecW8CYwSCgLgHm9Xf
OmmkGujjnidm1WDNJotlaBHrN4LVeWQKTTZjng/GTP6BshOZiaO97k1i3Dqm
nyzbaqWtHSf+qd0busLOY7qgHYL1es2d5mN+EXNjrUuzUCkEkOwptnuwweYy
KjiyJbYaD3Ja9yQ1ixfNhcoBmH5ztSmxYYturiHMYn1qW8sKYYyT0JW0qjsE
U8S2pUHyRJ8k1WhgZgoaW5qHD7ahpg9APLsR8cTUblcxMLi33ftgqs4IJgQb
odD4EKb13+7txRRP9UVKTUy2pkK4uqf0Fo7V5qt1VnPGhDIteq0LZlKOtkRe
mBJVZNOHVA1rGkppK4ejsVLXl2BdcSE3XYFMIGStOhobabApyeypH/bYKYjD
dj1XNSF4Itz0+mszu2DUlP0wRv6gbBgciynRJFGwRQJctu7Vj8NGMkUyTNkB
2NOea/d7aCYDTXBu4Rn9B2xQvZRP/t48Bzv63Tgxgegwl8UwJpNlWJhkABlb
6A4vBlM0Xdsi3ezuZCiOEz6Z8L1oxeLfwJeDqRKtVknaLgboWWf9S/0Cv1+W
8A==
              "], {{0, 19}, {106, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {106, 19}, 
            PlotRange -> {{0, 106}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"94cba6b2-1333-4d83-a7a2-e3f14cfcfc71"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.4"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"498ad7d8-0200-42a3-9725-0f09c11655b2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9dba14d1-1360-4bcb-9d05-f6393c196559"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"73580afe-307c-4e73-b044-3b8e1834adf4"],

Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " and ",
 Cell[BoxData[
  StyleBox["+",
   FontFamily->"Source Sans Pro"]], "InlineCode",ExpressionUUID->
  "b0bfb7b7-9093-41e3-8e06-044c39602f49"],
 " to make a list of numbers from 10 to 20, inclusive."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"f9acd2a0-c5a5-4383-a90b-e47ba2dd13f2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b4af44c4-c21b-4539-8c15-4aaf7210a216"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWjGvpDYQRkmTMlJ+Qf4AdVrKVEgXpdvmTjlOaS7oLlJES+eSjo6KioqK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            "], {{0, 19}, {222, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{222, 19},
          PlotRange->{{0, 222}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{226, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "85cb1aca-b98b-4263-ac6d-5ac270d5dc81"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWjGvpDYQRkmTMlJ+Qf4AdVrKVEgXpdvmTjlOaS7oLlJES+eSjo6KioqK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              "], {{0, 19}, {222, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {222, 19}, 
            PlotRange -> {{0, 222}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3fa4b30f-b99c-4840-b87d-8303d893e838"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.5"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3d4cd4bd-3788-4855-acf3-8155268378a4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9655750b-54f1-40f8-b975-e2ccc4152454"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b9bd1637-93d4-469d-b986-197b18ba344f"],

Cell["\<\
Make a combined list of the first 5 squares and cubes (numbers raised to the \
power 3), sorted into order.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"e489dc44-8426-4e60-9bcd-c86bca7f2b36"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c1893f84-7399-43c9-9ae4-098fdc7fdd96"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK2vpUYUJ62pbNK/oH9A0bXImpJsU4fZTR+bmi3ZbdJgSSpIaqgah0KR
NEGhMCgMZirGIEgTDAKBQYx4nXMG7r28OwO8txWbhpM8ci/3nDlfv/Mx7+s3
v7xyPzMM48MX4vHq9W/W+/ev/R++FF9+fPfh57fvHn767t2vD28f3n/75nPx
8ivx95f4g8+PJ5100kknnXTSSVs05KFrmh6d5NexobQd+Z7UQTY4n9V1O0wb
HB2tsjTNK7bF9DjWBXCJs15gW8/qPE2zoh42TB67Khcqsor1t0ddiHXjcdn+
VhKlN6LFh7YU4lnO+lUMeN/U9Zag0t+hpcJZ4W179fbekTFxLcsJqn7mGSkR
q6MbZh1/bFLfQAqrrWgfZJNURbbgNMNK8/tUhJZgsGx4Gl6mBgNvkcswTXj6
efss2yriGFfyG1VgB5ri2YZ8eilD62rrRtLQeKGSHSPTWJNZanA0suSWL7kW
RBugYKUH4L2/dexeI2VYRcc1jnCWx85NasY6MoxI6m6LJPAgcaTeSvFBNtDf
pFKzTWpNFCphYVB04uNQRTqvuwL8TSGFPPOFj54OCgrbuhwMCEsQ7sqQlMoK
axIRlbBDmxKIZdgDfyaCWYqq4ZLUSpWyi4iQ6UJhsptqOt4QWYhP+HlIQ3IB
Qj0D2K71SLjzd4qtJdpDJeStCD7rHGGxbZjRLEkBCTeqmDg32kvxMTaMgOU4
5myPgkbAql/iOZxaGiTUIliLwTKzMdNHZ21bk4rcOGx/jo3D0mCHKhR2C0uw
TGz6ItkLDXCIkXdqScyRqNGn7nAsItv3RWI3egLSyl8+XibxGC1I0DlCiQgs
kccDni9BfpzbyD4SDrBR6D1G3nYJ4E6DhMceO5RbsLaCtua3qrADEoxwVjaU
O6pXtvHcM8ygaFkREyK2jJ2gXtUF3TI6TcfzPJ+kewlZyy40EsB6oeOXOSqZ
aNVxnORsnuw9FJEZ9SO117hSkDYXXWDMkdc5wjD74uvQFJ6Aze34+4+QwNsM
BzqERPQrizAdZ5t5l/FlJ41aW5OgIwEhgZx/ZCOlK9tGYs9n+wEqsuNt36Tl
bsJQbypKMkqzLMZxrO3wCtn5DZZ2qsS3tA9zBFJ+4Jg42XtZRLIViD5p7TQl
TS7wEDPHPUHniDQvzFiIu0Ux7B97UPvFvxjj74VRFAW23BQKxWyfWAw7Eu35
2CQ+MGaaoA1NGQW+H5CyyqBBHO0JWJLOnH0M+2aJ4Ww1nOSeBRH7bFkG6Qg0
k+FiklyBBDVCx/d//CmhG5EoRPS6fli0egyqctEVkFs/U1TW2pGJYGnxgUGN
BTe9i1MYOnSvEe6wTWVCIkIioNA2sRRLBRJgYzGC5ZQhNPQbxeVoHLtZt3El
W9kG7doicwm06VY2+wrWPSu63CH5dNXSF8GzZJGwIvx8o6YnQIJZzmkcRV6+
+V3ETgQPoxfOSCg3kHCXixZh4Mb0yqJxRFZiXAFUm1SAVu4JE1w5S/jJT0pG
aTfBVUOs6laQ39hxkO1qBU4HtOqOrQOrRHei4zQ1JcHdqb9n433pOUHJ2qZO
oXF4GVedprRNThYvqYahwQuWh1eQp7JTV8hNnRQ1reuqqpr+b/HGifK275sq
sRDOo0qvQnYe99CRVthW2AzT3HAI6/sar4SrZRi2aKvmOlmFv02GV0/DK6m0
hQ4TUzsyb4lzmVzvDlNtGyuKxCyeKPho3lwuDrJdCaJhS3wq2HhJ3MtRrrzi
3bFxUXHL9dx0yTxADtomOs8cHAhBJuN8J0vJE1HAJCvI9RpuB3PZHZKVRd76
T7qcKlB8ARImdN0SofMvjeiQv/8Qa/0KxLnakfXdAXfXcGMYQNNYmDfoo9j4
NA7DOO2wCZ4V02GlqAKkb4UPy/JR3BGnVYN/ht470shyjMDOffVj9CodYdCz
5gPlpLAuhbamLoc5ldCdBfJTZjtlNTRVeI+4aVlTlYSuGyj/6c/Hrum2b06f
Otspq6EpDz0viJuXtpiTTjrpf0z/AgCLXcA=
            "], {{0, 19}, {174, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{174, 19},
          PlotRange->{{0, 174}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{178, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5bf10e0d-a23f-4d6c-8818-b181e8b68b24"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK2vpUYUJ62pbNK/oH9A0bXImpJsU4fZTR+bmi3ZbdJgSSpIaqgah0KR
NEGhMCgMZirGIEgTDAKBQYx4nXMG7r28OwO8txWbhpM8ci/3nDlfv/Mx7+s3
v7xyPzMM48MX4vHq9W/W+/ev/R++FF9+fPfh57fvHn767t2vD28f3n/75nPx
8ivx95f4g8+PJ5100kknnXTSSVs05KFrmh6d5NexobQd+Z7UQTY4n9V1O0wb
HB2tsjTNK7bF9DjWBXCJs15gW8/qPE2zoh42TB67Khcqsor1t0ddiHXjcdn+
VhKlN6LFh7YU4lnO+lUMeN/U9Zag0t+hpcJZ4W179fbekTFxLcsJqn7mGSkR
q6MbZh1/bFLfQAqrrWgfZJNURbbgNMNK8/tUhJZgsGx4Gl6mBgNvkcswTXj6
efss2yriGFfyG1VgB5ri2YZ8eilD62rrRtLQeKGSHSPTWJNZanA0suSWL7kW
RBugYKUH4L2/dexeI2VYRcc1jnCWx85NasY6MoxI6m6LJPAgcaTeSvFBNtDf
pFKzTWpNFCphYVB04uNQRTqvuwL8TSGFPPOFj54OCgrbuhwMCEsQ7sqQlMoK
axIRlbBDmxKIZdgDfyaCWYqq4ZLUSpWyi4iQ6UJhsptqOt4QWYhP+HlIQ3IB
Qj0D2K71SLjzd4qtJdpDJeStCD7rHGGxbZjRLEkBCTeqmDg32kvxMTaMgOU4
5myPgkbAql/iOZxaGiTUIliLwTKzMdNHZ21bk4rcOGx/jo3D0mCHKhR2C0uw
TGz6ItkLDXCIkXdqScyRqNGn7nAsItv3RWI3egLSyl8+XibxGC1I0DlCiQgs
kccDni9BfpzbyD4SDrBR6D1G3nYJ4E6DhMceO5RbsLaCtua3qrADEoxwVjaU
O6pXtvHcM8ygaFkREyK2jJ2gXtUF3TI6TcfzPJ+kewlZyy40EsB6oeOXOSqZ
aNVxnORsnuw9FJEZ9SO117hSkDYXXWDMkdc5wjD74uvQFJ6Aze34+4+QwNsM
BzqERPQrizAdZ5t5l/FlJ41aW5OgIwEhgZx/ZCOlK9tGYs9n+wEqsuNt36Tl
bsJQbypKMkqzLMZxrO3wCtn5DZZ2qsS3tA9zBFJ+4Jg42XtZRLIViD5p7TQl
TS7wEDPHPUHniDQvzFiIu0Ux7B97UPvFvxjj74VRFAW23BQKxWyfWAw7Eu35
2CQ+MGaaoA1NGQW+H5CyyqBBHO0JWJLOnH0M+2aJ4Ww1nOSeBRH7bFkG6Qg0
k+FiklyBBDVCx/d//CmhG5EoRPS6fli0egyqctEVkFs/U1TW2pGJYGnxgUGN
BTe9i1MYOnSvEe6wTWVCIkIioNA2sRRLBRJgYzGC5ZQhNPQbxeVoHLtZt3El
W9kG7doicwm06VY2+wrWPSu63CH5dNXSF8GzZJGwIvx8o6YnQIJZzmkcRV6+
+V3ETgQPoxfOSCg3kHCXixZh4Mb0yqJxRFZiXAFUm1SAVu4JE1w5S/jJT0pG
aTfBVUOs6laQ39hxkO1qBU4HtOqOrQOrRHei4zQ1JcHdqb9n433pOUHJ2qZO
oXF4GVedprRNThYvqYahwQuWh1eQp7JTV8hNnRQ1reuqqpr+b/HGifK275sq
sRDOo0qvQnYe99CRVthW2AzT3HAI6/sar4SrZRi2aKvmOlmFv02GV0/DK6m0
hQ4TUzsyb4lzmVzvDlNtGyuKxCyeKPho3lwuDrJdCaJhS3wq2HhJ3MtRrrzi
3bFxUXHL9dx0yTxADtomOs8cHAhBJuN8J0vJE1HAJCvI9RpuB3PZHZKVRd76
T7qcKlB8ARImdN0SofMvjeiQv/8Qa/0KxLnakfXdAXfXcGMYQNNYmDfoo9j4
NA7DOO2wCZ4V02GlqAKkb4UPy/JR3BGnVYN/ht470shyjMDOffVj9CodYdCz
5gPlpLAuhbamLoc5ldCdBfJTZjtlNTRVeI+4aVlTlYSuGyj/6c/Hrum2b06f
Otspq6EpDz0viJuXtpiTTjrpf0z/AgCLXcA=
              "], {{0, 19}, {174, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {174, 19}, 
            PlotRange -> {{0, 174}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0bb34294-0676-4c7a-88e3-78a19bbcc6ae"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.6"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4c581d89-2f5e-4be2-9dd3-6e4916e9f5fd"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"31ee6783-f0a9-4408-a95d-2305113f439a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2aec09e6-318b-49f5-aece-c0c0ff42f94f"],

Cell["Find the number of digits in 2^128.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"d67f04a9-3e4e-480a-962d-ab5e2dcb80d4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"912ece38-7b23-4c0a-a352-f145afacc375"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVkKFuwzAQhq2NDE2T9gR7AePRwKFKncZCWi2pRrKqnTSFmhmGhQUFBQUZ
mRiFmISEBISYBBiYBARk56Rtsr5BT7J1/vTf3X9+2X6v/TuE0PEBrvXm1zkc
NuH7Ezw+guPXLvA+34Ifb+cdXrf3AJ/hPMKx+XBD0bUFz7OcFZW6sF7XE1Pm
TBRfIRt4vFdU9FBaZXjBRNuPSuZgUtt04NRByClMl0IxpnaAKX1IibhyoQUZ
lSZ2EI7kBKvERYhcbJlWlSIDhPzUDDrGs1LxqfwkhCZTRFLDW8bW+57GEXFH
7Eozj+67lkWW543dqWQpCUOaMMkpLCU7+0fdrC6hNy300jwPYXgCGraH3UJe
Kd02ObVD0xo+ifg0r1UjUtAhKlrbUUni4pNL2IPVdt+cngkKU7kc0XdGa9P/
R/oa3Ub8ATR5jsQ=
            "], {{0, 19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3fb5662c-49e8-4988-89b9-7018a2c0a379"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVkKFuwzAQhq2NDE2T9gR7AePRwKFKncZCWi2pRrKqnTSFmhmGhQUFBQUZ
mRiFmISEBISYBBiYBARk56Rtsr5BT7J1/vTf3X9+2X6v/TuE0PEBrvXm1zkc
NuH7Ezw+guPXLvA+34Ifb+cdXrf3AJ/hPMKx+XBD0bUFz7OcFZW6sF7XE1Pm
TBRfIRt4vFdU9FBaZXjBRNuPSuZgUtt04NRByClMl0IxpnaAKX1IibhyoQUZ
lSZ2EI7kBKvERYhcbJlWlSIDhPzUDDrGs1LxqfwkhCZTRFLDW8bW+57GEXFH
7Eozj+67lkWW543dqWQpCUOaMMkpLCU7+0fdrC6hNy300jwPYXgCGraH3UJe
Kd02ObVD0xo+ifg0r1UjUtAhKlrbUUni4pNL2IPVdt+cngkKU7kc0XdGa9P/
R/oa3Ub8ATR5jsQ=
              "], {{0, 19}, {14, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f4b3cd3e-ebd2-474a-bb3b-e4cfc4a16eaf"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.7"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dd628164-e894-4b4f-bf68-27f88953c882"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"999e1db1-80c7-4702-9552-47f6d26471f5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fe835b54-0148-4f4e-9458-f7b324fb90b6"],

Cell["Find the first digit of 2^32.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"2d7c8383-9f18-4368-a246-b812f8540b25"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c024e42e-58b3-4e37-9b2e-ab078aa98de5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+T1vw7vrZsw/efUcWOjHRH2ivXucJuMj3O6sZwMB/xlmY2NNO
PQYGx5gYPQbHiVDBS/NjgGq2P3i61J9BDyz4+8FGoEjl9qdA9nxHBscZ10EM
kPEMBZ0TJ05s8oeYuvfBoaUzJs6YMREEOv31QILzDz1ActRvsPZLqI7/NMMR
qA5NkLYAAIm/U3w=
            "], {{0, 19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "333e3d69-a3b6-4c12-9ab5-1f702e7cfeb4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+T1vw7vrZsw/efUcWOjHRH2ivXucJuMj3O6sZwMB/xlmY2NNO
PQYGx5gYPQbHiVDBS/NjgGq2P3i61J9BDyz4+8FGoEjl9qdA9nxHBscZ10EM
kPEMBZ0TJ05s8oeYuvfBoaUzJs6YMREEOv31QILzDz1ActRvsPZLqI7/NMMR
qA5NkLYAAIm/U3w=
              "], {{0, 19}, {7, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bf9abc1d-554e-45a0-8825-9a39beaef582"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.8"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ddd0f06a-cd86-4583-b36d-00eff805b730"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f88d7bbd-d8c4-4bf1-af2b-9f42ec74b67a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"59fdc142-62bf-4d13-b9f4-7a25d94ac368"],

Cell["Find the first 10 digits in 2^100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"002e2a79-5205-463c-841a-43c0871b051f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7725b69f-3e31-493e-9558-a4a5158f2afb"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK+P4zgUjvbIwpX2L7h/IHip4aFKezpWsqubrI7MRrMnnUqjI4FhYUFB
QUVBIUUmISYmBiYhAQEmAQZz7zntNL3aqWd67PKkVm77+Xv2+53+/PX75+hd
EAQ/3sPb5y9/kaenL7tfP8CH3x5//PHt8eH3Xx7/fPj28PTp60/w5Ud4/Q0v
XD+vssoqq6yyiq8MdRqFYczG6aMSjEmll3aojtb7qtpT3i9T60EeALmveT9a
AWMv2aVIB9KHDSAdn3Fx6eR6fpZtU5VV08o7r/AqtkuYKiNCtgntj9ZWLIcm
HqX7Tj+LahcYSengYhtYFRrM9B5X3IVUvAxmUnLLXVhGgksJs/bNbIDKwjmK
tMp+tjbfvtxhW9g1eiv1ZbuCaV4X8FWY0qO6NguCbNIhmzKJN4DMW6cvRAm7
085sLSP0myM3BmPmnUDqoUpzxz20HjUIrFgBqjcO63myqZwEm4Ih7ZHViqJA
tsnRaBR5N8zO5qfUk80B43DrMJvMPTL0xcwAHCySuX0BpMOpgg00hdijNuvp
bm/yyxGXlg0cfLwt7VnmzdbDgXK+WGDxylgKmimGujrA+1qYPZV6srlgDKIn
zKcNGOcnv5g9Lbnhi7O06N+ks/1k0m1z4JCFRVHWfLhhH1lBjkXCgfJlUy1m
dbiNoyjJSt7bYQJ1ndJZi8hhPU+lnmwuGDf2h9Ugmhgi+1SvULx9oSWGTeSI
5KkNIWCXbLFCkmapz0toVKa22MWXTYuEhFFa1HUZIWxj7XsYQqdQhAsXJCC5
RbWnUk82F0yLCrNvz1PTS5r5gT19MVDsQ9vSlcDTRapjoIt40dRTzpbCOai8
ju14wkPoGEIwRM+lQAJbaruvp1JPNjdszE031wNPYJE05z2aYb9gi0Wyp9i0
SbYQ6aY8hoejbgXqXAMSnqyGtNg6Guir2Gbt2vRKq1lGPmPrG5xVbPf1VOrL
5oCNvIB1QbHSiwoCfPLXCE8W7IA/7coDzOndiC11FwYkqV/sNHaNmcyCvGlZ
21JKBRTSKxjEeoKJk/O+b82oXHBlg6Fc5q9FqSfbHgtuQkXXyzbDU4Z1Zzub
KddQXmUvC1zF8g6lvmxW2LFf5xPsPEeNpvHNBJvLyMydzoMWy/+FMnXgCobK
T14zzm0nZdewIyeZ+eKtbEoedufTkYL2LjbFq9ODDdkLdY9SfzYL7HKOMtNC
ulCSMHHmQfs6mFbDoEZ9C/ZfsukRpu6LPw7sbEB2Hs/vvoIn2xWM5+QlDqd6
RaJc2ka2ro6xq7IbrXyFvQk20mJnGm97/qZMYR63PlRq1Ylu6X+YFXYHbKzT
OE4KcbNMrLLK/1X+AcZHehs=
            "], {{0, 19}, {132, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{132, 19},
          PlotRange->{{0, 132}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{136, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "232055f3-1b4d-4fe7-a06e-f289d751e684"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK+P4zgUjvbIwpX2L7h/IHip4aFKezpWsqubrI7MRrMnnUqjI4FhYUFB
QUVBIUUmISYmBiYhAQEmAQZz7zntNL3aqWd67PKkVm77+Xv2+53+/PX75+hd
EAQ/3sPb5y9/kaenL7tfP8CH3x5//PHt8eH3Xx7/fPj28PTp60/w5Ud4/Q0v
XD+vssoqq6yyiq8MdRqFYczG6aMSjEmll3aojtb7qtpT3i9T60EeALmveT9a
AWMv2aVIB9KHDSAdn3Fx6eR6fpZtU5VV08o7r/AqtkuYKiNCtgntj9ZWLIcm
HqX7Tj+LahcYSengYhtYFRrM9B5X3IVUvAxmUnLLXVhGgksJs/bNbIDKwjmK
tMp+tjbfvtxhW9g1eiv1ZbuCaV4X8FWY0qO6NguCbNIhmzKJN4DMW6cvRAm7
085sLSP0myM3BmPmnUDqoUpzxz20HjUIrFgBqjcO63myqZwEm4Ih7ZHViqJA
tsnRaBR5N8zO5qfUk80B43DrMJvMPTL0xcwAHCySuX0BpMOpgg00hdijNuvp
bm/yyxGXlg0cfLwt7VnmzdbDgXK+WGDxylgKmimGujrA+1qYPZV6srlgDKIn
zKcNGOcnv5g9Lbnhi7O06N+ks/1k0m1z4JCFRVHWfLhhH1lBjkXCgfJlUy1m
dbiNoyjJSt7bYQJ1ndJZi8hhPU+lnmwuGDf2h9Ugmhgi+1SvULx9oSWGTeSI
5KkNIWCXbLFCkmapz0toVKa22MWXTYuEhFFa1HUZIWxj7XsYQqdQhAsXJCC5
RbWnUk82F0yLCrNvz1PTS5r5gT19MVDsQ9vSlcDTRapjoIt40dRTzpbCOai8
ju14wkPoGEIwRM+lQAJbaruvp1JPNjdszE031wNPYJE05z2aYb9gi0Wyp9i0
SbYQ6aY8hoejbgXqXAMSnqyGtNg6Guir2Gbt2vRKq1lGPmPrG5xVbPf1VOrL
5oCNvIB1QbHSiwoCfPLXCE8W7IA/7coDzOndiC11FwYkqV/sNHaNmcyCvGlZ
21JKBRTSKxjEeoKJk/O+b82oXHBlg6Fc5q9FqSfbHgtuQkXXyzbDU4Z1Zzub
KddQXmUvC1zF8g6lvmxW2LFf5xPsPEeNpvHNBJvLyMydzoMWy/+FMnXgCobK
T14zzm0nZdewIyeZ+eKtbEoedufTkYL2LjbFq9ODDdkLdY9SfzYL7HKOMtNC
ulCSMHHmQfs6mFbDoEZ9C/ZfsukRpu6LPw7sbEB2Hs/vvoIn2xWM5+QlDqd6
RaJc2ka2ro6xq7IbrXyFvQk20mJnGm97/qZMYR63PlRq1Ylu6X+YFXYHbKzT
OE4KcbNMrLLK/1X+AcZHehs=
              "], {{0, 19}, {132, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {132, 19}, 
            PlotRange -> {{0, 132}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fe2e2adc-cbcc-42bf-9028-858c8a27ed2a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.9"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f80b53af-e458-440a-962c-765fbd1106b4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8a531ce2-4c99-480a-b0a2-a5f927ccd845"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1e00f48b-8792-4d2e-ad8a-0ae55382b12d"],

Cell["Find the largest digit that appears in 2^20.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"c6a75607-7d6d-4a27-99bd-b1209f98f730"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"525661a1-9d20-4248-98e0-e0d70eddeb2b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJy1Ty0PwjAUbECAJOEX8AfQ2EnUEggOw8JKMIMMEjI7N4mbm5pCVaFmpmpm
ZmYmZmYmKmoqKsY1fPwDLnkv9+7yeq8z57SiA0LIZYy22t0s398F6wmGjXc5
Hjx3v/Su7sH1F84Q4hQ1Qhne/w1tydnj8eSV+ggqiywkWrbp5MyMLjmGMGtB
Bb8TMucSYgExyIVZ0qX1Fvsu2cKnWdXwhMJvtPEbdiZf2GltYqoEPC07Les0
sMFZo6sEJJSfS0SEM+5Fm4VwI1ZKpeo8Npx3iMxj+nuTxrn+fUkrKYRU/f/w
AiMXQ6k=
            "], {{0, 19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0f30722c-7365-4533-b179-bbab281bc460"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJy1Ty0PwjAUbECAJOEX8AfQ2EnUEggOw8JKMIMMEjI7N4mbm5pCVaFmpmpm
ZmYmZmYmKmoqKsY1fPwDLnkv9+7yeq8z57SiA0LIZYy22t0s398F6wmGjXc5
Hjx3v/Su7sH1F84Q4hQ1Qhne/w1tydnj8eSV+ggqiywkWrbp5MyMLjmGMGtB
Bb8TMucSYgExyIVZ0qX1Fvsu2cKnWdXwhMJvtPEbdiZf2GltYqoEPC07Les0
sMFZo6sEJJSfS0SEM+5Fm4VwI1ZKpeo8Npx3iMxj+nuTxrn+fUkrKYRU/f/w
AiMXQ6k=
              "], {{0, 19}, {7, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3bd6bfd9-2284-4e63-a9b0-433edf1cf986"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.10"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"94e9f014-bc55-4ca7-bbe7-53f1fbd2dcc6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a85dfac3-0b59-486c-8c37-55acf4cbed68"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"941e34ae-ddfb-4b1e-a7f1-09a31fb98bcd"],

Cell["Find how many zeros appear in the digits of 2^1000.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"56aca05e-5860-4960-92e7-5275c7c48fcc"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bccae481-5f25-4dc7-b9f2-5d6a4145f69e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVUC1vwzAQPW1kaJq0X7A/EDxqOBSp01hIqyXVSFe1k6bSMEOzsqGgoKKg
kCITE5MQg5CQAAMPGAR0Z7vr1z/oSWefn97du+enyecouwGA5R0eo/E3WSzG
q9cHfLzNlh/TWfr+MvtKp+nieXKL4CPmPaard1cUpuPVpiw3vOmP4KDFtkJQ
tDoAWpYRuAjnvGwcapuVx2LirrxuEVNFAkA7P7rIEKY41wgGQLgfVmNPxHxp
tBn28zl1BBOYeVild1Smz/cVDMVynD90FVZkXqhOUgKEbk9pQ7tB7axogskf
v2FwUJ8YRWFcF5LC+Nc2jyCiyg59U83RapR3gdZzZ4Ww/1bNIogLtdeSLCxv
uzrxGutaSCE450r/lq4zq1VvbV/RGMWk3cl1DOdB8Xesokc4LuWF9csYrNGH
H7ye+AMzvInj
            "], {{0, 19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b3aa5ae9-a394-4aea-8cd6-52d427a76a9f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVUC1vwzAQPW1kaJq0X7A/EDxqOBSp01hIqyXVSFe1k6bSMEOzsqGgoKKg
kCITE5MQg5CQAAMPGAR0Z7vr1z/oSWefn97du+enyecouwGA5R0eo/E3WSzG
q9cHfLzNlh/TWfr+MvtKp+nieXKL4CPmPaard1cUpuPVpiw3vOmP4KDFtkJQ
tDoAWpYRuAjnvGwcapuVx2LirrxuEVNFAkA7P7rIEKY41wgGQLgfVmNPxHxp
tBn28zl1BBOYeVild1Smz/cVDMVynD90FVZkXqhOUgKEbk9pQ7tB7axogskf
v2FwUJ8YRWFcF5LC+Nc2jyCiyg59U83RapR3gdZzZ4Ww/1bNIogLtdeSLCxv
uzrxGutaSCE450r/lq4zq1VvbV/RGMWk3cl1DOdB8Xesokc4LuWF9csYrNGH
H7ye+AMzvInj
              "], {{0, 19}, {14, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b9bf1801-a2be-43d4-b246-faf71a40f19d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.11"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f18729df-5df2-4e98-95a7-43b2ae414a79"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bbc4f16c-2f17-4776-9ba0-b63bde386b67"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"22d6c7e7-34ca-417b-ba44-a6b735c9a6d8"],

Cell[TextData[{
 "Use ",
 StyleBox["Part",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Sort",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["IntegerDigits",
  FontFamily->"Source Sans Pro"],
 " to find the ",
 "second-smallest digit",
 " in 2^20."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"1edd2c65-094c-4cd1-84a1-856e2609d12c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7470fd00-a6ad-4064-85e0-70a7d52d82bd"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+T0Pw6c6lSw8+/Ybz76yuZACDzhPv4IIP9i5tKvAHCs44+w5V
+3Wg6EQ0we9nHSkR/H0JZOalT3BFQBdeOjQfaHvl0kPXL116+h2k0Z8BBUw8
++k/vQAApzZj0w==
            "], {{0, 19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "dbc829b4-deb8-4577-96a7-f881ebb95a2a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+T0Pw6c6lSw8+/Ybz76yuZACDzhPv4IIP9i5tKvAHCs44+w5V
+3Wg6EQ0we9nHSkR/H0JZOalT3BFQBdeOjQfaHvl0kPXL116+h2k0Z8BBUw8
++k/vQAApzZj0w==
              "], {{0, 19}, {7, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"34d8340b-ddaf-4ea3-8d21-98ed37043461"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.12"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bb37d13a-bbc9-426b-959a-8f53b4a54381"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3bed3ac5-feba-4f5f-8f70-f96443ec1510"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8117c0bf-572b-479a-849b-5f403330add0"],

Cell["\<\
Make a line plot of the sequence of digits that appear in 2^128.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"4dd62a6b-61bd-48b4-9051-9bb9d297d306"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"357049ac-8d40-4b5b-ae82-7c3882f23d4b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndtbFNfW7tfe++a73P/C/i/27b7ct99+9q0m0XQ0K5LERLKSSKIEPOAR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            "], {{0, 234}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 234},
          PlotRange->{{0, 360}, {0, 234}}]], "ExerciseOutput",
         ImageSize->{364, 234},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7b8bcae3-e07c-4b16-a789-b9cac349b684"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndtbFNfW7tfe++a73P/C/i/27b7ct99+9q0m0XQ0K5LERLKSSKIEPOAR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              "], {{0, 234}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 234}, 
            PlotRange -> {{0, 360}, {0, 234}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c1cf991a-4f7e-4dbd-8e14-71f253ed6e94"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.13"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e8500323-9e87-4540-be27-a734de52398d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"499a04a2-230f-4e63-b1b3-68b3e19b3d84"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0841c869-908a-4b34-a2f9-8bb0c32bd443"],

Cell[TextData[{
 "Use ",
 StyleBox["Take",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Drop",
  FontFamily->"Source Sans Pro"],
 " to get the sequence 11 through 20 from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Range",
    FontFamily->"Source Sans Pro"], "[", "100", "]"}]], "InlineCode",
  ExpressionUUID->"47051841-d2c1-4211-a80f-3975111ffa0d"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "5.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"4e09ec11-12c6-4193-a2a4-cc93e1631cc5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5411747d-9c70-46e7-a326-b1517a525d55"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWT3PpDYQRkmTMlJ+Qf4AdVrKVEgXpdvmTjlOaS7oLlJES+eSjo6KioqK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            "], {{0, 19}, {202, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{202, 19},
          PlotRange->{{0, 202}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{206, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e9d91483-a554-408c-88d8-884b17e4eca2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWT3PpDYQRkmTMlJ+Qf4AdVrKVEgXpdvmTjlOaS7oLlJES+eSjo6KioqK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              "], {{0, 19}, {202, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {202, 19}, 
            PlotRange -> {{0, 202}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6c0c7144-6bdc-482e-817b-132e92b58567"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["5.14"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bcac04c9-6baf-4a00-bcfa-e1cbc0bc860f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a4e91bb0-b370-4584-a554-1d6e7e420634"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"591275b0-d582-4921-9a6e-2f1247eab430"],

Cell["Make a list of the first 10 multiples of 3.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"2f6e0177-9724-48cb-b8de-a91c639cfa5a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"31725588-0498-45e4-80b9-610d30c7e6db"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWa2vpUYUJ62pbNK/oP8AuhZZRbJN3TW76bKpeSVvmzRYHBKHQ6FQiAaF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            "], {{0, 19}, {181, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{181, 19},
          PlotRange->{{0, 181}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{185, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2dad6eaa-473f-4335-8bee-45f6708c106c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWa2vpUYUJ62pbNK/oP8AuhZZRbJN3TW76bKpeSVvmzRYHBKHQ6FQiAaF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              "], {{0, 19}, {181, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {181, 19}, 
            PlotRange -> {{0, 181}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6eedb3aa-d220-4069-8d8e-51e8cd3bfa9c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x5.1"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"64957444-9fbb-4af5-9095-04c0b5b3dd58"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e1ef096a-5822-4f1b-b24b-63b3a546d461"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0dd853fe-ddf1-448f-83ac-0602d82cd914"],

Cell[TextData[{
 "Make a list of the first 10 squares using only ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Times",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"5cc35d3c-49cc-4e60-a991-785927c160c0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a968c590-6408-42f8-a941-1796a40ffc35"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWa2vpUYUJ62pbNK/oH9A0bXImpJsU4fZTZdNzZZsmzRYkopJaqgah0Kh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            "], {{0, 19}, {188, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{188, 19},
          PlotRange->{{0, 188}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{192, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cb190640-741f-4f5b-a685-5b105d77b261"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWa2vpUYUJ62pbNK/oH9A0bXImpJsU4fZTZdNzZZsmzRYkopJaqgah0Kh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              "], {{0, 19}, {188, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {188, 19}, 
            PlotRange -> {{0, 188}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a005aba0-70f0-4447-a24b-ad7a37c7eb2b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x5.2"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6c86192b-cbde-432a-a7b1-d4513ac2d03c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f9411651-0d8f-49a3-9012-c102800110e1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c03223be-f5a7-4949-a7bd-31f80f5df90e"],

Cell["Find the last digit of 2^37.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"43b40a29-eca7-42b1-8f2b-bea64bad2d8e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5bf89d72-e91f-4c8e-9f0e-d739610f0ac3"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+TyPw6emJ7RtXr9544voriMC7S6v1GEAAQhasvg4UvLM0hoGh
8ylYw9I0oHAnWPWnd59+Q3Wd6GRgcDzxCcXssxMdGRianiKJ/H6wEag5bel1
hNC7E0CjGWKWIrS+OgGywXHiK5jA96d7Y8COmbH37KWzZ0+cOHHn3e9LM/wZ
UEHniXfUDBm8AABqhFJ0
            "], {{0, 19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c1b2d83c-296d-40ec-8be2-d837bf1289c3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+TyPw6emJ7RtXr9544voriMC7S6v1GEAAQhasvg4UvLM0hoGh
8ylYw9I0oHAnWPWnd59+Q3Wd6GRgcDzxCcXssxMdGRianiKJ/H6wEag5bel1
hNC7E0CjGWKWIrS+OgGywXHiK5jA96d7Y8COmbH37KWzZ0+cOHHn3e9LM/wZ
UEHniXfUDBm8AABqhFJ0
              "], {{0, 19}, {7, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4e7dd594-a88b-4aaa-9aa9-2d57f4e614de"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x5.3"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4432e45a-80b9-4b8a-a14f-f9449c8dd44d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"09683927-31b9-4ffa-bcd4-2e76a5aa2ac9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4ccac265-62be-4113-821a-0c5083eeab15"],

Cell["Find the second-to-last digit of 2^32.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"f06819fb-62a5-4091-bc6b-b169de03dba2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3fbff65d-9856-42c5-859e-108723e66351"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+Tyvw6ezejatXbz/74B1U4PeDTkeghQx6eiCycvsDoNjTvZVA
9uo7v4HSGyuBEgVA0bMTHRn0JkK1Pd0OVDD/+ieQIEMnVPDdISBn4tl33+8s
BRkY0zRjRhPYVIYZZz+B5O8cmthUWdk049CJjSBtZ98hu+z72YlAlRuf/v79
6lBBTNOh6w/unF3tDxQq2Ahyx6sTaRCzgCanzXjwG8lL7969+/SdZiEGAgAs
n0iM
            "], {{0, 19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2f5524c1-be50-44a6-9503-55fb8c541ce3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+Tyvw6ezejatXbz/74B1U4PeDTkeghQx6eiCycvsDoNjTvZVA
9uo7v4HSGyuBEgVA0bMTHRn0JkK1Pd0OVDD/+ieQIEMnVPDdISBn4tl33+8s
BRkY0zRjRhPYVIYZZz+B5O8cmthUWdk049CJjSBtZ98hu+z72YlAlRuf/v79
6lBBTNOh6w/unF3tDxQq2Ahyx6sTaRCzgCanzXjwG8lL7969+/SdZiEGAgAs
n0iM
              "], {{0, 19}, {7, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"70406c01-6b2d-46fa-8113-b9b85ae8a301"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x5.4"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d1f7486e-9d27-4b3a-89d0-b3c131b93a7e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f9f83840-fef2-452d-b9c8-a7c40254e811"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"585c0d60-054a-4d78-93bd-788c613c4589"],

Cell["Find the sum of all the digits of 3^126.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"47b37532-c722-4b58-adcc-aeb880d388b9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2738a949-ef0e-4004-a4c3-f1412288c87c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUqFuwzAQPW1kcNK0D9gPFI8aDkXaNFbSak010lXtpCm0zNAsLKgoKKgo
JNIkExMPhFhTSIhBgElAQHd2oqxJP2F7ki372Xfv3dl387dH/wIAtlc4Pc4+
yGYzC56ucfO82r4uV4uXh9X7YrnY3M8vkbzBcYvDro9/HKbkhySOE57rE04i
lxwypevR9UYrIXLT2HUl4wlYtPM6zvFcROsTDiJZnUQXO3fEjd2o/RSAlk5w
7yNP0UEe+R7jTkkFyAVpHyzCqUvpCdPZrFof6IRTAMLNoDCkYLpvC2hUbCOD
gIA3vOYyMwKwK7sKjS5UGjnxRDlKU6xmwrSR3ljl2BQJ3vT3eacqGHRY505b
Rmi7FZUEiGxOgis+dSZHKU0pdqhIwsolx3AWMrqzjfUDmhYur+a2Z4T1z9bU
v4+lD+iffH6LkLEwxIkx2oVnRV2XadvKMBVSCM650l/WJY2VrkqVYZtgQvXA
lDUvnHkZejAE5VWRRaTfk3VWDn9OLchZ685h8EnN+Mv9o8cPABriHw==
            "], {{0, 
            19}, {21, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{21, 19},
          PlotRange->{{0, 21}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{25, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "79497f9d-2a3b-4ff1-8d2d-08cb9fcaf320"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUqFuwzAQPW1kcNK0D9gPFI8aDkXaNFbSak010lXtpCm0zNAsLKgoKKgo
JNIkExMPhFhTSIhBgElAQHd2oqxJP2F7ki372Xfv3dl387dH/wIAtlc4Pc4+
yGYzC56ucfO82r4uV4uXh9X7YrnY3M8vkbzBcYvDro9/HKbkhySOE57rE04i
lxwypevR9UYrIXLT2HUl4wlYtPM6zvFcROsTDiJZnUQXO3fEjd2o/RSAlk5w
7yNP0UEe+R7jTkkFyAVpHyzCqUvpCdPZrFof6IRTAMLNoDCkYLpvC2hUbCOD
gIA3vOYyMwKwK7sKjS5UGjnxRDlKU6xmwrSR3ljl2BQJ3vT3eacqGHRY505b
Rmi7FZUEiGxOgis+dSZHKU0pdqhIwsolx3AWMrqzjfUDmhYur+a2Z4T1z9bU
v4+lD+iffH6LkLEwxIkx2oVnRV2XadvKMBVSCM650l/WJY2VrkqVYZtgQvXA
lDUvnHkZejAE5VWRRaTfk3VWDn9OLchZ685h8EnN+Mv9o8cPABriHw==
              "], {{
              0, 19}, {21, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {21, 19}, 
            PlotRange -> {{0, 21}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9a03acec-94f8-4e6a-b840-47e5e4bef231"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x5.5"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4dddacc9-6164-44bb-83ef-d67d18f42138"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f21437a1-4221-4eab-babe-6dda0d10a36d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6a61fcf9-df8b-4767-b55f-26306be8cff3"],

Cell["\<\
Make a pie chart of the sequence of digits that appear in 2^32.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"13af3e97-1afa-4d2d-8cf0-6c8ba503078d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"11f2daf0-6746-4610-87ab-f4b38cb03d12"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvWdUlGm697vf8355v5yz3rXedb6dmRYUFSQbkZxzzlTOgSqoAFVUoIqc
syAIqCDBhDk0oiAG0LYxtY5tOz06ndtW29ZuRbuFfR6kx3FQEIqn6q5w/dZv
7zV7r1m9bHiuv/d13/dzPVb0zDj2//Vf//Vf0v+F/a84mtxXIqEp4v839n8k
Zkh5nAwWMzQji8VhSTbQ/yf2/+T+j+n/mfrP/w0AAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAGDE/Prrr99+++3nn38+NjZ2Znj4+MG+vo7m7sayrRXq5gJxvYJd
KSaXZaQV8xML2LH5rKh8VjT2HzCLePGlwpQqKbVeya1V8XOFtB2N5Xs6W48e
2Hv69BD2T7t9+zb2T3769Cnqf0UAAHRkcnLy4cOHWC2Pjo4e2dvTWVtQl8PG
yr+SHdrKD9gt8DicvnpQYHdRtOqm3OGOyukrrfOPha6PS1b/Vr7mecXal1Vr
X9Ws+++69ZO16yZq1r167Xjl2qdlax4Vrx7kr8yPsb0kXnVWaHuCu/Iwc0Uv
06Wd5d7A8ithhmiYMdVyzrbawoO7u0dGRr744gvsT4L9eVD/SAAAmMnLly/v
3buHpcSBnm0thVmFnNhN3OCedM9+geOnklV3c51+Llk9HQWLt5+zoj7FHguQ
9/pToeuXKqcrUvtTvJV7mfZtrI1VrCAsTBrzpXu72rE/IfbnxP60qH9gAGCh
/PTTT59++umB3u2NGmExK2Irz6df4HQly/67fJc/qvGJiPfaR7NpJc6aG+/1
foErtrA5nW67l+XQyPTW0sPr1IK9XVuxP//9+/dR/yABwMzBquzC6OjO1rpy
EbGeE3Qofc1lqT3WYmANhf6CYoadadZd1FULyo0ZPixy/VzhOJxu2810rWQG
FgrSultqL1y4gCUh6h8wAJgJ4+PjN27cwNYVVVk0LCuOpbtgf3f/Wr7GYEEx
w80JS/roKxeTGzP8Wus8kmnXy3CqYASWiih9Pdtu3ryJ/Vuj/sEDgOnx+PHj
C6MjHXVFJZyo3ekbP5Ws+rlkNaqseNuqmI+OspbjmBtve1ftNMhf2c7ckMeI
bKvKHxk5j/0cUP8qAMDYwcrk/NnhlmJZFTv0cLrrF0pHvW5W6GBRpPUAF8/1
xmxbIlhUYouQIlpwU5HszOmhn3/+GfUvBwCMi2fPnl28MNpWrqpghR5Nd7mX
64w8H2YzN2LZGYGtvnPj7c2Qa1n2e1gORbSg5jLVhQuj2M8K9a8LAFAyMTFx
+/btXe2NpZyo/fzVd3OdDLnDqZuyUJsLokXti+ocIGMS+y6GSwEzsqe1Afu5
YT891L9AADAoT548GTzxcVUWrYPndSXL/mXVWuSBME9FwTaXpQs7h8XXHwtc
h9NtmxgepWLKqRMfwyVVwBL48ssvd7Y1lLHDP053flDkijwHFmp6wPIbMgeE
ufHGL1VOu5kOBcyIXR2tX3/9NepfLADgz6tXry6PjTXmS5o5Plez7I1tt3P+
sn2X3VE6IQ+NN/6Q73KCZ1tB891corh27Ro0L4B5MD4+fmbwVKWU0sPdcDfX
CXnhL1Ka99J/apyRx8W7XhKv2sJYXyqmnhkafPHiBepfOwDoyLNnz071HysT
JB/kr35YbHotyXsluVthf8UjT4nZxJqXHXSXYmHa8OBJSA/AtMAS48SRQ2X8
+GPpzr+UGsV9LVycqFlL2LgEeTjMJz266M5F6amnT52Aq6eA8YP9HTc00F8u
TMIS4zd0t8H15OOS1SyfpchjYZ7+Q+3UzcDSI2XoZD+kB2CcvHr1auTsmQoR
4RDf1ZzWGG/7ldY5M0hfl8z15F21E8PHJj0ldOTcWex3hPoxAYB/c/PmzVol
fyd3HfagIq9u/XlL4aCI0Pslc3w9xlouCF5+TupUTVpTKudhvynUDwsA/Pf3
33/fXl3QwvL4p8Z4L4fj5SWxXUGsHfIoWJA0L+sDHLubuasxB4T2JaSNmysL
fvjhB9QPDmChPH/+/EjfzkpW8HWZA/KKNoyD/JVVSSgviy7U3eRlWWErpkPj
jXtZdmpK8MG9O7HfIOqHCLAsLo99WiEiHk93fmE6V8QX7yGmzeY0k8mNB4Uu
ZM+lx/irZuQG5hWFyxaKQ56QeHlsDPWjBFgEDx8+3F5fupW98cdCM7mSMX97
SUu3kxG81KabW1Os1NEr3w2NN56VOBYTNmypLcV+p6gfK8BsmZiYODt0qpwX
84nEUhqTGbYlL9lFM9xL9Ivxh3wXgsfSkxkOc+QG5g21606mnZoRdXpwAO6o
A7hz//795lJVL3fdkzJzPjGZ27rYvx5kmMY5bH2cVXG87dyh8caLMudq0pqG
EhXMOAXwYnJy8vzw6XJu1NUsC11mvLE02qqfswJ5JnzQr3Kd0tytz0gc55kb
/94vpUeeHT4NH3wBFsnjx4+31hZ1sNab61WuBZkXsXSQbwL3N0oiraqT59rZ
mGPhUUFc21xd9Msvv6B+9ABT5W83b1ZkpF6UOCIvWCNREWZzPsPY72/8XeVE
8LAezXbSITem7WXYaXgpN27cQP0AAibG77//fnhvTwPT54cCF+TVajxKQ2wu
iY39PEUTZtWYNt+djdkcFjvmET2H+o9iTwLqhxEwDR4+fNhUJD/AczWh8X2G
URi4/Hq2UQz7ms3PZA5kr2WX5M6LzA3Mq0rXJopzTb4cTmmBD3Lr1q1yYfLV
bOhN3iPX3+ZzhSPycJjD7CDrdrIuOxuzuYdlp+Um/e1vf0P9YAJGyuTk5Ikj
h2oZvt/nQ2/yfhneS++qjWhI4AyxHorms+yKwgXH3MA8LXLUEL0/PnoIzlmA
Gbx48WJHc003e93zCuhNZpXiYf1tnvEO+xL6W3XR8FxsvPGywqWCuLarrQm2
O4A3PHr0qCFP0i8w/xdaFylh40cPCl2R58N7HeKv5PjbXFO56iM3br6+WdpE
cqwvUj558gT1Awug5+7du5UiwhXY0PiQ4xVraV5WyPNhNtm+1ruZiz1G+aA9
jFVFUub333+P+rEFUHL92tVKbvjXWlhpfNj7hS7p/jbI8+G9HmIszwxZ8Zla
X4uNtz3CW5XLioWdUovl7NDJOqafKX78CIlfqpyyQo30sijV0/oQ184AoTHt
sNgxl+z3yYUR1I8wYFAmJydP9x9pYWz81exGB+vPq1n2mmhjvCzaS1oqi9DL
dugcXpI7FxPdDvXtRv0sAwZiYmJi7472Hex1v1fD0ckCPCe0LUswusuiDwpd
SJ5Lj6fbGzg3MK+pXEsJa/t6O+F81uz5/fffu7fU7WSvnqgx1S8tovI4e3lD
qtEN+2pNstLEGHqx8XZ0VBBW7+xog9kdZszLly8H9mw/wHOdrIXQWLB7qcva
SMa13vgh3yXN3Xow8wPDefTqdZVrNcFlR+sm+MiCWYKFxtbaouPpcBdURzvS
rLupxrW/UROzpDRB72evH/QztWsd0XlrYzXcCjMzsL8L2msKj/LhvFV3mxKW
9NGNaGjPvdyp9+XPLnA4j568oXZtJDluqS39448/UD/sAD5gobF/W0N1vA3y
0jNpK6M+OsoyoiGBhRFLalPQLzbeti51VZlGBnsdZgCW/9vqy/ay4DroYi2M
tB7gGsv9jTtKpzSPpReycXhfHl9FQdatdWWw6jBpsOTvaqk7wIObXTioDl92
RmAsw8zVoVabCciOUeZ2E8lpe3MdbJOaKJOTk7s7tuzmrobTE1zMDrG5IDKK
85Tr2VPDeT7Nwfl9eby8MbVN6tJ/aC/c6zBFju7bvU/gBvc08DIzyOaK1Cju
b0iDrLeRjWtnY4bXVa5laWsO79uDugiAhXF26GQL0x0G/eEo39/mphz9kMAL
mXZ0n2VXlUa62Hgj9icsILgND51EXQrAfLl25XItwxfePcFXlu+yv6vQD/tK
97Pu1s9wHty9JHfWknyuXIZP0JoAd+/ereKG/1wCnzvBWbr30q80zmhDY4C3
khtgc11vw3lwdyTLSU0Lu3fvHuqyAObi0aNHFSLiPzVwvwt/Se5WPxYgHvbF
9LbeyzLqnY13PSG01woI2JOJujiA9zM+Pr4pX3rZ4r/GqA8nataS3JegDY2D
dBtRyIobBhnOg697WXaVajH2fKIuEWAmk5OTOzZXDwhhpaEXH5esZvsuRZsb
FK+lhhzOg6/tVIdtm2vgZNbYOHn88A72OriqoSe/0jqLglFeMu8iWOcYfDgP
jmLLpHLCmhPHj6AuFODffP7557VMP/iEgf68KXdQRiK7LHo/34XoYd0vQDCc
B0fHclw0JB8YTGok3Llzp1SQCB9L0qsXRXZFccguizYnWuXFmth26HsdFjtq
eUkPHjxAXTSWzsTERHWetCxu+dMyuK2hR0/xVtYko7ks+p3WJc3DekiEcjgP
ju5h2dUW5sCLb2g5dqhvt8y9iWEnCV3xpdoJeX2ZqwfpNpsJaHKjMtqqPMlU
t0PfawPJ+cCeXtSlY7lgHUq1MPj5Dv+JnYHn89cw/W1OCuxha1QfdhOXbicj
6FPu5Tphi43zUifkxY6jV5UueUTPzz77DHUBWSK//vprhZz+z0ZPLDSm/aHF
OyN8eTPB7je4YY63W5KW7KIh2BctiLSqTzHhY5TZPCNxzOOn/PLLL6jLyOLo
3FI7qN3wJjSm/aPHv4Zsmx22/Cv4BBuu1sb89SDD0Oewt3IciJ5LL8qMbjgP
LnbTV22pLYUbHYZk5NzZ1kzvV70BM3Jj2kH1apa/zdlMe+TlZjaWRFn1cww9
XFQRbNVCNIdjlNksI6w9O3wadTFZCj/++GNZZtzjrb7vDY1pv2ny5IXYtJNW
waUOXNRGLB3iG7RPuZZlT/FaNmasw3lw8ROZcy4jAnueUZeU+YOt67bU5I+V
zOxQ3vVll39pmq0ycsW3eXC1Y7HmhNmMZBj0IwjiQKvtFDPc2ZhhH9uuoUQF
o4z1zejIuW0S7w+GxhuPyV3YATYXxdCzLEpxkM2nEsOdp5zLsGX42lxVmt4r
bDpYSVxz5vQg6sIyZ3755ZcyccqDNp/55wbm3QZ3brBNF80exn/prDBo+WfZ
hhv2xfOz6qWb/2Jj2osyZzUjCi6R6o+utvoz+R/uUN51vMs/P2mlNnrlj4Uw
21wXuf42txWOhgmNAc4KXsByExrOs3h3M+1aaopRl5d5cv369aZM/z963n+G
Mh/7JI7cABsY0KGDDJ+l93INNOyL7mW1j23OxyjvtZiw4crly6iLzNx4/vx5
hZz+TZOnzqEx7e2ajawAm93MVb9XQ8+yACme1t/luRggNPqoy8ShJjmcZ5EO
ix3zBETsOUddambF4X07P1a7LTI0pv11u686fkVxnO2DIuhZ5mua20cPiwwx
JJDsaX2Etwp5FSNxC8Vh/65u1KVmPty/f79MGDX9HgpedgsdBEHLP5NDz/Jh
n1VgvYO1AUKjI9VaGWUp26HvelXpoqEGff/996gLzkzobKm+WKzLdujcXi/f
wPBfdoBj/wq+zTSnPxS4CAJs9B0a9/NdCB7WA0LTHs6zSPey7JqrilAXnDlw
586dhozAxWyHzuGT7b6ymBWViXaP4bsJs3tH5SgL0/sXpRvjlxTGWdx26Axv
qF2LiO43b95EXXamzcTEREOR9Itad32Exhu3cu0zgpffVsA369/vZam9Nlq/
l0W/0bqkuVsPix2RVy5yT2Y4lMi48FnqxXDxwmiHxEuvoTHtpeJ1DH+b4zx7
+J7su54RrCxL0O9l0fKoJZXJlr7YeGMNac3IubOoi89UGR8fL8+m/NCygFvl
i/FRm7c4cnldih2MHJzhMfbyhlQ95sY/VFPDeUayzGo4z2I8J3XKExBfvHiB
ugRNkqFTJw4p9duhvCuMHHzX3ZSlbUQ95kZemFVDKiw2/sMmsvPJ/uOoS9D0
wBYbZVLCo/aFvYqCi9MjB0/ByMF/uS3Vqpuqr5fob8odCB5LL8nNcziPzmI/
kFxOwrNnz1AXoomBLTYOKAy92Hgj1hwJw2xg5OC0m+I+2kfX19AeefCSVhIs
Nt7jForjx0cPoS5EUwLr7MqyiA8X+N4rvv5r5OAKGDlYHrXkGEsvuTEmWUXx
XnZZYc7DeXR2aqoPLDkWwunBk/tzPBCGxhth5CBmfuTSkzy93N/IDLDqpMJi
Y1ZbKI79x+DTkPMCW2yUZ5MXOmRDf37T5MkPsdlqwSMH1eHLzgrx3984I7Bl
+VnKcB7dnFpycBPhQ/bzYWdPd7cY/1vli/FfIwdXWubIwexQm4si/M9TuL5W
Oxmw2PiATWSX4SGYBvYBJiYmcsVEctDyRs7qv9ch2xd9rxY7clAUtPxqFs4f
azvOWj71XqHlvS+/UM9JnfIzKXB9dG6uX7/ekRcyPhDbm7uOHbmqhOJyvcJt
tu8dGF7LHDnID7D5mxznYV90b+v9bLP6eqP+rCatHRsbQ12aRk1LrfbWjqA/
huKnPV7hLoy3VyQ5jBauf9mN53v0OmuBIwdZvsu+VDnhGBq7ycuywlYgr0dT
8WSGQ1WuCHVpGi/ffPNNrTzyTWi88WKzX1aqQ0bMqlO5637r9EMeHRMWNnKQ
5mX9tRa3IYEPCl3IntbH+BY6nEc3i8he//jHP1AXqJGyt3fr+Sa/d3Nj2lud
QRqqIyfc9pB87c9b0Z+23K7ZyA602WMBIwdJ7lb3C3Ab9rU1xUodbbnDeXRz
D9N2x5YG1AVqjDx9+rQkK/G3/pjZcmPab/rCK3gujFDbrsy13zcb4lXZObSE
kYN/VK0luS/BKzR+yHdJ87DGFt7IK9G0vKZyVVHD4DvU7zJ4sv9Ihf/cofHG
x0ejm8SuzDDbZu7qL+sR3xAz75GDWLGzfZfilRv1cUuK4+HsVRfbqQ4DHx9D
XabGxcTERLmaff/gezY35vBZf2z31LGLXRnV5TOkxy7XyzcwzXTk4D9znUTB
+HyJ/hutS6q79RkJDOfRxfNTB7JU+H7929y+fbs1N3xBofG2R0rd0+PsVSmO
F4uQHbuY68jBG3IHZSQ+l0XLIpdUJcFiQ3fLKB5YpaAuViOit6Pp0pb5Nimz
ObrZR5riIIpZNahZ9wzRsYv5jRwcFdkVxeFwWfTvr4fzjGbDcB7d3Qu7o2/x
7Nmzkuyk5wOxi8yNaW92BqkpjrwIu0PytY+3+ho+Oi4Vr2Oa0cjBAd7KmmQc
ckMTtqQxDRYbi/KaylXNiPztt99Ql6xRcPHihb3FAbiExhu/2hNWynZmhtn2
itcabNLgG6dHDtabxcjB/XSbZsJiL5l/JnMgesJwHhxspLheuHABdckaBa31
+Z93BeObG9M+OhzZKHKlh9pu4a+522DoYxfzGDnYRVzaSV7sMPPsIKt2Miw2
cPB4un1jiRp1yaLn8ePHZVmxvw/G6SM3pn3WH9upXMuKsKukudysMuixixmM
HGxJXLKbtqjhG5fEq6jey67AcB48vKF2VVGCsKpBXbiIOTM8dLRysTui8/RQ
yUZ+7KrcVKdPitf/rp8POb3r65GDy0135GBtzF8PMRd1Div0s+qiwQVR3NxC
cThzegh14SKmuVr9ZW+IYXJj2nObfMTJDuI4+yGtgY5d/jVycLkpjhwsibLq
5+g+JHCIv5Ltb3NNBe/L4+aA0L4uX4a6cFHyyy+/6LtJmc0b2wNVZCd+pN1R
xdpfthni2MVERw5qI5adTtf9/gbbx3oXExYbePq6VQm25DvnIyPnD5QZqEl5
r/d2h5awnVlhtrska37covdjF1McOZgTZjOSqeO+6BHmcmEwDOfB381k59GR
EdTli4xtTcV6OklZkA8OR9ZnuDLCbNvT19zbpN9jF5MbOSgJXj4m0fEclupl
fZADw3nw93j6qpbKfNTli4bx8fEiaeL4SXyuey3eZ/2xHYqpY5dqhuut6o16
TQ8TGjkoCLT5TOagQ2j0kpbKIqBD0YvXVa4KWoRlziu+efNmV0EY8riY4ctT
sQeL3fgx9lqC01iJHo9d7ja484KXd9FWGfnIQa7fsi+UCx4S+KDQhehhfTzd
HnmJmas11A1YBaEuYgTs3915sWXWKT3IPV3vJU5ykMbbn8lb+3yHXt6VM4mR
gwzvpfdyFzzsqzXJShMDF7306E7Gyr0921EXMQLK1ewHhxf24rzhvb4tQEly
So+0O65Y+2S7Xo5djHzkINnD6rs8lwWFxtRwHnerwUwYzqNHR7On5pyjLmJD
89NPP9XmfGC0l/F4d2doEXPq2GWPdM1PrfgfuxjzyME0t48eFi1sSGBNzJLS
BNgO1bsF1IAff/wRdSkblAsXLqA9gdVBbHVUJ5w6dtkqWPNVoye+0WGcIwd/
LVvN8LJeUGh8leuUutH6LAzn0b+bKU4XL15EXcoGpXd7w/VtgcijQAd/7Y9u
l00du9QyXT+vwfnYxdhGDn6X7yIIsFlQbhRHLKlJhp0NQ3iAY7djSz3qUjYo
pQra42PRyENAZ1+eiu0rcONF2xcQnC6XbvgDv2OXf40cXGUMIwdvKxxlYQt4
qe2Ocmo4z4VseF/eEF6SO+fy01CXsuEwrc2NuR2s9RInOWYnOJzNXzfehc+x
i/GMHPxUsiovZgGXRVWhSzYTYLFhOAtpgZazxTE2NtZXapJNymxebvPPIToK
o+z6VWufbsfnXTljGDl4On1lReJ8h31dz3Ygey37NAfelzecTRRXy/kE5P7d
HYufJmqEftkbUsh0Zofb9mWtfdCGw5ehkI8cPMJcvil1vpfMJYFLtlFgsWFQ
dzNX9vV2oC5oA9FQKvm2T/fp5Ubu/YORNekuzDDb7cI1Xzct9tgF7cjB3ZSl
W8nzWm9cyLSj+Sy7qoTFhkEdFjtWqoSoC9oQvHz5slCSgOTdeUP65Hh0m2wN
M9yuge16e9HHLtMjB/9h8JGD21Ktemnz2t9I97PqpsNiw9DeULsqaeEvXrxA
XdZ65969e20aY78mipcvT8Xuzd/AjV5VSHS6UraoY5fz+WsYfoYeObgp7qP9
9A8P7TnFW8nxt7kOw3lQWE7zxmoKdVnrndHR0WOGGgxoPA5UeWYmOsgTHc4X
rHuh67GL4UcOlkdZHWd/ODdYPtZ7mLDYQOMWiqMlTDg3103R+fhpq18OwVEY
bXdCtfbXDl2OXQw8crAgchm2lpg7NA7SbUQhK27AcB5E7mXa7unehrqs9c7m
KsU/dxvd6/OG9E5PcD7dmRNueyB7zUOdjl0MNnJQFW5zTviB/Q2Kp9UhLryN
gszTIscarRh1WeuXycnJfEmK8czqQegP+8OrXx+77MhY883Cj10MM3IwO2T5
J+K5zlO6CNZyGM6D1KkZPowY8/7e9MOHD+uVZn6SsiCfHI9uzZo6dmlku96p
c19QdEyPHFTpc+RgRuDya1mz3t+4n+9C8LDuF8BwHsTmUYMePXqEurj1yBdf
fLGj0Gxvbujs+EDsLu16brR9Cdn5WvnCjl30OnKQ72/zN/msw76aE5bkxcJ2
KHqrae5YZaEubj0yMjJyrNIXeZ0arf2VHpmJDookh5GFHLvob+Qgy2fZlyqn
94bGd1qXVHfrIREM50FvK9l+xKzHmx/a13uh2XhnAxqJl1r8stMcM2JWncqd
77GLnkYOUj2tv9a+f0hgdcySskRYbBiFe5i2+3d1oy5uPdLZXHqnx6BfZzNd
b3cF59GceRF2B2VrH7XP69gF95GDRPcl9wveM+zrXq4Tttg4L3VCXjLgzdcf
m26tKURd3HqktlB4/6ClXBbFxe/2hVfxXVlhtl2Za75r9vpgdOA4chDresge
Vu9dbBSEf1SXAosNYxEL8FIZF3Vx65F8ScqLk3CesmAfH41ulkwduzRzV//9
Q8cub0YOPixeVM/yoMiF67fs3dC4rXBI87C+KIPhPMbidZWrnBaDurj1xdOn
Tytl6GvQdB0fiO3NXceNWlVGcb5e4faqd65jl26hQ3rgokYO3s11koS850v0
iuAlLURYbCD2M5XLUKbDLsbKxuSlBREfEYLWPnnyBHWJ64Vvv/22JdeEZwMa
j8fK3YUJDspkhwtF6152z3rs8nrkoI3OIwevZ9uro2Z+Ufpalj3Za9kYDOcx
iNdULieE9j20FXWJ1rlhf80MsGL7ryR62yVstI1ev4Lo4yQIW6eK9yhP9WKE
eWD1hbrE9cLt27e74PIGfl5s9stOdRTFTh27/Nb5/mOX1yMHV+o2cnBUZFcc
P/OyqCjAajsVFht4eknucoy/qoO8vCrOShXyl4wAa6bfyjQvuzi3lTHrV1L8
nEURGzSJnlWpns0U706W/15B8HFJxLAi5qwy9o3F1HBzvcIxNjZ2oMysxgMa
g7c6gzRUJ16k3SH5mp+3vv/YRbeRgwO8lbUp/3FZdCTDjuFjc1UJr7At2NFs
p4Ncu3bCsooYK3nQX9IDltF9bVM8bWPdVsa52TICXKXRbvlJXtVpHi1U7y52
wH5hSH9W5NvJMLcV5MArV66gLnG9cPr00Kkab+SFZpZ+0xdeznVhh9v2itd8
/75jFx1GDu6n22wh/sd6g+9n1UOHt1Fm9YzYYR/bdkvasuKoj7IC/8Lzt6H4
2CZ72EWvX5nksYodvEYWs7EwybM2zbON5tPDDTyYGXoyO2r+4TCHtQSvc+fO
oS5xvXDscN/5JrgsqkcfHY5sEq9mhtu28Fb/o8FjRnQ8WODIwS7i0h2Uf78M
O8BZwQ1YbuHDeWbsRooDl3D8lpO8bRPdbaPWrUj1cuSGrFXEuZekeDYQPbcy
fHfxgg6Lwgbl0biEwxxiLczRQwdQl7he6Ottv9wWgLy4zN5n/bFdqnWcyFWV
NJcblTOPXeY/crAlccle2r+HbzC8rftYFrGzcUUxczeS5beC4GWbsHHljN3I
JpLXdqbfnvTgY+Lw0zkx+g6HOexg+vdub0Nd4nqhu6361o4g5GVlOR4pdRfE
O+SmOn7yn8cu8xw5WB3z0RHmn+ewfdRl4lCzGs7z9m6kMuT/EwRY031XpHna
xm20fb0b6fL2buQOln+fIORj6czdSOMR63raG6pRl7heaK3TWPjEHiSeb/SR
pjhK4uyHNGue/evYZT4jB4sjrU9w/1xvkDysjvBWIS/2hfpmN7IsZoks6C98
/+ndSLtYN9u3diM9a9I8t1B9ujkB+zNCF7QbaTxia56mcvO8at5Ynm3Gnz8w
cm92BuVSnPiRdkdy1j7e6jvx58hBO9nsIwc14UuH06fub3SkWiuijHc79IzY
AWugmlOWFc2+G1mU7FlH8Gyj++K7G2k8YolXna9AXeJ6AV5OQe5Xe8LKOC6s
cNud4jU/bvGemHPkoDzMZiTT7n6+S5q79YAQ5XCez1Qug5kOO+krNyX9azfS
fwX59W5k9OvdSH7oOkWce2mKl4F3I43HI6KwkpxM1CWuFypyWSb9LWmz8dHh
yIbM1cww2zb+6rsNHv8aOWg3Xvkfr8KJg5ePSewb45cUxBliO/SKwuVjwarZ
diNJvk7C8PXqBOPajTQe+6UR2kw26hLXC8Vy8rMTMFnUWHzWH9upnDp2qWa4
fFax4fXIwRVvjxwUBNhcltinulsPix3xCof37UaunNqNdLON2bCS6m9iu5HG
4ylZVA6HjLrE9UJhNuH5AOSGcfnyVOyhko2COHttmuOOdHu2/79HDnL8lhVH
fFSRtOBZ5e/uRtJ8V6Z42mHJMNtu5AnT3I00Hofk0TIWAXWJ64V8KbxEb7ye
qfeWpjhxw1aQvT/qotq9rFpL8liS7LZkJOv9w3ne3o2UBv6F629D9rFNcp96
3+rd3chebuChzLCTMnPbjTQesdzIYqShLnG9oBUlvTwFuWHU3tgeqCQ6Rqz7
iyLU2nP5/1sabzO9G5kX/ldRwEdsv+V/7kauXzljN3Ibw28XP+iIKGzIknYj
jcehnOgsegrqEtcL3l5+Xl6hoPHr4RHi6OT5//zf/8dj5Uf80LXqBI+KVM8m
slcH0x92I41T7DcipSWjLnG9QGfJc6uua2tugsZsbuW1NEadl1fixjWhCR5+
UW5r6tLckdcFOLfDihiJmeYGm6dUV15FXhfgHMoKR8JjpaGBjOq84RA/Yqyb
XxsvhxwYTvRy7RMEI68OcA7F1CTUJa4XuAK1qvwy8tIAZ5MnO+jtTyQn5W0q
uYgZH8HzcvY4pqo6rKgoI/OjNrqLQlxPyWD7whgdNN/zFIFIqyz7FHl1gO+K
9Y9EdpOnV2KOsGs6NDAJCVmB68Na2NlYdGDukRZmxROxtqWe4IG8TMAZDmRH
qtLpqEtcL4ikBTklnyCvEXCG8uILkYk5Qf6UCs2pN6GBSU1Vk0O4gtD46dyY
tpUnJwWEErxcoG0xKo9LIvLE5vkphKycEnnxKPIyAd9WkHPUN5CSFqd8OzGm
ZZEL+TGyeK/Qt3PjTdsSvdFdDG2L0XhEFFYsN8/3U/IKaqV5w8grBZxWU32D
zG319EqQ8ra9GxqYfFolO1IavCH0gLxkRnRg7pYWSuMI0LYYiQczQys1MtQl
rhcqa7Zkqk8grxcQU1F6KSZZHeBHLFOfeG9oYAoZ9bRQISM6vYTAeTc33rQt
xIBQIrQtqO0ThDSUaFGXuF7Y3NKZLj+MvGTADFW/fzA9KTp7tsSYNpPVnObP
0tJqKH7hs+XG67alvJTEi9roLgl1HcqBtgWNPZyAbY21qEtcL3R17+FI+5BX
jSWL9SbU9G2e3omZ7Ja5QwNTytua6EdtEu+McA+ZIzem3SUpkMQRot3WNBCh
bUHgVobv7q7tqEtcLxw8dJSR2Yu8dixWZdmn8YQCP9+0YsWxD4YGplzYFedH
2qk5GekV2ylUfzA6MLdwZcSAEJK3635hCPJSsig3k72OHzmMusT1wtDp09hf
dsjLxzIV5Z4MDGPFRYjqi0bnExqYKtGuaF8ClhuZycrsaMJ8cmO6bSl53bZI
oW0xoLVEs/1+yuXLl2n8JuQVZIEyMrs8fZIE9IZ5Jsa02qz94T7JWG6UsVuS
vMPmmRtv2hZxbFrUhjWbiJ7Ia8oSrCAHjI2NoS5xvXDnzh06vxp5EVmUqvLL
iaQSX++UAvnhBYUGZlHOkVDvRCw3tuccDtoQdERRsaDomG5bCP5Y2+JyICMU
eWWZt6XUsNu3b6Mucb3www8/0LnFyEvJcpTknQ6O4EeH8msLzi80NDDL1CeC
POOx3MAkhtFraRkLzY232paN2WGroW3Rnxpq9Pfff4+6xPXCb7/9RmOpkFeT
hcgS7/TyTeWQqnRIjGmrtEP+7jHTuaEkl7KDonXIjbfblmi3NU0kL+QlZpZm
U+KePXuGusT1BYzgMIDqiqvJtEpv7yRt1j6dQwOzrvC8j1vkdG7UC3dEe868
cL5QWziyNP9gMrQteDs17IuRirq49YhMUSorGkFeWWZsVsHZ0OiMiGBOdd7w
YkJjWq8NET3qE1hu9Kj7QzdG7JYWLDI6DuVMtS2RbljbAqctuGnGL6dMU7+p
Xag4jry4zFWOtM/bL42eWrz4xJg2wDuxTXZgesnBT5BqEqmLzI03bYsoNjXG
bfVmMrQtOLiLH9RSU4q6uPXIvv2H4eqXPpwa7ses9/JKUGbuxCs0MMMDyZsy
e6Zzo4DeQPBZ2Gns3DZzstP8gsg+0LYs1laaz75dvaiLW49cuHCBym9BXmVm
pqxwJCIuKySQjktv8rax4ewKXtt0brRm7QtxC8YxN6bblmIiN8ptozxi9TC0
LbpaTfIdHR1FXdx65M6dOwx+DfJCMyf5skPe/kRSogbfxJg2JTazkN4wnRuY
Cf6pLVwZvtGBuVOcnxmTAm2LzhZRI7DKQl3ceuThw4d0bj7yWjMPNVWfkThN
nl4Jbw/3w1dSklxJLH+TG9mE/IywRNxz48+2hZ2VirUtXs6HMqFtWZg5lNjH
jx+jLm49Mjk5yeQqYKr54v3XcD/yjOF++Mog5GUlF7zJjSpee8ICL5wvtG0p
InIjN2yQh0PbMl9ff6ktFass1MWtXwqK68WaU8jrzqQVKI75BlJS4xT6S4xp
OZRSQaziTW7sUB4L3hDy3vFf+LYtGVNti2szBdqWD3sgI7RSI0dd1npn5659
LPEu5KVnomqqb1B4rZ5eibMN98PXdHoNK0L8Jjcw6VH8UgJXr7kx7ebXbQvF
G9qWD9hG993d3YG6rPXOJ598QuU3Iy9AU1RReik2Jdffl1Cq7DdAaGBmsJrI
Qby3c0NDrab6RxggNzAP5pQVETiRbm7QtsxhJcnv4sWLqMta73z11Vd0Xhny
GjQ5M9Un/EMYSdFZhkmMaSXctmQ/xtu50STaGenx4fFfONorzhdGJ2Ntyxaq
D/IiNUI11Mivv/4adVnrnRcvXtBYCuRlaFpSBdu95jfcD19l6R2J/pS3c6M3
dyDSK3ZHRq4howOziSVN8Q2k+rgcFkHb8m+HFTFSSsLvv/+OuqwNgVpbBR9E
mKfKsrF4QoGvT+o8h/vhqyKjJ9aP+HZuTI//ksXMd/wXvm1L4VTbskER4Qpt
y7QHMkLLVVmoC9pA7NqznynaibwkjV+x5lRgGCcucgHD/fA1V7InyjdtRm6U
spuTvRf7bqzubYsoTxiVhLUtrTRoW2LbLWNTdJqrV6/SeJuQV6WRy8js9vJJ
5tPqkSTGtPmyg+E+STNyY5v8UPCGYB3Gf+HbtiT7BNB8nC28bSknBVy+fBl1
QRuIhw8f0th5yAvTaFVVXEkkl/p4J2NlizA0MLHmKNgrYUZuYBJC6bW0TIS5
8aZtidiwQRlpuactCkrMgwcPUBe04UjP1CpKLyGvUCNUmjccHMGPCuXpNtwP
X8tzTwZ4xL6bGwpSCTsoBm1uvGlb0qMSYy2ybflYGqEWMlGXskFp3tLJlx1C
XqTGJku8y9MnhUWsRJ4Y01bnD/u5R7+bG3XCHTGLHv+Fo1jbkuQTQPdxPioK
R17OBnM7029H22bUpWxQpm5/8eCbCP9WXXk1hVbl5ZWoke5FHhdvrC8a9d4Q
8W5uTI//2istQp4YbzwoL8tPY0dsWK+2mLalkuRvCTe+3ubhw4dUlgZ5tRqJ
08P9woPYuA/QWLx+HrGdymPvRgc3XqJJoiOPixn2iLTTbUu7BbQtKkrM/fv3
UZeyoZHKirMLzyOvWeRys/q8/Qm0lCLkEfFeQ/xSWyR73s2NAno9wXeu700j
tJEpSfLxp/u6mHHbclQcnifmoS5iBOzctY+ZadG3ON4a7teLPB9mMzqEUSfo
eDc3tmT1hW7EefwXjk61LQTWVNsStQZ5jevDFop3364e1EWMgJs3b9L5dciL
F5Wyoj+H+1VqhpCHwxwmRPFLWc3v5gZmvF9KK1eOPCLmsDtTy49MiHFzaWf4
Iq90fC2khN66dQt1ESNgfHyczlZgf+ciL2HDy5cf8gkgkRLzkMfCB02Ll2qp
Ne/Njay0vIxwfY3/wtFNTEmitx/D1/mYxEzalqkPptASX7x4gbqI0VBb35ou
P4y8ig3p6+F+zZ5eCXLBDuSZMB+pKSp5avF7c6NyavyXkW5xzBBrW/LSsLZl
nSbaHNqWnbzApspi1OWLjIsXL1J5jchr2WDmlFyMSswJ9CeVqweQB8I8ZREL
MxNy35sbncpjQRuCD8jLkMfCPMXaFl5kQqybyzaGH/LaX4wVJP/RkRHU5YuM
p0+fUplKTfUN5BVtAIWK435BtJTYHORRsCB51EpuVPZ7cwOTFskrI/GQB8KC
bGCITbptGVbEZFPinjx5grp8UVJU2pCpPoG8qPXq6+F+bR6eCVJuO/IcWKgC
Rj0tVDhbbuRSq2j+kcijYKEekJdq05gRG9abYtuyixdUX6JFXbiIOX36DI3f
iry09eefw/38DDfcD18zWc2EAPZsudEo6o3yMKIL5wuyK1PDi4yPc3M2rbal
kuh3/txZ1IWLmMePH1NZKk3VZ8gLXB9OD/dLjJKiGqCxeKW8rcn+9NlyY2r8
l2cMVoDIQ0BnX7ctvkwTaVvOYE0K2cy/ljJPyqs2C3KOIq9x3KUJOry8kzKY
zchrfzHKhV3x/uTZcgMzI0khjyUiL//FONW2pGJty1ptjLG3Lbv40KT8yaVL
lyjceuRljqOvh/sV+vqkFOYcQV74i1Ql2hXzzqjAty1hNSfr82NMBrMrQ8MN
j4/b6NLBNN62pZQU8Mknn6AuWaPg+fPnDI5SXWEmH3GbHu4XG5Fhur3J22qz
9kf6ps6RG6/HfwWhHf+Fo/UMUYKXL8vP+bjxtS2nZFEyRjJWL6hL1lhobe/i
SPuQl/ziZWR2e/ok8Wl1yOsdLwvlh0PfGRU4Q0IorZ4uQl7yeLlfVqpJZYSv
X5sXsxZ5VrxtG923q30L6mI1Im7fvk1lm/ZHVYxnuB++lqr6g7zi586NHFIJ
N9goxn/hKNa2cMLj4tycO1n+yBNj2jxy+BdffIG6WI2IyclJaXZRVv4Z5OWv
m1PD/SLTXw/3O4u80vG1Ujvo7x4zd27UCTpjPc1hi+NdsbYl3tOH7eeEvG05
Jg7PzWCb/fejF8qpU0NUXgvyBNBBtmS3l28qi1iBvMb1YW3BOR+3yLlzo3tq
/Fe4UY3/wtHptiViw9qC2HUIc6Oa5DvQ/zHqMjU6nj59Smer1JWmtDs6NdyP
Xu3llZgrMaLhfrjrtSGiR31i7ujgxonzkhjIa1x/7sjIxdqWeERty5A8Opua
YOF3y2ejtb2LLdmDPA3maXbBubAYUVgQ0wiH++FroHfiVtnBuXMjn1ZP8otA
Xt169aiyso4hivP0Zvsb+rSlleYDO6Kz8eWXX1LYRcgDYT5ys/Z5+6XRUgqR
F7UBDA8kN4p6586NLdK9YUY8/gtHsbYlN2XqtKUgznBti4oUfu/ePdQFarxo
C6ozVB8jj4U5zK26TmA1eHoa9XA/fI0LZ1fx2ufODcw4v+R2Xg7yujaMncJc
dngs1rZ06b9t2c0PqtDIUZemUXP16lUKuxJ5OMzm1HC/+KyQQJqRD/fD15TY
zELGpg/mhjRNmxmehLyiDeZU20Kfals4/k79WZH6y40iYtDY2Bjq0jRqJiYm
xFkFxnkgmy4/PDXcL0GDvJANLCkpR02q+GBuVHDbEsziwvmC3CcrUafQI9av
LYpbr4/QOJQZphFxXr16hbo0jZ3hM2cpXOP66vSfw/0842XpHcir2PAyCHlZ
yQUfzA2TG/+Fo51CNSs0Rh9tSynR/+yZYdRFaQKMj49zBZqckk+Qx8W0OSUX
o5MUpjXcD1/Z5BJBrOKDubFzavwXt4LER17FSMTallp6Jr5tyzFJuJJHefny
JeqiNA2Of3yCymtGnhiYQuXUcL/kWDny4kUon17DihDPJzdyKVWMANMb/4Wj
WNuiSqaHr1+DS9tSRfSDu17z5/nz59x0tbz4AsLE0FTfoPLbPbwSxNw25JWL
1gxmIzmIN5/caMzsMd3xXziKtS3M0Oj4jU7dnACdQwNbtOSw0n777TfU5WhK
fNw/QOVvRhUaU8P9UjV+vmkmOtwPX8Wc1hR/xnxyozd3IMIzpidTi7xykYu1
LTW0zDgPL66/s25tSyXJr//YUdSFaGJgSw6eUINkyZGpHggIYSZEScxjgMbi
zU7vSPSnzSc3MIVJckUsCXnZGon7souVybSI9WuK4xfWthyThCu4ZBi1oQMn
Bk4ZfslBF3Z6eidmMJuQV6vxqMjoiQugzDM3SlibU3xM42NMBrPjdduSsNGp
Z95tSxnRb/DUAOoSNEnGx8cFIm1WwVnDJIaybCyBWGQew/3wNVeyJ9qPMM/c
2Co/GLzBIi6cL0isbammZ8R6ePICnAY+1LYcFoWpBQw4RtGZkdELZHa1AUJD
rBkMDOPEhGfUFpxHXqfGZr7sYIRvyjxzAzM1mLqJIUZeqkboVNuSRMXaltKE
udqWEmLgubNnUBefCTMxMaHMLc9Q9es1NJiiHjMb7oevxYpjId6J888NObGY
FxyLvEiN1u0CFT0kKnGWtmU3P6hQlgkXRBfJrVu3SMxCPX0LUlVxJYlc5uOd
nJd9AHl5Gq3luScDPePmnxu1go5YL4u7cL4gp9oWWkaMhyff/z/aljOKGCUh
BHvmUZedOVBd26KPqcXS/OEQMx3uh6/VecN+7tHzz40/x39lm+f4Lxztmzpt
oYavX12auGE6N9rovs21FagLzkz47rvvqKxcVfllHEPj9XC/FHMd7oev9UUj
3m4R888NTE6sKD/FnMd/4SjWttCCI7G2ZRcvSEaJ/fHHH1EXnPnQt+8QlY/P
9FF15dVUeo2Xp5kP98NXX/eYTuWx+edGPq2O7GfRF84X5BFlBda2hK3fcPhA
H+pSMyvGx8czJfmSvNOLDA3LGe6HryF+qS2SPfPPjRbpnvCNIcjr0YTsytAI
aEy46IU7V69eJTGLF7NBysve7+1PoKYUIC9DkzMqhF4n6FhQqxLrm9TOVyCv
R5PwqLIym0C/du0a6iIzT+rqW1niXTokxuvhfps8vRIUGd3Ia9AUTYhKL2U1
Lyg3pKlacUQy8pI0CatowtbGJtTlZbY8ePCAyc1d6Esr8uLRyARZSADVoob7
4SshXppHrVtQblRwWxPhwvk83C0tzGLxHj9+jLq8zJnh4bMkVsX8QyM954hP
AImYkIu89Exaaooqh1C6oNzoVBwNcQs9pLDE8V8LUkFgnjtzFnVhmTmTk5Pl
VY1sye4PJoam6jMyt8XTM8Eyh/vhK4tYKErQLCg3MKkRnEpyOvLCNGYbWZKq
olL4eqMBeN2tfGCqT07JJ1PD/fyIFjvcD1951EpedPZCc0NNqaD7RyGvTaMV
61CkDO79+/dRl5SlgHUrZNasn0uYHu6XYtnD/fBVwKinhwoXmhubMnuiPWGL
4/0eVVbK0xgj58+jLiYLAlvX1dZtYWR2zexNXg/384ThfnibydpMCGAvNDd6
ck/A+K/ZrKAKtmyCMxRD8+TJE6EoT6wZfBMaitJLcalaP9+0YuVx5IVmZkp5
7ckB9IXmBqYgUa6MJyMvUmNzR0ZuTnrm06dPUZeRJfL555+TGBp1xdQn7EW5
J/1DGPGRYhjupw/lgh3x/lQdcqOY2ZQKp7H/6aGccimBDi+9IqRv3yEyp4Eh
3AHD/fSqSrQz1p+oQ25slR0McYPxX/9hHpHTt2s36tKxaCYmJrT51W4bImG4
n17VZu2L9E3VITcwU4Mom5gS5NVqJNbSM6uKSv/44w/UpWPp/POf/xTwlEU5
R5EXlxlbKD8c5pusW27IiUX80DjkBWsMdgrVOekZcDXUSPj8889ZVEV1Przi
qi9LVf3BXgm65UZN+vY4L9jimPqUm5hIv3PnDupyAf7N8WP9HGpRQ/EF5CVm
llZqBwM8YnXLjS7VxyFuYfuyS5BXLkKPKisVaYyTJ+DTBsbF5ORkc1N7JrsR
eYmZpbUF53w3RumWG5js2MzCFBby4kVoKSW9tXEz3Cc3QsbHx/O15TIBvI2i
F702ROqcG3m0Woq/5Y7/qmOISjX52POJukSA9/Po0SOxMDcfhpPrwUDvxK2y
g7rlRrNkT7i7hY7/aufnKDPEsBdq5Ny9e5fHUpbnwutsOBseQGoU9eq85Ij1
SdyWrkRexQa2R6TNYnC/+eYb1GUBfJgrV64yKYoqLUzpwdPYMHYVr13n3JCk
aiSRKcgL2ZD2ZRdLCPQbN26gLghgvgwNDbMomtqCc8jLzWxMjskoZGzSOTfK
Oa1Jvha0xXEop1xGYAwNDqIuBWBh7Os7KMtohtdV8JKUKFeTKnTOjQ7FkWC3
EAsZ/3VYUZ6TxjjQtw91EQALZnJysmN7N49eBpc6cJGeps1KLtA5NzDJEewq
igB5UevbI8oKZRpjV08P6goAdGRiYqKleWs6vRJ50ZmBbHKJME65mNxQkcuZ
AdHI61qvHlVWagiszvZt2LOH+vEHdOePP/6orWmkp+UjrztTl0+vYUVIFpMb
DRnd0eb+vel8Iqe1sQm+Jm8eVJTXC1l1yEvPpBUyGynB/MXkxtT4L4/oXnEe
8urWk4pEakNV9e+//476eQfw4cWLF9VVjUImRIfuijmtqYHMxeTGzqnxXzJV
PAV5geslNJJoRZo8uEluZrx8+bK2uilbAHNHdTQ7vSM5gLbI3ChiNqb5RiCv
cXw9qqzMI7A31zXASsMswaKjrnZzOqMKTlh0UJHRHRdAWWRutMsOmNn4r+mN
0NamzTCKx4zB/kZoad7Ko5XCvY6FmivZE+1PWGRuYKYEkZqYUuT1jotHlBX5
ZN721jbYCDV7JiYmdnT0iPn1dYXnkRejCZmffSDCN2XxuSEjFKWHxiMv+cV7
UF6mSGN0bdsOR64WwuTk5N69+9lUDbzDMn+LFcdCvBMXnxs16dvjvU1+/Nfe
rKIsAv3wgYOwEWppDA6eZlGVpap+5CVpEpbnDgR6xS8+N7pUHweb+PivHpFW
TKSfOwsfg7ZQrl27xmUqCmSHkFel8VudN+znHrP43MBkxWQUpprq+K92vkLK
4Ny8eRP1wwug5O7du6KMXLmwE3lhGrn1RSPeixgV+LZaWi3VNMd/NbKkCoHo
q6++Qv3YAuh59OhRnqYsg9WAvDaNXF/32C7lscXnRrNkd4R7KPIQWJBHlBVF
JF5Jbt7Dhw9RP7CAsfDixYvmpnYurRg+pjCHIX6pW7L24rLkiPVJ7BCokKfB
PN2XXZyTxtje2o49J6gfVcC4mJycPHrkOJOigE84zWZ0CL1OuAOX3BCnqKVR
qcgDYT52CnMlJMbgyVOon1DAeLl161YGX5Uj3IG8SI3QxKj0Ms4WXHID++ek
+EQgz4QPuokllXOFX3zxBeoHEzB2sAa2qKAqnVEFYwZnmBovyaPW4ZIb23MO
h7iFGvP4r4PyMg2BXZ5fBBsawDz5448/9u7Zz6KqoGd5W0qKModQiktuYJLD
WdVUIfJ8eK9YbyIm0A/u2w9vnQAL5ebNm5kCdRZ/K/KCNRKZxAJRggav3FCR
y1mBMcgj4l0rqQKFQHT79m3UDyBgqvzyyy91NZs51MIKzSnkZYtcLrWCF52N
V240ZHTFGNn3pvdmFSkIzM11DU+fPkX96AGmzeTk5JnhszxWjlxg6Zul6Yx6
eqgQr9x4Pf4raqe4AHlcTFvHEEnonOHTp+GVEwAvfvrpp7KSWh69pEIziLx+
UZnJ2kwM4uCVG5jpCdnqBCryxNglKVCkMerLqx48eID6QQPMjYmJiaGhYR47
x2J3PKS89pRFjwp82yJGI8EP8YXzGlpGFos3cv48LDMA/fHw4cOGuhYuLb9Y
cQx5IRtYrFNLDKTimBtt2fvCNiL73nRXpiZnajej/ueff0b9WAEWwdjYmDgj
V8iqqyk4i7ycDaZKtDM2gIxjbmAmBxI3s7MMnBj7ZaWFJJ4yQzz26RjqRwmw
LJ4/f9639wCbnpMj7EJe0YZRm7Uvyo+Ab25kEwoEYYYb/3VUWVlHF4kprMMH
Do6Pj6N+iAAL5fvvv6+u3MSmavKzDyCva31bKD8cjseowLet5m+L944wTGh0
CtXZBDrWmPz000+oHxwAmLohplIU8eglZeoTyKtbf5YoPw7GY1Tg23apjodu
DD8g1+/4rx6RVk1k58kUMG8HMCpevXp17tx5kTBXwKg210tiFZrBAI9YfHNj
59T4L2FxGkdPibFLUpBH5CgzxKMjozB1HDBOXrx4MTBwUshXCZl1VXmnkVc6
vtYUnPXdGI17bmipNVT/KNwTY192cQGJK+MKhwYH4YtIgPHz7Nmzo0eOp3MV
WHqY2drDa0Mk7rmxWbwr0gPP701ja4xCEi+bze8/dvz58+eoHwcAWABYevR/
fCIjXSVgVpvNvkeAd+JW2UHcoyPGO6FTqF58YnRnarUkjpyfcfLEwG+//Yb6
EQAAHRkfHx8cPC0VafmMEm3WfuSFv0jDA8lNop2454YoRZ0VlbaYxNguUKmI
LI04+/y58y9fvkT9awcAHHj16tXly5cLtBUcukYu2GG6n4qLDWNX87fhnhtl
7JYUX10unB/MKaujZcrIrBK1FvsJw84nYJZ8+eWXbVs62QyZkFVvip98So7J
LGY24Z4b0+O/jigq5p8YPSJtIYknobG7tm2/e/cu6l8sAOidJ0+enDgxkCXW
8plFMkGnCQ0kJCXK1eQq3HMDkxTGrKVlfHiBIS9rYIiVZLZGkj146tSvv/6K
+pcJAAZlYmLi9u3b7W07uCx5OrNKm7W/ofgC8mSYW3qaNjulQB+5oSSVsYJm
Hf91RFmxhSvTkjkSBqejtR37ucHrq4CF8+zZswsXLlSUNbDpOUJmXV628W6f
ssnFwjilPnKjXrgj9p3vTR9VVnYI1YUkrpjCaqyquXz5MrxUAgAzePz48dmz
54oLazgMhYBZkyvZY2w7qHxaNStCoo/c6FH3h7lH7ZYWTO92NnOy88lYXDAr
84vOnjmLdXaofzkAYOxgATI6OlpX08xhyASs8iz+tvLcAeShgSlgbKIE8/WR
G5icODHZJ1SNNSN0zpaGxkuXLkFcAIAOYMvyGzdu7Ny5N0uSx6GrMlh1ioye
Ku0QqtwQcbakBbJwzIrtOYcree0KSomIKufThVVlZbdu3YILGACAFz/99NOF
CxfaWjtFGWouQyVk1cjSO4oVxwy5m5rN354cSF9MUPTmDjRL9pSwmnOoxVhW
ZKcr2pu3Y/9e8G47AOgbrMrGxsZ6u/do1eVsenY6s1DIqpcJOgvlh/W6JaLI
6I4LoCwoKLrV/U2inVhQqCnlWbTcdKq4UFWys3s39ueHrAAAVGCr+nv37o2O
jmIxUpRfzWVl81kaAbtMyGrAlgfarP3luQP1RSO45EauZE9MAGmOvc227H31
wh1FzEYVpVxOy5fQFQKGpDSvcmf3LuxPiP05oQcBACNkcnLy4cOHt2/fxup0
794DdTUtClkRFiYchiKdnZ/BqRSyajOYjVJeuyKjB8uBfNlBrNkpzz1ZpR2q
zh+uLTg3HTL1RaPYf8BWL5g1+WcqtYNl6hPYfz/II7YmfXsZZ0sBvSGXUqWk
lshpBVK6OpOWLaBLNLKCxprmvbv2jYyMfPHFF9ifBC5aAIDp8uuvv3777bef
f/451iAMDw8fOni0s6N3c+PWqorGAm2VUl4sydRkCtTp3BwsZFh0CZsh5TCz
plYvHHlGuipbkqfKKVHIC0Xp2S2b2ro7eg/tP3x66DT2T8MyCvsnwzfOAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAwJP8/UrXhZQ==
            "], {{0, 360}, {360, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 360},
          PlotRange->{{0, 360}, {0, 360}}]], "ExerciseOutput",
         ImageSize->{364, 360},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "564798cb-0797-4921-8422-7807491c7ddd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvWdUlGm697vf8355v5yz3rXedb6dmRYUFSQbkZxzzlTOgSqoAFVUoIqc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              "], {{0, 360}, {360, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 360}, 
            PlotRange -> {{0, 360}, {0, 360}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5c66d712-556c-4c09-8b54-c70b2e9dab37"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x5.6"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6bc102f1-606f-4b92-8b9f-9a67c41d7ed8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"efef7bf3-9e7b-4714-9367-7263d6bd8a36"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4deb0be3-5589-4a3d-a3c8-f904fdfa1afa"],

Cell["\<\
Make a list of pie charts for the sequence of digits in 2^20, 2^40, 2^60.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+5.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"e17fdc74-4c09-4577-86b0-58bb642dd837"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2683a2c0-44bf-429d-85c3-1600d7c44064"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvXdUk2m7/+s555991inrrLN+65y999lllBBCgIQAKr1D6L2XkJBeIIQ0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            "], {{0, 398}, {386, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{386, 398},
          PlotRange->{{0, 386}, {0, 398}}]], "ExerciseOutput",
         ImageSize->{390, 398},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2d39f837-bc80-4f79-aec7-5c1f7c8c0b9a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvXdUk2m7/+s555991inrrLN+65y999lllBBCgIQAKr1D6L2XkJBeIIQ0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              "], {{0, 398}, {386, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {386, 398}, 
            PlotRange -> {{0, 386}, {0, 398}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"632f2b7d-ebdd-4a58-8298-ea605ac3f3ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x5.7"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b26e12cf-3cba-4f69-b45f-64913f8e97e8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f6889227-d6f9-4e50-9edc-99716e746c3c"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c28a26d4-90dd-44a8-9b23-81dca2e68cf9"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Operations on Lists: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 5  Operations on Lists", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
05-operations-on-lists.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+5.1", "5.1", "5.10", "5.11", "5.12", "5.13", "5.14", "+5.2", "5.2", 
         "+5.3", "5.3", "+5.4", "5.4", "+5.5", "5.5", "+5.6", "5.6", "+5.7", 
         "5.7", "5.8", "5.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+5.1", "5.1", "5.10", "5.11", "5.12", "5.13", "5.14", "+5.2", "5.2", 
      "+5.3", "5.3", "+5.4", "5.4", "+5.5", "5.5", "+5.6", "5.6", "+5.7", 
      "5.7", "5.8", "5.9"}, "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[9830, 232, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f4424307-16e8-4ce7-8a1e-c1f94a5e4dc0",
   CellTags->"FirstInputCell"],
  Cell[16595, 426, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c0593b3f-9c3f-4000-8732-693262b81a1f",
   CellTags->"FirstInputCell"],
  Cell[29681, 724, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d1b016a7-b959-4bd3-9ec3-b18f4146c185",
   CellTags->"FirstInputCell"],
  Cell[37791, 954, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9dba14d1-1360-4bcb-9d05-f6393c196559",
   CellTags->"FirstInputCell"],
  Cell[48046, 1212, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9655750b-54f1-40f8-b975-e2ccc4152454",
   CellTags->"FirstInputCell"],
  Cell[57871, 1459, 813, 26, 
  70, "Input", "ExpressionUUID" -> "31ee6783-f0a9-4408-a95d-2305113f439a",
   CellTags->"FirstInputCell"],
  Cell[64384, 1650, 813, 26, 
  70, "Input", "ExpressionUUID" -> "999e1db1-80c7-4702-9552-47f6d26471f5",
   CellTags->"FirstInputCell"],
  Cell[70519, 1835, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f88d7bbd-d8c4-4bf1-af2b-9f42ec74b67a",
   CellTags->"FirstInputCell"],
  Cell[78884, 2056, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8a531ce2-4c99-480a-b0a2-a5f927ccd845",
   CellTags->"FirstInputCell"],
  Cell[85143, 2243, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a85dfac3-0b59-486c-8c37-55acf4cbed68",
   CellTags->"FirstInputCell"],
  Cell[91667, 2434, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bbc4f16c-2f17-4776-9ba0-b63bde386b67",
   CellTags->"FirstInputCell"],
  Cell[97913, 2630, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3bed3ac5-feba-4f5f-8f70-f96443ec1510",
   CellTags->"FirstInputCell"],
  Cell[149474, 3561, 813, 26, 
  70, "Input", "ExpressionUUID" -> "499a04a2-230f-4e63-b1b3-68b3e19b3d84",
   CellTags->"FirstInputCell"],
  Cell[159714, 3822, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a4e91bb0-b370-4584-a554-1d6e7e420634",
   CellTags->"FirstInputCell"],
  Cell[169599, 4068, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e1ef096a-5822-4f1b-b24b-63b3a546d461",
   CellTags->"FirstInputCell"],
  Cell[180036, 4329, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f9411651-0d8f-49a3-9012-c102800110e1",
   CellTags->"FirstInputCell"],
  Cell[186180, 4514, 813, 26, 
  70, "Input", "ExpressionUUID" -> "09683927-31b9-4ffa-bcd4-2e76a5aa2ac9",
   CellTags->"FirstInputCell"],
  Cell[192424, 4701, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f9f83840-fef2-452d-b9c8-a7c40254e811",
   CellTags->"FirstInputCell"],
  Cell[199159, 4895, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f21437a1-4221-4eab-babe-6dda0d10a36d",
   CellTags->"FirstInputCell"],
  Cell[252259, 5851, 813, 26, 
  70, "Input", "ExpressionUUID" -> "efef7bf3-9e7b-4714-9367-7263d6bd8a36",
   CellTags->"FirstInputCell"],
  Cell[333831, 7274, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f6889227-d6f9-4e50-9edc-99716e746c3c",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 392844, 8494}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[642, 22, 437, 9, 70, "Exercise", "ExpressionUUID" -> \
"0f28a84b-802d-41fe-a598-6d96d62d8edb",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1104, 35, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"e3cbaac8-2389-453c-bbbf-9c78b31225a9"],
Cell[1743, 56, 7481, 151, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ad3a980b-13a9-4342-9d05-252055d0d451"]
}, Closed]],
Cell[CellGroupData[{
Cell[9261, 212, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"f2bc80a1-0d64-4438-a197-1b84fb5d2f4a"],
Cell[9830, 232, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f4424307-16e8-4ce7-8a1e-c1f94a5e4dc0",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10680, 263, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"37f6f281-db89-4ea5-9b6b-c1b541f534a0"],
Cell[10967, 274, 422, 9, 70, "Exercise", "ExpressionUUID" -> \
"b74ccfb0-3c0e-4e13-9841-a01cc9e9f42d",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[11414, 287, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1b440e3c-abcb-43d4-a646-86039af396d1"],
Cell[12053, 308, 3936, 93, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0318df6a-0972-48e6-a1af-d2a88b35c505"]
}, Closed]],
Cell[CellGroupData[{
Cell[16026, 406, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"1456043d-fdff-4216-bf25-7847cd008b43"],
Cell[16595, 426, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c0593b3f-9c3f-4000-8732-693262b81a1f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17457, 458, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"8feb6405-1bd6-49ec-bd02-51f33318af93"],
Cell[17744, 469, 434, 9, 70, "Exercise", "ExpressionUUID" -> \
"68755a0b-8d38-4b72-adf1-608414df8897",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[18203, 482, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b5eed556-f2b7-4037-9f73-186de7768a88"],
Cell[18842, 503, 10233, 196, 70, "ExerciseOutput", "ExpressionUUID" -> \
"19471d71-3265-470c-b2f4-175147fa83ac"]
}, Closed]],
Cell[CellGroupData[{
Cell[29112, 704, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"5db16c50-5bce-42af-8a80-6d38c85c03f9"],
Cell[29681, 724, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d1b016a7-b959-4bd3-9ec3-b18f4146c185",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30543, 756, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2deb9b84-c662-46bc-ade8-286110b61433"],
Cell[30830, 767, 812, 28, 70, "Exercise", "ExpressionUUID" -> \
"11690a98-e0f9-4d4a-8283-4866151112b6",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[31667, 799, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d53e1393-14ea-4442-97ea-cde3a1efe3de"],
Cell[32306, 820, 4879, 109, 70, "ExerciseOutput", "ExpressionUUID" -> \
"94cba6b2-1333-4d83-a7a2-e3f14cfcfc71"]
}, Closed]],
Cell[CellGroupData[{
Cell[37222, 934, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"498ad7d8-0200-42a3-9725-0f09c11655b2"],
Cell[37791, 954, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9dba14d1-1360-4bcb-9d05-f6393c196559",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38653, 986, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"73580afe-307c-4e73-b044-3b8e1834adf4"],
Cell[38940, 997, 662, 19, 70, "Exercise", "ExpressionUUID" -> \
"f9acd2a0-c5a5-4383-a90b-e47ba2dd13f2",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[39627, 1020, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b4af44c4-c21b-4539-8c15-4aaf7210a216"],
Cell[40266, 1041, 7174, 146, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3fa4b30f-b99c-4840-b87d-8303d893e838"]
}, Closed]],
Cell[CellGroupData[{
Cell[47477, 1192, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"3d4cd4bd-3788-4855-acf3-8155268378a4"],
Cell[48046, 1212, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9655750b-54f1-40f8-b975-e2ccc4152454",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48908, 1244, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b9bd1637-93d4-469d-b986-197b18ba344f"],
Cell[49195, 1255, 498, 12, 70, "Exercise", "ExpressionUUID" -> \
"e489dc44-8426-4e60-9bcd-c86bca7f2b36",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[49718, 1271, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c1893f84-7399-43c9-9ae4-098fdc7fdd96"],
Cell[50357, 1292, 6908, 142, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0bb34294-0676-4c7a-88e3-78a19bbcc6ae"]
}, Closed]],
Cell[CellGroupData[{
Cell[57302, 1439, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"4c581d89-2f5e-4be2-9dd3-6e4916e9f5fd"],
Cell[57871, 1459, 813, 26, 70, "Input", "ExpressionUUID" -> \
"31ee6783-f0a9-4408-a95d-2305113f439a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58733, 1491, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2aec09e6-318b-49f5-aece-c0c0ff42f94f"],
Cell[59020, 1502, 418, 9, 70, "Exercise", "ExpressionUUID" -> \
"d67f04a9-3e4e-480a-962d-ab5e2dcb80d4",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[59463, 1515, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"912ece38-7b23-4c0a-a352-f145afacc375"],
Cell[60102, 1536, 3676, 89, 70, "ExerciseOutput", "ExpressionUUID" -> \
"f4b3cd3e-ebd2-474a-bb3b-e4cfc4a16eaf"]
}, Closed]],
Cell[CellGroupData[{
Cell[63815, 1630, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"dd628164-e894-4b4f-bf68-27f88953c882"],
Cell[64384, 1650, 813, 26, 70, "Input", "ExpressionUUID" -> \
"999e1db1-80c7-4702-9552-47f6d26471f5",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65246, 1682, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"fe835b54-0148-4f4e-9458-f7b324fb90b6"],
Cell[65533, 1693, 412, 9, 70, "Exercise", "ExpressionUUID" -> \
"2d7c8383-9f18-4368-a246-b812f8540b25",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[65970, 1706, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c024e42e-58b3-4e37-9b2e-ab078aa98de5"],
Cell[66609, 1727, 3304, 83, 70, "ExerciseOutput", "ExpressionUUID" -> \
"bf9abc1d-554e-45a0-8825-9a39beaef582"]
}, Closed]],
Cell[CellGroupData[{
Cell[69950, 1815, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"ddd0f06a-cd86-4583-b36d-00eff805b730"],
Cell[70519, 1835, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f88d7bbd-d8c4-4bf1-af2b-9f42ec74b67a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71381, 1867, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"59fdc142-62bf-4d13-b9f4-7a25d94ac368"],
Cell[71668, 1878, 417, 9, 70, "Exercise", "ExpressionUUID" -> \
"002e2a79-5205-463c-841a-43c0871b051f",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[72110, 1891, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"7725b69f-3e31-493e-9558-a4a5158f2afb"],
Cell[72749, 1912, 5529, 119, 70, "ExerciseOutput", "ExpressionUUID" -> \
"fe2e2adc-cbcc-42bf-9028-858c8a27ed2a"]
}, Closed]],
Cell[CellGroupData[{
Cell[78315, 2036, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"f80b53af-e458-440a-962c-765fbd1106b4"],
Cell[78884, 2056, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8a531ce2-4c99-480a-b0a2-a5f927ccd845",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79746, 2088, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1e00f48b-8792-4d2e-ad8a-0ae55382b12d"],
Cell[80033, 2099, 429, 9, 70, "Exercise", "ExpressionUUID" -> \
"c6a75607-7d6d-4a27-99bd-b1209f98f730",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[80487, 2112, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"525661a1-9d20-4248-98e0-e0d70eddeb2b"],
Cell[81126, 2133, 3410, 85, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3bd6bfd9-2284-4e63-a9b0-433edf1cf986"]
}, Closed]],
Cell[CellGroupData[{
Cell[84573, 2223, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"94e9f014-bc55-4ca7-bbe7-53f1fbd2dcc6"],
Cell[85143, 2243, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a85dfac3-0b59-486c-8c37-55acf4cbed68",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86005, 2275, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"941e34ae-ddfb-4b1e-a7f1-09a31fb98bcd"],
Cell[86292, 2286, 436, 9, 70, "Exercise", "ExpressionUUID" -> \
"56aca05e-5860-4960-92e7-5275c7c48fcc",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[86753, 2299, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"bccae481-5f25-4dc7-b9f2-5d6a4145f69e"],
Cell[87392, 2320, 3668, 89, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b9bf1801-a2be-43d4-b246-faf71a40f19d"]
}, Closed]],
Cell[CellGroupData[{
Cell[91097, 2414, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"f18729df-5df2-4e98-95a7-43b2ae414a79"],
Cell[91667, 2434, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bbc4f16c-2f17-4776-9ba0-b63bde386b67",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92529, 2466, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"22d6c7e7-34ca-417b-ba44-a6b735c9a6d8"],
Cell[92816, 2477, 644, 22, 70, "Exercise", "ExpressionUUID" -> \
"1edd2c65-094c-4cd1-84a1-856e2609d12c",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[93485, 2503, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"7470fd00-a6ad-4064-85e0-70a7d52d82bd"],
Cell[94124, 2524, 3182, 81, 70, "ExerciseOutput", "ExpressionUUID" -> \
"34d8340b-ddaf-4ea3-8d21-98ed37043461"]
}, Closed]],
Cell[CellGroupData[{
Cell[97343, 2610, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"bb37d13a-bbc9-426b-959a-8f53b4a54381"],
Cell[97913, 2630, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3bed3ac5-feba-4f5f-8f70-f96443ec1510",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98775, 2662, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"8117c0bf-572b-479a-849b-5f403330add0"],
Cell[99062, 2673, 457, 11, 70, "Exercise", "ExpressionUUID" -> \
"4dd62a6b-61bd-48b4-9051-9bb9d297d306",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[99544, 2688, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"357049ac-8d40-4b5b-ae82-7c3882f23d4b"],
Cell[100183, 2709, 48684, 827, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c1cf991a-4f7e-4dbd-8e14-71f253ed6e94"]
}, Closed]],
Cell[CellGroupData[{
Cell[148904, 3541, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"e8500323-9e87-4540-be27-a734de52398d"],
Cell[149474, 3561, 813, 26, 70, "Input", "ExpressionUUID" -> \
"499a04a2-230f-4e63-b1b3-68b3e19b3d84",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[150336, 3593, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0841c869-908a-4b34-a2f9-8bb0c32bd443"],
Cell[150623, 3604, 745, 23, 70, "Exercise", "ExpressionUUID" -> \
"4e09ec11-12c6-4193-a2a4-cc93e1631cc5",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[151393, 3631, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5411747d-9c70-46e7-a326-b1517a525d55"],
Cell[152032, 3652, 7075, 145, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6c0c7144-6bdc-482e-817b-132e92b58567"]
}, Closed]],
Cell[CellGroupData[{
Cell[159144, 3802, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"bcac04c9-6baf-4a00-bcfa-e1cbc0bc860f"],
Cell[159714, 3822, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a4e91bb0-b370-4584-a554-1d6e7e420634",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[160576, 3854, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"591275b0-d582-4921-9a6e-2f1247eab430"],
Cell[160863, 3865, 427, 9, 70, "Exercise", "ExpressionUUID" -> \
"2f6e0177-9724-48cb-b8de-a91c639cfa5a",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[161315, 3878, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"31725588-0498-45e4-80b9-610d30c7e6db"],
Cell[161954, 3899, 7038, 144, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6eedb3aa-d220-4069-8d8e-51e8cd3bfa9c"]
}, Closed]],
Cell[CellGroupData[{
Cell[169029, 4048, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"64957444-9fbb-4af5-9095-04c0b5b3dd58"],
Cell[169599, 4068, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e1ef096a-5822-4f1b-b24b-63b3a546d461",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[170461, 4100, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0dd853fe-ddf1-448f-83ac-0602d82cd914"],
Cell[170748, 4111, 568, 17, 70, "Exercise", "ExpressionUUID" -> \
"5cc35d3c-49cc-4e60-a991-785927c160c0",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[171341, 4132, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a968c590-6408-42f8-a941-1796a40ffc35"],
Cell[171980, 4153, 7449, 151, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a005aba0-70f0-4447-a24b-ad7a37c7eb2b"]
}, Closed]],
Cell[CellGroupData[{
Cell[179466, 4309, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"6c86192b-cbde-432a-a7b1-d4513ac2d03c"],
Cell[180036, 4329, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f9411651-0d8f-49a3-9012-c102800110e1",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[180898, 4361, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c03223be-f5a7-4949-a7bd-31f80f5df90e"],
Cell[181185, 4372, 412, 9, 70, "Exercise", "ExpressionUUID" -> \
"43b40a29-eca7-42b1-8f2b-bea64bad2d8e",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[181622, 4385, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5bf89d72-e91f-4c8e-9f0e-d739610f0ac3"],
Cell[182261, 4406, 3312, 83, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4e7dd594-a88b-4aaa-9aa9-2d57f4e614de"]
}, Closed]],
Cell[CellGroupData[{
Cell[185610, 4494, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4432e45a-80b9-4b8a-a14f-f9449c8dd44d"],
Cell[186180, 4514, 813, 26, 70, "Input", "ExpressionUUID" -> \
"09683927-31b9-4ffa-bcd4-2e76a5aa2ac9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[187042, 4546, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4ccac265-62be-4113-821a-0c5083eeab15"],
Cell[187329, 4557, 422, 9, 70, "Exercise", "ExpressionUUID" -> \
"f06819fb-62a5-4091-bc6b-b169de03dba2",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[187776, 4570, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3fbff65d-9856-42c5-859e-108723e66351"],
Cell[188415, 4591, 3402, 85, 70, "ExerciseOutput", "ExpressionUUID" -> \
"70406c01-6b2d-46fa-8113-b9b85ae8a301"]
}, Closed]],
Cell[CellGroupData[{
Cell[191854, 4681, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d1f7486e-9d27-4b3a-89d0-b3c131b93a7e"],
Cell[192424, 4701, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f9f83840-fef2-452d-b9c8-a7c40254e811",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[193286, 4733, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"585c0d60-054a-4d78-93bd-788c613c4589"],
Cell[193573, 4744, 424, 9, 70, "Exercise", "ExpressionUUID" -> \
"47b37532-c722-4b58-adcc-aeb880d388b9",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[194022, 4757, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"2738a949-ef0e-4004-a4c3-f1412288c87c"],
Cell[194661, 4778, 3891, 92, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9a03acec-94f8-4e6a-b840-47e5e4bef231"]
}, Closed]],
Cell[CellGroupData[{
Cell[198589, 4875, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4dddacc9-6164-44bb-83ef-d67d18f42138"],
Cell[199159, 4895, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f21437a1-4221-4eab-babe-6dda0d10a36d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[200021, 4927, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6a61fcf9-df8b-4767-b55f-26306be8cff3"],
Cell[200308, 4938, 455, 11, 70, "Exercise", "ExpressionUUID" -> \
"13af3e97-1afa-4d2d-8cf0-6c8ba503078d",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[200788, 4953, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"11f2daf0-6746-4610-87ab-f4b38cb03d12"],
Cell[201427, 4974, 50225, 852, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5c66d712-556c-4c09-8b54-c70b2e9dab37"]
}, Closed]],
Cell[CellGroupData[{
Cell[251689, 5831, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"6bc102f1-606f-4b92-8b9f-9a67c41d7ed8"],
Cell[252259, 5851, 813, 26, 70, "Input", "ExpressionUUID" -> \
"efef7bf3-9e7b-4714-9367-7263d6bd8a36",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[253121, 5883, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4deb0be3-5589-4a3d-a3c8-f904fdfa1afa"],
Cell[253408, 5894, 465, 11, 70, "Exercise", "ExpressionUUID" -> \
"e17fdc74-4c09-4577-86b0-58bb642dd837",
 CounterAssignments->{{"SectionNumber", 5}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[253898, 5909, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"2683a2c0-44bf-429d-85c3-1600d7c44064"],
Cell[254537, 5930, 78687, 1319, 70, "ExerciseOutput", "ExpressionUUID" -> \
"632f2b7d-ebdd-4a58-8298-ea605ac3f3ac"]
}, Closed]],
Cell[CellGroupData[{
Cell[333261, 7254, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b26e12cf-3cba-4f69-b45f-64913f8e97e8"],
Cell[333831, 7274, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f6889227-d6f9-4e50-9edc-99716e746c3c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[334671, 7304, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c28a26d4-90dd-44a8-9b23-81dca2e68cf9"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature JQcpDsVS33zHwkuOwpgkcYYi *)
