(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    783294,      17685]
NotebookOptionsPosition[    682086,      15649]
NotebookOutlinePosition[    775185,      17545]
CellTagsIndexPosition[    774852,      17530]
WindowTitle->Displaying Lists: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Displaying Lists", "SectionInline",ExpressionUUID->
   "61c9633f-281d-46de-adf8-4fbf76d4ae43"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 3}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{
  "p:11", "i:1"},ExpressionUUID->"89a2af2f-4d5d-4099-bd12-8828f9d605e4"],

Cell[TextData[{
 ButtonBox["ListPlot",
  BaseStyle->"Link"],
 " is one way to display, or ",
 StyleBox["visualize",
  FontSlant->"Italic"],
 ", a list of numbers. There are ",
 "lots",
 " of others. Different ones tend to emphasize different features of a list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"161e2b65-1c59-4a43-a7a1-94ac8f1249ee"],

Cell[TextData[{
 ButtonBox["ListLinePlot",
  BaseStyle->"Link"],
 " plots a list, ",
 "joining up values",
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"575539bb-fd1a-4faf-8fde-41ad82ec8ce6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "3", ",", "5", ",", "4", ",", "1", ",", "2", ",", "1", ",", 
    "4"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"5827832c-27db-4cd1-aea4-633e8684ffe9"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], 
     LineBox[{{1., 1.}, {2., 3.}, {3., 5.}, {4., 4.}, {5., 1.}, {6., 2.}, {7.,
       1.}, {8., 4.}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{179.875, Automatic},
  Method->{},
  PlotRange->{{0., 8.}, {0, 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"4c7db806-d296-497b-8ecf-e3666bd24f3b"]
}, Open  ]],

Cell["\<\
When values jump around, it\[CloseCurlyQuote]s usually harder to understand \
if you don\[CloseCurlyQuote]t join them up: \
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"62a2571b-b3bf-48db-b1e2-351b7d6ee035"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "3", ",", "5", ",", "4", ",", "1", ",", "2", ",", "1", ",", 
    "4"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"672ac71a-9f3f-4846-8323-0c3f4ba1d0ed"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 1.}, {2., 3.}, {3., 5.}, {4., 4.}, {5., 1.}, {6., 2.}, {
      7., 1.}, {8., 4.}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{180.28125, Automatic},
  Method->{},
  PlotRange->{{0., 8.}, {0, 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"6fa61f58-7f6e-4640-a2a7-b22b6ad7f5be"]
}, Open  ]],

Cell["Making a bar chart can be useful too:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"a9917087-0b0f-4aa9-87ee-8ae4ffb9f54a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "3", ",", "5", ",", "4", ",", "1", ",", "2", ",", "1", ",", 
    "4"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"269bbda0-3d7d-45aa-b201-55127c3d5016"],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.38380952380952377`, 0.}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
     Thickness[Small]}], 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5421245421245421, 0.}, {1.4578754578754578`, 1.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{12.140106042416965`, 32.24969675514814}, {
           27.71906622688219, 49.336332783602735`}}],
         StatusArea[#, 1]& ,
         TagBoxNote->"1"],
        StyleBox["1", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.542124542124542, 0.}, {2.4578754578754576`, 3.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{33.5537791007194, 
           53.66336981345058}, {-14.515466886558897`, 49.336332783602735`}}],
         StatusArea[#, 3]& ,
         TagBoxNote->"3"],
        StyleBox["3", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[3, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.542124542124542, 0.}, {3.4578754578754576`, 5.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{54.96745215902185, 
           75.07704287175304}, {-56.74999999999999, 49.336332783602735`}}],
         StatusArea[#, 5]& ,
         TagBoxNote->"5"],
        StyleBox["5", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[5, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.542124542124542, 0.}, {4.457875457875458, 4.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{76.38112521732431, 
           96.49071593005549}, {-35.63273344327944, 49.336332783602735`}}],
         StatusArea[#, 4]& ,
         TagBoxNote->"4"],
        StyleBox["4", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{4.542124542124542, 0.}, {5.457875457875458, 1.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{97.79479827562675, 117.90438898835794`}, {
           27.71906622688219, 49.336332783602735`}}],
         StatusArea[#, 1]& ,
         TagBoxNote->"1"],
        StyleBox["1", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.542124542124542, 0.}, {6.457875457875458, 2.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{119.2084713339292, 139.31806204666037`}, {
           6.601799670161647, 49.336332783602735`}}],
         StatusArea[#, 2]& ,
         TagBoxNote->"2"],
        StyleBox["2", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.542124542124542, 0.}, {7.457875457875458, 1.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{140.62214439223163`, 160.73173510496284`}, {
           27.71906622688219, 49.336332783602735`}}],
         StatusArea[#, 1]& ,
         TagBoxNote->"1"],
        StyleBox["1", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.644], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.542124542124542, 0.}, {8.457875457875458, 4.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{162.0358174505341, 
           182.14540816326527`}, {-35.63273344327944, 49.336332783602735`}}],
         StatusArea[#, 4]& ,
         TagBoxNote->"4"],
        StyleBox["4", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[{
     {Thickness[Tiny], 
      LineBox[{{0.38380952380952377`, 0.}, {8.619356776556776, 0.}}], 
      StyleBox[{}, "GraphicsLabel",
       StripOnInput->False]}, 
     StyleBox[{
       {Thickness[Tiny], 
        LineBox[{{0.5421245421245421, 0.}, 
          Offset[{-1.102182119232618*^-15, -6.}, {0.5421245421245421, 0.}]}], 
        LineBox[{{8.457875457875458, 0.}, 
          Offset[{-1.102182119232618*^-15, -6.}, {8.457875457875458, 
           0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
       StyleBox[{}, "GraphicsLabel",
        StripOnInput->False]}, "GraphicsTicks",
      StripOnInput->False]}, "GraphicsAxes",
    StripOnInput->False,
    Antialiasing->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.38380952380952377`, 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{190.02734375, Automatic},
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"32cf1eae-5eba-414c-9b4f-f1953725dcc2"]
}, Open  ]],

Cell["\<\
So long as the list isn\[CloseCurlyQuote]t too long, a pie chart can be \
useful:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"853d8d55-a68e-4e28-a077-ab7c0373acdf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"5893319e-e9b5-4294-a5e1-ba537e270b60"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   DynamicModuleBox[{DynamicChart`click$5397$5433 = False, 
    DynamicChart`click$5404$5433 = False, DynamicChart`click$5407$5433 = 
    False, DynamicChart`click$5410$5433 = False}, {
     {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
         {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 DiskBox[{0, 0}, 1., {2.658270706883671, 3.141592653589793}]},
                
                
                ImageSizeCache->{{12.582270812626906`, 
                 71.39663543737309}, {-30.44975415221727, \
-1.6033645626269042`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5397$5433, 
                FEPrivate`Not[DynamicChart`click$5397$5433]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5397$5433, {{{1., 0}, {
               0, 1.}}, {-0.1941883634852104, 0.04786313285751154}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5397$5433}]]}, 
         {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 DiskBox[{0, 0}, 1., {1.208304866765305, 2.658270706883671}]},
                
                
                ImageSizeCache->{{18.995122601407903`, 
                 91.24952248053106}, {-60.4177291873731, \
-1.6033645626269042`}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[3, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5404$5433, 
                FEPrivate`Not[DynamicChart`click$5404$5433]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5404$5433, {{{1., 0}, {
               0, 1.}}, {-0.0709209774085071, 0.18700324853708297`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5404$5433}]]}, 
         {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], EdgeForm[{
          GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 DiskBox[{0, 0}, 1., {-1.208304866765305, 1.208304866765305}]},
                
                ImageSizeCache->{{68.56820831262691, 
                 127.38257293737311`}, {-56.77955261184355, 
                 50.74439636184355}}],
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[5, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5407$5433, 
                FEPrivate`Not[DynamicChart`click$5407$5433]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5407$5433, {{{1., 0}, {0, 1.}}, {0.2, 0}}, {{
             1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5407$5433}]]}, 
         {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-3.141592653589793, -1.208304866765305}]},
                
                ImageSizeCache->{{12.582270812626906`, 
                 91.24952248053104}, {-4.431791687373099, 54.3825729373731}}],
               
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[4, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5410$5433, 
                FEPrivate`Not[DynamicChart`click$5410$5433]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5410$5433, {{{1., 0}, {
               0, 1.}}, {-0.11361294934623115`, -0.1645967731787313}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {
             DynamicChart`click$5410$5433}]]}}}, {}}, {}}, {{{
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 1]& ,
             TagBoxNote->"1"],
            StyleBox["1", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[1, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5397$5433, 
              FEPrivate`Not[DynamicChart`click$5397$5433]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$5397$5433, {{{1., 0}, {
             0, 1.}}, {-0.1941883634852104, 0.04786313285751154}}, {{1, 0}, {
           0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$5397$5433}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 3]& ,
             TagBoxNote->"3"],
            StyleBox["3", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[3, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5404$5433, 
              FEPrivate`Not[DynamicChart`click$5404$5433]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$5404$5433, {{{1., 0}, {
             0, 1.}}, {-0.0709209774085071, 0.18700324853708297`}}, {{1, 0}, {
           0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$5404$5433}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 5]& ,
             TagBoxNote->"5"],
            StyleBox["5", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[5, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5407$5433, 
              FEPrivate`Not[DynamicChart`click$5407$5433]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$5407$5433, {{{1., 0}, {0, 1.}}, {0.2, 0}}, {{1,
            0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$5407$5433}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 4]& ,
             TagBoxNote->"4"],
            StyleBox["4", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[4, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5410$5433, 
              FEPrivate`Not[DynamicChart`click$5410$5433]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$5410$5433, {{{1., 0}, {
             0, 1.}}, {-0.11361294934623115`, -0.1645967731787313}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$5410$5433}]]}, {}}, {}}},
    DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
  ContentSelectable->False,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{139.96484375, Automatic},
  LabelStyle->{
    GrayLevel[0], FontFamily -> "Arial"},
  PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
  PlotRangePadding->Scaled[0.02]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[4]=",ExpressionUUID->"46f44eea-5c5d-46b9-a98b-3f22b9f27044"]
}, Open  ]],

Cell["\<\
If you just want to know which numbers appear, you can plot them on a number \
line:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:12", "i:6"},ExpressionUUID->"228b2284-66a3-4738-8f90-ffbd64527792"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "7", ",", "11", ",", "25"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"7c531024-517f-4a30-99fc-affa8a74b554"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
    AbsoluteThickness[1.6], PointBox[{1, 1}]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
    AbsoluteThickness[1.6], PointBox[{7, 1}]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
    AbsoluteThickness[1.6], PointBox[{11, 1}]}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
    AbsoluteThickness[1.6], PointBox[{25, 1}]}},
  AspectRatio->NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948],
  Axes->{True, False},
  AxesLabel->{None},
  AxesOrigin->{Automatic, Automatic},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  PlotRange->{{1., 25.}, {0, 1}},
  PlotRangePadding->{{
     Scaled[0.1], 
     Scaled[0.1]}, {0, 1}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"67fa0603-950b-4bf7-a05d-8244f6c65ecc"]
}, Open  ]],

Cell["\<\
Sometimes you don\[CloseCurlyQuote]t want a plot at all; you just want to put \
the elements of a list in a column:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"607ce741-8e85-4d3f-a4f8-c53beabb0d36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{"100", ",", "350", ",", "502", ",", "400"}], "}"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"31754e54-2dcc-4bd2-b558-8c4e057a9bc6"],

Cell[BoxData[
 TagBox[GridBox[{
    {"100"},
    {"350"},
    {"502"},
    {"400"}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"e83ab20a-7c41-400b-b2e3-82d7b83a5c86"]
}, Open  ]],

Cell["\<\
Lists can contain anything, including graphics. So you can combine plots by \
putting them in lists.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ef0d2731-e9d6-46d4-84df-218976876cb8"],

Cell["Make a list of two pie charts:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2637b9c7-3950-4981-bb27-32003d652413"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PieChart", "[", 
    RowBox[{"Range", "[", "3", "]"}], "]"}], ",", 
   RowBox[{"PieChart", "[", 
    RowBox[{"Range", "[", "5", "]"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"3513756b-6ee8-4c3b-87c0-b24c30d976d5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$5496$5572 = False, 
      DynamicChart`click$5499$5572 = False, DynamicChart`click$5502$5572 = 
      False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {2.0943951023931957`, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{11.745161437626901`, 
                   67.21108856237309}, {-50.20275075407649, \
-1.7889114376269042`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5496$5572, 
                  FEPrivate`Not[DynamicChart`click$5496$5572]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5496$5572, {{{1., 0}, {
                 0, 1.}}, {-0.17320508075688776`, 0.09999999999999999}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$5496$5572}]]}, 
           {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{GrayLevel[
            0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   DiskBox[{0, 0}, 1., {0., 2.0943951023931957`}]},
                  
                  ImageSizeCache->{{38.0639114376269, 
                   119.8485885623731}, {-57.2548385623731, \
-1.7889114376269033`}}],
                 StatusArea[#, 2]& ,
                 TagBoxNote->"2"],
                StyleBox["2", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[2, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5499$5572, 
                  FEPrivate`Not[DynamicChart`click$5499$5572]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5499$5572, {{{1., 0}, {0, 1.}}, {
                0.09999999999999998, 0.17320508075688776`}}, {{1, 0}, {0, 
               1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$5499$5572}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   DiskBox[{0, 0}, 1., {-3.141592653589793, 0.}]},
                  
                  ImageSizeCache->{{11.745161437626901`, 
                   119.8485885623731}, {-4.6173385623731065`, 
                   50.848588562373095`}}],
                 StatusArea[#, 3]& ,
                 TagBoxNote->"3"],
                StyleBox["3", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[3, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5502$5572, 
                  FEPrivate`Not[DynamicChart`click$5502$5572]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5502$5572, {{{1., 0}, {0, 1.}}, {
                1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 0}, {
               0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$5502$5572}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5496$5572, 
                FEPrivate`Not[DynamicChart`click$5496$5572]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5496$5572, {{{1., 0}, {
               0, 1.}}, {-0.17320508075688776`, 0.09999999999999999}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5496$5572}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5499$5572, 
                FEPrivate`Not[DynamicChart`click$5499$5572]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5499$5572, {{{1., 0}, {0, 1.}}, {
              0.09999999999999998, 0.17320508075688776`}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5499$5572}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[3, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5502$5572, 
                FEPrivate`Not[DynamicChart`click$5502$5572]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5502$5572, {{{1., 0}, {0, 1.}}, {
              1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
              1}}], TrackedSymbols :> {
             DynamicChart`click$5502$5572}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{131.59375, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]], ",", 
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{DynamicChart`click$5537$5573 = False, 
      DynamicChart`click$5540$5573 = False, DynamicChart`click$5543$5573 = 
      False, DynamicChart`click$5546$5573 = False, 
      DynamicChart`click$5549$5573 = False}, {
       {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {2.722713633111154, 
                    3.141592653589793}]},
                  
                  ImageSizeCache->{{12.127583312626907`, 
                   69.12319793737309}, {-26.73700919598055, \
-1.8768020626269042`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[1, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5537$5573, 
                  FEPrivate`Not[DynamicChart`click$5537$5573]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5537$5573, {{{1., 0}, {
                 0, 1.}}, {-0.19562952014676113`, 0.041582338163551946`}}, {{
               1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$5537$5573}]]}, 
           {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
            GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {1.8849555921538759`, 
                    2.722713633111154}]},
                  
                  ImageSizeCache->{{16.810582718726845`, 
                   69.12319793737309}, {-56.22128582862949, \
-1.8768020626269042`}}],
                 StatusArea[#, 2]& ,
                 TagBoxNote->"2"],
                StyleBox["2", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[2, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5540$5573, 
                  FEPrivate`Not[DynamicChart`click$5540$5573]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5540$5573, {{{1., 0}, {
                 0, 1.}}, {-0.1338261212717716, 0.1486289650954789}}, {{1, 
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$5540$5573}]]}, 
           {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{GrayLevel[
            0], Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {0.6283185307179586, 
                    1.8849555921538759`}]},
                  ImageSizeCache->{{49.55618933763269, 
                   112.94537316236733`}, {-58.8724166873731, \
-1.8768020626269033`}}],
                 StatusArea[#, 3]& ,
                 TagBoxNote->"3"],
                StyleBox["3", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[3, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5543$5573, 
                  FEPrivate`Not[DynamicChart`click$5543$5573]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5543$5573, {{{1., 0}, {0, 1.}}, {
                0.06180339887498949, 0.1902113032590307}}, {{1, 0}, {0, 
               1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$5543$5573}]]}, 
           {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    0.6283185307179586}]},
                  
                  ImageSizeCache->{{66.29477081262691, 
                   123.29038543737309`}, {-36.54390315803429, 
                   45.03335836392798}}],
                 StatusArea[#, 4]& ,
                 TagBoxNote->"4"],
                StyleBox["4", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[4, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5546$5573, 
                  FEPrivate`Not[DynamicChart`click$5546$5573]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5546$5573, {{{1., 0}, {0, 1.}}, {
                0.19562952014676116`, -0.041582338163551835`}}, {{1, 0}, {0, 
               1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {DynamicChart`click$5546$5573}]]}, 
           {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
            Opacity[0.5]}], GeometricTransformationBox[
             TagBox[
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]},
                  
                  ImageSizeCache->{{12.127583312626907`, 
                   96.20679168737311}, {-4.7052291873731065`, 
                   52.29038543737309}}],
                 StatusArea[#, 5]& ,
                 TagBoxNote->"5"],
                StyleBox["5", {
                  GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                 False]],
               Annotation[#, 
                Style[5, {
                  GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
              
              EventHandlerTag[{
               "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5549$5573, 
                  FEPrivate`Not[DynamicChart`click$5549$5573]], 
                PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                True}]], Dynamic[
             If[DynamicChart`click$5549$5573, {{{1., 0}, {
                 0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1,
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
              TrackedSymbols :> {
               DynamicChart`click$5549$5573}]]}}}, {}}, {}}, {{{
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5537$5573, 
                FEPrivate`Not[DynamicChart`click$5537$5573]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5537$5573, {{{1., 0}, {
               0, 1.}}, {-0.19562952014676113`, 0.041582338163551946`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5537$5573}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5540$5573, 
                FEPrivate`Not[DynamicChart`click$5540$5573]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5540$5573, {{{1., 0}, {
               0, 1.}}, {-0.1338261212717716, 0.1486289650954789}}, {{1, 0}, {
             0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5540$5573}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[3, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5543$5573, 
                FEPrivate`Not[DynamicChart`click$5543$5573]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5543$5573, {{{1., 0}, {0, 1.}}, {
              0.06180339887498949, 0.1902113032590307}}, {{1, 0}, {0, 1}}, {{
             1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5543$5573}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[4, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5546$5573, 
                FEPrivate`Not[DynamicChart`click$5546$5573]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5546$5573, {{{1., 0}, {0, 1.}}, {
              0.19562952014676116`, -0.041582338163551835`}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5546$5573}]], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{{}, {}},
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[5, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5549$5573, 
                FEPrivate`Not[DynamicChart`click$5549$5573]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$5549$5573, {{{1., 0}, {
               0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$5549$5573}]]}, {}}, {}}},
      DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
    ContentSelectable->False,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{135.41796875, Automatic},
    LabelStyle->{
      GrayLevel[0], FontFamily -> "Arial"},
    PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
    PlotRangePadding->Scaled[0.02]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"9dfe1c85-0038-47aa-8357-e6fbb5485764"]
}, Open  ]],

Cell["Show three bar charts together:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"96740fcc-f0d5-40ee-8fd9-9f68eb623a3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BarChart", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"BarChart", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"BarChart", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}]}], 
  "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"933a9794-c72a-4c90-863b-1e453194612f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Opacity[0], PointBox[{0.4655474452554744, 0.}]}, {{}, 
      {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
       0.6719999999999999], Thickness[Small]}], 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{0.5437956204379562, 0.}, {1.4562043795620436`, 1.},
               "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{10.815237859849818`, 35.396836039068816`}, {
             12.492051108215385`, 29.072734810953847`}}],
           StatusArea[#, 1]& ,
           TagBoxNote->"1"],
          StyleBox["1", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[1, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{1.543795620437956, 0.}, {2.4562043795620436`, 1.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{37.20866946427384, 61.79026764349285}, {
             12.492051108215385`, 29.072734810953847`}}],
           StatusArea[#, 1]& ,
           TagBoxNote->"1"],
          StyleBox["1", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[1, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{2.543795620437956, 0.}, {3.4562043795620436`, 4.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{63.60210106869787, 88.18369924791688}, {-35.75, 
             29.072734810953847`}}],
           StatusArea[#, 4]& ,
           TagBoxNote->"4"],
          StyleBox["4", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[4, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.543795620437956, 0.}, {4.456204379562044, 2.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{89.9955326731219, 
             114.5771308523409}, {-3.5886325945230766`, 29.072734810953847`}}],
           StatusArea[#, 2]& ,
           TagBoxNote->"2"],
          StyleBox["2", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[2, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
     StyleBox[{
       {Thickness[Tiny], 
        LineBox[{{0.4655474452554744, 0.}, {4.536017518248175, 0.}}], 
        StyleBox[{}, "GraphicsLabel",
         StripOnInput->False]}, 
       StyleBox[{
         {Thickness[Tiny], 
          LineBox[{{0.5437956204379562, 0.}, 
            Offset[{-1.102182119232618*^-15, -6.}, {0.5437956204379562, 
             0.}]}], LineBox[{{4.456204379562044, 0.}, 
            Offset[{-1.102182119232618*^-15, -6.}, {4.456204379562044, 
             0.}]}], {{}, {}, {}, {}, {}, {}}}, 
         StyleBox[{}, "GraphicsLabel",
          StripOnInput->False]}, "GraphicsTicks",
        StripOnInput->False]}, "GraphicsAxes",
      StripOnInput->False,
      Antialiasing->False]},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, True},
    AxesLabel->{None, None},
    AxesOrigin->{0.4655474452554744, 0.},
    CoordinatesToolOptions:>{"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}}, {{0.9999999999999999, 
         FormBox[
          InterpretationBox[
           StyleBox[
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}}}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{119.671875, Automatic},
    PlotRange->{{All, All}, {All, All}},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{None, Automatic}], ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{0.4655474452554744, 0.}]}, {{}, 
      {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
       0.6719999999999999], Thickness[Small]}], 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{0.5437956204379562, 0.}, {1.4562043795620436`, 5.},
               "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{10.820681213661937`, 
             35.46575133565278}, {-35.75, 29.24227044195578}}],
           StatusArea[#, 5]& ,
           TagBoxNote->"5"],
          StyleBox["5", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[5, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{1.543795620437956, 0.}, {2.4562043795620436`, 1.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{37.283678067363894`, 61.92874818935475}, {
             15.84381635356462, 29.242270441955778`}}],
           StatusArea[#, 1]& ,
           TagBoxNote->"1"],
          StyleBox["1", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[1, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{2.543795620437956, 0.}, {3.4562043795620436`, 1.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{63.746674921065875`, 88.39174504305673}, {
             15.84381635356462, 29.242270441955778`}}],
           StatusArea[#, 1]& ,
           TagBoxNote->"1"],
          StyleBox["1", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[1, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.543795620437956, 0.}, {4.456204379562044, 0.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{90.20967177476784, 114.8547418967587}, {
             28.742270441955778`, 29.242270441955778`}}],
           StatusArea[#, 0]& ,
           TagBoxNote->"0"],
          StyleBox["0", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[0, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
     StyleBox[{
       {Thickness[Tiny], 
        LineBox[{{0.4655474452554744, 0.}, {4.536017518248175, 0.}}], 
        StyleBox[{}, "GraphicsLabel",
         StripOnInput->False]}, 
       StyleBox[{
         {Thickness[Tiny], 
          LineBox[{{0.5437956204379562, 0.}, 
            Offset[{-1.102182119232618*^-15, -6.}, {0.5437956204379562, 
             0.}]}], LineBox[{{4.456204379562044, 0.}, 
            Offset[{-1.102182119232618*^-15, -6.}, {4.456204379562044, 
             0.}]}], {{}, {}, {}, {}, {}, {}}}, 
         StyleBox[{}, "GraphicsLabel",
          StripOnInput->False]}, "GraphicsTicks",
        StripOnInput->False]}, "GraphicsAxes",
      StripOnInput->False,
      Antialiasing->False]},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, True},
    AxesLabel->{None, None},
    AxesOrigin->{0.4655474452554744, 0.},
    CoordinatesToolOptions:>{"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}}, {{0.9999999999999999, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}}}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{119.9609375, Automatic},
    PlotRange->{{All, All}, {All, All}},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{None, Automatic}], ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{0.4655474452554744, 0.}]}, {{}, 
      {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
       0.6719999999999999], Thickness[Small]}], 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{0.5437956204379562, 0.}, {1.4562043795620436`, 1.},
               "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{10.816709036555798`, 35.41546179490233}, {
             12.526416438823901`, 29.118555251765198`}}],
           StatusArea[#, 1]& ,
           TagBoxNote->"1"],
          StyleBox["1", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[1, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{1.543795620437956, 0.}, {2.4562043795620436`, 3.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{37.22894205970359, 
             61.827694818050134`}, {-19.65786118705869, 29.118555251765198`}}],
           StatusArea[#, 3]& ,
           TagBoxNote->"3"],
          StyleBox["3", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[3, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{2.543795620437956, 0.}, {3.4562043795620436`, 2.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{63.64117508285139, 
             88.23992784119793}, {-3.565722374117396, 29.118555251765198`}}],
           StatusArea[#, 2]& ,
           TagBoxNote->"2"],
          StyleBox["2", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[2, {}], "Tooltip"]& ]}, 
       {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
        0.6719999999999999], Thickness[Small]}], 
        TagBox[
         TooltipBox[
          TagBox[
           DynamicBox[{
             FEPrivate`If[
              CurrentValue["MouseOver"], 
              EdgeForm[{
                GrayLevel[0.5], 
                AbsoluteThickness[1.5], 
                Opacity[0.66]}], {}, {}], 
             
             RectangleBox[{3.543795620437956, 0.}, {4.456204379562044, 4.}, 
              "RoundingRadius" -> 0]},
            
            ImageSizeCache->{{90.0534081059992, 
             114.65216086434573`}, {-35.749999999999986`, 29.1185552517652}}],
           
           StatusArea[#, 4]& ,
           TagBoxNote->"4"],
          StyleBox["4", {}, StripOnInput -> False]],
         Annotation[#, 
          Style[4, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
     StyleBox[{
       {Thickness[Tiny], 
        LineBox[{{0.4655474452554744, 0.}, {4.536017518248175, 0.}}], 
        StyleBox[{}, "GraphicsLabel",
         StripOnInput->False]}, 
       StyleBox[{
         {Thickness[Tiny], 
          LineBox[{{0.5437956204379562, 0.}, 
            Offset[{-1.102182119232618*^-15, -6.}, {0.5437956204379562, 
             0.}]}], LineBox[{{4.456204379562044, 0.}, 
            Offset[{-1.102182119232618*^-15, -6.}, {4.456204379562044, 
             0.}]}], {{}, {}, {}, {}, {}, {}}}, 
         StyleBox[{}, "GraphicsLabel",
          StripOnInput->False]}, "GraphicsTicks",
        StripOnInput->False]}, "GraphicsAxes",
      StripOnInput->False,
      Antialiasing->False]},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, True},
    AxesLabel->{None, None},
    AxesOrigin->{0.4655474452554744, 0.},
    CoordinatesToolOptions:>{"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}}, {{0.9999999999999999, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[0]], TraditionalForm], {0.004, 0}}}}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{119.75, Automatic},
    PlotRange->{{All, All}, {All, All}},
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}},
    Ticks->{None, Automatic}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"229eae52-b48f-4b6c-911a-8d4fe42c08b2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1a17d580-85cd-4d94-b0a9-80172a901cc0"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ListLinePlot",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], "]"}], " ", Cell[
    "values joined by a line ", "VocabularyText",ExpressionUUID->
     "2203ca28-fa2a-4b2f-af75-d51506461088"]},
   {
    RowBox[{
     ButtonBox["BarChart",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], "]"}], " ", Cell[
    "bar chart (values give bar heights) ", "VocabularyText",ExpressionUUID->
     "c901726d-7c7d-4680-9500-219c2f5e7e52"]},
   {
    RowBox[{
     ButtonBox["PieChart",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], "]"}], " ", Cell[
    "pie chart (values give wedge sizes) ", "VocabularyText",ExpressionUUID->
     "0faf4d12-bd3a-4c00-b8dd-158ca2df6475"]},
   {
    RowBox[{
     ButtonBox["NumberLinePlot",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], "]"}], " ", Cell[
    "numbers arranged on a line ", "VocabularyText",ExpressionUUID->
     "c1b1b256-e01e-4d0b-8a71-497657df0824"]},
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], "]"}], " ", Cell[
    "elements displayed in a column ", "VocabularyText",ExpressionUUID->
     "42acae0f-e1f1-419b-aac2-c2f24c51def1"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"39036a04-8c08-4f42-84f2-d3c4a4883b00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"8e167b4e-e586-45f3-9c32-2f85809bf2d9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"7 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 6 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-04-displaying-lists-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"85841b1a-6791-4a22-8dcb-47645d4823f7"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a bar chart of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}]], 
  "InlineCode",ExpressionUUID->"09ef7835-ee94-4bd1-9cff-8917097dca4d"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"69a9d7d2-77d1-4365-a7ba-c2eb80d36e36"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.4451141552511416, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
           0.6649999999999999], Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.6649999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.54337899543379, 0.}, {1.45662100456621, 1.}, 
                  "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{13.08114422239484, 53.83341394725397}, {
                 37.418741862761024`, 64.89781741247583}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.6649999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.54337899543379, 0.}, {2.45662100456621, 1.}, 
                  "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{57.157379571115584`, 97.9096492959747}, {
                 37.418741862761024`, 64.89781741247583}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.6649999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.5433789954337898`, 0.}, {3.45662100456621, 
                  2.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{101.23361491983633`, 141.98588464469546`}, {
                 10.439666313046224`, 64.89781741247583}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.6649999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.5433789954337898`, 0.}, {4.45662100456621, 
                  3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{145.30985026855706`, 
                 186.0621199934162}, {-16.539409236668575`, 
                 64.89781741247583}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.6649999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.543378995433789, 0.}, {5.456621004566209, 
                  5.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{189.38608561727779`, 
                 230.1383553421369}, {-70.49756033609819, 64.89781741247583}}],
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[5, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.4451141552511416, 0.}, {5.55685114155251, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5433789954337899, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5433789954337899, 
                 0.}]}], 
              LineBox[{{5.456621004566209, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {5.456621004566209, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}}}, 
             StyleBox[{}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.4451141552511416, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            4.999999999999999, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            4.999999999999999, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "b02fd422-1a22-40f7-a7fd-d818e3ef6f63"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             Opacity[0], 
             PointBox[{0.4451141552511416, 0.}]}}, {{}, {{
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.6649999999999999], 
                Thickness[Small]}], {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.6649999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.54337899543379, 0.}, {1.45662100456621, 
                    1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{13.08114422239484, 
                    53.83341394725397}, {37.418741862761024`, 
                    64.89781741247583}}], StatusArea[#, 1]& , TagBoxNote -> 
                   "1"], 
                  StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                  Style[1, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.6649999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.54337899543379, 0.}, {2.45662100456621, 
                    1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{57.157379571115584`, 
                    97.9096492959747}, {37.418741862761024`, 
                    64.89781741247583}}], StatusArea[#, 1]& , TagBoxNote -> 
                   "1"], 
                  StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                  Style[1, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.6649999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.5433789954337898`, 0.}, {3.45662100456621,
                     2.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{101.23361491983633`, 
                    141.98588464469546`}, {10.439666313046224`, 
                    64.89781741247583}}], StatusArea[#, 2]& , TagBoxNote -> 
                   "2"], 
                  StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                  Style[2, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.6649999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.5433789954337898`, 0.}, {4.45662100456621,
                     3.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{145.30985026855706`, 
                    186.0621199934162}, {-16.539409236668575`, 
                    64.89781741247583}}], StatusArea[#, 3]& , TagBoxNote -> 
                   "3"], 
                  StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                  Style[3, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.6649999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{4.543378995433789, 0.}, {5.456621004566209, 
                    5.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{189.38608561727779`, 
                    230.1383553421369}, {-70.49756033609819, 
                    64.89781741247583}}], StatusArea[#, 5]& , TagBoxNote -> 
                   "5"], 
                  StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                  Style[5, {}], "Tooltip"]& ]}}}}, {}, {}}, {}, {}, 
           StyleBox[{{{
               Thickness[Tiny], 
               LineBox[{{0.4451141552511416, 0.}, {5.55685114155251, 0.}}], 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}}, 
             StyleBox[{{{
                 Thickness[Tiny], 
                 LineBox[{{0.5433789954337899, 0.}, 
                   
                   Offset[{-1.102182119232618*^-15, -6.}, {0.5433789954337899,
                     0.}]}], 
                 LineBox[{{5.456621004566209, 0.}, 
                   
                   Offset[{-1.102182119232618*^-15, -6.}, {5.456621004566209, 
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}}}}, 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
              "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
            StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, AxesOrigin -> {0.4451141552511416, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              4.999999999999999, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              4.999999999999999, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c52197ad-b9fb-46bf-b2c5-67965dee8e28"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a pie chart of numbers from 1 to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"dfa99e21-f42e-4ff7-b911-d45e30e58f46"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {}, 
         DynamicModuleBox[{DynamicChart`click$5696$5756 = False, 
          DynamicChart`click$5699$5756 = False, DynamicChart`click$5702$5756 =
           False, DynamicChart`click$5705$5756 = False, 
          DynamicChart`click$5708$5756 = False, DynamicChart`click$5711$5756 =
           False, DynamicChart`click$5714$5756 = False, 
          DynamicChart`click$5717$5756 = False, DynamicChart`click$5720$5756 =
           False, DynamicChart`click$5723$5756 = False}, {
           {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
            0.5]}], {{{}, {
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0273529207319823`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-15.357388911865026`, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5696$5756, 
                    FEPrivate`Not[DynamicChart`click$5696$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5696$5756, {{{1., 0}, {
                    0, 1.}}, {-0.19967382078522714`, 
                    0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {
                   DynamicChart`click$5696$5756}]]}, 
               {RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.798873455016361, 
                    3.0273529207319823`}]},
                    
                    ImageSizeCache->{{23.21153984416608, 
                    121.4142135623731}, {-36.67495531105442, \
-1.5857864376269042`}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5699$5756, 
                    FEPrivate`Not[DynamicChart`click$5699$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5699$5756, {{{1., 0}, {
                    0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5699$5756}]]}, 
               {RGBColor[0.998096, 0.5661274666666667, 0.2140296888888889], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.4561542564429293`, 
                    2.798873455016361}]},
                    
                    ImageSizeCache->{{28.168727528232534`, 
                    121.41421356237309`}, {-65.18340912802465, \
-1.5857864376269042`}}],
                    StatusArea[#, 3]& ,
                    TagBoxNote->"3"],
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5702$5756, 
                    FEPrivate`Not[DynamicChart`click$5702$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5702$5756, {{{1., 0}, {
                    0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5702$5756}]]}, 
               {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.9991953250116865`, 
                    2.4561542564429293`}]},
                    
                    ImageSizeCache->{{44.26819181627499, 
                    121.41421356237309`}, {-91.73888511640686, \
-1.5857864376269104`}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5705$5756, 
                    FEPrivate`Not[DynamicChart`click$5705$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5705$5756, {{{1., 0}, {
                    0, 1.}}, {-0.12212957592708765`, 
                    0.15838044918445504`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {
                   DynamicChart`click$5705$5756}]]}, 
               {RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.4279966607226333`, 
                    1.9991953250116865`}]},
                    
                    ImageSizeCache->{{78.7059451894458, 
                    
                    135.07643803660847`}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5708$5756, 
                    FEPrivate`Not[DynamicChart`click$5708$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5708$5756, {{{1., 0}, {
                    0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5708$5756}]]}, 
               {RGBColor[
                0.7598801777777778, 0.4773333333333333, 0.3161064888888889], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.7425582635757695, 
                    1.4279966607226333`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    192.14136279850794`}, {-99.43707198294264, \
-1.5857864376268935`}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5711$5756, 
                    FEPrivate`Not[DynamicChart`click$5711$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5711$5756, {{{1., 0}, {0, 1.}}, {
                    0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5711$5756}]]}, 
               {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.05711986642890521, 
                    0.7425582635757695}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-69.327003988679, 3.89473940519882}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5714$5756, 
                    FEPrivate`Not[DynamicChart`click$5714$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5714$5756, {{{1., 0}, {0, 1.}}, {
                    0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5714$5756}]]}, 
               {RGBColor[
                0.6558762666666667, 0.4926222222222222, 0.7345293333333333], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.9710377292913908, -0.05711986642890521}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.25764753928212`}, {-4.4142135623731065`, 
                    77.65951567079941}}],
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5717$5756, 
                    FEPrivate`Not[DynamicChart`click$5717$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5717$5756, {{{1., 0}, {0, 1.}}, {
                    0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5717$5756}]]}, 
               {RGBColor[
                0.5775381333333334, 0.5239111111111111, 0.7827298666666667], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.9991953250116863`, -0.9710377292913908}]},
                    
                    ImageSizeCache->{{78.70594518944583, 
                    175.60076257358293`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5720$5756, 
                    FEPrivate`Not[DynamicChart`click$5720$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5720$5756, {{{1., 0}, {0, 1.}}, {
                    0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5720$5756}]]}, 
               {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
                Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.9991953250116863`}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    85.73888511640688}}],
                    StatusArea[#, 10]& ,
                    TagBoxNote->"10"],
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5723$5756, 
                    FEPrivate`Not[DynamicChart`click$5723$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$5723$5756, {{{1., 0}, {
                    0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$5723$5756}]]}}}, {}}, {}}, {{{
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5696$5756, 
                    FEPrivate`Not[DynamicChart`click$5696$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5696$5756, {{{1., 0}, {
                   0, 1.}}, {-0.19967382078522714`, 
                  0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                 1}}], TrackedSymbols :> {DynamicChart`click$5696$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 2]& ,
                   TagBoxNote->"2"],
                  StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5699$5756, 
                    FEPrivate`Not[DynamicChart`click$5699$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5699$5756, {{{1., 0}, {
                   0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5699$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 3]& ,
                   TagBoxNote->"3"],
                  StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5702$5756, 
                    FEPrivate`Not[DynamicChart`click$5702$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5702$5756, {{{1., 0}, {
                   0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5702$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 4]& ,
                   TagBoxNote->"4"],
                  StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5705$5756, 
                    FEPrivate`Not[DynamicChart`click$5705$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5705$5756, {{{1., 0}, {
                   0, 1.}}, {-0.12212957592708765`, 0.15838044918445504`}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5705$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 5]& ,
                   TagBoxNote->"5"],
                  StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5708$5756, 
                    FEPrivate`Not[DynamicChart`click$5708$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5708$5756, {{{1., 0}, {
                   0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1, 
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5708$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 6]& ,
                   TagBoxNote->"6"],
                  StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5711$5756, 
                    FEPrivate`Not[DynamicChart`click$5711$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5711$5756, {{{1., 0}, {0, 1.}}, {
                  0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5711$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 7]& ,
                   TagBoxNote->"7"],
                  StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5714$5756, 
                    FEPrivate`Not[DynamicChart`click$5714$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5714$5756, {{{1., 0}, {0, 1.}}, {
                  0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5714$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 8]& ,
                   TagBoxNote->"8"],
                  StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5717$5756, 
                    FEPrivate`Not[DynamicChart`click$5717$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5717$5756, {{{1., 0}, {0, 1.}}, {
                  0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5717$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 9]& ,
                   TagBoxNote->"9"],
                  StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5720$5756, 
                    FEPrivate`Not[DynamicChart`click$5720$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5720$5756, {{{1., 0}, {0, 1.}}, {
                  0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5720$5756}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 10]& ,
                   TagBoxNote->"10"],
                  StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5723$5756, 
                    FEPrivate`Not[DynamicChart`click$5723$5756]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$5723$5756, {{{1., 0}, {
                   0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$5723$5756}]]}, {}}, {}}},
          DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
        ContentSelectable->False,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        LabelStyle->{
          GrayLevel[0], FontFamily -> "Arial"},
        PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
        PlotRangePadding->Scaled[0.02]]], "ExerciseOutput",ExpressionUUID->
       "d4334850-584c-46bd-aef0-d881828abaf5"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{
            DynamicChart`click$5696$5756 = False, 
             DynamicChart`click$5699$5756 = False, 
             DynamicChart`click$5702$5756 = False, 
             DynamicChart`click$5705$5756 = False, 
             DynamicChart`click$5708$5756 = False, 
             DynamicChart`click$5711$5756 = False, 
             DynamicChart`click$5714$5756 = False, 
             DynamicChart`click$5717$5756 = False, 
             DynamicChart`click$5720$5756 = False, 
             DynamicChart`click$5723$5756 = False}, {{{
               RGBColor[0.5, 0.5, 1.], 
               EdgeForm[{
                 GrayLevel[0], 
                 Opacity[0.5]}], {{{}, {{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0273529207319823`, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-15.357388911865026`, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5696$5756, 
                    FEPrivate`Not[DynamicChart`click$5696$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5696$5756, {{{1., 0}, {
                    0, 1.}}, {-0.19967382078522714`, 
                    0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$5696$5756}]]}}, {{
                    RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.798873455016361, 
                    3.0273529207319823`}]}, 
                    ImageSizeCache -> {{23.21153984416608, 
                    121.4142135623731}, {-36.67495531105442, \
-1.5857864376269042`}}], StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5699$5756, 
                    FEPrivate`Not[DynamicChart`click$5699$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5699$5756, {{{1., 0}, {
                    0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5699$5756}]]}}, {{
                    RGBColor[
                    0.998096, 0.5661274666666667, 0.2140296888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.4561542564429293`, 
                    2.798873455016361}]}, 
                    ImageSizeCache -> {{28.168727528232534`, 
                    121.41421356237309`}, {-65.18340912802465, \
-1.5857864376269042`}}], StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5702$5756, 
                    FEPrivate`Not[DynamicChart`click$5702$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5702$5756, {{{1., 0}, {
                    0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5702$5756}]]}}, {{
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.9991953250116865`, 
                    2.4561542564429293`}]}, 
                    ImageSizeCache -> {{44.26819181627499, 
                    121.41421356237309`}, {-91.73888511640686, \
-1.5857864376269104`}}], StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5705$5756, 
                    FEPrivate`Not[DynamicChart`click$5705$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5705$5756, {{{1., 0}, {
                    0, 1.}}, {-0.12212957592708765`, 
                    0.15838044918445504`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$5705$5756}]]}}, {{
                    RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.4279966607226333`, 
                    1.9991953250116865`}]}, 
                    ImageSizeCache -> {{78.7059451894458, 
                    135.07643803660847`}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5708$5756, 
                    FEPrivate`Not[DynamicChart`click$5708$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5708$5756, {{{1., 0}, {
                    0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5708$5756}]]}}, {{
                    RGBColor[
                    0.7598801777777778, 0.4773333333333333, 
                    0.3161064888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.7425582635757695, 
                    1.4279966607226333`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    192.14136279850794`}, {-99.43707198294264, \
-1.5857864376268935`}}], StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5711$5756, 
                    FEPrivate`Not[DynamicChart`click$5711$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5711$5756, {{{1., 0}, {0, 1.}}, {
                    0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5711$5756}]]}}, {{
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.05711986642890521, 
                    0.7425582635757695}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-69.327003988679, 
                    3.89473940519882}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5714$5756, 
                    FEPrivate`Not[DynamicChart`click$5714$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5714$5756, {{{1., 0}, {0, 1.}}, {
                    0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5714$5756}]]}}, {{
                    RGBColor[
                    0.6558762666666667, 0.4926222222222222, 
                    0.7345293333333333], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.9710377292913908, -0.05711986642890521}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.25764753928212`}, {-4.4142135623731065`, 
                    77.65951567079941}}], StatusArea[#, 8]& , TagBoxNote -> 
                    "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5717$5756, 
                    FEPrivate`Not[DynamicChart`click$5717$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5717$5756, {{{1., 0}, {0, 1.}}, {
                    0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5717$5756}]]}}, {{
                    RGBColor[
                    0.5775381333333334, 0.5239111111111111, 
                    0.7827298666666667], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.9991953250116863`, -0.9710377292913908}]}, 
                    ImageSizeCache -> {{78.70594518944583, 
                    175.60076257358293`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 9]& , TagBoxNote -> 
                    "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5720$5756, 
                    FEPrivate`Not[DynamicChart`click$5720$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5720$5756, {{{1., 0}, {0, 1.}}, {
                    0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5720$5756}]]}}, {{
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.9991953250116863`}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    85.73888511640688}}], StatusArea[#, 10]& , TagBoxNote -> 
                    "10"], 
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5723$5756, 
                    FEPrivate`Not[DynamicChart`click$5723$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5723$5756, {{{1., 0}, {
                    0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5723$5756}]]}}}}, {}}, {}}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5696$5756, 
                    FEPrivate`Not[DynamicChart`click$5696$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5696$5756, {{{1., 0}, {
                    0, 1.}}, {-0.19967382078522714`, 
                    0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$5696$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5699$5756, 
                    FEPrivate`Not[DynamicChart`click$5699$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5699$5756, {{{1., 0}, {
                    0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5699$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5702$5756, 
                    FEPrivate`Not[DynamicChart`click$5702$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5702$5756, {{{1., 0}, {
                    0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5702$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5705$5756, 
                    FEPrivate`Not[DynamicChart`click$5705$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5705$5756, {{{1., 0}, {
                    0, 1.}}, {-0.12212957592708765`, 
                    0.15838044918445504`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$5705$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5708$5756, 
                    FEPrivate`Not[DynamicChart`click$5708$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5708$5756, {{{1., 0}, {
                    0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5708$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5711$5756, 
                    FEPrivate`Not[DynamicChart`click$5711$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5711$5756, {{{1., 0}, {0, 1.}}, {
                    0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5711$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5714$5756, 
                    FEPrivate`Not[DynamicChart`click$5714$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5714$5756, {{{1., 0}, {0, 1.}}, {
                    0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5714$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 8]& , TagBoxNote -> "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5717$5756, 
                    FEPrivate`Not[DynamicChart`click$5717$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5717$5756, {{{1., 0}, {0, 1.}}, {
                    0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5717$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5720$5756, 
                    FEPrivate`Not[DynamicChart`click$5720$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5720$5756, {{{1., 0}, {0, 1.}}, {
                    0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$5720$5756}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 10]& , TagBoxNote -> "10"], 
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5723$5756, 
                    FEPrivate`Not[DynamicChart`click$5723$5756]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$5723$5756, {{{1., 0}, {
                    0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$5723$5756}]]}, {}}, {}}}, 
            DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}}, 
          ContentSelectable -> False, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], LabelStyle -> {
            GrayLevel[0], FontFamily -> "Arial"}, 
          PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
          Scaled[0.02]]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2cc5f816-72eb-4759-9228-5aaf26ea3232"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a bar chart of numbers counting down from 20 to 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"372dc506-4658-4731-909e-d671f33970fa"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.13851851851851854`, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
           0.5599999999999999], Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5370370370370371, 0.}, {1.462962962962963, 
                  20.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{17.986988913212343`, 
                 28.33129400896593}, {-68.65522206792215, 
                 63.807647468726316`}}],
               StatusArea[#, 20]& ,
               TagBoxNote->"20"],
              StyleBox["20", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[20, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5370370370370372`, 0.}, {2.4629629629629632`,
                   19.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{28.618838416626218`, 
                 38.9631435123798}, {-62.057078591089734`, 
                 63.807647468726316`}}],
               StatusArea[#, 19]& ,
               TagBoxNote->"19"],
              StyleBox["19", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[19, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.537037037037037, 0.}, {3.4629629629629632`, 
                  18.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{39.25068792004009, 
                 49.594993015793676`}, {-55.458935114257315`, 
                 63.807647468726316`}}],
               StatusArea[#, 18]& ,
               TagBoxNote->"18"],
              StyleBox["18", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[18, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.537037037037037, 0.}, {4.462962962962963, 
                  17.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{49.88253742345397, 
                 60.22684251920755}, {-48.86079163742488, 
                 63.807647468726316`}}],
               StatusArea[#, 17]& ,
               TagBoxNote->"17"],
              StyleBox["17", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[17, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.537037037037037, 0.}, {5.462962962962963, 
                  16.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{60.51438692686784, 
                 70.85869202262143}, {-42.26264816059246, 
                 63.807647468726316`}}],
               StatusArea[#, 16]& ,
               TagBoxNote->"16"],
              StyleBox["16", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[16, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.537037037037037, 0.}, {6.462962962962963, 
                  15.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{71.14623643028172, 
                 81.49054152603529}, {-35.66450468376004, 
                 63.807647468726316`}}],
               StatusArea[#, 15]& ,
               TagBoxNote->"15"],
              StyleBox["15", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[15, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.537037037037037, 0.}, {7.462962962962963, 
                  14.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{81.77808593369558, 
                 92.12239102944916}, {-29.06636120692761, 
                 63.807647468726316`}}],
               StatusArea[#, 14]& ,
               TagBoxNote->"14"],
              StyleBox["14", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[14, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{7.537037037037037, 0.}, {8.462962962962964, 
                  13.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{92.40993543710945, 
                 102.75424053286305`}, {-22.46821773009519, 
                 63.807647468726316`}}],
               StatusArea[#, 13]& ,
               TagBoxNote->"13"],
              StyleBox["13", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[13, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{8.537037037037038, 0.}, {9.462962962962964, 
                  12.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{103.04178494052334`, 
                 113.38609003627693`}, {-15.870074253262771`, 
                 63.807647468726316`}}],
               StatusArea[#, 12]& ,
               TagBoxNote->"12"],
              StyleBox["12", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[12, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{9.537037037037038, 0.}, {10.462962962962964`, 
                  11.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{113.6736344439372, 
                 124.01793953969079`}, {-9.271930776430338, 
                 63.807647468726316`}}],
               StatusArea[#, 11]& ,
               TagBoxNote->"11"],
              StyleBox["11", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[11, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{10.537037037037038`, 0.}, {11.462962962962964`,
                   10.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{124.30548394735108`, 
                 134.64978904310468`}, {-2.673787299597919, 
                 63.807647468726316`}}],
               StatusArea[#, 10]& ,
               TagBoxNote->"10"],
              StyleBox["10", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[10, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{11.537037037037038`, 0.}, {12.462962962962964`,
                   9.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{134.93733345076495`, 145.28163854651854`}, {
                 3.9243561772345004`, 63.807647468726316`}}],
               StatusArea[#, 9]& ,
               TagBoxNote->"9"],
              StyleBox["9", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[9, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{12.537037037037038`, 0.}, {13.462962962962964`,
                   8.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{145.56918295417884`, 155.91348804993243`}, {
                 10.522499654066927`, 63.807647468726316`}}],
               StatusArea[#, 8]& ,
               TagBoxNote->"8"],
              StyleBox["8", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[8, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{13.537037037037038`, 0.}, {14.462962962962964`,
                   7.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{156.2010324575927, 166.5453375533463}, {
                 17.120643130899353`, 63.807647468726316`}}],
               StatusArea[#, 7]& ,
               TagBoxNote->"7"],
              StyleBox["7", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[7, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{14.537037037037038`, 0.}, {15.462962962962964`,
                   6.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{166.83288196100656`, 177.17718705676015`}, {
                 23.718786607731772`, 63.807647468726316`}}],
               StatusArea[#, 6]& ,
               TagBoxNote->"6"],
              StyleBox["6", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[6, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{15.537037037037038`, 0.}, {16.462962962962965`,
                   5.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{177.46473146442045`, 187.80903656017404`}, {
                 30.3169300845642, 63.807647468726316`}}],
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[5, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{16.537037037037038`, 0.}, {17.462962962962965`,
                   4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{188.0965809678343, 198.44088606358793`}, {
                 36.915073561396625`, 63.807647468726316`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{17.537037037037038`, 0.}, {18.462962962962965`,
                   3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{198.7284304712482, 209.07273556700179`}, {
                 43.513217038229044`, 63.807647468726316`}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{18.537037037037038`, 0.}, {19.462962962962965`,
                   2.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{209.36027997466206`, 219.70458507041567`}, {
                 50.11136051506147, 63.807647468726316`}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5599999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{19.537037037037038`, 0.}, {20.462962962962965`,
                   1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{219.99212947807595`, 230.33643457382954`}, {
                 56.70950399189389, 63.807647468726316`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.13851851851851854`, 0.}, {20.869451851851853`, 0.}}], 
            
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5370370370370371, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5370370370370371, 
                 0.}]}], 
              LineBox[{{20.462962962962965`, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {20.462962962962965`, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
             StyleBox[{}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.13851851851851854`, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "18c54f07-9d46-4cc3-8274-66705e9bb5d2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             Opacity[0], 
             PointBox[{0.13851851851851854`, 0.}]}}, {{}, {{
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5599999999999999], 
                Thickness[Small]}], {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.5370370370370371, 0.}, {1.462962962962963,
                     20.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{17.986988913212343`, 
                    28.33129400896593}, {-68.65522206792215, 
                    63.807647468726316`}}], StatusArea[#, 20]& , TagBoxNote -> 
                   "20"], 
                  StyleBox["20", {}, StripOnInput -> False]], Annotation[#, 
                  Style[20, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.5370370370370372`, 0.}, {
                    2.4629629629629632`, 19.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{28.618838416626218`, 
                    38.9631435123798}, {-62.057078591089734`, 
                    63.807647468726316`}}], StatusArea[#, 19]& , TagBoxNote -> 
                   "19"], 
                  StyleBox["19", {}, StripOnInput -> False]], Annotation[#, 
                  Style[19, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.537037037037037, 0.}, {
                    3.4629629629629632`, 18.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{39.25068792004009, 
                    49.594993015793676`}, {-55.458935114257315`, 
                    63.807647468726316`}}], StatusArea[#, 18]& , TagBoxNote -> 
                   "18"], 
                  StyleBox["18", {}, StripOnInput -> False]], Annotation[#, 
                  Style[18, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.537037037037037, 0.}, {4.462962962962963, 
                    17.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{49.88253742345397, 
                    60.22684251920755}, {-48.86079163742488, 
                    63.807647468726316`}}], StatusArea[#, 17]& , TagBoxNote -> 
                   "17"], 
                  StyleBox["17", {}, StripOnInput -> False]], Annotation[#, 
                  Style[17, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{4.537037037037037, 0.}, {5.462962962962963, 
                    16.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{60.51438692686784, 
                    70.85869202262143}, {-42.26264816059246, 
                    63.807647468726316`}}], StatusArea[#, 16]& , TagBoxNote -> 
                   "16"], 
                  StyleBox["16", {}, StripOnInput -> False]], Annotation[#, 
                  Style[16, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.537037037037037, 0.}, {6.462962962962963, 
                    15.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{71.14623643028172, 
                    81.49054152603529}, {-35.66450468376004, 
                    63.807647468726316`}}], StatusArea[#, 15]& , TagBoxNote -> 
                   "15"], 
                  StyleBox["15", {}, StripOnInput -> False]], Annotation[#, 
                  Style[15, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.537037037037037, 0.}, {7.462962962962963, 
                    14.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{81.77808593369558, 
                    92.12239102944916}, {-29.06636120692761, 
                    63.807647468726316`}}], StatusArea[#, 14]& , TagBoxNote -> 
                   "14"], 
                  StyleBox["14", {}, StripOnInput -> False]], Annotation[#, 
                  Style[14, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.537037037037037, 0.}, {8.462962962962964, 
                    13.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{92.40993543710945, 
                    102.75424053286305`}, {-22.46821773009519, 
                    63.807647468726316`}}], StatusArea[#, 13]& , TagBoxNote -> 
                   "13"], 
                  StyleBox["13", {}, StripOnInput -> False]], Annotation[#, 
                  Style[13, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.537037037037038, 0.}, {9.462962962962964, 
                    12.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{103.04178494052334`, 
                    113.38609003627693`}, {-15.870074253262771`, 
                    63.807647468726316`}}], StatusArea[#, 12]& , TagBoxNote -> 
                   "12"], 
                  StyleBox["12", {}, StripOnInput -> False]], Annotation[#, 
                  Style[12, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.537037037037038, 0.}, {
                    10.462962962962964`, 11.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{113.6736344439372, 
                    124.01793953969079`}, {-9.271930776430338, 
                    63.807647468726316`}}], StatusArea[#, 11]& , TagBoxNote -> 
                   "11"], 
                  StyleBox["11", {}, StripOnInput -> False]], Annotation[#, 
                  Style[11, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10.537037037037038`, 0.}, {
                    11.462962962962964`, 10.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{124.30548394735108`, 
                    134.64978904310468`}, {-2.673787299597919, 
                    63.807647468726316`}}], StatusArea[#, 10]& , TagBoxNote -> 
                   "10"], 
                  StyleBox["10", {}, StripOnInput -> False]], Annotation[#, 
                  Style[10, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{11.537037037037038`, 0.}, {
                    12.462962962962964`, 9.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{134.93733345076495`, 
                    145.28163854651854`}, {3.9243561772345004`, 
                    63.807647468726316`}}], StatusArea[#, 9]& , TagBoxNote -> 
                   "9"], 
                  StyleBox["9", {}, StripOnInput -> False]], Annotation[#, 
                  Style[9, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{12.537037037037038`, 0.}, {
                    13.462962962962964`, 8.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{145.56918295417884`, 
                    155.91348804993243`}, {10.522499654066927`, 
                    63.807647468726316`}}], StatusArea[#, 8]& , TagBoxNote -> 
                   "8"], 
                  StyleBox["8", {}, StripOnInput -> False]], Annotation[#, 
                  Style[8, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{13.537037037037038`, 0.}, {
                    14.462962962962964`, 7.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{156.2010324575927, 
                    166.5453375533463}, {17.120643130899353`, 
                    63.807647468726316`}}], StatusArea[#, 7]& , TagBoxNote -> 
                   "7"], 
                  StyleBox["7", {}, StripOnInput -> False]], Annotation[#, 
                  Style[7, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{14.537037037037038`, 0.}, {
                    15.462962962962964`, 6.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{166.83288196100656`, 
                    177.17718705676015`}, {23.718786607731772`, 
                    63.807647468726316`}}], StatusArea[#, 6]& , TagBoxNote -> 
                   "6"], 
                  StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                  Style[6, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{15.537037037037038`, 0.}, {
                    16.462962962962965`, 5.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{177.46473146442045`, 
                    187.80903656017404`}, {30.3169300845642, 
                    63.807647468726316`}}], StatusArea[#, 5]& , TagBoxNote -> 
                   "5"], 
                  StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                  Style[5, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{16.537037037037038`, 0.}, {
                    17.462962962962965`, 4.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{188.0965809678343, 
                    198.44088606358793`}, {36.915073561396625`, 
                    63.807647468726316`}}], StatusArea[#, 4]& , TagBoxNote -> 
                   "4"], 
                  StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                  Style[4, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{17.537037037037038`, 0.}, {
                    18.462962962962965`, 3.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{198.7284304712482, 
                    209.07273556700179`}, {43.513217038229044`, 
                    63.807647468726316`}}], StatusArea[#, 3]& , TagBoxNote -> 
                   "3"], 
                  StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                  Style[3, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{18.537037037037038`, 0.}, {
                    19.462962962962965`, 2.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{209.36027997466206`, 
                    219.70458507041567`}, {50.11136051506147, 
                    63.807647468726316`}}], StatusArea[#, 2]& , TagBoxNote -> 
                   "2"], 
                  StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                  Style[2, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.5599999999999999], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{19.537037037037038`, 0.}, {
                    20.462962962962965`, 1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{219.99212947807595`, 
                    230.33643457382954`}, {56.70950399189389, 
                    63.807647468726316`}}], StatusArea[#, 1]& , TagBoxNote -> 
                   "1"], 
                  StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                  Style[1, {}], "Tooltip"]& ]}}}}, {}, {}}, {}, {}, 
           StyleBox[{{{
               Thickness[Tiny], 
               
               LineBox[{{0.13851851851851854`, 0.}, {20.869451851851853`, 
                0.}}], 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}}, 
             StyleBox[{{{
                 Thickness[Tiny], 
                 LineBox[{{0.5370370370370371, 0.}, 
                   
                   Offset[{-1.102182119232618*^-15, -6.}, {0.5370370370370371,
                     0.}]}], 
                 LineBox[{{20.462962962962965`, 0.}, 
                   
                   Offset[{-1.102182119232618*^-15, -6.}, {
                    20.462962962962965`, 
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}}, 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
              "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
            StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, 
          AxesOrigin -> {0.13851851851851854`, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"23126828-f34a-4c11-a82c-2d50a65d1f43"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Display numbers from 1 to 5 in a column.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9621efc3-bf03-4320-8540-4f32da67b620"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"1"},
          {"2"},
          {"3"},
          {"4"},
          {"5"}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "a68bac6b-f58a-4148-83d6-d7d61e1553d3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}}, DefaultBaseStyle -> 
           "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"64956d70-502e-403d-aa1d-327ba7f8af1a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a number line plot of ",
 "the squares ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], 
  "InlineCode",ExpressionUUID->"5a736793-9c2c-4607-8b06-d03a1eda26ff"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a64323f9-5be8-49c8-9526-9496d8999a0d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{1, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{4, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{9, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{16, 1}]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], PointBox[{25, 1}]}},
        AspectRatio->NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948],
        
        Axes->{True, False},
        AxesLabel->{None},
        AxesOrigin->{Automatic, Automatic},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        ImagePadding->All,
        PlotRange->{{1., 25.}, {0, 1}},
        PlotRangePadding->{{
           Scaled[0.1], 
           Scaled[0.1]}, {0, 1}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "9debc3c6-1f6e-472c-8349-59b1be03e4a9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[{1, 1}]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[{4, 1}]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[{9, 1}]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[{16, 1}]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[{25, 1}]}}}, AspectRatio -> 
          NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
          Axes -> {True, False}, AxesLabel -> {None}, 
          AxesOrigin -> {Automatic, Automatic}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          ImagePadding -> All, PlotRange -> {{1., 25.}, {0, 1}}, 
          PlotRangePadding -> {{
             Scaled[0.1], 
             Scaled[0.1]}, {0, 1}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b44c8362-f869-47c3-8417-722ce82b5e71"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a pie chart with 10 identical segments, each of size 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d8dcc334-cc8a-478c-80db-09658a2ff326"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {}, 
         DynamicModuleBox[{DynamicChart`click$6988$7069 = False, 
          DynamicChart`click$6998$7069 = False, DynamicChart`click$7002$7069 =
           False, DynamicChart`click$7006$7069 = False, 
          DynamicChart`click$7010$7069 = False, DynamicChart`click$7014$7069 =
           False, DynamicChart`click$7018$7069 = False, 
          DynamicChart`click$7022$7069 = False, DynamicChart`click$7026$7069 =
           False, DynamicChart`click$7030$7069 = False}, {
           {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
            0.5]}], {{{}, {
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.5132741228718345`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-60.841597782450535`, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6988$7069, 
                    FEPrivate`Not[DynamicChart`click$6988$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$6988$7069, {{{1., 0}, {
                    0, 1.}}, {-0.1902113032590307, 0.06180339887498951}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$6988$7069}]]}, 
               {RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.8849555921538759`, 
                    2.5132741228718345`}]},
                    
                    ImageSizeCache->{{40.92015497763197, 
                    121.41421356237309`}, {-95.71563912670784, \
-1.5857864376269104`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6998$7069, 
                    FEPrivate`Not[DynamicChart`click$6998$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$6998$7069, {{{1., 0}, {
                    0, 1.}}, {-0.11755705045849461`, 0.1618033988749895}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$6998$7069}]]}, 
               {RGBColor[0.998096, 0.5661274666666667, 0.2140296888888889], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.256637061435917, 
                    1.8849555921538759`}]},
                    
                    ImageSizeCache->{{88.92015497763195, 
                    151.0798450223681}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7002$7069, 
                    FEPrivate`Not[DynamicChart`click$7002$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7002$7069, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                   0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7002$7069}]]}, 
               {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.6283185307179586, 
                    1.256637061435917}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    199.07984502236803`}, {-95.71563912670784, \
-1.5857864376268935`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7006$7069, 
                    FEPrivate`Not[DynamicChart`click$7006$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7006$7069, {{{1., 0}, {0, 1.}}, {
                    0.11755705045849466`, 0.16180339887498948`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7006$7069}]]}, 
               {RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0., 0.6283185307179586}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-60.841597782450535`, \
-1.5857864376268935`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7010$7069, 
                    FEPrivate`Not[DynamicChart`click$7010$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7010$7069, {{{1., 0}, {0, 1.}}, {
                    0.1902113032590307, 0.06180339887498948}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7010$7069}]]}, 
               {RGBColor[
                0.7598801777777778, 0.4773333333333333, 0.3161064888888889], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-0.6283185307179591, 0.}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-4.414213562373114, 
                    54.84159778245056}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7014$7069, 
                    FEPrivate`Not[DynamicChart`click$7014$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7014$7069, {{{1., 0}, {0, 1.}}, {
                    0.1902113032590307, -0.06180339887498953}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7014$7069}]]}, 
               {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.2566370614359172`, -0.6283185307179591}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    199.07984502236803`}, {-4.4142135623731065`, 
                    89.71563912670784}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7018$7069, 
                    FEPrivate`Not[DynamicChart`click$7018$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7018$7069, {{{1., 0}, {0, 1.}}, {
                    0.11755705045849461`, -0.1618033988749895}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7018$7069}]]}, 
               {RGBColor[
                0.6558762666666667, 0.4926222222222222, 0.7345293333333333], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.8849555921538759`, -1.2566370614359172`}]},
                    
                    ImageSizeCache->{{88.92015497763195, 
                    151.07984502236806`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7022$7069, 
                    FEPrivate`Not[DynamicChart`click$7022$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7022$7069, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                   0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7022$7069}]]}, 
               {RGBColor[
                0.5775381333333334, 0.5239111111111111, 0.7827298666666667], 
                EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.5132741228718345`, -1.8849555921538759`}]},
                    
                    ImageSizeCache->{{40.92015497763197, 
                    121.41421356237309`}, {-4.414213562373092, 
                    89.71563912670784}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7026$7069, 
                    FEPrivate`Not[DynamicChart`click$7026$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7026$7069, {{{1., 0}, {
                    0, 1.}}, {-0.11755705045849461`, -0.1618033988749895}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7026$7069}]]}, 
               {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
                Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.5132741228718345`}]},
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.4142135623731065`, 
                    54.84159778245052}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7030$7069, 
                    FEPrivate`Not[DynamicChart`click$7030$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$7030$7069, {{{1., 0}, {
                    0, 1.}}, {-0.1902113032590307, -0.06180339887498951}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$7030$7069}]]}}}, {}}, {}}, {{{
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$6988$7069, 
                    FEPrivate`Not[DynamicChart`click$6988$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$6988$7069, {{{1., 0}, {
                   0, 1.}}, {-0.1902113032590307, 0.06180339887498951}}, {{1, 
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$6988$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$6998$7069, 
                    FEPrivate`Not[DynamicChart`click$6998$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$6998$7069, {{{1., 0}, {
                   0, 1.}}, {-0.11755705045849461`, 0.1618033988749895}}, {{1,
                  0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$6998$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7002$7069, 
                    FEPrivate`Not[DynamicChart`click$7002$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7002$7069, {{{1., 0}, {0, 1.}}, {
                  1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7002$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7006$7069, 
                    FEPrivate`Not[DynamicChart`click$7006$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7006$7069, {{{1., 0}, {0, 1.}}, {
                  0.11755705045849466`, 0.16180339887498948`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7006$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7010$7069, 
                    FEPrivate`Not[DynamicChart`click$7010$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7010$7069, {{{1., 0}, {0, 1.}}, {
                  0.1902113032590307, 0.06180339887498948}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7010$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7014$7069, 
                    FEPrivate`Not[DynamicChart`click$7014$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7014$7069, {{{1., 0}, {0, 1.}}, {
                  0.1902113032590307, -0.06180339887498953}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7014$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7018$7069, 
                    FEPrivate`Not[DynamicChart`click$7018$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7018$7069, {{{1., 0}, {0, 1.}}, {
                  0.11755705045849461`, -0.1618033988749895}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7018$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7022$7069, 
                    FEPrivate`Not[DynamicChart`click$7022$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7022$7069, {{{1., 0}, {0, 1.}}, {
                  1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7022$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7026$7069, 
                    FEPrivate`Not[DynamicChart`click$7026$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7026$7069, {{{1., 0}, {
                   0, 1.}}, {-0.11755705045849461`, -0.1618033988749895}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7026$7069}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{}, {}},
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> FEPrivate`Set[DynamicChart`click$7030$7069, 
                    FEPrivate`Not[DynamicChart`click$7030$7069]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$7030$7069, {{{1., 0}, {
                   0, 1.}}, {-0.1902113032590307, -0.06180339887498951}}, {{1,
                  0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$7030$7069}]]}, {}}, {}}},
          DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
        ContentSelectable->False,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        LabelStyle->{
          GrayLevel[0], FontFamily -> "Arial"},
        PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
        PlotRangePadding->Scaled[0.02]]], "ExerciseOutput",ExpressionUUID->
       "24fa8164-5759-4e22-8fce-2cc43864d9fd"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{
            DynamicChart`click$6988$7069 = False, 
             DynamicChart`click$6998$7069 = False, 
             DynamicChart`click$7002$7069 = False, 
             DynamicChart`click$7006$7069 = False, 
             DynamicChart`click$7010$7069 = False, 
             DynamicChart`click$7014$7069 = False, 
             DynamicChart`click$7018$7069 = False, 
             DynamicChart`click$7022$7069 = False, 
             DynamicChart`click$7026$7069 = False, 
             DynamicChart`click$7030$7069 = False}, {{{
               RGBColor[0.5, 0.5, 1.], 
               EdgeForm[{
                 GrayLevel[0], 
                 Opacity[0.5]}], {{{}, {{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.5132741228718345`, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-60.841597782450535`, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6988$7069, 
                    FEPrivate`Not[DynamicChart`click$6988$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6988$7069, {{{1., 0}, {
                    0, 1.}}, {-0.1902113032590307, 0.06180339887498951}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6988$7069}]]}}, {{
                    RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {1.8849555921538759`, 
                    2.5132741228718345`}]}, 
                    ImageSizeCache -> {{40.92015497763197, 
                    121.41421356237309`}, {-95.71563912670784, \
-1.5857864376269104`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6998$7069, 
                    FEPrivate`Not[DynamicChart`click$6998$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6998$7069, {{{1., 0}, {
                    0, 1.}}, {-0.11755705045849461`, 0.1618033988749895}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6998$7069}]]}}, {{
                    RGBColor[
                    0.998096, 0.5661274666666667, 0.2140296888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.256637061435917, 
                    1.8849555921538759`}]}, 
                    ImageSizeCache -> {{88.92015497763195, 
                    151.0798450223681}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7002$7069, 
                    FEPrivate`Not[DynamicChart`click$7002$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7002$7069, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$7002$7069}]]}}, {{
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.6283185307179586, 
                    1.256637061435917}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    199.07984502236803`}, {-95.71563912670784, \
-1.5857864376268935`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7006$7069, 
                    FEPrivate`Not[DynamicChart`click$7006$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7006$7069, {{{1., 0}, {0, 1.}}, {
                    0.11755705045849466`, 0.16180339887498948`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$7006$7069}]]}}, {{
                    RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0., 0.6283185307179586}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-60.841597782450535`, \
-1.5857864376268935`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7010$7069, 
                    FEPrivate`Not[DynamicChart`click$7010$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7010$7069, {{{1., 0}, {0, 1.}}, {
                    0.1902113032590307, 0.06180339887498948}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$7010$7069}]]}}, {{
                    RGBColor[
                    0.7598801777777778, 0.4773333333333333, 
                    0.3161064888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-0.6283185307179591, 0.}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-4.414213562373114, 
                    54.84159778245056}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7014$7069, 
                    FEPrivate`Not[DynamicChart`click$7014$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7014$7069, {{{1., 0}, {0, 1.}}, {
                    0.1902113032590307, -0.06180339887498953}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$7014$7069}]]}}, {{
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.2566370614359172`, -0.6283185307179591}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    199.07984502236803`}, {-4.4142135623731065`, 
                    89.71563912670784}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7018$7069, 
                    FEPrivate`Not[DynamicChart`click$7018$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7018$7069, {{{1., 0}, {0, 1.}}, {
                    0.11755705045849461`, -0.1618033988749895}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$7018$7069}]]}}, {{
                    RGBColor[
                    0.6558762666666667, 0.4926222222222222, 
                    0.7345293333333333], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 
                    1., {-1.8849555921538759`, -1.2566370614359172`}]}, 
                    ImageSizeCache -> {{88.92015497763195, 
                    151.07984502236806`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7022$7069, 
                    FEPrivate`Not[DynamicChart`click$7022$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7022$7069, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$7022$7069}]]}}, {{
                    RGBColor[
                    0.5775381333333334, 0.5239111111111111, 
                    0.7827298666666667], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.5132741228718345`, -1.8849555921538759`}]}, 
                    ImageSizeCache -> {{40.92015497763197, 
                    121.41421356237309`}, {-4.414213562373092, 
                    89.71563912670784}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7026$7069, 
                    FEPrivate`Not[DynamicChart`click$7026$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7026$7069, {{{1., 0}, {
                    0, 1.}}, {-0.11755705045849461`, -0.1618033988749895}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$7026$7069}]]}}, {{
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.5132741228718345`}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.4142135623731065`, 
                    54.84159778245052}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7030$7069, 
                    FEPrivate`Not[DynamicChart`click$7030$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$7030$7069, {{{1., 0}, {
                    0, 1.}}, {-0.1902113032590307, -0.06180339887498951}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$7030$7069}]]}}}}, {}}, {}}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6988$7069, 
                    FEPrivate`Not[DynamicChart`click$6988$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$6988$7069, {{{1., 0}, {
                    0, 1.}}, {-0.1902113032590307, 0.06180339887498951}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$6988$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6998$7069, 
                    FEPrivate`Not[DynamicChart`click$6998$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$6998$7069, {{{1., 0}, {
                    0, 1.}}, {-0.11755705045849461`, 0.1618033988749895}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$6998$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7002$7069, 
                    FEPrivate`Not[DynamicChart`click$7002$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7002$7069, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                   0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7002$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7006$7069, 
                    FEPrivate`Not[DynamicChart`click$7006$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7006$7069, {{{1., 0}, {0, 1.}}, {
                    0.11755705045849466`, 0.16180339887498948`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7006$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7010$7069, 
                    FEPrivate`Not[DynamicChart`click$7010$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7010$7069, {{{1., 0}, {0, 1.}}, {
                    0.1902113032590307, 0.06180339887498948}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7010$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7014$7069, 
                    FEPrivate`Not[DynamicChart`click$7014$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7014$7069, {{{1., 0}, {0, 1.}}, {
                    0.1902113032590307, -0.06180339887498953}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7014$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7018$7069, 
                    FEPrivate`Not[DynamicChart`click$7018$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7018$7069, {{{1., 0}, {0, 1.}}, {
                    0.11755705045849461`, -0.1618033988749895}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7018$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7022$7069, 
                    FEPrivate`Not[DynamicChart`click$7022$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7022$7069, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                   0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7022$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7026$7069, 
                    FEPrivate`Not[DynamicChart`click$7026$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7026$7069, {{{1., 0}, {
                    0, 1.}}, {-0.11755705045849461`, -0.1618033988749895}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$7026$7069}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$7030$7069, 
                    FEPrivate`Not[DynamicChart`click$7030$7069]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$7030$7069, {{{1., 0}, {
                    0, 1.}}, {-0.1902113032590307, -0.06180339887498951}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$7030$7069}]]}, {}}, {}}}, 
            DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}}, 
          ContentSelectable -> False, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], LabelStyle -> {
            GrayLevel[0], FontFamily -> "Arial"}, 
          PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
          Scaled[0.02]]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"13a07132-beb8-401b-b6e9-8b8986ae5672"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a column of pie charts with 1, 2 and 3 identical segments.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"50d16da9-2827-477d-af79-593e94aff476"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           GraphicsBox[{{}, {}, 
             DynamicModuleBox[{DynamicChart`click$5949$6041 = False}, {
               {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
                0.5]}], {{{}, 
                  {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                   GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 
                    3.141592653589793}]},
                    ImageSizeCache->{{23., 217.}, {-100., 94.}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5949$6041, 
                    FEPrivate`Not[DynamicChart`click$5949$6041]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$5949$6041, {{{1., 0}, {0, 1.}}, {
                    0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5949$6041}]]}}, {}}, {}}, {{
                 GeometricTransformationBox[
                  TagBox[
                   TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                   
                   EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5949$6041, 
                    FEPrivate`Not[DynamicChart`click$5949$6041]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                  If[DynamicChart`click$5949$6041, {{{1., 0}, {0, 1.}}, {
                    0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                   TrackedSymbols :> {
                    DynamicChart`click$5949$6041}]], {}}, {}}},
              DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
            ContentSelectable->False,
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            LabelStyle->{
              GrayLevel[0], FontFamily -> "Arial"},
            PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
            PlotRangePadding->Scaled[0.02]]},
          {
           GraphicsBox[{{}, {}, 
             
             DynamicModuleBox[{DynamicChart`click$5980$6042 = False, 
              DynamicChart`click$5983$6042 = False}, {
               {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
                0.5]}], {{{}, {
                   {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                    GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0., 3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626894`, 
                    217.41421356237308`}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5980$6042, 
                    FEPrivate`Not[DynamicChart`click$5980$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$5980$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5980$6042}]]}, 
                   {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[
                    0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 0.}]},
                    
                    ImageSizeCache->{{22.585786437626894`, 
                    217.41421356237308`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5983$6042, 
                    FEPrivate`Not[DynamicChart`click$5983$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$5983$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5983$6042}]]}}}, {}}, {}}, {{{
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5980$6042, 
                    FEPrivate`Not[DynamicChart`click$5980$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$5980$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5980$6042}]], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5983$6042, 
                    FEPrivate`Not[DynamicChart`click$5983$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$5983$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5983$6042}]]}, {}}, {}}},
              DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
            ContentSelectable->False,
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            LabelStyle->{
              GrayLevel[0], FontFamily -> "Arial"},
            PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
            PlotRangePadding->Scaled[0.02]]},
          {
           GraphicsBox[{{}, {}, 
             
             DynamicModuleBox[{DynamicChart`click$6016$6043 = False, 
              DynamicChart`click$6019$6043 = False, 
              DynamicChart`click$6022$6043 = False}, {
               {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
                0.5]}], {{{}, {
                   {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                    GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626894`, 
                    169.41421356237308`}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6016$6043, 
                    FEPrivate`Not[DynamicChart`click$6016$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$6016$6043, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6016$6043}]]}, 
                   {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
                    GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-87.55265232567923, 
                    81.5526523256792}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6019$6043, 
                    FEPrivate`Not[DynamicChart`click$6019$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$6019$6043, {{{1., 0}, {0, 1.}}, {
                    0.2, 4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6019$6043}]]}, 
                   {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[
                    0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]},
                    
                    ImageSizeCache->{{22.585786437626894`, 
                    169.4142135623731}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6022$6043, 
                    FEPrivate`Not[DynamicChart`click$6022$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$6022$6043, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$6022$6043}]]}}}, {}}, {}}, {{{
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6016$6043, 
                    FEPrivate`Not[DynamicChart`click$6016$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$6016$6043, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6016$6043}]], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6019$6043, 
                    FEPrivate`Not[DynamicChart`click$6019$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$6019$6043, {{{1., 0}, {0, 1.}}, {0.2,
                     4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {
                    0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6019$6043}]], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6022$6043, 
                    FEPrivate`Not[DynamicChart`click$6022$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$6022$6043, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$6022$6043}]]}, {}}, {}}},
              DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
            ContentSelectable->False,
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            LabelStyle->{
              GrayLevel[0], FontFamily -> "Arial"},
            PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
            PlotRangePadding->Scaled[0.02]]}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "7d3f40cd-42fe-4d23-b2ad-dc1eb469a616"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             GraphicsBox[{{}, {}, 
               DynamicModuleBox[{DynamicChart`click$5949$6041 = False}, {{{
                   RGBColor[0.5, 0.5, 1.], 
                   EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{23., 217.}, {-100., 94.}}], 
                    StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5949$6041, 
                    FEPrivate`Not[DynamicChart`click$5949$6041]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5949$6041, {{{1., 0}, {0, 1.}}, {
                    0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5949$6041}]]}}}, {}}, {}}}, {{
                   GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5949$6041, 
                    FEPrivate`Not[DynamicChart`click$5949$6041]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5949$6041, {{{1., 0}, {0, 1.}}, {
                    0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5949$6041}]], {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]]}, {
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$5980$6042 = False, 
                 DynamicChart`click$5983$6042 = False}, {{{
                   RGBColor[0.5, 0.5, 1.], 
                   EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0., 3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626894`, 
                    217.41421356237308`}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5980$6042, 
                    FEPrivate`Not[DynamicChart`click$5980$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5980$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5980$6042}]]}}, {{
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 0.}]}, 
                    ImageSizeCache -> {{22.585786437626894`, 
                    217.41421356237308`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5983$6042, 
                    FEPrivate`Not[DynamicChart`click$5983$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5983$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5983$6042}]]}}}}, {}}, {}}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5980$6042, 
                    FEPrivate`Not[DynamicChart`click$5980$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5980$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$5980$6042}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$5983$6042, 
                    FEPrivate`Not[DynamicChart`click$5983$6042]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$5983$6042, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$5983$6042}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]]}, {
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$6016$6043 = False, 
                 DynamicChart`click$6019$6043 = False, 
                 DynamicChart`click$6022$6043 = False}, {{{
                   RGBColor[0.5, 0.5, 1.], 
                   EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626894`, 
                    169.41421356237308`}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6016$6043, 
                    FEPrivate`Not[DynamicChart`click$6016$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6016$6043, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6016$6043}]]}}, {{
                    RGBColor[0.784, 0.47519999999999996`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-87.55265232567923, 
                    81.5526523256792}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6019$6043, 
                    FEPrivate`Not[DynamicChart`click$6019$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6019$6043, {{{1., 0}, {0, 1.}}, {0.2, 
                    4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
                     1}}], TrackedSymbols :> {
                    DynamicChart`click$6019$6043}]]}}, {{
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]}, 
                    ImageSizeCache -> {{22.585786437626894`, 
                    169.4142135623731}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6022$6043, 
                    FEPrivate`Not[DynamicChart`click$6022$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6022$6043, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$6022$6043}]]}}}}, {}}, {}}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6016$6043, 
                    FEPrivate`Not[DynamicChart`click$6016$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6016$6043, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$6016$6043}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6019$6043, 
                    FEPrivate`Not[DynamicChart`click$6019$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6019$6043, {{{1., 0}, {0, 1.}}, {0.2, 
                    4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
                     1}}], TrackedSymbols :> {DynamicChart`click$6019$6043}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$6022$6043, 
                    FEPrivate`Not[DynamicChart`click$6022$6043]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$6022$6043, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$6022$6043}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]]}}, DefaultBaseStyle -> "Column", 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ddd18592-588d-4c9a-886f-ba392d70d781"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of pie charts with 1, 2 and 3 identical segments.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"dfe6e7a6-a63c-41de-9348-09db2f048fb0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{{}, {}, 
           DynamicModuleBox[{DynamicChart`click$2250$2351 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, 
                {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                 GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                  TagBox[
                   TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{21., 219.00000000000003`}, {-102., 
                    96.00000000000003}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                   
                   EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2250$2351, 
                    FEPrivate`Not[DynamicChart`click$2250$2351]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                  If[DynamicChart`click$2250$2351, {{{1., 0}, {0, 1.}}, {
                    0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                   TrackedSymbols :> {
                    DynamicChart`click$2250$2351}]]}}, {}}, {}}, {{
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                   StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$2250$2351, 
                    FEPrivate`Not[DynamicChart`click$2250$2351]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$2250$2351, {{{1., 0}, {0, 1.}}, {
                   0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$2250$2351}]], {}}, {}}, {}, {}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1., 1.}, {-1., 1.}},
          PlotRangePadding->Scaled[0.09166666666666669]], ",", 
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{DynamicChart`click$2283$2352 = False, 
            DynamicChart`click$2287$2352 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, {
                 {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0., 3.141592653589793}]},
                    
                    ImageSizeCache->{{20.585786437626894`, 
                    219.4142135623731}, {-102.4142135623731, \
-1.5857864376268793`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2283$2352, 
                    FEPrivate`Not[DynamicChart`click$2283$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$2283$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$2283$2352}]]}, 
                 {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0],
                   Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 0.}]},
                    
                    ImageSizeCache->{{20.585786437626894`, 
                    219.4142135623731}, {-4.414213562373092, 
                    96.41421356237313}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2287$2352, 
                    FEPrivate`Not[DynamicChart`click$2287$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$2287$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2287$2352}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2283$2352, 
                    FEPrivate`Not[DynamicChart`click$2283$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$2283$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                   0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$2283$2352}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2287$2352, 
                    FEPrivate`Not[DynamicChart`click$2287$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$2287$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                   0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$2287$2352}]]}, {}}, {}}, {}, {}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1., 1.}, {-1., 1.}},
          PlotRangePadding->Scaled[0.09166666666666669]], ",", 
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{DynamicChart`click$2322$2353 = False, 
            DynamicChart`click$2326$2353 = False, 
            DynamicChart`click$2330$2353 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, {
                 {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{20.585786437626894`, 
                    170.41421356237308`}, {-102.4142135623731, \
-1.5857864376268793`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2322$2353, 
                    FEPrivate`Not[DynamicChart`click$2322$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$2322$2353, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$2322$2353}]]}, 
                 {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]},
                    
                    ImageSizeCache->{{118.58578643762691`, 
                    219.4142135623731}, {-89.2847031332481, 
                    83.2847031332481}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2326$2353, 
                    FEPrivate`Not[DynamicChart`click$2326$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$2326$2353, {{{1., 0}, {0, 1.}}, {0.2,
                     4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {
                    0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$2326$2353}]]}, 
                 {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0],
                   Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]},
                    
                    ImageSizeCache->{{20.585786437626894`, 
                    170.41421356237313`}, {-4.414213562373092, 
                    96.41421356237313}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2330$2353, 
                    FEPrivate`Not[DynamicChart`click$2330$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$2330$2353, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2330$2353}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2322$2353, 
                    FEPrivate`Not[DynamicChart`click$2322$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$2322$2353, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$2322$2353}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2326$2353, 
                    FEPrivate`Not[DynamicChart`click$2326$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$2326$2353, {{{1., 0}, {0, 1.}}, {0.2, 
                    4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
                    1}}], TrackedSymbols :> {DynamicChart`click$2326$2353}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2330$2353, 
                    FEPrivate`Not[DynamicChart`click$2330$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$2330$2353, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$2330$2353}]]}, {}}, {}}, {}, {}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1., 1.}, {-1., 1.}},
          PlotRangePadding->Scaled[0.09166666666666669]]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "9aa02c27-4fd0-47c6-a11a-14ca43fc8374"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{}, {}, 
               DynamicModuleBox[{DynamicChart`click$2250$2351 = False}, {{{{
                    RGBColor[0.5, 0.5, 1.], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{{{}, {{{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{21., 219.00000000000003`}, {-102., 
                    96.00000000000003}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2250$2351, 
                    FEPrivate`Not[DynamicChart`click$2250$2351]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2250$2351, {{{1., 0}, {0, 1.}}, {
                    0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2250$2351}]]}}}}}}}, {}}, {{}}}}}, {{{{
                    
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2250$2351, 
                    FEPrivate`Not[DynamicChart`click$2250$2351]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2250$2351, {{{1., 0}, {0, 1.}}, {
                    0.2, 0}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2250$2351}]]}, {}}}, {}}, {}, {}}, 
                DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, {}}}, \
{}}}, ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1., 1.}, {-1., 1.}}, PlotRangePadding -> 
              Scaled[0.09166666666666669]], ",", 
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$2283$2352 = False, 
                 DynamicChart`click$2287$2352 = False}, {{{{
                    RGBColor[0.5, 0.5, 1.], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{{{}, {{{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0., 3.141592653589793}]}, 
                    ImageSizeCache -> {{20.585786437626894`, 
                    219.4142135623731}, {-102.4142135623731, \
-1.5857864376268793`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2283$2352, 
                    FEPrivate`Not[DynamicChart`click$2283$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2283$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$2283$2352}]]}}}, {{{
                    
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 0.}]}, 
                    ImageSizeCache -> {{20.585786437626894`, 
                    219.4142135623731}, {-4.414213562373092, 
                    96.41421356237313}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2287$2352, 
                    FEPrivate`Not[DynamicChart`click$2287$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2287$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2287$2352}]]}}}}}}}, {}}, {{}}}}}, {{{{
                    
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2283$2352, 
                    FEPrivate`Not[DynamicChart`click$2283$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2283$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, 0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$2283$2352}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2287$2352, 
                    FEPrivate`Not[DynamicChart`click$2287$2352]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2287$2352, {{{1., 0}, {0, 1.}}, {
                    1.2246467991473533`*^-17, -0.2}}, {{1, 0}, {0, 1}}, {{1, 
                    0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2287$2352}]]}, {}}}, {}}, {}, {}}, 
                DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, {}}}, \
{}}}, ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1., 1.}, {-1., 1.}}, PlotRangePadding -> 
              Scaled[0.09166666666666669]], ",", 
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$2322$2353 = False, 
                 DynamicChart`click$2326$2353 = False, 
                 DynamicChart`click$2330$2353 = False}, {{{{
                    RGBColor[0.5, 0.5, 1.], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{{{}, {{{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{20.585786437626894`, 
                    170.41421356237308`}, {-102.4142135623731, \
-1.5857864376268793`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2322$2353, 
                    FEPrivate`Not[DynamicChart`click$2322$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2322$2353, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$2322$2353}]]}}}, {{{
                    
                    RGBColor[0.784, 0.47519999999999996`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.0471975511965974`, 
                    1.0471975511965979`}]}, 
                    ImageSizeCache -> {{118.58578643762691`, 
                    219.4142135623731}, {-89.2847031332481, 
                    83.2847031332481}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2326$2353, 
                    FEPrivate`Not[DynamicChart`click$2326$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2326$2353, {{{1., 0}, {0, 1.}}, {0.2, 
                    4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
                     1}}], TrackedSymbols :> {
                    DynamicChart`click$2326$2353}]]}}}, {{{
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.0471975511965974`}]}, 
                    ImageSizeCache -> {{20.585786437626894`, 
                    170.41421356237313`}, {-4.414213562373092, 
                    96.41421356237313}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2330$2353, 
                    FEPrivate`Not[DynamicChart`click$2330$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2330$2353, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2330$2353}]]}}}}}}}, {}}, {{}}}}}, {{{{
                    
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2322$2353, 
                    FEPrivate`Not[DynamicChart`click$2322$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2322$2353, {{{1., 0}, {
                    0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$2322$2353}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2326$2353, 
                    FEPrivate`Not[DynamicChart`click$2326$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2326$2353, {{{1., 0}, {0, 1.}}, {0.2, 
                    4.4408920985006264`*^-17}}, {{1, 0}, {0, 1}}, {{1, 0}, {0,
                     1}}], TrackedSymbols :> {DynamicChart`click$2326$2353}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$2330$2353, 
                    FEPrivate`Not[DynamicChart`click$2330$2353]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$2330$2353, {{{1., 0}, {
                    0, 1.}}, {-0.09999999999999996, -0.17320508075688776`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$2330$2353}]]}, {}}}, {}}, {}, {}}, 
                DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, {}}}, \
{}}}, ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1., 1.}, {-1., 1.}}, PlotRangePadding -> 
              Scaled[0.09166666666666669]]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4a126fdf-f6c2-4293-af21-83b30ef0aa7a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a bar chart of the sequence 1, 2, 3, ..., 9, 10, 9, 8, 7, ..., 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ded906dc-1ea0-44d4-bb7c-c96355027978"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.1589639222941721, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.567],
            Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5374653098982424, 0.}, {1.4625346901017577`, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{17.986988913212343`, 28.84232402224633}, {
                 50.1113605150615, 63.807647468726344`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5374653098982425`, 0.}, {2.4625346901017577`,
                   2.}, "RoundingRadius" -> 0]},
                ImageSizeCache->{{29.181106166078084`, 40.03644127511207}, {
                 36.915073561396646`, 63.807647468726344`}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.5374653098982427`, 0.}, {3.4625346901017577`,
                   3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{40.37522341894382, 51.230558527977806`}, {
                 23.7187866077318, 63.807647468726344`}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.5374653098982427`, 0.}, {4.462534690101758, 
                  4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{51.56934067180956, 62.42467578084354}, {
                 10.522499654066955`, 63.807647468726344`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.537465309898242, 0.}, {5.462534690101758, 
                  5.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{62.76345792467529, 
                 73.61879303370928}, {-2.6737872995978904`, 
                 63.807647468726344`}}],
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[5, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.537465309898242, 0.}, {6.462534690101758, 
                  6.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{73.95757517754103, 
                 84.812910286575}, {-15.870074253262743`, 
                 63.807647468726344`}}],
               StatusArea[#, 6]& ,
               TagBoxNote->"6"],
              StyleBox["6", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[6, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.537465309898242, 0.}, {7.462534690101758, 
                  7.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{85.15169243040677, 
                 96.00702753944074}, {-29.06636120692758, 
                 63.807647468726344`}}],
               StatusArea[#, 7]& ,
               TagBoxNote->"7"],
              StyleBox["7", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[7, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{7.537465309898242, 0.}, {8.462534690101757, 
                  8.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{96.3458096832725, 
                 107.20114479230648`}, {-42.262648160592434`, 
                 63.807647468726344`}}],
               StatusArea[#, 8]& ,
               TagBoxNote->"8"],
              StyleBox["8", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[8, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{8.537465309898241, 0.}, {9.462534690101757, 
                  9.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{107.53992693613824`, 
                 118.39526204517222`}, {-55.45893511425729, 
                 63.807647468726344`}}],
               StatusArea[#, 9]& ,
               TagBoxNote->"9"],
              StyleBox["9", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[9, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{9.537465309898241, 0.}, {10.462534690101757`, 
                  10.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{118.73404418900398`, 
                 129.58937929803795`}, {-68.65522206792213, 
                 63.807647468726344`}}],
               StatusArea[#, 10]& ,
               TagBoxNote->"10"],
              StyleBox["10", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[10, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{10.537465309898241`, 0.}, {11.462534690101757`,
                   9.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{129.92816144186972`, 
                 140.7834965509037}, {-55.45893511425729, 
                 63.807647468726344`}}],
               StatusArea[#, 9]& ,
               TagBoxNote->"9"],
              StyleBox["9", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[9, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{11.537465309898241`, 0.}, {12.462534690101757`,
                   8.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{141.12227869473546`, 
                 151.97761380376943`}, {-42.262648160592434`, 
                 63.807647468726344`}}],
               StatusArea[#, 8]& ,
               TagBoxNote->"8"],
              StyleBox["8", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[8, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 RectangleBox[{12.537465309898241`, 0.}, {13.462534690101757`,
                   7.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{152.3163959476012, 
                 163.17173105663517`}, {-29.06636120692758, 
                 63.807647468726344`}}],
               StatusArea[#, 7]& ,
               TagBoxNote->"7"],
              StyleBox["7", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[7, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{13.537465309898241`, 0.}, {14.462534690101757`,
                   6.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{163.51051320046693`, 
                 174.3658483095009}, {-15.870074253262743`, 
                 63.807647468726344`}}],
               StatusArea[#, 6]& ,
               TagBoxNote->"6"],
              StyleBox["6", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[6, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{14.537465309898241`, 0.}, {15.462534690101757`,
                   5.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{174.70463045333267`, 
                 185.55996556236664`}, {-2.6737872995978904`, 
                 63.807647468726344`}}],
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[5, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{15.537465309898241`, 0.}, {16.462534690101755`,
                   4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{185.8987477061984, 196.75408281523238`}, {
                 10.522499654066955`, 63.807647468726344`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{16.53746530989824, 0.}, {17.462534690101755`, 
                  3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{197.09286495906414`, 207.94820006809812`}, {
                 23.7187866077318, 63.807647468726344`}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{17.53746530989824, 0.}, {18.462534690101755`, 
                  2.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{208.28698221192988`, 219.14231732096385`}, {
                 36.915073561396646`, 63.807647468726344`}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.567], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{18.53746530989824, 0.}, {19.462534690101755`, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{219.48109946479562`, 230.3364345738296}, {
                 50.1113605150615, 63.807647468726344`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.1589639222941721, 0.}, {19.848606105457904`, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5374653098982424, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5374653098982424, 
                 0.}]}], 
              LineBox[{{19.46253469010175, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {19.46253469010175, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}}, 
             StyleBox[{}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.1589639222941721, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            15.999999999999998`, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            15.999999999999998`, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "e6c22d7e-980a-448c-98c8-bf575fa6f028"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             Opacity[0], 
             PointBox[{0.1589639222941721, 0.}]}}, {{}, {{
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.567], 
                Thickness[Small]}], {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.5374653098982424, 0.}, {
                    1.4625346901017577`, 1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{17.986988913212343`, 
                    28.84232402224633}, {50.1113605150615, 
                    63.807647468726344`}}], StatusArea[#, 1]& , TagBoxNote -> 
                   "1"], 
                  StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                  Style[1, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.5374653098982425`, 0.}, {
                    2.4625346901017577`, 2.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{29.181106166078084`, 
                    40.03644127511207}, {36.915073561396646`, 
                    63.807647468726344`}}], StatusArea[#, 2]& , TagBoxNote -> 
                   "2"], 
                  StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                  Style[2, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.5374653098982427`, 0.}, {
                    3.4625346901017577`, 3.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{40.37522341894382, 
                    51.230558527977806`}, {23.7187866077318, 
                    63.807647468726344`}}], StatusArea[#, 3]& , TagBoxNote -> 
                   "3"], 
                  StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                  Style[3, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.5374653098982427`, 0.}, {
                    4.462534690101758, 4.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{51.56934067180956, 
                    62.42467578084354}, {10.522499654066955`, 
                    63.807647468726344`}}], StatusArea[#, 4]& , TagBoxNote -> 
                   "4"], 
                  StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                  Style[4, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{4.537465309898242, 0.}, {5.462534690101758, 
                    5.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{62.76345792467529, 
                    73.61879303370928}, {-2.6737872995978904`, 
                    63.807647468726344`}}], StatusArea[#, 5]& , TagBoxNote -> 
                   "5"], 
                  StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                  Style[5, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{5.537465309898242, 0.}, {6.462534690101758, 
                    6.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{73.95757517754103, 
                    84.812910286575}, {-15.870074253262743`, 
                    63.807647468726344`}}], StatusArea[#, 6]& , TagBoxNote -> 
                   "6"], 
                  StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                  Style[6, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.537465309898242, 0.}, {7.462534690101758, 
                    7.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{85.15169243040677, 
                    96.00702753944074}, {-29.06636120692758, 
                    63.807647468726344`}}], StatusArea[#, 7]& , TagBoxNote -> 
                   "7"], 
                  StyleBox["7", {}, StripOnInput -> False]], Annotation[#, 
                  Style[7, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.537465309898242, 0.}, {8.462534690101757, 
                    8.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{96.3458096832725, 
                    107.20114479230648`}, {-42.262648160592434`, 
                    63.807647468726344`}}], StatusArea[#, 8]& , TagBoxNote -> 
                   "8"], 
                  StyleBox["8", {}, StripOnInput -> False]], Annotation[#, 
                  Style[8, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.537465309898241, 0.}, {9.462534690101757, 
                    9.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{107.53992693613824`, 
                    118.39526204517222`}, {-55.45893511425729, 
                    63.807647468726344`}}], StatusArea[#, 9]& , TagBoxNote -> 
                   "9"], 
                  StyleBox["9", {}, StripOnInput -> False]], Annotation[#, 
                  Style[9, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.537465309898241, 0.}, {
                    10.462534690101757`, 10.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{118.73404418900398`, 
                    129.58937929803795`}, {-68.65522206792213, 
                    63.807647468726344`}}], StatusArea[#, 10]& , TagBoxNote -> 
                   "10"], 
                  StyleBox["10", {}, StripOnInput -> False]], Annotation[#, 
                  Style[10, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10.537465309898241`, 0.}, {
                    11.462534690101757`, 9.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{129.92816144186972`, 
                    140.7834965509037}, {-55.45893511425729, 
                    63.807647468726344`}}], StatusArea[#, 9]& , TagBoxNote -> 
                   "9"], 
                  StyleBox["9", {}, StripOnInput -> False]], Annotation[#, 
                  Style[9, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{11.537465309898241`, 0.}, {
                    12.462534690101757`, 8.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{141.12227869473546`, 
                    151.97761380376943`}, {-42.262648160592434`, 
                    63.807647468726344`}}], StatusArea[#, 8]& , TagBoxNote -> 
                   "8"], 
                  StyleBox["8", {}, StripOnInput -> False]], Annotation[#, 
                  Style[8, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{12.537465309898241`, 0.}, {
                    13.462534690101757`, 7.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{152.3163959476012, 
                    163.17173105663517`}, {-29.06636120692758, 
                    63.807647468726344`}}], StatusArea[#, 7]& , TagBoxNote -> 
                   "7"], 
                  StyleBox["7", {}, StripOnInput -> False]], Annotation[#, 
                  Style[7, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{13.537465309898241`, 0.}, {
                    14.462534690101757`, 6.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{163.51051320046693`, 
                    174.3658483095009}, {-15.870074253262743`, 
                    63.807647468726344`}}], StatusArea[#, 6]& , TagBoxNote -> 
                   "6"], 
                  StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                  Style[6, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{14.537465309898241`, 0.}, {
                    15.462534690101757`, 5.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{174.70463045333267`, 
                    185.55996556236664`}, {-2.6737872995978904`, 
                    63.807647468726344`}}], StatusArea[#, 5]& , TagBoxNote -> 
                   "5"], 
                  StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                  Style[5, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{15.537465309898241`, 0.}, {
                    16.462534690101755`, 4.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{185.8987477061984, 
                    196.75408281523238`}, {10.522499654066955`, 
                    63.807647468726344`}}], StatusArea[#, 4]& , TagBoxNote -> 
                   "4"], 
                  StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                  Style[4, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{16.53746530989824, 0.}, {
                    17.462534690101755`, 3.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{197.09286495906414`, 
                    207.94820006809812`}, {23.7187866077318, 
                    63.807647468726344`}}], StatusArea[#, 3]& , TagBoxNote -> 
                   "3"], 
                  StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                  Style[3, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{17.53746530989824, 0.}, {
                    18.462534690101755`, 2.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{208.28698221192988`, 
                    219.14231732096385`}, {36.915073561396646`, 
                    63.807647468726344`}}], StatusArea[#, 2]& , TagBoxNote -> 
                   "2"], 
                  StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                  Style[2, {}], "Tooltip"]& ]}}, {{
                RGBColor[0.982864, 0.7431472, 0.3262672], 
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{18.53746530989824, 0.}, {
                    19.462534690101755`, 1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{219.48109946479562`, 
                    230.3364345738296}, {50.1113605150615, 
                    63.807647468726344`}}], StatusArea[#, 1]& , TagBoxNote -> 
                   "1"], 
                  StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                  Style[1, {}], "Tooltip"]& ]}}}}, {}, {}}, {}, {}, 
           StyleBox[{{{
               Thickness[Tiny], 
               LineBox[{{0.1589639222941721, 0.}, {19.848606105457904`, 0.}}], 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}}, 
             StyleBox[{{{
                 Thickness[Tiny], 
                 LineBox[{{0.5374653098982424, 0.}, 
                   
                   Offset[{-1.102182119232618*^-15, -6.}, {0.5374653098982424,
                     0.}]}], 
                 LineBox[{{19.46253469010175, 0.}, 
                   
                   Offset[{-1.102182119232618*^-15, -6.}, {19.46253469010175, 
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}}}, 
               StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
              "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
            StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, AxesOrigin -> {0.1589639222941721, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              15.999999999999998`, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              15.999999999999998`, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"096be9c3-cb06-4080-b55e-6c97457107c0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of a pie chart, bar chart and line plot of the numbers from 1 \
to 10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2365d96a-10e3-413e-b17e-6dd91525c381"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{DynamicChart`click$17908$18063 = False, 
            DynamicChart`click$17916$18063 = False, 
            DynamicChart`click$17919$18063 = False, 
            DynamicChart`click$17922$18063 = False, 
            DynamicChart`click$17925$18063 = False, 
            DynamicChart`click$17928$18063 = False, 
            DynamicChart`click$17931$18063 = False, 
            DynamicChart`click$17934$18063 = False, 
            DynamicChart`click$17937$18063 = False, 
            DynamicChart`click$17940$18063 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, {
                 {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0273529207319823`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-15.357388911865026`, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17908$18063, 
                    FEPrivate`Not[DynamicChart`click$17908$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17908$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19967382078522714`, 
                    0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$17908$18063}]]}, 
                 {RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.798873455016361, 
                    3.0273529207319823`}]},
                    
                    ImageSizeCache->{{23.21153984416608, 
                    121.4142135623731}, {-36.67495531105442, \
-1.5857864376269042`}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17916$18063, 
                    FEPrivate`Not[DynamicChart`click$17916$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[
                    DynamicChart`click$17916$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17916$18063}]]}, 
                 {RGBColor[0.998096, 0.5661274666666667, 0.2140296888888889], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.4561542564429293`, 
                    2.798873455016361}]},
                    
                    ImageSizeCache->{{28.168727528232534`, 
                    121.41421356237309`}, {-65.18340912802465, \
-1.5857864376269042`}}],
                    StatusArea[#, 3]& ,
                    TagBoxNote->"3"],
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17919$18063, 
                    FEPrivate`Not[DynamicChart`click$17919$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17919$18063, {{{1., 0}, {
                    0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17919$18063}]]}, 
                 {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.9991953250116865`, 
                    2.4561542564429293`}]},
                    
                    ImageSizeCache->{{44.26819181627499, 
                    121.41421356237309`}, {-91.73888511640686, \
-1.5857864376269104`}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17922$18063, 
                    FEPrivate`Not[DynamicChart`click$17922$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17922$18063, {{{1., 0}, {
                    0, 1.}}, {-0.12212957592708765`, 
                    0.15838044918445504`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$17922$18063}]]}, 
                 {RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.4279966607226333`, 
                    1.9991953250116865`}]},
                    
                    ImageSizeCache->{{78.7059451894458, 
                    135.07643803660847`}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17925$18063, 
                    FEPrivate`Not[DynamicChart`click$17925$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17925$18063, {{{1., 0}, {
                    0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17925$18063}]]}, 
                 {RGBColor[
                  0.7598801777777778, 0.4773333333333333, 0.3161064888888889],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.7425582635757695, 
                    1.4279966607226333`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    192.14136279850794`}, {-99.43707198294264, \
-1.5857864376268935`}}],
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17928$18063, 
                    FEPrivate`Not[DynamicChart`click$17928$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17928$18063, {{{1., 0}, {0, 1.}}, {
                    0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17928$18063}]]}, 
                 {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.05711986642890521, 
                    0.7425582635757695}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-69.327003988679, 3.89473940519882}}],
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17931$18063, 
                    FEPrivate`Not[DynamicChart`click$17931$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17931$18063, {{{1., 0}, {0, 1.}}, {
                    0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17931$18063}]]}, 
                 {RGBColor[
                  0.6558762666666667, 0.4926222222222222, 0.7345293333333333],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.9710377292913908, -0.05711986642890521}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.25764753928212`}, {-4.4142135623731065`, 
                    77.65951567079941}}],
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17934$18063, 
                    FEPrivate`Not[DynamicChart`click$17934$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17934$18063, {{{1., 0}, {0, 1.}}, {
                    0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17934$18063}]]}, 
                 {RGBColor[
                  0.5775381333333334, 0.5239111111111111, 0.7827298666666667],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.9991953250116863`, -0.9710377292913908}]},
                    
                    ImageSizeCache->{{78.70594518944583, 
                    175.60076257358293`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17937$18063, 
                    FEPrivate`Not[DynamicChart`click$17937$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17937$18063, {{{1., 0}, {0, 1.}}, {
                    0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17937$18063}]]}, 
                 {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0],
                   Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.9991953250116863`}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    85.73888511640688}}],
                    StatusArea[#, 10]& ,
                    TagBoxNote->"10"],
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17940$18063, 
                    FEPrivate`Not[DynamicChart`click$17940$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$17940$18063, {{{1., 0}, {
                    0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$17940$18063}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17908$18063, 
                    FEPrivate`Not[DynamicChart`click$17908$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17908$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19967382078522714`, 
                    0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$17908$18063}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17916$18063, 
                    FEPrivate`Not[DynamicChart`click$17916$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17916$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$17916$18063}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 3]& ,
                    TagBoxNote->"3"],
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17919$18063, 
                    FEPrivate`Not[DynamicChart`click$17919$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17919$18063, {{{1., 0}, {
                    0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$17919$18063}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17922$18063, 
                    FEPrivate`Not[DynamicChart`click$17922$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17922$18063, {{{1., 0}, {
                    0, 1.}}, {-0.12212957592708765`, 
                    0.15838044918445504`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$17922$18063}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17925$18063, 
                    FEPrivate`Not[DynamicChart`click$17925$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17925$18063, {{{1., 0}, {
                    0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$17925$18063}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 6]& ,
                    TagBoxNote->"6"],
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17928$18063, 
                    FEPrivate`Not[DynamicChart`click$17928$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17928$18063, {{{1., 0}, {0, 1.}}, {
                    0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$17928$18063}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 7]& ,
                    TagBoxNote->"7"],
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17931$18063, 
                    FEPrivate`Not[DynamicChart`click$17931$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17931$18063, {{{1., 0}, {0, 1.}}, {
                    0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$17931$18063}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17934$18063, 
                    FEPrivate`Not[DynamicChart`click$17934$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17934$18063, {{{1., 0}, {0, 1.}}, {
                    0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$17934$18063}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 9]& ,
                    TagBoxNote->"9"],
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17937$18063, 
                    FEPrivate`Not[DynamicChart`click$17937$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17937$18063, {{{1., 0}, {0, 1.}}, {
                    0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$17937$18063}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 10]& ,
                    TagBoxNote->"10"],
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17940$18063, 
                    FEPrivate`Not[DynamicChart`click$17940$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$17940$18063, {{{1., 0}, {
                    0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$17940$18063}]]}, {}}, {}}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
          PlotRangePadding->Scaled[0.02]], ",", 
         GraphicsBox[{
           {Opacity[0], PointBox[{0.3429357798165137, 0.}]}, {{}, 
            {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
             0.63], Thickness[Small]}], 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5412844036697247, 0.}, {
                    1.4587155963302751`, 1.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{17.986988913212343`, 38.08453245258489}, {
                   50.111360515061456`, 63.8076474687263}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275,
                     2.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{39.34831137112841, 59.445854910500955`}, {
                   36.91507356139661, 63.8076474687263}}],
                 StatusArea[#, 2]& ,
                 TagBoxNote->"2"],
                StyleBox["2", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[2, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`,
                     3.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{60.709633829044485`, 80.80717736841704}, {
                   23.718786607731772`, 63.8076474687263}}],
                 StatusArea[#, 3]& ,
                 TagBoxNote->"3"],
                StyleBox["3", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[3, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276,
                     4.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{82.07095628696058, 102.16849982633312`}, {
                   10.522499654066927`, 63.8076474687263}}],
                 StatusArea[#, 4]& ,
                 TagBoxNote->"4"],
                StyleBox["4", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                    5.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{103.43227874487664`, 
                   123.52982228424918`}, {-2.673787299597919, 
                   63.8076474687263}}],
                 StatusArea[#, 5]& ,
                 TagBoxNote->"5"],
                StyleBox["5", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[5, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                    6.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{124.79360120279271`, 
                   144.89114474216524`}, {-15.870074253262757`, 
                   63.8076474687263}}],
                 StatusArea[#, 6]& ,
                 TagBoxNote->"6"],
                StyleBox["6", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[6, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                    7.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{146.15492366070876`, 
                   166.2524672000813}, {-29.06636120692761, 
                   63.8076474687263}}],
                 StatusArea[#, 7]& ,
                 TagBoxNote->"7"],
                StyleBox["7", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[7, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                    8.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{167.51624611862485`, 
                   187.6137896579974}, {-42.26264816059245, 
                   63.8076474687263}}],
                 StatusArea[#, 8]& ,
                 TagBoxNote->"8"],
                StyleBox["8", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[8, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                    9.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{188.8775685765409, 
                   208.97511211591345`}, {-55.45893511425729, 
                   63.8076474687263}}],
                 StatusArea[#, 9]& ,
                 TagBoxNote->"9"],
                StyleBox["9", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[9, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`,
                     10.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{210.23889103445697`, 
                   230.33643457382954`}, {-68.65522206792214, 
                   63.8076474687263}}],
                 StatusArea[#, 10]& ,
                 TagBoxNote->"10"],
                StyleBox["10", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[10, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
              StyleBox[{}, "GraphicsLabel",
               StripOnInput->False]}, 
             StyleBox[{
               {Thickness[Tiny], 
                LineBox[{{0.5412844036697247, 0.}, 
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                   0.}]}], 
                LineBox[{{10.458715596330276`, 0.}, 
                  Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`,
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
               StyleBox[{}, "GraphicsLabel",
                StripOnInput->False]}, "GraphicsTicks",
              StripOnInput->False]}, "GraphicsAxes",
            StripOnInput->False,
            Antialiasing->False]},
          AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
          Axes->{False, True},
          AxesLabel->{None, None},
          AxesOrigin->{0.3429357798165137, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          PlotRange->{{All, All}, {All, All}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}},
          Ticks->{None, Automatic}], ",", 
         GraphicsBox[{{}, {{}, {}, 
            {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
             0.019444444444444445`], AbsoluteThickness[1.6], 
             LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 
              6.}, {7., 7.}, {8., 8.}, {9., 9.}, {10., 10.}}]}}, {}},
          AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0, 0},
          DisplayFunction->Identity,
          Frame->{{False, False}, {False, False}},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          Method->{},
          PlotRange->{{0., 10.}, {0, 10.}},
          PlotRangeClipping->True,
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"b205e54f-292d-444a-aea4-04f756f051d3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$17908$18063 = False, 
                 DynamicChart`click$17916$18063 = False, 
                 DynamicChart`click$17919$18063 = False, 
                 DynamicChart`click$17922$18063 = False, 
                 DynamicChart`click$17925$18063 = False, 
                 DynamicChart`click$17928$18063 = False, 
                 DynamicChart`click$17931$18063 = False, 
                 DynamicChart`click$17934$18063 = False, 
                 DynamicChart`click$17937$18063 = False, 
                 DynamicChart`click$17940$18063 = False}, {{{
                   RGBColor[0.5, 0.5, 1.], 
                   EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0273529207319823`, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-15.357388911865026`, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17908$18063, 
                    FEPrivate`Not[DynamicChart`click$17908$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17908$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19967382078522714`, 
                    0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$17908$18063}]]}}, {{
                    RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.798873455016361, 
                    3.0273529207319823`}]}, 
                    ImageSizeCache -> {{23.21153984416608, 
                    121.4142135623731}, {-36.67495531105442, \
-1.5857864376269042`}}], StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17916$18063, 
                    FEPrivate`Not[DynamicChart`click$17916$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17916$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17916$18063}]]}}, {{
                    
                    RGBColor[
                    0.998096, 0.5661274666666667, 0.2140296888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.4561542564429293`, 
                    2.798873455016361}]}, 
                    ImageSizeCache -> {{28.168727528232534`, 
                    121.41421356237309`}, {-65.18340912802465, \
-1.5857864376269042`}}], StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17919$18063, 
                    FEPrivate`Not[DynamicChart`click$17919$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17919$18063, {{{1., 0}, {
                    0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17919$18063}]]}}, {{
                    
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.9991953250116865`, 
                    2.4561542564429293`}]}, 
                    ImageSizeCache -> {{44.26819181627499, 
                    121.41421356237309`}, {-91.73888511640686, \
-1.5857864376269104`}}], StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17922$18063, 
                    FEPrivate`Not[DynamicChart`click$17922$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17922$18063, {{{1., 0}, {
                    0, 1.}}, {-0.12212957592708765`, 
                    0.15838044918445504`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$17922$18063}]]}}, {{
                    RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.4279966607226333`, 
                    1.9991953250116865`}]}, 
                    ImageSizeCache -> {{78.7059451894458, 
                    135.07643803660847`}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17925$18063, 
                    FEPrivate`Not[DynamicChart`click$17925$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17925$18063, {{{1., 0}, {
                    0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17925$18063}]]}}, {{
                    
                    RGBColor[
                    0.7598801777777778, 0.4773333333333333, 
                    0.3161064888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.7425582635757695, 
                    1.4279966607226333`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    
                    192.14136279850794`}, {-99.43707198294264, \
-1.5857864376268935`}}], StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17928$18063, 
                    FEPrivate`Not[DynamicChart`click$17928$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17928$18063, {{{1., 0}, {0, 1.}}, {
                    0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17928$18063}]]}}, {{
                    
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.05711986642890521, 
                    0.7425582635757695}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-69.327003988679, 
                    3.89473940519882}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17931$18063, 
                    FEPrivate`Not[DynamicChart`click$17931$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17931$18063, {{{1., 0}, {0, 1.}}, {
                    0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17931$18063}]]}}, {{
                    
                    RGBColor[
                    0.6558762666666667, 0.4926222222222222, 
                    0.7345293333333333], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.9710377292913908, -0.05711986642890521}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.25764753928212`}, {-4.4142135623731065`, 
                    77.65951567079941}}], StatusArea[#, 8]& , TagBoxNote -> 
                    "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17934$18063, 
                    FEPrivate`Not[DynamicChart`click$17934$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17934$18063, {{{1., 0}, {0, 1.}}, {
                    0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17934$18063}]]}}, {{
                    
                    RGBColor[
                    0.5775381333333334, 0.5239111111111111, 
                    0.7827298666666667], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.9991953250116863`, -0.9710377292913908}]}, 
                    ImageSizeCache -> {{78.70594518944583, 
                    175.60076257358293`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 9]& , TagBoxNote -> 
                    "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17937$18063, 
                    FEPrivate`Not[DynamicChart`click$17937$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17937$18063, {{{1., 0}, {0, 1.}}, {
                    0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17937$18063}]]}}, {{
                    
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.9991953250116863`}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    85.73888511640688}}], StatusArea[#, 10]& , TagBoxNote -> 
                    "10"], 
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17940$18063, 
                    FEPrivate`Not[DynamicChart`click$17940$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17940$18063, {{{1., 0}, {
                    0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$17940$18063}]]}}}}, {}}, {}}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17908$18063, 
                    FEPrivate`Not[DynamicChart`click$17908$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17908$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19967382078522714`, 
                    0.011417762172553685`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$17908$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17916$18063, 
                    FEPrivate`Not[DynamicChart`click$17916$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17916$18063, {{{1., 0}, {
                    0, 1.}}, {-0.19480238338846667`, 0.04529935348515298}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17916$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17919$18063, 
                    FEPrivate`Not[DynamicChart`click$17919$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17919$18063, {{{1., 0}, {
                    0, 1.}}, {-0.17414921542395542`, 0.09834658492912082}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17919$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17922$18063, 
                    FEPrivate`Not[DynamicChart`click$17922$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17922$18063, {{{1., 0}, {
                    0, 1.}}, {-0.12212957592708765`, 
                    0.15838044918445504`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$17922$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17925$18063, 
                    FEPrivate`Not[DynamicChart`click$17925$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17925$18063, {{{1., 0}, {
                    0, 1.}}, {-0.028462967654657, 0.19796428837618657`}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17925$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 6]& , TagBoxNote -> "6"], 
                    StyleBox["6", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[6, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17928$18063, 
                    FEPrivate`Not[DynamicChart`click$17928$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17928$18063, {{{1., 0}, {0, 1.}}, {
                    0.09333346464513473, 0.17688658619956288`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17928$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 7]& , TagBoxNote -> "7"], 
                    StyleBox["7", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[7, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17931$18063, 
                    FEPrivate`Not[DynamicChart`click$17931$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17931$18063, {{{1., 0}, {0, 1.}}, {
                    0.18836887272790492`, 0.06720987864308606}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17931$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 8]& , TagBoxNote -> "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17934$18063, 
                    FEPrivate`Not[DynamicChart`click$17934$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17934$18063, {{{1., 0}, {0, 1.}}, {
                    0.17414921542395545`, -0.09834658492912075}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17934$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 9]& , TagBoxNote -> "9"], 
                    StyleBox["9", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[9, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17937$18063, 
                    FEPrivate`Not[DynamicChart`click$17937$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17937$18063, {{{1., 0}, {0, 1.}}, {
                    0.01711500169576797, -0.19926634617253827`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$17937$18063}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 10]& , TagBoxNote -> "10"], 
                    StyleBox["10", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[10, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$17940$18063, 
                    FEPrivate`Not[DynamicChart`click$17940$18063]], 
                    PassEventsDown -> True, PassEventsDown -> Automatic, 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$17940$18063, {{{1., 0}, {
                    0, 1.}}, {-0.16825070656623622`, -0.10812816349111956`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$17940$18063}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]], ",", 
             GraphicsBox[{{{
                 Opacity[0], 
                 PointBox[{0.3429357798165137, 0.}]}}, {{}, {{
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.5412844036697247, 0.}, {
                    1.4587155963302751`, 1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{17.986988913212343`, 
                    38.08453245258489}, {50.111360515061456`, 
                    63.8076474687263}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                    Style[1, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{1.5412844036697246`, 0.}, {
                    2.458715596330275, 2.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{39.34831137112841, 
                    59.445854910500955`}, {36.91507356139661, 
                    63.8076474687263}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                    StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                    Style[2, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.541284403669725, 0.}, {
                    3.4587155963302756`, 3.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{60.709633829044485`, 
                    80.80717736841704}, {23.718786607731772`, 
                    63.8076474687263}}], StatusArea[#, 3]& , TagBoxNote -> 
                    "3"], 
                    StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                    Style[3, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.5412844036697253`, 0.}, {
                    4.458715596330276, 4.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{82.07095628696058, 
                    102.16849982633312`}, {10.522499654066927`, 
                    63.8076474687263}}], StatusArea[#, 4]& , TagBoxNote -> 
                    "4"], 
                    StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                    Style[4, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                    5.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{103.43227874487664`, 
                    123.52982228424918`}, {-2.673787299597919, 
                    63.8076474687263}}], StatusArea[#, 5]& , TagBoxNote -> 
                    "5"], 
                    StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                    Style[5, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                    6.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{124.79360120279271`, 
                    144.89114474216524`}, {-15.870074253262757`, 
                    63.8076474687263}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                    StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                    Style[6, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                    7.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{146.15492366070876`, 
                    166.2524672000813}, {-29.06636120692761, 
                    63.8076474687263}}], StatusArea[#, 7]& , TagBoxNote -> 
                    "7"], 
                    StyleBox["7", {}, StripOnInput -> False]], Annotation[#, 
                    Style[7, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                    8.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{167.51624611862485`, 
                    187.6137896579974}, {-42.26264816059245, 
                    63.8076474687263}}], StatusArea[#, 8]& , TagBoxNote -> 
                    "8"], 
                    StyleBox["8", {}, StripOnInput -> False]], Annotation[#, 
                    Style[8, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                    9.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{188.8775685765409, 
                    208.97511211591345`}, {-55.45893511425729, 
                    63.8076474687263}}], StatusArea[#, 9]& , TagBoxNote -> 
                    "9"], 
                    StyleBox["9", {}, StripOnInput -> False]], Annotation[#, 
                    Style[9, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.541284403669724, 0.}, {
                    10.458715596330276`, 10.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{210.23889103445697`, 
                    230.33643457382954`}, {-68.65522206792214, 
                    63.8076474687263}}], StatusArea[#, 10]& , TagBoxNote -> 
                    "10"], 
                    StyleBox["10", {}, StripOnInput -> False]], 
                    Annotation[#, 
                    Style[10, {}], "Tooltip"]& ]}}}}, {}, {}}, {}, {}, 
               StyleBox[{{{
                   Thickness[Tiny], 
                   
                   LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 
                    0.}}], 
                   StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}}, 
                 StyleBox[{{{
                    Thickness[Tiny], 
                    LineBox[{{0.5412844036697247, 0.}, 
                    
                    Offset[{-1.102182119232618*^-15, -6.}, {
                    0.5412844036697247, 0.}]}], 
                    LineBox[{{10.458715596330276`, 0.}, 
                    
                    Offset[{-1.102182119232618*^-15, -6.}, {
                    10.458715596330276`, 
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}}}, 
                   StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
                  "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
                StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {False, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0.3429357798165137, 0.}, 
              CoordinatesToolOptions :> {"DisplayFunction" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& )}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {{{1., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {None, Automatic}], ",", 
             GraphicsBox[{{}, {{}, {}, {{
                  RGBColor[0.368417, 0.506779, 0.709798], 
                  PointSize[0.019444444444444445`], 
                  AbsoluteThickness[1.6], 
                  
                  LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {
                   6., 6.}, {7., 7.}, {8., 8.}, {9., 9.}, {10., 
                   10.}}]}}}, {}}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {True, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
              Frame -> {{False, False}, {False, False}}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], Method -> {}, 
              PlotRange -> {{0., 10.}, {0, 10.}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6eb98aa4-43ba-4add-a394-c750028fb22b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of a pie chart and a bar chart of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
    "21", ",", "34", ",", "55"}], "}"}]], "InlineCode",ExpressionUUID->
  "14390fae-af5b-48a5-8391-139630ffe80e"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"55598569-532f-4f84-a35e-758a7ca5bfb8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{DynamicChart`click$73778$73909 = False, 
            DynamicChart`click$73787$73909 = False, 
            DynamicChart`click$73790$73909 = False, 
            DynamicChart`click$73793$73909 = False, 
            DynamicChart`click$73796$73909 = False, 
            DynamicChart`click$73799$73909 = False, 
            DynamicChart`click$73802$73909 = False, 
            DynamicChart`click$73805$73909 = False, 
            DynamicChart`click$73808$73909 = False, 
            DynamicChart`click$73811$73909 = False}, {
             {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
              0.5]}], {{{}, {
                 {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0976542947983274`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-8.630938913532344, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73778$73909, 
                    FEPrivate`Not[DynamicChart`click$73778$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73778$73909, {{{1., 0}, {
                    0, 1.}}, {-0.19995173745685363`, 
                    0.004393482443970972}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$73778$73909}]]}, 
                 {RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0537159360068618`, 
                    3.0976542947983274`}]},
                    
                    ImageSizeCache->{{22.67843933995722, 
                    121.41421356237309`}, {-12.839524851314192`, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73787$73909, 
                    FEPrivate`Not[DynamicChart`click$73787$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[
                    DynamicChart`click$73787$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1995657768568252, 0.0131719667298343}}, {{1, 
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73787$73909}]]}, 
                 {RGBColor[0.998096, 0.5661274666666667, 0.2140296888888889], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.9658392184239304`, 
                    3.0537159360068618`}]},
                    
                    ImageSizeCache->{{22.956219201941675`, 
                    121.4142135623731}, {-21.199815070443297`, \
-1.5857864376269042`}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73790$73909, 
                    FEPrivate`Not[DynamicChart`click$73790$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73790$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1982649929246814, 0.026286737731716348`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73790$73909}]]}, 
                 {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{
                  GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.834024142049534, 
                    2.9658392184239304`}]},
                    
                    ImageSizeCache->{{24.06465873586769, 
                    121.41421356237309`}, {-33.47745985355442, \
-1.5857864376269042`}}],
                    StatusArea[#, 3]& ,
                    TagBoxNote->"3"],
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73793$73909, 
                    FEPrivate`Not[DynamicChart`click$73793$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73793$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1941883634852104, 0.04786313285751154}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73793$73909}]]}, 
                 {RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.6143323480922054`, 
                    2.834024142049534}]},
                    
                    ImageSizeCache->{{27.09082638507463, 
                    121.41421356237309`}, {-52.71830499861349, \
-1.5857864376269042`}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73796$73909, 
                    FEPrivate`Not[DynamicChart`click$73796$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73796$73909, {{{1., 0}, {
                    0, 1.}}, {-0.18282803779278334`, 0.08107964354164736}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73796$73909}]]}, 
                 {RGBColor[
                  0.7598801777777778, 0.4773333333333333, 0.3161064888888889],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.2628254777604804`, 
                    2.6143323480922054`}]},
                    
                    ImageSizeCache->{{35.62365802640949, 
                    121.41421356237309`}, {-78.32968217625121, \
-1.5857864376269104`}}],
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73799$73909, 
                    FEPrivate`Not[DynamicChart`click$73799$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73799$73909, {{{1., 0}, {
                    0, 1.}}, {-0.15257944235912138`, 
                    0.12930395883104104`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$73799$73909}]]}, 
                 {RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                  EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.691626813471427, 
                    2.2628254777604804`}]},
                    
                    ImageSizeCache->{{57.32810528994715, 
                    121.4142135623731}, {-99.71426547578628, \
-1.5857864376269104`}}],
                    StatusArea[#, 13]& ,
                    TagBoxNote->"13"],
                    StyleBox["13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73802$73909, 
                    FEPrivate`Not[DynamicChart`click$73802$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73802$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07906650141332427, 0.1837076164840663}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73802$73909}]]}, 
                 {RGBColor[
                  0.6558762666666667, 0.4926222222222222, 0.7345293333333333],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.768921278850649, 
                    1.691626813471427}]},
                    
                    ImageSizeCache->{{107.0142651331159, 
                    190.40568756962324`}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 21]& ,
                    TagBoxNote->"21"],
                    StyleBox["21", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[21, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73805$73909, 
                    FEPrivate`Not[DynamicChart`click$73805$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73805$73909, {{{1., 0}, {0, 1.}}, {
                    0.06679588582778027, 0.1885160726210955}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73805$73909}]]}, 
                 {RGBColor[
                  0.5775381333333334, 0.5239111111111111, 0.7827298666666667],
                   EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.7249829200591833, 
                    0.768921278850649}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-71.1688127620307, 
                    62.07398875348947}}],
                    StatusArea[#, 34]& ,
                    TagBoxNote->"34"],
                    StyleBox["34", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[34, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73808$73909, 
                    FEPrivate`Not[DynamicChart`click$73808$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73808$73909, {{{1., 0}, {0, 1.}}, {
                    0.19995173745685363`, 0.004393482443970947}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73808$73909}]]}, 
                 {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0],
                   Opacity[0.5]}], GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.7249829200591833}]},
                    
                    ImageSizeCache->{{22.585786437626894`, 
                    193.27124538679877`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 55]& ,
                    TagBoxNote->"55"],
                    StyleBox["55", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[55, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73811$73909, 
                    FEPrivate`Not[DynamicChart`click$73811$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$73811$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07092097740850714, -0.18700324853708297`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$73811$73909}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73778$73909, 
                    FEPrivate`Not[DynamicChart`click$73778$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73778$73909, {{{1., 0}, {
                    0, 1.}}, {-0.19995173745685363`, 
                    0.004393482443970972}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$73778$73909}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73787$73909, 
                    FEPrivate`Not[DynamicChart`click$73787$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73787$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1995657768568252, 0.0131719667298343}}, {{1, 
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$73787$73909}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73790$73909, 
                    FEPrivate`Not[DynamicChart`click$73790$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73790$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1982649929246814, 0.026286737731716348`}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$73790$73909}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 3]& ,
                    TagBoxNote->"3"],
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73793$73909, 
                    FEPrivate`Not[DynamicChart`click$73793$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73793$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1941883634852104, 0.04786313285751154}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$73793$73909}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73796$73909, 
                    FEPrivate`Not[DynamicChart`click$73796$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73796$73909, {{{1., 0}, {
                    0, 1.}}, {-0.18282803779278334`, 0.08107964354164736}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$73796$73909}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 8]& ,
                    TagBoxNote->"8"],
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73799$73909, 
                    FEPrivate`Not[DynamicChart`click$73799$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73799$73909, {{{1., 0}, {
                    0, 1.}}, {-0.15257944235912138`, 
                    0.12930395883104104`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$73799$73909}]],
                 GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 13]& ,
                    TagBoxNote->"13"],
                    StyleBox["13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73802$73909, 
                    FEPrivate`Not[DynamicChart`click$73802$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73802$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07906650141332427, 0.1837076164840663}}, {{1,
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$73802$73909}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 21]& ,
                    TagBoxNote->"21"],
                    StyleBox["21", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[21, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73805$73909, 
                    FEPrivate`Not[DynamicChart`click$73805$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73805$73909, {{{1., 0}, {0, 1.}}, {
                    0.06679588582778027, 0.1885160726210955}}, {{1, 0}, {0, 
                   1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$73805$73909}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 34]& ,
                    TagBoxNote->"34"],
                    StyleBox["34", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[34, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73808$73909, 
                    FEPrivate`Not[DynamicChart`click$73808$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73808$73909, {{{1., 0}, {0, 1.}}, {
                    0.19995173745685363`, 0.004393482443970947}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$73808$73909}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 55]& ,
                    TagBoxNote->"55"],
                    StyleBox["55", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[55, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73811$73909, 
                    FEPrivate`Not[DynamicChart`click$73811$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$73811$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07092097740850714, -0.18700324853708297`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$73811$73909}]]}, {}}, {}}},
            DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
          ContentSelectable->False,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          LabelStyle->{
            GrayLevel[0], FontFamily -> "Arial"},
          PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
          PlotRangePadding->Scaled[0.02]], ",", 
         GraphicsBox[{
           {Opacity[0], PointBox[{0.3429357798165137, 0.}]}, {{}, 
            {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
             0.63], Thickness[Small]}], 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5412844036697247, 0.}, {
                    1.4587155963302751`, 1.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{17.986988913212343`, 38.08453245258489}, {
                   60.90832256805998, 63.807647468726316`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275,
                     1.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{39.34831137112841, 59.445854910500955`}, {
                   60.90832256805998, 63.807647468726316`}}],
                 StatusArea[#, 1]& ,
                 TagBoxNote->"1"],
                StyleBox["1", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`,
                     2.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{60.709633829044485`, 80.80717736841704}, {
                   58.50899766739364, 63.807647468726316`}}],
                 StatusArea[#, 2]& ,
                 TagBoxNote->"2"],
                StyleBox["2", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[2, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276,
                     3.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{82.07095628696058, 102.16849982633312`}, {
                   56.10967276672731, 63.807647468726316`}}],
                 StatusArea[#, 3]& ,
                 TagBoxNote->"3"],
                StyleBox["3", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[3, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                    5.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{103.43227874487664`, 
                   123.52982228424918`}, {51.311022965394635`, 
                   63.807647468726316`}}],
                 StatusArea[#, 5]& ,
                 TagBoxNote->"5"],
                StyleBox["5", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[5, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                    8.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{124.79360120279271`, 
                   144.89114474216524`}, {44.11304826339563, 
                   63.807647468726316`}}],
                 StatusArea[#, 8]& ,
                 TagBoxNote->"8"],
                StyleBox["8", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[8, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                    13.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{146.15492366070876`, 166.2524672000813}, {
                   32.11642376006396, 63.807647468726316`}}],
                 StatusArea[#, 13]& ,
                 TagBoxNote->"13"],
                StyleBox["13", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[13, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                    21.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{167.51624611862485`, 187.6137896579974}, {
                   12.921824554733277`, 63.807647468726316`}}],
                 StatusArea[#, 21]& ,
                 TagBoxNote->"21"],
                StyleBox["21", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[21, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                    34.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{188.8775685765409, 
                   208.97511211591345`}, {-18.269399153929086`, 
                   63.807647468726316`}}],
                 StatusArea[#, 34]& ,
                 TagBoxNote->"34"],
                StyleBox["34", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[34, {}], "Tooltip"]& ]}, 
             {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
              0.63], Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`,
                     55.}, "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{210.23889103445697`, 
                   230.33643457382954`}, {-68.65522206792213, 
                   63.807647468726316`}}],
                 StatusArea[#, 55]& ,
                 TagBoxNote->"55"],
                StyleBox["55", {}, StripOnInput -> False]],
               Annotation[#, 
                Style[55, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
              StyleBox[{}, "GraphicsLabel",
               StripOnInput->False]}, 
             StyleBox[{
               {Thickness[Tiny], 
                LineBox[{{0.5412844036697247, 0.}, 
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                   0.}]}], 
                LineBox[{{10.458715596330276`, 0.}, 
                  Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`,
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, 
               StyleBox[{}, "GraphicsLabel",
                StripOnInput->False]}, "GraphicsTicks",
              StripOnInput->False]}, "GraphicsAxes",
            StripOnInput->False,
            Antialiasing->False]},
          AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
          Axes->{False, True},
          AxesLabel->{None, None},
          AxesOrigin->{0.3429357798165137, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          PlotRange->{{All, All}, {All, All}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"7ed5caa8-083c-42fd-ad5e-36d71201e0cd"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$73778$73909 = False, 
                 DynamicChart`click$73787$73909 = False, 
                 DynamicChart`click$73790$73909 = False, 
                 DynamicChart`click$73793$73909 = False, 
                 DynamicChart`click$73796$73909 = False, 
                 DynamicChart`click$73799$73909 = False, 
                 DynamicChart`click$73802$73909 = False, 
                 DynamicChart`click$73805$73909 = False, 
                 DynamicChart`click$73808$73909 = False, 
                 DynamicChart`click$73811$73909 = False}, {{{
                   RGBColor[0.5, 0.5, 1.], 
                   EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0976542947983274`, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-8.630938913532344, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73778$73909, 
                    FEPrivate`Not[DynamicChart`click$73778$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73778$73909, {{{1., 0}, {
                    0, 1.}}, {-0.19995173745685363`, 
                    0.004393482443970972}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$73778$73909}]]}}, {{
                    RGBColor[0.99048, 0.6546373333333334, 0.2701484444444444], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0537159360068618`, 
                    3.0976542947983274`}]}, 
                    ImageSizeCache -> {{22.67843933995722, 
                    121.41421356237309`}, {-12.839524851314192`, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73787$73909, 
                    FEPrivate`Not[DynamicChart`click$73787$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73787$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1995657768568252, 0.0131719667298343}}, {{1, 
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73787$73909}]]}}, {{
                    
                    RGBColor[
                    0.998096, 0.5661274666666667, 0.2140296888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.9658392184239304`, 
                    3.0537159360068618`}]}, 
                    ImageSizeCache -> {{22.956219201941675`, 
                    121.4142135623731}, {-21.199815070443297`, \
-1.5857864376269042`}}], StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73790$73909, 
                    FEPrivate`Not[DynamicChart`click$73790$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73790$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1982649929246814, 0.026286737731716348`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73790$73909}]]}}, {{
                    
                    RGBColor[0.928, 0.5210666666666667, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.834024142049534, 
                    2.9658392184239304`}]}, 
                    ImageSizeCache -> {{24.06465873586769, 
                    121.41421356237309`}, {-33.47745985355442, \
-1.5857864376269042`}}], StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73793$73909, 
                    FEPrivate`Not[DynamicChart`click$73793$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73793$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1941883634852104, 0.04786313285751154}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73793$73909}]]}}, {{
                    
                    RGBColor[0.8320000000000001, 0.49048888888888886`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.6143323480922054`, 
                    2.834024142049534}]}, 
                    ImageSizeCache -> {{27.09082638507463, 
                    121.41421356237309`}, {-52.71830499861349, \
-1.5857864376269042`}}], StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73796$73909, 
                    FEPrivate`Not[DynamicChart`click$73796$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73796$73909, {{{1., 0}, {
                    0, 1.}}, {-0.18282803779278334`, 0.08107964354164736}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73796$73909}]]}}, {{
                    
                    RGBColor[
                    0.7598801777777778, 0.4773333333333333, 
                    0.3161064888888889], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.2628254777604804`, 
                    2.6143323480922054`}]}, 
                    ImageSizeCache -> {{35.62365802640949, 
                    121.41421356237309`}, {-78.32968217625121, \
-1.5857864376269104`}}], StatusArea[#, 8]& , TagBoxNote -> "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73799$73909, 
                    FEPrivate`Not[DynamicChart`click$73799$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73799$73909, {{{1., 0}, {
                    0, 1.}}, {-0.15257944235912138`, 
                    0.12930395883104104`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$73799$73909}]]}}, {{
                    RGBColor[0.7116405333333333, 0.4816, 0.5483194666666666], 
                    
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.691626813471427, 
                    2.2628254777604804`}]}, 
                    ImageSizeCache -> {{57.32810528994715, 
                    121.4142135623731}, {-99.71426547578628, \
-1.5857864376269104`}}], StatusArea[#, 13]& , TagBoxNote -> "13"], 
                    StyleBox["13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73802$73909, 
                    FEPrivate`Not[DynamicChart`click$73802$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73802$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07906650141332427, 0.1837076164840663}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73802$73909}]]}}, {{
                    
                    RGBColor[
                    0.6558762666666667, 0.4926222222222222, 
                    0.7345293333333333], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.768921278850649, 
                    1.691626813471427}]}, 
                    ImageSizeCache -> {{107.0142651331159, 
                    190.40568756962324`}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 21]& , TagBoxNote -> "21"], 
                    StyleBox["21", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[21, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73805$73909, 
                    FEPrivate`Not[DynamicChart`click$73805$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73805$73909, {{{1., 0}, {0, 1.}}, {
                    0.06679588582778027, 0.1885160726210955}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73805$73909}]]}}, {{
                    
                    RGBColor[
                    0.5775381333333334, 0.5239111111111111, 
                    0.7827298666666667], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.7249829200591833, 
                    0.768921278850649}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-71.1688127620307, 
                    62.07398875348947}}], StatusArea[#, 34]& , TagBoxNote -> 
                    "34"], 
                    StyleBox["34", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[34, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73808$73909, 
                    FEPrivate`Not[DynamicChart`click$73808$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73808$73909, {{{1., 0}, {0, 1.}}, {
                    0.19995173745685363`, 0.004393482443970947}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73808$73909}]]}}, {{
                    
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.7249829200591833}]}, 
                    ImageSizeCache -> {{22.585786437626894`, 
                    193.27124538679877`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 55]& , TagBoxNote -> 
                    "55"], 
                    StyleBox["55", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[55, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73811$73909, 
                    FEPrivate`Not[DynamicChart`click$73811$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73811$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07092097740850714, -0.18700324853708297`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$73811$73909}]]}}}}, {}}, {}}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73778$73909, 
                    FEPrivate`Not[DynamicChart`click$73778$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73778$73909, {{{1., 0}, {
                    0, 1.}}, {-0.19995173745685363`, 
                    0.004393482443970972}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$73778$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73787$73909, 
                    FEPrivate`Not[DynamicChart`click$73787$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73787$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1995657768568252, 0.0131719667298343}}, {{1, 
                    0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73787$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73790$73909, 
                    FEPrivate`Not[DynamicChart`click$73790$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73790$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1982649929246814, 0.026286737731716348`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73790$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73793$73909, 
                    FEPrivate`Not[DynamicChart`click$73793$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73793$73909, {{{1., 0}, {
                    0, 1.}}, {-0.1941883634852104, 0.04786313285751154}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73793$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73796$73909, 
                    FEPrivate`Not[DynamicChart`click$73796$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73796$73909, {{{1., 0}, {
                    0, 1.}}, {-0.18282803779278334`, 0.08107964354164736}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73796$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 8]& , TagBoxNote -> "8"], 
                    StyleBox["8", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[8, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73799$73909, 
                    FEPrivate`Not[DynamicChart`click$73799$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73799$73909, {{{1., 0}, {
                    0, 1.}}, {-0.15257944235912138`, 
                    0.12930395883104104`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$73799$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 13]& , TagBoxNote -> "13"], 
                    StyleBox["13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73802$73909, 
                    FEPrivate`Not[DynamicChart`click$73802$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73802$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07906650141332427, 0.1837076164840663}}, {{1,
                     0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73802$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 21]& , TagBoxNote -> "21"], 
                    StyleBox["21", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[21, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73805$73909, 
                    FEPrivate`Not[DynamicChart`click$73805$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73805$73909, {{{1., 0}, {0, 1.}}, {
                    0.06679588582778027, 0.1885160726210955}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73805$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 34]& , TagBoxNote -> "34"], 
                    StyleBox["34", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[34, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73808$73909, 
                    FEPrivate`Not[DynamicChart`click$73808$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73808$73909, {{{1., 0}, {0, 1.}}, {
                    0.19995173745685363`, 0.004393482443970947}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$73808$73909}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 55]& , TagBoxNote -> "55"], 
                    StyleBox["55", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[55, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$73811$73909, 
                    FEPrivate`Not[DynamicChart`click$73811$73909]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$73811$73909, {{{1., 0}, {
                    0, 1.}}, {-0.07092097740850714, -0.18700324853708297`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$73811$73909}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]], ",", 
             GraphicsBox[{{{
                 Opacity[0], 
                 PointBox[{0.3429357798165137, 0.}]}}, {{}, {{
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.5412844036697247, 0.}, {
                    1.4587155963302751`, 1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{17.986988913212343`, 
                    38.08453245258488}, {61.011519337981134`, 
                    63.91084423864747}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                    Style[1, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.5412844036697246`, 0.}, {
                    2.458715596330275, 1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{39.34831137112841, 
                    59.44585491050095}, {61.011519337981134`, 
                    63.91084423864747}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                    Style[1, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.541284403669725, 0.}, {
                    3.4587155963302756`, 2.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{60.70963382904448, 
                    80.80717736841703}, {58.6121944373148, 
                    63.91084423864747}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                    StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                    Style[2, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.5412844036697253`, 0.}, {
                    4.458715596330276, 3.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{82.07095628696057, 
                    102.1684998263331}, {56.21286953664846, 
                    63.91084423864747}}], StatusArea[#, 3]& , TagBoxNote -> 
                    "3"], 
                    StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                    Style[3, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                    5.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{103.43227874487663`, 
                    123.52982228424916`}, {51.4142197353158, 
                    63.91084423864747}}], StatusArea[#, 5]& , TagBoxNote -> 
                    "5"], 
                    StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                    Style[5, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                    8.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{124.7936012027927, 
                    144.8911447421652}, {44.21624503331679, 
                    63.91084423864747}}], StatusArea[#, 8]& , TagBoxNote -> 
                    "8"], 
                    StyleBox["8", {}, StripOnInput -> False]], Annotation[#, 
                    Style[8, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                    13.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{146.15492366070876`, 
                    166.2524672000813}, {32.21962052998511, 
                    63.91084423864747}}], StatusArea[#, 13]& , TagBoxNote -> 
                    "13"], 
                    StyleBox["13", {}, StripOnInput -> False]], 
                    Annotation[#, 
                    Style[13, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                    21.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{167.51624611862482`, 
                    187.61378965799736`}, {13.025021324654432`, 
                    63.91084423864747}}], StatusArea[#, 21]& , TagBoxNote -> 
                    "21"], 
                    StyleBox["21", {}, StripOnInput -> False]], 
                    Annotation[#, 
                    Style[21, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                    34.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{188.87756857654085`, 
                    208.97511211591342`}, {-18.16620238400793, 
                    63.91084423864747}}], StatusArea[#, 34]& , TagBoxNote -> 
                    "34"], 
                    StyleBox["34", {}, StripOnInput -> False]], 
                    Annotation[#, 
                    Style[34, {}], "Tooltip"]& ]}}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    Opacity[0.63], 
                    Thickness[Small]}], 
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.541284403669724, 0.}, {
                    10.458715596330276`, 55.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{210.23889103445694`, 
                    230.33643457382948`}, {-68.55202529800097, 
                    63.91084423864747}}], StatusArea[#, 55]& , TagBoxNote -> 
                    "55"], 
                    StyleBox["55", {}, StripOnInput -> False]], 
                    Annotation[#, 
                    Style[55, {}], "Tooltip"]& ]}}}}, {}, {}}, {}, {}, 
               StyleBox[{{{
                   Thickness[Tiny], 
                   
                   LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 
                    0.}}], 
                   StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}}, 
                 StyleBox[{{{
                    Thickness[Tiny], 
                    LineBox[{{0.5412844036697247, 0.}, 
                    
                    Offset[{-1.102182119232618*^-15, -6.}, {
                    0.5412844036697247, 0.}]}], 
                    LineBox[{{10.458715596330276`, 0.}, 
                    
                    Offset[{-1.102182119232618*^-15, -6.}, {
                    10.458715596330276`, 
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}}}, 
                   StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
                  "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
                StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {False, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0.3429357798165137, 0.}, 
              CoordinatesToolOptions :> {"DisplayFunction" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& )}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {{{1., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {None, Automatic}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b37964b3-600c-4bc2-8b13-205e9f6d7b26"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a column of two number line plots of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], 
  "InlineCode",ExpressionUUID->"1a75c453-ec0f-47a1-91c3-8fb5de03b0f7"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"fbd83359-d2a6-4973-a47d-045a4763325d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           GraphicsBox[{
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{1, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{2, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{3, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{4, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{5, 1}]}},
            
            AspectRatio->NCache[
             Rational[1, 10]/GoldenRatio, 0.06180339887498948],
            Axes->{True, False},
            AxesLabel->{None},
            AxesOrigin->{Automatic, Automatic},
            FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
            ImagePadding->All,
            PlotRange->{{1., 5.}, {0, 1}},
            PlotRangePadding->{{
               Scaled[0.1], 
               Scaled[0.1]}, {0, 1}},
            Ticks->{Automatic, Automatic}]},
          {
           GraphicsBox[{
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{1, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{2, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{3, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{4, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{5, 1}]}},
            
            AspectRatio->NCache[
             Rational[1, 10]/GoldenRatio, 0.06180339887498948],
            Axes->{True, False},
            AxesLabel->{None},
            AxesOrigin->{Automatic, Automatic},
            FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
            ImagePadding->All,
            PlotRange->{{1., 5.}, {0, 1}},
            PlotRangePadding->{{
               Scaled[0.1], 
               Scaled[0.1]}, {0, 1}},
            Ticks->{Automatic, Automatic}]}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "e341e3d0-5e50-442f-bd34-a227a12196c6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             GraphicsBox[{{{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{1, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{2, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{3, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{4, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{5, 1}]}}}, AspectRatio -> 
              NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
              Axes -> {True, False}, AxesLabel -> {None}, 
              AxesOrigin -> {Automatic, Automatic}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              ImagePadding -> All, PlotRange -> {{1., 5.}, {0, 1}}, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {0, 1}}, Ticks -> {Automatic, Automatic}]}, {
             GraphicsBox[{{{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{1, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{2, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{3, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{4, 1}]}}, {{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[Medium], 
                 AbsoluteThickness[1.6], 
                 PointBox[{5, 1}]}}}, AspectRatio -> 
              NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
              Axes -> {True, False}, AxesLabel -> {None}, 
              AxesOrigin -> {Automatic, Automatic}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              ImagePadding -> All, PlotRange -> {{1., 5.}, {0, 1}}, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {0, 1}}, Ticks -> {Automatic, Automatic}]}}, 
           DefaultBaseStyle -> "Column", 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"24258ba0-2b04-42a8-ab34-13bf8ec3bd2e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a number line of fractions 1/2, 1/3, ... through 1/9.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8e1ce00c-4368-4576-b832-ed79c5fcaf1f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 2], 1}, {0.5, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 3], 1}, {0.3333333333333333, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 4], 1}, {0.25, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 5], 1}, {0.2, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 6], 1}, {0.16666666666666666`, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 7], 1}, {0.14285714285714285`, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 8], 1}, {0.125, 1}]]}, 
         {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
          AbsoluteThickness[1.6], 
          PointBox[NCache[{Rational[1, 9], 1}, {0.1111111111111111, 1}]]}},
        AspectRatio->NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948],
        
        Axes->{True, False},
        AxesLabel->{None},
        AxesOrigin->{Automatic, Automatic},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        ImagePadding->All,
        PlotRange->{{0.1111111111111111, 0.5}, {0, 1}},
        PlotRangePadding->{{
           Scaled[0.1], 
           Scaled[0.1]}, {0, 1}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "eaa926ef-c478-4b98-8c95-510876feb5c7"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 2], 1}, {0.5, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 3], 1}, {0.3333333333333333, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 4], 1}, {0.25, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 5], 1}, {0.2, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 6], 1}, {0.16666666666666666`, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 7], 1}, {0.14285714285714285`, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 8], 1}, {0.125, 1}]]}}, {{
             RGBColor[0.368417, 0.506779, 0.709798], 
             PointSize[Medium], 
             AbsoluteThickness[1.6], 
             PointBox[
              NCache[{
                Rational[1, 9], 1}, {0.1111111111111111, 1}]]}}}, AspectRatio -> 
          NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
          Axes -> {True, False}, AxesLabel -> {None}, 
          AxesOrigin -> {Automatic, Automatic}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          ImagePadding -> All, 
          PlotRange -> {{0.1111111111111111, 0.5}, {0, 1}}, 
          PlotRangePadding -> {{
             Scaled[0.1], 
             Scaled[0.1]}, {0, 1}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3a7ecb5b-bd69-4804-a4b4-dd23e99911c5"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"26175449-abbf-4ab3-bdc2-3711f7b57485"],

Cell["How do pie charts work in the Wolfram Language?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"32d2df52-4e4d-406d-90ea-7993f7a97a90"],

Cell["\<\
As in any pie chart, the wedges have relative sizes determined by the \
relative sizes of numbers in the list. In the Wolfram Language, the wedge for \
the first number starts at the 9 o\[CloseCurlyQuote]clock position, and then \
subsequent wedges read clockwise. The colors of the wedges are chosen in a \
definite sequence.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"97d72f3a-5882-4aa8-9da4-66a244d8a823"],

Cell["How is the vertical scale determined on plots?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"22eea1e8-566a-42da-9b9a-0f65fb2a1655"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s set up to automatically include all points except \
distant outliers. Later on (",
 ButtonBox["Section 20",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-20-options.nb", "PlotRange"}],
 "), we\[CloseCurlyQuote]ll talk about the ",
 ButtonBox["PlotRange",
  BaseStyle->"Link"],
 " option, which lets you specify the exact range of the plot."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"52b63b50-e142-4f14-8f8a-3ac0e79a22e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Note", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"720da4dd-bff3-424c-9088-7c7c1a703f34"],

Cell[TextData[{
 "Particularly if you\[CloseCurlyQuote]re familiar with other computer \
languages, you may be surprised that a list of plots, for example, can appear \
as the output of a computation. This is made possible by the crucial fact \
that the Wolfram Language is ",
 StyleBox["symbolic",
  FontSlant->"Italic"],
 ". By the way, plots can appear in input as well. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"85d3476a-7bb0-4cc6-b1a6-cd4d60d4da13"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"42c60e78-0a5c-4974-8a55-6b93552bc2cb"],

Cell[TextData[ButtonBox["Data Visualization in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b3f0d16e-5d35-42ed-b12a-94817f61de90"],

Cell[TextData[ButtonBox["Charting and Information Visualization in the \
Wolfram Language\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ChartingAndInformationVisualization"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"0fbde90b-55db-4100-9d99-635e0785a5aa"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Displaying Lists: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"First Look at Lists\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "First Look at Lists", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Operations on Lists\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Operations on Lists", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingCopies->1,
PrintingStartingPageNumber->11,
PrintingPageRange->{1, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Displaying Lists \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"865ead1e-7cf6-4013-8daf-74fb9feb440c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:11"->{
  Cell[661, 24, 478, 13, 93, "Section",ExpressionUUID->"89a2af2f-4d5d-4099-bd12-8828f9d605e4",
   CounterAssignments->{{"Section", 3}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:11", "i:1"}]},
 "i:1"->{
  Cell[661, 24, 478, 13, 93, "Section",ExpressionUUID->"89a2af2f-4d5d-4099-bd12-8828f9d605e4",
   CounterAssignments->{{"Section", 3}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:11", "i:1"}]},
 "i:2"->{
  Cell[1142, 39, 409, 13, 65, "Text",ExpressionUUID->"161e2b65-1c59-4a43-a7a1-94ac8f1249ee",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[1554, 54, 265, 10, 37, "CodeCaption",ExpressionUUID->"575539bb-fd1a-4faf-8fde-41ad82ec8ce6",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[4853, 163, 195, 4, 37, "CodeCaption",ExpressionUUID->"a9917087-0b0f-4aa9-87ee-8ae4ffb9f54a",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[17433, 514, 247, 7, 37, "CodeCaption",ExpressionUUID->"853d8d55-a68e-4e28-a077-ab7c0373acdf",
   CellTags->"i:5"]},
 "LastCellOfAPage"->{
  Cell[17933, 532, 10722, 246, 70, "Output",ExpressionUUID->"46f44eea-5c5d-46b9-a98b-3f22b9f27044",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[77765, 2031, 1634, 46, 70, "VocabularyTable",ExpressionUUID->"39036a04-8c08-4f42-84f2-d3c4a4883b00",
   CellTags->"LastCellOfAPage"],
  Cell[681688, 15637, 382, 9, 70, "MoreExplore",ExpressionUUID->"0fbde90b-55db-4100-9d99-635e0785a5aa",
   CellTags->"LastCellOfAPage"]},
 "p:12"->{
  Cell[28670, 781, 263, 8, 70, "CodeCaption",ExpressionUUID->"228b2284-66a3-4738-8f90-ffbd64527792",
   CellTags->{"p:12", "i:6"}]},
 "i:6"->{
  Cell[28670, 781, 263, 8, 70, "CodeCaption",ExpressionUUID->"228b2284-66a3-4738-8f90-ffbd64527792",
   CellTags->{"p:12", "i:6"}]},
 "i:7"->{
  Cell[30220, 827, 281, 7, 70, "CodeCaption",ExpressionUUID->"607ce741-8e85-4d3f-a4f8-c53beabb0d36",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[680643, 15605, 526, 12, 70, "TechNote",ExpressionUUID->"85d3476a-7bb0-4cc6-b1a6-cd4d60d4da13",
   CellTags->"i:8"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:11", 772800, 17487},
 {"i:1", 773053, 17491},
 {"i:2", 773306, 17495},
 {"i:3", 773431, 17498},
 {"i:4", 773563, 17501},
 {"i:5", 773695, 17504},
 {"LastCellOfAPage", 773840, 17507},
 {"p:12", 774286, 17515},
 {"i:6", 774429, 17518},
 {"i:7", 774572, 17521},
 {"i:8", 774705, 17524}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[661, 24, 478, 13, 93, "Section",ExpressionUUID->"89a2af2f-4d5d-4099-bd12-8828f9d605e4",
 CounterAssignments->{{"Section", 3}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{"p:11", "i:1"}],
Cell[1142, 39, 409, 13, 65, "Text",ExpressionUUID->"161e2b65-1c59-4a43-a7a1-94ac8f1249ee",
 CellTags->"i:2"],
Cell[1554, 54, 265, 10, 37, "CodeCaption",ExpressionUUID->"575539bb-fd1a-4faf-8fde-41ad82ec8ce6",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[1844, 68, 278, 7, 29, "Input",ExpressionUUID->"5827832c-27db-4cd1-aea4-633e8684ffe9"],
Cell[2125, 77, 1060, 30, 144, "Output",ExpressionUUID->"4c7db806-d296-497b-8ecf-e3666bd24f3b",
 Evaluatable->False]
}, Open  ]],
Cell[3200, 110, 273, 7, 37, "CodeCaption",ExpressionUUID->"62a2571b-b3bf-48db-b1e2-351b7d6ee035"],
Cell[CellGroupData[{
Cell[3498, 121, 274, 7, 29, "Input",ExpressionUUID->"672ac71a-9f3f-4846-8323-0c3f4ba1d0ed"],
Cell[3775, 130, 1063, 30, 144, "Output",ExpressionUUID->"6fa61f58-7f6e-4640-a2a7-b22b6ad7f5be",
 Evaluatable->False]
}, Open  ]],
Cell[4853, 163, 195, 4, 37, "CodeCaption",ExpressionUUID->"a9917087-0b0f-4aa9-87ee-8ae4ffb9f54a",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[5073, 171, 274, 7, 29, "Input",ExpressionUUID->"269bbda0-3d7d-45aa-b201-55127c3d5016"],
Cell[5350, 180, 12068, 331, 141, "Output",ExpressionUUID->"32cf1eae-5eba-414c-9b4f-f1953725dcc2",
 Evaluatable->False]
}, Open  ]],
Cell[17433, 514, 247, 7, 37, "CodeCaption",ExpressionUUID->"853d8d55-a68e-4e28-a077-ab7c0373acdf",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[17705, 525, 225, 5, 70, "Input",ExpressionUUID->"5893319e-e9b5-4294-a5e1-ba537e270b60"],
Cell[17933, 532, 10722, 246, 70, "Output",ExpressionUUID->"46f44eea-5c5d-46b9-a98b-3f22b9f27044",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[28670, 781, 263, 8, 70, "CodeCaption",ExpressionUUID->"228b2284-66a3-4738-8f90-ffbd64527792",
 CellTags->{"p:12", "i:6"}],
Cell[CellGroupData[{
Cell[28958, 793, 233, 5, 70, "Input",ExpressionUUID->"7c531024-517f-4a30-99fc-affa8a74b554"],
Cell[29194, 800, 1011, 24, 70, "Output",ExpressionUUID->"67fa0603-950b-4bf7-a05d-8244f6c65ecc",
 Evaluatable->False]
}, Open  ]],
Cell[30220, 827, 281, 7, 70, "CodeCaption",ExpressionUUID->"607ce741-8e85-4d3f-a4f8-c53beabb0d36",
 CellTags->"i:7"],
Cell[CellGroupData[{
Cell[30526, 838, 233, 6, 70, "Input",ExpressionUUID->"31754e54-2dcc-4bd2-b558-8c4e057a9bc6"],
Cell[30762, 846, 409, 14, 70, "Output",ExpressionUUID->"e83ab20a-7c41-400b-b2e3-82d7b83a5c86",
 Evaluatable->False]
}, Open  ]],
Cell[31186, 863, 244, 7, 70, "Text",ExpressionUUID->"ef0d2731-e9d6-46d4-84df-218976876cb8"],
Cell[31433, 872, 173, 4, 70, "CodeCaption",ExpressionUUID->"2637b9c7-3950-4981-bb27-32003d652413"],
Cell[CellGroupData[{
Cell[31631, 880, 309, 8, 70, "Input",ExpressionUUID->"3513756b-6ee8-4c3b-87c0-b24c30d976d5"],
Cell[31943, 890, 22606, 511, 70, "Output",ExpressionUUID->"9dfe1c85-0038-47aa-8357-e6fbb5485764",
 Evaluatable->False]
}, Open  ]],
Cell[54564, 1404, 174, 4, 70, "CodeCaption",ExpressionUUID->"96740fcc-f0d5-40ee-8fd9-9f68eb623a3c"],
Cell[CellGroupData[{
Cell[54763, 1412, 503, 14, 70, "Input",ExpressionUUID->"933a9794-c72a-4c90-863b-1e453194612f"],
Cell[55269, 1428, 22285, 591, 70, "Output",ExpressionUUID->"229eae52-b48f-4b6c-911a-8d4fe42c08b2",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77603, 2025, 159, 4, 70, "VocabularySection",ExpressionUUID->"1a17d580-85cd-4d94-b0a9-80172a901cc0"],
Cell[77765, 2031, 1634, 46, 70, "VocabularyTable",ExpressionUUID->"39036a04-8c08-4f42-84f2-d3c4a4883b00",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79436, 2082, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"8e167b4e-e586-45f3-9c32-2f85809bf2d9"],
Cell[CellGroupData[{
Cell[81241, 2132, 1427, 43, 70, "ExerciseSummaryCell",ExpressionUUID->"85841b1a-6791-4a22-8dcb-47645d4823f7"],
Cell[CellGroupData[{
Cell[82693, 2179, 860, 25, 70, "Exercise",ExpressionUUID->"69a9d7d2-77d1-4365-a7ba-c2eb80d36e36"],
Cell[83556, 2206, 21041, 496, 70, "ExerciseOutput",ExpressionUUID->"c52197ad-b9fb-46bf-b2c5-67965dee8e28"]
}, Closed]],
Cell[CellGroupData[{
Cell[104634, 2707, 705, 20, 70, "Exercise",ExpressionUUID->"dfa99e21-f42e-4ff7-b911-d45e30e58f46"],
Cell[105342, 2729, 62547, 1347, 70, "ExerciseOutput",ExpressionUUID->"2cc5f816-72eb-4759-9228-5aaf26ea3232"]
}, Closed]],
Cell[CellGroupData[{
Cell[167926, 4081, 719, 20, 70, "Exercise",ExpressionUUID->"372dc506-4658-4731-909e-d671f33970fa"],
Cell[168648, 4103, 69297, 1619, 70, "ExerciseOutput",ExpressionUUID->"23126828-f34a-4c11-a82c-2d50a65d1f43"]
}, Closed]],
Cell[CellGroupData[{
Cell[237982, 5727, 704, 20, 70, "Exercise",ExpressionUUID->"9621efc3-bf03-4320-8540-4f32da67b620"],
Cell[238689, 5749, 1661, 49, 70, "ExerciseOutput",ExpressionUUID->"64956d70-502e-403d-aa1d-327ba7f8af1a"]
}, Closed]],
Cell[CellGroupData[{
Cell[240387, 5803, 886, 26, 70, "Exercise",ExpressionUUID->"a64323f9-5be8-49c8-9526-9496d8999a0d"],
Cell[241276, 5831, 3445, 83, 70, "ExerciseOutput",ExpressionUUID->"b44c8362-f869-47c3-8417-722ce82b5e71"]
}, Closed]],
Cell[CellGroupData[{
Cell[244758, 5919, 724, 20, 70, "Exercise",ExpressionUUID->"d8dcc334-cc8a-478c-80db-09658a2ff326"],
Cell[245485, 5941, 62151, 1334, 70, "ExerciseOutput",ExpressionUUID->"13a07132-beb8-401b-b6e9-8b8986ae5672"]
}, Closed]],
Cell[CellGroupData[{
Cell[307673, 7280, 727, 20, 70, "Exercise",ExpressionUUID->"50d16da9-2827-477d-af79-593e94aff476"],
Cell[308403, 7302, 41110, 882, 70, "ExerciseOutput",ExpressionUUID->"ddd18592-588d-4c9a-886f-ba392d70d781"]
}, Closed]],
Cell[CellGroupData[{
Cell[349550, 8189, 726, 20, 70, "Exercise",ExpressionUUID->"dfe6e7a6-a63c-41de-9348-09db2f048fb0"],
Cell[350279, 8211, 40840, 880, 70, "ExerciseOutput",ExpressionUUID->"4a126fdf-f6c2-4293-af21-83b30ef0aa7a"]
}, Closed]],
Cell[CellGroupData[{
Cell[391156, 9096, 735, 20, 70, "Exercise",ExpressionUUID->"ded906dc-1ea0-44d4-bb7c-c96355027978"],
Cell[391894, 9118, 65420, 1540, 70, "ExerciseOutput",ExpressionUUID->"096be9c3-cb06-4080-b55e-6c97457107c0"]
}, Closed]],
Cell[CellGroupData[{
Cell[457351, 10663, 747, 21, 70, "Exercise",ExpressionUUID->"2365d96a-10e3-413e-b17e-6dd91525c381"],
Cell[458101, 10686, 104226, 2265, 70, "ExerciseOutput",ExpressionUUID->"6eb98aa4-43ba-4add-a394-c750028fb22b"]
}, Closed]],
Cell[CellGroupData[{
Cell[562364, 12956, 950, 27, 70, "Exercise",ExpressionUUID->"55598569-532f-4f84-a35e-758a7ca5bfb8"],
Cell[563317, 12985, 101775, 2221, 70, "ExerciseOutput",ExpressionUUID->"b37964b3-600c-4bc2-8b13-205e9f6d7b26"]
}, Closed]],
Cell[CellGroupData[{
Cell[665129, 15211, 883, 25, 70, "Exercise",ExpressionUUID->"fbd83359-d2a6-4973-a47d-045a4763325d"],
Cell[666015, 15238, 6778, 152, 70, "ExerciseOutput",ExpressionUUID->"24258ba0-2b04-42a8-ab34-13bf8ec3bd2e"]
}, Closed]],
Cell[CellGroupData[{
Cell[672830, 15395, 723, 20, 70, "Exercise",ExpressionUUID->"8e1ce00c-4368-4576-b832-ed79c5fcaf1f"],
Cell[673556, 15417, 5313, 126, 70, "ExerciseOutput",ExpressionUUID->"3a7ecb5b-bd69-4804-a4b4-dd23e99911c5"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[678930, 15550, 144, 4, 70, "QASection",ExpressionUUID->"26175449-abbf-4ab3-bdc2-3711f7b57485"],
Cell[679077, 15556, 187, 4, 70, "Question",ExpressionUUID->"32d2df52-4e4d-406d-90ea-7993f7a97a90"],
Cell[679267, 15562, 472, 10, 70, "Answer",ExpressionUUID->"97d72f3a-5882-4aa8-9da4-66a244d8a823"],
Cell[679742, 15574, 186, 4, 70, "Question",ExpressionUUID->"22eea1e8-566a-42da-9b9a-0f65fb2a1655"],
Cell[679931, 15580, 516, 14, 70, "Answer",ExpressionUUID->"52b63b50-e142-4f14-8f8a-3ac0e79a22e6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[680484, 15599, 156, 4, 70, "TechNoteSection",ExpressionUUID->"720da4dd-bff3-424c-9088-7c7c1a703f34"],
Cell[680643, 15605, 526, 12, 70, "TechNote",ExpressionUUID->"85d3476a-7bb0-4cc6-b1a6-cd4d60d4da13",
 CellTags->"i:8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[681206, 15622, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"42c60e78-0a5c-4974-8a55-6b93552bc2cb"],
Cell[681374, 15628, 311, 7, 70, "MoreExplore",ExpressionUUID->"b3f0d16e-5d35-42ed-b12a-94817f61de90"],
Cell[681688, 15637, 382, 9, 70, "MoreExplore",ExpressionUUID->"0fbde90b-55db-4100-9d99-635e0785a5aa",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature qI4mCcXYxPRbNKkg4fZi7cbK *)
