(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    407686,       8138]
NotebookOptionsPosition[    336658,       6643]
NotebookOutlinePosition[    396298,       7870]
CellTagsIndexPosition[    396219,       7865]
WindowTitle->Displaying Lists: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Make a bar chart of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}]], 
  "InlineCode",ExpressionUUID->"09ef7835-ee94-4bd1-9cff-8917097dca4d"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"4fa622f9-6ddf-474e-87db-bf7717cf7a63"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"05044a7a-6298-4394-97e8-2f29c590ab6e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3CFvY8cWwPG0JYXlRf0WZVVh6a76AXbVnW3JrbRb3arAzCwoyCTIxCjE
IMRSFWBiYGBiYBBVBpYCDCxdcKVeKbWzm8YeZ705s9nJmTP/n87ry4ulVU8y
85eTvXrfvfz9mfvy6Ojo7dfrfzx78eePb968+Ov5N+v/8XPx9rfXxatffir+
ePX61ZvvX361/uQ/6//8+sXR0ebj6w9zzh14FQD20Q0AUnQDgJS79dT/IgCS
QTEASNENAFJ0A4AU3QDwAav+cfH+F6Cts2rrBboB4H71tHSt0fxqebVYLJbN
1it0A8C96su+c+2L0XA4mq52X6IbAO61uOg4V/bOB72T9U8rncXWS27Xk/0r
Aul4/sO36Y5gz6a5/dlkdepcf17//wqtAKTWt+/fv5+nOKJuzHql64w2Hy3H
hSsmW78YpRuAVCbduF7NOrd/ndIdzrdfoRuAVC7duFFXVd34n6QbgFRW3bgX
3QCk6AbdAKToBt0ApOgGT24AUnSDYgBSdINuAFJ0g24AUnSDbgBSdINuAFJ0
g24AUnSDbgBSdIPnNwApukExACm6QTcAKbpBNwApukE3ACm6QTcAKbpBNwAp
ukE3ACm6QTcAKbrBc1+AFN2gGIAU3aAbgBTdoBuAFN2gG4AU3aAbgBTdoBuA
FN2gG4AU3eD5DUCKblAMQIpu0A1Aim7QDUCKbtANQCqvbtTTlmtNqp3P0Q1A
Kqdu1OftdSTKKd0APk0+3bhcV6PVOS7bvN8APlEm3ajn586dXF03/bI1qXde
crse+esLWJRJN3rrIrS7g8FZyxUnvcHVVjpoBSCVSTfm0/FoNBqPLo6LojuY
rJq7l+gGIJVJN27VZ2V7/+eUR/paArnIrBv3oBuAFN2gG4AU3aAbgBTdoBuA
FN3gyQ1Aim5QDECKbtANQIpu0A1Aim7QDUCKbtANQIpu0A1Aim7QDUCKbtAN
QIpu8NwXIEU3KAYgRTfoBiBFN+gGIEU36AYgRTfoBiBFN+gGIEU36AYgRTd4
fgOQohsUA5CiG3QDkKIbdAOQoht0A5CiG3QDkKIbdAOQoht0A5CiGzy/AUjR
DYoBSNENugFI0Q26AUjRDboBSGXTjav+cXHz68/2cFFvv0A3AKlMurEYtJ3r
LtcfXJy44qzaeoluAFKZdKO6upwtNrVYDDuupBvAJ8mkGzfq85NyXYlWf7r9
WbfrEb+2gGd9aNMdb5EnL0CUbjTv/3s1KVwx3nrDQSsQjZnrZmaRw2a9wnVG
m49W48KVE7qBp2DmuplZ5COqWWfzM8rmr1ROLy63X6EbiMbMdTOzyENUVVU3
/ifpBqIxc93MLBKMbiAaM9fNzCLB6AaiMXPdzCwSjG4gGjPXzcwiwXhyA9GY
uW5mFglGMRCNmetmZpFgdAPRmLluZhYJRjcQjZnrZmaRYHQD0Zi5bmYWCUY3
EI2Z62ZmkWB0A9GYuW5mFglGNxCNmetmZpFgdAPRmLluZhYJxnNfiMbMdTOz
SDCKgWjMXDcziwSjG4jGzHUzs0gwuoFozFw3M4sEoxuIxsx1M7NIMLqBaMxc
NzOLBKMbiMbMdTOzSDC6gWjMXDcziwTj+Q1EY+a6mVkkGMVANGaum5lFgtEN
RGPmuplZJBjdQDRmrpuZRYLRDURj5rqZWSQY3UA0Zq6bmUWC0Q1EY+a6mVkk
GN1ANGaum5lFgvH8BqIxc93MLBKMYiAaM9fNzCLB6AaiMXPdzCwSjG4gGjPX
zcwiwegGojFz3cws8hHN4uy4ePf7z+5wvv0K3UA0Zq6bmUUOWwxarugtm+vV
rO9c+7K5e4luIBoz183MIoctZ8PhbLn5qB47V0yqu5foBqIxc93MLPIwV73S
Faejrbcbd89v8BSHWuvvdaKzv8iTXxy6ITp79WLUdq7V3YnGNe83UpDoKaUb
CkfUjXo+2PxGdLT5jWjT7JSDbuiX6CmlGwpH1I3B8fbPIi1+v5GWRE8p3VA4
PL+Rj0RPKd1QOHQjH4meUrqhcOhGPhI9pXRD4dCNfCR6SumGwnnEbvDkhnKJ
nlK6oXB4v5GPRE8p3VA4dCMfiZ5SuqFw6EY+Ej2ldEPh0I18JHpK6YbCoRv5
SPSU0g2FQzfykegppRsKh27kI9FTSjcUDt3IR6KnlG4oHJ77ykeip5RuKBze
b+Qj0VNKNxQO3chHoqeUbigcupGPRE8p3VA4dCMfiZ5SuqFw6EY+Ej2ldEPh
0I18JHpK6YbCoRv5SPSU0g2Fw/Mb+Uj0lNINhcP7jXwkekrphsKhG/lI9JTS
DYVDN/KR6CmlGwqHbuQj0VNKNxQO3chHoqeUbigcupGPRE8p3VA4dCMfiZ5S
uqFweH4jH4meUrqhcHi/kY9ETyndUDh0Ix+JnlK6oXDoRj4SPaV0Q+HQjXwk
ekrphsIJ6EY167uit9r9JN3QL9FTSjcUjrQbi3Fv87cm5Vm1+3m6oV+ip5Ru
KBxZN+rpcXnS77XX7zfoRnISPaV0Q+EE/JzSXK7fctzTjW3vviaJzv4pTXRs
XDczi+zvYmaRh6hm93fDxjfXzCllEYWTdTemdCOBYRGFk3M36tnZQ36/kejX
xMwpZRGFk3M37kU3tA2LKBy64aEb2oZFFA7d8NANbcMiCodueOiGtmERhUM3
PPv//xuJfk3MnFIWUTh0Y78bNr65Zk4piygcuuGhG9qGRRQO3fDQDW3DIgqH
bnjohrZhEYVDNzx0Q9uwiMKhGx66oW1YROHQDQ/d0DYsonDohoduaBsWUTh0
w8NzX9qGRRQO3djvho1vrplTyiIKh2546Ia2YRGFQzc8dEPbsIjCoRseuqFt
WETh0A0P3dA2LKJw6IaHbmgbFlE4dMNDN7QNiygcuuHh+Q1twyIKh27sd8PG
N9fMKWURhUM3PHRD27CIwqEbHrqhbVhE4dAND93QNiyicOiGh25oGxZROHTD
Qze0DYsoHLrhoRvahkUUDt3w8PyGtmERhUM39rth45tr5pSyiMKhGx66oW1Y
ROHQDQ/d0DYsonDohoduaBsWUTi5dqMenrZufv3ZuphXdEPzsIjCybMbq0nX
udNFfb0Ynrqit6IbiodFFE6e3Zh2i6I73XzUTEtXTLbecdANbcMiCifXbrQ6
o+XNh6tu0RrvdgNAzj7UjUm3vO3G8tSV44PvNw78OQCSJrrdV8MTV/br6+t6
fu5c+7I59OfQDcAq4e1e9Y+Ld+9JzqbLw38O3QCsCrjddVXVjf9JugHk47Fu
N90A8vH5bjfdAKzidgP4rP4DF2AoEg==
            "], {{0, 224}, {360, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 224},
          PlotRange->{{0, 360}, {0, 224}}]], "ExerciseOutput",
         ImageSize->{364, 224},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d8e776f1-be20-4382-8ae5-e0ad4754173e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3CFvY8cWwPG0JYXlRf0WZVVh6a76AXbVnW3JrbRb3arAzCwoyCTIxCjE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              "], {{0, 224}, {360, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 224}, 
            PlotRange -> {{0, 360}, {0, 224}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9f957f03-faa8-4b86-b72c-f7e85e026505"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["4.1"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"51b774ee-c1f1-4832-bf87-3339a28be46f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f658782e-641b-4cd2-a457-2ec9fb4bcec6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d6561c55-2ce7-49e4-b030-2bd3f022b8ae"],

Cell["Make a pie chart of numbers from 1 to 10.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"4f05517e-3429-4511-993d-2d449627c442"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1fa109db-9cc7-43be-b4e3-a50310ef3e63"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvWdYlOfav/vuvb/sj/vD+/G/1lJsFI0iWOgw9N6RNr33YXofeu9FqhQR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            "], {{0, 360}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 360},
          PlotRange->{{0, 360}, {0, 360}}]], "ExerciseOutput",
         ImageSize->{364, 360},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3b583e0f-665b-49db-ab37-2b27610a8ebd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvWdYlOfav/vuvb/sj/vD+/G/1lJsFI0iWOgw9N6RNr33YXofeu9FqhQR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              "], {{0, 360}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 360}, 
            PlotRange -> {{0, 360}, {0, 360}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ed6bed4c-37a2-4a02-98b5-4b431f06dd3e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["4.2"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3f763e12-1446-49d8-ab03-02983aa97217"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a099663c-d0e0-4c9c-ad50-993ee457b2c2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a8f19355-b3cb-403e-b66a-29affaa20f35"],

Cell["Make a bar chart of numbers counting down from 20 to 1.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"e1da5a41-14d6-4137-b864-d07f693659b3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5b97a8c6-26ed-485e-9e0f-a5434031ceb8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3DFv4+Ydx3GnXTL2LRToi+jasWsOfQEJek/ahQEuBYsO3Lx58qSFkxZN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            "], {{0, 221}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 221},
          PlotRange->{{0, 360}, {0, 221}}]], "ExerciseOutput",
         ImageSize->{364, 221},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3dadd5d7-12d2-4bad-9a82-6c7c2431fdd4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3DFv4+Ydx3GnXTL2LRToi+jasWsOfQEJek/ahQEuBYsO3Lx58qSFkxZN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              "], {{0, 221}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 221}, 
            PlotRange -> {{0, 360}, {0, 221}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"93ba7984-0f99-4fd2-9d99-f1c0435c5983"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["4.3"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a83f2e76-7c5e-4a32-b7df-7856bd89ca0a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"80535e94-c528-4e54-af53-67c228675ad9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f830be10-3345-441b-af85-0945f2720cb4"],

Cell["Display numbers from 1 to 5 in a column.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"41919585-a600-49a7-8026-488a84b9389e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5f06cae6-e699-445e-adeb-931f0c7fdb36"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVVKGO3DAQjVpwhf2F/kDwUcOiSFcVXcidujmVbFd7larQsECzsCCjoCCj
kCATExOTABOTAAOTAIPr2NnNJluppCX7JEfJi8cev+eZT88/HrJ3URS9foDH
w9MvdDw+5V8+wsfX/ev3l/3u2+f9z93L7nj//B7IRxh3MPz7299gByGUdcv3
0ORRQMnMQqqOFIcEyIqbbbgEFl+RE0f/Qjrh1xR2mQQZir6G3XPSSyH05AOT
aAPM7dutw2pG26ZpmRxnwogmDqebn4dGAjmQFMzRIYBk3qgw25qziYaVUYTY
Vg+OQelCrxinWgjOiLxQhsHSUUouoSPzOyA8nolJd2lIpuq44JwxNhgnqis3
NpfnVjGNrGubljJ5ks3pLlnZkZS98yRFcTEE7bsS/am86Ys1aUct+iYN0i9c
hZZrvNHNTSPFfm6rYINpuvwQKIhMD5BN3kltRtWWPjsyTJPmRRqfrYgxHVYL
WmNW1X57MJJzZaY1xbA/eFyyhZmGZj58UvEzp0uQBKUgDMInUtReW6o0SUAm
T85FkVPveI0iVPnqqIPrhxJjXCTzqp3qSYWrCnuUiRc7qXu1SsqFcLFN3hud
1FfkLcJpaMQLpAp+WLxcOg8UWvJyZBcwh4/QoSq5vYY2tPQ4PWRZgYkcw183
FCjOyppSkgWRr/uK6eNTt3GX5Szz1cFNC9WBCjboUfFQRjHVzqo+v7QrVLOl
t4XqsP+tOn4DQ7Io2A==
            "], {{0, 91}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 91},
          PlotRange->{{0, 7}, {0, 91}}]], "ExerciseOutput",
         ImageSize->{11, 91},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "66da39e2-b0bf-4514-8fc5-8808f413dcf0"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVVKGO3DAQjVpwhf2F/kDwUcOiSFcVXcidujmVbFd7larQsECzsCCjoCCj
kCATExOTABOTAAOTAIPr2NnNJluppCX7JEfJi8cev+eZT88/HrJ3URS9foDH
w9MvdDw+5V8+wsfX/ev3l/3u2+f9z93L7nj//B7IRxh3MPz7299gByGUdcv3
0ORRQMnMQqqOFIcEyIqbbbgEFl+RE0f/Qjrh1xR2mQQZir6G3XPSSyH05AOT
aAPM7dutw2pG26ZpmRxnwogmDqebn4dGAjmQFMzRIYBk3qgw25qziYaVUYTY
Vg+OQelCrxinWgjOiLxQhsHSUUouoSPzOyA8nolJd2lIpuq44JwxNhgnqis3
NpfnVjGNrGubljJ5ks3pLlnZkZS98yRFcTEE7bsS/am86Ys1aUct+iYN0i9c
hZZrvNHNTSPFfm6rYINpuvwQKIhMD5BN3kltRtWWPjsyTJPmRRqfrYgxHVYL
WmNW1X57MJJzZaY1xbA/eFyyhZmGZj58UvEzp0uQBKUgDMInUtReW6o0SUAm
T85FkVPveI0iVPnqqIPrhxJjXCTzqp3qSYWrCnuUiRc7qXu1SsqFcLFN3hud
1FfkLcJpaMQLpAp+WLxcOg8UWvJyZBcwh4/QoSq5vYY2tPQ4PWRZgYkcw183
FCjOyppSkgWRr/uK6eNTt3GX5Szz1cFNC9WBCjboUfFQRjHVzqo+v7QrVLOl
t4XqsP+tOn4DQ7Io2A==
              "], {{0, 91}, {7, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 91}, 
            PlotRange -> {{0, 7}, {0, 91}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3b53d07c-7248-4d41-ab18-614d5cfc7ca8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["4.4"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bd8b4a86-8eda-4b3a-b87f-f5f4cc119acb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3a4cfd58-af2c-491f-8076-afdcc2f45e20"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"45c97be0-06ae-4fe5-8476-53506fb3fb95"],

Cell[TextData[{
 "Make a number line plot of ",
 "the squares ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], 
  "InlineCode",ExpressionUUID->"5a736793-9c2c-4607-8b06-d03a1eda26ff"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"8618ed72-997d-48f6-b55c-9689b9601e1b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"69733061-2c18-471b-bef4-45d99055ff24"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt2TGPo1YQB3AnaVLmK6TKV0ibMu1FaSPdKcslzYu0F70oBcVJdFYKVzRU
FHkVjaWjceOCFCiioKFAigsKJAoKJIpXcNnMA+Pd21W8iYTEYP9/2rWeLSQP
o2EGnj9/9dML6+PVavXmU3p58fKXr25vX/76zWf05lvx5sfX4ub7r8XPN69v
br989Ql9+AX9//DRamXWdwAAAAAAAAAAAAAAAAAAAAAAAABPvH//97s//vrt
9z/pldYX811TWWLMk7jaE5/QBeeQzui7t++GP1pfzHdNZYkxT+JqT3xCF5xD
aoanU6P1xXzXVJYY8ySu9sQndME5xP3GeUuMeRJXe+ITuuAcYn/jvCXGPImr
PfEJIYcAAAAAAAAAAAAAAAAMWZaFY2b/IhyzrGNYBTPLMTyjYnIMq2BwDJ9j
WAUzyzEWAMD/8WxvAQAAAAAAAAC4BkXkDbslXlTMHct/1GzX4rjFYwft3NE8
q823llDN8EYXvuwjl16h543rnHzrSD8d1+txR83JWKa7SoJjQTiqz6qOPHuo
j33BMuKuDMYa9ofrrs0eFHU2d3zPaRJpiajUuoyEJVOWOX5MZ9Ky46Kqq7Is
627ucM4rE9V3iWN/S30p3EibwhbC51kebaKcB9XbKmH5SVFTuouSZYEUFK5K
azNQbMveHprUpzFY6ruSZuKpY3NS7mwKjGq3oZliOYeO2oaypOqzTEXNMs0P
tBllWPVRamrZfsowx4/pg0n1Po6iOOMers7WcrOly1AMSW6pifj9zNY5LTmW
dJsH9lpRyFL1faPLaXKrKI72cdmybNJdHe3iul+mLuU3zfyxJ3c0YgTDaVjn
UZT3IevE6iM8UMtzgjimoi5ZZvkD1Dekmwzr1LO9JfSNck/FIVW4Uxu6sXPL
ueN5VndQY3NulJTxkOM2kSxH4eAQyOHS68o93XtsVBiqDS32Fd+irsytnYir
LvNt99hIGl/YCb++MaoU9TUv7u66iLIrNuEuNEW9ifhmudemvnDjYZ24chF9
467rxqw2nmVtOW8T9Nr8vm/4YuwbTUxXJtt0Z0qOj1GdHtOduMIOD/MFdYbu
n63suG9r9DA49o3asyTPvqHL2ETsx0N2Oz2WcZuI/smFtYqmiZNrMxTpLEL2
1yDJqUcPva6mDHO8C33EPLoe+0YXrc0DOK0OoWPZIdt0n/pG3/S8ynxWm10D
jpNF72lYS78vXjNUKhrecqvNJnRosbwGdbEzO6Kx2RHtx2AbCCpqk+Y6oWHI
d6CcZONuucN/F3fQ5O648+wv4TcgnQfj/gYFn40/Tqw5XoKjPLDH+41m58rj
Pr8fMWzSfXO4Z5ttmftf3IKsnjvAp/Ru/UHINPuafGeybKK2I56/AT3R6bbV
/JryWQsM+aRrW547jP/KRLy0dC+wQrq2WVhhAAAAAAAAAADM5R+7e3kp
            "], {{0, 
            39}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 39},
          PlotRange->{{0, 360}, {0, 39}}]], "ExerciseOutput",
         ImageSize->{364, 39},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a6d40530-1abf-4ac8-8e3b-bed956db0c55"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt2TGPo1YQB3AnaVLmK6TKV0ibMu1FaSPdKcslzYu0F70oBcVJdFYKVzRU
FHkVjaWjceOCFCiioKFAigsKJAoKJIpXcNnMA+Pd21W8iYTEYP9/2rWeLSQP
o2EGnj9/9dML6+PVavXmU3p58fKXr25vX/76zWf05lvx5sfX4ub7r8XPN69v
br989Ql9+AX9//DRamXWdwAAAAAAAAAAAAAAAAAAAAAAAABPvH//97s//vrt
9z/pldYX811TWWLMk7jaE5/QBeeQzui7t++GP1pfzHdNZYkxT+JqT3xCF5xD
aoanU6P1xXzXVJYY8ySu9sQndME5xP3GeUuMeRJXe+ITuuAcYn/jvCXGPImr
PfEJIYcAAAAAAAAAAAAAAAAMWZaFY2b/IhyzrGNYBTPLMTyjYnIMq2BwDJ9j
WAUzyzEWAMD/8WxvAQAAAAAAAAC4BkXkDbslXlTMHct/1GzX4rjFYwft3NE8
q823llDN8EYXvuwjl16h543rnHzrSD8d1+txR83JWKa7SoJjQTiqz6qOPHuo
j33BMuKuDMYa9ofrrs0eFHU2d3zPaRJpiajUuoyEJVOWOX5MZ9Ky46Kqq7Is
627ucM4rE9V3iWN/S30p3EibwhbC51kebaKcB9XbKmH5SVFTuouSZYEUFK5K
azNQbMveHprUpzFY6ruSZuKpY3NS7mwKjGq3oZliOYeO2oaypOqzTEXNMs0P
tBllWPVRamrZfsowx4/pg0n1Po6iOOMers7WcrOly1AMSW6pifj9zNY5LTmW
dJsH9lpRyFL1faPLaXKrKI72cdmybNJdHe3iul+mLuU3zfyxJ3c0YgTDaVjn
UZT3IevE6iM8UMtzgjimoi5ZZvkD1Dekmwzr1LO9JfSNck/FIVW4Uxu6sXPL
ueN5VndQY3NulJTxkOM2kSxH4eAQyOHS68o93XtsVBiqDS32Fd+irsytnYir
LvNt99hIGl/YCb++MaoU9TUv7u66iLIrNuEuNEW9ifhmudemvnDjYZ24chF9
467rxqw2nmVtOW8T9Nr8vm/4YuwbTUxXJtt0Z0qOj1GdHtOduMIOD/MFdYbu
n63suG9r9DA49o3asyTPvqHL2ETsx0N2Oz2WcZuI/smFtYqmiZNrMxTpLEL2
1yDJqUcPva6mDHO8C33EPLoe+0YXrc0DOK0OoWPZIdt0n/pG3/S8ynxWm10D
jpNF72lYS78vXjNUKhrecqvNJnRosbwGdbEzO6Kx2RHtx2AbCCpqk+Y6oWHI
d6CcZONuucN/F3fQ5O648+wv4TcgnQfj/gYFn40/Tqw5XoKjPLDH+41m58rj
Pr8fMWzSfXO4Z5ttmftf3IKsnjvAp/Ru/UHINPuafGeybKK2I56/AT3R6bbV
/JryWQsM+aRrW547jP/KRLy0dC+wQrq2WVhhAAAAAAAAAADM5R+7e3kp
              "], {{
              0, 39}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 39}, 
            PlotRange -> {{0, 360}, {0, 39}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"db967f8a-8a14-49b4-9b68-796dc084b533"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["4.5"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"63c38a43-ba87-48d4-86b5-e9edd59fcb0b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0894da53-9440-47c5-9a1d-82c47df38f9d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4edacc37-0fc1-452e-b3dc-403b7a9e8687"],

Cell["Make a pie chart with 10 identical segments, each of size 1.", \
"Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"7b440fe2-c616-449c-96bc-1269424d0a00"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"46fe3745-d085-45f8-85ef-4dae5cf5d16a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvWdUk/m+932e537zvHiete51v7zXs9a2gFJEih2khN57b+mEhJBASE8o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            "], {{0, 360}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 360},
          PlotRange->{{0, 360}, {0, 360}}]], "ExerciseOutput",
         ImageSize->{364, 360},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e6402a89-1514-4688-9e91-9d2dec4db87c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvWdUk/m+932e537zvHiete51v7zXs9a2gFJEih2khN57b+mEhJBASE8o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              "], {{0, 360}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 360}, 
            PlotRange -> {{0, 360}, {0, 360}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d3b42497-f30e-4842-b2b0-ffabcf28f375"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["4.6"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"51453f7b-9f9c-485c-afbc-18406075b175"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1465c2f9-c8a9-4c81-a1e9-9cd2a5564a37"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0389fcfc-4697-4365-b220-d1aa8ac36e0c"],

Cell["\<\
Make a column of pie charts with 1, 2 and 3 identical segments.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "4.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"c2113015-f44f-491f-887b-3164ebe6a3b2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3b6aeea4-985f-40ae-be47-84acd68e93e8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfWdYVdfa7Xnu/fP9vH/v93333uTEY066mpwkJ82uUZFmoYkIgghIZ9N7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            "], {{0, 555}, {180, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{180, 555},
          PlotRange->{{0, 180}, {0, 555}}]], "ExerciseOutput",
         ImageSize->{184, 555},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b12e1c38-27d8-4630-b4f5-22abc83778a1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfWdYVdfa7Xnu/fP9vH/v93333uTEY066mpwkJ82uUZFmoYkIgghIZ9N7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              "], {{0, 555}, {180, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {180, 555}, 
            PlotRange -> {{0, 180}, {0, 555}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4510def6-9b49-4fa4-8f77-357125e3d108"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["4.7"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"56787df1-e4d8-4371-bc50-b70aa1b313e1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"17aa8d4f-03a9-4e95-b30c-69fd4ed69be9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b60dc39c-b873-4ceb-9919-af57112ef1ac"],

Cell["\<\
Make a list of pie charts with 1, 2 and 3 identical segments.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"c0a005b3-cead-4cc0-b278-f5ccf1c106cd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0638fd34-f38d-416e-8de3-a9b3df32ec05"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnfdblee655mZX+bH+QPmzMyZc9ztKEZ3kp29k21ARLAiqLHRF71J772u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            "], {{0, 398}, {
            386, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{386, 398},
          PlotRange->{{0, 386}, {0, 398}}]], "ExerciseOutput",
         ImageSize->{390, 398},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d7a0e2bf-d992-4157-869f-bb1d98665768"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnfdblee655mZX+bH+QPmzMyZc9ztKEZ3kp29k21ARLAiqLHRF71J772u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              "], {{0, 
              398}, {386, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {386, 398}, 
            PlotRange -> {{0, 386}, {0, 398}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1c10c36b-1b20-47c4-8565-b9aaab25444a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x4.1"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"48e32f26-ce3e-48a1-acc3-2b0a15e0c9cb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"54a437c0-35cf-4849-8ae1-792b9e1f448e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a982ef44-abb4-4809-9ba1-b2ff69eb269c"],

Cell["\<\
Make a bar chart of the sequence 1, 2, 3, ..., 9, 10, 9, 8, 7, ..., 1.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"bfc3bcee-e5ce-41b4-9728-6a42c7ae96aa"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"693f9800-ec26-4351-be64-be6b68ef5879"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnDFrI9sZhjdJkzJ/IeRPpE2ZMveSH3Av2XMTWCawN0xIoU6dK1VuVKlR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            "], {{0, 221}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 221},
          PlotRange->{{0, 360}, {0, 221}}]], "ExerciseOutput",
         ImageSize->{364, 221},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "766ad6f0-468d-47de-b983-4a6efeb86004"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnDFrI9sZhjdJkzJ/IeRPpE2ZMveSH3Av2XMTWCawN0xIoU6dK1VuVKlR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              "], {{0, 221}, {360, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 221}, 
            PlotRange -> {{0, 360}, {0, 221}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1d1b4763-5a84-4a0d-aeae-03eb07a48e21"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x4.2"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9e77f844-29b5-412e-9195-2279d0559469"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a92b07e6-c701-43ea-ae7f-d20050a00743"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f91af1b3-9a74-494e-920b-7f32bcc0b64b"],

Cell["\<\
Make a list of a pie chart, bar chart and line plot of the numbers from 1 to \
10.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"21a83cab-063e-437c-b677-0a08e7fd8c8d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2a78c927-842e-4a4b-90cf-7807f0f8b680"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3Xs8lPn/N3D3ff9z/3n/8f3r97jv35btoJKyncuZSAhFkeOYMYzDGKcZ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            "], {{0, 334}, {386, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{386, 334},
          PlotRange->{{0, 386}, {0, 334}}]], "ExerciseOutput",
         ImageSize->{390, 334},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "542ab3f4-4d80-401a-8c28-2f6005e74310"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3Xs8lPn/N3D3ff9z/3n/8f3r97jv35btoJKyncuZSAhFkeOYMYzDGKcZ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              "], {{0, 334}, {386, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {386, 334}, 
            PlotRange -> {{0, 386}, {0, 334}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2e4e61bb-19b4-44ca-acfa-3868da212140"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x4.3"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"99bf907d-0901-47cb-b3cf-64729fdde725"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e905f235-606b-4425-a48a-2e65ce44df90"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b78c0626-e9bc-4f46-be0b-f911f043cc9d"],

Cell[TextData[{
 "Make a list of a pie chart and a bar chart of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
    "21", ",", "34", ",", "55"}], "}"}]], "InlineCode",ExpressionUUID->
  "14390fae-af5b-48a5-8391-139630ffe80e"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"39937900-c55e-4b41-8c56-7a02df2713c7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"370258c5-9c7d-44a2-80d6-a9e4aa138e8b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnWlYVNe65+3uL/2xP/TzdPdzb58ERGQQFafIPE/KPMhU1EBV7RooCoqa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            "], {{0, 182}, {380, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{380, 182},
          PlotRange->{{0, 380}, {0, 182}}]], "ExerciseOutput",
         ImageSize->{384, 182},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a93cc975-a2f3-4bd8-a148-8d8031e8c49d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnWlYVNe65+3uL/2xP/TzdPdzb58ERGQQFafIPE/KPMhU1EBV7RooCoqa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              "], {{0, 182}, {380, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {380, 182}, 
            PlotRange -> {{0, 380}, {0, 182}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5d4fdd85-f694-4862-8166-669441f20389"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x4.4"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b201fce8-700b-4167-906b-0b6a0e25c648"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"85718867-a6dc-465a-a50d-869e6742e9d8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f083cb69-9eec-4f79-8227-d5fef6f3395b"],

Cell[TextData[{
 "Make a column of two number line plots of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], 
  "InlineCode",ExpressionUUID->"1a75c453-ec0f-47a1-91c3-8fb5de03b0f7"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"41c50b51-0f6b-4d04-9e47-554846ea15ac"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1614f99a-dd67-4246-8563-36bad18f4177"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3KGPm1AcB/DLZib3L+y/mD05e8vskrus7zLDkt7CMvHEElwzUXUGhRiq
huxqMBWdIAsCgyAZAkFSgWiCQLwb+9F2l25XNfhx7PX7ybXhEP3y4Md7pEl/
zy7enYlHJycnV0/o7ez8w+l4fP7x5VP655Vx9fbSGL15YbwfXY7Gzy8e085T
en2lV7NdAwAAAAzM7e3Pm28/Pn/5Tu+0jazBBvWcRSjl9aeb7R9tI2uwQT1n
ESrCuzjaRtZgg3rOqvUte8wb7em6XOJ5oytCCM2CdM3qKujg5wxw54MfwJEc
vwA45H7xAAAAAAAMWpVYwoxK3hC1CifG9pHZWma8YUXkbaMsJ6hYk7aqWArJ
fQLLZDcoMovXvGHbxDywmjQZ8w5N+VIYbqTqOvGoEueclyyjETlRUatsKoSb
MF+zupo3Z9BkPoF17JqmExRFked5USresEbpWZbjOYJ93lDJchEXzYjK6Jou
HWdamcabglC5TbcYc22kVBnyemJazCew8qSwZotguYxz7mrfoxKTf03ZRRWh
FMIOVtxBVTrfzMAW6+xbZXMhpqtaeaaMWFcvldMdZUxdf+7SuKbLnDNsTxX3
Uxt56NLVcgL2canfM27kGMKO2HJKd/NM4/szubluK87yUNVuVOvQFpJ1Ud7T
S21kC1r8zWAzHyrFuVw2wxFB0WyGtmE4MVuSyuIwCIIwWEwox4/WfMP6c1Cc
Bf93ruSuDZVO9r/cN2esz9mpTxOwaNYU0077WCurGT1vMN/Jyd2gpJP1NGto
SlVlqd0Z1HJQAAAAAAAAAAAAAAAAANrR9Wfg+B19e7q2j0D/jfZ0bTuDvj3t
6Vr2mDfa03W5xPNGV3rrz9BnIwgts7oKOvg5A9z54AdwJMffvsELaOl+8QAA
AAAADBr69rSEvj2toG9PW+jb0wX07ekO+vb8cwr69nQEfXvaQN+eDqBvT6e5
6NvTDvr2/Fe0bHGj5aAAAAAAAOCI/QIgu83D
            "], {{0, 65}, {180, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{180, 65},
          PlotRange->{{0, 180}, {0, 65}}]], "ExerciseOutput",
         ImageSize->{184, 65},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8f0cb8c3-82a1-44df-821d-097f43c6eacf"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3KGPm1AcB/DLZib3L+y/mD05e8vskrus7zLDkt7CMvHEElwzUXUGhRiq
huxqMBWdIAsCgyAZAkFSgWiCQLwb+9F2l25XNfhx7PX7ybXhEP3y4Md7pEl/
zy7enYlHJycnV0/o7ez8w+l4fP7x5VP655Vx9fbSGL15YbwfXY7Gzy8e085T
en2lV7NdAwAAAAzM7e3Pm28/Pn/5Tu+0jazBBvWcRSjl9aeb7R9tI2uwQT1n
ESrCuzjaRtZgg3rOqvUte8wb7em6XOJ5oytCCM2CdM3qKujg5wxw54MfwJEc
vwA45H7xAAAAAAAMWpVYwoxK3hC1CifG9pHZWma8YUXkbaMsJ6hYk7aqWArJ
fQLLZDcoMovXvGHbxDywmjQZ8w5N+VIYbqTqOvGoEueclyyjETlRUatsKoSb
MF+zupo3Z9BkPoF17JqmExRFked5USresEbpWZbjOYJ93lDJchEXzYjK6Jou
HWdamcabglC5TbcYc22kVBnyemJazCew8qSwZotguYxz7mrfoxKTf03ZRRWh
FMIOVtxBVTrfzMAW6+xbZXMhpqtaeaaMWFcvldMdZUxdf+7SuKbLnDNsTxX3
Uxt56NLVcgL2canfM27kGMKO2HJKd/NM4/szubluK87yUNVuVOvQFpJ1Ud7T
S21kC1r8zWAzHyrFuVw2wxFB0WyGtmE4MVuSyuIwCIIwWEwox4/WfMP6c1Cc
Bf93ruSuDZVO9r/cN2esz9mpTxOwaNYU0077WCurGT1vMN/Jyd2gpJP1NGto
SlVlqd0Z1HJQAAAAAAAAAAAAAAAAANrR9Wfg+B19e7q2j0D/jfZ0bTuDvj3t
6Vr2mDfa03W5xPNGV3rrz9BnIwgts7oKOvg5A9z54AdwJMffvsELaOl+8QAA
AAAADBr69rSEvj2toG9PW+jb0wX07ekO+vb8cwr69nQEfXvaQN+eDqBvT6e5
6NvTDvr2/Fe0bHGj5aAAAAAAAOCI/QIgu83D
              "], {{0, 65}, {180, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {180, 65}, 
            PlotRange -> {{0, 180}, {0, 65}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2ca3150e-a153-4dd9-98ac-0af89ab8fe56"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x4.5"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a6b88aea-9b51-46d1-96c8-fcbb88792da9"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"cf8c3790-1956-4539-af48-6b4118b6d4a8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"621e21c6-059d-4c52-8414-9d9726d810f2"],

Cell["Make a number line of fractions 1/2, 1/3, ... through 1/9.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+4.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"1e1028a7-6afa-4836-b20f-4e0d5f942d42"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4e92666d-7ea9-44c0-8dce-64fa5667f515"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmb+Po0YUx52kSZl/IVX+hbQp016UNtKdbueSZiLtRROloIhEZ13hioaK
IlRukM6NGxekQBEFDQVSKCiQXFAgTTEFF/IG/PNW3lt7vV7G+n60u5qFh3lf
3pfHMP761a8v2Oej0ejtl/Tnxcvfv7u9ffnHD1/RPz/yt7+84Tevv+e/3by5
uf321Re08Rv6/fmz0UiPWwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4A4fPvz3
/u9/3/31D/2l8QkBR4U98pALfNQAT3cuDE3bXK74gpOin/583//Q+ISAo8Ie
ecgFPmqApzsXhqZtLld8wakZbqTR+ISAo8IeecgFPmqApzsXhqZtLld8wTHf
GP7pzoWhaZvLFV9wrG8M/3TnwtC0zQUXHAAAAAAAAAAAAAAAAAAAwFwYY08R
/EQf+3TByOGE4CHkcFQwcjgt+GLnGohesxIeQg5HBQ8hh6OCkcMngxkAABzD
w9sOAAAAAAAAAAAAwPWiQtfqFkusRSHv7MxsJpI7m41BFZ7oxAm3UDvbm3I6
5v0akRcWz5be4yhCt5fg7kuokqDXZnuROnTw0LnXlq0MLOal9TPkdQ5UEa60
ueF+gepgbUtmTYd829WJR74rVVuSCbm/WwlZRnYnIB2ygHtJPMEdKg2ZkHMv
3Wwv5xaJrZq2zgK6vfLmGXM8lToWjIelUmXI93p7QVXzkqptigljfmZk8e6x
JZHPtDF9U31Z+5w5Ydmqkvr+XvdTqWBWVCyrZVmW1ZBdmXrrG6qhnPmO/WRg
215A5TN3viF9XRedvcpouLVflYVhVumRitmeamOQKZXG7xJXU06NYiNO5mnX
LBpty6mZfeOwLelhrVu9OxY7ko1CJtTn026ekfmCKrfZo3ItbRGFYTT0uVTq
WU7U3UFt7XEr/shlTSYM7hu1L0TUF0DG4s5jq22XVDfuRkNu7IegviGcuB8n
ruXu30Qqn3XzXXvo/jvAQVs2+ZixRdUWU9tLzXwJk4nF3ZW2xBXutm+UC4ce
0/5s7k+oek75XBk+AJrJrwtUuUx83Df0xMngvuHxdd+oI8G93XtIdW9hlmdk
02i1+zzuRP04dsRu32jWkiiE7djSIA7ZMqMpPrNni5ljcTHxk6WBrUMmgq37
Rle57a5mU7qa5opBMVx1y3DCRKD09G/Wv+krWdVynb7ZfaMJx8wK8rZ/I7Zm
JFNWFYlTxVyviEZ6OXFbK7NYLqhemdKPYGqAM/KYrpzqSsb6ey7eX9UxiEO2
rIs0jqMojvwxt715UZtYu3JCPSHX4mYWuVL7s7elfm3pnwVVzIf++rxdwp2m
2m36vXljNpVaBvcNEpeOV8vT4+6BLDtx1Xy9tV+5NlRgGqxk2FNdr82KRz6n
6S7j3bdIuZnSPmFLPfGwPFPXRcmVwcp6dtA1+N6Wsq0zZ/11ihFf8ykplYmd
+0E0UsprFdccqly34+LpnJlrtuXhAl2zagAAAAAAAAAAAIDz8T8qHkCa
            "], {{0, 
            39}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 39},
          PlotRange->{{0, 360}, {0, 39}}]], "ExerciseOutput",
         ImageSize->{364, 39},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e21d8e88-8998-4066-a9a0-b161a8913f0a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmb+Po0YUx52kSZl/IVX+hbQp016UNtKdbueSZiLtRROloIhEZ13hioaK
IlRukM6NGxekQBEFDQVSKCiQXFAgTTEFF/IG/PNW3lt7vV7G+n60u5qFh3lf
3pfHMP761a8v2Oej0ejtl/Tnxcvfv7u9ffnHD1/RPz/yt7+84Tevv+e/3by5
uf321Re08Rv6/fmz0UiPWwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4A4fPvz3
/u9/3/31D/2l8QkBR4U98pALfNQAT3cuDE3bXK74gpOin/583//Q+ISAo8Ie
ecgFPmqApzsXhqZtLld8wakZbqTR+ISAo8IeecgFPmqApzsXhqZtLld8wTHf
GP7pzoWhaZvLFV9wrG8M/3TnwtC0zQUXHAAAAAAAAAAAAAAAAAAAwFwYY08R
/EQf+3TByOGE4CHkcFQwcjgt+GLnGohesxIeQg5HBQ8hh6OCkcMngxkAABzD
w9sOAAAAAAAAAAAAwPWiQtfqFkusRSHv7MxsJpI7m41BFZ7oxAm3UDvbm3I6
5v0akRcWz5be4yhCt5fg7kuokqDXZnuROnTw0LnXlq0MLOal9TPkdQ5UEa60
ueF+gepgbUtmTYd829WJR74rVVuSCbm/WwlZRnYnIB2ygHtJPMEdKg2ZkHMv
3Wwv5xaJrZq2zgK6vfLmGXM8lToWjIelUmXI93p7QVXzkqptigljfmZk8e6x
JZHPtDF9U31Z+5w5Ydmqkvr+XvdTqWBWVCyrZVmW1ZBdmXrrG6qhnPmO/WRg
215A5TN3viF9XRedvcpouLVflYVhVumRitmeamOQKZXG7xJXU06NYiNO5mnX
LBpty6mZfeOwLelhrVu9OxY7ko1CJtTn026ekfmCKrfZo3ItbRGFYTT0uVTq
WU7U3UFt7XEr/shlTSYM7hu1L0TUF0DG4s5jq22XVDfuRkNu7IegviGcuB8n
ruXu30Qqn3XzXXvo/jvAQVs2+ZixRdUWU9tLzXwJk4nF3ZW2xBXutm+UC4ce
0/5s7k+oek75XBk+AJrJrwtUuUx83Df0xMngvuHxdd+oI8G93XtIdW9hlmdk
02i1+zzuRP04dsRu32jWkiiE7djSIA7ZMqMpPrNni5ljcTHxk6WBrUMmgq37
Rle57a5mU7qa5opBMVx1y3DCRKD09G/Wv+krWdVynb7ZfaMJx8wK8rZ/I7Zm
JFNWFYlTxVyviEZ6OXFbK7NYLqhemdKPYGqAM/KYrpzqSsb6ey7eX9UxiEO2
rIs0jqMojvwxt715UZtYu3JCPSHX4mYWuVL7s7elfm3pnwVVzIf++rxdwp2m
2m36vXljNpVaBvcNEpeOV8vT4+6BLDtx1Xy9tV+5NlRgGqxk2FNdr82KRz6n
6S7j3bdIuZnSPmFLPfGwPFPXRcmVwcp6dtA1+N6Wsq0zZ/11ihFf8ykplYmd
+0E0UsprFdccqly34+LpnJlrtuXhAl2zagAAAAAAAAAAAIDz8T8qHkCa
              "], {{
              0, 39}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 39}, 
            PlotRange -> {{0, 360}, {0, 39}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"863e3df8-c8d0-45eb-9a25-54af66ac69c0"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x4.6"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b1d2507d-059a-4e6b-82cf-dce762a22cb1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"727e5973-2fb2-456b-ada9-b5ebca8487ab"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fac2e570-c309-40bf-959b-fa3b954c64c3"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Displaying Lists: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[" 4  Displaying Lists", "DockedCellSectionTitle"]},
                  "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
04-displaying-lists.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+4.1", "4.1", "+4.2", "4.2", "+4.3", "4.3", "+4.4", "4.4", "+4.5", 
         "4.5", "+4.6", "4.6", "4.7"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+4.1", "4.1", "+4.2", "4.2", "+4.3", "4.3", "+4.4", "4.4", "+4.5", 
      "4.5", "+4.6", "4.6", "4.7"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[11972, 272, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f658782e-641b-4cd2-a457-2ec9fb4bcec6",
   CellTags->"FirstInputCell"],
  Cell[66545, 1250, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a099663c-d0e0-4c9c-ad50-993ee457b2c2",
   CellTags->"FirstInputCell"],
  Cell[79200, 1541, 813, 26, 
  70, "Input", "ExpressionUUID" -> "80535e94-c528-4e54-af53-67c228675ad9",
   CellTags->"FirstInputCell"],
  Cell[86330, 1742, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3a4cfd58-af2c-491f-8076-afdcc2f45e20",
   CellTags->"FirstInputCell"],
  Cell[95097, 1974, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0894da53-9440-47c5-9a1d-82c47df38f9d",
   CellTags->"FirstInputCell"],
  Cell[148637, 2936, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1465c2f9-c8a9-4c81-a1e9-9cd2a5564a37",
   CellTags->"FirstInputCell"],
  Cell[185387, 3624, 813, 26, 
  70, "Input", "ExpressionUUID" -> "17aa8d4f-03a9-4e95-b30c-69fd4ed69be9",
   CellTags->"FirstInputCell"],
  Cell[226797, 4388, 813, 26, 
  70, "Input", "ExpressionUUID" -> "54a437c0-35cf-4849-8ae1-792b9e1f448e",
   CellTags->"FirstInputCell"],
  Cell[240872, 4704, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a92b07e6-c701-43ea-ae7f-d20050a00743",
   CellTags->"FirstInputCell"],
  Cell[284361, 5503, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e905f235-606b-4425-a48a-2e65ce44df90",
   CellTags->"FirstInputCell"],
  Cell[318947, 6159, 813, 26, 
  70, "Input", "ExpressionUUID" -> "85718867-a6dc-465a-a50d-869e6742e9d8",
   CellTags->"FirstInputCell"],
  Cell[326818, 6376, 813, 26, 
  70, "Input", "ExpressionUUID" -> "cf8c3790-1956-4539-af48-6b4118b6d4a8",
   CellTags->"FirstInputCell"],
  Cell[335530, 6602, 813, 26, 
  70, "Input", "ExpressionUUID" -> "727e5973-2fb2-456b-ada9-b5ebca8487ab",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 394407, 7822}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[639, 22, 594, 16, 70, "Exercise", "ExpressionUUID" -> \
"4fa622f9-6ddf-474e-87db-bf7717cf7a63",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1258, 42, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"05044a7a-6298-4394-97e8-2f29c590ab6e"],
Cell[1897, 63, 9469, 184, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9f957f03-faa8-4b86-b72c-f7e85e026505"]
}, Closed]],
Cell[CellGroupData[{
Cell[11403, 252, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"51b774ee-c1f1-4832-bf87-3339a28be46f"],
Cell[11972, 272, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f658782e-641b-4cd2-a457-2ec9fb4bcec6",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12822, 303, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d6561c55-2ce7-49e4-b030-2bd3f022b8ae"],
Cell[13109, 314, 424, 9, 70, "Exercise", "ExpressionUUID" -> \
"4f05517e-3429-4511-993d-2d449627c442",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[13558, 327, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1fa109db-9cc7-43be-b4e3-a50310ef3e63"],
Cell[14197, 348, 51742, 877, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ed6bed4c-37a2-4a02-98b5-4b431f06dd3e"]
}, Closed]],
Cell[CellGroupData[{
Cell[65976, 1230, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"3f763e12-1446-49d8-ab03-02983aa97217"],
Cell[66545, 1250, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a099663c-d0e0-4c9c-ad50-993ee457b2c2",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67407, 1282, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a8f19355-b3cb-403e-b66a-29affaa20f35"],
Cell[67694, 1293, 438, 9, 70, "Exercise", "ExpressionUUID" -> \
"e1da5a41-14d6-4137-b864-d07f693659b3",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[68157, 1306, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5b97a8c6-26ed-485e-9e0f-a5434031ceb8"],
Cell[68796, 1327, 9798, 189, 70, "ExerciseOutput", "ExpressionUUID" -> \
"93ba7984-0f99-4fd2-9d99-f1c0435c5983"]
}, Closed]],
Cell[CellGroupData[{
Cell[78631, 1521, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"a83f2e76-7c5e-4a32-b7df-7856bd89ca0a"],
Cell[79200, 1541, 813, 26, 70, "Input", "ExpressionUUID" -> \
"80535e94-c528-4e54-af53-67c228675ad9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[80062, 1573, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f830be10-3345-441b-af85-0945f2720cb4"],
Cell[80349, 1584, 423, 9, 70, "Exercise", "ExpressionUUID" -> \
"41919585-a600-49a7-8026-488a84b9389e",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[80797, 1597, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5f06cae6-e699-445e-adeb-931f0c7fdb36"],
Cell[81436, 1618, 4288, 99, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3b53d07c-7248-4d41-ab18-614d5cfc7ca8"]
}, Closed]],
Cell[CellGroupData[{
Cell[85761, 1722, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"bd8b4a86-8eda-4b3a-b87f-f5f4cc119acb"],
Cell[86330, 1742, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3a4cfd58-af2c-491f-8076-afdcc2f45e20",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87192, 1774, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"45c97be0-06ae-4fe5-8476-53506fb3fb95"],
Cell[87479, 1785, 620, 17, 70, "Exercise", "ExpressionUUID" -> \
"8618ed72-997d-48f6-b55c-9689b9601e1b",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[88124, 1806, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"69733061-2c18-471b-bef4-45d99055ff24"],
Cell[88763, 1827, 5728, 122, 70, "ExerciseOutput", "ExpressionUUID" -> \
"db967f8a-8a14-49b4-9b68-796dc084b533"]
}, Closed]],
Cell[CellGroupData[{
Cell[94528, 1954, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"63c38a43-ba87-48d4-86b5-e9edd59fcb0b"],
Cell[95097, 1974, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0894da53-9440-47c5-9a1d-82c47df38f9d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95959, 2006, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4edacc37-0fc1-452e-b3dc-403b7a9e8687"],
Cell[96246, 2017, 445, 10, 70, "Exercise", "ExpressionUUID" -> \
"7b440fe2-c616-449c-96bc-1269424d0a00",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[96716, 2031, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"46fe3745-d085-45f8-85ef-4dae5cf5d16a"],
Cell[97355, 2052, 50676, 859, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d3b42497-f30e-4842-b2b0-ffabcf28f375"]
}, Closed]],
Cell[CellGroupData[{
Cell[148068, 2916, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"51453f7b-9f9c-485c-afbc-18406075b175"],
Cell[148637, 2936, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1465c2f9-c8a9-4c81-a1e9-9cd2a5564a37",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[149499, 2968, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0389fcfc-4697-4365-b220-d1aa8ac36e0c"],
Cell[149786, 2979, 454, 11, 70, "Exercise", "ExpressionUUID" -> \
"c2113015-f44f-491f-887b-3164ebe6a3b2",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[150265, 2994, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3b6aeea4-985f-40ae-be47-84acd68e93e8"],
Cell[150904, 3015, 33877, 584, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4510def6-9b49-4fa4-8f77-357125e3d108"]
}, Closed]],
Cell[CellGroupData[{
Cell[184818, 3604, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"56787df1-e4d8-4371-bc50-b70aa1b313e1"],
Cell[185387, 3624, 813, 26, 70, "Input", "ExpressionUUID" -> \
"17aa8d4f-03a9-4e95-b30c-69fd4ed69be9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[186249, 3656, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b60dc39c-b873-4ceb-9919-af57112ef1ac"],
Cell[186536, 3667, 453, 11, 70, "Exercise", "ExpressionUUID" -> \
"c0a005b3-cead-4cc0-b278-f5ccf1c106cd",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[187014, 3682, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0638fd34-f38d-416e-8de3-a9b3df32ec05"],
Cell[187653, 3703, 38537, 660, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1c10c36b-1b20-47c4-8565-b9aaab25444a"]
}, Closed]],
Cell[CellGroupData[{
Cell[226227, 4368, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"48e32f26-ce3e-48a1-acc3-2b0a15e0c9cb"],
Cell[226797, 4388, 813, 26, 70, "Input", "ExpressionUUID" -> \
"54a437c0-35cf-4849-8ae1-792b9e1f448e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[227659, 4420, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a982ef44-abb4-4809-9ba1-b2ff69eb269c"],
Cell[227946, 4431, 462, 11, 70, "Exercise", "ExpressionUUID" -> \
"bfc3bcee-e5ce-41b4-9728-6a42c7ae96aa",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[228433, 4446, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"693f9800-ec26-4351-be64-be6b68ef5879"],
Cell[229072, 4467, 11193, 212, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1d1b4763-5a84-4a0d-aeae-03eb07a48e21"]
}, Closed]],
Cell[CellGroupData[{
Cell[240302, 4684, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"9e77f844-29b5-412e-9195-2279d0559469"],
Cell[240872, 4704, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a92b07e6-c701-43ea-ae7f-d20050a00743",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[241734, 4736, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f91af1b3-9a74-494e-920b-7f32bcc0b64b"],
Cell[242021, 4747, 474, 12, 70, "Exercise", "ExpressionUUID" -> \
"21a83cab-063e-437c-b677-0a08e7fd8c8d",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[242520, 4763, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"2a78c927-842e-4a4b-90cf-7807f0f8b680"],
Cell[243159, 4784, 40595, 694, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2e4e61bb-19b4-44ca-acfa-3868da212140"]
}, Closed]],
Cell[CellGroupData[{
Cell[283791, 5483, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"99bf907d-0901-47cb-b3cf-64729fdde725"],
Cell[284361, 5503, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e905f235-606b-4425-a48a-2e65ce44df90",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[285223, 5535, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b78c0626-e9bc-4f46-be0b-f911f043cc9d"],
Cell[285510, 5546, 684, 18, 70, "Exercise", "ExpressionUUID" -> \
"39937900-c55e-4b41-8c56-7a02df2713c7",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[286219, 5568, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"370258c5-9c7d-44a2-80d6-a9e4aa138e8b"],
Cell[286858, 5589, 31482, 545, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5d4fdd85-f694-4862-8166-669441f20389"]
}, Closed]],
Cell[CellGroupData[{
Cell[318377, 6139, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b201fce8-700b-4167-906b-0b6a0e25c648"],
Cell[318947, 6159, 813, 26, 70, "Input", "ExpressionUUID" -> \
"85718867-a6dc-465a-a50d-869e6742e9d8",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[319809, 6191, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f083cb69-9eec-4f79-8227-d5fef6f3395b"],
Cell[320096, 6202, 617, 16, 70, "Exercise", "ExpressionUUID" -> \
"41c50b51-0f6b-4d04-9e47-554846ea15ac",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[320738, 6222, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1614f99a-dd67-4246-8563-36bad18f4177"],
Cell[321377, 6243, 4834, 108, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2ca3150e-a153-4dd9-98ac-0af89ab8fe56"]
}, Closed]],
Cell[CellGroupData[{
Cell[326248, 6356, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a6b88aea-9b51-46d1-96c8-fcbb88792da9"],
Cell[326818, 6376, 813, 26, 70, "Input", "ExpressionUUID" -> \
"cf8c3790-1956-4539-af48-6b4118b6d4a8",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[327680, 6408, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"621e21c6-059d-4c52-8414-9d9726d810f2"],
Cell[327967, 6419, 442, 9, 70, "Exercise", "ExpressionUUID" -> \
"1e1028a7-6afa-4836-b20f-4e0d5f942d42",
 CounterAssignments->{{"SectionNumber", 4}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[328434, 6432, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4e92666d-7ea9-44c0-8dce-64fa5667f515"],
Cell[329073, 6453, 5850, 124, 70, "ExerciseOutput", "ExpressionUUID" -> \
"863e3df8-c8d0-45eb-9a25-54af66ac69c0"]
}, Closed]],
Cell[CellGroupData[{
Cell[334960, 6582, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b1d2507d-059a-4e6b-82cf-dce762a22cb1"],
Cell[335530, 6602, 813, 26, 70, "Input", "ExpressionUUID" -> \
"727e5973-2fb2-456b-ada9-b5ebca8487ab",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[336370, 6632, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> 
 "fac2e570-c309-40bf-959b-fa3b954c64c3"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ATWR2uijDXx5RkIerUQS8un5 *)
