(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    197471,       5040]
NotebookOptionsPosition[    122314,       3449]
NotebookOutlinePosition[    182617,       4688]
CellTagsIndexPosition[    182538,       4683]
WindowTitle->Starting Out: Elementary Arithmetic: Elementary Introduction to \
the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Compute 1+2+3.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"bf6a1fa4-ce20-4c7e-a52d-10e0ea9a610e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f4e83c22-e1bc-4b8e-9dc6-f24f43d15d6b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+TzPw+92DQ9s3rt64/fqr7xCRT9eXMiCBpdeB4u8mOgKZlXdA
St6t7pwBFPv9dCNQqPPEJ2TTPp2dyMDgf+j69e3z589fuv36u98gwUszIEal
VTbF6AFpx72voIKr7/wG67tTANQ2/9J3kKDeoXdQw2boMehNPPv//9MmoNKY
GddfvTq7uhLInH8dZOnvp3tjYI6sXHoW2U+f3r379P037QINAATtSO8=
            "], {{0, 
            19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cfa93dd6-6cd5-4bf7-bba1-e3901c69b855"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+TzPw+92DQ9s3rt64/fqr7xCRT9eXMiCBpdeB4u8mOgKZlXdA
St6t7pwBFPv9dCNQqPPEJ2TTPp2dyMDgf+j69e3z589fuv36u98gwUszIEal
VTbF6AFpx72voIKr7/wG67tTANQ2/9J3kKDeoXdQw2boMehNPPv//9MmoNKY
GddfvTq7uhLInH8dZOnvp3tjYI6sXHoW2U+f3r379P037QINAATtSO8=
              "], {{
              0, 19}, {7, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c71ba5a1-1dbe-48d3-804e-945aef7b53ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.1"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"85de37bb-b65e-472c-b802-5a1a3e54a631"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d4a30d61-1d74-42a2-9f15-e5524deb0d71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3641b224-2dc9-46fd-abf8-0951e5c71d44"],

Cell["Add the numbers 1, 2, 3, 4, 5.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"0ec17ff6-2b0a-4612-9703-b5b26ff5aa8c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"14287ed4-875b-44b5-9bd3-995416e03336"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVkC1vwzAQQE8bGZom7RfsDwyPBg5Z6jQW0mppNZJZ6aQpNKwwLCwoyCho
KCQoJMTEJCAkJKDAAwYG2eWrSaV1uH3SWb7Tk+98D6uPxfoKALY3eCyWX4bj
LN2XO0xe7e37xrbenu1Pa2M5T6trLN5j3GK09+bCkAXnpdTz9ICoZF8tmAsd
u2w/iCo3YMYu68tlEnmUYCHIB1NXMYCR1rrRPfPuAlV/NGXuAxB+JIx07SaT
B9ji0aSUugHL5GlTFcwA4rM4DrsvrJk6Yc4pY4ozT+9q3s7Jh1yracQ68UZT
tatLQ2ziRqngvPoRJoDpf5d1XWRRuy4SdmJO4AicQSTBtE/icdn8i5ZyL9Wf
mzprfgGqPKm0
            "], {{0, 19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bafce36f-de01-49ea-8d82-8e086c2826f9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVkC1vwzAQQE8bGZom7RfsDwyPBg5Z6jQW0mppNZJZ6aQpNKwwLCwoyCho
KCQoJMTEJCAkJKDAAwYG2eWrSaV1uH3SWb7Tk+98D6uPxfoKALY3eCyWX4bj
LN2XO0xe7e37xrbenu1Pa2M5T6trLN5j3GK09+bCkAXnpdTz9ICoZF8tmAsd
u2w/iCo3YMYu68tlEnmUYCHIB1NXMYCR1rrRPfPuAlV/NGXuAxB+JIx07SaT
B9ji0aSUugHL5GlTFcwA4rM4DrsvrJk6Yc4pY4ozT+9q3s7Jh1yracQ68UZT
tatLQ2ziRqngvPoRJoDpf5d1XWRRuy4SdmJO4AicQSTBtE/icdn8i5ZyL9Wf
mzprfgGqPKm0
              "], {{0, 19}, {14, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e163c7a5-40e1-4cfb-b10f-ccba5d36c329"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.2"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"114048fc-e1a5-4d4e-8934-88d9ffa08da8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b42f8c78-dbd6-4e65-99a4-b22a3cbeac87"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"38892c66-2ccb-445d-a7f9-ea1d78d8add6"],

Cell["Multiply the numbers 1, 2, 3, 4, 5.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"eee1e61b-3fe7-4b1b-a21a-5df8b923b3fe"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"152d01ea-98b2-4499-b0ec-d0220b90c6bd"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUiFvg0AUvmxmcsmyH7A/gJ5FTpF0mZtps9LMdE27ZMHiKnHnUCjUKRQG
hTnzTM0JsgRTgTiDQLD3OEqp6ZbJZV9y5L2X+977vnvczd4m7gVjbHOFn8n0
w16vp97jNSZPy83rYjl/eVi+zxfz9f3sEos3eG7xUNz+o9UKoNDNkFcFJHEc
i7SojsW22WdJHMUCynqoqdhjHbZ5ZSoydCm3rK5sp6XpUGxtdoAlVN+hSCN/
5WCJS0OvQ5s5XHYi8mfkBxSXKU2JFbYqKHLFSNYO+UFPbxtdHcTpoKc3YoUR
1+Z2hF3d3eCglvaIPkLpo1Cia271Mug6cOyV62/oEOIUKyHvmttHuu7o8iy9
TLdo0RPKMM5Nb4C8w5DjexLXDWG4kZD30NhVkUve6e1q3DhkIQ2Ksh3QSpXw
u+2sMgAp8zwHXH4nmPkC9iolS35mZDvsBIH85PZp6aCz/x8QTlCM1vZz1Lqq
Kv0r6l/DF7V66Qk=
            "], {{0, 19}, {21, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{21, 19},
          PlotRange->{{0, 21}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{25, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e80328e3-f445-4615-96a0-93b1f87767f5"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUiFvg0AUvmxmcsmyH7A/gJ5FTpF0mZtps9LMdE27ZMHiKnHnUCjUKRQG
hTnzTM0JsgRTgTiDQLD3OEqp6ZbJZV9y5L2X+977vnvczd4m7gVjbHOFn8n0
w16vp97jNSZPy83rYjl/eVi+zxfz9f3sEos3eG7xUNz+o9UKoNDNkFcFJHEc
i7SojsW22WdJHMUCynqoqdhjHbZ5ZSoydCm3rK5sp6XpUGxtdoAlVN+hSCN/
5WCJS0OvQ5s5XHYi8mfkBxSXKU2JFbYqKHLFSNYO+UFPbxtdHcTpoKc3YoUR
1+Z2hF3d3eCglvaIPkLpo1Cia271Mug6cOyV62/oEOIUKyHvmttHuu7o8iy9
TLdo0RPKMM5Nb4C8w5DjexLXDWG4kZD30NhVkUve6e1q3DhkIQ2Ksh3QSpXw
u+2sMgAp8zwHXH4nmPkC9iolS35mZDvsBIH85PZp6aCz/x8QTlCM1vZz1Lqq
Kv0r6l/DF7V66Qk=
              "], {{0, 19}, {21, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {21, 19}, 
            PlotRange -> {{0, 21}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a7445e3d-377a-49b7-af33-cb1b9bf3ffae"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.3"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0a177789-8cba-4e87-8f4e-d09a6ef13638"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9313d285-6aef-471d-94c5-ac3f11b6318e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1b668447-7c2b-449a-8de2-a63125ce1b04"],

Cell["Compute 5 squared (i.e. 5\[Times]5 or 5 raised to the power 2).", \
"Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"af054dbf-2eb2-43e8-a9be-b490434e8939"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d0a6200c-ddb3-4157-888e-d2d97b590845"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVUKFuhEAQnbSmqmnSL+gPVNciq0iuqcPcpXCpoeSuSYPFIXG4U6hVqFOY
qjFrtgKDwGBWINasQNDZ4wJHm/PtS2Yz+/J25u27W70tvAsA2F7RsVh+WJvN
Mny6ocuzv31d++7Lo//urt3Nw+qSyFuqayrT9/8IqsF9zliOpRypSkwoG0VU
K9g9GAxnwEoj1NyCE8RIXJU51DWHOZlnWJrbNTmA9Sm7vhtwXNSqY9diTAJU
veIJgC26s355Qjsjmq9Eavw4QRCEKUM1l3U1bQQvMz51xSywE5bnu9D49Jge
dS2SXXCyH88JdR4Mlgwkmq9YyZhRpyeLsogGpW4K55BEWnDBOSJW8osYJ9nX
UlaYmbjsHY0UqQ1zxCjLIp3ytCPx29P8i4ry0+eT+qv4BnpRmFU=
            "], {{0, 
            19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "57c87e92-e60b-4158-975d-64813982cbb3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVUKFuhEAQnbSmqmnSL+gPVNciq0iuqcPcpXCpoeSuSYPFIXG4U6hVqFOY
qjFrtgKDwGBWINasQNDZ4wJHm/PtS2Yz+/J25u27W70tvAsA2F7RsVh+WJvN
Mny6ocuzv31d++7Lo//urt3Nw+qSyFuqayrT9/8IqsF9zliOpRypSkwoG0VU
K9g9GAxnwEoj1NyCE8RIXJU51DWHOZlnWJrbNTmA9Sm7vhtwXNSqY9diTAJU
veIJgC26s355Qjsjmq9Eavw4QRCEKUM1l3U1bQQvMz51xSywE5bnu9D49Jge
dS2SXXCyH88JdR4Mlgwkmq9YyZhRpyeLsogGpW4K55BEWnDBOSJW8osYJ9nX
UlaYmbjsHY0UqQ1zxCjLIp3ytCPx29P8i4ry0+eT+qv4BnpRmFU=
              "], {{0, 
              19}, {14, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6cdbada1-0619-449a-976f-e6222e0dfec3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.4"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8484d33f-e9d9-46a0-a847-b63ea05892a0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"eba0f79b-5c05-4514-bba7-27c9d4782ffc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8c1c4b99-625f-4b3f-a2ef-271e36aaacb9"],

Cell["Compute 3 raised to the fourth power.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"abbaff41-5959-4efd-87d9-7cd9a2f1f0ee"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"606ac3b8-ece2-4c2d-b3f8-6bbf7a9ababa"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVkSFvhDAUx5vNnFqW7BPsC6BnkVMkt8zN3GX0MsMIt2TB4pA4XBXqVNUp
TFUNpqYGgcGcqKipqGAPkgK7b3AvafPe//34v9I+77+3+A4hdNzAtt39+kmy
S98eoXiPjl+HKPx8jX7CQ5i87O9BfIL1AGvMh5uKXnB6Op25NCvRqk6IVi+C
qXMffs0Pxh3FdIINjacSeXxGNQcpq3tIFS9cy9QkT7GHUNAsZANkytQ0T/gr
EysJjFrI4UI+wAnXsuMEw0eddR6i/E8OHY2Ri6BqZ/2KNOMIVImL1W2VBpBT
Z3pFSgLdzFUqh17ROJOJdBfX1xn45FRoY1pWjjkH/14IySo4lUdYI2Q/jbGs
xPM5ccnseB8FWodXqOU9jFZKr1/oZuMP9jmcBg==
            "], {{0, 19}, {14, 0}}, {
            0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ca791397-56d0-45c4-ac35-4c9cb6c1152e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVkSFvhDAUx5vNnFqW7BPsC6BnkVMkt8zN3GX0MsMIt2TB4pA4XBXqVNUp
TFUNpqYGgcGcqKipqGAPkgK7b3AvafPe//34v9I+77+3+A4hdNzAtt39+kmy
S98eoXiPjl+HKPx8jX7CQ5i87O9BfIL1AGvMh5uKXnB6Op25NCvRqk6IVi+C
qXMffs0Pxh3FdIINjacSeXxGNQcpq3tIFS9cy9QkT7GHUNAsZANkytQ0T/gr
EysJjFrI4UI+wAnXsuMEw0eddR6i/E8OHY2Ri6BqZ/2KNOMIVImL1W2VBpBT
Z3pFSgLdzFUqh17ROJOJdBfX1xn45FRoY1pWjjkH/14IySo4lUdYI2Q/jbGs
xPM5ccnseB8FWodXqOU9jFZKr1/oZuMP9jmcBg==
              "], {{0, 19}, {14, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"67abc8f9-176f-458d-b64b-908e9aaaa190"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.5"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e397bd7e-269e-4532-9c87-e474915107d6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a6df4ff3-85b3-49ee-829c-07d7901371f5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"13ed0dc1-698e-43af-8eb4-cc4f74aa6125"],

Cell["Compute 10 raised to the power 12 (a trillion).", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"841dc895-8834-42b2-9ac2-a11d97fbc5f0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"01c818a4-50cb-4ef5-a543-59bf148f25c2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVi1vwzAQtTYyOGm/YH8geNRwqFKnsZJWa6qRruomTaVlhWFhQUFBQUUh
QSEmJiEG1qQOBASYGARk52RZv1JN0yzVIC9KZL9cXp7Od5ZvRy99+wIh9HoF
j/7wHc/nw8XDNUwep6/Pk+n46X76Np6M53ejSyBv4B7CrcZlhw4dOhgEwSjl
ojh+wUkU+EFE+JYqsngNXEg38hdSk8LZbbBggSqskvxAlrgD9cJSj4FH6l+t
MGpghUyeJvUomGCDR/5y1gPKJfspEgmE91wlmDhqSGW5iVQ+Awb1xtXIDmHU
SupRMMdGmUKOnP0USepCVJRVk80aVQHhDCHsivobH5bGTmXRRupRMMdGKQk+
ShELbGi+WrgsmK0CPl0LYYfsmMeJEG2kHgVzbLSmiEBNWm4TIj0MCU5cvBUR
lQgB5RZSj4I5Nk5WkeU0FIcaXJGPPy/f/xTMsVEWVO1F9GdexaQQY8W1dBap
/Zzma9WtXt2gzLdVtxZFG6lHwQwbEk5ENPbgw4Ufp3TnOFC1LbJ9nnFPjWb8
u/zQMqQZi2A7s5ZxeYLUo2CCDUl6aA/Otv1KkQbNMQGH7Jsn1W8Ueg5v1rqV
1KJgjo2TKEQO136wFHl+yLWTehTMsdGhQ4cOZ8IXzkSqCw==
            "], {{0, 19}, {
            97, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{97, 19},
          PlotRange->{{0, 97}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{101, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7e0e269b-5ece-4ae7-ba9b-149ca6f90180"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVi1vwzAQtTYyOGm/YH8geNRwqFKnsZJWa6qRruomTaVlhWFhQUFBQUUh
QSEmJiEG1qQOBASYGARk52RZv1JN0yzVIC9KZL9cXp7Od5ZvRy99+wIh9HoF
j/7wHc/nw8XDNUwep6/Pk+n46X76Np6M53ejSyBv4B7CrcZlhw4dOhgEwSjl
ojh+wUkU+EFE+JYqsngNXEg38hdSk8LZbbBggSqskvxAlrgD9cJSj4FH6l+t
MGpghUyeJvUomGCDR/5y1gPKJfspEgmE91wlmDhqSGW5iVQ+Awb1xtXIDmHU
SupRMMdGmUKOnP0USepCVJRVk80aVQHhDCHsivobH5bGTmXRRupRMMdGKQk+
ShELbGi+WrgsmK0CPl0LYYfsmMeJEG2kHgVzbLSmiEBNWm4TIj0MCU5cvBUR
lQgB5RZSj4I5Nk5WkeU0FIcaXJGPPy/f/xTMsVEWVO1F9GdexaQQY8W1dBap
/Zzma9WtXt2gzLdVtxZFG6lHwQwbEk5ENPbgw4Ufp3TnOFC1LbJ9nnFPjWb8
u/zQMqQZi2A7s5ZxeYLUo2CCDUl6aA/Otv1KkQbNMQGH7Jsn1W8Ueg5v1rqV
1KJgjo2TKEQO136wFHl+yLWTehTMsdGhQ4cOZ8IXzkSqCw==
              "], {{0, 19}, {
              97, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {97, 19}, 
            PlotRange -> {{0, 97}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c71e5319-549a-4e4a-94f6-a9290dfe10a6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.6"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"67a8c93e-817a-48e7-9c8d-ddb92e90caff"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d289192e-e99b-4b8e-a268-a9e300dedb89"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a4bac930-fe56-4058-8290-63f8b1f75396"],

Cell["Compute 3 raised to the power 7\[Times]8.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"601eaaa0-3caa-46e1-90fc-6a0ecc6494d6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eea47330-8e4e-465e-a405-25381516edab"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWD3LpUYUlqRJGcgvyB+wTmuZ6sKGdLfZJa9Lms1lNxBsbYKlnZ2VlZBg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            "], {{0, 19}, {201, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{201, 19},
          PlotRange->{{0, 201}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{205, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "22be849c-6d57-484b-b612-dc4b9ba8bc74"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWD3LpUYUlqRJGcgvyB+wTmuZ6sKGdLfZJa9Lms1lNxBsbYKlnZ2VlZBg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              "], {{0, 19}, {201, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {201, 19}, 
            PlotRange -> {{0, 201}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5d8f6978-39cc-4683-810f-a1448cbe18dd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.7"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9f525cc8-b1c2-4ae7-be48-148ea753bcff"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f93f8b53-ac43-4e35-be89-2784516d4b12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"58d0fb16-51f1-4000-adcf-5c97930f1d04"],

Cell[TextData[{
 "Add parentheses to ",
 Cell[BoxData[
  RowBox[{"4", "-", 
   RowBox[{"2", "*", "3"}], "+", "4"}]], "InlineCode",ExpressionUUID->
  "e2556061-dfe7-4b06-afd0-6d64ec141e9d"],
 " to make 14."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"82d7b6a6-6ae0-4867-9c43-eb43164b2a83"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ca96c660-6661-4658-a67c-309b8ce577ab"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiPmAGMT+P8TApzuXLj349BtN9PerO2fPXocL31ldyQAGnSfeoSp80AQS
1jvxCcbfu7SpwB8oNOMsisqzM2LABvif/YQsfB2odCKSyt93VoMUVVY6Mvif
QFb5/awjispXnXpAaye++nTJn8ERj8pL84H2Qoy65MjgeOk3dpW/H2yEOG/i
jImdTQVAVlpl594H32HOugRy56VP4JA5O2PixBkzgMTEiZ1QlYdAKr8DQ/LS
oflAkcqlh65fuvT0O5Jdv0G2n/0NtdefAQVMRA4UkKtQfTSMAACLdq8I
            "], {{0, 
            19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "83a32eb3-d7d0-4809-921a-6a63c1dae5ce"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiPmAGMT+P8TApzuXLj349BtN9PerO2fPXocL31ldyQAGnSfeoSp80AQS
1jvxCcbfu7SpwB8oNOMsisqzM2LABvif/YQsfB2odCKSyt93VoMUVVY6Mvif
QFb5/awjispXnXpAaye++nTJn8ERj8pL84H2Qoy65MjgeOk3dpW/H2yEOG/i
jImdTQVAVlpl594H32HOugRy56VP4JA5O2PixBkzgMTEiZ1QlYdAKr8DQ/LS
oflAkcqlh65fuvT0O5Jdv0G2n/0NtdefAQVMRA4UkKtQfTSMAACLdq8I
              "], {{
              0, 19}, {14, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f42cb7d2-f412-45dc-ac10-234933c80219"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.8"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"56d8b06b-0fe5-4120-8e94-cb1ee79662fc"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7724c46f-86d4-45b0-a3d4-5ab57bdee435"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"398cbc26-2231-4127-8f46-1c78588d533d"],

Cell["Compute twenty-nine thousand multiplied by seventy-three.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "1.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"f7eeaf12-afde-40a4-881e-c002e7bb57a5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b8db7e9d-9876-461a-8205-5a74a402cd10"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVa2PnEAUn7Smskn/gv4DqIpaZNUm15xbc5cul5rtZq9Jg12HxOFQqFEo
FAY1ZsyYMSNIEyoQiDEIBH0PdvharsmKntqXQGZ+vPfm9z7m8fHxx53zhhDy
/A5edw+/7OPxwf36Hjb3++fvT/vdty/7n7un3fHz41sAP8DzCR5ctze5ySuL
LlgSUxozWa5+VkLkuplCTZULobTZlqAxEzlVz3lKI5ryfGJfZglgsSjqf4CV
oBZB6d8HKqccFHU7mHisMlgdH+zegp3Jab83HsXKDG8ebAfv25D3ZD171IxV
/RKoIrD1iu6IyEEW09zlaXQ6bAAN+MgtDT3XgcM2fEhcc5a2LTz44tBz5JrB
gZsAKTEfl6JuixTjpQqUc1w5MZqtgWBfmQJUzCPEZrqdiwRy/sit4yJD0ORL
zbbiPjhOChOGCGCb9tEWCen8xAcwDXpTiZlxZN2sgTPPHEM7Fe1cam5fcNN4
6CU3HYCqmw57RZ2xEI1y0M+fwCK2zyfkIRt6DZykIo8xl9Gs367i1iiKdcnH
a4DBWoHRqkMbcsOA/0DD+NFroPFSMWzZbXRRpSu4yXC7SDvmzfKNZQ518/jv
6/JWMrwEtr86QdpGYL+JGY9adtxmLaFD0HOTZqlmZT25MsU7JaoEWyvsTRVe
P0c2zRrY1kXaXXISpFxwzhhT1eC+xrmVQdsTN8qkwMHT6ALGVxaBLyvMuJCF
0Z7VxcSFPQaNkpd5iKtDfs45OcWiVHi0dcraF0ARbBazaRxlNV9886Ezups4
mWRjyVxywQ0OldTMLTs205p3RFE2/tCeq+B/lwbGVDX/sbS1rqoltg7e5Cav
I38BKEfCbg==
            "], {{0, 19}, {52, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{52, 19},
          PlotRange->{{0, 52}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{56, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8f07cec0-f5cd-4776-8a14-e0202357b95f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVa2PnEAUn7Smskn/gv4DqIpaZNUm15xbc5cul5rtZq9Jg12HxOFQqFEo
FAY1ZsyYMSNIEyoQiDEIBH0PdvharsmKntqXQGZ+vPfm9z7m8fHxx53zhhDy
/A5edw+/7OPxwf36Hjb3++fvT/vdty/7n7un3fHz41sAP8DzCR5ctze5ySuL
LlgSUxozWa5+VkLkuplCTZULobTZlqAxEzlVz3lKI5ryfGJfZglgsSjqf4CV
oBZB6d8HKqccFHU7mHisMlgdH+zegp3Jab83HsXKDG8ebAfv25D3ZD171IxV
/RKoIrD1iu6IyEEW09zlaXQ6bAAN+MgtDT3XgcM2fEhcc5a2LTz44tBz5JrB
gZsAKTEfl6JuixTjpQqUc1w5MZqtgWBfmQJUzCPEZrqdiwRy/sit4yJD0ORL
zbbiPjhOChOGCGCb9tEWCen8xAcwDXpTiZlxZN2sgTPPHEM7Fe1cam5fcNN4
6CU3HYCqmw57RZ2xEI1y0M+fwCK2zyfkIRt6DZykIo8xl9Gs367i1iiKdcnH
a4DBWoHRqkMbcsOA/0DD+NFroPFSMWzZbXRRpSu4yXC7SDvmzfKNZQ518/jv
6/JWMrwEtr86QdpGYL+JGY9adtxmLaFD0HOTZqlmZT25MsU7JaoEWyvsTRVe
P0c2zRrY1kXaXXISpFxwzhhT1eC+xrmVQdsTN8qkwMHT6ALGVxaBLyvMuJCF
0Z7VxcSFPQaNkpd5iKtDfs45OcWiVHi0dcraF0ARbBazaRxlNV9886Ezups4
mWRjyVxywQ0OldTMLTs205p3RFE2/tCeq+B/lwbGVDX/sbS1rqoltg7e5Cav
I38BKEfCbg==
              "], {{0, 19}, {52, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {52, 19}, 
            PlotRange -> {{0, 52}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"462c1365-a61d-41f8-91f0-c570beb71388"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["1.9"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ce6f9467-40b1-4d1f-8104-010c0328b2d3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b70c4734-5ae4-4edc-9b74-7d21350fb0ba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"992c352c-0055-40d8-9b0e-a0df867e351a"],

Cell["Add all integers from -3 to +3. ", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"d569298b-629f-4725-8d90-e6b2a19355a7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f3f3789a-4d28-40d1-be8e-e4ebbdaf77c6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+TzPw4Oze1UtX7z37AC5ydkYM0EYGPRARM/8sSOjTCUcGBv8Z
IPaJiSDmpe//v1+aAVSw9xVYz9PtQPbEs5/urE5jYOiEiP3/fScNLHgWqEVv
xieo8d/nOzI4zrgEUqk38R3MFQVAbWfffb8ONFPvEET01V6gmTMufYKYw5C2
9MGrB/NBrAKIWz9dX+3IAAGOG+/AjAfZ++kdEP6mWZD9/w8AscJMDg==
            "], {{0, 
            19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "31d5c38a-e3e0-4dad-923c-1cdbd8159c0d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+TzPw4Oze1UtX7z37AC5ydkYM0EYGPRARM/8sSOjTCUcGBv8Z
IPaJiSDmpe//v1+aAVSw9xVYz9PtQPbEs5/urE5jYOiEiP3/fScNLHgWqEVv
xieo8d/nOzI4zrgEUqk38R3MFQVAbWfffb8ONFPvEET01V6gmTMufYKYw5C2
9MGrB/NBrAKIWz9dX+3IAAGOG+/AjAfZ++kdEP6mWZD9/w8AscJMDg==
              "], {{
              0, 19}, {7, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1bb08dba-7b9d-4ec1-a30e-40b81a80fe21"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.1"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3a4758c4-98d8-4246-b449-5b6a34361da3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"757b86e8-639c-4bba-997b-cbd25a66ce2e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fa8b3075-8ea7-4247-968f-3444c78fae9b"],

Cell["Compute 24 divided by 3.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"27dc87af-9753-4f48-8b70-d1d4c8b3982e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"390001a9-4606-4af2-bdc3-69ca22d7a066"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJy1Ty0PwjAUbECAJOEX8AfQ2EnUEggOw8JKMIMMEjI7N4mbm5pCVaFmpmpm
ZmYmZmYmKmoqKsY1fPwDLnkv9+7yeq8z57SiA0LIZYy22t0s398F6wmGjXc5
Hjx3v/Su7sH1F84Q4hQ1Qhne/w1tydnj8eSV+ggqiywkWrbp5MyMLjmGMGtB
Bb8TMucSYgExyIVZ0qX1Fvsu2cKnWdXwhMJvtPEbdiZf2GltYqoEPC07Les0
sMFZo6sEJJSfS0SEM+5Fm4VwI1ZKpeo8Npx3iMxj+nuTxrn+fUkrKYRU/f/w
AiMXQ6k=
            "], {{0, 19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cae78608-1843-41ce-a6bc-1312556691cf"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJy1Ty0PwjAUbECAJOEX8AfQ2EnUEggOw8JKMIMMEjI7N4mbm5pCVaFmpmpm
ZmYmZmYmKmoqKsY1fPwDLnkv9+7yeq8z57SiA0LIZYy22t0s398F6wmGjXc5
Hjx3v/Su7sH1F84Q4hQ1Qhne/w1tydnj8eSV+ggqiywkWrbp5MyMLjmGMGtB
Bb8TMucSYgExyIVZ0qX1Fvsu2cKnWdXwhMJvtPEbdiZf2GltYqoEPC07Les0
sMFZo6sEJJSfS0SEM+5Fm4VwI1ZKpeo8Npx3iMxj+nuTxrn+fUkrKYRU/f/w
AiMXQ6k=
              "], {{0, 19}, {7, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"13def68d-4e62-44b2-9b2d-3b2e8bcbb230"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.2"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a7084216-18cf-427f-bd6d-fd2ce29db0a4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"534ab602-5dd1-42b2-abae-f203990aab01"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"89633fff-bbf6-414e-8dbe-486ae22f148b"],

Cell["Compute 5 raised to the power 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"d4a22410-c3f5-4ef1-a585-3dbc8ac4c990"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7b073e7c-ab06-4687-87bb-eeeb5cc60125"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb3r9FgVx0dtLP0XbAWntk1p48CK3TS7uLPYPA67gkw7IBKwGQtJlyo2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            "], {{0, 
            42}, {492, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{492, 42},
          PlotRange->{{0, 492}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{496, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "feebcda0-182c-4d7a-8c90-f12e7d9cc7e8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb3r9FgVx0dtLP0XbAWntk1p48CK3TS7uLPYPA67gkw7IBKwGQtJlyo2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              "], {{0, 
              42}, {492, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {492, 42}, 
            PlotRange -> {{0, 492}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6f2115ff-e294-43a7-90b8-30799152bcb0"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.3"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1f93812d-4d28-4d29-9220-539aaaf5a56a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f0585b66-6143-4518-a0b2-84287a4316fa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0cea57bf-4927-4007-849e-0f468fc98456"],

Cell["Subtract 5 squared from 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"d897d19c-fe4f-4cab-8fc0-6e2365f63822"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"01d7b526-419d-4102-8f93-ed879e68de90"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVkKFuwzAQhk8bGZom7Qn6AsWjhkOWOo2FtFpSjWRROmkKLRsMCwsKCgoK
KhkKMTEJCTAJMRgwMTDwLu2axavGu0+ydT7/d/rvZquXRXABAJsrvBbLNxLH
y+ThBh+P4eZ5HfpP9+Grv/bju9UlJm/xXOMZYvtP0FJwFyG1taqbZNpeoZKn
BFzmKbOaOdn3Zt/VGG2QoSqnAJQpa/oKgHxIY80B14dpPQCvaDFULMUSbn5b
PSDKACDo9r+KZ4MNL4qiJCsb5QoT7JLz7zG7kgBNy6rKk8FnUOpR2NeYKDpt
TxBVhJ7HvqLGWo8fhTjjqJS77VTJcFfzTE1HS2shZdcUw7poPlrlGQVyVKJ0
l/3sk265O9IJRqlPpf/Y1BnzBVJerGA=
            "], {{0, 19}, {14, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2bce3d32-19f2-48d8-a56a-cbc9a8db875a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVkKFuwzAQhk8bGZom7Qn6AsWjhkOWOo2FtFpSjWRROmkKLRsMCwsKCgoK
KhkKMTEJCTAJMRgwMTDwLu2axavGu0+ydT7/d/rvZquXRXABAJsrvBbLNxLH
y+ThBh+P4eZ5HfpP9+Grv/bju9UlJm/xXOMZYvtP0FJwFyG1taqbZNpeoZKn
BFzmKbOaOdn3Zt/VGG2QoSqnAJQpa/oKgHxIY80B14dpPQCvaDFULMUSbn5b
PSDKACDo9r+KZ4MNL4qiJCsb5QoT7JLz7zG7kgBNy6rKk8FnUOpR2NeYKDpt
TxBVhJ7HvqLGWo8fhTjjqJS77VTJcFfzTE1HS2shZdcUw7poPlrlGQVyVKJ0
l/3sk265O9IJRqlPpf/Y1BnzBVJerGA=
              "], {{0, 19}, {14, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8b134bb3-82b0-4839-b9b3-064d70a8c7f2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.4"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e432f2e3-e0fc-41b5-b5e3-6d20ad0abbfb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a53613c2-3977-4365-a7f8-e72c5c2b4253"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"312cea63-d091-4bdb-9691-9334e176d49a"],

Cell["Multiply 6 by 5 squared, and add 7.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"fe8b20b5-4b15-4fe3-a8ed-8efed848818a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"546c5309-0bda-4145-83e3-a9401a8149c1"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUaFuhEAQnbSmsknTD+gPnK5FVpFccw5zl3KXGkq4Jg0Wh8ThUKdWoVAY
FAazBoPAYBCIrUCs2M5y3LE0vX7BvWTJzmPezNuZp83HcnsDAPs7/CzXX5rj
rN3XewxW1v59Z5lvL9anuTOd580tkg94HvHIu7hCsIrSmnE1PKNsGFKtSg30
Mb0iLgzw825U94UGCvwcCwYLmGORyaqiTg+erWMcFqOcNzGAlrVc8COO7Dlo
fCy1Jf1kvkR9cJKzIgDQKRd/opN/IWkUanA7yWkozRm2bbshydl8SiGmuumM
m8v7imigBySOo2Esik9eESRIzf+Rq6hjG+dwdlBGBoDX/EriVL6djkm8n4q3
qafIWYR5bqL07uU+swgtuYespLT5LrGBESR121b5QW5Qj07N5cO1oFBt6/N1
4hPKNJz2rnt0ml2Ns5jJL4Iz1rH+wvKuEOIHj78DNg==
            "], {{0, 19}, {21, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{21, 19},
          PlotRange->{{0, 21}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{25, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ebaf46e6-232f-4f5c-8606-7ff92a2ba7bb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUaFuhEAQnbSmsknTD+gPnK5FVpFccw5zl3KXGkq4Jg0Wh8ThUKdWoVAY
FAazBoPAYBCIrUCs2M5y3LE0vX7BvWTJzmPezNuZp83HcnsDAPs7/CzXX5rj
rN3XewxW1v59Z5lvL9anuTOd580tkg94HvHIu7hCsIrSmnE1PKNsGFKtSg30
Mb0iLgzw825U94UGCvwcCwYLmGORyaqiTg+erWMcFqOcNzGAlrVc8COO7Dlo
fCy1Jf1kvkR9cJKzIgDQKRd/opN/IWkUanA7yWkozRm2bbshydl8SiGmuumM
m8v7imigBySOo2Esik9eESRIzf+Rq6hjG+dwdlBGBoDX/EriVL6djkm8n4q3
qafIWYR5bqL07uU+swgtuYespLT5LrGBESR121b5QW5Qj07N5cO1oFBt6/N1
4hPKNJz2rnt0ml2Ns5jJL4Iz1rH+wvKuEOIHj78DNg==
              "], {{0, 19}, {21, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {21, 19}, 
            PlotRange -> {{0, 21}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a175c32e-0917-419c-9d9b-00ab18bce309"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.5"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a096648a-5e43-4d3a-a3bd-f7aa744fe704"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"994e7d6b-4951-4d73-b301-c21d62202d6c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9749bf57-ccdb-4bb9-a084-476edbc2e8bc"],

Cell["Compute 3 squared minus 2 cubed. ", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"b10f9434-9208-49da-afbc-0e6caef3c81f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"074eccd8-54a5-4fbf-b637-754e452bda54"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+T0Pw6c6lSw8+/Ybz76yuZACDzhPv4IIP9i5tKvAHCs44+w5V
+3Wg6EQ0we9nHSkR/H0JZOalT3BFQBdeOjQfaHvl0kPXL116+h2k0Z8BBUw8
++k/vQAApzZj0w==
            "], {{0, 19}, {7, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{7, 19},
          PlotRange->{{0, 7}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{11, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d13ef041-eab1-42e5-bdde-d5341846e720"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiNmBGMT+T0Pw6c6lSw8+/Ybz76yuZACDzhPv4IIP9i5tKvAHCs44+w5V
+3Wg6EQ0we9nHSkR/H0JZOalT3BFQBdeOjQfaHvl0kPXL116+h2k0Z8BBUw8
++k/vQAApzZj0w==
              "], {{0, 19}, {7, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {7, 19}, 
            PlotRange -> {{0, 7}, {0, 19}}]], "ExerciseOutput", Magnification -> 
          1, CellFrameColor -> GrayLevel[0], Selectable -> False, Copyable -> 
          False, Editable -> False, ShowCellBracket -> False, CellLabel -> 
          "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7e6b7c03-bcfb-4f04-a75b-ce2e57f8a6db"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.6"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c36fd7af-88fd-4dfc-a196-fa40cce6fe53"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"cc6ced62-b5ef-47b6-ab5e-3a1ab04c4f96"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"cd9bfb75-acda-494d-9cbf-eddca9d54db3"],

Cell["Compute 2 cubed times 3 squared.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"02ebb367-4d8d-402e-a45c-414dc5520e84"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"027d2d64-b6e0-4a11-8a04-17bd48fe8e8d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzdkKFuwzAQhq2NDE2T9gR7geBRw6FIncZCWi2pRrIpnTSFlg2GhRkVBQUF
hQyZmBwpCTAxKTAwMTDILu46JekTbL/k6Pzns//z3a1eF8kFIWRzhZ/F8oNm
2TJ/vMHNU7p5Wafx80P6Hq/j7H51ieYtrmtcQ93/EdmDhKnkwaKvJTRVVdWt
1O5IQkHJVEEhBEt8FXiDtuoIO2cdajjFQkJCYSyjJCzF8FPzCNFCTPpwezSj
3X4ojbY/rinOSFlhYtK52TvU1vczBnMMZjDjgGFO0KjRedVg67vOjjHVfqKZ
190kusErIxiB0mPJWYrAWQWlOW27euvn8/YFIATnHE5D7aEMCf0ldTmfMeWm
/3/6BsmSrVs=
            "], {{0, 19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d192626b-777c-479a-a200-4112334e17f6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzdkKFuwzAQhq2NDE2T9gR7geBRw6FIncZCWi2pRrIpnTSFlg2GhRkVBQUF
hQyZmBwpCTAxKTAwMTDILu46JekTbL/k6Pzns//z3a1eF8kFIWRzhZ/F8oNm
2TJ/vMHNU7p5Wafx80P6Hq/j7H51ieYtrmtcQ93/EdmDhKnkwaKvJTRVVdWt
1O5IQkHJVEEhBEt8FXiDtuoIO2cdajjFQkJCYSyjJCzF8FPzCNFCTPpwezSj
3X4ojbY/rinOSFlhYtK52TvU1vczBnMMZjDjgGFO0KjRedVg67vOjjHVfqKZ
190kusErIxiB0mPJWYrAWQWlOW27euvn8/YFIATnHE5D7aEMCf0ldTmfMeWm
/3/6BsmSrVs=
              "], {{0, 19}, {14, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8b3dc7a6-80ae-451c-9e27-21630473e847"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.7"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"735cf37a-fc8e-49a4-a9c5-4fe12c3240e0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"81cd8968-5c11-4625-91fa-6f0aa0657dd0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"29738a35-0c09-41a8-a6e0-61277ccd89a6"],

Cell["Compute \[OpenCurlyDoubleQuote]double the sum of eight and negative \
eleven\[CloseCurlyDoubleQuote].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+1.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 8}, {
   "WebOnly", 1}},ExpressionUUID->"d902f0ee-bb90-4bc9-a3b5-68167c7d232c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"948030d9-2824-4de3-942e-b67bf9c88713"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiEGSIPb/4Q5+v3twaPvG1Ru3X3/1naDiT9eXMiCBpdfxa3k30RGoqvIO
SNW71Z0z8Cv//XQjUHXniU9EuvzT2YkMDP6Hrl/fPn/+/KXbr7/7DRL9/urO
9Tuo4CnE2k+XZkCcnVbZFKMHpB33vgIa0smADvQgToCoX30HbOz/OwVAy+Zf
+v/7+zs08Anqq+8g9XqH3kFdN0OPQW/iWbw+eNoEtCBmxvVXr86urgQy518n
4PffT/fGwFxZuRS/4QhNn0Bu/E2c4sEOAEmoMZQ=
            "], {{0, 19}, {16, 0}}, {
            0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{16, 19},
          PlotRange->{{0, 16}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{20, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f5c80672-c231-4366-909c-b720353eb320"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAYiEGSIPb/4Q5+v3twaPvG1Ru3X3/1naDiT9eXMiCBpdfxa3k30RGoqvIO
SNW71Z0z8Cv//XQjUHXniU9EuvzT2YkMDP6Hrl/fPn/+/KXbr7/7DRL9/urO
9Tuo4CnE2k+XZkCcnVbZFKMHpB33vgIa0smADvQgToCoX30HbOz/OwVAy+Zf
+v/7+zs08Anqq+8g9XqH3kFdN0OPQW/iWbw+eNoEtCBmxvVXr86urgQy518n
4PffT/fGwFxZuRS/4QhNn0Bu/E2c4sEOAEmoMZQ=
              "], {{0, 19}, {16, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {16, 19}, 
            PlotRange -> {{0, 16}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"176edb24-1a12-4cf5-b053-82d97fe2a2cd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x1.8"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"203cfb58-d0ad-4014-b337-cf643f94bb85"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"554d069a-5be8-46d7-ae32-c468571391af"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2a5b1dc3-be94-4d07-89ee-7bc3b6879349"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Starting Out: Elementary Arithmetic: Elementary Introduction to \
the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR
EWwgQQEDRkORWBHFQkCw14AEASUGo9hQyax8PokvL++9vPz+uJ/vnHvOnXvP
OXc+o5GQEZIIAwCyCOgQws5xFQrZeaEy6EO4IIufJOBxfQUiXhJPyEqAUKMP
BR0AxcefL8iAUa90gUgY4u3GjIqOYeL7AQyIAAcsAGBzsjIDQr3CJN6+nu7M
LNQJ/Ite3wKSBcF1E58gJhP8f5LlZApFAEBBKFtxeVkclAtRTssRZUrs0yjT
E1IlDGMkLEQ3iLKihJPm2fizzzy7SJibLuCiLNlzJjedK+EelDdni3koI/4o
F2XzeTko30BZO02czkf5rSQ2ncfOAgAjyY62iMdJRtlckihhWIg7ygsBIFCS
vuCEL1jEyxVJDuWekZkn5Ccli5j6HAOmhb09i+nDy0njiUQmQWxOKlvIZbpn
pGeyBXkAzJ/5s+QkuWWiSba1sLe1NbE0tfgiUf918m9KUtt5ehn8uWYQo+8P
21/5ZdQBwJpBc7PtD1vCbgA6NgKgeO8Pm/YBAKTRurUPfHEehqRfkkWiTAcz
s5ycHFM+j2MqSejv+p8Of0NfvM9Ustzv6WF68BLZ4jQRU5I3TkZahljIzMpk
c3hMkz838T8O/Ot9GIfwEnlCngCNiEC7jC9IQsst4PJF/AwBky/4T0X8h2F/
0nxfo6LVfwL0OFMgM0AHyM99AEMjAyR2HzoD/V43f2IEkNy8SPXx+b7/LOjf
V4XLJAP6Gfkc5x4SxuSIhdnzc5JrCbCABKQBHSgBNaAF9IEJsAR2wBG4AE+w
GASCMBANlgMOSAbpQAhyQD5YD4pACdgGdoJqsB/Ug0bQAo6BDnASnAMXwVVw
DdwE98EwGAPPwDR4DWYhCMJDVIgGKUHqkA5kBFlCLGgR5An5QyFQNBQPJUEC
SAzlQxugEqgcqoZqoUboW+gEdA66DA1Cd6ERaBL6FXoPIzAFpsOqsC5sBrNg
V9gPDoOXwUnwCnglXAhvhavgOvgI3A6fg6/CN+Fh+Bk8gwCEjDAQDcQEYSHu
SCASgyQiQmQNUoxUInVIC9KF9CLXkWFkCnmHwWFoGCbGBOOI8cGEYziYFZg1
mFJMNeYwph3Tg7mOGcFMYz5hqVgVrBHWAeuLjcImYXOwRdhKbAO2DXsBexM7
hn2Nw+EYOD2cHc4HF41Lwa3CleL24lpxZ3GDuFHcDB6PV8Ib4Z3wgXg2XoQv
wu/GH8GfwQ/hx/BvCWSCOsGS4EWIIQgIBYRKQhPhNGGIME6YJcoQdYgOxEAi
l5hHLCPWE7uIA8Qx4ixJlqRHciKFkVJI60lVpBbSBdID0ksymaxJticHk/nk
deQq8lHyJfII+R1FjmJIcafEUsSUrZRDlLOUu5SXVCpVl+pCjaGKqFupjdTz
1EfUt1I0KVMpXymu1FqpGql2qSGp59JEaR1pV+nl0iulK6WPSw9IT8kQZXRl
3GXYMmtkamROyNyWmZGlyVrIBsqmy5bKNslelp2Qw8vpynnKceUK5Q7KnZcb
pSE0LZo7jUPbQKunXaCN0XF0PbovPYVeQv+G3k+flpeTt5aPkM+Vr5E/JT/M
QBi6DF9GGqOMcYxxi/FeQVXBVYGnsEWhRWFI4Y3iAkUXRZ5isWKr4k3F90pM
JU+lVKXtSh1KD5UxyobKwco5yvuULyhPLaAvcFzAWVC84NiCeyqwiqFKiMoq
lYMqfSozqmqq3qqZqrtVz6tOqTHUXNRS1CrUTqtNqtPUF6nz1SvUz6g/Zcoz
XZlpzCpmD3NaQ0XDR0OsUavRrzGrqacZrlmg2ar5UIukxdJK1KrQ6taa1lbX
DtDO127WvqdD1GHpJOvs0unVeaOrpxupu0m3Q3dCT1HPV2+lXrPeA32qvrP+
Cv06/RsGOAOWQarBXoNrhrChjWGyYY3hgBFsZGvEN9prNGiMNbY3FhjXGd82
oZi4mmSbNJuMmDJM/U0LTDtMn5tpm8WYbTfrNftkbmOeZl5vft9CzmKxRYFF
l8WvloaWHMsayxtWVCsvq7VWnVYvrI2sedb7rO/Y0GwCbDbZdNt8tLWzFdq2
2E7aadvF2+2xu82is4JYpaxL9lh7N/u19ift3znYOogcjjn84mjimOrY5Dix
UG8hb2H9wlEnTSe2U63T8CLmovhFBxYNO2s4s53rnB+7aLlwXRpcxl0NXFNc
j7g+dzN3E7q1ub1xd3Bf7X7WA/Hw9ij26PeU8wz3rPZ85KXpleTV7DXtbeO9
yvusD9bHz2e7z21fVV+Ob6Pv9GK7xasX9/hR/EL9qv0e+xv6C/27AuCAxQE7
Ah4s0VkiWNIRCAJ9A3cEPgzSC1oR9H0wLjgouCb4SYhFSH5IbygtNC60KfR1
mFtYWdj9cP1wcXh3hHREbERjxJtIj8jyyOEos6jVUVejlaP50Z0x+JiImIaY
maWeS3cuHYu1iS2KvbVMb1nussvLlZenLT8VJx3Hjjsej42PjG+K/8AOZNex
ZxJ8E/YkTHPcObs4z7gu3AruJM+JV84bT3RKLE+cSHJK2pE0meycXJk8xXfn
V/NfpPik7E95kxqYeih1Li0yrTWdkB6ffkIgJ0gV9GSoZeRmDGYaZRZlDq9w
WLFzxbTQT9iQBWUty+oU0dGfqT6xvnijeCR7UXZN9tuciJzjubK5gty+PMO8
LXnjK71Wfr0Ks4qzqjtfI399/shq19W1a6A1CWu612qtLVw7ts573eH1pPWp
638oMC8oL3i1IXJDV6Fq4brC0Y3eG5uLpIqERbc3OW7avxmzmb+5f4vVlt1b
PhVzi6+UmJdUlnwo5ZRe+criq6qv5rYmbu0vsy3btw23TbDt1nbn7YfLZctX
lo/uCNjRXsGsKK54tTNu5+VK68r9u0i7xLuGq/yrOndr7962+0N1cvXNGrea
1j0qe7bsebOXu3don8u+lv2q+0v2vz/AP3Cn1ru2vU63rvIg7mD2wSf1EfW9
X7O+bmxQbihp+HhIcGj4cMjhnka7xsYmlaayZrhZ3Dx5JPbItW88vulsMWmp
bWW0lhwFR8VHn34b/+2tY37Huo+zjrd8p/PdnjZaW3E71J7XPt2R3DHcGd05
eGLxie4ux662702/P3RS42TNKflTZadJpwtPz51ZeWbmbObZqXNJ50a747rv
n486f6MnuKf/gt+FSxe9Lp7vde09c8np0snLDpdPXGFd6bhqe7W9z6av7Qeb
H9r6bfvbB+wGOq/ZX+saXDh4esh56Nx1j+sXb/jeuHpzyc3BW+G37tyOvT18
h3tn4m7a3Rf3su/N3l/3APug+KHMw8pHKo/qfjT4sXXYdvjUiMdI3+PQx/dH
OaPPfsr66cNY4RPqk8px9fHGCcuJk5Nek9eeLn069izz2exU0c+yP+95rv/8
u19cfumbjpoeeyF8Mfdr6Uull4deWb/qngmaefQ6/fXsm+K3Sm8Pv2O9630f
+X58NucD/kPVR4OPXZ/8Pj2YS5+b+w0AsgC3
                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 1  Starting Out: Elementary Arithmetic", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
01-starting-out-elementary-arithmetic.html"], None}], Evaluator -> Automatic, 
                Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+1.1", "1.1", "+1.2", "1.2", "+1.3", "1.3", "+1.4", "1.4", "+1.5", 
         "1.5", "+1.6", "1.6", "+1.7", "1.7", "+1.8", "1.8", "1.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+1.1", "1.1", "+1.2", "1.2", "+1.3", "1.3", "+1.4", "1.4", "+1.5", 
      "1.5", "+1.6", "1.6", "+1.7", "1.7", "+1.8", "1.8", "1.9"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[5722, 165, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d4a30d61-1d74-42a2-9f15-e5524deb0d71",
   CellTags->"FirstInputCell"],
  Cell[12088, 353, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b42f8c78-dbd6-4e65-99a4-b22a3cbeac87",
   CellTags->"FirstInputCell"],
  Cell[18723, 546, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9313d285-6aef-471d-94c5-ac3f11b6318e",
   CellTags->"FirstInputCell"],
  Cell[25229, 737, 813, 26, 
  70, "Input", "ExpressionUUID" -> "eba0f79b-5c05-4514-bba7-27c9d4782ffc",
   CellTags->"FirstInputCell"],
  Cell[31683, 927, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a6df4ff3-85b3-49ee-829c-07d7901371f5",
   CellTags->"FirstInputCell"],
  Cell[38652, 1125, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d289192e-e99b-4b8e-a268-a9e300dedb89",
   CellTags->"FirstInputCell"],
  Cell[48578, 1372, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f93f8b53-ac43-4e35-be89-2784516d4b12",
   CellTags->"FirstInputCell"],
  Cell[55106, 1567, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7724c46f-86d4-45b0-a3d4-5ab57bdee435",
   CellTags->"FirstInputCell"],
  Cell[62487, 1772, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b70c4734-5ae4-4edc-9b74-7d21350fb0ba",
   CellTags->"FirstInputCell"],
  Cell[68720, 1958, 813, 26, 
  70, "Input", "ExpressionUUID" -> "757b86e8-639c-4bba-997b-cbd25a66ce2e",
   CellTags->"FirstInputCell"],
  Cell[74958, 2145, 813, 26, 
  70, "Input", "ExpressionUUID" -> "534ab602-5dd1-42b2-abae-f203990aab01",
   CellTags->"FirstInputCell"],
  Cell[89372, 2465, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f0585b66-6143-4518-a0b2-84287a4316fa",
   CellTags->"FirstInputCell"],
  Cell[95803, 2655, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a53613c2-3977-4365-a7f8-e72c5c2b4253",
   CellTags->"FirstInputCell"],
  Cell[102387, 2847, 813, 26, 
  70, "Input", "ExpressionUUID" -> "994e7d6b-4951-4d73-b301-c21d62202d6c",
   CellTags->"FirstInputCell"],
  Cell[108406, 3030, 813, 26, 
  70, "Input", "ExpressionUUID" -> "cc6ced62-b5ef-47b6-ab5e-3a1ab04c4f96",
   CellTags->"FirstInputCell"],
  Cell[114788, 3219, 813, 26, 
  70, "Input", "ExpressionUUID" -> "81cd8968-5c11-4625-91fa-6f0aa0657dd0",
   CellTags->"FirstInputCell"],
  Cell[121186, 3408, 813, 26, 
  70, "Input", "ExpressionUUID" -> "554d069a-5be8-46d7-ae32-c468571391af",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 180187, 4628}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[658, 22, 397, 9, 70, "Exercise", "ExpressionUUID" -> \
"bf6a1fa4-ce20-4c7e-a52d-10e0ea9a610e",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1080, 35, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f4e83c22-e1bc-4b8e-9dc6-f24f43d15d6b"],
Cell[1719, 56, 3397, 84, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c71ba5a1-1dbe-48d3-804e-945aef7b53ac"]
}, Closed]],
Cell[CellGroupData[{
Cell[5153, 145, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"85de37bb-b65e-472c-b802-5a1a3e54a631"],
Cell[5722, 165, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d4a30d61-1d74-42a2-9f15-e5524deb0d71",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6572, 196, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3641b224-2dc9-46fd-abf8-0951e5c71d44"],
Cell[6859, 207, 413, 9, 70, "Exercise", "ExpressionUUID" -> \
"0ec17ff6-2b0a-4612-9703-b5b26ff5aa8c",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[7297, 220, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"14287ed4-875b-44b5-9bd3-995416e03336"],
Cell[7936, 241, 3546, 87, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e163c7a5-40e1-4cfb-b10f-ccba5d36c329"]
}, Closed]],
Cell[CellGroupData[{
Cell[11519, 333, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"114048fc-e1a5-4d4e-8934-88d9ffa08da8"],
Cell[12088, 353, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b42f8c78-dbd6-4e65-99a4-b22a3cbeac87",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12950, 385, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"38892c66-2ccb-445d-a7f9-ea1d78d8add6"],
Cell[13237, 396, 418, 9, 70, "Exercise", "ExpressionUUID" -> \
"eee1e61b-3fe7-4b1b-a21a-5df8b923b3fe",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[13680, 409, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"152d01ea-98b2-4499-b0ec-d0220b90c6bd"],
Cell[14319, 430, 3798, 91, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a7445e3d-377a-49b7-af33-cb1b9bf3ffae"]
}, Closed]],
Cell[CellGroupData[{
Cell[18154, 526, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"0a177789-8cba-4e87-8f4e-d09a6ef13638"],
Cell[18723, 546, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9313d285-6aef-471d-94c5-ac3f11b6318e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19585, 578, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1b668447-7c2b-449a-8de2-a63125ce1b04"],
Cell[19872, 589, 448, 10, 70, "Exercise", "ExpressionUUID" -> \
"af054dbf-2eb2-43e8-a9be-b490434e8939",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[20345, 603, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d0a6200c-ddb3-4157-888e-d2d97b590845"],
Cell[20984, 624, 3639, 88, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6cdbada1-0619-449a-976f-e6222e0dfec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[24660, 717, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"8484d33f-e9d9-46a0-a847-b63ea05892a0"],
Cell[25229, 737, 813, 26, 70, "Input", "ExpressionUUID" -> \
"eba0f79b-5c05-4514-bba7-27c9d4782ffc",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26091, 769, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"8c1c4b99-625f-4b3f-a2ef-271e36aaacb9"],
Cell[26378, 780, 420, 9, 70, "Exercise", "ExpressionUUID" -> \
"abbaff41-5959-4efd-87d9-7cd9a2f1f0ee",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[26823, 793, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"606ac3b8-ece2-4c2d-b3f8-6bbf7a9ababa"],
Cell[27462, 814, 3615, 88, 70, "ExerciseOutput", "ExpressionUUID" -> \
"67abc8f9-176f-458d-b64b-908e9aaaa190"]
}, Closed]],
Cell[CellGroupData[{
Cell[31114, 907, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"e397bd7e-269e-4532-9c87-e474915107d6"],
Cell[31683, 927, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a6df4ff3-85b3-49ee-829c-07d7901371f5",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32545, 959, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"13ed0dc1-698e-43af-8eb4-cc4f74aa6125"],
Cell[32832, 970, 430, 9, 70, "Exercise", "ExpressionUUID" -> \
"841dc895-8834-42b2-9ac2-a11d97fbc5f0",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[33287, 983, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"01c818a4-50cb-4ef5-a543-59bf148f25c2"],
Cell[33926, 1004, 4120, 96, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c71e5319-549a-4e4a-94f6-a9290dfe10a6"]
}, Closed]],
Cell[CellGroupData[{
Cell[38083, 1105, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"67a8c93e-817a-48e7-9c8d-ddb92e90caff"],
Cell[38652, 1125, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d289192e-e99b-4b8e-a268-a9e300dedb89",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39514, 1157, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a4bac930-fe56-4058-8290-63f8b1f75396"],
Cell[39801, 1168, 424, 9, 70, "Exercise", "ExpressionUUID" -> \
"601eaaa0-3caa-46e1-90fc-6a0ecc6494d6",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[40250, 1181, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"eea47330-8e4e-465e-a405-25381516edab"],
Cell[40889, 1202, 7083, 145, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5d8f6978-39cc-4683-810f-a1448cbe18dd"]
}, Closed]],
Cell[CellGroupData[{
Cell[48009, 1352, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"9f525cc8-b1c2-4ae7-be48-148ea753bcff"],
Cell[48578, 1372, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f93f8b53-ac43-4e35-be89-2784516d4b12",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49440, 1404, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"58d0fb16-51f1-4000-adcf-5c97930f1d04"],
Cell[49727, 1415, 584, 16, 70, "Exercise", "ExpressionUUID" -> \
"82d7b6a6-6ae0-4867-9c43-eb43164b2a83",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[50336, 1435, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ca96c660-6661-4658-a67c-309b8ce577ab"],
Cell[50975, 1456, 3525, 86, 70, "ExerciseOutput", "ExpressionUUID" -> \
"f42cb7d2-f412-45dc-ac10-234933c80219"]
}, Closed]],
Cell[CellGroupData[{
Cell[54537, 1547, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"56d8b06b-0fe5-4120-8e94-cb1ee79662fc"],
Cell[55106, 1567, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7724c46f-86d4-45b0-a3d4-5ab57bdee435",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55968, 1599, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"398cbc26-2231-4127-8f46-1c78588d533d"],
Cell[56255, 1610, 440, 9, 70, "Exercise", "ExpressionUUID" -> \
"f7eeaf12-afde-40a4-881e-c002e7bb57a5",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[56720, 1623, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b8db7e9d-9876-461a-8205-5a74a402cd10"],
Cell[57359, 1644, 4522, 103, 70, "ExerciseOutput", "ExpressionUUID" -> \
"462c1365-a61d-41f8-91f0-c570beb71388"]
}, Closed]],
Cell[CellGroupData[{
Cell[61918, 1752, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"ce6f9467-40b1-4d1f-8104-010c0328b2d3"],
Cell[62487, 1772, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b70c4734-5ae4-4edc-9b74-7d21350fb0ba",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63349, 1804, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"992c352c-0055-40d8-9b0e-a0df867e351a"],
Cell[63636, 1815, 416, 9, 70, "Exercise", "ExpressionUUID" -> \
"d569298b-629f-4725-8d90-e6b2a19355a7",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[64077, 1828, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f3f3789a-4d28-40d1-be8e-e4ebbdaf77c6"],
Cell[64716, 1849, 3397, 84, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1bb08dba-7b9d-4ec1-a30e-40b81a80fe21"]
}, Closed]],
Cell[CellGroupData[{
Cell[68150, 1938, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3a4758c4-98d8-4246-b449-5b6a34361da3"],
Cell[68720, 1958, 813, 26, 70, "Input", "ExpressionUUID" -> \
"757b86e8-639c-4bba-997b-cbd25a66ce2e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69582, 1990, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"fa8b3075-8ea7-4247-968f-3444c78fae9b"],
Cell[69869, 2001, 408, 9, 70, "Exercise", "ExpressionUUID" -> \
"27dc87af-9753-4f48-8b70-d1d4c8b3982e",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[70302, 2014, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"390001a9-4606-4af2-bdc3-69ca22d7a066"],
Cell[70941, 2035, 3410, 85, 70, "ExerciseOutput", "ExpressionUUID" -> \
"13def68d-4e62-44b2-9b2d-3b2e8bcbb230"]
}, Closed]],
Cell[CellGroupData[{
Cell[74388, 2125, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a7084216-18cf-427f-bd6d-fd2ce29db0a4"],
Cell[74958, 2145, 813, 26, 70, "Input", "ExpressionUUID" -> \
"534ab602-5dd1-42b2-abae-f203990aab01",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75820, 2177, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"89633fff-bbf6-414e-8dbe-486ae22f148b"],
Cell[76107, 2188, 418, 9, 70, "Exercise", "ExpressionUUID" -> \
"d4a22410-c3f5-4ef1-a585-3dbc8ac4c990",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[76550, 2201, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"7b073e7c-ab06-4687-87bb-eeeb5cc60125"],
Cell[77189, 2222, 11576, 218, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6f2115ff-e294-43a7-90b8-30799152bcb0"]
}, Closed]],
Cell[CellGroupData[{
Cell[88802, 2445, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"1f93812d-4d28-4d29-9220-539aaaf5a56a"],
Cell[89372, 2465, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f0585b66-6143-4518-a0b2-84287a4316fa",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90234, 2497, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0cea57bf-4927-4007-849e-0f468fc98456"],
Cell[90521, 2508, 412, 9, 70, "Exercise", "ExpressionUUID" -> \
"d897d19c-fe4f-4cab-8fc0-6e2365f63822",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[90958, 2521, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"01d7b526-419d-4102-8f93-ed879e68de90"],
Cell[91597, 2542, 3599, 88, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8b134bb3-82b0-4839-b9b3-064d70a8c7f2"]
}, Closed]],
Cell[CellGroupData[{
Cell[95233, 2635, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"e432f2e3-e0fc-41b5-b5e3-6d20ad0abbfb"],
Cell[95803, 2655, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a53613c2-3977-4365-a7f8-e72c5c2b4253",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96665, 2687, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"312cea63-d091-4bdb-9691-9334e176d49a"],
Cell[96952, 2698, 419, 9, 70, "Exercise", "ExpressionUUID" -> \
"fe8b20b5-4b15-4fe3-a8ed-8efed848818a",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[97396, 2711, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"546c5309-0bda-4145-83e3-a9401a8149c1"],
Cell[98035, 2732, 3745, 90, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a175c32e-0917-419c-9d9b-00ab18bce309"]
}, Closed]],
Cell[CellGroupData[{
Cell[101817, 2827, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a096648a-5e43-4d3a-a3bd-f7aa744fe704"],
Cell[102387, 2847, 813, 26, 70, "Input", "ExpressionUUID" -> \
"994e7d6b-4951-4d73-b301-c21d62202d6c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[103249, 2879, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9749bf57-ccdb-4bb9-a084-476edbc2e8bc"],
Cell[103536, 2890, 417, 9, 70, "Exercise", "ExpressionUUID" -> \
"b10f9434-9208-49da-afbc-0e6caef3c81f",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[103978, 2903, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"074eccd8-54a5-4fbf-b637-754e452bda54"],
Cell[104617, 2924, 3182, 81, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7e6b7c03-bcfb-4f04-a75b-ce2e57f8a6db"]
}, Closed]],
Cell[CellGroupData[{
Cell[107836, 3010, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"c36fd7af-88fd-4dfc-a196-fa40cce6fe53"],
Cell[108406, 3030, 813, 26, 70, "Input", "ExpressionUUID" -> \
"cc6ced62-b5ef-47b6-ab5e-3a1ab04c4f96",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[109268, 3062, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"cd9bfb75-acda-494d-9cbf-eddca9d54db3"],
Cell[109555, 3073, 416, 9, 70, "Exercise", "ExpressionUUID" -> \
"02ebb367-4d8d-402e-a45c-414dc5520e84",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[109996, 3086, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"027d2d64-b6e0-4a11-8a04-17bd48fe8e8d"],
Cell[110635, 3107, 3546, 87, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8b3dc7a6-80ae-451c-9e27-21630473e847"]
}, Closed]],
Cell[CellGroupData[{
Cell[114218, 3199, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"735cf37a-fc8e-49a4-a9c5-4fe12c3240e0"],
Cell[114788, 3219, 813, 26, 70, "Input", "ExpressionUUID" -> \
"81cd8968-5c11-4625-91fa-6f0aa0657dd0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115650, 3251, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"29738a35-0c09-41a8-a6e0-61277ccd89a6"],
Cell[115937, 3262, 485, 10, 70, "Exercise", "ExpressionUUID" -> \
"d902f0ee-bb90-4bc9-a3b5-68167c7d232c",
 CounterAssignments->{{"SectionNumber", 1}, {"ExerciseNumber", 8}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[116447, 3276, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"948030d9-2824-4de3-942e-b67bf9c88713"],
Cell[117086, 3297, 3493, 86, 70, "ExerciseOutput", "ExpressionUUID" -> \
"176edb24-1a12-4cf5-b053-82d97fe2a2cd"]
}, Closed]],
Cell[CellGroupData[{
Cell[120616, 3388, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"203cfb58-d0ad-4014-b337-cf643f94bb85"],
Cell[121186, 3408, 813, 26, 70, "Input", "ExpressionUUID" -> \
"554d069a-5be8-46d7-ae32-c468571391af",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[122026, 3438, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2a5b1dc3-be94-4d07-89ee-7bc3b6879349"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature HScgTOWIoPA8ckefq1jYigDL *)
