(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13859,        388]
NotebookOptionsPosition[     12775,        347]
NotebookOutlinePosition[     13389,        371]
CellTagsIndexPosition[     13346,        368]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Wave Packet Dispersion", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"10", "t"}], " ", "+", " ", 
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"-", "\[Sigma]"}], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"k", "-", "k0"}], ")"}], "2"]}], "]"}], 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"k", " ", "x"}], " ", "-", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"Abs", "[", "k", "]"}], "^", "\[Alpha]"}], " ", 
               "t"}]}], "]"}]}]}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"k", ",", " ", 
            RowBox[{"k0", "-", 
             RowBox[{
              RowBox[{"n", "/", "2"}], " ", "\[CapitalDelta]k"}]}], ",", " ", 
            
            RowBox[{"k0", "+", 
             RowBox[{
              RowBox[{"n", " ", "/", "2"}], "\[CapitalDelta]k"}]}], ",", 
            "\[CapitalDelta]k"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "1", ",", 
          RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "/", "2"}], "Pi"}], ",", 
       RowBox[{
        RowBox[{"3", "/", "2"}], "Pi"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "3"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", 
            RowBox[{"\"\<FallColors\>\"", ",", "\"\<ColorFunction\>\""}], 
            "]"}], "[", "t", "]"}], ",", 
          RowBox[{"Thickness", "[", ".005", "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "1", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "300"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "1.8", ",", "\"\<\[Alpha]\>\""}], "}"}], ",", 
     "0.001", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Sigma]", ",", "2", ",", "\"\<\[Sigma]\>\""}], "}"}], ",", 
     "0.001", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "k0", ",", "3", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\(k\), \(0\)]\)\>\""}], "}"}], ",", "0.001", 
     ",", " ", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]k", ",", "0.5", ",", "\"\<\[CapitalDelta]k\>\""}], 
      "}"}], ",", "0.001", ",", " ", "1"}], "}"}], ",", "\[IndentingNewLine]",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "5", ",", "\"\<n\>\""}], "}"}], ",", "1", ",", "10", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35342918504958*^9, {3.35724612689063*^9, 3.35724613114063*^9}, {
   3.35878835994347*^9, 3.35878838250583*^9}, {3.36274330057279*^9, 
   3.36274333210142*^9}, {3.36926559559375*^9, 3.36926559692188*^9}, {
   3.379463279596875*^9, 3.379463292971875*^9}, {3.379463328003125*^9, 
   3.3794633373*^9}, {3.3842549282089167`*^9, 3.3842549364418693`*^9}, {
   3.386859211921875*^9, 3.386859212421875*^9}, {3.386859244875*^9, 
   3.3868592689375*^9}},
 CellID->1496021318]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`k0$$ = 3, $CellContext`n$$ = 
    5, $CellContext`\[Alpha]$$ = 1.8, $CellContext`\[CapitalDelta]k$$ = 
    0.5, $CellContext`\[Sigma]$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Alpha]$$], 1.8, "\[Alpha]"}, 0.001, 4}, {{
       Hold[$CellContext`\[Sigma]$$], 2, "\[Sigma]"}, 0.001, 10}, {{
       Hold[$CellContext`k0$$], 3, "\!\(\*SubscriptBox[\(k\), \(0\)]\)"}, 
      0.001, 5}, {{
       Hold[$CellContext`\[CapitalDelta]k$$], 0.5, "\[CapitalDelta]k"}, 0.001,
       1}, {{
       Hold[$CellContext`n$$], 5, "n"}, 1, 10, 1}}, Typeset`size$$ = {
    500., {148., 152.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Alpha]$73522$$ = 
    0, $CellContext`\[Sigma]$73523$$ = 0, $CellContext`k0$73524$$ = 
    0, $CellContext`\[CapitalDelta]k$73525$$ = 0, $CellContext`n$73526$$ = 0},
     
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`k0$$ = 3, $CellContext`n$$ = 
        5, $CellContext`\[Alpha]$$ = 1.8, $CellContext`\[CapitalDelta]k$$ = 
        0.5, $CellContext`\[Sigma]$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`\[Alpha]$$, $CellContext`\[Alpha]$73522$$, 0], 
        Hold[$CellContext`\[Sigma]$$, $CellContext`\[Sigma]$73523$$, 0], 
        Hold[$CellContext`k0$$, $CellContext`k0$73524$$, 0], 
        Hold[$CellContext`\[CapitalDelta]k$$, \
$CellContext`\[CapitalDelta]k$73525$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$73526$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Evaluate[
         Table[
          Sum[
          10 $CellContext`t + 
           Exp[(-$CellContext`\[Sigma]$$) ($CellContext`k - \
$CellContext`k0$$)^2] 
            Cos[$CellContext`k $CellContext`x - 
              Abs[$CellContext`k]^$CellContext`\[Alpha]$$ $CellContext`t], \
{$CellContext`k, $CellContext`k0$$ - ($CellContext`n$$/
             2) $CellContext`\[CapitalDelta]k$$, $CellContext`k0$$ + \
($CellContext`n$$/
              2) $CellContext`\[CapitalDelta]k$$, \
$CellContext`\[CapitalDelta]k$$}], {$CellContext`t, 0, 1, 1/
           10}]], {$CellContext`x, ((-3)/2) Pi, (3/2) Pi}, Frame -> True, 
        Axes -> False, FrameTicks -> None, MaxRecursion -> 3, PlotStyle -> 
        Table[{
           ColorData["FallColors", "ColorFunction"][$CellContext`t], 
           Thickness[0.005]}, {$CellContext`t, 0, 1, 1/5}], 
        ImageSize -> {500, 300}], 
      "Specifications" :> {{{$CellContext`\[Alpha]$$, 1.8, "\[Alpha]"}, 0.001,
          4}, {{$CellContext`\[Sigma]$$, 2, "\[Sigma]"}, 0.001, 
         10}, {{$CellContext`k0$$, 3, "\!\(\*SubscriptBox[\(k\), \(0\)]\)"}, 
         0.001, 5}, {{$CellContext`\[CapitalDelta]k$$, 0.5, 
          "\[CapitalDelta]k"}, 0.001, 1}, {{$CellContext`n$$, 5, "n"}, 1, 10, 
         1}}, "Options" :> {AutorunSequencing -> {1, 2, 3}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{544., {245., 250.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->252930357],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Wave Packet Dispersion",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/WavePacketDispersion/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/WavePacketDispersion/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/WavePacketDispersion/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/WavePacketDispersion/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/WavePacketDispersion/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Michael Trott",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Michael+Trott"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Michael+Trott"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->171491753],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
WavePacketDispersion"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Wave Packet Dispersion - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 214, 4, 70, "Section"],
Cell[807, 29, 4000, 108, 70, "Input",
 CellID->1496021318]
}, Open  ]],
Cell[4822, 140, 3773, 73, 70, "Output",
 CellID->252930357],
Cell[CellGroupData[{
Cell[8620, 217, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[8996, 228, 899, 24, 70, "Text"],
Cell[9898, 254, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[10238, 265, 456, 15, 70, "Text",
 CellID->171491753],
Cell[CellGroupData[{
Cell[10719, 284, 829, 24, 70, "Text"],
Cell[11551, 310, 1196, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature mTzr7SHMVbmFcDThpMQHOuu6 *)
