(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49345,       1048]
NotebookOptionsPosition[     48246,       1008]
NotebookOutlinePosition[     48889,       1032]
CellTagsIndexPosition[     48846,       1029]
WindowTitle->Superposition of Two Sine Waves with Sum and Beats - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Superposition of Two Sine Waves with Sum and Beats", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f1", "=", 
     RowBox[{"freq1", "/", "440"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"f2", "=", 
     RowBox[{"freq2", "/", "440"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"showW", ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"f1", " ", "x"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showW", ",", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"f2", " ", "x"}], " ", "+", " ", "p"}], "]"}], "a2"}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showS", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"f2", " ", "x"}], " ", "+", " ", "p"}], "]"}], "a2"}], 
           "+", 
           RowBox[{"Sin", "[", 
            RowBox[{"f1", " ", "x"}], "]"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showB", ",", 
          RowBox[{"1", "-", "a2", "+", 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"f2", "-", "f1"}], ")"}], "/", "2"}], " ", "x"}], 
               " ", "+", " ", 
               RowBox[{"p", "/", "2"}]}], "]"}], " ", "2", " ", "a2"}], 
            "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showB", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "a2", "-", 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"f2", "-", "f1"}], ")"}], "/", "2"}], " ", "x"}], 
               " ", "+", " ", 
               RowBox[{"p", "/", "2"}]}], "]"}], " ", "2", " ", "a2"}], 
            "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLabel", " ", "\[Rule]", " ", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<frequency of beats = \>\"", ",", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"f2", "-", "f1"}], "]"}], " ", "440"}], "]"}], ",", 
         "\"\< Hz.\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"AspectRatio", "\[Rule]", " ", ".6"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"\[Pi]", "/", "2"}], ",", "\[Pi]", ",", 
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{"2", "Pi"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", " ", "2"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Filling", " ", "\[Rule]", " ", 
       RowBox[{"If", "[", 
        RowBox[{"fill", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", "\[Rule]", 
             RowBox[{"{", "2", "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", " ", "\[Rule]", " ", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", "\[Rule]", 
             RowBox[{"{", "5", "}"}]}], "}"}]}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
        "Blue", ",", " ", "Purple", ",", " ", "Black", ",", " ", "Gray", ",", 
         " ", "Gray"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", "580"}]}], "\[IndentingNewLine]", 
     "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Row", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"freq1", ",", "440", ",", "\"\<frequency 1\>\""}], 
              "}"}], ",", "440", ",", 
             RowBox[{"30", " ", "440"}], ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"freq2", ",", "440", ",", "\"\<frequency 2\>\""}], 
              "}"}], ",", "440", ",", 
             RowBox[{"30", " ", "440"}], ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a2", ",", "1", ",", "\"\<amplitude 2\>\""}], "}"}], 
             ",", "0", ",", "1", ",", " ", "0.01", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Control", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"p", ",", "0", ",", "\"\<\>\""}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"\[Pi]", "/", "2"}], ",", " ", "\[Pi]", ",", 
                  RowBox[{"3", " ", 
                   RowBox[{"\[Pi]", "/", "2"}]}], ",", " ", 
                  RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Control", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"p", ",", "1", ",", "\"\< <-> phase 2\>\""}], "}"}], 
                ",", "0", ",", 
                RowBox[{"2", " ", "\[Pi]"}], ",", 
                RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                " ", 
                RowBox[{"ImageSize", " ", "\[Rule]", " ", "Small"}]}], "}"}], 
              "]"}]}], "\[IndentingNewLine]", "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", " ", "Right"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "showW", ",", "True", ",", "\"\<show waves 1 and 2\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "fill", ",", "True", ",", 
               "\"\<show filling: waves 1 \[Rule] 2, sum and beats\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "showS", ",", "True", ",", 
               "\"\<show sum (wave 1 + wave 2)\>\""}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"showB", ",", "True", ",", "\"\<show beats\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Button", "[", 
              RowBox[{"\"\<A\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<B\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<C\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<D\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", ".5"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<E\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "\[Pi]"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<F\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<G\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<H\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<I\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<J\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.5"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<K\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<L\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<M\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<N\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<O\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}]}], "\[IndentingNewLine]", "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", " ", "Right"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{
  3.454897982*^9, {3.455454103234375*^9, 3.4554541155625*^9}, {
   3.455454163578125*^9, 3.455454295859375*^9}, {3.455454493921875*^9, 
   3.455454520953125*^9}, {3.45545457984375*^9, 3.455454607546875*^9}, {
   3.455454659328125*^9, 3.455455147109375*^9}, {3.455455287015625*^9, 
   3.455455321171875*^9}, {3.45545535890625*^9, 3.455455385703125*^9}, {
   3.455455424203125*^9, 3.4554554315*^9}, {3.45545546659375*^9, 
   3.455455480140625*^9}, {3.455455546453125*^9, 3.455455548546875*^9}, {
   3.455455581734375*^9, 3.455455611*^9}, {3.455455754609375*^9, 
   3.4554557948125*^9}, {3.455455849265625*^9, 3.455455854515625*^9}, {
   3.45545591953125*^9, 3.455455943578125*^9}, {3.4554559828125*^9, 
   3.45545602625*^9}, {3.4554561195*^9, 3.455456199921875*^9}, {
   3.455456276484375*^9, 3.455456359671875*^9}, {3.45545642628125*^9, 
   3.45545644703125*^9}, {3.45545657075*^9, 3.45545662803125*^9}, {
   3.4554566675625*^9, 3.455456676*^9}, {3.455456706296875*^9, 
   3.4554567275*^9}, {3.455456959421875*^9, 3.455457014640625*^9}, {
   3.455457079625*^9, 3.455457081453125*^9}, {3.455457188375*^9, 
   3.455457258859375*^9}, {3.455457431703125*^9, 3.455457447578125*^9}, {
   3.45545749434375*^9, 3.455457586390625*^9}, {3.455502117890625*^9, 
   3.45550212040625*^9}, {3.4555027640625*^9, 3.455502764796875*^9}, {
   3.455502797671875*^9, 3.455502823421875*^9}, {3.455502857796875*^9, 
   3.45550287*^9}, {3.455502932078125*^9, 3.45550300628125*^9}, 
   3.45550305234375*^9, {3.4555031345*^9, 3.45550321090625*^9}, {
   3.4555032678125*^9, 3.4555032821875*^9}, {3.455503444140625*^9, 
   3.4555034594375*^9}, {3.455503591828125*^9, 3.45550363275*^9}, {
   3.45550366621875*^9, 3.45550378984375*^9}, {3.455503873109375*^9, 
   3.4555038948125*^9}, {3.455503987015625*^9, 3.45550399221875*^9}, {
   3.455504077484375*^9, 3.4555040816875*^9}, {3.455504249765625*^9, 
   3.455504290453125*^9}, {3.455504327875*^9, 3.4555043525625*^9}, {
   3.45550439078125*^9, 3.45550445284375*^9}, {3.45550454234375*^9, 
   3.4555045835625*^9}, {3.4555046311875*^9, 3.455504706390625*^9}, 
   3.455504738953125*^9, {3.455504771828125*^9, 3.455504873734375*^9}, {
   3.45550903675*^9, 3.455509122046875*^9}, {3.455509175484375*^9, 
   3.455509185625*^9}, {3.455509314171875*^9, 3.45550934096875*^9}, {
   3.455509565375*^9, 3.455509602484375*^9}, {3.4555096571875*^9, 
   3.455509660671875*^9}, 3.455509694953125*^9, {3.45550984753125*^9, 
   3.45550985084375*^9}, {3.4555523355615597`*^9, 3.455552403197323*^9}, 
   3.455552528513853*^9, {3.455552731059106*^9, 3.455552736656666*^9}, 
   3.4558088014134016`*^9, {3.455852777140625*^9, 3.45585282040625*^9}, 
   3.455889127317867*^9, {3.455889191411617*^9, 3.455889212286617*^9}, {
   3.455889245474117*^9, 3.455889278567867*^9}, {3.455890556442867*^9, 
   3.455890556786617*^9}, {3.455890599114742*^9, 3.455890634270992*^9}, {
   3.455890723724117*^9, 3.455890808161617*^9}, 3.455890859849117*^9, {
   3.455891359224117*^9, 3.455891377880367*^9}, 3.4559121809071817`*^9, {
   3.4559125926571817`*^9, 3.4559126115634317`*^9}, 3.455968434470934*^9, {
   3.4560749191045113`*^9, 3.4560749630619063`*^9}},
 CellID->39540832]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1, $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
    440, $CellContext`p$$ = 0, $CellContext`showB$$ = 
    True, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 440, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 440, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], True, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    580., {185., 188.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`freq1$955725$$ = 
    0, $CellContext`freq2$955726$$ = 0, $CellContext`a2$955727$$ = 
    0, $CellContext`p$955728$$ = 0, $CellContext`showW$955729$$ = 
    False, $CellContext`fill$955730$$ = False, $CellContext`showS$955731$$ = 
    False, $CellContext`showB$955732$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1, $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
        440, $CellContext`p$$ = 0, $CellContext`showB$$ = 
        True, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$955725$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$955726$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$955727$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$955728$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$955729$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$955730$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$955731$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$955732$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 440, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 440, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, True, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{625., {273., 278.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->355932188],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Superposition of Two Sine Waves with Sum and Beats",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
SuperpositionOfTwoSineWavesWithSumAndBeats/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
SuperpositionOfTwoSineWavesWithSumAndBeats/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
SuperpositionOfTwoSineWavesWithSumAndBeats/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
SuperpositionOfTwoSineWavesWithSumAndBeats/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
SuperpositionOfTwoSineWavesWithSumAndBeats/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Arthur Stammet",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Arthur+Stammet"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Arthur+Stammet"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
SuperpositionOfTwoSineWavesWithSumAndBeats"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Superposition of Two Sine Waves with Sum and Beats - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[640, 23, 242, 4, 70, "Section"],
Cell[885, 29, 25267, 519, 70, "Input",
 CellID->39540832]
}, Open  ]],
Cell[26167, 551, 17723, 317, 70, "Output",
 CellID->355932188],
Cell[CellGroupData[{
Cell[43915, 872, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[44291, 883, 1055, 31, 70, "Text"],
Cell[45349, 916, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[45689, 927, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[46150, 945, 847, 24, 70, "Text"],
Cell[47000, 971, 1218, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature TQ4YEXzkezE#yD0GjVddACOt *)
