(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    180871,       3491]
NotebookOptionsPosition[    176664,       3364]
NotebookOutlinePosition[    178284,       3414]
CellTagsIndexPosition[    177948,       3402]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Superposition of Two Sine Waves with Sum and Beats", "DemoTitle",
 CellChangeTimes->{
  3.35696210375764*^9, {3.454848173375*^9, 3.4548481915*^9}, {
   3.455888670411617*^9, 3.455888671099117*^9}, 3.455891347505367*^9}],

Cell["", "InitializationSection"],

Cell[CellGroupData[{

Cell["", "ManipulateSection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f1", "=", 
     RowBox[{"freq1", "/", "440"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"f2", "=", 
     RowBox[{"freq2", "/", "440"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{"showW", ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"f1", " ", "x"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showW", ",", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"f2", " ", "x"}], " ", "+", " ", "p"}], "]"}], "a2"}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showS", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"f2", " ", "x"}], " ", "+", " ", "p"}], "]"}], "a2"}], 
           "+", 
           RowBox[{"Sin", "[", 
            RowBox[{"f1", " ", "x"}], "]"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showB", ",", 
          RowBox[{"1", "-", "a2", "+", 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"f2", "-", "f1"}], ")"}], "/", "2"}], " ", "x"}], 
               " ", "+", " ", 
               RowBox[{"p", "/", "2"}]}], "]"}], " ", "2", " ", "a2"}], 
            "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"showB", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "a2", "-", 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"f2", "-", "f1"}], ")"}], "/", "2"}], " ", "x"}], 
               " ", "+", " ", 
               RowBox[{"p", "/", "2"}]}], "]"}], " ", "2", " ", "a2"}], 
            "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLabel", " ", "\[Rule]", " ", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<frequency of beats = \>\"", ",", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"f2", "-", "f1"}], "]"}], " ", "440"}], "]"}], ",", 
         "\"\< Hz.\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", " ", ".6"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"\[Pi]", "/", "2"}], ",", "\[Pi]", ",", 
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{"2", "Pi"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", " ", "2"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Filling", " ", "\[Rule]", " ", 
       RowBox[{"If", "[", 
        RowBox[{"fill", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", "\[Rule]", 
             RowBox[{"{", "2", "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", " ", "\[Rule]", " ", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", "\[Rule]", 
             RowBox[{"{", "5", "}"}]}], "}"}]}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
        "Blue", ",", " ", "Purple", ",", " ", "Black", ",", " ", "Gray", ",", 
         " ", "Gray"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", "580"}]}], "\[IndentingNewLine]", 
     "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Row", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"freq1", ",", "440", ",", "\"\<frequency 1\>\""}], 
              "}"}], ",", "440", ",", 
             RowBox[{"30", " ", "440"}], ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"freq2", ",", "440", ",", "\"\<frequency 2\>\""}], 
              "}"}], ",", "440", ",", 
             RowBox[{"30", " ", "440"}], ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a2", ",", "1", ",", "\"\<amplitude 2\>\""}], "}"}], 
             ",", "0", ",", "1", ",", " ", "0.01", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Control", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"p", ",", "0", ",", "\"\<\>\""}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"\[Pi]", "/", "2"}], ",", " ", "\[Pi]", ",", 
                  RowBox[{"3", " ", 
                   RowBox[{"\[Pi]", "/", "2"}]}], ",", " ", 
                  RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Control", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"p", ",", "1", ",", "\"\< <-> phase 2\>\""}], "}"}], 
                ",", "0", ",", 
                RowBox[{"2", " ", "\[Pi]"}], ",", 
                RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                " ", 
                RowBox[{"ImageSize", " ", "\[Rule]", " ", "Small"}]}], "}"}], 
              "]"}]}], "\[IndentingNewLine]", "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", " ", "Right"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "showW", ",", "True", ",", "\"\<show waves 1 and 2\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "fill", ",", "True", ",", 
               "\"\<show filling: waves 1 \[Rule] 2, sum and beats\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "showS", ",", "True", ",", 
               "\"\<show sum (wave 1 + wave 2)\>\""}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Control", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"showB", ",", "True", ",", "\"\<show beats\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Button", "[", 
              RowBox[{"\"\<A\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<B\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<C\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<D\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"2", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", ".5"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<E\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "\[Pi]"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<F\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<G\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<H\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<I\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<J\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"15", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"13", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.5"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<K\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<L\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<M\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<N\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "False"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "False"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Button", "[", 
              RowBox[{"\"\<O\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"freq1", " ", "=", 
                  RowBox[{"1", " ", "440"}]}], ",", 
                 RowBox[{"freq2", " ", "=", 
                  RowBox[{"30", " ", "440"}]}], ",", " ", 
                 RowBox[{"a2", " ", "=", " ", "0.1"}], ",", 
                 RowBox[{"p", " ", "=", "0"}], ",", 
                 RowBox[{"fill", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showS", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showW", " ", "=", " ", "True"}], ",", " ", 
                 RowBox[{"showB", " ", "=", " ", "True"}]}], "}"}], ",", 
               RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}]}], 
              "]"}]}], "\[IndentingNewLine]", "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", " ", "Right"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "True"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{
  3.454897982*^9, {3.455454103234375*^9, 3.4554541155625*^9}, {
   3.455454163578125*^9, 3.455454295859375*^9}, {3.455454493921875*^9, 
   3.455454520953125*^9}, {3.45545457984375*^9, 3.455454607546875*^9}, {
   3.455454659328125*^9, 3.455455147109375*^9}, {3.455455287015625*^9, 
   3.455455321171875*^9}, {3.45545535890625*^9, 3.455455385703125*^9}, {
   3.455455424203125*^9, 3.4554554315*^9}, {3.45545546659375*^9, 
   3.455455480140625*^9}, {3.455455546453125*^9, 3.455455548546875*^9}, {
   3.455455581734375*^9, 3.455455611*^9}, {3.455455754609375*^9, 
   3.4554557948125*^9}, {3.455455849265625*^9, 3.455455854515625*^9}, {
   3.45545591953125*^9, 3.455455943578125*^9}, {3.4554559828125*^9, 
   3.45545602625*^9}, {3.4554561195*^9, 3.455456199921875*^9}, {
   3.455456276484375*^9, 3.455456359671875*^9}, {3.45545642628125*^9, 
   3.45545644703125*^9}, {3.45545657075*^9, 3.45545662803125*^9}, {
   3.4554566675625*^9, 3.455456676*^9}, {3.455456706296875*^9, 
   3.4554567275*^9}, {3.455456959421875*^9, 3.455457014640625*^9}, {
   3.455457079625*^9, 3.455457081453125*^9}, {3.455457188375*^9, 
   3.455457258859375*^9}, {3.455457431703125*^9, 3.455457447578125*^9}, {
   3.45545749434375*^9, 3.455457586390625*^9}, {3.455502117890625*^9, 
   3.45550212040625*^9}, {3.4555027640625*^9, 3.455502764796875*^9}, {
   3.455502797671875*^9, 3.455502823421875*^9}, {3.455502857796875*^9, 
   3.45550287*^9}, {3.455502932078125*^9, 3.45550300628125*^9}, 
   3.45550305234375*^9, {3.4555031345*^9, 3.45550321090625*^9}, {
   3.4555032678125*^9, 3.4555032821875*^9}, {3.455503444140625*^9, 
   3.4555034594375*^9}, {3.455503591828125*^9, 3.45550363275*^9}, {
   3.45550366621875*^9, 3.45550378984375*^9}, {3.455503873109375*^9, 
   3.4555038948125*^9}, {3.455503987015625*^9, 3.45550399221875*^9}, {
   3.455504077484375*^9, 3.4555040816875*^9}, {3.455504249765625*^9, 
   3.455504290453125*^9}, {3.455504327875*^9, 3.4555043525625*^9}, {
   3.45550439078125*^9, 3.45550445284375*^9}, {3.45550454234375*^9, 
   3.4555045835625*^9}, {3.4555046311875*^9, 3.455504706390625*^9}, 
   3.455504738953125*^9, {3.455504771828125*^9, 3.455504873734375*^9}, {
   3.45550903675*^9, 3.455509122046875*^9}, {3.455509175484375*^9, 
   3.455509185625*^9}, {3.455509314171875*^9, 3.45550934096875*^9}, {
   3.455509565375*^9, 3.455509602484375*^9}, {3.4555096571875*^9, 
   3.455509660671875*^9}, 3.455509694953125*^9, {3.45550984753125*^9, 
   3.45550985084375*^9}, {3.4555523355615597`*^9, 3.455552403197323*^9}, 
   3.455552528513853*^9, {3.455552731059106*^9, 3.455552736656666*^9}, 
   3.4558088014134016`*^9, {3.455852777140625*^9, 3.45585282040625*^9}, 
   3.455889127317867*^9, {3.455889191411617*^9, 3.455889212286617*^9}, {
   3.455889245474117*^9, 3.455889278567867*^9}, {3.455890556442867*^9, 
   3.455890556786617*^9}, {3.455890599114742*^9, 3.455890634270992*^9}, {
   3.455890723724117*^9, 3.455890808161617*^9}, 3.455890859849117*^9, {
   3.455891359224117*^9, 3.455891377880367*^9}, 3.4559121809071817`*^9, {
   3.4559125926571817`*^9, 3.4559126115634317`*^9}, 3.455968434470934*^9, {
   3.4560749191045113`*^9, 3.4560749630619063`*^9}},
 CellID->39540832],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1, $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
    440, $CellContext`p$$ = 0, $CellContext`showB$$ = 
    True, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 440, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 440, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], True, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    580., {185., 188.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`freq1$955725$$ = 
    0, $CellContext`freq2$955726$$ = 0, $CellContext`a2$955727$$ = 
    0, $CellContext`p$955728$$ = 0, $CellContext`showW$955729$$ = 
    False, $CellContext`fill$955730$$ = False, $CellContext`showS$955731$$ = 
    False, $CellContext`showB$955732$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1, $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
        440, $CellContext`p$$ = 0, $CellContext`showB$$ = 
        True, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$955725$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$955726$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$955727$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$955728$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$955729$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$955730$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$955731$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$955732$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 440, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 440, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, True, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{629., {274., 279.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->355932188]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ManipulateCaptionSection"],

Cell["\<\
This Demonstration shows the sum and the envelope of the beat for two sine \
waves. You can change the frequencies of either wave or modulate the \
amplitude or phase of the second wave.\
\>", "ManipulateCaption",
 CellChangeTimes->{
  3.35696210375764*^9, {3.45551775271875*^9, 3.455517753390625*^9}, {
   3.4555524431483173`*^9, 3.4555524457085733`*^9}, 3.455552528525854*^9, {
   3.455552655872588*^9, 3.45555268579558*^9}, {3.455888779567867*^9, 
   3.455888855849117*^9}, {3.455890466177242*^9, 3.455890477286617*^9}, {
   3.455891304270992*^9, 3.455891305364742*^9}, {3.4559091776198683`*^9, 
   3.455909192163862*^9}},
 CellID->334122753],

Cell["\<\
The buttons A, B, C, \[Ellipsis], L are presets. They show some typical \
situations that may be freely used for further investigations. The notebook \
being quite complex with all its possibilities, the presets illustrate how it \
is possible to reduces redundancies by switching off some waves or the \
filling. Stepping through the presets while analyzing the parameters and the \
obtained results lets you see the most interesting cases of adding two sine \
waves. \
\>", "ManipulateCaption",
 CellChangeTimes->{
  3.35696210375764*^9, {3.455891421099117*^9, 3.455891449974117*^9}, {
   3.455891486817867*^9, 3.455891497770992*^9}},
 CellID->38415573]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ThumbnailSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1., $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 6330., $CellContext`freq2$$ = 
    8130., $CellContext`p$$ = 0, $CellContext`showB$$ = 
    True, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 6330., "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 8130., "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1., "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], True, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    580., {185., 188.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`freq1$955822$$ = 
    0, $CellContext`freq2$955823$$ = 0, $CellContext`a2$955824$$ = 
    0, $CellContext`p$955825$$ = 0, $CellContext`showW$955826$$ = 
    False, $CellContext`fill$955827$$ = False, $CellContext`showS$955828$$ = 
    False, $CellContext`showB$955829$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1., $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 6330., $CellContext`freq2$$ = 
        8130., $CellContext`p$$ = 0, $CellContext`showB$$ = 
        True, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$955822$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$955823$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$955824$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$955825$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$955826$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$955827$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$955828$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$955829$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 6330., "frequency 1"}, 440,
          13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 8130., "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1., "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, True, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{629., {274., 279.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->217109199]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SnapshotsSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1, $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
    440, $CellContext`p$$ = 0, $CellContext`showB$$ = 
    False, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 440, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 440, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], False, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    580., {185., 188.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`freq1$955919$$ = 
    0, $CellContext`freq2$955920$$ = 0, $CellContext`a2$955921$$ = 
    0, $CellContext`p$955922$$ = 0, $CellContext`showW$955923$$ = 
    False, $CellContext`fill$955924$$ = False, $CellContext`showS$955925$$ = 
    False, $CellContext`showB$955926$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1, $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
        440, $CellContext`p$$ = 0, $CellContext`showB$$ = 
        False, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$955919$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$955920$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$955921$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$955922$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$955923$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$955924$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$955925$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$955926$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 440, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 440, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, False, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{629., {274., 279.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->29902505],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1, $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 880, $CellContext`freq2$$ = 
    880, $CellContext`p$$ = 0, $CellContext`showB$$ = 
    False, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 880, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 880, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], False, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`freq1$956016$$ = 0, $CellContext`freq2$956017$$ = 
    0, $CellContext`a2$956018$$ = 0, $CellContext`p$956019$$ = 
    0, $CellContext`showW$956020$$ = False, $CellContext`fill$956021$$ = 
    False, $CellContext`showS$956022$$ = False, $CellContext`showB$956023$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1, $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 880, $CellContext`freq2$$ = 
        880, $CellContext`p$$ = 0, $CellContext`showB$$ = 
        False, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$956016$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$956017$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$956018$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$956019$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$956020$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$956021$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$956022$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$956023$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 880, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 880, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, False, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->311155499],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1, $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
    880, $CellContext`p$$ = 0, $CellContext`showB$$ = 
    True, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 440, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 880, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], True, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`freq1$956113$$ = 0, $CellContext`freq2$956114$$ = 
    0, $CellContext`a2$956115$$ = 0, $CellContext`p$956116$$ = 
    0, $CellContext`showW$956117$$ = False, $CellContext`fill$956118$$ = 
    False, $CellContext`showS$956119$$ = False, $CellContext`showB$956120$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1, $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
        880, $CellContext`p$$ = 0, $CellContext`showB$$ = 
        True, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$956113$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$956114$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$956115$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$956116$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$956117$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$956118$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$956119$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$956120$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 440, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 880, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, True, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->526388812],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 0.5, $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
    880, $CellContext`p$$ = 0, $CellContext`showB$$ = 
    True, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 440, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 880, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 0.5, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], True, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`freq1$956210$$ = 0, $CellContext`freq2$956211$$ = 
    0, $CellContext`a2$956212$$ = 0, $CellContext`p$956213$$ = 
    0, $CellContext`showW$956214$$ = False, $CellContext`fill$956215$$ = 
    False, $CellContext`showS$956216$$ = False, $CellContext`showB$956217$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 0.5, $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
        880, $CellContext`p$$ = 0, $CellContext`showB$$ = 
        True, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$956210$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$956211$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$956212$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$956213$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$956214$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$956215$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$956216$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$956217$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 440, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 880, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 0.5, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, True, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->367997690],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1, $CellContext`fill$$ = 
    True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
    440, $CellContext`p$$ = Pi, $CellContext`showB$$ = 
    False, $CellContext`showS$$ = True, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 440, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 440, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], Pi, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], Pi, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], True, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], True, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], False, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`freq1$956307$$ = 0, $CellContext`freq2$956308$$ = 
    0, $CellContext`a2$956309$$ = 0, $CellContext`p$956310$$ = 
    0, $CellContext`showW$956311$$ = False, $CellContext`fill$956312$$ = 
    False, $CellContext`showS$956313$$ = False, $CellContext`showB$956314$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1, $CellContext`fill$$ = 
        True, $CellContext`freq1$$ = 440, $CellContext`freq2$$ = 
        440, $CellContext`p$$ = Pi, $CellContext`showB$$ = 
        False, $CellContext`showS$$ = True, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$956307$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$956308$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$956309$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$956310$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$956311$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$956312$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$956313$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$956314$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 440, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 440, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, Pi, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, Pi, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, True, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, True, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, False, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->16598722],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a2$$ = 1, $CellContext`fill$$ = 
    False, $CellContext`freq1$$ = 6600, $CellContext`freq2$$ = 
    5720, $CellContext`p$$ = 0, $CellContext`showB$$ = 
    False, $CellContext`showS$$ = False, $CellContext`showW$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`freq1$$], 6600, "frequency 1"}, 440, 13200}, {{
       Hold[$CellContext`freq2$$], 5720, "frequency 2"}, 440, 13200}, {{
       Hold[$CellContext`a2$$], 1, "amplitude 2"}, 0, 1, 0.01}, {{
       Hold[$CellContext`p$$], 0, ""}, {
      0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}}, {{
       Hold[$CellContext`p$$], 0, " <-> phase 2"}, 0, 2 Pi}, {{
       Hold[$CellContext`showW$$], True, "show waves 1 and 2"}, {
      True, False}}, {{
       Hold[$CellContext`fill$$], False, 
       "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}}, {{
       Hold[$CellContext`showS$$], False, "show sum (wave 1 + wave 2)"}, {
      True, False}}, {{
       Hold[$CellContext`showB$$], False, "show beats"}, {True, False}}, {
      Hold[
       Row[{
         Column[{
           Manipulate`Place[1], 
           Manipulate`Place[2], 
           Manipulate`Place[3], 
           Row[{
             Manipulate`Place[4], 
             Manipulate`Place[5]}]}, Right], 
         Column[{
           Manipulate`Place[6], 
           Manipulate`Place[7], 
           Manipulate`Place[8], 
           Manipulate`Place[9], 
           Row[{
             Button[
             "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
               13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"], 
             Button[
             "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
               False}, Appearance -> "FramedPalette"], 
             Button[
             "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
               30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
               0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
               True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
               True}, Appearance -> "FramedPalette"]}]}, Right]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`freq1$956404$$ = 0, $CellContext`freq2$956405$$ = 
    0, $CellContext`a2$956406$$ = 0, $CellContext`p$956407$$ = 
    0, $CellContext`showW$956408$$ = False, $CellContext`fill$956409$$ = 
    False, $CellContext`showS$956410$$ = False, $CellContext`showB$956411$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`a2$$ = 1, $CellContext`fill$$ = 
        False, $CellContext`freq1$$ = 6600, $CellContext`freq2$$ = 
        5720, $CellContext`p$$ = 0, $CellContext`showB$$ = 
        False, $CellContext`showS$$ = False, $CellContext`showW$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`freq1$$, $CellContext`freq1$956404$$, 0], 
        Hold[$CellContext`freq2$$, $CellContext`freq2$956405$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$956406$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$956407$$, 0], 
        Hold[$CellContext`showW$$, $CellContext`showW$956408$$, False], 
        Hold[$CellContext`fill$$, $CellContext`fill$956409$$, False], 
        Hold[$CellContext`showS$$, $CellContext`showS$956410$$, False], 
        Hold[$CellContext`showB$$, $CellContext`showB$956411$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`f1 = $CellContext`freq1$$/
         440; $CellContext`f2 = $CellContext`freq2$$/440; Plot[{
          If[$CellContext`showW$$, 
           Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showW$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$], 
          
          If[$CellContext`showS$$, 
           Sin[$CellContext`f2 $CellContext`x + $CellContext`p$$] \
$CellContext`a2$$ + Sin[$CellContext`f1 $CellContext`x]], 
          
          If[$CellContext`showB$$, 1 - $CellContext`a2$$ + 
           Abs[Cos[(($CellContext`f2 - $CellContext`f1)/
                 2) $CellContext`x + $CellContext`p$$/2] 
             2 $CellContext`a2$$]], 
          
          If[$CellContext`showB$$, -1 + $CellContext`a2$$ - Abs[
           Cos[(($CellContext`f2 - $CellContext`f1)/
                2) $CellContext`x + $CellContext`p$$/2] 
            2 $CellContext`a2$$]]}, {$CellContext`x, 0, 2 Pi}, PlotLabel -> 
         StringJoin["frequency of beats = ", 
           ToString[Abs[$CellContext`f2 - $CellContext`f1] 440], " Hz."], 
         PlotRange -> {-2, 2}, AspectRatio -> 0.6, 
         Ticks -> {{0, Pi/2, Pi, 3 (Pi/2), 2 Pi}, {-2, -1, 0, 1, 2}}, Filling -> 
         If[$CellContext`fill$$, {{1 -> {2}}, {3 -> 0}, {4 -> {5}}}], 
         PlotStyle -> {Blue, Purple, Black, Gray, Gray}, ImageSize -> 580]), 
      "Specifications" :> {{{$CellContext`freq1$$, 6600, "frequency 1"}, 440, 
         13200, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`freq2$$, 5720, "frequency 2"}, 440, 13200, 
         Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`a2$$, 1, "amplitude 2"}, 0, 1, 0.01, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`p$$, 0, ""}, {
         0, Rational[1, 2] Pi, Pi, Rational[3, 2] Pi, 2 Pi}, ControlPlacement -> 
         4}, {{$CellContext`p$$, 0, " <-> phase 2"}, 0, 2 Pi, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         5}, {{$CellContext`showW$$, True, "show waves 1 and 2"}, {
         True, False}, ControlPlacement -> 
         6}, {{$CellContext`fill$$, False, 
          "show filling: waves 1 \[Rule] 2, sum and beats"}, {True, False}, 
         ControlPlacement -> 
         7}, {{$CellContext`showS$$, False, "show sum (wave 1 + wave 2)"}, {
         True, False}, ControlPlacement -> 
         8}, {{$CellContext`showB$$, False, "show beats"}, {True, False}, 
         ControlPlacement -> 9}, 
        Row[{
          Column[{
            Manipulate`Place[1], 
            Manipulate`Place[2], 
            Manipulate`Place[3], 
            Row[{
              Manipulate`Place[4], 
              Manipulate`Place[5]}]}, Right], 
          Column[{
            Manipulate`Place[6], 
            Manipulate`Place[7], 
            Manipulate`Place[8], 
            Manipulate`Place[9], 
            Row[{
              Button[
              "A", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "B", {$CellContext`freq1$$ = 2 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "C", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "D", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                2 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "E", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                1 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                Pi, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "F", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "G", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "H", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "I", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "J", {$CellContext`freq1$$ = 15 440, $CellContext`freq2$$ = 
                13 440, $CellContext`a2$$ = 0.5, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"], 
              Button[
              "K", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                False, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "L", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "M", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = False, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "N", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = False, $CellContext`showB$$ = 
                False}, Appearance -> "FramedPalette"], 
              Button[
              "O", {$CellContext`freq1$$ = 1 440, $CellContext`freq2$$ = 
                30 440, $CellContext`a2$$ = 0.1, $CellContext`p$$ = 
                0, $CellContext`fill$$ = True, $CellContext`showS$$ = 
                True, $CellContext`showW$$ = True, $CellContext`showB$$ = 
                True}, Appearance -> "FramedPalette"]}]}, Right]}]}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}, TrackedSymbols -> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->29877904]
}, Open  ]],

Cell["", "DetailsSection"],

Cell[CellGroupData[{

Cell["", "ControlSuggestionsSection"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[True], Cell[" Resize Images"]}],
  "\"Click inside an image to reveal its orange resize frame.\\nDrag any of \
the orange resize handles to resize the image.\"",
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{
  3.35696210375764*^9, {3.454848265796875*^9, 3.454848271078125*^9}, 
   3.4559127034853067`*^9},
 FontFamily->"Verdana",
 CellTags->"ResizeImages"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Rotate and Zoom in 3D"]}],
  RowBox[{
   "\"Drag a 3D graphic to rotate it. Starting the drag near the center \
tumbles\\nthe graphic; starting near a corner turns it parallel to the plane \
of the screen.\\nHold down \"", 
    FrameBox[
    "Ctrl", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" (or \"", 
    FrameBox[
    "Cmd", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" on Mac) and drag up and down to zoom.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"RotateAndZoomIn3D"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Drag Locators"]}],
  RowBox[{"\"Drag any locator (\"", 
    GraphicsBox[
     LocatorBox[
      Scaled[{0.5, 0.5}]], ImageSize -> 20], 
    "\", etc.) to move it around.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"DragLocators"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Create and Delete Locators"]}],
  RowBox[{"\"Insert a new locator in the graphic by holding down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], 
    "\" key\\nand clicking where you want it to be. Delete a locator by \
clicking it\\nwhile holding down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" key.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"CreateAndDeleteLocators"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Slider Zoom"]}],
  RowBox[{"\"Hold down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], 
    "\" key while moving a slider to make fine adjustments in the slider \
value.\\nHold \"", 
    FrameBox[
    "Ctrl", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" and/or \"", 
    FrameBox[
    "Shift", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" at the same time as \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" to make ever finer adjustments.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"SliderZoom"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Gamepad Controls"]}],
  "\"Control this Demonstration with a gamepad or other\\nhuman interface \
device connected to your computer.\"",
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.35696210375764*^9, 3.3895522232313623`*^9},
 FontFamily->"Verdana",
 CellTags->"GamepadControls"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[True], Cell[" Automatic Animation"]}],
  RowBox[{"\"Animate a slider in this Demonstration by clicking the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIKwAgOI/R/IhBKc\n\
/4EAyGAG0f+nTZsGwgysIJIRKsWKLAXGIHFmEpUgLADxWUAkI24jZs+eTaEt\n\
IG+wQKRmzJgBlYf5lhEA30OqWA=="], "Graphics", ImageSize -> {9, 9}, ImageMargins -> 
      0, CellBaseline -> Baseline], BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"button\\nnext to the slider, and then clicking the play button that \
appears.\\nAnimate all controls by selecting \"", 
    StyleBox["Autorun", FontWeight -> "Bold"], "\" from the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJyNULENwyAQfEySIlMwTVJlCGRFsosokeNtqBmDBagoaZjAI1C8/8GUUUC6\n\
57h7cQ8PvU7Pl17nUav7oj/TPH7V7b2QJAUAXBkKmCPRowxICy64bRvGGNF7\n\
X8CctGoDSN4xhIDGGDhzFXwUh3/ClBKrDQPmnGXtI6u0OOd+tZBVUqy1xSaH\n\
UqiK6pPe4XdEdAz6563tx/gejuORGMxJaz8mdpJn7hc="], "Graphics", 
      ImageSize -> {10, 10}, ImageMargins -> 0, CellBaseline -> Baseline], 
     BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"menu.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.35696210375764*^9, 3.454848292625*^9, 3.454848324*^9, 
  3.4559127058134317`*^9},
 FontFamily->"Verdana",
 CellTags->"AutomaticAnimation"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Bookmark Animation"]}],
  RowBox[{
   "\"See a prepared animation of this Demonstration by selecting\\n\"", 
    StyleBox["Animate Bookmarks", FontWeight -> "Bold"], "\" from the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJyNULENwyAQfEySIlMwTVJlCGRFsosokeNtqBmDBagoaZjAI1C8/8GUUUC6\n\
57h7cQ8PvU7Pl17nUav7oj/TPH7V7b2QJAUAXBkKmCPRowxICy64bRvGGNF7\n\
X8CctGoDSN4xhIDGGDhzFXwUh3/ClBKrDQPmnGXtI6u0OOd+tZBVUqy1xSaH\n\
UqiK6pPe4XdEdAz6563tx/gejuORGMxJaz8mdpJn7hc="], "Graphics", 
      ImageSize -> {10, 10}, ImageMargins -> 0, CellBaseline -> Baseline], 
     BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"menu.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"BookmarkAnimation"]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SearchTermsSection"],

Cell["Acoustics", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4555104924375*^9, 3.455510495484375*^9}},
 CellID->108471510],

Cell["Wave", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.455510496046875*^9, 3.455510500828125*^9}},
 CellID->29924135],

Cell["Sine", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.455510501734375*^9, 3.45551050446875*^9}},
 CellID->334867526],

Cell["Cosine", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.455510504859375*^9, 3.4555105076875*^9}},
 CellID->518921739],

Cell["Sum of 2 Waves", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.455510516625*^9, 3.455510529578125*^9}},
 CellID->241646030],

Cell["Beatings", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.455510530765625*^9, 3.4555105330625*^9}},
 CellID->150038797]
}, Open  ]],

Cell["", "RelatedLinksSection"],

Cell[CellGroupData[{

Cell["", "AuthorSection"],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Arthur Stammet",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Arthur+Stammet"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Arthur+Stammet"]
}], "Author",
 CellChangeTimes->{
  3.35696210375764*^9, {3.454848900828125*^9, 3.45484890409375*^9}, 
   3.4559127634228067`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{982, 681},
WindowMargins->{{43, Automatic}, {Automatic, 26}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Demonstration.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ResizeImages"->{
  Cell[169412, 3153, 429, 11, 22, "ControlSuggestions",
   CellTags->"ResizeImages"]},
 "RotateAndZoomIn3D"->{
  Cell[169844, 3166, 678, 16, 22, "ControlSuggestions",
   CellTags->"RotateAndZoomIn3D"]},
 "DragLocators"->{
  Cell[170525, 3184, 340, 11, 22, "ControlSuggestions",
   CellTags->"DragLocators"]},
 "CreateAndDeleteLocators"->{
  Cell[170868, 3197, 637, 15, 22, "ControlSuggestions",
   CellTags->"CreateAndDeleteLocators"]},
 "SliderZoom"->{
  Cell[171508, 3214, 844, 21, 22, "ControlSuggestions",
   CellTags->"SliderZoom"]},
 "GamepadControls"->{
  Cell[172355, 3237, 369, 9, 22, "ControlSuggestions",
   CellTags->"GamepadControls"]},
 "AutomaticAnimation"->{
  Cell[172727, 3248, 1566, 33, 22, "ControlSuggestions",
   CellTags->"AutomaticAnimation"]},
 "BookmarkAnimation"->{
  Cell[174296, 3283, 908, 21, 22, "ControlSuggestions",
   CellTags->"BookmarkAnimation"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ResizeImages", 177040, 3375},
 {"RotateAndZoomIn3D", 177151, 3378},
 {"DragLocators", 177262, 3381},
 {"CreateAndDeleteLocators", 177379, 3384},
 {"SliderZoom", 177494, 3387},
 {"GamepadControls", 177601, 3390},
 {"AutomaticAnimation", 177715, 3393},
 {"BookmarkAnimation", 177833, 3396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 225, 3, 74, "DemoTitle"],
Cell[795, 27, 33, 0, 266, "InitializationSection"],
Cell[CellGroupData[{
Cell[853, 31, 29, 0, 188, "ManipulateSection"],
Cell[CellGroupData[{
Cell[907, 35, 25260, 518, 1428, "Input",
 CellID->39540832],
Cell[26170, 555, 17723, 317, 565, "Output",
 CellID->355932188]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43939, 878, 36, 0, 166, "ManipulateCaptionSection"],
Cell[43978, 880, 655, 12, 37, "ManipulateCaption",
 CellID->334122753],
Cell[44636, 894, 665, 12, 67, "ManipulateCaption",
 CellID->38415573]
}, Open  ]],
Cell[CellGroupData[{
Cell[45338, 911, 28, 0, 168, "ThumbnailSection"],
Cell[45369, 913, 17743, 317, 565, "Output",
 CellID->217109199]
}, Open  ]],
Cell[CellGroupData[{
Cell[63149, 1235, 28, 0, 138, "SnapshotsSection"],
Cell[63180, 1237, 17726, 317, 565, "Output",
 CellID->29902505],
Cell[80909, 1556, 17673, 316, 37, "Output",
 CellID->311155499],
Cell[98585, 1874, 17669, 316, 37, "Output",
 CellID->526388812],
Cell[116257, 2192, 17677, 316, 37, "Output",
 CellID->367997690],
Cell[133937, 2510, 17678, 316, 37, "Output",
 CellID->16598722],
Cell[151618, 2828, 17688, 316, 37, "Output",
 CellID->29877904]
}, Open  ]],
Cell[169321, 3147, 26, 0, 332, "DetailsSection"],
Cell[CellGroupData[{
Cell[169372, 3151, 37, 0, 108, "ControlSuggestionsSection"],
Cell[169412, 3153, 429, 11, 22, "ControlSuggestions",
 CellTags->"ResizeImages"],
Cell[169844, 3166, 678, 16, 22, "ControlSuggestions",
 CellTags->"RotateAndZoomIn3D"],
Cell[170525, 3184, 340, 11, 22, "ControlSuggestions",
 CellTags->"DragLocators"],
Cell[170868, 3197, 637, 15, 22, "ControlSuggestions",
 CellTags->"CreateAndDeleteLocators"],
Cell[171508, 3214, 844, 21, 22, "ControlSuggestions",
 CellTags->"SliderZoom"],
Cell[172355, 3237, 369, 9, 22, "ControlSuggestions",
 CellTags->"GamepadControls"],
Cell[172727, 3248, 1566, 33, 22, "ControlSuggestions",
 CellTags->"AutomaticAnimation"],
Cell[174296, 3283, 908, 21, 22, "ControlSuggestions",
 CellTags->"BookmarkAnimation"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175241, 3309, 30, 0, 152, "SearchTermsSection"],
Cell[175274, 3311, 140, 3, 22, "SearchTerms",
 CellID->108471510],
Cell[175417, 3316, 136, 3, 22, "SearchTerms",
 CellID->29924135],
Cell[175556, 3321, 136, 3, 22, "SearchTerms",
 CellID->334867526],
Cell[175695, 3326, 137, 3, 22, "SearchTerms",
 CellID->518921739],
Cell[175835, 3331, 144, 3, 22, "SearchTerms",
 CellID->241646030],
Cell[175982, 3336, 139, 3, 22, "SearchTerms",
 CellID->150038797]
}, Open  ]],
Cell[176136, 3342, 31, 0, 138, "RelatedLinksSection"],
Cell[CellGroupData[{
Cell[176192, 3346, 25, 0, 124, "AuthorSection"],
Cell[176220, 3348, 416, 12, 22, "Author"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
