(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     22638,        569]
NotebookOptionsPosition[     21465,        524]
NotebookOutlinePosition[     22115,        549]
CellTagsIndexPosition[     22072,        546]
WindowTitle->Superposition of Sound Waves - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Superposition of Sound Waves", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"f1", "*", "2", "Pi", "*", "t"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "0.02"}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{".33", ",", ".6", ",", ".7"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.0075", "]"}]}], "}"}]}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"f2", "*", "2", "Pi", "*", "t"}], "+", "offset"}], "]"}],
            ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "0.02"}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{".48", ",", ".11", ",", ".56"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.0075", "]"}]}], "}"}]}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"f1", "*", "2", "Pi", "*", "t"}], "]"}], "+", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"f2", "*", "2", "Pi", "*", "t"}], "+", "offset"}], 
             "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "0.02"}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{".6", ",", ".73", ",", ".36"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0.02"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}], ",", 
       "\[IndentingNewLine]", "\"\<\>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"f1", "\[NotEqual]", "oldf1"}], ",", "\[IndentingNewLine]", 
         RowBox[{"EmitSound", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Sound", "[", 
            RowBox[{
             RowBox[{"Play", "[", 
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"f1", "*", "2", "Pi", "*", "t"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0.1"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "}"}], "]"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"f2", "\[NotEqual]", "oldf2"}], ",", "\[IndentingNewLine]", 
         RowBox[{"EmitSound", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Sound", "[", 
            RowBox[{
             RowBox[{"Play", "[", 
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{
                 RowBox[{"f2", "*", "2", "Pi", "*", "t"}], "+", "offset"}], 
                "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0.1"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "}"}], "]"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Button", "[", 
        RowBox[{"\"\<play result\>\"", ",", 
         RowBox[{"EmitSound", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Sound", "[", 
            RowBox[{
             RowBox[{"Play", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Sin", "[", 
                 RowBox[{"f1", "*", "2", "Pi", "*", "t"}], "]"}], "+", 
                RowBox[{"Sin", "[", 
                 RowBox[{
                  RowBox[{"f2", "*", "2", "Pi", "*", "t"}], "+", "offset"}], 
                 "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
               RowBox[{"PlayRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
           "}"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"oldf1", "=", "f1"}], ";", 
        RowBox[{"oldf2", "=", "f2"}], ";"}]}], "\[IndentingNewLine]", "}"}], 
     ",", 
     RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f1", ",", "200", ",", "\"\<blue wave\>\""}], "}"}], ",", "200",
      ",", "500", ",", "25"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f2", ",", "200", ",", "\"\<purple wave\>\""}], "}"}], ",", 
     "200", ",", "500", ",", "25"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"offset", ",", "0", ",", "\"\<offset\>\""}], "}"}], ",", "0", 
     ",", 
     RowBox[{"2", "Pi"}], ",", 
     RowBox[{"Pi", "/", "16"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"oldf1", ",", "200"}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "None"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"oldf2", ",", "200"}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "None"}]}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.3880408599245253`*^9, {3.38809355971875*^9, 
   3.388093591578125*^9}, {3.388093666640625*^9, 3.38809370184375*^9}, {
   3.38815144875001*^9, 3.3881514508906345`*^9}, {3.3882337403698*^9, 
   3.3882337440729012`*^9}, {3.3882691751744223`*^9, 3.388269234217186*^9}, {
   3.3882692713665867`*^9, 3.388269297975689*^9}, {3.3882693926745033`*^9, 
   3.388269394607625*^9}, {3.3882694454244137`*^9, 3.3882694568925343`*^9}, {
   3.388269489631571*^9, 3.388269512432417*^9}, {3.388269661143173*^9, 
   3.388269684364599*^9}, {3.388269879230542*^9, 3.38826991888437*^9}, 
   3.3882700098763657`*^9, {3.388270052469618*^9, 3.388270085495042*^9}, {
   3.388270234912266*^9, 3.388270287657125*^9}, {3.388270326529517*^9, 
   3.388270335431246*^9}, 3.388270379558235*^9, {3.388270415430615*^9, 
   3.38827046767307*^9}, {3.3882705170265703`*^9, 3.388270560297297*^9}, {
   3.388270591693824*^9, 3.388270593776366*^9}, {3.388270648023672*^9, 
   3.388270702571981*^9}, {3.3882707809084873`*^9, 3.38827092511474*^9}, {
   3.3882709597300386`*^9, 3.388271014389387*^9}, {3.388271057404477*^9, 
   3.3882712230046473`*^9}, {3.388312081159659*^9, 3.3883121435709476`*^9}, {
   3.388312188278754*^9, 3.388312208686873*^9}, {3.3883122477847023`*^9, 
   3.388312274220769*^9}, {3.38831233631575*^9, 3.3883123548475323`*^9}, 
   3.4204718076988173`*^9, {3.4204732662237945`*^9, 3.420473325854757*^9}, {
   3.4204733616323347`*^9, 3.4204733910132723`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f1$$ = 200, $CellContext`f2$$ = 
    200, $CellContext`offset$$ = 0, $CellContext`oldf1$$ = 
    200, $CellContext`oldf2$$ = 200, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`f1$$], 200, "blue wave"}, 200, 500, 25}, {{
       Hold[$CellContext`f2$$], 200, "purple wave"}, 200, 500, 25}, {{
       Hold[$CellContext`offset$$], 0, "offset"}, 0, 2 Pi, Rational[1, 16] 
      Pi}, {{
       Hold[$CellContext`oldf1$$], 200}}, {{
       Hold[$CellContext`oldf2$$], 200}}}, Typeset`size$$ = {
    400., {165.5, 170.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`f1$780470$$ = 
    0, $CellContext`f2$780471$$ = 0, $CellContext`offset$780472$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`f1$$ = 200, $CellContext`f2$$ = 
        200, $CellContext`offset$$ = 0, $CellContext`oldf1$$ = 
        200, $CellContext`oldf2$$ = 200}, "ControllerVariables" :> {
        Hold[$CellContext`f1$$, $CellContext`f1$780470$$, 0], 
        Hold[$CellContext`f2$$, $CellContext`f2$780471$$, 0], 
        Hold[$CellContext`offset$$, $CellContext`offset$780472$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Show[
          Plot[
           
           Sin[(($CellContext`f1$$ 2) Pi) $CellContext`t], {$CellContext`t, 0,
             0.02}, PlotStyle -> {
             RGBColor[0.33, 0.6, 0.7], 
             Thickness[0.0075]}], 
          Plot[
           
           Sin[(($CellContext`f2$$ 2) 
              Pi) $CellContext`t + $CellContext`offset$$], {$CellContext`t, 0,
             0.02}, PlotStyle -> {
             RGBColor[0.48, 0.11, 0.56], 
             Thickness[0.0075]}], 
          Plot[
          Sin[(($CellContext`f1$$ 2) Pi) $CellContext`t] + 
           Sin[(($CellContext`f2$$ 2) 
               Pi) $CellContext`t + $CellContext`offset$$], {$CellContext`t, 
            0, 0.02}, PlotStyle -> {
             RGBColor[0.6, 0.73, 0.36], 
             Thickness[0.01]}], PlotRange -> {{0, 0.02}, {-2, 2}}, Ticks -> 
          None, ImageSize -> 400], "", 
         If[$CellContext`f1$$ != $CellContext`oldf1$$, 
          EmitSound[{
            Sound[
             Play[
              
              Sin[(($CellContext`f1$$ 2) Pi) $CellContext`t], {$CellContext`t,
                0, 1}], {0, 0.1}]}]], 
         If[$CellContext`f2$$ != $CellContext`oldf2$$, 
          EmitSound[{
            Sound[
             Play[
              
              Sin[(($CellContext`f2$$ 2) 
                 Pi) $CellContext`t + $CellContext`offset$$], {$CellContext`t,
                0, 1}], {0, 0.1}]}]], 
         Button["play result", 
          EmitSound[{
            Sound[
             Play[
             Sin[(($CellContext`f1$$ 2) Pi) $CellContext`t] + 
              Sin[(($CellContext`f2$$ 2) 
                  Pi) $CellContext`t + $CellContext`offset$$], \
{$CellContext`t, 0, 1}, PlayRange -> {-1, 1}], {0, 
             1}]}]], $CellContext`oldf1$$ = $CellContext`f1$$; \
$CellContext`oldf2$$ = $CellContext`f2$$; Null}, Alignment -> Center], 
      "Specifications" :> {{{$CellContext`f1$$, 200, "blue wave"}, 200, 500, 
         25}, {{$CellContext`f2$$, 200, "purple wave"}, 200, 500, 
         25}, {{$CellContext`offset$$, 0, "offset"}, 0, 2 Pi, Rational[1, 16] 
         Pi}, {{$CellContext`oldf1$$, 200}, ControlType -> 
         None}, {{$CellContext`oldf2$$, 200}, ControlType -> None}}, 
      "Options" :> {AutorunSequencing -> {1, 2, 3}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{445., {237., 242.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->186798225],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration shows two sound waves and their sum. By adjusting the \
waves' frequencies and their offset from each other, you can hear a variety \
of resultant patterns representing the sum of the two waves. It is even \
possible to allow the two waves to cancel each other out completely by \
setting them to the same frequency and adjusting the offset to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ", yielding a result that is silent."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Superposition of Sound Waves",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/SuperpositionOfSoundWaves/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/SuperpositionOfSoundWaves/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/SuperpositionOfSoundWaves/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/SuperpositionOfSoundWaves/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/SuperpositionOfSoundWaves/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Alan Joyce",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Alan+Joyce"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Alan+Joyce"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
SuperpositionOfSoundWaves"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Superposition of Sound Waves - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[630, 23, 148, 3, 70, "Section"],
Cell[781, 28, 3700, 64, 70, "Section"],
Cell[4484, 94, 7953, 184, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12474, 283, 4414, 95, 70, "Output",
 CellID->186798225],
Cell[CellGroupData[{
Cell[16913, 382, 209, 6, 70, "Section"],
Cell[17125, 390, 502, 9, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17675, 405, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[18033, 416, 934, 25, 70, "Text"],
Cell[18970, 443, 427, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[19422, 461, 815, 24, 70, "Text"],
Cell[20240, 487, 1197, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature hR4sW#egMdLfRATddv@PgiRW *)
