(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46222,       1161]
NotebookOptionsPosition[     41342,       1010]
NotebookOutlinePosition[     42936,       1060]
CellTagsIndexPosition[     42608,       1048]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Multiple Slit Diffraction Pattern", "DemoTitle",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4446958335895147`*^9, 3.4446958422336473`*^9}}],

Cell["", "InitializationSection"],

Cell[CellGroupData[{

Cell["", "ManipulateSection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "n"}], ")"}], 
          RowBox[{"ChebyshevU", "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"Cos", "[", 
             RowBox[{"b", " ", 
              RowBox[{"k", "/", "2"}]}], "]"}]}], "]"}], 
          RowBox[{"Sinc", "[", 
           RowBox[{"a", " ", 
            RowBox[{"k", "/", "2"}]}], "]"}]}], ")"}], "^", "2"}], ",", 
       RowBox[{
        RowBox[{"Sinc", "[", 
         RowBox[{"a", " ", 
          RowBox[{"k", "/", "2"}]}], "]"}], "^", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"-", "kmax"}], ",", "kmax"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<position\>\"", ",", "\"\<intensity\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{
       RowBox[{"ToString", "[", "n", "]"}], "<>", 
       "\"\< slit diffraction pattern\>\""}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "350"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"40", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"40", ",", "20"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0.5", ",", "\"\<slit width\>\""}], "}"}], ",", "0", 
     ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "2.5", ",", "\"\<slit spacing\>\""}], "}"}], ",", "1",
      ",", "5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "2", ",", "\"\<number of slits\>\""}], "}"}], ",", 
     RowBox[{"Range", "[", "10", "]"}], ",", "SetterBar"}], "}"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kmax", ",", "10", ",", "\"\<horizontal range\>\""}], "}"}], 
     ",", "1", ",", "100", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.444695859026884*^9, {3.444696299781196*^9, 
   3.444696341694256*^9}, {3.444696401996207*^9, 3.444696402959168*^9}, {
   3.444696509207447*^9, 3.444696597511465*^9}, {3.444752502538575*^9, 
   3.4447525323925605`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.5, $CellContext`b$$ = 
    2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 2, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 0.5, "slit width"}, 0, 1}, {{
       Hold[$CellContext`b$$], 2.5, "slit spacing"}, 1, 5}, {{
       Hold[$CellContext`n$$], 2, "number of slits"}, {1, 2, 3, 4, 5, 6, 7, 8,
       9, 10}}, {{
       Hold[$CellContext`kmax$$], 10, "horizontal range"}, 1, 100}}, 
    Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$31849$$ = 0, $CellContext`b$31850$$ = 
    0, $CellContext`n$31851$$ = 0, $CellContext`kmax$31852$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.5, $CellContext`b$$ = 
        2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$31849$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$31850$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$31851$$, 0], 
        Hold[$CellContext`kmax$$, $CellContext`kmax$31852$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{(((1/$CellContext`n$$) ChebyshevU[$CellContext`n$$ - 1, 
             Cos[$CellContext`b$$ ($CellContext`k/2)]]) 
          Sinc[$CellContext`a$$ ($CellContext`k/2)])^2, 
         Sinc[$CellContext`a$$ ($CellContext`k/
            2)]^2}, {$CellContext`k, -$CellContext`kmax$$, \
$CellContext`kmax$$}, PlotRange -> {0, 1}, Axes -> False, Frame -> True, 
        FrameTicks -> {True, False}, FrameLabel -> {"position", "intensity"}, 
        PlotLabel -> StringJoin[
          ToString[$CellContext`n$$], " slit diffraction pattern"], 
        Filling -> {1 -> Axis}, PlotStyle -> {Automatic, {Thick, Dashed}}, 
        ImageSize -> {500, 350}, ImagePadding -> {{40, 20}, {40, 20}}], 
      "Specifications" :> {{{$CellContext`a$$, 0.5, "slit width"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`b$$, 2.5, "slit spacing"}, 
         1, 5, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 2, "number of slits"}, {1, 2, 3, 4, 
         5, 6, 7, 8, 9, 10}, ControlType -> SetterBar}, 
        Delimiter, {{$CellContext`kmax$$, 10, "horizontal range"}, 1, 100, 
         Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{547., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.35696210375764*^9, 3.444770809588087*^9},
 CellID->341469225]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ManipulateCaptionSection"],

Cell[TextData[{
 "In this Demonstration we visualize the diffraction pattern of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " equally spaced slits of equal width, also known as a ",
 StyleBox["diffraction grating",
  FontSlant->"Italic"],
 ". It can be shown that the diffraction pattern is equivalent to the \
diffraction pattern for ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " delta function slits modulated by the diffraction pattern of a single slit \
of finite width. The latter thus acts as an envelope, shown by the thick \
dashed line. Special cases of this system include the single (",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "1"}], TraditionalForm]], "InlineMath"],
 ") and double (",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "2"}], TraditionalForm]], "InlineMath"],
 ") slits, which appear in introductory physics courses. The horizontal scale \
is arbitrary and the vertical scale normalized to the peak intensity."
}], "ManipulateCaption",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444695869239983*^9, 3.444696062134519*^9}, {
   3.444696671063671*^9, 3.444696734925806*^9}, {3.444696767814446*^9, 
   3.444696855152974*^9}, {3.444697719630142*^9, 3.4446977290563917`*^9}, {
   3.4446993148781843`*^9, 3.444699338536785*^9}, {3.4447708378066564`*^9, 
   3.4447708391503973`*^9}, 3.444783657709056*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ThumbnailSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.5, $CellContext`b$$ = 
    2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 2, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 0.5, "slit width"}, 0, 1}, {{
       Hold[$CellContext`b$$], 2.5, "slit spacing"}, 1, 5}, {{
       Hold[$CellContext`n$$], 2, "number of slits"}, {1, 2, 3, 4, 5, 6, 7, 8,
       9, 10}}, {{
       Hold[$CellContext`kmax$$], 10, "horizontal range"}, 1, 100}}, 
    Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`a$7567$$ =
     0, $CellContext`b$7568$$ = 0, $CellContext`n$7569$$ = 
    0, $CellContext`kmax$7570$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.5, $CellContext`b$$ = 
        2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$7567$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$7568$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$7569$$, 0], 
        Hold[$CellContext`kmax$$, $CellContext`kmax$7570$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{(((1/$CellContext`n$$) ChebyshevU[$CellContext`n$$ - 1, 
             Cos[$CellContext`b$$ ($CellContext`k/2)]]) 
          Sinc[$CellContext`a$$ ($CellContext`k/2)])^2, 
         Sinc[$CellContext`a$$ ($CellContext`k/
            2)]^2}, {$CellContext`k, -$CellContext`kmax$$, \
$CellContext`kmax$$}, PlotRange -> {0, 1}, Axes -> False, Frame -> True, 
        FrameTicks -> {True, False}, FrameLabel -> {"position", "intensity"}, 
        PlotLabel -> StringJoin[
          ToString[$CellContext`n$$], " slit diffraction pattern"], 
        Filling -> {1 -> Axis}, PlotStyle -> {Automatic, {Thick, Dashed}}, 
        ImageSize -> {500, 350}, ImagePadding -> {{40, 20}, {40, 20}}], 
      "Specifications" :> {{{$CellContext`a$$, 0.5, "slit width"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`b$$, 2.5, "slit spacing"}, 
         1, 5, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 2, "number of slits"}, {1, 2, 3, 4, 
         5, 6, 7, 8, 9, 10}, ControlType -> SetterBar}, 
        Delimiter, {{$CellContext`kmax$$, 10, "horizontal range"}, 1, 100, 
         Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{547., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->985615296]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SnapshotsSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0., $CellContext`b$$ = 
    2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 1, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 0., "slit width"}, 0, 1}, {{
       Hold[$CellContext`b$$], 2.5, "slit spacing"}, 1, 5}, {{
       Hold[$CellContext`n$$], 1, "number of slits"}, {1, 2, 3, 4, 5, 6, 7, 8,
       9, 10}}, {{
       Hold[$CellContext`kmax$$], 10, "horizontal range"}, 1, 100}}, 
    Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`a$7636$$ =
     0, $CellContext`b$7637$$ = 0, $CellContext`n$7638$$ = 
    0, $CellContext`kmax$7639$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0., $CellContext`b$$ = 
        2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$7636$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$7637$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$7638$$, 0], 
        Hold[$CellContext`kmax$$, $CellContext`kmax$7639$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{(((1/$CellContext`n$$) ChebyshevU[$CellContext`n$$ - 1, 
             Cos[$CellContext`b$$ ($CellContext`k/2)]]) 
          Sinc[$CellContext`a$$ ($CellContext`k/2)])^2, 
         Sinc[$CellContext`a$$ ($CellContext`k/
            2)]^2}, {$CellContext`k, -$CellContext`kmax$$, \
$CellContext`kmax$$}, PlotRange -> {0, 1}, Axes -> False, Frame -> True, 
        FrameTicks -> {True, False}, FrameLabel -> {"position", "intensity"}, 
        PlotLabel -> StringJoin[
          ToString[$CellContext`n$$], " slit diffraction pattern"], 
        Filling -> {1 -> Axis}, PlotStyle -> {Automatic, {Thick, Dashed}}, 
        ImageSize -> {500, 350}, ImagePadding -> {{40, 20}, {40, 20}}], 
      "Specifications" :> {{{$CellContext`a$$, 0., "slit width"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`b$$, 2.5, "slit spacing"}, 
         1, 5, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 1, "number of slits"}, {1, 2, 3, 4, 
         5, 6, 7, 8, 9, 10}, ControlType -> SetterBar}, 
        Delimiter, {{$CellContext`kmax$$, 10, "horizontal range"}, 1, 100, 
         Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{547., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->372097706],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0., $CellContext`b$$ = 
    2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 6, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 0., "slit width"}, 0, 1}, {{
       Hold[$CellContext`b$$], 2.5, "slit spacing"}, 1, 5}, {{
       Hold[$CellContext`n$$], 6, "number of slits"}, {1, 2, 3, 4, 5, 6, 7, 8,
       9, 10}}, {{
       Hold[$CellContext`kmax$$], 10, "horizontal range"}, 1, 100}}, 
    Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`a$7705$$ =
     0, $CellContext`b$7706$$ = 0, $CellContext`n$7707$$ = 
    0, $CellContext`kmax$7708$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0., $CellContext`b$$ = 
        2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 6}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$7705$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$7706$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$7707$$, 0], 
        Hold[$CellContext`kmax$$, $CellContext`kmax$7708$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{(((1/$CellContext`n$$) ChebyshevU[$CellContext`n$$ - 1, 
             Cos[$CellContext`b$$ ($CellContext`k/2)]]) 
          Sinc[$CellContext`a$$ ($CellContext`k/2)])^2, 
         Sinc[$CellContext`a$$ ($CellContext`k/
            2)]^2}, {$CellContext`k, -$CellContext`kmax$$, \
$CellContext`kmax$$}, PlotRange -> {0, 1}, Axes -> False, Frame -> True, 
        FrameTicks -> {True, False}, FrameLabel -> {"position", "intensity"}, 
        PlotLabel -> StringJoin[
          ToString[$CellContext`n$$], " slit diffraction pattern"], 
        Filling -> {1 -> Axis}, PlotStyle -> {Automatic, {Thick, Dashed}}, 
        ImageSize -> {500, 350}, ImagePadding -> {{40, 20}, {40, 20}}], 
      "Specifications" :> {{{$CellContext`a$$, 0., "slit width"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`b$$, 2.5, "slit spacing"}, 
         1, 5, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 6, "number of slits"}, {1, 2, 3, 4, 
         5, 6, 7, 8, 9, 10}, ControlType -> SetterBar}, 
        Delimiter, {{$CellContext`kmax$$, 10, "horizontal range"}, 1, 100, 
         Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{547., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->103037841],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.5, $CellContext`b$$ = 
    2.5, $CellContext`kmax$$ = 31.400000000000002`, $CellContext`n$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 0.5, "slit width"}, 0, 1}, {{
       Hold[$CellContext`b$$], 2.5, "slit spacing"}, 1, 5}, {{
       Hold[$CellContext`n$$], 1, "number of slits"}, {1, 2, 3, 4, 5, 6, 7, 8,
       9, 10}}, {{
       Hold[$CellContext`kmax$$], 31.400000000000002`, "horizontal range"}, 1,
       100}}, Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`a$7774$$ =
     0, $CellContext`b$7775$$ = 0, $CellContext`n$7776$$ = 
    0, $CellContext`kmax$7777$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.5, $CellContext`b$$ = 
        2.5, $CellContext`kmax$$ = 31.400000000000002`, $CellContext`n$$ = 1},
       "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$7774$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$7775$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$7776$$, 0], 
        Hold[$CellContext`kmax$$, $CellContext`kmax$7777$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{(((1/$CellContext`n$$) ChebyshevU[$CellContext`n$$ - 1, 
             Cos[$CellContext`b$$ ($CellContext`k/2)]]) 
          Sinc[$CellContext`a$$ ($CellContext`k/2)])^2, 
         Sinc[$CellContext`a$$ ($CellContext`k/
            2)]^2}, {$CellContext`k, -$CellContext`kmax$$, \
$CellContext`kmax$$}, PlotRange -> {0, 1}, Axes -> False, Frame -> True, 
        FrameTicks -> {True, False}, FrameLabel -> {"position", "intensity"}, 
        PlotLabel -> StringJoin[
          ToString[$CellContext`n$$], " slit diffraction pattern"], 
        Filling -> {1 -> Axis}, PlotStyle -> {Automatic, {Thick, Dashed}}, 
        ImageSize -> {500, 350}, ImagePadding -> {{40, 20}, {40, 20}}], 
      "Specifications" :> {{{$CellContext`a$$, 0.5, "slit width"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`b$$, 2.5, "slit spacing"}, 
         1, 5, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 1, "number of slits"}, {1, 2, 3, 4, 
         5, 6, 7, 8, 9, 10}, ControlType -> SetterBar}, 
        Delimiter, {{$CellContext`kmax$$, 31.400000000000002`, 
          "horizontal range"}, 1, 100, Appearance -> "Labeled"}}, 
      "Options" :> {}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{547., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->40596558],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.5, $CellContext`b$$ = 
    2.5, $CellContext`kmax$$ = 40.400000000000006`, $CellContext`n$$ = 6, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 0.5, "slit width"}, 0, 1}, {{
       Hold[$CellContext`b$$], 2.5, "slit spacing"}, 1, 5}, {{
       Hold[$CellContext`n$$], 6, "number of slits"}, {1, 2, 3, 4, 5, 6, 7, 8,
       9, 10}}, {{
       Hold[$CellContext`kmax$$], 40.400000000000006`, "horizontal range"}, 1,
       100}}, Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`a$7843$$ =
     0, $CellContext`b$7844$$ = 0, $CellContext`n$7845$$ = 
    0, $CellContext`kmax$7846$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.5, $CellContext`b$$ = 
        2.5, $CellContext`kmax$$ = 40.400000000000006`, $CellContext`n$$ = 6},
       "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$7843$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$7844$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$7845$$, 0], 
        Hold[$CellContext`kmax$$, $CellContext`kmax$7846$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{(((1/$CellContext`n$$) ChebyshevU[$CellContext`n$$ - 1, 
             Cos[$CellContext`b$$ ($CellContext`k/2)]]) 
          Sinc[$CellContext`a$$ ($CellContext`k/2)])^2, 
         Sinc[$CellContext`a$$ ($CellContext`k/
            2)]^2}, {$CellContext`k, -$CellContext`kmax$$, \
$CellContext`kmax$$}, PlotRange -> {0, 1}, Axes -> False, Frame -> True, 
        FrameTicks -> {True, False}, FrameLabel -> {"position", "intensity"}, 
        PlotLabel -> StringJoin[
          ToString[$CellContext`n$$], " slit diffraction pattern"], 
        Filling -> {1 -> Axis}, PlotStyle -> {Automatic, {Thick, Dashed}}, 
        ImageSize -> {500, 350}, ImagePadding -> {{40, 20}, {40, 20}}], 
      "Specifications" :> {{{$CellContext`a$$, 0.5, "slit width"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`b$$, 2.5, "slit spacing"}, 
         1, 5, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 6, "number of slits"}, {1, 2, 3, 4, 
         5, 6, 7, 8, 9, 10}, ControlType -> SetterBar}, 
        Delimiter, {{$CellContext`kmax$$, 40.400000000000006`, 
          "horizontal range"}, 1, 100, Appearance -> "Labeled"}}, 
      "Options" :> {}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{547., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->238972935]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "DetailsSection"],

Cell[TextData[{
 "For an array of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " slits of width ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and equal spacing ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", the intensity of the diffracted light on a screen may be neatly expressed \
as"
}], "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.44469782705196*^9, 3.444697903180908*^9}, {
   3.4446980436687813`*^9, 3.4446981188739643`*^9}, 3.444698198469324*^9, {
   3.444698284145123*^9, 3.4446982902943172`*^9}, {3.4447710557583866`*^9, 
   3.4447710579771223`*^9}},
 CellID->1753031548],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["I", 
     SubscriptBox["I", "0"]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "n"], 
       RowBox[{
        SubscriptBox["U", 
         RowBox[{"n", "-", "1"}]], "(", 
        RowBox[{"cos", "(", 
         FractionBox[
          RowBox[{"d", " ", "q"}], "2"], ")"}], ")"}], 
       RowBox[{"sinc", "(", 
        FractionBox[
         RowBox[{"a", " ", "q"}], "2"], ")"}]}], ")"}], "2"]}], 
   TraditionalForm]], "InlineMath"],
 ","
}], "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444698122709322*^9, 3.44469812854606*^9}, {
   3.44469820535495*^9, 3.4446982431120777`*^9}, {3.444698652185246*^9, 
   3.444698655084463*^9}, 3.4447710656489477`*^9},
 CellID->792659328],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "0"], TraditionalForm]], "InlineMath"],
 " is the peak intensity and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["U", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is the Chebyshev polynomial of the second kind, which appears when we \
simplify the ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sin", "(", 
     RowBox[{"n", " ", "x"}], ")"}], "/", 
    RowBox[{"sin", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444698219228907*^9, 3.444698295795158*^9}, {
   3.444698356058077*^9, 3.444698476620467*^9}, {3.4446986597971973`*^9, 
   3.444698677509001*^9}, {3.4446993590775747`*^9, 3.444699437188574*^9}, {
   3.444699478314205*^9, 3.444699497102639*^9}, {3.444699605226411*^9, 
   3.4446996065168743`*^9}, {3.4447711323047714`*^9, 3.4447711635233216`*^9}},
 
 CellID->1623859534],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " is a normalized wavenumber. It is related to the actual wavenumber ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 ", the perpendicular distance ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " from the diffraction grating to the screen on which the pattern is \
observed, and the distance from the center of the pattern ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    FractionBox[
     RowBox[{"k", " ", "x"}], "R"]}], TraditionalForm]], "InlineMath"],
 "."
}], "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444698219228907*^9, 3.444698295795158*^9}, {
   3.444698356058077*^9, 3.444698476620467*^9}, {3.4446986597971973`*^9, 
   3.444698777349516*^9}, 3.444752611989519*^9},
 CellID->832249800],

Cell[TextData[{
 "The formula for the intensity is valid within the Fraunhofer diffraction \
regime, for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"R", "\[GreaterGreater]", "a"}], ",", "d"}], TraditionalForm]], 
  "InlineMath"],
 ". In this case, the diffraction pattern is equivalent to the Fourier \
transform of the diffraction grating. This explains why, since an array of \
finite-width slits is equivalent to the ",
 StyleBox["convolution",
  FontSlant->"Italic"],
 " of an array of delta function slits with a single slit, the resulting \
diffraction pattern is the ",
 StyleBox["product",
  FontSlant->"Italic"],
 " of the two corresponding diffraction patterns."
}], "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444698219228907*^9, 3.444698295795158*^9}, {
   3.444698356058077*^9, 3.444698476620467*^9}, {3.4446987875484543`*^9, 
   3.444698821562478*^9}, {3.444698869504168*^9, 3.444698878803769*^9}, {
   3.444698954772476*^9, 3.4446991092127542`*^9}, {3.4447711996480904`*^9, 
   3.4447712265229187`*^9}, {3.444783704214055*^9, 3.4447837069709272`*^9}, {
   3.444783758417289*^9, 3.44478376414078*^9}},
 CellID->1985001862],

Cell["\<\
Snapshot 1: for a single, infinitely narrow slit, the diffraction pattern is \
constant; this is essentially because the Fourier transform of the delta \
function is constant\
\>", "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444698891734022*^9, 3.4446989518354177`*^9}, {
   3.444699113161319*^9, 3.4446991317112093`*^9}, {3.4447713037255497`*^9, 
   3.444771306881779*^9}, {3.445014537390895*^9, 3.445014542328332*^9}},
 CellID->1061395689],

Cell["\<\
Snapshot 2: for multiple infinitely narrow slits, there is an infinitely \
repeating pattern of peaks and troughs, corresponding to \
constructive/destructive interference between paths from different slits\
\>", "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444699134049574*^9, 3.444699198624036*^9}, 
   3.44475261630095*^9, 3.4450145589531193`*^9},
 CellID->1878173041],

Cell["\<\
Snapshot 3: for a single slit of finite width, the diffraction pattern has \
the well-known form of a sinc function\
\>", "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4446991999897633`*^9, 3.444699249236923*^9}, 
   3.4447713286941395`*^9},
 CellID->592172834],

Cell["\<\
Snapshot 4: for multiple slits of finite width, the diffraction is a pattern \
of peaks and troughs modulated by the sinc function pattern arising from the \
finite width of each slit\
\>", "DetailNotes",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444699250166274*^9, 3.4446992931118307`*^9}, 
   3.4447713449752855`*^9},
 CellID->1209600840]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ControlSuggestionsSection"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[True], Cell[" Resize Images"]}],
  "\"Click inside an image to reveal its orange resize frame.\\nDrag any of \
the orange resize handles to resize the image.\"",
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.35696210375764*^9, 3.4447525537126923`*^9},
 FontFamily->"Verdana",
 CellTags->"ResizeImages"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Rotate and Zoom in 3D"]}],
  RowBox[{
   "\"Drag a 3D graphic to rotate it. Starting the drag near the center \
tumbles\\nthe graphic; starting near a corner turns it parallel to the plane \
of the screen.\\nHold down \"", 
    FrameBox[
    "Ctrl", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" (or \"", 
    FrameBox[
    "Cmd", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" on Mac) and drag up and down to zoom.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"RotateAndZoomIn3D"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Drag Locators"]}],
  RowBox[{"\"Drag any locator (\"", 
    GraphicsBox[
     LocatorBox[
      Scaled[{0.5, 0.5}]], ImageSize -> 20], 
    "\", etc.) to move it around.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"DragLocators"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Create and Delete Locators"]}],
  RowBox[{"\"Insert a new locator in the graphic by holding down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], 
    "\" key\\nand clicking where you want it to be. Delete a locator by \
clicking it\\nwhile holding down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" key.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"CreateAndDeleteLocators"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Slider Zoom"]}],
  RowBox[{"\"Hold down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], 
    "\" key while moving a slider to make fine adjustments in the slider \
value.\\nHold \"", 
    FrameBox[
    "Ctrl", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" and/or \"", 
    FrameBox[
    "Shift", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" at the same time as \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" to make ever finer adjustments.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"SliderZoom"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Gamepad Controls"]}],
  "\"Control this Demonstration with a gamepad or other\\nhuman interface \
device connected to your computer.\"",
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.35696210375764*^9, 3.3895522232313623`*^9},
 FontFamily->"Verdana",
 CellTags->"GamepadControls"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Automatic Animation"]}],
  RowBox[{"\"Animate a slider in this Demonstration by clicking the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIKwAgOI/R/IhBKc\n\
/4EAyGAG0f+nTZsGwgysIJIRKsWKLAXGIHFmEpUgLADxWUAkI24jZs+eTaEt\n\
IG+wQKRmzJgBlYf5lhEA30OqWA=="], "Graphics", ImageSize -> {9, 9}, ImageMargins -> 
      0, CellBaseline -> Baseline], BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"button\\nnext to the slider, and then clicking the play button that \
appears.\\nAnimate all controls by selecting \"", 
    StyleBox["Autorun", FontWeight -> "Bold"], "\" from the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJyNULENwyAQfEySIlMwTVJlCGRFsosokeNtqBmDBagoaZjAI1C8/8GUUUC6\n\
57h7cQ8PvU7Pl17nUav7oj/TPH7V7b2QJAUAXBkKmCPRowxICy64bRvGGNF7\n\
X8CctGoDSN4xhIDGGDhzFXwUh3/ClBKrDQPmnGXtI6u0OOd+tZBVUqy1xSaH\n\
UqiK6pPe4XdEdAz6563tx/gejuORGMxJaz8mdpJn7hc="], "Graphics", 
      ImageSize -> {10, 10}, ImageMargins -> 0, CellBaseline -> Baseline], 
     BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"menu.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"AutomaticAnimation"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Bookmark Animation"]}],
  RowBox[{
   "\"See a prepared animation of this Demonstration by selecting\\n\"", 
    StyleBox["Animate Bookmarks", FontWeight -> "Bold"], "\" from the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJyNULENwyAQfEySIlMwTVJlCGRFsosokeNtqBmDBagoaZjAI1C8/8GUUUC6\n\
57h7cQ8PvU7Pl17nUav7oj/TPH7V7b2QJAUAXBkKmCPRowxICy64bRvGGNF7\n\
X8CctGoDSN4xhIDGGDhzFXwUh3/ClBKrDQPmnGXtI6u0OOd+tZBVUqy1xSaH\n\
UqiK6pPe4XdEdAz6563tx/gejuORGMxJaz8mdpJn7hc="], "Graphics", 
      ImageSize -> {10, 10}, ImageMargins -> 0, CellBaseline -> Baseline], 
     BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"menu.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"BookmarkAnimation"]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SearchTermsSection"],

Cell["diffraction", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444696949976984*^9, 3.444696951476158*^9}},
 CellID->287021756],

Cell["Fraunhofer diffraction", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444697757193808*^9, 3.444697762767041*^9}},
 CellID->1526404607],

Cell["diffraction grating", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444697748046713*^9, 3.444697750767118*^9}},
 CellID->673583192],

Cell["multiple slit", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444696956292172*^9, 3.444696959490367*^9}},
 CellID->900577786],

Cell["single slit", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4446969525928698`*^9, 3.444696953851317*^9}},
 CellID->726381930],

Cell["double slit", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444696954625876*^9, 3.444696955638337*^9}},
 CellID->2004047962]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "RelatedLinksSection"],

Cell[TextData[ButtonBox["Diffraction Grating",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://scienceworld.wolfram.com/physics/DiffractionGrating.html"], 
   None},
 ButtonNote->
  "http://scienceworld.wolfram.com/physics/DiffractionGrating.html"]], \
"RelatedLinks",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444697375999477*^9, 3.44469738194133*^9}},
 CellID->261966647],

Cell[TextData[ButtonBox["Fraunhofer Diffraction",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://scienceworld.wolfram.com/physics/FraunhoferDiffraction.html"], 
   None},
 ButtonNote->
  "http://scienceworld.wolfram.com/physics/FraunhoferDiffraction.html"]], \
"RelatedLinks",
 CellChangeTimes->{
  3.35696210375764*^9, {3.44469780977109*^9, 3.444697815952379*^9}},
 CellID->442582787],

Cell[TextData[ButtonBox["Fraunhofer Diffraction\[LongDash]Single Slit",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://scienceworld.wolfram.com/physics/\
FraunhoferDiffractionSingleSlit.html"], None},
 ButtonNote->
  "http://scienceworld.wolfram.com/physics/FraunhoferDiffractionSingleSlit.\
html"]], "RelatedLinks",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444697412627439*^9, 3.444697422744285*^9}, {
   3.444752558964217*^9, 3.444752560443365*^9}},
 CellID->531959779],

Cell[TextData[ButtonBox["Fraunhofer Diffraction\[LongDash]Double Slit",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://scienceworld.wolfram.com/physics/\
FraunhoferDiffractionDoubleSlit.html"], None},
 ButtonNote->
  "http://scienceworld.wolfram.com/physics/FraunhoferDiffractionDoubleSlit.\
html"]], "RelatedLinks",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444699635311412*^9, 3.444699670484639*^9}, {
   3.4447525630456257`*^9, 3.444752563952716*^9}},
 CellID->1805421872],

Cell[TextData[ButtonBox["Sin",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Sin/16/05/02/0004/"],
    None},
 ButtonNote->
  "http://functions.wolfram.com/ElementaryFunctions/Sin/16/05/02/0004/"]], \
"RelatedLinks",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444699543108138*^9, 3.444699593923209*^9}, {
   3.4447525795102715`*^9, 3.4447525840407248`*^9}},
 CellID->935407016]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "AuthorSection"],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Peter Falloon",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Peter+Falloon"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Peter+Falloon"]
}], "Author",
 CellChangeTimes->{
  3.35696210375764*^9, {3.444696988214715*^9, 3.444696989788248*^9}, {
   3.4447526004633665`*^9, 3.4447526004633665`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{700, 681},
WindowMargins->{{10, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Demonstration.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ResizeImages"->{
  Cell[31933, 737, 376, 9, 22, "ControlSuggestions",
   CellTags->"ResizeImages"]},
 "RotateAndZoomIn3D"->{
  Cell[32312, 748, 678, 16, 22, "ControlSuggestions",
   CellTags->"RotateAndZoomIn3D"]},
 "DragLocators"->{
  Cell[32993, 766, 340, 11, 22, "ControlSuggestions",
   CellTags->"DragLocators"]},
 "CreateAndDeleteLocators"->{
  Cell[33336, 779, 637, 15, 22, "ControlSuggestions",
   CellTags->"CreateAndDeleteLocators"]},
 "SliderZoom"->{
  Cell[33976, 796, 844, 21, 22, "ControlSuggestions",
   CellTags->"SliderZoom"]},
 "GamepadControls"->{
  Cell[34823, 819, 369, 9, 22, "ControlSuggestions",
   CellTags->"GamepadControls"]},
 "AutomaticAnimation"->{
  Cell[35195, 830, 1464, 31, 22, "ControlSuggestions",
   CellTags->"AutomaticAnimation"]},
 "BookmarkAnimation"->{
  Cell[36662, 863, 908, 21, 22, "ControlSuggestions",
   CellTags->"BookmarkAnimation"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ResizeImages", 41717, 1021},
 {"RotateAndZoomIn3D", 41825, 1024},
 {"DragLocators", 41934, 1027},
 {"CreateAndDeleteLocators", 42049, 1030},
 {"SliderZoom", 42162, 1033},
 {"GamepadControls", 42267, 1036},
 {"AutomaticAnimation", 42379, 1039},
 {"BookmarkAnimation", 42495, 1042}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 148, 2, 74, "DemoTitle"],
Cell[718, 26, 33, 0, 266, "InitializationSection"],
Cell[CellGroupData[{
Cell[776, 30, 29, 0, 188, "ManipulateSection"],
Cell[CellGroupData[{
Cell[830, 34, 3689, 97, 368, "Input"],
Cell[4522, 133, 3300, 61, 547, "Output",
 CellID->341469225]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7868, 200, 36, 0, 166, "ManipulateCaptionSection"],
Cell[7907, 202, 1382, 29, 115, "ManipulateCaption"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9326, 236, 28, 0, 168, "ThumbnailSection"],
Cell[9357, 238, 3229, 60, 547, "Output",
 CellID->985615296]
}, Open  ]],
Cell[CellGroupData[{
Cell[12623, 303, 28, 0, 144, "SnapshotsSection"],
Cell[12654, 305, 3225, 60, 547, "Output",
 CellID->372097706],
Cell[15882, 367, 3225, 60, 547, "Output",
 CellID->103037841],
Cell[19110, 429, 3299, 60, 547, "Output",
 CellID->40596558],
Cell[22412, 491, 3300, 60, 547, "Output",
 CellID->238972935]
}, Open  ]],
Cell[CellGroupData[{
Cell[25749, 556, 26, 0, 338, "DetailsSection"],
Cell[25778, 558, 668, 18, 38, "DetailNotes",
 CellID->1753031548],
Cell[26449, 578, 797, 26, 37, "DetailNotes",
 CellID->792659328],
Cell[27249, 606, 979, 28, 39, "DetailNotes",
 CellID->1623859534],
Cell[28231, 636, 935, 26, 65, "DetailNotes",
 CellID->832249800],
Cell[29169, 664, 1169, 26, 83, "DetailNotes",
 CellID->1985001862],
Cell[30341, 692, 468, 9, 37, "DetailNotes",
 CellID->1061395689],
Cell[30812, 703, 397, 8, 52, "DetailNotes",
 CellID->1878173041],
Cell[31212, 713, 286, 7, 37, "DetailNotes",
 CellID->592172834],
Cell[31501, 722, 355, 8, 37, "DetailNotes",
 CellID->1209600840]
}, Open  ]],
Cell[CellGroupData[{
Cell[31893, 735, 37, 0, 120, "ControlSuggestionsSection"],
Cell[31933, 737, 376, 9, 22, "ControlSuggestions",
 CellTags->"ResizeImages"],
Cell[32312, 748, 678, 16, 22, "ControlSuggestions",
 CellTags->"RotateAndZoomIn3D"],
Cell[32993, 766, 340, 11, 22, "ControlSuggestions",
 CellTags->"DragLocators"],
Cell[33336, 779, 637, 15, 22, "ControlSuggestions",
 CellTags->"CreateAndDeleteLocators"],
Cell[33976, 796, 844, 21, 22, "ControlSuggestions",
 CellTags->"SliderZoom"],
Cell[34823, 819, 369, 9, 22, "ControlSuggestions",
 CellTags->"GamepadControls"],
Cell[35195, 830, 1464, 31, 22, "ControlSuggestions",
 CellTags->"AutomaticAnimation"],
Cell[36662, 863, 908, 21, 22, "ControlSuggestions",
 CellTags->"BookmarkAnimation"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37607, 889, 30, 0, 152, "SearchTermsSection"],
Cell[37640, 891, 144, 3, 22, "SearchTerms",
 CellID->287021756],
Cell[37787, 896, 156, 3, 22, "SearchTerms",
 CellID->1526404607],
Cell[37946, 901, 152, 3, 22, "SearchTerms",
 CellID->673583192],
Cell[38101, 906, 146, 3, 22, "SearchTerms",
 CellID->900577786],
Cell[38250, 911, 146, 3, 22, "SearchTerms",
 CellID->726381930],
Cell[38399, 916, 145, 3, 22, "SearchTerms",
 CellID->2004047962]
}, Open  ]],
Cell[CellGroupData[{
Cell[38581, 924, 31, 0, 138, "RelatedLinksSection"],
Cell[38615, 926, 384, 10, 22, "RelatedLinks",
 CellID->261966647],
Cell[39002, 938, 393, 10, 70, "RelatedLinks",
 CellID->442582787],
Cell[39398, 950, 484, 11, 70, "RelatedLinks",
 CellID->531959779],
Cell[39885, 963, 487, 11, 70, "RelatedLinks",
 CellID->1805421872],
Cell[40375, 976, 431, 11, 70, "RelatedLinks",
 CellID->935407016]
}, Open  ]],
Cell[CellGroupData[{
Cell[40843, 992, 25, 0, 70, "AuthorSection"],
Cell[40871, 994, 443, 12, 70, "Author"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
