(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 10.2' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1064,         20]
NotebookDataLength[     91963,       1982]
NotebookOptionsPosition[     64165,       1364]
NotebookOutlinePosition[     90414,       1925]
CellTagsIndexPosition[     90303,       1919]
WindowTitle->Fraunhofer Diffraction through a Rectangular Aperture
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 ButtonBox[
  GraphicsBox[RasterBox[CompressedData["
1:eJztvXmUXldxL8p6zzeKUCRHkqVWz3O3utWTutWjWq1u9dz9SdbgSZ7AI1OY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    "], {{0, 0}, {1714, 38}}, {0, 255},
    ColorFunction->RGBColor],
   ImageSize->{1714, 38},
   PlotRange->{{0, 1714}, {0, 38}}],
  Alignment->Left,
  BaseStyle->{"Hyperlink", "DemonstrationHeader"},
  ButtonData->{
    URL["http://demonstrations.wolfram.com"], None},
  ButtonNote->"http://demonstrations.wolfram.com"]], "DemonstrationHeader"],

Cell["Fraunhofer Diffraction through a Rectangular Aperture", "DemoTitle"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.09, $CellContext`b$$ = 
    0.09, $CellContext`color$$ = "violet", $CellContext`z$$ = 900, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`b$$], 0.09, "length (cm)"}, 0.01, 0.1, 0.01}, {{
       Hold[$CellContext`a$$], 0.09, "breadth (cm)"}, 0.01, 0.1, 0.01}, {{
       Hold[$CellContext`z$$], 900, "distance (cm)"}, 100, 1000, 100}, {
      Hold[$CellContext`color$$], {"violet", "green", "orange"}}}, 
    Typeset`size$$ = {424., {185., 190.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`b$36240$$ = 0, $CellContext`a$36241$$ = 
    0, $CellContext`z$36242$$ = 0, $CellContext`color$36243$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.09, $CellContext`b$$ = 
        0.09, $CellContext`color$$ = "violet", $CellContext`z$$ = 900}, 
      "ControllerVariables" :> {
        Hold[$CellContext`b$$, $CellContext`b$36240$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$36241$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$36242$$, 0], 
        Hold[$CellContext`color$$, $CellContext`color$36243$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ContourPlot[(
          Sin[((Pi $CellContext`b$$) $CellContext`x)/($CellContext`\[Lambda] = 
            Which[$CellContext`color$$ == "violet", 4 
               10^(-5), $CellContext`color$$ == "green", 5 
               10^(-5), $CellContext`color$$ == "orange", 6 
               10^(-5)] $CellContext`z$$)]/(((
            Pi $CellContext`b$$) $CellContext`x)/($CellContext`\[Lambda] = 
          Which[$CellContext`color$$ == "violet", 4 
             10^(-5), $CellContext`color$$ == "green", 5 
             10^(-5), $CellContext`color$$ == "orange", 6 
             10^(-5)] $CellContext`z$$)))^2 (
          Sin[((Pi $CellContext`a$$) $CellContext`y)/($CellContext`\[Lambda] = 
            Which[$CellContext`color$$ == "violet", 4 
               10^(-5), $CellContext`color$$ == "green", 5 
               10^(-5), $CellContext`color$$ == "orange", 6 
               10^(-5)] $CellContext`z$$)]/(((
            Pi $CellContext`a$$) $CellContext`y)/($CellContext`\[Lambda] = 
          Which[$CellContext`color$$ == "violet", 4 
             10^(-5), $CellContext`color$$ == "green", 5 
             10^(-5), $CellContext`color$$ == "orange", 6 
             10^(-5)] $CellContext`z$$)))^2, {$CellContext`x, -2, 
         2}, {$CellContext`y, -2, 2}, ColorFunction -> 
        Which[$CellContext`color$$ == "violet", 
          Blend[{Black, Purple, LightPurple}, #]& , $CellContext`color$$ == 
          "green", "AvocadoColors", $CellContext`color$$ == "orange", 
          Blend[{Black, Red, Orange, LightOrange}, #]& ], PlotLegends -> 
        Automatic, PlotLabel -> "intensity profile", FrameLabel -> {
          Row[{
            Style["x", Italic], " (cm)"}], 
          Row[{
            Style["y", Italic], " (cm)"}]}, Contours -> 100, ContourStyle -> 
        None, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{{$CellContext`b$$, 0.09, "length (cm)"}, 0.01, 
         0.1, 0.01, ControlType -> 
         Setter}, {{$CellContext`a$$, 0.09, "breadth (cm)"}, 0.01, 0.1, 0.01, 
         ControlType -> Setter}, {{$CellContext`z$$, 900, "distance (cm)"}, 
         100, 1000, 100, ControlType -> Setter}, {$CellContext`color$$, {
         "violet", "green", "orange"}}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{471., {266., 273.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->125649460],

Cell["\<\
This Demonstration illustrates Fraunhofer optical diffraction through a \
rectangular aperture. The length and breadth determine the dimensions of the \
aperture in cm (length is along the horizontal axis and breadth along the \
vertical axis). The distance control specifies the distance between the \
aperture and the screen. Color is related to the wavelength of light used to \
illuminate the aperture. Violet corresponds to 400nm, green is around 500nm \
and orange is at 600nm. You can change the parameters to observe the \
variation in the intensity profile on the screen.\
\>", "ManipulateCaption",
 CellID->736269831],

Cell["THINGS TO TRY", "ManipulateCaption",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047],
 CellTags->"ControlSuggestions"],

Cell[TextData[{
 Cell[BoxData[
  TooltipBox[
   PaneSelectorBox[{False->Cell[TextData[StyleBox["Resize Images",
     FontFamily->"Verdana"]]], True->Cell[TextData[StyleBox["Resize Images",
     FontFamily->"Verdana",
     FontColor->GrayLevel[0.5]]]]}, Dynamic[
     CurrentValue["MouseOver"]]],
   "\"Click inside an image to reveal its orange resize frame.\\nDrag any of \
the orange resize handles to resize the image.\"",
   TooltipStyle->{
    FontFamily -> "Verdana", FontSize -> 10, FontColor -> GrayLevel[0.35], 
     Background -> GrayLevel[0.98]}]]],
 StyleBox["\[NonBreakingSpace]\[FilledVerySmallSquare]\[NonBreakingSpace]",
  FontColor->RGBColor[0.928786, 0.43122, 0.104662]],
 Cell[BoxData[
  TooltipBox[
   PaneSelectorBox[{False->Cell[TextData[StyleBox["Slider Zoom",
     FontFamily->"Verdana"]]], True->Cell[TextData[StyleBox["Slider Zoom",
     FontFamily->"Verdana",
     FontColor->GrayLevel[0.5]]]]}, Dynamic[
     CurrentValue["MouseOver"]]],
   RowBox[{"\"Hold down the \"", 
     FrameBox[
     "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
      GrayLevel[0.9]], 
     "\" key while moving a slider to make fine adjustments in the slider \
value.\\nHold \"", 
     FrameBox[
     "Ctrl", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
      GrayLevel[0.9]], "\" and/or \"", 
     FrameBox[
     "Shift", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
      GrayLevel[0.9]], "\" at the same time as \"", 
     FrameBox[
     "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
      GrayLevel[0.9]], "\" to make ever finer adjustments.\""}],
   TooltipStyle->{
    FontFamily -> "Verdana", FontSize -> 10, FontColor -> GrayLevel[0.35], 
     Background -> GrayLevel[0.98]}]]],
 StyleBox["\[NonBreakingSpace]\[FilledVerySmallSquare]\[NonBreakingSpace]",
  FontColor->RGBColor[0.928786, 0.43122, 0.104662]],
 Cell[BoxData[
  TooltipBox[
   PaneSelectorBox[{False->Cell[TextData[StyleBox["Gamepad Controls",
     FontFamily->"Verdana"]]], True->Cell[TextData[StyleBox["Gamepad Controls",
     FontFamily->"Verdana",
     FontColor->GrayLevel[0.5]]]]}, Dynamic[
     CurrentValue["MouseOver"]]],
   "\"Control this Demonstration with a gamepad or other\\nhuman interface \
device connected to your computer.\"",
   TooltipStyle->{
    FontFamily -> "Verdana", FontSize -> 10, FontColor -> GrayLevel[0.35], 
     Background -> GrayLevel[0.98]}]]],
 StyleBox["\[NonBreakingSpace]\[FilledVerySmallSquare]\[NonBreakingSpace]",
  FontColor->RGBColor[0.928786, 0.43122, 0.104662]],
 Cell[BoxData[
  TooltipBox[
   PaneSelectorBox[{False->Cell[TextData[StyleBox["Automatic Animation",
     FontFamily->"Verdana"]]], True->Cell[TextData[StyleBox[
    "Automatic Animation",
     FontFamily->"Verdana",
     FontColor->GrayLevel[0.5]]]]}, Dynamic[
     CurrentValue["MouseOver"]]],
   RowBox[{"\"Animate a slider in this Demonstration by clicking the\"", 
     AdjustmentBox[
      Cell[
       GraphicsData[
       "CompressedBitmap", 
        "eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIKwAgOI/R/IhBKc\n\
/4EAyGAG0f+nTZsGwgysIJIRKsWKLAXGIHFmEpUgLADxWUAkI24jZs+eTaEt\n\
IG+wQKRmzJgBlYf5lhEA30OqWA=="], "Graphics", ImageSize -> {9, 9}, ImageMargins -> 
       0, CellBaseline -> Baseline], BoxBaselineShift -> 0.1839080459770115, 
      BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
     "\"button\\nnext to the slider, and then clicking the play button that \
appears.\\nAnimate all controls by selecting \"", 
     StyleBox["Autorun", FontWeight -> "Bold"], "\" from the\"", 
     AdjustmentBox[
      Cell[
       GraphicsData[
       "CompressedBitmap", 
        "eJyNULENwyAQfEySIlMwTVJlCGRFsosokeNtqBmDBagoaZjAI1C8/8GUUUC6\n\
57h7cQ8PvU7Pl17nUav7oj/TPH7V7b2QJAUAXBkKmCPRowxICy64bRvGGNF7\n\
X8CctGoDSN4xhIDGGDhzFXwUh3/ClBKrDQPmnGXtI6u0OOd+tZBVUqy1xSaH\n\
UqiK6pPe4XdEdAz6563tx/gejuORGMxJaz8mdpJn7hc="], "Graphics", 
       ImageSize -> {10, 10}, ImageMargins -> 0, CellBaseline -> Baseline], 
      BoxBaselineShift -> 0.1839080459770115, 
      BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
     "\"menu.\""}],
   TooltipStyle->{
    FontFamily -> "Verdana", FontSize -> 10, FontColor -> GrayLevel[0.35], 
     Background -> GrayLevel[0.98]}]]]
}], "ManipulateCaption",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 Deployed->True,
 FontFamily->"Verdana",
 CellTags->"ControlSuggestions"],

Cell["DETAILS", "DetailsSection"],

Cell["\<\
The Fraunhofer diffraction pattern is the Fourier transform of the aperture \
function. It is obtained by evaluating the Fraunhofer diffraction integral. \
\>", "DetailNotes",
 CellID->606813693],

Cell[TextData[Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.85], EdgeForm[Thickness[Tiny]], 
   RectangleBox[{0.013405292479108627`, -0.01787372330547865}, \
{0.5134052924791086, 0.7821262766945216}], 
   {GrayLevel[1], RectangleBox[{0.8, 0.8}, {1.3, 1.6}], 
    {EdgeForm[Thickness[Tiny]], RectangleBox[{0.18, 0.27}, {0.32, 0.53}], 
     {GrayLevel[0], Thickness[Large], LineBox[{{0.25, 0.4}, {1.05, 1.2}}], 
      {Arrowheads[Medium], ArrowBox[{{0.25, 0.4}, {0.25, 1}}], 
       ArrowBox[{{0.25, 0.4}, {0.7, 0.4}}], 
       ArrowBox[{{1.05, 1.2}, {1.05, 1.8}}], 
       ArrowBox[{{1.05, 1.2}, {1.5, 1.2}}], PointBox[{1.18, 1.45}]}, 
      {Thickness[Tiny], Arrowheads[{-Small, Small}], 
       ArrowBox[{{0.18, 0.24}, {0.32, 0.24}}], 
       ArrowBox[{{0.15, 0.27}, {0.15, 0.53}}], 
       StyleBox[InsetBox[
         StyleBox["\<\"x\"\>",
          StripOnInput->False,
          FontSize->15], {1.54, 1.1955315691736301`}],
        FontSlant->"Italic"], 
       StyleBox[InsetBox[
         StyleBox["\<\"y\"\>",
          StripOnInput->False,
          FontSize->15], {1.05, 1.85}],
        FontSlant->"Italic"], InsetBox[
        StyleBox["\<\"P\"\>",
         StripOnInput->False,
         FontSize->18], {1.23, 1.45}], InsetBox[
        StyleBox["\<\"o\"\>",
         StripOnInput->False,
         FontSize->15], {0.24, 0.37}], InsetBox[
        StyleBox["\<\"o'\"\>",
         StripOnInput->False,
         FontSize->15], {1.05, 1.15}], InsetBox[
        StyleBox["\<\"\[Xi]\"\>",
         StripOnInput->False,
         FontSize->15], {0.75, 0.4}], InsetBox[
        StyleBox["\<\"\[Eta]\"\>",
         StripOnInput->False,
         FontSize->15], {0.25, 1.05}], InsetBox[
        StyleBox["\<\"screen\"\>",
         StripOnInput->False,
         FontSize->17], {1.1, 0.85}], 
       StyleBox[InsetBox[
         StyleBox["\<\"z\"\>",
          StripOnInput->False,
          FontSize->15], {0.7, 0.78}],
        FontSlant->"Italic"], 
       StyleBox[InsetBox[
         StyleBox["\<\"b\"\>",
          StripOnInput->False,
          FontSize->15], {0.25, 0.19}],
        FontSlant->"Italic"], 
       StyleBox[InsetBox[
         StyleBox["\<\"a\"\>",
          StripOnInput->False,
          FontSize->15], {0.11, 0.39553156917362997`}],
        FontSlant->"Italic"]}}}}},
  ImagePadding->{{0., 1.}, {1., 3.1072}},
  PlotRange->{{-0.03208333333333334, 1.5720833333333333`}, {-0.0308, 1.8808}},
  PlotRangePadding->Automatic]]]], "DetailNotes",
 CellID->1640796739],

Cell[TextData[{
 "Consider a screen in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " plane. The rectangular aperture is in a plane parallel to it (the ",
 Cell[BoxData[
  FormBox["\[Xi]", TraditionalForm]], "InlineMath"],
 "-",
 Cell[BoxData[
  FormBox["\[Eta]", TraditionalForm]], "InlineMath"],
 " plane). The perpendicular distance between the screen and aperture is \
given by ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ". The dimensions of the aperture are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "\[Times]", "a"}], TraditionalForm]], "InlineMath"],
 ". "
}], "DetailNotes",
 CellID->168092040],

Cell[TextData[{
 "Consider a monochromatic plane wave normally incident on the aperture. The \
field distribution at a point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["P",
     FontSlant->"Plain"], "(", 
    RowBox[{"x", ",", "y", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
 " on the screen is given by the Fraunhofer diffraction integral:"
}], "DetailNotes",
 CellID->757893124],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", "P", ")"}], "=", 
    RowBox[{
     FractionBox["A", 
      RowBox[{"i", "\[Lambda]", "z"}]], 
     TagBox[
      SuperscriptBox["e", 
       RowBox[{"i", "k", "z"}]],
      "MathMLPresentationTag",
      AutoDelete->True], 
     RowBox[{"exp", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"i", "k"}], 
        RowBox[{"2", "z"}]], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}], "]"}], 
     RowBox[{
      UnderoverscriptBox[
       StyleBox["\[Integral]",
        SpanMinSize->1.,
        SpanMaxSize->1.], 
       RowBox[{
        RowBox[{"-", "b"}], "/", "2"}], 
       RowBox[{"b", "/", "2"}]], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{
         RowBox[{"-", "i"}], "u", "\[Xi]"}]], "d", "\[InvisibleSpace]", 
       "\[Xi]", 
       RowBox[{
        UnderoverscriptBox[
         StyleBox["\[Integral]",
          SpanMinSize->1.,
          SpanMaxSize->1.], 
         RowBox[{
          RowBox[{"-", "a"}], "/", "2"}], 
         RowBox[{"a", "/", "2"}]], 
        RowBox[{
         SuperscriptBox["e", 
          RowBox[{
           RowBox[{"-", "i"}], "v", "\[Eta]"}]], "d", "\[InvisibleSpace]", 
         "\[Eta]"}]}]}]}]}]}], TraditionalForm]], "InlineMath"],
 ","
}], "DetailNotes",
 CellID->1921895297],

Cell["where ", "DetailNotes",
 CellID->549626501],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"u", "=", 
     FractionBox[
      RowBox[{"2", "\[Pi]", "x"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 ","
}], "DetailNotes",
 CellID->1245436560],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"v", "=", 
     FractionBox[
      RowBox[{"2", "\[Pi]", "y"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 ","
}], "DetailNotes",
 CellID->1464268441],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is the amplitude of the incident plane wave in the plane of the aperture. \
The value of the integral turns out to be"
}], "DetailNotes",
 CellID->529156611],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", "P", ")"}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "b", "a"}], 
      RowBox[{"i", "\[Lambda]", "z"}]], 
     SuperscriptBox["e", 
      RowBox[{"i", "k", "z"}]], " ", 
     RowBox[{"exp", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"i", "k"}], 
        RowBox[{"2", "z"}]], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}], "]"}], 
     FractionBox[
      RowBox[{"sin", " ", "\[Beta]"}], "\[Beta]"], 
     FractionBox[
      RowBox[{"sin", " ", "\[Gamma]"}], "\[Gamma]"]}]}], TraditionalForm]], 
  "InlineMath"],
 ","
}], "DetailNotes",
 CellID->324870060],

Cell["where", "DetailNotes",
 CellID->1187667746],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"\[Beta]", "=", 
     FractionBox[
      RowBox[{"\[Pi]", "b", "x"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 " "
}], "DetailNotes",
 CellID->271308157],

Cell["and ", "DetailNotes",
 CellID->768412118],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"\[Gamma]", "=", 
     FractionBox[
      RowBox[{"\[Pi]", "a", "y"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 ". "
}], "DetailNotes",
 CellID->1883297815],

Cell["\<\
The intensity of a light wave is proportional to the square of the amplitude, \
hence the intensity distribution on the screen is given by\
\>", "DetailNotes",
 CellID->824903572],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"I", "(", "P", ")"}], "=", 
    RowBox[{
     SubscriptBox["I", "0"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["sin", "2"], "\[Beta]"}], 
      SuperscriptBox["\[Beta]", "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox["sin", "2"], "\[Gamma]"}], 
      SuperscriptBox["\[Gamma]", "2"]]}]}], TraditionalForm]], "InlineMath"],
 ","
}], "DetailNotes",
 CellID->2058789831],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   TagBox[
    SubscriptBox["I", "0"],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 " is a constant. In this Demonstration, the intensity distribution has been \
plotted schematically (for simplicity, ",
 Cell[BoxData[
  FormBox[
   TagBox[
    SubscriptBox["I", "0"],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 " has been taken to be unity)."
}], "DetailNotes",
 CellID->1824169153],

Cell["\<\
Snapshot 1: pattern obtained from a square aperture (0.1cm x 0.1cm) and \
violet light at a distance of 1000cm\
\>", "DetailNotes",
 CellID->205771602],

Cell["\<\
Snapshot 2: pattern obtained from a square aperture (0.1cm x 0.1cm) and green \
light at a distance of 1000cm\
\>", "DetailNotes",
 CellID->512271610],

Cell["\<\
Snapshot 3: pattern obtained from a square aperture (0.1cm x 0.1cm) and \
orange light at a distance of 1000cm\
\>", "DetailNotes",
 CellID->75475726],

Cell["\<\
As the wavelength of the light increases, the width (the spacing between \
bright or dark spots) of the pattern also increases. This is seen clearly in \
the first three Snapshots.\
\>", "DetailNotes",
 CellID->88935465],

Cell["\<\
Snapshots 4 and 5: the single slit limit is obtained when one of the \
dimensions is much larger in comparison to the other\
\>", "DetailNotes",
 CellID->7160609],

Cell["\<\
Snapshot 6: if the dimension of the aperture decreases (0.05cm x 0.05cm in \
this case), then the width of the pattern increases, and vice versa; compare \
with Snapshot 1\
\>", "DetailNotes",
 CellID->16557886],

Cell["References", "DetailNotes",
 CellID->1241893507],

Cell[TextData[{
 "[1] A. Ghatak, ",
 StyleBox["Optics",
  FontSlant->"Italic"],
 ", 5th ed., India: Tata McGraw-Hill Education Pvt. Ltd, 2012."
}], "DetailNotes",
 CellID->243227928],

Cell[TextData[{
 "[2] Wikipedia. \"Visible Spectrum.\" (Mar 14, 2018) ",
 ButtonBox["en.wikipedia.org/wiki/Visible_spectrum",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://en.wikipedia.org/wiki/Visible_spectrum"], None},
  ButtonNote->"https://en.wikipedia.org/wiki/Visible_spectrum"],
 "."
}], "DetailNotes",
 CellID->18447758],

Cell["RELATED LINKS", "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Fraunhofer Diffraction\[LongDash]Rectangular Aperture",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://scienceworld.wolfram.com/physics/\
FraunhoferDiffractionRectangularAperture.html"], None},
  ButtonNote->
   "http://scienceworld.wolfram.com/physics/\
FraunhoferDiffractionRectangularAperture.html"],
 " (",
 StyleBox[ButtonBox["ScienceWorld",
  BaseStyle->"SiteLink",
  ButtonData->{
    URL["http://scienceworld.wolfram.com/"], None},
  ButtonNote->"http://scienceworld.wolfram.com/"],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks",
 CellID->435327720],

Cell[BoxData[
 ButtonBox[
  PaneSelectorBox[{False->Cell[BoxData[
    GraphicsBox[RasterBox[CompressedData["
1:eJztmklPHVcQhVGSRX5B9vkpyU9wJG+RLSWwCziRwvPO3hl2hhXDhmHFtMCW
FxADEYNBsg1CzCGQOIMUHg9bwhuQRb70EZXK7eH149lBkftItOrWrVt1qu7p
FkJ8evPra1990NDQ8M3HPK7d+O6zW7dulL74iMXnpW+/vPkhxif8/MDP3/b5
+fmbN29OT09PTk5evnx5fHxcqVSOI1QiYLyKwK55BDyvHIJlGtLCso8H3NIQ
BFSlZAHe8L2n5U8spKe2gkFl8NRgM1pIvBR/1hDPnI08M0zc5SyCQTaI5zxC
uVze39//sUCBGoFsEI9UtLe3d9V0CvxfgXikIlsWKJAHUos97VtUoMClUahI
mJubm5yc5HnVRP7B+vr6ZISrJlIdUtFPtaOtre26A8uJiQnbZQL37t1rbGxk
686dO9yObeEkWLZ2fc7u7m7ZU1NT7HojIy1O0cAYHh7GIBI/lJqamljev3/f
J/cgiWIEbEubVg5KOsKuMls7bFlmyimspaXFhoPBEidpOSuecbBllIikKU8Y
MvJDwDLg16Xw9KyqVuRgf3+/Iv0l5odUtO+Acz8HINne3v79BbDhiWG7DJDe
Hzx4gA3/jY0N/CwbI2ATrAvSlk719PTITlSRpaVZpWUmTEBzJlLD1wB1kKvE
0NjjKuI4Z9l9+vQpS57cCyUyyuHHyb3AH7Z6KcTZT0BbnMUjVs+ePcOWIDHY
IoC5xWdrZ7EZDktOMTotVZElATBRdfmVWfHy56xIO5yCIQHWQgYCkcRVlBP+
xgXoQQYDMn6ealAzaY/Acn5+fmBgQNek+QQ51b430tKShyQmRfJrgGYIBAeE
AWclaQ9VyejC+30V74cSyf1w9K55SgzBejdQyOcJZislWLMaDlQDP7JJHEJi
RcvDLiPyw8wJqeggAsuD3CiVSlT0noWFBZg8f/5clBKDYfjw4UOWIyMjdIpT
uorntCRxI0i7ubmpLzbJSxeIM4wTBrCFtveoCs6MLnTLcuJRucDvbZ9BSTyC
GOaDHuI88QflfKHAb8s8FQWugzFiUL2zszMxJg1eRTUh8VLUkebP5ZpfH0zJ
DL/Eo4+nH1oeFcXTyiY5qfQq2QD9NHxwHBzn08ERSkjVGeVyqkj3HgzNS13i
D2LiOgl2ddcC9ExF3k/jNoSqFQ8ilXILvNq6juDNqgqp6OfaAaXe3t7ACcPH
jx9jSM9yQgz/4uIinrt37+IhRr92KoBgYpQT/9bWFvbg4KACCPaR8bQrKyv4
VRdogMpg2ZQkThiQwT5l6MfypJXzbQJyqpz8Fk+n5ieYVPCEErVECVBOA/Hw
CRPZSp/WLJnNL3rkx2lDqFpRbAFhDIEjadXTIBX9UjukIu9hSjTCE3t0dBS7
ublZF9TR0YGTJX4F4ySD7I4Iykk8YfomyDk9PY2tyMS0yqCE8qvK9vY2S82T
J6cCwtYIePLkSXwrrRw2rGTr0s1PpCVUUd+LyokSWxjxuhTFnzF5NatBWbN+
CBwXjZwV8SAhxkUqZJlROg1S0YvaAau+vj7v6erqgqctV1dXh4aGiIGkPDMz
Mzs7O7JxEmCRipGTME6NjY3ZKYaTkVZ49OhRXwTizUk58uDkVJywQHJ/BJvI
7HK+ESNvfuOArbNwi1Nly5J44AwovYhNm4rKYDP0mTVA30V2xfpRj4oQ/8wF
9CIE43orCFR0aaSpCD9voq6DZ2trK8v6y9UD3kc+GnqPJMu4rrIRqOhdQyr6
tXbcvn37ugPDR0KXyFMVUlH9eSDMbOP+paUlyFsjhO3u7tZfrk5AVX9M018L
x8fHaz1OI++IWxxS0W/vPZaXl2dnZ9fW1q6ayL8wGyFn8H+mGRCULlRUoH5I
Rb8XKFAHTEV/FChwKZiKyuWyRJURWSitQACpwv5j9uzs7PXr15VK5fDw8M8k
4D86OkrbLfAeAjEgGGSDeJDQX/iUS2c=
      "], {{0, 0}, {194, 22}}, {0, 255},
      ColorFunction->RGBColor],
     ImageSize->{194, 22},
     PlotRange->{{0, 194}, {0, 22}}]]], True->Cell[BoxData[
    GraphicsBox[RasterBox[CompressedData["
1:eJztmjtPJFcQhZHtwL/AuX+K/RPWklO0K9mCyAJbshZCCIEMyHhEQMYjApGA
gYBnwivgLdmM17bMDEgTAMKf54hy7b3dPTO0MbLdR9pW3bp1q07VPd0gtJ++
+ebV1x+0tLR8+zGPV6+//6yz8/XbLz5i8fnb77568yHGJ/xb5t+f9sPDw/39
/e3tbbVavbm5ub6+rlQq1zVUasC4eYR5hJt/Fp5bGoKAPIUSa/nhpBXSVjCo
DJ52JC1z4qX4s4Y4c91O684wcZezCAbZIJ6HGsrl8uXl5Y8FCjQJZIN4pKKX
5lLg341CRQXyo1BRgfwoVCSsr68vLS3xfGkif+Ho6GiphpcmUh9S0U/No6ur
60sHlvPz87Z7fHzc19fX2trKVk9Pz8bGhm3hJFi2dn3OkZER2cvLy+x6IyMt
TtHAmJ6exiASP5Ta2tpYDg4O+uQeJFGMgG1p08pBSUfYVWZrhy3LTDmFdXR0
2HAwWOIkLWfFMwZbRolImvKEISM/BCwDfl0KT8+qbkUOTkxMKNJfYuOQii4d
cF42AEj29/f/8AhseGLYLgOk94WFBWz4n5yc4GfZWgM2wbogbenU6Oio7EQV
WVqaVVpmwgQ0ZyI1fA1QB7lKDI09VhHHOcvu7u4uS57cCyUyyuHHyb3AH7Z6
KcTZT0BbnMUzNDTE1t7eHrYEicEWAcwtnq2dxWY4LDnF6LRURZYEwETV5Vdm
xcvfYEXa4RQMCbAWMhCIJFZRg/A3LkAPMhiQ8fNUg5pJfw0sNzc3uX1dk+YT
5FT73khLSx6SmBTJrwGaIRAcEAZSYOBUlYwuvN9X8X4okdwPR++ap8QQrHcD
hXyeYLZSgjWr4UA18CObxCEkVrQ87DIiP8wGIRWVamBZahjd3d1U9J6trS2Y
7O/vi1JisDTDcmZmpre3F6d0Fee0JLERpD09PdUXm+Tdj4gZxoQBbKHtPaqC
M6ML3bKceFQu8HvbZ1ASjyBGn+uYJ/6gnC8U+G3ZSEWB62CMGFTn45kYkwav
oqaQeCnqSPPncs2vD6Zkhl/i0cfTD60RFcVpZZOcVHqVbIB+Gj44BscnJyc5
QgmpOqNcgyrSvQdD81KX+IOYWCfBru5agJ6pyPtp3IZQt2KpplJugVdb1xG8
WXXxHCoqva9niOntxoPgS7UL0q+dCiBYA1fLujjuNP4EJabVBOz6bIBksGxK
kqgiMtinTD93bCuxXClTRRZPp+bXb4DwhBK1TJmU00A8slWkN9H0STm9g/KL
Hvlx2hDqVhRbQBhD4Eha9TRIRT83D0iOjY15z8HBAY3wxJ6dndW9dHZ26u3G
yRK/gnGSQbZ+qCkn8Xp37NTKygq2IhPTKoMSyq8qZ2dnLDVPnpwKCFsjgPnH
W2nlsGElm5zWCH4iLaGK+l5UTpTY0lsfF8WfMXk1q0FZs34IHBeNBiviQUKM
i1TDw8MZpdMgFb1rHlKR90Cgvb3dlshpamqKmO3tbXlWV1fPz89l4yTAIhUj
J2GcoiM7xXAy0gqLi4tjNRBvTsqRByenYsICyf0RbCKzy/lGjLz5jQO2zsIt
psqWJfHAGVB6F02bispgM/SZNUDfRXbF/MijooGBgdVHYNN7MK6/BYGKnow0
FeHnTdR18OQtZpm/XB7wPvLR0HskWca6ykagoueGVPRL89CH2sDwkdAT8tTF
2toa+fPngfD4+Hjs39nZ0Q8sgbCLi4v85XICqvpjmv5aODc31+xxGnkmbjGe
rKL/GNAScj08PHxpIu9hrYaXZlEfhYoK5IdU9GuBAjlgKvqtQIEnwVRULpcl
qozIQmkFAkgV9j9m7+7uqtVqpVK5urr6PQn4CU7bLfA/BGJAMMgG8SChPwBG
7X9c
      "], {{0, 0}, {194, 22}}, {0, 255},
      ColorFunction->RGBColor],
     ImageSize->{194, 22},
     PlotRange->{{0, 194}, {0, 22}}]]]}, Dynamic[
    CurrentValue["MouseOver"]]],
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/versions/source.jsp?id=\
FraunhoferDiffractionThroughARectangularAperture&version=0015"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/\
FraunhoferDiffractionThroughARectangularAperture-source.nb"]], \
"DemoSourceNotebookSection",
 CellFrame->{{0, 0}, {1, 1}},
 ShowCellBracket->False,
 CellMargins->{{48, 48}, {28, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 8}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87]],

Cell["PERMANENT CITATION", "CitationSection"],

Cell[TextData[{
 "\[NonBreakingSpace]",
 ButtonBox["Radhika Prasad",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Radhika+Prasad"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Radhika+Prasad"]
}], "Author",
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "\"",
 ButtonBox["Fraunhofer Diffraction through a Rectangular Aperture",
  BaseStyle->"SiteLink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"],
 "\"",
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/",
  BaseStyle->"SiteLink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"SiteLink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 "Published: ",
 "May 2, 2018"
}], "Citations"],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 48}, {20, 50}},
 CellFrameColor->GrayLevel[0.45098],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6],
 CellTags->"Copyright"]
},
Editable->False,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
CellGrouping->Manual,
WindowSize->{650, 650},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Fraunhofer Diffraction through a Rectangular Aperture",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 7, 2015)",
StyleDefinitions->Notebook[{
   Cell[
    CellGroupData[{
      Cell[
      "Demonstration Styles", "Title", 
       CellChangeTimes -> {
        3.3509184553711*^9, {3.36928902713192*^9, 3.36928902738193*^9}, {
         3.3754479092466917`*^9, 3.3754479095123196`*^9}, {
         3.375558447161495*^9, 3.375558447395873*^9}, {3.37572892702972*^9, 
         3.375728927639103*^9}}], 
      Cell[
       StyleData[StyleDefinitions -> "Default.nb"]], 
      Cell[
       CellGroupData[{
         Cell[
         "Style Environment Names", "Section", 
          CellChangeTimes -> {{3.369277974278112*^9, 3.369277974396138*^9}}], 
         Cell[
          StyleData[All, "Working"], ShowCellBracket -> False]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Notebook Options", "Section", 
          CellChangeTimes -> {{3.374865264950812*^9, 3.374865265419568*^9}}], 
         Cell[
         "  The options defined for the style below will be used at the \
Notebook level.  ", "Text"], 
         Cell[
          StyleData["Notebook"], Editable -> True, 
          PageHeaders -> {{None, None, None}, {None, None, None}}, 
          PageFooters -> {{None, None, None}, {None, None, None}}, 
          PageHeaderLines -> {False, False}, 
          PageFooterLines -> {False, False}, 
          PrintingOptions -> {
           "FacingPages" -> False, "FirstPageFooter" -> False, 
            "RestPagesFooter" -> False}, CreateCellID -> True, 
          CellFrameLabelMargins -> 6, DefaultNewInlineCellStyle -> 
          "InlineMath", DefaultInlineFormatType -> 
          "DefaultTextInlineFormatType", ShowStringCharacters -> True, 
          CacheGraphics -> False, StyleMenuListing -> None, 
          DemonstrationSite`Private`TrackCellChangeTimes -> False]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Input/Output", "Section", 
          CellChangeTimes -> {{3.3756313297791014`*^9, 
           3.3756313299509783`*^9}}], 
         Cell[
         "The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    ", "Text"], 
         Cell[
          StyleData["Input"], CellMargins -> {{48, 4}, {6, 4}}], 
         Cell[
          StyleData["Output"], CellMargins -> {{48, 4}, {6, 4}}], 
         Cell[
          StyleData["DemonstrationHeader"], Deletable -> False, 
          CellFrame -> {{0, 0}, {0, 0}}, ShowCellBracket -> False, 
          CellMargins -> {{0, 0}, {30, 0}}, 
          CellGroupingRules -> {"SectionGrouping", 20}, 
          CellHorizontalScrolling -> True, 
          CellFrameMargins -> {{0, 0}, {0, 0}}, CellFrameColor -> 
          RGBColor[0, 0, 0], StyleMenuListing -> None, Background -> 
          RGBColor[0, 0, 0]], 
         Cell[
          StyleData["ShowSource"], CellFrame -> {{0, 0}, {0, 1}}, 
          ShowCellBracket -> False, CellMargins -> {{48, 48}, {8, 28}}, 
          CellFrameMargins -> {{48, 48}, {6, 8}}, CellFrameColor -> 
          RGBColor[0.87, 0.87, 0.87], StyleMenuListing -> None, FontFamily -> 
          "Helvetica", FontSize -> 10, FontWeight -> "Bold", FontSlant -> 
          "Plain", FontColor -> RGBColor[1, 0.42, 0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Basic Styles", "Section", 
          CellChangeTimes -> {{3.34971724802035*^9, 3.34971724966638*^9}, {
           3.35091840608065*^9, 3.35091840781999*^9}, {3.35091845122987*^9, 
           3.35091845356607*^9}, {3.35686681885432*^9, 3.35686681945788*^9}, {
           3.375657418186455*^9, 3.375657418452083*^9}}], 
         Cell[
          StyleData["Hyperlink"], StyleMenuListing -> None, FontColor -> 
          GrayLevel[0]], 
         Cell[
          StyleData["SiteLink"], StyleMenuListing -> None, 
          ButtonStyleMenuListing -> Automatic, FontColor -> 
          GrayLevel[0.45098], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FrontEndExecute[{
               NotebookLocate[#2]}]& ), ButtonNote -> ButtonData}], 
         Cell[
          StyleData["Link"], FontColor -> GrayLevel[0.45098]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DemoNotes"], CellFrame -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, 
             CellFrameMargins -> {{48, 48}, {4, 4}}, CellFrameColor -> 
             GrayLevel[0.99], StyleMenuListing -> None, FontFamily -> 
             "Verdana", FontSize -> 10, FontColor -> GrayLevel[0.45098], 
             DemonstrationSite`Private`ReturnCreatesNewCell -> True], 
            Cell[
             StyleData["DemoNotes", "Printout"], 
             CellMargins -> {{24, 0}, {0, 10}}, FontSize -> 9]}, Open]], 
         Cell[
          StyleData["SnapshotsSection"], CellFrame -> {{0, 0}, {0, 2}}, 
          ShowCellBracket -> False, ShowGroupOpener -> True, 
          CellMargins -> {{48, 48}, {10, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, 
          CellFrameMargins -> {{8, 8}, {8, 2}}, CellFrameColor -> 
          RGBColor[0.870588, 0.521569, 0.121569], DefaultNewCellStyle -> 
          "SnapshotCaption", StyleMenuListing -> None, FontFamily -> 
          "Verdana", FontSize -> 12, FontColor -> GrayLevel[0.45098], 
          PrivateCellOptions -> {"DefaultCellGroupOpen" -> False}], 
         Cell[
          StyleData[
          "SnapshotCaption", StyleDefinitions -> StyleData["DemoNotes"]], 
          ShowCellBracket -> False], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SnapshotOutput"], ShowCellBracket -> False, 
             CellMargins -> {{48, 10}, {5, 7}}, Evaluatable -> True, 
             CellGroupingRules -> "InputGrouping", PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, DefaultFormatType -> 
             DefaultInputFormatType, ShowAutoStyles -> True, 
             "TwoByteSyntaxCharacterAutoReplacement" -> True, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, 
             AutoItalicWords -> {}, LanguageCategory -> "Mathematica", 
             FormatType -> InputForm, NumberMarks -> True, 
             LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, CounterIncrements -> 
             "Input", MenuSortingValue -> 1500, MenuCommandKey -> "9", 
             DemonstrationSite`Private`StripStyleOnPaste -> True], 
            Cell[
             StyleData["SnapshotOuput", "Printout"], 
             CellMargins -> {{39, 0}, {4, 6}}, 
             LinebreakAdjustments -> {0.85, 2, 10, 1, 1}]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DemoTitle"], Deletable -> False, ShowCellBracket -> 
             False, CellMargins -> {{48, 48}, {22, 10}}, 
             CellGroupingRules -> {"SectionGrouping", 20}, StyleMenuListing -> 
             None, FontFamily -> "Verdana", FontSize -> 20, FontWeight -> 
             "Bold", FontColor -> RGBColor[0.597406, 0, 0.0527047], 
             Background -> GrayLevel[1]], 
            Cell[
             StyleData["DemoName", "Printout"], 
             CellMargins -> {{24, 8}, {8, 27}}, 
             HyphenationOptions -> {"HyphenationCharacter" -> "-"}, FontSize -> 
             16]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DetailsSection"], CellFrame -> {{0, 0}, {1, 0}}, 
             ShowCellBracket -> False, CellMargins -> {{48, 48}, {8, 28}}, 
             CellGroupingRules -> {"SectionGrouping", 25}, 
             CellFrameMargins -> {{48, 48}, {6, 8}}, CellFrameColor -> 
             RGBColor[0.87, 0.87, 0.87], StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 12, FontWeight -> "Bold", FontColor -> 
             RGBColor[0.597406, 0, 0.0527047]], 
            Cell[
             StyleData["DetailsSection", "Printout"], 
             CellMargins -> {{12, 0}, {0, 16}}, PageBreakBelow -> False, 
             FontSize -> 12]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DemoSection"], CellFrame -> {{0, 0}, {1, 0}}, 
             ShowCellBracket -> False, CellMargins -> {{48, 48}, {8, 28}}, 
             CellGroupingRules -> {"SectionGrouping", 30}, 
             CellFrameMargins -> {{48, 48}, {6, 8}}, CellFrameColor -> 
             RGBColor[0.87, 0.87, 0.87], StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 12, FontWeight -> "Bold", FontColor -> 
             RGBColor[0.597406, 0, 0.0527047]], 
            Cell[
             StyleData["DemoSection", "Printout"], 
             CellMargins -> {{12, 0}, {0, 16}}, PageBreakBelow -> False, 
             FontSize -> 12]}, Open]], 
         Cell[
          StyleData["ManipulateSection"], CellFrame -> {{0, 0}, {0, 2}}, 
          ShowCellBracket -> False, CellMargins -> {{48, 48}, {10, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, 
          CellFrameMargins -> {{8, 8}, {8, 2}}, CellFrameColor -> 
          RGBColor[0.870588, 0.521569, 0.121569], StyleMenuListing -> None, 
          FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ManipulateCaptionSection"], 
          CellFrame -> {{0, 0}, {0, 2}}, ShowCellBracket -> False, 
          CellMargins -> {{48, 48}, {10, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, 
          CellFrameMargins -> {{8, 8}, {8, 2}}, CellFrameColor -> 
          RGBColor[0.870588, 0.521569, 0.121569], DefaultNewCellStyle -> 
          "ManipulateCaption", StyleMenuListing -> None, FontFamily -> 
          "Verdana", FontSize -> 12, FontColor -> GrayLevel[0.45098]], 
         Cell[
          StyleData["ManipulateCaption"], ShowCellBracket -> False, 
          CellMargins -> {{48, 48}, {10, 16}}, StyleMenuListing -> None, 
          FontFamily -> "Verdana", FontSize -> 12, FontColor -> GrayLevel[0], 
          DemonstrationSite`Private`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData[
          "SeeAlsoSection", StyleDefinitions -> StyleData["DemoSection"]], 
          ShowCellBracket -> False, DefaultNewCellStyle -> "SeeAlso"], 
         Cell[
          StyleData["SeeAlso", StyleDefinitions -> StyleData["DemoNotes"]], 
          CellDingbat -> 
          Cell["\[FilledSmallSquare]", FontColor -> 
            RGBColor[0.928786, 0.43122, 0.104662]], ShowCellBracket -> False, 
          FontColor -> GrayLevel[0.45098]], 
         Cell[
          StyleData[
          "RelatedLinksSection", StyleDefinitions -> 
           StyleData["DemoSection"]], ShowCellBracket -> False, 
          DefaultNewCellStyle -> "RelatedLinks"], 
         Cell[
          StyleData[
          "RelatedLinks", StyleDefinitions -> StyleData["DemoNotes"], 
           FontColor -> RGBColor[0.928786, 0.43122, 0.104662]], 
          ShowCellBracket -> False, FontColor -> GrayLevel[0.45098]], 
         Cell[
          StyleData[
          "CategoriesSection", StyleDefinitions -> StyleData["DemoSection"]], 
          ShowCellBracket -> False, DefaultNewCellStyle -> "Categories"], 
         Cell[
          StyleData["Categories", StyleDefinitions -> StyleData["DemoNotes"]],
           ShowCellBracket -> False], 
         Cell[
          StyleData[
          "AuthorSection", StyleDefinitions -> StyleData["DemoSection"]], 
          ShowCellBracket -> False, CellMargins -> {{48, 48}, {4, 18}}, 
          CellElementSpacings -> {"CellMinHeight" -> 3}, 
          CellFrameMargins -> {{48, 48}, {6, 3}}, DefaultNewCellStyle -> 
          "Author", FontSize -> 1, FontColor -> GrayLevel[1]], 
         Cell[
          StyleData[
          "Author", StyleDefinitions -> StyleData["DemoNotes"], FontColor -> 
           GrayLevel[0.64]], ShowCellBracket -> False], 
         Cell[
          StyleData[
          "DetailNotes", StyleDefinitions -> StyleData["DemoNotes"]], 
          ShowCellBracket -> False, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData[
          "CitationSection", StyleDefinitions -> StyleData["DemoSection"]], 
          ShowCellBracket -> False, CellMargins -> {{48, 48}, {8, 14}}, 
          DefaultNewCellStyle -> "Categories"], 
         Cell[
          StyleData["Citations", StyleDefinitions -> StyleData["DemoNotes"]], 
          ShowCellBracket -> False, ParagraphSpacing -> {0, 6}], 
         Cell[
          StyleData[
          "RevisionSection", StyleDefinitions -> StyleData["DemoSection"]], 
          DefaultNewCellStyle -> "RevisionNotes"], 
         Cell[
          StyleData[
          "RevisionNotes", StyleDefinitions -> StyleData["DemoNotes"]], 
          ShowCellBracket -> False]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Specific Styles", "Section", 
          CellChangeTimes -> {{3.34971724802035*^9, 3.34971724966638*^9}, {
           3.35091840608065*^9, 3.35091840781999*^9}, {3.35091845122987*^9, 
           3.35091845356607*^9}, {3.36230868322317*^9, 3.36230868335672*^9}, {
           3.36928857618576*^9, 3.36928857640452*^9}, {3.3737586217185173`*^9,
            3.373758622077897*^9}}], 
         Cell[
          StyleData["InitializationSection"], CellFrame -> {{0, 0}, {0, 2}}, 
          ShowCellBracket -> False, CellMargins -> {{48, 48}, {10, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, 
          CellFrameMargins -> {{8, 8}, {8, 2}}, CellFrameColor -> 
          RGBColor[0.870588, 0.521569, 0.121569], StyleMenuListing -> None, 
          FontFamily -> "Verdana", FontSize -> 12, FontColor -> 
          GrayLevel[0.45098]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["AnchorBar"], ShowCellBracket -> False, 
             CellMargins -> {{48, 44}, {3, 6}}, StyleMenuListing -> None, 
             FontFamily -> "Verdana", FontSize -> 9, FontColor -> 
             GrayLevel[0.5]], 
            Cell[
             StyleData["AnchorBar", "Presentation"], FontSize -> 18], 
            Cell[
             StyleData["AnchorBar", "SlideShow"], StyleMenuListing -> None], 
            Cell[
             StyleData["AnchorBar", "Printout"], FontSize -> 9]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["AnchorLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, FontColor -> 
             RGBColor[0.5, 0.5, 0.5], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`NotebookLocate[#2]}]& ), ButtonNote -> 
               ButtonData}], 
            Cell[
             StyleData["AnchorLink", "Printout"], 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["GamePadStatus"], ShowCellBracket -> False, 
             CellMargins -> {{48, 48}, {5, 5}}, StyleMenuListing -> None, 
             FontFamily -> "Verdana", FontSize -> 10], 
            Cell[
             StyleData["GamePadStatus", "Printout"], 
             CellMargins -> {{24, 0}, {0, 10}}, FontSize -> 9]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DemoInstruction"], CellMargins -> {{48, 48}, {5, 5}}, 
             CellFrameLabelMargins -> 2, MenuSortingValue -> 800, 
             MenuCommandKey -> "8", StyleMenuListing -> None, FontFamily -> 
             "Verdana", FontSize -> 11, Background -> RGBColor[1, 0.85, 0.5], 
             DemonstrationSite`Private`ReturnCreatesNewCell -> True], 
            Cell[
             StyleData["DemoInstruction", "Printout"], 
             CellMargins -> {{24, 0}, {0, 10}}, Hyphenation -> True, 
             HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
             LineSpacing -> {1., 2, 2.}, FontSize -> 9]}, Open]], 
         Cell[
          StyleData[
          "ImplementationSection", StyleDefinitions -> 
           StyleData["DemoSection"]], Deletable -> True, DefaultNewCellStyle -> 
          "ImplementationNotes"], 
         Cell[
          StyleData[
          "ImplementationNotes", StyleDefinitions -> StyleData["DemoNotes"]]], 
         Cell[
          StyleData[
          "StatusSection", StyleDefinitions -> StyleData["DemoSection"]], 
          DefaultNewCellStyle -> "StatusNotes"], 
         Cell[
          StyleData[
          "StatusNotes", StyleDefinitions -> StyleData["DemoNotes"]]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SectionGloss"], StyleMenuListing -> None, FontSize -> 
             0.85 Inherited, FontWeight -> "Plain", FontColor -> 
             GrayLevel[0.6]], 
            Cell[
             StyleData["SectionGloss", "Printout"]]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineFormula"], 
             "TwoByteSyntaxCharacterAutoReplacement" -> True, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             "Formula", AutoSpacing -> True, ScriptLevel -> 1, 
             AutoMultiplicationSymbol -> False, SingleLetterItalics -> False, 
             SpanMaxSize -> 1, StyleMenuListing -> None, FontFamily -> 
             "Courier", FontSize -> 1.05 Inherited, 
             ButtonBoxOptions -> {Appearance -> {Automatic, None}}, 
             FractionBoxOptions -> {BaseStyle -> {SpanMaxSize -> Automatic}}, 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["InlineFormula", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineOutput"], CellHorizontalScrolling -> True, 
             "TwoByteSyntaxCharacterAutoReplacement" -> True, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             None, AutoMultiplicationSymbol -> False, StyleMenuListing -> 
             None, FontFamily -> "Courier", FontSize -> 1.05 Inherited], 
            Cell[
             StyleData["InlineOutput", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineMath"], DefaultFormatType -> 
             "DefaultTextFormatType", DefaultInlineFormatType -> 
             "TraditionalForm", LanguageCategory -> "Formula", AutoSpacing -> 
             True, ScriptLevel -> 1, AutoMultiplicationSymbol -> False, 
             SingleLetterItalics -> True, SpanMaxSize -> DirectedInfinity[1], 
             StyleMenuListing -> None, FontFamily -> "Times", FontSize -> 
             1.05 Inherited, 
             ButtonBoxOptions -> {Appearance -> {Automatic, None}}, 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["InlineMath", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TableBase"], CellMargins -> {{48, 48}, {4, 4}}, 
             SpanMaxSize -> 1, StyleMenuListing -> None, FontFamily -> 
             "Courier", FontSize -> 11, 
             ButtonBoxOptions -> {Appearance -> {Automatic, None}}, 
             GridBoxOptions -> {
              GridBoxAlignment -> {
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["TableBase", "Printout"], 
             CellMargins -> {{2, 0}, {0, 8}}, FontSize -> 9]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "1ColumnTableMod", StyleDefinitions -> StyleData["TableBase"]], 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.04], {
                    Scaled[0.966]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
                  "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.28], 
                   Offset[0.126], {
                    Offset[0.77]}, 
                   Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData[
             "1ColumnTableMod", "Printout", StyleDefinitions -> 
              StyleData["TableBase", "Printout"]], 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.078], {
                    Scaled[0.922]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
                  "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.28], {
                    Offset[0.56]}, 
                   Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.56]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "2ColumnTableMod", StyleDefinitions -> StyleData["TableBase"]], 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.05], 
                   Scaled[0.41], {
                    Scaled[0.565]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
                  "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.28], 
                   Offset[0.14], {
                    Offset[0.77]}, 
                   Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData[
             "2ColumnTableMod", "Printout", StyleDefinitions -> 
              StyleData["TableBase", "Printout"]], 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.079], 
                   Scaled[0.363], {
                    Scaled[0.558]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
                  "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.28], {
                    Offset[0.56]}, 
                   Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.56]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "3ColumnTableMod", StyleDefinitions -> StyleData["TableBase"]], 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.04], 
                   Scaled[0.266], 
                   Scaled[0.26], {
                    Scaled[0.44]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.28], 
                   Offset[0.14], {
                    Offset[0.77]}, 
                   Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData[
             "3ColumnTableMod", "Printout", StyleDefinitions -> 
              StyleData["TableBase", "Printout"]], 
             GridBoxOptions -> {GridBoxItemSize -> {"Columns" -> {
                   Scaled[0.08], 
                   Scaled[0.25], 
                   Scaled[0.25], {
                    Scaled[0.42]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
                 "RowsIndexed" -> {}}, GridBoxSpacings -> {"Columns" -> {
                   Offset[0.28], {
                    Offset[0.56]}, 
                   Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.56]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}}]}, Open]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TableText"], Deletable -> False, StyleMenuListing -> 
             None, FontFamily -> "Verdana", FontSize -> 0.952 Inherited], 
            Cell[
             StyleData["TableText", "Printout"], 
             CellMargins -> {{24, 0}, {0, 8}}, Hyphenation -> True, 
             HyphenationOptions -> {"HyphenationCharacter" -> "-"}, 
             LineSpacing -> {1., 2, 2.}]}, Open]], 
         Cell[
          StyleData["Continuation"], FontColor -> GrayLevel[1]]}, Closed]]}, 
     Open]]}, Visible -> False, FrontEndVersion -> 
  "10.2 for Microsoft Windows (64-bit) (July 7, 2015)", StyleDefinitions -> 
  "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ControlSuggestions"->{
  Cell[41036, 700, 258, 7, 70, "ManipulateCaption",
   CellTags->"ControlSuggestions"],
  Cell[41297, 709, 4440, 96, 70, "ManipulateCaption",
   CellTags->"ControlSuggestions"]},
 "Copyright"->{
  Cell[63343, 1339, 818, 23, 70, "Text",
   CellTags->"Copyright"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ControlSuggestions", 90016, 1908},
 {"Copyright", 90211, 1913}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[1531, 34, 34369, 568, 70, "DemonstrationHeader"],
Cell[35903, 604, 74, 0, 70, "DemoTitle"],
Cell[35980, 606, 4413, 80, 70, "Output",
 CellID->125649460],
Cell[40396, 688, 637, 10, 70, "ManipulateCaption",
 CellID->736269831],
Cell[41036, 700, 258, 7, 70, "ManipulateCaption",
 CellTags->"ControlSuggestions"],
Cell[41297, 709, 4440, 96, 70, "ManipulateCaption",
 CellTags->"ControlSuggestions"],
Cell[45740, 807, 33, 0, 70, "DetailsSection"],
Cell[45776, 809, 205, 4, 70, "DetailNotes",
 CellID->606813693],
Cell[45984, 815, 2469, 61, 70, "DetailNotes",
 CellID->1640796739],
Cell[48456, 878, 727, 23, 70, "DetailNotes",
 CellID->168092040],
Cell[49186, 903, 401, 11, 70, "DetailNotes",
 CellID->757893124],
Cell[49590, 916, 1399, 50, 70, "DetailNotes",
 CellID->1921895297],
Cell[50992, 968, 49, 1, 70, "DetailNotes",
 CellID->549626501],
Cell[51044, 971, 297, 12, 70, "DetailNotes",
 CellID->1245436560],
Cell[51344, 985, 297, 12, 70, "DetailNotes",
 CellID->1464268441],
Cell[51644, 999, 249, 7, 70, "DetailNotes",
 CellID->529156611],
Cell[51896, 1008, 740, 27, 70, "DetailNotes",
 CellID->324870060],
Cell[52639, 1037, 49, 1, 70, "DetailNotes",
 CellID->1187667746],
Cell[52691, 1040, 302, 12, 70, "DetailNotes",
 CellID->271308157],
Cell[52996, 1054, 47, 1, 70, "DetailNotes",
 CellID->768412118],
Cell[53046, 1057, 305, 12, 70, "DetailNotes",
 CellID->1883297815],
Cell[53354, 1071, 189, 4, 70, "DetailNotes",
 CellID->824903572],
Cell[53546, 1077, 464, 17, 70, "DetailNotes",
 CellID->2058789831],
Cell[54013, 1096, 522, 18, 70, "DetailNotes",
 CellID->1824169153],
Cell[54538, 1116, 161, 4, 70, "DetailNotes",
 CellID->205771602],
Cell[54702, 1122, 160, 4, 70, "DetailNotes",
 CellID->512271610],
Cell[54865, 1128, 160, 4, 70, "DetailNotes",
 CellID->75475726],
Cell[55028, 1134, 230, 5, 70, "DetailNotes",
 CellID->88935465],
Cell[55261, 1141, 172, 4, 70, "DetailNotes",
 CellID->7160609],
Cell[55436, 1147, 221, 5, 70, "DetailNotes",
 CellID->16557886],
Cell[55660, 1154, 54, 1, 70, "DetailNotes",
 CellID->1241893507],
Cell[55717, 1157, 182, 6, 70, "DetailNotes",
 CellID->243227928],
Cell[55902, 1165, 341, 9, 70, "DetailNotes",
 CellID->18447758],
Cell[56246, 1176, 44, 0, 70, "RelatedLinksSection"],
Cell[56293, 1178, 598, 18, 70, "RelatedLinks",
 CellID->435327720],
Cell[56894, 1198, 4981, 93, 70, "DemoSourceNotebookSection",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[61878, 1293, 45, 0, 70, "CitationSection"],
Cell[61926, 1295, 330, 10, 70, "Author"],
Cell[62259, 1307, 1081, 30, 70, "Citations"],
Cell[63343, 1339, 818, 23, 70, "Text",
 CellTags->"Copyright"]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature tQaM353V#HlX8vQVZuRl@a2q *)
