(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     28402,        716]
NotebookOptionsPosition[     27048,        665]
NotebookOutlinePosition[     27695,        690]
CellTagsIndexPosition[     27652,        687]
WindowTitle->Total Internal Reflection - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Total Internal Reflection", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"refractions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "\"\<vacuum\>\""}], ",", 
     RowBox[{"1.002", "\[Rule]", "\"\<air\>\""}], ",", 
     RowBox[{"1.31", "\[Rule]", "\"\<water ice\>\""}], ",", 
     RowBox[{"1.33", "\[Rule]", "\"\<water\>\""}], ",", 
     RowBox[{"1.36", "\[Rule]", "\"\<ethanol\>\""}], ",", 
     RowBox[{"1.491", "\[Rule]", "\"\<acrylic glass\>\""}], ",", 
     RowBox[{"1.516", "\[Rule]", "\"\<rock salt\>\""}], ",", 
     RowBox[{"1.525", "\[Rule]", "\"\<crown glass\>\""}], ",", 
     RowBox[{"1.61", "\[Rule]", "\"\<flint glass\>\""}], ",", 
     RowBox[{"2.419", "\[Rule]", "\"\<diamond\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, 3.390318682480095*^9, {3.3911872038167815`*^9, 
   3.3911872038167815`*^9}},
 CellID->609204314],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "=", 
       RowBox[{"aa", " ", "Degree"}]}], "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"catf", "=", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"Sin", "[", "a", "]"}], "]"}], "<", " ", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"{", 
             RowBox[{"r1", ",", "r2"}], "}"}], "]"}], "/", 
           RowBox[{"Max", "[", 
            RowBox[{"{", 
             RowBox[{"r1", ",", "r2"}], "}"}], "]"}]}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"outvec", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"r1", ">", "r2"}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{"catf", ",", 
               RowBox[{
                RowBox[{"3", 
                 RowBox[{"Pi", "/", "2"}]}], "+", 
                RowBox[{"ArcSin", "[", 
                 RowBox[{
                  RowBox[{"Sin", "[", "a", "]"}], 
                  RowBox[{"(", 
                   RowBox[{"r1", "/", "r2"}], ")"}]}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"Pi", "/", "2"}], "-", "a"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"3", 
               RowBox[{"Pi", "/", "2"}]}], "+", 
              RowBox[{"ArcSin", "[", 
               RowBox[{
                RowBox[{"Sin", "[", "a", "]"}], 
                RowBox[{"(", 
                 RowBox[{"r1", "/", "r2"}], ")"}]}], "]"}]}]}], "]"}]}], 
          "}"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"GrayLevel", "[", 
             RowBox[{".5", "+", 
              RowBox[{".33", "/", "r1"}]}], "]"}], ",", 
            RowBox[{"Polygon", "[", 
             RowBox[{"1.5", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"GrayLevel", "[", 
             RowBox[{".5", "+", 
              RowBox[{".33", "/", "r2"}]}], "]"}], ",", 
            RowBox[{"Polygon", "[", 
             RowBox[{"1.5", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", 
                  RowBox[{"-", "1"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"-", "1"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Lighter", "[", 
             RowBox[{"Orange", ",", ".5"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Disk", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Min", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Pi", "/", "2"}], "+", "a"}], ",", 
                  RowBox[{"Pi", "/", "2"}]}], "]"}], ",", 
                RowBox[{"Max", "[", 
                 RowBox[{
                  RowBox[{"Pi", "/", "2"}], ",", 
                  RowBox[{"Min", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Pi", "/", "2"}], "+", "a"}], ",", "Pi"}], 
                   "]"}]}], "]"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Lighter", "[", 
             RowBox[{"Cyan", ",", ".5"}], "]"}], ",", 
            RowBox[{"Disk", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"r1", ">", "r2"}], ",", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"a", "<", "0"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"If", "[", 
                   RowBox[{"catf", ",", 
                    RowBox[{"{", 
                    RowBox[{"outvec", ",", 
                    RowBox[{"3", 
                    RowBox[{"Pi", "/", "2"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Pi", "/", "2"}], ",", "outvec"}], "}"}]}], "]"}],
                   ",", 
                  RowBox[{"If", "[", 
                   RowBox[{"catf", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"3", 
                    RowBox[{"Pi", "/", "2"}]}], ",", "outvec"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"outvec", ",", 
                    RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"a", "<", "0"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"outvec", ",", 
                    RowBox[{"3", 
                    RowBox[{"Pi", "/", "2"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"3", 
                    RowBox[{"Pi", "/", "2"}]}], ",", "outvec"}], "}"}]}], 
                 "]"}]}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
            "Magenta", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{
                RowBox[{"-", "1.5"}], " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cos", "[", 
                   RowBox[{
                    RowBox[{"Pi", "/", "2"}], "+", "a"}], "]"}], ",", 
                  RowBox[{"Sin", "[", 
                   RowBox[{
                    RowBox[{"Pi", "/", "2"}], "+", "a"}], "]"}]}], "}"}]}]}], 
              "}"}], "]"}], ",", "Thick", ",", "Red", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"1.5", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", "Green", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"1.5", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", "Blue", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"Pi", "/", "2"}], "+", "a"}], "]"}], ",", 
                 RowBox[{"Sin", "[", 
                  RowBox[{
                   RowBox[{"Pi", "/", "2"}], "+", "a"}], "]"}]}], "}"}], ",", 
               
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", "outvec", "]"}], ",", 
                 RowBox[{"Sin", "[", "outvec", "]"}]}], "}"}]}], "}"}], 
             "]"}]}], "}"}], "]"}]}], "]"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "1.", ",", "\"\<refraction above\>\""}], "}"}], ",", 
     "1", ",", "3", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "1.", ",", "\"\<medium\>\""}], "}"}], ",", 
     "refractions"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "1.33", ",", "\"\<refraction below\>\""}], "}"}], 
     ",", "1", ",", "3", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Bottom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "1.33", ",", "\"\<medium\>\""}], "}"}], ",", 
     "refractions", ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Bottom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aa", ",", "66", ",", 
       RowBox[{"Dynamic", "@", 
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<incoming angle\>\"", ",", "aa"}], "}"}], ",", 
          "Center"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"-", "90"}], ",", "90", ",", 
     RowBox[{"ControlType", "\[Rule]", "VerticalSlider"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.3903243901247473`*^9, 3.3903243943402743`*^9}, {
   3.3903244364555845`*^9, 3.390324436965044*^9}, {3.3903244703695974`*^9, 
   3.390324495413024*^9}},
 CellID->1786799822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`aa$$ = 66, $CellContext`r1$$ = 
    1., $CellContext`r2$$ = 1.33, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r1$$], 1., "refraction above"}, 1, 3}, {{
       Hold[$CellContext`r1$$], 1., "medium"}, {
      1 -> "vacuum", 1.002 -> "air", 1.31 -> "water ice", 1.33 -> "water", 
       1.36 -> "ethanol", 1.491 -> "acrylic glass", 1.516 -> "rock salt", 
       1.525 -> "crown glass", 1.61 -> "flint glass", 2.419 -> "diamond"}}, {{
      
       Hold[$CellContext`r2$$], 1.33, "refraction below"}, 1, 3}, {{
       Hold[$CellContext`r2$$], 1.33, "medium"}, {
      1 -> "vacuum", 1.002 -> "air", 1.31 -> "water ice", 1.33 -> "water", 
       1.36 -> "ethanol", 1.491 -> "acrylic glass", 1.516 -> "rock salt", 
       1.525 -> "crown glass", 1.61 -> "flint glass", 2.419 -> "diamond"}}, {{
      
       Hold[$CellContext`aa$$], 66, 
       Dynamic[
        Column[{"incoming angle", $CellContext`aa$$}, Center]]}, -90, 90}}, 
    Typeset`size$$ = {360., {177., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`r1$29659$$ = 0, $CellContext`r2$29660$$ = 
    0, $CellContext`aa$29661$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`aa$$ = 66, $CellContext`r1$$ = 
        1., $CellContext`r2$$ = 1.33}, "ControllerVariables" :> {
        Hold[$CellContext`r1$$, $CellContext`r1$29659$$, 0], 
        Hold[$CellContext`r2$$, $CellContext`r2$29660$$, 0], 
        Hold[$CellContext`aa$$, $CellContext`aa$29661$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`a$ = $CellContext`aa$$ Degree}, 
        With[{$CellContext`catf$ = Abs[
             Sin[$CellContext`a$]] < 
           Min[{$CellContext`r1$$, $CellContext`r2$$}]/
            Max[{$CellContext`r1$$, $CellContext`r2$$}]}, 
         With[{$CellContext`outvec$ = 
           If[$CellContext`r1$$ > $CellContext`r2$$, 
             
             If[$CellContext`catf$, 3 (Pi/2) + 
              ArcSin[Sin[$CellContext`a$] \
($CellContext`r1$$/$CellContext`r2$$)], Pi/2 - $CellContext`a$], 3 (Pi/2) + 
             ArcSin[Sin[$CellContext`a$] \
($CellContext`r1$$/$CellContext`r2$$)]]}, 
          Graphics[{
            GrayLevel[0.5 + 0.33/$CellContext`r1$$], 
            Polygon[1.5 {{-1, 0}, {-1, 1}, {1, 1}, {1, 0}}], 
            GrayLevel[0.5 + 0.33/$CellContext`r2$$], 
            Polygon[1.5 {{-1, 0}, {-1, -1}, {1, -1}, {1, 0}}], 
            Lighter[Orange, 0.5], 
            Disk[{0, 0}, 1, {
              Min[Pi/2 + $CellContext`a$, Pi/2], 
              Max[Pi/2, 
               Min[Pi/2 + $CellContext`a$, Pi]]}], 
            Lighter[Cyan, 0.5], 
            Disk[{0, 0}, 1, 
             If[$CellContext`r1$$ > $CellContext`r2$$, 
              If[$CellContext`a$ < 0, 
               
               If[$CellContext`catf$, {$CellContext`outvec$, 3 (Pi/2)}, {
                Pi/2, $CellContext`outvec$}], 
               
               If[$CellContext`catf$, {
                3 (Pi/2), $CellContext`outvec$}, {$CellContext`outvec$, Pi/
                 2}]], 
              
              If[$CellContext`a$ < 0, {$CellContext`outvec$, 3 (Pi/2)}, {
               3 (Pi/2), $CellContext`outvec$}]]], Magenta, 
            Arrow[{{0, 0}, (-1.5) {
                Cos[Pi/2 + $CellContext`a$], 
                Sin[Pi/2 + $CellContext`a$]}}], Thick, Red, 
            Line[1.5 {{-1, 0}, {1, 0}}], Green, 
            Line[1.5 {{0, 1}, {0, -1}}], Blue, 
            Arrow[{{
               Cos[Pi/2 + $CellContext`a$], 
               Sin[Pi/2 + $CellContext`a$]}, {0, 0}}], 
            Arrow[{{0, 0}, {
               Cos[$CellContext`outvec$], 
               Sin[$CellContext`outvec$]}}]}]]]], 
      "Specifications" :> {{{$CellContext`r1$$, 1., "refraction above"}, 1, 3,
          Appearance -> "Labeled"}, {{$CellContext`r1$$, 1., "medium"}, {
         1 -> "vacuum", 1.002 -> "air", 1.31 -> "water ice", 1.33 -> "water", 
          1.36 -> "ethanol", 1.491 -> "acrylic glass", 1.516 -> "rock salt", 
          1.525 -> "crown glass", 1.61 -> "flint glass", 2.419 -> 
          "diamond"}}, {{$CellContext`r2$$, 1.33, "refraction below"}, 1, 3, 
         Appearance -> "Labeled", ControlPlacement -> 
         Bottom}, {{$CellContext`r2$$, 1.33, "medium"}, {
         1 -> "vacuum", 1.002 -> "air", 1.31 -> "water ice", 1.33 -> "water", 
          1.36 -> "ethanol", 1.491 -> "acrylic glass", 1.516 -> "rock salt", 
          1.525 -> "crown glass", 1.61 -> "flint glass", 2.419 -> "diamond"}, 
         ControlPlacement -> Bottom}, {{$CellContext`aa$$, 66, 
          Dynamic[
           Column[{"incoming angle", $CellContext`aa$$}, Center]]}, -90, 90, 
         ControlType -> VerticalSlider, ImageSize -> Large, ControlPlacement -> 
         Left}}, "Options" :> {AutorunSequencing -> {1, 3, 5}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{505., {273., 278.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(ReleaseHold[
       HoldComplete[{$CellContext`refractions = {
           1 -> "vacuum", 1.002 -> "air", 1.31 -> "water ice", 1.33 -> 
            "water", 1.36 -> "ethanol", 1.491 -> "acrylic glass", 1.516 -> 
            "rock salt", 1.525 -> "crown glass", 1.61 -> "flint glass", 2.419 -> 
            "diamond"}; Null}]]; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->20238235],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
A ray of light is bent on passing from air to a liquid because its wavefront \
moves more slowly in water than in air. This change in angle is proportional \
to the propagation velocities, which are often specified by giving the \
refractive indices of the materials. By definition, a vacuum has a refractive \
index of 1. \
\>", "Text"]
}, Close]]
}, Open  ]],

Cell["\<\
In passing from a slow to a fast medium, total reflection will occur if the \
angle between the incoming ray and the normal vector of the boundary surface \
is larger than the critical angle. In that case the incoming angle is equal \
to the outgoing angle.\
\>", "Text"],

Cell["\<\
The red line indicates the surface boundary which is hit by a ray, and the \
green line shows its normal vector. The angle between the ray and the surface \
normal is shown as an orange disk segment. The angle between refracted or \
reflected rays and the surface normal is shown as a cyan disk segment.\
\>", "Text"],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Total Internal Reflection",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/TotalInternalReflection/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/TotalInternalReflection/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/TotalInternalReflection/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/TotalInternalReflection/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/TotalInternalReflection/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Michael Schreiber",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Michael+\
Schreiber"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Michael+Schreiber"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
TotalInternalReflection"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Total Internal Reflection - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[627, 23, 145, 3, 70, "Section"],
Cell[775, 28, 3700, 64, 70, "Section"],
Cell[4478, 94, 879, 20, 70, "Input",
 InitializationCell->True,
 CellID->609204314],
Cell[5360, 116, 10483, 268, 70, "Input",
 CellID->1786799822]
}, Open  ]],
Cell[CellGroupData[{
Cell[15880, 389, 6133, 120, 70, "Output",
 CellID->20238235],
Cell[CellGroupData[{
Cell[22038, 513, 209, 6, 70, "Section"],
Cell[22250, 521, 347, 6, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[22623, 531, 281, 5, 70, "Text"],
Cell[22907, 538, 327, 5, 70, "Text"],
Cell[CellGroupData[{
Cell[23259, 547, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[23617, 558, 917, 24, 70, "Text"],
Cell[24537, 584, 445, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[25007, 602, 815, 24, 70, "Text"],
Cell[25825, 628, 1195, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature zT47CqpPuwlygDpWUgZXv2fA *)
