(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38521,        848]
NotebookOptionsPosition[     37440,        808]
NotebookOutlinePosition[     38066,        832]
CellTagsIndexPosition[     38023,        829]
WindowTitle->Reverberations in Acoustic Layers - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Reverberations in Acoustic Layers", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"nl", " ", "\[Equal]", " ", "3"}], ",", 
      RowBox[{"\[Rho]v", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{"\[Rho]v1", ",", "\[Rho]v2", ",", "\[Rho]v3"}], "}"}]}]}], 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"nl", " ", "\[Equal]", " ", "4"}], ",", 
      RowBox[{"\[Rho]v", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
        "\[Rho]v1", ",", "\[Rho]v2", ",", "\[Rho]v3", ",", "\[Rho]v4"}], 
        "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"nl", " ", "=", " ", 
       RowBox[{"Length", "[", "\[Rho]v", "]"}]}], ";", "  ", 
      RowBox[{
      "number", " ", "of", " ", "layers", " ", "includes", " ", "the", " ", 
       "bottom", " ", "and", " ", "top", " ", "half\[Hyphen]spaces"}]}], 
     "*)"}], "\[IndentingNewLine]", " ", 
    RowBox[{"nb", " ", "=", " ", 
     RowBox[{"nl", " ", "-", "1"}]}], ";", " ", 
    RowBox[{"(*", 
     RowBox[{
     "number", " ", "of", " ", "boundaries", " ", "is", " ", "one", " ", 
      "less", " ", "than", " ", "number", " ", "of", " ", "layers"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"r", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"\[Rho]v", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "-", " ", 
         RowBox[{"\[Rho]v", "[", 
          RowBox[{"[", 
           RowBox[{"i", "-", "1"}], "]"}], "]"}]}], 
        RowBox[{
         RowBox[{"\[Rho]v", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "+", " ", 
         RowBox[{"\[Rho]v", "[", 
          RowBox[{"[", 
           RowBox[{"i", "-", "1"}], "]"}], "]"}]}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "nl"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"reflection", " ", "coefficients"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"t", " ", "=", " ", 
     RowBox[{"1", " ", "+", " ", "r"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"transmission", " ", "coefficients"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"rp", " ", "=", " ", 
     RowBox[{"-", "r"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"tp", " ", "=", " ", 
     RowBox[{"1", " ", "+", " ", "rp"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"F", "=", "1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"G", "=", 
     RowBox[{"r", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"FF", "=", 
        RowBox[{"F", "+", 
         RowBox[{
          RowBox[{"r", "[", 
           RowBox[{"[", "k", "]"}], "]"}], "*", "z", "*", "G"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"GG", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"r", "[", 
           RowBox[{"[", "k", "]"}], "]"}], "*", "F"}], "+", 
         RowBox[{"z", "*", "G"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"F", "=", "FF"}], ";", "\[IndentingNewLine]", 
       RowBox[{"G", "=", "GG"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"k", ",", "2", ",", "nb"}], "}"}]}], "\[IndentingNewLine]", 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"T", " ", "=", " ", 
     RowBox[{
      SuperscriptBox["z", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"nl", "-", "2"}], ")"}], "/", "2"}]], 
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"tp", "[", 
          RowBox[{"[", "k", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "nb"}], "}"}]}], "]"}], "/", "F"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"R", "=", 
     RowBox[{"G", "/", "F"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "Because", " ", "inverse", " ", "Z", " ", "transform", " ", "only", " ",
        "works", " ", "for", " ", "integer", " ", "exponents"}], ",", " ", 
      RowBox[{
       RowBox[{
       "multiply", " ", "the", " ", "z", " ", "expression", " ", "for", " ", 
        "T", " ", "by", " ", 
        SuperscriptBox["z", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], " ", "when", " ", "nl", " ", "is", 
        " ", "odd", " ", 
        RowBox[{"only", ".", " ", "It"}], " ", "will", " ", "be", " ", 
        "compensated", " ", "by", " ", "a", " ", 
        RowBox[{"1", "/", "2"}], " ", "unit", " ", "shift", " ", "in", " ", 
        "time", " ", "sequence", " ", 
        RowBox[{"later", ".", " ", "The"}], " ", "one"}], "-", 
       RowBox[{
       "way", " ", "time", " ", "through", " ", "a", " ", "layer", " ", "is", 
        " ", "one"}], "-", 
       RowBox[{"half", " ", "unit", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", " ", "=", " ", 
           RowBox[{"1", "/", "2"}]}], ")"}], ".", " ", "For"}], " ", 
        "example"}]}], ",", " ", 
      RowBox[{
      "the", " ", "first", " ", "arrival", " ", "through", " ", "a", " ", 
       "stack", " ", "of", " ", "1", " ", "layer", " ", "between", " ", "2", 
       " ", "half\[Hyphen]spaces", " ", "is", " ", "given", " ", "by", " ", 
       "an", " ", "impulse", " ", "at", " ", 
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"1", "/", "2"}], "]"}], " ", "with", " ", "amplitude", " ", 
       "equal", " ", "to", " ", "the", " ", "product", " ", "of", " ", "the", 
       " ", "2", " ", "transmission", " ", 
       RowBox[{"factors", "."}]}]}], "*)"}], "\n", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"OddQ", "[", "nl", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"up", " ", "=", " ", 
       RowBox[{"InverseZTransform", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["z", 
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}]], "T"}], ")"}], "/.", 
          RowBox[{"z", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"1", "/", "z"}], ")"}]}]}], ",", "z", ",", "m"}], "]"}]}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"up", " ", "=", " ", 
       RowBox[{"InverseZTransform", "[", 
        RowBox[{
         RowBox[{"T", "/.", 
          RowBox[{"z", " ", "\[Rule]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "/", "z"}], ")"}]}]}], ",", "z", ",", "m"}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"down", " ", "=", " ", 
     RowBox[{"InverseZTransform", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "R"}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"1", "/", "z"}], ")"}]}]}], ",", "z", ",", "m"}], "]"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"shift", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"nl", "-", "2"}], ")"}], "/", "2"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"rseq", " ", "=", " ", 
     RowBox[{"Chop", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", "down", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", "0", ",", 
          RowBox[{"np", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tseq", " ", "=", " ", 
     RowBox[{"Chop", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", "up", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", "0", ",", 
          RowBox[{"np", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"rmax", " ", "=", 
     RowBox[{"Ceiling", "[", " ", 
      RowBox[{"Max", "[", "rseq", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"tmax", " ", "=", 
     RowBox[{"Ceiling", "[", " ", 
      RowBox[{"Max", "[", "tseq", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"rlist", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"rseq", "[", 
          RowBox[{"[", 
           RowBox[{"k", "+", "1"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"np", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"kstart", " ", "=", " ", 
     RowBox[{"Floor", "[", 
      RowBox[{"nl", "/", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"tlist", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k", " ", "-", " ", "kstart", " ", "+", " ", "shift"}], " ", 
         ",", 
         RowBox[{"tseq", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "kstart", ",", "np"}], " ", "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"GraphicsRow", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ListPlot", "[", 
         RowBox[{"rlist", ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<Reflected Sequence\>\""}], ",", 
          RowBox[{"PlotStyle", " ", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Red", ",", 
             RowBox[{"PointSize", "[", "0.05", "]"}]}], "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", ".1"}], ",", "np"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "rmax"}], ",", "rmax"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesOrigin", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
        RowBox[{"ListPlot", "[", 
         RowBox[{"tlist", ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<Transmitted Sequence\>\""}], 
          ",", 
          RowBox[{"PlotStyle", " ", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Blue", ",", 
             RowBox[{"PointSize", "[", "0.05", "]"}]}], "}"}]}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "np"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "tmax"}], ",", "tmax"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesOrigin", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"AxesStyle", "\[Rule]", "Thick"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
    "Remarks", " ", "on", " ", "the", " ", "range", " ", "of", " ", "input", 
     " ", 
     RowBox[{"parameters", ":", "\[IndentingNewLine]", 
      RowBox[{"nl", " ", ">", " ", 
       RowBox[{
       "4", " ", "results", " ", "in", " ", "too", " ", "slow", " ", 
        "calculation", " ", "for", " ", 
        RowBox[{"demonstrations", ".", "\[IndentingNewLine]", "np"}]}], " ", 
       ">", " ", 
       RowBox[{
       "8", " ", "does", " ", "not", " ", "show", " ", "anything", " ", "of", 
        " ", 
        RowBox[{"significance", " ", "--"}], " ", "most", " ", 
        "reverberations", " ", "have", " ", "gone", " ", "to", " ", "zero", 
        " ", 
        RowBox[{"amplitude", ".", " ", "\[IndentingNewLine]", "Increments"}], 
        " ", "finer", " ", "than", " ", "0.05", " ", "in", " ", "\[Rho]v", 
        " ", "can", " ", "result", " ", "in", " ", "InverseZTransform", " ", 
        "not", " ", "evaluating", " ", "due", " ", "to", " ", "nature", " ", 
        "of", " ", "internal", " ", 
        RowBox[{"algorithm", "."}]}]}]}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nl", ",", "3", ",", "\"\<number of layers\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"np", ",", "5", ",", "\"\<number of output points\>\""}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8"}], 
      "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Rho]v1", ",", "0.0", ",", "\"\<layer 1 impedance\>\""}], 
      "}"}], ",", "0.0", ",", "1.0", ",", "0.05", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Rho]v2", ",", "0.5", ",", "\"\<layer 2 impedance\>\""}], 
      "}"}], ",", "0.05", ",", "1.0", ",", "0.05", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Rho]v3", ",", "0.8", ",", "\"\<layer 3 impedance\>\""}], 
      "}"}], ",", "0.05", ",", "1.0", ",", "0.05", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Rho]v4", ",", "1.0", ",", "\"\<layer 4 impedance\>\""}], 
      "}"}], ",", "0.05", ",", "1.0", ",", "0.05", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"TrackedSymbols", " ", "\[RuleDelayed]", " ", 
    RowBox[{"{", 
     RowBox[{
     "nl", ",", "np", ",", "\[Rho]v1", ",", "\[Rho]v2", ",", "\[Rho]v3", ",", 
      "\[Rho]v4"}], "}"}]}], ",", 
   RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.437657389943089*^9, 3.4376574168623238`*^9}, {
   3.437657457007512*^9, 3.437657511657723*^9}, {3.437657544813448*^9, 
   3.437657884975855*^9}, {3.437657925641185*^9, 3.437657940434061*^9}, {
   3.437657985979844*^9, 3.437658053438279*^9}, {3.437658113722961*^9, 
   3.437658261533699*^9}, {3.437658353420642*^9, 3.437658418092575*^9}, {
   3.437658480832089*^9, 3.437658482541581*^9}, {3.437658630877144*^9, 
   3.437658677534223*^9}, {3.437658732864499*^9, 3.4376587335899067`*^9}, {
   3.43765973941049*^9, 3.437659769585463*^9}, {3.437660513521963*^9, 
   3.437660533007695*^9}, {3.437660771897992*^9, 3.437660782247614*^9}, {
   3.437661826771858*^9, 3.4376618581148233`*^9}, {3.437662825468576*^9, 
   3.4376628273468647`*^9}, {3.437662909743819*^9, 3.43766294536664*^9}, {
   3.4376631865191803`*^9, 3.4376632275045233`*^9}, {3.4376632588269033`*^9, 
   3.437663324269247*^9}, {3.437663414934808*^9, 3.437663499821197*^9}, 
   3.437663531895997*^9, {3.437663567469058*^9, 3.4376635710681267`*^9}, {
   3.437663616447792*^9, 3.437663649263315*^9}, {3.437663754438501*^9, 
   3.437663756627701*^9}, {3.437663836397838*^9, 3.437663849725564*^9}, {
   3.43766439351403*^9, 3.437664407815209*^9}, {3.437664442425147*^9, 
   3.4376644543354073`*^9}, {3.4376644976449547`*^9, 3.437664530253561*^9}, {
   3.437665452909275*^9, 3.437665467721355*^9}, {3.4376655191277037`*^9, 
   3.437665568586133*^9}, {3.437666302309927*^9, 3.437666320222207*^9}, 
   3.43766671021358*^9, {3.4376667967604847`*^9, 3.437666815510306*^9}, {
   3.437666921188715*^9, 3.437666926065938*^9}, {3.437667307208844*^9, 
   3.437667384048875*^9}, {3.437787580862013*^9, 3.437787641670559*^9}, {
   3.437787699513483*^9, 3.4377878995231323`*^9}, {3.437787936989272*^9, 
   3.437787974425108*^9}, {3.437788234234126*^9, 3.437788239691187*^9}, {
   3.437788276184751*^9, 3.437788334251013*^9}, {3.4377894948353167`*^9, 
   3.4377894988406897`*^9}, {3.437789537738168*^9, 3.437789556842412*^9}, {
   3.43778964322192*^9, 3.437789661214435*^9}, {3.437790382541184*^9, 
   3.437790446992799*^9}, {3.437790499986639*^9, 3.437790729066163*^9}, {
   3.437790765531802*^9, 3.437790932864505*^9}, {3.437790971535296*^9, 
   3.437791129910471*^9}, {3.4377911847303467`*^9, 3.437791210323234*^9}, {
   3.4377913000460033`*^9, 3.437791300445362*^9}, {3.437791657801731*^9, 
   3.437791662567898*^9}, {3.437795950459342*^9, 3.4377959539776173`*^9}, {
   3.437835247120688*^9, 3.437835270303122*^9}, {3.437835491549159*^9, 
   3.437835526063443*^9}, {3.437836384674653*^9, 3.437836426843286*^9}, {
   3.438307777648662*^9, 3.438307779546245*^9}, 3.4383079255041523`*^9, 
   3.438308065284639*^9, 3.4383081224796124`*^9, {3.439641254860344*^9, 
   3.439641255720787*^9}, {3.43964130351256*^9, 3.439641345261712*^9}, {
   3.439641567799284*^9, 3.4396415682764063`*^9}, {3.43964213831187*^9, 
   3.439642139543089*^9}, {3.4396422492694893`*^9, 3.439642249698415*^9}, {
   3.439642284084634*^9, 3.4396422966516733`*^9}, {3.439642486355723*^9, 
   3.439642607305492*^9}, {3.439642666141296*^9, 3.4396426937944403`*^9}, {
   3.439642970062559*^9, 3.4396430812211933`*^9}, {3.439643189327854*^9, 
   3.43964319446852*^9}, {3.4396434362722073`*^9, 3.439643585812262*^9}, {
   3.439643621597186*^9, 3.439643623037251*^9}, {3.439643813661703*^9, 
   3.4396438169235888`*^9}, {3.4396438493324957`*^9, 3.439643852972371*^9}, 
   3.439991981424075*^9, {3.439992052826223*^9, 3.439992055717366*^9}, {
   3.439992163780727*^9, 3.43999221986272*^9}, {3.439993346275421*^9, 
   3.439993365726005*^9}, {3.43999454995273*^9, 3.439994551686421*^9}, {
   3.4406037372014427`*^9, 3.440603754353088*^9}, {3.440603820083334*^9, 
   3.440603848007133*^9}, {3.4406050280269327`*^9, 3.440605035680665*^9}, {
   3.440605090511114*^9, 3.440605153081311*^9}, {3.4406051978311987`*^9, 
   3.440605370602989*^9}, {3.44060540178821*^9, 3.440605405522331*^9}, {
   3.440605454643808*^9, 3.4406054547769003`*^9}, {3.44060595238822*^9, 
   3.4406059527134037`*^9}, {3.440606823264237*^9, 3.4406068234053802`*^9}, {
   3.440606928593822*^9, 3.4406069321541224`*^9}, {3.4406118282551603`*^9, 
   3.44061185865385*^9}, {3.440612007525399*^9, 3.440612013617888*^9}, {
   3.4406130513496027`*^9, 3.4406130696184807`*^9}, 3.440613109415498*^9, {
   3.440687735136866*^9, 3.440687736821567*^9}, {3.4406877780104027`*^9, 
   3.440687811760869*^9}, {3.440689624109885*^9, 3.440689626204844*^9}, {
   3.440692086161097*^9, 3.440692119677421*^9}, {3.4406922251855583`*^9, 
   3.4406922344165697`*^9}, 3.440692386677226*^9, {3.440692552132536*^9, 
   3.440692556186514*^9}, {3.440693034149137*^9, 3.4406930403862333`*^9}, {
   3.4406931705954123`*^9, 3.440693176706174*^9}, {3.440693550693825*^9, 
   3.4406935512350607`*^9}, 3.440693640752376*^9, 3.440693702210737*^9, {
   3.440694687020742*^9, 3.4406947121212883`*^9}, {3.440695472204399*^9, 
   3.440695475170698*^9}, {3.440695569631589*^9, 3.440695570861865*^9}, {
   3.440695639990986*^9, 3.440695717078846*^9}, {3.440696363505372*^9, 
   3.440696364304315*^9}, {3.4406968524352703`*^9, 3.4406968804361153`*^9}, {
   3.44069705141744*^9, 3.440697055246714*^9}, {3.4407742745228977`*^9, 
   3.440774287313184*^9}, {3.4407743813035994`*^9, 3.4407743851211643`*^9}, {
   3.440774460422442*^9, 3.4407744736047487`*^9}, {3.440774685551549*^9, 
   3.440774686331523*^9}, {3.440775010819434*^9, 3.440775013446074*^9}, {
   3.440775279385696*^9, 3.4407752797988033`*^9}, {3.4407753153604403`*^9, 
   3.440775344437479*^9}, {3.440775405217827*^9, 3.440775411663217*^9}, {
   3.4407754529575043`*^9, 3.44077561552566*^9}, {3.4408098722330236`*^9, 
   3.440809877691441*^9}, 3.4408107717737007`*^9, {3.4408108174853783`*^9, 
   3.4408108234017677`*^9}, {3.440811498554183*^9, 3.440811504351273*^9}, {
   3.440811608354697*^9, 3.440811642880988*^9}, {3.4408127931802397`*^9, 
   3.4408128092530127`*^9}, {3.440813249803643*^9, 3.44081325411362*^9}, {
   3.44081335452579*^9, 3.440813360035696*^9}, {3.440938795800555*^9, 
   3.440938822658041*^9}, {3.440938861874229*^9, 3.4409388657306137`*^9}, {
   3.440938899291787*^9, 3.440939010065889*^9}, {3.440939044614093*^9, 
   3.440939059092689*^9}, {3.44093912272186*^9, 3.440939191705008*^9}, {
   3.4409393581740417`*^9, 3.440939361837585*^9}, {3.4409406839231243`*^9, 
   3.440940684344096*^9}, {3.440940773325961*^9, 3.440940775114264*^9}, {
   3.440941014062187*^9, 3.440941014635479*^9}, {3.44094112328972*^9, 
   3.4409411286787367`*^9}, {3.4409411944126997`*^9, 3.440941198888973*^9}, {
   3.440941288983733*^9, 3.440941290100066*^9}, {3.4409413202729797`*^9, 
   3.440941321397154*^9}, {3.441026878754592*^9, 3.441026879814238*^9}, {
   3.441026994942313*^9, 3.4410270331907787`*^9}, {3.441027118414751*^9, 
   3.4410271607861977`*^9}, 3.4410271921874237`*^9, 3.441027259424293*^9, {
   3.4410272932478857`*^9, 3.441027294245681*^9}, {3.441027468389098*^9, 
   3.4410274692837067`*^9}, {3.441028662925838*^9, 3.44102868868232*^9}, {
   3.441028724696746*^9, 3.441028730777561*^9}, {3.441029032911728*^9, 
   3.4410290480868263`*^9}, {3.4410296404285583`*^9, 
   3.4410296415151863`*^9}, {3.4410296775793343`*^9, 
   3.4410298111989937`*^9}, {3.441029842513653*^9, 3.4410298476947803`*^9}, {
   3.441222792290818*^9, 3.4412228222128887`*^9}, {3.44122315566537*^9, 
   3.441223176552141*^9}, {3.441223266233204*^9, 3.441223279532127*^9}, {
   3.4412233111108923`*^9, 3.441223346220168*^9}, {3.441223397658128*^9, 
   3.441223398819106*^9}, {3.4412234317466917`*^9, 3.441223456132164*^9}, {
   3.44122355238338*^9, 3.441223583810748*^9}, {3.441223626381556*^9, 
   3.44122369975534*^9}, {3.4412238155597897`*^9, 3.441223817057372*^9}, 
   3.441223905904166*^9, {3.441223958281087*^9, 3.4412239593143177`*^9}, {
   3.4412242729882*^9, 3.4412242747571697`*^9}, {3.441224323210766*^9, 
   3.441224325970475*^9}, {3.4412243793980627`*^9, 3.4412243802951813`*^9}, {
   3.441224547929202*^9, 3.441224605901807*^9}, {3.441224661913965*^9, 
   3.441224698541933*^9}, {3.4412247682448883`*^9, 3.441224768523158*^9}, {
   3.441224839355585*^9, 3.441224839495541*^9}, {3.441224879559299*^9, 
   3.441224899608968*^9}, {3.441224929836474*^9, 3.44122496115582*^9}, {
   3.441225093174457*^9, 3.4412251028847446`*^9}, {3.441225253617446*^9, 
   3.441225308238446*^9}, {3.441225372764607*^9, 3.441225457093388*^9}, {
   3.4412255008087473`*^9, 3.441225506594747*^9}, {3.441225544912571*^9, 
   3.441225553713228*^9}, {3.441225690287113*^9, 3.441225717833652*^9}, {
   3.441389594451486*^9, 3.4413896151437817`*^9}, {3.4413899579658823`*^9, 
   3.441390028114524*^9}, {3.44139008839645*^9, 3.441390099318956*^9}, {
   3.441390210481716*^9, 3.441390220495578*^9}, {3.4413903177105837`*^9, 
   3.441390322433497*^9}, {3.441390541382326*^9, 3.4413905773255167`*^9}, 
   3.441390613414833*^9, {3.441392703223734*^9, 3.441392728931184*^9}, {
   3.441394865614607*^9, 3.441394887722547*^9}, 3.44139540142901*^9, 
   3.441395434925374*^9, 3.441395558056481*^9, {3.441395869575198*^9, 
   3.441395869906896*^9}, {3.441397064154523*^9, 3.441397067894568*^9}, 
   3.4413971075267467`*^9, {3.441397551311801*^9, 3.441397775663394*^9}, {
   3.4413983019935217`*^9, 3.441398356407565*^9}, {3.441398477118956*^9, 
   3.441398505329342*^9}, {3.441398583027968*^9, 3.441398590541976*^9}, {
   3.4413989479123898`*^9, 3.4413989754025183`*^9}, {3.4413990643927402`*^9, 
   3.4413990704395037`*^9}, {3.441399144048558*^9, 3.4413991638594713`*^9}, {
   3.441399197159067*^9, 3.441399201389296*^9}, {3.44139925443329*^9, 
   3.441399340138072*^9}, 3.441399567367755*^9, {3.4414630379653273`*^9, 
   3.441463104010725*^9}, {3.441463183148067*^9, 3.441463238243423*^9}, {
   3.441463279730534*^9, 3.441463304487467*^9}, {3.441463441319936*^9, 
   3.441463497786583*^9}, {3.4414635303750362`*^9, 3.441463569155616*^9}, {
   3.441463771733603*^9, 3.441463789658051*^9}, {3.441464852121296*^9, 
   3.441465003322412*^9}, 3.44146506823875*^9, {3.4414658568562727`*^9, 
   3.441465860591864*^9}, {3.4414674125199347`*^9, 3.441467438929467*^9}, {
   3.4414674782203407`*^9, 3.441467498169327*^9}, {3.441467554486361*^9, 
   3.4414677067975817`*^9}, {3.4414678237304697`*^9, 3.441467825716304*^9}, {
   3.4414679777719297`*^9, 3.4414679806481953`*^9}, {3.441468082062842*^9, 
   3.441468127275317*^9}, {3.441468179667787*^9, 3.441468186113757*^9}, {
   3.441499885956975*^9, 3.4415002725350027`*^9}, {3.441500304223342*^9, 
   3.4415003358004704`*^9}, {3.44150036969768*^9, 3.4415003759792147`*^9}, {
   3.4415005123762493`*^9, 3.441500582423522*^9}, {3.441503237783725*^9, 
   3.441503250483189*^9}, {3.441503310849514*^9, 3.4415033115071793`*^9}, {
   3.441503472096098*^9, 3.441503502977295*^9}, {3.441503613409066*^9, 
   3.441503663419382*^9}, {3.441503738556652*^9, 3.441503750358183*^9}, {
   3.44150380765851*^9, 3.441503865187212*^9}, 3.441503916466242*^9, 
   3.441503950402605*^9, {3.441655676636834*^9, 3.4416556892332563`*^9}, {
   3.4416559359330873`*^9, 3.44165597029361*^9}, {3.441728192059781*^9, 
   3.441728215422921*^9}, {3.4422328860310373`*^9, 3.4422328864960833`*^9}, {
   3.4422626354096584`*^9, 3.442262661812299*^9}, {3.442266903734398*^9, 
   3.442266904578164*^9}, {3.4423434561395683`*^9, 3.442343456155573*^9}, {
   3.4426888427167063`*^9, 3.442688846303282*^9}},
 CellID->934004989]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`nl$$ = 3, $CellContext`np$$ = 
    5, $CellContext`\[Rho]v1$$ = 0., $CellContext`\[Rho]v2$$ = 
    0.5, $CellContext`\[Rho]v3$$ = 0.8, $CellContext`\[Rho]v4$$ = 1., 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`nl$$], 3, "number of layers"}, {3, 4}}, {{
       Hold[$CellContext`np$$], 5, "number of output points"}, {3, 4, 5, 6, 7,
       8}}, {{
       Hold[$CellContext`\[Rho]v1$$], 0., "layer 1 impedance"}, 0., 1., 
      0.05}, {{
       Hold[$CellContext`\[Rho]v2$$], 0.5, "layer 2 impedance"}, 0.05, 1., 
      0.05}, {{
       Hold[$CellContext`\[Rho]v3$$], 0.8, "layer 3 impedance"}, 0.05, 1., 
      0.05}, {{
       Hold[$CellContext`\[Rho]v4$$], 1., "layer 4 impedance"}, 0.05, 1., 
      0.05}}, Typeset`size$$ = {600., {97., 100.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`nl$1321639$$ = False, $CellContext`np$1321640$$ = 
    0, $CellContext`\[Rho]v1$1321641$$ = 0, $CellContext`\[Rho]v2$1321642$$ = 
    0, $CellContext`\[Rho]v3$1321643$$ = 0, $CellContext`\[Rho]v4$1321644$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`nl$$ = 3, $CellContext`np$$ = 
        5, $CellContext`\[Rho]v1$$ = 0., $CellContext`\[Rho]v2$$ = 
        0.5, $CellContext`\[Rho]v3$$ = 0.8, $CellContext`\[Rho]v4$$ = 1.}, 
      "ControllerVariables" :> {
        Hold[$CellContext`nl$$, $CellContext`nl$1321639$$, False], 
        Hold[$CellContext`np$$, $CellContext`np$1321640$$, 0], 
        Hold[$CellContext`\[Rho]v1$$, $CellContext`\[Rho]v1$1321641$$, 0], 
        Hold[$CellContext`\[Rho]v2$$, $CellContext`\[Rho]v2$1321642$$, 0], 
        Hold[$CellContext`\[Rho]v3$$, $CellContext`\[Rho]v3$1321643$$, 0], 
        Hold[$CellContext`\[Rho]v4$$, $CellContext`\[Rho]v4$1321644$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       If[$CellContext`nl$$ == 
         3, $CellContext`\[Rho]v = {$CellContext`\[Rho]v1$$, $CellContext`\
\[Rho]v2$$, $CellContext`\[Rho]v3$$}]; 
       If[$CellContext`nl$$ == 
         4, $CellContext`\[Rho]v = {$CellContext`\[Rho]v1$$, $CellContext`\
\[Rho]v2$$, $CellContext`\[Rho]v3$$, $CellContext`\[Rho]v4$$}]; \
$CellContext`nb = $CellContext`nl$$ - 1; $CellContext`r = 
        Table[(Part[$CellContext`\[Rho]v, $CellContext`i] - 
           Part[$CellContext`\[Rho]v, $CellContext`i - 1])/(
          Part[$CellContext`\[Rho]v, $CellContext`i] + 
          Part[$CellContext`\[Rho]v, $CellContext`i - 1]), {$CellContext`i, 
           2, $CellContext`nl$$}]; $CellContext`t = 
        1 + $CellContext`r; $CellContext`rp = -$CellContext`r; \
$CellContext`tp = 1 + $CellContext`rp; $CellContext`F = 1; $CellContext`G = 
        Part[$CellContext`r, 1]; 
       Do[$CellContext`FF = $CellContext`F + 
           Part[$CellContext`r, $CellContext`k] $CellContext`z $CellContext`G; \
$CellContext`GG = 
          Part[$CellContext`r, $CellContext`k] $CellContext`F + \
$CellContext`z $CellContext`G; $CellContext`F = $CellContext`FF; \
$CellContext`G = $CellContext`GG, {$CellContext`k, 
          2, $CellContext`nb}]; $CellContext`T = \
$CellContext`z^(($CellContext`nl$$ - 2)/2) (Product[
            
            Part[$CellContext`tp, $CellContext`k], {$CellContext`k, 
             1, $CellContext`nb}]/$CellContext`F); $CellContext`R = \
$CellContext`G/$CellContext`F; If[
         OddQ[$CellContext`nl$$], $CellContext`up = InverseZTransform[
           
           ReplaceAll[$CellContext`z^((-1)/2) $CellContext`T, $CellContext`z -> 
            1/$CellContext`z], $CellContext`z, $CellContext`m], \
$CellContext`up = InverseZTransform[
           ReplaceAll[$CellContext`T, $CellContext`z -> 
            1/$CellContext`z], $CellContext`z, $CellContext`m]]; \
$CellContext`down = InverseZTransform[
          
          ReplaceAll[-$CellContext`R, $CellContext`z -> 
           1/$CellContext`z], $CellContext`z, $CellContext`m]; \
$CellContext`shift = ($CellContext`nl$$ - 2)/2; $CellContext`rseq = Chop[
          Table[
           
           Evaluate[$CellContext`down], {$CellContext`m, 0, $CellContext`np$$ - 
            1}]]; $CellContext`tseq = Chop[
          Table[
           
           Evaluate[$CellContext`up], {$CellContext`m, 0, $CellContext`np$$ - 
            1}]]; $CellContext`rmax = Ceiling[
          Max[$CellContext`rseq]]; $CellContext`tmax = Ceiling[
          Max[$CellContext`tseq]]; $CellContext`rlist = Table[{$CellContext`k, 
           Part[$CellContext`rseq, $CellContext`k + 1]}, {$CellContext`k, 
           0, $CellContext`np$$ - 1}]; $CellContext`kstart = 
        Floor[$CellContext`nl$$/2]; $CellContext`tlist = 
        Table[{$CellContext`k - $CellContext`kstart + $CellContext`shift, 
           
           Part[$CellContext`tseq, $CellContext`k]}, {$CellContext`k, \
$CellContext`kstart, $CellContext`np$$}]; GraphicsRow[{
          
          ListPlot[$CellContext`rlist, PlotLabel -> "Reflected Sequence", 
           PlotStyle -> {Red, 
             PointSize[0.05]}, 
           PlotRange -> {{-0.1, $CellContext`np$$}, {-$CellContext`rmax, \
$CellContext`rmax}}, AxesOrigin -> {0, 0}, AxesStyle -> Thick], 
          
          ListPlot[$CellContext`tlist, PlotLabel -> "Transmitted Sequence", 
           PlotStyle -> {Blue, 
             PointSize[0.05]}, 
           PlotRange -> {{
             0, $CellContext`np$$}, {-$CellContext`tmax, $CellContext`tmax}}, 
           AxesOrigin -> {0, 0}, AxesStyle -> Thick]}, ImageSize -> 600]), 
      "Specifications" :> {{{$CellContext`nl$$, 3, "number of layers"}, {3, 
         4}}, {{$CellContext`np$$, 5, "number of output points"}, {3, 4, 5, 6,
          7, 8}}, {{$CellContext`\[Rho]v1$$, 0., "layer 1 impedance"}, 0., 1.,
          0.05, Appearance -> 
         "Labeled"}, {{$CellContext`\[Rho]v2$$, 0.5, "layer 2 impedance"}, 
         0.05, 1., 0.05, Appearance -> 
         "Labeled"}, {{$CellContext`\[Rho]v3$$, 0.8, "layer 3 impedance"}, 
         0.05, 1., 0.05, Appearance -> 
         "Labeled"}, {{$CellContext`\[Rho]v4$$, 1., "layer 4 impedance"}, 
         0.05, 1., 0.05, Appearance -> "Labeled"}}, 
      "Options" :> {
       TrackedSymbols :> {$CellContext`nl$$, $CellContext`np$$, $CellContext`\
\[Rho]v1$$, $CellContext`\[Rho]v2$$, $CellContext`\[Rho]v3$$, $CellContext`\
\[Rho]v4$$}, SynchronousUpdating -> False}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{645., {206., 211.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->251991481],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Reverberations in Acoustic Layers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ReverberationsInAcousticLayers/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ReverberationsInAcousticLayers/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/ReverberationsInAcousticLayers/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ReverberationsInAcousticLayers/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ReverberationsInAcousticLayers/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["David von Seggern",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=David+von+\
Seggern"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=David+von+Seggern"],
 " (University of Nevada)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ReverberationsInAcousticLayers"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Reverberations in Acoustic Layers - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[623, 23, 225, 4, 70, "Section"],
Cell[851, 29, 25026, 501, 70, "Input",
 CellID->934004989]
}, Open  ]],
Cell[25892, 533, 7244, 137, 70, "Output",
 CellID->251991481],
Cell[CellGroupData[{
Cell[33161, 674, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[33537, 685, 978, 28, 70, "Text"],
Cell[34518, 715, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[34858, 726, 473, 15, 70, "Text"],
Cell[CellGroupData[{
Cell[35356, 745, 847, 24, 70, "Text"],
Cell[36206, 771, 1206, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature iSjzUHWpb8iYcDTOAQl@WQSg *)
