(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25585,        640]
NotebookOptionsPosition[     24406,        595]
NotebookOutlinePosition[     25061,        620]
CellTagsIndexPosition[     25018,        617]
WindowTitle->Refraction through Parallel Faces - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Refraction through Parallel Faces", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"LightBlue", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Arrowheads", "[", ".03", "]"}], ",", "Red", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], "+", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "1"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"1.5", ",", "1"}], "}"}]}], "}"}], "]"}], ",", "Blue", ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{".5", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Sin", "[", "x", "]"}]}], ",", 
              RowBox[{"Cos", "[", "x", "]"}]}], "}"}]}], "+", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "1"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "\[Theta]", ",", ".05"}], "}"}]}], 
         "]"}]}], ",", "Dashed", ",", "Red", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"1.5", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "+", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "1"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"1.5", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Dashing", "[", "1", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1.5", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.5", ",", ".25"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Theta]2", "=", 
           RowBox[{"ArcSin", "[", 
            RowBox[{
             FractionBox["1", "1.5"], 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.5", ",", "1"}], "}"}], ",", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.5", ",", "1"}], "}"}], "+", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Tan", "[", "\[Theta]2", "]"}], ",", 
                 RowBox[{"-", "1"}]}], "}"}]}]}], "}"}], "]"}], ",", "Blue", 
           ",", 
           RowBox[{"Arrow", "@", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{".5", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"Sin", "[", "x", "]"}]}], ",", 
                  RowBox[{"Cos", "[", "x", "]"}]}], "}"}]}], "+", 
               RowBox[{"{", 
                RowBox[{"1.5", ",", "1"}], "}"}], "+", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Tan", "[", "\[Theta]2", "]"}], ",", 
                 RowBox[{"-", "1"}]}], "}"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "0", ",", "\[Theta]2", ",", ".05"}], "}"}]}],
              "]"}]}], ",", 
           RowBox[{"Arrow", "@", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{".5", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Sin", "[", "x", "]"}], ",", 
                  RowBox[{"2", "-", 
                   RowBox[{"Cos", "[", "x", "]"}]}]}], "}"}]}], "+", 
               RowBox[{"{", 
                RowBox[{"1.5", ",", "0"}], "}"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "0", ",", "\[Theta]2", ",", ".05"}], "}"}]}],
              "]"}]}], ",", "Dashed", ",", "Red", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.5", ",", "1"}], "}"}], "+", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Tan", "[", "\[Theta]2", "]"}], ",", 
                 RowBox[{"-", "1"}]}], "}"}]}], ",", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.5", ",", "1"}], "}"}], "+", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Tan", "[", "\[Theta]2", "]"}], ",", 
                 RowBox[{"-", "1"}]}], "}"}], "+", 
               RowBox[{"1.5", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Sin", "[", "\[Theta]2", "]"}], ",", 
                  RowBox[{"-", 
                   RowBox[{"Cos", "[", "\[Theta]2", "]"}]}]}], "}"}]}]}]}], 
             "}"}], "]"}], ",", 
           RowBox[{"Dashing", "[", "1", "]"}], ",", "Black", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"Tan", "[", "\[Theta]2", "]"}], "+", "1.5"}], ",", 
                RowBox[{"-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"Tan", "[", "\[Theta]2", "]"}], "+", "1.5"}], ",", 
                ".75"}], "}"}]}], "}"}], "]"}], ",", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\[Theta]3", "=", 
               RowBox[{"ArcSin", "[", 
                RowBox[{
                 FractionBox["1.5", "1"], 
                 RowBox[{"Sin", "[", "\[Theta]2", "]"}]}], "]"}]}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", 
               RowBox[{"Arrow", "@", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{".5", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sin", "[", "x", "]"}], ",", 
                    RowBox[{"-", 
                    RowBox[{"Cos", "[", "x", "]"}]}]}], "}"}]}], "+", 
                   RowBox[{"{", 
                    RowBox[{"1.5", ",", "0"}], "}"}], "+", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Tan", "[", "\[Theta]2", "]"}], ",", "0"}], 
                    "}"}]}], ",", 
                  RowBox[{"{", 
                   RowBox[{"x", ",", "0", ",", "\[Theta]3", ",", ".05"}], 
                   "}"}]}], "]"}]}], ",", "Red", ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1.5", ",", "1"}], "}"}], "+", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Tan", "[", "\[Theta]2", "]"}], ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], ",", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.5", "+", 
                    RowBox[{"Tan", "[", "\[Theta]2", "]"}]}], ",", "0"}], 
                    "}"}], "+", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sin", "[", "\[Theta]3", "]"}], ",", 
                    RowBox[{"-", 
                    RowBox[{"Cos", "[", "\[Theta]3", "]"}]}]}], "}"}]}]}], 
                 "}"}], "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Background", "\[Rule]", "LightYellow"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "400"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "1"}], "}"}], ",", "0", ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.431466055865809*^9, 3.4314660881253023`*^9}, {
   3.432399494985675*^9, 3.4323995526447573`*^9}, {3.432403143066908*^9, 
   3.4324031478139544`*^9}, {3.4324034735376787`*^9, 3.432403483043247*^9}, {
   3.4324035378051147`*^9, 3.4324036198645573`*^9}, {3.43240365076423*^9, 
   3.432403693444097*^9}, {3.432403748977929*^9, 3.4324037790398006`*^9}, {
   3.432403925115378*^9, 3.4324039425484667`*^9}, {3.43240398916363*^9, 
   3.432404006262947*^9}, {3.432404146053629*^9, 3.4324042213268642`*^9}, 
   3.43240479211569*^9, {3.4324052580670843`*^9, 3.432405295810763*^9}, {
   3.432405325830832*^9, 3.4324053573159103`*^9}, {3.4324053898372*^9, 
   3.432405465432033*^9}, {3.432412747315123*^9, 3.4324127923516083`*^9}, {
   3.432412838119978*^9, 3.432412842368909*^9}, {3.4324129113464193`*^9, 
   3.432412912502789*^9}, {3.4324129495578537`*^9, 3.432412949618988*^9}, {
   3.432413011859947*^9, 3.432413064819137*^9}, {3.4324131274427967`*^9, 
   3.432413135406109*^9}, {3.4324133936344433`*^9, 3.432413443254253*^9}, {
   3.432413640289978*^9, 3.4324136412667513`*^9}, {3.432413697474285*^9, 
   3.432413716208581*^9}, {3.43241382628179*^9, 3.4324138349451933`*^9}, {
   3.432414130948619*^9, 3.432414158946663*^9}, {3.432414840180654*^9, 
   3.43241489480977*^9}, {3.432414990929488*^9, 3.432415027361287*^9}, {
   3.432415687555188*^9, 3.432415698963277*^9}, {3.4324162829046793`*^9, 
   3.4324162899657927`*^9}, {3.432416428260446*^9, 3.43241643074435*^9}, {
   3.43241705692212*^9, 3.432417062087318*^9}, {3.4324173657533092`*^9, 
   3.432417377614378*^9}, 3.432417419537161*^9, {3.4324174615241537`*^9, 
   3.4324174735325823`*^9}, {3.4324179787971163`*^9, 3.432417980802292*^9}, {
   3.432418360690843*^9, 3.432418407172265*^9}, 3.432418831221183*^9, {
   3.432419106740637*^9, 3.43241910749581*^9}, 3.4324199928633337`*^9, 
   3.4324200671392803`*^9, {3.432420224593279*^9, 3.4324202625997877`*^9}, {
   3.432420367367896*^9, 3.432420420912881*^9}, {3.43242130171457*^9, 
   3.4324213021705627`*^9}, 3.432421466237681*^9, {3.432421636589157*^9, 
   3.43242164295619*^9}, {3.4324216912134743`*^9, 3.432421713178194*^9}, {
   3.4324218779759493`*^9, 3.432421878394773*^9}, {3.43242346413783*^9, 
   3.432423473593318*^9}, {3.432743774108127*^9, 3.4327438162053757`*^9}, {
   3.432745474859893*^9, 3.43274550879046*^9}, {3.432751962697022*^9, 
   3.4327519842040052`*^9}, {3.432752104657576*^9, 3.4327521466570473`*^9}, {
   3.4327521820885572`*^9, 3.432752187789527*^9}, {3.432752239239202*^9, 
   3.4327523024799223`*^9}, {3.432752333026229*^9, 3.4327523341978073`*^9}, {
   3.432906469203928*^9, 3.432906483649372*^9}, {3.432934204103096*^9, 
   3.432934266056221*^9}, {3.432934305431221*^9, 3.432934307899971*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 1.2409290981679684`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Theta]$$], 1.2409290981679684`}, 0, Rational[1, 2] 
      Pi}}, Typeset`size$$ = {500., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Theta]$1049732$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Theta]$$ = 1.2409290981679684`}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$1049732$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{LightBlue, 
         Rectangle[{0, 0}, {4, 1}], 
         Arrowheads[0.03], Red, 
         Arrow[{{-Sin[$CellContext`\[Theta]$$], 
             Cos[$CellContext`\[Theta]$$]} + {1.5, 1}, {1.5, 1}}], Blue, 
         Arrow[
          Table[0.5 {-Sin[$CellContext`x], 
              Cos[$CellContext`x]} + {1.5, 1}, {$CellContext`x, 
            0, $CellContext`\[Theta]$$, 0.05}]], Dashed, Red, 
         Line[{1.5 {
              Sin[$CellContext`\[Theta]$$], -Cos[$CellContext`\[Theta]$$]} + {
            1.5, 1}, {1.5, 1}}], 
         Dashing[1], Black, 
         Line[{{1.5, 2}, {1.5, 0.25}}], 
         With[{$CellContext`\[Theta]2 = 
           ArcSin[(1/1.5) Sin[$CellContext`\[Theta]$$]]}, {Red, 
           Arrow[{{1.5, 1}, {1.5, 1} + {
               Tan[$CellContext`\[Theta]2], -1}}], Blue, 
           Arrow[
            Table[0.5 {-Sin[$CellContext`x], 
                Cos[$CellContext`x]} + {1.5, 1} + {
               Tan[$CellContext`\[Theta]2], -1}, {$CellContext`x, 
              0, $CellContext`\[Theta]2, 0.05}]], 
           Arrow[
            Table[0.5 {
                Sin[$CellContext`x], 2 - Cos[$CellContext`x]} + {
              1.5, 0}, {$CellContext`x, 0, $CellContext`\[Theta]2, 0.05}]], 
           Dashed, Red, 
           Line[{{1.5, 1} + {
               Tan[$CellContext`\[Theta]2], -1}, {1.5, 1} + {
               Tan[$CellContext`\[Theta]2], -1} + 1.5 {
                Sin[$CellContext`\[Theta]2], -Cos[$CellContext`\[Theta]2]}}], 
           
           Dashing[1], Black, 
           
           Line[{{Tan[$CellContext`\[Theta]2] + 1.5, -1}, {
             Tan[$CellContext`\[Theta]2] + 1.5, 0.75}}], 
           
           With[{$CellContext`\[Theta]3 = 
             ArcSin[(1.5/1) Sin[$CellContext`\[Theta]2]]}, {Blue, 
             Arrow[
              Table[0.5 {
                  Sin[$CellContext`x], -Cos[$CellContext`x]} + {1.5, 0} + {
                 Tan[$CellContext`\[Theta]2], 0}, {$CellContext`x, 
                0, $CellContext`\[Theta]3, 0.05}]], Red, 
             Arrow[{{1.5, 1} + {
                 Tan[$CellContext`\[Theta]2], -1}, {
                1.5 + Tan[$CellContext`\[Theta]2], 0} + {
                 Sin[$CellContext`\[Theta]3], -
                 Cos[$CellContext`\[Theta]3]}}]}]}]}, Background -> 
        LightYellow, ImageSize -> {500, 400}, PlotRange -> {{0, 4}, {-1, 2}}],
       "Specifications" :> {{{$CellContext`\[Theta]$$, 1.2409290981679684`}, 
         0, Rational[1, 2] Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {242., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->147513565],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
A ray of light passes through the air (yellow) to a glass plate (blue) and \
then back into the air. By Snell's law, the angles of refraction at the first \
and second surfaces are equal and therefore the entry and exit rays are \
parallel.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Refraction through Parallel Faces",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/RefractionThroughParallelFaces/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/RefractionThroughParallelFaces/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/RefractionThroughParallelFaces/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/RefractionThroughParallelFaces/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/RefractionThroughParallelFaces/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Enrique Zeleny",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
RefractionThroughParallelFaces"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Refraction through Parallel Faces - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[635, 23, 153, 3, 70, "Section"],
Cell[791, 28, 3700, 64, 70, "Section"],
Cell[4494, 94, 11460, 267, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15991, 366, 4018, 84, 70, "Output",
 CellID->147513565],
Cell[CellGroupData[{
Cell[20034, 454, 209, 6, 70, "Section"],
Cell[20246, 462, 264, 5, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20558, 473, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[20916, 484, 978, 28, 70, "Text"],
Cell[21897, 514, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[22358, 532, 815, 24, 70, "Text"],
Cell[23176, 558, 1202, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ZSNZhsq2dF4ILD0LHaU2Dl4Y *)
