(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     95101,       2324]
NotebookOptionsPosition[     93864,       2277]
NotebookOutlinePosition[     94527,       2302]
CellTagsIndexPosition[     94484,       2299]
WindowTitle->Ray Diagrams for Microscope and Telescope - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Ray Diagrams for Microscope and Telescope", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h", "=", "2.0"}], ",", 
       RowBox[{"h2", "=", "2.5"}], ",", "head", ",", "radius", ",", "radius2",
        ",", "lfocusloc", ",", "rfocusloc", ",", "lfocusloc2", ",", 
       "rfocusloc2", ",", "imgloc", ",", "img2loc", ",", "objdist", ",", 
       "obj2dist"}], "}"}], ",", "\[IndentingNewLine]", "            ", 
     RowBox[{"(*", "\:041e\:043f\:0438\:0441", "*)"}], "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{
       RowBox[{"imagedistance", "[", 
        RowBox[{"focus_", ",", "objdistance_"}], "]"}], ":=", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "rfocusloc", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "lfocusloc", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{"objdistance", "==", "0"}]}], ",", "0", ",", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"1", "/", "focus"}], " ", "==", " ", 
             RowBox[{
              RowBox[{"1", "/", "objdistance"}], " ", "+", " ", 
              RowBox[{"1", "/", "q"}]}]}], ",", "q"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"image2distance", "[", 
        RowBox[{"focus2_", ",", "objdistance_"}], "]"}], ":=", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "rfocusloc2", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "lfocusloc2", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{"objdistance", "==", "0"}]}], ",", "0", ",", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"1", "/", "focus2"}], " ", "==", " ", 
             RowBox[{
              RowBox[{"1", "/", "objdistance"}], " ", "+", " ", 
              RowBox[{"1", "/", "q"}]}]}], ",", "q"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"magnification", "[", 
        RowBox[{"imgdistance_", ",", "objdistance_"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "rfocusloc", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "lfocusloc", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{"objdistance", "==", "0"}], "||", 
          RowBox[{"imgdistance", "\[Equal]", "0"}]}], ",", "0", ",", 
         RowBox[{"imgdistance", "/", "objdistance"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"magnification2", "[", 
        RowBox[{"imgdistance_", ",", "objdistance_"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "rfocusloc2", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{
           RowBox[{
           "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "lfocusloc2", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{"objdistance", "==", "0"}], "||", 
          RowBox[{"imgdistance", "\[Equal]", "0"}]}], ",", "0", ",", 
         RowBox[{"imgdistance", "/", "objdistance"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "            ", 
      RowBox[{
      "(*", "\:0420\:043e\:0437\:0440\:0430\:0445\:0443\:043d\:043e\:043a", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"radius", " ", "=", 
       RowBox[{"4", "focus"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
       "\:043a\:0440\:0438\:0432\:0438\:0437\:043d\:0430", " ", 
        "\:043b\:0456\:043d\:0437\:0438"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"radius2", " ", "=", 
       RowBox[{"10", "focus2"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
       "\:043a\:0440\:0438\:0432\:0438\:0437\:043d\:0430", " ", 
        "\:043b\:0456\:043d\:0437\:04382"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"lfocusloc", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "focus"}], "+", 
          RowBox[{
          "location", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rfocusloc", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"focus", "+", 
          RowBox[{
          "location", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"lfocusloc2", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "focus2"}], "+", 
          RowBox[{
          "location2", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rfocusloc2", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"focus2", "+", 
          RowBox[{
          "location2", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"objdist", " ", "=", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{
         "location", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         "-", 
         RowBox[{
         "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"imgloc", " ", "=", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
          "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          "<", 
          RowBox[{
          "location", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
            "location", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}], "+", 
            RowBox[{"imagedistance", "[", 
             RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"magnification", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "*", 
               RowBox[{"imagedistance", "[", 
                RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", "objdist"}], 
             "]"}], "*", 
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
            "location", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}], "-", 
            RowBox[{"imagedistance", "[", 
             RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"magnification", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "*", 
               RowBox[{"imagedistance", "[", 
                RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", "objdist"}], 
             "]"}], "*", 
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"obj2dist", " ", "=", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{
         "location2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         "-", 
         RowBox[{
         "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"img2loc", " ", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
          "location2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           "+", 
          RowBox[{"image2distance", "[", 
           RowBox[{"focus2", ",", "obj2dist"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"magnification2", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "*", 
             RowBox[{"image2distance", "[", 
              RowBox[{"focus2", ",", "obj2dist"}], "]"}]}], ",", "obj2dist"}],
            "]"}], "*", 
          RowBox[{
          "imgloc", "\[LeftDoubleBracket]", "2", 
           "\[RightDoubleBracket]"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"head", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{"1", "/", "4"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"-", "1"}], "/", "4"}]}], "}"}]}], "}"}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"source", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x0_", ",", "y0_"}], "}"}], ",", "r0_"}], "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{"Orange", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x0", ",", "y0"}], "}"}], ",", "r0"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "+", 
               RowBox[{"2", "r0"}]}], ",", "y0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "-", 
               RowBox[{"2", "r0"}]}], ",", "y0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x0", ",", 
              RowBox[{"y0", "+", 
               RowBox[{"2", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x0", ",", 
              RowBox[{"y0", "-", 
               RowBox[{"2", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "-", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "-", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "+", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "-", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "-", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "+", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "+", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "+", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"line2", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x3", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x4", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
        "]"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "\:043b\:0456\:043d\:0456\:044f", " ", "\:0437", " ", 
         "\:043f\:043e\:0447\:0430\:0442\:043a\:043e\:043c", " ", "\:0432", 
         " ", "\:0442", ".3"}], ",", " ", 
        RowBox[{
        "\:0437\:0430\:043a\:0456\:043d\:0447\:0435\:043d\:043d\:044f\:043c", 
         " ", "\:0432", " ", "\:0442", ".4", "  ", "\:0456", " ", 
         "\:043f\:0440\:043e\:0445\:043e\:0434\:0438\:0442\:044c", " ", 
         "\:0447\:0435\:0440\:0435\:0437", " ", 
         "\:0442\:043e\:0447\:043a\:0438", " ", "1", " ", "\:0456", " ", 
         "2"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"arrow2", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x3", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x4", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
        "]"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "\:0441\:0442\:0440\:0456\:043b\:043a\:0430", " ", "\:0437", " ", 
         "\:043f\:043e\:0447\:0430\:0442\:043a\:043e\:043c", " ", "\:0432", 
         " ", "\:0442", ".3"}], ",", " ", 
        RowBox[{
        "\:0437\:0430\:043a\:0456\:043d\:0447\:0435\:043d\:043d\:044f\:043c", 
         " ", "\:0432", " ", "\:0442", ".4", "  ", "\:0456", " ", 
         "\:043f\:0440\:043e\:0445\:043e\:0434\:0438\:0442\:044c", " ", 
         "\:0447\:0435\:0440\:0435\:0437", " ", 
         "\:0442\:043e\:0447\:043a\:0438", " ", "1", " ", "\:0456", " ", 
         "2"}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "\:041f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
        "\:0413\:0440\:0430\:0444\:0456\:0447\:043d\:043e\:0433\:043e", " ", 
        "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\:044f"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"y31", ":=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
            "-", 
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
            ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            "-", 
            RowBox[{
            "location", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}]}], ")"}]}], 
         RowBox[{
         "location2", "\[LeftDoubleBracket]", "1", 
          "\[RightDoubleBracket]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            " ", 
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
            "-", 
           RowBox[{
            RowBox[{
            "location", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}], " ", 
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
           "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "-", 
           RowBox[{
           "location", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], ")"}]}]}]}], ";", 
      RowBox[{"(*", " ", 
       RowBox[{"\:0443", "-", 
        RowBox[{
        "\:043a\:043e\:043e\:0440\:0434\:0438\:043d\:0430\:0442\:0430", " ", 
         "\:0442\:043e\:0447\:043a\:0438", "  ", "\:0434\:043b\:044f", " ", 
         "\:043f\:0440\:043e\:043c\:0435\:043d\:044f", " ", "1", " ", 
         "\:0437\:0430", " ", 
         "\:0444\:043e\:0440\:043c\:0443\:043b\:043e\:044e", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y2", "-", "y1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"x2", "-", "x1"}], ")"}]}], "x31"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x2", " ", "y1"}], "-", 
           RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"x2", "-", "x1"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"y32", ":=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
            "-", 
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
            ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            "-", 
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
            ")"}]}], 
         RowBox[{
         "location2", "\[LeftDoubleBracket]", "1", 
          "\[RightDoubleBracket]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            " ", 
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
            "-", 
           RowBox[{
            RowBox[{
            "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            " ", 
            RowBox[{
            "imgloc", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
           "imgloc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "-", 
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
          ")"}]}]}]}], ";", 
      RowBox[{"(*", " ", 
       RowBox[{"\:0443", "-", 
        RowBox[{
        "\:043a\:043e\:043e\:0440\:0434\:0438\:043d\:0430\:0442\:0430", " ", 
         "\:0442\:043e\:0447\:043a\:0438", "  ", "\:0434\:043b\:044f", " ", 
         "\:043f\:0440\:043e\:043c\:0435\:043d\:044f", " ", "1", " ", 
         "\:0437\:0430", " ", 
         "\:0444\:043e\:0440\:043c\:0443\:043b\:043e\:044e", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y2", "-", "y1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"x2", "-", "x1"}], ")"}]}], "x32"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x2", " ", "y1"}], "-", 
           RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"x2", "-", "x1"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(*", 
          RowBox[{
          "\:043b\:0456\:0432\:0430", " ", 
           "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
           RowBox[{
           "\:0437\:0431\:0438\:0440", ".", 
            "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Gray", ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "+", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"radius", "^", "2"}], "-", 
                   RowBox[{"h", "^", "2"}]}], "]"}]}], ",", "0"}], "}"}], ",",
               "radius", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Pi", " ", "-", " ", 
                 RowBox[{"ArcTan", "[", 
                  RowBox[{"h", "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                RowBox[{"Pi", " ", "+", " ", 
                 RowBox[{"ArcTan", "[", 
                  RowBox[{"h", "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}]}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "\:043f\:0440\:0430\:0432\:0430", " ", 
            "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
            RowBox[{
            "\:0437\:0431\:0438\:0440", ".", 
             "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Gray", ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "-", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"radius", "^", "2"}], "-", 
                   RowBox[{"h", "^", "2"}]}], "]"}]}], ",", "0"}], "}"}], ",",
               "radius", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"ArcTan", "[", 
                  RowBox[{"h", "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                RowBox[{"ArcTan", "[", 
                 RowBox[{"h", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "\:043b\:0456\:0432\:0430", " ", 
            "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
            RowBox[{
            "\:0437\:0431\:0438\:0440", ".", 
             "\:043b\:0456\:043d\:0437\:04382"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Gray", ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "location2", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "+", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"radius2", "^", "2"}], "-", 
                   RowBox[{"h2", "^", "2"}]}], "]"}]}], ",", "0"}], "}"}], 
              ",", "radius2", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Pi", " ", "-", " ", 
                 RowBox[{"ArcTan", "[", 
                  RowBox[{"h2", "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius2", "^", "2"}], "-", 
                    RowBox[{"h2", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                RowBox[{"Pi", " ", "+", " ", 
                 RowBox[{"ArcTan", "[", 
                  RowBox[{"h2", "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius2", "^", "2"}], "-", 
                    RowBox[{"h2", "^", "2"}]}], "]"}]}], "]"}]}]}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "\:043f\:0440\:0430\:0432\:0430", " ", 
            "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
            RowBox[{
            "\:0437\:0431\:0438\:0440", ".", 
             "\:043b\:0456\:043d\:0437\:04382"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Gray", ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "location2", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "-", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"radius2", "^", "2"}], "-", 
                   RowBox[{"h2", "^", "2"}]}], "]"}]}], ",", "0"}], "}"}], 
              ",", "radius2", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"ArcTan", "[", 
                  RowBox[{"h2", "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius2", "^", "2"}], "-", 
                    RowBox[{"h2", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                RowBox[{"ArcTan", "[", 
                 RowBox[{"h2", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"radius2", "^", "2"}], "-", 
                    RowBox[{"h2", "^", "2"}]}], "]"}]}], "]"}]}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", " ", 
          RowBox[{"(*", 
           RowBox[{
           "\:0441\:0445\:0435\:043c\:0430\:0442\:0438\:0447\:043d\:0435", 
            " ", "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\:044f\
", " ", 
            RowBox[{
            "\:0437\:0431\:0438\:0440", ".", 
             "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Arrowheads", "[", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic", ",", "head"}], "}"}], 
              "}"}], "]"}], ",", "Thick", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{"1.3", "h"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Arrowheads", "[", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic", ",", "head"}], "}"}], 
              "}"}], "]"}], ",", "Thick", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{
                  RowBox[{"-", "1.3"}], "h"}]}], "}"}]}], "}"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
            RowBox[{"Point", "[", "rfocusloc", "]"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "\:0442\:043e\:0447\:043a\:0430", " ", 
            "\:043f\:0440\:0430\:0432\:043e\:0433\:043e", " ", 
            "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<F\>\"", ",", 
              RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
              RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
            RowBox[{"rfocusloc", "+", ".3"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
            RowBox[{"Point", "[", "lfocusloc", "]"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "\:0442\:043e\:0447\:043a\:0430", " ", 
            "\:043b\:0456\:0432\:043e\:0433\:043e", " ", 
            "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "\:0441\:0445\:0435\:043c\:0430\:0442\:0438\:0447\:043d\:0435", 
            " ", "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\:044f\
", " ", 
            RowBox[{
            "\:0437\:0431\:0438\:0440", ".", 
             "\:043b\:0456\:043d\:0437\:04382"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Arrowheads", "[", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic", ",", "head"}], "}"}], 
              "}"}], "]"}], ",", "Thick", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location2", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location2", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{"1.3", "h"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Arrowheads", "[", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic", ",", "head"}], "}"}], 
              "}"}], "]"}], ",", "Thick", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location2", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location2", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{
                  RowBox[{"-", "1.3"}], "h"}]}], "}"}]}], "}"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
            RowBox[{"Darker", "[", 
             RowBox[{"Red", ",", ".7"}], "]"}], ",", 
            RowBox[{"Point", "[", "rfocusloc2", "]"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "\:0442\:043e\:0447\:043a\:0430", " ", 
            "\:043f\:0440\:0430\:0432\:043e\:0433\:043e", " ", 
            "\:0444\:043e\:043a\:0443\:0441\:04302"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<F'\>\"", ",", 
              RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
              RowBox[{"FontColor", "\[Rule]", 
               RowBox[{"Darker", "[", 
                RowBox[{"Red", ",", ".7"}], "]"}]}]}], "]"}], ",", 
            RowBox[{"lfocusloc2", "+", ".3"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
            RowBox[{"Darker", "[", 
             RowBox[{"Red", ",", ".7"}], "]"}], ",", 
            RowBox[{"Point", "[", "lfocusloc2", "]"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "\:0442\:043e\:0447\:043a\:0430", " ", 
            "\:043b\:0456\:0432\:043e\:0433\:043e", " ", 
            "\:0444\:043e\:043a\:0443\:0441\:04302"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"(*", "\:043f\:0440\:0435\:0434\:043c\:0435\:0442", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Thick", ",", 
            "Blue", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "ptobj", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
               "ptobj"}], "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Thin", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "location", "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}], ",", 
               RowBox[{"-", "h"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "location", "\[LeftDoubleBracket]", "1", 
                "\[RightDoubleBracket]"}], ",", "h"}], "}"}]}], "}"}], "]"}], 
          ",", 
          RowBox[{"(*", 
           RowBox[{
           "\:043e\:043f\:0442\:0438\:0447\:043d\:0430", " ", 
            "\:0432\:0456\:0441\:044c"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", " ", "[", 
             RowBox[{"ray1", ",", 
              RowBox[{"(*", 
               RowBox[{
               "\:043f\:0440\:043e\:043c\:0456\:043d\:044c", " ", 
                "\:0432\:0456\:0434", " ", 
                "\:043f\:0440\:0435\:0434\:043c\:0435\:0442\:0430", " ", 
                "\:0434\:043e", " ", "\:043b\:0456\:043d\:0437\:0438", " ", 
                "\:043f\:0430\:0440\:0430\:043b\:0435\:043b\:044c\:043d\:0438\
\:0439", " ", "\:043e\:043f\:0442\:0438\:0447\:043d\:0456\:0439", " ", 
                "\:043e\:0441\:0456"}], "*)"}], "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                  ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                 "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                  ",", 
                  RowBox[{"line2", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "imgloc"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
                RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", ",", 
                RowBox[{"arrow2", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"img2loc", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "y31"}], "}"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", "focus2"}]}], "}"}]}], 
                 "]"}], ",", "\[IndentingNewLine]", "Brown", ",", "Dashed", 
                ",", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "y31"}], "}"}], ",", 
                   "img2loc"}], "}"}], "]"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"If", " ", "[", 
             RowBox[{"ray2", ",", 
              RowBox[{"(*", 
               RowBox[{
               "\:043b\:0456\:043d\:0456\:044f", " ", "\:0432\:0456\:0434", 
                " ", "\:043f\:0440\:0435\:0434\:043c\:0435\:0442\:0430", " ", 
                "\:0434\:043e", " ", 
                "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\:044f\
", " ", "\:0447\:0435\:0440\:0435\:0437", " ", 
                "\:0446\:0435\:043d\:0442\:0440", " ", 
                "\:043b\:0456\:043d\:0437\:0438"}], "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Pink", ",", 
                
                RowBox[{"line2", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"ptobj", ",", "imgloc"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Pink", ",", 
                
                RowBox[{"arrow2", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"img2loc", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "y32"}], "}"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", "focus2"}]}], "}"}]}], 
                 "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"Pink", ",", "Dashed", ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "y32"}], "}"}], ",", 
                    "img2loc"}], "}"}], "]"}]}], "}"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"If", " ", "[", 
             RowBox[{"ray3", ",", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{
                "\:043b\:0456\:043d\:0456\:044f", " ", "\:0432\:0456\:0434", 
                 " ", "\:043f\:0440\:0435\:0434\:043c\:0435\:0442\:0430", " ",
                  "\:0434\:043e", " ", "\:043b\:0456\:043d\:0437\:0438", " ", 
                 "\:0447\:0435\:0440\:0435\:0437", " ", 
                 "\:0444\:043e\:043a\:0443\:0441"}], " ", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                  "location2", "\[LeftDoubleBracket]", "1", 
                   "\[RightDoubleBracket]"}], ",", 
                  RowBox[{"2", "*", 
                   RowBox[{
                   "rfocusloc2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], "}"}]}], "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                  RowBox[{"Darker", "[", 
                   RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                 "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                  RowBox[{"Darker", "[", 
                   RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                 "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                  RowBox[{"Darker", "[", 
                   RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                  RowBox[{"arrow2", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "rfocusloc2"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", "focus2"}]}], "}"}]}], 
                   "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Darker", "[", 
                   RowBox[{"Green", ",", ".6"}], "]"}], ",", "Dashed", ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location2", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "img2loc"}], 
                    "}"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{
            "(*", "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\
\:044f", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{
                 "ptobj", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "-", 
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}]}], "]"}], "<", 
               RowBox[{"Abs", "[", "focus", "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Thick", ",",
                 "Dashed", ",", "Blue", ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                   "imgloc"}], "}"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Thick", ",",
                 "Blue", ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                   "imgloc"}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
            "(*", "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\
\:044f2", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{
                 "imgloc", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "-", 
                 RowBox[{
                 "location2", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}]}], "]"}], "<", 
               RowBox[{"Abs", "[", "focus2", "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Large", "]"}], ",", "Thick", ",", 
                "Dashed", ",", "Blue", ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "img2loc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                   "img2loc"}], "}"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Large", "]"}], ",", "Thick", ",", 
                "Blue", ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "img2loc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                   "img2loc"}], "}"}], "]"}]}], "}"}]}], "]"}]}], 
           "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "\:041e\:043f\:0446\:0456\:0457", " ", 
          "\:0413\:0440\:0430\:0444\:0456\:043a\:0430"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"550", ",", "350"}], "}"}]}], ",", 
        RowBox[{"Axes", "\[Rule]", "axes"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "10"}], ",", "3.5"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"ImagePadding", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"10", ",", "10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "40"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Column", "[", 
            RowBox[{"{", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                "ptobj", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "\[Equal]", "0"}], ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"Text", "[", 
                RowBox[{
                "\"\<                         Linear magnification\\nan \
eyepiece: \>\"", "<>", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"k1", "=", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"magnification", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "*", 
                    RowBox[{"imagedistance", "[", 
                    RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", 
                    "objdist"}], "]"}], ",", ".01"}], "]"}], "]"}]}], "]"}], 
                 "<>", "\"\<, an ocular lense: \>\"", "<>", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"k2", "=", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"magnification2", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "*", 
                    RowBox[{"image2distance", "[", 
                    RowBox[{"focus2", ",", "obj2dist"}], "]"}]}], ",", 
                    "obj2dist"}], "]"}], ",", ".01"}], "]"}], "]"}]}], "]"}], 
                 "<>", "\"\<, a microscope: \>\"", "<>", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"k1", "*", "k2"}], "]"}]}], "]"}]}], "]"}], "}"}], 
            "]"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]}], 
    RowBox[{"(*", 
     RowBox[{"End", " ", "Graphics"}], "*)"}], "\[IndentingNewLine]", "]"}], 
   ",", 
   RowBox[{"(*", 
    RowBox[{"End", " ", "Module"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "\:0456\:043d\:0441\:0442\:0440\:0443\:043c\:0435\:043d\:0442\:0438", " ",
      "\:0434\:043b\:044f", " ", 
     "\:043a\:0435\:0440\:0443\:0432\:0430\:043d\:043d\:044f"}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"focus", ",", "3", ",", "\"\<left lens focal length\>\""}], 
      "}"}], ",", "2.0", ",", "3.5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"focus2", ",", "1.4", ",", "\"\<right lens focal length\>\""}], 
      "}"}], ",", "0.5", ",", "2.0", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptobj", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "9"}], ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"location", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
        "location2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        "-", "focus", "-", "focus2"}], ",", "0"}], "}"}], ",", "Locator"}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"location2", ",", 
       RowBox[{"{", 
        RowBox[{"4.67", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
        "location", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        "+", "focus", "+", "focus2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "0"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"axes", ",", "False", ",", "\"\<coordinates\>\""}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ray1", ",", "True", ",", "\"\<ray 1\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ray2", ",", "True", ",", "\"\<ray 2\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ray3", ",", "True", ",", "\"\<ray 3\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Reset to initial values.\>\"", ",", 
     RowBox[{
      RowBox[{"focus", " ", "=", " ", "3"}], ";", 
      RowBox[{"focus2", "=", "1.4"}], ";", 
      RowBox[{"ptobj", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "9"}], ",", "1"}], "}"}]}], ";", 
      RowBox[{"location", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "0"}], "}"}]}], ";", 
      RowBox[{"location2", "=", " ", 
       RowBox[{"{", 
        RowBox[{"4.67", ",", "0"}], "}"}]}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", "Top"}], ",", "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", "Manipulate"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.445362050672737*^9, 3.445362061125795*^9}, {
   3.445362135047197*^9, 3.4453622228122597`*^9}, {3.4453624448889637`*^9, 
   3.4453624699513035`*^9}, {3.4453625177166224`*^9, 
   3.4453626504970226`*^9}, {3.4453626863717933`*^9, 
   3.4453626950592375`*^9}, {3.445362725293419*^9, 3.4453627648869157`*^9}, {
   3.445383172922701*^9, 3.4453831919417267`*^9}},
 CellID->84583529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`axes$$ = False, $CellContext`focus$$ = 
    3, $CellContext`focus2$$ = 0.758, $CellContext`location$$ = {-4, 
    0}, $CellContext`location2$$ = {4.67, 0}, $CellContext`ptobj$$ = {-9, 
    1}, $CellContext`ray1$$ = True, $CellContext`ray2$$ = 
    True, $CellContext`ray3$$ = True, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`focus$$], 3, "left lens focal length"}, 2., 3.5}, {{
       Hold[$CellContext`focus2$$], 1.4, "right lens focal length"}, 0.5, 
      2.}, {{
       Hold[$CellContext`ptobj$$], {-9, 1}}, {-10, -2}, {0, 2}}, {{
       Hold[$CellContext`location$$], {-4, 0}}, {-8, 0}, 
      Dynamic[{
       Part[$CellContext`location2$$, 
          1] - $CellContext`focus$$ - $CellContext`focus2$$, 0}]}, {{
       Hold[$CellContext`location2$$], {4.67, 0}}, 
      Dynamic[{
       Part[$CellContext`location$$, 
          1] + $CellContext`focus$$ + $CellContext`focus2$$, 0}], {8, 0}}, {{
       Hold[$CellContext`axes$$], False, "coordinates"}, {True, False}}, {{
       Hold[$CellContext`ray1$$], True, "ray 1"}, {True, False}}, {{
       Hold[$CellContext`ray2$$], True, "ray 2"}, {True, False}}, {{
       Hold[$CellContext`ray3$$], True, "ray 3"}, {True, False}}, {
      Hold[
       Button[
       "Reset to initial values.", $CellContext`focus$$ = 
         3; $CellContext`focus2$$ = 
         1.4; $CellContext`ptobj$$ = {-9, 1}; $CellContext`location$$ = {-4, 
          0}; $CellContext`location2$$ = {4.67, 0}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    550., {173., 177.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`focus$1761$$ = 
    0, $CellContext`focus2$1762$$ = 0, $CellContext`ptobj$1763$$ = {0, 
    0}, $CellContext`location$1764$$ = 0, $CellContext`location2$1765$$ = 
    0, $CellContext`axes$1766$$ = False, $CellContext`ray1$1767$$ = 
    False, $CellContext`ray2$1768$$ = False, $CellContext`ray3$1769$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`axes$$ = False, $CellContext`focus$$ = 
        3, $CellContext`focus2$$ = 
        1.4, $CellContext`location$$ = {-4, 0}, $CellContext`location2$$ = {
         4.67, 0}, $CellContext`ptobj$$ = {-9, 1}, $CellContext`ray1$$ = 
        True, $CellContext`ray2$$ = True, $CellContext`ray3$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`focus$$, $CellContext`focus$1761$$, 0], 
        Hold[$CellContext`focus2$$, $CellContext`focus2$1762$$, 0], 
        Hold[$CellContext`ptobj$$, $CellContext`ptobj$1763$$, {0, 0}], 
        Hold[$CellContext`location$$, $CellContext`location$1764$$, 0], 
        Hold[$CellContext`location2$$, $CellContext`location2$1765$$, 0], 
        Hold[$CellContext`axes$$, $CellContext`axes$1766$$, False], 
        Hold[$CellContext`ray1$$, $CellContext`ray1$1767$$, False], 
        Hold[$CellContext`ray2$$, $CellContext`ray2$1768$$, False], 
        Hold[$CellContext`ray3$$, $CellContext`ray3$1769$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`h$ = 2., $CellContext`h2$ = 
         2.5, $CellContext`head$, $CellContext`radius$, \
$CellContext`radius2$, $CellContext`lfocusloc$, $CellContext`rfocusloc$, \
$CellContext`lfocusloc2$, $CellContext`rfocusloc2$, $CellContext`imgloc$, \
$CellContext`img2loc$, $CellContext`objdist$, $CellContext`obj2dist$}, \
$CellContext`imagedistance[
           Pattern[$CellContext`focus$, 
            Blank[]], 
           Pattern[$CellContext`objdistance$, 
            Blank[]]] := If[
           Or[
           Part[$CellContext`ptobj$$, 1] == Part[$CellContext`rfocusloc$, 1], 
            Part[$CellContext`ptobj$$, 1] == 
            Part[$CellContext`lfocusloc$, 1], $CellContext`objdistance$ == 0],
            0, 
           Part[
            Solve[
            1/$CellContext`focus$ == 
             1/$CellContext`objdistance$ + 1/$CellContext`q, $CellContext`q], 
            1, 1, 2]]; $CellContext`image2distance[
           Pattern[$CellContext`focus2$, 
            Blank[]], 
           Pattern[$CellContext`objdistance$, 
            Blank[]]] := If[
           Or[
           Part[$CellContext`imgloc$, 1] == Part[$CellContext`rfocusloc2$, 1],
             Part[$CellContext`ptobj$$, 1] == 
            Part[$CellContext`lfocusloc2$, 1], $CellContext`objdistance$ == 
            0], 0, 
           Part[
            Solve[
            1/$CellContext`focus2$ == 
             1/$CellContext`objdistance$ + 1/$CellContext`q, $CellContext`q], 
            1, 1, 2]]; $CellContext`magnification[
           Pattern[$CellContext`imgdistance$, 
            Blank[]], 
           Pattern[$CellContext`objdistance$, 
            Blank[]]] := If[
           Or[
           Part[$CellContext`ptobj$$, 1] == Part[$CellContext`rfocusloc$, 1], 
            Part[$CellContext`ptobj$$, 1] == 
            Part[$CellContext`lfocusloc$, 1], $CellContext`objdistance$ == 
            0, $CellContext`imgdistance$ == 0], 
           0, $CellContext`imgdistance$/$CellContext`objdistance$]; \
$CellContext`magnification2[
           Pattern[$CellContext`imgdistance$, 
            Blank[]], 
           Pattern[$CellContext`objdistance$, 
            Blank[]]] := If[
           Or[
           Part[$CellContext`imgloc$, 1] == Part[$CellContext`rfocusloc2$, 1],
             Part[$CellContext`imgloc$, 1] == 
            Part[$CellContext`lfocusloc2$, 1], $CellContext`objdistance$ == 
            0, $CellContext`imgdistance$ == 0], 
           0, $CellContext`imgdistance$/$CellContext`objdistance$]; \
$CellContext`radius$ = 4 $CellContext`focus$$; $CellContext`radius2$ = 
         10 $CellContext`focus2$$; $CellContext`lfocusloc$ = \
{-$CellContext`focus$$ + Part[$CellContext`location$$, 1], 
           0}; $CellContext`rfocusloc$ = {$CellContext`focus$$ + 
           Part[$CellContext`location$$, 1], 
           0}; $CellContext`lfocusloc2$ = {-$CellContext`focus2$$ + 
           Part[$CellContext`location2$$, 1], 
           0}; $CellContext`rfocusloc2$ = {$CellContext`focus2$$ + 
           Part[$CellContext`location2$$, 1], 0}; $CellContext`objdist$ = 
         Abs[Part[$CellContext`location$$, 1] - 
           Part[$CellContext`ptobj$$, 1]]; $CellContext`imgloc$ = 
         If[Part[$CellContext`ptobj$$, 1] < 
           Part[$CellContext`location$$, 1], {
           Part[$CellContext`location$$, 
              1] + $CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], \
$CellContext`magnification[-$CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], $CellContext`objdist$] 
            Part[$CellContext`ptobj$$, 2]}, {
           Part[$CellContext`location$$, 
              1] - $CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], \
$CellContext`magnification[-$CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], $CellContext`objdist$] 
            Part[$CellContext`ptobj$$, 2]}]; $CellContext`obj2dist$ = 
         Abs[Part[$CellContext`location2$$, 1] - 
           Part[$CellContext`imgloc$, 1]]; $CellContext`img2loc$ = {
          Part[$CellContext`location2$$, 
             1] + $CellContext`image2distance[$CellContext`focus2$$, \
$CellContext`obj2dist$], \
$CellContext`magnification2[-$CellContext`image2distance[$CellContext`focus2$$\
, $CellContext`obj2dist$], $CellContext`obj2dist$] 
           Part[$CellContext`imgloc$, 2]}; $CellContext`head$ = Graphics[
           
           Line[{{(-1)/2, 1/4}, {0, 
             0}, {(-1)/2, (-1)/4}}]]; $CellContext`source[{
            Pattern[$CellContext`x0, 
             Blank[]], 
            Pattern[$CellContext`y0, 
             Blank[]]}, 
           Pattern[$CellContext`r0, 
            Blank[]]] := {Orange, 
           Disk[{$CellContext`x0, $CellContext`y0}, $CellContext`r0], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
              2 $CellContext`r0, $CellContext`y0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
              2 $CellContext`r0, $CellContext`y0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0, \
$CellContext`y0 + 2 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0, \
$CellContext`y0 - 2 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
              1.6 $CellContext`r0, $CellContext`y0 - 1.6 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
              1.6 $CellContext`r0, $CellContext`y0 - 1.6 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
              1.6 $CellContext`r0, $CellContext`y0 + 1.6 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
              1.6 $CellContext`r0, $CellContext`y0 + 
              1.6 $CellContext`r0}}]}; $CellContext`line2[{{
             Pattern[$CellContext`x1, 
              Blank[]], 
             Pattern[$CellContext`y1, 
              Blank[]]}, {
             Pattern[$CellContext`x2, 
              Blank[]], 
             Pattern[$CellContext`y2, 
              Blank[]]}}, {
            Pattern[$CellContext`x3, 
             Blank[]], 
            Pattern[$CellContext`x4, 
             Blank[]]}] := 
         Line[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; $CellContext`arrow2[{{
             Pattern[$CellContext`x1, 
              Blank[]], 
             Pattern[$CellContext`y1, 
              Blank[]]}, {
             Pattern[$CellContext`x2, 
              Blank[]], 
             Pattern[$CellContext`y2, 
              Blank[]]}}, {
            Pattern[$CellContext`x3, 
             Blank[]], 
            Pattern[$CellContext`x4, 
             Blank[]]}] := 
         Arrow[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; $CellContext`y31 := \
((Part[$CellContext`imgloc$, 2] - Part[$CellContext`ptobj$$, 2])/(
            Part[$CellContext`imgloc$, 1] - Part[$CellContext`location$$, 1]))
             Part[$CellContext`location2$$, 1] + (
            Part[$CellContext`imgloc$, 1] Part[$CellContext`ptobj$$, 2] - 
            Part[$CellContext`location$$, 1] Part[$CellContext`imgloc$, 2])/(
           Part[$CellContext`imgloc$, 1] - 
           Part[$CellContext`location$$, 
            1]); $CellContext`y32 := ((Part[$CellContext`imgloc$, 2] - 
             Part[$CellContext`ptobj$$, 2])/(Part[$CellContext`imgloc$, 1] - 
            Part[$CellContext`ptobj$$, 1])) 
           Part[$CellContext`location2$$, 1] + (
            Part[$CellContext`imgloc$, 1] Part[$CellContext`ptobj$$, 2] - 
            Part[$CellContext`ptobj$$, 1] Part[$CellContext`imgloc$, 2])/(
           Part[$CellContext`imgloc$, 1] - Part[$CellContext`ptobj$$, 1]); 
        Graphics[{{Thick, Gray, 
            
            Circle[{Part[$CellContext`location$$, 1] + 
              Sqrt[$CellContext`radius$^2 - $CellContext`h$^2], 
              0}, $CellContext`radius$, {
             Pi - ArcTan[$CellContext`h$/
               Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]], Pi + 
              ArcTan[$CellContext`h$/
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]}]}, {
           Thick, Gray, 
            Circle[{
             Part[$CellContext`location$$, 1] - 
              Sqrt[$CellContext`radius$^2 - $CellContext`h$^2], 
              0}, $CellContext`radius$, {-
              ArcTan[$CellContext`h$/
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]], 
              
              ArcTan[$CellContext`h$/
               Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]}]}, {
           Thick, Gray, 
            
            Circle[{Part[$CellContext`location2$$, 1] + 
              Sqrt[$CellContext`radius2$^2 - $CellContext`h2$^2], 
              0}, $CellContext`radius2$, {
             Pi - ArcTan[$CellContext`h2$/
               Sqrt[$CellContext`radius2$^2 - $CellContext`h2$^2]], Pi + 
              ArcTan[$CellContext`h2$/
                Sqrt[$CellContext`radius2$^2 - $CellContext`h2$^2]]}]}, {
           Thick, Gray, 
            
            Circle[{Part[$CellContext`location2$$, 1] - 
              Sqrt[$CellContext`radius2$^2 - $CellContext`h2$^2], 
              0}, $CellContext`radius2$, {-
              ArcTan[$CellContext`h2$/
                Sqrt[$CellContext`radius2$^2 - $CellContext`h2$^2]], 
              
              ArcTan[$CellContext`h2$/
               Sqrt[$CellContext`radius2$^2 - $CellContext`h2$^2]]}]}, {
            Arrowheads[{{Automatic, Automatic, $CellContext`head$}}], Thick, 
            Arrow[{{
               Part[$CellContext`location$$, 1], 0}, {
               Part[$CellContext`location$$, 1], 1.3 $CellContext`h$}}]}, {
            Arrowheads[{{Automatic, Automatic, $CellContext`head$}}], Thick, 
            Arrow[{{
               Part[$CellContext`location$$, 1], 0}, {
               Part[$CellContext`location$$, 1], (-1.3) $CellContext`h$}}]}, {
           
            PointSize[Medium], Red, 
            Point[$CellContext`rfocusloc$]}, 
           Text[
            Style[
            "F", FontSize -> 14, Italic, FontColor -> 
             Red], $CellContext`rfocusloc$ + 0.3], {
            PointSize[Medium], Red, 
            Point[$CellContext`lfocusloc$]}, {
            Arrowheads[{{Automatic, Automatic, $CellContext`head$}}], Thick, 
            Arrow[{{
               Part[$CellContext`location2$$, 1], 0}, {
               Part[$CellContext`location2$$, 1], 1.3 $CellContext`h$}}]}, {
            Arrowheads[{{Automatic, Automatic, $CellContext`head$}}], Thick, 
            Arrow[{{
               Part[$CellContext`location2$$, 1], 0}, {
               Part[$CellContext`location2$$, 1], (-1.3) $CellContext`h$}}]}, {
            PointSize[Medium], 
            Darker[Red, 0.7], 
            Point[$CellContext`rfocusloc2$]}, 
           Text[
            Style[
            "F'", FontSize -> 14, Italic, FontColor -> 
             Darker[Red, 0.7]], $CellContext`lfocusloc2$ + 0.3], {
            PointSize[Medium], 
            Darker[Red, 0.7], 
            Point[$CellContext`lfocusloc2$]}, {
            Arrowheads[Medium], Thick, Blue, 
            Arrow[{{
               Part[$CellContext`ptobj$$, 1], 0}, $CellContext`ptobj$$}]}, {
           Thin, 
            Line[{{-10, 0}, {8, 0}}]}, 
           Line[{{
              Part[$CellContext`location$$, 1], -$CellContext`h$}, {
              Part[$CellContext`location$$, 1], $CellContext`h$}}], {
            If[$CellContext`ray1$$, {{
               Arrowheads[Medium], Brown, 
               Line[{$CellContext`ptobj$$, {
                  Part[$CellContext`location$$, 1], 
                  Part[$CellContext`ptobj$$, 2]}}]}, {
               Arrowheads[Medium], Brown, 
               $CellContext`line2[{{
                  Part[$CellContext`location$$, 1], 
                  Part[$CellContext`ptobj$$, 2]}, $CellContext`imgloc$}, {
                 Part[$CellContext`location$$, 1], 
                 Part[$CellContext`location2$$, 1]}]}, 
              Arrowheads[Medium], Brown, 
              $CellContext`arrow2[{$CellContext`img2loc$, {
                 Part[$CellContext`location2$$, 1], $CellContext`y31}}, {
                Part[$CellContext`location2$$, 1], 
                Part[$CellContext`rfocusloc2$, 1] + $CellContext`focus2$$}], 
              Brown, Dashed, 
              Line[{{
                 
                 Part[$CellContext`location2$$, 
                  1], $CellContext`y31}, $CellContext`img2loc$}]}, {}], 
            If[$CellContext`ray2$$, {
              Arrowheads[Medium], Pink, 
              $CellContext`line2[{$CellContext`ptobj$$, \
$CellContext`imgloc$}, {
                Part[$CellContext`ptobj$$, 1], 
                Part[$CellContext`location2$$, 1]}], 
              Arrowheads[Medium], Pink, 
              $CellContext`arrow2[{$CellContext`img2loc$, {
                 Part[$CellContext`location2$$, 1], $CellContext`y32}}, {
                Part[$CellContext`location2$$, 1], 
                Part[$CellContext`rfocusloc2$, 1] + $CellContext`focus2$$}], {
              Pink, Dashed, 
               Line[{{
                  
                  Part[$CellContext`location2$$, 
                   1], $CellContext`y32}, $CellContext`img2loc$}]}}, {}], 
            If[$CellContext`ray3$$, {{
               Arrowheads[Medium], 
               Darker[Green, 0.6], 
               Line[{{
                  Part[$CellContext`location$$, 1], 
                  Part[$CellContext`imgloc$, 2]}, {
                  Part[$CellContext`location2$$, 1], 
                  Part[$CellContext`imgloc$, 2]}}]}, {
               Arrowheads[Medium], 
               Darker[Green, 0.6], 
               Line[{$CellContext`ptobj$$, {
                  Part[$CellContext`location$$, 1], 
                  Part[$CellContext`imgloc$, 2]}}]}, {
               Arrowheads[Medium], 
               Darker[Green, 0.6], 
               $CellContext`arrow2[{{
                  Part[$CellContext`location2$$, 1], 
                  Part[$CellContext`imgloc$, 2]}, $CellContext`rfocusloc2$}, {
                
                 Part[$CellContext`location2$$, 1], 
                 Part[$CellContext`rfocusloc2$, 
                   1] + $CellContext`focus2$$}]}, {
               Darker[Green, 0.6], Dashed, 
               Line[{{
                  Part[$CellContext`location2$$, 1], 
                  
                  Part[$CellContext`imgloc$, 
                   2]}, $CellContext`img2loc$}]}}, {}], 
            If[
            Abs[Part[$CellContext`ptobj$$, 1] - 
               Part[$CellContext`location$$, 1]] < Abs[$CellContext`focus$$], {
              Arrowheads[Medium], Thick, Dashed, Blue, 
              Arrow[{{
                 Part[$CellContext`imgloc$, 1], 0}, $CellContext`imgloc$}]}, {
             
              Arrowheads[Medium], Thick, Blue, 
              Arrow[{{
                 Part[$CellContext`imgloc$, 1], 0}, $CellContext`imgloc$}]}], 
            
            If[
            Abs[Part[$CellContext`imgloc$, 1] - 
               Part[$CellContext`location2$$, 1]] < 
             Abs[$CellContext`focus2$$], {
              Arrowheads[Large], Thick, Dashed, Blue, 
              Arrow[{{
                 Part[$CellContext`img2loc$, 1], 
                 0}, $CellContext`img2loc$}]}, {
              Arrowheads[Large], Thick, Blue, 
              Arrow[{{
                 Part[$CellContext`img2loc$, 1], 
                 0}, $CellContext`img2loc$}]}]}}, ImageSize -> {550, 350}, 
          Axes -> $CellContext`axes$$, PlotRange -> {{-10, 10}, {-10, 3.5}}, 
          ImagePadding -> {{10, 10}, {0, 40}}, PlotLabel -> Style[
            Column[{
              If[Part[$CellContext`ptobj$$, 2] == 0, "  ", 
               Text[
                StringJoin[
                "                         Linear magnification\nan eyepiece: \
", 
                 ToString[$CellContext`k1 = Abs[
                    Round[
                    $CellContext`magnification[-$CellContext`imagedistance[$\
CellContext`focus$$, $CellContext`objdist$], $CellContext`objdist$], 0.01]]], 
                 ", an ocular lense: ", 
                 ToString[$CellContext`k2 = Abs[
                    Round[
                    $CellContext`magnification2[-$CellContext`image2distance[$\
CellContext`focus2$$, $CellContext`obj2dist$], $CellContext`obj2dist$], 
                    0.01]]], ", a microscope: ", 
                 ToString[$CellContext`k1 $CellContext`k2]]]]}], FontSize -> 
            14]]], "Specifications" :> {{{$CellContext`focus$$, 3, 
          "left lens focal length"}, 2., 3.5, Appearance -> 
         "Labeled"}, {{$CellContext`focus2$$, 1.4, "right lens focal length"},
          0.5, 2., Appearance -> 
         "Labeled"}, {{$CellContext`ptobj$$, {-9, 1}}, {-10, -2}, {0, 2}, 
         ControlType -> Locator}, {{$CellContext`location$$, {-4, 0}}, {-8, 
         0}, 
         Dynamic[{
          Part[$CellContext`location2$$, 
             1] - $CellContext`focus$$ - $CellContext`focus2$$, 0}], 
         ControlType -> Locator}, {{$CellContext`location2$$, {4.67, 0}}, 
         Dynamic[{
          Part[$CellContext`location$$, 
             1] + $CellContext`focus$$ + $CellContext`focus2$$, 0}], {8, 0}, 
         ControlType -> 
         Locator}, {{$CellContext`axes$$, False, "coordinates"}, {
         True, False}}, {{$CellContext`ray1$$, True, "ray 1"}, {
         True, False}}, {{$CellContext`ray2$$, True, "ray 2"}, {
         True, False}}, {{$CellContext`ray3$$, True, "ray 3"}, {True, False}}, 
        Button[
        "Reset to initial values.", $CellContext`focus$$ = 
          3; $CellContext`focus2$$ = 
          1.4; $CellContext`ptobj$$ = {-9, 1}; $CellContext`location$$ = {-4, 
           0}; $CellContext`location2$$ = {4.67, 0}]}, 
      "Options" :> {ControlPlacement -> Top, TrackedSymbols :> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{601., {280., 285.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->83045801],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration shows the linear magnification for a pair of lenses such \
as in a microscope or telescope.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Ray Diagrams for Microscope and Telescope",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
RayDiagramsForMicroscopeAndTelescope/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/RayDiagramsForMicroscopeAndTelescope/"],\

 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
RayDiagramsForMicroscopeAndTelescope/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
RayDiagramsForMicroscopeAndTelescope/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/RayDiagramsForMicroscopeAndTelescope/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Volodymyr Holovatsky",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"],
 " (Chernivtsi National University, Ukraine)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->148158409],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
RayDiagramsForMicroscopeAndTelescope"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Ray Diagrams for Microscope and Telescope - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[643, 23, 161, 3, 70, "Section"],
Cell[807, 28, 3700, 64, 70, "Section"],
Cell[4510, 94, 62126, 1568, 70, "Input",
 CellID->84583529]
}, Open  ]],
Cell[CellGroupData[{
Cell[66673, 1667, 22795, 462, 70, "Output",
 CellID->83045801],
Cell[CellGroupData[{
Cell[89493, 2133, 209, 6, 70, "Section"],
Cell[89705, 2141, 134, 3, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89887, 2150, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[90245, 2161, 1014, 30, 70, "Text"],
Cell[91262, 2193, 523, 17, 70, "Text",
 CellID->148158409],
Cell[CellGroupData[{
Cell[91810, 2214, 815, 24, 70, "Text"],
Cell[92628, 2240, 1208, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature @TN4GxaHVp@4dDDrPmn#vhvH *)
