(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    476505,       8480]
NotebookOptionsPosition[    474559,       8413]
NotebookOutlinePosition[    475250,       8439]
CellTagsIndexPosition[    475207,       8436]
WindowTitle->Motion, Pursuit, Fixate, and Distractor (Visual Depth Perception \
2) - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Motion, Pursuit, Fixate, and Distractor (Visual Depth Perception 2)\
\>", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"framelabel", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"HoldForm", "[", 
         FractionBox[
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "\[InvisibleSpace]", 
           "\[Alpha]"}], 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "\[InvisibleSpace]", 
           "t"}]], "]"}], ",", "\"\<\[Degree]/sec\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"HoldForm", "[", 
         FractionBox[
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "\[InvisibleSpace]", 
           "\[Theta]"}], 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "\[InvisibleSpace]", 
           "t"}]], "]"}], ",", "\"\<\[Degree]/sec\>\""}], "}"}], "]"}]}], 
    "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.4270473128012037`*^9, 3.427047323112714*^9}, {
   3.4270475452632604`*^9, 3.4270475867749*^9}, {3.427058570904027*^9, 
   3.427058577683975*^9}},
 CellID->347766915],

Cell[BoxData[{
 RowBox[{
  RowBox[{"depthPlain", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"i", " ", 
      FractionBox["mm", "pp"], 
      FractionBox[
       RowBox[{" ", "180"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"pp", "-", "mm"}], ")"}], "\[Pi]"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"pp", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"mm", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{".99", "pp"}]}], "}"}], ",", 
     RowBox[{"FrameLabel", "->", "framelabel"}], ",", 
     RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
     RowBox[{"ContourShading", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"{", "Brown", "}"}]}], ",", 
     RowBox[{"Contours", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", 
        RowBox[{"-", "30"}], ",", 
        RowBox[{"-", "50"}], ",", 
        RowBox[{"-", "70"}], ",", 
        RowBox[{"-", "90"}], ",", "10", ",", "30", ",", "50", ",", "70", ",", 
        "90", ",", "110"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"depth", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"depthPlain", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Brown", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"10", ",", "10"}], "}"}]}], "}"}], "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"20", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
        "}"}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Brown", ",", 
         RowBox[{"Dashing", "[", ".01", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"18", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "\[Pi]"}], "/", "2.2"}], ",", 
               RowBox[{"\[Pi]", "/", "3"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<-f\[ShortLeftArrow]d\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"1.4", ",", 
               RowBox[{"-", "8"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<d=0\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "1"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\[Infinity]\[ShortLeftArrow]d\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"8", ",", "7"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<d=10\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"15", ",", "4"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<d=30\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"12", ",", "6"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<d=-30\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", 
               RowBox[{"-", "7"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<d=-10\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"13", ",", 
               RowBox[{"-", "6"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<d\[UpperRightArrow]\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"16", ",", 
               RowBox[{"-", "3"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"framePlain", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"180", " ", 
      FractionBox["i", 
       RowBox[{"\[Pi]", " ", "pp"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"pp", ",", "0.01", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"mm", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"FrameLabel", "->", "framelabel"}], ",", 
     RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
     RowBox[{"ContourShading", "\[Rule]", "False"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", "Blue"}], ",", 
     RowBox[{"Contours", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "20", ",", "40", ",", "60", ",", "80", ",", "100", ",", "120", ",", 
        "140", ",", "160"}], "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frame", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"framePlain", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Black", ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"20", ",", "0"}], "}"}]}], "}"}], "]"}], "}"}]}], "}"}],
        "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"Dashing", "[", ".01", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"20", ",", "5"}], "}"}]}], "}"}], "]"}], "}"}]}], "}"}],
        "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{"\"\<f=20\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"180", 
                RowBox[{
                 RowBox[{"i", "/", "20"}], "/", "\[Pi]"}]}], ",", "9"}], 
              "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<f=40\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"180", 
                RowBox[{
                 RowBox[{"i", "/", "40"}], "/", "\[Pi]"}]}], ",", "9"}], 
              "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<f=60\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"180", 
                RowBox[{
                 RowBox[{"i", "/", "60"}], "/", "\[Pi]"}]}], ",", "9"}], 
              "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\[Infinity]\[ShortLeftArrow]f\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "9"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<\[ShortLeftArrow]f\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"12", ",", "6"}], "}"}]}], "]"}]}], "}"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.4270468372687345`*^9, 3.4270468442993097`*^9}},
 CellID->405405697],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p", "=", 
     RowBox[{
      FractionBox["i", "f"], "*", 
      FractionBox["180", "\[Pi]"]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"m", "=", 
     RowBox[{
      FractionBox[
       RowBox[{"d", " ", "i"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", "f"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"n", " ", "r"}]}], ")"}]}]], "*", 
      FractionBox["180", "\[Pi]"]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"mp", "=", 
     RowBox[{"m", "/", "p"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"n", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{"i", "=", "6.5"}], ";", "\[IndentingNewLine]", 
    RowBox[{"r", "=", 
     RowBox[{"i", "/", "5"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"PM", "=", 
     RowBox[{"{", 
      RowBox[{"p", ",", "m"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"framePlain", ",", "depthPlain", ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "/", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]}], ",", " ", 
                  "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{
                    FractionBox[
                    RowBox[{"PM", " ", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], 
                    RowBox[{"PM", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]], 
                    FractionBox["1", 
                    RowBox[{"1", "-", 
                    RowBox[{
                    RowBox[{"PM", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/", 
                    RowBox[{"PM", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}]]}], ",", ".01"}], 
                   "]"}], ",", " ", "\"\<, \>\"", ",", 
                  RowBox[{"HoldForm", "[", 
                   RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "\[InvisibleSpace]\[InvisibleSpace]", 
                    RowBox[{"\[Theta]", "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "\[InvisibleSpace]\[InvisibleSpace]",
                     "\[Alpha]"}], ")"}]}]}], "]"}], ",", "\"\< = \>\"", ",", 
                  
                  RowBox[{"Round", "[", 
                   RowBox[{
                    FractionBox[
                    RowBox[{"PM", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], 
                    RowBox[{"PM", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]], ",", ".01"}], "]"}]}], 
                 "}"}], "]"}], ",", 
               RowBox[{"PM", "+", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"20", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", " ", "mp"}], "}"}]}]}], "}"}], "]"}], ",", 
             RowBox[{"Point", "[", "PM", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{"f", ",", ".1"}], "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "}"}]}], 
          "\[IndentingNewLine]", "}"}], "]"}], ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{"d", ",", ".1"}], "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "4"}]}], "}"}]}], "]"}], "}"}]}], "}"}], "]"}]}],
        "\[IndentingNewLine]", "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "40", ",", "\"\<fixate distance f\>\""}], "}"}], ",", 
     "20", ",", "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "10", ",", "\"\<distractor distance d\>\""}], "}"}], 
     ",", 
     RowBox[{"-", "19.99"}], ",", "20"}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.42454310731907*^9, 3.42454322274771*^9}, {
   3.424543297128787*^9, 3.424543502528522*^9}, {3.4245435336313887`*^9, 
   3.424543605330659*^9}, {3.4245436405543222`*^9, 3.424543682209218*^9}, {
   3.4245437305603113`*^9, 3.424543923114499*^9}, {3.424543982245144*^9, 
   3.424543986591814*^9}, {3.424544197766048*^9, 3.424544252911542*^9}, {
   3.424544321170598*^9, 3.424544326192994*^9}, {3.424544359687179*^9, 
   3.424544376666967*^9}, {3.424544427058186*^9, 3.424544448452591*^9}, {
   3.424544585796297*^9, 3.4245445959450293`*^9}, {3.424544695608391*^9, 
   3.424544698208136*^9}, {3.4245447467779617`*^9, 3.4245447540372267`*^9}, {
   3.424544791617423*^9, 3.4245448538242893`*^9}, {3.424544888735424*^9, 
   3.424544899024452*^9}, {3.4245449311900578`*^9, 3.424545041847498*^9}, {
   3.4245450885886593`*^9, 3.4245451130154877`*^9}, {3.42454517665895*^9, 
   3.4245452110436697`*^9}, {3.424547435711906*^9, 3.424547449059849*^9}, {
   3.424547480605749*^9, 3.424547516764511*^9}, {3.4245475515231*^9, 
   3.4245475715326147`*^9}, {3.424553333115714*^9, 3.424553335941793*^9}, {
   3.4245535577717323`*^9, 3.424553559675061*^9}, {3.4245565917103567`*^9, 
   3.42455661079035*^9}, {3.424556659933188*^9, 3.424556732213067*^9}, {
   3.424557186728242*^9, 3.424557189569222*^9}, {3.4245574426259003`*^9, 
   3.424557450596944*^9}, {3.42455753949996*^9, 3.424557548473765*^9}, {
   3.424557592224399*^9, 3.424557600854862*^9}, {3.424557636304953*^9, 
   3.424557702813486*^9}, {3.424557842156947*^9, 3.424557845182549*^9}, {
   3.424557894199172*^9, 3.4245579092070723`*^9}, {3.424557940218605*^9, 
   3.424557943417416*^9}, {3.424559849568606*^9, 3.424559851438686*^9}, {
   3.424559936361961*^9, 3.424559985096877*^9}, {3.4245600585778627`*^9, 
   3.424560060831545*^9}, {3.424560109549329*^9, 3.4245601318619537`*^9}, {
   3.42456016563242*^9, 3.424560229302074*^9}, 3.424560273290029*^9, {
   3.424560317184278*^9, 3.4245604068977747`*^9}, {3.424589737201158*^9, 
   3.424589743538806*^9}, 3.424589819033544*^9, {3.4245903196915607`*^9, 
   3.424590424766468*^9}, {3.424590461010549*^9, 3.42459046141722*^9}, {
   3.424590571712069*^9, 3.424590574369974*^9}, {3.424590660551251*^9, 
   3.424590694514742*^9}, {3.424590743125107*^9, 3.424590776550805*^9}, {
   3.4245908280106707`*^9, 3.424590859986101*^9}, {3.424590957169578*^9, 
   3.4245909577332573`*^9}, {3.424591007939427*^9, 3.424591017742133*^9}, 
   3.4245915837588453`*^9, {3.424591660593298*^9, 3.424591748519754*^9}, {
   3.424594449788446*^9, 3.424594469874539*^9}, {3.424594509286147*^9, 
   3.424594536270196*^9}, {3.4245945688631268`*^9, 3.424594658377583*^9}, {
   3.424594695011937*^9, 3.42459473458963*^9}, {3.424594766387013*^9, 
   3.424594861347994*^9}, {3.424594904749234*^9, 3.424594927422928*^9}, {
   3.4246323230519943`*^9, 3.424632323733156*^9}, {3.424632573136394*^9, 
   3.424632592518023*^9}, {3.424632680228506*^9, 3.424632774191945*^9}, {
   3.424632808776948*^9, 3.4246328693526373`*^9}, {3.4246329188876534`*^9, 
   3.424632978456223*^9}, 3.4246331248469543`*^9, {3.424633156143722*^9, 
   3.4246332443132477`*^9}, {3.424633319526479*^9, 3.424633380239279*^9}, {
   3.424633413987027*^9, 3.4246334609436207`*^9}, {3.4246335059035587`*^9, 
   3.424633534601631*^9}, {3.424633579724267*^9, 3.424633685736771*^9}, {
   3.4246337339819803`*^9, 3.424633743616064*^9}, {3.424633813073597*^9, 
   3.4246338412696037`*^9}, {3.424633880479619*^9, 3.424633894706962*^9}, {
   3.42463392661981*^9, 3.424633926970729*^9}, {3.424633966895418*^9, 
   3.424634065521922*^9}, {3.4246341386850986`*^9, 3.4246341980636044`*^9}, {
   3.424634257213785*^9, 3.424634319455748*^9}, {3.424634363552197*^9, 
   3.4246343854924297`*^9}, {3.424634479590522*^9, 3.424634512881349*^9}, {
   3.424634567139263*^9, 3.424634640245956*^9}, {3.424634708067031*^9, 
   3.4246347845468493`*^9}, {3.424634842146813*^9, 3.4246348513324127`*^9}, {
   3.424634914874867*^9, 3.424634982156337*^9}, 3.42463501377588*^9, {
   3.424635047978888*^9, 3.4246350640333633`*^9}, 3.424682699246846*^9, {
   3.424683261214149*^9, 3.4246833557967873`*^9}, {3.424683412628961*^9, 
   3.424683419512727*^9}, {3.424683465314232*^9, 3.424683528241056*^9}, 
   3.424685458320215*^9, {3.424685498547023*^9, 3.424685510678047*^9}, {
   3.424685571823119*^9, 3.42468557470575*^9}, {3.424766070933445*^9, 
   3.424766133314885*^9}, {3.424766164580913*^9, 3.424766166395465*^9}, {
   3.4247662253704853`*^9, 3.424766289160022*^9}, {3.424766350702083*^9, 
   3.424766353562031*^9}, {3.424766394020574*^9, 3.424766406740734*^9}, {
   3.424766438911661*^9, 3.424766474050138*^9}, {3.424767492860324*^9, 
   3.424767536344288*^9}, {3.4247675755439577`*^9, 3.4247676155786247`*^9}, {
   3.4247677433544416`*^9, 3.424767750018324*^9}, {3.424767781628792*^9, 
   3.424767792827457*^9}, {3.424767859762644*^9, 3.424767863997056*^9}, {
   3.424767897286804*^9, 3.42476790894629*^9}, {3.42476802529702*^9, 
   3.424768046452623*^9}, 3.42476812155862*^9, {3.424768219089644*^9, 
   3.424768279143888*^9}, {3.426438213305889*^9, 3.4264382515937176`*^9}, {
   3.426438291362694*^9, 3.42643832703026*^9}, {3.4264383585044074`*^9, 
   3.4264383637289295`*^9}, {3.427046898122267*^9, 3.4270471271784005`*^9}, {
   3.427047224122218*^9, 3.4270472293248434`*^9}, {3.4302422269943643`*^9, 
   3.4302422408447495`*^9}, {3.4304949509110284`*^9, 3.4304949559275303`*^9}},
 
 CellID->1118830646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = 10, $CellContext`f$$ = 40, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`f$$], 40, "fixate distance f"}, 20, 200}, {{
       Hold[$CellContext`d$$], 10, "distractor distance d"}, -19.99, 20}}, 
    Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`f$650492$$ = 0, $CellContext`d$650493$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`d$$ = 10, $CellContext`f$$ = 40}, 
      "ControllerVariables" :> {
        Hold[$CellContext`f$$, $CellContext`f$650492$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$650493$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`p = ($CellContext`i/$CellContext`f$$) (180/
          Pi); $CellContext`m = ($CellContext`d$$ \
($CellContext`i/(($CellContext`d$$ + $CellContext`f$$) ($CellContext`f$$ + 
            DemonstrationsTools`n $CellContext`r)))) (180/
          Pi); $CellContext`mp = $CellContext`m/$CellContext`p; 
       DemonstrationsTools`n = 0; $CellContext`i = 
        6.5; $CellContext`r = $CellContext`i/
         5; $CellContext`PM = {$CellContext`p, $CellContext`m}; 
       Show[{$CellContext`framePlain, $CellContext`depthPlain, 
          Graphics[{Red, 
            AbsolutePointSize[4], {
             Text[
              Row[{Style["d", Italic]/Style["f", Italic], " = ", 
                
                Round[(Part[$CellContext`PM, 2]/Part[$CellContext`PM, 1]) (1/(
                  1 - Part[$CellContext`PM, 2]/Part[$CellContext`PM, 1])), 
                 0.01], ", ", 
                HoldForm[
                Style["d", Italic] ($CellContext`\[Theta]/(
                  Style["d", Italic] $CellContext`\[Alpha]))], " = ", 
                Round[
                Part[$CellContext`PM, 2]/Part[$CellContext`PM, 1], 
                 0.01]}], $CellContext`PM + {1, -1}], 
             Line[{{0, 0}, 20 {1, $CellContext`mp}}], 
             Point[$CellContext`PM]}}], 
          Graphics[{Red, {
             Text[
              Row[{
                Style["f", Italic], " = ", 
                Round[$CellContext`f$$, 0.1]}], {1, 4}]}}], 
          Graphics[{Red, {
             Text[
              Row[{
                Style["d", Italic], " = ", 
                Round[$CellContext`d$$, 0.1]}], {1, -4}]}}]}, 
         ImageSize -> {400, 400}]), 
      "Specifications" :> {{{$CellContext`f$$, 40, "fixate distance f"}, 20, 
         200}, {{$CellContext`d$$, 10, "distractor distance d"}, -19.99, 20}},
       "Options" :> {TrackedSymbols -> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{445., {256., 261.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`p = 9.310564170875878, $CellContext`i = 
        6.5, $CellContext`m = 1.8621128341751758`, DemonstrationsTools`n = 
        0, $CellContext`r = 1.3, $CellContext`mp = 
        0.2, $CellContext`PM = {9.310564170875878, 
         1.8621128341751758`}, $CellContext`framePlain = Graphics[
          GraphicsComplex[CompressedData["
1:eJxtnAuYjtXax8cwjOMYM8Yw50PJIaWi6N3Ng4QInUtEiVQbJZGKJJEkNY5J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           
           "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwV0L8rxGEAx/GHjkGXDJIBnZOSJH2d69IlpSQTl0ESZWDiyGGw3W63222G
G6RklRHnVwYLDn+C1zO8+nyf9/f51nX9G+XSTlMIYYuJVAiHLSEcsU+5NYRE
a3DBvfMjD7yTZYADd/dszp0fatSdn3mig6o7M3qwzaQY1U/svN5m07Qzpp/a
Rb3TdtFNop/ZZb3PZsiS08/tuj5khxkhr9fspp7Ee7FR0G/stl60U0wzqd/Z
ij5r5+Jvo6jX7bG+YEssxe/0D1vVV+wqawzq3zT4JO/9L5d8OV/ZW3o891Lx
za4d1/645sX5jdf4nzv/AxpZMQY=
                "]], 160]}, {
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwVz7kvw3Ecx+GvOBKDq6UaV0pEQ10dTAYiMZgkTAYLYRE1+AeYmZmZmSQq
JCLue2YTR5gkwmLi+Q1PXu9+2ubXNk8tjOUKQgiLpItCyBWHMM8cJ17HSkI4
0nq90KSea50OMetzM0xz6F7ldqBteqtPeqOfOkir/aHvvDHpexO88kKL97OM
26M88kDKrZcRe5h77mhy62HA7o9+M8c0uHXTZ2fZI0+dWxcZO802WyTdOmm2
G9lkg0T0WWrtOOusUe3WQZldyiorxNzaKbT/dFmf/c+l6D9qZfQczfBr71Nh
56Nn65U26aWmNM2P/c0Xu5S77WhCzzSup9Fv1Bqu7X8njzWC
                "]], 140]}, {
             
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwV0L0vg1EUwOHTaIkwMpgaicVsNptZLSJG4Y8gbISN1EbYCAbxlRhIbYSJ
alHeapksQiM87/Dkd3POcHNv7/j0yFQmIsbozEbc0dUaca/7PPBJiQZl8vYV
PeCJHx6pm3/lImaoOs9qhnnm+GaBRTpYZokmK6zSzRoFfllngzxbbPLHNjv0
s8duepc7D/WIAU45ocX8XC8Y5JIiOfMrvWaIW25oS9+vJYapUKbdPNEaozRI
zOrpe/TZH/RpVY95ZcLuRd9J6LGv6Vn6X0zav+kH/2U4QO4=
                "]], 120]}, {
             
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwVzyFIg1EUQOErOLUNbaJFhmKRKUOGioyhbbgwGLqk/mXMsKEgGNaGYUmL
aX3dbrfb7SbDQByI4vfC4VxOePe+tazX6M5ERBNPsxF3uYgyf+EbU2zORfT1
Q/MPfvGHLf1ePzbneB4LKOqPXNPzvIgl7OgjbujLvIJVlPQxt/QCr2MDu/oz
X6Rd6V1sp/v0F27rZd7DfrL+yl29ykfpNhzob3yr1/gE9fQf/Z37epNPcYaK
/sED/ZwvkaGqf/JQb3MHV2mPPuEHvcfXuEm79X8ZrSUk
                "]], 100]}, {
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwVzkEoAwAYhuF/NTs7u61cXJy5UCtOczEc7MJO22XbaaK2E8VciJTE0pJG
0srOnDlz5jxFTU4Onh3enr7bly5UFsuJiFhWNxnxMxJxyCoPOOA9v7nPIpv8
4h0/ucM1brPPW36wwRXW+c4O37jBLGt85TVfWGWGFT7zik8scYpFPrLNHguc
5DofeMkb5jnOVXbYYotLHGOOFzznMRc4yiyPeMY9zjPFOe7ylA3O8k8zqtsn
3OI0f4dftWlPpCL+ASh2MLM=
                "]], 80]}, {
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwVzbFKAlAYhuFfUZHIi2jtEmqxqaaCwKZcqilBSRqKBqOhKAqkECFCRCqk
RKKgoa2tob293aGhCJHocTg8fC8/nKm1ynI5EREFL5eKmM5EzLDKWe6lI5r8
YZ7b+hxr9iV/OT++0xd4Yl9xyEUe6Ets2C2OWOCxvsK23eYfV1nXi7y3Owx7
nU1u8Fm/ZtLeZIslvuq3TNlbvGGV73qXGXuHPe7yQ79j1q7xifv81HucsA/5
wiMO9D4n7dPxfzzjl/7AnH3ON17wW3/kP+NFL94=
                "]], 60]}, {
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwVzjtLwlEcx+ETRGMQIREiIaL4IpoEM7XyUpqXrqbds0FcokVapCEQGtza
2tra2tp6Vz3/4cPDd/gdTrL3WB8uhBAayi6GMFwK4UH3erf/mOEdb3WjN/uX
aV7zSpea2j9MccC+LjSxv5lkj+c605P9xQ2e8kTHGtmfTPCIXXWiP9kfjLPN
lg41sOdcZ5MNHUTv2TOucZ911aIb+5UxVlnRnqr2C1e5yx2VVbSfucJStLWt
nD3mMgvcUl6b9ohz/gNt/yLU
                "]], 40]}, {
              RGBColor[0, 0, 1], 
              Tooltip[
               Line[CompressedData["
1:eJwV0EdKA0AUgOEJBLc5g1fKzq0H0F0sEAtoIsQCagQb2MAGlkAsYINEA5pi
EtstLCfwm8XHz/Bm4DG9/YPpgUQIoY9UMoQW3z0hvGqTDj/ObX3WIYbJMMoI
L4wxTpZJJqgzTY4pZsjTYJY5CiwwT5MllllkhSIt1lhnlU024o5ss8MWe+zG
XTngkH2OOaLDKWecUOKcLhdcUuaaK9645Y4bHrjnnSqPVKjxxEd8459+4x3t
8slfnOkX/2uvQKM=
                "]], 20]}, {}, {}}}], {
          AspectRatio -> 1, Frame -> True, FrameLabel -> {
             Row[{
               
               HoldForm[(Style["d", Italic] $CellContext`\[Alpha])/(
                Style["d", Italic] $CellContext`t)], "\[Degree]/sec"}], 
             Row[{
               
               HoldForm[(Style["d", Italic] $CellContext`\[Theta])/(
                Style["d", Italic] $CellContext`t)], "\[Degree]/sec"}]}, 
           PlotRange -> {{0.01, 20}, {-10, 10}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {
             Scaled[0.02], 
             Scaled[0.02]}, RotateLabel -> False}], 
        Attributes[PlotRange] = {ReadProtected}, $CellContext`depthPlain = 
        Graphics[
          GraphicsComplex[CompressedData["
1:eJxcfQd0VUXXdjrppPeENELvCILIGREREBFpgiBFulQRkSYdRKUqIk16U3rv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           
           "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0T1IlXEUx/FjQURWdu/VStBBSCjnVCSkxNmGRDAEwYjs7ZaYb4OYhpOD
ZolkCi4lRFOITmJKwxXB3jCdmnMJDUJMh/zc4cf3nO85///z8Dwltx7feJQT
Ea+k+1REYX7EeTlIRkyfjJhJRXTx57izss9P8W/5Tr6Ay5d//AT/hu/gU1xS
9vhxPqF+wj9LRGxyfTjG3z4T8RJ79Rt8D77Qt/Cj2KX/wbfjc30zP4Jt+nV+
/XTEsH40LyLt/u/6bzKVG/HQzh87aWxy7gHel0mzu7htdg8bzVrxjrw2++J8
A/cVB935GavtruGEeY16jr+pn8dfnt3sHf7q38mQsxk7s9yuvt1OBXdFPW53
V31JivTv7RXjU32/rLh/gcvgR1ySRbluZxnrsNbemjvn9b/dt6ru930T2Xsw
Dwey/wUv2E3hVanyPqX2K7HWmVzp4dNymf/A76hH+OPZ74+f+LKCiKNmF/EE
ZsyK1duecUT9H+v1xyTpTAsW4hZfrr4mP9WHdIZWcQ==
                "]], 110]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0EtIlVEUhuGlaJKW98CBkyiwJikoEqTnxJlrIEIXEERBCkIJFSkRzQuC
hQQmSpE6EKGoCMthE41AdCaEXabVKA3Fqfj8g5d3rfXtvc86//mOnpburIhY
xs/SiKclEQtnIib5FU/xD/PdwoiX+pmiiBf8Tf/dfEI+r79bHDHH4/pd8zGe
1XeZP1aPYKkgYoiP5MPcKRvkR1iUDfCh7CG3y/q5L9lH9oAPZL3cJuvh7mRH
2Y5dZrjJvFN9/2zEFm+iyJ012X8uxB1nUu41oED/SbbH+bgpqzevQ57+o+wf
t5ov8kLyv7yd5utowA0041p5xKrz08job/ntP77Vb7T5Dof6I6xgVX/Azd4d
dnYEs849xxXZJfPXZm/wDm/xxPtTeK8+Zb/bZRE5nPHOZ7N73Cj/ghQ2zNK8
Zd+M97Z5zawm+X2u5gmMolpenNTOX1CXqlO4apeLdqrnjPv5GEi+L2rNP5jv
q6fN89x7xuvml89FZMuq+DR/lVWq97yfpT7mFn0uStxp5wr+a16nTuOX+gRa
gVri
                "]], 90]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0T9I1WEUxvEjlJZd6/ovTZcsuJs3TYSGFBwcoiCUEkzh2oVQE7Qpm8pr
FkUI5mT/hFJBXKolXZVaQsIlIpxaIoyEIFKQoM8dvjznPM97zvvy+9VlRzqH
CyJiEa8ORTwqjZjEfTzEA7zkfzkc8RU3SiI+0xE6fSRiXV1bFrHizA6tQX8y
os9cBsf0y7K/tBrXZD38K6jSv5P9oUeRlXXxL6NCX4lylCEju5eIuCgbdncp
L4le/gT/HH+In/Weq5jytrv8j+rr/BJnE+h2fpzf4vwg/yDvALr4OX4zf4D/
nPcCT/AMTzGf35mfR6u+sSKiAfU4hVWkUVwe8d69Y/ZtmblDF/W99Btdogt0
1l3z9DdmfIdRs7dw2+5db8jRHmfn5Oft3HHvTzNbuCD7YXe7vEi/H495U9gz
e9aeS+o1fNLPmn2T/xd4i7SdE8ghLWvACRxHCmfQIptGG1LuOolm97Xlvxtu
8odwmv+av62e5BeaTWCVv0FXaIE8Velb0w+8WvUvbwz1P9qh34ek+Qytot/5
TepWbKr/A6ReVqQ=
                "]], 70]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0c1LlGEUhvEjIQZ+lZaLKEVIN61so46ok5aGZoxjUUaKWW5a+LGINhGU
kKXTTJZam4hqERGYUBC1EtJq19euVVASQf0HQf5mcXGdcz/vOe/zztSOTqTH
CyLiGaZKI3ZXRFRjD26WRJzbHpHhMf4qO8tz+jM8y6P8RT7MN/Sn+ToP8Wf5
IM/oT/A1Psmf5EvFEQPqY0ghjX4syvv4KHpwBL1YkHfzYRxEFw7htryDO9GO
A0hiXp7gFjSiGU24JX9fFvEB9XiHdeTkLe713G9wj1f4e3nEFX7MBZXqbRHL
+oTzEjN3Oessh3V5Sp9GP946f5Lfb+9lc82yJjz1Gzxwjze8YudrrpPXYy+u
2vPI3Cn5b3sH+aF+Sj2JBbvuIIs1z/aZWeUs53Ax/78hgzkM5L9lR8Rxvm/m
BVd67y/3eqn+ydP270Ot8xrUoREJzMuTaFP/cJdL7pD0vmpu5xHeyhc8cx4N
+mXP/VVn5IXmirEq/8ivOPLfvDOiiNdku9R/3PG/s3+c0m9BuflhruIN+X51
K76pNwELgVkg
                "]], 50]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0T1IlWEUwPEniTItNetCDQ1BeP26pgWFYS0OZQ1BSy0RNDbUoqbeoiW1
tKv33j4tK2sqQaylIRHJuxiB1aZRBiItOqj0QQTV7x3+/M85zznPeR/enWcv
nDi/JoQwhVRhCENbQkhuDOERd/BjvqH+kNvlD7iNB7lX/T5flN/jVh7gHvW7
3CK/xXdwG9fVs3wT/cggjWvqKe6LZqN90d3oVt+zOYS92I061KJLPcE1qEQ1
qtCpXs4VKEOz/XHeV6pnawjDm7yhxLuQ0ztTHMIkt8njRfbyOnvXIyGeddZk
9igOY8L8EX5i7imey6vc+4w/cqOzA1yPF2bfy6ejeXcVur9PvR8pVMgznEUa
lfJFdy7hCz4jbm6Ov2LOjpP6TqHTnVfRLn7rfZ/sGhZPiVNmVrCMhPdf0vfT
bJJ/8WWe5GOc47S+DLI4Z88Gb8+P/o+83DeN6nujr4N/cKs937mFq/X9tvul
+LX+UR7jQWzzLaXOY/wO3/T1uC+BYnsKsKI27myV682knR3kBsz79qSeK9iB
Q9G/4zP4oL+Gm/Xv51qM6F+S9+pba74AE+rT/Ir/mdkV83/15dS2ixd9719n
f/i4PA9F5k9zjBfU68QNmBX/B+4Bcgk=
                "]], 30]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0UtszFEUx/FbNZi+W/UWSZWEqMSqFpXQeKSdYCEem1JGohtRlNFWH1RJ
ULFgWUlFUDR2NkxH0pVHJ7azkRDEo+JRLDTa+Mzim+89v3vOuf9OK+LNO47k
hBDeYG9hCEP5IUTKQ/haFsKp2SEkMF39QJ7LY/KTshOYpr4v78CAc4P5VFEI
w+iR9eo5j7M4h57sWd7NZ9CBLnRma3k7n0YrjheE0Mbd8qWlIRxTV/BRnuEb
9ntrljcbOea9tHM9Lynxvplb6oXqZajEQ9lNWbP5PSi1azeX8XVcQ6+elXr6
7VzBNzhdHMIoUu5a7E7KcrO/CSJYbnef3oz7Tuc65NtVgJj9683Uc1Sdh0n1
FGpl4+Y38C7eiTq7f/KgLM/Og+oox/mKbzjAW/ztKd7Ew7yZn3rzsbkX5ga9
8ZLv8UbZXX6uvs3P+A7PNFdibxMX8yG+bP82/Vsx4fv+yi7YnXGetD9pdq7z
Ex6w45+sWs9H57U87u4XfuO1u5g99fij/qznE/rl7/kDvsm/o8q+Jm+v4hpe
hzbvtiKBpJ5F+g/bFdezwLmR0zwPEW+PZnf6/S/aX4UiO6L4IUu6S+GqvFbW
xzV2vrWjXd2FxWhFAvvwytxqbtE7pq/aeYjH1Jey/3/zUaTkaX7EU2Yq5/ge
fSOy+c5f/LaT7iZ4uzoHheYbuJzfydc41yDj/B+1pXsl
                "]], 10]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV02loD3Acx/Gf0ubYZjNXc1/JwlxzLGoe2QNzbBpZFEWOoTYjRKIMyTPK
Awkb4pHSDnPfkyNXCnNMYXtAOcZyvn4PPnt/j8/3+/v9f///Bi5ZW7CmXQgh
w5+81BDOpISwNCmEwuQQLnYLoQArO4dQSofkc+XL9VvTQ/hB36lIrUp/HfVJ
C6EvzbJrNv3V/0e/6A/9pmDPet5CZ03jyaWH8o3yVXZ3MZ+PyTgDU/AoJuon
UF/+R/z9xCXqpXauxjIcwLscZ8prnLOCdyX15z0uf2IuU/4YN6nNEXfEBr0O
uKdLCC/0Tstv+VxL1ZbROfFVtXqso4Fqd+QD8GTcRYflneTF+g10TX4b6/Wq
3adOXoOZlK9+QT4TR9MHd87Cj/G97HhNW83d6xrCXUrkTaBFPBNxEo2nCZRN
5/lrzNZSNd2M5+FgrPQmN/AoXsdj+APf6v/EJhyNGd4iC6vtm2Jfq/ga71U6
xXNCXqt3gu+Tu/VW60OplEbv1G5iE24z3+iuo+LnivvjvLcd7rPst+8Alcfv
AavsvGzmifhpzM1lqlXiYzPzzc6jzWpFWEE7qcx9duFuGmpuSNxr/14zY/Ta
7P9JO9S2x3PdqRy/xndWn24uj3qKe1GOfr3+ZDzorDp3arRzJP9LfE2v6Ijd
q5xREn8rvM9prXiYerN9LfEt+LLNvcdMXKM/Pv6ecBzm4Bf+hWYzeBZgodpi
tQfyBJ4e2B53xd+UXgWOjf8rPOnyZDol/+yel3i/qe/jyVWfSm/id4uNuAV7
0wYqp4V039wILDXTwpMtPo0t8t3OTbX7m3e4oH5XfBb/mBnU3b34rqj1FDfz
/NZrw3x5oCTzxZiOTepZ4hx6Jv4PfW6i1w==
                "]], -10]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0klsTWEYxvGvpo26rZpCUlJjmzZNOiW6stAYwqYlQSMi2CA60BBrFBHz
zIbQ3t6IGBLUECpmooZom6LVGiJFI4iYNn5n8b/P9z7v8L3n3JOxpLKsIimE
MNxP9cAQzsZCeJQWwkM8QOmgEBbxTshVYdWQECrwWq4DnVjDr+QtTw7hjbgL
f8R/8RvzzOjLWyFfJa7GmMEhjEY//rihIYzHWEzEBJTr6S+3gCaJ4+5Yjxze
Ht59upcWyDXSfHqJbrPrJ3UFqSEUIl/cqDaPXqZfU0LYioNyB7Afd/Utk7+i
77CdjuAQDmKl/Al7n7dzEz1Hb9DjcidpgziB3eIGO+yiCdpmVrdzK41Hz2Z+
jlnZKNFXgYTcHHEZUtXOpG1ojWL5B/bcrHcLajHSjK20Tq7TuYVej/aKdsIt
8SAaQwqeoBld7pmu75nnnEaf03qz6zDJO8mM3qn76/WvdvdZ5zv63ovT6WjM
1fdSX6ZzFn7obRfv4xfZZS8tpGfctQGtatrQgm/mfKbF6r+YPZlecs9FXMBV
3hUU2uOFuePVd/O7UMWrjP5rs/dhkt6XajPpK/pH7W16D3fRi6lm3LTDOv1r
EVdbZEY9bZGbZpeP/O/iGv4xM3boi/N30k9yPcjkv3ZnFu0Vf0aunq7oG+Ef
xSzxW/FsGszKohvdsQnLsBSrUBx9c3YqpQv19VE313mx2c36T/M6zB/AK8d8
1PLyeE/VpImTkRC32/MU/cHfruYnnSL3Jnpv9B1GRd+OmhG0JroTj92fTav1
9KjtoR9wnrfFPinRTP/jNfEj55ia2LAQMpCGJt5w+k/+F36rnS1O1zuDzkMJ
uvm5tBitzv8BbxinFQ==
                "]], -30]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0ttPz3Ecx/EP5sIoSmXGTDnOYWNDXRmKRiGHHObGZA4XIrowpxvHP8Ah
LtiM2CqhUEJs1QxDOeTYbIxsKjJl5vT4Xjx7vd/vz+v9/rw/v77JazYvzu8R
QhjpT+aAEC7EhpDXL4Si/iGspeXynJgQLtN18hPq62mFPFf9gLxSfAU75Ndo
U0IIV+lBZ1W0GlmowXUcUp/jru19QzjJu0httjwDK8yojw9hoVodzaENNIbu
4Y2lH+WfkCteiqPqaXTKwBCmYlqkZg2zZ5o4FUU8x9BTXIJSJCIBrfZot9Nn
OkiehJm8M7DQjCd2KhN/d17P14BE9/22wx/8RXf0bt4avTdxA7fkfWk/vNX7
nr6hWWZlYx4WYD4Ou2MMPUL/mRd4f0a/qxn71QeJ99Ikuo/etcMPs1L4kpET
7Yrleivkd/RdoZW46Le4hC7+Tn1j1EZjFJrdt0TfTnN34Yu+y3EhtEX/YzqR
p784Tn88UnmO8E+jZebtRiNPEx7jKZ4gLrpffwetpO10g571KJc3y4vNqxKX
mtdmTrV4BAYiAcej74Evz5ve2LNKXo3H3nBKPkn9NC1U2yQ+Y06tOfniWTzb
5IXYKv/G16TWiNn2y4jeHt0XfW80hZ7jO4+zGGLPYvqcvxlfnRfIt5pXgHh7
dUS70slmtYtf2uOv/F70Jv4v8jKaqm88fW3OBLqR9uJJ510nDuJ/vLfdOdf5
anrJO7LVsrA48qivUu9BS+kr9RKaZEaLuDfPSjySl9KHNIm+ir5Bep7nRfT9
oQ6/zU9Wn44Wng+0wuzB9ADvA+d9EkO4T8eqjcMW97XyttIP0Y5qB/XE8nf6
TWrk98QxPDF6hyMOtWqJ9JfzLnTzZsmH6s2ky5COd+oTaRqeif8DD8yruA==

                "]], -50]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0ldsz2EUxvHXSppozTYRRVs1YiRiJELNmjGKinlhNHZVjRsjRiLmtVU1
U25KawaRELsUUVVCjBKJVXslFPH5XXz7vOd5n3Pe8/unKVm5mQtqhBC6+TO5
cQgxDUO4Fh/C77gQltMM3ihsrx9CU/VSflKjEJbRZFqnXghb6AZsRHWDEEbL
94wNIU9Pop5mSHGXipbYik3YjD/yY+TT5PPld2E3apg7kz8Ls7GGN1RmD38v
RmA3evM+u+9Dx9JMfMB7DOdd8D0Xcdc75biHFna/yyvDM7nnqMRTVLi/j3l2
zkYXXlc0N+uKHdrbuQPK9SaZUyk7S50juwBpsr2QLL9XPon2VPfAG/n5Mud4
ubRK3TvaHX0Rb1Y67Y9+0Te4z/ONifIL5T+qs731KZpDV9F59AOdTediDv7p
KdV/EzdwG7cw1pzs6DeiZeYd8w3X1SW4XzeEAbyBSMcdMwfR1TSFrqFvzH6L
d1ghP8E7FfzD9k41oxW++OYj6mIUIVPvGEzUU+T+CIpxwF0BqswJet7TpvyD
vEP2KsQ4e07R99Abx/kncBKl8jeRx89RL8QiPLfPRTMe6DusvxhFKFHvcL8T
+TjNO4UX3pxm/nRMxWPzsugeesf8fXSX3H7aiX/GnK60QP3SnC7OnbEErd29
8nZrd4/0tIlmmTEdbaI7+cHO1c4JztvsmibTTT2M/5cupkui/3MMwVX7zaEr
5VdgpPMhPaNpBtL11PTWJbO+e3ulei1/qjrObz5TtoA/g47n16Jf5b/hiXlf
aLyeQvkEWlumEDEojt7C7WjfqBePnCcl6KWPzb2Majsmu2uJ4+Y3oevM3oQY
2VL3bXntkOud13pf05c4yluvJy7axb5n1TecY2Vi9SahAc7z4ukv9z/wU3aY
OlHvYDoO6ajkd6TdUeH8HzP1sbE=
                "]], -70]}, {
              RGBColor[0.6, 0.4, 0.2], 
              Tooltip[
               Line[CompressedData["
1:eJwV0l1oz1Ecx/GzUcqGzYh52iZXhGwliSR78FRDNsxmtnlOcyUXhohS7ihk
HraRuECYC0weIkSooaGG2X/igpVhmw2v38V77/M93+/5nOPnn1G+ZUllXAgh
y58lA0M4NiSEaqxMCaEYuYkhjEwKIY9XqUvQMyCEKjMHB4fwKzmEHHUHZ/NP
zufj+nPklZpfjTKMkrOGK1COXnM7zB2S0+1crvo3d6ETcfazZTwxk8N/9QM/
VP+znuFNz63/mn0W7fEf9KIH8c7nmn+ql8fx6ItH6j48y/ndg0LYgzx537zp
O1qc+4izCSFsRan51ViFcpTho/k1vBYVaFEPl1cUfTusQAmKsV1vNI/BJ7mt
iGGb7PX2WvXXcYw3RDO8Vv9zdAe38Ub7qfKPePd79RX1CPVJb69S31bv4EL9
L1yvztBP8c3H8jX1V/tH9T/wVfUo+zXOp1mnY5N/+2J7G3kRz7U3D2nqdHR4
70Pztd5UhxqcwWnUm7/BWfJPubMGtWg3n+rscNSpX0RvNLc0utvsK/UDd7zm
w9E3tFenbnBXl3VjlKt+yfeQJC8ZO6PvYGaadTMXyVyJFShBMY7Im8hHebO7
K7EF3c7+QbX9O7KPcZyc33Iuqtvds0u/wLoQ4719Ajr1n5mbJLPa7+sEDsh7
za36sei3o25FDFPkNullcgYaou/M49DtjpvqHs7CPLmZPF0vxzob9923IPr/
lbWQ3+IN/pnL5zjZd71zvjM/3F1lv5Z38kDZddaJnIAC88sw0+w7eTO43flh
ZlPV5/TOox/26V3gp3pDOB5N1suHOstv5d5Dt/el6V02X6RXz/15v7x+/Fh/
r/VkMzHnKr21jdu4BZfsX0W7913nR2YT9BOcHYNBuGUvhTv1O/Az+k2qR0Tf
iZdiNprtT+CpaLT+D13wtZw=
                "]], -90]}, {}, {}}}], {
          AspectRatio -> 1, Frame -> True, FrameLabel -> {
             Row[{
               
               HoldForm[(Style["d", Italic] $CellContext`\[Alpha])/(
                Style["d", Italic] $CellContext`t)], "\[Degree]/sec"}], 
             Row[{
               
               HoldForm[(Style["d", Italic] $CellContext`\[Theta])/(
                Style["d", Italic] $CellContext`t)], "\[Degree]/sec"}]}, 
           PlotRange -> {{0, 20}, {-10, 10}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {Automatic, Automatic}, RotateLabel -> 
           False}]}; Typeset`initDone$$ = True); ReleaseHold[
       HoldComplete[{$CellContext`framelabel = {
            Row[{
              HoldForm[
              Style["d", Italic] $CellContext`\[Alpha]/(
               Style["d", Italic] $CellContext`t)], "\[Degree]/sec"}], 
            Row[{
              HoldForm[
              Style["d", Italic] $CellContext`\[Theta]/(
               Style["d", Italic] $CellContext`t)], "\[Degree]/sec"}]}; Null, {
          
          HoldComplete[$CellContext`depthPlain = 
            ContourPlot[$CellContext`i ($CellContext`mm/$CellContext`pp) (
               180/(($CellContext`pp - $CellContext`mm) 
               Pi)), {$CellContext`pp, 0, 20}, {$CellContext`mm, -10, 
               0.99 $CellContext`pp}, FrameLabel -> $CellContext`framelabel, 
              RotateLabel -> False, ContourShading -> False, 
              PlotRange -> {{0, 20}, {-10, 10}}, ContourStyle -> {Brown}, 
              Contours -> {-10, -30, -50, -70, -90, 10, 30, 50, 70, 90, 110}]; 
           Null], 
          HoldComplete[Null], 
          HoldComplete[$CellContext`depth = Show[{$CellContext`depthPlain, 
               Graphics[{Brown, {
                  Line[{{0, 0}, {10, 10}}], 
                  Line[{{0, 0}, {20, 0}}]}}], 
               Graphics[{Brown, 
                 Dashing[0.01], {
                  Circle[{0, 0}, {18, 8}, {(-Pi)/2.2, Pi/3}], 
                  Text["-f\[ShortLeftArrow]d", {1.4, -8}], 
                  Text["d=0", {17, 1}], 
                  Text["\[Infinity]\[ShortLeftArrow]d", {8, 7}], 
                  Text["d=10", {15, 4}], 
                  Text["d=30", {12, 6}], 
                  Text["d=-30", {7, -7}], 
                  Text["d=-10", {13, -6}], 
                  Text["d\[UpperRightArrow]", {16, -3}]}}]}]; Null], 
          HoldComplete[Null], 
          
          HoldComplete[$CellContext`framePlain = 
            ContourPlot[
             180 ($CellContext`i/(Pi $CellContext`pp)), {$CellContext`pp, 
               0.01, 20}, {$CellContext`mm, -10, 10}, 
              FrameLabel -> $CellContext`framelabel, RotateLabel -> False, 
              ContourShading -> False, ContourStyle -> Blue, 
              Contours -> {20, 40, 60, 80, 100, 120, 140, 160}]; Null], 
          HoldComplete[Null], 
          HoldComplete[$CellContext`frame = Show[{$CellContext`framePlain, 
               Graphics[{Black, 
                 AbsoluteThickness[1], {
                  Line[{{0, 0}, {20, 0}}]}}], 
               Graphics[{Blue, 
                 Dashing[0.01], {
                  Line[{{2, 5}, {20, 5}}]}}], 
               Graphics[{Blue, {
                  Text["f=20", {180 (($CellContext`i/20)/Pi), 9}], 
                  Text["f=40", {180 (($CellContext`i/40)/Pi), 9}], 
                  Text["f=60", {180 (($CellContext`i/60)/Pi), 9}], 
                  Text["\[Infinity]\[ShortLeftArrow]f", {1, 9}], 
                  Text["\[ShortLeftArrow]f", {12, 6}]}}]}]; Null]}}]]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->322716303],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration shows the retinal motion and pursuit rates for your \
choice of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " in the case of a fixate and distractor on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis and an observer moving at 6.5 cm/sec (interocular distance per \
second) to the right on the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis.  The observer's eyes are \"fixed\" on the point ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " (the \"fixate\" point). \"Fixation\" means the ray from ",
 Cell[BoxData[
  FormBox[
   StyleBox[Cell[TextData[Cell[BoxData[
     FormBox["F", TraditionalForm]], "InlineMath"]], "InlineMath"],
    FontSlant->"Plain"], TraditionalForm]], "InlineMath"],
 " through the eye node strikes the fovea at the center of the retina (see: \
",
 ButtonBox["Fixation and Distraction (Visual Depth Perception 5)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"], None}],
 ")."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration is for the case of a fixate and distractor on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis and an observer moving at speed 6.5 cm/sec (interocular distance per \
second) to the right on the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis.  Additional details of this framework are given in the Demonstration \
\"",
 ButtonBox["Motion/Pursuit Law in 1D (Visual Depth Perception 1)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawIn1DVisualDepthPerception1/"], None}],
 "\". This Demonstration shows a different graphical representation of the \
dynamic quantities."
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{
     {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.025], 
      LineBox[{{2.6, -1.9500000000000002`}, {4.875, -1.9500000000000002`}, {
       4.55, -2.08}}], 
      CircleBox[{3.25, 0}, 1.3, {2.467219080199778, 7.950404387379365}]}, 
     {GrayLevel[0.5], 
      CircleBox[{2.754665525517617, 0.914463645198245}, 0.65, {
       0.5672190801997781, 3.567219080199778}]}, 
     {RGBColor[0, 1, 0], 
      DiskBox[{2.940415953448511, 0.5715397782489031}, 0.13]}}, 
    {GrayLevel[0], LineBox[{{9.75, 0}, {0, 0}}]}, 
    {RGBColor[1, 0, 1], 
     InsetBox["\<\"\[Theta][t]\"\>", {2.364082248717103, 4.393490324618912}], 
     CircleBox[{2.940415953448511, 0.5715397782489031}, 3.9000000000000004`, {
      1.8731034751892794`, 2.067219080199778}]}, 
    {RGBColor[1, 0.5, 0], 
     CircleBox[{2.940415953448511, 0.5715397782489031}, 2.6, 
      NCache[{Rational[1, 2] Pi, 2.067219080199778}, {1.5707963267948966`, 
       2.067219080199778}]], 
     LineBox[{{2.940415953448511, 0.5715397782489031}, {2.940415953448511, 
      4.4715397782489035`}}], 
     InsetBox["\<\"\[Alpha][t]\"\>", \
{3.540415953448511, 3.2715397782489033`}]}, 
    {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 6}], 
     InsetBox["\<\"F\"\>", {0.5, 6.}], LineBox[{{0, 0}, {0, 6}}], 
     InsetBox["\<\"f\"\>", {-0.4, 3}], 
     LineBox[{{2.940415953448511, 0.5715397782489031}, {0, 6}}]}, 
    {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 10}], 
     InsetBox["\<\"D\"\>", {0.5, 10.}], 
     LineBox[{{2.940415953448511, 0.5715397782489031}, {0, 10}}], 
     LineBox[{{0, 6}, {0, 10}}], 
     InsetBox["\<\"d\"\>", 
      NCache[{-0.4, Rational[22, 3]}, {-0.4, 7.333333333333333}]]}, 
    {GrayLevel[0.5], InsetBox["\<\"Translation\"\>", {1, -2}]}},
   AspectRatio->Automatic,
   ImageSize->{Automatic, 225.},
   PlotRange->{{-2, 6}, {-4, 11}}], TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "If you know ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", pursuit at speed ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is given by the formula"
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}], 
    RowBox[{"d", "\[InvisibleSpace]", "t"}]], " ", "=", 
   FractionBox["i", 
    RowBox[{"f", "+", 
     RowBox[{"n", " ", "r"}]}]]}], TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". Once you know ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", time zero motion is given by the formula"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[InvisibleSpace]", "t"}]], "=", 
    FractionBox[
     RowBox[{"d", " ", "i"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", "f"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"n", " ", "r"}]}], ")"}]}]]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "All the points on the red line have the same M/P ratio and same relative \
depth. The brown curves have the same ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "=", 
     RowBox[{"\[PlusMinus]", "10"}]}], ",", 
    RowBox[{"\[PlusMinus]", "30"}], ",", "\[CenterEllipsis]"}], 
   TraditionalForm]], "InlineMath"],
 " and the vertical blue lines have the same ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "=", " ", "20"}], ",", " ", "40", ",", " ", "60", ",", " ", 
    "\[CenterEllipsis]"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxtnAuYjtXax8cwjOMYM8Yw50PJIaWi6N3NIykidC4RJYdqoyRSOSSRJDWO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         
         "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0L8rxGEAx/GHjkGXDJIBnZOSJH2d69IlpSQTl0ESZWDiyGGw3W63222G
G6RklRHnVwYLDn+C1zO8+nyf9/f51nX9G+XSTlMIYYuJVAiHLSEcsU+5NYRE
a3DBvfMjD7yTZYADd/dszp0fatSdn3mig6o7M3qwzaQY1U/svN5m07Qzpp/a
Rb3TdtFNop/ZZb3PZsiS08/tuj5khxkhr9fspp7Ee7FR0G/stl60U0wzqd/Z
ij5r5+Jvo6jX7bG+YEssxe/0D1vVV+wqawzq3zT4JO/9L5d8OV/ZW3o891Lx
za4d1/645sX5jdf4nzv/AxpZMQY=
               "]],
              "160"],
             Annotation[#, 160, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVz7kvw3Ecx+GvOBKDq6UaV0pEQ10dTAYiMZgkTAYLYRE1+AeYmZmZmSQq
JCLue2YTR5gkwmLi+Q1PXu9+2ubXNk8tjOUKQgiLpItCyBWHMM8cJ17HSkI4
0nq90KSea50OMetzM0xz6F7ldqBteqtPeqOfOkir/aHvvDHpexO88kKL97OM
26M88kDKrZcRe5h77mhy62HA7o9+M8c0uHXTZ2fZI0+dWxcZO802WyTdOmm2
G9lkg0T0WWrtOOusUe3WQZldyiorxNzaKbT/dFmf/c+l6D9qZfQczfBr71Nh
56Nn65U26aWmNM2P/c0Xu5S77WhCzzSup9Fv1Bqu7X8njzWC
               "]],
              "140"],
             Annotation[#, 140, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0L0vg1EUwOHTaIkwMpgaicVsNptZLSJG4Y8gbISN1EbYCAbxlRhIbYSJ
alHeapksQiM87/Dkd3POcHNv7/j0yFQmIsbozEbc0dUaca/7PPBJiQZl8vYV
PeCJHx6pm3/lImaoOs9qhnnm+GaBRTpYZokmK6zSzRoFfllngzxbbPLHNjv0
s8duepc7D/WIAU45ocX8XC8Y5JIiOfMrvWaIW25oS9+vJYapUKbdPNEaozRI
zOrpe/TZH/RpVY95ZcLuRd9J6LGv6Vn6X0zav+kH/2U4QO4=
               "]],
              "120"],
             Annotation[#, 120, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzyFIg1EUQOErOLUNbaJFhmKRKUOGioyhbbgwGLqk/mXMsKEgGNaGYUmL
aX3dbrfb7SbDQByI4vfC4VxOePe+tazX6M5ERBNPsxF3uYgyf+EbU2zORfT1
Q/MPfvGHLf1ePzbneB4LKOqPXNPzvIgl7OgjbujLvIJVlPQxt/QCr2MDu/oz
X6Rd6V1sp/v0F27rZd7DfrL+yl29ykfpNhzob3yr1/gE9fQf/Z37epNPcYaK
/sED/ZwvkaGqf/JQb3MHV2mPPuEHvcfXuEm79X8ZrSUk
               "]],
              "100"],
             Annotation[#, 100, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzkEoAwAYhuF/NTs7u61cXJy5UCtOczEc7MJO22XbaaK2E8VciJTE0pJG
0srOnDlz5jxFTU4Onh3enr7bly5UFsuJiFhWNxnxMxJxyCoPOOA9v7nPIpv8
4h0/ucM1brPPW36wwRXW+c4O37jBLGt85TVfWGWGFT7zik8scYpFPrLNHguc
5DofeMkb5jnOVXbYYotLHGOOFzznMRc4yiyPeMY9zjPFOe7ylA3O8k8zqtsn
3OI0f4dftWlPpCL+ASh2MLM=
               "]],
              "80"],
             Annotation[#, 80, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzbFKAlAYhuFfUZHIi2jtEmqxqaaCwKZcqilBSRqKBqOhKAqkECFCRCqk
RKKgoa2tob293aGhCJHocTg8fC8/nKm1ynI5EREFL5eKmM5EzLDKWe6lI5r8
YZ7b+hxr9iV/OT++0xd4Yl9xyEUe6Ets2C2OWOCxvsK23eYfV1nXi7y3Owx7
nU1u8Fm/ZtLeZIslvuq3TNlbvGGV73qXGXuHPe7yQ79j1q7xifv81HucsA/5
wiMO9D4n7dPxfzzjl/7AnH3ON17wW3/kP+NFL94=
               "]],
              "60"],
             Annotation[#, 60, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzjtLwlEcx+ETRGMQIREiIaL4IpoEM7XyUpqXrqbds0FcokVapCEQGtza
2tra2tp6Vz3/4cPDd/gdTrL3WB8uhBAayi6GMFwK4UH3erf/mOEdb3WjN/uX
aV7zSpea2j9MccC+LjSxv5lkj+c605P9xQ2e8kTHGtmfTPCIXXWiP9kfjLPN
lg41sOdcZ5MNHUTv2TOucZ911aIb+5UxVlnRnqr2C1e5yx2VVbSfucJStLWt
nD3mMgvcUl6b9ohz/gNt/yLU
               "]],
              "40"],
             Annotation[#, 40, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0EdKA0AUgOEJBLc5g1fKzq0H0F0sEAtoIsQCagQb2MAGlkAsYINEA5pi
EtstLCfwm8XHz/Bm4DG9/YPpgUQIoY9UMoQW3z0hvGqTDj/ObX3WIYbJMMoI
L4wxTpZJJqgzTY4pZsjTYJY5CiwwT5MllllkhSIt1lhnlU024o5ss8MWe+zG
XTngkH2OOaLDKWecUOKcLhdcUuaaK9645Y4bHrjnnSqPVKjxxEd8459+4x3t
8slfnOkX/2uvQKM=
               "]],
              "20"],
             Annotation[#, 20, "Tooltip"]& ]}, {}, {}}}], 
        {GrayLevel[0], AbsoluteThickness[1], LineBox[{{0, 0}, {20, 0}}]}, 
        {RGBColor[0, 0, 1], Dashing[0.01], LineBox[{{2, 5}, {20, 5}}]}, 
        {RGBColor[0, 0, 1], 
         InsetBox["\<\"f=20\"\>", {18.621128341751756`, 9}], 
         InsetBox["\<\"f=40\"\>", {9.310564170875878, 9}], 
         InsetBox["\<\"f=60\"\>", {6.207042780583919, 9}], 
         InsetBox["\<\"\[Infinity]\[ShortLeftArrow]f\"\>", {1, 9}], 
         InsetBox["\<\"\[ShortLeftArrow]f\"\>", {12, 6}]}},
       AspectRatio->1,
       Frame->True,
       FrameLabel->{
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Alpha]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Theta]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm]},
       PlotRange->{{0.01, 20}, {-10, 10}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]},
       RotateLabel->False], {192., -189.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxcfQd0VUXXdjrppPeENHovgiByRgQERECaIEiRLlJEQJp0EJWqiDTpTem9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         
         "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0T1IlXEUx/FjQURWdu/VStBBSCjnVCSkxNmGRDAEwYjs7ZaYb4OYhpOD
ZolkCi4lRFOITmJKwxXB3jCdmnMJDUJMh/zc4cf3nO85///z8Dwltx7feJQT
Ea+k+1REYX7EeTlIRkyfjJhJRXTx57izss9P8W/5Tr6Ay5d//AT/hu/gU1xS
9vhxPqF+wj9LRGxyfTjG3z4T8RJ79Rt8D77Qt/Cj2KX/wbfjc30zP4Jt+nV+
/XTEsH40LyLt/u/6bzKVG/HQzh87aWxy7gHel0mzu7htdg8bzVrxjrw2++J8
A/cVB935GavtruGEeY16jr+pn8dfnt3sHf7q38mQsxk7s9yuvt1OBXdFPW53
V31JivTv7RXjU32/rLh/gcvgR1ySRbluZxnrsNbemjvn9b/dt6ru930T2Xsw
Dwey/wUv2E3hVanyPqX2K7HWmVzp4dNymf/A76hH+OPZ74+f+LKCiKNmF/EE
ZsyK1duecUT9H+v1xyTpTAsW4hZfrr4mP9WHdIZWcQ==
               "]],
              "110"],
             Annotation[#, 110, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0EtIlVEUhuGlaJKW98CBkyiwJikoEqTnxJlrIEIXEERBCkIJFSkRzQuC
hQQmSpE6EKGoCMthE41AdCaEXabVKA3Fqfj8g5d3rfXtvc86//mOnpburIhY
xs/SiKclEQtnIib5FU/xD/PdwoiX+pmiiBf8Tf/dfEI+r79bHDHH4/pd8zGe
1XeZP1aPYKkgYoiP5MPcKRvkR1iUDfCh7CG3y/q5L9lH9oAPZL3cJuvh7mRH
2Y5dZrjJvFN9/2zEFm+iyJ012X8uxB1nUu41oED/SbbH+bgpqzevQ57+o+wf
t5ov8kLyv7yd5utowA0041p5xKrz08job/ntP77Vb7T5Dof6I6xgVX/Azd4d
dnYEs849xxXZJfPXZm/wDm/xxPtTeK8+Zb/bZRE5nPHOZ7N73Cj/ghQ2zNK8
Zd+M97Z5zawm+X2u5gmMolpenNTOX1CXqlO4apeLdqrnjPv5GEi+L2rNP5jv
q6fN89x7xuvml89FZMuq+DR/lVWq97yfpT7mFn0uStxp5wr+a16nTuOX+gRa
gVri
               "]],
              "90"],
             Annotation[#, 90, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0T9I1WEUxvEjlJZd6/ovTZcsuJs3TYSGFBwcoiCUEkzh2oVQE7Qpm8pr
FkUI5mT/hFJBXKolXZVaQsIlIpxaIoyEIFKQoM8dvjznPM97zvvy+9VlRzqH
CyJiEa8ORTwqjZjEfTzEA7zkfzkc8RU3SiI+0xE6fSRiXV1bFrHizA6tQX8y
os9cBsf0y7K/tBrXZD38K6jSv5P9oUeRlXXxL6NCX4lylCEju5eIuCgbdncp
L4le/gT/HH+In/Weq5jytrv8j+rr/BJnE+h2fpzf4vwg/yDvALr4OX4zf4D/
nPcCT/AMTzGf35mfR6u+sSKiAfU4hVWkUVwe8d69Y/ZtmblDF/W99Btdogt0
1l3z9DdmfIdRs7dw2+5db8jRHmfn5Oft3HHvTzNbuCD7YXe7vEi/H495U9gz
e9aeS+o1fNLPmn2T/xd4i7SdE8ghLWvACRxHCmfQIptGG1LuOolm97Xlvxtu
8odwmv+av62e5BeaTWCVv0FXaIE8Velb0w+8WvUvbwz1P9qh34ek+Qytot/5
TepWbKr/A6ReVqQ=
               "]],
              "70"],
             Annotation[#, 70, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0c1LlGEUhvEjIQZ+lZaLKEVIN61so46ok5aGZoxjUUaKWW5a+LGINhGU
kKXTTJZam4hqERGYUBC1EtJq19euVVASQf0HQf5mcXGdcz/vOe/zztSOTqTH
CyLiGaZKI3ZXRFRjD26WRJzbHpHhMf4qO8tz+jM8y6P8RT7MN/Sn+ToP8Wf5
IM/oT/A1Psmf5EvFEQPqY0ghjX4syvv4KHpwBL1YkHfzYRxEFw7htryDO9GO
A0hiXp7gFjSiGU24JX9fFvEB9XiHdeTkLe713G9wj1f4e3nEFX7MBZXqbRHL
+oTzEjN3Oessh3V5Sp9GP946f5Lfb+9lc82yJjz1Gzxwjze8YudrrpPXYy+u
2vPI3Cn5b3sH+aF+Sj2JBbvuIIs1z/aZWeUs53Ax/78hgzkM5L9lR8Rxvm/m
BVd67y/3eqn+ydP270Ot8xrUoREJzMuTaFP/cJdL7pD0vmpu5xHeyhc8cx4N
+mXP/VVn5IXmirEq/8ivOPLfvDOiiNdku9R/3PG/s3+c0m9BuflhruIN+X51
K76pNwELgVkg
               "]],
              "50"],
             Annotation[#, 50, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0T1IlWEUwPEniTItNetCDQ1BeP26pgWFYS0OZQ1BSy0RNDbUoqbeoiW1
tKv33j4tK2sqQaylIRHJuxiB1aZRBiItOqj0QQTV7x3+/M85zznPeR/enWcv
nDi/JoQwhVRhCENbQkhuDOERd/BjvqH+kNvlD7iNB7lX/T5flN/jVh7gHvW7
3CK/xXdwG9fVs3wT/cggjWvqKe6LZqN90d3oVt+zOYS92I061KJLPcE1qEQ1
qtCpXs4VKEOz/XHeV6pnawjDm7yhxLuQ0ztTHMIkt8njRfbyOnvXIyGeddZk
9igOY8L8EX5i7imey6vc+4w/cqOzA1yPF2bfy6ejeXcVur9PvR8pVMgznEUa
lfJFdy7hCz4jbm6Ov2LOjpP6TqHTnVfRLn7rfZ/sGhZPiVNmVrCMhPdf0vfT
bJJ/8WWe5GOc47S+DLI4Z88Gb8+P/o+83DeN6nujr4N/cKs937mFq/X9tvul
+LX+UR7jQWzzLaXOY/wO3/T1uC+BYnsKsKI27myV682knR3kBsz79qSeK9iB
Q9G/4zP4oL+Gm/Xv51qM6F+S9+pba74AE+rT/Ir/mdkV83/15dS2ixd9719n
f/i4PA9F5k9zjBfU68QNmBX/B+4Bcgk=
               "]],
              "30"],
             Annotation[#, 30, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0UtszFEUx/FbNZi+W/UWSZWEqMSqFpXQeKSdYCEem1JGohtRlNFWH1RJ
ULFgWUlFUDR2NkxH0pVHJ7azkRDEo+JRLDTa+Mzim+89v3vOuf9OK+LNO47k
hBDeYG9hCEP5IUTKQ/haFsKp2SEkMF39QJ7LY/KTshOYpr4v78CAc4P5VFEI
w+iR9eo5j7M4h57sWd7NZ9CBLnRma3k7n0YrjheE0Mbd8qWlIRxTV/BRnuEb
9ntrljcbOea9tHM9Lynxvplb6oXqZajEQ9lNWbP5PSi1azeX8XVcQ6+elXr6
7VzBNzhdHMIoUu5a7E7KcrO/CSJYbnef3oz7Tuc65NtVgJj9683Uc1Sdh0n1
FGpl4+Y38C7eiTq7f/KgLM/Og+oox/mKbzjAW/ztKd7Ew7yZn3rzsbkX5ga9
8ZLv8UbZXX6uvs3P+A7PNFdibxMX8yG+bP82/Vsx4fv+yi7YnXGetD9pdq7z
Ex6w45+sWs9H57U87u4XfuO1u5g99fij/qznE/rl7/kDvsm/o8q+Jm+v4hpe
hzbvtiKBpJ5F+g/bFdezwLmR0zwPEW+PZnf6/S/aX4UiO6L4IUu6S+GqvFbW
xzV2vrWjXd2FxWhFAvvwytxqbtE7pq/aeYjH1Jey/3/zUaTkaX7EU2Yq5/ge
fSOy+c5f/LaT7iZ4uzoHheYbuJzfydc41yDj/B+1pXsl
               "]],
              "10"],
             Annotation[#, 10, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV02loD3Acx/Gf0ubYZjNXc1/JwlxzLGoe2QNzbBpZFEWOoTYjRKIMyTPK
Awkb4pHSDnPfkyNXCnNMYXtAOcZyvn4PPnt/j8/3+/v9f///Bi5ZW7CmXQgh
w5+81BDOpISwNCmEwuQQLnYLoQArO4dQSofkc+XL9VvTQ/hB36lIrUp/HfVJ
C6EvzbJrNv3V/0e/6A/9pmDPet5CZ03jyaWH8o3yVXZ3MZ+PyTgDU/AoJuon
UF/+R/z9xCXqpXauxjIcwLscZ8prnLOCdyX15z0uf2IuU/4YN6nNEXfEBr0O
uKdLCC/0Tstv+VxL1ZbROfFVtXqso4Fqd+QD8GTcRYflneTF+g10TX4b6/Wq
3adOXoOZlK9+QT4TR9MHd87Cj/G97HhNW83d6xrCXUrkTaBFPBNxEo2nCZRN
5/lrzNZSNd2M5+FgrPQmN/AoXsdj+APf6v/EJhyNGd4iC6vtm2Jfq/ga71U6
xXNCXqt3gu+Tu/VW60OplEbv1G5iE24z3+iuo+LnivvjvLcd7rPst+8Alcfv
AavsvGzmifhpzM1lqlXiYzPzzc6jzWpFWEE7qcx9duFuGmpuSNxr/14zY/Ta
7P9JO9S2x3PdqRy/xndWn24uj3qKe1GOfr3+ZDzorDp3arRzJP9LfE2v6Ijd
q5xREn8rvM9prXiYerN9LfEt+LLNvcdMXKM/Pv6ecBzm4Bf+hWYzeBZgodpi
tQfyBJ4e2B53xd+UXgWOjf8rPOnyZDol/+yel3i/qe/jyVWfSm/id4uNuAV7
0wYqp4V039wILDXTwpMtPo0t8t3OTbX7m3e4oH5XfBb/mBnU3b34rqj1FDfz
/NZrw3x5oCTzxZiOTepZ4hx6Jv4PfW6i1w==
               "]],
              RowBox[{"-", "10"}]],
             Annotation[#, -10, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0klsTWEYxvGvpo26rZpCUlJjmzZNOiW6stAYwqYlQSMi2CA60BBrFBHz
zIbQ3t6IGBLUECpmooZom6LVGiJFI4iYNn5n8b/P9z7v8L3n3JOxpLKsIimE
MNxP9cAQzsZCeJQWwkM8QOmgEBbxTshVYdWQECrwWq4DnVjDr+QtTw7hjbgL
f8R/8RvzzOjLWyFfJa7GmMEhjEY//rihIYzHWEzEBJTr6S+3gCaJ4+5Yjxze
Ht59upcWyDXSfHqJbrPrJ3UFqSEUIl/cqDaPXqZfU0LYioNyB7Afd/Utk7+i
77CdjuAQDmKl/Al7n7dzEz1Hb9DjcidpgziB3eIGO+yiCdpmVrdzK41Hz2Z+
jlnZKNFXgYTcHHEZUtXOpG1ojWL5B/bcrHcLajHSjK20Tq7TuYVej/aKdsIt
8SAaQwqeoBld7pmu75nnnEaf03qz6zDJO8mM3qn76/WvdvdZ5zv63ovT6WjM
1fdSX6ZzFn7obRfv4xfZZS8tpGfctQGtatrQgm/mfKbF6r+YPZlecs9FXMBV
3hUU2uOFuePVd/O7UMWrjP5rs/dhkt6XajPpK/pH7W16D3fRi6lm3LTDOv1r
EVdbZEY9bZGbZpeP/O/iGv4xM3boi/N30k9yPcjkv3ZnFu0Vf0aunq7oG+Ef
xSzxW/FsGszKohvdsQnLsBSrUBx9c3YqpQv19VE313mx2c36T/M6zB/AK8d8
1PLyeE/VpImTkRC32/MU/cHfruYnnSL3Jnpv9B1GRd+OmhG0JroTj92fTav1
9KjtoR9wnrfFPinRTP/jNfEj55ia2LAQMpCGJt5w+k/+F36rnS1O1zuDzkMJ
uvm5tBitzv8BbxinFQ==
               "]],
              RowBox[{"-", "30"}]],
             Annotation[#, -30, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0ttPz3Ecx/EP5sIoSmXGTDnOYWNDXRmKRiGHHObGZA4XIrowpxvHP8Ah
LtiM2CqhUEJs1QxDOeTYbIxsKjJl5vT4Xjx7vd/vz+v9/rw/v77JazYvzu8R
QhjpT+aAEC7EhpDXL4Si/iGspeXynJgQLtN18hPq62mFPFf9gLxSfAU75Ndo
U0IIV+lBZ1W0GlmowXUcUp/jru19QzjJu0httjwDK8yojw9hoVodzaENNIbu
4Y2lH+WfkCteiqPqaXTKwBCmYlqkZg2zZ5o4FUU8x9BTXIJSJCIBrfZot9Nn
OkiehJm8M7DQjCd2KhN/d17P14BE9/22wx/8RXf0bt4avTdxA7fkfWk/vNX7
nr6hWWZlYx4WYD4Ou2MMPUL/mRd4f0a/qxn71QeJ99Ikuo/etcMPs1L4kpET
7Yrleivkd/RdoZW46Le4hC7+Tn1j1EZjFJrdt0TfTnN34Yu+y3EhtEX/YzqR
p784Tn88UnmO8E+jZebtRiNPEx7jKZ4gLrpffwetpO10g571KJc3y4vNqxKX
mtdmTrV4BAYiAcej74Evz5ve2LNKXo3H3nBKPkn9NC1U2yQ+Y06tOfniWTzb
5IXYKv/G16TWiNn2y4jeHt0XfW80hZ7jO4+zGGLPYvqcvxlfnRfIt5pXgHh7
dUS70slmtYtf2uOv/F70Jv4v8jKaqm88fW3OBLqR9uJJ510nDuJ/vLfdOdf5
anrJO7LVsrA48qivUu9BS+kr9RKaZEaLuDfPSjySl9KHNIm+ir5Bep7nRfT9
oQ6/zU9Wn44Wng+0wuzB9ADvA+d9EkO4T8eqjcMW97XyttIP0Y5qB/XE8nf6
TWrk98QxPDF6hyMOtWqJ9JfzLnTzZsmH6s2ky5COd+oTaRqeif8DD8yruA==

               "]],
              RowBox[{"-", "50"}]],
             Annotation[#, -50, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0ldsz2EUxvHXSppozTYRRVs1YiRiJELNmjGKinlhNHZVjRsjRiLmtVU1
U25KawaRELsUUVVCjBKJVXslFPH5XXz7vOd5n3Pe8/unKVm5mQtqhBC6+TO5
cQgxDUO4Fh/C77gQltMM3ihsrx9CU/VSflKjEJbRZFqnXghb6AZsRHWDEEbL
94wNIU9Pop5mSHGXipbYik3YjD/yY+TT5PPld2E3apg7kz8Ls7GGN1RmD38v
RmA3evM+u+9Dx9JMfMB7DOdd8D0Xcdc75biHFna/yyvDM7nnqMRTVLi/j3l2
zkYXXlc0N+uKHdrbuQPK9SaZUyk7S50juwBpsr2QLL9XPon2VPfAG/n5Mud4
ubRK3TvaHX0Rb1Y67Y9+0Te4z/ONifIL5T+qs731KZpDV9F59AOdTediDv7p
KdV/EzdwG7cw1pzs6DeiZeYd8w3X1SW4XzeEAbyBSMcdMwfR1TSFrqFvzH6L
d1ghP8E7FfzD9k41oxW++OYj6mIUIVPvGEzUU+T+CIpxwF0BqswJet7TpvyD
vEP2KsQ4e07R99Abx/kncBKl8jeRx89RL8QiPLfPRTMe6DusvxhFKFHvcL8T
+TjNO4UX3pxm/nRMxWPzsugeesf8fXSX3H7aiX/GnK60QP3SnC7OnbEErd29
8nZrd4/0tIlmmTEdbaI7+cHO1c4JztvsmibTTT2M/5cupkui/3MMwVX7zaEr
5VdgpPMhPaNpBtL11PTWJbO+e3ulei1/qjrObz5TtoA/g47n16Jf5b/hiXlf
aLyeQvkEWlumEDEojt7C7WjfqBePnCcl6KWPzb2Majsmu2uJ4+Y3oevM3oQY
2VL3bXntkOud13pf05c4yluvJy7axb5n1TecY2Vi9SahAc7z4ukv9z/wU3aY
OlHvYDoO6ajkd6TdUeH8HzP1sbE=
               "]],
              RowBox[{"-", "70"}]],
             Annotation[#, -70, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0l1oz1Ecx/GzUcqGzYh52iZXhGwliSR78FRDNsxmtnlOcyUXhohS7ihk
HraRuECYC0weIkSooaGG2X/igpVhmw2v38V77/M93+/5nOPnn1G+ZUllXAgh
y58lA0M4NiSEaqxMCaEYuYkhjEwKIY9XqUvQMyCEKjMHB4fwKzmEHHUHZ/NP
zufj+nPklZpfjTKMkrOGK1COXnM7zB2S0+1crvo3d6ETcfazZTwxk8N/9QM/
VP+znuFNz63/mn0W7fEf9KIH8c7nmn+ql8fx6ItH6j48y/ndg0LYgzx537zp
O1qc+4izCSFsRan51ViFcpTho/k1vBYVaFEPl1cUfTusQAmKsV1vNI/BJ7mt
iGGb7PX2WvXXcYw3RDO8Vv9zdAe38Ub7qfKPePd79RX1CPVJb69S31bv4EL9
L1yvztBP8c3H8jX1V/tH9T/wVfUo+zXOp1mnY5N/+2J7G3kRz7U3D2nqdHR4
70Pztd5UhxqcwWnUm7/BWfJPubMGtWg3n+rscNSpX0RvNLc0utvsK/UDd7zm
w9E3tFenbnBXl3VjlKt+yfeQJC8ZO6PvYGaadTMXyVyJFShBMY7Im8hHebO7
K7EF3c7+QbX9O7KPcZyc33Iuqtvds0u/wLoQ4719Ajr1n5mbJLPa7+sEDsh7
za36sei3o25FDFPkNullcgYaou/M49DtjpvqHs7CPLmZPF0vxzob9923IPr/
lbWQ3+IN/pnL5zjZd71zvjM/3F1lv5Z38kDZddaJnIAC88sw0+w7eTO43flh
ZlPV5/TOox/26V3gp3pDOB5N1suHOstv5d5Dt/el6V02X6RXz/15v7x+/Fh/
r/VkMzHnKr21jdu4BZfsX0W7913nR2YT9BOcHYNBuGUvhTv1O/Az+k2qR0Tf
iZdiNprtT+CpaLT+D13wtZw=
               "]],
              RowBox[{"-", "90"}]],
             Annotation[#, -90, "Tooltip"]& ]}, {}, {}}}], 
        {RGBColor[0.6, 0.4, 0.2], LineBox[{{0, 0}, {10, 10}}], 
         LineBox[{{0, 0}, {20, 0}}]}, 
        {RGBColor[0.6, 0.4, 0.2], Dashing[0.01], 
         CircleBox[{0, 0}, {18., 8.}, 
          NCache[{-1.427996660722633, Rational[1, 3] Pi}, {-1.427996660722633,
            1.0471975511965976`}]], 
         InsetBox["\<\"-f\[ShortLeftArrow]d\"\>", {1.4, -8}], 
         InsetBox["\<\"d=0\"\>", {17, 1}], 
         InsetBox["\<\"\[Infinity]\[ShortLeftArrow]d\"\>", {8, 7}], 
         InsetBox["\<\"d=10\"\>", {15, 4}], InsetBox["\<\"d=30\"\>", {12, 6}],
          InsetBox["\<\"d=-30\"\>", {7, -7}], 
         InsetBox["\<\"d=-10\"\>", {13, -6}], 
         InsetBox["\<\"d\[UpperRightArrow]\"\>", {16, -3}]}},
       AspectRatio->1,
       Frame->True,
       FrameLabel->{
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Alpha]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Theta]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm]},
       PlotRange->{{0, 20}, {-10, 10}},
       PlotRangeClipping->True,
       PlotRangePadding->{Automatic, Automatic},
       RotateLabel->False], {576., -189.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
   ImageMargins->0.,
   ImageSize->{479., Automatic},
   PlotRangePadding->{6, 5}], TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxcXQVcVUsTp7u7W0BEEFFsd+3u7u7CLmyfXc/OZ3d3e66N3WCBdHc3H8yc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         
         "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0ctLlAEUhvHjgHjLstFRo8SkbBHhRon8B9q5EQQJIjSYzIWJprYpaHaF
lotMxXbmMgjxAhVltrQWbSwrjKILRBpGUtmm37d4eM55z/nOfDNT13mhtScv
Iu5hBlW7IvahGk2FERmeK42o5I6SiAouR6PZXXla/UZ9xmyN9+qn5UPFEa/1
H/kV51IRi/Kz9lb1ZfauF0V85k/olBdzET6g3c4Rz16zM8A/sIlCe81mQ7sj
LqHCzUU7GZ7jcl7gNM9zyjN5GLQ7q38qX0a3Gxvy87ykf+DuhPqlepwPeIca
5OTr+v3qHW7gf5x2bzP5vrzBJ906xVn7X33OMH/h0+7VqfvMbtoZRZl+D77L
xuw8cuMWH3X7m+yy2RWcUx+TZbnSThUyyLdbzTfkK+7Xqw+j2e1VpMzneQd/
MWy2Lmuz+55H9Af5ENfyRXfe2evn+7Kfsi38wRP9b84lv5N6imd5kkvkLZ67
410fJ/9N8nurC/ih/hmWcdv+L1mvz9/mfl7hE/yCG/k5H+er7tYk74Ue370P
vUibZ7kLbXhrvob/GuZcpA==
               "]],
              "1"],
             Annotation[#, 1, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0s1LlGEUxuHTRi1nxlwFUSPjB7QxSAotody5aRVCtCgiCD8iByWK2jRW
oGAZLVIo3NQ/kAklQaDRotQWheFUWlC72oS2yOjrehY/7nPOfT9nnvedt3Cq
eKR/U0TMYDIb8a864lVVxDG6SD9mIj6hmIvox5XNES/pPF5glXdSdkH2Lx3i
r5h9wAn9H/zGsr5LprAloiRT1r/HO5w3a+Hl1DWoRhYZ7DGvpNPuVkWP2/XW
rEJ9z6xD/0X9GU32fMcS/xwd8TuNtAGVctP6QXWtcwP0G47KHuIdxFbzYZkc
rUEGU/osbZML+Qf6IdmruIavZj28krpTPa6+RW/T7e60Si/yVmiTPc+cH9Xf
QA6z6Y7mc7RAG1CPMTvanRml17GOtXRns2Z7N+hl53/S3ebNOGBeYc+4+Zj6
uT0X+DfTO6b1/q+d/Ev6PH3szCMM86Zol/xDWsYyWtGGXbJ9vDPoRi960Jie
w9nXMm9Qp89jm/wvbOCH+R2Zw/QubxJP1bO4z39C+8xm6Fx6b+44gaL9g+l/
wrxcK92PFuzDXpTs3SGbx1nPNJC+U9TKn6bd6ZtL3xm/jP9VAGNq
               "]],
              "0.8`"],
             Annotation[#, 0.8, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0jtIlmEYh/E7VPIYQi1BQwW6VGAuEVQQZkNSWkIGNUjlIJhlDX2VeQhK
LILwgEMt1tASRGZBJDWatZh2QEsIAlNQSytTK+r3DRfXffi/z/N+H++6oycP
1C6LiB5MpEWUpUc8yIl4nB1xKCviC8bxUF9qtzoz4nRGRK++jh9xjdkmuyW5
3/iFRSxgo/kt582rX6p/8AD/5Jvm3/mFvoL7+a3z3uHECuei0R39/MbsKQ/z
Edk5zGJQX+65td6hQfa1/iIP8RmzArtUdY+70viwZ4bNUtTdZoX6K/Kf9Ovl
pzBkf4onMYGD+u1y25DlmcvyGZyJ5bivT+ctcv/Unzkhex7H1RucfYx3OasY
z2Vy7DrMduqr1F9lvmEKM5jGdbs6mVa+iuzk/Zg0m7Nvd06nvo1n9U0y57iZ
U83y1Sm8lddwglf6D/94fhX/5QKzMu/+TL+fX/FH2Ws8xuVmI1zKH3gvj/I+
HnTPbvcX46w+gXx1Hm7IlNjvMNvDF9zVl/ztuG33hKvlatClrrTv5lr5Ozwg
c4836+9yo329d21Ifm9owSXkyhUlvwGU4L33/g9sD2g2
               "]],
              "0.6`"],
             Annotation[#, 0.6, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0j1I1WEUx/ETNfTe0pSlBoZWQ4FWYENgTVENd2jI1FIq6KL3VuO1Ispo
CCKo8BpJRLQEmdqQkL0MSUveXMRe9ZpCL1q5BVH0+Q9fvs/vnPOc53/Rtc2Z
VNu8iBjA+OKIvQsjVvKxRRH1yyMacBAtauv0ppZETKOIz5hEhfo4T+AjXsif
+MayiA/8XH7Pz7h3aUQfjtp5BFnvDPFDtQHu4f1m3+EtHsj73Ltu1zVsUMu4
k/Y9x7FR76faL8xiSP7BXWZruD2ZtbdgzwH5pf4MD8uvkZLzZjtRrZ4zn7G3
DdvlWrQ6F+wYMVt0fpPckbvQiT/u3OQv3GjPN74if+VD8mE04bt8Sv0CZ/kk
TqDDzqydZb6nHKWYlP+Z+4sp/WnsRB1yOO/eoF6ZvU+5nJ/wGi7FKqxGCS6Z
r7Vvl99y1nnCeY6LXOWt9ajEYLIDjeo18hZswjb0em8rX9brdzdl7hGPebPF
eZb38Aw382Ms0J+PSu/m1X87X+U6vQLv4GHusLvd3lv63birlud08j/ETXq3
udX8HX6lf583y/f4jH7Ot51GGhdxDiuSt5K/MXZj1Dv/AbLGbig=
               "]],
              "0.4`"],
             Annotation[#, 0.4, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0klIlWEUxvFzs6IspaDINoW2MNpIuwYEXRaCFbgoKvI2UFG3VYOpJIIN
oqbZwqmuzdCwaGEUUZvUSs1WUss2Deoqom30exd/nvc85znn/b6PrzR7Zk8u
ExHPcXBpxODyiOniiAG6c1nEOMbQr96xJGJlYcQBuVqZ/XQXPcQr01vovAgZ
FGABSvmfzb+g03SE3rXrHvbp78Uxe0bpGN7hjt5u2U+YwrC6xlxPUUQ3NvKO
msm6tx4b9Hr5X/lvnb/QN/SZudNyT+kpWiK7BkfckVPX08PI4gR/k5k5s/OY
xaj6g9kG2ff0Al0vtw5T6ovqj3QSE6n2DMPI4zZu2TuEJ3IN6nN2nsc381m7
Xzq/St8kfR/9EdTxK7CV993cT9kfaFdfw1W85q+VPetcpdcrX+h8g1am90vv
4Hm65GZpJ52jrXpNeo1YbP6X/ArPd4Wfl9kik6E39TvSHMrVPepudOGfmc38
6/xtdmzHQ/4jXNabsauNTtBJVOtXpe+hn1f/0Stw/k371Med79MM/ctbRVfj
Ma/C3APazL/kzjJ3nqRtaEGxujr9K+nfxIx3+Q9CPGKd
               "]],
              "0.2`"],
             Annotation[#, 0.2, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0s1LlFEYhvFTQVSmLUIhLUhCSKiwFimUFZVltIlQiwlUpIUW5Mqk6duZ
TVRqGtQiKpMWJY3RoqBGKDUpQwvrPxBqXzZJH9DvLC6u85znPs95532ntKX9
8KkFIYQsEsjlhzCPXyhaEsJPHuY5zvCBghCOLA2hlht4P+/DU/0n+j94j3o3
atQFy0Kol9urruMaPmZvtd5f2X/4jWfqKb0/1iXWmZiTv73cnXkhjGMMt9S1
+sVIyXYhIddkZiN61N24jqPxWXHPmUPOfsAk7qoPOr8W1+Su4rgZDbJZe0P6
berH3MpF5haiWf+kupFPxDu51X65M5vNrcAbZ15jjf23PIFRjGMMi9y1Sb5K
thIv8BwL9S6adwkX0IXLeOmec3weZ3AWSaTN3xrfoX4KO9U7kMQK/a96ZWZ+
43L1Rpn1vIH7+SZ60YcbWOwZemU/eb6PmJXrtp+I31Vvhj9jxLof2fg91K94
m3s6nO2z7sEgHiAV9zxPmh+qq+W3Y5XZnc6UcAcX82l+J/seW1AR3x++O3uH
78tkeICDWXP2V3KOp+0/ihn1FXMGuFSuzXodpzmfd8X/Qfz/4Ivf9h/wCGcb

               "]],
              "0"],
             Annotation[#, 0, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0jlMlGEUheELjcwwQ9RYYGLESQiLqAgIWkAQl6DjDhqDS6MmFhoptLAn
glqJdlrYuA1CaChEFAswsUAsEAsbCtcOOysZn794c+45d/n+IeQu9PdcK4mI
aawrjRiviHiZjXhaFrFEm/jt6ORXpSM6UhHNfDttoadkFXq/zP7GTzzn9+vv
wy4zOzEq/4HvaOO7zGTxTL3XXEF92q21dER2SNZBx83/wTLa+T36a1BQ582M
qrvUJ9S76XGadSeDXvUrWQ89w683O8b38av5I+qjyR0cTt7EeXmVuaL3gl+h
E/zJ5LeiFxft52UbcVf/DlLyMkzJ0rQcX8oj5ugiLWQiLrtdp9/Ib8Nr2SQ2
yKfpO0zhLd6g1N0Rb7WZbcVWDNufoPM0zHyiJfSc2bP45la/bMjMICbtV8ob
5Fuwma8230Dv03m9YVrP36O1vrcm+Ru50Ypa/TrUYMbMQTcO4Kbee1mznZDn
aFHWQjfZz6FSfp1/4jse2FnWX6Cf0YgbeldlX9VX6C1zs+qUvSaapo9o3jsP
6T+sYAxF/E3+F+zsUM/hI17gsey229X2L9EP9vvoADKyTnoM3Vjwnf8Bg0Jb
lA==
               "]],
              RowBox[{"-", "0.2`"}]],
             Annotation[#, -0.2, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0UtIFGAUxfFrC51Rs9AyKFpkUEQGQqhkYWkRSTSVRLgwJINehEJFYekq
ehq0UqGFCRpN5MLoZdNOJGkVVGAhLXssWyXSpt+3+HPuOfcx38xs6O5t7ymK
iJfILIvIlUYMLI/ox3WMVUQ8wjbk+a+YRy2/KxNRjFF1XdasuoG+4utpM5/F
ON/IH3X7CEplE7IdsmJ+J33NN9FjfLn+Y34Pn+Fb6Ru+hR7nV+g/4Q/w2XQP
K2V5WZvsmXq3OpfeQA/RfbLVmOQP81PqJd/jOZ0pixgujxhCp1vrZbf0buJk
eredSnkV7sja+W75DL3NF9LvoC7BF7c+I+/WafOb9Wr5rbhiZ1q+Vr4OI3bP
2rkqP0/P4aK5Ar1EL+OvuUU8NRPm87SIrkE1bujtNdeKFgzqD8j68cBnv5D1
qRfU39N78MsbfuMn7pvf4s4sHTH7Xr1R/sN8hXfUqAuyt+iUfbN/gr7jz5gf
tffPzB/ZkN6krE1vk3yBn07/UbqrnsM8f1D/ntt30WfvAn+NPjQ3lebMVKq3
qz+iHqtkXT6nmg7SU5iz9wEd6X9DM3LYj09u/wcmlFnE
               "]],
              RowBox[{"-", "0.4`"}]],
             Annotation[#, -0.4, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0DtI1mEUx/HTEGmmDRKY2RBhg5EOXQbFcilbVPKFVIQMMdx8Bw2aTBcp
G5MuoILXNLCIdyiXxEXITUE3K8FZSDG7vJmf//Dl+5zfOef5X861pxu7jkTE
GMpzIzIFERU8khOxlh8xyut8UV6GhuMRx2RjzpfNHVVXq3MwLrsim3DesDPJ
X7lCXo5GsyncMHNVfZ1rzORh29wMz/E7VOnX6lfyLX5+ImLR+a2ZH/o7WMiL
+IwhvRb39skeoxfNdk7Kas0XoV/2xWzGuZ4bMGLvvrlhbuMV2Sf9FM/zKr/R
m0aHux6gx9xHdTd3ep875i7gn+wAWUzp/ecXvGfnJafd9Yp35VvcK/9m77x8
W12mbk3+Fz/CQ3fPJf83+R+clf1N3sFMk+y77C5vcjNvyfPtDJgZln1Ivo9/
el4p/+Y/mJX/4n0MmR2098Tempnb7lnn02aK8EyvmM/gLEpQaacKu+ZeJ9+E
9+ol9TW+5I6uZM+dhbJ7nnOKB7kdy/pPk29wbkU16nATK3YOAe5WWmg=
               "]],
              RowBox[{"-", "0.6`"}]],
             Annotation[#, -0.6, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0L9L1HEcx/G3oGF6tRSJtJRTWgSKQ8FtpxZ4LmKiQpCRbZ4K6l8g6dTQ
qEIU6dmdqEjQVP6IqKHAyqV0yHNRU2zIZh83PHm+36/P+/Pj+736cKA9UxIR
T9F/JmLzXMR0ecQMzyKLMv1Pfs6vOYeGsxFvzkfU85b+hbVf/JK3+ZZ8p3iG
/jfvooBGew74D/ZxhEPclndVRFwwn1en7a/Up/QXsVoZsYY7uIsWWRU+qT+j
FWm0Ycx5G/zWejt34B6eyWt5JhHxCuvWE+76wHvyEXf2mXmMfn0GvdZKeUX2
HsPmZ82940H5EMqQldXwNW+uxbG+1PxffsRT/M+dk3zC8zwiH8WCfYtYwhV8
lX3BsrpgrluddGYzf9fPyXPI41Lxn8ir+Ju1VPHbuYn/8zA/8dYf6nHe5BbZ
mPomf9TX8Q1cL3637622dhn3vbMXDzAh7+QeJJFGEzbMnQKDuFD1
               "]],
              RowBox[{"-", "0.8`"}]],
             Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}], 
        {RGBColor[1, 0, 0], Dashing[0.01], 
         CircleBox[{0, 0}, 5, {-1.3, 0.4636476090008061}]}, 
        {RGBColor[1, 0, 0], 
         InsetBox["\<\"d/f\[UpperRightArrow]\"\>", {5.5, -2.2}], 
         InsetBox["\<\"d/f=1\"\>", {12, 7.2}], 
         InsetBox["\<\"d/f=.8\"\>", {17, 7.5}], 
         InsetBox["\<\"d/f=-.8\"\>", {2.5, -9}], 
         InsetBox["\<\"d/f=-.6\"\>", {5, -7}], 
         InsetBox["\<\"d/f=-.4\"\>", {7.5, -5}], 
         InsetBox["\<\"d/f=-.2\"\>", {10, -2}], 
         InsetBox["\<\"d/f=0\"\>", {12.5, 0.4}], 
         InsetBox["\<\"d/f=.2\"\>", {13, 2.3}], 
         InsetBox["\<\"d/f=.4\"\>", {14, 4}], 
         InsetBox["\<\"d/f=.6\"\>", {15, 5.7}]}},
       AspectRatio->1,
       Frame->True,
       FrameLabel->{
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Alpha]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Theta]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm]},
       PlotRange->{{0, 20}, {-10, 10}},
       PlotRangeClipping->True,
       PlotRangePadding->{Automatic, Automatic},
       RotateLabel->False], {192., -189.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxtnAuYjtXax8cwjOMYM8Yw50PJIaWi6N3NIykidC4RJYdqoyRSOSSRJDWO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         
         "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0L8rxGEAx/GHjkGXDJIBnZOSJH2d69IlpSQTl0ESZWDiyGGw3W63222G
G6RklRHnVwYLDn+C1zO8+nyf9/f51nX9G+XSTlMIYYuJVAiHLSEcsU+5NYRE
a3DBvfMjD7yTZYADd/dszp0fatSdn3mig6o7M3qwzaQY1U/svN5m07Qzpp/a
Rb3TdtFNop/ZZb3PZsiS08/tuj5khxkhr9fspp7Ee7FR0G/stl60U0wzqd/Z
ij5r5+Jvo6jX7bG+YEssxe/0D1vVV+wqawzq3zT4JO/9L5d8OV/ZW3o891Lx
za4d1/645sX5jdf4nzv/AxpZMQY=
               "]],
              "160"],
             Annotation[#, 160, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVz7kvw3Ecx+GvOBKDq6UaV0pEQ10dTAYiMZgkTAYLYRE1+AeYmZmZmSQq
JCLue2YTR5gkwmLi+Q1PXu9+2ubXNk8tjOUKQgiLpItCyBWHMM8cJ17HSkI4
0nq90KSea50OMetzM0xz6F7ldqBteqtPeqOfOkir/aHvvDHpexO88kKL97OM
26M88kDKrZcRe5h77mhy62HA7o9+M8c0uHXTZ2fZI0+dWxcZO802WyTdOmm2
G9lkg0T0WWrtOOusUe3WQZldyiorxNzaKbT/dFmf/c+l6D9qZfQczfBr71Nh
56Nn65U26aWmNM2P/c0Xu5S77WhCzzSup9Fv1Bqu7X8njzWC
               "]],
              "140"],
             Annotation[#, 140, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0L0vg1EUwOHTaIkwMpgaicVsNptZLSJG4Y8gbISN1EbYCAbxlRhIbYSJ
alHeapksQiM87/Dkd3POcHNv7/j0yFQmIsbozEbc0dUaca/7PPBJiQZl8vYV
PeCJHx6pm3/lImaoOs9qhnnm+GaBRTpYZokmK6zSzRoFfllngzxbbPLHNjv0
s8duepc7D/WIAU45ocX8XC8Y5JIiOfMrvWaIW25oS9+vJYapUKbdPNEaozRI
zOrpe/TZH/RpVY95ZcLuRd9J6LGv6Vn6X0zav+kH/2U4QO4=
               "]],
              "120"],
             Annotation[#, 120, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzyFIg1EUQOErOLUNbaJFhmKRKUOGioyhbbgwGLqk/mXMsKEgGNaGYUmL
aX3dbrfb7SbDQByI4vfC4VxOePe+tazX6M5ERBNPsxF3uYgyf+EbU2zORfT1
Q/MPfvGHLf1ePzbneB4LKOqPXNPzvIgl7OgjbujLvIJVlPQxt/QCr2MDu/oz
X6Rd6V1sp/v0F27rZd7DfrL+yl29ykfpNhzob3yr1/gE9fQf/Z37epNPcYaK
/sED/ZwvkaGqf/JQb3MHV2mPPuEHvcfXuEm79X8ZrSUk
               "]],
              "100"],
             Annotation[#, 100, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzkEoAwAYhuF/NTs7u61cXJy5UCtOczEc7MJO22XbaaK2E8VciJTE0pJG
0srOnDlz5jxFTU4Onh3enr7bly5UFsuJiFhWNxnxMxJxyCoPOOA9v7nPIpv8
4h0/ucM1brPPW36wwRXW+c4O37jBLGt85TVfWGWGFT7zik8scYpFPrLNHguc
5DofeMkb5jnOVXbYYotLHGOOFzznMRc4yiyPeMY9zjPFOe7ylA3O8k8zqtsn
3OI0f4dftWlPpCL+ASh2MLM=
               "]],
              "80"],
             Annotation[#, 80, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzbFKAlAYhuFfUZHIi2jtEmqxqaaCwKZcqilBSRqKBqOhKAqkECFCRCqk
RKKgoa2tob293aGhCJHocTg8fC8/nKm1ynI5EREFL5eKmM5EzLDKWe6lI5r8
YZ7b+hxr9iV/OT++0xd4Yl9xyEUe6Ets2C2OWOCxvsK23eYfV1nXi7y3Owx7
nU1u8Fm/ZtLeZIslvuq3TNlbvGGV73qXGXuHPe7yQ79j1q7xifv81HucsA/5
wiMO9D4n7dPxfzzjl/7AnH3ON17wW3/kP+NFL94=
               "]],
              "60"],
             Annotation[#, 60, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwVzjtLwlEcx+ETRGMQIREiIaL4IpoEM7XyUpqXrqbds0FcokVapCEQGtza
2tra2tp6Vz3/4cPDd/gdTrL3WB8uhBAayi6GMFwK4UH3erf/mOEdb3WjN/uX
aV7zSpea2j9MccC+LjSxv5lkj+c605P9xQ2e8kTHGtmfTPCIXXWiP9kfjLPN
lg41sOdcZ5MNHUTv2TOucZ911aIb+5UxVlnRnqr2C1e5yx2VVbSfucJStLWt
nD3mMgvcUl6b9ohz/gNt/yLU
               "]],
              "40"],
             Annotation[#, 40, "Tooltip"]& ]}, 
           {RGBColor[0, 0, 1], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0EdKA0AUgOEJBLc5g1fKzq0H0F0sEAtoIsQCagQb2MAGlkAsYINEA5pi
EtstLCfwm8XHz/Bm4DG9/YPpgUQIoY9UMoQW3z0hvGqTDj/ObX3WIYbJMMoI
L4wxTpZJJqgzTY4pZsjTYJY5CiwwT5MllllkhSIt1lhnlU024o5ss8MWe+zG
XTngkH2OOaLDKWecUOKcLhdcUuaaK9645Y4bHrjnnSqPVKjxxEd8459+4x3t
8slfnOkX/2uvQKM=
               "]],
              "20"],
             Annotation[#, 20, "Tooltip"]& ]}, {}, {}}}], 
        GraphicsComplexBox[CompressedData["
1:eJxcfQd0VUXXdjrppPeENHovgiByRgQERECaIEiRLlJEQJp0EJWqiDTpTem9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         
         "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0T1IlXEUx/FjQURWdu/VStBBSCjnVCSkxNmGRDAEwYjs7ZaYb4OYhpOD
ZolkCi4lRFOITmJKwxXB3jCdmnMJDUJMh/zc4cf3nO85///z8Dwltx7feJQT
Ea+k+1REYX7EeTlIRkyfjJhJRXTx57izss9P8W/5Tr6Ay5d//AT/hu/gU1xS
9vhxPqF+wj9LRGxyfTjG3z4T8RJ79Rt8D77Qt/Cj2KX/wbfjc30zP4Jt+nV+
/XTEsH40LyLt/u/6bzKVG/HQzh87aWxy7gHel0mzu7htdg8bzVrxjrw2++J8
A/cVB935GavtruGEeY16jr+pn8dfnt3sHf7q38mQsxk7s9yuvt1OBXdFPW53
V31JivTv7RXjU32/rLh/gcvgR1ySRbluZxnrsNbemjvn9b/dt6ru930T2Xsw
Dwey/wUv2E3hVanyPqX2K7HWmVzp4dNymf/A76hH+OPZ74+f+LKCiKNmF/EE
ZsyK1duecUT9H+v1xyTpTAsW4hZfrr4mP9WHdIZWcQ==
               "]],
              "110"],
             Annotation[#, 110, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0EtIlVEUhuGlaJKW98CBkyiwJikoEqTnxJlrIEIXEERBCkIJFSkRzQuC
hQQmSpE6EKGoCMthE41AdCaEXabVKA3Fqfj8g5d3rfXtvc86//mOnpburIhY
xs/SiKclEQtnIib5FU/xD/PdwoiX+pmiiBf8Tf/dfEI+r79bHDHH4/pd8zGe
1XeZP1aPYKkgYoiP5MPcKRvkR1iUDfCh7CG3y/q5L9lH9oAPZL3cJuvh7mRH
2Y5dZrjJvFN9/2zEFm+iyJ012X8uxB1nUu41oED/SbbH+bgpqzevQ57+o+wf
t5ov8kLyv7yd5utowA0041p5xKrz08job/ntP77Vb7T5Dof6I6xgVX/Azd4d
dnYEs849xxXZJfPXZm/wDm/xxPtTeK8+Zb/bZRE5nPHOZ7N73Cj/ghQ2zNK8
Zd+M97Z5zawm+X2u5gmMolpenNTOX1CXqlO4apeLdqrnjPv5GEi+L2rNP5jv
q6fN89x7xuvml89FZMuq+DR/lVWq97yfpT7mFn0uStxp5wr+a16nTuOX+gRa
gVri
               "]],
              "90"],
             Annotation[#, 90, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0T9I1WEUxvEjlJZd6/ovTZcsuJs3TYSGFBwcoiCUEkzh2oVQE7Qpm8pr
FkUI5mT/hFJBXKolXZVaQsIlIpxaIoyEIFKQoM8dvjznPM97zvvy+9VlRzqH
CyJiEa8ORTwqjZjEfTzEA7zkfzkc8RU3SiI+0xE6fSRiXV1bFrHizA6tQX8y
os9cBsf0y7K/tBrXZD38K6jSv5P9oUeRlXXxL6NCX4lylCEju5eIuCgbdncp
L4le/gT/HH+In/Weq5jytrv8j+rr/BJnE+h2fpzf4vwg/yDvALr4OX4zf4D/
nPcCT/AMTzGf35mfR6u+sSKiAfU4hVWkUVwe8d69Y/ZtmblDF/W99Btdogt0
1l3z9DdmfIdRs7dw2+5db8jRHmfn5Oft3HHvTzNbuCD7YXe7vEi/H495U9gz
e9aeS+o1fNLPmn2T/xd4i7SdE8ghLWvACRxHCmfQIptGG1LuOolm97Xlvxtu
8odwmv+av62e5BeaTWCVv0FXaIE8Velb0w+8WvUvbwz1P9qh34ek+Qytot/5
TepWbKr/A6ReVqQ=
               "]],
              "70"],
             Annotation[#, 70, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0c1LlGEUhvEjIQZ+lZaLKEVIN61so46ok5aGZoxjUUaKWW5a+LGINhGU
kKXTTJZam4hqERGYUBC1EtJq19euVVASQf0HQf5mcXGdcz/vOe/zztSOTqTH
CyLiGaZKI3ZXRFRjD26WRJzbHpHhMf4qO8tz+jM8y6P8RT7MN/Sn+ToP8Wf5
IM/oT/A1Psmf5EvFEQPqY0ghjX4syvv4KHpwBL1YkHfzYRxEFw7htryDO9GO
A0hiXp7gFjSiGU24JX9fFvEB9XiHdeTkLe713G9wj1f4e3nEFX7MBZXqbRHL
+oTzEjN3Oessh3V5Sp9GP946f5Lfb+9lc82yJjz1Gzxwjze8YudrrpPXYy+u
2vPI3Cn5b3sH+aF+Sj2JBbvuIIs1z/aZWeUs53Ax/78hgzkM5L9lR8Rxvm/m
BVd67y/3eqn+ydP270Ot8xrUoREJzMuTaFP/cJdL7pD0vmpu5xHeyhc8cx4N
+mXP/VVn5IXmirEq/8ivOPLfvDOiiNdku9R/3PG/s3+c0m9BuflhruIN+X51
K76pNwELgVkg
               "]],
              "50"],
             Annotation[#, 50, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0T1IlWEUwPEniTItNetCDQ1BeP26pgWFYS0OZQ1BSy0RNDbUoqbeoiW1
tKv33j4tK2sqQaylIRHJuxiB1aZRBiItOqj0QQTV7x3+/M85zznPeR/enWcv
nDi/JoQwhVRhCENbQkhuDOERd/BjvqH+kNvlD7iNB7lX/T5flN/jVh7gHvW7
3CK/xXdwG9fVs3wT/cggjWvqKe6LZqN90d3oVt+zOYS92I061KJLPcE1qEQ1
qtCpXs4VKEOz/XHeV6pnawjDm7yhxLuQ0ztTHMIkt8njRfbyOnvXIyGeddZk
9igOY8L8EX5i7imey6vc+4w/cqOzA1yPF2bfy6ejeXcVur9PvR8pVMgznEUa
lfJFdy7hCz4jbm6Ov2LOjpP6TqHTnVfRLn7rfZ/sGhZPiVNmVrCMhPdf0vfT
bJJ/8WWe5GOc47S+DLI4Z88Gb8+P/o+83DeN6nujr4N/cKs937mFq/X9tvul
+LX+UR7jQWzzLaXOY/wO3/T1uC+BYnsKsKI27myV682knR3kBsz79qSeK9iB
Q9G/4zP4oL+Gm/Xv51qM6F+S9+pba74AE+rT/Ir/mdkV83/15dS2ixd9719n
f/i4PA9F5k9zjBfU68QNmBX/B+4Bcgk=
               "]],
              "30"],
             Annotation[#, 30, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0UtszFEUx/FbNZi+W/UWSZWEqMSqFpXQeKSdYCEem1JGohtRlNFWH1RJ
ULFgWUlFUDR2NkxH0pVHJ7azkRDEo+JRLDTa+Mzim+89v3vOuf9OK+LNO47k
hBDeYG9hCEP5IUTKQ/haFsKp2SEkMF39QJ7LY/KTshOYpr4v78CAc4P5VFEI
w+iR9eo5j7M4h57sWd7NZ9CBLnRma3k7n0YrjheE0Mbd8qWlIRxTV/BRnuEb
9ntrljcbOea9tHM9Lynxvplb6oXqZajEQ9lNWbP5PSi1azeX8XVcQ6+elXr6
7VzBNzhdHMIoUu5a7E7KcrO/CSJYbnef3oz7Tuc65NtVgJj9683Uc1Sdh0n1
FGpl4+Y38C7eiTq7f/KgLM/Og+oox/mKbzjAW/ztKd7Ew7yZn3rzsbkX5ga9
8ZLv8UbZXX6uvs3P+A7PNFdibxMX8yG+bP82/Vsx4fv+yi7YnXGetD9pdq7z
Ex6w45+sWs9H57U87u4XfuO1u5g99fij/qznE/rl7/kDvsm/o8q+Jm+v4hpe
hzbvtiKBpJ5F+g/bFdezwLmR0zwPEW+PZnf6/S/aX4UiO6L4IUu6S+GqvFbW
xzV2vrWjXd2FxWhFAvvwytxqbtE7pq/aeYjH1Jey/3/zUaTkaX7EU2Yq5/ge
fSOy+c5f/LaT7iZ4uzoHheYbuJzfydc41yDj/B+1pXsl
               "]],
              "10"],
             Annotation[#, 10, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV02loD3Acx/Gf0ubYZjNXc1/JwlxzLGoe2QNzbBpZFEWOoTYjRKIMyTPK
Awkb4pHSDnPfkyNXCnNMYXtAOcZyvn4PPnt/j8/3+/v9f///Bi5ZW7CmXQgh
w5+81BDOpISwNCmEwuQQLnYLoQArO4dQSofkc+XL9VvTQ/hB36lIrUp/HfVJ
C6EvzbJrNv3V/0e/6A/9pmDPet5CZ03jyaWH8o3yVXZ3MZ+PyTgDU/AoJuon
UF/+R/z9xCXqpXauxjIcwLscZ8prnLOCdyX15z0uf2IuU/4YN6nNEXfEBr0O
uKdLCC/0Tstv+VxL1ZbROfFVtXqso4Fqd+QD8GTcRYflneTF+g10TX4b6/Wq
3adOXoOZlK9+QT4TR9MHd87Cj/G97HhNW83d6xrCXUrkTaBFPBNxEo2nCZRN
5/lrzNZSNd2M5+FgrPQmN/AoXsdj+APf6v/EJhyNGd4iC6vtm2Jfq/ga71U6
xXNCXqt3gu+Tu/VW60OplEbv1G5iE24z3+iuo+LnivvjvLcd7rPst+8Alcfv
AavsvGzmifhpzM1lqlXiYzPzzc6jzWpFWEE7qcx9duFuGmpuSNxr/14zY/Ta
7P9JO9S2x3PdqRy/xndWn24uj3qKe1GOfr3+ZDzorDp3arRzJP9LfE2v6Ijd
q5xREn8rvM9prXiYerN9LfEt+LLNvcdMXKM/Pv6ecBzm4Bf+hWYzeBZgodpi
tQfyBJ4e2B53xd+UXgWOjf8rPOnyZDol/+yel3i/qe/jyVWfSm/id4uNuAV7
0wYqp4V039wILDXTwpMtPo0t8t3OTbX7m3e4oH5XfBb/mBnU3b34rqj1FDfz
/NZrw3x5oCTzxZiOTepZ4hx6Jv4PfW6i1w==
               "]],
              RowBox[{"-", "10"}]],
             Annotation[#, -10, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0klsTWEYxvGvpo26rZpCUlJjmzZNOiW6stAYwqYlQSMi2CA60BBrFBHz
zIbQ3t6IGBLUECpmooZom6LVGiJFI4iYNn5n8b/P9z7v8L3n3JOxpLKsIimE
MNxP9cAQzsZCeJQWwkM8QOmgEBbxTshVYdWQECrwWq4DnVjDr+QtTw7hjbgL
f8R/8RvzzOjLWyFfJa7GmMEhjEY//rihIYzHWEzEBJTr6S+3gCaJ4+5Yjxze
Ht59upcWyDXSfHqJbrPrJ3UFqSEUIl/cqDaPXqZfU0LYioNyB7Afd/Utk7+i
77CdjuAQDmKl/Al7n7dzEz1Hb9DjcidpgziB3eIGO+yiCdpmVrdzK41Hz2Z+
jlnZKNFXgYTcHHEZUtXOpG1ojWL5B/bcrHcLajHSjK20Tq7TuYVej/aKdsIt
8SAaQwqeoBld7pmu75nnnEaf03qz6zDJO8mM3qn76/WvdvdZ5zv63ovT6WjM
1fdSX6ZzFn7obRfv4xfZZS8tpGfctQGtatrQgm/mfKbF6r+YPZlecs9FXMBV
3hUU2uOFuePVd/O7UMWrjP5rs/dhkt6XajPpK/pH7W16D3fRi6lm3LTDOv1r
EVdbZEY9bZGbZpeP/O/iGv4xM3boi/N30k9yPcjkv3ZnFu0Vf0aunq7oG+Ef
xSzxW/FsGszKohvdsQnLsBSrUBx9c3YqpQv19VE313mx2c36T/M6zB/AK8d8
1PLyeE/VpImTkRC32/MU/cHfruYnnSL3Jnpv9B1GRd+OmhG0JroTj92fTav1
9KjtoR9wnrfFPinRTP/jNfEj55ia2LAQMpCGJt5w+k/+F36rnS1O1zuDzkMJ
uvm5tBitzv8BbxinFQ==
               "]],
              RowBox[{"-", "30"}]],
             Annotation[#, -30, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0ttPz3Ecx/EP5sIoSmXGTDnOYWNDXRmKRiGHHObGZA4XIrowpxvHP8Ah
LtiM2CqhUEJs1QxDOeTYbIxsKjJl5vT4Xjx7vd/vz+v9/rw/v77JazYvzu8R
QhjpT+aAEC7EhpDXL4Si/iGspeXynJgQLtN18hPq62mFPFf9gLxSfAU75Ndo
U0IIV+lBZ1W0GlmowXUcUp/jru19QzjJu0httjwDK8yojw9hoVodzaENNIbu
4Y2lH+WfkCteiqPqaXTKwBCmYlqkZg2zZ5o4FUU8x9BTXIJSJCIBrfZot9Nn
OkiehJm8M7DQjCd2KhN/d17P14BE9/22wx/8RXf0bt4avTdxA7fkfWk/vNX7
nr6hWWZlYx4WYD4Ou2MMPUL/mRd4f0a/qxn71QeJ99Ikuo/etcMPs1L4kpET
7Yrleivkd/RdoZW46Le4hC7+Tn1j1EZjFJrdt0TfTnN34Yu+y3EhtEX/YzqR
p784Tn88UnmO8E+jZebtRiNPEx7jKZ4gLrpffwetpO10g571KJc3y4vNqxKX
mtdmTrV4BAYiAcej74Evz5ve2LNKXo3H3nBKPkn9NC1U2yQ+Y06tOfniWTzb
5IXYKv/G16TWiNn2y4jeHt0XfW80hZ7jO4+zGGLPYvqcvxlfnRfIt5pXgHh7
dUS70slmtYtf2uOv/F70Jv4v8jKaqm88fW3OBLqR9uJJ510nDuJ/vLfdOdf5
anrJO7LVsrA48qivUu9BS+kr9RKaZEaLuDfPSjySl9KHNIm+ir5Bep7nRfT9
oQ6/zU9Wn44Wng+0wuzB9ADvA+d9EkO4T8eqjcMW97XyttIP0Y5qB/XE8nf6
TWrk98QxPDF6hyMOtWqJ9JfzLnTzZsmH6s2ky5COd+oTaRqeif8DD8yruA==

               "]],
              RowBox[{"-", "50"}]],
             Annotation[#, -50, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0ldsz2EUxvHXSppozTYRRVs1YiRiJELNmjGKinlhNHZVjRsjRiLmtVU1
U25KawaRELsUUVVCjBKJVXslFPH5XXz7vOd5n3Pe8/unKVm5mQtqhBC6+TO5
cQgxDUO4Fh/C77gQltMM3ihsrx9CU/VSflKjEJbRZFqnXghb6AZsRHWDEEbL
94wNIU9Pop5mSHGXipbYik3YjD/yY+TT5PPld2E3apg7kz8Ls7GGN1RmD38v
RmA3evM+u+9Dx9JMfMB7DOdd8D0Xcdc75biHFna/yyvDM7nnqMRTVLi/j3l2
zkYXXlc0N+uKHdrbuQPK9SaZUyk7S50juwBpsr2QLL9XPon2VPfAG/n5Mud4
ubRK3TvaHX0Rb1Y67Y9+0Te4z/ONifIL5T+qs731KZpDV9F59AOdTediDv7p
KdV/EzdwG7cw1pzs6DeiZeYd8w3X1SW4XzeEAbyBSMcdMwfR1TSFrqFvzH6L
d1ghP8E7FfzD9k41oxW++OYj6mIUIVPvGEzUU+T+CIpxwF0BqswJet7TpvyD
vEP2KsQ4e07R99Abx/kncBKl8jeRx89RL8QiPLfPRTMe6DusvxhFKFHvcL8T
+TjNO4UX3pxm/nRMxWPzsugeesf8fXSX3H7aiX/GnK60QP3SnC7OnbEErd29
8nZrd4/0tIlmmTEdbaI7+cHO1c4JztvsmibTTT2M/5cupkui/3MMwVX7zaEr
5VdgpPMhPaNpBtL11PTWJbO+e3ulei1/qjrObz5TtoA/g47n16Jf5b/hiXlf
aLyeQvkEWlumEDEojt7C7WjfqBePnCcl6KWPzb2Majsmu2uJ4+Y3oevM3oQY
2VL3bXntkOud13pf05c4yluvJy7axb5n1TecY2Vi9SahAc7z4ukv9z/wU3aY
OlHvYDoO6ajkd6TdUeH8HzP1sbE=
               "]],
              RowBox[{"-", "70"}]],
             Annotation[#, -70, "Tooltip"]& ]}, 
           {RGBColor[0.6, 0.4, 0.2], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0l1oz1Ecx/GzUcqGzYh52iZXhGwliSR78FRDNsxmtnlOcyUXhohS7ihk
HraRuECYC0weIkSooaGG2X/igpVhmw2v38V77/M93+/5nOPnn1G+ZUllXAgh
y58lA0M4NiSEaqxMCaEYuYkhjEwKIY9XqUvQMyCEKjMHB4fwKzmEHHUHZ/NP
zufj+nPklZpfjTKMkrOGK1COXnM7zB2S0+1crvo3d6ETcfazZTwxk8N/9QM/
VP+znuFNz63/mn0W7fEf9KIH8c7nmn+ql8fx6ItH6j48y/ndg0LYgzx537zp
O1qc+4izCSFsRan51ViFcpTho/k1vBYVaFEPl1cUfTusQAmKsV1vNI/BJ7mt
iGGb7PX2WvXXcYw3RDO8Vv9zdAe38Ub7qfKPePd79RX1CPVJb69S31bv4EL9
L1yvztBP8c3H8jX1V/tH9T/wVfUo+zXOp1mnY5N/+2J7G3kRz7U3D2nqdHR4
70Pztd5UhxqcwWnUm7/BWfJPubMGtWg3n+rscNSpX0RvNLc0utvsK/UDd7zm
w9E3tFenbnBXl3VjlKt+yfeQJC8ZO6PvYGaadTMXyVyJFShBMY7Im8hHebO7
K7EF3c7+QbX9O7KPcZyc33Iuqtvds0u/wLoQ4719Ajr1n5mbJLPa7+sEDsh7
za36sei3o25FDFPkNullcgYaou/M49DtjpvqHs7CPLmZPF0vxzob9923IPr/
lbWQ3+IN/pnL5zjZd71zvjM/3F1lv5Z38kDZddaJnIAC88sw0+w7eTO43flh
ZlPV5/TOox/26V3gp3pDOB5N1suHOstv5d5Dt/el6V02X6RXz/15v7x+/Fh/
r/VkMzHnKr21jdu4BZfsX0W7913nR2YT9BOcHYNBuGUvhTv1O/Az+k2qR0Tf
iZdiNprtT+CpaLT+D13wtZw=
               "]],
              RowBox[{"-", "90"}]],
             Annotation[#, -90, "Tooltip"]& ]}, {}, {}}}], 
        GraphicsComplexBox[CompressedData["
1:eJxcXQVcVUsTp7u7W0BEEFFsd+3u7u7CLmyfXc/OZ3d3e66N3WCBdHc3H8yc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         
         "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0ctLlAEUhvHjgHjLstFRo8SkbBHhRon8B9q5EQQJIjSYzIWJprYpaHaF
lotMxXbmMgjxAhVltrQWbSwrjKILRBpGUtmm37d4eM55z/nOfDNT13mhtScv
Iu5hBlW7IvahGk2FERmeK42o5I6SiAouR6PZXXla/UZ9xmyN9+qn5UPFEa/1
H/kV51IRi/Kz9lb1ZfauF0V85k/olBdzET6g3c4Rz16zM8A/sIlCe81mQ7sj
LqHCzUU7GZ7jcl7gNM9zyjN5GLQ7q38qX0a3Gxvy87ykf+DuhPqlepwPeIca
5OTr+v3qHW7gf5x2bzP5vrzBJ906xVn7X33OMH/h0+7VqfvMbtoZRZl+D77L
xuw8cuMWH3X7m+yy2RWcUx+TZbnSThUyyLdbzTfkK+7Xqw+j2e1VpMzneQd/
MWy2Lmuz+55H9Af5ENfyRXfe2evn+7Kfsi38wRP9b84lv5N6imd5kkvkLZ67
410fJ/9N8nurC/ih/hmWcdv+L1mvz9/mfl7hE/yCG/k5H+er7tYk74Ue370P
vUibZ7kLbXhrvob/GuZcpA==
               "]],
              "1"],
             Annotation[#, 1, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0s1LlGEUxuHTRi1nxlwFUSPjB7QxSAotody5aRVCtCgiCD8iByWK2jRW
oGAZLVIo3NQ/kAklQaDRotQWheFUWlC72oS2yOjrehY/7nPOfT9nnvedt3Cq
eKR/U0TMYDIb8a864lVVxDG6SD9mIj6hmIvox5XNES/pPF5glXdSdkH2Lx3i
r5h9wAn9H/zGsr5LprAloiRT1r/HO5w3a+Hl1DWoRhYZ7DGvpNPuVkWP2/XW
rEJ9z6xD/0X9GU32fMcS/xwd8TuNtAGVctP6QXWtcwP0G47KHuIdxFbzYZkc
rUEGU/osbZML+Qf6IdmruIavZj28krpTPa6+RW/T7e60Si/yVmiTPc+cH9Xf
QA6z6Y7mc7RAG1CPMTvanRml17GOtXRns2Z7N+hl53/S3ebNOGBeYc+4+Zj6
uT0X+DfTO6b1/q+d/Ev6PH3szCMM86Zol/xDWsYyWtGGXbJ9vDPoRi960Jie
w9nXMm9Qp89jm/wvbOCH+R2Zw/QubxJP1bO4z39C+8xm6Fx6b+44gaL9g+l/
wrxcK92PFuzDXpTs3SGbx1nPNJC+U9TKn6bd6ZtL3xm/jP9VAGNq
               "]],
              "0.8`"],
             Annotation[#, 0.8, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0jtIlmEYh/E7VPIYQi1BQwW6VGAuEVQQZkNSWkIGNUjlIJhlDX2VeQhK
LILwgEMt1tASRGZBJDWatZh2QEsIAlNQSytTK+r3DRfXffi/z/N+H++6oycP
1C6LiB5MpEWUpUc8yIl4nB1xKCviC8bxUF9qtzoz4nRGRK++jh9xjdkmuyW5
3/iFRSxgo/kt582rX6p/8AD/5Jvm3/mFvoL7+a3z3uHECuei0R39/MbsKQ/z
Edk5zGJQX+65td6hQfa1/iIP8RmzArtUdY+70viwZ4bNUtTdZoX6K/Kf9Ovl
pzBkf4onMYGD+u1y25DlmcvyGZyJ5bivT+ctcv/Unzkhex7H1RucfYx3OasY
z2Vy7DrMduqr1F9lvmEKM5jGdbs6mVa+iuzk/Zg0m7Nvd06nvo1n9U0y57iZ
U83y1Sm8lddwglf6D/94fhX/5QKzMu/+TL+fX/FH2Ws8xuVmI1zKH3gvj/I+
HnTPbvcX46w+gXx1Hm7IlNjvMNvDF9zVl/ztuG33hKvlatClrrTv5lr5Ozwg
c4836+9yo329d21Ifm9owSXkyhUlvwGU4L33/g9sD2g2
               "]],
              "0.6`"],
             Annotation[#, 0.6, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0j1I1WEUx/ETNfTe0pSlBoZWQ4FWYENgTVENd2jI1FIq6KL3VuO1Ispo
CCKo8BpJRLQEmdqQkL0MSUveXMRe9ZpCL1q5BVH0+Q9fvs/vnPOc53/Rtc2Z
VNu8iBjA+OKIvQsjVvKxRRH1yyMacBAtauv0ppZETKOIz5hEhfo4T+AjXsif
+MayiA/8XH7Pz7h3aUQfjtp5BFnvDPFDtQHu4f1m3+EtHsj73Ltu1zVsUMu4
k/Y9x7FR76faL8xiSP7BXWZruD2ZtbdgzwH5pf4MD8uvkZLzZjtRrZ4zn7G3
DdvlWrQ6F+wYMVt0fpPckbvQiT/u3OQv3GjPN74if+VD8mE04bt8Sv0CZ/kk
TqDDzqydZb6nHKWYlP+Z+4sp/WnsRB1yOO/eoF6ZvU+5nJ/wGi7FKqxGCS6Z
r7Vvl99y1nnCeY6LXOWt9ajEYLIDjeo18hZswjb0em8rX9brdzdl7hGPebPF
eZb38Aw382Ms0J+PSu/m1X87X+U6vQLv4GHusLvd3lv63birlud08j/ETXq3
udX8HX6lf583y/f4jH7Ot51GGhdxDiuSt5K/MXZj1Dv/AbLGbig=
               "]],
              "0.4`"],
             Annotation[#, 0.4, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0klIlWEUxvFzs6IspaDINoW2MNpIuwYEXRaCFbgoKvI2UFG3VYOpJIIN
oqbZwqmuzdCwaGEUUZvUSs1WUss2Deoqom30exd/nvc85znn/b6PrzR7Zk8u
ExHPcXBpxODyiOniiAG6c1nEOMbQr96xJGJlYcQBuVqZ/XQXPcQr01vovAgZ
FGABSvmfzb+g03SE3rXrHvbp78Uxe0bpGN7hjt5u2U+YwrC6xlxPUUQ3NvKO
msm6tx4b9Hr5X/lvnb/QN/SZudNyT+kpWiK7BkfckVPX08PI4gR/k5k5s/OY
xaj6g9kG2ff0Al0vtw5T6ovqj3QSE6n2DMPI4zZu2TuEJ3IN6nN2nsc381m7
Xzq/St8kfR/9EdTxK7CV993cT9kfaFdfw1W85q+VPetcpdcrX+h8g1am90vv
4Hm65GZpJ52jrXpNeo1YbP6X/ArPd4Wfl9kik6E39TvSHMrVPepudOGfmc38
6/xtdmzHQ/4jXNabsauNTtBJVOtXpe+hn1f/0Stw/k371Med79MM/ctbRVfj
Ma/C3APazL/kzjJ3nqRtaEGxujr9K+nfxIx3+Q9CPGKd
               "]],
              "0.2`"],
             Annotation[#, 0.2, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0s1LlFEYhvFTQVSmLUIhLUhCSKiwFimUFZVltIlQiwlUpIUW5Mqk6duZ
TVRqGtQiKpMWJY3RoqBGKDUpQwvrPxBqXzZJH9DvLC6u85znPs95532ntKX9
8KkFIYQsEsjlhzCPXyhaEsJPHuY5zvCBghCOLA2hlht4P+/DU/0n+j94j3o3
atQFy0Kol9urruMaPmZvtd5f2X/4jWfqKb0/1iXWmZiTv73cnXkhjGMMt9S1
+sVIyXYhIddkZiN61N24jqPxWXHPmUPOfsAk7qoPOr8W1+Su4rgZDbJZe0P6
berH3MpF5haiWf+kupFPxDu51X65M5vNrcAbZ15jjf23PIFRjGMMi9y1Sb5K
thIv8BwL9S6adwkX0IXLeOmec3weZ3AWSaTN3xrfoX4KO9U7kMQK/a96ZWZ+
43L1Rpn1vIH7+SZ60YcbWOwZemU/eb6PmJXrtp+I31Vvhj9jxLof2fg91K94
m3s6nO2z7sEgHiAV9zxPmh+qq+W3Y5XZnc6UcAcX82l+J/seW1AR3x++O3uH
78tkeICDWXP2V3KOp+0/ihn1FXMGuFSuzXodpzmfd8X/Qfz/4Ivf9h/wCGcb

               "]],
              "0"],
             Annotation[#, 0, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0jlMlGEUheELjcwwQ9RYYGLESQiLqAgIWkAQl6DjDhqDS6MmFhoptLAn
glqJdlrYuA1CaChEFAswsUAsEAsbCtcOOysZn794c+45d/n+IeQu9PdcK4mI
aawrjRiviHiZjXhaFrFEm/jt6ORXpSM6UhHNfDttoadkFXq/zP7GTzzn9+vv
wy4zOzEq/4HvaOO7zGTxTL3XXEF92q21dER2SNZBx83/wTLa+T36a1BQ582M
qrvUJ9S76XGadSeDXvUrWQ89w683O8b38av5I+qjyR0cTt7EeXmVuaL3gl+h
E/zJ5LeiFxft52UbcVf/DlLyMkzJ0rQcX8oj5ugiLWQiLrtdp9/Ib8Nr2SQ2
yKfpO0zhLd6g1N0Rb7WZbcVWDNufoPM0zHyiJfSc2bP45la/bMjMICbtV8ob
5Fuwma8230Dv03m9YVrP36O1vrcm+Ru50Ypa/TrUYMbMQTcO4Kbee1mznZDn
aFHWQjfZz6FSfp1/4jse2FnWX6Cf0YgbeldlX9VX6C1zs+qUvSaapo9o3jsP
6T+sYAxF/E3+F+zsUM/hI17gsey229X2L9EP9vvoADKyTnoM3Vjwnf8Bg0Jb
lA==
               "]],
              RowBox[{"-", "0.2`"}]],
             Annotation[#, -0.2, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0UtIFGAUxfFrC51Rs9AyKFpkUEQGQqhkYWkRSTSVRLgwJINehEJFYekq
ehq0UqGFCRpN5MLoZdNOJGkVVGAhLXssWyXSpt+3+HPuOfcx38xs6O5t7ymK
iJfILIvIlUYMLI/ox3WMVUQ8wjbk+a+YRy2/KxNRjFF1XdasuoG+4utpM5/F
ON/IH3X7CEplE7IdsmJ+J33NN9FjfLn+Y34Pn+Fb6Ru+hR7nV+g/4Q/w2XQP
K2V5WZvsmXq3OpfeQA/RfbLVmOQP81PqJd/jOZ0pixgujxhCp1vrZbf0buJk
eredSnkV7sja+W75DL3NF9LvoC7BF7c+I+/WafOb9Wr5rbhiZ1q+Vr4OI3bP
2rkqP0/P4aK5Ar1EL+OvuUU8NRPm87SIrkE1bujtNdeKFgzqD8j68cBnv5D1
qRfU39N78MsbfuMn7pvf4s4sHTH7Xr1R/sN8hXfUqAuyt+iUfbN/gr7jz5gf
tffPzB/ZkN6krE1vk3yBn07/UbqrnsM8f1D/ntt30WfvAn+NPjQ3lebMVKq3
qz+iHqtkXT6nmg7SU5iz9wEd6X9DM3LYj09u/wcmlFnE
               "]],
              RowBox[{"-", "0.4`"}]],
             Annotation[#, -0.4, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0DtI1mEUx/HTEGmmDRKY2RBhg5EOXQbFcilbVPKFVIQMMdx8Bw2aTBcp
G5MuoILXNLCIdyiXxEXITUE3K8FZSDG7vJmf//Dl+5zfOef5X861pxu7jkTE
GMpzIzIFERU8khOxlh8xyut8UV6GhuMRx2RjzpfNHVVXq3MwLrsim3DesDPJ
X7lCXo5GsyncMHNVfZ1rzORh29wMz/E7VOnX6lfyLX5+ImLR+a2ZH/o7WMiL
+IwhvRb39skeoxfNdk7Kas0XoV/2xWzGuZ4bMGLvvrlhbuMV2Sf9FM/zKr/R
m0aHux6gx9xHdTd3ep875i7gn+wAWUzp/ecXvGfnJafd9Yp35VvcK/9m77x8
W12mbk3+Fz/CQ3fPJf83+R+clf1N3sFMk+y77C5vcjNvyfPtDJgZln1Ivo9/
el4p/+Y/mJX/4n0MmR2098Tempnb7lnn02aK8EyvmM/gLEpQaacKu+ZeJ9+E
9+ol9TW+5I6uZM+dhbJ7nnOKB7kdy/pPk29wbkU16nATK3YOAe5WWmg=
               "]],
              RowBox[{"-", "0.6`"}]],
             Annotation[#, -0.6, "Tooltip"]& ]}, 
           {RGBColor[1, 0, 0], 
            TagBox[
             TooltipBox[LineBox[CompressedData["
1:eJwV0L9L1HEcx/G3oGF6tRSJtJRTWgSKQ8FtpxZ4LmKiQpCRbZ4K6l8g6dTQ
qEIU6dmdqEjQVP6IqKHAyqV0yHNRU2zIZh83PHm+36/P+/Pj+736cKA9UxIR
T9F/JmLzXMR0ecQMzyKLMv1Pfs6vOYeGsxFvzkfU85b+hbVf/JK3+ZZ8p3iG
/jfvooBGew74D/ZxhEPclndVRFwwn1en7a/Up/QXsVoZsYY7uIsWWRU+qT+j
FWm0Ycx5G/zWejt34B6eyWt5JhHxCuvWE+76wHvyEXf2mXmMfn0GvdZKeUX2
HsPmZ82940H5EMqQldXwNW+uxbG+1PxffsRT/M+dk3zC8zwiH8WCfYtYwhV8
lX3BsrpgrluddGYzf9fPyXPI41Lxn8ir+Ju1VPHbuYn/8zA/8dYf6nHe5BbZ
mPomf9TX8Q1cL3637622dhn3vbMXDzAh7+QeJJFGEzbMnQKDuFD1
               "]],
              RowBox[{"-", "0.8`"}]],
             Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}]},
       AspectRatio->1,
       Frame->True,
       FrameLabel->{
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Alpha]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm], 
         FormBox[
         "\"\\!\\(\\*FractionBox[\\(d\[Theta]\\), \
\\(dt\\)]\\)\[Degree]/sec\"", TraditionalForm]},
       PlotRange->{{0.01, 20}, {-10, 10}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]},
       RotateLabel->False], {576., -189.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
   ImageSize->{478., Automatic},
   PlotRangePadding->{6, 5}], TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "The eye parameters ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 ", etc. are described in the Demonstration \"",
 "Eye Parameters (Visual Depth Perception 6)\" in the Related Links."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Motion, Pursuit, Fixate, and Distractor (Visual Depth Perception \
2)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitFixateAndDistractorVisualDepthPerception2/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionPursuitFixateAndDistractorVisualDepthPerception2/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
MotionPursuitFixateAndDistractorVisualDepthPerception2/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitFixateAndDistractorVisualDepthPerception2/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionPursuitFixateAndDistractorVisualDepthPerception2/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
MotionPursuitFixateAndDistractorVisualDepthPerception2"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Motion, Pursuit, Fixate, and Distractor (Visual Depth \
Perception 2) - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[671, 24, 195, 5, 70, "Section"],
Cell[869, 31, 3700, 64, 70, "Section"],
Cell[4572, 97, 1321, 37, 70, "Input",
 InitializationCell->True,
 CellID->347766915],
Cell[5896, 136, 7750, 213, 70, "Input",
 InitializationCell->True,
 CellID->405405697],
Cell[13649, 351, 11444, 224, 70, "Input",
 CellID->1118830646]
}, Open  ]],
Cell[CellGroupData[{
Cell[25130, 580, 110858, 1898, 70, "Output",
 CellID->322716303],
Cell[CellGroupData[{
Cell[136013, 2482, 209, 6, 70, "Section"],
Cell[136225, 2490, 1214, 32, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[137487, 2528, 209, 6, 70, "Section"],
Cell[137699, 2536, 731, 17, 70, "Text"],
Cell[138433, 2555, 1937, 38, 70, "Text"],
Cell[140373, 2595, 224, 8, 70, "Text"],
Cell[140600, 2605, 296, 8, 70, "Text"],
Cell[140899, 2615, 328, 12, 70, "Text"],
Cell[141230, 2629, 451, 17, 70, "Text"],
Cell[141684, 2648, 583, 17, 70, "Text"],
Cell[142270, 2667, 106546, 1826, 70, "Text"],
Cell[248819, 4495, 221278, 3772, 70, "Text"],
Cell[470100, 8269, 376, 12, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[470512, 8286, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[470870, 8297, 1134, 32, 70, "Text"],
Cell[472007, 8331, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[472487, 8350, 815, 24, 70, "Text"],
Cell[473305, 8376, 1226, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature @RjfOgzj5dwavC0vpSP76uZN *)
